/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.xmpp.extensions.coin;

import org.jitsi.xmpp.extensions.DefaultPacketExtensionProvider;
import org.jitsi.xmpp.extensions.coin.CallInfoPacketExtension;
import org.jitsi.xmpp.extensions.coin.CoinIQProvider;
import org.jitsi.xmpp.extensions.coin.DisconnectionType;
import org.jitsi.xmpp.extensions.coin.EndpointPacketExtension;
import org.jitsi.xmpp.extensions.coin.EndpointStatusType;
import org.jitsi.xmpp.extensions.coin.JoiningType;
import org.jitsi.xmpp.extensions.coin.MediaProvider;
import org.jitsi.xmpp.extensions.coin.StateType;
import org.jivesoftware.smack.packet.ExtensionElement;
import org.jivesoftware.smack.provider.ExtensionElementProvider;
import org.xmlpull.v1.XmlPullParser;

public class EndpointProvider
extends ExtensionElementProvider {
    public ExtensionElement parse(XmlPullParser parser, int depth) throws Exception {
        boolean done = false;
        String elementName = null;
        String entity = parser.getAttributeValue("", "entity");
        StateType state = StateType.full;
        String stateStr = parser.getAttributeValue("", "state");
        if (stateStr != null) {
            state = StateType.parseString(stateStr);
        }
        EndpointPacketExtension ext = new EndpointPacketExtension(entity);
        ext.setAttribute("state", (Object)state);
        while (!done) {
            int eventType = parser.next();
            elementName = parser.getName();
            if (eventType == 2) {
                ExtensionElement childExtension;
                ExtensionElementProvider provider;
                if (elementName.equals("display-text")) {
                    ext.setDisplayText(CoinIQProvider.parseText(parser));
                    continue;
                }
                if (elementName.equals("disconnection-method")) {
                    ext.setDisconnectionType(DisconnectionType.parseString(parser.getText()));
                    continue;
                }
                if (elementName.equals("joining-method")) {
                    ext.setJoiningType(JoiningType.parseString(CoinIQProvider.parseText(parser)));
                    continue;
                }
                if (elementName.equals("status")) {
                    ext.setStatus(EndpointStatusType.parseString(CoinIQProvider.parseText(parser)));
                    continue;
                }
                if (elementName.equals("call-info")) {
                    provider = new DefaultPacketExtensionProvider<CallInfoPacketExtension>(CallInfoPacketExtension.class);
                    childExtension = (ExtensionElement)provider.parse(parser);
                    ext.addChildExtension(childExtension);
                    continue;
                }
                if (!elementName.equals("media")) continue;
                provider = new MediaProvider();
                childExtension = (ExtensionElement)provider.parse(parser);
                ext.addChildExtension(childExtension);
                continue;
            }
            if (eventType != 3 || !parser.getName().equals("endpoint")) continue;
            done = true;
        }
        return ext;
    }
}

