/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.xmpp.extensions.jingle;

import java.util.List;
import org.jitsi.xmpp.extensions.AbstractPacketExtension;
import org.jitsi.xmpp.extensions.DefaultPacketExtensionProvider;
import org.jitsi.xmpp.extensions.jingle.ContentPacketExtension;
import org.xmlpull.v1.XmlPullParser;

public class GroupPacketExtension
extends AbstractPacketExtension {
    public static final String ELEMENT_NAME = "group";
    public static final String NAMESPACE = "urn:xmpp:jingle:apps:grouping:0";
    public static final String SEMANTICS_ATTR_NAME = "semantics";
    public static final String SEMANTICS_BUNDLE = "BUNDLE";

    public GroupPacketExtension() {
        super(NAMESPACE, ELEMENT_NAME);
    }

    public static GroupPacketExtension createBundleGroup(List<ContentPacketExtension> contents) {
        GroupPacketExtension group = new GroupPacketExtension();
        group.setSemantics(SEMANTICS_BUNDLE);
        group.addContents(contents);
        return group;
    }

    public String getSemantics() {
        return this.getAttributeAsString(SEMANTICS_ATTR_NAME);
    }

    public void setSemantics(String semantics) {
        this.setAttribute(SEMANTICS_ATTR_NAME, semantics);
    }

    public List<ContentPacketExtension> getContents() {
        return this.getChildExtensionsOfType(ContentPacketExtension.class);
    }

    public void addContents(List<ContentPacketExtension> contents) {
        for (ContentPacketExtension content : contents) {
            ContentPacketExtension copy = new ContentPacketExtension();
            copy.setName(content.getName());
            this.addChildExtension(copy);
        }
    }

    public static GroupPacketExtension parseExtension(XmlPullParser parser) throws Exception {
        GroupPacketExtension group = new GroupPacketExtension();
        String semantics = parser.getAttributeValue("", SEMANTICS_ATTR_NAME);
        if (semantics != null) {
            group.setSemantics(semantics);
        }
        boolean done = false;
        DefaultPacketExtensionProvider<ContentPacketExtension> contentProvider = new DefaultPacketExtensionProvider<ContentPacketExtension>(ContentPacketExtension.class);
        while (!done) {
            int eventType = parser.next();
            String elementName = parser.getName();
            if (elementName.equals("content")) {
                ContentPacketExtension content = contentProvider.parse(parser, 0);
                group.addChildExtension(content);
            }
            if (eventType != 3 || !parser.getName().equals(ELEMENT_NAME)) continue;
            done = true;
        }
        return group;
    }
}

