/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.xmpp.extensions.rayo;

import org.apache.commons.lang3.StringUtils;
import org.jitsi.xmpp.extensions.DefaultPacketExtensionProvider;
import org.jitsi.xmpp.extensions.rayo.EndExtension;
import org.jitsi.xmpp.extensions.rayo.HeaderExtension;
import org.jivesoftware.smack.packet.ExtensionElement;
import org.jivesoftware.smack.packet.IQ;
import org.jivesoftware.smack.provider.IQProvider;
import org.jivesoftware.smack.provider.ProviderManager;
import org.jxmpp.jid.Jid;
import org.xmlpull.v1.XmlPullParser;

public class RayoIqProvider
extends IQProvider<RayoIq> {
    public static final String NAMESPACE = "urn:xmpp:rayo:1";

    public void registerRayoIQs() {
        ProviderManager.addIQProvider((String)"dial", (String)NAMESPACE, (Object)((Object)this));
        ProviderManager.addIQProvider((String)"ref", (String)NAMESPACE, (Object)((Object)this));
        ProviderManager.addIQProvider((String)"hangup", (String)NAMESPACE, (Object)((Object)this));
        ProviderManager.addExtensionProvider((String)"end", (String)NAMESPACE, new DefaultPacketExtensionProvider<EndExtension>(EndExtension.class));
        ProviderManager.addExtensionProvider((String)"header", (String)NAMESPACE, new DefaultPacketExtensionProvider<HeaderExtension>(HeaderExtension.class));
    }

    public RayoIq parse(XmlPullParser parser, int depth) throws Exception {
        RayoIq iq;
        String namespace = parser.getNamespace();
        if (!NAMESPACE.equals(namespace)) {
            return null;
        }
        String rootElement = parser.getName();
        if ("dial".equals(rootElement)) {
            DialIq dial;
            iq = dial = new DialIq();
            String src = parser.getAttributeValue("", "from");
            String dst = parser.getAttributeValue("", "to");
            if (StringUtils.isEmpty((CharSequence)dst)) {
                return null;
            }
            dial.setSource(src);
            dial.setDestination(dst);
        } else if ("ref".equals(rootElement)) {
            RefIq ref = new RefIq();
            iq = ref;
            String uri = parser.getAttributeValue("", "uri");
            if (StringUtils.isEmpty((CharSequence)uri)) {
                return null;
            }
            ref.setUri(uri);
        } else if ("hangup".equals(rootElement)) {
            iq = new HangUp();
        } else {
            return null;
        }
        boolean done = false;
        HeaderExtension header = null;
        while (!done) {
            switch (parser.next()) {
                case 3: {
                    String name = parser.getName();
                    if (rootElement.equals(name)) {
                        done = true;
                        break;
                    }
                    if (!"header".equals(name) || header == null) break;
                    iq.addExtension(header);
                    header = null;
                    break;
                }
                case 2: {
                    String name = parser.getName();
                    if (!"header".equals(name)) break;
                    header = new HeaderExtension();
                    String nameAttr = parser.getAttributeValue("", "name");
                    header.setName(nameAttr);
                    String valueAttr = parser.getAttributeValue("", "value");
                    header.setValue(valueAttr);
                    break;
                }
            }
        }
        return iq;
    }

    public static class HangUp
    extends RayoIq {
        public static final String ELEMENT_NAME = "hangup";

        protected HangUp() {
            super(ELEMENT_NAME);
        }

        public static HangUp create(Jid from, Jid to) {
            HangUp hangUp = new HangUp();
            hangUp.setFrom(from);
            hangUp.setTo(to);
            hangUp.setType(IQ.Type.set);
            return hangUp;
        }

        protected IQ.IQChildElementXmlStringBuilder getIQChildElementBuilder(IQ.IQChildElementXmlStringBuilder xml) {
            xml.setEmptyElement();
            return xml;
        }
    }

    public static class RefIq
    extends RayoIq {
        public static final String ELEMENT_NAME = "ref";
        public static final String URI_ATTR_NAME = "uri";
        private String uri;

        protected RefIq() {
            super(ELEMENT_NAME);
        }

        public static RefIq create(String uri) {
            RefIq refIq = new RefIq();
            refIq.setUri(uri);
            return refIq;
        }

        public static RefIq createResult(IQ requestIq, String uri) {
            RefIq refIq = RefIq.create(uri);
            refIq.setType(IQ.Type.result);
            refIq.setStanzaId(requestIq.getStanzaId());
            refIq.setFrom(requestIq.getTo());
            refIq.setTo(requestIq.getFrom());
            return refIq;
        }

        protected IQ.IQChildElementXmlStringBuilder getIQChildElementBuilder(IQ.IQChildElementXmlStringBuilder xml) {
            xml.optAttribute(URI_ATTR_NAME, this.uri);
            xml.setEmptyElement();
            return xml;
        }

        public void setUri(String uri) {
            this.uri = uri;
        }

        public String getUri() {
            return this.uri;
        }
    }

    public static class DialIq
    extends RayoIq {
        public static final String ELEMENT_NAME = "dial";
        public static final String SRC_ATTR_NAME = "from";
        public static final String DST_ATTR_NAME = "to";
        private String source;
        private String destination;

        public DialIq() {
            super(ELEMENT_NAME);
        }

        public DialIq(DialIq original) {
            super(original);
            this.source = original.source;
            this.destination = original.destination;
        }

        public static DialIq create(String to, String from) {
            DialIq dialIq = new DialIq();
            dialIq.setSource(from);
            dialIq.setDestination(to);
            return dialIq;
        }

        public String getSource() {
            return this.source;
        }

        public void setSource(String source) {
            this.source = source;
        }

        public String getDestination() {
            return this.destination;
        }

        public void setDestination(String destination) {
            this.destination = destination;
        }

        protected IQ.IQChildElementXmlStringBuilder getIQChildElementBuilder(IQ.IQChildElementXmlStringBuilder xml) {
            xml.optAttribute(SRC_ATTR_NAME, this.source).optAttribute(DST_ATTR_NAME, this.destination);
            xml.setEmptyElement();
            return xml;
        }
    }

    public static abstract class RayoIq
    extends IQ {
        protected RayoIq(String elementName) {
            super(elementName, RayoIqProvider.NAMESPACE);
        }

        protected RayoIq(RayoIq original) {
            super((IQ)original);
        }

        public String getHeader(String name) {
            HeaderExtension header = this.findHeader(name);
            return header != null ? header.getValue() : null;
        }

        private HeaderExtension findHeader(String name) {
            for (ExtensionElement ext : this.getExtensions()) {
                HeaderExtension header;
                if (!(ext instanceof HeaderExtension) || !name.equals((header = (HeaderExtension)ext).getName())) continue;
                return header;
            }
            return null;
        }

        public void setHeader(String name, String value) {
            HeaderExtension headerExt = this.findHeader(name);
            if (headerExt == null) {
                headerExt = new HeaderExtension();
                headerExt.setName(name);
                this.addExtension(headerExt);
            }
            headerExt.setValue(value);
        }
    }
}

