/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.plugin.desktoputil;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.SwingUtilities;
import net.java.sip.communicator.plugin.desktoputil.DesktopUtilActivator;
import net.java.sip.communicator.plugin.desktoputil.SIPCommButton;
import net.java.sip.communicator.plugin.desktoputil.SIPCommFrame;
import net.java.sip.communicator.util.Logger;
import net.java.sip.communicator.util.skin.Skinnable;
import org.apache.commons.lang3.StringUtils;

public class PopupNotificationPanel
extends SIPCommFrame.MainContentPane
implements Skinnable {
    private static final long serialVersionUID = 0L;
    private final Logger logger = Logger.getLogger(SIPCommFrame.class);
    private Object tag;
    private final SIPCommButton notifClose;
    private JLabel notifTitle;

    private PopupNotificationPanel(String titleString) {
        this.notifTitle = new JLabel(DesktopUtilActivator.getResources().getSettingsString("service.gui.APPLICATION_NAME") + (StringUtils.isBlank((CharSequence)titleString) ? "" : ": " + titleString), 2);
        this.notifClose = new SIPCommButton();
        this.notifClose.setToolTipText(DesktopUtilActivator.getResources().getI18NString("service.gui.CLOSE"));
        this.notifClose.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    Window parentWindow = SwingUtilities.getWindowAncestor(PopupNotificationPanel.this);
                    parentWindow.dispose();
                }
                catch (Exception ex) {
                    PopupNotificationPanel.this.logger.warn((Object)"Error while getting the popup window :", (Throwable)ex);
                }
            }
        });
        JPanel notificationWindowTitle = new JPanel(new BorderLayout(0, 2));
        notificationWindowTitle.setBorder(BorderFactory.createEmptyBorder(3, 3, 3, 3));
        notificationWindowTitle.setOpaque(false);
        notificationWindowTitle.add((Component)this.notifTitle, "West");
        notificationWindowTitle.add((Component)this.notifClose, "East");
        JSeparator jSep = new JSeparator();
        notificationWindowTitle.add((Component)jSep, "South");
        this.add((Component)notificationWindowTitle, "North");
        this.setBorder(BorderFactory.createLineBorder(Color.GRAY));
        this.loadSkin();
    }

    public PopupNotificationPanel(String titleString, JPanel notificationContent, Object tag) {
        this(titleString);
        this.add((Component)notificationContent, "Center");
        this.tag = tag;
    }

    public Object getTag() {
        return this.tag;
    }

    public void setTag(Object tag) {
        this.tag = tag;
    }

    public void loadSkin() {
        this.notifTitle.setIcon(DesktopUtilActivator.getResources().getImage("service.gui.SIP_COMMUNICATOR_LOGO"));
        this.notifClose.setBackgroundImage(DesktopUtilActivator.getResources().getImage("service.gui.lookandfeel.CLOSE_TAB_ICON").getImage());
    }
}

