/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.plugin.desktoputil;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import net.java.sip.communicator.plugin.desktoputil.DesktopUtilActivator;
import net.java.sip.communicator.plugin.desktoputil.MoveableTableModel;
import net.java.sip.communicator.plugin.desktoputil.TransparentPanel;
import org.jitsi.service.resources.ResourceManagementService;

public class PriorityTable
extends TransparentPanel {
    private JTable table;
    private JButton upButton;
    private JButton downButton;
    private static final int WIDTH = 350;

    public PriorityTable(MoveableTableModel tableModel, int height) {
        super(new BorderLayout());
        ResourceManagementService resources = DesktopUtilActivator.getResources();
        this.table = new JTable();
        this.table.setShowGrid(false);
        this.table.setTableHeader(null);
        String key = "impl.media.configform.UP";
        this.upButton = new JButton(resources.getI18NString(key));
        this.upButton.setMnemonic(resources.getI18nMnemonic(key));
        this.upButton.setOpaque(false);
        key = "impl.media.configform.DOWN";
        this.downButton = new JButton(resources.getI18NString(key));
        this.downButton.setMnemonic(resources.getI18nMnemonic(key));
        this.downButton.setOpaque(false);
        TransparentPanel buttonBar = new TransparentPanel(new GridLayout(0, 1));
        ((Container)((Object)buttonBar)).add(this.upButton);
        ((Container)((Object)buttonBar)).add(this.downButton);
        TransparentPanel parentButtonBar = new TransparentPanel(new BorderLayout());
        ((Container)((Object)parentButtonBar)).add((Component)((Object)buttonBar), "North");
        this.setPreferredSize(new Dimension(350, height));
        this.setMaximumSize(new Dimension(350, height));
        this.add(new JScrollPane(this.table), "Center");
        this.add((Component)((Object)parentButtonBar), "East");
        this.table.setModel(tableModel);
        TableColumnModel tableColumnModel = this.table.getColumnModel();
        TableColumn tableColumn = tableColumnModel.getColumn(0);
        tableColumn.setMaxWidth(tableColumn.getMinWidth());
        ListSelectionListener tableSelectionListener = new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent event) {
                int selectedRow;
                if (PriorityTable.this.table.getSelectedRowCount() == 1 && (selectedRow = PriorityTable.this.table.getSelectedRow()) > -1) {
                    PriorityTable.this.upButton.setEnabled(selectedRow > 0);
                    PriorityTable.this.downButton.setEnabled(selectedRow < PriorityTable.this.table.getRowCount() - 1);
                    return;
                }
                PriorityTable.this.upButton.setEnabled(false);
                PriorityTable.this.downButton.setEnabled(false);
            }
        };
        this.table.getSelectionModel().addListSelectionListener(tableSelectionListener);
        tableSelectionListener.valueChanged(null);
        ActionListener buttonListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                boolean up;
                Object source = event.getSource();
                if (source == PriorityTable.this.upButton) {
                    up = true;
                } else if (source == PriorityTable.this.downButton) {
                    up = false;
                } else {
                    return;
                }
                PriorityTable.this.move(up);
            }
        };
        this.upButton.addActionListener(buttonListener);
        this.downButton.addActionListener(buttonListener);
    }

    private void move(boolean up) {
        int index = ((MoveableTableModel)this.table.getModel()).move(this.table.getSelectedRow(), up);
        this.table.getSelectionModel().setSelectionInterval(index, index);
    }

    public void setEnabled(boolean enabled) {
        this.table.setEnabled(enabled);
        this.upButton.setEnabled(enabled);
        this.downButton.setEnabled(enabled);
    }
}

