/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.plugin.desktoputil.plaf;

import java.awt.Cursor;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.ToolTipManager;
import javax.swing.plaf.ComponentUI;
import javax.swing.text.JTextComponent;
import net.java.sip.communicator.plugin.desktoputil.AntialiasingManager;
import net.java.sip.communicator.plugin.desktoputil.DesktopUtilActivator;
import net.java.sip.communicator.plugin.desktoputil.plaf.SIPCommTextFieldUI;
import net.java.sip.communicator.util.skin.Skinnable;
import org.apache.commons.lang3.StringUtils;
import org.jitsi.service.resources.ResourceManagementService;

public class SearchFieldUI
extends SIPCommTextFieldUI
implements Skinnable {
    private Image callIcon;
    private Image callPressedIcon;
    private Image callRolloverIcon;
    private Image smsIcon;
    private Image smsPressedIcon;
    private Image smsRolloverIcon;
    private final String callString = DesktopUtilActivator.getResources().getI18NString("service.gui.CALL");
    private final String smsString = DesktopUtilActivator.getResources().getI18NString("service.gui.SMS");
    private boolean isCallButtonEnabled = false;
    private boolean isSMSButtonEnabled = false;
    protected boolean isCallIconVisible = false;
    private boolean isCallMouseOver = false;
    private boolean isCallMousePressed = false;
    protected boolean isSMSIconVisible = false;
    private boolean isSMSMouseOver = false;
    private boolean isSMSMousePressed = false;
    private ImageIcon searchIcon;
    private Image separatorIcon;

    public static ComponentUI createUI(JComponent c) {
        return new SearchFieldUI();
    }

    public SearchFieldUI() {
        this.loadSkin();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void customPaintBackground(Graphics g) {
        Graphics2D g2 = (Graphics2D)g.create();
        try {
            int dx;
            AntialiasingManager.activateAntialiasing(g2);
            super.customPaintBackground(g2);
            JTextComponent c = this.getComponent();
            int dy = c.getHeight() / 2 - this.searchIcon.getIconHeight() / 2;
            g2.drawImage(this.searchIcon.getImage(), 3, dy, null);
            String str = c.getText();
            if (c.getText() != null && c.getText().length() > 0 && str != null && StringUtils.isNotEmpty((CharSequence)str) && !StringUtils.isAlpha((CharSequence)str) && this.isSMSButtonEnabled) {
                Rectangle smsRect = this.getSMSButtonRect();
                dx = smsRect.x;
                dy = smsRect.y;
                if (this.isSMSMousePressed) {
                    g2.drawImage(this.smsPressedIcon, dx, dy, null);
                } else if (this.isSMSMouseOver) {
                    g2.drawImage(this.smsRolloverIcon, dx, dy, null);
                } else {
                    g2.drawImage(this.smsIcon, dx, dy, null);
                }
                this.isSMSIconVisible = true;
            } else {
                this.isSMSIconVisible = false;
            }
            if (c.getText() != null && c.getText().length() > 0 && this.isCallButtonEnabled) {
                Rectangle callRect = this.getCallButtonRect();
                dx = callRect.x;
                dy = callRect.y;
                if (this.isCallMousePressed) {
                    g2.drawImage(this.callPressedIcon, dx, dy, null);
                } else if (this.isCallMouseOver) {
                    g2.drawImage(this.callRolloverIcon, dx, dy, null);
                } else {
                    g2.drawImage(this.callIcon, dx, dy, null);
                }
                g2.drawImage(this.separatorIcon, dx + callRect.width + 3, dy + (callRect.height - this.separatorIcon.getHeight(null)) / 2, null);
                this.isCallIconVisible = true;
            } else {
                this.isCallIconVisible = false;
            }
        }
        finally {
            g2.dispose();
        }
    }

    protected Rectangle getCallButtonRect() {
        JTextComponent c = this.getComponent();
        Rectangle rect = c.getBounds();
        int dx = this.getDeleteButtonRect().x - this.callRolloverIcon.getWidth(null) - 8;
        int dy = rect.height / 2 - this.callRolloverIcon.getHeight(null) / 2;
        return new Rectangle(dx, dy, this.callRolloverIcon.getWidth(null), this.callRolloverIcon.getHeight(null));
    }

    protected Rectangle getSMSButtonRect() {
        JTextComponent c = this.getComponent();
        Rectangle rect = c.getBounds();
        int dx = this.getDeleteButtonRect().x - this.smsRolloverIcon.getWidth(null) - 8;
        if (this.isCallIconVisible) {
            dx -= this.callRolloverIcon.getWidth(null) + 4;
        }
        int dy = (rect.y + rect.height) / 2 - this.smsRolloverIcon.getHeight(null) / 2;
        return new Rectangle(dx, dy, this.smsRolloverIcon.getWidth(null), this.smsRolloverIcon.getHeight(null));
    }

    @Override
    protected Rectangle getVisibleEditorRect() {
        Rectangle rect = super.getVisibleEditorRect();
        if (rect == null) {
            return null;
        }
        if (rect.width > 0 && rect.height > 0) {
            rect.x += this.searchIcon.getIconWidth() + 5;
            rect.width -= this.searchIcon.getIconWidth() + 5;
            if (this.isSMSIconVisible) {
                rect.width -= this.smsRolloverIcon.getWidth(null) + 12;
            }
            rect.width = this.isCallIconVisible ? (rect.width -= this.callRolloverIcon.getWidth(null) + 12) : (rect.width -= 8);
            return rect;
        }
        return null;
    }

    @Override
    public void loadSkin() {
        super.loadSkin();
        ResourceManagementService r = DesktopUtilActivator.getResources();
        this.searchIcon = r.getImage("service.gui.icons.SEARCH_ICON");
        if (this.isCallButtonEnabled) {
            this.callIcon = r.getImage("service.gui.buttons.SEARCH_CALL_ICON").getImage();
            this.callRolloverIcon = r.getImage("service.gui.buttons.SEARCH_CALL_ROLLOVER_ICON").getImage();
            this.callPressedIcon = r.getImage("service.gui.buttons.SEARCH_CALL_PRESSED_ICON").getImage();
        }
        if (this.isSMSButtonEnabled) {
            this.loadSMSIcons();
        }
        if (this.isSMSButtonEnabled || this.isCallButtonEnabled) {
            this.separatorIcon = r.getImage("service.gui.icons.SEARCH_SEPARATOR").getImage();
        }
    }

    private void loadSMSIcons() {
        ResourceManagementService r = DesktopUtilActivator.getResources();
        this.smsIcon = r.getImage("service.gui.buttons.SEARCH_SMS_ICON").getImage();
        this.smsRolloverIcon = r.getImage("service.gui.buttons.SEARCH_SMS_ROLLOVER_ICON").getImage();
        this.smsPressedIcon = r.getImage("service.gui.buttons.SEARCH_SMS_PRESSED_ICON").getImage();
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        super.mouseClicked(e);
        if (this.isCallButtonEnabled || this.isSMSButtonEnabled) {
            this.updateIcon(e);
        }
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        super.mouseDragged(e);
        if (this.isCallButtonEnabled || this.isSMSButtonEnabled) {
            this.updateIcon(e);
        }
    }

    @Override
    public void mouseEntered(MouseEvent e) {
        super.mouseEntered(e);
        if (this.isCallButtonEnabled || this.isSMSButtonEnabled) {
            this.updateIcon(e);
        }
    }

    @Override
    public void mouseExited(MouseEvent e) {
        super.mouseExited(e);
        if (this.isCallButtonEnabled || this.isSMSButtonEnabled) {
            this.updateIcon(e);
        }
    }

    @Override
    public void mouseMoved(MouseEvent e) {
        super.mouseMoved(e);
        if (this.isCallButtonEnabled || this.isSMSButtonEnabled) {
            this.updateIcon(e);
        }
    }

    @Override
    public void mousePressed(MouseEvent e) {
        super.mousePressed(e);
        if (this.isCallButtonEnabled || this.isSMSButtonEnabled) {
            this.updateIcon(e);
        }
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        super.mouseReleased(e);
        if (this.isCallButtonEnabled || this.isSMSButtonEnabled) {
            this.updateIcon(e);
        }
    }

    @Override
    protected void paintSafely(Graphics g) {
        this.customPaintBackground(g);
        super.paintSafely(g);
    }

    public void setCallButtonEnabled(boolean isEnabled) {
        JTextComponent c = this.getComponent();
        if (this.isCallButtonEnabled != isEnabled) {
            this.isCallButtonEnabled = isEnabled;
            this.loadSkin();
            if (c != null && c.isVisible()) {
                c.repaint();
            }
        }
    }

    public void setSMSButtonEnabled(boolean isEnabled) {
        this.loadSMSIcons();
        this.isSMSButtonEnabled = isEnabled;
    }

    protected void updateIcon(MouseEvent evt) {
        String searchText;
        JTextComponent c;
        int x = evt.getX();
        int y = evt.getY();
        boolean outsideButtons = true;
        if (this.isCallIconVisible && this.getCallButtonRect().contains(x, y)) {
            c = this.getComponent();
            searchText = c.getText();
            if (searchText == null) {
                return;
            }
            outsideButtons = false;
            this.getComponent().setToolTipText(this.callString + " " + searchText);
            ToolTipManager.sharedInstance().mouseEntered(new MouseEvent(c, 0, x, y, x, y, 0, false));
            if (evt.getID() == 501) {
                this.isCallMouseOver = false;
                this.isCallMousePressed = true;
            } else {
                this.isCallMouseOver = true;
                this.isCallMousePressed = false;
            }
            this.getComponent().setCursor(Cursor.getDefaultCursor());
        }
        if (this.isSMSIconVisible && this.getSMSButtonRect().contains(x, y)) {
            c = this.getComponent();
            searchText = c.getText();
            if (searchText == null) {
                return;
            }
            outsideButtons = false;
            this.getComponent().setToolTipText(this.smsString + " " + searchText);
            ToolTipManager.sharedInstance().mouseEntered(new MouseEvent(c, 0, x, y, x, y, 0, false));
            if (evt.getID() == 501) {
                this.isSMSMouseOver = false;
                this.isSMSMousePressed = true;
            } else {
                this.isSMSMouseOver = true;
                this.isSMSMousePressed = false;
            }
            this.getComponent().setCursor(Cursor.getDefaultCursor());
        }
        if (outsideButtons) {
            this.getComponent().setToolTipText("");
            ToolTipManager.sharedInstance().mouseExited(new MouseEvent(this.getComponent(), 0, x, y, x, y, 0, false));
            this.isCallMouseOver = false;
            this.isCallMousePressed = false;
            this.isSMSMouseOver = false;
            this.isSMSMousePressed = false;
        }
        this.getComponent().repaint();
    }
}

