/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.plugin.desktoputil.presence;

import java.awt.CheckboxMenuItem;
import java.awt.Component;
import java.awt.ItemSelectable;
import java.awt.Menu;
import java.awt.MenuComponent;
import java.awt.MenuItem;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.Icon;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.SwingUtilities;
import net.java.sip.communicator.plugin.desktoputil.DesktopUtilActivator;
import net.java.sip.communicator.plugin.desktoputil.presence.NewStatusMessageDialog;
import net.java.sip.communicator.util.ConfigurationUtils;
import org.apache.commons.lang3.StringUtils;
import org.jitsi.service.resources.ResourceManagementService;

public abstract class AbstractStatusMessageMenu
implements ActionListener,
ItemListener,
PropertyChangeListener {
    public static final String STATUS_MESSAGE_UPDATED_PROP = "STATUS_MESSAGE_UPDATED";
    public static final String CUSTOM_STATUS_MESSAGES_UPDATED_PROP = "CUSTOM_STATUS_MESSAGES_UPDATED";
    private static final String CUSTOM_MESSAGES_PREFIX = "service.gui.CUSTOM_STATUS_MESSAGE";
    private static final String PROVISIONED_MESSAGES_PREFIX = "service.gui.PROVISIONED_STATUS_MESSAGE";
    private static final String BRB_MESSAGE = DesktopUtilActivator.getResources().getI18NString("service.gui.BRB_MESSAGE");
    private static final String BUSY_MESSAGE = DesktopUtilActivator.getResources().getI18NString("service.gui.BUSY_MESSAGE");
    private Object noMessageItem;
    private Object newMessageItem;
    private Object clearCustomMessageItem;
    private Object busyMessageItem;
    private Object brbMessageItem;
    private Object menu;
    private static List<PropertyChangeListener> propertyChangeListeners = new ArrayList<PropertyChangeListener>();

    public AbstractStatusMessageMenu(boolean swing) {
        ResourceManagementService R = DesktopUtilActivator.getResources();
        String text = R.getI18NString("service.gui.SET_STATUS_MESSAGE");
        if (swing) {
            JMenu menuInstance = new JMenu(text);
            Icon icon = this.getMenuIcon();
            if (icon != null) {
                menuInstance.setIcon(icon);
            }
            this.menu = menuInstance;
        } else {
            this.menu = new Menu(text);
        }
        this.noMessageItem = this.createMenuItem(R.getI18NString("service.gui.NO_MESSAGE"));
        this.newMessageItem = this.createMenuItem(R.getI18NString("service.gui.NEW_MESSAGE"));
        this.clearCustomMessageItem = this.createMenuItem(R.getI18NString("service.gui.CLEAR_CUSTOM_MESSAGES"));
        if (ConfigurationUtils.isPresetStatusMessagesEnabled()) {
            this.addSeparator();
            this.busyMessageItem = this.createsCheckBoxMenuItem(BUSY_MESSAGE);
            this.brbMessageItem = this.createsCheckBoxMenuItem(BRB_MESSAGE);
        } else {
            this.busyMessageItem = null;
            this.brbMessageItem = null;
        }
        this.loadProvisionedStatusMessages();
        this.loadCustomStatusMessages();
        this.addPropertyChangeListener(this);
    }

    private Object createMenuItem(String text) {
        if (this.menu instanceof JMenu) {
            JMenuItem menuItem = new JMenuItem(text);
            menuItem.setName(text);
            menuItem.addActionListener(this);
            ((JMenu)this.menu).add(menuItem);
            return menuItem;
        }
        MenuItem menuItem = new MenuItem(text);
        menuItem.setName(text);
        menuItem.addActionListener(this);
        ((Menu)this.menu).add(menuItem);
        return menuItem;
    }

    private Object createsCheckBoxMenuItem(String text) {
        if (this.menu instanceof JMenu) {
            JCheckBoxMenuItem menuItem = new JCheckBoxMenuItem(text);
            menuItem.setName(text);
            menuItem.addActionListener(this);
            ((JMenu)this.menu).add(menuItem);
            return menuItem;
        }
        CheckboxMenuItem menuItem = new CheckboxMenuItem(text);
        menuItem.setName(text);
        menuItem.addItemListener(this);
        ((Menu)this.menu).add(menuItem);
        return menuItem;
    }

    private void addSeparator() {
        if (this.menu instanceof JMenu) {
            ((JMenu)this.menu).addSeparator();
        } else {
            ((Menu)this.menu).addSeparator();
        }
    }

    public Object getMenu() {
        return this.menu;
    }

    private int getMenuComponentCount() {
        if (this.menu instanceof JMenu) {
            return ((JMenu)this.menu).getMenuComponentCount();
        }
        return ((Menu)this.menu).getItemCount();
    }

    private Object[] getMenuComponents() {
        if (this.menu instanceof JMenu) {
            return ((JMenu)this.menu).getMenuComponents();
        }
        int c = ((Menu)this.menu).getItemCount();
        Object[] res = new Object[c];
        for (int i = 0; i < c; ++i) {
            res[i] = ((Menu)this.menu).getItem(i);
        }
        return res;
    }

    private Object getMenuComponent(int index) {
        if (this.menu instanceof JMenu) {
            return ((JMenu)this.menu).getMenuComponent(index);
        }
        return ((Menu)this.menu).getItem(index);
    }

    private void removeMenuComponent(int index) {
        if (this.menu instanceof JMenu) {
            ((JMenu)this.menu).remove(index);
        } else {
            ((Menu)this.menu).remove(index);
        }
    }

    private int removeMenuComponent(Object item) {
        if (this.menu instanceof JMenu) {
            int ix = ((JMenu)this.menu).getPopupMenu().getComponentIndex((JMenuItem)item);
            ((JMenu)this.menu).remove((JMenuItem)item);
            return ix;
        }
        int ix = ((MenuItem)item).getAccessibleContext().getAccessibleIndexInParent();
        ((Menu)this.menu).remove((MenuItem)item);
        return ix;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.actionPerformed(e.getSource());
    }

    public abstract String getCurrentStatusMessage();

    public void actionPerformed(Object menuItem) {
        String statusMessage = "";
        if (menuItem.equals(this.newMessageItem)) {
            String currentStatusMessage = this.getCurrentStatusMessage();
            NewStatusMessageDialog dialog = new NewStatusMessageDialog(currentStatusMessage == null ? "" : currentStatusMessage, this);
            dialog.setLocation(Toolkit.getDefaultToolkit().getScreenSize().width / 2 - dialog.getWidth() / 2, Toolkit.getDefaultToolkit().getScreenSize().height / 2 - dialog.getHeight() / 2);
            dialog.setVisible(true);
            dialog.requestFocusInField();
            return;
        }
        if (menuItem.equals(this.clearCustomMessageItem)) {
            this.removeAllCustomStatusMessages();
            List customMessagesProps = DesktopUtilActivator.getConfigurationService().getPropertyNamesByPrefix(CUSTOM_MESSAGES_PREFIX, false);
            for (String p : customMessagesProps) {
                DesktopUtilActivator.getConfigurationService().removeProperty(p);
            }
            this.fireCustomStatusMessagesUpdated();
        } else if (menuItem.equals(this.busyMessageItem)) {
            statusMessage = BUSY_MESSAGE;
        } else if (menuItem.equals(this.brbMessageItem)) {
            statusMessage = BRB_MESSAGE;
        } else if (menuItem instanceof CustomMessageItems) {
            statusMessage = ((CustomMessageItems)menuItem).getName();
        } else if (menuItem instanceof ProvisionedMessageItems) {
            statusMessage = ((ProvisionedMessageItems)menuItem).getName();
        }
        this.publishStatusMessage(statusMessage, menuItem, false);
        this.setCurrentMessage(statusMessage, menuItem, false);
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        this.actionPerformed(e.getSource());
    }

    private void removeAllCustomStatusMessages() {
        int lastIx = -1;
        for (Object c : this.getMenuComponents()) {
            if (!(c instanceof CustomMessageItems)) continue;
            lastIx = this.removeMenuComponent(c);
        }
        if (lastIx - 1 >= 0) {
            this.removeMenuComponent(lastIx - 1);
        }
    }

    public abstract void publishStatusMessage(String var1, Object var2, boolean var3);

    Object getNewMessageItem() {
        return this.newMessageItem;
    }

    protected void setCurrentMessage(final String message, final Object menuItem, final boolean saveNewMessage) {
        if (menuItem == null) {
            return;
        }
        if (!SwingUtilities.isEventDispatchThread()) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    AbstractStatusMessageMenu.this.setCurrentMessage(message, menuItem, saveNewMessage);
                }
            });
            return;
        }
        String oldMesage = this.getCurrentMessage();
        if (StringUtils.isEmpty((CharSequence)message)) {
            this.clearSelectedItems();
            this.fireStatusMessageUpdated(oldMesage, null);
            return;
        }
        if (menuItem.equals(this.newMessageItem)) {
            this.clearSelectedItems();
            int ix = this.getLastCustomMessageIndex();
            if (ix == -1) {
                this.addSeparator();
                this.createsCustomMessageItem(message, -1, true);
            } else {
                this.createsCustomMessageItem(message, ix + 1, true);
            }
            if (saveNewMessage) {
                int saveIx = this.getLastCustomStatusMessageIndex();
                DesktopUtilActivator.getConfigurationService().setProperty("service.gui.CUSTOM_STATUS_MESSAGE." + String.valueOf(saveIx + 1), (Object)message);
            }
            this.fireCustomStatusMessagesUpdated();
            this.fireStatusMessageUpdated(oldMesage, message);
        } else if (menuItem instanceof JCheckBoxMenuItem || menuItem instanceof CheckboxMenuItem) {
            this.clearSelectedItems();
            this.selectMenuItem(menuItem, oldMesage);
        }
    }

    private int getLastCustomStatusMessageIndex() {
        int ix = -1;
        List customMessagesProps = DesktopUtilActivator.getConfigurationService().getPropertyNamesByPrefix(CUSTOM_MESSAGES_PREFIX, false);
        int prefixLen = CUSTOM_MESSAGES_PREFIX.length() + 1;
        for (String p : customMessagesProps) {
            if (prefixLen > p.length()) continue;
            String s = p.substring(prefixLen);
            try {
                int i = Integer.parseInt(s);
                if (i <= ix) continue;
                ix = i;
            }
            catch (Throwable throwable) {}
        }
        return ix;
    }

    private void loadCustomStatusMessages() {
        List customMessagesProps = DesktopUtilActivator.getConfigurationService().getPropertyNamesByPrefix(CUSTOM_MESSAGES_PREFIX, false);
        if (customMessagesProps.size() > 0) {
            this.addSeparator();
        }
        for (String p : customMessagesProps) {
            String message = DesktopUtilActivator.getConfigurationService().getString(p);
            this.createsCustomMessageItem(message, -1, false);
        }
    }

    private void loadProvisionedStatusMessages() {
        List provMessagesProps = DesktopUtilActivator.getConfigurationService().getPropertyNamesByPrefix(PROVISIONED_MESSAGES_PREFIX, false);
        if (provMessagesProps.size() > 0) {
            this.addSeparator();
        }
        for (String p : provMessagesProps) {
            String message = DesktopUtilActivator.getConfigurationService().getString(p);
            this.createsProvisionedMessageItem(message);
        }
    }

    public void clearSelectedItems() {
        for (int i = 0; i < this.getMenuComponentCount(); ++i) {
            ItemSelectable checkItem;
            Object c = this.getMenuComponent(i);
            if (c instanceof JCheckBoxMenuItem) {
                checkItem = (JCheckBoxMenuItem)c;
                ((AbstractButton)checkItem).setSelected(false);
                ((AbstractButton)checkItem).setText(((Component)((Object)checkItem)).getName());
                continue;
            }
            if (!(c instanceof CheckboxMenuItem)) continue;
            checkItem = (CheckboxMenuItem)c;
            ((CheckboxMenuItem)checkItem).setState(false);
        }
    }

    private int getLastCustomMessageIndex() {
        int ix = -1;
        for (int i = 0; i < this.getMenuComponentCount(); ++i) {
            Object c = this.getMenuComponent(i);
            if (!(c instanceof CustomMessageItems) || i <= ix) continue;
            ix = i;
        }
        return ix;
    }

    public String getCurrentMessage() {
        for (int i = 0; i < this.getMenuComponentCount(); ++i) {
            Object c = this.getMenuComponent(i);
            if (c instanceof JCheckBoxMenuItem && ((JCheckBoxMenuItem)c).isSelected()) {
                return ((JCheckBoxMenuItem)c).getName();
            }
            if (!(c instanceof CheckboxMenuItem) || !((CheckboxMenuItem)c).getState()) continue;
            return ((CheckboxMenuItem)c).getName();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addPropertyChangeListener(PropertyChangeListener listener) {
        List<PropertyChangeListener> list = propertyChangeListeners;
        synchronized (list) {
            if (!propertyChangeListeners.contains(listener)) {
                propertyChangeListeners.add(listener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removePropertyChangeListener(PropertyChangeListener listener) {
        List<PropertyChangeListener> list = propertyChangeListeners;
        synchronized (list) {
            propertyChangeListeners.remove(listener);
        }
    }

    public abstract Object getDescriptor();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void fireStatusMessageUpdated(String oldMessage, String newMessage) {
        ArrayList<PropertyChangeListener> listeners;
        PropertyChangeEvent evt = new PropertyChangeEvent(this.getDescriptor(), STATUS_MESSAGE_UPDATED_PROP, oldMessage, newMessage);
        List<PropertyChangeListener> list = propertyChangeListeners;
        synchronized (list) {
            listeners = new ArrayList<PropertyChangeListener>(propertyChangeListeners);
        }
        for (PropertyChangeListener target : listeners) {
            target.propertyChange(evt);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireCustomStatusMessagesUpdated() {
        ArrayList<PropertyChangeListener> listeners;
        PropertyChangeEvent evt = new PropertyChangeEvent(this.getDescriptor(), CUSTOM_STATUS_MESSAGES_UPDATED_PROP, null, null);
        List<PropertyChangeListener> list = propertyChangeListeners;
        synchronized (list) {
            listeners = new ArrayList<PropertyChangeListener>(propertyChangeListeners);
        }
        for (PropertyChangeListener target : listeners) {
            target.propertyChange(evt);
        }
    }

    private Object createsProvisionedMessageItem(String text) {
        if (this.menu instanceof JMenu) {
            ProvisionedMessageItemsSwing newMenuItem = new ProvisionedMessageItemsSwing(text);
            newMenuItem.setName(text);
            newMenuItem.addActionListener(this);
            ((JMenu)this.menu).add(newMenuItem);
            return newMenuItem;
        }
        ProvisionedMessageItemsAwt newMenuItem = new ProvisionedMessageItemsAwt(text);
        newMenuItem.setName(text);
        newMenuItem.addItemListener(this);
        ((Menu)this.menu).add(newMenuItem);
        return newMenuItem;
    }

    private Object createsCustomMessageItem(String text, int index, boolean selected) {
        if (this.menu instanceof JMenu) {
            CustomMessageItemsSwing newMenuItem = new CustomMessageItemsSwing(text);
            if (selected) {
                newMenuItem.setSelected(true);
            }
            newMenuItem.setName(text);
            newMenuItem.addActionListener(this);
            if (index == -1) {
                ((JMenu)this.menu).add(newMenuItem);
            } else {
                ((JMenu)this.menu).insert(newMenuItem, index);
            }
            return newMenuItem;
        }
        CustomMessageItemsAwt newMenuItem = new CustomMessageItemsAwt(text);
        if (selected) {
            newMenuItem.setState(true);
        }
        newMenuItem.setName(text);
        newMenuItem.addItemListener(this);
        if (index == -1) {
            ((Menu)this.menu).add(newMenuItem);
        } else {
            ((Menu)this.menu).insert(newMenuItem, index);
        }
        return newMenuItem;
    }

    private String selectMenuItem(Object item, String oldMesage) {
        String name = null;
        if (item instanceof JCheckBoxMenuItem) {
            JCheckBoxMenuItem checkItem = (JCheckBoxMenuItem)item;
            name = checkItem.getName();
            checkItem.setSelected(true);
            checkItem.setText("<html><b>" + name + "</b></html>");
        } else if (item instanceof CheckboxMenuItem) {
            CheckboxMenuItem checkItem = (CheckboxMenuItem)item;
            name = checkItem.getName();
            checkItem.setState(true);
        }
        this.fireStatusMessageUpdated(oldMesage, name);
        return null;
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        block9: {
            block8: {
                if (!evt.getPropertyName().equals(CUSTOM_STATUS_MESSAGES_UPDATED_PROP)) break block8;
                List customMessagesProps = DesktopUtilActivator.getConfigurationService().getPropertyNamesByPrefix(CUSTOM_MESSAGES_PREFIX, false);
                if (customMessagesProps.isEmpty()) {
                    this.removeAllCustomStatusMessages();
                    return;
                }
                ArrayList<String> customMessages = new ArrayList<String>();
                for (String p : customMessagesProps) {
                    customMessages.add(DesktopUtilActivator.getConfigurationService().getString(p));
                }
                for (Object o : this.getMenuComponents()) {
                    if (!(o instanceof CustomMessageItems)) continue;
                    customMessages.remove(((CustomMessageItems)o).getName());
                }
                for (String message : customMessages) {
                    int ix = this.getLastCustomMessageIndex();
                    if (ix == -1) {
                        this.addSeparator();
                        this.createsCustomMessageItem(message, -1, false);
                        continue;
                    }
                    this.createsCustomMessageItem(message, ix + 1, false);
                }
                break block9;
            }
            if (!evt.getPropertyName().equals(STATUS_MESSAGE_UPDATED_PROP)) break block9;
            if (!evt.getSource().equals(this.getDescriptor())) {
                return;
            }
            this.clearSelectedItems();
            for (Object o : this.getMenuComponents()) {
                ItemSelectable item;
                if (o instanceof JCheckBoxMenuItem) {
                    item = (JCheckBoxMenuItem)o;
                    if (((AbstractButton)item).isSelected() || !((Component)((Object)item)).getName().equals(evt.getNewValue())) continue;
                    ((AbstractButton)item).setSelected(true);
                    continue;
                }
                if (!(o instanceof CheckboxMenuItem) || ((CheckboxMenuItem)(item = (CheckboxMenuItem)o)).getState() || !((MenuComponent)((Object)item)).getName().equals(evt.getNewValue())) continue;
                ((CheckboxMenuItem)item).setState(true);
            }
        }
    }

    public void dispose() {
        this.removePropertyChangeListener(this);
        this.noMessageItem = null;
        this.newMessageItem = null;
        this.clearCustomMessageItem = null;
        this.busyMessageItem = null;
        this.brbMessageItem = null;
        this.menu = null;
    }

    protected Icon getMenuIcon() {
        return null;
    }

    private class ProvisionedMessageItemsAwt
    extends CheckboxMenuItem
    implements ProvisionedMessageItems {
        public ProvisionedMessageItemsAwt(String text) {
            super(text);
        }
    }

    private class ProvisionedMessageItemsSwing
    extends JCheckBoxMenuItem
    implements ProvisionedMessageItems {
        public ProvisionedMessageItemsSwing(String text) {
            super(text);
        }
    }

    private static interface ProvisionedMessageItems {
        public String getName();
    }

    private class CustomMessageItemsAwt
    extends CheckboxMenuItem
    implements CustomMessageItems {
        public CustomMessageItemsAwt(String text) {
            super(text);
        }
    }

    private class CustomMessageItemsSwing
    extends JCheckBoxMenuItem
    implements CustomMessageItems {
        public CustomMessageItemsSwing(String text) {
            super(text);
        }
    }

    private static interface CustomMessageItems {
        public String getName();
    }
}

