/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.plugin.desktoputil.presence.avatar.imagepicker;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridLayout;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Robot;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import javax.swing.JButton;
import javax.swing.JComponent;
import net.java.sip.communicator.plugin.desktoputil.AntialiasingManager;
import net.java.sip.communicator.plugin.desktoputil.DesktopUtilActivator;
import net.java.sip.communicator.plugin.desktoputil.ImageUtils;
import net.java.sip.communicator.plugin.desktoputil.SIPCommDialog;
import net.java.sip.communicator.plugin.desktoputil.TransparentPanel;
import net.java.sip.communicator.plugin.desktoputil.presence.avatar.imagepicker.ImagePickerDialog;
import net.java.sip.communicator.util.Logger;
import org.jitsi.service.audionotifier.SCAudioClip;
import org.jitsi.service.neomedia.MediaService;
import org.jitsi.service.neomedia.MediaUseCase;
import org.jitsi.utils.MediaType;

public class WebcamDialog
extends SIPCommDialog
implements ActionListener {
    private static final Logger logger = Logger.getLogger(WebcamDialog.class);
    private Component videoContainer;
    private JButton grabSnapshot;
    private byte[] grabbedImage = null;
    private TimerImage[] timerImages = new TimerImage[3];

    public WebcamDialog(ImagePickerDialog parent) {
        super(false);
        this.setTitle(DesktopUtilActivator.getResources().getI18NString("service.gui.avatar.imagepicker.TAKE_PHOTO"));
        this.setModal(true);
        this.init();
        this.setSize(320, 240);
    }

    private void init() {
        this.grabSnapshot = new JButton();
        this.grabSnapshot.setText(DesktopUtilActivator.getResources().getI18NString("service.gui.avatar.imagepicker.CLICK"));
        this.grabSnapshot.setName("grab");
        this.grabSnapshot.addActionListener(this);
        this.grabSnapshot.setEnabled(false);
        JButton cancelButton = new JButton(DesktopUtilActivator.getResources().getI18NString("service.gui.avatar.imagepicker.CANCEL"));
        cancelButton.setName("cancel");
        cancelButton.addActionListener(this);
        this.initAccessWebcam();
        TransparentPanel timerPanel = new TransparentPanel();
        timerPanel.setLayout(new GridLayout(0, this.timerImages.length));
        for (int i = 0; i < this.timerImages.length; ++i) {
            this.timerImages[i] = new TimerImage("" + (this.timerImages.length - i));
            TransparentPanel tp = new TransparentPanel();
            tp.add(this.timerImages[i], "Center");
            timerPanel.add((Component)((Object)tp));
        }
        TransparentPanel buttonsPanel = new TransparentPanel(new FlowLayout(2));
        buttonsPanel.add(this.grabSnapshot);
        buttonsPanel.add(cancelButton);
        TransparentPanel southPanel = new TransparentPanel(new BorderLayout());
        southPanel.add((Component)((Object)timerPanel), "Center");
        southPanel.add((Component)((Object)buttonsPanel), "South");
        TransparentPanel videoPanel = new TransparentPanel(new FlowLayout(1));
        videoPanel.add(this.videoContainer);
        this.add((Component)((Object)videoPanel), "Center");
        this.add((Component)((Object)southPanel), "South");
        this.setResizable(false);
    }

    private void initAccessWebcam() {
        MediaService mediaService = DesktopUtilActivator.getMediaService();
        this.videoContainer = (Component)mediaService.getVideoPreviewComponent(mediaService.getDefaultDevice(MediaType.VIDEO, MediaUseCase.CALL), 320, 240);
        this.grabSnapshot.setEnabled(true);
    }

    private void grabSnapshot() {
        try {
            Robot robot = new Robot();
            Point location = this.videoContainer.getLocationOnScreen();
            BufferedImage bi = robot.createScreenCapture(new Rectangle(location.x, location.y, this.videoContainer.getWidth(), this.videoContainer.getHeight()));
            this.grabbedImage = ImageUtils.toByteArray(bi);
        }
        catch (Throwable e) {
            logger.error((Object)"Cannot create snapshot!", e);
        }
        this.close(false);
        this.setVisible(false);
    }

    public byte[] getGrabbedImage() {
        return this.grabbedImage;
    }

    private void playSound() {
        String soundKey = DesktopUtilActivator.getResources().getSoundPath("WEBCAM_SNAPSHOT");
        SCAudioClip audio = DesktopUtilActivator.getAudioNotifier().createAudio(soundKey);
        audio.play();
    }

    @Override
    protected void close(boolean isEscaped) {
        this.videoContainer = null;
        this.dispose();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        String actName = ((JButton)e.getSource()).getName();
        if (actName.equals("grab")) {
            this.grabSnapshot.setEnabled(false);
            new SnapshotTimer().start();
        } else {
            this.close(false);
            this.dispose();
        }
    }

    private class TimerImage
    extends JComponent {
        private static final int WIDTH = 30;
        private static final int HEIGHT = 30;
        private boolean isElapsed = false;
        private Font textFont = null;
        private String second;

        public TimerImage(String second) {
            Dimension d = new Dimension(30, 30);
            this.setPreferredSize(d);
            this.setMinimumSize(d);
            this.textFont = new Font("Sans", 1, 20);
            this.second = second;
        }

        public void setElapsed() {
            this.isElapsed = true;
            this.repaint();
        }

        @Override
        protected void paintComponent(Graphics g) {
            Graphics2D g2d = (Graphics2D)g;
            AntialiasingManager.activateAntialiasing(g);
            Color c = this.isElapsed ? Color.RED : new Color(150, 0, 0);
            g2d.setColor(c);
            g2d.fillOval(0, 0, 30, 30);
            g2d.setColor(Color.WHITE);
            g2d.setFont(this.textFont);
            g2d.drawString(this.second, 7, 21);
        }
    }

    private class SnapshotTimer
    extends Thread {
        private SnapshotTimer() {
        }

        @Override
        public void run() {
            for (int i = 0; i < WebcamDialog.this.timerImages.length; ++i) {
                WebcamDialog.this.timerImages[i].setElapsed();
                try {
                    Thread.sleep(1000L);
                    continue;
                }
                catch (InterruptedException e) {
                    logger.error((Object)"", (Throwable)e);
                }
            }
            WebcamDialog.this.playSound();
            WebcamDialog.this.grabSnapshot();
            WebcamDialog.this.setVisible(false);
            WebcamDialog.this.dispose();
        }
    }
}

