/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.impl.protocol.jabber;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.java.sip.communicator.impl.protocol.jabber.JabberAccountIDImpl;
import net.java.sip.communicator.impl.protocol.jabber.JabberActivator;
import net.java.sip.communicator.util.Logger;
import org.apache.commons.lang3.StringUtils;
import org.jivesoftware.smack.SmackConfiguration;
import org.jivesoftware.smack.SmackException;
import org.jivesoftware.smack.StanzaCollector;
import org.jivesoftware.smack.XMPPConnection;
import org.jivesoftware.smack.packet.IQ;
import org.jivesoftware.smack.packet.Presence;
import org.jivesoftware.smack.roster.Roster;
import org.jivesoftware.smack.roster.RosterEntry;
import org.jivesoftware.smackx.disco.packet.DiscoverItems;
import org.jxmpp.jid.DomainBareJid;
import org.jxmpp.jid.Jid;
import org.xmpp.jnodes.smack.SmackServiceNode;
import org.xmpp.jnodes.smack.TrackerEntry;

public class JingleNodesServiceDiscovery
implements Runnable {
    private static final Logger logger = Logger.getLogger(JingleNodesServiceDiscovery.class);
    private static final String JINGLE_NODES_SEARCH_PREFIX_PROP = "net.java.sip.communicator.impl.protocol.jabber.JINGLE_NODES_SEARCH_PREFIXES";
    private static final String JINGLE_NODES_SEARCH_PREFIXES_STOP_ON_FIRST_PROP = "net.java.sip.communicator.impl.protocol.jabber.JINGLE_NODES_SEARCH_PREFIXES_STOP_ON_FIRST";
    private final Object jingleNodesSyncRoot;
    private final SmackServiceNode service;
    private final XMPPConnection connection;
    private final JabberAccountIDImpl accountID;

    JingleNodesServiceDiscovery(SmackServiceNode service, XMPPConnection connection, JabberAccountIDImpl accountID, Object syncRoot) {
        this.jingleNodesSyncRoot = syncRoot;
        this.service = service;
        this.connection = connection;
        this.accountID = accountID;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        Object object = this.jingleNodesSyncRoot;
        synchronized (object) {
            long start = System.currentTimeMillis();
            if (logger.isInfoEnabled()) {
                logger.info((Object)"Start Jingle Nodes discovery!");
            }
            SmackServiceNode.MappedNodes nodes = null;
            String searchNodesWithPrefix = JabberActivator.getResources().getSettingsString(JINGLE_NODES_SEARCH_PREFIX_PROP);
            if (searchNodesWithPrefix == null || searchNodesWithPrefix.length() == 0) {
                searchNodesWithPrefix = JabberActivator.getConfigurationService().getString(JINGLE_NODES_SEARCH_PREFIX_PROP);
            }
            if (searchNodesWithPrefix == null || searchNodesWithPrefix.length() == 0 || searchNodesWithPrefix.equalsIgnoreCase("off")) {
                searchNodesWithPrefix = "";
            }
            try {
                nodes = this.searchServicesWithPrefix(this.service, this.connection, 6, 3, 20, "udp", this.accountID.isJingleNodesSearchBuddiesEnabled(), this.accountID.isJingleNodesAutoDiscoveryEnabled(), searchNodesWithPrefix);
            }
            catch (InterruptedException | SmackException.NotConnectedException e) {
                logger.error((Object)"Search failed", e);
            }
            if (logger.isInfoEnabled()) {
                logger.info((Object)"Jingle Nodes discovery terminated! ");
                logger.info((Object)("Found " + (nodes != null ? Integer.valueOf(nodes.getRelayEntries().size()) : "0") + " Jingle Nodes relay for account: " + this.accountID.getAccountAddress() + " in " + (System.currentTimeMillis() - start) + " ms."));
            }
            if (nodes != null) {
                this.service.addEntries(nodes);
            }
        }
    }

    private SmackServiceNode.MappedNodes searchServicesWithPrefix(SmackServiceNode service, XMPPConnection xmppConnection, int maxEntries, int maxDepth, int maxSearchNodes, String protocol, boolean searchBuddies, boolean autoDiscover, String prefix) throws SmackException.NotConnectedException, InterruptedException {
        if (xmppConnection == null || !xmppConnection.isConnected()) {
            return null;
        }
        SmackServiceNode.MappedNodes mappedNodes = new SmackServiceNode.MappedNodes();
        ConcurrentHashMap<Jid, Jid> visited = new ConcurrentHashMap<Jid, Jid>();
        for (Map.Entry entry : service.getTrackerEntries().entrySet()) {
            SmackServiceNode.deepSearch((XMPPConnection)xmppConnection, (int)maxEntries, (Jid)((TrackerEntry)entry.getValue()).getJid(), (SmackServiceNode.MappedNodes)mappedNodes, (int)(maxDepth - 1), (int)maxSearchNodes, (String)protocol, visited);
        }
        if (autoDiscover) {
            boolean continueSearch = JingleNodesServiceDiscovery.searchDiscoItems(service, xmppConnection, maxEntries, xmppConnection.getXMPPServiceDomain(), mappedNodes, maxDepth - 1, maxSearchNodes, protocol, visited, prefix);
            if (!continueSearch) {
                return mappedNodes;
            }
            SmackServiceNode.deepSearch((XMPPConnection)xmppConnection, (int)maxEntries, (Jid)xmppConnection.getXMPPServiceDomain(), (SmackServiceNode.MappedNodes)mappedNodes, (int)(maxDepth - 1), (int)maxSearchNodes, (String)protocol, visited);
            Roster r = Roster.getInstanceFor((XMPPConnection)xmppConnection);
            if (r != null && searchBuddies) {
                for (RosterEntry re : r.getEntries()) {
                    for (Presence presence : r.getPresences(re.getJid())) {
                        if (!presence.isAvailable()) continue;
                        SmackServiceNode.deepSearch((XMPPConnection)xmppConnection, (int)maxEntries, (Jid)presence.getFrom(), (SmackServiceNode.MappedNodes)mappedNodes, (int)(maxDepth - 1), (int)maxSearchNodes, (String)protocol, visited);
                    }
                }
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean searchDiscoItems(SmackServiceNode service, XMPPConnection xmppConnection, int maxEntries, DomainBareJid startPoint, SmackServiceNode.MappedNodes mappedNodes, int maxDepth, int maxSearchNodes, String protocol, ConcurrentHashMap<Jid, Jid> visited, String prefix) throws InterruptedException, SmackException.NotConnectedException {
        String[] prefixes = prefix.split(",");
        boolean stopOnFirst = true;
        String stopOnFirstDefaultValue = JabberActivator.getResources().getSettingsString(JINGLE_NODES_SEARCH_PREFIXES_STOP_ON_FIRST_PROP);
        if (stopOnFirstDefaultValue != null) {
            stopOnFirst = Boolean.parseBoolean(stopOnFirstDefaultValue);
        }
        stopOnFirst = JabberActivator.getConfigurationService().getBoolean(JINGLE_NODES_SEARCH_PREFIXES_STOP_ON_FIRST_PROP, stopOnFirst);
        DiscoverItems items = new DiscoverItems();
        items.setTo((Jid)startPoint);
        StanzaCollector collector = xmppConnection.createStanzaCollectorAndSend((IQ)items);
        DiscoverItems result = null;
        try {
            result = (DiscoverItems)collector.nextResult(Math.round((double)SmackConfiguration.getDefaultReplyTimeout() * 1.5));
        }
        finally {
            collector.cancel();
        }
        if (result != null) {
            for (DiscoverItems.Item item : result.getItems()) {
                for (String pref : prefixes) {
                    if (!StringUtils.isNotEmpty((CharSequence)pref) || !item.getEntityID().toString().startsWith(pref.trim())) continue;
                    SmackServiceNode.deepSearch((XMPPConnection)xmppConnection, (int)maxEntries, (Jid)item.getEntityID(), (SmackServiceNode.MappedNodes)mappedNodes, (int)maxDepth, (int)maxSearchNodes, (String)protocol, visited);
                    if (!stopOnFirst) continue;
                    return false;
                }
            }
            for (DiscoverItems.Item item : result.getItems()) {
                if (!visited.containsKey(item.getEntityID().toString())) {
                    SmackServiceNode.deepSearch((XMPPConnection)xmppConnection, (int)maxEntries, (Jid)item.getEntityID(), (SmackServiceNode.MappedNodes)mappedNodes, (int)maxDepth, (int)maxSearchNodes, (String)protocol, visited);
                }
                if (!stopOnFirst) continue;
                return false;
            }
        }
        return true;
    }
}

