/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.impl.protocol.jabber;

import java.io.IOException;
import java.security.GeneralSecurityException;
import javax.net.ssl.SSLContext;
import javax.net.ssl.X509ExtendedTrustManager;
import net.java.sip.communicator.impl.protocol.jabber.JabberLoginStrategy;
import net.java.sip.communicator.service.certificate.CertificateService;
import net.java.sip.communicator.service.protocol.AccountID;
import net.java.sip.communicator.service.protocol.SecurityAuthority;
import net.java.sip.communicator.service.protocol.UserCredentials;
import org.jitsi.utils.logging.Logger;
import org.jivesoftware.smack.AbstractXMPPConnection;
import org.jivesoftware.smack.ConnectionConfiguration;
import org.jivesoftware.smack.SmackException;
import org.jivesoftware.smack.XMPPException;
import org.jxmpp.jid.EntityFullJid;

class LoginByClientCertificateStrategy
implements JabberLoginStrategy {
    private static final Logger logger = Logger.getLogger(LoginByClientCertificateStrategy.class);
    private AccountID accountID;
    private ConnectionConfiguration.Builder ccBuilder;

    public LoginByClientCertificateStrategy(AccountID accountID, ConnectionConfiguration.Builder ccBuilder) {
        this.accountID = accountID;
        this.ccBuilder = ccBuilder;
    }

    @Override
    public UserCredentials prepareLogin(SecurityAuthority authority, int reasonCode) {
        return null;
    }

    @Override
    public boolean loginPreparationSuccessful() {
        this.ccBuilder.allowEmptyOrNullUsernames().setSecurityMode(ConnectionConfiguration.SecurityMode.required).addEnabledSaslMechanism("EXTERNAL");
        return true;
    }

    @Override
    public boolean isTlsRequired() {
        return true;
    }

    @Override
    public SSLContext createSslContext(CertificateService cs, X509ExtendedTrustManager trustManager) throws GeneralSecurityException {
        String certConfigName = this.accountID.getAccountPropertyString((Object)"CLIENT_TLS_CERTIFICATE");
        return cs.getSSLContext(certConfigName, trustManager);
    }

    @Override
    public boolean login(AbstractXMPPConnection connection, EntityFullJid jid) throws XMPPException, InterruptedException, IOException, SmackException {
        try {
            connection.login((CharSequence)"", "", jid.getResourceOrEmpty());
            return true;
        }
        catch (XMPPException ex) {
            if (ex.getMessage().contains("EXTERNAL failed: not-authorized")) {
                logger.error((Object)"Certificate login failed", (Throwable)ex);
                return false;
            }
            throw ex;
        }
    }

    @Override
    public ConnectionConfiguration.Builder getConnectionConfigurationBuilder() {
        return this.ccBuilder;
    }
}

