/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.impl.protocol.jabber;

import java.util.ArrayList;
import java.util.Date;
import java.util.EventObject;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.java.sip.communicator.impl.protocol.jabber.ChatRoomJabberImpl;
import net.java.sip.communicator.impl.protocol.jabber.ContactJabberImpl;
import net.java.sip.communicator.impl.protocol.jabber.ContactResourceJabberImpl;
import net.java.sip.communicator.impl.protocol.jabber.MessageJabberImpl;
import net.java.sip.communicator.impl.protocol.jabber.OperationSetMultiUserChatJabberImpl;
import net.java.sip.communicator.impl.protocol.jabber.OperationSetPersistentPresenceJabberImpl;
import net.java.sip.communicator.impl.protocol.jabber.ProtocolProviderServiceJabberImpl;
import net.java.sip.communicator.service.protocol.AbstractOperationSetBasicInstantMessaging;
import net.java.sip.communicator.service.protocol.ChatRoom;
import net.java.sip.communicator.service.protocol.Contact;
import net.java.sip.communicator.service.protocol.ContactResource;
import net.java.sip.communicator.service.protocol.OperationFailedException;
import net.java.sip.communicator.service.protocol.OperationSetMessageCorrection;
import net.java.sip.communicator.service.protocol.OperationSetMultiUserChat;
import net.java.sip.communicator.service.protocol.OperationSetPersistentPresence;
import net.java.sip.communicator.service.protocol.RegistrationState;
import net.java.sip.communicator.service.protocol.event.ChatRoomMessageDeliveryFailedEvent;
import net.java.sip.communicator.service.protocol.event.MessageDeliveredEvent;
import net.java.sip.communicator.service.protocol.event.MessageDeliveryFailedEvent;
import net.java.sip.communicator.service.protocol.event.MessageReceivedEvent;
import net.java.sip.communicator.service.protocol.event.RegistrationStateChangeEvent;
import net.java.sip.communicator.service.protocol.event.RegistrationStateChangeListener;
import net.java.sip.communicator.util.Html2Text;
import net.java.sip.communicator.util.Logger;
import org.apache.commons.lang3.RandomStringUtils;
import org.jivesoftware.smack.SmackException;
import org.jivesoftware.smack.StanzaListener;
import org.jivesoftware.smack.XMPPConnection;
import org.jivesoftware.smack.XMPPException;
import org.jivesoftware.smack.filter.AndFilter;
import org.jivesoftware.smack.filter.StanzaFilter;
import org.jivesoftware.smack.filter.StanzaTypeFilter;
import org.jivesoftware.smack.packet.ExtensionElement;
import org.jivesoftware.smack.packet.Message;
import org.jivesoftware.smack.packet.Stanza;
import org.jivesoftware.smack.packet.XMPPError;
import org.jivesoftware.smack.provider.ProviderManager;
import org.jivesoftware.smackx.carbons.CarbonCopyReceivedListener;
import org.jivesoftware.smackx.carbons.CarbonManager;
import org.jivesoftware.smackx.carbons.packet.CarbonExtension;
import org.jivesoftware.smackx.delay.DelayInformationManager;
import org.jivesoftware.smackx.message_correct.element.MessageCorrectExtension;
import org.jivesoftware.smackx.message_correct.provider.MessageCorrectProvider;
import org.jivesoftware.smackx.xevent.MessageEventManager;
import org.jivesoftware.smackx.xevent.packet.MessageEvent;
import org.jivesoftware.smackx.xhtmlim.XHTMLManager;
import org.jivesoftware.smackx.xhtmlim.XHTMLText;
import org.jivesoftware.smackx.xhtmlim.packet.XHTMLExtension;
import org.jxmpp.jid.BareJid;
import org.jxmpp.jid.Jid;
import org.jxmpp.jid.impl.JidCreate;
import org.jxmpp.stringprep.XmppStringprepException;

public class OperationSetBasicInstantMessagingJabberImpl
extends AbstractOperationSetBasicInstantMessaging
implements OperationSetMessageCorrection {
    private static final Logger logger = Logger.getLogger(OperationSetBasicInstantMessagingJabberImpl.class);
    private final Map<BareJid, StoredThreadID> jids = new Hashtable<BareJid, StoredThreadID>();
    private Map<BareJid, Jid> recentJIDForAddress = new Hashtable<BareJid, Jid>();
    private SmackMessageListener smackMessageListener = null;
    private static String prefix = RandomStringUtils.random((int)5);
    private static long id = 0L;
    private static final long JID_INACTIVITY_TIMEOUT = 600000L;
    private final ProtocolProviderServiceJabberImpl jabberProvider;
    private OperationSetPersistentPresenceJabberImpl opSetPersPresence = null;
    private static final String HTML_NAMESPACE = "http://jabber.org/protocol/xhtml-im";
    private List<StanzaFilter> packetFilters = new ArrayList<StanzaFilter>();
    private boolean isCarbonEnabled = false;

    OperationSetBasicInstantMessagingJabberImpl(ProtocolProviderServiceJabberImpl provider) {
        this.jabberProvider = provider;
        this.packetFilters.add(new GroupMessagePacketFilter());
        this.packetFilters.add((StanzaFilter)new StanzaTypeFilter(Message.class));
        provider.addRegistrationStateChangeListener(new RegistrationStateListener());
        MessageCorrectProvider extProvider = new MessageCorrectProvider();
        ProviderManager.addExtensionProvider((String)"replace", (String)"urn:xmpp:message-correct:0", (Object)extProvider);
    }

    public net.java.sip.communicator.service.protocol.Message createMessageWithUID(String messageText, String contentType, String messageUID) {
        return new MessageJabberImpl(messageText, contentType, "UTF-8", null, messageUID);
    }

    public net.java.sip.communicator.service.protocol.Message createMessage(String content, String contentType) {
        return this.createMessage(content, contentType, "UTF-8", null);
    }

    public net.java.sip.communicator.service.protocol.Message createMessage(String content, String contentType, String encoding, String subject) {
        return new MessageJabberImpl(content, contentType, encoding, subject);
    }

    net.java.sip.communicator.service.protocol.Message createMessage(String content, String contentType, String messageUID) {
        return new MessageJabberImpl(content, contentType, "UTF-8", null, messageUID);
    }

    public boolean isOfflineMessagingSupported() {
        return true;
    }

    public boolean isContentTypeSupported(String contentType) {
        return contentType.equals("text/plain") || contentType.equals("text/html");
    }

    public boolean isContentTypeSupported(String contentType, Contact contact) {
        if (contentType.equals("text/plain")) {
            return true;
        }
        if (contentType.equals("text/html")) {
            Jid contactJid;
            try {
                contactJid = JidCreate.from((String)contact.getAddress());
            }
            catch (XmppStringprepException e) {
                return false;
            }
            Jid toJID = this.recentJIDForAddress.get(contactJid);
            if (toJID == null) {
                toJID = contactJid;
            }
            return this.jabberProvider.isFeatureListSupported(toJID, HTML_NAMESPACE);
        }
        return false;
    }

    private void purgeOldJids() {
        long currentTime = System.currentTimeMillis();
        Iterator<Map.Entry<BareJid, StoredThreadID>> entries = this.jids.entrySet().iterator();
        while (entries.hasNext()) {
            Map.Entry<BareJid, StoredThreadID> entry = entries.next();
            StoredThreadID target = entry.getValue();
            if (currentTime - target.lastUpdatedTime <= 600000L) continue;
            entries.remove();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    String getThreadIDForAddress(BareJid jid) {
        Map<BareJid, StoredThreadID> map = this.jids;
        synchronized (map) {
            this.purgeOldJids();
            StoredThreadID ta = this.jids.get(jid);
            if (ta == null) {
                return null;
            }
            ta.lastUpdatedTime = System.currentTimeMillis();
            return ta.threadID;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void putJidForAddress(Jid jid, String threadID) {
        Map<BareJid, StoredThreadID> map = this.jids;
        synchronized (map) {
            this.purgeOldJids();
            StoredThreadID ta = this.jids.get(jid.asBareJid());
            if (ta == null) {
                ta = new StoredThreadID();
                this.jids.put(jid.asBareJid(), ta);
            }
            this.recentJIDForAddress.put(jid.asBareJid(), jid);
            ta.lastUpdatedTime = System.currentTimeMillis();
            ta.threadID = threadID;
        }
    }

    private MessageDeliveredEvent sendMessage(Contact to, ContactResource toResource, net.java.sip.communicator.service.protocol.Message message, ExtensionElement[] extensions) throws OperationFailedException {
        MessageDeliveredEvent msgDeliveryPendingEvt;
        MessageDeliveredEvent[] transformedEvents;
        if (!(to instanceof ContactJabberImpl)) {
            throw new IllegalArgumentException("The specified contact is not a Jabber contact." + to);
        }
        this.assertConnected();
        Message msg = new Message();
        Object toJID = null;
        if (toResource != null) {
            toJID = toResource.equals((Object)ContactResource.BASE_RESOURCE) ? ((ContactJabberImpl)to).getAddressAsJid() : ((ContactResourceJabberImpl)toResource).getFullJid();
        }
        if (toJID == null) {
            toJID = ((ContactJabberImpl)to).getAddressAsJid();
        }
        msg.setStanzaId(message.getMessageUID());
        msg.setTo(toJID);
        for (ExtensionElement ext : extensions) {
            msg.addExtension(ext);
        }
        if (logger.isTraceEnabled()) {
            logger.trace((Object)("Will send a message to:" + toJID + " chat.jid=" + toJID));
        }
        if ((transformedEvents = this.messageDeliveryPendingTransform(msgDeliveryPendingEvt = new MessageDeliveredEvent(message, to, toResource))) == null || transformedEvents.length == 0) {
            return null;
        }
        for (MessageDeliveredEvent event : transformedEvents) {
            String content = event.getSourceMessage().getContent();
            if (message.getContentType().equals("text/html")) {
                msg.setBody(Html2Text.extractText((String)content));
                if (this.jabberProvider.isFeatureListSupported((Jid)toJID, new String[]{HTML_NAMESPACE})) {
                    XHTMLManager.addBody((Message)msg, (XHTMLText)new XHTMLText(null, "en").append(content).appendCloseBodyTag());
                }
            } else {
                msg.setBody(content);
            }
            if (event.isMessageEncrypted() && this.isCarbonEnabled) {
                CarbonExtension.Private.addTo((Message)msg);
            }
            MessageEventManager.addNotificationsRequests((Message)msg, (boolean)true, (boolean)false, (boolean)false, (boolean)true);
            String threadID = this.getThreadIDForAddress(toJID.asBareJid());
            if (threadID == null) {
                threadID = OperationSetBasicInstantMessagingJabberImpl.nextThreadID();
            }
            msg.setThread(threadID);
            msg.setType(Message.Type.chat);
            msg.setFrom((Jid)this.jabberProvider.getConnection().getUser());
            try {
                this.jabberProvider.getConnection().sendStanza((Stanza)msg);
            }
            catch (InterruptedException | SmackException.NotConnectedException e) {
                throw new OperationFailedException("Could not send message", 1, e);
            }
            this.putJidForAddress((Jid)toJID, threadID);
        }
        return new MessageDeliveredEvent(message, to, toResource);
    }

    public void sendInstantMessage(Contact to, net.java.sip.communicator.service.protocol.Message message) throws IllegalStateException, IllegalArgumentException, OperationFailedException {
        this.sendInstantMessage(to, null, message);
    }

    public void sendInstantMessage(Contact to, ContactResource toResource, net.java.sip.communicator.service.protocol.Message message) throws IllegalStateException, IllegalArgumentException, OperationFailedException {
        MessageDeliveredEvent msgDelivered = this.sendMessage(to, toResource, message, new ExtensionElement[0]);
        this.fireMessageEvent((EventObject)msgDelivered);
    }

    public void correctMessage(Contact to, ContactResource resource, net.java.sip.communicator.service.protocol.Message message, String correctedMessageUID) throws OperationFailedException {
        ExtensionElement[] exts = new ExtensionElement[]{new MessageCorrectExtension(correctedMessageUID)};
        MessageDeliveredEvent msgDelivered = this.sendMessage(to, resource, message, exts);
        msgDelivered.setCorrectedMessageUID(correctedMessageUID);
        this.fireMessageEvent((EventObject)msgDelivered);
    }

    private void assertConnected() throws IllegalStateException {
        if (this.opSetPersPresence == null) {
            throw new IllegalStateException("The provider must be signed on the service before being able to communicate.");
        }
        this.opSetPersPresence.assertConnected();
    }

    private void initAdditionalServices() {
        boolean enableCarbon;
        CarbonManager cm = CarbonManager.getInstanceFor((XMPPConnection)this.jabberProvider.getConnection());
        boolean bl = enableCarbon = this.isCarbonSupported() && !this.jabberProvider.getAccountID().getAccountPropertyBoolean((Object)"CARBON_DISABLED", false);
        if (enableCarbon) {
            try {
                cm.enableCarbons();
                cm.addCarbonCopyReceivedListener(new CarbonCopyReceivedListener(){

                    public void onCarbonCopyReceived(CarbonExtension.Direction direction, Message carbonCopy, Message wrappingMessage) {
                        OperationSetBasicInstantMessagingJabberImpl.this.processMessage(carbonCopy, direction == CarbonExtension.Direction.sent);
                    }
                });
            }
            catch (InterruptedException | SmackException | XMPPException e) {
                this.isCarbonEnabled = false;
                logger.warn((Object)"Could not enable carbons", e);
            }
        } else {
            this.isCarbonEnabled = false;
        }
    }

    private boolean isCarbonSupported() {
        try {
            return CarbonManager.getInstanceFor((XMPPConnection)this.jabberProvider.getConnection()).isSupportedByServer();
        }
        catch (InterruptedException | SmackException.NoResponseException | SmackException.NotConnectedException | XMPPException e) {
            logger.warn((Object)"Failed to retrieve carbon support", e);
            return false;
        }
    }

    private void processMessage(Message msg, boolean isForwardedSentMessage) {
        Date timestamp;
        if (msg.getBody() == null) {
            return;
        }
        ExtensionElement multiChatExtension = msg.getExtension("x", "http://jabber.org/protocol/muc#user");
        if (multiChatExtension != null) {
            return;
        }
        Jid userFullId = isForwardedSentMessage ? msg.getTo() : msg.getFrom();
        BareJid userBareID = userFullId.asBareJid();
        boolean isPrivateMessaging = false;
        ChatRoomJabberImpl privateContactRoom = null;
        OperationSetMultiUserChatJabberImpl mucOpSet = (OperationSetMultiUserChatJabberImpl)this.jabberProvider.getOperationSet(OperationSetMultiUserChat.class);
        if (mucOpSet != null) {
            privateContactRoom = mucOpSet.getChatRoom(userBareID);
        }
        if (privateContactRoom != null) {
            isPrivateMessaging = true;
        }
        if (logger.isDebugEnabled() && logger.isDebugEnabled()) {
            logger.debug((Object)("Received from " + userBareID + " the message " + msg.toXML()));
        }
        net.java.sip.communicator.service.protocol.Message newMessage = this.createMessage(msg.getBody(), "text/plain", msg.getStanzaId());
        ExtensionElement ext = msg.getExtension(HTML_NAMESPACE);
        if (ext != null) {
            XHTMLExtension xhtmlExt = (XHTMLExtension)ext;
            StringBuilder messageBuff = new StringBuilder();
            for (CharSequence body : xhtmlExt.getBodies()) {
                messageBuff.append(body);
            }
            if (messageBuff.length() > 0) {
                String receivedMessage = messageBuff.toString().replaceAll("\\<[bB][oO][dD][yY].*?>", "").replaceAll("\\</[bB][oO][dD][yY].*?>", "");
                receivedMessage = receivedMessage.replaceAll("&apos;", "&#39;");
                newMessage = this.createMessage(receivedMessage, "text/html", msg.getStanzaId());
            }
        }
        ExtensionElement correctionExtension = msg.getExtension("urn:xmpp:message-correct:0");
        String correctedMessageUID = null;
        if (correctionExtension != null) {
            correctedMessageUID = ((MessageCorrectExtension)correctionExtension).getIdInitialMessage();
        }
        Object sourceContact = this.opSetPersPresence.findContactByID((Jid)(isPrivateMessaging ? userFullId : userBareID));
        if (msg.getType() == Message.Type.error) {
            MessageEvent msgEvent;
            if (isPrivateMessaging && sourceContact == null) {
                XMPPError error = msg.getError();
                int errorResultCode = 1;
                if (error != null && error.getCondition() == XMPPError.Condition.forbidden) {
                    errorResultCode = 6;
                }
                String errorReason = error.getConditionText();
                ChatRoomMessageDeliveryFailedEvent evt = new ChatRoomMessageDeliveryFailedEvent((ChatRoom)privateContactRoom, null, errorResultCode, errorReason, new Date(), newMessage);
                privateContactRoom.fireMessageEvent((EventObject)evt);
                return;
            }
            if (logger.isInfoEnabled()) {
                logger.info((Object)("Message error received from " + userBareID));
            }
            int errorResultCode = 1;
            if (msg.getError() != null && msg.getError().getCondition() == XMPPError.Condition.service_unavailable && (msgEvent = (MessageEvent)msg.getExtension("x", "jabber:x:event")) != null && msgEvent.isOffline()) {
                errorResultCode = 5;
            }
            if (sourceContact == null) {
                sourceContact = this.opSetPersPresence.createVolatileContact(userFullId, isPrivateMessaging);
            }
            MessageDeliveryFailedEvent ev = new MessageDeliveryFailedEvent(newMessage, sourceContact, correctedMessageUID, errorResultCode);
            this.fireMessageEvent((EventObject)ev);
            return;
        }
        this.putJidForAddress(userFullId, msg.getThread());
        if (sourceContact == null) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("received a message from an unknown contact: " + userBareID));
            }
            sourceContact = this.opSetPersPresence.createVolatileContact(userFullId, isPrivateMessaging);
        }
        if ((timestamp = DelayInformationManager.getDelayTimestamp((Stanza)msg)) == null) {
            timestamp = new Date();
        }
        ContactResource resource = ((ContactJabberImpl)((Object)sourceContact)).getResourceFromJid(userFullId);
        Object msgEvt = null;
        msgEvt = !isForwardedSentMessage ? new MessageReceivedEvent(newMessage, sourceContact, resource, timestamp, correctedMessageUID, isPrivateMessaging, (ChatRoom)privateContactRoom) : new MessageDeliveredEvent(newMessage, sourceContact, timestamp);
        this.fireMessageEvent((EventObject)msgEvt);
    }

    public Jid getRecentJIDForAddress(BareJid address) {
        return this.recentJIDForAddress.get(address);
    }

    public long getInactivityTimeout() {
        return 600000L;
    }

    public void addMessageFilters(StanzaFilter filter) {
        this.packetFilters.add(filter);
    }

    public static synchronized String nextThreadID() {
        return prefix + Long.toString(id++);
    }

    private static class GroupMessagePacketFilter
    implements StanzaFilter {
        private GroupMessagePacketFilter() {
        }

        public boolean accept(Stanza packet) {
            if (!(packet instanceof Message)) {
                return false;
            }
            Message msg = (Message)packet;
            return !msg.getType().equals((Object)Message.Type.groupchat);
        }
    }

    private class SmackMessageListener
    implements StanzaListener {
        private SmackMessageListener() {
        }

        public void processStanza(Stanza packet) {
            if (!(packet instanceof Message)) {
                return;
            }
            Message msg = (Message)packet;
            OperationSetBasicInstantMessagingJabberImpl.this.processMessage(msg, false);
        }
    }

    private class RegistrationStateListener
    implements RegistrationStateChangeListener {
        private RegistrationStateListener() {
        }

        public void registrationStateChanged(RegistrationStateChangeEvent evt) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("The provider changed state from: " + evt.getOldState() + " to: " + evt.getNewState()));
            }
            if (evt.getNewState() == RegistrationState.REGISTERING) {
                OperationSetBasicInstantMessagingJabberImpl.this.opSetPersPresence = (OperationSetPersistentPresenceJabberImpl)OperationSetBasicInstantMessagingJabberImpl.this.jabberProvider.getOperationSet(OperationSetPersistentPresence.class);
                if (OperationSetBasicInstantMessagingJabberImpl.this.smackMessageListener == null) {
                    OperationSetBasicInstantMessagingJabberImpl.this.smackMessageListener = new SmackMessageListener();
                } else {
                    OperationSetBasicInstantMessagingJabberImpl.this.jabberProvider.getConnection().removeAsyncStanzaListener((StanzaListener)OperationSetBasicInstantMessagingJabberImpl.this.smackMessageListener);
                }
                OperationSetBasicInstantMessagingJabberImpl.this.jabberProvider.getConnection().addAsyncStanzaListener((StanzaListener)OperationSetBasicInstantMessagingJabberImpl.this.smackMessageListener, (StanzaFilter)new AndFilter(OperationSetBasicInstantMessagingJabberImpl.this.packetFilters.toArray(new StanzaFilter[OperationSetBasicInstantMessagingJabberImpl.this.packetFilters.size()])));
            } else if (evt.getNewState() == RegistrationState.REGISTERED) {
                new Thread(new Runnable(){

                    @Override
                    public void run() {
                        OperationSetBasicInstantMessagingJabberImpl.this.initAdditionalServices();
                    }
                }).start();
            } else if (evt.getNewState() == RegistrationState.UNREGISTERED || evt.getNewState() == RegistrationState.CONNECTION_FAILED || evt.getNewState() == RegistrationState.AUTHENTICATION_FAILED) {
                if (OperationSetBasicInstantMessagingJabberImpl.this.jabberProvider.getConnection() != null && OperationSetBasicInstantMessagingJabberImpl.this.smackMessageListener != null) {
                    OperationSetBasicInstantMessagingJabberImpl.this.jabberProvider.getConnection().removeAsyncStanzaListener((StanzaListener)OperationSetBasicInstantMessagingJabberImpl.this.smackMessageListener);
                }
                OperationSetBasicInstantMessagingJabberImpl.this.smackMessageListener = null;
            }
        }
    }

    public static class StoredThreadID {
        long lastUpdatedTime;
        String threadID;
    }
}

