/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.impl.protocol.jabber;

import java.util.ArrayList;
import java.util.Iterator;
import net.java.sip.communicator.impl.protocol.jabber.ActiveCallsRepositoryJabberImpl;
import net.java.sip.communicator.impl.protocol.jabber.CallJabberImpl;
import net.java.sip.communicator.impl.protocol.jabber.CallPeerJabberImpl;
import net.java.sip.communicator.impl.protocol.jabber.ChatRoomJabberImpl;
import net.java.sip.communicator.impl.protocol.jabber.OperationSetJitsiMeetToolsJabberImpl;
import net.java.sip.communicator.impl.protocol.jabber.OperationSetPersistentPresenceJabberImpl;
import net.java.sip.communicator.impl.protocol.jabber.ProtocolProviderServiceJabberImpl;
import net.java.sip.communicator.service.protocol.AbstractCallPeer;
import net.java.sip.communicator.service.protocol.AccountID;
import net.java.sip.communicator.service.protocol.Call;
import net.java.sip.communicator.service.protocol.CallConference;
import net.java.sip.communicator.service.protocol.CallPeer;
import net.java.sip.communicator.service.protocol.CallPeerState;
import net.java.sip.communicator.service.protocol.CallState;
import net.java.sip.communicator.service.protocol.ChatRoom;
import net.java.sip.communicator.service.protocol.ConferenceDescription;
import net.java.sip.communicator.service.protocol.OperationFailedException;
import net.java.sip.communicator.service.protocol.OperationSetAdvancedTelephony;
import net.java.sip.communicator.service.protocol.OperationSetJitsiMeetTools;
import net.java.sip.communicator.service.protocol.OperationSetMultiUserChat;
import net.java.sip.communicator.service.protocol.OperationSetSecureSDesTelephony;
import net.java.sip.communicator.service.protocol.OperationSetSecureZrtpTelephony;
import net.java.sip.communicator.service.protocol.PresenceStatus;
import net.java.sip.communicator.service.protocol.RegistrationState;
import net.java.sip.communicator.service.protocol.TransferAuthority;
import net.java.sip.communicator.service.protocol.event.CallChangeEvent;
import net.java.sip.communicator.service.protocol.event.CallChangeListener;
import net.java.sip.communicator.service.protocol.event.CallPeerEvent;
import net.java.sip.communicator.service.protocol.event.RegistrationStateChangeEvent;
import net.java.sip.communicator.service.protocol.event.RegistrationStateChangeListener;
import net.java.sip.communicator.service.protocol.media.AbstractOperationSetBasicTelephony;
import net.java.sip.communicator.service.protocol.media.MediaAwareCallPeer;
import net.java.sip.communicator.util.Logger;
import org.jitsi.xmpp.extensions.condesc.CallIdExtension;
import org.jitsi.xmpp.extensions.jingle.CoinPacketExtension;
import org.jitsi.xmpp.extensions.jingle.JingleAction;
import org.jitsi.xmpp.extensions.jingle.JingleIQ;
import org.jitsi.xmpp.extensions.jingle.JingleIQProvider;
import org.jitsi.xmpp.extensions.jingle.Reason;
import org.jitsi.xmpp.extensions.jingle.ReasonPacketExtension;
import org.jitsi.xmpp.extensions.jingle.RtpDescriptionPacketExtension;
import org.jitsi.xmpp.extensions.jingle.SessionInfoPacketExtension;
import org.jitsi.xmpp.extensions.jingle.TransferPacketExtension;
import org.jivesoftware.smack.SmackException;
import org.jivesoftware.smack.StanzaListener;
import org.jivesoftware.smack.XMPPConnection;
import org.jivesoftware.smack.XMPPException;
import org.jivesoftware.smack.filter.StanzaFilter;
import org.jivesoftware.smack.iqrequest.AbstractIqRequestHandler;
import org.jivesoftware.smack.iqrequest.IQRequestHandler;
import org.jivesoftware.smack.packet.ExtensionElement;
import org.jivesoftware.smack.packet.IQ;
import org.jivesoftware.smack.packet.Presence;
import org.jivesoftware.smack.packet.StandardExtensionElement;
import org.jivesoftware.smack.packet.Stanza;
import org.jivesoftware.smack.packet.XMPPError;
import org.jivesoftware.smack.provider.ProviderManager;
import org.jivesoftware.smack.roster.Roster;
import org.jivesoftware.smackx.disco.packet.DiscoverInfo;
import org.jxmpp.jid.EntityFullJid;
import org.jxmpp.jid.Jid;
import org.jxmpp.jid.impl.JidCreate;
import org.jxmpp.stringprep.XmppStringprepException;

public class OperationSetBasicTelephonyJabberImpl
extends AbstractOperationSetBasicTelephony<ProtocolProviderServiceJabberImpl>
implements RegistrationStateChangeListener,
StanzaListener,
StanzaFilter,
OperationSetSecureSDesTelephony,
OperationSetSecureZrtpTelephony,
OperationSetAdvancedTelephony<ProtocolProviderServiceJabberImpl> {
    private static final Logger logger = Logger.getLogger(OperationSetBasicTelephonyJabberImpl.class);
    private final ProtocolProviderServiceJabberImpl protocolProvider;
    private ActiveCallsRepositoryJabberImpl activeCallsRepository = new ActiveCallsRepositoryJabberImpl(this);
    private final JingleIqSetRequestHandler setRequestHandler = new JingleIqSetRequestHandler();
    private static final String GOOGLE_VOICE_DOMAIN = "voice.google.com";

    public OperationSetBasicTelephonyJabberImpl(ProtocolProviderServiceJabberImpl protocolProvider) {
        this.protocolProvider = protocolProvider;
        this.protocolProvider.addRegistrationStateChangeListener(this);
    }

    public void registrationStateChanged(RegistrationStateChangeEvent evt) {
        RegistrationState registrationState = evt.getNewState();
        if (registrationState == RegistrationState.REGISTERING) {
            ProviderManager.addIQProvider((String)"jingle", (String)"urn:xmpp:jingle:1", (Object)new JingleIQProvider());
            this.subscribeForJinglePackets();
            if (logger.isInfoEnabled()) {
                logger.info((Object)"Jingle : ON ");
            }
        } else if (registrationState == RegistrationState.UNREGISTERED) {
            this.unsubscribeForJinglePackets();
            if (logger.isInfoEnabled()) {
                logger.info((Object)"Jingle : OFF ");
            }
        }
    }

    public Call createCall(String callee, CallConference conference) throws OperationFailedException {
        AbstractCallPeer<?, ?> callPeer;
        CallJabberImpl call = new CallJabberImpl(this);
        if (conference != null) {
            call.setConference(conference);
        }
        if ((callPeer = this.createOutgoingCall(call, callee)) == null) {
            throw new OperationFailedException("Failed to create outgoing call because no peer was created", 4);
        }
        Call callOfCallPeer = callPeer.getCall();
        if (callOfCallPeer != call && conference != null) {
            callOfCallPeer.setConference(conference);
        }
        return callOfCallPeer;
    }

    public CallJabberImpl createCall(ConferenceDescription cd, final ChatRoom chatRoom) throws OperationFailedException {
        Jid remoteJid;
        final CallJabberImpl call = new CallJabberImpl(this);
        ((ChatRoomJabberImpl)chatRoom).addConferenceCall(call);
        call.addCallChangeListener(new CallChangeListener(){

            public void callPeerAdded(CallPeerEvent ev) {
            }

            public void callPeerRemoved(CallPeerEvent ev) {
            }

            public void callStateChanged(CallChangeEvent ev) {
                if (CallState.CALL_ENDED.equals(ev.getNewValue())) {
                    ((ChatRoomJabberImpl)chatRoom).removeConferenceCall(call);
                }
            }
        });
        String remoteUri = cd.getUri();
        if (remoteUri.startsWith("xmpp:")) {
            remoteUri = remoteUri.substring(5, remoteUri.length());
        }
        try {
            remoteJid = JidCreate.from((String)remoteUri);
        }
        catch (XmppStringprepException e) {
            throw new OperationFailedException("Invalid remote JID", 1, (Throwable)e);
        }
        ArrayList<ExtensionElement> sessionInitiateExtensions = new ArrayList<ExtensionElement>(2);
        String callid = cd.getCallId();
        if (callid != null) {
            sessionInitiateExtensions.add((ExtensionElement)new CallIdExtension(callid));
        }
        call.initiateSession(remoteJid, null, sessionInitiateExtensions, cd.getSupportedTransports());
        return call;
    }

    AbstractCallPeer<?, ?> createOutgoingCall(CallJabberImpl call, String calleeAddress) throws OperationFailedException {
        return this.createOutgoingCall(call, calleeAddress, null);
    }

    AbstractCallPeer<?, ?> createOutgoingCall(CallJabberImpl call, String calleeAddress, Iterable<ExtensionElement> sessionInitiateExtensions) throws OperationFailedException {
        if (calleeAddress.contains("/")) {
            return this.createOutgoingCall(call, calleeAddress, calleeAddress, sessionInitiateExtensions);
        }
        return this.createOutgoingCall(call, calleeAddress, null, sessionInitiateExtensions);
    }

    AbstractCallPeer<?, ?> createOutgoingCall(CallJabberImpl call, String calleeAddress, String fullCalleeURI, Iterable<ExtensionElement> sessionInitiateExtensions) throws OperationFailedException {
        Jid calleeJid;
        String bypassDomain;
        if (logger.isInfoEnabled()) {
            logger.info((Object)("Creating outgoing call to " + calleeAddress));
        }
        if (this.protocolProvider.getConnection() == null || call == null) {
            throw new OperationFailedException("Failed to create OutgoingJingleSession. We don't have a valid XMPPConnection.", 4);
        }
        boolean isGoogle = this.protocolProvider.isGmailOrGoogleAppsAccount();
        boolean isGoogleVoice = false;
        if (isGoogle) {
            if (!calleeAddress.contains("@")) {
                calleeAddress = calleeAddress + "@voice.google.com";
                isGoogleVoice = true;
            } else if (calleeAddress.endsWith(GOOGLE_VOICE_DOMAIN)) {
                isGoogleVoice = true;
            }
        }
        AccountID accountID = this.getProtocolProvider().getAccountID();
        if (calleeAddress.indexOf(64) == -1) {
            String phoneSuffix = accountID.getAccountPropertyString((Object)"OVERRIDE_PHONE_SUFFIX");
            String serviceName = null;
            if (phoneSuffix == null || phoneSuffix.length() == 0) {
                try {
                    serviceName = JidCreate.from((String)accountID.getUserID()).getDomain().toString();
                }
                catch (XmppStringprepException e) {
                    throw new OperationFailedException("UserID is not a valid JID", 1, (Throwable)e);
                }
            } else {
                serviceName = phoneSuffix;
            }
            calleeAddress = calleeAddress + "@" + serviceName;
        }
        boolean alwaysCallGtalk = (bypassDomain = accountID.getAccountPropertyString((Object)"TELEPHONY_BYPASS_GTALK_CAPS")) != null && bypassDomain.equals(calleeAddress.substring(calleeAddress.indexOf(64) + 1)) || isGoogleVoice;
        boolean isPrivateMessagingContact = false;
        OperationSetMultiUserChat mucOpSet = (OperationSetMultiUserChat)this.getProtocolProvider().getOperationSet(OperationSetMultiUserChat.class);
        if (mucOpSet != null) {
            isPrivateMessagingContact = mucOpSet.isPrivateMessagingContact(calleeAddress);
        }
        try {
            calleeJid = JidCreate.from((String)calleeAddress);
        }
        catch (XmppStringprepException e) {
            throw new OperationFailedException(calleeAddress + " for callee address is not a valid JID", 1, (Throwable)e);
        }
        Roster r = Roster.getInstanceFor((XMPPConnection)this.getProtocolProvider().getConnection());
        if (!(r.contains(calleeJid.asBareJid()) || isPrivateMessagingContact || alwaysCallGtalk)) {
            throw new OperationFailedException(calleeAddress + " does not belong to our contact list", 404);
        }
        EntityFullJid fullCalleeJid = null;
        try {
            fullCalleeJid = JidCreate.entityFullFrom((String)fullCalleeURI);
        }
        catch (XmppStringprepException xmppStringprepException) {
            // empty catch block
        }
        if (fullCalleeJid == null) {
            fullCalleeJid = this.discoverFullJid(calleeJid);
        }
        if (fullCalleeJid == null) {
            throw new OperationFailedException("Failed to create outgoing call to " + calleeAddress + ". Could not find a resource which supports Jingle", 4);
        }
        DiscoverInfo di = null;
        try {
            di = this.protocolProvider.getDiscoveryManager().discoverInfo((Jid)fullCalleeJid);
        }
        catch (InterruptedException | SmackException.NoResponseException | SmackException.NotConnectedException | XMPPException ex) {
            logger.warn((Object)("could not retrieve info for " + fullCalleeJid), ex);
        }
        if (di != null) {
            if (logger.isInfoEnabled()) {
                logger.info((Object)(fullCalleeJid + ": jingle supported "));
            }
        } else {
            if (logger.isInfoEnabled()) {
                logger.info((Object)(fullCalleeJid + ": jingle not supported?"));
            }
            throw new OperationFailedException("Failed to create an outgoing call.\n" + fullCalleeJid + " does not support jingle", 4);
        }
        CallPeerJabberImpl peer = null;
        try {
            peer = call.initiateSession((Jid)fullCalleeJid, di, sessionInitiateExtensions, null);
        }
        catch (Throwable t) {
            if (t instanceof ThreadDeath) {
                throw (ThreadDeath)t;
            }
            ProtocolProviderServiceJabberImpl.throwOperationFailedException("Failed to create a call to " + fullCalleeJid, 4, t, logger);
        }
        return peer;
    }

    private EntityFullJid discoverFullJid(Jid calleeAddress) {
        Jid fullCalleeURI = null;
        DiscoverInfo discoverInfo = null;
        int bestPriority = -1;
        PresenceStatus jabberStatus = null;
        Roster r = Roster.getInstanceFor((XMPPConnection)this.getProtocolProvider().getConnection());
        for (Presence presence : r.getPresences(calleeAddress.asBareJid())) {
            PresenceStatus tempStatus;
            int priority = presence.getPriority() == Integer.MIN_VALUE ? 0 : presence.getPriority();
            Jid calleeURI = presence.getFrom();
            try {
                discoverInfo = this.protocolProvider.getDiscoveryManager().discoverInfo(calleeURI);
            }
            catch (InterruptedException | SmackException.NoResponseException | SmackException.NotConnectedException | XMPPException ex) {
                logger.warn((Object)("could not retrieve info for " + fullCalleeURI), ex);
            }
            if (discoverInfo == null || !discoverInfo.containsFeature((CharSequence)"urn:xmpp:jingle:1")) continue;
            if (priority > bestPriority) {
                bestPriority = priority;
                fullCalleeURI = calleeURI;
                jabberStatus = OperationSetPersistentPresenceJabberImpl.jabberStatusToPresenceStatus(presence, this.protocolProvider);
                continue;
            }
            if (priority != bestPriority || jabberStatus == null || (tempStatus = OperationSetPersistentPresenceJabberImpl.jabberStatusToPresenceStatus(presence, this.protocolProvider)).compareTo(jabberStatus) <= 0) continue;
            fullCalleeURI = calleeURI;
            jabberStatus = tempStatus;
        }
        if (logger.isInfoEnabled()) {
            logger.info((Object)("Full JID for outgoing call: " + fullCalleeURI + ", priority " + bestPriority));
        }
        return fullCalleeURI.asEntityFullJidOrThrow();
    }

    EntityFullJid getFullCalleeURI(String calleeAddress) {
        try {
            Jid calleeJid = JidCreate.from((String)calleeAddress);
            if (calleeJid.isEntityFullJid()) {
                return calleeJid.asEntityFullJidOrThrow();
            }
            Roster r = Roster.getInstanceFor((XMPPConnection)this.protocolProvider.getConnection());
            return r.getPresence(calleeJid.asBareJid()).getFrom().asEntityFullJidOrThrow();
        }
        catch (XmppStringprepException e) {
            throw new IllegalArgumentException("calleeAddress is not a valid JID", e);
        }
    }

    public Iterator<CallJabberImpl> getActiveCalls() {
        return this.activeCallsRepository.getActiveCalls();
    }

    public CallPeerJabberImpl getActiveCallPeer(String sid) {
        return this.activeCallsRepository.findCallPeer(sid);
    }

    public synchronized void putOffHold(CallPeer peer) throws OperationFailedException {
        this.putOnHold(peer, false);
    }

    public synchronized void putOnHold(CallPeer peer) throws OperationFailedException {
        this.putOnHold(peer, true);
    }

    private void putOnHold(CallPeer peer, boolean on) throws OperationFailedException {
        if (peer instanceof CallPeerJabberImpl) {
            ((CallPeerJabberImpl)peer).putOnHold(on);
        }
    }

    public synchronized void hangupCallPeer(CallPeer peer) throws ClassCastException, OperationFailedException {
        this.hangupCallPeer(peer, 200, null);
    }

    public void hangupCallPeer(CallPeer peer, int reasonCode, String reasonText) throws OperationFailedException {
        Reason reason;
        boolean failed = reasonCode != 200;
        ReasonPacketExtension reasonPacketExt = null;
        if (failed && reasonText != null && (reason = OperationSetBasicTelephonyJabberImpl.convertReasonCodeToSIPCode(reasonCode)) != null) {
            reasonPacketExt = new ReasonPacketExtension(reason, reasonText, null);
        }
        if (peer instanceof CallPeerJabberImpl) {
            try {
                ((CallPeerJabberImpl)peer).hangup(failed, reasonText, (ExtensionElement)reasonPacketExt);
            }
            catch (InterruptedException | SmackException.NotConnectedException e) {
                throw new OperationFailedException("Could not hang up", 1, e);
            }
        }
    }

    private static Reason convertReasonCodeToSIPCode(int reasonCode) {
        switch (reasonCode) {
            case 200: {
                return Reason.SUCCESS;
            }
            case 609: {
                return Reason.SECURITY_ERROR;
            }
            case 408: {
                return Reason.TIMEOUT;
            }
            case 486: {
                return Reason.BUSY;
            }
        }
        return null;
    }

    public void answerCallPeer(CallPeer peer) throws OperationFailedException {
        if (peer instanceof CallPeerJabberImpl) {
            ((CallPeerJabberImpl)peer).answer();
        }
    }

    public void shutdown() {
        if (logger.isTraceEnabled()) {
            logger.trace((Object)"Ending all active calls. ");
        }
        Iterator activeCalls = this.activeCallsRepository.getActiveCalls();
        while (activeCalls.hasNext()) {
            CallJabberImpl call = (CallJabberImpl)((Object)activeCalls.next());
            Iterator callPeers = call.getCallPeers();
            while (callPeers.hasNext()) {
                CallPeer peer = (CallPeer)callPeers.next();
                try {
                    this.hangupCallPeer(peer);
                }
                catch (Exception ex) {
                    logger.warn((Object)("Failed to properly hangup peer " + peer), (Throwable)ex);
                }
            }
        }
    }

    private void subscribeForJinglePackets() {
        XMPPConnection conn = this.protocolProvider.getConnection();
        conn.addAsyncStanzaListener((StanzaListener)this, (StanzaFilter)this);
        conn.registerIQRequestHandler((IQRequestHandler)this.setRequestHandler);
    }

    private void unsubscribeForJinglePackets() {
        XMPPConnection connection = this.protocolProvider.getConnection();
        if (connection != null) {
            connection.removeAsyncStanzaListener((StanzaListener)this);
            connection.unregisterIQRequestHandler((IQRequestHandler)this.setRequestHandler);
        }
    }

    public boolean accept(Stanza packet) {
        if (!(packet instanceof JingleIQ)) {
            XMPPError error;
            String packetID = packet.getStanzaId();
            CallPeerJabberImpl callPeer = this.activeCallsRepository.findCallPeerBySessInitPacketID(packetID);
            if (callPeer != null && (error = packet.getError()) != null) {
                String message;
                logger.error((Object)("Received an error: condition=" + error.getCondition() + " message=" + error.getConditionText()));
                if (error.getConditionText() == null) {
                    Roster roster = Roster.getInstanceFor((XMPPConnection)this.getProtocolProvider().getConnection());
                    Jid packetFrom = packet.getFrom();
                    message = "Service unavailable";
                    if (!roster.contains(packetFrom.asBareJid())) {
                        message = message + ": try adding the contact " + packetFrom + " to your contact list first.";
                    }
                } else {
                    message = error.getConditionText();
                }
                callPeer.setState(CallPeerState.FAILED, message);
            }
            return false;
        }
        JingleIQ jingleIQ = (JingleIQ)packet;
        if (jingleIQ.getAction() == JingleAction.SESSION_INITIATE) {
            return jingleIQ.containsContentChildOfType(RtpDescriptionPacketExtension.class);
        }
        String sid = jingleIQ.getSID();
        return this.activeCallsRepository.findSID(sid) != null;
    }

    public void processStanza(Stanza packet) {
        block4: {
            IQ iq = (IQ)packet;
            try {
                if (iq instanceof JingleIQ) {
                    this.processJingleIQError((JingleIQ)iq);
                }
            }
            catch (Throwable t) {
                if (logger.isInfoEnabled()) {
                    String packetClass = iq instanceof JingleIQ ? "Jingle" : packet.getClass().getSimpleName();
                    logger.info((Object)("Error while handling incoming " + packetClass + " packet: "), t);
                }
                if (!(t instanceof ThreadDeath)) break block4;
                throw (ThreadDeath)t;
            }
        }
    }

    private void processJingleIQ(final JingleIQ jingleIQ) throws SmackException.NotConnectedException, InterruptedException {
        CallPeerJabberImpl callPeer = this.activeCallsRepository.findCallPeer(jingleIQ.getSID());
        JingleAction action = jingleIQ.getAction();
        if (action == JingleAction.SESSION_INITIATE) {
            String callid;
            CallPeerJabberImpl attendant;
            CallJabberImpl attendantCall;
            String sid;
            StandardExtensionElement startMutedExt = (StandardExtensionElement)jingleIQ.getExtension("startmuted", "http://jitsi.org/jitmeet/start-muted");
            if (startMutedExt != null) {
                ProtocolProviderServiceJabberImpl protocolProvider = this.getProtocolProvider();
                OperationSetJitsiMeetToolsJabberImpl operationSetJitsiMeetTools = (OperationSetJitsiMeetToolsJabberImpl)protocolProvider.getOperationSet(OperationSetJitsiMeetTools.class);
                if (operationSetJitsiMeetTools != null) {
                    boolean[] startMutedFlags = new boolean[]{Boolean.parseBoolean(startMutedExt.getAttributeValue("audio")), Boolean.parseBoolean(startMutedExt.getAttributeValue("video"))};
                    operationSetJitsiMeetTools.notifySessionStartMuted(startMutedFlags);
                } else {
                    logger.warn((Object)"StartMutedPacketExtension not handled!OperationSetJitsiMeetTools not available.");
                }
            }
            TransferPacketExtension transfer = (TransferPacketExtension)jingleIQ.getExtension("transfer", "urn:xmpp:jingle:transfer:0");
            CallIdExtension callidExt = (CallIdExtension)jingleIQ.getExtension("callid", "http://jitsi.org/protocol/condesc");
            CallJabberImpl call = null;
            if (transfer != null && (sid = transfer.getSID()) != null && (attendantCall = this.getActiveCallsRepository().findSID(sid)) != null && (attendant = attendantCall.getPeer(sid)) != null && this.getFullCalleeURI(attendant.getAddress()).equals((CharSequence)transfer.getFrom()) && this.protocolProvider.getOurJID().equals((CharSequence)transfer.getTo())) {
                call = attendantCall;
            }
            if (callidExt != null && (callid = callidExt.getText()) != null) {
                call = this.getActiveCallsRepository().findCallId(callid);
            }
            if (transfer != null && callidExt != null) {
                logger.warn((Object)"Received a session-initiate with both 'transfer' and 'callid' extensions. Ignored 'transfer' and used 'callid'.");
            }
            if (call == null) {
                call = new CallJabberImpl(this);
            }
            final CallJabberImpl finalCall = call;
            new Thread(){

                @Override
                public void run() {
                    finalCall.processSessionInitiate(jingleIQ);
                }
            }.start();
            return;
        }
        if (callPeer == null) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"Received a stray trying response.");
            }
            return;
        }
        if (action == JingleAction.SESSION_TERMINATE) {
            callPeer.processSessionTerminate(jingleIQ);
        } else if (action == JingleAction.SESSION_ACCEPT) {
            callPeer.processSessionAccept(jingleIQ);
        } else if (action == JingleAction.SESSION_INFO) {
            SessionInfoPacketExtension info = jingleIQ.getSessionInfo();
            if (info != null) {
                callPeer.processSessionInfo(info);
            } else {
                ExtensionElement packetExtension = jingleIQ.getExtension("transfer", "urn:xmpp:jingle:transfer:0");
                if (packetExtension instanceof TransferPacketExtension) {
                    TransferPacketExtension transfer = (TransferPacketExtension)packetExtension;
                    if (transfer.getFrom() == null) {
                        transfer.setFrom(jingleIQ.getFrom());
                    }
                    try {
                        callPeer.processTransfer(transfer);
                    }
                    catch (OperationFailedException ofe) {
                        logger.error((Object)("Failed to transfer to " + transfer.getTo()), (Throwable)ofe);
                    }
                }
                if ((packetExtension = jingleIQ.getExtension("conference-info", "urn:xmpp:coin:1")) instanceof CoinPacketExtension) {
                    CoinPacketExtension coinExt = (CoinPacketExtension)packetExtension;
                    callPeer.setConferenceFocus(Boolean.parseBoolean(coinExt.getAttributeAsString("isfocus")));
                }
            }
        } else if (action == JingleAction.CONTENT_ACCEPT) {
            callPeer.processContentAccept(jingleIQ);
        } else if (action == JingleAction.CONTENT_ADD) {
            callPeer.processContentAdd(jingleIQ);
        } else if (action == JingleAction.CONTENT_MODIFY) {
            callPeer.processContentModify(jingleIQ);
        } else if (action == JingleAction.CONTENT_REJECT) {
            callPeer.processContentReject(jingleIQ);
        } else if (action == JingleAction.CONTENT_REMOVE) {
            callPeer.processContentRemove(jingleIQ);
        } else if (action == JingleAction.TRANSPORT_INFO) {
            callPeer.processTransportInfo(jingleIQ);
        } else if (action == JingleAction.SOURCEADD) {
            callPeer.processSourceAdd(jingleIQ);
        } else if (action == JingleAction.SOURCEREMOVE) {
            callPeer.processSourceRemove(jingleIQ);
        }
    }

    private void processJingleIQError(JingleIQ jingleIQ) {
        CallPeerJabberImpl callPeer = this.activeCallsRepository.findCallPeer(jingleIQ.getSID());
        XMPPError error = jingleIQ.getError();
        String message = "Remote party returned an error!";
        if (error != null) {
            String errorStr = "code=" + error.getCondition() + " message=" + error.getConditionText();
            message = message + "\n" + errorStr;
        }
        logger.error((Object)message);
        if (callPeer != null) {
            callPeer.setState(CallPeerState.FAILED, message);
        }
    }

    protected ActiveCallsRepositoryJabberImpl getActiveCallsRepository() {
        return this.activeCallsRepository;
    }

    public ProtocolProviderServiceJabberImpl getProtocolProvider() {
        return this.protocolProvider;
    }

    public boolean isSecure(CallPeer peer) {
        return ((MediaAwareCallPeer)peer).getMediaHandler().isSecure();
    }

    public void transfer(CallPeer peer, CallPeer target) throws OperationFailedException {
        CallPeerJabberImpl jabberTarget = (CallPeerJabberImpl)target;
        EntityFullJid to = this.getFullCalleeURI(jabberTarget.getAddress());
        try {
            DiscoverInfo discoverInfo = this.protocolProvider.getDiscoveryManager().discoverInfo((Jid)to);
            if (!discoverInfo.containsFeature((CharSequence)"urn:xmpp:jingle:transfer:0")) {
                throw new OperationFailedException("Callee " + to + " does not support XEP-0251: Jingle Session Transfer", 4);
            }
        }
        catch (InterruptedException | SmackException.NoResponseException | SmackException.NotConnectedException | XMPPException xmppe) {
            logger.warn((Object)("Failed to retrieve DiscoverInfo for " + to), xmppe);
        }
        this.transfer(peer, to, jabberTarget.getSID());
    }

    public void transfer(CallPeer peer, String target) throws OperationFailedException {
        EntityFullJid targetJid = this.getFullCalleeURI(target);
        this.transfer(peer, targetJid, null);
    }

    private void transfer(CallPeer peer, EntityFullJid to, String sid) throws OperationFailedException {
        EntityFullJid caller = this.getFullCalleeURI(peer.getAddress());
        try {
            DiscoverInfo discoverInfo = this.protocolProvider.getDiscoveryManager().discoverInfo((Jid)caller);
            if (!discoverInfo.containsFeature((CharSequence)"urn:xmpp:jingle:transfer:0")) {
                throw new OperationFailedException("Caller " + caller + " does not support XEP-0251: Jingle Session Transfer", 4);
            }
        }
        catch (InterruptedException | SmackException.NoResponseException | SmackException.NotConnectedException | XMPPException xmppe) {
            logger.warn((Object)("Failed to retrieve DiscoverInfo for " + to), xmppe);
        }
        ((CallPeerJabberImpl)peer).transfer((Jid)to, sid);
    }

    public void setTransferAuthority(TransferAuthority authority) {
    }

    private class JingleIqSetRequestHandler
    extends AbstractIqRequestHandler {
        protected JingleIqSetRequestHandler() {
            super("jingle", "urn:xmpp:jingle:1", IQ.Type.set, IQRequestHandler.Mode.sync);
        }

        public IQ handleIQRequest(IQ iq) {
            try {
                OperationSetBasicTelephonyJabberImpl.this.protocolProvider.getConnection().sendStanza((Stanza)IQ.createResultIQ((IQ)iq));
                OperationSetBasicTelephonyJabberImpl.this.processJingleIQ((JingleIQ)iq);
            }
            catch (Exception e) {
                logger.error((Object)("Error while handling incoming " + iq.getClass() + " packet: "), (Throwable)e);
            }
            return null;
        }
    }
}

