/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.impl.protocol.jabber;

import java.awt.Dimension;
import java.awt.event.ComponentEvent;
import java.awt.event.InputEvent;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.util.List;
import net.java.sip.communicator.impl.protocol.jabber.CallPeerJabberImpl;
import net.java.sip.communicator.impl.protocol.jabber.OperationSetDesktopSharingServerJabberImpl;
import net.java.sip.communicator.impl.protocol.jabber.ProtocolProviderServiceJabberImpl;
import net.java.sip.communicator.service.protocol.AbstractOperationSetDesktopSharingClient;
import net.java.sip.communicator.service.protocol.CallPeer;
import net.java.sip.communicator.service.protocol.ProtocolProviderService;
import net.java.sip.communicator.service.protocol.event.RegistrationStateChangeEvent;
import net.java.sip.communicator.service.protocol.event.RegistrationStateChangeListener;
import net.java.sip.communicator.service.protocol.event.RemoteControlListener;
import net.java.sip.communicator.util.Logger;
import org.jitsi.xmpp.extensions.inputevt.InputEvtAction;
import org.jitsi.xmpp.extensions.inputevt.InputEvtIQ;
import org.jitsi.xmpp.extensions.inputevt.RemoteControlExtension;
import org.jivesoftware.smack.SmackException;
import org.jivesoftware.smack.iqrequest.IQRequestHandler;
import org.jivesoftware.smack.packet.IQ;
import org.jivesoftware.smack.packet.Stanza;
import org.jivesoftware.smackx.disco.packet.DiscoverInfo;
import org.jxmpp.jid.Jid;

public class OperationSetDesktopSharingClientJabberImpl
extends AbstractOperationSetDesktopSharingClient<ProtocolProviderServiceJabberImpl>
implements RegistrationStateChangeListener,
IQRequestHandler {
    private static final Logger logger = Logger.getLogger(OperationSetDesktopSharingClientJabberImpl.class);

    public OperationSetDesktopSharingClientJabberImpl(ProtocolProviderServiceJabberImpl parentProvider) {
        super((ProtocolProviderService)parentProvider);
        parentProvider.addRegistrationStateChangeListener(this);
    }

    public void sendKeyboardEvent(CallPeer callPeer, KeyEvent event) {
        RemoteControlExtension payload = new RemoteControlExtension((ComponentEvent)event);
        this.sendRemoteControlExtension(callPeer, payload);
    }

    public void sendMouseEvent(CallPeer callPeer, MouseEvent event) {
        RemoteControlExtension payload = new RemoteControlExtension((ComponentEvent)event);
        this.sendRemoteControlExtension(callPeer, payload);
    }

    public void sendMouseEvent(CallPeer callPeer, MouseEvent event, Dimension videoPanelSize) {
        RemoteControlExtension payload = new RemoteControlExtension((InputEvent)event, videoPanelSize);
        this.sendRemoteControlExtension(callPeer, payload);
    }

    private void sendRemoteControlExtension(CallPeer callPeer, RemoteControlExtension payload) {
        DiscoverInfo discoverInfo = ((CallPeerJabberImpl)callPeer).getDiscoveryInfo();
        if (((ProtocolProviderServiceJabberImpl)this.parentProvider).getDiscoveryManager().includesFeature("http://jitsi.org/protocol/inputevt/sharee") && discoverInfo != null && discoverInfo.containsFeature((CharSequence)"http://jitsi.org/protocol/inputevt/sharer")) {
            InputEvtIQ inputIQ = new InputEvtIQ();
            inputIQ.setAction(InputEvtAction.NOTIFY);
            inputIQ.setType(IQ.Type.set);
            inputIQ.setFrom(((ProtocolProviderServiceJabberImpl)this.parentProvider).getOurJID());
            inputIQ.setTo(((CallPeerJabberImpl)callPeer).getAddressAsJid());
            inputIQ.addRemoteControl(payload);
            try {
                ((ProtocolProviderServiceJabberImpl)this.parentProvider).getConnection().sendStanza((Stanza)inputIQ);
            }
            catch (InterruptedException | SmackException.NotConnectedException e) {
                logger.error((Object)"Could not send remote control event", e);
            }
        }
    }

    public void registrationStateChanged(RegistrationStateChangeEvent evt) {
        OperationSetDesktopSharingServerJabberImpl.registrationStateChanged(evt, this, ((ProtocolProviderServiceJabberImpl)this.parentProvider).getConnection());
    }

    protected CallPeer getListenerCallPeer(Jid callPeerAddress) {
        List listeners = this.getListeners();
        for (RemoteControlListener listener : listeners) {
            CallPeerJabberImpl callPeer = (CallPeerJabberImpl)listener.getCallPeer();
            if (!callPeer.getAddress().equals(callPeerAddress.toString())) continue;
            return callPeer;
        }
        return null;
    }

    public IQ handleIQRequest(IQ iqRequest) {
        Jid callPeerID;
        InputEvtIQ inputIQ = (InputEvtIQ)iqRequest;
        if (inputIQ.getAction() != InputEvtAction.NOTIFY && (callPeerID = inputIQ.getFrom()) != null) {
            CallPeer callPeer = this.getListenerCallPeer(callPeerID);
            if (callPeer != null) {
                if (inputIQ.getAction() == InputEvtAction.START) {
                    this.fireRemoteControlGranted(callPeer);
                } else if (inputIQ.getAction() == InputEvtAction.STOP) {
                    this.fireRemoteControlRevoked(callPeer);
                }
            } else {
                this.addAddDeferredRemoteControlPeer(callPeerID.toString());
            }
        }
        return IQ.createResultIQ((IQ)inputIQ);
    }

    public IQRequestHandler.Mode getMode() {
        return IQRequestHandler.Mode.sync;
    }

    public IQ.Type getType() {
        return IQ.Type.set;
    }

    public String getElement() {
        return "inputevt";
    }

    public String getNamespace() {
        return "http://jitsi.org/protocol/inputevt";
    }
}

