/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.impl.protocol.jabber;

import net.java.sip.communicator.impl.protocol.jabber.ContactJabberImpl;
import net.java.sip.communicator.impl.protocol.jabber.OperationSetPersistentPresenceJabberImpl;
import net.java.sip.communicator.impl.protocol.jabber.ProtocolProviderServiceJabberImpl;
import net.java.sip.communicator.service.protocol.AuthorizationRequest;
import net.java.sip.communicator.service.protocol.Contact;
import net.java.sip.communicator.service.protocol.OperationFailedException;
import net.java.sip.communicator.service.protocol.OperationSetExtendedAuthorizations;
import org.jivesoftware.smack.SmackException;
import org.jivesoftware.smack.packet.Presence;
import org.jivesoftware.smack.packet.Stanza;
import org.jivesoftware.smack.roster.RosterEntry;
import org.jivesoftware.smack.roster.packet.RosterPacket;

public class OperationSetExtendedAuthorizationsJabberImpl
implements OperationSetExtendedAuthorizations {
    private OperationSetPersistentPresenceJabberImpl opSetPersPresence = null;
    private ProtocolProviderServiceJabberImpl parentProvider;

    OperationSetExtendedAuthorizationsJabberImpl(ProtocolProviderServiceJabberImpl provider, OperationSetPersistentPresenceJabberImpl opSetPersPresence) {
        this.opSetPersPresence = opSetPersPresence;
        this.parentProvider = provider;
    }

    public void explicitAuthorize(Contact contact) throws OperationFailedException {
        this.opSetPersPresence.assertConnected();
        if (!(contact instanceof ContactJabberImpl)) {
            throw new IllegalArgumentException("The specified contact is not an jabber contact." + contact);
        }
        Presence responsePacket = new Presence(Presence.Type.subscribed);
        responsePacket.setTo(((ContactJabberImpl)contact).getAddressAsJid());
        try {
            this.parentProvider.getConnection().sendStanza((Stanza)responsePacket);
        }
        catch (InterruptedException | SmackException.NotConnectedException e) {
            throw new OperationFailedException("Could not send authorize", 2, e);
        }
    }

    public void reRequestAuthorization(AuthorizationRequest request, Contact contact) throws OperationFailedException {
        this.opSetPersPresence.assertConnected();
        if (!(contact instanceof ContactJabberImpl)) {
            throw new IllegalArgumentException("The specified contact is not an jabber contact." + contact);
        }
        Presence responsePacket = new Presence(Presence.Type.subscribe);
        responsePacket.setTo(((ContactJabberImpl)contact).getAddressAsJid());
        try {
            this.parentProvider.getConnection().sendStanza((Stanza)responsePacket);
        }
        catch (InterruptedException | SmackException.NotConnectedException e) {
            throw new OperationFailedException("Could not send subscribe packet", 2, e);
        }
    }

    public OperationSetExtendedAuthorizations.SubscriptionStatus getSubscriptionStatus(Contact contact) {
        if (!(contact instanceof ContactJabberImpl)) {
            throw new IllegalArgumentException("The specified contact is not an jabber contact." + contact);
        }
        RosterEntry entry = ((ContactJabberImpl)contact).getSourceEntry();
        if (entry != null) {
            if ((entry.getType() == RosterPacket.ItemType.none || entry.getType() == RosterPacket.ItemType.from) && entry.isSubscriptionPending()) {
                return OperationSetExtendedAuthorizations.SubscriptionStatus.SubscriptionPending;
            }
            if (entry.getType() == RosterPacket.ItemType.to || entry.getType() == RosterPacket.ItemType.both) {
                return OperationSetExtendedAuthorizations.SubscriptionStatus.Subscribed;
            }
            return OperationSetExtendedAuthorizations.SubscriptionStatus.NotSubscribed;
        }
        return null;
    }
}

