/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.impl.protocol.jabber;

import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import net.java.sip.communicator.impl.protocol.jabber.ChatRoomJabberImpl;
import net.java.sip.communicator.impl.protocol.jabber.ProtocolProviderServiceJabberImpl;
import net.java.sip.communicator.service.protocol.CallPeer;
import net.java.sip.communicator.service.protocol.ChatRoom;
import net.java.sip.communicator.service.protocol.OperationFailedException;
import net.java.sip.communicator.service.protocol.OperationSetJitsiMeetTools;
import net.java.sip.communicator.util.Logger;
import org.jivesoftware.smack.packet.ExtensionElement;
import org.json.simple.JSONObject;

public class OperationSetJitsiMeetToolsJabberImpl
implements OperationSetJitsiMeetTools {
    private final ProtocolProviderServiceJabberImpl parentProvider;
    private static final Logger logger = Logger.getLogger(OperationSetJitsiMeetToolsJabberImpl.class);
    private final List<OperationSetJitsiMeetTools.JitsiMeetRequestListener> requestHandlers = new CopyOnWriteArrayList<OperationSetJitsiMeetTools.JitsiMeetRequestListener>();

    public OperationSetJitsiMeetToolsJabberImpl(ProtocolProviderServiceJabberImpl parentProvider) {
        this.parentProvider = parentProvider;
    }

    public void addSupportedFeature(String featureName) {
        this.parentProvider.getDiscoveryManager().addFeature(featureName);
    }

    public void removeSupportedFeature(String featureName) {
        this.parentProvider.getDiscoveryManager().removeFeature(featureName);
    }

    public void sendPresenceExtension(ChatRoom chatRoom, ExtensionElement extension) {
        ((ChatRoomJabberImpl)chatRoom).sendPresenceExtension(extension);
    }

    public void removePresenceExtension(ChatRoom chatRoom, ExtensionElement extension) {
        ((ChatRoomJabberImpl)chatRoom).removePresenceExtension(extension);
    }

    public void setPresenceStatus(ChatRoom chatRoom, String statusMessage) {
        ((ChatRoomJabberImpl)chatRoom).publishPresenceStatus(statusMessage);
    }

    public void addRequestListener(OperationSetJitsiMeetTools.JitsiMeetRequestListener requestHandler) {
        this.requestHandlers.add(requestHandler);
    }

    public void removeRequestListener(OperationSetJitsiMeetTools.JitsiMeetRequestListener requestHandler) {
        this.requestHandlers.remove(requestHandler);
    }

    public void notifySessionStartMuted(boolean[] startMuted) {
        boolean handled = false;
        for (OperationSetJitsiMeetTools.JitsiMeetRequestListener l : this.requestHandlers) {
            l.onSessionStartMuted(startMuted);
            handled = true;
        }
        if (!handled) {
            logger.warn((Object)"Unhandled join onStartMuted Jitsi Meet request!");
        }
    }

    public void sendJSON(CallPeer callPeer, JSONObject jsonObject, Map<String, Object> params) throws OperationFailedException {
        throw new OperationFailedException("Operation not supported for this protocol yet!", 18);
    }
}

