/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.impl.protocol.jabber;

import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.java.sip.communicator.impl.protocol.jabber.ChatRoomInvitationJabberImpl;
import net.java.sip.communicator.impl.protocol.jabber.ChatRoomJabberImpl;
import net.java.sip.communicator.impl.protocol.jabber.ChatRoomMemberJabberImpl;
import net.java.sip.communicator.impl.protocol.jabber.JabberActivator;
import net.java.sip.communicator.impl.protocol.jabber.OperationSetPersistentPresenceJabberImpl;
import net.java.sip.communicator.impl.protocol.jabber.ProtocolProviderServiceJabberImpl;
import net.java.sip.communicator.service.protocol.AbstractOperationSetMultiUserChat;
import net.java.sip.communicator.service.protocol.ChatRoom;
import net.java.sip.communicator.service.protocol.ChatRoomInvitation;
import net.java.sip.communicator.service.protocol.ChatRoomMember;
import net.java.sip.communicator.service.protocol.ChatRoomMemberRole;
import net.java.sip.communicator.service.protocol.Contact;
import net.java.sip.communicator.service.protocol.OperationFailedException;
import net.java.sip.communicator.service.protocol.OperationNotSupportedException;
import net.java.sip.communicator.service.protocol.OperationSetMultiUserChat;
import net.java.sip.communicator.service.protocol.OperationSetPersistentPresence;
import net.java.sip.communicator.service.protocol.ProtocolProviderService;
import net.java.sip.communicator.service.protocol.RegistrationState;
import net.java.sip.communicator.service.protocol.event.ContactPropertyChangeEvent;
import net.java.sip.communicator.service.protocol.event.RegistrationStateChangeEvent;
import net.java.sip.communicator.service.protocol.event.RegistrationStateChangeListener;
import net.java.sip.communicator.service.protocol.event.SubscriptionEvent;
import net.java.sip.communicator.service.protocol.event.SubscriptionListener;
import net.java.sip.communicator.service.protocol.event.SubscriptionMovedEvent;
import net.java.sip.communicator.util.Logger;
import org.apache.commons.lang3.RandomStringUtils;
import org.jivesoftware.smack.SmackException;
import org.jivesoftware.smack.XMPPConnection;
import org.jivesoftware.smack.XMPPException;
import org.jivesoftware.smack.packet.Message;
import org.jivesoftware.smackx.muc.HostedRoom;
import org.jivesoftware.smackx.muc.InvitationListener;
import org.jivesoftware.smackx.muc.InvitationRejectionListener;
import org.jivesoftware.smackx.muc.MultiUserChat;
import org.jivesoftware.smackx.muc.MultiUserChatException;
import org.jivesoftware.smackx.muc.MultiUserChatManager;
import org.jivesoftware.smackx.muc.packet.MUCUser;
import org.jivesoftware.smackx.xdata.Form;
import org.jivesoftware.smackx.xdata.FormField;
import org.jivesoftware.smackx.xdata.packet.DataForm;
import org.jxmpp.jid.BareJid;
import org.jxmpp.jid.DomainBareJid;
import org.jxmpp.jid.EntityBareJid;
import org.jxmpp.jid.EntityJid;
import org.jxmpp.jid.Jid;
import org.jxmpp.jid.impl.JidCreate;
import org.jxmpp.jid.parts.Localpart;
import org.jxmpp.jid.parts.Resourcepart;
import org.jxmpp.stringprep.XmppStringprepException;

public class OperationSetMultiUserChatJabberImpl
extends AbstractOperationSetMultiUserChat
implements SubscriptionListener {
    private static final Logger logger = Logger.getLogger(OperationSetMultiUserChatJabberImpl.class);
    private final ProtocolProviderServiceJabberImpl jabberProvider;
    private final Hashtable<BareJid, ChatRoomJabberImpl> chatRoomCache = new Hashtable();
    private OperationSetPersistentPresenceJabberImpl opSetPersPresence = null;
    private SmackInvitationListener smackInvitationListener = null;

    OperationSetMultiUserChatJabberImpl(ProtocolProviderServiceJabberImpl jabberProvider) {
        this.jabberProvider = jabberProvider;
        RegistrationStateListener providerRegListener = new RegistrationStateListener();
        jabberProvider.addRegistrationStateChangeListener(providerRegListener);
        this.opSetPersPresence = (OperationSetPersistentPresenceJabberImpl)jabberProvider.getOperationSet(OperationSetPersistentPresence.class);
        this.opSetPersPresence.addSubscriptionListener(this);
    }

    public void addSmackInvitationRejectionListener(MultiUserChat muc, ChatRoom chatRoom) {
        muc.addInvitationRejectionListener((InvitationRejectionListener)new SmackInvitationRejectionListener(chatRoom));
    }

    public ChatRoom createChatRoom(String roomName, Map<String, Object> roomProperties) throws OperationFailedException, OperationNotSupportedException {
        this.assertSupportedAndConnected();
        ChatRoom room = null;
        if (roomName == null) {
            roomName = "chatroom-" + RandomStringUtils.random((int)4);
        } else {
            room = this.findRoom(roomName);
        }
        if (room == null) {
            Object isPrivateObject;
            MultiUserChat muc;
            if (logger.isInfoEnabled()) {
                logger.info((Object)"Find room returns null.");
            }
            if (this.getXmppConnection() != null && this.getXmppConnection().getHost().toLowerCase().contains("google")) {
                roomName = "private-chat-" + UUID.randomUUID().toString() + "@groupchat.google.com";
            }
            try {
                MultiUserChatManager manager = MultiUserChatManager.getInstanceFor((XMPPConnection)this.getXmppConnection());
                muc = manager.getMultiUserChat(this.getCanonicalRoomName(roomName));
                Resourcepart nick = Resourcepart.from((String)JabberActivator.getGlobalDisplayDetailsService().getDisplayName((ProtocolProviderService)this.jabberProvider));
                muc.create(nick);
            }
            catch (Exception ex) {
                logger.error((Object)"Failed to create chat room.", (Throwable)ex);
                throw new OperationFailedException("Failed to create chat room", 1, (Throwable)ex);
            }
            boolean isPrivate = false;
            if (roomProperties != null && (isPrivateObject = roomProperties.get("isPrivate")) != null) {
                isPrivate = isPrivateObject.equals(true);
            }
            try {
                Form form;
                if (isPrivate) {
                    Form initForm;
                    try {
                        initForm = muc.getConfigurationForm();
                    }
                    catch (InterruptedException | SmackException.NoResponseException | SmackException.NotConnectedException e) {
                        throw new OperationFailedException("Could not get config form", 1, e);
                    }
                    form = initForm.createAnswerForm();
                    for (FormField initField : initForm.getFields()) {
                        FormField submitField;
                        if (initField == null || initField.getVariable() == null || initField.getType() == FormField.Type.fixed || initField.getType() == FormField.Type.hidden || (submitField = form.getField(initField.getVariable())) == null) continue;
                        for (String value : initField.getValues()) {
                            submitField.addValue(value);
                        }
                    }
                    String[] fields = new String[]{"muc#roomconfig_membersonly", "muc#roomconfig_allowinvites", "muc#roomconfig_publicroom"};
                    Boolean[] values = new Boolean[]{true, true, false};
                    for (int i = 0; i < fields.length; ++i) {
                        FormField field = new FormField(fields[i]);
                        field.setType(FormField.Type.bool);
                        form.addField(field);
                        form.setAnswer(fields[i], values[i].booleanValue());
                    }
                } else {
                    form = new Form(DataForm.Type.submit);
                }
                muc.sendConfigurationForm(form);
            }
            catch (InterruptedException | SmackException.NoResponseException | SmackException.NotConnectedException | XMPPException e) {
                logger.error((Object)"Failed to send config form.", e);
            }
            room = this.createLocalChatRoomInstance(muc);
            room.setLocalUserRole(ChatRoomMemberRole.OWNER);
        }
        return room;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ChatRoom createLocalChatRoomInstance(MultiUserChat muc) {
        Hashtable<BareJid, ChatRoomJabberImpl> hashtable = this.chatRoomCache;
        synchronized (hashtable) {
            ChatRoomJabberImpl chatRoom = new ChatRoomJabberImpl(muc, this.jabberProvider);
            this.chatRoomCache.put((BareJid)muc.getRoom(), chatRoom);
            this.addSmackInvitationRejectionListener(muc, (ChatRoom)chatRoom);
            return chatRoom;
        }
    }

    public synchronized ChatRoom findRoom(String roomName) throws OperationFailedException, OperationNotSupportedException {
        this.assertSupportedAndConnected();
        EntityBareJid canonicalRoomName = this.getCanonicalRoomName(roomName);
        ChatRoomJabberImpl room = this.chatRoomCache.get(canonicalRoomName);
        if (room != null) {
            return room;
        }
        MultiUserChatManager manager = MultiUserChatManager.getInstanceFor((XMPPConnection)this.getXmppConnection());
        MultiUserChat muc = manager.getMultiUserChat(canonicalRoomName);
        room = new ChatRoomJabberImpl(muc, this.jabberProvider);
        this.chatRoomCache.put((BareJid)canonicalRoomName, room);
        return room;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<ChatRoom> getCurrentlyJoinedChatRooms() {
        Hashtable<BareJid, ChatRoomJabberImpl> hashtable = this.chatRoomCache;
        synchronized (hashtable) {
            LinkedList<ChatRoom> joinedRooms = new LinkedList<ChatRoom>();
            for (ChatRoom chatRoom : this.chatRoomCache.values()) {
                joinedRooms.add(chatRoom);
            }
            Iterator joinedRoomsIter = joinedRooms.iterator();
            while (joinedRoomsIter.hasNext()) {
                if (((ChatRoom)joinedRoomsIter.next()).isJoined()) continue;
                joinedRoomsIter.remove();
            }
            return joinedRooms;
        }
    }

    public List<String> getExistingChatRooms() throws OperationFailedException, OperationNotSupportedException {
        List serviceNames;
        this.assertSupportedAndConnected();
        LinkedList<String> list = new LinkedList<String>();
        MultiUserChatManager manager = MultiUserChatManager.getInstanceFor((XMPPConnection)this.getXmppConnection());
        try {
            serviceNames = manager.getXMPPServiceDomains();
        }
        catch (InterruptedException | SmackException.NoResponseException | SmackException.NotConnectedException | XMPPException ex) {
            throw new OperationFailedException("Failed to retrieve Jabber conference service names", 1, ex);
        }
        for (DomainBareJid serviceName : serviceNames) {
            LinkedList roomsOnThisService = new LinkedList();
            try {
                roomsOnThisService.addAll(manager.getHostedRooms(serviceName));
            }
            catch (InterruptedException | SmackException.NoResponseException | SmackException.NotConnectedException | XMPPException | MultiUserChatException.NotAMucServiceException ex) {
                logger.error((Object)("Failed to retrieve rooms for serviceName=" + serviceName), ex);
                continue;
            }
            for (HostedRoom hr : roomsOnThisService) {
                list.add(hr.getJid().toString());
            }
        }
        return list;
    }

    public boolean isMultiChatSupportedByContact(Contact contact) {
        return contact.getProtocolProvider().getOperationSet(OperationSetMultiUserChat.class) != null;
    }

    public boolean isPrivateMessagingContact(String contactAddress) {
        try {
            Jid jid = JidCreate.from((String)contactAddress);
            return this.opSetPersPresence.isPrivateMessagingContact(jid);
        }
        catch (XmppStringprepException e) {
            logger.error((Object)(contactAddress + " is not a valid JID"), (Throwable)e);
            return false;
        }
    }

    public void rejectInvitation(ChatRoomInvitation invitation, String rejectReason) throws OperationFailedException {
        MultiUserChatManager manager = MultiUserChatManager.getInstanceFor((XMPPConnection)this.getXmppConnection());
        try {
            manager.decline(JidCreate.entityBareFrom((String)invitation.getTargetChatRoom().getName()), JidCreate.entityBareFrom((String)invitation.getInviter()), rejectReason);
        }
        catch (InterruptedException | SmackException.NotConnectedException | XmppStringprepException e) {
            throw new OperationFailedException("Could not reject invitation", 1, e);
        }
    }

    private XMPPConnection getXmppConnection() {
        return this.jabberProvider == null ? null : this.jabberProvider.getConnection();
    }

    private void assertSupportedAndConnected() throws OperationFailedException, OperationNotSupportedException {
        if (!this.jabberProvider.isRegistered() || this.getXmppConnection() == null || !this.getXmppConnection().isConnected()) {
            throw new OperationFailedException("Provider not connected to jabber server", 2);
        }
    }

    private EntityBareJid getCanonicalRoomName(String roomName) throws OperationFailedException {
        try {
            return JidCreate.entityBareFrom((String)roomName);
        }
        catch (XmppStringprepException xmppStringprepException) {
            List serviceNames;
            try {
                MultiUserChatManager manager = MultiUserChatManager.getInstanceFor((XMPPConnection)this.getXmppConnection());
                serviceNames = manager.getXMPPServiceDomains();
            }
            catch (Exception ex) {
                logger.error((Object)("Failed to retrieve conference service name for user: " + this.jabberProvider.getAccountID().getUserID() + " on server: " + this.jabberProvider.getAccountID().getService()), (Throwable)ex);
                throw new OperationFailedException("Failed to retrieve conference service name for user: " + this.jabberProvider.getAccountID().getUserID() + " on server: " + this.jabberProvider.getAccountID().getService(), 1, (Throwable)ex);
            }
            if (serviceNames != null) {
                try {
                    return JidCreate.entityBareFrom((Localpart)Localpart.from((String)roomName), (DomainBareJid)((DomainBareJid)serviceNames.get(0)));
                }
                catch (XmppStringprepException e) {
                    throw new OperationFailedException(roomName + " is not a valid JID local part", 1, (Throwable)e);
                }
            }
            throw new OperationFailedException("Failed to retrieve MultiUserChat service names.", 1);
        }
    }

    public ChatRoomJabberImpl getChatRoom(BareJid chatRoomName) {
        return this.chatRoomCache.get(chatRoomName);
    }

    public List<String> getCurrentlyJoinedChatRooms(ChatRoomMember chatRoomMember) throws OperationFailedException, OperationNotSupportedException {
        this.assertSupportedAndConnected();
        MultiUserChatManager manager = MultiUserChatManager.getInstanceFor((XMPPConnection)this.getXmppConnection());
        try {
            EntityJid memberJid = JidCreate.from((String)chatRoomMember.getContactAddress()).asEntityJidOrThrow();
            ArrayList<String> joinedRooms = new ArrayList<String>();
            for (Jid jid : manager.getJoinedRooms(memberJid)) {
                joinedRooms.add(jid.toString());
            }
            return joinedRooms;
        }
        catch (InterruptedException | SmackException.NoResponseException | SmackException.NotConnectedException | XMPPException.XMPPErrorException | XmppStringprepException e) {
            throw new OperationFailedException("Could not get list of joined rooms", 1, e);
        }
    }

    public void fireInvitationEvent(ChatRoom targetChatRoom, EntityJid inviter, String reason, byte[] password) {
        ChatRoomInvitationJabberImpl invitation = new ChatRoomInvitationJabberImpl(targetChatRoom, inviter, reason, password);
        this.fireInvitationReceived(invitation);
    }

    public void contactModified(ContactPropertyChangeEvent evt) {
        Contact modifiedContact = evt.getSourceContact();
        this.updateChatRoomMembers(modifiedContact);
    }

    public void subscriptionCreated(SubscriptionEvent evt) {
        Contact createdContact = evt.getSourceContact();
        this.updateChatRoomMembers(createdContact);
    }

    public void subscriptionFailed(SubscriptionEvent evt) {
    }

    public void subscriptionMoved(SubscriptionMovedEvent evt) {
    }

    public void subscriptionRemoved(SubscriptionEvent evt) {
    }

    public void subscriptionResolved(SubscriptionEvent evt) {
    }

    private void updateChatRoomMembers(Contact contact) {
        for (ChatRoomJabberImpl chatRoom : this.chatRoomCache.values()) {
            Resourcepart nick;
            try {
                nick = Resourcepart.from((String)contact.getAddress());
            }
            catch (XmppStringprepException e) {
                continue;
            }
            ChatRoomMemberJabberImpl member = chatRoom.findMemberForNickName(nick);
            if (member == null) continue;
            member.setContact(contact);
            member.setAvatar(contact.getImage());
        }
    }

    private class RegistrationStateListener
    implements RegistrationStateChangeListener {
        private RegistrationStateListener() {
        }

        public void registrationStateChanged(RegistrationStateChangeEvent evt) {
            if (evt.getNewState() == RegistrationState.REGISTERED) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)"adding an Invitation listener to the smack muc");
                }
                MultiUserChatManager manager = MultiUserChatManager.getInstanceFor((XMPPConnection)OperationSetMultiUserChatJabberImpl.this.getXmppConnection());
                OperationSetMultiUserChatJabberImpl.this.smackInvitationListener = new SmackInvitationListener();
                manager.addInvitationListener((InvitationListener)OperationSetMultiUserChatJabberImpl.this.smackInvitationListener);
            } else if (evt.getNewState() == RegistrationState.UNREGISTERED || evt.getNewState() == RegistrationState.CONNECTION_FAILED) {
                OperationSetMultiUserChatJabberImpl.this.chatRoomCache.clear();
                XMPPConnection connection = OperationSetMultiUserChatJabberImpl.this.getXmppConnection();
                if (OperationSetMultiUserChatJabberImpl.this.smackInvitationListener != null && connection != null) {
                    MultiUserChatManager.getInstanceFor((XMPPConnection)connection).removeInvitationListener((InvitationListener)OperationSetMultiUserChatJabberImpl.this.smackInvitationListener);
                    OperationSetMultiUserChatJabberImpl.this.smackInvitationListener = null;
                }
            } else if (evt.getNewState() == RegistrationState.UNREGISTERING) {
                XMPPConnection connection = OperationSetMultiUserChatJabberImpl.this.getXmppConnection();
                if (OperationSetMultiUserChatJabberImpl.this.smackInvitationListener != null && connection != null) {
                    MultiUserChatManager.getInstanceFor((XMPPConnection)connection).removeInvitationListener((InvitationListener)OperationSetMultiUserChatJabberImpl.this.smackInvitationListener);
                    OperationSetMultiUserChatJabberImpl.this.smackInvitationListener = null;
                }
                List<ChatRoom> joinedRooms = OperationSetMultiUserChatJabberImpl.this.getCurrentlyJoinedChatRooms();
                for (ChatRoom room : joinedRooms) {
                    room.leave();
                }
            }
        }
    }

    private class SmackInvitationRejectionListener
    implements InvitationRejectionListener {
        private ChatRoom chatRoom;

        public SmackInvitationRejectionListener(ChatRoom chatRoom) {
            this.chatRoom = chatRoom;
        }

        public void invitationDeclined(EntityBareJid invitee, String reason, Message message, MUCUser.Decline rejection) {
            OperationSetMultiUserChatJabberImpl.this.fireInvitationRejectedEvent(this.chatRoom, invitee.toString(), reason);
        }
    }

    private class SmackInvitationListener
    implements InvitationListener {
        private SmackInvitationListener() {
        }

        public void invitationReceived(XMPPConnection conn, MultiUserChat room, EntityJid inviter, String reason, String password, Message message, MUCUser.Invite invite) {
            try {
                ChatRoomJabberImpl chatRoom = (ChatRoomJabberImpl)OperationSetMultiUserChatJabberImpl.this.findRoom(room.getRoom().toString());
                if (password != null) {
                    OperationSetMultiUserChatJabberImpl.this.fireInvitationEvent((ChatRoom)chatRoom, inviter, reason, password.getBytes());
                } else {
                    OperationSetMultiUserChatJabberImpl.this.fireInvitationEvent((ChatRoom)chatRoom, inviter, reason, null);
                }
            }
            catch (OperationFailedException | OperationNotSupportedException e) {
                logger.error((Object)("Failed to find room with name: " + room), e);
            }
        }
    }
}

