/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.impl.protocol.jabber;

import java.io.IOException;
import java.lang.reflect.Field;
import java.math.BigInteger;
import java.net.ConnectException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.NoRouteToHostException;
import java.net.Socket;
import java.net.SocketException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.UnknownHostException;
import java.security.GeneralSecurityException;
import java.security.SecureRandom;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLHandshakeException;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.X509ExtendedTrustManager;
import javax.net.ssl.X509TrustManager;
import net.java.sip.communicator.impl.protocol.jabber.AnonymousLoginStrategy;
import net.java.sip.communicator.impl.protocol.jabber.InfoRetreiver;
import net.java.sip.communicator.impl.protocol.jabber.JabberAccountIDImpl;
import net.java.sip.communicator.impl.protocol.jabber.JabberActivator;
import net.java.sip.communicator.impl.protocol.jabber.JabberLoginStrategy;
import net.java.sip.communicator.impl.protocol.jabber.JingleNodesServiceDiscovery;
import net.java.sip.communicator.impl.protocol.jabber.JitsiXmppException;
import net.java.sip.communicator.impl.protocol.jabber.LoginByClientCertificateStrategy;
import net.java.sip.communicator.impl.protocol.jabber.LoginByPasswordStrategy;
import net.java.sip.communicator.impl.protocol.jabber.OperationSetAutoAnswerJabberImpl;
import net.java.sip.communicator.impl.protocol.jabber.OperationSetAvatarJabberImpl;
import net.java.sip.communicator.impl.protocol.jabber.OperationSetBasicInstantMessagingJabberImpl;
import net.java.sip.communicator.impl.protocol.jabber.OperationSetBasicTelephonyJabberImpl;
import net.java.sip.communicator.impl.protocol.jabber.OperationSetChangePasswordJabberImpl;
import net.java.sip.communicator.impl.protocol.jabber.OperationSetContactCapabilitiesJabberImpl;
import net.java.sip.communicator.impl.protocol.jabber.OperationSetCusaxUtilsJabberImpl;
import net.java.sip.communicator.impl.protocol.jabber.OperationSetDTMFJabberImpl;
import net.java.sip.communicator.impl.protocol.jabber.OperationSetDesktopSharingClientJabberImpl;
import net.java.sip.communicator.impl.protocol.jabber.OperationSetDesktopSharingServerJabberImpl;
import net.java.sip.communicator.impl.protocol.jabber.OperationSetDesktopStreamingJabberImpl;
import net.java.sip.communicator.impl.protocol.jabber.OperationSetExtendedAuthorizationsJabberImpl;
import net.java.sip.communicator.impl.protocol.jabber.OperationSetFileTransferJabberImpl;
import net.java.sip.communicator.impl.protocol.jabber.OperationSetIncomingDTMFJabberImpl;
import net.java.sip.communicator.impl.protocol.jabber.OperationSetJitsiMeetToolsJabberImpl;
import net.java.sip.communicator.impl.protocol.jabber.OperationSetMultiUserChatJabberImpl;
import net.java.sip.communicator.impl.protocol.jabber.OperationSetPersistentPresenceJabberImpl;
import net.java.sip.communicator.impl.protocol.jabber.OperationSetPersistentPresencePermissionsJabberImpl;
import net.java.sip.communicator.impl.protocol.jabber.OperationSetResAwareTelephonyJabberImpl;
import net.java.sip.communicator.impl.protocol.jabber.OperationSetServerStoredAccountInfoJabberImpl;
import net.java.sip.communicator.impl.protocol.jabber.OperationSetServerStoredContactInfoJabberImpl;
import net.java.sip.communicator.impl.protocol.jabber.OperationSetTLSJabberImpl;
import net.java.sip.communicator.impl.protocol.jabber.OperationSetTelephonyConferencingJabberImpl;
import net.java.sip.communicator.impl.protocol.jabber.OperationSetThumbnailedFileFactoryImpl;
import net.java.sip.communicator.impl.protocol.jabber.OperationSetTypingNotificationsJabberImpl;
import net.java.sip.communicator.impl.protocol.jabber.OperationSetUserSearchJabberImpl;
import net.java.sip.communicator.impl.protocol.jabber.OperationSetVideoBridgeImpl;
import net.java.sip.communicator.impl.protocol.jabber.OperationSetVideoTelephonyJabberImpl;
import net.java.sip.communicator.impl.protocol.jabber.ProtocolIconJabberImpl;
import net.java.sip.communicator.impl.protocol.jabber.ScServiceDiscoveryManager;
import net.java.sip.communicator.impl.protocol.jabber.debugger.SmackPacketDebugger;
import net.java.sip.communicator.service.certificate.CertificateService;
import net.java.sip.communicator.service.dns.DnssecException;
import net.java.sip.communicator.service.protocol.AbstractProtocolProviderService;
import net.java.sip.communicator.service.protocol.AccountID;
import net.java.sip.communicator.service.protocol.Contact;
import net.java.sip.communicator.service.protocol.JingleNodeDescriptor;
import net.java.sip.communicator.service.protocol.OperationFailedException;
import net.java.sip.communicator.service.protocol.OperationSet;
import net.java.sip.communicator.service.protocol.OperationSetAdvancedTelephony;
import net.java.sip.communicator.service.protocol.OperationSetAvatar;
import net.java.sip.communicator.service.protocol.OperationSetBasicAutoAnswer;
import net.java.sip.communicator.service.protocol.OperationSetBasicInstantMessaging;
import net.java.sip.communicator.service.protocol.OperationSetBasicTelephony;
import net.java.sip.communicator.service.protocol.OperationSetChangePassword;
import net.java.sip.communicator.service.protocol.OperationSetConnectionInfo;
import net.java.sip.communicator.service.protocol.OperationSetContactCapabilities;
import net.java.sip.communicator.service.protocol.OperationSetCusaxUtils;
import net.java.sip.communicator.service.protocol.OperationSetDTMF;
import net.java.sip.communicator.service.protocol.OperationSetDesktopSharingClient;
import net.java.sip.communicator.service.protocol.OperationSetDesktopSharingServer;
import net.java.sip.communicator.service.protocol.OperationSetDesktopStreaming;
import net.java.sip.communicator.service.protocol.OperationSetExtendedAuthorizations;
import net.java.sip.communicator.service.protocol.OperationSetFileTransfer;
import net.java.sip.communicator.service.protocol.OperationSetIncomingDTMF;
import net.java.sip.communicator.service.protocol.OperationSetInstantMessageTransform;
import net.java.sip.communicator.service.protocol.OperationSetInstantMessageTransformImpl;
import net.java.sip.communicator.service.protocol.OperationSetJitsiMeetTools;
import net.java.sip.communicator.service.protocol.OperationSetMessageCorrection;
import net.java.sip.communicator.service.protocol.OperationSetMultiUserChat;
import net.java.sip.communicator.service.protocol.OperationSetPersistentPresence;
import net.java.sip.communicator.service.protocol.OperationSetPersistentPresencePermissions;
import net.java.sip.communicator.service.protocol.OperationSetPresence;
import net.java.sip.communicator.service.protocol.OperationSetResourceAwareTelephony;
import net.java.sip.communicator.service.protocol.OperationSetSecureSDesTelephony;
import net.java.sip.communicator.service.protocol.OperationSetSecureZrtpTelephony;
import net.java.sip.communicator.service.protocol.OperationSetServerStoredAccountInfo;
import net.java.sip.communicator.service.protocol.OperationSetServerStoredContactInfo;
import net.java.sip.communicator.service.protocol.OperationSetTLS;
import net.java.sip.communicator.service.protocol.OperationSetTelephonyConferencing;
import net.java.sip.communicator.service.protocol.OperationSetThumbnailedFileFactory;
import net.java.sip.communicator.service.protocol.OperationSetTypingNotifications;
import net.java.sip.communicator.service.protocol.OperationSetUserSearch;
import net.java.sip.communicator.service.protocol.OperationSetVideoBridge;
import net.java.sip.communicator.service.protocol.OperationSetVideoTelephony;
import net.java.sip.communicator.service.protocol.ProtocolIcon;
import net.java.sip.communicator.service.protocol.ProtocolProviderService;
import net.java.sip.communicator.service.protocol.ProxyInfo;
import net.java.sip.communicator.service.protocol.RegistrationState;
import net.java.sip.communicator.service.protocol.SecurityAuthority;
import net.java.sip.communicator.service.protocol.TransportProtocol;
import net.java.sip.communicator.service.protocol.UserCredentials;
import net.java.sip.communicator.service.protocol.event.RegistrationStateChangeEvent;
import net.java.sip.communicator.service.protocol.jabber.JabberAccountID;
import net.java.sip.communicator.service.protocol.jabberconstants.JabberStatusEnum;
import net.java.sip.communicator.util.Logger;
import net.java.sip.communicator.util.NetworkUtils;
import net.java.sip.communicator.util.SRVRecord;
import net.java.sip.communicator.util.ServiceUtils;
import org.apache.commons.lang3.StringUtils;
import org.jitsi.service.configuration.ConfigurationService;
import org.jitsi.service.neomedia.SrtpControlType;
import org.jitsi.xmpp.extensions.DefaultPacketExtensionProvider;
import org.jitsi.xmpp.extensions.colibri.ColibriIQProvider;
import org.jitsi.xmpp.extensions.condesc.ConferenceDescriptionExtensionProvider;
import org.jitsi.xmpp.extensions.inputevt.InputEvtIQProvider;
import org.jitsi.xmpp.extensions.jibri.JibriIqProvider;
import org.jitsi.xmpp.extensions.jingle.JingleIQProvider;
import org.jitsi.xmpp.extensions.jingleinfo.JingleInfoQueryIQProvider;
import org.jitsi.xmpp.extensions.jitsimeet.AvatarIdPacketExtension;
import org.jitsi.xmpp.extensions.jitsimeet.AvatarUrl;
import org.jitsi.xmpp.extensions.jitsimeet.Email;
import org.jitsi.xmpp.extensions.jitsimeet.IdentityPacketExtension;
import org.jitsi.xmpp.extensions.jitsimeet.JsonMessageExtension;
import org.jitsi.xmpp.extensions.jitsimeet.StatsId;
import org.jitsi.xmpp.extensions.jitsimeet.TranscriptionLanguageExtension;
import org.jitsi.xmpp.extensions.jitsimeet.TranscriptionRequestExtension;
import org.jitsi.xmpp.extensions.jitsimeet.TranscriptionStatusExtension;
import org.jitsi.xmpp.extensions.jitsimeet.TranslationLanguageExtension;
import org.jitsi.xmpp.extensions.thumbnail.ThumbnailStreamInitiationProvider;
import org.jivesoftware.smack.AbstractXMPPConnection;
import org.jivesoftware.smack.ConnectionConfiguration;
import org.jivesoftware.smack.ConnectionListener;
import org.jivesoftware.smack.ReconnectionManager;
import org.jivesoftware.smack.SmackException;
import org.jivesoftware.smack.StanzaListener;
import org.jivesoftware.smack.XMPPConnection;
import org.jivesoftware.smack.XMPPException;
import org.jivesoftware.smack.bosh.BOSHConfiguration;
import org.jivesoftware.smack.bosh.XMPPBOSHConnection;
import org.jivesoftware.smack.packet.Presence;
import org.jivesoftware.smack.packet.StreamError;
import org.jivesoftware.smack.provider.ProviderManager;
import org.jivesoftware.smack.proxy.ProxyInfo;
import org.jivesoftware.smack.roster.Roster;
import org.jivesoftware.smack.tcp.XMPPTCPConnection;
import org.jivesoftware.smack.tcp.XMPPTCPConnectionConfiguration;
import org.jivesoftware.smack.util.TLSUtils;
import org.jivesoftware.smackx.disco.packet.DiscoverInfo;
import org.jivesoftware.smackx.disco.packet.DiscoverItems;
import org.jivesoftware.smackx.nick.packet.Nick;
import org.jivesoftware.smackx.ping.PingManager;
import org.jxmpp.jid.BareJid;
import org.jxmpp.jid.DomainBareJid;
import org.jxmpp.jid.EntityBareJid;
import org.jxmpp.jid.EntityFullJid;
import org.jxmpp.jid.Jid;
import org.jxmpp.jid.impl.JidCreate;
import org.jxmpp.jid.parts.Resourcepart;
import org.jxmpp.stringprep.XmppStringprepException;
import org.osgi.framework.BundleContext;
import org.xmlpull.v1.XmlPullParserException;
import org.xmpp.jnodes.smack.SmackServiceNode;
import org.xmpp.jnodes.smack.TrackerEntry;

public class ProtocolProviderServiceJabberImpl
extends AbstractProtocolProviderService {
    private static final Logger logger = Logger.getLogger(ProtocolProviderServiceJabberImpl.class);
    public static final String URN_XMPP_JINGLE = "urn:xmpp:jingle:1";
    public static final String URN_XMPP_JINGLE_RTP = "urn:xmpp:jingle:apps:rtp:1";
    public static final String URN_XMPP_JINGLE_RTP_AUDIO = "urn:xmpp:jingle:apps:rtp:audio";
    public static final String URN_XMPP_JINGLE_RTP_VIDEO = "urn:xmpp:jingle:apps:rtp:video";
    public static final String URN_XMPP_JINGLE_RTP_ZRTP = "urn:xmpp:jingle:apps:rtp:zrtp:1";
    public static final String URN_XMPP_JINGLE_RAW_UDP_0 = "urn:xmpp:jingle:transports:raw-udp:1";
    public static final String URN_XMPP_JINGLE_ICE_UDP_1 = "urn:xmpp:jingle:transports:ice-udp:1";
    public static final String URN_XMPP_JINGLE_NODES = "http://jabber.org/protocol/jinglenodes";
    public static final String URN_XMPP_JINGLE_TRANSFER_0 = "urn:xmpp:jingle:transfer:0";
    public static final String URN_XMPP_JINGLE_COIN = "urn:xmpp:coin";
    public static final String URN_XMPP_JINGLE_DTLS_SRTP = "urn:xmpp:jingle:apps:dtls:0";
    public static final String URN_IETF_RFC_3264 = "urn:ietf:rfc:3264";
    public static final String URN_XMPP_JINGLE_RTP_HDREXT = "urn:xmpp:jingle:apps:rtp:rtp-hdrext:0";
    public static final String URN_REGISTER = "jabber:iq:register";
    private static final String IS_DESKTOP_STREAMING_DISABLED = "net.java.sip.communicator.impl.protocol.jabber.DESKTOP_STREAMING_DISABLED";
    private static final String IS_CALLING_DISABLED = "net.java.sip.communicator.impl.protocol.jabber.CALLING_DISABLED";
    public static final int SMACK_PACKET_REPLY_TIMEOUT = 45000;
    public static final String VCARD_REPLY_TIMEOUT_PROPERTY = "net.java.sip.communicator.impl.protocol.jabber.VCARD_REPLY_TIMEOUT";
    private static final String XMPP_DSCP_PROPERTY = "net.java.sip.communicator.impl.protocol.XMPP_DSCP";
    private static final String IS_USER_SEARCH_ENABLED_PROPERTY = "USER_SEARCH_ENABLED";
    private static final String IS_IM_DISABLED_PROPERTY = "IM_DISABLED";
    public static final String IS_SERVER_STORED_INFO_DISABLED_PROPERTY = "SERVER_STORED_INFO_DISABLED";
    private static final String IS_FILE_TRANSFER_DISABLED_PROPERTY = "IS_FILE_TRANSFER_DISABLED";
    public static final String GOOGLE_VOICE_DOMAIN = "voice.google.com";
    private AbstractXMPPConnection connection;
    private InetSocketAddress address;
    private boolean isInitialized = false;
    private final Object initializationLock = new Object();
    private JabberAccountID accountID = null;
    private SecurityAuthority authority = null;
    private Resourcepart resource = null;
    private ProtocolIconJabberImpl jabberIcon;
    private final List<String> supportedFeatures = new ArrayList<String>();
    private ScServiceDiscoveryManager discoveryManager = null;
    private OperationSetContactCapabilitiesJabberImpl opsetContactCapabilities;
    private JabberStatusEnum jabberStatusEnum;
    private CertificateService guiVerification;
    private boolean abortConnecting = false;
    private boolean inConnectAndLogin = false;
    private final Object connectAndLoginLock = new Object();
    private RegistrationStateChangeEvent eventDuringLogin;
    private JabberConnectionListener connectionListener;
    private ProxyInfo proxy;
    private SmackPacketDebugger debugger = null;
    private SmackServiceNode jingleNodesServiceNode = null;
    private final Object jingleNodesSyncRoot = new Object();
    private UserCredentials userCredentials = null;
    private boolean isKeepAliveEnabled = false;

    public RegistrationState getRegistrationState() {
        if (this.connection == null) {
            if (this.inConnectAndLogin) {
                return RegistrationState.REGISTERING;
            }
            return RegistrationState.UNREGISTERED;
        }
        if (this.connection.isConnected() && this.connection.isAuthenticated()) {
            return RegistrationState.REGISTERED;
        }
        return RegistrationState.REGISTERING;
    }

    private CertificateService getCertificateVerificationService() {
        if (this.guiVerification == null) {
            this.guiVerification = (CertificateService)ServiceUtils.getService((BundleContext)JabberActivator.getBundleContext(), CertificateService.class);
        }
        return this.guiVerification;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void register(SecurityAuthority authority) throws OperationFailedException {
        if (authority == null) {
            throw new IllegalArgumentException("The register method needs a valid non-null authority impl  in order to be able and retrieve passwords.");
        }
        this.authority = authority;
        try {
            this.abortConnecting = false;
            Object object = this.connectAndLoginLock;
            synchronized (object) {
                this.inConnectAndLogin = true;
            }
            this.initializeConnectAndLogin(authority, 0);
        }
        catch (IOException | InterruptedException | SmackException | XMPPException ex) {
            logger.error((Object)"Error registering", ex);
            this.eventDuringLogin = null;
            this.fireRegistrationStateChanged((Exception)ex);
        }
        finally {
            Object object = this.connectAndLoginLock;
            synchronized (object) {
                if (this.eventDuringLogin != null) {
                    if (this.eventDuringLogin.getNewState().equals((Object)RegistrationState.CONNECTION_FAILED) || this.eventDuringLogin.getNewState().equals((Object)RegistrationState.UNREGISTERED)) {
                        this.disconnectAndCleanConnection();
                    }
                    this.fireRegistrationStateChanged(this.eventDuringLogin.getOldState(), this.eventDuringLogin.getNewState(), this.eventDuringLogin.getReasonCode(), this.eventDuringLogin.getReason());
                    this.eventDuringLogin = null;
                    this.inConnectAndLogin = false;
                    return;
                }
                this.inConnectAndLogin = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void reregister(int authReasonCode) {
        try {
            if (logger.isTraceEnabled()) {
                logger.trace((Object)"Trying to reregister us!");
            }
            this.unregisterInternal(false);
            this.abortConnecting = false;
            Object object = this.connectAndLoginLock;
            synchronized (object) {
                this.inConnectAndLogin = true;
            }
            this.initializeConnectAndLogin(this.authority, authReasonCode);
        }
        catch (XmppStringprepException e) {
            logger.error((Object)"User ID is not a valid JID", (Throwable)e);
            this.fireRegistrationStateChanged(this.getRegistrationState(), RegistrationState.CONNECTION_FAILED, 3, e.toString());
        }
        catch (IOException | InterruptedException | OperationFailedException | SmackException | XMPPException ex) {
            logger.error((Object)"Error ReRegistering", ex);
            this.eventDuringLogin = null;
            this.disconnectAndCleanConnection();
            this.fireRegistrationStateChanged(this.getRegistrationState(), RegistrationState.CONNECTION_FAILED, 6, ex.getMessage());
        }
        finally {
            Object e = this.connectAndLoginLock;
            synchronized (e) {
                if (this.eventDuringLogin != null) {
                    if (this.eventDuringLogin.getNewState().equals((Object)RegistrationState.CONNECTION_FAILED) || this.eventDuringLogin.getNewState().equals((Object)RegistrationState.UNREGISTERED)) {
                        this.disconnectAndCleanConnection();
                    }
                    this.fireRegistrationStateChanged(this.eventDuringLogin.getOldState(), this.eventDuringLogin.getNewState(), this.eventDuringLogin.getReasonCode(), this.eventDuringLogin.getReason());
                    this.eventDuringLogin = null;
                    this.inConnectAndLogin = false;
                    return;
                }
                this.inConnectAndLogin = false;
            }
        }
    }

    public boolean isSignalingTransportSecure() {
        return this.connection.isSecureConnection();
    }

    public TransportProtocol getTransportProtocol() {
        if (this.connection != null && this.connection.isConnected()) {
            if (this.isSignalingTransportSecure()) {
                return TransportProtocol.TLS;
            }
            return TransportProtocol.TCP;
        }
        return TransportProtocol.UNKNOWN;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initializeConnectAndLogin(SecurityAuthority authority, int reasonCode) throws XMPPException, OperationFailedException, IOException, InterruptedException, SmackException {
        Object object = this.initializationLock;
        synchronized (object) {
            String customXMPPDomain;
            ConnectState state;
            if (this.isRegistered()) {
                return;
            }
            JabberLoginStrategy loginStrategy = this.createLoginStrategy();
            this.userCredentials = loginStrategy.prepareLogin(authority, reasonCode);
            if (!loginStrategy.loginPreparationSuccessful()) {
                return;
            }
            DomainBareJid serviceName = JidCreate.from((String)this.getAccountID().getUserID()).asDomainBareJid();
            this.loadResource();
            this.loadProxy();
            Roster.setDefaultSubscriptionMode((Roster.SubscriptionMode)Roster.SubscriptionMode.manual);
            boolean[] hadDnsSecException = new boolean[]{false};
            boolean isServerOverriden = this.getAccountID().getAccountPropertyBoolean((Object)"IS_SERVER_OVERRIDDEN", false);
            if (!isServerOverriden) {
                state = this.connectUsingSRVRecords(serviceName.toString(), serviceName, hadDnsSecException, loginStrategy);
                if (hadDnsSecException[0]) {
                    this.setDnssecLoginFailure();
                    return;
                }
                if (state == ConnectState.ABORT_CONNECTING || state == ConnectState.STOP_TRYING) {
                    return;
                }
            }
            if ((customXMPPDomain = this.getAccountID().getAccountPropertyString((Object)"CUSTOM_XMPP_DOMAIN")) != null && !hadDnsSecException[0]) {
                logger.info((Object)("Connect using custom xmpp domain: " + customXMPPDomain));
                state = this.connectUsingSRVRecords(customXMPPDomain, serviceName, hadDnsSecException, loginStrategy);
                logger.info((Object)("state for connectUsingSRVRecords: " + (Object)((Object)state)));
                if (hadDnsSecException[0]) {
                    this.setDnssecLoginFailure();
                    return;
                }
                if (state == ConnectState.ABORT_CONNECTING || state == ConnectState.STOP_TRYING) {
                    return;
                }
            }
            String serverAddressUserSetting = this.getAccountID().getAccountPropertyString((Object)"SERVER_ADDRESS");
            int serverPort = this.getAccountID().getAccountPropertyInt((Object)"SERVER_PORT", 5222);
            InetSocketAddress[] addrs = null;
            try {
                addrs = NetworkUtils.getAandAAAARecords((String)serverAddressUserSetting, (int)serverPort);
            }
            catch (ParseException e) {
                logger.error((Object)"Domain not resolved", (Throwable)e);
            }
            catch (DnssecException e) {
                logger.error((Object)"DNSSEC failure for overridden server", (Throwable)e);
                this.setDnssecLoginFailure();
                return;
            }
            if (addrs == null || addrs.length == 0) {
                logger.error((Object)"No server addresses found");
                this.eventDuringLogin = null;
                this.fireRegistrationStateChanged(this.getRegistrationState(), RegistrationState.CONNECTION_FAILED, 8, "No server addresses found");
            } else {
                for (InetSocketAddress isa : addrs) {
                    try {
                        state = this.connectAndLogin(isa, serviceName, loginStrategy);
                        if (state != ConnectState.ABORT_CONNECTING && state != ConnectState.STOP_TRYING) continue;
                        return;
                    }
                    catch (IOException | InterruptedException | SmackException | XMPPException ex) {
                        this.disconnectAndCleanConnection();
                        if (!this.isAuthenticationFailed((Exception)ex)) continue;
                        throw ex;
                    }
                }
            }
        }
    }

    private JabberLoginStrategy createLoginStrategy() {
        String boshURL = this.accountID.getBoshUrl();
        boolean isBosh = StringUtils.isNotEmpty((CharSequence)boshURL);
        Object ccBuilder = isBosh ? BOSHConfiguration.builder() : XMPPTCPConnectionConfiguration.builder();
        if (((JabberAccountIDImpl)this.getAccountID()).isAnonymousAuthUsed()) {
            return new AnonymousLoginStrategy(this.getAccountID().getAuthorizationName(), (ConnectionConfiguration.Builder)ccBuilder);
        }
        String clientCertId = this.getAccountID().getAccountPropertyString((Object)"CLIENT_TLS_CERTIFICATE");
        if (clientCertId != null) {
            return new LoginByClientCertificateStrategy((AccountID)this.accountID, (ConnectionConfiguration.Builder)ccBuilder);
        }
        return new LoginByPasswordStrategy(this, (AccountID)this.accountID, (ConnectionConfiguration.Builder)ccBuilder);
    }

    private void setDnssecLoginFailure() {
        this.eventDuringLogin = new RegistrationStateChangeEvent((ProtocolProviderService)this, this.getRegistrationState(), RegistrationState.UNREGISTERED, 0, "No usable host found due to DNSSEC failures");
    }

    private ConnectState connectUsingSRVRecords(String domain, DomainBareJid serviceName, boolean[] dnssecState, JabberLoginStrategy loginStrategy) throws XMPPException, IOException, InterruptedException, SmackException {
        SRVRecord[] srvRecords = null;
        try {
            srvRecords = NetworkUtils.getSRVRecords((String)"xmpp-client", (String)"tcp", (String)domain);
        }
        catch (ParseException e) {
            logger.error((Object)"SRV record not resolved", (Throwable)e);
        }
        catch (DnssecException e) {
            logger.error((Object)"DNSSEC failure for SRV lookup", (Throwable)e);
            dnssecState[0] = true;
        }
        if (srvRecords != null) {
            for (SRVRecord srv : srvRecords) {
                InetSocketAddress[] addrs = null;
                try {
                    addrs = NetworkUtils.getAandAAAARecords((String)srv.getTarget(), (int)srv.getPort());
                }
                catch (ParseException e) {
                    logger.error((Object)"Invalid SRV record target", (Throwable)e);
                }
                catch (DnssecException e) {
                    logger.error((Object)"DNSSEC failure for A/AAAA lookup of SRV", (Throwable)e);
                    dnssecState[0] = true;
                }
                if (addrs == null || addrs.length == 0) {
                    logger.error((Object)("No A/AAAA addresses found for " + srv.getTarget()));
                    continue;
                }
                for (InetSocketAddress isa : addrs) {
                    try {
                        return this.connectAndLogin(isa, serviceName, loginStrategy);
                    }
                    catch (XMPPException ex) {
                        logger.error((Object)("Error connecting to " + isa + " for domain:" + domain + " serviceName:" + serviceName), (Throwable)ex);
                        this.disconnectAndCleanConnection();
                        if (!this.isAuthenticationFailed((Exception)((Object)ex))) continue;
                        throw ex;
                    }
                }
            }
        } else {
            logger.error((Object)("No SRV addresses found for _xmpp-client._tcp." + domain));
        }
        return ConnectState.CONTINUE_TRYING;
    }

    private ConnectState connectAndLogin(InetSocketAddress currentAddress, DomainBareJid serviceName, JabberLoginStrategy loginStrategy) throws XMPPException, IOException, InterruptedException, SmackException {
        try {
            EntityBareJid userID = JidCreate.entityBareFrom((String)this.getAccountID().getUserID());
            return this.connectAndLogin(currentAddress, serviceName, JidCreate.entityFullFrom((EntityBareJid)userID, (Resourcepart)this.resource), loginStrategy);
        }
        catch (ConnectException | NoRouteToHostException | SmackException.NoResponseException ex) {
            this.eventDuringLogin = new RegistrationStateChangeEvent((ProtocolProviderService)this, this.getRegistrationState(), RegistrationState.CONNECTION_FAILED, 8, null);
            throw ex;
        }
        catch (IOException | InterruptedException | SmackException | XMPPException ex) {
            logger.error((Object)"Failed to connect to XMPP service", ex);
            this.disconnectAndCleanConnection();
            this.eventDuringLogin = new RegistrationStateChangeEvent((ProtocolProviderService)this, this.getRegistrationState(), RegistrationState.CONNECTION_FAILED, 6, ex.getMessage());
            return ConnectState.CONTINUE_TRYING;
        }
    }

    private void loadResource() {
        if (this.resource != null) {
            return;
        }
        SecureRandom random = new SecureRandom();
        try {
            this.resource = Resourcepart.from((String)("jitsi-" + new BigInteger(32, random).toString(32)));
        }
        catch (XmppStringprepException xmppStringprepException) {
            // empty catch block
        }
        boolean autoGenerateResource = this.getAccountID().getAccountPropertyBoolean((Object)"AUTO_GENERATE_RESOURCE", true);
        if (!autoGenerateResource) {
            try {
                Resourcepart configured = Resourcepart.from((String)this.getAccountID().getAccountPropertyString((Object)"RESOURCE"));
                if (!Resourcepart.EMPTY.equals((Object)configured)) {
                    this.resource = configured;
                }
            }
            catch (XmppStringprepException xmppStringprepException) {
                // empty catch block
            }
        }
    }

    private void loadProxy() throws OperationFailedException {
        String globalProxyType = JabberActivator.getConfigurationService().getString("net.java.sip.communicator.service.connectionProxyType");
        if (globalProxyType != null && !globalProxyType.equals(ProxyInfo.ProxyType.NONE.name())) {
            int globalProxyPort;
            String globalProxyAddress = JabberActivator.getConfigurationService().getString("net.java.sip.communicator.service.connectionProxyAddress");
            String globalProxyPortStr = JabberActivator.getConfigurationService().getString("net.java.sip.communicator.service.connectionProxyPort");
            try {
                globalProxyPort = Integer.parseInt(globalProxyPortStr);
            }
            catch (NumberFormatException ex) {
                throw new OperationFailedException("Wrong proxy port, " + globalProxyPortStr + " does not represent an integer", 7, (Throwable)ex);
            }
            String globalProxyUsername = JabberActivator.getConfigurationService().getString("net.java.sip.communicator.service.connectionProxyUsername");
            String globalProxyPassword = JabberActivator.getConfigurationService().getString("net.java.sip.communicator.service.connectionProxyPassword");
            if (globalProxyAddress == null || globalProxyAddress.length() <= 0) {
                throw new OperationFailedException("Missing Proxy Address", 7);
            }
            try {
                this.proxy = new ProxyInfo(Enum.valueOf(ProxyInfo.ProxyType.class, globalProxyType), globalProxyAddress, globalProxyPort, globalProxyUsername, globalProxyPassword);
            }
            catch (IllegalArgumentException e) {
                logger.error((Object)"Invalid value for smack proxy enum", (Throwable)e);
                this.proxy = null;
            }
        }
    }

    private ConnectState connectAndLogin(InetSocketAddress address, DomainBareJid serviceName, EntityFullJid jid, JabberLoginStrategy loginStrategy) throws XMPPException, InterruptedException, IOException, SmackException {
        ConnectionConfiguration.Builder confConn = loginStrategy.getConnectionConfigurationBuilder();
        String boshURL = this.accountID.getBoshUrl();
        boolean isBosh = StringUtils.isNotEmpty((CharSequence)boshURL);
        confConn.setXmppDomain(serviceName);
        if (isBosh) {
            BOSHConfiguration.Builder boshConfConnBuilder = (BOSHConfiguration.Builder)confConn;
            try {
                URI boshURI = new URI(boshURL);
                boolean useHttps = boshURI.getScheme().equals("https");
                int port = boshURI.getPort();
                if (port == -1) {
                    port = useHttps ? 443 : 80;
                }
                String file = boshURI.getPath();
                String query = boshURI.getRawQuery();
                if (StringUtils.isNotEmpty((CharSequence)query)) {
                    file = file + "?" + query;
                }
                ((BOSHConfiguration.Builder)((BOSHConfiguration.Builder)boshConfConnBuilder.setUseHttps(useHttps).setFile(file).setPort(port)).setHost(boshURI.getHost())).setProxyInfo(this.proxy);
            }
            catch (URISyntaxException e) {
                throw new JitsiXmppException("Fail setting bosh URL to XMPPBOSHConnection configuration", e);
            }
        } else {
            confConn.setHostAddress(address.getAddress()).setPort(address.getPort()).setProxyInfo(this.proxy);
        }
        if (this.getOperationSet(OperationSetPersistentPresence.class) != null) {
            confConn.setSendPresence(false);
        }
        confConn.setSecurityMode(loginStrategy.isTlsRequired() ? ConnectionConfiguration.SecurityMode.required : ConnectionConfiguration.SecurityMode.ifpossible);
        TLSUtils.setTLSOnly((ConnectionConfiguration.Builder)confConn);
        if (this.connection != null) {
            logger.error((Object)("Connection is not null and isConnected:" + this.connection.isConnected()), (Throwable)new Exception("Trace possible duplicate connections: " + this.getAccountID().getAccountAddress()));
            this.disconnectAndCleanConnection();
        }
        try {
            CertificateService cvs = this.getCertificateVerificationService();
            if (cvs != null) {
                SSLContext sslContext = loginStrategy.createSslContext(cvs, this.getTrustManager(cvs, serviceName.toString()));
                if (logger.isDebugEnabled()) {
                    StringBuilder buff = new StringBuilder();
                    buff.append("Available TLS protocols and algorithms:\n");
                    buff.append("Default protocols: ");
                    buff.append(Arrays.toString(sslContext.getDefaultSSLParameters().getProtocols()));
                    buff.append("\n");
                    buff.append("Supported protocols: ");
                    buff.append(Arrays.toString(sslContext.getSupportedSSLParameters().getProtocols()));
                    buff.append("\n");
                    buff.append("Default cipher suites: ");
                    buff.append(Arrays.toString(sslContext.getDefaultSSLParameters().getCipherSuites()));
                    buff.append("\n");
                    buff.append("Supported cipher suites: ");
                    buff.append(Arrays.toString(sslContext.getSupportedSSLParameters().getCipherSuites()));
                    logger.debug((Object)buff.toString());
                }
                confConn.setCustomSSLContext(sslContext);
                confConn.setHostnameVerifier(new HostnameVerifier(){

                    @Override
                    public boolean verify(String hostname, SSLSession session) {
                        return true;
                    }
                });
            } else if (loginStrategy.isTlsRequired()) {
                throw new JitsiXmppException("Certificate verification service is unavailable and TLS is required");
            }
        }
        catch (GeneralSecurityException e) {
            logger.error((Object)"Error creating custom trust manager", (Throwable)e);
            throw new JitsiXmppException("Error creating custom trust manager", e);
        }
        this.connection = isBosh ? new XMPPBOSHConnection((BOSHConfiguration)confConn.build()) : new XMPPTCPConnection((XMPPTCPConnectionConfiguration)confConn.build());
        ReconnectionManager.getInstanceFor((AbstractXMPPConnection)this.connection).disableAutomaticReconnection();
        this.address = address;
        if (this.debugger == null) {
            this.debugger = new SmackPacketDebugger();
            this.debugger.setConnection((XMPPConnection)this.connection);
            this.connection.addAsyncStanzaListener((StanzaListener)this.debugger.inbound, null);
            this.connection.addPacketInterceptor((StanzaListener)this.debugger.outbound, null);
        }
        int keepAliveInterval = this.getAccountID().getAccountPropertyInt((Object)"KEEP_ALIVE_INTERVAL", -1);
        if (this.isKeepAliveEnabled && keepAliveInterval > 0) {
            PingManager.getInstanceFor((XMPPConnection)this.connection).setPingInterval(keepAliveInterval);
        }
        this.connection.connect();
        this.setTrafficClass();
        if (this.abortConnecting) {
            this.abortConnecting = false;
            this.disconnectAndCleanConnection();
            return ConnectState.ABORT_CONNECTING;
        }
        this.registerServiceDiscoveryManager();
        if (this.connectionListener == null) {
            this.connectionListener = new JabberConnectionListener();
        }
        if (!this.connection.isSecureConnection() && loginStrategy.isTlsRequired()) {
            throw new JitsiXmppException("TLS is required by client");
        }
        if (!this.connection.isConnected()) {
            this.disconnectAndCleanConnection();
            logger.error((Object)"Connection not established, server not found!");
            this.eventDuringLogin = null;
            this.fireRegistrationStateChanged(this.getRegistrationState(), RegistrationState.CONNECTION_FAILED, 8, null);
            return ConnectState.ABORT_CONNECTING;
        }
        this.connection.addConnectionListener((ConnectionListener)this.connectionListener);
        if (this.abortConnecting) {
            this.abortConnecting = false;
            this.disconnectAndCleanConnection();
            return ConnectState.ABORT_CONNECTING;
        }
        this.fireRegistrationStateChanged(this.getRegistrationState(), RegistrationState.REGISTERING, -1, null);
        if (!loginStrategy.login(this.connection, jid)) {
            this.disconnectAndCleanConnection();
            this.eventDuringLogin = null;
            this.fireRegistrationStateChanged(this.getRegistrationState(), RegistrationState.CONNECTION_FAILED, 1, loginStrategy.getClass().getName() + " requests abort");
            return ConnectState.ABORT_CONNECTING;
        }
        if (this.connection.isAuthenticated()) {
            this.eventDuringLogin = null;
            this.fireRegistrationStateChanged(this.getRegistrationState(), RegistrationState.REGISTERED, -1, null);
            return ConnectState.STOP_TRYING;
        }
        this.disconnectAndCleanConnection();
        this.eventDuringLogin = null;
        this.fireRegistrationStateChanged(this.getRegistrationState(), RegistrationState.UNREGISTERED, -1, null);
        return ConnectState.CONTINUE_TRYING;
    }

    private X509ExtendedTrustManager getTrustManager(CertificateService cvs, String serviceName) throws GeneralSecurityException {
        return new HostTrustManager(cvs.getTrustManager(Arrays.asList(serviceName, "_xmpp-client." + serviceName)));
    }

    private void registerServiceDiscoveryManager() {
        this.discoveryManager = new ScServiceDiscoveryManager((ProtocolProviderService)this, JabberActivator.getConfigurationService(), (XMPPConnection)this.connection, new String[]{"http://jabber.org/protocol/commands"}, this.supportedFeatures.toArray(new String[this.supportedFeatures.size()]), true);
        if (this.opsetContactCapabilities != null) {
            this.opsetContactCapabilities.setDiscoveryManager(this.discoveryManager);
        }
    }

    public void disconnectAndCleanConnection() {
        if (this.connection != null) {
            this.connection.removeConnectionListener((ConnectionListener)this.connectionListener);
            try {
                OperationSetPersistentPresenceJabberImpl opSet = (OperationSetPersistentPresenceJabberImpl)this.getOperationSet(OperationSetPersistentPresence.class);
                Presence unavailablePresence = new Presence(Presence.Type.unavailable);
                if (opSet != null && StringUtils.isNotEmpty((CharSequence)opSet.getCurrentStatusMessage())) {
                    unavailablePresence.setStatus(opSet.getCurrentStatusMessage());
                }
                this.connection.disconnect(unavailablePresence);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (this.debugger != null) {
                this.debugger.setConnection(null);
                this.debugger = null;
            }
            this.connectionListener = null;
            this.connection = null;
            try {
                if (this.opsetContactCapabilities != null) {
                    this.opsetContactCapabilities.setDiscoveryManager(null);
                }
            }
            finally {
                if (this.discoveryManager != null) {
                    this.discoveryManager.stop();
                    this.discoveryManager = null;
                }
            }
        }
    }

    public void unregister() {
        this.unregisterInternal(true);
    }

    public void unregister(boolean userRequest) {
        this.unregisterInternal(true, userRequest);
    }

    public void unregisterInternal(boolean fireEvent) {
        this.unregisterInternal(fireEvent, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregisterInternal(boolean fireEvent, boolean userRequest) {
        if (fireEvent) {
            this.eventDuringLogin = null;
            this.fireRegistrationStateChanged(this.getRegistrationState(), RegistrationState.UNREGISTERING, -1, null, userRequest);
        }
        Object object = this.initializationLock;
        synchronized (object) {
            this.disconnectAndCleanConnection();
        }
        RegistrationState currRegState = this.getRegistrationState();
        if (fireEvent) {
            this.eventDuringLogin = null;
            this.fireRegistrationStateChanged(currRegState, RegistrationState.UNREGISTERED, 0, null, userRequest);
        }
    }

    public String getProtocolName() {
        return "Jabber";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void initialize(EntityBareJid screenname, JabberAccountID accountID) {
        Object object = this.initializationLock;
        synchronized (object) {
            this.accountID = accountID;
            this.supportedFeatures.clear();
            this.clearRegistrationStateChangeListener();
            this.clearSupportedOperationSet();
            String protocolIconPath = accountID.getAccountPropertyString((Object)"PROTOCOL_ICON_PATH");
            if (protocolIconPath == null) {
                protocolIconPath = "resources/images/protocol/jabber";
            }
            this.jabberIcon = new ProtocolIconJabberImpl(protocolIconPath);
            this.jabberStatusEnum = JabberStatusEnum.getJabberStatusEnum((String)protocolIconPath);
            ScServiceDiscoveryManager.initIdentity();
            this.supportedFeatures.add("http://jabber.org/protocol/disco#info");
            String keepAliveStrValue = accountID.getAccountPropertyString((Object)"KEEP_ALIVE_METHOD");
            boolean isServerStoredInfoEnabled = !accountID.getAccountPropertyBoolean((Object)IS_SERVER_STORED_INFO_DISABLED_PROPERTY, false);
            InfoRetreiver infoRetreiver = null;
            if (isServerStoredInfoEnabled) {
                infoRetreiver = new InfoRetreiver(this);
            }
            OperationSetPersistentPresenceJabberImpl persistentPresence = new OperationSetPersistentPresenceJabberImpl(this, infoRetreiver);
            this.addSupportedOperationSet(OperationSetPersistentPresence.class, (OperationSet)persistentPresence);
            this.addSupportedOperationSet(OperationSetPresence.class, (OperationSet)persistentPresence);
            if (accountID.getAccountPropertyString((Object)"READ_ONLY_GROUPS") != null) {
                this.addSupportedOperationSet(OperationSetPersistentPresencePermissions.class, (OperationSet)new OperationSetPersistentPresencePermissionsJabberImpl(this));
            }
            if (keepAliveStrValue == null || keepAliveStrValue.equalsIgnoreCase("XEP-0199")) {
                PingManager.class.getName();
                this.isKeepAliveEnabled = true;
            }
            if (!accountID.getAccountPropertyBoolean((Object)IS_IM_DISABLED_PROPERTY, false)) {
                OperationSetBasicInstantMessagingJabberImpl basicInstantMessaging = new OperationSetBasicInstantMessagingJabberImpl(this);
                this.addSupportedOperationSet(OperationSetBasicInstantMessaging.class, (OperationSet)basicInstantMessaging);
                this.addSupportedOperationSet(OperationSetTypingNotifications.class, (OperationSet)new OperationSetTypingNotificationsJabberImpl(this));
                this.addSupportedOperationSet(OperationSetInstantMessageTransform.class, (OperationSet)new OperationSetInstantMessageTransformImpl());
                this.supportedFeatures.add("urn:xmpp:message-correct:0");
                this.addSupportedOperationSet(OperationSetMessageCorrection.class, (OperationSet)basicInstantMessaging);
            }
            this.addSupportedOperationSet(OperationSetExtendedAuthorizations.class, (OperationSet)new OperationSetExtendedAuthorizationsJabberImpl(this, persistentPresence));
            this.addSupportedOperationSet(OperationSetMultiUserChat.class, (OperationSet)new OperationSetMultiUserChatJabberImpl(this));
            this.addSupportedOperationSet(OperationSetJitsiMeetTools.class, (OperationSet)new OperationSetJitsiMeetToolsJabberImpl(this));
            if (isServerStoredInfoEnabled) {
                this.addSupportedOperationSet(OperationSetServerStoredContactInfo.class, (OperationSet)new OperationSetServerStoredContactInfoJabberImpl(infoRetreiver));
                OperationSetServerStoredAccountInfoJabberImpl accountInfo = new OperationSetServerStoredAccountInfoJabberImpl(this, infoRetreiver, screenname);
                this.addSupportedOperationSet(OperationSetServerStoredAccountInfo.class, (OperationSet)accountInfo);
                this.addSupportedOperationSet(OperationSetAvatar.class, (OperationSet)new OperationSetAvatarJabberImpl(this, (OperationSetServerStoredAccountInfo)accountInfo));
            }
            if (!accountID.getAccountPropertyBoolean((Object)IS_FILE_TRANSFER_DISABLED_PROPERTY, false)) {
                this.addSupportedOperationSet(OperationSetFileTransfer.class, (OperationSet)new OperationSetFileTransferJabberImpl(this));
                this.supportedFeatures.add("urn:xmpp:bob");
                this.supportedFeatures.add("urn:xmpp:thumbs:0");
            }
            this.addSupportedOperationSet(OperationSetThumbnailedFileFactory.class, (OperationSet)new OperationSetThumbnailedFileFactoryImpl());
            this.supportedFeatures.add("http://jabber.org/protocol/muc#rooms");
            this.supportedFeatures.add("http://jabber.org/protocol/muc#traffic");
            this.supportedFeatures.add(URN_XMPP_JINGLE_RTP_HDREXT);
            ProviderManager.addIQProvider((String)"jingle", (String)URN_XMPP_JINGLE, (Object)new JingleIQProvider());
            ProviderManager.addIQProvider((String)"inputevt", (String)"http://jitsi.org/protocol/inputevt", (Object)new InputEvtIQProvider());
            ProviderManager.addIQProvider((String)"si", (String)"http://jabber.org/protocol/si", (Object)new ThumbnailStreamInitiationProvider());
            ProviderManager.addIQProvider((String)"query", (String)"google:jingleinfo", (Object)new JingleInfoQueryIQProvider());
            ProviderManager.addIQProvider((String)"conference", (String)"http://jitsi.org/protocol/colibri", (Object)new ColibriIQProvider());
            ProviderManager.addIQProvider((String)"jibri", (String)"http://jitsi.org/protocol/jibri", (Object)new JibriIqProvider());
            ProviderManager.addExtensionProvider((String)"conference", (String)"http://jitsi.org/protocol/condesc", (Object)new ConferenceDescriptionExtensionProvider());
            ProviderManager.addExtensionProvider((String)"nick", (String)"http://jabber.org/protocol/nick", (Object)new Nick.Provider());
            ProviderManager.addExtensionProvider((String)"email", (String)"jabber:client", (Object)new Email.Provider());
            ProviderManager.addExtensionProvider((String)"avatar-url", (String)"jabber:client", (Object)new AvatarUrl.Provider());
            ProviderManager.addExtensionProvider((String)"stats-id", (String)"jabber:client", (Object)new StatsId.Provider());
            ProviderManager.addExtensionProvider((String)"identity", (String)"jabber:client", (Object)new IdentityPacketExtension.Provider());
            ProviderManager.addExtensionProvider((String)"avatar-id", (String)"jabber:client", (Object)new DefaultPacketExtensionProvider(AvatarIdPacketExtension.class));
            ProviderManager.addExtensionProvider((String)"json-message", (String)"http://jitsi.org/jitmeet", (Object)new DefaultPacketExtensionProvider(JsonMessageExtension.class));
            ProviderManager.addExtensionProvider((String)"jitsi_participant_translation_language", (String)"jabber:client", (Object)new DefaultPacketExtensionProvider(TranslationLanguageExtension.class));
            ProviderManager.addExtensionProvider((String)"jitsi_participant_transcription_language", (String)"jabber:client", (Object)new DefaultPacketExtensionProvider(TranscriptionLanguageExtension.class));
            ProviderManager.addExtensionProvider((String)"transcription-status", (String)"jabber:client", (Object)new DefaultPacketExtensionProvider(TranscriptionStatusExtension.class));
            ProviderManager.addExtensionProvider((String)"jitsi_participant_requestingTranscription", (String)"jabber:client", (Object)new DefaultPacketExtensionProvider(TranscriptionRequestExtension.class));
            boolean isCallingDisabled = JabberActivator.getConfigurationService().getBoolean(IS_CALLING_DISABLED, false);
            boolean isCallingDisabledForAccount = accountID.getAccountPropertyBoolean((Object)"CALLING_DISABLED", false);
            if (!isCallingDisabled && !isCallingDisabledForAccount) {
                OperationSetBasicTelephonyJabberImpl basicTelephony = new OperationSetBasicTelephonyJabberImpl(this);
                this.addSupportedOperationSet(OperationSetAdvancedTelephony.class, (OperationSet)basicTelephony);
                this.addSupportedOperationSet(OperationSetBasicTelephony.class, (OperationSet)basicTelephony);
                this.addSupportedOperationSet(OperationSetSecureZrtpTelephony.class, (OperationSet)basicTelephony);
                this.addSupportedOperationSet(OperationSetSecureSDesTelephony.class, (OperationSet)basicTelephony);
                this.addSupportedOperationSet(OperationSetTelephonyConferencing.class, (OperationSet)new OperationSetTelephonyConferencingJabberImpl(this));
                this.addSupportedOperationSet(OperationSetBasicAutoAnswer.class, (OperationSet)new OperationSetAutoAnswerJabberImpl(this));
                this.addSupportedOperationSet(OperationSetResourceAwareTelephony.class, (OperationSet)new OperationSetResAwareTelephonyJabberImpl(basicTelephony));
                boolean isVideobridgeDisabled = JabberActivator.getConfigurationService().getBoolean("net.java.sip.communicator.service.protocol.VIDEO_BRIDGE_DISABLED", false);
                if (!isVideobridgeDisabled) {
                    this.addSupportedOperationSet(OperationSetVideoBridge.class, (OperationSet)new OperationSetVideoBridgeImpl(this));
                }
                OperationSetDTMFJabberImpl operationSetDTMF = new OperationSetDTMFJabberImpl(this);
                this.addSupportedOperationSet(OperationSetDTMF.class, (OperationSet)operationSetDTMF);
                this.addSupportedOperationSet(OperationSetIncomingDTMF.class, (OperationSet)new OperationSetIncomingDTMFJabberImpl());
                this.addJingleFeatures();
                boolean isVideoCallingDisabledForAccount = accountID.getAccountPropertyBoolean((Object)"VIDEO_CALLING_DISABLED", false);
                if (!isVideoCallingDisabledForAccount) {
                    this.supportedFeatures.add(URN_XMPP_JINGLE_RTP_VIDEO);
                    this.addSupportedOperationSet(OperationSetVideoTelephony.class, (OperationSet)new OperationSetVideoTelephonyJabberImpl(basicTelephony));
                    boolean isDesktopStreamingDisabled = JabberActivator.getConfigurationService().getBoolean(IS_DESKTOP_STREAMING_DISABLED, false);
                    boolean isAccountDesktopStreamingDisabled = accountID.getAccountPropertyBoolean((Object)"DESKTOP_STREAMING_DISABLED", false);
                    if (!isDesktopStreamingDisabled && !isAccountDesktopStreamingDisabled) {
                        this.addSupportedOperationSet(OperationSetDesktopStreaming.class, (OperationSet)new OperationSetDesktopStreamingJabberImpl(basicTelephony));
                        if (!accountID.getAccountPropertyBoolean((Object)"DESKTOP_REMOTE_CONTROL_DISABLED", false)) {
                            this.addSupportedOperationSet(OperationSetDesktopSharingServer.class, (OperationSet)new OperationSetDesktopSharingServerJabberImpl(basicTelephony));
                            this.supportedFeatures.add("http://jitsi.org/protocol/inputevt/sharer");
                            this.addSupportedOperationSet(OperationSetDesktopSharingClient.class, (OperationSet)new OperationSetDesktopSharingClientJabberImpl(this));
                            this.supportedFeatures.add("http://jitsi.org/protocol/inputevt/sharee");
                        }
                    }
                }
            }
            this.opsetContactCapabilities = new OperationSetContactCapabilitiesJabberImpl(this);
            if (this.discoveryManager != null) {
                this.opsetContactCapabilities.setDiscoveryManager(this.discoveryManager);
            }
            this.addSupportedOperationSet(OperationSetContactCapabilities.class, (OperationSet)this.opsetContactCapabilities);
            OperationSetChangePasswordJabberImpl opsetChangePassword = new OperationSetChangePasswordJabberImpl(this);
            this.addSupportedOperationSet(OperationSetChangePassword.class, (OperationSet)opsetChangePassword);
            OperationSetCusaxUtilsJabberImpl opsetCusaxCusaxUtils = new OperationSetCusaxUtilsJabberImpl();
            this.addSupportedOperationSet(OperationSetCusaxUtils.class, (OperationSet)opsetCusaxCusaxUtils);
            boolean isUserSearchEnabled = accountID.getAccountPropertyBoolean((Object)IS_USER_SEARCH_ENABLED_PROPERTY, false);
            if (isUserSearchEnabled) {
                this.addSupportedOperationSet(OperationSetUserSearch.class, (OperationSet)new OperationSetUserSearchJabberImpl(this));
            }
            OperationSetTLSJabberImpl opsetTLS = new OperationSetTLSJabberImpl(this);
            this.addSupportedOperationSet(OperationSetTLS.class, (OperationSet)opsetTLS);
            OperationSetConnectionInfoJabberImpl opsetConnectionInfo = new OperationSetConnectionInfoJabberImpl();
            this.addSupportedOperationSet(OperationSetConnectionInfo.class, (OperationSet)opsetConnectionInfo);
            this.isInitialized = true;
        }
    }

    private void addJingleFeatures() {
        this.supportedFeatures.add(URN_XMPP_JINGLE);
        this.supportedFeatures.add(URN_XMPP_JINGLE_RTP);
        this.supportedFeatures.add(URN_XMPP_JINGLE_RAW_UDP_0);
        if (this.accountID.getAccountPropertyBoolean((Object)"ICE_ENABLED", true)) {
            this.supportedFeatures.add(URN_XMPP_JINGLE_ICE_UDP_1);
        }
        this.supportedFeatures.add(URN_XMPP_JINGLE_RTP_AUDIO);
        this.supportedFeatures.add(URN_XMPP_JINGLE_RTP_ZRTP);
        if (this.accountID.getAccountPropertyBoolean((Object)"JINGLE_NODES_ENABLED", true)) {
            this.supportedFeatures.add(URN_XMPP_JINGLE_NODES);
        }
        this.supportedFeatures.add(URN_XMPP_JINGLE_TRANSFER_0);
        if (this.accountID.getAccountPropertyBoolean((Object)"DEFAULT_ENCRYPTION", true) && this.accountID.isEncryptionProtocolEnabled(SrtpControlType.DTLS_SRTP)) {
            this.supportedFeatures.add(URN_XMPP_JINGLE_DTLS_SRTP);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown() {
        Object object = this.initializationLock;
        synchronized (object) {
            OperationSetBasicTelephonyJabberImpl telephony;
            if (logger.isTraceEnabled()) {
                logger.trace((Object)"Killing the Jabber Protocol Provider.");
            }
            if ((telephony = (OperationSetBasicTelephonyJabberImpl)this.getOperationSet(OperationSetBasicTelephony.class)) != null) {
                telephony.shutdown();
            }
            this.disconnectAndCleanConnection();
            this.isInitialized = false;
        }
    }

    public boolean isInitialized() {
        return this.isInitialized;
    }

    public AccountID getAccountID() {
        return this.accountID;
    }

    public boolean validateContactAddress(String contactId, List<String> result) {
        if (result == null) {
            throw new IllegalArgumentException("result must be an empty list");
        }
        result.clear();
        try {
            contactId = contactId.trim();
            if (contactId.length() == 0) {
                result.add(JabberActivator.getResources().getI18NString("impl.protocol.jabber.INVALID_ADDRESS", new String[]{contactId}));
                return false;
            }
            String user = contactId;
            String remainder = "";
            int at = contactId.indexOf(64);
            if (at > -1) {
                user = contactId.substring(0, at);
                remainder = contactId.substring(at);
            }
            boolean valid = true;
            String suggestion = "";
            for (char c : user.toCharArray()) {
                if (!(c == '!' || c >= '#' && c <= '%' || c >= '(' && c <= '.' || c >= '0' && c <= '9' || c == ';' || c == '=' || c == '?' || c >= 'A' && c <= '~' || c >= '\u0080' && c <= '\ud7ff' || c >= '\ue000' && c <= '\ufffd')) {
                    valid = false;
                    continue;
                }
                suggestion = suggestion + c;
            }
            if (!valid) {
                result.add(JabberActivator.getResources().getI18NString("impl.protocol.jabber.INVALID_ADDRESS", new String[]{contactId}));
                result.add(suggestion + remainder);
                return false;
            }
            return true;
        }
        catch (Exception ex) {
            result.add(JabberActivator.getResources().getI18NString("impl.protocol.jabber.INVALID_ADDRESS", new String[]{contactId}));
            return false;
        }
    }

    public XMPPConnection getConnection() {
        return this.connection;
    }

    private boolean isAuthenticationFailed(Exception ex) {
        String exMsg = ex.getMessage().toLowerCase();
        return exMsg.contains("sasl authentication") && exMsg.contains("failed") || exMsg.contains("does not support compatible authentication mechanism") || exMsg.contains("unable to determine password");
    }

    private void fireRegistrationStateChanged(Exception ex) {
        int reason = -1;
        RegistrationState regState = RegistrationState.UNREGISTERED;
        String reasonStr = null;
        if (ex instanceof UnknownHostException || ex instanceof ConnectException || ex instanceof SocketException) {
            reason = 8;
            regState = RegistrationState.CONNECTION_FAILED;
        } else {
            String exMsg = ex.getMessage().toLowerCase();
            if (this.isAuthenticationFailed(ex)) {
                JabberActivator.getProtocolProviderFactory().storePassword(this.getAccountID(), null);
                reason = 1;
                regState = RegistrationState.AUTHENTICATION_FAILED;
                this.fireRegistrationStateChanged(this.getRegistrationState(), regState, reason, null);
                this.reregister(1);
                return;
            }
            if (exMsg.indexOf("no response from the server") != -1 || exMsg.indexOf("connection failed") != -1) {
                reason = -1;
                regState = RegistrationState.CONNECTION_FAILED;
            } else if (exMsg.indexOf("tls is required") != -1) {
                regState = RegistrationState.AUTHENTICATION_FAILED;
                reason = 9;
            }
        }
        if (regState == RegistrationState.UNREGISTERED || regState == RegistrationState.CONNECTION_FAILED) {
            this.disconnectAndCleanConnection();
        }
        this.fireRegistrationStateChanged(this.getRegistrationState(), regState, reason, reasonStr);
    }

    public ProtocolIcon getProtocolIcon() {
        return this.jabberIcon;
    }

    JabberStatusEnum getJabberStatusEnum() {
        return this.jabberStatusEnum;
    }

    public boolean isFeatureListSupported(Jid jid, String ... features) {
        if (this.discoveryManager == null) {
            return false;
        }
        DiscoverInfo featureInfo = this.discoveryManager.discoverInfoNonBlocking(jid);
        if (featureInfo == null) {
            return false;
        }
        for (String feature : features) {
            if (featureInfo.containsFeature((CharSequence)feature)) continue;
            return false;
        }
        return true;
    }

    public boolean isFeatureSupported(Jid jid, String feature) {
        return this.isFeatureListSupported(jid, feature);
    }

    public Jid getFullJid(Contact contact) throws XmppStringprepException {
        return this.getFullJid(JidCreate.bareFrom((String)contact.getAddress()));
    }

    public Jid getFullJid(BareJid bareJid) {
        XMPPConnection connection = this.getConnection();
        if (connection == null || !connection.isConnected()) {
            return null;
        }
        Roster roster = Roster.getInstanceFor((XMPPConnection)connection);
        if (roster != null) {
            return roster.getPresence(bareJid).getFrom();
        }
        return null;
    }

    public ScServiceDiscoveryManager getDiscoveryManager() {
        return this.discoveryManager;
    }

    public Jid getOurJID() {
        EntityFullJid jid = null;
        if (this.connection != null) {
            jid = this.connection.getUser();
        }
        if (jid == null) {
            String accountIDUserID = this.getAccountID().getUserID();
            try {
                jid = JidCreate.bareFrom((String)accountIDUserID);
            }
            catch (XmppStringprepException e) {
                logger.error((Object)"Invalid JID", (Throwable)e);
                return null;
            }
        }
        return jid;
    }

    public InetAddress getNextHop() throws IllegalArgumentException {
        InetAddress nextHop = null;
        String nextHopStr = null;
        nextHopStr = this.proxy != null ? this.proxy.getProxyAddress() : this.getConnection().getHost();
        try {
            nextHop = NetworkUtils.getInetAddress((String)nextHopStr);
        }
        catch (UnknownHostException ex) {
            throw new IllegalArgumentException("seems we don't have a valid next hop.", ex);
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Returning address " + nextHop + " as next hop."));
        }
        return nextHop;
    }

    public void startJingleNodesDiscovery() {
        JabberAccountIDImpl accID = (JabberAccountIDImpl)this.getAccountID();
        if (!accID.isJingleNodesRelayEnabled()) {
            return;
        }
        SmackServiceNode service = new SmackServiceNode(this.connection, 60000L);
        this.connection.addConnectionListener((ConnectionListener)service);
        for (JingleNodeDescriptor desc : accID.getJingleNodes()) {
            TrackerEntry entry = new TrackerEntry(desc.isRelaySupported() ? TrackerEntry.Type.relay : TrackerEntry.Type.tracker, TrackerEntry.Policy._public, desc.getJID(), "udp");
            service.addTrackerEntry(entry);
        }
        new Thread(new JingleNodesServiceDiscovery(service, (XMPPConnection)this.connection, accID, this.jingleNodesSyncRoot)).start();
        this.jingleNodesServiceNode = service;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SmackServiceNode getJingleNodesServiceNode() {
        Object object = this.jingleNodesSyncRoot;
        synchronized (object) {
            return this.jingleNodesServiceNode;
        }
    }

    public static void throwOperationFailedException(String message, int errorCode, Throwable cause, Logger logger) throws OperationFailedException {
        logger.error((Object)message, cause);
        if (cause == null) {
            throw new OperationFailedException(message, errorCode);
        }
        throw new OperationFailedException(message, errorCode, cause);
    }

    public SecurityAuthority getAuthority() {
        return this.authority;
    }

    UserCredentials getUserCredentials() {
        return this.userCredentials;
    }

    public boolean isGmailOrGoogleAppsAccount() {
        try {
            String domain = JidCreate.domainBareFrom((String)this.getAccountID().getUserID()).toString();
            return ProtocolProviderServiceJabberImpl.isGmailOrGoogleAppsAccount(domain);
        }
        catch (XmppStringprepException e) {
            return false;
        }
    }

    public static boolean isGmailOrGoogleAppsAccount(String domain) {
        SRVRecord[] srvRecords = null;
        try {
            srvRecords = NetworkUtils.getSRVRecords((String)"xmpp-client", (String)"tcp", (String)domain);
        }
        catch (ParseException e) {
            logger.info((Object)"Failed to get SRV records for XMPP domain");
            return false;
        }
        catch (DnssecException e) {
            logger.error((Object)"DNSSEC failure while checking for google domains", (Throwable)e);
            return false;
        }
        if (srvRecords == null) {
            return false;
        }
        for (SRVRecord srv : srvRecords) {
            if (!srv.getTarget().endsWith("google.com") && !srv.getTarget().endsWith("google.com.")) continue;
            return true;
        }
        return false;
    }

    private void setTrafficClass() {
        ConfigurationService configService;
        String dscp;
        Socket s = this.getSocket();
        if (s != null && (dscp = (configService = JabberActivator.getConfigurationService()).getString(XMPP_DSCP_PROPERTY)) != null) {
            try {
                int dscpInt = Integer.parseInt(dscp) << 2;
                if (dscpInt > 0) {
                    s.setTrafficClass(dscpInt);
                }
            }
            catch (Exception e) {
                logger.info((Object)"Failed to set trafficClass", (Throwable)e);
            }
        }
    }

    public Jid getJitsiVideobridge() {
        XMPPConnection connection = this.getConnection();
        if (connection != null) {
            DiscoverItems discoverItems;
            ScServiceDiscoveryManager discoveryManager;
            block7: {
                discoveryManager = this.getDiscoveryManager();
                DomainBareJid serviceName = connection.getServiceName();
                discoverItems = null;
                try {
                    discoverItems = discoveryManager.discoverItems((Jid)serviceName);
                }
                catch (InterruptedException | SmackException.NoResponseException | SmackException.NotConnectedException | XMPPException xmppe) {
                    if (!logger.isDebugEnabled()) break block7;
                    logger.debug((Object)("Failed to discover the items associated with Jabber entity: " + serviceName), xmppe);
                }
            }
            if (discoverItems != null) {
                for (DiscoverItems.Item discoverItem : discoverItems.getItems()) {
                    Jid entityID = discoverItem.getEntityID();
                    DiscoverInfo discoverInfo = null;
                    try {
                        discoverInfo = discoveryManager.discoverInfo(entityID);
                    }
                    catch (InterruptedException | SmackException.NoResponseException | SmackException.NotConnectedException | XMPPException xmppe) {
                        logger.warn((Object)("Failed to discover information about Jabber entity: " + entityID), xmppe);
                    }
                    if (discoverInfo == null || !discoverInfo.containsFeature((CharSequence)"http://jitsi.org/protocol/colibri")) continue;
                    return entityID;
                }
            }
        }
        return null;
    }

    private Socket getSocket() {
        if (this.connection == null) {
            return null;
        }
        if (this.connection instanceof XMPPTCPConnection) {
            try {
                Field socket = this.connection.getClass().getField("socket");
                socket.setAccessible(true);
                return (Socket)socket.get(this.connection);
            }
            catch (IllegalAccessException | NoSuchFieldException e) {
                return null;
            }
        }
        return null;
    }

    SSLSocket getSSLSocket() {
        Socket socket = this.getSocket();
        return socket instanceof SSLSocket ? (SSLSocket)socket : null;
    }

    private class HostTrustManager
    extends X509ExtendedTrustManager {
        private final X509TrustManager tm;

        HostTrustManager(X509TrustManager tm) {
            this.tm = tm;
        }

        @Override
        public X509Certificate[] getAcceptedIssuers() {
            return new X509Certificate[0];
        }

        @Override
        public void checkClientTrusted(X509Certificate[] chain, String authType) throws CertificateException, UnsupportedOperationException {
            throw new UnsupportedOperationException();
        }

        @Override
        public void checkClientTrusted(X509Certificate[] chain, String authType, Socket socket) throws CertificateException {
            throw new UnsupportedOperationException();
        }

        @Override
        public void checkServerTrusted(X509Certificate[] chain, String authType, Socket socket) throws CertificateException {
            this.checkServerTrusted(chain, authType);
        }

        @Override
        public void checkClientTrusted(X509Certificate[] chain, String authType, SSLEngine engine) throws CertificateException {
            throw new UnsupportedOperationException();
        }

        @Override
        public void checkServerTrusted(X509Certificate[] chain, String authType, SSLEngine engine) throws CertificateException {
            this.checkServerTrusted(chain, authType);
        }

        @Override
        public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
            ProtocolProviderServiceJabberImpl.this.abortConnecting = true;
            try {
                this.tm.checkServerTrusted(chain, authType);
            }
            catch (CertificateException e) {
                new Thread(new Runnable(){

                    @Override
                    public void run() {
                        ProtocolProviderServiceJabberImpl.this.fireRegistrationStateChanged(ProtocolProviderServiceJabberImpl.this.getRegistrationState(), RegistrationState.UNREGISTERED, 0, "Not trusted certificate");
                    }
                }).start();
                throw e;
            }
            if (ProtocolProviderServiceJabberImpl.this.abortConnecting) {
                ProtocolProviderServiceJabberImpl.this.abortConnecting = false;
                return;
            }
            new Thread(new Runnable(){

                @Override
                public void run() {
                    ProtocolProviderServiceJabberImpl.this.reregister(3);
                }
            }).start();
        }
    }

    private class JabberConnectionListener
    implements ConnectionListener {
        private JabberConnectionListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void connectionClosed() {
            Object object = ProtocolProviderServiceJabberImpl.this.connectAndLoginLock;
            synchronized (object) {
                if (ProtocolProviderServiceJabberImpl.this.inConnectAndLogin) {
                    ProtocolProviderServiceJabberImpl.this.eventDuringLogin = new RegistrationStateChangeEvent((ProtocolProviderService)ProtocolProviderServiceJabberImpl.this, ProtocolProviderServiceJabberImpl.this.getRegistrationState(), RegistrationState.CONNECTION_FAILED, -1, null);
                    return;
                }
            }
            ProtocolProviderServiceJabberImpl.this.fireRegistrationStateChanged(ProtocolProviderServiceJabberImpl.this.getRegistrationState(), RegistrationState.CONNECTION_FAILED, -1, null);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void connectionClosedOnError(Exception exception) {
            logger.error((Object)("connectionClosedOnError " + exception.getLocalizedMessage()), (Throwable)exception);
            int reason = -1;
            if (exception instanceof XMPPException.StreamErrorException) {
                StreamError err = ((XMPPException.StreamErrorException)exception).getStreamError();
                if (err != null && err.getCondition() == StreamError.Condition.conflict) {
                    Object object = ProtocolProviderServiceJabberImpl.this.connectAndLoginLock;
                    synchronized (object) {
                        if (ProtocolProviderServiceJabberImpl.this.inConnectAndLogin) {
                            ProtocolProviderServiceJabberImpl.this.eventDuringLogin = new RegistrationStateChangeEvent((ProtocolProviderService)ProtocolProviderServiceJabberImpl.this, ProtocolProviderServiceJabberImpl.this.getRegistrationState(), RegistrationState.UNREGISTERED, 2, "Connecting multiple times with the same resource");
                            return;
                        }
                    }
                    ProtocolProviderServiceJabberImpl.this.fireRegistrationStateChanged(ProtocolProviderServiceJabberImpl.this.getRegistrationState(), RegistrationState.UNREGISTERED, 2, "Connecting multiple times with the same resource");
                    ProtocolProviderServiceJabberImpl.this.disconnectAndCleanConnection();
                    return;
                }
            } else {
                if (exception instanceof SSLHandshakeException && exception.getCause() instanceof CertificateException) {
                    return;
                }
                if (exception instanceof XmlPullParserException) {
                    reason = 10;
                }
            }
            Object object = ProtocolProviderServiceJabberImpl.this.connectAndLoginLock;
            synchronized (object) {
                if (ProtocolProviderServiceJabberImpl.this.inConnectAndLogin) {
                    ProtocolProviderServiceJabberImpl.this.eventDuringLogin = new RegistrationStateChangeEvent((ProtocolProviderService)ProtocolProviderServiceJabberImpl.this, ProtocolProviderServiceJabberImpl.this.getRegistrationState(), RegistrationState.CONNECTION_FAILED, reason, exception.getMessage());
                    return;
                }
            }
            ProtocolProviderServiceJabberImpl.this.fireRegistrationStateChanged(ProtocolProviderServiceJabberImpl.this.getRegistrationState(), RegistrationState.CONNECTION_FAILED, reason, exception.getMessage());
            ProtocolProviderServiceJabberImpl.this.disconnectAndCleanConnection();
        }

        public void reconnectingIn(int i) {
            if (logger.isInfoEnabled()) {
                logger.info((Object)("reconnectingIn " + i));
            }
        }

        public void reconnectionSuccessful() {
            if (logger.isInfoEnabled()) {
                logger.info((Object)"reconnectionSuccessful");
            }
        }

        public void reconnectionFailed(Exception exception) {
            if (logger.isInfoEnabled()) {
                logger.info((Object)"reconnectionFailed ", (Throwable)exception);
            }
        }

        public void connected(XMPPConnection xmppConnection) {
            logger.info((Object)"Connected");
        }

        public void authenticated(XMPPConnection xmppConnection, boolean b) {
            logger.info((Object)("Authenticated: " + b));
        }
    }

    private class OperationSetConnectionInfoJabberImpl
    implements OperationSetConnectionInfo {
        private OperationSetConnectionInfoJabberImpl() {
        }

        public InetSocketAddress getServerAddress() {
            return ProtocolProviderServiceJabberImpl.this.address;
        }
    }

    static enum ConnectState {
        ABORT_CONNECTING,
        CONTINUE_TRYING,
        STOP_TRYING;

    }
}

