/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.impl.dns;

import java.net.InetSocketAddress;
import net.java.sip.communicator.impl.dns.ConfigurableDnssecResolver;
import net.java.sip.communicator.impl.dns.DnsJavaLogger;
import net.java.sip.communicator.impl.dns.ParallelResolverImpl;
import net.java.sip.communicator.service.dns.CustomResolver;
import net.java.sip.communicator.service.netaddr.NetworkAddressManagerService;
import net.java.sip.communicator.service.netaddr.event.ChangeEvent;
import net.java.sip.communicator.service.netaddr.event.NetworkConfigurationChangeListener;
import net.java.sip.communicator.service.notification.NotificationService;
import net.java.sip.communicator.service.resources.ResourceManagementServiceUtils;
import net.java.sip.communicator.util.Logger;
import net.java.sip.communicator.util.ServiceUtils;
import net.java.sip.communicator.util.UtilActivator;
import org.apache.commons.lang3.StringUtils;
import org.jitsi.service.configuration.ConfigurationService;
import org.jitsi.service.resources.ResourceManagementService;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceEvent;
import org.osgi.framework.ServiceListener;
import org.xbill.DNS.ExtendedResolver;
import org.xbill.DNS.Lookup;
import org.xbill.DNS.Options;
import org.xbill.DNS.PacketLogger;
import org.xbill.DNS.Resolver;
import org.xbill.DNS.ResolverConfig;
import org.xbill.DNS.SimpleResolver;

public class DnsUtilActivator
implements BundleActivator,
ServiceListener {
    private static final Logger logger = Logger.getLogger(DnsUtilActivator.class);
    public static final String PNAME_DNSSEC_NAMESERVERS = "net.java.sip.communicator.util.dns.DNSSEC_NAMESERVERS";
    private static ConfigurationService configurationService;
    private static NotificationService notificationService;
    private static ResourceManagementService resourceService;
    private static BundleContext bundleContext;
    public static final String DEFAULT_BACKUP_RESOLVER = "backup-resolver.jitsi.net";
    public static final String PNAME_BACKUP_RESOLVER_PORT = "net.java.sip.communicator.util.dns.BACKUP_RESOLVER_PORT";
    public static final String PNAME_BACKUP_RESOLVER_FALLBACK_IP = "net.java.sip.communicator.util.dns.BACKUP_RESOLVER_FALLBACK_IP";
    public static final boolean PDEFAULT_BACKUP_RESOLVER_ENABLED = true;
    public static final String PNAME_BACKUP_RESOLVER_ENABLED = "net.java.sip.communicator.util.dns.BACKUP_RESOLVER_ENABLED";
    public static final String PNAME_BACKUP_RESOLVER = "net.java.sip.communicator.util.dns.BACKUP_RESOLVER";

    public void start(BundleContext context) throws Exception {
        logger.info((Object)"DNS service ... [STARTING]");
        bundleContext = context;
        context.addServiceListener((ServiceListener)this);
        if (Logger.getLogger((String)"org.xbill").isTraceEnabled()) {
            Options.set((String)"verbose", (String)"1");
        }
        Lookup.setPacketLogger((PacketLogger)new DnsJavaLogger());
        if (DnsUtilActivator.loadDNSProxyForward()) {
            return;
        }
        if (UtilActivator.getConfigurationService().getBoolean(PNAME_BACKUP_RESOLVER_ENABLED, true) && !DnsUtilActivator.getConfigurationService().getBoolean("net.java.sip.communicator.util.dns.DNSSEC_ENABLED", false)) {
            bundleContext.registerService(CustomResolver.class.getName(), (Object)new ParallelResolverImpl(), null);
            logger.info((Object)"ParallelResolver ... [REGISTERED]");
        }
        if (DnsUtilActivator.getConfigurationService().getBoolean("net.java.sip.communicator.util.dns.DNSSEC_ENABLED", false)) {
            bundleContext.registerService(CustomResolver.class.getName(), (Object)new ConfigurableDnssecResolver(new ExtendedResolver()), null);
            logger.info((Object)"DnssecResolver ... [REGISTERED]");
        }
        logger.info((Object)"DNS service ... [STARTED]");
    }

    private static boolean loadDNSProxyForward() {
        if (DnsUtilActivator.getConfigurationService().getBoolean("net.java.sip.communicator.service.connectionProxyForwardDNS", false)) {
            try {
                String serverAddress = (String)DnsUtilActivator.getConfigurationService().getProperty("net.java.sip.communicator.service.connectionProxyForwardDNSAddress");
                if (StringUtils.isBlank((CharSequence)serverAddress)) {
                    return false;
                }
                int port = 53;
                try {
                    port = DnsUtilActivator.getConfigurationService().getInt("net.java.sip.communicator.service.connectionProxyForwardDNSPort", 53);
                }
                catch (NumberFormatException ne) {
                    logger.error((Object)"Wrong port value", (Throwable)ne);
                }
                SimpleResolver sResolver = new SimpleResolver("0");
                sResolver.setAddress(new InetSocketAddress(serverAddress, port));
                Lookup.setDefaultResolver((Resolver)sResolver);
                return true;
            }
            catch (Throwable t) {
                logger.error((Object)"Creating simple forwarding resolver", t);
            }
        }
        return false;
    }

    public static void reloadDnsResolverConfig() {
        ResolverConfig.refresh();
        DnsUtilActivator.logDNSServers();
        if (Lookup.getDefaultResolver() instanceof CustomResolver) {
            if (logger.isInfoEnabled()) {
                logger.info((Object)("Resetting custom resolver " + Lookup.getDefaultResolver().getClass().getSimpleName()));
            }
            ((CustomResolver)Lookup.getDefaultResolver()).reset();
        } else if (!DnsUtilActivator.loadDNSProxyForward()) {
            Lookup.refreshDefault();
        }
    }

    private static void logDNSServers() {
        if (logger.isInfoEnabled()) {
            StringBuilder sb = new StringBuilder();
            sb.append("Loading or Reloading resolver config, ").append("default DNS servers are: ");
            ResolverConfig config = ResolverConfig.getCurrentConfig();
            if (config != null && config.servers() != null) {
                for (String s : config.servers()) {
                    sb.append(s);
                    sb.append(", ");
                }
            } else {
                sb.append("undefined");
            }
            logger.info((Object)sb.toString());
        }
    }

    public void stop(BundleContext context) throws Exception {
    }

    public static ConfigurationService getConfigurationService() {
        if (configurationService == null) {
            configurationService = (ConfigurationService)ServiceUtils.getService((BundleContext)bundleContext, ConfigurationService.class);
        }
        return configurationService;
    }

    public static NotificationService getNotificationService() {
        if (notificationService == null) {
            notificationService = (NotificationService)ServiceUtils.getService((BundleContext)bundleContext, NotificationService.class);
        }
        return notificationService;
    }

    public static ResourceManagementService getResources() {
        if (resourceService == null) {
            resourceService = ResourceManagementServiceUtils.getService((BundleContext)bundleContext);
        }
        return resourceService;
    }

    public void serviceChanged(ServiceEvent event) {
        if (event.getType() != 1) {
            return;
        }
        Object service = bundleContext.getService(event.getServiceReference());
        if (!(service instanceof NetworkAddressManagerService)) {
            return;
        }
        ((NetworkAddressManagerService)service).addNetworkConfigurationChangeListener((NetworkConfigurationChangeListener)new NetworkListener());
    }

    private static class NetworkListener
    implements NetworkConfigurationChangeListener {
        private NetworkListener() {
        }

        public void configurationChanged(ChangeEvent event) {
            if (event.getType() == 1 || event.getType() == 0 || event.getType() == 4) {
                if (event.isInitial()) {
                    DnsUtilActivator.logDNSServers();
                } else {
                    DnsUtilActivator.reloadDnsResolverConfig();
                }
            }
        }
    }
}

