/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.plugin.addrbook.msoutlook;

import java.util.Vector;
import java.util.regex.Pattern;
import net.java.sip.communicator.plugin.addrbook.AddrBookActivator;
import net.java.sip.communicator.plugin.addrbook.msoutlook.DefaultMailClientMessageDialog;
import net.java.sip.communicator.plugin.addrbook.msoutlook.MsOutlookAddrBookContactQuery;
import net.java.sip.communicator.plugin.addrbook.msoutlook.MsOutlookMAPIHResultException;
import net.java.sip.communicator.plugin.addrbook.msoutlook.RegistryHandler;
import net.java.sip.communicator.service.contactsource.AsyncContactSourceService;
import net.java.sip.communicator.service.contactsource.ContactQuery;
import net.java.sip.communicator.service.contactsource.EditableContactSourceService;
import net.java.sip.communicator.service.contactsource.PrefixedContactSourceService;
import net.java.sip.communicator.util.Logger;

public class MsOutlookAddrBookContactSourceService
extends AsyncContactSourceService
implements EditableContactSourceService,
PrefixedContactSourceService {
    private static final Logger logger = Logger.getLogger(MsOutlookAddrBookContactSourceService.class);
    public static final String OUTLOOK_ADDR_BOOK_PREFIX = "net.java.sip.communicator.plugin.addrbook.OUTLOOK_ADDR_BOOK_PREFIX";
    public static final String PNAME_OUTLOOK_ADDR_BOOK_SEARCH_FIELD_DISABLED = "net.java.sip.communicator.plugin.addrbook.OUTLOOK_ADDR_BOOK_SEARCH_FIELD_DISABLED";
    public static final String PNAME_OUTLOOK_ADDR_BOOK_SHOW_DEFAULTMAILCLIENT_WARNING = "net.java.sip.communicator.plugin.addrbook.SHOW_DEFAULTMAILCLIENT_WARNING";
    private static final long MAPI_INIT_VERSION = 0L;
    private static final long MAPI_MULTITHREAD_NOTIFICATIONS = 1L;
    private static final int NATIVE_LOGGER_LEVEL_INFO = 0;
    private static final int NATIVE_LOGGER_LEVEL_TRACE = 1;
    private NotificationThread notificationThread = null;
    private Object notificationThreadMutex = new Object();
    private MsOutlookAddrBookContactQuery latestQuery = null;
    private static boolean isMAPIInitialized = false;

    public static void initMAPI(NotificationsDelegate notificationDelegate) throws MsOutlookMAPIHResultException {
        if (!isMAPIInitialized) {
            boolean isOutlookDefaultMailClient = MsOutlookAddrBookContactSourceService.isOutlookDefaultMailClient();
            boolean showWarning = AddrBookActivator.getConfigService().getBoolean(PNAME_OUTLOOK_ADDR_BOOK_SHOW_DEFAULTMAILCLIENT_WARNING, true);
            if (!isOutlookDefaultMailClient && showWarning) {
                DefaultMailClientMessageDialog dialog = new DefaultMailClientMessageDialog();
                int result = dialog.showDialog();
                if ((result & DefaultMailClientMessageDialog.DONT_ASK_SELECTED_MASK) != 0) {
                    AddrBookActivator.getConfigService().setProperty(PNAME_OUTLOOK_ADDR_BOOK_SHOW_DEFAULTMAILCLIENT_WARNING, (Object)false);
                }
                if ((result & DefaultMailClientMessageDialog.DEFAULT_MAIL_CLIENT_SELECTED_MASK) != 0) {
                    RegistryHandler.setOutlookAsDefaultMailClient();
                }
            }
            if (isOutlookDefaultMailClient && !showWarning) {
                AddrBookActivator.getConfigService().setProperty(PNAME_OUTLOOK_ADDR_BOOK_SHOW_DEFAULTMAILCLIENT_WARNING, (Object)true);
            }
            String logFileName = "";
            String homeLocation = System.getProperty("net.java.sip.communicator.SC_LOG_DIR_LOCATION");
            String dirName = System.getProperty("net.java.sip.communicator.SC_HOME_DIR_NAME");
            if (homeLocation != null && dirName != null) {
                logFileName = homeLocation + "\\" + dirName + "\\log\\";
            }
            int logLevel = 0;
            if (logger.isTraceEnabled()) {
                logLevel = 1;
            }
            logger.info((Object)("Init mapi with log level " + logLevel + " and log file path " + logFileName));
            MsOutlookAddrBookContactSourceService.MAPIInitialize(0L, 1L, notificationDelegate, logFileName, logLevel);
            isMAPIInitialized = true;
        }
    }

    public NotificationsDelegate createNotificationDelegate() {
        return new NotificationsDelegate();
    }

    public String getDisplayName() {
        return "Microsoft Outlook";
    }

    public int getType() {
        return 1;
    }

    private static native void MAPIInitialize(long var0, long var2, NotificationsDelegate var4, String var5, int var6) throws MsOutlookMAPIHResultException;

    public static void UninitializeMAPI() {
        if (isMAPIInitialized) {
            MsOutlookAddrBookContactSourceService.MAPIUninitialize();
            isMAPIInitialized = false;
        }
    }

    private static native void MAPIUninitialize();

    public static native int getOutlookBitnessVersion();

    public static native int getOutlookVersion();

    private static native boolean isOutlookDefaultMailClient();

    public ContactQuery createContactQuery(Pattern query) {
        if (this.latestQuery != null) {
            this.latestQuery.clear();
        }
        this.latestQuery = new MsOutlookAddrBookContactQuery(this, query);
        return this.latestQuery;
    }

    public void stop() {
        if (this.latestQuery != null) {
            this.latestQuery.clear();
            this.latestQuery = null;
        }
        MsOutlookAddrBookContactSourceService.UninitializeMAPI();
    }

    public String getPhoneNumberPrefix() {
        return AddrBookActivator.getConfigService().getString(OUTLOOK_ADDR_BOOK_PREFIX);
    }

    public int getIndex() {
        return -1;
    }

    public String createContact() {
        return MsOutlookAddrBookContactQuery.createContact();
    }

    public void addEmptyContact(String id) {
        if (id != null && this.latestQuery != null) {
            this.latestQuery.addEmptyContact(id);
        }
    }

    public void deleteContact(String id) {
        if (id != null && MsOutlookAddrBookContactQuery.deleteContact(id) && this.latestQuery != null) {
            this.latestQuery.deleted(id);
        }
    }

    public boolean canBeUsedToSearchContacts() {
        return !AddrBookActivator.getConfigService().getBoolean(PNAME_OUTLOOK_ADDR_BOOK_SEARCH_FIELD_DISABLED, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addNotification(String id, char function) {
        Object object = this.notificationThreadMutex;
        synchronized (object) {
            if (this.notificationThread == null || !this.notificationThread.isAlive()) {
                this.notificationThread = new NotificationThread();
                this.notificationThread.start();
            }
            this.notificationThread.add(id, function);
        }
    }

    public int getBitness() {
        return MsOutlookAddrBookContactSourceService.getOutlookBitnessVersion();
    }

    public int getVersion() {
        return MsOutlookAddrBookContactSourceService.getOutlookVersion();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getNbRemainingNotifications() {
        int nbNotifications = 0;
        Object object = this.notificationThreadMutex;
        synchronized (object) {
            if (this.notificationThread != null) {
                nbNotifications = this.notificationThread.getNbRemainingNotifications();
            }
        }
        return nbNotifications;
    }

    public void clearRemainingNotifications() {
        if (this.notificationThread != null) {
            this.notificationThread.clear();
        }
    }

    static {
        String lib = "jmsoutlookaddrbook";
        try {
            System.loadLibrary(lib);
        }
        catch (Throwable t) {
            logger.error((Object)("Failed to load native library " + lib + ": " + t.getMessage()));
            throw new RuntimeException(t);
        }
        try {
            Class.forName(MsOutlookAddrBookContactQuery.class.getName());
        }
        catch (ClassNotFoundException cnfe) {
            throw new RuntimeException(cnfe);
        }
        int bitness = MsOutlookAddrBookContactSourceService.getOutlookBitnessVersion();
        int version = MsOutlookAddrBookContactSourceService.getOutlookVersion();
        if (bitness != -1 && version != -1) {
            logger.info((Object)("Outlook " + version + "-x" + bitness + " is installed."));
        }
    }

    private class NotificationIdFunction {
        private String id;
        private char function;

        public NotificationIdFunction(String id, char function) {
            this.id = id;
            this.function = function;
        }

        public String getId() {
            return this.id;
        }

        public char getFunction() {
            return this.function;
        }

        public boolean equals(Object obj) {
            return this.id == null && obj == null || obj instanceof String && this.id.equals(obj);
        }

        public int hashCode() {
            return this.id.hashCode();
        }
    }

    private class NotificationThread
    extends Thread {
        private Vector<NotificationIdFunction> contactIds;

        public NotificationThread() {
            super("MsOutlookAddrbookContactSourceService notification thread");
            this.contactIds = new Vector();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            boolean hasMore;
            NotificationIdFunction idFunction = null;
            Object object = MsOutlookAddrBookContactSourceService.this.notificationThreadMutex;
            synchronized (object) {
                boolean bl = hasMore = this.contactIds.size() > 0;
                if (hasMore) {
                    idFunction = this.contactIds.get(0);
                }
            }
            while (hasMore) {
                if (MsOutlookAddrBookContactSourceService.this.latestQuery != null) {
                    String id = idFunction.getId();
                    char function = idFunction.getFunction();
                    if (function == 'd') {
                        MsOutlookAddrBookContactSourceService.this.latestQuery.deleted(id);
                    } else if (function == 'u') {
                        MsOutlookAddrBookContactSourceService.this.latestQuery.updated(id);
                    } else if (function == 'i') {
                        MsOutlookAddrBookContactSourceService.this.latestQuery.inserted(id);
                    }
                }
                object = MsOutlookAddrBookContactSourceService.this.notificationThreadMutex;
                synchronized (object) {
                    this.contactIds.remove(0);
                    boolean bl = hasMore = this.contactIds.size() > 0;
                    if (hasMore) {
                        idFunction = this.contactIds.get(0);
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void add(String id, char function) {
            NotificationIdFunction idFunction = new NotificationIdFunction(id, function);
            Object object = MsOutlookAddrBookContactSourceService.this.notificationThreadMutex;
            synchronized (object) {
                this.contactIds.remove(idFunction);
                this.contactIds.add(idFunction);
            }
        }

        public int getNbRemainingNotifications() {
            return this.contactIds.size();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void clear() {
            Object object = MsOutlookAddrBookContactSourceService.this.notificationThreadMutex;
            synchronized (object) {
                this.contactIds.clear();
            }
        }
    }

    public class NotificationsDelegate {
        public void inserted(String id) {
            if (MsOutlookAddrBookContactSourceService.this.latestQuery != null) {
                MsOutlookAddrBookContactSourceService.this.addNotification(id, 'i');
            }
        }

        public void updated(String id) {
            if (MsOutlookAddrBookContactSourceService.this.latestQuery != null) {
                MsOutlookAddrBookContactSourceService.this.addNotification(id, 'u');
            }
        }

        public void deleted(String id) {
            if (MsOutlookAddrBookContactSourceService.this.latestQuery != null) {
                MsOutlookAddrBookContactSourceService.this.addNotification(id, 'd');
            }
        }
    }
}

