/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.plugin.addrbook.msoutlook.calendar;

import java.beans.PropertyChangeEvent;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.regex.Pattern;
import net.java.sip.communicator.plugin.addrbook.AddrBookActivator;
import net.java.sip.communicator.plugin.addrbook.msoutlook.MsOutlookMAPIHResultException;
import net.java.sip.communicator.plugin.addrbook.msoutlook.calendar.CalendarItemTimerTask;
import net.java.sip.communicator.plugin.addrbook.msoutlook.calendar.RecurringPattern;
import net.java.sip.communicator.service.calendar.CalendarService;
import net.java.sip.communicator.service.calendar.FreeBusySateListener;
import net.java.sip.communicator.service.protocol.OperationSetPresence;
import net.java.sip.communicator.service.protocol.PresenceStatus;
import net.java.sip.communicator.service.protocol.ProtocolProviderService;
import net.java.sip.communicator.service.protocol.event.ProviderPresenceStatusChangeEvent;
import net.java.sip.communicator.service.protocol.event.ProviderPresenceStatusListener;
import net.java.sip.communicator.util.Logger;

public class CalendarServiceImpl
implements CalendarService {
    private static final Logger logger = Logger.getLogger(CalendarServiceImpl.class);
    private List<CalendarItemTimerTask> currentCalendarItems = new LinkedList<CalendarItemTimerTask>();
    private Map<String, CalendarItemTimerTask> taskMap = new HashMap<String, CalendarItemTimerTask>();
    private CalendarService.BusyStatusEnum currentState = CalendarService.BusyStatusEnum.FREE;
    private InMeetingStatusPolicy inMeetingStatusPolicy = new InMeetingStatusPolicy();
    public ProviderPresenceStatusListener presenceStatusListener = new ProviderPresenceStatusListener(){

        public void providerStatusMessageChanged(PropertyChangeEvent evt) {
        }

        public void providerStatusChanged(ProviderPresenceStatusChangeEvent evt) {
            if (evt.getNewStatus().isOnline()) {
                CalendarServiceImpl.this.inMeetingStatusPolicy.handleProtocolProvider(evt.getProvider(), null, false, true);
            }
        }
    };
    public static final long MAPI_UNICODE = Integer.MIN_VALUE;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addToTaskMap(String id, CalendarItemTimerTask task) {
        Map<String, CalendarItemTimerTask> map = this.taskMap;
        synchronized (map) {
            this.taskMap.put(id, task);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeFromTaskMap(String id) {
        Map<String, CalendarItemTimerTask> map = this.taskMap;
        synchronized (map) {
            this.taskMap.remove(id);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addToCurrentItems(CalendarItemTimerTask task) {
        List<CalendarItemTimerTask> list = this.currentCalendarItems;
        synchronized (list) {
            this.currentCalendarItems.add(task);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeFromCurrentItems(CalendarItemTimerTask task) {
        List<CalendarItemTimerTask> list = this.currentCalendarItems;
        synchronized (list) {
            this.currentCalendarItems.remove(task);
        }
    }

    public void start() {
        CalendarServiceImpl.getAllCalendarItems(new NotificationsDelegate());
    }

    private static native void getAllCalendarItems(NotificationsDelegate var0);

    public static native Object[] IMAPIProp_GetProps(String var0, long[] var1, long var2) throws MsOutlookMAPIHResultException;

    private synchronized void insert(String id) throws MsOutlookMAPIHResultException {
        Object[] props = null;
        props = CalendarServiceImpl.IMAPIProp_GetProps(id, MAPICalendarProperties.getALLPropertyIDs(), Integer.MIN_VALUE);
        this.addCalendarItem(props, id);
    }

    private void addCalendarItem(Object[] props, String id) {
        Date startTime = null;
        Date endTime = null;
        CalendarService.BusyStatusEnum status = CalendarService.BusyStatusEnum.FREE;
        ResponseStatus responseStatus = ResponseStatus.respNone;
        boolean isRecurring = false;
        byte[] recurringData = null;
        block14: for (int i = 0; i < props.length; ++i) {
            if (props[i] == null) continue;
            MAPICalendarProperties propertyName = MAPICalendarProperties.getByOrderId(i);
            switch (propertyName) {
                case PidLidAppointmentStartWhole: {
                    long time;
                    try {
                        time = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss Z").parse(props[i] + " UTC").getTime();
                        startTime = new Date(time);
                        continue block14;
                    }
                    catch (ParseException e) {
                        logger.error((Object)("Cannot parse date string: " + props[i]));
                        return;
                    }
                }
                case PidLidAppointmentEndWhole: {
                    long time;
                    try {
                        time = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss Z").parse(props[i] + " UTC").getTime();
                        endTime = new Date(time);
                        continue block14;
                    }
                    catch (ParseException e) {
                        logger.error((Object)("Cannot parse date string: " + props[i]));
                        return;
                    }
                }
                case PidLidBusyStatus: {
                    status = CalendarService.BusyStatusEnum.getFromLong((Long)props[i]);
                    continue block14;
                }
                case PidLidRecurring: {
                    isRecurring = (Boolean)props[i];
                    continue block14;
                }
                case PidLidAppointmentRecur: {
                    recurringData = (byte[])props[i];
                    continue block14;
                }
                case PidLidResponseStatus: {
                    responseStatus = ResponseStatus.getFromLong((Long)props[i]);
                }
            }
        }
        if (responseStatus != ResponseStatus.respNone && responseStatus != ResponseStatus.respAccepted && responseStatus != ResponseStatus.respOrganized) {
            return;
        }
        if (status == CalendarService.BusyStatusEnum.FREE || startTime == null || endTime == null) {
            return;
        }
        Date currentTime = new Date();
        boolean executeNow = false;
        if (startTime.before(currentTime) || startTime.equals(currentTime)) {
            executeNow = true;
        }
        CalendarItemTimerTask task = null;
        if (recurringData != null) {
            task = new CalendarItemTimerTask(status, startTime, endTime, id, executeNow, null);
            try {
                RecurringPattern pattern = new RecurringPattern(recurringData, task);
                task.setPattern(pattern);
            }
            catch (IndexOutOfBoundsException e) {
                logger.error((Object)("Error parsing reccuring pattern." + e.getMessage()), (Throwable)e);
                logger.error((Object)("Reccuring data:\n" + CalendarServiceImpl.bytesToHex(recurringData)));
                return;
            }
        }
        if (endTime.before(currentTime) || endTime.equals(currentTime)) {
            if (isRecurring) {
                task = task.getPattern().next(startTime, endTime);
            } else {
                return;
            }
        }
        if (task == null) {
            task = new CalendarItemTimerTask(status, startTime, endTime, id, executeNow, null);
        }
        task.scheduleTasks();
    }

    private static String bytesToHex(byte[] bytes) {
        StringBuilder sb = new StringBuilder();
        for (byte b : bytes) {
            sb.append(String.format("%02x", b & 0xFF));
        }
        return sb.toString();
    }

    protected void setCurrentState(CalendarService.BusyStatusEnum state) {
        if (this.currentState == state) {
            return;
        }
        CalendarService.BusyStatusEnum oldState = this.currentState;
        this.currentState = state;
        if (oldState == CalendarService.BusyStatusEnum.FREE && state != CalendarService.BusyStatusEnum.FREE || oldState != CalendarService.BusyStatusEnum.FREE && state == CalendarService.BusyStatusEnum.FREE) {
            this.inMeetingStatusPolicy.freeBusyStateChanged();
        }
    }

    @Override
    public boolean onThePhoneStatusChanged(Map<ProtocolProviderService, PresenceStatus> presenceStatuses) {
        if (this.currentState != CalendarService.BusyStatusEnum.FREE) {
            this.inMeetingStatusPolicy.onThePhoneStatusChanged(presenceStatuses);
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateStateFromCurrentItems() {
        CalendarService.BusyStatusEnum tmpState = CalendarService.BusyStatusEnum.FREE;
        List<CalendarItemTimerTask> list = this.currentCalendarItems;
        synchronized (list) {
            for (CalendarItemTimerTask task : this.currentCalendarItems) {
                if (tmpState.getPriority() >= task.getStatus().getPriority()) continue;
                tmpState = task.getStatus();
            }
        }
        this.setCurrentState(tmpState);
    }

    @Override
    public CalendarService.BusyStatusEnum getStatus() {
        return this.currentState;
    }

    @Override
    public void addFreeBusySateListener(FreeBusySateListener listener) {
    }

    @Override
    public void removeFreeBusySateListener(FreeBusySateListener listener) {
    }

    public void handleProviderAdded(ProtocolProviderService pps) {
        this.inMeetingStatusPolicy.handleProtocolProvider(pps, null, false, false);
    }

    @Override
    public Map<ProtocolProviderService, PresenceStatus> getRememberedStatuses() {
        return this.inMeetingStatusPolicy.getRememberedStatuses();
    }

    static {
        System.loadLibrary("jmsoutlookaddrbook");
    }

    public class NotificationsDelegate {
        public void inserted(String id) {
            try {
                CalendarServiceImpl.this.insert(id);
            }
            catch (MsOutlookMAPIHResultException e) {
                e.printStackTrace();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void updated(String id) {
            try {
                Map map = CalendarServiceImpl.this.taskMap;
                synchronized (map) {
                    CalendarItemTimerTask task = (CalendarItemTimerTask)CalendarServiceImpl.this.taskMap.get(id);
                    if (task != null) {
                        task.remove();
                    }
                }
                CalendarServiceImpl.this.insert(id);
            }
            catch (MsOutlookMAPIHResultException e) {
                e.printStackTrace();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void deleted(String id) {
            Map map = CalendarServiceImpl.this.taskMap;
            synchronized (map) {
                CalendarItemTimerTask task = (CalendarItemTimerTask)CalendarServiceImpl.this.taskMap.get(id);
                if (task != null) {
                    task.remove();
                }
            }
        }

        public boolean callback(String id) {
            try {
                CalendarServiceImpl.this.insert(id);
            }
            catch (MsOutlookMAPIHResultException e) {
                e.printStackTrace();
            }
            return true;
        }
    }

    private class InMeetingStatusPolicy {
        private final Pattern presenceStatusNameWhitespace = Pattern.compile("\\p{Space}");
        private final Map<ProtocolProviderService, PresenceStatus> presenceStatuses = Collections.synchronizedMap(new WeakHashMap());

        private InMeetingStatusPolicy() {
        }

        public void freeBusyStateChanged() {
            this.run(false);
        }

        public void onThePhoneStatusChanged(Map<ProtocolProviderService, PresenceStatus> presenceStatuses) {
            this.run(true);
            for (ProtocolProviderService pps : presenceStatuses.keySet()) {
                this.rememberPresenceStatus(pps, presenceStatuses.get(pps));
            }
        }

        public Map<ProtocolProviderService, PresenceStatus> getRememberedStatuses() {
            return this.presenceStatuses;
        }

        private PresenceStatus findInMeetingPresenceStatus(OperationSetPresence presence) {
            Iterator i = presence.getSupportedStatusSet();
            while (i.hasNext()) {
                PresenceStatus presenceStatus = (PresenceStatus)i.next();
                if (!this.presenceStatusNameWhitespace.matcher(presenceStatus.getStatusName()).replaceAll("").equalsIgnoreCase("InAMeeting")) continue;
                return presenceStatus;
            }
            return null;
        }

        private PresenceStatus findOnThePhonePresenceStatus(OperationSetPresence presence) {
            Iterator i = presence.getSupportedStatusSet();
            while (i.hasNext()) {
                PresenceStatus presenceStatus = (PresenceStatus)i.next();
                if (!this.presenceStatusNameWhitespace.matcher(presenceStatus.getStatusName()).replaceAll("").equalsIgnoreCase("OnThePhone")) continue;
                return presenceStatus;
            }
            return null;
        }

        private PresenceStatus forgetPresenceStatus(ProtocolProviderService pps) {
            return this.presenceStatuses.remove(pps);
        }

        private void forgetPresenceStatuses() {
            this.presenceStatuses.clear();
        }

        private boolean isInMeeting() {
            return CalendarServiceImpl.this.currentState != CalendarService.BusyStatusEnum.FREE;
        }

        private void publishPresenceStatus(OperationSetPresence presence, PresenceStatus presenceStatus) {
            block3: {
                try {
                    presence.publishPresenceStatus(presenceStatus, null);
                }
                catch (Throwable t) {
                    if (t instanceof InterruptedException) {
                        Thread.currentThread().interrupt();
                    }
                    if (!(t instanceof ThreadDeath)) break block3;
                    throw (ThreadDeath)t;
                }
            }
        }

        private PresenceStatus rememberPresenceStatus(ProtocolProviderService pps, PresenceStatus presenceStatus) {
            return this.presenceStatuses.put(pps, presenceStatus);
        }

        private void run(boolean onThePhoneStatusChanged) {
            List<ProtocolProviderService> providers = AddrBookActivator.getProtocolProviders();
            if (providers == null || providers.size() == 0) {
                this.forgetPresenceStatuses();
            } else {
                boolean isInMeeting = this.isInMeeting();
                for (ProtocolProviderService pps : providers) {
                    if (pps == null) continue;
                    this.handleProtocolProvider(pps, isInMeeting, onThePhoneStatusChanged, false);
                }
            }
        }

        public void handleProtocolProvider(ProtocolProviderService pps, Boolean isInMeeting, boolean onThePhoneStatusChanged, boolean dontAddListeners) {
            OperationSetPresence presence;
            if (isInMeeting == null) {
                isInMeeting = this.isInMeeting();
            }
            if ((presence = (OperationSetPresence)pps.getOperationSet(OperationSetPresence.class)) == null) {
                this.forgetPresenceStatus(pps);
            } else if (pps.isRegistered()) {
                PresenceStatus inMeetingPresenceStatus = this.findInMeetingPresenceStatus(presence);
                PresenceStatus onThePhone = this.findOnThePhonePresenceStatus(presence);
                if (inMeetingPresenceStatus == null) {
                    this.forgetPresenceStatus(pps);
                } else if (isInMeeting.booleanValue()) {
                    PresenceStatus presenceStatus;
                    if (!dontAddListeners) {
                        presence.addProviderPresenceStatusListener(CalendarServiceImpl.this.presenceStatusListener);
                    }
                    if ((presenceStatus = presence.getPresenceStatus()) == null) {
                        logger.info((Object)"HANDLE provider 55");
                        this.forgetPresenceStatus(pps);
                        presence.removeProviderPresenceStatusListener(CalendarServiceImpl.this.presenceStatusListener);
                    } else if (!(inMeetingPresenceStatus.equals((Object)presenceStatus) || presenceStatus.equals((Object)onThePhone) && !onThePhoneStatusChanged)) {
                        if (!dontAddListeners) {
                            if (!presenceStatus.isOnline()) {
                                return;
                            }
                            presence.removeProviderPresenceStatusListener(CalendarServiceImpl.this.presenceStatusListener);
                        }
                        this.publishPresenceStatus(presence, inMeetingPresenceStatus);
                        if (inMeetingPresenceStatus.equals((Object)presence.getPresenceStatus())) {
                            this.rememberPresenceStatus(pps, presenceStatus);
                        } else {
                            this.forgetPresenceStatus(pps);
                        }
                    } else {
                        presence.removeProviderPresenceStatusListener(CalendarServiceImpl.this.presenceStatusListener);
                    }
                } else {
                    PresenceStatus presenceStatus = this.forgetPresenceStatus(pps);
                    if (presenceStatus != null && inMeetingPresenceStatus.equals((Object)presence.getPresenceStatus())) {
                        this.publishPresenceStatus(presence, presenceStatus);
                    }
                }
            } else {
                this.forgetPresenceStatus(pps);
            }
        }
    }

    public static enum MAPICalendarProperties {
        PidLidAppointmentStartWhole(33293L, MAPIType.PT_SYSTIME),
        PidLidAppointmentEndWhole(33294L, MAPIType.PT_SYSTIME),
        PidLidBusyStatus(33285L, MAPIType.PT_LONG),
        PidLidRecurring(33315L, MAPIType.PT_BOOL),
        PidLidAppointmentRecur(33302L, MAPIType.PT_BINARY),
        PidLidResponseStatus(33304L, MAPIType.PT_LONG);

        private final long id;
        private final MAPIType type;

        private MAPICalendarProperties(long id, MAPIType type) {
            this.id = id;
            this.type = type;
        }

        public static long[] getALLPropertyIDs() {
            MAPICalendarProperties[] properties = MAPICalendarProperties.values();
            long[] result = new long[properties.length];
            for (int i = 0; i < properties.length; ++i) {
                result[i] = properties[i].getID();
            }
            return result;
        }

        public long getID() {
            return this.id;
        }

        public MAPIType getType() {
            return this.type;
        }

        public static MAPICalendarProperties getByOrderId(int i) {
            return MAPICalendarProperties.values()[i];
        }
    }

    public static enum ResponseStatus {
        respNone(0),
        respOrganized(1),
        respTentative(2),
        respAccepted(3),
        respDeclined(4),
        respNotResponded(5);

        private final long id;

        private ResponseStatus(int id) {
            this.id = id;
        }

        public static ResponseStatus getFromLong(long value) {
            for (ResponseStatus state : ResponseStatus.values()) {
                if (state.getID() != value) continue;
                return state;
            }
            return respNone;
        }

        private long getID() {
            return this.id;
        }
    }

    public static enum MAPIType {
        PT_SYSTIME,
        PT_LONG,
        PT_BOOL,
        PT_BINARY;

    }
}

