/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.impl.neomedia;

import java.awt.Dimension;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import javax.media.control.JitterBufferControl;
import javax.media.format.VideoFormat;
import javax.media.protocol.DataSource;
import javax.media.protocol.PushBufferDataSource;
import javax.media.protocol.PushBufferStream;
import javax.media.protocol.PushSourceStream;
import javax.media.rtp.ReceiveStream;
import net.sf.fmj.media.rtp.RTCPFeedback;
import net.sf.fmj.media.rtp.RTCPReport;
import net.sf.fmj.media.rtp.RTCPSRPacket;
import org.jitsi.impl.neomedia.AbstractRTPConnector;
import org.jitsi.impl.neomedia.MediaStreamImpl;
import org.jitsi.impl.neomedia.RTPConnectorOutputStream;
import org.jitsi.impl.neomedia.device.MediaDeviceSession;
import org.jitsi.impl.neomedia.device.VideoMediaDeviceSession;
import org.jitsi.impl.neomedia.rtcp.NACKPacket;
import org.jitsi.impl.neomedia.rtcp.RTCPREMBPacket;
import org.jitsi.impl.neomedia.rtcp.RTCPTCCPacket;
import org.jitsi.impl.neomedia.rtp.StreamRTPManager;
import org.jitsi.impl.neomedia.rtp.TransportCCEngine;
import org.jitsi.impl.neomedia.rtp.remotebitrateestimator.RemoteBitrateEstimatorWrapper;
import org.jitsi.impl.neomedia.stats.MediaStreamStats2Impl;
import org.jitsi.impl.neomedia.transform.rtcp.StatisticsEngine;
import org.jitsi.service.neomedia.MediaStream;
import org.jitsi.service.neomedia.MediaStreamStats;
import org.jitsi.service.neomedia.MediaStreamTarget;
import org.jitsi.service.neomedia.RTPTranslator;
import org.jitsi.service.neomedia.VideoMediaStream;
import org.jitsi.service.neomedia.control.FECDecoderControl;
import org.jitsi.service.neomedia.format.MediaFormat;
import org.jitsi.service.neomedia.rtp.RTCPPacketListener;
import org.jitsi.service.neomedia.rtp.RTCPReportAdapter;
import org.jitsi.service.neomedia.rtp.RTCPReportListener;
import org.jitsi.service.neomedia.rtp.RTCPReports;
import org.jitsi.service.neomedia.stats.TrackStats;
import org.jitsi.utils.LRUCache;
import org.jitsi.utils.MediaType;
import org.jitsi.utils.TimeUtils;
import org.jitsi.utils.logging.Logger;

public class MediaStreamStatsImpl
implements MediaStreamStats {
    private static final Logger logger = Logger.getLogger(MediaStreamStatsImpl.class);
    private final Map<Long, Long> emission2reception = Collections.synchronizedMap(new LRUCache(100));
    private double[] jitterRTPTimestampUnits = new double[]{0.0, 0.0};
    private final MediaStreamImpl mediaStreamImpl;
    private long[] nbByte = new long[]{0L, 0L};
    private long nbDiscarded = 0L;
    private long nbFec = 0L;
    private long[] nbLost = new long[]{0L, 0L};
    private long[] nbPackets = new long[]{0L, 0L};
    private double percentDiscarded = 0.0;
    private double[] percentLoss = new double[]{0.0, 0.0};
    private double[] rateKiloBitPerSec = new double[]{0.0, 0.0};
    private long nbPacketsLostUpload = 0L;
    private final RTCPReportListener rtcpReportListener = new RTCPReportAdapter(){

        @Override
        public void rtcpReportReceived(RTCPReport report) {
            MediaStreamStatsImpl.this.rtcpReportReceived(report);
        }

        @Override
        public void rtcpReportSent(RTCPReport report) {
            Vector feedbackReports = report.getFeedbackReports();
            if (!feedbackReports.isEmpty()) {
                MediaStreamStatsImpl.this.updateNewSentFeedback((RTCPFeedback)feedbackReports.get(0));
            }
        }
    };
    private final RTCPReports rtcpReports = new RTCPReports();
    private long rttMs = -1L;
    private long updateTimeMs;
    private long uploadFeedbackNbPackets = 0L;
    private long minRemoteInterArrivalJitter = -1L;
    private long maxRemoteInterArrivalJitter = 0L;
    private long remoteJitterSum = 0L;
    private int remoteJitterCount = 0;
    private final List<RTCPPacketListener> rtcpPacketListeners = Collections.synchronizedList(new LinkedList());

    private static double computeEWMA(long nbStepSinceLastUpdate, double lastValue, double newValue) {
        double EWMACoeff = 0.01 * (double)nbStepSinceLastUpdate;
        if (EWMACoeff > 1.0) {
            EWMACoeff = 1.0;
        }
        return lastValue * (1.0 - EWMACoeff) + newValue * EWMACoeff;
    }

    private static double computePercentLoss(long nbLostAndRecv, long nbLost) {
        return nbLostAndRecv == 0L ? 0.0 : 100.0 * (double)nbLost / (double)nbLostAndRecv;
    }

    private static double computeRateKiloBitPerSec(long nbBytes, long intervalMs) {
        return intervalMs == 0L ? 0.0 : (double)nbBytes * 8.0 / (double)intervalMs;
    }

    public static JitterBufferControl getJitterBufferControl(ReceiveStream receiveStream) {
        DataSource ds = receiveStream.getDataSource();
        if (ds instanceof PushBufferDataSource) {
            for (PushBufferStream pbs : ((PushBufferDataSource)ds).getStreams()) {
                JitterBufferControl pqc = (JitterBufferControl)pbs.getControl(JitterBufferControl.class.getName());
                if (pqc == null) continue;
                return pqc;
            }
        }
        return null;
    }

    public MediaStreamStatsImpl(MediaStreamImpl mediaStreamImpl) {
        this.mediaStreamImpl = mediaStreamImpl;
        this.updateTimeMs = System.currentTimeMillis();
        this.getRTCPReports().addRTCPReportListener(this.rtcpReportListener);
    }

    private int computeRTTInMs(RTCPFeedback feedback) {
        long lsr = feedback.getLSR();
        long dlsr = feedback.getDLSR();
        int rtt = -1;
        if (lsr > 0L && dlsr > 0L) {
            long arrivalNtp;
            long arrival;
            long ntprtd;
            long rttLong;
            long arrivalMs = System.currentTimeMillis();
            RTPTranslator translator = this.mediaStreamImpl.getRTPTranslator();
            if (translator != null) {
                StreamRTPManager receiveRTPManager = translator.findStreamRTPManagerByReceiveSSRC((int)feedback.getSSRC());
                if (receiveRTPManager != null) {
                    MediaStream receiveStream = receiveRTPManager.getMediaStream();
                    MediaStreamStatsImpl stats = (MediaStreamStatsImpl)((Object)receiveStream.getMediaStreamStats());
                    Long lsrReceipt = stats.emission2reception.get(lsr);
                    if (lsrReceipt == null) {
                        return -1;
                    }
                    lsr = lsrReceipt;
                } else {
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)("invalid_rtt,stream=" + this.mediaStreamImpl.hashCode() + " ssrc=" + feedback.getSSRC() + ",now=" + arrivalMs + ",lsr=" + lsr + ",dlsr=" + dlsr));
                    }
                    return -1;
                }
            }
            if ((rttLong = (ntprtd = (arrival = TimeUtils.toNtpShortFormat((long)(arrivalNtp = TimeUtils.toNtpTime((long)arrivalMs)))) - lsr - dlsr) >= 0L ? TimeUtils.ntpShortToMs((long)ntprtd) : -TimeUtils.ntpShortToMs((long)(-ntprtd))) < 0L || rttLong >= 3000L) {
                logger.warn((Object)("invalid_rtt,stream=" + this.mediaStreamImpl.hashCode() + " ssrc=" + feedback.getSSRC() + ",rtt=" + rttLong + ",now=" + arrivalMs + ",lsr=" + lsr + ",dlsr=" + dlsr));
                rtt = -1;
            } else {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("rtt,stream= " + this.mediaStreamImpl.hashCode() + " ssrc=" + feedback.getSSRC() + ",rtt=" + rttLong + ",now=" + arrivalMs + ",lsr=" + lsr + ",dlsr=" + dlsr));
                }
                rtt = (int)rttLong;
            }
        }
        return rtt;
    }

    @Override
    public double getDownloadJitterMs() {
        return this.getJitterMs(StreamDirection.DOWNLOAD);
    }

    @Override
    public long getDownloadNbPacketLost() {
        long downloadLost = 0L;
        for (ReceiveStream stream : this.mediaStreamImpl.getReceiveStreams()) {
            downloadLost += (long)stream.getSourceReceptionStats().getPDUlost();
        }
        return downloadLost;
    }

    @Override
    public long getUploadNbPacketLost() {
        return this.nbPacketsLostUpload;
    }

    private long getDownloadNbPDULost() {
        MediaDeviceSession devSession = this.mediaStreamImpl.getDeviceSession();
        int nbLost = 0;
        if (devSession != null) {
            for (ReceiveStream receiveStream : devSession.getReceiveStreams()) {
                nbLost += receiveStream.getSourceReceptionStats().getPDUlost();
            }
        }
        return nbLost;
    }

    @Override
    public double getDownloadPercentLoss() {
        return this.percentLoss[StreamDirection.DOWNLOAD.ordinal()];
    }

    @Override
    public double getDownloadRateKiloBitPerSec() {
        return this.rateKiloBitPerSec[StreamDirection.DOWNLOAD.ordinal()];
    }

    private VideoFormat getDownloadVideoFormat() {
        MediaDeviceSession deviceSession = this.mediaStreamImpl.getDeviceSession();
        return deviceSession instanceof VideoMediaDeviceSession ? ((VideoMediaDeviceSession)deviceSession).getReceivedVideoFormat() : null;
    }

    @Override
    public Dimension getDownloadVideoSize() {
        VideoFormat format = this.getDownloadVideoFormat();
        return format == null ? null : format.getSize();
    }

    @Override
    public String getEncoding() {
        MediaFormat format = this.mediaStreamImpl.getFormat();
        return format == null ? null : format.getEncoding();
    }

    @Override
    public String getEncodingClockRate() {
        MediaFormat format = this.mediaStreamImpl.getFormat();
        return format == null ? null : format.getRealUsedClockRateString();
    }

    private Set<JitterBufferControl> getJitterBufferControls() {
        MediaDeviceSession devSession;
        HashSet<JitterBufferControl> set = new HashSet<JitterBufferControl>();
        if (this.mediaStreamImpl.isStarted() && (devSession = this.mediaStreamImpl.getDeviceSession()) != null) {
            for (ReceiveStream receiveStream : devSession.getReceiveStreams()) {
                JitterBufferControl pqc = MediaStreamStatsImpl.getJitterBufferControl(receiveStream);
                if (pqc == null) continue;
                set.add(pqc);
            }
        }
        return set;
    }

    @Override
    public int getJitterBufferDelayMs() {
        int delay = 0;
        for (JitterBufferControl pqc : this.getJitterBufferControls()) {
            if (pqc.getCurrentDelayMs() <= delay) continue;
            delay = pqc.getCurrentDelayMs();
        }
        return delay;
    }

    @Override
    public int getJitterBufferDelayPackets() {
        int delay = 0;
        for (JitterBufferControl pqc : this.getJitterBufferControls()) {
            if (pqc.getCurrentDelayPackets() <= delay) continue;
            delay = pqc.getCurrentDelayPackets();
        }
        return delay;
    }

    private double getJitterMs(StreamDirection streamDirection) {
        return this.rtpTimeToMs(this.jitterRTPTimestampUnits[streamDirection.ordinal()]);
    }

    private double getRtpClockRate() {
        MediaType mediaType;
        MediaFormat format = this.mediaStreamImpl.getFormat();
        double clockRate = format == null ? (MediaType.VIDEO.equals((Object)(mediaType = this.mediaStreamImpl.getMediaType())) ? 90000.0 : 48000.0) : format.getClockRate();
        return clockRate;
    }

    private double rtpTimeToMs(double rtpTime) {
        double rtpClockRate = this.getRtpClockRate();
        if (rtpClockRate <= 0.0) {
            return -1.0;
        }
        return rtpTime / rtpClockRate * 1000.0;
    }

    @Override
    public double getMinDownloadJitterMs() {
        StatisticsEngine statisticsEngine = this.mediaStreamImpl.getStatisticsEngine();
        if (statisticsEngine != null) {
            return this.rtpTimeToMs(statisticsEngine.getMinInterArrivalJitter());
        }
        return -1.0;
    }

    @Override
    public double getMaxDownloadJitterMs() {
        StatisticsEngine statisticsEngine = this.mediaStreamImpl.getStatisticsEngine();
        if (statisticsEngine != null) {
            return this.rtpTimeToMs(statisticsEngine.getMaxInterArrivalJitter());
        }
        return -1.0;
    }

    @Override
    public double getMinUploadJitterMs() {
        return this.rtpTimeToMs(this.minRemoteInterArrivalJitter);
    }

    @Override
    public double getMaxUploadJitterMs() {
        return this.rtpTimeToMs(this.maxRemoteInterArrivalJitter);
    }

    @Override
    public double getAvgDownloadJitterMs() {
        StatisticsEngine statisticsEngine = this.mediaStreamImpl.getStatisticsEngine();
        if (statisticsEngine != null) {
            return this.rtpTimeToMs(statisticsEngine.getAvgInterArrivalJitter());
        }
        return -1.0;
    }

    @Override
    public double getAvgUploadJitterMs() {
        int count = this.remoteJitterCount;
        if (count == 0) {
            return -1.0;
        }
        return this.rtpTimeToMs((double)this.remoteJitterSum / (double)count);
    }

    public void updateRemoteJitter(long remoteJitter) {
        if (remoteJitter < this.minRemoteInterArrivalJitter || this.minRemoteInterArrivalJitter == -1L) {
            this.minRemoteInterArrivalJitter = remoteJitter;
        }
        if (this.maxRemoteInterArrivalJitter < remoteJitter) {
            this.maxRemoteInterArrivalJitter = remoteJitter;
        }
        this.remoteJitterSum += remoteJitter;
        ++this.remoteJitterCount;
    }

    @Override
    public String getLocalIPAddress() {
        InetSocketAddress mediaStreamLocalDataAddress = this.mediaStreamImpl.getLocalDataAddress();
        return mediaStreamLocalDataAddress == null ? null : mediaStreamLocalDataAddress.getAddress().getHostAddress();
    }

    @Override
    public int getLocalPort() {
        InetSocketAddress mediaStreamLocalDataAddress = this.mediaStreamImpl.getLocalDataAddress();
        return mediaStreamLocalDataAddress == null ? -1 : mediaStreamLocalDataAddress.getPort();
    }

    private long getNbBytes(StreamDirection streamDirection) {
        return this.getTrackStats(streamDirection).getBytes();
    }

    private TrackStats getTrackStats(StreamDirection streamDirection) {
        MediaStreamStats2Impl extended = this.getExtended();
        return streamDirection == StreamDirection.DOWNLOAD ? extended.getReceiveStats() : extended.getSendStats();
    }

    @Override
    public long getNbDiscarded() {
        int nbDiscarded = 0;
        for (JitterBufferControl pqc : this.getJitterBufferControls()) {
            nbDiscarded = pqc.getDiscarded();
        }
        return nbDiscarded;
    }

    @Override
    public int getNbDiscardedFull() {
        int nbDiscardedFull = 0;
        for (JitterBufferControl pqc : this.getJitterBufferControls()) {
            nbDiscardedFull = pqc.getDiscardedFull();
        }
        return nbDiscardedFull;
    }

    @Override
    public int getNbDiscardedLate() {
        int nbDiscardedLate = 0;
        for (JitterBufferControl pqc : this.getJitterBufferControls()) {
            nbDiscardedLate = pqc.getDiscardedLate();
        }
        return nbDiscardedLate;
    }

    @Override
    public int getNbDiscardedReset() {
        int nbDiscardedReset = 0;
        for (JitterBufferControl pqc : this.getJitterBufferControls()) {
            nbDiscardedReset = pqc.getDiscardedReset();
        }
        return nbDiscardedReset;
    }

    @Override
    public int getNbDiscardedShrink() {
        int nbDiscardedShrink = 0;
        for (JitterBufferControl pqc : this.getJitterBufferControls()) {
            nbDiscardedShrink = pqc.getDiscardedShrink();
        }
        return nbDiscardedShrink;
    }

    @Override
    public long getNbFec() {
        return this.nbFec;
    }

    @Override
    public long getNbPackets() {
        return this.getNbPDU(StreamDirection.DOWNLOAD) + this.getDownloadNbPacketLost() + this.uploadFeedbackNbPackets;
    }

    @Override
    public long getNbPacketsLost() {
        return this.nbLost[StreamDirection.UPLOAD.ordinal()] + this.getDownloadNbPacketLost();
    }

    @Override
    public long getNbPacketsSent() {
        return this.getNbPDU(StreamDirection.UPLOAD);
    }

    @Override
    public long getNbPacketsReceived() {
        return this.getNbPDU(StreamDirection.DOWNLOAD);
    }

    private long getNbPDU(StreamDirection streamDirection) {
        return this.getTrackStats(streamDirection).getPackets();
    }

    @Override
    public long getNbReceivedBytes() {
        AbstractRTPConnector connector = this.mediaStreamImpl.getRTPConnector();
        if (connector != null) {
            PushSourceStream stream;
            try {
                stream = connector.getDataInputStream();
            }
            catch (IOException ex) {
                stream = null;
            }
            if (stream != null) {
                return stream.getNumberOfReceivedBytes();
            }
        }
        return 0L;
    }

    @Override
    public long getNbSentBytes() {
        AbstractRTPConnector connector = this.mediaStreamImpl.getRTPConnector();
        if (connector == null) {
            return 0L;
        }
        RTPConnectorOutputStream stream = null;
        try {
            stream = connector.getDataOutputStream(false);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (stream == null) {
            return 0L;
        }
        return stream.getNumberOfBytesSent();
    }

    @Override
    public int getPacketQueueCountPackets() {
        Iterator<JitterBufferControl> iterator = this.getJitterBufferControls().iterator();
        if (iterator.hasNext()) {
            JitterBufferControl pqc = iterator.next();
            return pqc.getCurrentPacketCount();
        }
        return 0;
    }

    @Override
    public int getPacketQueueSize() {
        Iterator<JitterBufferControl> iterator = this.getJitterBufferControls().iterator();
        if (iterator.hasNext()) {
            JitterBufferControl pqc = iterator.next();
            return pqc.getCurrentSizePackets();
        }
        return 0;
    }

    @Override
    public double getPercentDiscarded() {
        return this.percentDiscarded;
    }

    @Override
    public String getRemoteIPAddress() {
        MediaStreamTarget mediaStreamTarget = this.mediaStreamImpl.getTarget();
        return mediaStreamTarget == null ? null : mediaStreamTarget.getDataAddress().getAddress().getHostAddress();
    }

    @Override
    public int getRemotePort() {
        MediaStreamTarget mediaStreamTarget = this.mediaStreamImpl.getTarget();
        return mediaStreamTarget == null ? -1 : mediaStreamTarget.getDataAddress().getPort();
    }

    @Override
    public RTCPReports getRTCPReports() {
        return this.rtcpReports;
    }

    @Override
    public long getRttMs() {
        return this.rttMs;
    }

    @Override
    public double getUploadJitterMs() {
        return this.getJitterMs(StreamDirection.UPLOAD);
    }

    @Override
    public double getUploadPercentLoss() {
        return this.percentLoss[StreamDirection.UPLOAD.ordinal()];
    }

    @Override
    public double getUploadRateKiloBitPerSec() {
        return this.rateKiloBitPerSec[StreamDirection.UPLOAD.ordinal()];
    }

    private VideoFormat getUploadVideoFormat() {
        MediaDeviceSession deviceSession = this.mediaStreamImpl.getDeviceSession();
        return deviceSession instanceof VideoMediaDeviceSession ? ((VideoMediaDeviceSession)deviceSession).getSentVideoFormat() : null;
    }

    @Override
    public Dimension getUploadVideoSize() {
        VideoFormat format = this.getUploadVideoFormat();
        return format == null ? null : format.getSize();
    }

    @Override
    public boolean isAdaptiveBufferEnabled() {
        for (JitterBufferControl pcq : this.getJitterBufferControls()) {
            if (!pcq.isAdaptiveBufferEnabled()) continue;
            return true;
        }
        return false;
    }

    private void setRttMs(long rttMs) {
        if (this.rttMs != rttMs) {
            MediaStreamImpl mediaStream;
            this.rttMs = rttMs;
            rttMs = this.getRttMs();
            if (rttMs >= 0L && (mediaStream = this.mediaStreamImpl) instanceof VideoMediaStream) {
                RemoteBitrateEstimatorWrapper remoteBitrateEstimator = mediaStream.getRemoteBitrateEstimator();
                remoteBitrateEstimator.onRttUpdate(rttMs, rttMs);
                TransportCCEngine tccEngine = mediaStream.getTransportCCEngine();
                if (tccEngine != null) {
                    tccEngine.onRttUpdate(rttMs, rttMs);
                }
            }
        }
    }

    private void updateJitterRTPTimestampUnits(RTCPFeedback feedback, StreamDirection streamDirection) {
        this.jitterRTPTimestampUnits[streamDirection.ordinal()] = feedback.getJitter();
        MediaStreamStats2Impl extended = this.getExtended();
        extended.updateJitter(feedback.getSSRC(), streamDirection, this.rtpTimeToMs(feedback.getJitter()));
    }

    private void updateNbDiscarded(long newNbDiscarded, long nbSteps) {
        double newPercentDiscarded = MediaStreamStatsImpl.computePercentLoss(nbSteps, newNbDiscarded);
        this.percentDiscarded = MediaStreamStatsImpl.computeEWMA(nbSteps, this.percentDiscarded, newPercentDiscarded);
        this.nbDiscarded += newNbDiscarded;
    }

    private void updateNbFec() {
        MediaDeviceSession devSession = this.mediaStreamImpl.getDeviceSession();
        int nbFec = 0;
        if (devSession != null) {
            for (ReceiveStream receiveStream : devSession.getReceiveStreams()) {
                for (FECDecoderControl fecDecoderControl : devSession.getDecoderControls(receiveStream, FECDecoderControl.class)) {
                    nbFec += fecDecoderControl.fecPacketsDecoded();
                }
            }
        }
        this.nbFec = nbFec;
    }

    private void updateNbLoss(StreamDirection streamDirection, long newNbLost, long nbSteps) {
        int streamDirectionIndex = streamDirection.ordinal();
        double newPercentLoss = MediaStreamStatsImpl.computePercentLoss(nbSteps, newNbLost);
        this.percentLoss[streamDirectionIndex] = MediaStreamStatsImpl.computeEWMA(nbSteps, this.percentLoss[streamDirectionIndex], newPercentLoss);
        int n = streamDirectionIndex;
        this.nbLost[n] = this.nbLost[n] + newNbLost;
    }

    private void updateNewReceivedFeedback(RTCPFeedback feedback) {
        StreamDirection streamDirection = StreamDirection.UPLOAD;
        this.updateJitterRTPTimestampUnits(feedback, streamDirection);
        long uploadNewNbRecv = feedback.getXtndSeqNum();
        this.nbPacketsLostUpload = feedback.getNumLost();
        long newNbLost = this.nbPacketsLostUpload - this.nbLost[streamDirection.ordinal()];
        long nbSteps = uploadNewNbRecv - this.uploadFeedbackNbPackets;
        this.updateNbLoss(streamDirection, newNbLost, nbSteps);
        this.uploadFeedbackNbPackets = uploadNewNbRecv;
        int rtt = this.computeRTTInMs(feedback);
        if (rtt >= 0) {
            this.setRttMs(rtt);
            MediaStreamStats2Impl extended = this.getExtended();
            extended.updateRtt(feedback.getSSRC(), rtt);
        }
    }

    private void updateNewSentFeedback(RTCPFeedback feedback) {
        this.updateJitterRTPTimestampUnits(feedback, StreamDirection.DOWNLOAD);
    }

    @Override
    public void updateStats() {
        long currentTimeMs = System.currentTimeMillis();
        this.updateStreamDirectionStats(StreamDirection.DOWNLOAD, currentTimeMs);
        this.updateStreamDirectionStats(StreamDirection.UPLOAD, currentTimeMs);
        this.updateTimeMs = currentTimeMs;
    }

    private void updateStreamDirectionStats(StreamDirection streamDirection, long currentTimeMs) {
        int streamDirectionIndex = streamDirection.ordinal();
        long newNbRecv = this.getNbPDU(streamDirection);
        long newNbByte = this.getNbBytes(streamDirection);
        long nbSteps = newNbRecv - this.nbPackets[streamDirectionIndex];
        if (nbSteps == 0L) {
            nbSteps = (currentTimeMs - this.updateTimeMs) / 20L;
        }
        if (streamDirection == StreamDirection.DOWNLOAD) {
            long newNbLost = this.getDownloadNbPDULost() - this.nbLost[streamDirectionIndex];
            this.updateNbLoss(streamDirection, newNbLost, nbSteps + newNbLost);
            long newNbDiscarded = this.getNbDiscarded() - this.nbDiscarded;
            this.updateNbDiscarded(newNbDiscarded, nbSteps + newNbDiscarded);
        }
        double newRateKiloBitPerSec = MediaStreamStatsImpl.computeRateKiloBitPerSec(newNbByte - this.nbByte[streamDirectionIndex], currentTimeMs - this.updateTimeMs);
        this.rateKiloBitPerSec[streamDirectionIndex] = MediaStreamStatsImpl.computeEWMA(nbSteps, this.rateKiloBitPerSec[streamDirectionIndex], newRateKiloBitPerSec);
        this.nbPackets[streamDirectionIndex] = newNbRecv;
        this.nbByte[streamDirectionIndex] = newNbByte;
        this.updateNbFec();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void rembReceived(RTCPREMBPacket remb) {
        if (remb != null) {
            List<RTCPPacketListener> list = this.rtcpPacketListeners;
            synchronized (list) {
                for (RTCPPacketListener listener : this.rtcpPacketListeners) {
                    listener.rembReceived(remb);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void nackReceived(NACKPacket nack) {
        if (nack != null) {
            List<RTCPPacketListener> list = this.rtcpPacketListeners;
            synchronized (list) {
                for (RTCPPacketListener listener : this.rtcpPacketListeners) {
                    listener.nackReceived(nack);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void srReceived(RTCPSRPacket sr) {
        if (sr != null) {
            long emisionTime = TimeUtils.toNtpShortFormat((long)TimeUtils.constructNtp((long)sr.ntptimestampmsw, (long)sr.ntptimestamplsw));
            long arrivalTime = TimeUtils.toNtpShortFormat((long)TimeUtils.toNtpTime((long)System.currentTimeMillis()));
            this.emission2reception.put(emisionTime, arrivalTime);
            List<RTCPPacketListener> list = this.rtcpPacketListeners;
            synchronized (list) {
                for (RTCPPacketListener listener : this.rtcpPacketListeners) {
                    listener.srReceived(sr);
                }
            }
        }
    }

    @Override
    public void addRTCPPacketListener(RTCPPacketListener listener) {
        if (listener != null) {
            this.rtcpPacketListeners.add(listener);
        }
    }

    @Override
    public void removeRTCPPacketListener(RTCPPacketListener listener) {
        if (listener != null) {
            this.rtcpPacketListeners.remove(listener);
        }
    }

    private void rtcpReportReceived(RTCPReport report) {
        Vector feedbackReports = report.getFeedbackReports();
        if (!feedbackReports.isEmpty()) {
            MediaStreamStats2Impl extended = this.getExtended();
            for (RTCPFeedback rtcpFeedback : feedbackReports) {
                this.updateNewReceivedFeedback(rtcpFeedback);
                extended.rtcpReceiverReportReceived(rtcpFeedback.getSSRC(), rtcpFeedback.getFractionLost());
            }
        }
    }

    @Override
    public long getSendingBitrate() {
        long sbr = -1L;
        AbstractRTPConnector rtpConnector = this.mediaStreamImpl.getRTPConnector();
        if (rtpConnector != null) {
            try {
                RTPConnectorOutputStream rtpStream = rtpConnector.getDataOutputStream(false);
                if (rtpStream != null) {
                    long now = System.currentTimeMillis();
                    sbr = rtpStream.getOutputBitrate(now);
                    RTPConnectorOutputStream rtcpStream = rtpConnector.getControlOutputStream(false);
                    if (rtcpStream != null) {
                        sbr += rtcpStream.getOutputBitrate(now);
                    }
                }
            }
            catch (IOException ioe) {
                logger.warn((Object)"Failed to get sending bitrate: ", (Throwable)ioe);
            }
        }
        return sbr;
    }

    private MediaStreamStats2Impl getExtended() {
        return this.mediaStreamImpl.getMediaStreamStats();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void tccPacketReceived(RTCPTCCPacket tccPacket) {
        if (tccPacket != null) {
            List<RTCPPacketListener> list = this.rtcpPacketListeners;
            synchronized (list) {
                for (RTCPPacketListener listener : this.rtcpPacketListeners) {
                    listener.tccReceived(tccPacket);
                }
            }
        }
    }

    public static enum StreamDirection {
        DOWNLOAD,
        UPLOAD;

    }
}

