/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.impl.neomedia.codec.video.vp8;

import java.awt.Dimension;
import javax.media.Buffer;
import javax.media.Format;
import javax.media.ResourceUnavailableException;
import javax.media.format.VideoFormat;
import javax.media.format.YUVFormat;
import org.jitsi.impl.neomedia.NeomediaServiceUtils;
import org.jitsi.impl.neomedia.codec.AbstractCodec2;
import org.jitsi.impl.neomedia.codec.video.VPX;
import org.jitsi.utils.logging.Logger;

public class VPXEncoder
extends AbstractCodec2 {
    private static final int INTERFACE = 1;
    private static final int DEFAULT_WIDTH = 640;
    private static final int DEFAULT_HEIGHT = 480;
    private static final Logger logger = Logger.getLogger(VPXEncoder.class);
    private static final VideoFormat[] SUPPORTED_OUTPUT_FORMATS = new VideoFormat[]{new VideoFormat("VP8")};
    private long cfg = 0L;
    private long context = 0L;
    private long flags = 0L;
    private long frameCount = 0L;
    private long img = 0L;
    private long[] iter = new long[1];
    private boolean leftoverPackets = false;
    private long pkt = 0L;
    private int width = 640;
    private int height = 480;

    public VPXEncoder() {
        super("VP8 Encoder", VideoFormat.class, (Format[])SUPPORTED_OUTPUT_FORMATS);
        this.inputFormats = new VideoFormat[]{new YUVFormat(null, -1, Format.byteArray, -1.0f, 2, -1, -1, -1, -1, -1)};
        this.inputFormat = null;
        this.outputFormat = null;
    }

    @Override
    protected void doClose() {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"Closing encoder");
        }
        if (this.context != 0L) {
            VPX.codec_destroy(this.context);
            VPX.free(this.context);
            this.context = 0L;
        }
        if (this.img != 0L) {
            VPX.free(this.img);
            this.img = 0L;
        }
        if (this.cfg != 0L) {
            VPX.free(this.cfg);
            this.cfg = 0L;
        }
    }

    @Override
    protected void doOpen() throws ResourceUnavailableException {
        this.img = VPX.img_malloc();
        if (this.img == 0L) {
            throw new RuntimeException("Could not img_malloc()");
        }
        VPX.img_set_fmt(this.img, 258);
        VPX.img_set_bps(this.img, 12);
        VPX.img_set_w(this.img, this.width);
        VPX.img_set_d_w(this.img, this.width);
        VPX.img_set_h(this.img, this.height);
        VPX.img_set_d_h(this.img, this.height);
        this.cfg = VPX.codec_enc_cfg_malloc();
        if (this.cfg == 0L) {
            throw new RuntimeException("Could not codec_enc_cfg_malloc()");
        }
        VPX.codec_enc_config_default(1, this.cfg, 0);
        int bitRate = NeomediaServiceUtils.getMediaServiceImpl().getDeviceConfiguration().getVideoBitrate();
        VPX.codec_enc_cfg_set_rc_target_bitrate(this.cfg, bitRate);
        VPX.codec_enc_cfg_set_rc_resize_allowed(this.cfg, 1);
        VPX.codec_enc_cfg_set_rc_end_usage(this.cfg, 1);
        VPX.codec_enc_cfg_set_kf_mode(this.cfg, 1);
        VPX.codec_enc_cfg_set_w(this.cfg, this.width);
        VPX.codec_enc_cfg_set_h(this.cfg, this.height);
        VPX.codec_enc_cfg_set_error_resilient(this.cfg, 3);
        this.context = VPX.codec_ctx_malloc();
        int ret = VPX.codec_enc_init(this.context, 1, this.cfg, this.flags);
        if (ret != 0) {
            throw new RuntimeException("Failed to initialize encoder, libvpx error:\n" + VPX.codec_err_to_string(ret));
        }
        if (this.inputFormat == null) {
            throw new ResourceUnavailableException("No input format selected");
        }
        if (this.outputFormat == null) {
            throw new ResourceUnavailableException("No output format selected");
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"VP8 encoder opened succesfully");
        }
    }

    private void updateSize(int w, int h) {
        if (logger.isInfoEnabled()) {
            logger.info((Object)("Setting new width/height: " + w + "/" + h));
        }
        this.width = w;
        this.height = h;
        if (this.img != 0L) {
            VPX.img_set_w(this.img, w);
            VPX.img_set_d_w(this.img, w);
            VPX.img_set_h(this.img, h);
            VPX.img_set_d_h(this.img, h);
        }
        if (this.cfg != 0L) {
            VPX.codec_enc_cfg_set_w(this.cfg, w);
            VPX.codec_enc_cfg_set_h(this.cfg, h);
            this.reinit();
        }
    }

    @Override
    protected int doProcess(Buffer inputBuffer, Buffer outputBuffer) {
        if (inputBuffer.isDiscard()) {
            outputBuffer.setDiscard(true);
            return 0;
        }
        int ret = 0;
        if (this.leftoverPackets) {
            if (VPX.codec_cx_pkt_get_kind(this.pkt) == 0) {
                int size = VPX.codec_cx_pkt_get_size(this.pkt);
                byte[] output = VPXEncoder.validateByteArraySize(inputBuffer, size, false);
                VPX.memcpy(output, VPX.codec_cx_pkt_get_data(this.pkt), size);
                outputBuffer.setOffset(0);
                outputBuffer.setLength(size);
                outputBuffer.setTimeStamp(inputBuffer.getTimeStamp());
            } else {
                ret |= 4;
            }
        } else {
            int result;
            int offsetV;
            int offsetU;
            int strideUV;
            int strideY;
            ++this.frameCount;
            YUVFormat format = (YUVFormat)inputBuffer.getFormat();
            Dimension formatSize = format.getSize();
            int width = formatSize.width;
            int height = formatSize.height;
            if (width > 0 && height > 0 && (width != this.width || height != this.height)) {
                this.updateSize(width, height);
            }
            if ((strideY = format.getStrideY()) == -1) {
                strideY = width;
            }
            if ((strideUV = format.getStrideUV()) == -1) {
                strideUV = width / 2;
            }
            VPX.img_set_stride0(this.img, strideY);
            VPX.img_set_stride1(this.img, strideUV);
            VPX.img_set_stride2(this.img, strideUV);
            VPX.img_set_stride3(this.img, 0);
            int offsetY = format.getOffsetY();
            if (offsetY == -1) {
                offsetY = 0;
            }
            if ((offsetU = format.getOffsetU()) == -1) {
                offsetU = offsetY + width * height;
            }
            if ((offsetV = format.getOffsetV()) == -1) {
                offsetV = offsetU + width * height / 4;
            }
            if ((result = VPX.codec_encode(this.context, this.img, (byte[])inputBuffer.getData(), offsetY, offsetU, offsetV, this.frameCount, 1L, 0L, 1L)) != 0) {
                logger.warn((Object)("Failed to encode a frame: " + VPX.codec_err_to_string(result)));
                outputBuffer.setDiscard(true);
                return 0;
            }
            this.iter[0] = 0L;
            this.pkt = VPX.codec_get_cx_data(this.context, this.iter);
            if (this.pkt != 0L && VPX.codec_cx_pkt_get_kind(this.pkt) == 0) {
                int size = VPX.codec_cx_pkt_get_size(this.pkt);
                long data = VPX.codec_cx_pkt_get_data(this.pkt);
                byte[] output = VPXEncoder.validateByteArraySize(outputBuffer, size, false);
                VPX.memcpy(output, data, size);
                outputBuffer.setOffset(0);
                outputBuffer.setLength(size);
                outputBuffer.setTimeStamp(inputBuffer.getTimeStamp());
            } else {
                ret |= 4;
            }
        }
        this.pkt = VPX.codec_get_cx_data(this.context, this.iter);
        boolean bl = this.leftoverPackets = this.pkt != 0L;
        if (this.leftoverPackets) {
            return ret | 2;
        }
        return ret;
    }

    @Override
    protected Format[] getMatchingOutputFormats(Format inputFormat) {
        VideoFormat inputVideoFormat = (VideoFormat)inputFormat;
        return new VideoFormat[]{new VideoFormat("VP8", inputVideoFormat.getSize(), -1, Format.byteArray, inputVideoFormat.getFrameRate())};
    }

    private void reinit() {
        int ret;
        if (this.context != 0L) {
            VPX.codec_destroy(this.context);
        }
        if ((ret = VPX.codec_enc_init(this.context, 1, this.cfg, this.flags)) != 0) {
            throw new RuntimeException("Failed to re-initialize encoder, libvpx error:\n" + VPX.codec_err_to_string(ret));
        }
    }

    @Override
    public Format setInputFormat(Format format) {
        if (!(format instanceof VideoFormat) || VPXEncoder.matches(format, this.inputFormats) == null) {
            return null;
        }
        YUVFormat yuvFormat = (YUVFormat)format;
        if (yuvFormat.getOffsetU() > yuvFormat.getOffsetV()) {
            return null;
        }
        this.inputFormat = VPXEncoder.specialize(yuvFormat, Format.byteArray);
        return this.inputFormat;
    }

    @Override
    public Format setOutputFormat(Format format) {
        if (!(format instanceof VideoFormat) || VPXEncoder.matches(format, this.getMatchingOutputFormats(this.inputFormat)) == null) {
            return null;
        }
        VideoFormat videoFormat = (VideoFormat)format;
        Dimension size = null;
        if (this.inputFormat != null) {
            size = ((VideoFormat)this.inputFormat).getSize();
        }
        if (size == null && format.matches(this.outputFormat)) {
            size = ((VideoFormat)this.outputFormat).getSize();
        }
        this.outputFormat = new VideoFormat(videoFormat.getEncoding(), size, -1, Format.byteArray, videoFormat.getFrameRate());
        return this.outputFormat;
    }
}

