/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.impl.neomedia.device;

import java.awt.Component;
import java.util.LinkedList;
import java.util.List;
import javax.media.Format;
import javax.media.Player;
import javax.media.Processor;
import javax.media.protocol.DataSource;
import org.jitsi.impl.neomedia.AbstractRTPConnector;
import org.jitsi.impl.neomedia.device.AbstractMediaDevice;
import org.jitsi.impl.neomedia.device.MediaDeviceImpl;
import org.jitsi.impl.neomedia.device.MediaDeviceSession;
import org.jitsi.impl.neomedia.device.VideoMediaDeviceSession;
import org.jitsi.impl.neomedia.format.MediaFormatImpl;
import org.jitsi.service.neomedia.MediaDirection;
import org.jitsi.service.neomedia.QualityPreset;
import org.jitsi.service.neomedia.codec.EncodingConfiguration;
import org.jitsi.service.neomedia.device.MediaDevice;
import org.jitsi.service.neomedia.device.MediaDeviceWrapper;
import org.jitsi.service.neomedia.format.MediaFormat;
import org.jitsi.util.event.VideoEvent;
import org.jitsi.util.event.VideoListener;
import org.jitsi.utils.MediaType;

public class VideoTranslatorMediaDevice
extends AbstractMediaDevice
implements MediaDeviceWrapper,
VideoListener {
    private final MediaDeviceImpl device;
    private VideoMediaDeviceSession deviceSession;
    private final List<MediaStreamMediaDeviceSession> streamDeviceSessions = new LinkedList<MediaStreamMediaDeviceSession>();

    public VideoTranslatorMediaDevice(MediaDeviceImpl device) {
        this.device = device;
    }

    private synchronized void close(MediaStreamMediaDeviceSession streamDeviceSession) {
        this.streamDeviceSessions.remove(streamDeviceSession);
        if (this.deviceSession != null) {
            this.deviceSession.removeRTCPFeedbackMessageCreateListner(streamDeviceSession);
        }
        if (this.streamDeviceSessions.isEmpty()) {
            if (this.deviceSession != null) {
                this.deviceSession.removeVideoListener(this);
                this.deviceSession.close();
            }
            this.deviceSession = null;
        } else {
            this.updateDeviceSessionStartedDirection();
        }
    }

    @Override
    protected synchronized DataSource createOutputDataSource() {
        if (this.deviceSession == null) {
            MediaFormatImpl<? extends Format> format = null;
            MediaDirection startedDirection = MediaDirection.INACTIVE;
            for (MediaStreamMediaDeviceSession streamDeviceSession : this.streamDeviceSessions) {
                MediaFormatImpl<? extends Format> streamFormat = streamDeviceSession.getFormat();
                if (streamFormat != null && format == null) {
                    format = streamFormat;
                }
                startedDirection = startedDirection.or(streamDeviceSession.getStartedDirection());
            }
            MediaDeviceSession newDeviceSession = this.device.createSession();
            if (newDeviceSession instanceof VideoMediaDeviceSession) {
                this.deviceSession = (VideoMediaDeviceSession)newDeviceSession;
                this.deviceSession.addVideoListener(this);
                for (MediaStreamMediaDeviceSession streamDeviceSession : this.streamDeviceSessions) {
                    this.deviceSession.addRTCPFeedbackMessageCreateListner(streamDeviceSession);
                }
            }
            if (format != null) {
                this.deviceSession.setFormat(format);
            }
            this.deviceSession.start(startedDirection);
        }
        return this.deviceSession == null ? null : this.deviceSession.getOutputDataSource();
    }

    @Override
    public synchronized MediaDeviceSession createSession() {
        MediaStreamMediaDeviceSession streamDeviceSession = new MediaStreamMediaDeviceSession();
        this.streamDeviceSessions.add(streamDeviceSession);
        return streamDeviceSession;
    }

    @Override
    public MediaDirection getDirection() {
        return this.device.getDirection();
    }

    @Override
    public MediaFormat getFormat() {
        return this.device.getFormat();
    }

    @Override
    public MediaType getMediaType() {
        return this.device.getMediaType();
    }

    @Override
    public List<MediaFormat> getSupportedFormats(QualityPreset localPreset, QualityPreset remotePreset) {
        return this.device.getSupportedFormats(localPreset, remotePreset);
    }

    @Override
    public List<MediaFormat> getSupportedFormats(QualityPreset localPreset, QualityPreset remotePreset, EncodingConfiguration encodingConfiguration) {
        return this.device.getSupportedFormats(localPreset, remotePreset, encodingConfiguration);
    }

    @Override
    public MediaDevice getWrappedDevice() {
        return this.device;
    }

    private synchronized void updateDeviceSessionStartedDirection() {
        if (this.deviceSession == null) {
            return;
        }
        MediaDirection startDirection = MediaDirection.INACTIVE;
        for (MediaStreamMediaDeviceSession streamDeviceSession : this.streamDeviceSessions) {
            startDirection = startDirection.or(streamDeviceSession.getStartedDirection());
        }
        this.deviceSession.start(startDirection);
        MediaDirection stopDirection = MediaDirection.INACTIVE;
        if (!startDirection.allowsReceiving()) {
            stopDirection = stopDirection.or(MediaDirection.RECVONLY);
        }
        if (!startDirection.allowsSending()) {
            stopDirection = stopDirection.or(MediaDirection.SENDONLY);
        }
        this.deviceSession.stop(stopDirection);
    }

    @Override
    public void videoAdded(VideoEvent event) {
        for (MediaStreamMediaDeviceSession sds : this.streamDeviceSessions) {
            sds.fireVideoEvent(event, false);
        }
    }

    @Override
    public void videoRemoved(VideoEvent event) {
        for (MediaStreamMediaDeviceSession sds : this.streamDeviceSessions) {
            sds.fireVideoEvent(event, false);
        }
    }

    @Override
    public void videoUpdate(VideoEvent event) {
        for (MediaStreamMediaDeviceSession sds : this.streamDeviceSessions) {
            sds.fireVideoEvent(event, false);
        }
    }

    private class MediaStreamMediaDeviceSession
    extends VideoMediaDeviceSession {
        public MediaStreamMediaDeviceSession() {
            super(VideoTranslatorMediaDevice.this);
        }

        @Override
        public void close() {
            super.close();
            VideoTranslatorMediaDevice.this.close(this);
        }

        @Override
        protected DataSource createCaptureDevice() {
            return VideoTranslatorMediaDevice.this.createOutputDataSource();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected Player createLocalPlayer(DataSource captureDevice) {
            VideoTranslatorMediaDevice videoTranslatorMediaDevice = VideoTranslatorMediaDevice.this;
            synchronized (videoTranslatorMediaDevice) {
                if (VideoTranslatorMediaDevice.this.deviceSession != null) {
                    captureDevice = VideoTranslatorMediaDevice.this.deviceSession.getCaptureDevice();
                }
            }
            return super.createLocalPlayer(captureDevice);
        }

        @Override
        protected Processor createProcessor() {
            return null;
        }

        @Override
        public DataSource getOutputDataSource() {
            return this.getConnectedCaptureDevice();
        }

        @Override
        public void setConnector(AbstractRTPConnector rtpConnector) {
            super.setConnector(rtpConnector);
            if (VideoTranslatorMediaDevice.this.deviceSession != null) {
                VideoTranslatorMediaDevice.this.deviceSession.addRTCPFeedbackMessageCreateListner(this);
            }
        }

        @Override
        protected void startedDirectionChanged(MediaDirection oldValue, MediaDirection newValue) {
            super.startedDirectionChanged(oldValue, newValue);
            VideoTranslatorMediaDevice.this.updateDeviceSessionStartedDirection();
        }

        @Override
        public Component getLocalVisualComponent() {
            if (VideoTranslatorMediaDevice.this.deviceSession != null) {
                return VideoTranslatorMediaDevice.this.deviceSession.getLocalVisualComponent();
            }
            return null;
        }

        @Override
        protected Component createLocalVisualComponent() {
            if (VideoTranslatorMediaDevice.this.deviceSession != null) {
                return VideoTranslatorMediaDevice.this.deviceSession.createLocalVisualComponent();
            }
            return null;
        }

        @Override
        protected Player getLocalPlayer() {
            if (VideoTranslatorMediaDevice.this.deviceSession != null) {
                return VideoTranslatorMediaDevice.this.deviceSession.getLocalPlayer();
            }
            return null;
        }

        @Override
        protected void disposeLocalPlayer(Player player) {
        }
    }
}

