/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.impl.neomedia.recording;

import java.io.IOException;
import org.jitsi.utils.JNIUtils;

public class WebmWriter {
    public static int FLAG_FRAME_IS_KEY;
    public static int FLAG_FRAME_IS_INVISIBLE;
    private long glob = this.allocCfg();

    private native long allocCfg();

    private native void freeCfg(long var1);

    private native boolean openFile(long var1, String var3);

    private native void writeWebmFileHeader(long var1, int var3, int var4);

    public void writeWebmFileHeader(int width, int height) {
        this.writeWebmFileHeader(this.glob, width, height);
    }

    private native void writeWebmBlock(long var1, FrameDescriptor var3);

    private native void writeWebmFileFooter(long var1, long var3);

    public WebmWriter(String filename) throws IOException {
        if (this.glob == 0L) {
            throw new IOException("allocCfg() failed");
        }
        if (this.openFile(this.glob, filename)) {
            throw new IOException("Can not open " + filename + " for writing");
        }
    }

    public void close() {
        this.writeWebmFileFooter(this.glob, 0L);
        this.freeCfg(this.glob);
    }

    public void writeFrame(FrameDescriptor fd) {
        this.writeWebmBlock(this.glob, fd);
    }

    static {
        JNIUtils.loadLibrary((String)"jnvpx", WebmWriter.class);
        FLAG_FRAME_IS_KEY = 1;
        FLAG_FRAME_IS_INVISIBLE = 4;
    }

    public static class FrameDescriptor {
        public byte[] buffer;
        public int offset;
        public long length;
        public long pts;
        public int flags;
    }
}

