/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.impl.neomedia.rtp.translator;

import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicInteger;
import org.jitsi.impl.neomedia.RTCPFeedbackMessagePacket;
import org.jitsi.impl.neomedia.VideoMediaStreamImpl;
import org.jitsi.impl.neomedia.rtp.StreamRTPManager;
import org.jitsi.impl.neomedia.rtp.translator.RTPTranslatorImpl;
import org.jitsi.impl.neomedia.rtp.translator.StreamRTPManagerDesc;
import org.jitsi.utils.concurrent.PeriodicRunnable;
import org.jitsi.utils.concurrent.RecurringRunnable;
import org.jitsi.utils.concurrent.RecurringRunnableExecutor;
import org.jitsi.utils.logging.Logger;

public class RTCPFeedbackMessageSender {
    private static final Logger logger = Logger.getLogger(RTCPFeedbackMessageSender.class);
    private static final boolean TRACE = logger.isTraceEnabled();
    private static final int FIR_RETRY_INTERVAL_MS = 300;
    private static final int FIR_MAX_RETRIES = 10;
    private final RTPTranslatorImpl rtpTranslator;
    private final RecurringRunnableExecutor recurringRunnableExecutor = new RecurringRunnableExecutor(RTCPFeedbackMessageSender.class.getSimpleName());
    private final ConcurrentMap<Long, KeyframeRequester> kfRequesters = new ConcurrentHashMap<Long, KeyframeRequester>();

    public RTCPFeedbackMessageSender(RTPTranslatorImpl rtpTranslator) {
        this.rtpTranslator = rtpTranslator;
    }

    private long getSenderSSRC() {
        long ssrc = this.rtpTranslator.getLocalSSRC(null);
        return ssrc == Long.MAX_VALUE ? -1L : ssrc;
    }

    @Deprecated
    public boolean sendFIR(int mediaSenderSSRC) {
        return this.requestKeyframe((long)mediaSenderSSRC & 0xFFFFFFFFL);
    }

    public boolean requestKeyframe(long mediaSenderSSRC) {
        boolean registerRecurringRunnable = false;
        KeyframeRequester keyframeRequester = (KeyframeRequester)((Object)this.kfRequesters.get(mediaSenderSSRC));
        if (keyframeRequester == null) {
            keyframeRequester = new KeyframeRequester(mediaSenderSSRC);
            KeyframeRequester existingKfRequester = this.kfRequesters.putIfAbsent(mediaSenderSSRC, keyframeRequester);
            if (existingKfRequester != null) {
                keyframeRequester = existingKfRequester;
            } else {
                registerRecurringRunnable = true;
            }
        }
        if (registerRecurringRunnable) {
            this.recurringRunnableExecutor.registerRecurringRunnable((RecurringRunnable)keyframeRequester);
        }
        return keyframeRequester.maybeRequest(true);
    }

    @Deprecated
    public boolean sendFIR(int[] mediaSenderSSRCs) {
        long[] ssrcsAsLong = new long[mediaSenderSSRCs.length];
        for (int i = 0; i < ssrcsAsLong.length; ++i) {
            ssrcsAsLong[i] = (long)mediaSenderSSRCs[i] & 0xFFFFFFFFL;
        }
        return this.requestKeyframe(ssrcsAsLong);
    }

    public boolean requestKeyframe(long[] mediaSenderSSRCs) {
        if (mediaSenderSSRCs == null || mediaSenderSSRCs.length == 0) {
            return false;
        }
        boolean requested = false;
        for (long mediaSenderSSRC : mediaSenderSSRCs) {
            if (!this.requestKeyframe(mediaSenderSSRC)) continue;
            requested = true;
        }
        return requested;
    }

    public void maybeStopRequesting(StreamRTPManagerDesc streamRTPManager, long ssrc, byte[] buf, int off, int len) {
        KeyframeRequester kfRequester = (KeyframeRequester)((Object)this.kfRequesters.get(ssrc));
        if (kfRequester != null) {
            kfRequester.maybeStopRequesting(streamRTPManager, buf, off, len);
        }
    }

    void dispose() {
        this.recurringRunnableExecutor.close();
    }

    class KeyframeRequester
    extends PeriodicRunnable {
        private final long mediaSenderSSRC;
        private final AtomicInteger sequenceNumber;
        private int remainingRetries;

        public KeyframeRequester(long mediaSenderSSRC) {
            super(300L);
            this.sequenceNumber = new AtomicInteger(0);
            this.mediaSenderSSRC = mediaSenderSSRC;
            this.remainingRetries = 0;
        }

        public void run() {
            super.run();
            this.maybeRequest(false);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void maybeStopRequesting(StreamRTPManagerDesc streamRTPManager, byte[] buf, int off, int len) {
            if (this.remainingRetries == 0) {
                return;
            }
            if (!streamRTPManager.streamRTPManager.getMediaStream().isKeyFrame(buf, off, len)) {
                return;
            }
            if (TRACE) {
                logger.trace((Object)("Stopping FIRs to ssrc=" + this.mediaSenderSSRC));
            }
            KeyframeRequester keyframeRequester = this;
            synchronized (keyframeRequester) {
                this.remainingRetries = 0;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public boolean maybeRequest(boolean allowResetRemainingRetries) {
            RTCPFeedbackMessagePacket request;
            KeyframeRequester keyframeRequester = this;
            synchronized (keyframeRequester) {
                if (allowResetRemainingRetries) {
                    if (this.remainingRetries != 0) {
                        if (!TRACE) return true;
                        logger.trace((Object)("Pending FIRs to ssrc=" + this.mediaSenderSSRC));
                        return true;
                    }
                    if (TRACE) {
                        logger.trace((Object)("Starting FIRs to ssrc=" + this.mediaSenderSSRC));
                    }
                    this.remainingRetries = 10;
                } else if (this.remainingRetries == 0) {
                    return false;
                }
                --this.remainingRetries;
                logger.info((Object)("Sending a FIR to ssrc=" + this.mediaSenderSSRC + " remainingRetries=" + this.remainingRetries));
            }
            long senderSSRC = RTCPFeedbackMessageSender.this.getSenderSSRC();
            if (senderSSRC == -1L) {
                logger.warn((Object)"Not sending an FIR because the sender SSRC is -1.");
                return false;
            }
            StreamRTPManager streamRTPManager = RTCPFeedbackMessageSender.this.rtpTranslator.findStreamRTPManagerByReceiveSSRC((int)this.mediaSenderSSRC);
            if (streamRTPManager == null) {
                logger.warn((Object)"Not sending an FIR because the stream RTP manager is null.");
                return false;
            }
            VideoMediaStreamImpl videoMediaStream = (VideoMediaStreamImpl)streamRTPManager.getMediaStream();
            if (!videoMediaStream.supportsPli() && videoMediaStream.supportsFir()) {
                request = new RTCPFeedbackMessagePacket(4, 206, senderSSRC, this.mediaSenderSSRC);
                request.setSequenceNumber(this.sequenceNumber.incrementAndGet());
                return RTCPFeedbackMessageSender.this.rtpTranslator.writeControlPayload(request, videoMediaStream);
            }
            request = new RTCPFeedbackMessagePacket(1, 206, senderSSRC, this.mediaSenderSSRC);
            if (videoMediaStream.supportsPli()) return RTCPFeedbackMessageSender.this.rtpTranslator.writeControlPayload(request, videoMediaStream);
            logger.warn((Object)"Sending a PLI to a media sender for which PLI support hasn't been explicitly signaled.");
            return RTCPFeedbackMessageSender.this.rtpTranslator.writeControlPayload(request, videoMediaStream);
        }
    }
}

