/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.impl.neomedia.transform;

import java.io.IOException;
import org.jitsi.impl.neomedia.RTPConnectorTCPImpl;
import org.jitsi.impl.neomedia.RTPConnectorTCPInputStream;
import org.jitsi.impl.neomedia.transform.PacketTransformer;
import org.jitsi.impl.neomedia.transform.RTPTransformUDPConnector;
import org.jitsi.impl.neomedia.transform.TransformEngine;
import org.jitsi.impl.neomedia.transform.TransformTCPOutputStream;
import org.jitsi.service.neomedia.StreamConnector;
import org.jitsi.utils.logging.Logger;

public class RTPTransformTCPConnector
extends RTPConnectorTCPImpl {
    private static final Logger logger = Logger.getLogger(RTPTransformUDPConnector.class);
    private TransformEngine engine;

    public RTPTransformTCPConnector(StreamConnector connector) {
        super(connector);
    }

    protected RTPConnectorTCPInputStream createControlInputStream() throws IOException {
        RTPConnectorTCPInputStream controlInputStream = new RTPConnectorTCPInputStream(this.getControlSocket());
        controlInputStream.setTransformer(this.getRTCPTransformer());
        return controlInputStream;
    }

    @Override
    protected TransformTCPOutputStream createControlOutputStream() throws IOException {
        TransformTCPOutputStream controlOutputStream = new TransformTCPOutputStream(this.getControlSocket());
        controlOutputStream.setTransformer(this.getRTCPTransformer());
        return controlOutputStream;
    }

    protected RTPConnectorTCPInputStream createDataInputStream() throws IOException {
        RTPConnectorTCPInputStream dataInputStream = new RTPConnectorTCPInputStream(this.getDataSocket());
        dataInputStream.setTransformer(this.getRTPTransformer());
        return dataInputStream;
    }

    @Override
    protected TransformTCPOutputStream createDataOutputStream() throws IOException {
        TransformTCPOutputStream dataOutputStream = new TransformTCPOutputStream(this.getDataSocket());
        dataOutputStream.setTransformer(this.getRTPTransformer());
        return dataOutputStream;
    }

    public TransformEngine getEngine() {
        return this.engine;
    }

    private PacketTransformer getRTCPTransformer() {
        TransformEngine engine = this.getEngine();
        return engine == null ? null : engine.getRTCPTransformer();
    }

    private PacketTransformer getRTPTransformer() {
        TransformEngine engine = this.getEngine();
        return engine == null ? null : engine.getRTPTransformer();
    }

    public void setEngine(TransformEngine engine) {
        if (this.engine != engine) {
            TransformTCPOutputStream dataOutputStream;
            RTPConnectorTCPInputStream dataInputStream;
            TransformTCPOutputStream controlOutputStream;
            RTPConnectorTCPInputStream controlInputStream;
            this.engine = engine;
            try {
                controlInputStream = (RTPConnectorTCPInputStream)this.getControlInputStream(false);
            }
            catch (IOException ioex) {
                logger.error((Object)"The impossible happened", (Throwable)ioex);
                controlInputStream = null;
            }
            if (controlInputStream != null) {
                controlInputStream.setTransformer(this.getRTCPTransformer());
            }
            try {
                controlOutputStream = (TransformTCPOutputStream)this.getControlOutputStream(false);
            }
            catch (IOException ioex) {
                logger.error((Object)"The impossible happened", (Throwable)ioex);
                controlOutputStream = null;
            }
            if (controlOutputStream != null) {
                controlOutputStream.setTransformer(this.getRTCPTransformer());
            }
            try {
                dataInputStream = (RTPConnectorTCPInputStream)this.getDataInputStream(false);
            }
            catch (IOException ioex) {
                logger.error((Object)"The impossible happened", (Throwable)ioex);
                dataInputStream = null;
            }
            if (dataInputStream != null) {
                dataInputStream.setTransformer(this.getRTPTransformer());
            }
            try {
                dataOutputStream = (TransformTCPOutputStream)this.getDataOutputStream(false);
            }
            catch (IOException ioex) {
                logger.error((Object)"The impossible happened", (Throwable)ioex);
                dataOutputStream = null;
            }
            if (dataOutputStream != null) {
                dataOutputStream.setTransformer(this.getRTPTransformer());
            }
        }
    }
}

