/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.impl.neomedia.transform;

import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import org.jitsi.impl.neomedia.MediaStreamImpl;
import org.jitsi.impl.neomedia.RTCPPacketPredicate;
import org.jitsi.impl.neomedia.RTPPacketPredicate;
import org.jitsi.impl.neomedia.rtcp.NACKPacket;
import org.jitsi.impl.neomedia.rtcp.RTCPIterator;
import org.jitsi.impl.neomedia.rtp.MediaStreamTrackReceiver;
import org.jitsi.impl.neomedia.rtp.RTPEncodingDesc;
import org.jitsi.impl.neomedia.rtp.RawPacketCache;
import org.jitsi.impl.neomedia.rtp.StreamRTPManager;
import org.jitsi.impl.neomedia.stats.MediaStreamStats2Impl;
import org.jitsi.impl.neomedia.transform.CachingTransformer;
import org.jitsi.impl.neomedia.transform.PacketTransformer;
import org.jitsi.impl.neomedia.transform.SinglePacketTransformerAdapter;
import org.jitsi.impl.neomedia.transform.TransformEngine;
import org.jitsi.service.configuration.ConfigurationService;
import org.jitsi.service.libjitsi.LibJitsi;
import org.jitsi.service.neomedia.MediaStream;
import org.jitsi.service.neomedia.RawPacket;
import org.jitsi.service.neomedia.TransmissionFailedException;
import org.jitsi.service.neomedia.format.MediaFormat;
import org.jitsi.utils.ByteArrayBuffer;
import org.jitsi.utils.logging.Logger;

public class RtxTransformer
implements TransformEngine {
    public static final String DISABLE_NACK_TERMINATION_PNAME = "org.jitsi.impl.neomedia.rtcp.DISABLE_NACK_TERMINATION";
    private MediaStreamImpl mediaStream;
    private final Map<Long, Integer> rtxSequenceNumbers = new HashMap<Long, Integer>();
    private final Logger logger = Logger.getLogger(RtxTransformer.class);
    private Map<Byte, Byte> apt2rtx = new HashMap<Byte, Byte>();
    private Map<Byte, Byte> rtx2apt = new HashMap<Byte, Byte>();
    private final RTPTransformer rtpTransformer = new RTPTransformer();
    private final RTCPTransformer rtcpTransformer = new RTCPTransformer();

    public RtxTransformer(MediaStreamImpl mediaStream) {
        boolean enableNackTermination;
        this.mediaStream = mediaStream;
        ConfigurationService cfg = LibJitsi.getConfigurationService();
        if (cfg == null) {
            this.logger.warn((Object)"NOT initializing RTCP n' NACK termination because the configuration service was not found.");
            return;
        }
        boolean bl = enableNackTermination = !cfg.getBoolean(DISABLE_NACK_TERMINATION_PNAME, false);
        if (enableNackTermination) {
            CachingTransformer cache = mediaStream.getCachingTransformer();
            if (cache != null) {
                cache.setEnabled(true);
            } else {
                this.logger.warn((Object)"NACK termination is enabled, but we don't have a packet cache.");
            }
        }
    }

    @Override
    public PacketTransformer getRTPTransformer() {
        return this.rtpTransformer;
    }

    @Override
    public PacketTransformer getRTCPTransformer() {
        return this.rtcpTransformer;
    }

    public boolean destinationSupportsRtx() {
        return !this.apt2rtx.isEmpty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int getNextRtxSequenceNumber(long ssrc) {
        Integer seq;
        Map<Long, Integer> map = this.rtxSequenceNumbers;
        synchronized (map) {
            seq = this.rtxSequenceNumbers.get(ssrc);
            if (seq == null) {
                seq = new Random().nextInt(65535);
            } else {
                Integer n = seq;
                Integer n2 = seq = Integer.valueOf(seq + 1);
            }
            this.rtxSequenceNumbers.put(ssrc, seq);
        }
        return seq;
    }

    private long getRtxSsrc(RawPacket pkt) {
        MediaStream receiveStream;
        StreamRTPManager receiveRTPManager = this.mediaStream.getRTPTranslator().findStreamRTPManagerByReceiveSSRC(pkt.getSSRC());
        MediaStreamTrackReceiver receiver = null;
        if (receiveRTPManager != null && (receiveStream = receiveRTPManager.getMediaStream()) != null) {
            receiver = receiveStream.getMediaStreamTrackReceiver();
        }
        if (receiver == null) {
            return -1L;
        }
        RTPEncodingDesc encoding = receiver.findRTPEncodingDesc(pkt);
        if (encoding == null) {
            this.logger.warn((Object)("encoding_not_found,stream_hash=" + this.mediaStream.hashCode() + " ssrc=" + pkt.getSSRCAsLong()));
            return -1L;
        }
        return encoding.getSecondarySsrc("rtx");
    }

    private boolean retransmit(RawPacket pkt, Byte rtxPt, TransformEngine after) {
        boolean retransmitPlain;
        boolean destinationSupportsRtx;
        boolean bl = destinationSupportsRtx = rtxPt != null;
        if (destinationSupportsRtx) {
            long rtxSsrc = this.getRtxSsrc(pkt);
            if (rtxSsrc == -1L) {
                this.logger.warn((Object)("Cannot find SSRC for RTX, retransmitting plain. SSRC=" + pkt.getSSRCAsLong()));
                retransmitPlain = true;
            } else {
                retransmitPlain = !this.encapsulateInRtxAndTransmit(pkt, rtxSsrc, rtxPt, after);
            }
        } else {
            retransmitPlain = true;
        }
        if (retransmitPlain && this.mediaStream != null) {
            try {
                this.mediaStream.injectPacket(pkt, true, after);
            }
            catch (TransmissionFailedException tfe) {
                this.logger.warn((Object)"Failed to retransmit a packet.");
                return false;
            }
        }
        return true;
    }

    public void onDynamicPayloadTypesChanged() {
        HashMap<Byte, Byte> apt2rtx = new HashMap<Byte, Byte>();
        HashMap<Byte, Byte> rtx2apt = new HashMap<Byte, Byte>();
        Map<Byte, MediaFormat> mediaFormatMap = this.mediaStream.getDynamicRTPPayloadTypes();
        for (Map.Entry<Byte, MediaFormat> entry : mediaFormatMap.entrySet()) {
            Byte apt;
            MediaFormat format = entry.getValue();
            if (!"rtx".equalsIgnoreCase(format.getEncoding())) continue;
            Byte pt = entry.getKey();
            String aptString = format.getFormatParameters().get("apt");
            try {
                apt = Byte.parseByte(aptString);
            }
            catch (NumberFormatException nfe) {
                this.logger.error((Object)("Failed to parse apt: " + aptString));
                continue;
            }
            apt2rtx.put(apt, pt);
            rtx2apt.put(pt, apt);
        }
        this.rtx2apt = rtx2apt;
        this.apt2rtx = apt2rtx;
    }

    private boolean encapsulateInRtxAndTransmit(RawPacket pkt, long rtxSsrc, byte rtxPt, TransformEngine after) {
        byte[] buf = pkt.getBuffer();
        int len = pkt.getLength();
        int off = pkt.getOffset();
        byte[] newBuf = new byte[len + 2];
        RawPacket rtxPkt = new RawPacket(newBuf, 0, len + 2);
        int osn = pkt.getSequenceNumber();
        int headerLength = pkt.getHeaderLength();
        int payloadLength = pkt.getPayloadLength();
        System.arraycopy(buf, off, newBuf, 0, headerLength);
        newBuf[headerLength] = (byte)(osn >> 8 & 0xFF);
        newBuf[headerLength + 1] = (byte)(osn & 0xFF);
        System.arraycopy(buf, off + headerLength, newBuf, headerLength + 2, payloadLength);
        if (this.mediaStream != null) {
            rtxPkt.setSSRC((int)rtxSsrc);
            rtxPkt.setPayloadType(rtxPt);
            rtxPkt.setSequenceNumber(this.getNextRtxSequenceNumber(rtxSsrc));
            try {
                this.mediaStream.injectPacket(rtxPkt, true, after);
            }
            catch (TransmissionFailedException tfe) {
                this.logger.warn((Object)"Failed to transmit an RTX packet.");
                return false;
            }
        }
        return true;
    }

    private long getPrimarySsrc(long rtxSSRC) {
        MediaStreamTrackReceiver receiver = this.mediaStream.getMediaStreamTrackReceiver();
        if (receiver == null) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)"Dropping an incoming RTX packet from an unknown source.");
            }
            return -1L;
        }
        RTPEncodingDesc encoding = receiver.findRTPEncodingDesc(rtxSSRC);
        if (encoding == null) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)"Dropping an incoming RTX packet from an unknown source.");
            }
            return -1L;
        }
        return encoding.getPrimarySSRC();
    }

    private RawPacketCache getCache() {
        MediaStreamImpl stream = this.mediaStream;
        CachingTransformer cachingTransformer = stream != null ? stream.getCachingTransformer() : null;
        return cachingTransformer != null ? cachingTransformer.getOutgoingRawPacketCache() : null;
    }

    private void nackReceived(long mediaSSRC, Collection<Integer> lostPackets) {
        RawPacketCache cache;
        if (this.logger.isDebugEnabled()) {
            this.logger.debug(Logger.Category.STATISTICS, "nack_received,stream=" + this.mediaStream.hashCode() + " ssrc=" + mediaSSRC + ",lost_packets=" + lostPackets);
        }
        if ((cache = this.getCache()) != null) {
            RtxTransformer after = this;
            long rtt = this.mediaStream.getMediaStreamStats().getSendStats().getRtt();
            long now = System.currentTimeMillis();
            Iterator<Integer> i = lostPackets.iterator();
            while (i.hasNext()) {
                int seq = i.next();
                RawPacketCache.Container container = cache.getContainer(mediaSSRC, seq);
                MediaStreamStats2Impl stats = this.mediaStream.getMediaStreamStats();
                if (container != null) {
                    boolean send;
                    long delay = now - container.timeAdded;
                    boolean bl = send = rtt == -1L || (double)delay >= Math.min((double)rtt * 0.9, (double)(rtt - 5L));
                    if (this.logger.isDebugEnabled()) {
                        this.logger.debug(Logger.Category.STATISTICS, "retransmitting,stream=" + this.mediaStream.hashCode() + " ssrc=" + mediaSSRC + ",seq=" + seq + ",send=" + send);
                    }
                    Byte rtxPt = this.apt2rtx.get(container.pkt.getPayloadType());
                    if (send && this.retransmit(container.pkt, rtxPt, after)) {
                        stats.rtpPacketRetransmitted(mediaSSRC, container.pkt.getLength());
                        cache.updateTimestamp(mediaSSRC, seq, now);
                        i.remove();
                    }
                    if (send) continue;
                    stats.rtpPacketNotRetransmitted(mediaSSRC, container.pkt.getLength());
                    i.remove();
                    continue;
                }
                stats.rtpPacketCacheMiss(mediaSSRC);
            }
        }
        if (!lostPackets.isEmpty() && this.logger.isDebugEnabled()) {
            this.logger.debug((Object)"Packets missing from the cache.");
        }
    }

    public int sendPadding(long ssrc, int bytes) {
        StreamRTPManager receiveRTPManager = this.mediaStream.getRTPTranslator().findStreamRTPManagerByReceiveSSRC((int)ssrc);
        if (receiveRTPManager == null) {
            this.logger.warn((Object)("rtp_manager_not_found,stream_hash=" + this.mediaStream.hashCode() + " ssrc=" + ssrc));
            return bytes;
        }
        MediaStream receiveStream = receiveRTPManager.getMediaStream();
        if (receiveStream == null) {
            this.logger.warn((Object)("stream_not_found,stream_hash=" + this.mediaStream.hashCode() + " ssrc=" + ssrc));
            return bytes;
        }
        MediaStreamTrackReceiver receiver = receiveStream.getMediaStreamTrackReceiver();
        if (receiver == null) {
            this.logger.warn((Object)("receiver_not_found,stream_hash=" + this.mediaStream.hashCode() + " ssrc=" + ssrc));
            return bytes;
        }
        RTPEncodingDesc encoding = receiver.findRTPEncodingDesc(ssrc);
        if (encoding == null) {
            this.logger.warn((Object)("encoding_not_found,stream_hash=" + this.mediaStream.hashCode() + " ssrc=" + ssrc));
            return bytes;
        }
        RawPacketCache cache = this.getCache();
        if (cache == null) {
            return bytes;
        }
        Set<RawPacketCache.Container> lastNPackets = cache.getMany(ssrc, bytes);
        if (lastNPackets == null || lastNPackets.isEmpty()) {
            return bytes;
        }
        for (int i = 0; i < 2; ++i) {
            for (RawPacketCache.Container container : lastNPackets) {
                RawPacket pkt = container.pkt;
                if (pkt == null) continue;
                int len = container.pkt.getLength();
                Byte apt = this.rtx2apt.get(container.pkt.getPayloadType());
                if (bytes - len <= 0 || apt == null) continue;
                this.retransmit(container.pkt, apt, this);
                bytes -= len;
            }
        }
        return bytes;
    }

    private class RTCPTransformer
    extends SinglePacketTransformerAdapter {
        RTCPTransformer() {
            super(RTCPPacketPredicate.INSTANCE);
        }

        @Override
        public RawPacket reverseTransform(RawPacket pkt) {
            RTCPIterator it = new RTCPIterator(pkt);
            while (it.hasNext()) {
                ByteArrayBuffer next = it.next();
                if (!NACKPacket.isNACKPacket(next)) continue;
                Collection<Integer> lostPackets = NACKPacket.getLostPackets(next);
                long mediaSSRC = NACKPacket.getSourceSSRC(next);
                RtxTransformer.this.nackReceived(mediaSSRC, lostPackets);
                it.remove();
            }
            return pkt;
        }
    }

    private class RTPTransformer
    extends SinglePacketTransformerAdapter {
        RTPTransformer() {
            super(RTPPacketPredicate.INSTANCE);
        }

        @Override
        public RawPacket reverseTransform(RawPacket pkt) {
            Byte apt = (Byte)RtxTransformer.this.rtx2apt.get(pkt.getPayloadType());
            if (apt == null) {
                return pkt;
            }
            if (pkt.getPayloadLength() - pkt.getPaddingSize() < 2) {
                if (RtxTransformer.this.logger.isDebugEnabled()) {
                    RtxTransformer.this.logger.debug((Object)("Dropping an incoming RTX packet with padding only: " + pkt));
                }
                return null;
            }
            boolean success = false;
            long mediaSsrc = RtxTransformer.this.getPrimarySsrc(pkt.getSSRCAsLong());
            if (mediaSsrc != -1L) {
                int osn = pkt.getOriginalSequenceNumber();
                byte[] buf = pkt.getBuffer();
                int off = pkt.getOffset();
                System.arraycopy(buf, off, buf, off + 2, pkt.getHeaderLength());
                pkt.setOffset(off + 2);
                pkt.setLength(pkt.getLength() - 2);
                pkt.setSSRC((int)mediaSsrc);
                pkt.setSequenceNumber(osn);
                pkt.setPayloadType(apt);
                success = true;
            }
            return success ? pkt : null;
        }
    }
}

