/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.impl.neomedia.transform.dtls;

import java.io.IOException;
import java.math.BigInteger;
import java.security.SecureRandom;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.asn1.x500.X500NameBuilder;
import org.bouncycastle.asn1.x500.style.BCStyle;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.asn1.x509.Certificate;
import org.bouncycastle.cert.X509v3CertificateBuilder;
import org.bouncycastle.crypto.AsymmetricCipherKeyPair;
import org.bouncycastle.crypto.ExtendedDigest;
import org.bouncycastle.crypto.KeyGenerationParameters;
import org.bouncycastle.crypto.generators.RSAKeyPairGenerator;
import org.bouncycastle.crypto.params.AsymmetricKeyParameter;
import org.bouncycastle.crypto.params.RSAKeyGenerationParameters;
import org.bouncycastle.crypto.util.SubjectPublicKeyInfoFactory;
import org.bouncycastle.operator.ContentSigner;
import org.bouncycastle.operator.DefaultDigestAlgorithmIdentifierFinder;
import org.bouncycastle.operator.DefaultSignatureAlgorithmIdentifierFinder;
import org.bouncycastle.operator.bc.BcDefaultDigestProvider;
import org.bouncycastle.operator.bc.BcRSAContentSignerBuilder;
import org.jitsi.impl.neomedia.AbstractRTPConnector;
import org.jitsi.impl.neomedia.transform.dtls.CertificateInfo;
import org.jitsi.impl.neomedia.transform.dtls.DtlsTransformEngine;
import org.jitsi.impl.neomedia.transform.dtls.Properties;
import org.jitsi.service.configuration.ConfigurationService;
import org.jitsi.service.libjitsi.LibJitsi;
import org.jitsi.service.neomedia.AbstractSrtpControl;
import org.jitsi.service.neomedia.DtlsControl;
import org.jitsi.service.neomedia.SrtpControlType;
import org.jitsi.utils.ConfigUtils;
import org.jitsi.utils.MediaType;
import org.jitsi.utils.StringUtils;
import org.jitsi.utils.logging.Logger;

public class DtlsControlImpl
extends AbstractSrtpControl<DtlsTransformEngine>
implements DtlsControl {
    private static final Map<String, String[]> HASH_FUNCTION_UPGRADES = new HashMap<String, String[]>();
    private static final char[] HEX_ENCODE_TABLE = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
    private static final Logger logger = Logger.getLogger(DtlsControlImpl.class);
    private static final long ONE_DAY = 86400000L;
    public static final String PROP_SIGNATURE_ALGORITHM = "org.jitsi.impl.neomedia.transform.dtls.SIGNATURE_ALGORITHM";
    public static final String RSA_KEY_SIZE_PNAME = "org.jitsi.impl.neomedia.transform.dtls.RSA_KEY_SIZE";
    public static final int DEFAULT_RSA_KEY_SIZE = 1024;
    public static final int RSA_KEY_SIZE;
    public static final String RSA_KEY_SIZE_CERTAINTY_PNAME = "org.jitsi.impl.neomedia.transform.dtls.RSA_KEY_SIZE_CERTAINTY";
    public static final int RSA_KEY_SIZE_CERTAINTY;
    public static final int DEFAULT_RSA_KEY_SIZE_CERTAINTY = 80;
    public static final String CERT_CACHE_EXPIRE_TIME_PNAME = "org.jitsi.impl.neomedia.transform.dtls.CERT_CACHE_EXPIRE_TIME";
    public static final long CERT_CACHE_EXPIRE_TIME;
    public static final long DEFAULT_CERT_CACHE_EXPIRE_TIME = 86400000L;
    public static final BigInteger RSA_KEY_PUBLIC_EXPONENT;
    static final int[] SRTP_PROTECTION_PROFILES;
    private static final boolean VERIFY_AND_VALIDATE_CERTIFICATE;
    private static final String VERIFY_AND_VALIDATE_CERTIFICATE_PNAME;
    private static CertificateInfo certificateInfoCache;
    private final CertificateInfo certificateInfo;
    private boolean disposed = false;
    private Map<String, String> remoteFingerprints;
    private final Properties properties;

    static int chooseSRTPProtectionProfile(int ... theirs) {
        if (theirs != null) {
            int[] ours = SRTP_PROTECTION_PROFILES;
            for (int their : theirs) {
                for (int our : ours) {
                    if (their != our) continue;
                    return their;
                }
            }
        }
        return 0;
    }

    private static String computeFingerprint(Certificate certificate, String hashFunction) {
        try {
            AlgorithmIdentifier digAlgId = new DefaultDigestAlgorithmIdentifierFinder().find(hashFunction.toUpperCase());
            ExtendedDigest digest = BcDefaultDigestProvider.INSTANCE.get(digAlgId);
            byte[] in = certificate.getEncoded("DER");
            byte[] out = new byte[digest.getDigestSize()];
            digest.update(in, 0, in.length);
            digest.doFinal(out, 0);
            return DtlsControlImpl.toHex(out);
        }
        catch (Throwable t) {
            if (t instanceof ThreadDeath) {
                throw (ThreadDeath)t;
            }
            logger.error((Object)"Failed to generate certificate fingerprint!", t);
            if (t instanceof RuntimeException) {
                throw (RuntimeException)t;
            }
            throw new RuntimeException(t);
        }
    }

    private static String findHashFunction(Certificate certificate) {
        try {
            AlgorithmIdentifier sigAlgId = certificate.getSignatureAlgorithm();
            AlgorithmIdentifier digAlgId = new DefaultDigestAlgorithmIdentifierFinder().find(sigAlgId);
            return BcDefaultDigestProvider.INSTANCE.get(digAlgId).getAlgorithmName().toLowerCase();
        }
        catch (Throwable t) {
            if (t instanceof ThreadDeath) {
                throw (ThreadDeath)t;
            }
            logger.warn((Object)"Failed to find the hash function of the signature algorithm of a certificate!", t);
            if (t instanceof RuntimeException) {
                throw (RuntimeException)t;
            }
            throw new RuntimeException(t);
        }
    }

    private static String findHashFunctionUpgrade(String hashFunction, Map<String, String> fingerprints) {
        String[] hashFunctionUpgrades = HASH_FUNCTION_UPGRADES.get(hashFunction);
        if (hashFunctionUpgrades != null) {
            for (String hashFunctionUpgrade : hashFunctionUpgrades) {
                String fingerprint = fingerprints.get(hashFunctionUpgrade);
                if (fingerprint == null) continue;
                return hashFunctionUpgrade.toLowerCase();
            }
        }
        return null;
    }

    private static CertificateInfo generateCertificateInfo() {
        AsymmetricCipherKeyPair keyPair = DtlsControlImpl.generateKeyPair();
        Certificate x509Certificate = DtlsControlImpl.generateX509Certificate(DtlsControlImpl.generateCN(), keyPair);
        org.bouncycastle.crypto.tls.Certificate certificate = new org.bouncycastle.crypto.tls.Certificate(new Certificate[]{x509Certificate});
        String localFingerprintHashFunction = DtlsControlImpl.findHashFunction(x509Certificate);
        String localFingerprint = DtlsControlImpl.computeFingerprint(x509Certificate, localFingerprintHashFunction);
        long timestamp = System.currentTimeMillis();
        return new CertificateInfo(keyPair, certificate, localFingerprintHashFunction, localFingerprint, timestamp);
    }

    private static X500Name generateCN() {
        X500NameBuilder builder = new X500NameBuilder(BCStyle.INSTANCE);
        String applicationName = "libjitsi";
        String applicationVersion = null;
        StringBuilder cn = new StringBuilder();
        if (!StringUtils.isNullOrEmpty((String)applicationName, (boolean)true)) {
            cn.append(applicationName);
        }
        if (!StringUtils.isNullOrEmpty(applicationVersion, (boolean)true)) {
            if (cn.length() != 0) {
                cn.append(' ');
            }
            cn.append(applicationVersion);
        }
        if (cn.length() == 0) {
            cn.append(DtlsControlImpl.class.getName());
        }
        builder.addRDN(BCStyle.CN, cn.toString());
        return builder.build();
    }

    private static AsymmetricCipherKeyPair generateKeyPair() {
        RSAKeyPairGenerator generator = new RSAKeyPairGenerator();
        generator.init((KeyGenerationParameters)new RSAKeyGenerationParameters(RSA_KEY_PUBLIC_EXPONENT, new SecureRandom(), RSA_KEY_SIZE, RSA_KEY_SIZE_CERTAINTY));
        return generator.generateKeyPair();
    }

    private static Certificate generateX509Certificate(X500Name subject, AsymmetricCipherKeyPair keyPair) {
        String signatureAlgorithm = ConfigUtils.getString((ConfigurationService)LibJitsi.getConfigurationService(), (String)PROP_SIGNATURE_ALGORITHM, (String)"SHA1withRSA");
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Signature algorithm: " + signatureAlgorithm));
        }
        try {
            long now = System.currentTimeMillis();
            Date notBefore = new Date(now - 86400000L);
            Date notAfter = new Date(now + 518400000L + CERT_CACHE_EXPIRE_TIME);
            X509v3CertificateBuilder builder = new X509v3CertificateBuilder(subject, BigInteger.valueOf(now), notBefore, notAfter, subject, SubjectPublicKeyInfoFactory.createSubjectPublicKeyInfo((AsymmetricKeyParameter)keyPair.getPublic()));
            AlgorithmIdentifier sigAlgId = new DefaultSignatureAlgorithmIdentifierFinder().find(signatureAlgorithm);
            AlgorithmIdentifier digAlgId = new DefaultDigestAlgorithmIdentifierFinder().find(sigAlgId);
            ContentSigner signer = new BcRSAContentSignerBuilder(sigAlgId, digAlgId).build(keyPair.getPrivate());
            return builder.build(signer).toASN1Structure();
        }
        catch (Throwable t) {
            if (t instanceof ThreadDeath) {
                throw (ThreadDeath)t;
            }
            logger.error((Object)"Failed to generate self-signed X.509 certificate", t);
            if (t instanceof RuntimeException) {
                throw (RuntimeException)t;
            }
            throw new RuntimeException(t);
        }
    }

    private static String toHex(byte[] fingerprint) {
        if (fingerprint.length == 0) {
            throw new IllegalArgumentException("fingerprint");
        }
        char[] chars = new char[3 * fingerprint.length - 1];
        int fLast = fingerprint.length - 1;
        int c = 0;
        for (int f = 0; f <= fLast; ++f) {
            int b = fingerprint[f] & 0xFF;
            chars[c++] = HEX_ENCODE_TABLE[b >>> 4];
            chars[c++] = HEX_ENCODE_TABLE[b & 0xF];
            if (f == fLast) continue;
            chars[c++] = 58;
        }
        return new String(chars);
    }

    public DtlsControlImpl() {
        this(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DtlsControlImpl(boolean srtpDisabled) {
        super(SrtpControlType.DTLS_SRTP);
        Class<DtlsControlImpl> clazz = DtlsControlImpl.class;
        synchronized (DtlsControlImpl.class) {
            CertificateInfo certificateInfo = certificateInfoCache;
            if (certificateInfo == null || certificateInfo.timestamp + CERT_CACHE_EXPIRE_TIME < System.currentTimeMillis()) {
                certificateInfoCache = certificateInfo = DtlsControlImpl.generateCertificateInfo();
            }
            // ** MonitorExit[var3_2] (shouldn't be in output)
            this.certificateInfo = certificateInfo;
            this.properties = new Properties(srtpDisabled);
            return;
        }
    }

    @Override
    protected DtlsTransformEngine createTransformEngine() {
        return new DtlsTransformEngine(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void doCleanup() {
        super.doCleanup();
        this.setConnector(null);
        DtlsControlImpl dtlsControlImpl = this;
        synchronized (dtlsControlImpl) {
            this.disposed = true;
            this.notifyAll();
        }
    }

    CertificateInfo getCertificateInfo() {
        return this.certificateInfo;
    }

    @Override
    public String getLocalFingerprint() {
        return this.getCertificateInfo().localFingerprint;
    }

    @Override
    public String getLocalFingerprintHashFunction() {
        return this.getCertificateInfo().localFingerprintHashFunction;
    }

    Properties getProperties() {
        return this.properties;
    }

    @Override
    public boolean getSecureCommunicationStatus() {
        return false;
    }

    public DtlsControl.Setup getSetup() {
        return this.getProperties().getSetup();
    }

    @Override
    public boolean requiresSecureSignalingTransport() {
        return true;
    }

    @Override
    public void setConnector(AbstractRTPConnector connector) {
        this.properties.put(Properties.CONNECTOR_PNAME, connector);
    }

    @Override
    public void setRemoteFingerprints(Map<String, String> remoteFingerprints) {
        if (remoteFingerprints == null) {
            throw new NullPointerException("remoteFingerprints");
        }
        HashMap<String, String> rfs = new HashMap<String, String>(remoteFingerprints.size());
        for (Map.Entry<String, String> e : remoteFingerprints.entrySet()) {
            String v;
            String k = e.getKey();
            if (k == null || (v = e.getValue()) == null) continue;
            rfs.put(k.toLowerCase(), v);
        }
        this.remoteFingerprints = rfs;
    }

    @Override
    public void setRtcpmux(boolean rtcpmux) {
        this.properties.put(Properties.RTCPMUX_PNAME, rtcpmux);
    }

    @Override
    public void setSetup(DtlsControl.Setup setup) {
        this.properties.put(Properties.SETUP_PNAME, (Object)setup);
    }

    @Override
    public void start(MediaType mediaType) {
        this.properties.put(Properties.MEDIA_TYPE_PNAME, mediaType);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void verifyAndValidateCertificate(Certificate certificate) throws Exception {
        String remoteFingerprint;
        String hashFunction = DtlsControlImpl.findHashFunction(certificate);
        DtlsControlImpl dtlsControlImpl = this;
        synchronized (dtlsControlImpl) {
            String hashFunctionUpgrade;
            if (this.disposed) {
                throw new IllegalStateException("disposed");
            }
            Map<String, String> remoteFingerprints = this.remoteFingerprints;
            if (remoteFingerprints == null) {
                throw new IOException("No fingerprints declared over the signaling path!");
            }
            remoteFingerprint = remoteFingerprints.get(hashFunction);
            if (remoteFingerprint == null && (hashFunctionUpgrade = DtlsControlImpl.findHashFunctionUpgrade(hashFunction, remoteFingerprints)) != null && !hashFunctionUpgrade.equalsIgnoreCase(hashFunction) && (remoteFingerprint = remoteFingerprints.get(hashFunctionUpgrade)) != null) {
                hashFunction = hashFunctionUpgrade;
            }
        }
        if (remoteFingerprint == null) {
            throw new IOException("No fingerprint declared over the signaling path with hash function: " + hashFunction + "!");
        }
        String fingerprint = DtlsControlImpl.computeFingerprint(certificate, hashFunction);
        if (remoteFingerprint.equals(fingerprint)) {
            if (logger.isTraceEnabled()) {
                logger.trace((Object)("Fingerprint " + remoteFingerprint + " matches the " + hashFunction + "-hashed certificate."));
            }
        } else {
            throw new IOException("Fingerprint " + remoteFingerprint + " does not match the " + hashFunction + "-hashed certificate " + fingerprint + "!");
        }
    }

    boolean verifyAndValidateCertificate(org.bouncycastle.crypto.tls.Certificate certificate) throws Exception {
        boolean b = false;
        try {
            Certificate[] certificateList = certificate.getCertificateList();
            if (certificateList.length == 0) {
                throw new IllegalArgumentException("certificate.certificateList");
            }
            for (Certificate x509Certificate : certificateList) {
                this.verifyAndValidateCertificate(x509Certificate);
            }
            b = true;
        }
        catch (Exception e) {
            String message = "Failed to verify and/or validate a certificate offered over the media path against fingerprints declared over the signaling path!";
            String throwableMessage = e.getMessage();
            if (VERIFY_AND_VALIDATE_CERTIFICATE) {
                if (throwableMessage == null || throwableMessage.length() == 0) {
                    logger.error((Object)message, (Throwable)e);
                } else {
                    logger.error((Object)(message + " " + throwableMessage));
                }
                throw e;
            }
            if (throwableMessage == null || throwableMessage.length() == 0) {
                logger.warn((Object)message, (Throwable)e);
            }
            logger.warn((Object)(message + " " + throwableMessage));
        }
        return b;
    }

    static {
        RSA_KEY_PUBLIC_EXPONENT = new BigInteger("10001", 16);
        SRTP_PROTECTION_PROFILES = new int[]{1, 2};
        VERIFY_AND_VALIDATE_CERTIFICATE_PNAME = DtlsControlImpl.class.getName() + ".verifyAndValidateCertificate";
        VERIFY_AND_VALIDATE_CERTIFICATE = ConfigUtils.getBoolean((ConfigurationService)LibJitsi.getConfigurationService(), (String)VERIFY_AND_VALIDATE_CERTIFICATE_PNAME, (boolean)true);
        RSA_KEY_SIZE = ConfigUtils.getInt((ConfigurationService)LibJitsi.getConfigurationService(), (String)RSA_KEY_SIZE_PNAME, (int)1024);
        RSA_KEY_SIZE_CERTAINTY = ConfigUtils.getInt((ConfigurationService)LibJitsi.getConfigurationService(), (String)RSA_KEY_SIZE_CERTAINTY_PNAME, (int)80);
        CERT_CACHE_EXPIRE_TIME = ConfigUtils.getLong((ConfigurationService)LibJitsi.getConfigurationService(), (String)CERT_CACHE_EXPIRE_TIME_PNAME, (long)86400000L);
        HASH_FUNCTION_UPGRADES.put("sha-1", new String[]{"sha-224", "sha-256", "sha-384", "sha-512"});
    }
}

