/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.impl.neomedia.transform.srtp;

import java.lang.reflect.Constructor;
import java.security.Provider;
import java.util.Random;
import org.bouncycastle.crypto.BlockCipher;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.engines.AESFastEngine;
import org.bouncycastle.crypto.params.KeyParameter;
import org.jitsi.impl.neomedia.transform.srtp.BlockCipherFactory;
import org.jitsi.impl.neomedia.transform.srtp.SecurityProviderBlockCipherFactory;
import org.jitsi.service.configuration.ConfigurationService;
import org.jitsi.service.libjitsi.LibJitsi;
import org.jitsi.utils.ConfigUtils;
import org.jitsi.utils.logging.Logger;

public class AES {
    private static final int BLOCK_SIZE = 16;
    private static final String BLOCK_CIPHER_FACTORY_SIMPLE_CLASS_NAME = "BlockCipherFactory";
    private static final BlockCipherFactory BOUNCYCASTLE_FACTORY = new BouncyCastleBlockCipherFactory();
    private static BlockCipherFactory[] factories;
    private static BlockCipherFactory factory;
    private static final String FACTORY_CLASS_NAME;
    private static final String FACTORY_CLASS_NAME_PNAME;
    private static final Class<?>[] FACTORY_CLASSES;
    public static final long FACTORY_TIMEOUT = 60000L;
    private static Class<? extends BlockCipherFactory> factoryClass;
    private static long factoryTimestamp;
    private static final byte[] in;
    private static final Logger logger;
    private static final byte[] out;
    private static final Random random;

    private static BlockCipherFactory benchmark(BlockCipherFactory[] factories, int keySize) {
        Random random = AES.random;
        byte[] key = new byte[keySize];
        byte[] in = AES.in;
        random.nextBytes(key);
        random.nextBytes(in);
        KeyParameter params = new KeyParameter(key);
        int blockSize = 16;
        int inEnd = in.length - blockSize + 1;
        byte[] out = AES.out;
        long minTime = Long.MAX_VALUE;
        BlockCipherFactory minFactory = null;
        StringBuilder log = new StringBuilder();
        for (int f = 0; f < factories.length; ++f) {
            BlockCipherFactory factory = factories[f];
            if (factory == null) continue;
            try {
                BlockCipher cipher = factory.createBlockCipher(keySize);
                if (cipher == null) {
                    factories[f] = null;
                    continue;
                }
                cipher.init(true, (CipherParameters)params);
                long startTime = System.nanoTime();
                for (int inOff = 0; inOff < inEnd; inOff += blockSize) {
                    cipher.processBlock(in, inOff, out, 0);
                }
                long endTime = System.nanoTime();
                long time = endTime - startTime;
                if (time < minTime) {
                    minTime = time;
                    minFactory = factory;
                }
                if (log.length() != 0) {
                    log.append(", ");
                }
                log.append(AES.getSimpleClassName(factory)).append(' ').append(time);
                continue;
            }
            catch (Throwable t) {
                if (t instanceof InterruptedException) {
                    Thread.currentThread().interrupt();
                    continue;
                }
                if (!(t instanceof ThreadDeath)) continue;
                throw (ThreadDeath)t;
            }
        }
        if (log.length() != 0) {
            logger.info((Object)("AES benchmark (of execution times expressed in nanoseconds): " + log));
        }
        return minFactory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static BlockCipher createBlockCipher(int keySize) {
        Class<AES> clazz = AES.class;
        synchronized (AES.class) {
            long now = System.currentTimeMillis();
            BlockCipherFactory factory = AES.factory;
            if (factory != null && now > factoryTimestamp + 60000L) {
                factory = null;
            }
            if (factory == null) {
                try {
                    factory = AES.getBlockCipherFactory(keySize);
                }
                catch (Throwable t) {
                    if (t instanceof InterruptedException) {
                        Thread.currentThread().interrupt();
                    } else {
                        if (t instanceof ThreadDeath) {
                            throw (ThreadDeath)t;
                        }
                        logger.warn((Object)("Failed to initialize an optimized AES implementation: " + t.getLocalizedMessage()));
                    }
                }
                finally {
                    if (factory == null && (factory = AES.factory) == null) {
                        factory = BOUNCYCASTLE_FACTORY;
                    }
                    factoryTimestamp = now;
                    if (AES.factory != factory) {
                        AES.factory = factory;
                        logger.info((Object)("Will employ AES implemented by " + AES.getSimpleClassName(factory) + "."));
                    }
                }
            }
            // ** MonitorExit[var2_1] (shouldn't be in output)
            try {
                return factory.createBlockCipher(keySize);
            }
            catch (Exception ex) {
                if (ex instanceof RuntimeException) {
                    throw (RuntimeException)ex;
                }
                throw new RuntimeException(ex);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private static BlockCipherFactory[] createBlockCipherFactories() {
        String string;
        Class<BlockCipherFactory> factoryClass = AES.factoryClass;
        Class<?>[] factoryClasses = FACTORY_CLASSES;
        boolean add = true;
        if (factoryClass == null && (string = FACTORY_CLASS_NAME) != null && string.length() != 0) {
            void var3_5;
            if (Character.isUpperCase(string.charAt(0)) && !string.contains(".") && !string.endsWith(BLOCK_CIPHER_FACTORY_SIMPLE_CLASS_NAME)) {
                String string2 = AES.class.getName() + "$" + string + BLOCK_CIPHER_FACTORY_SIMPLE_CLASS_NAME;
            }
            Class<?>[] classArray = factoryClasses;
            int n = classArray.length;
            for (int i = 0; i < n; ++i) {
                Class<?> clazz = classArray[i];
                if (clazz == null || !clazz.getName().equals(var3_5) || !BlockCipherFactory.class.isAssignableFrom(clazz)) continue;
                AES.factoryClass = factoryClass = clazz;
                add = false;
                break;
            }
            if (add) {
                try {
                    Class<?> clazz = Class.forName((String)var3_5);
                    if (BlockCipherFactory.class.isAssignableFrom(clazz)) {
                        AES.factoryClass = factoryClass = clazz;
                    }
                }
                catch (Throwable t) {
                    if (t instanceof InterruptedException) {
                        Thread.currentThread().interrupt();
                    }
                    if (t instanceof ThreadDeath) {
                        throw (ThreadDeath)t;
                    }
                    logger.warn((Object)("Failed to employ class " + (String)var3_5 + " as an AES implementation: " + t.getLocalizedMessage()));
                }
            }
        }
        if (add && factoryClass != null) {
            for (Class<?> clazz : factoryClasses) {
                if (!factoryClass.equals(clazz)) continue;
                add = false;
                break;
            }
            if (add) {
                Class[] classArray = new Class[1 + factoryClasses.length];
                classArray[0] = factoryClass;
                System.arraycopy(factoryClasses, 0, classArray, 1, factoryClasses.length);
                factoryClasses = classArray;
            }
        }
        return AES.createBlockCipherFactories(factoryClasses);
    }

    private static BlockCipherFactory[] createBlockCipherFactories(Class<?>[] classes) {
        BlockCipherFactory[] factories = new BlockCipherFactory[classes.length];
        int i = 0;
        for (Class<?> clazz : classes) {
            try {
                if (!BlockCipherFactory.class.isAssignableFrom(clazz)) continue;
                BlockCipherFactory factory = BouncyCastleBlockCipherFactory.class.equals(clazz) ? BOUNCYCASTLE_FACTORY : (BlockCipherFactory)clazz.newInstance();
                factories[i++] = factory;
            }
            catch (Throwable t) {
                if (t instanceof InterruptedException) {
                    Thread.currentThread().interrupt();
                    continue;
                }
                if (!(t instanceof ThreadDeath)) continue;
                throw (ThreadDeath)t;
            }
        }
        return factories;
    }

    private static BlockCipherFactory getBlockCipherFactory(int keySize) {
        BlockCipherFactory[] factories = AES.factories;
        if (factories == null) {
            factories = AES.createBlockCipherFactories();
            AES.factories = factories;
        }
        BlockCipherFactory minFactory = AES.benchmark(factories, keySize);
        Class<? extends BlockCipherFactory> factoryClass = AES.factoryClass;
        if (factoryClass != null) {
            for (BlockCipherFactory factory : factories) {
                if (factory == null || !factory.getClass().equals(factoryClass)) continue;
                minFactory = factory;
                break;
            }
        }
        return minFactory;
    }

    private static String getSimpleClassName(BlockCipherFactory factory) {
        String suffix;
        Class<?> clazz = factory.getClass();
        String className = clazz.getSimpleName();
        if (className == null || className.length() == 0) {
            className = clazz.getName();
        }
        if (className.endsWith(suffix = BLOCK_CIPHER_FACTORY_SIMPLE_CLASS_NAME)) {
            String prefix;
            String simpleClassName = className.substring(0, className.length() - suffix.length());
            if (simpleClassName.startsWith(prefix = AES.class.getName() + "$")) {
                className = simpleClassName.substring(prefix.length());
            } else if (simpleClassName.contains(".")) {
                Package pkg = AES.class.getPackage();
                if (pkg != null && simpleClassName.startsWith(prefix = pkg.getName() + ".")) {
                    className = simpleClassName.substring(prefix.length());
                }
            } else {
                className = simpleClassName;
            }
        }
        return className;
    }

    static {
        FACTORY_CLASS_NAME_PNAME = AES.class.getName() + ".factoryClassName";
        FACTORY_CLASSES = new Class[]{BouncyCastleBlockCipherFactory.class, SunJCEBlockCipherFactory.class, SunPKCS11BlockCipherFactory.class};
        in = new byte[16384];
        logger = Logger.getLogger(AES.class);
        out = new byte[16];
        random = new Random();
        ConfigurationService cfg = LibJitsi.getConfigurationService();
        FACTORY_CLASS_NAME = ConfigUtils.getString((ConfigurationService)cfg, (String)FACTORY_CLASS_NAME_PNAME, null);
    }

    public static class SunPKCS11BlockCipherFactory
    extends SecurityProviderBlockCipherFactory {
        private static Provider provider;
        private static boolean useProvider;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private static synchronized Provider getProvider() throws Exception {
            Provider provider = SunPKCS11BlockCipherFactory.provider;
            if (provider == null && useProvider) {
                try {
                    Class<?> clazz = Class.forName("sun.security.pkcs11.SunPKCS11");
                    if (Provider.class.isAssignableFrom(clazz)) {
                        Constructor<?> contructor = clazz.getConstructor(String.class);
                        String name = null;
                        Package pkg = AES.class.getPackage();
                        if (pkg != null) {
                            name = pkg.getName();
                        }
                        if (name == null || name.length() == 0) {
                            name = "org.jitsi.impl.neomedia.transform.srtp";
                        }
                        provider = (Provider)contructor.newInstance("--name=" + name + "\\nnssDbMode=noDb\\nattributes=compatibility");
                    }
                }
                finally {
                    if (provider == null) {
                        useProvider = false;
                    } else {
                        SunPKCS11BlockCipherFactory.provider = provider;
                    }
                }
            }
            return provider;
        }

        public SunPKCS11BlockCipherFactory() throws Exception {
            super("AES_<size>/ECB/NoPadding", SunPKCS11BlockCipherFactory.getProvider());
        }

        static {
            useProvider = true;
        }
    }

    public static class SunJCEBlockCipherFactory
    extends SecurityProviderBlockCipherFactory {
        public SunJCEBlockCipherFactory() {
            super("AES_<size>/ECB/NoPadding", "SunJCE");
        }
    }

    public static class BouncyCastleBlockCipherFactory
    implements BlockCipherFactory {
        @Override
        public BlockCipher createBlockCipher(int keySize) throws Exception {
            return new AESFastEngine();
        }
    }
}

