/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.service.neomedia;

import java.util.Objects;
import org.jitsi.utils.ByteArrayBuffer;

public class ByteArrayBufferImpl
implements ByteArrayBuffer {
    protected byte[] buffer;
    private int offset;
    private int length;

    public ByteArrayBufferImpl(byte[] buffer, int offset, int length) {
        this.buffer = Objects.requireNonNull(buffer, "buffer");
        if (offset + length > buffer.length || length < 0 || offset < 0) {
            throw new IllegalArgumentException("length or offset");
        }
        this.offset = offset;
        this.length = length;
    }

    public ByteArrayBufferImpl(int size) {
        if (size < 0) {
            throw new IllegalArgumentException("size");
        }
        this.buffer = new byte[size];
        this.offset = 0;
        this.length = size;
    }

    public ByteArrayBufferImpl(byte[] buf) {
        this(buf, 0, buf.length);
    }

    public byte[] getBuffer() {
        return this.buffer;
    }

    public int getOffset() {
        return this.offset;
    }

    public int getLength() {
        return this.length;
    }

    public void setLength(int length) {
        if (this.offset + length > this.buffer.length || length < 0) {
            throw new IllegalArgumentException("length");
        }
        this.length = length;
    }

    public void setOffset(int offset) {
        if (offset + this.length > this.buffer.length || offset < 0) {
            throw new IllegalArgumentException("offset");
        }
        this.offset = offset;
    }

    public void setOffsetLength(int offset, int length) {
        if (offset + length > this.buffer.length || length < 0 || offset < 0) {
            throw new IllegalArgumentException("length or offset");
        }
        this.offset = offset;
        this.length = length;
    }

    public boolean isInvalid() {
        return false;
    }

    public void readRegionToBuff(int off, int len, byte[] outBuff) {
        int startOffset = this.offset + off;
        if (off < 0 || len <= 0 || startOffset + len > this.buffer.length) {
            return;
        }
        if (outBuff.length < len) {
            return;
        }
        System.arraycopy(this.buffer, startOffset, outBuff, 0, len);
    }

    public void grow(int howMuch) {
        if (howMuch < 0) {
            throw new IllegalArgumentException("howMuch");
        }
        int newLength = this.length + howMuch;
        if (newLength > this.buffer.length - this.offset) {
            byte[] newBuffer = new byte[newLength];
            System.arraycopy(this.buffer, this.offset, newBuffer, 0, this.length);
            this.offset = 0;
            this.buffer = newBuffer;
        }
    }

    public void append(byte[] data, int len) {
        if (data == null || len == 0) {
            return;
        }
        this.grow(len);
        System.arraycopy(data, 0, this.buffer, this.length + this.offset, len);
        this.length += len;
    }

    public void shrink(int len) {
        if (len <= 0) {
            return;
        }
        this.length = Math.max(0, this.length - len);
    }
}

