/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.service.neomedia.codec;

import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.jitsi.service.neomedia.format.MediaFormat;
import org.jitsi.utils.MediaType;
import org.jitsi.utils.logging.Logger;

public abstract class EncodingConfiguration {
    private final Logger logger = Logger.getLogger(EncodingConfiguration.class);
    private final Comparator<MediaFormat> encodingComparator = new Comparator<MediaFormat>(){

        @Override
        public int compare(MediaFormat s1, MediaFormat s2) {
            return EncodingConfiguration.this.compareEncodingPreferences(s1, s2);
        }
    };
    protected final Map<String, Integer> encodingPreferences = new HashMap<String, Integer>();
    private Set<MediaFormat> supportedAudioEncodings;
    private Set<MediaFormat> supportedVideoEncodings;

    private void updateSupportedEncodings() {
        this.supportedAudioEncodings = null;
        this.supportedVideoEncodings = null;
    }

    private Set<MediaFormat> updateSupportedEncodings(MediaType type) {
        TreeSet<MediaFormat> enabled = new TreeSet<MediaFormat>(this.encodingComparator);
        for (MediaFormat format : this.getAllEncodings(type)) {
            if (this.getPriority(format) <= 0) continue;
            enabled.add(format);
        }
        return enabled;
    }

    protected abstract void setEncodingPreference(String var1, double var2, int var4);

    public void setPriority(MediaFormat encoding, int priority) {
        String encodingEncoding = encoding.getEncoding();
        this.setEncodingPreference(encodingEncoding, encoding.getClockRate(), priority);
        this.updateSupportedEncodings();
    }

    public int getPriority(MediaFormat encoding) {
        Integer priority = this.encodingPreferences.get(this.getEncodingPreferenceKey(encoding));
        return priority == null ? 0 : priority;
    }

    public abstract MediaFormat[] getAllEncodings(MediaType var1);

    public MediaFormat[] getEnabledEncodings(MediaType type) {
        Set<MediaFormat> supportedEncodings;
        switch (type) {
            case AUDIO: {
                if (this.supportedAudioEncodings == null) {
                    this.supportedAudioEncodings = this.updateSupportedEncodings(type);
                }
                supportedEncodings = this.supportedAudioEncodings;
                break;
            }
            case VIDEO: {
                if (this.supportedVideoEncodings == null) {
                    this.supportedVideoEncodings = this.updateSupportedEncodings(type);
                }
                supportedEncodings = this.supportedVideoEncodings;
                break;
            }
            default: {
                return new MediaFormat[0];
            }
        }
        return supportedEncodings.toArray(new MediaFormat[supportedEncodings.size()]);
    }

    protected abstract int compareEncodingPreferences(MediaFormat var1, MediaFormat var2);

    protected String getEncodingPreferenceKey(MediaFormat encoding) {
        return encoding.getEncoding() + "/" + encoding.getClockRateString();
    }

    public void storeProperties(Map<String, String> properties, String prefix) {
        for (MediaType mediaType : MediaType.values()) {
            for (MediaFormat mediaFormat : this.getAllEncodings(mediaType)) {
                properties.put(prefix + this.getEncodingPreferenceKey(mediaFormat), Integer.toString(this.getPriority(mediaFormat)));
            }
        }
    }

    public void storeProperties(Map<String, String> properties) {
        this.storeProperties(properties, "");
    }

    public void loadProperties(Map<String, String> properties) {
        this.loadProperties(properties, "");
    }

    public void loadProperties(Map<String, String> properties, String prefix) {
        for (Map.Entry<String, String> entry : properties.entrySet()) {
            double clockRate;
            String encoding;
            String pName = entry.getKey();
            String prefStr = entry.getValue();
            if (!pName.startsWith(prefix)) continue;
            String fmtName = pName.contains(".") ? pName.substring(pName.lastIndexOf(46) + 1) : pName;
            if (fmtName.contains("sdp")) {
                fmtName = fmtName.replaceAll("sdp", "");
                if (properties.containsKey(pName.replaceAll("sdp", ""))) continue;
            }
            int preference = -1;
            try {
                preference = Integer.parseInt(prefStr);
                int encodingClockRateSeparator = fmtName.lastIndexOf(47);
                if (encodingClockRateSeparator > -1) {
                    encoding = fmtName.substring(0, encodingClockRateSeparator);
                    clockRate = Double.parseDouble(fmtName.substring(encodingClockRateSeparator + 1));
                } else {
                    encoding = fmtName;
                    clockRate = -1.0;
                }
            }
            catch (NumberFormatException nfe) {
                this.logger.warn((Object)("Failed to parse format (" + fmtName + ") or preference (" + prefStr + ")."), (Throwable)nfe);
                continue;
            }
            this.setEncodingPreference(encoding, clockRate, preference);
        }
        this.updateSupportedEncodings();
    }

    public void loadEncodingConfiguration(EncodingConfiguration encodingConfiguration) {
        HashMap<String, String> properties = new HashMap<String, String>();
        encodingConfiguration.storeProperties(properties);
        this.loadProperties(properties);
    }

    public boolean hasEnabledFormat(MediaType mediaType) {
        return this.getEnabledEncodings(mediaType).length > 0;
    }
}

