/*
 * Decompiled with CFR 0.152.
 */
package net.kano.joscar.flap;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import net.kano.joscar.BinaryTools;
import net.kano.joscar.ByteBlock;
import net.kano.joscar.DefensiveTools;
import net.kano.joscar.LiveWritable;
import net.kano.joscar.flap.FlapCommand;
import net.kano.joscar.flap.FlapDataLengthException;
import net.kano.joscar.flap.FlapHeader;
import org.jetbrains.annotations.Nullable;

public final class FlapPacket
implements LiveWritable {
    public static final int CHANNEL_LOGIN = 1;
    public static final int CHANNEL_SNAC = 2;
    public static final int CHANNEL_ERROR = 3;
    public static final int CHANNEL_CLOSE = 4;
    public static final int MAX_DATA_LEN = 65535;
    private final int seqnum;
    private final int channel;
    private ByteBlock block = null;
    private final FlapCommand command;

    @Nullable
    static FlapPacket readRestOfFlap(FlapHeader header, InputStream in) throws IOException {
        int count;
        DefensiveTools.checkNull(header, "header");
        DefensiveTools.checkNull(in, "in");
        byte[] data = new byte[header.getDataLength()];
        for (int pos = 0; pos < data.length; pos += count) {
            count = in.read(data, pos, data.length - pos);
            if (count != -1) continue;
            return null;
        }
        return new FlapPacket(header, ByteBlock.wrap(data));
    }

    FlapPacket(FlapHeader header, ByteBlock data) throws IllegalArgumentException {
        DefensiveTools.checkNull(header, "header");
        DefensiveTools.checkNull(data, "data");
        if (header.getDataLength() != data.getLength()) {
            throw new IllegalArgumentException("FLAP data length (" + data.getLength() + ") does not agree with header (" + header.getDataLength() + ")");
        }
        this.channel = header.getChannel();
        this.seqnum = header.getSeqnum();
        this.block = data;
        this.command = null;
    }

    FlapPacket(int seqnum, FlapCommand command) {
        DefensiveTools.checkNull(command, "command");
        this.seqnum = seqnum;
        this.channel = command.getChannel();
        this.block = null;
        this.command = command;
    }

    public final int getSeqnum() {
        return this.seqnum;
    }

    public final int getChannel() {
        return this.channel;
    }

    public final synchronized ByteBlock getData() {
        return this.block;
    }

    public synchronized void write(OutputStream out) throws FlapDataLengthException, IOException {
        int len;
        if (this.block == null) {
            ByteArrayOutputStream tmp = new ByteArrayOutputStream();
            try {
                this.command.writeData(tmp);
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.block = ByteBlock.wrap(tmp.toByteArray());
        }
        if ((len = (int)this.block.getWritableLength()) > 65535) {
            throw new FlapDataLengthException("data length (" + len + ") must " + "be <= " + 65535);
        }
        BinaryTools.writeUByte(out, 42);
        BinaryTools.writeUByte(out, this.channel);
        BinaryTools.writeUShort(out, this.seqnum);
        BinaryTools.writeUShort(out, len);
        this.block.write(out);
    }

    public String toString() {
        return "FlapPacket (channel=" + this.channel + ", seq=" + this.seqnum + ")";
    }
}

