/*
 * Decompiled with CFR 0.152.
 */
package org.xmpp.jnodes;

import java.io.IOException;
import java.net.BindException;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.nio.ByteBuffer;
import org.xmpp.jnodes.nio.DatagramListener;
import org.xmpp.jnodes.nio.SelDatagramChannel;

public class RelayChannel {
    private final SelDatagramChannel channelA;
    private final SelDatagramChannel channelB;
    private final SocketAddress addressA;
    private final SocketAddress addressB;
    private SocketAddress lastReceivedA;
    private SocketAddress lastReceivedB;
    private final SelDatagramChannel channelA_;
    private final SelDatagramChannel channelB_;
    private SocketAddress lastReceivedA_;
    private SocketAddress lastReceivedB_;
    private long lastReceivedTimeA;
    private long lastReceivedTimeB;
    private final int portA;
    private final int portB;
    private final String ip;
    private Object attachment;

    public static RelayChannel createLocalRelayChannel(String host, int minPort, int maxPort) throws IOException {
        int range = maxPort - minPort;
        IOException be = null;
        int t = 0;
        while (t < 50) {
            try {
                int a = Math.round((int)(Math.random() * (double)range)) + minPort;
                a = a % 2 == 0 ? a : a + 1;
                return new RelayChannel(host, a);
            }
            catch (BindException e) {
                be = e;
            }
            catch (IOException e) {
                be = e;
            }
            ++t;
        }
        throw be;
    }

    public RelayChannel(String host, int portA) throws IOException {
        int portB = portA + 2;
        this.addressA = new InetSocketAddress(host, portA);
        this.addressB = new InetSocketAddress(host, portB);
        this.channelA = SelDatagramChannel.open(null, this.addressA);
        this.channelB = SelDatagramChannel.open(null, this.addressB);
        this.channelA.setDatagramListener(new DatagramListener(){

            @Override
            public void datagramReceived(SelDatagramChannel channel, ByteBuffer buffer, SocketAddress address) {
                RelayChannel.this.lastReceivedA = address;
                RelayChannel.this.lastReceivedTimeA = System.currentTimeMillis();
                if (RelayChannel.this.lastReceivedB != null) {
                    try {
                        buffer.flip();
                        RelayChannel.this.channelB.send(buffer, RelayChannel.this.lastReceivedB);
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }
        });
        this.channelB.setDatagramListener(new DatagramListener(){

            @Override
            public void datagramReceived(SelDatagramChannel channel, ByteBuffer buffer, SocketAddress address) {
                RelayChannel.this.lastReceivedB = address;
                RelayChannel.this.lastReceivedTimeB = System.currentTimeMillis();
                if (RelayChannel.this.lastReceivedA != null) {
                    try {
                        buffer.flip();
                        RelayChannel.this.channelA.send(buffer, RelayChannel.this.lastReceivedA);
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }
        });
        this.portA = portA;
        this.portB = portB;
        InetSocketAddress addressA_ = new InetSocketAddress(host, portA + 1);
        InetSocketAddress addressB_ = new InetSocketAddress(host, portB + 1);
        this.channelA_ = SelDatagramChannel.open(null, addressA_);
        this.channelB_ = SelDatagramChannel.open(null, addressB_);
        this.channelA_.setDatagramListener(new DatagramListener(){

            @Override
            public void datagramReceived(SelDatagramChannel channel, ByteBuffer buffer, SocketAddress address) {
                RelayChannel.this.lastReceivedA_ = address;
                if (RelayChannel.this.lastReceivedB_ != null) {
                    try {
                        buffer.flip();
                        RelayChannel.this.channelB_.send(buffer, RelayChannel.this.lastReceivedB_);
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }
        });
        this.channelB_.setDatagramListener(new DatagramListener(){

            @Override
            public void datagramReceived(SelDatagramChannel channel, ByteBuffer buffer, SocketAddress address) {
                RelayChannel.this.lastReceivedB_ = address;
                if (RelayChannel.this.lastReceivedA_ != null) {
                    try {
                        buffer.flip();
                        RelayChannel.this.channelA_.send(buffer, RelayChannel.this.lastReceivedA_);
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }
        });
        this.ip = host;
    }

    public SocketAddress getAddressB() {
        return this.addressB;
    }

    public SocketAddress getAddressA() {
        return this.addressA;
    }

    public int getPortA() {
        return this.portA;
    }

    public int getPortB() {
        return this.portB;
    }

    public String getIp() {
        return this.ip;
    }

    public long getLastReceivedTimeA() {
        return this.lastReceivedTimeA;
    }

    public long getLastReceivedTimeB() {
        return this.lastReceivedTimeB;
    }

    public Object getAttachment() {
        return this.attachment;
    }

    public void setAttachment(Object attachment) {
        this.attachment = attachment;
    }

    public void close() {
        try {
            this.channelA.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        try {
            this.channelB.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        try {
            this.channelA_.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        try {
            this.channelB_.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public SelDatagramChannel getChannelA() {
        return this.channelA;
    }

    public SelDatagramChannel getChannelB() {
        return this.channelB;
    }

    public SelDatagramChannel getChannelA_() {
        return this.channelA_;
    }

    public SelDatagramChannel getChannelB_() {
        return this.channelB_;
    }
}

