/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.impl.protocol.mock;

import java.text.ParseException;
import java.util.Hashtable;
import java.util.Iterator;
import net.java.sip.communicator.impl.protocol.mock.MockCall;
import net.java.sip.communicator.impl.protocol.mock.MockCallPeer;
import net.java.sip.communicator.impl.protocol.mock.MockProvider;
import net.java.sip.communicator.service.protocol.Call;
import net.java.sip.communicator.service.protocol.CallConference;
import net.java.sip.communicator.service.protocol.CallPeer;
import net.java.sip.communicator.service.protocol.CallPeerState;
import net.java.sip.communicator.service.protocol.CallState;
import net.java.sip.communicator.service.protocol.Contact;
import net.java.sip.communicator.service.protocol.ContactResource;
import net.java.sip.communicator.service.protocol.OperationFailedException;
import net.java.sip.communicator.service.protocol.event.CallChangeEvent;
import net.java.sip.communicator.service.protocol.event.CallChangeListener;
import net.java.sip.communicator.service.protocol.event.CallPeerEvent;
import net.java.sip.communicator.service.protocol.media.AbstractOperationSetBasicTelephony;
import net.java.sip.communicator.util.Logger;

public class MockOperationSetBasicTelephony
extends AbstractOperationSetBasicTelephony<MockProvider>
implements CallChangeListener {
    private static final Logger logger = Logger.getLogger(MockOperationSetBasicTelephony.class);
    private MockProvider protocolProvider = null;
    private Hashtable<String, Call> activeCalls = new Hashtable();

    public MockOperationSetBasicTelephony(MockProvider protocolProvider) {
        this.protocolProvider = protocolProvider;
    }

    public void answerCallPeer(CallPeer peer) throws OperationFailedException {
        MockCallPeer callPeer = (MockCallPeer)peer;
        if (peer.getState().equals(CallPeerState.CONNECTED)) {
            if (logger.isInfoEnabled()) {
                logger.info((Object)("Ignoring user request to answer a CallPeer that is already connected. CP:" + peer));
            }
            return;
        }
        callPeer.setState(CallPeerState.CONNECTED, null);
    }

    public Call createCall(String callee, CallConference conference) throws OperationFailedException, ParseException {
        return this.createNewCall(callee);
    }

    public Call createCall(Contact callee, ContactResource calleeResource, CallConference conference) throws OperationFailedException {
        return this.createCall(callee, conference);
    }

    private Call createNewCall(String address) {
        MockCall newCall = new MockCall(this.protocolProvider);
        newCall.addCallChangeListener(this);
        this.activeCalls.put(newCall.getCallID(), (Call)newCall);
        new MockCallPeer(address, newCall);
        return newCall;
    }

    public Iterator<Call> getActiveCalls() {
        return this.activeCalls.values().iterator();
    }

    public void hangupCallPeer(CallPeer peer) throws OperationFailedException {
        if (peer.getState().equals(CallPeerState.DISCONNECTED)) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"Ignoring a request to hangup a call peer that is already DISCONNECTED");
            }
            return;
        }
        MockCallPeer callPeer = (MockCallPeer)peer;
        if (logger.isInfoEnabled()) {
            logger.info((Object)"hangupCallPeer");
        }
        callPeer.setState(CallPeerState.DISCONNECTED, null);
    }

    public void hangupCallPeer(CallPeer peer, int reasonCode, String reason) throws OperationFailedException {
        this.hangupCallPeer(peer);
    }

    public void putOffHold(CallPeer peer) {
    }

    public void putOnHold(CallPeer peer) throws OperationFailedException {
    }

    public Call receiveCall(String fromAddress) throws Exception {
        Call newCall = this.createCall(fromAddress);
        this.fireCallEvent(2, newCall);
        return newCall;
    }

    public Call placeCall(String toAddress) throws Exception {
        Call newCall = this.createCall(toAddress);
        this.fireCallEvent(1, newCall);
        MockCallPeer callPArt = (MockCallPeer)((Object)newCall.getCallPeers().next());
        callPArt.setState(CallPeerState.ALERTING_REMOTE_SIDE, "no reason");
        callPArt.setState(CallPeerState.CONNECTED, "no reason");
        return newCall;
    }

    public CallPeer addNewCallPeer(Call call, String address) {
        MockCallPeer callPArt = new MockCallPeer(address, (MockCall)call);
        callPArt.setState(CallPeerState.ALERTING_REMOTE_SIDE, "no reason");
        callPArt.setState(CallPeerState.CONNECTED, "no reason");
        return callPArt;
    }

    public void callPeerAdded(CallPeerEvent evt) {
    }

    public void callPeerRemoved(CallPeerEvent evt) {
    }

    public void callStateChanged(CallChangeEvent evt) {
        if (evt.getEventType().equals("CallState") && evt.getNewValue().equals(CallState.CALL_ENDED)) {
            MockCall sourceCall = (MockCall)this.activeCalls.remove(evt.getSourceCall().getCallID());
            if (logger.isTraceEnabled()) {
                logger.trace((Object)("Removing call " + (Object)((Object)sourceCall) + " from the list of active calls because it entered an ENDED state"));
            }
            this.fireCallEvent(3, (Call)sourceCall);
        }
    }

    public MockProvider getProtocolProvider() {
        return this.protocolProvider;
    }
}

