/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.impl.protocol.mock;

import java.util.Iterator;
import net.java.sip.communicator.impl.protocol.mock.MockContact;
import net.java.sip.communicator.impl.protocol.mock.MockContactGroup;
import net.java.sip.communicator.impl.protocol.mock.MockProvider;
import net.java.sip.communicator.impl.protocol.mock.MockStatusEnum;
import net.java.sip.communicator.service.protocol.AbstractOperationSetPersistentPresence;
import net.java.sip.communicator.service.protocol.AuthorizationHandler;
import net.java.sip.communicator.service.protocol.Contact;
import net.java.sip.communicator.service.protocol.ContactGroup;
import net.java.sip.communicator.service.protocol.OperationFailedException;
import net.java.sip.communicator.service.protocol.PresenceStatus;
import net.java.sip.communicator.service.protocol.ProtocolProviderService;

public class MockPersistentPresenceOperationSet
extends AbstractOperationSetPersistentPresence<MockProvider> {
    private MockContactGroup contactListRoot = null;
    private String statusMessage = "Default Status Message";
    private PresenceStatus presenceStatus = MockStatusEnum.MOCK_STATUS_50;

    public MockPersistentPresenceOperationSet(MockProvider provider) {
        super((ProtocolProviderService)provider);
        this.contactListRoot = new MockContactGroup("RootMockGroup", provider);
    }

    public void createServerStoredContactGroup(ContactGroup parent, String groupName) {
        MockContactGroup newGroup = new MockContactGroup(groupName, (MockProvider)this.parentProvider);
        ((MockContactGroup)parent).addSubgroup(newGroup);
        this.fireServerStoredGroupEvent(newGroup, 1);
    }

    public void addMockGroup(MockContactGroup contactGroup) {
        this.contactListRoot.addSubgroup(contactGroup);
    }

    public void addMockGroupAndFireEvent(MockContactGroup parent, MockContactGroup contactGroup) {
        parent.addSubgroup(contactGroup);
        this.fireServerStoredGroupEvent(contactGroup, 1);
    }

    public Contact findContactByID(String contactID) {
        return this.contactListRoot.findContactByID(contactID);
    }

    public void setStatusMessage(String statusMessage) {
        this.statusMessage = statusMessage;
    }

    public String getCurrentStatusMessage() {
        return this.statusMessage;
    }

    public Contact getLocalContact() {
        return null;
    }

    public PresenceStatus getPresenceStatus() {
        return this.presenceStatus;
    }

    public ContactGroup getServerStoredContactListRoot() {
        return this.contactListRoot;
    }

    public Iterator<PresenceStatus> getSupportedStatusSet() {
        return MockStatusEnum.supportedStatusSet();
    }

    public void moveContactToGroup(Contact contactToMove, ContactGroup newParent) {
        MockContact mockContact = (MockContact)contactToMove;
        MockContactGroup parentMockGroup = this.findContactParent(mockContact);
        parentMockGroup.removeContact(mockContact);
        ((MockContactGroup)newParent).addContact(mockContact);
    }

    public void publishPresenceStatus(PresenceStatus status, String statusMessage) throws IllegalArgumentException, IllegalStateException, OperationFailedException {
        PresenceStatus oldPresenceStatus = this.presenceStatus;
        this.presenceStatus = status;
        this.statusMessage = statusMessage;
        this.fireProviderStatusChangeEvent(oldPresenceStatus);
    }

    public PresenceStatus queryContactStatus(String contactIdentifier) throws IllegalArgumentException, IllegalStateException, OperationFailedException {
        return this.findContactByID(contactIdentifier).getPresenceStatus();
    }

    public void changePresenceStatusForContact(MockContact contact, MockStatusEnum newStatus) {
        PresenceStatus oldStatus = contact.getPresenceStatus();
        contact.setPresenceStatus(newStatus);
        this.fireContactPresenceStatusChangeEvent((Contact)contact, this.findContactParent(contact), oldStatus);
    }

    public MockContactGroup findGroupParent(MockContactGroup mockGroup) {
        return this.contactListRoot.findGroupParent(mockGroup);
    }

    public MockContactGroup findContactParent(MockContact mockContact) {
        return (MockContactGroup)mockContact.getParentContactGroup();
    }

    public void removeServerStoredContactGroup(ContactGroup group) throws IllegalArgumentException {
        MockContactGroup mockGroup = (MockContactGroup)group;
        MockContactGroup parent = this.findGroupParent(mockGroup);
        if (parent == null) {
            throw new IllegalArgumentException("group " + group + " does not seem to belong to this protocol's contact list.");
        }
        parent.removeSubGroup(mockGroup);
        this.fireServerStoredGroupEvent(mockGroup, 2);
    }

    public void renameServerStoredContactGroup(ContactGroup group, String newName) {
        ((MockContactGroup)group).setGroupName(newName);
        this.fireServerStoredGroupEvent(group, 3);
    }

    public void setAuthorizationHandler(AuthorizationHandler handler) {
    }

    public void subscribe(ContactGroup parent, String contactIdentifier) throws IllegalArgumentException, IllegalStateException, OperationFailedException {
        MockContact contact = new MockContact(contactIdentifier, (MockProvider)this.parentProvider);
        ((MockContactGroup)parent).addContact(contact);
        this.fireSubscriptionEvent((Contact)contact, parent, 1);
    }

    public void subscribe(String contactIdentifier) throws IllegalArgumentException, IllegalStateException, OperationFailedException {
        MockContact contact = new MockContact(contactIdentifier, (MockProvider)this.parentProvider);
        this.contactListRoot.addContact(contact);
        this.fireSubscriptionEvent((Contact)contact, this.contactListRoot, 1);
    }

    public void unsubscribe(Contact contact) throws IllegalArgumentException, IllegalStateException, OperationFailedException {
        MockContactGroup parentGroup = (MockContactGroup)contact.getParentContactGroup();
        parentGroup.removeContact((MockContact)contact);
        this.fireSubscriptionEvent(contact, contact.getParentContactGroup(), 2);
    }

    public Contact createUnresolvedContact(String address, String persistentData) {
        MockContact contact = new MockContact(address, (MockProvider)this.parentProvider);
        contact.setResolved(false);
        ((MockContactGroup)this.getServerStoredContactListRoot()).addContact(contact);
        this.fireSubscriptionEvent((Contact)contact, this.getServerStoredContactListRoot(), 1);
        return contact;
    }

    public Contact createUnresolvedContact(String address, String persistentData, ContactGroup parent) {
        MockContact contact = new MockContact(address, (MockProvider)this.parentProvider);
        contact.setResolved(false);
        ((MockContactGroup)parent).addContact(contact);
        this.fireSubscriptionEvent((Contact)contact, parent, 1);
        return contact;
    }

    public ContactGroup createUnresolvedContactGroup(String groupUID, String persistentData, ContactGroup parentGroup) {
        MockContactGroup newGroup = new MockContactGroup(MockContactGroup.createNameFromUID(groupUID), (MockProvider)this.parentProvider);
        newGroup.setResolved(false);
        if (parentGroup == null) {
            parentGroup = this.getServerStoredContactListRoot();
        }
        ((MockContactGroup)parentGroup).addSubgroup(newGroup);
        this.fireServerStoredGroupEvent(newGroup, 1);
        return newGroup;
    }

    public MockContact createVolatileContact(String id) {
        MockContact newVolatileContact = new MockContact(id, (MockProvider)this.parentProvider);
        newVolatileContact.setResolved(false);
        newVolatileContact.setPersistent(false);
        MockContactGroup theVolatileGroup = this.getNonPersistentGroup();
        if (theVolatileGroup == null) {
            theVolatileGroup = new MockContactGroup("Not-In-Contactlist", (MockProvider)this.parentProvider);
            theVolatileGroup.setResolved(false);
            theVolatileGroup.setPersistent(false);
            theVolatileGroup.addContact(newVolatileContact);
            this.contactListRoot.addSubgroup(theVolatileGroup);
            this.fireServerStoredGroupEvent(theVolatileGroup, 1);
        } else {
            theVolatileGroup.addContact(newVolatileContact);
            this.fireSubscriptionEvent((Contact)newVolatileContact, theVolatileGroup, 1);
        }
        return newVolatileContact;
    }

    public MockContactGroup getNonPersistentGroup() {
        String groupName = "Not-In-Contactlist";
        for (int i = 0; i < this.contactListRoot.countSubgroups(); ++i) {
            MockContactGroup gr = (MockContactGroup)this.contactListRoot.getGroup(i);
            if (gr.isPersistent() || !gr.getGroupName().equals(groupName)) continue;
            return gr;
        }
        return null;
    }
}

