/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.impl.configuration;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.SetMultimap;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.jitsi.service.configuration.ConfigVetoableChangeListener;
import org.jitsi.service.configuration.ConfigurationService;
import org.jitsi.service.fileaccess.FileAccessService;
import org.jitsi.service.fileaccess.FileCategory;
import org.jitsi.util.OSUtils;
import org.jitsi.utils.logging.Logger;

public final class JdbcConfigService
implements ConfigurationService {
    private final Logger logger = Logger.getLogger(JdbcConfigService.class);
    private static final String DEFAULT_PROPS_FILE_NAME = "jitsi-defaults.properties";
    private static final String DEFAULT_OVERRIDES_PROPS_FILE_NAME = "jitsi-default-overrides.properties";
    private Map<String, String> immutableDefaultProperties = new HashMap<String, String>();
    private Map<String, String> defaultProperties = new HashMap<String, String>();
    private SetMultimap<String, ConfigVetoableChangeListener> vetoListeners = HashMultimap.create();
    private SetMultimap<String, PropertyChangeListener> listeners = HashMultimap.create();
    private Connection connection;
    private PreparedStatement selectExact;
    private PreparedStatement selectLike;
    private PreparedStatement selectAll;
    private PreparedStatement insertOrUpdate;
    private PreparedStatement delete;
    private FileAccessService fas;

    public JdbcConfigService(FileAccessService fas) throws Exception {
        this.fas = fas;
        File dataFile = fas.getPrivatePersistentFile("props.hsql.script", FileCategory.PROFILE);
        File oldProps = fas.getPrivatePersistentFile("sip-communicator.properties", FileCategory.PROFILE);
        boolean migrate = false;
        if (!dataFile.exists() && oldProps.exists()) {
            migrate = true;
        }
        Class.forName("org.hsqldb.jdbc.JDBCDriver");
        this.checkConnection();
        if (migrate) {
            Properties p = new Properties();
            p.load(new FileInputStream(oldProps));
            this.connection.setAutoCommit(false);
            for (Map.Entry<Object, Object> e : p.entrySet()) {
                this.setProperty(e.getKey().toString(), e.getValue(), false);
            }
            this.connection.commit();
            this.connection.setAutoCommit(true);
        }
        this.loadDefaultProperties(DEFAULT_PROPS_FILE_NAME);
        this.loadDefaultProperties(DEFAULT_OVERRIDES_PROPS_FILE_NAME);
    }

    private void checkConnection() throws SQLException {
        String filename;
        if (this.connection != null && this.connection.isValid(1)) {
            try {
                PreparedStatement st = this.connection.prepareStatement("SELECT 1 FROM INFORMATION_SCHEMA.SYSTEM_USERS");
                if (st.execute()) {
                    return;
                }
            }
            catch (Exception e) {
                this.connection = null;
                this.logger.error((Object)"Database connection is invalid, recreating", (Throwable)e);
            }
        }
        try {
            File f = this.fas.getPrivatePersistentFile("props.hsql", FileCategory.PROFILE);
            filename = f.getAbsolutePath();
        }
        catch (Exception e) {
            throw new SQLException(e);
        }
        this.connection = DriverManager.getConnection("jdbc:hsqldb:file:" + filename + ";shutdown=true;hsqldb.write_delay=false;hsqldb.write_delay_millis=0");
        Statement st = this.connection.createStatement();
        st.executeUpdate("CREATE TABLE IF NOT EXISTS Props (k LONGVARCHAR UNIQUE, v LONGVARCHAR)");
        this.selectExact = this.connection.prepareStatement("SELECT v FROM Props WHERE k=?");
        this.selectLike = this.connection.prepareStatement("SELECT k, v FROM Props WHERE k LIKE ?");
        this.selectAll = this.connection.prepareStatement("SELECT k, v FROM Props");
        this.insertOrUpdate = this.connection.prepareStatement("MERGE INTO Props USING (VALUES(?,?)) AS i(k,v) ON Props.k = i.k WHEN MATCHED THEN UPDATE SET Props.v = i.v WHEN NOT MATCHED THEN INSERT (k, v) VALUES (i.k, i.v)");
        this.delete = this.connection.prepareStatement("DELETE FROM Props WHERE k=?");
    }

    public synchronized void setProperty(String propertyName, Object property) {
        this.setProperty(propertyName, property, false);
    }

    public synchronized void setProperty(String propertyName, Object property, boolean isSystem) {
        if (!isSystem && System.getProperty(propertyName) != null) {
            isSystem = true;
        }
        if (isSystem) {
            if (property == null) {
                System.clearProperty(propertyName);
                return;
            }
            System.setProperty(propertyName, property.toString());
        } else {
            if (this.immutableDefaultProperties.containsKey(propertyName)) {
                return;
            }
            try {
                this.checkConnection();
                Object oldValue = this.getProperty(propertyName);
                this.fireVetoableChange(propertyName, oldValue, property);
                if (property == null) {
                    this.delete.setString(1, propertyName);
                    this.delete.execute();
                } else {
                    this.insertOrUpdate.setString(1, propertyName);
                    this.insertOrUpdate.setString(2, property.toString());
                    this.insertOrUpdate.execute();
                }
                this.fireChange(propertyName, oldValue, property);
            }
            catch (SQLException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public synchronized void setProperties(Map<String, Object> properties) {
        try {
            this.checkConnection();
            this.connection.setAutoCommit(false);
            for (Map.Entry<String, Object> e : properties.entrySet()) {
                this.setProperty(e.getKey(), e.getValue(), false);
            }
            this.connection.commit();
            this.connection.setAutoCommit(true);
        }
        catch (SQLException e1) {
            throw new RuntimeException(e1);
        }
    }

    public synchronized Object getProperty(String propertyName) {
        String value = this.immutableDefaultProperties.get(propertyName);
        if (value != null) {
            return value;
        }
        try {
            this.checkConnection();
            this.selectExact.setString(1, propertyName);
            ResultSet q = this.selectExact.executeQuery();
            if (q.next()) {
                value = q.getString(1);
            }
        }
        catch (SQLException e) {
            this.logger.error((Object)e);
            throw new RuntimeException(e);
        }
        if (value != null) {
            return value;
        }
        value = this.defaultProperties.get(propertyName);
        if (value != null) {
            return value;
        }
        return System.getProperty(propertyName);
    }

    public synchronized void removeProperty(String propertyName) {
        for (String child : this.getPropertyNamesByPrefix(propertyName, false)) {
            this.setProperty(child, null, false);
        }
        this.setProperty(propertyName, null, false);
    }

    public List<String> getAllPropertyNames() {
        ArrayList<String> data = new ArrayList<String>(this.immutableDefaultProperties.keySet());
        data.addAll(this.defaultProperties.keySet());
        try {
            this.checkConnection();
            ResultSet q = this.selectAll.executeQuery();
            while (q.next()) {
                data.add(q.getString(1));
            }
        }
        catch (SQLException e) {
            this.logger.error((Object)e);
            throw new RuntimeException(e);
        }
        return data;
    }

    public List<String> getPropertyNamesByPrefix(String prefix, boolean exactPrefixMatch) {
        try {
            ArrayList<String> resultSet = new ArrayList<String>(50);
            this.checkConnection();
            this.selectLike.setString(1, prefix + "%");
            ResultSet q = this.selectLike.executeQuery();
            while (q.next()) {
                String key = q.getString(1);
                if (exactPrefixMatch) {
                    String keyPrefix;
                    int ix = key.lastIndexOf(46);
                    if (ix == -1 || !prefix.equals(keyPrefix = key.substring(0, ix))) continue;
                    resultSet.add(key);
                    continue;
                }
                if (!key.startsWith(prefix)) continue;
                resultSet.add(key);
            }
            return resultSet;
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    public List<String> getPropertyNamesBySuffix(String suffix) {
        try {
            ArrayList<String> resultKeySet = new ArrayList<String>(20);
            this.checkConnection();
            this.selectLike.setString(1, "%" + suffix);
            ResultSet q = this.selectLike.executeQuery();
            while (q.next()) {
                String key = q.getString(1);
                int ix = key.lastIndexOf(46);
                if (ix == -1 || !suffix.equals(key.substring(ix + 1))) continue;
                resultKeySet.add(key);
            }
            return resultKeySet;
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    public String getString(String propertyName) {
        String value = (String)this.getProperty(propertyName);
        if (value != null && (value = value.trim()).length() == 0) {
            return null;
        }
        return value;
    }

    public String getString(String propertyName, String defaultValue) {
        String value = this.getString(propertyName);
        if (value == null) {
            return defaultValue;
        }
        return value;
    }

    public boolean getBoolean(String propertyName, boolean defaultValue) {
        Object value = this.getProperty(propertyName);
        if (value == null) {
            return defaultValue;
        }
        return Boolean.parseBoolean(value.toString());
    }

    public int getInt(String propertyName, int defaultValue) {
        Object value = this.getProperty(propertyName);
        if (value == null || "".equals(value.toString())) {
            return defaultValue;
        }
        try {
            return Integer.parseInt(value.toString());
        }
        catch (NumberFormatException ex) {
            this.logger.error((Object)String.format("'%s' for property %s not an integer, returning default (%s)", value, propertyName, defaultValue), (Throwable)ex);
            return defaultValue;
        }
    }

    public double getDouble(String propertyName, double defaultValue) {
        Object value = this.getProperty(propertyName);
        if (value == null || "".equals(value.toString())) {
            return defaultValue;
        }
        try {
            return Double.parseDouble(value.toString());
        }
        catch (NumberFormatException ex) {
            this.logger.error((Object)String.format("'%s' for property %s not a double, returning default (%s)", value, propertyName, defaultValue), (Throwable)ex);
            return defaultValue;
        }
    }

    public long getLong(String propertyName, long defaultValue) {
        Object value = this.getProperty(propertyName);
        if (value == null || "".equals(value.toString())) {
            return defaultValue;
        }
        try {
            return Long.parseLong(value.toString());
        }
        catch (NumberFormatException ex) {
            this.logger.error((Object)String.format("'%s' for property %s not a long, returning default (%s)", value, propertyName, defaultValue), (Throwable)ex);
            return defaultValue;
        }
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.listeners.put(null, (Object)listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.listeners.remove(null, (Object)listener);
    }

    public void addPropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this.listeners.put((Object)propertyName, (Object)listener);
    }

    public void removePropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this.listeners.remove((Object)propertyName, (Object)listener);
    }

    public void addVetoableChangeListener(ConfigVetoableChangeListener listener) {
        this.vetoListeners.put(null, (Object)listener);
    }

    public void removeVetoableChangeListener(ConfigVetoableChangeListener listener) {
        this.vetoListeners.remove(null, (Object)listener);
    }

    public void addVetoableChangeListener(String propertyName, ConfigVetoableChangeListener listener) {
        this.vetoListeners.put((Object)propertyName, (Object)listener);
    }

    public void removeVetoableChangeListener(String propertyName, ConfigVetoableChangeListener listener) {
        this.vetoListeners.remove((Object)propertyName, (Object)listener);
    }

    public void storeConfiguration() throws IOException {
        try {
            this.connection.close();
        }
        catch (SQLException e) {
            this.logger.error((Object)e);
        }
        finally {
            this.connection = null;
        }
    }

    public void reloadConfiguration() throws IOException {
    }

    public void purgeStoredConfiguration() {
        try {
            this.checkConnection();
            Statement st = this.connection.createStatement();
            st.executeUpdate("TRUNCATE TABLE Props");
        }
        catch (SQLException e) {
            this.logger.error((Object)e);
            throw new RuntimeException(e);
        }
    }

    public String getScHomeDirName() {
        return System.getProperty("net.java.sip.communicator.SC_HOME_DIR_NAME");
    }

    public String getScHomeDirLocation() {
        return System.getProperty("net.java.sip.communicator.SC_HOME_DIR_LOCATION");
    }

    public String getConfigurationFilename() {
        return "props.hsql.script";
    }

    private void loadDefaultProperties(String fileName) {
        block4: {
            try {
                Properties fileProps = new Properties();
                InputStream fileStream = OSUtils.IS_ANDROID ? this.getClass().getClassLoader().getResourceAsStream(fileName) : ClassLoader.getSystemResourceAsStream(fileName);
                fileProps.load(fileStream);
                fileStream.close();
                for (Map.Entry<Object, Object> entry : fileProps.entrySet()) {
                    String name = (String)entry.getKey();
                    String value = (String)entry.getValue();
                    if (name == null || value == null || name.trim().length() == 0) continue;
                    if (name.startsWith("*")) {
                        if ((name = name.substring(1)).trim().length() == 0) continue;
                        this.immutableDefaultProperties.put(name, value);
                        this.defaultProperties.remove(name);
                        continue;
                    }
                    this.defaultProperties.put(name, value);
                    this.immutableDefaultProperties.remove(name);
                }
            }
            catch (Exception ex) {
                this.logger.info((Object)("No defaults property file loaded: " + fileName + ". Not a problem."));
                if (!this.logger.isDebugEnabled()) break block4;
                this.logger.debug((Object)"load exception", (Throwable)ex);
            }
        }
    }

    private void fireVetoableChange(String propertyName, Object oldValue, Object newValue) {
        PropertyChangeEvent evt = new PropertyChangeEvent(this, propertyName, oldValue, newValue);
        for (ConfigVetoableChangeListener l : this.vetoListeners.get((Object)propertyName)) {
            l.vetoableChange(evt);
        }
        for (ConfigVetoableChangeListener l : this.vetoListeners.get(null)) {
            l.vetoableChange(evt);
        }
    }

    private void fireChange(String propertyName, Object oldValue, Object newValue) {
        PropertyChangeEvent evt = new PropertyChangeEvent(this, propertyName, oldValue, newValue);
        for (PropertyChangeListener l : this.listeners.get((Object)propertyName)) {
            l.propertyChange(evt);
        }
        for (PropertyChangeListener l : this.listeners.get(null)) {
            l.propertyChange(evt);
        }
    }

    public void logConfigurationProperties(String excludePattern) {
        if (!this.logger.isInfoEnabled()) {
            return;
        }
        Pattern exclusion = null;
        if (StringUtils.isNotEmpty((CharSequence)excludePattern)) {
            exclusion = Pattern.compile(excludePattern, 2);
        }
        for (String p : this.getAllPropertyNames()) {
            Object v = this.getProperty(p);
            if (v == null) continue;
            if (exclusion != null && exclusion.matcher(p).find()) {
                v = "**********";
            }
            this.logger.info((Object)(p + "=" + v));
        }
    }
}

