/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.slick.protocol.sip;

import java.io.UnsupportedEncodingException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Arrays;
import java.util.Date;
import java.util.EventObject;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import net.java.sip.communicator.service.protocol.Contact;
import net.java.sip.communicator.service.protocol.Message;
import net.java.sip.communicator.service.protocol.OperationFailedException;
import net.java.sip.communicator.service.protocol.OperationSetBasicInstantMessaging;
import net.java.sip.communicator.service.protocol.OperationSetPresence;
import net.java.sip.communicator.service.protocol.PresenceStatus;
import net.java.sip.communicator.service.protocol.event.MessageDeliveredEvent;
import net.java.sip.communicator.service.protocol.event.MessageDeliveryFailedEvent;
import net.java.sip.communicator.service.protocol.event.MessageListener;
import net.java.sip.communicator.service.protocol.event.MessageReceivedEvent;
import net.java.sip.communicator.slick.protocol.sip.SipSlickFixture;
import net.java.sip.communicator.util.Logger;

public class TestOperationSetBasicInstantMessaging
extends TestCase {
    private static final Logger logger = Logger.getLogger(TestOperationSetBasicInstantMessaging.class);
    private SipSlickFixture fixture = new SipSlickFixture();
    private OperationSetBasicInstantMessaging opSetBasicIM1 = null;
    private OperationSetBasicInstantMessaging opSetBasicIM2 = null;
    private OperationSetPresence opSetPresence1 = null;
    private OperationSetPresence opSetPresence2 = null;

    public TestOperationSetBasicInstantMessaging(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.fixture.setUp();
        Map supportedOperationSets1 = this.fixture.provider1.getSupportedOperationSets();
        if (supportedOperationSets1 == null || supportedOperationSets1.size() < 1) {
            throw new NullPointerException("No OperationSet implementations are supported by this implementation. ");
        }
        this.opSetBasicIM1 = (OperationSetBasicInstantMessaging)supportedOperationSets1.get(OperationSetBasicInstantMessaging.class.getName());
        if (this.opSetBasicIM1 == null) {
            throw new NullPointerException("No implementation for basic IM was found");
        }
        this.opSetPresence1 = (OperationSetPresence)supportedOperationSets1.get(OperationSetPresence.class.getName());
        if (this.opSetPresence1 == null) {
            throw new NullPointerException("An implementation of the service must provide an implementation of at least one of the PresenceOperationSets");
        }
        Map supportedOperationSets2 = this.fixture.provider2.getSupportedOperationSets();
        if (supportedOperationSets2 == null || supportedOperationSets2.size() < 1) {
            throw new NullPointerException("No OperationSet implementations are supported by this implementation. ");
        }
        this.opSetBasicIM2 = (OperationSetBasicInstantMessaging)supportedOperationSets2.get(OperationSetBasicInstantMessaging.class.getName());
        if (this.opSetBasicIM2 == null) {
            throw new NullPointerException("No implementation for basic IM was found");
        }
        this.opSetPresence2 = (OperationSetPresence)supportedOperationSets2.get(OperationSetPresence.class.getName());
        if (this.opSetPresence2 == null) {
            throw new NullPointerException("An implementation of the service must provide an implementation of at least one of the PresenceOperationSets");
        }
    }

    protected void tearDown() throws Exception {
        super.tearDown();
        this.fixture.tearDown();
    }

    public static Test suite() {
        TestSuite suite = new TestSuite();
        suite.addTest((Test)new TestOperationSetBasicInstantMessaging("prepareContactList"));
        suite.addTestSuite(TestOperationSetBasicInstantMessaging.class);
        suite.addTest((Test)new TestOperationSetBasicInstantMessaging("firstTestReceiveMessage"));
        suite.addTest((Test)new TestOperationSetBasicInstantMessaging("thenTestSendMessage"));
        suite.addTest((Test)new TestOperationSetBasicInstantMessaging("reportingSendFunMessages"));
        return suite;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void prepareContactList() throws Exception {
        PresenceStatus stat;
        Object o;
        block13: {
            block12: {
                this.fixture.clearProvidersLists();
                Object object = o = new Object();
                synchronized (object) {
                    o.wait(2000L);
                }
                try {
                    this.opSetPresence1.subscribe(this.fixture.userID2);
                }
                catch (OperationFailedException ex) {
                    if (ex.getErrorCode() == 5) break block12;
                    throw ex;
                }
            }
            try {
                this.opSetPresence2.subscribe(this.fixture.userID1);
            }
            catch (OperationFailedException ex) {
                if (ex.getErrorCode() == 5) break block13;
                throw ex;
            }
        }
        Iterator iter = this.opSetPresence1.getSupportedStatusSet();
        while (iter.hasNext()) {
            stat = (PresenceStatus)iter.next();
            if (!stat.isOnline()) continue;
            this.opSetPresence1.publishPresenceStatus(stat, "online for testing purpose");
            break;
        }
        iter = this.opSetPresence2.getSupportedStatusSet();
        while (iter.hasNext()) {
            stat = (PresenceStatus)iter.next();
            if (!stat.isOnline()) continue;
            this.opSetPresence2.publishPresenceStatus(stat, "online for testing purpose");
            break;
        }
        logger.info((Object)"will wait till the list prepare is completed");
        Object object = o;
        synchronized (object) {
            o.wait(4000L);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void firstTestReceiveMessage() throws IllegalStateException, IllegalArgumentException, OperationFailedException {
        String body = "This is an IM coming from the tester agent on " + new Date().toString();
        ImEventCollector evtCollector = new ImEventCollector();
        this.opSetBasicIM1.addMessageListener((MessageListener)evtCollector);
        Contact testerAgentContact = this.opSetPresence2.findContactByID(this.fixture.userID1);
        logger.debug((Object)("Will send message " + body + " to: " + testerAgentContact.getAddress()));
        this.opSetBasicIM2.sendInstantMessage(testerAgentContact, this.opSetBasicIM2.createMessage(body));
        evtCollector.waitForEvent(25000L);
        this.opSetBasicIM1.removeMessageListener((MessageListener)evtCollector);
        TestOperationSetBasicInstantMessaging.assertTrue((String)"No events delivered upon a received message", (evtCollector.collectedEvents.size() > 0 ? 1 : 0) != 0);
        TestOperationSetBasicInstantMessaging.assertTrue((String)("Received evt was not an instance of " + MessageReceivedEvent.class.getName()), (boolean)(evtCollector.collectedEvents.get(0) instanceof MessageReceivedEvent));
        MessageReceivedEvent evt = (MessageReceivedEvent)evtCollector.collectedEvents.get(0);
        TestOperationSetBasicInstantMessaging.assertEquals((String)"message sender ", (String)evt.getSourceContact().getAddress(), (String)this.fixture.userID2);
        TestOperationSetBasicInstantMessaging.assertEquals((String)"message body", (String)body, (String)evt.getSourceMessage().getContent());
        TestOperationSetBasicInstantMessaging.assertEquals((String)"message content type", (String)"text/plain", (String)evt.getSourceMessage().getContentType());
        try {
            TestOperationSetBasicInstantMessaging testOperationSetBasicInstantMessaging = this;
            synchronized (testOperationSetBasicInstantMessaging) {
                ((Object)((Object)this)).wait(5000L);
            }
        }
        catch (InterruptedException e) {
            logger.debug((Object)"the first test's wait has been interrupted, the second test may fail", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void thenTestSendMessage() throws IllegalStateException, IllegalArgumentException, OperationFailedException {
        String body = "This is an IM coming from the tested implementation on " + new Date().toString();
        Message msg = this.opSetBasicIM1.createMessage(body);
        ImEventCollector imEvtCollector1 = new ImEventCollector();
        this.opSetBasicIM1.addMessageListener((MessageListener)imEvtCollector1);
        ImEventCollector imEvtCollector2 = new ImEventCollector();
        this.opSetBasicIM2.addMessageListener((MessageListener)imEvtCollector2);
        Contact testerAgentContact = this.opSetPresence1.findContactByID(this.fixture.userID2);
        logger.debug((Object)("Will send message " + body + " to: " + testerAgentContact.getAddress()));
        this.opSetBasicIM1.sendInstantMessage(testerAgentContact, msg);
        imEvtCollector1.waitForEvent(10000L);
        imEvtCollector2.waitForEvent(10000L);
        this.opSetBasicIM1.removeMessageListener((MessageListener)imEvtCollector1);
        this.opSetBasicIM2.removeMessageListener((MessageListener)imEvtCollector2);
        TestOperationSetBasicInstantMessaging.assertTrue((String)"No events delivered when sending a message", (imEvtCollector1.collectedEvents.size() > 0 ? 1 : 0) != 0);
        TestOperationSetBasicInstantMessaging.assertTrue((String)("Received evt was not an instance of " + MessageDeliveredEvent.class.getName()), (boolean)(imEvtCollector1.collectedEvents.get(0) instanceof MessageDeliveredEvent));
        MessageDeliveredEvent evt = (MessageDeliveredEvent)imEvtCollector1.collectedEvents.get(0);
        TestOperationSetBasicInstantMessaging.assertEquals((String)"message destination ", (String)evt.getDestinationContact().getAddress(), (String)this.fixture.userID2);
        TestOperationSetBasicInstantMessaging.assertSame((String)"source message", (Object)msg, (Object)evt.getSourceMessage());
        TestOperationSetBasicInstantMessaging.assertTrue((String)"No messages received by the tester agent", (imEvtCollector2.collectedEvents.size() > 0 ? 1 : 0) != 0);
        String receivedBody = ((MessageReceivedEvent)imEvtCollector2.collectedEvents.get(0)).getSourceMessage().getContent();
        TestOperationSetBasicInstantMessaging.assertEquals((String)"received message body", (String)msg.getContent(), (String)receivedBody);
        try {
            TestOperationSetBasicInstantMessaging testOperationSetBasicInstantMessaging = this;
            synchronized (testOperationSetBasicInstantMessaging) {
                ((Object)((Object)this)).wait(5000L);
            }
        }
        catch (InterruptedException e) {
            logger.debug((Object)"the second test's wait has been interrupted, the following test may fail", (Throwable)e);
        }
    }

    public void testCreateMessage1() {
        String body = "This is an IM coming from the tested implementation on " + new Date().toString();
        Message msg = this.opSetBasicIM1.createMessage(body);
        TestOperationSetBasicInstantMessaging.assertEquals((String)"message body", (String)body, (String)msg.getContent());
        TestOperationSetBasicInstantMessaging.assertTrue((String)"message body bytes", (boolean)Arrays.equals(body.getBytes(), msg.getRawData()));
        TestOperationSetBasicInstantMessaging.assertEquals((String)"message length", (int)body.length(), (int)msg.getSize());
        TestOperationSetBasicInstantMessaging.assertEquals((String)"message content type", (String)"text/plain", (String)msg.getContentType());
        TestOperationSetBasicInstantMessaging.assertEquals((String)"message encoding", (String)"UTF-8", (String)msg.getEncoding());
        TestOperationSetBasicInstantMessaging.assertNotNull((String)"message uid", (Object)msg.getMessageUID());
        Message msg2 = this.opSetBasicIM1.createMessage(body);
        TestOperationSetBasicInstantMessaging.assertFalse((String)"message uid", (boolean)msg.getMessageUID().equals(msg2.getMessageUID()));
    }

    public void testCreateMessage2() {
        String body = "This is an IM coming from the tested implementation on " + new Date().toString();
        String contentType = "text/html";
        String encoding = "UTF-16";
        String subject = "test message";
        Message msg = this.opSetBasicIM1.createMessage(body, contentType, encoding, subject);
        TestOperationSetBasicInstantMessaging.assertEquals((String)"message body", (String)body, (String)msg.getContent());
        TestOperationSetBasicInstantMessaging.assertEquals((String)"message encoding", (String)encoding, (String)msg.getEncoding());
        try {
            TestOperationSetBasicInstantMessaging.assertTrue((String)"message body bytes", (boolean)Arrays.equals(body.getBytes(encoding), msg.getRawData()));
            TestOperationSetBasicInstantMessaging.assertEquals((String)"message length", (int)body.getBytes(encoding).length, (int)msg.getSize());
        }
        catch (UnsupportedEncodingException e) {
            logger.warn((Object)"The current content encoding isn't supported", (Throwable)e);
            TestOperationSetBasicInstantMessaging.assertTrue((String)"message body bytes", (boolean)Arrays.equals(body.getBytes(), msg.getRawData()));
            TestOperationSetBasicInstantMessaging.assertEquals((String)"message length", (int)body.getBytes().length, (int)msg.getSize());
        }
        TestOperationSetBasicInstantMessaging.assertEquals((String)"message content type", (String)contentType, (String)msg.getContentType());
        TestOperationSetBasicInstantMessaging.assertNotNull((String)"message uid", (Object)msg.getMessageUID());
        Message msg2 = this.opSetBasicIM1.createMessage(body);
        TestOperationSetBasicInstantMessaging.assertFalse((String)"message uid", (boolean)msg.getMessageUID().equals(msg2.getMessageUID()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reportingSendFunMessages() throws IllegalStateException, IllegalArgumentException, OperationFailedException {
        String hostname = "";
        try {
            hostname = InetAddress.getLocalHost().getHostName() + ": ";
        }
        catch (UnknownHostException unknownHostException) {
            // empty catch block
        }
        String message = hostname + "Hello this is the SIP Communicator (version " + System.getProperty("sip-communicator.version") + ") build on: " + new Date().toString() + ". Have a very nice day!";
        String list = System.getProperty("accounts.reporting.SIP_REPORT_LIST");
        logger.debug((Object)("Will send message " + message + " to: " + list));
        if (list == null || list.trim().length() == 0) {
            return;
        }
        StringTokenizer tokenizer = new StringTokenizer(list, " ");
        while (tokenizer.hasMoreTokens()) {
            String contactID = tokenizer.nextToken();
            Contact contact = this.opSetPresence2.findContactByID(contactID);
            if (contact == null) {
                try {
                    Object o;
                    this.opSetPresence2.subscribe(contactID);
                    Object object = o = new Object();
                    synchronized (object) {
                        o.wait(2000L);
                    }
                }
                catch (Exception ex1) {
                    continue;
                }
            }
            contact = this.opSetPresence2.findContactByID(contactID);
            this.opSetBasicIM2.sendInstantMessage(contact, this.opSetBasicIM2.createMessage(message));
        }
    }

    private class ImEventCollector
    implements MessageListener {
        private List<EventObject> collectedEvents = new LinkedList<EventObject>();

        private ImEventCollector() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void messageReceived(MessageReceivedEvent evt) {
            logger.debug((Object)("Received a MessageReceivedEvent: " + evt));
            ImEventCollector imEventCollector = this;
            synchronized (imEventCollector) {
                this.collectedEvents.add((EventObject)evt);
                this.notifyAll();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void messageDeliveryFailed(MessageDeliveryFailedEvent evt) {
            logger.debug((Object)("Received a MessageDeliveryFailedEvent: " + evt));
            ImEventCollector imEventCollector = this;
            synchronized (imEventCollector) {
                this.collectedEvents.add((EventObject)evt);
                this.notifyAll();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void messageDelivered(MessageDeliveredEvent evt) {
            logger.debug((Object)("Received a MessageDeliveredEvent: " + evt));
            ImEventCollector imEventCollector = this;
            synchronized (imEventCollector) {
                this.collectedEvents.add((EventObject)evt);
                this.notifyAll();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void waitForEvent(long waitFor) {
            ImEventCollector imEventCollector = this;
            synchronized (imEventCollector) {
                if (this.collectedEvents.size() > 0) {
                    return;
                }
                try {
                    this.wait(waitFor);
                }
                catch (InterruptedException ex) {
                    logger.debug((Object)"Interrupted while waiting for a message evt", (Throwable)ex);
                }
            }
        }
    }
}

