/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.colors;

import org.jivesoftware.smack.util.Objects;
import org.jivesoftware.smack.util.SHA1;

public class ConsistentColor {
    private static final ConsistentColorSettings DEFAULT_SETTINGS = new ConsistentColorSettings();
    private static final double KR = 0.299;
    private static final double KG = 0.587;
    private static final double KB = 0.114;
    private static final double Y = 0.732;

    private static double createAngle(CharSequence input) {
        byte[] h = SHA1.bytes((String)input.toString());
        double v = ConsistentColor.u(h[0]) + 256 * ConsistentColor.u(h[1]);
        double d = v / 65536.0;
        return d * 2.0 * Math.PI;
    }

    private static double applyColorDeficiencyCorrection(double angle, Deficiency deficiency) {
        switch (deficiency) {
            case none: {
                break;
            }
            case redGreenBlindness: {
                angle %= Math.PI;
                break;
            }
            case blueBlindness: {
                angle -= 1.5707963267948966;
                angle %= Math.PI;
                angle += 1.5707963267948966;
            }
        }
        return angle;
    }

    private static double[] angleToCbCr(double angle) {
        double cb = Math.cos(angle);
        double cr = Math.sin(angle);
        double acb = Math.abs(cb);
        double acr = Math.abs(cr);
        double factor = acr > acb ? 0.5 / acr : 0.5 / acb;
        return new double[]{cb *= factor, cr *= factor};
    }

    private static float[] CbCrToRGB(double[] cbcr, double y) {
        double cb = cbcr[0];
        double cr = cbcr[1];
        double r = 1.4020000000000001 * cr + y;
        double b = 1.772 * cb + y;
        double g = (y - 0.299 * r - 0.114 * b) / 0.587;
        r = ConsistentColor.clip(r);
        g = ConsistentColor.clip(g);
        b = ConsistentColor.clip(b);
        return new float[]{(float)r, (float)g, (float)b};
    }

    private static double clip(double value) {
        double out = value;
        if (value < 0.0) {
            out = 0.0;
        }
        if (value > 1.0) {
            out = 1.0;
        }
        return out;
    }

    private static int u(byte b) {
        return b & 0xFF;
    }

    public static float[] RGBFrom(CharSequence input) {
        return ConsistentColor.RGBFrom(input, DEFAULT_SETTINGS);
    }

    public static float[] RGBFrom(CharSequence input, ConsistentColorSettings settings) {
        double angle = ConsistentColor.createAngle(input);
        double correctedAngle = ConsistentColor.applyColorDeficiencyCorrection(angle, settings.getDeficiency());
        double[] CbCr = ConsistentColor.angleToCbCr(correctedAngle);
        float[] rgb = ConsistentColor.CbCrToRGB(CbCr, 0.732);
        return rgb;
    }

    public static class ConsistentColorSettings {
        private final Deficiency deficiency;

        public ConsistentColorSettings() {
            this(Deficiency.none);
        }

        public ConsistentColorSettings(Deficiency deficiency) {
            this.deficiency = (Deficiency)((Object)Objects.requireNonNull((Object)((Object)deficiency), (String)"Deficiency must be given"));
        }

        public Deficiency getDeficiency() {
            return this.deficiency;
        }
    }

    public static enum Deficiency {
        none,
        redGreenBlindness,
        blueBlindness;

    }
}

