/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.slick.slickless;

import java.util.Hashtable;
import java.util.StringTokenizer;
import junit.framework.Test;
import junit.framework.TestSuite;
import junit.textui.TestRunner;
import net.java.sip.communicator.util.Logger;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;

public class SlicklessTests
extends TestSuite
implements BundleActivator {
    private Logger logger = Logger.getLogger((String)((Object)((Object)this)).getClass().getName());
    protected static BundleContext bc = null;
    private static final String TEST_LIST_PROPERTY_NAME = "net.java.sip.communicator.slick.runner.SLICKLESS_TEST_LIST";

    public void start(BundleContext bundleContext) throws Exception {
        bc = bundleContext;
        this.setName("SlicklessTests");
        Hashtable<String, String> properties = new Hashtable<String, String>();
        properties.put("service.pid", this.getName());
        this.addTest(this.createSuite());
        bundleContext.registerService(((Object)((Object)this)).getClass().getName(), (Object)this, properties);
        this.logger.debug((Object)("Successfully registered " + ((Object)((Object)this)).getClass().getName()));
    }

    public void stop(BundleContext bundlecontext) throws Exception {
    }

    public static void main(String[] args) {
        TestRunner.run((Test)SlicklessTests.suite());
    }

    public static Test suite() {
        SlicklessTests tests = new SlicklessTests();
        return tests.createSuite();
    }

    private Test createSuite() {
        String tests = System.getProperty(TEST_LIST_PROPERTY_NAME);
        if (tests == null || tests.trim().length() == 0) {
            tests = "";
        }
        this.logger.debug((Object)("specfied test list is: " + tests));
        StringTokenizer st = new StringTokenizer(tests);
        String[] ids = new String[st.countTokens()];
        int n = 0;
        while (st.hasMoreTokens()) {
            ids[n++] = st.nextToken().trim();
        }
        TestSuite suite = new TestSuite();
        for (int i = 0; i < n; ++i) {
            String testName = ids[i];
            if (testName == null || testName.trim().length() <= 0) continue;
            try {
                Class<?> testClass = Class.forName(testName);
                if (bc == null && BundleActivator.class.isAssignableFrom(testClass)) {
                    this.logger.error((Object)("test " + testName + " skipped - it must run under felix"));
                    continue;
                }
                suite.addTest((Test)new TestSuite(testClass));
                continue;
            }
            catch (ClassNotFoundException e) {
                this.logger.error((Object)("Failed to load standalone test " + testName));
            }
        }
        return suite;
    }
}

