/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.impl.sysactivity;

import net.java.sip.communicator.util.Logger;
import org.jitsi.util.OSUtils;
import org.jitsi.utils.JNIUtils;

public class SystemActivityNotifications {
    private static final Logger logger = Logger.getLogger(SystemActivityNotifications.class);
    public static final int NOTIFY_DISPLAY_SLEEP = 2;
    public static final int NOTIFY_DISPLAY_WAKE = 3;
    public static final int NOTIFY_DNS_CHANGE = 10;
    public static final int NOTIFY_ENDSESSION = 12;
    public static final int NOTIFY_NETWORK_CHANGE = 9;
    public static final int NOTIFY_QUERY_ENDSESSION = 11;
    public static final int NOTIFY_SCREEN_LOCKED = 7;
    public static final int NOTIFY_SCREEN_UNLOCKED = 8;
    public static final int NOTIFY_SCREENSAVER_START = 4;
    public static final int NOTIFY_SCREENSAVER_STOP = 6;
    public static final int NOTIFY_SCREENSAVER_WILL_STOP = 5;
    public static final int NOTIFY_SLEEP = 0;
    public static final int NOTIFY_WAKE = 1;
    private static long ptr;
    private static boolean linuxLoaded;

    private static native long allocAndInit();

    public static native long getLastInput();

    public static boolean isLoaded() {
        return ptr != 0L || OSUtils.IS_LINUX && linuxLoaded;
    }

    private static native void release(long var0);

    public static native void setDelegate(long var0, NotificationsDelegate var2);

    public static void setDelegate(NotificationsDelegate delegate) {
        if (ptr != 0L) {
            SystemActivityNotifications.setDelegate(ptr, delegate);
        }
    }

    public static void start() {
        if (ptr != 0L) {
            SystemActivityNotifications.start(ptr);
        }
    }

    private static native void start(long var0);

    public static void stop() {
        if (ptr != 0L) {
            SystemActivityNotifications.stop(ptr);
            SystemActivityNotifications.release(ptr);
            ptr = 0L;
        }
    }

    private static native void stop(long var0);

    static {
        linuxLoaded = false;
        try {
            if (!OSUtils.IS_ANDROID) {
                JNIUtils.loadLibrary((String)"sysactivitynotifications", SystemActivityNotifications.class);
                ptr = SystemActivityNotifications.allocAndInit();
                if (ptr == -1L) {
                    ptr = 0L;
                    linuxLoaded = true;
                }
            }
        }
        catch (Throwable t) {
            if (t instanceof ThreadDeath) {
                throw (ThreadDeath)t;
            }
            logger.warn((Object)"Failed to initialize native counterpart", t);
        }
    }

    public static interface NotificationsDelegate {
        public void notify(int var1);

        public void notifyNetworkChange(int var1, long var2, String var4, long var5, boolean var7);
    }
}

