/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.util;

import java.awt.Color;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import net.java.sip.communicator.service.protocol.AccountID;
import net.java.sip.communicator.service.protocol.ProtocolProviderFactory;
import net.java.sip.communicator.service.protocol.ProtocolProviderService;
import net.java.sip.communicator.service.resources.ResourceManagementServiceUtils;
import net.java.sip.communicator.util.Logger;
import net.java.sip.communicator.util.UtilActivator;
import org.apache.commons.lang3.StringUtils;
import org.jitsi.service.configuration.ConfigurationService;
import org.jitsi.service.neomedia.codec.EncodingConfiguration;
import org.jitsi.util.OSUtils;
import org.jitsi.utils.MediaType;
import org.osgi.framework.ServiceReference;

public class ConfigurationUtils {
    private static final Logger logger = Logger.getLogger(ConfigurationUtils.class);
    public static final String ENTER_COMMAND = "Enter";
    public static final String CTRL_ENTER_COMMAND = "Ctrl-Enter";
    private static boolean autoPopupNewMessage = false;
    private static String sendMessageCommand;
    private static boolean isCallPanelShown;
    private static boolean isShowOffline;
    private static boolean isApplicationVisible;
    private static boolean isQuitWarningShown;
    private static boolean minimizeInsteadOfHide;
    private static boolean isSendTypingNotifications;
    private static boolean isMoveContactConfirmationRequested;
    private static boolean isMultiChatWindowEnabled;
    private static boolean isLeaveChatRoomOnWindowCloseEnabled;
    private static boolean isPrivateMessagingInChatRoomDisabled;
    private static boolean isHistoryShown;
    private static boolean isRecentMessagesShown;
    private static int chatHistorySize;
    private static int chatWriteAreaSize;
    private static int windowTransparency;
    private static boolean isTransparentWindowEnabled;
    private static boolean isWindowDecorated;
    private static boolean isChatToolbarVisible;
    private static boolean isChatStylebarVisible;
    private static boolean isShowSmileys;
    private static boolean isChatSimpleThemeEnabled;
    private static boolean isAddContactDisabled;
    private static boolean isMergeContactDisabled;
    private static boolean isGoToChatroomDisabled;
    private static boolean isCreateGroupDisabled;
    private static boolean isFlattenGroupEnabled;
    private static boolean isRemoveContactDisabled;
    private static boolean isContactMoveDisabled;
    private static boolean isContactRenameDisabled;
    private static boolean isGroupRemoveDisabled;
    private static boolean isGroupRenameDisabled;
    private static boolean isPresetStatusMessagesEnabled;
    private static String sendFileLastDir;
    private static ConfigurationService configService;
    private static String lastContactParent;
    private static ProtocolProviderService lastCallConferenceProvider;
    private static boolean isAdvancedAccountConfigDisabled;
    private static String defaultFontFamily;
    private static String defaultFontSize;
    private static boolean isDefaultFontBold;
    private static boolean isDefaultFontItalic;
    private static boolean isDefaultFontUnderline;
    private static int defaultFontColor;
    private static boolean showStatusChangedInChat;
    private static boolean routeVideoAndDesktopUsingPhoneNumber;
    private static boolean hideAccountSelectionWhenPossible;
    private static boolean hideAccountStatusSelectors;
    private static boolean hideExtendedAwayStatus;
    private static boolean autoAnswerDisableSubmenu;
    private static boolean isChatRoomConfigDisabled;
    private static boolean isSingleWindowInterfaceEnabled;
    private static boolean isHideAddressInCallHistoryTooltipEnabled;
    private static final String HIDE_ADDR_IN_CALL_HISTORY_TOOLTIP_PROPERTY = "net.java.sip.communicator.impl.gui.contactlist.HIDE_ADDRESS_IN_CALL_HISTORY_TOOLTIP_ENABLED";
    private static boolean isSmsNotifyTextDisabled;
    private static final String SMS_MSG_NOTIFY_TEXT_DISABLED_PROP = "net.java.sip.communicator.impl.gui.main.contactlist.SMS_MSG_NOTIFY_TEXT_DISABLED_PROP";
    private static boolean isHideDomainInReceivedCallDialogEnabled;
    private static final String HIDE_DOMAIN_IN_RECEIEVE_CALL_DIALOG_PROPERTY = "net.java.sip.communicator.impl.gui.main.call.HIDE_DOMAIN_IN_RECEIVE_CALL_DIALOG_ENABLED";
    private static final String SHOW_SMILEYS_PROPERTY = "net.java.sip.communicator.service.replacement.SMILEY.enable";
    private static final String CHAT_SIMPLE_THEME_ENABLED_PROP = "net.java.sip.communicator.service.gui.CHAT_SIMPLE_THEME_ENABLED";
    private static final String CHAT_ROOM_CONFIG_DISABLED_PROP = "net.java.sip.communicator.service.gui.CHAT_ROOM_CONFIG_DISABLED";
    private static final String SINGLE_WINDOW_INTERFACE_ENABLED = "net.java.sip.communicator.service.gui.SINGLE_WINDOW_INTERFACE_ENABLED";
    private static boolean isNormalizePhoneNumber;
    private static boolean acceptPhoneNumberWithAlphaChars;
    public static final String ALERTER_ENABLED_PROP = "plugin.chatalerter.ENABLED";
    private static final String MASTER_PASS_WARNING_PROP = "net.java.sip.communicator.impl.gui.main.SHOW_MASTER_PASSWORD_WARNING";
    private static boolean showMasterPasswordWarning;
    private static boolean alerterEnabled;

    public static void loadGuiConfigurations() {
        String isWindowDecoratedProperty;
        String isWindowDecoratedString;
        String windowTransparencyProperty;
        String windowTransparencyString;
        String isTransparentWindowEnabledProperty;
        String isTransparentWindowEnabledString;
        String chatWriteAreaSizeStringProperty;
        String chatWriteAreaSizeString;
        String isHistoryShownStringProperty;
        String isHistoryShownString;
        String isMultiChatWindowEnabledStringProperty;
        String isMultiChatWindowEnabledString;
        String isMoveContactConfirmationRequestedString;
        String showOffline;
        configService.addPropertyChangeListener((PropertyChangeListener)new ConfigurationChangeListener());
        String autoPopupProperty = "service.gui.AUTO_POPUP_NEW_MESSAGE";
        String autoPopup = configService.getString(autoPopupProperty);
        if (autoPopup == null) {
            autoPopup = UtilActivator.getResources().getSettingsString(autoPopupProperty);
        }
        if (autoPopup != null && autoPopup.equalsIgnoreCase("yes")) {
            autoPopupNewMessage = true;
        }
        String messageCommandProperty = "service.gui.SEND_MESSAGE_COMMAND";
        sendMessageCommand = UtilActivator.getResources().getSettingsString(messageCommandProperty);
        String callPanelShown = configService.getString("net.java.sip.communicator.impl.gui.showCallPanel");
        if (callPanelShown != null && callPanelShown.length() > 0) {
            isCallPanelShown = Boolean.parseBoolean(callPanelShown);
        }
        if ((showOffline = configService.getString("net.java.sip.communicator.impl.gui.showOffline")) != null && showOffline.length() > 0) {
            isShowOffline = Boolean.parseBoolean(showOffline);
        }
        isApplicationVisible = configService.getBoolean("net.java.sip.communicator.impl.systray.showApplication", isApplicationVisible);
        String quitWarningShown = configService.getString("net.java.sip.communicator.impl.gui.quitWarningShown");
        if (quitWarningShown != null && quitWarningShown.length() > 0) {
            isQuitWarningShown = Boolean.parseBoolean(quitWarningShown);
        }
        minimizeInsteadOfHide = configService.getBoolean("net.java.sip.communicator.impl.gui.minimizeInsteadOfHide", ConfigurationUtils.isPinnedToTaskBar());
        String isSendTypingNotifProperty = "service.gui.SEND_TYPING_NOTIFICATIONS_ENABLED";
        String isSendTypingNotif = configService.getString(isSendTypingNotifProperty);
        if (isSendTypingNotif == null) {
            isSendTypingNotif = UtilActivator.getResources().getSettingsString(isSendTypingNotifProperty);
        }
        if (isSendTypingNotif != null && isSendTypingNotif.length() > 0) {
            isSendTypingNotifications = Boolean.parseBoolean(isSendTypingNotif);
        }
        if ((isMoveContactConfirmationRequestedString = configService.getString("net.java.sip.communicator.impl.gui.isMoveContactConfirmationRequested")) != null && isMoveContactConfirmationRequestedString.length() > 0) {
            isMoveContactConfirmationRequested = Boolean.parseBoolean(isMoveContactConfirmationRequestedString);
        }
        if ((isMultiChatWindowEnabledString = configService.getString(isMultiChatWindowEnabledStringProperty = "service.gui.IS_MULTI_CHAT_WINDOW_ENABLED")) == null) {
            isMultiChatWindowEnabledString = UtilActivator.getResources().getSettingsString(isMultiChatWindowEnabledStringProperty);
        }
        if (isMultiChatWindowEnabledString != null && isMultiChatWindowEnabledString.length() > 0) {
            isMultiChatWindowEnabled = Boolean.parseBoolean(isMultiChatWindowEnabledString);
        }
        isPrivateMessagingInChatRoomDisabled = configService.getBoolean("service.gui.IS_PRIVATE_CHAT_IN_CHATROOM_DISABLED", false);
        String isLeaveChatRoomOnWindowCloseEnabledStringProperty = "service.gui.LEAVE_CHATROOM_ON_WINDOW_CLOSE";
        String isLeaveChatRoomOnWindowCloseEnabledString = configService.getString(isLeaveChatRoomOnWindowCloseEnabledStringProperty);
        if (isLeaveChatRoomOnWindowCloseEnabledString == null) {
            isLeaveChatRoomOnWindowCloseEnabledString = UtilActivator.getResources().getSettingsString(isLeaveChatRoomOnWindowCloseEnabledStringProperty);
        }
        if (isLeaveChatRoomOnWindowCloseEnabledString != null && isLeaveChatRoomOnWindowCloseEnabledString.length() > 0) {
            isLeaveChatRoomOnWindowCloseEnabled = Boolean.parseBoolean(isLeaveChatRoomOnWindowCloseEnabledString);
        }
        if ((isHistoryShownString = configService.getString(isHistoryShownStringProperty = "service.gui.IS_MESSAGE_HISTORY_SHOWN")) == null) {
            isHistoryShownString = UtilActivator.getResources().getSettingsString(isHistoryShownStringProperty);
        }
        if (isHistoryShownString != null && isHistoryShownString.length() > 0) {
            isHistoryShown = Boolean.parseBoolean(isHistoryShownString);
        }
        isRecentMessagesShown = !configService.getBoolean("net.java.sip.communicator.service.msghistory.IS_RECENT_MESSAGES_DISABLED", !isRecentMessagesShown);
        String chatHistorySizeStringProperty = "service.gui.MESSAGE_HISTORY_SIZE";
        String chatHistorySizeString = configService.getString(chatHistorySizeStringProperty);
        if (chatHistorySizeString == null) {
            chatHistorySizeString = UtilActivator.getResources().getSettingsString(chatHistorySizeStringProperty);
        }
        if (chatHistorySizeString != null && chatHistorySizeString.length() > 0) {
            chatHistorySize = Integer.parseInt(chatHistorySizeString);
        }
        if ((chatWriteAreaSizeString = configService.getString(chatWriteAreaSizeStringProperty = "net.java.sip.communicator.impl.gui.CHAT_WRITE_AREA_SIZE")) == null) {
            chatWriteAreaSizeString = UtilActivator.getResources().getSettingsString(chatWriteAreaSizeStringProperty);
        }
        if (chatWriteAreaSizeString != null && chatWriteAreaSizeString.length() > 0) {
            chatWriteAreaSize = Integer.parseInt(chatWriteAreaSizeString);
        }
        if ((isTransparentWindowEnabledString = configService.getString(isTransparentWindowEnabledProperty = "impl.gui.IS_TRANSPARENT_WINDOW_ENABLED")) == null) {
            isTransparentWindowEnabledString = UtilActivator.getResources().getSettingsString(isTransparentWindowEnabledProperty);
        }
        if (isTransparentWindowEnabledString != null && isTransparentWindowEnabledString.length() > 0) {
            isTransparentWindowEnabled = Boolean.parseBoolean(isTransparentWindowEnabledString);
        }
        if ((windowTransparencyString = configService.getString(windowTransparencyProperty = "impl.gui.WINDOW_TRANSPARENCY")) == null) {
            windowTransparencyString = UtilActivator.getResources().getSettingsString(windowTransparencyProperty);
        }
        if (windowTransparencyString != null && windowTransparencyString.length() > 0) {
            windowTransparency = Integer.parseInt(windowTransparencyString);
        }
        if ((isWindowDecoratedString = configService.getString(isWindowDecoratedProperty = "impl.gui.IS_WINDOW_DECORATED")) == null) {
            isWindowDecoratedString = UtilActivator.getResources().getSettingsString(isWindowDecoratedProperty);
        }
        if (isWindowDecoratedString != null && isWindowDecoratedString.length() > 0) {
            isWindowDecorated = Boolean.parseBoolean(isWindowDecoratedString);
        }
        isChatToolbarVisible = configService.getBoolean("net.java.sip.communicator.impl.gui.chat.ChatWindow.showToolbar", true);
        isChatStylebarVisible = configService.getBoolean("net.java.sip.communicator.impl.gui.chat.ChatWindow.showStylebar", true);
        isShowSmileys = configService.getBoolean(SHOW_SMILEYS_PROPERTY, true);
        isChatSimpleThemeEnabled = configService.getBoolean(CHAT_SIMPLE_THEME_ENABLED_PROP, true);
        lastContactParent = configService.getString("net.java.sip.communicator.impl.gui.addcontact.lastContactParent");
        sendFileLastDir = configService.getString("net.java.sip.communicator.impl.gui.chat.filetransfer.SEND_FILE_LAST_DIR");
        isAddContactDisabled = configService.getBoolean("net.java.sip.communicator.impl.gui.main.contactlist.CONTACT_ADD_DISABLED", false);
        isMergeContactDisabled = configService.getBoolean("net.java.sip.communicator.impl.gui.main.contactlist.CONTACT_MERGE_DISABLED", false);
        isCreateGroupDisabled = configService.getBoolean("net.java.sip.communicator.impl.gui.main.contactlist.CREATE_GROUP_DISABLED", false);
        isFlattenGroupEnabled = configService.getBoolean("net.java.sip.communicator.impl.gui.main.contactlist.FLATTEN_GROUP_ENABLED", false);
        isGoToChatroomDisabled = configService.getBoolean("net.java.sip.communicator.impl.gui.main.chatroomslist.GO_TO_CHATROOM_DISABLED", false);
        isRemoveContactDisabled = configService.getBoolean("net.java.sip.communicator.impl.gui.main.contactlist.CONTACT_REMOVE_DISABLED", false);
        isContactMoveDisabled = configService.getBoolean("net.java.sip.communicator.impl.gui.main.contactlist.CONTACT_MOVE_DISABLED", false);
        isContactRenameDisabled = configService.getBoolean("net.java.sip.communicator.impl.gui.main.contactlist.CONTACT_RENAME_DISABLED", false);
        isGroupRemoveDisabled = configService.getBoolean("net.java.sip.communicator.impl.gui.main.contactlist.GROUP_REMOVE_DISABLED", false);
        isGroupRenameDisabled = configService.getBoolean("net.java.sip.communicator.impl.gui.main.contactlist.GROUP_RENAME_DISABLED", false);
        isPresetStatusMessagesEnabled = configService.getBoolean("net.java.sip.communicator.impl.gui.main.presence.PRESET_STATUS_MESSAGES", true);
        String advancedConfigDisabledDefaultProp = UtilActivator.getResources().getSettingsString("impl.gui.main.account.ADVANCED_CONFIG_DISABLED");
        boolean isAdvancedConfigDisabled = false;
        if (advancedConfigDisabledDefaultProp != null) {
            isAdvancedConfigDisabled = Boolean.parseBoolean(advancedConfigDisabledDefaultProp);
        }
        isAdvancedAccountConfigDisabled = configService.getBoolean("net.java.sip.communicator.impl.gui.main.account.ADVANCED_CONFIG_DISABLED", isAdvancedConfigDisabled);
        String singleInterfaceEnabledProp = UtilActivator.getResources().getSettingsString(SINGLE_WINDOW_INTERFACE_ENABLED);
        boolean isEnabled = false;
        isEnabled = singleInterfaceEnabledProp != null ? Boolean.parseBoolean(singleInterfaceEnabledProp) : Boolean.parseBoolean(UtilActivator.getResources().getSettingsString("impl.gui.SINGLE_WINDOW_INTERFACE"));
        isSingleWindowInterfaceEnabled = configService.getBoolean(SINGLE_WINDOW_INTERFACE_ENABLED, isEnabled);
        if (ConfigurationUtils.isFontSupportEnabled()) {
            defaultFontFamily = configService.getString("net.java.sip.communicator.impl.gui.chat.DEFAULT_FONT_FAMILY");
            defaultFontSize = configService.getString("net.java.sip.communicator.impl.gui.chat.DEFAULT_FONT_SIZE");
            isDefaultFontBold = configService.getBoolean("net.java.sip.communicator.impl.gui.chat.DEFAULT_FONT_BOLD", isDefaultFontBold);
            isDefaultFontItalic = configService.getBoolean("net.java.sip.communicator.impl.gui.chat.DEFAULT_FONT_ITALIC", isDefaultFontItalic);
            isDefaultFontUnderline = configService.getBoolean("net.java.sip.communicator.impl.gui.chat.DEFAULT_FONT_UNDERLINE", isDefaultFontUnderline);
            int colorSetting = configService.getInt("net.java.sip.communicator.impl.gui.chat.DEFAULT_FONT_COLOR", -1);
            if (colorSetting != -1) {
                defaultFontColor = colorSetting;
            }
        }
        String showStatusChangedInChatProperty = "impl.gui.SHOW_STATUS_CHANGED_IN_CHAT";
        String showStatusChangedInChatDefault = UtilActivator.getResources().getSettingsString(showStatusChangedInChatProperty);
        if (showStatusChangedInChatDefault != null) {
            showStatusChangedInChat = Boolean.parseBoolean(showStatusChangedInChatDefault);
        }
        showStatusChangedInChat = configService.getBoolean(showStatusChangedInChatProperty, showStatusChangedInChat);
        String routeVideoAndDesktopUsingPhoneNumberProperty = "impl.gui.ROUTE_VIDEO_AND_DESKTOP_TO_PNONENUMBER";
        String routeVideoAndDesktopUsingPhoneNumberDefault = UtilActivator.getResources().getSettingsString(routeVideoAndDesktopUsingPhoneNumberProperty);
        if (routeVideoAndDesktopUsingPhoneNumberDefault != null) {
            routeVideoAndDesktopUsingPhoneNumber = Boolean.parseBoolean(routeVideoAndDesktopUsingPhoneNumberDefault);
        }
        routeVideoAndDesktopUsingPhoneNumber = configService.getBoolean(routeVideoAndDesktopUsingPhoneNumberProperty, routeVideoAndDesktopUsingPhoneNumber);
        String hideAccountMenuProperty = "impl.gui.HIDE_SELECTION_ON_SINGLE_ACCOUNT";
        String hideAccountMenuDefaultValue = UtilActivator.getResources().getSettingsString(hideAccountMenuProperty);
        if (hideAccountMenuDefaultValue != null) {
            hideAccountSelectionWhenPossible = Boolean.parseBoolean(hideAccountMenuDefaultValue);
        }
        hideAccountSelectionWhenPossible = configService.getBoolean(hideAccountMenuProperty, hideAccountSelectionWhenPossible);
        String hideAccountStatusSelectorsProperty = "impl.gui.HIDE_ACCOUNT_STATUS_SELECTORS";
        String hideAccountsStatusDefaultValue = UtilActivator.getResources().getSettingsString(hideAccountStatusSelectorsProperty);
        if (hideAccountsStatusDefaultValue != null) {
            hideAccountStatusSelectors = Boolean.parseBoolean(hideAccountsStatusDefaultValue);
        }
        hideAccountStatusSelectors = configService.getBoolean(hideAccountStatusSelectorsProperty, hideAccountStatusSelectors);
        String autoAnswerDisableSubmenuProperty = "impl.gui.AUTO_ANSWER_DISABLE_SUBMENU";
        String autoAnswerDisableSubmenuDefaultValue = UtilActivator.getResources().getSettingsString(autoAnswerDisableSubmenuProperty);
        if (autoAnswerDisableSubmenuDefaultValue != null) {
            autoAnswerDisableSubmenu = Boolean.parseBoolean(autoAnswerDisableSubmenuDefaultValue);
        }
        autoAnswerDisableSubmenu = configService.getBoolean(autoAnswerDisableSubmenuProperty, autoAnswerDisableSubmenu);
        isChatRoomConfigDisabled = configService.getBoolean(CHAT_ROOM_CONFIG_DISABLED_PROP, isChatRoomConfigDisabled);
        isNormalizePhoneNumber = configService.getBoolean("impl.gui.NORMALIZE_PHONE_NUMBER", true);
        alerterEnabled = configService.getBoolean(ALERTER_ENABLED_PROP, true);
        acceptPhoneNumberWithAlphaChars = configService.getBoolean("impl.gui.ACCEPT_PHONE_NUMBER_WITH_ALPHA_CHARS", true);
        isHideAddressInCallHistoryTooltipEnabled = configService.getBoolean(HIDE_ADDR_IN_CALL_HISTORY_TOOLTIP_PROPERTY, isHideAddressInCallHistoryTooltipEnabled);
        isHideDomainInReceivedCallDialogEnabled = configService.getBoolean(HIDE_DOMAIN_IN_RECEIEVE_CALL_DIALOG_PROPERTY, isHideDomainInReceivedCallDialogEnabled);
        String hideExtendedAwayStatusProperty = "net.java.sip.communicator.service.protocol.globalstatus.HIDE_EXTENDED_AWAY_STATUS";
        String hideExtendedAwayStatusDefaultValue = UtilActivator.getResources().getSettingsString(hideExtendedAwayStatusProperty);
        if (hideExtendedAwayStatusDefaultValue != null) {
            hideExtendedAwayStatus = Boolean.parseBoolean(hideExtendedAwayStatusDefaultValue);
        }
        hideExtendedAwayStatus = configService.getBoolean(hideExtendedAwayStatusProperty, hideExtendedAwayStatus);
        isSmsNotifyTextDisabled = configService.getBoolean(SMS_MSG_NOTIFY_TEXT_DISABLED_PROP, isSmsNotifyTextDisabled);
        showMasterPasswordWarning = configService.getBoolean(MASTER_PASS_WARNING_PROP, true);
    }

    private static boolean isPinnedToTaskBar() {
        if (!OSUtils.IS_WINDOWS) {
            return false;
        }
        File taskbar = new File(System.getenv("appdata"), "Microsoft\\Internet Explorer\\Quick Launch\\User Pinned\\TaskBar");
        if (!taskbar.exists()) {
            return false;
        }
        File[] pins = taskbar.listFiles(new FileFilter(){

            @Override
            public boolean accept(File f) {
                return f.getName().endsWith(".lnk");
            }
        });
        String title = UtilActivator.getResources().getSettingsString("service.gui.APPLICATION_NAME");
        for (File pin : pins) {
            if (!pin.getName().contains(title)) continue;
            return true;
        }
        return false;
    }

    public static boolean isFontSupportEnabled() {
        String fontDisabledProp = "net.java.sip.communicator.impl.gui.FONT_SUPPORT_ENABLED";
        boolean defaultValue = false;
        String defaultSettingStr = UtilActivator.getResources().getSettingsString(fontDisabledProp);
        if (defaultSettingStr != null) {
            defaultValue = Boolean.parseBoolean(defaultSettingStr);
        }
        return configService.getBoolean(fontDisabledProp, defaultValue);
    }

    public static boolean isAutoPopupNewMessage() {
        return autoPopupNewMessage;
    }

    public static void setAutoPopupNewMessage(boolean autoPopup) {
        autoPopupNewMessage = autoPopup;
        if (autoPopupNewMessage) {
            configService.setProperty("service.gui.AUTO_POPUP_NEW_MESSAGE", (Object)"yes");
        } else {
            configService.setProperty("service.gui.AUTO_POPUP_NEW_MESSAGE", (Object)"no");
        }
    }

    public static boolean isCallPanelShown() {
        return isCallPanelShown;
    }

    public static boolean isShowOffline() {
        return isShowOffline;
    }

    public static boolean isApplicationVisible() {
        return isApplicationVisible;
    }

    public static boolean isMinimizeInsteadOfHide() {
        return minimizeInsteadOfHide;
    }

    public static void setIsMinimizeInsteadOfHide(boolean value) {
        minimizeInsteadOfHide = value;
        configService.setProperty("net.java.sip.communicator.impl.gui.minimizeInsteadOfHide", (Object)value);
    }

    public static boolean isQuitWarningShown() {
        return isQuitWarningShown;
    }

    public static boolean isSendTypingNotifications() {
        return isSendTypingNotifications;
    }

    public static void setSendTypingNotifications(boolean isSendTypingNotif) {
        isSendTypingNotifications = isSendTypingNotif;
        configService.setProperty("service.gui.SEND_TYPING_NOTIFICATIONS_ENABLED", (Object)Boolean.toString(isSendTypingNotif));
    }

    public static boolean isMoveContactConfirmationRequested() {
        return isMoveContactConfirmationRequested;
    }

    public static boolean isMultiChatWindowEnabled() {
        return isMultiChatWindowEnabled;
    }

    public static boolean isPrivateMessagingInChatRoomDisabled() {
        return isPrivateMessagingInChatRoomDisabled;
    }

    public static void setMultiChatWindowEnabled(boolean isEnabled) {
        isMultiChatWindowEnabled = isEnabled;
        configService.setProperty("service.gui.IS_MULTI_CHAT_WINDOW_ENABLED", (Object)Boolean.toString(isMultiChatWindowEnabled));
    }

    public static boolean isLeaveChatRoomOnWindowCloseEnabled() {
        return isLeaveChatRoomOnWindowCloseEnabled;
    }

    public static void setLeaveChatRoomOnWindowClose(boolean isLeave) {
        isLeaveChatRoomOnWindowCloseEnabled = isLeave;
        configService.setProperty("service.gui.LEAVE_CHATROOM_ON_WINDOW_CLOSE", (Object)Boolean.toString(isLeaveChatRoomOnWindowCloseEnabled));
    }

    @Deprecated
    public static boolean isHistoryLoggingEnabled() {
        return configService.getBoolean("net.java.sip.communicator.service.msghistory.IS_MESSAGE_HISTORY_ENABLED", true);
    }

    @Deprecated
    public static boolean isHistoryLoggingEnabled(String id) {
        return ConfigurationUtils.isHistoryLoggingEnabled();
    }

    public static boolean isHistoryShown() {
        return isHistoryShown;
    }

    public static boolean isRecentMessagesShown() {
        return isRecentMessagesShown;
    }

    public static void setHistoryShown(boolean isShown) {
        isHistoryShown = isShown;
        configService.setProperty("service.gui.IS_MESSAGE_HISTORY_SHOWN", (Object)Boolean.toString(isHistoryShown));
    }

    public static void setRecentMessagesShown(boolean isShown) {
        isRecentMessagesShown = isShown;
        configService.setProperty("net.java.sip.communicator.service.msghistory.IS_RECENT_MESSAGES_DISABLED", (Object)Boolean.toString(!isRecentMessagesShown));
    }

    public static boolean isWindowDecorated() {
        return isWindowDecorated;
    }

    public static boolean isChatToolbarVisible() {
        return isChatToolbarVisible;
    }

    public static boolean isChatStylebarVisible() {
        return isChatStylebarVisible;
    }

    public static boolean isShowSmileys() {
        return isShowSmileys;
    }

    public static boolean isChatSimpleThemeEnabled() {
        return isChatSimpleThemeEnabled;
    }

    public static boolean isAddContactDisabled() {
        return isAddContactDisabled;
    }

    public static boolean isMergeContactDisabled() {
        return isMergeContactDisabled;
    }

    public static boolean isCreateGroupDisabled() {
        return isCreateGroupDisabled;
    }

    public static boolean isFlattenGroupEnabled() {
        return isFlattenGroupEnabled;
    }

    public static boolean isGoToChatroomDisabled() {
        return isGoToChatroomDisabled;
    }

    public static boolean isRemoveContactDisabled() {
        return isRemoveContactDisabled;
    }

    public static boolean isContactMoveDisabled() {
        return isContactMoveDisabled;
    }

    public static boolean isContactRenameDisabled() {
        return isContactRenameDisabled;
    }

    public static boolean isGroupRemoveDisabled() {
        return isGroupRemoveDisabled;
    }

    public static boolean isGroupRenameDisabled() {
        return isGroupRenameDisabled;
    }

    public static boolean isPresetStatusMessagesEnabled() {
        return isPresetStatusMessagesEnabled;
    }

    public static boolean isAdvancedAccountConfigDisabled() {
        return isAdvancedAccountConfigDisabled;
    }

    public static boolean isChatRoomConfigDisabled() {
        return isChatRoomConfigDisabled;
    }

    public static String getChatDefaultFontFamily() {
        return defaultFontFamily;
    }

    public static int getChatDefaultFontSize() {
        if (defaultFontSize != null && defaultFontSize.length() > 0) {
            return Integer.parseInt(defaultFontSize);
        }
        return -1;
    }

    public static Color getChatDefaultFontColor() {
        return defaultFontColor == -1 ? null : new Color(defaultFontColor);
    }

    public static boolean isChatFontBold() {
        return isDefaultFontBold;
    }

    public static boolean isChatFontItalic() {
        return isDefaultFontItalic;
    }

    public static boolean isChatFontUnderline() {
        return isDefaultFontUnderline;
    }

    public static void setAdvancedAccountConfigDisabled(boolean disabled) {
        isAdvancedAccountConfigDisabled = disabled;
        configService.setProperty("net.java.sip.communicator.impl.gui.main.account.ADVANCED_CONFIG_DISABLED", (Object)Boolean.toString(isAdvancedAccountConfigDisabled));
    }

    public static String getSendMessageCommand() {
        return sendMessageCommand;
    }

    public static void setSendMessageCommand(String newMessageCommand) {
        sendMessageCommand = newMessageCommand;
        configService.setProperty("service.gui.SEND_MESSAGE_COMMAND", (Object)newMessageCommand);
    }

    public static String getLastContactParent() {
        return lastContactParent;
    }

    public static ProtocolProviderService getLastCallConferenceProvider() {
        if (lastCallConferenceProvider != null) {
            return lastCallConferenceProvider;
        }
        return ConfigurationUtils.findProviderFromAccountId(configService.getString("net.java.sip.communicator.impl.gui.call.lastCallConferenceProvider"));
    }

    private static ProtocolProviderService findProviderFromAccountId(String savedAccountId) {
        ProtocolProviderService protocolProvider = null;
        for (ProtocolProviderFactory providerFactory : UtilActivator.getProtocolProviderFactories().values()) {
            ServiceReference serRef;
            AccountID accountId;
            Iterator iterator = providerFactory.getRegisteredAccounts().iterator();
            while (iterator.hasNext() && (!(accountId = (AccountID)iterator.next()).getAccountUniqueID().equals(savedAccountId) || (protocolProvider = (ProtocolProviderService)UtilActivator.bundleContext.getService(serRef = providerFactory.getProviderForAccount(accountId))) == null)) {
            }
        }
        return protocolProvider;
    }

    public static int getChatHistorySize() {
        return chatHistorySize;
    }

    public static void setChatHistorySize(int historySize) {
        chatHistorySize = historySize;
        configService.setProperty("service.gui.MESSAGE_HISTORY_SIZE", (Object)Integer.toString(chatHistorySize));
    }

    public static int getChatWriteAreaSize() {
        return chatWriteAreaSize;
    }

    public static boolean isTransparentWindowEnabled() {
        return isTransparentWindowEnabled;
    }

    public static int getWindowTransparency() {
        return windowTransparency;
    }

    public static String getSendFileLastDir() {
        return sendFileLastDir;
    }

    public static boolean isNormalizePhoneNumber() {
        return isNormalizePhoneNumber;
    }

    public static void setNormalizePhoneNumber(boolean isNormalize) {
        isNormalizePhoneNumber = isNormalize;
        configService.setProperty("impl.gui.NORMALIZE_PHONE_NUMBER", (Object)Boolean.toString(isNormalize));
    }

    public static boolean isAlerterEnabled() {
        return alerterEnabled;
    }

    public static void setAlerterEnabled(boolean isEnabled) {
        alerterEnabled = isEnabled;
        configService.setProperty(ALERTER_ENABLED_PROP, (Object)Boolean.toString(isEnabled));
    }

    public static boolean acceptPhoneNumberWithAlphaChars() {
        return acceptPhoneNumberWithAlphaChars;
    }

    public static void setAcceptPhoneNumberWithAlphaChars(boolean accept) {
        acceptPhoneNumberWithAlphaChars = accept;
        configService.setProperty("impl.gui.ACCEPT_PHONE_NUMBER_WITH_ALPHA_CHARS", (Object)Boolean.toString(acceptPhoneNumberWithAlphaChars));
    }

    public static boolean isShowStatusChangedInChat() {
        return showStatusChangedInChat;
    }

    public static boolean isRouteVideoAndDesktopUsingPhoneNumberEnabled() {
        return routeVideoAndDesktopUsingPhoneNumber;
    }

    public static boolean isHideAccountSelectionWhenPossibleEnabled() {
        return hideAccountSelectionWhenPossible;
    }

    public static boolean isHideAccountStatusSelectorsEnabled() {
        return hideAccountStatusSelectors;
    }

    public static boolean isHideExtendedAwayStatus() {
        return hideExtendedAwayStatus;
    }

    public static boolean isAutoAnswerDisableSubmenu() {
        return autoAnswerDisableSubmenu;
    }

    public static boolean isSingleWindowInterfaceEnabled() {
        return isSingleWindowInterfaceEnabled;
    }

    public static boolean isHideAddressInCallHistoryTooltipEnabled() {
        return isHideAddressInCallHistoryTooltipEnabled;
    }

    public static boolean isSmsNotifyTextDisabled() {
        return isSmsNotifyTextDisabled;
    }

    public static boolean isHideDomainInReceivedCallDialogEnabled() {
        return isHideDomainInReceivedCallDialogEnabled;
    }

    public static boolean showMasterPasswordWarning() {
        return showMasterPasswordWarning;
    }

    public static void setShowMasterPasswordWarning(boolean value) {
        showMasterPasswordWarning = value;
        configService.setProperty(MASTER_PASS_WARNING_PROP, (Object)value);
    }

    public static void setSingleWindowInterfaceEnabled(boolean isEnabled) {
        isSingleWindowInterfaceEnabled = isEnabled;
        configService.setProperty(SINGLE_WINDOW_INTERFACE_ENABLED, (Object)isEnabled);
    }

    public static void setWindowTransparency(int transparency) {
        windowTransparency = transparency;
    }

    public static void setShowOffline(boolean isShowOffline) {
        ConfigurationUtils.isShowOffline = isShowOffline;
        configService.setProperty("net.java.sip.communicator.impl.gui.showOffline", (Object)Boolean.toString(isShowOffline));
    }

    public static void setShowCallPanel(boolean isCallPanelShown) {
        ConfigurationUtils.isCallPanelShown = isCallPanelShown;
        configService.setProperty("net.java.sip.communicator.impl.gui.showCallPanel", (Object)Boolean.toString(isCallPanelShown));
    }

    public static void setApplicationVisible(boolean isVisible) {
        if (isApplicationVisible == isVisible) {
            return;
        }
        isApplicationVisible = isVisible;
        configService.setProperty("net.java.sip.communicator.impl.systray.showApplication", (Object)Boolean.toString(isVisible));
    }

    public static void setQuitWarningShown(boolean isWarningShown) {
        isQuitWarningShown = isWarningShown;
        configService.setProperty("net.java.sip.communicator.impl.gui.quitWarningShown", (Object)Boolean.toString(isQuitWarningShown));
    }

    public static void setPopupHandlerConfig(String handler) {
        configService.setProperty("systray.POPUP_HANDLER", (Object)handler);
    }

    public static void setLastContactParent(String groupName) {
        lastContactParent = groupName;
        configService.setProperty("net.java.sip.communicator.impl.gui.addcontact.lastContactParent", (Object)groupName);
    }

    public static void setMoveContactConfirmationRequested(boolean isRequested) {
        isMoveContactConfirmationRequested = isRequested;
        configService.setProperty("net.java.sip.communicator.impl.gui.isMoveContactConfirmationRequested", (Object)Boolean.toString(isMoveContactConfirmationRequested));
    }

    public static void setTransparentWindowEnabled(boolean isTransparent) {
        isTransparentWindowEnabled = isTransparent;
        configService.setProperty("impl.gui.IS_TRANSPARENT_WINDOW_ENABLED", (Object)Boolean.toString(isTransparentWindowEnabled));
    }

    public static void setChatToolbarVisible(boolean isVisible) {
        isChatToolbarVisible = isVisible;
        configService.setProperty("net.java.sip.communicator.impl.gui.chat.ChatWindow.showToolbar", (Object)Boolean.toString(isChatToolbarVisible));
    }

    public static void setShowSmileys(boolean isVisible) {
        isShowSmileys = isVisible;
        configService.setProperty(SHOW_SMILEYS_PROPERTY, (Object)Boolean.toString(isShowSmileys));
    }

    public static void setChatSimpleThemeEnabled(boolean isEnabled) {
        isChatSimpleThemeEnabled = isEnabled;
        configService.setProperty(CHAT_SIMPLE_THEME_ENABLED_PROP, (Object)Boolean.toString(isChatSimpleThemeEnabled));
    }

    public static void setChatStylebarVisible(boolean isVisible) {
        isChatStylebarVisible = isVisible;
        configService.setProperty("net.java.sip.communicator.impl.gui.chat.ChatWindow.showStylebar", (Object)Boolean.toString(isChatStylebarVisible));
    }

    public static void setChatWriteAreaSize(int size) {
        chatWriteAreaSize = size;
        configService.setProperty("net.java.sip.communicator.impl.gui.CHAT_WRITE_AREA_SIZE", (Object)Integer.toString(chatWriteAreaSize));
    }

    public static void setSendFileLastDir(String lastDir) {
        sendFileLastDir = lastDir;
        configService.setProperty("net.java.sip.communicator.impl.gui.chat.filetransfer.SEND_FILE_LAST_DIR", (Object)lastDir);
    }

    public static void setLastCallConferenceProvider(ProtocolProviderService protocolProvider) {
        lastCallConferenceProvider = protocolProvider;
        configService.setProperty("net.java.sip.communicator.impl.gui.call.lastCallConferenceProvider", (Object)protocolProvider.getAccountID().getAccountUniqueID());
    }

    public static void setChatDefaultFontFamily(String fontFamily) {
        defaultFontFamily = fontFamily;
        configService.setProperty("net.java.sip.communicator.impl.gui.chat.DEFAULT_FONT_FAMILY", (Object)fontFamily);
    }

    public static void setChatDefaultFontSize(int fontSize) {
        defaultFontSize = String.valueOf(fontSize);
        configService.setProperty("net.java.sip.communicator.impl.gui.chat.DEFAULT_FONT_SIZE", (Object)fontSize);
    }

    public static void setChatFontIsBold(boolean isBold) {
        isDefaultFontBold = isBold;
        configService.setProperty("net.java.sip.communicator.impl.gui.chat.DEFAULT_FONT_BOLD", (Object)isBold);
    }

    public static void setChatFontIsItalic(boolean isItalic) {
        isDefaultFontItalic = isItalic;
        configService.setProperty("net.java.sip.communicator.impl.gui.chat.DEFAULT_FONT_ITALIC", (Object)isItalic);
    }

    public static void setChatFontIsUnderline(boolean isUnderline) {
        isDefaultFontUnderline = isUnderline;
        configService.setProperty("net.java.sip.communicator.impl.gui.chat.DEFAULT_FONT_UNDERLINE", (Object)isUnderline);
    }

    public static void setChatDefaultFontColor(Color fontColor) {
        defaultFontColor = fontColor.getRGB();
        configService.setProperty("net.java.sip.communicator.impl.gui.chat.DEFAULT_FONT_COLOR", (Object)defaultFontColor);
    }

    public static Locale getCurrentLanguage() {
        String localeId = configService.getString("net.java.sip.communicator.service.resources.DefaultLocale");
        return localeId != null ? ResourceManagementServiceUtils.getLocale((String)localeId) : Locale.getDefault();
    }

    public static void setLanguage(Locale locale) {
        String language = locale.getLanguage();
        String country = locale.getCountry();
        configService.setProperty("net.java.sip.communicator.service.resources.DefaultLocale", (Object)(country.length() > 0 ? language + '_' + country : language));
    }

    public static void saveChatRoom(ProtocolProviderService protocolProvider, String oldChatRoomId, String newChatRoomId, String newChatRoomName) {
        String prefix = "net.java.sip.communicator.impl.gui.accounts";
        List accounts = configService.getPropertyNamesByPrefix(prefix, true);
        for (String accountRootPropName : accounts) {
            String accountUID = configService.getString(accountRootPropName);
            if (!accountUID.equals(protocolProvider.getAccountID().getAccountUniqueID())) continue;
            List chatRooms = configService.getPropertyNamesByPrefix(accountRootPropName + ".chatRooms", true);
            boolean isExistingChatRoom = false;
            for (String chatRoomPropName : chatRooms) {
                String chatRoomID = configService.getString(chatRoomPropName);
                if (!oldChatRoomId.equals(chatRoomID)) continue;
                isExistingChatRoom = true;
                configService.setProperty(chatRoomPropName, (Object)newChatRoomId);
                configService.setProperty(chatRoomPropName + ".chatRoomName", (Object)newChatRoomName);
            }
            if (isExistingChatRoom) continue;
            String chatRoomNodeName = "chatRoom" + Long.toString(System.currentTimeMillis());
            String chatRoomPackage = accountRootPropName + ".chatRooms." + chatRoomNodeName;
            configService.setProperty(chatRoomPackage, (Object)newChatRoomId);
            configService.setProperty(chatRoomPackage + ".chatRoomName", (Object)newChatRoomName);
        }
    }

    public static void updateChatRoomStatus(ProtocolProviderService protocolProvider, String chatRoomId, String chatRoomStatus) {
        String prefix = "net.java.sip.communicator.impl.gui.accounts";
        List accounts = configService.getPropertyNamesByPrefix(prefix, true);
        for (String accountRootPropName : accounts) {
            String accountUID = configService.getString(accountRootPropName);
            if (!accountUID.equals(protocolProvider.getAccountID().getAccountUniqueID())) continue;
            List chatRooms = configService.getPropertyNamesByPrefix(accountRootPropName + ".chatRooms", true);
            for (String chatRoomPropName : chatRooms) {
                String chatRoomID = configService.getString(chatRoomPropName);
                if (!chatRoomId.equals(chatRoomID)) continue;
                configService.setProperty(chatRoomPropName + ".lastChatRoomStatus", (Object)chatRoomStatus);
            }
        }
    }

    public static void updateChatRoomProperty(ProtocolProviderService protocolProvider, String chatRoomId, String property, String value) {
        String prefix = "net.java.sip.communicator.impl.gui.accounts";
        List accounts = configService.getPropertyNamesByPrefix(prefix, true);
        for (String accountRootPropName : accounts) {
            String accountUID = configService.getString(accountRootPropName);
            if (!accountUID.equals(protocolProvider.getAccountID().getAccountUniqueID())) continue;
            List chatRooms = configService.getPropertyNamesByPrefix(accountRootPropName + ".chatRooms", true);
            for (String chatRoomPropName : chatRooms) {
                String chatRoomID = configService.getString(chatRoomPropName);
                if (!chatRoomId.equals(chatRoomID)) continue;
                if (value != null) {
                    configService.setProperty(chatRoomPropName + "." + property, (Object)value);
                    continue;
                }
                configService.removeProperty(chatRoomPropName + "." + property);
            }
        }
    }

    public static String getChatRoomProperty(ProtocolProviderService protocolProvider, String chatRoomId, String property) {
        String prefix = "net.java.sip.communicator.impl.gui.accounts";
        List accounts = configService.getPropertyNamesByPrefix(prefix, true);
        for (String accountRootPropName : accounts) {
            String accountUID = configService.getString(accountRootPropName);
            if (!accountUID.equals(protocolProvider.getAccountID().getAccountUniqueID())) continue;
            List chatRooms = configService.getPropertyNamesByPrefix(accountRootPropName + ".chatRooms", true);
            for (String chatRoomPropName : chatRooms) {
                String chatRoomID = configService.getString(chatRoomPropName);
                if (!chatRoomId.equals(chatRoomID)) continue;
                return configService.getString(chatRoomPropName + "." + property);
            }
        }
        return null;
    }

    public static String getChatRoomPrefix(String accountID, String chatRoomId) {
        String prefix = "net.java.sip.communicator.impl.gui.accounts";
        List accounts = configService.getPropertyNamesByPrefix(prefix, true);
        for (String accountRootPropName : accounts) {
            String tmpAccountID = configService.getString(accountRootPropName);
            if (!tmpAccountID.equals(accountID)) continue;
            List chatRooms = configService.getPropertyNamesByPrefix(accountRootPropName + ".chatRooms", true);
            for (String chatRoomPropName : chatRooms) {
                String tmpChatRoomID = configService.getString(chatRoomPropName);
                if (!tmpChatRoomID.equals(chatRoomId)) continue;
                return chatRoomPropName;
            }
        }
        return null;
    }

    public static String getChatRoomStatus(ProtocolProviderService protocolProvider, String chatRoomId) {
        String prefix = "net.java.sip.communicator.impl.gui.accounts";
        List accounts = configService.getPropertyNamesByPrefix(prefix, true);
        for (String accountRootPropName : accounts) {
            String accountUID = configService.getString(accountRootPropName);
            if (!accountUID.equals(protocolProvider.getAccountID().getAccountUniqueID())) continue;
            List chatRooms = configService.getPropertyNamesByPrefix(accountRootPropName + ".chatRooms", true);
            for (String chatRoomPropName : chatRooms) {
                String chatRoomID = configService.getString(chatRoomPropName);
                if (!chatRoomId.equals(chatRoomID)) continue;
                return configService.getString(chatRoomPropName + ".lastChatRoomStatus");
            }
        }
        return null;
    }

    public static void setContactListGroupCollapsed(String groupID, boolean isCollapsed) {
        String prefix = "net.java.sip.communicator.impl.gui.contactlist.groups";
        List groups = configService.getPropertyNamesByPrefix(prefix, true);
        boolean isExistingGroup = false;
        for (String groupRootPropName : groups) {
            String storedID = configService.getString(groupRootPropName);
            if (!storedID.equals(groupID)) continue;
            configService.setProperty(groupRootPropName + ".isClosed", (Object)Boolean.toString(isCollapsed));
            isExistingGroup = true;
            break;
        }
        if (!isExistingGroup) {
            String groupNodeName = "group" + Long.toString(System.currentTimeMillis());
            String groupPackage = prefix + "." + groupNodeName;
            configService.setProperty(groupPackage, (Object)groupID);
            configService.setProperty(groupPackage + ".isClosed", (Object)Boolean.toString(isCollapsed));
        }
    }

    public static boolean isContactListGroupCollapsed(String groupID) {
        String prefix = "net.java.sip.communicator.impl.gui.contactlist.groups";
        List groups = configService.getPropertyNamesByPrefix(prefix, true);
        for (String groupRootPropName : groups) {
            String storedID = configService.getString(groupRootPropName);
            if (!storedID.equals(groupID)) continue;
            String status = (String)configService.getProperty(groupRootPropName + ".isClosed");
            return Boolean.parseBoolean(status);
        }
        return false;
    }

    public static boolean isShowAccountConfig() {
        String SHOW_ACCOUNT_CONFIG_PROP = "net.java.sip.communicator.impl.gui.main.configforms.SHOW_ACCOUNT_CONFIG";
        boolean defaultValue = !Boolean.parseBoolean(UtilActivator.getResources().getSettingsString("impl.gui.main.account.ACCOUNT_CONFIG_DISABLED"));
        Boolean showAccountConfigProp = configService.getBoolean("net.java.sip.communicator.impl.gui.main.configforms.SHOW_ACCOUNT_CONFIG", defaultValue);
        return showAccountConfigProp;
    }

    public static String getFactoryImplPackageName(ProtocolProviderFactory factory) {
        String className = factory.getClass().getName();
        return className.substring(0, className.lastIndexOf(46));
    }

    public static int getClientPort() {
        return configService.getInt("net.java.sip.communicator.SIP_PREFERRED_CLEAR_PORT", 5060);
    }

    public static void setClientPort(int port) {
        configService.setProperty("net.java.sip.communicator.SIP_PREFERRED_CLEAR_PORT", (Object)port);
    }

    public static int getClientSecurePort() {
        return configService.getInt("net.java.sip.communicator.SIP_PREFERRED_SECURE_PORT", 5061);
    }

    public static void setClientSecurePort(int port) {
        configService.setProperty("net.java.sip.communicator.SIP_PREFERRED_SECURE_PORT", (Object)port);
    }

    public static String[] getEnabledSslProtocols() {
        String enabledSslProtocols = configService.getString("gov.nist.javax.sip.TLS_CLIENT_PROTOCOLS");
        if (StringUtils.isBlank((CharSequence)enabledSslProtocols)) {
            try {
                SSLSocket temp = (SSLSocket)SSLSocketFactory.getDefault().createSocket();
                return temp.getEnabledProtocols();
            }
            catch (IOException e) {
                logger.error(e);
                return ConfigurationUtils.getAvailableSslProtocols();
            }
        }
        return enabledSslProtocols.split("(,)|(,\\s)");
    }

    public static String[] getAvailableSslProtocols() {
        try {
            SSLSocket temp = (SSLSocket)SSLSocketFactory.getDefault().createSocket();
            return temp.getSupportedProtocols();
        }
        catch (IOException e) {
            logger.error(e);
            return new String[0];
        }
    }

    public static void setEnabledSslProtocols(String[] enabledProtocols) {
        if (enabledProtocols == null || enabledProtocols.length == 0) {
            configService.removeProperty("gov.nist.javax.sip.TLS_CLIENT_PROTOCOLS");
        } else {
            String protocols = Arrays.toString(enabledProtocols);
            configService.setProperty("gov.nist.javax.sip.TLS_CLIENT_PROTOCOLS", (Object)protocols.substring(1, protocols.length() - 1));
        }
    }

    public static boolean hasEnabledVideoFormat(ProtocolProviderService protocolProvider) {
        EncodingConfiguration encodingConfiguration;
        Map accountProperties = protocolProvider.getAccountID().getAccountProperties();
        String overrideEncodings = (String)accountProperties.get("OVERRIDE_ENCODINGS");
        if (Boolean.parseBoolean(overrideEncodings)) {
            encodingConfiguration = UtilActivator.getMediaService().createEmptyEncodingConfiguration();
            encodingConfiguration.loadProperties(accountProperties, "Encodings");
        } else {
            encodingConfiguration = UtilActivator.getMediaService().getCurrentEncodingConfiguration();
        }
        return encodingConfiguration.hasEnabledFormat(MediaType.VIDEO);
    }

    static {
        isCallPanelShown = true;
        isShowOffline = true;
        isApplicationVisible = true;
        isQuitWarningShown = true;
        minimizeInsteadOfHide = false;
        isMoveContactConfirmationRequested = true;
        isRecentMessagesShown = true;
        configService = UtilActivator.getConfigurationService();
        lastContactParent = null;
        lastCallConferenceProvider = null;
        isDefaultFontBold = false;
        isDefaultFontItalic = false;
        isDefaultFontUnderline = false;
        defaultFontColor = -1;
        showStatusChangedInChat = false;
        routeVideoAndDesktopUsingPhoneNumber = false;
        hideAccountSelectionWhenPossible = false;
        hideAccountStatusSelectors = false;
        hideExtendedAwayStatus = false;
        autoAnswerDisableSubmenu = false;
        isChatRoomConfigDisabled = false;
        isSingleWindowInterfaceEnabled = false;
        isHideAddressInCallHistoryTooltipEnabled = false;
        isSmsNotifyTextDisabled = false;
        isHideDomainInReceivedCallDialogEnabled = false;
    }

    private static class ConfigurationChangeListener
    implements PropertyChangeListener {
        private ConfigurationChangeListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if (!(evt.getNewValue() instanceof String)) {
                return;
            }
            String newValue = (String)evt.getNewValue();
            if (evt.getPropertyName().equals("net.java.sip.communicator.impl.gui.addcontact.lastContactParent")) {
                lastContactParent = newValue;
            } else if (evt.getPropertyName().equals("service.gui.AUTO_POPUP_NEW_MESSAGE")) {
                if ("yes".equalsIgnoreCase(newValue)) {
                    autoPopupNewMessage = true;
                } else {
                    autoPopupNewMessage = false;
                }
            } else if (evt.getPropertyName().equals("service.gui.SEND_MESSAGE_COMMAND")) {
                sendMessageCommand = newValue;
            } else if (evt.getPropertyName().equals("net.java.sip.communicator.impl.gui.showCallPanel")) {
                isCallPanelShown = Boolean.parseBoolean(newValue);
            } else if (evt.getPropertyName().equals("net.java.sip.communicator.impl.gui.showOffline")) {
                isShowOffline = Boolean.parseBoolean(newValue);
            } else if (evt.getPropertyName().equals("net.java.sip.communicator.impl.systray.showApplication")) {
                isApplicationVisible = Boolean.parseBoolean(newValue);
            } else if (evt.getPropertyName().equals("net.java.sip.communicator.impl.gui.quitWarningShown")) {
                isQuitWarningShown = Boolean.parseBoolean(newValue);
            } else if (evt.getPropertyName().equals("service.gui.SEND_TYPING_NOTIFICATIONS_ENABLED")) {
                isSendTypingNotifications = Boolean.parseBoolean(newValue);
            } else if (evt.getPropertyName().equals("net.java.sip.communicator.impl.gui.isMoveContactConfirmationRequested")) {
                isMoveContactConfirmationRequested = Boolean.parseBoolean(newValue);
            } else if (evt.getPropertyName().equals("service.gui.IS_MULTI_CHAT_WINDOW_ENABLED")) {
                isMultiChatWindowEnabled = Boolean.parseBoolean(newValue);
            } else if (evt.getPropertyName().equals("service.gui.IS_PRIVATE_CHAT_IN_CHATROOM_DISABLED")) {
                isPrivateMessagingInChatRoomDisabled = Boolean.parseBoolean(newValue);
            } else if (evt.getPropertyName().equals("service.gui.LEAVE_CHATROOM_ON_WINDOW_CLOSE")) {
                isLeaveChatRoomOnWindowCloseEnabled = Boolean.parseBoolean(newValue);
            } else if (evt.getPropertyName().equals("service.gui.IS_MESSAGE_HISTORY_SHOWN")) {
                isHistoryShown = Boolean.parseBoolean(newValue);
            } else if (evt.getPropertyName().equals("service.gui.MESSAGE_HISTORY_SIZE")) {
                chatHistorySize = Integer.parseInt(newValue);
            } else if (evt.getPropertyName().equals("net.java.sip.communicator.impl.gui.CHAT_WRITE_AREA_SIZE")) {
                chatWriteAreaSize = Integer.parseInt(newValue);
            } else if (evt.getPropertyName().equals("impl.gui.IS_TRANSPARENT_WINDOW_ENABLED")) {
                isTransparentWindowEnabled = Boolean.parseBoolean(newValue);
            } else if (evt.getPropertyName().equals("impl.gui.WINDOW_TRANSPARENCY")) {
                windowTransparency = Integer.parseInt(newValue);
            } else if (evt.getPropertyName().equals("net.java.sip.communicator.impl.gui.chat.ChatWindow.showStylebar")) {
                isChatStylebarVisible = Boolean.parseBoolean(newValue);
            } else if (evt.getPropertyName().equals("net.java.sip.communicator.impl.gui.chat.ChatWindow.showToolbar")) {
                isChatToolbarVisible = Boolean.parseBoolean(newValue);
            } else if (evt.getPropertyName().equals("net.java.sip.communicator.impl.gui.call.lastCallConferenceProvider")) {
                lastCallConferenceProvider = ConfigurationUtils.findProviderFromAccountId(newValue);
            } else if (evt.getPropertyName().equals("impl.gui.SHOW_STATUS_CHANGED_IN_CHAT")) {
                showStatusChangedInChat = Boolean.parseBoolean(newValue);
            }
        }
    }
}

