
#include "nir.h"
#include "nir_builder.h"
#include "nir_search.h"
#include "nir_search_helpers.h"

/* What follows is NIR algebraic transform code for the following 2411
 * transforms:
 *    ('fgeu', 'a', 'b') => ('inot', ('flt', 'a', 'b'))
 *    ('fltu', 'a', 'b') => ('inot', ('fge', 'a', 'b'))
 *    ('fneo', 0.0, 'a') => ('flt', 0.0, ('fabs', 'a'))
 *    ('fequ', 0.0, 'a') => ('inot', ('flt', 0.0, ('fabs', 'a')))
 *    ('imul', 'a', '#b(is_pos_power_of_two)') => ('ishl', 'a', ('find_lsb', 'b'))
 *    ('imul', 'a@8', 128) => ('ishl', 'a', 7)
 *    ('imul', 'a@16', 32768) => ('ishl', 'a', 15)
 *    ('imul', 'a@32', 2147483648) => ('ishl', 'a', 31)
 *    ('imul', 'a@64', 9223372036854775808) => ('ishl', 'a', 63)
 *    ('imul', 'a', '#b(is_neg_power_of_two)') => ('ineg', ('ishl', 'a', ('find_lsb', ('iabs', 'b'))))
 *    ('ishl', 'a', '#b') => ('imul', 'a', ('ishl', 1, 'b'))
 *    ('imul@64', 'a', '#b(is_bitcount2)') => ('iadd', ('ishl', 'a', ('ufind_msb', 'b')), ('ishl', 'a', ('find_lsb', 'b')))
 *    ('unpack_64_2x32_split_x', ('imul_2x32_64(is_used_once)', 'a', 'b')) => ('imul', 'a', 'b')
 *    ('unpack_64_2x32_split_x', ('umul_2x32_64(is_used_once)', 'a', 'b')) => ('imul', 'a', 'b')
 *    ('imul_2x32_64', 'a', 'b') => ('pack_64_2x32_split', ('imul', 'a', 'b'), ('imul_high', 'a', 'b'))
 *    ('umul_2x32_64', 'a', 'b') => ('pack_64_2x32_split', ('imul', 'a', 'b'), ('umul_high', 'a', 'b'))
 *    ('udiv', 'a', 1) => a
 *    ('idiv', 'a', 1) => a
 *    ('umod', 'a', 1) => 0
 *    ('imod', 'a', 1) => 0
 *    ('imod', 'a', -1) => 0
 *    ('irem', 'a', 1) => 0
 *    ('irem', 'a', -1) => 0
 *    ('udiv', 'a', '#b(is_pos_power_of_two)') => ('ushr', 'a', ('find_lsb', 'b'))
 *    ('idiv', 'a', '#b(is_pos_power_of_two)') => ('imul', ('isign', 'a'), ('ushr', ('iabs', 'a'), ('find_lsb', 'b')))
 *    ('idiv', 'a', '#b(is_neg_power_of_two)') => ('ineg', ('imul', ('isign', 'a'), ('ushr', ('iabs', 'a'), ('find_lsb', ('iabs', 'b')))))
 *    ('umod', 'a', '#b(is_pos_power_of_two)') => ('iand', 'a', ('isub', 'b', 1))
 *    ('imod', 'a', '#b(is_pos_power_of_two)') => ('iand', 'a', ('isub', 'b', 1))
 *    ('imod', 'a', '#b(is_neg_power_of_two)') => ('bcsel', ('ieq', ('ior', 'a', 'b'), 'b'), 0, ('ior', 'a', 'b'))
 *    ('irem', 'a', '#b(is_pos_power_of_two)') => ('isub', 'a', ('iand', ('bcsel', ('ilt', 'a', 0), ('iadd', 'a', ('isub', 'b', 1)), 'a'), ('ineg', 'b')))
 *    ('irem', 'a', '#b(is_neg_power_of_two)') => ('irem', 'a', ('iabs', 'b'))
 *    ('~fmul', ('fsign', 'a'), ('ffloor', ('fadd', ('fabs', 'a'), 0.5))) => ('ftrunc', ('fadd', 'a', ('fmul', ('fsign', 'a'), 0.5)))
 *    ('~fneg', ('fneg', 'a')) => a
 *    ('ineg', ('ineg', 'a')) => a
 *    ('fabs', ('fneg', 'a')) => ('fabs', 'a')
 *    ('fabs', ('u2f', 'a')) => ('u2f', 'a')
 *    ('iabs', ('iabs', 'a')) => ('iabs', 'a')
 *    ('iabs', ('ineg', 'a')) => ('iabs', 'a')
 *    ('~fadd', 'a', 0.0) => a
 *    ('fadd(is_only_used_as_float,nsz)', 'a', 0.0) => a
 *    ('iadd', 'a', 0) => a
 *    ('iadd_sat', 'a', 0) => a
 *    ('isub_sat', 'a', 0) => a
 *    ('uadd_sat', 'a', 0) => a
 *    ('usub_sat', 'a', 0) => a
 *    ('usadd_4x8_vc4', 'a', 0) => a
 *    ('usadd_4x8_vc4', 'a', -1) => -1
 *    ('~fadd', ('fmul', 'a', 'b'), ('fmul', 'a', 'c')) => ('fmul', 'a', ('fadd', 'b', 'c'))
 *    ('~fadd', ('fmulz', 'a', 'b'), ('fmulz', 'a', 'c')) => ('fmulz', 'a', ('fadd', 'b', 'c'))
 *    ('~ffma', 'a', 'b', ('ffma(is_used_once)', 'a', 'c', 'd')) => ('ffma', 'a', ('fadd', 'b', 'c'), 'd')
 *    ('~ffma', 'a', 'b', ('fmul(is_used_once)', 'a', 'c')) => ('fmul', 'a', ('fadd', 'b', 'c'))
 *    ('~fadd', ('fmul(is_used_once)', 'a', 'b'), ('ffma(is_used_once)', 'a', 'c', 'd')) => ('ffma', 'a', ('fadd', 'b', 'c'), 'd')
 *    ('~ffma', 'a', ('fmul(is_used_once)', 'b', 'c'), ('fmul(is_used_once)', 'b', 'd')) => ('fmul', 'b', ('ffma', 'a', 'c', 'd'))
 *    ('~ffmaz', 'a', 'b', ('ffmaz(is_used_once)', 'a', 'c', 'd')) => ('ffmaz', 'a', ('fadd', 'b', 'c'), 'd')
 *    ('~ffmaz', 'a', 'b', ('fmulz(is_used_once)', 'a', 'c')) => ('fmulz', 'a', ('fadd', 'b', 'c'))
 *    ('~fadd', ('fmulz(is_used_once)', 'a', 'b'), ('ffmaz(is_used_once)', 'a', 'c', 'd')) => ('ffmaz', 'a', ('fadd', 'b', 'c'), 'd')
 *    ('~ffmaz', 'a', ('fmulz(is_used_once)', 'b', 'c'), ('fmulz(is_used_once)', 'b', 'd')) => ('fmulz', 'b', ('ffmaz', 'a', 'c', 'd'))
 *    ('iadd', ('imul', 'a', 'b'), ('imul', 'a', 'c')) => ('imul', 'a', ('iadd', 'b', 'c'))
 *    ('iadd', ('ishl', 'b', 'a'), ('ishl', 'c', 'a')) => ('ishl', ('iadd', 'b', 'c'), 'a')
 *    ('iand', ('ior', 'a', 'b'), ('ior', 'a', 'c')) => ('ior', 'a', ('iand', 'b', 'c'))
 *    ('ior', ('iand', 'a', 'b'), ('iand', 'a', 'c')) => ('iand', 'a', ('ior', 'b', 'c'))
 *    ('ieq', ('iand', 'a', '#b(is_pos_power_of_two)'), 'b') => ('ine', ('iand', 'a', 'b'), 0)
 *    ('ine', ('iand', 'a', '#b(is_pos_power_of_two)'), 'b') => ('ieq', ('iand', 'a', 'b'), 0)
 *    ('ieq', ('ushr(is_used_once)', 'a', '#b'), 0) => ('ult', 'a', ('ishl', 1, 'b'))
 *    ('ine', ('ushr(is_used_once)', 'a', '#b'), 0) => ('uge', 'a', ('ishl', 1, 'b'))
 *    ('~fadd', ('fneg', 'a'), 'a') => 0.0
 *    ('iadd', ('ineg', 'a'), 'a') => 0
 *    ('iadd', ('ineg', 'a'), ('iadd', 'a', 'b')) => b
 *    ('iadd', 'a', ('iadd', ('ineg', 'a'), 'b')) => b
 *    ('~fadd', ('fneg', 'a'), ('fadd', 'a', 'b')) => b
 *    ('~fadd', 'a', ('fadd', ('fneg', 'a'), 'b')) => b
 *    ('fadd', ('fsat', 'a'), ('fsat', ('fneg', 'a'))) => ('fsat', ('fabs', 'a'))
 *    ('~fmul', 'a', 0.0) => 0.0
 *    ('fmul(nsz,nnan)', 'a', 0.0) => 0.0
 *    ('fmulz', 'a', 0.0) => 0.0
 *    ('fmulz(nsz)', 'a', 'b(is_finite_not_zero)') => ('fmul', 'a', 'b')
 *    ('fmulz', 'a(is_finite)', 'b(is_finite)') => ('fmul', 'a', 'b')
 *    ('fmulz', 'a', 'a') => ('fmul', 'a', 'a')
 *    ('ffmaz(nsz)', 'a', 'b(is_finite_not_zero)', 'c') => ('ffma', 'a', 'b', 'c')
 *    ('ffmaz', 'a(is_finite)', 'b(is_finite)', 'c') => ('ffma', 'a', 'b', 'c')
 *    ('ffmaz', 'a', 'a', 'b') => ('ffma', 'a', 'a', 'b')
 *    ('imul', 'a', 0) => 0
 *    ('umul_unorm_4x8_vc4', 'a', 0) => 0
 *    ('umul_unorm_4x8_vc4', 'a', -1) => a
 *    ('~fmul', 'a', 1.0) => a
 *    ('~fmulz', 'a', 1.0) => a
 *    ('fmul(is_only_used_as_float)', 'a', 1.0) => a
 *    ('imul', 'a', 1) => a
 *    ('fmul', 'a', -1.0) => ('fneg', 'a')
 *    ('imul', 'a', -1) => ('ineg', 'a')
 *    ('fmul', ('fsign', 'a'), ('fmul', 'a', 'a')) => ('fmul', ('fabs', 'a'), 'a')
 *    ('fmul', ('fmul', ('fsign', 'a'), 'a'), 'a') => ('fmul', ('fabs', 'a'), 'a')
 *    ('~ffma', 0.0, 'a', 'b') => b
 *    ('ffma(is_only_used_as_float,nsz,nnan,ninf)', 0.0, 'a', 'b') => b
 *    ('ffmaz', 0.0, 'a', 'b') => ('fadd', 0.0, 'b')
 *    ('~ffma', 'a', 'b', 0.0) => ('fmul', 'a', 'b')
 *    ('ffma(nsz)', 'a', 'b', 0.0) => ('fmul', 'a', 'b')
 *    ('ffmaz(nsz)', 'a', 'b', 0.0) => ('fmulz', 'a', 'b')
 *    ('ffma', 1.0, 'a', 'b') => ('fadd', 'a', 'b')
 *    ('ffmaz(nsz)', 1.0, 'a', 'b') => ('fadd', 'a', 'b')
 *    ('ffma', -1.0, 'a', 'b') => ('fadd', ('fneg', 'a'), 'b')
 *    ('ffmaz(nsz)', -1.0, 'a', 'b') => ('fadd', ('fneg', 'a'), 'b')
 *    ('~ffma', '#a', '#b', 'c') => ('fadd', ('fmul', 'a', 'b'), 'c')
 *    ('~ffmaz', '#a', '#b', 'c') => ('fadd', ('fmulz', 'a', 'b'), 'c')
 *    ('~flrp', 'a', 'b', 0.0) => a
 *    ('~flrp', 'a', 'b', 1.0) => b
 *    ('~flrp', 'a', 'a', 'b') => a
 *    ('~flrp', 0.0, 'a', 'b') => ('fmul', 'a', 'b')
 *    ('~flrp', 'a', ('fadd(is_used_once)', 'a', 'b'), 'c') => ('fadd', ('fmul', 'b', 'c'), 'a')
 *    ('sdot_4x8_iadd', 'a', 0, 'b') => b
 *    ('udot_4x8_uadd', 'a', 0, 'b') => b
 *    ('sdot_4x8_iadd_sat', 'a', 0, 'b') => b
 *    ('udot_4x8_uadd_sat', 'a', 0, 'b') => b
 *    ('sdot_2x16_iadd', 'a', 0, 'b') => b
 *    ('udot_2x16_uadd', 'a', 0, 'b') => b
 *    ('sdot_2x16_iadd_sat', 'a', 0, 'b') => b
 *    ('udot_2x16_uadd_sat', 'a', 0, 'b') => b
 *    ('sudot_4x8_iadd', 'a', 0, 'b') => b
 *    ('sudot_4x8_iadd', 0, 'a', 'b') => b
 *    ('sudot_4x8_iadd_sat', 'a', 0, 'b') => b
 *    ('sudot_4x8_iadd_sat', 0, 'a', 'b') => b
 *    ('iadd', ('sdot_4x8_iadd(is_used_once)', 'a', 'b', '#c'), '#d') => ('sdot_4x8_iadd', 'a', 'b', ('iadd', 'c', 'd'))
 *    ('iadd', ('udot_4x8_uadd(is_used_once)', 'a', 'b', '#c'), '#d') => ('udot_4x8_uadd', 'a', 'b', ('iadd', 'c', 'd'))
 *    ('iadd', ('sudot_4x8_iadd(is_used_once)', 'a', 'b', '#c'), '#d') => ('sudot_4x8_iadd', 'a', 'b', ('iadd', 'c', 'd'))
 *    ('iadd', ('sdot_2x16_iadd(is_used_once)', 'a', 'b', '#c'), '#d') => ('sdot_2x16_iadd', 'a', 'b', ('iadd', 'c', 'd'))
 *    ('iadd', ('udot_2x16_uadd(is_used_once)', 'a', 'b', '#c'), '#d') => ('udot_2x16_uadd', 'a', 'b', ('iadd', 'c', 'd'))
 *    ('iadd', ('sdot_4x8_iadd', 'a(is_not_const)', 'b', 0), 'c') => ('sdot_4x8_iadd', 'a', 'b', 'c')
 *    ('iadd', ('udot_4x8_uadd', 'a(is_not_const)', 'b', 0), 'c') => ('udot_4x8_uadd', 'a', 'b', 'c')
 *    ('iadd', ('sudot_4x8_iadd', 'a(is_not_const)', 'b', 0), 'c') => ('sudot_4x8_iadd', 'a', 'b', 'c')
 *    ('iadd', ('sudot_4x8_iadd', 'a', 'b(is_not_const)', 0), 'c') => ('sudot_4x8_iadd', 'a', 'b', 'c')
 *    ('iadd', ('sdot_2x16_iadd', 'a(is_not_const)', 'b', 0), 'c') => ('sdot_2x16_iadd', 'a', 'b', 'c')
 *    ('iadd', ('udot_2x16_uadd', 'a(is_not_const)', 'b', 0), 'c') => ('udot_2x16_uadd', 'a', 'b', 'c')
 *    ('sdot_4x8_iadd', '#a', '#b', 'c(is_not_const)') => ('iadd', ('sdot_4x8_iadd', 'a', 'b', 0), 'c')
 *    ('udot_4x8_uadd', '#a', '#b', 'c(is_not_const)') => ('iadd', ('udot_4x8_uadd', 'a', 'b', 0), 'c')
 *    ('sudot_4x8_iadd', '#a', '#b', 'c(is_not_const)') => ('iadd', ('sudot_4x8_iadd', 'a', 'b', 0), 'c')
 *    ('sdot_2x16_iadd', '#a', '#b', 'c(is_not_const)') => ('iadd', ('sdot_2x16_iadd', 'a', 'b', 0), 'c')
 *    ('udot_2x16_uadd', '#a', '#b', 'c(is_not_const)') => ('iadd', ('udot_2x16_uadd', 'a', 'b', 0), 'c')
 *    ('sdot_4x8_iadd_sat', '#a', '#b', 'c(is_not_const)') => ('iadd_sat', ('sdot_4x8_iadd', 'a', 'b', 0), 'c')
 *    ('udot_4x8_uadd_sat', '#a', '#b', 'c(is_not_const)') => ('uadd_sat', ('udot_4x8_uadd', 'a', 'b', 0), 'c')
 *    ('sudot_4x8_iadd_sat', '#a', '#b', 'c(is_not_const)') => ('iadd_sat', ('sudot_4x8_iadd', 'a', 'b', 0), 'c')
 *    ('sdot_2x16_iadd_sat', '#a', '#b', 'c(is_not_const)') => ('iadd_sat', ('sdot_2x16_iadd', 'a', 'b', 0), 'c')
 *    ('udot_2x16_uadd_sat', '#a', '#b', 'c(is_not_const)') => ('uadd_sat', ('udot_2x16_uadd', 'a', 'b', 0), 'c')
 *    ('fmul@32(nsz)', ('bcsel', ('feq', 'b', 0.0, 'ignore_exact'), 0.0, ('fneg', ('fabs', 'a'))), ('bcsel', ('feq', 'a', 0.0, 'ignore_exact'), 0.0, ('fneg', ('fabs', 'b')))) => ('fmulz', ('fneg', ('fabs', 'a')), ('fneg', ('fabs', 'b')))
 *    ('fmul@32(nsz)', ('bcsel', ('feq', 'b', 0.0, 'ignore_exact'), 0.0, ('fneg', ('fabs', 'a'))), ('bcsel', ('feq', 'a', 0.0, 'ignore_exact'), 0.0, ('fabs', 'b'))) => ('fmulz', ('fneg', ('fabs', 'a')), ('fabs', 'b'))
 *    ('fmul@32(nsz)', ('bcsel', ('feq', 'b', 0.0, 'ignore_exact'), 0.0, ('fneg', ('fabs', 'a'))), ('bcsel', ('feq', 'a', 0.0, 'ignore_exact'), 0.0, ('fneg', 'b'))) => ('fmulz', ('fneg', ('fabs', 'a')), ('fneg', 'b'))
 *    ('fmul@32(nsz)', ('bcsel', ('feq', 'b', 0.0, 'ignore_exact'), 0.0, ('fneg', ('fabs', 'a'))), ('bcsel', ('feq', 'a', 0.0, 'ignore_exact'), 0.0, 'b')) => ('fmulz', ('fneg', ('fabs', 'a')), 'b')
 *    ('fmul@32(nsz)', ('bcsel', ('feq', 'b', 0.0, 'ignore_exact'), 0.0, ('fabs', 'a')), ('bcsel', ('feq', 'a', 0.0, 'ignore_exact'), 0.0, ('fabs', 'b'))) => ('fmulz', ('fabs', 'a'), ('fabs', 'b'))
 *    ('fmul@32(nsz)', ('bcsel', ('feq', 'b', 0.0, 'ignore_exact'), 0.0, ('fabs', 'a')), ('bcsel', ('feq', 'a', 0.0, 'ignore_exact'), 0.0, ('fneg', 'b'))) => ('fmulz', ('fabs', 'a'), ('fneg', 'b'))
 *    ('fmul@32(nsz)', ('bcsel', ('feq', 'b', 0.0, 'ignore_exact'), 0.0, ('fabs', 'a')), ('bcsel', ('feq', 'a', 0.0, 'ignore_exact'), 0.0, 'b')) => ('fmulz', ('fabs', 'a'), 'b')
 *    ('fmul@32(nsz)', ('bcsel', ('feq', 'b', 0.0, 'ignore_exact'), 0.0, ('fneg', 'a')), ('bcsel', ('feq', 'a', 0.0, 'ignore_exact'), 0.0, ('fneg', 'b'))) => ('fmulz', ('fneg', 'a'), ('fneg', 'b'))
 *    ('fmul@32(nsz)', ('bcsel', ('feq', 'b', 0.0, 'ignore_exact'), 0.0, ('fneg', 'a')), ('bcsel', ('feq', 'a', 0.0, 'ignore_exact'), 0.0, 'b')) => ('fmulz', ('fneg', 'a'), 'b')
 *    ('fmul@32(nsz)', ('bcsel', ('feq', 'b', 0.0, 'ignore_exact'), 0.0, 'a'), ('bcsel', ('feq', 'a', 0.0, 'ignore_exact'), 0.0, 'b')) => ('fmulz', 'a', 'b')
 *    ('fmul@32(nsz)', ('fneg', ('fabs', 'a')), ('bcsel', ('feq', 'a', 0.0, 'ignore_exact'), 0.0, '#b(is_not_const_zero)')) => ('fmulz', ('fneg', ('fabs', 'a')), 'b')
 *    ('fmul@32(nsz)', ('fabs', 'a'), ('bcsel', ('feq', 'a', 0.0, 'ignore_exact'), 0.0, '#b(is_not_const_zero)')) => ('fmulz', ('fabs', 'a'), 'b')
 *    ('fmul@32(nsz)', ('fneg', 'a'), ('bcsel', ('feq', 'a', 0.0, 'ignore_exact'), 0.0, '#b(is_not_const_zero)')) => ('fmulz', ('fneg', 'a'), 'b')
 *    ('fmul@32(nsz)', 'a', ('bcsel', ('feq', 'a', 0.0, 'ignore_exact'), 0.0, '#b(is_not_const_zero)')) => ('fmulz', 'a', 'b')
 *    ('ffma@32(nsz)', ('bcsel', ('feq', 'b', 0.0, 'ignore_exact'), 0.0, ('fneg', ('fabs', 'a'))), ('bcsel', ('feq', 'a', 0.0, 'ignore_exact'), 0.0, ('fneg', ('fabs', 'b'))), 'c') => ('ffmaz', ('fneg', ('fabs', 'a')), ('fneg', ('fabs', 'b')), 'c')
 *    ('ffma@32(nsz)', ('bcsel', ('feq', 'b', 0.0, 'ignore_exact'), 0.0, ('fneg', ('fabs', 'a'))), ('bcsel', ('feq', 'a', 0.0, 'ignore_exact'), 0.0, ('fabs', 'b')), 'c') => ('ffmaz', ('fneg', ('fabs', 'a')), ('fabs', 'b'), 'c')
 *    ('ffma@32(nsz)', ('bcsel', ('feq', 'b', 0.0, 'ignore_exact'), 0.0, ('fneg', ('fabs', 'a'))), ('bcsel', ('feq', 'a', 0.0, 'ignore_exact'), 0.0, ('fneg', 'b')), 'c') => ('ffmaz', ('fneg', ('fabs', 'a')), ('fneg', 'b'), 'c')
 *    ('ffma@32(nsz)', ('bcsel', ('feq', 'b', 0.0, 'ignore_exact'), 0.0, ('fneg', ('fabs', 'a'))), ('bcsel', ('feq', 'a', 0.0, 'ignore_exact'), 0.0, 'b'), 'c') => ('ffmaz', ('fneg', ('fabs', 'a')), 'b', 'c')
 *    ('ffma@32(nsz)', ('bcsel', ('feq', 'b', 0.0, 'ignore_exact'), 0.0, ('fabs', 'a')), ('bcsel', ('feq', 'a', 0.0, 'ignore_exact'), 0.0, ('fabs', 'b')), 'c') => ('ffmaz', ('fabs', 'a'), ('fabs', 'b'), 'c')
 *    ('ffma@32(nsz)', ('bcsel', ('feq', 'b', 0.0, 'ignore_exact'), 0.0, ('fabs', 'a')), ('bcsel', ('feq', 'a', 0.0, 'ignore_exact'), 0.0, ('fneg', 'b')), 'c') => ('ffmaz', ('fabs', 'a'), ('fneg', 'b'), 'c')
 *    ('ffma@32(nsz)', ('bcsel', ('feq', 'b', 0.0, 'ignore_exact'), 0.0, ('fabs', 'a')), ('bcsel', ('feq', 'a', 0.0, 'ignore_exact'), 0.0, 'b'), 'c') => ('ffmaz', ('fabs', 'a'), 'b', 'c')
 *    ('ffma@32(nsz)', ('bcsel', ('feq', 'b', 0.0, 'ignore_exact'), 0.0, ('fneg', 'a')), ('bcsel', ('feq', 'a', 0.0, 'ignore_exact'), 0.0, ('fneg', 'b')), 'c') => ('ffmaz', ('fneg', 'a'), ('fneg', 'b'), 'c')
 *    ('ffma@32(nsz)', ('bcsel', ('feq', 'b', 0.0, 'ignore_exact'), 0.0, ('fneg', 'a')), ('bcsel', ('feq', 'a', 0.0, 'ignore_exact'), 0.0, 'b'), 'c') => ('ffmaz', ('fneg', 'a'), 'b', 'c')
 *    ('ffma@32(nsz)', ('bcsel', ('feq', 'b', 0.0, 'ignore_exact'), 0.0, 'a'), ('bcsel', ('feq', 'a', 0.0, 'ignore_exact'), 0.0, 'b'), 'c') => ('ffmaz', 'a', 'b', 'c')
 *    ('ffma@32(nsz)', ('fneg', ('fabs', 'a')), ('bcsel', ('feq', 'a', 0.0, 'ignore_exact'), 0.0, '#b(is_not_const_zero)'), 'c') => ('ffmaz', ('fneg', ('fabs', 'a')), 'b', 'c')
 *    ('ffma@32(nsz)', ('fabs', 'a'), ('bcsel', ('feq', 'a', 0.0, 'ignore_exact'), 0.0, '#b(is_not_const_zero)'), 'c') => ('ffmaz', ('fabs', 'a'), 'b', 'c')
 *    ('ffma@32(nsz)', ('fneg', 'a'), ('bcsel', ('feq', 'a', 0.0, 'ignore_exact'), 0.0, '#b(is_not_const_zero)'), 'c') => ('ffmaz', ('fneg', 'a'), 'b', 'c')
 *    ('ffma@32(nsz)', 'a', ('bcsel', ('feq', 'a', 0.0, 'ignore_exact'), 0.0, '#b(is_not_const_zero)'), 'c') => ('ffmaz', 'a', 'b', 'c')
 *    ('bcsel(nsz,nnan,ninf)', ('feq', 'b', 0.0, 'ignore_exact'), 1.0, ('fexp2', ('fmul@32', 'a', ('fneg', ('fabs', 'b'))))) => ('fexp2', ('fmulz', 'a', ('fneg', ('fabs', 'b'))))
 *    ('bcsel(nsz,nnan,ninf)', ('feq', 'b', 0.0, 'ignore_exact'), 1.0, ('fexp2', ('fmul@32', 'a', ('fabs', 'b')))) => ('fexp2', ('fmulz', 'a', ('fabs', 'b')))
 *    ('bcsel(nsz,nnan,ninf)', ('feq', 'b', 0.0, 'ignore_exact'), 1.0, ('fexp2', ('fmul@32', 'a', ('fneg', 'b')))) => ('fexp2', ('fmulz', 'a', ('fneg', 'b')))
 *    ('bcsel(nsz,nnan,ninf)', ('feq', 'b', 0.0, 'ignore_exact'), 1.0, ('fexp2', ('fmul@32', 'a', 'b'))) => ('fexp2', ('fmulz', 'a', 'b'))
 *    ('bcsel', ('feq', 'b', 0.0, 'ignore_exact'), 1.0, ('fexp2', ('fmulz', 'a', ('fneg', ('fabs', 'b'))))) => ('fexp2', ('fmulz', 'a', ('fneg', ('fabs', 'b'))))
 *    ('bcsel', ('feq', 'b', 0.0, 'ignore_exact'), 1.0, ('fexp2', ('fmulz', 'a', ('fabs', 'b')))) => ('fexp2', ('fmulz', 'a', ('fabs', 'b')))
 *    ('bcsel', ('feq', 'b', 0.0, 'ignore_exact'), 1.0, ('fexp2', ('fmulz', 'a', ('fneg', 'b')))) => ('fexp2', ('fmulz', 'a', ('fneg', 'b')))
 *    ('bcsel', ('feq', 'b', 0.0, 'ignore_exact'), 1.0, ('fexp2', ('fmulz', 'a', 'b'))) => ('fexp2', ('fmulz', 'a', 'b'))
 *    ('sdot_4x8_iadd', 'a', 'b', 'c') => ('iadd', ('iadd', ('iadd', ('imul', ('extract_i8', 'a', 0), ('extract_i8', 'b', 0)), ('imul', ('extract_i8', 'a', 1), ('extract_i8', 'b', 1))), ('iadd', ('imul', ('extract_i8', 'a', 2), ('extract_i8', 'b', 2)), ('imul', ('extract_i8', 'a', 3), ('extract_i8', 'b', 3)))), 'c')
 *    ('udot_4x8_uadd', 'a', 'b', 'c') => ('iadd', ('iadd', ('iadd', ('imul', ('extract_u8', 'a', 0), ('extract_u8', 'b', 0)), ('imul', ('extract_u8', 'a', 1), ('extract_u8', 'b', 1))), ('iadd', ('imul', ('extract_u8', 'a', 2), ('extract_u8', 'b', 2)), ('imul', ('extract_u8', 'a', 3), ('extract_u8', 'b', 3)))), 'c')
 *    ('sudot_4x8_iadd', 'a', 'b', 'c') => ('iadd', ('iadd', ('iadd', ('imul', ('extract_i8', 'a', 0), ('extract_u8', 'b', 0)), ('imul', ('extract_i8', 'a', 1), ('extract_u8', 'b', 1))), ('iadd', ('imul', ('extract_i8', 'a', 2), ('extract_u8', 'b', 2)), ('imul', ('extract_i8', 'a', 3), ('extract_u8', 'b', 3)))), 'c')
 *    ('sdot_2x16_iadd', 'a', 'b', 'c') => ('iadd', ('iadd', ('imul', ('extract_i16', 'a', 0), ('extract_i16', 'b', 0)), ('imul', ('extract_i16', 'a', 1), ('extract_i16', 'b', 1))), 'c')
 *    ('udot_2x16_uadd', 'a', 'b', 'c') => ('iadd', ('iadd', ('imul', ('extract_u16', 'a', 0), ('extract_u16', 'b', 0)), ('imul', ('extract_u16', 'a', 1), ('extract_u16', 'b', 1))), 'c')
 *    ('udot_4x8_uadd_sat', 'a', 'b', '#c(is_ult_0xfffc07fc)') => ('udot_4x8_uadd', 'a', 'b', 'c')
 *    ('udot_4x8_uadd_sat', 'a', 'b', 'c') => ('uadd_sat', ('udot_4x8_uadd', 'a', 'b', 0), 'c')
 *    ('sdot_4x8_iadd_sat', 'a', 'b', 'c') => ('iadd_sat', ('sdot_4x8_iadd', 'a', 'b', 0), 'c')
 *    ('sudot_4x8_iadd_sat', 'a', 'b', 'c') => ('iadd_sat', ('sudot_4x8_iadd', 'a', 'b', 0), 'c')
 *    ('udot_2x16_uadd_sat', 'a', 'b', 'c') => ('uadd_sat', ('iadd', ('imul', ('extract_u16', 'a', 0), ('extract_u16', 'b', 0)), ('imul', ('extract_u16', 'a', 1), ('extract_u16', 'b', 1))), 'c')
 *    ('sdot_2x16_iadd_sat', 'a', 'b', 'c') => ('iadd_sat', ('iadd', ('imul', ('extract_i16', 'a', 0), ('extract_i16', 'b', 0)), ('imul', ('extract_i16', 'a', 1), ('extract_i16', 'b', 1))), 'c')
 *    ('~flrp@16', 'a', 'b', ('b2f', 'c@1')) => ('bcsel', 'c', 'b', 'a')
 *    ('~flrp@16', 'a', ('fadd', 'a', 'b'), 'c') => ('fadd', ('fmul', 'b', 'c'), 'a')
 *    ('~flrp@16', ('fadd(is_used_once)', 'a', 'b'), ('fadd(is_used_once)', 'a', 'c'), 'd') => ('fadd', ('flrp', 'b', 'c', 'd'), 'a')
 *    ('~flrp@16', 'a', ('fmul(is_used_once)', 'a', 'b'), 'c') => ('fmul', ('flrp', 1.0, 'b', 'c'), 'a')
 *    ('~fadd@16', ('fmul', 'a', ('fadd', 1.0, ('fneg', 'c'))), ('fmul', 'b', 'c')) => ('flrp', 'a', 'b', 'c')
 *    ('~fadd@16', ('fmul', 'a', ('fsat', ('fadd', 1.0, ('fneg', 'c')))), ('fmul', 'b', ('fsat', 'c'))) => ('flrp', 'a', 'b', ('fsat', 'c'))
 *    ('~fadd@16', 'a', ('fmul', 'c', ('fadd', 'b', ('fneg', 'a')))) => ('flrp', 'a', 'b', 'c')
 *    ('~fadd@16', ('fmul', 'a', ('fadd', 1.0, ('fneg', ('b2f', 'c@1')))), ('fmul', 'b', ('b2f', 'c'))) => ('bcsel', 'c', 'b', 'a')
 *    ('~fadd@16', 'a', ('fmul', ('b2f', 'c@1'), ('fadd', 'b', ('fneg', 'a')))) => ('bcsel', 'c', 'b', 'a')
 *    ('~ffma@16', 'a', ('fadd', 1.0, ('fneg', ('b2f', 'c@1'))), ('fmul', 'b', ('b2f', 'c@1'))) => ('bcsel', 'c', 'b', 'a')
 *    ('~ffma@16', 'b', ('b2f', 'c@1'), ('ffma', ('fneg', 'a'), ('b2f', 'c@1'), 'a')) => ('bcsel', 'c', 'b', 'a')
 *    ('~ffma@16', ('b2f', 'c@1'), ('fadd', 'b', ('fneg', 'a')), 'a') => ('bcsel', 'c', 'b', 'a')
 *    ('~ffma@16', ('b2f', 'c@1'), ('ffma', ('fneg', 'a'), 'b', 'd'), ('fmul', 'a', 'b')) => ('bcsel', 'c', 'd', ('fmul', 'a', 'b'))
 *    ('~fadd@16', 1.0, ('fneg', ('fmul', ('fadd', 1.0, ('fneg', 'a')), ('fadd', 1.0, ('fneg', 'b'))))) => ('flrp', 'b', 1.0, 'a')
 *    ('~flrp@32', 'a', 'b', ('b2f', 'c@1')) => ('bcsel', 'c', 'b', 'a')
 *    ('~flrp@32', 'a', ('fadd', 'a', 'b'), 'c') => ('fadd', ('fmul', 'b', 'c'), 'a')
 *    ('~flrp@32', ('fadd(is_used_once)', 'a', 'b'), ('fadd(is_used_once)', 'a', 'c'), 'd') => ('fadd', ('flrp', 'b', 'c', 'd'), 'a')
 *    ('~flrp@32', 'a', ('fmul(is_used_once)', 'a', 'b'), 'c') => ('fmul', ('flrp', 1.0, 'b', 'c'), 'a')
 *    ('~fadd@32', ('fmul', 'a', ('fadd', 1.0, ('fneg', 'c'))), ('fmul', 'b', 'c')) => ('flrp', 'a', 'b', 'c')
 *    ('~fadd@32', ('fmul', 'a', ('fsat', ('fadd', 1.0, ('fneg', 'c')))), ('fmul', 'b', ('fsat', 'c'))) => ('flrp', 'a', 'b', ('fsat', 'c'))
 *    ('~fadd@32', 'a', ('fmul', 'c', ('fadd', 'b', ('fneg', 'a')))) => ('flrp', 'a', 'b', 'c')
 *    ('~fadd@32', ('fmul', 'a', ('fadd', 1.0, ('fneg', ('b2f', 'c@1')))), ('fmul', 'b', ('b2f', 'c'))) => ('bcsel', 'c', 'b', 'a')
 *    ('~fadd@32', 'a', ('fmul', ('b2f', 'c@1'), ('fadd', 'b', ('fneg', 'a')))) => ('bcsel', 'c', 'b', 'a')
 *    ('~ffma@32', 'a', ('fadd', 1.0, ('fneg', ('b2f', 'c@1'))), ('fmul', 'b', ('b2f', 'c@1'))) => ('bcsel', 'c', 'b', 'a')
 *    ('~ffma@32', 'b', ('b2f', 'c@1'), ('ffma', ('fneg', 'a'), ('b2f', 'c@1'), 'a')) => ('bcsel', 'c', 'b', 'a')
 *    ('~ffma@32', ('b2f', 'c@1'), ('fadd', 'b', ('fneg', 'a')), 'a') => ('bcsel', 'c', 'b', 'a')
 *    ('~ffma@32', ('b2f', 'c@1'), ('ffma', ('fneg', 'a'), 'b', 'd'), ('fmul', 'a', 'b')) => ('bcsel', 'c', 'd', ('fmul', 'a', 'b'))
 *    ('~fadd@32', 1.0, ('fneg', ('fmul', ('fadd', 1.0, ('fneg', 'a')), ('fadd', 1.0, ('fneg', 'b'))))) => ('flrp', 'b', 1.0, 'a')
 *    ('~flrp@64', 'a', 'b', ('b2f', 'c@1')) => ('bcsel', 'c', 'b', 'a')
 *    ('~flrp@64', 'a', ('fadd', 'a', 'b'), 'c') => ('fadd', ('fmul', 'b', 'c'), 'a')
 *    ('~flrp@64', ('fadd(is_used_once)', 'a', 'b'), ('fadd(is_used_once)', 'a', 'c'), 'd') => ('fadd', ('flrp', 'b', 'c', 'd'), 'a')
 *    ('~flrp@64', 'a', ('fmul(is_used_once)', 'a', 'b'), 'c') => ('fmul', ('flrp', 1.0, 'b', 'c'), 'a')
 *    ('~fadd@64', ('fmul', 'a', ('fadd', 1.0, ('fneg', 'c'))), ('fmul', 'b', 'c')) => ('flrp', 'a', 'b', 'c')
 *    ('~fadd@64', ('fmul', 'a', ('fsat', ('fadd', 1.0, ('fneg', 'c')))), ('fmul', 'b', ('fsat', 'c'))) => ('flrp', 'a', 'b', ('fsat', 'c'))
 *    ('~fadd@64', 'a', ('fmul', 'c', ('fadd', 'b', ('fneg', 'a')))) => ('flrp', 'a', 'b', 'c')
 *    ('~fadd@64', ('fmul', 'a', ('fadd', 1.0, ('fneg', ('b2f', 'c@1')))), ('fmul', 'b', ('b2f', 'c'))) => ('bcsel', 'c', 'b', 'a')
 *    ('~fadd@64', 'a', ('fmul', ('b2f', 'c@1'), ('fadd', 'b', ('fneg', 'a')))) => ('bcsel', 'c', 'b', 'a')
 *    ('~ffma@64', 'a', ('fadd', 1.0, ('fneg', ('b2f', 'c@1'))), ('fmul', 'b', ('b2f', 'c@1'))) => ('bcsel', 'c', 'b', 'a')
 *    ('~ffma@64', 'b', ('b2f', 'c@1'), ('ffma', ('fneg', 'a'), ('b2f', 'c@1'), 'a')) => ('bcsel', 'c', 'b', 'a')
 *    ('~ffma@64', ('b2f', 'c@1'), ('fadd', 'b', ('fneg', 'a')), 'a') => ('bcsel', 'c', 'b', 'a')
 *    ('~ffma@64', ('b2f', 'c@1'), ('ffma', ('fneg', 'a'), 'b', 'd'), ('fmul', 'a', 'b')) => ('bcsel', 'c', 'd', ('fmul', 'a', 'b'))
 *    ('~fadd@64', 1.0, ('fneg', ('fmul', ('fadd', 1.0, ('fneg', 'a')), ('fadd', 1.0, ('fneg', 'b'))))) => ('flrp', 'b', 1.0, 'a')
 *    ('~flrp', ('fmul(is_used_once)', 'a', 'b'), ('fmul(is_used_once)', 'a', 'c'), 'd') => ('fmul', ('flrp', 'b', 'c', 'd'), 'a')
 *    ('~flrp', 'a', 0.0, 'c') => ('fadd', ('fmul', ('fneg', 'a'), 'c'), 'a')
 *    ('ftrunc@16', 'a') => ('bcsel', ('flt', 'a', 0.0), ('fneg', ('ffloor', ('fabs', 'a'))), ('ffloor', ('fabs', 'a')))
 *    ('ftrunc@32', 'a') => ('bcsel', ('flt', 'a', 0.0), ('fneg', ('ffloor', ('fabs', 'a'))), ('ffloor', ('fabs', 'a')))
 *    ('ftrunc@64', 'a') => ('bcsel', ('flt', 'a', 0.0), ('fneg', ('ffloor', ('fabs', 'a'))), ('ffloor', ('fabs', 'a')))
 *    ('ffloor@16', 'a') => ('fsub', 'a', ('ffract', 'a'))
 *    ('ffloor@32', 'a') => ('fsub', 'a', ('ffract', 'a'))
 *    ('ffloor@64', 'a') => ('fsub', 'a', ('ffract', 'a'))
 *    ('fadd@16', 'a', ('fadd@16', 'b', ('fneg', ('ffract', 'a')))) => ('fadd@16', 'b', ('ffloor', 'a'))
 *    ('fadd@32', 'a', ('fadd@32', 'b', ('fneg', ('ffract', 'a')))) => ('fadd@32', 'b', ('ffloor', 'a'))
 *    ('fadd@64', 'a', ('fadd@64', 'b', ('fneg', ('ffract', 'a')))) => ('fadd@64', 'b', ('ffloor', 'a'))
 *    ('fadd@16', 'a', ('fneg', ('ffract', 'a'))) => ('ffloor', 'a')
 *    ('fadd@32', 'a', ('fneg', ('ffract', 'a'))) => ('ffloor', 'a')
 *    ('fadd@64', 'a', ('fneg', ('ffract', 'a'))) => ('ffloor', 'a')
 *    ('ffract@16', 'a') => ('fsub', 'a', ('ffloor', 'a'))
 *    ('ffract@32', 'a') => ('fsub', 'a', ('ffloor', 'a'))
 *    ('ffract@64', 'a') => ('fsub', 'a', ('ffloor', 'a'))
 *    ('fceil', 'a') => ('fneg', ('ffloor', ('fneg', 'a')))
 *    ('ffma@16', 'a', 'b', 'c') => ('fadd', ('fmul', 'a', 'b'), 'c')
 *    ('ffma@32', 'a', 'b', 'c') => ('fadd', ('fmul', 'a', 'b'), 'c')
 *    ('ffma@64', 'a', 'b', 'c') => ('fadd', ('fmul', 'a', 'b'), 'c')
 *    ('ffmaz', 'a', 'b', 'c') => ('fadd', ('fmulz', 'a', 'b'), 'c')
 *    ('~ffma@16', 'a', 'b', 'c') => ('fadd', ('fmul', 'a', 'b'), 'c')
 *    ('~ffma@32', 'a', 'b', 'c') => ('fadd', ('fmul', 'a', 'b'), 'c')
 *    ('~ffma@64', 'a', 'b', 'c') => ('fadd', ('fmul', 'a', 'b'), 'c')
 *    ('~ffmaz', 'a', 'b', 'c') => ('fadd', ('fmulz', 'a', 'b'), 'c')
 *    ('~fmul', ('fadd', ('iand', ('ineg', ('b2i', 'a@bool')), ('fmul', 'b', 'c')), '#d'), '#e') => ('bcsel', 'a', ('fmul', ('fadd', ('fmul', 'b', 'c'), 'd'), 'e'), ('fmul', 'd', 'e'))
 *    ('fdph', 'a', 'b') => ('fdot4', ('vec4', 'a.x', 'a.y', 'a.z', 1.0), 'b')
 *    ('fdot4', 'a', 0.0) => 0.0
 *    ('fdot3', 'a', 0.0) => 0.0
 *    ('fdot2', 'a', 0.0) => 0.0
 *    ('fdot4', ('vec4', 'a', 'b', 'c', 1.0), 'd') => ('fdph', ('vec3', 'a', 'b', 'c'), 'd')
 *    ('fdot4', ('vec4', 'a', 0.0, 0.0, 0.0), 'b') => ('fmul', 'a', 'b')
 *    ('fdot4', ('vec4', 'a', 'b', 0.0, 0.0), 'c') => ('fdot2', ('vec2', 'a', 'b'), 'c')
 *    ('fdot4', ('vec4', 'a', 'b', 'c', 0.0), 'd') => ('fdot3', ('vec3', 'a', 'b', 'c'), 'd')
 *    ('fdot3', ('vec3', 'a', 0.0, 0.0), 'b') => ('fmul', 'a', 'b')
 *    ('fdot3', ('vec3', 'a', 'b', 0.0), 'c') => ('fdot2', ('vec2', 'a', 'b'), 'c')
 *    ('fdot2', ('vec2', 'a', 0.0), 'b') => ('fmul', 'a', 'b')
 *    ('fdot2', 'a', 1.0) => ('fadd', 'a.x', 'a.y')
 *    ('fdot2', 'a', 'b') => ('fsum2', ('fmul', 'a', 'b'))
 *    ('fdot3', 'a', 'b') => ('fsum3', ('fmul', 'a', 'b'))
 *    ('fdot4', 'a', 'b') => ('fsum4', ('fmul', 'a', 'b'))
 *    ('fsum2', 'a') => ('fadd', 'a.x', 'a.y')
 *    ('~fadd', ('fneg(is_used_once)', ('fsat(is_used_once)', 'a(is_not_fmul)')), 1.0) => ('fsat', ('fadd', 1.0, ('fneg', 'a')))
 *    ('ishl', ('iadd', ('imul', 'a', '#b'), '#c'), '#d') => ('iadd', ('imul', 'a', ('ishl', 'b', 'd')), ('ishl', 'c', 'd'))
 *    ('ishl', ('imul', 'a', '#b'), '#c') => ('imul', 'a', ('ishl', 'b', 'c'))
 *    ('ishl@8', ('ishl@8', 'a', '#b'), '#c') => ('bcsel', ('ult', ('iadd', ('iand', 'b', 7), ('iand', 'c', 7)), 8), ('ishl@8', 'a', ('iadd', 'b', 'c')), 0)
 *    ('ushr@8', ('ushr@8', 'a', '#b'), '#c') => ('bcsel', ('ult', ('iadd', ('iand', 'b', 7), ('iand', 'c', 7)), 8), ('ushr@8', 'a', ('iadd', 'b', 'c')), 0)
 *    ('ishr@8', ('ishr@8', 'a', '#b'), '#c') => ('ishr@8', 'a', ('imin', ('iadd', ('iand', 'b', 7), ('iand', 'c', 7)), 7))
 *    ('ishl@16', ('ishl@16', 'a', '#b'), '#c') => ('bcsel', ('ult', ('iadd', ('iand', 'b', 15), ('iand', 'c', 15)), 16), ('ishl@16', 'a', ('iadd', 'b', 'c')), 0)
 *    ('ushr@16', ('ushr@16', 'a', '#b'), '#c') => ('bcsel', ('ult', ('iadd', ('iand', 'b', 15), ('iand', 'c', 15)), 16), ('ushr@16', 'a', ('iadd', 'b', 'c')), 0)
 *    ('ishr@16', ('ishr@16', 'a', '#b'), '#c') => ('ishr@16', 'a', ('imin', ('iadd', ('iand', 'b', 15), ('iand', 'c', 15)), 15))
 *    ('ishl@32', ('ishl@32', 'a', '#b'), '#c') => ('bcsel', ('ult', ('iadd', ('iand', 'b', 31), ('iand', 'c', 31)), 32), ('ishl@32', 'a', ('iadd', 'b', 'c')), 0)
 *    ('ushr@32', ('ushr@32', 'a', '#b'), '#c') => ('bcsel', ('ult', ('iadd', ('iand', 'b', 31), ('iand', 'c', 31)), 32), ('ushr@32', 'a', ('iadd', 'b', 'c')), 0)
 *    ('ishr@32', ('ishr@32', 'a', '#b'), '#c') => ('ishr@32', 'a', ('imin', ('iadd', ('iand', 'b', 31), ('iand', 'c', 31)), 31))
 *    ('ishl@64', ('ishl@64', 'a', '#b'), '#c') => ('bcsel', ('ult', ('iadd', ('iand', 'b', 63), ('iand', 'c', 63)), 64), ('ishl@64', 'a', ('iadd', 'b', 'c')), 0)
 *    ('ushr@64', ('ushr@64', 'a', '#b'), '#c') => ('bcsel', ('ult', ('iadd', ('iand', 'b', 63), ('iand', 'c', 63)), 64), ('ushr@64', 'a', ('iadd', 'b', 'c')), 0)
 *    ('ishr@64', ('ishr@64', 'a', '#b'), '#c') => ('ishr@64', 'a', ('imin', ('iadd', ('iand', 'b', 63), ('iand', 'c', 63)), 63))
 *    ('ishl', ('ushr', 'a@8', '#b'), 'b') => ('iand', 'a', ('ishl', 255, 'b'))
 *    ('ishl', ('ishr', 'a@8', '#b'), 'b') => ('iand', 'a', ('ishl', 255, 'b'))
 *    ('ushr', ('ishl', 'a@8', '#b'), 'b') => ('iand', 'a', ('ushr', 255, 'b'))
 *    ('ishl', ('ushr', 'a@16', '#b'), 'b') => ('iand', 'a', ('ishl', 65535, 'b'))
 *    ('ishl', ('ishr', 'a@16', '#b'), 'b') => ('iand', 'a', ('ishl', 65535, 'b'))
 *    ('ushr', ('ishl', 'a@16', '#b'), 'b') => ('iand', 'a', ('ushr', 65535, 'b'))
 *    ('ishl', ('ushr', 'a@32', '#b'), 'b') => ('iand', 'a', ('ishl', 4294967295, 'b'))
 *    ('ishl', ('ishr', 'a@32', '#b'), 'b') => ('iand', 'a', ('ishl', 4294967295, 'b'))
 *    ('ushr', ('ishl', 'a@32', '#b'), 'b') => ('iand', 'a', ('ushr', 4294967295, 'b'))
 *    ('ishl', ('ushr', 'a@64', '#b'), 'b') => ('iand', 'a', ('ishl', 18446744073709551615, 'b'))
 *    ('ishl', ('ishr', 'a@64', '#b'), 'b') => ('iand', 'a', ('ishl', 18446744073709551615, 'b'))
 *    ('ushr', ('ishl', 'a@64', '#b'), 'b') => ('iand', 'a', ('ushr', 18446744073709551615, 'b'))
 *    ('iand', ('ishl', 'a@32', '#b(is_first_5_bits_uge_2)'), -4) => ('ishl', 'a', 'b')
 *    ('iand', ('imul', 'a', '#b(is_unsigned_multiple_of_4)'), -4) => ('imul', 'a', 'b')
 *    ('iand@32', ('iadd@32', 'a', '#b(is_unsigned_multiple_of_2)'), 4294967294) => ('iadd', ('iand', 'a', 4294967294), 'b')
 *    ('iand@32', ('iadd@32', 'a', '#b(is_unsigned_multiple_of_4)'), 4294967292) => ('iadd', ('iand', 'a', 4294967292), 'b')
 *    ('iand@32', ('iadd@32', 'a', '#b(is_unsigned_multiple_of_8)'), 4294967288) => ('iadd', ('iand', 'a', 4294967288), 'b')
 *    ('iand@32', ('iadd@32', 'a', '#b(is_unsigned_multiple_of_16)'), 4294967280) => ('iadd', ('iand', 'a', 4294967280), 'b')
 *    ('iand@32', ('iadd@32', 'a', '#b(is_unsigned_multiple_of_32)'), 4294967264) => ('iadd', ('iand', 'a', 4294967264), 'b')
 *    ('iand@32', ('iadd@32', 'a', '#b(is_unsigned_multiple_of_64)'), 4294967232) => ('iadd', ('iand', 'a', 4294967232), 'b')
 *    ('ishl@32', ('iand', 'a@32', 2147483647), 1) => ('ishl', 'a', 1)
 *    ('iand', ('ishl', 'a@32', 1), 4294967294) => ('ishl', 'a', 1)
 *    ('iand', ('ushr', 'a@32', 1), 2147483647) => ('ushr', 'a', 1)
 *    ('ishl@32', ('iand', 'a@32', 1073741823), 2) => ('ishl', 'a', 2)
 *    ('iand', ('ishl', 'a@32', 2), 4294967292) => ('ishl', 'a', 2)
 *    ('iand', ('ushr', 'a@32', 2), 1073741823) => ('ushr', 'a', 2)
 *    ('ishl@32', ('iand', 'a@32', 65535), 16) => ('ishl', 'a', 16)
 *    ('iand', ('ishl', 'a@32', 16), 4294901760) => ('ishl', 'a', 16)
 *    ('iand', ('ushr', 'a@32', 16), 65535) => ('ushr', 'a', 16)
 *    ('ishl@32', ('iand', 'a@32', 255), 24) => ('ishl', 'a', 24)
 *    ('iand', ('ishl', 'a@32', 24), 4278190080) => ('ishl', 'a', 24)
 *    ('iand', ('ushr', 'a@32', 24), 255) => ('ushr', 'a', 24)
 *    ('ishl', ('iadd', 'a', '#b'), '#c') => ('iadd', ('ishl', 'a', 'c'), ('ishl', 'b', 'c'))
 *    ('imul', ('iadd(is_used_once)', 'a', '#b'), '#c') => ('iadd', ('imul', 'a', 'c'), ('imul', 'b', 'c'))
 *    ('imul', ('iadd(is_used_once)', ('iadd(is_used_once)', 'a', '#b'), 'c'), '#d') => ('iadd', ('imul', ('iadd', 'a', 'c'), 'd'), ('imul', 'b', 'd'))
 *    ('ishl', ('iadd(is_used_once)', ('iadd(is_used_once)', 'a', '#b'), 'c'), '#d') => ('iadd', ('ishl', ('iadd', 'a', 'c'), 'd'), ('ishl', 'b', 'd'))
 *    ('inot', ('flt(is_used_once)', 'a(is_a_number)', 'b(is_a_number)')) => ('fge', 'a', 'b')
 *    ('inot', ('fge(is_used_once)', 'a(is_a_number)', 'b(is_a_number)')) => ('flt', 'a', 'b')
 *    ('inot', ('feq(is_used_once)', 'a', 'b')) => ('fneu', 'a', 'b')
 *    ('inot', ('fneu(is_used_once)', 'a', 'b')) => ('feq', 'a', 'b')
 *    ('inot', ('ilt(is_used_once)', 'a', 'b')) => ('ige', 'a', 'b')
 *    ('inot', ('ult(is_used_once)', 'a', 'b')) => ('uge', 'a', 'b')
 *    ('inot', ('ige(is_used_once)', 'a', 'b')) => ('ilt', 'a', 'b')
 *    ('inot', ('uge(is_used_once)', 'a', 'b')) => ('ult', 'a', 'b')
 *    ('inot', ('ieq(is_used_once)', 'a', 'b')) => ('ine', 'a', 'b')
 *    ('inot', ('ine(is_used_once)', 'a', 'b')) => ('ieq', 'a', 'b')
 *    ('iand', ('feq', 'a', 'b'), ('fneu', 'a', 'b')) => False
 *    ('iand', ('flt', 'a', 'b'), ('flt', 'b', 'a')) => False
 *    ('iand', ('ieq', 'a', 'b'), ('ine', 'a', 'b')) => False
 *    ('iand', ('ilt', 'a', 'b'), ('ilt', 'b', 'a')) => False
 *    ('iand', ('ult', 'a', 'b'), ('ult', 'b', 'a')) => False
 *    ('flt', ('fneg', 'a'), ('fneg', 'b')) => ('flt', 'b', 'a')
 *    ('fge', ('fneg', 'a'), ('fneg', 'b')) => ('fge', 'b', 'a')
 *    ('feq', ('fneg', 'a'), ('fneg', 'b')) => ('feq', 'b', 'a')
 *    ('fneu', ('fneg', 'a'), ('fneg', 'b')) => ('fneu', 'b', 'a')
 *    ('flt', ('fneg', 'a(is_not_const)'), '#b') => ('flt', ('fneg', 'b'), 'a')
 *    ('flt', '#b', ('fneg', 'a(is_not_const)')) => ('flt', 'a', ('fneg', 'b'))
 *    ('fge', ('fneg', 'a(is_not_const)'), '#b') => ('fge', ('fneg', 'b'), 'a')
 *    ('fge', '#b', ('fneg', 'a(is_not_const)')) => ('fge', 'a', ('fneg', 'b'))
 *    ('fneu', ('fneg', 'a(is_not_const)'), '#b') => ('fneu', ('fneg', 'b'), 'a')
 *    ('feq', '#b', ('fneg', 'a(is_not_const)')) => ('feq', 'a', ('fneg', 'b'))
 *    ('flt', 'a', '#b(is_negative_zero)') => ('flt', 'a', 0.0)
 *    ('flt', '#b(is_negative_zero)', 'a') => ('flt', 0.0, 'a')
 *    ('fge', 'a', '#b(is_negative_zero)') => ('fge', 'a', 0.0)
 *    ('fge', '#b(is_negative_zero)', 'a') => ('fge', 0.0, 'a')
 *    ('fneu', 'a', '#b(is_negative_zero)') => ('fneu', 0.0, 'a')
 *    ('feq', '#b(is_negative_zero)', 'a') => ('feq', 'a', 0.0)
 *    ('ieq', ('ineg', 'a'), 0) => ('ieq', 'a', 0)
 *    ('ine', ('ineg', 'a'), 0) => ('ine', 'a', 0)
 *    ('ieq', ('iabs', 'a'), 0) => ('ieq', 'a', 0)
 *    ('ine', ('iabs', 'a'), 0) => ('ine', 'a', 0)
 *    ('fneu', ('fabs', 'a'), 0.0) => ('fneu', 'a', 0.0)
 *    ('feq', ('fabs', 'a'), 0.0) => ('feq', 'a', 0.0)
 *    ('fneu', ('fabs', 'a'), ('fabs', 'a')) => ('fneu', 'a', 'a')
 *    ('feq', ('fabs', 'a'), ('fabs', 'a')) => ('feq', 'a', 'a')
 *    ('flt', '#b(is_gt_0_and_lt_1)', ('fsat(is_used_once)', 'a')) => ('flt', 'b', 'a')
 *    ('fge', ('fsat(is_used_once)', 'a'), '#b(is_gt_0_and_lt_1)') => ('fge', 'a', 'b')
 *    ('feq', ('fsat(is_used_once)', 'a'), '#b(is_gt_0_and_lt_1)') => ('feq', 'a', 'b')
 *    ('fneu', ('fsat(is_used_once)', 'a'), '#b(is_gt_0_and_lt_1)') => ('fneu', 'a', 'b')
 *    ('fge', ('fsat(is_used_once)', 'a'), 1.0) => ('fge', 'a', 1.0)
 *    ('flt', 0.0, ('fsat(is_used_once)', 'a')) => ('flt', 0.0, 'a')
 *    ('fge', 0.0, ('b2f', 'a@1')) => ('inot', 'a')
 *    ('fge', ('fneg', ('b2f', 'a@1')), 0.0) => ('inot', 'a')
 *    ('fneu', ('fadd', ('b2f', 'a@1'), ('b2f', 'b@1')), 0.0) => ('ior', 'a', 'b')
 *    ('fneu', ('bcsel', 'a', 1.0, ('b2f', 'b@1')), 0.0) => ('ior', 'a', 'b')
 *    ('fneu', ('b2f', 'a@1'), ('fneg', ('b2f', 'b@1'))) => ('ior', 'a', 'b')
 *    ('fneu', ('fmul', ('b2f', 'a@1'), ('b2f', 'b@1')), 0.0) => ('iand', 'a', 'b')
 *    ('fneu', ('bcsel', 'a', ('b2f', 'b@1'), 0.0), 0.0) => ('iand', 'a', 'b')
 *    ('fneu', ('fadd', ('b2f', 'a@1'), ('fneg', ('b2f', 'b@1'))), 0.0) => ('ixor', 'a', 'b')
 *    ('fneu', ('b2f', 'a@1'), ('b2f', 'b@1')) => ('ixor', 'a', 'b')
 *    ('fneu', ('fneg', ('b2f', 'a@1')), ('fneg', ('b2f', 'b@1'))) => ('ixor', 'a', 'b')
 *    ('feq', ('fadd', ('b2f', 'a@1'), ('b2f', 'b@1')), 0.0) => ('inot', ('ior', 'a', 'b'))
 *    ('feq', ('bcsel', 'a', 1.0, ('b2f', 'b@1')), 0.0) => ('inot', ('ior', 'a', 'b'))
 *    ('feq', ('b2f', 'a@1'), ('fneg', ('b2f', 'b@1'))) => ('inot', ('ior', 'a', 'b'))
 *    ('feq', ('fmul', ('b2f', 'a@1'), ('b2f', 'b@1')), 0.0) => ('inot', ('iand', 'a', 'b'))
 *    ('feq', ('bcsel', 'a', ('b2f', 'b@1'), 0.0), 0.0) => ('inot', ('iand', 'a', 'b'))
 *    ('feq', ('fadd', ('b2f', 'a@1'), ('fneg', ('b2f', 'b@1'))), 0.0) => ('ieq', 'a', 'b')
 *    ('feq', ('b2f', 'a@1'), ('b2f', 'b@1')) => ('ieq', 'a', 'b')
 *    ('feq', ('fneg', ('b2f', 'a@1')), ('fneg', ('b2f', 'b@1'))) => ('ieq', 'a', 'b')
 *    ('flt', ('fneg', ('fadd', ('b2f', 'a@1'), ('b2f', 'b@1'))), 0.0) => ('ior', 'a', 'b')
 *    ('flt', 0.0, ('fadd', ('b2f', 'a@1'), ('b2f', 'b@1'))) => ('ior', 'a', 'b')
 *    ('fge', ('fneg', ('fadd', ('b2f', 'a@1'), ('b2f', 'b@1'))), 0.0) => ('inot', ('ior', 'a', 'b'))
 *    ('fge', 0.0, ('fadd', ('b2f', 'a@1'), ('b2f', 'b@1'))) => ('inot', ('ior', 'a', 'b'))
 *    ('flt', 'a', ('fneg', 'a')) => ('flt', 'a', 0.0)
 *    ('fge', 'a', ('fneg', 'a')) => ('fge', 'a', 0.0)
 *    ('flt', ('fmin', 'c', ('fneg', ('fadd', ('b2f', 'a@1'), ('b2f', 'b@1')))), 0.0) => ('ior', ('flt', 'c', 0.0), ('ior', 'a', 'b'))
 *    ('~flt', ('fadd', 'a', 'b'), 'a') => ('flt', 'b', 0.0)
 *    ('~fge', ('fadd', 'a', 'b'), 'a') => ('fge', 'b', 0.0)
 *    ('~feq', ('fadd', 'a', 'b'), 'a') => ('feq', 'b', 0.0)
 *    ('~fneu', ('fadd', 'a', 'b'), 'a') => ('fneu', 'b', 0.0)
 *    ('~flt', ('fadd(is_used_once)', 'a', '#b'), '#c') => ('flt', 'a', ('fadd', 'c', ('fneg', 'b')))
 *    ('~flt', ('fneg(is_used_once)', ('fadd(is_used_once)', 'a', '#b')), '#c') => ('flt', ('fneg', ('fadd', 'c', 'b')), 'a')
 *    ('~fge', ('fadd(is_used_once)', 'a', '#b'), '#c') => ('fge', 'a', ('fadd', 'c', ('fneg', 'b')))
 *    ('~fge', ('fneg(is_used_once)', ('fadd(is_used_once)', 'a', '#b')), '#c') => ('fge', ('fneg', ('fadd', 'c', 'b')), 'a')
 *    ('~feq', ('fadd(is_used_once)', 'a', '#b'), '#c') => ('feq', 'a', ('fadd', 'c', ('fneg', 'b')))
 *    ('~feq', ('fneg(is_used_once)', ('fadd(is_used_once)', 'a', '#b')), '#c') => ('feq', ('fneg', ('fadd', 'c', 'b')), 'a')
 *    ('~fneu', ('fadd(is_used_once)', 'a', '#b'), '#c') => ('fneu', 'a', ('fadd', 'c', ('fneg', 'b')))
 *    ('~fneu', ('fneg(is_used_once)', ('fadd(is_used_once)', 'a', '#b')), '#c') => ('fneu', ('fneg', ('fadd', 'c', 'b')), 'a')
 *    ('ieq', ('iadd', 'a', 'b'), 'a') => ('ieq', 'b', 0)
 *    ('ine', ('iadd', 'a', 'b'), 'a') => ('ine', 'b', 0)
 *    ('feq', ('b2f', 'a@1'), 0.0) => ('inot', 'a')
 *    ('fge', 0.0, ('b2f', 'a@1')) => ('inot', 'a')
 *    ('fneu', ('b2f', 'a@1'), 0.0) => a
 *    ('flt', 0.0, ('b2f', 'a@1')) => a
 *    ('ieq', ('b2i', 'a@1'), 0) => ('inot', 'a')
 *    ('ine', ('b2i', 'a@1'), 0) => a
 *    ('ieq', 'a@1', False) => ('inot', 'a')
 *    ('ieq', 'a@1', True) => a
 *    ('ine', 'a@1', False) => a
 *    ('ine', 'a@1', True) => ('inot', 'a')
 *    ('fneu', ('u2f', 'a'), 0.0) => ('ine', 'a', 0)
 *    ('feq', ('u2f', 'a'), 0.0) => ('ieq', 'a', 0)
 *    ('fge', ('u2f', 'a'), 0.0) => True
 *    ('fge', 0.0, ('u2f', 'a')) => ('uge', 0, 'a')
 *    ('flt', ('u2f', 'a'), 0.0) => False
 *    ('flt', 0.0, ('u2f', 'a')) => ('ult', 0, 'a')
 *    ('fneu', ('i2f', 'a'), 0.0) => ('ine', 'a', 0)
 *    ('feq', ('i2f', 'a'), 0.0) => ('ieq', 'a', 0)
 *    ('fge', ('i2f', 'a'), 0.0) => ('ige', 'a', 0)
 *    ('fge', 0.0, ('i2f', 'a')) => ('ige', 0, 'a')
 *    ('flt', ('i2f', 'a'), 0.0) => ('ilt', 'a', 0)
 *    ('flt', 0.0, ('i2f', 'a')) => ('ilt', 0, 'a')
 *    ('~flt', 0.0, ('fabs', 'a')) => ('fneu', 'a', 0.0)
 *    ('~flt', ('fneg', ('fabs', 'a')), 0.0) => ('fneu', 'a', 0.0)
 *    ('fge', 0.0, ('fabs', 'a')) => ('feq', 'a', 0.0)
 *    ('fge', ('fneg', ('fabs', 'a')), 0.0) => ('feq', 'a', 0.0)
 *    ('iand', ('fge', 'a', 0.0), ('fge', 1.0, 'a')) => ('feq', 'a', ('fsat', 'a'))
 *    ('fmax', ('b2f(is_used_once)', 'a@1'), ('b2f', 'b@1')) => ('b2f', ('ior', 'a', 'b'))
 *    ('fmax', ('fneg(is_used_once)', ('b2f(is_used_once)', 'a@1')), ('fneg', ('b2f', 'b@1'))) => ('fneg', ('b2f', ('iand', 'a', 'b')))
 *    ('fmin', ('b2f(is_used_once)', 'a@1'), ('b2f', 'b@1')) => ('b2f', ('iand', 'a', 'b'))
 *    ('fmin', ('fneg(is_used_once)', ('b2f(is_used_once)', 'a@1')), ('fneg', ('b2f', 'b@1'))) => ('fneg', ('b2f', ('ior', 'a', 'b')))
 *    ('fmin', ('b2f', 'a@1'), '#b') => ('bcsel', 'a', ('fmin', 'b', 1.0), ('fmin', 'b', 0.0))
 *    ('flt', ('fadd(is_used_once)', 'a', ('fneg', 'b')), 0.0) => ('flt', 'a', 'b')
 *    ('fge', ('fneg', ('fabs', 'a')), 0.0) => ('feq', 'a', 0.0)
 *    ('~bcsel', ('flt', 'b', 'a'), 'b', 'a') => ('fmin', 'a', 'b')
 *    ('~bcsel', ('flt', 'a', 'b'), 'b', 'a') => ('fmax', 'a', 'b')
 *    ('~bcsel', ('fge', 'a', 'b'), 'b', 'a') => ('fmin', 'a', 'b')
 *    ('~bcsel', ('fge', 'b', 'a'), 'b', 'a') => ('fmax', 'a', 'b')
 *    ('bcsel', ('inot', 'a'), 'b', 'c') => ('bcsel', 'a', 'c', 'b')
 *    ('bcsel', 'a', ('bcsel', 'a', 'b', 'c'), 'd') => ('bcsel', 'a', 'b', 'd')
 *    ('bcsel', 'a', 'b', ('bcsel', 'a', 'c', 'd')) => ('bcsel', 'a', 'b', 'd')
 *    ('bcsel', 'a', ('bcsel', 'b', 'c', 'd'), ('bcsel(is_used_once)', 'b', 'c', 'e')) => ('bcsel', 'b', 'c', ('bcsel', 'a', 'd', 'e'))
 *    ('bcsel', 'a', ('bcsel(is_used_once)', 'b', 'c', 'd'), ('bcsel', 'b', 'c', 'e')) => ('bcsel', 'b', 'c', ('bcsel', 'a', 'd', 'e'))
 *    ('bcsel', 'a', ('bcsel', 'b', 'c', 'd'), ('bcsel(is_used_once)', 'b', 'e', 'd')) => ('bcsel', 'b', ('bcsel', 'a', 'c', 'e'), 'd')
 *    ('bcsel', 'a', ('bcsel(is_used_once)', 'b', 'c', 'd'), ('bcsel', 'b', 'e', 'd')) => ('bcsel', 'b', ('bcsel', 'a', 'c', 'e'), 'd')
 *    ('bcsel', 'a', True, 'b') => ('ior', 'a', 'b')
 *    ('bcsel', 'a', 'a', 'b') => ('ior', 'a', 'b')
 *    ('bcsel', 'a', 'b', False) => ('iand', 'a', 'b')
 *    ('bcsel', 'a', 'b', 'a') => ('iand', 'a', 'b')
 *    ('~fmin', 'a', 'a') => a
 *    ('~fmax', 'a', 'a') => a
 *    ('imin', 'a', 'a') => a
 *    ('imax', 'a', 'a') => a
 *    ('umin', 'a', 'a') => a
 *    ('umin', 'a', 0) => 0
 *    ('umin', 'a', -1) => a
 *    ('umax', 'a', 'a') => a
 *    ('umax', 'a', 0) => a
 *    ('umax', 'a', -1) => -1
 *    ('fmax', ('fmax', 'a', 'b'), 'b') => ('fmax', 'a', 'b')
 *    ('umax', ('umax', 'a', 'b'), 'b') => ('umax', 'a', 'b')
 *    ('imax', ('imax', 'a', 'b'), 'b') => ('imax', 'a', 'b')
 *    ('fmin', ('fmin', 'a', 'b'), 'b') => ('fmin', 'a', 'b')
 *    ('umin', ('umin', 'a', 'b'), 'b') => ('umin', 'a', 'b')
 *    ('imin', ('imin', 'a', 'b'), 'b') => ('imin', 'a', 'b')
 *    ('fmax', ('fmax', ('fmax', 'a', 'b'), 'c'), 'a') => ('fmax', ('fmax', 'a', 'b'), 'c')
 *    ('umax', ('umax', ('umax', 'a', 'b'), 'c'), 'a') => ('umax', ('umax', 'a', 'b'), 'c')
 *    ('imax', ('imax', ('imax', 'a', 'b'), 'c'), 'a') => ('imax', ('imax', 'a', 'b'), 'c')
 *    ('fmin', ('fmin', ('fmin', 'a', 'b'), 'c'), 'a') => ('fmin', ('fmin', 'a', 'b'), 'c')
 *    ('umin', ('umin', ('umin', 'a', 'b'), 'c'), 'a') => ('umin', ('umin', 'a', 'b'), 'c')
 *    ('imin', ('imin', ('imin', 'a', 'b'), 'c'), 'a') => ('imin', ('imin', 'a', 'b'), 'c')
 *    ('ieq', ('b2i8', 'a@1'), ('b2i8', 'b@1')) => ('ieq', 'a', 'b')
 *    ('ine', ('b2i8', 'a@1'), ('b2i8', 'b@1')) => ('ine', 'a', 'b')
 *    ('ieq', ('b2i16', 'a@1'), ('b2i16', 'b@1')) => ('ieq', 'a', 'b')
 *    ('ine', ('b2i16', 'a@1'), ('b2i16', 'b@1')) => ('ine', 'a', 'b')
 *    ('ieq', ('b2i32', 'a@1'), ('b2i32', 'b@1')) => ('ieq', 'a', 'b')
 *    ('ine', ('b2i32', 'a@1'), ('b2i32', 'b@1')) => ('ine', 'a', 'b')
 *    ('ieq', ('b2i64', 'a@1'), ('b2i64', 'b@1')) => ('ieq', 'a', 'b')
 *    ('ine', ('b2i64', 'a@1'), ('b2i64', 'b@1')) => ('ine', 'a', 'b')
 *    ('feq', ('b2f16', 'a@1'), ('b2f16', 'b@1')) => ('ieq', 'a', 'b')
 *    ('fneu', ('b2f16', 'a@1'), ('b2f16', 'b@1')) => ('ine', 'a', 'b')
 *    ('feq', ('b2f32', 'a@1'), ('b2f32', 'b@1')) => ('ieq', 'a', 'b')
 *    ('fneu', ('b2f32', 'a@1'), ('b2f32', 'b@1')) => ('ine', 'a', 'b')
 *    ('feq', ('b2f64', 'a@1'), ('b2f64', 'b@1')) => ('ieq', 'a', 'b')
 *    ('fneu', ('b2f64', 'a@1'), ('b2f64', 'b@1')) => ('ine', 'a', 'b')
 *    ('iand@8', 'a', ('inot', ('ishr', 'a', 7))) => ('imax', 'a', 0)
 *    ('ieq', ('iand', 'a@8', 128), 0) => ('ige', 'a', 0)
 *    ('ine', ('iand', 'a@8', 128), 128) => ('ige', 'a', 0)
 *    ('ine', ('iand', 'a@8', 128), 0) => ('ilt', 'a', 0)
 *    ('ieq', ('iand', 'a@8', 128), 128) => ('ilt', 'a', 0)
 *    ('ine', ('ushr', 'a@8', 7), 0) => ('ilt', 'a', 0)
 *    ('ieq', ('ushr', 'a@8', 7), 0) => ('ige', 'a', 0)
 *    ('ieq', ('ushr', 'a@8', 7), 1) => ('ilt', 'a', 0)
 *    ('ine', ('ushr', 'a@8', 7), 1) => ('ige', 'a', 0)
 *    ('ine', ('ishr', 'a@8', 7), 0) => ('ilt', 'a', 0)
 *    ('ieq', ('ishr', 'a@8', 7), 0) => ('ige', 'a', 0)
 *    ('ieq', ('ishr', 'a@8', 7), -1) => ('ilt', 'a', 0)
 *    ('ine', ('ishr', 'a@8', 7), -1) => ('ige', 'a', 0)
 *    ('iand@16', 'a', ('inot', ('ishr', 'a', 15))) => ('imax', 'a', 0)
 *    ('ieq', ('iand', 'a@16', 32768), 0) => ('ige', 'a', 0)
 *    ('ine', ('iand', 'a@16', 32768), 32768) => ('ige', 'a', 0)
 *    ('ine', ('iand', 'a@16', 32768), 0) => ('ilt', 'a', 0)
 *    ('ieq', ('iand', 'a@16', 32768), 32768) => ('ilt', 'a', 0)
 *    ('ine', ('ushr', 'a@16', 15), 0) => ('ilt', 'a', 0)
 *    ('ieq', ('ushr', 'a@16', 15), 0) => ('ige', 'a', 0)
 *    ('ieq', ('ushr', 'a@16', 15), 1) => ('ilt', 'a', 0)
 *    ('ine', ('ushr', 'a@16', 15), 1) => ('ige', 'a', 0)
 *    ('ine', ('ishr', 'a@16', 15), 0) => ('ilt', 'a', 0)
 *    ('ieq', ('ishr', 'a@16', 15), 0) => ('ige', 'a', 0)
 *    ('ieq', ('ishr', 'a@16', 15), -1) => ('ilt', 'a', 0)
 *    ('ine', ('ishr', 'a@16', 15), -1) => ('ige', 'a', 0)
 *    ('iand@32', 'a', ('inot', ('ishr', 'a', 31))) => ('imax', 'a', 0)
 *    ('ieq', ('iand', 'a@32', 2147483648), 0) => ('ige', 'a', 0)
 *    ('ine', ('iand', 'a@32', 2147483648), 2147483648) => ('ige', 'a', 0)
 *    ('ine', ('iand', 'a@32', 2147483648), 0) => ('ilt', 'a', 0)
 *    ('ieq', ('iand', 'a@32', 2147483648), 2147483648) => ('ilt', 'a', 0)
 *    ('ine', ('ushr', 'a@32', 31), 0) => ('ilt', 'a', 0)
 *    ('ieq', ('ushr', 'a@32', 31), 0) => ('ige', 'a', 0)
 *    ('ieq', ('ushr', 'a@32', 31), 1) => ('ilt', 'a', 0)
 *    ('ine', ('ushr', 'a@32', 31), 1) => ('ige', 'a', 0)
 *    ('ine', ('ishr', 'a@32', 31), 0) => ('ilt', 'a', 0)
 *    ('ieq', ('ishr', 'a@32', 31), 0) => ('ige', 'a', 0)
 *    ('ieq', ('ishr', 'a@32', 31), -1) => ('ilt', 'a', 0)
 *    ('ine', ('ishr', 'a@32', 31), -1) => ('ige', 'a', 0)
 *    ('iand@64', 'a', ('inot', ('ishr', 'a', 63))) => ('imax', 'a', 0)
 *    ('ieq', ('iand', 'a@64', 9223372036854775808), 0) => ('ige', 'a', 0)
 *    ('ine', ('iand', 'a@64', 9223372036854775808), 9223372036854775808) => ('ige', 'a', 0)
 *    ('ine', ('iand', 'a@64', 9223372036854775808), 0) => ('ilt', 'a', 0)
 *    ('ieq', ('iand', 'a@64', 9223372036854775808), 9223372036854775808) => ('ilt', 'a', 0)
 *    ('ine', ('ushr', 'a@64', 63), 0) => ('ilt', 'a', 0)
 *    ('ieq', ('ushr', 'a@64', 63), 0) => ('ige', 'a', 0)
 *    ('ieq', ('ushr', 'a@64', 63), 1) => ('ilt', 'a', 0)
 *    ('ine', ('ushr', 'a@64', 63), 1) => ('ige', 'a', 0)
 *    ('ine', ('ishr', 'a@64', 63), 0) => ('ilt', 'a', 0)
 *    ('ieq', ('ishr', 'a@64', 63), 0) => ('ige', 'a', 0)
 *    ('ieq', ('ishr', 'a@64', 63), -1) => ('ilt', 'a', 0)
 *    ('ine', ('ishr', 'a@64', 63), -1) => ('ige', 'a', 0)
 *    ('fmin', 'a', ('fneg', 'a')) => ('fneg', ('fabs', 'a'))
 *    ('imin', 'a', ('ineg', 'a')) => ('ineg', ('iabs', 'a'))
 *    ('fmin', 'a', ('fneg', ('fabs', 'a'))) => ('fneg', ('fabs', 'a'))
 *    ('imin', 'a', ('ineg', ('iabs', 'a'))) => ('ineg', ('iabs', 'a'))
 *    ('~fmin', 'a', ('fabs', 'a')) => a
 *    ('imin', 'a', ('iabs', 'a')) => a
 *    ('~fmax', 'a', ('fneg', ('fabs', 'a'))) => a
 *    ('imax', 'a', ('ineg', ('iabs', 'a'))) => a
 *    ('fmax', 'a', ('fabs', 'a')) => ('fabs', 'a')
 *    ('imax', 'a', ('iabs', 'a')) => ('iabs', 'a')
 *    ('fmax', 'a', ('fneg', 'a')) => ('fabs', 'a')
 *    ('imax', 'a', ('ineg', 'a')) => ('iabs', 'a')
 *    ('~fmax', ('fabs', 'a'), 0.0) => ('fabs', 'a')
 *    ('fmin', ('fmax', 'a', 0.0), 1.0) => ('fsat', 'a')
 *    ('~fmax', ('fmin', 'a', 1.0), 0.0) => ('fsat', 'a')
 *    ('~fmin', ('fmax', 'a', -1.0), 0.0) => ('fneg', ('fsat', ('fneg', 'a')))
 *    ('~fmax', ('fmin', 'a', 0.0), -1.0) => ('fneg', ('fsat', ('fneg', 'a')))
 *    ('fsat', ('fsign', 'a')) => ('b2f', ('!flt', 0.0, 'a'))
 *    ('fsat', ('b2f', 'a')) => ('b2f', 'a')
 *    ('fsat', 'a') => ('fmin', ('fmax', 'a', 0.0), 1.0)
 *    ('fsat', ('fsat', 'a')) => ('fsat', 'a')
 *    ('fsat', ('fneg(is_used_once)', ('fadd(is_used_once)', 'a', 'b'))) => ('fsat', ('fadd', ('fneg', 'a'), ('fneg', 'b')))
 *    ('fsat', ('fneg(is_used_once)', ('fmul(is_used_once)', 'a', 'b'))) => ('fsat', ('fmul', ('fneg', 'a'), 'b'))
 *    ('fsat(nsz)', ('fneg(is_used_once)', ('fmulz(is_used_once)', 'a', 'b'))) => ('fsat', ('fmulz', ('fneg', 'a'), 'b'))
 *    ('fsat', ('fabs(is_used_once)', ('fmul(is_used_once)', 'a', 'b'))) => ('fsat', ('fmul', ('fabs', 'a'), ('fabs', 'b')))
 *    ('fmin', ('fmax', ('fmin', ('fmax', 'a', 'b'), 'c'), 'b'), 'c') => ('fmin', ('fmax', 'a', 'b'), 'c')
 *    ('imin', ('imax', ('imin', ('imax', 'a', 'b'), 'c'), 'b'), 'c') => ('imin', ('imax', 'a', 'b'), 'c')
 *    ('umin', ('umax', ('umin', ('umax', 'a', 'b'), 'c'), 'b'), 'c') => ('umin', ('umax', 'a', 'b'), 'c')
 *    ('fmax', ('fsat', 'a'), '#b(is_zero_to_one)') => ('fsat', ('fmax', 'a', 'b'))
 *    ('fmax', ('fsat(is_used_once)', 'a'), ('fsat(is_used_once)', 'b')) => ('fsat', ('fmax', 'a', 'b'))
 *    ('~fmin', ('fsat', 'a'), '#b(is_zero_to_one)') => ('fsat', ('fmin', 'a', 'b'))
 *    ('fmax', ('fneg', ('fmin', 'b', 'a')), 'b') => ('fmax', ('fabs', 'b'), ('fneg', 'a'))
 *    ('fmin', ('fneg', ('fmax', 'b', 'a')), 'b') => ('fmin', ('fneg', ('fabs', 'b')), ('fneg', 'a'))
 *    ('fmax', ('fadd(is_used_once)', ('fneg', 'a(is_not_negative)'), '#b(is_zero_to_one)'), 0.0) => ('fsat', ('fadd', ('fneg', 'a'), 'b'))
 *    ('extract_u8', ('imin', ('imax', 'a', 0), 255), 0) => ('imin', ('imax', 'a', 0), 255)
 *    ('ior', ('flt(is_used_once)', 'a', 'b'), ('flt', 'a', 'c')) => ('flt', 'a', ('!fmax', 'b', 'c'))
 *    ('ior', ('flt(is_used_once)', 'a', 'c'), ('flt', 'b', 'c')) => ('flt', ('!fmin', 'a', 'b'), 'c')
 *    ('ior', ('fge(is_used_once)', 'a', 'b'), ('fge', 'a', 'c')) => ('fge', 'a', ('!fmin', 'b', 'c'))
 *    ('ior', ('fge(is_used_once)', 'a', 'c'), ('fge', 'b', 'c')) => ('fge', ('!fmax', 'a', 'b'), 'c')
 *    ('ior', ('flt', 'a', '#b'), ('flt', 'a', '#c')) => ('flt', 'a', ('!fmax', 'b', 'c'))
 *    ('ior', ('flt', '#a', 'c'), ('flt', '#b', 'c')) => ('flt', ('!fmin', 'a', 'b'), 'c')
 *    ('ior', ('fge', 'a', '#b'), ('fge', 'a', '#c')) => ('fge', 'a', ('!fmin', 'b', 'c'))
 *    ('ior', ('fge', '#a', 'c'), ('fge', '#b', 'c')) => ('fge', ('!fmax', 'a', 'b'), 'c')
 *    ('~iand', ('flt(is_used_once)', 'a', 'b'), ('flt', 'a', 'c')) => ('flt', 'a', ('fmin', 'b', 'c'))
 *    ('~iand', ('flt(is_used_once)', 'a', 'c'), ('flt', 'b', 'c')) => ('flt', ('fmax', 'a', 'b'), 'c')
 *    ('~iand', ('fge(is_used_once)', 'a', 'b'), ('fge', 'a', 'c')) => ('fge', 'a', ('fmax', 'b', 'c'))
 *    ('~iand', ('fge(is_used_once)', 'a', 'c'), ('fge', 'b', 'c')) => ('fge', ('fmin', 'a', 'b'), 'c')
 *    ('iand', ('flt', 'a', '#b(is_a_number)'), ('flt', 'a', '#c(is_a_number)')) => ('flt', 'a', ('fmin', 'b', 'c'))
 *    ('iand', ('flt', '#a(is_a_number)', 'c'), ('flt', '#b(is_a_number)', 'c')) => ('flt', ('fmax', 'a', 'b'), 'c')
 *    ('iand', ('fge', 'a', '#b(is_a_number)'), ('fge', 'a', '#c(is_a_number)')) => ('fge', 'a', ('fmax', 'b', 'c'))
 *    ('iand', ('fge', '#a(is_a_number)', 'c'), ('fge', '#b(is_a_number)', 'c')) => ('fge', ('fmin', 'a', 'b'), 'c')
 *    ('ior', ('ilt(is_used_once)', 'a', 'b'), ('ilt', 'a', 'c')) => ('ilt', 'a', ('imax', 'b', 'c'))
 *    ('ior', ('ilt(is_used_once)', 'a', 'c'), ('ilt', 'b', 'c')) => ('ilt', ('imin', 'a', 'b'), 'c')
 *    ('ior', ('ige(is_used_once)', 'a', 'b'), ('ige', 'a', 'c')) => ('ige', 'a', ('imin', 'b', 'c'))
 *    ('ior', ('ige(is_used_once)', 'a', 'c'), ('ige', 'b', 'c')) => ('ige', ('imax', 'a', 'b'), 'c')
 *    ('ior', ('ult(is_used_once)', 'a', 'b'), ('ult', 'a', 'c')) => ('ult', 'a', ('umax', 'b', 'c'))
 *    ('ior', ('ult(is_used_once)', 'a', 'c'), ('ult', 'b', 'c')) => ('ult', ('umin', 'a', 'b'), 'c')
 *    ('ior', ('uge(is_used_once)', 'a', 'b'), ('uge', 'a', 'c')) => ('uge', 'a', ('umin', 'b', 'c'))
 *    ('ior', ('uge(is_used_once)', 'a', 'c'), ('uge', 'b', 'c')) => ('uge', ('umax', 'a', 'b'), 'c')
 *    ('iand', ('ilt(is_used_once)', 'a', 'b'), ('ilt', 'a', 'c')) => ('ilt', 'a', ('imin', 'b', 'c'))
 *    ('iand', ('ilt(is_used_once)', 'a', 'c'), ('ilt', 'b', 'c')) => ('ilt', ('imax', 'a', 'b'), 'c')
 *    ('iand', ('ige(is_used_once)', 'a', 'b'), ('ige', 'a', 'c')) => ('ige', 'a', ('imax', 'b', 'c'))
 *    ('iand', ('ige(is_used_once)', 'a', 'c'), ('ige', 'b', 'c')) => ('ige', ('imin', 'a', 'b'), 'c')
 *    ('iand', ('ult(is_used_once)', 'a', 'b'), ('ult', 'a', 'c')) => ('ult', 'a', ('umin', 'b', 'c'))
 *    ('iand', ('ult(is_used_once)', 'a', 'c'), ('ult', 'b', 'c')) => ('ult', ('umax', 'a', 'b'), 'c')
 *    ('iand', ('uge(is_used_once)', 'a', 'b'), ('uge', 'a', 'c')) => ('uge', 'a', ('umax', 'b', 'c'))
 *    ('iand', ('uge(is_used_once)', 'a', 'c'), ('uge', 'b', 'c')) => ('uge', ('umin', 'a', 'b'), 'c')
 *    ('ior', ('ior(is_used_once)', ('flt(is_used_once)', 'a', 'c'), 'd'), ('flt', 'b', 'c')) => ('ior', ('flt', ('!fmin', 'a', 'b'), 'c'), 'd')
 *    ('ior', ('ior(is_used_once)', ('flt', 'a', 'c'), 'd'), ('flt(is_used_once)', 'b', 'c')) => ('ior', ('flt', ('!fmin', 'a', 'b'), 'c'), 'd')
 *    ('ior', ('ior(is_used_once)', ('flt(is_used_once)', 'a', 'b'), 'd'), ('flt', 'a', 'c')) => ('ior', ('flt', 'a', ('!fmax', 'b', 'c')), 'd')
 *    ('ior', ('ior(is_used_once)', ('flt', 'a', 'b'), 'd'), ('flt(is_used_once)', 'a', 'c')) => ('ior', ('flt', 'a', ('!fmax', 'b', 'c')), 'd')
 *    ('ior', ('flt', 'a(is_a_number)', 'b(is_a_number)'), ('flt', 'b', 'a')) => ('fneu', 'a', 'b')
 *    ('umin', ('iand', 'a', '#b(is_pos_power_of_two)'), ('iand', 'c', 'b')) => ('iand', ('iand', 'a', 'b'), ('iand', 'c', 'b'))
 *    ('ior', ('flt(is_used_once)', 0.0, 'a@16'), ('flt', 'b@16', 0.0)) => ('flt', 0.0, ('fmax', 'a', ('fneg', 'b')))
 *    ('ior', ('flt', 0.0, 'a@16'), ('flt(is_used_once)', 'b@16', 0.0)) => ('flt', 0.0, ('fmax', 'a', ('fneg', 'b')))
 *    ('ior', ('fge(is_used_once)', 0.0, 'a@16'), ('fge', 'b@16', 0.0)) => ('fge', 0.0, ('fmin', 'a', ('fneg', 'b')))
 *    ('ior', ('fge', 0.0, 'a@16'), ('fge(is_used_once)', 'b@16', 0.0)) => ('fge', 0.0, ('fmin', 'a', ('fneg', 'b')))
 *    ('~iand', ('flt(is_used_once)', 0.0, 'a@16'), ('flt', 'b@16', 0.0)) => ('flt', 0.0, ('fmin', 'a', ('fneg', 'b')))
 *    ('~iand', ('flt', 0.0, 'a@16'), ('flt(is_used_once)', 'b@16', 0.0)) => ('flt', 0.0, ('fmin', 'a', ('fneg', 'b')))
 *    ('~iand', ('fge(is_used_once)', 0.0, 'a@16'), ('fge', 'b@16', 0.0)) => ('fge', 0.0, ('fmax', 'a', ('fneg', 'b')))
 *    ('~iand', ('fge', 0.0, 'a@16'), ('fge(is_used_once)', 'b@16', 0.0)) => ('fge', 0.0, ('fmax', 'a', ('fneg', 'b')))
 *    ('ior', ('feq(is_used_once)', 'a@16', 0.0), ('feq', 'b@16', 0.0)) => ('feq', ('fmin', ('fabs', 'a'), ('fabs', 'b')), 0.0)
 *    ('ior', ('fneu(is_used_once)', 'a@16', 0.0), ('fneu', 'b@16', 0.0)) => ('fneu', ('fadd', ('fabs', 'a'), ('fabs', 'b')), 0.0)
 *    ('iand', ('feq(is_used_once)', 'a@16', 0.0), ('feq', 'b@16', 0.0)) => ('feq', ('fadd', ('fabs', 'a'), ('fabs', 'b')), 0.0)
 *    ('iand', ('fneu(is_used_once)', 'a@16', 0.0), ('fneu', 'b@16', 0.0)) => ('fneu', ('fmin', ('fabs', 'a'), ('fabs', 'b')), 0.0)
 *    ('bcsel@16', ('feq', 'a', 0.0), 1.0, ('i2f16', ('iadd', ('b2i16', ('flt', 0.0, 'a@16')), ('ineg', ('b2i16', ('flt', 'a@16', 0.0)))))) => ('i2f16', ('iadd', ('b2i32', ('!fge', 'a', 0.0)), ('ineg', ('b2i32', ('!flt', 'a', 0.0)))))
 *    ('bcsel', 'a', ('b2f(is_used_once)', 'b@16'), ('b2f', 'c@16')) => ('b2f', ('bcsel', 'a', 'b', 'c'))
 *    ('~i2f16', ('f2i', 'a@16')) => ('ftrunc', 'a')
 *    ('~f2i16', ('i2f', 'a@16')) => a
 *    ('~f2i16', ('u2f', 'a@16')) => a
 *    ('~f2u16', ('i2f', 'a@16')) => a
 *    ('~f2u16', ('u2f', 'a@16')) => a
 *    ('fadd', ('b2f16', ('flt', 0.0, 'a@16')), ('fneg', ('b2f16', ('flt', 'a@16', 0.0)))) => ('fsign', 'a')
 *    ('iadd', ('b2i16', ('flt', 0, 'a@16')), ('ineg', ('b2i16', ('flt', 'a@16', 0)))) => ('f2i16', ('fsign', 'a'))
 *    ('~f2f16', ('f2f', 'a')) => ('f2f16', 'a')
 *    ('~f2f16', ('u2f', 'a')) => ('u2f16', 'a')
 *    ('~f2f16', ('i2f', 'a')) => ('i2f16', 'a')
 *    ('~f2u16', ('f2f', 'a')) => ('f2u16', 'a')
 *    ('~f2i16', ('f2f', 'a')) => ('f2i16', 'a')
 *    ('i2f16', ('f2i', ('fsign', 'a@16'))) => ('fsign', 'a')
 *    ('~f2f16', ('f2f32', 'a@16')) => a
 *    ('f2u32', ('f2f32', 'a@16')) => ('f2u32', 'a')
 *    ('f2i32', ('f2f32', 'a@16')) => ('f2i32', 'a')
 *    ('f2f16', ('u2f32', 'a')) => ('u2f16', 'a')
 *    ('f2f16', ('i2f32', 'a')) => ('i2f16', 'a')
 *    ('~f2f16', ('f2f64', 'a@16')) => a
 *    ('f2u64', ('f2f64', 'a@16')) => ('f2u64', 'a')
 *    ('f2i64', ('f2f64', 'a@16')) => ('f2i64', 'a')
 *    ('f2f16', ('u2f64', 'a')) => ('u2f16', 'a')
 *    ('f2f16', ('i2f64', 'a')) => ('i2f16', 'a')
 *    ('ior', ('flt(is_used_once)', 0.0, 'a@32'), ('flt', 'b@32', 0.0)) => ('flt', 0.0, ('fmax', 'a', ('fneg', 'b')))
 *    ('ior', ('flt', 0.0, 'a@32'), ('flt(is_used_once)', 'b@32', 0.0)) => ('flt', 0.0, ('fmax', 'a', ('fneg', 'b')))
 *    ('ior', ('fge(is_used_once)', 0.0, 'a@32'), ('fge', 'b@32', 0.0)) => ('fge', 0.0, ('fmin', 'a', ('fneg', 'b')))
 *    ('ior', ('fge', 0.0, 'a@32'), ('fge(is_used_once)', 'b@32', 0.0)) => ('fge', 0.0, ('fmin', 'a', ('fneg', 'b')))
 *    ('~iand', ('flt(is_used_once)', 0.0, 'a@32'), ('flt', 'b@32', 0.0)) => ('flt', 0.0, ('fmin', 'a', ('fneg', 'b')))
 *    ('~iand', ('flt', 0.0, 'a@32'), ('flt(is_used_once)', 'b@32', 0.0)) => ('flt', 0.0, ('fmin', 'a', ('fneg', 'b')))
 *    ('~iand', ('fge(is_used_once)', 0.0, 'a@32'), ('fge', 'b@32', 0.0)) => ('fge', 0.0, ('fmax', 'a', ('fneg', 'b')))
 *    ('~iand', ('fge', 0.0, 'a@32'), ('fge(is_used_once)', 'b@32', 0.0)) => ('fge', 0.0, ('fmax', 'a', ('fneg', 'b')))
 *    ('ior', ('feq(is_used_once)', 'a@32', 0.0), ('feq', 'b@32', 0.0)) => ('feq', ('fmin', ('fabs', 'a'), ('fabs', 'b')), 0.0)
 *    ('ior', ('fneu(is_used_once)', 'a@32', 0.0), ('fneu', 'b@32', 0.0)) => ('fneu', ('fadd', ('fabs', 'a'), ('fabs', 'b')), 0.0)
 *    ('iand', ('feq(is_used_once)', 'a@32', 0.0), ('feq', 'b@32', 0.0)) => ('feq', ('fadd', ('fabs', 'a'), ('fabs', 'b')), 0.0)
 *    ('iand', ('fneu(is_used_once)', 'a@32', 0.0), ('fneu', 'b@32', 0.0)) => ('fneu', ('fmin', ('fabs', 'a'), ('fabs', 'b')), 0.0)
 *    ('bcsel@32', ('feq', 'a', 0.0), 1.0, ('i2f32', ('iadd', ('b2i32', ('flt', 0.0, 'a@32')), ('ineg', ('b2i32', ('flt', 'a@32', 0.0)))))) => ('i2f32', ('iadd', ('b2i32', ('!fge', 'a', 0.0)), ('ineg', ('b2i32', ('!flt', 'a', 0.0)))))
 *    ('bcsel', 'a', ('b2f(is_used_once)', 'b@32'), ('b2f', 'c@32')) => ('b2f', ('bcsel', 'a', 'b', 'c'))
 *    ('~i2f32', ('f2i', 'a@32')) => ('ftrunc', 'a')
 *    ('~f2i32', ('i2f', 'a@32')) => a
 *    ('~f2i32', ('u2f', 'a@32')) => a
 *    ('~f2u32', ('i2f', 'a@32')) => a
 *    ('~f2u32', ('u2f', 'a@32')) => a
 *    ('fadd', ('b2f32', ('flt', 0.0, 'a@32')), ('fneg', ('b2f32', ('flt', 'a@32', 0.0)))) => ('fsign', 'a')
 *    ('iadd', ('b2i32', ('flt', 0, 'a@32')), ('ineg', ('b2i32', ('flt', 'a@32', 0)))) => ('f2i32', ('fsign', 'a'))
 *    ('~f2f32', ('f2f', 'a')) => ('f2f32', 'a')
 *    ('~f2f32', ('u2f', 'a')) => ('u2f32', 'a')
 *    ('~f2f32', ('i2f', 'a')) => ('i2f32', 'a')
 *    ('~f2u32', ('f2f', 'a')) => ('f2u32', 'a')
 *    ('~f2i32', ('f2f', 'a')) => ('f2i32', 'a')
 *    ('i2f32', ('f2i', ('fsign', 'a@32'))) => ('fsign', 'a')
 *    ('~f2f32', ('f2f64', 'a@32')) => a
 *    ('f2u64', ('f2f64', 'a@32')) => ('f2u64', 'a')
 *    ('f2i64', ('f2f64', 'a@32')) => ('f2i64', 'a')
 *    ('f2f32', ('u2f64', 'a')) => ('u2f32', 'a')
 *    ('f2f32', ('i2f64', 'a')) => ('i2f32', 'a')
 *    ('ior', ('flt(is_used_once)', 0.0, 'a@64'), ('flt', 'b@64', 0.0)) => ('flt', 0.0, ('fmax', 'a', ('fneg', 'b')))
 *    ('ior', ('flt', 0.0, 'a@64'), ('flt(is_used_once)', 'b@64', 0.0)) => ('flt', 0.0, ('fmax', 'a', ('fneg', 'b')))
 *    ('ior', ('fge(is_used_once)', 0.0, 'a@64'), ('fge', 'b@64', 0.0)) => ('fge', 0.0, ('fmin', 'a', ('fneg', 'b')))
 *    ('ior', ('fge', 0.0, 'a@64'), ('fge(is_used_once)', 'b@64', 0.0)) => ('fge', 0.0, ('fmin', 'a', ('fneg', 'b')))
 *    ('~iand', ('flt(is_used_once)', 0.0, 'a@64'), ('flt', 'b@64', 0.0)) => ('flt', 0.0, ('fmin', 'a', ('fneg', 'b')))
 *    ('~iand', ('flt', 0.0, 'a@64'), ('flt(is_used_once)', 'b@64', 0.0)) => ('flt', 0.0, ('fmin', 'a', ('fneg', 'b')))
 *    ('~iand', ('fge(is_used_once)', 0.0, 'a@64'), ('fge', 'b@64', 0.0)) => ('fge', 0.0, ('fmax', 'a', ('fneg', 'b')))
 *    ('~iand', ('fge', 0.0, 'a@64'), ('fge(is_used_once)', 'b@64', 0.0)) => ('fge', 0.0, ('fmax', 'a', ('fneg', 'b')))
 *    ('ior', ('feq(is_used_once)', 'a@64', 0.0), ('feq', 'b@64', 0.0)) => ('feq', ('fmin', ('fabs', 'a'), ('fabs', 'b')), 0.0)
 *    ('ior', ('fneu(is_used_once)', 'a@64', 0.0), ('fneu', 'b@64', 0.0)) => ('fneu', ('fadd', ('fabs', 'a'), ('fabs', 'b')), 0.0)
 *    ('iand', ('feq(is_used_once)', 'a@64', 0.0), ('feq', 'b@64', 0.0)) => ('feq', ('fadd', ('fabs', 'a'), ('fabs', 'b')), 0.0)
 *    ('iand', ('fneu(is_used_once)', 'a@64', 0.0), ('fneu', 'b@64', 0.0)) => ('fneu', ('fmin', ('fabs', 'a'), ('fabs', 'b')), 0.0)
 *    ('bcsel@64', ('feq', 'a', 0.0), 1.0, ('i2f64', ('iadd', ('b2i64', ('flt', 0.0, 'a@64')), ('ineg', ('b2i64', ('flt', 'a@64', 0.0)))))) => ('i2f64', ('iadd', ('b2i32', ('!fge', 'a', 0.0)), ('ineg', ('b2i32', ('!flt', 'a', 0.0)))))
 *    ('bcsel', 'a', ('b2f(is_used_once)', 'b@64'), ('b2f', 'c@64')) => ('b2f', ('bcsel', 'a', 'b', 'c'))
 *    ('~i2f64', ('f2i', 'a@64')) => ('ftrunc', 'a')
 *    ('~f2i64', ('i2f', 'a@64')) => a
 *    ('~f2i64', ('u2f', 'a@64')) => a
 *    ('~f2u64', ('i2f', 'a@64')) => a
 *    ('~f2u64', ('u2f', 'a@64')) => a
 *    ('fadd', ('b2f64', ('flt', 0.0, 'a@64')), ('fneg', ('b2f64', ('flt', 'a@64', 0.0)))) => ('fsign', 'a')
 *    ('iadd', ('b2i64', ('flt', 0, 'a@64')), ('ineg', ('b2i64', ('flt', 'a@64', 0)))) => ('f2i64', ('fsign', 'a'))
 *    ('~f2f64', ('f2f', 'a')) => ('f2f64', 'a')
 *    ('~f2f64', ('u2f', 'a')) => ('u2f64', 'a')
 *    ('~f2f64', ('i2f', 'a')) => ('i2f64', 'a')
 *    ('~f2u64', ('f2f', 'a')) => ('f2u64', 'a')
 *    ('~f2i64', ('f2f', 'a')) => ('f2i64', 'a')
 *    ('i2f64', ('f2i', ('fsign', 'a@64'))) => ('fsign', 'a')
 *    ('i2i1', ('i2i8', 'a@1')) => a
 *    ('u2u1', ('u2u8', 'a@1')) => a
 *    ('i2i1', ('i2i16', 'a@1')) => a
 *    ('u2u1', ('u2u16', 'a@1')) => a
 *    ('u2f16', ('u2u8', 'a@1')) => ('u2f16', 'a')
 *    ('i2f16', ('i2i8', 'a@1')) => ('i2f16', 'a')
 *    ('u2f16', ('u2u16', 'a@1')) => ('u2f16', 'a')
 *    ('i2f16', ('i2i16', 'a@1')) => ('i2f16', 'a')
 *    ('u2f16', ('u2u32', 'a@1')) => ('u2f16', 'a')
 *    ('i2f16', ('i2i32', 'a@1')) => ('i2f16', 'a')
 *    ('u2f16', ('u2u64', 'a@1')) => ('u2f16', 'a')
 *    ('i2f16', ('i2i64', 'a@1')) => ('i2f16', 'a')
 *    ('i2i1', ('i2i32', 'a@1')) => a
 *    ('u2u1', ('u2u32', 'a@1')) => a
 *    ('u2f32', ('u2u8', 'a@1')) => ('u2f32', 'a')
 *    ('i2f32', ('i2i8', 'a@1')) => ('i2f32', 'a')
 *    ('u2f32', ('u2u16', 'a@1')) => ('u2f32', 'a')
 *    ('i2f32', ('i2i16', 'a@1')) => ('i2f32', 'a')
 *    ('u2f32', ('u2u32', 'a@1')) => ('u2f32', 'a')
 *    ('i2f32', ('i2i32', 'a@1')) => ('i2f32', 'a')
 *    ('u2f32', ('u2u64', 'a@1')) => ('u2f32', 'a')
 *    ('i2f32', ('i2i64', 'a@1')) => ('i2f32', 'a')
 *    ('i2i1', ('i2i64', 'a@1')) => a
 *    ('u2u1', ('u2u64', 'a@1')) => a
 *    ('u2f64', ('u2u8', 'a@1')) => ('u2f64', 'a')
 *    ('i2f64', ('i2i8', 'a@1')) => ('i2f64', 'a')
 *    ('u2f64', ('u2u16', 'a@1')) => ('u2f64', 'a')
 *    ('i2f64', ('i2i16', 'a@1')) => ('i2f64', 'a')
 *    ('u2f64', ('u2u32', 'a@1')) => ('u2f64', 'a')
 *    ('i2f64', ('i2i32', 'a@1')) => ('i2f64', 'a')
 *    ('u2f64', ('u2u64', 'a@1')) => ('u2f64', 'a')
 *    ('i2f64', ('i2i64', 'a@1')) => ('i2f64', 'a')
 *    ('i2i8', ('i2i16', 'a@8')) => a
 *    ('u2u8', ('u2u16', 'a@8')) => a
 *    ('u2f16', ('u2u16', 'a@8')) => ('u2f16', 'a')
 *    ('i2f16', ('i2i16', 'a@8')) => ('i2f16', 'a')
 *    ('u2f16', ('u2u32', 'a@8')) => ('u2f16', 'a')
 *    ('i2f16', ('i2i32', 'a@8')) => ('i2f16', 'a')
 *    ('u2f16', ('u2u64', 'a@8')) => ('u2f16', 'a')
 *    ('i2f16', ('i2i64', 'a@8')) => ('i2f16', 'a')
 *    ('i2i8', ('i2i32', 'a@8')) => a
 *    ('u2u8', ('u2u32', 'a@8')) => a
 *    ('u2f32', ('u2u16', 'a@8')) => ('u2f32', 'a')
 *    ('i2f32', ('i2i16', 'a@8')) => ('i2f32', 'a')
 *    ('u2f32', ('u2u32', 'a@8')) => ('u2f32', 'a')
 *    ('i2f32', ('i2i32', 'a@8')) => ('i2f32', 'a')
 *    ('u2f32', ('u2u64', 'a@8')) => ('u2f32', 'a')
 *    ('i2f32', ('i2i64', 'a@8')) => ('i2f32', 'a')
 *    ('i2i8', ('i2i64', 'a@8')) => a
 *    ('u2u8', ('u2u64', 'a@8')) => a
 *    ('u2f64', ('u2u16', 'a@8')) => ('u2f64', 'a')
 *    ('i2f64', ('i2i16', 'a@8')) => ('i2f64', 'a')
 *    ('u2f64', ('u2u32', 'a@8')) => ('u2f64', 'a')
 *    ('i2f64', ('i2i32', 'a@8')) => ('i2f64', 'a')
 *    ('u2f64', ('u2u64', 'a@8')) => ('u2f64', 'a')
 *    ('i2f64', ('i2i64', 'a@8')) => ('i2f64', 'a')
 *    ('i2i16', ('i2i32', 'a@16')) => a
 *    ('u2u16', ('u2u32', 'a@16')) => a
 *    ('u2f32', ('u2u32', 'a@16')) => ('u2f32', 'a')
 *    ('i2f32', ('i2i32', 'a@16')) => ('i2f32', 'a')
 *    ('u2f32', ('u2u64', 'a@16')) => ('u2f32', 'a')
 *    ('i2f32', ('i2i64', 'a@16')) => ('i2f32', 'a')
 *    ('i2i16', ('i2i64', 'a@16')) => a
 *    ('u2u16', ('u2u64', 'a@16')) => a
 *    ('u2f64', ('u2u32', 'a@16')) => ('u2f64', 'a')
 *    ('i2f64', ('i2i32', 'a@16')) => ('i2f64', 'a')
 *    ('u2f64', ('u2u64', 'a@16')) => ('u2f64', 'a')
 *    ('i2f64', ('i2i64', 'a@16')) => ('i2f64', 'a')
 *    ('i2i32', ('i2i64', 'a@32')) => a
 *    ('u2u32', ('u2u64', 'a@32')) => a
 *    ('u2f64', ('u2u64', 'a@32')) => ('u2f64', 'a')
 *    ('i2f64', ('i2i64', 'a@32')) => ('i2f64', 'a')
 *    ('f2fmp', ('u2f32', 'a@32')) => ('u2fmp', 'a')
 *    ('f2fmp', ('i2f32', 'a@32')) => ('i2fmp', 'a')
 *    ('f2u16', ('f2fmp', 'a@32')) => ('f2u16', 'a')
 *    ('f2i16', ('f2fmp', 'a@32')) => ('f2i16', 'a')
 *    ('i2imp', ('f2u32', 'a@32')) => ('f2ump', 'a')
 *    ('i2imp', ('f2i32', 'a@32')) => ('f2imp', 'a')
 *    ('u2f16', ('i2imp', 'a@32')) => ('u2f16', 'a')
 *    ('i2f16', ('i2imp', 'a@32')) => ('i2f16', 'a')
 *    ('iand', ('u2u16', ('u2u8', 'a@16')), '#b') => ('iand', 'a', ('iand', 'b', 255))
 *    ('u2u16', ('u2u8(is_used_once)', ('iand', 'a@16', '#b'))) => ('iand', 'a', ('iand', 'b', 255))
 *    ('u2u8', ('iand', ('u2u16', ('u2u8', 'a@16')), ('u2u16', ('u2u8', 'b@16')))) => ('u2u8', ('iand', 'a', 'b'))
 *    ('u2u8', ('iand', ('u2u16', ('u2u8', 'a@32')), ('u2u16', ('u2u8', 'b@32')))) => ('u2u8', ('iand', 'a', 'b'))
 *    ('iand', ('extract_i8', 'a', '#b'), ('extract_i8', 'c', 'b')) => ('extract_i8', ('iand', 'a', 'c'), 'b')
 *    ('iand', ('extract_u8', 'a', '#b'), ('extract_u8', 'c', 'b')) => ('extract_u8', ('iand', 'a', 'c'), 'b')
 *    ('iand', ('extract_i16', 'a', '#b'), ('extract_i16', 'c', 'b')) => ('extract_i16', ('iand', 'a', 'c'), 'b')
 *    ('iand', ('extract_u16', 'a', '#b'), ('extract_u16', 'c', 'b')) => ('extract_u16', ('iand', 'a', 'c'), 'b')
 *    ('iand', ('ushr(is_used_once)', 'a', '#b'), ('ushr', 'c', 'b')) => ('ushr', ('iand', 'a', 'c'), 'b')
 *    ('iand', ('ishr(is_used_once)', 'a', '#b'), ('ishr', 'c', 'b')) => ('ishr', ('iand', 'a', 'c'), 'b')
 *    ('iand', ('ishl(is_used_once)', 'a', '#b'), ('ishl', 'c', 'b')) => ('ishl', ('iand', 'a', 'c'), 'b')
 *    ('u2u8', ('ior', ('u2u16', ('u2u8', 'a@16')), ('u2u16', ('u2u8', 'b@16')))) => ('u2u8', ('ior', 'a', 'b'))
 *    ('u2u8', ('ior', ('u2u16', ('u2u8', 'a@32')), ('u2u16', ('u2u8', 'b@32')))) => ('u2u8', ('ior', 'a', 'b'))
 *    ('ior', ('extract_i8', 'a', '#b'), ('extract_i8', 'c', 'b')) => ('extract_i8', ('ior', 'a', 'c'), 'b')
 *    ('ior', ('extract_u8', 'a', '#b'), ('extract_u8', 'c', 'b')) => ('extract_u8', ('ior', 'a', 'c'), 'b')
 *    ('ior', ('extract_i16', 'a', '#b'), ('extract_i16', 'c', 'b')) => ('extract_i16', ('ior', 'a', 'c'), 'b')
 *    ('ior', ('extract_u16', 'a', '#b'), ('extract_u16', 'c', 'b')) => ('extract_u16', ('ior', 'a', 'c'), 'b')
 *    ('ior', ('ushr(is_used_once)', 'a', '#b'), ('ushr', 'c', 'b')) => ('ushr', ('ior', 'a', 'c'), 'b')
 *    ('ior', ('ishr(is_used_once)', 'a', '#b'), ('ishr', 'c', 'b')) => ('ishr', ('ior', 'a', 'c'), 'b')
 *    ('ior', ('ishl(is_used_once)', 'a', '#b'), ('ishl', 'c', 'b')) => ('ishl', ('ior', 'a', 'c'), 'b')
 *    ('u2u8', ('ixor', ('u2u16', ('u2u8', 'a@16')), ('u2u16', ('u2u8', 'b@16')))) => ('u2u8', ('ixor', 'a', 'b'))
 *    ('u2u8', ('ixor', ('u2u16', ('u2u8', 'a@32')), ('u2u16', ('u2u8', 'b@32')))) => ('u2u8', ('ixor', 'a', 'b'))
 *    ('ixor', ('extract_i8', 'a', '#b'), ('extract_i8', 'c', 'b')) => ('extract_i8', ('ixor', 'a', 'c'), 'b')
 *    ('ixor', ('extract_u8', 'a', '#b'), ('extract_u8', 'c', 'b')) => ('extract_u8', ('ixor', 'a', 'c'), 'b')
 *    ('ixor', ('extract_i16', 'a', '#b'), ('extract_i16', 'c', 'b')) => ('extract_i16', ('ixor', 'a', 'c'), 'b')
 *    ('ixor', ('extract_u16', 'a', '#b'), ('extract_u16', 'c', 'b')) => ('extract_u16', ('ixor', 'a', 'c'), 'b')
 *    ('ixor', ('ushr(is_used_once)', 'a', '#b'), ('ushr', 'c', 'b')) => ('ushr', ('ixor', 'a', 'c'), 'b')
 *    ('ixor', ('ishr(is_used_once)', 'a', '#b'), ('ishr', 'c', 'b')) => ('ishr', ('ixor', 'a', 'c'), 'b')
 *    ('ixor', ('ishl(is_used_once)', 'a', '#b'), ('ishl', 'c', 'b')) => ('ishl', ('ixor', 'a', 'c'), 'b')
 *    ('iand', ('ieq', 'a@8', 0), ('ieq', 'b@8', 0)) => ('ieq', ('ior', 'a', 'b'), 0)
 *    ('ior', ('ine', 'a@8', 0), ('ine', 'b@8', 0)) => ('ine', ('ior', 'a', 'b'), 0)
 *    ('iand', ('ieq', 'a@8', 0), ('ieq', 'b@8', 0)) => ('ieq', ('umax', 'a', 'b'), 0)
 *    ('ior', ('ieq', 'a@8', 0), ('ieq', 'b@8', 0)) => ('ieq', ('umin', 'a', 'b'), 0)
 *    ('iand', ('ine', 'a@8', 0), ('ine', 'b@8', 0)) => ('ine', ('umin', 'a', 'b'), 0)
 *    ('ior', ('ine', 'a@8', 0), ('ine', 'b@8', 0)) => ('ine', ('umax', 'a', 'b'), 0)
 *    ('bcsel', ('ult', 'b@8', 'a'), 'b', 'a') => ('umin', 'a', 'b')
 *    ('bcsel', ('ult', 'a@8', 'b'), 'b', 'a') => ('umax', 'a', 'b')
 *    ('bcsel', ('uge', 'a@8', 'b'), 'b', 'a') => ('umin', 'a', 'b')
 *    ('bcsel', ('uge', 'b@8', 'a'), 'b', 'a') => ('umax', 'a', 'b')
 *    ('bcsel', ('ilt', 'b@8', 'a'), 'b', 'a') => ('imin', 'a', 'b')
 *    ('bcsel', ('ilt', 'a@8', 'b'), 'b', 'a') => ('imax', 'a', 'b')
 *    ('bcsel', ('ige', 'a@8', 'b'), 'b', 'a') => ('imin', 'a', 'b')
 *    ('bcsel', ('ige', 'b@8', 'a'), 'b', 'a') => ('imax', 'a', 'b')
 *    ('ineg', ('b2i8', 'a@8')) => a
 *    ('ishl', 'a@8', ('iand', 7, 'b')) => ('ishl', 'a', 'b')
 *    ('ishr', 'a@8', ('iand', 7, 'b')) => ('ishr', 'a', 'b')
 *    ('ushr', 'a@8', ('iand', 7, 'b')) => ('ushr', 'a', 'b')
 *    ('ushr', 'a@8', ('ishl(is_used_once)', ('iand', 'b', 1), 2)) => ('ushr', 'a', ('ishl', 'b', 2))
 *    ('iand', ('ieq', 'a@16', 0), ('ieq', 'b@16', 0)) => ('ieq', ('ior', 'a', 'b'), 0)
 *    ('ior', ('ine', 'a@16', 0), ('ine', 'b@16', 0)) => ('ine', ('ior', 'a', 'b'), 0)
 *    ('iand', ('ieq', 'a@16', 0), ('ieq', 'b@16', 0)) => ('ieq', ('umax', 'a', 'b'), 0)
 *    ('ior', ('ieq', 'a@16', 0), ('ieq', 'b@16', 0)) => ('ieq', ('umin', 'a', 'b'), 0)
 *    ('iand', ('ine', 'a@16', 0), ('ine', 'b@16', 0)) => ('ine', ('umin', 'a', 'b'), 0)
 *    ('ior', ('ine', 'a@16', 0), ('ine', 'b@16', 0)) => ('ine', ('umax', 'a', 'b'), 0)
 *    ('bcsel', ('ult', 'b@16', 'a'), 'b', 'a') => ('umin', 'a', 'b')
 *    ('bcsel', ('ult', 'a@16', 'b'), 'b', 'a') => ('umax', 'a', 'b')
 *    ('bcsel', ('uge', 'a@16', 'b'), 'b', 'a') => ('umin', 'a', 'b')
 *    ('bcsel', ('uge', 'b@16', 'a'), 'b', 'a') => ('umax', 'a', 'b')
 *    ('bcsel', ('ilt', 'b@16', 'a'), 'b', 'a') => ('imin', 'a', 'b')
 *    ('bcsel', ('ilt', 'a@16', 'b'), 'b', 'a') => ('imax', 'a', 'b')
 *    ('bcsel', ('ige', 'a@16', 'b'), 'b', 'a') => ('imin', 'a', 'b')
 *    ('bcsel', ('ige', 'b@16', 'a'), 'b', 'a') => ('imax', 'a', 'b')
 *    ('ineg', ('b2i16', 'a@16')) => a
 *    ('ishl', 'a@16', ('iand', 15, 'b')) => ('ishl', 'a', 'b')
 *    ('ishr', 'a@16', ('iand', 15, 'b')) => ('ishr', 'a', 'b')
 *    ('ushr', 'a@16', ('iand', 15, 'b')) => ('ushr', 'a', 'b')
 *    ('ushr', 'a@16', ('ishl(is_used_once)', ('iand', 'b', 1), 3)) => ('ushr', 'a', ('ishl', 'b', 3))
 *    ('iand', ('ieq', 'a@32', 0), ('ieq', 'b@32', 0)) => ('ieq', ('ior', 'a', 'b'), 0)
 *    ('ior', ('ine', 'a@32', 0), ('ine', 'b@32', 0)) => ('ine', ('ior', 'a', 'b'), 0)
 *    ('iand', ('ieq', 'a@32', 0), ('ieq', 'b@32', 0)) => ('ieq', ('umax', 'a', 'b'), 0)
 *    ('ior', ('ieq', 'a@32', 0), ('ieq', 'b@32', 0)) => ('ieq', ('umin', 'a', 'b'), 0)
 *    ('iand', ('ine', 'a@32', 0), ('ine', 'b@32', 0)) => ('ine', ('umin', 'a', 'b'), 0)
 *    ('ior', ('ine', 'a@32', 0), ('ine', 'b@32', 0)) => ('ine', ('umax', 'a', 'b'), 0)
 *    ('bcsel', ('ult', 'b@32', 'a'), 'b', 'a') => ('umin', 'a', 'b')
 *    ('bcsel', ('ult', 'a@32', 'b'), 'b', 'a') => ('umax', 'a', 'b')
 *    ('bcsel', ('uge', 'a@32', 'b'), 'b', 'a') => ('umin', 'a', 'b')
 *    ('bcsel', ('uge', 'b@32', 'a'), 'b', 'a') => ('umax', 'a', 'b')
 *    ('bcsel', ('ilt', 'b@32', 'a'), 'b', 'a') => ('imin', 'a', 'b')
 *    ('bcsel', ('ilt', 'a@32', 'b'), 'b', 'a') => ('imax', 'a', 'b')
 *    ('bcsel', ('ige', 'a@32', 'b'), 'b', 'a') => ('imin', 'a', 'b')
 *    ('bcsel', ('ige', 'b@32', 'a'), 'b', 'a') => ('imax', 'a', 'b')
 *    ('ineg', ('b2i32', 'a@32')) => a
 *    ('ishl', 'a@32', ('iand', 31, 'b')) => ('ishl', 'a', 'b')
 *    ('ishr', 'a@32', ('iand', 31, 'b')) => ('ishr', 'a', 'b')
 *    ('ushr', 'a@32', ('iand', 31, 'b')) => ('ushr', 'a', 'b')
 *    ('ushr', 'a@32', ('ishl(is_used_once)', ('iand', 'b', 1), 4)) => ('ushr', 'a', ('ishl', 'b', 4))
 *    ('iand', ('ieq', 'a@64', 0), ('ieq', 'b@64', 0)) => ('ieq', ('ior', 'a', 'b'), 0)
 *    ('ior', ('ine', 'a@64', 0), ('ine', 'b@64', 0)) => ('ine', ('ior', 'a', 'b'), 0)
 *    ('iand', ('ieq', 'a@64', 0), ('ieq', 'b@64', 0)) => ('ieq', ('umax', 'a', 'b'), 0)
 *    ('ior', ('ieq', 'a@64', 0), ('ieq', 'b@64', 0)) => ('ieq', ('umin', 'a', 'b'), 0)
 *    ('iand', ('ine', 'a@64', 0), ('ine', 'b@64', 0)) => ('ine', ('umin', 'a', 'b'), 0)
 *    ('ior', ('ine', 'a@64', 0), ('ine', 'b@64', 0)) => ('ine', ('umax', 'a', 'b'), 0)
 *    ('bcsel', ('ult', 'b@64', 'a'), 'b', 'a') => ('umin', 'a', 'b')
 *    ('bcsel', ('ult', 'a@64', 'b'), 'b', 'a') => ('umax', 'a', 'b')
 *    ('bcsel', ('uge', 'a@64', 'b'), 'b', 'a') => ('umin', 'a', 'b')
 *    ('bcsel', ('uge', 'b@64', 'a'), 'b', 'a') => ('umax', 'a', 'b')
 *    ('bcsel', ('ilt', 'b@64', 'a'), 'b', 'a') => ('imin', 'a', 'b')
 *    ('bcsel', ('ilt', 'a@64', 'b'), 'b', 'a') => ('imax', 'a', 'b')
 *    ('bcsel', ('ige', 'a@64', 'b'), 'b', 'a') => ('imin', 'a', 'b')
 *    ('bcsel', ('ige', 'b@64', 'a'), 'b', 'a') => ('imax', 'a', 'b')
 *    ('ineg', ('b2i64', 'a@64')) => a
 *    ('ishl', 'a@64', ('iand', 63, 'b')) => ('ishl', 'a', 'b')
 *    ('ishr', 'a@64', ('iand', 63, 'b')) => ('ishr', 'a', 'b')
 *    ('ushr', 'a@64', ('iand', 63, 'b')) => ('ushr', 'a', 'b')
 *    ('ushr', 'a@64', ('ishl(is_used_once)', ('iand', 'b', 1), 5)) => ('ushr', 'a', ('ishl', 'b', 5))
 *    ('ior', ('ieq', 'a', 0), ('ieq', 'a', 1)) => ('uge', 1, 'a')
 *    ('ior', ('uge', 1, 'a'), ('ieq', 'a', 2)) => ('uge', 2, 'a')
 *    ('ior', ('uge', 2, 'a'), ('ieq', 'a', 3)) => ('uge', 3, 'a')
 *    ('ior', 'a', ('ieq', 'a', False)) => True
 *    ('ine', ('ineg', ('b2i', 'a@1')), ('ineg', ('b2i', 'b@1'))) => ('ine', 'a', 'b')
 *    ('b2i', ('ine', 'a@1', 'b@1')) => ('b2i', ('ixor', 'a', 'b'))
 *    ('ishl', ('b2i32', ('ine', ('iand', 'a@32', '#b(is_pos_power_of_two)'), 0)), '#c') => ('bcsel', ('ige', ('iand', 'c', 31), ('find_lsb', 'b')), ('ishl', ('iand', 'a', 'b'), ('iadd', ('iand', 'c', 31), ('ineg', ('find_lsb', 'b')))), ('ushr', ('iand', 'a', 'b'), ('iadd', ('ineg', ('iand', 'c', 31)), ('find_lsb', 'b'))))
 *    ('b2i32', ('ine', ('iand', 'a@32', '#b(is_pos_power_of_two)'), 0)) => ('ushr', ('iand', 'a', 'b'), ('find_lsb', 'b'))
 *    ('ior', ('b2i', 'a'), ('iand', 'b', 1)) => ('iand', ('ior', ('b2i', 'a'), 'b'), 1)
 *    ('iand', ('b2i', 'a'), ('iand', 'b', 1)) => ('iand', ('b2i', 'a'), 'b')
 *    ('iand', ('inot', ('iand', ('ior', ('ieq', 'a', 0), 'b'), 'c')), ('ilt', 'a', 0)) => ('iand', ('inot', ('iand', 'b', 'c')), ('ilt', 'a', 0))
 *    ('iand', ('inot', ('iand', ('ieq', ('umin', 'a', 'b'), 0), 'c')), ('ilt', 'a', 0)) => ('iand', ('inot', ('iand', ('ieq', 'b', 0), 'c')), ('ilt', 'a', 0))
 *    ('flt', 'a', ('fmax', 'b', 'a')) => ('flt', 'a', 'b')
 *    ('flt', ('fmin', 'a', 'b'), 'a') => ('flt', 'b', 'a')
 *    ('~fge', 'a', ('fmin', 'b', 'a')) => True
 *    ('~fge', ('fmax', 'a', 'b'), 'a') => True
 *    ('flt', 'a', ('fmin', 'b', 'a')) => False
 *    ('flt', ('fmax', 'a', 'b'), 'a') => False
 *    ('~fge', 'a', ('fmax', 'b', 'a')) => ('fge', 'a', 'b')
 *    ('~fge', ('fmin', 'a', 'b'), 'a') => ('fge', 'b', 'a')
 *    ('ilt', 'a', ('imax', 'b', 'a')) => ('ilt', 'a', 'b')
 *    ('ilt', ('imin', 'a', 'b'), 'a') => ('ilt', 'b', 'a')
 *    ('ige', 'a', ('imin', 'b', 'a')) => True
 *    ('ige', ('imax', 'a', 'b'), 'a') => True
 *    ('ult', 'a', ('umax', 'b', 'a')) => ('ult', 'a', 'b')
 *    ('ult', ('umin', 'a', 'b'), 'a') => ('ult', 'b', 'a')
 *    ('uge', 'a', ('umin', 'b', 'a')) => True
 *    ('uge', ('umax', 'a', 'b'), 'a') => True
 *    ('ilt', 'a', ('imin', 'b', 'a')) => False
 *    ('ilt', ('imax', 'a', 'b'), 'a') => False
 *    ('ige', 'a', ('imax', 'b', 'a')) => ('ige', 'a', 'b')
 *    ('ige', ('imin', 'a', 'b'), 'a') => ('ige', 'b', 'a')
 *    ('ult', 'a', ('umin', 'b', 'a')) => False
 *    ('ult', ('umax', 'a', 'b'), 'a') => False
 *    ('uge', 'a', ('umax', 'b', 'a')) => ('uge', 'a', 'b')
 *    ('uge', ('umin', 'a', 'b'), 'a') => ('uge', 'b', 'a')
 *    ('ult', 'a', ('iand', 'b', 'a')) => False
 *    ('ult', ('ior', 'a', 'b'), 'a') => False
 *    ('uge', 'a', ('iand', 'b', 'a')) => True
 *    ('uge', ('ior', 'a', 'b'), 'a') => True
 *    ('ilt', '#a', ('imax', '#b', 'c')) => ('ior', ('ilt', 'a', 'b'), ('ilt', 'a', 'c'))
 *    ('ilt', ('imin', '#a', 'b'), '#c') => ('ior', ('ilt', 'a', 'c'), ('ilt', 'b', 'c'))
 *    ('ige', '#a', ('imin', '#b', 'c')) => ('ior', ('ige', 'a', 'b'), ('ige', 'a', 'c'))
 *    ('ige', ('imax', '#a', 'b'), '#c') => ('ior', ('ige', 'a', 'c'), ('ige', 'b', 'c'))
 *    ('ult', '#a', ('umax', '#b', 'c')) => ('ior', ('ult', 'a', 'b'), ('ult', 'a', 'c'))
 *    ('ult', ('umin', '#a', 'b'), '#c') => ('ior', ('ult', 'a', 'c'), ('ult', 'b', 'c'))
 *    ('uge', '#a', ('umin', '#b', 'c')) => ('ior', ('uge', 'a', 'b'), ('uge', 'a', 'c'))
 *    ('uge', ('umax', '#a', 'b'), '#c') => ('ior', ('uge', 'a', 'c'), ('uge', 'b', 'c'))
 *    ('ilt', '#a', ('imin', '#b', 'c')) => ('iand', ('ilt', 'a', 'b'), ('ilt', 'a', 'c'))
 *    ('ilt', ('imax', '#a', 'b'), '#c') => ('iand', ('ilt', 'a', 'c'), ('ilt', 'b', 'c'))
 *    ('ige', '#a', ('imax', '#b', 'c')) => ('iand', ('ige', 'a', 'b'), ('ige', 'a', 'c'))
 *    ('ige', ('imin', '#a', 'b'), '#c') => ('iand', ('ige', 'a', 'c'), ('ige', 'b', 'c'))
 *    ('ult', '#a', ('umin', '#b', 'c')) => ('iand', ('ult', 'a', 'b'), ('ult', 'a', 'c'))
 *    ('ult', ('umax', '#a', 'b'), '#c') => ('iand', ('ult', 'a', 'c'), ('ult', 'b', 'c'))
 *    ('uge', '#a', ('umax', '#b', 'c')) => ('iand', ('uge', 'a', 'b'), ('uge', 'a', 'c'))
 *    ('uge', ('umin', '#a', 'b'), '#c') => ('iand', ('uge', 'a', 'c'), ('uge', 'b', 'c'))
 *    ('bcsel', ('ilt', 'a', 0), ('ineg', ('ishr', 'a', 'b')), ('ishr', 'a', 'b')) => ('iabs', ('ishr', 'a', 'b'))
 *    ('iabs', ('ishr', ('iabs', 'a'), 'b')) => ('ishr', ('iabs', 'a'), 'b')
 *    ('fabs', ('slt', 'a', 'b')) => ('slt', 'a', 'b')
 *    ('fabs', ('sge', 'a', 'b')) => ('sge', 'a', 'b')
 *    ('fabs', ('seq', 'a', 'b')) => ('seq', 'a', 'b')
 *    ('fabs', ('sne', 'a', 'b')) => ('sne', 'a', 'b')
 *    ('slt', 'a', 'b') => ('b2f', ('flt', 'a', 'b'))
 *    ('sge', 'a', 'b') => ('b2f', ('fge', 'a', 'b'))
 *    ('seq', 'a', 'b') => ('b2f', ('feq', 'a', 'b'))
 *    ('sne', 'a', 'b') => ('b2f', ('fneu', 'a', 'b'))
 *    ('seq', ('seq', 'a', 'b'), 1.0) => ('seq', 'a', 'b')
 *    ('seq', ('sne', 'a', 'b'), 1.0) => ('sne', 'a', 'b')
 *    ('seq', ('slt', 'a', 'b'), 1.0) => ('slt', 'a', 'b')
 *    ('seq', ('sge', 'a', 'b'), 1.0) => ('sge', 'a', 'b')
 *    ('sne', ('seq', 'a', 'b'), 0.0) => ('seq', 'a', 'b')
 *    ('sne', ('sne', 'a', 'b'), 0.0) => ('sne', 'a', 'b')
 *    ('sne', ('slt', 'a', 'b'), 0.0) => ('slt', 'a', 'b')
 *    ('sne', ('sge', 'a', 'b'), 0.0) => ('sge', 'a', 'b')
 *    ('seq', ('seq', 'a', 'b'), 0.0) => ('sne', 'a', 'b')
 *    ('seq', ('sne', 'a', 'b'), 0.0) => ('seq', 'a', 'b')
 *    ('seq', ('slt', 'a', 'b'), 0.0) => ('sge', 'a', 'b')
 *    ('seq', ('sge', 'a', 'b'), 0.0) => ('slt', 'a', 'b')
 *    ('sne', ('seq', 'a', 'b'), 1.0) => ('sne', 'a', 'b')
 *    ('sne', ('sne', 'a', 'b'), 1.0) => ('seq', 'a', 'b')
 *    ('sne', ('slt', 'a', 'b'), 1.0) => ('sge', 'a', 'b')
 *    ('sne', ('sge', 'a', 'b'), 1.0) => ('slt', 'a', 'b')
 *    ('fall_equal2', 'a', 'b') => ('fmin', ('seq', 'a.x', 'b.x'), ('seq', 'a.y', 'b.y'))
 *    ('fall_equal3', 'a', 'b') => ('seq', ('fany_nequal3', 'a', 'b'), 0.0)
 *    ('fall_equal4', 'a', 'b') => ('seq', ('fany_nequal4', 'a', 'b'), 0.0)
 *    ('fall_equal8', 'a', 'b') => ('seq', ('fany_nequal8', 'a', 'b'), 0.0)
 *    ('fall_equal16', 'a', 'b') => ('seq', ('fany_nequal16', 'a', 'b'), 0.0)
 *    ('fany_nequal2', 'a', 'b') => ('fmax', ('sne', 'a.x', 'b.x'), ('sne', 'a.y', 'b.y'))
 *    ('fany_nequal3', 'a', 'b') => ('fsat', ('fdot3', ('sne', 'a', 'b'), ('sne', 'a', 'b')))
 *    ('fany_nequal4', 'a', 'b') => ('fsat', ('fdot4', ('sne', 'a', 'b'), ('sne', 'a', 'b')))
 *    ('fany_nequal8', 'a', 'b') => ('fsat', ('fdot8', ('sne', 'a', 'b'), ('sne', 'a', 'b')))
 *    ('fany_nequal16', 'a', 'b') => ('fsat', ('fdot16', ('sne', 'a', 'b'), ('sne', 'a', 'b')))
 *    ('ball_iequal2', 'a', 'b') => ('iand', ('ieq', 'a.x', 'b.x'), ('ieq', 'a.y', 'b.y'))
 *    ('ball_iequal3', 'a', 'b') => ('iand', ('ieq', 'a.x', 'b.x'), ('iand', ('ieq', 'a.y', 'b.y'), ('ieq', 'a.z', 'b.z')))
 *    ('ball_iequal4', 'a', 'b') => ('iand', ('iand', ('ieq', 'a.x', 'b.x'), ('ieq', 'a.y', 'b.y')), ('iand', ('ieq', 'a.z', 'b.z'), ('ieq', 'a.w', 'b.w')))
 *    ('ball_iequal8', 'a', 'b') => ('iand', ('iand', ('iand', ('ieq', 'a.a', 'b.a'), ('ieq', 'a.b', 'b.b')), ('iand', ('ieq', 'a.c', 'b.c'), ('ieq', 'a.d', 'b.d'))), ('iand', ('iand', ('ieq', 'a.e', 'b.e'), ('ieq', 'a.f', 'b.f')), ('iand', ('ieq', 'a.g', 'b.g'), ('ieq', 'a.h', 'b.h'))))
 *    ('ball_iequal16', 'a', 'b') => ('iand', ('iand', ('iand', ('iand', ('ieq', 'a.a', 'b.a'), ('ieq', 'a.b', 'b.b')), ('iand', ('ieq', 'a.c', 'b.c'), ('ieq', 'a.d', 'b.d'))), ('iand', ('iand', ('ieq', 'a.e', 'b.e'), ('ieq', 'a.f', 'b.f')), ('iand', ('ieq', 'a.g', 'b.g'), ('ieq', 'a.h', 'b.h')))), ('iand', ('iand', ('iand', ('ieq', 'a.i', 'b.i'), ('ieq', 'a.j', 'b.j')), ('iand', ('ieq', 'a.k', 'b.k'), ('ieq', 'a.l', 'b.l'))), ('iand', ('iand', ('ieq', 'a.m', 'b.m'), ('ieq', 'a.n', 'b.n')), ('iand', ('ieq', 'a.o', 'b.o'), ('ieq', 'a.p', 'b.p')))))
 *    ('ball_fequal2', 'a', 'b') => ('iand', ('feq', 'a.x', 'b.x'), ('feq', 'a.y', 'b.y'))
 *    ('ball_fequal3', 'a', 'b') => ('iand', ('feq', 'a.x', 'b.x'), ('iand', ('feq', 'a.y', 'b.y'), ('feq', 'a.z', 'b.z')))
 *    ('ball_fequal4', 'a', 'b') => ('iand', ('iand', ('feq', 'a.x', 'b.x'), ('feq', 'a.y', 'b.y')), ('iand', ('feq', 'a.z', 'b.z'), ('feq', 'a.w', 'b.w')))
 *    ('ball_fequal8', 'a', 'b') => ('iand', ('iand', ('iand', ('feq', 'a.a', 'b.a'), ('feq', 'a.b', 'b.b')), ('iand', ('feq', 'a.c', 'b.c'), ('feq', 'a.d', 'b.d'))), ('iand', ('iand', ('feq', 'a.e', 'b.e'), ('feq', 'a.f', 'b.f')), ('iand', ('feq', 'a.g', 'b.g'), ('feq', 'a.h', 'b.h'))))
 *    ('ball_fequal16', 'a', 'b') => ('iand', ('iand', ('iand', ('iand', ('feq', 'a.a', 'b.a'), ('feq', 'a.b', 'b.b')), ('iand', ('feq', 'a.c', 'b.c'), ('feq', 'a.d', 'b.d'))), ('iand', ('iand', ('feq', 'a.e', 'b.e'), ('feq', 'a.f', 'b.f')), ('iand', ('feq', 'a.g', 'b.g'), ('feq', 'a.h', 'b.h')))), ('iand', ('iand', ('iand', ('feq', 'a.i', 'b.i'), ('feq', 'a.j', 'b.j')), ('iand', ('feq', 'a.k', 'b.k'), ('feq', 'a.l', 'b.l'))), ('iand', ('iand', ('feq', 'a.m', 'b.m'), ('feq', 'a.n', 'b.n')), ('iand', ('feq', 'a.o', 'b.o'), ('feq', 'a.p', 'b.p')))))
 *    ('bany_inequal2', 'a', 'b') => ('ior', ('ine', 'a.x', 'b.x'), ('ine', 'a.y', 'b.y'))
 *    ('bany_inequal3', 'a', 'b') => ('ior', ('ine', 'a.x', 'b.x'), ('ior', ('ine', 'a.y', 'b.y'), ('ine', 'a.z', 'b.z')))
 *    ('bany_inequal4', 'a', 'b') => ('ior', ('ior', ('ine', 'a.x', 'b.x'), ('ine', 'a.y', 'b.y')), ('ior', ('ine', 'a.z', 'b.z'), ('ine', 'a.w', 'b.w')))
 *    ('bany_inequal8', 'a', 'b') => ('ior', ('ior', ('ior', ('ine', 'a.a', 'b.a'), ('ine', 'a.b', 'b.b')), ('ior', ('ine', 'a.c', 'b.c'), ('ine', 'a.d', 'b.d'))), ('ior', ('ior', ('ine', 'a.e', 'b.e'), ('ine', 'a.f', 'b.f')), ('ior', ('ine', 'a.g', 'b.g'), ('ine', 'a.h', 'b.h'))))
 *    ('bany_inequal16', 'a', 'b') => ('ior', ('ior', ('ior', ('ior', ('ine', 'a.a', 'b.a'), ('ine', 'a.b', 'b.b')), ('ior', ('ine', 'a.c', 'b.c'), ('ine', 'a.d', 'b.d'))), ('ior', ('ior', ('ine', 'a.e', 'b.e'), ('ine', 'a.f', 'b.f')), ('ior', ('ine', 'a.g', 'b.g'), ('ine', 'a.h', 'b.h')))), ('ior', ('ior', ('ior', ('ine', 'a.i', 'b.i'), ('ine', 'a.j', 'b.j')), ('ior', ('ine', 'a.k', 'b.k'), ('ine', 'a.l', 'b.l'))), ('ior', ('ior', ('ine', 'a.m', 'b.m'), ('ine', 'a.n', 'b.n')), ('ior', ('ine', 'a.o', 'b.o'), ('ine', 'a.p', 'b.p')))))
 *    ('bany_fnequal2', 'a', 'b') => ('ior', ('fneu', 'a.x', 'b.x'), ('fneu', 'a.y', 'b.y'))
 *    ('bany_fnequal3', 'a', 'b') => ('ior', ('fneu', 'a.x', 'b.x'), ('ior', ('fneu', 'a.y', 'b.y'), ('fneu', 'a.z', 'b.z')))
 *    ('bany_fnequal4', 'a', 'b') => ('ior', ('ior', ('fneu', 'a.x', 'b.x'), ('fneu', 'a.y', 'b.y')), ('ior', ('fneu', 'a.z', 'b.z'), ('fneu', 'a.w', 'b.w')))
 *    ('bany_fnequal8', 'a', 'b') => ('ior', ('ior', ('ior', ('fneu', 'a.a', 'b.a'), ('fneu', 'a.b', 'b.b')), ('ior', ('fneu', 'a.c', 'b.c'), ('fneu', 'a.d', 'b.d'))), ('ior', ('ior', ('fneu', 'a.e', 'b.e'), ('fneu', 'a.f', 'b.f')), ('ior', ('fneu', 'a.g', 'b.g'), ('fneu', 'a.h', 'b.h'))))
 *    ('bany_fnequal16', 'a', 'b') => ('ior', ('ior', ('ior', ('ior', ('fneu', 'a.a', 'b.a'), ('fneu', 'a.b', 'b.b')), ('ior', ('fneu', 'a.c', 'b.c'), ('fneu', 'a.d', 'b.d'))), ('ior', ('ior', ('fneu', 'a.e', 'b.e'), ('fneu', 'a.f', 'b.f')), ('ior', ('fneu', 'a.g', 'b.g'), ('fneu', 'a.h', 'b.h')))), ('ior', ('ior', ('ior', ('fneu', 'a.i', 'b.i'), ('fneu', 'a.j', 'b.j')), ('ior', ('fneu', 'a.k', 'b.k'), ('fneu', 'a.l', 'b.l'))), ('ior', ('ior', ('fneu', 'a.m', 'b.m'), ('fneu', 'a.n', 'b.n')), ('ior', ('fneu', 'a.o', 'b.o'), ('fneu', 'a.p', 'b.p')))))
 *    ('feq', ('seq', 'a', 'b'), 1.0) => ('feq', 'a', 'b')
 *    ('feq', ('sne', 'a', 'b'), 1.0) => ('fneu', 'a', 'b')
 *    ('feq', ('slt', 'a', 'b'), 1.0) => ('flt', 'a', 'b')
 *    ('feq', ('sge', 'a', 'b'), 1.0) => ('fge', 'a', 'b')
 *    ('fneu', ('seq', 'a', 'b'), 0.0) => ('feq', 'a', 'b')
 *    ('fneu', ('sne', 'a', 'b'), 0.0) => ('fneu', 'a', 'b')
 *    ('fneu', ('slt', 'a', 'b'), 0.0) => ('flt', 'a', 'b')
 *    ('fneu', ('sge', 'a', 'b'), 0.0) => ('fge', 'a', 'b')
 *    ('feq', ('seq', 'a', 'b'), 0.0) => ('fneu', 'a', 'b')
 *    ('feq', ('sne', 'a', 'b'), 0.0) => ('feq', 'a', 'b')
 *    ('feq', ('slt', 'a', 'b'), 0.0) => ('fge', 'a', 'b')
 *    ('feq', ('sge', 'a', 'b'), 0.0) => ('flt', 'a', 'b')
 *    ('fneu', ('seq', 'a', 'b'), 1.0) => ('fneu', 'a', 'b')
 *    ('fneu', ('sne', 'a', 'b'), 1.0) => ('feq', 'a', 'b')
 *    ('fneu', ('slt', 'a', 'b'), 1.0) => ('fge', 'a', 'b')
 *    ('fneu', ('sge', 'a', 'b'), 1.0) => ('flt', 'a', 'b')
 *    ('fneu', ('fneg', 'a'), 'a') => ('fneu', 'a', 0.0)
 *    ('feq', ('fneg', 'a'), 'a') => ('feq', 'a', 0.0)
 *    ('imul', ('b2i', 'a@1'), ('b2i', 'b@1')) => ('b2i', ('iand', 'a', 'b'))
 *    ('iand', ('b2i', 'a@1'), ('b2i', 'b@1')) => ('b2i', ('iand', 'a', 'b'))
 *    ('ior', ('b2i', 'a@1'), ('b2i', 'b@1')) => ('b2i', ('ior', 'a', 'b'))
 *    ('fmul', ('b2f', 'a@1'), ('b2f', 'b@1')) => ('b2f', ('iand', 'a', 'b'))
 *    ('fsat', ('fadd', ('b2f', 'a@1'), ('b2f', 'b@1'))) => ('b2f', ('ior', 'a', 'b'))
 *    ('iand', 'a@bool16', 1.0) => ('b2f', 'a')
 *    ('iand', 'a@bool32', 1.0) => ('b2f', 'a')
 *    ('flt', ('fneg', ('b2f', 'a@1')), 0) => a
 *    ('ilt', 'a', 'a') => False
 *    ('ige', 'a', 'a') => True
 *    ('ieq', 'a', 'a') => True
 *    ('ine', 'a', 'a') => False
 *    ('ult', 'a', 'a') => False
 *    ('uge', 'a', 'a') => True
 *    ('flt', 'a', 'a') => False
 *    ('fge', 'a(is_a_number)', 'a') => True
 *    ('feq', 'a(is_a_number)', 'a') => True
 *    ('fneu', 'a(is_a_number)', 'a') => False
 *    ('iand', 'a', 'a') => a
 *    ('iand', 'a', 0) => 0
 *    ('iand', 'a', -1) => a
 *    ('iand', 'a', ('inot', 'a')) => 0
 *    ('ior', 'a', 'a') => a
 *    ('ior', 'a', 0) => a
 *    ('ior', 'a', -1) => -1
 *    ('ior', 'a', ('inot', 'a')) => -1
 *    ('ixor', 'a', 'a') => 0
 *    ('ixor', 'a', 0) => a
 *    ('ixor', 'a', ('ixor', 'a', 'b')) => b
 *    ('ixor', 'a', -1) => ('inot', 'a')
 *    ('inot', ('inot', 'a')) => a
 *    ('ior', ('iand', 'a', 'b'), 'b') => b
 *    ('ior', ('ior', 'a', 'b'), 'b') => ('ior', 'a', 'b')
 *    ('iand', ('ior', 'a', 'b'), 'b') => b
 *    ('iand', ('iand', 'a', 'b'), 'b') => ('iand', 'a', 'b')
 *    ('iand', ('iand(is_used_once)', 'a', 'b'), ('iand(is_used_once)', 'a', 'c')) => ('iand', 'a', ('iand', 'b', 'c'))
 *    ('iand@64', 'a', '#b(is_lower_half_zero)') => ('pack_64_2x32_split', 0, ('iand', ('unpack_64_2x32_split_y', 'a'), ('unpack_64_2x32_split_y', 'b')))
 *    ('iand@64', 'a', '#b(is_upper_half_zero)') => ('pack_64_2x32_split', ('iand', ('unpack_64_2x32_split_x', 'a'), ('unpack_64_2x32_split_x', 'b')), 0)
 *    ('iand@64', 'a', '#b(is_lower_half_negative_one)') => ('pack_64_2x32_split', ('unpack_64_2x32_split_x', 'a'), ('iand', ('unpack_64_2x32_split_y', 'a'), ('unpack_64_2x32_split_y', 'b')))
 *    ('iand@64', 'a', '#b(is_upper_half_negative_one)') => ('pack_64_2x32_split', ('iand', ('unpack_64_2x32_split_x', 'a'), ('unpack_64_2x32_split_x', 'b')), ('unpack_64_2x32_split_y', 'a'))
 *    ('ior@64', 'a', '#b(is_lower_half_zero)') => ('pack_64_2x32_split', ('unpack_64_2x32_split_x', 'a'), ('ior', ('unpack_64_2x32_split_y', 'a'), ('unpack_64_2x32_split_y', 'b')))
 *    ('ior@64', 'a', '#b(is_upper_half_zero)') => ('pack_64_2x32_split', ('ior', ('unpack_64_2x32_split_x', 'a'), ('unpack_64_2x32_split_x', 'b')), ('unpack_64_2x32_split_y', 'a'))
 *    ('ior@64', 'a', '#b(is_lower_half_negative_one)') => ('pack_64_2x32_split', -1, ('ior', ('unpack_64_2x32_split_y', 'a'), ('unpack_64_2x32_split_y', 'b')))
 *    ('ior@64', 'a', '#b(is_upper_half_negative_one)') => ('pack_64_2x32_split', ('ior', ('unpack_64_2x32_split_x', 'a'), ('unpack_64_2x32_split_x', 'b')), -1)
 *    ('ixor@64', 'a', '#b(is_lower_half_zero)') => ('pack_64_2x32_split', ('unpack_64_2x32_split_x', 'a'), ('ixor', ('unpack_64_2x32_split_y', 'a'), ('unpack_64_2x32_split_y', 'b')))
 *    ('ixor@64', 'a', '#b(is_upper_half_zero)') => ('pack_64_2x32_split', ('ixor', ('unpack_64_2x32_split_x', 'a'), ('unpack_64_2x32_split_x', 'b')), ('unpack_64_2x32_split_y', 'a'))
 *    ('iand', ('inot', 'a'), ('inot', 'b')) => ('inot', ('ior', 'a', 'b'))
 *    ('ior', ('inot', 'a'), ('inot', 'b')) => ('inot', ('iand', 'a', 'b'))
 *    ('ishl', 0, 'a') => 0
 *    ('ishl', 'a', 0) => a
 *    ('ishr', 0, 'a') => 0
 *    ('ishr', -1, 'a') => -1
 *    ('ishr', 'a', 0) => a
 *    ('ushr', 0, 'a') => 0
 *    ('ushr', 'a', 0) => a
 *    ('ior', ('ishl@16', 'a', 'b'), ('ushr@16', 'a', ('iadd', 16, ('ineg', 'b')))) => ('urol', 'a', 'b')
 *    ('ior', ('ishl@16', 'a', 'b'), ('ushr@16', 'a', ('isub', 16, 'b'))) => ('urol', 'a', 'b')
 *    ('ior', ('ishl@32', 'a', 'b'), ('ushr@32', 'a', ('iadd', 32, ('ineg', 'b')))) => ('urol', 'a', 'b')
 *    ('ior', ('ishl@32', 'a', 'b'), ('ushr@32', 'a', ('isub', 32, 'b'))) => ('urol', 'a', 'b')
 *    ('ior', ('ushr@16', 'a', 'b'), ('ishl@16', 'a', ('iadd', 16, ('ineg', 'b')))) => ('uror', 'a', 'b')
 *    ('ior', ('ushr@16', 'a', 'b'), ('ishl@16', 'a', ('isub', 16, 'b'))) => ('uror', 'a', 'b')
 *    ('ior', ('ushr@32', 'a', 'b'), ('ishl@32', 'a', ('iadd', 32, ('ineg', 'b')))) => ('uror', 'a', 'b')
 *    ('ior', ('ushr@32', 'a', 'b'), ('ishl@32', 'a', ('isub', 32, 'b'))) => ('uror', 'a', 'b')
 *    ('urol@8', 'a', 'b') => ('ior', ('ishl', 'a', 'b'), ('ushr', 'a', ('isub', 8, 'b')))
 *    ('urol@16', 'a', 'b') => ('ior', ('ishl', 'a', 'b'), ('ushr', 'a', ('isub', 16, 'b')))
 *    ('urol@32', 'a', 'b') => ('ior', ('ishl', 'a', 'b'), ('ushr', 'a', ('isub', 32, 'b')))
 *    ('urol@64', 'a', 'b') => ('ior', ('ishl', 'a', 'b'), ('ushr', 'a', ('isub', 64, 'b')))
 *    ('uror@8', 'a', 'b') => ('ior', ('ushr', 'a', 'b'), ('ishl', 'a', ('isub', 8, 'b')))
 *    ('uror@16', 'a', 'b') => ('ior', ('ushr', 'a', 'b'), ('ishl', 'a', ('isub', 16, 'b')))
 *    ('uror@32', 'a', 'b') => ('ior', ('ushr', 'a', 'b'), ('ishl', 'a', ('isub', 32, 'b')))
 *    ('uror@64', 'a', 'b') => ('ior', ('ushr', 'a', 'b'), ('ishl', 'a', ('isub', 64, 'b')))
 *    ('bitfield_select', 4278190080, ('ishl', 'b@32', 24), ('ushr', 'a', 8)) => ('shfr', 'b', 'a', 8)
 *    ('bitfield_select', 4294901760, ('ishl', 'b@32', 16), ('extract_u16', 'a', 1)) => ('shfr', 'b', 'a', 16)
 *    ('bitfield_select', 4294967040, ('ishl', 'b@32', 8), ('extract_u8', 'a', 3)) => ('shfr', 'b', 'a', 24)
 *    ('ior', ('ishl', 'b@32', 24), ('ushr', 'a', 8)) => ('shfr', 'b', 'a', 8)
 *    ('ior', ('ishl', 'b@32', 16), ('extract_u16', 'a', 1)) => ('shfr', 'b', 'a', 16)
 *    ('ior', ('ishl', 'b@32', 8), ('extract_u8', 'a', 3)) => ('shfr', 'b', 'a', 24)
 *    ('ior', ('ishl', 'b@32', ('iadd', 32, ('ineg', 'c'))), ('ushr@32', 'a', 'c')) => ('shfr', 'b', 'a', 'c')
 *    ('bfi', 4294967295, 'a', 'b') => a
 *    ('bfi', 0, 'a', 'b') => b
 *    ('bfi', ('ineg', ('b2i', 'a@1')), 'b', 'c') => ('bcsel', 'a', 'b', 'c')
 *    ('bfi', '#a(is_odd)', 'a', 'b') => ('ior', 'a', 'b')
 *    ('bfi', '#a(is_odd)', 'b', 0) => ('iand', 'a', 'b')
 *    ('u2f32', ('bfi', '#a(is_pos_power_of_two)', 'b', 0)) => ('bcsel', ('ieq', ('iand', 'b', 1), 0), ('iand', 'b', 1), ('u2f', 'a'))
 *    ('u2f', ('bfi', '#a(is_pos_power_of_two)', 'b', 0)) => ('bcsel', ('ieq', ('iand', 'b', 1), 0), 0, ('u2f', 'a'))
 *    ('~fexp2', ('flog2', 'a')) => a
 *    ('~flog2', ('fexp2', 'a')) => a
 *    ('fpow@32', 'a', 'b') => ('fexp2', ('fmulz', ('flog2', 'a'), 'b'))
 *    ('fpow', 'a', 'b') => ('fexp2', ('fmul', ('flog2', 'a'), 'b'))
 *    ('~fexp2', ('fmul', ('flog2', 'a'), 'b')) => ('fpow', 'a', 'b')
 *    ('~fexp2', ('fadd', ('fmul', ('flog2', 'a'), 'b'), ('fmul', ('flog2', 'c'), 'd'))) => ('~fmul', ('fpow', 'a', 'b'), ('fpow', 'c', 'd'))
 *    ('~fexp2', ('fmul', ('flog2', 'a'), 0.5)) => ('fsqrt', 'a')
 *    ('~fexp2', ('fmul', ('flog2', 'a'), 2.0)) => ('fmul', 'a', 'a')
 *    ('~fexp2', ('fmul', ('flog2', 'a'), 3.0)) => ('fmul', ('fmul', 'a', 'a'), 'a')
 *    ('~fexp2', ('fmul', ('flog2', 'a'), 4.0)) => ('fmul', ('fmul', 'a', 'a'), ('fmul', 'a', 'a'))
 *    ('~fexp2', ('fmul', ('flog2', 'a'), 5.0)) => ('fmul', ('fmul', ('fmul', 'a', 'a'), ('fmul', 'a', 'a')), 'a')
 *    ('~fexp2', ('fmul', ('flog2', 'a'), 6.0)) => ('fmul', ('fmul', ('fmul', 'a', 'a'), ('fmul', 'a', 'a')), ('fmul', 'a', 'a'))
 *    ('~fexp2', ('fmul', ('flog2', 'a'), 8.0)) => ('fmul', ('fmul', ('fmul', 'a', 'a'), ('fmul', 'a', 'a')), ('fmul', ('fmul', 'a', 'a'), ('fmul', 'a', 'a')))
 *    ('~fpow', 'a', 1.0) => a
 *    ('~fpow', 'a', 2.0) => ('fmul', 'a', 'a')
 *    ('~fpow', 'a', 3.0) => ('fmul', ('fmul', 'a', 'a'), 'a')
 *    ('~fpow', 'a', 4.0) => ('fmul', ('fmul', 'a', 'a'), ('fmul', 'a', 'a'))
 *    ('~fpow', 2.0, 'a') => ('fexp2', 'a')
 *    ('~fpow', ('fpow', 'a', 2.2), 0.454545) => a
 *    ('~fpow', ('fabs', ('fpow', 'a', 2.2)), 0.454545) => ('fabs', 'a')
 *    ('~fsqrt', ('fexp2', 'a')) => ('fexp2', ('fmul', 0.5, 'a'))
 *    ('~frcp', ('fexp2', 'a')) => ('fexp2', ('fneg', 'a'))
 *    ('~frsq', ('fexp2', 'a')) => ('fexp2', ('fmul', -0.5, 'a'))
 *    ('~flog2', ('fsqrt', 'a')) => ('fmul', 0.5, ('flog2', 'a'))
 *    ('~flog2', ('frcp', 'a')) => ('fneg', ('flog2', 'a'))
 *    ('~flog2', ('frsq', 'a')) => ('fmul', -0.5, ('flog2', 'a'))
 *    ('~flog2', ('fpow', 'a', 'b')) => ('fmul', 'b', ('flog2', 'a'))
 *    ('~fmul', ('fexp2(is_used_once)', 'a'), ('fexp2(is_used_once)', 'b')) => ('fexp2', ('fadd', 'a', 'b'))
 *    ('bcsel', ('flt', 'a', 0.0), 0.0, ('fsqrt', 'a')) => ('fsqrt', ('fmax', 'a', 0.0))
 *    ('~fmul', ('fsqrt', 'a'), ('fsqrt', 'a')) => ('fabs', 'a')
 *    ('~fmulz', ('fsqrt', 'a'), ('fsqrt', 'a')) => ('fabs', 'a')
 *    ('~fdiv', 1.0, 'a') => ('frcp', 'a')
 *    ('fdiv', 'a', 'b') => ('fmul', 'a', ('frcp', 'b'))
 *    ('~frcp', ('frcp', 'a')) => a
 *    ('~frcp', ('fsqrt', 'a')) => ('frsq', 'a')
 *    ('fsqrt', 'a') => ('frcp', ('frsq', 'a'))
 *    ('~frcp', ('frsq', 'a')) => ('fsqrt', 'a')
 *    ('fsin', 'a') => ('ffma', ('ffma', ('fmul', ('fsub', ('fsub', ('fmul', 2.0, ('ffract', ('fadd', ('fmul', 0.15915494309189535, 'a'), 0.5))), 1.0), ('fmul', ('fsub', ('fmul', 2.0, ('ffract', ('fadd', ('fmul', 0.15915494309189535, 'a'), 0.5))), 1.0), ('fabs', ('fsub', ('fmul', 2.0, ('ffract', ('fadd', ('fmul', 0.15915494309189535, 'a'), 0.5))), 1.0)))), 4.0), ('fabs', ('fmul', ('fsub', ('fsub', ('fmul', 2.0, ('ffract', ('fadd', ('fmul', 0.15915494309189535, 'a'), 0.5))), 1.0), ('fmul', ('fsub', ('fmul', 2.0, ('ffract', ('fadd', ('fmul', 0.15915494309189535, 'a'), 0.5))), 1.0), ('fabs', ('fsub', ('fmul', 2.0, ('ffract', ('fadd', ('fmul', 0.15915494309189535, 'a'), 0.5))), 1.0)))), 4.0)), ('fneg', ('fmul', ('fsub', ('fsub', ('fmul', 2.0, ('ffract', ('fadd', ('fmul', 0.15915494309189535, 'a'), 0.5))), 1.0), ('fmul', ('fsub', ('fmul', 2.0, ('ffract', ('fadd', ('fmul', 0.15915494309189535, 'a'), 0.5))), 1.0), ('fabs', ('fsub', ('fmul', 2.0, ('ffract', ('fadd', ('fmul', 0.15915494309189535, 'a'), 0.5))), 1.0)))), 4.0))), 0.225, ('fmul', ('fsub', ('fsub', ('fmul', 2.0, ('ffract', ('fadd', ('fmul', 0.15915494309189535, 'a'), 0.5))), 1.0), ('fmul', ('fsub', ('fmul', 2.0, ('ffract', ('fadd', ('fmul', 0.15915494309189535, 'a'), 0.5))), 1.0), ('fabs', ('fsub', ('fmul', 2.0, ('ffract', ('fadd', ('fmul', 0.15915494309189535, 'a'), 0.5))), 1.0)))), 4.0))
 *    ('fcos', 'a') => ('ffma', ('ffma', ('fmul', ('fsub', ('fsub', ('fmul', 2.0, ('ffract', ('fadd', ('fmul', 0.15915494309189535, 'a'), 0.75))), 1.0), ('fmul', ('fsub', ('fmul', 2.0, ('ffract', ('fadd', ('fmul', 0.15915494309189535, 'a'), 0.75))), 1.0), ('fabs', ('fsub', ('fmul', 2.0, ('ffract', ('fadd', ('fmul', 0.15915494309189535, 'a'), 0.75))), 1.0)))), 4.0), ('fabs', ('fmul', ('fsub', ('fsub', ('fmul', 2.0, ('ffract', ('fadd', ('fmul', 0.15915494309189535, 'a'), 0.75))), 1.0), ('fmul', ('fsub', ('fmul', 2.0, ('ffract', ('fadd', ('fmul', 0.15915494309189535, 'a'), 0.75))), 1.0), ('fabs', ('fsub', ('fmul', 2.0, ('ffract', ('fadd', ('fmul', 0.15915494309189535, 'a'), 0.75))), 1.0)))), 4.0)), ('fneg', ('fmul', ('fsub', ('fsub', ('fmul', 2.0, ('ffract', ('fadd', ('fmul', 0.15915494309189535, 'a'), 0.75))), 1.0), ('fmul', ('fsub', ('fmul', 2.0, ('ffract', ('fadd', ('fmul', 0.15915494309189535, 'a'), 0.75))), 1.0), ('fabs', ('fsub', ('fmul', 2.0, ('ffract', ('fadd', ('fmul', 0.15915494309189535, 'a'), 0.75))), 1.0)))), 4.0))), 0.225, ('fmul', ('fsub', ('fsub', ('fmul', 2.0, ('ffract', ('fadd', ('fmul', 0.15915494309189535, 'a'), 0.75))), 1.0), ('fmul', ('fsub', ('fmul', 2.0, ('ffract', ('fadd', ('fmul', 0.15915494309189535, 'a'), 0.75))), 1.0), ('fabs', ('fsub', ('fmul', 2.0, ('ffract', ('fadd', ('fmul', 0.15915494309189535, 'a'), 0.75))), 1.0)))), 4.0))
 *    ('ieq', 'a', True) => a
 *    ('ine(is_not_used_by_if)', 'a', True) => ('inot', 'a')
 *    ('ine', 'a', False) => a
 *    ('ieq(is_not_used_by_if)', 'a', False) => ('inot', 'a')
 *    ('bcsel', 'a', True, False) => a
 *    ('bcsel', 'a', False, True) => ('inot', 'a')
 *    ('bcsel', True, 'b', 'c') => b
 *    ('bcsel', False, 'b', 'c') => c
 *    ('bcsel@16', 'a', 1.0, 0.0) => ('b2f', 'a')
 *    ('bcsel@16', 'a', 0.0, 1.0) => ('b2f', ('inot', 'a'))
 *    ('bcsel@16', 'a', -1.0, -0.0) => ('fneg', ('b2f', 'a'))
 *    ('bcsel@16', 'a', -0.0, -1.0) => ('fneg', ('b2f', ('inot', 'a')))
 *    ('bcsel@32', 'a', 1.0, 0.0) => ('b2f', 'a')
 *    ('bcsel@32', 'a', 0.0, 1.0) => ('b2f', ('inot', 'a'))
 *    ('bcsel@32', 'a', -1.0, -0.0) => ('fneg', ('b2f', 'a'))
 *    ('bcsel@32', 'a', -0.0, -1.0) => ('fneg', ('b2f', ('inot', 'a')))
 *    ('bcsel@64', 'a', 1.0, 0.0) => ('b2f', 'a')
 *    ('bcsel@64', 'a', 0.0, 1.0) => ('b2f', ('inot', 'a'))
 *    ('bcsel@64', 'a', -1.0, -0.0) => ('fneg', ('b2f', 'a'))
 *    ('bcsel@64', 'a', -0.0, -1.0) => ('fneg', ('b2f', ('inot', 'a')))
 *    ('bcsel', 'a', 'b', 'b') => b
 *    ('~fcsel', 'a', 'b', 'b') => b
 *    ('bcsel', 'a', -1, 0) => ('ineg', ('b2i', 'a@1'))
 *    ('bcsel', 'a', 0, -1) => ('ineg', ('b2i', ('inot', 'a')))
 *    ('bcsel', 'a', 1, 0) => ('b2i', 'a@1')
 *    ('bcsel', 'a', 0, 1) => ('b2i', ('inot', 'a'))
 *    ('iand', ('ineg', ('b2i', 'a@1')), ('ineg', ('b2i', 'b@1'))) => ('ineg', ('b2i', ('iand', 'a', 'b')))
 *    ('ior', ('ineg', ('b2i', 'a@1')), ('ineg', ('b2i', 'b@1'))) => ('ineg', ('b2i', ('ior', 'a', 'b')))
 *    ('ieq', ('ineg', ('b2i', 'a@1')), -1) => a
 *    ('ine', ('ineg', ('b2i', 'a@1')), -1) => ('inot', 'a')
 *    ('ige', ('ineg', ('b2i', 'a@1')), 0) => ('inot', 'a')
 *    ('ilt', ('ineg', ('b2i', 'a@1')), 0) => a
 *    ('ult', 0, ('ineg', ('b2i', 'a@1'))) => a
 *    ('iand', ('ineg', ('b2i', 'a')), 1.0) => ('b2f', 'a')
 *    ('iand', ('ineg', ('b2i', 'a')), 1) => ('b2i', 'a')
 *    ('imax', ('ineg', ('b2i', 'a@1')), ('ineg', ('b2i', 'b@1'))) => ('ineg', ('b2i', ('iand', 'a', 'b')))
 *    ('imin', ('ineg', ('b2i', 'a@1')), ('ineg', ('b2i', 'b@1'))) => ('ineg', ('b2i', ('ior', 'a', 'b')))
 *    ('umax', ('ineg', ('b2i', 'a@1')), ('ineg', ('b2i', 'b@1'))) => ('ineg', ('b2i', ('ior', 'a', 'b')))
 *    ('umin', ('ineg', ('b2i', 'a@1')), ('ineg', ('b2i', 'b@1'))) => ('ineg', ('b2i', ('iand', 'a', 'b')))
 *    ('umax', ('b2i', 'a@1'), ('b2i', 'b@1')) => ('b2i', ('ior', 'a', 'b'))
 *    ('umin', ('b2i', 'a@1'), ('b2i', 'b@1')) => ('b2i', ('iand', 'a', 'b'))
 *    ('iand', ('b2i', 'a'), 1) => ('b2i', 'a')
 *    ('ine', ('umin', ('ineg', ('b2i', 'a@1')), 'b'), 0) => ('iand', 'a', ('ine', 'b', 0))
 *    ('ine', ('umax', ('ineg', ('b2i', 'a@1')), 'b'), 0) => ('ior', 'a', ('ine', 'b', 0))
 *    ('f2i', ('ftrunc', 'a')) => ('f2i', 'a')
 *    ('f2u', ('ftrunc', 'a')) => ('f2u', 'a')
 *    ('f2fmp', ('f2f32', 'a@16')) => a
 *    ('i2imp', ('i2i32', 'a@16')) => a
 *    ('i2imp', ('u2u32', 'a@16')) => a
 *    ('f2imp', ('f2f32', 'a@16')) => ('f2i16', 'a')
 *    ('f2ump', ('f2f32', 'a@16')) => ('f2u16', 'a')
 *    ('i2fmp', ('i2i32', 'a@16')) => ('i2f16', 'a')
 *    ('u2fmp', ('u2u32', 'a@16')) => ('u2f16', 'a')
 *    ('f2fmp', ('b2f32', 'a@1')) => ('b2f16', 'a')
 *    ('i2imp', ('b2i32', 'a@1')) => ('b2i16', 'a')
 *    ('i2imp', ('b2i32', 'a@1')) => ('b2i16', 'a')
 *    ('f2imp', ('b2f32', 'a@1')) => ('b2i16', 'a')
 *    ('f2ump', ('b2f32', 'a@1')) => ('b2i16', 'a')
 *    ('i2fmp', ('b2i32', 'a@1')) => ('b2f16', 'a')
 *    ('u2fmp', ('b2i32', 'a@1')) => ('b2f16', 'a')
 *    ('f2f32', ('f2fmp', 'a@32')) => a
 *    ('i2i32', ('i2imp', 'a@32')) => a
 *    ('u2u32', ('i2imp', 'a@32')) => a
 *    ('i2i32', ('f2imp', 'a@32')) => ('f2i32', 'a')
 *    ('u2u32', ('f2ump', 'a@32')) => ('f2u32', 'a')
 *    ('f2f32', ('i2fmp', 'a@32')) => ('i2f32', 'a')
 *    ('f2f32', ('u2fmp', 'a@32')) => ('u2f32', 'a')
 *    ('f2i32', ('f2fmp', 'a@32')) => ('f2i32', 'a')
 *    ('f2u32', ('f2fmp', 'a@32')) => ('f2u32', 'a')
 *    ('i2f32', ('i2imp', 'a@32')) => ('i2f32', 'a')
 *    ('ffloor', 'a(is_integral)') => a
 *    ('fceil', 'a(is_integral)') => a
 *    ('ftrunc', 'a(is_integral)') => a
 *    ('fround_even', 'a(is_integral)') => a
 *    ('~ffract', 'a(is_integral)') => 0.0
 *    ('fabs', 'a(is_not_negative)') => a
 *    ('iabs', 'a(is_not_negative)') => a
 *    ('fsat', 'a(is_not_positive)') => 0.0
 *    ('~fmin', 'a(is_not_negative)', 1.0) => ('fsat', 'a')
 *    ('flt', ('fadd', ('fmul', ('fsat', 'a'), ('fneg', ('fsat', 'a'))), 1.0), 0.0) => False
 *    ('flt', ('fadd', ('fneg', ('fmul', ('fsat', 'a'), ('fsat', 'a'))), 1.0), 0.0) => False
 *    ('fmax', ('fadd', ('fmul', ('fsat', 'a'), ('fneg', ('fsat', 'a'))), 1.0), 0.0) => ('fadd', ('fmul', ('fsat', 'a'), ('fneg', ('fsat', 'a'))), 1.0)
 *    ('fmax', ('fadd', ('fneg', ('fmul', ('fsat', 'a'), ('fsat', 'a'))), 1.0), 0.0) => ('fadd', ('fneg', ('fmul', ('fsat', 'a'), ('fsat', 'a'))), 1.0)
 *    ('fneu', 'a(is_not_zero)', 0.0) => True
 *    ('feq', 'a(is_not_zero)', 0.0) => False
 *    ('fge', 'a(is_a_number_not_negative)', 'b(is_a_number_not_positive)') => True
 *    ('fge', 'a(is_not_positive)', 'b(is_gt_zero)') => False
 *    ('fge', 'a(is_lt_zero)', 'b(is_not_negative)') => False
 *    ('flt', 'a(is_not_negative)', 'b(is_not_positive)') => False
 *    ('flt', 'a(is_a_number_not_positive)', 'b(is_a_number_gt_zero)') => True
 *    ('flt', 'a(is_a_number_lt_zero)', 'b(is_a_number_not_negative)') => True
 *    ('ine', 'a(is_not_zero)', 0) => True
 *    ('ieq', 'a(is_not_zero)', 0) => False
 *    ('ige', 'a(is_not_negative)', 'b(is_not_positive)') => True
 *    ('ige', 'a(is_not_positive)', 'b(is_gt_zero)') => False
 *    ('ige', 'a(is_lt_zero)', 'b(is_not_negative)') => False
 *    ('ilt', 'a(is_not_negative)', 'b(is_not_positive)') => False
 *    ('ilt', 'a(is_not_positive)', 'b(is_gt_zero)') => True
 *    ('ilt', 'a(is_lt_zero)', 'b(is_not_negative)') => True
 *    ('ult', 0, 'a(is_gt_zero)') => True
 *    ('ult', 'a', 0) => False
 *    ('unpack_64_2x32_split_x', ('pack_64_2x32_split', 'a', 'b')) => a
 *    ('unpack_64_2x32_split_y', ('pack_64_2x32_split', 'a', 'b')) => b
 *    ('unpack_64_2x32_split_x', ('pack_64_2x32', 'a')) => a.x
 *    ('unpack_64_2x32_split_y', ('pack_64_2x32', 'a')) => a.y
 *    ('unpack_64_2x32_split_x', ('u2u64', 'a@32')) => a
 *    ('unpack_64_2x32_split_y', ('u2u64', 'a')) => 0
 *    ('unpack_64_2x32_split_x', ('i2i64', 'a@32')) => a
 *    ('unpack_64_2x32_split_y', ('i2i64(is_used_once)', 'a@32')) => ('ishr', 'a', 31)
 *    ('unpack_64_2x32', ('pack_64_2x32_split', 'a', 'b')) => ('vec2', 'a', 'b')
 *    ('unpack_64_2x32', ('pack_64_2x32', 'a')) => a
 *    ('unpack_double_2x32_dxil', ('pack_double_2x32_dxil', 'a')) => a
 *    ('pack_64_2x32_split', ('unpack_64_2x32_split_x', 'a'), ('unpack_64_2x32_split_y', 'a')) => a
 *    ('pack_64_2x32', ('vec2', ('unpack_64_2x32_split_x', 'a'), ('unpack_64_2x32_split_y', 'a'))) => a
 *    ('pack_64_2x32', ('unpack_64_2x32', 'a')) => a
 *    ('pack_double_2x32_dxil', ('unpack_double_2x32_dxil', 'a')) => a
 *    ('unpack_64_4x16', ('pack_64_4x16', 'a')) => a
 *    ('unpack_64_4x16', ('pack_64_2x32', ('vec2', ('pack_32_2x16_split', 'a', 'b'), ('pack_32_2x16_split', 'c', 'd')))) => ('vec4', 'a', 'b', 'c', 'd')
 *    ('unpack_64_4x16', ('pack_64_2x32_split', ('pack_32_2x16_split', 'a', 'b'), ('pack_32_2x16_split', 'c', 'd'))) => ('vec4', 'a', 'b', 'c', 'd')
 *    ('iand', ('ieq', ('unpack_32_2x16_split_x', 'a'), '#b'), ('ieq', ('unpack_32_2x16_split_y', 'a'), '#c')) => ('ieq', 'a', ('pack_32_2x16_split', 'b', 'c'))
 *    ('ushr', 'a@16', 8) => ('extract_u8', 'a', 1)
 *    ('ushr', 'a@32', 24) => ('extract_u8', 'a', 3)
 *    ('ushr', 'a@64', 56) => ('extract_u8', 'a', 7)
 *    ('ishr', 'a@16', 8) => ('extract_i8', 'a', 1)
 *    ('ishr', 'a@32', 24) => ('extract_i8', 'a', 3)
 *    ('ishr', 'a@64', 56) => ('extract_i8', 'a', 7)
 *    ('iand', 255, 'a') => ('extract_u8', 'a', 0)
 *    ('ishr', ('iand', 'a', 65280), 8) => ('extract_u8', 'a', 1)
 *    ('ishr', ('iand', 'a', 16711680), 16) => ('extract_u8', 'a', 2)
 *    ('u2u8', ('extract_u16', 'a', 1)) => ('u2u8', ('extract_u8', 'a', 2))
 *    ('u2u8', ('ushr', 'a', 8)) => ('u2u8', ('extract_u8', 'a', 1))
 *    ('i2i16', ('u2u8', ('extract_u8', 'a', 'b'))) => ('i2i16', ('extract_i8', 'a', 'b'))
 *    ('u2u16', ('u2u8', ('extract_u8', 'a', 'b'))) => ('u2u16', ('extract_u8', 'a', 'b'))
 *    ('ubfe', 'a', 0, 8) => ('extract_u8', 'a', 0)
 *    ('ubfe', 'a', 8, 8) => ('extract_u8', 'a', 1)
 *    ('ubfe', 'a', 16, 8) => ('extract_u8', 'a', 2)
 *    ('ubfe', 'a', 24, 8) => ('extract_u8', 'a', 3)
 *    ('ibfe', 'a', 0, 8) => ('extract_i8', 'a', 0)
 *    ('ibfe', 'a', 8, 8) => ('extract_i8', 'a', 1)
 *    ('ibfe', 'a', 16, 8) => ('extract_i8', 'a', 2)
 *    ('ibfe', 'a', 24, 8) => ('extract_i8', 'a', 3)
 *    ('extract_u8', ('extract_i8', 'a', 'b'), 0) => ('extract_u8', 'a', 'b')
 *    ('extract_u8', ('extract_u8', 'a', 'b'), 0) => ('extract_u8', 'a', 'b')
 *    ('extract_i8', ('iand', 'a', 65280), 1) => ('extract_i8', 'a', 1)
 *    ('extract_i8', ('iand', 'a', 16711680), 2) => ('extract_i8', 'a', 2)
 *    ('extract_i8', ('iand', 'a', 4278190080), 3) => ('extract_i8', 'a', 3)
 *    ('extract_u8', ('iand', 'a', 65280), 1) => ('extract_u8', 'a', 1)
 *    ('extract_u8', ('iand', 'a', 16711680), 2) => ('extract_u8', 'a', 2)
 *    ('extract_u8', ('iand', 'a', 4278190080), 3) => ('extract_u8', 'a', 3)
 *    ('iand', ('extract_u8', 'a', 0), '#b') => ('iand', 'a', ('iand', 'b', 255))
 *    ('iand', ('extract_u16', 'a', 0), '#b') => ('iand', 'a', ('iand', 'b', 65535))
 *    ('ieq', ('iand', ('extract_u8', 'a', '#b'), '#c'), 0) => ('ieq', ('iand', 'a', ('ishl', ('iand', 'c', 255), ('imul', ('i2i32', 'b'), 8))), 0)
 *    ('ine', ('iand', ('extract_u8', 'a', '#b'), '#c'), 0) => ('ine', ('iand', 'a', ('ishl', ('iand', 'c', 255), ('imul', ('i2i32', 'b'), 8))), 0)
 *    ('ieq', ('iand', ('extract_u16(is_used_once)', 'a', '#b'), '#c'), 0) => ('ieq', ('iand', 'a', ('ishl', ('iand', 'c', 65535), ('imul', ('i2i32', 'b'), 16))), 0)
 *    ('ine', ('iand', ('extract_u16(is_used_once)', 'a', '#b'), '#c'), 0) => ('ine', ('iand', 'a', ('ishl', ('iand', 'c', 65535), ('imul', ('i2i32', 'b'), 16))), 0)
 *    ('ushr', ('ishl', 'a@32', 16), 16) => ('extract_u16', 'a', 0)
 *    ('ushr', 'a@32', 16) => ('extract_u16', 'a', 1)
 *    ('ishr', ('ishl', 'a@32', 16), 16) => ('extract_i16', 'a', 0)
 *    ('ishr', 'a@32', 16) => ('extract_i16', 'a', 1)
 *    ('iand', 65535, 'a') => ('extract_u16', 'a', 0)
 *    ('ubfe', 'a', 0, 16) => ('extract_u16', 'a', 0)
 *    ('ubfe', 'a', 16, 16) => ('extract_u16', 'a', 1)
 *    ('ibfe', 'a', 0, 16) => ('extract_i16', 'a', 0)
 *    ('ibfe', 'a', 16, 16) => ('extract_i16', 'a', 1)
 *    ('unpack_32_4x8', ('pack_32_4x8', 'a')) => a
 *    ('unpack_32_2x16', ('pack_32_2x16', 'a')) => a
 *    ('unpack_64_4x16', ('pack_64_4x16', 'a')) => a
 *    ('unpack_64_2x32', ('pack_64_2x32', 'a')) => a
 *    ('pack_32_4x8', ('unpack_32_4x8', 'a')) => a
 *    ('pack_32_2x16', ('unpack_32_2x16', 'a')) => a
 *    ('pack_64_4x16', ('unpack_64_4x16', 'a')) => a
 *    ('pack_64_2x32', ('unpack_64_2x32', 'a')) => a
 *    ('ior', ('ishl', ('u2u32', 'a@8'), 24), ('ior', ('ishl', ('u2u32', 'b@8'), 16), ('ior', ('ishl', ('u2u32', 'c@8'), 8), ('u2u32', 'd@8')))) => ('pack_32_4x8', ('vec4', 'd', 'c', 'b', 'a'))
 *    ('extract_u16', ('extract_i16', 'a', 'b'), 0) => ('extract_u16', 'a', 'b')
 *    ('extract_u16', ('extract_u16', 'a', 'b'), 0) => ('extract_u16', 'a', 'b')
 *    ('extract_i16', ('iand', 'a', 16711680), 1) => ('extract_u8', 'a', 2)
 *    ('extract_u16', ('iand', 'a', 16711680), 1) => ('extract_u8', 'a', 2)
 *    ('pack_64_2x32_split', 'a', 'b') => ('ior', ('u2u64', 'a'), ('ishl', ('u2u64', 'b'), 32))
 *    ('pack_32_2x16_split', 'a', 'b') => ('ior', ('u2u32', 'a'), ('ishl', ('u2u32', 'b'), 16))
 *    ('pack_half_2x16_split', 'a', 'b') => ('pack_half_2x16_rtz_split', 'a', 'b')
 *    ('unpack_64_2x32_split_x', 'a') => ('u2u32', 'a')
 *    ('unpack_64_2x32_split_y', 'a') => ('u2u32', ('ushr', 'a', 32))
 *    ('unpack_32_2x16_split_x', 'a') => ('u2u16', 'a')
 *    ('unpack_32_2x16_split_y', 'a') => ('u2u16', ('ushr', 'a', 16))
 *    ('unpack_64_2x32_split_x', ('ushr', 'a', 32)) => ('unpack_64_2x32_split_y', 'a')
 *    ('u2u32', ('ushr', 'a@64', 32)) => ('unpack_64_2x32_split_y', 'a')
 *    ('unpack_half_2x16_split_x', ('iand', 'a', 65535)) => ('unpack_half_2x16_split_x', 'a')
 *    ('unpack_32_2x16_split_x', ('iand', 'a', 65535)) => ('unpack_32_2x16_split_x', 'a')
 *    ('unpack_64_2x32_split_x', ('iand', 'a', 4294967295)) => ('unpack_64_2x32_split_x', 'a')
 *    ('unpack_half_2x16_split_y', ('iand', 'a', 4294901760)) => ('unpack_half_2x16_split_y', 'a')
 *    ('unpack_32_2x16_split_y', ('iand', 'a', 4294901760)) => ('unpack_32_2x16_split_y', 'a')
 *    ('unpack_64_2x32_split_y', ('iand', 'a', 18446744069414584320)) => ('unpack_64_2x32_split_y', 'a')
 *    ('unpack_half_2x16_split_x', ('extract_u16', 'a', 0)) => ('unpack_half_2x16_split_x', 'a')
 *    ('unpack_half_2x16_split_x', ('extract_u16', 'a', 1)) => ('unpack_half_2x16_split_y', 'a')
 *    ('unpack_half_2x16_split_x', ('ushr', 'a', 16)) => ('unpack_half_2x16_split_y', 'a')
 *    ('unpack_32_2x16_split_x', ('extract_u16', 'a', 0)) => ('unpack_32_2x16_split_x', 'a')
 *    ('unpack_32_2x16_split_x', ('extract_u16', 'a', 1)) => ('unpack_32_2x16_split_y', 'a')
 *    ('ishl', ('pack_half_2x16', ('vec2', 'a', 0)), 16) => ('pack_half_2x16', ('vec2', 0, 'a'))
 *    ('ushr', ('pack_half_2x16', ('vec2', 0, 'a')), 16) => ('pack_half_2x16', ('vec2', 'a', 0))
 *    ('iadd', ('pack_half_2x16', ('vec2', 'a', 0)), ('pack_half_2x16', ('vec2', 0, 'b'))) => ('pack_half_2x16', ('vec2', 'a', 'b'))
 *    ('ior', ('pack_half_2x16', ('vec2', 'a', 0)), ('pack_half_2x16', ('vec2', 0, 'b'))) => ('pack_half_2x16', ('vec2', 'a', 'b'))
 *    ('ishl', ('pack_half_2x16_split', 'a', 0), 16) => ('pack_half_2x16_split', 0, 'a')
 *    ('ushr', ('pack_half_2x16_split', 0, 'a'), 16) => ('pack_half_2x16_split', 'a', 0)
 *    ('extract_u16', ('pack_half_2x16_split', 0, 'a'), 1) => ('pack_half_2x16_split', 'a', 0)
 *    ('ishl', ('pack_half_2x16_rtz_split', 'a', 0), 16) => ('pack_half_2x16_rtz_split', 0, 'a')
 *    ('ushr', ('pack_half_2x16_rtz_split', 0, 'a'), 16) => ('pack_half_2x16_rtz_split', 'a', 0)
 *    ('extract_u16', ('pack_half_2x16_rtz_split', 0, 'a'), 1) => ('pack_half_2x16_rtz_split', 'a', 0)
 *    ('iadd', ('pack_half_2x16_split', 'a', 0), ('pack_half_2x16_split', 0, 'b')) => ('pack_half_2x16_split', 'a', 'b')
 *    ('ior', ('pack_half_2x16_split', 'a', 0), ('pack_half_2x16_split', 0, 'b')) => ('pack_half_2x16_split', 'a', 'b')
 *    ('iadd', ('pack_half_2x16_rtz_split', 'a', 0), ('pack_half_2x16_rtz_split', 0, 'b')) => ('pack_half_2x16_rtz_split', 'a', 'b')
 *    ('ior', ('pack_half_2x16_rtz_split', 'a', 0), ('pack_half_2x16_rtz_split', 0, 'b')) => ('pack_half_2x16_rtz_split', 'a', 'b')
 *    ('pack_uint_2x16', ('vec2', ('pack_half_2x16_rtz_split', 'a', 0), ('pack_half_2x16_rtz_split', 'b', 0))) => ('pack_half_2x16_rtz_split', 'a', 'b')
 *    ('bfi', 4294901760, ('pack_half_2x16_split', 'a', 'b'), ('pack_half_2x16_split', 'c', 'd')) => ('pack_half_2x16_split', 'c', 'a')
 *    ('iand', ('bfi', 15, '#a', 'b'), 4294967292) => ('bfi', 15, ('iand', 'a', 4294967292), 'b')
 *    ('iand', ('bfi', 7, '#a', 'b'), 4294967292) => ('bfi', 7, ('iand', 'a', 4294967292), 'b')
 *    ('umin', ('ishl', ('iand', 'a', 15), 3), 120) => ('ishl', ('iand', 'a', 15), 3)
 *    ('extract_i8', ('pack_32_4x8_split', 'a', 'b', 'c', 'd'), 0) => ('i2i', 'a')
 *    ('extract_i8', ('pack_32_4x8_split', 'a', 'b', 'c', 'd'), 1) => ('i2i', 'b')
 *    ('extract_i8', ('pack_32_4x8_split', 'a', 'b', 'c', 'd'), 2) => ('i2i', 'c')
 *    ('extract_i8', ('pack_32_4x8_split', 'a', 'b', 'c', 'd'), 3) => ('i2i', 'd')
 *    ('extract_u8', ('pack_32_4x8_split', 'a', 'b', 'c', 'd'), 0) => ('u2u', 'a')
 *    ('extract_u8', ('pack_32_4x8_split', 'a', 'b', 'c', 'd'), 1) => ('u2u', 'b')
 *    ('extract_u8', ('pack_32_4x8_split', 'a', 'b', 'c', 'd'), 2) => ('u2u', 'c')
 *    ('extract_u8', ('pack_32_4x8_split', 'a', 'b', 'c', 'd'), 3) => ('u2u', 'd')
 *    ('u2u32', ('iadd(is_used_once)', 'a@64', 'b')) => ('iadd', ('u2u32', 'a'), ('u2u32', 'b'))
 *    ('u2u32', ('ushr', ('ior', ('ishl', 'a', 32), ('u2u64', 'b')), 32)) => ('u2u32', 'a')
 *    ('u2u16', ('ushr', ('ior', ('ishl', 'a', 16), ('u2u32', 'b')), 16)) => ('u2u16', 'a')
 *    ('extract_u8', ('ushr', 'a@16', 8), 0) => ('extract_u8', 'a', 1)
 *    ('extract_u8', ('ushr', 'a@32', 8), 0) => ('extract_u8', 'a', 1)
 *    ('extract_u8', ('ushr', 'a@32', 16), 0) => ('extract_u8', 'a', 2)
 *    ('extract_u8', ('ushr', 'a@32', 24), 0) => ('extract_u8', 'a', 3)
 *    ('extract_u8', ('ushr', 'a@64', 8), 0) => ('extract_u8', 'a', 1)
 *    ('extract_u8', ('ushr', 'a@64', 16), 0) => ('extract_u8', 'a', 2)
 *    ('extract_u8', ('ushr', 'a@64', 24), 0) => ('extract_u8', 'a', 3)
 *    ('extract_u8', ('ushr', 'a@64', 32), 0) => ('extract_u8', 'a', 4)
 *    ('extract_u8', ('ushr', 'a@64', 40), 0) => ('extract_u8', 'a', 5)
 *    ('extract_u8', ('ushr', 'a@64', 48), 0) => ('extract_u8', 'a', 6)
 *    ('extract_u8', ('ushr', 'a@64', 56), 0) => ('extract_u8', 'a', 7)
 *    ('extract_u8', ('ishr', 'a@16', 8), 0) => ('extract_u8', 'a', 1)
 *    ('extract_u8', ('ishr', 'a@32', 8), 0) => ('extract_u8', 'a', 1)
 *    ('extract_u8', ('ishr', 'a@32', 16), 0) => ('extract_u8', 'a', 2)
 *    ('extract_u8', ('ishr', 'a@32', 24), 0) => ('extract_u8', 'a', 3)
 *    ('extract_u8', ('ishr', 'a@64', 8), 0) => ('extract_u8', 'a', 1)
 *    ('extract_u8', ('ishr', 'a@64', 16), 0) => ('extract_u8', 'a', 2)
 *    ('extract_u8', ('ishr', 'a@64', 24), 0) => ('extract_u8', 'a', 3)
 *    ('extract_u8', ('ishr', 'a@64', 32), 0) => ('extract_u8', 'a', 4)
 *    ('extract_u8', ('ishr', 'a@64', 40), 0) => ('extract_u8', 'a', 5)
 *    ('extract_u8', ('ishr', 'a@64', 48), 0) => ('extract_u8', 'a', 6)
 *    ('extract_u8', ('ishr', 'a@64', 56), 0) => ('extract_u8', 'a', 7)
 *    ('extract_u8', ('extract_u16', 'a', 1), 0) => ('extract_u8', 'a', 2)
 *    ('extract_u8', ('ishl', 'a@16', 8), 1) => ('extract_u8', 'a', 0)
 *    ('extract_u8', ('ishl', 'a@32', 8), 3) => ('extract_u8', 'a', 2)
 *    ('extract_u8', ('ishl', 'a@32', 16), 3) => ('extract_u8', 'a', 1)
 *    ('extract_u8', ('ishl', 'a@32', 24), 3) => ('extract_u8', 'a', 0)
 *    ('extract_u8', ('ishl', 'a@64', 8), 7) => ('extract_u8', 'a', 6)
 *    ('extract_u8', ('ishl', 'a@64', 16), 7) => ('extract_u8', 'a', 5)
 *    ('extract_u8', ('ishl', 'a@64', 24), 7) => ('extract_u8', 'a', 4)
 *    ('extract_u8', ('ishl', 'a@64', 32), 7) => ('extract_u8', 'a', 3)
 *    ('extract_u8', ('ishl', 'a@64', 40), 7) => ('extract_u8', 'a', 2)
 *    ('extract_u8', ('ishl', 'a@64', 48), 7) => ('extract_u8', 'a', 1)
 *    ('extract_u8', ('ishl', 'a@64', 56), 7) => ('extract_u8', 'a', 0)
 *    ('extract_i8', ('ishl', 'a@16', 8), 1) => ('extract_i8', 'a', 0)
 *    ('extract_i8', ('ishl', 'a@32', 8), 3) => ('extract_i8', 'a', 2)
 *    ('extract_i8', ('ishl', 'a@32', 16), 3) => ('extract_i8', 'a', 1)
 *    ('extract_i8', ('ishl', 'a@32', 24), 3) => ('extract_i8', 'a', 0)
 *    ('extract_i8', ('ishl', 'a@64', 8), 7) => ('extract_i8', 'a', 6)
 *    ('extract_i8', ('ishl', 'a@64', 16), 7) => ('extract_i8', 'a', 5)
 *    ('extract_i8', ('ishl', 'a@64', 24), 7) => ('extract_i8', 'a', 4)
 *    ('extract_i8', ('ishl', 'a@64', 32), 7) => ('extract_i8', 'a', 3)
 *    ('extract_i8', ('ishl', 'a@64', 40), 7) => ('extract_i8', 'a', 2)
 *    ('extract_i8', ('ishl', 'a@64', 48), 7) => ('extract_i8', 'a', 1)
 *    ('extract_i8', ('ishl', 'a@64', 56), 7) => ('extract_i8', 'a', 0)
 *    ('ieq', ('pack_64_2x32_split', 'a', 0), ('pack_64_2x32_split', 'b', 0)) => ('ieq', 'a', 'b')
 *    ('ieq', ('pack_64_2x32_split', 'a', 0), '#b(is_upper_half_zero)') => ('ieq', 'a', ('unpack_64_2x32_split_x', 'b'))
 *    ('ieq', '#a(is_upper_half_zero)', ('pack_64_2x32_split', 'b', 0)) => ('ieq', ('unpack_64_2x32_split_x', 'a'), 'b')
 *    ('ieq', ('pack_64_2x32_split', 0, 'a'), ('pack_64_2x32_split', 0, 'b')) => ('ieq', 'a', 'b')
 *    ('ieq', ('pack_64_2x32_split', 0, 'a'), '#b(is_lower_half_zero)') => ('ieq', 'a', ('unpack_64_2x32_split_y', 'b'))
 *    ('ieq', '#a(is_lower_half_zero)', ('pack_64_2x32_split', 0, 'b')) => ('ieq', ('unpack_64_2x32_split_y', 'a'), 'b')
 *    ('ine', ('pack_64_2x32_split', 'a', 0), ('pack_64_2x32_split', 'b', 0)) => ('ine', 'a', 'b')
 *    ('ine', ('pack_64_2x32_split', 'a', 0), '#b(is_upper_half_zero)') => ('ine', 'a', ('unpack_64_2x32_split_x', 'b'))
 *    ('ine', '#a(is_upper_half_zero)', ('pack_64_2x32_split', 'b', 0)) => ('ine', ('unpack_64_2x32_split_x', 'a'), 'b')
 *    ('ine', ('pack_64_2x32_split', 0, 'a'), ('pack_64_2x32_split', 0, 'b')) => ('ine', 'a', 'b')
 *    ('ine', ('pack_64_2x32_split', 0, 'a'), '#b(is_lower_half_zero)') => ('ine', 'a', ('unpack_64_2x32_split_y', 'b'))
 *    ('ine', '#a(is_lower_half_zero)', ('pack_64_2x32_split', 0, 'b')) => ('ine', ('unpack_64_2x32_split_y', 'a'), 'b')
 *    ('ult', ('pack_64_2x32_split', 'a', 0), ('pack_64_2x32_split', 'b', 0)) => ('ult', 'a', 'b')
 *    ('ult', ('pack_64_2x32_split', 'a', 0), '#b(is_upper_half_zero)') => ('ult', 'a', ('unpack_64_2x32_split_x', 'b'))
 *    ('ult', '#a(is_upper_half_zero)', ('pack_64_2x32_split', 'b', 0)) => ('ult', ('unpack_64_2x32_split_x', 'a'), 'b')
 *    ('ult', ('pack_64_2x32_split', 0, 'a'), ('pack_64_2x32_split', 0, 'b')) => ('ult', 'a', 'b')
 *    ('ult', ('pack_64_2x32_split', 0, 'a'), '#b(is_lower_half_zero)') => ('ult', 'a', ('unpack_64_2x32_split_y', 'b'))
 *    ('ult', '#a(is_lower_half_zero)', ('pack_64_2x32_split', 0, 'b')) => ('ult', ('unpack_64_2x32_split_y', 'a'), 'b')
 *    ('ilt', ('pack_64_2x32_split', 'a', 0), ('pack_64_2x32_split', 'b', 0)) => ('ult', 'a', 'b')
 *    ('ilt', ('pack_64_2x32_split', 'a', 0), '#b(is_upper_half_zero)') => ('ult', 'a', ('unpack_64_2x32_split_x', 'b'))
 *    ('ilt', '#a(is_upper_half_zero)', ('pack_64_2x32_split', 'b', 0)) => ('ult', ('unpack_64_2x32_split_x', 'a'), 'b')
 *    ('ilt', ('pack_64_2x32_split', 0, 'a'), ('pack_64_2x32_split', 0, 'b')) => ('ilt', 'a', 'b')
 *    ('ilt', ('pack_64_2x32_split', 0, 'a'), '#b(is_lower_half_zero)') => ('ilt', 'a', ('unpack_64_2x32_split_y', 'b'))
 *    ('ilt', '#a(is_lower_half_zero)', ('pack_64_2x32_split', 0, 'b')) => ('ilt', ('unpack_64_2x32_split_y', 'a'), 'b')
 *    ('uge', ('pack_64_2x32_split', 'a', 0), ('pack_64_2x32_split', 'b', 0)) => ('uge', 'a', 'b')
 *    ('uge', ('pack_64_2x32_split', 'a', 0), '#b(is_upper_half_zero)') => ('uge', 'a', ('unpack_64_2x32_split_x', 'b'))
 *    ('uge', '#a(is_upper_half_zero)', ('pack_64_2x32_split', 'b', 0)) => ('uge', ('unpack_64_2x32_split_x', 'a'), 'b')
 *    ('uge', ('pack_64_2x32_split', 0, 'a'), ('pack_64_2x32_split', 0, 'b')) => ('uge', 'a', 'b')
 *    ('uge', ('pack_64_2x32_split', 0, 'a'), '#b(is_lower_half_zero)') => ('uge', 'a', ('unpack_64_2x32_split_y', 'b'))
 *    ('uge', '#a(is_lower_half_zero)', ('pack_64_2x32_split', 0, 'b')) => ('uge', ('unpack_64_2x32_split_y', 'a'), 'b')
 *    ('ige', ('pack_64_2x32_split', 'a', 0), ('pack_64_2x32_split', 'b', 0)) => ('uge', 'a', 'b')
 *    ('ige', ('pack_64_2x32_split', 'a', 0), '#b(is_upper_half_zero)') => ('uge', 'a', ('unpack_64_2x32_split_x', 'b'))
 *    ('ige', '#a(is_upper_half_zero)', ('pack_64_2x32_split', 'b', 0)) => ('uge', ('unpack_64_2x32_split_x', 'a'), 'b')
 *    ('ige', ('pack_64_2x32_split', 0, 'a'), ('pack_64_2x32_split', 0, 'b')) => ('ige', 'a', 'b')
 *    ('ige', ('pack_64_2x32_split', 0, 'a'), '#b(is_lower_half_zero)') => ('ige', 'a', ('unpack_64_2x32_split_y', 'b'))
 *    ('ige', '#a(is_lower_half_zero)', ('pack_64_2x32_split', 0, 'b')) => ('ige', ('unpack_64_2x32_split_y', 'a'), 'b')
 *    ('ussub_4x8_vc4', 'a', 0) => a
 *    ('ussub_4x8_vc4', 'a', -1) => 0
 *    ('fsub', 'a', 'b') => ('fadd', 'a', ('fneg', 'b'))
 *    ('isub', 'a', 'b') => ('iadd', 'a', ('ineg', 'b'))
 *    ('uabs_usub', 'a', 'b') => ('bcsel', ('ult', 'a', 'b'), ('ineg', ('isub', 'a', 'b')), ('isub', 'a', 'b'))
 *    ('uabs_isub', 'a', 'b') => ('bcsel', ('ilt', 'a', 'b'), ('ineg', ('isub', 'a', 'b')), ('isub', 'a', 'b'))
 *    ('bitz', 'a', 'b') => ('inot', ('bitnz', 'a', 'b'))
 *    ('fmul(is_used_by_non_fsat)', ('fneg', 'a'), 'b') => ('fneg', ('fmul', 'a', 'b'))
 *    ('fmulz(is_used_by_non_fsat,nsz)', ('fneg', 'a'), 'b') => ('fneg', ('fmulz', 'a', 'b'))
 *    ('ffma', ('fneg', 'a'), ('fneg', 'b'), 'c') => ('ffma', 'a', 'b', 'c')
 *    ('ffmaz', ('fneg', 'a'), ('fneg', 'b'), 'c') => ('ffmaz', 'a', 'b', 'c')
 *    ('imul', ('ineg', 'a'), 'b') => ('ineg', ('imul', 'a', 'b'))
 *    ('~fmul(is_used_once)', ('fmul(is_used_once)', 'a(is_not_const)', 'b(is_not_const)'), '#c') => ('fmul', ('fmul', 'a', 'c'), 'b')
 *    ('~fmulz(is_used_once)', ('fmulz(is_used_once)', 'a(is_not_const)', 'b(is_not_const)'), '#c') => ('fmulz', ('fmulz', 'a', 'c'), 'b')
 *    ('~fmul(is_used_once)', ('fmulz(is_used_once)', 'a(is_not_const)', 'b(is_not_const)'), '#c(is_finite_not_zero)') => ('fmulz', ('fmul', 'a', 'c'), 'b')
 *    ('imul(is_used_once)', ('imul(is_used_once)', 'a(is_not_const)', 'b(is_not_const)'), '#c') => ('imul', ('imul', 'a', 'c'), 'b')
 *    ('~ffma', ('fmul(is_used_once)', 'a(is_not_const)', 'b(is_not_const)'), '#c', 'd') => ('ffma', ('fmul', 'a', 'c'), 'b', 'd')
 *    ('~ffmaz', ('fmulz(is_used_once)', 'a(is_not_const)', 'b(is_not_const)'), '#c', 'd') => ('ffmaz', ('fmulz', 'a', 'c'), 'b', 'd')
 *    ('~ffma', ('fmulz(is_used_once)', 'a(is_not_const)', 'b(is_not_const)'), '#c(is_finite_not_zero)', 'd') => ('ffmaz', ('fmul', 'a', 'c'), 'b', 'd')
 *    ('~fadd(is_used_once)', ('fadd(is_used_once)', 'a(is_not_const)', 'b(is_fmul)'), '#c') => ('fadd', ('fadd', 'a', 'c'), 'b')
 *    ('~fadd(is_used_once)', ('fadd(is_used_once)', 'a(is_not_const)', 'b(is_not_const)'), '#c') => ('fadd', ('fadd', 'a', 'c'), 'b')
 *    ('~fadd(is_used_once)', ('ffma(is_used_once)', 'a(is_not_const)', 'b', 'c(is_not_const)'), '#d') => ('fadd', ('ffma', 'a', 'b', 'd'), 'c')
 *    ('~fadd(is_used_once)', ('ffmaz(is_used_once)', 'a(is_not_const)', 'b', 'c(is_not_const)'), '#d') => ('fadd', ('ffmaz', 'a', 'b', 'd'), 'c')
 *    ('iadd(is_used_once)', ('iadd(is_used_once)', 'a(is_not_const)', 'b(is_not_const)'), '#c') => ('iadd', ('iadd', 'a', 'c'), 'b')
 *    ('~fmul', '#a', ('fmul', 'b(is_not_const)', '#c')) => ('fmul', ('fmul', 'a', 'c'), 'b')
 *    ('~fmulz', '#a', ('fmulz', 'b(is_not_const)', '#c')) => ('fmulz', ('fmulz', 'a', 'c'), 'b')
 *    ('~fmul', '#a(is_finite_not_zero)', ('fmulz', 'b(is_not_const)', '#c')) => ('fmulz', ('fmul', 'a', 'c'), 'b')
 *    ('~ffma', '#a', ('fmul', 'b(is_not_const)', '#c'), 'd') => ('ffma', ('fmul', 'a', 'c'), 'b', 'd')
 *    ('~ffmaz', '#a', ('fmulz', 'b(is_not_const)', '#c'), 'd') => ('ffmaz', ('fmulz', 'a', 'c'), 'b', 'd')
 *    ('~ffmaz', '#a(is_finite_not_zero)', ('fmulz', 'b(is_not_const)', '#c'), 'd') => ('ffmaz', ('fmul', 'a', 'c'), 'b', 'd')
 *    ('imul', '#a', ('imul', 'b(is_not_const)', '#c')) => ('imul', ('imul', 'a', 'c'), 'b')
 *    ('~fadd', '#a', ('fadd', 'b(is_not_const)', '#c')) => ('fadd', ('fadd', 'a', 'c'), 'b')
 *    ('~fadd', '#a', ('fneg', ('fadd', 'b(is_not_const)', '#c'))) => ('fadd', ('fadd', 'a', ('fneg', 'c')), ('fneg', 'b'))
 *    ('~fadd', '#a', ('ffma', 'b(is_not_const)', 'c(is_not_const)', '#d')) => ('ffma', 'b', 'c', ('fadd', 'a', 'd'))
 *    ('~fadd', '#a', ('fneg', ('ffma', 'b(is_not_const)', 'c(is_not_const)', '#d'))) => ('ffma', ('fneg', 'b'), 'c', ('fadd', 'a', ('fneg', 'd')))
 *    ('~fadd', '#a', ('ffmaz', 'b(is_not_const)', 'c(is_not_const)', '#d')) => ('ffmaz', 'b', 'c', ('fadd', 'a', 'd'))
 *    ('~fadd', '#a', ('fneg', ('ffmaz', 'b(is_not_const)', 'c(is_not_const)', '#d'))) => ('ffmaz', ('fneg', 'b'), 'c', ('fadd', 'a', ('fneg', 'd')))
 *    ('iadd', '#a', ('iadd', 'b(is_not_const)', '#c')) => ('iadd', ('iadd', 'a', 'c'), 'b')
 *    ('iand', '#a', ('iand', 'b(is_not_const)', '#c')) => ('iand', ('iand', 'a', 'c'), 'b')
 *    ('ior', '#a', ('ior', 'b(is_not_const)', '#c')) => ('ior', ('ior', 'a', 'c'), 'b')
 *    ('ixor', '#a', ('ixor', 'b(is_not_const)', '#c')) => ('ixor', ('ixor', 'a', 'c'), 'b')
 *    ('ior', ('iand', 'a', '#c'), ('ior', 'b', ('iand', 'a', '#d'))) => ('ior', 'b', ('iand', 'a', ('ior', 'c', 'd')))
 *    ('~fadd', ('fadd(is_used_once)', 'a(is_fmul)', 'b(is_fmul)'), 'c(is_not_fmul)') => ('fadd', ('fadd', 'a', 'c'), 'b')
 *    ('idiv', ('imul(no_signed_wrap)', 'a', 'b'), 'b') => a
 *    ('bcsel', ('ige', ('find_lsb', 'a'), 0), ('find_lsb', 'a'), -1) => ('find_lsb', 'a')
 *    ('bcsel', ('ige', ('ifind_msb', 'a'), 0), ('ifind_msb', 'a'), -1) => ('ifind_msb', 'a')
 *    ('bcsel', ('ige', ('ufind_msb', 'a'), 0), ('ufind_msb', 'a'), -1) => ('ufind_msb', 'a')
 *    ('bcsel', ('ige', ('ifind_msb_rev', 'a'), 0), ('ifind_msb_rev', 'a'), -1) => ('ifind_msb_rev', 'a')
 *    ('bcsel', ('ige', ('ufind_msb_rev', 'a'), 0), ('ufind_msb_rev', 'a'), -1) => ('ufind_msb_rev', 'a')
 *    ('bcsel', ('ine', 'a', 0), ('find_lsb', 'a'), -1) => ('find_lsb', 'a')
 *    ('bcsel', ('ine', 'a', 0), ('ifind_msb', 'a'), -1) => ('ifind_msb', 'a')
 *    ('bcsel', ('ine', 'a', 0), ('ufind_msb', 'a'), -1) => ('ufind_msb', 'a')
 *    ('bcsel', ('ine', 'a', 0), ('ifind_msb_rev', 'a'), -1) => ('ifind_msb_rev', 'a')
 *    ('bcsel', ('ine', 'a', 0), ('ufind_msb_rev', 'a'), -1) => ('ufind_msb_rev', 'a')
 *    ('bcsel', ('ine', 'a', -1), ('ifind_msb', 'a'), -1) => ('ifind_msb', 'a')
 *    ('bcsel', ('ine', 'a', -1), ('ifind_msb_rev', 'a'), -1) => ('ifind_msb_rev', 'a')
 *    ('bcsel', ('ine', ('ifind_msb', 'a@32'), -1), ('iadd', 31, ('ineg', ('ifind_msb', 'a'))), -1) => ('ifind_msb_rev', 'a')
 *    ('bcsel', ('ine', ('ufind_msb', 'a@32'), -1), ('iadd', 31, ('ineg', ('ufind_msb', 'a'))), -1) => ('ufind_msb_rev', 'a')
 *    ('bcsel', ('ieq', ('ifind_msb', 'a@32'), -1), -1, ('iadd', 31, ('ineg', ('ifind_msb', 'a')))) => ('ifind_msb_rev', 'a')
 *    ('bcsel', ('ieq', ('ufind_msb', 'a@32'), -1), -1, ('iadd', 31, ('ineg', ('ufind_msb', 'a')))) => ('ufind_msb_rev', 'a')
 *    ('bcsel', ('ine', ('ifind_msb', 'a@32'), -1), ('iadd', 31, ('ineg', ('ifind_msb', 'a'))), ('ifind_msb', 'a')) => ('ifind_msb_rev', 'a')
 *    ('bcsel', ('ine', ('ufind_msb', 'a@32'), -1), ('iadd', 31, ('ineg', ('ufind_msb', 'a'))), ('ufind_msb', 'a')) => ('ufind_msb_rev', 'a')
 *    ('bcsel', ('ieq', ('ifind_msb', 'a@32'), -1), ('ifind_msb', 'a'), ('iadd', 31, ('ineg', ('ifind_msb', 'a')))) => ('ifind_msb_rev', 'a')
 *    ('bcsel', ('ieq', ('ufind_msb', 'a@32'), -1), ('ufind_msb', 'a'), ('iadd', 31, ('ineg', ('ufind_msb', 'a')))) => ('ufind_msb_rev', 'a')
 *    ('bcsel', ('ine', 'a@32', 0), ('iadd', 31, ('ineg', ('ufind_msb', 'a'))), -1) => ('ufind_msb_rev', 'a')
 *    ('bcsel', ('ieq', 'a@32', 0), -1, ('iadd', 31, ('ineg', ('ufind_msb', 'a')))) => ('ufind_msb_rev', 'a')
 *    ('bcsel', ('ine', 'a@32', 0), ('iadd', 31, ('ineg', ('ufind_msb', 'a'))), ('ufind_msb', 'a')) => ('ufind_msb_rev', 'a')
 *    ('bcsel', ('ieq', 'a@32', 0), ('ufind_msb', 'a'), ('iadd', 31, ('ineg', ('ufind_msb', 'a')))) => ('ufind_msb_rev', 'a')
 *    ('bcsel', ('ine', ('ifind_msb_rev', 'a@32'), -1), ('iadd', 31, ('ineg', ('ifind_msb_rev', 'a'))), -1) => ('ifind_msb', 'a')
 *    ('bcsel', ('ine', ('ufind_msb_rev', 'a@32'), -1), ('iadd', 31, ('ineg', ('ufind_msb_rev', 'a'))), -1) => ('ufind_msb', 'a')
 *    ('bcsel', ('ieq', ('ifind_msb_rev', 'a@32'), -1), -1, ('iadd', 31, ('ineg', ('ifind_msb_rev', 'a')))) => ('ifind_msb', 'a')
 *    ('bcsel', ('ieq', ('ufind_msb_rev', 'a@32'), -1), -1, ('iadd', 31, ('ineg', ('ufind_msb_rev', 'a')))) => ('ufind_msb', 'a')
 *    ('bcsel', ('ine', ('ifind_msb_rev', 'a@32'), -1), ('iadd', 31, ('ineg', ('ifind_msb_rev', 'a'))), ('ifind_msb_rev', 'a')) => ('ifind_msb', 'a')
 *    ('bcsel', ('ine', ('ufind_msb_rev', 'a@32'), -1), ('iadd', 31, ('ineg', ('ufind_msb_rev', 'a'))), ('ufind_msb_rev', 'a')) => ('ufind_msb', 'a')
 *    ('bcsel', ('ieq', ('ifind_msb_rev', 'a@32'), -1), ('ifind_msb_rev', 'a'), ('iadd', 31, ('ineg', ('ifind_msb_rev', 'a')))) => ('ifind_msb', 'a')
 *    ('bcsel', ('ieq', ('ufind_msb_rev', 'a@32'), -1), ('ufind_msb_rev', 'a'), ('iadd', 31, ('ineg', ('ufind_msb_rev', 'a')))) => ('ufind_msb', 'a')
 *    ('bcsel', ('ine', 'a@32', 0), ('iadd', 31, ('ineg', ('ufind_msb_rev', 'a'))), -1) => ('ufind_msb', 'a')
 *    ('bcsel', ('ieq', 'a@32', 0), -1, ('iadd', 31, ('ineg', ('ufind_msb_rev', 'a')))) => ('ufind_msb', 'a')
 *    ('bcsel', ('ine', 'a@32', 0), ('iadd', 31, ('ineg', ('ufind_msb_rev', 'a'))), ('ufind_msb_rev', 'a')) => ('ufind_msb', 'a')
 *    ('bcsel', ('ieq', 'a@32', 0), ('ufind_msb_rev', 'a'), ('iadd', 31, ('ineg', ('ufind_msb_rev', 'a')))) => ('ufind_msb', 'a')
 *    ('iand', 'a', ('inot', ('ishl', 1, ('find_lsb', 'a')))) => ('iand', 'a', ('inot', ('ineg', 'a')))
 *    ('find_lsb', ('bitfield_reverse', 'a')) => ('ufind_msb_rev', 'a')
 *    ('ufind_msb_rev', ('bitfield_reverse', 'a')) => ('find_lsb', 'a')
 *    ('ifind_msb', ('f2i32(is_used_once)', 'a')) => ('ufind_msb', ('f2i32', ('fabs', 'a')))
 *    ('ifind_msb', ('extract_u8', 'a', 'b')) => ('ufind_msb', ('extract_u8', 'a', 'b'))
 *    ('ifind_msb', ('extract_u16', 'a', 'b')) => ('ufind_msb', ('extract_u16', 'a', 'b'))
 *    ('ifind_msb', ('imax', 'a', 1)) => ('ufind_msb', ('imax', 'a', 1))
 *    ('~fmul', ('bcsel(is_used_once)', 'c', -1.0, 1.0), 'b') => ('bcsel', 'c', ('fneg', 'b'), 'b')
 *    ('~fmul', ('bcsel(is_used_once)', 'c', 1.0, -1.0), 'b') => ('bcsel', 'c', 'b', ('fneg', 'b'))
 *    ('~fmulz', ('bcsel(is_used_once)', 'c', -1.0, 1.0), 'b') => ('bcsel', 'c', ('fneg', 'b'), 'b')
 *    ('~fmulz', ('bcsel(is_used_once)', 'c', 1.0, -1.0), 'b') => ('bcsel', 'c', 'b', ('fneg', 'b'))
 *    ('fabs', ('bcsel(is_used_once)', 'b', ('fneg', 'a'), 'a')) => ('fabs', 'a')
 *    ('fabs', ('bcsel(is_used_once)', 'b', 'a', ('fneg', 'a'))) => ('fabs', 'a')
 *    ('~bcsel', ('flt', 'a', 0.0), ('fneg', 'a'), 'a') => ('fabs', 'a')
 *    ('bcsel', 'a', ('bcsel', 'b', 'c', 'd'), 'd') => ('bcsel', ('iand', 'a', 'b'), 'c', 'd')
 *    ('bcsel', 'a', 'b', ('bcsel', 'c', 'b', 'd')) => ('bcsel', ('ior', 'a', 'c'), 'b', 'd')
 *    ('fmod', 'a', 'b') => ('fsub', 'a', ('fmul', 'b', ('ffloor', ('fdiv', 'a', 'b'))))
 *    ('frem', 'a', 'b') => ('fsub', 'a', ('fmul', 'b', ('ftrunc', ('fdiv', 'a', 'b'))))
 *    ('uadd_carry', 'a', 'b') => ('b2i', ('ult', ('iadd', 'a', 'b'), 'a'))
 *    ('usub_borrow', 'a', 'b') => ('b2i', ('ult', 'a', 'b'))
 *    ('bitfield_insert', 'base', 'insert', 'offset', 'bits') => ('bcsel', ('ult', 31, 'bits'), 'insert', ('bfi', ('bfm', 'bits', 'offset'), 'insert', 'base'))
 *    ('ihadd', 'a', 'b') => ('iadd', ('iand', 'a', 'b'), ('ishr', ('ixor', 'a', 'b'), 1))
 *    ('uhadd', 'a', 'b') => ('iadd', ('iand', 'a', 'b'), ('ushr', ('ixor', 'a', 'b'), 1))
 *    ('irhadd', 'a', 'b') => ('isub', ('ior', 'a', 'b'), ('ishr', ('ixor', 'a', 'b'), 1))
 *    ('urhadd', 'a', 'b') => ('isub', ('ior', 'a', 'b'), ('ushr', ('ixor', 'a', 'b'), 1))
 *    ('ihadd@64', 'a', 'b') => ('iadd', ('iand', 'a', 'b'), ('ishr', ('ixor', 'a', 'b'), 1))
 *    ('uhadd@64', 'a', 'b') => ('iadd', ('iand', 'a', 'b'), ('ushr', ('ixor', 'a', 'b'), 1))
 *    ('irhadd@64', 'a', 'b') => ('isub', ('ior', 'a', 'b'), ('ishr', ('ixor', 'a', 'b'), 1))
 *    ('urhadd@64', 'a', 'b') => ('isub', ('ior', 'a', 'b'), ('ushr', ('ixor', 'a', 'b'), 1))
 *    ('imul_32x16', 'a', 'b') => ('imul', 'a', ('extract_i16', 'b', 0))
 *    ('umul_32x16', 'a', 'b') => ('imul', 'a', ('extract_u16', 'b', 0))
 *    ('uadd_sat@64', 'a', 'b') => ('bcsel', ('ult', ('iadd', 'a', 'b'), 'a'), -1, ('iadd', 'a', 'b'))
 *    ('uadd_sat', 'a', 'b') => ('bcsel', ('ult', ('iadd', 'a', 'b'), 'a'), -1, ('iadd', 'a', 'b'))
 *    ('usub_sat', 'a', 'b') => ('bcsel', ('ult', 'a', 'b'), 0, ('isub', 'a', 'b'))
 *    ('usub_sat@64', 'a', 'b') => ('bcsel', ('ult', 'a', 'b'), 0, ('isub', 'a', 'b'))
 *    ('iadd_sat@64', 'a', 'b') => ('bcsel', ('iand', ('iand', ('ilt', 'a', 0), ('ilt', 'b', 0)), ('ige', ('iadd', 'a', 'b'), 0)), 9223372036854775808, ('bcsel', ('ior', ('ior', ('ilt', 'a', 0), ('ilt', 'b', 0)), ('ige', ('iadd', 'a', 'b'), 0)), ('iadd', 'a', 'b'), 9223372036854775807))
 *    ('isub_sat@64', 'a', 'b') => ('bcsel', ('iand', ('iand', ('ilt', 'a', 0), ('ige', 'b', 0)), ('ige', ('isub', 'a', 'b'), 0)), 9223372036854775808, ('bcsel', ('ior', ('ior', ('ilt', 'a', 0), ('ige', 'b', 0)), ('ige', ('isub', 'a', 'b'), 0)), ('isub', 'a', 'b'), 9223372036854775807))
 *    ('ilt', ('imax(is_used_once)', 'a@64', 'b@64'), 0) => ('ilt', ('imax', ('unpack_64_2x32_split_y', 'a'), ('unpack_64_2x32_split_y', 'b')), 0)
 *    ('ilt', ('imin(is_used_once)', 'a@64', 'b@64'), 0) => ('ilt', ('imin', ('unpack_64_2x32_split_y', 'a'), ('unpack_64_2x32_split_y', 'b')), 0)
 *    ('ige', ('imax(is_used_once)', 'a@64', 'b@64'), 0) => ('ige', ('imax', ('unpack_64_2x32_split_y', 'a'), ('unpack_64_2x32_split_y', 'b')), 0)
 *    ('ige', ('imin(is_used_once)', 'a@64', 'b@64'), 0) => ('ige', ('imin', ('unpack_64_2x32_split_y', 'a'), ('unpack_64_2x32_split_y', 'b')), 0)
 *    ('ilt', 'a@64', 0) => ('ilt', ('unpack_64_2x32_split_y', 'a'), 0)
 *    ('ige', 'a@64', 0) => ('ige', ('unpack_64_2x32_split_y', 'a'), 0)
 *    ('ine', 'a@64', 0) => ('ine', ('ior', ('unpack_64_2x32_split_x', 'a'), ('unpack_64_2x32_split_y', 'a')), 0)
 *    ('ieq', 'a@64', 0) => ('ieq', ('ior', ('unpack_64_2x32_split_x', 'a'), ('unpack_64_2x32_split_y', 'a')), 0)
 *    ('ult', 0, 'a@64') => ('ine', ('ior', ('unpack_64_2x32_split_x', 'a'), ('unpack_64_2x32_split_y', 'a')), 0)
 *    ('bitfield_insert', 'base', 'insert', 'offset', 'bits') => ('bcsel', ('ult', 31, 'bits'), 'insert', ('ior', ('iand', 'base', ('inot', ('ishl', ('isub', ('ishl', 1, 'bits'), 1), 'offset'))), ('iand', ('ishl', 'insert', 'offset'), ('ishl', ('isub', ('ishl', 1, 'bits'), 1), 'offset'))))
 *    ('bitfield_insert', 'base', 'insert', 'offset', 'bits') => ('bcsel', ('ult', 31, 'bits'), 'insert', ('bitfield_select', ('bfm', 'bits', 'offset'), ('ishl', 'insert', 'offset'), 'base'))
 *    ('ibitfield_extract', 'value', 'offset', 'bits') => ('bcsel', ('ult', 31, 'bits'), 'value', ('ibfe', 'value', 'offset', 'bits'))
 *    ('ubitfield_extract', 'value', 'offset', 'bits') => ('bcsel', ('ult', 31, 'bits'), 'value', ('ubfe', 'value', 'offset', 'bits'))
 *    ('bitfield_select', 'a', 'b', 0) => ('iand', 'a', 'b')
 *    ('bitfield_select', 'a', ('iand', 'a', 'b'), 'c') => ('bitfield_select', 'a', 'b', 'c')
 *    ('ubfe', 'value', 'offset', ('iand', 31, 'bits')) => ('ubfe', 'value', 'offset', 'bits')
 *    ('ubfe', 'value', ('iand', 31, 'offset'), 'bits') => ('ubfe', 'value', 'offset', 'bits')
 *    ('ibfe', 'value', 'offset', ('iand', 31, 'bits')) => ('ibfe', 'value', 'offset', 'bits')
 *    ('ibfe', 'value', ('iand', 31, 'offset'), 'bits') => ('ibfe', 'value', 'offset', 'bits')
 *    ('bfm', 'bits', ('iand', 31, 'offset')) => ('bfm', 'bits', 'offset')
 *    ('bfm', ('iand', 31, 'bits'), 'offset') => ('bfm', 'bits', 'offset')
 *    ('ult', 'a', ('umin', ('iand', 'a', 'b'), 'c')) => False
 *    ('ult', 31, ('umin', '#bits(is_ult_32)', 'a')) => False
 *    ('ubfe', 'value', 'offset', ('umin', 'width', ('iadd', 32, ('ineg', ('iand', 31, 'offset'))))) => ('ubfe', 'value', 'offset', 'width')
 *    ('ibfe', 'value', 'offset', ('umin', 'width', ('iadd', 32, ('ineg', ('iand', 31, 'offset'))))) => ('ibfe', 'value', 'offset', 'width')
 *    ('bfm', ('umin', 'width', ('iadd', 32, ('ineg', ('iand', 31, 'offset')))), 'offset') => ('bfm', 'width', 'offset')
 *    ('iadd@32', ('ishl', 1, 'a'), -1) => ('bfm', 'a', 0)
 *    ('ishl', ('bfm', 'a', 0), 'b') => ('bfm', 'a', 'b')
 *    ('ubfe', 'a', 'b', 0) => 0
 *    ('ibfe', 'a', 'b', 0) => 0
 *    ('ubfe', 'a', 0, '#b') => ('iand', 'a', ('ushr', 4294967295, ('ineg', 'b')))
 *    ('b2i32', ('ine', ('ubfe', 'a', 'b', 1), 0)) => ('ubfe', 'a', 'b', 1)
 *    ('b2i32', ('ine', ('ibfe', 'a', 'b', 1), 0)) => ('ubfe', 'a', 'b', 1)
 *    ('ine', ('ibfe(is_used_once)', 'a', '#b', '#c'), 0) => ('ine', ('iand', 'a', ('ishl', ('ushr', 4294967295, ('ineg', 'c')), 'b')), 0)
 *    ('ieq', ('ibfe(is_used_once)', 'a', '#b', '#c'), 0) => ('ieq', ('iand', 'a', ('ishl', ('ushr', 4294967295, ('ineg', 'c')), 'b')), 0)
 *    ('ine', ('ubfe(is_used_once)', 'a', '#b', '#c'), 0) => ('ine', ('iand', 'a', ('ishl', ('ushr', 4294967295, ('ineg', 'c')), 'b')), 0)
 *    ('ieq', ('ubfe(is_used_once)', 'a', '#b', '#c'), 0) => ('ieq', ('iand', 'a', ('ishl', ('ushr', 4294967295, ('ineg', 'c')), 'b')), 0)
 *    ('ibitfield_extract', 'value', 'offset', 'bits') => ('bcsel', ('ieq', 0, 'bits'), 0, ('ishr', ('ishl', 'value', ('isub', ('isub', 32, 'bits'), 'offset')), ('isub', 32, 'bits')))
 *    ('ubitfield_extract', 'value', 'offset', 'bits') => ('iand', ('ushr', 'value', 'offset'), ('bcsel', ('ieq', 'bits', 32), 4294967295, ('isub', ('ishl', 1, 'bits'), 1)))
 *    ('ifind_msb', 'value') => ('ufind_msb', ('bcsel', ('ilt', 'value', 0), ('inot', 'value'), 'value'))
 *    ('ifind_msb', 'value') => ('bcsel', ('ige', ('ifind_msb_rev', 'value'), 0), ('isub', 31, ('ifind_msb_rev', 'value')), ('ifind_msb_rev', 'value'))
 *    ('ifind_msb', 'value') => ('isub', 31, ('uclz', ('ixor', 'value', ('ishr', 'value', 31))))
 *    ('ufind_msb', 'value@32') => ('bcsel', ('ige', ('ufind_msb_rev', 'value'), 0), ('isub', 31, ('ufind_msb_rev', 'value')), ('ufind_msb_rev', 'value'))
 *    ('ufind_msb', 'value@32') => ('isub', 31, ('uclz', 'value'))
 *    ('uclz', 'a') => ('umin', 32, ('ufind_msb_rev', 'a'))
 *    ('find_lsb', 'value@64') => ('ufind_msb', ('iand', 'value', ('ineg', 'value')))
 *    ('find_lsb', 'value') => ('ufind_msb', ('u2u32', ('iand', 'value', ('ineg', 'value'))))
 *    ('extract_i8', 'a', 'b@32') => ('ishr', ('ishl', 'a', ('imul', ('isub', 3, 'b'), 8)), 24)
 *    ('extract_u8', 'a', 'b@32') => ('iand', ('ushr', 'a', ('imul', 'b', 8)), 255)
 *    ('extract_i16', 'a', 'b@32') => ('ishr', ('ishl', 'a', ('imul', ('isub', 1, 'b'), 16)), 16)
 *    ('extract_u16', 'a', 'b@32') => ('iand', ('ushr', 'a', ('imul', 'b', 16)), 65535)
 *    ('pack_unorm_2x16', 'v') => ('pack_uvec2_to_uint', ('f2u32', ('fround_even', ('fmul', ('fsat', 'v'), 65535.0))))
 *    ('pack_unorm_4x8', 'v') => ('pack_uvec4_to_uint', ('f2u32', ('fround_even', ('fmul', ('fsat', 'v'), 255.0))))
 *    ('pack_unorm_4x8', 'v') => ('pack_32_4x8', ('f2u8', ('fround_even', ('fmul', ('fsat', 'v'), 255.0))))
 *    ('pack_snorm_2x16', 'v') => ('pack_uvec2_to_uint', ('f2i32', ('fround_even', ('fmul', ('fmin', 1.0, ('fmax', -1.0, 'v')), 32767.0))))
 *    ('pack_snorm_4x8', 'v') => ('pack_uvec4_to_uint', ('f2i32', ('fround_even', ('fmul', ('fmin', 1.0, ('fmax', -1.0, 'v')), 127.0))))
 *    ('pack_snorm_4x8', 'v') => ('pack_32_4x8', ('f2i8', ('fround_even', ('fmul', ('fmin', 1.0, ('fmax', -1.0, 'v')), 127.0))))
 *    ('unpack_unorm_2x16', 'v') => ('fdiv', ('u2f32', ('vec2', ('extract_u16', 'v', 0), ('extract_u16', 'v', 1))), 65535.0)
 *    ('unpack_unorm_4x8', 'v') => ('fdiv', ('u2f32', ('vec4', ('extract_u8', 'v', 0), ('extract_u8', 'v', 1), ('extract_u8', 'v', 2), ('extract_u8', 'v', 3))), 255.0)
 *    ('unpack_snorm_2x16', 'v') => ('fmin', 1.0, ('fmax', -1.0, ('fdiv', ('i2f', ('vec2', ('extract_i16', 'v', 0), ('extract_i16', 'v', 1))), 32767.0)))
 *    ('unpack_snorm_4x8', 'v') => ('fmin', 1.0, ('fmax', -1.0, ('fdiv', ('i2f', ('vec4', ('extract_i8', 'v', 0), ('extract_i8', 'v', 1), ('extract_i8', 'v', 2), ('extract_i8', 'v', 3))), 127.0)))
 *    ('pack_half_2x16_split', 'a@32', 'b@32') => ('ior', ('ishl', ('u2u32', ('f2f16', 'b')), 16), ('u2u32', ('f2f16', 'a')))
 *    ('unpack_half_2x16_split_x', 'a@32') => ('f2f32', ('u2u16', 'a'))
 *    ('unpack_half_2x16_split_x', 'a@32') => ('f2f32', ('fmul', 1.0, ('u2u16', 'a')))
 *    ('unpack_half_2x16_split_y', 'a@32') => ('f2f32', ('u2u16', ('ushr', 'a', 16)))
 *    ('unpack_half_2x16_split_y', 'a@32') => ('f2f32', ('fmul', 1.0, ('u2u16', ('ushr', 'a', 16))))
 *    ('isign', 'a') => ('imin', ('imax', 'a', -1), 1)
 *    ('imin', ('imax', 'a', -1), 1) => ('isign', 'a')
 *    ('imax', ('imin', 'a', 1), -1) => ('isign', 'a')
 *    ('fsign', 'a') => ('fsub', ('b2f', ('!flt', 0.0, 'a')), ('b2f', ('!flt', 'a', 0.0)))
 *    ('fsign', 'a@64') => ('fsub', ('b2f', ('!flt', 0.0, 'a')), ('b2f', ('!flt', 'a', 0.0)))
 *    ('amul', 'a', 'b') => ('imul', 'a', 'b')
 *    ('umul24', 'a', 'b') => ('imul', ('iand', 'a', 16777215), ('iand', 'b', 16777215))
 *    ('umad24', 'a', 'b', 'c') => ('iadd', ('imul', ('iand', 'a', 16777215), ('iand', 'b', 16777215)), 'c')
 *    ('imul24_relaxed', 'a', 'b') => ('imul24', 'a', 'b')
 *    ('imul24_relaxed', 'a', 'b') => ('imul', 'a', 'b')
 *    ('umad24_relaxed', 'a', 'b', 'c') => ('umad24', 'a', 'b', 'c')
 *    ('umad24_relaxed', 'a', 'b', 'c') => ('iadd', ('umul24_relaxed', 'a', 'b'), 'c')
 *    ('umul24_relaxed', 'a', 'b') => ('umul24', 'a', 'b')
 *    ('umul24_relaxed', 'a', 'b') => ('imul', 'a', 'b')
 *    ('imad24_ir3', 'a', 'b', 0) => ('imul24', 'a', 'b')
 *    ('imad24_ir3', 'a', 0, 'c') => c
 *    ('imad24_ir3', 'a', 1, 'c') => ('iadd', 'a', 'c')
 *    ('imad24_ir3', '#a', '#b', 'c') => ('iadd', ('imul', 'a', 'b'), 'c')
 *    ('imul24', 'a', '#b@32(is_pos_power_of_two)') => ('ishl', 'a', ('find_lsb', 'b'))
 *    ('imul24', 'a', '#b@32(is_neg_power_of_two)') => ('ineg', ('ishl', 'a', ('find_lsb', ('iabs', 'b'))))
 *    ('imul24', 'a', 0) => 0
 *    ('bcsel', ('ult', ('iadd', 'a', 'b'), 'a'), -1, ('iadd@8', 'a', 'b')) => ('uadd_sat', 'a', 'b')
 *    ('bcsel', ('uge', ('iadd', 'a', 'b'), 'a'), ('iadd@8', 'a', 'b'), -1) => ('uadd_sat', 'a', 'b')
 *    ('bcsel', ('ieq', ('uadd_carry', 'a', 'b'), 0), ('iadd@8', 'a', 'b'), -1) => ('uadd_sat', 'a', 'b')
 *    ('bcsel', ('ine', ('uadd_carry', 'a', 'b'), 0), -1, ('iadd@8', 'a', 'b')) => ('uadd_sat', 'a', 'b')
 *    ('bcsel', ('ult', ('iadd', 'a', 'b'), 'a'), -1, ('iadd@16', 'a', 'b')) => ('uadd_sat', 'a', 'b')
 *    ('bcsel', ('uge', ('iadd', 'a', 'b'), 'a'), ('iadd@16', 'a', 'b'), -1) => ('uadd_sat', 'a', 'b')
 *    ('bcsel', ('ieq', ('uadd_carry', 'a', 'b'), 0), ('iadd@16', 'a', 'b'), -1) => ('uadd_sat', 'a', 'b')
 *    ('bcsel', ('ine', ('uadd_carry', 'a', 'b'), 0), -1, ('iadd@16', 'a', 'b')) => ('uadd_sat', 'a', 'b')
 *    ('bcsel', ('ult', ('iadd', 'a', 'b'), 'a'), -1, ('iadd@32', 'a', 'b')) => ('uadd_sat', 'a', 'b')
 *    ('bcsel', ('uge', ('iadd', 'a', 'b'), 'a'), ('iadd@32', 'a', 'b'), -1) => ('uadd_sat', 'a', 'b')
 *    ('bcsel', ('ieq', ('uadd_carry', 'a', 'b'), 0), ('iadd@32', 'a', 'b'), -1) => ('uadd_sat', 'a', 'b')
 *    ('bcsel', ('ine', ('uadd_carry', 'a', 'b'), 0), -1, ('iadd@32', 'a', 'b')) => ('uadd_sat', 'a', 'b')
 *    ('bcsel', ('ult', ('iadd', 'a', 'b'), 'a'), -1, ('iadd@64', 'a', 'b')) => ('uadd_sat', 'a', 'b')
 *    ('bcsel', ('uge', ('iadd', 'a', 'b'), 'a'), ('iadd@64', 'a', 'b'), -1) => ('uadd_sat', 'a', 'b')
 *    ('bcsel', ('ieq', ('uadd_carry', 'a', 'b'), 0), ('iadd@64', 'a', 'b'), -1) => ('uadd_sat', 'a', 'b')
 *    ('bcsel', ('ine', ('uadd_carry', 'a', 'b'), 0), -1, ('iadd@64', 'a', 'b')) => ('uadd_sat', 'a', 'b')
 *    ('bcsel', ('ult', 'a', 'b'), 0, ('iadd@8', 'a', ('ineg', 'b'))) => ('usub_sat', 'a', 'b')
 *    ('bcsel', ('uge', 'a', 'b'), ('iadd@8', 'a', ('ineg', 'b')), 0) => ('usub_sat', 'a', 'b')
 *    ('bcsel', ('ieq', ('usub_borrow', 'a', 'b'), 0), ('iadd@8', 'a', ('ineg', 'b')), 0) => ('usub_sat', 'a', 'b')
 *    ('bcsel', ('ine', ('usub_borrow', 'a', 'b'), 0), 0, ('iadd@8', 'a', ('ineg', 'b'))) => ('usub_sat', 'a', 'b')
 *    ('bcsel', ('ult', 'a', 'b'), 0, ('iadd@16', 'a', ('ineg', 'b'))) => ('usub_sat', 'a', 'b')
 *    ('bcsel', ('uge', 'a', 'b'), ('iadd@16', 'a', ('ineg', 'b')), 0) => ('usub_sat', 'a', 'b')
 *    ('bcsel', ('ieq', ('usub_borrow', 'a', 'b'), 0), ('iadd@16', 'a', ('ineg', 'b')), 0) => ('usub_sat', 'a', 'b')
 *    ('bcsel', ('ine', ('usub_borrow', 'a', 'b'), 0), 0, ('iadd@16', 'a', ('ineg', 'b'))) => ('usub_sat', 'a', 'b')
 *    ('bcsel', ('ult', 'a', 'b'), 0, ('iadd@32', 'a', ('ineg', 'b'))) => ('usub_sat', 'a', 'b')
 *    ('bcsel', ('uge', 'a', 'b'), ('iadd@32', 'a', ('ineg', 'b')), 0) => ('usub_sat', 'a', 'b')
 *    ('bcsel', ('ieq', ('usub_borrow', 'a', 'b'), 0), ('iadd@32', 'a', ('ineg', 'b')), 0) => ('usub_sat', 'a', 'b')
 *    ('bcsel', ('ine', ('usub_borrow', 'a', 'b'), 0), 0, ('iadd@32', 'a', ('ineg', 'b'))) => ('usub_sat', 'a', 'b')
 *    ('bcsel', ('ult', 'a', 'b'), 0, ('iadd@64', 'a', ('ineg', 'b'))) => ('usub_sat', 'a', 'b')
 *    ('bcsel', ('uge', 'a', 'b'), ('iadd@64', 'a', ('ineg', 'b')), 0) => ('usub_sat', 'a', 'b')
 *    ('bcsel', ('ieq', ('usub_borrow', 'a', 'b'), 0), ('iadd@64', 'a', ('ineg', 'b')), 0) => ('usub_sat', 'a', 'b')
 *    ('bcsel', ('ine', ('usub_borrow', 'a', 'b'), 0), 0, ('iadd@64', 'a', ('ineg', 'b'))) => ('usub_sat', 'a', 'b')
 *    ('iadd_sat@8', 'a', 'b') => ('bcsel', ('ige', 'b', 1), ('bcsel', ('ilt', ('iadd', 'a', 'b'), 'a'), 127, ('iadd', 'a', 'b')), ('bcsel', ('ilt', 'a', ('iadd', 'a', 'b')), 128, ('iadd', 'a', 'b')))
 *    ('isub_sat@8', 'a', 'b') => ('bcsel', ('ilt', 'b', 0), ('bcsel', ('ilt', ('isub', 'a', 'b'), 'a'), 127, ('isub', 'a', 'b')), ('bcsel', ('ilt', 'a', ('isub', 'a', 'b')), 128, ('isub', 'a', 'b')))
 *    ('iadd_sat@16', 'a', 'b') => ('bcsel', ('ige', 'b', 1), ('bcsel', ('ilt', ('iadd', 'a', 'b'), 'a'), 32767, ('iadd', 'a', 'b')), ('bcsel', ('ilt', 'a', ('iadd', 'a', 'b')), 32768, ('iadd', 'a', 'b')))
 *    ('isub_sat@16', 'a', 'b') => ('bcsel', ('ilt', 'b', 0), ('bcsel', ('ilt', ('isub', 'a', 'b'), 'a'), 32767, ('isub', 'a', 'b')), ('bcsel', ('ilt', 'a', ('isub', 'a', 'b')), 32768, ('isub', 'a', 'b')))
 *    ('iadd_sat@32', 'a', 'b') => ('bcsel', ('ige', 'b', 1), ('bcsel', ('ilt', ('iadd', 'a', 'b'), 'a'), 2147483647, ('iadd', 'a', 'b')), ('bcsel', ('ilt', 'a', ('iadd', 'a', 'b')), 2147483648, ('iadd', 'a', 'b')))
 *    ('isub_sat@32', 'a', 'b') => ('bcsel', ('ilt', 'b', 0), ('bcsel', ('ilt', ('isub', 'a', 'b'), 'a'), 2147483647, ('isub', 'a', 'b')), ('bcsel', ('ilt', 'a', ('isub', 'a', 'b')), 2147483648, ('isub', 'a', 'b')))
 *    ('iadd_sat@64', 'a', 'b') => ('bcsel', ('ige', 'b', 1), ('bcsel', ('ilt', ('iadd', 'a', 'b'), 'a'), 9223372036854775807, ('iadd', 'a', 'b')), ('bcsel', ('ilt', 'a', ('iadd', 'a', 'b')), 9223372036854775808, ('iadd', 'a', 'b')))
 *    ('isub_sat@64', 'a', 'b') => ('bcsel', ('ilt', 'b', 0), ('bcsel', ('ilt', ('isub', 'a', 'b'), 'a'), 9223372036854775807, ('isub', 'a', 'b')), ('bcsel', ('ilt', 'a', ('isub', 'a', 'b')), 9223372036854775808, ('isub', 'a', 'b')))
 *    ('inot', ('ior(is_used_once)', ('feq', 'a', 'b'), ('feq', 'c', 'd'))) => ('iand', ('fneu', 'a', 'b'), ('fneu', 'c', 'd'))
 *    ('inot', ('iand(is_used_once)', ('feq', 'a', 'b'), ('feq', 'c', 'd'))) => ('ior', ('fneu', 'a', 'b'), ('fneu', 'c', 'd'))
 *    ('inot', ('ior(is_used_once)', ('feq', 'a', 'b'), ('fneu', 'c', 'd'))) => ('iand', ('fneu', 'a', 'b'), ('feq', 'c', 'd'))
 *    ('inot', ('iand(is_used_once)', ('feq', 'a', 'b'), ('fneu', 'c', 'd'))) => ('ior', ('fneu', 'a', 'b'), ('feq', 'c', 'd'))
 *    ('inot', ('ior(is_used_once)', ('fneu', 'a', 'b'), ('fneu', 'c', 'd'))) => ('iand', ('feq', 'a', 'b'), ('feq', 'c', 'd'))
 *    ('inot', ('iand(is_used_once)', ('fneu', 'a', 'b'), ('fneu', 'c', 'd'))) => ('ior', ('feq', 'a', 'b'), ('feq', 'c', 'd'))
 *    ('f2f', ('b2f', 'a')) => ('b2f', 'a')
 *    ('f2u', ('b2f', 'a')) => ('b2i', 'a')
 *    ('f2i', ('b2f', 'a')) => ('b2i', 'a')
 *    ('u2f', ('b2i', 'a')) => ('b2f', 'a')
 *    ('u2u', ('b2i', 'a')) => ('b2i', 'a')
 *    ('i2f', ('b2i', 'a')) => ('b2f', 'a')
 *    ('i2i', ('b2i', 'a')) => ('b2i', 'a')
 *    ('i2i1', 'a@1') => a
 *    ('i2i8', 'a@8') => a
 *    ('i2i16', 'a@16') => a
 *    ('i2i32', 'a@32') => a
 *    ('i2i64', 'a@64') => a
 *    ('u2u1', 'a@1') => a
 *    ('u2u8', 'a@8') => a
 *    ('u2u16', 'a@16') => a
 *    ('u2u32', 'a@32') => a
 *    ('u2u64', 'a@64') => a
 *    ('f2f16', 'a@16') => a
 *    ('f2f32', 'a@32') => a
 *    ('f2f64', 'a@64') => a
 *    ('b2b1', 'a@1') => a
 *    ('b2b8', 'a@8') => a
 *    ('b2b16', 'a@16') => a
 *    ('b2b32', 'a@32') => a
 *    ('i2i1', ('i2i8', 'a')) => ('i2i1', 'a')
 *    ('i2i1', ('u2u8', 'a')) => ('u2u1', 'a')
 *    ('u2u1', ('i2i8', 'a')) => ('i2i1', 'a')
 *    ('u2u1', ('u2u8', 'a')) => ('u2u1', 'a')
 *    ('i2i1', ('i2i16', 'a')) => ('i2i1', 'a')
 *    ('i2i1', ('u2u16', 'a')) => ('u2u1', 'a')
 *    ('u2u1', ('i2i16', 'a')) => ('i2i1', 'a')
 *    ('u2u1', ('u2u16', 'a')) => ('u2u1', 'a')
 *    ('i2i1', ('i2i32', 'a')) => ('i2i1', 'a')
 *    ('i2i1', ('u2u32', 'a')) => ('u2u1', 'a')
 *    ('u2u1', ('i2i32', 'a')) => ('i2i1', 'a')
 *    ('u2u1', ('u2u32', 'a')) => ('u2u1', 'a')
 *    ('i2i1', ('i2i64', 'a')) => ('i2i1', 'a')
 *    ('i2i1', ('u2u64', 'a')) => ('u2u1', 'a')
 *    ('u2u1', ('i2i64', 'a')) => ('i2i1', 'a')
 *    ('u2u1', ('u2u64', 'a')) => ('u2u1', 'a')
 *    ('i2i8', ('i2i1', 'a@1')) => ('i2i8', 'a')
 *    ('u2u8', ('u2u1', 'a@1')) => ('u2u8', 'a')
 *    ('i2i8', ('i2i16', 'a')) => ('i2i8', 'a')
 *    ('i2i8', ('u2u16', 'a')) => ('u2u8', 'a')
 *    ('u2u8', ('i2i16', 'a')) => ('i2i8', 'a')
 *    ('u2u8', ('u2u16', 'a')) => ('u2u8', 'a')
 *    ('i2i8', ('i2i32', 'a')) => ('i2i8', 'a')
 *    ('i2i8', ('u2u32', 'a')) => ('u2u8', 'a')
 *    ('u2u8', ('i2i32', 'a')) => ('i2i8', 'a')
 *    ('u2u8', ('u2u32', 'a')) => ('u2u8', 'a')
 *    ('i2i8', ('i2i64', 'a')) => ('i2i8', 'a')
 *    ('i2i8', ('u2u64', 'a')) => ('u2u8', 'a')
 *    ('u2u8', ('i2i64', 'a')) => ('i2i8', 'a')
 *    ('u2u8', ('u2u64', 'a')) => ('u2u8', 'a')
 *    ('i2i16', ('i2i1', 'a@1')) => ('i2i16', 'a')
 *    ('u2u16', ('u2u1', 'a@1')) => ('u2u16', 'a')
 *    ('i2i16', ('i2i8', 'a@1')) => ('i2i16', 'a')
 *    ('u2u16', ('u2u8', 'a@1')) => ('u2u16', 'a')
 *    ('i2i16', ('i2i8', 'a@8')) => ('i2i16', 'a')
 *    ('u2u16', ('u2u8', 'a@8')) => ('u2u16', 'a')
 *    ('i2i16', ('i2i32', 'a')) => ('i2i16', 'a')
 *    ('i2i16', ('u2u32', 'a')) => ('u2u16', 'a')
 *    ('u2u16', ('i2i32', 'a')) => ('i2i16', 'a')
 *    ('u2u16', ('u2u32', 'a')) => ('u2u16', 'a')
 *    ('i2i16', ('i2i64', 'a')) => ('i2i16', 'a')
 *    ('i2i16', ('u2u64', 'a')) => ('u2u16', 'a')
 *    ('u2u16', ('i2i64', 'a')) => ('i2i16', 'a')
 *    ('u2u16', ('u2u64', 'a')) => ('u2u16', 'a')
 *    ('i2i32', ('i2i1', 'a@1')) => ('i2i32', 'a')
 *    ('u2u32', ('u2u1', 'a@1')) => ('u2u32', 'a')
 *    ('i2i32', ('i2i8', 'a@1')) => ('i2i32', 'a')
 *    ('u2u32', ('u2u8', 'a@1')) => ('u2u32', 'a')
 *    ('i2i32', ('i2i8', 'a@8')) => ('i2i32', 'a')
 *    ('u2u32', ('u2u8', 'a@8')) => ('u2u32', 'a')
 *    ('i2i32', ('i2i16', 'a@1')) => ('i2i32', 'a')
 *    ('u2u32', ('u2u16', 'a@1')) => ('u2u32', 'a')
 *    ('i2i32', ('i2i16', 'a@8')) => ('i2i32', 'a')
 *    ('u2u32', ('u2u16', 'a@8')) => ('u2u32', 'a')
 *    ('i2i32', ('i2i16', 'a@16')) => ('i2i32', 'a')
 *    ('u2u32', ('u2u16', 'a@16')) => ('u2u32', 'a')
 *    ('i2i32', ('i2i64', 'a')) => ('i2i32', 'a')
 *    ('i2i32', ('u2u64', 'a')) => ('u2u32', 'a')
 *    ('u2u32', ('i2i64', 'a')) => ('i2i32', 'a')
 *    ('u2u32', ('u2u64', 'a')) => ('u2u32', 'a')
 *    ('i2i64', ('i2i1', 'a@1')) => ('i2i64', 'a')
 *    ('u2u64', ('u2u1', 'a@1')) => ('u2u64', 'a')
 *    ('i2i64', ('i2i8', 'a@1')) => ('i2i64', 'a')
 *    ('u2u64', ('u2u8', 'a@1')) => ('u2u64', 'a')
 *    ('i2i64', ('i2i8', 'a@8')) => ('i2i64', 'a')
 *    ('u2u64', ('u2u8', 'a@8')) => ('u2u64', 'a')
 *    ('i2i64', ('i2i16', 'a@1')) => ('i2i64', 'a')
 *    ('u2u64', ('u2u16', 'a@1')) => ('u2u64', 'a')
 *    ('i2i64', ('i2i16', 'a@8')) => ('i2i64', 'a')
 *    ('u2u64', ('u2u16', 'a@8')) => ('u2u64', 'a')
 *    ('i2i64', ('i2i16', 'a@16')) => ('i2i64', 'a')
 *    ('u2u64', ('u2u16', 'a@16')) => ('u2u64', 'a')
 *    ('i2i64', ('i2i32', 'a@1')) => ('i2i64', 'a')
 *    ('u2u64', ('u2u32', 'a@1')) => ('u2u64', 'a')
 *    ('i2i64', ('i2i32', 'a@8')) => ('i2i64', 'a')
 *    ('u2u64', ('u2u32', 'a@8')) => ('u2u64', 'a')
 *    ('i2i64', ('i2i32', 'a@16')) => ('i2i64', 'a')
 *    ('u2u64', ('u2u32', 'a@16')) => ('u2u64', 'a')
 *    ('i2i64', ('i2i32', 'a@32')) => ('i2i64', 'a')
 *    ('u2u64', ('u2u32', 'a@32')) => ('u2u64', 'a')
 *    ('i2i8', ('pack_64_2x32_split', 'a', 'b')) => ('i2i8', 'a')
 *    ('i2i8', ('pack_64_2x32_split', 'a', 'b')) => ('i2i8', 'a')
 *    ('i2i16', ('pack_64_2x32_split', 'a', 'b')) => ('i2i16', 'a')
 *    ('i2i16', ('pack_64_2x32_split', 'a', 'b')) => ('i2i16', 'a')
 *    ('i2i32', ('pack_64_2x32_split', 'a', 'b')) => ('i2i32', 'a')
 *    ('i2i32', ('pack_64_2x32_split', 'a', 'b')) => ('i2i32', 'a')
 *    ('u2u8', ('pack_64_2x32_split', 'a', 'b')) => ('u2u8', 'a')
 *    ('u2u8', ('pack_64_2x32_split', 'a', 'b')) => ('u2u8', 'a')
 *    ('u2u16', ('pack_64_2x32_split', 'a', 'b')) => ('u2u16', 'a')
 *    ('u2u16', ('pack_64_2x32_split', 'a', 'b')) => ('u2u16', 'a')
 *    ('u2u32', ('pack_64_2x32_split', 'a', 'b')) => ('u2u32', 'a')
 *    ('u2u32', ('pack_64_2x32_split', 'a', 'b')) => ('u2u32', 'a')
 *    ('ieq', ('i2i16', 'a@8'), ('i2i16', 'b@8')) => ('ieq', 'a', ('i2i8', 'b'))
 *    ('ine', ('i2i16', 'a@8'), ('i2i16', 'b@8')) => ('ine', 'a', ('i2i8', 'b'))
 *    ('ige', ('i2i16', 'a@8'), ('i2i16', 'b@8')) => ('ige', 'a', ('i2i8', 'b'))
 *    ('ilt', ('i2i16', 'a@8'), ('i2i16', 'b@8')) => ('ilt', 'a', ('i2i8', 'b'))
 *    ('ige', ('i2i16', 'b@8'), ('i2i16', 'a@8')) => ('ige', ('i2i8', 'b'), 'a')
 *    ('ilt', ('i2i16', 'b@8'), ('i2i16', 'a@8')) => ('ilt', ('i2i8', 'b'), 'a')
 *    ('ieq', ('i2i16', 'a@8'), '#b') => ('iand', ('ieq', 'a', ('i2i8', 'b')), ('ieq', ('i2i16', ('i2i8', 'b')), 'b'))
 *    ('ine', ('i2i16', 'a@8'), '#b') => ('ior', ('ine', 'a', ('i2i8', 'b')), ('ine', ('i2i16', ('i2i8', 'b')), 'b'))
 *    ('ilt', ('i2i16', 'a@8'), '#b') => ('iand', ('ilt', -128, 'b'), ('ior', ('ilt', 127, 'b'), ('ilt', 'a', ('i2i8', 'b'))))
 *    ('ilt', '#a', ('i2i16', 'b@8')) => ('iand', ('ilt', 'a', 127), ('ior', ('ilt', 'a', -128), ('ilt', ('i2i8', 'a'), 'b')))
 *    ('ige', ('i2i16', 'a@8'), '#b') => ('iand', ('ige', 127, 'b'), ('ior', ('ige', -128, 'b'), ('ige', 'a', ('i2i8', 'b'))))
 *    ('ige', '#a', ('i2i16', 'b@8')) => ('iand', ('ige', 'a', -128), ('ior', ('ige', 'a', 127), ('ige', ('i2i8', 'a'), 'b')))
 *    ('ieq', ('i2i32', 'a@8'), ('i2i32', 'b@8')) => ('ieq', 'a', ('i2i8', 'b'))
 *    ('ine', ('i2i32', 'a@8'), ('i2i32', 'b@8')) => ('ine', 'a', ('i2i8', 'b'))
 *    ('ige', ('i2i32', 'a@8'), ('i2i32', 'b@8')) => ('ige', 'a', ('i2i8', 'b'))
 *    ('ilt', ('i2i32', 'a@8'), ('i2i32', 'b@8')) => ('ilt', 'a', ('i2i8', 'b'))
 *    ('ige', ('i2i32', 'b@8'), ('i2i32', 'a@8')) => ('ige', ('i2i8', 'b'), 'a')
 *    ('ilt', ('i2i32', 'b@8'), ('i2i32', 'a@8')) => ('ilt', ('i2i8', 'b'), 'a')
 *    ('ieq', ('i2i32', 'a@8'), '#b') => ('iand', ('ieq', 'a', ('i2i8', 'b')), ('ieq', ('i2i32', ('i2i8', 'b')), 'b'))
 *    ('ine', ('i2i32', 'a@8'), '#b') => ('ior', ('ine', 'a', ('i2i8', 'b')), ('ine', ('i2i32', ('i2i8', 'b')), 'b'))
 *    ('ilt', ('i2i32', 'a@8'), '#b') => ('iand', ('ilt', -128, 'b'), ('ior', ('ilt', 127, 'b'), ('ilt', 'a', ('i2i8', 'b'))))
 *    ('ilt', '#a', ('i2i32', 'b@8')) => ('iand', ('ilt', 'a', 127), ('ior', ('ilt', 'a', -128), ('ilt', ('i2i8', 'a'), 'b')))
 *    ('ige', ('i2i32', 'a@8'), '#b') => ('iand', ('ige', 127, 'b'), ('ior', ('ige', -128, 'b'), ('ige', 'a', ('i2i8', 'b'))))
 *    ('ige', '#a', ('i2i32', 'b@8')) => ('iand', ('ige', 'a', -128), ('ior', ('ige', 'a', 127), ('ige', ('i2i8', 'a'), 'b')))
 *    ('ieq', ('i2i64', 'a@8'), ('i2i64', 'b@8')) => ('ieq', 'a', ('i2i8', 'b'))
 *    ('ine', ('i2i64', 'a@8'), ('i2i64', 'b@8')) => ('ine', 'a', ('i2i8', 'b'))
 *    ('ige', ('i2i64', 'a@8'), ('i2i64', 'b@8')) => ('ige', 'a', ('i2i8', 'b'))
 *    ('ilt', ('i2i64', 'a@8'), ('i2i64', 'b@8')) => ('ilt', 'a', ('i2i8', 'b'))
 *    ('ige', ('i2i64', 'b@8'), ('i2i64', 'a@8')) => ('ige', ('i2i8', 'b'), 'a')
 *    ('ilt', ('i2i64', 'b@8'), ('i2i64', 'a@8')) => ('ilt', ('i2i8', 'b'), 'a')
 *    ('ieq', ('i2i64', 'a@8'), '#b') => ('iand', ('ieq', 'a', ('i2i8', 'b')), ('ieq', ('i2i64', ('i2i8', 'b')), 'b'))
 *    ('ine', ('i2i64', 'a@8'), '#b') => ('ior', ('ine', 'a', ('i2i8', 'b')), ('ine', ('i2i64', ('i2i8', 'b')), 'b'))
 *    ('ilt', ('i2i64', 'a@8'), '#b') => ('iand', ('ilt', -128, 'b'), ('ior', ('ilt', 127, 'b'), ('ilt', 'a', ('i2i8', 'b'))))
 *    ('ilt', '#a', ('i2i64', 'b@8')) => ('iand', ('ilt', 'a', 127), ('ior', ('ilt', 'a', -128), ('ilt', ('i2i8', 'a'), 'b')))
 *    ('ige', ('i2i64', 'a@8'), '#b') => ('iand', ('ige', 127, 'b'), ('ior', ('ige', -128, 'b'), ('ige', 'a', ('i2i8', 'b'))))
 *    ('ige', '#a', ('i2i64', 'b@8')) => ('iand', ('ige', 'a', -128), ('ior', ('ige', 'a', 127), ('ige', ('i2i8', 'a'), 'b')))
 *    ('ieq', ('i2i32', 'a@16'), ('i2i32', 'b@8')) => ('ieq', 'a', ('i2i16', 'b'))
 *    ('ine', ('i2i32', 'a@16'), ('i2i32', 'b@8')) => ('ine', 'a', ('i2i16', 'b'))
 *    ('ige', ('i2i32', 'a@16'), ('i2i32', 'b@8')) => ('ige', 'a', ('i2i16', 'b'))
 *    ('ilt', ('i2i32', 'a@16'), ('i2i32', 'b@8')) => ('ilt', 'a', ('i2i16', 'b'))
 *    ('ige', ('i2i32', 'b@8'), ('i2i32', 'a@16')) => ('ige', ('i2i16', 'b'), 'a')
 *    ('ilt', ('i2i32', 'b@8'), ('i2i32', 'a@16')) => ('ilt', ('i2i16', 'b'), 'a')
 *    ('ieq', ('i2i32', 'a@16'), ('i2i32', 'b@16')) => ('ieq', 'a', ('i2i16', 'b'))
 *    ('ine', ('i2i32', 'a@16'), ('i2i32', 'b@16')) => ('ine', 'a', ('i2i16', 'b'))
 *    ('ige', ('i2i32', 'a@16'), ('i2i32', 'b@16')) => ('ige', 'a', ('i2i16', 'b'))
 *    ('ilt', ('i2i32', 'a@16'), ('i2i32', 'b@16')) => ('ilt', 'a', ('i2i16', 'b'))
 *    ('ige', ('i2i32', 'b@16'), ('i2i32', 'a@16')) => ('ige', ('i2i16', 'b'), 'a')
 *    ('ilt', ('i2i32', 'b@16'), ('i2i32', 'a@16')) => ('ilt', ('i2i16', 'b'), 'a')
 *    ('ieq', ('i2i32', 'a@16'), '#b') => ('iand', ('ieq', 'a', ('i2i16', 'b')), ('ieq', ('i2i32', ('i2i16', 'b')), 'b'))
 *    ('ine', ('i2i32', 'a@16'), '#b') => ('ior', ('ine', 'a', ('i2i16', 'b')), ('ine', ('i2i32', ('i2i16', 'b')), 'b'))
 *    ('ilt', ('i2i32', 'a@16'), '#b') => ('iand', ('ilt', -32768, 'b'), ('ior', ('ilt', 32767, 'b'), ('ilt', 'a', ('i2i16', 'b'))))
 *    ('ilt', '#a', ('i2i32', 'b@16')) => ('iand', ('ilt', 'a', 32767), ('ior', ('ilt', 'a', -32768), ('ilt', ('i2i16', 'a'), 'b')))
 *    ('ige', ('i2i32', 'a@16'), '#b') => ('iand', ('ige', 32767, 'b'), ('ior', ('ige', -32768, 'b'), ('ige', 'a', ('i2i16', 'b'))))
 *    ('ige', '#a', ('i2i32', 'b@16')) => ('iand', ('ige', 'a', -32768), ('ior', ('ige', 'a', 32767), ('ige', ('i2i16', 'a'), 'b')))
 *    ('ieq', ('i2i64', 'a@16'), ('i2i64', 'b@8')) => ('ieq', 'a', ('i2i16', 'b'))
 *    ('ine', ('i2i64', 'a@16'), ('i2i64', 'b@8')) => ('ine', 'a', ('i2i16', 'b'))
 *    ('ige', ('i2i64', 'a@16'), ('i2i64', 'b@8')) => ('ige', 'a', ('i2i16', 'b'))
 *    ('ilt', ('i2i64', 'a@16'), ('i2i64', 'b@8')) => ('ilt', 'a', ('i2i16', 'b'))
 *    ('ige', ('i2i64', 'b@8'), ('i2i64', 'a@16')) => ('ige', ('i2i16', 'b'), 'a')
 *    ('ilt', ('i2i64', 'b@8'), ('i2i64', 'a@16')) => ('ilt', ('i2i16', 'b'), 'a')
 *    ('ieq', ('i2i64', 'a@16'), ('i2i64', 'b@16')) => ('ieq', 'a', ('i2i16', 'b'))
 *    ('ine', ('i2i64', 'a@16'), ('i2i64', 'b@16')) => ('ine', 'a', ('i2i16', 'b'))
 *    ('ige', ('i2i64', 'a@16'), ('i2i64', 'b@16')) => ('ige', 'a', ('i2i16', 'b'))
 *    ('ilt', ('i2i64', 'a@16'), ('i2i64', 'b@16')) => ('ilt', 'a', ('i2i16', 'b'))
 *    ('ige', ('i2i64', 'b@16'), ('i2i64', 'a@16')) => ('ige', ('i2i16', 'b'), 'a')
 *    ('ilt', ('i2i64', 'b@16'), ('i2i64', 'a@16')) => ('ilt', ('i2i16', 'b'), 'a')
 *    ('ieq', ('i2i64', 'a@16'), '#b') => ('iand', ('ieq', 'a', ('i2i16', 'b')), ('ieq', ('i2i64', ('i2i16', 'b')), 'b'))
 *    ('ine', ('i2i64', 'a@16'), '#b') => ('ior', ('ine', 'a', ('i2i16', 'b')), ('ine', ('i2i64', ('i2i16', 'b')), 'b'))
 *    ('ilt', ('i2i64', 'a@16'), '#b') => ('iand', ('ilt', -32768, 'b'), ('ior', ('ilt', 32767, 'b'), ('ilt', 'a', ('i2i16', 'b'))))
 *    ('ilt', '#a', ('i2i64', 'b@16')) => ('iand', ('ilt', 'a', 32767), ('ior', ('ilt', 'a', -32768), ('ilt', ('i2i16', 'a'), 'b')))
 *    ('ige', ('i2i64', 'a@16'), '#b') => ('iand', ('ige', 32767, 'b'), ('ior', ('ige', -32768, 'b'), ('ige', 'a', ('i2i16', 'b'))))
 *    ('ige', '#a', ('i2i64', 'b@16')) => ('iand', ('ige', 'a', -32768), ('ior', ('ige', 'a', 32767), ('ige', ('i2i16', 'a'), 'b')))
 *    ('ieq', ('i2i64', 'a@32'), ('i2i64', 'b@8')) => ('ieq', 'a', ('i2i32', 'b'))
 *    ('ine', ('i2i64', 'a@32'), ('i2i64', 'b@8')) => ('ine', 'a', ('i2i32', 'b'))
 *    ('ige', ('i2i64', 'a@32'), ('i2i64', 'b@8')) => ('ige', 'a', ('i2i32', 'b'))
 *    ('ilt', ('i2i64', 'a@32'), ('i2i64', 'b@8')) => ('ilt', 'a', ('i2i32', 'b'))
 *    ('ige', ('i2i64', 'b@8'), ('i2i64', 'a@32')) => ('ige', ('i2i32', 'b'), 'a')
 *    ('ilt', ('i2i64', 'b@8'), ('i2i64', 'a@32')) => ('ilt', ('i2i32', 'b'), 'a')
 *    ('ieq', ('i2i64', 'a@32'), ('i2i64', 'b@16')) => ('ieq', 'a', ('i2i32', 'b'))
 *    ('ine', ('i2i64', 'a@32'), ('i2i64', 'b@16')) => ('ine', 'a', ('i2i32', 'b'))
 *    ('ige', ('i2i64', 'a@32'), ('i2i64', 'b@16')) => ('ige', 'a', ('i2i32', 'b'))
 *    ('ilt', ('i2i64', 'a@32'), ('i2i64', 'b@16')) => ('ilt', 'a', ('i2i32', 'b'))
 *    ('ige', ('i2i64', 'b@16'), ('i2i64', 'a@32')) => ('ige', ('i2i32', 'b'), 'a')
 *    ('ilt', ('i2i64', 'b@16'), ('i2i64', 'a@32')) => ('ilt', ('i2i32', 'b'), 'a')
 *    ('ieq', ('i2i64', 'a@32'), ('i2i64', 'b@32')) => ('ieq', 'a', ('i2i32', 'b'))
 *    ('ine', ('i2i64', 'a@32'), ('i2i64', 'b@32')) => ('ine', 'a', ('i2i32', 'b'))
 *    ('ige', ('i2i64', 'a@32'), ('i2i64', 'b@32')) => ('ige', 'a', ('i2i32', 'b'))
 *    ('ilt', ('i2i64', 'a@32'), ('i2i64', 'b@32')) => ('ilt', 'a', ('i2i32', 'b'))
 *    ('ige', ('i2i64', 'b@32'), ('i2i64', 'a@32')) => ('ige', ('i2i32', 'b'), 'a')
 *    ('ilt', ('i2i64', 'b@32'), ('i2i64', 'a@32')) => ('ilt', ('i2i32', 'b'), 'a')
 *    ('ieq', ('i2i64', 'a@32'), '#b') => ('iand', ('ieq', 'a', ('i2i32', 'b')), ('ieq', ('i2i64', ('i2i32', 'b')), 'b'))
 *    ('ine', ('i2i64', 'a@32'), '#b') => ('ior', ('ine', 'a', ('i2i32', 'b')), ('ine', ('i2i64', ('i2i32', 'b')), 'b'))
 *    ('ilt', ('i2i64', 'a@32'), '#b') => ('iand', ('ilt', -2147483648, 'b'), ('ior', ('ilt', 2147483647, 'b'), ('ilt', 'a', ('i2i32', 'b'))))
 *    ('ilt', '#a', ('i2i64', 'b@32')) => ('iand', ('ilt', 'a', 2147483647), ('ior', ('ilt', 'a', -2147483648), ('ilt', ('i2i32', 'a'), 'b')))
 *    ('ige', ('i2i64', 'a@32'), '#b') => ('iand', ('ige', 2147483647, 'b'), ('ior', ('ige', -2147483648, 'b'), ('ige', 'a', ('i2i32', 'b'))))
 *    ('ige', '#a', ('i2i64', 'b@32')) => ('iand', ('ige', 'a', -2147483648), ('ior', ('ige', 'a', 2147483647), ('ige', ('i2i32', 'a'), 'b')))
 *    ('ieq', ('u2u16', 'a@8'), ('u2u16', 'b@8')) => ('ieq', 'a', ('u2u8', 'b'))
 *    ('ine', ('u2u16', 'a@8'), ('u2u16', 'b@8')) => ('ine', 'a', ('u2u8', 'b'))
 *    ('uge', ('u2u16', 'a@8'), ('u2u16', 'b@8')) => ('uge', 'a', ('u2u8', 'b'))
 *    ('ult', ('u2u16', 'a@8'), ('u2u16', 'b@8')) => ('ult', 'a', ('u2u8', 'b'))
 *    ('uge', ('u2u16', 'b@8'), ('u2u16', 'a@8')) => ('uge', ('u2u8', 'b'), 'a')
 *    ('ult', ('u2u16', 'b@8'), ('u2u16', 'a@8')) => ('ult', ('u2u8', 'b'), 'a')
 *    ('ieq', ('u2u16', 'a@8'), '#b') => ('iand', ('ieq', 'a', ('u2u8', 'b')), ('ieq', ('u2u16', ('u2u8', 'b')), 'b'))
 *    ('ine', ('u2u16', 'a@8'), '#b') => ('ior', ('ine', 'a', ('u2u8', 'b')), ('ine', ('u2u16', ('u2u8', 'b')), 'b'))
 *    ('ult', ('u2u16', 'a@8'), '#b') => ('iand', ('ult', 0, 'b'), ('ior', ('ult', 255, 'b'), ('ult', 'a', ('u2u8', 'b'))))
 *    ('ult', '#a', ('u2u16', 'b@8')) => ('iand', ('ult', 'a', 255), ('ior', ('ult', 'a', 0), ('ult', ('u2u8', 'a'), 'b')))
 *    ('uge', ('u2u16', 'a@8'), '#b') => ('iand', ('uge', 255, 'b'), ('ior', ('uge', 0, 'b'), ('uge', 'a', ('u2u8', 'b'))))
 *    ('uge', '#a', ('u2u16', 'b@8')) => ('iand', ('uge', 'a', 0), ('ior', ('uge', 'a', 255), ('uge', ('u2u8', 'a'), 'b')))
 *    ('ieq', ('u2u32', 'a@8'), ('u2u32', 'b@8')) => ('ieq', 'a', ('u2u8', 'b'))
 *    ('ine', ('u2u32', 'a@8'), ('u2u32', 'b@8')) => ('ine', 'a', ('u2u8', 'b'))
 *    ('uge', ('u2u32', 'a@8'), ('u2u32', 'b@8')) => ('uge', 'a', ('u2u8', 'b'))
 *    ('ult', ('u2u32', 'a@8'), ('u2u32', 'b@8')) => ('ult', 'a', ('u2u8', 'b'))
 *    ('uge', ('u2u32', 'b@8'), ('u2u32', 'a@8')) => ('uge', ('u2u8', 'b'), 'a')
 *    ('ult', ('u2u32', 'b@8'), ('u2u32', 'a@8')) => ('ult', ('u2u8', 'b'), 'a')
 *    ('ieq', ('u2u32', 'a@8'), '#b') => ('iand', ('ieq', 'a', ('u2u8', 'b')), ('ieq', ('u2u32', ('u2u8', 'b')), 'b'))
 *    ('ine', ('u2u32', 'a@8'), '#b') => ('ior', ('ine', 'a', ('u2u8', 'b')), ('ine', ('u2u32', ('u2u8', 'b')), 'b'))
 *    ('ult', ('u2u32', 'a@8'), '#b') => ('iand', ('ult', 0, 'b'), ('ior', ('ult', 255, 'b'), ('ult', 'a', ('u2u8', 'b'))))
 *    ('ult', '#a', ('u2u32', 'b@8')) => ('iand', ('ult', 'a', 255), ('ior', ('ult', 'a', 0), ('ult', ('u2u8', 'a'), 'b')))
 *    ('uge', ('u2u32', 'a@8'), '#b') => ('iand', ('uge', 255, 'b'), ('ior', ('uge', 0, 'b'), ('uge', 'a', ('u2u8', 'b'))))
 *    ('uge', '#a', ('u2u32', 'b@8')) => ('iand', ('uge', 'a', 0), ('ior', ('uge', 'a', 255), ('uge', ('u2u8', 'a'), 'b')))
 *    ('ieq', ('u2u64', 'a@8'), ('u2u64', 'b@8')) => ('ieq', 'a', ('u2u8', 'b'))
 *    ('ine', ('u2u64', 'a@8'), ('u2u64', 'b@8')) => ('ine', 'a', ('u2u8', 'b'))
 *    ('uge', ('u2u64', 'a@8'), ('u2u64', 'b@8')) => ('uge', 'a', ('u2u8', 'b'))
 *    ('ult', ('u2u64', 'a@8'), ('u2u64', 'b@8')) => ('ult', 'a', ('u2u8', 'b'))
 *    ('uge', ('u2u64', 'b@8'), ('u2u64', 'a@8')) => ('uge', ('u2u8', 'b'), 'a')
 *    ('ult', ('u2u64', 'b@8'), ('u2u64', 'a@8')) => ('ult', ('u2u8', 'b'), 'a')
 *    ('ieq', ('u2u64', 'a@8'), '#b') => ('iand', ('ieq', 'a', ('u2u8', 'b')), ('ieq', ('u2u64', ('u2u8', 'b')), 'b'))
 *    ('ine', ('u2u64', 'a@8'), '#b') => ('ior', ('ine', 'a', ('u2u8', 'b')), ('ine', ('u2u64', ('u2u8', 'b')), 'b'))
 *    ('ult', ('u2u64', 'a@8'), '#b') => ('iand', ('ult', 0, 'b'), ('ior', ('ult', 255, 'b'), ('ult', 'a', ('u2u8', 'b'))))
 *    ('ult', '#a', ('u2u64', 'b@8')) => ('iand', ('ult', 'a', 255), ('ior', ('ult', 'a', 0), ('ult', ('u2u8', 'a'), 'b')))
 *    ('uge', ('u2u64', 'a@8'), '#b') => ('iand', ('uge', 255, 'b'), ('ior', ('uge', 0, 'b'), ('uge', 'a', ('u2u8', 'b'))))
 *    ('uge', '#a', ('u2u64', 'b@8')) => ('iand', ('uge', 'a', 0), ('ior', ('uge', 'a', 255), ('uge', ('u2u8', 'a'), 'b')))
 *    ('ieq', ('u2u32', 'a@16'), ('u2u32', 'b@8')) => ('ieq', 'a', ('u2u16', 'b'))
 *    ('ine', ('u2u32', 'a@16'), ('u2u32', 'b@8')) => ('ine', 'a', ('u2u16', 'b'))
 *    ('uge', ('u2u32', 'a@16'), ('u2u32', 'b@8')) => ('uge', 'a', ('u2u16', 'b'))
 *    ('ult', ('u2u32', 'a@16'), ('u2u32', 'b@8')) => ('ult', 'a', ('u2u16', 'b'))
 *    ('uge', ('u2u32', 'b@8'), ('u2u32', 'a@16')) => ('uge', ('u2u16', 'b'), 'a')
 *    ('ult', ('u2u32', 'b@8'), ('u2u32', 'a@16')) => ('ult', ('u2u16', 'b'), 'a')
 *    ('ieq', ('u2u32', 'a@16'), ('u2u32', 'b@16')) => ('ieq', 'a', ('u2u16', 'b'))
 *    ('ine', ('u2u32', 'a@16'), ('u2u32', 'b@16')) => ('ine', 'a', ('u2u16', 'b'))
 *    ('uge', ('u2u32', 'a@16'), ('u2u32', 'b@16')) => ('uge', 'a', ('u2u16', 'b'))
 *    ('ult', ('u2u32', 'a@16'), ('u2u32', 'b@16')) => ('ult', 'a', ('u2u16', 'b'))
 *    ('uge', ('u2u32', 'b@16'), ('u2u32', 'a@16')) => ('uge', ('u2u16', 'b'), 'a')
 *    ('ult', ('u2u32', 'b@16'), ('u2u32', 'a@16')) => ('ult', ('u2u16', 'b'), 'a')
 *    ('ieq', ('u2u32', 'a@16'), '#b') => ('iand', ('ieq', 'a', ('u2u16', 'b')), ('ieq', ('u2u32', ('u2u16', 'b')), 'b'))
 *    ('ine', ('u2u32', 'a@16'), '#b') => ('ior', ('ine', 'a', ('u2u16', 'b')), ('ine', ('u2u32', ('u2u16', 'b')), 'b'))
 *    ('ult', ('u2u32', 'a@16'), '#b') => ('iand', ('ult', 0, 'b'), ('ior', ('ult', 65535, 'b'), ('ult', 'a', ('u2u16', 'b'))))
 *    ('ult', '#a', ('u2u32', 'b@16')) => ('iand', ('ult', 'a', 65535), ('ior', ('ult', 'a', 0), ('ult', ('u2u16', 'a'), 'b')))
 *    ('uge', ('u2u32', 'a@16'), '#b') => ('iand', ('uge', 65535, 'b'), ('ior', ('uge', 0, 'b'), ('uge', 'a', ('u2u16', 'b'))))
 *    ('uge', '#a', ('u2u32', 'b@16')) => ('iand', ('uge', 'a', 0), ('ior', ('uge', 'a', 65535), ('uge', ('u2u16', 'a'), 'b')))
 *    ('ieq', ('u2u64', 'a@16'), ('u2u64', 'b@8')) => ('ieq', 'a', ('u2u16', 'b'))
 *    ('ine', ('u2u64', 'a@16'), ('u2u64', 'b@8')) => ('ine', 'a', ('u2u16', 'b'))
 *    ('uge', ('u2u64', 'a@16'), ('u2u64', 'b@8')) => ('uge', 'a', ('u2u16', 'b'))
 *    ('ult', ('u2u64', 'a@16'), ('u2u64', 'b@8')) => ('ult', 'a', ('u2u16', 'b'))
 *    ('uge', ('u2u64', 'b@8'), ('u2u64', 'a@16')) => ('uge', ('u2u16', 'b'), 'a')
 *    ('ult', ('u2u64', 'b@8'), ('u2u64', 'a@16')) => ('ult', ('u2u16', 'b'), 'a')
 *    ('ieq', ('u2u64', 'a@16'), ('u2u64', 'b@16')) => ('ieq', 'a', ('u2u16', 'b'))
 *    ('ine', ('u2u64', 'a@16'), ('u2u64', 'b@16')) => ('ine', 'a', ('u2u16', 'b'))
 *    ('uge', ('u2u64', 'a@16'), ('u2u64', 'b@16')) => ('uge', 'a', ('u2u16', 'b'))
 *    ('ult', ('u2u64', 'a@16'), ('u2u64', 'b@16')) => ('ult', 'a', ('u2u16', 'b'))
 *    ('uge', ('u2u64', 'b@16'), ('u2u64', 'a@16')) => ('uge', ('u2u16', 'b'), 'a')
 *    ('ult', ('u2u64', 'b@16'), ('u2u64', 'a@16')) => ('ult', ('u2u16', 'b'), 'a')
 *    ('ieq', ('u2u64', 'a@16'), '#b') => ('iand', ('ieq', 'a', ('u2u16', 'b')), ('ieq', ('u2u64', ('u2u16', 'b')), 'b'))
 *    ('ine', ('u2u64', 'a@16'), '#b') => ('ior', ('ine', 'a', ('u2u16', 'b')), ('ine', ('u2u64', ('u2u16', 'b')), 'b'))
 *    ('ult', ('u2u64', 'a@16'), '#b') => ('iand', ('ult', 0, 'b'), ('ior', ('ult', 65535, 'b'), ('ult', 'a', ('u2u16', 'b'))))
 *    ('ult', '#a', ('u2u64', 'b@16')) => ('iand', ('ult', 'a', 65535), ('ior', ('ult', 'a', 0), ('ult', ('u2u16', 'a'), 'b')))
 *    ('uge', ('u2u64', 'a@16'), '#b') => ('iand', ('uge', 65535, 'b'), ('ior', ('uge', 0, 'b'), ('uge', 'a', ('u2u16', 'b'))))
 *    ('uge', '#a', ('u2u64', 'b@16')) => ('iand', ('uge', 'a', 0), ('ior', ('uge', 'a', 65535), ('uge', ('u2u16', 'a'), 'b')))
 *    ('ieq', ('u2u64', 'a@32'), ('u2u64', 'b@8')) => ('ieq', 'a', ('u2u32', 'b'))
 *    ('ine', ('u2u64', 'a@32'), ('u2u64', 'b@8')) => ('ine', 'a', ('u2u32', 'b'))
 *    ('uge', ('u2u64', 'a@32'), ('u2u64', 'b@8')) => ('uge', 'a', ('u2u32', 'b'))
 *    ('ult', ('u2u64', 'a@32'), ('u2u64', 'b@8')) => ('ult', 'a', ('u2u32', 'b'))
 *    ('uge', ('u2u64', 'b@8'), ('u2u64', 'a@32')) => ('uge', ('u2u32', 'b'), 'a')
 *    ('ult', ('u2u64', 'b@8'), ('u2u64', 'a@32')) => ('ult', ('u2u32', 'b'), 'a')
 *    ('ieq', ('u2u64', 'a@32'), ('u2u64', 'b@16')) => ('ieq', 'a', ('u2u32', 'b'))
 *    ('ine', ('u2u64', 'a@32'), ('u2u64', 'b@16')) => ('ine', 'a', ('u2u32', 'b'))
 *    ('uge', ('u2u64', 'a@32'), ('u2u64', 'b@16')) => ('uge', 'a', ('u2u32', 'b'))
 *    ('ult', ('u2u64', 'a@32'), ('u2u64', 'b@16')) => ('ult', 'a', ('u2u32', 'b'))
 *    ('uge', ('u2u64', 'b@16'), ('u2u64', 'a@32')) => ('uge', ('u2u32', 'b'), 'a')
 *    ('ult', ('u2u64', 'b@16'), ('u2u64', 'a@32')) => ('ult', ('u2u32', 'b'), 'a')
 *    ('ieq', ('u2u64', 'a@32'), ('u2u64', 'b@32')) => ('ieq', 'a', ('u2u32', 'b'))
 *    ('ine', ('u2u64', 'a@32'), ('u2u64', 'b@32')) => ('ine', 'a', ('u2u32', 'b'))
 *    ('uge', ('u2u64', 'a@32'), ('u2u64', 'b@32')) => ('uge', 'a', ('u2u32', 'b'))
 *    ('ult', ('u2u64', 'a@32'), ('u2u64', 'b@32')) => ('ult', 'a', ('u2u32', 'b'))
 *    ('uge', ('u2u64', 'b@32'), ('u2u64', 'a@32')) => ('uge', ('u2u32', 'b'), 'a')
 *    ('ult', ('u2u64', 'b@32'), ('u2u64', 'a@32')) => ('ult', ('u2u32', 'b'), 'a')
 *    ('ieq', ('u2u64', 'a@32'), '#b') => ('iand', ('ieq', 'a', ('u2u32', 'b')), ('ieq', ('u2u64', ('u2u32', 'b')), 'b'))
 *    ('ine', ('u2u64', 'a@32'), '#b') => ('ior', ('ine', 'a', ('u2u32', 'b')), ('ine', ('u2u64', ('u2u32', 'b')), 'b'))
 *    ('ult', ('u2u64', 'a@32'), '#b') => ('iand', ('ult', 0, 'b'), ('ior', ('ult', 4294967295, 'b'), ('ult', 'a', ('u2u32', 'b'))))
 *    ('ult', '#a', ('u2u64', 'b@32')) => ('iand', ('ult', 'a', 4294967295), ('ior', ('ult', 'a', 0), ('ult', ('u2u32', 'a'), 'b')))
 *    ('uge', ('u2u64', 'a@32'), '#b') => ('iand', ('uge', 4294967295, 'b'), ('ior', ('uge', 0, 'b'), ('uge', 'a', ('u2u32', 'b'))))
 *    ('uge', '#a', ('u2u64', 'b@32')) => ('iand', ('uge', 'a', 0), ('ior', ('uge', 'a', 4294967295), ('uge', ('u2u32', 'a'), 'b')))
 *    ('feq', ('f2f32', 'a@16'), ('f2f32', 'b@16')) => ('feq', 'a', ('f2f16', 'b'))
 *    ('fneu', ('f2f32', 'a@16'), ('f2f32', 'b@16')) => ('fneu', 'a', ('f2f16', 'b'))
 *    ('fge', ('f2f32', 'a@16'), ('f2f32', 'b@16')) => ('fge', 'a', ('f2f16', 'b'))
 *    ('flt', ('f2f32', 'a@16'), ('f2f32', 'b@16')) => ('flt', 'a', ('f2f16', 'b'))
 *    ('fge', ('f2f32', 'b@16'), ('f2f32', 'a@16')) => ('fge', ('f2f16', 'b'), 'a')
 *    ('flt', ('f2f32', 'b@16'), ('f2f32', 'a@16')) => ('flt', ('f2f16', 'b'), 'a')
 *    ('feq', ('f2f64', 'a@16'), ('f2f64', 'b@16')) => ('feq', 'a', ('f2f16', 'b'))
 *    ('fneu', ('f2f64', 'a@16'), ('f2f64', 'b@16')) => ('fneu', 'a', ('f2f16', 'b'))
 *    ('fge', ('f2f64', 'a@16'), ('f2f64', 'b@16')) => ('fge', 'a', ('f2f16', 'b'))
 *    ('flt', ('f2f64', 'a@16'), ('f2f64', 'b@16')) => ('flt', 'a', ('f2f16', 'b'))
 *    ('fge', ('f2f64', 'b@16'), ('f2f64', 'a@16')) => ('fge', ('f2f16', 'b'), 'a')
 *    ('flt', ('f2f64', 'b@16'), ('f2f64', 'a@16')) => ('flt', ('f2f16', 'b'), 'a')
 *    ('feq', ('f2f64', 'a@32'), ('f2f64', 'b@16')) => ('feq', 'a', ('f2f32', 'b'))
 *    ('fneu', ('f2f64', 'a@32'), ('f2f64', 'b@16')) => ('fneu', 'a', ('f2f32', 'b'))
 *    ('fge', ('f2f64', 'a@32'), ('f2f64', 'b@16')) => ('fge', 'a', ('f2f32', 'b'))
 *    ('flt', ('f2f64', 'a@32'), ('f2f64', 'b@16')) => ('flt', 'a', ('f2f32', 'b'))
 *    ('fge', ('f2f64', 'b@16'), ('f2f64', 'a@32')) => ('fge', ('f2f32', 'b'), 'a')
 *    ('flt', ('f2f64', 'b@16'), ('f2f64', 'a@32')) => ('flt', ('f2f32', 'b'), 'a')
 *    ('feq', ('f2f64', 'a@32'), ('f2f64', 'b@32')) => ('feq', 'a', ('f2f32', 'b'))
 *    ('fneu', ('f2f64', 'a@32'), ('f2f64', 'b@32')) => ('fneu', 'a', ('f2f32', 'b'))
 *    ('fge', ('f2f64', 'a@32'), ('f2f64', 'b@32')) => ('fge', 'a', ('f2f32', 'b'))
 *    ('flt', ('f2f64', 'a@32'), ('f2f64', 'b@32')) => ('flt', 'a', ('f2f32', 'b'))
 *    ('fge', ('f2f64', 'b@32'), ('f2f64', 'a@32')) => ('fge', ('f2f32', 'b'), 'a')
 *    ('flt', ('f2f64', 'b@32'), ('f2f64', 'a@32')) => ('flt', ('f2f32', 'b'), 'a')
 *    ('i2i32', ('iand', 'a@64', 4294967295)) => ('u2u32', 'a')
 *    ('i2i16', ('iand', 'a@32', 65535)) => ('u2u16', 'a')
 *    ('i2i16', ('iand', 'a@64', 65535)) => ('u2u16', 'a')
 *    ('i2i8', ('iand', 'a@16', 255)) => ('u2u8', 'a')
 *    ('i2i8', ('iand', 'a@32', 255)) => ('u2u8', 'a')
 *    ('i2i8', ('iand', 'a@64', 255)) => ('u2u8', 'a')
 *    ('u2u16(only_lower_8_bits_used)', ('u2u8', 'a@16')) => a
 *    ('extract_u8(only_lower_8_bits_used)', 'a@16', 0) => a
 *    ('bcsel(only_lower_8_bits_used)', 'c', ('u2u16', ('u2u8', 'a@16')), 'b') => ('bcsel', 'c', 'a', 'b')
 *    ('bcsel(only_lower_8_bits_used)', 'c', ('u2u16', ('i2i8', 'a@16')), 'b') => ('bcsel', 'c', 'a', 'b')
 *    ('bcsel(only_lower_8_bits_used)', 'c', ('extract_u8', 'a@16', 0), 'b') => ('bcsel', 'c', 'a', 'b')
 *    ('iadd(only_lower_8_bits_used)', ('u2u16', ('u2u8', 'a@16')), 'b') => ('iadd', 'a', 'b')
 *    ('iadd(only_lower_8_bits_used)', ('u2u16', ('i2i8', 'a@16')), 'b') => ('iadd', 'a', 'b')
 *    ('iadd(only_lower_8_bits_used)', ('extract_u8', 'a@16', 0), 'b') => ('iadd', 'a', 'b')
 *    ('imul(only_lower_8_bits_used)', ('u2u16', ('u2u8', 'a@16')), 'b') => ('imul', 'a', 'b')
 *    ('imul(only_lower_8_bits_used)', ('u2u16', ('i2i8', 'a@16')), 'b') => ('imul', 'a', 'b')
 *    ('imul(only_lower_8_bits_used)', ('extract_u8', 'a@16', 0), 'b') => ('imul', 'a', 'b')
 *    ('iand(only_lower_8_bits_used)', ('u2u16', ('u2u8', 'a@16')), 'b') => ('iand', 'a', 'b')
 *    ('iand(only_lower_8_bits_used)', ('u2u16', ('i2i8', 'a@16')), 'b') => ('iand', 'a', 'b')
 *    ('iand(only_lower_8_bits_used)', ('extract_u8', 'a@16', 0), 'b') => ('iand', 'a', 'b')
 *    ('ior(only_lower_8_bits_used)', ('u2u16', ('u2u8', 'a@16')), 'b') => ('ior', 'a', 'b')
 *    ('ior(only_lower_8_bits_used)', ('u2u16', ('i2i8', 'a@16')), 'b') => ('ior', 'a', 'b')
 *    ('ior(only_lower_8_bits_used)', ('extract_u8', 'a@16', 0), 'b') => ('ior', 'a', 'b')
 *    ('ixor(only_lower_8_bits_used)', ('u2u16', ('u2u8', 'a@16')), 'b') => ('ixor', 'a', 'b')
 *    ('ixor(only_lower_8_bits_used)', ('u2u16', ('i2i8', 'a@16')), 'b') => ('ixor', 'a', 'b')
 *    ('ixor(only_lower_8_bits_used)', ('extract_u8', 'a@16', 0), 'b') => ('ixor', 'a', 'b')
 *    ('i2i16(only_lower_8_bits_used)', ('u2u8', 'a@16')) => a
 *    ('extract_i8(only_lower_8_bits_used)', 'a@16', 0) => a
 *    ('bcsel(only_lower_8_bits_used)', 'c', ('i2i16', ('u2u8', 'a@16')), 'b') => ('bcsel', 'c', 'a', 'b')
 *    ('bcsel(only_lower_8_bits_used)', 'c', ('i2i16', ('i2i8', 'a@16')), 'b') => ('bcsel', 'c', 'a', 'b')
 *    ('bcsel(only_lower_8_bits_used)', 'c', ('extract_i8', 'a@16', 0), 'b') => ('bcsel', 'c', 'a', 'b')
 *    ('iadd(only_lower_8_bits_used)', ('i2i16', ('u2u8', 'a@16')), 'b') => ('iadd', 'a', 'b')
 *    ('iadd(only_lower_8_bits_used)', ('i2i16', ('i2i8', 'a@16')), 'b') => ('iadd', 'a', 'b')
 *    ('iadd(only_lower_8_bits_used)', ('extract_i8', 'a@16', 0), 'b') => ('iadd', 'a', 'b')
 *    ('imul(only_lower_8_bits_used)', ('i2i16', ('u2u8', 'a@16')), 'b') => ('imul', 'a', 'b')
 *    ('imul(only_lower_8_bits_used)', ('i2i16', ('i2i8', 'a@16')), 'b') => ('imul', 'a', 'b')
 *    ('imul(only_lower_8_bits_used)', ('extract_i8', 'a@16', 0), 'b') => ('imul', 'a', 'b')
 *    ('iand(only_lower_8_bits_used)', ('i2i16', ('u2u8', 'a@16')), 'b') => ('iand', 'a', 'b')
 *    ('iand(only_lower_8_bits_used)', ('i2i16', ('i2i8', 'a@16')), 'b') => ('iand', 'a', 'b')
 *    ('iand(only_lower_8_bits_used)', ('extract_i8', 'a@16', 0), 'b') => ('iand', 'a', 'b')
 *    ('ior(only_lower_8_bits_used)', ('i2i16', ('u2u8', 'a@16')), 'b') => ('ior', 'a', 'b')
 *    ('ior(only_lower_8_bits_used)', ('i2i16', ('i2i8', 'a@16')), 'b') => ('ior', 'a', 'b')
 *    ('ior(only_lower_8_bits_used)', ('extract_i8', 'a@16', 0), 'b') => ('ior', 'a', 'b')
 *    ('ixor(only_lower_8_bits_used)', ('i2i16', ('u2u8', 'a@16')), 'b') => ('ixor', 'a', 'b')
 *    ('ixor(only_lower_8_bits_used)', ('i2i16', ('i2i8', 'a@16')), 'b') => ('ixor', 'a', 'b')
 *    ('ixor(only_lower_8_bits_used)', ('extract_i8', 'a@16', 0), 'b') => ('ixor', 'a', 'b')
 *    ('u2u32(only_lower_8_bits_used)', ('u2u8', 'a@32')) => a
 *    ('extract_u8(only_lower_8_bits_used)', 'a@32', 0) => a
 *    ('bcsel(only_lower_8_bits_used)', 'c', ('u2u32', ('u2u8', 'a@32')), 'b') => ('bcsel', 'c', 'a', 'b')
 *    ('bcsel(only_lower_8_bits_used)', 'c', ('u2u32', ('i2i8', 'a@32')), 'b') => ('bcsel', 'c', 'a', 'b')
 *    ('bcsel(only_lower_8_bits_used)', 'c', ('extract_u8', 'a@32', 0), 'b') => ('bcsel', 'c', 'a', 'b')
 *    ('iadd(only_lower_8_bits_used)', ('u2u32', ('u2u8', 'a@32')), 'b') => ('iadd', 'a', 'b')
 *    ('iadd(only_lower_8_bits_used)', ('u2u32', ('i2i8', 'a@32')), 'b') => ('iadd', 'a', 'b')
 *    ('iadd(only_lower_8_bits_used)', ('extract_u8', 'a@32', 0), 'b') => ('iadd', 'a', 'b')
 *    ('imul(only_lower_8_bits_used)', ('u2u32', ('u2u8', 'a@32')), 'b') => ('imul', 'a', 'b')
 *    ('imul(only_lower_8_bits_used)', ('u2u32', ('i2i8', 'a@32')), 'b') => ('imul', 'a', 'b')
 *    ('imul(only_lower_8_bits_used)', ('extract_u8', 'a@32', 0), 'b') => ('imul', 'a', 'b')
 *    ('iand(only_lower_8_bits_used)', ('u2u32', ('u2u8', 'a@32')), 'b') => ('iand', 'a', 'b')
 *    ('iand(only_lower_8_bits_used)', ('u2u32', ('i2i8', 'a@32')), 'b') => ('iand', 'a', 'b')
 *    ('iand(only_lower_8_bits_used)', ('extract_u8', 'a@32', 0), 'b') => ('iand', 'a', 'b')
 *    ('ior(only_lower_8_bits_used)', ('u2u32', ('u2u8', 'a@32')), 'b') => ('ior', 'a', 'b')
 *    ('ior(only_lower_8_bits_used)', ('u2u32', ('i2i8', 'a@32')), 'b') => ('ior', 'a', 'b')
 *    ('ior(only_lower_8_bits_used)', ('extract_u8', 'a@32', 0), 'b') => ('ior', 'a', 'b')
 *    ('ixor(only_lower_8_bits_used)', ('u2u32', ('u2u8', 'a@32')), 'b') => ('ixor', 'a', 'b')
 *    ('ixor(only_lower_8_bits_used)', ('u2u32', ('i2i8', 'a@32')), 'b') => ('ixor', 'a', 'b')
 *    ('ixor(only_lower_8_bits_used)', ('extract_u8', 'a@32', 0), 'b') => ('ixor', 'a', 'b')
 *    ('i2i32(only_lower_8_bits_used)', ('u2u8', 'a@32')) => a
 *    ('extract_i8(only_lower_8_bits_used)', 'a@32', 0) => a
 *    ('bcsel(only_lower_8_bits_used)', 'c', ('i2i32', ('u2u8', 'a@32')), 'b') => ('bcsel', 'c', 'a', 'b')
 *    ('bcsel(only_lower_8_bits_used)', 'c', ('i2i32', ('i2i8', 'a@32')), 'b') => ('bcsel', 'c', 'a', 'b')
 *    ('bcsel(only_lower_8_bits_used)', 'c', ('extract_i8', 'a@32', 0), 'b') => ('bcsel', 'c', 'a', 'b')
 *    ('iadd(only_lower_8_bits_used)', ('i2i32', ('u2u8', 'a@32')), 'b') => ('iadd', 'a', 'b')
 *    ('iadd(only_lower_8_bits_used)', ('i2i32', ('i2i8', 'a@32')), 'b') => ('iadd', 'a', 'b')
 *    ('iadd(only_lower_8_bits_used)', ('extract_i8', 'a@32', 0), 'b') => ('iadd', 'a', 'b')
 *    ('imul(only_lower_8_bits_used)', ('i2i32', ('u2u8', 'a@32')), 'b') => ('imul', 'a', 'b')
 *    ('imul(only_lower_8_bits_used)', ('i2i32', ('i2i8', 'a@32')), 'b') => ('imul', 'a', 'b')
 *    ('imul(only_lower_8_bits_used)', ('extract_i8', 'a@32', 0), 'b') => ('imul', 'a', 'b')
 *    ('iand(only_lower_8_bits_used)', ('i2i32', ('u2u8', 'a@32')), 'b') => ('iand', 'a', 'b')
 *    ('iand(only_lower_8_bits_used)', ('i2i32', ('i2i8', 'a@32')), 'b') => ('iand', 'a', 'b')
 *    ('iand(only_lower_8_bits_used)', ('extract_i8', 'a@32', 0), 'b') => ('iand', 'a', 'b')
 *    ('ior(only_lower_8_bits_used)', ('i2i32', ('u2u8', 'a@32')), 'b') => ('ior', 'a', 'b')
 *    ('ior(only_lower_8_bits_used)', ('i2i32', ('i2i8', 'a@32')), 'b') => ('ior', 'a', 'b')
 *    ('ior(only_lower_8_bits_used)', ('extract_i8', 'a@32', 0), 'b') => ('ior', 'a', 'b')
 *    ('ixor(only_lower_8_bits_used)', ('i2i32', ('u2u8', 'a@32')), 'b') => ('ixor', 'a', 'b')
 *    ('ixor(only_lower_8_bits_used)', ('i2i32', ('i2i8', 'a@32')), 'b') => ('ixor', 'a', 'b')
 *    ('ixor(only_lower_8_bits_used)', ('extract_i8', 'a@32', 0), 'b') => ('ixor', 'a', 'b')
 *    ('u2u32(only_lower_16_bits_used)', ('u2u16', 'a@32')) => a
 *    ('extract_u16(only_lower_16_bits_used)', 'a@32', 0) => a
 *    ('bcsel(only_lower_16_bits_used)', 'c', ('u2u32', ('u2u16', 'a@32')), 'b') => ('bcsel', 'c', 'a', 'b')
 *    ('bcsel(only_lower_16_bits_used)', 'c', ('u2u32', ('i2i16', 'a@32')), 'b') => ('bcsel', 'c', 'a', 'b')
 *    ('bcsel(only_lower_16_bits_used)', 'c', ('extract_u16', 'a@32', 0), 'b') => ('bcsel', 'c', 'a', 'b')
 *    ('iadd(only_lower_16_bits_used)', ('u2u32', ('u2u16', 'a@32')), 'b') => ('iadd', 'a', 'b')
 *    ('iadd(only_lower_16_bits_used)', ('u2u32', ('i2i16', 'a@32')), 'b') => ('iadd', 'a', 'b')
 *    ('iadd(only_lower_16_bits_used)', ('extract_u16', 'a@32', 0), 'b') => ('iadd', 'a', 'b')
 *    ('imul(only_lower_16_bits_used)', ('u2u32', ('u2u16', 'a@32')), 'b') => ('imul', 'a', 'b')
 *    ('imul(only_lower_16_bits_used)', ('u2u32', ('i2i16', 'a@32')), 'b') => ('imul', 'a', 'b')
 *    ('imul(only_lower_16_bits_used)', ('extract_u16', 'a@32', 0), 'b') => ('imul', 'a', 'b')
 *    ('iand(only_lower_16_bits_used)', ('u2u32', ('u2u16', 'a@32')), 'b') => ('iand', 'a', 'b')
 *    ('iand(only_lower_16_bits_used)', ('u2u32', ('i2i16', 'a@32')), 'b') => ('iand', 'a', 'b')
 *    ('iand(only_lower_16_bits_used)', ('extract_u16', 'a@32', 0), 'b') => ('iand', 'a', 'b')
 *    ('ior(only_lower_16_bits_used)', ('u2u32', ('u2u16', 'a@32')), 'b') => ('ior', 'a', 'b')
 *    ('ior(only_lower_16_bits_used)', ('u2u32', ('i2i16', 'a@32')), 'b') => ('ior', 'a', 'b')
 *    ('ior(only_lower_16_bits_used)', ('extract_u16', 'a@32', 0), 'b') => ('ior', 'a', 'b')
 *    ('ixor(only_lower_16_bits_used)', ('u2u32', ('u2u16', 'a@32')), 'b') => ('ixor', 'a', 'b')
 *    ('ixor(only_lower_16_bits_used)', ('u2u32', ('i2i16', 'a@32')), 'b') => ('ixor', 'a', 'b')
 *    ('ixor(only_lower_16_bits_used)', ('extract_u16', 'a@32', 0), 'b') => ('ixor', 'a', 'b')
 *    ('i2i32(only_lower_16_bits_used)', ('u2u16', 'a@32')) => a
 *    ('extract_i16(only_lower_16_bits_used)', 'a@32', 0) => a
 *    ('bcsel(only_lower_16_bits_used)', 'c', ('i2i32', ('u2u16', 'a@32')), 'b') => ('bcsel', 'c', 'a', 'b')
 *    ('bcsel(only_lower_16_bits_used)', 'c', ('i2i32', ('i2i16', 'a@32')), 'b') => ('bcsel', 'c', 'a', 'b')
 *    ('bcsel(only_lower_16_bits_used)', 'c', ('extract_i16', 'a@32', 0), 'b') => ('bcsel', 'c', 'a', 'b')
 *    ('iadd(only_lower_16_bits_used)', ('i2i32', ('u2u16', 'a@32')), 'b') => ('iadd', 'a', 'b')
 *    ('iadd(only_lower_16_bits_used)', ('i2i32', ('i2i16', 'a@32')), 'b') => ('iadd', 'a', 'b')
 *    ('iadd(only_lower_16_bits_used)', ('extract_i16', 'a@32', 0), 'b') => ('iadd', 'a', 'b')
 *    ('imul(only_lower_16_bits_used)', ('i2i32', ('u2u16', 'a@32')), 'b') => ('imul', 'a', 'b')
 *    ('imul(only_lower_16_bits_used)', ('i2i32', ('i2i16', 'a@32')), 'b') => ('imul', 'a', 'b')
 *    ('imul(only_lower_16_bits_used)', ('extract_i16', 'a@32', 0), 'b') => ('imul', 'a', 'b')
 *    ('iand(only_lower_16_bits_used)', ('i2i32', ('u2u16', 'a@32')), 'b') => ('iand', 'a', 'b')
 *    ('iand(only_lower_16_bits_used)', ('i2i32', ('i2i16', 'a@32')), 'b') => ('iand', 'a', 'b')
 *    ('iand(only_lower_16_bits_used)', ('extract_i16', 'a@32', 0), 'b') => ('iand', 'a', 'b')
 *    ('ior(only_lower_16_bits_used)', ('i2i32', ('u2u16', 'a@32')), 'b') => ('ior', 'a', 'b')
 *    ('ior(only_lower_16_bits_used)', ('i2i32', ('i2i16', 'a@32')), 'b') => ('ior', 'a', 'b')
 *    ('ior(only_lower_16_bits_used)', ('extract_i16', 'a@32', 0), 'b') => ('ior', 'a', 'b')
 *    ('ixor(only_lower_16_bits_used)', ('i2i32', ('u2u16', 'a@32')), 'b') => ('ixor', 'a', 'b')
 *    ('ixor(only_lower_16_bits_used)', ('i2i32', ('i2i16', 'a@32')), 'b') => ('ixor', 'a', 'b')
 *    ('ixor(only_lower_16_bits_used)', ('extract_i16', 'a@32', 0), 'b') => ('ixor', 'a', 'b')
 *    ('ldexp@16', 'x', 'exp') => ('fmul', ('fmul', 'x', ('i2i16', ('ishl', ('iadd', ('ishr', ('imin', ('imax', 'exp', -30), 30), 1), 15), 10))), ('i2i16', ('ishl', ('iadd', ('isub', ('imin', ('imax', 'exp', -30), 30), ('ishr', ('imin', ('imax', 'exp', -30), 30), 1)), 15), 10)))
 *    ('ldexp@32', 'x', 'exp') => ('fmul', ('fmul', 'x', ('ishl', ('iadd', ('ishr', ('imin', ('imax', 'exp', -254), 254), 1), 127), 23)), ('ishl', ('iadd', ('isub', ('imin', ('imax', 'exp', -254), 254), ('ishr', ('imin', ('imax', 'exp', -254), 254), 1)), 127), 23))
 *    ('ldexp@64', 'x', 'exp') => ('fmul', ('fmul', 'x', ('pack_64_2x32_split', 0, ('ishl', ('iadd', ('ishr', ('imin', ('imax', 'exp', -2046), 2046), 1), 1023), 20))), ('pack_64_2x32_split', 0, ('ishl', ('iadd', ('isub', ('imin', ('imax', 'exp', -2046), 2046), ('ishr', ('imin', ('imax', 'exp', -2046), 2046), 1)), 1023), 20)))
 *    ('ior(many-comm-expr)', ('ishl', ('iand', ('ior', ('ishl', ('iand', ('ior', ('ishl', ('iand', ('ior', ('ishl', ('iand', ('ior', ('ishl', 'x@32', 16), ('ushr', 'x@32', 16)), 16711935), 8), ('ushr', ('iand', ('ior', ('ishl', 'x@32', 16), ('ushr', 'x@32', 16)), 4278255360), 8)), 252645135), 4), ('ushr', ('iand', ('ior', ('ishl', ('iand', ('ior', ('ishl', 'x@32', 16), ('ushr', 'x@32', 16)), 16711935), 8), ('ushr', ('iand', ('ior', ('ishl', 'x@32', 16), ('ushr', 'x@32', 16)), 4278255360), 8)), 4042322160), 4)), 858993459), 2), ('ushr', ('iand', ('ior', ('ishl', ('iand', ('ior', ('ishl', ('iand', ('ior', ('ishl', 'x@32', 16), ('ushr', 'x@32', 16)), 16711935), 8), ('ushr', ('iand', ('ior', ('ishl', 'x@32', 16), ('ushr', 'x@32', 16)), 4278255360), 8)), 252645135), 4), ('ushr', ('iand', ('ior', ('ishl', ('iand', ('ior', ('ishl', 'x@32', 16), ('ushr', 'x@32', 16)), 16711935), 8), ('ushr', ('iand', ('ior', ('ishl', 'x@32', 16), ('ushr', 'x@32', 16)), 4278255360), 8)), 4042322160), 4)), 3435973836), 2)), 1431655765), 1), ('ushr', ('iand', ('ior', ('ishl', ('iand', ('ior', ('ishl', ('iand', ('ior', ('ishl', ('iand', ('ior', ('ishl', 'x@32', 16), ('ushr', 'x@32', 16)), 16711935), 8), ('ushr', ('iand', ('ior', ('ishl', 'x@32', 16), ('ushr', 'x@32', 16)), 4278255360), 8)), 252645135), 4), ('ushr', ('iand', ('ior', ('ishl', ('iand', ('ior', ('ishl', 'x@32', 16), ('ushr', 'x@32', 16)), 16711935), 8), ('ushr', ('iand', ('ior', ('ishl', 'x@32', 16), ('ushr', 'x@32', 16)), 4278255360), 8)), 4042322160), 4)), 858993459), 2), ('ushr', ('iand', ('ior', ('ishl', ('iand', ('ior', ('ishl', ('iand', ('ior', ('ishl', 'x@32', 16), ('ushr', 'x@32', 16)), 16711935), 8), ('ushr', ('iand', ('ior', ('ishl', 'x@32', 16), ('ushr', 'x@32', 16)), 4278255360), 8)), 252645135), 4), ('ushr', ('iand', ('ior', ('ishl', ('iand', ('ior', ('ishl', 'x@32', 16), ('ushr', 'x@32', 16)), 16711935), 8), ('ushr', ('iand', ('ior', ('ishl', 'x@32', 16), ('ushr', 'x@32', 16)), 4278255360), 8)), 4042322160), 4)), 3435973836), 2)), 2863311530), 1)) => ('bitfield_reverse', 'x')
 *    ('ior(many-comm-expr)', ('iand', ('ishl', ('ior', ('iand', ('ishl', ('ior', ('iand', ('ishl', ('ior', ('iand', ('ishl', ('ior', ('ishl', 'x@32', 16), ('ushr', 'x@32', 16)), 1), 2863311530), ('iand', ('ushr', ('ior', ('ishl', 'x@32', 16), ('ushr', 'x@32', 16)), 1), 1431655765)), 2), 3435973836), ('iand', ('ushr', ('ior', ('iand', ('ishl', ('ior', ('ishl', 'x@32', 16), ('ushr', 'x@32', 16)), 1), 2863311530), ('iand', ('ushr', ('ior', ('ishl', 'x@32', 16), ('ushr', 'x@32', 16)), 1), 1431655765)), 2), 858993459)), 4), 4042322160), ('iand', ('ushr', ('ior', ('iand', ('ishl', ('ior', ('iand', ('ishl', ('ior', ('ishl', 'x@32', 16), ('ushr', 'x@32', 16)), 1), 2863311530), ('iand', ('ushr', ('ior', ('ishl', 'x@32', 16), ('ushr', 'x@32', 16)), 1), 1431655765)), 2), 3435973836), ('iand', ('ushr', ('ior', ('iand', ('ishl', ('ior', ('ishl', 'x@32', 16), ('ushr', 'x@32', 16)), 1), 2863311530), ('iand', ('ushr', ('ior', ('ishl', 'x@32', 16), ('ushr', 'x@32', 16)), 1), 1431655765)), 2), 858993459)), 4), 252645135)), 8), 4278255360), ('iand', ('ushr', ('ior', ('iand', ('ishl', ('ior', ('iand', ('ishl', ('ior', ('iand', ('ishl', ('ior', ('ishl', 'x@32', 16), ('ushr', 'x@32', 16)), 1), 2863311530), ('iand', ('ushr', ('ior', ('ishl', 'x@32', 16), ('ushr', 'x@32', 16)), 1), 1431655765)), 2), 3435973836), ('iand', ('ushr', ('ior', ('iand', ('ishl', ('ior', ('ishl', 'x@32', 16), ('ushr', 'x@32', 16)), 1), 2863311530), ('iand', ('ushr', ('ior', ('ishl', 'x@32', 16), ('ushr', 'x@32', 16)), 1), 1431655765)), 2), 858993459)), 4), 4042322160), ('iand', ('ushr', ('ior', ('iand', ('ishl', ('ior', ('iand', ('ishl', ('ior', ('ishl', 'x@32', 16), ('ushr', 'x@32', 16)), 1), 2863311530), ('iand', ('ushr', ('ior', ('ishl', 'x@32', 16), ('ushr', 'x@32', 16)), 1), 1431655765)), 2), 3435973836), ('iand', ('ushr', ('ior', ('iand', ('ishl', ('ior', ('ishl', 'x@32', 16), ('ushr', 'x@32', 16)), 1), 2863311530), ('iand', ('ushr', ('ior', ('ishl', 'x@32', 16), ('ushr', 'x@32', 16)), 1), 1431655765)), 2), 858993459)), 4), 252645135)), 8), 16711935)) => ('bitfield_reverse', 'x')
 *    ('bcsel', ('iand', ('ine', ('fabs', 'x'), 2139095040), ('ieq', ('iand', ('pack_half_2x16_rtz_split', 'x', 0), 32767), 31744)), ('iadd', ('pack_half_2x16_rtz_split', 'x', 0), 4294967295), ('pack_half_2x16_rtz_split', 'x', 0)) => ('pack_half_2x16_rtz_split', 'x', 0)
 *    ('bcsel', ('iand', ('ine', 'x', 2139095040), ('ieq', ('iand', ('pack_half_2x16_rtz_split', 'x(is_not_negative)', 0), 32767), 31744)), ('iadd', ('pack_half_2x16_rtz_split', 'x(is_not_negative)', 0), 4294967295), ('pack_half_2x16_rtz_split', 'x(is_not_negative)', 0)) => ('pack_half_2x16_rtz_split', 'x', 0)
 *    ('bcsel', ('iand', ('ine', ('fabs', 'x'), 2139095040), ('ieq', ('iand', ('pack_half_2x16_rtz_split', ('fneg', 'x'), 0), 32767), 31744)), ('iadd', ('pack_half_2x16_rtz_split', ('fneg', 'x'), 0), 4294967295), ('pack_half_2x16_rtz_split', ('fneg', 'x'), 0)) => ('pack_half_2x16_rtz_split', ('fneg', 'x'), 0)
 *    ('iadd(many-comm-expr)', ('iadd', ('iadd', ('bcsel', ('ieq', ('extract_u8', 'a@32', 0), 0), 0, ('iabs', ('iadd', ('extract_u8', 'a@32', 0), ('ineg', ('extract_u8', 'b@32', 0))))), ('bcsel', ('ieq', ('extract_u8', 'a@32', 1), 0), 0, ('iabs', ('iadd', ('extract_u8', 'a@32', 1), ('ineg', ('extract_u8', 'b@32', 1)))))), ('bcsel', ('ieq', ('extract_u8', 'a@32', 2), 0), 0, ('iabs', ('iadd', ('extract_u8', 'a@32', 2), ('ineg', ('extract_u8', 'b@32', 2)))))), ('bcsel', ('ieq', ('extract_u8', 'a@32', 3), 0), 0, ('iabs', ('iadd', ('extract_u8', 'a@32', 3), ('ineg', ('extract_u8', 'b@32', 3)))))) => ('msad_4x8', 'a', 'b', 0)
 *    ('iadd', ('msad_4x8', 'a', 'b', 0), 'c') => ('msad_4x8', 'a', 'b', 'c')
 *    ('ball_iequal2', ('ieq', 'a', 'b'), -1) => ('ball_iequal2', 'a', 'b')
 *    ('ball_iequal2', ('feq', 'a', 'b'), -1) => ('ball_fequal2', 'a', 'b')
 *    ('bany_inequal2', ('ine', 'a', 'b'), 0) => ('bany_inequal2', 'a', 'b')
 *    ('bany_inequal2', ('fneu', 'a', 'b'), 0) => ('bany_fnequal2', 'a', 'b')
 *    ('ball_iequal3', ('ieq', 'a', 'b'), -1) => ('ball_iequal3', 'a', 'b')
 *    ('ball_iequal3', ('feq', 'a', 'b'), -1) => ('ball_fequal3', 'a', 'b')
 *    ('bany_inequal3', ('ine', 'a', 'b'), 0) => ('bany_inequal3', 'a', 'b')
 *    ('bany_inequal3', ('fneu', 'a', 'b'), 0) => ('bany_fnequal3', 'a', 'b')
 *    ('ball_iequal4', ('ieq', 'a', 'b'), -1) => ('ball_iequal4', 'a', 'b')
 *    ('ball_iequal4', ('feq', 'a', 'b'), -1) => ('ball_fequal4', 'a', 'b')
 *    ('bany_inequal4', ('ine', 'a', 'b'), 0) => ('bany_inequal4', 'a', 'b')
 *    ('bany_inequal4', ('fneu', 'a', 'b'), 0) => ('bany_fnequal4', 'a', 'b')
 *    ('ball_iequal8', ('ieq', 'a', 'b'), -1) => ('ball_iequal8', 'a', 'b')
 *    ('ball_iequal8', ('feq', 'a', 'b'), -1) => ('ball_fequal8', 'a', 'b')
 *    ('bany_inequal8', ('ine', 'a', 'b'), 0) => ('bany_inequal8', 'a', 'b')
 *    ('bany_inequal8', ('fneu', 'a', 'b'), 0) => ('bany_fnequal8', 'a', 'b')
 *    ('ball_iequal16', ('ieq', 'a', 'b'), -1) => ('ball_iequal16', 'a', 'b')
 *    ('ball_iequal16', ('feq', 'a', 'b'), -1) => ('ball_fequal16', 'a', 'b')
 *    ('bany_inequal16', ('ine', 'a', 'b'), 0) => ('bany_inequal16', 'a', 'b')
 *    ('bany_inequal16', ('fneu', 'a', 'b'), 0) => ('bany_fnequal16', 'a', 'b')
 *    ('iand', ('feq', 'a', 'a'), ('flt', 'a', 'b')) => ('!flt', 'a', 'b')
 *    ('iand', ('feq', 'a', 'a'), ('flt', 'b', 'a')) => ('!flt', 'b', 'a')
 *    ('iand', ('feq', 'a', 'a'), ('fge', 'a', 'b')) => ('!fge', 'a', 'b')
 *    ('iand', ('feq', 'a', 'a'), ('fge', 'b', 'a')) => ('!fge', 'b', 'a')
 *    ('iand', ('feq', 'a', 'a'), ('feq', 'a', 'b')) => ('!feq', 'a', 'b')
 *    ('iand', ('feq', 'a', 'a'), ('feq', 'b', 'a')) => ('!feq', 'b', 'a')
 *    ('feq', ('bcsel', 'a', '#b', '#c'), '#d') => ('bcsel', 'a', ('feq', 'b', 'd'), ('feq', 'c', 'd'))
 *    ('fneu', ('bcsel', 'a', '#b', '#c'), '#d') => ('bcsel', 'a', ('fneu', 'b', 'd'), ('fneu', 'c', 'd'))
 *    ('ieq', ('bcsel', 'a', '#b', '#c'), '#d') => ('bcsel', 'a', ('ieq', 'b', 'd'), ('ieq', 'c', 'd'))
 *    ('ine', ('bcsel', 'a', '#b', '#c'), '#d') => ('bcsel', 'a', ('ine', 'b', 'd'), ('ine', 'c', 'd'))
 *    ('flt', ('bcsel', 'a', '#b', '#c'), '#d') => ('bcsel', 'a', ('flt', 'b', 'd'), ('flt', 'c', 'd'))
 *    ('flt', '#d', ('bcsel', 'a', '#b', '#c')) => ('bcsel', 'a', ('flt', 'd', 'b'), ('flt', 'd', 'c'))
 *    ('fge', ('bcsel', 'a', '#b', '#c'), '#d') => ('bcsel', 'a', ('fge', 'b', 'd'), ('fge', 'c', 'd'))
 *    ('fge', '#d', ('bcsel', 'a', '#b', '#c')) => ('bcsel', 'a', ('fge', 'd', 'b'), ('fge', 'd', 'c'))
 *    ('ilt', ('bcsel', 'a', '#b', '#c'), '#d') => ('bcsel', 'a', ('ilt', 'b', 'd'), ('ilt', 'c', 'd'))
 *    ('ilt', '#d', ('bcsel', 'a', '#b', '#c')) => ('bcsel', 'a', ('ilt', 'd', 'b'), ('ilt', 'd', 'c'))
 *    ('ige', ('bcsel', 'a', '#b', '#c'), '#d') => ('bcsel', 'a', ('ige', 'b', 'd'), ('ige', 'c', 'd'))
 *    ('ige', '#d', ('bcsel', 'a', '#b', '#c')) => ('bcsel', 'a', ('ige', 'd', 'b'), ('ige', 'd', 'c'))
 *    ('ult', ('bcsel', 'a', '#b', '#c'), '#d') => ('bcsel', 'a', ('ult', 'b', 'd'), ('ult', 'c', 'd'))
 *    ('ult', '#d', ('bcsel', 'a', '#b', '#c')) => ('bcsel', 'a', ('ult', 'd', 'b'), ('ult', 'd', 'c'))
 *    ('uge', ('bcsel', 'a', '#b', '#c'), '#d') => ('bcsel', 'a', ('uge', 'b', 'd'), ('uge', 'c', 'd'))
 *    ('uge', '#d', ('bcsel', 'a', '#b', '#c')) => ('bcsel', 'a', ('uge', 'd', 'b'), ('uge', 'd', 'c'))
 *    ('fadd', ('bcsel(is_used_once)', 'a', '#b', 'c'), '#d') => ('bcsel', 'a', ('fadd', 'b', 'd'), ('fadd', 'c', 'd'))
 *    ('fmul', ('bcsel(is_used_once)', 'a', '#b', 'c'), '#d') => ('bcsel', 'a', ('fmul', 'b', 'd'), ('fmul', 'c', 'd'))
 *    ('fmulz', ('bcsel(is_used_once)', 'a', '#b', 'c'), '#d') => ('bcsel', 'a', ('fmulz', 'b', 'd'), ('fmulz', 'c', 'd'))
 *    ('iadd', ('bcsel(is_used_once)', 'a', '#b', 'c'), '#d') => ('bcsel', 'a', ('iadd', 'b', 'd'), ('iadd', 'c', 'd'))
 *    ('imul', ('bcsel(is_used_once)', 'a', '#b', 'c'), '#d') => ('bcsel', 'a', ('imul', 'b', 'd'), ('imul', 'c', 'd'))
 *    ('fddx', 'a') => 0.0
 *    ('fddx_fine', 'a') => 0.0
 *    ('fddx_coarse', 'a') => 0.0
 *    ('fddy', 'a') => 0.0
 *    ('fddy_fine', 'a') => 0.0
 *    ('fddy_coarse', 'a') => 0.0
 *    ('umul_low', '#a(is_lower_half_zero)', 'b') => 0
 *    ('imadsh_mix16', '#a@32(is_lower_half_zero)', 'b@32', 'c@32') => c
 *    ('imadsh_mix16', 'a@32', '#b@32(is_upper_half_zero)', 'c@32') => c
 *    ('bcsel', 'a', ('flrp(is_used_once)', 'b', 'c', 'd'), ('flrp', 'b', 'c', 'e')) => ('flrp', 'b', 'c', ('bcsel', 'a', 'd', 'e'))
 *    ('bcsel', 'a', ('flrp', 'b', 'c', 'd'), ('flrp(is_used_once)', 'b', 'c', 'e')) => ('flrp', 'b', 'c', ('bcsel', 'a', 'd', 'e'))
 *    ('bcsel', 'a', ('flrp(is_used_once)', 'b', 'c', 'd'), ('flrp', 'b', 'e', 'd')) => ('flrp', 'b', ('bcsel', 'a', 'c', 'e'), 'd')
 *    ('bcsel', 'a', ('flrp', 'b', 'c', 'd'), ('flrp(is_used_once)', 'b', 'e', 'd')) => ('flrp', 'b', ('bcsel', 'a', 'c', 'e'), 'd')
 *    ('bcsel', 'a', ('flrp(is_used_once)', 'b', 'c', 'd'), ('flrp', 'e', 'c', 'd')) => ('flrp', ('bcsel', 'a', 'b', 'e'), 'c', 'd')
 *    ('bcsel', 'a', ('flrp', 'b', 'c', 'd'), ('flrp(is_used_once)', 'e', 'c', 'd')) => ('flrp', ('bcsel', 'a', 'b', 'e'), 'c', 'd')
 *    ('bcsel', 'a', ('fmulz(is_used_once)', 'b', 'c'), ('fmulz', 'b', 'd(is_not_const)')) => ('fmulz', 'b', ('bcsel', 'a', 'c', 'd'))
 *    ('bcsel', 'a', ('fmulz(is_used_once)', 'b', 'c(is_not_const)'), ('fmulz', 'b', 'd')) => ('fmulz', 'b', ('bcsel', 'a', 'c', 'd'))
 *    ('bcsel', 'a', ('fmulz', 'b', 'c(is_not_const)'), ('fmulz(is_used_once)', 'b', 'd')) => ('fmulz', 'b', ('bcsel', 'a', 'c', 'd'))
 *    ('bcsel', 'a', ('fmulz', 'b', 'c'), ('fmulz(is_used_once)', 'b', 'd(is_not_const)')) => ('fmulz', 'b', ('bcsel', 'a', 'c', 'd'))
 *    ('bcsel', 'a', ('fmul(is_used_once)', 'b', 'c'), ('fmul', 'b', 'd(is_not_const)')) => ('fmul', 'b', ('bcsel', 'a', 'c', 'd'))
 *    ('bcsel', 'a', ('fmul(is_used_once)', 'b', 'c(is_not_const)'), ('fmul', 'b', 'd')) => ('fmul', 'b', ('bcsel', 'a', 'c', 'd'))
 *    ('bcsel', 'a', ('fmul', 'b', 'c(is_not_const)'), ('fmul(is_used_once)', 'b', 'd')) => ('fmul', 'b', ('bcsel', 'a', 'c', 'd'))
 *    ('bcsel', 'a', ('fmul', 'b', 'c'), ('fmul(is_used_once)', 'b', 'd(is_not_const)')) => ('fmul', 'b', ('bcsel', 'a', 'c', 'd'))
 *    ('bcsel', 'a', ('iadd(is_used_once)', 'b', 'c'), ('iadd', 'b', 'd(is_not_const)')) => ('iadd', 'b', ('bcsel', 'a', 'c', 'd'))
 *    ('bcsel', 'a', ('iadd(is_used_once)', 'b', 'c(is_not_const)'), ('iadd', 'b', 'd')) => ('iadd', 'b', ('bcsel', 'a', 'c', 'd'))
 *    ('bcsel', 'a', ('iadd', 'b', 'c(is_not_const)'), ('iadd(is_used_once)', 'b', 'd')) => ('iadd', 'b', ('bcsel', 'a', 'c', 'd'))
 *    ('bcsel', 'a', ('iadd', 'b', 'c'), ('iadd(is_used_once)', 'b', 'd(is_not_const)')) => ('iadd', 'b', ('bcsel', 'a', 'c', 'd'))
 *    ('bcsel', 'a', ('imul(is_used_once)', 'b', 'c'), ('imul', 'b', 'd(is_not_const)')) => ('imul', 'b', ('bcsel', 'a', 'c', 'd'))
 *    ('bcsel', 'a', ('imul(is_used_once)', 'b', 'c(is_not_const)'), ('imul', 'b', 'd')) => ('imul', 'b', ('bcsel', 'a', 'c', 'd'))
 *    ('bcsel', 'a', ('imul', 'b', 'c(is_not_const)'), ('imul(is_used_once)', 'b', 'd')) => ('imul', 'b', ('bcsel', 'a', 'c', 'd'))
 *    ('bcsel', 'a', ('imul', 'b', 'c'), ('imul(is_used_once)', 'b', 'd(is_not_const)')) => ('imul', 'b', ('bcsel', 'a', 'c', 'd'))
 *    ('bcsel', 'a', ('iand(is_used_once)', 'b', 'c'), ('iand', 'b', 'd(is_not_const)')) => ('iand', 'b', ('bcsel', 'a', 'c', 'd'))
 *    ('bcsel', 'a', ('iand(is_used_once)', 'b', 'c(is_not_const)'), ('iand', 'b', 'd')) => ('iand', 'b', ('bcsel', 'a', 'c', 'd'))
 *    ('bcsel', 'a', ('iand', 'b', 'c(is_not_const)'), ('iand(is_used_once)', 'b', 'd')) => ('iand', 'b', ('bcsel', 'a', 'c', 'd'))
 *    ('bcsel', 'a', ('iand', 'b', 'c'), ('iand(is_used_once)', 'b', 'd(is_not_const)')) => ('iand', 'b', ('bcsel', 'a', 'c', 'd'))
 *    ('bcsel', 'a', ('ior(is_used_once)', 'b', 'c'), ('ior', 'b', 'd(is_not_const)')) => ('ior', 'b', ('bcsel', 'a', 'c', 'd'))
 *    ('bcsel', 'a', ('ior(is_used_once)', 'b', 'c(is_not_const)'), ('ior', 'b', 'd')) => ('ior', 'b', ('bcsel', 'a', 'c', 'd'))
 *    ('bcsel', 'a', ('ior', 'b', 'c(is_not_const)'), ('ior(is_used_once)', 'b', 'd')) => ('ior', 'b', ('bcsel', 'a', 'c', 'd'))
 *    ('bcsel', 'a', ('ior', 'b', 'c'), ('ior(is_used_once)', 'b', 'd(is_not_const)')) => ('ior', 'b', ('bcsel', 'a', 'c', 'd'))
 *    ('bcsel', 'a', ('ixor(is_used_once)', 'b', 'c'), ('ixor', 'b', 'd(is_not_const)')) => ('ixor', 'b', ('bcsel', 'a', 'c', 'd'))
 *    ('bcsel', 'a', ('ixor(is_used_once)', 'b', 'c(is_not_const)'), ('ixor', 'b', 'd')) => ('ixor', 'b', ('bcsel', 'a', 'c', 'd'))
 *    ('bcsel', 'a', ('ixor', 'b', 'c(is_not_const)'), ('ixor(is_used_once)', 'b', 'd')) => ('ixor', 'b', ('bcsel', 'a', 'c', 'd'))
 *    ('bcsel', 'a', ('ixor', 'b', 'c'), ('ixor(is_used_once)', 'b', 'd(is_not_const)')) => ('ixor', 'b', ('bcsel', 'a', 'c', 'd'))
 *    ('bcsel', 'a', ('fmin(is_used_once)', 'b', 'c'), ('fmin', 'b', 'd(is_not_const)')) => ('fmin', 'b', ('bcsel', 'a', 'c', 'd'))
 *    ('bcsel', 'a', ('fmin(is_used_once)', 'b', 'c(is_not_const)'), ('fmin', 'b', 'd')) => ('fmin', 'b', ('bcsel', 'a', 'c', 'd'))
 *    ('bcsel', 'a', ('fmin', 'b', 'c(is_not_const)'), ('fmin(is_used_once)', 'b', 'd')) => ('fmin', 'b', ('bcsel', 'a', 'c', 'd'))
 *    ('bcsel', 'a', ('fmin', 'b', 'c'), ('fmin(is_used_once)', 'b', 'd(is_not_const)')) => ('fmin', 'b', ('bcsel', 'a', 'c', 'd'))
 *    ('bcsel', 'a', ('fmax(is_used_once)', 'b', 'c'), ('fmax', 'b', 'd(is_not_const)')) => ('fmax', 'b', ('bcsel', 'a', 'c', 'd'))
 *    ('bcsel', 'a', ('fmax(is_used_once)', 'b', 'c(is_not_const)'), ('fmax', 'b', 'd')) => ('fmax', 'b', ('bcsel', 'a', 'c', 'd'))
 *    ('bcsel', 'a', ('fmax', 'b', 'c(is_not_const)'), ('fmax(is_used_once)', 'b', 'd')) => ('fmax', 'b', ('bcsel', 'a', 'c', 'd'))
 *    ('bcsel', 'a', ('fmax', 'b', 'c'), ('fmax(is_used_once)', 'b', 'd(is_not_const)')) => ('fmax', 'b', ('bcsel', 'a', 'c', 'd'))
 *    ('bcsel', 'a', ('imin(is_used_once)', 'b', 'c'), ('imin', 'b', 'd(is_not_const)')) => ('imin', 'b', ('bcsel', 'a', 'c', 'd'))
 *    ('bcsel', 'a', ('imin(is_used_once)', 'b', 'c(is_not_const)'), ('imin', 'b', 'd')) => ('imin', 'b', ('bcsel', 'a', 'c', 'd'))
 *    ('bcsel', 'a', ('imin', 'b', 'c(is_not_const)'), ('imin(is_used_once)', 'b', 'd')) => ('imin', 'b', ('bcsel', 'a', 'c', 'd'))
 *    ('bcsel', 'a', ('imin', 'b', 'c'), ('imin(is_used_once)', 'b', 'd(is_not_const)')) => ('imin', 'b', ('bcsel', 'a', 'c', 'd'))
 *    ('bcsel', 'a', ('imax(is_used_once)', 'b', 'c'), ('imax', 'b', 'd(is_not_const)')) => ('imax', 'b', ('bcsel', 'a', 'c', 'd'))
 *    ('bcsel', 'a', ('imax(is_used_once)', 'b', 'c(is_not_const)'), ('imax', 'b', 'd')) => ('imax', 'b', ('bcsel', 'a', 'c', 'd'))
 *    ('bcsel', 'a', ('imax', 'b', 'c(is_not_const)'), ('imax(is_used_once)', 'b', 'd')) => ('imax', 'b', ('bcsel', 'a', 'c', 'd'))
 *    ('bcsel', 'a', ('imax', 'b', 'c'), ('imax(is_used_once)', 'b', 'd(is_not_const)')) => ('imax', 'b', ('bcsel', 'a', 'c', 'd'))
 *    ('bcsel', 'a', ('umin(is_used_once)', 'b', 'c'), ('umin', 'b', 'd(is_not_const)')) => ('umin', 'b', ('bcsel', 'a', 'c', 'd'))
 *    ('bcsel', 'a', ('umin(is_used_once)', 'b', 'c(is_not_const)'), ('umin', 'b', 'd')) => ('umin', 'b', ('bcsel', 'a', 'c', 'd'))
 *    ('bcsel', 'a', ('umin', 'b', 'c(is_not_const)'), ('umin(is_used_once)', 'b', 'd')) => ('umin', 'b', ('bcsel', 'a', 'c', 'd'))
 *    ('bcsel', 'a', ('umin', 'b', 'c'), ('umin(is_used_once)', 'b', 'd(is_not_const)')) => ('umin', 'b', ('bcsel', 'a', 'c', 'd'))
 *    ('bcsel', 'a', ('umax(is_used_once)', 'b', 'c'), ('umax', 'b', 'd(is_not_const)')) => ('umax', 'b', ('bcsel', 'a', 'c', 'd'))
 *    ('bcsel', 'a', ('umax(is_used_once)', 'b', 'c(is_not_const)'), ('umax', 'b', 'd')) => ('umax', 'b', ('bcsel', 'a', 'c', 'd'))
 *    ('bcsel', 'a', ('umax', 'b', 'c(is_not_const)'), ('umax(is_used_once)', 'b', 'd')) => ('umax', 'b', ('bcsel', 'a', 'c', 'd'))
 *    ('bcsel', 'a', ('umax', 'b', 'c'), ('umax(is_used_once)', 'b', 'd(is_not_const)')) => ('umax', 'b', ('bcsel', 'a', 'c', 'd'))
 *    ('bcsel', 'a', ('fpow(is_used_once)', 'b', 'c'), ('fpow', 'b', 'd')) => ('fpow', 'b', ('bcsel', 'a', 'c', 'd'))
 *    ('bcsel', 'a', ('fpow', 'b', 'c'), ('fpow(is_used_once)', 'b', 'd')) => ('fpow', 'b', ('bcsel', 'a', 'c', 'd'))
 *    ('bcsel', 'a', ('fpow(is_used_once)', 'b', 'c'), ('fpow', 'd', 'c')) => ('fpow', ('bcsel', 'a', 'b', 'd'), 'c')
 *    ('bcsel', 'a', ('fpow', 'b', 'c'), ('fpow(is_used_once)', 'd', 'c')) => ('fpow', ('bcsel', 'a', 'b', 'd'), 'c')
 *    ('bcsel', 'c', ('frcp(is_used_once)', 'a'), ('frcp(is_used_once)', 'b')) => ('frcp', ('bcsel', 'c', 'a', 'b'))
 *    ('bcsel', 'c', ('frsq(is_used_once)', 'a'), ('frsq(is_used_once)', 'b')) => ('frsq', ('bcsel', 'c', 'a', 'b'))
 *    ('bcsel', 'c', ('fsqrt(is_used_once)', 'a'), ('fsqrt(is_used_once)', 'b')) => ('fsqrt', ('bcsel', 'c', 'a', 'b'))
 *    ('bcsel', 'c', ('fexp2(is_used_once)', 'a'), ('fexp2(is_used_once)', 'b')) => ('fexp2', ('bcsel', 'c', 'a', 'b'))
 *    ('bcsel', 'c', ('flog2(is_used_once)', 'a'), ('flog2(is_used_once)', 'b')) => ('flog2', ('bcsel', 'c', 'a', 'b'))
 *    ('bcsel', 'c', ('fsign(is_used_once)', 'a'), ('fsign(is_used_once)', 'b')) => ('fsign', ('bcsel', 'c', 'a', 'b'))
 *    ('bcsel', 'c', ('fsin(is_used_once)', 'a'), ('fsin(is_used_once)', 'b')) => ('fsin', ('bcsel', 'c', 'a', 'b'))
 *    ('bcsel', 'c', ('fcos(is_used_once)', 'a'), ('fcos(is_used_once)', 'b')) => ('fcos', ('bcsel', 'c', 'a', 'b'))
 *    ('bcsel', 'c', ('fsin_amd(is_used_once)', 'a'), ('fsin_amd(is_used_once)', 'b')) => ('fsin_amd', ('bcsel', 'c', 'a', 'b'))
 *    ('bcsel', 'c', ('fcos_amd(is_used_once)', 'a'), ('fcos_amd(is_used_once)', 'b')) => ('fcos_amd', ('bcsel', 'c', 'a', 'b'))
 *    ('bcsel', 'c', ('fsin_mdg(is_used_once)', 'a'), ('fsin_mdg(is_used_once)', 'b')) => ('fsin_mdg', ('bcsel', 'c', 'a', 'b'))
 *    ('bcsel', 'c', ('fcos_mdg(is_used_once)', 'a'), ('fcos_mdg(is_used_once)', 'b')) => ('fcos_mdg', ('bcsel', 'c', 'a', 'b'))
 *    ('bcsel', 'c', ('fsin_agx(is_used_once)', 'a'), ('fsin_agx(is_used_once)', 'b')) => ('fsin_agx', ('bcsel', 'c', 'a', 'b'))
 *    ('bcsel', 'c', ('fneg(is_used_once)', 'a'), ('fneg(is_used_once)', 'b')) => ('fneg', ('bcsel', 'c', 'a', 'b'))
 *    ('bcsel', 'c', ('fabs(is_used_once)', 'a'), ('fabs(is_used_once)', 'b')) => ('fabs', ('bcsel', 'c', 'a', 'b'))
 *    ('bcsel', 'c', ('fsign(is_used_once)', 'a'), ('fsign(is_used_once)', 'b')) => ('fsign', ('bcsel', 'c', 'a', 'b'))
 *    ('ineg', ('bcsel', 'c', '#a', '#b')) => ('bcsel', 'c', ('ineg', 'a'), ('ineg', 'b'))
 *    ('iabs', ('bcsel', 'c', '#a', '#b')) => ('bcsel', 'c', ('iabs', 'a'), ('iabs', 'b'))
 *    ('inot', ('bcsel', 'c', '#a', '#b')) => ('bcsel', 'c', ('inot', 'a'), ('inot', 'b'))
 *    ('isign', ('bcsel', 'c', '#a', '#b')) => ('bcsel', 'c', ('isign', 'a'), ('isign', 'b'))
 *    ('fisnormal', 'a@16') => ('ult', 4095, ('iadd', ('ishl', 'a', 1), 2048))
 *    ('fisnormal', 'a@32') => ('ult', 33554431, ('iadd', ('ishl', 'a', 1), 16777216))
 *    ('fisnormal', 'a@64') => ('ult', 18014398509481983, ('iadd', ('ishl', 'a', 1), 9007199254740992))
 *    ('fquantize2f16', 'a@32') => ('bcsel', ('!flt', ('!fabs', 'a'), 6.103515625e-05), ('iand', 'a', 2147483648), ('!f2f32', ('!f2f16_rtne', 'a')))
 *    ('bfi', 4294967295, 'a', '#b') => ('iadd', ('ishl', 'a', 0), ('iand', 'b', -4294967296))
 *    ('bfi', 8589934590, 'a', '#b') => ('iadd', ('ishl', 'a', 1), ('iand', 'b', -8589934591))
 *    ('bfi', 17179869180, 'a', '#b') => ('iadd', ('ishl', 'a', 2), ('iand', 'b', -17179869181))
 *    ('bfi', 34359738360, 'a', '#b') => ('iadd', ('ishl', 'a', 3), ('iand', 'b', -34359738361))
 *    ('bfi', 68719476720, 'a', '#b') => ('iadd', ('ishl', 'a', 4), ('iand', 'b', -68719476721))
 *    ('bfi', 137438953440, 'a', '#b') => ('iadd', ('ishl', 'a', 5), ('iand', 'b', -137438953441))
 *    ('bfi', 274877906880, 'a', '#b') => ('iadd', ('ishl', 'a', 6), ('iand', 'b', -274877906881))
 *    ('bfi', 549755813760, 'a', '#b') => ('iadd', ('ishl', 'a', 7), ('iand', 'b', -549755813761))
 *    ('bfi', 1099511627520, 'a', '#b') => ('iadd', ('ishl', 'a', 8), ('iand', 'b', -1099511627521))
 *    ('bfi', 2199023255040, 'a', '#b') => ('iadd', ('ishl', 'a', 9), ('iand', 'b', -2199023255041))
 *    ('bfi', 4398046510080, 'a', '#b') => ('iadd', ('ishl', 'a', 10), ('iand', 'b', -4398046510081))
 *    ('bfi', 8796093020160, 'a', '#b') => ('iadd', ('ishl', 'a', 11), ('iand', 'b', -8796093020161))
 *    ('bfi', 17592186040320, 'a', '#b') => ('iadd', ('ishl', 'a', 12), ('iand', 'b', -17592186040321))
 *    ('bfi', 35184372080640, 'a', '#b') => ('iadd', ('ishl', 'a', 13), ('iand', 'b', -35184372080641))
 *    ('bfi', 70368744161280, 'a', '#b') => ('iadd', ('ishl', 'a', 14), ('iand', 'b', -70368744161281))
 *    ('bfi', 140737488322560, 'a', '#b') => ('iadd', ('ishl', 'a', 15), ('iand', 'b', -140737488322561))
 *    ('bfi', 281474976645120, 'a', '#b') => ('iadd', ('ishl', 'a', 16), ('iand', 'b', -281474976645121))
 *    ('bfi', 562949953290240, 'a', '#b') => ('iadd', ('ishl', 'a', 17), ('iand', 'b', -562949953290241))
 *    ('bfi', 1125899906580480, 'a', '#b') => ('iadd', ('ishl', 'a', 18), ('iand', 'b', -1125899906580481))
 *    ('bfi', 2251799813160960, 'a', '#b') => ('iadd', ('ishl', 'a', 19), ('iand', 'b', -2251799813160961))
 *    ('bfi', 4503599626321920, 'a', '#b') => ('iadd', ('ishl', 'a', 20), ('iand', 'b', -4503599626321921))
 *    ('bfi', 9007199252643840, 'a', '#b') => ('iadd', ('ishl', 'a', 21), ('iand', 'b', -9007199252643841))
 *    ('bfi', 18014398505287680, 'a', '#b') => ('iadd', ('ishl', 'a', 22), ('iand', 'b', -18014398505287681))
 *    ('bfi', 36028797010575360, 'a', '#b') => ('iadd', ('ishl', 'a', 23), ('iand', 'b', -36028797010575361))
 *    ('bfi', 72057594021150720, 'a', '#b') => ('iadd', ('ishl', 'a', 24), ('iand', 'b', -72057594021150721))
 *    ('bfi', 144115188042301440, 'a', '#b') => ('iadd', ('ishl', 'a', 25), ('iand', 'b', -144115188042301441))
 *    ('bfi', 288230376084602880, 'a', '#b') => ('iadd', ('ishl', 'a', 26), ('iand', 'b', -288230376084602881))
 *    ('bfi', 576460752169205760, 'a', '#b') => ('iadd', ('ishl', 'a', 27), ('iand', 'b', -576460752169205761))
 *    ('bfi', 1152921504338411520, 'a', '#b') => ('iadd', ('ishl', 'a', 28), ('iand', 'b', -1152921504338411521))
 *    ('bfi', 2305843008676823040, 'a', '#b') => ('iadd', ('ishl', 'a', 29), ('iand', 'b', -2305843008676823041))
 *    ('bfi', 4611686017353646080, 'a', '#b') => ('iadd', ('ishl', 'a', 30), ('iand', 'b', -4611686017353646081))
 *    ('fadd', '#a(is_nan)', 'b') => nan
 *    ('fadd', 'a', '#b(is_nan)') => nan
 *    ('fdiv', '#a(is_nan)', 'b') => nan
 *    ('fdiv', 'a', '#b(is_nan)') => nan
 *    ('fmod', '#a(is_nan)', 'b') => nan
 *    ('fmod', 'a', '#b(is_nan)') => nan
 *    ('fmul', '#a(is_nan)', 'b') => nan
 *    ('fmul', 'a', '#b(is_nan)') => nan
 *    ('fpow', '#a(is_nan)', 'b') => nan
 *    ('fpow', 'a', '#b(is_nan)') => nan
 *    ('frem', '#a(is_nan)', 'b') => nan
 *    ('frem', 'a', '#b(is_nan)') => nan
 *    ('fsub', '#a(is_nan)', 'b') => nan
 *    ('fsub', 'a', '#b(is_nan)') => nan
 *    ('ffma', '#a(is_nan)', 'b', 'c') => nan
 *    ('ffma', 'a', '#b(is_nan)', 'c') => nan
 *    ('ffma', 'a', 'b', '#c(is_nan)') => nan
 *    ('flrp', '#a(is_nan)', 'b', 'c') => nan
 *    ('flrp', 'a', '#b(is_nan)', 'c') => nan
 *    ('flrp', 'a', 'b', '#c(is_nan)') => nan
 *    ('fmin', '#a(is_nan)', 'b') => b
 *    ('fmax', '#a(is_nan)', 'b') => b
 *    ('ldexp', '#a(is_nan)', 'b') => nan
 *    ('fdot2', '#a(is_any_comp_nan)', 'b') => nan
 *    ('fdot3', '#a(is_any_comp_nan)', 'b') => nan
 *    ('fdot4', '#a(is_any_comp_nan)', 'b') => nan
 *    ('fdot5', '#a(is_any_comp_nan)', 'b') => nan
 *    ('fdot8', '#a(is_any_comp_nan)', 'b') => nan
 *    ('fdot16', '#a(is_any_comp_nan)', 'b') => nan
 *    ('feq', '#a(is_nan)', 'b') => False
 *    ('feq', 'a', '#b(is_nan)') => False
 *    ('fge', '#a(is_nan)', 'b') => False
 *    ('fge', 'a', '#b(is_nan)') => False
 *    ('flt', '#a(is_nan)', 'b') => False
 *    ('flt', 'a', '#b(is_nan)') => False
 *    ('fneu', '#a(is_nan)', 'b') => True
 *    ('seq', '#a(is_nan)', 'b') => 0.0
 *    ('seq', 'a', '#b(is_nan)') => 0.0
 *    ('sge', '#a(is_nan)', 'b') => 0.0
 *    ('sge', 'a', '#b(is_nan)') => 0.0
 *    ('slt', '#a(is_nan)', 'b') => 0.0
 *    ('slt', 'a', '#b(is_nan)') => 0.0
 *    ('sne', '#a(is_nan)', 'b') => 1.0
 *    ('f2f16', ('vec2', 'a@32', 'b@32')) => ('vec2', ('f2f16', 'a'), ('f2f16', 'b'))
 *    ('f2fmp', ('vec2', 'a@32', 'b@32')) => ('vec2', ('f2fmp', 'a'), ('f2fmp', 'b'))
 *    ('u2u16', ('vec2', 'a@32', 'b@32')) => ('vec2', ('u2u16', 'a'), ('u2u16', 'b'))
 *    ('i2i16', ('vec2', 'a@32', 'b@32')) => ('vec2', ('i2i16', 'a'), ('i2i16', 'b'))
 *    ('i2imp', ('vec2', 'a@32', 'b@32')) => ('vec2', ('i2imp', 'a'), ('i2imp', 'b'))
 *    ('f2f16', ('vec3', 'a@32', 'b@32', 'c@32')) => ('vec3', ('f2f16', 'a'), ('f2f16', 'b'), ('f2f16', 'c'))
 *    ('f2fmp', ('vec3', 'a@32', 'b@32', 'c@32')) => ('vec3', ('f2fmp', 'a'), ('f2fmp', 'b'), ('f2fmp', 'c'))
 *    ('u2u16', ('vec3', 'a@32', 'b@32', 'c@32')) => ('vec3', ('u2u16', 'a'), ('u2u16', 'b'), ('u2u16', 'c'))
 *    ('i2i16', ('vec3', 'a@32', 'b@32', 'c@32')) => ('vec3', ('i2i16', 'a'), ('i2i16', 'b'), ('i2i16', 'c'))
 *    ('i2imp', ('vec3', 'a@32', 'b@32', 'c@32')) => ('vec3', ('i2imp', 'a'), ('i2imp', 'b'), ('i2imp', 'c'))
 *    ('f2f16', ('vec4', 'a@32', 'b@32', 'c@32', 'd@32')) => ('vec4', ('f2f16', 'a'), ('f2f16', 'b'), ('f2f16', 'c'), ('f2f16', 'd'))
 *    ('f2fmp', ('vec4', 'a@32', 'b@32', 'c@32', 'd@32')) => ('vec4', ('f2fmp', 'a'), ('f2fmp', 'b'), ('f2fmp', 'c'), ('f2fmp', 'd'))
 *    ('u2u16', ('vec4', 'a@32', 'b@32', 'c@32', 'd@32')) => ('vec4', ('u2u16', 'a'), ('u2u16', 'b'), ('u2u16', 'c'), ('u2u16', 'd'))
 *    ('i2i16', ('vec4', 'a@32', 'b@32', 'c@32', 'd@32')) => ('vec4', ('i2i16', 'a'), ('i2i16', 'b'), ('i2i16', 'c'), ('i2i16', 'd'))
 *    ('i2imp', ('vec4', 'a@32', 'b@32', 'c@32', 'd@32')) => ('vec4', ('i2imp', 'a'), ('i2imp', 'b'), ('i2imp', 'c'), ('i2imp', 'd'))
 */


static const nir_search_value_union nir_opt_algebraic_values[] = {
   /* ('fgeu', 'a', 'b') => ('inot', ('flt', 'a', 'b')) */
   { .variable = {
      { nir_search_value_variable, -2 },
      0, /* a */
      false,
      nir_type_invalid,
      -1,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .variable = {
      { nir_search_value_variable, -2 },
      1, /* b */
      false,
      nir_type_invalid,
      -1,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fgeu,
      -1, 0,
      { 0, 1 },
      -1,
   } },

   /* replace0_0_0 -> 0 in the cache */
   /* replace0_0_1 -> 1 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_flt,
      -1, 0,
      { 0, 1 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_inot,
      -1, 0,
      { 3 },
      -1,
   } },

   /* ('fltu', 'a', 'b') => ('inot', ('fge', 'a', 'b')) */
   /* search1_0 -> 0 in the cache */
   /* search1_1 -> 1 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fltu,
      -1, 0,
      { 0, 1 },
      -1,
   } },

   /* replace1_0_0 -> 0 in the cache */
   /* replace1_0_1 -> 1 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fge,
      -1, 0,
      { 0, 1 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_inot,
      -1, 0,
      { 6 },
      -1,
   } },

   /* ('fneo', 0.0, 'a') => ('flt', 0.0, ('fabs', 'a')) */
   { .constant = {
      { nir_search_value_constant, -1 },
      nir_type_float, { 0x0ull /* 0.0 */ },
   } },
   { .variable = {
      { nir_search_value_variable, -1 },
      0, /* a */
      false,
      nir_type_invalid,
      -1,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fneo,
      0, 1,
      { 8, 9 },
      -1,
   } },

   /* replace2_0 -> 8 in the cache */
   /* replace2_1_0 -> 9 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fabs,
      -1, 0,
      { 9 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_flt,
      -1, 0,
      { 8, 11 },
      -1,
   } },

   /* ('fequ', 0.0, 'a') => ('inot', ('flt', 0.0, ('fabs', 'a'))) */
   /* search3_0 -> 8 in the cache */
   /* search3_1 -> 9 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fequ,
      0, 1,
      { 8, 9 },
      -1,
   } },

   /* replace3_0_0 -> 8 in the cache */
   /* replace3_0_1_0 -> 9 in the cache */
   /* replace3_0_1 -> 11 in the cache */
   /* replace3_0 -> 12 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_inot,
      -1, 0,
      { 12 },
      -1,
   } },

   /* ('imul', 'a', '#b(is_pos_power_of_two)') => ('ishl', 'a', ('find_lsb', 'b')) */
   /* search4_0 -> 0 in the cache */
   { .variable = {
      { nir_search_value_variable, -2 },
      1, /* b */
      true,
      nir_type_invalid,
      0,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_imul,
      0, 1,
      { 0, 15 },
      -1,
   } },

   /* replace4_0 -> 0 in the cache */
   /* replace4_1_0 -> 1 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_find_lsb,
      -1, 0,
      { 1 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ishl,
      -1, 0,
      { 0, 17 },
      -1,
   } },

   /* ('imul', 'a@8', 128) => ('ishl', 'a', 7) */
   { .variable = {
      { nir_search_value_variable, 8 },
      0, /* a */
      false,
      nir_type_invalid,
      -1,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .constant = {
      { nir_search_value_constant, 8 },
      nir_type_int, { 0x80ull /* 128 */ },
   } },
   { .expression = {
      { nir_search_value_expression, 8 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_imul,
      0, 1,
      { 19, 20 },
      -1,
   } },

   /* replace5_0 -> 19 in the cache */
   { .constant = {
      { nir_search_value_constant, 32 },
      nir_type_int, { 0x7ull /* 7 */ },
   } },
   { .expression = {
      { nir_search_value_expression, 8 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ishl,
      -1, 0,
      { 19, 22 },
      -1,
   } },

   /* ('imul', 'a@16', 32768) => ('ishl', 'a', 15) */
   { .variable = {
      { nir_search_value_variable, 16 },
      0, /* a */
      false,
      nir_type_invalid,
      -1,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .constant = {
      { nir_search_value_constant, 16 },
      nir_type_int, { 0x8000ull /* 32768 */ },
   } },
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_imul,
      0, 1,
      { 24, 25 },
      -1,
   } },

   /* replace6_0 -> 24 in the cache */
   { .constant = {
      { nir_search_value_constant, 32 },
      nir_type_int, { 0xfull /* 15 */ },
   } },
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ishl,
      -1, 0,
      { 24, 27 },
      -1,
   } },

   /* ('imul', 'a@32', 2147483648) => ('ishl', 'a', 31) */
   { .variable = {
      { nir_search_value_variable, 32 },
      0, /* a */
      false,
      nir_type_invalid,
      -1,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .constant = {
      { nir_search_value_constant, 32 },
      nir_type_int, { 0x80000000ull /* 2147483648 */ },
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_imul,
      0, 1,
      { 29, 30 },
      -1,
   } },

   /* replace7_0 -> 29 in the cache */
   { .constant = {
      { nir_search_value_constant, 32 },
      nir_type_int, { 0x1full /* 31 */ },
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ishl,
      -1, 0,
      { 29, 32 },
      -1,
   } },

   /* ('imul', 'a@64', 9223372036854775808) => ('ishl', 'a', 63) */
   { .variable = {
      { nir_search_value_variable, 64 },
      0, /* a */
      false,
      nir_type_invalid,
      -1,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .constant = {
      { nir_search_value_constant, 64 },
      nir_type_int, { 0x8000000000000000ull /* 9223372036854775808 */ },
   } },
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_imul,
      0, 1,
      { 34, 35 },
      -1,
   } },

   /* replace8_0 -> 34 in the cache */
   { .constant = {
      { nir_search_value_constant, 32 },
      nir_type_int, { 0x3full /* 63 */ },
   } },
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ishl,
      -1, 0,
      { 34, 37 },
      -1,
   } },

   /* ('imul', 'a', '#b(is_neg_power_of_two)') => ('ineg', ('ishl', 'a', ('find_lsb', ('iabs', 'b')))) */
   /* search9_0 -> 0 in the cache */
   { .variable = {
      { nir_search_value_variable, -2 },
      1, /* b */
      true,
      nir_type_invalid,
      1,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_imul,
      0, 1,
      { 0, 39 },
      -1,
   } },

   /* replace9_0_0 -> 0 in the cache */
   /* replace9_0_1_0_0 -> 1 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_iabs,
      -1, 0,
      { 1 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_find_lsb,
      -1, 0,
      { 41 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ishl,
      -1, 0,
      { 0, 42 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ineg,
      -1, 0,
      { 43 },
      -1,
   } },

   /* ('ishl', 'a', '#b') => ('imul', 'a', ('ishl', 1, 'b')) */
   /* search10_0 -> 9 in the cache */
   { .variable = {
      { nir_search_value_variable, 32 },
      1, /* b */
      true,
      nir_type_invalid,
      -1,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ishl,
      -1, 0,
      { 9, 45 },
      -1,
   } },

   /* replace10_0 -> 9 in the cache */
   { .constant = {
      { nir_search_value_constant, -1 },
      nir_type_int, { 0x1ull /* 1 */ },
   } },
   { .variable = {
      { nir_search_value_variable, 32 },
      1, /* b */
      false,
      nir_type_invalid,
      -1,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ishl,
      -1, 0,
      { 47, 48 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_imul,
      0, 1,
      { 9, 49 },
      -1,
   } },

   /* ('imul@64', 'a', '#b(is_bitcount2)') => ('iadd', ('ishl', 'a', ('ufind_msb', 'b')), ('ishl', 'a', ('find_lsb', 'b'))) */
   /* search11_0 -> 34 in the cache */
   { .variable = {
      { nir_search_value_variable, 64 },
      1, /* b */
      true,
      nir_type_invalid,
      2,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_imul,
      0, 1,
      { 34, 51 },
      -1,
   } },

   /* replace11_0_0 -> 34 in the cache */
   { .variable = {
      { nir_search_value_variable, 64 },
      1, /* b */
      false,
      nir_type_invalid,
      -1,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ufind_msb,
      -1, 0,
      { 53 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ishl,
      -1, 0,
      { 34, 54 },
      -1,
   } },
   /* replace11_1_0 -> 34 in the cache */
   /* replace11_1_1_0 -> 53 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_find_lsb,
      -1, 0,
      { 53 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ishl,
      -1, 0,
      { 34, 56 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_iadd,
      0, 1,
      { 55, 57 },
      -1,
   } },

   /* ('unpack_64_2x32_split_x', ('imul_2x32_64(is_used_once)', 'a', 'b')) => ('imul', 'a', 'b') */
   /* search12_0_0 -> 29 in the cache */
   /* search12_0_1 -> 48 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_imul_2x32_64,
      0, 1,
      { 29, 48 },
      0,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_unpack_64_2x32_split_x,
      -1, 1,
      { 59 },
      -1,
   } },

   /* replace12_0 -> 29 in the cache */
   /* replace12_1 -> 48 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_imul,
      0, 1,
      { 29, 48 },
      -1,
   } },

   /* ('unpack_64_2x32_split_x', ('umul_2x32_64(is_used_once)', 'a', 'b')) => ('imul', 'a', 'b') */
   /* search13_0_0 -> 29 in the cache */
   /* search13_0_1 -> 48 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_umul_2x32_64,
      0, 1,
      { 29, 48 },
      0,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_unpack_64_2x32_split_x,
      -1, 1,
      { 62 },
      -1,
   } },

   /* replace13_0 -> 29 in the cache */
   /* replace13_1 -> 48 in the cache */
   /* replace13 -> 61 in the cache */

   /* ('imul_2x32_64', 'a', 'b') => ('pack_64_2x32_split', ('imul', 'a', 'b'), ('imul_high', 'a', 'b')) */
   /* search14_0 -> 29 in the cache */
   /* search14_1 -> 48 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_imul_2x32_64,
      0, 1,
      { 29, 48 },
      -1,
   } },

   /* replace14_0_0 -> 29 in the cache */
   /* replace14_0_1 -> 48 in the cache */
   /* replace14_0 -> 61 in the cache */
   /* replace14_1_0 -> 29 in the cache */
   /* replace14_1_1 -> 48 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_imul_high,
      1, 1,
      { 29, 48 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_pack_64_2x32_split,
      -1, 2,
      { 61, 65 },
      -1,
   } },

   /* ('umul_2x32_64', 'a', 'b') => ('pack_64_2x32_split', ('imul', 'a', 'b'), ('umul_high', 'a', 'b')) */
   /* search15_0 -> 29 in the cache */
   /* search15_1 -> 48 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_umul_2x32_64,
      0, 1,
      { 29, 48 },
      -1,
   } },

   /* replace15_0_0 -> 29 in the cache */
   /* replace15_0_1 -> 48 in the cache */
   /* replace15_0 -> 61 in the cache */
   /* replace15_1_0 -> 29 in the cache */
   /* replace15_1_1 -> 48 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_umul_high,
      1, 1,
      { 29, 48 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_pack_64_2x32_split,
      -1, 2,
      { 61, 68 },
      -1,
   } },

   /* ('udiv', 'a', 1) => a */
   /* search16_0 -> 9 in the cache */
   /* search16_1 -> 47 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_udiv,
      -1, 0,
      { 9, 47 },
      -1,
   } },

   /* replace16 -> 9 in the cache */

   /* ('idiv', 'a', 1) => a */
   /* search17_0 -> 9 in the cache */
   /* search17_1 -> 47 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_idiv,
      -1, 0,
      { 9, 47 },
      -1,
   } },

   /* replace17 -> 9 in the cache */

   /* ('umod', 'a', 1) => 0 */
   /* search18_0 -> 9 in the cache */
   /* search18_1 -> 47 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_umod,
      -1, 0,
      { 9, 47 },
      -1,
   } },

   { .constant = {
      { nir_search_value_constant, -1 },
      nir_type_int, { 0x0ull /* 0 */ },
   } },

   /* ('imod', 'a', 1) => 0 */
   /* search19_0 -> 9 in the cache */
   /* search19_1 -> 47 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_imod,
      -1, 0,
      { 9, 47 },
      -1,
   } },

   /* replace19 -> 73 in the cache */

   /* ('imod', 'a', -1) => 0 */
   /* search20_0 -> 9 in the cache */
   { .constant = {
      { nir_search_value_constant, -1 },
      nir_type_int, { 0xffffffffffffffffull /* -1 */ },
   } },
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_imod,
      -1, 0,
      { 9, 75 },
      -1,
   } },

   /* replace20 -> 73 in the cache */

   /* ('irem', 'a', 1) => 0 */
   /* search21_0 -> 9 in the cache */
   /* search21_1 -> 47 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_irem,
      -1, 0,
      { 9, 47 },
      -1,
   } },

   /* replace21 -> 73 in the cache */

   /* ('irem', 'a', -1) => 0 */
   /* search22_0 -> 9 in the cache */
   /* search22_1 -> 75 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_irem,
      -1, 0,
      { 9, 75 },
      -1,
   } },

   /* replace22 -> 73 in the cache */

   /* ('udiv', 'a', '#b(is_pos_power_of_two)') => ('ushr', 'a', ('find_lsb', 'b')) */
   /* search23_0 -> 0 in the cache */
   /* search23_1 -> 15 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_udiv,
      -1, 0,
      { 0, 15 },
      -1,
   } },

   /* replace23_0 -> 0 in the cache */
   /* replace23_1_0 -> 1 in the cache */
   /* replace23_1 -> 17 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ushr,
      -1, 0,
      { 0, 17 },
      -1,
   } },

   /* ('idiv', 'a', '#b(is_pos_power_of_two)') => ('imul', ('isign', 'a'), ('ushr', ('iabs', 'a'), ('find_lsb', 'b'))) */
   /* search24_0 -> 0 in the cache */
   /* search24_1 -> 15 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_idiv,
      -1, 0,
      { 0, 15 },
      -1,
   } },

   /* replace24_0_0 -> 0 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_isign,
      -1, 0,
      { 0 },
      -1,
   } },
   /* replace24_1_0_0 -> 0 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_iabs,
      -1, 0,
      { 0 },
      -1,
   } },
   /* replace24_1_1_0 -> 1 in the cache */
   /* replace24_1_1 -> 17 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ushr,
      -1, 0,
      { 83, 17 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_imul,
      0, 1,
      { 82, 84 },
      -1,
   } },

   /* ('idiv', 'a', '#b(is_neg_power_of_two)') => ('ineg', ('imul', ('isign', 'a'), ('ushr', ('iabs', 'a'), ('find_lsb', ('iabs', 'b'))))) */
   /* search25_0 -> 0 in the cache */
   /* search25_1 -> 39 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_idiv,
      -1, 0,
      { 0, 39 },
      -1,
   } },

   /* replace25_0_0_0 -> 0 in the cache */
   /* replace25_0_0 -> 82 in the cache */
   /* replace25_0_1_0_0 -> 0 in the cache */
   /* replace25_0_1_0 -> 83 in the cache */
   /* replace25_0_1_1_0_0 -> 1 in the cache */
   /* replace25_0_1_1_0 -> 41 in the cache */
   /* replace25_0_1_1 -> 42 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ushr,
      -1, 0,
      { 83, 42 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_imul,
      0, 1,
      { 82, 87 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ineg,
      -1, 1,
      { 88 },
      -1,
   } },

   /* ('umod', 'a', '#b(is_pos_power_of_two)') => ('iand', 'a', ('isub', 'b', 1)) */
   /* search26_0 -> 0 in the cache */
   /* search26_1 -> 15 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_umod,
      -1, 0,
      { 0, 15 },
      -1,
   } },

   /* replace26_0 -> 0 in the cache */
   /* replace26_1_0 -> 1 in the cache */
   { .constant = {
      { nir_search_value_constant, -2 },
      nir_type_int, { 0x1ull /* 1 */ },
   } },
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_isub,
      -1, 0,
      { 1, 91 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_iand,
      0, 1,
      { 0, 92 },
      -1,
   } },

   /* ('imod', 'a', '#b(is_pos_power_of_two)') => ('iand', 'a', ('isub', 'b', 1)) */
   /* search27_0 -> 0 in the cache */
   /* search27_1 -> 15 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_imod,
      -1, 0,
      { 0, 15 },
      -1,
   } },

   /* replace27_0 -> 0 in the cache */
   /* replace27_1_0 -> 1 in the cache */
   /* replace27_1_1 -> 91 in the cache */
   /* replace27_1 -> 92 in the cache */
   /* replace27 -> 93 in the cache */

   /* ('imod', 'a', '#b(is_neg_power_of_two)') => ('bcsel', ('ieq', ('ior', 'a', 'b'), 'b'), 0, ('ior', 'a', 'b')) */
   /* search28_0 -> 0 in the cache */
   /* search28_1 -> 39 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_imod,
      -1, 0,
      { 0, 39 },
      -1,
   } },

   /* replace28_0_0_0 -> 0 in the cache */
   /* replace28_0_0_1 -> 1 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ior,
      1, 1,
      { 0, 1 },
      -1,
   } },
   /* replace28_0_1 -> 1 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ieq,
      0, 2,
      { 96, 1 },
      -1,
   } },
   { .constant = {
      { nir_search_value_constant, -2 },
      nir_type_int, { 0x0ull /* 0 */ },
   } },
   /* replace28_2_0 -> 0 in the cache */
   /* replace28_2_1 -> 1 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ior,
      2, 1,
      { 0, 1 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_bcsel,
      -1, 3,
      { 97, 98, 99 },
      -1,
   } },

   /* ('irem', 'a', '#b(is_pos_power_of_two)') => ('isub', 'a', ('iand', ('bcsel', ('ilt', 'a', 0), ('iadd', 'a', ('isub', 'b', 1)), 'a'), ('ineg', 'b'))) */
   /* search29_0 -> 0 in the cache */
   /* search29_1 -> 15 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_irem,
      -1, 0,
      { 0, 15 },
      -1,
   } },

   /* replace29_0 -> 0 in the cache */
   /* replace29_1_0_0_0 -> 0 in the cache */
   /* replace29_1_0_0_1 -> 98 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ilt,
      -1, 0,
      { 0, 98 },
      -1,
   } },
   /* replace29_1_0_1_0 -> 0 in the cache */
   /* replace29_1_0_1_1_0 -> 1 in the cache */
   /* replace29_1_0_1_1_1 -> 91 in the cache */
   /* replace29_1_0_1_1 -> 92 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_iadd,
      1, 1,
      { 0, 92 },
      -1,
   } },
   /* replace29_1_0_2 -> 0 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_bcsel,
      -1, 1,
      { 102, 103, 0 },
      -1,
   } },
   /* replace29_1_1_0 -> 1 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ineg,
      -1, 0,
      { 1 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_iand,
      0, 2,
      { 104, 105 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_isub,
      -1, 2,
      { 0, 106 },
      -1,
   } },

   /* ('irem', 'a', '#b(is_neg_power_of_two)') => ('irem', 'a', ('iabs', 'b')) */
   /* search30_0 -> 0 in the cache */
   /* search30_1 -> 39 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_irem,
      -1, 0,
      { 0, 39 },
      -1,
   } },

   /* replace30_0 -> 0 in the cache */
   /* replace30_1_0 -> 1 in the cache */
   /* replace30_1 -> 41 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_irem,
      -1, 0,
      { 0, 41 },
      -1,
   } },

   /* ('~fmul', ('fsign', 'a'), ('ffloor', ('fadd', ('fabs', 'a'), 0.5))) => ('ftrunc', ('fadd', 'a', ('fmul', ('fsign', 'a'), 0.5))) */
   /* search31_0_0 -> 9 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fsign,
      -1, 0,
      { 9 },
      -1,
   } },
   /* search31_1_0_0_0 -> 9 in the cache */
   /* search31_1_0_0 -> 11 in the cache */
   { .constant = {
      { nir_search_value_constant, -1 },
      nir_type_float, { 0x3fe0000000000000ull /* 0.5 */ },
   } },
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fadd,
      1, 1,
      { 11, 111 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ffloor,
      -1, 1,
      { 112 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -1 },
      true,
      false,
      false,
      false,
      false,
      false,
      nir_op_fmul,
      0, 2,
      { 110, 113 },
      -1,
   } },

   /* replace31_0_0 -> 9 in the cache */
   /* replace31_0_1_0_0 -> 9 in the cache */
   /* replace31_0_1_0 -> 110 in the cache */
   /* replace31_0_1_1 -> 111 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fmul,
      1, 1,
      { 110, 111 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fadd,
      0, 2,
      { 9, 115 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ftrunc,
      -1, 2,
      { 116 },
      -1,
   } },

   /* ('~fneg', ('fneg', 'a')) => a */
   /* search32_0_0 -> 9 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fneg,
      -1, 0,
      { 9 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -1 },
      true,
      false,
      false,
      false,
      false,
      false,
      nir_op_fneg,
      -1, 0,
      { 118 },
      -1,
   } },

   /* replace32 -> 9 in the cache */

   /* ('ineg', ('ineg', 'a')) => a */
   /* search33_0_0 -> 9 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ineg,
      -1, 0,
      { 9 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ineg,
      -1, 0,
      { 120 },
      -1,
   } },

   /* replace33 -> 9 in the cache */

   /* ('fabs', ('fneg', 'a')) => ('fabs', 'a') */
   /* search34_0_0 -> 9 in the cache */
   /* search34_0 -> 118 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fabs,
      -1, 0,
      { 118 },
      -1,
   } },

   /* replace34_0 -> 9 in the cache */
   /* replace34 -> 11 in the cache */

   /* ('fabs', ('u2f', 'a')) => ('u2f', 'a') */
   /* search35_0_0 -> 9 in the cache */
   { .expression = {
      { nir_search_value_expression, 0 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_search_op_u2f,
      -1, 0,
      { 9 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 0 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fabs,
      -1, 0,
      { 123 },
      -1,
   } },

   /* replace35_0 -> 9 in the cache */
   /* replace35 -> 123 in the cache */

   /* ('iabs', ('iabs', 'a')) => ('iabs', 'a') */
   /* search36_0_0 -> 9 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_iabs,
      -1, 0,
      { 9 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_iabs,
      -1, 0,
      { 125 },
      -1,
   } },

   /* replace36_0 -> 9 in the cache */
   /* replace36 -> 125 in the cache */

   /* ('iabs', ('ineg', 'a')) => ('iabs', 'a') */
   /* search37_0_0 -> 9 in the cache */
   /* search37_0 -> 120 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_iabs,
      -1, 0,
      { 120 },
      -1,
   } },

   /* replace37_0 -> 9 in the cache */
   /* replace37 -> 125 in the cache */

   /* ('~fadd', 'a', 0.0) => a */
   /* search38_0 -> 9 in the cache */
   /* search38_1 -> 8 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      true,
      false,
      false,
      false,
      false,
      false,
      nir_op_fadd,
      0, 1,
      { 9, 8 },
      -1,
   } },

   /* replace38 -> 9 in the cache */

   /* ('fadd(is_only_used_as_float,nsz)', 'a', 0.0) => a */
   /* search39_0 -> 9 in the cache */
   /* search39_1 -> 8 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      true,
      false,
      false,
      nir_op_fadd,
      0, 1,
      { 9, 8 },
      1,
   } },

   /* replace39 -> 9 in the cache */

   /* ('iadd', 'a', 0) => a */
   /* search40_0 -> 9 in the cache */
   /* search40_1 -> 73 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_iadd,
      0, 1,
      { 9, 73 },
      -1,
   } },

   /* replace40 -> 9 in the cache */

   /* ('iadd_sat', 'a', 0) => a */
   /* search41_0 -> 9 in the cache */
   /* search41_1 -> 73 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_iadd_sat,
      0, 1,
      { 9, 73 },
      -1,
   } },

   /* replace41 -> 9 in the cache */

   /* ('isub_sat', 'a', 0) => a */
   /* search42_0 -> 9 in the cache */
   /* search42_1 -> 73 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_isub_sat,
      -1, 0,
      { 9, 73 },
      -1,
   } },

   /* replace42 -> 9 in the cache */

   /* ('uadd_sat', 'a', 0) => a */
   /* search43_0 -> 9 in the cache */
   /* search43_1 -> 73 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_uadd_sat,
      0, 1,
      { 9, 73 },
      -1,
   } },

   /* replace43 -> 9 in the cache */

   /* ('usub_sat', 'a', 0) => a */
   /* search44_0 -> 9 in the cache */
   /* search44_1 -> 73 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_usub_sat,
      -1, 0,
      { 9, 73 },
      -1,
   } },

   /* replace44 -> 9 in the cache */

   /* ('usadd_4x8_vc4', 'a', 0) => a */
   /* search45_0 -> 29 in the cache */
   { .constant = {
      { nir_search_value_constant, 32 },
      nir_type_int, { 0x0ull /* 0 */ },
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_usadd_4x8_vc4,
      0, 1,
      { 29, 135 },
      -1,
   } },

   /* replace45 -> 29 in the cache */

   /* ('usadd_4x8_vc4', 'a', -1) => -1 */
   /* search46_0 -> 29 in the cache */
   { .constant = {
      { nir_search_value_constant, 32 },
      nir_type_int, { 0xffffffffffffffffull /* -1 */ },
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_usadd_4x8_vc4,
      0, 1,
      { 29, 137 },
      -1,
   } },

   /* replace46 -> 137 in the cache */

   /* ('~fadd', ('fmul', 'a', 'b'), ('fmul', 'a', 'c')) => ('fmul', 'a', ('fadd', 'b', 'c')) */
   { .variable = {
      { nir_search_value_variable, -3 },
      0, /* a */
      false,
      nir_type_invalid,
      -1,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .variable = {
      { nir_search_value_variable, -3 },
      1, /* b */
      false,
      nir_type_invalid,
      -1,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fmul,
      1, 1,
      { 139, 140 },
      -1,
   } },
   /* search47_1_0 -> 139 in the cache */
   { .variable = {
      { nir_search_value_variable, -3 },
      2, /* c */
      false,
      nir_type_invalid,
      -1,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fmul,
      2, 1,
      { 139, 142 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -3 },
      true,
      false,
      false,
      false,
      false,
      false,
      nir_op_fadd,
      0, 3,
      { 141, 143 },
      -1,
   } },

   /* replace47_0 -> 139 in the cache */
   /* replace47_1_0 -> 140 in the cache */
   /* replace47_1_1 -> 142 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fadd,
      1, 1,
      { 140, 142 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fmul,
      0, 2,
      { 139, 145 },
      -1,
   } },

   /* ('~fadd', ('fmulz', 'a', 'b'), ('fmulz', 'a', 'c')) => ('fmulz', 'a', ('fadd', 'b', 'c')) */
   /* search48_0_0 -> 29 in the cache */
   /* search48_0_1 -> 48 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fmulz,
      1, 1,
      { 29, 48 },
      -1,
   } },
   /* search48_1_0 -> 29 in the cache */
   { .variable = {
      { nir_search_value_variable, 32 },
      2, /* c */
      false,
      nir_type_invalid,
      -1,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fmulz,
      2, 1,
      { 29, 148 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      true,
      false,
      false,
      false,
      false,
      false,
      nir_op_fadd,
      0, 3,
      { 147, 149 },
      -1,
   } },

   /* replace48_0 -> 29 in the cache */
   /* replace48_1_0 -> 48 in the cache */
   /* replace48_1_1 -> 148 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fadd,
      1, 1,
      { 48, 148 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fmulz,
      0, 2,
      { 29, 151 },
      -1,
   } },

   /* ('~ffma', 'a', 'b', ('ffma(is_used_once)', 'a', 'c', 'd')) => ('ffma', 'a', ('fadd', 'b', 'c'), 'd') */
   /* search49_0 -> 0 in the cache */
   /* search49_1 -> 1 in the cache */
   /* search49_2_0 -> 0 in the cache */
   { .variable = {
      { nir_search_value_variable, -2 },
      2, /* c */
      false,
      nir_type_invalid,
      -1,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .variable = {
      { nir_search_value_variable, -2 },
      3, /* d */
      false,
      nir_type_invalid,
      -1,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ffma,
      1, 1,
      { 0, 153, 154 },
      0,
   } },
   { .expression = {
      { nir_search_value_expression, -2 },
      true,
      false,
      false,
      false,
      false,
      false,
      nir_op_ffma,
      0, 2,
      { 0, 1, 155 },
      -1,
   } },

   /* replace49_0 -> 0 in the cache */
   /* replace49_1_0 -> 1 in the cache */
   /* replace49_1_1 -> 153 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fadd,
      1, 1,
      { 1, 153 },
      -1,
   } },
   /* replace49_2 -> 154 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ffma,
      0, 2,
      { 0, 157, 154 },
      -1,
   } },

   /* ('~ffma', 'a', 'b', ('fmul(is_used_once)', 'a', 'c')) => ('fmul', 'a', ('fadd', 'b', 'c')) */
   /* search50_0 -> 0 in the cache */
   /* search50_1 -> 1 in the cache */
   /* search50_2_0 -> 0 in the cache */
   /* search50_2_1 -> 153 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fmul,
      1, 1,
      { 0, 153 },
      0,
   } },
   { .expression = {
      { nir_search_value_expression, -2 },
      true,
      false,
      false,
      false,
      false,
      false,
      nir_op_ffma,
      0, 2,
      { 0, 1, 159 },
      -1,
   } },

   /* replace50_0 -> 0 in the cache */
   /* replace50_1_0 -> 1 in the cache */
   /* replace50_1_1 -> 153 in the cache */
   /* replace50_1 -> 157 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fmul,
      0, 2,
      { 0, 157 },
      -1,
   } },

   /* ('~fadd', ('fmul(is_used_once)', 'a', 'b'), ('ffma(is_used_once)', 'a', 'c', 'd')) => ('ffma', 'a', ('fadd', 'b', 'c'), 'd') */
   { .variable = {
      { nir_search_value_variable, -4 },
      0, /* a */
      false,
      nir_type_invalid,
      -1,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .variable = {
      { nir_search_value_variable, -4 },
      1, /* b */
      false,
      nir_type_invalid,
      -1,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .expression = {
      { nir_search_value_expression, -4 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fmul,
      1, 1,
      { 162, 163 },
      0,
   } },
   /* search51_1_0 -> 162 in the cache */
   { .variable = {
      { nir_search_value_variable, -4 },
      2, /* c */
      false,
      nir_type_invalid,
      -1,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .variable = {
      { nir_search_value_variable, -4 },
      3, /* d */
      false,
      nir_type_invalid,
      -1,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .expression = {
      { nir_search_value_expression, -4 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ffma,
      2, 1,
      { 162, 165, 166 },
      0,
   } },
   { .expression = {
      { nir_search_value_expression, -4 },
      true,
      false,
      false,
      false,
      false,
      false,
      nir_op_fadd,
      0, 3,
      { 164, 167 },
      -1,
   } },

   /* replace51_0 -> 162 in the cache */
   /* replace51_1_0 -> 163 in the cache */
   /* replace51_1_1 -> 165 in the cache */
   { .expression = {
      { nir_search_value_expression, -4 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fadd,
      1, 1,
      { 163, 165 },
      -1,
   } },
   /* replace51_2 -> 166 in the cache */
   { .expression = {
      { nir_search_value_expression, -4 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ffma,
      0, 2,
      { 162, 169, 166 },
      -1,
   } },

   /* ('~ffma', 'a', ('fmul(is_used_once)', 'b', 'c'), ('fmul(is_used_once)', 'b', 'd')) => ('fmul', 'b', ('ffma', 'a', 'c', 'd')) */
   /* search52_0 -> 162 in the cache */
   /* search52_1_0 -> 163 in the cache */
   /* search52_1_1 -> 165 in the cache */
   { .expression = {
      { nir_search_value_expression, -4 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fmul,
      1, 1,
      { 163, 165 },
      0,
   } },
   /* search52_2_0 -> 163 in the cache */
   /* search52_2_1 -> 166 in the cache */
   { .expression = {
      { nir_search_value_expression, -4 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fmul,
      2, 1,
      { 163, 166 },
      0,
   } },
   { .expression = {
      { nir_search_value_expression, -4 },
      true,
      false,
      false,
      false,
      false,
      false,
      nir_op_ffma,
      0, 3,
      { 162, 171, 172 },
      -1,
   } },

   /* replace52_0 -> 163 in the cache */
   /* replace52_1_0 -> 162 in the cache */
   /* replace52_1_1 -> 165 in the cache */
   /* replace52_1_2 -> 166 in the cache */
   { .expression = {
      { nir_search_value_expression, -4 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ffma,
      1, 1,
      { 162, 165, 166 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -4 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fmul,
      0, 2,
      { 163, 174 },
      -1,
   } },

   /* ('~ffmaz', 'a', 'b', ('ffmaz(is_used_once)', 'a', 'c', 'd')) => ('ffmaz', 'a', ('fadd', 'b', 'c'), 'd') */
   /* search53_0 -> 29 in the cache */
   /* search53_1 -> 48 in the cache */
   /* search53_2_0 -> 29 in the cache */
   /* search53_2_1 -> 148 in the cache */
   { .variable = {
      { nir_search_value_variable, 32 },
      3, /* d */
      false,
      nir_type_invalid,
      -1,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ffmaz,
      1, 1,
      { 29, 148, 176 },
      0,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      true,
      false,
      false,
      false,
      false,
      false,
      nir_op_ffmaz,
      0, 2,
      { 29, 48, 177 },
      -1,
   } },

   /* replace53_0 -> 29 in the cache */
   /* replace53_1_0 -> 48 in the cache */
   /* replace53_1_1 -> 148 in the cache */
   /* replace53_1 -> 151 in the cache */
   /* replace53_2 -> 176 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ffmaz,
      0, 2,
      { 29, 151, 176 },
      -1,
   } },

   /* ('~ffmaz', 'a', 'b', ('fmulz(is_used_once)', 'a', 'c')) => ('fmulz', 'a', ('fadd', 'b', 'c')) */
   /* search54_0 -> 29 in the cache */
   /* search54_1 -> 48 in the cache */
   /* search54_2_0 -> 29 in the cache */
   /* search54_2_1 -> 148 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fmulz,
      1, 1,
      { 29, 148 },
      0,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      true,
      false,
      false,
      false,
      false,
      false,
      nir_op_ffmaz,
      0, 2,
      { 29, 48, 180 },
      -1,
   } },

   /* replace54_0 -> 29 in the cache */
   /* replace54_1_0 -> 48 in the cache */
   /* replace54_1_1 -> 148 in the cache */
   /* replace54_1 -> 151 in the cache */
   /* replace54 -> 152 in the cache */

   /* ('~fadd', ('fmulz(is_used_once)', 'a', 'b'), ('ffmaz(is_used_once)', 'a', 'c', 'd')) => ('ffmaz', 'a', ('fadd', 'b', 'c'), 'd') */
   /* search55_0_0 -> 29 in the cache */
   /* search55_0_1 -> 48 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fmulz,
      1, 1,
      { 29, 48 },
      0,
   } },
   /* search55_1_0 -> 29 in the cache */
   /* search55_1_1 -> 148 in the cache */
   /* search55_1_2 -> 176 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ffmaz,
      2, 1,
      { 29, 148, 176 },
      0,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      true,
      false,
      false,
      false,
      false,
      false,
      nir_op_fadd,
      0, 3,
      { 182, 183 },
      -1,
   } },

   /* replace55_0 -> 29 in the cache */
   /* replace55_1_0 -> 48 in the cache */
   /* replace55_1_1 -> 148 in the cache */
   /* replace55_1 -> 151 in the cache */
   /* replace55_2 -> 176 in the cache */
   /* replace55 -> 179 in the cache */

   /* ('~ffmaz', 'a', ('fmulz(is_used_once)', 'b', 'c'), ('fmulz(is_used_once)', 'b', 'd')) => ('fmulz', 'b', ('ffmaz', 'a', 'c', 'd')) */
   /* search56_0 -> 29 in the cache */
   /* search56_1_0 -> 48 in the cache */
   /* search56_1_1 -> 148 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fmulz,
      1, 1,
      { 48, 148 },
      0,
   } },
   /* search56_2_0 -> 48 in the cache */
   /* search56_2_1 -> 176 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fmulz,
      2, 1,
      { 48, 176 },
      0,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      true,
      false,
      false,
      false,
      false,
      false,
      nir_op_ffmaz,
      0, 3,
      { 29, 185, 186 },
      -1,
   } },

   /* replace56_0 -> 48 in the cache */
   /* replace56_1_0 -> 29 in the cache */
   /* replace56_1_1 -> 148 in the cache */
   /* replace56_1_2 -> 176 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ffmaz,
      1, 1,
      { 29, 148, 176 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fmulz,
      0, 2,
      { 48, 188 },
      -1,
   } },

   /* ('iadd', ('imul', 'a', 'b'), ('imul', 'a', 'c')) => ('imul', 'a', ('iadd', 'b', 'c')) */
   /* search57_0_0 -> 139 in the cache */
   /* search57_0_1 -> 140 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_imul,
      1, 1,
      { 139, 140 },
      -1,
   } },
   /* search57_1_0 -> 139 in the cache */
   /* search57_1_1 -> 142 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_imul,
      2, 1,
      { 139, 142 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_iadd,
      0, 3,
      { 190, 191 },
      -1,
   } },

   /* replace57_0 -> 139 in the cache */
   /* replace57_1_0 -> 140 in the cache */
   /* replace57_1_1 -> 142 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_iadd,
      1, 1,
      { 140, 142 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_imul,
      0, 2,
      { 139, 193 },
      -1,
   } },

   /* ('iadd', ('ishl', 'b', 'a'), ('ishl', 'c', 'a')) => ('ishl', ('iadd', 'b', 'c'), 'a') */
   { .variable = {
      { nir_search_value_variable, -3 },
      0, /* b */
      false,
      nir_type_invalid,
      -1,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .variable = {
      { nir_search_value_variable, 32 },
      1, /* a */
      false,
      nir_type_invalid,
      -1,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ishl,
      -1, 0,
      { 195, 196 },
      -1,
   } },
   /* search58_1_0 -> 142 in the cache */
   /* search58_1_1 -> 196 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ishl,
      -1, 0,
      { 142, 196 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_iadd,
      0, 1,
      { 197, 198 },
      -1,
   } },

   /* replace58_0_0 -> 195 in the cache */
   /* replace58_0_1 -> 142 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_iadd,
      0, 1,
      { 195, 142 },
      -1,
   } },
   /* replace58_1 -> 196 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ishl,
      -1, 1,
      { 200, 196 },
      -1,
   } },

   /* ('iand', ('ior', 'a', 'b'), ('ior', 'a', 'c')) => ('ior', 'a', ('iand', 'b', 'c')) */
   /* search59_0_0 -> 139 in the cache */
   /* search59_0_1 -> 140 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ior,
      1, 1,
      { 139, 140 },
      -1,
   } },
   /* search59_1_0 -> 139 in the cache */
   /* search59_1_1 -> 142 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ior,
      2, 1,
      { 139, 142 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_iand,
      0, 3,
      { 202, 203 },
      -1,
   } },

   /* replace59_0 -> 139 in the cache */
   /* replace59_1_0 -> 140 in the cache */
   /* replace59_1_1 -> 142 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_iand,
      1, 1,
      { 140, 142 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ior,
      0, 2,
      { 139, 205 },
      -1,
   } },

   /* ('ior', ('iand', 'a', 'b'), ('iand', 'a', 'c')) => ('iand', 'a', ('ior', 'b', 'c')) */
   /* search60_0_0 -> 139 in the cache */
   /* search60_0_1 -> 140 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_iand,
      1, 1,
      { 139, 140 },
      -1,
   } },
   /* search60_1_0 -> 139 in the cache */
   /* search60_1_1 -> 142 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_iand,
      2, 1,
      { 139, 142 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ior,
      0, 3,
      { 207, 208 },
      -1,
   } },

   /* replace60_0 -> 139 in the cache */
   /* replace60_1_0 -> 140 in the cache */
   /* replace60_1_1 -> 142 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ior,
      1, 1,
      { 140, 142 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_iand,
      0, 2,
      { 139, 210 },
      -1,
   } },

   /* ('ieq', ('iand', 'a', '#b(is_pos_power_of_two)'), 'b') => ('ine', ('iand', 'a', 'b'), 0) */
   /* search61_0_0 -> 0 in the cache */
   /* search61_0_1 -> 15 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_iand,
      1, 1,
      { 0, 15 },
      -1,
   } },
   /* search61_1 -> 1 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ieq,
      0, 2,
      { 212, 1 },
      -1,
   } },

   /* replace61_0_0 -> 0 in the cache */
   /* replace61_0_1 -> 1 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_iand,
      1, 1,
      { 0, 1 },
      -1,
   } },
   /* replace61_1 -> 98 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ine,
      0, 2,
      { 214, 98 },
      -1,
   } },

   /* ('ine', ('iand', 'a', '#b(is_pos_power_of_two)'), 'b') => ('ieq', ('iand', 'a', 'b'), 0) */
   /* search62_0_0 -> 0 in the cache */
   /* search62_0_1 -> 15 in the cache */
   /* search62_0 -> 212 in the cache */
   /* search62_1 -> 1 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ine,
      0, 2,
      { 212, 1 },
      -1,
   } },

   /* replace62_0_0 -> 0 in the cache */
   /* replace62_0_1 -> 1 in the cache */
   /* replace62_0 -> 214 in the cache */
   /* replace62_1 -> 98 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ieq,
      0, 2,
      { 214, 98 },
      -1,
   } },

   /* ('ieq', ('ushr(is_used_once)', 'a', '#b'), 0) => ('ult', 'a', ('ishl', 1, 'b')) */
   /* search63_0_0 -> 9 in the cache */
   /* search63_0_1 -> 45 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ushr,
      -1, 0,
      { 9, 45 },
      0,
   } },
   /* search63_1 -> 73 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ieq,
      0, 1,
      { 218, 73 },
      -1,
   } },

   /* replace63_0 -> 9 in the cache */
   /* replace63_1_0 -> 47 in the cache */
   /* replace63_1_1 -> 48 in the cache */
   /* replace63_1 -> 49 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ult,
      -1, 0,
      { 9, 49 },
      -1,
   } },

   /* ('ine', ('ushr(is_used_once)', 'a', '#b'), 0) => ('uge', 'a', ('ishl', 1, 'b')) */
   /* search64_0_0 -> 9 in the cache */
   /* search64_0_1 -> 45 in the cache */
   /* search64_0 -> 218 in the cache */
   /* search64_1 -> 73 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ine,
      0, 1,
      { 218, 73 },
      -1,
   } },

   /* replace64_0 -> 9 in the cache */
   /* replace64_1_0 -> 47 in the cache */
   /* replace64_1_1 -> 48 in the cache */
   /* replace64_1 -> 49 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_uge,
      -1, 0,
      { 9, 49 },
      -1,
   } },

   /* ('~fadd', ('fneg', 'a'), 'a') => 0.0 */
   /* search65_0_0 -> 9 in the cache */
   /* search65_0 -> 118 in the cache */
   /* search65_1 -> 9 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      true,
      false,
      false,
      false,
      false,
      false,
      nir_op_fadd,
      0, 1,
      { 118, 9 },
      -1,
   } },

   /* replace65 -> 8 in the cache */

   /* ('iadd', ('ineg', 'a'), 'a') => 0 */
   /* search66_0_0 -> 9 in the cache */
   /* search66_0 -> 120 in the cache */
   /* search66_1 -> 9 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_iadd,
      0, 1,
      { 120, 9 },
      -1,
   } },

   /* replace66 -> 73 in the cache */

   /* ('iadd', ('ineg', 'a'), ('iadd', 'a', 'b')) => b */
   /* search67_0_0 -> 0 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ineg,
      -1, 0,
      { 0 },
      -1,
   } },
   /* search67_1_0 -> 0 in the cache */
   /* search67_1_1 -> 1 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_iadd,
      1, 1,
      { 0, 1 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_iadd,
      0, 2,
      { 225, 226 },
      -1,
   } },

   /* replace67 -> 1 in the cache */

   /* ('iadd', 'a', ('iadd', ('ineg', 'a'), 'b')) => b */
   /* search68_0 -> 0 in the cache */
   /* search68_1_0_0 -> 0 in the cache */
   /* search68_1_0 -> 225 in the cache */
   /* search68_1_1 -> 1 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_iadd,
      1, 1,
      { 225, 1 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_iadd,
      0, 2,
      { 0, 228 },
      -1,
   } },

   /* replace68 -> 1 in the cache */

   /* ('~fadd', ('fneg', 'a'), ('fadd', 'a', 'b')) => b */
   /* search69_0_0 -> 0 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fneg,
      -1, 0,
      { 0 },
      -1,
   } },
   /* search69_1_0 -> 0 in the cache */
   /* search69_1_1 -> 1 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fadd,
      1, 1,
      { 0, 1 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -2 },
      true,
      false,
      false,
      false,
      false,
      false,
      nir_op_fadd,
      0, 2,
      { 230, 231 },
      -1,
   } },

   /* replace69 -> 1 in the cache */

   /* ('~fadd', 'a', ('fadd', ('fneg', 'a'), 'b')) => b */
   /* search70_0 -> 0 in the cache */
   /* search70_1_0_0 -> 0 in the cache */
   /* search70_1_0 -> 230 in the cache */
   /* search70_1_1 -> 1 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fadd,
      1, 1,
      { 230, 1 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -2 },
      true,
      false,
      false,
      false,
      false,
      false,
      nir_op_fadd,
      0, 2,
      { 0, 233 },
      -1,
   } },

   /* replace70 -> 1 in the cache */

   /* ('fadd', ('fsat', 'a'), ('fsat', ('fneg', 'a'))) => ('fsat', ('fabs', 'a')) */
   /* search71_0_0 -> 9 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fsat,
      -1, 0,
      { 9 },
      -1,
   } },
   /* search71_1_0_0 -> 9 in the cache */
   /* search71_1_0 -> 118 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fsat,
      -1, 0,
      { 118 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fadd,
      0, 1,
      { 235, 236 },
      -1,
   } },

   /* replace71_0_0 -> 9 in the cache */
   /* replace71_0 -> 11 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fsat,
      -1, 0,
      { 11 },
      -1,
   } },

   /* ('~fmul', 'a', 0.0) => 0.0 */
   /* search72_0 -> 9 in the cache */
   /* search72_1 -> 8 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      true,
      false,
      false,
      false,
      false,
      false,
      nir_op_fmul,
      0, 1,
      { 9, 8 },
      -1,
   } },

   /* replace72 -> 8 in the cache */

   /* ('fmul(nsz,nnan)', 'a', 0.0) => 0.0 */
   /* search73_0 -> 9 in the cache */
   /* search73_1 -> 8 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      true,
      true,
      false,
      nir_op_fmul,
      0, 1,
      { 9, 8 },
      -1,
   } },

   /* replace73 -> 8 in the cache */

   /* ('fmulz', 'a', 0.0) => 0.0 */
   /* search74_0 -> 29 in the cache */
   { .constant = {
      { nir_search_value_constant, 32 },
      nir_type_float, { 0x0ull /* 0.0 */ },
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fmulz,
      0, 1,
      { 29, 241 },
      -1,
   } },

   /* replace74 -> 241 in the cache */

   /* ('fmulz(nsz)', 'a', 'b(is_finite_not_zero)') => ('fmul', 'a', 'b') */
   /* search75_0 -> 29 in the cache */
   { .variable = {
      { nir_search_value_variable, 32 },
      1, /* b */
      false,
      nir_type_invalid,
      3,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      true,
      false,
      false,
      nir_op_fmulz,
      0, 1,
      { 29, 243 },
      -1,
   } },

   /* replace75_0 -> 29 in the cache */
   /* replace75_1 -> 48 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fmul,
      0, 1,
      { 29, 48 },
      -1,
   } },

   /* ('fmulz', 'a(is_finite)', 'b(is_finite)') => ('fmul', 'a', 'b') */
   { .variable = {
      { nir_search_value_variable, 32 },
      0, /* a */
      false,
      nir_type_invalid,
      4,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .variable = {
      { nir_search_value_variable, 32 },
      1, /* b */
      false,
      nir_type_invalid,
      4,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fmulz,
      0, 1,
      { 246, 247 },
      -1,
   } },

   /* replace76_0 -> 29 in the cache */
   /* replace76_1 -> 48 in the cache */
   /* replace76 -> 245 in the cache */

   /* ('fmulz', 'a', 'a') => ('fmul', 'a', 'a') */
   /* search77_0 -> 29 in the cache */
   /* search77_1 -> 29 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fmulz,
      -1, 0,
      { 29, 29 },
      -1,
   } },

   /* replace77_0 -> 29 in the cache */
   /* replace77_1 -> 29 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fmul,
      -1, 0,
      { 29, 29 },
      -1,
   } },

   /* ('ffmaz(nsz)', 'a', 'b(is_finite_not_zero)', 'c') => ('ffma', 'a', 'b', 'c') */
   /* search78_0 -> 29 in the cache */
   /* search78_1 -> 243 in the cache */
   /* search78_2 -> 148 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      true,
      false,
      false,
      nir_op_ffmaz,
      0, 1,
      { 29, 243, 148 },
      -1,
   } },

   /* replace78_0 -> 29 in the cache */
   /* replace78_1 -> 48 in the cache */
   /* replace78_2 -> 148 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ffma,
      0, 1,
      { 29, 48, 148 },
      -1,
   } },

   /* ('ffmaz', 'a(is_finite)', 'b(is_finite)', 'c') => ('ffma', 'a', 'b', 'c') */
   /* search79_0 -> 246 in the cache */
   /* search79_1 -> 247 in the cache */
   /* search79_2 -> 148 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ffmaz,
      0, 1,
      { 246, 247, 148 },
      -1,
   } },

   /* replace79_0 -> 29 in the cache */
   /* replace79_1 -> 48 in the cache */
   /* replace79_2 -> 148 in the cache */
   /* replace79 -> 252 in the cache */

   /* ('ffmaz', 'a', 'a', 'b') => ('ffma', 'a', 'a', 'b') */
   /* search80_0 -> 29 in the cache */
   /* search80_1 -> 29 in the cache */
   /* search80_2 -> 48 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ffmaz,
      -1, 0,
      { 29, 29, 48 },
      -1,
   } },

   /* replace80_0 -> 29 in the cache */
   /* replace80_1 -> 29 in the cache */
   /* replace80_2 -> 48 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ffma,
      -1, 0,
      { 29, 29, 48 },
      -1,
   } },

   /* ('imul', 'a', 0) => 0 */
   /* search81_0 -> 9 in the cache */
   /* search81_1 -> 73 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_imul,
      0, 1,
      { 9, 73 },
      -1,
   } },

   /* replace81 -> 73 in the cache */

   /* ('umul_unorm_4x8_vc4', 'a', 0) => 0 */
   /* search82_0 -> 29 in the cache */
   /* search82_1 -> 135 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_umul_unorm_4x8_vc4,
      0, 1,
      { 29, 135 },
      -1,
   } },

   /* replace82 -> 135 in the cache */

   /* ('umul_unorm_4x8_vc4', 'a', -1) => a */
   /* search83_0 -> 29 in the cache */
   /* search83_1 -> 137 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_umul_unorm_4x8_vc4,
      0, 1,
      { 29, 137 },
      -1,
   } },

   /* replace83 -> 29 in the cache */

   /* ('~fmul', 'a', 1.0) => a */
   /* search84_0 -> 9 in the cache */
   { .constant = {
      { nir_search_value_constant, -1 },
      nir_type_float, { 0x3ff0000000000000ull /* 1.0 */ },
   } },
   { .expression = {
      { nir_search_value_expression, -1 },
      true,
      false,
      false,
      false,
      false,
      false,
      nir_op_fmul,
      0, 1,
      { 9, 259 },
      -1,
   } },

   /* replace84 -> 9 in the cache */

   /* ('~fmulz', 'a', 1.0) => a */
   /* search85_0 -> 29 in the cache */
   { .constant = {
      { nir_search_value_constant, 32 },
      nir_type_float, { 0x3ff0000000000000ull /* 1.0 */ },
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      true,
      false,
      false,
      false,
      false,
      false,
      nir_op_fmulz,
      0, 1,
      { 29, 261 },
      -1,
   } },

   /* replace85 -> 29 in the cache */

   /* ('fmul(is_only_used_as_float)', 'a', 1.0) => a */
   /* search86_0 -> 9 in the cache */
   /* search86_1 -> 259 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fmul,
      0, 1,
      { 9, 259 },
      1,
   } },

   /* replace86 -> 9 in the cache */

   /* ('imul', 'a', 1) => a */
   /* search87_0 -> 9 in the cache */
   /* search87_1 -> 47 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_imul,
      0, 1,
      { 9, 47 },
      -1,
   } },

   /* replace87 -> 9 in the cache */

   /* ('fmul', 'a', -1.0) => ('fneg', 'a') */
   /* search88_0 -> 9 in the cache */
   { .constant = {
      { nir_search_value_constant, -1 },
      nir_type_float, { 0xbff0000000000000ull /* -1.0 */ },
   } },
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fmul,
      0, 1,
      { 9, 265 },
      -1,
   } },

   /* replace88_0 -> 9 in the cache */
   /* replace88 -> 118 in the cache */

   /* ('imul', 'a', -1) => ('ineg', 'a') */
   /* search89_0 -> 9 in the cache */
   /* search89_1 -> 75 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_imul,
      0, 1,
      { 9, 75 },
      -1,
   } },

   /* replace89_0 -> 9 in the cache */
   /* replace89 -> 120 in the cache */

   /* ('fmul', ('fsign', 'a'), ('fmul', 'a', 'a')) => ('fmul', ('fabs', 'a'), 'a') */
   /* search90_0_0 -> 9 in the cache */
   /* search90_0 -> 110 in the cache */
   /* search90_1_0 -> 9 in the cache */
   /* search90_1_1 -> 9 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fmul,
      -1, 0,
      { 9, 9 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fmul,
      0, 1,
      { 110, 268 },
      -1,
   } },

   /* replace90_0_0 -> 9 in the cache */
   /* replace90_0 -> 11 in the cache */
   /* replace90_1 -> 9 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fmul,
      0, 1,
      { 11, 9 },
      -1,
   } },

   /* ('fmul', ('fmul', ('fsign', 'a'), 'a'), 'a') => ('fmul', ('fabs', 'a'), 'a') */
   /* search91_0_0_0 -> 9 in the cache */
   /* search91_0_0 -> 110 in the cache */
   /* search91_0_1 -> 9 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fmul,
      1, 1,
      { 110, 9 },
      -1,
   } },
   /* search91_1 -> 9 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fmul,
      0, 2,
      { 271, 9 },
      -1,
   } },

   /* replace91_0_0 -> 9 in the cache */
   /* replace91_0 -> 11 in the cache */
   /* replace91_1 -> 9 in the cache */
   /* replace91 -> 270 in the cache */

   /* ('~ffma', 0.0, 'a', 'b') => b */
   { .constant = {
      { nir_search_value_constant, -2 },
      nir_type_float, { 0x0ull /* 0.0 */ },
   } },
   /* search92_1 -> 0 in the cache */
   /* search92_2 -> 1 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      true,
      false,
      false,
      false,
      false,
      false,
      nir_op_ffma,
      0, 1,
      { 273, 0, 1 },
      -1,
   } },

   /* replace92 -> 1 in the cache */

   /* ('ffma(is_only_used_as_float,nsz,nnan,ninf)', 0.0, 'a', 'b') => b */
   /* search93_0 -> 273 in the cache */
   /* search93_1 -> 0 in the cache */
   /* search93_2 -> 1 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      true,
      true,
      true,
      nir_op_ffma,
      0, 1,
      { 273, 0, 1 },
      1,
   } },

   /* replace93 -> 1 in the cache */

   /* ('ffmaz', 0.0, 'a', 'b') => ('fadd', 0.0, 'b') */
   /* search94_0 -> 241 in the cache */
   /* search94_1 -> 29 in the cache */
   /* search94_2 -> 48 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ffmaz,
      0, 1,
      { 241, 29, 48 },
      -1,
   } },

   /* replace94_0 -> 241 in the cache */
   /* replace94_1 -> 48 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fadd,
      0, 1,
      { 241, 48 },
      -1,
   } },

   /* ('~ffma', 'a', 'b', 0.0) => ('fmul', 'a', 'b') */
   /* search95_0 -> 0 in the cache */
   /* search95_1 -> 1 in the cache */
   /* search95_2 -> 273 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      true,
      false,
      false,
      false,
      false,
      false,
      nir_op_ffma,
      0, 1,
      { 0, 1, 273 },
      -1,
   } },

   /* replace95_0 -> 0 in the cache */
   /* replace95_1 -> 1 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fmul,
      0, 1,
      { 0, 1 },
      -1,
   } },

   /* ('ffma(nsz)', 'a', 'b', 0.0) => ('fmul', 'a', 'b') */
   /* search96_0 -> 0 in the cache */
   /* search96_1 -> 1 in the cache */
   /* search96_2 -> 273 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      true,
      false,
      false,
      nir_op_ffma,
      0, 1,
      { 0, 1, 273 },
      -1,
   } },

   /* replace96_0 -> 0 in the cache */
   /* replace96_1 -> 1 in the cache */
   /* replace96 -> 279 in the cache */

   /* ('ffmaz(nsz)', 'a', 'b', 0.0) => ('fmulz', 'a', 'b') */
   /* search97_0 -> 29 in the cache */
   /* search97_1 -> 48 in the cache */
   /* search97_2 -> 241 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      true,
      false,
      false,
      nir_op_ffmaz,
      0, 1,
      { 29, 48, 241 },
      -1,
   } },

   /* replace97_0 -> 29 in the cache */
   /* replace97_1 -> 48 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fmulz,
      0, 1,
      { 29, 48 },
      -1,
   } },

   /* ('ffma', 1.0, 'a', 'b') => ('fadd', 'a', 'b') */
   { .constant = {
      { nir_search_value_constant, -2 },
      nir_type_float, { 0x3ff0000000000000ull /* 1.0 */ },
   } },
   /* search98_1 -> 0 in the cache */
   /* search98_2 -> 1 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ffma,
      0, 1,
      { 283, 0, 1 },
      -1,
   } },

   /* replace98_0 -> 0 in the cache */
   /* replace98_1 -> 1 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fadd,
      0, 1,
      { 0, 1 },
      -1,
   } },

   /* ('ffmaz(nsz)', 1.0, 'a', 'b') => ('fadd', 'a', 'b') */
   /* search99_0 -> 261 in the cache */
   /* search99_1 -> 29 in the cache */
   /* search99_2 -> 48 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      true,
      false,
      false,
      nir_op_ffmaz,
      0, 1,
      { 261, 29, 48 },
      -1,
   } },

   /* replace99_0 -> 29 in the cache */
   /* replace99_1 -> 48 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fadd,
      0, 1,
      { 29, 48 },
      -1,
   } },

   /* ('ffma', -1.0, 'a', 'b') => ('fadd', ('fneg', 'a'), 'b') */
   { .constant = {
      { nir_search_value_constant, -2 },
      nir_type_float, { 0xbff0000000000000ull /* -1.0 */ },
   } },
   /* search100_1 -> 0 in the cache */
   /* search100_2 -> 1 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ffma,
      0, 1,
      { 288, 0, 1 },
      -1,
   } },

   /* replace100_0_0 -> 0 in the cache */
   /* replace100_0 -> 230 in the cache */
   /* replace100_1 -> 1 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fadd,
      0, 1,
      { 230, 1 },
      -1,
   } },

   /* ('ffmaz(nsz)', -1.0, 'a', 'b') => ('fadd', ('fneg', 'a'), 'b') */
   { .constant = {
      { nir_search_value_constant, 32 },
      nir_type_float, { 0xbff0000000000000ull /* -1.0 */ },
   } },
   /* search101_1 -> 29 in the cache */
   /* search101_2 -> 48 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      true,
      false,
      false,
      nir_op_ffmaz,
      0, 1,
      { 291, 29, 48 },
      -1,
   } },

   /* replace101_0_0 -> 29 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fneg,
      -1, 0,
      { 29 },
      -1,
   } },
   /* replace101_1 -> 48 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fadd,
      0, 1,
      { 293, 48 },
      -1,
   } },

   /* ('~ffma', '#a', '#b', 'c') => ('fadd', ('fmul', 'a', 'b'), 'c') */
   { .variable = {
      { nir_search_value_variable, -3 },
      0, /* a */
      true,
      nir_type_invalid,
      -1,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .variable = {
      { nir_search_value_variable, -3 },
      1, /* b */
      true,
      nir_type_invalid,
      -1,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   /* search102_2 -> 142 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      true,
      false,
      false,
      false,
      false,
      false,
      nir_op_ffma,
      0, 1,
      { 295, 296, 142 },
      -1,
   } },

   /* replace102_0_0 -> 139 in the cache */
   /* replace102_0_1 -> 140 in the cache */
   /* replace102_0 -> 141 in the cache */
   /* replace102_1 -> 142 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fadd,
      0, 2,
      { 141, 142 },
      -1,
   } },

   /* ('~ffmaz', '#a', '#b', 'c') => ('fadd', ('fmulz', 'a', 'b'), 'c') */
   { .variable = {
      { nir_search_value_variable, 32 },
      0, /* a */
      true,
      nir_type_invalid,
      -1,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   /* search103_1 -> 45 in the cache */
   /* search103_2 -> 148 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      true,
      false,
      false,
      false,
      false,
      false,
      nir_op_ffmaz,
      0, 1,
      { 299, 45, 148 },
      -1,
   } },

   /* replace103_0_0 -> 29 in the cache */
   /* replace103_0_1 -> 48 in the cache */
   /* replace103_0 -> 147 in the cache */
   /* replace103_1 -> 148 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fadd,
      0, 2,
      { 147, 148 },
      -1,
   } },

   /* ('~flrp', 'a', 'b', 0.0) => a */
   /* search104_0 -> 0 in the cache */
   /* search104_1 -> 1 in the cache */
   /* search104_2 -> 273 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      true,
      false,
      false,
      false,
      false,
      false,
      nir_op_flrp,
      -1, 0,
      { 0, 1, 273 },
      -1,
   } },

   /* replace104 -> 0 in the cache */

   /* ('~flrp', 'a', 'b', 1.0) => b */
   /* search105_0 -> 0 in the cache */
   /* search105_1 -> 1 in the cache */
   /* search105_2 -> 283 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      true,
      false,
      false,
      false,
      false,
      false,
      nir_op_flrp,
      -1, 0,
      { 0, 1, 283 },
      -1,
   } },

   /* replace105 -> 1 in the cache */

   /* ('~flrp', 'a', 'a', 'b') => a */
   /* search106_0 -> 0 in the cache */
   /* search106_1 -> 0 in the cache */
   /* search106_2 -> 1 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      true,
      false,
      false,
      false,
      false,
      false,
      nir_op_flrp,
      -1, 0,
      { 0, 0, 1 },
      -1,
   } },

   /* replace106 -> 0 in the cache */

   /* ('~flrp', 0.0, 'a', 'b') => ('fmul', 'a', 'b') */
   /* search107_0 -> 273 in the cache */
   /* search107_1 -> 0 in the cache */
   /* search107_2 -> 1 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      true,
      false,
      false,
      false,
      false,
      false,
      nir_op_flrp,
      -1, 0,
      { 273, 0, 1 },
      -1,
   } },

   /* replace107_0 -> 0 in the cache */
   /* replace107_1 -> 1 in the cache */
   /* replace107 -> 279 in the cache */

   /* ('~flrp', 'a', ('fadd(is_used_once)', 'a', 'b'), 'c') => ('fadd', ('fmul', 'b', 'c'), 'a') */
   /* search108_0 -> 139 in the cache */
   /* search108_1_0 -> 139 in the cache */
   /* search108_1_1 -> 140 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fadd,
      0, 1,
      { 139, 140 },
      0,
   } },
   /* search108_2 -> 142 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      true,
      false,
      false,
      false,
      false,
      false,
      nir_op_flrp,
      -1, 1,
      { 139, 306, 142 },
      -1,
   } },

   /* replace108_0_0 -> 140 in the cache */
   /* replace108_0_1 -> 142 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fmul,
      1, 1,
      { 140, 142 },
      -1,
   } },
   /* replace108_1 -> 139 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fadd,
      0, 2,
      { 308, 139 },
      -1,
   } },

   /* ('sdot_4x8_iadd', 'a', 0, 'b') => b */
   /* search109_0 -> 29 in the cache */
   /* search109_1 -> 135 in the cache */
   /* search109_2 -> 48 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_sdot_4x8_iadd,
      0, 1,
      { 29, 135, 48 },
      -1,
   } },

   /* replace109 -> 48 in the cache */

   /* ('udot_4x8_uadd', 'a', 0, 'b') => b */
   /* search110_0 -> 29 in the cache */
   /* search110_1 -> 135 in the cache */
   /* search110_2 -> 48 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_udot_4x8_uadd,
      0, 1,
      { 29, 135, 48 },
      -1,
   } },

   /* replace110 -> 48 in the cache */

   /* ('sdot_4x8_iadd_sat', 'a', 0, 'b') => b */
   /* search111_0 -> 29 in the cache */
   /* search111_1 -> 135 in the cache */
   /* search111_2 -> 48 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_sdot_4x8_iadd_sat,
      0, 1,
      { 29, 135, 48 },
      -1,
   } },

   /* replace111 -> 48 in the cache */

   /* ('udot_4x8_uadd_sat', 'a', 0, 'b') => b */
   /* search112_0 -> 29 in the cache */
   /* search112_1 -> 135 in the cache */
   /* search112_2 -> 48 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_udot_4x8_uadd_sat,
      0, 1,
      { 29, 135, 48 },
      -1,
   } },

   /* replace112 -> 48 in the cache */

   /* ('sdot_2x16_iadd', 'a', 0, 'b') => b */
   /* search113_0 -> 29 in the cache */
   /* search113_1 -> 135 in the cache */
   /* search113_2 -> 48 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_sdot_2x16_iadd,
      0, 1,
      { 29, 135, 48 },
      -1,
   } },

   /* replace113 -> 48 in the cache */

   /* ('udot_2x16_uadd', 'a', 0, 'b') => b */
   /* search114_0 -> 29 in the cache */
   /* search114_1 -> 135 in the cache */
   /* search114_2 -> 48 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_udot_2x16_uadd,
      0, 1,
      { 29, 135, 48 },
      -1,
   } },

   /* replace114 -> 48 in the cache */

   /* ('sdot_2x16_iadd_sat', 'a', 0, 'b') => b */
   /* search115_0 -> 29 in the cache */
   /* search115_1 -> 135 in the cache */
   /* search115_2 -> 48 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_sdot_2x16_iadd_sat,
      0, 1,
      { 29, 135, 48 },
      -1,
   } },

   /* replace115 -> 48 in the cache */

   /* ('udot_2x16_uadd_sat', 'a', 0, 'b') => b */
   /* search116_0 -> 29 in the cache */
   /* search116_1 -> 135 in the cache */
   /* search116_2 -> 48 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_udot_2x16_uadd_sat,
      0, 1,
      { 29, 135, 48 },
      -1,
   } },

   /* replace116 -> 48 in the cache */

   /* ('sudot_4x8_iadd', 'a', 0, 'b') => b */
   /* search117_0 -> 29 in the cache */
   /* search117_1 -> 135 in the cache */
   /* search117_2 -> 48 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_sudot_4x8_iadd,
      -1, 0,
      { 29, 135, 48 },
      -1,
   } },

   /* replace117 -> 48 in the cache */

   /* ('sudot_4x8_iadd', 0, 'a', 'b') => b */
   /* search118_0 -> 135 in the cache */
   /* search118_1 -> 29 in the cache */
   /* search118_2 -> 48 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_sudot_4x8_iadd,
      -1, 0,
      { 135, 29, 48 },
      -1,
   } },

   /* replace118 -> 48 in the cache */

   /* ('sudot_4x8_iadd_sat', 'a', 0, 'b') => b */
   /* search119_0 -> 29 in the cache */
   /* search119_1 -> 135 in the cache */
   /* search119_2 -> 48 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_sudot_4x8_iadd_sat,
      -1, 0,
      { 29, 135, 48 },
      -1,
   } },

   /* replace119 -> 48 in the cache */

   /* ('sudot_4x8_iadd_sat', 0, 'a', 'b') => b */
   /* search120_0 -> 135 in the cache */
   /* search120_1 -> 29 in the cache */
   /* search120_2 -> 48 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_sudot_4x8_iadd_sat,
      -1, 0,
      { 135, 29, 48 },
      -1,
   } },

   /* replace120 -> 48 in the cache */

   /* ('iadd', ('sdot_4x8_iadd(is_used_once)', 'a', 'b', '#c'), '#d') => ('sdot_4x8_iadd', 'a', 'b', ('iadd', 'c', 'd')) */
   /* search121_0_0 -> 29 in the cache */
   /* search121_0_1 -> 48 in the cache */
   { .variable = {
      { nir_search_value_variable, 32 },
      2, /* c */
      true,
      nir_type_invalid,
      -1,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_sdot_4x8_iadd,
      1, 1,
      { 29, 48, 322 },
      0,
   } },
   { .variable = {
      { nir_search_value_variable, 32 },
      3, /* d */
      true,
      nir_type_invalid,
      -1,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_iadd,
      0, 2,
      { 323, 324 },
      -1,
   } },

   /* replace121_0 -> 29 in the cache */
   /* replace121_1 -> 48 in the cache */
   /* replace121_2_0 -> 148 in the cache */
   /* replace121_2_1 -> 176 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_iadd,
      1, 1,
      { 148, 176 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_sdot_4x8_iadd,
      0, 2,
      { 29, 48, 326 },
      -1,
   } },

   /* ('iadd', ('udot_4x8_uadd(is_used_once)', 'a', 'b', '#c'), '#d') => ('udot_4x8_uadd', 'a', 'b', ('iadd', 'c', 'd')) */
   /* search122_0_0 -> 29 in the cache */
   /* search122_0_1 -> 48 in the cache */
   /* search122_0_2 -> 322 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_udot_4x8_uadd,
      1, 1,
      { 29, 48, 322 },
      0,
   } },
   /* search122_1 -> 324 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_iadd,
      0, 2,
      { 328, 324 },
      -1,
   } },

   /* replace122_0 -> 29 in the cache */
   /* replace122_1 -> 48 in the cache */
   /* replace122_2_0 -> 148 in the cache */
   /* replace122_2_1 -> 176 in the cache */
   /* replace122_2 -> 326 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_udot_4x8_uadd,
      0, 2,
      { 29, 48, 326 },
      -1,
   } },

   /* ('iadd', ('sudot_4x8_iadd(is_used_once)', 'a', 'b', '#c'), '#d') => ('sudot_4x8_iadd', 'a', 'b', ('iadd', 'c', 'd')) */
   /* search123_0_0 -> 29 in the cache */
   /* search123_0_1 -> 48 in the cache */
   /* search123_0_2 -> 322 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_sudot_4x8_iadd,
      -1, 0,
      { 29, 48, 322 },
      0,
   } },
   /* search123_1 -> 324 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_iadd,
      0, 1,
      { 331, 324 },
      -1,
   } },

   /* replace123_0 -> 29 in the cache */
   /* replace123_1 -> 48 in the cache */
   /* replace123_2_0 -> 148 in the cache */
   /* replace123_2_1 -> 176 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_iadd,
      0, 1,
      { 148, 176 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_sudot_4x8_iadd,
      -1, 1,
      { 29, 48, 333 },
      -1,
   } },

   /* ('iadd', ('sdot_2x16_iadd(is_used_once)', 'a', 'b', '#c'), '#d') => ('sdot_2x16_iadd', 'a', 'b', ('iadd', 'c', 'd')) */
   /* search124_0_0 -> 29 in the cache */
   /* search124_0_1 -> 48 in the cache */
   /* search124_0_2 -> 322 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_sdot_2x16_iadd,
      1, 1,
      { 29, 48, 322 },
      0,
   } },
   /* search124_1 -> 324 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_iadd,
      0, 2,
      { 335, 324 },
      -1,
   } },

   /* replace124_0 -> 29 in the cache */
   /* replace124_1 -> 48 in the cache */
   /* replace124_2_0 -> 148 in the cache */
   /* replace124_2_1 -> 176 in the cache */
   /* replace124_2 -> 326 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_sdot_2x16_iadd,
      0, 2,
      { 29, 48, 326 },
      -1,
   } },

   /* ('iadd', ('udot_2x16_uadd(is_used_once)', 'a', 'b', '#c'), '#d') => ('udot_2x16_uadd', 'a', 'b', ('iadd', 'c', 'd')) */
   /* search125_0_0 -> 29 in the cache */
   /* search125_0_1 -> 48 in the cache */
   /* search125_0_2 -> 322 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_udot_2x16_uadd,
      1, 1,
      { 29, 48, 322 },
      0,
   } },
   /* search125_1 -> 324 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_iadd,
      0, 2,
      { 338, 324 },
      -1,
   } },

   /* replace125_0 -> 29 in the cache */
   /* replace125_1 -> 48 in the cache */
   /* replace125_2_0 -> 148 in the cache */
   /* replace125_2_1 -> 176 in the cache */
   /* replace125_2 -> 326 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_udot_2x16_uadd,
      0, 2,
      { 29, 48, 326 },
      -1,
   } },

   /* ('iadd', ('sdot_4x8_iadd', 'a(is_not_const)', 'b', 0), 'c') => ('sdot_4x8_iadd', 'a', 'b', 'c') */
   { .variable = {
      { nir_search_value_variable, 32 },
      0, /* a */
      false,
      nir_type_invalid,
      5,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   /* search126_0_1 -> 48 in the cache */
   /* search126_0_2 -> 135 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_sdot_4x8_iadd,
      1, 1,
      { 341, 48, 135 },
      -1,
   } },
   /* search126_1 -> 148 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_iadd,
      0, 2,
      { 342, 148 },
      -1,
   } },

   /* replace126_0 -> 29 in the cache */
   /* replace126_1 -> 48 in the cache */
   /* replace126_2 -> 148 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_sdot_4x8_iadd,
      0, 1,
      { 29, 48, 148 },
      -1,
   } },

   /* ('iadd', ('udot_4x8_uadd', 'a(is_not_const)', 'b', 0), 'c') => ('udot_4x8_uadd', 'a', 'b', 'c') */
   /* search127_0_0 -> 341 in the cache */
   /* search127_0_1 -> 48 in the cache */
   /* search127_0_2 -> 135 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_udot_4x8_uadd,
      1, 1,
      { 341, 48, 135 },
      -1,
   } },
   /* search127_1 -> 148 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_iadd,
      0, 2,
      { 345, 148 },
      -1,
   } },

   /* replace127_0 -> 29 in the cache */
   /* replace127_1 -> 48 in the cache */
   /* replace127_2 -> 148 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_udot_4x8_uadd,
      0, 1,
      { 29, 48, 148 },
      -1,
   } },

   /* ('iadd', ('sudot_4x8_iadd', 'a(is_not_const)', 'b', 0), 'c') => ('sudot_4x8_iadd', 'a', 'b', 'c') */
   /* search128_0_0 -> 341 in the cache */
   /* search128_0_1 -> 48 in the cache */
   /* search128_0_2 -> 135 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_sudot_4x8_iadd,
      -1, 0,
      { 341, 48, 135 },
      -1,
   } },
   /* search128_1 -> 148 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_iadd,
      0, 1,
      { 348, 148 },
      -1,
   } },

   /* replace128_0 -> 29 in the cache */
   /* replace128_1 -> 48 in the cache */
   /* replace128_2 -> 148 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_sudot_4x8_iadd,
      -1, 0,
      { 29, 48, 148 },
      -1,
   } },

   /* ('iadd', ('sudot_4x8_iadd', 'a', 'b(is_not_const)', 0), 'c') => ('sudot_4x8_iadd', 'a', 'b', 'c') */
   /* search129_0_0 -> 29 in the cache */
   { .variable = {
      { nir_search_value_variable, 32 },
      1, /* b */
      false,
      nir_type_invalid,
      5,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   /* search129_0_2 -> 135 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_sudot_4x8_iadd,
      -1, 0,
      { 29, 351, 135 },
      -1,
   } },
   /* search129_1 -> 148 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_iadd,
      0, 1,
      { 352, 148 },
      -1,
   } },

   /* replace129_0 -> 29 in the cache */
   /* replace129_1 -> 48 in the cache */
   /* replace129_2 -> 148 in the cache */
   /* replace129 -> 350 in the cache */

   /* ('iadd', ('sdot_2x16_iadd', 'a(is_not_const)', 'b', 0), 'c') => ('sdot_2x16_iadd', 'a', 'b', 'c') */
   /* search130_0_0 -> 341 in the cache */
   /* search130_0_1 -> 48 in the cache */
   /* search130_0_2 -> 135 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_sdot_2x16_iadd,
      1, 1,
      { 341, 48, 135 },
      -1,
   } },
   /* search130_1 -> 148 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_iadd,
      0, 2,
      { 354, 148 },
      -1,
   } },

   /* replace130_0 -> 29 in the cache */
   /* replace130_1 -> 48 in the cache */
   /* replace130_2 -> 148 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_sdot_2x16_iadd,
      0, 1,
      { 29, 48, 148 },
      -1,
   } },

   /* ('iadd', ('udot_2x16_uadd', 'a(is_not_const)', 'b', 0), 'c') => ('udot_2x16_uadd', 'a', 'b', 'c') */
   /* search131_0_0 -> 341 in the cache */
   /* search131_0_1 -> 48 in the cache */
   /* search131_0_2 -> 135 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_udot_2x16_uadd,
      1, 1,
      { 341, 48, 135 },
      -1,
   } },
   /* search131_1 -> 148 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_iadd,
      0, 2,
      { 357, 148 },
      -1,
   } },

   /* replace131_0 -> 29 in the cache */
   /* replace131_1 -> 48 in the cache */
   /* replace131_2 -> 148 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_udot_2x16_uadd,
      0, 1,
      { 29, 48, 148 },
      -1,
   } },

   /* ('sdot_4x8_iadd', '#a', '#b', 'c(is_not_const)') => ('iadd', ('sdot_4x8_iadd', 'a', 'b', 0), 'c') */
   /* search132_0 -> 299 in the cache */
   /* search132_1 -> 45 in the cache */
   { .variable = {
      { nir_search_value_variable, 32 },
      2, /* c */
      false,
      nir_type_invalid,
      5,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_sdot_4x8_iadd,
      0, 1,
      { 299, 45, 360 },
      -1,
   } },

   /* replace132_0_0 -> 29 in the cache */
   /* replace132_0_1 -> 48 in the cache */
   /* replace132_0_2 -> 135 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_sdot_4x8_iadd,
      1, 1,
      { 29, 48, 135 },
      -1,
   } },
   /* replace132_1 -> 148 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_iadd,
      0, 2,
      { 362, 148 },
      -1,
   } },

   /* ('udot_4x8_uadd', '#a', '#b', 'c(is_not_const)') => ('iadd', ('udot_4x8_uadd', 'a', 'b', 0), 'c') */
   /* search133_0 -> 299 in the cache */
   /* search133_1 -> 45 in the cache */
   /* search133_2 -> 360 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_udot_4x8_uadd,
      0, 1,
      { 299, 45, 360 },
      -1,
   } },

   /* replace133_0_0 -> 29 in the cache */
   /* replace133_0_1 -> 48 in the cache */
   /* replace133_0_2 -> 135 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_udot_4x8_uadd,
      1, 1,
      { 29, 48, 135 },
      -1,
   } },
   /* replace133_1 -> 148 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_iadd,
      0, 2,
      { 365, 148 },
      -1,
   } },

   /* ('sudot_4x8_iadd', '#a', '#b', 'c(is_not_const)') => ('iadd', ('sudot_4x8_iadd', 'a', 'b', 0), 'c') */
   /* search134_0 -> 299 in the cache */
   /* search134_1 -> 45 in the cache */
   /* search134_2 -> 360 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_sudot_4x8_iadd,
      -1, 0,
      { 299, 45, 360 },
      -1,
   } },

   /* replace134_0_0 -> 29 in the cache */
   /* replace134_0_1 -> 48 in the cache */
   /* replace134_0_2 -> 135 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_sudot_4x8_iadd,
      -1, 0,
      { 29, 48, 135 },
      -1,
   } },
   /* replace134_1 -> 148 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_iadd,
      0, 1,
      { 368, 148 },
      -1,
   } },

   /* ('sdot_2x16_iadd', '#a', '#b', 'c(is_not_const)') => ('iadd', ('sdot_2x16_iadd', 'a', 'b', 0), 'c') */
   /* search135_0 -> 299 in the cache */
   /* search135_1 -> 45 in the cache */
   /* search135_2 -> 360 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_sdot_2x16_iadd,
      0, 1,
      { 299, 45, 360 },
      -1,
   } },

   /* replace135_0_0 -> 29 in the cache */
   /* replace135_0_1 -> 48 in the cache */
   /* replace135_0_2 -> 135 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_sdot_2x16_iadd,
      1, 1,
      { 29, 48, 135 },
      -1,
   } },
   /* replace135_1 -> 148 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_iadd,
      0, 2,
      { 371, 148 },
      -1,
   } },

   /* ('udot_2x16_uadd', '#a', '#b', 'c(is_not_const)') => ('iadd', ('udot_2x16_uadd', 'a', 'b', 0), 'c') */
   /* search136_0 -> 299 in the cache */
   /* search136_1 -> 45 in the cache */
   /* search136_2 -> 360 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_udot_2x16_uadd,
      0, 1,
      { 299, 45, 360 },
      -1,
   } },

   /* replace136_0_0 -> 29 in the cache */
   /* replace136_0_1 -> 48 in the cache */
   /* replace136_0_2 -> 135 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_udot_2x16_uadd,
      1, 1,
      { 29, 48, 135 },
      -1,
   } },
   /* replace136_1 -> 148 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_iadd,
      0, 2,
      { 374, 148 },
      -1,
   } },

   /* ('sdot_4x8_iadd_sat', '#a', '#b', 'c(is_not_const)') => ('iadd_sat', ('sdot_4x8_iadd', 'a', 'b', 0), 'c') */
   /* search137_0 -> 299 in the cache */
   /* search137_1 -> 45 in the cache */
   /* search137_2 -> 360 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_sdot_4x8_iadd_sat,
      0, 1,
      { 299, 45, 360 },
      -1,
   } },

   /* replace137_0_0 -> 29 in the cache */
   /* replace137_0_1 -> 48 in the cache */
   /* replace137_0_2 -> 135 in the cache */
   /* replace137_0 -> 362 in the cache */
   /* replace137_1 -> 148 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_iadd_sat,
      0, 2,
      { 362, 148 },
      -1,
   } },

   /* ('udot_4x8_uadd_sat', '#a', '#b', 'c(is_not_const)') => ('uadd_sat', ('udot_4x8_uadd', 'a', 'b', 0), 'c') */
   /* search138_0 -> 299 in the cache */
   /* search138_1 -> 45 in the cache */
   /* search138_2 -> 360 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_udot_4x8_uadd_sat,
      0, 1,
      { 299, 45, 360 },
      -1,
   } },

   /* replace138_0_0 -> 29 in the cache */
   /* replace138_0_1 -> 48 in the cache */
   /* replace138_0_2 -> 135 in the cache */
   /* replace138_0 -> 365 in the cache */
   /* replace138_1 -> 148 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_uadd_sat,
      0, 2,
      { 365, 148 },
      -1,
   } },

   /* ('sudot_4x8_iadd_sat', '#a', '#b', 'c(is_not_const)') => ('iadd_sat', ('sudot_4x8_iadd', 'a', 'b', 0), 'c') */
   /* search139_0 -> 299 in the cache */
   /* search139_1 -> 45 in the cache */
   /* search139_2 -> 360 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_sudot_4x8_iadd_sat,
      -1, 0,
      { 299, 45, 360 },
      -1,
   } },

   /* replace139_0_0 -> 29 in the cache */
   /* replace139_0_1 -> 48 in the cache */
   /* replace139_0_2 -> 135 in the cache */
   /* replace139_0 -> 368 in the cache */
   /* replace139_1 -> 148 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_iadd_sat,
      0, 1,
      { 368, 148 },
      -1,
   } },

   /* ('sdot_2x16_iadd_sat', '#a', '#b', 'c(is_not_const)') => ('iadd_sat', ('sdot_2x16_iadd', 'a', 'b', 0), 'c') */
   /* search140_0 -> 299 in the cache */
   /* search140_1 -> 45 in the cache */
   /* search140_2 -> 360 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_sdot_2x16_iadd_sat,
      0, 1,
      { 299, 45, 360 },
      -1,
   } },

   /* replace140_0_0 -> 29 in the cache */
   /* replace140_0_1 -> 48 in the cache */
   /* replace140_0_2 -> 135 in the cache */
   /* replace140_0 -> 371 in the cache */
   /* replace140_1 -> 148 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_iadd_sat,
      0, 2,
      { 371, 148 },
      -1,
   } },

   /* ('udot_2x16_uadd_sat', '#a', '#b', 'c(is_not_const)') => ('uadd_sat', ('udot_2x16_uadd', 'a', 'b', 0), 'c') */
   /* search141_0 -> 299 in the cache */
   /* search141_1 -> 45 in the cache */
   /* search141_2 -> 360 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_udot_2x16_uadd_sat,
      0, 1,
      { 299, 45, 360 },
      -1,
   } },

   /* replace141_0_0 -> 29 in the cache */
   /* replace141_0_1 -> 48 in the cache */
   /* replace141_0_2 -> 135 in the cache */
   /* replace141_0 -> 374 in the cache */
   /* replace141_1 -> 148 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_uadd_sat,
      0, 2,
      { 374, 148 },
      -1,
   } },

   /* ('fmul@32(nsz)', ('bcsel', ('feq', 'b', 0.0, 'ignore_exact'), 0.0, ('fneg', ('fabs', 'a'))), ('bcsel', ('feq', 'a', 0.0, 'ignore_exact'), 0.0, ('fneg', ('fabs', 'b')))) => ('fmulz', ('fneg', ('fabs', 'a')), ('fneg', ('fabs', 'b'))) */
   { .variable = {
      { nir_search_value_variable, 32 },
      0, /* b */
      false,
      nir_type_invalid,
      -1,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   /* search142_0_0_1 -> 241 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      true,
      false,
      false,
      false,
      nir_op_feq,
      1, 1,
      { 386, 241 },
      -1,
   } },
   /* search142_0_1 -> 241 in the cache */
   /* search142_0_2_0_0 -> 196 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fabs,
      -1, 0,
      { 196 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fneg,
      -1, 0,
      { 388 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_bcsel,
      -1, 1,
      { 387, 241, 389 },
      -1,
   } },
   /* search142_1_0_0 -> 196 in the cache */
   /* search142_1_0_1 -> 241 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      true,
      false,
      false,
      false,
      nir_op_feq,
      2, 1,
      { 196, 241 },
      -1,
   } },
   /* search142_1_1 -> 241 in the cache */
   /* search142_1_2_0_0 -> 386 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fabs,
      -1, 0,
      { 386 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fneg,
      -1, 0,
      { 392 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_bcsel,
      -1, 1,
      { 391, 241, 393 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      true,
      false,
      false,
      nir_op_fmul,
      0, 3,
      { 390, 394 },
      -1,
   } },

   /* replace142_0_0_0 -> 196 in the cache */
   /* replace142_0_0 -> 388 in the cache */
   /* replace142_0 -> 389 in the cache */
   /* replace142_1_0_0 -> 386 in the cache */
   /* replace142_1_0 -> 392 in the cache */
   /* replace142_1 -> 393 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fmulz,
      0, 1,
      { 389, 393 },
      -1,
   } },

   /* ('fmul@32(nsz)', ('bcsel', ('feq', 'b', 0.0, 'ignore_exact'), 0.0, ('fneg', ('fabs', 'a'))), ('bcsel', ('feq', 'a', 0.0, 'ignore_exact'), 0.0, ('fabs', 'b'))) => ('fmulz', ('fneg', ('fabs', 'a')), ('fabs', 'b')) */
   /* search143_0_0_0 -> 386 in the cache */
   /* search143_0_0_1 -> 241 in the cache */
   /* search143_0_0 -> 387 in the cache */
   /* search143_0_1 -> 241 in the cache */
   /* search143_0_2_0_0 -> 196 in the cache */
   /* search143_0_2_0 -> 388 in the cache */
   /* search143_0_2 -> 389 in the cache */
   /* search143_0 -> 390 in the cache */
   /* search143_1_0_0 -> 196 in the cache */
   /* search143_1_0_1 -> 241 in the cache */
   /* search143_1_0 -> 391 in the cache */
   /* search143_1_1 -> 241 in the cache */
   /* search143_1_2_0 -> 386 in the cache */
   /* search143_1_2 -> 392 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_bcsel,
      -1, 1,
      { 391, 241, 392 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      true,
      false,
      false,
      nir_op_fmul,
      0, 3,
      { 390, 397 },
      -1,
   } },

   /* replace143_0_0_0 -> 196 in the cache */
   /* replace143_0_0 -> 388 in the cache */
   /* replace143_0 -> 389 in the cache */
   /* replace143_1_0 -> 386 in the cache */
   /* replace143_1 -> 392 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fmulz,
      0, 1,
      { 389, 392 },
      -1,
   } },

   /* ('fmul@32(nsz)', ('bcsel', ('feq', 'b', 0.0, 'ignore_exact'), 0.0, ('fneg', ('fabs', 'a'))), ('bcsel', ('feq', 'a', 0.0, 'ignore_exact'), 0.0, ('fneg', 'b'))) => ('fmulz', ('fneg', ('fabs', 'a')), ('fneg', 'b')) */
   /* search144_0_0_0 -> 386 in the cache */
   /* search144_0_0_1 -> 241 in the cache */
   /* search144_0_0 -> 387 in the cache */
   /* search144_0_1 -> 241 in the cache */
   /* search144_0_2_0_0 -> 196 in the cache */
   /* search144_0_2_0 -> 388 in the cache */
   /* search144_0_2 -> 389 in the cache */
   /* search144_0 -> 390 in the cache */
   /* search144_1_0_0 -> 196 in the cache */
   /* search144_1_0_1 -> 241 in the cache */
   /* search144_1_0 -> 391 in the cache */
   /* search144_1_1 -> 241 in the cache */
   /* search144_1_2_0 -> 386 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fneg,
      -1, 0,
      { 386 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_bcsel,
      -1, 1,
      { 391, 241, 400 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      true,
      false,
      false,
      nir_op_fmul,
      0, 3,
      { 390, 401 },
      -1,
   } },

   /* replace144_0_0_0 -> 196 in the cache */
   /* replace144_0_0 -> 388 in the cache */
   /* replace144_0 -> 389 in the cache */
   /* replace144_1_0 -> 386 in the cache */
   /* replace144_1 -> 400 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fmulz,
      0, 1,
      { 389, 400 },
      -1,
   } },

   /* ('fmul@32(nsz)', ('bcsel', ('feq', 'b', 0.0, 'ignore_exact'), 0.0, ('fneg', ('fabs', 'a'))), ('bcsel', ('feq', 'a', 0.0, 'ignore_exact'), 0.0, 'b')) => ('fmulz', ('fneg', ('fabs', 'a')), 'b') */
   /* search145_0_0_0 -> 386 in the cache */
   /* search145_0_0_1 -> 241 in the cache */
   /* search145_0_0 -> 387 in the cache */
   /* search145_0_1 -> 241 in the cache */
   /* search145_0_2_0_0 -> 196 in the cache */
   /* search145_0_2_0 -> 388 in the cache */
   /* search145_0_2 -> 389 in the cache */
   /* search145_0 -> 390 in the cache */
   /* search145_1_0_0 -> 196 in the cache */
   /* search145_1_0_1 -> 241 in the cache */
   /* search145_1_0 -> 391 in the cache */
   /* search145_1_1 -> 241 in the cache */
   /* search145_1_2 -> 386 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_bcsel,
      -1, 1,
      { 391, 241, 386 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      true,
      false,
      false,
      nir_op_fmul,
      0, 3,
      { 390, 404 },
      -1,
   } },

   /* replace145_0_0_0 -> 196 in the cache */
   /* replace145_0_0 -> 388 in the cache */
   /* replace145_0 -> 389 in the cache */
   /* replace145_1 -> 386 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fmulz,
      0, 1,
      { 389, 386 },
      -1,
   } },

   /* ('fmul@32(nsz)', ('bcsel', ('feq', 'b', 0.0, 'ignore_exact'), 0.0, ('fabs', 'a')), ('bcsel', ('feq', 'a', 0.0, 'ignore_exact'), 0.0, ('fabs', 'b'))) => ('fmulz', ('fabs', 'a'), ('fabs', 'b')) */
   /* search146_0_0_0 -> 386 in the cache */
   /* search146_0_0_1 -> 241 in the cache */
   /* search146_0_0 -> 387 in the cache */
   /* search146_0_1 -> 241 in the cache */
   /* search146_0_2_0 -> 196 in the cache */
   /* search146_0_2 -> 388 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_bcsel,
      -1, 1,
      { 387, 241, 388 },
      -1,
   } },
   /* search146_1_0_0 -> 196 in the cache */
   /* search146_1_0_1 -> 241 in the cache */
   /* search146_1_0 -> 391 in the cache */
   /* search146_1_1 -> 241 in the cache */
   /* search146_1_2_0 -> 386 in the cache */
   /* search146_1_2 -> 392 in the cache */
   /* search146_1 -> 397 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      true,
      false,
      false,
      nir_op_fmul,
      0, 3,
      { 407, 397 },
      -1,
   } },

   /* replace146_0_0 -> 196 in the cache */
   /* replace146_0 -> 388 in the cache */
   /* replace146_1_0 -> 386 in the cache */
   /* replace146_1 -> 392 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fmulz,
      0, 1,
      { 388, 392 },
      -1,
   } },

   /* ('fmul@32(nsz)', ('bcsel', ('feq', 'b', 0.0, 'ignore_exact'), 0.0, ('fabs', 'a')), ('bcsel', ('feq', 'a', 0.0, 'ignore_exact'), 0.0, ('fneg', 'b'))) => ('fmulz', ('fabs', 'a'), ('fneg', 'b')) */
   /* search147_0_0_0 -> 386 in the cache */
   /* search147_0_0_1 -> 241 in the cache */
   /* search147_0_0 -> 387 in the cache */
   /* search147_0_1 -> 241 in the cache */
   /* search147_0_2_0 -> 196 in the cache */
   /* search147_0_2 -> 388 in the cache */
   /* search147_0 -> 407 in the cache */
   /* search147_1_0_0 -> 196 in the cache */
   /* search147_1_0_1 -> 241 in the cache */
   /* search147_1_0 -> 391 in the cache */
   /* search147_1_1 -> 241 in the cache */
   /* search147_1_2_0 -> 386 in the cache */
   /* search147_1_2 -> 400 in the cache */
   /* search147_1 -> 401 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      true,
      false,
      false,
      nir_op_fmul,
      0, 3,
      { 407, 401 },
      -1,
   } },

   /* replace147_0_0 -> 196 in the cache */
   /* replace147_0 -> 388 in the cache */
   /* replace147_1_0 -> 386 in the cache */
   /* replace147_1 -> 400 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fmulz,
      0, 1,
      { 388, 400 },
      -1,
   } },

   /* ('fmul@32(nsz)', ('bcsel', ('feq', 'b', 0.0, 'ignore_exact'), 0.0, ('fabs', 'a')), ('bcsel', ('feq', 'a', 0.0, 'ignore_exact'), 0.0, 'b')) => ('fmulz', ('fabs', 'a'), 'b') */
   /* search148_0_0_0 -> 386 in the cache */
   /* search148_0_0_1 -> 241 in the cache */
   /* search148_0_0 -> 387 in the cache */
   /* search148_0_1 -> 241 in the cache */
   /* search148_0_2_0 -> 196 in the cache */
   /* search148_0_2 -> 388 in the cache */
   /* search148_0 -> 407 in the cache */
   /* search148_1_0_0 -> 196 in the cache */
   /* search148_1_0_1 -> 241 in the cache */
   /* search148_1_0 -> 391 in the cache */
   /* search148_1_1 -> 241 in the cache */
   /* search148_1_2 -> 386 in the cache */
   /* search148_1 -> 404 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      true,
      false,
      false,
      nir_op_fmul,
      0, 3,
      { 407, 404 },
      -1,
   } },

   /* replace148_0_0 -> 196 in the cache */
   /* replace148_0 -> 388 in the cache */
   /* replace148_1 -> 386 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fmulz,
      0, 1,
      { 388, 386 },
      -1,
   } },

   /* ('fmul@32(nsz)', ('bcsel', ('feq', 'b', 0.0, 'ignore_exact'), 0.0, ('fneg', 'a')), ('bcsel', ('feq', 'a', 0.0, 'ignore_exact'), 0.0, ('fneg', 'b'))) => ('fmulz', ('fneg', 'a'), ('fneg', 'b')) */
   /* search149_0_0_0 -> 386 in the cache */
   /* search149_0_0_1 -> 241 in the cache */
   /* search149_0_0 -> 387 in the cache */
   /* search149_0_1 -> 241 in the cache */
   /* search149_0_2_0 -> 196 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fneg,
      -1, 0,
      { 196 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_bcsel,
      -1, 1,
      { 387, 241, 414 },
      -1,
   } },
   /* search149_1_0_0 -> 196 in the cache */
   /* search149_1_0_1 -> 241 in the cache */
   /* search149_1_0 -> 391 in the cache */
   /* search149_1_1 -> 241 in the cache */
   /* search149_1_2_0 -> 386 in the cache */
   /* search149_1_2 -> 400 in the cache */
   /* search149_1 -> 401 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      true,
      false,
      false,
      nir_op_fmul,
      0, 3,
      { 415, 401 },
      -1,
   } },

   /* replace149_0_0 -> 196 in the cache */
   /* replace149_0 -> 414 in the cache */
   /* replace149_1_0 -> 386 in the cache */
   /* replace149_1 -> 400 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fmulz,
      0, 1,
      { 414, 400 },
      -1,
   } },

   /* ('fmul@32(nsz)', ('bcsel', ('feq', 'b', 0.0, 'ignore_exact'), 0.0, ('fneg', 'a')), ('bcsel', ('feq', 'a', 0.0, 'ignore_exact'), 0.0, 'b')) => ('fmulz', ('fneg', 'a'), 'b') */
   /* search150_0_0_0 -> 386 in the cache */
   /* search150_0_0_1 -> 241 in the cache */
   /* search150_0_0 -> 387 in the cache */
   /* search150_0_1 -> 241 in the cache */
   /* search150_0_2_0 -> 196 in the cache */
   /* search150_0_2 -> 414 in the cache */
   /* search150_0 -> 415 in the cache */
   /* search150_1_0_0 -> 196 in the cache */
   /* search150_1_0_1 -> 241 in the cache */
   /* search150_1_0 -> 391 in the cache */
   /* search150_1_1 -> 241 in the cache */
   /* search150_1_2 -> 386 in the cache */
   /* search150_1 -> 404 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      true,
      false,
      false,
      nir_op_fmul,
      0, 3,
      { 415, 404 },
      -1,
   } },

   /* replace150_0_0 -> 196 in the cache */
   /* replace150_0 -> 414 in the cache */
   /* replace150_1 -> 386 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fmulz,
      0, 1,
      { 414, 386 },
      -1,
   } },

   /* ('fmul@32(nsz)', ('bcsel', ('feq', 'b', 0.0, 'ignore_exact'), 0.0, 'a'), ('bcsel', ('feq', 'a', 0.0, 'ignore_exact'), 0.0, 'b')) => ('fmulz', 'a', 'b') */
   /* search151_0_0_0 -> 386 in the cache */
   /* search151_0_0_1 -> 241 in the cache */
   /* search151_0_0 -> 387 in the cache */
   /* search151_0_1 -> 241 in the cache */
   /* search151_0_2 -> 196 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_bcsel,
      -1, 1,
      { 387, 241, 196 },
      -1,
   } },
   /* search151_1_0_0 -> 196 in the cache */
   /* search151_1_0_1 -> 241 in the cache */
   /* search151_1_0 -> 391 in the cache */
   /* search151_1_1 -> 241 in the cache */
   /* search151_1_2 -> 386 in the cache */
   /* search151_1 -> 404 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      true,
      false,
      false,
      nir_op_fmul,
      0, 3,
      { 420, 404 },
      -1,
   } },

   /* replace151_0 -> 196 in the cache */
   /* replace151_1 -> 386 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fmulz,
      0, 1,
      { 196, 386 },
      -1,
   } },

   /* ('fmul@32(nsz)', ('fneg', ('fabs', 'a')), ('bcsel', ('feq', 'a', 0.0, 'ignore_exact'), 0.0, '#b(is_not_const_zero)')) => ('fmulz', ('fneg', ('fabs', 'a')), 'b') */
   /* search152_0_0_0 -> 29 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fabs,
      -1, 0,
      { 29 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fneg,
      -1, 0,
      { 423 },
      -1,
   } },
   /* search152_1_0_0 -> 29 in the cache */
   /* search152_1_0_1 -> 241 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      true,
      false,
      false,
      false,
      nir_op_feq,
      1, 1,
      { 29, 241 },
      -1,
   } },
   /* search152_1_1 -> 241 in the cache */
   { .variable = {
      { nir_search_value_variable, 32 },
      1, /* b */
      true,
      nir_type_invalid,
      6,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_bcsel,
      -1, 1,
      { 425, 241, 426 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      true,
      false,
      false,
      nir_op_fmul,
      0, 2,
      { 424, 427 },
      -1,
   } },

   /* replace152_0_0_0 -> 29 in the cache */
   /* replace152_0_0 -> 423 in the cache */
   /* replace152_0 -> 424 in the cache */
   /* replace152_1 -> 48 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fmulz,
      0, 1,
      { 424, 48 },
      -1,
   } },

   /* ('fmul@32(nsz)', ('fabs', 'a'), ('bcsel', ('feq', 'a', 0.0, 'ignore_exact'), 0.0, '#b(is_not_const_zero)')) => ('fmulz', ('fabs', 'a'), 'b') */
   /* search153_0_0 -> 29 in the cache */
   /* search153_0 -> 423 in the cache */
   /* search153_1_0_0 -> 29 in the cache */
   /* search153_1_0_1 -> 241 in the cache */
   /* search153_1_0 -> 425 in the cache */
   /* search153_1_1 -> 241 in the cache */
   /* search153_1_2 -> 426 in the cache */
   /* search153_1 -> 427 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      true,
      false,
      false,
      nir_op_fmul,
      0, 2,
      { 423, 427 },
      -1,
   } },

   /* replace153_0_0 -> 29 in the cache */
   /* replace153_0 -> 423 in the cache */
   /* replace153_1 -> 48 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fmulz,
      0, 1,
      { 423, 48 },
      -1,
   } },

   /* ('fmul@32(nsz)', ('fneg', 'a'), ('bcsel', ('feq', 'a', 0.0, 'ignore_exact'), 0.0, '#b(is_not_const_zero)')) => ('fmulz', ('fneg', 'a'), 'b') */
   /* search154_0_0 -> 29 in the cache */
   /* search154_0 -> 293 in the cache */
   /* search154_1_0_0 -> 29 in the cache */
   /* search154_1_0_1 -> 241 in the cache */
   /* search154_1_0 -> 425 in the cache */
   /* search154_1_1 -> 241 in the cache */
   /* search154_1_2 -> 426 in the cache */
   /* search154_1 -> 427 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      true,
      false,
      false,
      nir_op_fmul,
      0, 2,
      { 293, 427 },
      -1,
   } },

   /* replace154_0_0 -> 29 in the cache */
   /* replace154_0 -> 293 in the cache */
   /* replace154_1 -> 48 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fmulz,
      0, 1,
      { 293, 48 },
      -1,
   } },

   /* ('fmul@32(nsz)', 'a', ('bcsel', ('feq', 'a', 0.0, 'ignore_exact'), 0.0, '#b(is_not_const_zero)')) => ('fmulz', 'a', 'b') */
   /* search155_0 -> 29 in the cache */
   /* search155_1_0_0 -> 29 in the cache */
   /* search155_1_0_1 -> 241 in the cache */
   /* search155_1_0 -> 425 in the cache */
   /* search155_1_1 -> 241 in the cache */
   /* search155_1_2 -> 426 in the cache */
   /* search155_1 -> 427 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      true,
      false,
      false,
      nir_op_fmul,
      0, 2,
      { 29, 427 },
      -1,
   } },

   /* replace155_0 -> 29 in the cache */
   /* replace155_1 -> 48 in the cache */
   /* replace155 -> 282 in the cache */

   /* ('ffma@32(nsz)', ('bcsel', ('feq', 'b', 0.0, 'ignore_exact'), 0.0, ('fneg', ('fabs', 'a'))), ('bcsel', ('feq', 'a', 0.0, 'ignore_exact'), 0.0, ('fneg', ('fabs', 'b'))), 'c') => ('ffmaz', ('fneg', ('fabs', 'a')), ('fneg', ('fabs', 'b')), 'c') */
   /* search156_0_0_0 -> 386 in the cache */
   /* search156_0_0_1 -> 241 in the cache */
   /* search156_0_0 -> 387 in the cache */
   /* search156_0_1 -> 241 in the cache */
   /* search156_0_2_0_0 -> 196 in the cache */
   /* search156_0_2_0 -> 388 in the cache */
   /* search156_0_2 -> 389 in the cache */
   /* search156_0 -> 390 in the cache */
   /* search156_1_0_0 -> 196 in the cache */
   /* search156_1_0_1 -> 241 in the cache */
   /* search156_1_0 -> 391 in the cache */
   /* search156_1_1 -> 241 in the cache */
   /* search156_1_2_0_0 -> 386 in the cache */
   /* search156_1_2_0 -> 392 in the cache */
   /* search156_1_2 -> 393 in the cache */
   /* search156_1 -> 394 in the cache */
   /* search156_2 -> 148 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      true,
      false,
      false,
      nir_op_ffma,
      0, 3,
      { 390, 394, 148 },
      -1,
   } },

   /* replace156_0_0_0 -> 196 in the cache */
   /* replace156_0_0 -> 388 in the cache */
   /* replace156_0 -> 389 in the cache */
   /* replace156_1_0_0 -> 386 in the cache */
   /* replace156_1_0 -> 392 in the cache */
   /* replace156_1 -> 393 in the cache */
   /* replace156_2 -> 148 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ffmaz,
      0, 1,
      { 389, 393, 148 },
      -1,
   } },

   /* ('ffma@32(nsz)', ('bcsel', ('feq', 'b', 0.0, 'ignore_exact'), 0.0, ('fneg', ('fabs', 'a'))), ('bcsel', ('feq', 'a', 0.0, 'ignore_exact'), 0.0, ('fabs', 'b')), 'c') => ('ffmaz', ('fneg', ('fabs', 'a')), ('fabs', 'b'), 'c') */
   /* search157_0_0_0 -> 386 in the cache */
   /* search157_0_0_1 -> 241 in the cache */
   /* search157_0_0 -> 387 in the cache */
   /* search157_0_1 -> 241 in the cache */
   /* search157_0_2_0_0 -> 196 in the cache */
   /* search157_0_2_0 -> 388 in the cache */
   /* search157_0_2 -> 389 in the cache */
   /* search157_0 -> 390 in the cache */
   /* search157_1_0_0 -> 196 in the cache */
   /* search157_1_0_1 -> 241 in the cache */
   /* search157_1_0 -> 391 in the cache */
   /* search157_1_1 -> 241 in the cache */
   /* search157_1_2_0 -> 386 in the cache */
   /* search157_1_2 -> 392 in the cache */
   /* search157_1 -> 397 in the cache */
   /* search157_2 -> 148 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      true,
      false,
      false,
      nir_op_ffma,
      0, 3,
      { 390, 397, 148 },
      -1,
   } },

   /* replace157_0_0_0 -> 196 in the cache */
   /* replace157_0_0 -> 388 in the cache */
   /* replace157_0 -> 389 in the cache */
   /* replace157_1_0 -> 386 in the cache */
   /* replace157_1 -> 392 in the cache */
   /* replace157_2 -> 148 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ffmaz,
      0, 1,
      { 389, 392, 148 },
      -1,
   } },

   /* ('ffma@32(nsz)', ('bcsel', ('feq', 'b', 0.0, 'ignore_exact'), 0.0, ('fneg', ('fabs', 'a'))), ('bcsel', ('feq', 'a', 0.0, 'ignore_exact'), 0.0, ('fneg', 'b')), 'c') => ('ffmaz', ('fneg', ('fabs', 'a')), ('fneg', 'b'), 'c') */
   /* search158_0_0_0 -> 386 in the cache */
   /* search158_0_0_1 -> 241 in the cache */
   /* search158_0_0 -> 387 in the cache */
   /* search158_0_1 -> 241 in the cache */
   /* search158_0_2_0_0 -> 196 in the cache */
   /* search158_0_2_0 -> 388 in the cache */
   /* search158_0_2 -> 389 in the cache */
   /* search158_0 -> 390 in the cache */
   /* search158_1_0_0 -> 196 in the cache */
   /* search158_1_0_1 -> 241 in the cache */
   /* search158_1_0 -> 391 in the cache */
   /* search158_1_1 -> 241 in the cache */
   /* search158_1_2_0 -> 386 in the cache */
   /* search158_1_2 -> 400 in the cache */
   /* search158_1 -> 401 in the cache */
   /* search158_2 -> 148 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      true,
      false,
      false,
      nir_op_ffma,
      0, 3,
      { 390, 401, 148 },
      -1,
   } },

   /* replace158_0_0_0 -> 196 in the cache */
   /* replace158_0_0 -> 388 in the cache */
   /* replace158_0 -> 389 in the cache */
   /* replace158_1_0 -> 386 in the cache */
   /* replace158_1 -> 400 in the cache */
   /* replace158_2 -> 148 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ffmaz,
      0, 1,
      { 389, 400, 148 },
      -1,
   } },

   /* ('ffma@32(nsz)', ('bcsel', ('feq', 'b', 0.0, 'ignore_exact'), 0.0, ('fneg', ('fabs', 'a'))), ('bcsel', ('feq', 'a', 0.0, 'ignore_exact'), 0.0, 'b'), 'c') => ('ffmaz', ('fneg', ('fabs', 'a')), 'b', 'c') */
   /* search159_0_0_0 -> 386 in the cache */
   /* search159_0_0_1 -> 241 in the cache */
   /* search159_0_0 -> 387 in the cache */
   /* search159_0_1 -> 241 in the cache */
   /* search159_0_2_0_0 -> 196 in the cache */
   /* search159_0_2_0 -> 388 in the cache */
   /* search159_0_2 -> 389 in the cache */
   /* search159_0 -> 390 in the cache */
   /* search159_1_0_0 -> 196 in the cache */
   /* search159_1_0_1 -> 241 in the cache */
   /* search159_1_0 -> 391 in the cache */
   /* search159_1_1 -> 241 in the cache */
   /* search159_1_2 -> 386 in the cache */
   /* search159_1 -> 404 in the cache */
   /* search159_2 -> 148 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      true,
      false,
      false,
      nir_op_ffma,
      0, 3,
      { 390, 404, 148 },
      -1,
   } },

   /* replace159_0_0_0 -> 196 in the cache */
   /* replace159_0_0 -> 388 in the cache */
   /* replace159_0 -> 389 in the cache */
   /* replace159_1 -> 386 in the cache */
   /* replace159_2 -> 148 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ffmaz,
      0, 1,
      { 389, 386, 148 },
      -1,
   } },

   /* ('ffma@32(nsz)', ('bcsel', ('feq', 'b', 0.0, 'ignore_exact'), 0.0, ('fabs', 'a')), ('bcsel', ('feq', 'a', 0.0, 'ignore_exact'), 0.0, ('fabs', 'b')), 'c') => ('ffmaz', ('fabs', 'a'), ('fabs', 'b'), 'c') */
   /* search160_0_0_0 -> 386 in the cache */
   /* search160_0_0_1 -> 241 in the cache */
   /* search160_0_0 -> 387 in the cache */
   /* search160_0_1 -> 241 in the cache */
   /* search160_0_2_0 -> 196 in the cache */
   /* search160_0_2 -> 388 in the cache */
   /* search160_0 -> 407 in the cache */
   /* search160_1_0_0 -> 196 in the cache */
   /* search160_1_0_1 -> 241 in the cache */
   /* search160_1_0 -> 391 in the cache */
   /* search160_1_1 -> 241 in the cache */
   /* search160_1_2_0 -> 386 in the cache */
   /* search160_1_2 -> 392 in the cache */
   /* search160_1 -> 397 in the cache */
   /* search160_2 -> 148 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      true,
      false,
      false,
      nir_op_ffma,
      0, 3,
      { 407, 397, 148 },
      -1,
   } },

   /* replace160_0_0 -> 196 in the cache */
   /* replace160_0 -> 388 in the cache */
   /* replace160_1_0 -> 386 in the cache */
   /* replace160_1 -> 392 in the cache */
   /* replace160_2 -> 148 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ffmaz,
      0, 1,
      { 388, 392, 148 },
      -1,
   } },

   /* ('ffma@32(nsz)', ('bcsel', ('feq', 'b', 0.0, 'ignore_exact'), 0.0, ('fabs', 'a')), ('bcsel', ('feq', 'a', 0.0, 'ignore_exact'), 0.0, ('fneg', 'b')), 'c') => ('ffmaz', ('fabs', 'a'), ('fneg', 'b'), 'c') */
   /* search161_0_0_0 -> 386 in the cache */
   /* search161_0_0_1 -> 241 in the cache */
   /* search161_0_0 -> 387 in the cache */
   /* search161_0_1 -> 241 in the cache */
   /* search161_0_2_0 -> 196 in the cache */
   /* search161_0_2 -> 388 in the cache */
   /* search161_0 -> 407 in the cache */
   /* search161_1_0_0 -> 196 in the cache */
   /* search161_1_0_1 -> 241 in the cache */
   /* search161_1_0 -> 391 in the cache */
   /* search161_1_1 -> 241 in the cache */
   /* search161_1_2_0 -> 386 in the cache */
   /* search161_1_2 -> 400 in the cache */
   /* search161_1 -> 401 in the cache */
   /* search161_2 -> 148 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      true,
      false,
      false,
      nir_op_ffma,
      0, 3,
      { 407, 401, 148 },
      -1,
   } },

   /* replace161_0_0 -> 196 in the cache */
   /* replace161_0 -> 388 in the cache */
   /* replace161_1_0 -> 386 in the cache */
   /* replace161_1 -> 400 in the cache */
   /* replace161_2 -> 148 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ffmaz,
      0, 1,
      { 388, 400, 148 },
      -1,
   } },

   /* ('ffma@32(nsz)', ('bcsel', ('feq', 'b', 0.0, 'ignore_exact'), 0.0, ('fabs', 'a')), ('bcsel', ('feq', 'a', 0.0, 'ignore_exact'), 0.0, 'b'), 'c') => ('ffmaz', ('fabs', 'a'), 'b', 'c') */
   /* search162_0_0_0 -> 386 in the cache */
   /* search162_0_0_1 -> 241 in the cache */
   /* search162_0_0 -> 387 in the cache */
   /* search162_0_1 -> 241 in the cache */
   /* search162_0_2_0 -> 196 in the cache */
   /* search162_0_2 -> 388 in the cache */
   /* search162_0 -> 407 in the cache */
   /* search162_1_0_0 -> 196 in the cache */
   /* search162_1_0_1 -> 241 in the cache */
   /* search162_1_0 -> 391 in the cache */
   /* search162_1_1 -> 241 in the cache */
   /* search162_1_2 -> 386 in the cache */
   /* search162_1 -> 404 in the cache */
   /* search162_2 -> 148 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      true,
      false,
      false,
      nir_op_ffma,
      0, 3,
      { 407, 404, 148 },
      -1,
   } },

   /* replace162_0_0 -> 196 in the cache */
   /* replace162_0 -> 388 in the cache */
   /* replace162_1 -> 386 in the cache */
   /* replace162_2 -> 148 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ffmaz,
      0, 1,
      { 388, 386, 148 },
      -1,
   } },

   /* ('ffma@32(nsz)', ('bcsel', ('feq', 'b', 0.0, 'ignore_exact'), 0.0, ('fneg', 'a')), ('bcsel', ('feq', 'a', 0.0, 'ignore_exact'), 0.0, ('fneg', 'b')), 'c') => ('ffmaz', ('fneg', 'a'), ('fneg', 'b'), 'c') */
   /* search163_0_0_0 -> 386 in the cache */
   /* search163_0_0_1 -> 241 in the cache */
   /* search163_0_0 -> 387 in the cache */
   /* search163_0_1 -> 241 in the cache */
   /* search163_0_2_0 -> 196 in the cache */
   /* search163_0_2 -> 414 in the cache */
   /* search163_0 -> 415 in the cache */
   /* search163_1_0_0 -> 196 in the cache */
   /* search163_1_0_1 -> 241 in the cache */
   /* search163_1_0 -> 391 in the cache */
   /* search163_1_1 -> 241 in the cache */
   /* search163_1_2_0 -> 386 in the cache */
   /* search163_1_2 -> 400 in the cache */
   /* search163_1 -> 401 in the cache */
   /* search163_2 -> 148 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      true,
      false,
      false,
      nir_op_ffma,
      0, 3,
      { 415, 401, 148 },
      -1,
   } },

   /* replace163_0_0 -> 196 in the cache */
   /* replace163_0 -> 414 in the cache */
   /* replace163_1_0 -> 386 in the cache */
   /* replace163_1 -> 400 in the cache */
   /* replace163_2 -> 148 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ffmaz,
      0, 1,
      { 414, 400, 148 },
      -1,
   } },

   /* ('ffma@32(nsz)', ('bcsel', ('feq', 'b', 0.0, 'ignore_exact'), 0.0, ('fneg', 'a')), ('bcsel', ('feq', 'a', 0.0, 'ignore_exact'), 0.0, 'b'), 'c') => ('ffmaz', ('fneg', 'a'), 'b', 'c') */
   /* search164_0_0_0 -> 386 in the cache */
   /* search164_0_0_1 -> 241 in the cache */
   /* search164_0_0 -> 387 in the cache */
   /* search164_0_1 -> 241 in the cache */
   /* search164_0_2_0 -> 196 in the cache */
   /* search164_0_2 -> 414 in the cache */
   /* search164_0 -> 415 in the cache */
   /* search164_1_0_0 -> 196 in the cache */
   /* search164_1_0_1 -> 241 in the cache */
   /* search164_1_0 -> 391 in the cache */
   /* search164_1_1 -> 241 in the cache */
   /* search164_1_2 -> 386 in the cache */
   /* search164_1 -> 404 in the cache */
   /* search164_2 -> 148 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      true,
      false,
      false,
      nir_op_ffma,
      0, 3,
      { 415, 404, 148 },
      -1,
   } },

   /* replace164_0_0 -> 196 in the cache */
   /* replace164_0 -> 414 in the cache */
   /* replace164_1 -> 386 in the cache */
   /* replace164_2 -> 148 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ffmaz,
      0, 1,
      { 414, 386, 148 },
      -1,
   } },

   /* ('ffma@32(nsz)', ('bcsel', ('feq', 'b', 0.0, 'ignore_exact'), 0.0, 'a'), ('bcsel', ('feq', 'a', 0.0, 'ignore_exact'), 0.0, 'b'), 'c') => ('ffmaz', 'a', 'b', 'c') */
   /* search165_0_0_0 -> 386 in the cache */
   /* search165_0_0_1 -> 241 in the cache */
   /* search165_0_0 -> 387 in the cache */
   /* search165_0_1 -> 241 in the cache */
   /* search165_0_2 -> 196 in the cache */
   /* search165_0 -> 420 in the cache */
   /* search165_1_0_0 -> 196 in the cache */
   /* search165_1_0_1 -> 241 in the cache */
   /* search165_1_0 -> 391 in the cache */
   /* search165_1_1 -> 241 in the cache */
   /* search165_1_2 -> 386 in the cache */
   /* search165_1 -> 404 in the cache */
   /* search165_2 -> 148 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      true,
      false,
      false,
      nir_op_ffma,
      0, 3,
      { 420, 404, 148 },
      -1,
   } },

   /* replace165_0 -> 196 in the cache */
   /* replace165_1 -> 386 in the cache */
   /* replace165_2 -> 148 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ffmaz,
      0, 1,
      { 196, 386, 148 },
      -1,
   } },

   /* ('ffma@32(nsz)', ('fneg', ('fabs', 'a')), ('bcsel', ('feq', 'a', 0.0, 'ignore_exact'), 0.0, '#b(is_not_const_zero)'), 'c') => ('ffmaz', ('fneg', ('fabs', 'a')), 'b', 'c') */
   /* search166_0_0_0 -> 29 in the cache */
   /* search166_0_0 -> 423 in the cache */
   /* search166_0 -> 424 in the cache */
   /* search166_1_0_0 -> 29 in the cache */
   /* search166_1_0_1 -> 241 in the cache */
   /* search166_1_0 -> 425 in the cache */
   /* search166_1_1 -> 241 in the cache */
   /* search166_1_2 -> 426 in the cache */
   /* search166_1 -> 427 in the cache */
   /* search166_2 -> 148 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      true,
      false,
      false,
      nir_op_ffma,
      0, 2,
      { 424, 427, 148 },
      -1,
   } },

   /* replace166_0_0_0 -> 29 in the cache */
   /* replace166_0_0 -> 423 in the cache */
   /* replace166_0 -> 424 in the cache */
   /* replace166_1 -> 48 in the cache */
   /* replace166_2 -> 148 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ffmaz,
      0, 1,
      { 424, 48, 148 },
      -1,
   } },

   /* ('ffma@32(nsz)', ('fabs', 'a'), ('bcsel', ('feq', 'a', 0.0, 'ignore_exact'), 0.0, '#b(is_not_const_zero)'), 'c') => ('ffmaz', ('fabs', 'a'), 'b', 'c') */
   /* search167_0_0 -> 29 in the cache */
   /* search167_0 -> 423 in the cache */
   /* search167_1_0_0 -> 29 in the cache */
   /* search167_1_0_1 -> 241 in the cache */
   /* search167_1_0 -> 425 in the cache */
   /* search167_1_1 -> 241 in the cache */
   /* search167_1_2 -> 426 in the cache */
   /* search167_1 -> 427 in the cache */
   /* search167_2 -> 148 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      true,
      false,
      false,
      nir_op_ffma,
      0, 2,
      { 423, 427, 148 },
      -1,
   } },

   /* replace167_0_0 -> 29 in the cache */
   /* replace167_0 -> 423 in the cache */
   /* replace167_1 -> 48 in the cache */
   /* replace167_2 -> 148 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ffmaz,
      0, 1,
      { 423, 48, 148 },
      -1,
   } },

   /* ('ffma@32(nsz)', ('fneg', 'a'), ('bcsel', ('feq', 'a', 0.0, 'ignore_exact'), 0.0, '#b(is_not_const_zero)'), 'c') => ('ffmaz', ('fneg', 'a'), 'b', 'c') */
   /* search168_0_0 -> 29 in the cache */
   /* search168_0 -> 293 in the cache */
   /* search168_1_0_0 -> 29 in the cache */
   /* search168_1_0_1 -> 241 in the cache */
   /* search168_1_0 -> 425 in the cache */
   /* search168_1_1 -> 241 in the cache */
   /* search168_1_2 -> 426 in the cache */
   /* search168_1 -> 427 in the cache */
   /* search168_2 -> 148 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      true,
      false,
      false,
      nir_op_ffma,
      0, 2,
      { 293, 427, 148 },
      -1,
   } },

   /* replace168_0_0 -> 29 in the cache */
   /* replace168_0 -> 293 in the cache */
   /* replace168_1 -> 48 in the cache */
   /* replace168_2 -> 148 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ffmaz,
      0, 1,
      { 293, 48, 148 },
      -1,
   } },

   /* ('ffma@32(nsz)', 'a', ('bcsel', ('feq', 'a', 0.0, 'ignore_exact'), 0.0, '#b(is_not_const_zero)'), 'c') => ('ffmaz', 'a', 'b', 'c') */
   /* search169_0 -> 29 in the cache */
   /* search169_1_0_0 -> 29 in the cache */
   /* search169_1_0_1 -> 241 in the cache */
   /* search169_1_0 -> 425 in the cache */
   /* search169_1_1 -> 241 in the cache */
   /* search169_1_2 -> 426 in the cache */
   /* search169_1 -> 427 in the cache */
   /* search169_2 -> 148 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      true,
      false,
      false,
      nir_op_ffma,
      0, 2,
      { 29, 427, 148 },
      -1,
   } },

   /* replace169_0 -> 29 in the cache */
   /* replace169_1 -> 48 in the cache */
   /* replace169_2 -> 148 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ffmaz,
      0, 1,
      { 29, 48, 148 },
      -1,
   } },

   /* ('bcsel(nsz,nnan,ninf)', ('feq', 'b', 0.0, 'ignore_exact'), 1.0, ('fexp2', ('fmul@32', 'a', ('fneg', ('fabs', 'b'))))) => ('fexp2', ('fmulz', 'a', ('fneg', ('fabs', 'b')))) */
   /* search170_0_0 -> 386 in the cache */
   /* search170_0_1 -> 241 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      true,
      false,
      false,
      false,
      nir_op_feq,
      0, 1,
      { 386, 241 },
      -1,
   } },
   /* search170_1 -> 261 in the cache */
   /* search170_2_0_0 -> 196 in the cache */
   /* search170_2_0_1_0_0 -> 386 in the cache */
   /* search170_2_0_1_0 -> 392 in the cache */
   /* search170_2_0_1 -> 393 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fmul,
      1, 1,
      { 196, 393 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fexp2,
      -1, 1,
      { 464 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      true,
      true,
      true,
      nir_op_bcsel,
      -1, 2,
      { 463, 261, 465 },
      -1,
   } },

   /* replace170_0_0 -> 196 in the cache */
   /* replace170_0_1_0_0 -> 386 in the cache */
   /* replace170_0_1_0 -> 392 in the cache */
   /* replace170_0_1 -> 393 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fmulz,
      0, 1,
      { 196, 393 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fexp2,
      -1, 1,
      { 467 },
      -1,
   } },

   /* ('bcsel(nsz,nnan,ninf)', ('feq', 'b', 0.0, 'ignore_exact'), 1.0, ('fexp2', ('fmul@32', 'a', ('fabs', 'b')))) => ('fexp2', ('fmulz', 'a', ('fabs', 'b'))) */
   /* search171_0_0 -> 386 in the cache */
   /* search171_0_1 -> 241 in the cache */
   /* search171_0 -> 463 in the cache */
   /* search171_1 -> 261 in the cache */
   /* search171_2_0_0 -> 196 in the cache */
   /* search171_2_0_1_0 -> 386 in the cache */
   /* search171_2_0_1 -> 392 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fmul,
      1, 1,
      { 196, 392 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fexp2,
      -1, 1,
      { 469 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      true,
      true,
      true,
      nir_op_bcsel,
      -1, 2,
      { 463, 261, 470 },
      -1,
   } },

   /* replace171_0_0 -> 196 in the cache */
   /* replace171_0_1_0 -> 386 in the cache */
   /* replace171_0_1 -> 392 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fmulz,
      0, 1,
      { 196, 392 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fexp2,
      -1, 1,
      { 472 },
      -1,
   } },

   /* ('bcsel(nsz,nnan,ninf)', ('feq', 'b', 0.0, 'ignore_exact'), 1.0, ('fexp2', ('fmul@32', 'a', ('fneg', 'b')))) => ('fexp2', ('fmulz', 'a', ('fneg', 'b'))) */
   /* search172_0_0 -> 386 in the cache */
   /* search172_0_1 -> 241 in the cache */
   /* search172_0 -> 463 in the cache */
   /* search172_1 -> 261 in the cache */
   /* search172_2_0_0 -> 196 in the cache */
   /* search172_2_0_1_0 -> 386 in the cache */
   /* search172_2_0_1 -> 400 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fmul,
      1, 1,
      { 196, 400 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fexp2,
      -1, 1,
      { 474 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      true,
      true,
      true,
      nir_op_bcsel,
      -1, 2,
      { 463, 261, 475 },
      -1,
   } },

   /* replace172_0_0 -> 196 in the cache */
   /* replace172_0_1_0 -> 386 in the cache */
   /* replace172_0_1 -> 400 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fmulz,
      0, 1,
      { 196, 400 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fexp2,
      -1, 1,
      { 477 },
      -1,
   } },

   /* ('bcsel(nsz,nnan,ninf)', ('feq', 'b', 0.0, 'ignore_exact'), 1.0, ('fexp2', ('fmul@32', 'a', 'b'))) => ('fexp2', ('fmulz', 'a', 'b')) */
   /* search173_0_0 -> 386 in the cache */
   /* search173_0_1 -> 241 in the cache */
   /* search173_0 -> 463 in the cache */
   /* search173_1 -> 261 in the cache */
   /* search173_2_0_0 -> 196 in the cache */
   /* search173_2_0_1 -> 386 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fmul,
      1, 1,
      { 196, 386 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fexp2,
      -1, 1,
      { 479 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      true,
      true,
      true,
      nir_op_bcsel,
      -1, 2,
      { 463, 261, 480 },
      -1,
   } },

   /* replace173_0_0 -> 196 in the cache */
   /* replace173_0_1 -> 386 in the cache */
   /* replace173_0 -> 422 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fexp2,
      -1, 1,
      { 422 },
      -1,
   } },

   /* ('bcsel', ('feq', 'b', 0.0, 'ignore_exact'), 1.0, ('fexp2', ('fmulz', 'a', ('fneg', ('fabs', 'b'))))) => ('fexp2', ('fmulz', 'a', ('fneg', ('fabs', 'b')))) */
   /* search174_0_0 -> 386 in the cache */
   /* search174_0_1 -> 241 in the cache */
   /* search174_0 -> 463 in the cache */
   /* search174_1 -> 261 in the cache */
   /* search174_2_0_0 -> 196 in the cache */
   /* search174_2_0_1_0_0 -> 386 in the cache */
   /* search174_2_0_1_0 -> 392 in the cache */
   /* search174_2_0_1 -> 393 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fmulz,
      1, 1,
      { 196, 393 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fexp2,
      -1, 1,
      { 483 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_bcsel,
      -1, 2,
      { 463, 261, 484 },
      -1,
   } },

   /* replace174_0_0 -> 196 in the cache */
   /* replace174_0_1_0_0 -> 386 in the cache */
   /* replace174_0_1_0 -> 392 in the cache */
   /* replace174_0_1 -> 393 in the cache */
   /* replace174_0 -> 467 in the cache */
   /* replace174 -> 468 in the cache */

   /* ('bcsel', ('feq', 'b', 0.0, 'ignore_exact'), 1.0, ('fexp2', ('fmulz', 'a', ('fabs', 'b')))) => ('fexp2', ('fmulz', 'a', ('fabs', 'b'))) */
   /* search175_0_0 -> 386 in the cache */
   /* search175_0_1 -> 241 in the cache */
   /* search175_0 -> 463 in the cache */
   /* search175_1 -> 261 in the cache */
   /* search175_2_0_0 -> 196 in the cache */
   /* search175_2_0_1_0 -> 386 in the cache */
   /* search175_2_0_1 -> 392 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fmulz,
      1, 1,
      { 196, 392 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fexp2,
      -1, 1,
      { 486 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_bcsel,
      -1, 2,
      { 463, 261, 487 },
      -1,
   } },

   /* replace175_0_0 -> 196 in the cache */
   /* replace175_0_1_0 -> 386 in the cache */
   /* replace175_0_1 -> 392 in the cache */
   /* replace175_0 -> 472 in the cache */
   /* replace175 -> 473 in the cache */

   /* ('bcsel', ('feq', 'b', 0.0, 'ignore_exact'), 1.0, ('fexp2', ('fmulz', 'a', ('fneg', 'b')))) => ('fexp2', ('fmulz', 'a', ('fneg', 'b'))) */
   /* search176_0_0 -> 386 in the cache */
   /* search176_0_1 -> 241 in the cache */
   /* search176_0 -> 463 in the cache */
   /* search176_1 -> 261 in the cache */
   /* search176_2_0_0 -> 196 in the cache */
   /* search176_2_0_1_0 -> 386 in the cache */
   /* search176_2_0_1 -> 400 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fmulz,
      1, 1,
      { 196, 400 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fexp2,
      -1, 1,
      { 489 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_bcsel,
      -1, 2,
      { 463, 261, 490 },
      -1,
   } },

   /* replace176_0_0 -> 196 in the cache */
   /* replace176_0_1_0 -> 386 in the cache */
   /* replace176_0_1 -> 400 in the cache */
   /* replace176_0 -> 477 in the cache */
   /* replace176 -> 478 in the cache */

   /* ('bcsel', ('feq', 'b', 0.0, 'ignore_exact'), 1.0, ('fexp2', ('fmulz', 'a', 'b'))) => ('fexp2', ('fmulz', 'a', 'b')) */
   /* search177_0_0 -> 386 in the cache */
   /* search177_0_1 -> 241 in the cache */
   /* search177_0 -> 463 in the cache */
   /* search177_1 -> 261 in the cache */
   /* search177_2_0_0 -> 196 in the cache */
   /* search177_2_0_1 -> 386 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fmulz,
      1, 1,
      { 196, 386 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fexp2,
      -1, 1,
      { 492 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_bcsel,
      -1, 2,
      { 463, 261, 493 },
      -1,
   } },

   /* replace177_0_0 -> 196 in the cache */
   /* replace177_0_1 -> 386 in the cache */
   /* replace177_0 -> 422 in the cache */
   /* replace177 -> 482 in the cache */

   /* ('sdot_4x8_iadd', 'a', 'b', 'c') => ('iadd', ('iadd', ('iadd', ('imul', ('extract_i8', 'a', 0), ('extract_i8', 'b', 0)), ('imul', ('extract_i8', 'a', 1), ('extract_i8', 'b', 1))), ('iadd', ('imul', ('extract_i8', 'a', 2), ('extract_i8', 'b', 2)), ('imul', ('extract_i8', 'a', 3), ('extract_i8', 'b', 3)))), 'c') */
   /* search178_0 -> 29 in the cache */
   /* search178_1 -> 48 in the cache */
   /* search178_2 -> 148 in the cache */
   /* search178 -> 344 in the cache */

   /* replace178_0_0_0_0_0 -> 29 in the cache */
   /* replace178_0_0_0_0_1 -> 135 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_extract_i8,
      -1, 0,
      { 29, 135 },
      -1,
   } },
   /* replace178_0_0_0_1_0 -> 48 in the cache */
   /* replace178_0_0_0_1_1 -> 135 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_extract_i8,
      -1, 0,
      { 48, 135 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_imul,
      3, 1,
      { 495, 496 },
      -1,
   } },
   /* replace178_0_0_1_0_0 -> 29 in the cache */
   { .constant = {
      { nir_search_value_constant, 32 },
      nir_type_int, { 0x1ull /* 1 */ },
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_extract_i8,
      -1, 0,
      { 29, 498 },
      -1,
   } },
   /* replace178_0_0_1_1_0 -> 48 in the cache */
   /* replace178_0_0_1_1_1 -> 498 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_extract_i8,
      -1, 0,
      { 48, 498 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_imul,
      4, 1,
      { 499, 500 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_iadd,
      2, 3,
      { 497, 501 },
      -1,
   } },
   /* replace178_0_1_0_0_0 -> 29 in the cache */
   { .constant = {
      { nir_search_value_constant, 32 },
      nir_type_int, { 0x2ull /* 2 */ },
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_extract_i8,
      -1, 0,
      { 29, 503 },
      -1,
   } },
   /* replace178_0_1_0_1_0 -> 48 in the cache */
   /* replace178_0_1_0_1_1 -> 503 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_extract_i8,
      -1, 0,
      { 48, 503 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_imul,
      6, 1,
      { 504, 505 },
      -1,
   } },
   /* replace178_0_1_1_0_0 -> 29 in the cache */
   { .constant = {
      { nir_search_value_constant, 32 },
      nir_type_int, { 0x3ull /* 3 */ },
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_extract_i8,
      -1, 0,
      { 29, 507 },
      -1,
   } },
   /* replace178_0_1_1_1_0 -> 48 in the cache */
   /* replace178_0_1_1_1_1 -> 507 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_extract_i8,
      -1, 0,
      { 48, 507 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_imul,
      7, 1,
      { 508, 509 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_iadd,
      5, 3,
      { 506, 510 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_iadd,
      1, 7,
      { 502, 511 },
      -1,
   } },
   /* replace178_1 -> 148 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_iadd,
      0, 8,
      { 512, 148 },
      -1,
   } },

   /* ('udot_4x8_uadd', 'a', 'b', 'c') => ('iadd', ('iadd', ('iadd', ('imul', ('extract_u8', 'a', 0), ('extract_u8', 'b', 0)), ('imul', ('extract_u8', 'a', 1), ('extract_u8', 'b', 1))), ('iadd', ('imul', ('extract_u8', 'a', 2), ('extract_u8', 'b', 2)), ('imul', ('extract_u8', 'a', 3), ('extract_u8', 'b', 3)))), 'c') */
   /* search179_0 -> 29 in the cache */
   /* search179_1 -> 48 in the cache */
   /* search179_2 -> 148 in the cache */
   /* search179 -> 347 in the cache */

   /* replace179_0_0_0_0_0 -> 29 in the cache */
   /* replace179_0_0_0_0_1 -> 135 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_extract_u8,
      -1, 0,
      { 29, 135 },
      -1,
   } },
   /* replace179_0_0_0_1_0 -> 48 in the cache */
   /* replace179_0_0_0_1_1 -> 135 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_extract_u8,
      -1, 0,
      { 48, 135 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_imul,
      3, 1,
      { 514, 515 },
      -1,
   } },
   /* replace179_0_0_1_0_0 -> 29 in the cache */
   /* replace179_0_0_1_0_1 -> 498 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_extract_u8,
      -1, 0,
      { 29, 498 },
      -1,
   } },
   /* replace179_0_0_1_1_0 -> 48 in the cache */
   /* replace179_0_0_1_1_1 -> 498 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_extract_u8,
      -1, 0,
      { 48, 498 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_imul,
      4, 1,
      { 517, 518 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_iadd,
      2, 3,
      { 516, 519 },
      -1,
   } },
   /* replace179_0_1_0_0_0 -> 29 in the cache */
   /* replace179_0_1_0_0_1 -> 503 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_extract_u8,
      -1, 0,
      { 29, 503 },
      -1,
   } },
   /* replace179_0_1_0_1_0 -> 48 in the cache */
   /* replace179_0_1_0_1_1 -> 503 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_extract_u8,
      -1, 0,
      { 48, 503 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_imul,
      6, 1,
      { 521, 522 },
      -1,
   } },
   /* replace179_0_1_1_0_0 -> 29 in the cache */
   /* replace179_0_1_1_0_1 -> 507 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_extract_u8,
      -1, 0,
      { 29, 507 },
      -1,
   } },
   /* replace179_0_1_1_1_0 -> 48 in the cache */
   /* replace179_0_1_1_1_1 -> 507 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_extract_u8,
      -1, 0,
      { 48, 507 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_imul,
      7, 1,
      { 524, 525 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_iadd,
      5, 3,
      { 523, 526 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_iadd,
      1, 7,
      { 520, 527 },
      -1,
   } },
   /* replace179_1 -> 148 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_iadd,
      0, 8,
      { 528, 148 },
      -1,
   } },

   /* ('sudot_4x8_iadd', 'a', 'b', 'c') => ('iadd', ('iadd', ('iadd', ('imul', ('extract_i8', 'a', 0), ('extract_u8', 'b', 0)), ('imul', ('extract_i8', 'a', 1), ('extract_u8', 'b', 1))), ('iadd', ('imul', ('extract_i8', 'a', 2), ('extract_u8', 'b', 2)), ('imul', ('extract_i8', 'a', 3), ('extract_u8', 'b', 3)))), 'c') */
   /* search180_0 -> 29 in the cache */
   /* search180_1 -> 48 in the cache */
   /* search180_2 -> 148 in the cache */
   /* search180 -> 350 in the cache */

   /* replace180_0_0_0_0_0 -> 29 in the cache */
   /* replace180_0_0_0_0_1 -> 135 in the cache */
   /* replace180_0_0_0_0 -> 495 in the cache */
   /* replace180_0_0_0_1_0 -> 48 in the cache */
   /* replace180_0_0_0_1_1 -> 135 in the cache */
   /* replace180_0_0_0_1 -> 515 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_imul,
      3, 1,
      { 495, 515 },
      -1,
   } },
   /* replace180_0_0_1_0_0 -> 29 in the cache */
   /* replace180_0_0_1_0_1 -> 498 in the cache */
   /* replace180_0_0_1_0 -> 499 in the cache */
   /* replace180_0_0_1_1_0 -> 48 in the cache */
   /* replace180_0_0_1_1_1 -> 498 in the cache */
   /* replace180_0_0_1_1 -> 518 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_imul,
      4, 1,
      { 499, 518 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_iadd,
      2, 3,
      { 530, 531 },
      -1,
   } },
   /* replace180_0_1_0_0_0 -> 29 in the cache */
   /* replace180_0_1_0_0_1 -> 503 in the cache */
   /* replace180_0_1_0_0 -> 504 in the cache */
   /* replace180_0_1_0_1_0 -> 48 in the cache */
   /* replace180_0_1_0_1_1 -> 503 in the cache */
   /* replace180_0_1_0_1 -> 522 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_imul,
      6, 1,
      { 504, 522 },
      -1,
   } },
   /* replace180_0_1_1_0_0 -> 29 in the cache */
   /* replace180_0_1_1_0_1 -> 507 in the cache */
   /* replace180_0_1_1_0 -> 508 in the cache */
   /* replace180_0_1_1_1_0 -> 48 in the cache */
   /* replace180_0_1_1_1_1 -> 507 in the cache */
   /* replace180_0_1_1_1 -> 525 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_imul,
      7, 1,
      { 508, 525 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_iadd,
      5, 3,
      { 533, 534 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_iadd,
      1, 7,
      { 532, 535 },
      -1,
   } },
   /* replace180_1 -> 148 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_iadd,
      0, 8,
      { 536, 148 },
      -1,
   } },

   /* ('sdot_2x16_iadd', 'a', 'b', 'c') => ('iadd', ('iadd', ('imul', ('extract_i16', 'a', 0), ('extract_i16', 'b', 0)), ('imul', ('extract_i16', 'a', 1), ('extract_i16', 'b', 1))), 'c') */
   /* search181_0 -> 29 in the cache */
   /* search181_1 -> 48 in the cache */
   /* search181_2 -> 148 in the cache */
   /* search181 -> 356 in the cache */

   /* replace181_0_0_0_0 -> 29 in the cache */
   /* replace181_0_0_0_1 -> 135 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_extract_i16,
      -1, 0,
      { 29, 135 },
      -1,
   } },
   /* replace181_0_0_1_0 -> 48 in the cache */
   /* replace181_0_0_1_1 -> 135 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_extract_i16,
      -1, 0,
      { 48, 135 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_imul,
      2, 1,
      { 538, 539 },
      -1,
   } },
   /* replace181_0_1_0_0 -> 29 in the cache */
   /* replace181_0_1_0_1 -> 498 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_extract_i16,
      -1, 0,
      { 29, 498 },
      -1,
   } },
   /* replace181_0_1_1_0 -> 48 in the cache */
   /* replace181_0_1_1_1 -> 498 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_extract_i16,
      -1, 0,
      { 48, 498 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_imul,
      3, 1,
      { 541, 542 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_iadd,
      1, 3,
      { 540, 543 },
      -1,
   } },
   /* replace181_1 -> 148 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_iadd,
      0, 4,
      { 544, 148 },
      -1,
   } },

   /* ('udot_2x16_uadd', 'a', 'b', 'c') => ('iadd', ('iadd', ('imul', ('extract_u16', 'a', 0), ('extract_u16', 'b', 0)), ('imul', ('extract_u16', 'a', 1), ('extract_u16', 'b', 1))), 'c') */
   /* search182_0 -> 29 in the cache */
   /* search182_1 -> 48 in the cache */
   /* search182_2 -> 148 in the cache */
   /* search182 -> 359 in the cache */

   /* replace182_0_0_0_0 -> 29 in the cache */
   /* replace182_0_0_0_1 -> 135 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_extract_u16,
      -1, 0,
      { 29, 135 },
      -1,
   } },
   /* replace182_0_0_1_0 -> 48 in the cache */
   /* replace182_0_0_1_1 -> 135 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_extract_u16,
      -1, 0,
      { 48, 135 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_imul,
      2, 1,
      { 546, 547 },
      -1,
   } },
   /* replace182_0_1_0_0 -> 29 in the cache */
   /* replace182_0_1_0_1 -> 498 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_extract_u16,
      -1, 0,
      { 29, 498 },
      -1,
   } },
   /* replace182_0_1_1_0 -> 48 in the cache */
   /* replace182_0_1_1_1 -> 498 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_extract_u16,
      -1, 0,
      { 48, 498 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_imul,
      3, 1,
      { 549, 550 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_iadd,
      1, 3,
      { 548, 551 },
      -1,
   } },
   /* replace182_1 -> 148 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_iadd,
      0, 4,
      { 552, 148 },
      -1,
   } },

   /* ('udot_4x8_uadd_sat', 'a', 'b', '#c(is_ult_0xfffc07fc)') => ('udot_4x8_uadd', 'a', 'b', 'c') */
   /* search183_0 -> 29 in the cache */
   /* search183_1 -> 48 in the cache */
   { .variable = {
      { nir_search_value_variable, 32 },
      2, /* c */
      true,
      nir_type_invalid,
      7,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_udot_4x8_uadd_sat,
      0, 1,
      { 29, 48, 554 },
      -1,
   } },

   /* replace183_0 -> 29 in the cache */
   /* replace183_1 -> 48 in the cache */
   /* replace183_2 -> 148 in the cache */
   /* replace183 -> 347 in the cache */

   /* ('udot_4x8_uadd_sat', 'a', 'b', 'c') => ('uadd_sat', ('udot_4x8_uadd', 'a', 'b', 0), 'c') */
   /* search184_0 -> 29 in the cache */
   /* search184_1 -> 48 in the cache */
   /* search184_2 -> 148 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_udot_4x8_uadd_sat,
      0, 1,
      { 29, 48, 148 },
      -1,
   } },

   /* replace184_0_0 -> 29 in the cache */
   /* replace184_0_1 -> 48 in the cache */
   /* replace184_0_2 -> 135 in the cache */
   /* replace184_0 -> 365 in the cache */
   /* replace184_1 -> 148 in the cache */
   /* replace184 -> 379 in the cache */

   /* ('sdot_4x8_iadd_sat', 'a', 'b', 'c') => ('iadd_sat', ('sdot_4x8_iadd', 'a', 'b', 0), 'c') */
   /* search185_0 -> 29 in the cache */
   /* search185_1 -> 48 in the cache */
   /* search185_2 -> 148 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_sdot_4x8_iadd_sat,
      0, 1,
      { 29, 48, 148 },
      -1,
   } },

   /* replace185_0_0 -> 29 in the cache */
   /* replace185_0_1 -> 48 in the cache */
   /* replace185_0_2 -> 135 in the cache */
   /* replace185_0 -> 362 in the cache */
   /* replace185_1 -> 148 in the cache */
   /* replace185 -> 377 in the cache */

   /* ('sudot_4x8_iadd_sat', 'a', 'b', 'c') => ('iadd_sat', ('sudot_4x8_iadd', 'a', 'b', 0), 'c') */
   /* search186_0 -> 29 in the cache */
   /* search186_1 -> 48 in the cache */
   /* search186_2 -> 148 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_sudot_4x8_iadd_sat,
      -1, 0,
      { 29, 48, 148 },
      -1,
   } },

   /* replace186_0_0 -> 29 in the cache */
   /* replace186_0_1 -> 48 in the cache */
   /* replace186_0_2 -> 135 in the cache */
   /* replace186_0 -> 368 in the cache */
   /* replace186_1 -> 148 in the cache */
   /* replace186 -> 381 in the cache */

   /* ('udot_2x16_uadd_sat', 'a', 'b', 'c') => ('uadd_sat', ('iadd', ('imul', ('extract_u16', 'a', 0), ('extract_u16', 'b', 0)), ('imul', ('extract_u16', 'a', 1), ('extract_u16', 'b', 1))), 'c') */
   /* search187_0 -> 29 in the cache */
   /* search187_1 -> 48 in the cache */
   /* search187_2 -> 148 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_udot_2x16_uadd_sat,
      0, 1,
      { 29, 48, 148 },
      -1,
   } },

   /* replace187_0_0_0_0 -> 29 in the cache */
   /* replace187_0_0_0_1 -> 135 in the cache */
   /* replace187_0_0_0 -> 546 in the cache */
   /* replace187_0_0_1_0 -> 48 in the cache */
   /* replace187_0_0_1_1 -> 135 in the cache */
   /* replace187_0_0_1 -> 547 in the cache */
   /* replace187_0_0 -> 548 in the cache */
   /* replace187_0_1_0_0 -> 29 in the cache */
   /* replace187_0_1_0_1 -> 498 in the cache */
   /* replace187_0_1_0 -> 549 in the cache */
   /* replace187_0_1_1_0 -> 48 in the cache */
   /* replace187_0_1_1_1 -> 498 in the cache */
   /* replace187_0_1_1 -> 550 in the cache */
   /* replace187_0_1 -> 551 in the cache */
   /* replace187_0 -> 552 in the cache */
   /* replace187_1 -> 148 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_uadd_sat,
      0, 4,
      { 552, 148 },
      -1,
   } },

   /* ('sdot_2x16_iadd_sat', 'a', 'b', 'c') => ('iadd_sat', ('iadd', ('imul', ('extract_i16', 'a', 0), ('extract_i16', 'b', 0)), ('imul', ('extract_i16', 'a', 1), ('extract_i16', 'b', 1))), 'c') */
   /* search188_0 -> 29 in the cache */
   /* search188_1 -> 48 in the cache */
   /* search188_2 -> 148 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_sdot_2x16_iadd_sat,
      0, 1,
      { 29, 48, 148 },
      -1,
   } },

   /* replace188_0_0_0_0 -> 29 in the cache */
   /* replace188_0_0_0_1 -> 135 in the cache */
   /* replace188_0_0_0 -> 538 in the cache */
   /* replace188_0_0_1_0 -> 48 in the cache */
   /* replace188_0_0_1_1 -> 135 in the cache */
   /* replace188_0_0_1 -> 539 in the cache */
   /* replace188_0_0 -> 540 in the cache */
   /* replace188_0_1_0_0 -> 29 in the cache */
   /* replace188_0_1_0_1 -> 498 in the cache */
   /* replace188_0_1_0 -> 541 in the cache */
   /* replace188_0_1_1_0 -> 48 in the cache */
   /* replace188_0_1_1_1 -> 498 in the cache */
   /* replace188_0_1_1 -> 542 in the cache */
   /* replace188_0_1 -> 543 in the cache */
   /* replace188_0 -> 544 in the cache */
   /* replace188_1 -> 148 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_iadd_sat,
      0, 4,
      { 544, 148 },
      -1,
   } },

   /* ('~flrp@16', 'a', 'b', ('b2f', 'c@1')) => ('bcsel', 'c', 'b', 'a') */
   /* search189_0 -> 24 in the cache */
   { .variable = {
      { nir_search_value_variable, 16 },
      1, /* b */
      false,
      nir_type_invalid,
      -1,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .variable = {
      { nir_search_value_variable, 1 },
      2, /* c */
      false,
      nir_type_invalid,
      -1,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_search_op_b2f,
      -1, 0,
      { 564 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 16 },
      true,
      false,
      false,
      false,
      false,
      false,
      nir_op_flrp,
      -1, 0,
      { 24, 563, 565 },
      -1,
   } },

   /* replace189_0 -> 564 in the cache */
   /* replace189_1 -> 563 in the cache */
   /* replace189_2 -> 24 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_bcsel,
      -1, 0,
      { 564, 563, 24 },
      -1,
   } },

   /* ('~flrp@16', 'a', ('fadd', 'a', 'b'), 'c') => ('fadd', ('fmul', 'b', 'c'), 'a') */
   /* search190_0 -> 24 in the cache */
   /* search190_1_0 -> 24 in the cache */
   /* search190_1_1 -> 563 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fadd,
      0, 1,
      { 24, 563 },
      -1,
   } },
   { .variable = {
      { nir_search_value_variable, 16 },
      2, /* c */
      false,
      nir_type_invalid,
      -1,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .expression = {
      { nir_search_value_expression, 16 },
      true,
      false,
      false,
      false,
      false,
      false,
      nir_op_flrp,
      -1, 1,
      { 24, 568, 569 },
      -1,
   } },

   /* replace190_0_0 -> 563 in the cache */
   /* replace190_0_1 -> 569 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fmul,
      1, 1,
      { 563, 569 },
      -1,
   } },
   /* replace190_1 -> 24 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fadd,
      0, 2,
      { 571, 24 },
      -1,
   } },

   /* ('~flrp@16', ('fadd(is_used_once)', 'a', 'b'), ('fadd(is_used_once)', 'a', 'c'), 'd') => ('fadd', ('flrp', 'b', 'c', 'd'), 'a') */
   /* search191_0_0 -> 24 in the cache */
   /* search191_0_1 -> 563 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fadd,
      0, 1,
      { 24, 563 },
      0,
   } },
   /* search191_1_0 -> 24 in the cache */
   /* search191_1_1 -> 569 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fadd,
      1, 1,
      { 24, 569 },
      0,
   } },
   { .variable = {
      { nir_search_value_variable, 16 },
      3, /* d */
      false,
      nir_type_invalid,
      -1,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .expression = {
      { nir_search_value_expression, 16 },
      true,
      false,
      false,
      false,
      false,
      false,
      nir_op_flrp,
      -1, 2,
      { 573, 574, 575 },
      -1,
   } },

   /* replace191_0_0 -> 563 in the cache */
   /* replace191_0_1 -> 569 in the cache */
   /* replace191_0_2 -> 575 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_flrp,
      -1, 0,
      { 563, 569, 575 },
      -1,
   } },
   /* replace191_1 -> 24 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fadd,
      0, 1,
      { 577, 24 },
      -1,
   } },

   /* ('~flrp@16', 'a', ('fmul(is_used_once)', 'a', 'b'), 'c') => ('fmul', ('flrp', 1.0, 'b', 'c'), 'a') */
   /* search192_0 -> 24 in the cache */
   /* search192_1_0 -> 24 in the cache */
   /* search192_1_1 -> 563 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fmul,
      0, 1,
      { 24, 563 },
      0,
   } },
   /* search192_2 -> 569 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      true,
      false,
      false,
      false,
      false,
      false,
      nir_op_flrp,
      -1, 1,
      { 24, 579, 569 },
      -1,
   } },

   { .constant = {
      { nir_search_value_constant, 16 },
      nir_type_float, { 0x3ff0000000000000ull /* 1.0 */ },
   } },
   /* replace192_0_1 -> 563 in the cache */
   /* replace192_0_2 -> 569 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_flrp,
      -1, 0,
      { 581, 563, 569 },
      -1,
   } },
   /* replace192_1 -> 24 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fmul,
      0, 1,
      { 582, 24 },
      -1,
   } },

   /* ('~fadd@16', ('fmul', 'a', ('fadd', 1.0, ('fneg', 'c'))), ('fmul', 'b', 'c')) => ('flrp', 'a', 'b', 'c') */
   /* search193_0_0 -> 24 in the cache */
   /* search193_0_1_0 -> 581 in the cache */
   { .variable = {
      { nir_search_value_variable, 16 },
      1, /* c */
      false,
      nir_type_invalid,
      -1,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fneg,
      -1, 0,
      { 584 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fadd,
      2, 1,
      { 581, 585 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fmul,
      1, 2,
      { 24, 586 },
      -1,
   } },
   { .variable = {
      { nir_search_value_variable, 16 },
      2, /* b */
      false,
      nir_type_invalid,
      -1,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   /* search193_1_1 -> 584 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fmul,
      3, 1,
      { 588, 584 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 16 },
      true,
      false,
      false,
      false,
      false,
      false,
      nir_op_fadd,
      0, 4,
      { 587, 589 },
      -1,
   } },

   /* replace193_0 -> 24 in the cache */
   /* replace193_1 -> 588 in the cache */
   /* replace193_2 -> 584 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_flrp,
      -1, 0,
      { 24, 588, 584 },
      -1,
   } },

   /* ('~fadd@16', ('fmul', 'a', ('fsat', ('fadd', 1.0, ('fneg', 'c')))), ('fmul', 'b', ('fsat', 'c'))) => ('flrp', 'a', 'b', ('fsat', 'c')) */
   /* search194_0_0 -> 24 in the cache */
   /* search194_0_1_0_0 -> 581 in the cache */
   /* search194_0_1_0_1_0 -> 584 in the cache */
   /* search194_0_1_0_1 -> 585 in the cache */
   /* search194_0_1_0 -> 586 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fsat,
      -1, 1,
      { 586 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fmul,
      1, 2,
      { 24, 592 },
      -1,
   } },
   /* search194_1_0 -> 588 in the cache */
   /* search194_1_1_0 -> 584 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fsat,
      -1, 0,
      { 584 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fmul,
      3, 1,
      { 588, 594 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 16 },
      true,
      false,
      false,
      false,
      false,
      false,
      nir_op_fadd,
      0, 4,
      { 593, 595 },
      -1,
   } },

   /* replace194_0 -> 24 in the cache */
   /* replace194_1 -> 588 in the cache */
   /* replace194_2_0 -> 584 in the cache */
   /* replace194_2 -> 594 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_flrp,
      -1, 0,
      { 24, 588, 594 },
      -1,
   } },

   /* ('~fadd@16', 'a', ('fmul', 'c', ('fadd', 'b', ('fneg', 'a')))) => ('flrp', 'a', 'b', 'c') */
   /* search195_0 -> 24 in the cache */
   /* search195_1_0 -> 584 in the cache */
   /* search195_1_1_0 -> 588 in the cache */
   /* search195_1_1_1_0 -> 24 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fneg,
      -1, 0,
      { 24 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fadd,
      2, 1,
      { 588, 598 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fmul,
      1, 2,
      { 584, 599 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 16 },
      true,
      false,
      false,
      false,
      false,
      false,
      nir_op_fadd,
      0, 3,
      { 24, 600 },
      -1,
   } },

   /* replace195_0 -> 24 in the cache */
   /* replace195_1 -> 588 in the cache */
   /* replace195_2 -> 584 in the cache */
   /* replace195 -> 591 in the cache */

   /* ('~fadd@16', ('fmul', 'a', ('fadd', 1.0, ('fneg', ('b2f', 'c@1')))), ('fmul', 'b', ('b2f', 'c'))) => ('bcsel', 'c', 'b', 'a') */
   /* search196_0_0 -> 24 in the cache */
   /* search196_0_1_0 -> 581 in the cache */
   { .variable = {
      { nir_search_value_variable, 1 },
      1, /* c */
      false,
      nir_type_invalid,
      -1,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_search_op_b2f,
      -1, 0,
      { 602 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fneg,
      -1, 0,
      { 603 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fadd,
      2, 1,
      { 581, 604 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fmul,
      1, 2,
      { 24, 605 },
      -1,
   } },
   /* search196_1_0 -> 588 in the cache */
   /* search196_1_1_0 -> 602 in the cache */
   /* search196_1_1 -> 603 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fmul,
      3, 1,
      { 588, 603 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 16 },
      true,
      false,
      false,
      false,
      false,
      false,
      nir_op_fadd,
      0, 4,
      { 606, 607 },
      -1,
   } },

   /* replace196_0 -> 602 in the cache */
   /* replace196_1 -> 588 in the cache */
   /* replace196_2 -> 24 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_bcsel,
      -1, 0,
      { 602, 588, 24 },
      -1,
   } },

   /* ('~fadd@16', 'a', ('fmul', ('b2f', 'c@1'), ('fadd', 'b', ('fneg', 'a')))) => ('bcsel', 'c', 'b', 'a') */
   /* search197_0 -> 24 in the cache */
   /* search197_1_0_0 -> 602 in the cache */
   /* search197_1_0 -> 603 in the cache */
   /* search197_1_1_0 -> 588 in the cache */
   /* search197_1_1_1_0 -> 24 in the cache */
   /* search197_1_1_1 -> 598 in the cache */
   /* search197_1_1 -> 599 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fmul,
      1, 2,
      { 603, 599 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 16 },
      true,
      false,
      false,
      false,
      false,
      false,
      nir_op_fadd,
      0, 3,
      { 24, 610 },
      -1,
   } },

   /* replace197_0 -> 602 in the cache */
   /* replace197_1 -> 588 in the cache */
   /* replace197_2 -> 24 in the cache */
   /* replace197 -> 609 in the cache */

   /* ('~ffma@16', 'a', ('fadd', 1.0, ('fneg', ('b2f', 'c@1'))), ('fmul', 'b', ('b2f', 'c@1'))) => ('bcsel', 'c', 'b', 'a') */
   /* search198_0 -> 24 in the cache */
   /* search198_1_0 -> 581 in the cache */
   /* search198_1_1_0_0 -> 602 in the cache */
   /* search198_1_1_0 -> 603 in the cache */
   /* search198_1_1 -> 604 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fadd,
      1, 1,
      { 581, 604 },
      -1,
   } },
   /* search198_2_0 -> 588 in the cache */
   /* search198_2_1_0 -> 602 in the cache */
   /* search198_2_1 -> 603 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fmul,
      2, 1,
      { 588, 603 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 16 },
      true,
      false,
      false,
      false,
      false,
      false,
      nir_op_ffma,
      0, 3,
      { 24, 612, 613 },
      -1,
   } },

   /* replace198_0 -> 602 in the cache */
   /* replace198_1 -> 588 in the cache */
   /* replace198_2 -> 24 in the cache */
   /* replace198 -> 609 in the cache */

   /* ('~ffma@16', 'b', ('b2f', 'c@1'), ('ffma', ('fneg', 'a'), ('b2f', 'c@1'), 'a')) => ('bcsel', 'c', 'b', 'a') */
   { .variable = {
      { nir_search_value_variable, 16 },
      0, /* b */
      false,
      nir_type_invalid,
      -1,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   /* search199_1_0 -> 602 in the cache */
   /* search199_1 -> 603 in the cache */
   { .variable = {
      { nir_search_value_variable, 16 },
      2, /* a */
      false,
      nir_type_invalid,
      -1,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fneg,
      -1, 0,
      { 616 },
      -1,
   } },
   /* search199_2_1_0 -> 602 in the cache */
   /* search199_2_1 -> 603 in the cache */
   /* search199_2_2 -> 616 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ffma,
      1, 1,
      { 617, 603, 616 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 16 },
      true,
      false,
      false,
      false,
      false,
      false,
      nir_op_ffma,
      0, 2,
      { 615, 603, 618 },
      -1,
   } },

   /* replace199_0 -> 602 in the cache */
   /* replace199_1 -> 615 in the cache */
   /* replace199_2 -> 616 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_bcsel,
      -1, 0,
      { 602, 615, 616 },
      -1,
   } },

   /* ('~ffma@16', ('b2f', 'c@1'), ('fadd', 'b', ('fneg', 'a')), 'a') => ('bcsel', 'c', 'b', 'a') */
   { .variable = {
      { nir_search_value_variable, 1 },
      0, /* c */
      false,
      nir_type_invalid,
      -1,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_search_op_b2f,
      -1, 0,
      { 621 },
      -1,
   } },
   /* search200_1_0 -> 563 in the cache */
   /* search200_1_1_0 -> 616 in the cache */
   /* search200_1_1 -> 617 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fadd,
      1, 1,
      { 563, 617 },
      -1,
   } },
   /* search200_2 -> 616 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      true,
      false,
      false,
      false,
      false,
      false,
      nir_op_ffma,
      0, 2,
      { 622, 623, 616 },
      -1,
   } },

   /* replace200_0 -> 621 in the cache */
   /* replace200_1 -> 563 in the cache */
   /* replace200_2 -> 616 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_bcsel,
      -1, 0,
      { 621, 563, 616 },
      -1,
   } },

   /* ('~ffma@16', ('b2f', 'c@1'), ('ffma', ('fneg', 'a'), 'b', 'd'), ('fmul', 'a', 'b')) => ('bcsel', 'c', 'd', ('fmul', 'a', 'b')) */
   /* search201_0_0 -> 621 in the cache */
   /* search201_0 -> 622 in the cache */
   { .variable = {
      { nir_search_value_variable, 16 },
      1, /* a */
      false,
      nir_type_invalid,
      -1,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fneg,
      -1, 0,
      { 626 },
      -1,
   } },
   /* search201_1_1 -> 588 in the cache */
   /* search201_1_2 -> 575 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ffma,
      1, 1,
      { 627, 588, 575 },
      -1,
   } },
   /* search201_2_0 -> 626 in the cache */
   /* search201_2_1 -> 588 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fmul,
      2, 1,
      { 626, 588 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 16 },
      true,
      false,
      false,
      false,
      false,
      false,
      nir_op_ffma,
      0, 3,
      { 622, 628, 629 },
      -1,
   } },

   /* replace201_0 -> 621 in the cache */
   /* replace201_1 -> 575 in the cache */
   /* replace201_2_0 -> 626 in the cache */
   /* replace201_2_1 -> 588 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fmul,
      0, 1,
      { 626, 588 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_bcsel,
      -1, 1,
      { 621, 575, 631 },
      -1,
   } },

   /* ('~fadd@16', 1.0, ('fneg', ('fmul', ('fadd', 1.0, ('fneg', 'a')), ('fadd', 1.0, ('fneg', 'b'))))) => ('flrp', 'b', 1.0, 'a') */
   /* search202_0 -> 581 in the cache */
   /* search202_1_0_0_0 -> 581 in the cache */
   /* search202_1_0_0_1_0 -> 24 in the cache */
   /* search202_1_0_0_1 -> 598 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fadd,
      2, 1,
      { 581, 598 },
      -1,
   } },
   /* search202_1_0_1_0 -> 581 in the cache */
   /* search202_1_0_1_1_0 -> 563 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fneg,
      -1, 0,
      { 563 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fadd,
      3, 1,
      { 581, 634 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fmul,
      1, 3,
      { 633, 635 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fneg,
      -1, 3,
      { 636 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 16 },
      true,
      false,
      false,
      false,
      false,
      false,
      nir_op_fadd,
      0, 4,
      { 581, 637 },
      -1,
   } },

   /* replace202_0 -> 563 in the cache */
   /* replace202_1 -> 581 in the cache */
   /* replace202_2 -> 24 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_flrp,
      -1, 0,
      { 563, 581, 24 },
      -1,
   } },

   /* ('~flrp@32', 'a', 'b', ('b2f', 'c@1')) => ('bcsel', 'c', 'b', 'a') */
   /* search203_0 -> 29 in the cache */
   /* search203_1 -> 48 in the cache */
   /* search203_2_0 -> 564 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_search_op_b2f,
      -1, 0,
      { 564 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      true,
      false,
      false,
      false,
      false,
      false,
      nir_op_flrp,
      -1, 0,
      { 29, 48, 640 },
      -1,
   } },

   /* replace203_0 -> 564 in the cache */
   /* replace203_1 -> 48 in the cache */
   /* replace203_2 -> 29 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_bcsel,
      -1, 0,
      { 564, 48, 29 },
      -1,
   } },

   /* ('~flrp@32', 'a', ('fadd', 'a', 'b'), 'c') => ('fadd', ('fmul', 'b', 'c'), 'a') */
   /* search204_0 -> 29 in the cache */
   /* search204_1_0 -> 29 in the cache */
   /* search204_1_1 -> 48 in the cache */
   /* search204_1 -> 287 in the cache */
   /* search204_2 -> 148 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      true,
      false,
      false,
      false,
      false,
      false,
      nir_op_flrp,
      -1, 1,
      { 29, 287, 148 },
      -1,
   } },

   /* replace204_0_0 -> 48 in the cache */
   /* replace204_0_1 -> 148 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fmul,
      1, 1,
      { 48, 148 },
      -1,
   } },
   /* replace204_1 -> 29 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fadd,
      0, 2,
      { 644, 29 },
      -1,
   } },

   /* ('~flrp@32', ('fadd(is_used_once)', 'a', 'b'), ('fadd(is_used_once)', 'a', 'c'), 'd') => ('fadd', ('flrp', 'b', 'c', 'd'), 'a') */
   /* search205_0_0 -> 29 in the cache */
   /* search205_0_1 -> 48 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fadd,
      0, 1,
      { 29, 48 },
      0,
   } },
   /* search205_1_0 -> 29 in the cache */
   /* search205_1_1 -> 148 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fadd,
      1, 1,
      { 29, 148 },
      0,
   } },
   /* search205_2 -> 176 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      true,
      false,
      false,
      false,
      false,
      false,
      nir_op_flrp,
      -1, 2,
      { 646, 647, 176 },
      -1,
   } },

   /* replace205_0_0 -> 48 in the cache */
   /* replace205_0_1 -> 148 in the cache */
   /* replace205_0_2 -> 176 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_flrp,
      -1, 0,
      { 48, 148, 176 },
      -1,
   } },
   /* replace205_1 -> 29 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fadd,
      0, 1,
      { 649, 29 },
      -1,
   } },

   /* ('~flrp@32', 'a', ('fmul(is_used_once)', 'a', 'b'), 'c') => ('fmul', ('flrp', 1.0, 'b', 'c'), 'a') */
   /* search206_0 -> 29 in the cache */
   /* search206_1_0 -> 29 in the cache */
   /* search206_1_1 -> 48 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fmul,
      0, 1,
      { 29, 48 },
      0,
   } },
   /* search206_2 -> 148 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      true,
      false,
      false,
      false,
      false,
      false,
      nir_op_flrp,
      -1, 1,
      { 29, 651, 148 },
      -1,
   } },

   /* replace206_0_0 -> 261 in the cache */
   /* replace206_0_1 -> 48 in the cache */
   /* replace206_0_2 -> 148 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_flrp,
      -1, 0,
      { 261, 48, 148 },
      -1,
   } },
   /* replace206_1 -> 29 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fmul,
      0, 1,
      { 653, 29 },
      -1,
   } },

   /* ('~fadd@32', ('fmul', 'a', ('fadd', 1.0, ('fneg', 'c'))), ('fmul', 'b', 'c')) => ('flrp', 'a', 'b', 'c') */
   /* search207_0_0 -> 29 in the cache */
   /* search207_0_1_0 -> 261 in the cache */
   { .variable = {
      { nir_search_value_variable, 32 },
      1, /* c */
      false,
      nir_type_invalid,
      -1,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fneg,
      -1, 0,
      { 655 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fadd,
      2, 1,
      { 261, 656 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fmul,
      1, 2,
      { 29, 657 },
      -1,
   } },
   { .variable = {
      { nir_search_value_variable, 32 },
      2, /* b */
      false,
      nir_type_invalid,
      -1,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   /* search207_1_1 -> 655 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fmul,
      3, 1,
      { 659, 655 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      true,
      false,
      false,
      false,
      false,
      false,
      nir_op_fadd,
      0, 4,
      { 658, 660 },
      -1,
   } },

   /* replace207_0 -> 29 in the cache */
   /* replace207_1 -> 659 in the cache */
   /* replace207_2 -> 655 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_flrp,
      -1, 0,
      { 29, 659, 655 },
      -1,
   } },

   /* ('~fadd@32', ('fmul', 'a', ('fsat', ('fadd', 1.0, ('fneg', 'c')))), ('fmul', 'b', ('fsat', 'c'))) => ('flrp', 'a', 'b', ('fsat', 'c')) */
   /* search208_0_0 -> 29 in the cache */
   /* search208_0_1_0_0 -> 261 in the cache */
   /* search208_0_1_0_1_0 -> 655 in the cache */
   /* search208_0_1_0_1 -> 656 in the cache */
   /* search208_0_1_0 -> 657 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fsat,
      -1, 1,
      { 657 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fmul,
      1, 2,
      { 29, 663 },
      -1,
   } },
   /* search208_1_0 -> 659 in the cache */
   /* search208_1_1_0 -> 655 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fsat,
      -1, 0,
      { 655 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fmul,
      3, 1,
      { 659, 665 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      true,
      false,
      false,
      false,
      false,
      false,
      nir_op_fadd,
      0, 4,
      { 664, 666 },
      -1,
   } },

   /* replace208_0 -> 29 in the cache */
   /* replace208_1 -> 659 in the cache */
   /* replace208_2_0 -> 655 in the cache */
   /* replace208_2 -> 665 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_flrp,
      -1, 0,
      { 29, 659, 665 },
      -1,
   } },

   /* ('~fadd@32', 'a', ('fmul', 'c', ('fadd', 'b', ('fneg', 'a')))) => ('flrp', 'a', 'b', 'c') */
   /* search209_0 -> 29 in the cache */
   /* search209_1_0 -> 655 in the cache */
   /* search209_1_1_0 -> 659 in the cache */
   /* search209_1_1_1_0 -> 29 in the cache */
   /* search209_1_1_1 -> 293 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fadd,
      2, 1,
      { 659, 293 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fmul,
      1, 2,
      { 655, 669 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      true,
      false,
      false,
      false,
      false,
      false,
      nir_op_fadd,
      0, 3,
      { 29, 670 },
      -1,
   } },

   /* replace209_0 -> 29 in the cache */
   /* replace209_1 -> 659 in the cache */
   /* replace209_2 -> 655 in the cache */
   /* replace209 -> 662 in the cache */

   /* ('~fadd@32', ('fmul', 'a', ('fadd', 1.0, ('fneg', ('b2f', 'c@1')))), ('fmul', 'b', ('b2f', 'c'))) => ('bcsel', 'c', 'b', 'a') */
   /* search210_0_0 -> 29 in the cache */
   /* search210_0_1_0 -> 261 in the cache */
   /* search210_0_1_1_0_0 -> 602 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_search_op_b2f,
      -1, 0,
      { 602 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fneg,
      -1, 0,
      { 672 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fadd,
      2, 1,
      { 261, 673 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fmul,
      1, 2,
      { 29, 674 },
      -1,
   } },
   /* search210_1_0 -> 659 in the cache */
   /* search210_1_1_0 -> 602 in the cache */
   /* search210_1_1 -> 672 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fmul,
      3, 1,
      { 659, 672 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      true,
      false,
      false,
      false,
      false,
      false,
      nir_op_fadd,
      0, 4,
      { 675, 676 },
      -1,
   } },

   /* replace210_0 -> 602 in the cache */
   /* replace210_1 -> 659 in the cache */
   /* replace210_2 -> 29 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_bcsel,
      -1, 0,
      { 602, 659, 29 },
      -1,
   } },

   /* ('~fadd@32', 'a', ('fmul', ('b2f', 'c@1'), ('fadd', 'b', ('fneg', 'a')))) => ('bcsel', 'c', 'b', 'a') */
   /* search211_0 -> 29 in the cache */
   /* search211_1_0_0 -> 602 in the cache */
   /* search211_1_0 -> 672 in the cache */
   /* search211_1_1_0 -> 659 in the cache */
   /* search211_1_1_1_0 -> 29 in the cache */
   /* search211_1_1_1 -> 293 in the cache */
   /* search211_1_1 -> 669 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fmul,
      1, 2,
      { 672, 669 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      true,
      false,
      false,
      false,
      false,
      false,
      nir_op_fadd,
      0, 3,
      { 29, 679 },
      -1,
   } },

   /* replace211_0 -> 602 in the cache */
   /* replace211_1 -> 659 in the cache */
   /* replace211_2 -> 29 in the cache */
   /* replace211 -> 678 in the cache */

   /* ('~ffma@32', 'a', ('fadd', 1.0, ('fneg', ('b2f', 'c@1'))), ('fmul', 'b', ('b2f', 'c@1'))) => ('bcsel', 'c', 'b', 'a') */
   /* search212_0 -> 29 in the cache */
   /* search212_1_0 -> 261 in the cache */
   /* search212_1_1_0_0 -> 602 in the cache */
   /* search212_1_1_0 -> 672 in the cache */
   /* search212_1_1 -> 673 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fadd,
      1, 1,
      { 261, 673 },
      -1,
   } },
   /* search212_2_0 -> 659 in the cache */
   /* search212_2_1_0 -> 602 in the cache */
   /* search212_2_1 -> 672 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fmul,
      2, 1,
      { 659, 672 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      true,
      false,
      false,
      false,
      false,
      false,
      nir_op_ffma,
      0, 3,
      { 29, 681, 682 },
      -1,
   } },

   /* replace212_0 -> 602 in the cache */
   /* replace212_1 -> 659 in the cache */
   /* replace212_2 -> 29 in the cache */
   /* replace212 -> 678 in the cache */

   /* ('~ffma@32', 'b', ('b2f', 'c@1'), ('ffma', ('fneg', 'a'), ('b2f', 'c@1'), 'a')) => ('bcsel', 'c', 'b', 'a') */
   /* search213_0 -> 386 in the cache */
   /* search213_1_0 -> 602 in the cache */
   /* search213_1 -> 672 in the cache */
   { .variable = {
      { nir_search_value_variable, 32 },
      2, /* a */
      false,
      nir_type_invalid,
      -1,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fneg,
      -1, 0,
      { 684 },
      -1,
   } },
   /* search213_2_1_0 -> 602 in the cache */
   /* search213_2_1 -> 672 in the cache */
   /* search213_2_2 -> 684 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ffma,
      1, 1,
      { 685, 672, 684 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      true,
      false,
      false,
      false,
      false,
      false,
      nir_op_ffma,
      0, 2,
      { 386, 672, 686 },
      -1,
   } },

   /* replace213_0 -> 602 in the cache */
   /* replace213_1 -> 386 in the cache */
   /* replace213_2 -> 684 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_bcsel,
      -1, 0,
      { 602, 386, 684 },
      -1,
   } },

   /* ('~ffma@32', ('b2f', 'c@1'), ('fadd', 'b', ('fneg', 'a')), 'a') => ('bcsel', 'c', 'b', 'a') */
   /* search214_0_0 -> 621 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_search_op_b2f,
      -1, 0,
      { 621 },
      -1,
   } },
   /* search214_1_0 -> 48 in the cache */
   /* search214_1_1_0 -> 684 in the cache */
   /* search214_1_1 -> 685 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fadd,
      1, 1,
      { 48, 685 },
      -1,
   } },
   /* search214_2 -> 684 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      true,
      false,
      false,
      false,
      false,
      false,
      nir_op_ffma,
      0, 2,
      { 689, 690, 684 },
      -1,
   } },

   /* replace214_0 -> 621 in the cache */
   /* replace214_1 -> 48 in the cache */
   /* replace214_2 -> 684 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_bcsel,
      -1, 0,
      { 621, 48, 684 },
      -1,
   } },

   /* ('~ffma@32', ('b2f', 'c@1'), ('ffma', ('fneg', 'a'), 'b', 'd'), ('fmul', 'a', 'b')) => ('bcsel', 'c', 'd', ('fmul', 'a', 'b')) */
   /* search215_0_0 -> 621 in the cache */
   /* search215_0 -> 689 in the cache */
   /* search215_1_0_0 -> 196 in the cache */
   /* search215_1_0 -> 414 in the cache */
   /* search215_1_1 -> 659 in the cache */
   /* search215_1_2 -> 176 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ffma,
      1, 1,
      { 414, 659, 176 },
      -1,
   } },
   /* search215_2_0 -> 196 in the cache */
   /* search215_2_1 -> 659 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fmul,
      2, 1,
      { 196, 659 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      true,
      false,
      false,
      false,
      false,
      false,
      nir_op_ffma,
      0, 3,
      { 689, 693, 694 },
      -1,
   } },

   /* replace215_0 -> 621 in the cache */
   /* replace215_1 -> 176 in the cache */
   /* replace215_2_0 -> 196 in the cache */
   /* replace215_2_1 -> 659 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fmul,
      0, 1,
      { 196, 659 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_bcsel,
      -1, 1,
      { 621, 176, 696 },
      -1,
   } },

   /* ('~fadd@32', 1.0, ('fneg', ('fmul', ('fadd', 1.0, ('fneg', 'a')), ('fadd', 1.0, ('fneg', 'b'))))) => ('flrp', 'b', 1.0, 'a') */
   /* search216_0 -> 261 in the cache */
   /* search216_1_0_0_0 -> 261 in the cache */
   /* search216_1_0_0_1_0 -> 29 in the cache */
   /* search216_1_0_0_1 -> 293 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fadd,
      2, 1,
      { 261, 293 },
      -1,
   } },
   /* search216_1_0_1_0 -> 261 in the cache */
   /* search216_1_0_1_1_0 -> 48 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fneg,
      -1, 0,
      { 48 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fadd,
      3, 1,
      { 261, 699 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fmul,
      1, 3,
      { 698, 700 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fneg,
      -1, 3,
      { 701 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      true,
      false,
      false,
      false,
      false,
      false,
      nir_op_fadd,
      0, 4,
      { 261, 702 },
      -1,
   } },

   /* replace216_0 -> 48 in the cache */
   /* replace216_1 -> 261 in the cache */
   /* replace216_2 -> 29 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_flrp,
      -1, 0,
      { 48, 261, 29 },
      -1,
   } },

   /* ('~flrp@64', 'a', 'b', ('b2f', 'c@1')) => ('bcsel', 'c', 'b', 'a') */
   /* search217_0 -> 34 in the cache */
   /* search217_1 -> 53 in the cache */
   /* search217_2_0 -> 564 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_search_op_b2f,
      -1, 0,
      { 564 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 64 },
      true,
      false,
      false,
      false,
      false,
      false,
      nir_op_flrp,
      -1, 0,
      { 34, 53, 705 },
      -1,
   } },

   /* replace217_0 -> 564 in the cache */
   /* replace217_1 -> 53 in the cache */
   /* replace217_2 -> 34 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_bcsel,
      -1, 0,
      { 564, 53, 34 },
      -1,
   } },

   /* ('~flrp@64', 'a', ('fadd', 'a', 'b'), 'c') => ('fadd', ('fmul', 'b', 'c'), 'a') */
   /* search218_0 -> 34 in the cache */
   /* search218_1_0 -> 34 in the cache */
   /* search218_1_1 -> 53 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fadd,
      0, 1,
      { 34, 53 },
      -1,
   } },
   { .variable = {
      { nir_search_value_variable, 64 },
      2, /* c */
      false,
      nir_type_invalid,
      -1,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .expression = {
      { nir_search_value_expression, 64 },
      true,
      false,
      false,
      false,
      false,
      false,
      nir_op_flrp,
      -1, 1,
      { 34, 708, 709 },
      -1,
   } },

   /* replace218_0_0 -> 53 in the cache */
   /* replace218_0_1 -> 709 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fmul,
      1, 1,
      { 53, 709 },
      -1,
   } },
   /* replace218_1 -> 34 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fadd,
      0, 2,
      { 711, 34 },
      -1,
   } },

   /* ('~flrp@64', ('fadd(is_used_once)', 'a', 'b'), ('fadd(is_used_once)', 'a', 'c'), 'd') => ('fadd', ('flrp', 'b', 'c', 'd'), 'a') */
   /* search219_0_0 -> 34 in the cache */
   /* search219_0_1 -> 53 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fadd,
      0, 1,
      { 34, 53 },
      0,
   } },
   /* search219_1_0 -> 34 in the cache */
   /* search219_1_1 -> 709 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fadd,
      1, 1,
      { 34, 709 },
      0,
   } },
   { .variable = {
      { nir_search_value_variable, 64 },
      3, /* d */
      false,
      nir_type_invalid,
      -1,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .expression = {
      { nir_search_value_expression, 64 },
      true,
      false,
      false,
      false,
      false,
      false,
      nir_op_flrp,
      -1, 2,
      { 713, 714, 715 },
      -1,
   } },

   /* replace219_0_0 -> 53 in the cache */
   /* replace219_0_1 -> 709 in the cache */
   /* replace219_0_2 -> 715 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_flrp,
      -1, 0,
      { 53, 709, 715 },
      -1,
   } },
   /* replace219_1 -> 34 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fadd,
      0, 1,
      { 717, 34 },
      -1,
   } },

   /* ('~flrp@64', 'a', ('fmul(is_used_once)', 'a', 'b'), 'c') => ('fmul', ('flrp', 1.0, 'b', 'c'), 'a') */
   /* search220_0 -> 34 in the cache */
   /* search220_1_0 -> 34 in the cache */
   /* search220_1_1 -> 53 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fmul,
      0, 1,
      { 34, 53 },
      0,
   } },
   /* search220_2 -> 709 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      true,
      false,
      false,
      false,
      false,
      false,
      nir_op_flrp,
      -1, 1,
      { 34, 719, 709 },
      -1,
   } },

   { .constant = {
      { nir_search_value_constant, 64 },
      nir_type_float, { 0x3ff0000000000000ull /* 1.0 */ },
   } },
   /* replace220_0_1 -> 53 in the cache */
   /* replace220_0_2 -> 709 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_flrp,
      -1, 0,
      { 721, 53, 709 },
      -1,
   } },
   /* replace220_1 -> 34 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fmul,
      0, 1,
      { 722, 34 },
      -1,
   } },

   /* ('~fadd@64', ('fmul', 'a', ('fadd', 1.0, ('fneg', 'c'))), ('fmul', 'b', 'c')) => ('flrp', 'a', 'b', 'c') */
   /* search221_0_0 -> 34 in the cache */
   /* search221_0_1_0 -> 721 in the cache */
   { .variable = {
      { nir_search_value_variable, 64 },
      1, /* c */
      false,
      nir_type_invalid,
      -1,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fneg,
      -1, 0,
      { 724 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fadd,
      2, 1,
      { 721, 725 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fmul,
      1, 2,
      { 34, 726 },
      -1,
   } },
   { .variable = {
      { nir_search_value_variable, 64 },
      2, /* b */
      false,
      nir_type_invalid,
      -1,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   /* search221_1_1 -> 724 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fmul,
      3, 1,
      { 728, 724 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 64 },
      true,
      false,
      false,
      false,
      false,
      false,
      nir_op_fadd,
      0, 4,
      { 727, 729 },
      -1,
   } },

   /* replace221_0 -> 34 in the cache */
   /* replace221_1 -> 728 in the cache */
   /* replace221_2 -> 724 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_flrp,
      -1, 0,
      { 34, 728, 724 },
      -1,
   } },

   /* ('~fadd@64', ('fmul', 'a', ('fsat', ('fadd', 1.0, ('fneg', 'c')))), ('fmul', 'b', ('fsat', 'c'))) => ('flrp', 'a', 'b', ('fsat', 'c')) */
   /* search222_0_0 -> 34 in the cache */
   /* search222_0_1_0_0 -> 721 in the cache */
   /* search222_0_1_0_1_0 -> 724 in the cache */
   /* search222_0_1_0_1 -> 725 in the cache */
   /* search222_0_1_0 -> 726 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fsat,
      -1, 1,
      { 726 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fmul,
      1, 2,
      { 34, 732 },
      -1,
   } },
   /* search222_1_0 -> 728 in the cache */
   /* search222_1_1_0 -> 724 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fsat,
      -1, 0,
      { 724 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fmul,
      3, 1,
      { 728, 734 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 64 },
      true,
      false,
      false,
      false,
      false,
      false,
      nir_op_fadd,
      0, 4,
      { 733, 735 },
      -1,
   } },

   /* replace222_0 -> 34 in the cache */
   /* replace222_1 -> 728 in the cache */
   /* replace222_2_0 -> 724 in the cache */
   /* replace222_2 -> 734 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_flrp,
      -1, 0,
      { 34, 728, 734 },
      -1,
   } },

   /* ('~fadd@64', 'a', ('fmul', 'c', ('fadd', 'b', ('fneg', 'a')))) => ('flrp', 'a', 'b', 'c') */
   /* search223_0 -> 34 in the cache */
   /* search223_1_0 -> 724 in the cache */
   /* search223_1_1_0 -> 728 in the cache */
   /* search223_1_1_1_0 -> 34 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fneg,
      -1, 0,
      { 34 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fadd,
      2, 1,
      { 728, 738 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fmul,
      1, 2,
      { 724, 739 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 64 },
      true,
      false,
      false,
      false,
      false,
      false,
      nir_op_fadd,
      0, 3,
      { 34, 740 },
      -1,
   } },

   /* replace223_0 -> 34 in the cache */
   /* replace223_1 -> 728 in the cache */
   /* replace223_2 -> 724 in the cache */
   /* replace223 -> 731 in the cache */

   /* ('~fadd@64', ('fmul', 'a', ('fadd', 1.0, ('fneg', ('b2f', 'c@1')))), ('fmul', 'b', ('b2f', 'c'))) => ('bcsel', 'c', 'b', 'a') */
   /* search224_0_0 -> 34 in the cache */
   /* search224_0_1_0 -> 721 in the cache */
   /* search224_0_1_1_0_0 -> 602 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_search_op_b2f,
      -1, 0,
      { 602 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fneg,
      -1, 0,
      { 742 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fadd,
      2, 1,
      { 721, 743 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fmul,
      1, 2,
      { 34, 744 },
      -1,
   } },
   /* search224_1_0 -> 728 in the cache */
   /* search224_1_1_0 -> 602 in the cache */
   /* search224_1_1 -> 742 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fmul,
      3, 1,
      { 728, 742 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 64 },
      true,
      false,
      false,
      false,
      false,
      false,
      nir_op_fadd,
      0, 4,
      { 745, 746 },
      -1,
   } },

   /* replace224_0 -> 602 in the cache */
   /* replace224_1 -> 728 in the cache */
   /* replace224_2 -> 34 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_bcsel,
      -1, 0,
      { 602, 728, 34 },
      -1,
   } },

   /* ('~fadd@64', 'a', ('fmul', ('b2f', 'c@1'), ('fadd', 'b', ('fneg', 'a')))) => ('bcsel', 'c', 'b', 'a') */
   /* search225_0 -> 34 in the cache */
   /* search225_1_0_0 -> 602 in the cache */
   /* search225_1_0 -> 742 in the cache */
   /* search225_1_1_0 -> 728 in the cache */
   /* search225_1_1_1_0 -> 34 in the cache */
   /* search225_1_1_1 -> 738 in the cache */
   /* search225_1_1 -> 739 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fmul,
      1, 2,
      { 742, 739 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 64 },
      true,
      false,
      false,
      false,
      false,
      false,
      nir_op_fadd,
      0, 3,
      { 34, 749 },
      -1,
   } },

   /* replace225_0 -> 602 in the cache */
   /* replace225_1 -> 728 in the cache */
   /* replace225_2 -> 34 in the cache */
   /* replace225 -> 748 in the cache */

   /* ('~ffma@64', 'a', ('fadd', 1.0, ('fneg', ('b2f', 'c@1'))), ('fmul', 'b', ('b2f', 'c@1'))) => ('bcsel', 'c', 'b', 'a') */
   /* search226_0 -> 34 in the cache */
   /* search226_1_0 -> 721 in the cache */
   /* search226_1_1_0_0 -> 602 in the cache */
   /* search226_1_1_0 -> 742 in the cache */
   /* search226_1_1 -> 743 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fadd,
      1, 1,
      { 721, 743 },
      -1,
   } },
   /* search226_2_0 -> 728 in the cache */
   /* search226_2_1_0 -> 602 in the cache */
   /* search226_2_1 -> 742 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fmul,
      2, 1,
      { 728, 742 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 64 },
      true,
      false,
      false,
      false,
      false,
      false,
      nir_op_ffma,
      0, 3,
      { 34, 751, 752 },
      -1,
   } },

   /* replace226_0 -> 602 in the cache */
   /* replace226_1 -> 728 in the cache */
   /* replace226_2 -> 34 in the cache */
   /* replace226 -> 748 in the cache */

   /* ('~ffma@64', 'b', ('b2f', 'c@1'), ('ffma', ('fneg', 'a'), ('b2f', 'c@1'), 'a')) => ('bcsel', 'c', 'b', 'a') */
   { .variable = {
      { nir_search_value_variable, 64 },
      0, /* b */
      false,
      nir_type_invalid,
      -1,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   /* search227_1_0 -> 602 in the cache */
   /* search227_1 -> 742 in the cache */
   { .variable = {
      { nir_search_value_variable, 64 },
      2, /* a */
      false,
      nir_type_invalid,
      -1,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fneg,
      -1, 0,
      { 755 },
      -1,
   } },
   /* search227_2_1_0 -> 602 in the cache */
   /* search227_2_1 -> 742 in the cache */
   /* search227_2_2 -> 755 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ffma,
      1, 1,
      { 756, 742, 755 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 64 },
      true,
      false,
      false,
      false,
      false,
      false,
      nir_op_ffma,
      0, 2,
      { 754, 742, 757 },
      -1,
   } },

   /* replace227_0 -> 602 in the cache */
   /* replace227_1 -> 754 in the cache */
   /* replace227_2 -> 755 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_bcsel,
      -1, 0,
      { 602, 754, 755 },
      -1,
   } },

   /* ('~ffma@64', ('b2f', 'c@1'), ('fadd', 'b', ('fneg', 'a')), 'a') => ('bcsel', 'c', 'b', 'a') */
   /* search228_0_0 -> 621 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_search_op_b2f,
      -1, 0,
      { 621 },
      -1,
   } },
   /* search228_1_0 -> 53 in the cache */
   /* search228_1_1_0 -> 755 in the cache */
   /* search228_1_1 -> 756 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fadd,
      1, 1,
      { 53, 756 },
      -1,
   } },
   /* search228_2 -> 755 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      true,
      false,
      false,
      false,
      false,
      false,
      nir_op_ffma,
      0, 2,
      { 760, 761, 755 },
      -1,
   } },

   /* replace228_0 -> 621 in the cache */
   /* replace228_1 -> 53 in the cache */
   /* replace228_2 -> 755 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_bcsel,
      -1, 0,
      { 621, 53, 755 },
      -1,
   } },

   /* ('~ffma@64', ('b2f', 'c@1'), ('ffma', ('fneg', 'a'), 'b', 'd'), ('fmul', 'a', 'b')) => ('bcsel', 'c', 'd', ('fmul', 'a', 'b')) */
   /* search229_0_0 -> 621 in the cache */
   /* search229_0 -> 760 in the cache */
   { .variable = {
      { nir_search_value_variable, 64 },
      1, /* a */
      false,
      nir_type_invalid,
      -1,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fneg,
      -1, 0,
      { 764 },
      -1,
   } },
   /* search229_1_1 -> 728 in the cache */
   /* search229_1_2 -> 715 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ffma,
      1, 1,
      { 765, 728, 715 },
      -1,
   } },
   /* search229_2_0 -> 764 in the cache */
   /* search229_2_1 -> 728 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fmul,
      2, 1,
      { 764, 728 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 64 },
      true,
      false,
      false,
      false,
      false,
      false,
      nir_op_ffma,
      0, 3,
      { 760, 766, 767 },
      -1,
   } },

   /* replace229_0 -> 621 in the cache */
   /* replace229_1 -> 715 in the cache */
   /* replace229_2_0 -> 764 in the cache */
   /* replace229_2_1 -> 728 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fmul,
      0, 1,
      { 764, 728 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_bcsel,
      -1, 1,
      { 621, 715, 769 },
      -1,
   } },

   /* ('~fadd@64', 1.0, ('fneg', ('fmul', ('fadd', 1.0, ('fneg', 'a')), ('fadd', 1.0, ('fneg', 'b'))))) => ('flrp', 'b', 1.0, 'a') */
   /* search230_0 -> 721 in the cache */
   /* search230_1_0_0_0 -> 721 in the cache */
   /* search230_1_0_0_1_0 -> 34 in the cache */
   /* search230_1_0_0_1 -> 738 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fadd,
      2, 1,
      { 721, 738 },
      -1,
   } },
   /* search230_1_0_1_0 -> 721 in the cache */
   /* search230_1_0_1_1_0 -> 53 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fneg,
      -1, 0,
      { 53 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fadd,
      3, 1,
      { 721, 772 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fmul,
      1, 3,
      { 771, 773 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fneg,
      -1, 3,
      { 774 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 64 },
      true,
      false,
      false,
      false,
      false,
      false,
      nir_op_fadd,
      0, 4,
      { 721, 775 },
      -1,
   } },

   /* replace230_0 -> 53 in the cache */
   /* replace230_1 -> 721 in the cache */
   /* replace230_2 -> 34 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_flrp,
      -1, 0,
      { 53, 721, 34 },
      -1,
   } },

   /* ('~flrp', ('fmul(is_used_once)', 'a', 'b'), ('fmul(is_used_once)', 'a', 'c'), 'd') => ('fmul', ('flrp', 'b', 'c', 'd'), 'a') */
   /* search231_0_0 -> 162 in the cache */
   /* search231_0_1 -> 163 in the cache */
   { .expression = {
      { nir_search_value_expression, -4 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fmul,
      0, 1,
      { 162, 163 },
      0,
   } },
   /* search231_1_0 -> 162 in the cache */
   /* search231_1_1 -> 165 in the cache */
   { .expression = {
      { nir_search_value_expression, -4 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fmul,
      1, 1,
      { 162, 165 },
      0,
   } },
   /* search231_2 -> 166 in the cache */
   { .expression = {
      { nir_search_value_expression, -4 },
      true,
      false,
      false,
      false,
      false,
      false,
      nir_op_flrp,
      -1, 2,
      { 778, 779, 166 },
      -1,
   } },

   /* replace231_0_0 -> 163 in the cache */
   /* replace231_0_1 -> 165 in the cache */
   /* replace231_0_2 -> 166 in the cache */
   { .expression = {
      { nir_search_value_expression, -4 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_flrp,
      -1, 0,
      { 163, 165, 166 },
      -1,
   } },
   /* replace231_1 -> 162 in the cache */
   { .expression = {
      { nir_search_value_expression, -4 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fmul,
      0, 1,
      { 781, 162 },
      -1,
   } },

   /* ('~flrp', 'a', 0.0, 'c') => ('fadd', ('fmul', ('fneg', 'a'), 'c'), 'a') */
   /* search232_0 -> 0 in the cache */
   /* search232_1 -> 273 in the cache */
   { .variable = {
      { nir_search_value_variable, -2 },
      1, /* c */
      false,
      nir_type_invalid,
      -1,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .expression = {
      { nir_search_value_expression, -2 },
      true,
      false,
      false,
      false,
      false,
      false,
      nir_op_flrp,
      -1, 0,
      { 0, 273, 783 },
      -1,
   } },

   /* replace232_0_0_0 -> 0 in the cache */
   /* replace232_0_0 -> 230 in the cache */
   /* replace232_0_1 -> 783 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fmul,
      1, 1,
      { 230, 783 },
      -1,
   } },
   /* replace232_1 -> 0 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fadd,
      0, 2,
      { 785, 0 },
      -1,
   } },

   /* ('ftrunc@16', 'a') => ('bcsel', ('flt', 'a', 0.0), ('fneg', ('ffloor', ('fabs', 'a'))), ('ffloor', ('fabs', 'a'))) */
   /* search233_0 -> 24 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ftrunc,
      -1, 0,
      { 24 },
      -1,
   } },

   /* replace233_0_0 -> 24 in the cache */
   { .constant = {
      { nir_search_value_constant, 16 },
      nir_type_float, { 0x0ull /* 0.0 */ },
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_flt,
      -1, 0,
      { 24, 788 },
      -1,
   } },
   /* replace233_1_0_0_0 -> 24 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fabs,
      -1, 0,
      { 24 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ffloor,
      -1, 0,
      { 790 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fneg,
      -1, 0,
      { 791 },
      -1,
   } },
   /* replace233_2_0_0 -> 24 in the cache */
   /* replace233_2_0 -> 790 in the cache */
   /* replace233_2 -> 791 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_bcsel,
      -1, 0,
      { 789, 792, 791 },
      -1,
   } },

   /* ('ftrunc@32', 'a') => ('bcsel', ('flt', 'a', 0.0), ('fneg', ('ffloor', ('fabs', 'a'))), ('ffloor', ('fabs', 'a'))) */
   /* search234_0 -> 29 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ftrunc,
      -1, 0,
      { 29 },
      -1,
   } },

   /* replace234_0_0 -> 29 in the cache */
   /* replace234_0_1 -> 241 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_flt,
      -1, 0,
      { 29, 241 },
      -1,
   } },
   /* replace234_1_0_0_0 -> 29 in the cache */
   /* replace234_1_0_0 -> 423 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ffloor,
      -1, 0,
      { 423 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fneg,
      -1, 0,
      { 796 },
      -1,
   } },
   /* replace234_2_0_0 -> 29 in the cache */
   /* replace234_2_0 -> 423 in the cache */
   /* replace234_2 -> 796 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_bcsel,
      -1, 0,
      { 795, 797, 796 },
      -1,
   } },

   /* ('ftrunc@64', 'a') => ('bcsel', ('flt', 'a', 0.0), ('fneg', ('ffloor', ('fabs', 'a'))), ('ffloor', ('fabs', 'a'))) */
   /* search235_0 -> 34 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ftrunc,
      -1, 0,
      { 34 },
      -1,
   } },

   /* replace235_0_0 -> 34 in the cache */
   { .constant = {
      { nir_search_value_constant, 64 },
      nir_type_float, { 0x0ull /* 0.0 */ },
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_flt,
      -1, 0,
      { 34, 800 },
      -1,
   } },
   /* replace235_1_0_0_0 -> 34 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fabs,
      -1, 0,
      { 34 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ffloor,
      -1, 0,
      { 802 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fneg,
      -1, 0,
      { 803 },
      -1,
   } },
   /* replace235_2_0_0 -> 34 in the cache */
   /* replace235_2_0 -> 802 in the cache */
   /* replace235_2 -> 803 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_bcsel,
      -1, 0,
      { 801, 804, 803 },
      -1,
   } },

   /* ('ffloor@16', 'a') => ('fsub', 'a', ('ffract', 'a')) */
   /* search236_0 -> 24 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ffloor,
      -1, 0,
      { 24 },
      -1,
   } },

   /* replace236_0 -> 24 in the cache */
   /* replace236_1_0 -> 24 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ffract,
      -1, 0,
      { 24 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fsub,
      -1, 0,
      { 24, 807 },
      -1,
   } },

   /* ('ffloor@32', 'a') => ('fsub', 'a', ('ffract', 'a')) */
   /* search237_0 -> 29 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ffloor,
      -1, 0,
      { 29 },
      -1,
   } },

   /* replace237_0 -> 29 in the cache */
   /* replace237_1_0 -> 29 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ffract,
      -1, 0,
      { 29 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fsub,
      -1, 0,
      { 29, 810 },
      -1,
   } },

   /* ('ffloor@64', 'a') => ('fsub', 'a', ('ffract', 'a')) */
   /* search238_0 -> 34 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ffloor,
      -1, 0,
      { 34 },
      -1,
   } },

   /* replace238_0 -> 34 in the cache */
   /* replace238_1_0 -> 34 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ffract,
      -1, 0,
      { 34 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fsub,
      -1, 0,
      { 34, 813 },
      -1,
   } },

   /* ('fadd@16', 'a', ('fadd@16', 'b', ('fneg', ('ffract', 'a')))) => ('fadd@16', 'b', ('ffloor', 'a')) */
   /* search239_0 -> 24 in the cache */
   /* search239_1_0 -> 563 in the cache */
   /* search239_1_1_0_0 -> 24 in the cache */
   /* search239_1_1_0 -> 807 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fneg,
      -1, 0,
      { 807 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fadd,
      1, 1,
      { 563, 815 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fadd,
      0, 2,
      { 24, 816 },
      -1,
   } },

   /* replace239_0 -> 563 in the cache */
   /* replace239_1_0 -> 24 in the cache */
   /* replace239_1 -> 806 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fadd,
      0, 1,
      { 563, 806 },
      -1,
   } },

   /* ('fadd@32', 'a', ('fadd@32', 'b', ('fneg', ('ffract', 'a')))) => ('fadd@32', 'b', ('ffloor', 'a')) */
   /* search240_0 -> 29 in the cache */
   /* search240_1_0 -> 48 in the cache */
   /* search240_1_1_0_0 -> 29 in the cache */
   /* search240_1_1_0 -> 810 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fneg,
      -1, 0,
      { 810 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fadd,
      1, 1,
      { 48, 819 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fadd,
      0, 2,
      { 29, 820 },
      -1,
   } },

   /* replace240_0 -> 48 in the cache */
   /* replace240_1_0 -> 29 in the cache */
   /* replace240_1 -> 809 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fadd,
      0, 1,
      { 48, 809 },
      -1,
   } },

   /* ('fadd@64', 'a', ('fadd@64', 'b', ('fneg', ('ffract', 'a')))) => ('fadd@64', 'b', ('ffloor', 'a')) */
   /* search241_0 -> 34 in the cache */
   /* search241_1_0 -> 53 in the cache */
   /* search241_1_1_0_0 -> 34 in the cache */
   /* search241_1_1_0 -> 813 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fneg,
      -1, 0,
      { 813 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fadd,
      1, 1,
      { 53, 823 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fadd,
      0, 2,
      { 34, 824 },
      -1,
   } },

   /* replace241_0 -> 53 in the cache */
   /* replace241_1_0 -> 34 in the cache */
   /* replace241_1 -> 812 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fadd,
      0, 1,
      { 53, 812 },
      -1,
   } },

   /* ('fadd@16', 'a', ('fneg', ('ffract', 'a'))) => ('ffloor', 'a') */
   /* search242_0 -> 24 in the cache */
   /* search242_1_0_0 -> 24 in the cache */
   /* search242_1_0 -> 807 in the cache */
   /* search242_1 -> 815 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fadd,
      0, 1,
      { 24, 815 },
      -1,
   } },

   /* replace242_0 -> 24 in the cache */
   /* replace242 -> 806 in the cache */

   /* ('fadd@32', 'a', ('fneg', ('ffract', 'a'))) => ('ffloor', 'a') */
   /* search243_0 -> 29 in the cache */
   /* search243_1_0_0 -> 29 in the cache */
   /* search243_1_0 -> 810 in the cache */
   /* search243_1 -> 819 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fadd,
      0, 1,
      { 29, 819 },
      -1,
   } },

   /* replace243_0 -> 29 in the cache */
   /* replace243 -> 809 in the cache */

   /* ('fadd@64', 'a', ('fneg', ('ffract', 'a'))) => ('ffloor', 'a') */
   /* search244_0 -> 34 in the cache */
   /* search244_1_0_0 -> 34 in the cache */
   /* search244_1_0 -> 813 in the cache */
   /* search244_1 -> 823 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fadd,
      0, 1,
      { 34, 823 },
      -1,
   } },

   /* replace244_0 -> 34 in the cache */
   /* replace244 -> 812 in the cache */

   /* ('ffract@16', 'a') => ('fsub', 'a', ('ffloor', 'a')) */
   /* search245_0 -> 24 in the cache */
   /* search245 -> 807 in the cache */

   /* replace245_0 -> 24 in the cache */
   /* replace245_1_0 -> 24 in the cache */
   /* replace245_1 -> 806 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fsub,
      -1, 0,
      { 24, 806 },
      -1,
   } },

   /* ('ffract@32', 'a') => ('fsub', 'a', ('ffloor', 'a')) */
   /* search246_0 -> 29 in the cache */
   /* search246 -> 810 in the cache */

   /* replace246_0 -> 29 in the cache */
   /* replace246_1_0 -> 29 in the cache */
   /* replace246_1 -> 809 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fsub,
      -1, 0,
      { 29, 809 },
      -1,
   } },

   /* ('ffract@64', 'a') => ('fsub', 'a', ('ffloor', 'a')) */
   /* search247_0 -> 34 in the cache */
   /* search247 -> 813 in the cache */

   /* replace247_0 -> 34 in the cache */
   /* replace247_1_0 -> 34 in the cache */
   /* replace247_1 -> 812 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fsub,
      -1, 0,
      { 34, 812 },
      -1,
   } },

   /* ('fceil', 'a') => ('fneg', ('ffloor', ('fneg', 'a'))) */
   /* search248_0 -> 9 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fceil,
      -1, 0,
      { 9 },
      -1,
   } },

   /* replace248_0_0_0 -> 9 in the cache */
   /* replace248_0_0 -> 118 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ffloor,
      -1, 0,
      { 118 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fneg,
      -1, 0,
      { 834 },
      -1,
   } },

   /* ('ffma@16', 'a', 'b', 'c') => ('fadd', ('fmul', 'a', 'b'), 'c') */
   /* search249_0 -> 24 in the cache */
   /* search249_1 -> 563 in the cache */
   /* search249_2 -> 569 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ffma,
      0, 1,
      { 24, 563, 569 },
      -1,
   } },

   /* replace249_0_0 -> 24 in the cache */
   /* replace249_0_1 -> 563 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fmul,
      1, 1,
      { 24, 563 },
      -1,
   } },
   /* replace249_1 -> 569 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fadd,
      0, 2,
      { 837, 569 },
      -1,
   } },

   /* ('ffma@32', 'a', 'b', 'c') => ('fadd', ('fmul', 'a', 'b'), 'c') */
   /* search250_0 -> 29 in the cache */
   /* search250_1 -> 48 in the cache */
   /* search250_2 -> 148 in the cache */
   /* search250 -> 252 in the cache */

   /* replace250_0_0 -> 29 in the cache */
   /* replace250_0_1 -> 48 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fmul,
      1, 1,
      { 29, 48 },
      -1,
   } },
   /* replace250_1 -> 148 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fadd,
      0, 2,
      { 839, 148 },
      -1,
   } },

   /* ('ffma@64', 'a', 'b', 'c') => ('fadd', ('fmul', 'a', 'b'), 'c') */
   /* search251_0 -> 34 in the cache */
   /* search251_1 -> 53 in the cache */
   /* search251_2 -> 709 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ffma,
      0, 1,
      { 34, 53, 709 },
      -1,
   } },

   /* replace251_0_0 -> 34 in the cache */
   /* replace251_0_1 -> 53 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fmul,
      1, 1,
      { 34, 53 },
      -1,
   } },
   /* replace251_1 -> 709 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fadd,
      0, 2,
      { 842, 709 },
      -1,
   } },

   /* ('ffmaz', 'a', 'b', 'c') => ('fadd', ('fmulz', 'a', 'b'), 'c') */
   /* search252_0 -> 29 in the cache */
   /* search252_1 -> 48 in the cache */
   /* search252_2 -> 148 in the cache */
   /* search252 -> 462 in the cache */

   /* replace252_0_0 -> 29 in the cache */
   /* replace252_0_1 -> 48 in the cache */
   /* replace252_0 -> 147 in the cache */
   /* replace252_1 -> 148 in the cache */
   /* replace252 -> 301 in the cache */

   /* ('~ffma@16', 'a', 'b', 'c') => ('fadd', ('fmul', 'a', 'b'), 'c') */
   /* search253_0 -> 24 in the cache */
   /* search253_1 -> 563 in the cache */
   /* search253_2 -> 569 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      true,
      false,
      false,
      false,
      false,
      false,
      nir_op_ffma,
      0, 1,
      { 24, 563, 569 },
      -1,
   } },

   /* replace253_0_0 -> 24 in the cache */
   /* replace253_0_1 -> 563 in the cache */
   /* replace253_0 -> 837 in the cache */
   /* replace253_1 -> 569 in the cache */
   /* replace253 -> 838 in the cache */

   /* ('~ffma@32', 'a', 'b', 'c') => ('fadd', ('fmul', 'a', 'b'), 'c') */
   /* search254_0 -> 29 in the cache */
   /* search254_1 -> 48 in the cache */
   /* search254_2 -> 148 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      true,
      false,
      false,
      false,
      false,
      false,
      nir_op_ffma,
      0, 1,
      { 29, 48, 148 },
      -1,
   } },

   /* replace254_0_0 -> 29 in the cache */
   /* replace254_0_1 -> 48 in the cache */
   /* replace254_0 -> 839 in the cache */
   /* replace254_1 -> 148 in the cache */
   /* replace254 -> 840 in the cache */

   /* ('~ffma@64', 'a', 'b', 'c') => ('fadd', ('fmul', 'a', 'b'), 'c') */
   /* search255_0 -> 34 in the cache */
   /* search255_1 -> 53 in the cache */
   /* search255_2 -> 709 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      true,
      false,
      false,
      false,
      false,
      false,
      nir_op_ffma,
      0, 1,
      { 34, 53, 709 },
      -1,
   } },

   /* replace255_0_0 -> 34 in the cache */
   /* replace255_0_1 -> 53 in the cache */
   /* replace255_0 -> 842 in the cache */
   /* replace255_1 -> 709 in the cache */
   /* replace255 -> 843 in the cache */

   /* ('~ffmaz', 'a', 'b', 'c') => ('fadd', ('fmulz', 'a', 'b'), 'c') */
   /* search256_0 -> 29 in the cache */
   /* search256_1 -> 48 in the cache */
   /* search256_2 -> 148 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      true,
      false,
      false,
      false,
      false,
      false,
      nir_op_ffmaz,
      0, 1,
      { 29, 48, 148 },
      -1,
   } },

   /* replace256_0_0 -> 29 in the cache */
   /* replace256_0_1 -> 48 in the cache */
   /* replace256_0 -> 147 in the cache */
   /* replace256_1 -> 148 in the cache */
   /* replace256 -> 301 in the cache */

   /* ('~fmul', ('fadd', ('iand', ('ineg', ('b2i', 'a@bool')), ('fmul', 'b', 'c')), '#d'), '#e') => ('bcsel', 'a', ('fmul', ('fadd', ('fmul', 'b', 'c'), 'd'), 'e'), ('fmul', 'd', 'e')) */
   { .variable = {
      { nir_search_value_variable, 1 },
      0, /* a */
      false,
      nir_type_bool,
      -1,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .expression = {
      { nir_search_value_expression, -5 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_search_op_b2i,
      -1, 0,
      { 848 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -5 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ineg,
      -1, 0,
      { 849 },
      -1,
   } },
   { .variable = {
      { nir_search_value_variable, -5 },
      1, /* b */
      false,
      nir_type_invalid,
      -1,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .variable = {
      { nir_search_value_variable, -5 },
      2, /* c */
      false,
      nir_type_invalid,
      -1,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .expression = {
      { nir_search_value_expression, -5 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fmul,
      3, 1,
      { 851, 852 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -5 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_iand,
      2, 2,
      { 850, 853 },
      -1,
   } },
   { .variable = {
      { nir_search_value_variable, -5 },
      3, /* d */
      true,
      nir_type_invalid,
      -1,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .expression = {
      { nir_search_value_expression, -5 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fadd,
      1, 3,
      { 854, 855 },
      -1,
   } },
   { .variable = {
      { nir_search_value_variable, -5 },
      4, /* e */
      true,
      nir_type_invalid,
      -1,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .expression = {
      { nir_search_value_expression, -5 },
      true,
      false,
      false,
      false,
      false,
      false,
      nir_op_fmul,
      0, 4,
      { 856, 857 },
      -1,
   } },

   { .variable = {
      { nir_search_value_variable, 1 },
      0, /* a */
      false,
      nir_type_invalid,
      -1,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   /* replace257_1_0_0_0 -> 851 in the cache */
   /* replace257_1_0_0_1 -> 852 in the cache */
   { .expression = {
      { nir_search_value_expression, -5 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fmul,
      2, 1,
      { 851, 852 },
      -1,
   } },
   { .variable = {
      { nir_search_value_variable, -5 },
      3, /* d */
      false,
      nir_type_invalid,
      -1,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .expression = {
      { nir_search_value_expression, -5 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fadd,
      1, 2,
      { 860, 861 },
      -1,
   } },
   { .variable = {
      { nir_search_value_variable, -5 },
      4, /* e */
      false,
      nir_type_invalid,
      -1,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .expression = {
      { nir_search_value_expression, -5 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fmul,
      0, 3,
      { 862, 863 },
      -1,
   } },
   /* replace257_2_0 -> 861 in the cache */
   /* replace257_2_1 -> 863 in the cache */
   { .expression = {
      { nir_search_value_expression, -5 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fmul,
      3, 1,
      { 861, 863 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -5 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_bcsel,
      -1, 4,
      { 859, 864, 865 },
      -1,
   } },

   /* ('fdph', 'a', 'b') => ('fdot4', ('vec4', 'a.x', 'a.y', 'a.z', 1.0), 'b') */
   /* search258_0 -> 0 in the cache */
   /* search258_1 -> 1 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fdph,
      -1, 0,
      { 0, 1 },
      -1,
   } },

   { .variable = {
      { nir_search_value_variable, -2 },
      0, /* a */
      false,
      nir_type_invalid,
      -1,
      {0},
   } },
   { .variable = {
      { nir_search_value_variable, -2 },
      0, /* a */
      false,
      nir_type_invalid,
      -1,
      {1},
   } },
   { .variable = {
      { nir_search_value_variable, -2 },
      0, /* a */
      false,
      nir_type_invalid,
      -1,
      {2},
   } },
   /* replace258_0_3 -> 283 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_vec4,
      -1, 0,
      { 868, 869, 870, 283 },
      -1,
   } },
   /* replace258_1 -> 1 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fdot4,
      0, 1,
      { 871, 1 },
      -1,
   } },

   /* ('fdot4', 'a', 0.0) => 0.0 */
   /* search259_0 -> 9 in the cache */
   /* search259_1 -> 8 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fdot4,
      0, 1,
      { 9, 8 },
      -1,
   } },

   /* replace259 -> 8 in the cache */

   /* ('fdot3', 'a', 0.0) => 0.0 */
   /* search260_0 -> 9 in the cache */
   /* search260_1 -> 8 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fdot3,
      0, 1,
      { 9, 8 },
      -1,
   } },

   /* replace260 -> 8 in the cache */

   /* ('fdot2', 'a', 0.0) => 0.0 */
   /* search261_0 -> 9 in the cache */
   /* search261_1 -> 8 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fdot2,
      0, 1,
      { 9, 8 },
      -1,
   } },

   /* replace261 -> 8 in the cache */

   /* ('fdot4', ('vec4', 'a', 'b', 'c', 1.0), 'd') => ('fdph', ('vec3', 'a', 'b', 'c'), 'd') */
   /* search262_0_0 -> 162 in the cache */
   /* search262_0_1 -> 163 in the cache */
   /* search262_0_2 -> 165 in the cache */
   { .constant = {
      { nir_search_value_constant, -4 },
      nir_type_float, { 0x3ff0000000000000ull /* 1.0 */ },
   } },
   { .expression = {
      { nir_search_value_expression, -4 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_vec4,
      -1, 0,
      { 162, 163, 165, 876 },
      -1,
   } },
   /* search262_1 -> 166 in the cache */
   { .expression = {
      { nir_search_value_expression, -4 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fdot4,
      0, 1,
      { 877, 166 },
      -1,
   } },

   /* replace262_0_0 -> 162 in the cache */
   /* replace262_0_1 -> 163 in the cache */
   /* replace262_0_2 -> 165 in the cache */
   { .expression = {
      { nir_search_value_expression, -4 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_vec3,
      -1, 0,
      { 162, 163, 165 },
      -1,
   } },
   /* replace262_1 -> 166 in the cache */
   { .expression = {
      { nir_search_value_expression, -4 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fdph,
      -1, 0,
      { 879, 166 },
      -1,
   } },

   /* ('fdot4', ('vec4', 'a', 0.0, 0.0, 0.0), 'b') => ('fmul', 'a', 'b') */
   /* search263_0_0 -> 0 in the cache */
   /* search263_0_1 -> 273 in the cache */
   /* search263_0_2 -> 273 in the cache */
   /* search263_0_3 -> 273 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_vec4,
      -1, 0,
      { 0, 273, 273, 273 },
      -1,
   } },
   /* search263_1 -> 1 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fdot4,
      0, 1,
      { 881, 1 },
      -1,
   } },

   /* replace263_0 -> 0 in the cache */
   /* replace263_1 -> 1 in the cache */
   /* replace263 -> 279 in the cache */

   /* ('fdot4', ('vec4', 'a', 'b', 0.0, 0.0), 'c') => ('fdot2', ('vec2', 'a', 'b'), 'c') */
   /* search264_0_0 -> 139 in the cache */
   /* search264_0_1 -> 140 in the cache */
   { .constant = {
      { nir_search_value_constant, -3 },
      nir_type_float, { 0x0ull /* 0.0 */ },
   } },
   /* search264_0_3 -> 883 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_vec4,
      -1, 0,
      { 139, 140, 883, 883 },
      -1,
   } },
   /* search264_1 -> 142 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fdot4,
      0, 1,
      { 884, 142 },
      -1,
   } },

   /* replace264_0_0 -> 139 in the cache */
   /* replace264_0_1 -> 140 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_vec2,
      -1, 0,
      { 139, 140 },
      -1,
   } },
   /* replace264_1 -> 142 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fdot2,
      0, 1,
      { 886, 142 },
      -1,
   } },

   /* ('fdot4', ('vec4', 'a', 'b', 'c', 0.0), 'd') => ('fdot3', ('vec3', 'a', 'b', 'c'), 'd') */
   /* search265_0_0 -> 162 in the cache */
   /* search265_0_1 -> 163 in the cache */
   /* search265_0_2 -> 165 in the cache */
   { .constant = {
      { nir_search_value_constant, -4 },
      nir_type_float, { 0x0ull /* 0.0 */ },
   } },
   { .expression = {
      { nir_search_value_expression, -4 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_vec4,
      -1, 0,
      { 162, 163, 165, 888 },
      -1,
   } },
   /* search265_1 -> 166 in the cache */
   { .expression = {
      { nir_search_value_expression, -4 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fdot4,
      0, 1,
      { 889, 166 },
      -1,
   } },

   /* replace265_0_0 -> 162 in the cache */
   /* replace265_0_1 -> 163 in the cache */
   /* replace265_0_2 -> 165 in the cache */
   /* replace265_0 -> 879 in the cache */
   /* replace265_1 -> 166 in the cache */
   { .expression = {
      { nir_search_value_expression, -4 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fdot3,
      0, 1,
      { 879, 166 },
      -1,
   } },

   /* ('fdot3', ('vec3', 'a', 0.0, 0.0), 'b') => ('fmul', 'a', 'b') */
   /* search266_0_0 -> 0 in the cache */
   /* search266_0_1 -> 273 in the cache */
   /* search266_0_2 -> 273 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_vec3,
      -1, 0,
      { 0, 273, 273 },
      -1,
   } },
   /* search266_1 -> 1 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fdot3,
      0, 1,
      { 892, 1 },
      -1,
   } },

   /* replace266_0 -> 0 in the cache */
   /* replace266_1 -> 1 in the cache */
   /* replace266 -> 279 in the cache */

   /* ('fdot3', ('vec3', 'a', 'b', 0.0), 'c') => ('fdot2', ('vec2', 'a', 'b'), 'c') */
   /* search267_0_0 -> 139 in the cache */
   /* search267_0_1 -> 140 in the cache */
   /* search267_0_2 -> 883 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_vec3,
      -1, 0,
      { 139, 140, 883 },
      -1,
   } },
   /* search267_1 -> 142 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fdot3,
      0, 1,
      { 894, 142 },
      -1,
   } },

   /* replace267_0_0 -> 139 in the cache */
   /* replace267_0_1 -> 140 in the cache */
   /* replace267_0 -> 886 in the cache */
   /* replace267_1 -> 142 in the cache */
   /* replace267 -> 887 in the cache */

   /* ('fdot2', ('vec2', 'a', 0.0), 'b') => ('fmul', 'a', 'b') */
   /* search268_0_0 -> 0 in the cache */
   /* search268_0_1 -> 273 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_vec2,
      -1, 0,
      { 0, 273 },
      -1,
   } },
   /* search268_1 -> 1 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fdot2,
      0, 1,
      { 896, 1 },
      -1,
   } },

   /* replace268_0 -> 0 in the cache */
   /* replace268_1 -> 1 in the cache */
   /* replace268 -> 279 in the cache */

   /* ('fdot2', 'a', 1.0) => ('fadd', 'a.x', 'a.y') */
   /* search269_0 -> 9 in the cache */
   /* search269_1 -> 259 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fdot2,
      0, 1,
      { 9, 259 },
      -1,
   } },

   { .variable = {
      { nir_search_value_variable, -1 },
      0, /* a */
      false,
      nir_type_invalid,
      -1,
      {0},
   } },
   { .variable = {
      { nir_search_value_variable, -1 },
      0, /* a */
      false,
      nir_type_invalid,
      -1,
      {1},
   } },
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fadd,
      -1, 0,
      { 899, 900 },
      -1,
   } },

   /* ('fdot2', 'a', 'b') => ('fsum2', ('fmul', 'a', 'b')) */
   /* search270_0 -> 0 in the cache */
   /* search270_1 -> 1 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fdot2,
      0, 1,
      { 0, 1 },
      -1,
   } },

   /* replace270_0_0 -> 0 in the cache */
   /* replace270_0_1 -> 1 in the cache */
   /* replace270_0 -> 279 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fsum2,
      -1, 1,
      { 279 },
      -1,
   } },

   /* ('fdot3', 'a', 'b') => ('fsum3', ('fmul', 'a', 'b')) */
   /* search271_0 -> 0 in the cache */
   /* search271_1 -> 1 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fdot3,
      0, 1,
      { 0, 1 },
      -1,
   } },

   /* replace271_0_0 -> 0 in the cache */
   /* replace271_0_1 -> 1 in the cache */
   /* replace271_0 -> 279 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fsum3,
      -1, 1,
      { 279 },
      -1,
   } },

   /* ('fdot4', 'a', 'b') => ('fsum4', ('fmul', 'a', 'b')) */
   /* search272_0 -> 0 in the cache */
   /* search272_1 -> 1 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fdot4,
      0, 1,
      { 0, 1 },
      -1,
   } },

   /* replace272_0_0 -> 0 in the cache */
   /* replace272_0_1 -> 1 in the cache */
   /* replace272_0 -> 279 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fsum4,
      -1, 1,
      { 279 },
      -1,
   } },

   /* ('fsum2', 'a') => ('fadd', 'a.x', 'a.y') */
   /* search273_0 -> 9 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fsum2,
      -1, 0,
      { 9 },
      -1,
   } },

   /* replace273_0 -> 899 in the cache */
   /* replace273_1 -> 900 in the cache */
   /* replace273 -> 901 in the cache */

   /* ('~fadd', ('fneg(is_used_once)', ('fsat(is_used_once)', 'a(is_not_fmul)')), 1.0) => ('fsat', ('fadd', 1.0, ('fneg', 'a'))) */
   { .variable = {
      { nir_search_value_variable, -1 },
      0, /* a */
      false,
      nir_type_invalid,
      8,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fsat,
      -1, 0,
      { 909 },
      0,
   } },
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fneg,
      -1, 0,
      { 910 },
      0,
   } },
   /* search274_1 -> 259 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      true,
      false,
      false,
      false,
      false,
      false,
      nir_op_fadd,
      0, 1,
      { 911, 259 },
      -1,
   } },

   /* replace274_0_0 -> 259 in the cache */
   /* replace274_0_1_0 -> 9 in the cache */
   /* replace274_0_1 -> 118 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fadd,
      0, 1,
      { 259, 118 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fsat,
      -1, 1,
      { 913 },
      -1,
   } },

   /* ('ishl', ('iadd', ('imul', 'a', '#b'), '#c'), '#d') => ('iadd', ('imul', 'a', ('ishl', 'b', 'd')), ('ishl', 'c', 'd')) */
   /* search275_0_0_0 -> 139 in the cache */
   /* search275_0_0_1 -> 296 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_imul,
      1, 1,
      { 139, 296 },
      -1,
   } },
   { .variable = {
      { nir_search_value_variable, -3 },
      2, /* c */
      true,
      nir_type_invalid,
      -1,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_iadd,
      0, 2,
      { 915, 916 },
      -1,
   } },
   /* search275_1 -> 324 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ishl,
      -1, 2,
      { 917, 324 },
      -1,
   } },

   /* replace275_0_0 -> 139 in the cache */
   /* replace275_0_1_0 -> 140 in the cache */
   /* replace275_0_1_1 -> 176 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ishl,
      -1, 0,
      { 140, 176 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_imul,
      1, 1,
      { 139, 919 },
      -1,
   } },
   /* replace275_1_0 -> 142 in the cache */
   /* replace275_1_1 -> 176 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ishl,
      -1, 0,
      { 142, 176 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_iadd,
      0, 2,
      { 920, 921 },
      -1,
   } },

   /* ('ishl', ('imul', 'a', '#b'), '#c') => ('imul', 'a', ('ishl', 'b', 'c')) */
   /* search276_0_0 -> 0 in the cache */
   { .variable = {
      { nir_search_value_variable, -2 },
      1, /* b */
      true,
      nir_type_invalid,
      -1,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_imul,
      0, 1,
      { 0, 923 },
      -1,
   } },
   /* search276_1 -> 322 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ishl,
      -1, 1,
      { 924, 322 },
      -1,
   } },

   /* replace276_0 -> 0 in the cache */
   /* replace276_1_0 -> 1 in the cache */
   /* replace276_1_1 -> 148 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ishl,
      -1, 0,
      { 1, 148 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_imul,
      0, 1,
      { 0, 926 },
      -1,
   } },

   /* ('ishl@8', ('ishl@8', 'a', '#b'), '#c') => ('bcsel', ('ult', ('iadd', ('iand', 'b', 7), ('iand', 'c', 7)), 8), ('ishl@8', 'a', ('iadd', 'b', 'c')), 0) */
   /* search277_0_0 -> 19 in the cache */
   /* search277_0_1 -> 45 in the cache */
   { .expression = {
      { nir_search_value_expression, 8 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ishl,
      -1, 0,
      { 19, 45 },
      -1,
   } },
   /* search277_1 -> 322 in the cache */
   { .expression = {
      { nir_search_value_expression, 8 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ishl,
      -1, 0,
      { 928, 322 },
      -1,
   } },

   /* replace277_0_0_0_0 -> 48 in the cache */
   /* replace277_0_0_0_1 -> 22 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_iand,
      1, 1,
      { 48, 22 },
      -1,
   } },
   /* replace277_0_0_1_0 -> 148 in the cache */
   /* replace277_0_0_1_1 -> 22 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_iand,
      2, 1,
      { 148, 22 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_iadd,
      0, 3,
      { 930, 931 },
      -1,
   } },
   { .constant = {
      { nir_search_value_constant, 32 },
      nir_type_int, { 0x8ull /* 8 */ },
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ult,
      -1, 3,
      { 932, 933 },
      -1,
   } },
   /* replace277_1_0 -> 19 in the cache */
   /* replace277_1_1_0 -> 48 in the cache */
   /* replace277_1_1_1 -> 148 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_iadd,
      3, 1,
      { 48, 148 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 8 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ishl,
      -1, 1,
      { 19, 935 },
      -1,
   } },
   { .constant = {
      { nir_search_value_constant, 8 },
      nir_type_int, { 0x0ull /* 0 */ },
   } },
   { .expression = {
      { nir_search_value_expression, 8 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_bcsel,
      -1, 4,
      { 934, 936, 937 },
      -1,
   } },

   /* ('ushr@8', ('ushr@8', 'a', '#b'), '#c') => ('bcsel', ('ult', ('iadd', ('iand', 'b', 7), ('iand', 'c', 7)), 8), ('ushr@8', 'a', ('iadd', 'b', 'c')), 0) */
   /* search278_0_0 -> 19 in the cache */
   /* search278_0_1 -> 45 in the cache */
   { .expression = {
      { nir_search_value_expression, 8 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ushr,
      -1, 0,
      { 19, 45 },
      -1,
   } },
   /* search278_1 -> 322 in the cache */
   { .expression = {
      { nir_search_value_expression, 8 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ushr,
      -1, 0,
      { 939, 322 },
      -1,
   } },

   /* replace278_0_0_0_0 -> 48 in the cache */
   /* replace278_0_0_0_1 -> 22 in the cache */
   /* replace278_0_0_0 -> 930 in the cache */
   /* replace278_0_0_1_0 -> 148 in the cache */
   /* replace278_0_0_1_1 -> 22 in the cache */
   /* replace278_0_0_1 -> 931 in the cache */
   /* replace278_0_0 -> 932 in the cache */
   /* replace278_0_1 -> 933 in the cache */
   /* replace278_0 -> 934 in the cache */
   /* replace278_1_0 -> 19 in the cache */
   /* replace278_1_1_0 -> 48 in the cache */
   /* replace278_1_1_1 -> 148 in the cache */
   /* replace278_1_1 -> 935 in the cache */
   { .expression = {
      { nir_search_value_expression, 8 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ushr,
      -1, 1,
      { 19, 935 },
      -1,
   } },
   /* replace278_2 -> 937 in the cache */
   { .expression = {
      { nir_search_value_expression, 8 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_bcsel,
      -1, 4,
      { 934, 941, 937 },
      -1,
   } },

   /* ('ishr@8', ('ishr@8', 'a', '#b'), '#c') => ('ishr@8', 'a', ('imin', ('iadd', ('iand', 'b', 7), ('iand', 'c', 7)), 7)) */
   /* search279_0_0 -> 19 in the cache */
   /* search279_0_1 -> 45 in the cache */
   { .expression = {
      { nir_search_value_expression, 8 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ishr,
      -1, 0,
      { 19, 45 },
      -1,
   } },
   /* search279_1 -> 322 in the cache */
   { .expression = {
      { nir_search_value_expression, 8 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ishr,
      -1, 0,
      { 943, 322 },
      -1,
   } },

   /* replace279_0 -> 19 in the cache */
   /* replace279_1_0_0_0 -> 48 in the cache */
   /* replace279_1_0_0_1 -> 22 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_iand,
      2, 1,
      { 48, 22 },
      -1,
   } },
   /* replace279_1_0_1_0 -> 148 in the cache */
   /* replace279_1_0_1_1 -> 22 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_iand,
      3, 1,
      { 148, 22 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_iadd,
      1, 3,
      { 945, 946 },
      -1,
   } },
   /* replace279_1_1 -> 22 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_imin,
      0, 4,
      { 947, 22 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 8 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ishr,
      -1, 4,
      { 19, 948 },
      -1,
   } },

   /* ('ishl@16', ('ishl@16', 'a', '#b'), '#c') => ('bcsel', ('ult', ('iadd', ('iand', 'b', 15), ('iand', 'c', 15)), 16), ('ishl@16', 'a', ('iadd', 'b', 'c')), 0) */
   /* search280_0_0 -> 24 in the cache */
   /* search280_0_1 -> 45 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ishl,
      -1, 0,
      { 24, 45 },
      -1,
   } },
   /* search280_1 -> 322 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ishl,
      -1, 0,
      { 950, 322 },
      -1,
   } },

   /* replace280_0_0_0_0 -> 48 in the cache */
   /* replace280_0_0_0_1 -> 27 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_iand,
      1, 1,
      { 48, 27 },
      -1,
   } },
   /* replace280_0_0_1_0 -> 148 in the cache */
   /* replace280_0_0_1_1 -> 27 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_iand,
      2, 1,
      { 148, 27 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_iadd,
      0, 3,
      { 952, 953 },
      -1,
   } },
   { .constant = {
      { nir_search_value_constant, 32 },
      nir_type_int, { 0x10ull /* 16 */ },
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ult,
      -1, 3,
      { 954, 955 },
      -1,
   } },
   /* replace280_1_0 -> 24 in the cache */
   /* replace280_1_1_0 -> 48 in the cache */
   /* replace280_1_1_1 -> 148 in the cache */
   /* replace280_1_1 -> 935 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ishl,
      -1, 1,
      { 24, 935 },
      -1,
   } },
   { .constant = {
      { nir_search_value_constant, 16 },
      nir_type_int, { 0x0ull /* 0 */ },
   } },
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_bcsel,
      -1, 4,
      { 956, 957, 958 },
      -1,
   } },

   /* ('ushr@16', ('ushr@16', 'a', '#b'), '#c') => ('bcsel', ('ult', ('iadd', ('iand', 'b', 15), ('iand', 'c', 15)), 16), ('ushr@16', 'a', ('iadd', 'b', 'c')), 0) */
   /* search281_0_0 -> 24 in the cache */
   /* search281_0_1 -> 45 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ushr,
      -1, 0,
      { 24, 45 },
      -1,
   } },
   /* search281_1 -> 322 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ushr,
      -1, 0,
      { 960, 322 },
      -1,
   } },

   /* replace281_0_0_0_0 -> 48 in the cache */
   /* replace281_0_0_0_1 -> 27 in the cache */
   /* replace281_0_0_0 -> 952 in the cache */
   /* replace281_0_0_1_0 -> 148 in the cache */
   /* replace281_0_0_1_1 -> 27 in the cache */
   /* replace281_0_0_1 -> 953 in the cache */
   /* replace281_0_0 -> 954 in the cache */
   /* replace281_0_1 -> 955 in the cache */
   /* replace281_0 -> 956 in the cache */
   /* replace281_1_0 -> 24 in the cache */
   /* replace281_1_1_0 -> 48 in the cache */
   /* replace281_1_1_1 -> 148 in the cache */
   /* replace281_1_1 -> 935 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ushr,
      -1, 1,
      { 24, 935 },
      -1,
   } },
   /* replace281_2 -> 958 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_bcsel,
      -1, 4,
      { 956, 962, 958 },
      -1,
   } },

   /* ('ishr@16', ('ishr@16', 'a', '#b'), '#c') => ('ishr@16', 'a', ('imin', ('iadd', ('iand', 'b', 15), ('iand', 'c', 15)), 15)) */
   /* search282_0_0 -> 24 in the cache */
   /* search282_0_1 -> 45 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ishr,
      -1, 0,
      { 24, 45 },
      -1,
   } },
   /* search282_1 -> 322 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ishr,
      -1, 0,
      { 964, 322 },
      -1,
   } },

   /* replace282_0 -> 24 in the cache */
   /* replace282_1_0_0_0 -> 48 in the cache */
   /* replace282_1_0_0_1 -> 27 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_iand,
      2, 1,
      { 48, 27 },
      -1,
   } },
   /* replace282_1_0_1_0 -> 148 in the cache */
   /* replace282_1_0_1_1 -> 27 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_iand,
      3, 1,
      { 148, 27 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_iadd,
      1, 3,
      { 966, 967 },
      -1,
   } },
   /* replace282_1_1 -> 27 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_imin,
      0, 4,
      { 968, 27 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ishr,
      -1, 4,
      { 24, 969 },
      -1,
   } },

   /* ('ishl@32', ('ishl@32', 'a', '#b'), '#c') => ('bcsel', ('ult', ('iadd', ('iand', 'b', 31), ('iand', 'c', 31)), 32), ('ishl@32', 'a', ('iadd', 'b', 'c')), 0) */
   /* search283_0_0 -> 29 in the cache */
   /* search283_0_1 -> 45 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ishl,
      -1, 0,
      { 29, 45 },
      -1,
   } },
   /* search283_1 -> 322 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ishl,
      -1, 0,
      { 971, 322 },
      -1,
   } },

   /* replace283_0_0_0_0 -> 48 in the cache */
   /* replace283_0_0_0_1 -> 32 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_iand,
      1, 1,
      { 48, 32 },
      -1,
   } },
   /* replace283_0_0_1_0 -> 148 in the cache */
   /* replace283_0_0_1_1 -> 32 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_iand,
      2, 1,
      { 148, 32 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_iadd,
      0, 3,
      { 973, 974 },
      -1,
   } },
   { .constant = {
      { nir_search_value_constant, 32 },
      nir_type_int, { 0x20ull /* 32 */ },
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ult,
      -1, 3,
      { 975, 976 },
      -1,
   } },
   /* replace283_1_0 -> 29 in the cache */
   /* replace283_1_1_0 -> 48 in the cache */
   /* replace283_1_1_1 -> 148 in the cache */
   /* replace283_1_1 -> 935 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ishl,
      -1, 1,
      { 29, 935 },
      -1,
   } },
   /* replace283_2 -> 135 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_bcsel,
      -1, 4,
      { 977, 978, 135 },
      -1,
   } },

   /* ('ushr@32', ('ushr@32', 'a', '#b'), '#c') => ('bcsel', ('ult', ('iadd', ('iand', 'b', 31), ('iand', 'c', 31)), 32), ('ushr@32', 'a', ('iadd', 'b', 'c')), 0) */
   /* search284_0_0 -> 29 in the cache */
   /* search284_0_1 -> 45 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ushr,
      -1, 0,
      { 29, 45 },
      -1,
   } },
   /* search284_1 -> 322 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ushr,
      -1, 0,
      { 980, 322 },
      -1,
   } },

   /* replace284_0_0_0_0 -> 48 in the cache */
   /* replace284_0_0_0_1 -> 32 in the cache */
   /* replace284_0_0_0 -> 973 in the cache */
   /* replace284_0_0_1_0 -> 148 in the cache */
   /* replace284_0_0_1_1 -> 32 in the cache */
   /* replace284_0_0_1 -> 974 in the cache */
   /* replace284_0_0 -> 975 in the cache */
   /* replace284_0_1 -> 976 in the cache */
   /* replace284_0 -> 977 in the cache */
   /* replace284_1_0 -> 29 in the cache */
   /* replace284_1_1_0 -> 48 in the cache */
   /* replace284_1_1_1 -> 148 in the cache */
   /* replace284_1_1 -> 935 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ushr,
      -1, 1,
      { 29, 935 },
      -1,
   } },
   /* replace284_2 -> 135 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_bcsel,
      -1, 4,
      { 977, 982, 135 },
      -1,
   } },

   /* ('ishr@32', ('ishr@32', 'a', '#b'), '#c') => ('ishr@32', 'a', ('imin', ('iadd', ('iand', 'b', 31), ('iand', 'c', 31)), 31)) */
   /* search285_0_0 -> 29 in the cache */
   /* search285_0_1 -> 45 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ishr,
      -1, 0,
      { 29, 45 },
      -1,
   } },
   /* search285_1 -> 322 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ishr,
      -1, 0,
      { 984, 322 },
      -1,
   } },

   /* replace285_0 -> 29 in the cache */
   /* replace285_1_0_0_0 -> 48 in the cache */
   /* replace285_1_0_0_1 -> 32 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_iand,
      2, 1,
      { 48, 32 },
      -1,
   } },
   /* replace285_1_0_1_0 -> 148 in the cache */
   /* replace285_1_0_1_1 -> 32 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_iand,
      3, 1,
      { 148, 32 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_iadd,
      1, 3,
      { 986, 987 },
      -1,
   } },
   /* replace285_1_1 -> 32 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_imin,
      0, 4,
      { 988, 32 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ishr,
      -1, 4,
      { 29, 989 },
      -1,
   } },

   /* ('ishl@64', ('ishl@64', 'a', '#b'), '#c') => ('bcsel', ('ult', ('iadd', ('iand', 'b', 63), ('iand', 'c', 63)), 64), ('ishl@64', 'a', ('iadd', 'b', 'c')), 0) */
   /* search286_0_0 -> 34 in the cache */
   /* search286_0_1 -> 45 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ishl,
      -1, 0,
      { 34, 45 },
      -1,
   } },
   /* search286_1 -> 322 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ishl,
      -1, 0,
      { 991, 322 },
      -1,
   } },

   /* replace286_0_0_0_0 -> 48 in the cache */
   /* replace286_0_0_0_1 -> 37 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_iand,
      1, 1,
      { 48, 37 },
      -1,
   } },
   /* replace286_0_0_1_0 -> 148 in the cache */
   /* replace286_0_0_1_1 -> 37 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_iand,
      2, 1,
      { 148, 37 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_iadd,
      0, 3,
      { 993, 994 },
      -1,
   } },
   { .constant = {
      { nir_search_value_constant, 32 },
      nir_type_int, { 0x40ull /* 64 */ },
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ult,
      -1, 3,
      { 995, 996 },
      -1,
   } },
   /* replace286_1_0 -> 34 in the cache */
   /* replace286_1_1_0 -> 48 in the cache */
   /* replace286_1_1_1 -> 148 in the cache */
   /* replace286_1_1 -> 935 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ishl,
      -1, 1,
      { 34, 935 },
      -1,
   } },
   { .constant = {
      { nir_search_value_constant, 64 },
      nir_type_int, { 0x0ull /* 0 */ },
   } },
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_bcsel,
      -1, 4,
      { 997, 998, 999 },
      -1,
   } },

   /* ('ushr@64', ('ushr@64', 'a', '#b'), '#c') => ('bcsel', ('ult', ('iadd', ('iand', 'b', 63), ('iand', 'c', 63)), 64), ('ushr@64', 'a', ('iadd', 'b', 'c')), 0) */
   /* search287_0_0 -> 34 in the cache */
   /* search287_0_1 -> 45 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ushr,
      -1, 0,
      { 34, 45 },
      -1,
   } },
   /* search287_1 -> 322 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ushr,
      -1, 0,
      { 1001, 322 },
      -1,
   } },

   /* replace287_0_0_0_0 -> 48 in the cache */
   /* replace287_0_0_0_1 -> 37 in the cache */
   /* replace287_0_0_0 -> 993 in the cache */
   /* replace287_0_0_1_0 -> 148 in the cache */
   /* replace287_0_0_1_1 -> 37 in the cache */
   /* replace287_0_0_1 -> 994 in the cache */
   /* replace287_0_0 -> 995 in the cache */
   /* replace287_0_1 -> 996 in the cache */
   /* replace287_0 -> 997 in the cache */
   /* replace287_1_0 -> 34 in the cache */
   /* replace287_1_1_0 -> 48 in the cache */
   /* replace287_1_1_1 -> 148 in the cache */
   /* replace287_1_1 -> 935 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ushr,
      -1, 1,
      { 34, 935 },
      -1,
   } },
   /* replace287_2 -> 999 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_bcsel,
      -1, 4,
      { 997, 1003, 999 },
      -1,
   } },

   /* ('ishr@64', ('ishr@64', 'a', '#b'), '#c') => ('ishr@64', 'a', ('imin', ('iadd', ('iand', 'b', 63), ('iand', 'c', 63)), 63)) */
   /* search288_0_0 -> 34 in the cache */
   /* search288_0_1 -> 45 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ishr,
      -1, 0,
      { 34, 45 },
      -1,
   } },
   /* search288_1 -> 322 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ishr,
      -1, 0,
      { 1005, 322 },
      -1,
   } },

   /* replace288_0 -> 34 in the cache */
   /* replace288_1_0_0_0 -> 48 in the cache */
   /* replace288_1_0_0_1 -> 37 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_iand,
      2, 1,
      { 48, 37 },
      -1,
   } },
   /* replace288_1_0_1_0 -> 148 in the cache */
   /* replace288_1_0_1_1 -> 37 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_iand,
      3, 1,
      { 148, 37 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_iadd,
      1, 3,
      { 1007, 1008 },
      -1,
   } },
   /* replace288_1_1 -> 37 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_imin,
      0, 4,
      { 1009, 37 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ishr,
      -1, 4,
      { 34, 1010 },
      -1,
   } },

   /* ('ishl', ('ushr', 'a@8', '#b'), 'b') => ('iand', 'a', ('ishl', 255, 'b')) */
   /* search289_0_0 -> 19 in the cache */
   /* search289_0_1 -> 45 in the cache */
   /* search289_0 -> 939 in the cache */
   /* search289_1 -> 48 in the cache */
   { .expression = {
      { nir_search_value_expression, 8 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ishl,
      -1, 0,
      { 939, 48 },
      -1,
   } },

   /* replace289_0 -> 19 in the cache */
   { .constant = {
      { nir_search_value_constant, 8 },
      nir_type_int, { 0xffull /* 255 */ },
   } },
   /* replace289_1_1 -> 48 in the cache */
   { .expression = {
      { nir_search_value_expression, 8 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ishl,
      -1, 0,
      { 1013, 48 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 8 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_iand,
      0, 1,
      { 19, 1014 },
      -1,
   } },

   /* ('ishl', ('ishr', 'a@8', '#b'), 'b') => ('iand', 'a', ('ishl', 255, 'b')) */
   /* search290_0_0 -> 19 in the cache */
   /* search290_0_1 -> 45 in the cache */
   /* search290_0 -> 943 in the cache */
   /* search290_1 -> 48 in the cache */
   { .expression = {
      { nir_search_value_expression, 8 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ishl,
      -1, 0,
      { 943, 48 },
      -1,
   } },

   /* replace290_0 -> 19 in the cache */
   /* replace290_1_0 -> 1013 in the cache */
   /* replace290_1_1 -> 48 in the cache */
   /* replace290_1 -> 1014 in the cache */
   /* replace290 -> 1015 in the cache */

   /* ('ushr', ('ishl', 'a@8', '#b'), 'b') => ('iand', 'a', ('ushr', 255, 'b')) */
   /* search291_0_0 -> 19 in the cache */
   /* search291_0_1 -> 45 in the cache */
   /* search291_0 -> 928 in the cache */
   /* search291_1 -> 48 in the cache */
   { .expression = {
      { nir_search_value_expression, 8 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ushr,
      -1, 0,
      { 928, 48 },
      -1,
   } },

   /* replace291_0 -> 19 in the cache */
   /* replace291_1_0 -> 1013 in the cache */
   /* replace291_1_1 -> 48 in the cache */
   { .expression = {
      { nir_search_value_expression, 8 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ushr,
      -1, 0,
      { 1013, 48 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 8 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_iand,
      0, 1,
      { 19, 1018 },
      -1,
   } },

   /* ('ishl', ('ushr', 'a@16', '#b'), 'b') => ('iand', 'a', ('ishl', 65535, 'b')) */
   /* search292_0_0 -> 24 in the cache */
   /* search292_0_1 -> 45 in the cache */
   /* search292_0 -> 960 in the cache */
   /* search292_1 -> 48 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ishl,
      -1, 0,
      { 960, 48 },
      -1,
   } },

   /* replace292_0 -> 24 in the cache */
   { .constant = {
      { nir_search_value_constant, 16 },
      nir_type_int, { 0xffffull /* 65535 */ },
   } },
   /* replace292_1_1 -> 48 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ishl,
      -1, 0,
      { 1021, 48 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_iand,
      0, 1,
      { 24, 1022 },
      -1,
   } },

   /* ('ishl', ('ishr', 'a@16', '#b'), 'b') => ('iand', 'a', ('ishl', 65535, 'b')) */
   /* search293_0_0 -> 24 in the cache */
   /* search293_0_1 -> 45 in the cache */
   /* search293_0 -> 964 in the cache */
   /* search293_1 -> 48 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ishl,
      -1, 0,
      { 964, 48 },
      -1,
   } },

   /* replace293_0 -> 24 in the cache */
   /* replace293_1_0 -> 1021 in the cache */
   /* replace293_1_1 -> 48 in the cache */
   /* replace293_1 -> 1022 in the cache */
   /* replace293 -> 1023 in the cache */

   /* ('ushr', ('ishl', 'a@16', '#b'), 'b') => ('iand', 'a', ('ushr', 65535, 'b')) */
   /* search294_0_0 -> 24 in the cache */
   /* search294_0_1 -> 45 in the cache */
   /* search294_0 -> 950 in the cache */
   /* search294_1 -> 48 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ushr,
      -1, 0,
      { 950, 48 },
      -1,
   } },

   /* replace294_0 -> 24 in the cache */
   /* replace294_1_0 -> 1021 in the cache */
   /* replace294_1_1 -> 48 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ushr,
      -1, 0,
      { 1021, 48 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_iand,
      0, 1,
      { 24, 1026 },
      -1,
   } },

   /* ('ishl', ('ushr', 'a@32', '#b'), 'b') => ('iand', 'a', ('ishl', 4294967295, 'b')) */
   /* search295_0_0 -> 29 in the cache */
   /* search295_0_1 -> 45 in the cache */
   /* search295_0 -> 980 in the cache */
   /* search295_1 -> 48 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ishl,
      -1, 0,
      { 980, 48 },
      -1,
   } },

   /* replace295_0 -> 29 in the cache */
   { .constant = {
      { nir_search_value_constant, 32 },
      nir_type_int, { 0xffffffffull /* 4294967295 */ },
   } },
   /* replace295_1_1 -> 48 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ishl,
      -1, 0,
      { 1029, 48 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_iand,
      0, 1,
      { 29, 1030 },
      -1,
   } },

   /* ('ishl', ('ishr', 'a@32', '#b'), 'b') => ('iand', 'a', ('ishl', 4294967295, 'b')) */
   /* search296_0_0 -> 29 in the cache */
   /* search296_0_1 -> 45 in the cache */
   /* search296_0 -> 984 in the cache */
   /* search296_1 -> 48 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ishl,
      -1, 0,
      { 984, 48 },
      -1,
   } },

   /* replace296_0 -> 29 in the cache */
   /* replace296_1_0 -> 1029 in the cache */
   /* replace296_1_1 -> 48 in the cache */
   /* replace296_1 -> 1030 in the cache */
   /* replace296 -> 1031 in the cache */

   /* ('ushr', ('ishl', 'a@32', '#b'), 'b') => ('iand', 'a', ('ushr', 4294967295, 'b')) */
   /* search297_0_0 -> 29 in the cache */
   /* search297_0_1 -> 45 in the cache */
   /* search297_0 -> 971 in the cache */
   /* search297_1 -> 48 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ushr,
      -1, 0,
      { 971, 48 },
      -1,
   } },

   /* replace297_0 -> 29 in the cache */
   /* replace297_1_0 -> 1029 in the cache */
   /* replace297_1_1 -> 48 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ushr,
      -1, 0,
      { 1029, 48 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_iand,
      0, 1,
      { 29, 1034 },
      -1,
   } },

   /* ('ishl', ('ushr', 'a@64', '#b'), 'b') => ('iand', 'a', ('ishl', 18446744073709551615, 'b')) */
   /* search298_0_0 -> 34 in the cache */
   /* search298_0_1 -> 45 in the cache */
   /* search298_0 -> 1001 in the cache */
   /* search298_1 -> 48 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ishl,
      -1, 0,
      { 1001, 48 },
      -1,
   } },

   /* replace298_0 -> 34 in the cache */
   { .constant = {
      { nir_search_value_constant, 64 },
      nir_type_int, { 0xffffffffffffffffull /* 18446744073709551615 */ },
   } },
   /* replace298_1_1 -> 48 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ishl,
      -1, 0,
      { 1037, 48 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_iand,
      0, 1,
      { 34, 1038 },
      -1,
   } },

   /* ('ishl', ('ishr', 'a@64', '#b'), 'b') => ('iand', 'a', ('ishl', 18446744073709551615, 'b')) */
   /* search299_0_0 -> 34 in the cache */
   /* search299_0_1 -> 45 in the cache */
   /* search299_0 -> 1005 in the cache */
   /* search299_1 -> 48 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ishl,
      -1, 0,
      { 1005, 48 },
      -1,
   } },

   /* replace299_0 -> 34 in the cache */
   /* replace299_1_0 -> 1037 in the cache */
   /* replace299_1_1 -> 48 in the cache */
   /* replace299_1 -> 1038 in the cache */
   /* replace299 -> 1039 in the cache */

   /* ('ushr', ('ishl', 'a@64', '#b'), 'b') => ('iand', 'a', ('ushr', 18446744073709551615, 'b')) */
   /* search300_0_0 -> 34 in the cache */
   /* search300_0_1 -> 45 in the cache */
   /* search300_0 -> 991 in the cache */
   /* search300_1 -> 48 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ushr,
      -1, 0,
      { 991, 48 },
      -1,
   } },

   /* replace300_0 -> 34 in the cache */
   /* replace300_1_0 -> 1037 in the cache */
   /* replace300_1_1 -> 48 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ushr,
      -1, 0,
      { 1037, 48 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_iand,
      0, 1,
      { 34, 1042 },
      -1,
   } },

   /* ('iand', ('ishl', 'a@32', '#b(is_first_5_bits_uge_2)'), -4) => ('ishl', 'a', 'b') */
   /* search301_0_0 -> 29 in the cache */
   { .variable = {
      { nir_search_value_variable, 32 },
      1, /* b */
      true,
      nir_type_invalid,
      9,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ishl,
      -1, 0,
      { 29, 1044 },
      -1,
   } },
   { .constant = {
      { nir_search_value_constant, 32 },
      nir_type_int, { 0xfffffffffffffffcull /* -4 */ },
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_iand,
      0, 1,
      { 1045, 1046 },
      -1,
   } },

   /* replace301_0 -> 29 in the cache */
   /* replace301_1 -> 48 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ishl,
      -1, 0,
      { 29, 48 },
      -1,
   } },

   /* ('iand', ('imul', 'a', '#b(is_unsigned_multiple_of_4)'), -4) => ('imul', 'a', 'b') */
   /* search302_0_0 -> 0 in the cache */
   { .variable = {
      { nir_search_value_variable, -2 },
      1, /* b */
      true,
      nir_type_invalid,
      10,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_imul,
      1, 1,
      { 0, 1049 },
      -1,
   } },
   { .constant = {
      { nir_search_value_constant, -2 },
      nir_type_int, { 0xfffffffffffffffcull /* -4 */ },
   } },
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_iand,
      0, 2,
      { 1050, 1051 },
      -1,
   } },

   /* replace302_0 -> 0 in the cache */
   /* replace302_1 -> 1 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_imul,
      0, 1,
      { 0, 1 },
      -1,
   } },

   /* ('iand@32', ('iadd@32', 'a', '#b(is_unsigned_multiple_of_2)'), 4294967294) => ('iadd', ('iand', 'a', 4294967294), 'b') */
   /* search303_0_0 -> 29 in the cache */
   { .variable = {
      { nir_search_value_variable, 32 },
      1, /* b */
      true,
      nir_type_invalid,
      11,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_iadd,
      1, 1,
      { 29, 1054 },
      -1,
   } },
   { .constant = {
      { nir_search_value_constant, 32 },
      nir_type_int, { 0xfffffffeull /* 4294967294 */ },
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_iand,
      0, 2,
      { 1055, 1056 },
      -1,
   } },

   /* replace303_0_0 -> 29 in the cache */
   /* replace303_0_1 -> 1056 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_iand,
      1, 1,
      { 29, 1056 },
      -1,
   } },
   /* replace303_1 -> 48 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_iadd,
      0, 2,
      { 1058, 48 },
      -1,
   } },

   /* ('iand@32', ('iadd@32', 'a', '#b(is_unsigned_multiple_of_4)'), 4294967292) => ('iadd', ('iand', 'a', 4294967292), 'b') */
   /* search304_0_0 -> 29 in the cache */
   { .variable = {
      { nir_search_value_variable, 32 },
      1, /* b */
      true,
      nir_type_invalid,
      10,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_iadd,
      1, 1,
      { 29, 1060 },
      -1,
   } },
   { .constant = {
      { nir_search_value_constant, 32 },
      nir_type_int, { 0xfffffffcull /* 4294967292 */ },
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_iand,
      0, 2,
      { 1061, 1062 },
      -1,
   } },

   /* replace304_0_0 -> 29 in the cache */
   /* replace304_0_1 -> 1062 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_iand,
      1, 1,
      { 29, 1062 },
      -1,
   } },
   /* replace304_1 -> 48 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_iadd,
      0, 2,
      { 1064, 48 },
      -1,
   } },

   /* ('iand@32', ('iadd@32', 'a', '#b(is_unsigned_multiple_of_8)'), 4294967288) => ('iadd', ('iand', 'a', 4294967288), 'b') */
   /* search305_0_0 -> 29 in the cache */
   { .variable = {
      { nir_search_value_variable, 32 },
      1, /* b */
      true,
      nir_type_invalid,
      12,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_iadd,
      1, 1,
      { 29, 1066 },
      -1,
   } },
   { .constant = {
      { nir_search_value_constant, 32 },
      nir_type_int, { 0xfffffff8ull /* 4294967288 */ },
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_iand,
      0, 2,
      { 1067, 1068 },
      -1,
   } },

   /* replace305_0_0 -> 29 in the cache */
   /* replace305_0_1 -> 1068 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_iand,
      1, 1,
      { 29, 1068 },
      -1,
   } },
   /* replace305_1 -> 48 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_iadd,
      0, 2,
      { 1070, 48 },
      -1,
   } },

   /* ('iand@32', ('iadd@32', 'a', '#b(is_unsigned_multiple_of_16)'), 4294967280) => ('iadd', ('iand', 'a', 4294967280), 'b') */
   /* search306_0_0 -> 29 in the cache */
   { .variable = {
      { nir_search_value_variable, 32 },
      1, /* b */
      true,
      nir_type_invalid,
      13,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_iadd,
      1, 1,
      { 29, 1072 },
      -1,
   } },
   { .constant = {
      { nir_search_value_constant, 32 },
      nir_type_int, { 0xfffffff0ull /* 4294967280 */ },
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_iand,
      0, 2,
      { 1073, 1074 },
      -1,
   } },

   /* replace306_0_0 -> 29 in the cache */
   /* replace306_0_1 -> 1074 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_iand,
      1, 1,
      { 29, 1074 },
      -1,
   } },
   /* replace306_1 -> 48 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_iadd,
      0, 2,
      { 1076, 48 },
      -1,
   } },

   /* ('iand@32', ('iadd@32', 'a', '#b(is_unsigned_multiple_of_32)'), 4294967264) => ('iadd', ('iand', 'a', 4294967264), 'b') */
   /* search307_0_0 -> 29 in the cache */
   { .variable = {
      { nir_search_value_variable, 32 },
      1, /* b */
      true,
      nir_type_invalid,
      14,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_iadd,
      1, 1,
      { 29, 1078 },
      -1,
   } },
   { .constant = {
      { nir_search_value_constant, 32 },
      nir_type_int, { 0xffffffe0ull /* 4294967264 */ },
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_iand,
      0, 2,
      { 1079, 1080 },
      -1,
   } },

   /* replace307_0_0 -> 29 in the cache */
   /* replace307_0_1 -> 1080 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_iand,
      1, 1,
      { 29, 1080 },
      -1,
   } },
   /* replace307_1 -> 48 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_iadd,
      0, 2,
      { 1082, 48 },
      -1,
   } },

   /* ('iand@32', ('iadd@32', 'a', '#b(is_unsigned_multiple_of_64)'), 4294967232) => ('iadd', ('iand', 'a', 4294967232), 'b') */
   /* search308_0_0 -> 29 in the cache */
   { .variable = {
      { nir_search_value_variable, 32 },
      1, /* b */
      true,
      nir_type_invalid,
      15,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_iadd,
      1, 1,
      { 29, 1084 },
      -1,
   } },
   { .constant = {
      { nir_search_value_constant, 32 },
      nir_type_int, { 0xffffffc0ull /* 4294967232 */ },
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_iand,
      0, 2,
      { 1085, 1086 },
      -1,
   } },

   /* replace308_0_0 -> 29 in the cache */
   /* replace308_0_1 -> 1086 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_iand,
      1, 1,
      { 29, 1086 },
      -1,
   } },
   /* replace308_1 -> 48 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_iadd,
      0, 2,
      { 1088, 48 },
      -1,
   } },

   /* ('ishl@32', ('iand', 'a@32', 2147483647), 1) => ('ishl', 'a', 1) */
   /* search309_0_0 -> 29 in the cache */
   { .constant = {
      { nir_search_value_constant, 32 },
      nir_type_int, { 0x7fffffffull /* 2147483647 */ },
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_iand,
      0, 1,
      { 29, 1090 },
      -1,
   } },
   /* search309_1 -> 498 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ishl,
      -1, 1,
      { 1091, 498 },
      -1,
   } },

   /* replace309_0 -> 29 in the cache */
   /* replace309_1 -> 498 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ishl,
      -1, 0,
      { 29, 498 },
      -1,
   } },

   /* ('iand', ('ishl', 'a@32', 1), 4294967294) => ('ishl', 'a', 1) */
   /* search310_0_0 -> 29 in the cache */
   /* search310_0_1 -> 498 in the cache */
   /* search310_0 -> 1093 in the cache */
   /* search310_1 -> 1056 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_iand,
      0, 1,
      { 1093, 1056 },
      -1,
   } },

   /* replace310_0 -> 29 in the cache */
   /* replace310_1 -> 498 in the cache */
   /* replace310 -> 1093 in the cache */

   /* ('iand', ('ushr', 'a@32', 1), 2147483647) => ('ushr', 'a', 1) */
   /* search311_0_0 -> 29 in the cache */
   /* search311_0_1 -> 498 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ushr,
      -1, 0,
      { 29, 498 },
      -1,
   } },
   /* search311_1 -> 1090 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_iand,
      0, 1,
      { 1095, 1090 },
      -1,
   } },

   /* replace311_0 -> 29 in the cache */
   /* replace311_1 -> 498 in the cache */
   /* replace311 -> 1095 in the cache */

   /* ('ishl@32', ('iand', 'a@32', 1073741823), 2) => ('ishl', 'a', 2) */
   /* search312_0_0 -> 29 in the cache */
   { .constant = {
      { nir_search_value_constant, 32 },
      nir_type_int, { 0x3fffffffull /* 1073741823 */ },
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_iand,
      0, 1,
      { 29, 1097 },
      -1,
   } },
   /* search312_1 -> 503 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ishl,
      -1, 1,
      { 1098, 503 },
      -1,
   } },

   /* replace312_0 -> 29 in the cache */
   /* replace312_1 -> 503 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ishl,
      -1, 0,
      { 29, 503 },
      -1,
   } },

   /* ('iand', ('ishl', 'a@32', 2), 4294967292) => ('ishl', 'a', 2) */
   /* search313_0_0 -> 29 in the cache */
   /* search313_0_1 -> 503 in the cache */
   /* search313_0 -> 1100 in the cache */
   /* search313_1 -> 1062 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_iand,
      0, 1,
      { 1100, 1062 },
      -1,
   } },

   /* replace313_0 -> 29 in the cache */
   /* replace313_1 -> 503 in the cache */
   /* replace313 -> 1100 in the cache */

   /* ('iand', ('ushr', 'a@32', 2), 1073741823) => ('ushr', 'a', 2) */
   /* search314_0_0 -> 29 in the cache */
   /* search314_0_1 -> 503 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ushr,
      -1, 0,
      { 29, 503 },
      -1,
   } },
   /* search314_1 -> 1097 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_iand,
      0, 1,
      { 1102, 1097 },
      -1,
   } },

   /* replace314_0 -> 29 in the cache */
   /* replace314_1 -> 503 in the cache */
   /* replace314 -> 1102 in the cache */

   /* ('ishl@32', ('iand', 'a@32', 65535), 16) => ('ishl', 'a', 16) */
   /* search315_0_0 -> 29 in the cache */
   { .constant = {
      { nir_search_value_constant, 32 },
      nir_type_int, { 0xffffull /* 65535 */ },
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_iand,
      0, 1,
      { 29, 1104 },
      -1,
   } },
   /* search315_1 -> 955 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ishl,
      -1, 1,
      { 1105, 955 },
      -1,
   } },

   /* replace315_0 -> 29 in the cache */
   /* replace315_1 -> 955 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ishl,
      -1, 0,
      { 29, 955 },
      -1,
   } },

   /* ('iand', ('ishl', 'a@32', 16), 4294901760) => ('ishl', 'a', 16) */
   /* search316_0_0 -> 29 in the cache */
   /* search316_0_1 -> 955 in the cache */
   /* search316_0 -> 1107 in the cache */
   { .constant = {
      { nir_search_value_constant, 32 },
      nir_type_int, { 0xffff0000ull /* 4294901760 */ },
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_iand,
      0, 1,
      { 1107, 1108 },
      -1,
   } },

   /* replace316_0 -> 29 in the cache */
   /* replace316_1 -> 955 in the cache */
   /* replace316 -> 1107 in the cache */

   /* ('iand', ('ushr', 'a@32', 16), 65535) => ('ushr', 'a', 16) */
   /* search317_0_0 -> 29 in the cache */
   /* search317_0_1 -> 955 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ushr,
      -1, 0,
      { 29, 955 },
      -1,
   } },
   /* search317_1 -> 1104 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_iand,
      0, 1,
      { 1110, 1104 },
      -1,
   } },

   /* replace317_0 -> 29 in the cache */
   /* replace317_1 -> 955 in the cache */
   /* replace317 -> 1110 in the cache */

   /* ('ishl@32', ('iand', 'a@32', 255), 24) => ('ishl', 'a', 24) */
   /* search318_0_0 -> 29 in the cache */
   { .constant = {
      { nir_search_value_constant, 32 },
      nir_type_int, { 0xffull /* 255 */ },
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_iand,
      0, 1,
      { 29, 1112 },
      -1,
   } },
   { .constant = {
      { nir_search_value_constant, 32 },
      nir_type_int, { 0x18ull /* 24 */ },
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ishl,
      -1, 1,
      { 1113, 1114 },
      -1,
   } },

   /* replace318_0 -> 29 in the cache */
   /* replace318_1 -> 1114 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ishl,
      -1, 0,
      { 29, 1114 },
      -1,
   } },

   /* ('iand', ('ishl', 'a@32', 24), 4278190080) => ('ishl', 'a', 24) */
   /* search319_0_0 -> 29 in the cache */
   /* search319_0_1 -> 1114 in the cache */
   /* search319_0 -> 1116 in the cache */
   { .constant = {
      { nir_search_value_constant, 32 },
      nir_type_int, { 0xff000000ull /* 4278190080 */ },
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_iand,
      0, 1,
      { 1116, 1117 },
      -1,
   } },

   /* replace319_0 -> 29 in the cache */
   /* replace319_1 -> 1114 in the cache */
   /* replace319 -> 1116 in the cache */

   /* ('iand', ('ushr', 'a@32', 24), 255) => ('ushr', 'a', 24) */
   /* search320_0_0 -> 29 in the cache */
   /* search320_0_1 -> 1114 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ushr,
      -1, 0,
      { 29, 1114 },
      -1,
   } },
   /* search320_1 -> 1112 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_iand,
      0, 1,
      { 1119, 1112 },
      -1,
   } },

   /* replace320_0 -> 29 in the cache */
   /* replace320_1 -> 1114 in the cache */
   /* replace320 -> 1119 in the cache */

   /* ('ishl', ('iadd', 'a', '#b'), '#c') => ('iadd', ('ishl', 'a', 'c'), ('ishl', 'b', 'c')) */
   /* search321_0_0 -> 0 in the cache */
   /* search321_0_1 -> 923 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_iadd,
      0, 1,
      { 0, 923 },
      -1,
   } },
   /* search321_1 -> 322 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ishl,
      -1, 1,
      { 1121, 322 },
      -1,
   } },

   /* replace321_0_0 -> 0 in the cache */
   /* replace321_0_1 -> 148 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ishl,
      -1, 0,
      { 0, 148 },
      -1,
   } },
   /* replace321_1_0 -> 1 in the cache */
   /* replace321_1_1 -> 148 in the cache */
   /* replace321_1 -> 926 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_iadd,
      0, 1,
      { 1123, 926 },
      -1,
   } },

   /* ('imul', ('iadd(is_used_once)', 'a', '#b'), '#c') => ('iadd', ('imul', 'a', 'c'), ('imul', 'b', 'c')) */
   /* search322_0_0 -> 139 in the cache */
   /* search322_0_1 -> 296 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_iadd,
      1, 1,
      { 139, 296 },
      0,
   } },
   /* search322_1 -> 916 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_imul,
      0, 2,
      { 1125, 916 },
      -1,
   } },

   /* replace322_0_0 -> 139 in the cache */
   /* replace322_0_1 -> 142 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_imul,
      1, 1,
      { 139, 142 },
      -1,
   } },
   /* replace322_1_0 -> 140 in the cache */
   /* replace322_1_1 -> 142 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_imul,
      2, 1,
      { 140, 142 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_iadd,
      0, 3,
      { 1127, 1128 },
      -1,
   } },

   /* ('imul', ('iadd(is_used_once)', ('iadd(is_used_once)', 'a', '#b'), 'c'), '#d') => ('iadd', ('imul', ('iadd', 'a', 'c'), 'd'), ('imul', 'b', 'd')) */
   /* search323_0_0_0 -> 162 in the cache */
   { .variable = {
      { nir_search_value_variable, -4 },
      1, /* b */
      true,
      nir_type_invalid,
      -1,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .expression = {
      { nir_search_value_expression, -4 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_iadd,
      2, 1,
      { 162, 1130 },
      0,
   } },
   /* search323_0_1 -> 165 in the cache */
   { .expression = {
      { nir_search_value_expression, -4 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_iadd,
      1, 2,
      { 1131, 165 },
      0,
   } },
   { .variable = {
      { nir_search_value_variable, -4 },
      3, /* d */
      true,
      nir_type_invalid,
      -1,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .expression = {
      { nir_search_value_expression, -4 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_imul,
      0, 3,
      { 1132, 1133 },
      -1,
   } },

   /* replace323_0_0_0 -> 162 in the cache */
   /* replace323_0_0_1 -> 165 in the cache */
   { .expression = {
      { nir_search_value_expression, -4 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_iadd,
      2, 1,
      { 162, 165 },
      -1,
   } },
   /* replace323_0_1 -> 166 in the cache */
   { .expression = {
      { nir_search_value_expression, -4 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_imul,
      1, 2,
      { 1135, 166 },
      -1,
   } },
   /* replace323_1_0 -> 163 in the cache */
   /* replace323_1_1 -> 166 in the cache */
   { .expression = {
      { nir_search_value_expression, -4 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_imul,
      3, 1,
      { 163, 166 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -4 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_iadd,
      0, 4,
      { 1136, 1137 },
      -1,
   } },

   /* ('ishl', ('iadd(is_used_once)', ('iadd(is_used_once)', 'a', '#b'), 'c'), '#d') => ('iadd', ('ishl', ('iadd', 'a', 'c'), 'd'), ('ishl', 'b', 'd')) */
   /* search324_0_0_0 -> 139 in the cache */
   /* search324_0_0_1 -> 296 in the cache */
   /* search324_0_0 -> 1125 in the cache */
   /* search324_0_1 -> 142 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_iadd,
      0, 2,
      { 1125, 142 },
      0,
   } },
   /* search324_1 -> 324 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ishl,
      -1, 2,
      { 1139, 324 },
      -1,
   } },

   /* replace324_0_0_0 -> 139 in the cache */
   /* replace324_0_0_1 -> 142 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_iadd,
      1, 1,
      { 139, 142 },
      -1,
   } },
   /* replace324_0_1 -> 176 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ishl,
      -1, 1,
      { 1141, 176 },
      -1,
   } },
   /* replace324_1_0 -> 140 in the cache */
   /* replace324_1_1 -> 176 in the cache */
   /* replace324_1 -> 919 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_iadd,
      0, 2,
      { 1142, 919 },
      -1,
   } },

   /* ('inot', ('flt(is_used_once)', 'a(is_a_number)', 'b(is_a_number)')) => ('fge', 'a', 'b') */
   { .variable = {
      { nir_search_value_variable, -2 },
      0, /* a */
      false,
      nir_type_invalid,
      16,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .variable = {
      { nir_search_value_variable, -2 },
      1, /* b */
      false,
      nir_type_invalid,
      16,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_flt,
      -1, 0,
      { 1144, 1145 },
      0,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_inot,
      -1, 0,
      { 1146 },
      -1,
   } },

   /* replace325_0 -> 0 in the cache */
   /* replace325_1 -> 1 in the cache */
   /* replace325 -> 6 in the cache */

   /* ('inot', ('fge(is_used_once)', 'a(is_a_number)', 'b(is_a_number)')) => ('flt', 'a', 'b') */
   /* search326_0_0 -> 1144 in the cache */
   /* search326_0_1 -> 1145 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fge,
      -1, 0,
      { 1144, 1145 },
      0,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_inot,
      -1, 0,
      { 1148 },
      -1,
   } },

   /* replace326_0 -> 0 in the cache */
   /* replace326_1 -> 1 in the cache */
   /* replace326 -> 3 in the cache */

   /* ('inot', ('feq(is_used_once)', 'a', 'b')) => ('fneu', 'a', 'b') */
   /* search327_0_0 -> 0 in the cache */
   /* search327_0_1 -> 1 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_feq,
      0, 1,
      { 0, 1 },
      0,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_inot,
      -1, 1,
      { 1150 },
      -1,
   } },

   /* replace327_0 -> 0 in the cache */
   /* replace327_1 -> 1 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fneu,
      0, 1,
      { 0, 1 },
      -1,
   } },

   /* ('inot', ('fneu(is_used_once)', 'a', 'b')) => ('feq', 'a', 'b') */
   /* search328_0_0 -> 0 in the cache */
   /* search328_0_1 -> 1 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fneu,
      0, 1,
      { 0, 1 },
      0,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_inot,
      -1, 1,
      { 1153 },
      -1,
   } },

   /* replace328_0 -> 0 in the cache */
   /* replace328_1 -> 1 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_feq,
      0, 1,
      { 0, 1 },
      -1,
   } },

   /* ('inot', ('ilt(is_used_once)', 'a', 'b')) => ('ige', 'a', 'b') */
   /* search329_0_0 -> 0 in the cache */
   /* search329_0_1 -> 1 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ilt,
      -1, 0,
      { 0, 1 },
      0,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_inot,
      -1, 0,
      { 1156 },
      -1,
   } },

   /* replace329_0 -> 0 in the cache */
   /* replace329_1 -> 1 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ige,
      -1, 0,
      { 0, 1 },
      -1,
   } },

   /* ('inot', ('ult(is_used_once)', 'a', 'b')) => ('uge', 'a', 'b') */
   /* search330_0_0 -> 0 in the cache */
   /* search330_0_1 -> 1 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ult,
      -1, 0,
      { 0, 1 },
      0,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_inot,
      -1, 0,
      { 1159 },
      -1,
   } },

   /* replace330_0 -> 0 in the cache */
   /* replace330_1 -> 1 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_uge,
      -1, 0,
      { 0, 1 },
      -1,
   } },

   /* ('inot', ('ige(is_used_once)', 'a', 'b')) => ('ilt', 'a', 'b') */
   /* search331_0_0 -> 0 in the cache */
   /* search331_0_1 -> 1 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ige,
      -1, 0,
      { 0, 1 },
      0,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_inot,
      -1, 0,
      { 1162 },
      -1,
   } },

   /* replace331_0 -> 0 in the cache */
   /* replace331_1 -> 1 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ilt,
      -1, 0,
      { 0, 1 },
      -1,
   } },

   /* ('inot', ('uge(is_used_once)', 'a', 'b')) => ('ult', 'a', 'b') */
   /* search332_0_0 -> 0 in the cache */
   /* search332_0_1 -> 1 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_uge,
      -1, 0,
      { 0, 1 },
      0,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_inot,
      -1, 0,
      { 1165 },
      -1,
   } },

   /* replace332_0 -> 0 in the cache */
   /* replace332_1 -> 1 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ult,
      -1, 0,
      { 0, 1 },
      -1,
   } },

   /* ('inot', ('ieq(is_used_once)', 'a', 'b')) => ('ine', 'a', 'b') */
   /* search333_0_0 -> 0 in the cache */
   /* search333_0_1 -> 1 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ieq,
      0, 1,
      { 0, 1 },
      0,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_inot,
      -1, 1,
      { 1168 },
      -1,
   } },

   /* replace333_0 -> 0 in the cache */
   /* replace333_1 -> 1 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ine,
      0, 1,
      { 0, 1 },
      -1,
   } },

   /* ('inot', ('ine(is_used_once)', 'a', 'b')) => ('ieq', 'a', 'b') */
   /* search334_0_0 -> 0 in the cache */
   /* search334_0_1 -> 1 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ine,
      0, 1,
      { 0, 1 },
      0,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_inot,
      -1, 1,
      { 1171 },
      -1,
   } },

   /* replace334_0 -> 0 in the cache */
   /* replace334_1 -> 1 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ieq,
      0, 1,
      { 0, 1 },
      -1,
   } },

   /* ('iand', ('feq', 'a', 'b'), ('fneu', 'a', 'b')) => False */
   /* search335_0_0 -> 0 in the cache */
   /* search335_0_1 -> 1 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_feq,
      1, 1,
      { 0, 1 },
      -1,
   } },
   /* search335_1_0 -> 0 in the cache */
   /* search335_1_1 -> 1 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fneu,
      2, 1,
      { 0, 1 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_iand,
      0, 3,
      { 1174, 1175 },
      -1,
   } },

   { .constant = {
      { nir_search_value_constant, 1 },
      nir_type_bool, { NIR_FALSE /* False */ },
   } },

   /* ('iand', ('flt', 'a', 'b'), ('flt', 'b', 'a')) => False */
   /* search336_0_0 -> 0 in the cache */
   /* search336_0_1 -> 1 in the cache */
   /* search336_0 -> 3 in the cache */
   /* search336_1_0 -> 1 in the cache */
   /* search336_1_1 -> 0 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_flt,
      -1, 0,
      { 1, 0 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_iand,
      0, 1,
      { 3, 1178 },
      -1,
   } },

   /* replace336 -> 1177 in the cache */

   /* ('iand', ('ieq', 'a', 'b'), ('ine', 'a', 'b')) => False */
   /* search337_0_0 -> 0 in the cache */
   /* search337_0_1 -> 1 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ieq,
      1, 1,
      { 0, 1 },
      -1,
   } },
   /* search337_1_0 -> 0 in the cache */
   /* search337_1_1 -> 1 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ine,
      2, 1,
      { 0, 1 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_iand,
      0, 3,
      { 1180, 1181 },
      -1,
   } },

   /* replace337 -> 1177 in the cache */

   /* ('iand', ('ilt', 'a', 'b'), ('ilt', 'b', 'a')) => False */
   /* search338_0_0 -> 0 in the cache */
   /* search338_0_1 -> 1 in the cache */
   /* search338_0 -> 1164 in the cache */
   /* search338_1_0 -> 1 in the cache */
   /* search338_1_1 -> 0 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ilt,
      -1, 0,
      { 1, 0 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_iand,
      0, 1,
      { 1164, 1183 },
      -1,
   } },

   /* replace338 -> 1177 in the cache */

   /* ('iand', ('ult', 'a', 'b'), ('ult', 'b', 'a')) => False */
   /* search339_0_0 -> 0 in the cache */
   /* search339_0_1 -> 1 in the cache */
   /* search339_0 -> 1167 in the cache */
   /* search339_1_0 -> 1 in the cache */
   /* search339_1_1 -> 0 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ult,
      -1, 0,
      { 1, 0 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_iand,
      0, 1,
      { 1167, 1185 },
      -1,
   } },

   /* replace339 -> 1177 in the cache */

   /* ('flt', ('fneg', 'a'), ('fneg', 'b')) => ('flt', 'b', 'a') */
   /* search340_0_0 -> 0 in the cache */
   /* search340_0 -> 230 in the cache */
   /* search340_1_0 -> 1 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fneg,
      -1, 0,
      { 1 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_flt,
      -1, 0,
      { 230, 1187 },
      -1,
   } },

   /* replace340_0 -> 1 in the cache */
   /* replace340_1 -> 0 in the cache */
   /* replace340 -> 1178 in the cache */

   /* ('fge', ('fneg', 'a'), ('fneg', 'b')) => ('fge', 'b', 'a') */
   /* search341_0_0 -> 0 in the cache */
   /* search341_0 -> 230 in the cache */
   /* search341_1_0 -> 1 in the cache */
   /* search341_1 -> 1187 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fge,
      -1, 0,
      { 230, 1187 },
      -1,
   } },

   /* replace341_0 -> 1 in the cache */
   /* replace341_1 -> 0 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fge,
      -1, 0,
      { 1, 0 },
      -1,
   } },

   /* ('feq', ('fneg', 'a'), ('fneg', 'b')) => ('feq', 'b', 'a') */
   /* search342_0_0 -> 0 in the cache */
   /* search342_0 -> 230 in the cache */
   /* search342_1_0 -> 1 in the cache */
   /* search342_1 -> 1187 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_feq,
      0, 1,
      { 230, 1187 },
      -1,
   } },

   /* replace342_0 -> 1 in the cache */
   /* replace342_1 -> 0 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_feq,
      0, 1,
      { 1, 0 },
      -1,
   } },

   /* ('fneu', ('fneg', 'a'), ('fneg', 'b')) => ('fneu', 'b', 'a') */
   /* search343_0_0 -> 0 in the cache */
   /* search343_0 -> 230 in the cache */
   /* search343_1_0 -> 1 in the cache */
   /* search343_1 -> 1187 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fneu,
      0, 1,
      { 230, 1187 },
      -1,
   } },

   /* replace343_0 -> 1 in the cache */
   /* replace343_1 -> 0 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fneu,
      0, 1,
      { 1, 0 },
      -1,
   } },

   /* ('flt', ('fneg', 'a(is_not_const)'), '#b') => ('flt', ('fneg', 'b'), 'a') */
   { .variable = {
      { nir_search_value_variable, -2 },
      0, /* a */
      false,
      nir_type_invalid,
      5,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fneg,
      -1, 0,
      { 1195 },
      -1,
   } },
   /* search344_1 -> 923 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_flt,
      -1, 0,
      { 1196, 923 },
      -1,
   } },

   /* replace344_0_0 -> 1 in the cache */
   /* replace344_0 -> 1187 in the cache */
   /* replace344_1 -> 0 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_flt,
      -1, 0,
      { 1187, 0 },
      -1,
   } },

   /* ('flt', '#b', ('fneg', 'a(is_not_const)')) => ('flt', 'a', ('fneg', 'b')) */
   { .variable = {
      { nir_search_value_variable, -2 },
      0, /* b */
      true,
      nir_type_invalid,
      -1,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .variable = {
      { nir_search_value_variable, -2 },
      1, /* a */
      false,
      nir_type_invalid,
      5,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fneg,
      -1, 0,
      { 1200 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_flt,
      -1, 0,
      { 1199, 1201 },
      -1,
   } },

   { .variable = {
      { nir_search_value_variable, -2 },
      1, /* a */
      false,
      nir_type_invalid,
      -1,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .variable = {
      { nir_search_value_variable, -2 },
      0, /* b */
      false,
      nir_type_invalid,
      -1,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fneg,
      -1, 0,
      { 1204 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_flt,
      -1, 0,
      { 1203, 1205 },
      -1,
   } },

   /* ('fge', ('fneg', 'a(is_not_const)'), '#b') => ('fge', ('fneg', 'b'), 'a') */
   /* search346_0_0 -> 1195 in the cache */
   /* search346_0 -> 1196 in the cache */
   /* search346_1 -> 923 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fge,
      -1, 0,
      { 1196, 923 },
      -1,
   } },

   /* replace346_0_0 -> 1 in the cache */
   /* replace346_0 -> 1187 in the cache */
   /* replace346_1 -> 0 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fge,
      -1, 0,
      { 1187, 0 },
      -1,
   } },

   /* ('fge', '#b', ('fneg', 'a(is_not_const)')) => ('fge', 'a', ('fneg', 'b')) */
   /* search347_0 -> 1199 in the cache */
   /* search347_1_0 -> 1200 in the cache */
   /* search347_1 -> 1201 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fge,
      -1, 0,
      { 1199, 1201 },
      -1,
   } },

   /* replace347_0 -> 1203 in the cache */
   /* replace347_1_0 -> 1204 in the cache */
   /* replace347_1 -> 1205 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fge,
      -1, 0,
      { 1203, 1205 },
      -1,
   } },

   /* ('fneu', ('fneg', 'a(is_not_const)'), '#b') => ('fneu', ('fneg', 'b'), 'a') */
   /* search348_0_0 -> 1195 in the cache */
   /* search348_0 -> 1196 in the cache */
   /* search348_1 -> 923 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fneu,
      0, 1,
      { 1196, 923 },
      -1,
   } },

   /* replace348_0_0 -> 1 in the cache */
   /* replace348_0 -> 1187 in the cache */
   /* replace348_1 -> 0 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fneu,
      0, 1,
      { 1187, 0 },
      -1,
   } },

   /* ('feq', '#b', ('fneg', 'a(is_not_const)')) => ('feq', 'a', ('fneg', 'b')) */
   /* search349_0 -> 1199 in the cache */
   /* search349_1_0 -> 1200 in the cache */
   /* search349_1 -> 1201 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_feq,
      0, 1,
      { 1199, 1201 },
      -1,
   } },

   /* replace349_0 -> 1203 in the cache */
   /* replace349_1_0 -> 1204 in the cache */
   /* replace349_1 -> 1205 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_feq,
      0, 1,
      { 1203, 1205 },
      -1,
   } },

   /* ('flt', 'a', '#b(is_negative_zero)') => ('flt', 'a', 0.0) */
   /* search350_0 -> 0 in the cache */
   { .variable = {
      { nir_search_value_variable, -2 },
      1, /* b */
      true,
      nir_type_invalid,
      17,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_flt,
      -1, 0,
      { 0, 1215 },
      -1,
   } },

   /* replace350_0 -> 0 in the cache */
   /* replace350_1 -> 273 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_flt,
      -1, 0,
      { 0, 273 },
      -1,
   } },

   /* ('flt', '#b(is_negative_zero)', 'a') => ('flt', 0.0, 'a') */
   { .variable = {
      { nir_search_value_variable, -2 },
      0, /* b */
      true,
      nir_type_invalid,
      17,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   /* search351_1 -> 1203 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_flt,
      -1, 0,
      { 1218, 1203 },
      -1,
   } },

   /* replace351_0 -> 273 in the cache */
   /* replace351_1 -> 1203 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_flt,
      -1, 0,
      { 273, 1203 },
      -1,
   } },

   /* ('fge', 'a', '#b(is_negative_zero)') => ('fge', 'a', 0.0) */
   /* search352_0 -> 0 in the cache */
   /* search352_1 -> 1215 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fge,
      -1, 0,
      { 0, 1215 },
      -1,
   } },

   /* replace352_0 -> 0 in the cache */
   /* replace352_1 -> 273 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fge,
      -1, 0,
      { 0, 273 },
      -1,
   } },

   /* ('fge', '#b(is_negative_zero)', 'a') => ('fge', 0.0, 'a') */
   /* search353_0 -> 1218 in the cache */
   /* search353_1 -> 1203 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fge,
      -1, 0,
      { 1218, 1203 },
      -1,
   } },

   /* replace353_0 -> 273 in the cache */
   /* replace353_1 -> 1203 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fge,
      -1, 0,
      { 273, 1203 },
      -1,
   } },

   /* ('fneu', 'a', '#b(is_negative_zero)') => ('fneu', 0.0, 'a') */
   /* search354_0 -> 0 in the cache */
   /* search354_1 -> 1215 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fneu,
      0, 1,
      { 0, 1215 },
      -1,
   } },

   /* replace354_0 -> 273 in the cache */
   /* replace354_1 -> 0 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fneu,
      0, 1,
      { 273, 0 },
      -1,
   } },

   /* ('feq', '#b(is_negative_zero)', 'a') => ('feq', 'a', 0.0) */
   /* search355_0 -> 1218 in the cache */
   /* search355_1 -> 1203 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_feq,
      0, 1,
      { 1218, 1203 },
      -1,
   } },

   /* replace355_0 -> 1203 in the cache */
   /* replace355_1 -> 273 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_feq,
      0, 1,
      { 1203, 273 },
      -1,
   } },

   /* ('ieq', ('ineg', 'a'), 0) => ('ieq', 'a', 0) */
   /* search356_0_0 -> 9 in the cache */
   /* search356_0 -> 120 in the cache */
   /* search356_1 -> 73 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ieq,
      0, 1,
      { 120, 73 },
      -1,
   } },

   /* replace356_0 -> 9 in the cache */
   /* replace356_1 -> 73 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ieq,
      0, 1,
      { 9, 73 },
      -1,
   } },

   /* ('ine', ('ineg', 'a'), 0) => ('ine', 'a', 0) */
   /* search357_0_0 -> 9 in the cache */
   /* search357_0 -> 120 in the cache */
   /* search357_1 -> 73 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ine,
      0, 1,
      { 120, 73 },
      -1,
   } },

   /* replace357_0 -> 9 in the cache */
   /* replace357_1 -> 73 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ine,
      0, 1,
      { 9, 73 },
      -1,
   } },

   /* ('ieq', ('iabs', 'a'), 0) => ('ieq', 'a', 0) */
   /* search358_0_0 -> 9 in the cache */
   /* search358_0 -> 125 in the cache */
   /* search358_1 -> 73 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ieq,
      0, 1,
      { 125, 73 },
      -1,
   } },

   /* replace358_0 -> 9 in the cache */
   /* replace358_1 -> 73 in the cache */
   /* replace358 -> 1230 in the cache */

   /* ('ine', ('iabs', 'a'), 0) => ('ine', 'a', 0) */
   /* search359_0_0 -> 9 in the cache */
   /* search359_0 -> 125 in the cache */
   /* search359_1 -> 73 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ine,
      0, 1,
      { 125, 73 },
      -1,
   } },

   /* replace359_0 -> 9 in the cache */
   /* replace359_1 -> 73 in the cache */
   /* replace359 -> 1232 in the cache */

   /* ('fneu', ('fabs', 'a'), 0.0) => ('fneu', 'a', 0.0) */
   /* search360_0_0 -> 9 in the cache */
   /* search360_0 -> 11 in the cache */
   /* search360_1 -> 8 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fneu,
      0, 1,
      { 11, 8 },
      -1,
   } },

   /* replace360_0 -> 9 in the cache */
   /* replace360_1 -> 8 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fneu,
      0, 1,
      { 9, 8 },
      -1,
   } },

   /* ('feq', ('fabs', 'a'), 0.0) => ('feq', 'a', 0.0) */
   /* search361_0_0 -> 9 in the cache */
   /* search361_0 -> 11 in the cache */
   /* search361_1 -> 8 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_feq,
      0, 1,
      { 11, 8 },
      -1,
   } },

   /* replace361_0 -> 9 in the cache */
   /* replace361_1 -> 8 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_feq,
      0, 1,
      { 9, 8 },
      -1,
   } },

   /* ('fneu', ('fabs', 'a'), ('fabs', 'a')) => ('fneu', 'a', 'a') */
   /* search362_0_0 -> 9 in the cache */
   /* search362_0 -> 11 in the cache */
   /* search362_1_0 -> 9 in the cache */
   /* search362_1 -> 11 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fneu,
      -1, 0,
      { 11, 11 },
      -1,
   } },

   /* replace362_0 -> 9 in the cache */
   /* replace362_1 -> 9 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fneu,
      -1, 0,
      { 9, 9 },
      -1,
   } },

   /* ('feq', ('fabs', 'a'), ('fabs', 'a')) => ('feq', 'a', 'a') */
   /* search363_0_0 -> 9 in the cache */
   /* search363_0 -> 11 in the cache */
   /* search363_1_0 -> 9 in the cache */
   /* search363_1 -> 11 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_feq,
      -1, 0,
      { 11, 11 },
      -1,
   } },

   /* replace363_0 -> 9 in the cache */
   /* replace363_1 -> 9 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_feq,
      -1, 0,
      { 9, 9 },
      -1,
   } },

   /* ('flt', '#b(is_gt_0_and_lt_1)', ('fsat(is_used_once)', 'a')) => ('flt', 'b', 'a') */
   { .variable = {
      { nir_search_value_variable, -2 },
      0, /* b */
      true,
      nir_type_invalid,
      18,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   /* search364_1_0 -> 1203 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fsat,
      -1, 0,
      { 1203 },
      0,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_flt,
      -1, 0,
      { 1243, 1244 },
      -1,
   } },

   /* replace364_0 -> 1204 in the cache */
   /* replace364_1 -> 1203 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_flt,
      -1, 0,
      { 1204, 1203 },
      -1,
   } },

   /* ('fge', ('fsat(is_used_once)', 'a'), '#b(is_gt_0_and_lt_1)') => ('fge', 'a', 'b') */
   /* search365_0_0 -> 0 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fsat,
      -1, 0,
      { 0 },
      0,
   } },
   { .variable = {
      { nir_search_value_variable, -2 },
      1, /* b */
      true,
      nir_type_invalid,
      18,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fge,
      -1, 0,
      { 1247, 1248 },
      -1,
   } },

   /* replace365_0 -> 0 in the cache */
   /* replace365_1 -> 1 in the cache */
   /* replace365 -> 6 in the cache */

   /* ('feq', ('fsat(is_used_once)', 'a'), '#b(is_gt_0_and_lt_1)') => ('feq', 'a', 'b') */
   /* search366_0_0 -> 0 in the cache */
   /* search366_0 -> 1247 in the cache */
   /* search366_1 -> 1248 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_feq,
      0, 1,
      { 1247, 1248 },
      -1,
   } },

   /* replace366_0 -> 0 in the cache */
   /* replace366_1 -> 1 in the cache */
   /* replace366 -> 1155 in the cache */

   /* ('fneu', ('fsat(is_used_once)', 'a'), '#b(is_gt_0_and_lt_1)') => ('fneu', 'a', 'b') */
   /* search367_0_0 -> 0 in the cache */
   /* search367_0 -> 1247 in the cache */
   /* search367_1 -> 1248 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fneu,
      0, 1,
      { 1247, 1248 },
      -1,
   } },

   /* replace367_0 -> 0 in the cache */
   /* replace367_1 -> 1 in the cache */
   /* replace367 -> 1152 in the cache */

   /* ('fge', ('fsat(is_used_once)', 'a'), 1.0) => ('fge', 'a', 1.0) */
   /* search368_0_0 -> 9 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fsat,
      -1, 0,
      { 9 },
      0,
   } },
   /* search368_1 -> 259 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fge,
      -1, 0,
      { 1252, 259 },
      -1,
   } },

   /* replace368_0 -> 9 in the cache */
   /* replace368_1 -> 259 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fge,
      -1, 0,
      { 9, 259 },
      -1,
   } },

   /* ('flt', 0.0, ('fsat(is_used_once)', 'a')) => ('flt', 0.0, 'a') */
   /* search369_0 -> 8 in the cache */
   /* search369_1_0 -> 9 in the cache */
   /* search369_1 -> 1252 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_flt,
      -1, 0,
      { 8, 1252 },
      -1,
   } },

   /* replace369_0 -> 8 in the cache */
   /* replace369_1 -> 9 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_flt,
      -1, 0,
      { 8, 9 },
      -1,
   } },

   /* ('fge', 0.0, ('b2f', 'a@1')) => ('inot', 'a') */
   { .constant = {
      { nir_search_value_constant, 0 },
      nir_type_float, { 0x0ull /* 0.0 */ },
   } },
   /* search370_1_0 -> 859 in the cache */
   { .expression = {
      { nir_search_value_expression, 0 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_search_op_b2f,
      -1, 0,
      { 859 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fge,
      -1, 0,
      { 1257, 1258 },
      -1,
   } },

   /* replace370_0 -> 859 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_inot,
      -1, 0,
      { 859 },
      -1,
   } },

   /* ('fge', ('fneg', ('b2f', 'a@1')), 0.0) => ('inot', 'a') */
   /* search371_0_0_0 -> 859 in the cache */
   /* search371_0_0 -> 1258 in the cache */
   { .expression = {
      { nir_search_value_expression, 0 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fneg,
      -1, 0,
      { 1258 },
      -1,
   } },
   /* search371_1 -> 1257 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fge,
      -1, 0,
      { 1261, 1257 },
      -1,
   } },

   /* replace371_0 -> 859 in the cache */
   /* replace371 -> 1260 in the cache */

   /* ('fneu', ('fadd', ('b2f', 'a@1'), ('b2f', 'b@1')), 0.0) => ('ior', 'a', 'b') */
   /* search372_0_0_0 -> 859 in the cache */
   /* search372_0_0 -> 1258 in the cache */
   { .variable = {
      { nir_search_value_variable, 1 },
      1, /* b */
      false,
      nir_type_invalid,
      -1,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .expression = {
      { nir_search_value_expression, 0 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_search_op_b2f,
      -1, 0,
      { 1263 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 0 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fadd,
      1, 1,
      { 1258, 1264 },
      -1,
   } },
   /* search372_1 -> 1257 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fneu,
      0, 2,
      { 1265, 1257 },
      -1,
   } },

   /* replace372_0 -> 859 in the cache */
   /* replace372_1 -> 1263 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ior,
      0, 1,
      { 859, 1263 },
      -1,
   } },

   /* ('fneu', ('bcsel', 'a', 1.0, ('b2f', 'b@1')), 0.0) => ('ior', 'a', 'b') */
   /* search373_0_0 -> 859 in the cache */
   { .constant = {
      { nir_search_value_constant, 0 },
      nir_type_float, { 0x3ff0000000000000ull /* 1.0 */ },
   } },
   /* search373_0_2_0 -> 1263 in the cache */
   /* search373_0_2 -> 1264 in the cache */
   { .expression = {
      { nir_search_value_expression, 0 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_bcsel,
      -1, 0,
      { 859, 1268, 1264 },
      -1,
   } },
   /* search373_1 -> 1257 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fneu,
      0, 1,
      { 1269, 1257 },
      -1,
   } },

   /* replace373_0 -> 859 in the cache */
   /* replace373_1 -> 1263 in the cache */
   /* replace373 -> 1267 in the cache */

   /* ('fneu', ('b2f', 'a@1'), ('fneg', ('b2f', 'b@1'))) => ('ior', 'a', 'b') */
   /* search374_0_0 -> 859 in the cache */
   /* search374_0 -> 1258 in the cache */
   /* search374_1_0_0 -> 1263 in the cache */
   /* search374_1_0 -> 1264 in the cache */
   { .expression = {
      { nir_search_value_expression, 0 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fneg,
      -1, 0,
      { 1264 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fneu,
      0, 1,
      { 1258, 1271 },
      -1,
   } },

   /* replace374_0 -> 859 in the cache */
   /* replace374_1 -> 1263 in the cache */
   /* replace374 -> 1267 in the cache */

   /* ('fneu', ('fmul', ('b2f', 'a@1'), ('b2f', 'b@1')), 0.0) => ('iand', 'a', 'b') */
   /* search375_0_0_0 -> 859 in the cache */
   /* search375_0_0 -> 1258 in the cache */
   /* search375_0_1_0 -> 1263 in the cache */
   /* search375_0_1 -> 1264 in the cache */
   { .expression = {
      { nir_search_value_expression, 0 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fmul,
      1, 1,
      { 1258, 1264 },
      -1,
   } },
   /* search375_1 -> 1257 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fneu,
      0, 2,
      { 1273, 1257 },
      -1,
   } },

   /* replace375_0 -> 859 in the cache */
   /* replace375_1 -> 1263 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_iand,
      0, 1,
      { 859, 1263 },
      -1,
   } },

   /* ('fneu', ('bcsel', 'a', ('b2f', 'b@1'), 0.0), 0.0) => ('iand', 'a', 'b') */
   /* search376_0_0 -> 859 in the cache */
   /* search376_0_1_0 -> 1263 in the cache */
   /* search376_0_1 -> 1264 in the cache */
   /* search376_0_2 -> 1257 in the cache */
   { .expression = {
      { nir_search_value_expression, 0 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_bcsel,
      -1, 0,
      { 859, 1264, 1257 },
      -1,
   } },
   /* search376_1 -> 1257 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fneu,
      0, 1,
      { 1276, 1257 },
      -1,
   } },

   /* replace376_0 -> 859 in the cache */
   /* replace376_1 -> 1263 in the cache */
   /* replace376 -> 1275 in the cache */

   /* ('fneu', ('fadd', ('b2f', 'a@1'), ('fneg', ('b2f', 'b@1'))), 0.0) => ('ixor', 'a', 'b') */
   /* search377_0_0_0 -> 859 in the cache */
   /* search377_0_0 -> 1258 in the cache */
   /* search377_0_1_0_0 -> 1263 in the cache */
   /* search377_0_1_0 -> 1264 in the cache */
   /* search377_0_1 -> 1271 in the cache */
   { .expression = {
      { nir_search_value_expression, 0 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fadd,
      1, 1,
      { 1258, 1271 },
      -1,
   } },
   /* search377_1 -> 1257 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fneu,
      0, 2,
      { 1278, 1257 },
      -1,
   } },

   /* replace377_0 -> 859 in the cache */
   /* replace377_1 -> 1263 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ixor,
      0, 1,
      { 859, 1263 },
      -1,
   } },

   /* ('fneu', ('b2f', 'a@1'), ('b2f', 'b@1')) => ('ixor', 'a', 'b') */
   /* search378_0_0 -> 859 in the cache */
   /* search378_0 -> 1258 in the cache */
   /* search378_1_0 -> 1263 in the cache */
   /* search378_1 -> 1264 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fneu,
      0, 1,
      { 1258, 1264 },
      -1,
   } },

   /* replace378_0 -> 859 in the cache */
   /* replace378_1 -> 1263 in the cache */
   /* replace378 -> 1280 in the cache */

   /* ('fneu', ('fneg', ('b2f', 'a@1')), ('fneg', ('b2f', 'b@1'))) => ('ixor', 'a', 'b') */
   /* search379_0_0_0 -> 859 in the cache */
   /* search379_0_0 -> 1258 in the cache */
   /* search379_0 -> 1261 in the cache */
   /* search379_1_0_0 -> 1263 in the cache */
   /* search379_1_0 -> 1264 in the cache */
   /* search379_1 -> 1271 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fneu,
      0, 1,
      { 1261, 1271 },
      -1,
   } },

   /* replace379_0 -> 859 in the cache */
   /* replace379_1 -> 1263 in the cache */
   /* replace379 -> 1280 in the cache */

   /* ('feq', ('fadd', ('b2f', 'a@1'), ('b2f', 'b@1')), 0.0) => ('inot', ('ior', 'a', 'b')) */
   /* search380_0_0_0 -> 859 in the cache */
   /* search380_0_0 -> 1258 in the cache */
   /* search380_0_1_0 -> 1263 in the cache */
   /* search380_0_1 -> 1264 in the cache */
   /* search380_0 -> 1265 in the cache */
   /* search380_1 -> 1257 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_feq,
      0, 2,
      { 1265, 1257 },
      -1,
   } },

   /* replace380_0_0 -> 859 in the cache */
   /* replace380_0_1 -> 1263 in the cache */
   /* replace380_0 -> 1267 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_inot,
      -1, 1,
      { 1267 },
      -1,
   } },

   /* ('feq', ('bcsel', 'a', 1.0, ('b2f', 'b@1')), 0.0) => ('inot', ('ior', 'a', 'b')) */
   /* search381_0_0 -> 859 in the cache */
   /* search381_0_1 -> 1268 in the cache */
   /* search381_0_2_0 -> 1263 in the cache */
   /* search381_0_2 -> 1264 in the cache */
   /* search381_0 -> 1269 in the cache */
   /* search381_1 -> 1257 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_feq,
      0, 1,
      { 1269, 1257 },
      -1,
   } },

   /* replace381_0_0 -> 859 in the cache */
   /* replace381_0_1 -> 1263 in the cache */
   /* replace381_0 -> 1267 in the cache */
   /* replace381 -> 1284 in the cache */

   /* ('feq', ('b2f', 'a@1'), ('fneg', ('b2f', 'b@1'))) => ('inot', ('ior', 'a', 'b')) */
   /* search382_0_0 -> 859 in the cache */
   /* search382_0 -> 1258 in the cache */
   /* search382_1_0_0 -> 1263 in the cache */
   /* search382_1_0 -> 1264 in the cache */
   /* search382_1 -> 1271 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_feq,
      0, 1,
      { 1258, 1271 },
      -1,
   } },

   /* replace382_0_0 -> 859 in the cache */
   /* replace382_0_1 -> 1263 in the cache */
   /* replace382_0 -> 1267 in the cache */
   /* replace382 -> 1284 in the cache */

   /* ('feq', ('fmul', ('b2f', 'a@1'), ('b2f', 'b@1')), 0.0) => ('inot', ('iand', 'a', 'b')) */
   /* search383_0_0_0 -> 859 in the cache */
   /* search383_0_0 -> 1258 in the cache */
   /* search383_0_1_0 -> 1263 in the cache */
   /* search383_0_1 -> 1264 in the cache */
   /* search383_0 -> 1273 in the cache */
   /* search383_1 -> 1257 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_feq,
      0, 2,
      { 1273, 1257 },
      -1,
   } },

   /* replace383_0_0 -> 859 in the cache */
   /* replace383_0_1 -> 1263 in the cache */
   /* replace383_0 -> 1275 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_inot,
      -1, 1,
      { 1275 },
      -1,
   } },

   /* ('feq', ('bcsel', 'a', ('b2f', 'b@1'), 0.0), 0.0) => ('inot', ('iand', 'a', 'b')) */
   /* search384_0_0 -> 859 in the cache */
   /* search384_0_1_0 -> 1263 in the cache */
   /* search384_0_1 -> 1264 in the cache */
   /* search384_0_2 -> 1257 in the cache */
   /* search384_0 -> 1276 in the cache */
   /* search384_1 -> 1257 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_feq,
      0, 1,
      { 1276, 1257 },
      -1,
   } },

   /* replace384_0_0 -> 859 in the cache */
   /* replace384_0_1 -> 1263 in the cache */
   /* replace384_0 -> 1275 in the cache */
   /* replace384 -> 1288 in the cache */

   /* ('feq', ('fadd', ('b2f', 'a@1'), ('fneg', ('b2f', 'b@1'))), 0.0) => ('ieq', 'a', 'b') */
   /* search385_0_0_0 -> 859 in the cache */
   /* search385_0_0 -> 1258 in the cache */
   /* search385_0_1_0_0 -> 1263 in the cache */
   /* search385_0_1_0 -> 1264 in the cache */
   /* search385_0_1 -> 1271 in the cache */
   /* search385_0 -> 1278 in the cache */
   /* search385_1 -> 1257 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_feq,
      0, 2,
      { 1278, 1257 },
      -1,
   } },

   /* replace385_0 -> 859 in the cache */
   /* replace385_1 -> 1263 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ieq,
      0, 1,
      { 859, 1263 },
      -1,
   } },

   /* ('feq', ('b2f', 'a@1'), ('b2f', 'b@1')) => ('ieq', 'a', 'b') */
   /* search386_0_0 -> 859 in the cache */
   /* search386_0 -> 1258 in the cache */
   /* search386_1_0 -> 1263 in the cache */
   /* search386_1 -> 1264 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_feq,
      0, 1,
      { 1258, 1264 },
      -1,
   } },

   /* replace386_0 -> 859 in the cache */
   /* replace386_1 -> 1263 in the cache */
   /* replace386 -> 1291 in the cache */

   /* ('feq', ('fneg', ('b2f', 'a@1')), ('fneg', ('b2f', 'b@1'))) => ('ieq', 'a', 'b') */
   /* search387_0_0_0 -> 859 in the cache */
   /* search387_0_0 -> 1258 in the cache */
   /* search387_0 -> 1261 in the cache */
   /* search387_1_0_0 -> 1263 in the cache */
   /* search387_1_0 -> 1264 in the cache */
   /* search387_1 -> 1271 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_feq,
      0, 1,
      { 1261, 1271 },
      -1,
   } },

   /* replace387_0 -> 859 in the cache */
   /* replace387_1 -> 1263 in the cache */
   /* replace387 -> 1291 in the cache */

   /* ('flt', ('fneg', ('fadd', ('b2f', 'a@1'), ('b2f', 'b@1'))), 0.0) => ('ior', 'a', 'b') */
   /* search388_0_0_0_0 -> 859 in the cache */
   /* search388_0_0_0 -> 1258 in the cache */
   /* search388_0_0_1_0 -> 1263 in the cache */
   /* search388_0_0_1 -> 1264 in the cache */
   { .expression = {
      { nir_search_value_expression, 0 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fadd,
      0, 1,
      { 1258, 1264 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 0 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fneg,
      -1, 1,
      { 1294 },
      -1,
   } },
   /* search388_1 -> 1257 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_flt,
      -1, 1,
      { 1295, 1257 },
      -1,
   } },

   /* replace388_0 -> 859 in the cache */
   /* replace388_1 -> 1263 in the cache */
   /* replace388 -> 1267 in the cache */

   /* ('flt', 0.0, ('fadd', ('b2f', 'a@1'), ('b2f', 'b@1'))) => ('ior', 'a', 'b') */
   /* search389_0 -> 1257 in the cache */
   /* search389_1_0_0 -> 859 in the cache */
   /* search389_1_0 -> 1258 in the cache */
   /* search389_1_1_0 -> 1263 in the cache */
   /* search389_1_1 -> 1264 in the cache */
   /* search389_1 -> 1294 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_flt,
      -1, 1,
      { 1257, 1294 },
      -1,
   } },

   /* replace389_0 -> 859 in the cache */
   /* replace389_1 -> 1263 in the cache */
   /* replace389 -> 1267 in the cache */

   /* ('fge', ('fneg', ('fadd', ('b2f', 'a@1'), ('b2f', 'b@1'))), 0.0) => ('inot', ('ior', 'a', 'b')) */
   /* search390_0_0_0_0 -> 859 in the cache */
   /* search390_0_0_0 -> 1258 in the cache */
   /* search390_0_0_1_0 -> 1263 in the cache */
   /* search390_0_0_1 -> 1264 in the cache */
   /* search390_0_0 -> 1294 in the cache */
   /* search390_0 -> 1295 in the cache */
   /* search390_1 -> 1257 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fge,
      -1, 1,
      { 1295, 1257 },
      -1,
   } },

   /* replace390_0_0 -> 859 in the cache */
   /* replace390_0_1 -> 1263 in the cache */
   /* replace390_0 -> 1267 in the cache */
   /* replace390 -> 1284 in the cache */

   /* ('fge', 0.0, ('fadd', ('b2f', 'a@1'), ('b2f', 'b@1'))) => ('inot', ('ior', 'a', 'b')) */
   /* search391_0 -> 1257 in the cache */
   /* search391_1_0_0 -> 859 in the cache */
   /* search391_1_0 -> 1258 in the cache */
   /* search391_1_1_0 -> 1263 in the cache */
   /* search391_1_1 -> 1264 in the cache */
   /* search391_1 -> 1294 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fge,
      -1, 1,
      { 1257, 1294 },
      -1,
   } },

   /* replace391_0_0 -> 859 in the cache */
   /* replace391_0_1 -> 1263 in the cache */
   /* replace391_0 -> 1267 in the cache */
   /* replace391 -> 1284 in the cache */

   /* ('flt', 'a', ('fneg', 'a')) => ('flt', 'a', 0.0) */
   /* search392_0 -> 9 in the cache */
   /* search392_1_0 -> 9 in the cache */
   /* search392_1 -> 118 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_flt,
      -1, 0,
      { 9, 118 },
      -1,
   } },

   /* replace392_0 -> 9 in the cache */
   /* replace392_1 -> 8 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_flt,
      -1, 0,
      { 9, 8 },
      -1,
   } },

   /* ('fge', 'a', ('fneg', 'a')) => ('fge', 'a', 0.0) */
   /* search393_0 -> 9 in the cache */
   /* search393_1_0 -> 9 in the cache */
   /* search393_1 -> 118 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fge,
      -1, 0,
      { 9, 118 },
      -1,
   } },

   /* replace393_0 -> 9 in the cache */
   /* replace393_1 -> 8 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fge,
      -1, 0,
      { 9, 8 },
      -1,
   } },

   /* ('flt', ('fmin', 'c', ('fneg', ('fadd', ('b2f', 'a@1'), ('b2f', 'b@1')))), 0.0) => ('ior', ('flt', 'c', 0.0), ('ior', 'a', 'b')) */
   { .variable = {
      { nir_search_value_variable, -1 },
      0, /* c */
      false,
      nir_type_invalid,
      -1,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .variable = {
      { nir_search_value_variable, 1 },
      1, /* a */
      false,
      nir_type_invalid,
      -1,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_search_op_b2f,
      -1, 0,
      { 1305 },
      -1,
   } },
   { .variable = {
      { nir_search_value_variable, 1 },
      2, /* b */
      false,
      nir_type_invalid,
      -1,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_search_op_b2f,
      -1, 0,
      { 1307 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fadd,
      1, 1,
      { 1306, 1308 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fneg,
      -1, 1,
      { 1309 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fmin,
      0, 2,
      { 1304, 1310 },
      -1,
   } },
   /* search394_1 -> 8 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_flt,
      -1, 2,
      { 1311, 8 },
      -1,
   } },

   /* replace394_0_0 -> 1304 in the cache */
   /* replace394_0_1 -> 8 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_flt,
      -1, 0,
      { 1304, 8 },
      -1,
   } },
   /* replace394_1_0 -> 1305 in the cache */
   /* replace394_1_1 -> 1307 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ior,
      1, 1,
      { 1305, 1307 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ior,
      0, 2,
      { 1313, 1314 },
      -1,
   } },

   /* ('~flt', ('fadd', 'a', 'b'), 'a') => ('flt', 'b', 0.0) */
   /* search395_0_0 -> 0 in the cache */
   /* search395_0_1 -> 1 in the cache */
   /* search395_0 -> 285 in the cache */
   /* search395_1 -> 0 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      true,
      false,
      false,
      false,
      false,
      false,
      nir_op_flt,
      -1, 1,
      { 285, 0 },
      -1,
   } },

   /* replace395_0 -> 1 in the cache */
   /* replace395_1 -> 273 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_flt,
      -1, 0,
      { 1, 273 },
      -1,
   } },

   /* ('~fge', ('fadd', 'a', 'b'), 'a') => ('fge', 'b', 0.0) */
   /* search396_0_0 -> 0 in the cache */
   /* search396_0_1 -> 1 in the cache */
   /* search396_0 -> 285 in the cache */
   /* search396_1 -> 0 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      true,
      false,
      false,
      false,
      false,
      false,
      nir_op_fge,
      -1, 1,
      { 285, 0 },
      -1,
   } },

   /* replace396_0 -> 1 in the cache */
   /* replace396_1 -> 273 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fge,
      -1, 0,
      { 1, 273 },
      -1,
   } },

   /* ('~feq', ('fadd', 'a', 'b'), 'a') => ('feq', 'b', 0.0) */
   /* search397_0_0 -> 0 in the cache */
   /* search397_0_1 -> 1 in the cache */
   /* search397_0 -> 231 in the cache */
   /* search397_1 -> 0 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      true,
      false,
      false,
      false,
      false,
      false,
      nir_op_feq,
      0, 2,
      { 231, 0 },
      -1,
   } },

   /* replace397_0 -> 1 in the cache */
   /* replace397_1 -> 273 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_feq,
      0, 1,
      { 1, 273 },
      -1,
   } },

   /* ('~fneu', ('fadd', 'a', 'b'), 'a') => ('fneu', 'b', 0.0) */
   /* search398_0_0 -> 0 in the cache */
   /* search398_0_1 -> 1 in the cache */
   /* search398_0 -> 231 in the cache */
   /* search398_1 -> 0 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      true,
      false,
      false,
      false,
      false,
      false,
      nir_op_fneu,
      0, 2,
      { 231, 0 },
      -1,
   } },

   /* replace398_0 -> 1 in the cache */
   /* replace398_1 -> 273 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fneu,
      0, 1,
      { 1, 273 },
      -1,
   } },

   /* ('~flt', ('fadd(is_used_once)', 'a', '#b'), '#c') => ('flt', 'a', ('fadd', 'c', ('fneg', 'b'))) */
   /* search399_0_0 -> 139 in the cache */
   /* search399_0_1 -> 296 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fadd,
      0, 1,
      { 139, 296 },
      0,
   } },
   /* search399_1 -> 916 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      true,
      false,
      false,
      false,
      false,
      false,
      nir_op_flt,
      -1, 1,
      { 1324, 916 },
      -1,
   } },

   /* replace399_0 -> 139 in the cache */
   /* replace399_1_0 -> 142 in the cache */
   /* replace399_1_1_0 -> 140 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fneg,
      -1, 0,
      { 140 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fadd,
      0, 1,
      { 142, 1326 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_flt,
      -1, 1,
      { 139, 1327 },
      -1,
   } },

   /* ('~flt', ('fneg(is_used_once)', ('fadd(is_used_once)', 'a', '#b')), '#c') => ('flt', ('fneg', ('fadd', 'c', 'b')), 'a') */
   /* search400_0_0_0 -> 139 in the cache */
   /* search400_0_0_1 -> 296 in the cache */
   /* search400_0_0 -> 1324 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fneg,
      -1, 1,
      { 1324 },
      0,
   } },
   /* search400_1 -> 916 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      true,
      false,
      false,
      false,
      false,
      false,
      nir_op_flt,
      -1, 1,
      { 1329, 916 },
      -1,
   } },

   /* replace400_0_0_0 -> 142 in the cache */
   /* replace400_0_0_1 -> 140 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fadd,
      0, 1,
      { 142, 140 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fneg,
      -1, 1,
      { 1331 },
      -1,
   } },
   /* replace400_1 -> 139 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_flt,
      -1, 1,
      { 1332, 139 },
      -1,
   } },

   /* ('~fge', ('fadd(is_used_once)', 'a', '#b'), '#c') => ('fge', 'a', ('fadd', 'c', ('fneg', 'b'))) */
   /* search401_0_0 -> 139 in the cache */
   /* search401_0_1 -> 296 in the cache */
   /* search401_0 -> 1324 in the cache */
   /* search401_1 -> 916 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      true,
      false,
      false,
      false,
      false,
      false,
      nir_op_fge,
      -1, 1,
      { 1324, 916 },
      -1,
   } },

   /* replace401_0 -> 139 in the cache */
   /* replace401_1_0 -> 142 in the cache */
   /* replace401_1_1_0 -> 140 in the cache */
   /* replace401_1_1 -> 1326 in the cache */
   /* replace401_1 -> 1327 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fge,
      -1, 1,
      { 139, 1327 },
      -1,
   } },

   /* ('~fge', ('fneg(is_used_once)', ('fadd(is_used_once)', 'a', '#b')), '#c') => ('fge', ('fneg', ('fadd', 'c', 'b')), 'a') */
   /* search402_0_0_0 -> 139 in the cache */
   /* search402_0_0_1 -> 296 in the cache */
   /* search402_0_0 -> 1324 in the cache */
   /* search402_0 -> 1329 in the cache */
   /* search402_1 -> 916 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      true,
      false,
      false,
      false,
      false,
      false,
      nir_op_fge,
      -1, 1,
      { 1329, 916 },
      -1,
   } },

   /* replace402_0_0_0 -> 142 in the cache */
   /* replace402_0_0_1 -> 140 in the cache */
   /* replace402_0_0 -> 1331 in the cache */
   /* replace402_0 -> 1332 in the cache */
   /* replace402_1 -> 139 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fge,
      -1, 1,
      { 1332, 139 },
      -1,
   } },

   /* ('~feq', ('fadd(is_used_once)', 'a', '#b'), '#c') => ('feq', 'a', ('fadd', 'c', ('fneg', 'b'))) */
   /* search403_0_0 -> 139 in the cache */
   /* search403_0_1 -> 296 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fadd,
      1, 1,
      { 139, 296 },
      0,
   } },
   /* search403_1 -> 916 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      true,
      false,
      false,
      false,
      false,
      false,
      nir_op_feq,
      0, 2,
      { 1338, 916 },
      -1,
   } },

   /* replace403_0 -> 139 in the cache */
   /* replace403_1_0 -> 142 in the cache */
   /* replace403_1_1_0 -> 140 in the cache */
   /* replace403_1_1 -> 1326 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fadd,
      1, 1,
      { 142, 1326 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_feq,
      0, 2,
      { 139, 1340 },
      -1,
   } },

   /* ('~feq', ('fneg(is_used_once)', ('fadd(is_used_once)', 'a', '#b')), '#c') => ('feq', ('fneg', ('fadd', 'c', 'b')), 'a') */
   /* search404_0_0_0 -> 139 in the cache */
   /* search404_0_0_1 -> 296 in the cache */
   /* search404_0_0 -> 1338 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fneg,
      -1, 1,
      { 1338 },
      0,
   } },
   /* search404_1 -> 916 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      true,
      false,
      false,
      false,
      false,
      false,
      nir_op_feq,
      0, 2,
      { 1342, 916 },
      -1,
   } },

   /* replace404_0_0_0 -> 142 in the cache */
   /* replace404_0_0_1 -> 140 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fadd,
      1, 1,
      { 142, 140 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fneg,
      -1, 1,
      { 1344 },
      -1,
   } },
   /* replace404_1 -> 139 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_feq,
      0, 2,
      { 1345, 139 },
      -1,
   } },

   /* ('~fneu', ('fadd(is_used_once)', 'a', '#b'), '#c') => ('fneu', 'a', ('fadd', 'c', ('fneg', 'b'))) */
   /* search405_0_0 -> 139 in the cache */
   /* search405_0_1 -> 296 in the cache */
   /* search405_0 -> 1338 in the cache */
   /* search405_1 -> 916 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      true,
      false,
      false,
      false,
      false,
      false,
      nir_op_fneu,
      0, 2,
      { 1338, 916 },
      -1,
   } },

   /* replace405_0 -> 139 in the cache */
   /* replace405_1_0 -> 142 in the cache */
   /* replace405_1_1_0 -> 140 in the cache */
   /* replace405_1_1 -> 1326 in the cache */
   /* replace405_1 -> 1340 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fneu,
      0, 2,
      { 139, 1340 },
      -1,
   } },

   /* ('~fneu', ('fneg(is_used_once)', ('fadd(is_used_once)', 'a', '#b')), '#c') => ('fneu', ('fneg', ('fadd', 'c', 'b')), 'a') */
   /* search406_0_0_0 -> 139 in the cache */
   /* search406_0_0_1 -> 296 in the cache */
   /* search406_0_0 -> 1338 in the cache */
   /* search406_0 -> 1342 in the cache */
   /* search406_1 -> 916 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      true,
      false,
      false,
      false,
      false,
      false,
      nir_op_fneu,
      0, 2,
      { 1342, 916 },
      -1,
   } },

   /* replace406_0_0_0 -> 142 in the cache */
   /* replace406_0_0_1 -> 140 in the cache */
   /* replace406_0_0 -> 1344 in the cache */
   /* replace406_0 -> 1345 in the cache */
   /* replace406_1 -> 139 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fneu,
      0, 2,
      { 1345, 139 },
      -1,
   } },

   /* ('ieq', ('iadd', 'a', 'b'), 'a') => ('ieq', 'b', 0) */
   /* search407_0_0 -> 0 in the cache */
   /* search407_0_1 -> 1 in the cache */
   /* search407_0 -> 226 in the cache */
   /* search407_1 -> 0 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ieq,
      0, 2,
      { 226, 0 },
      -1,
   } },

   /* replace407_0 -> 1 in the cache */
   /* replace407_1 -> 98 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ieq,
      0, 1,
      { 1, 98 },
      -1,
   } },

   /* ('ine', ('iadd', 'a', 'b'), 'a') => ('ine', 'b', 0) */
   /* search408_0_0 -> 0 in the cache */
   /* search408_0_1 -> 1 in the cache */
   /* search408_0 -> 226 in the cache */
   /* search408_1 -> 0 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ine,
      0, 2,
      { 226, 0 },
      -1,
   } },

   /* replace408_0 -> 1 in the cache */
   /* replace408_1 -> 98 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ine,
      0, 1,
      { 1, 98 },
      -1,
   } },

   /* ('feq', ('b2f', 'a@1'), 0.0) => ('inot', 'a') */
   /* search409_0_0 -> 859 in the cache */
   /* search409_0 -> 1258 in the cache */
   /* search409_1 -> 1257 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_feq,
      0, 1,
      { 1258, 1257 },
      -1,
   } },

   /* replace409_0 -> 859 in the cache */
   /* replace409 -> 1260 in the cache */

   /* ('fge', 0.0, ('b2f', 'a@1')) => ('inot', 'a') */
   /* search410_0 -> 1257 in the cache */
   /* search410_1_0 -> 859 in the cache */
   /* search410_1 -> 1258 in the cache */
   /* search410 -> 1259 in the cache */

   /* replace410_0 -> 859 in the cache */
   /* replace410 -> 1260 in the cache */

   /* ('fneu', ('b2f', 'a@1'), 0.0) => a */
   /* search411_0_0 -> 859 in the cache */
   /* search411_0 -> 1258 in the cache */
   /* search411_1 -> 1257 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fneu,
      0, 1,
      { 1258, 1257 },
      -1,
   } },

   /* replace411 -> 859 in the cache */

   /* ('flt', 0.0, ('b2f', 'a@1')) => a */
   /* search412_0 -> 1257 in the cache */
   /* search412_1_0 -> 859 in the cache */
   /* search412_1 -> 1258 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_flt,
      -1, 0,
      { 1257, 1258 },
      -1,
   } },

   /* replace412 -> 859 in the cache */

   /* ('ieq', ('b2i', 'a@1'), 0) => ('inot', 'a') */
   /* search413_0_0 -> 859 in the cache */
   { .expression = {
      { nir_search_value_expression, 0 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_search_op_b2i,
      -1, 0,
      { 859 },
      -1,
   } },
   { .constant = {
      { nir_search_value_constant, 0 },
      nir_type_int, { 0x0ull /* 0 */ },
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ieq,
      0, 1,
      { 1358, 1359 },
      -1,
   } },

   /* replace413_0 -> 859 in the cache */
   /* replace413 -> 1260 in the cache */

   /* ('ine', ('b2i', 'a@1'), 0) => a */
   /* search414_0_0 -> 859 in the cache */
   /* search414_0 -> 1358 in the cache */
   /* search414_1 -> 1359 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ine,
      0, 1,
      { 1358, 1359 },
      -1,
   } },

   /* replace414 -> 859 in the cache */

   /* ('ieq', 'a@1', False) => ('inot', 'a') */
   /* search415_0 -> 859 in the cache */
   /* search415_1 -> 1177 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ieq,
      0, 1,
      { 859, 1177 },
      -1,
   } },

   /* replace415_0 -> 859 in the cache */
   /* replace415 -> 1260 in the cache */

   /* ('ieq', 'a@1', True) => a */
   /* search416_0 -> 859 in the cache */
   { .constant = {
      { nir_search_value_constant, 1 },
      nir_type_bool, { NIR_TRUE /* True */ },
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ieq,
      0, 1,
      { 859, 1363 },
      -1,
   } },

   /* replace416 -> 859 in the cache */

   /* ('ine', 'a@1', False) => a */
   /* search417_0 -> 859 in the cache */
   /* search417_1 -> 1177 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ine,
      0, 1,
      { 859, 1177 },
      -1,
   } },

   /* replace417 -> 859 in the cache */

   /* ('ine', 'a@1', True) => ('inot', 'a') */
   /* search418_0 -> 859 in the cache */
   /* search418_1 -> 1363 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ine,
      0, 1,
      { 859, 1363 },
      -1,
   } },

   /* replace418_0 -> 859 in the cache */
   /* replace418 -> 1260 in the cache */

   /* ('fneu', ('u2f', 'a'), 0.0) => ('ine', 'a', 0) */
   /* search419_0_0 -> 9 in the cache */
   /* search419_0 -> 123 in the cache */
   /* search419_1 -> 1257 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fneu,
      0, 1,
      { 123, 1257 },
      -1,
   } },

   /* replace419_0 -> 9 in the cache */
   /* replace419_1 -> 73 in the cache */
   /* replace419 -> 1232 in the cache */

   /* ('feq', ('u2f', 'a'), 0.0) => ('ieq', 'a', 0) */
   /* search420_0_0 -> 9 in the cache */
   /* search420_0 -> 123 in the cache */
   /* search420_1 -> 1257 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_feq,
      0, 1,
      { 123, 1257 },
      -1,
   } },

   /* replace420_0 -> 9 in the cache */
   /* replace420_1 -> 73 in the cache */
   /* replace420 -> 1230 in the cache */

   /* ('fge', ('u2f', 'a'), 0.0) => True */
   /* search421_0_0 -> 9 in the cache */
   /* search421_0 -> 123 in the cache */
   /* search421_1 -> 1257 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fge,
      -1, 0,
      { 123, 1257 },
      -1,
   } },

   /* replace421 -> 1363 in the cache */

   /* ('fge', 0.0, ('u2f', 'a')) => ('uge', 0, 'a') */
   /* search422_0 -> 1257 in the cache */
   /* search422_1_0 -> 9 in the cache */
   /* search422_1 -> 123 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fge,
      -1, 0,
      { 1257, 123 },
      -1,
   } },

   /* replace422_0 -> 73 in the cache */
   /* replace422_1 -> 9 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_uge,
      -1, 0,
      { 73, 9 },
      -1,
   } },

   /* ('flt', ('u2f', 'a'), 0.0) => False */
   /* search423_0_0 -> 9 in the cache */
   /* search423_0 -> 123 in the cache */
   /* search423_1 -> 1257 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_flt,
      -1, 0,
      { 123, 1257 },
      -1,
   } },

   /* replace423 -> 1177 in the cache */

   /* ('flt', 0.0, ('u2f', 'a')) => ('ult', 0, 'a') */
   /* search424_0 -> 1257 in the cache */
   /* search424_1_0 -> 9 in the cache */
   /* search424_1 -> 123 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_flt,
      -1, 0,
      { 1257, 123 },
      -1,
   } },

   /* replace424_0 -> 73 in the cache */
   /* replace424_1 -> 9 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ult,
      -1, 0,
      { 73, 9 },
      -1,
   } },

   /* ('fneu', ('i2f', 'a'), 0.0) => ('ine', 'a', 0) */
   /* search425_0_0 -> 9 in the cache */
   { .expression = {
      { nir_search_value_expression, 0 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_search_op_i2f,
      -1, 0,
      { 9 },
      -1,
   } },
   /* search425_1 -> 1257 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fneu,
      0, 1,
      { 1375, 1257 },
      -1,
   } },

   /* replace425_0 -> 9 in the cache */
   /* replace425_1 -> 73 in the cache */
   /* replace425 -> 1232 in the cache */

   /* ('feq', ('i2f', 'a'), 0.0) => ('ieq', 'a', 0) */
   /* search426_0_0 -> 9 in the cache */
   /* search426_0 -> 1375 in the cache */
   /* search426_1 -> 1257 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_feq,
      0, 1,
      { 1375, 1257 },
      -1,
   } },

   /* replace426_0 -> 9 in the cache */
   /* replace426_1 -> 73 in the cache */
   /* replace426 -> 1230 in the cache */

   /* ('fge', ('i2f', 'a'), 0.0) => ('ige', 'a', 0) */
   /* search427_0_0 -> 9 in the cache */
   /* search427_0 -> 1375 in the cache */
   /* search427_1 -> 1257 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fge,
      -1, 0,
      { 1375, 1257 },
      -1,
   } },

   /* replace427_0 -> 9 in the cache */
   /* replace427_1 -> 73 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ige,
      -1, 0,
      { 9, 73 },
      -1,
   } },

   /* ('fge', 0.0, ('i2f', 'a')) => ('ige', 0, 'a') */
   /* search428_0 -> 1257 in the cache */
   /* search428_1_0 -> 9 in the cache */
   /* search428_1 -> 1375 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fge,
      -1, 0,
      { 1257, 1375 },
      -1,
   } },

   /* replace428_0 -> 73 in the cache */
   /* replace428_1 -> 9 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ige,
      -1, 0,
      { 73, 9 },
      -1,
   } },

   /* ('flt', ('i2f', 'a'), 0.0) => ('ilt', 'a', 0) */
   /* search429_0_0 -> 9 in the cache */
   /* search429_0 -> 1375 in the cache */
   /* search429_1 -> 1257 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_flt,
      -1, 0,
      { 1375, 1257 },
      -1,
   } },

   /* replace429_0 -> 9 in the cache */
   /* replace429_1 -> 73 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ilt,
      -1, 0,
      { 9, 73 },
      -1,
   } },

   /* ('flt', 0.0, ('i2f', 'a')) => ('ilt', 0, 'a') */
   /* search430_0 -> 1257 in the cache */
   /* search430_1_0 -> 9 in the cache */
   /* search430_1 -> 1375 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_flt,
      -1, 0,
      { 1257, 1375 },
      -1,
   } },

   /* replace430_0 -> 73 in the cache */
   /* replace430_1 -> 9 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ilt,
      -1, 0,
      { 73, 9 },
      -1,
   } },

   /* ('~flt', 0.0, ('fabs', 'a')) => ('fneu', 'a', 0.0) */
   /* search431_0 -> 8 in the cache */
   /* search431_1_0 -> 9 in the cache */
   /* search431_1 -> 11 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      true,
      false,
      false,
      false,
      false,
      false,
      nir_op_flt,
      -1, 0,
      { 8, 11 },
      -1,
   } },

   /* replace431_0 -> 9 in the cache */
   /* replace431_1 -> 8 in the cache */
   /* replace431 -> 1236 in the cache */

   /* ('~flt', ('fneg', ('fabs', 'a')), 0.0) => ('fneu', 'a', 0.0) */
   /* search432_0_0_0 -> 9 in the cache */
   /* search432_0_0 -> 11 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fneg,
      -1, 0,
      { 11 },
      -1,
   } },
   /* search432_1 -> 8 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      true,
      false,
      false,
      false,
      false,
      false,
      nir_op_flt,
      -1, 0,
      { 1387, 8 },
      -1,
   } },

   /* replace432_0 -> 9 in the cache */
   /* replace432_1 -> 8 in the cache */
   /* replace432 -> 1236 in the cache */

   /* ('fge', 0.0, ('fabs', 'a')) => ('feq', 'a', 0.0) */
   /* search433_0 -> 8 in the cache */
   /* search433_1_0 -> 9 in the cache */
   /* search433_1 -> 11 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fge,
      -1, 0,
      { 8, 11 },
      -1,
   } },

   /* replace433_0 -> 9 in the cache */
   /* replace433_1 -> 8 in the cache */
   /* replace433 -> 1238 in the cache */

   /* ('fge', ('fneg', ('fabs', 'a')), 0.0) => ('feq', 'a', 0.0) */
   /* search434_0_0_0 -> 9 in the cache */
   /* search434_0_0 -> 11 in the cache */
   /* search434_0 -> 1387 in the cache */
   /* search434_1 -> 8 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fge,
      -1, 0,
      { 1387, 8 },
      -1,
   } },

   /* replace434_0 -> 9 in the cache */
   /* replace434_1 -> 8 in the cache */
   /* replace434 -> 1238 in the cache */

   /* ('iand', ('fge', 'a', 0.0), ('fge', 1.0, 'a')) => ('feq', 'a', ('fsat', 'a')) */
   /* search435_0_0 -> 9 in the cache */
   /* search435_0_1 -> 8 in the cache */
   /* search435_0 -> 1303 in the cache */
   /* search435_1_0 -> 259 in the cache */
   /* search435_1_1 -> 9 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fge,
      -1, 0,
      { 259, 9 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_iand,
      0, 1,
      { 1303, 1391 },
      -1,
   } },

   /* replace435_0 -> 9 in the cache */
   /* replace435_1_0 -> 9 in the cache */
   /* replace435_1 -> 235 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_feq,
      0, 1,
      { 9, 235 },
      -1,
   } },

   /* ('fmax', ('b2f(is_used_once)', 'a@1'), ('b2f', 'b@1')) => ('b2f', ('ior', 'a', 'b')) */
   /* search436_0_0 -> 859 in the cache */
   { .expression = {
      { nir_search_value_expression, 0 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_search_op_b2f,
      -1, 0,
      { 859 },
      0,
   } },
   /* search436_1_0 -> 1263 in the cache */
   /* search436_1 -> 1264 in the cache */
   { .expression = {
      { nir_search_value_expression, 0 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fmax,
      0, 1,
      { 1394, 1264 },
      -1,
   } },

   /* replace436_0_0 -> 859 in the cache */
   /* replace436_0_1 -> 1263 in the cache */
   /* replace436_0 -> 1267 in the cache */
   { .expression = {
      { nir_search_value_expression, 0 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_search_op_b2f,
      -1, 1,
      { 1267 },
      -1,
   } },

   /* ('fmax', ('fneg(is_used_once)', ('b2f(is_used_once)', 'a@1')), ('fneg', ('b2f', 'b@1'))) => ('fneg', ('b2f', ('iand', 'a', 'b'))) */
   /* search437_0_0_0 -> 859 in the cache */
   /* search437_0_0 -> 1394 in the cache */
   { .expression = {
      { nir_search_value_expression, 0 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fneg,
      -1, 0,
      { 1394 },
      0,
   } },
   /* search437_1_0_0 -> 1263 in the cache */
   /* search437_1_0 -> 1264 in the cache */
   /* search437_1 -> 1271 in the cache */
   { .expression = {
      { nir_search_value_expression, 0 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fmax,
      0, 1,
      { 1397, 1271 },
      -1,
   } },

   /* replace437_0_0_0 -> 859 in the cache */
   /* replace437_0_0_1 -> 1263 in the cache */
   /* replace437_0_0 -> 1275 in the cache */
   { .expression = {
      { nir_search_value_expression, 0 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_search_op_b2f,
      -1, 1,
      { 1275 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 0 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fneg,
      -1, 1,
      { 1399 },
      -1,
   } },

   /* ('fmin', ('b2f(is_used_once)', 'a@1'), ('b2f', 'b@1')) => ('b2f', ('iand', 'a', 'b')) */
   /* search438_0_0 -> 859 in the cache */
   /* search438_0 -> 1394 in the cache */
   /* search438_1_0 -> 1263 in the cache */
   /* search438_1 -> 1264 in the cache */
   { .expression = {
      { nir_search_value_expression, 0 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fmin,
      0, 1,
      { 1394, 1264 },
      -1,
   } },

   /* replace438_0_0 -> 859 in the cache */
   /* replace438_0_1 -> 1263 in the cache */
   /* replace438_0 -> 1275 in the cache */
   /* replace438 -> 1399 in the cache */

   /* ('fmin', ('fneg(is_used_once)', ('b2f(is_used_once)', 'a@1')), ('fneg', ('b2f', 'b@1'))) => ('fneg', ('b2f', ('ior', 'a', 'b'))) */
   /* search439_0_0_0 -> 859 in the cache */
   /* search439_0_0 -> 1394 in the cache */
   /* search439_0 -> 1397 in the cache */
   /* search439_1_0_0 -> 1263 in the cache */
   /* search439_1_0 -> 1264 in the cache */
   /* search439_1 -> 1271 in the cache */
   { .expression = {
      { nir_search_value_expression, 0 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fmin,
      0, 1,
      { 1397, 1271 },
      -1,
   } },

   /* replace439_0_0_0 -> 859 in the cache */
   /* replace439_0_0_1 -> 1263 in the cache */
   /* replace439_0_0 -> 1267 in the cache */
   /* replace439_0 -> 1396 in the cache */
   { .expression = {
      { nir_search_value_expression, 0 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fneg,
      -1, 1,
      { 1396 },
      -1,
   } },

   /* ('fmin', ('b2f', 'a@1'), '#b') => ('bcsel', 'a', ('fmin', 'b', 1.0), ('fmin', 'b', 0.0)) */
   /* search440_0_0 -> 859 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_search_op_b2f,
      -1, 0,
      { 859 },
      -1,
   } },
   /* search440_1 -> 923 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fmin,
      0, 1,
      { 1404, 923 },
      -1,
   } },

   /* replace440_0 -> 859 in the cache */
   /* replace440_1_0 -> 1 in the cache */
   /* replace440_1_1 -> 283 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fmin,
      0, 1,
      { 1, 283 },
      -1,
   } },
   /* replace440_2_0 -> 1 in the cache */
   /* replace440_2_1 -> 273 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fmin,
      1, 1,
      { 1, 273 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_bcsel,
      -1, 2,
      { 859, 1406, 1407 },
      -1,
   } },

   /* ('flt', ('fadd(is_used_once)', 'a', ('fneg', 'b')), 0.0) => ('flt', 'a', 'b') */
   /* search441_0_0 -> 0 in the cache */
   /* search441_0_1_0 -> 1 in the cache */
   /* search441_0_1 -> 1187 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fadd,
      0, 1,
      { 0, 1187 },
      0,
   } },
   /* search441_1 -> 273 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_flt,
      -1, 1,
      { 1409, 273 },
      -1,
   } },

   /* replace441_0 -> 0 in the cache */
   /* replace441_1 -> 1 in the cache */
   /* replace441 -> 3 in the cache */

   /* ('fge', ('fneg', ('fabs', 'a')), 0.0) => ('feq', 'a', 0.0) */
   /* search442_0_0_0 -> 9 in the cache */
   /* search442_0_0 -> 11 in the cache */
   /* search442_0 -> 1387 in the cache */
   /* search442_1 -> 8 in the cache */
   /* search442 -> 1390 in the cache */

   /* replace442_0 -> 9 in the cache */
   /* replace442_1 -> 8 in the cache */
   /* replace442 -> 1238 in the cache */

   /* ('~bcsel', ('flt', 'b', 'a'), 'b', 'a') => ('fmin', 'a', 'b') */
   /* search443_0_0 -> 1204 in the cache */
   /* search443_0_1 -> 1203 in the cache */
   /* search443_0 -> 1246 in the cache */
   /* search443_1 -> 1204 in the cache */
   /* search443_2 -> 1203 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      true,
      false,
      false,
      false,
      false,
      false,
      nir_op_bcsel,
      -1, 0,
      { 1246, 1204, 1203 },
      -1,
   } },

   /* replace443_0 -> 1203 in the cache */
   /* replace443_1 -> 1204 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fmin,
      0, 1,
      { 1203, 1204 },
      -1,
   } },

   /* ('~bcsel', ('flt', 'a', 'b'), 'b', 'a') => ('fmax', 'a', 'b') */
   /* search444_0_0 -> 0 in the cache */
   /* search444_0_1 -> 1 in the cache */
   /* search444_0 -> 3 in the cache */
   /* search444_1 -> 1 in the cache */
   /* search444_2 -> 0 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      true,
      false,
      false,
      false,
      false,
      false,
      nir_op_bcsel,
      -1, 0,
      { 3, 1, 0 },
      -1,
   } },

   /* replace444_0 -> 0 in the cache */
   /* replace444_1 -> 1 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fmax,
      0, 1,
      { 0, 1 },
      -1,
   } },

   /* ('~bcsel', ('fge', 'a', 'b'), 'b', 'a') => ('fmin', 'a', 'b') */
   /* search445_0_0 -> 0 in the cache */
   /* search445_0_1 -> 1 in the cache */
   /* search445_0 -> 6 in the cache */
   /* search445_1 -> 1 in the cache */
   /* search445_2 -> 0 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      true,
      false,
      false,
      false,
      false,
      false,
      nir_op_bcsel,
      -1, 0,
      { 6, 1, 0 },
      -1,
   } },

   /* replace445_0 -> 0 in the cache */
   /* replace445_1 -> 1 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fmin,
      0, 1,
      { 0, 1 },
      -1,
   } },

   /* ('~bcsel', ('fge', 'b', 'a'), 'b', 'a') => ('fmax', 'a', 'b') */
   /* search446_0_0 -> 1204 in the cache */
   /* search446_0_1 -> 1203 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fge,
      -1, 0,
      { 1204, 1203 },
      -1,
   } },
   /* search446_1 -> 1204 in the cache */
   /* search446_2 -> 1203 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      true,
      false,
      false,
      false,
      false,
      false,
      nir_op_bcsel,
      -1, 0,
      { 1417, 1204, 1203 },
      -1,
   } },

   /* replace446_0 -> 1203 in the cache */
   /* replace446_1 -> 1204 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fmax,
      0, 1,
      { 1203, 1204 },
      -1,
   } },

   /* ('bcsel', ('inot', 'a'), 'b', 'c') => ('bcsel', 'a', 'c', 'b') */
   /* search447_0_0 -> 859 in the cache */
   /* search447_0 -> 1260 in the cache */
   /* search447_1 -> 140 in the cache */
   /* search447_2 -> 142 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_bcsel,
      -1, 0,
      { 1260, 140, 142 },
      -1,
   } },

   /* replace447_0 -> 859 in the cache */
   /* replace447_1 -> 142 in the cache */
   /* replace447_2 -> 140 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_bcsel,
      -1, 0,
      { 859, 142, 140 },
      -1,
   } },

   /* ('bcsel', 'a', ('bcsel', 'a', 'b', 'c'), 'd') => ('bcsel', 'a', 'b', 'd') */
   /* search448_0 -> 859 in the cache */
   /* search448_1_0 -> 859 in the cache */
   /* search448_1_1 -> 163 in the cache */
   /* search448_1_2 -> 165 in the cache */
   { .expression = {
      { nir_search_value_expression, -4 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_bcsel,
      -1, 0,
      { 859, 163, 165 },
      -1,
   } },
   /* search448_2 -> 166 in the cache */
   { .expression = {
      { nir_search_value_expression, -4 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_bcsel,
      -1, 0,
      { 859, 1422, 166 },
      -1,
   } },

   /* replace448_0 -> 859 in the cache */
   /* replace448_1 -> 163 in the cache */
   /* replace448_2 -> 166 in the cache */
   { .expression = {
      { nir_search_value_expression, -4 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_bcsel,
      -1, 0,
      { 859, 163, 166 },
      -1,
   } },

   /* ('bcsel', 'a', 'b', ('bcsel', 'a', 'c', 'd')) => ('bcsel', 'a', 'b', 'd') */
   /* search449_0 -> 859 in the cache */
   /* search449_1 -> 163 in the cache */
   /* search449_2_0 -> 859 in the cache */
   /* search449_2_1 -> 165 in the cache */
   /* search449_2_2 -> 166 in the cache */
   { .expression = {
      { nir_search_value_expression, -4 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_bcsel,
      -1, 0,
      { 859, 165, 166 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -4 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_bcsel,
      -1, 0,
      { 859, 163, 1425 },
      -1,
   } },

   /* replace449_0 -> 859 in the cache */
   /* replace449_1 -> 163 in the cache */
   /* replace449_2 -> 166 in the cache */
   /* replace449 -> 1424 in the cache */

   /* ('bcsel', 'a', ('bcsel', 'b', 'c', 'd'), ('bcsel(is_used_once)', 'b', 'c', 'e')) => ('bcsel', 'b', 'c', ('bcsel', 'a', 'd', 'e')) */
   /* search450_0 -> 859 in the cache */
   /* search450_1_0 -> 1263 in the cache */
   /* search450_1_1 -> 852 in the cache */
   /* search450_1_2 -> 861 in the cache */
   { .expression = {
      { nir_search_value_expression, -5 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_bcsel,
      -1, 0,
      { 1263, 852, 861 },
      -1,
   } },
   /* search450_2_0 -> 1263 in the cache */
   /* search450_2_1 -> 852 in the cache */
   /* search450_2_2 -> 863 in the cache */
   { .expression = {
      { nir_search_value_expression, -5 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_bcsel,
      -1, 0,
      { 1263, 852, 863 },
      0,
   } },
   { .expression = {
      { nir_search_value_expression, -5 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_bcsel,
      -1, 0,
      { 859, 1427, 1428 },
      -1,
   } },

   /* replace450_0 -> 1263 in the cache */
   /* replace450_1 -> 852 in the cache */
   /* replace450_2_0 -> 859 in the cache */
   /* replace450_2_1 -> 861 in the cache */
   /* replace450_2_2 -> 863 in the cache */
   { .expression = {
      { nir_search_value_expression, -5 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_bcsel,
      -1, 0,
      { 859, 861, 863 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -5 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_bcsel,
      -1, 0,
      { 1263, 852, 1430 },
      -1,
   } },

   /* ('bcsel', 'a', ('bcsel(is_used_once)', 'b', 'c', 'd'), ('bcsel', 'b', 'c', 'e')) => ('bcsel', 'b', 'c', ('bcsel', 'a', 'd', 'e')) */
   /* search451_0 -> 859 in the cache */
   /* search451_1_0 -> 1263 in the cache */
   /* search451_1_1 -> 852 in the cache */
   /* search451_1_2 -> 861 in the cache */
   { .expression = {
      { nir_search_value_expression, -5 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_bcsel,
      -1, 0,
      { 1263, 852, 861 },
      0,
   } },
   /* search451_2_0 -> 1263 in the cache */
   /* search451_2_1 -> 852 in the cache */
   /* search451_2_2 -> 863 in the cache */
   { .expression = {
      { nir_search_value_expression, -5 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_bcsel,
      -1, 0,
      { 1263, 852, 863 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -5 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_bcsel,
      -1, 0,
      { 859, 1432, 1433 },
      -1,
   } },

   /* replace451_0 -> 1263 in the cache */
   /* replace451_1 -> 852 in the cache */
   /* replace451_2_0 -> 859 in the cache */
   /* replace451_2_1 -> 861 in the cache */
   /* replace451_2_2 -> 863 in the cache */
   /* replace451_2 -> 1430 in the cache */
   /* replace451 -> 1431 in the cache */

   /* ('bcsel', 'a', ('bcsel', 'b', 'c', 'd'), ('bcsel(is_used_once)', 'b', 'e', 'd')) => ('bcsel', 'b', ('bcsel', 'a', 'c', 'e'), 'd') */
   /* search452_0 -> 859 in the cache */
   /* search452_1_0 -> 1263 in the cache */
   /* search452_1_1 -> 165 in the cache */
   /* search452_1_2 -> 166 in the cache */
   { .expression = {
      { nir_search_value_expression, -4 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_bcsel,
      -1, 0,
      { 1263, 165, 166 },
      -1,
   } },
   /* search452_2_0 -> 1263 in the cache */
   { .variable = {
      { nir_search_value_variable, -4 },
      4, /* e */
      false,
      nir_type_invalid,
      -1,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   /* search452_2_2 -> 166 in the cache */
   { .expression = {
      { nir_search_value_expression, -4 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_bcsel,
      -1, 0,
      { 1263, 1436, 166 },
      0,
   } },
   { .expression = {
      { nir_search_value_expression, -4 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_bcsel,
      -1, 0,
      { 859, 1435, 1437 },
      -1,
   } },

   /* replace452_0 -> 1263 in the cache */
   /* replace452_1_0 -> 859 in the cache */
   /* replace452_1_1 -> 165 in the cache */
   /* replace452_1_2 -> 1436 in the cache */
   { .expression = {
      { nir_search_value_expression, -4 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_bcsel,
      -1, 0,
      { 859, 165, 1436 },
      -1,
   } },
   /* replace452_2 -> 166 in the cache */
   { .expression = {
      { nir_search_value_expression, -4 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_bcsel,
      -1, 0,
      { 1263, 1439, 166 },
      -1,
   } },

   /* ('bcsel', 'a', ('bcsel(is_used_once)', 'b', 'c', 'd'), ('bcsel', 'b', 'e', 'd')) => ('bcsel', 'b', ('bcsel', 'a', 'c', 'e'), 'd') */
   /* search453_0 -> 859 in the cache */
   /* search453_1_0 -> 1263 in the cache */
   /* search453_1_1 -> 165 in the cache */
   /* search453_1_2 -> 166 in the cache */
   { .expression = {
      { nir_search_value_expression, -4 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_bcsel,
      -1, 0,
      { 1263, 165, 166 },
      0,
   } },
   /* search453_2_0 -> 1263 in the cache */
   /* search453_2_1 -> 1436 in the cache */
   /* search453_2_2 -> 166 in the cache */
   { .expression = {
      { nir_search_value_expression, -4 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_bcsel,
      -1, 0,
      { 1263, 1436, 166 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -4 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_bcsel,
      -1, 0,
      { 859, 1441, 1442 },
      -1,
   } },

   /* replace453_0 -> 1263 in the cache */
   /* replace453_1_0 -> 859 in the cache */
   /* replace453_1_1 -> 165 in the cache */
   /* replace453_1_2 -> 1436 in the cache */
   /* replace453_1 -> 1439 in the cache */
   /* replace453_2 -> 166 in the cache */
   /* replace453 -> 1440 in the cache */

   /* ('bcsel', 'a', True, 'b') => ('ior', 'a', 'b') */
   /* search454_0 -> 859 in the cache */
   /* search454_1 -> 1363 in the cache */
   /* search454_2 -> 1263 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_bcsel,
      -1, 0,
      { 859, 1363, 1263 },
      -1,
   } },

   /* replace454_0 -> 859 in the cache */
   /* replace454_1 -> 1263 in the cache */
   /* replace454 -> 1267 in the cache */

   /* ('bcsel', 'a', 'a', 'b') => ('ior', 'a', 'b') */
   /* search455_0 -> 859 in the cache */
   /* search455_1 -> 859 in the cache */
   /* search455_2 -> 1263 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_bcsel,
      -1, 0,
      { 859, 859, 1263 },
      -1,
   } },

   /* replace455_0 -> 859 in the cache */
   /* replace455_1 -> 1263 in the cache */
   /* replace455 -> 1267 in the cache */

   /* ('bcsel', 'a', 'b', False) => ('iand', 'a', 'b') */
   /* search456_0 -> 859 in the cache */
   /* search456_1 -> 1263 in the cache */
   /* search456_2 -> 1177 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_bcsel,
      -1, 0,
      { 859, 1263, 1177 },
      -1,
   } },

   /* replace456_0 -> 859 in the cache */
   /* replace456_1 -> 1263 in the cache */
   /* replace456 -> 1275 in the cache */

   /* ('bcsel', 'a', 'b', 'a') => ('iand', 'a', 'b') */
   /* search457_0 -> 859 in the cache */
   /* search457_1 -> 1263 in the cache */
   /* search457_2 -> 859 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_bcsel,
      -1, 0,
      { 859, 1263, 859 },
      -1,
   } },

   /* replace457_0 -> 859 in the cache */
   /* replace457_1 -> 1263 in the cache */
   /* replace457 -> 1275 in the cache */

   /* ('~fmin', 'a', 'a') => a */
   /* search458_0 -> 9 in the cache */
   /* search458_1 -> 9 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      true,
      false,
      false,
      false,
      false,
      false,
      nir_op_fmin,
      -1, 0,
      { 9, 9 },
      -1,
   } },

   /* replace458 -> 9 in the cache */

   /* ('~fmax', 'a', 'a') => a */
   /* search459_0 -> 9 in the cache */
   /* search459_1 -> 9 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      true,
      false,
      false,
      false,
      false,
      false,
      nir_op_fmax,
      -1, 0,
      { 9, 9 },
      -1,
   } },

   /* replace459 -> 9 in the cache */

   /* ('imin', 'a', 'a') => a */
   /* search460_0 -> 9 in the cache */
   /* search460_1 -> 9 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_imin,
      -1, 0,
      { 9, 9 },
      -1,
   } },

   /* replace460 -> 9 in the cache */

   /* ('imax', 'a', 'a') => a */
   /* search461_0 -> 9 in the cache */
   /* search461_1 -> 9 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_imax,
      -1, 0,
      { 9, 9 },
      -1,
   } },

   /* replace461 -> 9 in the cache */

   /* ('umin', 'a', 'a') => a */
   /* search462_0 -> 9 in the cache */
   /* search462_1 -> 9 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_umin,
      -1, 0,
      { 9, 9 },
      -1,
   } },

   /* replace462 -> 9 in the cache */

   /* ('umin', 'a', 0) => 0 */
   /* search463_0 -> 9 in the cache */
   /* search463_1 -> 73 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_umin,
      0, 1,
      { 9, 73 },
      -1,
   } },

   /* replace463 -> 73 in the cache */

   /* ('umin', 'a', -1) => a */
   /* search464_0 -> 9 in the cache */
   /* search464_1 -> 75 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_umin,
      0, 1,
      { 9, 75 },
      -1,
   } },

   /* replace464 -> 9 in the cache */

   /* ('umax', 'a', 'a') => a */
   /* search465_0 -> 9 in the cache */
   /* search465_1 -> 9 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_umax,
      -1, 0,
      { 9, 9 },
      -1,
   } },

   /* replace465 -> 9 in the cache */

   /* ('umax', 'a', 0) => a */
   /* search466_0 -> 9 in the cache */
   /* search466_1 -> 73 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_umax,
      0, 1,
      { 9, 73 },
      -1,
   } },

   /* replace466 -> 9 in the cache */

   /* ('umax', 'a', -1) => -1 */
   /* search467_0 -> 9 in the cache */
   /* search467_1 -> 75 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_umax,
      0, 1,
      { 9, 75 },
      -1,
   } },

   /* replace467 -> 75 in the cache */

   /* ('fmax', ('fmax', 'a', 'b'), 'b') => ('fmax', 'a', 'b') */
   /* search468_0_0 -> 0 in the cache */
   /* search468_0_1 -> 1 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fmax,
      1, 1,
      { 0, 1 },
      -1,
   } },
   /* search468_1 -> 1 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fmax,
      0, 2,
      { 1458, 1 },
      -1,
   } },

   /* replace468_0 -> 0 in the cache */
   /* replace468_1 -> 1 in the cache */
   /* replace468 -> 1414 in the cache */

   /* ('umax', ('umax', 'a', 'b'), 'b') => ('umax', 'a', 'b') */
   /* search469_0_0 -> 0 in the cache */
   /* search469_0_1 -> 1 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_umax,
      1, 1,
      { 0, 1 },
      -1,
   } },
   /* search469_1 -> 1 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_umax,
      0, 2,
      { 1460, 1 },
      -1,
   } },

   /* replace469_0 -> 0 in the cache */
   /* replace469_1 -> 1 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_umax,
      0, 1,
      { 0, 1 },
      -1,
   } },

   /* ('imax', ('imax', 'a', 'b'), 'b') => ('imax', 'a', 'b') */
   /* search470_0_0 -> 0 in the cache */
   /* search470_0_1 -> 1 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_imax,
      1, 1,
      { 0, 1 },
      -1,
   } },
   /* search470_1 -> 1 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_imax,
      0, 2,
      { 1463, 1 },
      -1,
   } },

   /* replace470_0 -> 0 in the cache */
   /* replace470_1 -> 1 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_imax,
      0, 1,
      { 0, 1 },
      -1,
   } },

   /* ('fmin', ('fmin', 'a', 'b'), 'b') => ('fmin', 'a', 'b') */
   /* search471_0_0 -> 0 in the cache */
   /* search471_0_1 -> 1 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fmin,
      1, 1,
      { 0, 1 },
      -1,
   } },
   /* search471_1 -> 1 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fmin,
      0, 2,
      { 1466, 1 },
      -1,
   } },

   /* replace471_0 -> 0 in the cache */
   /* replace471_1 -> 1 in the cache */
   /* replace471 -> 1416 in the cache */

   /* ('umin', ('umin', 'a', 'b'), 'b') => ('umin', 'a', 'b') */
   /* search472_0_0 -> 0 in the cache */
   /* search472_0_1 -> 1 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_umin,
      1, 1,
      { 0, 1 },
      -1,
   } },
   /* search472_1 -> 1 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_umin,
      0, 2,
      { 1468, 1 },
      -1,
   } },

   /* replace472_0 -> 0 in the cache */
   /* replace472_1 -> 1 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_umin,
      0, 1,
      { 0, 1 },
      -1,
   } },

   /* ('imin', ('imin', 'a', 'b'), 'b') => ('imin', 'a', 'b') */
   /* search473_0_0 -> 0 in the cache */
   /* search473_0_1 -> 1 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_imin,
      1, 1,
      { 0, 1 },
      -1,
   } },
   /* search473_1 -> 1 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_imin,
      0, 2,
      { 1471, 1 },
      -1,
   } },

   /* replace473_0 -> 0 in the cache */
   /* replace473_1 -> 1 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_imin,
      0, 1,
      { 0, 1 },
      -1,
   } },

   /* ('fmax', ('fmax', ('fmax', 'a', 'b'), 'c'), 'a') => ('fmax', ('fmax', 'a', 'b'), 'c') */
   /* search474_0_0_0 -> 139 in the cache */
   /* search474_0_0_1 -> 140 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fmax,
      2, 1,
      { 139, 140 },
      -1,
   } },
   /* search474_0_1 -> 142 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fmax,
      1, 2,
      { 1474, 142 },
      -1,
   } },
   /* search474_1 -> 139 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fmax,
      0, 3,
      { 1475, 139 },
      -1,
   } },

   /* replace474_0_0 -> 139 in the cache */
   /* replace474_0_1 -> 140 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fmax,
      1, 1,
      { 139, 140 },
      -1,
   } },
   /* replace474_1 -> 142 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fmax,
      0, 2,
      { 1477, 142 },
      -1,
   } },

   /* ('umax', ('umax', ('umax', 'a', 'b'), 'c'), 'a') => ('umax', ('umax', 'a', 'b'), 'c') */
   /* search475_0_0_0 -> 139 in the cache */
   /* search475_0_0_1 -> 140 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_umax,
      2, 1,
      { 139, 140 },
      -1,
   } },
   /* search475_0_1 -> 142 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_umax,
      1, 2,
      { 1479, 142 },
      -1,
   } },
   /* search475_1 -> 139 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_umax,
      0, 3,
      { 1480, 139 },
      -1,
   } },

   /* replace475_0_0 -> 139 in the cache */
   /* replace475_0_1 -> 140 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_umax,
      1, 1,
      { 139, 140 },
      -1,
   } },
   /* replace475_1 -> 142 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_umax,
      0, 2,
      { 1482, 142 },
      -1,
   } },

   /* ('imax', ('imax', ('imax', 'a', 'b'), 'c'), 'a') => ('imax', ('imax', 'a', 'b'), 'c') */
   /* search476_0_0_0 -> 139 in the cache */
   /* search476_0_0_1 -> 140 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_imax,
      2, 1,
      { 139, 140 },
      -1,
   } },
   /* search476_0_1 -> 142 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_imax,
      1, 2,
      { 1484, 142 },
      -1,
   } },
   /* search476_1 -> 139 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_imax,
      0, 3,
      { 1485, 139 },
      -1,
   } },

   /* replace476_0_0 -> 139 in the cache */
   /* replace476_0_1 -> 140 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_imax,
      1, 1,
      { 139, 140 },
      -1,
   } },
   /* replace476_1 -> 142 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_imax,
      0, 2,
      { 1487, 142 },
      -1,
   } },

   /* ('fmin', ('fmin', ('fmin', 'a', 'b'), 'c'), 'a') => ('fmin', ('fmin', 'a', 'b'), 'c') */
   /* search477_0_0_0 -> 139 in the cache */
   /* search477_0_0_1 -> 140 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fmin,
      2, 1,
      { 139, 140 },
      -1,
   } },
   /* search477_0_1 -> 142 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fmin,
      1, 2,
      { 1489, 142 },
      -1,
   } },
   /* search477_1 -> 139 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fmin,
      0, 3,
      { 1490, 139 },
      -1,
   } },

   /* replace477_0_0 -> 139 in the cache */
   /* replace477_0_1 -> 140 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fmin,
      1, 1,
      { 139, 140 },
      -1,
   } },
   /* replace477_1 -> 142 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fmin,
      0, 2,
      { 1492, 142 },
      -1,
   } },

   /* ('umin', ('umin', ('umin', 'a', 'b'), 'c'), 'a') => ('umin', ('umin', 'a', 'b'), 'c') */
   /* search478_0_0_0 -> 139 in the cache */
   /* search478_0_0_1 -> 140 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_umin,
      2, 1,
      { 139, 140 },
      -1,
   } },
   /* search478_0_1 -> 142 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_umin,
      1, 2,
      { 1494, 142 },
      -1,
   } },
   /* search478_1 -> 139 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_umin,
      0, 3,
      { 1495, 139 },
      -1,
   } },

   /* replace478_0_0 -> 139 in the cache */
   /* replace478_0_1 -> 140 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_umin,
      1, 1,
      { 139, 140 },
      -1,
   } },
   /* replace478_1 -> 142 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_umin,
      0, 2,
      { 1497, 142 },
      -1,
   } },

   /* ('imin', ('imin', ('imin', 'a', 'b'), 'c'), 'a') => ('imin', ('imin', 'a', 'b'), 'c') */
   /* search479_0_0_0 -> 139 in the cache */
   /* search479_0_0_1 -> 140 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_imin,
      2, 1,
      { 139, 140 },
      -1,
   } },
   /* search479_0_1 -> 142 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_imin,
      1, 2,
      { 1499, 142 },
      -1,
   } },
   /* search479_1 -> 139 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_imin,
      0, 3,
      { 1500, 139 },
      -1,
   } },

   /* replace479_0_0 -> 139 in the cache */
   /* replace479_0_1 -> 140 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_imin,
      1, 1,
      { 139, 140 },
      -1,
   } },
   /* replace479_1 -> 142 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_imin,
      0, 2,
      { 1502, 142 },
      -1,
   } },

   /* ('ieq', ('b2i8', 'a@1'), ('b2i8', 'b@1')) => ('ieq', 'a', 'b') */
   /* search480_0_0 -> 859 in the cache */
   { .expression = {
      { nir_search_value_expression, 8 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_b2i8,
      -1, 0,
      { 859 },
      -1,
   } },
   /* search480_1_0 -> 1263 in the cache */
   { .expression = {
      { nir_search_value_expression, 8 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_b2i8,
      -1, 0,
      { 1263 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ieq,
      0, 1,
      { 1504, 1505 },
      -1,
   } },

   /* replace480_0 -> 859 in the cache */
   /* replace480_1 -> 1263 in the cache */
   /* replace480 -> 1291 in the cache */

   /* ('ine', ('b2i8', 'a@1'), ('b2i8', 'b@1')) => ('ine', 'a', 'b') */
   /* search481_0_0 -> 859 in the cache */
   /* search481_0 -> 1504 in the cache */
   /* search481_1_0 -> 1263 in the cache */
   /* search481_1 -> 1505 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ine,
      0, 1,
      { 1504, 1505 },
      -1,
   } },

   /* replace481_0 -> 859 in the cache */
   /* replace481_1 -> 1263 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ine,
      0, 1,
      { 859, 1263 },
      -1,
   } },

   /* ('ieq', ('b2i16', 'a@1'), ('b2i16', 'b@1')) => ('ieq', 'a', 'b') */
   /* search482_0_0 -> 859 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_b2i16,
      -1, 0,
      { 859 },
      -1,
   } },
   /* search482_1_0 -> 1263 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_b2i16,
      -1, 0,
      { 1263 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ieq,
      0, 1,
      { 1509, 1510 },
      -1,
   } },

   /* replace482_0 -> 859 in the cache */
   /* replace482_1 -> 1263 in the cache */
   /* replace482 -> 1291 in the cache */

   /* ('ine', ('b2i16', 'a@1'), ('b2i16', 'b@1')) => ('ine', 'a', 'b') */
   /* search483_0_0 -> 859 in the cache */
   /* search483_0 -> 1509 in the cache */
   /* search483_1_0 -> 1263 in the cache */
   /* search483_1 -> 1510 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ine,
      0, 1,
      { 1509, 1510 },
      -1,
   } },

   /* replace483_0 -> 859 in the cache */
   /* replace483_1 -> 1263 in the cache */
   /* replace483 -> 1508 in the cache */

   /* ('ieq', ('b2i32', 'a@1'), ('b2i32', 'b@1')) => ('ieq', 'a', 'b') */
   /* search484_0_0 -> 859 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_b2i32,
      -1, 0,
      { 859 },
      -1,
   } },
   /* search484_1_0 -> 1263 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_b2i32,
      -1, 0,
      { 1263 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ieq,
      0, 1,
      { 1513, 1514 },
      -1,
   } },

   /* replace484_0 -> 859 in the cache */
   /* replace484_1 -> 1263 in the cache */
   /* replace484 -> 1291 in the cache */

   /* ('ine', ('b2i32', 'a@1'), ('b2i32', 'b@1')) => ('ine', 'a', 'b') */
   /* search485_0_0 -> 859 in the cache */
   /* search485_0 -> 1513 in the cache */
   /* search485_1_0 -> 1263 in the cache */
   /* search485_1 -> 1514 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ine,
      0, 1,
      { 1513, 1514 },
      -1,
   } },

   /* replace485_0 -> 859 in the cache */
   /* replace485_1 -> 1263 in the cache */
   /* replace485 -> 1508 in the cache */

   /* ('ieq', ('b2i64', 'a@1'), ('b2i64', 'b@1')) => ('ieq', 'a', 'b') */
   /* search486_0_0 -> 859 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_b2i64,
      -1, 0,
      { 859 },
      -1,
   } },
   /* search486_1_0 -> 1263 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_b2i64,
      -1, 0,
      { 1263 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ieq,
      0, 1,
      { 1517, 1518 },
      -1,
   } },

   /* replace486_0 -> 859 in the cache */
   /* replace486_1 -> 1263 in the cache */
   /* replace486 -> 1291 in the cache */

   /* ('ine', ('b2i64', 'a@1'), ('b2i64', 'b@1')) => ('ine', 'a', 'b') */
   /* search487_0_0 -> 859 in the cache */
   /* search487_0 -> 1517 in the cache */
   /* search487_1_0 -> 1263 in the cache */
   /* search487_1 -> 1518 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ine,
      0, 1,
      { 1517, 1518 },
      -1,
   } },

   /* replace487_0 -> 859 in the cache */
   /* replace487_1 -> 1263 in the cache */
   /* replace487 -> 1508 in the cache */

   /* ('feq', ('b2f16', 'a@1'), ('b2f16', 'b@1')) => ('ieq', 'a', 'b') */
   /* search488_0_0 -> 859 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_b2f16,
      -1, 0,
      { 859 },
      -1,
   } },
   /* search488_1_0 -> 1263 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_b2f16,
      -1, 0,
      { 1263 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_feq,
      0, 1,
      { 1521, 1522 },
      -1,
   } },

   /* replace488_0 -> 859 in the cache */
   /* replace488_1 -> 1263 in the cache */
   /* replace488 -> 1291 in the cache */

   /* ('fneu', ('b2f16', 'a@1'), ('b2f16', 'b@1')) => ('ine', 'a', 'b') */
   /* search489_0_0 -> 859 in the cache */
   /* search489_0 -> 1521 in the cache */
   /* search489_1_0 -> 1263 in the cache */
   /* search489_1 -> 1522 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fneu,
      0, 1,
      { 1521, 1522 },
      -1,
   } },

   /* replace489_0 -> 859 in the cache */
   /* replace489_1 -> 1263 in the cache */
   /* replace489 -> 1508 in the cache */

   /* ('feq', ('b2f32', 'a@1'), ('b2f32', 'b@1')) => ('ieq', 'a', 'b') */
   /* search490_0_0 -> 859 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_b2f32,
      -1, 0,
      { 859 },
      -1,
   } },
   /* search490_1_0 -> 1263 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_b2f32,
      -1, 0,
      { 1263 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_feq,
      0, 1,
      { 1525, 1526 },
      -1,
   } },

   /* replace490_0 -> 859 in the cache */
   /* replace490_1 -> 1263 in the cache */
   /* replace490 -> 1291 in the cache */

   /* ('fneu', ('b2f32', 'a@1'), ('b2f32', 'b@1')) => ('ine', 'a', 'b') */
   /* search491_0_0 -> 859 in the cache */
   /* search491_0 -> 1525 in the cache */
   /* search491_1_0 -> 1263 in the cache */
   /* search491_1 -> 1526 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fneu,
      0, 1,
      { 1525, 1526 },
      -1,
   } },

   /* replace491_0 -> 859 in the cache */
   /* replace491_1 -> 1263 in the cache */
   /* replace491 -> 1508 in the cache */

   /* ('feq', ('b2f64', 'a@1'), ('b2f64', 'b@1')) => ('ieq', 'a', 'b') */
   /* search492_0_0 -> 859 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_b2f64,
      -1, 0,
      { 859 },
      -1,
   } },
   /* search492_1_0 -> 1263 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_b2f64,
      -1, 0,
      { 1263 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_feq,
      0, 1,
      { 1529, 1530 },
      -1,
   } },

   /* replace492_0 -> 859 in the cache */
   /* replace492_1 -> 1263 in the cache */
   /* replace492 -> 1291 in the cache */

   /* ('fneu', ('b2f64', 'a@1'), ('b2f64', 'b@1')) => ('ine', 'a', 'b') */
   /* search493_0_0 -> 859 in the cache */
   /* search493_0 -> 1529 in the cache */
   /* search493_1_0 -> 1263 in the cache */
   /* search493_1 -> 1530 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fneu,
      0, 1,
      { 1529, 1530 },
      -1,
   } },

   /* replace493_0 -> 859 in the cache */
   /* replace493_1 -> 1263 in the cache */
   /* replace493 -> 1508 in the cache */

   /* ('iand@8', 'a', ('inot', ('ishr', 'a', 7))) => ('imax', 'a', 0) */
   /* search494_0 -> 19 in the cache */
   /* search494_1_0_0 -> 19 in the cache */
   /* search494_1_0_1 -> 22 in the cache */
   { .expression = {
      { nir_search_value_expression, 8 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ishr,
      -1, 0,
      { 19, 22 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 8 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_inot,
      -1, 0,
      { 1533 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 8 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_iand,
      0, 1,
      { 19, 1534 },
      -1,
   } },

   /* replace494_0 -> 19 in the cache */
   /* replace494_1 -> 937 in the cache */
   { .expression = {
      { nir_search_value_expression, 8 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_imax,
      0, 1,
      { 19, 937 },
      -1,
   } },

   /* ('ieq', ('iand', 'a@8', 128), 0) => ('ige', 'a', 0) */
   /* search495_0_0 -> 19 in the cache */
   /* search495_0_1 -> 20 in the cache */
   { .expression = {
      { nir_search_value_expression, 8 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_iand,
      1, 1,
      { 19, 20 },
      -1,
   } },
   /* search495_1 -> 937 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ieq,
      0, 2,
      { 1537, 937 },
      -1,
   } },

   /* replace495_0 -> 19 in the cache */
   /* replace495_1 -> 937 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ige,
      -1, 0,
      { 19, 937 },
      -1,
   } },

   /* ('ine', ('iand', 'a@8', 128), 128) => ('ige', 'a', 0) */
   /* search496_0_0 -> 19 in the cache */
   /* search496_0_1 -> 20 in the cache */
   /* search496_0 -> 1537 in the cache */
   /* search496_1 -> 20 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ine,
      0, 2,
      { 1537, 20 },
      -1,
   } },

   /* replace496_0 -> 19 in the cache */
   /* replace496_1 -> 937 in the cache */
   /* replace496 -> 1539 in the cache */

   /* ('ine', ('iand', 'a@8', 128), 0) => ('ilt', 'a', 0) */
   /* search497_0_0 -> 19 in the cache */
   /* search497_0_1 -> 20 in the cache */
   /* search497_0 -> 1537 in the cache */
   /* search497_1 -> 937 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ine,
      0, 2,
      { 1537, 937 },
      -1,
   } },

   /* replace497_0 -> 19 in the cache */
   /* replace497_1 -> 937 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ilt,
      -1, 0,
      { 19, 937 },
      -1,
   } },

   /* ('ieq', ('iand', 'a@8', 128), 128) => ('ilt', 'a', 0) */
   /* search498_0_0 -> 19 in the cache */
   /* search498_0_1 -> 20 in the cache */
   /* search498_0 -> 1537 in the cache */
   /* search498_1 -> 20 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ieq,
      0, 2,
      { 1537, 20 },
      -1,
   } },

   /* replace498_0 -> 19 in the cache */
   /* replace498_1 -> 937 in the cache */
   /* replace498 -> 1542 in the cache */

   /* ('ine', ('ushr', 'a@8', 7), 0) => ('ilt', 'a', 0) */
   /* search499_0_0 -> 19 in the cache */
   /* search499_0_1 -> 22 in the cache */
   { .expression = {
      { nir_search_value_expression, 8 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ushr,
      -1, 0,
      { 19, 22 },
      -1,
   } },
   /* search499_1 -> 937 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ine,
      0, 1,
      { 1544, 937 },
      -1,
   } },

   /* replace499_0 -> 19 in the cache */
   /* replace499_1 -> 937 in the cache */
   /* replace499 -> 1542 in the cache */

   /* ('ieq', ('ushr', 'a@8', 7), 0) => ('ige', 'a', 0) */
   /* search500_0_0 -> 19 in the cache */
   /* search500_0_1 -> 22 in the cache */
   /* search500_0 -> 1544 in the cache */
   /* search500_1 -> 937 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ieq,
      0, 1,
      { 1544, 937 },
      -1,
   } },

   /* replace500_0 -> 19 in the cache */
   /* replace500_1 -> 937 in the cache */
   /* replace500 -> 1539 in the cache */

   /* ('ieq', ('ushr', 'a@8', 7), 1) => ('ilt', 'a', 0) */
   /* search501_0_0 -> 19 in the cache */
   /* search501_0_1 -> 22 in the cache */
   /* search501_0 -> 1544 in the cache */
   { .constant = {
      { nir_search_value_constant, 8 },
      nir_type_int, { 0x1ull /* 1 */ },
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ieq,
      0, 1,
      { 1544, 1547 },
      -1,
   } },

   /* replace501_0 -> 19 in the cache */
   /* replace501_1 -> 937 in the cache */
   /* replace501 -> 1542 in the cache */

   /* ('ine', ('ushr', 'a@8', 7), 1) => ('ige', 'a', 0) */
   /* search502_0_0 -> 19 in the cache */
   /* search502_0_1 -> 22 in the cache */
   /* search502_0 -> 1544 in the cache */
   /* search502_1 -> 1547 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ine,
      0, 1,
      { 1544, 1547 },
      -1,
   } },

   /* replace502_0 -> 19 in the cache */
   /* replace502_1 -> 937 in the cache */
   /* replace502 -> 1539 in the cache */

   /* ('ine', ('ishr', 'a@8', 7), 0) => ('ilt', 'a', 0) */
   /* search503_0_0 -> 19 in the cache */
   /* search503_0_1 -> 22 in the cache */
   /* search503_0 -> 1533 in the cache */
   /* search503_1 -> 937 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ine,
      0, 1,
      { 1533, 937 },
      -1,
   } },

   /* replace503_0 -> 19 in the cache */
   /* replace503_1 -> 937 in the cache */
   /* replace503 -> 1542 in the cache */

   /* ('ieq', ('ishr', 'a@8', 7), 0) => ('ige', 'a', 0) */
   /* search504_0_0 -> 19 in the cache */
   /* search504_0_1 -> 22 in the cache */
   /* search504_0 -> 1533 in the cache */
   /* search504_1 -> 937 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ieq,
      0, 1,
      { 1533, 937 },
      -1,
   } },

   /* replace504_0 -> 19 in the cache */
   /* replace504_1 -> 937 in the cache */
   /* replace504 -> 1539 in the cache */

   /* ('ieq', ('ishr', 'a@8', 7), -1) => ('ilt', 'a', 0) */
   /* search505_0_0 -> 19 in the cache */
   /* search505_0_1 -> 22 in the cache */
   /* search505_0 -> 1533 in the cache */
   { .constant = {
      { nir_search_value_constant, 8 },
      nir_type_int, { 0xffffffffffffffffull /* -1 */ },
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ieq,
      0, 1,
      { 1533, 1552 },
      -1,
   } },

   /* replace505_0 -> 19 in the cache */
   /* replace505_1 -> 937 in the cache */
   /* replace505 -> 1542 in the cache */

   /* ('ine', ('ishr', 'a@8', 7), -1) => ('ige', 'a', 0) */
   /* search506_0_0 -> 19 in the cache */
   /* search506_0_1 -> 22 in the cache */
   /* search506_0 -> 1533 in the cache */
   /* search506_1 -> 1552 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ine,
      0, 1,
      { 1533, 1552 },
      -1,
   } },

   /* replace506_0 -> 19 in the cache */
   /* replace506_1 -> 937 in the cache */
   /* replace506 -> 1539 in the cache */

   /* ('iand@16', 'a', ('inot', ('ishr', 'a', 15))) => ('imax', 'a', 0) */
   /* search507_0 -> 24 in the cache */
   /* search507_1_0_0 -> 24 in the cache */
   /* search507_1_0_1 -> 27 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ishr,
      -1, 0,
      { 24, 27 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_inot,
      -1, 0,
      { 1555 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_iand,
      0, 1,
      { 24, 1556 },
      -1,
   } },

   /* replace507_0 -> 24 in the cache */
   /* replace507_1 -> 958 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_imax,
      0, 1,
      { 24, 958 },
      -1,
   } },

   /* ('ieq', ('iand', 'a@16', 32768), 0) => ('ige', 'a', 0) */
   /* search508_0_0 -> 24 in the cache */
   /* search508_0_1 -> 25 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_iand,
      1, 1,
      { 24, 25 },
      -1,
   } },
   /* search508_1 -> 958 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ieq,
      0, 2,
      { 1559, 958 },
      -1,
   } },

   /* replace508_0 -> 24 in the cache */
   /* replace508_1 -> 958 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ige,
      -1, 0,
      { 24, 958 },
      -1,
   } },

   /* ('ine', ('iand', 'a@16', 32768), 32768) => ('ige', 'a', 0) */
   /* search509_0_0 -> 24 in the cache */
   /* search509_0_1 -> 25 in the cache */
   /* search509_0 -> 1559 in the cache */
   /* search509_1 -> 25 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ine,
      0, 2,
      { 1559, 25 },
      -1,
   } },

   /* replace509_0 -> 24 in the cache */
   /* replace509_1 -> 958 in the cache */
   /* replace509 -> 1561 in the cache */

   /* ('ine', ('iand', 'a@16', 32768), 0) => ('ilt', 'a', 0) */
   /* search510_0_0 -> 24 in the cache */
   /* search510_0_1 -> 25 in the cache */
   /* search510_0 -> 1559 in the cache */
   /* search510_1 -> 958 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ine,
      0, 2,
      { 1559, 958 },
      -1,
   } },

   /* replace510_0 -> 24 in the cache */
   /* replace510_1 -> 958 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ilt,
      -1, 0,
      { 24, 958 },
      -1,
   } },

   /* ('ieq', ('iand', 'a@16', 32768), 32768) => ('ilt', 'a', 0) */
   /* search511_0_0 -> 24 in the cache */
   /* search511_0_1 -> 25 in the cache */
   /* search511_0 -> 1559 in the cache */
   /* search511_1 -> 25 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ieq,
      0, 2,
      { 1559, 25 },
      -1,
   } },

   /* replace511_0 -> 24 in the cache */
   /* replace511_1 -> 958 in the cache */
   /* replace511 -> 1564 in the cache */

   /* ('ine', ('ushr', 'a@16', 15), 0) => ('ilt', 'a', 0) */
   /* search512_0_0 -> 24 in the cache */
   /* search512_0_1 -> 27 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ushr,
      -1, 0,
      { 24, 27 },
      -1,
   } },
   /* search512_1 -> 958 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ine,
      0, 1,
      { 1566, 958 },
      -1,
   } },

   /* replace512_0 -> 24 in the cache */
   /* replace512_1 -> 958 in the cache */
   /* replace512 -> 1564 in the cache */

   /* ('ieq', ('ushr', 'a@16', 15), 0) => ('ige', 'a', 0) */
   /* search513_0_0 -> 24 in the cache */
   /* search513_0_1 -> 27 in the cache */
   /* search513_0 -> 1566 in the cache */
   /* search513_1 -> 958 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ieq,
      0, 1,
      { 1566, 958 },
      -1,
   } },

   /* replace513_0 -> 24 in the cache */
   /* replace513_1 -> 958 in the cache */
   /* replace513 -> 1561 in the cache */

   /* ('ieq', ('ushr', 'a@16', 15), 1) => ('ilt', 'a', 0) */
   /* search514_0_0 -> 24 in the cache */
   /* search514_0_1 -> 27 in the cache */
   /* search514_0 -> 1566 in the cache */
   { .constant = {
      { nir_search_value_constant, 16 },
      nir_type_int, { 0x1ull /* 1 */ },
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ieq,
      0, 1,
      { 1566, 1569 },
      -1,
   } },

   /* replace514_0 -> 24 in the cache */
   /* replace514_1 -> 958 in the cache */
   /* replace514 -> 1564 in the cache */

   /* ('ine', ('ushr', 'a@16', 15), 1) => ('ige', 'a', 0) */
   /* search515_0_0 -> 24 in the cache */
   /* search515_0_1 -> 27 in the cache */
   /* search515_0 -> 1566 in the cache */
   /* search515_1 -> 1569 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ine,
      0, 1,
      { 1566, 1569 },
      -1,
   } },

   /* replace515_0 -> 24 in the cache */
   /* replace515_1 -> 958 in the cache */
   /* replace515 -> 1561 in the cache */

   /* ('ine', ('ishr', 'a@16', 15), 0) => ('ilt', 'a', 0) */
   /* search516_0_0 -> 24 in the cache */
   /* search516_0_1 -> 27 in the cache */
   /* search516_0 -> 1555 in the cache */
   /* search516_1 -> 958 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ine,
      0, 1,
      { 1555, 958 },
      -1,
   } },

   /* replace516_0 -> 24 in the cache */
   /* replace516_1 -> 958 in the cache */
   /* replace516 -> 1564 in the cache */

   /* ('ieq', ('ishr', 'a@16', 15), 0) => ('ige', 'a', 0) */
   /* search517_0_0 -> 24 in the cache */
   /* search517_0_1 -> 27 in the cache */
   /* search517_0 -> 1555 in the cache */
   /* search517_1 -> 958 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ieq,
      0, 1,
      { 1555, 958 },
      -1,
   } },

   /* replace517_0 -> 24 in the cache */
   /* replace517_1 -> 958 in the cache */
   /* replace517 -> 1561 in the cache */

   /* ('ieq', ('ishr', 'a@16', 15), -1) => ('ilt', 'a', 0) */
   /* search518_0_0 -> 24 in the cache */
   /* search518_0_1 -> 27 in the cache */
   /* search518_0 -> 1555 in the cache */
   { .constant = {
      { nir_search_value_constant, 16 },
      nir_type_int, { 0xffffffffffffffffull /* -1 */ },
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ieq,
      0, 1,
      { 1555, 1574 },
      -1,
   } },

   /* replace518_0 -> 24 in the cache */
   /* replace518_1 -> 958 in the cache */
   /* replace518 -> 1564 in the cache */

   /* ('ine', ('ishr', 'a@16', 15), -1) => ('ige', 'a', 0) */
   /* search519_0_0 -> 24 in the cache */
   /* search519_0_1 -> 27 in the cache */
   /* search519_0 -> 1555 in the cache */
   /* search519_1 -> 1574 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ine,
      0, 1,
      { 1555, 1574 },
      -1,
   } },

   /* replace519_0 -> 24 in the cache */
   /* replace519_1 -> 958 in the cache */
   /* replace519 -> 1561 in the cache */

   /* ('iand@32', 'a', ('inot', ('ishr', 'a', 31))) => ('imax', 'a', 0) */
   /* search520_0 -> 29 in the cache */
   /* search520_1_0_0 -> 29 in the cache */
   /* search520_1_0_1 -> 32 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ishr,
      -1, 0,
      { 29, 32 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_inot,
      -1, 0,
      { 1577 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_iand,
      0, 1,
      { 29, 1578 },
      -1,
   } },

   /* replace520_0 -> 29 in the cache */
   /* replace520_1 -> 135 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_imax,
      0, 1,
      { 29, 135 },
      -1,
   } },

   /* ('ieq', ('iand', 'a@32', 2147483648), 0) => ('ige', 'a', 0) */
   /* search521_0_0 -> 29 in the cache */
   /* search521_0_1 -> 30 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_iand,
      1, 1,
      { 29, 30 },
      -1,
   } },
   /* search521_1 -> 135 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ieq,
      0, 2,
      { 1581, 135 },
      -1,
   } },

   /* replace521_0 -> 29 in the cache */
   /* replace521_1 -> 135 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ige,
      -1, 0,
      { 29, 135 },
      -1,
   } },

   /* ('ine', ('iand', 'a@32', 2147483648), 2147483648) => ('ige', 'a', 0) */
   /* search522_0_0 -> 29 in the cache */
   /* search522_0_1 -> 30 in the cache */
   /* search522_0 -> 1581 in the cache */
   /* search522_1 -> 30 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ine,
      0, 2,
      { 1581, 30 },
      -1,
   } },

   /* replace522_0 -> 29 in the cache */
   /* replace522_1 -> 135 in the cache */
   /* replace522 -> 1583 in the cache */

   /* ('ine', ('iand', 'a@32', 2147483648), 0) => ('ilt', 'a', 0) */
   /* search523_0_0 -> 29 in the cache */
   /* search523_0_1 -> 30 in the cache */
   /* search523_0 -> 1581 in the cache */
   /* search523_1 -> 135 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ine,
      0, 2,
      { 1581, 135 },
      -1,
   } },

   /* replace523_0 -> 29 in the cache */
   /* replace523_1 -> 135 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ilt,
      -1, 0,
      { 29, 135 },
      -1,
   } },

   /* ('ieq', ('iand', 'a@32', 2147483648), 2147483648) => ('ilt', 'a', 0) */
   /* search524_0_0 -> 29 in the cache */
   /* search524_0_1 -> 30 in the cache */
   /* search524_0 -> 1581 in the cache */
   /* search524_1 -> 30 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ieq,
      0, 2,
      { 1581, 30 },
      -1,
   } },

   /* replace524_0 -> 29 in the cache */
   /* replace524_1 -> 135 in the cache */
   /* replace524 -> 1586 in the cache */

   /* ('ine', ('ushr', 'a@32', 31), 0) => ('ilt', 'a', 0) */
   /* search525_0_0 -> 29 in the cache */
   /* search525_0_1 -> 32 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ushr,
      -1, 0,
      { 29, 32 },
      -1,
   } },
   /* search525_1 -> 135 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ine,
      0, 1,
      { 1588, 135 },
      -1,
   } },

   /* replace525_0 -> 29 in the cache */
   /* replace525_1 -> 135 in the cache */
   /* replace525 -> 1586 in the cache */

   /* ('ieq', ('ushr', 'a@32', 31), 0) => ('ige', 'a', 0) */
   /* search526_0_0 -> 29 in the cache */
   /* search526_0_1 -> 32 in the cache */
   /* search526_0 -> 1588 in the cache */
   /* search526_1 -> 135 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ieq,
      0, 1,
      { 1588, 135 },
      -1,
   } },

   /* replace526_0 -> 29 in the cache */
   /* replace526_1 -> 135 in the cache */
   /* replace526 -> 1583 in the cache */

   /* ('ieq', ('ushr', 'a@32', 31), 1) => ('ilt', 'a', 0) */
   /* search527_0_0 -> 29 in the cache */
   /* search527_0_1 -> 32 in the cache */
   /* search527_0 -> 1588 in the cache */
   /* search527_1 -> 498 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ieq,
      0, 1,
      { 1588, 498 },
      -1,
   } },

   /* replace527_0 -> 29 in the cache */
   /* replace527_1 -> 135 in the cache */
   /* replace527 -> 1586 in the cache */

   /* ('ine', ('ushr', 'a@32', 31), 1) => ('ige', 'a', 0) */
   /* search528_0_0 -> 29 in the cache */
   /* search528_0_1 -> 32 in the cache */
   /* search528_0 -> 1588 in the cache */
   /* search528_1 -> 498 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ine,
      0, 1,
      { 1588, 498 },
      -1,
   } },

   /* replace528_0 -> 29 in the cache */
   /* replace528_1 -> 135 in the cache */
   /* replace528 -> 1583 in the cache */

   /* ('ine', ('ishr', 'a@32', 31), 0) => ('ilt', 'a', 0) */
   /* search529_0_0 -> 29 in the cache */
   /* search529_0_1 -> 32 in the cache */
   /* search529_0 -> 1577 in the cache */
   /* search529_1 -> 135 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ine,
      0, 1,
      { 1577, 135 },
      -1,
   } },

   /* replace529_0 -> 29 in the cache */
   /* replace529_1 -> 135 in the cache */
   /* replace529 -> 1586 in the cache */

   /* ('ieq', ('ishr', 'a@32', 31), 0) => ('ige', 'a', 0) */
   /* search530_0_0 -> 29 in the cache */
   /* search530_0_1 -> 32 in the cache */
   /* search530_0 -> 1577 in the cache */
   /* search530_1 -> 135 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ieq,
      0, 1,
      { 1577, 135 },
      -1,
   } },

   /* replace530_0 -> 29 in the cache */
   /* replace530_1 -> 135 in the cache */
   /* replace530 -> 1583 in the cache */

   /* ('ieq', ('ishr', 'a@32', 31), -1) => ('ilt', 'a', 0) */
   /* search531_0_0 -> 29 in the cache */
   /* search531_0_1 -> 32 in the cache */
   /* search531_0 -> 1577 in the cache */
   /* search531_1 -> 137 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ieq,
      0, 1,
      { 1577, 137 },
      -1,
   } },

   /* replace531_0 -> 29 in the cache */
   /* replace531_1 -> 135 in the cache */
   /* replace531 -> 1586 in the cache */

   /* ('ine', ('ishr', 'a@32', 31), -1) => ('ige', 'a', 0) */
   /* search532_0_0 -> 29 in the cache */
   /* search532_0_1 -> 32 in the cache */
   /* search532_0 -> 1577 in the cache */
   /* search532_1 -> 137 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ine,
      0, 1,
      { 1577, 137 },
      -1,
   } },

   /* replace532_0 -> 29 in the cache */
   /* replace532_1 -> 135 in the cache */
   /* replace532 -> 1583 in the cache */

   /* ('iand@64', 'a', ('inot', ('ishr', 'a', 63))) => ('imax', 'a', 0) */
   /* search533_0 -> 34 in the cache */
   /* search533_1_0_0 -> 34 in the cache */
   /* search533_1_0_1 -> 37 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ishr,
      -1, 0,
      { 34, 37 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_inot,
      -1, 0,
      { 1597 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_iand,
      0, 1,
      { 34, 1598 },
      -1,
   } },

   /* replace533_0 -> 34 in the cache */
   /* replace533_1 -> 999 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_imax,
      0, 1,
      { 34, 999 },
      -1,
   } },

   /* ('ieq', ('iand', 'a@64', 9223372036854775808), 0) => ('ige', 'a', 0) */
   /* search534_0_0 -> 34 in the cache */
   /* search534_0_1 -> 35 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_iand,
      1, 1,
      { 34, 35 },
      -1,
   } },
   /* search534_1 -> 999 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ieq,
      0, 2,
      { 1601, 999 },
      -1,
   } },

   /* replace534_0 -> 34 in the cache */
   /* replace534_1 -> 999 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ige,
      -1, 0,
      { 34, 999 },
      -1,
   } },

   /* ('ine', ('iand', 'a@64', 9223372036854775808), 9223372036854775808) => ('ige', 'a', 0) */
   /* search535_0_0 -> 34 in the cache */
   /* search535_0_1 -> 35 in the cache */
   /* search535_0 -> 1601 in the cache */
   /* search535_1 -> 35 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ine,
      0, 2,
      { 1601, 35 },
      -1,
   } },

   /* replace535_0 -> 34 in the cache */
   /* replace535_1 -> 999 in the cache */
   /* replace535 -> 1603 in the cache */

   /* ('ine', ('iand', 'a@64', 9223372036854775808), 0) => ('ilt', 'a', 0) */
   /* search536_0_0 -> 34 in the cache */
   /* search536_0_1 -> 35 in the cache */
   /* search536_0 -> 1601 in the cache */
   /* search536_1 -> 999 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ine,
      0, 2,
      { 1601, 999 },
      -1,
   } },

   /* replace536_0 -> 34 in the cache */
   /* replace536_1 -> 999 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ilt,
      -1, 0,
      { 34, 999 },
      -1,
   } },

   /* ('ieq', ('iand', 'a@64', 9223372036854775808), 9223372036854775808) => ('ilt', 'a', 0) */
   /* search537_0_0 -> 34 in the cache */
   /* search537_0_1 -> 35 in the cache */
   /* search537_0 -> 1601 in the cache */
   /* search537_1 -> 35 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ieq,
      0, 2,
      { 1601, 35 },
      -1,
   } },

   /* replace537_0 -> 34 in the cache */
   /* replace537_1 -> 999 in the cache */
   /* replace537 -> 1606 in the cache */

   /* ('ine', ('ushr', 'a@64', 63), 0) => ('ilt', 'a', 0) */
   /* search538_0_0 -> 34 in the cache */
   /* search538_0_1 -> 37 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ushr,
      -1, 0,
      { 34, 37 },
      -1,
   } },
   /* search538_1 -> 999 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ine,
      0, 1,
      { 1608, 999 },
      -1,
   } },

   /* replace538_0 -> 34 in the cache */
   /* replace538_1 -> 999 in the cache */
   /* replace538 -> 1606 in the cache */

   /* ('ieq', ('ushr', 'a@64', 63), 0) => ('ige', 'a', 0) */
   /* search539_0_0 -> 34 in the cache */
   /* search539_0_1 -> 37 in the cache */
   /* search539_0 -> 1608 in the cache */
   /* search539_1 -> 999 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ieq,
      0, 1,
      { 1608, 999 },
      -1,
   } },

   /* replace539_0 -> 34 in the cache */
   /* replace539_1 -> 999 in the cache */
   /* replace539 -> 1603 in the cache */

   /* ('ieq', ('ushr', 'a@64', 63), 1) => ('ilt', 'a', 0) */
   /* search540_0_0 -> 34 in the cache */
   /* search540_0_1 -> 37 in the cache */
   /* search540_0 -> 1608 in the cache */
   { .constant = {
      { nir_search_value_constant, 64 },
      nir_type_int, { 0x1ull /* 1 */ },
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ieq,
      0, 1,
      { 1608, 1611 },
      -1,
   } },

   /* replace540_0 -> 34 in the cache */
   /* replace540_1 -> 999 in the cache */
   /* replace540 -> 1606 in the cache */

   /* ('ine', ('ushr', 'a@64', 63), 1) => ('ige', 'a', 0) */
   /* search541_0_0 -> 34 in the cache */
   /* search541_0_1 -> 37 in the cache */
   /* search541_0 -> 1608 in the cache */
   /* search541_1 -> 1611 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ine,
      0, 1,
      { 1608, 1611 },
      -1,
   } },

   /* replace541_0 -> 34 in the cache */
   /* replace541_1 -> 999 in the cache */
   /* replace541 -> 1603 in the cache */

   /* ('ine', ('ishr', 'a@64', 63), 0) => ('ilt', 'a', 0) */
   /* search542_0_0 -> 34 in the cache */
   /* search542_0_1 -> 37 in the cache */
   /* search542_0 -> 1597 in the cache */
   /* search542_1 -> 999 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ine,
      0, 1,
      { 1597, 999 },
      -1,
   } },

   /* replace542_0 -> 34 in the cache */
   /* replace542_1 -> 999 in the cache */
   /* replace542 -> 1606 in the cache */

   /* ('ieq', ('ishr', 'a@64', 63), 0) => ('ige', 'a', 0) */
   /* search543_0_0 -> 34 in the cache */
   /* search543_0_1 -> 37 in the cache */
   /* search543_0 -> 1597 in the cache */
   /* search543_1 -> 999 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ieq,
      0, 1,
      { 1597, 999 },
      -1,
   } },

   /* replace543_0 -> 34 in the cache */
   /* replace543_1 -> 999 in the cache */
   /* replace543 -> 1603 in the cache */

   /* ('ieq', ('ishr', 'a@64', 63), -1) => ('ilt', 'a', 0) */
   /* search544_0_0 -> 34 in the cache */
   /* search544_0_1 -> 37 in the cache */
   /* search544_0 -> 1597 in the cache */
   { .constant = {
      { nir_search_value_constant, 64 },
      nir_type_int, { 0xffffffffffffffffull /* -1 */ },
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ieq,
      0, 1,
      { 1597, 1616 },
      -1,
   } },

   /* replace544_0 -> 34 in the cache */
   /* replace544_1 -> 999 in the cache */
   /* replace544 -> 1606 in the cache */

   /* ('ine', ('ishr', 'a@64', 63), -1) => ('ige', 'a', 0) */
   /* search545_0_0 -> 34 in the cache */
   /* search545_0_1 -> 37 in the cache */
   /* search545_0 -> 1597 in the cache */
   /* search545_1 -> 1616 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ine,
      0, 1,
      { 1597, 1616 },
      -1,
   } },

   /* replace545_0 -> 34 in the cache */
   /* replace545_1 -> 999 in the cache */
   /* replace545 -> 1603 in the cache */

   /* ('fmin', 'a', ('fneg', 'a')) => ('fneg', ('fabs', 'a')) */
   /* search546_0 -> 9 in the cache */
   /* search546_1_0 -> 9 in the cache */
   /* search546_1 -> 118 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fmin,
      0, 1,
      { 9, 118 },
      -1,
   } },

   /* replace546_0_0 -> 9 in the cache */
   /* replace546_0 -> 11 in the cache */
   /* replace546 -> 1387 in the cache */

   /* ('imin', 'a', ('ineg', 'a')) => ('ineg', ('iabs', 'a')) */
   /* search547_0 -> 9 in the cache */
   /* search547_1_0 -> 9 in the cache */
   /* search547_1 -> 120 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_imin,
      0, 1,
      { 9, 120 },
      -1,
   } },

   /* replace547_0_0 -> 9 in the cache */
   /* replace547_0 -> 125 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ineg,
      -1, 0,
      { 125 },
      -1,
   } },

   /* ('fmin', 'a', ('fneg', ('fabs', 'a'))) => ('fneg', ('fabs', 'a')) */
   /* search548_0 -> 9 in the cache */
   /* search548_1_0_0 -> 9 in the cache */
   /* search548_1_0 -> 11 in the cache */
   /* search548_1 -> 1387 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fmin,
      0, 1,
      { 9, 1387 },
      -1,
   } },

   /* replace548_0_0 -> 9 in the cache */
   /* replace548_0 -> 11 in the cache */
   /* replace548 -> 1387 in the cache */

   /* ('imin', 'a', ('ineg', ('iabs', 'a'))) => ('ineg', ('iabs', 'a')) */
   /* search549_0 -> 9 in the cache */
   /* search549_1_0_0 -> 9 in the cache */
   /* search549_1_0 -> 125 in the cache */
   /* search549_1 -> 1621 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_imin,
      0, 1,
      { 9, 1621 },
      -1,
   } },

   /* replace549_0_0 -> 9 in the cache */
   /* replace549_0 -> 125 in the cache */
   /* replace549 -> 1621 in the cache */

   /* ('~fmin', 'a', ('fabs', 'a')) => a */
   /* search550_0 -> 9 in the cache */
   /* search550_1_0 -> 9 in the cache */
   /* search550_1 -> 11 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      true,
      false,
      false,
      false,
      false,
      false,
      nir_op_fmin,
      0, 1,
      { 9, 11 },
      -1,
   } },

   /* replace550 -> 9 in the cache */

   /* ('imin', 'a', ('iabs', 'a')) => a */
   /* search551_0 -> 9 in the cache */
   /* search551_1_0 -> 9 in the cache */
   /* search551_1 -> 125 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_imin,
      0, 1,
      { 9, 125 },
      -1,
   } },

   /* replace551 -> 9 in the cache */

   /* ('~fmax', 'a', ('fneg', ('fabs', 'a'))) => a */
   /* search552_0 -> 9 in the cache */
   /* search552_1_0_0 -> 9 in the cache */
   /* search552_1_0 -> 11 in the cache */
   /* search552_1 -> 1387 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      true,
      false,
      false,
      false,
      false,
      false,
      nir_op_fmax,
      0, 1,
      { 9, 1387 },
      -1,
   } },

   /* replace552 -> 9 in the cache */

   /* ('imax', 'a', ('ineg', ('iabs', 'a'))) => a */
   /* search553_0 -> 9 in the cache */
   /* search553_1_0_0 -> 9 in the cache */
   /* search553_1_0 -> 125 in the cache */
   /* search553_1 -> 1621 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_imax,
      0, 1,
      { 9, 1621 },
      -1,
   } },

   /* replace553 -> 9 in the cache */

   /* ('fmax', 'a', ('fabs', 'a')) => ('fabs', 'a') */
   /* search554_0 -> 9 in the cache */
   /* search554_1_0 -> 9 in the cache */
   /* search554_1 -> 11 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fmax,
      0, 1,
      { 9, 11 },
      -1,
   } },

   /* replace554_0 -> 9 in the cache */
   /* replace554 -> 11 in the cache */

   /* ('imax', 'a', ('iabs', 'a')) => ('iabs', 'a') */
   /* search555_0 -> 9 in the cache */
   /* search555_1_0 -> 9 in the cache */
   /* search555_1 -> 125 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_imax,
      0, 1,
      { 9, 125 },
      -1,
   } },

   /* replace555_0 -> 9 in the cache */
   /* replace555 -> 125 in the cache */

   /* ('fmax', 'a', ('fneg', 'a')) => ('fabs', 'a') */
   /* search556_0 -> 9 in the cache */
   /* search556_1_0 -> 9 in the cache */
   /* search556_1 -> 118 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fmax,
      0, 1,
      { 9, 118 },
      -1,
   } },

   /* replace556_0 -> 9 in the cache */
   /* replace556 -> 11 in the cache */

   /* ('imax', 'a', ('ineg', 'a')) => ('iabs', 'a') */
   /* search557_0 -> 9 in the cache */
   /* search557_1_0 -> 9 in the cache */
   /* search557_1 -> 120 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_imax,
      0, 1,
      { 9, 120 },
      -1,
   } },

   /* replace557_0 -> 9 in the cache */
   /* replace557 -> 125 in the cache */

   /* ('~fmax', ('fabs', 'a'), 0.0) => ('fabs', 'a') */
   /* search558_0_0 -> 9 in the cache */
   /* search558_0 -> 11 in the cache */
   /* search558_1 -> 8 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      true,
      false,
      false,
      false,
      false,
      false,
      nir_op_fmax,
      0, 1,
      { 11, 8 },
      -1,
   } },

   /* replace558_0 -> 9 in the cache */
   /* replace558 -> 11 in the cache */

   /* ('fmin', ('fmax', 'a', 0.0), 1.0) => ('fsat', 'a') */
   /* search559_0_0 -> 9 in the cache */
   /* search559_0_1 -> 8 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fmax,
      1, 1,
      { 9, 8 },
      -1,
   } },
   /* search559_1 -> 259 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fmin,
      0, 2,
      { 1633, 259 },
      -1,
   } },

   /* replace559_0 -> 9 in the cache */
   /* replace559 -> 235 in the cache */

   /* ('~fmax', ('fmin', 'a', 1.0), 0.0) => ('fsat', 'a') */
   /* search560_0_0 -> 9 in the cache */
   /* search560_0_1 -> 259 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fmin,
      1, 1,
      { 9, 259 },
      -1,
   } },
   /* search560_1 -> 8 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      true,
      false,
      false,
      false,
      false,
      false,
      nir_op_fmax,
      0, 2,
      { 1635, 8 },
      -1,
   } },

   /* replace560_0 -> 9 in the cache */
   /* replace560 -> 235 in the cache */

   /* ('~fmin', ('fmax', 'a', -1.0), 0.0) => ('fneg', ('fsat', ('fneg', 'a'))) */
   /* search561_0_0 -> 9 in the cache */
   /* search561_0_1 -> 265 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fmax,
      1, 1,
      { 9, 265 },
      -1,
   } },
   /* search561_1 -> 8 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      true,
      false,
      false,
      false,
      false,
      false,
      nir_op_fmin,
      0, 2,
      { 1637, 8 },
      -1,
   } },

   /* replace561_0_0_0 -> 9 in the cache */
   /* replace561_0_0 -> 118 in the cache */
   /* replace561_0 -> 236 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fneg,
      -1, 0,
      { 236 },
      -1,
   } },

   /* ('~fmax', ('fmin', 'a', 0.0), -1.0) => ('fneg', ('fsat', ('fneg', 'a'))) */
   /* search562_0_0 -> 9 in the cache */
   /* search562_0_1 -> 8 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fmin,
      1, 1,
      { 9, 8 },
      -1,
   } },
   /* search562_1 -> 265 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      true,
      false,
      false,
      false,
      false,
      false,
      nir_op_fmax,
      0, 2,
      { 1640, 265 },
      -1,
   } },

   /* replace562_0_0_0 -> 9 in the cache */
   /* replace562_0_0 -> 118 in the cache */
   /* replace562_0 -> 236 in the cache */
   /* replace562 -> 1639 in the cache */

   /* ('fsat', ('fsign', 'a')) => ('b2f', ('!flt', 0.0, 'a')) */
   /* search563_0_0 -> 9 in the cache */
   /* search563_0 -> 110 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fsat,
      -1, 0,
      { 110 },
      -1,
   } },

   /* replace563_0_0 -> 8 in the cache */
   /* replace563_0_1 -> 9 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      true,
      false,
      false,
      false,
      false,
      nir_op_flt,
      -1, 0,
      { 8, 9 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_search_op_b2f,
      -1, 0,
      { 1643 },
      -1,
   } },

   /* ('fsat', ('b2f', 'a')) => ('b2f', 'a') */
   /* search564_0_0 -> 9 in the cache */
   { .expression = {
      { nir_search_value_expression, 0 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_search_op_b2f,
      -1, 0,
      { 9 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 0 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fsat,
      -1, 0,
      { 1645 },
      -1,
   } },

   /* replace564_0 -> 9 in the cache */
   /* replace564 -> 1645 in the cache */

   /* ('fsat', 'a') => ('fmin', ('fmax', 'a', 0.0), 1.0) */
   /* search565_0 -> 9 in the cache */
   /* search565 -> 235 in the cache */

   /* replace565_0_0 -> 9 in the cache */
   /* replace565_0_1 -> 8 in the cache */
   /* replace565_0 -> 1633 in the cache */
   /* replace565_1 -> 259 in the cache */
   /* replace565 -> 1634 in the cache */

   /* ('fsat', ('fsat', 'a')) => ('fsat', 'a') */
   /* search566_0_0 -> 9 in the cache */
   /* search566_0 -> 235 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fsat,
      -1, 0,
      { 235 },
      -1,
   } },

   /* replace566_0 -> 9 in the cache */
   /* replace566 -> 235 in the cache */

   /* ('fsat', ('fneg(is_used_once)', ('fadd(is_used_once)', 'a', 'b'))) => ('fsat', ('fadd', ('fneg', 'a'), ('fneg', 'b'))) */
   /* search567_0_0_0 -> 0 in the cache */
   /* search567_0_0_1 -> 1 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fadd,
      0, 1,
      { 0, 1 },
      0,
   } },
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fneg,
      -1, 1,
      { 1648 },
      0,
   } },
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fsat,
      -1, 1,
      { 1649 },
      -1,
   } },

   /* replace567_0_0_0 -> 0 in the cache */
   /* replace567_0_0 -> 230 in the cache */
   /* replace567_0_1_0 -> 1 in the cache */
   /* replace567_0_1 -> 1187 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fadd,
      0, 1,
      { 230, 1187 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fsat,
      -1, 1,
      { 1651 },
      -1,
   } },

   /* ('fsat', ('fneg(is_used_once)', ('fmul(is_used_once)', 'a', 'b'))) => ('fsat', ('fmul', ('fneg', 'a'), 'b')) */
   /* search568_0_0_0 -> 0 in the cache */
   /* search568_0_0_1 -> 1 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fmul,
      0, 1,
      { 0, 1 },
      0,
   } },
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fneg,
      -1, 1,
      { 1653 },
      0,
   } },
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fsat,
      -1, 1,
      { 1654 },
      -1,
   } },

   /* replace568_0_0_0 -> 0 in the cache */
   /* replace568_0_0 -> 230 in the cache */
   /* replace568_0_1 -> 1 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fmul,
      0, 1,
      { 230, 1 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fsat,
      -1, 1,
      { 1656 },
      -1,
   } },

   /* ('fsat(nsz)', ('fneg(is_used_once)', ('fmulz(is_used_once)', 'a', 'b'))) => ('fsat', ('fmulz', ('fneg', 'a'), 'b')) */
   /* search569_0_0_0 -> 29 in the cache */
   /* search569_0_0_1 -> 48 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fmulz,
      0, 1,
      { 29, 48 },
      0,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fneg,
      -1, 1,
      { 1658 },
      0,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      true,
      false,
      false,
      nir_op_fsat,
      -1, 1,
      { 1659 },
      -1,
   } },

   /* replace569_0_0_0 -> 29 in the cache */
   /* replace569_0_0 -> 293 in the cache */
   /* replace569_0_1 -> 48 in the cache */
   /* replace569_0 -> 433 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fsat,
      -1, 1,
      { 433 },
      -1,
   } },

   /* ('fsat', ('fabs(is_used_once)', ('fmul(is_used_once)', 'a', 'b'))) => ('fsat', ('fmul', ('fabs', 'a'), ('fabs', 'b'))) */
   /* search570_0_0_0 -> 0 in the cache */
   /* search570_0_0_1 -> 1 in the cache */
   /* search570_0_0 -> 1653 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fabs,
      -1, 1,
      { 1653 },
      0,
   } },
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fsat,
      -1, 1,
      { 1662 },
      -1,
   } },

   /* replace570_0_0_0 -> 0 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fabs,
      -1, 0,
      { 0 },
      -1,
   } },
   /* replace570_0_1_0 -> 1 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fabs,
      -1, 0,
      { 1 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fmul,
      0, 1,
      { 1664, 1665 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fsat,
      -1, 1,
      { 1666 },
      -1,
   } },

   /* ('fmin', ('fmax', ('fmin', ('fmax', 'a', 'b'), 'c'), 'b'), 'c') => ('fmin', ('fmax', 'a', 'b'), 'c') */
   /* search571_0_0_0_0 -> 139 in the cache */
   /* search571_0_0_0_1 -> 140 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fmax,
      3, 1,
      { 139, 140 },
      -1,
   } },
   /* search571_0_0_1 -> 142 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fmin,
      2, 2,
      { 1668, 142 },
      -1,
   } },
   /* search571_0_1 -> 140 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fmax,
      1, 3,
      { 1669, 140 },
      -1,
   } },
   /* search571_1 -> 142 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fmin,
      0, 4,
      { 1670, 142 },
      -1,
   } },

   /* replace571_0_0 -> 139 in the cache */
   /* replace571_0_1 -> 140 in the cache */
   /* replace571_0 -> 1477 in the cache */
   /* replace571_1 -> 142 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fmin,
      0, 2,
      { 1477, 142 },
      -1,
   } },

   /* ('imin', ('imax', ('imin', ('imax', 'a', 'b'), 'c'), 'b'), 'c') => ('imin', ('imax', 'a', 'b'), 'c') */
   /* search572_0_0_0_0 -> 139 in the cache */
   /* search572_0_0_0_1 -> 140 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_imax,
      3, 1,
      { 139, 140 },
      -1,
   } },
   /* search572_0_0_1 -> 142 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_imin,
      2, 2,
      { 1673, 142 },
      -1,
   } },
   /* search572_0_1 -> 140 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_imax,
      1, 3,
      { 1674, 140 },
      -1,
   } },
   /* search572_1 -> 142 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_imin,
      0, 4,
      { 1675, 142 },
      -1,
   } },

   /* replace572_0_0 -> 139 in the cache */
   /* replace572_0_1 -> 140 in the cache */
   /* replace572_0 -> 1487 in the cache */
   /* replace572_1 -> 142 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_imin,
      0, 2,
      { 1487, 142 },
      -1,
   } },

   /* ('umin', ('umax', ('umin', ('umax', 'a', 'b'), 'c'), 'b'), 'c') => ('umin', ('umax', 'a', 'b'), 'c') */
   /* search573_0_0_0_0 -> 139 in the cache */
   /* search573_0_0_0_1 -> 140 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_umax,
      3, 1,
      { 139, 140 },
      -1,
   } },
   /* search573_0_0_1 -> 142 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_umin,
      2, 2,
      { 1678, 142 },
      -1,
   } },
   /* search573_0_1 -> 140 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_umax,
      1, 3,
      { 1679, 140 },
      -1,
   } },
   /* search573_1 -> 142 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_umin,
      0, 4,
      { 1680, 142 },
      -1,
   } },

   /* replace573_0_0 -> 139 in the cache */
   /* replace573_0_1 -> 140 in the cache */
   /* replace573_0 -> 1482 in the cache */
   /* replace573_1 -> 142 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_umin,
      0, 2,
      { 1482, 142 },
      -1,
   } },

   /* ('fmax', ('fsat', 'a'), '#b(is_zero_to_one)') => ('fsat', ('fmax', 'a', 'b')) */
   /* search574_0_0 -> 0 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fsat,
      -1, 0,
      { 0 },
      -1,
   } },
   { .variable = {
      { nir_search_value_variable, -2 },
      1, /* b */
      true,
      nir_type_invalid,
      19,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fmax,
      0, 1,
      { 1683, 1684 },
      -1,
   } },

   /* replace574_0_0 -> 0 in the cache */
   /* replace574_0_1 -> 1 in the cache */
   /* replace574_0 -> 1414 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fsat,
      -1, 1,
      { 1414 },
      -1,
   } },

   /* ('fmax', ('fsat(is_used_once)', 'a'), ('fsat(is_used_once)', 'b')) => ('fsat', ('fmax', 'a', 'b')) */
   /* search575_0_0 -> 0 in the cache */
   /* search575_0 -> 1247 in the cache */
   /* search575_1_0 -> 1 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fsat,
      -1, 0,
      { 1 },
      0,
   } },
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fmax,
      0, 1,
      { 1247, 1687 },
      -1,
   } },

   /* replace575_0_0 -> 0 in the cache */
   /* replace575_0_1 -> 1 in the cache */
   /* replace575_0 -> 1414 in the cache */
   /* replace575 -> 1686 in the cache */

   /* ('~fmin', ('fsat', 'a'), '#b(is_zero_to_one)') => ('fsat', ('fmin', 'a', 'b')) */
   /* search576_0_0 -> 0 in the cache */
   /* search576_0 -> 1683 in the cache */
   /* search576_1 -> 1684 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      true,
      false,
      false,
      false,
      false,
      false,
      nir_op_fmin,
      0, 1,
      { 1683, 1684 },
      -1,
   } },

   /* replace576_0_0 -> 0 in the cache */
   /* replace576_0_1 -> 1 in the cache */
   /* replace576_0 -> 1416 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fsat,
      -1, 1,
      { 1416 },
      -1,
   } },

   /* ('fmax', ('fneg', ('fmin', 'b', 'a')), 'b') => ('fmax', ('fabs', 'b'), ('fneg', 'a')) */
   /* search577_0_0_0 -> 1204 in the cache */
   /* search577_0_0_1 -> 1203 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fmin,
      1, 1,
      { 1204, 1203 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fneg,
      -1, 1,
      { 1691 },
      -1,
   } },
   /* search577_1 -> 1204 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fmax,
      0, 2,
      { 1692, 1204 },
      -1,
   } },

   /* replace577_0_0 -> 1204 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fabs,
      -1, 0,
      { 1204 },
      -1,
   } },
   /* replace577_1_0 -> 1203 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fneg,
      -1, 0,
      { 1203 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fmax,
      0, 1,
      { 1694, 1695 },
      -1,
   } },

   /* ('fmin', ('fneg', ('fmax', 'b', 'a')), 'b') => ('fmin', ('fneg', ('fabs', 'b')), ('fneg', 'a')) */
   /* search578_0_0_0 -> 1204 in the cache */
   /* search578_0_0_1 -> 1203 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fmax,
      1, 1,
      { 1204, 1203 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fneg,
      -1, 1,
      { 1697 },
      -1,
   } },
   /* search578_1 -> 1204 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fmin,
      0, 2,
      { 1698, 1204 },
      -1,
   } },

   /* replace578_0_0_0 -> 1204 in the cache */
   /* replace578_0_0 -> 1694 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fneg,
      -1, 0,
      { 1694 },
      -1,
   } },
   /* replace578_1_0 -> 1203 in the cache */
   /* replace578_1 -> 1695 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fmin,
      0, 1,
      { 1700, 1695 },
      -1,
   } },

   /* ('fmax', ('fadd(is_used_once)', ('fneg', 'a(is_not_negative)'), '#b(is_zero_to_one)'), 0.0) => ('fsat', ('fadd', ('fneg', 'a'), 'b')) */
   { .variable = {
      { nir_search_value_variable, -2 },
      0, /* a */
      false,
      nir_type_invalid,
      20,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fneg,
      -1, 0,
      { 1702 },
      -1,
   } },
   /* search579_0_1 -> 1684 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fadd,
      1, 1,
      { 1703, 1684 },
      0,
   } },
   /* search579_1 -> 273 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fmax,
      0, 2,
      { 1704, 273 },
      -1,
   } },

   /* replace579_0_0_0 -> 0 in the cache */
   /* replace579_0_0 -> 230 in the cache */
   /* replace579_0_1 -> 1 in the cache */
   /* replace579_0 -> 290 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fsat,
      -1, 1,
      { 290 },
      -1,
   } },

   /* ('extract_u8', ('imin', ('imax', 'a', 0), 255), 0) => ('imin', ('imax', 'a', 0), 255) */
   /* search580_0_0_0 -> 9 in the cache */
   /* search580_0_0_1 -> 73 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_imax,
      1, 1,
      { 9, 73 },
      -1,
   } },
   { .constant = {
      { nir_search_value_constant, -1 },
      nir_type_int, { 0xffull /* 255 */ },
   } },
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_imin,
      0, 2,
      { 1707, 1708 },
      -1,
   } },
   /* search580_1 -> 73 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_extract_u8,
      -1, 2,
      { 1709, 73 },
      -1,
   } },

   /* replace580_0_0 -> 9 in the cache */
   /* replace580_0_1 -> 73 in the cache */
   /* replace580_0 -> 1707 in the cache */
   /* replace580_1 -> 1708 in the cache */
   /* replace580 -> 1709 in the cache */

   /* ('ior', ('flt(is_used_once)', 'a', 'b'), ('flt', 'a', 'c')) => ('flt', 'a', ('!fmax', 'b', 'c')) */
   /* search581_0_0 -> 139 in the cache */
   /* search581_0_1 -> 140 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_flt,
      -1, 0,
      { 139, 140 },
      0,
   } },
   /* search581_1_0 -> 139 in the cache */
   /* search581_1_1 -> 142 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_flt,
      -1, 0,
      { 139, 142 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ior,
      0, 1,
      { 1711, 1712 },
      -1,
   } },

   /* replace581_0 -> 139 in the cache */
   /* replace581_1_0 -> 140 in the cache */
   /* replace581_1_1 -> 142 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      true,
      false,
      false,
      false,
      false,
      nir_op_fmax,
      0, 1,
      { 140, 142 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_flt,
      -1, 1,
      { 139, 1714 },
      -1,
   } },

   /* ('ior', ('flt(is_used_once)', 'a', 'c'), ('flt', 'b', 'c')) => ('flt', ('!fmin', 'a', 'b'), 'c') */
   /* search582_0_0 -> 0 in the cache */
   /* search582_0_1 -> 783 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_flt,
      -1, 0,
      { 0, 783 },
      0,
   } },
   { .variable = {
      { nir_search_value_variable, -2 },
      2, /* b */
      false,
      nir_type_invalid,
      -1,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   /* search582_1_1 -> 783 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_flt,
      -1, 0,
      { 1717, 783 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ior,
      0, 1,
      { 1716, 1718 },
      -1,
   } },

   /* replace582_0_0 -> 0 in the cache */
   /* replace582_0_1 -> 1717 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      true,
      false,
      false,
      false,
      false,
      nir_op_fmin,
      0, 1,
      { 0, 1717 },
      -1,
   } },
   /* replace582_1 -> 783 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_flt,
      -1, 1,
      { 1720, 783 },
      -1,
   } },

   /* ('ior', ('fge(is_used_once)', 'a', 'b'), ('fge', 'a', 'c')) => ('fge', 'a', ('!fmin', 'b', 'c')) */
   /* search583_0_0 -> 139 in the cache */
   /* search583_0_1 -> 140 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fge,
      -1, 0,
      { 139, 140 },
      0,
   } },
   /* search583_1_0 -> 139 in the cache */
   /* search583_1_1 -> 142 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fge,
      -1, 0,
      { 139, 142 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ior,
      0, 1,
      { 1722, 1723 },
      -1,
   } },

   /* replace583_0 -> 139 in the cache */
   /* replace583_1_0 -> 140 in the cache */
   /* replace583_1_1 -> 142 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      true,
      false,
      false,
      false,
      false,
      nir_op_fmin,
      0, 1,
      { 140, 142 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fge,
      -1, 1,
      { 139, 1725 },
      -1,
   } },

   /* ('ior', ('fge(is_used_once)', 'a', 'c'), ('fge', 'b', 'c')) => ('fge', ('!fmax', 'a', 'b'), 'c') */
   /* search584_0_0 -> 0 in the cache */
   /* search584_0_1 -> 783 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fge,
      -1, 0,
      { 0, 783 },
      0,
   } },
   /* search584_1_0 -> 1717 in the cache */
   /* search584_1_1 -> 783 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fge,
      -1, 0,
      { 1717, 783 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ior,
      0, 1,
      { 1727, 1728 },
      -1,
   } },

   /* replace584_0_0 -> 0 in the cache */
   /* replace584_0_1 -> 1717 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      true,
      false,
      false,
      false,
      false,
      nir_op_fmax,
      0, 1,
      { 0, 1717 },
      -1,
   } },
   /* replace584_1 -> 783 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fge,
      -1, 1,
      { 1730, 783 },
      -1,
   } },

   /* ('ior', ('flt', 'a', '#b'), ('flt', 'a', '#c')) => ('flt', 'a', ('!fmax', 'b', 'c')) */
   /* search585_0_0 -> 139 in the cache */
   /* search585_0_1 -> 296 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_flt,
      -1, 0,
      { 139, 296 },
      -1,
   } },
   /* search585_1_0 -> 139 in the cache */
   /* search585_1_1 -> 916 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_flt,
      -1, 0,
      { 139, 916 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ior,
      0, 1,
      { 1732, 1733 },
      -1,
   } },

   /* replace585_0 -> 139 in the cache */
   /* replace585_1_0 -> 140 in the cache */
   /* replace585_1_1 -> 142 in the cache */
   /* replace585_1 -> 1714 in the cache */
   /* replace585 -> 1715 in the cache */

   /* ('ior', ('flt', '#a', 'c'), ('flt', '#b', 'c')) => ('flt', ('!fmin', 'a', 'b'), 'c') */
   { .variable = {
      { nir_search_value_variable, -2 },
      0, /* a */
      true,
      nir_type_invalid,
      -1,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   /* search586_0_1 -> 783 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_flt,
      -1, 0,
      { 1735, 783 },
      -1,
   } },
   { .variable = {
      { nir_search_value_variable, -2 },
      2, /* b */
      true,
      nir_type_invalid,
      -1,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   /* search586_1_1 -> 783 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_flt,
      -1, 0,
      { 1737, 783 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ior,
      0, 1,
      { 1736, 1738 },
      -1,
   } },

   /* replace586_0_0 -> 0 in the cache */
   /* replace586_0_1 -> 1717 in the cache */
   /* replace586_0 -> 1720 in the cache */
   /* replace586_1 -> 783 in the cache */
   /* replace586 -> 1721 in the cache */

   /* ('ior', ('fge', 'a', '#b'), ('fge', 'a', '#c')) => ('fge', 'a', ('!fmin', 'b', 'c')) */
   /* search587_0_0 -> 139 in the cache */
   /* search587_0_1 -> 296 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fge,
      -1, 0,
      { 139, 296 },
      -1,
   } },
   /* search587_1_0 -> 139 in the cache */
   /* search587_1_1 -> 916 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fge,
      -1, 0,
      { 139, 916 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ior,
      0, 1,
      { 1740, 1741 },
      -1,
   } },

   /* replace587_0 -> 139 in the cache */
   /* replace587_1_0 -> 140 in the cache */
   /* replace587_1_1 -> 142 in the cache */
   /* replace587_1 -> 1725 in the cache */
   /* replace587 -> 1726 in the cache */

   /* ('ior', ('fge', '#a', 'c'), ('fge', '#b', 'c')) => ('fge', ('!fmax', 'a', 'b'), 'c') */
   /* search588_0_0 -> 1735 in the cache */
   /* search588_0_1 -> 783 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fge,
      -1, 0,
      { 1735, 783 },
      -1,
   } },
   /* search588_1_0 -> 1737 in the cache */
   /* search588_1_1 -> 783 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fge,
      -1, 0,
      { 1737, 783 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ior,
      0, 1,
      { 1743, 1744 },
      -1,
   } },

   /* replace588_0_0 -> 0 in the cache */
   /* replace588_0_1 -> 1717 in the cache */
   /* replace588_0 -> 1730 in the cache */
   /* replace588_1 -> 783 in the cache */
   /* replace588 -> 1731 in the cache */

   /* ('~iand', ('flt(is_used_once)', 'a', 'b'), ('flt', 'a', 'c')) => ('flt', 'a', ('fmin', 'b', 'c')) */
   /* search589_0_0 -> 139 in the cache */
   /* search589_0_1 -> 140 in the cache */
   /* search589_0 -> 1711 in the cache */
   /* search589_1_0 -> 139 in the cache */
   /* search589_1_1 -> 142 in the cache */
   /* search589_1 -> 1712 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      true,
      false,
      false,
      false,
      false,
      false,
      nir_op_iand,
      0, 1,
      { 1711, 1712 },
      -1,
   } },

   /* replace589_0 -> 139 in the cache */
   /* replace589_1_0 -> 140 in the cache */
   /* replace589_1_1 -> 142 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fmin,
      0, 1,
      { 140, 142 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_flt,
      -1, 1,
      { 139, 1747 },
      -1,
   } },

   /* ('~iand', ('flt(is_used_once)', 'a', 'c'), ('flt', 'b', 'c')) => ('flt', ('fmax', 'a', 'b'), 'c') */
   /* search590_0_0 -> 0 in the cache */
   /* search590_0_1 -> 783 in the cache */
   /* search590_0 -> 1716 in the cache */
   /* search590_1_0 -> 1717 in the cache */
   /* search590_1_1 -> 783 in the cache */
   /* search590_1 -> 1718 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      true,
      false,
      false,
      false,
      false,
      false,
      nir_op_iand,
      0, 1,
      { 1716, 1718 },
      -1,
   } },

   /* replace590_0_0 -> 0 in the cache */
   /* replace590_0_1 -> 1717 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fmax,
      0, 1,
      { 0, 1717 },
      -1,
   } },
   /* replace590_1 -> 783 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_flt,
      -1, 1,
      { 1750, 783 },
      -1,
   } },

   /* ('~iand', ('fge(is_used_once)', 'a', 'b'), ('fge', 'a', 'c')) => ('fge', 'a', ('fmax', 'b', 'c')) */
   /* search591_0_0 -> 139 in the cache */
   /* search591_0_1 -> 140 in the cache */
   /* search591_0 -> 1722 in the cache */
   /* search591_1_0 -> 139 in the cache */
   /* search591_1_1 -> 142 in the cache */
   /* search591_1 -> 1723 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      true,
      false,
      false,
      false,
      false,
      false,
      nir_op_iand,
      0, 1,
      { 1722, 1723 },
      -1,
   } },

   /* replace591_0 -> 139 in the cache */
   /* replace591_1_0 -> 140 in the cache */
   /* replace591_1_1 -> 142 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fmax,
      0, 1,
      { 140, 142 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fge,
      -1, 1,
      { 139, 1753 },
      -1,
   } },

   /* ('~iand', ('fge(is_used_once)', 'a', 'c'), ('fge', 'b', 'c')) => ('fge', ('fmin', 'a', 'b'), 'c') */
   /* search592_0_0 -> 0 in the cache */
   /* search592_0_1 -> 783 in the cache */
   /* search592_0 -> 1727 in the cache */
   /* search592_1_0 -> 1717 in the cache */
   /* search592_1_1 -> 783 in the cache */
   /* search592_1 -> 1728 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      true,
      false,
      false,
      false,
      false,
      false,
      nir_op_iand,
      0, 1,
      { 1727, 1728 },
      -1,
   } },

   /* replace592_0_0 -> 0 in the cache */
   /* replace592_0_1 -> 1717 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fmin,
      0, 1,
      { 0, 1717 },
      -1,
   } },
   /* replace592_1 -> 783 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fge,
      -1, 1,
      { 1756, 783 },
      -1,
   } },

   /* ('iand', ('flt', 'a', '#b(is_a_number)'), ('flt', 'a', '#c(is_a_number)')) => ('flt', 'a', ('fmin', 'b', 'c')) */
   /* search593_0_0 -> 139 in the cache */
   { .variable = {
      { nir_search_value_variable, -3 },
      1, /* b */
      true,
      nir_type_invalid,
      16,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_flt,
      -1, 0,
      { 139, 1758 },
      -1,
   } },
   /* search593_1_0 -> 139 in the cache */
   { .variable = {
      { nir_search_value_variable, -3 },
      2, /* c */
      true,
      nir_type_invalid,
      16,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_flt,
      -1, 0,
      { 139, 1760 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_iand,
      0, 1,
      { 1759, 1761 },
      -1,
   } },

   /* replace593_0 -> 139 in the cache */
   /* replace593_1_0 -> 140 in the cache */
   /* replace593_1_1 -> 142 in the cache */
   /* replace593_1 -> 1747 in the cache */
   /* replace593 -> 1748 in the cache */

   /* ('iand', ('flt', '#a(is_a_number)', 'c'), ('flt', '#b(is_a_number)', 'c')) => ('flt', ('fmax', 'a', 'b'), 'c') */
   { .variable = {
      { nir_search_value_variable, -2 },
      0, /* a */
      true,
      nir_type_invalid,
      16,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   /* search594_0_1 -> 783 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_flt,
      -1, 0,
      { 1763, 783 },
      -1,
   } },
   { .variable = {
      { nir_search_value_variable, -2 },
      2, /* b */
      true,
      nir_type_invalid,
      16,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   /* search594_1_1 -> 783 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_flt,
      -1, 0,
      { 1765, 783 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_iand,
      0, 1,
      { 1764, 1766 },
      -1,
   } },

   /* replace594_0_0 -> 0 in the cache */
   /* replace594_0_1 -> 1717 in the cache */
   /* replace594_0 -> 1750 in the cache */
   /* replace594_1 -> 783 in the cache */
   /* replace594 -> 1751 in the cache */

   /* ('iand', ('fge', 'a', '#b(is_a_number)'), ('fge', 'a', '#c(is_a_number)')) => ('fge', 'a', ('fmax', 'b', 'c')) */
   /* search595_0_0 -> 139 in the cache */
   /* search595_0_1 -> 1758 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fge,
      -1, 0,
      { 139, 1758 },
      -1,
   } },
   /* search595_1_0 -> 139 in the cache */
   /* search595_1_1 -> 1760 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fge,
      -1, 0,
      { 139, 1760 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_iand,
      0, 1,
      { 1768, 1769 },
      -1,
   } },

   /* replace595_0 -> 139 in the cache */
   /* replace595_1_0 -> 140 in the cache */
   /* replace595_1_1 -> 142 in the cache */
   /* replace595_1 -> 1753 in the cache */
   /* replace595 -> 1754 in the cache */

   /* ('iand', ('fge', '#a(is_a_number)', 'c'), ('fge', '#b(is_a_number)', 'c')) => ('fge', ('fmin', 'a', 'b'), 'c') */
   /* search596_0_0 -> 1763 in the cache */
   /* search596_0_1 -> 783 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fge,
      -1, 0,
      { 1763, 783 },
      -1,
   } },
   /* search596_1_0 -> 1765 in the cache */
   /* search596_1_1 -> 783 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fge,
      -1, 0,
      { 1765, 783 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_iand,
      0, 1,
      { 1771, 1772 },
      -1,
   } },

   /* replace596_0_0 -> 0 in the cache */
   /* replace596_0_1 -> 1717 in the cache */
   /* replace596_0 -> 1756 in the cache */
   /* replace596_1 -> 783 in the cache */
   /* replace596 -> 1757 in the cache */

   /* ('ior', ('ilt(is_used_once)', 'a', 'b'), ('ilt', 'a', 'c')) => ('ilt', 'a', ('imax', 'b', 'c')) */
   /* search597_0_0 -> 139 in the cache */
   /* search597_0_1 -> 140 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ilt,
      -1, 0,
      { 139, 140 },
      0,
   } },
   /* search597_1_0 -> 139 in the cache */
   /* search597_1_1 -> 142 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ilt,
      -1, 0,
      { 139, 142 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ior,
      0, 1,
      { 1774, 1775 },
      -1,
   } },

   /* replace597_0 -> 139 in the cache */
   /* replace597_1_0 -> 140 in the cache */
   /* replace597_1_1 -> 142 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_imax,
      0, 1,
      { 140, 142 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ilt,
      -1, 1,
      { 139, 1777 },
      -1,
   } },

   /* ('ior', ('ilt(is_used_once)', 'a', 'c'), ('ilt', 'b', 'c')) => ('ilt', ('imin', 'a', 'b'), 'c') */
   /* search598_0_0 -> 0 in the cache */
   /* search598_0_1 -> 783 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ilt,
      -1, 0,
      { 0, 783 },
      0,
   } },
   /* search598_1_0 -> 1717 in the cache */
   /* search598_1_1 -> 783 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ilt,
      -1, 0,
      { 1717, 783 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ior,
      0, 1,
      { 1779, 1780 },
      -1,
   } },

   /* replace598_0_0 -> 0 in the cache */
   /* replace598_0_1 -> 1717 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_imin,
      0, 1,
      { 0, 1717 },
      -1,
   } },
   /* replace598_1 -> 783 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ilt,
      -1, 1,
      { 1782, 783 },
      -1,
   } },

   /* ('ior', ('ige(is_used_once)', 'a', 'b'), ('ige', 'a', 'c')) => ('ige', 'a', ('imin', 'b', 'c')) */
   /* search599_0_0 -> 139 in the cache */
   /* search599_0_1 -> 140 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ige,
      -1, 0,
      { 139, 140 },
      0,
   } },
   /* search599_1_0 -> 139 in the cache */
   /* search599_1_1 -> 142 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ige,
      -1, 0,
      { 139, 142 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ior,
      0, 1,
      { 1784, 1785 },
      -1,
   } },

   /* replace599_0 -> 139 in the cache */
   /* replace599_1_0 -> 140 in the cache */
   /* replace599_1_1 -> 142 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_imin,
      0, 1,
      { 140, 142 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ige,
      -1, 1,
      { 139, 1787 },
      -1,
   } },

   /* ('ior', ('ige(is_used_once)', 'a', 'c'), ('ige', 'b', 'c')) => ('ige', ('imax', 'a', 'b'), 'c') */
   /* search600_0_0 -> 0 in the cache */
   /* search600_0_1 -> 783 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ige,
      -1, 0,
      { 0, 783 },
      0,
   } },
   /* search600_1_0 -> 1717 in the cache */
   /* search600_1_1 -> 783 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ige,
      -1, 0,
      { 1717, 783 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ior,
      0, 1,
      { 1789, 1790 },
      -1,
   } },

   /* replace600_0_0 -> 0 in the cache */
   /* replace600_0_1 -> 1717 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_imax,
      0, 1,
      { 0, 1717 },
      -1,
   } },
   /* replace600_1 -> 783 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ige,
      -1, 1,
      { 1792, 783 },
      -1,
   } },

   /* ('ior', ('ult(is_used_once)', 'a', 'b'), ('ult', 'a', 'c')) => ('ult', 'a', ('umax', 'b', 'c')) */
   /* search601_0_0 -> 139 in the cache */
   /* search601_0_1 -> 140 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ult,
      -1, 0,
      { 139, 140 },
      0,
   } },
   /* search601_1_0 -> 139 in the cache */
   /* search601_1_1 -> 142 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ult,
      -1, 0,
      { 139, 142 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ior,
      0, 1,
      { 1794, 1795 },
      -1,
   } },

   /* replace601_0 -> 139 in the cache */
   /* replace601_1_0 -> 140 in the cache */
   /* replace601_1_1 -> 142 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_umax,
      0, 1,
      { 140, 142 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ult,
      -1, 1,
      { 139, 1797 },
      -1,
   } },

   /* ('ior', ('ult(is_used_once)', 'a', 'c'), ('ult', 'b', 'c')) => ('ult', ('umin', 'a', 'b'), 'c') */
   /* search602_0_0 -> 0 in the cache */
   /* search602_0_1 -> 783 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ult,
      -1, 0,
      { 0, 783 },
      0,
   } },
   /* search602_1_0 -> 1717 in the cache */
   /* search602_1_1 -> 783 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ult,
      -1, 0,
      { 1717, 783 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ior,
      0, 1,
      { 1799, 1800 },
      -1,
   } },

   /* replace602_0_0 -> 0 in the cache */
   /* replace602_0_1 -> 1717 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_umin,
      0, 1,
      { 0, 1717 },
      -1,
   } },
   /* replace602_1 -> 783 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ult,
      -1, 1,
      { 1802, 783 },
      -1,
   } },

   /* ('ior', ('uge(is_used_once)', 'a', 'b'), ('uge', 'a', 'c')) => ('uge', 'a', ('umin', 'b', 'c')) */
   /* search603_0_0 -> 139 in the cache */
   /* search603_0_1 -> 140 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_uge,
      -1, 0,
      { 139, 140 },
      0,
   } },
   /* search603_1_0 -> 139 in the cache */
   /* search603_1_1 -> 142 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_uge,
      -1, 0,
      { 139, 142 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ior,
      0, 1,
      { 1804, 1805 },
      -1,
   } },

   /* replace603_0 -> 139 in the cache */
   /* replace603_1_0 -> 140 in the cache */
   /* replace603_1_1 -> 142 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_umin,
      0, 1,
      { 140, 142 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_uge,
      -1, 1,
      { 139, 1807 },
      -1,
   } },

   /* ('ior', ('uge(is_used_once)', 'a', 'c'), ('uge', 'b', 'c')) => ('uge', ('umax', 'a', 'b'), 'c') */
   /* search604_0_0 -> 0 in the cache */
   /* search604_0_1 -> 783 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_uge,
      -1, 0,
      { 0, 783 },
      0,
   } },
   /* search604_1_0 -> 1717 in the cache */
   /* search604_1_1 -> 783 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_uge,
      -1, 0,
      { 1717, 783 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ior,
      0, 1,
      { 1809, 1810 },
      -1,
   } },

   /* replace604_0_0 -> 0 in the cache */
   /* replace604_0_1 -> 1717 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_umax,
      0, 1,
      { 0, 1717 },
      -1,
   } },
   /* replace604_1 -> 783 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_uge,
      -1, 1,
      { 1812, 783 },
      -1,
   } },

   /* ('iand', ('ilt(is_used_once)', 'a', 'b'), ('ilt', 'a', 'c')) => ('ilt', 'a', ('imin', 'b', 'c')) */
   /* search605_0_0 -> 139 in the cache */
   /* search605_0_1 -> 140 in the cache */
   /* search605_0 -> 1774 in the cache */
   /* search605_1_0 -> 139 in the cache */
   /* search605_1_1 -> 142 in the cache */
   /* search605_1 -> 1775 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_iand,
      0, 1,
      { 1774, 1775 },
      -1,
   } },

   /* replace605_0 -> 139 in the cache */
   /* replace605_1_0 -> 140 in the cache */
   /* replace605_1_1 -> 142 in the cache */
   /* replace605_1 -> 1787 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ilt,
      -1, 1,
      { 139, 1787 },
      -1,
   } },

   /* ('iand', ('ilt(is_used_once)', 'a', 'c'), ('ilt', 'b', 'c')) => ('ilt', ('imax', 'a', 'b'), 'c') */
   /* search606_0_0 -> 0 in the cache */
   /* search606_0_1 -> 783 in the cache */
   /* search606_0 -> 1779 in the cache */
   /* search606_1_0 -> 1717 in the cache */
   /* search606_1_1 -> 783 in the cache */
   /* search606_1 -> 1780 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_iand,
      0, 1,
      { 1779, 1780 },
      -1,
   } },

   /* replace606_0_0 -> 0 in the cache */
   /* replace606_0_1 -> 1717 in the cache */
   /* replace606_0 -> 1792 in the cache */
   /* replace606_1 -> 783 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ilt,
      -1, 1,
      { 1792, 783 },
      -1,
   } },

   /* ('iand', ('ige(is_used_once)', 'a', 'b'), ('ige', 'a', 'c')) => ('ige', 'a', ('imax', 'b', 'c')) */
   /* search607_0_0 -> 139 in the cache */
   /* search607_0_1 -> 140 in the cache */
   /* search607_0 -> 1784 in the cache */
   /* search607_1_0 -> 139 in the cache */
   /* search607_1_1 -> 142 in the cache */
   /* search607_1 -> 1785 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_iand,
      0, 1,
      { 1784, 1785 },
      -1,
   } },

   /* replace607_0 -> 139 in the cache */
   /* replace607_1_0 -> 140 in the cache */
   /* replace607_1_1 -> 142 in the cache */
   /* replace607_1 -> 1777 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ige,
      -1, 1,
      { 139, 1777 },
      -1,
   } },

   /* ('iand', ('ige(is_used_once)', 'a', 'c'), ('ige', 'b', 'c')) => ('ige', ('imin', 'a', 'b'), 'c') */
   /* search608_0_0 -> 0 in the cache */
   /* search608_0_1 -> 783 in the cache */
   /* search608_0 -> 1789 in the cache */
   /* search608_1_0 -> 1717 in the cache */
   /* search608_1_1 -> 783 in the cache */
   /* search608_1 -> 1790 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_iand,
      0, 1,
      { 1789, 1790 },
      -1,
   } },

   /* replace608_0_0 -> 0 in the cache */
   /* replace608_0_1 -> 1717 in the cache */
   /* replace608_0 -> 1782 in the cache */
   /* replace608_1 -> 783 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ige,
      -1, 1,
      { 1782, 783 },
      -1,
   } },

   /* ('iand', ('ult(is_used_once)', 'a', 'b'), ('ult', 'a', 'c')) => ('ult', 'a', ('umin', 'b', 'c')) */
   /* search609_0_0 -> 139 in the cache */
   /* search609_0_1 -> 140 in the cache */
   /* search609_0 -> 1794 in the cache */
   /* search609_1_0 -> 139 in the cache */
   /* search609_1_1 -> 142 in the cache */
   /* search609_1 -> 1795 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_iand,
      0, 1,
      { 1794, 1795 },
      -1,
   } },

   /* replace609_0 -> 139 in the cache */
   /* replace609_1_0 -> 140 in the cache */
   /* replace609_1_1 -> 142 in the cache */
   /* replace609_1 -> 1807 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ult,
      -1, 1,
      { 139, 1807 },
      -1,
   } },

   /* ('iand', ('ult(is_used_once)', 'a', 'c'), ('ult', 'b', 'c')) => ('ult', ('umax', 'a', 'b'), 'c') */
   /* search610_0_0 -> 0 in the cache */
   /* search610_0_1 -> 783 in the cache */
   /* search610_0 -> 1799 in the cache */
   /* search610_1_0 -> 1717 in the cache */
   /* search610_1_1 -> 783 in the cache */
   /* search610_1 -> 1800 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_iand,
      0, 1,
      { 1799, 1800 },
      -1,
   } },

   /* replace610_0_0 -> 0 in the cache */
   /* replace610_0_1 -> 1717 in the cache */
   /* replace610_0 -> 1812 in the cache */
   /* replace610_1 -> 783 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ult,
      -1, 1,
      { 1812, 783 },
      -1,
   } },

   /* ('iand', ('uge(is_used_once)', 'a', 'b'), ('uge', 'a', 'c')) => ('uge', 'a', ('umax', 'b', 'c')) */
   /* search611_0_0 -> 139 in the cache */
   /* search611_0_1 -> 140 in the cache */
   /* search611_0 -> 1804 in the cache */
   /* search611_1_0 -> 139 in the cache */
   /* search611_1_1 -> 142 in the cache */
   /* search611_1 -> 1805 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_iand,
      0, 1,
      { 1804, 1805 },
      -1,
   } },

   /* replace611_0 -> 139 in the cache */
   /* replace611_1_0 -> 140 in the cache */
   /* replace611_1_1 -> 142 in the cache */
   /* replace611_1 -> 1797 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_uge,
      -1, 1,
      { 139, 1797 },
      -1,
   } },

   /* ('iand', ('uge(is_used_once)', 'a', 'c'), ('uge', 'b', 'c')) => ('uge', ('umin', 'a', 'b'), 'c') */
   /* search612_0_0 -> 0 in the cache */
   /* search612_0_1 -> 783 in the cache */
   /* search612_0 -> 1809 in the cache */
   /* search612_1_0 -> 1717 in the cache */
   /* search612_1_1 -> 783 in the cache */
   /* search612_1 -> 1810 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_iand,
      0, 1,
      { 1809, 1810 },
      -1,
   } },

   /* replace612_0_0 -> 0 in the cache */
   /* replace612_0_1 -> 1717 in the cache */
   /* replace612_0 -> 1802 in the cache */
   /* replace612_1 -> 783 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_uge,
      -1, 1,
      { 1802, 783 },
      -1,
   } },

   /* ('ior', ('ior(is_used_once)', ('flt(is_used_once)', 'a', 'c'), 'd'), ('flt', 'b', 'c')) => ('ior', ('flt', ('!fmin', 'a', 'b'), 'c'), 'd') */
   /* search613_0_0_0 -> 0 in the cache */
   /* search613_0_0_1 -> 783 in the cache */
   /* search613_0_0 -> 1716 in the cache */
   { .variable = {
      { nir_search_value_variable, 1 },
      2, /* d */
      false,
      nir_type_invalid,
      -1,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ior,
      1, 1,
      { 1716, 1830 },
      0,
   } },
   { .variable = {
      { nir_search_value_variable, -2 },
      3, /* b */
      false,
      nir_type_invalid,
      -1,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   /* search613_1_1 -> 783 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_flt,
      -1, 0,
      { 1832, 783 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ior,
      0, 2,
      { 1831, 1833 },
      -1,
   } },

   /* replace613_0_0_0 -> 0 in the cache */
   /* replace613_0_0_1 -> 1832 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      true,
      false,
      false,
      false,
      false,
      nir_op_fmin,
      1, 1,
      { 0, 1832 },
      -1,
   } },
   /* replace613_0_1 -> 783 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_flt,
      -1, 1,
      { 1835, 783 },
      -1,
   } },
   /* replace613_1 -> 1830 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ior,
      0, 2,
      { 1836, 1830 },
      -1,
   } },

   /* ('ior', ('ior(is_used_once)', ('flt', 'a', 'c'), 'd'), ('flt(is_used_once)', 'b', 'c')) => ('ior', ('flt', ('!fmin', 'a', 'b'), 'c'), 'd') */
   /* search614_0_0_0 -> 0 in the cache */
   /* search614_0_0_1 -> 783 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_flt,
      -1, 0,
      { 0, 783 },
      -1,
   } },
   /* search614_0_1 -> 1830 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ior,
      1, 1,
      { 1838, 1830 },
      0,
   } },
   /* search614_1_0 -> 1832 in the cache */
   /* search614_1_1 -> 783 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_flt,
      -1, 0,
      { 1832, 783 },
      0,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ior,
      0, 2,
      { 1839, 1840 },
      -1,
   } },

   /* replace614_0_0_0 -> 0 in the cache */
   /* replace614_0_0_1 -> 1832 in the cache */
   /* replace614_0_0 -> 1835 in the cache */
   /* replace614_0_1 -> 783 in the cache */
   /* replace614_0 -> 1836 in the cache */
   /* replace614_1 -> 1830 in the cache */
   /* replace614 -> 1837 in the cache */

   /* ('ior', ('ior(is_used_once)', ('flt(is_used_once)', 'a', 'b'), 'd'), ('flt', 'a', 'c')) => ('ior', ('flt', 'a', ('!fmax', 'b', 'c')), 'd') */
   /* search615_0_0_0 -> 162 in the cache */
   /* search615_0_0_1 -> 163 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_flt,
      -1, 0,
      { 162, 163 },
      0,
   } },
   /* search615_0_1 -> 1830 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ior,
      1, 1,
      { 1842, 1830 },
      0,
   } },
   /* search615_1_0 -> 162 in the cache */
   { .variable = {
      { nir_search_value_variable, -4 },
      3, /* c */
      false,
      nir_type_invalid,
      -1,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_flt,
      -1, 0,
      { 162, 1844 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ior,
      0, 2,
      { 1843, 1845 },
      -1,
   } },

   /* replace615_0_0 -> 162 in the cache */
   /* replace615_0_1_0 -> 163 in the cache */
   /* replace615_0_1_1 -> 1844 in the cache */
   { .expression = {
      { nir_search_value_expression, -4 },
      false,
      true,
      false,
      false,
      false,
      false,
      nir_op_fmax,
      1, 1,
      { 163, 1844 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_flt,
      -1, 1,
      { 162, 1847 },
      -1,
   } },
   /* replace615_1 -> 1830 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ior,
      0, 2,
      { 1848, 1830 },
      -1,
   } },

   /* ('ior', ('ior(is_used_once)', ('flt', 'a', 'b'), 'd'), ('flt(is_used_once)', 'a', 'c')) => ('ior', ('flt', 'a', ('!fmax', 'b', 'c')), 'd') */
   /* search616_0_0_0 -> 162 in the cache */
   /* search616_0_0_1 -> 163 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_flt,
      -1, 0,
      { 162, 163 },
      -1,
   } },
   /* search616_0_1 -> 1830 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ior,
      1, 1,
      { 1850, 1830 },
      0,
   } },
   /* search616_1_0 -> 162 in the cache */
   /* search616_1_1 -> 1844 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_flt,
      -1, 0,
      { 162, 1844 },
      0,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ior,
      0, 2,
      { 1851, 1852 },
      -1,
   } },

   /* replace616_0_0 -> 162 in the cache */
   /* replace616_0_1_0 -> 163 in the cache */
   /* replace616_0_1_1 -> 1844 in the cache */
   /* replace616_0_1 -> 1847 in the cache */
   /* replace616_0 -> 1848 in the cache */
   /* replace616_1 -> 1830 in the cache */
   /* replace616 -> 1849 in the cache */

   /* ('ior', ('flt', 'a(is_a_number)', 'b(is_a_number)'), ('flt', 'b', 'a')) => ('fneu', 'a', 'b') */
   /* search617_0_0 -> 1144 in the cache */
   /* search617_0_1 -> 1145 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_flt,
      -1, 0,
      { 1144, 1145 },
      -1,
   } },
   /* search617_1_0 -> 1 in the cache */
   /* search617_1_1 -> 0 in the cache */
   /* search617_1 -> 1178 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ior,
      0, 1,
      { 1854, 1178 },
      -1,
   } },

   /* replace617_0 -> 0 in the cache */
   /* replace617_1 -> 1 in the cache */
   /* replace617 -> 1152 in the cache */

   /* ('umin', ('iand', 'a', '#b(is_pos_power_of_two)'), ('iand', 'c', 'b')) => ('iand', ('iand', 'a', 'b'), ('iand', 'c', 'b')) */
   /* search618_0_0 -> 0 in the cache */
   /* search618_0_1 -> 15 in the cache */
   /* search618_0 -> 212 in the cache */
   /* search618_1_0 -> 153 in the cache */
   /* search618_1_1 -> 1 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_iand,
      2, 1,
      { 153, 1 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_umin,
      0, 3,
      { 212, 1856 },
      -1,
   } },

   /* replace618_0_0 -> 0 in the cache */
   /* replace618_0_1 -> 1 in the cache */
   /* replace618_0 -> 214 in the cache */
   /* replace618_1_0 -> 153 in the cache */
   /* replace618_1_1 -> 1 in the cache */
   /* replace618_1 -> 1856 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_iand,
      0, 3,
      { 214, 1856 },
      -1,
   } },

   /* ('ior', ('flt(is_used_once)', 0.0, 'a@16'), ('flt', 'b@16', 0.0)) => ('flt', 0.0, ('fmax', 'a', ('fneg', 'b'))) */
   /* search619_0_0 -> 788 in the cache */
   /* search619_0_1 -> 24 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_flt,
      -1, 0,
      { 788, 24 },
      0,
   } },
   /* search619_1_0 -> 563 in the cache */
   /* search619_1_1 -> 788 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_flt,
      -1, 0,
      { 563, 788 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ior,
      0, 1,
      { 1859, 1860 },
      -1,
   } },

   /* replace619_0 -> 788 in the cache */
   /* replace619_1_0 -> 24 in the cache */
   /* replace619_1_1_0 -> 563 in the cache */
   /* replace619_1_1 -> 634 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fmax,
      0, 1,
      { 24, 634 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_flt,
      -1, 1,
      { 788, 1862 },
      -1,
   } },

   /* ('ior', ('flt', 0.0, 'a@16'), ('flt(is_used_once)', 'b@16', 0.0)) => ('flt', 0.0, ('fmax', 'a', ('fneg', 'b'))) */
   /* search620_0_0 -> 788 in the cache */
   /* search620_0_1 -> 24 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_flt,
      -1, 0,
      { 788, 24 },
      -1,
   } },
   /* search620_1_0 -> 563 in the cache */
   /* search620_1_1 -> 788 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_flt,
      -1, 0,
      { 563, 788 },
      0,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ior,
      0, 1,
      { 1864, 1865 },
      -1,
   } },

   /* replace620_0 -> 788 in the cache */
   /* replace620_1_0 -> 24 in the cache */
   /* replace620_1_1_0 -> 563 in the cache */
   /* replace620_1_1 -> 634 in the cache */
   /* replace620_1 -> 1862 in the cache */
   /* replace620 -> 1863 in the cache */

   /* ('ior', ('fge(is_used_once)', 0.0, 'a@16'), ('fge', 'b@16', 0.0)) => ('fge', 0.0, ('fmin', 'a', ('fneg', 'b'))) */
   /* search621_0_0 -> 788 in the cache */
   /* search621_0_1 -> 24 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fge,
      -1, 0,
      { 788, 24 },
      0,
   } },
   /* search621_1_0 -> 563 in the cache */
   /* search621_1_1 -> 788 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fge,
      -1, 0,
      { 563, 788 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ior,
      0, 1,
      { 1867, 1868 },
      -1,
   } },

   /* replace621_0 -> 788 in the cache */
   /* replace621_1_0 -> 24 in the cache */
   /* replace621_1_1_0 -> 563 in the cache */
   /* replace621_1_1 -> 634 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fmin,
      0, 1,
      { 24, 634 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fge,
      -1, 1,
      { 788, 1870 },
      -1,
   } },

   /* ('ior', ('fge', 0.0, 'a@16'), ('fge(is_used_once)', 'b@16', 0.0)) => ('fge', 0.0, ('fmin', 'a', ('fneg', 'b'))) */
   /* search622_0_0 -> 788 in the cache */
   /* search622_0_1 -> 24 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fge,
      -1, 0,
      { 788, 24 },
      -1,
   } },
   /* search622_1_0 -> 563 in the cache */
   /* search622_1_1 -> 788 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fge,
      -1, 0,
      { 563, 788 },
      0,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ior,
      0, 1,
      { 1872, 1873 },
      -1,
   } },

   /* replace622_0 -> 788 in the cache */
   /* replace622_1_0 -> 24 in the cache */
   /* replace622_1_1_0 -> 563 in the cache */
   /* replace622_1_1 -> 634 in the cache */
   /* replace622_1 -> 1870 in the cache */
   /* replace622 -> 1871 in the cache */

   /* ('~iand', ('flt(is_used_once)', 0.0, 'a@16'), ('flt', 'b@16', 0.0)) => ('flt', 0.0, ('fmin', 'a', ('fneg', 'b'))) */
   /* search623_0_0 -> 788 in the cache */
   /* search623_0_1 -> 24 in the cache */
   /* search623_0 -> 1859 in the cache */
   /* search623_1_0 -> 563 in the cache */
   /* search623_1_1 -> 788 in the cache */
   /* search623_1 -> 1860 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      true,
      false,
      false,
      false,
      false,
      false,
      nir_op_iand,
      0, 1,
      { 1859, 1860 },
      -1,
   } },

   /* replace623_0 -> 788 in the cache */
   /* replace623_1_0 -> 24 in the cache */
   /* replace623_1_1_0 -> 563 in the cache */
   /* replace623_1_1 -> 634 in the cache */
   /* replace623_1 -> 1870 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_flt,
      -1, 1,
      { 788, 1870 },
      -1,
   } },

   /* ('~iand', ('flt', 0.0, 'a@16'), ('flt(is_used_once)', 'b@16', 0.0)) => ('flt', 0.0, ('fmin', 'a', ('fneg', 'b'))) */
   /* search624_0_0 -> 788 in the cache */
   /* search624_0_1 -> 24 in the cache */
   /* search624_0 -> 1864 in the cache */
   /* search624_1_0 -> 563 in the cache */
   /* search624_1_1 -> 788 in the cache */
   /* search624_1 -> 1865 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      true,
      false,
      false,
      false,
      false,
      false,
      nir_op_iand,
      0, 1,
      { 1864, 1865 },
      -1,
   } },

   /* replace624_0 -> 788 in the cache */
   /* replace624_1_0 -> 24 in the cache */
   /* replace624_1_1_0 -> 563 in the cache */
   /* replace624_1_1 -> 634 in the cache */
   /* replace624_1 -> 1870 in the cache */
   /* replace624 -> 1876 in the cache */

   /* ('~iand', ('fge(is_used_once)', 0.0, 'a@16'), ('fge', 'b@16', 0.0)) => ('fge', 0.0, ('fmax', 'a', ('fneg', 'b'))) */
   /* search625_0_0 -> 788 in the cache */
   /* search625_0_1 -> 24 in the cache */
   /* search625_0 -> 1867 in the cache */
   /* search625_1_0 -> 563 in the cache */
   /* search625_1_1 -> 788 in the cache */
   /* search625_1 -> 1868 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      true,
      false,
      false,
      false,
      false,
      false,
      nir_op_iand,
      0, 1,
      { 1867, 1868 },
      -1,
   } },

   /* replace625_0 -> 788 in the cache */
   /* replace625_1_0 -> 24 in the cache */
   /* replace625_1_1_0 -> 563 in the cache */
   /* replace625_1_1 -> 634 in the cache */
   /* replace625_1 -> 1862 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fge,
      -1, 1,
      { 788, 1862 },
      -1,
   } },

   /* ('~iand', ('fge', 0.0, 'a@16'), ('fge(is_used_once)', 'b@16', 0.0)) => ('fge', 0.0, ('fmax', 'a', ('fneg', 'b'))) */
   /* search626_0_0 -> 788 in the cache */
   /* search626_0_1 -> 24 in the cache */
   /* search626_0 -> 1872 in the cache */
   /* search626_1_0 -> 563 in the cache */
   /* search626_1_1 -> 788 in the cache */
   /* search626_1 -> 1873 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      true,
      false,
      false,
      false,
      false,
      false,
      nir_op_iand,
      0, 1,
      { 1872, 1873 },
      -1,
   } },

   /* replace626_0 -> 788 in the cache */
   /* replace626_1_0 -> 24 in the cache */
   /* replace626_1_1_0 -> 563 in the cache */
   /* replace626_1_1 -> 634 in the cache */
   /* replace626_1 -> 1862 in the cache */
   /* replace626 -> 1879 in the cache */

   /* ('ior', ('feq(is_used_once)', 'a@16', 0.0), ('feq', 'b@16', 0.0)) => ('feq', ('fmin', ('fabs', 'a'), ('fabs', 'b')), 0.0) */
   /* search627_0_0 -> 24 in the cache */
   /* search627_0_1 -> 788 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_feq,
      1, 1,
      { 24, 788 },
      0,
   } },
   /* search627_1_0 -> 563 in the cache */
   /* search627_1_1 -> 788 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_feq,
      2, 1,
      { 563, 788 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ior,
      0, 3,
      { 1881, 1882 },
      -1,
   } },

   /* replace627_0_0_0 -> 24 in the cache */
   /* replace627_0_0 -> 790 in the cache */
   /* replace627_0_1_0 -> 563 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fabs,
      -1, 0,
      { 563 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fmin,
      1, 1,
      { 790, 1884 },
      -1,
   } },
   /* replace627_1 -> 788 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_feq,
      0, 2,
      { 1885, 788 },
      -1,
   } },

   /* ('ior', ('fneu(is_used_once)', 'a@16', 0.0), ('fneu', 'b@16', 0.0)) => ('fneu', ('fadd', ('fabs', 'a'), ('fabs', 'b')), 0.0) */
   /* search628_0_0 -> 24 in the cache */
   /* search628_0_1 -> 788 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fneu,
      1, 1,
      { 24, 788 },
      0,
   } },
   /* search628_1_0 -> 563 in the cache */
   /* search628_1_1 -> 788 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fneu,
      2, 1,
      { 563, 788 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ior,
      0, 3,
      { 1887, 1888 },
      -1,
   } },

   /* replace628_0_0_0 -> 24 in the cache */
   /* replace628_0_0 -> 790 in the cache */
   /* replace628_0_1_0 -> 563 in the cache */
   /* replace628_0_1 -> 1884 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fadd,
      1, 1,
      { 790, 1884 },
      -1,
   } },
   /* replace628_1 -> 788 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fneu,
      0, 2,
      { 1890, 788 },
      -1,
   } },

   /* ('iand', ('feq(is_used_once)', 'a@16', 0.0), ('feq', 'b@16', 0.0)) => ('feq', ('fadd', ('fabs', 'a'), ('fabs', 'b')), 0.0) */
   /* search629_0_0 -> 24 in the cache */
   /* search629_0_1 -> 788 in the cache */
   /* search629_0 -> 1881 in the cache */
   /* search629_1_0 -> 563 in the cache */
   /* search629_1_1 -> 788 in the cache */
   /* search629_1 -> 1882 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_iand,
      0, 3,
      { 1881, 1882 },
      -1,
   } },

   /* replace629_0_0_0 -> 24 in the cache */
   /* replace629_0_0 -> 790 in the cache */
   /* replace629_0_1_0 -> 563 in the cache */
   /* replace629_0_1 -> 1884 in the cache */
   /* replace629_0 -> 1890 in the cache */
   /* replace629_1 -> 788 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_feq,
      0, 2,
      { 1890, 788 },
      -1,
   } },

   /* ('iand', ('fneu(is_used_once)', 'a@16', 0.0), ('fneu', 'b@16', 0.0)) => ('fneu', ('fmin', ('fabs', 'a'), ('fabs', 'b')), 0.0) */
   /* search630_0_0 -> 24 in the cache */
   /* search630_0_1 -> 788 in the cache */
   /* search630_0 -> 1887 in the cache */
   /* search630_1_0 -> 563 in the cache */
   /* search630_1_1 -> 788 in the cache */
   /* search630_1 -> 1888 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_iand,
      0, 3,
      { 1887, 1888 },
      -1,
   } },

   /* replace630_0_0_0 -> 24 in the cache */
   /* replace630_0_0 -> 790 in the cache */
   /* replace630_0_1_0 -> 563 in the cache */
   /* replace630_0_1 -> 1884 in the cache */
   /* replace630_0 -> 1885 in the cache */
   /* replace630_1 -> 788 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fneu,
      0, 2,
      { 1885, 788 },
      -1,
   } },

   /* ('bcsel@16', ('feq', 'a', 0.0), 1.0, ('i2f16', ('iadd', ('b2i16', ('flt', 0.0, 'a@16')), ('ineg', ('b2i16', ('flt', 'a@16', 0.0)))))) => ('i2f16', ('iadd', ('b2i32', ('!fge', 'a', 0.0)), ('ineg', ('b2i32', ('!flt', 'a', 0.0))))) */
   /* search631_0_0 -> 24 in the cache */
   /* search631_0_1 -> 788 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_feq,
      0, 1,
      { 24, 788 },
      -1,
   } },
   /* search631_1 -> 581 in the cache */
   /* search631_2_0_0_0_0 -> 788 in the cache */
   /* search631_2_0_0_0_1 -> 24 in the cache */
   /* search631_2_0_0_0 -> 1864 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_b2i16,
      -1, 0,
      { 1864 },
      -1,
   } },
   /* search631_2_0_1_0_0_0 -> 24 in the cache */
   /* search631_2_0_1_0_0_1 -> 788 in the cache */
   /* search631_2_0_1_0_0 -> 789 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_b2i16,
      -1, 0,
      { 789 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ineg,
      -1, 0,
      { 1898 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_iadd,
      1, 1,
      { 1897, 1899 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_i2f16,
      -1, 1,
      { 1900 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_bcsel,
      -1, 2,
      { 1896, 581, 1901 },
      -1,
   } },

   /* replace631_0_0_0_0 -> 24 in the cache */
   /* replace631_0_0_0_1 -> 788 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      true,
      false,
      false,
      false,
      false,
      nir_op_fge,
      -1, 0,
      { 24, 788 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_b2i32,
      -1, 0,
      { 1903 },
      -1,
   } },
   /* replace631_0_1_0_0_0 -> 24 in the cache */
   /* replace631_0_1_0_0_1 -> 788 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      true,
      false,
      false,
      false,
      false,
      nir_op_flt,
      -1, 0,
      { 24, 788 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_b2i32,
      -1, 0,
      { 1905 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ineg,
      -1, 0,
      { 1906 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_iadd,
      0, 1,
      { 1904, 1907 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_i2f16,
      -1, 1,
      { 1908 },
      -1,
   } },

   /* ('bcsel', 'a', ('b2f(is_used_once)', 'b@16'), ('b2f', 'c@16')) => ('b2f', ('bcsel', 'a', 'b', 'c')) */
   /* search632_0 -> 859 in the cache */
   /* search632_1_0 -> 563 in the cache */
   { .expression = {
      { nir_search_value_expression, 0 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_search_op_b2f,
      -1, 0,
      { 563 },
      0,
   } },
   /* search632_2_0 -> 569 in the cache */
   { .expression = {
      { nir_search_value_expression, 0 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_search_op_b2f,
      -1, 0,
      { 569 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 0 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_bcsel,
      -1, 0,
      { 859, 1910, 1911 },
      -1,
   } },

   /* replace632_0_0 -> 859 in the cache */
   /* replace632_0_1 -> 563 in the cache */
   /* replace632_0_2 -> 569 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_bcsel,
      -1, 0,
      { 859, 563, 569 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 0 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_search_op_b2f,
      -1, 0,
      { 1913 },
      -1,
   } },

   /* ('~i2f16', ('f2i', 'a@16')) => ('ftrunc', 'a') */
   /* search633_0_0 -> 24 in the cache */
   { .expression = {
      { nir_search_value_expression, 0 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_search_op_f2i,
      -1, 0,
      { 24 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 16 },
      true,
      false,
      false,
      false,
      false,
      false,
      nir_op_i2f16,
      -1, 0,
      { 1915 },
      -1,
   } },

   /* replace633_0 -> 24 in the cache */
   /* replace633 -> 787 in the cache */

   /* ('~f2i16', ('i2f', 'a@16')) => a */
   /* search634_0_0 -> 24 in the cache */
   { .expression = {
      { nir_search_value_expression, 0 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_search_op_i2f,
      -1, 0,
      { 24 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 16 },
      true,
      false,
      false,
      false,
      false,
      false,
      nir_op_f2i16,
      -1, 0,
      { 1917 },
      -1,
   } },

   /* replace634 -> 24 in the cache */

   /* ('~f2i16', ('u2f', 'a@16')) => a */
   /* search635_0_0 -> 24 in the cache */
   { .expression = {
      { nir_search_value_expression, 0 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_search_op_u2f,
      -1, 0,
      { 24 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 16 },
      true,
      false,
      false,
      false,
      false,
      false,
      nir_op_f2i16,
      -1, 0,
      { 1919 },
      -1,
   } },

   /* replace635 -> 24 in the cache */

   /* ('~f2u16', ('i2f', 'a@16')) => a */
   /* search636_0_0 -> 24 in the cache */
   /* search636_0 -> 1917 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      true,
      false,
      false,
      false,
      false,
      false,
      nir_op_f2u16,
      -1, 0,
      { 1917 },
      -1,
   } },

   /* replace636 -> 24 in the cache */

   /* ('~f2u16', ('u2f', 'a@16')) => a */
   /* search637_0_0 -> 24 in the cache */
   /* search637_0 -> 1919 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      true,
      false,
      false,
      false,
      false,
      false,
      nir_op_f2u16,
      -1, 0,
      { 1919 },
      -1,
   } },

   /* replace637 -> 24 in the cache */

   /* ('fadd', ('b2f16', ('flt', 0.0, 'a@16')), ('fneg', ('b2f16', ('flt', 'a@16', 0.0)))) => ('fsign', 'a') */
   /* search638_0_0_0 -> 788 in the cache */
   /* search638_0_0_1 -> 24 in the cache */
   /* search638_0_0 -> 1864 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_b2f16,
      -1, 0,
      { 1864 },
      -1,
   } },
   /* search638_1_0_0_0 -> 24 in the cache */
   /* search638_1_0_0_1 -> 788 in the cache */
   /* search638_1_0_0 -> 789 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_b2f16,
      -1, 0,
      { 789 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fneg,
      -1, 0,
      { 1924 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fadd,
      0, 1,
      { 1923, 1925 },
      -1,
   } },

   /* replace638_0 -> 24 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fsign,
      -1, 0,
      { 24 },
      -1,
   } },

   /* ('iadd', ('b2i16', ('flt', 0, 'a@16')), ('ineg', ('b2i16', ('flt', 'a@16', 0)))) => ('f2i16', ('fsign', 'a')) */
   /* search639_0_0_0 -> 958 in the cache */
   /* search639_0_0_1 -> 24 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_flt,
      -1, 0,
      { 958, 24 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_b2i16,
      -1, 0,
      { 1928 },
      -1,
   } },
   /* search639_1_0_0_0 -> 24 in the cache */
   /* search639_1_0_0_1 -> 958 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_flt,
      -1, 0,
      { 24, 958 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_b2i16,
      -1, 0,
      { 1930 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ineg,
      -1, 0,
      { 1931 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_iadd,
      0, 1,
      { 1929, 1932 },
      -1,
   } },

   /* replace639_0_0 -> 24 in the cache */
   /* replace639_0 -> 1927 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_f2i16,
      -1, 0,
      { 1927 },
      -1,
   } },

   /* ('~f2f16', ('f2f', 'a')) => ('f2f16', 'a') */
   /* search640_0_0 -> 9 in the cache */
   { .expression = {
      { nir_search_value_expression, 0 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_search_op_f2f,
      -1, 0,
      { 9 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 16 },
      true,
      false,
      false,
      false,
      false,
      false,
      nir_op_f2f16,
      -1, 0,
      { 1935 },
      -1,
   } },

   /* replace640_0 -> 9 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_f2f16,
      -1, 0,
      { 9 },
      -1,
   } },

   /* ('~f2f16', ('u2f', 'a')) => ('u2f16', 'a') */
   /* search641_0_0 -> 9 in the cache */
   /* search641_0 -> 123 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      true,
      false,
      false,
      false,
      false,
      false,
      nir_op_f2f16,
      -1, 0,
      { 123 },
      -1,
   } },

   /* replace641_0 -> 9 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_u2f16,
      -1, 0,
      { 9 },
      -1,
   } },

   /* ('~f2f16', ('i2f', 'a')) => ('i2f16', 'a') */
   /* search642_0_0 -> 9 in the cache */
   /* search642_0 -> 1375 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      true,
      false,
      false,
      false,
      false,
      false,
      nir_op_f2f16,
      -1, 0,
      { 1375 },
      -1,
   } },

   /* replace642_0 -> 9 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_i2f16,
      -1, 0,
      { 9 },
      -1,
   } },

   /* ('~f2u16', ('f2f', 'a')) => ('f2u16', 'a') */
   /* search643_0_0 -> 9 in the cache */
   /* search643_0 -> 1935 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      true,
      false,
      false,
      false,
      false,
      false,
      nir_op_f2u16,
      -1, 0,
      { 1935 },
      -1,
   } },

   /* replace643_0 -> 9 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_f2u16,
      -1, 0,
      { 9 },
      -1,
   } },

   /* ('~f2i16', ('f2f', 'a')) => ('f2i16', 'a') */
   /* search644_0_0 -> 9 in the cache */
   /* search644_0 -> 1935 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      true,
      false,
      false,
      false,
      false,
      false,
      nir_op_f2i16,
      -1, 0,
      { 1935 },
      -1,
   } },

   /* replace644_0 -> 9 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_f2i16,
      -1, 0,
      { 9 },
      -1,
   } },

   /* ('i2f16', ('f2i', ('fsign', 'a@16'))) => ('fsign', 'a') */
   /* search645_0_0_0 -> 24 in the cache */
   /* search645_0_0 -> 1927 in the cache */
   { .expression = {
      { nir_search_value_expression, 0 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_search_op_f2i,
      -1, 0,
      { 1927 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_i2f16,
      -1, 0,
      { 1946 },
      -1,
   } },

   /* replace645_0 -> 24 in the cache */
   /* replace645 -> 1927 in the cache */

   /* ('~f2f16', ('f2f32', 'a@16')) => a */
   /* search646_0_0 -> 24 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_f2f32,
      -1, 0,
      { 24 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 16 },
      true,
      false,
      false,
      false,
      false,
      false,
      nir_op_f2f16,
      -1, 0,
      { 1948 },
      -1,
   } },

   /* replace646 -> 24 in the cache */

   /* ('f2u32', ('f2f32', 'a@16')) => ('f2u32', 'a') */
   /* search647_0_0 -> 24 in the cache */
   /* search647_0 -> 1948 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_f2u32,
      -1, 0,
      { 1948 },
      -1,
   } },

   /* replace647_0 -> 24 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_f2u32,
      -1, 0,
      { 24 },
      -1,
   } },

   /* ('f2i32', ('f2f32', 'a@16')) => ('f2i32', 'a') */
   /* search648_0_0 -> 24 in the cache */
   /* search648_0 -> 1948 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_f2i32,
      -1, 0,
      { 1948 },
      -1,
   } },

   /* replace648_0 -> 24 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_f2i32,
      -1, 0,
      { 24 },
      -1,
   } },

   /* ('f2f16', ('u2f32', 'a')) => ('u2f16', 'a') */
   /* search649_0_0 -> 9 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_u2f32,
      -1, 0,
      { 9 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_f2f16,
      -1, 0,
      { 1954 },
      -1,
   } },

   /* replace649_0 -> 9 in the cache */
   /* replace649 -> 1939 in the cache */

   /* ('f2f16', ('i2f32', 'a')) => ('i2f16', 'a') */
   /* search650_0_0 -> 9 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_i2f32,
      -1, 0,
      { 9 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_f2f16,
      -1, 0,
      { 1956 },
      -1,
   } },

   /* replace650_0 -> 9 in the cache */
   /* replace650 -> 1941 in the cache */

   /* ('~f2f16', ('f2f64', 'a@16')) => a */
   /* search651_0_0 -> 24 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_f2f64,
      -1, 0,
      { 24 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 16 },
      true,
      false,
      false,
      false,
      false,
      false,
      nir_op_f2f16,
      -1, 0,
      { 1958 },
      -1,
   } },

   /* replace651 -> 24 in the cache */

   /* ('f2u64', ('f2f64', 'a@16')) => ('f2u64', 'a') */
   /* search652_0_0 -> 24 in the cache */
   /* search652_0 -> 1958 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_f2u64,
      -1, 0,
      { 1958 },
      -1,
   } },

   /* replace652_0 -> 24 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_f2u64,
      -1, 0,
      { 24 },
      -1,
   } },

   /* ('f2i64', ('f2f64', 'a@16')) => ('f2i64', 'a') */
   /* search653_0_0 -> 24 in the cache */
   /* search653_0 -> 1958 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_f2i64,
      -1, 0,
      { 1958 },
      -1,
   } },

   /* replace653_0 -> 24 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_f2i64,
      -1, 0,
      { 24 },
      -1,
   } },

   /* ('f2f16', ('u2f64', 'a')) => ('u2f16', 'a') */
   /* search654_0_0 -> 9 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_u2f64,
      -1, 0,
      { 9 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_f2f16,
      -1, 0,
      { 1964 },
      -1,
   } },

   /* replace654_0 -> 9 in the cache */
   /* replace654 -> 1939 in the cache */

   /* ('f2f16', ('i2f64', 'a')) => ('i2f16', 'a') */
   /* search655_0_0 -> 9 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_i2f64,
      -1, 0,
      { 9 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_f2f16,
      -1, 0,
      { 1966 },
      -1,
   } },

   /* replace655_0 -> 9 in the cache */
   /* replace655 -> 1941 in the cache */

   /* ('ior', ('flt(is_used_once)', 0.0, 'a@32'), ('flt', 'b@32', 0.0)) => ('flt', 0.0, ('fmax', 'a', ('fneg', 'b'))) */
   /* search656_0_0 -> 241 in the cache */
   /* search656_0_1 -> 29 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_flt,
      -1, 0,
      { 241, 29 },
      0,
   } },
   /* search656_1_0 -> 48 in the cache */
   /* search656_1_1 -> 241 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_flt,
      -1, 0,
      { 48, 241 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ior,
      0, 1,
      { 1968, 1969 },
      -1,
   } },

   /* replace656_0 -> 241 in the cache */
   /* replace656_1_0 -> 29 in the cache */
   /* replace656_1_1_0 -> 48 in the cache */
   /* replace656_1_1 -> 699 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fmax,
      0, 1,
      { 29, 699 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_flt,
      -1, 1,
      { 241, 1971 },
      -1,
   } },

   /* ('ior', ('flt', 0.0, 'a@32'), ('flt(is_used_once)', 'b@32', 0.0)) => ('flt', 0.0, ('fmax', 'a', ('fneg', 'b'))) */
   /* search657_0_0 -> 241 in the cache */
   /* search657_0_1 -> 29 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_flt,
      -1, 0,
      { 241, 29 },
      -1,
   } },
   /* search657_1_0 -> 48 in the cache */
   /* search657_1_1 -> 241 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_flt,
      -1, 0,
      { 48, 241 },
      0,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ior,
      0, 1,
      { 1973, 1974 },
      -1,
   } },

   /* replace657_0 -> 241 in the cache */
   /* replace657_1_0 -> 29 in the cache */
   /* replace657_1_1_0 -> 48 in the cache */
   /* replace657_1_1 -> 699 in the cache */
   /* replace657_1 -> 1971 in the cache */
   /* replace657 -> 1972 in the cache */

   /* ('ior', ('fge(is_used_once)', 0.0, 'a@32'), ('fge', 'b@32', 0.0)) => ('fge', 0.0, ('fmin', 'a', ('fneg', 'b'))) */
   /* search658_0_0 -> 241 in the cache */
   /* search658_0_1 -> 29 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fge,
      -1, 0,
      { 241, 29 },
      0,
   } },
   /* search658_1_0 -> 48 in the cache */
   /* search658_1_1 -> 241 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fge,
      -1, 0,
      { 48, 241 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ior,
      0, 1,
      { 1976, 1977 },
      -1,
   } },

   /* replace658_0 -> 241 in the cache */
   /* replace658_1_0 -> 29 in the cache */
   /* replace658_1_1_0 -> 48 in the cache */
   /* replace658_1_1 -> 699 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fmin,
      0, 1,
      { 29, 699 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fge,
      -1, 1,
      { 241, 1979 },
      -1,
   } },

   /* ('ior', ('fge', 0.0, 'a@32'), ('fge(is_used_once)', 'b@32', 0.0)) => ('fge', 0.0, ('fmin', 'a', ('fneg', 'b'))) */
   /* search659_0_0 -> 241 in the cache */
   /* search659_0_1 -> 29 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fge,
      -1, 0,
      { 241, 29 },
      -1,
   } },
   /* search659_1_0 -> 48 in the cache */
   /* search659_1_1 -> 241 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fge,
      -1, 0,
      { 48, 241 },
      0,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ior,
      0, 1,
      { 1981, 1982 },
      -1,
   } },

   /* replace659_0 -> 241 in the cache */
   /* replace659_1_0 -> 29 in the cache */
   /* replace659_1_1_0 -> 48 in the cache */
   /* replace659_1_1 -> 699 in the cache */
   /* replace659_1 -> 1979 in the cache */
   /* replace659 -> 1980 in the cache */

   /* ('~iand', ('flt(is_used_once)', 0.0, 'a@32'), ('flt', 'b@32', 0.0)) => ('flt', 0.0, ('fmin', 'a', ('fneg', 'b'))) */
   /* search660_0_0 -> 241 in the cache */
   /* search660_0_1 -> 29 in the cache */
   /* search660_0 -> 1968 in the cache */
   /* search660_1_0 -> 48 in the cache */
   /* search660_1_1 -> 241 in the cache */
   /* search660_1 -> 1969 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      true,
      false,
      false,
      false,
      false,
      false,
      nir_op_iand,
      0, 1,
      { 1968, 1969 },
      -1,
   } },

   /* replace660_0 -> 241 in the cache */
   /* replace660_1_0 -> 29 in the cache */
   /* replace660_1_1_0 -> 48 in the cache */
   /* replace660_1_1 -> 699 in the cache */
   /* replace660_1 -> 1979 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_flt,
      -1, 1,
      { 241, 1979 },
      -1,
   } },

   /* ('~iand', ('flt', 0.0, 'a@32'), ('flt(is_used_once)', 'b@32', 0.0)) => ('flt', 0.0, ('fmin', 'a', ('fneg', 'b'))) */
   /* search661_0_0 -> 241 in the cache */
   /* search661_0_1 -> 29 in the cache */
   /* search661_0 -> 1973 in the cache */
   /* search661_1_0 -> 48 in the cache */
   /* search661_1_1 -> 241 in the cache */
   /* search661_1 -> 1974 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      true,
      false,
      false,
      false,
      false,
      false,
      nir_op_iand,
      0, 1,
      { 1973, 1974 },
      -1,
   } },

   /* replace661_0 -> 241 in the cache */
   /* replace661_1_0 -> 29 in the cache */
   /* replace661_1_1_0 -> 48 in the cache */
   /* replace661_1_1 -> 699 in the cache */
   /* replace661_1 -> 1979 in the cache */
   /* replace661 -> 1985 in the cache */

   /* ('~iand', ('fge(is_used_once)', 0.0, 'a@32'), ('fge', 'b@32', 0.0)) => ('fge', 0.0, ('fmax', 'a', ('fneg', 'b'))) */
   /* search662_0_0 -> 241 in the cache */
   /* search662_0_1 -> 29 in the cache */
   /* search662_0 -> 1976 in the cache */
   /* search662_1_0 -> 48 in the cache */
   /* search662_1_1 -> 241 in the cache */
   /* search662_1 -> 1977 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      true,
      false,
      false,
      false,
      false,
      false,
      nir_op_iand,
      0, 1,
      { 1976, 1977 },
      -1,
   } },

   /* replace662_0 -> 241 in the cache */
   /* replace662_1_0 -> 29 in the cache */
   /* replace662_1_1_0 -> 48 in the cache */
   /* replace662_1_1 -> 699 in the cache */
   /* replace662_1 -> 1971 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fge,
      -1, 1,
      { 241, 1971 },
      -1,
   } },

   /* ('~iand', ('fge', 0.0, 'a@32'), ('fge(is_used_once)', 'b@32', 0.0)) => ('fge', 0.0, ('fmax', 'a', ('fneg', 'b'))) */
   /* search663_0_0 -> 241 in the cache */
   /* search663_0_1 -> 29 in the cache */
   /* search663_0 -> 1981 in the cache */
   /* search663_1_0 -> 48 in the cache */
   /* search663_1_1 -> 241 in the cache */
   /* search663_1 -> 1982 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      true,
      false,
      false,
      false,
      false,
      false,
      nir_op_iand,
      0, 1,
      { 1981, 1982 },
      -1,
   } },

   /* replace663_0 -> 241 in the cache */
   /* replace663_1_0 -> 29 in the cache */
   /* replace663_1_1_0 -> 48 in the cache */
   /* replace663_1_1 -> 699 in the cache */
   /* replace663_1 -> 1971 in the cache */
   /* replace663 -> 1988 in the cache */

   /* ('ior', ('feq(is_used_once)', 'a@32', 0.0), ('feq', 'b@32', 0.0)) => ('feq', ('fmin', ('fabs', 'a'), ('fabs', 'b')), 0.0) */
   /* search664_0_0 -> 29 in the cache */
   /* search664_0_1 -> 241 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_feq,
      1, 1,
      { 29, 241 },
      0,
   } },
   /* search664_1_0 -> 48 in the cache */
   /* search664_1_1 -> 241 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_feq,
      2, 1,
      { 48, 241 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ior,
      0, 3,
      { 1990, 1991 },
      -1,
   } },

   /* replace664_0_0_0 -> 29 in the cache */
   /* replace664_0_0 -> 423 in the cache */
   /* replace664_0_1_0 -> 48 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fabs,
      -1, 0,
      { 48 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fmin,
      1, 1,
      { 423, 1993 },
      -1,
   } },
   /* replace664_1 -> 241 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_feq,
      0, 2,
      { 1994, 241 },
      -1,
   } },

   /* ('ior', ('fneu(is_used_once)', 'a@32', 0.0), ('fneu', 'b@32', 0.0)) => ('fneu', ('fadd', ('fabs', 'a'), ('fabs', 'b')), 0.0) */
   /* search665_0_0 -> 29 in the cache */
   /* search665_0_1 -> 241 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fneu,
      1, 1,
      { 29, 241 },
      0,
   } },
   /* search665_1_0 -> 48 in the cache */
   /* search665_1_1 -> 241 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fneu,
      2, 1,
      { 48, 241 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ior,
      0, 3,
      { 1996, 1997 },
      -1,
   } },

   /* replace665_0_0_0 -> 29 in the cache */
   /* replace665_0_0 -> 423 in the cache */
   /* replace665_0_1_0 -> 48 in the cache */
   /* replace665_0_1 -> 1993 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fadd,
      1, 1,
      { 423, 1993 },
      -1,
   } },
   /* replace665_1 -> 241 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fneu,
      0, 2,
      { 1999, 241 },
      -1,
   } },

   /* ('iand', ('feq(is_used_once)', 'a@32', 0.0), ('feq', 'b@32', 0.0)) => ('feq', ('fadd', ('fabs', 'a'), ('fabs', 'b')), 0.0) */
   /* search666_0_0 -> 29 in the cache */
   /* search666_0_1 -> 241 in the cache */
   /* search666_0 -> 1990 in the cache */
   /* search666_1_0 -> 48 in the cache */
   /* search666_1_1 -> 241 in the cache */
   /* search666_1 -> 1991 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_iand,
      0, 3,
      { 1990, 1991 },
      -1,
   } },

   /* replace666_0_0_0 -> 29 in the cache */
   /* replace666_0_0 -> 423 in the cache */
   /* replace666_0_1_0 -> 48 in the cache */
   /* replace666_0_1 -> 1993 in the cache */
   /* replace666_0 -> 1999 in the cache */
   /* replace666_1 -> 241 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_feq,
      0, 2,
      { 1999, 241 },
      -1,
   } },

   /* ('iand', ('fneu(is_used_once)', 'a@32', 0.0), ('fneu', 'b@32', 0.0)) => ('fneu', ('fmin', ('fabs', 'a'), ('fabs', 'b')), 0.0) */
   /* search667_0_0 -> 29 in the cache */
   /* search667_0_1 -> 241 in the cache */
   /* search667_0 -> 1996 in the cache */
   /* search667_1_0 -> 48 in the cache */
   /* search667_1_1 -> 241 in the cache */
   /* search667_1 -> 1997 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_iand,
      0, 3,
      { 1996, 1997 },
      -1,
   } },

   /* replace667_0_0_0 -> 29 in the cache */
   /* replace667_0_0 -> 423 in the cache */
   /* replace667_0_1_0 -> 48 in the cache */
   /* replace667_0_1 -> 1993 in the cache */
   /* replace667_0 -> 1994 in the cache */
   /* replace667_1 -> 241 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fneu,
      0, 2,
      { 1994, 241 },
      -1,
   } },

   /* ('bcsel@32', ('feq', 'a', 0.0), 1.0, ('i2f32', ('iadd', ('b2i32', ('flt', 0.0, 'a@32')), ('ineg', ('b2i32', ('flt', 'a@32', 0.0)))))) => ('i2f32', ('iadd', ('b2i32', ('!fge', 'a', 0.0)), ('ineg', ('b2i32', ('!flt', 'a', 0.0))))) */
   /* search668_0_0 -> 29 in the cache */
   /* search668_0_1 -> 241 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_feq,
      0, 1,
      { 29, 241 },
      -1,
   } },
   /* search668_1 -> 261 in the cache */
   /* search668_2_0_0_0_0 -> 241 in the cache */
   /* search668_2_0_0_0_1 -> 29 in the cache */
   /* search668_2_0_0_0 -> 1973 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_b2i32,
      -1, 0,
      { 1973 },
      -1,
   } },
   /* search668_2_0_1_0_0_0 -> 29 in the cache */
   /* search668_2_0_1_0_0_1 -> 241 in the cache */
   /* search668_2_0_1_0_0 -> 795 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_b2i32,
      -1, 0,
      { 795 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ineg,
      -1, 0,
      { 2007 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_iadd,
      1, 1,
      { 2006, 2008 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_i2f32,
      -1, 1,
      { 2009 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_bcsel,
      -1, 2,
      { 2005, 261, 2010 },
      -1,
   } },

   /* replace668_0_0_0_0 -> 29 in the cache */
   /* replace668_0_0_0_1 -> 241 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      true,
      false,
      false,
      false,
      false,
      nir_op_fge,
      -1, 0,
      { 29, 241 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_b2i32,
      -1, 0,
      { 2012 },
      -1,
   } },
   /* replace668_0_1_0_0_0 -> 29 in the cache */
   /* replace668_0_1_0_0_1 -> 241 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      true,
      false,
      false,
      false,
      false,
      nir_op_flt,
      -1, 0,
      { 29, 241 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_b2i32,
      -1, 0,
      { 2014 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ineg,
      -1, 0,
      { 2015 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_iadd,
      0, 1,
      { 2013, 2016 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_i2f32,
      -1, 1,
      { 2017 },
      -1,
   } },

   /* ('bcsel', 'a', ('b2f(is_used_once)', 'b@32'), ('b2f', 'c@32')) => ('b2f', ('bcsel', 'a', 'b', 'c')) */
   /* search669_0 -> 859 in the cache */
   /* search669_1_0 -> 48 in the cache */
   { .expression = {
      { nir_search_value_expression, 0 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_search_op_b2f,
      -1, 0,
      { 48 },
      0,
   } },
   /* search669_2_0 -> 148 in the cache */
   { .expression = {
      { nir_search_value_expression, 0 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_search_op_b2f,
      -1, 0,
      { 148 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 0 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_bcsel,
      -1, 0,
      { 859, 2019, 2020 },
      -1,
   } },

   /* replace669_0_0 -> 859 in the cache */
   /* replace669_0_1 -> 48 in the cache */
   /* replace669_0_2 -> 148 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_bcsel,
      -1, 0,
      { 859, 48, 148 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 0 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_search_op_b2f,
      -1, 0,
      { 2022 },
      -1,
   } },

   /* ('~i2f32', ('f2i', 'a@32')) => ('ftrunc', 'a') */
   /* search670_0_0 -> 29 in the cache */
   { .expression = {
      { nir_search_value_expression, 0 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_search_op_f2i,
      -1, 0,
      { 29 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      true,
      false,
      false,
      false,
      false,
      false,
      nir_op_i2f32,
      -1, 0,
      { 2024 },
      -1,
   } },

   /* replace670_0 -> 29 in the cache */
   /* replace670 -> 794 in the cache */

   /* ('~f2i32', ('i2f', 'a@32')) => a */
   /* search671_0_0 -> 29 in the cache */
   { .expression = {
      { nir_search_value_expression, 0 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_search_op_i2f,
      -1, 0,
      { 29 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      true,
      false,
      false,
      false,
      false,
      false,
      nir_op_f2i32,
      -1, 0,
      { 2026 },
      -1,
   } },

   /* replace671 -> 29 in the cache */

   /* ('~f2i32', ('u2f', 'a@32')) => a */
   /* search672_0_0 -> 29 in the cache */
   { .expression = {
      { nir_search_value_expression, 0 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_search_op_u2f,
      -1, 0,
      { 29 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      true,
      false,
      false,
      false,
      false,
      false,
      nir_op_f2i32,
      -1, 0,
      { 2028 },
      -1,
   } },

   /* replace672 -> 29 in the cache */

   /* ('~f2u32', ('i2f', 'a@32')) => a */
   /* search673_0_0 -> 29 in the cache */
   /* search673_0 -> 2026 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      true,
      false,
      false,
      false,
      false,
      false,
      nir_op_f2u32,
      -1, 0,
      { 2026 },
      -1,
   } },

   /* replace673 -> 29 in the cache */

   /* ('~f2u32', ('u2f', 'a@32')) => a */
   /* search674_0_0 -> 29 in the cache */
   /* search674_0 -> 2028 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      true,
      false,
      false,
      false,
      false,
      false,
      nir_op_f2u32,
      -1, 0,
      { 2028 },
      -1,
   } },

   /* replace674 -> 29 in the cache */

   /* ('fadd', ('b2f32', ('flt', 0.0, 'a@32')), ('fneg', ('b2f32', ('flt', 'a@32', 0.0)))) => ('fsign', 'a') */
   /* search675_0_0_0 -> 241 in the cache */
   /* search675_0_0_1 -> 29 in the cache */
   /* search675_0_0 -> 1973 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_b2f32,
      -1, 0,
      { 1973 },
      -1,
   } },
   /* search675_1_0_0_0 -> 29 in the cache */
   /* search675_1_0_0_1 -> 241 in the cache */
   /* search675_1_0_0 -> 795 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_b2f32,
      -1, 0,
      { 795 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fneg,
      -1, 0,
      { 2033 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fadd,
      0, 1,
      { 2032, 2034 },
      -1,
   } },

   /* replace675_0 -> 29 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fsign,
      -1, 0,
      { 29 },
      -1,
   } },

   /* ('iadd', ('b2i32', ('flt', 0, 'a@32')), ('ineg', ('b2i32', ('flt', 'a@32', 0)))) => ('f2i32', ('fsign', 'a')) */
   /* search676_0_0_0 -> 135 in the cache */
   /* search676_0_0_1 -> 29 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_flt,
      -1, 0,
      { 135, 29 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_b2i32,
      -1, 0,
      { 2037 },
      -1,
   } },
   /* search676_1_0_0_0 -> 29 in the cache */
   /* search676_1_0_0_1 -> 135 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_flt,
      -1, 0,
      { 29, 135 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_b2i32,
      -1, 0,
      { 2039 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ineg,
      -1, 0,
      { 2040 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_iadd,
      0, 1,
      { 2038, 2041 },
      -1,
   } },

   /* replace676_0_0 -> 29 in the cache */
   /* replace676_0 -> 2036 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_f2i32,
      -1, 0,
      { 2036 },
      -1,
   } },

   /* ('~f2f32', ('f2f', 'a')) => ('f2f32', 'a') */
   /* search677_0_0 -> 9 in the cache */
   /* search677_0 -> 1935 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      true,
      false,
      false,
      false,
      false,
      false,
      nir_op_f2f32,
      -1, 0,
      { 1935 },
      -1,
   } },

   /* replace677_0 -> 9 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_f2f32,
      -1, 0,
      { 9 },
      -1,
   } },

   /* ('~f2f32', ('u2f', 'a')) => ('u2f32', 'a') */
   /* search678_0_0 -> 9 in the cache */
   /* search678_0 -> 123 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      true,
      false,
      false,
      false,
      false,
      false,
      nir_op_f2f32,
      -1, 0,
      { 123 },
      -1,
   } },

   /* replace678_0 -> 9 in the cache */
   /* replace678 -> 1954 in the cache */

   /* ('~f2f32', ('i2f', 'a')) => ('i2f32', 'a') */
   /* search679_0_0 -> 9 in the cache */
   /* search679_0 -> 1375 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      true,
      false,
      false,
      false,
      false,
      false,
      nir_op_f2f32,
      -1, 0,
      { 1375 },
      -1,
   } },

   /* replace679_0 -> 9 in the cache */
   /* replace679 -> 1956 in the cache */

   /* ('~f2u32', ('f2f', 'a')) => ('f2u32', 'a') */
   /* search680_0_0 -> 9 in the cache */
   /* search680_0 -> 1935 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      true,
      false,
      false,
      false,
      false,
      false,
      nir_op_f2u32,
      -1, 0,
      { 1935 },
      -1,
   } },

   /* replace680_0 -> 9 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_f2u32,
      -1, 0,
      { 9 },
      -1,
   } },

   /* ('~f2i32', ('f2f', 'a')) => ('f2i32', 'a') */
   /* search681_0_0 -> 9 in the cache */
   /* search681_0 -> 1935 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      true,
      false,
      false,
      false,
      false,
      false,
      nir_op_f2i32,
      -1, 0,
      { 1935 },
      -1,
   } },

   /* replace681_0 -> 9 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_f2i32,
      -1, 0,
      { 9 },
      -1,
   } },

   /* ('i2f32', ('f2i', ('fsign', 'a@32'))) => ('fsign', 'a') */
   /* search682_0_0_0 -> 29 in the cache */
   /* search682_0_0 -> 2036 in the cache */
   { .expression = {
      { nir_search_value_expression, 0 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_search_op_f2i,
      -1, 0,
      { 2036 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_i2f32,
      -1, 0,
      { 2052 },
      -1,
   } },

   /* replace682_0 -> 29 in the cache */
   /* replace682 -> 2036 in the cache */

   /* ('~f2f32', ('f2f64', 'a@32')) => a */
   /* search683_0_0 -> 29 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_f2f64,
      -1, 0,
      { 29 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      true,
      false,
      false,
      false,
      false,
      false,
      nir_op_f2f32,
      -1, 0,
      { 2054 },
      -1,
   } },

   /* replace683 -> 29 in the cache */

   /* ('f2u64', ('f2f64', 'a@32')) => ('f2u64', 'a') */
   /* search684_0_0 -> 29 in the cache */
   /* search684_0 -> 2054 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_f2u64,
      -1, 0,
      { 2054 },
      -1,
   } },

   /* replace684_0 -> 29 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_f2u64,
      -1, 0,
      { 29 },
      -1,
   } },

   /* ('f2i64', ('f2f64', 'a@32')) => ('f2i64', 'a') */
   /* search685_0_0 -> 29 in the cache */
   /* search685_0 -> 2054 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_f2i64,
      -1, 0,
      { 2054 },
      -1,
   } },

   /* replace685_0 -> 29 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_f2i64,
      -1, 0,
      { 29 },
      -1,
   } },

   /* ('f2f32', ('u2f64', 'a')) => ('u2f32', 'a') */
   /* search686_0_0 -> 9 in the cache */
   /* search686_0 -> 1964 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_f2f32,
      -1, 0,
      { 1964 },
      -1,
   } },

   /* replace686_0 -> 9 in the cache */
   /* replace686 -> 1954 in the cache */

   /* ('f2f32', ('i2f64', 'a')) => ('i2f32', 'a') */
   /* search687_0_0 -> 9 in the cache */
   /* search687_0 -> 1966 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_f2f32,
      -1, 0,
      { 1966 },
      -1,
   } },

   /* replace687_0 -> 9 in the cache */
   /* replace687 -> 1956 in the cache */

   /* ('ior', ('flt(is_used_once)', 0.0, 'a@64'), ('flt', 'b@64', 0.0)) => ('flt', 0.0, ('fmax', 'a', ('fneg', 'b'))) */
   /* search688_0_0 -> 800 in the cache */
   /* search688_0_1 -> 34 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_flt,
      -1, 0,
      { 800, 34 },
      0,
   } },
   /* search688_1_0 -> 53 in the cache */
   /* search688_1_1 -> 800 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_flt,
      -1, 0,
      { 53, 800 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ior,
      0, 1,
      { 2062, 2063 },
      -1,
   } },

   /* replace688_0 -> 800 in the cache */
   /* replace688_1_0 -> 34 in the cache */
   /* replace688_1_1_0 -> 53 in the cache */
   /* replace688_1_1 -> 772 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fmax,
      0, 1,
      { 34, 772 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_flt,
      -1, 1,
      { 800, 2065 },
      -1,
   } },

   /* ('ior', ('flt', 0.0, 'a@64'), ('flt(is_used_once)', 'b@64', 0.0)) => ('flt', 0.0, ('fmax', 'a', ('fneg', 'b'))) */
   /* search689_0_0 -> 800 in the cache */
   /* search689_0_1 -> 34 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_flt,
      -1, 0,
      { 800, 34 },
      -1,
   } },
   /* search689_1_0 -> 53 in the cache */
   /* search689_1_1 -> 800 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_flt,
      -1, 0,
      { 53, 800 },
      0,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ior,
      0, 1,
      { 2067, 2068 },
      -1,
   } },

   /* replace689_0 -> 800 in the cache */
   /* replace689_1_0 -> 34 in the cache */
   /* replace689_1_1_0 -> 53 in the cache */
   /* replace689_1_1 -> 772 in the cache */
   /* replace689_1 -> 2065 in the cache */
   /* replace689 -> 2066 in the cache */

   /* ('ior', ('fge(is_used_once)', 0.0, 'a@64'), ('fge', 'b@64', 0.0)) => ('fge', 0.0, ('fmin', 'a', ('fneg', 'b'))) */
   /* search690_0_0 -> 800 in the cache */
   /* search690_0_1 -> 34 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fge,
      -1, 0,
      { 800, 34 },
      0,
   } },
   /* search690_1_0 -> 53 in the cache */
   /* search690_1_1 -> 800 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fge,
      -1, 0,
      { 53, 800 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ior,
      0, 1,
      { 2070, 2071 },
      -1,
   } },

   /* replace690_0 -> 800 in the cache */
   /* replace690_1_0 -> 34 in the cache */
   /* replace690_1_1_0 -> 53 in the cache */
   /* replace690_1_1 -> 772 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fmin,
      0, 1,
      { 34, 772 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fge,
      -1, 1,
      { 800, 2073 },
      -1,
   } },

   /* ('ior', ('fge', 0.0, 'a@64'), ('fge(is_used_once)', 'b@64', 0.0)) => ('fge', 0.0, ('fmin', 'a', ('fneg', 'b'))) */
   /* search691_0_0 -> 800 in the cache */
   /* search691_0_1 -> 34 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fge,
      -1, 0,
      { 800, 34 },
      -1,
   } },
   /* search691_1_0 -> 53 in the cache */
   /* search691_1_1 -> 800 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fge,
      -1, 0,
      { 53, 800 },
      0,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ior,
      0, 1,
      { 2075, 2076 },
      -1,
   } },

   /* replace691_0 -> 800 in the cache */
   /* replace691_1_0 -> 34 in the cache */
   /* replace691_1_1_0 -> 53 in the cache */
   /* replace691_1_1 -> 772 in the cache */
   /* replace691_1 -> 2073 in the cache */
   /* replace691 -> 2074 in the cache */

   /* ('~iand', ('flt(is_used_once)', 0.0, 'a@64'), ('flt', 'b@64', 0.0)) => ('flt', 0.0, ('fmin', 'a', ('fneg', 'b'))) */
   /* search692_0_0 -> 800 in the cache */
   /* search692_0_1 -> 34 in the cache */
   /* search692_0 -> 2062 in the cache */
   /* search692_1_0 -> 53 in the cache */
   /* search692_1_1 -> 800 in the cache */
   /* search692_1 -> 2063 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      true,
      false,
      false,
      false,
      false,
      false,
      nir_op_iand,
      0, 1,
      { 2062, 2063 },
      -1,
   } },

   /* replace692_0 -> 800 in the cache */
   /* replace692_1_0 -> 34 in the cache */
   /* replace692_1_1_0 -> 53 in the cache */
   /* replace692_1_1 -> 772 in the cache */
   /* replace692_1 -> 2073 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_flt,
      -1, 1,
      { 800, 2073 },
      -1,
   } },

   /* ('~iand', ('flt', 0.0, 'a@64'), ('flt(is_used_once)', 'b@64', 0.0)) => ('flt', 0.0, ('fmin', 'a', ('fneg', 'b'))) */
   /* search693_0_0 -> 800 in the cache */
   /* search693_0_1 -> 34 in the cache */
   /* search693_0 -> 2067 in the cache */
   /* search693_1_0 -> 53 in the cache */
   /* search693_1_1 -> 800 in the cache */
   /* search693_1 -> 2068 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      true,
      false,
      false,
      false,
      false,
      false,
      nir_op_iand,
      0, 1,
      { 2067, 2068 },
      -1,
   } },

   /* replace693_0 -> 800 in the cache */
   /* replace693_1_0 -> 34 in the cache */
   /* replace693_1_1_0 -> 53 in the cache */
   /* replace693_1_1 -> 772 in the cache */
   /* replace693_1 -> 2073 in the cache */
   /* replace693 -> 2079 in the cache */

   /* ('~iand', ('fge(is_used_once)', 0.0, 'a@64'), ('fge', 'b@64', 0.0)) => ('fge', 0.0, ('fmax', 'a', ('fneg', 'b'))) */
   /* search694_0_0 -> 800 in the cache */
   /* search694_0_1 -> 34 in the cache */
   /* search694_0 -> 2070 in the cache */
   /* search694_1_0 -> 53 in the cache */
   /* search694_1_1 -> 800 in the cache */
   /* search694_1 -> 2071 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      true,
      false,
      false,
      false,
      false,
      false,
      nir_op_iand,
      0, 1,
      { 2070, 2071 },
      -1,
   } },

   /* replace694_0 -> 800 in the cache */
   /* replace694_1_0 -> 34 in the cache */
   /* replace694_1_1_0 -> 53 in the cache */
   /* replace694_1_1 -> 772 in the cache */
   /* replace694_1 -> 2065 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fge,
      -1, 1,
      { 800, 2065 },
      -1,
   } },

   /* ('~iand', ('fge', 0.0, 'a@64'), ('fge(is_used_once)', 'b@64', 0.0)) => ('fge', 0.0, ('fmax', 'a', ('fneg', 'b'))) */
   /* search695_0_0 -> 800 in the cache */
   /* search695_0_1 -> 34 in the cache */
   /* search695_0 -> 2075 in the cache */
   /* search695_1_0 -> 53 in the cache */
   /* search695_1_1 -> 800 in the cache */
   /* search695_1 -> 2076 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      true,
      false,
      false,
      false,
      false,
      false,
      nir_op_iand,
      0, 1,
      { 2075, 2076 },
      -1,
   } },

   /* replace695_0 -> 800 in the cache */
   /* replace695_1_0 -> 34 in the cache */
   /* replace695_1_1_0 -> 53 in the cache */
   /* replace695_1_1 -> 772 in the cache */
   /* replace695_1 -> 2065 in the cache */
   /* replace695 -> 2082 in the cache */

   /* ('ior', ('feq(is_used_once)', 'a@64', 0.0), ('feq', 'b@64', 0.0)) => ('feq', ('fmin', ('fabs', 'a'), ('fabs', 'b')), 0.0) */
   /* search696_0_0 -> 34 in the cache */
   /* search696_0_1 -> 800 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_feq,
      1, 1,
      { 34, 800 },
      0,
   } },
   /* search696_1_0 -> 53 in the cache */
   /* search696_1_1 -> 800 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_feq,
      2, 1,
      { 53, 800 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ior,
      0, 3,
      { 2084, 2085 },
      -1,
   } },

   /* replace696_0_0_0 -> 34 in the cache */
   /* replace696_0_0 -> 802 in the cache */
   /* replace696_0_1_0 -> 53 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fabs,
      -1, 0,
      { 53 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fmin,
      1, 1,
      { 802, 2087 },
      -1,
   } },
   /* replace696_1 -> 800 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_feq,
      0, 2,
      { 2088, 800 },
      -1,
   } },

   /* ('ior', ('fneu(is_used_once)', 'a@64', 0.0), ('fneu', 'b@64', 0.0)) => ('fneu', ('fadd', ('fabs', 'a'), ('fabs', 'b')), 0.0) */
   /* search697_0_0 -> 34 in the cache */
   /* search697_0_1 -> 800 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fneu,
      1, 1,
      { 34, 800 },
      0,
   } },
   /* search697_1_0 -> 53 in the cache */
   /* search697_1_1 -> 800 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fneu,
      2, 1,
      { 53, 800 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ior,
      0, 3,
      { 2090, 2091 },
      -1,
   } },

   /* replace697_0_0_0 -> 34 in the cache */
   /* replace697_0_0 -> 802 in the cache */
   /* replace697_0_1_0 -> 53 in the cache */
   /* replace697_0_1 -> 2087 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fadd,
      1, 1,
      { 802, 2087 },
      -1,
   } },
   /* replace697_1 -> 800 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fneu,
      0, 2,
      { 2093, 800 },
      -1,
   } },

   /* ('iand', ('feq(is_used_once)', 'a@64', 0.0), ('feq', 'b@64', 0.0)) => ('feq', ('fadd', ('fabs', 'a'), ('fabs', 'b')), 0.0) */
   /* search698_0_0 -> 34 in the cache */
   /* search698_0_1 -> 800 in the cache */
   /* search698_0 -> 2084 in the cache */
   /* search698_1_0 -> 53 in the cache */
   /* search698_1_1 -> 800 in the cache */
   /* search698_1 -> 2085 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_iand,
      0, 3,
      { 2084, 2085 },
      -1,
   } },

   /* replace698_0_0_0 -> 34 in the cache */
   /* replace698_0_0 -> 802 in the cache */
   /* replace698_0_1_0 -> 53 in the cache */
   /* replace698_0_1 -> 2087 in the cache */
   /* replace698_0 -> 2093 in the cache */
   /* replace698_1 -> 800 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_feq,
      0, 2,
      { 2093, 800 },
      -1,
   } },

   /* ('iand', ('fneu(is_used_once)', 'a@64', 0.0), ('fneu', 'b@64', 0.0)) => ('fneu', ('fmin', ('fabs', 'a'), ('fabs', 'b')), 0.0) */
   /* search699_0_0 -> 34 in the cache */
   /* search699_0_1 -> 800 in the cache */
   /* search699_0 -> 2090 in the cache */
   /* search699_1_0 -> 53 in the cache */
   /* search699_1_1 -> 800 in the cache */
   /* search699_1 -> 2091 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_iand,
      0, 3,
      { 2090, 2091 },
      -1,
   } },

   /* replace699_0_0_0 -> 34 in the cache */
   /* replace699_0_0 -> 802 in the cache */
   /* replace699_0_1_0 -> 53 in the cache */
   /* replace699_0_1 -> 2087 in the cache */
   /* replace699_0 -> 2088 in the cache */
   /* replace699_1 -> 800 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fneu,
      0, 2,
      { 2088, 800 },
      -1,
   } },

   /* ('bcsel@64', ('feq', 'a', 0.0), 1.0, ('i2f64', ('iadd', ('b2i64', ('flt', 0.0, 'a@64')), ('ineg', ('b2i64', ('flt', 'a@64', 0.0)))))) => ('i2f64', ('iadd', ('b2i32', ('!fge', 'a', 0.0)), ('ineg', ('b2i32', ('!flt', 'a', 0.0))))) */
   /* search700_0_0 -> 34 in the cache */
   /* search700_0_1 -> 800 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_feq,
      0, 1,
      { 34, 800 },
      -1,
   } },
   /* search700_1 -> 721 in the cache */
   /* search700_2_0_0_0_0 -> 800 in the cache */
   /* search700_2_0_0_0_1 -> 34 in the cache */
   /* search700_2_0_0_0 -> 2067 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_b2i64,
      -1, 0,
      { 2067 },
      -1,
   } },
   /* search700_2_0_1_0_0_0 -> 34 in the cache */
   /* search700_2_0_1_0_0_1 -> 800 in the cache */
   /* search700_2_0_1_0_0 -> 801 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_b2i64,
      -1, 0,
      { 801 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ineg,
      -1, 0,
      { 2101 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_iadd,
      1, 1,
      { 2100, 2102 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_i2f64,
      -1, 1,
      { 2103 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_bcsel,
      -1, 2,
      { 2099, 721, 2104 },
      -1,
   } },

   /* replace700_0_0_0_0 -> 34 in the cache */
   /* replace700_0_0_0_1 -> 800 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      true,
      false,
      false,
      false,
      false,
      nir_op_fge,
      -1, 0,
      { 34, 800 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_b2i32,
      -1, 0,
      { 2106 },
      -1,
   } },
   /* replace700_0_1_0_0_0 -> 34 in the cache */
   /* replace700_0_1_0_0_1 -> 800 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      true,
      false,
      false,
      false,
      false,
      nir_op_flt,
      -1, 0,
      { 34, 800 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_b2i32,
      -1, 0,
      { 2108 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ineg,
      -1, 0,
      { 2109 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_iadd,
      0, 1,
      { 2107, 2110 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_i2f64,
      -1, 1,
      { 2111 },
      -1,
   } },

   /* ('bcsel', 'a', ('b2f(is_used_once)', 'b@64'), ('b2f', 'c@64')) => ('b2f', ('bcsel', 'a', 'b', 'c')) */
   /* search701_0 -> 859 in the cache */
   /* search701_1_0 -> 53 in the cache */
   { .expression = {
      { nir_search_value_expression, 0 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_search_op_b2f,
      -1, 0,
      { 53 },
      0,
   } },
   /* search701_2_0 -> 709 in the cache */
   { .expression = {
      { nir_search_value_expression, 0 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_search_op_b2f,
      -1, 0,
      { 709 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 0 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_bcsel,
      -1, 0,
      { 859, 2113, 2114 },
      -1,
   } },

   /* replace701_0_0 -> 859 in the cache */
   /* replace701_0_1 -> 53 in the cache */
   /* replace701_0_2 -> 709 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_bcsel,
      -1, 0,
      { 859, 53, 709 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 0 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_search_op_b2f,
      -1, 0,
      { 2116 },
      -1,
   } },

   /* ('~i2f64', ('f2i', 'a@64')) => ('ftrunc', 'a') */
   /* search702_0_0 -> 34 in the cache */
   { .expression = {
      { nir_search_value_expression, 0 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_search_op_f2i,
      -1, 0,
      { 34 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 64 },
      true,
      false,
      false,
      false,
      false,
      false,
      nir_op_i2f64,
      -1, 0,
      { 2118 },
      -1,
   } },

   /* replace702_0 -> 34 in the cache */
   /* replace702 -> 799 in the cache */

   /* ('~f2i64', ('i2f', 'a@64')) => a */
   /* search703_0_0 -> 34 in the cache */
   { .expression = {
      { nir_search_value_expression, 0 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_search_op_i2f,
      -1, 0,
      { 34 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 64 },
      true,
      false,
      false,
      false,
      false,
      false,
      nir_op_f2i64,
      -1, 0,
      { 2120 },
      -1,
   } },

   /* replace703 -> 34 in the cache */

   /* ('~f2i64', ('u2f', 'a@64')) => a */
   /* search704_0_0 -> 34 in the cache */
   { .expression = {
      { nir_search_value_expression, 0 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_search_op_u2f,
      -1, 0,
      { 34 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 64 },
      true,
      false,
      false,
      false,
      false,
      false,
      nir_op_f2i64,
      -1, 0,
      { 2122 },
      -1,
   } },

   /* replace704 -> 34 in the cache */

   /* ('~f2u64', ('i2f', 'a@64')) => a */
   /* search705_0_0 -> 34 in the cache */
   /* search705_0 -> 2120 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      true,
      false,
      false,
      false,
      false,
      false,
      nir_op_f2u64,
      -1, 0,
      { 2120 },
      -1,
   } },

   /* replace705 -> 34 in the cache */

   /* ('~f2u64', ('u2f', 'a@64')) => a */
   /* search706_0_0 -> 34 in the cache */
   /* search706_0 -> 2122 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      true,
      false,
      false,
      false,
      false,
      false,
      nir_op_f2u64,
      -1, 0,
      { 2122 },
      -1,
   } },

   /* replace706 -> 34 in the cache */

   /* ('fadd', ('b2f64', ('flt', 0.0, 'a@64')), ('fneg', ('b2f64', ('flt', 'a@64', 0.0)))) => ('fsign', 'a') */
   /* search707_0_0_0 -> 800 in the cache */
   /* search707_0_0_1 -> 34 in the cache */
   /* search707_0_0 -> 2067 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_b2f64,
      -1, 0,
      { 2067 },
      -1,
   } },
   /* search707_1_0_0_0 -> 34 in the cache */
   /* search707_1_0_0_1 -> 800 in the cache */
   /* search707_1_0_0 -> 801 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_b2f64,
      -1, 0,
      { 801 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fneg,
      -1, 0,
      { 2127 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fadd,
      0, 1,
      { 2126, 2128 },
      -1,
   } },

   /* replace707_0 -> 34 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fsign,
      -1, 0,
      { 34 },
      -1,
   } },

   /* ('iadd', ('b2i64', ('flt', 0, 'a@64')), ('ineg', ('b2i64', ('flt', 'a@64', 0)))) => ('f2i64', ('fsign', 'a')) */
   /* search708_0_0_0 -> 999 in the cache */
   /* search708_0_0_1 -> 34 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_flt,
      -1, 0,
      { 999, 34 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_b2i64,
      -1, 0,
      { 2131 },
      -1,
   } },
   /* search708_1_0_0_0 -> 34 in the cache */
   /* search708_1_0_0_1 -> 999 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_flt,
      -1, 0,
      { 34, 999 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_b2i64,
      -1, 0,
      { 2133 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ineg,
      -1, 0,
      { 2134 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_iadd,
      0, 1,
      { 2132, 2135 },
      -1,
   } },

   /* replace708_0_0 -> 34 in the cache */
   /* replace708_0 -> 2130 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_f2i64,
      -1, 0,
      { 2130 },
      -1,
   } },

   /* ('~f2f64', ('f2f', 'a')) => ('f2f64', 'a') */
   /* search709_0_0 -> 9 in the cache */
   /* search709_0 -> 1935 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      true,
      false,
      false,
      false,
      false,
      false,
      nir_op_f2f64,
      -1, 0,
      { 1935 },
      -1,
   } },

   /* replace709_0 -> 9 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_f2f64,
      -1, 0,
      { 9 },
      -1,
   } },

   /* ('~f2f64', ('u2f', 'a')) => ('u2f64', 'a') */
   /* search710_0_0 -> 9 in the cache */
   /* search710_0 -> 123 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      true,
      false,
      false,
      false,
      false,
      false,
      nir_op_f2f64,
      -1, 0,
      { 123 },
      -1,
   } },

   /* replace710_0 -> 9 in the cache */
   /* replace710 -> 1964 in the cache */

   /* ('~f2f64', ('i2f', 'a')) => ('i2f64', 'a') */
   /* search711_0_0 -> 9 in the cache */
   /* search711_0 -> 1375 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      true,
      false,
      false,
      false,
      false,
      false,
      nir_op_f2f64,
      -1, 0,
      { 1375 },
      -1,
   } },

   /* replace711_0 -> 9 in the cache */
   /* replace711 -> 1966 in the cache */

   /* ('~f2u64', ('f2f', 'a')) => ('f2u64', 'a') */
   /* search712_0_0 -> 9 in the cache */
   /* search712_0 -> 1935 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      true,
      false,
      false,
      false,
      false,
      false,
      nir_op_f2u64,
      -1, 0,
      { 1935 },
      -1,
   } },

   /* replace712_0 -> 9 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_f2u64,
      -1, 0,
      { 9 },
      -1,
   } },

   /* ('~f2i64', ('f2f', 'a')) => ('f2i64', 'a') */
   /* search713_0_0 -> 9 in the cache */
   /* search713_0 -> 1935 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      true,
      false,
      false,
      false,
      false,
      false,
      nir_op_f2i64,
      -1, 0,
      { 1935 },
      -1,
   } },

   /* replace713_0 -> 9 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_f2i64,
      -1, 0,
      { 9 },
      -1,
   } },

   /* ('i2f64', ('f2i', ('fsign', 'a@64'))) => ('fsign', 'a') */
   /* search714_0_0_0 -> 34 in the cache */
   /* search714_0_0 -> 2130 in the cache */
   { .expression = {
      { nir_search_value_expression, 0 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_search_op_f2i,
      -1, 0,
      { 2130 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_i2f64,
      -1, 0,
      { 2146 },
      -1,
   } },

   /* replace714_0 -> 34 in the cache */
   /* replace714 -> 2130 in the cache */

   /* ('i2i1', ('i2i8', 'a@1')) => a */
   /* search715_0_0 -> 859 in the cache */
   { .expression = {
      { nir_search_value_expression, 8 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_i2i8,
      -1, 0,
      { 859 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_i2i1,
      -1, 0,
      { 2148 },
      -1,
   } },

   /* replace715 -> 859 in the cache */

   /* ('u2u1', ('u2u8', 'a@1')) => a */
   /* search716_0_0 -> 859 in the cache */
   { .expression = {
      { nir_search_value_expression, 8 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_u2u8,
      -1, 0,
      { 859 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_u2u1,
      -1, 0,
      { 2150 },
      -1,
   } },

   /* replace716 -> 859 in the cache */

   /* ('i2i1', ('i2i16', 'a@1')) => a */
   /* search717_0_0 -> 859 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_i2i16,
      -1, 0,
      { 859 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_i2i1,
      -1, 0,
      { 2152 },
      -1,
   } },

   /* replace717 -> 859 in the cache */

   /* ('u2u1', ('u2u16', 'a@1')) => a */
   /* search718_0_0 -> 859 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_u2u16,
      -1, 0,
      { 859 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_u2u1,
      -1, 0,
      { 2154 },
      -1,
   } },

   /* replace718 -> 859 in the cache */

   /* ('u2f16', ('u2u8', 'a@1')) => ('u2f16', 'a') */
   /* search719_0_0 -> 859 in the cache */
   /* search719_0 -> 2150 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_u2f16,
      -1, 0,
      { 2150 },
      -1,
   } },

   /* replace719_0 -> 859 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_u2f16,
      -1, 0,
      { 859 },
      -1,
   } },

   /* ('i2f16', ('i2i8', 'a@1')) => ('i2f16', 'a') */
   /* search720_0_0 -> 859 in the cache */
   /* search720_0 -> 2148 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_i2f16,
      -1, 0,
      { 2148 },
      -1,
   } },

   /* replace720_0 -> 859 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_i2f16,
      -1, 0,
      { 859 },
      -1,
   } },

   /* ('u2f16', ('u2u16', 'a@1')) => ('u2f16', 'a') */
   /* search721_0_0 -> 859 in the cache */
   /* search721_0 -> 2154 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_u2f16,
      -1, 0,
      { 2154 },
      -1,
   } },

   /* replace721_0 -> 859 in the cache */
   /* replace721 -> 2157 in the cache */

   /* ('i2f16', ('i2i16', 'a@1')) => ('i2f16', 'a') */
   /* search722_0_0 -> 859 in the cache */
   /* search722_0 -> 2152 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_i2f16,
      -1, 0,
      { 2152 },
      -1,
   } },

   /* replace722_0 -> 859 in the cache */
   /* replace722 -> 2159 in the cache */

   /* ('u2f16', ('u2u32', 'a@1')) => ('u2f16', 'a') */
   /* search723_0_0 -> 859 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_u2u32,
      -1, 0,
      { 859 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_u2f16,
      -1, 0,
      { 2162 },
      -1,
   } },

   /* replace723_0 -> 859 in the cache */
   /* replace723 -> 2157 in the cache */

   /* ('i2f16', ('i2i32', 'a@1')) => ('i2f16', 'a') */
   /* search724_0_0 -> 859 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_i2i32,
      -1, 0,
      { 859 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_i2f16,
      -1, 0,
      { 2164 },
      -1,
   } },

   /* replace724_0 -> 859 in the cache */
   /* replace724 -> 2159 in the cache */

   /* ('u2f16', ('u2u64', 'a@1')) => ('u2f16', 'a') */
   /* search725_0_0 -> 859 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_u2u64,
      -1, 0,
      { 859 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_u2f16,
      -1, 0,
      { 2166 },
      -1,
   } },

   /* replace725_0 -> 859 in the cache */
   /* replace725 -> 2157 in the cache */

   /* ('i2f16', ('i2i64', 'a@1')) => ('i2f16', 'a') */
   /* search726_0_0 -> 859 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_i2i64,
      -1, 0,
      { 859 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_i2f16,
      -1, 0,
      { 2168 },
      -1,
   } },

   /* replace726_0 -> 859 in the cache */
   /* replace726 -> 2159 in the cache */

   /* ('i2i1', ('i2i32', 'a@1')) => a */
   /* search727_0_0 -> 859 in the cache */
   /* search727_0 -> 2164 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_i2i1,
      -1, 0,
      { 2164 },
      -1,
   } },

   /* replace727 -> 859 in the cache */

   /* ('u2u1', ('u2u32', 'a@1')) => a */
   /* search728_0_0 -> 859 in the cache */
   /* search728_0 -> 2162 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_u2u1,
      -1, 0,
      { 2162 },
      -1,
   } },

   /* replace728 -> 859 in the cache */

   /* ('u2f32', ('u2u8', 'a@1')) => ('u2f32', 'a') */
   /* search729_0_0 -> 859 in the cache */
   /* search729_0 -> 2150 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_u2f32,
      -1, 0,
      { 2150 },
      -1,
   } },

   /* replace729_0 -> 859 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_u2f32,
      -1, 0,
      { 859 },
      -1,
   } },

   /* ('i2f32', ('i2i8', 'a@1')) => ('i2f32', 'a') */
   /* search730_0_0 -> 859 in the cache */
   /* search730_0 -> 2148 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_i2f32,
      -1, 0,
      { 2148 },
      -1,
   } },

   /* replace730_0 -> 859 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_i2f32,
      -1, 0,
      { 859 },
      -1,
   } },

   /* ('u2f32', ('u2u16', 'a@1')) => ('u2f32', 'a') */
   /* search731_0_0 -> 859 in the cache */
   /* search731_0 -> 2154 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_u2f32,
      -1, 0,
      { 2154 },
      -1,
   } },

   /* replace731_0 -> 859 in the cache */
   /* replace731 -> 2173 in the cache */

   /* ('i2f32', ('i2i16', 'a@1')) => ('i2f32', 'a') */
   /* search732_0_0 -> 859 in the cache */
   /* search732_0 -> 2152 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_i2f32,
      -1, 0,
      { 2152 },
      -1,
   } },

   /* replace732_0 -> 859 in the cache */
   /* replace732 -> 2175 in the cache */

   /* ('u2f32', ('u2u32', 'a@1')) => ('u2f32', 'a') */
   /* search733_0_0 -> 859 in the cache */
   /* search733_0 -> 2162 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_u2f32,
      -1, 0,
      { 2162 },
      -1,
   } },

   /* replace733_0 -> 859 in the cache */
   /* replace733 -> 2173 in the cache */

   /* ('i2f32', ('i2i32', 'a@1')) => ('i2f32', 'a') */
   /* search734_0_0 -> 859 in the cache */
   /* search734_0 -> 2164 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_i2f32,
      -1, 0,
      { 2164 },
      -1,
   } },

   /* replace734_0 -> 859 in the cache */
   /* replace734 -> 2175 in the cache */

   /* ('u2f32', ('u2u64', 'a@1')) => ('u2f32', 'a') */
   /* search735_0_0 -> 859 in the cache */
   /* search735_0 -> 2166 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_u2f32,
      -1, 0,
      { 2166 },
      -1,
   } },

   /* replace735_0 -> 859 in the cache */
   /* replace735 -> 2173 in the cache */

   /* ('i2f32', ('i2i64', 'a@1')) => ('i2f32', 'a') */
   /* search736_0_0 -> 859 in the cache */
   /* search736_0 -> 2168 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_i2f32,
      -1, 0,
      { 2168 },
      -1,
   } },

   /* replace736_0 -> 859 in the cache */
   /* replace736 -> 2175 in the cache */

   /* ('i2i1', ('i2i64', 'a@1')) => a */
   /* search737_0_0 -> 859 in the cache */
   /* search737_0 -> 2168 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_i2i1,
      -1, 0,
      { 2168 },
      -1,
   } },

   /* replace737 -> 859 in the cache */

   /* ('u2u1', ('u2u64', 'a@1')) => a */
   /* search738_0_0 -> 859 in the cache */
   /* search738_0 -> 2166 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_u2u1,
      -1, 0,
      { 2166 },
      -1,
   } },

   /* replace738 -> 859 in the cache */

   /* ('u2f64', ('u2u8', 'a@1')) => ('u2f64', 'a') */
   /* search739_0_0 -> 859 in the cache */
   /* search739_0 -> 2150 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_u2f64,
      -1, 0,
      { 2150 },
      -1,
   } },

   /* replace739_0 -> 859 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_u2f64,
      -1, 0,
      { 859 },
      -1,
   } },

   /* ('i2f64', ('i2i8', 'a@1')) => ('i2f64', 'a') */
   /* search740_0_0 -> 859 in the cache */
   /* search740_0 -> 2148 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_i2f64,
      -1, 0,
      { 2148 },
      -1,
   } },

   /* replace740_0 -> 859 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_i2f64,
      -1, 0,
      { 859 },
      -1,
   } },

   /* ('u2f64', ('u2u16', 'a@1')) => ('u2f64', 'a') */
   /* search741_0_0 -> 859 in the cache */
   /* search741_0 -> 2154 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_u2f64,
      -1, 0,
      { 2154 },
      -1,
   } },

   /* replace741_0 -> 859 in the cache */
   /* replace741 -> 2185 in the cache */

   /* ('i2f64', ('i2i16', 'a@1')) => ('i2f64', 'a') */
   /* search742_0_0 -> 859 in the cache */
   /* search742_0 -> 2152 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_i2f64,
      -1, 0,
      { 2152 },
      -1,
   } },

   /* replace742_0 -> 859 in the cache */
   /* replace742 -> 2187 in the cache */

   /* ('u2f64', ('u2u32', 'a@1')) => ('u2f64', 'a') */
   /* search743_0_0 -> 859 in the cache */
   /* search743_0 -> 2162 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_u2f64,
      -1, 0,
      { 2162 },
      -1,
   } },

   /* replace743_0 -> 859 in the cache */
   /* replace743 -> 2185 in the cache */

   /* ('i2f64', ('i2i32', 'a@1')) => ('i2f64', 'a') */
   /* search744_0_0 -> 859 in the cache */
   /* search744_0 -> 2164 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_i2f64,
      -1, 0,
      { 2164 },
      -1,
   } },

   /* replace744_0 -> 859 in the cache */
   /* replace744 -> 2187 in the cache */

   /* ('u2f64', ('u2u64', 'a@1')) => ('u2f64', 'a') */
   /* search745_0_0 -> 859 in the cache */
   /* search745_0 -> 2166 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_u2f64,
      -1, 0,
      { 2166 },
      -1,
   } },

   /* replace745_0 -> 859 in the cache */
   /* replace745 -> 2185 in the cache */

   /* ('i2f64', ('i2i64', 'a@1')) => ('i2f64', 'a') */
   /* search746_0_0 -> 859 in the cache */
   /* search746_0 -> 2168 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_i2f64,
      -1, 0,
      { 2168 },
      -1,
   } },

   /* replace746_0 -> 859 in the cache */
   /* replace746 -> 2187 in the cache */

   /* ('i2i8', ('i2i16', 'a@8')) => a */
   /* search747_0_0 -> 19 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_i2i16,
      -1, 0,
      { 19 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 8 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_i2i8,
      -1, 0,
      { 2194 },
      -1,
   } },

   /* replace747 -> 19 in the cache */

   /* ('u2u8', ('u2u16', 'a@8')) => a */
   /* search748_0_0 -> 19 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_u2u16,
      -1, 0,
      { 19 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 8 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_u2u8,
      -1, 0,
      { 2196 },
      -1,
   } },

   /* replace748 -> 19 in the cache */

   /* ('u2f16', ('u2u16', 'a@8')) => ('u2f16', 'a') */
   /* search749_0_0 -> 19 in the cache */
   /* search749_0 -> 2196 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_u2f16,
      -1, 0,
      { 2196 },
      -1,
   } },

   /* replace749_0 -> 19 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_u2f16,
      -1, 0,
      { 19 },
      -1,
   } },

   /* ('i2f16', ('i2i16', 'a@8')) => ('i2f16', 'a') */
   /* search750_0_0 -> 19 in the cache */
   /* search750_0 -> 2194 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_i2f16,
      -1, 0,
      { 2194 },
      -1,
   } },

   /* replace750_0 -> 19 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_i2f16,
      -1, 0,
      { 19 },
      -1,
   } },

   /* ('u2f16', ('u2u32', 'a@8')) => ('u2f16', 'a') */
   /* search751_0_0 -> 19 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_u2u32,
      -1, 0,
      { 19 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_u2f16,
      -1, 0,
      { 2202 },
      -1,
   } },

   /* replace751_0 -> 19 in the cache */
   /* replace751 -> 2199 in the cache */

   /* ('i2f16', ('i2i32', 'a@8')) => ('i2f16', 'a') */
   /* search752_0_0 -> 19 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_i2i32,
      -1, 0,
      { 19 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_i2f16,
      -1, 0,
      { 2204 },
      -1,
   } },

   /* replace752_0 -> 19 in the cache */
   /* replace752 -> 2201 in the cache */

   /* ('u2f16', ('u2u64', 'a@8')) => ('u2f16', 'a') */
   /* search753_0_0 -> 19 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_u2u64,
      -1, 0,
      { 19 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_u2f16,
      -1, 0,
      { 2206 },
      -1,
   } },

   /* replace753_0 -> 19 in the cache */
   /* replace753 -> 2199 in the cache */

   /* ('i2f16', ('i2i64', 'a@8')) => ('i2f16', 'a') */
   /* search754_0_0 -> 19 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_i2i64,
      -1, 0,
      { 19 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_i2f16,
      -1, 0,
      { 2208 },
      -1,
   } },

   /* replace754_0 -> 19 in the cache */
   /* replace754 -> 2201 in the cache */

   /* ('i2i8', ('i2i32', 'a@8')) => a */
   /* search755_0_0 -> 19 in the cache */
   /* search755_0 -> 2204 in the cache */
   { .expression = {
      { nir_search_value_expression, 8 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_i2i8,
      -1, 0,
      { 2204 },
      -1,
   } },

   /* replace755 -> 19 in the cache */

   /* ('u2u8', ('u2u32', 'a@8')) => a */
   /* search756_0_0 -> 19 in the cache */
   /* search756_0 -> 2202 in the cache */
   { .expression = {
      { nir_search_value_expression, 8 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_u2u8,
      -1, 0,
      { 2202 },
      -1,
   } },

   /* replace756 -> 19 in the cache */

   /* ('u2f32', ('u2u16', 'a@8')) => ('u2f32', 'a') */
   /* search757_0_0 -> 19 in the cache */
   /* search757_0 -> 2196 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_u2f32,
      -1, 0,
      { 2196 },
      -1,
   } },

   /* replace757_0 -> 19 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_u2f32,
      -1, 0,
      { 19 },
      -1,
   } },

   /* ('i2f32', ('i2i16', 'a@8')) => ('i2f32', 'a') */
   /* search758_0_0 -> 19 in the cache */
   /* search758_0 -> 2194 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_i2f32,
      -1, 0,
      { 2194 },
      -1,
   } },

   /* replace758_0 -> 19 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_i2f32,
      -1, 0,
      { 19 },
      -1,
   } },

   /* ('u2f32', ('u2u32', 'a@8')) => ('u2f32', 'a') */
   /* search759_0_0 -> 19 in the cache */
   /* search759_0 -> 2202 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_u2f32,
      -1, 0,
      { 2202 },
      -1,
   } },

   /* replace759_0 -> 19 in the cache */
   /* replace759 -> 2213 in the cache */

   /* ('i2f32', ('i2i32', 'a@8')) => ('i2f32', 'a') */
   /* search760_0_0 -> 19 in the cache */
   /* search760_0 -> 2204 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_i2f32,
      -1, 0,
      { 2204 },
      -1,
   } },

   /* replace760_0 -> 19 in the cache */
   /* replace760 -> 2215 in the cache */

   /* ('u2f32', ('u2u64', 'a@8')) => ('u2f32', 'a') */
   /* search761_0_0 -> 19 in the cache */
   /* search761_0 -> 2206 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_u2f32,
      -1, 0,
      { 2206 },
      -1,
   } },

   /* replace761_0 -> 19 in the cache */
   /* replace761 -> 2213 in the cache */

   /* ('i2f32', ('i2i64', 'a@8')) => ('i2f32', 'a') */
   /* search762_0_0 -> 19 in the cache */
   /* search762_0 -> 2208 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_i2f32,
      -1, 0,
      { 2208 },
      -1,
   } },

   /* replace762_0 -> 19 in the cache */
   /* replace762 -> 2215 in the cache */

   /* ('i2i8', ('i2i64', 'a@8')) => a */
   /* search763_0_0 -> 19 in the cache */
   /* search763_0 -> 2208 in the cache */
   { .expression = {
      { nir_search_value_expression, 8 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_i2i8,
      -1, 0,
      { 2208 },
      -1,
   } },

   /* replace763 -> 19 in the cache */

   /* ('u2u8', ('u2u64', 'a@8')) => a */
   /* search764_0_0 -> 19 in the cache */
   /* search764_0 -> 2206 in the cache */
   { .expression = {
      { nir_search_value_expression, 8 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_u2u8,
      -1, 0,
      { 2206 },
      -1,
   } },

   /* replace764 -> 19 in the cache */

   /* ('u2f64', ('u2u16', 'a@8')) => ('u2f64', 'a') */
   /* search765_0_0 -> 19 in the cache */
   /* search765_0 -> 2196 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_u2f64,
      -1, 0,
      { 2196 },
      -1,
   } },

   /* replace765_0 -> 19 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_u2f64,
      -1, 0,
      { 19 },
      -1,
   } },

   /* ('i2f64', ('i2i16', 'a@8')) => ('i2f64', 'a') */
   /* search766_0_0 -> 19 in the cache */
   /* search766_0 -> 2194 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_i2f64,
      -1, 0,
      { 2194 },
      -1,
   } },

   /* replace766_0 -> 19 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_i2f64,
      -1, 0,
      { 19 },
      -1,
   } },

   /* ('u2f64', ('u2u32', 'a@8')) => ('u2f64', 'a') */
   /* search767_0_0 -> 19 in the cache */
   /* search767_0 -> 2202 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_u2f64,
      -1, 0,
      { 2202 },
      -1,
   } },

   /* replace767_0 -> 19 in the cache */
   /* replace767 -> 2223 in the cache */

   /* ('i2f64', ('i2i32', 'a@8')) => ('i2f64', 'a') */
   /* search768_0_0 -> 19 in the cache */
   /* search768_0 -> 2204 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_i2f64,
      -1, 0,
      { 2204 },
      -1,
   } },

   /* replace768_0 -> 19 in the cache */
   /* replace768 -> 2225 in the cache */

   /* ('u2f64', ('u2u64', 'a@8')) => ('u2f64', 'a') */
   /* search769_0_0 -> 19 in the cache */
   /* search769_0 -> 2206 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_u2f64,
      -1, 0,
      { 2206 },
      -1,
   } },

   /* replace769_0 -> 19 in the cache */
   /* replace769 -> 2223 in the cache */

   /* ('i2f64', ('i2i64', 'a@8')) => ('i2f64', 'a') */
   /* search770_0_0 -> 19 in the cache */
   /* search770_0 -> 2208 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_i2f64,
      -1, 0,
      { 2208 },
      -1,
   } },

   /* replace770_0 -> 19 in the cache */
   /* replace770 -> 2225 in the cache */

   /* ('i2i16', ('i2i32', 'a@16')) => a */
   /* search771_0_0 -> 24 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_i2i32,
      -1, 0,
      { 24 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_i2i16,
      -1, 0,
      { 2230 },
      -1,
   } },

   /* replace771 -> 24 in the cache */

   /* ('u2u16', ('u2u32', 'a@16')) => a */
   /* search772_0_0 -> 24 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_u2u32,
      -1, 0,
      { 24 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_u2u16,
      -1, 0,
      { 2232 },
      -1,
   } },

   /* replace772 -> 24 in the cache */

   /* ('u2f32', ('u2u32', 'a@16')) => ('u2f32', 'a') */
   /* search773_0_0 -> 24 in the cache */
   /* search773_0 -> 2232 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_u2f32,
      -1, 0,
      { 2232 },
      -1,
   } },

   /* replace773_0 -> 24 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_u2f32,
      -1, 0,
      { 24 },
      -1,
   } },

   /* ('i2f32', ('i2i32', 'a@16')) => ('i2f32', 'a') */
   /* search774_0_0 -> 24 in the cache */
   /* search774_0 -> 2230 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_i2f32,
      -1, 0,
      { 2230 },
      -1,
   } },

   /* replace774_0 -> 24 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_i2f32,
      -1, 0,
      { 24 },
      -1,
   } },

   /* ('u2f32', ('u2u64', 'a@16')) => ('u2f32', 'a') */
   /* search775_0_0 -> 24 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_u2u64,
      -1, 0,
      { 24 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_u2f32,
      -1, 0,
      { 2238 },
      -1,
   } },

   /* replace775_0 -> 24 in the cache */
   /* replace775 -> 2235 in the cache */

   /* ('i2f32', ('i2i64', 'a@16')) => ('i2f32', 'a') */
   /* search776_0_0 -> 24 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_i2i64,
      -1, 0,
      { 24 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_i2f32,
      -1, 0,
      { 2240 },
      -1,
   } },

   /* replace776_0 -> 24 in the cache */
   /* replace776 -> 2237 in the cache */

   /* ('i2i16', ('i2i64', 'a@16')) => a */
   /* search777_0_0 -> 24 in the cache */
   /* search777_0 -> 2240 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_i2i16,
      -1, 0,
      { 2240 },
      -1,
   } },

   /* replace777 -> 24 in the cache */

   /* ('u2u16', ('u2u64', 'a@16')) => a */
   /* search778_0_0 -> 24 in the cache */
   /* search778_0 -> 2238 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_u2u16,
      -1, 0,
      { 2238 },
      -1,
   } },

   /* replace778 -> 24 in the cache */

   /* ('u2f64', ('u2u32', 'a@16')) => ('u2f64', 'a') */
   /* search779_0_0 -> 24 in the cache */
   /* search779_0 -> 2232 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_u2f64,
      -1, 0,
      { 2232 },
      -1,
   } },

   /* replace779_0 -> 24 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_u2f64,
      -1, 0,
      { 24 },
      -1,
   } },

   /* ('i2f64', ('i2i32', 'a@16')) => ('i2f64', 'a') */
   /* search780_0_0 -> 24 in the cache */
   /* search780_0 -> 2230 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_i2f64,
      -1, 0,
      { 2230 },
      -1,
   } },

   /* replace780_0 -> 24 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_i2f64,
      -1, 0,
      { 24 },
      -1,
   } },

   /* ('u2f64', ('u2u64', 'a@16')) => ('u2f64', 'a') */
   /* search781_0_0 -> 24 in the cache */
   /* search781_0 -> 2238 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_u2f64,
      -1, 0,
      { 2238 },
      -1,
   } },

   /* replace781_0 -> 24 in the cache */
   /* replace781 -> 2245 in the cache */

   /* ('i2f64', ('i2i64', 'a@16')) => ('i2f64', 'a') */
   /* search782_0_0 -> 24 in the cache */
   /* search782_0 -> 2240 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_i2f64,
      -1, 0,
      { 2240 },
      -1,
   } },

   /* replace782_0 -> 24 in the cache */
   /* replace782 -> 2247 in the cache */

   /* ('i2i32', ('i2i64', 'a@32')) => a */
   /* search783_0_0 -> 29 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_i2i64,
      -1, 0,
      { 29 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_i2i32,
      -1, 0,
      { 2250 },
      -1,
   } },

   /* replace783 -> 29 in the cache */

   /* ('u2u32', ('u2u64', 'a@32')) => a */
   /* search784_0_0 -> 29 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_u2u64,
      -1, 0,
      { 29 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_u2u32,
      -1, 0,
      { 2252 },
      -1,
   } },

   /* replace784 -> 29 in the cache */

   /* ('u2f64', ('u2u64', 'a@32')) => ('u2f64', 'a') */
   /* search785_0_0 -> 29 in the cache */
   /* search785_0 -> 2252 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_u2f64,
      -1, 0,
      { 2252 },
      -1,
   } },

   /* replace785_0 -> 29 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_u2f64,
      -1, 0,
      { 29 },
      -1,
   } },

   /* ('i2f64', ('i2i64', 'a@32')) => ('i2f64', 'a') */
   /* search786_0_0 -> 29 in the cache */
   /* search786_0 -> 2250 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_i2f64,
      -1, 0,
      { 2250 },
      -1,
   } },

   /* replace786_0 -> 29 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_i2f64,
      -1, 0,
      { 29 },
      -1,
   } },

   /* ('f2fmp', ('u2f32', 'a@32')) => ('u2fmp', 'a') */
   /* search787_0_0 -> 29 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_u2f32,
      -1, 0,
      { 29 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_f2fmp,
      -1, 0,
      { 2258 },
      -1,
   } },

   /* replace787_0 -> 29 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_u2fmp,
      -1, 0,
      { 29 },
      -1,
   } },

   /* ('f2fmp', ('i2f32', 'a@32')) => ('i2fmp', 'a') */
   /* search788_0_0 -> 29 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_i2f32,
      -1, 0,
      { 29 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_f2fmp,
      -1, 0,
      { 2261 },
      -1,
   } },

   /* replace788_0 -> 29 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_i2fmp,
      -1, 0,
      { 29 },
      -1,
   } },

   /* ('f2u16', ('f2fmp', 'a@32')) => ('f2u16', 'a') */
   /* search789_0_0 -> 29 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_f2fmp,
      -1, 0,
      { 29 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_f2u16,
      -1, 0,
      { 2264 },
      -1,
   } },

   /* replace789_0 -> 29 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_f2u16,
      -1, 0,
      { 29 },
      -1,
   } },

   /* ('f2i16', ('f2fmp', 'a@32')) => ('f2i16', 'a') */
   /* search790_0_0 -> 29 in the cache */
   /* search790_0 -> 2264 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_f2i16,
      -1, 0,
      { 2264 },
      -1,
   } },

   /* replace790_0 -> 29 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_f2i16,
      -1, 0,
      { 29 },
      -1,
   } },

   /* ('i2imp', ('f2u32', 'a@32')) => ('f2ump', 'a') */
   /* search791_0_0 -> 29 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_f2u32,
      -1, 0,
      { 29 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_i2imp,
      -1, 0,
      { 2269 },
      -1,
   } },

   /* replace791_0 -> 29 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_f2ump,
      -1, 0,
      { 29 },
      -1,
   } },

   /* ('i2imp', ('f2i32', 'a@32')) => ('f2imp', 'a') */
   /* search792_0_0 -> 29 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_f2i32,
      -1, 0,
      { 29 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_i2imp,
      -1, 0,
      { 2272 },
      -1,
   } },

   /* replace792_0 -> 29 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_f2imp,
      -1, 0,
      { 29 },
      -1,
   } },

   /* ('u2f16', ('i2imp', 'a@32')) => ('u2f16', 'a') */
   /* search793_0_0 -> 29 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_i2imp,
      -1, 0,
      { 29 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_u2f16,
      -1, 0,
      { 2275 },
      -1,
   } },

   /* replace793_0 -> 29 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_u2f16,
      -1, 0,
      { 29 },
      -1,
   } },

   /* ('i2f16', ('i2imp', 'a@32')) => ('i2f16', 'a') */
   /* search794_0_0 -> 29 in the cache */
   /* search794_0 -> 2275 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_i2f16,
      -1, 0,
      { 2275 },
      -1,
   } },

   /* replace794_0 -> 29 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_i2f16,
      -1, 0,
      { 29 },
      -1,
   } },

   /* ('iand', ('u2u16', ('u2u8', 'a@16')), '#b') => ('iand', 'a', ('iand', 'b', 255)) */
   /* search795_0_0_0 -> 24 in the cache */
   { .expression = {
      { nir_search_value_expression, 8 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_u2u8,
      -1, 0,
      { 24 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_u2u16,
      -1, 0,
      { 2280 },
      -1,
   } },
   { .variable = {
      { nir_search_value_variable, 16 },
      1, /* b */
      true,
      nir_type_invalid,
      -1,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_iand,
      0, 1,
      { 2281, 2282 },
      -1,
   } },

   /* replace795_0 -> 24 in the cache */
   /* replace795_1_0 -> 563 in the cache */
   { .constant = {
      { nir_search_value_constant, 16 },
      nir_type_int, { 0xffull /* 255 */ },
   } },
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_iand,
      1, 1,
      { 563, 2284 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_iand,
      0, 2,
      { 24, 2285 },
      -1,
   } },

   /* ('u2u16', ('u2u8(is_used_once)', ('iand', 'a@16', '#b'))) => ('iand', 'a', ('iand', 'b', 255)) */
   /* search796_0_0_0 -> 24 in the cache */
   /* search796_0_0_1 -> 2282 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_iand,
      0, 1,
      { 24, 2282 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 8 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_u2u8,
      -1, 1,
      { 2287 },
      0,
   } },
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_u2u16,
      -1, 1,
      { 2288 },
      -1,
   } },

   /* replace796_0 -> 24 in the cache */
   /* replace796_1_0 -> 563 in the cache */
   /* replace796_1_1 -> 2284 in the cache */
   /* replace796_1 -> 2285 in the cache */
   /* replace796 -> 2286 in the cache */

   /* ('u2u8', ('iand', ('u2u16', ('u2u8', 'a@16')), ('u2u16', ('u2u8', 'b@16')))) => ('u2u8', ('iand', 'a', 'b')) */
   /* search797_0_0_0_0 -> 24 in the cache */
   /* search797_0_0_0 -> 2280 in the cache */
   /* search797_0_0 -> 2281 in the cache */
   /* search797_0_1_0_0 -> 563 in the cache */
   { .expression = {
      { nir_search_value_expression, 8 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_u2u8,
      -1, 0,
      { 563 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_u2u16,
      -1, 0,
      { 2290 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_iand,
      0, 1,
      { 2281, 2291 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 8 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_u2u8,
      -1, 1,
      { 2292 },
      -1,
   } },

   /* replace797_0_0 -> 24 in the cache */
   /* replace797_0_1 -> 563 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_iand,
      0, 1,
      { 24, 563 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 8 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_u2u8,
      -1, 1,
      { 2294 },
      -1,
   } },

   /* ('u2u8', ('iand', ('u2u16', ('u2u8', 'a@32')), ('u2u16', ('u2u8', 'b@32')))) => ('u2u8', ('iand', 'a', 'b')) */
   /* search798_0_0_0_0 -> 29 in the cache */
   { .expression = {
      { nir_search_value_expression, 8 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_u2u8,
      -1, 0,
      { 29 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_u2u16,
      -1, 0,
      { 2296 },
      -1,
   } },
   /* search798_0_1_0_0 -> 48 in the cache */
   { .expression = {
      { nir_search_value_expression, 8 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_u2u8,
      -1, 0,
      { 48 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_u2u16,
      -1, 0,
      { 2298 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_iand,
      0, 1,
      { 2297, 2299 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 8 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_u2u8,
      -1, 1,
      { 2300 },
      -1,
   } },

   /* replace798_0_0 -> 29 in the cache */
   /* replace798_0_1 -> 48 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_iand,
      0, 1,
      { 29, 48 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 8 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_u2u8,
      -1, 1,
      { 2302 },
      -1,
   } },

   /* ('iand', ('extract_i8', 'a', '#b'), ('extract_i8', 'c', 'b')) => ('extract_i8', ('iand', 'a', 'c'), 'b') */
   /* search799_0_0 -> 0 in the cache */
   /* search799_0_1 -> 923 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_extract_i8,
      -1, 0,
      { 0, 923 },
      -1,
   } },
   /* search799_1_0 -> 153 in the cache */
   /* search799_1_1 -> 1 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_extract_i8,
      -1, 0,
      { 153, 1 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_iand,
      0, 1,
      { 2304, 2305 },
      -1,
   } },

   /* replace799_0_0 -> 0 in the cache */
   /* replace799_0_1 -> 153 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_iand,
      0, 1,
      { 0, 153 },
      -1,
   } },
   /* replace799_1 -> 1 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_extract_i8,
      -1, 1,
      { 2307, 1 },
      -1,
   } },

   /* ('iand', ('extract_u8', 'a', '#b'), ('extract_u8', 'c', 'b')) => ('extract_u8', ('iand', 'a', 'c'), 'b') */
   /* search800_0_0 -> 0 in the cache */
   /* search800_0_1 -> 923 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_extract_u8,
      -1, 0,
      { 0, 923 },
      -1,
   } },
   /* search800_1_0 -> 153 in the cache */
   /* search800_1_1 -> 1 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_extract_u8,
      -1, 0,
      { 153, 1 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_iand,
      0, 1,
      { 2309, 2310 },
      -1,
   } },

   /* replace800_0_0 -> 0 in the cache */
   /* replace800_0_1 -> 153 in the cache */
   /* replace800_0 -> 2307 in the cache */
   /* replace800_1 -> 1 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_extract_u8,
      -1, 1,
      { 2307, 1 },
      -1,
   } },

   /* ('iand', ('extract_i16', 'a', '#b'), ('extract_i16', 'c', 'b')) => ('extract_i16', ('iand', 'a', 'c'), 'b') */
   /* search801_0_0 -> 0 in the cache */
   /* search801_0_1 -> 923 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_extract_i16,
      -1, 0,
      { 0, 923 },
      -1,
   } },
   /* search801_1_0 -> 153 in the cache */
   /* search801_1_1 -> 1 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_extract_i16,
      -1, 0,
      { 153, 1 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_iand,
      0, 1,
      { 2313, 2314 },
      -1,
   } },

   /* replace801_0_0 -> 0 in the cache */
   /* replace801_0_1 -> 153 in the cache */
   /* replace801_0 -> 2307 in the cache */
   /* replace801_1 -> 1 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_extract_i16,
      -1, 1,
      { 2307, 1 },
      -1,
   } },

   /* ('iand', ('extract_u16', 'a', '#b'), ('extract_u16', 'c', 'b')) => ('extract_u16', ('iand', 'a', 'c'), 'b') */
   /* search802_0_0 -> 0 in the cache */
   /* search802_0_1 -> 923 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_extract_u16,
      -1, 0,
      { 0, 923 },
      -1,
   } },
   /* search802_1_0 -> 153 in the cache */
   /* search802_1_1 -> 1 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_extract_u16,
      -1, 0,
      { 153, 1 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_iand,
      0, 1,
      { 2317, 2318 },
      -1,
   } },

   /* replace802_0_0 -> 0 in the cache */
   /* replace802_0_1 -> 153 in the cache */
   /* replace802_0 -> 2307 in the cache */
   /* replace802_1 -> 1 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_extract_u16,
      -1, 1,
      { 2307, 1 },
      -1,
   } },

   /* ('iand', ('ushr(is_used_once)', 'a', '#b'), ('ushr', 'c', 'b')) => ('ushr', ('iand', 'a', 'c'), 'b') */
   /* search803_0_0 -> 139 in the cache */
   /* search803_0_1 -> 45 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ushr,
      -1, 0,
      { 139, 45 },
      0,
   } },
   /* search803_1_0 -> 142 in the cache */
   /* search803_1_1 -> 48 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ushr,
      -1, 0,
      { 142, 48 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_iand,
      0, 1,
      { 2321, 2322 },
      -1,
   } },

   /* replace803_0_0 -> 139 in the cache */
   /* replace803_0_1 -> 142 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_iand,
      0, 1,
      { 139, 142 },
      -1,
   } },
   /* replace803_1 -> 48 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ushr,
      -1, 1,
      { 2324, 48 },
      -1,
   } },

   /* ('iand', ('ishr(is_used_once)', 'a', '#b'), ('ishr', 'c', 'b')) => ('ishr', ('iand', 'a', 'c'), 'b') */
   /* search804_0_0 -> 139 in the cache */
   /* search804_0_1 -> 45 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ishr,
      -1, 0,
      { 139, 45 },
      0,
   } },
   /* search804_1_0 -> 142 in the cache */
   /* search804_1_1 -> 48 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ishr,
      -1, 0,
      { 142, 48 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_iand,
      0, 1,
      { 2326, 2327 },
      -1,
   } },

   /* replace804_0_0 -> 139 in the cache */
   /* replace804_0_1 -> 142 in the cache */
   /* replace804_0 -> 2324 in the cache */
   /* replace804_1 -> 48 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ishr,
      -1, 1,
      { 2324, 48 },
      -1,
   } },

   /* ('iand', ('ishl(is_used_once)', 'a', '#b'), ('ishl', 'c', 'b')) => ('ishl', ('iand', 'a', 'c'), 'b') */
   /* search805_0_0 -> 139 in the cache */
   /* search805_0_1 -> 45 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ishl,
      -1, 0,
      { 139, 45 },
      0,
   } },
   /* search805_1_0 -> 142 in the cache */
   /* search805_1_1 -> 48 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ishl,
      -1, 0,
      { 142, 48 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_iand,
      0, 1,
      { 2330, 2331 },
      -1,
   } },

   /* replace805_0_0 -> 139 in the cache */
   /* replace805_0_1 -> 142 in the cache */
   /* replace805_0 -> 2324 in the cache */
   /* replace805_1 -> 48 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ishl,
      -1, 1,
      { 2324, 48 },
      -1,
   } },

   /* ('u2u8', ('ior', ('u2u16', ('u2u8', 'a@16')), ('u2u16', ('u2u8', 'b@16')))) => ('u2u8', ('ior', 'a', 'b')) */
   /* search806_0_0_0_0 -> 24 in the cache */
   /* search806_0_0_0 -> 2280 in the cache */
   /* search806_0_0 -> 2281 in the cache */
   /* search806_0_1_0_0 -> 563 in the cache */
   /* search806_0_1_0 -> 2290 in the cache */
   /* search806_0_1 -> 2291 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ior,
      0, 1,
      { 2281, 2291 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 8 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_u2u8,
      -1, 1,
      { 2334 },
      -1,
   } },

   /* replace806_0_0 -> 24 in the cache */
   /* replace806_0_1 -> 563 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ior,
      0, 1,
      { 24, 563 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 8 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_u2u8,
      -1, 1,
      { 2336 },
      -1,
   } },

   /* ('u2u8', ('ior', ('u2u16', ('u2u8', 'a@32')), ('u2u16', ('u2u8', 'b@32')))) => ('u2u8', ('ior', 'a', 'b')) */
   /* search807_0_0_0_0 -> 29 in the cache */
   /* search807_0_0_0 -> 2296 in the cache */
   /* search807_0_0 -> 2297 in the cache */
   /* search807_0_1_0_0 -> 48 in the cache */
   /* search807_0_1_0 -> 2298 in the cache */
   /* search807_0_1 -> 2299 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ior,
      0, 1,
      { 2297, 2299 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 8 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_u2u8,
      -1, 1,
      { 2338 },
      -1,
   } },

   /* replace807_0_0 -> 29 in the cache */
   /* replace807_0_1 -> 48 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ior,
      0, 1,
      { 29, 48 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 8 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_u2u8,
      -1, 1,
      { 2340 },
      -1,
   } },

   /* ('ior', ('extract_i8', 'a', '#b'), ('extract_i8', 'c', 'b')) => ('extract_i8', ('ior', 'a', 'c'), 'b') */
   /* search808_0_0 -> 0 in the cache */
   /* search808_0_1 -> 923 in the cache */
   /* search808_0 -> 2304 in the cache */
   /* search808_1_0 -> 153 in the cache */
   /* search808_1_1 -> 1 in the cache */
   /* search808_1 -> 2305 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ior,
      0, 1,
      { 2304, 2305 },
      -1,
   } },

   /* replace808_0_0 -> 0 in the cache */
   /* replace808_0_1 -> 153 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ior,
      0, 1,
      { 0, 153 },
      -1,
   } },
   /* replace808_1 -> 1 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_extract_i8,
      -1, 1,
      { 2343, 1 },
      -1,
   } },

   /* ('ior', ('extract_u8', 'a', '#b'), ('extract_u8', 'c', 'b')) => ('extract_u8', ('ior', 'a', 'c'), 'b') */
   /* search809_0_0 -> 0 in the cache */
   /* search809_0_1 -> 923 in the cache */
   /* search809_0 -> 2309 in the cache */
   /* search809_1_0 -> 153 in the cache */
   /* search809_1_1 -> 1 in the cache */
   /* search809_1 -> 2310 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ior,
      0, 1,
      { 2309, 2310 },
      -1,
   } },

   /* replace809_0_0 -> 0 in the cache */
   /* replace809_0_1 -> 153 in the cache */
   /* replace809_0 -> 2343 in the cache */
   /* replace809_1 -> 1 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_extract_u8,
      -1, 1,
      { 2343, 1 },
      -1,
   } },

   /* ('ior', ('extract_i16', 'a', '#b'), ('extract_i16', 'c', 'b')) => ('extract_i16', ('ior', 'a', 'c'), 'b') */
   /* search810_0_0 -> 0 in the cache */
   /* search810_0_1 -> 923 in the cache */
   /* search810_0 -> 2313 in the cache */
   /* search810_1_0 -> 153 in the cache */
   /* search810_1_1 -> 1 in the cache */
   /* search810_1 -> 2314 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ior,
      0, 1,
      { 2313, 2314 },
      -1,
   } },

   /* replace810_0_0 -> 0 in the cache */
   /* replace810_0_1 -> 153 in the cache */
   /* replace810_0 -> 2343 in the cache */
   /* replace810_1 -> 1 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_extract_i16,
      -1, 1,
      { 2343, 1 },
      -1,
   } },

   /* ('ior', ('extract_u16', 'a', '#b'), ('extract_u16', 'c', 'b')) => ('extract_u16', ('ior', 'a', 'c'), 'b') */
   /* search811_0_0 -> 0 in the cache */
   /* search811_0_1 -> 923 in the cache */
   /* search811_0 -> 2317 in the cache */
   /* search811_1_0 -> 153 in the cache */
   /* search811_1_1 -> 1 in the cache */
   /* search811_1 -> 2318 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ior,
      0, 1,
      { 2317, 2318 },
      -1,
   } },

   /* replace811_0_0 -> 0 in the cache */
   /* replace811_0_1 -> 153 in the cache */
   /* replace811_0 -> 2343 in the cache */
   /* replace811_1 -> 1 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_extract_u16,
      -1, 1,
      { 2343, 1 },
      -1,
   } },

   /* ('ior', ('ushr(is_used_once)', 'a', '#b'), ('ushr', 'c', 'b')) => ('ushr', ('ior', 'a', 'c'), 'b') */
   /* search812_0_0 -> 139 in the cache */
   /* search812_0_1 -> 45 in the cache */
   /* search812_0 -> 2321 in the cache */
   /* search812_1_0 -> 142 in the c