/* This file is autogenerated by sid_tables.py from sid.h. Do not edit directly. */

/*
 * Copyright 2015-2019 Advanced Micro Devices, Inc.
 *
 * SPDX-License-Identifier: MIT
 */

#ifndef SID_TABLES_H
#define SID_TABLES_H

struct si_field {
        unsigned name_offset;
        unsigned mask;
        unsigned num_values;
        unsigned values_offset; /* offset into sid_strings_offsets */
};

struct si_reg {
        unsigned name_offset;
        unsigned offset;
        unsigned num_fields;
        unsigned fields_offset;
};

struct si_packet3 {
        unsigned name_offset;
        unsigned op;
};

static const struct si_packet3 packet3_table[] = {
	{0, PKT3_NOP},
	{4, PKT3_SET_BASE},
	{13, PKT3_CLEAR_STATE},
	{25, PKT3_INDEX_BUFFER_SIZE},
	{43, PKT3_DISPATCH_DIRECT},
	{59, PKT3_DISPATCH_INDIRECT},
	{77, PKT3_ATOMIC_MEM},
	{88, PKT3_OCCLUSION_QUERY},
	{104, PKT3_SET_PREDICATION},
	{120, PKT3_COND_EXEC},
	{130, PKT3_PRED_EXEC},
	{140, PKT3_DRAW_INDIRECT},
	{154, PKT3_DRAW_INDEX_INDIRECT},
	{174, PKT3_INDEX_BASE},
	{185, PKT3_DRAW_INDEX_2},
	{198, PKT3_CONTEXT_CONTROL},
	{214, PKT3_INDEX_TYPE},
	{225, PKT3_DRAW_INDIRECT_MULTI},
	{245, PKT3_DRAW_INDEX_AUTO},
	{261, PKT3_DRAW_INDEX_IMMD},
	{277, PKT3_NUM_INSTANCES},
	{291, PKT3_DRAW_INDEX_MULTI_AUTO},
	{313, PKT3_INDIRECT_BUFFER_SI},
	{332, PKT3_INDIRECT_BUFFER_CONST},
	{354, PKT3_STRMOUT_BUFFER_UPDATE},
	{376, PKT3_DRAW_INDEX_OFFSET_2},
	{396, PKT3_WRITE_DATA},
	{407, PKT3_DRAW_INDEX_INDIRECT_MULTI},
	{433, PKT3_MEM_SEMAPHORE},
	{447, PKT3_MPEG_INDEX},
	{458, PKT3_WAIT_REG_MEM},
	{471, PKT3_MEM_WRITE},
	{481, PKT3_INDIRECT_BUFFER},
	{497, PKT3_COPY_DATA},
	{507, PKT3_CP_DMA},
	{514, PKT3_PFP_SYNC_ME},
	{526, PKT3_SURFACE_SYNC},
	{539, PKT3_ME_INITIALIZE},
	{553, PKT3_COND_WRITE},
	{564, PKT3_EVENT_WRITE},
	{576, PKT3_EVENT_WRITE_EOP},
	{592, PKT3_EVENT_WRITE_EOS},
	{592, PKT3_EVENT_WRITE_EOS},
	{608, PKT3_RELEASE_MEM},
	{620, PKT3_DISPATCH_MESH_INDIRECT_MULTI},
	{649, PKT3_DISPATCH_TASKMESH_GFX},
	{671, PKT3_DISPATCH_MESH_DIRECT},
	{692, PKT3_DMA_DATA},
	{701, PKT3_CONTEXT_REG_RMW},
	{717, PKT3_ONE_REG_WRITE},
	{731, PKT3_ACQUIRE_MEM},
	{743, PKT3_REWIND},
	{750, PKT3_PRIME_UTCL2},
	{762, PKT3_LOAD_UCONFIG_REG},
	{779, PKT3_LOAD_SH_REG},
	{791, PKT3_LOAD_CONTEXT_REG},
	{808, PKT3_LOAD_SH_REG_INDEX},
	{826, PKT3_SET_CONFIG_REG},
	{841, PKT3_SET_CONTEXT_REG},
	{857, PKT3_SET_SH_REG},
	{868, PKT3_SET_SH_REG_OFFSET},
	{886, PKT3_SET_UCONFIG_REG},
	{902, PKT3_SET_UCONFIG_REG_INDEX},
	{924, PKT3_LOAD_CONST_RAM},
	{939, PKT3_WRITE_CONST_RAM},
	{955, PKT3_DUMP_CONST_RAM},
	{970, PKT3_INCREMENT_CE_COUNTER},
	{991, PKT3_INCREMENT_DE_COUNTER},
	{1012, PKT3_WAIT_ON_CE_COUNTER},
	{1031, PKT3_SET_SH_REG_INDEX},
	{1048, PKT3_LOAD_CONTEXT_REG_INDEX},
	{1071, PKT3_DISPATCH_DIRECT_INTERLEAVED},
	{1099, PKT3_DISPATCH_INDIRECT_INTERLEAVED},
	{1129, PKT3_DISPATCH_TASK_STATE_INIT},
	{1154, PKT3_DISPATCH_TASKMESH_DIRECT_ACE},
	{1183, PKT3_DISPATCH_TASKMESH_INDIRECT_MULTI_ACE},
	{1220, PKT3_EVENT_WRITE_ZPASS},
	{1238, PKT3_SET_CONTEXT_REG_PAIRS},
	{1260, PKT3_SET_CONTEXT_REG_PAIRS_PACKED},
	{1289, PKT3_SET_SH_REG_PAIRS},
	{1306, PKT3_SET_SH_REG_PAIRS_PACKED},
	{1330, PKT3_SET_SH_REG_PAIRS_PACKED_N},
	{1356, PKT3_SET_UCONFIG_REG_PAIRS},
	{1378, PKT3_IT_OPCODE_C},
};

static const struct si_reg gfx10_reg_table[] = {
	{1390, 1028, 10, 0},
	{1403, 1032, 20, 10},
	{1418, 1036, 10, 30},
	{1434, 1040, 12, 40},
	{1455, 1044, 4, 52},
	{1473, 1048, 3, 56},
	{1491, 1052, 11, 59},
	{1506, 1056},
	{1520, 1060, 1, 70},
	{1534, 1064},
	{1551, 1076, 9, 71},
	{1567, 1080},
	{1584, 1116, 5, 80},
	{1599, 1120, 7, 85},
	{1614, 1124, 2, 92},
	{1634, 1128, 1, 94},
	{1653, 1132, 4, 95},
	{1673, 1136, 7, 99},
	{1689, 2480},
	{1703, 2484},
	{1717, 2488},
	{1731, 2492},
	{1745, 2496},
	{1759, 2500},
	{1773, 2504},
	{1787, 2508},
	{1801, 2512},
	{1815, 2516},
	{1829, 2520},
	{1844, 2524},
	{1859, 2528},
	{1874, 2532},
	{1889, 2536},
	{1904, 2540},
	{1919, 2544},
	{1930, 2552},
	{1946, 2556},
	{1962, 2560},
	{1986, 2564},
	{2010, 2568},
	{2034, 32776, 27, 106},
	{2047, 32784, 21, 133},
	{2059, 32788, 14, 154},
	{2075, 32792, 14, 154},
	{2091, 32796, 15, 168},
	{2104, 32824, 14, 154},
	{2120, 32828, 14, 154},
	{2136, 33296, 21, 183},
	{2150, 33300, 28, 204},
	{2167, 33304, 15, 232},
	{2188, 33308, 28, 247},
	{2202, 33312, 32, 275},
	{2219, 33316, 13, 307},
	{2240, 33320, 9, 320},
	{2258, 33324, 1, 329},
	{2281, 33344, 2, 330},
	{2302, 33348},
	{2322, 33352, 1, 332},
	{2345, 33356, 9, 333},
	{2363, 33436, 1, 342},
	{2386, 36096},
	{2412, 36100, 2, 343},
	{2438, 36104},
	{2464, 36108, 2, 343},
	{2490, 36112, 2, 345},
	{2511, 36116, 4, 347},
	{2532, 36120, 4, 351},
	{2559, 36124, 17, 355},
	{2580, 36128, 6, 372},
	{2603, 36132},
	{2632, 36140},
	{2662, 36144},
	{2694, 36148},
	{2725, 36152},
	{2758, 36348, 5, 378},
	{2767, 36608},
	{2785, 36612, 4, 383},
	{2803, 36616},
	{2821, 36620, 10, 387},
	{2839, 36656, 14, 397},
	{2857, 36660, 4, 411},
	{2875, 36664, 9, 415},
	{2893, 36668, 2, 424},
	{2911, 37120, 9, 426},
	{2927, 39160, 5, 435},
	{2942, 39184, 5, 440},
	{2956, 39188, 5, 440},
	{2970, 39192, 5, 440},
	{2984, 39196, 5, 440},
	{2998, 39200, 5, 440},
	{3012, 39204, 5, 440},
	{3026, 39208, 5, 440},
	{3040, 39212, 5, 440},
	{3054, 39216, 5, 440},
	{3068, 39220, 5, 440},
	{3082, 39224, 5, 440},
	{3097, 39228, 5, 440},
	{3112, 39232, 5, 440},
	{3127, 39236, 5, 440},
	{3142, 39240, 5, 440},
	{3157, 39244, 5, 440},
	{3172, 39248, 5, 440},
	{3187, 39252, 5, 440},
	{3202, 39256, 5, 440},
	{3217, 39260, 5, 440},
	{3232, 39264, 5, 440},
	{3247, 39268, 5, 440},
	{3262, 39272, 5, 440},
	{3277, 39276, 5, 440},
	{3292, 39280, 5, 440},
	{3307, 39284, 5, 440},
	{3322, 39288, 5, 440},
	{3337, 39292, 5, 440},
	{3352, 39296, 5, 440},
	{3367, 39300, 5, 440},
	{3382, 39304, 5, 440},
	{3397, 39308, 5, 440},
	{3412, 39312, 4, 445},
	{3431, 39316, 4, 445},
	{3450, 39320, 4, 445},
	{3469, 39324, 4, 445},
	{3488, 39328, 4, 445},
	{3507, 39332, 4, 445},
	{3526, 39336, 4, 445},
	{3545, 39340, 4, 445},
	{3564, 39344, 4, 445},
	{3583, 39348, 4, 445},
	{3602, 39352, 4, 445},
	{3622, 39356, 4, 445},
	{3642, 39360, 4, 445},
	{3662, 39364, 4, 445},
	{3682, 39368, 4, 445},
	{3702, 39372, 4, 445},
	{3722, 40960},
	{3740, 40964, 4, 449},
	{3758, 40968, 3, 453},
	{3776, 40972, 9, 456},
	{3794, 40976, 2, 465},
	{3812, 40980, 7, 467},
	{3830, 40984, 10, 474},
	{3848, 40988},
	{3866, 41264, 10, 484},
	{3898, 45060, 1, 494},
	{3922, 45080},
	{3947, 45084, 3, 495},
	{3971, 45088},
	{3992, 45092, 1, 498},
	{4013, 45096, 11, 499},
	{4037, 45100, 10, 510},
	{4061, 45104},
	{4087, 45108},
	{4113, 45112},
	{4139, 45116},
	{4165, 45120},
	{4191, 45124},
	{4217, 45128},
	{4243, 45132},
	{4269, 45136},
	{4295, 45140},
	{4321, 45144},
	{4348, 45148},
	{4375, 45152},
	{4402, 45156},
	{4429, 45160},
	{4456, 45164},
	{4483, 45168},
	{4510, 45172},
	{4537, 45176},
	{4564, 45180},
	{4591, 45184},
	{4618, 45188},
	{4645, 45192},
	{4672, 45196},
	{4699, 45200},
	{4726, 45204},
	{4753, 45208},
	{4780, 45212},
	{4807, 45216},
	{4834, 45220},
	{4861, 45224},
	{4888, 45228},
	{4915, 45248, 8, 520},
	{4938, 45252, 5, 528},
	{4971, 45256, 1, 533},
	{4998, 45260, 1, 533},
	{5025, 45264, 1, 533},
	{5052, 45268, 1, 533},
	{5079, 45316, 1, 494},
	{5103, 45332},
	{5128, 45336, 3, 495},
	{5152, 45340, 1, 534},
	{5177, 45344},
	{5198, 45348, 1, 498},
	{5219, 45352, 12, 535},
	{5243, 45356, 14, 547},
	{5267, 45360},
	{5293, 45364},
	{5319, 45368},
	{5345, 45372},
	{5371, 45376},
	{5397, 45380},
	{5423, 45384},
	{5449, 45388},
	{5475, 45392},
	{5501, 45396},
	{5527, 45400},
	{5554, 45404},
	{5581, 45408},
	{5608, 45412},
	{5635, 45416},
	{5662, 45420},
	{5689, 45424},
	{5716, 45428},
	{5743, 45432},
	{5770, 45436},
	{5797, 45440},
	{5824, 45444},
	{5851, 45448},
	{5878, 45452},
	{5905, 45456},
	{5932, 45460},
	{5959, 45464},
	{5986, 45468},
	{6013, 45472},
	{6040, 45476},
	{6067, 45480},
	{6094, 45484},
	{6121, 45504, 8, 520},
	{6144, 45508, 5, 528},
	{6177, 45512, 1, 533},
	{6204, 45516, 1, 533},
	{6231, 45520, 1, 533},
	{6258, 45524, 1, 533},
	{6285, 45548, 9, 561},
	{6312, 45552, 6, 570},
	{6339, 45556, 5, 576},
	{6366, 45568},
	{6391, 45572, 2, 581},
	{6415, 45576},
	{6447, 45580},
	{6479, 45584},
	{6503, 45588, 1, 498},
	{6527, 45596, 4, 583},
	{6551, 45600},
	{6572, 45604, 1, 498},
	{6593, 45608, 13, 587},
	{6617, 45612, 9, 600},
	{6641, 45616},
	{6667, 45620},
	{6693, 45624},
	{6719, 45628},
	{6745, 45632},
	{6771, 45636},
	{6797, 45640},
	{6823, 45644},
	{6849, 45648},
	{6875, 45652},
	{6901, 45656},
	{6928, 45660},
	{6955, 45664},
	{6982, 45668},
	{7009, 45672},
	{7036, 45676},
	{7063, 45680},
	{7090, 45684},
	{7117, 45688},
	{7144, 45692},
	{7171, 45696},
	{7198, 45700},
	{7225, 45704},
	{7252, 45708},
	{7279, 45712},
	{7306, 45716},
	{7333, 45720},
	{7360, 45724},
	{7387, 45728},
	{7414, 45732},
	{7441, 45736},
	{7468, 45740},
	{7495, 45760, 8, 520},
	{7520, 45764, 5, 528},
	{7555, 45768, 1, 533},
	{7584, 45772, 1, 533},
	{7613, 45776, 1, 533},
	{7642, 45780, 1, 533},
	{7671, 45808, 6, 570},
	{7698, 45852, 4, 583},
	{7722, 45856},
	{7743, 45860, 1, 498},
	{7764, 45864, 10, 609},
	{7788, 45868, 6, 570},
	{7812, 45872},
	{7838, 45876},
	{7864, 45880},
	{7890, 45884},
	{7916, 45888},
	{7942, 45892},
	{7968, 45896},
	{7994, 45900},
	{8020, 45904},
	{8046, 45908},
	{8072, 45912},
	{8099, 45916},
	{8126, 45920},
	{8153, 45924},
	{8180, 45928},
	{8207, 45932},
	{8234, 46068, 5, 576},
	{8261, 46080},
	{8286, 46084, 1, 494},
	{8310, 46088},
	{8342, 46092},
	{8374, 46096},
	{8398, 46100, 1, 498},
	{8422, 46108, 4, 619},
	{8446, 46112},
	{8467, 46116, 1, 498},
	{8488, 46120, 12, 623},
	{8512, 46124, 9, 635},
	{8536, 46128},
	{8562, 46132},
	{8588, 46136},
	{8614, 46140},
	{8640, 46144},
	{8666, 46148},
	{8692, 46152},
	{8718, 46156},
	{8744, 46160},
	{8770, 46164},
	{8796, 46168},
	{8823, 46172},
	{8850, 46176},
	{8877, 46180},
	{8904, 46184},
	{8931, 46188},
	{8958, 46192},
	{8985, 46196},
	{9012, 46200},
	{9039, 46204},
	{9066, 46208},
	{9093, 46212},
	{9120, 46216},
	{9147, 46220},
	{9174, 46224},
	{9201, 46228},
	{9228, 46232},
	{9255, 46236},
	{9282, 46240},
	{9309, 46244},
	{9336, 46248},
	{9363, 46252},
	{9390, 46272, 8, 520},
	{9415, 46276, 5, 528},
	{9450, 46280, 1, 533},
	{9479, 46284, 1, 533},
	{9508, 46288, 1, 533},
	{9537, 46292, 1, 533},
	{9566, 46324, 5, 576},
	{9593, 46364, 4, 583},
	{9617, 46368},
	{9638, 46372, 1, 498},
	{9659, 46376, 9, 644},
	{9683, 46380, 5, 576},
	{9707, 46384},
	{9733, 46388},
	{9759, 46392},
	{9785, 46396},
	{9811, 46400},
	{9837, 46404},
	{9863, 46408},
	{9889, 46412},
	{9915, 46416},
	{9941, 46420},
	{9967, 46424},
	{9994, 46428},
	{10021, 46432},
	{10048, 46436},
	{10075, 46440},
	{10102, 46444},
	{10129, 47104, 13, 653},
	{10156, 47108},
	{10170, 47112},
	{10184, 47116},
	{10198, 47120},
	{10214, 47124},
	{10230, 47128},
	{10246, 47132, 2, 666},
	{10267, 47136, 2, 666},
	{10288, 47140, 2, 666},
	{10309, 47144, 1, 668},
	{10337, 47148, 1, 669},
	{10362, 47152},
	{10377, 47156, 1, 670},
	{10392, 47160},
	{10421, 47164, 1, 670},
	{10450, 47168},
	{10483, 47172, 1, 670},
	{10516, 47176, 12, 671},
	{10534, 47180, 11, 683},
	{10552, 47184, 1, 694},
	{10565, 47188, 6, 695},
	{10589, 47192},
	{10616, 47196},
	{10643, 47200, 2, 701},
	{10664, 47204},
	{10691, 47208},
	{10718, 47212},
	{10736, 47216},
	{10754, 47220},
	{10772, 47224, 1, 703},
	{10800, 47228, 5, 704},
	{10822, 47232},
	{10842, 47236},
	{10865, 47240, 9, 709},
	{10882, 47248, 1, 533},
	{10903, 47252, 1, 533},
	{10924, 47256, 1, 533},
	{10945, 47260, 1, 533},
	{10966, 47264, 1, 718},
	{10984, 47268, 1, 719},
	{11003, 47272},
	{11025, 47276, 3, 720},
	{11042, 47280},
	{11071, 47284, 1, 723},
	{11100, 47288, 3, 720},
	{11118, 47360},
	{11138, 47364},
	{11158, 47368},
	{11178, 47372},
	{11198, 47376},
	{11218, 47380},
	{11238, 47384},
	{11258, 47388},
	{11278, 47392},
	{11298, 47396},
	{11318, 47400},
	{11339, 47404},
	{11360, 47408},
	{11381, 47412},
	{11402, 47416},
	{11423, 47420},
	{11444, 47604, 2, 724},
	{11468, 47608},
	{11489, 47612},
	{11505, 163840, 10, 726},
	{11523, 163844, 11, 736},
	{11540, 163848, 7, 747},
	{11554, 163852, 23, 754},
	{11573, 163856, 16, 777},
	{11593, 163860},
	{11612, 163868, 2, 793},
	{11629, 163872},
	{11649, 163876},
	{11669, 163880, 1, 795},
	{11686, 163884},
	{11701, 163888, 2, 796},
	{11725, 163892, 2, 798},
	{11749, 163896, 3, 800},
	{11765, 163900, 8, 803},
	{11783, 163904, 14, 811},
	{11793, 163908, 9, 825},
	{11809, 163912},
	{11824, 163916},
	{11845, 163920},
	{11861, 163924},
	{11883, 163928, 2, 834},
	{11901, 163932, 1, 836},
	{11919, 163944, 1, 837},
	{11937, 163948, 1, 837},
	{11961, 163952, 1, 837},
	{11980, 163956, 1, 837},
	{12005, 163960, 1, 837},
	{12027, 163964, 9, 838},
	{12051, 163968},
	{12067, 163972, 1, 847},
	{12086, 164328, 1, 848},
	{12107, 164332, 1, 848},
	{12128, 164336, 1, 848},
	{12149, 164340, 1, 848},
	{12170, 164344},
	{12188, 164348},
	{12206, 164352, 2, 849},
	{12226, 164356, 3, 851},
	{12250, 164360, 2, 854},
	{12274, 164364, 1, 856},
	{12294, 164368, 2, 851},
	{12314, 164372, 2, 854},
	{12334, 164376, 2, 851},
	{12354, 164380, 2, 854},
	{12374, 164384, 2, 851},
	{12394, 164388, 2, 854},
	{12414, 164392, 2, 851},
	{12434, 164396, 2, 854},
	{12454, 164400, 7, 857},
	{12469, 164404, 2, 864},
	{12498, 164408, 8, 866},
	{12513, 164412, 8, 874},
	{12528, 164416, 3, 851},
	{12553, 164420, 2, 854},
	{12578, 164424},
	{12596, 164428},
	{12614, 164432, 3, 851},
	{12639, 164436, 2, 854},
	{12664, 164440, 3, 851},
	{12689, 164444, 2, 854},
	{12714, 164448, 3, 851},
	{12739, 164452, 2, 854},
	{12764, 164456, 3, 851},
	{12789, 164460, 2, 854},
	{12814, 164464, 3, 851},
	{12839, 164468, 2, 854},
	{12864, 164472, 3, 851},
	{12889, 164476, 2, 854},
	{12914, 164480, 3, 851},
	{12939, 164484, 2, 854},
	{12964, 164488, 3, 851},
	{12989, 164492, 2, 854},
	{13014, 164496, 3, 851},
	{13039, 164500, 2, 854},
	{13064, 164504, 3, 851},
	{13089, 164508, 2, 854},
	{13114, 164512, 3, 851},
	{13140, 164516, 2, 854},
	{13166, 164520, 3, 851},
	{13192, 164524, 2, 854},
	{13218, 164528, 3, 851},
	{13244, 164532, 2, 854},
	{13270, 164536, 3, 851},
	{13296, 164540, 2, 854},
	{13322, 164544, 3, 851},
	{13348, 164548, 2, 854},
	{13374, 164552, 3, 851},
	{13400, 164556, 2, 854},
	{13426, 164560},
	{13445, 164564},
	{13464, 164568},
	{13483, 164572},
	{13502, 164576},
	{13521, 164580},
	{13540, 164584},
	{13559, 164588},
	{13578, 164592},
	{13597, 164596},
	{13616, 164600},
	{13635, 164604},
	{13654, 164608},
	{13673, 164612},
	{13692, 164616},
	{13711, 164620},
	{13730, 164624},
	{13749, 164628},
	{13768, 164632},
	{13787, 164636},
	{13806, 164640},
	{13826, 164644},
	{13846, 164648},
	{13866, 164652},
	{13886, 164656},
	{13906, 164660},
	{13926, 164664},
	{13946, 164668},
	{13966, 164672},
	{13986, 164676},
	{14006, 164680},
	{14026, 164684},
	{14046, 164688, 15, 882},
	{14066, 164692, 3, 897},
	{14088, 164696, 2, 900},
	{14116, 164700, 7, 902},
	{14145, 164704, 1, 909},
	{14166, 164708, 1, 910},
	{14176, 164712, 1, 911},
	{14184, 164768, 4, 912},
	{14206, 164772, 4, 912},
	{14227, 164776, 4, 916},
	{14244, 164864},
	{14261, 164868},
	{14278, 164872},
	{14294, 164876},
	{14323, 164880, 10, 920},
	{14348, 164884},
	{14361, 164888},
	{14376, 164892},
	{14390, 164896},
	{14405, 164900, 8, 930},
	{14420, 164904, 4, 938},
	{14444, 164908, 6, 942},
	{14463, 164912, 4, 948},
	{14481, 164916, 4, 952},
	{14502, 164924},
	{14521, 164928},
	{14541, 164932},
	{14560, 164936},
	{14580, 164940},
	{14599, 164944},
	{14619, 164948},
	{14640, 164952},
	{14662, 164956},
	{14683, 164960},
	{14705, 164964},
	{14726, 164968},
	{14748, 164972},
	{14769, 164976},
	{14791, 164980},
	{14812, 164984},
	{14834, 164988},
	{14855, 164992},
	{14877, 164996},
	{14898, 165000},
	{14920, 165004},
	{14941, 165008},
	{14963, 165012},
	{14984, 165016},
	{15006, 165020},
	{15027, 165024},
	{15049, 165028},
	{15070, 165032},
	{15092, 165036},
	{15113, 165040},
	{15135, 165044},
	{15156, 165048},
	{15178, 165052},
	{15199, 165056},
	{15221, 165060},
	{15242, 165064},
	{15264, 165068},
	{15285, 165072},
	{15307, 165076},
	{15328, 165080},
	{15350, 165084},
	{15371, 165088},
	{15393, 165092},
	{15414, 165096},
	{15436, 165100},
	{15457, 165104},
	{15479, 165108},
	{15500, 165112},
	{15522, 165116},
	{15543, 165120},
	{15565, 165124},
	{15586, 165128},
	{15608, 165132},
	{15629, 165136},
	{15651, 165140},
	{15672, 165144},
	{15694, 165148},
	{15715, 165152},
	{15737, 165156},
	{15758, 165160},
	{15780, 165164},
	{15802, 165168},
	{15825, 165172},
	{15847, 165176},
	{15870, 165180},
	{15892, 165184},
	{15915, 165188},
	{15937, 165192},
	{15960, 165196},
	{15982, 165200},
	{16005, 165204},
	{16027, 165208},
	{16050, 165212},
	{16072, 165216},
	{16095, 165220},
	{16117, 165224},
	{16140, 165228},
	{16162, 165232},
	{16185, 165236},
	{16207, 165240},
	{16230, 165244},
	{16252, 165248},
	{16275, 165252},
	{16297, 165256},
	{16320, 165260},
	{16342, 165264},
	{16365, 165268},
	{16387, 165272},
	{16410, 165276},
	{16432, 165280},
	{16455, 165284},
	{16477, 165288},
	{16500, 165292},
	{16522, 165296},
	{16545, 165300},
	{16567, 165304},
	{16590, 165308},
	{16604, 165312},
	{16618, 165316},
	{16632, 165320},
	{16646, 165324},
	{16660, 165328},
	{16674, 165332},
	{16688, 165336},
	{16702, 165340},
	{16716, 165344},
	{16730, 165348},
	{16744, 165352},
	{16758, 165356},
	{16772, 165360},
	{16786, 165364},
	{16800, 165368},
	{16814, 165372},
	{16828, 165376},
	{16842, 165380},
	{16856, 165384},
	{16870, 165388},
	{16884, 165392},
	{16898, 165396},
	{16912, 165400},
	{16926, 165404},
	{16949, 165444, 12, 956},
	{16969, 165448, 12, 956},
	{16989, 165452, 12, 956},
	{17009, 165456, 12, 956},
	{17029, 165460, 12, 956},
	{17049, 165464, 12, 956},
	{17069, 165468, 12, 956},
	{17089, 165472, 12, 956},
	{17109, 165476, 12, 956},
	{17129, 165480, 12, 956},
	{17149, 165484, 12, 956},
	{17170, 165488, 12, 956},
	{17191, 165492, 12, 956},
	{17212, 165496, 12, 956},
	{17233, 165500, 12, 956},
	{17254, 165504, 12, 956},
	{17275, 165508, 12, 956},
	{17296, 165512, 12, 956},
	{17317, 165516, 12, 956},
	{17338, 165520, 12, 956},
	{17359, 165524, 9, 968},
	{17380, 165528, 9, 968},
	{17401, 165532, 9, 968},
	{17422, 165536, 9, 968},
	{17443, 165540, 9, 968},
	{17464, 165544, 9, 968},
	{17485, 165548, 9, 968},
	{17506, 165552, 9, 968},
	{17527, 165556, 9, 968},
	{17548, 165560, 9, 968},
	{17569, 165564, 9, 968},
	{17590, 165568, 9, 968},
	{17611, 165572, 3, 977},
	{17629, 165580, 16, 980},
	{17646, 165584, 16, 980},
	{17664, 165588, 7, 996},
	{17685, 165592, 6, 1003},
	{17703, 165600, 7, 1009},
	{17718, 165608, 2, 701},
	{17735, 165640, 1, 1016},
	{17757, 165644, 5, 1017},
	{17779, 165648, 1, 1022},
	{17799, 165652, 8, 1023},
	{17821, 165716, 8, 1031},
	{17839, 165720, 8, 1039},
	{17860, 165724, 17, 1047},
	{17881, 165728, 6, 1064},
	{17899, 165732, 6, 1064},
	{17917, 165736, 6, 1064},
	{17935, 165740, 6, 1064},
	{17953, 165744, 6, 1064},
	{17971, 165748, 6, 1064},
	{17989, 165752, 6, 1064},
	{18007, 165756, 6, 1064},
	{18025, 165760, 9, 1070},
	{18043, 165764, 9, 1070},
	{18061, 165768, 9, 1070},
	{18079, 165772, 9, 1070},
	{18097, 165776, 9, 1070},
	{18115, 165780, 9, 1070},
	{18133, 165784, 9, 1070},
	{18151, 165788, 9, 1070},
	{18169, 165836, 1, 1079},
	{18183, 165840, 1, 1079},
	{18198, 165844},
	{18216, 165848},
	{18234, 165852},
	{18251, 165856},
	{18272, 165860, 1, 1080},
	{18288, 165864},
	{18301, 165872, 8, 1081},
	{18320, 165876},
	{18335, 165880, 1, 1089},
	{18357, 165884, 1, 1090},
	{18384, 165888, 10, 1091},
	{18401, 165892, 12, 1101},
	{18409, 165896, 4, 1113},
	{18426, 165900, 17, 1117},
	{18444, 165904, 20, 1134},
	{18460, 165908, 16, 1154},
	{18479, 165912, 10, 1170},
	{18494, 165916, 28, 1180},
	{18512, 165920, 16, 1208},
	{18530, 165924, 4, 1224},
	{18554, 165928},
	{18579, 165932, 11, 1228},
	{18602, 165936, 7, 1239},
	{18631, 165940, 2, 1246},
	{18653, 165944, 2, 1248},
	{18668, 165948, 5, 1250},
	{18698, 165952, 5, 1255},
	{18713, 165956},
	{18731, 166400, 2, 1260},
	{18748, 166404, 2, 1262},
	{18767, 166408, 1, 1264},
	{18783, 166412, 4, 1265},
	{18802, 166416, 1, 1269},
	{18823, 166420, 1, 1270},
	{18836, 166424},
	{18859, 166428},
	{18882, 166432, 1, 1271},
	{18902, 166436, 4, 1272},
	{18922, 166440, 1, 1276},
	{18943, 166444, 1, 1277},
	{18958, 166448, 6, 1278},
	{18980, 166452, 6, 1278},
	{19002, 166456, 8, 1284},
	{19028, 166460, 8, 1284},
	{19054, 166464, 15, 1292},
	{19066, 166468, 3, 1307},
	{19085, 166472, 7, 1310},
	{19103, 166476, 24, 1317},
	{19121, 166480},
	{19133, 166484, 1, 1341},
	{19147, 166488, 1, 1342},
	{19161, 166492, 1, 1343},
	{19175, 166496, 1, 1344},
	{19198, 166500, 1, 1344},
	{19221, 166504, 1, 1344},
	{19244, 166508, 5, 1345},
	{19265, 166512},
	{19276, 166516},
	{19289, 166520},
	{19306, 166524, 8, 1350},
	{19325, 166528},
	{19336, 166532, 3, 1358},
	{19355, 166536},
	{19377, 166540},
	{19399, 166544, 3, 1361},
	{19419, 166548, 2, 1364},
	{19446, 166552, 5, 1366},
	{19468, 166560},
	{19493, 166564},
	{19518, 166568, 6, 1371},
	{19537, 166572, 1, 1377},
	{19560, 166576, 1, 1377},
	{19583, 166580, 1, 1378},
	{19597, 166584, 1, 1379},
	{19612, 166588, 9, 1380},
	{19629, 166592, 4, 1389},
	{19656, 166596, 4, 1393},
	{19683, 166600, 4, 1397},
	{19702, 166608},
	{19728, 166612, 1, 1401},
	{19753, 166620},
	{19781, 166624},
	{19807, 166628, 1, 1401},
	{19832, 166636},
	{19860, 166640},
	{19886, 166644, 1, 1401},
	{19911, 166652},
	{19939, 166656},
	{19965, 166660, 1, 1401},
	{19990, 166668},
	{20018, 166696},
	{20049, 166700},
	{20092, 166704, 1, 1402},
	{20130, 166712, 1, 1403},
	{20150, 166732, 2, 1404},
	{20169, 166736, 5, 1406},
	{20191, 166740, 19, 1411},
	{20212, 166744, 3, 1430},
	{20229, 166748, 1, 1377},
	{20250, 166752, 1, 1377},
	{20273, 166756, 1, 1377},
	{20296, 166760, 1, 1377},
	{20319, 166764, 12, 1433},
	{20332, 166768, 6, 1445},
	{20349, 166772},
	{20373, 166776, 2, 1451},
	{20403, 166780},
	{20427, 166784},
	{20457, 166788},
	{20488, 166792},
	{20517, 166796},
	{20547, 166800, 3, 1453},
	{20567, 166804, 8, 1456},
	{20586, 166808, 4, 1464},
	{20612, 166812, 3, 1361},
	{20636, 166868, 8, 1468},
	{20662, 166872, 8, 1476},
	{20688, 166876, 5, 1484},
	{20704, 166880, 6, 1489},
	{20720, 166884, 3, 1495},
	{20735, 166888},
	{20758, 166892},
	{20781, 166896},
	{20804, 166900},
	{20827, 166904, 8, 1498},
	{20861, 166908, 8, 1506},
	{20895, 166912, 8, 1514},
	{20929, 166916, 8, 1522},
	{20963, 166920, 8, 1498},
	{20997, 166924, 8, 1506},
	{21031, 166928, 8, 1514},
	{21065, 166932, 8, 1522},
	{21099, 166936, 8, 1498},
	{21133, 166940, 8, 1506},
	{21167, 166944, 8, 1514},
	{21201, 166948, 8, 1522},
	{21235, 166952, 8, 1498},
	{21269, 166956, 8, 1506},
	{21303, 166960, 8, 1514},
	{21337, 166964, 8, 1522},
	{21371, 166968, 2, 1530},
	{21395, 166972, 2, 1532},
	{21419, 166976, 4, 1534},
	{21440, 166980, 12, 1538},
	{21460, 166984, 2, 1550},
	{21480, 166988, 20, 1552},
	{21518, 166992, 2, 1572},
	{21538, 167000, 1, 1574},
	{21566, 167004, 1, 1575},
	{21587, 167008},
	{21602, 167012, 2, 1576},
	{21618, 167016, 1, 1578},
	{21634, 167020, 3, 1579},
	{21649, 167024, 19, 1582},
	{21664, 167028, 8, 1601},
	{21681, 167032, 12, 1609},
	{21703, 167036},
	{21719, 167040, 1, 1621},
	{21741, 167044},
	{21757, 167048, 1, 1578},
	{21779, 167052},
	{21801, 167056},
	{21823, 167060},
	{21842, 167068},
	{21857, 167072, 2, 1576},
	{21873, 167076, 1, 1578},
	{21889, 167080, 3, 1579},
	{21904, 167084, 19, 1582},
	{21919, 167088, 8, 1601},
	{21936, 167092, 12, 1609},
	{21958, 167096},
	{21974, 167100, 1, 1621},
	{21996, 167104},
	{22012, 167108, 1, 1578},
	{22034, 167112},
	{22056, 167116},
	{22078, 167120},
	{22097, 167128},
	{22112, 167132, 2, 1576},
	{22128, 167136, 1, 1578},
	{22144, 167140, 3, 1579},
	{22159, 167144, 19, 1582},
	{22174, 167148, 8, 1601},
	{22191, 167152, 12, 1609},
	{22213, 167156},
	{22229, 167160, 1, 1621},
	{22251, 167164},
	{22267, 167168, 1, 1578},
	{22289, 167172},
	{22311, 167176},
	{22333, 167180},
	{22352, 167188},
	{22367, 167192, 2, 1576},
	{22383, 167196, 1, 1578},
	{22399, 167200, 3, 1579},
	{22414, 167204, 19, 1582},
	{22429, 167208, 8, 1601},
	{22446, 167212, 12, 1609},
	{22468, 167216},
	{22484, 167220, 1, 1621},
	{22506, 167224},
	{22522, 167228, 1, 1578},
	{22544, 167232},
	{22566, 167236},
	{22588, 167240},
	{22607, 167248},
	{22622, 167252, 2, 1576},
	{22638, 167256, 1, 1578},
	{22654, 167260, 3, 1579},
	{22669, 167264, 19, 1582},
	{22684, 167268, 8, 1601},
	{22701, 167272, 12, 1609},
	{22723, 167276},
	{22739, 167280, 1, 1621},
	{22761, 167284},
	{22777, 167288, 1, 1578},
	{22799, 167292},
	{22821, 167296},
	{22843, 167300},
	{22862, 167308},
	{22877, 167312, 2, 1576},
	{22893, 167316, 1, 1578},
	{22909, 167320, 3, 1579},
	{22924, 167324, 19, 1582},
	{22939, 167328, 8, 1601},
	{22956, 167332, 12, 1609},
	{22978, 167336},
	{22994, 167340, 1, 1621},
	{23016, 167344},
	{23032, 167348, 1, 1578},
	{23054, 167352},
	{23076, 167356},
	{23098, 167360},
	{23117, 167368},
	{23132, 167372, 2, 1576},
	{23148, 167376, 1, 1578},
	{23164, 167380, 3, 1579},
	{23179, 167384, 19, 1582},
	{23194, 167388, 8, 1601},
	{23211, 167392, 12, 1609},
	{23233, 167396},
	{23249, 167400, 1, 1621},
	{23271, 167404},
	{23287, 167408, 1, 1578},
	{23309, 167412},
	{23331, 167416},
	{23353, 167420},
	{23372, 167428},
	{23387, 167432, 2, 1576},
	{23403, 167436, 1, 1578},
	{23419, 167440, 3, 1579},
	{23434, 167444, 19, 1582},
	{23449, 167448, 8, 1601},
	{23466, 167452, 12, 1609},
	{23488, 167456},
	{23504, 167460, 1, 1621},
	{23526, 167464},
	{23542, 167468, 1, 1578},
	{23564, 167472},
	{23586, 167476},
	{23608, 167480},
	{23627, 167488, 1, 1622},
	{23646, 167492, 1, 1622},
	{23665, 167496, 1, 1622},
	{23684, 167500, 1, 1622},
	{23703, 167504, 1, 1622},
	{23722, 167508, 1, 1622},
	{23741, 167512, 1, 1622},
	{23760, 167516, 1, 1622},
	{23779, 167520, 1, 1622},
	{23804, 167524, 1, 1622},
	{23829, 167528, 1, 1622},
	{23854, 167532, 1, 1622},
	{23879, 167536, 1, 1622},
	{23904, 167540, 1, 1622},
	{23929, 167544, 1, 1622},
	{23954, 167548, 1, 1622},
	{23979, 167552, 1, 1622},
	{24004, 167556, 1, 1622},
	{24029, 167560, 1, 1622},
	{24054, 167564, 1, 1622},
	{24079, 167568, 1, 1622},
	{24104, 167572, 1, 1622},
	{24129, 167576, 1, 1622},
	{24154, 167580, 1, 1622},
	{24179, 167584, 1, 1622},
	{24202, 167588, 1, 1622},
	{24225, 167592, 1, 1622},
	{24248, 167596, 1, 1622},
	{24271, 167600, 1, 1622},
	{24294, 167604, 1, 1622},
	{24317, 167608, 1, 1622},
	{24340, 167612, 1, 1622},
	{24363, 167616, 3, 1623},
	{24381, 167620, 3, 1623},
	{24399, 167624, 3, 1623},
	{24417, 167628, 3, 1623},
	{24435, 167632, 3, 1623},
	{24453, 167636, 3, 1623},
	{24471, 167640, 3, 1623},
	{24489, 167644, 3, 1623},
	{24507, 167648, 8, 1626},
	{24525, 167652, 8, 1626},
	{24543, 167656, 8, 1626},
	{24561, 167660, 8, 1626},
	{24579, 167664, 8, 1626},
	{24597, 167668, 8, 1626},
	{24615, 167672, 8, 1626},
	{24633, 167676, 8, 1626},
	{24651, 196608, 1, 1634},
	{24671, 196612, 1, 1635},
	{24691, 196616},
	{24711, 196620},
	{24731, 196624},
	{24752, 196628},
	{24773, 196632, 1, 1636},
	{24795, 196636, 1, 1637},
	{24817, 196640},
	{24847, 196644},
	{24877, 196648},
	{24906, 196652},
	{24935, 196656},
	{24965, 196660},
	{24995, 196664},
	{25024, 196668},
	{25053, 196672},
	{25083, 196676},
	{25113, 196680},
	{25142, 196684},
	{25171, 196688},
	{25201, 196692},
	{25231, 196696},
	{25260, 196700},
	{25289, 196704, 1, 1638},
	{25311, 196708, 1, 1639},
	{25333, 196712},
	{25356, 196716},
	{25379, 196720},
	{25402, 196724},
	{25425, 196728},
	{25448, 196732},
	{25471, 196736},
	{25495, 196740},
	{25519, 196744},
	{25543, 196748},
	{25567, 196752},
	{25591, 196756},
	{25615, 196760},
	{25639, 196764},
	{25663, 196768},
	{25685, 196772},
	{25707, 196776},
	{25728, 196780},
	{25749, 196784},
	{25773, 196788},
	{25797, 196792},
	{25821, 196796},
	{25845, 196800},
	{25869, 196804},
	{25893, 196808, 1, 1640},
	{25914, 196812, 1, 1640},
	{25937, 196816, 1, 1640},
	{25953, 196852, 1, 1641},
	{25975, 196856, 1, 1641},
	{25997, 196860, 1, 1642},
	{26013, 196864},
	{26026, 196868},
	{26039, 196872},
	{26052, 196876},
	{26065, 196880},
	{26078, 196884},
	{26091, 196888},
	{26104, 196892},
	{26117, 196896, 1, 1640},
	{26140, 196908, 1, 670},
	{26159, 196912},
	{26177, 196916},
	{26204, 196920},
	{26231, 196928, 2, 1643},
	{26244, 196932},
	{26257, 196936},
	{26280, 196940},
	{26303, 196944},
	{26331, 196948},
	{26359, 196952},
	{26387, 196956},
	{26415, 196960, 1, 1645},
	{26433, 196964, 4, 1646},
	{26451, 196968},
	{26466, 196972},
	{26490, 196976},
	{26514, 196980},
	{26533, 196984},
	{26552, 196988},
	{26576, 196992},
	{26600, 196996},
	{26624, 197000},
	{26648, 197028, 1, 1650},
	{26666, 197032, 2, 1651},
	{26684, 197036},
	{26702, 197040},
	{26720, 197044, 1, 1653},
	{26738, 197048, 2, 1654},
	{26756, 197052},
	{26774, 197056, 2, 1656},
	{26793, 197060, 5, 1658},
	{26812, 197072},
	{26836, 197076, 2, 1656},
	{26856, 197080, 5, 1658},
	{26876, 197084, 7, 1663},
	{26895, 197088, 7, 1663},
	{26913, 197092, 1, 1670},
	{26930, 197100, 1, 1671},
	{26951, 197104, 13, 1672},
	{26965, 197108},
	{26979, 197112},
	{26993, 197116, 2, 1685},
	{27009, 197120},
	{27028, 197124, 1, 1687},
	{27050, 197128},
	{27069, 197132, 1, 1688},
	{27091, 197136, 7, 1689},
	{27109, 197140},
	{27129, 197144, 1, 1687},
	{27152, 197148},
	{27172, 197152, 1, 1688},
	{27195, 197156, 7, 1689},
	{27214, 197160, 7, 1696},
	{27226, 197164, 2, 1703},
	{27243, 197168, 1, 1705},
	{27260, 197172, 1, 1706},
	{27278, 197176, 4, 1707},
	{27298, 197180, 2, 1711},
	{27315, 197184},
	{27331, 197188, 1, 1713},
	{27344, 197192, 1, 1714},
	{27358, 197196, 1, 1715},
	{27372, 197200, 1, 1716},
	{27394, 197204, 1, 1717},
	{27414, 197208, 1, 1718},
	{27436, 197212, 1, 1719},
	{27456, 197216, 1, 1714},
	{27473, 197220, 1, 1715},
	{27490, 197224},
	{27504, 197232, 2, 1720},
	{27526, 197236, 2, 1722},
	{27548, 197240, 2, 1720},
	{27571, 197244, 2, 1722},
	{27594, 197248, 2, 1720},
	{27616, 197252, 2, 1722},
	{27638, 197364, 1, 1724},
	{27659, 197368, 1, 1725},
	{27679, 197372, 1, 1726},
	{27699, 197376, 1, 1725},
	{27716, 197380, 1, 1726},
	{27733, 197384, 1, 1727},
	{27749, 197388, 1, 1728},
	{27768, 197392, 1, 1729},
	{27787, 197396, 1, 1730},
	{27804, 197400, 1, 1731},
	{27822, 197404, 1, 1732},
	{27840, 197408, 1, 1733},
	{27856, 197412, 1, 1734},
	{27874, 197416, 1, 1735},
	{27892, 197420, 1, 1736},
	{27908, 197424, 1, 1731},
	{27923, 197428, 1, 1732},
	{27938, 197432, 1, 1733},
	{27951, 197436, 1, 1734},
	{27966, 197440, 1, 1735},
	{27981, 197444, 1, 1736},
	{27994, 197448, 1, 1737},
	{28008, 197452, 1, 1738},
	{28022, 197456, 1, 1739},
	{28034, 197460, 4, 1740},
	{28057, 197464, 3, 1744},
	{28079, 197468, 1, 1747},
	{28099, 197472, 1, 1748},
	{28113, 197476, 1, 1749},
	{28127, 197480, 1, 1750},
	{28139, 197484, 1, 1751},
	{28155, 197488, 1, 1748},
	{28172, 197492, 1, 1749},
	{28189, 197496, 1, 1750},
	{28204, 197500, 1, 1751},
	{28223, 197552, 1, 1752},
	{28248, 197556, 1, 1752},
	{28272, 197560, 1, 1753},
	{28292, 197568},
	{28318, 197572, 1, 1635},
	{28347, 197576},
	{28372, 197580, 1, 1635},
	{28400, 197584},
	{28423, 197588, 1, 1635},
	{28449, 197592},
	{28471, 197596, 1, 1635},
	{28496, 197600},
	{28515, 197604, 1, 1635},
	{28537, 197608, 1, 1350},
	{28551, 197612},
	{28568, 197616, 1, 1635},
	{28588, 197620, 8, 1754},
	{28605, 197624, 13, 1762},
	{28622, 197628},
	{28639, 197632, 1, 1705},
	{28659, 197636},
	{28676, 197640, 1, 1670},
	{28696, 197644, 2, 1775},
	{28715, 197888, 8, 1777},
	{28736, 197892, 8, 1777},
	{28757, 198656, 6, 1785},
	{28772, 198912},
	{28791, 198916},
	{28810, 198920, 1, 1791},
	{28829, 198924, 1, 1350},
	{28844, 198928},
	{28877, 198932},
	{28910, 198936},
	{28943, 198940},
	{28976, 198948},
	{28992, 198952},
	{29007, 198956, 2, 1364},
	{29033, 198960},
	{29049, 198964},
	{29067, 198968, 1, 1792},
	{29084, 198972, 2, 1793},
	{29105, 198976},
	{29124, 198980},
	{29143, 198984},
	{29159, 198988, 1, 837},
	{29178, 198992},
	{29198, 198996, 1, 837},
	{29221, 199000},
	{29239, 199004, 1, 837},
	{29260, 199008, 9, 1795},
	{29285, 199012},
	{29301, 199016},
	{29322, 199020, 4, 1804},
	{29330, 199024},
	{29344, 199028},
	{29358, 199032},
	{29372, 199036, 3, 1808},
	{29387, 199040, 2, 1811},
	{29399, 199044, 1, 837},
	{29421, 199048, 3, 1813},
	{29437, 199168, 1, 1816},
	{29462, 199172, 2, 1817},
	{29487, 199184, 2, 1819},
	{29513, 199188, 2, 1819},
	{29539, 199192, 2, 1819},
	{29565, 199212, 2, 1819},
	{29591, 199296, 2, 1821},
	{29619, 199300, 1, 1823},
	{29643, 199304, 1, 1824},
	{29667, 199308, 1, 1825},
	{29700, 199312, 1, 1825},
	{29728, 199328, 2, 1821},
	{29757, 199332, 1, 1823},
	{29782, 199336, 1, 1824},
	{29807, 199340, 1, 1825},
	{29841, 199344, 1, 1825},
	{29870, 199360, 2, 1821},
	{29894, 199364, 1, 1823},
	{29914, 199368, 1, 1824},
	{29934, 199372, 1, 1825},
	{29963, 199376, 1, 1825},
	{29987, 199936},
	{30014, 199940},
	{30041, 199944},
	{30068, 199948},
	{30095, 199952},
	{30122, 199956},
	{30149, 199960},
	{30176, 199964},
	{30203, 199968, 7, 1826},
	{30214, 199972, 2, 1833},
	{30228, 200192},
	{30247, 200196, 1, 847},
	{30269, 200448},
	{30293, 200452, 1, 1835},
	{30316, 200456},
	{30340, 200460, 1, 1835},
	{30363, 200464},
	{30387, 200468, 1, 1835},
	{30410, 200472},
	{30434, 200476, 1, 1835},
	{30457, 200696},
	{30476, 200700, 1, 1835},
	{30494, 200704},
	{30506, 200708},
	{30518, 200712},
	{30536, 200716},
	{30555, 200720},
	{30573, 200724},
	{30585, 200728},
	{30597, 200732},
	{30615, 200736},
	{30633, 200740},
	{30652, 200744, 4, 1836},
	{30666, 200748, 2, 1840},
	{30684, 200752, 2, 1842},
	{30698, 200756, 2, 1844},
	{30712, 200760, 2, 1846},
	{30729, 200764, 2, 1848},
	{30746, 200768},
	{30759, 200772, 2, 1850},
	{30771, 200776},
	{30785, 200780},
	{30801, 200784},
	{30815, 200788},
	{30831, 200792},
	{30846, 200796},
	{30863, 200800},
	{30878, 200804},
	{30895, 200808, 2, 1852},
	{30917, 200812, 10, 1854},
	{30934, 200816, 2, 1864},
	{30955, 200820, 2, 1866},
	{30967, 200824},
	{30982, 200828, 6, 1868},
	{30997, 200832, 2, 1874},
	{31011, 200836},
	{31028, 200960},
	{31050, 200964},
	{31074, 200968},
	{31098, 200972},
	{31124, 212992},
	{31144, 212996},
	{31164, 213000},
	{31184, 213004},
	{31204, 213008},
	{31224, 213012},
	{31244, 213016},
	{31264, 213020},
	{31284, 213024},
	{31304, 213028},
	{31324, 213032},
	{31344, 213036},
	{31364, 213040},
	{31387, 213044},
	{31410, 213048},
	{31433, 213248},
	{31454, 213252},
	{31475, 213260},
	{31496, 213264},
	{31517, 213268},
	{31541, 213272},
	{31565, 213276},
	{31589, 213280},
	{31613, 213284},
	{31637, 213288},
	{31661, 213292},
	{31685, 213296},
	{31709, 213504},
	{31728, 213508},
	{31747, 213512},
	{31766, 213516},
	{31785, 213520},
	{31804, 213524},
	{31823, 213528},
	{31842, 213532},
	{31861, 213536},
	{31880, 213540},
	{31899, 213544},
	{31918, 213548},
	{31937, 213552},
	{31956, 213556},
	{31975, 213560},
	{31994, 213564},
	{32013, 213568},
	{32032, 213572},
	{32051, 213576},
	{32070, 213580},
	{32089, 213584},
	{32109, 213588},
	{32129, 213592},
	{32149, 213596},
	{32169, 214016},
	{32191, 214020, 1, 1876},
	{32213, 214024},
	{32235, 214028, 1, 1876},
	{32257, 214032},
	{32279, 214036, 1, 1876},
	{32301, 214040},
	{32323, 214044, 1, 1876},
	{32345, 214272},
	{32367, 214276},
	{32389, 214280},
	{32411, 214284},
	{32433, 214288},
	{32455, 214292},
	{32477, 214296},
	{32499, 214300},
	{32521, 214304},
	{32543, 214308},
	{32565, 214312},
	{32587, 214316},
	{32609, 214320},
	{32631, 214324},
	{32653, 214328},
	{32675, 214332},
	{32697, 214528},
	{32717, 214532},
	{32737, 214536},
	{32757, 214540},
	{32777, 214544},
	{32797, 214548},
	{32817, 214552},
	{32837, 214556},
	{32857, 214560},
	{32877, 214564},
	{32897, 214568},
	{32917, 214572},
	{32937, 214784},
	{32956, 214788},
	{32975, 214792},
	{32994, 214796},
	{33013, 214800},
	{33032, 214804},
	{33051, 214808},
	{33070, 214812},
	{33089, 214816},
	{33108, 214820},
	{33127, 214824},
	{33146, 214828},
	{33165, 214832},
	{33184, 214836},
	{33203, 214840},
	{33222, 214844},
	{33241, 214848},
	{33260, 214852},
	{33279, 214856},
	{33298, 214860},
	{33317, 214864},
	{33337, 214868},
	{33357, 214872},
	{33377, 214876},
	{33397, 214880},
	{33417, 214884},
	{33437, 214888},
	{33457, 214892},
	{33477, 214896},
	{33497, 214900},
	{33517, 214904},
	{33537, 214908},
	{33557, 215296},
	{33576, 215300},
	{33595, 215304},
	{33614, 215308},
	{33633, 215312},
	{33652, 215316},
	{33671, 215320},
	{33690, 215324},
	{33709, 215424},
	{33730, 215428},
	{33751, 215552},
	{33771, 215556},
	{33791, 215560},
	{33811, 215564},
	{33831, 215568},
	{33851, 215572},
	{33871, 215576},
	{33891, 215580},
	{33911, 215808},
	{33930, 215812},
	{33949, 215816},
	{33968, 215820},
	{33987, 216064},
	{34006, 216068},
	{34025, 216072},
	{34044, 216076},
	{34063, 216320},
	{34083, 216324},
	{34103, 216328},
	{34123, 216332},
	{34143, 216336},
	{34163, 216340},
	{34183, 216344},
	{34203, 216348},
	{34223, 216576},
	{34244, 216580},
	{34265, 216584},
	{34286, 216588},
	{34307, 216592},
	{34328, 216596},
	{34349, 216600},
	{34370, 216604},
	{34391, 216640},
	{34412, 216644},
	{34433, 216648},
	{34454, 216652},
	{34475, 216656},
	{34496, 216660},
	{34517, 216664},
	{34538, 216668},
	{34559, 216704},
	{34580, 216708},
	{34601, 216712},
	{34622, 216716},
	{34643, 216720},
	{34664, 216724},
	{34685, 216728},
	{34706, 216732},
	{34727, 216832},
	{34747, 216836},
	{34767, 216840},
	{34787, 216844},
	{34807, 216848},
	{34827, 216852},
	{34847, 216856},
	{34867, 216860},
	{34887, 216864},
	{34908, 216868},
	{34929, 216872},
	{34950, 216876},
	{34971, 216880},
	{34992, 216884},
	{35013, 216888},
	{35034, 216892},
	{35055, 217112},
	{35074, 217116},
	{35093, 217120},
	{35112, 217124},
	{35131, 217128},
	{35150, 217132},
	{35169, 217136},
	{35188, 217140},
	{35207, 217344},
	{35226, 217348},
	{35245, 217352},
	{35264, 217356},
	{35283, 217360},
	{35302, 217364},
	{35321, 217368},
	{35340, 217372},
	{35359, 217600},
	{35379, 217604},
	{35399, 217608},
	{35419, 217612},
	{35439, 217856},
	{35459, 217860},
	{35479, 217864},
	{35499, 217868},
	{35519, 217872},
	{35539, 217876},
	{35559, 217880},
	{35579, 217884},
	{35599, 217984},
	{35624, 217988, 2, 1877},
	{35649, 218016},
	{35675, 218020, 2, 1877},
	{35701, 218080},
	{35726, 218084},
	{35751, 218088},
	{35776, 218092},
	{35801, 218096},
	{35827, 218100},
	{35853, 218224},
	{35875, 218228},
	{35897, 218232},
	{35919, 218236},
	{35941, 218240},
	{35961, 218244},
	{35981, 218248},
	{36001, 218252},
	{36021, 218624},
	{36043, 218628},
	{36065, 218632},
	{36087, 218636},
	{36109, 218640},
	{36131, 218644},
	{36153, 218648},
	{36175, 218652},
	{36197, 218656},
	{36219, 218660},
	{36241, 218664},
	{36263, 218668},
	{36285, 218672},
	{36307, 218676},
	{36329, 218680},
	{36351, 218684},
	{36373, 218880},
	{36394, 218884},
	{36415, 218888},
	{36436, 218892},
	{36457, 218896},
	{36478, 218900},
	{36499, 218904},
	{36520, 218908},
	{36541, 219136},
	{36561, 219140},
	{36581, 219144},
	{36601, 219148},
	{36621, 219152},
	{36641, 219156},
	{36661, 219160},
	{36681, 219164},
	{36701, 219392},
	{36721, 219396},
	{36741, 221184, 5, 1879},
	{36765, 221188, 4, 1884},
	{36790, 221192, 5, 1879},
	{36814, 221196, 5, 1879},
	{36838, 221200, 4, 1884},
	{36863, 221204, 5, 1879},
	{36887, 221208, 4, 1884},
	{36912, 221212, 5, 1879},
	{36936, 221216, 4, 1888},
	{36952, 221220, 5, 1879},
	{36976, 221224, 3, 1892},
	{37010, 221228, 3, 1895},
	{37044, 221232, 3, 1898},
	{37069, 221236, 3, 1901},
	{37094, 221240, 3, 1898},
	{37119, 221248},
	{37134, 221252, 1, 1825},
	{37157, 221256},
	{37180, 221260},
	{37198, 221264, 2, 1904},
	{37216, 221268, 4, 1906},
	{37236, 221440, 20, 1910},
	{37261, 221444, 20, 1910},
	{37286, 221448, 15, 1930},
	{37314, 221452, 15, 1930},
	{37342, 221456, 15, 1930},
	{37370, 221460, 15, 1930},
	{37398, 221492, 8, 1945},
	{37426, 221496, 8, 1945},
	{37454, 221696, 5, 1953},
	{37477, 221700, 4, 1958},
	{37501, 221704, 5, 1953},
	{37524, 221708, 4, 1958},
	{37548, 221712, 5, 1953},
	{37571, 221716, 4, 1958},
	{37595, 221720, 5, 1953},
	{37618, 221724, 4, 1958},
	{37642, 221728, 2, 1962},
	{37665, 221736, 2, 1962},
	{37688, 221744, 2, 1962},
	{37711, 221752, 2, 1962},
	{37734, 221760, 2, 1962},
	{37757, 221768, 2, 1962},
	{37780, 221776, 2, 1962},
	{37804, 221784, 2, 1962},
	{37828, 222208, 5, 1964},
	{37854, 222212, 4, 1969},
	{37881, 222216, 5, 1964},
	{37907, 222220, 4, 1969},
	{37934, 222224, 5, 1964},
	{37960, 222228, 4, 1969},
	{37987, 222232, 5, 1964},
	{38013, 222236, 4, 1969},
	{38040, 222464, 5, 1964},
	{38066, 222468, 4, 1969},
	{38093, 222472, 1, 1879},
	{38119, 222476, 1, 1879},
	{38145, 222480, 1, 1879},
	{38171, 222484, 1, 1879},
	{38197, 222488, 1, 1879},
	{38223, 222492, 1, 1879},
	{38249, 222496, 1, 1879},
	{38275, 222720, 5, 1964},
	{38299, 222724, 5, 1964},
	{38323, 222728, 5, 1964},
	{38347, 222732, 5, 1964},
	{38371, 222736, 4, 1969},
	{38396, 222740, 4, 1969},
	{38421, 222744, 4, 1969},
	{38446, 222748, 4, 1969},
	{38471, 222752, 1, 1879},
	{38495, 222756, 1, 1879},
	{38519, 222760, 8, 1973},
	{38540, 222976, 4, 1981},
	{38563, 222980, 4, 1981},
	{38586, 222984, 4, 1981},
	{38609, 222988, 4, 1981},
	{38632, 222992, 4, 1981},
	{38655, 222996, 4, 1981},
	{38678, 223000, 4, 1981},
	{38701, 223004, 4, 1981},
	{38724, 223008, 4, 1981},
	{38747, 223012, 4, 1981},
	{38770, 223016, 4, 1981},
	{38794, 223020, 4, 1981},
	{38818, 223024, 4, 1981},
	{38842, 223028, 4, 1981},
	{38866, 223032, 4, 1981},
	{38890, 223036, 4, 1981},
	{38914, 223104, 9, 1985},
	{38934, 223112, 1, 1994},
	{38955, 223232, 5, 1964},
	{38980, 223236, 4, 1969},
	{39006, 223240, 8, 1995},
	{39029, 223488, 3, 2003},
	{39052, 223492, 3, 2003},
	{39075, 223496, 3, 2003},
	{39098, 223500, 3, 2003},
	{39121, 223504, 2, 2006},
	{39145, 223508, 2, 2006},
	{39169, 223744, 5, 1964},
	{39193, 223748, 5, 1964},
	{39217, 223752, 5, 1964},
	{39241, 223756, 5, 1964},
	{39265, 223760, 4, 1969},
	{39290, 224000, 5, 2008},
	{39313, 224004, 4, 2013},
	{39337, 224008, 3, 2017},
	{39360, 224256, 5, 2008},
	{39383, 224260, 4, 2013},
	{39407, 224264, 3, 2017},
	{39430, 224512, 5, 1964},
	{39454, 224516, 4, 1969},
	{39479, 224520, 5, 1964},
	{39503, 224524, 4, 1969},
	{39528, 224528, 3, 2020},
	{39552, 224532, 3, 2020},
	{39576, 224768, 5, 1964},
	{39601, 224772, 4, 1958},
	{39627, 224776, 5, 1964},
	{39652, 224780, 4, 1958},
	{39678, 224784, 3, 2020},
	{39703, 224788, 3, 2020},
	{39728, 224832, 5, 1964},
	{39753, 224836, 4, 1958},
	{39779, 224840, 5, 1964},
	{39804, 224844, 4, 1958},
	{39830, 224848, 3, 2020},
	{39855, 224852, 3, 2020},
	{39880, 224896, 5, 1964},
	{39905, 224900, 4, 1958},
	{39931, 224904, 3, 2020},
	{39956, 224908, 3, 2020},
	{39981, 224912, 3, 2020},
	{40006, 225024, 5, 1964},
	{40030, 225028, 4, 1958},
	{40055, 225032, 3, 2020},
	{40079, 225036, 3, 2020},
	{40103, 225040, 3, 2020},
	{40127, 225048, 5, 1964},
	{40152, 225052, 4, 1958},
	{40178, 225056, 3, 2020},
	{40203, 225060, 3, 2020},
	{40228, 225064, 3, 2020},
	{40253, 225280, 12, 2023},
	{40275, 225284, 5, 2035},
	{40298, 225288, 4, 2040},
	{40322, 225292, 2, 2044},
	{40345, 225296, 2, 2044},
	{40368, 225300, 2, 2044},
	{40391, 225536, 5, 1964},
	{40414, 225540, 4, 1969},
	{40438, 225544, 5, 1964},
	{40461, 225548, 4, 1969},
	{40485, 225552, 5, 1964},
	{40508, 225560, 5, 1964},
	{40531, 225792, 4, 2046},
	{40552, 225796},
	{40581, 225800, 2, 2050},
	{40610, 225804},
	{40636, 225808, 7, 2052},
	{40665, 225812},
	{40684, 225816, 2, 2059},
	{40710, 225820, 2, 2061},
	{40733, 225824},
	{40756, 225828, 2, 2063},
	{40783, 225832},
	{40810, 225836, 2, 2065},
	{40835, 225840, 2, 2067},
	{40863, 225844, 2, 2069},
	{40891, 225848, 2, 2071},
	{40914, 225852, 2, 2073},
	{40937, 225856},
	{40970, 225860, 2, 2075},
	{41003, 225864},
	{41035, 225868, 2, 2075},
	{41067, 225872, 2, 2077},
	{41086, 225876, 2, 2079},
	{41113, 225880},
	{41140, 225884, 2, 2081},
	{41167, 225888, 2, 2083},
	{41194, 225892, 10, 2085},
	{41215, 225896, 8, 2095},
	{41234, 225900, 8, 2103},
	{41253, 225904, 2, 2111},
	{41277, 225908, 2, 2113},
	{41309, 225912, 2, 2115},
	{41339, 225916, 4, 2117},
	{41375, 225920, 3, 2121},
	{41408, 225924, 1, 2124},
	{41426, 225932, 1, 2125},
	{41446, 226048, 2, 2126},
	{41463, 226052, 1, 2128},
	{41487, 226056, 1, 2128},
	{41511, 226060, 4, 2129},
	{41537, 226064, 3, 2133},
	{41566, 226068, 1, 694},
	{41595, 226072, 3, 2133},
	{41624, 226076, 1, 694},
	{41653, 226192, 1, 2136},
	{41674, 226196, 1, 2136},
	{41701, 226304, 5, 2035},
	{41725, 226308, 4, 2040},
	{41750, 226312, 2, 2044},
	{41774, 226316, 5, 2035},
	{41798, 226320, 4, 2040},
	{41823, 226324, 2, 2044},
	{41847, 226328, 10, 2137},
	{41869, 226432, 5, 2147},
	{41896, 226436, 5, 2147},
	{41923, 226440, 6, 2152},
	{41955, 226480, 5, 2147},
	{41983, 226484, 5, 2147},
	{42011, 226488, 5, 2147},
	{42039, 226492, 5, 2147},
	{42067, 226496, 5, 2147},
	{42095, 226500, 5, 2147},
	{42123, 226504, 5, 2147},
	{42151, 226508, 5, 2147},
	{42179, 226512, 6, 2152},
	{42212, 226544, 5, 1964},
	{42241, 226548, 5, 1964},
	{42270, 226552, 4, 1969},
	{42300, 226556, 4, 1969},
	{42330, 226560, 8, 1995},
	{42357, 226564, 8, 1995},
	{42384, 226608, 5, 1964},
	{42414, 226612, 4, 1969},
	{42445, 226616, 8, 1995},
	{42473, 226688, 5, 2035},
	{42497, 226692, 4, 2040},
	{42522, 226696, 3, 2158},
	{42546, 226700, 2, 2161},
	{42572, 226704, 2, 2161},
	{42598, 226816, 5, 1964},
	{42624, 226820, 4, 1969},
	{42651, 226824, 5, 1964},
	{42677, 226828, 5, 1964},
	{42703, 226832, 5, 1964},
	{42729, 226836, 1, 1879},
	{42755, 226840, 1, 1879},
	{42781, 226844, 1, 1879},
	{42807, 226848, 1, 1879},
	{42833, 226880, 4, 1969},
	{42860, 226884, 4, 1969},
	{42887, 226888, 4, 1969},
	{42914, 227072, 5, 1964},
	{42939, 227076, 4, 1958},
	{42965, 227080, 3, 2020},
	{42990, 227084, 3, 2020},
	{43015, 227088, 3, 2020},
	{43040, 227200, 5, 1964},
	{43064, 227204, 4, 1958},
	{43089, 227208, 3, 2020},
	{43113, 227212, 3, 2020},
	{43137, 227216, 3, 2020},
	{43161, 227328, 5, 1964},
	{43185, 227332, 4, 1969},
	{43210, 227336, 8, 1995},
	{206, 880, 4, 2163},
	{43232, 881},
	{27079, 882},
	{43244, 1008},
	{43255, 1009},
	{27267, 1010, 4, 2167},
	{43266, 1040, 1, 2171},
	{43279, 1041, 5, 2172},
	{43292, 1042, 1, 2177},
	{43305, 1043, 1, 1688},
	{27101, 1045, 7, 2178},
	{43318, 1168, 12, 2185},
	{43333, 1281, 6, 2197},
	{43348, 1282},
	{27038, 1283},
	{43232, 1285},
	{27079, 1286},
	{43360, 1414, 15, 2203},
};

static const struct si_reg gfx103_reg_table[] = {
	{43369, 40, 1, 2218},
	{43384, 44, 1, 2218},
	{1390, 1028, 8, 0},
	{1403, 1032, 20, 10},
	{1418, 1036, 10, 2219},
	{1434, 1040, 12, 40},
	{1455, 1044, 4, 52},
	{1473, 1048, 3, 56},
	{1491, 1052, 8, 2229},
	{1506, 1056},
	{1520, 1060, 1, 70},
	{1534, 1064},
	{1551, 1076, 2, 78},
	{1567, 1080},
	{1962, 1104},
	{1986, 1108},
	{1584, 1116, 5, 80},
	{1599, 1120, 6, 85},
	{1614, 1124, 2, 92},
	{1634, 1128, 1, 94},
	{1653, 1132, 4, 95},
	{1673, 1136, 5, 99},
	{43407, 1140, 1, 2237},
	{1689, 2480},
	{1703, 2484},
	{1717, 2488},
	{1731, 2492},
	{1745, 2496},
	{1759, 2500},
	{1773, 2504},
	{1787, 2508},
	{1801, 2512},
	{1815, 2516},
	{1829, 2520},
	{1844, 2524},
	{1859, 2528},
	{1874, 2532},
	{1889, 2536},
	{1904, 2540},
	{1919, 2544},
	{1930, 2552},
	{1946, 2556},
	{2034, 32776, 29, 2238},
	{2047, 32784, 20, 2267},
	{2059, 32788, 14, 154},
	{2075, 32792, 14, 154},
	{2091, 32796, 15, 168},
	{2104, 32824, 14, 154},
	{2120, 32828, 14, 154},
	{2136, 33296, 21, 183},
	{2150, 33300, 28, 204},
	{2167, 33304, 15, 232},
	{2188, 33308, 28, 247},
	{2202, 33312, 32, 275},
	{2219, 33316, 13, 307},
	{2240, 33320, 9, 320},
	{2258, 33324, 1, 329},
	{43429, 33328, 1, 2287},
	{2281, 33344, 2, 330},
	{2302, 33348},
	{2322, 33352, 1, 332},
	{2345, 33356, 9, 333},
	{2363, 33436, 1, 342},
	{2386, 36096},
	{2412, 36100, 2, 343},
	{2438, 36104},
	{2464, 36108, 2, 343},
	{2490, 36112, 2, 345},
	{2511, 36116, 4, 347},
	{2532, 36120, 6, 2288},
	{2559, 36124, 20, 2294},
	{2580, 36128, 7, 2314},
	{2603, 36132},
	{2632, 36140},
	{2662, 36144},
	{2694, 36148},
	{2725, 36152},
	{43456, 36156, 3, 2321},
	{2758, 36348, 5, 378},
	{2767, 36608},
	{2785, 36612, 4, 383},
	{2803, 36616},
	{2821, 36620, 11, 2324},
	{2839, 36656, 14, 397},
	{2857, 36660, 4, 411},
	{2875, 36664, 9, 415},
	{2893, 36668, 2, 424},
	{2911, 37168, 9, 2335},
	{2927, 39160, 6, 2344},
	{3722, 40960},
	{3740, 40964, 4, 449},
	{3758, 40968, 3, 453},
	{3776, 40972, 9, 456},
	{3794, 40976, 3, 2350},
	{3812, 40980, 8, 2353},
	{3830, 40984, 11, 2361},
	{3848, 40988},
	{3866, 41120, 10, 484},
	{3898, 45060, 1, 494},
	{3922, 45080},
	{3947, 45084, 3, 495},
	{3971, 45088},
	{3992, 45092, 1, 498},
	{4013, 45096, 12, 2372},
	{4037, 45100, 10, 510},
	{4061, 45104},
	{4087, 45108},
	{4113, 45112},
	{4139, 45116},
	{4165, 45120},
	{4191, 45124},
	{4217, 45128},
	{4243, 45132},
	{4269, 45136},
	{4295, 45140},
	{4321, 45144},
	{4348, 45148},
	{4375, 45152},
	{4402, 45156},
	{4429, 45160},
	{4456, 45164},
	{4483, 45168},
	{4510, 45172},
	{4537, 45176},
	{4564, 45180},
	{4591, 45184},
	{4618, 45188},
	{4645, 45192},
	{4672, 45196},
	{4699, 45200},
	{4726, 45204},
	{4753, 45208},
	{4780, 45212},
	{4807, 45216},
	{4834, 45220},
	{4861, 45224},
	{4888, 45228},
	{4915, 45248, 8, 520},
	{4971, 45256, 1, 533},
	{4998, 45260, 1, 533},
	{5025, 45264, 1, 533},
	{5052, 45268, 1, 533},
	{5079, 45316, 1, 494},
	{5103, 45332},
	{5128, 45336, 3, 495},
	{5152, 45340, 1, 534},
	{5177, 45344},
	{5198, 45348, 1, 498},
	{5219, 45352, 12, 535},
	{5243, 45356, 14, 547},
	{5267, 45360},
	{5293, 45364},
	{5319, 45368},
	{5345, 45372},
	{5371, 45376},
	{5397, 45380},
	{5423, 45384},
	{5449, 45388},
	{5475, 45392},
	{5501, 45396},
	{5527, 45400},
	{5554, 45404},
	{5581, 45408},
	{5608, 45412},
	{5635, 45416},
	{5662, 45420},
	{5689, 45424},
	{5716, 45428},
	{5743, 45432},
	{5770, 45436},
	{5797, 45440},
	{5824, 45444},
	{5851, 45448},
	{5878, 45452},
	{5905, 45456},
	{5932, 45460},
	{5959, 45464},
	{5986, 45468},
	{6013, 45472},
	{6040, 45476},
	{6067, 45480},
	{6094, 45484},
	{6121, 45504, 8, 520},
	{6177, 45512, 1, 533},
	{6204, 45516, 1, 533},
	{6231, 45520, 1, 533},
	{6258, 45524, 1, 533},
	{6285, 45548, 9, 561},
	{6366, 45568},
	{6391, 45572, 2, 581},
	{6415, 45576},
	{6447, 45580},
	{6479, 45584},
	{6503, 45588, 1, 498},
	{6527, 45596, 4, 583},
	{6551, 45600},
	{6572, 45604, 1, 498},
	{6593, 45608, 13, 587},
	{6617, 45612, 9, 600},
	{6641, 45616},
	{6667, 45620},
	{6693, 45624},
	{6719, 45628},
	{6745, 45632},
	{6771, 45636},
	{6797, 45640},
	{6823, 45644},
	{6849, 45648},
	{6875, 45652},
	{6901, 45656},
	{6928, 45660},
	{6955, 45664},
	{6982, 45668},
	{7009, 45672},
	{7036, 45676},
	{7063, 45680},
	{7090, 45684},
	{7117, 45688},
	{7144, 45692},
	{7171, 45696},
	{7198, 45700},
	{7225, 45704},
	{7252, 45708},
	{7279, 45712},
	{7306, 45716},
	{7333, 45720},
	{7360, 45724},
	{7387, 45728},
	{7414, 45732},
	{7441, 45736},
	{7468, 45740},
	{7495, 45760, 8, 520},
	{7555, 45768, 1, 533},
	{7584, 45772, 1, 533},
	{7613, 45776, 1, 533},
	{7642, 45780, 1, 533},
	{7722, 45856},
	{7743, 45860, 1, 498},
	{8261, 46080},
	{8286, 46084, 1, 494},
	{8310, 46088},
	{8342, 46092},
	{8374, 46096},
	{8398, 46100, 1, 498},
	{8422, 46108, 4, 619},
	{8446, 46112},
	{8467, 46116, 1, 498},
	{8488, 46120, 12, 623},
	{8512, 46124, 9, 635},
	{8536, 46128},
	{8562, 46132},
	{8588, 46136},
	{8614, 46140},
	{8640, 46144},
	{8666, 46148},
	{8692, 46152},
	{8718, 46156},
	{8744, 46160},
	{8770, 46164},
	{8796, 46168},
	{8823, 46172},
	{8850, 46176},
	{8877, 46180},
	{8904, 46184},
	{8931, 46188},
	{8958, 46192},
	{8985, 46196},
	{9012, 46200},
	{9039, 46204},
	{9066, 46208},
	{9093, 46212},
	{9120, 46216},
	{9147, 46220},
	{9174, 46224},
	{9201, 46228},
	{9228, 46232},
	{9255, 46236},
	{9282, 46240},
	{9309, 46244},
	{9336, 46248},
	{9363, 46252},
	{9390, 46272, 8, 520},
	{9450, 46280, 1, 533},
	{9479, 46284, 1, 533},
	{9508, 46288, 1, 533},
	{9537, 46292, 1, 533},
	{9617, 46368},
	{9638, 46372, 1, 498},
	{10129, 47104, 13, 653},
	{10156, 47108},
	{10170, 47112},
	{10184, 47116},
	{10198, 47120},
	{10214, 47124},
	{10230, 47128},
	{10246, 47132, 2, 666},
	{10267, 47136, 2, 666},
	{10288, 47140, 2, 666},
	{10309, 47144, 1, 668},
	{10337, 47148, 1, 669},
	{10362, 47152},
	{10377, 47156, 1, 670},
	{10392, 47160},
	{10421, 47164, 1, 670},
	{10450, 47168},
	{10483, 47172, 1, 670},
	{10516, 47176, 12, 671},
	{10534, 47180, 11, 683},
	{10552, 47184, 1, 694},
	{10565, 47188, 6, 695},
	{10589, 47192},
	{10616, 47196},
	{10643, 47200, 2, 701},
	{10664, 47204},
	{10691, 47208},
	{10718, 47212},
	{10736, 47216},
	{10754, 47220},
	{10772, 47224, 1, 703},
	{10800, 47228, 5, 704},
	{10822, 47232},
	{10842, 47236},
	{10865, 47240, 9, 709},
	{10882, 47248, 1, 533},
	{10903, 47252, 1, 533},
	{10924, 47256, 1, 533},
	{10945, 47260, 1, 533},
	{10966, 47264, 1, 718},
	{10984, 47268, 1, 719},
	{11003, 47272},
	{11025, 47276, 3, 720},
	{11042, 47280},
	{11071, 47284, 1, 723},
	{11100, 47288, 3, 720},
	{11118, 47360},
	{11138, 47364},
	{11158, 47368},
	{11178, 47372},
	{11198, 47376},
	{11218, 47380},
	{11238, 47384},
	{11258, 47388},
	{11278, 47392},
	{11298, 47396},
	{11318, 47400},
	{11339, 47404},
	{11360, 47408},
	{11381, 47412},
	{11402, 47416},
	{11423, 47420},
	{11444, 47604, 2, 724},
	{11468, 47608},
	{11489, 47612},
	{11505, 163840, 11, 2384},
	{11523, 163844, 11, 736},
	{11540, 163848, 7, 747},
	{11554, 163852, 23, 754},
	{11573, 163856, 18, 2395},
	{11593, 163860},
	{11612, 163868, 2, 793},
	{11629, 163872},
	{11649, 163876},
	{11669, 163880, 1, 795},
	{11686, 163884},
	{11701, 163888, 2, 796},
	{11725, 163892, 2, 798},
	{11749, 163896, 3, 800},
	{11765, 163900, 8, 803},
	{11783, 163904, 14, 811},
	{11793, 163908, 9, 825},
	{11809, 163912},
	{11824, 163916},
	{11845, 163920},
	{11861, 163924},
	{11883, 163928, 2, 834},
	{11901, 163932, 1, 836},
	{43480, 163940, 3, 2413},
	{11919, 163944, 1, 837},
	{11937, 163948, 1, 837},
	{11961, 163952, 1, 837},
	{11980, 163956, 1, 837},
	{12005, 163960, 1, 837},
	{12027, 163964, 13, 2416},
	{12051, 163968},
	{12067, 163972, 1, 847},
	{12086, 164328, 1, 848},
	{12107, 164332, 1, 848},
	{12128, 164336, 1, 848},
	{12149, 164340, 1, 848},
	{12170, 164344},
	{12188, 164348},
	{12206, 164352, 2, 849},
	{12226, 164356, 3, 851},
	{12250, 164360, 2, 854},
	{12274, 164364, 1, 856},
	{12294, 164368, 2, 851},
	{12314, 164372, 2, 854},
	{12334, 164376, 2, 851},
	{12354, 164380, 2, 854},
	{12374, 164384, 2, 851},
	{12394, 164388, 2, 854},
	{12414, 164392, 2, 851},
	{12434, 164396, 2, 854},
	{12454, 164400, 7, 857},
	{12469, 164404, 2, 864},
	{12498, 164408, 8, 866},
	{12513, 164412, 8, 874},
	{12528, 164416, 3, 851},
	{12553, 164420, 2, 854},
	{12578, 164424},
	{12596, 164428},
	{12614, 164432, 3, 851},
	{12639, 164436, 2, 854},
	{12664, 164440, 3, 851},
	{12689, 164444, 2, 854},
	{12714, 164448, 3, 851},
	{12739, 164452, 2, 854},
	{12764, 164456, 3, 851},
	{12789, 164460, 2, 854},
	{12814, 164464, 3, 851},
	{12839, 164468, 2, 854},
	{12864, 164472, 3, 851},
	{12889, 164476, 2, 854},
	{12914, 164480, 3, 851},
	{12939, 164484, 2, 854},
	{12964, 164488, 3, 851},
	{12989, 164492, 2, 854},
	{13014, 164496, 3, 851},
	{13039, 164500, 2, 854},
	{13064, 164504, 3, 851},
	{13089, 164508, 2, 854},
	{13114, 164512, 3, 851},
	{13140, 164516, 2, 854},
	{13166, 164520, 3, 851},
	{13192, 164524, 2, 854},
	{13218, 164528, 3, 851},
	{13244, 164532, 2, 854},
	{13270, 164536, 3, 851},
	{13296, 164540, 2, 854},
	{13322, 164544, 3, 851},
	{13348, 164548, 2, 854},
	{13374, 164552, 3, 851},
	{13400, 164556, 2, 854},
	{13426, 164560},
	{13445, 164564},
	{13464, 164568},
	{13483, 164572},
	{13502, 164576},
	{13521, 164580},
	{13540, 164584},
	{13559, 164588},
	{13578, 164592},
	{13597, 164596},
	{13616, 164600},
	{13635, 164604},
	{13654, 164608},
	{13673, 164612},
	{13692, 164616},
	{13711, 164620},
	{13730, 164624},
	{13749, 164628},
	{13768, 164632},
	{13787, 164636},
	{13806, 164640},
	{13826, 164644},
	{13846, 164648},
	{13866, 164652},
	{13886, 164656},
	{13906, 164660},
	{13926, 164664},
	{13946, 164668},
	{13966, 164672},
	{13986, 164676},
	{14006, 164680},
	{14026, 164684},
	{14046, 164688, 15, 882},
	{14066, 164692, 3, 897},
	{14088, 164696, 2, 900},
	{14116, 164700, 6, 2429},
	{14145, 164704, 1, 909},
	{14166, 164708, 1, 910},
	{14176, 164712, 1, 911},
	{43501, 164716},
	{43523, 164720},
	{14244, 164864},
	{14261, 164868},
	{14278, 164872},
	{14294, 164876},
	{14323, 164880, 14, 2435},
	{14348, 164884},
	{14361, 164888},
	{14376, 164892},
	{14390, 164896},
	{14405, 164900, 8, 930},
	{14420, 164904, 4, 938},
	{14444, 164908, 6, 942},
	{14463, 164912, 4, 948},
	{14481, 164916, 4, 952},
	{14502, 164924},
	{14521, 164928},
	{14541, 164932},
	{14560, 164936},
	{14580, 164940},
	{14599, 164944},
	{14619, 164948},
	{14640, 164952},
	{14662, 164956},
	{14683, 164960},
	{14705, 164964},
	{14726, 164968},
	{14748, 164972},
	{14769, 164976},
	{14791, 164980},
	{14812, 164984},
	{14834, 164988},
	{14855, 164992},
	{14877, 164996},
	{14898, 165000},
	{14920, 165004},
	{14941, 165008},
	{14963, 165012},
	{14984, 165016},
	{15006, 165020},
	{15027, 165024},
	{15049, 165028},
	{15070, 165032},
	{15092, 165036},
	{15113, 165040},
	{15135, 165044},
	{15156, 165048},
	{15178, 165052},
	{15199, 165056},
	{15221, 165060},
	{15242, 165064},
	{15264, 165068},
	{15285, 165072},
	{15307, 165076},
	{15328, 165080},
	{15350, 165084},
	{15371, 165088},
	{15393, 165092},
	{15414, 165096},
	{15436, 165100},
	{15457, 165104},
	{15479, 165108},
	{15500, 165112},
	{15522, 165116},
	{15543, 165120},
	{15565, 165124},
	{15586, 165128},
	{15608, 165132},
	{15629, 165136},
	{15651, 165140},
	{15672, 165144},
	{15694, 165148},
	{15715, 165152},
	{15737, 165156},
	{15758, 165160},
	{15780, 165164},
	{15802, 165168},
	{15825, 165172},
	{15847, 165176},
	{15870, 165180},
	{15892, 165184},
	{15915, 165188},
	{15937, 165192},
	{15960, 165196},
	{15982, 165200},
	{16005, 165204},
	{16027, 165208},
	{16050, 165212},
	{16072, 165216},
	{16095, 165220},
	{16117, 165224},
	{16140, 165228},
	{16162, 165232},
	{16185, 165236},
	{16207, 165240},
	{16230, 165244},
	{16252, 165248},
	{16275, 165252},
	{16297, 165256},
	{16320, 165260},
	{16342, 165264},
	{16365, 165268},
	{16387, 165272},
	{16410, 165276},
	{16432, 165280},
	{16455, 165284},
	{16477, 165288},
	{16500, 165292},
	{16522, 165296},
	{16545, 165300},
	{16567, 165304},
	{16590, 165308},
	{16604, 165312},
	{16618, 165316},
	{16632, 165320},
	{16646, 165324},
	{16660, 165328},
	{16674, 165332},
	{16688, 165336},
	{16702, 165340},
	{16716, 165344},
	{16730, 165348},
	{16744, 165352},
	{16758, 165356},
	{16772, 165360},
	{16786, 165364},
	{16800, 165368},
	{16814, 165372},
	{16828, 165376},
	{16842, 165380},
	{16856, 165384},
	{16870, 165388},
	{16884, 165392},
	{16898, 165396},
	{16912, 165400},
	{16926, 165404},
	{16949, 165444, 13, 2449},
	{16969, 165448, 13, 2449},
	{16989, 165452, 13, 2449},
	{17009, 165456, 13, 2449},
	{17029, 165460, 13, 2449},
	{17049, 165464, 13, 2449},
	{17069, 165468, 13, 2449},
	{17089, 165472, 13, 2449},
	{17109, 165476, 13, 2449},
	{17129, 165480, 13, 2449},
	{17149, 165484, 13, 2449},
	{17170, 165488, 13, 2449},
	{17191, 165492, 13, 2449},
	{17212, 165496, 13, 2449},
	{17233, 165500, 13, 2449},
	{17254, 165504, 13, 2449},
	{17275, 165508, 13, 2449},
	{17296, 165512, 13, 2449},
	{17317, 165516, 13, 2449},
	{17338, 165520, 13, 2449},
	{17359, 165524, 10, 2462},
	{17380, 165528, 10, 2462},
	{17401, 165532, 10, 2462},
	{17422, 165536, 10, 2462},
	{17443, 165540, 10, 2462},
	{17464, 165544, 10, 2462},
	{17485, 165548, 10, 2462},
	{17506, 165552, 10, 2462},
	{17527, 165556, 10, 2462},
	{17548, 165560, 10, 2462},
	{17569, 165564, 10, 2462},
	{17590, 165568, 10, 2462},
	{17611, 165572, 4, 2472},
	{17629, 165580, 16, 980},
	{17646, 165584, 16, 980},
	{17664, 165588, 7, 996},
	{17685, 165592, 6, 2476},
	{17703, 165600, 7, 1009},
	{17718, 165608, 2, 701},
	{17735, 165640, 1, 1016},
	{17757, 165644, 5, 1017},
	{17779, 165648, 1, 1022},
	{17799, 165652, 8, 1023},
	{43545, 165712, 8, 2482},
	{17821, 165716, 8, 2490},
	{17839, 165720, 8, 1039},
	{17860, 165724, 17, 1047},
	{17881, 165728, 6, 1064},
	{17899, 165732, 6, 1064},
	{17917, 165736, 6, 1064},
	{17935, 165740, 6, 1064},
	{17953, 165744, 6, 1064},
	{17971, 165748, 6, 1064},
	{17989, 165752, 6, 1064},
	{18007, 165756, 6, 1064},
	{18025, 165760, 9, 1070},
	{18043, 165764, 9, 1070},
	{18061, 165768, 9, 1070},
	{18079, 165772, 9, 1070},
	{18097, 165776, 9, 1070},
	{18115, 165780, 9, 1070},
	{18133, 165784, 9, 1070},
	{18151, 165788, 9, 1070},
	{18169, 165836, 1, 1079},
	{18183, 165840, 1, 1079},
	{18198, 165844},
	{18216, 165848},
	{18234, 165852},
	{18251, 165856},
	{18272, 165860, 1, 1080},
	{18288, 165864},
	{18301, 165872, 6, 2498},
	{18320, 165876},
	{18335, 165880, 1, 1089},
	{18357, 165884, 1, 1090},
	{18384, 165888, 10, 1091},
	{18401, 165892, 12, 1101},
	{18409, 165896, 5, 2504},
	{18426, 165900, 17, 1117},
	{18444, 165904, 20, 1134},
	{18460, 165908, 16, 1154},
	{18479, 165912, 10, 1170},
	{18494, 165916, 30, 2509},
	{18512, 165920, 16, 1208},
	{18530, 165924, 4, 1224},
	{18554, 165928},
	{18579, 165932, 11, 1228},
	{18602, 165936, 5, 1239},
	{18653, 165944, 3, 2539},
	{18668, 165948, 5, 1250},
	{18698, 165952, 5, 1255},
	{18713, 165956},
	{43571, 165960, 6, 2542},
	{18731, 166400, 2, 1260},
	{18748, 166404, 2, 1262},
	{18767, 166408, 1, 1264},
	{18783, 166412, 4, 1265},
	{18802, 166416, 1, 1269},
	{18823, 166420, 1, 1270},
	{18836, 166424},
	{18859, 166428},
	{18882, 166432, 1, 1271},
	{18902, 166436, 4, 1272},
	{18922, 166440, 1, 1276},
	{18943, 166444, 1, 1277},
	{18958, 166448, 6, 1278},
	{18980, 166452, 6, 1278},
	{19002, 166456, 8, 1284},
	{19028, 166460, 8, 1284},
	{19054, 166464, 15, 1292},
	{19066, 166468, 3, 1307},
	{19085, 166472, 6, 2548},
	{19103, 166476, 24, 1317},
	{19121, 166480},
	{19133, 166484, 1, 1341},
	{19147, 166488, 1, 1342},
	{19161, 166492, 1, 1343},
	{19175, 166496, 1, 1344},
	{19198, 166500, 1, 1344},
	{19221, 166504, 1, 1344},
	{19244, 166508, 5, 1345},
	{19265, 166512},
	{19276, 166516},
	{19289, 166520},
	{19306, 166524, 9, 2554},
	{19325, 166528},
	{19336, 166532, 3, 1358},
	{19355, 166536},
	{19377, 166540},
	{19399, 166544, 3, 1361},
	{19419, 166548, 2, 1364},
	{19446, 166552, 4, 2563},
	{19468, 166560},
	{19493, 166564},
	{19518, 166568, 6, 1371},
	{19537, 166572, 1, 1377},
	{19560, 166576, 1, 1377},
	{19583, 166580, 1, 1378},
	{19597, 166584, 1, 1379},
	{19612, 166588, 10, 2567},
	{19629, 166592, 4, 1389},
	{19656, 166596, 4, 1393},
	{19683, 166600, 4, 1397},
	{19702, 166608},
	{19728, 166612, 1, 1401},
	{19753, 166620},
	{19781, 166624},
	{19807, 166628, 1, 1401},
	{19832, 166636},
	{19860, 166640},
	{19886, 166644, 1, 1401},
	{19911, 166652},
	{19939, 166656},
	{19965, 166660, 1, 1401},
	{19990, 166668},
	{20018, 166696},
	{20049, 166700},
	{20092, 166704, 1, 1402},
	{20130, 166712, 1, 1403},
	{20150, 166732, 2, 1404},
	{20169, 166736, 5, 1406},
	{20191, 166740, 20, 2577},
	{20212, 166744, 3, 1430},
	{20229, 166748, 1, 1377},
	{20250, 166752, 1, 1377},
	{20273, 166756, 1, 1377},
	{20296, 166760, 1, 1377},
	{20319, 166764, 12, 1433},
	{20332, 166768, 6, 1445},
	{20349, 166772},
	{20373, 166776, 2, 1451},
	{20403, 166780},
	{20427, 166784},
	{20457, 166788},
	{20488, 166792},
	{20517, 166796},
	{20547, 166800, 3, 1453},
	{20567, 166804, 8, 1456},
	{20586, 166808, 4, 1464},
	{20612, 166812, 3, 1361},
	{20636, 166868, 8, 1468},
	{20662, 166872, 8, 1476},
	{20688, 166876, 5, 1484},
	{20704, 166880, 8, 2597},
	{20720, 166884, 3, 1495},
	{20735, 166888},
	{20758, 166892},
	{20781, 166896},
	{20804, 166900},
	{20827, 166904, 8, 1498},
	{20861, 166908, 8, 1506},
	{20895, 166912, 8, 1514},
	{20929, 166916, 8, 1522},
	{20963, 166920, 8, 1498},
	{20997, 166924, 8, 1506},
	{21031, 166928, 8, 1514},
	{21065, 166932, 8, 1522},
	{21099, 166936, 8, 1498},
	{21133, 166940, 8, 1506},
	{21167, 166944, 8, 1514},
	{21201, 166948, 8, 1522},
	{21235, 166952, 8, 1498},
	{21269, 166956, 8, 1506},
	{21303, 166960, 8, 1514},
	{21337, 166964, 8, 1522},
	{21371, 166968, 2, 1530},
	{21395, 166972, 2, 1532},
	{21419, 166976, 4, 1534},
	{21440, 166980, 12, 1538},
	{21460, 166984, 2, 1550},
	{21480, 166988, 20, 1552},
	{21518, 166992, 2, 1572},
	{21538, 167000, 1, 1574},
	{21566, 167004, 1, 1575},
	{21587, 167008},
	{21602, 167012, 2, 1576},
	{21618, 167016, 1, 1578},
	{21634, 167020, 3, 1579},
	{21649, 167024, 19, 2605},
	{21664, 167028, 8, 1601},
	{21681, 167032, 14, 2624},
	{21703, 167036},
	{21719, 167040, 1, 1621},
	{21741, 167044},
	{21757, 167048, 1, 1578},
	{21779, 167052},
	{21801, 167056},
	{21823, 167060},
	{21842, 167068},
	{21857, 167072, 2, 1576},
	{21873, 167076, 1, 1578},
	{21889, 167080, 3, 1579},
	{21904, 167084, 19, 2605},
	{21919, 167088, 8, 1601},
	{21936, 167092, 14, 2624},
	{21958, 167096},
	{21974, 167100, 1, 1621},
	{21996, 167104},
	{22012, 167108, 1, 1578},
	{22034, 167112},
	{22056, 167116},
	{22078, 167120},
	{22097, 167128},
	{22112, 167132, 2, 1576},
	{22128, 167136, 1, 1578},
	{22144, 167140, 3, 1579},
	{22159, 167144, 19, 2605},
	{22174, 167148, 8, 1601},
	{22191, 167152, 14, 2624},
	{22213, 167156},
	{22229, 167160, 1, 1621},
	{22251, 167164},
	{22267, 167168, 1, 1578},
	{22289, 167172},
	{22311, 167176},
	{22333, 167180},
	{22352, 167188},
	{22367, 167192, 2, 1576},
	{22383, 167196, 1, 1578},
	{22399, 167200, 3, 1579},
	{22414, 167204, 19, 2605},
	{22429, 167208, 8, 1601},
	{22446, 167212, 14, 2624},
	{22468, 167216},
	{22484, 167220, 1, 1621},
	{22506, 167224},
	{22522, 167228, 1, 1578},
	{22544, 167232},
	{22566, 167236},
	{22588, 167240},
	{22607, 167248},
	{22622, 167252, 2, 1576},
	{22638, 167256, 1, 1578},
	{22654, 167260, 3, 1579},
	{22669, 167264, 19, 2605},
	{22684, 167268, 8, 1601},
	{22701, 167272, 14, 2624},
	{22723, 167276},
	{22739, 167280, 1, 1621},
	{22761, 167284},
	{22777, 167288, 1, 1578},
	{22799, 167292},
	{22821, 167296},
	{22843, 167300},
	{22862, 167308},
	{22877, 167312, 2, 1576},
	{22893, 167316, 1, 1578},
	{22909, 167320, 3, 1579},
	{22924, 167324, 19, 2605},
	{22939, 167328, 8, 1601},
	{22956, 167332, 14, 2624},
	{22978, 167336},
	{22994, 167340, 1, 1621},
	{23016, 167344},
	{23032, 167348, 1, 1578},
	{23054, 167352},
	{23076, 167356},
	{23098, 167360},
	{23117, 167368},
	{23132, 167372, 2, 1576},
	{23148, 167376, 1, 1578},
	{23164, 167380, 3, 1579},
	{23179, 167384, 19, 2605},
	{23194, 167388, 8, 1601},
	{23211, 167392, 14, 2624},
	{23233, 167396},
	{23249, 167400, 1, 1621},
	{23271, 167404},
	{23287, 167408, 1, 1578},
	{23309, 167412},
	{23331, 167416},
	{23353, 167420},
	{23372, 167428},
	{23387, 167432, 2, 1576},
	{23403, 167436, 1, 1578},
	{23419, 167440, 3, 1579},
	{23434, 167444, 19, 2605},
	{23449, 167448, 8, 1601},
	{23466, 167452, 14, 2624},
	{23488, 167456},
	{23504, 167460, 1, 1621},
	{23526, 167464},
	{23542, 167468, 1, 1578},
	{23564, 167472},
	{23586, 167476},
	{23608, 167480},
	{23627, 167488, 1, 1622},
	{23646, 167492, 1, 1622},
	{23665, 167496, 1, 1622},
	{23684, 167500, 1, 1622},
	{23703, 167504, 1, 1622},
	{23722, 167508, 1, 1622},
	{23741, 167512, 1, 1622},
	{23760, 167516, 1, 1622},
	{23779, 167520, 1, 1622},
	{23804, 167524, 1, 1622},
	{23829, 167528, 1, 1622},
	{23854, 167532, 1, 1622},
	{23879, 167536, 1, 1622},
	{23904, 167540, 1, 1622},
	{23929, 167544, 1, 1622},
	{23954, 167548, 1, 1622},
	{23979, 167552, 1, 1622},
	{24004, 167556, 1, 1622},
	{24029, 167560, 1, 1622},
	{24054, 167564, 1, 1622},
	{24079, 167568, 1, 1622},
	{24104, 167572, 1, 1622},
	{24129, 167576, 1, 1622},
	{24154, 167580, 1, 1622},
	{24179, 167584, 1, 1622},
	{24202, 167588, 1, 1622},
	{24225, 167592, 1, 1622},
	{24248, 167596, 1, 1622},
	{24271, 167600, 1, 1622},
	{24294, 167604, 1, 1622},
	{24317, 167608, 1, 1622},
	{24340, 167612, 1, 1622},
	{24363, 167616, 3, 1623},
	{24381, 167620, 3, 1623},
	{24399, 167624, 3, 1623},
	{24417, 167628, 3, 1623},
	{24435, 167632, 3, 1623},
	{24453, 167636, 3, 1623},
	{24471, 167640, 3, 1623},
	{24489, 167644, 3, 1623},
	{24507, 167648, 9, 2638},
	{24525, 167652, 9, 2638},
	{24543, 167656, 9, 2638},
	{24561, 167660, 9, 2638},
	{24579, 167664, 9, 2638},
	{24597, 167668, 9, 2638},
	{24615, 167672, 9, 2638},
	{24633, 167676, 9, 2638},
	{24651, 196608, 1, 1634},
	{24671, 196612, 1, 1635},
	{24691, 196616},
	{24711, 196620},
	{24731, 196624},
	{24752, 196628},
	{24773, 196632, 1, 1636},
	{24795, 196636, 1, 1637},
	{24817, 196640},
	{24847, 196644},
	{24877, 196648},
	{24906, 196652},
	{24935, 196656},
	{24965, 196660},
	{24995, 196664},
	{25024, 196668},
	{25053, 196672},
	{25083, 196676},
	{25113, 196680},
	{25142, 196684},
	{25171, 196688},
	{25201, 196692},
	{25231, 196696},
	{25260, 196700},
	{25289, 196704, 1, 1638},
	{25311, 196708, 1, 1639},
	{25333, 196712},
	{25356, 196716},
	{25379, 196720},
	{25402, 196724},
	{25425, 196728},
	{25448, 196732},
	{25471, 196736},
	{25495, 196740},
	{25519, 196744},
	{25543, 196748},
	{25567, 196752},
	{25591, 196756},
	{25615, 196760},
	{25639, 196764},
	{25663, 196768},
	{25685, 196772},
	{25707, 196776},
	{25728, 196780},
	{25749, 196784},
	{25773, 196788},
	{25797, 196792},
	{25821, 196796},
	{25845, 196800},
	{25869, 196804},
	{25953, 196852, 1, 1641},
	{25975, 196856, 1, 1641},
	{25997, 196860, 1, 1642},
	{26013, 196864},
	{26026, 196868},
	{26039, 196872},
	{26052, 196876},
	{26065, 196880},
	{26078, 196884},
	{26091, 196888},
	{26104, 196892},
	{43586, 196896, 5, 2647},
	{26140, 196908, 1, 670},
	{26159, 196912},
	{26177, 196916},
	{26204, 196920},
	{26231, 196928, 2, 1643},
	{26244, 196932},
	{26257, 196936},
	{26280, 196940},
	{26303, 196944},
	{26331, 196948},
	{26359, 196952},
	{26387, 196956},
	{26415, 196960, 1, 1645},
	{26433, 196964, 4, 1646},
	{26451, 196968},
	{26466, 196972},
	{26490, 196976},
	{26514, 196980},
	{26533, 196984},
	{26552, 196988},
	{26576, 196992},
	{26600, 196996},
	{26624, 197000},
	{26648, 197028, 1, 1650},
	{26666, 197032, 2, 1651},
	{26684, 197036},
	{26702, 197040},
	{26720, 197044, 1, 1653},
	{26738, 197048, 2, 1654},
	{26756, 197052},
	{26774, 197056, 2, 2652},
	{26793, 197060, 5, 1658},
	{26812, 197072},
	{26836, 197076, 2, 2652},
	{26856, 197080, 5, 1658},
	{26876, 197084, 7, 1663},
	{26895, 197088, 7, 1663},
	{26913, 197092, 1, 1670},
	{26930, 197100, 1, 1671},
	{26951, 197104, 13, 1672},
	{26965, 197108},
	{26979, 197112},
	{26993, 197116, 2, 1685},
	{27009, 197120},
	{27028, 197124, 1, 1687},
	{27050, 197128},
	{27069, 197132, 1, 1688},
	{27091, 197136, 7, 1689},
	{27109, 197140},
	{27129, 197144, 1, 1687},
	{27152, 197148},
	{27172, 197152, 1, 1688},
	{27195, 197156, 7, 1689},
	{27214, 197160, 7, 1696},
	{27226, 197164, 2, 1703},
	{27243, 197168, 1, 1705},
	{27260, 197172, 1, 1706},
	{27278, 197176, 5, 2654},
	{27298, 197180, 2, 330},
	{27315, 197184},
	{27331, 197188, 1, 1713},
	{27358, 197196, 1, 1715},
	{27414, 197208, 1, 1718},
	{27436, 197212, 1, 1719},
	{27456, 197216, 1, 1714},
	{27473, 197220, 1, 1715},
	{27490, 197224},
	{27504, 197232, 2, 1720},
	{27526, 197236, 2, 1722},
	{27548, 197240, 2, 1720},
	{27571, 197244, 2, 1722},
	{27594, 197248, 2, 1720},
	{27616, 197252, 2, 1722},
	{43605, 197256},
	{43627, 197260},
	{43649, 197280},
	{43671, 197284},
	{43693, 197288},
	{43720, 197292},
	{43747, 197296},
	{43774, 197300},
	{27638, 197364, 1, 1724},
	{27659, 197368, 1, 1725},
	{27679, 197372, 1, 1726},
	{27716, 197380, 1, 1726},
	{27733, 197384, 1, 1727},
	{27749, 197388, 1, 1728},
	{27768, 197392, 1, 1729},
	{27787, 197396, 1, 1730},
	{27804, 197400, 1, 1731},
	{27822, 197404, 1, 1732},
	{27840, 197408, 1, 1733},
	{27856, 197412, 1, 1734},
	{27874, 197416, 1, 1735},
	{27892, 197420, 1, 1736},
	{27908, 197424, 1, 1731},
	{27923, 197428, 1, 1732},
	{27938, 197432, 1, 1733},
	{27951, 197436, 1, 1734},
	{27966, 197440, 1, 1735},
	{27981, 197444, 1, 1736},
	{27994, 197448, 1, 1737},
	{28008, 197452, 1, 1738},
	{28022, 197456, 1, 1739},
	{28034, 197460, 4, 1740},
	{28057, 197464, 5, 2659},
	{28079, 197468, 1, 1747},
	{28099, 197472, 1, 1748},
	{28113, 197476, 1, 1749},
	{28127, 197480, 1, 1750},
	{28139, 197484, 1, 1751},
	{28155, 197488, 1, 1748},
	{28172, 197492, 1, 1749},
	{28189, 197496, 1, 1750},
	{28204, 197500, 1, 1751},
	{28223, 197552, 1, 1752},
	{28248, 197556, 1, 1752},
	{28272, 197560, 1, 1753},
	{28292, 197568},
	{28318, 197572, 1, 1635},
	{28347, 197576},
	{28372, 197580, 1, 1635},
	{28400, 197584},
	{28423, 197588, 1, 1635},
	{28449, 197592},
	{28471, 197596, 1, 1635},
	{28496, 197600},
	{28515, 197604, 1, 1635},
	{28537, 197608, 1, 1350},
	{28551, 197612},
	{28568, 197616, 1, 1635},
	{28588, 197620, 8, 1754},
	{28605, 197624, 13, 1762},
	{28622, 197628},
	{28639, 197632, 1, 1705},
	{28659, 197636},
	{28676, 197640, 1, 1670},
	{28696, 197644, 2, 1775},
	{28715, 197888, 8, 1777},
	{28736, 197892, 8, 1777},
	{28757, 198656, 6, 1785},
	{28772, 198912},
	{28791, 198916},
	{28810, 198920, 1, 1791},
	{28829, 198924, 2, 2664},
	{28844, 198928},
	{28877, 198932},
	{28910, 198936},
	{28943, 198940},
	{28976, 198948},
	{28992, 198952},
	{29007, 198956, 2, 1364},
	{29033, 198960},
	{29049, 198964},
	{29067, 198968, 1, 1792},
	{29084, 198972, 2, 2666},
	{29105, 198976},
	{29124, 198980},
	{29143, 198984},
	{29159, 198988, 1, 837},
	{29178, 198992},
	{29198, 198996, 1, 837},
	{29221, 199000},
	{29239, 199004, 1, 837},
	{29260, 199008, 9, 1795},
	{29285, 199012},
	{29301, 199016},
	{29322, 199020, 4, 1804},
	{29330, 199024},
	{29344, 199028},
	{29358, 199032},
	{29372, 199036, 3, 1808},
	{29387, 199040, 2, 1811},
	{29399, 199044, 1, 837},
	{29421, 199048, 3, 1813},
	{43801, 199052, 2, 2668},
	{29437, 199168, 1, 1816},
	{29462, 199172, 2, 1817},
	{29487, 199184, 2, 1819},
	{29513, 199188, 2, 1819},
	{29539, 199192, 2, 1819},
	{29565, 199212, 2, 1819},
	{29591, 199296, 2, 1821},
	{29619, 199300, 1, 1823},
	{29643, 199304, 1, 1824},
	{29667, 199308, 1, 1825},
	{29700, 199312, 1, 1825},
	{29728, 199328, 2, 1821},
	{29757, 199332, 1, 1823},
	{29782, 199336, 1, 1824},
	{29807, 199340, 1, 1825},
	{29841, 199344, 1, 1825},
	{29870, 199360, 2, 1821},
	{29894, 199364, 1, 1823},
	{29914, 199368, 1, 1824},
	{29934, 199372, 1, 1825},
	{29963, 199376, 1, 1825},
	{29987, 199936},
	{30014, 199940},
	{30041, 199944},
	{30068, 199948},
	{30095, 199952},
	{30122, 199956},
	{30149, 199960},
	{30176, 199964},
	{30203, 199968, 5, 2670},
	{30228, 200192},
	{30247, 200196, 1, 847},
	{30269, 200448},
	{30293, 200452, 1, 1835},
	{30316, 200456},
	{30340, 200460, 1, 1835},
	{30363, 200464},
	{30387, 200468, 1, 1835},
	{30410, 200472},
	{30434, 200476, 1, 1835},
	{30457, 200696},
	{30476, 200700, 1, 1835},
	{30494, 200704},
	{30506, 200708},
	{30518, 200712},
	{30536, 200716},
	{30555, 200720},
	{30573, 200724},
	{30585, 200728},
	{30597, 200732},
	{30615, 200736},
	{30633, 200740},
	{30652, 200744, 4, 1836},
	{30666, 200748, 2, 1840},
	{30684, 200752, 2, 1842},
	{30698, 200756, 2, 1844},
	{30712, 200760, 2, 1846},
	{30729, 200764, 2, 1848},
	{30746, 200768},
	{30759, 200772, 2, 1850},
	{30771, 200776},
	{30785, 200780},
	{30801, 200784},
	{30815, 200788},
	{30831, 200792},
	{30846, 200796},
	{30863, 200800},
	{30878, 200804},
	{30895, 200808, 2, 1852},
	{30917, 200812, 11, 2675},
	{30934, 200816, 2, 1864},
	{30955, 200820, 2, 1866},
	{30967, 200824},
	{30982, 200828, 6, 1868},
	{30997, 200832, 2, 1874},
	{31011, 200836},
	{31028, 200960},
	{31050, 200964},
	{31074, 200968},
	{31098, 200972},
	{31124, 212992},
	{31144, 212996},
	{31164, 213000},
	{31184, 213004},
	{31204, 213008},
	{31224, 213012},
	{31244, 213016},
	{31264, 213020},
	{31284, 213024},
	{31304, 213028},
	{31324, 213032},
	{31344, 213036},
	{31364, 213040},
	{31387, 213044},
	{31410, 213048},
	{31433, 213248},
	{31454, 213252},
	{31475, 213260},
	{31496, 213264},
	{31517, 213268},
	{31541, 213272},
	{31565, 213276},
	{31589, 213280},
	{31613, 213284},
	{31637, 213288},
	{31661, 213292},
	{31685, 213296},
	{43813, 213648},
	{43833, 213652},
	{43853, 213656},
	{43873, 213660},
	{43893, 213664},
	{43913, 213668},
	{43933, 213672},
	{43953, 213676},
	{43973, 213680},
	{43998, 213684},
	{44023, 213688},
	{44048, 213692},
	{44073, 213696},
	{44098, 213700},
	{44123, 213704},
	{44148, 213708},
	{44173, 213712},
	{44196, 213716},
	{44219, 213720},
	{44242, 213724},
	{44265, 213728},
	{44288, 213732},
	{44311, 213736},
	{44334, 213740},
	{32169, 214016},
	{32191, 214020, 1, 1876},
	{32213, 214024},
	{32235, 214028, 1, 1876},
	{32257, 214032},
	{32279, 214036, 1, 1876},
	{32301, 214040},
	{32323, 214044, 1, 1876},
	{32345, 214272},
	{32367, 214276},
	{32389, 214280},
	{32411, 214284},
	{32433, 214288},
	{32455, 214292},
	{32477, 214296},
	{32499, 214300},
	{32521, 214304},
	{32543, 214308},
	{32565, 214312},
	{32587, 214316},
	{32609, 214320},
	{32631, 214324},
	{32653, 214328},
	{32675, 214332},
	{32697, 214528},
	{32717, 214532},
	{32737, 214536},
	{32757, 214540},
	{32777, 214544},
	{32797, 214548},
	{32817, 214552},
	{32837, 214556},
	{32857, 214560},
	{32877, 214564},
	{32897, 214568},
	{32917, 214572},
	{32937, 214784},
	{32956, 214788},
	{32975, 214792},
	{32994, 214796},
	{33013, 214800},
	{33032, 214804},
	{33051, 214808},
	{33070, 214812},
	{33089, 214816},
	{33108, 214820},
	{33127, 214824},
	{33146, 214828},
	{33165, 214832},
	{33184, 214836},
	{33203, 214840},
	{33222, 214844},
	{33241, 214848},
	{33260, 214852},
	{33279, 214856},
	{33298, 214860},
	{33317, 214864},
	{33337, 214868},
	{33357, 214872},
	{33377, 214876},
	{33397, 214880},
	{33417, 214884},
	{33437, 214888},
	{33457, 214892},
	{33477, 214896},
	{33497, 214900},
	{33517, 214904},
	{33537, 214908},
	{33557, 215296},
	{33576, 215300},
	{33595, 215304},
	{33614, 215308},
	{33633, 215312},
	{33652, 215316},
	{33671, 215320},
	{33690, 215324},
	{33709, 215424},
	{33730, 215428},
	{44357, 215432},
	{44377, 215436, 2, 1877},
	{33751, 215552},
	{33771, 215556},
	{33791, 215560},
	{33811, 215564},
	{33831, 215568},
	{33851, 215572},
	{33871, 215576},
	{33891, 215580},
	{33911, 215808},
	{33930, 215812},
	{33949, 215816},
	{33968, 215820},
	{33987, 216064},
	{34006, 216068},
	{34025, 216072},
	{34044, 216076},
	{34063, 216320},
	{34083, 216324},
	{34103, 216328},
	{34123, 216332},
	{34143, 216336},
	{34163, 216340},
	{34183, 216344},
	{34203, 216348},
	{34223, 216576},
	{34244, 216580},
	{34265, 216584},
	{34286, 216588},
	{34307, 216592},
	{34328, 216596},
	{34349, 216600},
	{34370, 216604},
	{34391, 216640},
	{34412, 216644},
	{34433, 216648},
	{34454, 216652},
	{34475, 216656},
	{34496, 216660},
	{34517, 216664},
	{34538, 216668},
	{34559, 216704},
	{34580, 216708},
	{34601, 216712},
	{34622, 216716},
	{34643, 216720},
	{34664, 216724},
	{34685, 216728},
	{34706, 216732},
	{34727, 216832},
	{34747, 216836},
	{34767, 216840},
	{34787, 216844},
	{34807, 216848},
	{34827, 216852},
	{34847, 216856},
	{34867, 216860},
	{34887, 216864},
	{34908, 216868},
	{34929, 216872},
	{34950, 216876},
	{34971, 216880},
	{34992, 216884},
	{35013, 216888},
	{35034, 216892},
	{35055, 217112},
	{35074, 217116},
	{35093, 217120},
	{35112, 217124},
	{35131, 217128},
	{35150, 217132},
	{35169, 217136},
	{35188, 217140},
	{35207, 217344},
	{35226, 217348},
	{35245, 217352},
	{35264, 217356},
	{35283, 217360},
	{35302, 217364},
	{35321, 217368},
	{35340, 217372},
	{35359, 217600},
	{35379, 217604},
	{35399, 217608},
	{35419, 217612},
	{35439, 217856},
	{35459, 217860},
	{35479, 217864},
	{35499, 217868},
	{35519, 217872},
	{35539, 217876},
	{35559, 217880},
	{35579, 217884},
	{35649, 218016},
	{35675, 218020, 2, 1877},
	{44397, 218024},
	{44420, 218028, 2, 1877},
	{35701, 218080},
	{35726, 218084},
	{35751, 218088},
	{35776, 218092},
	{35853, 218224},
	{35875, 218228},
	{35897, 218232},
	{35919, 218236},
	{35941, 218240},
	{35961, 218244},
	{35981, 218248},
	{36001, 218252},
	{36021, 218624},
	{36043, 218628},
	{36065, 218632},
	{36087, 218636},
	{36109, 218640},
	{36131, 218644},
	{36153, 218648},
	{36175, 218652},
	{36197, 218656},
	{36219, 218660},
	{36241, 218664},
	{36263, 218668},
	{36285, 218672},
	{36307, 218676},
	{36329, 218680},
	{36351, 218684},
	{36373, 218880},
	{36394, 218884},
	{36415, 218888},
	{36436, 218892},
	{36457, 218896},
	{36478, 218900},
	{36499, 218904},
	{36520, 218908},
	{36541, 219136},
	{36561, 219140},
	{36581, 219144},
	{36601, 219148},
	{36621, 219152},
	{36641, 219156},
	{36661, 219160},
	{36681, 219164},
	{36701, 219392},
	{36721, 219396},
	{44443, 219400},
	{44462, 219404, 2, 1877},
	{44481, 219520},
	{44510, 219524, 2, 1877},
	{44539, 219528},
	{44561, 219532},
	{44583, 219536},
	{44605, 219540},
	{44627, 219568},
	{44656, 219572, 2, 1877},
	{44685, 219576},
	{44707, 219580},
	{44729, 219584},
	{44751, 219588},
	{44773, 219616},
	{44802, 219620, 2, 1877},
	{44831, 219624},
	{44853, 219628},
	{44875, 219632},
	{44897, 219636},
	{44919, 219664},
	{44948, 219668, 2, 1877},
	{44977, 219672},
	{44999, 219676},
	{45021, 219680},
	{45043, 219684},
	{36741, 221184, 5, 1879},
	{36765, 221188, 4, 1884},
	{36790, 221192, 5, 1879},
	{36814, 221196, 5, 1879},
	{36838, 221200, 4, 1884},
	{36863, 221204, 5, 1879},
	{36887, 221208, 4, 1884},
	{36912, 221212, 5, 1879},
	{36936, 221216, 4, 1888},
	{36952, 221220, 5, 1879},
	{36976, 221224, 3, 1892},
	{37010, 221228, 3, 1895},
	{37044, 221232, 3, 1898},
	{37069, 221236, 3, 1901},
	{37094, 221240, 3, 1898},
	{37119, 221248},
	{37134, 221252, 1, 1825},
	{37157, 221256},
	{37180, 221260},
	{37198, 221264, 2, 1904},
	{37216, 221268, 4, 1906},
	{37236, 221440, 20, 1910},
	{37261, 221444, 20, 1910},
	{37286, 221448, 15, 1930},
	{37314, 221452, 15, 1930},
	{37342, 221456, 15, 1930},
	{37370, 221460, 15, 1930},
	{37398, 221492, 8, 1945},
	{37426, 221496, 8, 1945},
	{45065, 221840, 5, 1953},
	{45089, 221844, 4, 1958},
	{45114, 221848, 5, 1953},
	{45138, 221852, 4, 1958},
	{45163, 221856, 5, 1953},
	{45187, 221860, 4, 1958},
	{45212, 221864, 5, 1953},
	{45236, 221868, 4, 1958},
	{45261, 221872, 5, 1953},
	{45290, 221876, 4, 1958},
	{45320, 221880, 5, 1953},
	{45349, 221884, 4, 1958},
	{45379, 221888, 5, 1953},
	{45408, 221892, 4, 1958},
	{45438, 221896, 5, 1953},
	{45467, 221900, 4, 1958},
	{45497, 221904, 5, 1953},
	{45524, 221908, 4, 1958},
	{45552, 221912, 5, 1953},
	{45579, 221916, 4, 1958},
	{45607, 221920, 5, 1953},
	{45634, 221924, 4, 1958},
	{45662, 221928, 5, 1953},
	{45689, 221932, 4, 1958},
	{37828, 222208, 5, 1964},
	{37854, 222212, 4, 1969},
	{37881, 222216, 5, 1964},
	{37907, 222220, 4, 1969},
	{37934, 222224, 5, 1964},
	{37960, 222228, 4, 1969},
	{37987, 222232, 5, 1964},
	{38013, 222236, 4, 1969},
	{38040, 222464, 5, 1964},
	{38066, 222468, 4, 1969},
	{38093, 222472, 1, 1879},
	{38119, 222476, 1, 1879},
	{38145, 222480, 1, 1879},
	{38171, 222484, 1, 1879},
	{38197, 222488, 1, 1879},
	{38223, 222492, 1, 1879},
	{38249, 222496, 1, 1879},
	{38275, 222720, 5, 1964},
	{38299, 222724, 5, 1964},
	{38323, 222728, 5, 1964},
	{38347, 222732, 5, 1964},
	{38371, 222736, 4, 1969},
	{38396, 222740, 4, 1969},
	{38421, 222744, 4, 1969},
	{38446, 222748, 4, 1969},
	{38471, 222752, 1, 1879},
	{38495, 222756, 1, 1879},
	{38519, 222760, 8, 1973},
	{38540, 222976, 3, 2686},
	{38563, 222980, 3, 2686},
	{38586, 222984, 3, 2686},
	{38609, 222988, 3, 2686},
	{38632, 222992, 3, 2686},
	{38655, 222996, 3, 2686},
	{38678, 223000, 3, 2686},
	{38701, 223004, 3, 2686},
	{38724, 223008, 3, 2686},
	{38747, 223012, 3, 2686},
	{38770, 223016, 3, 2686},
	{38794, 223020, 3, 2686},
	{38818, 223024, 3, 2686},
	{38842, 223028, 3, 2686},
	{38866, 223032, 3, 2686},
	{38890, 223036, 3, 2686},
	{38914, 223104, 15, 2689},
	{38934, 223112, 1, 1994},
	{38955, 223232, 5, 1964},
	{38980, 223236, 4, 1969},
	{39006, 223240, 8, 1995},
	{45717, 223244, 5, 2147},
	{45739, 223248, 5, 2147},
	{45761, 223252, 6, 2152},
	{39029, 223488, 5, 1964},
	{39052, 223492, 5, 1964},
	{39075, 223496, 3, 2020},
	{39098, 223500, 3, 2020},
	{39121, 223504, 4, 1969},
	{39145, 223508, 4, 1969},
	{39169, 223744, 5, 1964},
	{39193, 223748, 5, 1964},
	{39217, 223752, 5, 1964},
	{39241, 223756, 5, 1964},
	{39265, 223760, 4, 1969},
	{45788, 223764, 4, 1969},
	{45813, 223768, 4, 1969},
	{45838, 223772, 4, 1969},
	{39290, 224000, 5, 1964},
	{39313, 224004, 4, 1969},
	{39337, 224008, 3, 2020},
	{39360, 224256, 5, 1964},
	{39383, 224260, 4, 1969},
	{39407, 224264, 3, 2020},
	{39430, 224512, 5, 1964},
	{39454, 224516, 4, 1969},
	{39479, 224520, 5, 1964},
	{39503, 224524, 4, 1969},
	{39528, 224528, 3, 2020},
	{39552, 224532, 3, 2020},
	{39576, 224768, 5, 1964},
	{39601, 224772, 4, 1958},
	{39627, 224776, 5, 1964},
	{39652, 224780, 4, 1958},
	{39678, 224784, 3, 2020},
	{39703, 224788, 3, 2020},
	{39728, 224832, 5, 1964},
	{39753, 224836, 4, 1958},
	{39779, 224840, 5, 1964},
	{39804, 224844, 4, 1958},
	{39830, 224848, 3, 2020},
	{39855, 224852, 3, 2020},
	{39880, 224896, 5, 1964},
	{39905, 224900, 4, 1958},
	{39931, 224904, 3, 2020},
	{39956, 224908, 3, 2020},
	{39981, 224912, 3, 2020},
	{40006, 225024, 5, 1964},
	{40030, 225028, 4, 1958},
	{40055, 225032, 3, 2020},
	{40079, 225036, 3, 2020},
	{40103, 225040, 3, 2020},
	{40127, 225048, 5, 1964},
	{40152, 225052, 4, 1958},
	{40178, 225056, 3, 2020},
	{40203, 225060, 3, 2020},
	{40228, 225064, 3, 2020},
	{40253, 225280, 12, 2023},
	{40275, 225284, 5, 2035},
	{40298, 225288, 4, 2040},
	{40322, 225292, 2, 2044},
	{40345, 225296, 2, 2044},
	{40368, 225300, 2, 2044},
	{40391, 225536, 5, 1964},
	{40414, 225540, 4, 1969},
	{40438, 225544, 5, 1964},
	{40461, 225548, 4, 1969},
	{40485, 225552, 5, 1964},
	{40508, 225560, 5, 1964},
	{40531, 225792, 4, 2046},
	{40552, 225796},
	{40581, 225800, 2, 2050},
	{40610, 225804},
	{40636, 225808, 7, 2052},
	{40665, 225812},
	{40684, 225816, 2, 2059},
	{40710, 225820, 2, 2061},
	{40733, 225824},
	{40756, 225828, 2, 2063},
	{40783, 225832},
	{40810, 225836, 2, 2065},
	{40835, 225840, 2, 2067},
	{40863, 225844, 2, 2069},
	{40891, 225848, 2, 2071},
	{40914, 225852, 2, 2073},
	{40937, 225856},
	{40970, 225860, 2, 2075},
	{41003, 225864},
	{41035, 225868, 2, 2075},
	{41067, 225872, 2, 2077},
	{41086, 225876, 2, 2079},
	{41113, 225880},
	{41140, 225884, 2, 2704},
	{41167, 225888, 2, 2083},
	{41194, 225892, 17, 2706},
	{41215, 225896, 9, 2723},
	{41234, 225900, 19, 2732},
	{41253, 225904, 1, 2111},
	{41277, 225908, 1, 2113},
	{41309, 225912, 2, 2115},
	{41339, 225916, 4, 2117},
	{41375, 225920, 3, 2121},
	{41408, 225924, 1, 2124},
	{45863, 225928, 7, 2052},
	{41426, 225932, 1, 2125},
	{45896, 225936},
	{45923, 225940},
	{45949, 225944, 4, 2117},
	{45989, 225948, 2, 2751},
	{46023, 225952, 2, 2751},
	{46053, 225956, 2, 2079},
	{46084, 225960},
	{46115, 225964, 4, 2753},
	{46149, 225968, 3, 2121},
	{46186, 225972, 3, 2757},
	{41446, 226048, 2, 2126},
	{41463, 226052, 1, 2128},
	{41487, 226056, 1, 2128},
	{41511, 226060, 4, 2129},
	{41537, 226064, 3, 2133},
	{41566, 226068, 1, 694},
	{41595, 226072, 3, 2133},
	{41624, 226076, 1, 694},
	{41653, 226192, 1, 2136},
	{41701, 226304, 5, 2035},
	{41725, 226308, 4, 2040},
	{41750, 226312, 2, 2044},
	{41774, 226316, 5, 2035},
	{41798, 226320, 4, 2040},
	{41823, 226324, 2, 2044},
	{41847, 226328, 10, 2137},
	{41955, 226480, 5, 2147},
	{41983, 226484, 5, 2147},
	{42011, 226488, 5, 2147},
	{42039, 226492, 5, 2147},
	{42067, 226496, 5, 2147},
	{42095, 226500, 5, 2147},
	{42123, 226504, 5, 2147},
	{42151, 226508, 5, 2147},
	{42179, 226512, 6, 2152},
	{46227, 226516, 5, 2147},
	{46252, 226520, 5, 2147},
	{46277, 226524, 5, 2147},
	{46302, 226528, 5, 2147},
	{46327, 226532, 6, 2152},
	{42212, 226544, 5, 1964},
	{42241, 226548, 5, 1964},
	{42270, 226552, 4, 1969},
	{42300, 226556, 4, 1969},
	{42330, 226560, 8, 1995},
	{42357, 226564, 8, 1995},
	{42473, 226688, 5, 2035},
	{42497, 226692, 4, 2040},
	{42522, 226696, 3, 2158},
	{42546, 226700, 2, 2161},
	{42572, 226704, 2, 2161},
	{42598, 226816, 5, 1964},
	{42624, 226820, 4, 1969},
	{42651, 226824, 5, 1964},
	{42677, 226828, 5, 1964},
	{42703, 226832, 5, 1964},
	{42729, 226836, 1, 1879},
	{42755, 226840, 1, 1879},
	{42781, 226844, 1, 1879},
	{42807, 226848, 1, 1879},
	{42833, 226880, 4, 1969},
	{42860, 226884, 4, 1969},
	{42887, 226888, 4, 1969},
	{42914, 227072, 5, 1964},
	{42939, 227076, 4, 1958},
	{42965, 227080, 3, 2020},
	{42990, 227084, 3, 2020},
	{43015, 227088, 3, 2020},
	{43040, 227200, 5, 1964},
	{43064, 227204, 4, 1958},
	{43089, 227208, 3, 2020},
	{43113, 227212, 3, 2020},
	{43137, 227216, 3, 2020},
	{43161, 227328, 5, 1964},
	{43185, 227332, 4, 1969},
	{43210, 227336, 8, 1995},
	{46357, 227340, 5, 2147},
	{46378, 227344, 5, 2147},
	{46399, 227348, 6, 2152},
	{46425, 227456, 5, 2147},
	{46456, 227460, 5, 2147},
	{46487, 227464, 6, 2152},
	{46523, 227468, 1, 2760},
	{46547, 227472, 5, 1964},
	{46573, 227476, 4, 1969},
	{46600, 227480, 5, 1964},
	{46626, 227484, 4, 1969},
	{46653, 227504, 5, 2147},
	{46684, 227508, 5, 2147},
	{46715, 227512, 6, 2152},
	{46751, 227516, 1, 2760},
	{46775, 227520, 5, 1964},
	{46801, 227524, 4, 1969},
	{46828, 227528, 5, 1964},
	{46854, 227532, 4, 1969},
	{46881, 227552, 5, 2147},
	{46912, 227556, 5, 2147},
	{46943, 227560, 6, 2152},
	{46979, 227564, 1, 2760},
	{47003, 227568, 5, 1964},
	{47029, 227572, 4, 1969},
	{47056, 227576, 5, 1964},
	{47082, 227580, 4, 1969},
	{47109, 227600, 5, 2147},
	{47140, 227604, 5, 2147},
	{47171, 227608, 6, 2152},
	{47207, 227612, 1, 2760},
	{47231, 227616, 5, 1964},
	{47257, 227620, 4, 1969},
	{47284, 227624, 5, 1964},
	{47310, 227628, 4, 1969},
	{206, 880, 4, 2163},
	{43232, 881},
	{27079, 882},
	{43244, 1008},
	{43255, 1009},
	{27267, 1010, 4, 2167},
	{43266, 1040, 1, 2171},
	{43279, 1041, 5, 2172},
	{43292, 1042, 1, 2177},
	{43305, 1043, 1, 1688},
	{27101, 1045, 7, 2178},
	{43318, 1168, 12, 2185},
	{43333, 1281, 6, 2197},
	{43348, 1282},
	{27038, 1283},
	{43232, 1285},
	{27079, 1286},
	{43360, 1414, 15, 2203},
};

static const struct si_reg gfx11_reg_table[] = {
	{43369, 40, 1, 2218},
	{43384, 44, 1, 2218},
	{1390, 1028, 10, 2761},
	{1403, 1032, 26, 2771},
	{1418, 1036, 11, 2797},
	{1455, 1044, 2, 2808},
	{1473, 1048, 3, 56},
	{1491, 1052, 4, 2810},
	{1506, 1056},
	{1520, 1060, 1, 70},
	{1551, 1076, 2, 78},
	{1567, 1080},
	{1962, 1104},
	{1986, 1108},
	{1584, 1116, 6, 2814},
	{1599, 1120, 6, 85},
	{1614, 1124, 2, 92},
	{1634, 1128, 1, 94},
	{1673, 1136, 4, 2820},
	{43407, 1140, 1, 2237},
	{1689, 2480},
	{1703, 2484},
	{1731, 2492},
	{1745, 2496},
	{1759, 2500},
	{1773, 2504},
	{1787, 2508},
	{1801, 2512},
	{1815, 2516},
	{1829, 2520},
	{1844, 2524},
	{1859, 2528},
	{1874, 2532},
	{1889, 2536},
	{1904, 2540},
	{1919, 2548},
	{1930, 2552},
	{1946, 2556},
	{2034, 32776, 22, 2824},
	{2047, 32784, 22, 2846},
	{2059, 32788, 17, 2868},
	{2075, 32792, 17, 2868},
	{2091, 32796, 15, 2885},
	{2104, 32824, 17, 2868},
	{2120, 32828, 17, 2868},
	{47337, 32832, 17, 2868},
	{47353, 32836, 17, 2868},
	{47369, 33280, 1, 2900},
	{47387, 33284},
	{2136, 33296, 23, 2901},
	{2150, 33300, 28, 2924},
	{2167, 33304, 16, 2952},
	{2188, 33308, 28, 247},
	{2202, 33312, 32, 275},
	{2219, 33316, 13, 307},
	{2240, 33320, 9, 320},
	{2258, 33324, 1, 329},
	{43429, 33328, 1, 2968},
	{2281, 33344, 2, 330},
	{2302, 33348},
	{2322, 33352, 1, 332},
	{2345, 33356, 11, 2969},
	{2363, 33436, 1, 342},
	{2767, 36608},
	{2785, 36612, 3, 2980},
	{2803, 36616},
	{2821, 36620, 10, 2983},
	{2839, 36656, 14, 397},
	{2857, 36660, 4, 411},
	{2875, 36664, 8, 2993},
	{2893, 36668, 2, 3001},
	{2927, 39160, 6, 2344},
	{3722, 40960},
	{3740, 40964, 6, 3003},
	{3758, 40968, 2, 453},
	{3776, 40972, 9, 456},
	{3794, 40976, 3, 2350},
	{3812, 40980, 6, 3009},
	{3830, 40984, 11, 3015},
	{3848, 40988},
	{3866, 41120, 11, 3026},
	{3898, 45060, 5, 3037},
	{3922, 45080},
	{3947, 45084, 3, 3042},
	{3971, 45088},
	{3992, 45092, 1, 498},
	{4013, 45096, 12, 2372},
	{4037, 45100, 10, 510},
	{4061, 45104},
	{4087, 45108},
	{4113, 45112},
	{4139, 45116},
	{4165, 45120},
	{4191, 45124},
	{4217, 45128},
	{4243, 45132},
	{4269, 45136},
	{4295, 45140},
	{4321, 45144},
	{4348, 45148},
	{4375, 45152},
	{4402, 45156},
	{4429, 45160},
	{4456, 45164},
	{4483, 45168},
	{4510, 45172},
	{4537, 45176},
	{4564, 45180},
	{4591, 45184},
	{4618, 45188},
	{4645, 45192},
	{4672, 45196},
	{4699, 45200},
	{4726, 45204},
	{4753, 45208},
	{4780, 45212},
	{4807, 45216},
	{4834, 45220},
	{4861, 45224},
	{4888, 45228},
	{4915, 45248, 8, 520},
	{4971, 45256, 1, 533},
	{4998, 45260, 1, 533},
	{5025, 45264, 1, 533},
	{5052, 45268, 1, 533},
	{6366, 45568},
	{6391, 45572, 9, 3045},
	{6415, 45576},
	{6447, 45580},
	{6479, 45584},
	{6503, 45588, 1, 498},
	{6527, 45596, 4, 583},
	{6551, 45600},
	{6572, 45604, 1, 498},
	{6593, 45608, 13, 587},
	{6617, 45612, 9, 600},
	{6641, 45616},
	{6667, 45620},
	{6693, 45624},
	{6719, 45628},
	{6745, 45632},
	{6771, 45636},
	{6797, 45640},
	{6823, 45644},
	{6849, 45648},
	{6875, 45652},
	{6901, 45656},
	{6928, 45660},
	{6955, 45664},
	{6982, 45668},
	{7009, 45672},
	{7036, 45676},
	{7063, 45680},
	{7090, 45684},
	{7117, 45688},
	{7144, 45692},
	{7171, 45696},
	{7198, 45700},
	{7225, 45704},
	{7252, 45708},
	{7279, 45712},
	{7306, 45716},
	{7333, 45720},
	{7360, 45724},
	{7387, 45728},
	{7414, 45732},
	{7441, 45736},
	{7468, 45740},
	{47405, 45744, 4, 3054},
	{47431, 45748, 2, 3058},
	{7495, 45760, 8, 520},
	{7555, 45768, 1, 533},
	{7584, 45772, 1, 533},
	{7613, 45776, 1, 533},
	{7642, 45780, 1, 533},
	{7722, 45856},
	{7743, 45860, 1, 498},
	{8261, 46080},
	{8286, 46084, 5, 3037},
	{8310, 46088},
	{8342, 46092},
	{8374, 46096},
	{8398, 46100, 1, 498},
	{8422, 46108, 4, 619},
	{8446, 46112},
	{8467, 46116, 1, 498},
	{8488, 46120, 12, 623},
	{8512, 46124, 9, 635},
	{8536, 46128},
	{8562, 46132},
	{8588, 46136},
	{8614, 46140},
	{8640, 46144},
	{8666, 46148},
	{8692, 46152},
	{8718, 46156},
	{8744, 46160},
	{8770, 46164},
	{8796, 46168},
	{8823, 46172},
	{8850, 46176},
	{8877, 46180},
	{8904, 46184},
	{8931, 46188},
	{8958, 46192},
	{8985, 46196},
	{9012, 46200},
	{9039, 46204},
	{9066, 46208},
	{9093, 46212},
	{9120, 46216},
	{9147, 46220},
	{9174, 46224},
	{9201, 46228},
	{9228, 46232},
	{9255, 46236},
	{9282, 46240},
	{9309, 46244},
	{9336, 46248},
	{9363, 46252},
	{9390, 46272, 8, 520},
	{9450, 46280, 1, 533},
	{9479, 46284, 1, 533},
	{9508, 46288, 1, 533},
	{9537, 46292, 1, 533},
	{9617, 46368},
	{9638, 46372, 1, 498},
	{10129, 47104, 15, 3060},
	{10156, 47108},
	{10170, 47112},
	{10184, 47116},
	{10198, 47120},
	{10214, 47124},
	{10230, 47128},
	{10246, 47132, 2, 666},
	{10267, 47136, 2, 666},
	{10288, 47140, 2, 666},
	{10309, 47144, 1, 668},
	{10337, 47148, 1, 669},
	{10362, 47152},
	{10377, 47156, 1, 670},
	{10392, 47160},
	{10421, 47164, 1, 670},
	{10450, 47168},
	{10483, 47172, 1, 670},
	{10516, 47176, 12, 671},
	{10534, 47180, 11, 683},
	{10552, 47184, 1, 694},
	{10565, 47188, 6, 695},
	{10589, 47192},
	{10616, 47196},
	{10643, 47200, 2, 3075},
	{10664, 47204},
	{10691, 47208},
	{10718, 47212},
	{10736, 47216},
	{10754, 47220},
	{10772, 47224, 1, 703},
	{10800, 47228, 4, 3077},
	{10822, 47232},
	{10842, 47236},
	{10865, 47240, 9, 709},
	{10882, 47248, 1, 533},
	{10903, 47252, 1, 533},
	{10924, 47256, 1, 533},
	{10945, 47260, 1, 533},
	{10966, 47264, 5, 3081},
	{10984, 47268, 1, 719},
	{11003, 47272},
	{47463, 47276, 2, 3086},
	{47494, 47280, 2, 3086},
	{47525, 47284, 2, 3086},
	{47556, 47288, 2, 3086},
	{47587, 47292, 1, 3088},
	{11025, 47296, 3, 720},
	{11042, 47300},
	{11071, 47304, 1, 723},
	{11100, 47308, 3, 720},
	{11118, 47360},
	{11138, 47364},
	{11158, 47368},
	{11178, 47372},
	{11198, 47376},
	{11218, 47380},
	{11238, 47384},
	{11258, 47388},
	{11278, 47392},
	{11298, 47396},
	{11318, 47400},
	{11339, 47404},
	{11360, 47408},
	{11381, 47412},
	{11402, 47416},
	{11423, 47420},
	{11444, 47604, 2, 724},
	{11468, 47608},
	{11489, 47612},
	{11505, 163840, 15, 3089},
	{11523, 163844, 10, 737},
	{11540, 163848, 7, 747},
	{11554, 163852, 22, 3104},
	{11573, 163856, 18, 3126},
	{11593, 163860},
	{11612, 163868, 2, 793},
	{11629, 163872},
	{11649, 163876},
	{11669, 163880, 1, 795},
	{11686, 163884},
	{11701, 163888, 2, 796},
	{11725, 163892, 2, 798},
	{11765, 163900, 8, 3144},
	{11783, 163904, 14, 811},
	{11793, 163908, 9, 825},
	{11809, 163912},
	{11824, 163916},
	{11845, 163920},
	{11861, 163924},
	{11883, 163928, 2, 834},
	{11901, 163932, 1, 836},
	{11919, 163944, 1, 837},
	{11937, 163948, 1, 837},
	{11961, 163952, 1, 837},
	{11980, 163956, 1, 837},
	{12005, 163960, 1, 837},
	{12027, 163964, 13, 3152},
	{12051, 163968},
	{12067, 163972, 1, 847},
	{12086, 164328, 1, 848},
	{12107, 164332, 1, 848},
	{12128, 164336, 1, 848},
	{12149, 164340, 1, 848},
	{12170, 164344},
	{12188, 164348},
	{12206, 164352, 2, 849},
	{12226, 164356, 3, 851},
	{12250, 164360, 2, 854},
	{12274, 164364, 1, 856},
	{12294, 164368, 2, 851},
	{12314, 164372, 2, 854},
	{12334, 164376, 2, 851},
	{12354, 164380, 2, 854},
	{12374, 164384, 2, 851},
	{12394, 164388, 2, 854},
	{12414, 164392, 2, 851},
	{12434, 164396, 2, 854},
	{12454, 164400, 7, 857},
	{12469, 164404, 2, 864},
	{12498, 164408, 8, 866},
	{12513, 164412, 8, 874},
	{12528, 164416, 3, 851},
	{12553, 164420, 2, 854},
	{12578, 164424},
	{12596, 164428},
	{12614, 164432, 3, 851},
	{12639, 164436, 2, 854},
	{12664, 164440, 3, 851},
	{12689, 164444, 2, 854},
	{12714, 164448, 3, 851},
	{12739, 164452, 2, 854},
	{12764, 164456, 3, 851},
	{12789, 164460, 2, 854},
	{12814, 164464, 3, 851},
	{12839, 164468, 2, 854},
	{12864, 164472, 3, 851},
	{12889, 164476, 2, 854},
	{12914, 164480, 3, 851},
	{12939, 164484, 2, 854},
	{12964, 164488, 3, 851},
	{12989, 164492, 2, 854},
	{13014, 164496, 3, 851},
	{13039, 164500, 2, 854},
	{13064, 164504, 3, 851},
	{13089, 164508, 2, 854},
	{13114, 164512, 3, 851},
	{13140, 164516, 2, 854},
	{13166, 164520, 3, 851},
	{13192, 164524, 2, 854},
	{13218, 164528, 3, 851},
	{13244, 164532, 2, 854},
	{13270, 164536, 3, 851},
	{13296, 164540, 2, 854},
	{13322, 164544, 3, 851},
	{13348, 164548, 2, 854},
	{13374, 164552, 3, 851},
	{13400, 164556, 2, 854},
	{13426, 164560},
	{13445, 164564},
	{13464, 164568},
	{13483, 164572},
	{13502, 164576},
	{13521, 164580},
	{13540, 164584},
	{13559, 164588},
	{13578, 164592},
	{13597, 164596},
	{13616, 164600},
	{13635, 164604},
	{13654, 164608},
	{13673, 164612},
	{13692, 164616},
	{13711, 164620},
	{13730, 164624},
	{13749, 164628},
	{13768, 164632},
	{13787, 164636},
	{13806, 164640},
	{13826, 164644},
	{13846, 164648},
	{13866, 164652},
	{13886, 164656},
	{13906, 164660},
	{13926, 164664},
	{13946, 164668},
	{13966, 164672},
	{13986, 164676},
	{14006, 164680},
	{14026, 164684},
	{14046, 164688, 15, 882},
	{14066, 164692, 3, 897},
	{14088, 164696, 2, 900},
	{14116, 164700, 4, 3165},
	{14145, 164704, 1, 909},
	{14166, 164708, 1, 910},
	{14176, 164712, 1, 911},
	{43501, 164716},
	{43523, 164720},
	{47615, 164816, 5, 3169},
	{47639, 164820},
	{47668, 164824, 1, 1622},
	{47701, 164828, 2, 3174},
	{47733, 164836, 11, 3176},
	{47759, 164848},
	{47779, 164852, 2, 3187},
	{47803, 164856, 2, 3174},
	{14294, 164876},
	{14323, 164880, 7, 3189},
	{14348, 164884},
	{14361, 164888},
	{14376, 164892},
	{14390, 164896},
	{47826, 164900, 8, 3196},
	{14420, 164904, 4, 938},
	{14444, 164908, 6, 942},
	{14463, 164912, 4, 948},
	{14481, 164916, 4, 952},
	{14502, 164924},
	{14521, 164928},
	{14541, 164932},
	{14560, 164936},
	{14580, 164940},
	{14599, 164944},
	{14619, 164948},
	{14640, 164952},
	{14662, 164956},
	{14683, 164960},
	{14705, 164964},
	{14726, 164968},
	{14748, 164972},
	{14769, 164976},
	{14791, 164980},
	{14812, 164984},
	{14834, 164988},
	{14855, 164992},
	{14877, 164996},
	{14898, 165000},
	{14920, 165004},
	{14941, 165008},
	{14963, 165012},
	{14984, 165016},
	{15006, 165020},
	{15027, 165024},
	{15049, 165028},
	{15070, 165032},
	{15092, 165036},
	{15113, 165040},
	{15135, 165044},
	{15156, 165048},
	{15178, 165052},
	{15199, 165056},
	{15221, 165060},
	{15242, 165064},
	{15264, 165068},
	{15285, 165072},
	{15307, 165076},
	{15328, 165080},
	{15350, 165084},
	{15371, 165088},
	{15393, 165092},
	{15414, 165096},
	{15436, 165100},
	{15457, 165104},
	{15479, 165108},
	{15500, 165112},
	{15522, 165116},
	{15543, 165120},
	{15565, 165124},
	{15586, 165128},
	{15608, 165132},
	{15629, 165136},
	{15651, 165140},
	{15672, 165144},
	{15694, 165148},
	{15715, 165152},
	{15737, 165156},
	{15758, 165160},
	{15780, 165164},
	{15802, 165168},
	{15825, 165172},
	{15847, 165176},
	{15870, 165180},
	{15892, 165184},
	{15915, 165188},
	{15937, 165192},
	{15960, 165196},
	{15982, 165200},
	{16005, 165204},
	{16027, 165208},
	{16050, 165212},
	{16072, 165216},
	{16095, 165220},
	{16117, 165224},
	{16140, 165228},
	{16162, 165232},
	{16185, 165236},
	{16207, 165240},
	{16230, 165244},
	{16252, 165248},
	{16275, 165252},
	{16297, 165256},
	{16320, 165260},
	{16342, 165264},
	{16365, 165268},
	{16387, 165272},
	{16410, 165276},
	{16432, 165280},
	{16455, 165284},
	{16477, 165288},
	{16500, 165292},
	{16522, 165296},
	{16545, 165300},
	{16567, 165304},
	{16590, 165308},
	{16604, 165312},
	{16618, 165316},
	{16632, 165320},
	{16646, 165324},
	{16660, 165328},
	{16674, 165332},
	{16688, 165336},
	{16702, 165340},
	{16716, 165344},
	{16730, 165348},
	{16744, 165352},
	{16758, 165356},
	{16772, 165360},
	{16786, 165364},
	{16800, 165368},
	{16814, 165372},
	{16828, 165376},
	{16842, 165380},
	{16856, 165384},
	{16870, 165388},
	{16884, 165392},
	{16898, 165396},
	{16912, 165400},
	{16926, 165404},
	{47842, 165408, 2, 3204},
	{16949, 165444, 13, 3206},
	{16969, 165448, 13, 3206},
	{16989, 165452, 13, 3206},
	{17009, 165456, 13, 3206},
	{17029, 165460, 13, 3206},
	{17049, 165464, 13, 3206},
	{17069, 165468, 13, 3206},
	{17089, 165472, 13, 3206},
	{17109, 165476, 13, 3206},
	{17129, 165480, 13, 3206},
	{17149, 165484, 13, 3206},
	{17170, 165488, 13, 3206},
	{17191, 165492, 13, 3206},
	{17212, 165496, 13, 3206},
	{17233, 165500, 13, 3206},
	{17254, 165504, 13, 3206},
	{17275, 165508, 13, 3206},
	{17296, 165512, 13, 3206},
	{17317, 165516, 13, 3206},
	{17338, 165520, 13, 3206},
	{17359, 165524, 11, 3219},
	{17380, 165528, 11, 3219},
	{17401, 165532, 11, 3219},
	{17422, 165536, 11, 3219},
	{17443, 165540, 11, 3219},
	{17464, 165544, 11, 3219},
	{17485, 165548, 11, 3219},
	{17506, 165552, 11, 3219},
	{17527, 165556, 11, 3219},
	{17548, 165560, 11, 3219},
	{17569, 165564, 11, 3219},
	{17590, 165568, 11, 3219},
	{17611, 165572, 3, 3230},
	{17629, 165580, 16, 980},
	{17646, 165584, 16, 980},
	{17664, 165588, 7, 996},
	{17685, 165592, 7, 3233},
	{17703, 165600, 7, 1009},
	{17718, 165608, 2, 3075},
	{47855, 165612},
	{47879, 165616, 1, 670},
	{17735, 165640, 1, 1016},
	{17757, 165644, 5, 1017},
	{17779, 165648, 1, 1022},
	{17799, 165652, 8, 1023},
	{43545, 165712, 8, 2482},
	{17821, 165716, 8, 3240},
	{17839, 165720, 8, 1039},
	{17860, 165724, 17, 1047},
	{17881, 165728, 6, 1064},
	{17899, 165732, 6, 1064},
	{17917, 165736, 6, 1064},
	{17935, 165740, 6, 1064},
	{17953, 165744, 6, 1064},
	{17971, 165748, 6, 1064},
	{17989, 165752, 6, 1064},
	{18007, 165756, 6, 1064},
	{18025, 165760, 9, 3248},
	{18043, 165764, 9, 3248},
	{18061, 165768, 9, 3248},
	{18079, 165772, 9, 3248},
	{18097, 165776, 9, 3248},
	{18115, 165780, 9, 3248},
	{18133, 165784, 9, 3248},
	{18151, 165788, 9, 3248},
	{18183, 165840, 1, 1079},
	{18198, 165844},
	{18216, 165848},
	{18234, 165852},
	{18251, 165856},
	{18272, 165860, 1, 1080},
	{18288, 165864},
	{18301, 165872, 6, 2498},
	{18335, 165880, 1, 1089},
	{18357, 165884, 1, 1090},
	{18384, 165888, 10, 1091},
	{18401, 165892, 12, 1101},
	{18409, 165896, 5, 3257},
	{18426, 165900, 18, 3262},
	{18444, 165904, 20, 1134},
	{18460, 165908, 16, 1154},
	{18479, 165912, 10, 1170},
	{18494, 165916, 29, 3280},
	{18512, 165920, 16, 1208},
	{18530, 165924, 3, 1224},
	{18554, 165928},
	{18579, 165932, 11, 1228},
	{18602, 165936, 5, 1239},
	{18653, 165944, 3, 2539},
	{18668, 165948, 5, 1250},
	{18698, 165952, 5, 1255},
	{18713, 165956},
	{43571, 165960, 6, 2542},
	{18731, 166400, 2, 1260},
	{18748, 166404, 2, 1262},
	{18767, 166408, 1, 1264},
	{18783, 166412, 4, 1265},
	{18836, 166424},
	{18859, 166428},
	{19085, 166472, 6, 2548},
	{19103, 166476, 24, 1317},
	{19121, 166480},
	{19265, 166512},
	{19276, 166516},
	{19289, 166520},
	{19306, 166524, 9, 2554},
	{19325, 166528},
	{19336, 166532, 3, 1358},
	{19355, 166536},
	{19377, 166540},
	{19399, 166544, 3, 3309},
	{19446, 166552, 4, 2563},
	{19537, 166572, 1, 1377},
	{19583, 166580, 1, 1378},
	{19612, 166588, 9, 1380},
	{19629, 166592, 4, 1389},
	{19656, 166596, 4, 1393},
	{19683, 166600, 4, 1397},
	{20018, 166696},
	{20049, 166700},
	{20092, 166704, 1, 1402},
	{20130, 166712, 1, 1403},
	{20150, 166732, 2, 1404},
	{20169, 166736, 5, 1406},
	{20191, 166740, 17, 3312},
	{20212, 166744, 3, 1430},
	{20319, 166764, 11, 3329},
	{20332, 166768, 6, 1445},
	{20373, 166776, 2, 1451},
	{20403, 166780},
	{20427, 166784},
	{20457, 166788},
	{20488, 166792},
	{20517, 166796},
	{20547, 166800, 3, 1453},
	{20636, 166868, 8, 1468},
	{20662, 166872, 8, 1476},
	{20688, 166876, 5, 1484},
	{20704, 166880, 8, 2597},
	{20720, 166884, 3, 1495},
	{20735, 166888},
	{20758, 166892},
	{20781, 166896},
	{20804, 166900},
	{20827, 166904, 8, 1498},
	{20861, 166908, 8, 1506},
	{20895, 166912, 8, 1514},
	{20929, 166916, 8, 1522},
	{20963, 166920, 8, 1498},
	{20997, 166924, 8, 1506},
	{21031, 166928, 8, 1514},
	{21065, 166932, 8, 1522},
	{21099, 166936, 8, 1498},
	{21133, 166940, 8, 1506},
	{21167, 166944, 8, 1514},
	{21201, 166948, 8, 1522},
	{21235, 166952, 8, 1498},
	{21269, 166956, 8, 1506},
	{21303, 166960, 8, 1514},
	{21337, 166964, 8, 1522},
	{21371, 166968, 2, 1530},
	{21395, 166972, 2, 1532},
	{21419, 166976, 5, 3340},
	{21440, 166980, 12, 3345},
	{21460, 166984, 2, 1550},
	{21480, 166988, 20, 1552},
	{21518, 166992, 6, 3357},
	{47903, 166996, 10, 3363},
	{21587, 167008},
	{21634, 167020, 3, 1579},
	{21649, 167024, 10, 3373},
	{21664, 167028, 5, 3383},
	{47923, 167032, 17, 3388},
	{21823, 167060},
	{21842, 167068},
	{21889, 167080, 3, 1579},
	{21904, 167084, 10, 3373},
	{21919, 167088, 5, 3383},
	{47946, 167092, 17, 3388},
	{22078, 167120},
	{22097, 167128},
	{22144, 167140, 3, 1579},
	{22159, 167144, 10, 3373},
	{22174, 167148, 5, 3383},
	{47969, 167152, 17, 3388},
	{22333, 167180},
	{22352, 167188},
	{22399, 167200, 3, 1579},
	{22414, 167204, 10, 3373},
	{22429, 167208, 5, 3383},
	{47992, 167212, 17, 3388},
	{22588, 167240},
	{22607, 167248},
	{22654, 167260, 3, 1579},
	{22669, 167264, 10, 3373},
	{22684, 167268, 5, 3383},
	{48015, 167272, 17, 3388},
	{22843, 167300},
	{22862, 167308},
	{22909, 167320, 3, 1579},
	{22924, 167324, 10, 3373},
	{22939, 167328, 5, 3383},
	{48038, 167332, 17, 3388},
	{23098, 167360},
	{23117, 167368},
	{23164, 167380, 3, 1579},
	{23179, 167384, 10, 3373},
	{23194, 167388, 5, 3383},
	{48061, 167392, 17, 3388},
	{23353, 167420},
	{23372, 167428},
	{23419, 167440, 3, 1579},
	{23434, 167444, 10, 3373},
	{23449, 167448, 5, 3383},
	{48084, 167452, 17, 3388},
	{23608, 167480},
	{23627, 167488, 1, 1622},
	{23646, 167492, 1, 1622},
	{23665, 167496, 1, 1622},
	{23684, 167500, 1, 1622},
	{23703, 167504, 1, 1622},
	{23722, 167508, 1, 1622},
	{23741, 167512, 1, 1622},
	{23760, 167516, 1, 1622},
	{24179, 167584, 1, 1622},
	{24202, 167588, 1, 1622},
	{24225, 167592, 1, 1622},
	{24248, 167596, 1, 1622},
	{24271, 167600, 1, 1622},
	{24294, 167604, 1, 1622},
	{24317, 167608, 1, 1622},
	{24340, 167612, 1, 1622},
	{24363, 167616, 3, 1623},
	{24381, 167620, 3, 1623},
	{24399, 167624, 3, 1623},
	{24417, 167628, 3, 1623},
	{24435, 167632, 3, 1623},
	{24453, 167636, 3, 1623},
	{24471, 167640, 3, 1623},
	{24489, 167644, 3, 1623},
	{24507, 167648, 5, 3405},
	{24525, 167652, 5, 3405},
	{24543, 167656, 5, 3405},
	{24561, 167660, 5, 3405},
	{24579, 167664, 5, 3405},
	{24597, 167668, 5, 3405},
	{24615, 167672, 5, 3405},
	{24633, 167676, 5, 3405},
	{24651, 196608, 1, 1634},
	{24671, 196612, 1, 1635},
	{24691, 196616},
	{24711, 196620},
	{24731, 196624},
	{24752, 196628},
	{25289, 196704, 1, 1638},
	{25311, 196708, 1, 1639},
	{25333, 196712},
	{25356, 196716},
	{25379, 196720},
	{25402, 196724},
	{25425, 196728},
	{25448, 196732},
	{25471, 196736},
	{25495, 196740},
	{25519, 196744},
	{25543, 196748},
	{25567, 196752},
	{25591, 196756},
	{25615, 196760},
	{25639, 196764},
	{25663, 196768},
	{25685, 196772},
	{25707, 196776},
	{25728, 196780},
	{25749, 196784},
	{25773, 196788},
	{25797, 196792},
	{25821, 196796},
	{25845, 196800},
	{25869, 196804},
	{48107, 196808},
	{48131, 196812},
	{25953, 196852, 1, 1641},
	{26013, 196864},
	{26026, 196868},
	{26039, 196872},
	{26052, 196876},
	{26065, 196880},
	{26078, 196884},
	{26091, 196888},
	{26104, 196892},
	{43586, 196896, 5, 2647},
	{26140, 196908, 1, 670},
	{26159, 196912},
	{26177, 196916},
	{26204, 196920},
	{26257, 196936},
	{26280, 196940},
	{26303, 196944},
	{26331, 196948},
	{26359, 196952},
	{26387, 196956},
	{26415, 196960, 1, 1645},
	{26433, 196964, 6, 3410},
	{26451, 196968},
	{26466, 196972},
	{26490, 196976},
	{26514, 196980},
	{26533, 196984},
	{26552, 196988},
	{26576, 196992},
	{26600, 196996},
	{26624, 197000},
	{26648, 197028, 1, 1650},
	{26666, 197032, 7, 3416},
	{26684, 197036},
	{26702, 197040},
	{26720, 197044, 1, 1653},
	{26738, 197048, 5, 3423},
	{26756, 197052},
	{26774, 197056, 2, 2652},
	{26793, 197060, 5, 1658},
	{26812, 197072},
	{26836, 197076, 2, 2652},
	{26856, 197080, 5, 1658},
	{26876, 197084, 9, 3428},
	{26895, 197088, 9, 3428},
	{27009, 197120},
	{27028, 197124, 1, 1687},
	{27050, 197128},
	{27069, 197132, 1, 1688},
	{27091, 197136, 7, 1689},
	{27109, 197140},
	{27129, 197144, 1, 1687},
	{27152, 197148},
	{27172, 197152, 1, 1688},
	{27195, 197156, 7, 1689},
	{27214, 197160, 7, 1696},
	{27226, 197164, 2, 1703},
	{27260, 197172, 1, 1706},
	{27278, 197176, 6, 3437},
	{27298, 197180, 2, 330},
	{27315, 197184},
	{27331, 197188, 1, 1713},
	{27358, 197196, 1, 1715},
	{27414, 197208, 1, 1718},
	{27436, 197212, 1, 1719},
	{27504, 197232, 2, 1720},
	{27526, 197236, 2, 1722},
	{27548, 197240, 2, 1720},
	{27571, 197244, 2, 1722},
	{27594, 197248, 2, 1720},
	{27616, 197252, 2, 1722},
	{43605, 197256},
	{43627, 197260},
	{48155, 197264},
	{48177, 197268},
	{48199, 197272},
	{48222, 197276},
	{27716, 197380, 1, 1726},
	{27733, 197384, 1, 1727},
	{27951, 197436, 1, 1734},
	{27966, 197440, 1, 1735},
	{27981, 197444, 1, 1736},
	{27994, 197448, 1, 1737},
	{28008, 197452, 1, 1738},
	{28022, 197456, 1, 1739},
	{28034, 197460, 6, 3443},
	{28057, 197464, 6, 3449},
	{28079, 197468, 1, 1747},
	{28099, 197472, 1, 1748},
	{28113, 197476, 1, 1749},
	{28127, 197480, 1, 1750},
	{28139, 197484, 1, 1751},
	{28223, 197552, 1, 1752},
	{28272, 197560, 1, 1753},
	{28292, 197568},
	{28318, 197572, 1, 1635},
	{28400, 197584},
	{28423, 197588, 1, 1635},
	{28449, 197592},
	{28471, 197596, 1, 1635},
	{28496, 197600},
	{28515, 197604, 1, 1635},
	{28537, 197608, 1, 1350},
	{28551, 197612},
	{28568, 197616, 1, 1635},
	{28588, 197620, 8, 1754},
	{28605, 197624, 13, 1762},
	{28622, 197628},
	{28639, 197632, 1, 1705},
	{28659, 197636},
	{28676, 197640, 1, 1670},
	{28696, 197644, 2, 1775},
	{28715, 197888, 8, 1777},
	{28736, 197892, 8, 1777},
	{28757, 198656, 6, 1785},
	{28810, 198920, 1, 3455},
	{28829, 198924, 2, 2664},
	{28976, 198948},
	{28992, 198952},
	{29007, 198956, 3, 3456},
	{29033, 198960},
	{29049, 198964},
	{29067, 198968, 1, 3459},
	{29084, 198972, 2, 2666},
	{29105, 198976},
	{29285, 199012},
	{29301, 199016},
	{29322, 199020, 8, 3460},
	{29330, 199024},
	{29344, 199028},
	{29358, 199032},
	{29372, 199036, 3, 1808},
	{29387, 199040, 2, 1811},
	{29399, 199044, 1, 837},
	{29421, 199048, 3, 1813},
	{43801, 199052, 2, 2668},
	{48245, 199056, 2, 3468},
	{48270, 199060, 1, 3470},
	{19244, 199064, 1, 3471},
	{29437, 199168, 1, 1816},
	{29462, 199172, 2, 1817},
	{29487, 199184, 2, 1819},
	{29513, 199188, 2, 1819},
	{29539, 199192, 2, 1819},
	{29565, 199212, 2, 1819},
	{29591, 199296, 2, 1821},
	{29619, 199300, 1, 1823},
	{29643, 199304, 1, 1824},
	{29667, 199308, 1, 1825},
	{29700, 199312, 1, 1825},
	{29728, 199328, 2, 1821},
	{29757, 199332, 1, 1823},
	{29782, 199336, 1, 1824},
	{29807, 199340, 1, 1825},
	{29841, 199344, 1, 1825},
	{29870, 199360, 2, 1821},
	{29894, 199364, 1, 1823},
	{29914, 199368, 1, 1824},
	{29934, 199372, 1, 1825},
	{29963, 199376, 1, 1825},
	{29987, 199936},
	{30014, 199940},
	{30041, 199944},
	{30068, 199948},
	{30095, 199952},
	{30122, 199956},
	{30149, 199960},
	{30176, 199964},
	{30203, 199968, 4, 2670},
	{30228, 200192},
	{30247, 200196, 1, 847},
	{30269, 200448},
	{30293, 200452, 1, 1835},
	{30316, 200456},
	{30340, 200460, 1, 1835},
	{30363, 200464},
	{30387, 200468, 1, 1835},
	{30410, 200472},
	{30434, 200476, 1, 1835},
	{30494, 200704},
	{30506, 200708},
	{30518, 200712},
	{30536, 200716},
	{30555, 200720},
	{30573, 200724},
	{30585, 200728},
	{30597, 200732},
	{30615, 200736},
	{30633, 200740},
	{30652, 200744, 4, 1836},
	{30666, 200748, 2, 1840},
	{30684, 200752, 2, 3472},
	{30698, 200756, 2, 3474},
	{30712, 200760, 2, 1846},
	{30729, 200764, 2, 1848},
	{30746, 200768},
	{30759, 200772, 2, 1850},
	{30771, 200776},
	{30785, 200780},
	{30801, 200784},
	{30815, 200788},
	{30831, 200792},
	{30846, 200796},
	{30863, 200800},
	{30878, 200804},
	{30895, 200808, 2, 1852},
	{30917, 200812, 9, 3476},
	{30934, 200816, 2, 1864},
	{30955, 200820, 2, 1866},
	{30967, 200824},
	{30982, 200828, 6, 1868},
	{30997, 200832, 2, 1874},
	{31011, 200836},
	{48297, 200840},
	{48326, 200844},
	{48355, 200848},
	{48384, 200852},
	{48413, 200856},
	{48422, 200860},
	{48431, 200864},
	{48440, 200868},
	{48449, 200872},
	{48479, 200876},
	{48509, 200880},
	{48540, 200884},
	{48571, 200888},
	{48601, 200892},
	{48631, 200896},
	{48662, 200900},
	{48693, 200904},
	{48723, 200908},
	{48753, 200912},
	{48784, 200916},
	{48815, 200920},
	{48845, 200924},
	{48875, 200928},
	{48906, 200932},
	{2911, 200960, 7, 3485},
	{48937, 200964, 13, 3492},
	{48955, 200968, 7, 3505},
	{48973, 200972, 3, 3512},
	{48993, 200976, 8, 3515},
	{49015, 200980, 8, 3523},
	{49037, 200984},
	{49061, 200988, 6, 3531},
	{31124, 212992},
	{31144, 212996},
	{31164, 213000},
	{31184, 213004},
	{31204, 213008},
	{31224, 213012},
	{31244, 213016},
	{31264, 213020},
	{31284, 213024},
	{31304, 213028},
	{31324, 213032},
	{31344, 213036},
	{31364, 213040},
	{31387, 213044},
	{31410, 213048},
	{31433, 213248},
	{31454, 213252},
	{31475, 213260},
	{31496, 213264},
	{31517, 213268},
	{31541, 213272},
	{31565, 213276},
	{31589, 213280},
	{31613, 213284},
	{31637, 213288},
	{31661, 213292},
	{31685, 213296},
	{49085, 213300},
	{49109, 213304},
	{49133, 213308},
	{49157, 213312},
	{49181, 213316},
	{49205, 213320},
	{43813, 213648},
	{43833, 213652},
	{43853, 213656},
	{43873, 213660},
	{43893, 213664},
	{43913, 213668},
	{43933, 213672},
	{43953, 213676},
	{43973, 213680},
	{43998, 213684},
	{44023, 213688},
	{44048, 213692},
	{44073, 213696},
	{44098, 213700},
	{44123, 213704},
	{44148, 213708},
	{44173, 213712},
	{44196, 213716},
	{44219, 213720},
	{44242, 213724},
	{44265, 213728},
	{44288, 213732},
	{44311, 213736},
	{44334, 213740},
	{32169, 214016},
	{32191, 214020, 1, 1876},
	{32213, 214024},
	{32235, 214028, 1, 1876},
	{32257, 214032},
	{32279, 214036, 1, 1876},
	{32301, 214040},
	{32323, 214044, 1, 1876},
	{32345, 214272},
	{32367, 214276},
	{32389, 214280},
	{32411, 214284},
	{32433, 214288},
	{32455, 214292},
	{32477, 214296},
	{32499, 214300},
	{32521, 214304},
	{32543, 214308},
	{32565, 214312},
	{32587, 214316},
	{32609, 214320},
	{32631, 214324},
	{32653, 214328},
	{32675, 214332},
	{32697, 214528},
	{32717, 214532},
	{32737, 214536},
	{32757, 214540},
	{32777, 214544},
	{32797, 214548},
	{32817, 214552},
	{32837, 214556},
	{32857, 214560},
	{32877, 214564},
	{32897, 214568},
	{32917, 214572},
	{31265, 214576},
	{31245, 214580},
	{31225, 214584},
	{31205, 214588},
	{49229, 214592},
	{49248, 214596},
	{49267, 214600},
	{49286, 214604},
	{32937, 214784},
	{32975, 214792},
	{33013, 214800},
	{33051, 214808},
	{33089, 214816},
	{33127, 214824},
	{33165, 214832},
	{33203, 214840},
	{49305, 214928},
	{49325, 214932},
	{49345, 214936},
	{49365, 214940},
	{49385, 214944},
	{49405, 214948},
	{49425, 214952},
	{49445, 214956},
	{49465, 214960},
	{49485, 214964},
	{49505, 214968},
	{49525, 214972},
	{49545, 214976},
	{49565, 214980},
	{49585, 214984},
	{49605, 214988},
	{33557, 215296},
	{33576, 215300},
	{33595, 215304},
	{33614, 215308},
	{33633, 215312},
	{33652, 215316},
	{33671, 215320},
	{33690, 215324},
	{33709, 215424},
	{33730, 215428},
	{44357, 215432},
	{44377, 215436, 2, 1877},
	{33751, 215552},
	{33771, 215556},
	{33791, 215560},
	{33811, 215564},
	{33831, 215568},
	{33851, 215572},
	{33871, 215576},
	{33891, 215580},
	{33911, 215808},
	{33930, 215812},
	{33949, 215816},
	{33968, 215820},
	{33987, 216064},
	{34006, 216068},
	{34025, 216072},
	{34044, 216076},
	{34063, 216320},
	{34083, 216324},
	{34103, 216328},
	{34123, 216332},
	{34143, 216336},
	{34163, 216340},
	{34183, 216344},
	{34203, 216348},
	{49625, 216352, 12, 3537},
	{49648, 216356, 1, 3549},
	{49672, 216360, 13, 3550},
	{34223, 216576},
	{34244, 216580},
	{34265, 216584},
	{34286, 216588},
	{34307, 216592},
	{34328, 216596},
	{34349, 216600},
	{34370, 216604},
	{34391, 216640},
	{34412, 216644},
	{34433, 216648},
	{34454, 216652},
	{34475, 216656},
	{34496, 216660},
	{34517, 216664},
	{34538, 216668},
	{34559, 216704},
	{34580, 216708},
	{34601, 216712},
	{34622, 216716},
	{34643, 216720},
	{34664, 216724},
	{34685, 216728},
	{34706, 216732},
	{34727, 216832},
	{34747, 216836},
	{34767, 216840},
	{34787, 216844},
	{34807, 216848},
	{34827, 216852},
	{34847, 216856},
	{34867, 216860},
	{34887, 216864},
	{34908, 216868},
	{34929, 216872},
	{34950, 216876},
	{34971, 216880},
	{34992, 216884},
	{35013, 216888},
	{35034, 216892},
	{35055, 217112},
	{35074, 217116},
	{35093, 217120},
	{35112, 217124},
	{35131, 217128},
	{35150, 217132},
	{35169, 217136},
	{35188, 217140},
	{35207, 217344},
	{35226, 217348},
	{35245, 217352},
	{35264, 217356},
	{35283, 217360},
	{35302, 217364},
	{35321, 217368},
	{35340, 217372},
	{35359, 217600},
	{35379, 217604},
	{35399, 217608},
	{35419, 217612},
	{35439, 217856},
	{35459, 217860},
	{35479, 217864},
	{35499, 217868},
	{35519, 217872},
	{35539, 217876},
	{35559, 217880},
	{35579, 217884},
	{35701, 217984},
	{35726, 217988},
	{35751, 217992},
	{35776, 217996},
	{35649, 218000},
	{35675, 218004, 2, 1877},
	{44397, 218008},
	{44420, 218012, 2, 1877},
	{35941, 218240},
	{35961, 218244},
	{35981, 218248},
	{36001, 218252},
	{36021, 218624},
	{36043, 218628},
	{36065, 218632},
	{36087, 218636},
	{36109, 218640},
	{36131, 218644},
	{36153, 218648},
	{36175, 218652},
	{36197, 218656},
	{36219, 218660},
	{36241, 218664},
	{36263, 218668},
	{36285, 218672},
	{36307, 218676},
	{36329, 218680},
	{36351, 218684},
	{35853, 218752},
	{35875, 218756},
	{35897, 218760},
	{35919, 218764},
	{49698, 218768},
	{49720, 218772},
	{49742, 218776},
	{49764, 218780},
	{36373, 218880},
	{36394, 218884},
	{36415, 218888},
	{36436, 218892},
	{36457, 218896},
	{36478, 218900},
	{36499, 218904},
	{36520, 218908},
	{49786, 218944},
	{49807, 218948},
	{49828, 218952},
	{49849, 218956},
	{49870, 218960},
	{49891, 218964},
	{49912, 218968},
	{49933, 218972},
	{36541, 219136},
	{36561, 219140},
	{36581, 219144},
	{36601, 219148},
	{36621, 219152},
	{36641, 219156},
	{36661, 219160},
	{36681, 219164},
	{36701, 219392},
	{36721, 219396},
	{44443, 219400},
	{44462, 219404, 2, 1877},
	{44481, 219520},
	{44510, 219524, 2, 1877},
	{44539, 219528},
	{44561, 219532},
	{44583, 219536},
	{44605, 219540},
	{44627, 219568},
	{44656, 219572, 2, 1877},
	{44685, 219576},
	{44707, 219580},
	{44729, 219584},
	{44751, 219588},
	{36741, 221184, 3, 3563},
	{36765, 221188, 4, 1884},
	{36790, 221192, 5, 1879},
	{36814, 221196, 3, 3563},
	{36838, 221200, 4, 1884},
	{36863, 221204, 3, 3563},
	{36887, 221208, 4, 1884},
	{36912, 221212, 5, 1879},
	{36936, 221216, 4, 1888},
	{36952, 221220, 5, 1879},
	{36976, 221224, 3, 1892},
	{37010, 221228, 3, 1895},
	{37044, 221232, 3, 1898},
	{37069, 221236, 3, 1901},
	{37094, 221240, 3, 1898},
	{49954, 221244, 3, 1895},
	{37119, 221248},
	{37134, 221252, 1, 1825},
	{37157, 221256},
	{37180, 221260},
	{37198, 221264, 2, 1904},
	{37216, 221268, 4, 1906},
	{37236, 221440, 20, 1910},
	{37261, 221444, 20, 1910},
	{37286, 221448, 18, 3566},
	{37314, 221452, 18, 3566},
	{37342, 221456, 18, 3566},
	{37370, 221460, 18, 3566},
	{49988, 221464, 18, 3566},
	{50016, 221468, 18, 3566},
	{50044, 221472, 18, 3566},
	{37398, 221492, 9, 3584},
	{37426, 221496, 9, 3584},
	{45065, 221840, 5, 3593},
	{45089, 221844, 4, 1969},
	{45114, 221848, 5, 3593},
	{45138, 221852, 4, 1969},
	{45163, 221856, 5, 3593},
	{45187, 221860, 4, 1969},
	{45212, 221864, 5, 3593},
	{45236, 221868, 4, 1969},
	{45261, 221872, 5, 3593},
	{45290, 221876, 4, 1969},
	{45320, 221880, 5, 3593},
	{45349, 221884, 4, 1969},
	{45379, 221888, 5, 3593},
	{45408, 221892, 4, 1969},
	{45438, 221896, 5, 3593},
	{45467, 221900, 4, 1969},
	{45497, 221904, 5, 3593},
	{45524, 221908, 4, 1969},
	{45552, 221912, 5, 3593},
	{45579, 221916, 4, 1969},
	{45607, 221920, 5, 3593},
	{45634, 221924, 4, 1969},
	{45662, 221928, 5, 3593},
	{45689, 221932, 4, 1969},
	{37828, 222208, 5, 1964},
	{37854, 222212, 4, 1969},
	{37881, 222216, 5, 1964},
	{37907, 222220, 4, 1969},
	{37934, 222224, 5, 1964},
	{37960, 222228, 4, 1969},
	{37987, 222232, 5, 1964},
	{38013, 222236, 4, 1969},
	{38040, 222464, 5, 1964},
	{38066, 222468, 4, 1969},
	{38093, 222472, 1, 1879},
	{38119, 222476, 1, 1879},
	{38145, 222480, 1, 1879},
	{38171, 222484, 1, 1879},
	{38197, 222488, 1, 1879},
	{38223, 222492, 1, 1879},
	{38249, 222496, 1, 1879},
	{38275, 222720, 5, 1964},
	{38299, 222724, 5, 1964},
	{38323, 222728, 5, 1964},
	{38347, 222732, 5, 1964},
	{38371, 222736, 4, 1969},
	{38396, 222740, 4, 1969},
	{38421, 222744, 4, 1969},
	{38446, 222748, 4, 1969},
	{38471, 222752, 1, 1879},
	{38495, 222756, 1, 1879},
	{38519, 222760, 8, 1973},
	{36953, 222768, 5, 1964},
	{36815, 222772, 5, 1964},
	{50072, 222776, 5, 1964},
	{50095, 222780, 5, 1964},
	{36839, 222784, 4, 1969},
	{50118, 222788, 4, 1969},
	{50142, 222792, 4, 1969},
	{50166, 222796, 4, 1969},
	{38540, 222976, 3, 2686},
	{38563, 222980, 3, 2686},
	{38586, 222984, 3, 2686},
	{38609, 222988, 3, 2686},
	{38632, 222992, 3, 2686},
	{38655, 222996, 3, 2686},
	{38678, 223000, 3, 2686},
	{38701, 223004, 3, 2686},
	{38724, 223008, 3, 2686},
	{38747, 223012, 3, 2686},
	{38770, 223016, 3, 2686},
	{38794, 223020, 3, 2686},
	{38818, 223024, 3, 2686},
	{38842, 223028, 3, 2686},
	{38866, 223032, 3, 2686},
	{38890, 223036, 3, 2686},
	{50190, 223040, 3, 2686},
	{50214, 223044, 3, 2686},
	{50238, 223048, 3, 2686},
	{50262, 223052, 3, 2686},
	{50286, 223056, 3, 2686},
	{50310, 223060, 3, 2686},
	{50334, 223064, 3, 2686},
	{50358, 223068, 3, 2686},
	{50382, 223072, 10, 3598},
	{50403, 223080, 2, 3608},
	{50425, 223084, 1, 3610},
	{38914, 223104, 10, 3598},
	{38934, 223112, 2, 3608},
	{2386, 223136},
	{2412, 223140, 2, 343},
	{2438, 223144},
	{2464, 223148, 2, 343},
	{2559, 223152, 18, 3611},
	{2511, 223156, 5, 3629},
	{2532, 223160, 7, 3634},
	{2490, 223164, 2, 345},
	{2580, 223184, 5, 3641},
	{43456, 223188, 6, 3646},
	{2632, 223192},
	{2662, 223196},
	{2694, 223200},
	{2725, 223204},
	{2603, 223208},
	{38955, 223232, 5, 1964},
	{38980, 223236, 4, 1969},
	{39006, 223240, 8, 1995},
	{45717, 223244, 5, 2147},
	{45739, 223248, 5, 2147},
	{45761, 223252, 6, 2152},
	{39029, 223488, 5, 1964},
	{39052, 223492, 5, 1964},
	{39075, 223496, 3, 2020},
	{39098, 223500, 3, 2020},
	{39121, 223504, 4, 1969},
	{39145, 223508, 4, 1969},
	{39169, 223744, 5, 1964},
	{39193, 223748, 5, 1964},
	{39217, 223752, 5, 1964},
	{39241, 223756, 5, 1964},
	{39265, 223760, 4, 1969},
	{45788, 223764, 4, 1969},
	{45813, 223768, 4, 1969},
	{45838, 223772, 4, 1969},
	{39290, 224000, 5, 1964},
	{39313, 224004, 4, 1969},
	{39337, 224008, 3, 2020},
	{39360, 224256, 5, 1964},
	{39383, 224260, 4, 1969},
	{39407, 224264, 3, 2020},
	{39430, 224512, 5, 1964},
	{39454, 224516, 4, 1969},
	{39479, 224520, 5, 1964},
	{39503, 224524, 4, 1969},
	{39528, 224528, 3, 2020},
	{39552, 224532, 3, 2020},
	{39576, 224768, 5, 1964},
	{39601, 224772, 4, 1958},
	{39627, 224776, 5, 1964},
	{39652, 224780, 4, 1958},
	{39678, 224784, 3, 2020},
	{39703, 224788, 3, 2020},
	{39728, 224832, 5, 1964},
	{39753, 224836, 4, 1958},
	{39779, 224840, 5, 1964},
	{39804, 224844, 4, 1958},
	{39830, 224848, 3, 2020},
	{39855, 224852, 3, 2020},
	{39880, 224896, 5, 1964},
	{39905, 224900, 4, 1958},
	{39931, 224904, 3, 2020},
	{39956, 224908, 3, 2020},
	{39981, 224912, 3, 2020},
	{40006, 225024, 5, 1964},
	{40030, 225028, 4, 1958},
	{40055, 225032, 3, 2020},
	{40079, 225036, 3, 2020},
	{40103, 225040, 3, 2020},
	{40127, 225048, 5, 1964},
	{40152, 225052, 4, 1958},
	{40178, 225056, 3, 2020},
	{40203, 225060, 3, 2020},
	{40228, 225064, 3, 2020},
	{40253, 225280, 12, 2023},
	{40275, 225284, 5, 1964},
	{40298, 225288, 4, 1969},
	{40322, 225292, 2, 3652},
	{40345, 225296, 2, 3652},
	{40368, 225300, 2, 3652},
	{40391, 225536, 5, 1964},
	{40414, 225540, 4, 1969},
	{40438, 225544, 5, 1964},
	{40461, 225548, 4, 1969},
	{40485, 225552, 5, 1964},
	{40508, 225560, 5, 1964},
	{40531, 225792, 5, 3654},
	{40552, 225796},
	{40581, 225800, 2, 2050},
	{40610, 225804},
	{41067, 225808, 2, 2077},
	{40665, 225812},
	{40684, 225816, 2, 2059},
	{40636, 225820, 3, 3659},
	{40756, 225824, 1, 3662},
	{40783, 225828, 2, 3663},
	{40710, 225832, 1, 3662},
	{40733, 225836, 2, 3663},
	{41086, 225864, 2, 2079},
	{41113, 225868},
	{46053, 225872, 2, 2079},
	{46084, 225876},
	{41140, 225880, 2, 2704},
	{41167, 225884, 2, 2083},
	{46115, 225888, 4, 2753},
	{41194, 225892, 18, 3665},
	{41215, 225896, 9, 2723},
	{41234, 225900, 22, 3683},
	{41253, 225904, 1, 2111},
	{41277, 225908, 1, 2113},
	{41309, 225912, 2, 2115},
	{46186, 225916, 3, 2757},
	{50448, 225928, 2, 3705},
	{50462, 225932, 10, 3707},
	{45923, 225936},
	{45896, 225940},
	{50477, 225972, 1, 3717},
	{50490, 225976},
	{50515, 225980, 1, 3718},
	{50540, 225984, 1, 3719},
	{50560, 225988},
	{50582, 225992, 2, 3720},
	{50602, 225996},
	{50630, 226000, 1, 3718},
	{50658, 226004, 1, 3719},
	{50681, 226008},
	{50706, 226012, 2, 3720},
	{50729, 226016, 1, 3722},
	{50746, 226020, 9, 3723},
	{50767, 226044},
	{41446, 226048, 2, 2126},
	{41463, 226052, 1, 2128},
	{41487, 226056, 1, 2128},
	{41511, 226060, 4, 2129},
	{41537, 226064, 3, 2133},
	{41566, 226068, 1, 694},
	{41595, 226072, 3, 2133},
	{41624, 226076, 1, 694},
	{41701, 226304, 5, 1964},
	{41725, 226308, 4, 1969},
	{41750, 226312, 2, 3652},
	{41774, 226316, 5, 1964},
	{41798, 226320, 4, 1969},
	{41823, 226324, 2, 3652},
	{41847, 226328, 10, 2137},
	{42212, 226432, 5, 1964},
	{42241, 226436, 5, 1964},
	{42270, 226440, 4, 1969},
	{42300, 226444, 4, 1969},
	{42330, 226448, 8, 1995},
	{42357, 226452, 8, 1995},
	{41955, 226496, 5, 2147},
	{41983, 226500, 5, 2147},
	{42011, 226504, 5, 2147},
	{42039, 226508, 5, 2147},
	{42067, 226512, 5, 2147},
	{42095, 226516, 5, 2147},
	{42123, 226520, 5, 2147},
	{42151, 226524, 5, 2147},
	{42179, 226528, 6, 2152},
	{46227, 226532, 5, 2147},
	{46252, 226536, 5, 2147},
	{46277, 226540, 5, 2147},
	{46302, 226544, 5, 2147},
	{46327, 226548, 6, 2152},
	{42473, 226688, 5, 1964},
	{42497, 226692, 4, 1969},
	{42522, 226696, 3, 2020},
	{42598, 226816, 5, 1964},
	{42624, 226820, 4, 1969},
	{42651, 226824, 5, 1964},
	{42677, 226828, 5, 1964},
	{42703, 226832, 5, 1964},
	{42729, 226836, 1, 1879},
	{42755, 226840, 1, 1879},
	{42781, 226844, 1, 1879},
	{42807, 226848, 1, 1879},
	{42833, 226880, 4, 1969},
	{42860, 226884, 4, 1969},
	{42887, 226888, 4, 1969},
	{42546, 226944, 2, 2161},
	{42572, 226948, 2, 2161},
	{50781, 226952, 2, 2161},
	{50807, 226956, 2, 2161},
	{42914, 227072, 5, 1964},
	{42939, 227076, 4, 1958},
	{42965, 227080, 3, 2020},
	{42990, 227084, 3, 2020},
	{43015, 227088, 3, 2020},
	{50833, 227136, 5, 1964},
	{50858, 227140, 4, 1958},
	{50884, 227144, 3, 2020},
	{50909, 227148, 3, 2020},
	{50934, 227152, 3, 2020},
	{43040, 227200, 5, 1964},
	{43064, 227204, 4, 1958},
	{43089, 227208, 3, 2020},
	{43113, 227212, 3, 2020},
	{43137, 227216, 3, 2020},
	{43161, 227328, 5, 1964},
	{43185, 227332, 4, 1969},
	{43210, 227336, 8, 1995},
	{46357, 227340, 5, 2147},
	{46378, 227344, 5, 2147},
	{46399, 227348, 6, 2152},
	{46425, 227456, 5, 2147},
	{46456, 227460, 5, 2147},
	{46487, 227464, 6, 2152},
	{46523, 227468, 1, 2760},
	{46547, 227472, 5, 1964},
	{46573, 227476, 4, 1969},
	{46600, 227480, 5, 1964},
	{46626, 227484, 4, 1969},
	{46653, 227504, 5, 2147},
	{46684, 227508, 5, 2147},
	{46715, 227512, 6, 2152},
	{46751, 227516, 1, 2760},
	{46775, 227520, 5, 1964},
	{46801, 227524, 4, 1969},
	{46828, 227528, 5, 1964},
	{46854, 227532, 4, 1969},
	{206, 880, 4, 2163},
	{43232, 881},
	{27079, 882},
	{43244, 1008},
	{43255, 1009},
	{27267, 1010, 4, 2167},
	{43266, 1040, 1, 2171},
	{43279, 1041, 5, 2172},
	{43292, 1042, 1, 2177},
	{43305, 1043, 1, 1688},
	{27101, 1045, 7, 2178},
	{43318, 1168, 18, 3732},
	{43333, 1281, 6, 2197},
	{43348, 1282},
	{27038, 1283},
	{43232, 1285},
	{27079, 1286},
	{50959, 1408, 4, 3750},
	{50977, 1413, 1, 3754},
	{43360, 1414, 15, 2203},
};

static const struct si_reg gfx115_reg_table[] = {
	{43369, 40, 1, 2218},
	{43384, 44, 1, 2218},
	{1390, 1028, 10, 2761},
	{1403, 1032, 26, 2771},
	{1418, 1036, 11, 2797},
	{1455, 1044, 2, 2808},
	{1473, 1048, 3, 56},
	{1491, 1052, 4, 2810},
	{1506, 1056},
	{1520, 1060, 1, 70},
	{1551, 1076, 2, 78},
	{1567, 1080},
	{1962, 1104},
	{1986, 1108},
	{1584, 1116, 6, 2814},
	{1599, 1120, 6, 85},
	{1614, 1124, 2, 92},
	{1634, 1128, 1, 94},
	{1673, 1136, 4, 2820},
	{43407, 1140, 1, 2237},
	{1689, 2480},
	{1703, 2484},
	{1717, 2488},
	{1731, 2492},
	{1745, 2496},
	{1759, 2500},
	{1773, 2504},
	{1787, 2508},
	{1801, 2512},
	{1815, 2516},
	{1829, 2520},
	{1844, 2524},
	{1859, 2528},
	{1874, 2532},
	{1889, 2536},
	{1904, 2540},
	{1919, 2548},
	{1930, 2552},
	{1946, 2556},
	{2034, 32776, 22, 3755},
	{2047, 32784, 22, 2846},
	{2059, 32788, 16, 3777},
	{2091, 32796, 14, 3793},
	{47369, 33280, 1, 2900},
	{47387, 33284},
	{2136, 33296, 23, 2901},
	{2150, 33300, 28, 2924},
	{2167, 33304, 16, 2952},
	{2188, 33308, 28, 247},
	{2202, 33312, 32, 275},
	{2219, 33316, 13, 307},
	{2240, 33320, 9, 320},
	{2258, 33324, 1, 329},
	{2281, 33344, 2, 330},
	{2302, 33348},
	{2322, 33352, 1, 332},
	{2345, 33356, 11, 2969},
	{2363, 33436, 1, 342},
	{2927, 39160, 6, 2344},
	{3866, 41136, 12, 3807},
	{3898, 45060, 5, 3037},
	{3922, 45080},
	{3947, 45084, 3, 3042},
	{3971, 45088},
	{3992, 45092, 1, 498},
	{4013, 45096, 12, 2372},
	{4037, 45100, 10, 510},
	{4061, 45104},
	{4087, 45108},
	{4113, 45112},
	{4139, 45116},
	{4165, 45120},
	{4191, 45124},
	{4217, 45128},
	{4243, 45132},
	{4269, 45136},
	{4295, 45140},
	{4321, 45144},
	{4348, 45148},
	{4375, 45152},
	{4402, 45156},
	{4429, 45160},
	{4456, 45164},
	{4483, 45168},
	{4510, 45172},
	{4537, 45176},
	{4564, 45180},
	{4591, 45184},
	{4618, 45188},
	{4645, 45192},
	{4672, 45196},
	{4699, 45200},
	{4726, 45204},
	{4753, 45208},
	{4780, 45212},
	{4807, 45216},
	{4834, 45220},
	{4861, 45224},
	{4888, 45228},
	{4915, 45248, 8, 520},
	{4971, 45256, 1, 533},
	{4998, 45260, 1, 533},
	{5025, 45264, 1, 533},
	{5052, 45268, 1, 533},
	{6366, 45568},
	{6391, 45572, 9, 3045},
	{6415, 45576},
	{6447, 45580},
	{6479, 45584},
	{6503, 45588, 1, 498},
	{6527, 45596, 4, 583},
	{6551, 45600},
	{6572, 45604, 1, 498},
	{6593, 45608, 13, 587},
	{6617, 45612, 9, 600},
	{6641, 45616},
	{6667, 45620},
	{6693, 45624},
	{6719, 45628},
	{6745, 45632},
	{6771, 45636},
	{6797, 45640},
	{6823, 45644},
	{6849, 45648},
	{6875, 45652},
	{6901, 45656},
	{6928, 45660},
	{6955, 45664},
	{6982, 45668},
	{7009, 45672},
	{7036, 45676},
	{7063, 45680},
	{7090, 45684},
	{7117, 45688},
	{7144, 45692},
	{7171, 45696},
	{7198, 45700},
	{7225, 45704},
	{7252, 45708},
	{7279, 45712},
	{7306, 45716},
	{7333, 45720},
	{7360, 45724},
	{7387, 45728},
	{7414, 45732},
	{7441, 45736},
	{7468, 45740},
	{47405, 45744, 4, 3054},
	{47431, 45748, 2, 3058},
	{7495, 45760, 8, 520},
	{7555, 45768, 1, 533},
	{7584, 45772, 1, 533},
	{7613, 45776, 1, 533},
	{7642, 45780, 1, 533},
	{7722, 45856},
	{7743, 45860, 1, 498},
	{8261, 46080},
	{8286, 46084, 5, 3037},
	{8310, 46088},
	{8342, 46092},
	{8374, 46096},
	{8398, 46100, 1, 498},
	{8422, 46108, 4, 619},
	{8446, 46112},
	{8467, 46116, 1, 498},
	{8488, 46120, 12, 623},
	{8512, 46124, 9, 635},
	{8536, 46128},
	{8562, 46132},
	{8588, 46136},
	{8614, 46140},
	{8640, 46144},
	{8666, 46148},
	{8692, 46152},
	{8718, 46156},
	{8744, 46160},
	{8770, 46164},
	{8796, 46168},
	{8823, 46172},
	{8850, 46176},
	{8877, 46180},
	{8904, 46184},
	{8931, 46188},
	{8958, 46192},
	{8985, 46196},
	{9012, 46200},
	{9039, 46204},
	{9066, 46208},
	{9093, 46212},
	{9120, 46216},
	{9147, 46220},
	{9174, 46224},
	{9201, 46228},
	{9228, 46232},
	{9255, 46236},
	{9282, 46240},
	{9309, 46244},
	{9336, 46248},
	{9363, 46252},
	{9390, 46272, 8, 520},
	{9450, 46280, 1, 533},
	{9479, 46284, 1, 533},
	{9508, 46288, 1, 533},
	{9537, 46292, 1, 533},
	{9617, 46368},
	{9638, 46372, 1, 498},
	{10129, 47104, 15, 3060},
	{10156, 47108},
	{10170, 47112},
	{10184, 47116},
	{10198, 47120},
	{10214, 47124},
	{10230, 47128},
	{10246, 47132, 2, 666},
	{10267, 47136, 2, 666},
	{10288, 47140, 2, 666},
	{10309, 47144, 1, 668},
	{10337, 47148, 1, 669},
	{10362, 47152},
	{10377, 47156, 1, 670},
	{10392, 47160},
	{10421, 47164, 1, 670},
	{10450, 47168},
	{10483, 47172, 1, 670},
	{10516, 47176, 12, 671},
	{10534, 47180, 11, 683},
	{10552, 47184, 1, 694},
	{10565, 47188, 6, 695},
	{10589, 47192},
	{10616, 47196},
	{10643, 47200, 2, 3075},
	{10664, 47204},
	{10691, 47208},
	{10718, 47212},
	{10736, 47216},
	{10754, 47220},
	{10772, 47224, 1, 703},
	{10800, 47228, 4, 3077},
	{10822, 47232},
	{10842, 47236},
	{10865, 47240, 9, 709},
	{10882, 47248, 1, 533},
	{10903, 47252, 1, 533},
	{10924, 47256, 1, 533},
	{10945, 47260, 1, 533},
	{10966, 47264, 5, 3081},
	{10984, 47268, 1, 719},
	{11003, 47272},
	{47463, 47276, 2, 3086},
	{47494, 47280, 2, 3086},
	{47525, 47284, 2, 3086},
	{47556, 47288, 2, 3086},
	{47587, 47292, 1, 3088},
	{11025, 47296, 3, 720},
	{11042, 47300},
	{11071, 47304, 1, 723},
	{11100, 47308, 3, 720},
	{11118, 47360},
	{11138, 47364},
	{11158, 47368},
	{11178, 47372},
	{11198, 47376},
	{11218, 47380},
	{11238, 47384},
	{11258, 47388},
	{11278, 47392},
	{11298, 47396},
	{11318, 47400},
	{11339, 47404},
	{11360, 47408},
	{11381, 47412},
	{11402, 47416},
	{11423, 47420},
	{11444, 47604, 2, 724},
	{11468, 47608},
	{11489, 47612},
	{11505, 163840, 15, 3089},
	{11523, 163844, 10, 737},
	{11540, 163848, 7, 747},
	{11554, 163852, 22, 3104},
	{11573, 163856, 18, 3126},
	{11593, 163860},
	{11612, 163868, 2, 793},
	{11629, 163872},
	{11649, 163876},
	{11669, 163880, 1, 795},
	{11686, 163884},
	{11701, 163888, 2, 796},
	{11725, 163892, 2, 798},
	{11765, 163900, 8, 3144},
	{11783, 163904, 14, 811},
	{11793, 163908, 9, 825},
	{11809, 163912},
	{11824, 163916},
	{11845, 163920},
	{11861, 163924},
	{11883, 163928, 2, 834},
	{11901, 163932, 1, 836},
	{50995, 163936, 8, 3819},
	{11919, 163944, 1, 837},
	{11937, 163948, 1, 837},
	{11961, 163952, 1, 837},
	{11980, 163956, 1, 837},
	{12005, 163960, 1, 837},
	{12027, 163964, 13, 3152},
	{12051, 163968},
	{12067, 163972, 1, 847},
	{12086, 164328, 1, 848},
	{12107, 164332, 1, 848},
	{12128, 164336, 1, 848},
	{12149, 164340, 1, 848},
	{12170, 164344},
	{12188, 164348},
	{12206, 164352, 2, 849},
	{12226, 164356, 3, 851},
	{12250, 164360, 2, 854},
	{12274, 164364, 1, 856},
	{12294, 164368, 2, 851},
	{12314, 164372, 2, 854},
	{12334, 164376, 2, 851},
	{12354, 164380, 2, 854},
	{12374, 164384, 2, 851},
	{12394, 164388, 2, 854},
	{12414, 164392, 2, 851},
	{12434, 164396, 2, 854},
	{12454, 164400, 7, 857},
	{12469, 164404, 2, 864},
	{12498, 164408, 8, 866},
	{12513, 164412, 8, 874},
	{12528, 164416, 3, 851},
	{12553, 164420, 2, 854},
	{12578, 164424},
	{12596, 164428},
	{12614, 164432, 3, 851},
	{12639, 164436, 2, 854},
	{12664, 164440, 3, 851},
	{12689, 164444, 2, 854},
	{12714, 164448, 3, 851},
	{12739, 164452, 2, 854},
	{12764, 164456, 3, 851},
	{12789, 164460, 2, 854},
	{12814, 164464, 3, 851},
	{12839, 164468, 2, 854},
	{12864, 164472, 3, 851},
	{12889, 164476, 2, 854},
	{12914, 164480, 3, 851},
	{12939, 164484, 2, 854},
	{12964, 164488, 3, 851},
	{12989, 164492, 2, 854},
	{13014, 164496, 3, 851},
	{13039, 164500, 2, 854},
	{13064, 164504, 3, 851},
	{13089, 164508, 2, 854},
	{13114, 164512, 3, 851},
	{13140, 164516, 2, 854},
	{13166, 164520, 3, 851},
	{13192, 164524, 2, 854},
	{13218, 164528, 3, 851},
	{13244, 164532, 2, 854},
	{13270, 164536, 3, 851},
	{13296, 164540, 2, 854},
	{13322, 164544, 3, 851},
	{13348, 164548, 2, 854},
	{13374, 164552, 3, 851},
	{13400, 164556, 2, 854},
	{13426, 164560},
	{13445, 164564},
	{13464, 164568},
	{13483, 164572},
	{13502, 164576},
	{13521, 164580},
	{13540, 164584},
	{13559, 164588},
	{13578, 164592},
	{13597, 164596},
	{13616, 164600},
	{13635, 164604},
	{13654, 164608},
	{13673, 164612},
	{13692, 164616},
	{13711, 164620},
	{13730, 164624},
	{13749, 164628},
	{13768, 164632},
	{13787, 164636},
	{13806, 164640},
	{13826, 164644},
	{13846, 164648},
	{13866, 164652},
	{13886, 164656},
	{13906, 164660},
	{13926, 164664},
	{13946, 164668},
	{13966, 164672},
	{13986, 164676},
	{14006, 164680},
	{14026, 164684},
	{14046, 164688, 15, 882},
	{14066, 164692, 3, 897},
	{14088, 164696, 2, 900},
	{14116, 164700, 4, 3165},
	{14145, 164704, 1, 909},
	{14166, 164708, 1, 910},
	{14176, 164712, 1, 911},
	{43501, 164716},
	{43523, 164720},
	{47615, 164816, 5, 3169},
	{47639, 164820},
	{47668, 164824, 1, 1622},
	{47701, 164828, 2, 3174},
	{47733, 164836, 11, 3176},
	{47759, 164848},
	{47779, 164852, 2, 3187},
	{47803, 164856, 2, 3174},
	{14294, 164876},
	{14323, 164880, 7, 3189},
	{14348, 164884},
	{14361, 164888},
	{14376, 164892},
	{14390, 164896},
	{47826, 164900, 8, 3196},
	{14420, 164904, 4, 938},
	{14444, 164908, 6, 942},
	{14463, 164912, 4, 948},
	{14481, 164916, 4, 952},
	{14502, 164924},
	{14521, 164928},
	{14541, 164932},
	{14560, 164936},
	{14580, 164940},
	{14599, 164944},
	{14619, 164948},
	{14640, 164952},
	{14662, 164956},
	{14683, 164960},
	{14705, 164964},
	{14726, 164968},
	{14748, 164972},
	{14769, 164976},
	{14791, 164980},
	{14812, 164984},
	{14834, 164988},
	{14855, 164992},
	{14877, 164996},
	{14898, 165000},
	{14920, 165004},
	{14941, 165008},
	{14963, 165012},
	{14984, 165016},
	{15006, 165020},
	{15027, 165024},
	{15049, 165028},
	{15070, 165032},
	{15092, 165036},
	{15113, 165040},
	{15135, 165044},
	{15156, 165048},
	{15178, 165052},
	{15199, 165056},
	{15221, 165060},
	{15242, 165064},
	{15264, 165068},
	{15285, 165072},
	{15307, 165076},
	{15328, 165080},
	{15350, 165084},
	{15371, 165088},
	{15393, 165092},
	{15414, 165096},
	{15436, 165100},
	{15457, 165104},
	{15479, 165108},
	{15500, 165112},
	{15522, 165116},
	{15543, 165120},
	{15565, 165124},
	{15586, 165128},
	{15608, 165132},
	{15629, 165136},
	{15651, 165140},
	{15672, 165144},
	{15694, 165148},
	{15715, 165152},
	{15737, 165156},
	{15758, 165160},
	{15780, 165164},
	{15802, 165168},
	{15825, 165172},
	{15847, 165176},
	{15870, 165180},
	{15892, 165184},
	{15915, 165188},
	{15937, 165192},
	{15960, 165196},
	{15982, 165200},
	{16005, 165204},
	{16027, 165208},
	{16050, 165212},
	{16072, 165216},
	{16095, 165220},
	{16117, 165224},
	{16140, 165228},
	{16162, 165232},
	{16185, 165236},
	{16207, 165240},
	{16230, 165244},
	{16252, 165248},
	{16275, 165252},
	{16297, 165256},
	{16320, 165260},
	{16342, 165264},
	{16365, 165268},
	{16387, 165272},
	{16410, 165276},
	{16432, 165280},
	{16455, 165284},
	{16477, 165288},
	{16500, 165292},
	{16522, 165296},
	{16545, 165300},
	{16567, 165304},
	{16590, 165308},
	{16604, 165312},
	{16618, 165316},
	{16632, 165320},
	{16646, 165324},
	{16660, 165328},
	{16674, 165332},
	{16688, 165336},
	{16702, 165340},
	{16716, 165344},
	{16730, 165348},
	{16744, 165352},
	{16758, 165356},
	{16772, 165360},
	{16786, 165364},
	{16800, 165368},
	{16814, 165372},
	{16828, 165376},
	{16842, 165380},
	{16856, 165384},
	{16870, 165388},
	{16884, 165392},
	{16898, 165396},
	{16912, 165400},
	{16926, 165404},
	{47842, 165408, 2, 3204},
	{16949, 165444, 13, 3206},
	{16969, 165448, 13, 3206},
	{16989, 165452, 13, 3206},
	{17009, 165456, 13, 3206},
	{17029, 165460, 13, 3206},
	{17049, 165464, 13, 3206},
	{17069, 165468, 13, 3206},
	{17089, 165472, 13, 3206},
	{17109, 165476, 13, 3206},
	{17129, 165480, 13, 3206},
	{17149, 165484, 13, 3206},
	{17170, 165488, 13, 3206},
	{17191, 165492, 13, 3206},
	{17212, 165496, 13, 3206},
	{17233, 165500, 13, 3206},
	{17254, 165504, 13, 3206},
	{17275, 165508, 13, 3206},
	{17296, 165512, 13, 3206},
	{17317, 165516, 13, 3206},
	{17338, 165520, 13, 3206},
	{17359, 165524, 11, 3219},
	{17380, 165528, 11, 3219},
	{17401, 165532, 11, 3219},
	{17422, 165536, 11, 3219},
	{17443, 165540, 11, 3219},
	{17464, 165544, 11, 3219},
	{17485, 165548, 11, 3219},
	{17506, 165552, 11, 3219},
	{17527, 165556, 11, 3219},
	{17548, 165560, 11, 3219},
	{17569, 165564, 11, 3219},
	{17590, 165568, 11, 3219},
	{17611, 165572, 3, 3230},
	{17629, 165580, 16, 980},
	{17646, 165584, 16, 980},
	{17664, 165588, 7, 996},
	{17685, 165592, 7, 3233},
	{51022, 165596, 2, 3827},
	{17703, 165600, 7, 1009},
	{17718, 165608, 2, 3075},
	{47855, 165612},
	{47879, 165616, 1, 670},
	{17735, 165640, 1, 1016},
	{17757, 165644, 5, 1017},
	{17779, 165648, 1, 1022},
	{17799, 165652, 8, 1023},
	{43545, 165712, 8, 2482},
	{17821, 165716, 8, 3240},
	{17839, 165720, 8, 1039},
	{17860, 165724, 17, 1047},
	{17881, 165728, 6, 1064},
	{17899, 165732, 6, 1064},
	{17917, 165736, 6, 1064},
	{17935, 165740, 6, 1064},
	{17953, 165744, 6, 1064},
	{17971, 165748, 6, 1064},
	{17989, 165752, 6, 1064},
	{18007, 165756, 6, 1064},
	{18025, 165760, 9, 3248},
	{18043, 165764, 9, 3248},
	{18061, 165768, 9, 3248},
	{18079, 165772, 9, 3248},
	{18097, 165776, 9, 3248},
	{18115, 165780, 9, 3248},
	{18133, 165784, 9, 3248},
	{18151, 165788, 9, 3248},
	{18183, 165840, 1, 1079},
	{18198, 165844},
	{18216, 165848},
	{18234, 165852},
	{18251, 165856},
	{18272, 165860, 1, 1080},
	{18288, 165864},
	{18301, 165872, 6, 2498},
	{18335, 165880, 1, 1089},
	{18357, 165884, 1, 1090},
	{18384, 165888, 10, 1091},
	{18401, 165892, 12, 1101},
	{18409, 165896, 5, 3257},
	{18426, 165900, 18, 3262},
	{18444, 165904, 20, 1134},
	{18460, 165908, 16, 1154},
	{18479, 165912, 10, 1170},
	{18494, 165916, 29, 3280},
	{18512, 165920, 16, 1208},
	{18530, 165924, 3, 1224},
	{18554, 165928},
	{18579, 165932, 11, 1228},
	{18602, 165936, 6, 3829},
	{18653, 165944, 3, 2539},
	{18668, 165948, 5, 1250},
	{18698, 165952, 5, 1255},
	{18713, 165956},
	{43571, 165960, 6, 2542},
	{18731, 166400, 2, 1260},
	{18748, 166404, 2, 1262},
	{18767, 166408, 1, 1264},
	{18783, 166412, 4, 1265},
	{18836, 166424},
	{18859, 166428},
	{19085, 166472, 6, 2548},
	{19103, 166476, 24, 1317},
	{19121, 166480},
	{19265, 166512},
	{19276, 166516},
	{19289, 166520},
	{19306, 166524, 9, 2554},
	{19325, 166528},
	{19336, 166532, 3, 1358},
	{19355, 166536},
	{19377, 166540},
	{19399, 166544, 3, 3309},
	{19446, 166552, 4, 2563},
	{19537, 166572, 1, 1377},
	{19583, 166580, 1, 1378},
	{19612, 166588, 9, 1380},
	{19629, 166592, 4, 1389},
	{19656, 166596, 4, 1393},
	{19683, 166600, 4, 1397},
	{20018, 166696},
	{20049, 166700},
	{20092, 166704, 1, 1402},
	{20130, 166712, 1, 1403},
	{20150, 166732, 2, 1404},
	{20169, 166736, 5, 1406},
	{20191, 166740, 17, 3312},
	{20212, 166744, 3, 1430},
	{20319, 166764, 12, 3835},
	{20332, 166768, 6, 1445},
	{20373, 166776, 2, 1451},
	{20403, 166780},
	{20427, 166784},
	{20457, 166788},
	{20488, 166792},
	{20517, 166796},
	{20547, 166800, 3, 1453},
	{20636, 166868, 8, 1468},
	{20662, 166872, 8, 1476},
	{20688, 166876, 5, 1484},
	{20704, 166880, 8, 2597},
	{20720, 166884, 3, 1495},
	{20735, 166888},
	{20758, 166892},
	{20781, 166896},
	{20804, 166900},
	{20827, 166904, 8, 1498},
	{20861, 166908, 8, 1506},
	{20895, 166912, 8, 1514},
	{20929, 166916, 8, 1522},
	{20963, 166920, 8, 1498},
	{20997, 166924, 8, 1506},
	{21031, 166928, 8, 1514},
	{21065, 166932, 8, 1522},
	{21099, 166936, 8, 1498},
	{21133, 166940, 8, 1506},
	{21167, 166944, 8, 1514},
	{21201, 166948, 8, 1522},
	{21235, 166952, 8, 1498},
	{21269, 166956, 8, 1506},
	{21303, 166960, 8, 1514},
	{21337, 166964, 8, 1522},
	{21371, 166968, 2, 1530},
	{21395, 166972, 2, 1532},
	{21419, 166976, 5, 3340},
	{21440, 166980, 12, 3847},
	{21460, 166984, 2, 1550},
	{21480, 166988, 20, 1552},
	{21518, 166992, 6, 3357},
	{47903, 166996, 14, 3859},
	{51042, 167000, 1, 3873},
	{21587, 167008},
	{21634, 167020, 3, 1579},
	{21649, 167024, 10, 3373},
	{21664, 167028, 5, 3383},
	{47923, 167032, 17, 3388},
	{21823, 167060},
	{21842, 167068},
	{21889, 167080, 3, 1579},
	{21904, 167084, 10, 3373},
	{21919, 167088, 5, 3383},
	{47946, 167092, 17, 3388},
	{22078, 167120},
	{22097, 167128},
	{22144, 167140, 3, 1579},
	{22159, 167144, 10, 3373},
	{22174, 167148, 5, 3383},
	{47969, 167152, 17, 3388},
	{22333, 167180},
	{22352, 167188},
	{22399, 167200, 3, 1579},
	{22414, 167204, 10, 3373},
	{22429, 167208, 5, 3383},
	{47992, 167212, 17, 3388},
	{22588, 167240},
	{22607, 167248},
	{22654, 167260, 3, 1579},
	{22669, 167264, 10, 3373},
	{22684, 167268, 5, 3383},
	{48015, 167272, 17, 3388},
	{22843, 167300},
	{22862, 167308},
	{22909, 167320, 3, 1579},
	{22924, 167324, 10, 3373},
	{22939, 167328, 5, 3383},
	{48038, 167332, 17, 3388},
	{23098, 167360},
	{23117, 167368},
	{23164, 167380, 3, 1579},
	{23179, 167384, 10, 3373},
	{23194, 167388, 5, 3383},
	{48061, 167392, 17, 3388},
	{23353, 167420},
	{23372, 167428},
	{23419, 167440, 3, 1579},
	{23434, 167444, 10, 3373},
	{23449, 167448, 5, 3383},
	{48084, 167452, 17, 3388},
	{23608, 167480},
	{23627, 167488, 1, 1622},
	{23646, 167492, 1, 1622},
	{23665, 167496, 1, 1622},
	{23684, 167500, 1, 1622},
	{23703, 167504, 1, 1622},
	{23722, 167508, 1, 1622},
	{23741, 167512, 1, 1622},
	{23760, 167516, 1, 1622},
	{24179, 167584, 1, 1622},
	{24202, 167588, 1, 1622},
	{24225, 167592, 1, 1622},
	{24248, 167596, 1, 1622},
	{24271, 167600, 1, 1622},
	{24294, 167604, 1, 1622},
	{24317, 167608, 1, 1622},
	{24340, 167612, 1, 1622},
	{24363, 167616, 3, 1623},
	{24381, 167620, 3, 1623},
	{24399, 167624, 3, 1623},
	{24417, 167628, 3, 1623},
	{24435, 167632, 3, 1623},
	{24453, 167636, 3, 1623},
	{24471, 167640, 3, 1623},
	{24489, 167644, 3, 1623},
	{24507, 167648, 5, 3405},
	{24525, 167652, 5, 3405},
	{24543, 167656, 5, 3405},
	{24561, 167660, 5, 3405},
	{24579, 167664, 5, 3405},
	{24597, 167668, 5, 3405},
	{24615, 167672, 5, 3405},
	{24633, 167676, 5, 3405},
	{24651, 196608, 1, 1634},
	{24671, 196612, 1, 1635},
	{24691, 196616},
	{24711, 196620},
	{24731, 196624},
	{24752, 196628},
	{25289, 196704, 1, 1638},
	{25311, 196708, 1, 1639},
	{25333, 196712},
	{25356, 196716},
	{25379, 196720},
	{25402, 196724},
	{25425, 196728},
	{25448, 196732},
	{25471, 196736},
	{25495, 196740},
	{25519, 196744},
	{25543, 196748},
	{25567, 196752},
	{25591, 196756},
	{25615, 196760},
	{25639, 196764},
	{25663, 196768},
	{25685, 196772},
	{25707, 196776},
	{25728, 196780},
	{25749, 196784},
	{25773, 196788},
	{25797, 196792},
	{25821, 196796},
	{25845, 196800},
	{25869, 196804},
	{48107, 196808},
	{48131, 196812},
	{25953, 196852, 1, 1641},
	{26013, 196864},
	{26026, 196868},
	{26039, 196872},
	{26052, 196876},
	{26065, 196880},
	{26078, 196884},
	{26091, 196888},
	{26104, 196892},
	{43586, 196896, 5, 2647},
	{26140, 196908, 1, 670},
	{26159, 196912},
	{26177, 196916},
	{26204, 196920},
	{26257, 196936},
	{26280, 196940},
	{26303, 196944},
	{26331, 196948},
	{26359, 196952},
	{26387, 196956},
	{26415, 196960, 1, 1645},
	{26433, 196964, 6, 3410},
	{26451, 196968},
	{26466, 196972},
	{26490, 196976},
	{26514, 196980},
	{26533, 196984},
	{26552, 196988},
	{26576, 196992},
	{26600, 196996},
	{26624, 197000},
	{26648, 197028, 1, 1650},
	{26666, 197032, 7, 3416},
	{26684, 197036},
	{26702, 197040},
	{26720, 197044, 1, 1653},
	{26738, 197048, 5, 3423},
	{26756, 197052},
	{26774, 197056, 2, 2652},
	{26793, 197060, 5, 1658},
	{26812, 197072},
	{26836, 197076, 2, 2652},
	{26856, 197080, 5, 1658},
	{26876, 197084, 9, 3428},
	{26895, 197088, 9, 3428},
	{27009, 197120},
	{27028, 197124, 1, 1687},
	{27050, 197128},
	{27069, 197132, 1, 1688},
	{27091, 197136, 7, 1689},
	{27109, 197140},
	{27129, 197144, 1, 1687},
	{27152, 197148},
	{27172, 197152, 1, 1688},
	{27195, 197156, 7, 1689},
	{27214, 197160, 7, 1696},
	{27226, 197164, 2, 1703},
	{27260, 197172, 1, 1706},
	{27278, 197176, 6, 3437},
	{27298, 197180, 2, 330},
	{27315, 197184},
	{27331, 197188, 1, 1713},
	{27344, 197192, 1, 1714},
	{27358, 197196, 1, 1715},
	{27372, 197200, 1, 1716},
	{27394, 197204, 1, 1717},
	{27414, 197208, 1, 1718},
	{27436, 197212, 1, 1719},
	{27504, 197232, 2, 1720},
	{27526, 197236, 2, 1722},
	{27548, 197240, 2, 1720},
	{27571, 197244, 2, 1722},
	{27594, 197248, 2, 1720},
	{27616, 197252, 2, 1722},
	{43605, 197256},
	{43627, 197260},
	{48155, 197264},
	{48177, 197268},
	{48199, 197272},
	{48222, 197276},
	{27699, 197376, 1, 1725},
	{27716, 197380, 1, 1726},
	{27733, 197384, 1, 1727},
	{27908, 197424, 1, 1731},
	{27923, 197428, 1, 1732},
	{27938, 197432, 1, 1733},
	{27951, 197436, 1, 1734},
	{27966, 197440, 1, 1735},
	{27981, 197444, 1, 1736},
	{27994, 197448, 1, 1737},
	{28008, 197452, 1, 1738},
	{28022, 197456, 1, 1739},
	{28034, 197460, 6, 3443},
	{28057, 197464, 6, 3449},
	{28079, 197468, 1, 1747},
	{28099, 197472, 1, 1748},
	{28113, 197476, 1, 1749},
	{28127, 197480, 1, 1750},
	{28139, 197484, 1, 1751},
	{28223, 197552, 1, 1752},
	{28272, 197560, 1, 1753},
	{28292, 197568},
	{28318, 197572, 1, 1635},
	{28400, 197584},
	{28423, 197588, 1, 1635},
	{28449, 197592},
	{28471, 197596, 1, 1635},
	{28496, 197600},
	{28515, 197604, 1, 1635},
	{28537, 197608, 1, 1350},
	{28551, 197612},
	{28568, 197616, 1, 1635},
	{28588, 197620, 8, 1754},
	{28605, 197624, 13, 1762},
	{28622, 197628},
	{28639, 197632, 1, 1705},
	{28659, 197636},
	{28676, 197640, 1, 1670},
	{28696, 197644, 2, 1775},
	{28715, 197888, 8, 1777},
	{28736, 197892, 8, 1777},
	{28757, 198656, 6, 3874},
	{28810, 198920, 1, 3455},
	{28829, 198924, 2, 2664},
	{28976, 198948},
	{28992, 198952},
	{29007, 198956, 3, 3456},
	{29033, 198960},
	{29049, 198964},
	{29067, 198968, 1, 3459},
	{29084, 198972, 2, 2666},
	{29105, 198976},
	{29285, 199012},
	{29301, 199016},
	{29322, 199020, 8, 3460},
	{29330, 199024},
	{29344, 199028},
	{29358, 199032},
	{29372, 199036, 3, 1808},
	{29387, 199040, 2, 1811},
	{29399, 199044, 1, 837},
	{29421, 199048, 3, 1813},
	{43801, 199052, 2, 2668},
	{48245, 199056, 2, 3468},
	{48270, 199060, 1, 3470},
	{19244, 199064, 1, 3471},
	{29437, 199168, 1, 1816},
	{29462, 199172, 2, 1817},
	{29487, 199184, 2, 1819},
	{29513, 199188, 2, 1819},
	{29539, 199192, 2, 1819},
	{29565, 199212, 2, 1819},
	{29591, 199296, 2, 1821},
	{29619, 199300, 1, 1823},
	{29643, 199304, 1, 1824},
	{29667, 199308, 1, 1825},
	{29700, 199312, 1, 1825},
	{29728, 199328, 2, 1821},
	{29757, 199332, 1, 1823},
	{29782, 199336, 1, 1824},
	{29807, 199340, 1, 1825},
	{29841, 199344, 1, 1825},
	{29870, 199360, 2, 1821},
	{29894, 199364, 1, 1823},
	{29914, 199368, 1, 1824},
	{29934, 199372, 1, 1825},
	{29963, 199376, 1, 1825},
	{29987, 199936},
	{30014, 199940},
	{30041, 199944},
	{30068, 199948},
	{30095, 199952},
	{30122, 199956},
	{30149, 199960},
	{30176, 199964},
	{30203, 199968, 4, 2670},
	{30228, 200192},
	{30247, 200196, 1, 847},
	{30269, 200448},
	{30293, 200452, 1, 1835},
	{30316, 200456},
	{30340, 200460, 1, 1835},
	{30363, 200464},
	{30387, 200468, 1, 1835},
	{30410, 200472},
	{30434, 200476, 1, 1835},
	{30494, 200704},
	{30506, 200708},
	{30518, 200712},
	{30536, 200716},
	{30555, 200720},
	{30573, 200724},
	{30585, 200728},
	{30597, 200732},
	{30615, 200736},
	{30633, 200740},
	{30652, 200744, 4, 1836},
	{30666, 200748, 2, 1840},
	{30684, 200752, 2, 3472},
	{30698, 200756, 2, 3474},
	{30712, 200760, 2, 1846},
	{30729, 200764, 2, 1848},
	{30746, 200768},
	{30759, 200772, 2, 1850},
	{30771, 200776},
	{30785, 200780},
	{30801, 200784},
	{30815, 200788},
	{30831, 200792},
	{30846, 200796},
	{30863, 200800},
	{30878, 200804},
	{30895, 200808, 2, 1852},
	{30917, 200812, 9, 3476},
	{30934, 200816, 2, 1864},
	{30955, 200820, 2, 1866},
	{30967, 200824},
	{30982, 200828, 6, 1868},
	{30997, 200832, 2, 1874},
	{31011, 200836},
	{48297, 200840},
	{48326, 200844},
	{48355, 200848},
	{48384, 200852},
	{48413, 200856},
	{48422, 200860},
	{48431, 200864},
	{48440, 200868},
	{48449, 200872},
	{48479, 200876},
	{48509, 200880},
	{48540, 200884},
	{48571, 200888},
	{48601, 200892},
	{48631, 200896},
	{48662, 200900},
	{48693, 200904},
	{48723, 200908},
	{48753, 200912},
	{48784, 200916},
	{48815, 200920},
	{48845, 200924},
	{48875, 200928},
	{48906, 200932},
	{2911, 200960, 7, 3485},
	{48937, 200964, 13, 3492},
	{48955, 200968, 7, 3505},
	{48973, 200972, 3, 3512},
	{48993, 200976, 8, 3515},
	{49015, 200980, 8, 3523},
	{49037, 200984},
	{49061, 200988, 6, 3531},
	{31124, 212992},
	{31144, 212996},
	{31164, 213000},
	{31184, 213004},
	{31204, 213008},
	{31224, 213012},
	{31244, 213016},
	{31264, 213020},
	{31284, 213024},
	{31304, 213028},
	{31324, 213032},
	{31344, 213036},
	{31364, 213040},
	{31387, 213044},
	{31410, 213048},
	{31433, 213248},
	{31454, 213252},
	{31475, 213260},
	{31496, 213264},
	{31517, 213268},
	{31541, 213272},
	{31565, 213276},
	{31589, 213280},
	{43813, 213648},
	{43833, 213652},
	{43853, 213656},
	{43873, 213660},
	{43893, 213664},
	{43913, 213668},
	{43933, 213672},
	{43953, 213676},
	{43973, 213680},
	{43998, 213684},
	{44023, 213688},
	{44048, 213692},
	{44073, 213696},
	{44098, 213700},
	{44123, 213704},
	{44148, 213708},
	{44173, 213712},
	{44196, 213716},
	{44219, 213720},
	{44242, 213724},
	{44265, 213728},
	{44288, 213732},
	{44311, 213736},
	{44334, 213740},
	{32169, 214016},
	{32191, 214020, 1, 1876},
	{32213, 214024},
	{32235, 214028, 1, 1876},
	{32257, 214032},
	{32279, 214036, 1, 1876},
	{32301, 214040},
	{32323, 214044, 1, 1876},
	{32345, 214272},
	{32367, 214276},
	{32389, 214280},
	{32411, 214284},
	{32433, 214288},
	{32455, 214292},
	{32477, 214296},
	{32499, 214300},
	{32521, 214304},
	{32543, 214308},
	{32565, 214312},
	{32587, 214316},
	{32609, 214320},
	{32631, 214324},
	{32653, 214328},
	{32675, 214332},
	{32697, 214528},
	{32717, 214532},
	{32737, 214536},
	{32757, 214540},
	{32777, 214544},
	{32797, 214548},
	{32817, 214552},
	{32837, 214556},
	{32857, 214560},
	{32877, 214564},
	{32897, 214568},
	{32917, 214572},
	{31265, 214576},
	{31245, 214580},
	{31225, 214584},
	{31205, 214588},
	{49229, 214592},
	{49248, 214596},
	{49267, 214600},
	{49286, 214604},
	{32937, 214784},
	{32975, 214792},
	{33013, 214800},
	{33051, 214808},
	{33089, 214816},
	{33127, 214824},
	{33165, 214832},
	{33203, 214840},
	{49305, 214928},
	{49325, 214932},
	{49345, 214936},
	{49365, 214940},
	{49385, 214944},
	{49405, 214948},
	{49425, 214952},
	{49445, 214956},
	{49465, 214960},
	{49485, 214964},
	{49505, 214968},
	{49525, 214972},
	{49545, 214976},
	{49565, 214980},
	{49585, 214984},
	{49605, 214988},
	{33557, 215296},
	{33576, 215300},
	{33595, 215304},
	{33614, 215308},
	{33633, 215312},
	{33652, 215316},
	{33671, 215320},
	{33690, 215324},
	{33709, 215424},
	{33730, 215428},
	{44357, 215432},
	{44377, 215436, 2, 1877},
	{33751, 215552},
	{33771, 215556},
	{33791, 215560},
	{33811, 215564},
	{33831, 215568},
	{33851, 215572},
	{33871, 215576},
	{33891, 215580},
	{33911, 215808},
	{33930, 215812},
	{33949, 215816},
	{33968, 215820},
	{33987, 216064},
	{34006, 216068},
	{34025, 216072},
	{34044, 216076},
	{34063, 216320},
	{34083, 216324},
	{34103, 216328},
	{34123, 216332},
	{34143, 216336},
	{34163, 216340},
	{34183, 216344},
	{34203, 216348},
	{49625, 216352, 12, 3537},
	{49648, 216356, 1, 3549},
	{49672, 216360, 13, 3550},
	{34223, 216576},
	{34244, 216580},
	{34265, 216584},
	{34286, 216588},
	{34307, 216592},
	{34328, 216596},
	{34349, 216600},
	{34370, 216604},
	{34391, 216640},
	{34412, 216644},
	{34433, 216648},
	{34454, 216652},
	{34475, 216656},
	{34496, 216660},
	{34517, 216664},
	{34538, 216668},
	{34559, 216704},
	{34580, 216708},
	{34601, 216712},
	{34622, 216716},
	{34643, 216720},
	{34664, 216724},
	{34685, 216728},
	{34706, 216732},
	{34727, 216832},
	{34747, 216836},
	{34767, 216840},
	{34787, 216844},
	{34807, 216848},
	{34827, 216852},
	{34847, 216856},
	{34867, 216860},
	{35055, 217112},
	{35074, 217116},
	{35093, 217120},
	{35112, 217124},
	{35131, 217128},
	{35150, 217132},
	{35169, 217136},
	{35188, 217140},
	{35207, 217344},
	{35226, 217348},
	{35245, 217352},
	{35264, 217356},
	{35283, 217360},
	{35302, 217364},
	{35321, 217368},
	{35340, 217372},
	{35359, 217600},
	{35379, 217604},
	{35399, 217608},
	{35419, 217612},
	{35439, 217856},
	{35459, 217860},
	{35479, 217864},
	{35499, 217868},
	{35519, 217872},
	{35539, 217876},
	{35559, 217880},
	{35579, 217884},
	{35701, 217984},
	{35726, 217988},
	{35751, 217992},
	{35776, 217996},
	{35649, 218000},
	{35675, 218004, 2, 1877},
	{44397, 218008},
	{44420, 218012, 2, 1877},
	{35801, 218064},
	{35827, 218068},
	{35599, 218080},
	{35624, 218084, 2, 1877},
	{51075, 218088},
	{51098, 218092, 2, 1877},
	{35941, 218240},
	{35961, 218244},
	{35981, 218248},
	{36001, 218252},
	{36021, 218624},
	{36043, 218628},
	{36065, 218632},
	{36087, 218636},
	{36109, 218640},
	{36131, 218644},
	{36153, 218648},
	{36175, 218652},
	{36197, 218656},
	{36219, 218660},
	{36241, 218664},
	{36263, 218668},
	{36285, 218672},
	{36307, 218676},
	{36329, 218680},
	{36351, 218684},
	{35853, 218752},
	{35875, 218756},
	{35897, 218760},
	{35919, 218764},
	{49698, 218768},
	{49720, 218772},
	{49742, 218776},
	{49764, 218780},
	{36373, 218880},
	{36394, 218884},
	{36415, 218888},
	{36436, 218892},
	{36457, 218896},
	{36478, 218900},
	{36499, 218904},
	{36520, 218908},
	{49786, 218944},
	{49807, 218948},
	{49828, 218952},
	{49849, 218956},
	{49870, 218960},
	{49891, 218964},
	{49912, 218968},
	{49933, 218972},
	{36541, 219136},
	{36561, 219140},
	{36581, 219144},
	{36601, 219148},
	{36621, 219152},
	{36641, 219156},
	{36661, 219160},
	{36681, 219164},
	{44481, 219520},
	{44510, 219524, 2, 1877},
	{44539, 219528},
	{44561, 219532},
	{44583, 219536},
	{44605, 219540},
	{36741, 221184, 3, 3563},
	{36765, 221188, 4, 1884},
	{36790, 221192, 5, 1879},
	{36814, 221196, 3, 3563},
	{36838, 221200, 4, 1884},
	{36863, 221204, 3, 3563},
	{36887, 221208, 4, 1884},
	{36912, 221212, 5, 1879},
	{36936, 221216, 4, 1888},
	{36952, 221220, 5, 1879},
	{36976, 221224, 3, 1892},
	{37010, 221228, 3, 1895},
	{37044, 221232, 3, 1898},
	{37069, 221236, 3, 1901},
	{37094, 221240, 3, 1898},
	{49954, 221244, 3, 1895},
	{37119, 221248},
	{37134, 221252, 1, 1825},
	{37157, 221256},
	{37180, 221260},
	{37198, 221264, 2, 1904},
	{37216, 221268, 4, 1906},
	{37236, 221440, 20, 1910},
	{37261, 221444, 20, 1910},
	{37286, 221448, 17, 3566},
	{37314, 221452, 17, 3566},
	{37398, 221492, 9, 3584},
	{37426, 221496, 9, 3584},
	{45065, 221840, 5, 3593},
	{45089, 221844, 4, 1969},
	{45114, 221848, 5, 3593},
	{45138, 221852, 4, 1969},
	{45163, 221856, 5, 3593},
	{45187, 221860, 4, 1969},
	{45212, 221864, 5, 3593},
	{45236, 221868, 4, 1969},
	{45261, 221872, 5, 3593},
	{45290, 221876, 4, 1969},
	{45320, 221880, 5, 3593},
	{45349, 221884, 4, 1969},
	{45379, 221888, 5, 3593},
	{45408, 221892, 4, 1969},
	{45438, 221896, 5, 3593},
	{45467, 221900, 4, 1969},
	{45497, 221904, 5, 3593},
	{45524, 221908, 4, 1969},
	{45552, 221912, 5, 3593},
	{45579, 221916, 4, 1969},
	{45607, 221920, 5, 3593},
	{45634, 221924, 4, 1969},
	{45662, 221928, 5, 3593},
	{45689, 221932, 4, 1969},
	{37828, 222208, 5, 1964},
	{37854, 222212, 4, 1969},
	{37881, 222216, 5, 1964},
	{37907, 222220, 4, 1969},
	{37934, 222224, 5, 1964},
	{37960, 222228, 4, 1969},
	{37987, 222232, 5, 1964},
	{38013, 222236, 4, 1969},
	{38040, 222464, 5, 1964},
	{38066, 222468, 4, 1969},
	{38093, 222472, 1, 1879},
	{38119, 222476, 1, 1879},
	{38145, 222480, 1, 1879},
	{38171, 222484, 1, 1879},
	{38197, 222488, 1, 1879},
	{38223, 222492, 1, 1879},
	{38249, 222496, 1, 1879},
	{38275, 222720, 5, 1964},
	{38299, 222724, 5, 1964},
	{38323, 222728, 5, 1964},
	{38347, 222732, 5, 1964},
	{38371, 222736, 4, 1969},
	{38396, 222740, 4, 1969},
	{38421, 222744, 4, 1969},
	{38446, 222748, 4, 1969},
	{38471, 222752, 1, 1879},
	{38495, 222756, 1, 1879},
	{38519, 222760, 8, 1973},
	{36953, 222768, 5, 1964},
	{36815, 222772, 5, 1964},
	{50072, 222776, 5, 1964},
	{50095, 222780, 5, 1964},
	{36839, 222784, 4, 1969},
	{50118, 222788, 4, 1969},
	{50142, 222792, 4, 1969},
	{50166, 222796, 4, 1969},
	{38540, 222976, 3, 2686},
	{38563, 222980, 3, 2686},
	{38586, 222984, 3, 2686},
	{38609, 222988, 3, 2686},
	{38632, 222992, 3, 2686},
	{38655, 222996, 3, 2686},
	{38678, 223000, 3, 2686},
	{38701, 223004, 3, 2686},
	{38724, 223008, 3, 2686},
	{38747, 223012, 3, 2686},
	{38770, 223016, 3, 2686},
	{38794, 223020, 3, 2686},
	{38818, 223024, 3, 2686},
	{38842, 223028, 3, 2686},
	{38866, 223032, 3, 2686},
	{38890, 223036, 3, 2686},
	{50190, 223040, 3, 2686},
	{50214, 223044, 3, 2686},
	{50238, 223048, 3, 2686},
	{50262, 223052, 3, 2686},
	{50286, 223056, 3, 2686},
	{50310, 223060, 3, 2686},
	{50334, 223064, 3, 2686},
	{50358, 223068, 3, 2686},
	{50382, 223072, 10, 3598},
	{50403, 223080, 2, 3608},
	{50425, 223084, 1, 3610},
	{38914, 223104, 10, 3598},
	{38934, 223112, 2, 3608},
	{2386, 223136},
	{2412, 223140, 2, 343},
	{2438, 223144},
	{2464, 223148, 2, 343},
	{2559, 223152, 18, 3611},
	{2511, 223156, 5, 3629},
	{2532, 223160, 7, 3634},
	{2490, 223164, 2, 345},
	{2580, 223184, 5, 3641},
	{43456, 223188, 6, 3646},
	{2632, 223192},
	{2662, 223196},
	{2694, 223200},
	{2725, 223204},
	{2603, 223208},
	{38955, 223232, 5, 1964},
	{38980, 223236, 4, 1969},
	{39006, 223240, 8, 1995},
	{45717, 223244, 5, 2147},
	{45739, 223248, 5, 2147},
	{45761, 223252, 4, 3880},
	{39029, 223488, 5, 1964},
	{39052, 223492, 5, 1964},
	{39075, 223496, 3, 2020},
	{39098, 223500, 3, 2020},
	{39121, 223504, 4, 1969},
	{39145, 223508, 4, 1969},
	{39169, 223744, 5, 1964},
	{39193, 223748, 5, 1964},
	{39217, 223752, 5, 1964},
	{39241, 223756, 5, 1964},
	{39265, 223760, 4, 1969},
	{45788, 223764, 4, 1969},
	{45813, 223768, 4, 1969},
	{45838, 223772, 4, 1969},
	{39290, 224000, 5, 1964},
	{39313, 224004, 4, 1969},
	{39337, 224008, 3, 2020},
	{39360, 224256, 5, 1964},
	{39383, 224260, 4, 1969},
	{39407, 224264, 3, 2020},
	{39430, 224512, 5, 1964},
	{39454, 224516, 4, 1969},
	{39479, 224520, 5, 1964},
	{39503, 224524, 4, 1969},
	{39528, 224528, 3, 2020},
	{39552, 224532, 3, 2020},
	{39576, 224768, 5, 1964},
	{39601, 224772, 4, 1958},
	{39627, 224776, 5, 1964},
	{39652, 224780, 4, 1958},
	{39678, 224784, 3, 2020},
	{39703, 224788, 3, 2020},
	{39728, 224832, 5, 1964},
	{39753, 224836, 4, 1958},
	{39779, 224840, 5, 1964},
	{39804, 224844, 4, 1958},
	{39830, 224848, 3, 2020},
	{39855, 224852, 3, 2020},
	{39880, 224896, 5, 1964},
	{39905, 224900, 4, 1958},
	{39931, 224904, 3, 2020},
	{39956, 224908, 3, 2020},
	{39981, 224912, 3, 2020},
	{40006, 225024, 5, 1964},
	{40030, 225028, 4, 1958},
	{40055, 225032, 3, 2020},
	{40079, 225036, 3, 2020},
	{40103, 225040, 3, 2020},
	{40253, 225280, 12, 2023},
	{40275, 225284, 5, 1964},
	{40298, 225288, 4, 1969},
	{40322, 225292, 2, 3652},
	{40345, 225296, 2, 3652},
	{40368, 225300, 2, 3652},
	{40391, 225536, 5, 1964},
	{40414, 225540, 4, 1969},
	{40438, 225544, 5, 1964},
	{40461, 225548, 4, 1969},
	{40485, 225552, 5, 1964},
	{40508, 225560, 5, 1964},
	{40531, 225792, 5, 3654},
	{40552, 225796},
	{40581, 225800, 2, 2050},
	{40610, 225804},
	{41067, 225808, 2, 2077},
	{40665, 225812},
	{40684, 225816, 2, 2059},
	{40636, 225820, 3, 3659},
	{40756, 225824, 1, 3662},
	{40783, 225828, 2, 3663},
	{40710, 225832, 1, 3662},
	{40733, 225836, 2, 3663},
	{41086, 225864, 2, 2079},
	{41113, 225868},
	{46053, 225872, 2, 2079},
	{46084, 225876},
	{41140, 225880, 2, 2081},
	{41167, 225884, 2, 2083},
	{46115, 225888, 4, 2753},
	{41194, 225892, 18, 3665},
	{41215, 225896, 9, 2723},
	{41234, 225900, 12, 3683},
	{41253, 225904, 1, 2111},
	{41277, 225908, 1, 2113},
	{41309, 225912, 2, 2115},
	{46186, 225916, 3, 2757},
	{50448, 225928, 2, 3705},
	{50462, 225932, 10, 3707},
	{45923, 225936},
	{45896, 225940},
	{50477, 225972, 1, 3717},
	{50490, 225976},
	{50515, 225980, 1, 3718},
	{50540, 225984, 1, 3719},
	{50560, 225988},
	{50582, 225992, 2, 3720},
	{50602, 225996},
	{50630, 226000, 1, 3718},
	{50658, 226004, 1, 3719},
	{50681, 226008},
	{50706, 226012, 2, 3720},
	{50729, 226016, 1, 3722},
	{50746, 226020, 9, 3723},
	{50767, 226044},
	{41446, 226048, 2, 2126},
	{41463, 226052, 1, 2128},
	{41487, 226056, 1, 2128},
	{41701, 226304, 5, 1964},
	{41725, 226308, 4, 1969},
	{41750, 226312, 2, 3652},
	{41774, 226316, 5, 1964},
	{41798, 226320, 4, 1969},
	{41823, 226324, 2, 3652},
	{41847, 226328, 10, 2137},
	{42212, 226432, 5, 1964},
	{42241, 226436, 5, 1964},
	{42270, 226440, 4, 1969},
	{42300, 226444, 4, 1969},
	{42330, 226448, 8, 1995},
	{42357, 226452, 8, 1995},
	{41955, 226496, 5, 2147},
	{41983, 226500, 5, 2147},
	{42011, 226504, 5, 2147},
	{42039, 226508, 5, 2147},
	{42067, 226512, 5, 2147},
	{42095, 226516, 5, 2147},
	{42123, 226520, 5, 2147},
	{42151, 226524, 5, 2147},
	{42179, 226528, 4, 3880},
	{46227, 226532, 5, 2147},
	{46252, 226536, 5, 2147},
	{46277, 226540, 5, 2147},
	{46302, 226544, 5, 2147},
	{46327, 226548, 4, 3880},
	{42384, 226560, 5, 3593},
	{42414, 226564, 4, 1969},
	{42445, 226568, 8, 1995},
	{41869, 226576, 5, 2147},
	{41896, 226580, 5, 2147},
	{41923, 226584, 4, 3880},
	{51121, 226600, 5, 2147},
	{51146, 226604, 5, 2147},
	{51171, 226608, 5, 2147},
	{51196, 226612, 5, 2147},
	{51221, 226616, 4, 3880},
	{42473, 226688, 5, 1964},
	{42497, 226692, 4, 1969},
	{42522, 226696, 3, 2020},
	{42598, 226816, 5, 1964},
	{42624, 226820, 4, 1969},
	{42651, 226824, 5, 1964},
	{42677, 226828, 5, 1964},
	{42703, 226832, 5, 1964},
	{42729, 226836, 1, 1879},
	{42755, 226840, 1, 1879},
	{42781, 226844, 1, 1879},
	{42807, 226848, 1, 1879},
	{42833, 226880, 4, 1969},
	{42860, 226884, 4, 1969},
	{42887, 226888, 4, 1969},
	{42546, 226944, 2, 2161},
	{42572, 226948, 2, 2161},
	{50781, 226952, 2, 2161},
	{50807, 226956, 2, 2161},
	{42914, 227072, 5, 1964},
	{42939, 227076, 4, 1958},
	{42965, 227080, 3, 2020},
	{42990, 227084, 3, 2020},
	{43015, 227088, 3, 2020},
	{50833, 227136, 5, 1964},
	{50858, 227140, 4, 1958},
	{50884, 227144, 3, 2020},
	{50909, 227148, 3, 2020},
	{50934, 227152, 3, 2020},
	{43040, 227200, 5, 1964},
	{43064, 227204, 4, 1958},
	{43089, 227208, 3, 2020},
	{43113, 227212, 3, 2020},
	{43137, 227216, 3, 2020},
	{46425, 227456, 5, 2147},
	{46456, 227460, 5, 2147},
	{46487, 227464, 4, 3880},
	{46523, 227468, 1, 2760},
	{46547, 227472, 5, 1964},
	{46573, 227476, 4, 1969},
	{46600, 227480, 5, 1964},
	{46626, 227484, 4, 1969},
};

static const struct si_reg gfx12_reg_table[] = {
	{43369, 40, 1, 2218},
	{43384, 44, 1, 2218},
	{1390, 1028, 5, 3884},
	{1403, 1032, 20, 3889},
	{51251, 1040, 15, 3909},
	{1455, 1044, 2, 2808},
	{1473, 1048, 3, 3924},
	{1491, 1052, 6, 3927},
	{1551, 1076, 2, 78},
	{1567, 1080},
	{51270, 1092, 11, 3933},
	{51293, 1096, 9, 3944},
	{51316, 1100, 10, 3953},
	{51334, 1104},
	{51358, 1108},
	{1584, 1116, 6, 2814},
	{1599, 1120, 6, 85},
	{1634, 1128, 1, 94},
	{1673, 1136, 4, 3963},
	{51382, 1148, 4, 3967},
	{51405, 1152, 4, 3971},
	{1506, 1280},
	{1520, 1284, 1, 70},
	{1689, 2480},
	{1703, 2484},
	{1717, 2488},
	{1731, 2492},
	{1745, 2496},
	{1759, 2500},
	{1773, 2504},
	{1787, 2508},
	{1801, 2512},
	{1815, 2516},
	{1829, 2520},
	{1844, 2524},
	{1859, 2528},
	{1874, 2532},
	{1889, 2536},
	{1904, 2540},
	{1919, 2548},
	{1930, 2552},
	{1946, 2556},
	{2034, 32776, 19, 3975},
	{2047, 32784, 21, 3994},
	{2059, 32788, 16, 4015},
	{2075, 32792, 16, 4015},
	{2091, 32796, 11, 4031},
	{2104, 32824, 16, 4015},
	{2120, 32828, 16, 4015},
	{47369, 33280, 1, 2900},
	{47387, 33284},
	{51428, 33288, 1, 2900},
	{2136, 33296, 23, 2901},
	{2150, 33300, 26, 4042},
	{2167, 33304, 16, 2952},
	{2188, 33308, 27, 4068},
	{2202, 33312, 30, 4095},
	{2219, 33316, 13, 307},
	{2240, 33320, 17, 4125},
	{2258, 33324, 1, 329},
	{43429, 33328, 3, 4142},
	{51446, 33332, 1, 4145},
	{2281, 33344, 2, 330},
	{2302, 33348},
	{2322, 33352, 1, 332},
	{2345, 33356, 12, 4146},
	{2363, 33436, 1, 342},
	{2767, 36608},
	{2785, 36612, 3, 2980},
	{2803, 36616},
	{2821, 36620, 13, 4158},
	{2839, 36656, 14, 397},
	{2857, 36660, 3, 4171},
	{2875, 36664, 8, 4174},
	{2893, 36668, 3, 4182},
	{2927, 39160, 6, 4185},
	{3722, 40960},
	{3740, 40964, 5, 4191},
	{3758, 40968, 2, 4196},
	{3776, 40972, 9, 4198},
	{3794, 40976, 3, 4207},
	{3812, 40980, 5, 4210},
	{3830, 40984, 7, 4215},
	{3848, 40988},
	{51476, 41152, 12, 4222},
	{51513, 41156, 1, 4234},
	{3922, 45076},
	{3947, 45080, 1, 494},
	{3898, 45084, 4, 4235},
	{3971, 45088},
	{3992, 45092, 1, 498},
	{4013, 45096, 13, 4239},
	{4037, 45100, 10, 510},
	{4061, 45104},
	{4087, 45108},
	{4113, 45112},
	{4139, 45116},
	{4165, 45120},
	{4191, 45124},
	{4217, 45128},
	{4243, 45132},
	{4269, 45136},
	{4295, 45140},
	{4321, 45144},
	{4348, 45148},
	{4375, 45152},
	{4402, 45156},
	{4429, 45160},
	{4456, 45164},
	{4483, 45168},
	{4510, 45172},
	{4537, 45176},
	{4564, 45180},
	{4591, 45184},
	{4618, 45188},
	{4645, 45192},
	{4672, 45196},
	{4699, 45200},
	{4726, 45204},
	{4753, 45208},
	{4780, 45212},
	{4807, 45216},
	{4834, 45220},
	{4861, 45224},
	{4888, 45228},
	{4915, 45248, 8, 520},
	{51550, 45252, 5, 4252},
	{4971, 45256, 1, 533},
	{4998, 45260, 1, 533},
	{5025, 45264, 1, 533},
	{5052, 45268, 1, 533},
	{6366, 45568},
	{6415, 45576},
	{6447, 45580},
	{6551, 45584},
	{6572, 45588},
	{7743, 45592, 1, 498},
	{6527, 45596, 4, 583},
	{6391, 45600, 8, 4257},
	{7722, 45604},
	{6593, 45608, 14, 4265},
	{6617, 45612, 9, 600},
	{6641, 45616},
	{6667, 45620},
	{6693, 45624},
	{6719, 45628},
	{6745, 45632},
	{6771, 45636},
	{6797, 45640},
	{6823, 45644},
	{6849, 45648},
	{6875, 45652},
	{6901, 45656},
	{6928, 45660},
	{6955, 45664},
	{6982, 45668},
	{7009, 45672},
	{7036, 45676},
	{7063, 45680},
	{7090, 45684},
	{7117, 45688},
	{7144, 45692},
	{7171, 45696},
	{7198, 45700},
	{7225, 45704},
	{7252, 45708},
	{7279, 45712},
	{7306, 45716},
	{7333, 45720},
	{7360, 45724},
	{7387, 45728},
	{7414, 45732},
	{7441, 45736},
	{7468, 45740},
	{47405, 45744, 4, 3054},
	{47431, 45748, 2, 3058},
	{51578, 45752, 2, 4279},
	{7495, 45760, 8, 520},
	{51605, 45764, 5, 4252},
	{7555, 45768, 1, 533},
	{7584, 45772, 1, 533},
	{7613, 45776, 1, 533},
	{7642, 45780, 1, 533},
	{8261, 46080},
	{8310, 46088},
	{8342, 46092},
	{8446, 46096},
	{8467, 46100},
	{9638, 46104, 1, 498},
	{8422, 46108, 4, 619},
	{8286, 46112, 5, 4281},
	{9617, 46116},
	{8488, 46120, 13, 4286},
	{8512, 46124, 9, 635},
	{8536, 46128},
	{8562, 46132},
	{8588, 46136},
	{8614, 46140},
	{8640, 46144},
	{8666, 46148},
	{8692, 46152},
	{8718, 46156},
	{8744, 46160},
	{8770, 46164},
	{8796, 46168},
	{8823, 46172},
	{8850, 46176},
	{8877, 46180},
	{8904, 46184},
	{8931, 46188},
	{8958, 46192},
	{8985, 46196},
	{9012, 46200},
	{9039, 46204},
	{9066, 46208},
	{9093, 46212},
	{9120, 46216},
	{9147, 46220},
	{9174, 46224},
	{9201, 46228},
	{9228, 46232},
	{9255, 46236},
	{9282, 46240},
	{9309, 46244},
	{9336, 46248},
	{9363, 46252},
	{9390, 46272, 8, 520},
	{9450, 46280, 1, 533},
	{9479, 46284, 1, 533},
	{9508, 46288, 1, 533},
	{9537, 46292, 1, 533},
	{10129, 47104, 17, 4299},
	{10156, 47108},
	{10170, 47112},
	{10184, 47116},
	{10198, 47120},
	{10214, 47124},
	{10230, 47128},
	{10246, 47132, 3, 4316},
	{10267, 47136, 3, 4319},
	{10288, 47140, 2, 666},
	{10309, 47144, 1, 668},
	{10337, 47148, 1, 669},
	{10362, 47152},
	{10377, 47156, 1, 670},
	{10392, 47160},
	{10421, 47164, 1, 670},
	{10450, 47168},
	{10483, 47172, 1, 670},
	{10516, 47176, 14, 4322},
	{10534, 47180, 12, 4336},
	{10552, 47184, 1, 694},
	{10565, 47188, 6, 695},
	{10589, 47192},
	{10616, 47196},
	{10643, 47200, 2, 4348},
	{10664, 47204},
	{10691, 47208},
	{10718, 47212},
	{10736, 47216},
	{10754, 47220},
	{10772, 47224, 1, 703},
	{10800, 47228, 3, 4350},
	{10822, 47232},
	{10842, 47236},
	{10865, 47240, 9, 709},
	{51636, 47244, 2, 3086},
	{10882, 47248, 1, 533},
	{10903, 47252, 1, 533},
	{10924, 47256, 1, 533},
	{10945, 47260, 1, 533},
	{10966, 47264, 4, 4353},
	{10984, 47268, 1, 719},
	{11003, 47272},
	{47463, 47276, 2, 3086},
	{47494, 47280, 2, 3086},
	{47525, 47284, 2, 3086},
	{47556, 47288, 2, 3086},
	{47587, 47292, 3, 4357},
	{11025, 47296, 3, 720},
	{11042, 47300},
	{11071, 47304, 1, 723},
	{11100, 47308, 3, 720},
	{51667, 47316},
	{51691, 47320},
	{51715, 47324},
	{11118, 47360},
	{11138, 47364},
	{11158, 47368},
	{11178, 47372},
	{11198, 47376},
	{11218, 47380},
	{11238, 47384},
	{11258, 47388},
	{11278, 47392},
	{11298, 47396},
	{11318, 47400},
	{11339, 47404},
	{11360, 47408},
	{11381, 47412},
	{11402, 47416},
	{11423, 47420},
	{11444, 47604, 1, 4360},
	{11468, 47608},
	{11489, 47612},
	{11505, 163840, 14, 4361},
	{11540, 163844, 2, 4375},
	{51739, 163848, 3, 4377},
	{11554, 163852, 20, 4380},
	{11573, 163856, 16, 4400},
	{11612, 163860, 2, 4416},
	{11783, 163864, 13, 4418},
	{11793, 163868, 9, 4431},
	{11809, 163872},
	{11919, 163876, 1, 837},
	{11845, 163880},
	{11961, 163884, 1, 837},
	{11824, 163888},
	{11937, 163892, 1, 837},
	{11861, 163896},
	{11980, 163900, 1, 837},
	{51754, 163904, 5, 4440},
	{51779, 163912, 5, 4445},
	{11629, 163920},
	{11649, 163924},
	{11523, 163936, 9, 4450},
	{51795, 163940, 1, 4459},
	{50995, 163944, 8, 3819},
	{18426, 163948, 18, 3262},
	{18384, 163952, 10, 4460},
	{14444, 163956, 6, 942},
	{18401, 163960, 11, 4470},
	{20332, 163964, 6, 1445},
	{12051, 163968},
	{12067, 163972, 1, 847},
	{51815, 163976, 2, 4481},
	{51830, 163980, 2, 4483},
	{51847, 163984, 2, 4485},
	{51868, 163988, 2, 4487},
	{51890, 164088, 6, 4489},
	{51906, 164092, 3, 4495},
	{51923, 164096, 2, 796},
	{51940, 164100, 2, 798},
	{51957, 164104, 2, 796},
	{51974, 164108, 2, 798},
	{51991, 164112, 2, 796},
	{52008, 164116, 2, 798},
	{52025, 164120, 2, 796},
	{52042, 164124, 2, 798},
	{52059, 164128, 2, 796},
	{52076, 164132, 2, 798},
	{52093, 164136, 2, 796},
	{52110, 164140, 2, 798},
	{52127, 164144, 2, 796},
	{52144, 164148, 2, 798},
	{52161, 164152, 2, 796},
	{52178, 164156, 2, 798},
	{52195, 164160, 2, 796},
	{52212, 164164, 2, 798},
	{52229, 164168, 2, 796},
	{52246, 164172, 2, 798},
	{52263, 164176, 2, 796},
	{52281, 164180, 2, 798},
	{52299, 164184, 2, 796},
	{52317, 164188, 2, 798},
	{52335, 164192, 2, 796},
	{52353, 164196, 2, 798},
	{52371, 164200, 2, 796},
	{52389, 164204, 2, 798},
	{52407, 164208, 2, 796},
	{52425, 164212, 2, 798},
	{52443, 164216, 2, 796},
	{52461, 164220, 2, 798},
	{11701, 164224, 2, 796},
	{11725, 164228, 2, 798},
	{12086, 164328, 1, 848},
	{12107, 164332, 1, 848},
	{12128, 164336, 1, 848},
	{12149, 164340, 1, 848},
	{12170, 164344},
	{12188, 164348},
	{12206, 164352, 2, 849},
	{12226, 164356, 2, 796},
	{12250, 164360, 2, 798},
	{12274, 164364, 1, 856},
	{12294, 164368, 2, 851},
	{12314, 164372, 2, 854},
	{12334, 164376, 2, 851},
	{12354, 164380, 2, 854},
	{12374, 164384, 2, 851},
	{12394, 164388, 2, 854},
	{12414, 164392, 2, 851},
	{12434, 164396, 2, 854},
	{12454, 164400, 7, 857},
	{12469, 164404, 2, 4498},
	{12528, 164416, 2, 796},
	{12553, 164420, 2, 798},
	{12578, 164424},
	{12596, 164428},
	{12614, 164432, 2, 796},
	{12639, 164436, 2, 798},
	{12664, 164440, 2, 796},
	{12689, 164444, 2, 798},
	{12714, 164448, 2, 796},
	{12739, 164452, 2, 798},
	{12764, 164456, 2, 796},
	{12789, 164460, 2, 798},
	{12814, 164464, 2, 796},
	{12839, 164468, 2, 798},
	{12864, 164472, 2, 796},
	{12889, 164476, 2, 798},
	{12914, 164480, 2, 796},
	{12939, 164484, 2, 798},
	{12964, 164488, 2, 796},
	{12989, 164492, 2, 798},
	{13014, 164496, 2, 796},
	{13039, 164500, 2, 798},
	{13064, 164504, 2, 796},
	{13089, 164508, 2, 798},
	{13114, 164512, 2, 796},
	{13140, 164516, 2, 798},
	{13166, 164520, 2, 796},
	{13192, 164524, 2, 798},
	{13218, 164528, 2, 796},
	{13244, 164532, 2, 798},
	{13270, 164536, 2, 796},
	{13296, 164540, 2, 798},
	{13322, 164544, 2, 796},
	{13348, 164548, 2, 798},
	{13374, 164552, 2, 796},
	{13400, 164556, 2, 798},
	{16590, 164560},
	{16604, 164564},
	{16618, 164568},
	{16632, 164572},
	{16646, 164576},
	{16660, 164580},
	{16674, 164584},
	{16688, 164588},
	{16702, 164592},
	{16716, 164596},
	{16730, 164600},
	{16744, 164604},
	{16758, 164608},
	{16772, 164612},
	{16786, 164616},
	{16800, 164620},
	{16814, 164624},
	{16828, 164628},
	{16842, 164632},
	{16856, 164636},
	{16870, 164640},
	{16884, 164644},
	{16898, 164648},
	{16912, 164652},
	{16926, 164656},
	{47842, 164660, 2, 3204},
	{14046, 164688, 15, 882},
	{14066, 164692, 3, 897},
	{14088, 164696, 2, 900},
	{14116, 164700, 4, 3165},
	{14145, 164704, 1, 909},
	{52479, 164708, 1, 910},
	{52492, 164712, 1, 911},
	{43501, 164716},
	{43523, 164720},
	{52503, 164724, 4, 4500},
	{52524, 164728, 4, 4500},
	{52545, 164732, 4, 4500},
	{52566, 164736, 4, 4500},
	{47615, 164816, 5, 3169},
	{47639, 164820},
	{47668, 164824, 1, 1622},
	{47701, 164828, 2, 4504},
	{52587, 164832, 2, 4506},
	{47759, 164848},
	{47779, 164852, 2, 3187},
	{47803, 164856, 2, 4504},
	{14294, 164876},
	{14323, 164880, 3, 4508},
	{14348, 164884},
	{14361, 164888},
	{14376, 164892},
	{14390, 164896},
	{20735, 164908},
	{20758, 164912},
	{20781, 164916},
	{20804, 164920},
	{14502, 164924},
	{14521, 164928},
	{14541, 164932},
	{14560, 164936},
	{14580, 164940},
	{14599, 164944},
	{13426, 164948},
	{13445, 164952},
	{14619, 164956},
	{14640, 164960},
	{14662, 164964},
	{14683, 164968},
	{14705, 164972},
	{14726, 164976},
	{13464, 164980},
	{13483, 164984},
	{14748, 164988},
	{14769, 164992},
	{14791, 164996},
	{14812, 165000},
	{14834, 165004},
	{14855, 165008},
	{13502, 165012},
	{13521, 165016},
	{14877, 165020},
	{14898, 165024},
	{14920, 165028},
	{14941, 165032},
	{14963, 165036},
	{14984, 165040},
	{13540, 165044},
	{13559, 165048},
	{15006, 165052},
	{15027, 165056},
	{15049, 165060},
	{15070, 165064},
	{15092, 165068},
	{15113, 165072},
	{13578, 165076},
	{13597, 165080},
	{15135, 165084},
	{15156, 165088},
	{15178, 165092},
	{15199, 165096},
	{15221, 165100},
	{15242, 165104},
	{13616, 165108},
	{13635, 165112},
	{15264, 165116},
	{15285, 165120},
	{15307, 165124},
	{15328, 165128},
	{15350, 165132},
	{15371, 165136},
	{13654, 165140},
	{13673, 165144},
	{15393, 165148},
	{15414, 165152},
	{15436, 165156},
	{15457, 165160},
	{15479, 165164},
	{15500, 165168},
	{13692, 165172},
	{13711, 165176},
	{15522, 165180},
	{15543, 165184},
	{15565, 165188},
	{15586, 165192},
	{15608, 165196},
	{15629, 165200},
	{13730, 165204},
	{13749, 165208},
	{15651, 165212},
	{15672, 165216},
	{15694, 165220},
	{15715, 165224},
	{15737, 165228},
	{15758, 165232},
	{13768, 165236},
	{13787, 165240},
	{15780, 165244},
	{15802, 165248},
	{15825, 165252},
	{15847, 165256},
	{15870, 165260},
	{15892, 165264},
	{13806, 165268},
	{13826, 165272},
	{15915, 165276},
	{15937, 165280},
	{15960, 165284},
	{15982, 165288},
	{16005, 165292},
	{16027, 165296},
	{13846, 165300},
	{13866, 165304},
	{16050, 165308},
	{16072, 165312},
	{16095, 165316},
	{16117, 165320},
	{16140, 165324},
	{16162, 165328},
	{13886, 165332},
	{13906, 165336},
	{16185, 165340},
	{16207, 165344},
	{16230, 165348},
	{16252, 165352},
	{16275, 165356},
	{16297, 165360},
	{13926, 165364},
	{13946, 165368},
	{16320, 165372},
	{16342, 165376},
	{16365, 165380},
	{16387, 165384},
	{16410, 165388},
	{16432, 165392},
	{13966, 165396},
	{13986, 165400},
	{16455, 165404},
	{16477, 165408},
	{16500, 165412},
	{16522, 165416},
	{16545, 165420},
	{16567, 165424},
	{14006, 165428},
	{14026, 165432},
	{17685, 165440, 3, 4511},
	{17664, 165444, 7, 996},
	{17735, 165448, 1, 1016},
	{17757, 165452, 5, 1017},
	{17779, 165456, 1, 1022},
	{17799, 165460, 8, 1023},
	{17703, 165464, 7, 1009},
	{17629, 165468, 17, 4514},
	{17646, 165472, 16, 980},
	{16949, 165476, 13, 3206},
	{16969, 165480, 13, 3206},
	{16989, 165484, 13, 3206},
	{17009, 165488, 13, 3206},
	{17029, 165492, 13, 3206},
	{17049, 165496, 13, 3206},
	{17069, 165500, 13, 3206},
	{17089, 165504, 13, 3206},
	{17109, 165508, 13, 3206},
	{17129, 165512, 13, 3206},
	{17149, 165516, 13, 3206},
	{17170, 165520, 13, 3206},
	{17191, 165524, 13, 3206},
	{17212, 165528, 13, 3206},
	{17233, 165532, 13, 3206},
	{17254, 165536, 13, 3206},
	{17275, 165540, 13, 3206},
	{17296, 165544, 13, 3206},
	{17317, 165548, 13, 3206},
	{17338, 165552, 13, 3206},
	{17359, 165556, 11, 3219},
	{17380, 165560, 11, 3219},
	{17401, 165564, 11, 3219},
	{17422, 165568, 11, 3219},
	{17443, 165572, 11, 3219},
	{17464, 165576, 11, 3219},
	{17485, 165580, 11, 3219},
	{17506, 165584, 11, 3219},
	{17527, 165588, 11, 3219},
	{17548, 165592, 11, 3219},
	{17569, 165596, 11, 3219},
	{17590, 165600, 11, 3219},
	{51022, 165604, 3, 4531},
	{17718, 165608, 2, 4348},
	{47855, 165612},
	{47879, 165616, 1, 670},
	{43545, 165712, 8, 2482},
	{17821, 165716, 8, 3240},
	{17839, 165720, 8, 1039},
	{17860, 165724, 17, 1047},
	{17881, 165728, 6, 1064},
	{17899, 165732, 6, 1064},
	{17917, 165736, 6, 1064},
	{17935, 165740, 6, 1064},
	{17953, 165744, 6, 1064},
	{17971, 165748, 6, 1064},
	{17989, 165752, 6, 1064},
	{18007, 165756, 6, 1064},
	{18025, 165760, 9, 3248},
	{18043, 165764, 9, 3248},
	{18061, 165768, 9, 3248},
	{18079, 165772, 9, 3248},
	{18097, 165776, 9, 3248},
	{18115, 165780, 9, 3248},
	{18133, 165784, 9, 3248},
	{18151, 165788, 9, 3248},
	{18183, 165840, 1, 1079},
	{18198, 165844},
	{18216, 165848},
	{18234, 165852},
	{18251, 165856},
	{18272, 165860, 1, 1080},
	{18288, 165864},
	{18301, 165872, 4, 4534},
	{18335, 165880, 1, 1089},
	{18357, 165884, 1, 1090},
	{18444, 165904, 20, 1134},
	{18479, 165908, 10, 1170},
	{18494, 165912, 29, 3280},
	{18460, 165916, 15, 1154},
	{18512, 165920, 16, 1208},
	{18530, 165924, 3, 1224},
	{18554, 165928},
	{18579, 165932, 11, 1228},
	{18602, 165936, 6, 3829},
	{18653, 165944, 3, 2539},
	{18668, 165948, 5, 1250},
	{18698, 165952, 5, 1255},
	{18713, 165956},
	{43571, 165960, 7, 4538},
	{12498, 165968, 8, 866},
	{12513, 165972, 8, 874},
	{18409, 165976, 5, 3257},
	{18731, 166400, 2, 1260},
	{18748, 166404, 2, 1262},
	{18767, 166408, 1, 1264},
	{18783, 166412, 3, 1265},
	{18836, 166424},
	{18859, 166428},
	{52602, 166468, 1, 4545},
	{19085, 166472, 7, 4546},
	{19103, 166476, 25, 4553},
	{52627, 166480},
	{52641, 166512},
	{19276, 166516},
	{19289, 166520},
	{19306, 166524, 7, 4578},
	{52655, 166528},
	{19355, 166536},
	{19399, 166544, 3, 3309},
	{20191, 166552, 7, 4585},
	{19583, 166556, 1, 1378},
	{19446, 166560, 5, 4592},
	{20319, 166564, 10, 4597},
	{19612, 166588, 7, 4607},
	{19629, 166592, 3, 1389},
	{19656, 166596, 3, 1393},
	{20018, 166696},
	{20049, 166700},
	{20092, 166704, 1, 1402},
	{20130, 166712, 1, 1403},
	{20547, 166716, 3, 4614},
	{20150, 166732, 2, 1404},
	{20169, 166736, 5, 1406},
	{20212, 166744, 2, 4617},
	{20373, 166776, 2, 1451},
	{20403, 166780},
	{20427, 166784},
	{20457, 166788},
	{20488, 166792},
	{20517, 166796},
	{52669, 166804, 4, 4619},
	{52684, 166808, 2, 4623},
	{52699, 166812},
	{52714, 166816, 1, 1622},
	{52733, 166820, 2, 4504},
	{52751, 166824},
	{52766, 166828, 1, 1622},
	{52785, 166832, 2, 4504},
	{51042, 166836, 1, 3873},
	{52803, 166840, 1, 4625},
	{52836, 166844, 2, 4626},
	{52855, 166848, 10, 4628},
	{20688, 166876, 5, 1484},
	{20704, 166880, 5, 4638},
	{20720, 166884, 3, 1495},
	{20636, 166896, 8, 1468},
	{20662, 166900, 8, 1476},
	{20827, 166904, 8, 1498},
	{20861, 166908, 8, 1506},
	{20895, 166912, 8, 1514},
	{20929, 166916, 8, 1522},
	{20963, 166920, 8, 1498},
	{20997, 166924, 8, 1506},
	{21031, 166928, 8, 1514},
	{21065, 166932, 8, 1522},
	{21099, 166936, 8, 1498},
	{21133, 166940, 8, 1506},
	{21167, 166944, 8, 1514},
	{21201, 166948, 8, 1522},
	{21235, 166952, 8, 1498},
	{21269, 166956, 8, 1506},
	{21303, 166960, 8, 1514},
	{21337, 166964, 8, 1522},
	{21371, 166968, 2, 1530},
	{21395, 166972, 2, 1532},
	{52882, 166976},
	{21440, 166980, 13, 4643},
	{21460, 166984, 2, 1550},
	{47903, 166988, 14, 3859},
	{21518, 166992, 6, 3357},
	{21480, 166996, 20, 1552},
	{21419, 167000, 6, 4656},
	{52918, 167004, 1, 4662},
	{21587, 167008},
	{21634, 167012, 2, 4663},
	{52942, 167016, 1, 4665},
	{21664, 167020, 3, 4666},
	{47923, 167024, 6, 4669},
	{24363, 167032, 2, 4675},
	{24507, 167036, 5, 4677},
	{21842, 167044},
	{21889, 167048, 2, 4663},
	{52958, 167052, 1, 4665},
	{21919, 167056, 3, 4666},
	{47946, 167060, 6, 4669},
	{24381, 167068, 2, 4675},
	{24525, 167072, 5, 4677},
	{22097, 167080},
	{22144, 167084, 2, 4663},
	{52974, 167088, 1, 4665},
	{22174, 167092, 3, 4666},
	{47969, 167096, 6, 4669},
	{24399, 167104, 2, 4675},
	{24543, 167108, 5, 4677},
	{22352, 167116},
	{22399, 167120, 2, 4663},
	{52990, 167124, 1, 4665},
	{22429, 167128, 3, 4666},
	{47992, 167132, 6, 4669},
	{24417, 167140, 2, 4675},
	{24561, 167144, 5, 4677},
	{22607, 167152},
	{22654, 167156, 2, 4663},
	{53006, 167160, 1, 4665},
	{22684, 167164, 3, 4666},
	{48015, 167168, 6, 4669},
	{24435, 167176, 2, 4675},
	{24579, 167180, 5, 4677},
	{22862, 167188},
	{22909, 167192, 2, 4663},
	{53022, 167196, 1, 4665},
	{22939, 167200, 3, 4666},
	{48038, 167204, 6, 4669},
	{24453, 167212, 2, 4675},
	{24597, 167216, 5, 4677},
	{23117, 167224},
	{23164, 167228, 2, 4663},
	{53038, 167232, 1, 4665},
	{23194, 167236, 3, 4666},
	{48061, 167240, 6, 4669},
	{24471, 167248, 2, 4675},
	{24615, 167252, 5, 4677},
	{23372, 167260},
	{23419, 167264, 2, 4663},
	{53054, 167268, 1, 4665},
	{23449, 167272, 3, 4666},
	{48084, 167276, 6, 4669},
	{24489, 167284, 2, 4675},
	{24633, 167288, 5, 4677},
	{23627, 167488, 1, 1622},
	{23646, 167492, 1, 1622},
	{23665, 167496, 1, 1622},
	{23684, 167500, 1, 1622},
	{23703, 167504, 1, 1622},
	{23722, 167508, 1, 1622},
	{23741, 167512, 1, 1622},
	{23760, 167516, 1, 1622},
	{21649, 167616, 9, 4682},
	{21904, 167620, 9, 4682},
	{22159, 167624, 9, 4682},
	{22414, 167628, 9, 4682},
	{22669, 167632, 9, 4682},
	{22924, 167636, 9, 4682},
	{23179, 167640, 9, 4682},
	{23434, 167644, 9, 4682},
	{53070, 167680, 2, 4691},
	{53083, 167684, 2, 4691},
	{53096, 167688, 2, 4691},
	{53109, 167692, 2, 4691},
	{53122, 167696, 2, 4691},
	{53135, 167700, 2, 4691},
	{53148, 167704, 2, 4691},
	{53161, 167708, 2, 4691},
	{24651, 196608, 1, 1634},
	{24671, 196612, 1, 1635},
	{24691, 196616},
	{24711, 196620},
	{24731, 196624},
	{24752, 196628},
	{25289, 196704, 1, 1638},
	{25311, 196708, 1, 1639},
	{25333, 196712},
	{25356, 196716},
	{25379, 196720},
	{25402, 196724},
	{25425, 196728},
	{25448, 196732},
	{25471, 196736},
	{25495, 196740},
	{25519, 196744},
	{25543, 196748},
	{25567, 196752},
	{25591, 196756},
	{25615, 196760},
	{25639, 196764},
	{25663, 196768},
	{25685, 196772},
	{25707, 196776},
	{25728, 196780},
	{25749, 196784},
	{25773, 196788},
	{25797, 196792},
	{25821, 196796},
	{25845, 196800},
	{25869, 196804},
	{48107, 196808},
	{48131, 196812},
	{25953, 196852, 1, 1641},
	{26013, 196864},
	{26026, 196868},
	{26039, 196872},
	{26052, 196876},
	{26065, 196880},
	{26078, 196884},
	{26091, 196888},
	{26104, 196892},
	{43586, 196896, 5, 2647},
	{26140, 196908, 1, 670},
	{26159, 196912},
	{26177, 196916},
	{26204, 196920},
	{26257, 196936},
	{26280, 196940},
	{26415, 196960, 1, 1645},
	{26433, 196964, 6, 3410},
	{26451, 196968},
	{26466, 196972},
	{26490, 196976},
	{26514, 196980},
	{26533, 196984},
	{26648, 197028, 1, 1650},
	{26666, 197032, 7, 3416},
	{26684, 197036},
	{26702, 197040},
	{26720, 197044, 1, 1653},
	{26738, 197048, 5, 3423},
	{26812, 197072},
	{26876, 197084, 7, 4693},
	{26895, 197088, 7, 4693},
	{27009, 197120},
	{27028, 197124, 1, 1687},
	{27050, 197128},
	{27069, 197132, 1, 1688},
	{27091, 197136, 7, 1689},
	{27109, 197140},
	{27129, 197144, 1, 1687},
	{27152, 197148},
	{27172, 197152, 1, 1688},
	{27195, 197156, 7, 1689},
	{27214, 197160, 8, 4700},
	{27226, 197164, 2, 1703},
	{27260, 197172, 1, 1706},
	{27278, 197176, 6, 3437},
	{27298, 197180, 2, 330},
	{27315, 197184},
	{27331, 197188, 1, 1713},
	{27344, 197192, 1, 1714},
	{27358, 197196, 1, 1715},
	{27372, 197200, 1, 1716},
	{27394, 197204, 1, 1717},
	{27414, 197208, 1, 1718},
	{27436, 197212, 1, 1719},
	{27504, 197232, 2, 1720},
	{27526, 197236, 2, 1722},
	{27548, 197240, 2, 1720},
	{27571, 197244, 2, 1722},
	{43605, 197256},
	{43627, 197260},
	{48155, 197264},
	{48177, 197268},
	{48199, 197272},
	{48222, 197276},
	{27699, 197376, 1, 1725},
	{27716, 197380, 1, 1726},
	{27733, 197384, 1, 1727},
	{27908, 197424, 1, 1731},
	{27923, 197428, 1, 1732},
	{27938, 197432, 1, 1733},
	{27951, 197436, 1, 1734},
	{27966, 197440, 1, 1735},
	{27981, 197444, 1, 1736},
	{27994, 197448, 1, 1737},
	{28008, 197452, 1, 1738},
	{28022, 197456, 1, 1739},
	{28034, 197460, 5, 4708},
	{28057, 197464, 5, 2659},
	{28079, 197468, 1, 1747},
	{28099, 197472, 1, 1748},
	{28113, 197476, 1, 1749},
	{28127, 197480, 1, 1750},
	{28139, 197484, 1, 1751},
	{28223, 197552, 1, 1752},
	{28272, 197560, 1, 1753},
	{28292, 197568},
	{28318, 197572, 1, 1635},
	{28400, 197584},
	{28423, 197588, 1, 1635},
	{28449, 197592},
	{28471, 197596, 1, 1635},
	{28496, 197600},
	{28515, 197604, 1, 1635},
	{28537, 197608, 1, 1350},
	{28588, 197620, 8, 1754},
	{28605, 197624, 13, 1762},
	{28622, 197628},
	{28639, 197632, 1, 1705},
	{28659, 197636},
	{28676, 197640, 1, 1670},
	{28696, 197644, 2, 1775},
	{28715, 197888, 8, 1777},
	{28736, 197892, 8, 1777},
	{28757, 198656, 6, 4713},
	{53174, 198660},
	{28810, 198920, 3, 4719},
	{28829, 198924, 2, 2664},
	{28976, 198948},
	{28992, 198952},
	{29007, 198956, 3, 3456},
	{29033, 198960},
	{29049, 198964},
	{29067, 198968, 1, 3459},
	{29084, 198972, 2, 2666},
	{29105, 198976},
	{53189, 198992, 8, 4722},
	{29285, 199012},
	{29301, 199016},
	{29322, 199020, 8, 3460},
	{29330, 199024},
	{29344, 199028},
	{29358, 199032},
	{29372, 199036, 4, 4730},
	{29421, 199040, 3, 1813},
	{19336, 199048, 1, 1360},
	{43801, 199052, 2, 2668},
	{48245, 199056, 2, 3468},
	{48270, 199060, 1, 3470},
	{19244, 199064, 1, 3471},
	{29399, 199068, 1, 837},
	{53204, 199072},
	{53221, 199076, 1, 4734},
	{53238, 199080},
	{53256, 199084, 7, 4735},
	{53274, 199088, 1, 3472},
	{19377, 199092},
	{29437, 199168, 1, 1816},
	{29462, 199172, 2, 1817},
	{29487, 199184, 2, 1819},
	{29513, 199188, 2, 1819},
	{29539, 199192, 2, 1819},
	{29565, 199212, 2, 1819},
	{29591, 199296, 2, 1821},
	{29619, 199300, 1, 4742},
	{29643, 199304, 1, 4743},
	{29667, 199308, 1, 1825},
	{29700, 199312, 1, 1825},
	{29728, 199328, 2, 1821},
	{29757, 199332, 1, 4742},
	{29782, 199336, 1, 4743},
	{29807, 199340, 1, 1825},
	{29841, 199344, 1, 1825},
	{29870, 199360, 2, 1821},
	{29894, 199364, 1, 4742},
	{29914, 199368, 1, 4743},
	{29934, 199372, 1, 1825},
	{29963, 199376, 1, 1825},
	{29987, 199936},
	{30014, 199940},
	{30041, 199944},
	{30068, 199948},
	{30095, 199952},
	{30122, 199956},
	{30149, 199960},
	{30176, 199964},
	{30203, 199968, 4, 2670},
	{30228, 200192},
	{30247, 200196, 1, 847},
	{30269, 200448},
	{30293, 200452, 1, 1835},
	{30316, 200456},
	{30340, 200460, 1, 1835},
	{30363, 200464},
	{30387, 200468, 1, 1835},
	{30410, 200472},
	{30434, 200476, 1, 1835},
	{2911, 200960, 7, 3485},
	{48937, 200964, 13, 3492},
	{48955, 200968, 9, 4744},
	{48993, 200976, 8, 3515},
	{49015, 200980, 8, 3523},
	{49037, 200984},
	{49061, 200988, 6, 3531},
	{53296, 200992, 2, 4753},
	{53314, 201000, 9, 4755},
	{53346, 201004, 7, 4764},
	{31124, 212992},
	{31144, 212996},
	{31164, 213000},
	{31184, 213004},
	{31204, 213008},
	{31224, 213012},
	{31244, 213016},
	{31264, 213020},
	{31284, 213024},
	{31304, 213028},
	{31324, 213032},
	{31344, 213036},
	{31364, 213040},
	{31387, 213044},
	{31410, 213048},
	{31433, 213248},
	{31454, 213252},
	{31475, 213260},
	{31496, 213264},
	{43813, 213648},
	{43833, 213652},
	{43853, 213656},
	{43873, 213660},
	{43893, 213664},
	{43913, 213668},
	{43933, 213672},
	{43953, 213676},
	{43973, 213680},
	{43998, 213684},
	{44023, 213688},
	{44048, 213692},
	{44073, 213696},
	{44098, 213700},
	{44123, 213704},
	{44148, 213708},
	{44173, 213712},
	{44196, 213716},
	{44219, 213720},
	{44242, 213724},
	{44265, 213728},
	{44288, 213732},
	{44311, 213736},
	{44334, 213740},
	{53376, 213992},
	{53398, 213996},
	{53420, 214000},
	{53442, 214004},
	{32169, 214016},
	{32191, 214020, 1, 1876},
	{32213, 214024},
	{32235, 214028, 1, 1876},
	{32257, 214032},
	{32279, 214036, 1, 1876},
	{32301, 214040},
	{32323, 214044, 1, 1876},
	{32345, 214272},
	{32367, 214276},
	{32389, 214280},
	{32411, 214284},
	{32433, 214288},
	{32455, 214292},
	{32477, 214296},
	{32499, 214300},
	{32521, 214304},
	{32543, 214308},
	{32565, 214312},
	{32587, 214316},
	{32609, 214320},
	{32631, 214324},
	{32653, 214328},
	{32675, 214332},
	{32697, 214528},
	{32717, 214532},
	{32737, 214536},
	{32757, 214540},
	{32777, 214544},
	{32797, 214548},
	{32817, 214552},
	{32837, 214556},
	{32857, 214560},
	{32877, 214564},
	{32897, 214568},
	{32917, 214572},
	{31265, 214576},
	{31245, 214580},
	{31225, 214584},
	{31205, 214588},
	{49229, 214592},
	{49248, 214596},
	{49267, 214600},
	{49286, 214604},
	{32937, 214784},
	{32975, 214792},
	{33013, 214800},
	{33051, 214808},
	{33089, 214816},
	{33127, 214824},
	{33165, 214832},
	{33203, 214840},
	{49305, 214928},
	{49325, 214932},
	{49345, 214936},
	{49365, 214940},
	{49385, 214944},
	{49405, 214948},
	{49425, 214952},
	{49445, 214956},
	{49465, 214960},
	{49485, 214964},
	{49505, 214968},
	{49525, 214972},
	{49545, 214976},
	{49565, 214980},
	{49585, 214984},
	{49605, 214988},
	{33557, 215296},
	{33576, 215300},
	{33595, 215304},
	{33614, 215308},
	{33633, 215312},
	{33652, 215316},
	{33671, 215320},
	{33690, 215324},
	{53464, 215424},
	{53491, 215428},
	{53518, 215432},
	{53545, 215436},
	{53572, 215488},
	{53597, 215492},
	{53622, 215496},
	{53647, 215500},
	{33911, 215808},
	{33930, 215812},
	{33949, 215816},
	{33968, 215820},
	{33987, 216064},
	{34006, 216068},
	{34025, 216072},
	{34044, 216076},
	{34063, 216320},
	{34083, 216324},
	{34103, 216328},
	{34123, 216332},
	{34143, 216336},
	{34163, 216340},
	{34183, 216344},
	{34203, 216348},
	{49625, 216352, 11, 4771},
	{49648, 216356, 1, 3549},
	{49672, 216360, 12, 4782},
	{34223, 216576},
	{34244, 216580},
	{34265, 216584},
	{34286, 216588},
	{34307, 216592},
	{34328, 216596},
	{34349, 216600},
	{34370, 216604},
	{34391, 216640},
	{34412, 216644},
	{34433, 216648},
	{34454, 216652},
	{34475, 216656},
	{34496, 216660},
	{34517, 216664},
	{34538, 216668},
	{34559, 216704},
	{34580, 216708},
	{34601, 216712},
	{34622, 216716},
	{34643, 216720},
	{34664, 216724},
	{34685, 216728},
	{34706, 216732},
	{53672, 216736},
	{53694, 216740},
	{53716, 216744},
	{53738, 216748},
	{53760, 216752},
	{53782, 216756},
	{53804, 216760},
	{53826, 216764},
	{34727, 216832},
	{34747, 216836},
	{34767, 216840},
	{34787, 216844},
	{34807, 216848},
	{34827, 216852},
	{34847, 216856},
	{34867, 216860},
	{35055, 217112},
	{35074, 217116},
	{35093, 217120},
	{35112, 217124},
	{35131, 217128},
	{35150, 217132},
	{35169, 217136},
	{35188, 217140},
	{35207, 217344},
	{35226, 217348},
	{35245, 217352},
	{35264, 217356},
	{35283, 217360},
	{35302, 217364},
	{35321, 217368},
	{35340, 217372},
	{35359, 217600},
	{35379, 217604},
	{35399, 217608},
	{35419, 217612},
	{35439, 217856},
	{35459, 217860},
	{35479, 217864},
	{35499, 217868},
	{35519, 217872},
	{35539, 217876},
	{35559, 217880},
	{35579, 217884},
	{35701, 217984},
	{35726, 217988},
	{35751, 217992},
	{35776, 217996},
	{35649, 218000},
	{35675, 218004, 2, 1877},
	{44397, 218008},
	{44420, 218012, 2, 1877},
	{35941, 218240},
	{35961, 218244},
	{35981, 218248},
	{36001, 218252},
	{36021, 218624},
	{36043, 218628},
	{36065, 218632},
	{36087, 218636},
	{36109, 218640},
	{36131, 218644},
	{36153, 218648},
	{36175, 218652},
	{36197, 218656},
	{36219, 218660},
	{36241, 218664},
	{36263, 218668},
	{36285, 218672},
	{36307, 218676},
	{36329, 218680},
	{36351, 218684},
	{35853, 218752},
	{35875, 218756},
	{35897, 218760},
	{35919, 218764},
	{49698, 218768},
	{49720, 218772},
	{49742, 218776},
	{49764, 218780},
	{36373, 218880},
	{36394, 218884},
	{36415, 218888},
	{36436, 218892},
	{36457, 218896},
	{36478, 218900},
	{36499, 218904},
	{36520, 218908},
	{53848, 218912},
	{53870, 218916},
	{53892, 218920},
	{53914, 218924},
	{53936, 218928},
	{53958, 218932},
	{53980, 218936},
	{54002, 218940},
	{36541, 219136},
	{36561, 219140},
	{36581, 219144},
	{36601, 219148},
	{36621, 219152},
	{36641, 219156},
	{36661, 219160},
	{36681, 219164},
	{44481, 219520},
	{44510, 219524, 2, 1877},
	{44539, 219528},
	{44561, 219532},
	{44583, 219536},
	{44605, 219540},
	{44627, 219568},
	{44656, 219572, 2, 1877},
	{44685, 219576},
	{44707, 219580},
	{44729, 219584},
	{44751, 219588},
	{36741, 221184, 2, 4794},
	{36765, 221188, 4, 1884},
	{36790, 221192, 5, 1879},
	{36814, 221196, 2, 4794},
	{36838, 221200, 4, 1884},
	{36863, 221204, 2, 4794},
	{36887, 221208, 4, 1884},
	{36912, 221212, 5, 1879},
	{54024, 221216, 4, 1888},
	{36952, 221220, 5, 1879},
	{36976, 221224, 3, 1892},
	{37010, 221228, 3, 1895},
	{37044, 221232, 3, 1898},
	{37069, 221236, 3, 1901},
	{37094, 221240, 3, 1901},
	{49954, 221244, 3, 1895},
	{37119, 221248},
	{37134, 221252, 1, 1825},
	{37157, 221256},
	{37180, 221260},
	{37198, 221264, 2, 1904},
	{37216, 221268, 4, 1906},
	{37236, 221440, 19, 4796},
	{37261, 221444, 19, 4796},
	{37398, 221492, 9, 4815},
	{37426, 221496, 9, 4815},
	{45065, 221840, 5, 3593},
	{45089, 221844, 4, 1969},
	{45114, 221848, 5, 3593},
	{45138, 221852, 4, 1969},
	{45163, 221856, 5, 3593},
	{45187, 221860, 4, 1969},
	{45212, 221864, 5, 3593},
	{45236, 221868, 4, 1969},
	{45261, 221872, 5, 3593},
	{45290, 221876, 4, 1969},
	{45320, 221880, 5, 3593},
	{45349, 221884, 4, 1969},
	{45379, 221888, 5, 3593},
	{45408, 221892, 4, 1969},
	{45438, 221896, 5, 3593},
	{45467, 221900, 4, 1969},
	{45497, 221904, 5, 3593},
	{45524, 221908, 4, 1969},
	{45552, 221912, 5, 3593},
	{45579, 221916, 4, 1969},
	{45607, 221920, 5, 3593},
	{45634, 221924, 4, 1969},
	{45662, 221928, 5, 3593},
	{45689, 221932, 4, 1969},
	{54043, 222176, 25, 4824},
	{54069, 222180, 25, 4824},
	{37828, 222208, 5, 1964},
	{37854, 222212, 4, 1969},
	{37881, 222216, 5, 1964},
	{37907, 222220, 4, 1969},
	{37934, 222224, 5, 1964},
	{37960, 222228, 4, 1969},
	{37987, 222232, 5, 1964},
	{38013, 222236, 4, 1969},
	{38040, 222464, 5, 1964},
	{38066, 222468, 4, 1969},
	{38093, 222472, 1, 1879},
	{38119, 222476, 1, 1879},
	{38145, 222480, 1, 1879},
	{38171, 222484, 1, 1879},
	{38197, 222488, 1, 1879},
	{38223, 222492, 1, 1879},
	{38249, 222496, 1, 1879},
	{38275, 222720, 5, 1964},
	{38299, 222724, 5, 1964},
	{38323, 222728, 5, 1964},
	{38347, 222732, 5, 1964},
	{38471, 222736, 5, 1964},
	{38495, 222740, 5, 1964},
	{38371, 222744, 4, 1969},
	{38396, 222748, 4, 1969},
	{38421, 222752, 4, 1969},
	{38446, 222756, 4, 1969},
	{54095, 222760, 4, 1969},
	{54120, 222764, 4, 1969},
	{38519, 222768, 8, 1973},
	{36953, 222784, 5, 1964},
	{36815, 222788, 5, 1964},
	{50072, 222792, 5, 1964},
	{50095, 222796, 5, 1964},
	{36839, 222800, 4, 1969},
	{50118, 222804, 4, 1969},
	{50142, 222808, 4, 1969},
	{50166, 222812, 4, 1969},
	{38540, 222976, 3, 2686},
	{38563, 222980, 3, 2686},
	{38586, 222984, 3, 2686},
	{38609, 222988, 3, 2686},
	{38632, 222992, 3, 2686},
	{38655, 222996, 3, 2686},
	{38678, 223000, 3, 2686},
	{38701, 223004, 3, 2686},
	{38724, 223008, 3, 2686},
	{38747, 223012, 3, 2686},
	{38770, 223016, 3, 2686},
	{38794, 223020, 3, 2686},
	{38818, 223024, 3, 2686},
	{38842, 223028, 3, 2686},
	{38866, 223032, 3, 2686},
	{38890, 223036, 3, 2686},
	{50190, 223040, 3, 2686},
	{50214, 223044, 3, 2686},
	{50238, 223048, 3, 2686},
	{50262, 223052, 3, 2686},
	{50286, 223056, 3, 2686},
	{50310, 223060, 3, 2686},
	{50334, 223064, 3, 2686},
	{50358, 223068, 3, 2686},
	{50382, 223072, 10, 3598},
	{50403, 223080, 2, 3608},
	{50425, 223084, 1, 3610},
	{38914, 223104, 10, 3598},
	{38934, 223112, 2, 3608},
	{2412, 223128, 1, 4849},
	{54145, 223132},
	{54174, 223136, 1, 4850},
	{2464, 223140, 1, 4849},
	{54203, 223144},
	{54232, 223148, 1, 4850},
	{2559, 223152, 19, 4851},
	{2511, 223156, 7, 4870},
	{2532, 223160, 8, 4877},
	{2490, 223164, 2, 345},
	{54261, 223168, 4, 4885},
	{54282, 223172},
	{2580, 223184, 5, 3641},
	{43456, 223188, 6, 3646},
	{2632, 223192},
	{2662, 223196},
	{2694, 223200},
	{2725, 223204},
	{2603, 223208},
	{54317, 223212, 2, 4889},
	{54351, 223232, 5, 1964},
	{54382, 223236, 4, 1969},
	{54414, 223240, 2, 2161},
	{54445, 223360, 5, 1964},
	{54474, 223364, 4, 1969},
	{54504, 223368, 2, 2161},
	{39029, 223488, 5, 1964},
	{39052, 223492, 5, 1964},
	{39075, 223496, 5, 1964},
	{39098, 223500, 5, 1964},
	{39121, 223504, 4, 1969},
	{39145, 223508, 4, 1969},
	{54533, 223512, 4, 1969},
	{54557, 223516, 4, 1969},
	{39290, 224000, 5, 1964},
	{39313, 224004, 4, 1969},
	{39337, 224008, 3, 2020},
	{39360, 224256, 5, 1964},
	{39383, 224260, 4, 1969},
	{39407, 224264, 3, 2020},
	{39430, 224512, 5, 1964},
	{39454, 224516, 4, 1969},
	{39479, 224520, 5, 1964},
	{39503, 224524, 4, 1969},
	{39528, 224528, 2, 3652},
	{39552, 224532, 2, 3652},
	{39576, 224768, 5, 1964},
	{39601, 224772, 4, 1958},
	{39627, 224776, 5, 1964},
	{39652, 224780, 4, 1958},
	{39678, 224784, 5, 1964},
	{54581, 224788, 4, 1958},
	{39703, 224792, 5, 1964},
	{54607, 224796, 4, 1958},
	{39728, 224832, 5, 1964},
	{39753, 224836, 4, 1958},
	{39779, 224840, 5, 1964},
	{39804, 224844, 4, 1958},
	{39830, 224848, 5, 1964},
	{54633, 224852, 4, 1958},
	{39855, 224856, 5, 1964},
	{54659, 224860, 4, 1958},
	{39880, 224896, 5, 1964},
	{39905, 224900, 4, 1958},
	{39931, 224904, 5, 1964},
	{54685, 224908, 4, 1958},
	{39956, 224912, 5, 1964},
	{54711, 224916, 4, 1958},
	{39981, 224920, 5, 1964},
	{54737, 224924, 4, 1958},
	{54763, 224928, 5, 1964},
	{54789, 224932, 4, 1958},
	{54816, 224936, 5, 1964},
	{54842, 224940, 4, 1958},
	{54869, 224944, 5, 1964},
	{54895, 224948, 4, 1958},
	{54922, 224952, 5, 1964},
	{54948, 224956, 4, 1958},
	{40006, 225024, 5, 1964},
	{40030, 225028, 4, 1958},
	{40055, 225032, 5, 1964},
	{54975, 225036, 4, 1958},
	{40079, 225040, 5, 1964},
	{55000, 225044, 4, 1958},
	{40103, 225048, 5, 1964},
	{55025, 225052, 4, 1958},
	{40253, 225280, 12, 2023},
	{40275, 225284, 5, 1964},
	{40298, 225288, 4, 1969},
	{40322, 225292, 2, 3652},
	{40345, 225296, 2, 3652},
	{40368, 225300, 2, 3652},
	{40391, 225536, 5, 1964},
	{40414, 225540, 4, 1969},
	{40438, 225544, 5, 1964},
	{40461, 225548, 4, 1969},
	{40485, 225552, 5, 1964},
	{55050, 225556, 4, 1969},
	{40508, 225560, 5, 1964},
	{55074, 225564, 4, 1969},
	{40531, 225792, 5, 4891},
	{40552, 225796},
	{40581, 225800, 2, 2050},
	{40610, 225804},
	{41067, 225808, 2, 2077},
	{40665, 225812},
	{40684, 225816, 2, 2059},
	{40636, 225820, 3, 3659},
	{40756, 225824, 1, 4896},
	{40783, 225828, 2, 3663},
	{40710, 225832, 1, 4896},
	{40733, 225836, 2, 3663},
	{41086, 225864, 1, 4897},
	{41113, 225868},
	{46053, 225872, 1, 4897},
	{46084, 225876},
	{41140, 225880, 1, 4898},
	{41167, 225884, 1, 670},
	{46115, 225888, 3, 2753},
	{41194, 225892, 17, 3665},
	{41215, 225896, 8, 2723},
	{41234, 225900, 24, 4899},
	{41253, 225904, 1, 2111},
	{41277, 225908, 1, 2113},
	{41309, 225912, 1, 2115},
	{46186, 225916, 2, 2757},
	{50448, 225928, 2, 3705},
	{50462, 225932, 10, 3707},
	{45923, 225936},
	{45896, 225940},
	{55098, 225944},
	{55127, 225948, 1, 4923},
	{50477, 225972, 1, 3717},
	{55156, 225976, 1, 694},
	{50540, 225984, 1, 3719},
	{50560, 225988},
	{50582, 225992, 2, 3720},
	{55178, 225996, 1, 694},
	{50658, 226004, 1, 3719},
	{50681, 226008},
	{50706, 226012, 2, 3720},
	{50729, 226016, 1, 3722},
	{50746, 226020, 9, 3723},
	{50767, 226044},
	{41446, 226048, 4, 4924},
	{41463, 226052, 1, 2128},
	{41487, 226056, 1, 2128},
	{41701, 226304, 5, 1964},
	{41725, 226308, 4, 1969},
	{41750, 226312, 2, 3652},
	{41774, 226316, 5, 1964},
	{41798, 226320, 4, 1969},
	{41823, 226324, 2, 3652},
	{41847, 226328, 10, 2137},
	{42212, 226432, 5, 1964},
	{42241, 226436, 5, 1964},
	{42270, 226440, 4, 1969},
	{42300, 226444, 4, 1969},
	{42330, 226448, 8, 1995},
	{42357, 226452, 8, 1995},
	{41955, 226496, 5, 2147},
	{41983, 226500, 5, 2147},
	{42011, 226504, 5, 2147},
	{42039, 226508, 5, 2147},
	{42067, 226512, 5, 2147},
	{42095, 226516, 5, 2147},
	{42123, 226520, 5, 2147},
	{42151, 226524, 5, 2147},
	{42179, 226528, 6, 2152},
	{46227, 226532, 5, 2147},
	{46252, 226536, 5, 2147},
	{46277, 226540, 5, 2147},
	{46302, 226544, 5, 2147},
	{46327, 226548, 6, 2152},
	{42473, 226688, 5, 1964},
	{42497, 226692, 4, 1969},
	{42522, 226696, 5, 1964},
	{55203, 226700, 4, 1969},
	{42598, 226816, 5, 1964},
	{42624, 226820, 4, 1969},
	{42651, 226824, 5, 1964},
	{42677, 226828, 5, 1964},
	{42703, 226832, 5, 1964},
	{42729, 226836, 1, 1879},
	{42755, 226840, 1, 1879},
	{42781, 226844, 1, 1879},
	{42807, 226848, 1, 1879},
	{42833, 226880, 4, 1969},
	{42860, 226884, 4, 1969},
	{42887, 226888, 4, 1969},
	{42546, 226944, 2, 2161},
	{42572, 226948, 2, 2161},
	{50781, 226952, 2, 2161},
	{50807, 226956, 2, 2161},
	{42914, 227072, 5, 1964},
	{42939, 227076, 4, 1958},
	{42965, 227080, 5, 1964},
	{55228, 227084, 4, 1958},
	{42990, 227088, 5, 1964},
	{55254, 227092, 4, 1958},
	{43015, 227096, 5, 1964},
	{55280, 227100, 4, 1958},
	{55306, 227104, 5, 1964},
	{55332, 227108, 4, 1958},
	{55359, 227112, 5, 1964},
	{55385, 227116, 4, 1958},
	{55412, 227120, 5, 1964},
	{55438, 227124, 4, 1958},
	{55465, 227128, 5, 1964},
	{55491, 227132, 4, 1958},
	{43040, 227200, 5, 1964},
	{43064, 227204, 4, 1958},
	{43089, 227208, 5, 1964},
	{55518, 227212, 4, 1958},
	{43113, 227216, 5, 1964},
	{55543, 227220, 4, 1958},
	{43137, 227224, 5, 1964},
	{55568, 227228, 4, 1958},
	{46425, 227456, 5, 2147},
	{46456, 227460, 5, 2147},
	{46487, 227464, 6, 2152},
	{46523, 227468, 1, 2760},
	{46547, 227472, 5, 1964},
	{46573, 227476, 4, 1969},
	{46600, 227480, 5, 1964},
	{46626, 227484, 4, 1969},
	{46653, 227504, 5, 2147},
	{46684, 227508, 5, 2147},
	{46715, 227512, 6, 2152},
	{46751, 227516, 1, 2760},
	{46775, 227520, 5, 1964},
	{46801, 227524, 4, 1969},
	{46828, 227528, 5, 1964},
	{46854, 227532, 4, 1969},
	{206, 880, 4, 2163},
	{43232, 881},
	{27079, 882},
	{43244, 1008},
	{43255, 1009},
	{27267, 1010, 4, 2167},
	{43266, 1040, 1, 2171},
	{43279, 1041, 5, 2172},
	{43292, 1042, 1, 2177},
	{43305, 1043, 1, 1688},
	{27101, 1045, 7, 2178},
	{43318, 1168, 18, 3732},
	{43333, 1281, 6, 2197},
	{43348, 1282},
	{27038, 1283},
	{43232, 1285},
	{27079, 1286},
	{50959, 1408, 4, 3750},
	{50977, 1413, 1, 3754},
	{43360, 1414, 15, 2203},
};

static const struct si_reg gfx6_reg_table[] = {
	{1390, 68, 9, 4928},
	{1403, 72, 24, 4937},
	{1418, 76, 3, 4961},
	{55593, 80, 11, 4964},
	{1455, 84, 4, 4975},
	{1473, 88, 2, 3924},
	{1491, 92, 4, 4979},
	{1506, 96},
	{1520, 100, 1, 4983},
	{1534, 104},
	{55607, 108},
	{55624, 112, 13, 4984},
	{55640, 2480},
	{55655, 2484, 1, 4997},
	{55670, 2488},
	{55685, 2492, 1, 4997},
	{1689, 2496},
	{1703, 2500},
	{1717, 2504},
	{1731, 2508},
	{1745, 2512},
	{1759, 2516},
	{1773, 2520},
	{1787, 2524},
	{1801, 2528},
	{1815, 2532},
	{1829, 2536},
	{1844, 2540},
	{1919, 2544},
	{1930, 2552},
	{1946, 2556},
	{55700, 3660, 21, 4998},
	{55713, 3664, 20, 5019},
	{55725, 3668, 16, 5039},
	{55738, 32768, 1, 5055},
	{55748, 32772, 2, 5056},
	{2034, 32776, 17, 5058},
	{55763, 32780, 2, 5075},
	{2047, 32784, 24, 5077},
	{2059, 32788, 11, 5101},
	{2075, 32792, 11, 5101},
	{55777, 32800, 6, 5112},
	{55793, 32804, 1, 5118},
	{55809, 32808},
	{28757, 32812, 6, 5119},
	{55825, 32816, 2, 5125},
	{55845, 32820, 1, 5127},
	{55867, 32848, 6, 5128},
	{55878, 32852, 22, 5134},
	{55898, 32856, 4, 5156},
	{55914, 32864, 2, 5160},
	{37236, 32880, 19, 5162},
	{37261, 32884, 19, 5162},
	{31433, 32888},
	{31454, 32892},
	{31475, 32896},
	{31496, 32900},
	{37286, 32920, 12, 5181},
	{37314, 32924, 12, 5181},
	{31517, 32936},
	{31541, 32940},
	{31565, 32944},
	{31589, 32948},
	{55928, 33008, 1, 5193},
	{47394, 33012},
	{55940, 33020},
	{55953, 33024},
	{55971, 33028},
	{55989, 33032},
	{56007, 33036},
	{56025, 33040},
	{56043, 33044},
	{56061, 33048},
	{56079, 33052},
	{56097, 33536, 10, 5194},
	{24651, 33792, 2, 5204},
	{24671, 33796, 1, 1635},
	{24691, 33800},
	{24711, 33804},
	{24731, 33808},
	{24752, 33812},
	{24773, 33816, 2, 5206},
	{24795, 33820},
	{24817, 33824},
	{24847, 33828},
	{24877, 33832},
	{24906, 33836},
	{24935, 33840},
	{24965, 33844},
	{24995, 33848},
	{25024, 33852},
	{25053, 33856},
	{25083, 33860},
	{25113, 33864},
	{25142, 33868},
	{25171, 33872},
	{25201, 33876},
	{25231, 33880},
	{25260, 33884},
	{25289, 33888, 2, 5208},
	{25311, 33892},
	{25333, 33896},
	{25356, 33900},
	{25379, 33904},
	{25402, 33908},
	{25425, 33912},
	{25448, 33916},
	{25471, 33920},
	{25495, 33924},
	{25519, 33928},
	{25543, 33932},
	{25567, 33936},
	{25591, 33940},
	{25615, 33944},
	{25639, 33948},
	{25663, 33952},
	{25685, 33956},
	{25707, 33960},
	{25728, 33964},
	{25749, 33968},
	{25773, 33972},
	{25797, 33976},
	{25821, 33980},
	{25845, 33984},
	{25869, 33988},
	{25997, 34044, 1, 1642},
	{26013, 34048},
	{26026, 34052},
	{26039, 34056},
	{26052, 34060},
	{26065, 34064},
	{26078, 34068},
	{26091, 34072},
	{26104, 34076},
	{26231, 34112, 2, 1643},
	{26244, 34116},
	{26415, 34144, 1, 1645},
	{26433, 34148, 3, 5210},
	{26451, 34152},
	{26466, 34156},
	{26490, 34160},
	{26514, 34164},
	{26533, 34168},
	{26552, 34172},
	{26576, 34176},
	{26600, 34180},
	{26624, 34184},
	{26648, 34212, 2, 5213},
	{26666, 34216, 1, 5215},
	{26684, 34220},
	{26702, 34224},
	{26720, 34228, 2, 5216},
	{26738, 34232, 1, 5218},
	{26756, 34236},
	{26774, 34240, 2, 1656},
	{26793, 34244, 5, 5219},
	{26812, 34256},
	{26836, 34260, 2, 1656},
	{26856, 34264, 5, 5219},
	{26930, 34284, 1, 1671},
	{26951, 34288, 23, 5224},
	{26965, 34292},
	{26979, 34296},
	{26993, 34300, 4, 5247},
	{27009, 34304},
	{27028, 34308, 1, 5251},
	{27050, 34312},
	{27069, 34316, 1, 5252},
	{27091, 34320, 9, 5253},
	{27109, 34324},
	{27129, 34328, 1, 5251},
	{27152, 34332},
	{27172, 34336, 1, 5252},
	{27195, 34340, 9, 5253},
	{27214, 34344, 5, 5262},
	{27226, 34348, 2, 1703},
	{27260, 34356, 1, 5267},
	{27278, 34360, 5, 2654},
	{27298, 34364, 1, 1711},
	{27315, 34368},
	{27331, 34372, 1, 1713},
	{27344, 34376, 1, 1714},
	{27358, 34380, 1, 1715},
	{27372, 34384, 1, 1716},
	{27394, 34388, 1, 1717},
	{27414, 34392, 1, 1718},
	{27436, 34396, 1, 1719},
	{56120, 34416, 15, 5268},
	{56137, 34420, 18, 5283},
	{56154, 34424, 31, 5301},
	{56171, 34428, 16, 5332},
	{56184, 34432, 24, 5348},
	{56192, 34436},
	{56210, 34440},
	{56229, 34444, 3, 5372},
	{56248, 34448},
	{56266, 34460, 1, 5375},
	{56287, 34512, 2, 5376},
	{56299, 34516, 1, 5378},
	{56311, 34520, 9, 5379},
	{56322, 34528, 4, 5388},
	{56335, 34532, 1, 5392},
	{56352, 34552, 1, 5393},
	{56364, 34556, 1, 5393},
	{56376, 34560, 1, 5393},
	{56388, 34564, 2, 5394},
	{56405, 34568, 2, 5396},
	{27749, 34572, 1, 1728},
	{27768, 34576, 1, 5398},
	{27787, 34580, 1, 1730},
	{27804, 34584, 1, 1731},
	{27822, 34588, 1, 5399},
	{27840, 34592, 1, 1733},
	{27856, 34596, 1, 1734},
	{27874, 34600, 1, 5400},
	{27892, 34604, 1, 1736},
	{27908, 34608, 1, 1731},
	{27923, 34612, 1, 5399},
	{27938, 34616, 1, 1733},
	{27951, 34620, 1, 1734},
	{27966, 34624, 1, 5400},
	{27981, 34628, 1, 1736},
	{27994, 34632, 1, 1737},
	{28008, 34636, 1, 5401},
	{28022, 34640, 1, 1739},
	{56426, 34644, 4, 5402},
	{56445, 34648, 4, 5406},
	{56464, 34652, 3, 5410},
	{56482, 34656, 2, 5413},
	{56502, 34660, 2, 5415},
	{56520, 34664, 2, 5417},
	{56533, 34668, 1, 5419},
	{56546, 34672, 1, 5420},
	{56560, 34676, 1, 5421},
	{56573, 34680, 3, 5422},
	{56586, 34684},
	{56598, 34688, 2, 5425},
	{56613, 34692, 2, 5427},
	{56629, 34696, 2, 5429},
	{56645, 34700, 1, 5431},
	{56657, 34708, 2, 5432},
	{56669, 34712, 2, 5434},
	{56683, 34716, 1, 5436},
	{56697, 34720, 2, 5437},
	{56715, 34724, 2, 5439},
	{56734, 34728, 2, 5441},
	{56753, 34780, 12, 5443},
	{36936, 34812, 4, 1888},
	{56771, 34944, 5, 5455},
	{56794, 34948, 2, 5460},
	{56817, 34952, 2, 5460},
	{56840, 34956, 2, 5460},
	{56863, 34960},
	{56882, 34964},
	{56901, 34968},
	{56920, 34972},
	{56939, 34976},
	{56958, 34980},
	{56977, 34984},
	{56996, 34988},
	{57015, 34992, 1, 5462},
	{57038, 34996, 1, 5463},
	{57062, 35000, 1, 5464},
	{57085, 35004, 1, 5465},
	{57110, 35008, 2, 5466},
	{57130, 35012, 8, 5468},
	{28772, 35016},
	{28791, 35020},
	{57153, 35024, 4, 5476},
	{57169, 35028, 1, 5480},
	{57189, 35032, 1, 5481},
	{57205, 35036, 5, 5482},
	{57220, 35040, 2, 5487},
	{57235, 35044},
	{57250, 35048, 2, 5489},
	{57264, 35052},
	{57278, 35056, 10, 5491},
	{57294, 35100, 1, 5501},
	{57320, 35104, 5, 5455},
	{57344, 35108, 5, 5455},
	{57368, 35112, 2, 5460},
	{57392, 35116, 2, 5460},
	{57416, 35120},
	{57436, 35124},
	{57456, 35128},
	{57476, 35132},
	{57496, 35136},
	{57516, 35140},
	{57536, 35144},
	{57556, 35148},
	{28810, 35160, 1, 5502},
	{28829, 35164, 1, 5503},
	{28844, 35168},
	{28877, 35172},
	{28910, 35176},
	{28943, 35180},
	{29033, 35184},
	{29049, 35188},
	{57576, 35196, 10, 5504},
	{57594, 35200, 2, 5514},
	{57611, 35204, 10, 5516},
	{29067, 35208, 1, 1792},
	{57628, 35212, 3, 5526},
	{29084, 35248, 2, 5529},
	{29105, 35256},
	{57643, 35260, 4, 5531},
	{57669, 35264, 4, 5531},
	{57697, 35328, 1, 5535},
	{57714, 35332},
	{57731, 35344, 1, 5536},
	{57749, 35348, 9, 5537},
	{57763, 35352, 10, 5546},
	{37828, 35360, 3, 5455},
	{37881, 35364, 3, 5455},
	{37934, 35368, 2, 2017},
	{37987, 35372, 2, 2017},
	{32169, 35376},
	{32191, 35380, 1, 1876},
	{32213, 35384},
	{32235, 35388, 1, 1876},
	{32257, 35392},
	{32279, 35396, 1, 1876},
	{32301, 35400},
	{32323, 35404, 1, 1876},
	{57780, 35408, 1, 5556},
	{57798, 35412, 1, 5557},
	{29437, 35424, 1, 1816},
	{38040, 35456, 3, 5558},
	{38093, 35460, 1, 1981},
	{38119, 35464, 1, 1981},
	{38145, 35468, 1, 1981},
	{38171, 35472, 1, 1981},
	{38197, 35476, 1, 1981},
	{38223, 35480, 1, 1981},
	{38249, 35484, 1, 1981},
	{32345, 35488},
	{32367, 35492},
	{32389, 35496},
	{32411, 35500},
	{32433, 35504},
	{32455, 35508},
	{32477, 35512},
	{32499, 35516},
	{32521, 35520},
	{32543, 35524},
	{32565, 35528},
	{32587, 35532},
	{32609, 35536},
	{32631, 35540},
	{32653, 35544},
	{32675, 35548},
	{29462, 35600, 2, 1817},
	{57820, 35620, 2, 5561},
	{57845, 35624, 10, 5563},
	{57862, 35788, 4, 5573},
	{57878, 35796, 4, 5577},
	{57897, 35800, 1, 5581},
	{57914, 35804},
	{57931, 35824, 26, 5582},
	{57945, 35840, 9, 5608},
	{57955, 35844, 9, 5617},
	{30203, 35848, 3, 5626},
	{57966, 35852, 3, 5629},
	{57985, 35856, 6, 5632},
	{58000, 35860, 4, 5638},
	{38914, 35864, 9, 5642},
	{58014, 35868, 4, 5651},
	{58034, 35872, 4, 5651},
	{58056, 35876, 4, 5655},
	{32937, 35968},
	{32956, 35972},
	{32975, 35976},
	{32994, 35980},
	{33013, 35984},
	{33032, 35988},
	{33051, 35992},
	{33070, 35996},
	{33089, 36000},
	{33108, 36004},
	{33127, 36008},
	{33146, 36012},
	{33165, 36016},
	{33184, 36020},
	{33203, 36024},
	{33222, 36028},
	{33241, 36032},
	{33260, 36036},
	{33279, 36040},
	{33298, 36044},
	{33317, 36048},
	{33337, 36052},
	{33357, 36056},
	{33377, 36060},
	{33397, 36064},
	{33417, 36068},
	{33437, 36072},
	{33457, 36076},
	{33477, 36080},
	{33497, 36084},
	{33517, 36088},
	{33537, 36092},
	{38540, 36096, 6, 5659},
	{38563, 36100, 6, 5659},
	{38586, 36104, 6, 5659},
	{38609, 36108, 6, 5659},
	{38632, 36112, 6, 5659},
	{38655, 36116, 6, 5659},
	{38678, 36120, 6, 5659},
	{38701, 36124, 6, 5659},
	{38724, 36128, 6, 5659},
	{38747, 36132, 6, 5659},
	{38770, 36136, 6, 5659},
	{38794, 36140, 6, 5659},
	{38818, 36144, 6, 5659},
	{38842, 36148, 6, 5659},
	{38866, 36152, 6, 5659},
	{38890, 36156, 6, 5659},
	{58076, 36224, 2, 5665},
	{58092, 36228, 2, 5665},
	{58108, 36232, 4, 5667},
	{58125, 36236, 4, 5667},
	{58143, 36320, 8, 5671},
	{58156, 36324},
	{58168, 36336},
	{58179, 36340},
	{58190, 36352},
	{58211, 36356, 1, 4849},
	{2511, 36360, 8, 5679},
	{2532, 36364, 3, 5687},
	{58232, 36368, 2, 5690},
	{29987, 36384},
	{30014, 36388},
	{30041, 36392},
	{30068, 36396},
	{2490, 36400, 2, 5692},
	{2580, 36404, 5, 5694},
	{58258, 36408, 15, 5699},
	{2559, 36412, 1, 5714},
	{58279, 36416},
	{58300, 36424, 1, 5715},
	{58324, 36440, 3, 5716},
	{58342, 36444, 4, 5719},
	{58361, 36448, 3, 5723},
	{58376, 36452},
	{58398, 36456},
	{58420, 36460},
	{58442, 36464},
	{58464, 36480, 4, 5726},
	{58479, 36484, 3, 5730},
	{58490, 36488, 3, 5733},
	{58501, 36492, 4, 5736},
	{2767, 36608},
	{2785, 36612, 4, 383},
	{2803, 36616},
	{2821, 36620, 14, 5740},
	{3722, 36624},
	{3740, 36628, 5, 5754},
	{3758, 36632, 4, 5759},
	{3776, 36636, 11, 5763},
	{3794, 36640, 2, 5774},
	{3812, 36644, 2, 5776},
	{3830, 36648, 4, 5778},
	{3848, 36652},
	{2839, 36656, 13, 5782},
	{2857, 36660, 4, 411},
	{2875, 36664, 9, 5795},
	{2893, 36668, 3, 5804},
	{2911, 37120, 6, 426},
	{30228, 38156},
	{2927, 39160, 9, 5807},
	{2942, 39184, 6, 5816},
	{2956, 39188, 5, 5817},
	{2970, 39192, 5, 5817},
	{2984, 39196, 5, 5817},
	{2998, 39200, 5, 5817},
	{3012, 39204, 5, 5817},
	{3026, 39208, 5, 5817},
	{3040, 39212, 5, 5817},
	{3054, 39216, 5, 5817},
	{3068, 39220, 5, 5817},
	{3082, 39224, 5, 5817},
	{3097, 39228, 5, 5817},
	{3112, 39232, 5, 5817},
	{3127, 39236, 5, 5817},
	{3142, 39240, 5, 5817},
	{3157, 39244, 5, 5817},
	{3172, 39248, 5, 5817},
	{3187, 39252, 5, 5817},
	{3202, 39256, 5, 5817},
	{3217, 39260, 5, 5817},
	{3232, 39264, 5, 5817},
	{3247, 39268, 5, 5817},
	{3262, 39272, 5, 5817},
	{3277, 39276, 5, 5817},
	{3292, 39280, 5, 5817},
	{3307, 39284, 5, 5817},
	{3322, 39288, 5, 5817},
	{3337, 39292, 5, 5817},
	{3352, 39296, 5, 5817},
	{3367, 39300, 5, 5817},
	{3382, 39304, 5, 5817},
	{3397, 39308, 5, 5817},
	{58513, 45056},
	{58534, 45060, 1, 498},
	{58555, 45064},
	{58576, 45068, 1, 498},
	{3971, 45088},
	{3992, 45092, 1, 498},
	{4013, 45096, 11, 5822},
	{4037, 45100, 6, 5833},
	{4061, 45104},
	{4087, 45108},
	{4113, 45112},
	{4139, 45116},
	{4165, 45120},
	{4191, 45124},
	{4217, 45128},
	{4243, 45132},
	{4269, 45136},
	{4295, 45140},
	{4321, 45144},
	{4348, 45148},
	{4375, 45152},
	{4402, 45156},
	{4429, 45160},
	{4456, 45164},
	{58597, 45312},
	{58618, 45316, 1, 498},
	{58639, 45320},
	{58660, 45324, 1, 498},
	{5177, 45344},
	{5198, 45348, 1, 498},
	{5219, 45352, 12, 5839},
	{5243, 45356, 10, 5851},
	{5267, 45360},
	{5293, 45364},
	{5319, 45368},
	{5345, 45372},
	{5371, 45376},
	{5397, 45380},
	{5423, 45384},
	{5449, 45388},
	{5475, 45392},
	{5501, 45396},
	{5527, 45400},
	{5554, 45404},
	{5581, 45408},
	{5608, 45412},
	{5635, 45416},
	{5662, 45420},
	{58681, 45568},
	{58702, 45572, 1, 498},
	{58723, 45576},
	{58744, 45580, 1, 498},
	{6551, 45600},
	{6572, 45604, 1, 498},
	{6593, 45608, 11, 5861},
	{6617, 45612, 4, 5872},
	{6641, 45616},
	{6667, 45620},
	{6693, 45624},
	{6719, 45628},
	{6745, 45632},
	{6771, 45636},
	{6797, 45640},
	{6823, 45644},
	{6849, 45648},
	{6875, 45652},
	{6901, 45656},
	{6928, 45660},
	{6955, 45664},
	{6982, 45668},
	{7009, 45672},
	{7036, 45676},
	{58765, 45824},
	{58786, 45828, 1, 498},
	{58807, 45832},
	{58828, 45836, 1, 498},
	{7722, 45856},
	{7743, 45860, 1, 498},
	{7764, 45864, 12, 5839},
	{7788, 45868, 6, 5876},
	{7812, 45872},
	{7838, 45876},
	{7864, 45880},
	{7890, 45884},
	{7916, 45888},
	{7942, 45892},
	{7968, 45896},
	{7994, 45900},
	{8020, 45904},
	{8046, 45908},
	{8072, 45912},
	{8099, 45916},
	{8126, 45920},
	{8153, 45924},
	{8180, 45928},
	{8207, 45932},
	{58849, 46080},
	{58870, 46084, 1, 498},
	{58891, 46088},
	{58912, 46092, 1, 498},
	{8446, 46112},
	{8467, 46116, 1, 498},
	{8488, 46120, 10, 5882},
	{8512, 46124, 6, 5892},
	{8536, 46128},
	{8562, 46132},
	{8588, 46136},
	{8614, 46140},
	{8640, 46144},
	{8666, 46148},
	{8692, 46152},
	{8718, 46156},
	{8744, 46160},
	{8770, 46164},
	{8796, 46168},
	{8823, 46172},
	{8850, 46176},
	{8877, 46180},
	{8904, 46184},
	{8931, 46188},
	{58933, 46336},
	{58954, 46340, 1, 498},
	{58975, 46344},
	{58996, 46348, 1, 498},
	{9617, 46368},
	{9638, 46372, 1, 498},
	{9659, 46376, 11, 5898},
	{9683, 46380, 5, 5909},
	{9707, 46384},
	{9733, 46388},
	{9759, 46392},
	{9785, 46396},
	{9811, 46400},
	{9837, 46404},
	{9863, 46408},
	{9889, 46412},
	{9915, 46416},
	{9941, 46420},
	{9967, 46424},
	{9994, 46428},
	{10021, 46432},
	{10048, 46436},
	{10075, 46440},
	{10102, 46444},
	{10129, 47104, 12, 5914},
	{10156, 47108},
	{10170, 47112},
	{10184, 47116},
	{10198, 47120},
	{10214, 47124},
	{10230, 47128},
	{10246, 47132, 2, 666},
	{10267, 47136, 2, 666},
	{10288, 47140, 2, 666},
	{59017, 47148, 1, 5926},
	{10362, 47152},
	{10377, 47156, 2, 5927},
	{59037, 47160},
	{59052, 47164, 1, 670},
	{59067, 47168},
	{59082, 47172, 1, 670},
	{10516, 47176, 10, 5929},
	{10534, 47180, 11, 683},
	{10552, 47184, 1, 694},
	{10565, 47188, 7, 5939},
	{59097, 47192, 2, 5946},
	{59128, 47196, 2, 5946},
	{10643, 47200, 2, 701},
	{11118, 47360},
	{11138, 47364},
	{11158, 47368},
	{11178, 47372},
	{11198, 47376},
	{11218, 47380},
	{11238, 47384},
	{11258, 47388},
	{11278, 47392},
	{11298, 47396},
	{11318, 47400},
	{11339, 47404},
	{11360, 47408},
	{11381, 47412},
	{11402, 47416},
	{11423, 47420},
	{59159, 53300, 29, 5948},
	{59176, 55348, 29, 5948},
	{11505, 163840, 9, 726},
	{11523, 163844, 9, 5977},
	{11540, 163848, 4, 5986},
	{11554, 163852, 23, 754},
	{11573, 163856, 15, 777},
	{11593, 163860},
	{11629, 163872},
	{11649, 163876},
	{11669, 163880, 1, 795},
	{11686, 163884},
	{11701, 163888, 2, 796},
	{11725, 163892, 2, 798},
	{59193, 163900, 7, 5990},
	{11783, 163904, 8, 5997},
	{11793, 163908, 5, 6005},
	{11809, 163912},
	{11824, 163916},
	{11845, 163920},
	{11861, 163924},
	{59207, 163928, 2, 6010},
	{59221, 163932, 1, 6012},
	{12051, 163968},
	{12170, 164344},
	{12188, 164348},
	{12206, 164352, 2, 849},
	{12226, 164356, 3, 851},
	{12250, 164360, 2, 854},
	{12274, 164364, 1, 856},
	{12294, 164368, 2, 851},
	{12314, 164372, 2, 854},
	{12334, 164376, 2, 851},
	{12354, 164380, 2, 854},
	{12374, 164384, 2, 851},
	{12394, 164388, 2, 854},
	{12414, 164392, 2, 851},
	{12434, 164396, 2, 854},
	{12454, 164400, 7, 857},
	{12469, 164404, 2, 864},
	{12498, 164408, 8, 866},
	{12513, 164412, 8, 874},
	{12528, 164416, 3, 851},
	{12553, 164420, 2, 854},
	{12578, 164424},
	{12596, 164428},
	{12614, 164432, 3, 851},
	{12639, 164436, 2, 854},
	{12664, 164440, 3, 851},
	{12689, 164444, 2, 854},
	{12714, 164448, 3, 851},
	{12739, 164452, 2, 854},
	{12764, 164456, 3, 851},
	{12789, 164460, 2, 854},
	{12814, 164464, 3, 851},
	{12839, 164468, 2, 854},
	{12864, 164472, 3, 851},
	{12889, 164476, 2, 854},
	{12914, 164480, 3, 851},
	{12939, 164484, 2, 854},
	{12964, 164488, 3, 851},
	{12989, 164492, 2, 854},
	{13014, 164496, 3, 851},
	{13039, 164500, 2, 854},
	{13064, 164504, 3, 851},
	{13089, 164508, 2, 854},
	{13114, 164512, 3, 851},
	{13140, 164516, 2, 854},
	{13166, 164520, 3, 851},
	{13192, 164524, 2, 854},
	{13218, 164528, 3, 851},
	{13244, 164532, 2, 854},
	{13270, 164536, 3, 851},
	{13296, 164540, 2, 854},
	{13322, 164544, 3, 851},
	{13348, 164548, 2, 854},
	{13374, 164552, 3, 851},
	{13400, 164556, 2, 854},
	{13426, 164560},
	{13445, 164564},
	{13464, 164568},
	{13483, 164572},
	{13502, 164576},
	{13521, 164580},
	{13540, 164584},
	{13559, 164588},
	{13578, 164592},
	{13597, 164596},
	{13616, 164600},
	{13635, 164604},
	{13654, 164608},
	{13673, 164612},
	{13692, 164616},
	{13711, 164620},
	{13730, 164624},
	{13749, 164628},
	{13768, 164632},
	{13787, 164636},
	{13806, 164640},
	{13826, 164644},
	{13846, 164648},
	{13866, 164652},
	{13886, 164656},
	{13906, 164660},
	{13926, 164664},
	{13946, 164668},
	{13966, 164672},
	{13986, 164676},
	{14006, 164680},
	{14026, 164684},
	{14046, 164688, 15, 882},
	{14145, 164704, 1, 909},
	{59236, 164708, 1, 6013},
	{14176, 164712, 1, 911},
	{14244, 164864},
	{14261, 164868},
	{14278, 164872},
	{14294, 164876},
	{14348, 164884},
	{14361, 164888},
	{14376, 164892},
	{14390, 164896},
	{14444, 164908, 6, 942},
	{14463, 164912, 4, 948},
	{14481, 164916, 4, 952},
	{14502, 164924},
	{14521, 164928},
	{14541, 164932},
	{14560, 164936},
	{14580, 164940},
	{14599, 164944},
	{14619, 164948},
	{14640, 164952},
	{14662, 164956},
	{14683, 164960},
	{14705, 164964},
	{14726, 164968},
	{14748, 164972},
	{14769, 164976},
	{14791, 164980},
	{14812, 164984},
	{14834, 164988},
	{14855, 164992},
	{14877, 164996},
	{14898, 165000},
	{14920, 165004},
	{14941, 165008},
	{14963, 165012},
	{14984, 165016},
	{15006, 165020},
	{15027, 165024},
	{15049, 165028},
	{15070, 165032},
	{15092, 165036},
	{15113, 165040},
	{15135, 165044},
	{15156, 165048},
	{15178, 165052},
	{15199, 165056},
	{15221, 165060},
	{15242, 165064},
	{15264, 165068},
	{15285, 165072},
	{15307, 165076},
	{15328, 165080},
	{15350, 165084},
	{15371, 165088},
	{15393, 165092},
	{15414, 165096},
	{15436, 165100},
	{15457, 165104},
	{15479, 165108},
	{15500, 165112},
	{15522, 165116},
	{15543, 165120},
	{15565, 165124},
	{15586, 165128},
	{15608, 165132},
	{15629, 165136},
	{15651, 165140},
	{15672, 165144},
	{15694, 165148},
	{15715, 165152},
	{15737, 165156},
	{15758, 165160},
	{15780, 165164},
	{15802, 165168},
	{15825, 165172},
	{15847, 165176},
	{15870, 165180},
	{15892, 165184},
	{15915, 165188},
	{15937, 165192},
	{15960, 165196},
	{15982, 165200},
	{16005, 165204},
	{16027, 165208},
	{16050, 165212},
	{16072, 165216},
	{16095, 165220},
	{16117, 165224},
	{16140, 165228},
	{16162, 165232},
	{16185, 165236},
	{16207, 165240},
	{16230, 165244},
	{16252, 165248},
	{16275, 165252},
	{16297, 165256},
	{16320, 165260},
	{16342, 165264},
	{16365, 165268},
	{16387, 165272},
	{16410, 165276},
	{16432, 165280},
	{16455, 165284},
	{16477, 165288},
	{16500, 165292},
	{16522, 165296},
	{16545, 165300},
	{16567, 165304},
	{16590, 165308},
	{16604, 165312},
	{16618, 165316},
	{16632, 165320},
	{16646, 165324},
	{16660, 165328},
	{16674, 165332},
	{16688, 165336},
	{16702, 165340},
	{16716, 165344},
	{16730, 165348},
	{16744, 165352},
	{16758, 165356},
	{16772, 165360},
	{16786, 165364},
	{16800, 165368},
	{16814, 165372},
	{16828, 165376},
	{16842, 165380},
	{16856, 165384},
	{16870, 165388},
	{16884, 165392},
	{16898, 165396},
	{16912, 165400},
	{16949, 165444, 6, 956},
	{16969, 165448, 6, 956},
	{16989, 165452, 6, 956},
	{17009, 165456, 6, 956},
	{17029, 165460, 6, 956},
	{17049, 165464, 6, 956},
	{17069, 165468, 6, 956},
	{17089, 165472, 6, 956},
	{17109, 165476, 6, 956},
	{17129, 165480, 6, 956},
	{17149, 165484, 6, 956},
	{17170, 165488, 6, 956},
	{17191, 165492, 6, 956},
	{17212, 165496, 6, 956},
	{17233, 165500, 6, 956},
	{17254, 165504, 6, 956},
	{17275, 165508, 6, 956},
	{17296, 165512, 6, 956},
	{17317, 165516, 6, 956},
	{17338, 165520, 6, 956},
	{17359, 165524, 4, 968},
	{17380, 165528, 4, 968},
	{17401, 165532, 4, 968},
	{17422, 165536, 4, 968},
	{17443, 165540, 4, 968},
	{17464, 165544, 4, 968},
	{17485, 165548, 4, 968},
	{17506, 165552, 4, 968},
	{17527, 165556, 4, 968},
	{17548, 165560, 4, 968},
	{17569, 165564, 4, 968},
	{17590, 165568, 4, 968},
	{17611, 165572, 2, 977},
	{17629, 165580, 16, 980},
	{17646, 165584, 16, 980},
	{17664, 165588, 7, 996},
	{17685, 165592, 3, 6014},
	{17703, 165600, 7, 1009},
	{17718, 165608, 2, 701},
	{17757, 165644, 4, 1017},
	{17779, 165648, 1, 1022},
	{17799, 165652, 8, 1023},
	{18025, 165760, 9, 1070},
	{18043, 165764, 9, 1070},
	{18061, 165768, 9, 1070},
	{18079, 165772, 9, 1070},
	{18097, 165776, 9, 1070},
	{18115, 165780, 9, 1070},
	{18133, 165784, 9, 1070},
	{18151, 165788, 9, 1070},
	{18169, 165836, 1, 1079},
	{18183, 165840, 1, 1079},
	{18198, 165844},
	{18216, 165848},
	{18234, 165852},
	{18251, 165856},
	{18272, 165860, 1, 6017},
	{18288, 165864},
	{18301, 165872, 5, 1081},
	{18320, 165876},
	{18335, 165880, 1, 1089},
	{18384, 165888, 10, 1091},
	{18401, 165892, 12, 1101},
	{18409, 165896, 3, 6018},
	{18426, 165900, 12, 1117},
	{18444, 165904, 19, 1134},
	{18460, 165908, 13, 1154},
	{18479, 165912, 10, 1170},
	{18494, 165916, 26, 1180},
	{18512, 165920, 16, 1208},
	{18530, 165924, 4, 1224},
	{18554, 165928},
	{18579, 165932, 11, 1228},
	{18731, 166400, 2, 1260},
	{18748, 166404, 2, 1262},
	{18767, 166408, 1, 1264},
	{18783, 166412, 4, 1265},
	{18802, 166416, 1, 1269},
	{18823, 166420, 1, 1270},
	{18836, 166424},
	{18859, 166428},
	{18882, 166432, 1, 1271},
	{18902, 166436, 4, 6021},
	{18922, 166440, 1, 1276},
	{18943, 166444, 1, 1277},
	{18958, 166448, 6, 1278},
	{18980, 166452, 6, 1278},
	{19002, 166456, 8, 1284},
	{19028, 166460, 8, 1284},
	{19054, 166464, 15, 1292},
	{19085, 166472, 4, 1310},
	{19103, 166476, 24, 1317},
	{19121, 166480},
	{19133, 166484, 1, 1341},
	{19147, 166488, 1, 1342},
	{19161, 166492, 1, 1343},
	{19175, 166496, 1, 1344},
	{19198, 166500, 1, 1344},
	{19221, 166504, 1, 1344},
	{19244, 166508, 5, 6025},
	{19265, 166512},
	{19276, 166516},
	{19289, 166520},
	{19306, 166524, 7, 6030},
	{19336, 166532, 2, 1358},
	{19355, 166536},
	{19377, 166540},
	{19399, 166544, 3, 6037},
	{19419, 166548, 1, 1364},
	{19468, 166560},
	{19493, 166564},
	{19518, 166568, 6, 1371},
	{19537, 166572, 1, 1377},
	{19560, 166576, 1, 1377},
	{19583, 166580, 1, 1378},
	{19597, 166584, 1, 1379},
	{19612, 166588, 7, 6040},
	{19629, 166592, 4, 1389},
	{19656, 166596, 4, 1393},
	{19683, 166600, 4, 1397},
	{19702, 166608},
	{19728, 166612, 1, 1401},
	{19753, 166620},
	{19781, 166624},
	{19807, 166628, 1, 1401},
	{19832, 166636},
	{19860, 166640},
	{19886, 166644, 1, 1401},
	{19911, 166652},
	{19939, 166656},
	{19965, 166660, 1, 1401},
	{19990, 166668},
	{20018, 166696},
	{20049, 166700},
	{20092, 166704, 1, 1402},
	{20130, 166712, 1, 1403},
	{20191, 166740, 6, 1411},
	{20212, 166744, 3, 1430},
	{20229, 166748, 1, 1377},
	{20250, 166752, 1, 1377},
	{20273, 166756, 1, 1377},
	{20296, 166760, 1, 1377},
	{20319, 166764, 8, 6047},
	{20332, 166768, 6, 1445},
	{20373, 166776, 2, 1451},
	{20403, 166780},
	{20427, 166784},
	{20457, 166788},
	{20488, 166792},
	{20517, 166796},
	{20547, 166800, 2, 1453},
	{20567, 166804, 7, 6055},
	{20586, 166808, 4, 1464},
	{20636, 166868, 8, 1468},
	{20662, 166872, 8, 1476},
	{20688, 166876, 4, 1484},
	{20704, 166880, 5, 1489},
	{20720, 166884, 3, 1495},
	{20735, 166888},
	{20758, 166892},
	{20781, 166896},
	{20804, 166900},
	{20827, 166904, 8, 1498},
	{20861, 166908, 8, 1506},
	{20895, 166912, 8, 1514},
	{20929, 166916, 8, 1522},
	{20963, 166920, 8, 1498},
	{20997, 166924, 8, 1506},
	{21031, 166928, 8, 1514},
	{21065, 166932, 8, 1522},
	{21099, 166936, 8, 1498},
	{21133, 166940, 8, 1506},
	{21167, 166944, 8, 1514},
	{21201, 166948, 8, 1522},
	{21235, 166952, 8, 1498},
	{21269, 166956, 8, 1506},
	{21303, 166960, 8, 1514},
	{21337, 166964, 8, 1522},
	{21371, 166968, 2, 1530},
	{21395, 166972, 2, 1532},
	{21538, 167000, 1, 1574},
	{21566, 167004, 1, 1575},
	{21587, 167008},
	{21602, 167012, 2, 1576},
	{21618, 167016, 1, 1578},
	{21634, 167020, 2, 5986},
	{21649, 167024, 15, 6062},
	{21664, 167028, 6, 1601},
	{21703, 167036},
	{21719, 167040, 1, 1621},
	{21741, 167044},
	{21757, 167048, 1, 1578},
	{21779, 167052},
	{21801, 167056},
	{21842, 167068},
	{21857, 167072, 2, 1576},
	{21873, 167076, 1, 1578},
	{21889, 167080, 2, 5986},
	{21904, 167084, 15, 6062},
	{21919, 167088, 6, 1601},
	{21958, 167096},
	{21974, 167100, 1, 1621},
	{21996, 167104},
	{22012, 167108, 1, 1578},
	{22034, 167112},
	{22056, 167116},
	{22097, 167128},
	{22112, 167132, 2, 1576},
	{22128, 167136, 1, 1578},
	{22144, 167140, 2, 5986},
	{22159, 167144, 15, 6062},
	{22174, 167148, 6, 1601},
	{22213, 167156},
	{22229, 167160, 1, 1621},
	{22251, 167164},
	{22267, 167168, 1, 1578},
	{22289, 167172},
	{22311, 167176},
	{22352, 167188},
	{22367, 167192, 2, 1576},
	{22383, 167196, 1, 1578},
	{22399, 167200, 2, 5986},
	{22414, 167204, 15, 6062},
	{22429, 167208, 6, 1601},
	{22468, 167216},
	{22484, 167220, 1, 1621},
	{22506, 167224},
	{22522, 167228, 1, 1578},
	{22544, 167232},
	{22566, 167236},
	{22607, 167248},
	{22622, 167252, 2, 1576},
	{22638, 167256, 1, 1578},
	{22654, 167260, 2, 5986},
	{22669, 167264, 15, 6062},
	{22684, 167268, 6, 1601},
	{22723, 167276},
	{22739, 167280, 1, 1621},
	{22761, 167284},
	{22777, 167288, 1, 1578},
	{22799, 167292},
	{22821, 167296},
	{22862, 167308},
	{22877, 167312, 2, 1576},
	{22893, 167316, 1, 1578},
	{22909, 167320, 2, 5986},
	{22924, 167324, 15, 6062},
	{22939, 167328, 6, 1601},
	{22978, 167336},
	{22994, 167340, 1, 1621},
	{23016, 167344},
	{23032, 167348, 1, 1578},
	{23054, 167352},
	{23076, 167356},
	{23117, 167368},
	{23132, 167372, 2, 1576},
	{23148, 167376, 1, 1578},
	{23164, 167380, 2, 5986},
	{23179, 167384, 15, 6062},
	{23194, 167388, 6, 1601},
	{23233, 167396},
	{23249, 167400, 1, 1621},
	{23271, 167404},
	{23287, 167408, 1, 1578},
	{23309, 167412},
	{23331, 167416},
	{23372, 167428},
	{23387, 167432, 2, 1576},
	{23403, 167436, 1, 1578},
	{23419, 167440, 2, 5986},
	{23434, 167444, 15, 6062},
	{23449, 167448, 6, 1601},
	{23488, 167456},
	{23504, 167460, 1, 1621},
	{23526, 167464},
	{23542, 167468, 1, 1578},
	{23564, 167472},
	{23586, 167476},
	{206, 880, 4, 6077},
	{43232, 881},
	{27079, 882},
	{43244, 1008},
	{43255, 1009},
	{27267, 1010, 4, 2167},
	{43266, 1040, 1, 2171},
	{43279, 1041, 5, 6081},
	{43292, 1042, 1, 2177},
	{43305, 1043, 1, 1688},
	{27101, 1045, 9, 6086},
	{43333, 1281, 4, 6095},
	{43348, 1282},
	{27038, 1283},
	{43232, 1285},
	{27079, 1286},
};

static const struct si_reg gfx7_reg_table[] = {
	{1390, 68, 9, 6099},
	{1403, 72, 24, 4937},
	{1418, 76, 3, 6108},
	{55593, 80, 11, 6111},
	{1455, 84, 4, 4975},
	{1473, 88, 2, 3924},
	{1491, 92, 4, 6122},
	{1506, 96},
	{1520, 100, 1, 4983},
	{1534, 104},
	{55607, 108},
	{55624, 112, 13, 4984},
	{55640, 2480},
	{55655, 2484, 1, 4997},
	{55670, 2488},
	{55685, 2492, 1, 4997},
	{1689, 2496},
	{1703, 2500},
	{1717, 2504},
	{1731, 2508},
	{1745, 2512},
	{1759, 2516},
	{1773, 2520},
	{1787, 2524},
	{1801, 2528},
	{1815, 2532},
	{1829, 2536},
	{1844, 2540},
	{1919, 2544},
	{1930, 2552},
	{1946, 2556},
	{55700, 3660, 21, 4998},
	{55713, 3664, 20, 5019},
	{55725, 3668, 16, 5039},
	{2034, 32776, 17, 6126},
	{2047, 32784, 24, 5077},
	{2059, 32788, 11, 5101},
	{2075, 32792, 11, 5101},
	{2104, 32824, 11, 5101},
	{2120, 32828, 11, 5101},
	{2136, 33296, 16, 6143},
	{2150, 33300, 28, 204},
	{2167, 33304, 17, 6159},
	{2188, 33308, 18, 6176},
	{2202, 33312, 31, 6194},
	{2219, 33316, 7, 6225},
	{59246, 33320, 1, 5375},
	{2258, 33324, 1, 329},
	{2281, 33344, 1, 1711},
	{2302, 33348},
	{2363, 33436, 1, 342},
	{58190, 36352},
	{58211, 36356, 1, 4849},
	{2511, 36360, 9, 6232},
	{2532, 36364, 3, 5687},
	{58232, 36368, 2, 5690},
	{59261, 36372, 2, 6241},
	{59283, 36376, 1, 6243},
	{2490, 36400, 2, 5692},
	{2580, 36404, 5, 6244},
	{58258, 36408, 15, 5699},
	{2559, 36412, 1, 5714},
	{58279, 36416},
	{58300, 36424, 1, 5715},
	{2767, 36608},
	{2785, 36612, 4, 383},
	{2803, 36616},
	{2821, 36620, 14, 5740},
	{3722, 36624},
	{3740, 36628, 5, 5754},
	{3758, 36632, 4, 5759},
	{3776, 36636, 11, 5763},
	{3794, 36640, 2, 5774},
	{3812, 36644, 2, 5776},
	{3830, 36648, 4, 5778},
	{3848, 36652},
	{2839, 36656, 13, 5782},
	{2857, 36660, 4, 411},
	{2875, 36664, 9, 5795},
	{2893, 36668, 3, 5804},
	{2911, 37120, 6, 426},
	{2927, 39160, 9, 5807},
	{2942, 39184, 5, 5817},
	{2956, 39188, 5, 5817},
	{2970, 39192, 5, 5817},
	{2984, 39196, 5, 5817},
	{2998, 39200, 5, 5817},
	{3012, 39204, 5, 5817},
	{3026, 39208, 5, 5817},
	{3040, 39212, 5, 5817},
	{3054, 39216, 5, 5817},
	{3068, 39220, 5, 5817},
	{3082, 39224, 5, 5817},
	{3097, 39228, 5, 5817},
	{3112, 39232, 5, 5817},
	{3127, 39236, 5, 5817},
	{3142, 39240, 5, 5817},
	{3157, 39244, 5, 5817},
	{3172, 39248, 5, 5817},
	{3187, 39252, 5, 5817},
	{3202, 39256, 5, 5817},
	{3217, 39260, 5, 5817},
	{3232, 39264, 5, 5817},
	{3247, 39268, 5, 5817},
	{3262, 39272, 5, 5817},
	{3277, 39276, 5, 5817},
	{3292, 39280, 5, 5817},
	{3307, 39284, 5, 5817},
	{3322, 39288, 5, 5817},
	{3337, 39292, 5, 5817},
	{3352, 39296, 5, 5817},
	{3367, 39300, 5, 5817},
	{3382, 39304, 5, 5817},
	{3397, 39308, 5, 5817},
	{3412, 39312, 4, 445},
	{3431, 39316, 4, 445},
	{3450, 39320, 4, 445},
	{3469, 39324, 4, 445},
	{3488, 39328, 4, 445},
	{3507, 39332, 4, 445},
	{3526, 39336, 4, 445},
	{3545, 39340, 4, 445},
	{3564, 39344, 4, 445},
	{3583, 39348, 4, 445},
	{3602, 39352, 4, 445},
	{3622, 39356, 4, 445},
	{3642, 39360, 4, 445},
	{3662, 39364, 4, 445},
	{3682, 39368, 4, 445},
	{3702, 39372, 4, 445},
	{58513, 45056},
	{58534, 45060, 1, 498},
	{58555, 45064},
	{58576, 45068, 1, 498},
	{3947, 45084, 3, 495},
	{3971, 45088},
	{3992, 45092, 1, 498},
	{4013, 45096, 11, 5822},
	{4037, 45100, 6, 510},
	{4061, 45104},
	{4087, 45108},
	{4113, 45112},
	{4139, 45116},
	{4165, 45120},
	{4191, 45124},
	{4217, 45128},
	{4243, 45132},
	{4269, 45136},
	{4295, 45140},
	{4321, 45144},
	{4348, 45148},
	{4375, 45152},
	{4402, 45156},
	{4429, 45160},
	{4456, 45164},
	{58597, 45312},
	{58618, 45316, 1, 498},
	{58639, 45320},
	{58660, 45324, 1, 498},
	{5128, 45336, 3, 495},
	{5152, 45340, 1, 534},
	{5177, 45344},
	{5198, 45348, 1, 498},
	{5219, 45352, 12, 5839},
	{5243, 45356, 10, 547},
	{5267, 45360},
	{5293, 45364},
	{5319, 45368},
	{5345, 45372},
	{5371, 45376},
	{5397, 45380},
	{5423, 45384},
	{5449, 45388},
	{5475, 45392},
	{5501, 45396},
	{5527, 45400},
	{5554, 45404},
	{5581, 45408},
	{5608, 45412},
	{5635, 45416},
	{5662, 45420},
	{6312, 45552, 6, 570},
	{6339, 45556, 5, 576},
	{58681, 45568},
	{58702, 45572, 1, 498},
	{58723, 45576},
	{58744, 45580, 1, 498},
	{6527, 45596, 3, 495},
	{6551, 45600},
	{6572, 45604, 1, 498},
	{6593, 45608, 11, 5861},
	{6617, 45612, 4, 561},
	{6641, 45616},
	{6667, 45620},
	{6693, 45624},
	{6719, 45628},
	{6745, 45632},
	{6771, 45636},
	{6797, 45640},
	{6823, 45644},
	{6849, 45648},
	{6875, 45652},
	{6901, 45656},
	{6928, 45660},
	{6955, 45664},
	{6982, 45668},
	{7009, 45672},
	{7036, 45676},
	{7671, 45808, 6, 570},
	{58765, 45824},
	{58786, 45828, 1, 498},
	{58807, 45832},
	{58828, 45836, 1, 498},
	{7698, 45852, 3, 495},
	{7722, 45856},
	{7743, 45860, 1, 498},
	{7764, 45864, 12, 5839},
	{7788, 45868, 6, 570},
	{7812, 45872},
	{7838, 45876},
	{7864, 45880},
	{7890, 45884},
	{7916, 45888},
	{7942, 45892},
	{7968, 45896},
	{7994, 45900},
	{8020, 45904},
	{8046, 45908},
	{8072, 45912},
	{8099, 45916},
	{8126, 45920},
	{8153, 45924},
	{8180, 45928},
	{8207, 45932},
	{8234, 46068, 5, 576},
	{58849, 46080},
	{58870, 46084, 1, 498},
	{58891, 46088},
	{58912, 46092, 1, 498},
	{8422, 46108, 2, 619},
	{8446, 46112},
	{8467, 46116, 1, 498},
	{8488, 46120, 10, 5882},
	{8512, 46124, 6, 635},
	{8536, 46128},
	{8562, 46132},
	{8588, 46136},
	{8614, 46140},
	{8640, 46144},
	{8666, 46148},
	{8692, 46152},
	{8718, 46156},
	{8744, 46160},
	{8770, 46164},
	{8796, 46168},
	{8823, 46172},
	{8850, 46176},
	{8877, 46180},
	{8904, 46184},
	{8931, 46188},
	{9566, 46324, 5, 576},
	{58933, 46336},
	{58954, 46340, 1, 498},
	{58975, 46344},
	{58996, 46348, 1, 498},
	{9593, 46364, 3, 495},
	{9617, 46368},
	{9638, 46372, 1, 498},
	{9659, 46376, 11, 5898},
	{9683, 46380, 5, 576},
	{9707, 46384},
	{9733, 46388},
	{9759, 46392},
	{9785, 46396},
	{9811, 46400},
	{9837, 46404},
	{9863, 46408},
	{9889, 46412},
	{9915, 46416},
	{9941, 46420},
	{9967, 46424},
	{9994, 46428},
	{10021, 46432},
	{10048, 46436},
	{10075, 46440},
	{10102, 46444},
	{10129, 47104, 12, 5914},
	{10156, 47108},
	{10170, 47112},
	{10184, 47116},
	{10198, 47120},
	{10214, 47124},
	{10230, 47128},
	{10246, 47132, 2, 666},
	{10267, 47136, 2, 666},
	{10288, 47140, 2, 666},
	{10309, 47144, 1, 668},
	{10337, 47148, 1, 669},
	{10362, 47152},
	{10377, 47156, 2, 5927},
	{59037, 47160},
	{59052, 47164, 1, 670},
	{59067, 47168},
	{59082, 47172, 1, 670},
	{10516, 47176, 10, 5929},
	{10534, 47180, 11, 683},
	{10552, 47184, 1, 694},
	{10565, 47188, 6, 695},
	{59097, 47192, 2, 5946},
	{59128, 47196, 2, 5946},
	{10643, 47200, 2, 701},
	{59311, 47204, 2, 5946},
	{59342, 47208, 2, 5946},
	{10718, 47212},
	{10736, 47216},
	{10754, 47220},
	{10772, 47224, 1, 703},
	{10800, 47228, 4, 704},
	{11118, 47360},
	{11138, 47364},
	{11158, 47368},
	{11178, 47372},
	{11198, 47376},
	{11218, 47380},
	{11238, 47384},
	{11258, 47388},
	{11278, 47392},
	{11298, 47396},
	{11318, 47400},
	{11339, 47404},
	{11360, 47408},
	{11381, 47412},
	{11402, 47416},
	{11423, 47420},
	{59159, 53300, 29, 5948},
	{59176, 55348, 29, 5948},
	{11505, 163840, 9, 726},
	{11523, 163844, 9, 5977},
	{11540, 163848, 4, 5986},
	{11554, 163852, 23, 754},
	{11573, 163856, 15, 777},
	{11593, 163860},
	{11629, 163872},
	{11649, 163876},
	{11669, 163880, 1, 795},
	{11686, 163884},
	{11701, 163888, 2, 796},
	{11725, 163892, 2, 798},
	{59193, 163900, 7, 5990},
	{11783, 163904, 8, 5997},
	{11793, 163908, 5, 6005},
	{11809, 163912},
	{11824, 163916},
	{11845, 163920},
	{11861, 163924},
	{59207, 163928, 2, 6010},
	{59221, 163932, 1, 6012},
	{12051, 163968},
	{12067, 163972, 1, 847},
	{12086, 164328, 1, 848},
	{12107, 164332, 1, 848},
	{12128, 164336, 1, 848},
	{12149, 164340, 1, 848},
	{12170, 164344},
	{12188, 164348},
	{12206, 164352, 2, 849},
	{12226, 164356, 3, 851},
	{12250, 164360, 2, 854},
	{12274, 164364, 1, 856},
	{12294, 164368, 2, 851},
	{12314, 164372, 2, 854},
	{12334, 164376, 2, 851},
	{12354, 164380, 2, 854},
	{12374, 164384, 2, 851},
	{12394, 164388, 2, 854},
	{12414, 164392, 2, 851},
	{12434, 164396, 2, 854},
	{12454, 164400, 7, 857},
	{12469, 164404, 2, 864},
	{12498, 164408, 8, 866},
	{12513, 164412, 8, 874},
	{12528, 164416, 3, 851},
	{12553, 164420, 2, 854},
	{12578, 164424},
	{12596, 164428},
	{12614, 164432, 3, 851},
	{12639, 164436, 2, 854},
	{12664, 164440, 3, 851},
	{12689, 164444, 2, 854},
	{12714, 164448, 3, 851},
	{12739, 164452, 2, 854},
	{12764, 164456, 3, 851},
	{12789, 164460, 2, 854},
	{12814, 164464, 3, 851},
	{12839, 164468, 2, 854},
	{12864, 164472, 3, 851},
	{12889, 164476, 2, 854},
	{12914, 164480, 3, 851},
	{12939, 164484, 2, 854},
	{12964, 164488, 3, 851},
	{12989, 164492, 2, 854},
	{13014, 164496, 3, 851},
	{13039, 164500, 2, 854},
	{13064, 164504, 3, 851},
	{13089, 164508, 2, 854},
	{13114, 164512, 3, 851},
	{13140, 164516, 2, 854},
	{13166, 164520, 3, 851},
	{13192, 164524, 2, 854},
	{13218, 164528, 3, 851},
	{13244, 164532, 2, 854},
	{13270, 164536, 3, 851},
	{13296, 164540, 2, 854},
	{13322, 164544, 3, 851},
	{13348, 164548, 2, 854},
	{13374, 164552, 3, 851},
	{13400, 164556, 2, 854},
	{13426, 164560},
	{13445, 164564},
	{13464, 164568},
	{13483, 164572},
	{13502, 164576},
	{13521, 164580},
	{13540, 164584},
	{13559, 164588},
	{13578, 164592},
	{13597, 164596},
	{13616, 164600},
	{13635, 164604},
	{13654, 164608},
	{13673, 164612},
	{13692, 164616},
	{13711, 164620},
	{13730, 164624},
	{13749, 164628},
	{13768, 164632},
	{13787, 164636},
	{13806, 164640},
	{13826, 164644},
	{13846, 164648},
	{13866, 164652},
	{13886, 164656},
	{13906, 164660},
	{13926, 164664},
	{13946, 164668},
	{13966, 164672},
	{13986, 164676},
	{14006, 164680},
	{14026, 164684},
	{14046, 164688, 15, 882},
	{14066, 164692, 3, 897},
	{14088, 164696, 2, 900},
	{14145, 164704, 1, 909},
	{59236, 164708, 1, 6013},
	{14176, 164712, 1, 911},
	{14244, 164864},
	{14261, 164868},
	{14278, 164872},
	{14294, 164876},
	{14348, 164884},
	{14361, 164888},
	{14376, 164892},
	{14390, 164896},
	{14444, 164908, 6, 942},
	{14463, 164912, 4, 948},
	{14481, 164916, 4, 952},
	{14502, 164924},
	{14521, 164928},
	{14541, 164932},
	{14560, 164936},
	{14580, 164940},
	{14599, 164944},
	{14619, 164948},
	{14640, 164952},
	{14662, 164956},
	{14683, 164960},
	{14705, 164964},
	{14726, 164968},
	{14748, 164972},
	{14769, 164976},
	{14791, 164980},
	{14812, 164984},
	{14834, 164988},
	{14855, 164992},
	{14877, 164996},
	{14898, 165000},
	{14920, 165004},
	{14941, 165008},
	{14963, 165012},
	{14984, 165016},
	{15006, 165020},
	{15027, 165024},
	{15049, 165028},
	{15070, 165032},
	{15092, 165036},
	{15113, 165040},
	{15135, 165044},
	{15156, 165048},
	{15178, 165052},
	{15199, 165056},
	{15221, 165060},
	{15242, 165064},
	{15264, 165068},
	{15285, 165072},
	{15307, 165076},
	{15328, 165080},
	{15350, 165084},
	{15371, 165088},
	{15393, 165092},
	{15414, 165096},
	{15436, 165100},
	{15457, 165104},
	{15479, 165108},
	{15500, 165112},
	{15522, 165116},
	{15543, 165120},
	{15565, 165124},
	{15586, 165128},
	{15608, 165132},
	{15629, 165136},
	{15651, 165140},
	{15672, 165144},
	{15694, 165148},
	{15715, 165152},
	{15737, 165156},
	{15758, 165160},
	{15780, 165164},
	{15802, 165168},
	{15825, 165172},
	{15847, 165176},
	{15870, 165180},
	{15892, 165184},
	{15915, 165188},
	{15937, 165192},
	{15960, 165196},
	{15982, 165200},
	{16005, 165204},
	{16027, 165208},
	{16050, 165212},
	{16072, 165216},
	{16095, 165220},
	{16117, 165224},
	{16140, 165228},
	{16162, 165232},
	{16185, 165236},
	{16207, 165240},
	{16230, 165244},
	{16252, 165248},
	{16275, 165252},
	{16297, 165256},
	{16320, 165260},
	{16342, 165264},
	{16365, 165268},
	{16387, 165272},
	{16410, 165276},
	{16432, 165280},
	{16455, 165284},
	{16477, 165288},
	{16500, 165292},
	{16522, 165296},
	{16545, 165300},
	{16567, 165304},
	{16590, 165308},
	{16604, 165312},
	{16618, 165316},
	{16632, 165320},
	{16646, 165324},
	{16660, 165328},
	{16674, 165332},
	{16688, 165336},
	{16702, 165340},
	{16716, 165344},
	{16730, 165348},
	{16744, 165352},
	{16758, 165356},
	{16772, 165360},
	{16786, 165364},
	{16800, 165368},
	{16814, 165372},
	{16828, 165376},
	{16842, 165380},
	{16856, 165384},
	{16870, 165388},
	{16884, 165392},
	{16898, 165396},
	{16912, 165400},
	{16949, 165444, 6, 956},
	{16969, 165448, 6, 956},
	{16989, 165452, 6, 956},
	{17009, 165456, 6, 956},
	{17029, 165460, 6, 956},
	{17049, 165464, 6, 956},
	{17069, 165468, 6, 956},
	{17089, 165472, 6, 956},
	{17109, 165476, 6, 956},
	{17129, 165480, 6, 956},
	{17149, 165484, 6, 956},
	{17170, 165488, 6, 956},
	{17191, 165492, 6, 956},
	{17212, 165496, 6, 956},
	{17233, 165500, 6, 956},
	{17254, 165504, 6, 956},
	{17275, 165508, 6, 956},
	{17296, 165512, 6, 956},
	{17317, 165516, 6, 956},
	{17338, 165520, 6, 956},
	{17359, 165524, 4, 968},
	{17380, 165528, 4, 968},
	{17401, 165532, 4, 968},
	{17422, 165536, 4, 968},
	{17443, 165540, 4, 968},
	{17464, 165544, 4, 968},
	{17485, 165548, 4, 968},
	{17506, 165552, 4, 968},
	{17527, 165556, 4, 968},
	{17548, 165560, 4, 968},
	{17569, 165564, 4, 968},
	{17590, 165568, 4, 968},
	{17611, 165572, 2, 977},
	{17629, 165580, 16, 980},
	{17646, 165584, 16, 980},
	{17664, 165588, 7, 996},
	{17685, 165592, 3, 6014},
	{17703, 165600, 7, 1009},
	{17718, 165608, 2, 701},
	{17757, 165644, 4, 1017},
	{17779, 165648, 1, 1022},
	{17799, 165652, 8, 1023},
	{18025, 165760, 9, 1070},
	{18043, 165764, 9, 1070},
	{18061, 165768, 9, 1070},
	{18079, 165772, 9, 1070},
	{18097, 165776, 9, 1070},
	{18115, 165780, 9, 1070},
	{18133, 165784, 9, 1070},
	{18151, 165788, 9, 1070},
	{18169, 165836, 1, 1079},
	{18183, 165840, 1, 1079},
	{18198, 165844},
	{18216, 165848},
	{18234, 165852},
	{18251, 165856},
	{18272, 165860, 1, 6017},
	{18288, 165864},
	{18301, 165872, 5, 1081},
	{18320, 165876},
	{18335, 165880, 1, 1089},
	{18384, 165888, 10, 1091},
	{18401, 165892, 12, 1101},
	{18409, 165896, 3, 6018},
	{18426, 165900, 12, 1117},
	{18444, 165904, 19, 1134},
	{18460, 165908, 13, 1154},
	{18479, 165912, 10, 1170},
	{18494, 165916, 26, 1180},
	{18512, 165920, 16, 1208},
	{18530, 165924, 4, 1224},
	{18554, 165928},
	{18579, 165932, 11, 1228},
	{18731, 166400, 2, 1260},
	{18748, 166404, 2, 1262},
	{18767, 166408, 1, 1264},
	{18783, 166412, 4, 1265},
	{18802, 166416, 1, 1269},
	{18823, 166420, 1, 1270},
	{18836, 166424},
	{18859, 166428},
	{18882, 166432, 1, 1271},
	{18902, 166436, 4, 6021},
	{18922, 166440, 1, 1276},
	{18943, 166444, 1, 1277},
	{18958, 166448, 6, 1278},
	{18980, 166452, 6, 1278},
	{19002, 166456, 8, 1284},
	{19028, 166460, 8, 1284},
	{19054, 166464, 15, 1292},
	{19066, 166468, 2, 1307},
	{19085, 166472, 4, 1310},
	{19103, 166476, 24, 1317},
	{19121, 166480},
	{19133, 166484, 1, 1341},
	{19147, 166488, 1, 1342},
	{19161, 166492, 1, 1343},
	{19175, 166496, 1, 1344},
	{19198, 166500, 1, 1344},
	{19221, 166504, 1, 1344},
	{19244, 166508, 5, 6025},
	{19265, 166512},
	{19276, 166516},
	{19289, 166520},
	{19306, 166524, 7, 6030},
	{19325, 166528},
	{19336, 166532, 2, 1358},
	{19355, 166536},
	{19377, 166540},
	{19399, 166544, 3, 6037},
	{19419, 166548, 1, 1364},
	{19468, 166560},
	{19493, 166564},
	{19518, 166568, 6, 1371},
	{19537, 166572, 1, 1377},
	{19560, 166576, 1, 1377},
	{19583, 166580, 1, 1378},
	{19597, 166584, 1, 1379},
	{19612, 166588, 7, 6040},
	{19629, 166592, 4, 1389},
	{19656, 166596, 4, 1393},
	{19683, 166600, 4, 1397},
	{19702, 166608},
	{19728, 166612, 1, 1401},
	{19753, 166620},
	{19781, 166624},
	{19807, 166628, 1, 1401},
	{19832, 166636},
	{19860, 166640},
	{19886, 166644, 1, 1401},
	{19911, 166652},
	{19939, 166656},
	{19965, 166660, 1, 1401},
	{19990, 166668},
	{20018, 166696},
	{20049, 166700},
	{20092, 166704, 1, 1402},
	{20130, 166712, 1, 1403},
	{20191, 166740, 6, 1411},
	{20212, 166744, 3, 1430},
	{20229, 166748, 1, 1377},
	{20250, 166752, 1, 1377},
	{20273, 166756, 1, 1377},
	{20296, 166760, 1, 1377},
	{20319, 166764, 8, 6047},
	{20332, 166768, 6, 1445},
	{20349, 166772},
	{20373, 166776, 2, 1451},
	{20403, 166780},
	{20427, 166784},
	{20457, 166788},
	{20488, 166792},
	{20517, 166796},
	{20547, 166800, 2, 1453},
	{20567, 166804, 7, 6055},
	{20586, 166808, 4, 1464},
	{20636, 166868, 8, 1468},
	{20662, 166872, 8, 1476},
	{20688, 166876, 4, 1484},
	{20704, 166880, 5, 1489},
	{20720, 166884, 3, 1495},
	{20735, 166888},
	{20758, 166892},
	{20781, 166896},
	{20804, 166900},
	{20827, 166904, 8, 1498},
	{20861, 166908, 8, 1506},
	{20895, 166912, 8, 1514},
	{20929, 166916, 8, 1522},
	{20963, 166920, 8, 1498},
	{20997, 166924, 8, 1506},
	{21031, 166928, 8, 1514},
	{21065, 166932, 8, 1522},
	{21099, 166936, 8, 1498},
	{21133, 166940, 8, 1506},
	{21167, 166944, 8, 1514},
	{21201, 166948, 8, 1522},
	{21235, 166952, 8, 1498},
	{21269, 166956, 8, 1506},
	{21303, 166960, 8, 1514},
	{21337, 166964, 8, 1522},
	{21371, 166968, 2, 1530},
	{21395, 166972, 2, 1532},
	{21538, 167000, 1, 1574},
	{21566, 167004, 1, 1575},
	{21587, 167008},
	{21602, 167012, 2, 1576},
	{21618, 167016, 1, 1578},
	{21634, 167020, 2, 5986},
	{21649, 167024, 15, 6062},
	{21664, 167028, 6, 1601},
	{21703, 167036},
	{21719, 167040, 1, 1621},
	{21741, 167044},
	{21757, 167048, 1, 1578},
	{21779, 167052},
	{21801, 167056},
	{21842, 167068},
	{21857, 167072, 2, 1576},
	{21873, 167076, 1, 1578},
	{21889, 167080, 2, 5986},
	{21904, 167084, 15, 6062},
	{21919, 167088, 6, 1601},
	{21958, 167096},
	{21974, 167100, 1, 1621},
	{21996, 167104},
	{22012, 167108, 1, 1578},
	{22034, 167112},
	{22056, 167116},
	{22097, 167128},
	{22112, 167132, 2, 1576},
	{22128, 167136, 1, 1578},
	{22144, 167140, 2, 5986},
	{22159, 167144, 15, 6062},
	{22174, 167148, 6, 1601},
	{22213, 167156},
	{22229, 167160, 1, 1621},
	{22251, 167164},
	{22267, 167168, 1, 1578},
	{22289, 167172},
	{22311, 167176},
	{22352, 167188},
	{22367, 167192, 2, 1576},
	{22383, 167196, 1, 1578},
	{22399, 167200, 2, 5986},
	{22414, 167204, 15, 6062},
	{22429, 167208, 6, 1601},
	{22468, 167216},
	{22484, 167220, 1, 1621},
	{22506, 167224},
	{22522, 167228, 1, 1578},
	{22544, 167232},
	{22566, 167236},
	{22607, 167248},
	{22622, 167252, 2, 1576},
	{22638, 167256, 1, 1578},
	{22654, 167260, 2, 5986},
	{22669, 167264, 15, 6062},
	{22684, 167268, 6, 1601},
	{22723, 167276},
	{22739, 167280, 1, 1621},
	{22761, 167284},
	{22777, 167288, 1, 1578},
	{22799, 167292},
	{22821, 167296},
	{22862, 167308},
	{22877, 167312, 2, 1576},
	{22893, 167316, 1, 1578},
	{22909, 167320, 2, 5986},
	{22924, 167324, 15, 6062},
	{22939, 167328, 6, 1601},
	{22978, 167336},
	{22994, 167340, 1, 1621},
	{23016, 167344},
	{23032, 167348, 1, 1578},
	{23054, 167352},
	{23076, 167356},
	{23117, 167368},
	{23132, 167372, 2, 1576},
	{23148, 167376, 1, 1578},
	{23164, 167380, 2, 5986},
	{23179, 167384, 15, 6062},
	{23194, 167388, 6, 1601},
	{23233, 167396},
	{23249, 167400, 1, 1621},
	{23271, 167404},
	{23287, 167408, 1, 1578},
	{23309, 167412},
	{23331, 167416},
	{23372, 167428},
	{23387, 167432, 2, 1576},
	{23403, 167436, 1, 1578},
	{23419, 167440, 2, 5986},
	{23434, 167444, 15, 6062},
	{23449, 167448, 6, 1601},
	{23488, 167456},
	{23504, 167460, 1, 1621},
	{23526, 167464},
	{23542, 167468, 1, 1578},
	{23564, 167472},
	{23586, 167476},
	{24651, 196608, 2, 5204},
	{24671, 196612, 1, 1635},
	{24691, 196616},
	{24711, 196620},
	{24731, 196624},
	{24752, 196628},
	{24773, 196632, 2, 5206},
	{24795, 196636, 1, 1637},
	{24817, 196640},
	{24847, 196644},
	{24877, 196648},
	{24906, 196652},
	{24935, 196656},
	{24965, 196660},
	{24995, 196664},
	{25024, 196668},
	{25053, 196672},
	{25083, 196676},
	{25113, 196680},
	{25142, 196684},
	{25171, 196688},
	{25201, 196692},
	{25231, 196696},
	{25260, 196700},
	{25289, 196704, 2, 5208},
	{25311, 196708, 1, 1639},
	{25333, 196712},
	{25356, 196716},
	{25379, 196720},
	{25402, 196724},
	{25425, 196728},
	{25448, 196732},
	{25471, 196736},
	{25495, 196740},
	{25519, 196744},
	{25543, 196748},
	{25567, 196752},
	{25591, 196756},
	{25615, 196760},
	{25639, 196764},
	{25663, 196768},
	{25685, 196772},
	{25707, 196776},
	{25728, 196780},
	{25749, 196784},
	{25773, 196788},
	{25797, 196792},
	{25821, 196796},
	{25845, 196800},
	{25869, 196804},
	{25997, 196860, 1, 1642},
	{26013, 196864},
	{26026, 196868},
	{26039, 196872},
	{26052, 196876},
	{26065, 196880},
	{26078, 196884},
	{26091, 196888},
	{26104, 196892},
	{26231, 196928, 2, 1643},
	{26244, 196932},
	{26257, 196936},
	{26280, 196940},
	{26303, 196944},
	{26331, 196948},
	{26359, 196952},
	{26387, 196956},
	{26415, 196960, 1, 1645},
	{26433, 196964, 3, 6249},
	{26451, 196968},
	{26466, 196972},
	{26490, 196976},
	{26514, 196980},
	{26533, 196984},
	{26552, 196988},
	{26576, 196992},
	{26600, 196996},
	{26624, 197000},
	{26648, 197028, 2, 5213},
	{26666, 197032, 1, 1651},
	{26684, 197036},
	{26702, 197040},
	{26720, 197044, 2, 5216},
	{26738, 197048, 1, 1654},
	{26756, 197052},
	{26774, 197056, 2, 1656},
	{26793, 197060, 5, 1658},
	{26812, 197072},
	{26836, 197076, 2, 1656},
	{26856, 197080, 5, 1658},
	{26876, 197084, 8, 6252},
	{26895, 197088, 8, 6252},
	{26913, 197092, 1, 1670},
	{26930, 197100, 1, 1671},
	{26951, 197104, 23, 5224},
	{26965, 197108},
	{26979, 197112},
	{26993, 197116, 4, 5247},
	{27009, 197120},
	{27028, 197124, 1, 1687},
	{27050, 197128},
	{27069, 197132, 1, 1688},
	{27091, 197136, 9, 5253},
	{27109, 197140},
	{27129, 197144, 1, 1687},
	{27152, 197148},
	{27172, 197152, 1, 1688},
	{27195, 197156, 9, 5253},
	{27214, 197160, 5, 5262},
	{27226, 197164, 2, 1703},
	{27243, 197168, 1, 1705},
	{27260, 197172, 1, 1706},
	{27278, 197176, 5, 2654},
	{27298, 197180, 1, 1711},
	{27315, 197184},
	{27331, 197188, 1, 1713},
	{27344, 197192, 1, 1714},
	{27358, 197196, 1, 1715},
	{27372, 197200, 1, 1716},
	{27394, 197204, 1, 1717},
	{27414, 197208, 1, 1718},
	{27436, 197212, 1, 1719},
	{27456, 197216, 1, 1714},
	{27473, 197220, 1, 1715},
	{27490, 197224},
	{27749, 197388, 1, 1728},
	{27768, 197392, 1, 1729},
	{27787, 197396, 1, 1730},
	{27804, 197400, 1, 1731},
	{27822, 197404, 1, 1732},
	{27840, 197408, 1, 1733},
	{27856, 197412, 1, 1734},
	{27874, 197416, 1, 1735},
	{27892, 197420, 1, 1736},
	{27908, 197424, 1, 1731},
	{27923, 197428, 1, 1732},
	{27938, 197432, 1, 1733},
	{27951, 197436, 1, 1734},
	{27966, 197440, 1, 1735},
	{27981, 197444, 1, 1736},
	{27994, 197448, 1, 1737},
	{28008, 197452, 1, 1738},
	{28022, 197456, 1, 1739},
	{28034, 197460, 4, 6260},
	{28057, 197464, 4, 6264},
	{28757, 198656, 6, 5119},
	{28772, 198912},
	{28791, 198916},
	{28810, 198920, 1, 5502},
	{28829, 198924, 1, 5503},
	{28844, 198928},
	{28877, 198932},
	{28910, 198936},
	{28943, 198940},
	{29033, 198960},
	{29049, 198964},
	{29067, 198968, 1, 1792},
	{29084, 198972, 2, 1793},
	{29105, 198976},
	{29437, 199168, 1, 1816},
	{29462, 199172, 2, 1817},
	{29487, 199184, 2, 1819},
	{29513, 199188, 2, 1819},
	{29539, 199192, 2, 1819},
	{29565, 199212, 2, 1819},
	{29591, 199296, 2, 1821},
	{29619, 199300, 1, 1823},
	{29643, 199304, 1, 1824},
	{29667, 199308, 1, 1825},
	{29700, 199312, 1, 1825},
	{29728, 199328, 2, 1821},
	{29757, 199332, 1, 1823},
	{29782, 199336, 1, 1824},
	{29807, 199340, 1, 1825},
	{29841, 199344, 1, 1825},
	{29870, 199360, 2, 1821},
	{29894, 199364, 1, 1823},
	{29914, 199368, 1, 1824},
	{29934, 199372, 1, 1825},
	{29963, 199376, 1, 1825},
	{29987, 199936},
	{30014, 199940},
	{30041, 199944},
	{30068, 199948},
	{30203, 199968, 3, 5626},
	{30228, 200192},
	{30247, 200196, 1, 847},
	{30269, 200448},
	{30293, 200452, 1, 1835},
	{30316, 200456},
	{30340, 200460, 1, 1835},
	{30363, 200464},
	{30387, 200468, 1, 1835},
	{30410, 200472},
	{30434, 200476, 1, 1835},
	{30457, 200696},
	{30476, 200700, 1, 1835},
	{30494, 200704},
	{30506, 200708},
	{30518, 200712},
	{30536, 200716},
	{30555, 200720},
	{30573, 200724},
	{30585, 200728},
	{30597, 200732},
	{30615, 200736},
	{30633, 200740},
	{30652, 200744, 4, 6268},
	{30666, 200748, 2, 1840},
	{30684, 200752, 2, 1842},
	{30698, 200756, 2, 1844},
	{30712, 200760, 2, 1846},
	{30729, 200764, 2, 1848},
	{30746, 200768},
	{30759, 200772, 2, 1850},
	{30771, 200776},
	{30785, 200780},
	{30801, 200784},
	{30815, 200788},
	{30831, 200792},
	{30846, 200796},
	{30863, 200800},
	{30878, 200804},
	{30895, 200808, 2, 1852},
	{30917, 200812, 9, 6272},
	{30934, 200816, 2, 1864},
	{30955, 200820, 2, 1866},
	{30967, 200824},
	{30982, 200828, 6, 1868},
	{30997, 200832, 2, 1874},
	{31011, 200836},
	{31124, 212992},
	{31144, 212996},
	{31164, 213000},
	{31184, 213004},
	{31204, 213008},
	{31224, 213012},
	{31244, 213016},
	{31264, 213020},
	{31284, 213024},
	{31304, 213028},
	{31324, 213032},
	{31344, 213036},
	{31433, 213248},
	{31454, 213252},
	{31475, 213260},
	{31496, 213264},
	{31517, 213268},
	{31541, 213272},
	{31565, 213276},
	{31589, 213280},
	{31613, 213284},
	{31637, 213288},
	{31661, 213292},
	{31685, 213296},
	{53472, 213504},
	{53499, 213508},
	{53526, 213512},
	{53553, 213516},
	{59373, 213520},
	{59392, 213524},
	{59411, 213528},
	{59430, 213532},
	{56863, 213536},
	{56882, 213540},
	{56901, 213544},
	{56920, 213548},
	{56939, 213552},
	{56958, 213556},
	{56977, 213560},
	{56996, 213564},
	{57416, 213568},
	{57436, 213572},
	{57456, 213576},
	{57476, 213580},
	{57496, 213584},
	{57516, 213588},
	{57536, 213592},
	{57556, 213596},
	{32169, 214016},
	{32191, 214020, 1, 1876},
	{32213, 214024},
	{32235, 214028, 1, 1876},
	{32257, 214032},
	{32279, 214036, 1, 1876},
	{32301, 214040},
	{32323, 214044, 1, 1876},
	{32345, 214272},
	{32367, 214276},
	{32389, 214280},
	{32411, 214284},
	{32433, 214288},
	{32455, 214292},
	{32477, 214296},
	{32499, 214300},
	{32521, 214304},
	{32543, 214308},
	{32565, 214312},
	{32587, 214316},
	{32609, 214320},
	{32631, 214324},
	{32653, 214328},
	{32675, 214332},
	{32697, 214528},
	{32717, 214532},
	{32737, 214536},
	{32757, 214540},
	{32777, 214544},
	{32797, 214548},
	{32817, 214552},
	{32837, 214556},
	{32857, 214560},
	{32877, 214564},
	{32897, 214568},
	{32917, 214572},
	{32937, 214784},
	{32956, 214788},
	{32975, 214792},
	{32994, 214796},
	{33013, 214800},
	{33032, 214804},
	{33051, 214808},
	{33070, 214812},
	{33089, 214816},
	{33108, 214820},
	{33127, 214824},
	{33146, 214828},
	{33165, 214832},
	{33184, 214836},
	{33203, 214840},
	{33222, 214844},
	{33241, 214848},
	{33260, 214852},
	{33279, 214856},
	{33298, 214860},
	{33317, 214864},
	{33337, 214868},
	{33357, 214872},
	{33377, 214876},
	{33397, 214880},
	{33417, 214884},
	{33437, 214888},
	{33457, 214892},
	{33477, 214896},
	{33497, 214900},
	{33517, 214904},
	{33537, 214908},
	{33557, 215296},
	{33576, 215300},
	{33595, 215304},
	{33614, 215308},
	{33633, 215312},
	{33652, 215316},
	{33671, 215320},
	{33690, 215324},
	{33751, 215552},
	{33771, 215556},
	{33791, 215560},
	{33811, 215564},
	{33831, 215568},
	{33851, 215572},
	{33871, 215576},
	{33891, 215580},
	{33911, 215808},
	{33930, 215812},
	{33949, 215816},
	{33968, 215820},
	{33987, 216064},
	{34006, 216068},
	{34025, 216072},
	{34044, 216076},
	{34063, 216320},
	{34083, 216324},
	{34103, 216328},
	{34123, 216332},
	{34143, 216336},
	{34163, 216340},
	{34183, 216344},
	{34203, 216348},
	{59449, 216576},
	{59469, 216580},
	{59489, 216584},
	{59509, 216588},
	{59529, 216592},
	{59549, 216596},
	{59569, 216600},
	{59589, 216604},
	{59609, 216640},
	{59629, 216644},
	{59649, 216648},
	{59669, 216652},
	{59689, 216656},
	{59709, 216660},
	{59729, 216664},
	{59749, 216668},
	{59769, 216704},
	{59789, 216708},
	{59809, 216712},
	{59829, 216716},
	{59849, 216720},
	{59869, 216724},
	{59889, 216728},
	{59909, 216732},
	{35055, 217112},
	{35074, 217116},
	{35093, 217120},
	{35112, 217124},
	{35131, 217128},
	{35150, 217132},
	{35169, 217136},
	{35188, 217140},
	{35207, 217344},
	{35226, 217348},
	{35245, 217352},
	{35264, 217356},
	{35283, 217360},
	{35302, 217364},
	{35321, 217368},
	{35340, 217372},
	{35359, 217600},
	{35379, 217604},
	{35399, 217608},
	{35419, 217612},
	{36741, 221184, 1, 1910},
	{36765, 221188, 2, 6281},
	{36790, 221192, 3, 6283},
	{36814, 221196, 1, 1910},
	{36838, 221200, 2, 6281},
	{36863, 221204, 1, 1910},
	{36887, 221208, 2, 6281},
	{36912, 221212, 3, 6283},
	{36936, 221216, 4, 1888},
	{36952, 221220, 3, 6283},
	{37119, 221248},
	{37134, 221252, 1, 1825},
	{37157, 221256},
	{37180, 221260},
	{37198, 221264, 2, 1904},
	{37216, 221268, 4, 1906},
	{37236, 221440, 19, 5162},
	{37261, 221444, 19, 5162},
	{37286, 221448, 12, 5181},
	{37314, 221452, 12, 5181},
	{37342, 221456, 12, 5181},
	{37370, 221460, 12, 5181},
	{54359, 221696, 2, 5460},
	{54422, 221700, 2, 5460},
	{59929, 221704, 2, 5460},
	{59952, 221708, 2, 5460},
	{56771, 221712, 5, 1964},
	{56794, 221716, 2, 5460},
	{56817, 221720, 2, 5460},
	{56840, 221724, 2, 5460},
	{59975, 221728, 4, 1969},
	{57320, 221744, 5, 1964},
	{57344, 221748, 5, 1964},
	{57368, 221752, 2, 5460},
	{57392, 221756, 2, 5460},
	{59999, 221760, 4, 1969},
	{60024, 221764, 4, 1969},
	{57294, 221776, 1, 5501},
	{37828, 222208, 3, 1964},
	{37854, 222212, 2, 1884},
	{37881, 222216, 3, 1964},
	{37907, 222220, 2, 1884},
	{37934, 222224, 2, 2020},
	{37987, 222228, 2, 2020},
	{38040, 222464, 3, 1964},
	{38066, 222468, 2, 1884},
	{38093, 222472, 1, 1879},
	{38119, 222476, 1, 1879},
	{38145, 222480, 1, 1879},
	{38171, 222484, 1, 1879},
	{38197, 222488, 1, 1879},
	{38223, 222492, 1, 1879},
	{38249, 222496, 1, 1879},
	{38275, 222720, 3, 1964},
	{38299, 222724, 3, 1964},
	{38323, 222728, 3, 1964},
	{38347, 222732, 3, 1964},
	{38371, 222736, 2, 1884},
	{38396, 222740, 2, 1884},
	{38421, 222744, 2, 1884},
	{38446, 222748, 2, 1884},
	{38471, 222752, 1, 2008},
	{38495, 222756, 1, 2008},
	{38519, 222760, 8, 1973},
	{38540, 222976, 6, 6286},
	{38563, 222980, 6, 6286},
	{38586, 222984, 6, 6286},
	{38609, 222988, 6, 6286},
	{38632, 222992, 6, 6286},
	{38655, 222996, 6, 6286},
	{38678, 223000, 6, 6286},
	{38701, 223004, 6, 6286},
	{38724, 223008, 6, 6286},
	{38747, 223012, 6, 6286},
	{38770, 223016, 6, 6286},
	{38794, 223020, 6, 6286},
	{38818, 223024, 6, 6286},
	{38842, 223028, 6, 6286},
	{38866, 223032, 6, 6286},
	{38890, 223036, 6, 6286},
	{38914, 223104, 9, 5642},
	{60049, 223108, 2, 5690},
	{38934, 223112, 1, 1994},
	{39029, 223488, 3, 2003},
	{39052, 223492, 3, 2003},
	{39075, 223496, 3, 2003},
	{39098, 223500, 3, 2003},
	{39121, 223504, 2, 2006},
	{39145, 223508, 2, 2006},
	{39169, 223744, 3, 2003},
	{39193, 223748, 3, 2003},
	{39217, 223752, 3, 2003},
	{39241, 223756, 3, 2003},
	{39265, 223760, 2, 2006},
	{39290, 224000, 5, 2008},
	{39313, 224004, 4, 2013},
	{39337, 224008, 5, 2008},
	{39360, 224256, 5, 2008},
	{39383, 224260, 4, 2013},
	{39407, 224264, 5, 2008},
	{39430, 224512, 5, 1964},
	{39454, 224516, 4, 1969},
	{39479, 224520, 5, 1964},
	{39503, 224524, 4, 1969},
	{39528, 224528, 3, 2020},
	{39552, 224532, 3, 2020},
	{60069, 224768, 5, 1964},
	{60093, 224772, 4, 1958},
	{60118, 224776, 5, 1964},
	{60142, 224780, 4, 1958},
	{60167, 224784, 3, 2020},
	{60191, 224788, 3, 2020},
	{60215, 224832, 5, 1964},
	{60239, 224836, 4, 1958},
	{60264, 224840, 5, 1964},
	{60288, 224844, 4, 1958},
	{60313, 224848, 3, 2020},
	{60337, 224852, 3, 2020},
	{60361, 224896, 5, 1964},
	{60385, 224900, 4, 1958},
	{60410, 224904, 3, 2020},
	{60434, 224908, 3, 2020},
	{60458, 224912, 3, 2020},
	{40253, 225280, 12, 2023},
	{40275, 225284, 5, 2035},
	{40298, 225288, 4, 2040},
	{40322, 225292, 2, 2044},
	{40345, 225296, 2, 2044},
	{40368, 225300, 2, 2044},
	{40391, 225536, 5, 1964},
	{40414, 225540, 4, 1969},
	{40438, 225544, 5, 1964},
	{40461, 225548, 4, 1969},
	{40485, 225552, 5, 1964},
	{40508, 225560, 5, 1964},
	{40531, 225792, 4, 2046},
	{40552, 225796},
	{40581, 225800, 2, 2050},
	{40610, 225804},
	{40636, 225808, 7, 2052},
	{40710, 225812},
	{40733, 225816},
	{60482, 225820, 2, 6292},
	{60515, 225824, 2, 6292},
	{60548, 225828, 2, 6292},
	{60581, 225832, 2, 6292},
	{60613, 225836, 2, 6292},
	{60645, 225840, 2, 6292},
	{60677, 225844, 2, 6292},
	{60710, 225848, 2, 6292},
	{60742, 225856, 2, 6292},
	{60774, 225860, 2, 6292},
	{60807, 225864, 2, 6292},
	{60840, 225868, 2, 6292},
	{60873, 225872, 2, 6292},
	{60905, 225876, 2, 6292},
	{60937, 225880, 2, 6292},
	{60970, 225884, 2, 6292},
	{61003, 225888, 2, 6292},
	{61036, 225892, 2, 6292},
	{61069, 225896, 2, 6292},
	{40756, 225900},
	{40783, 225904},
	{40665, 225908},
	{40684, 225912},
	{61101, 225916, 2, 6292},
	{61135, 225920, 2, 6292},
	{61169, 225924, 2, 6292},
	{61203, 225928, 2, 6292},
	{41446, 226048, 2, 2126},
	{41463, 226052, 1, 2128},
	{41487, 226056, 1, 2128},
	{206, 880, 4, 2163},
	{43232, 881},
	{27079, 882},
	{43244, 1008},
	{43255, 1009},
	{27267, 1010, 4, 2167},
	{43266, 1040, 1, 2171},
	{43279, 1041, 5, 6294},
	{43292, 1042, 1, 2177},
	{43305, 1043, 1, 1688},
	{27101, 1045, 9, 6086},
	{43333, 1281, 6, 6299},
	{43348, 1282},
	{27038, 1283},
	{43232, 1285},
	{27079, 1286},
};

static const struct si_reg gfx8_reg_table[] = {
	{1390, 68, 10, 6305},
	{1403, 72, 23, 6315},
	{1418, 76, 4, 6338},
	{55593, 80, 11, 6111},
	{1455, 84, 4, 4975},
	{1473, 88, 2, 3924},
	{1491, 92, 6, 6342},
	{1506, 96},
	{1520, 100, 1, 4983},
	{1534, 104},
	{55607, 108},
	{55624, 112, 13, 6348},
	{1551, 116, 5, 6361},
	{55640, 2480},
	{55655, 2484, 1, 4997},
	{55670, 2488},
	{55685, 2492, 1, 4997},
	{1689, 2496},
	{1703, 2500},
	{1717, 2504},
	{1731, 2508},
	{1745, 2512},
	{1759, 2516},
	{1773, 2520},
	{1787, 2524},
	{1801, 2528},
	{1815, 2532},
	{1829, 2536},
	{1844, 2540},
	{1919, 2544},
	{1930, 2552},
	{1946, 2556},
	{55700, 3660, 21, 4998},
	{55713, 3664, 20, 5019},
	{55725, 3668, 16, 5039},
	{2034, 32776, 18, 6366},
	{2047, 32784, 24, 5077},
	{2059, 32788, 11, 5101},
	{2075, 32792, 11, 5101},
	{2104, 32824, 11, 5101},
	{2120, 32828, 11, 5101},
	{2136, 33296, 15, 6384},
	{2150, 33300, 28, 204},
	{2167, 33304, 14, 6399},
	{2188, 33308, 21, 6413},
	{2202, 33312, 31, 6194},
	{2219, 33316, 9, 6434},
	{2258, 33324, 1, 329},
	{2281, 33344, 1, 330},
	{2302, 33348},
	{2363, 33436, 1, 342},
	{58279, 36416},
	{2767, 36608},
	{2785, 36612, 4, 383},
	{2803, 36616},
	{2821, 36620, 14, 6443},
	{3722, 36624},
	{3740, 36628, 5, 6457},
	{3758, 36632, 4, 5759},
	{3776, 36636, 11, 5763},
	{3794, 36640, 2, 5774},
	{3812, 36644, 2, 5776},
	{3830, 36648, 8, 6462},
	{3848, 36652},
	{2839, 36656, 14, 6470},
	{2857, 36660, 4, 411},
	{2875, 36664, 10, 6484},
	{2893, 36668, 3, 5804},
	{2911, 37120, 6, 426},
	{2927, 39160, 9, 5807},
	{2942, 39184, 5, 5817},
	{2956, 39188, 5, 5817},
	{2970, 39192, 5, 5817},
	{2984, 39196, 5, 5817},
	{2998, 39200, 5, 5817},
	{3012, 39204, 5, 5817},
	{3026, 39208, 5, 5817},
	{3040, 39212, 5, 5817},
	{3054, 39216, 5, 5817},
	{3068, 39220, 5, 5817},
	{3082, 39224, 5, 5817},
	{3097, 39228, 5, 5817},
	{3112, 39232, 5, 5817},
	{3127, 39236, 5, 5817},
	{3142, 39240, 5, 5817},
	{3157, 39244, 5, 5817},
	{3172, 39248, 5, 5817},
	{3187, 39252, 5, 5817},
	{3202, 39256, 5, 5817},
	{3217, 39260, 5, 5817},
	{3232, 39264, 5, 5817},
	{3247, 39268, 5, 5817},
	{3262, 39272, 5, 5817},
	{3277, 39276, 5, 5817},
	{3292, 39280, 5, 5817},
	{3307, 39284, 5, 5817},
	{3322, 39288, 5, 5817},
	{3337, 39292, 5, 5817},
	{3352, 39296, 5, 5817},
	{3367, 39300, 5, 5817},
	{3382, 39304, 5, 5817},
	{3397, 39308, 5, 5817},
	{3412, 39312, 4, 445},
	{3431, 39316, 4, 445},
	{3450, 39320, 4, 445},
	{3469, 39324, 4, 445},
	{3488, 39328, 4, 445},
	{3507, 39332, 4, 445},
	{3526, 39336, 4, 445},
	{3545, 39340, 4, 445},
	{3564, 39344, 4, 445},
	{3583, 39348, 4, 445},
	{3602, 39352, 4, 445},
	{3622, 39356, 4, 445},
	{3642, 39360, 4, 445},
	{3662, 39364, 4, 445},
	{3682, 39368, 4, 445},
	{3702, 39372, 4, 445},
	{58513, 45056},
	{58534, 45060, 1, 498},
	{58555, 45064},
	{58576, 45068, 1, 498},
	{3947, 45084, 3, 495},
	{3971, 45088},
	{3992, 45092, 1, 498},
	{4013, 45096, 11, 5822},
	{4037, 45100, 6, 510},
	{4061, 45104},
	{4087, 45108},
	{4113, 45112},
	{4139, 45116},
	{4165, 45120},
	{4191, 45124},
	{4217, 45128},
	{4243, 45132},
	{4269, 45136},
	{4295, 45140},
	{4321, 45144},
	{4348, 45148},
	{4375, 45152},
	{4402, 45156},
	{4429, 45160},
	{4456, 45164},
	{58597, 45312},
	{58618, 45316, 1, 498},
	{58639, 45320},
	{58660, 45324, 1, 498},
	{5128, 45336, 3, 495},
	{5152, 45340, 1, 534},
	{5177, 45344},
	{5198, 45348, 1, 498},
	{5219, 45352, 12, 5839},
	{5243, 45356, 11, 6494},
	{5267, 45360},
	{5293, 45364},
	{5319, 45368},
	{5345, 45372},
	{5371, 45376},
	{5397, 45380},
	{5423, 45384},
	{5449, 45388},
	{5475, 45392},
	{5501, 45396},
	{5527, 45400},
	{5554, 45404},
	{5581, 45408},
	{5608, 45412},
	{5635, 45416},
	{5662, 45420},
	{6312, 45552, 6, 570},
	{6339, 45556, 5, 576},
	{58681, 45568},
	{58702, 45572, 1, 498},
	{58723, 45576},
	{58744, 45580, 1, 498},
	{6527, 45596, 4, 583},
	{6551, 45600},
	{6572, 45604, 1, 498},
	{6593, 45608, 11, 5861},
	{6617, 45612, 4, 561},
	{6641, 45616},
	{6667, 45620},
	{6693, 45624},
	{6719, 45628},
	{6745, 45632},
	{6771, 45636},
	{6797, 45640},
	{6823, 45644},
	{6849, 45648},
	{6875, 45652},
	{6901, 45656},
	{6928, 45660},
	{6955, 45664},
	{6982, 45668},
	{7009, 45672},
	{7036, 45676},
	{7671, 45808, 6, 570},
	{58765, 45824},
	{58786, 45828, 1, 498},
	{58807, 45832},
	{58828, 45836, 1, 498},
	{7698, 45852, 4, 583},
	{7722, 45856},
	{7743, 45860, 1, 498},
	{7764, 45864, 12, 5839},
	{7788, 45868, 6, 570},
	{7812, 45872},
	{7838, 45876},
	{7864, 45880},
	{7890, 45884},
	{7916, 45888},
	{7942, 45892},
	{7968, 45896},
	{7994, 45900},
	{8020, 45904},
	{8046, 45908},
	{8072, 45912},
	{8099, 45916},
	{8126, 45920},
	{8153, 45924},
	{8180, 45928},
	{8207, 45932},
	{8234, 46068, 5, 576},
	{58849, 46080},
	{58870, 46084, 1, 498},
	{58891, 46088},
	{58912, 46092, 1, 498},
	{8422, 46108, 3, 619},
	{8446, 46112},
	{8467, 46116, 1, 498},
	{8488, 46120, 10, 5882},
	{8512, 46124, 6, 635},
	{8536, 46128},
	{8562, 46132},
	{8588, 46136},
	{8614, 46140},
	{8640, 46144},
	{8666, 46148},
	{8692, 46152},
	{8718, 46156},
	{8744, 46160},
	{8770, 46164},
	{8796, 46168},
	{8823, 46172},
	{8850, 46176},
	{8877, 46180},
	{8904, 46184},
	{8931, 46188},
	{9566, 46324, 5, 576},
	{58933, 46336},
	{58954, 46340, 1, 498},
	{58975, 46344},
	{58996, 46348, 1, 498},
	{9593, 46364, 4, 583},
	{9617, 46368},
	{9638, 46372, 1, 498},
	{9659, 46376, 11, 5898},
	{9683, 46380, 5, 576},
	{9707, 46384},
	{9733, 46388},
	{9759, 46392},
	{9785, 46396},
	{9811, 46400},
	{9837, 46404},
	{9863, 46408},
	{9889, 46412},
	{9915, 46416},
	{9941, 46420},
	{9967, 46424},
	{9994, 46428},
	{10021, 46432},
	{10048, 46436},
	{10075, 46440},
	{10102, 46444},
	{10129, 47104, 12, 5914},
	{10156, 47108},
	{10170, 47112},
	{10184, 47116},
	{10198, 47120},
	{10214, 47124},
	{10230, 47128},
	{10246, 47132, 2, 666},
	{10267, 47136, 2, 666},
	{10288, 47140, 2, 666},
	{10309, 47144, 1, 668},
	{10337, 47148, 1, 669},
	{10362, 47152},
	{10377, 47156, 2, 5927},
	{59037, 47160},
	{59052, 47164, 1, 670},
	{59067, 47168},
	{59082, 47172, 1, 670},
	{10516, 47176, 10, 5929},
	{10534, 47180, 11, 683},
	{10552, 47184, 1, 694},
	{10565, 47188, 6, 695},
	{59097, 47192, 2, 5946},
	{59128, 47196, 2, 5946},
	{10643, 47200, 2, 701},
	{59311, 47204, 2, 5946},
	{59342, 47208, 2, 5946},
	{10718, 47212},
	{10736, 47216},
	{10754, 47220},
	{10772, 47224, 1, 703},
	{10800, 47228, 5, 704},
	{10822, 47232},
	{10842, 47236},
	{11025, 47240, 3, 720},
	{11042, 47244},
	{11071, 47248, 1, 723},
	{61237, 47252, 2, 6505},
	{11118, 47360},
	{11138, 47364},
	{11158, 47368},
	{11178, 47372},
	{11198, 47376},
	{11218, 47380},
	{11238, 47384},
	{11258, 47388},
	{11278, 47392},
	{11298, 47396},
	{11318, 47400},
	{11339, 47404},
	{11360, 47408},
	{11381, 47412},
	{11402, 47416},
	{11423, 47420},
	{11489, 47612},
	{59159, 53300, 29, 5948},
	{59176, 55348, 29, 5948},
	{11505, 163840, 10, 726},
	{11523, 163844, 9, 5977},
	{11540, 163848, 4, 5986},
	{11554, 163852, 23, 754},
	{11573, 163856, 15, 777},
	{11593, 163860},
	{11629, 163872},
	{11649, 163876},
	{11669, 163880, 1, 795},
	{11686, 163884},
	{11701, 163888, 2, 796},
	{11725, 163892, 2, 798},
	{59193, 163900, 7, 5990},
	{11783, 163904, 10, 6507},
	{11793, 163908, 6, 6517},
	{11809, 163912},
	{11824, 163916},
	{11845, 163920},
	{11861, 163924},
	{59207, 163928, 2, 6010},
	{59221, 163932, 1, 6012},
	{12051, 163968},
	{12067, 163972, 1, 847},
	{12086, 164328, 1, 848},
	{12107, 164332, 1, 848},
	{12128, 164336, 1, 848},
	{12149, 164340, 1, 848},
	{12170, 164344},
	{12188, 164348},
	{12206, 164352, 2, 849},
	{12226, 164356, 3, 851},
	{12250, 164360, 2, 854},
	{12274, 164364, 1, 856},
	{12294, 164368, 2, 851},
	{12314, 164372, 2, 854},
	{12334, 164376, 2, 851},
	{12354, 164380, 2, 854},
	{12374, 164384, 2, 851},
	{12394, 164388, 2, 854},
	{12414, 164392, 2, 851},
	{12434, 164396, 2, 854},
	{12454, 164400, 7, 857},
	{12469, 164404, 2, 864},
	{12498, 164408, 8, 866},
	{12513, 164412, 8, 874},
	{12528, 164416, 3, 851},
	{12553, 164420, 2, 854},
	{12578, 164424},
	{12596, 164428},
	{12614, 164432, 3, 851},
	{12639, 164436, 2, 854},
	{12664, 164440, 3, 851},
	{12689, 164444, 2, 854},
	{12714, 164448, 3, 851},
	{12739, 164452, 2, 854},
	{12764, 164456, 3, 851},
	{12789, 164460, 2, 854},
	{12814, 164464, 3, 851},
	{12839, 164468, 2, 854},
	{12864, 164472, 3, 851},
	{12889, 164476, 2, 854},
	{12914, 164480, 3, 851},
	{12939, 164484, 2, 854},
	{12964, 164488, 3, 851},
	{12989, 164492, 2, 854},
	{13014, 164496, 3, 851},
	{13039, 164500, 2, 854},
	{13064, 164504, 3, 851},
	{13089, 164508, 2, 854},
	{13114, 164512, 3, 851},
	{13140, 164516, 2, 854},
	{13166, 164520, 3, 851},
	{13192, 164524, 2, 854},
	{13218, 164528, 3, 851},
	{13244, 164532, 2, 854},
	{13270, 164536, 3, 851},
	{13296, 164540, 2, 854},
	{13322, 164544, 3, 851},
	{13348, 164548, 2, 854},
	{13374, 164552, 3, 851},
	{13400, 164556, 2, 854},
	{13426, 164560},
	{13445, 164564},
	{13464, 164568},
	{13483, 164572},
	{13502, 164576},
	{13521, 164580},
	{13540, 164584},
	{13559, 164588},
	{13578, 164592},
	{13597, 164596},
	{13616, 164600},
	{13635, 164604},
	{13654, 164608},
	{13673, 164612},
	{13692, 164616},
	{13711, 164620},
	{13730, 164624},
	{13749, 164628},
	{13768, 164632},
	{13787, 164636},
	{13806, 164640},
	{13826, 164644},
	{13846, 164648},
	{13866, 164652},
	{13886, 164656},
	{13906, 164660},
	{13926, 164664},
	{13946, 164668},
	{13966, 164672},
	{13986, 164676},
	{14006, 164680},
	{14026, 164684},
	{14046, 164688, 15, 882},
	{14066, 164692, 3, 897},
	{14088, 164696, 2, 900},
	{14145, 164704, 1, 909},
	{59236, 164708, 1, 6013},
	{14176, 164712, 1, 911},
	{14244, 164864},
	{14261, 164868},
	{14278, 164872},
	{14294, 164876},
	{14348, 164884},
	{14361, 164888},
	{14376, 164892},
	{14390, 164896},
	{14405, 164900, 3, 6523},
	{14444, 164908, 6, 942},
	{14463, 164912, 4, 948},
	{14481, 164916, 4, 952},
	{14502, 164924},
	{14521, 164928},
	{14541, 164932},
	{14560, 164936},
	{14580, 164940},
	{14599, 164944},
	{14619, 164948},
	{14640, 164952},
	{14662, 164956},
	{14683, 164960},
	{14705, 164964},
	{14726, 164968},
	{14748, 164972},
	{14769, 164976},
	{14791, 164980},
	{14812, 164984},
	{14834, 164988},
	{14855, 164992},
	{14877, 164996},
	{14898, 165000},
	{14920, 165004},
	{14941, 165008},
	{14963, 165012},
	{14984, 165016},
	{15006, 165020},
	{15027, 165024},
	{15049, 165028},
	{15070, 165032},
	{15092, 165036},
	{15113, 165040},
	{15135, 165044},
	{15156, 165048},
	{15178, 165052},
	{15199, 165056},
	{15221, 165060},
	{15242, 165064},
	{15264, 165068},
	{15285, 165072},
	{15307, 165076},
	{15328, 165080},
	{15350, 165084},
	{15371, 165088},
	{15393, 165092},
	{15414, 165096},
	{15436, 165100},
	{15457, 165104},
	{15479, 165108},
	{15500, 165112},
	{15522, 165116},
	{15543, 165120},
	{15565, 165124},
	{15586, 165128},
	{15608, 165132},
	{15629, 165136},
	{15651, 165140},
	{15672, 165144},
	{15694, 165148},
	{15715, 165152},
	{15737, 165156},
	{15758, 165160},
	{15780, 165164},
	{15802, 165168},
	{15825, 165172},
	{15847, 165176},
	{15870, 165180},
	{15892, 165184},
	{15915, 165188},
	{15937, 165192},
	{15960, 165196},
	{15982, 165200},
	{16005, 165204},
	{16027, 165208},
	{16050, 165212},
	{16072, 165216},
	{16095, 165220},
	{16117, 165224},
	{16140, 165228},
	{16162, 165232},
	{16185, 165236},
	{16207, 165240},
	{16230, 165244},
	{16252, 165248},
	{16275, 165252},
	{16297, 165256},
	{16320, 165260},
	{16342, 165264},
	{16365, 165268},
	{16387, 165272},
	{16410, 165276},
	{16432, 165280},
	{16455, 165284},
	{16477, 165288},
	{16500, 165292},
	{16522, 165296},
	{16545, 165300},
	{16567, 165304},
	{16590, 165308},
	{16604, 165312},
	{16618, 165316},
	{16632, 165320},
	{16646, 165324},
	{16660, 165328},
	{16674, 165332},
	{16688, 165336},
	{16702, 165340},
	{16716, 165344},
	{16730, 165348},
	{16744, 165352},
	{16758, 165356},
	{16772, 165360},
	{16786, 165364},
	{16800, 165368},
	{16814, 165372},
	{16828, 165376},
	{16842, 165380},
	{16856, 165384},
	{16870, 165388},
	{16884, 165392},
	{16898, 165396},
	{16912, 165400},
	{16949, 165444, 12, 956},
	{16969, 165448, 12, 956},
	{16989, 165452, 12, 956},
	{17009, 165456, 12, 956},
	{17029, 165460, 12, 956},
	{17049, 165464, 12, 956},
	{17069, 165468, 12, 956},
	{17089, 165472, 12, 956},
	{17109, 165476, 12, 956},
	{17129, 165480, 12, 956},
	{17149, 165484, 12, 956},
	{17170, 165488, 12, 956},
	{17191, 165492, 12, 956},
	{17212, 165496, 12, 956},
	{17233, 165500, 12, 956},
	{17254, 165504, 12, 956},
	{17275, 165508, 12, 956},
	{17296, 165512, 12, 956},
	{17317, 165516, 12, 956},
	{17338, 165520, 12, 956},
	{17359, 165524, 9, 968},
	{17380, 165528, 9, 968},
	{17401, 165532, 9, 968},
	{17422, 165536, 9, 968},
	{17443, 165540, 9, 968},
	{17464, 165544, 9, 968},
	{17485, 165548, 9, 968},
	{17506, 165552, 9, 968},
	{17527, 165556, 9, 968},
	{17548, 165560, 9, 968},
	{17569, 165564, 9, 968},
	{17590, 165568, 9, 968},
	{17611, 165572, 2, 977},
	{17629, 165580, 16, 980},
	{17646, 165584, 16, 980},
	{17664, 165588, 7, 996},
	{17685, 165592, 3, 6014},
	{17703, 165600, 7, 1009},
	{17718, 165608, 2, 701},
	{17757, 165644, 4, 1017},
	{17779, 165648, 1, 1022},
	{17799, 165652, 8, 1023},
	{18025, 165760, 9, 1070},
	{18043, 165764, 9, 1070},
	{18061, 165768, 9, 1070},
	{18079, 165772, 9, 1070},
	{18097, 165776, 9, 1070},
	{18115, 165780, 9, 1070},
	{18133, 165784, 9, 1070},
	{18151, 165788, 9, 1070},
	{18169, 165836, 1, 1079},
	{18183, 165840, 1, 1079},
	{18198, 165844},
	{18216, 165848},
	{18234, 165852},
	{18251, 165856},
	{18272, 165860, 1, 6017},
	{18288, 165864},
	{18301, 165872, 5, 1081},
	{18320, 165876},
	{18335, 165880, 1, 1089},
	{18384, 165888, 10, 1091},
	{18401, 165892, 12, 1101},
	{18409, 165896, 3, 6526},
	{18426, 165900, 12, 1117},
	{18444, 165904, 19, 1134},
	{18460, 165908, 13, 1154},
	{18479, 165912, 10, 1170},
	{18494, 165916, 27, 6529},
	{18512, 165920, 16, 1208},
	{18530, 165924, 4, 1224},
	{18554, 165928},
	{18579, 165932, 11, 1228},
	{18731, 166400, 2, 1260},
	{18748, 166404, 2, 1262},
	{18767, 166408, 1, 1264},
	{18783, 166412, 4, 1265},
	{18802, 166416, 1, 1269},
	{18823, 166420, 1, 1270},
	{18836, 166424},
	{18859, 166428},
	{18882, 166432, 1, 1271},
	{18902, 166436, 4, 6021},
	{18922, 166440, 1, 1276},
	{18943, 166444, 1, 1277},
	{18958, 166448, 6, 1278},
	{18980, 166452, 6, 1278},
	{19002, 166456, 8, 1284},
	{19028, 166460, 8, 1284},
	{19054, 166464, 15, 6556},
	{19066, 166468, 2, 1307},
	{19085, 166472, 4, 1310},
	{19103, 166476, 24, 1317},
	{19121, 166480},
	{19133, 166484, 1, 1341},
	{19147, 166488, 1, 1342},
	{19161, 166492, 1, 1343},
	{19175, 166496, 1, 1344},
	{19198, 166500, 1, 1344},
	{19221, 166504, 1, 1344},
	{19244, 166508, 5, 6025},
	{19265, 166512},
	{19276, 166516},
	{19289, 166520},
	{19306, 166524, 7, 6571},
	{19325, 166528},
	{19336, 166532, 2, 1358},
	{19355, 166536},
	{19377, 166540},
	{19399, 166544, 3, 6578},
	{19419, 166548, 1, 1364},
	{19468, 166560},
	{19493, 166564},
	{19518, 166568, 7, 6581},
	{19537, 166572, 1, 1377},
	{19560, 166576, 1, 1377},
	{19583, 166580, 1, 1378},
	{19597, 166584, 1, 1379},
	{19612, 166588, 8, 6588},
	{19629, 166592, 4, 1389},
	{19656, 166596, 4, 1393},
	{19683, 166600, 4, 1397},
	{19702, 166608},
	{19728, 166612, 1, 1401},
	{19753, 166620},
	{19781, 166624},
	{19807, 166628, 1, 1401},
	{19832, 166636},
	{19860, 166640},
	{19886, 166644, 1, 1401},
	{19911, 166652},
	{19939, 166656},
	{19965, 166660, 1, 1401},
	{19990, 166668},
	{20018, 166696},
	{20049, 166700},
	{20092, 166704, 1, 1402},
	{20130, 166712, 1, 1403},
	{20169, 166736, 3, 1406},
	{20191, 166740, 10, 1411},
	{20212, 166744, 3, 1430},
	{20229, 166748, 1, 1377},
	{20250, 166752, 1, 1377},
	{20273, 166756, 1, 1377},
	{20296, 166760, 1, 1377},
	{20319, 166764, 10, 6596},
	{20332, 166768, 6, 1445},
	{20349, 166772},
	{20373, 166776, 2, 1451},
	{20403, 166780},
	{20427, 166784},
	{20457, 166788},
	{20488, 166792},
	{20517, 166796},
	{20547, 166800, 2, 1453},
	{20567, 166804, 7, 6055},
	{20586, 166808, 4, 1464},
	{20636, 166868, 8, 1468},
	{20662, 166872, 8, 1476},
	{20688, 166876, 4, 1484},
	{20704, 166880, 5, 1489},
	{20720, 166884, 3, 1495},
	{20735, 166888},
	{20758, 166892},
	{20781, 166896},
	{20804, 166900},
	{20827, 166904, 8, 1498},
	{20861, 166908, 8, 1506},
	{20895, 166912, 8, 1514},
	{20929, 166916, 8, 1522},
	{20963, 166920, 8, 1498},
	{20997, 166924, 8, 1506},
	{21031, 166928, 8, 1514},
	{21065, 166932, 8, 1522},
	{21099, 166936, 8, 1498},
	{21133, 166940, 8, 1506},
	{21167, 166944, 8, 1514},
	{21201, 166948, 8, 1522},
	{21235, 166952, 8, 1498},
	{21269, 166956, 8, 1506},
	{21303, 166960, 8, 1514},
	{21337, 166964, 8, 1522},
	{21371, 166968, 2, 1530},
	{21395, 166972, 2, 1532},
	{21538, 167000, 1, 1574},
	{21566, 167004, 1, 1575},
	{21587, 167008},
	{21602, 167012, 2, 1576},
	{21618, 167016, 1, 1578},
	{21634, 167020, 2, 5986},
	{21649, 167024, 18, 6606},
	{21664, 167028, 6, 1601},
	{21681, 167032, 9, 1609},
	{21703, 167036},
	{21719, 167040, 1, 1621},
	{21741, 167044},
	{21757, 167048, 1, 1578},
	{21779, 167052},
	{21801, 167056},
	{21823, 167060},
	{21842, 167068},
	{21857, 167072, 2, 1576},
	{21873, 167076, 1, 1578},
	{21889, 167080, 2, 5986},
	{21904, 167084, 18, 6606},
	{21919, 167088, 6, 1601},
	{21936, 167092, 9, 1609},
	{21958, 167096},
	{21974, 167100, 1, 1621},
	{21996, 167104},
	{22012, 167108, 1, 1578},
	{22034, 167112},
	{22056, 167116},
	{22078, 167120},
	{22097, 167128},
	{22112, 167132, 2, 1576},
	{22128, 167136, 1, 1578},
	{22144, 167140, 2, 5986},
	{22159, 167144, 18, 6606},
	{22174, 167148, 6, 1601},
	{22191, 167152, 9, 1609},
	{22213, 167156},
	{22229, 167160, 1, 1621},
	{22251, 167164},
	{22267, 167168, 1, 1578},
	{22289, 167172},
	{22311, 167176},
	{22333, 167180},
	{22352, 167188},
	{22367, 167192, 2, 1576},
	{22383, 167196, 1, 1578},
	{22399, 167200, 2, 5986},
	{22414, 167204, 18, 6606},
	{22429, 167208, 6, 1601},
	{22446, 167212, 9, 1609},
	{22468, 167216},
	{22484, 167220, 1, 1621},
	{22506, 167224},
	{22522, 167228, 1, 1578},
	{22544, 167232},
	{22566, 167236},
	{22588, 167240},
	{22607, 167248},
	{22622, 167252, 2, 1576},
	{22638, 167256, 1, 1578},
	{22654, 167260, 2, 5986},
	{22669, 167264, 18, 6606},
	{22684, 167268, 6, 1601},
	{22701, 167272, 9, 1609},
	{22723, 167276},
	{22739, 167280, 1, 1621},
	{22761, 167284},
	{22777, 167288, 1, 1578},
	{22799, 167292},
	{22821, 167296},
	{22843, 167300},
	{22862, 167308},
	{22877, 167312, 2, 1576},
	{22893, 167316, 1, 1578},
	{22909, 167320, 2, 5986},
	{22924, 167324, 18, 6606},
	{22939, 167328, 6, 1601},
	{22956, 167332, 9, 1609},
	{22978, 167336},
	{22994, 167340, 1, 1621},
	{23016, 167344},
	{23032, 167348, 1, 1578},
	{23054, 167352},
	{23076, 167356},
	{23098, 167360},
	{23117, 167368},
	{23132, 167372, 2, 1576},
	{23148, 167376, 1, 1578},
	{23164, 167380, 2, 5986},
	{23179, 167384, 18, 6606},
	{23194, 167388, 6, 1601},
	{23211, 167392, 9, 1609},
	{23233, 167396},
	{23249, 167400, 1, 1621},
	{23271, 167404},
	{23287, 167408, 1, 1578},
	{23309, 167412},
	{23331, 167416},
	{23353, 167420},
	{23372, 167428},
	{23387, 167432, 2, 1576},
	{23403, 167436, 1, 1578},
	{23419, 167440, 2, 5986},
	{23434, 167444, 18, 6606},
	{23449, 167448, 6, 1601},
	{23466, 167452, 9, 1609},
	{23488, 167456},
	{23504, 167460, 1, 1621},
	{23526, 167464},
	{23542, 167468, 1, 1578},
	{23564, 167472},
	{23586, 167476},
	{23608, 167480},
	{24651, 196608, 1, 1634},
	{24671, 196612, 1, 1635},
	{24691, 196616},
	{24711, 196620},
	{24731, 196624},
	{24752, 196628},
	{24773, 196632, 1, 1636},
	{24795, 196636, 1, 1637},
	{24817, 196640},
	{24847, 196644},
	{24877, 196648},
	{24906, 196652},
	{24935, 196656},
	{24965, 196660},
	{24995, 196664},
	{25024, 196668},
	{25053, 196672},
	{25083, 196676},
	{25113, 196680},
	{25142, 196684},
	{25171, 196688},
	{25201, 196692},
	{25231, 196696},
	{25260, 196700},
	{25289, 196704, 1, 1638},
	{25311, 196708, 1, 1639},
	{25333, 196712},
	{25356, 196716},
	{25379, 196720},
	{25402, 196724},
	{25425, 196728},
	{25448, 196732},
	{25471, 196736},
	{25495, 196740},
	{25519, 196744},
	{25543, 196748},
	{25567, 196752},
	{25591, 196756},
	{25615, 196760},
	{25639, 196764},
	{25663, 196768},
	{25685, 196772},
	{25707, 196776},
	{25728, 196780},
	{25749, 196784},
	{25773, 196788},
	{25797, 196792},
	{25821, 196796},
	{25845, 196800},
	{25869, 196804},
	{25953, 196852, 2, 6624},
	{25975, 196856, 2, 6624},
	{25997, 196860, 1, 1642},
	{26013, 196864},
	{26026, 196868},
	{26039, 196872},
	{26052, 196876},
	{26065, 196880},
	{26078, 196884},
	{26091, 196888},
	{26104, 196892},
	{26231, 196928, 2, 1643},
	{26244, 196932},
	{26257, 196936},
	{26280, 196940},
	{26303, 196944},
	{26331, 196948},
	{26359, 196952},
	{26387, 196956},
	{26415, 196960, 1, 1645},
	{26433, 196964, 5, 6626},
	{26451, 196968},
	{26466, 196972},
	{26490, 196976},
	{26514, 196980},
	{26533, 196984},
	{26552, 196988},
	{26576, 196992},
	{26600, 196996},
	{26624, 197000},
	{26648, 197028, 2, 5213},
	{26666, 197032, 3, 6631},
	{26684, 197036},
	{26702, 197040},
	{26720, 197044, 2, 5216},
	{26738, 197048, 3, 6634},
	{26756, 197052},
	{26774, 197056, 2, 1656},
	{26793, 197060, 5, 1658},
	{26812, 197072},
	{26836, 197076, 2, 1656},
	{26856, 197080, 5, 1658},
	{26876, 197084, 8, 6637},
	{26895, 197088, 8, 6637},
	{26913, 197092, 1, 1670},
	{26930, 197100, 1, 1671},
	{26951, 197104, 26, 6645},
	{26965, 197108},
	{26979, 197112},
	{26993, 197116, 4, 5247},
	{27009, 197120},
	{27028, 197124, 1, 1687},
	{27050, 197128},
	{27069, 197132, 1, 1688},
	{27091, 197136, 9, 5253},
	{27109, 197140},
	{27129, 197144, 1, 1687},
	{27152, 197148},
	{27172, 197152, 1, 1688},
	{27195, 197156, 9, 5253},
	{27214, 197160, 5, 5262},
	{27226, 197164, 2, 1703},
	{27243, 197168, 1, 1705},
	{27260, 197172, 1, 1706},
	{27278, 197176, 4, 1707},
	{27298, 197180, 1, 1711},
	{27315, 197184},
	{27331, 197188, 1, 1713},
	{27344, 197192, 1, 1714},
	{27358, 197196, 1, 1715},
	{27372, 197200, 1, 1716},
	{27394, 197204, 1, 1717},
	{27414, 197208, 1, 1718},
	{27436, 197212, 1, 1719},
	{27456, 197216, 1, 1714},
	{27473, 197220, 1, 1715},
	{27490, 197224},
	{61266, 197228, 1, 1713},
	{27749, 197388, 1, 1728},
	{27768, 197392, 1, 1729},
	{27787, 197396, 1, 1730},
	{27804, 197400, 1, 1731},
	{27822, 197404, 1, 1732},
	{27840, 197408, 1, 1733},
	{27856, 197412, 1, 1734},
	{27874, 197416, 1, 1735},
	{27892, 197420, 1, 1736},
	{27908, 197424, 1, 1731},
	{27923, 197428, 1, 1732},
	{27938, 197432, 1, 1733},
	{27951, 197436, 1, 1734},
	{27966, 197440, 1, 1735},
	{27981, 197444, 1, 1736},
	{27994, 197448, 1, 1737},
	{28008, 197452, 1, 1738},
	{28022, 197456, 1, 1739},
	{28034, 197460, 4, 6671},
	{28057, 197464, 4, 6264},
	{28079, 197468, 1, 1747},
	{28223, 197552, 1, 1752},
	{28248, 197556, 1, 1752},
	{28272, 197560, 1, 1753},
	{28292, 197568},
	{28318, 197572, 1, 1635},
	{28347, 197576},
	{28372, 197580, 1, 1635},
	{28400, 197584},
	{28423, 197588, 1, 1635},
	{28449, 197592},
	{28471, 197596, 1, 1635},
	{28496, 197600},
	{28515, 197604, 1, 1635},
	{28537, 197608, 1, 1350},
	{28551, 197612},
	{28568, 197616, 1, 1635},
	{28588, 197620, 8, 1754},
	{28757, 198656, 6, 5119},
	{28772, 198912},
	{28791, 198916},
	{28810, 198920, 1, 5502},
	{28829, 198924, 1, 1350},
	{28844, 198928},
	{28877, 198932},
	{28910, 198936},
	{28943, 198940},
	{29033, 198960},
	{29049, 198964},
	{29067, 198968, 1, 1792},
	{29084, 198972, 2, 1793},
	{29105, 198976},
	{29437, 199168, 1, 1816},
	{29462, 199172, 2, 1817},
	{29487, 199184, 2, 1819},
	{29513, 199188, 2, 1819},
	{29539, 199192, 2, 1819},
	{29565, 199212, 2, 1819},
	{29591, 199296, 2, 1821},
	{29619, 199300, 1, 1823},
	{29643, 199304, 1, 1824},
	{29667, 199308, 1, 1825},
	{29700, 199312, 1, 1825},
	{29728, 199328, 2, 1821},
	{29757, 199332, 1, 1823},
	{29782, 199336, 1, 1824},
	{29807, 199340, 1, 1825},
	{29841, 199344, 1, 1825},
	{29870, 199360, 2, 1821},
	{29894, 199364, 1, 1823},
	{29914, 199368, 1, 1824},
	{29934, 199372, 1, 1825},
	{29963, 199376, 1, 1825},
	{58190, 199872},
	{58211, 199876, 1, 4849},
	{2511, 199880, 8, 6232},
	{2532, 199884, 3, 5687},
	{58232, 199888, 2, 5690},
	{2559, 199892, 1, 5714},
	{58258, 199896, 15, 5699},
	{59261, 199900, 1, 6241},
	{59283, 199904},
	{2490, 199908, 2, 5692},
	{2580, 199912, 5, 6244},
	{58300, 199916, 1, 5715},
	{29987, 199936},
	{30014, 199940},
	{30041, 199944},
	{30068, 199948},
	{30203, 199968, 6, 1826},
	{30214, 199972, 2, 1833},
	{30228, 200192},
	{30247, 200196, 1, 847},
	{30269, 200448},
	{30293, 200452, 1, 1835},
	{30316, 200456},
	{30340, 200460, 1, 1835},
	{30363, 200464},
	{30387, 200468, 1, 1835},
	{30410, 200472},
	{30434, 200476, 1, 1835},
	{30457, 200696},
	{30476, 200700, 1, 1835},
	{30494, 200704},
	{30506, 200708},
	{30518, 200712},
	{30536, 200716},
	{30555, 200720},
	{30573, 200724},
	{30585, 200728},
	{30597, 200732},
	{30615, 200736},
	{30633, 200740},
	{30652, 200744, 4, 1836},
	{30666, 200748, 2, 1840},
	{30684, 200752, 2, 1842},
	{30698, 200756, 2, 1844},
	{30712, 200760, 2, 1846},
	{30729, 200764, 2, 1848},
	{30746, 200768},
	{30759, 200772, 2, 1850},
	{30771, 200776},
	{30785, 200780},
	{30801, 200784},
	{30815, 200788},
	{30831, 200792},
	{30846, 200796},
	{30863, 200800},
	{30878, 200804},
	{30895, 200808, 2, 1852},
	{30917, 200812, 9, 6272},
	{30934, 200816, 2, 1864},
	{30955, 200820, 2, 1866},
	{30967, 200824},
	{30982, 200828, 6, 6675},
	{30997, 200832, 2, 1874},
	{31011, 200836},
	{31124, 212992},
	{31144, 212996},
	{31164, 213000},
	{31184, 213004},
	{31204, 213008},
	{31224, 213012},
	{31244, 213016},
	{31264, 213020},
	{31284, 213024},
	{31304, 213028},
	{31324, 213032},
	{31344, 213036},
	{31433, 213248},
	{31454, 213252},
	{31475, 213260},
	{31496, 213264},
	{31517, 213268},
	{31541, 213272},
	{31565, 213276},
	{31589, 213280},
	{31613, 213284},
	{31637, 213288},
	{31661, 213292},
	{31685, 213296},
	{53472, 213504},
	{53499, 213508},
	{53526, 213512},
	{53553, 213516},
	{59373, 213520},
	{59392, 213524},
	{59411, 213528},
	{59430, 213532},
	{56863, 213536},
	{56882, 213540},
	{56901, 213544},
	{56920, 213548},
	{56939, 213552},
	{56958, 213556},
	{56977, 213560},
	{56996, 213564},
	{57416, 213568},
	{57436, 213572},
	{57456, 213576},
	{57476, 213580},
	{57496, 213584},
	{57516, 213588},
	{57536, 213592},
	{57556, 213596},
	{32169, 214016},
	{32191, 214020, 1, 1876},
	{32213, 214024},
	{32235, 214028, 1, 1876},
	{32257, 214032},
	{32279, 214036, 1, 1876},
	{32301, 214040},
	{32323, 214044, 1, 1876},
	{32345, 214272},
	{32367, 214276},
	{32389, 214280},
	{32411, 214284},
	{32433, 214288},
	{32455, 214292},
	{32477, 214296},
	{32499, 214300},
	{32521, 214304},
	{32543, 214308},
	{32565, 214312},
	{32587, 214316},
	{32609, 214320},
	{32631, 214324},
	{32653, 214328},
	{32675, 214332},
	{32697, 214528},
	{32717, 214532},
	{32737, 214536},
	{32757, 214540},
	{32777, 214544},
	{32797, 214548},
	{32817, 214552},
	{32837, 214556},
	{32857, 214560},
	{32877, 214564},
	{32897, 214568},
	{32917, 214572},
	{32937, 214784},
	{32956, 214788},
	{32975, 214792},
	{32994, 214796},
	{33013, 214800},
	{33032, 214804},
	{33051, 214808},
	{33070, 214812},
	{33089, 214816},
	{33108, 214820},
	{33127, 214824},
	{33146, 214828},
	{33165, 214832},
	{33184, 214836},
	{33203, 214840},
	{33222, 214844},
	{33241, 214848},
	{33260, 214852},
	{33279, 214856},
	{33298, 214860},
	{33317, 214864},
	{33337, 214868},
	{33357, 214872},
	{33377, 214876},
	{33397, 214880},
	{33417, 214884},
	{33437, 214888},
	{33457, 214892},
	{33477, 214896},
	{33497, 214900},
	{33517, 214904},
	{33537, 214908},
	{33557, 215296},
	{33576, 215300},
	{33595, 215304},
	{33614, 215308},
	{33633, 215312},
	{33652, 215316},
	{33671, 215320},
	{33690, 215324},
	{33751, 215552},
	{33771, 215556},
	{33791, 215560},
	{33811, 215564},
	{33831, 215568},
	{33851, 215572},
	{33871, 215576},
	{33891, 215580},
	{33911, 215808},
	{33930, 215812},
	{33949, 215816},
	{33968, 215820},
	{33987, 216064},
	{34006, 216068},
	{34025, 216072},
	{34044, 216076},
	{34063, 216320},
	{34083, 216324},
	{34103, 216328},
	{34123, 216332},
	{34143, 216336},
	{34163, 216340},
	{34183, 216344},
	{34203, 216348},
	{59449, 216576},
	{59469, 216580},
	{59489, 216584},
	{59509, 216588},
	{59529, 216592},
	{59549, 216596},
	{59569, 216600},
	{59589, 216604},
	{59609, 216640},
	{59629, 216644},
	{59649, 216648},
	{59669, 216652},
	{59689, 216656},
	{59709, 216660},
	{59729, 216664},
	{59749, 216668},
	{35055, 217112},
	{35074, 217116},
	{35093, 217120},
	{35112, 217124},
	{35131, 217128},
	{35150, 217132},
	{35169, 217136},
	{35188, 217140},
	{35207, 217344},
	{35226, 217348},
	{35245, 217352},
	{35264, 217356},
	{35283, 217360},
	{35302, 217364},
	{35321, 217368},
	{35340, 217372},
	{35359, 217600},
	{35379, 217604},
	{35399, 217608},
	{35419, 217612},
	{36741, 221184, 1, 1910},
	{36765, 221188, 2, 6281},
	{36790, 221192, 3, 6283},
	{36814, 221196, 1, 1910},
	{36838, 221200, 2, 6281},
	{36863, 221204, 1, 1910},
	{36887, 221208, 2, 6281},
	{36912, 221212, 3, 6283},
	{36936, 221216, 4, 1888},
	{36952, 221220, 3, 6283},
	{37119, 221248},
	{37134, 221252, 1, 1825},
	{37157, 221256},
	{37180, 221260},
	{37198, 221264, 2, 1904},
	{37216, 221268, 4, 1906},
	{37236, 221440, 19, 5162},
	{37261, 221444, 19, 5162},
	{37286, 221448, 12, 5181},
	{37314, 221452, 12, 5181},
	{37342, 221456, 12, 5181},
	{37370, 221460, 12, 5181},
	{54359, 221696, 2, 5460},
	{54422, 221700, 2, 5460},
	{59929, 221704, 2, 5460},
	{59952, 221708, 2, 5460},
	{56771, 221712, 5, 1964},
	{56794, 221716, 2, 5460},
	{56817, 221720, 2, 5460},
	{56840, 221724, 2, 5460},
	{59975, 221728, 4, 1969},
	{57320, 221744, 5, 1964},
	{57344, 221748, 5, 1964},
	{57368, 221752, 2, 5460},
	{57392, 221756, 2, 5460},
	{59999, 221760, 4, 1969},
	{60024, 221764, 4, 1969},
	{57294, 221776, 1, 5501},
	{37828, 222208, 3, 1964},
	{37854, 222212, 2, 1884},
	{37881, 222216, 3, 1964},
	{37907, 222220, 2, 1884},
	{37934, 222224, 2, 2020},
	{37987, 222228, 2, 2020},
	{38040, 222464, 3, 1964},
	{38066, 222468, 2, 1884},
	{38093, 222472, 1, 1879},
	{38119, 222476, 1, 1879},
	{38145, 222480, 1, 1879},
	{38171, 222484, 1, 1879},
	{38197, 222488, 1, 1879},
	{38223, 222492, 1, 1879},
	{38249, 222496, 1, 1879},
	{38275, 222720, 3, 1964},
	{38299, 222724, 3, 1964},
	{38323, 222728, 3, 1964},
	{38347, 222732, 3, 1964},
	{38371, 222736, 2, 1884},
	{38396, 222740, 2, 1884},
	{38421, 222744, 2, 1884},
	{38446, 222748, 2, 1884},
	{38471, 222752, 1, 2008},
	{38495, 222756, 1, 2008},
	{38519, 222760, 8, 1973},
	{38540, 222976, 6, 5659},
	{38563, 222980, 6, 5659},
	{38586, 222984, 6, 5659},
	{38609, 222988, 6, 5659},
	{38632, 222992, 6, 5659},
	{38655, 222996, 6, 5659},
	{38678, 223000, 6, 5659},
	{38701, 223004, 6, 5659},
	{38724, 223008, 6, 5659},
	{38747, 223012, 6, 5659},
	{38770, 223016, 6, 5659},
	{38794, 223020, 6, 5659},
	{38818, 223024, 6, 5659},
	{38842, 223028, 6, 5659},
	{38866, 223032, 6, 5659},
	{38890, 223036, 6, 5659},
	{38914, 223104, 9, 5642},
	{60049, 223108, 2, 5690},
	{38934, 223112, 1, 1994},
	{39029, 223488, 3, 2003},
	{39052, 223492, 3, 2003},
	{39075, 223496, 3, 2003},
	{39098, 223500, 3, 2003},
	{39121, 223504, 2, 2006},
	{39145, 223508, 2, 2006},
	{39169, 223744, 3, 2003},
	{39193, 223748, 3, 2003},
	{39217, 223752, 3, 2003},
	{39241, 223756, 3, 2003},
	{39265, 223760, 2, 2006},
	{39290, 224000, 5, 2008},
	{39313, 224004, 4, 2013},
	{39337, 224008, 5, 2008},
	{39360, 224256, 5, 2008},
	{39383, 224260, 4, 2013},
	{39407, 224264, 5, 2008},
	{39430, 224512, 5, 1964},
	{39454, 224516, 4, 1969},
	{39479, 224520, 5, 1964},
	{39503, 224524, 4, 1969},
	{39528, 224528, 3, 2020},
	{39552, 224532, 3, 2020},
	{60069, 224768, 5, 1964},
	{60093, 224772, 4, 1958},
	{60118, 224776, 5, 1964},
	{60142, 224780, 4, 1958},
	{60167, 224784, 3, 2020},
	{60191, 224788, 3, 2020},
	{60215, 224832, 5, 1964},
	{60239, 224836, 4, 1958},
	{60264, 224840, 5, 1964},
	{60288, 224844, 4, 1958},
	{60313, 224848, 3, 2020},
	{60337, 224852, 3, 2020},
	{40253, 225280, 12, 2023},
	{40275, 225284, 5, 2035},
	{40298, 225288, 4, 2040},
	{40322, 225292, 2, 2044},
	{40345, 225296, 2, 2044},
	{40368, 225300, 2, 2044},
	{40391, 225536, 5, 1964},
	{40414, 225540, 4, 1969},
	{40438, 225544, 5, 1964},
	{40461, 225548, 4, 1969},
	{40485, 225552, 5, 1964},
	{40508, 225560, 5, 1964},
	{40531, 225792, 4, 2046},
	{40552, 225796},
	{40581, 225800, 2, 2050},
	{40610, 225804},
	{40636, 225808, 7, 2052},
	{40710, 225812},
	{40733, 225816},
	{60482, 225820, 2, 6292},
	{60515, 225824, 2, 6292},
	{60548, 225828, 2, 6292},
	{60581, 225832, 2, 6292},
	{60613, 225836, 2, 6292},
	{60645, 225840, 2, 6292},
	{60677, 225844, 2, 6292},
	{60710, 225848, 2, 6292},
	{60742, 225856, 2, 6292},
	{60774, 225860, 2, 6292},
	{60807, 225864, 2, 6292},
	{60840, 225868, 2, 6292},
	{60873, 225872, 2, 6292},
	{60905, 225876, 2, 6292},
	{60937, 225880, 2, 6292},
	{60970, 225884, 2, 6292},
	{61003, 225888, 2, 6292},
	{61069, 225896, 2, 6292},
	{40756, 225900},
	{40783, 225904},
	{40665, 225908},
	{40684, 225912},
	{61101, 225916, 2, 6292},
	{61135, 225920, 2, 6292},
	{61169, 225924, 2, 6292},
	{61203, 225928, 2, 6292},
	{41653, 226044, 1, 2136},
	{41446, 226048, 2, 2126},
	{41463, 226052, 1, 2128},
	{41487, 226056, 1, 2128},
	{206, 880, 4, 2163},
	{43232, 881},
	{27079, 882},
	{43244, 1008},
	{43255, 1009},
	{27267, 1010, 4, 2167},
	{43266, 1040, 1, 2171},
	{43279, 1041, 5, 6294},
	{43292, 1042, 1, 2177},
	{43305, 1043, 1, 1688},
	{27101, 1045, 9, 6086},
	{43333, 1281, 6, 6299},
	{43348, 1282},
	{27038, 1283},
	{43232, 1285},
	{27079, 1286},
};

static const struct si_reg gfx81_reg_table[] = {
	{1390, 68, 10, 6305},
	{1403, 72, 23, 6315},
	{1418, 76, 4, 6338},
	{55593, 80, 11, 6111},
	{1455, 84, 4, 4975},
	{1473, 88, 2, 3924},
	{1491, 92, 6, 6342},
	{1506, 96},
	{1520, 100, 1, 70},
	{1534, 104},
	{55607, 108},
	{55624, 112, 13, 6348},
	{1551, 116, 5, 6361},
	{55640, 2480},
	{55655, 2484, 1, 4997},
	{55670, 2488},
	{55685, 2492, 1, 4997},
	{1689, 2496},
	{1703, 2500},
	{1717, 2504},
	{1731, 2508},
	{1745, 2512},
	{1759, 2516},
	{1773, 2520},
	{1787, 2524},
	{1801, 2528},
	{1815, 2532},
	{1829, 2536},
	{1844, 2540},
	{1919, 2544},
	{1930, 2552},
	{1946, 2556},
	{55700, 3660, 21, 4998},
	{55713, 3664, 20, 5019},
	{55725, 3668, 16, 5039},
	{2034, 32776, 18, 6366},
	{2047, 32784, 24, 5077},
	{2059, 32788, 11, 5101},
	{2075, 32792, 11, 5101},
	{2104, 32824, 11, 5101},
	{2120, 32828, 11, 5101},
	{2136, 33296, 15, 6384},
	{2150, 33300, 28, 204},
	{2167, 33304, 14, 6399},
	{2188, 33308, 21, 6413},
	{2202, 33312, 31, 6194},
	{2219, 33316, 9, 6434},
	{2258, 33324, 1, 329},
	{2281, 33344, 1, 330},
	{2302, 33348},
	{2363, 33436, 1, 342},
	{58279, 36416},
	{2767, 36608},
	{2785, 36612, 4, 383},
	{2803, 36616},
	{2821, 36620, 14, 6443},
	{3722, 36624},
	{3740, 36628, 5, 6681},
	{3758, 36632, 4, 5759},
	{3776, 36636, 11, 5763},
	{3794, 36640, 2, 5774},
	{3812, 36644, 2, 5776},
	{3830, 36648, 8, 6462},
	{3848, 36652},
	{2839, 36656, 14, 6470},
	{2857, 36660, 4, 411},
	{2875, 36664, 10, 6484},
	{2893, 36668, 3, 5804},
	{2911, 37120, 6, 426},
	{2927, 39160, 9, 5807},
	{2942, 39184, 5, 5817},
	{2956, 39188, 5, 5817},
	{2970, 39192, 5, 5817},
	{2984, 39196, 5, 5817},
	{2998, 39200, 5, 5817},
	{3012, 39204, 5, 5817},
	{3026, 39208, 5, 5817},
	{3040, 39212, 5, 5817},
	{3054, 39216, 5, 5817},
	{3068, 39220, 5, 5817},
	{3082, 39224, 5, 5817},
	{3097, 39228, 5, 5817},
	{3112, 39232, 5, 5817},
	{3127, 39236, 5, 5817},
	{3142, 39240, 5, 5817},
	{3157, 39244, 5, 5817},
	{3172, 39248, 5, 5817},
	{3187, 39252, 5, 5817},
	{3202, 39256, 5, 5817},
	{3217, 39260, 5, 5817},
	{3232, 39264, 5, 5817},
	{3247, 39268, 5, 5817},
	{3262, 39272, 5, 5817},
	{3277, 39276, 5, 5817},
	{3292, 39280, 5, 5817},
	{3307, 39284, 5, 5817},
	{3322, 39288, 5, 5817},
	{3337, 39292, 5, 5817},
	{3352, 39296, 5, 5817},
	{3367, 39300, 5, 5817},
	{3382, 39304, 5, 5817},
	{3397, 39308, 5, 5817},
	{3412, 39312, 4, 445},
	{3431, 39316, 4, 445},
	{3450, 39320, 4, 445},
	{3469, 39324, 4, 445},
	{3488, 39328, 4, 445},
	{3507, 39332, 4, 445},
	{3526, 39336, 4, 445},
	{3545, 39340, 4, 445},
	{3564, 39344, 4, 445},
	{3583, 39348, 4, 445},
	{3602, 39352, 4, 445},
	{3622, 39356, 4, 445},
	{3642, 39360, 4, 445},
	{3662, 39364, 4, 445},
	{3682, 39368, 4, 445},
	{3702, 39372, 4, 445},
	{58513, 45056},
	{58534, 45060, 1, 498},
	{58555, 45064},
	{58576, 45068, 1, 498},
	{3947, 45084, 3, 495},
	{3971, 45088},
	{3992, 45092, 1, 498},
	{4013, 45096, 11, 5822},
	{4037, 45100, 6, 510},
	{4061, 45104},
	{4087, 45108},
	{4113, 45112},
	{4139, 45116},
	{4165, 45120},
	{4191, 45124},
	{4217, 45128},
	{4243, 45132},
	{4269, 45136},
	{4295, 45140},
	{4321, 45144},
	{4348, 45148},
	{4375, 45152},
	{4402, 45156},
	{4429, 45160},
	{4456, 45164},
	{58597, 45312},
	{58618, 45316, 1, 498},
	{58639, 45320},
	{58660, 45324, 1, 498},
	{5128, 45336, 3, 495},
	{5152, 45340, 1, 534},
	{5177, 45344},
	{5198, 45348, 1, 498},
	{5219, 45352, 12, 5839},
	{5243, 45356, 11, 6494},
	{5267, 45360},
	{5293, 45364},
	{5319, 45368},
	{5345, 45372},
	{5371, 45376},
	{5397, 45380},
	{5423, 45384},
	{5449, 45388},
	{5475, 45392},
	{5501, 45396},
	{5527, 45400},
	{5554, 45404},
	{5581, 45408},
	{5608, 45412},
	{5635, 45416},
	{5662, 45420},
	{6312, 45552, 6, 570},
	{6339, 45556, 5, 576},
	{58681, 45568},
	{58702, 45572, 1, 498},
	{58723, 45576},
	{58744, 45580, 1, 498},
	{6527, 45596, 4, 583},
	{6551, 45600},
	{6572, 45604, 1, 498},
	{6593, 45608, 11, 5861},
	{6617, 45612, 4, 561},
	{6641, 45616},
	{6667, 45620},
	{6693, 45624},
	{6719, 45628},
	{6745, 45632},
	{6771, 45636},
	{6797, 45640},
	{6823, 45644},
	{6849, 45648},
	{6875, 45652},
	{6901, 45656},
	{6928, 45660},
	{6955, 45664},
	{6982, 45668},
	{7009, 45672},
	{7036, 45676},
	{7671, 45808, 6, 570},
	{58765, 45824},
	{58786, 45828, 1, 498},
	{58807, 45832},
	{58828, 45836, 1, 498},
	{7698, 45852, 4, 583},
	{7722, 45856},
	{7743, 45860, 1, 498},
	{7764, 45864, 12, 5839},
	{7788, 45868, 6, 570},
	{7812, 45872},
	{7838, 45876},
	{7864, 45880},
	{7890, 45884},
	{7916, 45888},
	{7942, 45892},
	{7968, 45896},
	{7994, 45900},
	{8020, 45904},
	{8046, 45908},
	{8072, 45912},
	{8099, 45916},
	{8126, 45920},
	{8153, 45924},
	{8180, 45928},
	{8207, 45932},
	{8234, 46068, 5, 576},
	{58849, 46080},
	{58870, 46084, 1, 498},
	{58891, 46088},
	{58912, 46092, 1, 498},
	{8422, 46108, 3, 619},
	{8446, 46112},
	{8467, 46116, 1, 498},
	{8488, 46120, 10, 5882},
	{8512, 46124, 6, 635},
	{8536, 46128},
	{8562, 46132},
	{8588, 46136},
	{8614, 46140},
	{8640, 46144},
	{8666, 46148},
	{8692, 46152},
	{8718, 46156},
	{8744, 46160},
	{8770, 46164},
	{8796, 46168},
	{8823, 46172},
	{8850, 46176},
	{8877, 46180},
	{8904, 46184},
	{8931, 46188},
	{9566, 46324, 5, 576},
	{58933, 46336},
	{58954, 46340, 1, 498},
	{58975, 46344},
	{58996, 46348, 1, 498},
	{9593, 46364, 4, 583},
	{9617, 46368},
	{9638, 46372, 1, 498},
	{9659, 46376, 11, 5898},
	{9683, 46380, 5, 576},
	{9707, 46384},
	{9733, 46388},
	{9759, 46392},
	{9785, 46396},
	{9811, 46400},
	{9837, 46404},
	{9863, 46408},
	{9889, 46412},
	{9915, 46416},
	{9941, 46420},
	{9967, 46424},
	{9994, 46428},
	{10021, 46432},
	{10048, 46436},
	{10075, 46440},
	{10102, 46444},
	{10129, 47104, 12, 5914},
	{10156, 47108},
	{10170, 47112},
	{10184, 47116},
	{10198, 47120},
	{10214, 47124},
	{10230, 47128},
	{10246, 47132, 2, 666},
	{10267, 47136, 2, 666},
	{10288, 47140, 2, 666},
	{10309, 47144, 1, 668},
	{10337, 47148, 1, 669},
	{10362, 47152},
	{10377, 47156, 2, 5927},
	{59037, 47160},
	{59052, 47164, 1, 670},
	{59067, 47168},
	{59082, 47172, 1, 670},
	{10516, 47176, 10, 5929},
	{10534, 47180, 11, 683},
	{10552, 47184, 1, 694},
	{10565, 47188, 6, 695},
	{59097, 47192, 2, 5946},
	{59128, 47196, 2, 5946},
	{10643, 47200, 2, 701},
	{59311, 47204, 2, 5946},
	{59342, 47208, 2, 5946},
	{10718, 47212},
	{10736, 47216},
	{10754, 47220},
	{10772, 47224, 1, 703},
	{10800, 47228, 5, 704},
	{10822, 47232},
	{10842, 47236},
	{11025, 47240, 3, 720},
	{11042, 47244},
	{11071, 47248, 1, 723},
	{61237, 47252, 2, 6505},
	{11118, 47360},
	{11138, 47364},
	{11158, 47368},
	{11178, 47372},
	{11198, 47376},
	{11218, 47380},
	{11238, 47384},
	{11258, 47388},
	{11278, 47392},
	{11298, 47396},
	{11318, 47400},
	{11339, 47404},
	{11360, 47408},
	{11381, 47412},
	{11402, 47416},
	{11423, 47420},
	{11489, 47612},
	{59159, 53300, 29, 5948},
	{59176, 55348, 29, 5948},
	{11505, 163840, 10, 726},
	{11523, 163844, 9, 5977},
	{11540, 163848, 4, 5986},
	{11554, 163852, 23, 754},
	{11573, 163856, 15, 777},
	{11593, 163860},
	{11629, 163872},
	{11649, 163876},
	{11669, 163880, 1, 795},
	{11686, 163884},
	{11701, 163888, 2, 796},
	{11725, 163892, 2, 798},
	{59193, 163900, 7, 5990},
	{11783, 163904, 10, 6507},
	{11793, 163908, 6, 6517},
	{11809, 163912},
	{11824, 163916},
	{11845, 163920},
	{11861, 163924},
	{59207, 163928, 2, 6010},
	{59221, 163932, 1, 6012},
	{12051, 163968},
	{12067, 163972, 1, 847},
	{12086, 164328, 1, 848},
	{12107, 164332, 1, 848},
	{12128, 164336, 1, 848},
	{12149, 164340, 1, 848},
	{12170, 164344},
	{12188, 164348},
	{12206, 164352, 2, 849},
	{12226, 164356, 3, 851},
	{12250, 164360, 2, 854},
	{12274, 164364, 1, 856},
	{12294, 164368, 2, 851},
	{12314, 164372, 2, 854},
	{12334, 164376, 2, 851},
	{12354, 164380, 2, 854},
	{12374, 164384, 2, 851},
	{12394, 164388, 2, 854},
	{12414, 164392, 2, 851},
	{12434, 164396, 2, 854},
	{12454, 164400, 7, 857},
	{12469, 164404, 2, 864},
	{12498, 164408, 8, 866},
	{12513, 164412, 8, 874},
	{12528, 164416, 3, 851},
	{12553, 164420, 2, 854},
	{12578, 164424},
	{12596, 164428},
	{12614, 164432, 3, 851},
	{12639, 164436, 2, 854},
	{12664, 164440, 3, 851},
	{12689, 164444, 2, 854},
	{12714, 164448, 3, 851},
	{12739, 164452, 2, 854},
	{12764, 164456, 3, 851},
	{12789, 164460, 2, 854},
	{12814, 164464, 3, 851},
	{12839, 164468, 2, 854},
	{12864, 164472, 3, 851},
	{12889, 164476, 2, 854},
	{12914, 164480, 3, 851},
	{12939, 164484, 2, 854},
	{12964, 164488, 3, 851},
	{12989, 164492, 2, 854},
	{13014, 164496, 3, 851},
	{13039, 164500, 2, 854},
	{13064, 164504, 3, 851},
	{13089, 164508, 2, 854},
	{13114, 164512, 3, 851},
	{13140, 164516, 2, 854},
	{13166, 164520, 3, 851},
	{13192, 164524, 2, 854},
	{13218, 164528, 3, 851},
	{13244, 164532, 2, 854},
	{13270, 164536, 3, 851},
	{13296, 164540, 2, 854},
	{13322, 164544, 3, 851},
	{13348, 164548, 2, 854},
	{13374, 164552, 3, 851},
	{13400, 164556, 2, 854},
	{13426, 164560},
	{13445, 164564},
	{13464, 164568},
	{13483, 164572},
	{13502, 164576},
	{13521, 164580},
	{13540, 164584},
	{13559, 164588},
	{13578, 164592},
	{13597, 164596},
	{13616, 164600},
	{13635, 164604},
	{13654, 164608},
	{13673, 164612},
	{13692, 164616},
	{13711, 164620},
	{13730, 164624},
	{13749, 164628},
	{13768, 164632},
	{13787, 164636},
	{13806, 164640},
	{13826, 164644},
	{13846, 164648},
	{13866, 164652},
	{13886, 164656},
	{13906, 164660},
	{13926, 164664},
	{13946, 164668},
	{13966, 164672},
	{13986, 164676},
	{14006, 164680},
	{14026, 164684},
	{14046, 164688, 15, 882},
	{14066, 164692, 3, 897},
	{14088, 164696, 2, 900},
	{14145, 164704, 1, 909},
	{59236, 164708, 1, 6013},
	{14176, 164712, 1, 911},
	{14244, 164864},
	{14261, 164868},
	{14278, 164872},
	{14294, 164876},
	{14348, 164884},
	{14361, 164888},
	{14376, 164892},
	{14390, 164896},
	{14405, 164900, 3, 6523},
	{14444, 164908, 6, 942},
	{14463, 164912, 4, 948},
	{14481, 164916, 4, 952},
	{14502, 164924},
	{14521, 164928},
	{14541, 164932},
	{14560, 164936},
	{14580, 164940},
	{14599, 164944},
	{14619, 164948},
	{14640, 164952},
	{14662, 164956},
	{14683, 164960},
	{14705, 164964},
	{14726, 164968},
	{14748, 164972},
	{14769, 164976},
	{14791, 164980},
	{14812, 164984},
	{14834, 164988},
	{14855, 164992},
	{14877, 164996},
	{14898, 165000},
	{14920, 165004},
	{14941, 165008},
	{14963, 165012},
	{14984, 165016},
	{15006, 165020},
	{15027, 165024},
	{15049, 165028},
	{15070, 165032},
	{15092, 165036},
	{15113, 165040},
	{15135, 165044},
	{15156, 165048},
	{15178, 165052},
	{15199, 165056},
	{15221, 165060},
	{15242, 165064},
	{15264, 165068},
	{15285, 165072},
	{15307, 165076},
	{15328, 165080},
	{15350, 165084},
	{15371, 165088},
	{15393, 165092},
	{15414, 165096},
	{15436, 165100},
	{15457, 165104},
	{15479, 165108},
	{15500, 165112},
	{15522, 165116},
	{15543, 165120},
	{15565, 165124},
	{15586, 165128},
	{15608, 165132},
	{15629, 165136},
	{15651, 165140},
	{15672, 165144},
	{15694, 165148},
	{15715, 165152},
	{15737, 165156},
	{15758, 165160},
	{15780, 165164},
	{15802, 165168},
	{15825, 165172},
	{15847, 165176},
	{15870, 165180},
	{15892, 165184},
	{15915, 165188},
	{15937, 165192},
	{15960, 165196},
	{15982, 165200},
	{16005, 165204},
	{16027, 165208},
	{16050, 165212},
	{16072, 165216},
	{16095, 165220},
	{16117, 165224},
	{16140, 165228},
	{16162, 165232},
	{16185, 165236},
	{16207, 165240},
	{16230, 165244},
	{16252, 165248},
	{16275, 165252},
	{16297, 165256},
	{16320, 165260},
	{16342, 165264},
	{16365, 165268},
	{16387, 165272},
	{16410, 165276},
	{16432, 165280},
	{16455, 165284},
	{16477, 165288},
	{16500, 165292},
	{16522, 165296},
	{16545, 165300},
	{16567, 165304},
	{16590, 165308},
	{16604, 165312},
	{16618, 165316},
	{16632, 165320},
	{16646, 165324},
	{16660, 165328},
	{16674, 165332},
	{16688, 165336},
	{16702, 165340},
	{16716, 165344},
	{16730, 165348},
	{16744, 165352},
	{16758, 165356},
	{16772, 165360},
	{16786, 165364},
	{16800, 165368},
	{16814, 165372},
	{16828, 165376},
	{16842, 165380},
	{16856, 165384},
	{16870, 165388},
	{16884, 165392},
	{16898, 165396},
	{16912, 165400},
	{16949, 165444, 12, 956},
	{16969, 165448, 12, 956},
	{16989, 165452, 12, 956},
	{17009, 165456, 12, 956},
	{17029, 165460, 12, 956},
	{17049, 165464, 12, 956},
	{17069, 165468, 12, 956},
	{17089, 165472, 12, 956},
	{17109, 165476, 12, 956},
	{17129, 165480, 12, 956},
	{17149, 165484, 12, 956},
	{17170, 165488, 12, 956},
	{17191, 165492, 12, 956},
	{17212, 165496, 12, 956},
	{17233, 165500, 12, 956},
	{17254, 165504, 12, 956},
	{17275, 165508, 12, 956},
	{17296, 165512, 12, 956},
	{17317, 165516, 12, 956},
	{17338, 165520, 12, 956},
	{17359, 165524, 9, 968},
	{17380, 165528, 9, 968},
	{17401, 165532, 9, 968},
	{17422, 165536, 9, 968},
	{17443, 165540, 9, 968},
	{17464, 165544, 9, 968},
	{17485, 165548, 9, 968},
	{17506, 165552, 9, 968},
	{17527, 165556, 9, 968},
	{17548, 165560, 9, 968},
	{17569, 165564, 9, 968},
	{17590, 165568, 9, 968},
	{17611, 165572, 2, 977},
	{17629, 165580, 16, 980},
	{17646, 165584, 16, 980},
	{17664, 165588, 7, 996},
	{17685, 165592, 3, 6014},
	{17703, 165600, 7, 1009},
	{17718, 165608, 2, 701},
	{17757, 165644, 4, 1017},
	{17779, 165648, 1, 1022},
	{17799, 165652, 8, 1023},
	{17821, 165716, 8, 1031},
	{17839, 165720, 8, 1039},
	{17860, 165724, 17, 1047},
	{17881, 165728, 6, 1064},
	{17899, 165732, 6, 1064},
	{17917, 165736, 6, 1064},
	{17935, 165740, 6, 1064},
	{17953, 165744, 6, 1064},
	{17971, 165748, 6, 1064},
	{17989, 165752, 6, 1064},
	{18007, 165756, 6, 1064},
	{18025, 165760, 9, 1070},
	{18043, 165764, 9, 1070},
	{18061, 165768, 9, 1070},
	{18079, 165772, 9, 1070},
	{18097, 165776, 9, 1070},
	{18115, 165780, 9, 1070},
	{18133, 165784, 9, 1070},
	{18151, 165788, 9, 1070},
	{18169, 165836, 1, 1079},
	{18183, 165840, 1, 1079},
	{18198, 165844},
	{18216, 165848},
	{18234, 165852},
	{18251, 165856},
	{18272, 165860, 1, 6017},
	{18288, 165864},
	{18301, 165872, 5, 1081},
	{18320, 165876},
	{18335, 165880, 1, 1089},
	{18384, 165888, 10, 1091},
	{18401, 165892, 12, 1101},
	{18409, 165896, 4, 6686},
	{18426, 165900, 13, 1117},
	{18444, 165904, 19, 1134},
	{18460, 165908, 13, 1154},
	{18479, 165912, 10, 1170},
	{18494, 165916, 27, 6529},
	{18512, 165920, 16, 1208},
	{18530, 165924, 4, 1224},
	{18554, 165928},
	{18579, 165932, 11, 1228},
	{18731, 166400, 2, 1260},
	{18748, 166404, 2, 1262},
	{18767, 166408, 1, 1264},
	{18783, 166412, 4, 1265},
	{18802, 166416, 1, 1269},
	{18823, 166420, 1, 1270},
	{18836, 166424},
	{18859, 166428},
	{18882, 166432, 1, 1271},
	{18902, 166436, 4, 6021},
	{18922, 166440, 1, 1276},
	{18943, 166444, 1, 1277},
	{18958, 166448, 6, 1278},
	{18980, 166452, 6, 1278},
	{19002, 166456, 8, 1284},
	{19028, 166460, 8, 1284},
	{19054, 166464, 15, 6556},
	{19066, 166468, 2, 1307},
	{19085, 166472, 4, 1310},
	{19103, 166476, 24, 1317},
	{19121, 166480},
	{19133, 166484, 1, 1341},
	{19147, 166488, 1, 1342},
	{19161, 166492, 1, 1343},
	{19175, 166496, 1, 1344},
	{19198, 166500, 1, 1344},
	{19221, 166504, 1, 1344},
	{19244, 166508, 5, 6025},
	{19265, 166512},
	{19276, 166516},
	{19289, 166520},
	{19306, 166524, 7, 6571},
	{19325, 166528},
	{19336, 166532, 2, 1358},
	{19355, 166536},
	{19377, 166540},
	{19399, 166544, 3, 6578},
	{19419, 166548, 1, 1364},
	{19468, 166560},
	{19493, 166564},
	{19518, 166568, 7, 6581},
	{19537, 166572, 1, 1377},
	{19560, 166576, 1, 1377},
	{19583, 166580, 1, 1378},
	{19597, 166584, 1, 1379},
	{19612, 166588, 8, 6588},
	{19629, 166592, 4, 1389},
	{19656, 166596, 4, 1393},
	{19683, 166600, 4, 1397},
	{19702, 166608},
	{19728, 166612, 1, 1401},
	{19753, 166620},
	{19781, 166624},
	{19807, 166628, 1, 1401},
	{19832, 166636},
	{19860, 166640},
	{19886, 166644, 1, 1401},
	{19911, 166652},
	{19939, 166656},
	{19965, 166660, 1, 1401},
	{19990, 166668},
	{20018, 166696},
	{20049, 166700},
	{20092, 166704, 1, 1402},
	{20130, 166712, 1, 1403},
	{20169, 166736, 4, 6690},
	{20191, 166740, 10, 1411},
	{20212, 166744, 3, 1430},
	{20229, 166748, 1, 1377},
	{20250, 166752, 1, 1377},
	{20273, 166756, 1, 1377},
	{20296, 166760, 1, 1377},
	{20319, 166764, 10, 6596},
	{20332, 166768, 6, 1445},
	{20349, 166772},
	{20373, 166776, 2, 1451},
	{20403, 166780},
	{20427, 166784},
	{20457, 166788},
	{20488, 166792},
	{20517, 166796},
	{20547, 166800, 2, 1453},
	{20567, 166804, 7, 6055},
	{20586, 166808, 4, 1464},
	{20636, 166868, 8, 1468},
	{20662, 166872, 8, 1476},
	{20688, 166876, 4, 1484},
	{20704, 166880, 5, 1489},
	{20720, 166884, 3, 1495},
	{20735, 166888},
	{20758, 166892},
	{20781, 166896},
	{20804, 166900},
	{20827, 166904, 8, 1498},
	{20861, 166908, 8, 1506},
	{20895, 166912, 8, 1514},
	{20929, 166916, 8, 1522},
	{20963, 166920, 8, 1498},
	{20997, 166924, 8, 1506},
	{21031, 166928, 8, 1514},
	{21065, 166932, 8, 1522},
	{21099, 166936, 8, 1498},
	{21133, 166940, 8, 1506},
	{21167, 166944, 8, 1514},
	{21201, 166948, 8, 1522},
	{21235, 166952, 8, 1498},
	{21269, 166956, 8, 1506},
	{21303, 166960, 8, 1514},
	{21337, 166964, 8, 1522},
	{21371, 166968, 2, 1530},
	{21395, 166972, 2, 1532},
	{21419, 166976, 1, 1534},
	{21538, 167000, 1, 1574},
	{21566, 167004, 1, 1575},
	{21587, 167008},
	{21602, 167012, 2, 1576},
	{21618, 167016, 1, 1578},
	{21634, 167020, 2, 5986},
	{21649, 167024, 18, 6694},
	{21664, 167028, 6, 1601},
	{21681, 167032, 9, 1609},
	{21703, 167036},
	{21719, 167040, 1, 1621},
	{21741, 167044},
	{21757, 167048, 1, 1578},
	{21779, 167052},
	{21801, 167056},
	{21823, 167060},
	{21842, 167068},
	{21857, 167072, 2, 1576},
	{21873, 167076, 1, 1578},
	{21889, 167080, 2, 5986},
	{21904, 167084, 18, 6694},
	{21919, 167088, 6, 1601},
	{21936, 167092, 9, 1609},
	{21958, 167096},
	{21974, 167100, 1, 1621},
	{21996, 167104},
	{22012, 167108, 1, 1578},
	{22034, 167112},
	{22056, 167116},
	{22078, 167120},
	{22097, 167128},
	{22112, 167132, 2, 1576},
	{22128, 167136, 1, 1578},
	{22144, 167140, 2, 5986},
	{22159, 167144, 18, 6694},
	{22174, 167148, 6, 1601},
	{22191, 167152, 9, 1609},
	{22213, 167156},
	{22229, 167160, 1, 1621},
	{22251, 167164},
	{22267, 167168, 1, 1578},
	{22289, 167172},
	{22311, 167176},
	{22333, 167180},
	{22352, 167188},
	{22367, 167192, 2, 1576},
	{22383, 167196, 1, 1578},
	{22399, 167200, 2, 5986},
	{22414, 167204, 18, 6694},
	{22429, 167208, 6, 1601},
	{22446, 167212, 9, 1609},
	{22468, 167216},
	{22484, 167220, 1, 1621},
	{22506, 167224},
	{22522, 167228, 1, 1578},
	{22544, 167232},
	{22566, 167236},
	{22588, 167240},
	{22607, 167248},
	{22622, 167252, 2, 1576},
	{22638, 167256, 1, 1578},
	{22654, 167260, 2, 5986},
	{22669, 167264, 18, 6694},
	{22684, 167268, 6, 1601},
	{22701, 167272, 9, 1609},
	{22723, 167276},
	{22739, 167280, 1, 1621},
	{22761, 167284},
	{22777, 167288, 1, 1578},
	{22799, 167292},
	{22821, 167296},
	{22843, 167300},
	{22862, 167308},
	{22877, 167312, 2, 1576},
	{22893, 167316, 1, 1578},
	{22909, 167320, 2, 5986},
	{22924, 167324, 18, 6694},
	{22939, 167328, 6, 1601},
	{22956, 167332, 9, 1609},
	{22978, 167336},
	{22994, 167340, 1, 1621},
	{23016, 167344},
	{23032, 167348, 1, 1578},
	{23054, 167352},
	{23076, 167356},
	{23098, 167360},
	{23117, 167368},
	{23132, 167372, 2, 1576},
	{23148, 167376, 1, 1578},
	{23164, 167380, 2, 5986},
	{23179, 167384, 18, 6694},
	{23194, 167388, 6, 1601},
	{23211, 167392, 9, 1609},
	{23233, 167396},
	{23249, 167400, 1, 1621},
	{23271, 167404},
	{23287, 167408, 1, 1578},
	{23309, 167412},
	{23331, 167416},
	{23353, 167420},
	{23372, 167428},
	{23387, 167432, 2, 1576},
	{23403, 167436, 1, 1578},
	{23419, 167440, 2, 5986},
	{23434, 167444, 18, 6694},
	{23449, 167448, 6, 1601},
	{23466, 167452, 9, 1609},
	{23488, 167456},
	{23504, 167460, 1, 1621},
	{23526, 167464},
	{23542, 167468, 1, 1578},
	{23564, 167472},
	{23586, 167476},
	{23608, 167480},
	{24651, 196608, 1, 1634},
	{24671, 196612, 1, 1635},
	{24691, 196616},
	{24711, 196620},
	{24731, 196624},
	{24752, 196628},
	{24773, 196632, 1, 1636},
	{24795, 196636, 1, 1637},
	{24817, 196640},
	{24847, 196644},
	{24877, 196648},
	{24906, 196652},
	{24935, 196656},
	{24965, 196660},
	{24995, 196664},
	{25024, 196668},
	{25053, 196672},
	{25083, 196676},
	{25113, 196680},
	{25142, 196684},
	{25171, 196688},
	{25201, 196692},
	{25231, 196696},
	{25260, 196700},
	{25289, 196704, 1, 1638},
	{25311, 196708, 1, 1639},
	{25333, 196712},
	{25356, 196716},
	{25379, 196720},
	{25402, 196724},
	{25425, 196728},
	{25448, 196732},
	{25471, 196736},
	{25495, 196740},
	{25519, 196744},
	{25543, 196748},
	{25567, 196752},
	{25591, 196756},
	{25615, 196760},
	{25639, 196764},
	{25663, 196768},
	{25685, 196772},
	{25707, 196776},
	{25728, 196780},
	{25749, 196784},
	{25773, 196788},
	{25797, 196792},
	{25821, 196796},
	{25845, 196800},
	{25869, 196804},
	{25953, 196852, 2, 6624},
	{25975, 196856, 2, 6624},
	{25997, 196860, 1, 1642},
	{26013, 196864},
	{26026, 196868},
	{26039, 196872},
	{26052, 196876},
	{26065, 196880},
	{26078, 196884},
	{26091, 196888},
	{26104, 196892},
	{26231, 196928, 2, 1643},
	{26244, 196932},
	{26257, 196936},
	{26280, 196940},
	{26303, 196944},
	{26331, 196948},
	{26359, 196952},
	{26387, 196956},
	{26415, 196960, 1, 1645},
	{26433, 196964, 5, 6626},
	{26451, 196968},
	{26466, 196972},
	{26490, 196976},
	{26514, 196980},
	{26533, 196984},
	{26552, 196988},
	{26576, 196992},
	{26600, 196996},
	{26624, 197000},
	{26648, 197028, 2, 5213},
	{26666, 197032, 3, 6631},
	{26684, 197036},
	{26702, 197040},
	{26720, 197044, 2, 5216},
	{26738, 197048, 3, 6634},
	{26756, 197052},
	{26774, 197056, 2, 1656},
	{26793, 197060, 5, 1658},
	{26812, 197072},
	{26836, 197076, 2, 1656},
	{26856, 197080, 5, 1658},
	{26876, 197084, 8, 6637},
	{26895, 197088, 8, 6637},
	{26913, 197092, 1, 1670},
	{26930, 197100, 1, 1671},
	{26951, 197104, 26, 6645},
	{26965, 197108},
	{26979, 197112},
	{26993, 197116, 4, 5247},
	{27009, 197120},
	{27028, 197124, 1, 1687},
	{27050, 197128},
	{27069, 197132, 1, 1688},
	{27091, 197136, 9, 5253},
	{27109, 197140},
	{27129, 197144, 1, 1687},
	{27152, 197148},
	{27172, 197152, 1, 1688},
	{27195, 197156, 9, 5253},
	{27214, 197160, 5, 5262},
	{27226, 197164, 2, 1703},
	{27243, 197168, 1, 1705},
	{27260, 197172, 1, 1706},
	{27278, 197176, 4, 1707},
	{27298, 197180, 1, 1711},
	{27315, 197184},
	{27331, 197188, 1, 1713},
	{27344, 197192, 1, 1714},
	{27358, 197196, 1, 1715},
	{27372, 197200, 1, 1716},
	{27394, 197204, 1, 1717},
	{27414, 197208, 1, 1718},
	{27436, 197212, 1, 1719},
	{27456, 197216, 1, 1714},
	{27473, 197220, 1, 1715},
	{27490, 197224},
	{61266, 197228, 1, 1713},
	{27749, 197388, 1, 1728},
	{27768, 197392, 1, 1729},
	{27787, 197396, 1, 1730},
	{27804, 197400, 1, 1731},
	{27822, 197404, 1, 1732},
	{27840, 197408, 1, 1733},
	{27856, 197412, 1, 1734},
	{27874, 197416, 1, 1735},
	{27892, 197420, 1, 1736},
	{27908, 197424, 1, 1731},
	{27923, 197428, 1, 1732},
	{27938, 197432, 1, 1733},
	{27951, 197436, 1, 1734},
	{27966, 197440, 1, 1735},
	{27981, 197444, 1, 1736},
	{27994, 197448, 1, 1737},
	{28008, 197452, 1, 1738},
	{28022, 197456, 1, 1739},
	{28034, 197460, 4, 6671},
	{28057, 197464, 4, 6264},
	{28079, 197468, 1, 1747},
	{28223, 197552, 1, 1752},
	{28248, 197556, 1, 1752},
	{28272, 197560, 1, 1753},
	{28292, 197568},
	{28318, 197572, 1, 1635},
	{28347, 197576},
	{28372, 197580, 1, 1635},
	{28400, 197584},
	{28423, 197588, 1, 1635},
	{28449, 197592},
	{28471, 197596, 1, 1635},
	{28496, 197600},
	{28515, 197604, 1, 1635},
	{28537, 197608, 1, 1350},
	{28551, 197612},
	{28568, 197616, 1, 1635},
	{28588, 197620, 8, 1754},
	{28757, 198656, 6, 5119},
	{28772, 198912},
	{28791, 198916},
	{28810, 198920, 1, 5502},
	{28829, 198924, 1, 1350},
	{28844, 198928},
	{28877, 198932},
	{28910, 198936},
	{28943, 198940},
	{29033, 198960},
	{29049, 198964},
	{29067, 198968, 1, 1792},
	{29084, 198972, 2, 1793},
	{29105, 198976},
	{29437, 199168, 1, 1816},
	{29462, 199172, 2, 1817},
	{29487, 199184, 2, 1819},
	{29513, 199188, 2, 1819},
	{29539, 199192, 2, 1819},
	{29565, 199212, 2, 1819},
	{29591, 199296, 2, 1821},
	{29619, 199300, 1, 1823},
	{29643, 199304, 1, 1824},
	{29667, 199308, 1, 1825},
	{29700, 199312, 1, 1825},
	{29728, 199328, 2, 1821},
	{29757, 199332, 1, 1823},
	{29782, 199336, 1, 1824},
	{29807, 199340, 1, 1825},
	{29841, 199344, 1, 1825},
	{29870, 199360, 2, 1821},
	{29894, 199364, 1, 1823},
	{29914, 199368, 1, 1824},
	{29934, 199372, 1, 1825},
	{29963, 199376, 1, 1825},
	{58190, 199872},
	{58211, 199876, 1, 4849},
	{2511, 199880, 8, 6232},
	{2532, 199884, 3, 5687},
	{58232, 199888, 2, 5690},
	{2559, 199892, 1, 5714},
	{58258, 199896, 15, 5699},
	{59261, 199900, 1, 6241},
	{59283, 199904},
	{2490, 199908, 2, 5692},
	{2580, 199912, 5, 6244},
	{58300, 199916, 1, 5715},
	{29987, 199936},
	{30014, 199940},
	{30041, 199944},
	{30068, 199948},
	{30203, 199968, 6, 1826},
	{30214, 199972, 2, 1833},
	{30228, 200192},
	{30247, 200196, 1, 847},
	{30269, 200448},
	{30293, 200452, 1, 1835},
	{30316, 200456},
	{30340, 200460, 1, 1835},
	{30363, 200464},
	{30387, 200468, 1, 1835},
	{30410, 200472},
	{30434, 200476, 1, 1835},
	{30457, 200696},
	{30476, 200700, 1, 1835},
	{30494, 200704},
	{30506, 200708},
	{30518, 200712},
	{30536, 200716},
	{30555, 200720},
	{30573, 200724},
	{30585, 200728},
	{30597, 200732},
	{30615, 200736},
	{30633, 200740},
	{30652, 200744, 4, 1836},
	{30666, 200748, 2, 1840},
	{30684, 200752, 2, 1842},
	{30698, 200756, 2, 1844},
	{30712, 200760, 2, 1846},
	{30729, 200764, 2, 1848},
	{30746, 200768},
	{30759, 200772, 2, 1850},
	{30771, 200776},
	{30785, 200780},
	{30801, 200784},
	{30815, 200788},
	{30831, 200792},
	{30846, 200796},
	{30863, 200800},
	{30878, 200804},
	{30895, 200808, 2, 1852},
	{30917, 200812, 9, 6712},
	{30934, 200816, 2, 1864},
	{30955, 200820, 2, 1866},
	{30967, 200824},
	{30982, 200828, 6, 6675},
	{30997, 200832, 2, 1874},
	{31011, 200836},
	{31124, 212992},
	{31144, 212996},
	{31164, 213000},
	{31184, 213004},
	{31204, 213008},
	{31224, 213012},
	{31244, 213016},
	{31264, 213020},
	{31284, 213024},
	{31304, 213028},
	{31324, 213032},
	{31344, 213036},
	{31433, 213248},
	{31454, 213252},
	{31475, 213260},
	{31496, 213264},
	{31517, 213268},
	{31541, 213272},
	{31565, 213276},
	{31589, 213280},
	{31613, 213284},
	{31637, 213288},
	{31661, 213292},
	{31685, 213296},
	{53472, 213504},
	{53499, 213508},
	{53526, 213512},
	{53553, 213516},
	{59373, 213520},
	{59392, 213524},
	{59411, 213528},
	{59430, 213532},
	{56863, 213536},
	{56882, 213540},
	{56901, 213544},
	{56920, 213548},
	{56939, 213552},
	{56958, 213556},
	{56977, 213560},
	{56996, 213564},
	{57416, 213568},
	{57436, 213572},
	{57456, 213576},
	{57476, 213580},
	{57496, 213584},
	{57516, 213588},
	{57536, 213592},
	{57556, 213596},
	{32169, 214016},
	{32191, 214020, 1, 1876},
	{32213, 214024},
	{32235, 214028, 1, 1876},
	{32257, 214032},
	{32279, 214036, 1, 1876},
	{32301, 214040},
	{32323, 214044, 1, 1876},
	{32345, 214272},
	{32367, 214276},
	{32389, 214280},
	{32411, 214284},
	{32433, 214288},
	{32455, 214292},
	{32477, 214296},
	{32499, 214300},
	{32521, 214304},
	{32543, 214308},
	{32565, 214312},
	{32587, 214316},
	{32609, 214320},
	{32631, 214324},
	{32653, 214328},
	{32675, 214332},
	{32697, 214528},
	{32717, 214532},
	{32737, 214536},
	{32757, 214540},
	{32777, 214544},
	{32797, 214548},
	{32817, 214552},
	{32837, 214556},
	{32857, 214560},
	{32877, 214564},
	{32897, 214568},
	{32917, 214572},
	{32937, 214784},
	{32956, 214788},
	{32975, 214792},
	{32994, 214796},
	{33013, 214800},
	{33032, 214804},
	{33051, 214808},
	{33070, 214812},
	{33089, 214816},
	{33108, 214820},
	{33127, 214824},
	{33146, 214828},
	{33165, 214832},
	{33184, 214836},
	{33203, 214840},
	{33222, 214844},
	{33241, 214848},
	{33260, 214852},
	{33279, 214856},
	{33298, 214860},
	{33317, 214864},
	{33337, 214868},
	{33357, 214872},
	{33377, 214876},
	{33397, 214880},
	{33417, 214884},
	{33437, 214888},
	{33457, 214892},
	{33477, 214896},
	{33497, 214900},
	{33517, 214904},
	{33537, 214908},
	{33557, 215296},
	{33576, 215300},
	{33595, 215304},
	{33614, 215308},
	{33633, 215312},
	{33652, 215316},
	{33671, 215320},
	{33690, 215324},
	{33751, 215552},
	{33771, 215556},
	{33791, 215560},
	{33811, 215564},
	{33831, 215568},
	{33851, 215572},
	{33871, 215576},
	{33891, 215580},
	{33911, 215808},
	{33930, 215812},
	{33949, 215816},
	{33968, 215820},
	{33987, 216064},
	{34006, 216068},
	{34025, 216072},
	{34044, 216076},
	{34063, 216320},
	{34083, 216324},
	{34103, 216328},
	{34123, 216332},
	{34143, 216336},
	{34163, 216340},
	{34183, 216344},
	{34203, 216348},
	{59449, 216576},
	{59469, 216580},
	{59489, 216584},
	{59509, 216588},
	{59529, 216592},
	{59549, 216596},
	{59569, 216600},
	{59589, 216604},
	{59609, 216640},
	{59629, 216644},
	{59649, 216648},
	{59669, 216652},
	{59689, 216656},
	{59709, 216660},
	{59729, 216664},
	{59749, 216668},
	{35055, 217112},
	{35074, 217116},
	{35093, 217120},
	{35112, 217124},
	{35131, 217128},
	{35150, 217132},
	{35169, 217136},
	{35188, 217140},
	{35207, 217344},
	{35226, 217348},
	{35245, 217352},
	{35264, 217356},
	{35283, 217360},
	{35302, 217364},
	{35321, 217368},
	{35340, 217372},
	{35359, 217600},
	{35379, 217604},
	{35399, 217608},
	{35419, 217612},
	{36741, 221184, 1, 1910},
	{36765, 221188, 2, 6281},
	{36790, 221192, 3, 6283},
	{36814, 221196, 1, 1910},
	{36838, 221200, 2, 6281},
	{36863, 221204, 1, 1910},
	{36887, 221208, 2, 6281},
	{36912, 221212, 3, 6283},
	{36936, 221216, 4, 1888},
	{36952, 221220, 3, 6283},
	{37119, 221248},
	{37134, 221252, 1, 1825},
	{37157, 221256},
	{37180, 221260},
	{37198, 221264, 2, 1904},
	{37216, 221268, 4, 1906},
	{37236, 221440, 19, 5162},
	{37261, 221444, 19, 5162},
	{37286, 221448, 12, 5181},
	{37314, 221452, 12, 5181},
	{37342, 221456, 12, 5181},
	{37370, 221460, 12, 5181},
	{54359, 221696, 2, 5460},
	{54422, 221700, 2, 5460},
	{59929, 221704, 2, 5460},
	{59952, 221708, 2, 5460},
	{56771, 221712, 5, 1964},
	{56794, 221716, 2, 5460},
	{56817, 221720, 2, 5460},
	{56840, 221724, 2, 5460},
	{59975, 221728, 4, 1969},
	{57320, 221744, 5, 1964},
	{57344, 221748, 5, 1964},
	{57368, 221752, 2, 5460},
	{57392, 221756, 2, 5460},
	{59999, 221760, 4, 1969},
	{60024, 221764, 4, 1969},
	{57294, 221776, 1, 5501},
	{37828, 222208, 3, 1964},
	{37854, 222212, 2, 1884},
	{37881, 222216, 3, 1964},
	{37907, 222220, 2, 1884},
	{37934, 222224, 2, 2020},
	{37987, 222228, 2, 2020},
	{38040, 222464, 3, 1964},
	{38066, 222468, 2, 1884},
	{38093, 222472, 1, 1879},
	{38119, 222476, 1, 1879},
	{38145, 222480, 1, 1879},
	{38171, 222484, 1, 1879},
	{38197, 222488, 1, 1879},
	{38223, 222492, 1, 1879},
	{38249, 222496, 1, 1879},
	{38275, 222720, 3, 1964},
	{38299, 222724, 3, 1964},
	{38323, 222728, 3, 1964},
	{38347, 222732, 3, 1964},
	{38371, 222736, 2, 1884},
	{38396, 222740, 2, 1884},
	{38421, 222744, 2, 1884},
	{38446, 222748, 2, 1884},
	{38471, 222752, 1, 2008},
	{38495, 222756, 1, 2008},
	{38519, 222760, 8, 1973},
	{38540, 222976, 6, 5659},
	{38563, 222980, 6, 5659},
	{38586, 222984, 6, 5659},
	{38609, 222988, 6, 5659},
	{38632, 222992, 6, 5659},
	{38655, 222996, 6, 5659},
	{38678, 223000, 6, 5659},
	{38701, 223004, 6, 5659},
	{38724, 223008, 6, 5659},
	{38747, 223012, 6, 5659},
	{38770, 223016, 6, 5659},
	{38794, 223020, 6, 5659},
	{38818, 223024, 6, 5659},
	{38842, 223028, 6, 5659},
	{38866, 223032, 6, 5659},
	{38890, 223036, 6, 5659},
	{38914, 223104, 9, 5642},
	{60049, 223108, 2, 5690},
	{38934, 223112, 1, 1994},
	{39029, 223488, 3, 2003},
	{39052, 223492, 3, 2003},
	{39075, 223496, 3, 2003},
	{39098, 223500, 3, 2003},
	{39121, 223504, 2, 2006},
	{39145, 223508, 2, 2006},
	{39169, 223744, 3, 2003},
	{39193, 223748, 3, 2003},
	{39217, 223752, 3, 2003},
	{39241, 223756, 3, 2003},
	{39265, 223760, 2, 2006},
	{39290, 224000, 5, 2008},
	{39313, 224004, 4, 2013},
	{39337, 224008, 5, 2008},
	{39360, 224256, 5, 2008},
	{39383, 224260, 4, 2013},
	{39407, 224264, 5, 2008},
	{39430, 224512, 5, 1964},
	{39454, 224516, 4, 1969},
	{39479, 224520, 5, 1964},
	{39503, 224524, 4, 1969},
	{39528, 224528, 3, 2020},
	{39552, 224532, 3, 2020},
	{60069, 224768, 5, 1964},
	{60093, 224772, 4, 1958},
	{60118, 224776, 5, 1964},
	{60142, 224780, 4, 1958},
	{60167, 224784, 3, 2020},
	{60191, 224788, 3, 2020},
	{60215, 224832, 5, 1964},
	{60239, 224836, 4, 1958},
	{60264, 224840, 5, 1964},
	{60288, 224844, 4, 1958},
	{60313, 224848, 3, 2020},
	{60337, 224852, 3, 2020},
	{40253, 225280, 12, 2023},
	{40275, 225284, 5, 2035},
	{40298, 225288, 4, 2040},
	{40322, 225292, 2, 2044},
	{40345, 225296, 2, 2044},
	{40368, 225300, 2, 2044},
	{40391, 225536, 5, 1964},
	{40414, 225540, 4, 1969},
	{40438, 225544, 5, 1964},
	{40461, 225548, 4, 1969},
	{40485, 225552, 5, 1964},
	{40508, 225560, 5, 1964},
	{40531, 225792, 4, 2046},
	{40552, 225796},
	{40581, 225800, 2, 2050},
	{40610, 225804},
	{40636, 225808, 7, 2052},
	{40710, 225812},
	{40733, 225816},
	{60482, 225820, 2, 6292},
	{60515, 225824, 2, 6292},
	{60548, 225828, 2, 6292},
	{60581, 225832, 2, 6292},
	{60613, 225836, 2, 6292},
	{60645, 225840, 2, 6292},
	{60677, 225844, 2, 6292},
	{60710, 225848, 2, 6292},
	{60742, 225856, 2, 6292},
	{60774, 225860, 2, 6292},
	{60807, 225864, 2, 6292},
	{60840, 225868, 2, 6292},
	{60873, 225872, 2, 6292},
	{60905, 225876, 2, 6292},
	{60937, 225880, 2, 6292},
	{60970, 225884, 2, 6292},
	{61003, 225888, 2, 6292},
	{61069, 225896, 2, 6292},
	{40756, 225900},
	{40783, 225904},
	{40665, 225908},
	{40684, 225912},
	{41653, 226044, 1, 2136},
	{41446, 226048, 2, 2126},
	{41463, 226052, 1, 2128},
	{41487, 226056, 1, 2128},
	{206, 880, 4, 2163},
	{43232, 881},
	{27079, 882},
	{43244, 1008},
	{43255, 1009},
	{27267, 1010, 4, 2167},
	{43266, 1040, 1, 2171},
	{43279, 1041, 5, 6294},
	{43292, 1042, 1, 2177},
	{43305, 1043, 1, 1688},
	{27101, 1045, 9, 6086},
	{43333, 1281, 6, 6299},
	{43348, 1282},
	{27038, 1283},
	{43232, 1285},
	{27079, 1286},
};

static const struct si_reg gfx9_reg_table[] = {
	{1390, 68, 14, 6721},
	{1403, 72, 23, 6735},
	{1418, 76, 7, 6758},
	{55593, 80, 11, 6111},
	{1455, 84, 4, 4975},
	{1473, 88, 2, 3924},
	{1491, 92, 7, 6765},
	{1506, 96},
	{1520, 100, 1, 70},
	{1534, 104},
	{55607, 108},
	{55624, 112, 13, 6772},
	{1551, 116, 7, 6785},
	{1567, 120},
	{1689, 2480},
	{1703, 2484},
	{1717, 2488},
	{1731, 2492},
	{1745, 2496},
	{1759, 2500},
	{1773, 2504},
	{1787, 2508},
	{1801, 2512},
	{1815, 2516},
	{1829, 2520},
	{1844, 2524},
	{1859, 2528},
	{1874, 2532},
	{1889, 2536},
	{1904, 2540},
	{1919, 2544},
	{1930, 2552},
	{1946, 2556},
	{2034, 32776, 25, 6792},
	{2047, 32784, 24, 6817},
	{2059, 32788, 12, 6841},
	{2075, 32792, 12, 6841},
	{2104, 32824, 12, 6841},
	{2120, 32828, 12, 6841},
	{2136, 33296, 16, 6853},
	{2150, 33300, 28, 204},
	{2167, 33304, 14, 232},
	{2188, 33308, 21, 6869},
	{2202, 33312, 31, 6194},
	{2219, 33316, 11, 307},
	{2258, 33324, 1, 329},
	{2281, 33344, 1, 330},
	{2302, 33348},
	{2322, 33352, 1, 332},
	{2363, 33436, 1, 342},
	{2767, 36608},
	{2785, 36612, 4, 383},
	{2803, 36616},
	{2821, 36620, 12, 6890},
	{3722, 36624},
	{3740, 36628, 8, 6902},
	{3758, 36632, 3, 5759},
	{3776, 36636, 8, 6910},
	{3794, 36640, 3, 6918},
	{3812, 36644, 7, 6921},
	{3830, 36648, 8, 6462},
	{3848, 36652},
	{2839, 36656, 14, 6470},
	{2857, 36660, 4, 411},
	{2875, 36664, 10, 6928},
	{2893, 36668, 3, 6938},
	{2927, 39160, 13, 6941},
	{2942, 39184, 5, 5817},
	{2956, 39188, 5, 5817},
	{2970, 39192, 5, 5817},
	{2984, 39196, 5, 5817},
	{2998, 39200, 5, 5817},
	{3012, 39204, 5, 5817},
	{3026, 39208, 5, 5817},
	{3040, 39212, 5, 5817},
	{3054, 39216, 5, 5817},
	{3068, 39220, 5, 5817},
	{3082, 39224, 5, 5817},
	{3097, 39228, 5, 5817},
	{3112, 39232, 5, 5817},
	{3127, 39236, 5, 5817},
	{3142, 39240, 5, 5817},
	{3157, 39244, 5, 5817},
	{3172, 39248, 5, 5817},
	{3187, 39252, 5, 5817},
	{3202, 39256, 5, 5817},
	{3217, 39260, 5, 5817},
	{3232, 39264, 5, 5817},
	{3247, 39268, 5, 5817},
	{3262, 39272, 5, 5817},
	{3277, 39276, 5, 5817},
	{3292, 39280, 5, 5817},
	{3307, 39284, 5, 5817},
	{3322, 39288, 5, 5817},
	{3337, 39292, 5, 5817},
	{3352, 39296, 5, 5817},
	{3367, 39300, 5, 5817},
	{3382, 39304, 5, 5817},
	{3397, 39308, 5, 5817},
	{3412, 39312, 4, 445},
	{3431, 39316, 4, 445},
	{3450, 39320, 4, 445},
	{3469, 39324, 4, 445},
	{3488, 39328, 4, 445},
	{3507, 39332, 4, 445},
	{3526, 39336, 4, 445},
	{3545, 39340, 4, 445},
	{3564, 39344, 4, 445},
	{3583, 39348, 4, 445},
	{3602, 39352, 4, 445},
	{3622, 39356, 4, 445},
	{3642, 39360, 4, 445},
	{3662, 39364, 4, 445},
	{3682, 39368, 4, 445},
	{3702, 39372, 4, 445},
	{3947, 45084, 4, 6954},
	{3971, 45088},
	{3992, 45092, 1, 498},
	{4013, 45096, 11, 6958},
	{4037, 45100, 10, 6969},
	{4061, 45104},
	{4087, 45108},
	{4113, 45112},
	{4139, 45116},
	{4165, 45120},
	{4191, 45124},
	{4217, 45128},
	{4243, 45132},
	{4269, 45136},
	{4295, 45140},
	{4321, 45144},
	{4348, 45148},
	{4375, 45152},
	{4402, 45156},
	{4429, 45160},
	{4456, 45164},
	{4483, 45168},
	{4510, 45172},
	{4537, 45176},
	{4564, 45180},
	{4591, 45184},
	{4618, 45188},
	{4645, 45192},
	{4672, 45196},
	{4699, 45200},
	{4726, 45204},
	{4753, 45208},
	{4780, 45212},
	{4807, 45216},
	{4834, 45220},
	{4861, 45224},
	{4888, 45228},
	{5128, 45336, 4, 6954},
	{5152, 45340, 1, 534},
	{5177, 45344},
	{5198, 45348, 1, 498},
	{5219, 45352, 12, 6979},
	{5243, 45356, 14, 6991},
	{5267, 45360},
	{5293, 45364},
	{5319, 45368},
	{5345, 45372},
	{5371, 45376},
	{5397, 45380},
	{5423, 45384},
	{5449, 45388},
	{5475, 45392},
	{5501, 45396},
	{5527, 45400},
	{5554, 45404},
	{5581, 45408},
	{5608, 45412},
	{5635, 45416},
	{5662, 45420},
	{5689, 45424},
	{5716, 45428},
	{5743, 45432},
	{5770, 45436},
	{5797, 45440},
	{5824, 45444},
	{5851, 45448},
	{5878, 45452},
	{5905, 45456},
	{5932, 45460},
	{5959, 45464},
	{5986, 45468},
	{6013, 45472},
	{6040, 45476},
	{6067, 45480},
	{6094, 45484},
	{6285, 45552, 9, 561},
	{6391, 45572, 2, 7005},
	{6415, 45576},
	{6447, 45580},
	{7722, 45584},
	{7743, 45588, 1, 498},
	{6527, 45596, 4, 6954},
	{6551, 45600},
	{6572, 45604, 1, 498},
	{6593, 45608, 12, 7007},
	{6617, 45612, 9, 7019},
	{7812, 45872},
	{7838, 45876},
	{7864, 45880},
	{7890, 45884},
	{7916, 45888},
	{7942, 45892},
	{7968, 45896},
	{7994, 45900},
	{8020, 45904},
	{8046, 45908},
	{8072, 45912},
	{8099, 45916},
	{8126, 45920},
	{8153, 45924},
	{8180, 45928},
	{8207, 45932},
	{61282, 45936},
	{61309, 45940},
	{61336, 45944},
	{61363, 45948},
	{61390, 45952},
	{61417, 45956},
	{61444, 45960},
	{61471, 45964},
	{61498, 45968},
	{61525, 45972},
	{61552, 45976},
	{61579, 45980},
	{61606, 45984},
	{61633, 45988},
	{61660, 45992},
	{61687, 45996},
	{8286, 46084, 1, 7005},
	{8310, 46088},
	{8342, 46092},
	{9617, 46096},
	{9638, 46100, 1, 498},
	{8422, 46108, 4, 7028},
	{8446, 46112},
	{8467, 46116, 1, 498},
	{8488, 46120, 11, 7032},
	{8512, 46124, 7, 7043},
	{9707, 46128},
	{9733, 46132},
	{9759, 46136},
	{9785, 46140},
	{9811, 46144},
	{9837, 46148},
	{9863, 46152},
	{9889, 46156},
	{9915, 46160},
	{9941, 46164},
	{9967, 46168},
	{9994, 46172},
	{10021, 46176},
	{10048, 46180},
	{10075, 46184},
	{10102, 46188},
	{61714, 46192},
	{61741, 46196},
	{61768, 46200},
	{61795, 46204},
	{61822, 46208},
	{61849, 46212},
	{61876, 46216},
	{61903, 46220},
	{61930, 46224},
	{61957, 46228},
	{61984, 46232},
	{62011, 46236},
	{62038, 46240},
	{62065, 46244},
	{62092, 46248},
	{62119, 46252},
	{62146, 46384},
	{62176, 46388},
	{62206, 46392},
	{62236, 46396},
	{62266, 46400},
	{62296, 46404},
	{62326, 46408},
	{62356, 46412},
	{62386, 46416},
	{62416, 46420},
	{62446, 46424},
	{62477, 46428},
	{62508, 46432},
	{62539, 46436},
	{62570, 46440},
	{62601, 46444},
	{62632, 46448},
	{62663, 46452},
	{62694, 46456},
	{62725, 46460},
	{62756, 46464},
	{62787, 46468},
	{62818, 46472},
	{62849, 46476},
	{62880, 46480},
	{62911, 46484},
	{62942, 46488},
	{62973, 46492},
	{63004, 46496},
	{63035, 46500},
	{63066, 46504},
	{63097, 46508},
	{10129, 47104, 11, 7050},
	{10156, 47108},
	{10170, 47112},
	{10184, 47116},
	{10198, 47120},
	{10214, 47124},
	{10230, 47128},
	{10246, 47132, 2, 666},
	{10267, 47136, 2, 666},
	{10288, 47140, 2, 666},
	{10309, 47144, 1, 668},
	{10337, 47148, 1, 669},
	{10362, 47152},
	{10377, 47156, 1, 670},
	{10392, 47160},
	{10421, 47164, 1, 670},
	{10450, 47168},
	{10483, 47172, 1, 670},
	{10516, 47176, 11, 7061},
	{10534, 47180, 12, 7072},
	{10552, 47184, 1, 694},
	{10565, 47188, 7, 7084},
	{59097, 47192, 2, 5946},
	{59128, 47196, 2, 5946},
	{10643, 47200, 2, 701},
	{59311, 47204, 2, 5946},
	{59342, 47208, 2, 5946},
	{10718, 47212},
	{10736, 47216},
	{10754, 47220},
	{10772, 47224, 1, 703},
	{10800, 47228, 5, 704},
	{10822, 47232},
	{10842, 47236},
	{11025, 47240, 3, 720},
	{11042, 47244},
	{11071, 47248, 1, 723},
	{11003, 47252},
	{47463, 47252},
	{47494, 47256},
	{47525, 47260},
	{47556, 47264},
	{11118, 47360},
	{11138, 47364},
	{11158, 47368},
	{11178, 47372},
	{11198, 47376},
	{11218, 47380},
	{11238, 47384},
	{11258, 47388},
	{11278, 47392},
	{11298, 47396},
	{11318, 47400},
	{11339, 47404},
	{11360, 47408},
	{11381, 47412},
	{11402, 47416},
	{11423, 47420},
	{11468, 47608},
	{11489, 47612},
	{11505, 163840, 10, 726},
	{11523, 163844, 9, 5977},
	{11540, 163848, 5, 7091},
	{11554, 163852, 23, 754},
	{11573, 163856, 16, 777},
	{11593, 163860},
	{12005, 163864, 1, 837},
	{59207, 163868, 2, 793},
	{11629, 163872},
	{11649, 163876},
	{11669, 163880, 1, 795},
	{11686, 163884},
	{11701, 163888, 2, 796},
	{11725, 163892, 2, 798},
	{11783, 163896, 13, 7096},
	{11793, 163900, 8, 7109},
	{11809, 163904},
	{11919, 163908, 1, 837},
	{11824, 163912},
	{11937, 163916, 1, 837},
	{11845, 163920},
	{11961, 163924, 1, 837},
	{11861, 163928},
	{11980, 163932, 1, 837},
	{11749, 163936, 3, 800},
	{63128, 163944, 1, 7117},
	{63139, 163948, 1, 7117},
	{12051, 163968},
	{12067, 163972, 1, 847},
	{12086, 164328, 1, 848},
	{12107, 164332, 1, 848},
	{12128, 164336, 1, 848},
	{12149, 164340, 1, 848},
	{12170, 164344},
	{12188, 164348},
	{12206, 164352, 2, 849},
	{12226, 164356, 3, 851},
	{12250, 164360, 2, 854},
	{12274, 164364, 1, 856},
	{12294, 164368, 2, 851},
	{12314, 164372, 2, 854},
	{12334, 164376, 2, 851},
	{12354, 164380, 2, 854},
	{12374, 164384, 2, 851},
	{12394, 164388, 2, 854},
	{12414, 164392, 2, 851},
	{12434, 164396, 2, 854},
	{12454, 164400, 7, 857},
	{12469, 164404, 2, 864},
	{12498, 164408, 8, 866},
	{12513, 164412, 8, 874},
	{12528, 164416, 3, 851},
	{12553, 164420, 2, 854},
	{12578, 164424},
	{12596, 164428},
	{12614, 164432, 3, 851},
	{12639, 164436, 2, 854},
	{12664, 164440, 3, 851},
	{12689, 164444, 2, 854},
	{12714, 164448, 3, 851},
	{12739, 164452, 2, 854},
	{12764, 164456, 3, 851},
	{12789, 164460, 2, 854},
	{12814, 164464, 3, 851},
	{12839, 164468, 2, 854},
	{12864, 164472, 3, 851},
	{12889, 164476, 2, 854},
	{12914, 164480, 3, 851},
	{12939, 164484, 2, 854},
	{12964, 164488, 3, 851},
	{12989, 164492, 2, 854},
	{13014, 164496, 3, 851},
	{13039, 164500, 2, 854},
	{13064, 164504, 3, 851},
	{13089, 164508, 2, 854},
	{13114, 164512, 3, 851},
	{13140, 164516, 2, 854},
	{13166, 164520, 3, 851},
	{13192, 164524, 2, 854},
	{13218, 164528, 3, 851},
	{13244, 164532, 2, 854},
	{13270, 164536, 3, 851},
	{13296, 164540, 2, 854},
	{13322, 164544, 3, 851},
	{13348, 164548, 2, 854},
	{13374, 164552, 3, 851},
	{13400, 164556, 2, 854},
	{13426, 164560},
	{13445, 164564},
	{13464, 164568},
	{13483, 164572},
	{13502, 164576},
	{13521, 164580},
	{13540, 164584},
	{13559, 164588},
	{13578, 164592},
	{13597, 164596},
	{13616, 164600},
	{13635, 164604},
	{13654, 164608},
	{13673, 164612},
	{13692, 164616},
	{13711, 164620},
	{13730, 164624},
	{13749, 164628},
	{13768, 164632},
	{13787, 164636},
	{13806, 164640},
	{13826, 164644},
	{13846, 164648},
	{13866, 164652},
	{13886, 164656},
	{13906, 164660},
	{13926, 164664},
	{13946, 164668},
	{13966, 164672},
	{13986, 164676},
	{14006, 164680},
	{14026, 164684},
	{14046, 164688, 15, 7118},
	{14066, 164692, 3, 7133},
	{14088, 164696, 2, 900},
	{14116, 164700, 3, 902},
	{14145, 164704, 1, 909},
	{14166, 164708, 1, 910},
	{14176, 164712, 1, 911},
	{14184, 164768, 4, 912},
	{14206, 164772, 4, 912},
	{14227, 164776, 4, 916},
	{14294, 164876},
	{14348, 164884},
	{14361, 164888},
	{14376, 164892},
	{14390, 164896},
	{14405, 164900, 9, 7136},
	{14444, 164908, 6, 942},
	{14463, 164912, 4, 948},
	{14481, 164916, 4, 952},
	{14502, 164924},
	{14521, 164928},
	{14541, 164932},
	{14560, 164936},
	{14580, 164940},
	{14599, 164944},
	{14619, 164948},
	{14640, 164952},
	{14662, 164956},
	{14683, 164960},
	{14705, 164964},
	{14726, 164968},
	{14748, 164972},
	{14769, 164976},
	{14791, 164980},
	{14812, 164984},
	{14834, 164988},
	{14855, 164992},
	{14877, 164996},
	{14898, 165000},
	{14920, 165004},
	{14941, 165008},
	{14963, 165012},
	{14984, 165016},
	{15006, 165020},
	{15027, 165024},
	{15049, 165028},
	{15070, 165032},
	{15092, 165036},
	{15113, 165040},
	{15135, 165044},
	{15156, 165048},
	{15178, 165052},
	{15199, 165056},
	{15221, 165060},
	{15242, 165064},
	{15264, 165068},
	{15285, 165072},
	{15307, 165076},
	{15328, 165080},
	{15350, 165084},
	{15371, 165088},
	{15393, 165092},
	{15414, 165096},
	{15436, 165100},
	{15457, 165104},
	{15479, 165108},
	{15500, 165112},
	{15522, 165116},
	{15543, 165120},
	{15565, 165124},
	{15586, 165128},
	{15608, 165132},
	{15629, 165136},
	{15651, 165140},
	{15672, 165144},
	{15694, 165148},
	{15715, 165152},
	{15737, 165156},
	{15758, 165160},
	{15780, 165164},
	{15802, 165168},
	{15825, 165172},
	{15847, 165176},
	{15870, 165180},
	{15892, 165184},
	{15915, 165188},
	{15937, 165192},
	{15960, 165196},
	{15982, 165200},
	{16005, 165204},
	{16027, 165208},
	{16050, 165212},
	{16072, 165216},
	{16095, 165220},
	{16117, 165224},
	{16140, 165228},
	{16162, 165232},
	{16185, 165236},
	{16207, 165240},
	{16230, 165244},
	{16252, 165248},
	{16275, 165252},
	{16297, 165256},
	{16320, 165260},
	{16342, 165264},
	{16365, 165268},
	{16387, 165272},
	{16410, 165276},
	{16432, 165280},
	{16455, 165284},
	{16477, 165288},
	{16500, 165292},
	{16522, 165296},
	{16545, 165300},
	{16567, 165304},
	{16590, 165308},
	{16604, 165312},
	{16618, 165316},
	{16632, 165320},
	{16646, 165324},
	{16660, 165328},
	{16674, 165332},
	{16688, 165336},
	{16702, 165340},
	{16716, 165344},
	{16730, 165348},
	{16744, 165352},
	{16758, 165356},
	{16772, 165360},
	{16786, 165364},
	{16800, 165368},
	{16814, 165372},
	{16828, 165376},
	{16842, 165380},
	{16856, 165384},
	{16870, 165388},
	{16884, 165392},
	{16898, 165396},
	{16912, 165400},
	{16926, 165404},
	{16949, 165444, 12, 956},
	{16969, 165448, 12, 956},
	{16989, 165452, 12, 956},
	{17009, 165456, 12, 956},
	{17029, 165460, 12, 956},
	{17049, 165464, 12, 956},
	{17069, 165468, 12, 956},
	{17089, 165472, 12, 956},
	{17109, 165476, 12, 956},
	{17129, 165480, 12, 956},
	{17149, 165484, 12, 956},
	{17170, 165488, 12, 956},
	{17191, 165492, 12, 956},
	{17212, 165496, 12, 956},
	{17233, 165500, 12, 956},
	{17254, 165504, 12, 956},
	{17275, 165508, 12, 956},
	{17296, 165512, 12, 956},
	{17317, 165516, 12, 956},
	{17338, 165520, 12, 956},
	{17359, 165524, 9, 968},
	{17380, 165528, 9, 968},
	{17401, 165532, 9, 968},
	{17422, 165536, 9, 968},
	{17443, 165540, 9, 968},
	{17464, 165544, 9, 968},
	{17485, 165548, 9, 968},
	{17506, 165552, 9, 968},
	{17527, 165556, 9, 968},
	{17548, 165560, 9, 968},
	{17569, 165564, 9, 968},
	{17590, 165568, 9, 968},
	{17611, 165572, 2, 977},
	{17629, 165580, 16, 980},
	{17646, 165584, 16, 980},
	{17664, 165588, 7, 996},
	{17685, 165592, 5, 1003},
	{17703, 165600, 7, 1009},
	{17718, 165608, 2, 701},
	{17757, 165644, 4, 1017},
	{17779, 165648, 1, 1022},
	{17799, 165652, 8, 1023},
	{17821, 165716, 8, 1031},
	{17839, 165720, 8, 1039},
	{17860, 165724, 17, 1047},
	{17881, 165728, 6, 1064},
	{17899, 165732, 6, 1064},
	{17917, 165736, 6, 1064},
	{17935, 165740, 6, 1064},
	{17953, 165744, 6, 1064},
	{17971, 165748, 6, 1064},
	{17989, 165752, 6, 1064},
	{18007, 165756, 6, 1064},
	{18025, 165760, 9, 1070},
	{18043, 165764, 9, 1070},
	{18061, 165768, 9, 1070},
	{18079, 165772, 9, 1070},
	{18097, 165776, 9, 1070},
	{18115, 165780, 9, 1070},
	{18133, 165784, 9, 1070},
	{18151, 165788, 9, 1070},
	{63156, 165792, 1, 7117},
	{63171, 165796, 1, 7117},
	{63186, 165800, 1, 7117},
	{63201, 165804, 1, 7117},
	{63216, 165808, 1, 7117},
	{63231, 165812, 1, 7117},
	{63246, 165816, 1, 7117},
	{63261, 165820, 1, 7117},
	{18169, 165836, 1, 1079},
	{18183, 165840, 1, 1079},
	{18198, 165844},
	{18216, 165848},
	{18234, 165852},
	{18251, 165856},
	{18272, 165860, 1, 1080},
	{18288, 165864},
	{18301, 165872, 8, 1081},
	{18320, 165876},
	{18335, 165880, 1, 1089},
	{18384, 165888, 10, 1091},
	{18401, 165892, 12, 1101},
	{18409, 165896, 4, 6686},
	{18426, 165900, 16, 1117},
	{18444, 165904, 20, 1134},
	{18460, 165908, 15, 1154},
	{18479, 165912, 10, 1170},
	{18494, 165916, 28, 7145},
	{18512, 165920, 16, 1208},
	{18530, 165924, 4, 1224},
	{18554, 165928},
	{18579, 165932, 11, 1228},
	{18602, 165936, 6, 3829},
	{18631, 165940, 3, 7173},
	{18653, 165944, 2, 1248},
	{18668, 165948, 5, 1250},
	{18698, 165952, 6, 7176},
	{18731, 166400, 2, 1260},
	{18748, 166404, 2, 1262},
	{18767, 166408, 1, 1264},
	{18783, 166412, 4, 1265},
	{18802, 166416, 1, 1269},
	{18823, 166420, 1, 1270},
	{18836, 166424},
	{18859, 166428},
	{18882, 166432, 1, 1271},
	{18902, 166436, 4, 1272},
	{18922, 166440, 1, 1276},
	{18943, 166444, 1, 1277},
	{18958, 166448, 6, 1278},
	{18980, 166452, 6, 1278},
	{19002, 166456, 8, 1284},
	{19028, 166460, 8, 1284},
	{19054, 166464, 15, 6556},
	{19066, 166468, 3, 1307},
	{19085, 166472, 7, 1310},
	{19103, 166476, 24, 1317},
	{19121, 166480},
	{19133, 166484, 1, 1341},
	{19147, 166488, 1, 1342},
	{19161, 166492, 1, 1343},
	{19175, 166496, 1, 1344},
	{19198, 166500, 1, 1344},
	{19221, 166504, 1, 1344},
	{19244, 166508, 5, 1345},
	{19265, 166512},
	{19276, 166516},
	{19289, 166520},
	{19306, 166524, 7, 7182},
	{19325, 166528},
	{19336, 166532, 3, 1358},
	{19355, 166536},
	{19377, 166540},
	{19399, 166544, 3, 7189},
	{63276, 166548, 1, 7192},
	{19446, 166552, 4, 7193},
	{19468, 166560},
	{19493, 166564},
	{19537, 166572, 1, 1377},
	{19560, 166576, 1, 1377},
	{19583, 166580, 1, 1378},
	{19597, 166584, 1, 1379},
	{19612, 166588, 8, 7197},
	{19629, 166592, 4, 1389},
	{19656, 166596, 4, 1393},
	{19683, 166600, 4, 1397},
	{19702, 166608},
	{19728, 166612, 1, 1401},
	{19753, 166620},
	{19781, 166624},
	{19807, 166628, 1, 1401},
	{19832, 166636},
	{19860, 166640},
	{19886, 166644, 1, 1401},
	{19911, 166652},
	{19939, 166656},
	{19965, 166660, 1, 1401},
	{19990, 166668},
	{20018, 166696},
	{20049, 166700},
	{20092, 166704, 1, 1402},
	{20130, 166712, 1, 1403},
	{20169, 166736, 5, 1406},
	{20191, 166740, 13, 7205},
	{20212, 166744, 3, 1430},
	{20229, 166748, 1, 1377},
	{20250, 166752, 1, 1377},
	{20273, 166756, 1, 1377},
	{20296, 166760, 1, 1377},
	{20319, 166764, 8, 7218},
	{20332, 166768, 6, 1445},
	{20349, 166772},
	{20373, 166776, 2, 1451},
	{20403, 166780},
	{20427, 166784},
	{20457, 166788},
	{20488, 166792},
	{20517, 166796},
	{20547, 166800, 2, 1453},
	{20567, 166804, 8, 1456},
	{20586, 166808, 4, 1464},
	{20612, 166812, 3, 7189},
	{20636, 166868, 8, 1468},
	{20662, 166872, 8, 1476},
	{20688, 166876, 5, 1484},
	{20704, 166880, 6, 1489},
	{20720, 166884, 3, 1495},
	{20735, 166888},
	{20758, 166892},
	{20781, 166896},
	{20804, 166900},
	{20827, 166904, 8, 1498},
	{20861, 166908, 8, 1506},
	{20895, 166912, 8, 1514},
	{20929, 166916, 8, 1522},
	{20963, 166920, 8, 1498},
	{20997, 166924, 8, 1506},
	{21031, 166928, 8, 1514},
	{21065, 166932, 8, 1522},
	{21099, 166936, 8, 1498},
	{21133, 166940, 8, 1506},
	{21167, 166944, 8, 1514},
	{21201, 166948, 8, 1522},
	{21235, 166952, 8, 1498},
	{21269, 166956, 8, 1506},
	{21303, 166960, 8, 1514},
	{21337, 166964, 8, 1522},
	{21371, 166968, 2, 1530},
	{21395, 166972, 2, 1532},
	{21419, 166976, 3, 1534},
	{21440, 166980, 11, 1538},
	{21460, 166984, 2, 1550},
	{21480, 166988, 18, 1552},
	{21518, 166992, 1, 1572},
	{21538, 167000, 1, 1574},
	{21566, 167004, 1, 1575},
	{21587, 167008},
	{23627, 167012, 1, 1622},
	{24363, 167016, 3, 1623},
	{21634, 167020, 3, 7226},
	{21649, 167024, 16, 7229},
	{21664, 167028, 10, 7245},
	{21681, 167032, 11, 1609},
	{21703, 167036},
	{23779, 167040, 1, 1622},
	{21741, 167044},
	{23979, 167048, 1, 1622},
	{21779, 167052},
	{21801, 167056},
	{21823, 167060},
	{24179, 167064, 1, 1622},
	{21842, 167068},
	{23646, 167072, 1, 1622},
	{24381, 167076, 3, 1623},
	{21889, 167080, 3, 7226},
	{21904, 167084, 16, 7229},
	{21919, 167088, 10, 7245},
	{21936, 167092, 11, 1609},
	{21958, 167096},
	{23804, 167100, 1, 1622},
	{21996, 167104},
	{24004, 167108, 1, 1622},
	{22034, 167112},
	{22056, 167116},
	{22078, 167120},
	{24202, 167124, 1, 1622},
	{22097, 167128},
	{23665, 167132, 1, 1622},
	{24399, 167136, 3, 1623},
	{22144, 167140, 3, 7226},
	{22159, 167144, 16, 7229},
	{22174, 167148, 10, 7245},
	{22191, 167152, 11, 1609},
	{22213, 167156},
	{23829, 167160, 1, 1622},
	{22251, 167164},
	{24029, 167168, 1, 1622},
	{22289, 167172},
	{22311, 167176},
	{22333, 167180},
	{24225, 167184, 1, 1622},
	{22352, 167188},
	{23684, 167192, 1, 1622},
	{24417, 167196, 3, 1623},
	{22399, 167200, 3, 7226},
	{22414, 167204, 16, 7229},
	{22429, 167208, 10, 7245},
	{22446, 167212, 11, 1609},
	{22468, 167216},
	{23854, 167220, 1, 1622},
	{22506, 167224},
	{24054, 167228, 1, 1622},
	{22544, 167232},
	{22566, 167236},
	{22588, 167240},
	{24248, 167244, 1, 1622},
	{22607, 167248},
	{23703, 167252, 1, 1622},
	{24435, 167256, 3, 1623},
	{22654, 167260, 3, 7226},
	{22669, 167264, 16, 7229},
	{22684, 167268, 10, 7245},
	{22701, 167272, 11, 1609},
	{22723, 167276},
	{23879, 167280, 1, 1622},
	{22761, 167284},
	{24079, 167288, 1, 1622},
	{22799, 167292},
	{22821, 167296},
	{22843, 167300},
	{24271, 167304, 1, 1622},
	{22862, 167308},
	{23722, 167312, 1, 1622},
	{24453, 167316, 3, 1623},
	{22909, 167320, 3, 7226},
	{22924, 167324, 16, 7229},
	{22939, 167328, 10, 7245},
	{22956, 167332, 11, 1609},
	{22978, 167336},
	{23904, 167340, 1, 1622},
	{23016, 167344},
	{24104, 167348, 1, 1622},
	{23054, 167352},
	{23076, 167356},
	{23098, 167360},
	{24294, 167364, 1, 1622},
	{23117, 167368},
	{23741, 167372, 1, 1622},
	{24471, 167376, 3, 1623},
	{23164, 167380, 3, 7226},
	{23179, 167384, 16, 7229},
	{23194, 167388, 10, 7245},
	{23211, 167392, 11, 1609},
	{23233, 167396},
	{23929, 167400, 1, 1622},
	{23271, 167404},
	{24129, 167408, 1, 1622},
	{23309, 167412},
	{23331, 167416},
	{23353, 167420},
	{24317, 167424, 1, 1622},
	{23372, 167428},
	{23760, 167432, 1, 1622},
	{24489, 167436, 3, 1623},
	{23419, 167440, 3, 7226},
	{23434, 167444, 16, 7229},
	{23449, 167448, 10, 7245},
	{23466, 167452, 11, 1609},
	{23488, 167456},
	{23954, 167460, 1, 1622},
	{23526, 167464},
	{24154, 167468, 1, 1622},
	{23564, 167472},
	{23586, 167476},
	{23608, 167480},
	{24340, 167484, 1, 1622},
	{24651, 196608, 1, 1634},
	{24671, 196612, 1, 1635},
	{24691, 196616},
	{24711, 196620},
	{24731, 196624},
	{24752, 196628},
	{24773, 196632, 1, 1636},
	{24795, 196636, 1, 1637},
	{24817, 196640},
	{24847, 196644},
	{24877, 196648},
	{24906, 196652},
	{24935, 196656},
	{24965, 196660},
	{24995, 196664},
	{25024, 196668},
	{25053, 196672},
	{25083, 196676},
	{25113, 196680},
	{25142, 196684},
	{25171, 196688},
	{25201, 196692},
	{25231, 196696},
	{25260, 196700},
	{25289, 196704, 1, 1638},
	{25311, 196708, 1, 1639},
	{25333, 196712},
	{25356, 196716},
	{25379, 196720},
	{25402, 196724},
	{25425, 196728},
	{25448, 196732},
	{25471, 196736},
	{25495, 196740},
	{25519, 196744},
	{25543, 196748},
	{25567, 196752},
	{25591, 196756},
	{25615, 196760},
	{25639, 196764},
	{25663, 196768},
	{25685, 196772},
	{25707, 196776},
	{25728, 196780},
	{25749, 196784},
	{25773, 196788},
	{25797, 196792},
	{25821, 196796},
	{25845, 196800},
	{25869, 196804},
	{25953, 196852, 1, 6628},
	{25975, 196856, 1, 6628},
	{25997, 196860, 1, 1642},
	{26013, 196864},
	{26026, 196868},
	{26039, 196872},
	{26052, 196876},
	{26065, 196880},
	{26078, 196884},
	{26091, 196888},
	{26104, 196892},
	{26159, 196912},
	{26177, 196916},
	{26204, 196920},
	{26231, 196928, 2, 1643},
	{26244, 196932},
	{26257, 196936},
	{26280, 196940},
	{26303, 196944},
	{26331, 196948},
	{26359, 196952},
	{26387, 196956},
	{26415, 196960, 1, 1645},
	{26433, 196964, 4, 7255},
	{63306, 196968},
	{63324, 196972},
	{63351, 196976},
	{26514, 196980},
	{26533, 196984},
	{26552, 196988},
	{26576, 196992},
	{26600, 196996},
	{26624, 197000},
	{26648, 197028, 1, 1650},
	{26666, 197032, 2, 7259},
	{26684, 197036},
	{26702, 197040},
	{26720, 197044, 1, 1653},
	{26738, 197048, 2, 7261},
	{26756, 197052},
	{26774, 197056, 2, 1656},
	{26793, 197060, 5, 1658},
	{26812, 197072},
	{26836, 197076, 2, 1656},
	{26856, 197080, 5, 1658},
	{26876, 197084, 5, 7263},
	{26895, 197088, 5, 7263},
	{26913, 197092, 1, 1670},
	{26930, 197100, 1, 1671},
	{26951, 197104, 13, 1672},
	{26965, 197108},
	{26979, 197112},
	{26993, 197116, 2, 1685},
	{27009, 197120},
	{27028, 197124, 1, 1687},
	{27050, 197128},
	{27069, 197132, 1, 1688},
	{27091, 197136, 7, 1689},
	{27109, 197140},
	{27129, 197144, 1, 1687},
	{27152, 197148},
	{27172, 197152, 1, 1688},
	{27195, 197156, 7, 1689},
	{27214, 197160, 6, 7268},
	{27226, 197164, 2, 1703},
	{27243, 197168, 1, 1705},
	{27260, 197172, 1, 1706},
	{27278, 197176, 4, 1707},
	{27298, 197180, 1, 1711},
	{27315, 197184},
	{27331, 197188, 1, 1713},
	{27344, 197192, 1, 1714},
	{27358, 197196, 1, 1715},
	{27372, 197200, 1, 1716},
	{27394, 197204, 1, 1717},
	{27414, 197208, 1, 1718},
	{27436, 197212, 1, 1719},
	{27456, 197216, 1, 1714},
	{27473, 197220, 1, 1715},
	{27490, 197224},
	{61266, 197228, 1, 1713},
	{27638, 197364, 1, 1724},
	{27659, 197368, 1, 1725},
	{27679, 197372, 1, 1726},
	{27699, 197376, 1, 1725},
	{27716, 197380, 1, 1726},
	{27733, 197384, 1, 1727},
	{27749, 197388, 1, 1728},
	{27768, 197392, 1, 1729},
	{27787, 197396, 1, 1730},
	{27804, 197400, 1, 1731},
	{27822, 197404, 1, 1732},
	{27840, 197408, 1, 1733},
	{27856, 197412, 1, 1734},
	{27874, 197416, 1, 1735},
	{27892, 197420, 1, 1736},
	{27908, 197424, 1, 1731},
	{27923, 197428, 1, 1732},
	{27938, 197432, 1, 1733},
	{27951, 197436, 1, 1734},
	{27966, 197440, 1, 1735},
	{27981, 197444, 1, 1736},
	{27994, 197448, 1, 1737},
	{28008, 197452, 1, 1738},
	{28022, 197456, 1, 1739},
	{28034, 197460, 4, 7274},
	{28057, 197464, 3, 1744},
	{28079, 197468, 1, 1747},
	{28223, 197552, 1, 1752},
	{28248, 197556, 1, 1752},
	{28272, 197560, 1, 1753},
	{28292, 197568},
	{28318, 197572, 1, 1635},
	{28347, 197576},
	{28372, 197580, 1, 1635},
	{28400, 197584},
	{28423, 197588, 1, 1635},
	{28449, 197592},
	{28471, 197596, 1, 1635},
	{28496, 197600},
	{28515, 197604, 1, 1635},
	{28537, 197608, 1, 1350},
	{28551, 197612},
	{28568, 197616, 1, 1635},
	{28588, 197620, 8, 1754},
	{28605, 197624, 13, 1762},
	{28622, 197628},
	{28639, 197632, 1, 1705},
	{28659, 197636},
	{28676, 197640, 1, 1670},
	{28696, 197644, 2, 1775},
	{28715, 197888, 8, 7278},
	{28736, 197892, 8, 7278},
	{28757, 198656, 6, 5119},
	{28791, 198916},
	{28810, 198920, 1, 1791},
	{28829, 198924, 2, 7286},
	{28844, 198928},
	{28877, 198932},
	{28910, 198936},
	{28943, 198940},
	{14244, 198944},
	{14261, 198948},
	{14278, 198952},
	{19419, 198956, 2, 1364},
	{29033, 198960},
	{29049, 198964},
	{29067, 198968, 1, 1792},
	{29084, 198972, 2, 1793},
	{29105, 198976},
	{29399, 198980, 1, 837},
	{29143, 198984},
	{29159, 198988, 1, 837},
	{29178, 198992},
	{29198, 198996, 1, 837},
	{29221, 199000},
	{29239, 199004, 1, 837},
	{19518, 199008, 9, 1795},
	{29301, 199016},
	{29437, 199168, 1, 1816},
	{29462, 199172, 2, 1817},
	{29487, 199184, 2, 1819},
	{29513, 199188, 2, 1819},
	{29539, 199192, 2, 1819},
	{29565, 199212, 2, 1819},
	{29591, 199296, 2, 1821},
	{29619, 199300, 1, 1823},
	{29643, 199304, 1, 1824},
	{29667, 199308, 1, 1825},
	{29700, 199312, 1, 1825},
	{29728, 199328, 2, 1821},
	{29757, 199332, 1, 1823},
	{29782, 199336, 1, 1824},
	{29807, 199340, 1, 1825},
	{29841, 199344, 1, 1825},
	{29870, 199360, 2, 1821},
	{29894, 199364, 1, 1823},
	{29914, 199368, 1, 1824},
	{29934, 199372, 1, 1825},
	{29963, 199376, 1, 1825},
	{18713, 199380},
	{58190, 199872},
	{58211, 199876, 1, 4849},
	{2511, 199880, 7, 6232},
	{2532, 199884, 3, 5687},
	{58232, 199888, 2, 5690},
	{2559, 199892, 1, 5714},
	{58258, 199896, 15, 7288},
	{59261, 199900, 1, 6241},
	{59283, 199904},
	{2490, 199908, 2, 5692},
	{2580, 199912, 6, 7303},
	{58300, 199916, 1, 5715},
	{58279, 199920},
	{29987, 199936},
	{30014, 199940},
	{30041, 199944},
	{30068, 199948},
	{30203, 199968, 6, 1826},
	{30214, 199972, 2, 1833},
	{30228, 200192},
	{30247, 200196, 1, 847},
	{30269, 200448},
	{30293, 200452, 1, 1835},
	{30316, 200456},
	{30340, 200460, 1, 1835},
	{30363, 200464},
	{30387, 200468, 1, 1835},
	{30410, 200472},
	{30434, 200476, 1, 1835},
	{30457, 200696},
	{30476, 200700, 1, 1835},
	{30494, 200704},
	{30506, 200708},
	{30518, 200712},
	{30536, 200716},
	{30555, 200720},
	{30573, 200724},
	{30585, 200728},
	{30597, 200732},
	{30615, 200736},
	{30633, 200740},
	{30652, 200744, 4, 1836},
	{30666, 200748, 2, 1840},
	{30684, 200752, 2, 1842},
	{30698, 200756, 2, 1844},
	{30712, 200760, 2, 1846},
	{30729, 200764, 2, 1848},
	{30746, 200768},
	{30759, 200772, 2, 1850},
	{30771, 200776},
	{30785, 200780},
	{30801, 200784},
	{30815, 200788},
	{30831, 200792},
	{30846, 200796},
	{30863, 200800},
	{30878, 200804},
	{30895, 200808, 2, 1852},
	{30917, 200812, 10, 7309},
	{30934, 200816, 2, 1864},
	{30955, 200820, 2, 1866},
	{30967, 200824},
	{30982, 200828, 6, 6675},
	{30997, 200832, 2, 1874},
	{31011, 200836},
	{2911, 200960, 9, 426},
	{48937, 200964, 11, 7319},
	{48955, 200968, 2, 3505},
	{48973, 200972, 4, 7330},
	{31124, 212992},
	{31144, 212996},
	{31164, 213000},
	{31184, 213004},
	{31204, 213008},
	{31224, 213012},
	{31244, 213016},
	{31264, 213020},
	{31284, 213024},
	{31304, 213028},
	{31324, 213032},
	{31344, 213036},
	{31364, 213040},
	{31387, 213044},
	{31410, 213048},
	{31433, 213248},
	{31454, 213252},
	{31475, 213260},
	{31496, 213264},
	{31517, 213268},
	{31541, 213272},
	{31565, 213276},
	{31589, 213280},
	{31613, 213284},
	{31637, 213288},
	{31661, 213292},
	{31685, 213296},
	{53472, 213504},
	{53499, 213508},
	{53526, 213512},
	{53553, 213516},
	{59373, 213520},
	{59392, 213524},
	{59411, 213528},
	{59430, 213532},
	{56863, 213536},
	{56882, 213540},
	{56901, 213544},
	{56920, 213548},
	{56939, 213552},
	{56958, 213556},
	{56977, 213560},
	{56996, 213564},
	{57416, 213568},
	{57436, 213572},
	{57456, 213576},
	{57476, 213580},
	{57496, 213584},
	{57516, 213588},
	{57536, 213592},
	{57556, 213596},
	{32169, 214016},
	{32191, 214020, 1, 1876},
	{32213, 214024},
	{32235, 214028, 1, 1876},
	{32257, 214032},
	{32279, 214036, 1, 1876},
	{32301, 214040},
	{32323, 214044, 1, 1876},
	{32345, 214272},
	{32367, 214276},
	{32389, 214280},
	{32411, 214284},
	{32433, 214288},
	{32455, 214292},
	{32477, 214296},
	{32499, 214300},
	{32521, 214304},
	{32543, 214308},
	{32565, 214312},
	{32587, 214316},
	{32609, 214320},
	{32631, 214324},
	{32653, 214328},
	{32675, 214332},
	{32697, 214528},
	{32717, 214532},
	{32737, 214536},
	{32757, 214540},
	{32777, 214544},
	{32797, 214548},
	{32817, 214552},
	{32837, 214556},
	{32857, 214560},
	{32877, 214564},
	{32897, 214568},
	{32917, 214572},
	{32937, 214784},
	{32956, 214788},
	{32975, 214792},
	{32994, 214796},
	{33013, 214800},
	{33032, 214804},
	{33051, 214808},
	{33070, 214812},
	{33089, 214816},
	{33108, 214820},
	{33127, 214824},
	{33146, 214828},
	{33165, 214832},
	{33184, 214836},
	{33203, 214840},
	{33222, 214844},
	{33241, 214848},
	{33260, 214852},
	{33279, 214856},
	{33298, 214860},
	{33317, 214864},
	{33337, 214868},
	{33357, 214872},
	{33377, 214876},
	{33397, 214880},
	{33417, 214884},
	{33437, 214888},
	{33457, 214892},
	{33477, 214896},
	{33497, 214900},
	{33517, 214904},
	{33537, 214908},
	{33557, 215296},
	{33576, 215300},
	{33595, 215304},
	{33614, 215308},
	{33633, 215312},
	{33652, 215316},
	{33671, 215320},
	{33690, 215324},
	{33751, 215552},
	{33771, 215556},
	{33791, 215560},
	{33811, 215564},
	{33831, 215568},
	{33851, 215572},
	{33871, 215576},
	{33891, 215580},
	{33911, 215808},
	{33930, 215812},
	{33949, 215816},
	{33968, 215820},
	{33987, 216064},
	{34006, 216068},
	{34025, 216072},
	{34044, 216076},
	{34063, 216320},
	{34083, 216324},
	{34103, 216328},
	{34123, 216332},
	{34143, 216336},
	{34163, 216340},
	{34183, 216344},
	{34203, 216348},
	{59449, 216576},
	{59469, 216580},
	{59489, 216584},
	{59509, 216588},
	{59529, 216592},
	{59549, 216596},
	{59569, 216600},
	{59589, 216604},
	{59609, 216640},
	{59629, 216644},
	{59649, 216648},
	{59669, 216652},
	{59689, 216656},
	{59709, 216660},
	{59729, 216664},
	{59749, 216668},
	{35055, 217112},
	{35074, 217116},
	{35093, 217120},
	{35112, 217124},
	{35131, 217128},
	{35150, 217132},
	{35169, 217136},
	{35188, 217140},
	{35207, 217344},
	{35226, 217348},
	{35245, 217352},
	{35264, 217356},
	{35283, 217360},
	{35302, 217364},
	{35321, 217368},
	{35340, 217372},
	{35359, 217600},
	{35379, 217604},
	{35399, 217608},
	{35419, 217612},
	{35439, 217856},
	{35459, 217860},
	{35479, 217864},
	{35499, 217868},
	{35519, 217872},
	{35539, 217876},
	{35559, 217880},
	{35579, 217884},
	{35602, 218112},
	{35627, 218116, 2, 1877},
	{35651, 218144},
	{35677, 218148, 2, 1877},
	{36741, 221184, 5, 7334},
	{36765, 221188, 4, 7339},
	{36790, 221192, 5, 7334},
	{36814, 221196, 5, 7334},
	{36838, 221200, 4, 7339},
	{36863, 221204, 5, 7334},
	{36887, 221208, 4, 7339},
	{36912, 221212, 5, 7334},
	{36936, 221216, 4, 1888},
	{36952, 221220, 5, 7334},
	{36976, 221224, 3, 1892},
	{37010, 221228, 3, 1895},
	{37044, 221232, 3, 1898},
	{37069, 221236, 3, 1901},
	{37094, 221240, 3, 7343},
	{37119, 221248},
	{37134, 221252, 1, 1825},
	{37157, 221256},
	{37180, 221260},
	{37198, 221264, 2, 1904},
	{37216, 221268, 4, 1906},
	{37236, 221440, 22, 7346},
	{37261, 221444, 22, 7346},
	{37286, 221448, 13, 7368},
	{37314, 221452, 13, 7368},
	{37342, 221456, 13, 7368},
	{37370, 221460, 13, 7368},
	{54359, 221696, 2, 5460},
	{54422, 221700, 2, 5460},
	{59929, 221704, 2, 5460},
	{59952, 221708, 2, 5460},
	{56771, 221712, 5, 1964},
	{56794, 221716, 2, 5460},
	{56817, 221720, 2, 5460},
	{56840, 221724, 2, 5460},
	{59975, 221728, 4, 1969},
	{57320, 221744, 5, 1964},
	{57344, 221748, 5, 1964},
	{57368, 221752, 2, 5460},
	{57392, 221756, 2, 5460},
	{59999, 221760, 4, 1969},
	{60024, 221764, 4, 1969},
	{57294, 221776, 1, 5501},
	{37828, 222208, 5, 1964},
	{37854, 222212, 4, 1969},
	{37881, 222216, 5, 1964},
	{37907, 222220, 4, 1969},
	{37934, 222224, 3, 2020},
	{37987, 222228, 3, 2020},
	{38040, 222464, 5, 1964},
	{38066, 222468, 4, 1969},
	{38093, 222472, 1, 1879},
	{38119, 222476, 1, 1879},
	{38145, 222480, 1, 1879},
	{38171, 222484, 1, 1879},
	{38197, 222488, 1, 1879},
	{38223, 222492, 1, 1879},
	{38249, 222496, 1, 1879},
	{38275, 222720, 5, 1964},
	{38299, 222724, 5, 1964},
	{38323, 222728, 5, 1964},
	{38347, 222732, 5, 1964},
	{38371, 222736, 4, 1969},
	{38396, 222740, 4, 1969},
	{38421, 222744, 4, 1969},
	{38446, 222748, 4, 1969},
	{38471, 222752, 1, 2008},
	{38495, 222756, 1, 2008},
	{38519, 222760, 8, 1973},
	{38540, 222976, 6, 5659},
	{38563, 222980, 6, 5659},
	{38586, 222984, 6, 5659},
	{38609, 222988, 6, 5659},
	{38632, 222992, 6, 5659},
	{38655, 222996, 6, 5659},
	{38678, 223000, 6, 5659},
	{38701, 223004, 6, 5659},
	{38724, 223008, 6, 5659},
	{38747, 223012, 6, 5659},
	{38770, 223016, 6, 5659},
	{38794, 223020, 6, 5659},
	{38818, 223024, 6, 5659},
	{38842, 223028, 6, 5659},
	{38866, 223032, 6, 5659},
	{38890, 223036, 6, 5659},
	{38914, 223104, 9, 5642},
	{60049, 223108, 2, 5690},
	{38934, 223112, 1, 1994},
	{39029, 223488, 5, 1964},
	{39052, 223492, 5, 1964},
	{39075, 223496, 3, 2020},
	{39098, 223500, 3, 2020},
	{39121, 223504, 4, 1969},
	{39145, 223508, 4, 1969},
	{39169, 223744, 5, 1964},
	{39193, 223748, 5, 1964},
	{39217, 223752, 5, 1964},
	{39241, 223756, 5, 1964},
	{39265, 223760, 4, 1969},
	{39290, 224000, 5, 2008},
	{39313, 224004, 4, 2013},
	{39337, 224008, 3, 2017},
	{39360, 224256, 5, 2008},
	{39383, 224260, 4, 2013},
	{39407, 224264, 3, 2017},
	{39430, 224512, 5, 1964},
	{39454, 224516, 4, 1969},
	{39479, 224520, 5, 1964},
	{39503, 224524, 4, 1969},
	{39528, 224528, 3, 2020},
	{39552, 224532, 3, 2020},
	{60069, 224768, 5, 1964},
	{60093, 224772, 4, 1958},
	{60118, 224776, 5, 1964},
	{60142, 224780, 4, 1958},
	{60167, 224784, 3, 2020},
	{60191, 224788, 3, 2020},
	{60215, 224832, 5, 1964},
	{60239, 224836, 4, 1958},
	{60264, 224840, 5, 1964},
	{60288, 224844, 4, 1958},
	{60313, 224848, 3, 2020},
	{60337, 224852, 3, 2020},
	{40253, 225280, 12, 2023},
	{40275, 225284, 5, 2035},
	{40298, 225288, 4, 2040},
	{40322, 225292, 2, 2044},
	{40345, 225296, 2, 2044},
	{40368, 225300, 2, 2044},
	{40391, 225536, 5, 1964},
	{40414, 225540, 4, 1969},
	{40438, 225544, 5, 1964},
	{40461, 225548, 4, 1969},
	{40485, 225552, 5, 1964},
	{40508, 225560, 5, 1964},
	{40531, 225792, 4, 2046},
	{40552, 225796},
	{40581, 225800, 2, 2050},
	{40610, 225804},
	{40636, 225808, 7, 2052},
	{40710, 225812},
	{40733, 225816},
	{60482, 225820, 2, 6292},
	{60515, 225824, 2, 6292},
	{60548, 225828, 2, 6292},
	{60581, 225832, 2, 6292},
	{60613, 225836, 2, 6292},
	{60645, 225840, 2, 6292},
	{60677, 225844, 2, 6292},
	{60710, 225848, 2, 6292},
	{60742, 225856, 2, 6292},
	{60774, 225860, 2, 6292},
	{60807, 225864, 2, 6292},
	{60840, 225868, 2, 6292},
	{60873, 225872, 2, 6292},
	{60905, 225876, 2, 6292},
	{60937, 225880, 2, 6292},
	{60970, 225884, 2, 6292},
	{61003, 225888, 2, 6292},
	{61069, 225896, 2, 6292},
	{40756, 225900},
	{40783, 225904},
	{40665, 225908},
	{40684, 225912},
	{63378, 225932, 2, 6292},
	{63411, 225936, 2, 7381},
	{41674, 226040, 1, 2136},
	{41653, 226044, 1, 2136},
	{41446, 226048, 2, 2126},
	{41463, 226052, 1, 2128},
	{41487, 226056, 1, 2128},
	{41511, 226060, 4, 2129},
	{41537, 226064, 3, 2133},
	{41566, 226068, 1, 694},
	{41595, 226072, 3, 2133},
	{41624, 226076, 1, 694},
	{41701, 226304, 5, 2035},
	{41725, 226308, 4, 2040},
	{41750, 226312, 2, 2044},
	{41774, 226316, 5, 2035},
	{41798, 226320, 4, 2040},
	{41823, 226324, 2, 2044},
	{41847, 226328, 10, 2137},
	{41872, 226560, 5, 2147},
	{41899, 226564, 5, 2147},
	{41926, 226568, 6, 2152},
	{41957, 226608, 5, 2147},
	{41985, 226612, 5, 2147},
	{42013, 226616, 5, 2147},
	{42041, 226620, 5, 2147},
	{42069, 226624, 5, 2147},
	{42097, 226628, 5, 2147},
	{42125, 226632, 5, 2147},
	{42153, 226636, 5, 2147},
	{42181, 226640, 6, 2152},
	{206, 880, 4, 2163},
	{43232, 881},
	{27079, 882},
	{43244, 1008},
	{43255, 1009},
	{27267, 1010, 4, 2167},
	{43266, 1040, 1, 2171},
	{43279, 1041, 5, 2172},
	{43292, 1042, 1, 2177},
	{43305, 1043, 1, 1688},
	{27101, 1045, 7, 2178},
	{43333, 1281, 6, 2197},
	{43348, 1282},
	{27038, 1283},
	{43232, 1285},
	{27079, 1286},
};

static const struct si_reg gfx940_reg_table[] = {
	{43384, 40},
	{1390, 68, 14, 6721},
	{1403, 72, 25, 7383},
	{1418, 76, 11, 7408},
	{55593, 80, 11, 7419},
	{1455, 84, 5, 7430},
	{1473, 88, 2, 3924},
	{1491, 92, 7, 6765},
	{1506, 96},
	{1520, 100, 1, 70},
	{1534, 104},
	{55607, 108},
	{55624, 112, 13, 6772},
	{1551, 116, 7, 6785},
	{1567, 120},
	{1689, 2480},
	{1703, 2484},
	{1717, 2488},
	{1731, 2492},
	{1745, 2496},
	{1759, 2500},
	{1773, 2504},
	{1787, 2508},
	{1801, 2512},
	{1815, 2516},
	{1829, 2520},
	{1844, 2524},
	{1859, 2528},
	{1874, 2532},
	{1889, 2536},
	{1904, 2540},
	{1919, 2544},
	{1930, 2552},
	{1946, 2556},
	{2034, 32776, 27, 7435},
	{2047, 32784, 24, 6817},
	{2059, 32788, 12, 6841},
	{2075, 32792, 12, 6841},
	{2104, 32824, 12, 6841},
	{2120, 32828, 12, 6841},
	{47369, 33280, 4, 7462},
	{51428, 33288, 3, 7466},
	{2136, 33296, 16, 6853},
	{2150, 33300, 28, 204},
	{2167, 33304, 14, 232},
	{2188, 33308, 21, 6869},
	{2202, 33312, 31, 6194},
	{2219, 33316, 11, 307},
	{2258, 33324, 1, 329},
	{43429, 33328, 4, 7469},
	{2281, 33344, 1, 7473},
	{2302, 33348},
	{2322, 33352, 1, 332},
	{2363, 33436, 1, 342},
	{58190, 36032},
	{58211, 36036, 1, 4849},
	{2511, 36040, 7, 6232},
	{2532, 36044, 3, 5687},
	{58232, 36048, 2, 5690},
	{2559, 36052, 1, 5714},
	{58258, 36056, 15, 7288},
	{59261, 36060, 1, 6241},
	{59283, 36064},
	{2490, 36068, 2, 5692},
	{2580, 36072, 6, 7303},
	{58300, 36076, 1, 5715},
	{58279, 36080},
	{29987, 36096},
	{30014, 36100},
	{30041, 36104},
	{30068, 36108},
	{2767, 36608},
	{2785, 36612, 4, 383},
	{2803, 36616},
	{2821, 36620, 12, 6890},
	{3722, 36624},
	{3740, 36628, 6, 7474},
	{3758, 36632, 3, 5759},
	{3776, 36636, 8, 6910},
	{3794, 36640, 3, 6918},
	{3812, 36644, 7, 6921},
	{3830, 36648, 8, 6462},
	{3848, 36652},
	{2839, 36656, 14, 6470},
	{2857, 36660, 4, 411},
	{2875, 36664, 10, 6928},
	{2893, 36668, 3, 6938},
	{2911, 37120, 9, 426},
	{2927, 39160, 13, 6941},
	{2942, 39184, 5, 5817},
	{2956, 39188, 5, 5817},
	{2970, 39192, 5, 5817},
	{2984, 39196, 5, 5817},
	{2998, 39200, 5, 5817},
	{3012, 39204, 5, 5817},
	{3026, 39208, 5, 5817},
	{3040, 39212, 5, 5817},
	{3054, 39216, 5, 5817},
	{3068, 39220, 5, 5817},
	{3082, 39224, 5, 5817},
	{3097, 39228, 5, 5817},
	{3112, 39232, 5, 5817},
	{3127, 39236, 5, 5817},
	{3142, 39240, 5, 5817},
	{3157, 39244, 5, 5817},
	{3172, 39248, 5, 5817},
	{3187, 39252, 5, 5817},
	{3202, 39256, 5, 5817},
	{3217, 39260, 5, 5817},
	{3232, 39264, 5, 5817},
	{3247, 39268, 5, 5817},
	{3262, 39272, 5, 5817},
	{3277, 39276, 5, 5817},
	{3292, 39280, 5, 5817},
	{3307, 39284, 5, 5817},
	{3322, 39288, 5, 5817},
	{3337, 39292, 5, 5817},
	{3352, 39296, 5, 5817},
	{3367, 39300, 5, 5817},
	{3382, 39304, 5, 5817},
	{3397, 39308, 5, 5817},
	{3412, 39312, 4, 445},
	{3431, 39316, 4, 445},
	{3450, 39320, 4, 445},
	{3469, 39324, 4, 445},
	{3488, 39328, 4, 445},
	{3507, 39332, 4, 445},
	{3526, 39336, 4, 445},
	{3545, 39340, 4, 445},
	{3564, 39344, 4, 445},
	{3583, 39348, 4, 445},
	{3602, 39352, 4, 445},
	{3622, 39356, 4, 445},
	{3642, 39360, 4, 445},
	{3662, 39364, 4, 445},
	{3682, 39368, 4, 445},
	{3702, 39372, 4, 445},
	{3947, 45084, 4, 6954},
	{3971, 45088},
	{3992, 45092, 1, 498},
	{4013, 45096, 11, 6958},
	{4037, 45100, 10, 6969},
	{4061, 45104},
	{4087, 45108},
	{4113, 45112},
	{4139, 45116},
	{4165, 45120},
	{4191, 45124},
	{4217, 45128},
	{4243, 45132},
	{4269, 45136},
	{4295, 45140},
	{4321, 45144},
	{4348, 45148},
	{4375, 45152},
	{4402, 45156},
	{4429, 45160},
	{4456, 45164},
	{4483, 45168},
	{4510, 45172},
	{4537, 45176},
	{4564, 45180},
	{4591, 45184},
	{4618, 45188},
	{4645, 45192},
	{4672, 45196},
	{4699, 45200},
	{4726, 45204},
	{4753, 45208},
	{4780, 45212},
	{4807, 45216},
	{4834, 45220},
	{4861, 45224},
	{4888, 45228},
	{5128, 45336, 4, 6954},
	{5152, 45340, 1, 534},
	{5177, 45344},
	{5198, 45348, 1, 498},
	{5219, 45352, 12, 6979},
	{5243, 45356, 14, 6991},
	{5267, 45360},
	{5293, 45364},
	{5319, 45368},
	{5345, 45372},
	{5371, 45376},
	{5397, 45380},
	{5423, 45384},
	{5449, 45388},
	{5475, 45392},
	{5501, 45396},
	{5527, 45400},
	{5554, 45404},
	{5581, 45408},
	{5608, 45412},
	{5635, 45416},
	{5662, 45420},
	{5689, 45424},
	{5716, 45428},
	{5743, 45432},
	{5770, 45436},
	{5797, 45440},
	{5824, 45444},
	{5851, 45448},
	{5878, 45452},
	{5905, 45456},
	{5932, 45460},
	{5959, 45464},
	{5986, 45468},
	{6013, 45472},
	{6040, 45476},
	{6067, 45480},
	{6094, 45484},
	{6285, 45552, 9, 561},
	{6391, 45572, 2, 7005},
	{6415, 45576},
	{6447, 45580},
	{7722, 45584},
	{7743, 45588, 1, 498},
	{6527, 45596, 4, 6954},
	{6551, 45600},
	{6572, 45604, 1, 498},
	{6593, 45608, 12, 7007},
	{6617, 45612, 9, 7019},
	{7812, 45872},
	{7838, 45876},
	{7864, 45880},
	{7890, 45884},
	{7916, 45888},
	{7942, 45892},
	{7968, 45896},
	{7994, 45900},
	{8020, 45904},
	{8046, 45908},
	{8072, 45912},
	{8099, 45916},
	{8126, 45920},
	{8153, 45924},
	{8180, 45928},
	{8207, 45932},
	{61282, 45936},
	{61309, 45940},
	{61336, 45944},
	{61363, 45948},
	{61390, 45952},
	{61417, 45956},
	{61444, 45960},
	{61471, 45964},
	{61498, 45968},
	{61525, 45972},
	{61552, 45976},
	{61579, 45980},
	{61606, 45984},
	{61633, 45988},
	{61660, 45992},
	{61687, 45996},
	{8286, 46084, 1, 7005},
	{8310, 46088},
	{8342, 46092},
	{9617, 46096},
	{9638, 46100, 1, 498},
	{8422, 46108, 4, 7028},
	{8446, 46112},
	{8467, 46116, 1, 498},
	{8488, 46120, 11, 7032},
	{8512, 46124, 7, 7043},
	{9707, 46128},
	{9733, 46132},
	{9759, 46136},
	{9785, 46140},
	{9811, 46144},
	{9837, 46148},
	{9863, 46152},
	{9889, 46156},
	{9915, 46160},
	{9941, 46164},
	{9967, 46168},
	{9994, 46172},
	{10021, 46176},
	{10048, 46180},
	{10075, 46184},
	{10102, 46188},
	{61714, 46192},
	{61741, 46196},
	{61768, 46200},
	{61795, 46204},
	{61822, 46208},
	{61849, 46212},
	{61876, 46216},
	{61903, 46220},
	{61930, 46224},
	{61957, 46228},
	{61984, 46232},
	{62011, 46236},
	{62038, 46240},
	{62065, 46244},
	{62092, 46248},
	{62119, 46252},
	{62146, 46384},
	{62176, 46388},
	{62206, 46392},
	{62236, 46396},
	{62266, 46400},
	{62296, 46404},
	{62326, 46408},
	{62356, 46412},
	{62386, 46416},
	{62416, 46420},
	{62446, 46424},
	{62477, 46428},
	{62508, 46432},
	{62539, 46436},
	{62570, 46440},
	{62601, 46444},
	{62632, 46448},
	{62663, 46452},
	{62694, 46456},
	{62725, 46460},
	{62756, 46464},
	{62787, 46468},
	{62818, 46472},
	{62849, 46476},
	{62880, 46480},
	{62911, 46484},
	{62942, 46488},
	{62973, 46492},
	{63004, 46496},
	{63035, 46500},
	{63066, 46504},
	{63097, 46508},
	{10129, 47104, 11, 7050},
	{10156, 47108},
	{10170, 47112},
	{10184, 47116},
	{10198, 47120},
	{10214, 47124},
	{10230, 47128},
	{10246, 47132, 2, 666},
	{10267, 47136, 2, 666},
	{10288, 47140, 2, 666},
	{10309, 47144, 1, 668},
	{10337, 47148, 1, 669},
	{10362, 47152},
	{10377, 47156, 1, 670},
	{10392, 47160},
	{10421, 47164, 1, 670},
	{10450, 47168},
	{10483, 47172, 1, 670},
	{10516, 47176, 11, 7061},
	{10534, 47180, 12, 7072},
	{10552, 47184, 1, 694},
	{10565, 47188, 7, 7084},
	{59097, 47192, 2, 5946},
	{59128, 47196, 2, 5946},
	{10643, 47200, 2, 701},
	{59311, 47204, 2, 5946},
	{59342, 47208, 2, 5946},
	{10718, 47212},
	{10736, 47216},
	{10754, 47220},
	{10772, 47224, 1, 703},
	{10800, 47228, 2, 7480},
	{10822, 47232},
	{10842, 47236},
	{11025, 47240, 3, 720},
	{11042, 47244},
	{11071, 47248, 1, 723},
	{63444, 47260, 1, 7482},
	{11003, 47280},
	{10966, 47284, 4, 7483},
	{11118, 47360},
	{11138, 47364},
	{11158, 47368},
	{11178, 47372},
	{11198, 47376},
	{11218, 47380},
	{11238, 47384},
	{11258, 47388},
	{11278, 47392},
	{11298, 47396},
	{11318, 47400},
	{11339, 47404},
	{11360, 47408},
	{11381, 47412},
	{11402, 47416},
	{11423, 47420},
	{11468, 47608},
	{11489, 47612},
	{26913, 197092, 1, 1670},
	{26930, 197100, 1, 1671},
	{26951, 197104, 13, 1672},
	{26965, 197108},
	{26979, 197112},
	{26993, 197116, 2, 1685},
	{27243, 197168, 1, 1705},
	{206, 880, 4, 2163},
	{43232, 881},
	{27079, 882},
	{43244, 1008},
	{43255, 1009},
	{27267, 1010, 4, 2167},
	{43266, 1040, 1, 2171},
	{43279, 1041, 5, 2172},
	{43292, 1042, 1, 2177},
	{43305, 1043, 1, 1688},
	{27101, 1045, 7, 2178},
	{43333, 1281, 6, 2197},
	{43348, 1282},
	{27038, 1283},
	{43232, 1285},
	{27079, 1286},
};

static const struct si_field sid_fields_table[] = {
	/* 0 */
	{63466, 0xF},
	{63475, 0xF0},
	{63485, 0x100},
	{63496, 0x200},
	{63501, 0x400},
	{63628, 0x1FF000, 257, 0},
	{63636, 0x800000},
	{63646, 0x8000000},
	{63659, 0x10000000},
	{63665, 0xE0000000},
	/* 10 */
	{63669, 0x1},
	{63673, 0x6},
	{63682, 0x18},
	{51265, 0x20},
	{63692, 0x40},
	{63700, 0x80},
	{63710, 0x100},
	{63721, 0x200},
	{63727, 0x400},
	{63732, 0x800},
	{63738, 0x1000},
	{54277, 0x2000},
	{63749, 0x4000},
	{63754, 0x8000},
	{63515, 0x10000},
	{63769, 0x20000},
	{63777, 0x40000},
	{63789, 0x80000},
	{63797, 0x800000},
	{63808, 0x8000000},
	/* 30 */
	{63820, 0x1FF, 257, 0},
	{63825, 0x400},
	{63833, 0x800},
	{63846, 0x7000},
	{63854, 0x8000},
	{63865, 0xF0000},
	{63876, 0xF00000},
	{63892, 0x1000000},
	{63906, 0x10000000},
	{63918, 0xE0000000},
	/* 40 */
	{59029, 0xF},
	{63926, 0x30},
	{63934, 0xC0},
	{63942, 0xF00},
	{63948, 0x1000},
	{29316, 0x6000},
	{63954, 0x8000},
	{63966, 0xF0000},
	{63972, 0xF00000},
	{63978, 0x7000000},
	{63987, 0x38000000},
	{63996, 0xC0000000},
	/* 52 */
	{64002, 0xFF},
	{64012, 0xFF00},
	{64022, 0xFF0000},
	{64032, 0xF000000},
	/* 56 */
	{64042, 0x1FF},
	{64051, 0x1FF000},
	{64060, 0xF000000},
	/* 59 */
	{64077, 0xF},
	{64084, 0x70},
	{64092, 0x80},
	{64106, 0xF00},
	{64115, 0x7000},
	{64124, 0x8000},
	{64137, 0x3F0000},
	{64142, 0xC00000},
	{64152, 0x1000000},
	{64166, 0x2000000},
	{64178, 0xFC000000},
	/* 70 */
	{1528, 0xFFFF},
	/* 71 */
	{63906, 0x1},
	{64185, 0x2},
	{64191, 0x4},
	{64205, 0x8},
	{64220, 0x3F0},
	{64225, 0x1F800},
	{64137, 0xFC0000},
	{64230, 0x1000000},
	{64240, 0xFE000000},
	/* 80 */
	{59029, 0x1F},
	{63926, 0x300},
	{64249, 0x3C00},
	{64256, 0x10000},
	{29316, 0xC0000},
	/* 85 */
	{63978, 0xF},
	{63934, 0x30},
	{63996, 0x300},
	{63987, 0x7000},
	{64262, 0x1F0000},
	{63972, 0xF000000},
	{64268, 0x60000000},
	/* 92 */
	{64281, 0x1},
	{64289, 0x6},
	/* 94 */
	{64304, 0x3},
	/* 95 */
	{30780, 0x3F},
	{10529, 0xFC0},
	{10547, 0x3F000},
	{30755, 0xFC0000},
	/* 99 */
	{64313, 0x3},
	{64327, 0x80},
	{64345, 0x300},
	{64355, 0x400},
	{64368, 0x800},
	{63897, 0x1000},
	{64375, 0x2000},
	/* 106 */
	{64385, 0xF},
	{64408, 0x10},
	{64431, 0x20},
	{64454, 0x40},
	{64474, 0x80},
	{64494, 0x100},
	{64514, 0x200},
	{64534, 0x400},
	{64554, 0x800},
	{64574, 0x1000},
	{64594, 0x2000},
	{64614, 0x4000},
	{64629, 0x8000},
	{64640, 0x10000},
	{64648, 0x20000},
	{64657, 0x40000},
	{64674, 0x80000},
	{64689, 0x100000},
	{64702, 0x200000},
	{64712, 0x400000},
	{64729, 0x800000},
	{64746, 0x1000000},
	{64755, 0x2000000},
	{64764, 0x10000000},
	{64773, 0x20000000},
	{64782, 0x40000000},
	{64791, 0x80000000},
	/* 133 */
	{64802, 0xF},
	{64825, 0x20},
	{64841, 0x80},
	{64864, 0x100},
	{64887, 0x200},
	{64906, 0x1000},
	{64915, 0x2000},
	{64924, 0x4000},
	{64932, 0x8000},
	{64941, 0x10000},
	{64956, 0x100000},
	{64964, 0x200000},
	{64972, 0x400000},
	{64981, 0x800000},
	{64990, 0x1000000},
	{64998, 0x2000000},
	{65006, 0x4000000},
	{65014, 0x10000000},
	{64756, 0x20000000},
	{65032, 0x40000000},
	{65040, 0x80000000},
	/* 154 */
	{64906, 0x2},
	{64915, 0x4},
	{65051, 0x8},
	{64755, 0x10},
	{65062, 0x20},
	{64648, 0x200000},
	{64981, 0x400000},
	{64998, 0x1000000},
	{64924, 0x2000000},
	{64956, 0x4000000},
	{64972, 0x8000000},
	{64990, 0x20000000},
	{65006, 0x40000000},
	{65032, 0x80000000},
	/* 168 */
	{65073, 0x20},
	{65102, 0x40},
	{65133, 0x80},
	{65162, 0x100},
	{65182, 0x200},
	{65202, 0x400},
	{65222, 0x800},
	{65242, 0x2000},
	{65250, 0x4000},
	{65258, 0x8000},
	{65062, 0x10000},
	{65269, 0x10000000},
	{65283, 0x20000000},
	{65051, 0x40000000},
	{65292, 0x80000000},
	/* 183 */
	{65301, 0x1},
	{65311, 0x2},
	{65321, 0x4},
	{65330, 0x8},
	{65339, 0x10},
	{65350, 0x20},
	{65361, 0x40},
	{65371, 0x80},
	{65381, 0x400},
	{65391, 0x800},
	{65408, 0x1000},
	{65416, 0x2000},
	{65429, 0x4000},
	{65447, 0x8000},
	{65458, 0x10000},
	{65467, 0x20000},
	{65488, 0x40000},
	{65499, 0x80000},
	{65526, 0x20000000},
	{65539, 0x40000000},
	{64773, 0x80000000},
	/* 204 */
	{65552, 0x1},
	{65567, 0x2},
	{65587, 0x4},
	{65603, 0x8},
	{65621, 0x10},
	{65641, 0x20},
	{65660, 0x40},
	{65679, 0x80},
	{65692, 0x100},
	{65706, 0x200},
	{65730, 0x400},
	{65746, 0x800},
	{65762, 0x1000},
	{65778, 0x2000},
	{65794, 0x10000},
	{65809, 0x20000},
	{65829, 0x40000},
	{65845, 0x80000},
	{65863, 0x100000},
	{65883, 0x200000},
	{65902, 0x400000},
	{65921, 0x800000},
	{65934, 0x1000000},
	{65948, 0x2000000},
	{65972, 0x4000000},
	{65988, 0x8000000},
	{66004, 0x10000000},
	{66020, 0x20000000},
	/* 232 */
	{66036, 0x8},
	{66055, 0x10},
	{66075, 0x40},
	{66094, 0x100},
	{66115, 0x200},
	{66133, 0x400},
	{66156, 0x2000},
	{66178, 0x10000},
	{66199, 0x20000},
	{66217, 0x40000},
	{66240, 0x200000},
	{66262, 0x400000},
	{66286, 0x800000},
	{66310, 0x1000000},
	{66333, 0x2000000},
	/* 247 */
	{66355, 0x1},
	{66374, 0x2},
	{66383, 0x10},
	{66398, 0x20},
	{66412, 0x40},
	{66431, 0x80},
	{66450, 0x100},
	{66465, 0x200},
	{66482, 0x400},
	{66504, 0x800},
	{66526, 0x1000},
	{66541, 0x2000},
	{65381, 0x4000},
	{66556, 0x8000},
	{66565, 0x10000},
	{65416, 0x20000},
	{66574, 0x40000},
	{66584, 0x80000},
	{66598, 0x100000},
	{66612, 0x200000},
	{66626, 0x400000},
	{65447, 0x800000},
	{66643, 0x1000000},
	{66656, 0x4000000},
	{66669, 0x8000000},
	{66682, 0x30000000},
	{66701, 0x40000000},
	{64764, 0x80000000},
	/* 275 */
	{66714, 0x1},
	{66732, 0x2},
	{66746, 0x4},
	{66765, 0x8},
	{66784, 0x10},
	{66799, 0x20},
	{66817, 0x40},
	{66835, 0x80},
	{66852, 0x100},
	{66867, 0x200},
	{66881, 0x400},
	{66898, 0x800},
	{66922, 0x1000},
	{66940, 0x2000},
	{66958, 0x4000},
	{66979, 0x8000},
	{67003, 0x10000},
	{67029, 0x20000},
	{67046, 0x40000},
	{67066, 0x80000},
	{67086, 0x100000},
	{67106, 0x200000},
	{67127, 0x400000},
	{67150, 0x800000},
	{67171, 0x1000000},
	{67190, 0x2000000},
	{67207, 0x4000000},
	{67223, 0x8000000},
	{67239, 0x10000000},
	{67255, 0x20000000},
	{67274, 0x40000000},
	{67286, 0x80000000},
	/* 307 */
	{67298, 0x1},
	{67317, 0x2},
	{67337, 0x4},
	{67357, 0x8},
	{67377, 0x20},
	{67398, 0x40},
	{66262, 0x80},
	{66286, 0x100},
	{67419, 0x200},
	{67446, 0x400},
	{67473, 0x800},
	{67494, 0x1000},
	{67513, 0x2000},
	/* 320 */
	{67532, 0x1},
	{67546, 0x4},
	{67561, 0x8},
	{67578, 0x80},
	{67590, 0x100},
	{67603, 0x400},
	{67618, 0x800},
	{67633, 0x1000},
	{67648, 0x2000},
	/* 329 */
	{2270, 0x3F},
	/* 330 */
	{2288, 0x1FF},
	{67663, 0x80000000},
	/* 332 */
	{2270, 0x7},
	/* 333 */
	{67688, 0x1000},
	{67710, 0x4000},
	{67735, 0x20000},
	{67756, 0x40000},
	{67780, 0x400000},
	{67807, 0x800000},
	{67832, 0x1000000},
	{67855, 0x8000000},
	{67875, 0x40000000},
	/* 342 */
	{2275, 0xF},
	/* 343 */
	{10508, 0xF},
	{38, 0x3FFFFF00},
	/* 345 */
	{879, 0x1FFFFFFF},
	{67891, 0x80000000},
	/* 347 */
	{67901, 0x3},
	{67910, 0xF0},
	{67918, 0x200},
	{67925, 0x1FC00},
	/* 351 */
	{68196, 0xFFF, 2049, 257},
	{68358, 0xFF0000, 129, 2306},
	{68370, 0x3000000},
	{68383, 0x80000000},
	/* 355 */
	{1398, 0x3},
	{68398, 0x4},
	{68407, 0x8},
	{68418, 0x10},
	{68431, 0x20},
	{58316, 0x1C0},
	{68445, 0x200},
	{68458, 0x400},
	{68471, 0x800},
	{68483, 0x1000},
	{68501, 0x2000},
	{68512, 0xC000},
	{68527, 0x30000},
	{68535, 0x40000},
	{68554, 0x80000},
	{68571, 0x40000000},
	{68583, 0x80000000},
	/* 372 */
	{68597, 0xFFF},
	{68612, 0xFFF000},
	{68624, 0x1000000},
	{64635, 0x2000000},
	{68632, 0x4000000},
	{68652, 0x8000000},
	/* 378 */
	{14373, 0xF},
	{68740, 0x3F0, 33, 2435},
	{68744, 0x400},
	{68619, 0x800},
	{68750, 0x1000},
	/* 383 */
	{68753, 0xFFFF},
	{20123, 0x3FFF0000},
	{68769, 0x40000000},
	{68783, 0x80000000},
	/* 387 */
	{68798, 0x7},
	{68808, 0x38},
	{68818, 0x1C0},
	{68828, 0xE00},
	{17750, 0x7F000, 293, 2468},
	{73065, 0x600000},
	{73078, 0x800000},
	{73093, 0x1000000},
	{73199, 0x30000000, 4, 2761},
	{220, 0xC0000000},
	/* 397 */
	{73210, 0x7},
	{73218, 0x38},
	{73226, 0x1C0},
	{73234, 0xE00},
	{73250, 0x7000},
	{73269, 0x8000},
	{73288, 0x70000},
	{73304, 0x80000},
	{73319, 0x100000},
	{73333, 0x7E00000},
	{73344, 0x8000000},
	{73356, 0x10000000},
	{73374, 0x60000000},
	{73386, 0x80000000},
	/* 411 */
	{73399, 0xFFF},
	{73407, 0xFFF000},
	{73415, 0xF000000},
	{73424, 0xF0000000},
	/* 415 */
	{73431, 0x3FFF},
	{73440, 0xFC000},
	{73453, 0x300000},
	{73467, 0xC00000},
	{73481, 0x3000000},
	{73490, 0xC000000},
	{73501, 0x10000000},
	{73520, 0x20000000},
	{73535, 0x40000000},
	/* 424 */
	{73550, 0xFFF},
	{73567, 0xC0000000},
	/* 426 */
	{73585, 0x1FFFFF},
	{73604, 0xE00000},
	{73623, 0x1000000},
	{73645, 0x2000000},
	{73667, 0x4000000},
	{73683, 0x8000000},
	{73700, 0x10000000},
	{73718, 0x20000000},
	{73734, 0xC0000000},
	/* 435 */
	{73755, 0x7},
	{73765, 0x38},
	{73786, 0xC0},
	{73807, 0x180000},
	{73826, 0xC000000},
	/* 440 */
	{74196, 0x3C, 16, 2765},
	{74624, 0x7C0, 19, 2781},
	{74814, 0x3800, 7, 2800},
	{74973, 0x1C00000, 5, 2807},
	{74993, 0x6000000},
	/* 445 */
	{75098, 0x3, 4, 2812},
	{75205, 0xC, 4, 2816},
	{75317, 0x30, 4, 2820},
	{75404, 0xC0, 4, 2824},
	/* 449 */
	{68753, 0xFF},
	{73399, 0xFFF00},
	{17750, 0x1FF00000, 293, 2468},
	{75414, 0xC0000000},
	/* 453 */
	{75423, 0xFFF},
	{75210, 0xFFFC000},
	{73093, 0x80000000},
	/* 456 */
	{68798, 0x7},
	{68808, 0x38},
	{68818, 0x1C0},
	{68828, 0xE00},
	{75432, 0xF000},
	{75443, 0xF0000},
	{75454, 0x1F00000},
	{75558, 0xE000000, 6, 2828},
	{220, 0xF0000000},
	/* 465 */
	{18896, 0x1FFF},
	{75569, 0x1FFF0000},
	/* 467 */
	{75580, 0xF},
	{75592, 0xF0},
	{75600, 0xFFF00},
	{75613, 0x700000},
	{75622, 0x800000},
	{75637, 0x2000000},
	{75652, 0x4000000},
	/* 474 */
	{75664, 0xFF},
	{75680, 0x400},
	{75692, 0x18000},
	{75720, 0x60000},
	{75746, 0x80000},
	{75764, 0x100000},
	{75786, 0x200000},
	{75801, 0x400000},
	{75817, 0x800000},
	{75833, 0xFF000000},
	/* 484 */
	{75854, 0x1},
	{75866, 0xE},
	{75879, 0xF0},
	{75897, 0x100},
	{75911, 0x3FE00},
	{75915, 0x40000},
	{43598, 0x80000},
	{10560, 0xF00000},
	{75918, 0x1000000},
	{75921, 0x3E000000},
	/* 494 */
	{75926, 0xFFFF},
	/* 495 */
	{75926, 0xFFFF},
	{75932, 0x3F0000},
	{75943, 0x3C00000},
	/* 498 */
	{75962, 0xFF},
	/* 499 */
	{75971, 0x3F},
	{75977, 0x3C0},
	{73595, 0xC00},
	{76067, 0xFF000, 193, 2834},
	{51265, 0x100000},
	{63485, 0x200000},
	{76078, 0x800000},
	{76088, 0x1000000},
	{76105, 0x2000000},
	{64355, 0x4000000},
	{63636, 0x20000000},
	/* 510 */
	{76117, 0x1},
	{76128, 0x3E},
	{76138, 0x40},
	{76151, 0x80},
	{76163, 0xFF00},
	{63628, 0x1FF0000, 257, 0},
	{76178, 0x2000000},
	{76200, 0x4000000},
	{76225, 0x8000000},
	{76239, 0xF0000000},
	/* 520 */
	{76255, 0x1},
	{76272, 0x1E},
	{76298, 0x1E0},
	{76331, 0x200},
	{76352, 0x7C00},
	{76376, 0x8000},
	{76401, 0x10000},
	{76420, 0xE0000},
	/* 528 */
	{76457, 0x7},
	{76486, 0x38},
	{76518, 0x40},
	{76534, 0xFF00},
	{76563, 0xFF0000},
	/* 533 */
	{76595, 0x7F},
	/* 534 */
	{52830, 0x3F},
	/* 535 */
	{75971, 0x3F},
	{75977, 0x3C0},
	{73595, 0xC00},
	{76067, 0xFF000, 193, 2834},
	{51265, 0x100000},
	{63485, 0x200000},
	{76078, 0x800000},
	{76608, 0x3000000},
	{76622, 0x4000000},
	{76105, 0x8000000},
	{64355, 0x10000000},
	{63636, 0x80000000},
	/* 547 */
	{76117, 0x1},
	{76128, 0x3E},
	{76138, 0x40},
	{76638, 0x80},
	{76648, 0x100},
	{76660, 0x200},
	{76672, 0x400},
	{76684, 0x800},
	{76696, 0x1000},
	{63628, 0x3FE000, 257, 0},
	{76702, 0x400000},
	{76713, 0x1000000},
	{76225, 0x8000000},
	{76239, 0xF0000000},
	/* 561 */
	{76117, 0x1},
	{76128, 0x3E},
	{76138, 0x40},
	{63628, 0xFF80, 257, 0},
	{76608, 0x30000},
	{76638, 0x40000},
	{64051, 0x7F80000},
	{76730, 0x8000000},
	{76225, 0x10000000},
	/* 570 */
	{76117, 0x1},
	{76128, 0x3E},
	{76138, 0x40},
	{76638, 0x80},
	{63628, 0x1FF00, 257, 0},
	{64051, 0x1FF00000},
	/* 576 */
	{76117, 0x1},
	{76128, 0x3E},
	{76138, 0x40},
	{64051, 0xFF80},
	{63628, 0x1FF0000, 257, 0},
	/* 581 */
	{75926, 0xFFFF},
	{76742, 0x7F0000},
	/* 583 */
	{75926, 0xFFFF},
	{75932, 0x3F0000},
	{75943, 0x3C00000},
	{76767, 0xFC000000},
	/* 587 */
	{75971, 0x3F},
	{75977, 0x3C0},
	{73595, 0xC00},
	{76067, 0xFF000, 193, 2834},
	{51265, 0x100000},
	{63485, 0x200000},
	{76078, 0x800000},
	{76622, 0x1000000},
	{76105, 0x2000000},
	{64355, 0x4000000},
	{76784, 0x8000000},
	{76793, 0x60000000},
	{63636, 0x80000000},
	/* 600 */
	{76117, 0x1},
	{76128, 0x3E},
	{76138, 0x40},
	{63628, 0xFF80, 257, 0},
	{76810, 0x30000},
	{76638, 0x40000},
	{64051, 0x7F80000},
	{76225, 0x8000000},
	{76239, 0xF0000000},
	/* 609 */
	{75971, 0x3F},
	{75977, 0x3C0},
	{73595, 0xC00},
	{76067, 0xFF000, 193, 2834},
	{51265, 0x100000},
	{63485, 0x200000},
	{76078, 0x800000},
	{76608, 0x3000000},
	{76622, 0x4000000},
	{63636, 0x80000000},
	/* 619 */
	{75932, 0x3F},
	{75943, 0x3C0},
	{76767, 0xFC00},
	{75926, 0xFFFF0000},
	/* 623 */
	{75971, 0x3F},
	{75977, 0x3C0},
	{73595, 0xC00},
	{76067, 0xFF000, 193, 2834},
	{51265, 0x100000},
	{63485, 0x200000},
	{76078, 0x800000},
	{76105, 0x1000000},
	{64355, 0x2000000},
	{76784, 0x4000000},
	{76827, 0x30000000},
	{63636, 0x40000000},
	/* 635 */
	{76117, 0x1},
	{76128, 0x3E},
	{76138, 0x40},
	{76638, 0x80},
	{76844, 0x100},
	{63628, 0x3FE00, 257, 0},
	{64051, 0x7FC0000},
	{76225, 0x8000000},
	{76239, 0xF0000000},
	/* 644 */
	{75971, 0x3F},
	{75977, 0x3C0},
	{73595, 0xC00},
	{76067, 0xFF000, 193, 2834},
	{51265, 0x100000},
	{63485, 0x200000},
	{76078, 0x800000},
	{76608, 0x3000000},
	{63636, 0x40000000},
	/* 653 */
	{76855, 0x1},
	{76873, 0x2},
	{76887, 0x4},
	{76906, 0x8},
	{76926, 0x10},
	{76946, 0x20},
	{76968, 0x40},
	{76979, 0x400},
	{76997, 0x800},
	{10813, 0x1000},
	{77015, 0x2000},
	{77029, 0x4000},
	{77037, 0x8000},
	/* 666 */
	{77047, 0xFFFF},
	{77063, 0xFFFF0000},
	/* 668 */
	{10317, 0x1},
	/* 669 */
	{10345, 0x1},
	/* 670 */
	{402, 0xFF},
	/* 671 */
	{75971, 0x3F},
	{75977, 0x3C0},
	{73595, 0xC00},
	{76067, 0xFF000, 193, 2834},
	{51265, 0x100000},
	{63485, 0x200000},
	{76078, 0x800000},
	{77082, 0x1000000},
	{63636, 0x4000000},
	{76784, 0x20000000},
	{76105, 0x40000000},
	{64355, 0x80000000},
	/* 683 */
	{76117, 0x1},
	{76128, 0x3E},
	{76138, 0x40},
	{77088, 0x80},
	{77098, 0x100},
	{77108, 0x200},
	{76844, 0x400},
	{77118, 0x1800},
	{77133, 0x6000},
	{64051, 0xFF8000},
	{63628, 0x7F000000, 257, 0},
	/* 694 */
	{402, 0xF},
	/* 695 */
	{77145, 0x3FF},
	{77158, 0xF000},
	{77168, 0x3F0000},
	{77183, 0x400000},
	{77198, 0x800000},
	{77214, 0x7000000},
	/* 701 */
	{77229, 0xFFF},
	{77235, 0x1FFF000},
	/* 703 */
	{10780, 0x1},
	/* 704 */
	{77244, 0x3},
	{74279, 0x4},
	{77254, 0x8},
	{77264, 0x10},
	{77274, 0x1FFE0},
	/* 709 */
	{76255, 0x1},
	{76272, 0x1E},
	{76298, 0x1E0},
	{76331, 0x200},
	{76352, 0x7C00},
	{76376, 0x8000},
	{76401, 0x10000},
	{76420, 0xE0000},
	{77287, 0x7F00000},
	/* 718 */
	{76239, 0xF},
	/* 719 */
	{452, 0x7FF},
	/* 720 */
	{77324, 0x3FFFFFFF},
	{77332, 0x40000000},
	{77341, 0x80000000},
	/* 723 */
	{12062, 0xFFFF},
	/* 724 */
	{77350, 0x3FF},
	{68064, 0x400},
	/* 726 */
	{77360, 0x1},
	{77379, 0x2},
	{77400, 0x4},
	{77411, 0x8},
	{77424, 0x10},
	{77443, 0x20},
	{77468, 0x40},
	{77491, 0x80},
	{77505, 0xF00},
	{77517, 0x1000},
	/* 736 */
	{77535, 0x1},
	{77559, 0x2},
	{77580, 0x4},
	{77614, 0x8},
	{77649, 0x70},
	{77661, 0xF00},
	{77674, 0xF000},
	{77687, 0xF0000},
	{77700, 0xF00000},
	{77714, 0xF000000},
	{77732, 0xF0000000},
	/* 747 */
	{77749, 0x7FF},
	{77761, 0x1800},
	{77776, 0xFFE000},
	{77786, 0x1000000},
	{77798, 0x2000000},
	{77816, 0x3C000000},
	{77822, 0xC0000000},
	/* 754 */
	{77887, 0x3, 4, 3027},
	{77904, 0xC, 4, 3027},
	{77922, 0x30, 4, 3027},
	{77940, 0x40},
	{77961, 0x80},
	{77976, 0x100},
	{77997, 0x200},
	{78015, 0x400},
	{78032, 0x800},
	{78045, 0x1000},
	{78064, 0x6000, 4, 3027},
	{78083, 0x8000},
	{78107, 0x10000},
	{78130, 0x20000},
	{78147, 0x40000},
	{78232, 0x180000, 4, 3031},
	{78251, 0x3E00000},
	{78268, 0x4000000},
	{78292, 0x8000000},
	{78306, 0x10000000},
	{78326, 0x20000000},
	{78340, 0x40000000},
	{78360, 0x80000000},
	/* 777 */
	{78434, 0x3, 4, 3035},
	{78463, 0x1C},
	{78494, 0x20},
	{78530, 0x40},
	{78565, 0x80},
	{78593, 0x100},
	{78615, 0x200},
	{78633, 0x400},
	{78665, 0x800},
	{78786, 0x7000, 8, 3039},
	{78796, 0x38000},
	{78809, 0x1C0000},
	{78822, 0x200000},
	{78838, 0x400000},
	{78856, 0x800000},
	{78874, 0x2000000},
	/* 793 */
	{78902, 0x3FFF},
	{63438, 0x3FFF0000},
	/* 795 */
	{11680, 0xFF},
	/* 796 */
	{78908, 0xFFFF},
	{78913, 0xFFFF0000},
	/* 798 */
	{78918, 0xFFFF},
	{78923, 0xFFFF0000},
	/* 800 */
	{78937, 0x3, 4, 3047},
	{78951, 0x4},
	{78976, 0x8},
	/* 803 */
	{78994, 0xF},
	{79002, 0xF0},
	{79010, 0x1F00},
	{79018, 0x6000},
	{79026, 0x18000},
	{79034, 0x60000},
	{79042, 0x180000},
	{73093, 0xF0000000},
	/* 811 */
	{17750, 0x3, 4, 3051},
	{79081, 0xC},
	{75454, 0x1F0},
	{79136, 0x600, 4, 3055},
	{79151, 0x800},
	{79165, 0x1000},
	{79184, 0xE000},
	{79201, 0xF0000},
	{75680, 0x100000},
	{79208, 0x7800000},
	{79232, 0x8000000},
	{79247, 0x10000000},
	{79257, 0x20000000},
	{79277, 0x80000000},
	/* 825 */
	{17750, 0x1, 2, 3059},
	{75454, 0x1F0},
	{79136, 0x600, 4, 3055},
	{79151, 0x800},
	{79165, 0x1000},
	{79184, 0xE000},
	{75680, 0x100000},
	{79232, 0x8000000},
	{79320, 0x20000000},
	/* 834 */
	{78994, 0x7FF},
	{79002, 0x3FF800},
	/* 836 */
	{78994, 0x3FFFFF},
	/* 837 */
	{10508, 0xFF},
	/* 838 */
	{79392, 0x3, 4, 3061},
	{79404, 0xC, 4, 3061},
	{79416, 0x30, 4, 3061},
	{79432, 0xC0, 4, 3061},
	{79502, 0x30000, 4, 3065},
	{79514, 0xC0000, 4, 3065},
	{79526, 0x300000, 4, 3065},
	{79542, 0x1000000},
	{79553, 0x2000000},
	/* 847 */
	{30989, 0xFF},
	/* 848 */
	{79564, 0xFF},
	/* 849 */
	{79582, 0xFFFF},
	{79598, 0xFFFF0000},
	/* 851 */
	{78908, 0x7FFF},
	{78913, 0x7FFF0000},
	{79614, 0x80000000},
	/* 854 */
	{78918, 0x7FFF},
	{78923, 0x7FFF0000},
	/* 856 */
	{79702, 0xFFFF, 32769, 3069},
	/* 857 */
	{79712, 0xF},
	{79719, 0xF0},
	{79728, 0xF00},
	{79736, 0x3F000},
	{79747, 0xFC0000},
	{79758, 0xF000000},
	{79769, 0xF0000000},
	/* 864 */
	{79780, 0x1FF},
	{79799, 0x1FF0000},
	/* 866 */
	{79818, 0xF},
	{79833, 0xF0},
	{79848, 0xF00},
	{79863, 0xF000},
	{79878, 0xF0000},
	{79893, 0xF00000},
	{79908, 0xF000000},
	{79923, 0xF0000000},
	/* 874 */
	{79938, 0xF},
	{79953, 0xF0},
	{79968, 0xF00},
	{79983, 0xF000},
	{79998, 0xF0000},
	{80013, 0xF00000},
	{80028, 0xF000000},
	{80043, 0xF0000000},
	/* 882 */
	{80150, 0x3, 4, 35838},
	{80162, 0xC, 4, 35838},
	{80274, 0x30, 4, 35842},
	{80331, 0x40, 2, 35846},
	{80387, 0x80, 2, 35848},
	{80491, 0x300, 4, 35850},
	{80599, 0xC00, 4, 35854},
	{80708, 0x3000, 4, 35858},
	{80821, 0xC000, 4, 35862},
	{80923, 0x30000, 4, 35866},
	{81069, 0xC0000, 4, 35870},
	{81216, 0x300000, 4, 35874},
	{81316, 0x3000000, 4, 35878},
	{81462, 0xC000000, 4, 35882},
	{81609, 0x30000000, 4, 35886},
	/* 897 */
	{81729, 0x3, 4, 35890},
	{81900, 0xC, 4, 35894},
	{82072, 0x30, 4, 35898},
	/* 900 */
	{77714, 0x3},
	{77732, 0xC},
	/* 902 */
	{10330, 0x1},
	{82085, 0x6},
	{73826, 0x60},
	{82092, 0x100},
	{82127, 0x3000},
	{82134, 0x30000},
	{82148, 0x100000},
	/* 909 */
	{82166, 0x80000000},
	/* 910 */
	{63934, 0x3},
	/* 911 */
	{10560, 0xF},
	/* 912 */
	{82181, 0xFF},
	{82190, 0xFF00},
	{82200, 0xFF0000},
	{82211, 0xFF000000},
	/* 916 */
	{82221, 0xFF},
	{82229, 0xFF00},
	{82238, 0xFF0000},
	{82247, 0xFF000000},
	/* 920 */
	{82255, 0x3, 4, 3061},
	{82271, 0xC, 4, 3061},
	{82287, 0x30, 4, 3061},
	{82301, 0xC0, 4, 3061},
	{82317, 0x30000, 4, 3065},
	{82333, 0xC0000, 4, 3065},
	{82349, 0x300000, 4, 3065},
	{82363, 0xC00000, 4, 3065},
	{82379, 0x40000000},
	{82394, 0x80000000},
	/* 930 */
	{82409, 0x1},
	{82436, 0x7C},
	{82465, 0x100},
	{82494, 0x200},
	{82525, 0x400},
	{82553, 0x1000},
	{82581, 0x2000},
	{82611, 0x4000},
	/* 938 */
	{82637, 0x1},
	{82657, 0xE},
	{82674, 0x30},
	{82695, 0xF00},
	/* 942 */
	{82953, 0xF, 16, 35902},
	{82965, 0xF0, 16, 35902},
	{82978, 0xF00, 16, 35902},
	{82991, 0xF000, 16, 35902},
	{83006, 0xF0000, 16, 35902},
	{83022, 0xF00000, 16, 35902},
	/* 948 */
	{83038, 0xFF},
	{83053, 0xFF00},
	{83065, 0xFF0000},
	{83082, 0xFF000000},
	/* 952 */
	{83095, 0xFF},
	{83113, 0xFF00},
	{83128, 0xFF0000},
	{83148, 0xFF000000},
	/* 956 */
	{879, 0x3F},
	{83164, 0x300},
	{83176, 0x400},
	{83187, 0x1E000},
	{83196, 0x20000},
	{83210, 0x40000},
	{83214, 0x80000},
	{83231, 0x100000},
	{83249, 0x600000},
	{83267, 0x800000},
	{83287, 0x1000000},
	{83299, 0x2000000},
	/* 968 */
	{879, 0x3F},
	{83164, 0x300},
	{83176, 0x400},
	{83210, 0x40000},
	{83214, 0x80000},
	{83231, 0x100000},
	{83249, 0x600000},
	{83287, 0x1000000},
	{83299, 0x2000000},
	/* 977 */
	{83311, 0x3E},
	{83327, 0x40},
	{83340, 0x80},
	/* 980 */
	{83353, 0x1},
	{83370, 0x2},
	{83387, 0x4},
	{83406, 0x8},
	{83427, 0x10},
	{83445, 0x20},
	{83463, 0x40},
	{83483, 0x80},
	{83504, 0x100},
	{83520, 0x200},
	{83536, 0x400},
	{83552, 0x800},
	{83568, 0x1000},
	{83583, 0x2000},
	{83597, 0x4000},
	{83617, 0x8000},
	/* 996 */
	{83634, 0x1},
	{83649, 0x2},
	{83772, 0x1C, 5, 35918},
	{83790, 0xE0, 5, 35918},
	{83808, 0x700, 5, 35918},
	{83826, 0x3800, 5, 35918},
	{83844, 0x4000},
	/* 1003 */
	{83861, 0x3F},
	{83872, 0x40},
	{83882, 0x80},
	{83899, 0x100},
	{83915, 0x4000},
	{83935, 0x8000},
	/* 1009 */
	{83945, 0x1},
	{83963, 0x10},
	{83983, 0x100},
	{84002, 0x1000},
	{84023, 0x30000},
	{84042, 0x100000},
	{84056, 0x1000000},
	/* 1016 */
	{84164, 0xF, 5, 35923},
	/* 1017 */
	{84183, 0xF, 5, 35923},
	{84202, 0xF0, 5, 35923},
	{84221, 0xF00, 5, 35923},
	{84240, 0xF000, 5, 35923},
	{84259, 0xF0000, 5, 35923},
	/* 1022 */
	{84478, 0xF, 10, 35928},
	/* 1023 */
	{84494, 0xF, 10, 35928},
	{84513, 0xF0, 10, 35928},
	{84532, 0xF00, 10, 35928},
	{84551, 0xF000, 10, 35928},
	{84570, 0xF0000, 10, 35928},
	{84589, 0xF00000, 10, 35928},
	{84608, 0xF000000, 10, 35928},
	{84627, 0xF0000000, 10, 35928},
	/* 1031 */
	{84881, 0xF, 11, 35938},
	{84886, 0xF0, 11, 35938},
	{84891, 0xF00, 11, 35938},
	{84896, 0xF000, 11, 35938},
	{84901, 0xF0000, 11, 35938},
	{84906, 0xF00000, 11, 35938},
	{84911, 0xF000000, 11, 35938},
	{84916, 0xF0000000, 11, 35938},
	/* 1039 */
	{85088, 0xF, 16, 35949},
	{85101, 0xF0},
	{85114, 0xF00},
	{85127, 0xF000},
	{85140, 0xF0000},
	{85153, 0xF00000},
	{85166, 0xF000000},
	{85179, 0xF0000000},
	/* 1047 */
	{85192, 0x1},
	{85215, 0x2},
	{85238, 0x10},
	{85261, 0x20},
	{85284, 0x100},
	{85307, 0x200},
	{85330, 0x1000},
	{85353, 0x2000},
	{85376, 0x10000},
	{85399, 0x20000},
	{85422, 0x100000},
	{85445, 0x200000},
	{85468, 0x1000000},
	{85491, 0x2000000},
	{85514, 0x10000000},
	{85537, 0x20000000},
	{85560, 0x80000000},
	/* 1064 */
	{85851, 0x7, 8, 35965},
	{85865, 0x70, 8, 35965},
	{86013, 0x700, 8, 35973},
	{86028, 0x70000, 8, 35965},
	{86042, 0x700000, 8, 35965},
	{86056, 0x7000000, 8, 35973},
	/* 1070 */
	{86511, 0x1F, 21, 35981},
	{86013, 0xE0, 5, 36002},
	{86616, 0x1F00, 21, 35981},
	{86632, 0x1F0000, 21, 35981},
	{86056, 0xE00000, 5, 36002},
	{86647, 0x1F000000, 21, 35981},
	{86663, 0x20000000},
	{10330, 0x40000000},
	{86684, 0x80000000},
	/* 1079 */
	{86697, 0x7},
	/* 1080 */
	{12057, 0xFFFF},
	/* 1081 */
	{86788, 0x3, 4, 36007},
	{86834, 0xC, 2, 36011},
	{86845, 0x10},
	{86860, 0x20},
	{86868, 0x40},
	{86879, 0x80},
	{86893, 0x100},
	{86910, 0xE0000000},
	/* 1089 */
	{86923, 0xFFFFFFF},
	/* 1090 */
	{86935, 0x3FF},
	/* 1091 */
	{86958, 0x1},
	{77895, 0x2},
	{86973, 0x4},
	{86988, 0x8},
	{78790, 0x70, 8, 3039},
	{87008, 0x80},
	{87024, 0x700, 8, 3039},
	{87036, 0x700000, 8, 3039},
	{87051, 0x40000000},
	{87085, 0x80000000},
	/* 1101 */
	{87120, 0x7},
	{87139, 0x70},
	{87155, 0x700},
	{87179, 0x7000},
	{87205, 0x10000},
	{87232, 0x20000},
	{87254, 0x40000},
	{87273, 0x80000},
	{87291, 0x100000},
	{87318, 0x200000},
	{87345, 0x7000000},
	{87370, 0x8000000},
	/* 1113 */
	{87401, 0x1},
	{87419, 0x8},
	{1398, 0x70, 8, 36013},
	{86692, 0xFF0000, 256, 36021},
	/* 1117 */
	{87839, 0x1},
	{87855, 0x2},
	{87886, 0x4},
	{77953, 0x30, 4, 36277},
	{87965, 0x40},
	{87977, 0x80},
	{88001, 0x100},
	{88020, 0x200},
	{88038, 0x400},
	{88051, 0x800},
	{88073, 0x1000},
	{88163, 0x6000, 4, 36281},
	{88185, 0x8000},
	{88203, 0x10000},
	{88234, 0x20000},
	{88253, 0x700000},
	{88278, 0x800000},
	/* 1134 */
	{88311, 0x1},
	{88321, 0x2},
	{88331, 0x4},
	{88341, 0x8},
	{88351, 0x10},
	{88361, 0x20},
	{88371, 0x2000},
	{88390, 0xC000},
	{88402, 0x10000},
	{88415, 0x20000},
	{88433, 0x40000},
	{88456, 0x80000},
	{88474, 0x100000},
	{88494, 0x200000},
	{88506, 0x400000},
	{88528, 0x1000000},
	{88552, 0x2000000},
	{88578, 0x4000000},
	{88597, 0x8000000},
	{88615, 0x10000000},
	/* 1154 */
	{88635, 0x1},
	{88646, 0x2},
	{19624, 0x4},
	{88666, 0x18, 2, 36285},
	{88732, 0xE0, 3, 36287},
	{88753, 0x700, 3, 36287},
	{88773, 0x800},
	{88798, 0x1000},
	{88822, 0x2000},
	{88846, 0x10000},
	{88871, 0x80000},
	{88890, 0x100000},
	{88905, 0x200000},
	{88923, 0x400000},
	{88961, 0x800000},
	{88984, 0x1000000},
	/* 1170 */
	{89005, 0x1},
	{89023, 0x2},
	{89042, 0x4},
	{89060, 0x8},
	{89079, 0x10},
	{89097, 0x20},
	{89116, 0x100},
	{89127, 0x200},
	{89137, 0x400},
	{89148, 0x800},
	/* 1180 */
	{89164, 0x1},
	{89180, 0x2},
	{89196, 0x4},
	{89212, 0x8},
	{89228, 0x10},
	{89244, 0x20},
	{89260, 0x40},
	{89276, 0x80},
	{89292, 0x100},
	{89308, 0x200},
	{89324, 0x400},
	{89340, 0x800},
	{89356, 0x1000},
	{89372, 0x2000},
	{89388, 0x4000},
	{89404, 0x8000},
	{89420, 0x10000},
	{89439, 0x20000},
	{89457, 0x40000},
	{89484, 0x80000},
	{89506, 0x100000},
	{89524, 0x200000},
	{89544, 0x400000},
	{89567, 0x800000},
	{89590, 0x1000000},
	{89615, 0x2000000},
	{89635, 0x4000000},
	{89658, 0x8000000},
	/* 1208 */
	{89677, 0x1},
	{89696, 0x2},
	{89714, 0x4},
	{89732, 0x8},
	{89750, 0x10},
	{89768, 0x20},
	{89785, 0x40},
	{89802, 0x80},
	{89823, 0x100},
	{89840, 0x200},
	{89857, 0x400},
	{89873, 0x800},
	{89889, 0x1000},
	{89905, 0x2000},
	{89921, 0x4000},
	{89946, 0x100000},
	/* 1224 */
	{52608, 0x3},
	{89966, 0x4},
	{89985, 0x8},
	{90002, 0x10},
	/* 1228 */
	{90017, 0x1},
	{90041, 0x2},
	{90061, 0x4},
	{90082, 0x8},
	{90107, 0x10},
	{90127, 0x20},
	{90143, 0x40},
	{90160, 0x80},
	{90181, 0xFF00},
	{90202, 0x40000000},
	{90223, 0x80000000},
	/* 1239 */
	{90245, 0x1},
	{90017, 0x2},
	{90041, 0x4},
	{90061, 0x8},
	{90082, 0x10},
	{90270, 0x20},
	{90283, 0x40},
	/* 1246 */
	{90312, 0x1},
	{90323, 0x2},
	/* 1248 */
	{90341, 0x1},
	{90358, 0x2},
	/* 1250 */
	{90382, 0x1},
	{90407, 0x2},
	{90428, 0x4},
	{90450, 0x8},
	{90476, 0x10},
	/* 1255 */
	{90493, 0x1E},
	{90505, 0xE0},
	{90519, 0xF00},
	{90535, 0x70000},
	{90546, 0x780000},
	/* 1260 */
	{75210, 0xFFFF},
	{75103, 0xFFFF0000},
	/* 1262 */
	{90559, 0xFFFF},
	{19297, 0xFFFF0000},
	/* 1264 */
	{75103, 0xFFFF},
	/* 1265 */
	{90568, 0xFFFF},
	{90581, 0xFF0000},
	{90594, 0x10000000},
	{90612, 0x60000000},
	/* 1269 */
	{90628, 0x7},
	/* 1270 */
	{90640, 0x3},
	/* 1271 */
	{18890, 0xFF},
	/* 1272 */
	{18912, 0x1F, 22, 36290},
	{90999, 0x4000},
	{91012, 0x8000},
	{91025, 0x70000},
	/* 1276 */
	{18932, 0xF},
	/* 1277 */
	{18938, 0xF},
	/* 1278 */
	{91036, 0x1},
	{91046, 0x2},
	{91056, 0x4},
	{91066, 0x8},
	{20123, 0xFF00},
	{91076, 0xFF0000},
	/* 1284 */
	{91082, 0xF},
	{14285, 0xF0},
	{91089, 0xF00},
	{79605, 0xF000},
	{91096, 0xF0000},
	{91103, 0xF00000},
	{91112, 0xF000000},
	{12217, 0xF0000000},
	/* 1292 */
	{1398, 0x7, 6, 36312},
	{91192, 0x8},
	{91248, 0x30, 4, 36318},
	{91257, 0x7C0},
	{91268, 0x800},
	{91281, 0x1000},
	{91292, 0x2000},
	{91304, 0x4000},
	{91317, 0x8000},
	{91335, 0x10000},
	{91351, 0x20000},
	{91370, 0x40000},
	{91384, 0x80000},
	{91402, 0x100000},
	{91420, 0x600000},
	/* 1307 */
	{91427, 0x7FF},
	{91447, 0x3FF800},
	{91467, 0xFFC00000},
	/* 1310 */
	{91491, 0x1},
	{91503, 0x2},
	{91524, 0x4},
	{91544, 0x8},
	{91569, 0x10},
	{91590, 0x20},
	{91613, 0x40},
	/* 1317 */
	{91643, 0x1},
	{91653, 0x2},
	{91668, 0x4},
	{91693, 0x8},
	{91711, 0x70},
	{91727, 0x80},
	{91732, 0x100},
	{91755, 0x200},
	{91774, 0x400},
	{91796, 0x800},
	{91812, 0x1000},
	{91828, 0x2000},
	{91844, 0x4000},
	{91863, 0x8000},
	{91889, 0x10000},
	{91904, 0x20000},
	{91944, 0x40000},
	{91971, 0x80000},
	{91994, 0xF00000},
	{92010, 0x1000000},
	{92040, 0x2000000},
	{92064, 0x4000000},
	{92085, 0x8000000},
	{92115, 0x70000000},
	/* 1341 */
	{19137, 0x7FF},
	/* 1342 */
	{19151, 0x7FF},
	/* 1343 */
	{19165, 0xF},
	/* 1344 */
	{879, 0x7FFF},
	/* 1345 */
	{92139, 0x3F, 4, 36322},
	{92152, 0x3F00, 4, 36322},
	{92167, 0x3F0000, 4, 36322},
	{92182, 0xFC00000, 4, 36322},
	{92197, 0x80000000},
	/* 1350 */
	{214, 0x3, 3, 36326},
	{92334, 0xC, 4, 36329},
	{92414, 0x30, 4, 36333},
	{92474, 0xC0, 3, 36337},
	{92487, 0x100},
	{86860, 0x200},
	{92491, 0x400},
	{92500, 0x3800},
	/* 1358 */
	{19340, 0x1},
	{92506, 0x2},
	{92527, 0x4},
	/* 1361 */
	{93710, 0x3F, 64, 36340},
	{68758, 0x7FFFC00},
	{93721, 0x8000000},
	/* 1364 */
	{19437, 0x1},
	{93736, 0x2},
	/* 1366 */
	{93751, 0x1},
	{93765, 0x2},
	{93781, 0x4},
	{93799, 0x8},
	{93815, 0x10},
	/* 1371 */
	{93826, 0xFFFF},
	{93841, 0x10000},
	{93860, 0x20000},
	{93874, 0x40000},
	{93893, 0x80000},
	{93907, 0x100000},
	/* 1377 */
	{19551, 0x7FFF},
	/* 1378 */
	{19587, 0x1},
	/* 1379 */
	{19601, 0x1},
	/* 1380 */
	{79184, 0x1},
	{93924, 0x2},
	{93935, 0x4},
	{93952, 0x8},
	{93969, 0x3F0},
	{93986, 0xFC00},
	{94003, 0x10000},
	{94027, 0x20000},
	{75751, 0x40000},
	/* 1389 */
	{94044, 0x7, 8, 3039},
	{94057, 0xFF0},
	{94071, 0xFF000},
	{77914, 0x1000000},
	/* 1393 */
	{94084, 0x7, 8, 3039},
	{94097, 0xFF0},
	{94111, 0xFF000},
	{77932, 0x1000000},
	/* 1397 */
	{10206, 0xFF},
	{10222, 0xFF00},
	{94124, 0xFF0000},
	{94130, 0xFF000000},
	/* 1401 */
	{20123, 0x3FF},
	/* 1402 */
	{20116, 0x1FF},
	/* 1403 */
	{20137, 0x7FF},
	/* 1404 */
	{94136, 0x1FF},
	{94152, 0x3FE00},
	/* 1406 */
	{94168, 0xFF},
	{94182, 0xFF00},
	{94192, 0xFF0000},
	{94203, 0x1F000000},
	{94215, 0xE0000000},
	/* 1411 */
	{94275, 0x3, 4, 36404},
	{94306, 0x4, 2, 36408},
	{20206, 0x18, 4, 36410},
	{94388, 0x20, 2, 36414},
	{94453, 0xC0, 4, 36416},
	{94459, 0x100},
	{76713, 0x200},
	{94470, 0x400},
	{94490, 0x800},
	{94510, 0x1000},
	{94524, 0x2000},
	{94535, 0x4000},
	{94551, 0x78000},
	{94571, 0x180000},
	{94586, 0x200000},
	{94596, 0x400000},
	{94606, 0x800000},
	{94616, 0x1000000},
	{94631, 0x2000000},
	/* 1430 */
	{94651, 0xFF},
	{94663, 0x3F00},
	{94679, 0xFC000},
	/* 1433 */
	{220, 0x3, 3, 36420},
	{94785, 0x1C, 4, 36423},
	{94862, 0xE0, 4, 36427},
	{94871, 0x100},
	{94891, 0x200},
	{94902, 0x3C00},
	{94924, 0x4000},
	{92474, 0x18000, 3, 36337},
	{94958, 0x60000, 4, 36431},
	{95017, 0x80000, 3, 36435},
	{95069, 0x100000, 3, 36438},
	{92500, 0x3800000},
	/* 1445 */
	{95081, 0x1},
	{95102, 0x300},
	{95124, 0xC00},
	{95146, 0x3000},
	{95168, 0xC000},
	{95190, 0x10000},
	/* 1451 */
	{95203, 0xFF},
	{95231, 0x100},
	/* 1453 */
	{10330, 0x1},
	{20563, 0x1FC},
	{95259, 0x80000000},
	/* 1456 */
	{95291, 0x1},
	{95306, 0x2},
	{95321, 0x4},
	{95336, 0x8},
	{95351, 0x70},
	{95363, 0x80},
	{95383, 0xF00},
	{95400, 0x80000000},
	/* 1464 */
	{95421, 0xF},
	{95440, 0xF0},
	{95459, 0xF00},
	{95478, 0xF000},
	/* 1468 */
	{95497, 0xF},
	{95508, 0xF0},
	{95519, 0xF00},
	{95530, 0xF000},
	{95541, 0xF0000},
	{95552, 0xF00000},
	{95563, 0xF000000},
	{95574, 0xF0000000},
	/* 1476 */
	{95585, 0xF},
	{95596, 0xF0},
	{95607, 0xF00},
	{95619, 0xF000},
	{95631, 0xF0000},
	{95643, 0xF00000},
	{95655, 0xF000000},
	{95667, 0xF0000000},
	/* 1484 */
	{95679, 0x200},
	{95697, 0x400},
	{95708, 0x800},
	{95733, 0x1000},
	{95755, 0x2000},
	/* 1489 */
	{95777, 0x7},
	{95794, 0x10},
	{95816, 0x1E000},
	{95832, 0x700000},
	{95853, 0x3000000},
	{95933, 0xC000000, 4, 36441},
	/* 1495 */
	{95959, 0x1},
	{96020, 0x6, 4, 36445},
	{96236, 0x38, 8, 36449},
	/* 1498 */
	{96247, 0xF},
	{96252, 0xF0},
	{96257, 0xF00},
	{96262, 0xF000},
	{96267, 0xF0000},
	{96272, 0xF00000},
	{96277, 0xF000000},
	{96282, 0xF0000000},
	/* 1506 */
	{96287, 0xF},
	{96292, 0xF0},
	{96297, 0xF00},
	{96302, 0xF000},
	{96307, 0xF0000},
	{96312, 0xF00000},
	{96317, 0xF000000},
	{96322, 0xF0000000},
	/* 1514 */
	{96327, 0xF},
	{96332, 0xF0},
	{96337, 0xF00},
	{96342, 0xF000},
	{96347, 0xF0000},
	{96353, 0xF00000},
	{96359, 0xF000000},
	{96365, 0xF0000000},
	/* 1522 */
	{96371, 0xF},
	{96377, 0xF0},
	{96383, 0xF00},
	{96389, 0xF000},
	{96395, 0xF0000},
	{96401, 0xF00000},
	{96407, 0xF000000},
	{96413, 0xF0000000},
	/* 1530 */
	{96419, 0xFFFF},
	{96432, 0xFFFF0000},
	/* 1532 */
	{96445, 0xFFFF},
	{96458, 0xFFFF0000},
	/* 1534 */
	{96471, 0x3},
	{76178, 0x4},
	{76200, 0x8},
	{96500, 0x60},
	/* 1538 */
	{96613, 0x3, 4, 36457},
	{96626, 0x4},
	{96637, 0x8},
	{96746, 0x70, 5, 36461},
	{96764, 0x380, 5, 36461},
	{96782, 0x1C00},
	{96805, 0x3E000},
	{96831, 0x40000},
	{96853, 0x7F80000},
	{96869, 0x8000000},
	{96891, 0x10000000},
	{96978, 0x60000000, 3, 36466},
	/* 1550 */
	{96995, 0xFFFF},
	{97011, 0xFFFF0000},
	/* 1552 */
	{97030, 0x1},
	{97047, 0x1E},
	{97071, 0x20},
	{97089, 0x3C0},
	{97114, 0x400},
	{97144, 0x800},
	{97159, 0x1000},
	{97174, 0x2000},
	{97209, 0x4000},
	{97245, 0x8000},
	{97335, 0x30000, 3, 36469},
	{97359, 0x40000},
	{97395, 0x80000},
	{97431, 0x100000},
	{97457, 0x200000},
	{97481, 0x400000},
	{97501, 0x800000},
	{97522, 0x1000000},
	{97547, 0x6000000},
	{97571, 0x18000000},
	/* 1572 */
	{97599, 0x7FF},
	{97620, 0xFF0000},
	/* 1574 */
	{97638, 0xFF},
	/* 1575 */
	{97654, 0x7F},
	/* 1576 */
	{97667, 0x7FF},
	{97676, 0x7FF00000},
	/* 1578 */
	{97667, 0x3FFFFF},
	/* 1579 */
	{77749, 0x1FFF},
	{77776, 0x3FFE000},
	{97691, 0x3C000000},
	/* 1582 */
	{97752, 0x3, 4, 36472},
	{17750, 0x7C, 32, 36476},
	{73846, 0x80},
	{98350, 0x700, 8, 36508},
	{98406, 0x1800, 4, 36516},
	{87468, 0x2000},
	{78369, 0x4000},
	{98416, 0x8000},
	{98428, 0x10000},
	{98441, 0x20000},
	{96020, 0x40000},
	{98454, 0x80000},
	{98681, 0x700000, 8, 36520},
	{98703, 0x3800000, 8, 36520},
	{98727, 0x4000000},
	{98753, 0x8000000},
	{98779, 0x10000000},
	{98847, 0x60000000, 3, 36528},
	{98863, 0x80000000},
	/* 1601 */
	{98877, 0x1F},
	{98893, 0x3E0},
	{98915, 0xC00},
	{79081, 0x7000},
	{98933, 0x18000},
	{98947, 0x20000},
	{98965, 0x40000},
	{98991, 0x80000},
	/* 1609 */
	{82409, 0x1},
	{99021, 0x2},
	{75692, 0xC, 3, 36531},
	{99135, 0x10, 2, 36534},
	{75720, 0x60},
	{75817, 0x180},
	{99161, 0x200},
	{99184, 0x3C00},
	{99204, 0x3C000},
	{82525, 0x40000},
	{99226, 0x80000},
	{99259, 0x100000},
	/* 1621 */
	{97667, 0x3FFF},
	/* 1622 */
	{99283, 0xFF},
	/* 1623 */
	{99293, 0x3FFF},
	{99305, 0xFFFC000},
	{75592, 0xF0000000},
	/* 1626 */
	{99316, 0x1FFF},
	{99327, 0x2000},
	{99339, 0x7C000},
	{99353, 0xF80000},
	{99367, 0x3000000},
	{99381, 0x4000000},
	{73093, 0x38000000},
	{99400, 0x40000000},
	/* 1634 */
	{10413, 0xFFFFFFFC},
	/* 1635 */
	{10442, 0xFFFF},
	/* 1636 */
	{24776, 0xFFFFFFFC},
	/* 1637 */
	{24798, 0xFFFF},
	/* 1638 */
	{25292, 0xFFFFFFFC},
	/* 1639 */
	{25314, 0xFFFF},
	/* 1640 */
	{99417, 0xFFFFFFC},
	/* 1641 */
	{99433, 0x6000000},
	/* 1642 */
	{99446, 0x1},
	/* 1643 */
	{99465, 0xFF},
	{99479, 0x30000},
	/* 1645 */
	{99493, 0xFFFFFFFC},
	/* 1646 */
	{99505, 0xFFFF},
	{99517, 0x10000},
	{99433, 0x6000000},
	{27101, 0xE0000000},
	/* 1650 */
	{26651, 0xFFFFFFFC},
	/* 1651 */
	{26669, 0xFFFF},
	{99433, 0xC00000},
	/* 1653 */
	{26723, 0xFFFFFFFC},
	/* 1654 */
	{26741, 0xFFFF},
	{99433, 0xC00000},
	/* 1656 */
	{99527, 0x3},
	{26781, 0xFFFFFFF8},
	/* 1658 */
	{26800, 0xFFFF},
	{99541, 0x10000},
	{99557, 0x100000},
	{99573, 0x3000000},
	{99589, 0xE0000000},
	/* 1663 */
	{99600, 0x400},
	{99613, 0x6000},
	{99630, 0x8000},
	{99642, 0x300000},
	{99653, 0x6000000},
	{99670, 0x8000000},
	{99682, 0x60000000},
	/* 1670 */
	{99693, 0xFF},
	/* 1671 */
	{99712, 0x3F},
	/* 1672 */
	{99730, 0x8},
	{99747, 0x10},
	{99764, 0x20},
	{99791, 0x8000},
	{99811, 0x40000},
	{99828, 0x400000},
	{99844, 0x800000},
	{99858, 0x2000000},
	{99872, 0x4000000},
	{99886, 0x8000000},
	{99907, 0x10000000},
	{99932, 0x20000000},
	{99953, 0x40000000},
	/* 1685 */
	{99977, 0x3000000},
	{1411, 0x80000000},
	/* 1687 */
	{27038, 0xFFFF},
	/* 1688 */
	{27079, 0xFFFF},
	/* 1689 */
	{99982, 0x3FFFFFF},
	{99993, 0x4000000},
	{99997, 0x8000000},
	{100001, 0x10000000},
	{100006, 0x20000000},
	{100011, 0x40000000},
	{100020, 0x80000000},
	/* 1696 */
	{100027, 0x1},
	{100047, 0x2},
	{100061, 0x30},
	{100073, 0x1FF0000},
	{100086, 0x10000000},
	{100101, 0x20000000},
	{100115, 0xC0000000},
	/* 1703 */
	{100125, 0x3FFFFFF},
	{100138, 0x10000000},
	/* 1705 */
	{100157, 0xFF},
	/* 1706 */
	{100176, 0xFF},
	/* 1707 */
	{100182, 0x1},
	{100196, 0x2},
	{100208, 0x10000},
	{100222, 0x1000000},
	/* 1711 */
	{2288, 0xFF},
	{67663, 0x80000000},
	/* 1713 */
	{27334, 0xFFFFF},
	/* 1714 */
	{27347, 0xFFFFF},
	/* 1715 */
	{27361, 0xFFFFF},
	/* 1716 */
	{27375, 0xFFFFF},
	/* 1717 */
	{27397, 0xFFFFF},
	/* 1718 */
	{27417, 0xFFFFF},
	/* 1719 */
	{27439, 0xFFFFF},
	/* 1720 */
	{100235, 0x3},
	{10413, 0xFFFFFFFC},
	/* 1722 */
	{10442, 0xFFFF},
	{100235, 0xFFFF0000},
	/* 1724 */
	{100240, 0xFFF},
	/* 1725 */
	{100255, 0xFFFFF},
	/* 1726 */
	{100269, 0xFFFFF},
	/* 1727 */
	{100283, 0xFFFFF},
	/* 1728 */
	{27755, 0xFFFFFFE0},
	/* 1729 */
	{27774, 0xFFFF},
	/* 1730 */
	{27793, 0xFFF},
	/* 1731 */
	{27810, 0xFFFFFFFC},
	/* 1732 */
	{27828, 0xFFFF},
	/* 1733 */
	{27846, 0xFFFFF},
	/* 1734 */
	{27862, 0xFFFFFFFC},
	/* 1735 */
	{27880, 0xFFFF},
	/* 1736 */
	{27898, 0xFFFFF},
	/* 1737 */
	{27997, 0xFFFFFFFC},
	/* 1738 */
	{28011, 0xFFFF},
	/* 1739 */
	{28025, 0xFFFFF},
	/* 1740 */
	{43360, 0xFFF000},
	{99433, 0x6000000},
	{100296, 0x8000000},
	{100309, 0x10000000},
	/* 1744 */
	{100317, 0x30000},
	{100325, 0x7000000},
	{100333, 0xE0000000},
	/* 1747 */
	{28091, 0xFFFFFFF},
	/* 1748 */
	{28102, 0xFFFFFFFC},
	/* 1749 */
	{28116, 0xFFFF},
	/* 1750 */
	{28130, 0xFFFFF},
	/* 1751 */
	{100342, 0xFFFFF},
	/* 1752 */
	{1411, 0x3},
	/* 1753 */
	{28280, 0x1},
	/* 1754 */
	{100355, 0x1},
	{100369, 0x2},
	{100386, 0x4},
	{100402, 0x8},
	{100417, 0x10},
	{100436, 0x20},
	{100454, 0x40},
	{100475, 0x80},
	/* 1762 */
	{100496, 0x1},
	{100512, 0x2},
	{100528, 0x40},
	{100546, 0x80},
	{100564, 0x100},
	{100582, 0x200},
	{100600, 0x400},
	{100618, 0x800},
	{100636, 0x1000},
	{100654, 0x2000},
	{100672, 0x4000},
	{100689, 0x80000},
	{100705, 0x200000},
	/* 1775 */
	{100721, 0xFF},
	{1411, 0x80000000},
	/* 1777 */
	{100739, 0xF},
	{100751, 0xF0},
	{100760, 0xF00},
	{100769, 0xF000},
	{100779, 0x30000},
	{100789, 0xC0000},
	{10330, 0x100000},
	{10813, 0xFFE00000},
	/* 1785 */
	{100796, 0xFF},
	{100760, 0xFF00},
	{100751, 0xFF0000},
	{100811, 0x20000000},
	{100831, 0x40000000},
	{100857, 0x80000000},
	/* 1791 */
	{18912, 0x3F, 22, 36290},
	/* 1792 */
	{38, 0xFFFF},
	/* 1793 */
	{100877, 0x1FF},
	{100943, 0x600, 4, 36536},
	/* 1795 */
	{93826, 0xFFFF},
	{93841, 0x10000},
	{93860, 0x20000},
	{93874, 0x40000},
	{93893, 0x80000},
	{93907, 0x100000},
	{100963, 0x200000},
	{100981, 0x400000},
	{100997, 0x800000},
	/* 1804 */
	{101009, 0x1FF},
	{101023, 0x3FE00},
	{101037, 0x40000},
	{101055, 0x80000},
	/* 1808 */
	{101072, 0x7},
	{101081, 0x78},
	{101090, 0x100},
	/* 1811 */
	{101100, 0x1},
	{101111, 0x7FE},
	/* 1813 */
	{101124, 0x1},
	{101138, 0x2},
	{101152, 0x4},
	/* 1816 */
	{29443, 0xFFFFFF},
	/* 1817 */
	{101166, 0xF},
	{101178, 0xFF00},
	/* 1819 */
	{456, 0xFFFF},
	{102, 0xFFFF0000},
	/* 1821 */
	{101192, 0x1},
	{101213, 0x2},
	/* 1823 */
	{101241, 0x3FFF},
	/* 1824 */
	{101249, 0x3FFF},
	/* 1825 */
	{2275, 0xFFFF},
	/* 1826 */
	{101257, 0x1},
	{101269, 0x2},
	{101281, 0x4},
	{30218, 0x8},
	{76993, 0x10},
	{30643, 0x10000},
	{101292, 0x60000},
	/* 1833 */
	{101305, 0x1},
	{78300, 0x2},
	/* 1835 */
	{25370, 0x7FFFFFFF},
	/* 1836 */
	{101309, 0x3F},
	{101314, 0xC0},
	{101322, 0x300},
	{101328, 0xFFFFFC00},
	/* 1840 */
	{30643, 0x1},
	{100789, 0xFFFFFFFE},
	/* 1842 */
	{8, 0xFFFF},
	{100789, 0xFFFF0000},
	/* 1844 */
	{38, 0xFFFF},
	{100789, 0xFFFF0000},
	/* 1846 */
	{30721, 0xFF},
	{100789, 0xFFFFFF00},
	/* 1848 */
	{30738, 0xFF},
	{100789, 0xFFFFFF00},
	/* 1850 */
	{1, 0xFF},
	{100789, 0xFFFFFF00},
	/* 1852 */
	{452, 0x3F},
	{100789, 0xFFFFFFC0},
	/* 1854 */
	{89452, 0x1},
	{983, 0x1FFE},
	{220, 0x2000},
	{97314, 0x4000},
	{101336, 0x8000},
	{101348, 0x7FF0000},
	{101359, 0x8000000},
	{101370, 0x10000000},
	{101380, 0x20000000},
	{101314, 0xC0000000},
	/* 1864 */
	{30942, 0xFFFF},
	{100789, 0xFFFF0000},
	/* 1866 */
	{452, 0xF},
	{100789, 0xFFFFFFF0},
	/* 1868 */
	{101387, 0xFFFF},
	{101398, 0xF0000},
	{101411, 0xF00000},
	{100789, 0x3F000000},
	{101419, 0x40000000},
	{10330, 0x80000000},
	/* 1874 */
	{29456, 0x7FFFFFFF},
	{31004, 0x80000000},
	/* 1876 */
	{31550, 0xFFFF},
	/* 1877 */
	{31554, 0xFFFF},
	{101428, 0xFFFF0000},
	/* 1879 */
	{101442, 0x3FF},
	{101451, 0xFFC00},
	{50481, 0xF00000},
	{101461, 0xF000000},
	{101472, 0xF0000000},
	/* 1884 */
	{101483, 0x3FF},
	{101493, 0xFFC00},
	{101503, 0xF000000},
	{101514, 0xF0000000},
	/* 1888 */
	{101734, 0xF, 6, 36540},
	{101969, 0xF0, 6, 36546},
	{102142, 0x300, 4, 36552},
	{102162, 0x400},
	/* 1892 */
	{452, 0x7},
	{78779, 0x40000000},
	{10330, 0x80000000},
	/* 1895 */
	{452, 0x1F},
	{78779, 0x40000000},
	{10330, 0x80000000},
	/* 1898 */
	{452, 0xF},
	{11680, 0x40000000},
	{10330, 0x80000000},
	/* 1901 */
	{452, 0x1F},
	{11680, 0x40000000},
	{10330, 0x80000000},
	/* 1904 */
	{11645, 0xFFFF},
	{11665, 0xFFFF0000},
	/* 1906 */
	{102184, 0x1},
	{102211, 0x2},
	{102238, 0x4},
	{1398, 0x100},
	/* 1910 */
	{101442, 0x3F},
	{102261, 0x400},
	{102288, 0x800},
	{102315, 0x2000},
	{102341, 0x4000},
	{102367, 0x10000},
	{102394, 0x20000},
	{102420, 0x40000},
	{102446, 0x80000},
	{102474, 0x100000},
	{102500, 0x200000},
	{102526, 0x400000},
	{102552, 0x1000000},
	{102579, 0x2000000},
	{102606, 0x4000000},
	{102633, 0x8000000},
	{102660, 0x10000000},
	{102686, 0x20000000},
	{102715, 0x40000000},
	{102741, 0x80000000},
	/* 1930 */
	{101442, 0x3F},
	{102261, 0x400},
	{102288, 0x800},
	{102315, 0x1000},
	{102341, 0x2000},
	{102367, 0x8000},
	{102394, 0x10000},
	{102474, 0x20000},
	{102500, 0x40000},
	{102420, 0x100000},
	{102579, 0x200000},
	{102741, 0x400000},
	{102768, 0x800000},
	{102633, 0x1000000},
	{102797, 0x2000000},
	/* 1945 */
	{102768, 0x2},
	{102826, 0x4},
	{102855, 0x8},
	{102883, 0x10},
	{102909, 0x20},
	{102935, 0x40},
	{102962, 0x80},
	{102797, 0x100},
	/* 1953 */
	{102989, 0x3FF},
	{101451, 0xFFC00},
	{102999, 0xF00000},
	{103009, 0xF000000},
	{103020, 0xF0000000},
	/* 1958 */
	{101483, 0x3FF},
	{101493, 0xFFC00},
	{103031, 0xF000000},
	{103042, 0xF0000000},
	/* 1962 */
	{102989, 0x3FF},
	{103053, 0xF0000000},
	/* 1964 */
	{101442, 0x3FF},
	{101451, 0xFFC00},
	{102999, 0xF00000},
	{103020, 0xF000000},
	{103053, 0xF0000000},
	/* 1969 */
	{101483, 0x3FF},
	{101493, 0xFFC00},
	{103042, 0xF000000},
	{103031, 0xF0000000},
	/* 1973 */
	{103063, 0xF},
	{103072, 0xF0},
	{103081, 0xF00},
	{103090, 0xF000},
	{103099, 0xF0000},
	{103108, 0xF00000},
	{103117, 0xF000000},
	{103126, 0xF0000000},
	/* 1981 */
	{101442, 0x1FF},
	{103135, 0xF000},
	{50481, 0xF00000},
	{103053, 0xF0000000},
	/* 1985 */
	{64283, 0x1},
	{94453, 0x2, 4, 36416},
	{94388, 0x4, 2, 36414},
	{20206, 0x8, 4, 36410},
	{94306, 0x10, 2, 36408},
	{94275, 0x20, 4, 36404},
	{103149, 0x40},
	{103155, 0x300},
	{103165, 0x2000},
	/* 1994 */
	{103179, 0x1},
	/* 1995 */
	{103188, 0x3},
	{103202, 0xC},
	{103216, 0x30},
	{103230, 0xC0},
	{103244, 0xF00},
	{103259, 0xF000},
	{103274, 0xF0000},
	{103289, 0xF00000},
	/* 2003 */
	{37295, 0x3FF},
	{103304, 0xFFC00},
	{102999, 0xF00000},
	/* 2006 */
	{103324, 0x3FF},
	{103344, 0xFFC00},
	/* 2008 */
	{101442, 0xFF},
	{101451, 0x3FC00},
	{102999, 0xF00000},
	{103020, 0xF000000},
	{103053, 0xF0000000},
	/* 2013 */
	{101483, 0xFF},
	{101493, 0x3FC00},
	{103042, 0xF000000},
	{103031, 0xF0000000},
	/* 2017 */
	{101442, 0xFF},
	{102999, 0xF00000},
	{103053, 0xF0000000},
	/* 2020 */
	{101442, 0x3FF},
	{102999, 0xF00000},
	{103053, 0xF0000000},
	/* 2023 */
	{103364, 0x1},
	{103599, 0xE, 6, 36556},
	{103613, 0x10},
	{103634, 0x3E0},
	{103652, 0x400},
	{103737, 0x800, 2, 36562},
	{103754, 0x1000},
	{103772, 0xE000},
	{103787, 0x20000},
	{103813, 0x1C0000},
	{103836, 0x200000},
	{103864, 0xC00000},
	/* 2035 */
	{101442, 0x1FF},
	{101451, 0x7FC00},
	{102999, 0xF00000},
	{103020, 0xF000000},
	{103053, 0xF0000000},
	/* 2040 */
	{101483, 0x1FF},
	{101493, 0x7FC00},
	{103042, 0xF000000},
	{103031, 0xF0000000},
	/* 2044 */
	{101442, 0x1FF},
	{103053, 0xF0000000},
	/* 2046 */
	{74256, 0xFFF},
	{103889, 0x3000},
	{10813, 0xC000},
	{103907, 0xFFFF0000},
	/* 2050 */
	{40597, 0xFFFF},
	{10813, 0xFFFF0000},
	/* 2052 */
	{40644, 0xFF},
	{74256, 0x700},
	{103931, 0xF800},
	{103947, 0x1F0000},
	{103960, 0x3E00000},
	{103973, 0x7C000000},
	{10813, 0x80000000},
	/* 2059 */
	{103986, 0xFF},
	{10813, 0xFFFFFF00},
	/* 2061 */
	{104008, 0x1FF},
	{10813, 0xFFFFFE00},
	/* 2063 */
	{104008, 0xFF},
	{10813, 0xFFFFFF00},
	/* 2065 */
	{40818, 0x7F},
	{10813, 0xFFFFFF80},
	/* 2067 */
	{40843, 0x7F},
	{10813, 0xFFFFFF80},
	/* 2069 */
	{40871, 0x7F},
	{10813, 0xFFFFFF80},
	/* 2071 */
	{40899, 0x7F},
	{10813, 0xFFFFFF80},
	/* 2073 */
	{40922, 0x7F},
	{10813, 0xFFFFFF80},
	/* 2075 */
	{104025, 0x7F},
	{10813, 0xFFFFFF80},
	/* 2077 */
	{10813, 0x1F},
	{104030, 0xFFFFFFE0},
	/* 2079 */
	{104049, 0x7F},
	{10813, 0xFFFFFF80},
	/* 2081 */
	{104049, 0x1FF},
	{10813, 0xFFFFFE00},
	/* 2083 */
	{104025, 0xFF},
	{10813, 0xFFFFFF00},
	/* 2085 */
	{104054, 0xFF},
	{104075, 0x100},
	{104085, 0x200},
	{104093, 0x400},
	{104107, 0x800},
	{104118, 0x1000},
	{104137, 0x2000},
	{104161, 0x4000},
	{104175, 0x8000},
	{10813, 0xFFFF0000},
	/* 2095 */
	{104185, 0x1},
	{104209, 0x2},
	{104233, 0x4},
	{104250, 0x8},
	{104267, 0x10},
	{104286, 0x20},
	{104303, 0x3C0},
	{10813, 0xFFFFFC00},
	/* 2103 */
	{104318, 0x1},
	{104330, 0x2},
	{104342, 0x4},
	{104352, 0x8},
	{104373, 0x10},
	{104390, 0x20},
	{104407, 0x40},
	{10813, 0xFFFFFF80},
	/* 2111 */
	{104431, 0xFFFF},
	{10813, 0xFFFF0000},
	/* 2113 */
	{104441, 0xFF},
	{10813, 0xFFFFFF00},
	/* 2115 */
	{104458, 0x7FFFF},
	{10813, 0xFFF80000},
	/* 2117 */
	{103947, 0xFF},
	{103960, 0xFF00},
	{103973, 0xFF0000},
	{104473, 0xFF000000},
	/* 2121 */
	{40644, 0xFF},
	{103931, 0xFF00},
	{10813, 0xFFFF0000},
	/* 2124 */
	{104486, 0x1},
	/* 2125 */
	{104510, 0x1},
	/* 2126 */
	{101734, 0x7, 6, 36540},
	{102162, 0x400},
	/* 2128 */
	{37295, 0xFF},
	/* 2129 */
	{10330, 0x1},
	{104528, 0x2},
	{19393, 0x4},
	{10813, 0xFFFFFFF8},
	/* 2133 */
	{75921, 0xF},
	{104540, 0x30},
	{10813, 0xFFFFFFC0},
	/* 2136 */
	{104547, 0x1},
	/* 2137 */
	{104567, 0x3},
	{104591, 0xC},
	{104615, 0x30},
	{104630, 0xC0},
	{104654, 0x300},
	{104678, 0x3C00},
	{104695, 0x7C000},
	{104713, 0x1F80000},
	{104749, 0x2000000},
	{104765, 0x4000000},
	/* 2147 */
	{101442, 0xFF},
	{104783, 0xFF00},
	{103053, 0xF000000},
	{10330, 0x10000000},
	{11680, 0x20000000},
	/* 2152 */
	{104796, 0xF},
	{104816, 0xFF00},
	{104830, 0xFF0000},
	{104843, 0x1000000},
	{104854, 0x2000000},
	{104864, 0x4000000},
	/* 2158 */
	{101442, 0x1FF},
	{103053, 0xF000000},
	{104885, 0xF0000000},
	/* 2161 */
	{101442, 0x3FF},
	{104895, 0xF0000000},
	/* 2163 */
	{100317, 0xF00, 6, 36564},
	{104947, 0x10000},
	{104959, 0x100000},
	{104974, 0xC0000000, 4, 36570},
	/* 2167 */
	{104985, 0xFFFFF},
	{104993, 0x100000},
	{104999, 0x200000},
	{63515, 0x800000},
	/* 2171 */
	{43348, 0xFFFFFFFF},
	/* 2172 */
	{27038, 0xFFFF},
	{100317, 0x300000, 4, 36574},
	{105022, 0x8000000, 2, 36570},
	{105044, 0x60000000, 4, 36578},
	{105052, 0x80000000},
	/* 2177 */
	{43232, 0xFFFFFFFF},
	/* 2178 */
	{99982, 0x3FFFFFF},
	{99993, 0x4000000, 2, 36582},
	{99997, 0x8000000, 2, 36582},
	{100001, 0x10000000, 2, 36584},
	{100006, 0x20000000, 2, 36584},
	{100011, 0x40000000},
	{105090, 0x80000000},
	/* 2185 */
	{93710, 0x3F},
	{105109, 0xF00},
	{105121, 0x1000},
	{105128, 0x2000},
	{105136, 0x4000},
	{105144, 0x8000},
	{105152, 0x10000},
	{105175, 0x60000, 4, 36586},
	{105200, 0x80000},
	{105212, 0x100000},
	{105220, 0x200000},
	{105264, 0xC00000, 3, 36590},
	/* 2197 */
	{105022, 0x1, 2, 36570},
	{99613, 0x6000},
	{100317, 0x300000, 4, 36574},
	{99653, 0x6000000},
	{105044, 0x60000000, 4, 36578},
	{105052, 0x80000000},
	/* 2203 */
	{105309, 0x3, 4, 36593},
	{105325, 0xC, 4, 36597},
	{105121, 0x10},
	{105128, 0x20},
	{105350, 0x40},
	{105357, 0x80},
	{105136, 0x100},
	{105144, 0x200},
	{105152, 0x400},
	{105175, 0x1800, 4, 36586},
	{105200, 0x2000},
	{105212, 0x4000},
	{105220, 0x8000},
	{105264, 0x30000, 3, 36590},
	{105365, 0x40000},
	/* 2218 */
	{105377, 0xFFFFF},
	/* 2219 */
	{63820, 0x1FF, 257, 0},
	{63825, 0x400},
	{63833, 0x800},
	{63846, 0x7000},
	{63854, 0x8000},
	{63865, 0xF0000},
	{63876, 0xF00000},
	{63892, 0x1000000},
	{105387, 0x10000000},
	{63918, 0xE0000000},
	/* 2229 */
	{64077, 0xF},
	{64084, 0x70},
	{64092, 0x80},
	{64106, 0xF00},
	{64115, 0x7000},
	{64142, 0xC00000},
	{64152, 0x1000000},
	{64178, 0xFC000000},
	/* 2237 */
	{43422, 0xFFFFF},
	/* 2238 */
	{64385, 0xF},
	{64408, 0x10},
	{64431, 0x20},
	{64454, 0x40},
	{64474, 0x80},
	{64494, 0x100},
	{64514, 0x200},
	{64534, 0x400},
	{64554, 0x800},
	{64574, 0x1000},
	{64594, 0x2000},
	{64614, 0x4000},
	{64629, 0x8000},
	{64640, 0x10000},
	{64648, 0x20000},
	{64657, 0x40000},
	{105397, 0x80000},
	{64689, 0x100000},
	{64702, 0x200000},
	{64712, 0x400000},
	{64729, 0x800000},
	{105417, 0x1000000},
	{105434, 0x2000000},
	{64746, 0x4000000},
	{64755, 0x8000000},
	{64764, 0x10000000},
	{64773, 0x20000000},
	{64782, 0x40000000},
	{64791, 0x80000000},
	/* 2267 */
	{64802, 0xF},
	{64841, 0x80},
	{64864, 0x100},
	{64887, 0x200},
	{64906, 0x1000},
	{64915, 0x2000},
	{64924, 0x4000},
	{64932, 0x8000},
	{64941, 0x10000},
	{64956, 0x100000},
	{64964, 0x200000},
	{64972, 0x400000},
	{64981, 0x800000},
	{64990, 0x1000000},
	{64998, 0x2000000},
	{65006, 0x4000000},
	{65014, 0x10000000},
	{64756, 0x20000000},
	{65032, 0x40000000},
	{65040, 0x80000000},
	/* 2287 */
	{43436, 0xFFFF},
	/* 2288 */
	{68196, 0x7FF, 2049, 257},
	{105451, 0x1000},
	{68358, 0xFF0000, 129, 2306},
	{68370, 0x3000000},
	{105476, 0x1C000000},
	{68383, 0x80000000},
	/* 2294 */
	{1398, 0x3},
	{68398, 0x4},
	{68407, 0x8},
	{68418, 0x10},
	{68431, 0x20},
	{58316, 0x1C0},
	{68445, 0x200},
	{68458, 0x400},
	{68471, 0x800},
	{68483, 0x1000},
	{68501, 0x2000},
	{68512, 0xC000},
	{68527, 0x30000},
	{68535, 0x40000},
	{68554, 0x80000},
	{105488, 0x700000},
	{105503, 0x10000000},
	{105526, 0x20000000},
	{68571, 0x40000000},
	{68583, 0x80000000},
	/* 2314 */
	{68597, 0xFFF},
	{68612, 0xFFF000},
	{68624, 0x1000000},
	{64635, 0x2000000},
	{68632, 0x4000000},
	{68652, 0x8000000},
	{105542, 0xF0000000},
	/* 2321 */
	{105553, 0x1},
	{105563, 0x2},
	{105573, 0x10},
	/* 2324 */
	{68798, 0x7},
	{68808, 0x38},
	{68818, 0x1C0},
	{68828, 0xE00},
	{17750, 0x7F000, 293, 2468},
	{73065, 0x600000},
	{73078, 0x800000},
	{73093, 0x1000000},
	{105601, 0xC000000},
	{73199, 0x30000000, 4, 2761},
	{220, 0xC0000000},
	/* 2335 */
	{73585, 0x1FFFFF},
	{73604, 0xE00000},
	{73623, 0x1000000},
	{73645, 0x2000000},
	{105613, 0x4000000},
	{73683, 0x8000000},
	{73700, 0x10000000},
	{73718, 0x20000000},
	{73734, 0xC0000000},
	/* 2344 */
	{73755, 0x7},
	{73765, 0x38},
	{73786, 0xC0},
	{105636, 0x700},
	{73807, 0x180000},
	{73826, 0xC000000},
	/* 2350 */
	{18896, 0x1FFF},
	{105645, 0x2000},
	{75569, 0x1FFF0000},
	/* 2353 */
	{75580, 0xF},
	{75592, 0xF0},
	{75600, 0xFFF00},
	{75613, 0x700000},
	{75622, 0x800000},
	{75637, 0x2000000},
	{75652, 0x4000000},
	{79544, 0x80000000},
	/* 2361 */
	{75664, 0xFF},
	{105601, 0x300},
	{75680, 0x400},
	{75692, 0x18000},
	{75720, 0x60000},
	{75746, 0x80000},
	{75764, 0x100000},
	{75786, 0x200000},
	{75801, 0x400000},
	{75817, 0x800000},
	{75833, 0xFF000000},
	/* 2372 */
	{75971, 0x3F},
	{75977, 0x3C0},
	{73595, 0xC00},
	{76067, 0xFF000, 193, 2834},
	{51265, 0x100000},
	{63485, 0x200000},
	{76078, 0x800000},
	{76088, 0x1000000},
	{76105, 0x2000000},
	{64355, 0x4000000},
	{105655, 0x8000000},
	{63636, 0x20000000},
	/* 2384 */
	{77360, 0x1},
	{77379, 0x2},
	{77400, 0x4},
	{77411, 0x8},
	{77424, 0x10},
	{77443, 0x20},
	{77468, 0x40},
	{77491, 0x80},
	{77505, 0xF00},
	{77517, 0x1000},
	{105674, 0x2000},
	/* 2395 */
	{78434, 0x3, 4, 3035},
	{78463, 0x1C},
	{78494, 0x20},
	{78530, 0x40},
	{78565, 0x80},
	{78593, 0x100},
	{78615, 0x200},
	{78633, 0x400},
	{78665, 0x800},
	{78786, 0x7000, 8, 3039},
	{78796, 0x38000},
	{78809, 0x1C0000},
	{78822, 0x200000},
	{78838, 0x400000},
	{78856, 0x800000},
	{78874, 0x2000000},
	{105692, 0x4000000},
	{105712, 0x18000000},
	/* 2413 */
	{105858, 0x7, 5, 36601},
	{105890, 0x30},
	{105910, 0xC0},
	/* 2416 */
	{79392, 0x3, 4, 3061},
	{79404, 0xC, 4, 3061},
	{79416, 0x30, 4, 3061},
	{79432, 0xC0, 4, 3061},
	{79502, 0x30000, 4, 3065},
	{79514, 0xC0000, 4, 3065},
	{79526, 0x300000, 4, 3065},
	{79542, 0x1000000},
	{79553, 0x2000000},
	{105930, 0x4000000},
	{105940, 0x8000000},
	{105950, 0x10000000},
	{105964, 0x20000000},
	/* 2429 */
	{10330, 0x1},
	{82085, 0x6},
	{73826, 0x60},
	{82127, 0x3000},
	{82134, 0x30000},
	{82148, 0x300000},
	/* 2435 */
	{82255, 0x3, 4, 3061},
	{82271, 0xC, 4, 3061},
	{82287, 0x30, 4, 3061},
	{82301, 0xC0, 4, 3061},
	{82317, 0x30000, 4, 3065},
	{82333, 0xC0000, 4, 3065},
	{82349, 0x300000, 4, 3065},
	{82363, 0xC00000, 4, 3065},
	{105979, 0x1000000},
	{105995, 0x2000000},
	{106011, 0x4000000},
	{106025, 0x8000000},
	{82379, 0x40000000},
	{82394, 0x80000000},
	/* 2449 */
	{879, 0x3F},
	{83164, 0x300},
	{83176, 0x400},
	{106041, 0x800},
	{83187, 0x1E000},
	{83196, 0x20000},
	{83210, 0x40000},
	{83214, 0x80000},
	{83231, 0x100000},
	{83249, 0x600000},
	{83267, 0x800000},
	{83287, 0x1000000},
	{83299, 0x2000000},
	/* 2462 */
	{879, 0x3F},
	{83164, 0x300},
	{83176, 0x400},
	{106041, 0x800},
	{83210, 0x40000},
	{83214, 0x80000},
	{83231, 0x100000},
	{83249, 0x600000},
	{83287, 0x1000000},
	{83299, 0x2000000},
	/* 2472 */
	{83311, 0x3E},
	{83327, 0x40},
	{83340, 0x80},
	{106055, 0x1F00},
	/* 2476 */
	{83861, 0x3F},
	{83882, 0x80},
	{83899, 0x100},
	{106073, 0x3E00},
	{83915, 0x4000},
	{83935, 0x8000},
	/* 2482 */
	{106089, 0x1},
	{106114, 0x2},
	{106139, 0x4},
	{106164, 0x8},
	{106189, 0x10},
	{106214, 0x20},
	{106239, 0x40},
	{106264, 0x80},
	/* 2490 */
	{84881, 0xF, 12, 36606},
	{84886, 0xF0, 12, 36606},
	{84891, 0xF00, 12, 36606},
	{84896, 0xF000, 12, 36606},
	{84901, 0xF0000, 12, 36606},
	{84906, 0xF00000, 12, 36606},
	{84911, 0xF000000, 12, 36606},
	{84916, 0xF0000000, 12, 36606},
	/* 2498 */
	{86788, 0x3, 4, 36007},
	{86834, 0xC, 2, 36011},
	{86845, 0x10},
	{86860, 0x20},
	{86868, 0x40},
	{86910, 0xE0000000},
	/* 2504 */
	{87401, 0x1},
	{106311, 0x2},
	{87419, 0x8},
	{1398, 0x70, 8, 36013},
	{86692, 0xFF0000, 256, 36021},
	/* 2509 */
	{89164, 0x1},
	{89180, 0x2},
	{89196, 0x4},
	{89212, 0x8},
	{89228, 0x10},
	{89244, 0x20},
	{89260, 0x40},
	{89276, 0x80},
	{89292, 0x100},
	{89308, 0x200},
	{89324, 0x400},
	{89340, 0x800},
	{89356, 0x1000},
	{89372, 0x2000},
	{89388, 0x4000},
	{89404, 0x8000},
	{89420, 0x10000},
	{89439, 0x20000},
	{89457, 0x40000},
	{89484, 0x80000},
	{89506, 0x100000},
	{89524, 0x200000},
	{89544, 0x400000},
	{89567, 0x800000},
	{89590, 0x1000000},
	{89615, 0x2000000},
	{89658, 0x8000000},
	{106334, 0x10000000},
	{106351, 0x20000000},
	{106376, 0x40000000},
	/* 2539 */
	{90341, 0x1},
	{90358, 0x2},
	{106402, 0x3FC},
	/* 2542 */
	{106421, 0x7, 5, 36601},
	{106447, 0x38, 5, 36601},
	{106476, 0x1C0, 5, 36601},
	{106501, 0xE00, 5, 36601},
	{106527, 0x2000},
	{106550, 0x4000},
	/* 2548 */
	{91491, 0x1},
	{91503, 0x2},
	{91524, 0x4},
	{91544, 0x8},
	{91590, 0x20},
	{91613, 0x40},
	/* 2554 */
	{214, 0x3, 3, 36326},
	{92334, 0xC, 4, 36329},
	{92414, 0x30, 4, 36333},
	{92474, 0xC0, 3, 36337},
	{92487, 0x100},
	{86860, 0x200},
	{92491, 0x400},
	{92500, 0x3800},
	{106577, 0x4000},
	/* 2563 */
	{93765, 0x2},
	{93799, 0x8},
	{93815, 0x10},
	{106602, 0x40},
	/* 2567 */
	{79184, 0x1},
	{93924, 0x2},
	{93935, 0x4},
	{93952, 0x8},
	{93969, 0x3F0},
	{93986, 0xFC00},
	{94003, 0x10000},
	{94027, 0x20000},
	{75751, 0x40000},
	{106680, 0x180000, 3, 36618},
	/* 2577 */
	{94275, 0x3, 4, 36404},
	{94306, 0x4, 2, 36408},
	{20206, 0x18, 4, 36410},
	{94388, 0x20, 2, 36414},
	{94453, 0xC0, 4, 36416},
	{94459, 0x100},
	{76713, 0x200},
	{94470, 0x400},
	{94490, 0x800},
	{94510, 0x1000},
	{94524, 0x2000},
	{94535, 0x4000},
	{94551, 0x78000},
	{94571, 0x180000},
	{94586, 0x200000},
	{94596, 0x400000},
	{94606, 0x800000},
	{94616, 0x1000000},
	{94631, 0x2000000},
	{106699, 0x4000000},
	/* 2597 */
	{95777, 0x7},
	{95794, 0x10},
	{95816, 0x1E000},
	{95832, 0x700000},
	{95853, 0x3000000},
	{95933, 0xC000000, 4, 36441},
	{106723, 0x10000000},
	{106748, 0x20000000},
	/* 2605 */
	{97752, 0x3, 4, 36472},
	{17750, 0x7C, 25, 36621},
	{73846, 0x80},
	{98350, 0x700, 8, 36508},
	{98406, 0x1800, 4, 36516},
	{87468, 0x2000},
	{78369, 0x4000},
	{98416, 0x8000},
	{98428, 0x10000},
	{98441, 0x20000},
	{96020, 0x40000},
	{98454, 0x80000},
	{98681, 0x700000, 8, 36520},
	{98703, 0x3800000, 8, 36520},
	{98727, 0x4000000},
	{98753, 0x8000000},
	{98779, 0x10000000},
	{98847, 0x60000000, 3, 36528},
	{106789, 0x80000000},
	/* 2624 */
	{82409, 0x1},
	{99021, 0x2},
	{75692, 0xC, 3, 36531},
	{99135, 0x10, 2, 36534},
	{75720, 0x60},
	{75817, 0x180},
	{99161, 0x200},
	{99184, 0x3C00},
	{99204, 0x3C000},
	{82525, 0x40000},
	{99226, 0x80000},
	{99259, 0x100000},
	{106800, 0x200000},
	{106820, 0x400000},
	/* 2638 */
	{99316, 0x1FFF},
	{99327, 0x2000},
	{99339, 0x7C000},
	{99353, 0xF80000},
	{99367, 0x3000000},
	{99381, 0x4000000},
	{73093, 0x38000000},
	{99400, 0x40000000},
	{106841, 0x80000000},
	/* 2647 */
	{106862, 0xFFFFFF},
	{10562, 0x7000000},
	{106868, 0x8000000},
	{1, 0x70000000},
	{106879, 0x80000000},
	/* 2652 */
	{106890, 0x1},
	{26781, 0xFFFFFFF8},
	/* 2654 */
	{100182, 0x1},
	{100196, 0x2},
	{106899, 0x8000},
	{100208, 0x10000},
	{100222, 0x1000000},
	/* 2659 */
	{100317, 0x30000},
	{106914, 0x300000},
	{106929, 0xC00000},
	{100325, 0x7000000},
	{100333, 0xE0000000},
	/* 2664 */
	{214, 0x3, 3, 36326},
	{106577, 0x4000},
	/* 2666 */
	{100877, 0x3FF},
	{100943, 0xC00, 4, 36536},
	/* 2668 */
	{105903, 0x3},
	{105923, 0x30},
	/* 2670 */
	{101257, 0x1},
	{101269, 0x2},
	{101281, 0x4},
	{30643, 0x10000},
	{101292, 0x60000},
	/* 2675 */
	{89452, 0x1},
	{983, 0x1FFE},
	{220, 0x2000},
	{97314, 0x4000},
	{101336, 0x8000},
	{101348, 0x7FF0000},
	{101359, 0x8000000},
	{101370, 0x10000000},
	{101380, 0x20000000},
	{106939, 0x40000000},
	{101314, 0x80000000},
	/* 2686 */
	{101442, 0x1FF},
	{50481, 0xF00000},
	{103053, 0xF0000000},
	/* 2689 */
	{64283, 0x1},
	{94453, 0x2, 4, 36416},
	{94388, 0x4, 2, 36414},
	{20206, 0x8, 4, 36410},
	{94306, 0x10, 2, 36408},
	{94275, 0x20, 4, 36404},
	{103149, 0x40},
	{103155, 0x300},
	{103165, 0x2000},
	{106951, 0x4000},
	{106973, 0x8000},
	{106995, 0x10000},
	{107017, 0x20000},
	{107039, 0x40000},
	{107061, 0x80000},
	/* 2704 */
	{104049, 0x7FF},
	{10813, 0xFFFFF800},
	/* 2706 */
	{104054, 0xFF},
	{104075, 0x100},
	{104085, 0x200},
	{104093, 0x400},
	{104107, 0x800},
	{104118, 0x1000},
	{104137, 0x2000},
	{104161, 0x4000},
	{104175, 0x8000},
	{107083, 0x10000},
	{107096, 0x20000},
	{107107, 0x40000},
	{107124, 0x80000},
	{107138, 0x100000},
	{107150, 0x200000},
	{107166, 0x400000},
	{10813, 0xFF800000},
	/* 2723 */
	{104185, 0x1},
	{104209, 0x2},
	{104233, 0x4},
	{107182, 0x8},
	{104303, 0xF0},
	{107202, 0x100},
	{107222, 0x200},
	{107237, 0x400},
	{10813, 0xFFFFF800},
	/* 2732 */
	{104318, 0x1},
	{107262, 0x2},
	{107285, 0x4},
	{104407, 0x8},
	{107299, 0x10},
	{104330, 0x20},
	{107326, 0x40},
	{104342, 0x80},
	{107341, 0x100},
	{104352, 0x200},
	{107354, 0x400},
	{104373, 0x800},
	{107378, 0x1000},
	{104390, 0x2000},
	{107398, 0x4000},
	{107418, 0x8000},
	{107435, 0x10000},
	{107455, 0x20000},
	{107472, 0x40000},
	/* 2751 */
	{879, 0xFFFF},
	{10813, 0xFFFF0000},
	/* 2753 */
	{107492, 0xFF},
	{107506, 0xFF00},
	{107529, 0xFF0000},
	{10813, 0xFF000000},
	/* 2757 */
	{107556, 0xFF},
	{107572, 0xFF00},
	{10813, 0xFFFF0000},
	/* 2760 */
	{107588, 0xFFFF},
	/* 2761 */
	{63466, 0xF},
	{63475, 0xF0},
	{63485, 0x100},
	{63496, 0x200},
	{63501, 0x400},
	{107595, 0x800},
	{63628, 0x1FF000, 257, 0},
	{107614, 0x200000},
	{63636, 0x800000},
	{63646, 0x8000000},
	/* 2771 */
	{63669, 0x1},
	{63673, 0x6},
	{63682, 0x18},
	{51265, 0x20},
	{63692, 0x40},
	{63700, 0x80},
	{63710, 0x100},
	{63721, 0x200},
	{63727, 0x400},
	{63732, 0x800},
	{63738, 0x1000},
	{54277, 0x2000},
	{63749, 0x4000},
	{63754, 0x8000},
	{63515, 0x10000},
	{63769, 0x20000},
	{63777, 0x40000},
	{63789, 0x80000},
	{107623, 0x400000},
	{63797, 0x800000},
	{107637, 0x1000000},
	{107646, 0x2000000},
	{107662, 0x4000000},
	{63808, 0x8000000},
	{43402, 0x10000000},
	{76117, 0x20000000},
	/* 2797 */
	{63820, 0x1FF, 257, 0},
	{63825, 0x400},
	{63833, 0x800},
	{63846, 0x7000},
	{63854, 0x8000},
	{107676, 0x10000},
	{107686, 0x20000},
	{107614, 0x40000},
	{107696, 0x80000},
	{107710, 0x100000},
	{105387, 0x10000000},
	/* 2808 */
	{64002, 0x1FF},
	{64012, 0xFF000},
	/* 2810 */
	{64084, 0x7},
	{64106, 0x3F0},
	{64077, 0xFC00},
	{64178, 0xFC000000},
	/* 2814 */
	{59029, 0x1F},
	{63926, 0x300},
	{64249, 0x3C00},
	{64256, 0x10000},
	{29316, 0x1C0000},
	{63918, 0xE0000000},
	/* 2820 */
	{64313, 0x3},
	{64345, 0x300},
	{64355, 0x400},
	{64368, 0x800},
	/* 2824 */
	{64385, 0xF},
	{64408, 0x10},
	{64431, 0x20},
	{64454, 0x40},
	{64474, 0x80},
	{64494, 0x100},
	{64514, 0x200},
	{64614, 0x4000},
	{64629, 0x8000},
	{64640, 0x10000},
	{64648, 0x20000},
	{64657, 0x40000},
	{105397, 0x80000},
	{64689, 0x100000},
	{64702, 0x200000},
	{64712, 0x400000},
	{64729, 0x800000},
	{64746, 0x4000000},
	{64755, 0x8000000},
	{64764, 0x10000000},
	{64773, 0x20000000},
	{64782, 0x40000000},
	/* 2846 */
	{64802, 0xF},
	{107726, 0x40},
	{64841, 0x80},
	{64864, 0x100},
	{64887, 0x200},
	{64906, 0x1000},
	{64915, 0x2000},
	{64924, 0x4000},
	{64932, 0x8000},
	{64941, 0x10000},
	{64956, 0x100000},
	{64964, 0x200000},
	{64972, 0x400000},
	{64981, 0x800000},
	{64990, 0x1000000},
	{64998, 0x2000000},
	{65006, 0x4000000},
	{107742, 0x8000000},
	{65014, 0x10000000},
	{64756, 0x20000000},
	{65032, 0x40000000},
	{65040, 0x80000000},
	/* 2868 */
	{64906, 0x2},
	{64915, 0x4},
	{65051, 0x8},
	{64755, 0x10},
	{65062, 0x20},
	{107753, 0x40},
	{64774, 0x80},
	{107763, 0x100},
	{64648, 0x200000},
	{64981, 0x400000},
	{64998, 0x1000000},
	{64924, 0x2000000},
	{64956, 0x4000000},
	{64972, 0x8000000},
	{64990, 0x20000000},
	{65006, 0x40000000},
	{65032, 0x80000000},
	/* 2885 */
	{65073, 0x20},
	{65133, 0x80},
	{65162, 0x100},
	{65182, 0x200},
	{65242, 0x2000},
	{65250, 0x4000},
	{65258, 0x8000},
	{65062, 0x10000},
	{107763, 0x2000000},
	{64774, 0x4000000},
	{107753, 0x8000000},
	{65269, 0x10000000},
	{65283, 0x20000000},
	{65051, 0x40000000},
	{65292, 0x80000000},
	/* 2900 */
	{107773, 0x7F},
	/* 2901 */
	{65301, 0x1},
	{65311, 0x2},
	{65321, 0x4},
	{65330, 0x8},
	{65339, 0x10},
	{65350, 0x20},
	{65361, 0x40},
	{65371, 0x80},
	{65381, 0x400},
	{65391, 0x800},
	{65408, 0x1000},
	{65416, 0x2000},
	{65429, 0x4000},
	{65447, 0x8000},
	{65458, 0x10000},
	{65467, 0x20000},
	{65488, 0x40000},
	{65499, 0x80000},
	{107784, 0x100000},
	{107804, 0x200000},
	{65526, 0x20000000},
	{65539, 0x40000000},
	{64773, 0x80000000},
	/* 2924 */
	{65552, 0x1},
	{107824, 0x2},
	{65587, 0x4},
	{65603, 0x8},
	{65621, 0x10},
	{65641, 0x20},
	{65660, 0x40},
	{65679, 0x80},
	{65692, 0x100},
	{65706, 0x200},
	{65730, 0x400},
	{65746, 0x800},
	{65762, 0x1000},
	{65778, 0x2000},
	{65794, 0x10000},
	{107844, 0x20000},
	{65829, 0x40000},
	{65845, 0x80000},
	{65863, 0x100000},
	{65883, 0x200000},
	{65902, 0x400000},
	{65921, 0x800000},
	{65934, 0x1000000},
	{65948, 0x2000000},
	{65972, 0x4000000},
	{65988, 0x8000000},
	{66004, 0x10000000},
	{66020, 0x20000000},
	/* 2952 */
	{66036, 0x8},
	{66055, 0x10},
	{66075, 0x40},
	{67398, 0x80},
	{66094, 0x100},
	{66115, 0x200},
	{66133, 0x400},
	{66156, 0x2000},
	{66178, 0x10000},
	{66199, 0x20000},
	{66217, 0x40000},
	{66240, 0x200000},
	{66262, 0x400000},
	{66286, 0x800000},
	{66310, 0x1000000},
	{66333, 0x2000000},
	/* 2968 */
	{43436, 0x3FFFF},
	/* 2969 */
	{107864, 0x1},
	{107881, 0x2},
	{67688, 0x1000},
	{67710, 0x4000},
	{67735, 0x20000},
	{67756, 0x40000},
	{67780, 0x400000},
	{67807, 0x800000},
	{67832, 0x1000000},
	{67855, 0x8000000},
	{67875, 0x40000000},
	/* 2980 */
	{68753, 0xFFFF},
	{20123, 0x3FFF0000},
	{68783, 0xC0000000},
	/* 2983 */
	{68798, 0x7},
	{68808, 0x38},
	{68818, 0x1C0},
	{68828, 0xE00},
	{17750, 0x3F000, 229, 36646},
	{73065, 0x600000},
	{73078, 0x800000},
	{105601, 0xC000000},
	{73199, 0x30000000, 4, 2761},
	{220, 0xC0000000},
	/* 2993 */
	{73431, 0x3FFF},
	{73440, 0xFC000},
	{73453, 0x300000},
	{73467, 0xC00000},
	{73481, 0x3000000},
	{73490, 0xC000000},
	{73520, 0x20000000},
	{111452, 0x40000000},
	/* 3001 */
	{73550, 0x3FFC0000},
	{73567, 0xC0000000},
	/* 3003 */
	{68753, 0xFF},
	{105601, 0x6000},
	{79544, 0x8000},
	{75592, 0xF0000},
	{17750, 0xFF00000, 229, 36646},
	{75414, 0xC0000000},
	/* 3009 */
	{75580, 0xF},
	{75600, 0xFFF00},
	{75613, 0x700000},
	{75622, 0x800000},
	{75652, 0x4000000},
	{111462, 0xF8000000},
	/* 3015 */
	{111473, 0x7F},
	{75680, 0x400},
	{111484, 0x7800},
	{75692, 0x18000},
	{75720, 0x60000},
	{75746, 0x80000},
	{75764, 0x100000},
	{75786, 0x200000},
	{75801, 0x400000},
	{75817, 0x800000},
	{75833, 0xFF000000},
	/* 3026 */
	{75854, 0x1},
	{75866, 0xE},
	{75879, 0xF0},
	{75897, 0x100},
	{75911, 0x3FE00},
	{75915, 0x40000},
	{43598, 0x80000},
	{10560, 0xF00000},
	{75918, 0x1000000},
	{75921, 0x1E000000},
	{73546, 0x20000000},
	/* 3037 */
	{75926, 0xFFFF},
	{111506, 0x3F0000},
	{111521, 0x20000000},
	{111535, 0x40000000},
	{111547, 0x80000000},
	/* 3042 */
	{75926, 0xFFFF},
	{75932, 0x3F0000},
	{111556, 0xC00000},
	/* 3045 */
	{75926, 0x1},
	{10813, 0x3FFE},
	{111571, 0x4000},
	{111586, 0x8000},
	{76742, 0x7F0000},
	{111506, 0x1F800000},
	{111521, 0x20000000},
	{111535, 0x40000000},
	{111547, 0x80000000},
	/* 3054 */
	{111602, 0xFF},
	{111623, 0xFF00},
	{111644, 0xFF0000},
	{111665, 0xFF000000},
	/* 3058 */
	{111690, 0x1FF},
	{111704, 0x3FE00},
	/* 3060 */
	{76855, 0x1},
	{76873, 0x2},
	{76887, 0x4},
	{76906, 0x8},
	{76926, 0x10},
	{76946, 0x20},
	{76968, 0x40},
	{76979, 0x400},
	{76997, 0x800},
	{10813, 0x1000},
	{77015, 0x2000},
	{77029, 0x4000},
	{77037, 0x8000},
	{111718, 0x10000},
	{111732, 0x20000},
	/* 3075 */
	{77229, 0xFFF},
	{77235, 0x7FFF000},
	/* 3077 */
	{77244, 0x7},
	{77254, 0x8},
	{77264, 0x10},
	{77274, 0x1FFE0},
	/* 3081 */
	{76239, 0xF},
	{111506, 0x3F0},
	{111521, 0x400},
	{111535, 0x800},
	{111547, 0x80000000},
	/* 3086 */
	{111755, 0xFFFF},
	{111765, 0xFFFF0000},
	/* 3088 */
	{47604, 0x3FF},
	/* 3089 */
	{77360, 0x1},
	{77379, 0x2},
	{77400, 0x4},
	{77411, 0x8},
	{77424, 0x10},
	{77443, 0x20},
	{77468, 0x40},
	{77491, 0x80},
	{77505, 0xF00},
	{77517, 0x1000},
	{105674, 0x4000},
	{111841, 0x30000, 4, 36875},
	{111851, 0x40000},
	{111867, 0x80000},
	{111886, 0xF00000},
	/* 3104 */
	{77887, 0x3, 4, 3027},
	{77904, 0xC, 4, 3027},
	{77922, 0x30, 4, 3027},
	{77940, 0x40},
	{77961, 0x80},
	{77976, 0x100},
	{77997, 0x200},
	{78015, 0x400},
	{78032, 0x800},
	{78045, 0x1000},
	{78064, 0x6000, 4, 3027},
	{78107, 0x10000},
	{78130, 0x20000},
	{78147, 0x40000},
	{78232, 0x180000, 4, 3031},
	{78251, 0x3E00000},
	{78268, 0x4000000},
	{78292, 0x8000000},
	{78306, 0x10000000},
	{78326, 0x20000000},
	{78340, 0x40000000},
	{78360, 0x80000000},
	/* 3126 */
	{78434, 0x3, 4, 3035},
	{78463, 0x1C},
	{78494, 0x20},
	{78530, 0x40},
	{78565, 0x80},
	{78593, 0x100},
	{78615, 0x200},
	{78633, 0x400},
	{78665, 0x800},
	{78786, 0x7000, 8, 3039},
	{78796, 0x38000},
	{78809, 0x1C0000},
	{78822, 0x200000},
	{78838, 0x400000},
	{78856, 0x800000},
	{78874, 0x2000000},
	{105712, 0x18000000},
	{111912, 0x20000000},
	/* 3144 */
	{78994, 0xF},
	{79002, 0xF0},
	{79010, 0x1F00},
	{79018, 0x6000},
	{79026, 0x18000},
	{79034, 0x60000},
	{79042, 0x180000},
	{111924, 0xF0000000},
	/* 3152 */
	{79392, 0x3, 4, 36879},
	{79404, 0xC, 4, 36879},
	{79416, 0x30, 4, 36879},
	{79432, 0xC0, 4, 36879},
	{79502, 0x30000, 4, 36883},
	{79514, 0xC0000, 4, 36883},
	{79526, 0x300000, 4, 36883},
	{79542, 0x1000000},
	{79553, 0x2000000},
	{105930, 0x4000000},
	{105940, 0x8000000},
	{105950, 0x10000000},
	{105964, 0x20000000},
	/* 3165 */
	{10330, 0x1},
	{82127, 0x3000},
	{82134, 0x30000},
	{82148, 0x300000},
	/* 3169 */
	{105858, 0x7, 5, 36601},
	{43804, 0xF0, 16, 36887},
	{112349, 0x1000},
	{112368, 0x2000},
	{112396, 0x4000},
	/* 3174 */
	{78902, 0x7FF},
	{63438, 0x7FF0000},
	/* 3176 */
	{112423, 0x1},
	{112435, 0x2},
	{112447, 0xC},
	{112460, 0x30},
	{112473, 0xC0},
	{112486, 0x100},
	{112501, 0x200},
	{112516, 0x400},
	{112526, 0x800},
	{112536, 0x1000},
	{112552, 0x2000},
	/* 3187 */
	{99283, 0xFF},
	{112568, 0xF0000000},
	/* 3189 */
	{82287, 0x3, 4, 36879},
	{82301, 0xC, 4, 36879},
	{82349, 0x300000, 4, 36883},
	{82363, 0xC00000, 4, 36883},
	{106011, 0x4000000},
	{106025, 0x8000000},
	{82394, 0x80000000},
	/* 3196 */
	{112583, 0x1},
	{112611, 0x7C},
	{82465, 0x100},
	{82494, 0x200},
	{82525, 0x400},
	{82553, 0x1000},
	{82581, 0x2000},
	{82611, 0x4000},
	/* 3204 */
	{112641, 0xF},
	{112653, 0xF0},
	/* 3206 */
	{879, 0x3F},
	{83164, 0x300},
	{83176, 0x400},
	{106041, 0x800},
	{112663, 0x1000},
	{83196, 0x20000},
	{83210, 0x40000},
	{83214, 0x80000},
	{83231, 0x100000},
	{83249, 0x600000},
	{83267, 0x800000},
	{83287, 0x1000000},
	{83299, 0x2000000},
	/* 3219 */
	{879, 0x3F},
	{83164, 0x300},
	{83176, 0x400},
	{106041, 0x800},
	{112663, 0x1000},
	{83210, 0x40000},
	{83214, 0x80000},
	{83231, 0x100000},
	{83249, 0x600000},
	{83287, 0x1000000},
	{83299, 0x2000000},
	/* 3230 */
	{83311, 0x3E},
	{83340, 0x80},
	{106055, 0x1F00},
	/* 3233 */
	{83861, 0x3F},
	{83872, 0x40},
	{83882, 0x80},
	{83899, 0x100},
	{106073, 0x3E00},
	{83915, 0x4000},
	{83935, 0x8000},
	/* 3240 */
	{84881, 0xF, 14, 36903},
	{84886, 0xF0, 14, 36903},
	{84891, 0xF00, 14, 36903},
	{84896, 0xF000, 14, 36903},
	{84901, 0xF0000, 14, 36903},
	{84906, 0xF00000, 14, 36903},
	{84911, 0xF000000, 14, 36903},
	{84916, 0xF0000000, 14, 36903},
	/* 3248 */
	{86511, 0x1F, 19, 36917},
	{86013, 0xE0, 5, 36002},
	{86616, 0x1F00, 19, 36917},
	{86632, 0x1F0000, 19, 36917},
	{86056, 0xE00000, 5, 36002},
	{86647, 0x1F000000, 19, 36917},
	{86663, 0x20000000},
	{10330, 0x40000000},
	{86684, 0x80000000},
	/* 3257 */
	{87401, 0x1},
	{106311, 0x2},
	{87419, 0x8},
	{1398, 0x70, 5, 36936},
	{86692, 0xFF0000, 256, 36021},
	/* 3262 */
	{87839, 0x1},
	{87855, 0x2},
	{87886, 0x4},
	{77953, 0x30, 4, 36277},
	{87965, 0x40},
	{87977, 0x80},
	{88001, 0x100},
	{88020, 0x200},
	{88038, 0x400},
	{88051, 0x800},
	{88073, 0x1000},
	{88163, 0x6000, 4, 36281},
	{88185, 0x8000},
	{88203, 0x10000},
	{88278, 0x800000},
	{112729, 0x1000000},
	{112747, 0x2000000},
	{112778, 0x1C000000},
	/* 3280 */
	{89164, 0x1},
	{89180, 0x2},
	{89196, 0x4},
	{89212, 0x8},
	{89228, 0x10},
	{89244, 0x20},
	{89260, 0x40},
	{89276, 0x80},
	{89292, 0x100},
	{89308, 0x200},
	{89324, 0x400},
	{89340, 0x800},
	{89356, 0x1000},
	{89372, 0x2000},
	{89388, 0x4000},
	{89404, 0x8000},
	{89420, 0x10000},
	{89439, 0x20000},
	{89457, 0x40000},
	{89484, 0x80000},
	{89506, 0x100000},
	{89524, 0x200000},
	{89544, 0x400000},
	{89567, 0x800000},
	{89590, 0x1000000},
	{89658, 0x8000000},
	{106334, 0x10000000},
	{106351, 0x20000000},
	{106376, 0x40000000},
	/* 3309 */
	{93710, 0x3F, 64, 36941},
	{68758, 0x7FFFC00},
	{93721, 0x8000000},
	/* 3312 */
	{94275, 0x3, 4, 36404},
	{94306, 0x4, 2, 36408},
	{20206, 0x18, 4, 36410},
	{94388, 0x20, 2, 36414},
	{94453, 0xC0, 4, 36416},
	{94459, 0x100},
	{94510, 0x1000},
	{94524, 0x2000},
	{94535, 0x4000},
	{94551, 0x78000},
	{94571, 0x180000},
	{94586, 0x200000},
	{94596, 0x400000},
	{94606, 0x800000},
	{94616, 0x1000000},
	{94631, 0x2000000},
	{106699, 0x4000000},
	/* 3329 */
	{220, 0x3, 3, 36420},
	{94785, 0x1C, 4, 36423},
	{94862, 0xE0, 4, 36427},
	{112826, 0x200},
	{94902, 0x3C00},
	{94924, 0x4000},
	{92474, 0x18000, 3, 36337},
	{94958, 0x60000, 4, 36431},
	{95017, 0x80000, 2, 37005},
	{95069, 0x100000, 2, 37007},
	{92500, 0x3800000},
	/* 3340 */
	{96471, 0x3},
	{76178, 0x4},
	{76200, 0x8},
	{96500, 0x60},
	{112897, 0x80},
	/* 3345 */
	{96613, 0x3, 4, 37009},
	{96626, 0x4},
	{96637, 0x8},
	{96746, 0x70, 5, 36461},
	{96764, 0x380, 5, 36461},
	{96782, 0x1C00},
	{96805, 0x3E000},
	{96831, 0x40000},
	{96853, 0x7F80000},
	{96869, 0x8000000},
	{96891, 0x10000000},
	{96978, 0x60000000, 3, 36466},
	/* 3357 */
	{97599, 0x7FF},
	{112968, 0x1000},
	{113002, 0x2000},
	{113022, 0x4000},
	{97620, 0xFF0000},
	{113045, 0xFF000000},
	/* 3363 */
	{113068, 0x1},
	{113092, 0x2},
	{113116, 0x4},
	{113159, 0x8},
	{113184, 0x70},
	{113212, 0x780},
	{113240, 0x800},
	{113252, 0x1000},
	{113277, 0x1FE000},
	{113296, 0x200000},
	/* 3373 */
	{17750, 0x1F, 25, 36621},
	{73846, 0x80},
	{98350, 0x700, 8, 36508},
	{98406, 0x1800, 4, 36516},
	{98416, 0x8000},
	{98428, 0x10000},
	{98441, 0x20000},
	{96020, 0x40000},
	{98681, 0x700000, 8, 36520},
	{98703, 0x3800000, 8, 36520},
	/* 3383 */
	{98933, 0x3},
	{98947, 0x4},
	{113336, 0x8},
	{98991, 0x10},
	{113362, 0x20},
	/* 3388 */
	{112583, 0x1},
	{113399, 0x2},
	{75692, 0xC, 3, 36531},
	{99135, 0x10, 2, 36534},
	{75720, 0x60},
	{75817, 0x180},
	{99161, 0x200},
	{99259, 0x400},
	{82525, 0x40000},
	{99226, 0x80000},
	{106800, 0x200000},
	{113429, 0x400000},
	{106820, 0x800000},
	{113441, 0x1000000},
	{113467, 0x2000000},
	{113502, 0x4000000},
	{113532, 0x38000000},
	/* 3405 */
	{99316, 0x1FFF},
	{99327, 0x2000},
	{99339, 0x7C000},
	{99367, 0x3000000},
	{99400, 0x40000000},
	/* 3410 */
	{99505, 0xFFFF},
	{99517, 0x30000},
	{91716, 0x40000},
	{113547, 0x80000},
	{99433, 0x6000000},
	{27101, 0xE0000000},
	/* 3416 */
	{26669, 0xFFFF},
	{113558, 0x20000},
	{113572, 0x40000},
	{99433, 0xC00000},
	{10560, 0xF000000},
	{59239, 0x30000000},
	{113580, 0x80000000},
	/* 3423 */
	{26741, 0xFFFF},
	{38, 0xF0000},
	{99433, 0xC00000},
	{10560, 0xF000000},
	{113580, 0x80000000},
	/* 3428 */
	{10560, 0xF},
	{113590, 0x10},
	{99600, 0x400},
	{99613, 0x6000},
	{99630, 0x8000},
	{99642, 0x300000},
	{99653, 0x6000000},
	{99670, 0x8000000},
	{99682, 0x60000000},
	/* 3437 */
	{100182, 0x1},
	{100196, 0x2},
	{106899, 0x8000},
	{100208, 0x10000},
	{100222, 0x1000000},
	{113594, 0x80000000},
	/* 3443 */
	{43360, 0x1FFF000},
	{99433, 0x6000000},
	{100296, 0x8000000},
	{100309, 0x10000000},
	{105357, 0x40000000},
	{113547, 0x80000000},
	/* 3449 */
	{100317, 0x30000},
	{113607, 0x80000},
	{106914, 0x300000},
	{106929, 0xC00000},
	{100325, 0x7000000},
	{100333, 0xE0000000},
	/* 3455 */
	{18912, 0x3F, 22, 37013},
	/* 3456 */
	{19437, 0x1},
	{93736, 0x2},
	{113644, 0x4},
	/* 3459 */
	{38, 0x1FFFF},
	/* 3460 */
	{91450, 0x1FF},
	{91430, 0x3FE00},
	{113667, 0x40000},
	{101055, 0x80000},
	{113687, 0x100000},
	{101009, 0x3FE00000},
	{113708, 0x40000000},
	{113720, 0x80000000},
	/* 3468 */
	{113749, 0xFFFF},
	{113761, 0xFFFF0000},
	/* 3470 */
	{113773, 0xFFFF},
	/* 3471 */
	{92139, 0x3F, 5, 37035},
	/* 3472 */
	{8, 0xFFF},
	{100789, 0xFFFFF000},
	/* 3474 */
	{38, 0x1FFF},
	{100789, 0xFFFFE000},
	/* 3476 */
	{89452, 0x1},
	{983, 0x1FFE},
	{220, 0x2000},
	{97314, 0x4000},
	{101336, 0x8000},
	{101348, 0x1FFF0000},
	{101359, 0x20000000},
	{101370, 0x40000000},
	{101380, 0x80000000},
	/* 3485 */
	{73585, 0x1FFFFF},
	{73604, 0xE00000},
	{73623, 0x1000000},
	{73645, 0x2000000},
	{73700, 0x10000000},
	{73718, 0x20000000},
	{73734, 0xC0000000},
	/* 3492 */
	{113793, 0xF},
	{113808, 0x10},
	{113832, 0x60},
	{113848, 0x80},
	{113864, 0x100},
	{113886, 0x200},
	{113906, 0x3C00},
	{113922, 0x4000},
	{113943, 0x8000},
	{113964, 0x1F0000},
	{113981, 0x200000},
	{113995, 0x400000},
	{114009, 0xFF800000},
	/* 3505 */
	{114026, 0xF},
	{114067, 0xF0},
	{114106, 0x100},
	{114127, 0x200},
	{114147, 0x400},
	{114167, 0x800},
	{114187, 0x1F000},
	/* 3512 */
	{114206, 0x3},
	{114219, 0x30},
	{114232, 0xC0},
	/* 3515 */
	{114245, 0xF},
	{114262, 0xF0},
	{114279, 0xF00},
	{114301, 0xF000},
	{114320, 0xF0000},
	{114338, 0xF00000},
	{114356, 0xF000000},
	{114374, 0xF0000000},
	/* 3523 */
	{114397, 0x3},
	{114415, 0x3C},
	{114438, 0xC0},
	{114468, 0x700},
	{114490, 0x3800},
	{114512, 0xC000},
	{114531, 0x10000},
	{10813, 0xFFFE0000},
	/* 3531 */
	{114539, 0xFF},
	{79544, 0x10000},
	{114548, 0x60000},
	{114558, 0x180000},
	{105601, 0x200000},
	{114568, 0x400000},
	/* 3537 */
	{490, 0x1},
	{114593, 0x2},
	{47427, 0x1C},
	{114598, 0xFE0},
	{114610, 0x1E000},
	{75454, 0x3E0000},
	{79081, 0xC00000},
	{114621, 0x7000000},
	{114633, 0x8000000},
	{114637, 0x10000000},
	{114641, 0x20000000},
	{114645, 0x40000000},
	/* 3549 */
	{114664, 0x7},
	/* 3550 */
	{490, 0x1},
	{114593, 0x2},
	{47427, 0x4},
	{114598, 0x8},
	{114610, 0x10},
	{75454, 0x20},
	{79081, 0x40},
	{114621, 0x80},
	{114633, 0x100},
	{114637, 0x200},
	{114641, 0x400},
	{114645, 0x800},
	{114664, 0x1000},
	/* 3563 */
	{101442, 0x3FF},
	{50481, 0xF00000},
	{102999, 0xF0000000},
	/* 3566 */
	{101442, 0x3F},
	{102261, 0x400},
	{102288, 0x800},
	{102315, 0x1000},
	{102341, 0x2000},
	{102367, 0x8000},
	{102394, 0x10000},
	{102474, 0x20000},
	{102500, 0x40000},
	{102420, 0x100000},
	{102579, 0x200000},
	{102741, 0x400000},
	{102768, 0x800000},
	{102633, 0x1000000},
	{102797, 0x2000000},
	{114673, 0x4000000},
	{114701, 0x8000000},
	{114727, 0x10000000},
	/* 3584 */
	{102768, 0x2},
	{102826, 0x4},
	{102855, 0x8},
	{102883, 0x10},
	{102909, 0x20},
	{102935, 0x40},
	{102962, 0x80},
	{102797, 0x100},
	{114673, 0x200},
	/* 3593 */
	{102989, 0x3FF},
	{101451, 0xFFC00},
	{102999, 0xF00000},
	{103020, 0xF000000},
	{103009, 0xF0000000},
	/* 3598 */
	{64283, 0x1},
	{94388, 0x4, 2, 36414},
	{94306, 0x10, 2, 36408},
	{103149, 0x40},
	{106951, 0x4000},
	{106973, 0x8000},
	{106995, 0x10000},
	{107017, 0x20000},
	{107039, 0x40000},
	{107061, 0x80000},
	/* 3608 */
	{103179, 0x1},
	{114755, 0x1FFFE},
	/* 3610 */
	{1411, 0x7F},
	/* 3611 */
	{1398, 0x3},
	{68398, 0x4},
	{114763, 0x8},
	{68418, 0x10},
	{68431, 0x20},
	{58316, 0x1C0},
	{114775, 0x600},
	{68458, 0x800},
	{68471, 0x1000},
	{68501, 0x2000},
	{68512, 0xC000},
	{68527, 0x30000},
	{68535, 0x40000},
	{68554, 0x80000},
	{105488, 0x700000},
	{105503, 0x10000000},
	{105526, 0x20000000},
	{68583, 0x80000000},
	/* 3629 */
	{67901, 0x3},
	{67910, 0xF0},
	{67918, 0x200},
	{67925, 0x1FC00},
	{114786, 0x20000},
	/* 3634 */
	{68196, 0x7FF, 2049, 257},
	{114815, 0x800},
	{105451, 0x1000},
	{68358, 0xFF0000, 129, 2306},
	{68370, 0x3000000},
	{105476, 0x1C000000},
	{68383, 0x80000000},
	/* 3641 */
	{68597, 0xFFF},
	{68612, 0xFFF000},
	{114827, 0x1000000},
	{64635, 0x2000000},
	{105542, 0xF0000000},
	/* 3646 */
	{105553, 0x1},
	{105563, 0x2},
	{105573, 0x10},
	{114839, 0x1F00},
	{114856, 0x2000},
	{114866, 0x4000},
	/* 3652 */
	{101442, 0x3FF},
	{103053, 0xF0000000},
	/* 3654 */
	{74256, 0xFFF},
	{103889, 0x3000},
	{114881, 0x4000},
	{10813, 0x8000},
	{103907, 0xFFFF0000},
	/* 3659 */
	{114904, 0xFFFF},
	{114922, 0xFF0000},
	{114941, 0xFF000000},
	/* 3662 */
	{12062, 0xFFF},
	/* 3663 */
	{102994, 0xFFFF},
	{101456, 0xFFFF0000},
	/* 3665 */
	{104054, 0xFF},
	{104075, 0x100},
	{104085, 0x200},
	{104093, 0x400},
	{104107, 0x800},
	{104118, 0x1000},
	{104137, 0x2000},
	{104161, 0x4000},
	{104175, 0x8000},
	{107083, 0x10000},
	{107096, 0x20000},
	{107107, 0x40000},
	{107124, 0x80000},
	{107138, 0x100000},
	{107150, 0x200000},
	{107166, 0x400000},
	{114956, 0x800000},
	{10813, 0xFF000000},
	/* 3683 */
	{104318, 0x1},
	{107262, 0x2},
	{107285, 0x4},
	{104407, 0x8},
	{104330, 0x20},
	{107326, 0x40},
	{104342, 0x80},
	{107341, 0x100},
	{104352, 0x200},
	{107354, 0x400},
	{104373, 0x800},
	{107378, 0x1000},
	{104390, 0x2000},
	{107398, 0x4000},
	{107418, 0x8000},
	{107435, 0x10000},
	{107455, 0x20000},
	{107472, 0x40000},
	{114975, 0x80000},
	{114992, 0x100000},
	{115012, 0x200000},
	{115029, 0x400000},
	/* 3705 */
	{50456, 0x1},
	{115049, 0x2},
	/* 3707 */
	{115056, 0x1},
	{115065, 0x2},
	{115079, 0x4},
	{115093, 0x8},
	{115110, 0xFF0},
	{115126, 0x8000},
	{115137, 0xF0000},
	{115154, 0xF00000},
	{115171, 0x3000000},
	{115185, 0x4000000},
	/* 3717 */
	{1398, 0x1},
	/* 3718 */
	{402, 0xFFF},
	/* 3719 */
	{1, 0xF},
	/* 3720 */
	{1, 0xF},
	{63515, 0x100},
	/* 3722 */
	{50742, 0xF},
	/* 3723 */
	{115199, 0x1},
	{115207, 0x2},
	{115215, 0x4},
	{115223, 0x8},
	{115231, 0x10},
	{115239, 0x20},
	{115247, 0x40},
	{115255, 0x80},
	{115263, 0x100},
	/* 3732 */
	{93710, 0x3F, 64, 36941},
	{112816, 0x80},
	{105109, 0xF00},
	{105121, 0x1000},
	{105128, 0x2000},
	{105136, 0x4000},
	{105144, 0x8000},
	{105152, 0x10000},
	{105175, 0x60000, 4, 36586},
	{105200, 0x80000},
	{105212, 0x100000},
	{105220, 0x200000},
	{105264, 0xC00000, 3, 36590},
	{105350, 0x1000000},
	{99433, 0x6000000},
	{100309, 0x30000000},
	{105357, 0x40000000},
	{113547, 0x80000000},
	/* 3750 */
	{115319, 0x3800, 6, 37040},
	{115353, 0xC000, 3, 37046},
	{115369, 0x20000},
	{115378, 0xFC0000},
	/* 3754 */
	{115388, 0x80000000},
	/* 3755 */
	{64385, 0xF},
	{64408, 0x10},
	{64431, 0x20},
	{64454, 0x40},
	{64474, 0x80},
	{64494, 0x100},
	{64514, 0x200},
	{64614, 0x4000},
	{64629, 0x8000},
	{64640, 0x10000},
	{64648, 0x20000},
	{64657, 0x40000},
	{105397, 0x80000},
	{64689, 0x100000},
	{64702, 0x200000},
	{64712, 0x400000},
	{64746, 0x4000000},
	{64755, 0x8000000},
	{64764, 0x10000000},
	{64773, 0x20000000},
	{64782, 0x40000000},
	{64791, 0x80000000},
	/* 3777 */
	{64906, 0x2},
	{64915, 0x4},
	{65051, 0x8},
	{64755, 0x10},
	{65062, 0x20},
	{107753, 0x40},
	{64774, 0x80},
	{64648, 0x200000},
	{64981, 0x400000},
	{64998, 0x1000000},
	{64924, 0x2000000},
	{64956, 0x4000000},
	{64972, 0x8000000},
	{64990, 0x20000000},
	{65006, 0x40000000},
	{65032, 0x80000000},
	/* 3793 */
	{65073, 0x20},
	{65133, 0x80},
	{65162, 0x100},
	{65182, 0x200},
	{65242, 0x2000},
	{65250, 0x4000},
	{65258, 0x8000},
	{65062, 0x10000},
	{64774, 0x4000000},
	{107753, 0x8000000},
	{65269, 0x10000000},
	{65283, 0x20000000},
	{65051, 0x40000000},
	{65292, 0x80000000},
	/* 3807 */
	{75854, 0x1},
	{75866, 0xE},
	{75879, 0xF0},
	{75897, 0x100},
	{75911, 0x3FE00},
	{75915, 0x40000},
	{43598, 0x80000},
	{10560, 0xF00000},
	{75918, 0x1000000},
	{75921, 0x1E000000},
	{73546, 0x20000000},
	{115396, 0x40000000},
	/* 3819 */
	{115400, 0xF},
	{115420, 0xF0},
	{115440, 0xF00},
	{115460, 0xF000},
	{115480, 0xF0000},
	{115500, 0xF00000},
	{115520, 0xF000000},
	{115540, 0xF0000000},
	/* 3827 */
	{115560, 0x1},
	{115577, 0x2},
	/* 3829 */
	{90245, 0x1},
	{90017, 0x2},
	{90041, 0x4},
	{90061, 0x8},
	{90082, 0x10},
	{90283, 0x40},
	/* 3835 */
	{220, 0x3, 3, 36420},
	{94785, 0x1C, 4, 36423},
	{94862, 0xE0, 4, 36427},
	{94871, 0x100},
	{112826, 0x200},
	{94902, 0x3C00},
	{94924, 0x4000},
	{92474, 0x18000, 3, 36337},
	{94958, 0x60000, 4, 36431},
	{95017, 0x80000, 2, 37005},
	{95069, 0x100000, 2, 37007},
	{92500, 0x3800000},
	/* 3847 */
	{96613, 0x3, 4, 37049},
	{96626, 0x4},
	{96637, 0x8},
	{96746, 0x70, 5, 36461},
	{96764, 0x380, 5, 36461},
	{96782, 0x1C00},
	{96805, 0x3E000},
	{96831, 0x40000},
	{96853, 0x7F80000},
	{96869, 0x8000000},
	{96891, 0x10000000},
	{96978, 0x60000000, 3, 36466},
	/* 3859 */
	{113068, 0x1},
	{113092, 0x2},
	{113116, 0x4},
	{113159, 0x8},
	{115596, 0x70},
	{113212, 0x780},
	{113240, 0x800},
	{113252, 0x1000},
	{113277, 0x1FE000},
	{113296, 0x200000},
	{115633, 0x400000},
	{115644, 0x800000},
	{115671, 0x3000000},
	{113184, 0x7C000000},
	/* 3873 */
	{40700, 0xFFFF},
	/* 3874 */
	{100796, 0x7F},
	{100760, 0xFF00},
	{100751, 0xFF0000},
	{100811, 0x20000000},
	{100831, 0x40000000},
	{100857, 0x80000000},
	/* 3880 */
	{104796, 0xF},
	{104843, 0x1000000},
	{104854, 0x2000000},
	{104864, 0x4000000},
	/* 3884 */
	{63466, 0xF},
	{63475, 0xF0},
	{63636, 0x800000},
	{115696, 0x1000000},
	{63646, 0x8000000},
	/* 3889 */
	{51265, 0x20},
	{63692, 0x40},
	{63710, 0x100},
	{63721, 0x200},
	{63727, 0x400},
	{115715, 0x800},
	{63749, 0x4000},
	{115721, 0x8000},
	{63515, 0x10000},
	{63777, 0x40000},
	{107623, 0x400000},
	{63797, 0x800000},
	{107637, 0x1000000},
	{107646, 0x2000000},
	{107662, 0x4000000},
	{63808, 0x8000000},
	{43402, 0x10000000},
	{64368, 0x20000000},
	{115743, 0x40000000},
	{115752, 0x80000000},
	/* 3909 */
	{115765, 0x1},
	{115774, 0x2},
	{115726, 0x4},
	{115787, 0x8},
	{115810, 0x1F0},
	{63669, 0x200},
	{115827, 0xC00},
	{63682, 0x3000},
	{54277, 0x4000},
	{115836, 0x8000},
	{115847, 0x10000},
	{115861, 0x20000},
	{76117, 0x40000},
	{63789, 0x80000},
	{63700, 0x100000},
	/* 3924 */
	{64042, 0xFF},
	{64051, 0x1FF000},
	{64060, 0xF000000},
	/* 3927 */
	{64084, 0x7},
	{115874, 0x1F8},
	{115881, 0x7E00},
	{115890, 0x1F8000},
	{115901, 0xE00000},
	{115909, 0x3F000000},
	/* 3933 */
	{115919, 0xF},
	{115930, 0x10},
	{115938, 0x20},
	{63833, 0x40},
	{107676, 0x80},
	{115951, 0x100},
	{107614, 0x200},
	{107696, 0x400},
	{107710, 0x800},
	{63906, 0x1000},
	{115962, 0xC0000000},
	/* 3944 */
	{115983, 0x1},
	{115995, 0x2},
	{116012, 0x4},
	{116027, 0x8},
	{116040, 0x10},
	{116054, 0x20},
	{116066, 0x40},
	{63854, 0x40000000},
	{63501, 0x80000000},
	/* 3953 */
	{115983, 0x1},
	{115995, 0x2},
	{116012, 0x4},
	{116027, 0x8},
	{116040, 0x10},
	{116054, 0x20},
	{116066, 0x40},
	{115919, 0x80},
	{107614, 0x100},
	{107710, 0x200},
	/* 3963 */
	{64108, 0x1F},
	{64313, 0x30000000},
	{64355, 0x40000000},
	{116079, 0x80000000},
	/* 3967 */
	{116093, 0x7F},
	{116102, 0x7F00},
	{116111, 0x7F0000},
	{116120, 0x7F000000},
	/* 3971 */
	{116129, 0x7F},
	{116138, 0x7F00},
	{116147, 0x7F0000},
	{116156, 0x7F000000},
	/* 3975 */
	{64385, 0xF},
	{64408, 0x10},
	{64431, 0x20},
	{64454, 0x40},
	{64474, 0x80},
	{64614, 0x4000},
	{64629, 0x8000},
	{64640, 0x10000},
	{64657, 0x40000},
	{105397, 0x80000},
	{64689, 0x100000},
	{64702, 0x200000},
	{64712, 0x400000},
	{64729, 0x800000},
	{64746, 0x4000000},
	{64755, 0x8000000},
	{64764, 0x10000000},
	{64773, 0x20000000},
	{64782, 0x40000000},
	/* 3994 */
	{64802, 0xF},
	{107726, 0x40},
	{64841, 0x80},
	{64864, 0x100},
	{116165, 0x800},
	{64906, 0x1000},
	{64915, 0x2000},
	{64924, 0x4000},
	{64941, 0x10000},
	{64956, 0x100000},
	{64964, 0x200000},
	{64972, 0x400000},
	{64981, 0x800000},
	{64990, 0x1000000},
	{64998, 0x2000000},
	{65006, 0x4000000},
	{107742, 0x8000000},
	{65014, 0x10000000},
	{64756, 0x20000000},
	{65032, 0x40000000},
	{65040, 0x80000000},
	/* 4015 */
	{116165, 0x1},
	{64906, 0x2},
	{64915, 0x4},
	{65051, 0x8},
	{64755, 0x10},
	{65062, 0x20},
	{116174, 0x40},
	{64774, 0x80},
	{64981, 0x400000},
	{64998, 0x1000000},
	{64924, 0x2000000},
	{64956, 0x4000000},
	{64972, 0x8000000},
	{64990, 0x20000000},
	{65006, 0x40000000},
	{65032, 0x80000000},
	/* 4031 */
	{65073, 0x20},
	{65133, 0x80},
	{65162, 0x100},
	{65182, 0x200},
	{65250, 0x4000},
	{65258, 0x8000},
	{65062, 0x10000},
	{64774, 0x4000000},
	{116174, 0x8000000},
	{65051, 0x40000000},
	{65292, 0x80000000},
	/* 4042 */
	{65552, 0x1},
	{65587, 0x4},
	{65603, 0x8},
	{65621, 0x10},
	{65641, 0x20},
	{65660, 0x40},
	{65679, 0x80},
	{65692, 0x100},
	{65706, 0x200},
	{65730, 0x400},
	{65746, 0x800},
	{65762, 0x1000},
	{65778, 0x2000},
	{65794, 0x10000},
	{65829, 0x40000},
	{65845, 0x80000},
	{65863, 0x100000},
	{65883, 0x200000},
	{65902, 0x400000},
	{65921, 0x800000},
	{65934, 0x1000000},
	{65948, 0x2000000},
	{65972, 0x4000000},
	{65988, 0x8000000},
	{66004, 0x10000000},
	{66020, 0x20000000},
	/* 4068 */
	{66355, 0x1},
	{66374, 0x2},
	{66383, 0x10},
	{66398, 0x20},
	{66412, 0x40},
	{66431, 0x80},
	{66450, 0x100},
	{66465, 0x200},
	{66482, 0x400},
	{66504, 0x800},
	{66541, 0x2000},
	{65381, 0x4000},
	{66556, 0x8000},
	{66565, 0x10000},
	{65416, 0x20000},
	{66574, 0x40000},
	{66584, 0x80000},
	{66598, 0x100000},
	{66612, 0x200000},
	{66626, 0x400000},
	{65447, 0x800000},
	{66643, 0x1000000},
	{66656, 0x4000000},
	{66669, 0x8000000},
	{66682, 0x30000000},
	{66701, 0x40000000},
	{64764, 0x80000000},
	/* 4095 */
	{66714, 0x1},
	{66732, 0x2},
	{66746, 0x4},
	{66765, 0x8},
	{66784, 0x10},
	{66799, 0x20},
	{66817, 0x40},
	{66835, 0x80},
	{66852, 0x100},
	{66867, 0x200},
	{66881, 0x400},
	{66898, 0x800},
	{66922, 0x1000},
	{66940, 0x2000},
	{66958, 0x4000},
	{67029, 0x20000},
	{67046, 0x40000},
	{67066, 0x80000},
	{67086, 0x100000},
	{67106, 0x200000},
	{67127, 0x400000},
	{67150, 0x800000},
	{67171, 0x1000000},
	{67190, 0x2000000},
	{67207, 0x4000000},
	{67223, 0x8000000},
	{67239, 0x10000000},
	{67255, 0x20000000},
	{67274, 0x40000000},
	{67286, 0x80000000},
	/* 4125 */
	{67532, 0x1},
	{67546, 0x4},
	{67561, 0x8},
	{67578, 0x80},
	{67590, 0x100},
	{67603, 0x400},
	{67618, 0x800},
	{67633, 0x1000},
	{67648, 0x2000},
	{116186, 0x4000},
	{116204, 0x8000},
	{116222, 0x10000},
	{116240, 0x20000},
	{116258, 0x40000},
	{116277, 0x80000},
	{116296, 0x100000},
	{116315, 0x200000},
	/* 4142 */
	{116334, 0x1},
	{116356, 0x2},
	{43436, 0xFFFFFFFC},
	/* 4145 */
	{43436, 0xFF},
	/* 4146 */
	{107864, 0x1},
	{107881, 0x2},
	{67688, 0x1000},
	{67710, 0x4000},
	{67735, 0x20000},
	{67756, 0x40000},
	{67780, 0x400000},
	{67807, 0x800000},
	{67832, 0x1000000},
	{67855, 0x8000000},
	{67875, 0x40000000},
	{116374, 0x80000000},
	/* 4158 */
	{68798, 0x7},
	{68808, 0x38},
	{68818, 0x1C0},
	{68828, 0xE00},
	{17750, 0x3F000, 123, 37053},
	{116401, 0xC0000},
	{73065, 0x600000},
	{73078, 0x800000},
	{75764, 0x1000000},
	{75786, 0x2000000},
	{116414, 0xC000000},
	{73199, 0x30000000, 4, 2761},
	{220, 0xC0000000},
	/* 4171 */
	{73399, 0x1FFF},
	{73407, 0x3FFE000},
	{73424, 0xF0000000},
	/* 4174 */
	{73431, 0x3FFF},
	{73440, 0xFC000},
	{73453, 0x300000},
	{73467, 0xC00000},
	{73481, 0x3000000},
	{73490, 0xC000000},
	{73520, 0x20000000},
	{116438, 0xC0000000},
	/* 4182 */
	{116450, 0x3},
	{73550, 0x3FFC0000},
	{73567, 0xC0000000},
	/* 4185 */
	{73755, 0x7},
	{73765, 0x38},
	{73786, 0xC0},
	{105636, 0x700},
	{73807, 0x780000},
	{73826, 0xC000000},
	/* 4191 */
	{68753, 0xFF},
	{75592, 0x1F000},
	{17750, 0x1FE0000, 123, 37053},
	{75432, 0x3E000000},
	{75414, 0xC0000000},
	/* 4196 */
	{75423, 0x3FFF},
	{75210, 0x3FFFC000},
	/* 4198 */
	{68798, 0x7},
	{68808, 0x38},
	{68818, 0x1C0},
	{68828, 0xE00},
	{116462, 0x1000},
	{75443, 0xF8000},
	{75454, 0x1F00000},
	{75558, 0xE000000, 6, 2828},
	{220, 0xF0000000},
	/* 4207 */
	{18896, 0x3FFF},
	{105645, 0xC000},
	{75569, 0x3FFF0000},
	/* 4210 */
	{116476, 0x10},
	{75600, 0x3FFE0},
	{75613, 0x700000},
	{75622, 0x800000},
	{111462, 0xFC000000},
	/* 4215 */
	{111473, 0x7F},
	{111484, 0x7800},
	{75692, 0x8000},
	{75720, 0x60000},
	{75764, 0x100000},
	{75786, 0x200000},
	{116414, 0xC00000},
	/* 4222 */
	{75854, 0x1},
	{75866, 0xE},
	{75879, 0xF0},
	{75897, 0x100},
	{75911, 0x3FE00},
	{75915, 0x40000},
	{43598, 0x80000},
	{10560, 0xF00000},
	{75918, 0x1000000},
	{75921, 0x3E000000},
	{73546, 0x40000000},
	{116482, 0x80000000},
	/* 4234 */
	{115396, 0x1},
	/* 4235 */
	{75932, 0x3FF},
	{111556, 0xC00},
	{111506, 0xFF0000},
	{111547, 0x80000000},
	/* 4239 */
	{75971, 0x3F},
	{75977, 0x3C0},
	{73595, 0xC00},
	{76067, 0xFF000, 193, 2834},
	{51265, 0x100000},
	{115765, 0x200000},
	{116486, 0x400000},
	{63646, 0x800000},
	{76088, 0x1000000},
	{64355, 0x4000000},
	{105655, 0x8000000},
	{116497, 0x10000000},
	{63636, 0x20000000},
	/* 4252 */
	{83311, 0x1F},
	{106055, 0x3E0},
	{83340, 0x400},
	{83861, 0x1F800},
	{106073, 0x3E0000},
	/* 4257 */
	{75932, 0x3FF},
	{116507, 0x400},
	{116523, 0x800},
	{111571, 0x4000},
	{111586, 0x8000},
	{76742, 0x7F0000},
	{111506, 0x7F800000},
	{111547, 0x80000000},
	/* 4265 */
	{75971, 0x3F},
	{75977, 0x3C0},
	{73595, 0xC00},
	{76067, 0xFF000, 193, 2834},
	{51265, 0x100000},
	{115765, 0x200000},
	{116486, 0x400000},
	{63646, 0x800000},
	{76622, 0x1000000},
	{64355, 0x4000000},
	{76784, 0x8000000},
	{116497, 0x10000000},
	{76793, 0x60000000},
	{63636, 0x80000000},
	/* 4279 */
	{116541, 0xF},
	{116559, 0xF0},
	/* 4281 */
	{75932, 0x3FF},
	{116507, 0x400},
	{116523, 0x800},
	{111506, 0xFF0000},
	{111547, 0x80000000},
	/* 4286 */
	{75971, 0x3F},
	{75977, 0x3C0},
	{73595, 0xC00},
	{76067, 0xFF000, 193, 2834},
	{51265, 0x100000},
	{115765, 0x200000},
	{116486, 0x400000},
	{63646, 0x800000},
	{64355, 0x2000000},
	{76784, 0x4000000},
	{116497, 0x8000000},
	{76827, 0x30000000},
	{63636, 0x40000000},
	/* 4299 */
	{76855, 0x1},
	{76873, 0x2},
	{76887, 0x4},
	{76906, 0x8},
	{76926, 0x10},
	{76946, 0x20},
	{76968, 0x40},
	{76979, 0x400},
	{76997, 0x800},
	{116577, 0x1000},
	{77015, 0x2000},
	{77029, 0x4000},
	{77037, 0x8000},
	{111718, 0x10000},
	{111732, 0x20000},
	{116590, 0x40000},
	{116607, 0xE0000000},
	/* 4316 */
	{77047, 0x1FFF},
	{116541, 0xE000},
	{77063, 0xFFFF0000},
	/* 4319 */
	{77047, 0x1FFF},
	{116559, 0xE000},
	{77063, 0xFFFF0000},
	/* 4322 */
	{75971, 0x3F},
	{75977, 0x3C0},
	{73595, 0xC00},
	{76067, 0xFF000, 193, 2834},
	{51265, 0x100000},
	{115765, 0x200000},
	{116486, 0x400000},
	{63646, 0x800000},
	{77082, 0x1000000},
	{116497, 0x2000000},
	{63636, 0x4000000},
	{76784, 0x20000000},
	{76105, 0x40000000},
	{64355, 0x80000000},
	/* 4336 */
	{76117, 0x1},
	{76128, 0x3E},
	{116623, 0x40},
	{77088, 0x80},
	{77098, 0x100},
	{77108, 0x200},
	{76844, 0x400},
	{77118, 0x1800},
	{77133, 0x6000},
	{64051, 0xFF8000},
	{63628, 0x7F000000, 257, 0},
	{115752, 0x80000000},
	/* 4348 */
	{77229, 0xFFF},
	{77235, 0x3FFFF000},
	/* 4350 */
	{77244, 0xF},
	{77264, 0x10},
	{77274, 0x1FFE0},
	/* 4353 */
	{76239, 0xF},
	{111506, 0xFF0},
	{116636, 0x2000},
	{111547, 0x80000000},
	/* 4357 */
	{116643, 0x3FF},
	{116657, 0xF0000},
	{116678, 0xF000000},
	/* 4360 */
	{77350, 0x1FFF},
	/* 4361 */
	{77379, 0x2},
	{79184, 0x4},
	{93935, 0x8},
	{93969, 0x10},
	{77443, 0x20},
	{77468, 0x40},
	{77491, 0x80},
	{77505, 0xF00},
	{77517, 0x1000},
	{105674, 0x4000},
	{111841, 0x30000, 4, 36875},
	{111851, 0x40000},
	{111867, 0x80000},
	{116699, 0xF00000},
	/* 4375 */
	{77749, 0x3FFF},
	{77776, 0x3FFF0000},
	/* 4377 */
	{77786, 0x1000000},
	{77798, 0x2000000},
	{77816, 0x7C000000},
	/* 4380 */
	{77887, 0x3, 4, 3027},
	{77904, 0xC, 4, 3027},
	{77922, 0x30, 4, 3027},
	{77940, 0x40},
	{77961, 0x80},
	{77976, 0x100},
	{77997, 0x200},
	{78015, 0x400},
	{78032, 0x800},
	{78045, 0x1000},
	{78064, 0x6000, 4, 3027},
	{116726, 0x8000},
	{78232, 0x180000, 4, 3031},
	{78251, 0x3E00000},
	{78268, 0x4000000},
	{78292, 0x8000000},
	{78306, 0x10000000},
	{78326, 0x20000000},
	{78340, 0x40000000},
	{78360, 0x80000000},
	/* 4400 */
	{78434, 0x3, 4, 3035},
	{78463, 0x1C},
	{93986, 0x20},
	{94027, 0x40},
	{78565, 0x80},
	{78593, 0x100},
	{79184, 0x200},
	{78633, 0x400},
	{116740, 0x800},
	{116766, 0x1000},
	{93935, 0x1FE000},
	{78822, 0x200000},
	{78856, 0x800000},
	{78874, 0x2000000},
	{105712, 0x18000000},
	{111912, 0x20000000},
	/* 4416 */
	{78902, 0xFFFF},
	{63438, 0xFFFF0000},
	/* 4418 */
	{17750, 0x3, 4, 3051},
	{79081, 0xC},
	{75454, 0x1F0},
	{93935, 0x600},
	{116798, 0x800},
	{116816, 0x1000},
	{79184, 0x6000},
	{79201, 0xF8000},
	{116834, 0x100000},
	{79208, 0x7800000},
	{116852, 0x8000000},
	{116870, 0x10000000},
	{79257, 0x20000000},
	/* 4431 */
	{17750, 0x1, 2, 3059},
	{75454, 0x1F0},
	{93935, 0x600},
	{116798, 0x800},
	{116816, 0x1000},
	{79184, 0xE000},
	{116834, 0x100000},
	{116852, 0x8000000},
	{79320, 0x20000000},
	/* 4440 */
	{116888, 0x3},
	{116907, 0xC},
	{116932, 0x30},
	{116951, 0xC0},
	{116976, 0x300},
	/* 4445 */
	{117003, 0x7},
	{117019, 0x38},
	{117036, 0x1C0},
	{117058, 0xE00},
	{117081, 0x7000},
	/* 4450 */
	{77559, 0x2},
	{77580, 0x4},
	{77614, 0x8},
	{77661, 0xF00},
	{77674, 0xF000},
	{77687, 0xF0000},
	{77700, 0xF00000},
	{77714, 0xF000000},
	{77732, 0xF0000000},
	/* 4459 */
	{78107, 0x1},
	/* 4460 */
	{86958, 0x1},
	{77895, 0x2},
	{86973, 0x4},
	{86988, 0x8},
	{78790, 0x70, 8, 3039},
	{87008, 0x80},
	{87024, 0x700, 8, 3039},
	{87036, 0x700000, 8, 3039},
	{117106, 0x40000000},
	{117124, 0x80000000},
	/* 4470 */
	{79184, 0x7},
	{87155, 0x700},
	{87179, 0x7000},
	{87205, 0x10000},
	{117142, 0x20000},
	{117160, 0x40000},
	{117178, 0x80000},
	{87291, 0x100000},
	{117196, 0x200000},
	{87345, 0x7000000},
	{87370, 0x8000000},
	/* 4481 */
	{83045, 0xFF},
	{83102, 0xFF00},
	/* 4483 */
	{51841, 0xFF},
	{83155, 0xFF00},
	/* 4485 */
	{117214, 0xFF},
	{117223, 0xFF00},
	/* 4487 */
	{83072, 0xFF},
	{83135, 0xFF00},
	/* 4489 */
	{117235, 0x7},
	{117253, 0x38},
	{117272, 0x1C0},
	{117290, 0xE00},
	{117309, 0x7000},
	{117327, 0x38000},
	/* 4495 */
	{117346, 0x3},
	{117367, 0xC},
	{117388, 0x30},
	/* 4498 */
	{79780, 0xFFF},
	{79799, 0xFFF0000},
	/* 4500 */
	{117409, 0x3},
	{117418, 0xC},
	{117427, 0x30},
	{117436, 0xC0},
	/* 4504 */
	{78902, 0x1FFF},
	{63438, 0x1FFF0000},
	/* 4506 */
	{117445, 0x7},
	{117458, 0x38},
	/* 4508 */
	{82301, 0xC, 4, 36879},
	{82363, 0xC00000, 4, 36883},
	{106025, 0x8000000},
	/* 4511 */
	{83872, 0x40},
	{83915, 0x4000},
	{83935, 0x8000},
	/* 4514 */
	{83353, 0x1},
	{83370, 0x2},
	{83387, 0x4},
	{83406, 0x8},
	{83427, 0x10},
	{83445, 0x20},
	{83463, 0x40},
	{83483, 0x80},
	{83504, 0x100},
	{83520, 0x200},
	{83536, 0x400},
	{83552, 0x800},
	{83568, 0x1000},
	{83583, 0x2000},
	{83597, 0x4000},
	{83617, 0x8000},
	{95933, 0x30000, 4, 36441},
	/* 4531 */
	{115560, 0x1},
	{115577, 0x2},
	{106748, 0x4},
	/* 4534 */
	{86788, 0x3, 4, 36007},
	{86860, 0x20},
	{86868, 0x40},
	{86910, 0xE0000000},
	/* 4538 */
	{106421, 0x7, 5, 36601},
	{106447, 0x38, 5, 36601},
	{106476, 0x1C0, 5, 36601},
	{106501, 0xE00, 5, 36601},
	{106527, 0x2000},
	{106550, 0x4000},
	{106723, 0x8000},
	/* 4545 */
	{90612, 0x3},
	/* 4546 */
	{91491, 0x1},
	{91503, 0x2},
	{91524, 0x4},
	{91544, 0x8},
	{91590, 0x20},
	{91613, 0x40},
	{117475, 0x80},
	/* 4553 */
	{91643, 0x1},
	{91653, 0x2},
	{91668, 0x4},
	{91693, 0x8},
	{91711, 0x70},
	{91727, 0x80},
	{91732, 0x100},
	{91755, 0x200},
	{91774, 0x400},
	{91796, 0x800},
	{91812, 0x1000},
	{91828, 0x2000},
	{91844, 0x4000},
	{91863, 0x8000},
	{91889, 0x10000},
	{91904, 0x20000},
	{91944, 0x40000},
	{91971, 0x80000},
	{91994, 0xF00000},
	{92010, 0x1000000},
	{92040, 0x2000000},
	{92064, 0x4000000},
	{92085, 0x8000000},
	{92115, 0x70000000},
	{117505, 0x80000000},
	/* 4578 */
	{214, 0x3, 3, 36326},
	{92474, 0xC0, 3, 36337},
	{86860, 0x200},
	{92500, 0x3800},
	{106577, 0x4000},
	{51786, 0x18000},
	{117529, 0x60000},
	/* 4585 */
	{94306, 0x4, 2, 36408},
	{94388, 0x20, 2, 36414},
	{94571, 0x80000},
	{94586, 0x200000},
	{94596, 0x400000},
	{94616, 0x1000000},
	{106699, 0x4000000},
	/* 4592 */
	{93765, 0x2},
	{93799, 0x8},
	{93815, 0x10},
	{100789, 0x20},
	{106602, 0x40},
	/* 4597 */
	{220, 0x3, 3, 36420},
	{94785, 0x1C, 4, 36423},
	{94862, 0xE0, 4, 36427},
	{94924, 0x4000},
	{51786, 0x18000},
	{94958, 0x60000, 4, 36431},
	{95017, 0x80000, 2, 37005},
	{95069, 0x100000, 2, 37007},
	{92500, 0x3800000},
	{117529, 0x30000000},
	/* 4607 */
	{79184, 0x1},
	{93935, 0x4},
	{93952, 0x8},
	{93969, 0x3F0},
	{93986, 0xFC00},
	{94003, 0x10000},
	{94027, 0x20000},
	/* 4614 */
	{10330, 0x1},
	{20563, 0xFC},
	{95259, 0x80000000},
	/* 4617 */
	{94651, 0xFF},
	{94679, 0xFC000},
	/* 4619 */
	{79262, 0x1},
	{17750, 0x2},
	{75454, 0x1C},
	{94003, 0x2000000},
	/* 4623 */
	{79262, 0x1},
	{75454, 0xE},
	/* 4625 */
	{52830, 0x7FF},
	/* 4626 */
	{63469, 0x7},
	{88163, 0x18, 4, 36281},
	/* 4628 */
	{77887, 0x3, 4, 3027},
	{117544, 0xC},
	{77961, 0x10},
	{77976, 0x20},
	{78064, 0xC0, 4, 3027},
	{78268, 0x100},
	{78633, 0x200},
	{78822, 0x400},
	{78856, 0x800},
	{117561, 0x1000},
	/* 4638 */
	{95777, 0x7},
	{95794, 0x10},
	{95832, 0x700000},
	{95853, 0x3000000},
	{87139, 0xC0000000},
	/* 4643 */
	{96613, 0x3, 4, 37049},
	{96626, 0x4},
	{96637, 0x8},
	{96746, 0x70, 5, 36461},
	{96764, 0x380, 5, 36461},
	{96782, 0x1C00},
	{96805, 0x3E000},
	{96831, 0x40000},
	{96853, 0x7F80000},
	{96869, 0x8000000},
	{96891, 0x10000000},
	{96978, 0x60000000, 3, 36466},
	{117584, 0x80000000},
	/* 4656 */
	{96471, 0x3},
	{76178, 0x4},
	{76200, 0x8},
	{96500, 0x60},
	{112897, 0x80},
	{91889, 0x100},
	/* 4662 */
	{95816, 0xF},
	/* 4663 */
	{77749, 0x3FFF},
	{77776, 0xFFFC000},
	/* 4665 */
	{97691, 0x1F},
	/* 4666 */
	{98933, 0x3},
	{98947, 0x4},
	{113362, 0x8},
	/* 4669 */
	{75692, 0x4, 3, 36531},
	{75720, 0x60},
	{113441, 0x1000000},
	{116934, 0xC000000},
	{113502, 0x10000000},
	{113532, 0x60000000},
	/* 4675 */
	{99293, 0xFFFF},
	{99305, 0xFFFF0000},
	/* 4677 */
	{99316, 0x3FFF},
	{99339, 0x38000},
	{75592, 0xF80000},
	{99367, 0x3000000},
	{116890, 0xC000000},
	/* 4682 */
	{17750, 0x1F, 25, 36621},
	{73846, 0x80},
	{98350, 0x700, 8, 36508},
	{98406, 0x1800, 4, 36516},
	{98416, 0x8000},
	{98428, 0x10000},
	{98441, 0x20000},
	{96020, 0x40000},
	{117596, 0x80000},
	/* 4691 */
	{117005, 0x7},
	{117021, 0x38},
	/* 4693 */
	{10560, 0xF},
	{113590, 0x10},
	{99600, 0x400},
	{99613, 0x6000},
	{99642, 0x300000},
	{99653, 0x6000000},
	{99682, 0x60000000},
	/* 4700 */
	{100027, 0x1},
	{100047, 0x2},
	{100061, 0x30},
	{117635, 0xC0},
	{100073, 0x1FF0000},
	{100086, 0x10000000},
	{100101, 0x20000000},
	{100115, 0xC0000000},
	/* 4708 */
	{43360, 0x1FFF000},
	{99433, 0x6000000},
	{100309, 0x10000000},
	{105357, 0x40000000},
	{113547, 0x80000000},
	/* 4713 */
	{100796, 0x7F},
	{100760, 0x300},
	{100751, 0xF0000},
	{100811, 0x20000000},
	{100831, 0x40000000},
	{100857, 0x80000000},
	/* 4719 */
	{18912, 0x3F, 22, 37013},
	{94666, 0xFC0},
	{63287, 0x1FF000},
	/* 4722 */
	{30726, 0x7},
	{2185, 0x38},
	{2255, 0x1C0},
	{117657, 0xFE00},
	{117670, 0x70000},
	{117678, 0x380000},
	{117686, 0x400000},
	{117702, 0x7F800000},
	/* 4730 */
	{101072, 0x7},
	{101081, 0x78},
	{100789, 0x80},
	{101090, 0x100},
	/* 4734 */
	{114539, 0x3FFF},
	/* 4735 */
	{114539, 0x7FF},
	{117716, 0x30000},
	{117722, 0x1C0000},
	{117735, 0xE00000},
	{117529, 0x3000000},
	{117748, 0x4000000},
	{117763, 0x8000000},
	/* 4742 */
	{101241, 0xFFFF},
	/* 4743 */
	{101249, 0xFFFF},
	/* 4744 */
	{114026, 0xF},
	{114067, 0xF0},
	{114106, 0x100},
	{114127, 0x200},
	{114147, 0x400},
	{114167, 0x800},
	{114187, 0x1F000},
	{117774, 0x1E0000},
	{117790, 0x200000},
	/* 4753 */
	{73623, 0x1},
	{73645, 0x2},
	/* 4755 */
	{10330, 0x1},
	{117818, 0x2},
	{117831, 0x4},
	{117844, 0x8},
	{117858, 0x10},
	{117873, 0xE0},
	{117890, 0x700},
	{117906, 0x7800},
	{117918, 0x38000},
	/* 4764 */
	{117935, 0x7},
	{117953, 0x38},
	{117975, 0x3C0},
	{117999, 0x3C00},
	{118023, 0x7C000},
	{118047, 0xF80000},
	{118070, 0x3000000},
	/* 4771 */
	{490, 0x1},
	{114593, 0x2},
	{47427, 0x1C},
	{114598, 0xFE0},
	{114645, 0x1000},
	{114610, 0x1E000},
	{75454, 0x3E0000},
	{79081, 0xC00000},
	{114621, 0x7000000},
	{118093, 0x38000000},
	{117716, 0xC0000000},
	/* 4782 */
	{490, 0x1},
	{114593, 0x2},
	{47427, 0x4},
	{114598, 0x8},
	{114610, 0x10},
	{75454, 0x20},
	{79081, 0x40},
	{114621, 0x80},
	{118093, 0x100},
	{114645, 0x800},
	{114664, 0x1000},
	{117716, 0x2000},
	/* 4794 */
	{101442, 0x3FF},
	{102999, 0xF0000000},
	/* 4796 */
	{101442, 0x3F},
	{118099, 0x200},
	{102261, 0x400},
	{102288, 0x800},
	{102315, 0x2000},
	{102341, 0x4000},
	{102367, 0x10000},
	{102394, 0x20000},
	{102420, 0x40000},
	{102446, 0x80000},
	{102474, 0x100000},
	{102500, 0x200000},
	{102526, 0x400000},
	{102579, 0x2000000},
	{102606, 0x4000000},
	{102633, 0x8000000},
	{102660, 0x10000000},
	{102686, 0x20000000},
	{102715, 0x40000000},
	/* 4815 */
	{102768, 0x2},
	{102826, 0x4},
	{102855, 0x8},
	{102883, 0x10},
	{102935, 0x40},
	{102797, 0x100},
	{118126, 0x200},
	{114701, 0x400},
	{118156, 0x2000},
	/* 4824 */
	{101442, 0x3F},
	{102797, 0x40},
	{118126, 0x80},
	{118192, 0x100},
	{118099, 0x200},
	{102261, 0x800},
	{102288, 0x1000},
	{102315, 0x2000},
	{102341, 0x4000},
	{118219, 0x8000},
	{102367, 0x10000},
	{102394, 0x20000},
	{102420, 0x40000},
	{118247, 0x80000},
	{102474, 0x100000},
	{102500, 0x200000},
	{114701, 0x400000},
	{118275, 0x800000},
	{118306, 0x1000000},
	{102579, 0x2000000},
	{102606, 0x4000000},
	{102633, 0x8000000},
	{102660, 0x10000000},
	{102768, 0x20000000},
	{102715, 0x40000000},
	/* 4849 */
	{38, 0x3FFFFF},
	/* 4850 */
	{10508, 0x1FFF},
	/* 4851 */
	{1398, 0x3},
	{114763, 0x8},
	{68418, 0x10},
	{68431, 0x20},
	{58316, 0x1C0},
	{114775, 0x600},
	{68458, 0x800},
	{68471, 0x1000},
	{118334, 0x2000},
	{68501, 0x4000},
	{68512, 0x18000},
	{68535, 0x40000},
	{68554, 0x80000},
	{105488, 0x700000},
	{118350, 0x7800000},
	{105503, 0x10000000},
	{105526, 0x20000000},
	{118369, 0x40000000},
	{68583, 0x80000000},
	/* 4870 */
	{67901, 0x3},
	{67910, 0xF0},
	{67918, 0x200},
	{67925, 0x1FC00},
	{114786, 0x20000},
	{118386, 0x40000},
	{118418, 0x80000},
	/* 4877 */
	{68196, 0xFFF, 2049, 257},
	{114815, 0x1000},
	{105451, 0x2000},
	{118442, 0x4000},
	{68358, 0xFF0000, 129, 2306},
	{68370, 0x3000000},
	{105476, 0x1C000000},
	{68383, 0x80000000},
	/* 4885 */
	{118463, 0x1},
	{118474, 0x2},
	{118485, 0x4},
	{118500, 0x8},
	/* 4889 */
	{667, 0x3FF},
	{105632, 0xFC00},
	/* 4891 */
	{10813, 0xFFF},
	{103889, 0x3000},
	{118515, 0x4000},
	{118550, 0x8000},
	{103907, 0xFFFF0000},
	/* 4896 */
	{12062, 0x3FF},
	/* 4897 */
	{12062, 0x7F},
	/* 4898 */
	{12062, 0x7FF},
	/* 4899 */
	{104318, 0x1},
	{107262, 0x2},
	{107285, 0x4},
	{104407, 0x8},
	{118579, 0x10},
	{104330, 0x20},
	{107326, 0x40},
	{104342, 0x80},
	{107341, 0x100},
	{104352, 0x200},
	{107354, 0x400},
	{104373, 0x800},
	{107378, 0x1000},
	{104390, 0x2000},
	{107398, 0x4000},
	{107418, 0x8000},
	{107435, 0x10000},
	{107455, 0x20000},
	{107472, 0x40000},
	{118590, 0x180000},
	{118605, 0x600000},
	{118620, 0x1800000},
	{118635, 0x6000000},
	{118650, 0xF8000000},
	/* 4923 */
	{55147, 0xFFFFFF},
	/* 4924 */
	{101734, 0x7, 6, 36540},
	{118665, 0x3F8},
	{102162, 0x400},
	{10813, 0xFFFFF800},
	/* 4928 */
	{63466, 0xF},
	{63475, 0xF0},
	{63485, 0x100},
	{63496, 0x200},
	{63501, 0x400},
	{118678, 0x800},
	{63628, 0x7F000, 257, 0},
	{63659, 0x10000000},
	{63665, 0xE0000000},
	/* 4937 */
	{63669, 0x1},
	{63673, 0x6},
	{118687, 0x18},
	{51265, 0x20},
	{63692, 0x40},
	{63700, 0x80},
	{63710, 0x100},
	{63721, 0x200},
	{63727, 0x400},
	{63732, 0x800},
	{63738, 0x1000},
	{54277, 0x2000},
	{63749, 0x4000},
	{118697, 0x8000},
	{63515, 0x10000},
	{63769, 0x20000},
	{63777, 0x40000},
	{63789, 0x80000},
	{115847, 0x100000},
	{115861, 0x200000},
	{118710, 0x400000},
	{118719, 0x800000},
	{118728, 0x7000000},
	{63808, 0x8000000},
	/* 4961 */
	{63820, 0x7F, 257, 0},
	{63865, 0x3F0000},
	{63918, 0xE0000000},
	/* 4964 */
	{59029, 0xF},
	{63926, 0x30},
	{63934, 0xC0},
	{63942, 0xF00},
	{63948, 0x1000},
	{29316, 0x2000},
	{63966, 0xF0000},
	{63972, 0xF00000},
	{63978, 0x7000000},
	{63987, 0x38000000},
	{63996, 0xC0000000},
	/* 4975 */
	{64002, 0x3F},
	{64012, 0x3F00},
	{64022, 0x3F0000},
	{64032, 0xF000000},
	/* 4979 */
	{64077, 0xF},
	{64084, 0x70},
	{64106, 0x1F00},
	{64115, 0xE000},
	/* 4983 */
	{1528, 0xFF},
	/* 4984 */
	{118748, 0x7},
	{118756, 0x8},
	{118767, 0x10},
	{118780, 0xE0},
	{118796, 0x300},
	{118806, 0xC00},
	{118816, 0x70000},
	{64240, 0x380000},
	{118828, 0xC00000},
	{118835, 0x1000000},
	{118842, 0x6000000},
	{78027, 0x8000000},
	{118850, 0x10000000},
	/* 4997 */
	{10442, 0xFF},
	/* 4998 */
	{107726, 0x1},
	{118867, 0x2},
	{64729, 0x4},
	{118882, 0x8},
	{118898, 0x10},
	{64702, 0x20},
	{118907, 0x40},
	{118918, 0x80},
	{118928, 0x100},
	{118938, 0x200},
	{118948, 0x400},
	{118959, 0x800},
	{118970, 0x1000},
	{118982, 0x2000},
	{118991, 0x4000},
	{119001, 0x8000},
	{105417, 0x10000},
	{105434, 0x20000},
	{119010, 0x40000},
	{119028, 0x80000},
	{119043, 0x100000},
	/* 5019 */
	{119059, 0x2},
	{119074, 0x4},
	{119092, 0x8},
	{64826, 0x10},
	{119107, 0x20},
	{119123, 0x40},
	{119137, 0x100},
	{119146, 0x200},
	{119155, 0x400},
	{119176, 0x800},
	{119185, 0x1000},
	{119194, 0x2000},
	{119204, 0x4000},
	{119213, 0x10000},
	{119222, 0x20000},
	{119230, 0x80000},
	{119239, 0x100000},
	{119251, 0x200000},
	{119264, 0x400000},
	{119277, 0x20000000},
	/* 5039 */
	{119286, 0x1},
	{119296, 0x2},
	{119306, 0x4},
	{119316, 0x8},
	{119326, 0x10},
	{119336, 0x20},
	{119346, 0x40},
	{119356, 0x80},
	{119366, 0x100},
	{119376, 0x200},
	{119386, 0x400},
	{119396, 0x800},
	{119406, 0x1000},
	{119416, 0x2000},
	{119426, 0x4000},
	{119436, 0x8000},
	/* 5055 */
	{119446, 0xFF},
	/* 5056 */
	{119459, 0x3F},
	{119478, 0xFC0},
	/* 5058 */
	{64385, 0xF},
	{64614, 0x1},
	{64408, 0x10},
	{64431, 0x20},
	{64454, 0x40},
	{64474, 0x80},
	{64494, 0x100},
	{64746, 0x100},
	{64514, 0x200},
	{65684, 0x200},
	{64534, 0x400},
	{64554, 0x800},
	{64574, 0x1000},
	{64594, 0x2000},
	{64764, 0x10000000},
	{64773, 0x20000000},
	{64782, 0x40000000},
	/* 5075 */
	{119489, 0xF},
	{119498, 0xF0},
	/* 5077 */
	{64802, 0xF},
	{119507, 0x20},
	{64841, 0x80},
	{64864, 0x100},
	{64887, 0x200},
	{64906, 0x1000},
	{64915, 0x2000},
	{64924, 0x4000},
	{64932, 0x8000},
	{119523, 0x10000},
	{119538, 0x20000},
	{119547, 0x40000},
	{119562, 0x80000},
	{64956, 0x100000},
	{119570, 0x200000},
	{64972, 0x400000},
	{64981, 0x800000},
	{64990, 0x1000000},
	{64998, 0x2000000},
	{65006, 0x4000000},
	{65014, 0x10000000},
	{64756, 0x20000000},
	{65032, 0x40000000},
	{65040, 0x80000000},
	/* 5101 */
	{64906, 0x2},
	{64915, 0x4},
	{64981, 0x400000},
	{119538, 0x800000},
	{64998, 0x1000000},
	{64924, 0x2000000},
	{64956, 0x4000000},
	{64972, 0x8000000},
	{64990, 0x20000000},
	{65006, 0x40000000},
	{65032, 0x80000000},
	/* 5112 */
	{119578, 0x1},
	{119592, 0x4},
	{119607, 0x10000},
	{119622, 0x20000},
	{119637, 0x40000},
	{119652, 0x80000},
	/* 5118 */
	{119667, 0x3F},
	/* 5119 */
	{100796, 0xFF},
	{119684, 0xFF00},
	{100751, 0xFF0000},
	{119693, 0x20000000},
	{100831, 0x40000000},
	{100857, 0x80000000},
	/* 5125 */
	{119713, 0xF},
	{119730, 0x1F00},
	/* 5127 */
	{55850, 0xFF},
	/* 5128 */
	{119745, 0x2},
	{119756, 0x20},
	{119767, 0x40},
	{119788, 0x80},
	{119808, 0xF00},
	{119830, 0x1000},
	/* 5134 */
	{119856, 0x1},
	{119864, 0x2},
	{119872, 0x2},
	{119881, 0x8},
	{119897, 0x10},
	{119913, 0x40},
	{119934, 0x80},
	{119955, 0x100},
	{119976, 0x200},
	{119984, 0x200},
	{120005, 0x400},
	{120026, 0x800},
	{120047, 0x1000},
	{120068, 0x2000},
	{120089, 0x4000},
	{120110, 0x8000},
	{120131, 0x10000},
	{120152, 0x20000},
	{120173, 0x40000},
	{120194, 0x80000},
	{120215, 0x100000},
	{120236, 0x200000},
	/* 5156 */
	{120257, 0x3FFFC},
	{120270, 0x300000},
	{120282, 0xC00000},
	{55903, 0x80000000},
	/* 5160 */
	{120292, 0x1},
	{120309, 0x80000},
	/* 5162 */
	{101442, 0x3F},
	{102261, 0x400},
	{102288, 0x800},
	{120329, 0x1000},
	{102315, 0x2000},
	{102341, 0x4000},
	{102367, 0x10000},
	{102394, 0x20000},
	{102420, 0x40000},
	{102446, 0x80000},
	{102474, 0x100000},
	{102500, 0x200000},
	{102526, 0x400000},
	{120356, 0x800000},
	{102552, 0x1000000},
	{102579, 0x2000000},
	{102606, 0x4000000},
	{120382, 0x8000000},
	{120408, 0x10000000},
	/* 5181 */
	{101442, 0x3F},
	{102261, 0x400},
	{102288, 0x800},
	{102315, 0x1000},
	{102341, 0x2000},
	{102367, 0x8000},
	{102394, 0x10000},
	{102474, 0x20000},
	{102500, 0x40000},
	{120329, 0x80000},
	{102420, 0x100000},
	{102579, 0x200000},
	/* 5193 */
	{55928, 0x3FFFF},
	/* 5194 */
	{120434, 0x1},
	{120447, 0x2},
	{120451, 0x4},
	{120473, 0x8},
	{120487, 0x10},
	{120501, 0x20},
	{120519, 0x40},
	{120537, 0x80},
	{29316, 0x2000000},
	{106647, 0xC000000},
	/* 5204 */
	{99531, 0x3},
	{10413, 0xFFFFFFFC},
	/* 5206 */
	{120552, 0x3},
	{24776, 0xFFFFFFFC},
	/* 5208 */
	{120573, 0x3},
	{25292, 0xFFFFFFFC},
	/* 5210 */
	{99505, 0xFF},
	{99517, 0x30000},
	{27101, 0xE0000000},
	/* 5213 */
	{120594, 0x3},
	{26651, 0xFFFFFFFC},
	/* 5215 */
	{26669, 0xFF},
	/* 5216 */
	{120611, 0x3},
	{26723, 0xFFFFFFFC},
	/* 5218 */
	{26741, 0xFF},
	/* 5219 */
	{26800, 0xFF},
	{99541, 0x10000},
	{99557, 0x100000},
	{99573, 0x3000000},
	{99589, 0xE0000000},
	/* 5224 */
	{100496, 0x1},
	{100512, 0x2},
	{100528, 0x40},
	{100546, 0x80},
	{100564, 0x100},
	{100582, 0x200},
	{100600, 0x400},
	{100618, 0x800},
	{100636, 0x1000},
	{100654, 0x2000},
	{100672, 0x4000},
	{99791, 0x8000},
	{120628, 0x10000},
	{99811, 0x40000},
	{100689, 0x80000},
	{100705, 0x200000},
	{99828, 0x400000},
	{99844, 0x800000},
	{99858, 0x2000000},
	{99872, 0x4000000},
	{99886, 0x8000000},
	{99907, 0x10000000},
	{99932, 0x20000000},
	/* 5247 */
	{100721, 0xFF},
	{99977, 0x3000000},
	{120646, 0x40000000},
	{1411, 0x80000000},
	/* 5251 */
	{27038, 0xFF},
	/* 5252 */
	{27079, 0xFF},
	/* 5253 */
	{99982, 0x1FFFFF},
	{100020, 0x200000},
	{120660, 0xC00000},
	{120669, 0x3000000},
	{99993, 0x4000000},
	{99997, 0x8000000},
	{100001, 0x10000000},
	{100006, 0x20000000},
	{100011, 0x40000000},
	/* 5262 */
	{100061, 0x30},
	{100073, 0xF0000},
	{100086, 0x10000000},
	{100101, 0x20000000},
	{100115, 0xC0000000},
	/* 5267 */
	{100176, 0x1},
	/* 5268 */
	{120678, 0x1},
	{120703, 0x2},
	{120741, 0x4},
	{120782, 0x8},
	{120805, 0x10},
	{120828, 0x20},
	{120852, 0x40},
	{120882, 0x80},
	{120911, 0x100},
	{120942, 0x400},
	{120968, 0x800},
	{120997, 0x1000},
	{121022, 0x2000},
	{67377, 0x4000},
	{67398, 0x8000},
	/* 5283 */
	{121057, 0x1},
	{121084, 0x4},
	{121111, 0x10},
	{121140, 0x400},
	{121169, 0x800},
	{121198, 0x1000},
	{121226, 0x2000},
	{121256, 0x4000},
	{121283, 0x8000},
	{121311, 0x10000},
	{121337, 0x20000},
	{121363, 0x800000},
	{121388, 0x1000000},
	{121414, 0x2000000},
	{121439, 0x4000000},
	{121463, 0x8000000},
	{121488, 0x10000000},
	{121517, 0x10000000},
	/* 5301 */
	{121545, 0x1},
	{121571, 0x2},
	{121597, 0x4},
	{121624, 0x10},
	{121650, 0x20},
	{121672, 0x40},
	{121693, 0x80},
	{121725, 0x100},
	{121752, 0x200},
	{121774, 0x400},
	{121798, 0x800},
	{121823, 0x1000},
	{121846, 0x2000},
	{121873, 0x4000},
	{121898, 0x8000},
	{121926, 0x10000},
	{121951, 0x20000},
	{121976, 0x40000},
	{122001, 0x80000},
	{122030, 0x100000},
	{122061, 0x200000},
	{122089, 0x400000},
	{122116, 0x800000},
	{122146, 0x1000000},
	{122173, 0x2000000},
	{122200, 0x4000000},
	{122227, 0x8000000},
	{122253, 0x10000000},
	{122277, 0x20000000},
	{122309, 0x40000000},
	{122336, 0x80000000},
	/* 5332 */
	{66714, 0x1},
	{122362, 0x40},
	{122381, 0x80},
	{122401, 0x100},
	{122420, 0x200},
	{122434, 0x400},
	{122447, 0x1000},
	{122469, 0x2000},
	{122492, 0x4000},
	{122513, 0x8000},
	{122530, 0x20000},
	{122545, 0x40000},
	{122559, 0x80000},
	{122573, 0x100000},
	{122589, 0x200000},
	{122602, 0x400000},
	/* 5348 */
	{122621, 0x80},
	{122636, 0x100},
	{66398, 0x200},
	{66412, 0x400},
	{66431, 0x800},
	{66450, 0x1000},
	{107765, 0x2000},
	{122425, 0x8000},
	{122651, 0x10000},
	{122439, 0x20000},
	{122660, 0x40000},
	{66526, 0x80000},
	{66541, 0x100000},
	{122671, 0x200000},
	{64703, 0x400000},
	{66574, 0x800000},
	{65391, 0x1000000},
	{122689, 0x2000000},
	{122594, 0x4000000},
	{65381, 0x8000000},
	{66465, 0x10000000},
	{66482, 0x20000000},
	{66504, 0x40000000},
	{64756, 0x80000000},
	/* 5372 */
	{2270, 0x3F},
	{122702, 0x3F00},
	{122717, 0x3F0000},
	/* 5375 */
	{56272, 0x1F},
	/* 5376 */
	{122732, 0xF},
	{122755, 0x3F00},
	/* 5378 */
	{122776, 0xF},
	/* 5379 */
	{122795, 0x10},
	{122816, 0x40},
	{122838, 0x100},
	{54274, 0x1000000},
	{122859, 0x2000000},
	{122867, 0x4000000},
	{122876, 0x8000000},
	{122885, 0x10000000},
	{122893, 0x20000000},
	/* 5388 */
	{122901, 0xFF},
	{122922, 0x700},
	{122943, 0xFF00000},
	{122963, 0x70000000},
	/* 5392 */
	{122983, 0x1},
	/* 5393 */
	{123004, 0xFFFFF},
	/* 5394 */
	{123012, 0xFFFFFFF},
	{123028, 0xF0000000},
	/* 5396 */
	{123044, 0xFFFF},
	{123059, 0xFFFF0000},
	/* 5398 */
	{27774, 0xFF},
	/* 5399 */
	{27828, 0xFF},
	/* 5400 */
	{27880, 0xFF},
	/* 5401 */
	{28011, 0xFF},
	/* 5402 */
	{123075, 0xFF},
	{123085, 0xFF00},
	{123095, 0xFF0000},
	{123108, 0xFF000000},
	/* 5406 */
	{123121, 0xFF},
	{123134, 0xFF00},
	{123147, 0xFF0000},
	{123160, 0xFF000000},
	/* 5410 */
	{123173, 0xFF},
	{123184, 0xFF00},
	{123195, 0xFF0000},
	/* 5413 */
	{123206, 0x3F},
	{123220, 0x3F00},
	/* 5415 */
	{123234, 0xFF},
	{123245, 0xFF00},
	/* 5417 */
	{123256, 0x7FF},
	{123269, 0x7FF0000},
	/* 5419 */
	{123281, 0x1FF},
	/* 5420 */
	{123289, 0x7FF},
	/* 5421 */
	{123301, 0x3FF},
	/* 5422 */
	{56576, 0x7FF},
	{123309, 0x3000},
	{123320, 0x30000},
	/* 5425 */
	{123334, 0x3FF},
	{123351, 0x3FF0000},
	/* 5427 */
	{123368, 0x3FF},
	{123387, 0x3FF0000},
	/* 5429 */
	{123406, 0x3FF},
	{123425, 0x3FF0000},
	/* 5431 */
	{123444, 0x3FF},
	/* 5432 */
	{123453, 0x3FF},
	{123462, 0x3FF0000},
	/* 5434 */
	{123471, 0x7FF},
	{123484, 0x7FF0000},
	/* 5436 */
	{123496, 0x7FF},
	/* 5437 */
	{123508, 0x3FF},
	{123525, 0x3FF0000},
	/* 5439 */
	{123542, 0x3FF},
	{123561, 0x3FF0000},
	/* 5441 */
	{123580, 0x3FF},
	{123599, 0x3FF0000},
	/* 5443 */
	{123618, 0x4000},
	{123644, 0x20000},
	{123674, 0x80000},
	{123697, 0x100000},
	{123721, 0x400000},
	{123745, 0x800000},
	{123767, 0x1000000},
	{123793, 0x4000000},
	{123817, 0x8000000},
	{123849, 0x20000000},
	{123871, 0x40000000},
	{123893, 0x80000000},
	/* 5455 */
	{101442, 0xFF},
	{101451, 0xFFC00},
	{102999, 0xF00000},
	{103020, 0xF000000},
	{103053, 0xF0000000},
	/* 5460 */
	{101442, 0xFF},
	{103053, 0xF0000000},
	/* 5462 */
	{123915, 0x3FF},
	/* 5463 */
	{57042, 0x1FF},
	/* 5464 */
	{57066, 0x3F},
	/* 5465 */
	{57089, 0x3F},
	/* 5466 */
	{86697, 0x7},
	{123926, 0x70000},
	/* 5468 */
	{57134, 0x3},
	{123939, 0x20},
	{123958, 0xC0},
	{123972, 0x200},
	{123984, 0x800},
	{124005, 0x1000},
	{124022, 0x2000},
	{124043, 0x1F0000},
	/* 5476 */
	{124052, 0x7F},
	{91192, 0x80},
	{124073, 0x3FFF00},
	{91257, 0xFFC00000},
	/* 5480 */
	{124090, 0x1F},
	/* 5481 */
	{124101, 0x3},
	/* 5482 */
	{119562, 0x1},
	{124119, 0x2},
	{124131, 0x4},
	{124147, 0x8},
	{124159, 0x10},
	/* 5487 */
	{124171, 0x3F},
	{124186, 0x40},
	/* 5489 */
	{124206, 0x3F},
	{124220, 0x40},
	/* 5491 */
	{119538, 0x1},
	{124239, 0x2},
	{124257, 0x4},
	{124270, 0x8},
	{124282, 0x10},
	{124294, 0x20},
	{124306, 0x40},
	{124318, 0x80},
	{124330, 0x100},
	{124342, 0x200},
	/* 5501 */
	{124356, 0xFF},
	/* 5502 */
	{18912, 0x3F, 29, 37176},
	/* 5503 */
	{214, 0x3, 2, 36326},
	/* 5504 */
	{124564, 0xF},
	{124573, 0xFF0},
	{124588, 0x1000000},
	{124603, 0x2000000},
	{124615, 0x4000000},
	{124626, 0x8000000},
	{124641, 0x10000000},
	{124656, 0x20000000},
	{124668, 0x40000000},
	{124682, 0x80000000},
	/* 5514 */
	{10330, 0x1},
	{10560, 0x1E},
	/* 5516 */
	{124564, 0xF},
	{124573, 0xFF0},
	{124588, 0x1000000},
	{124603, 0x2000000},
	{124615, 0x4000000},
	{124626, 0x8000000},
	{124641, 0x10000000},
	{124668, 0x20000000},
	{124695, 0x20000000},
	{124682, 0x80000000},
	/* 5526 */
	{124710, 0x1},
	{124723, 0x7E},
	{124740, 0x80},
	/* 5529 */
	{100877, 0x7F},
	{100943, 0x600, 4, 36536},
	/* 5531 */
	{124765, 0x6},
	{124775, 0x8},
	{124795, 0x10},
	{124804, 0xFFFF0000},
	/* 5535 */
	{124817, 0x1F},
	/* 5536 */
	{124831, 0x80000000},
	/* 5537 */
	{124839, 0x1},
	{124860, 0x6},
	{124873, 0x8},
	{124896, 0x10},
	{124916, 0x20},
	{124935, 0x10000000},
	{124946, 0x20000000},
	{124957, 0x40000000},
	{124968, 0x80000000},
	/* 5546 */
	{124564, 0xF},
	{124573, 0xFF0},
	{124588, 0x1000000},
	{124979, 0x2000000},
	{124994, 0x4000000},
	{124626, 0x8000000},
	{124641, 0x10000000},
	{125009, 0x20000000},
	{125025, 0x40000000},
	{125041, 0x80000000},
	/* 5556 */
	{125058, 0x80000000},
	/* 5557 */
	{18896, 0xFF},
	/* 5558 */
	{101442, 0x1FF},
	{101451, 0xFFC00},
	{102999, 0xF00000},
	/* 5561 */
	{125066, 0xFFFF},
	{125088, 0xFFFF0000},
	/* 5563 */
	{124564, 0xF},
	{124573, 0xFF0},
	{124588, 0x1000000},
	{124979, 0x2000000},
	{124994, 0x4000000},
	{124626, 0x8000000},
	{124641, 0x10000000},
	{124695, 0x20000000},
	{125110, 0x40000000},
	{125125, 0x80000000},
	/* 5573 */
	{125140, 0x3F},
	{125167, 0x7FC0},
	{125193, 0x1F8000},
	{125215, 0xFF800000},
	/* 5577 */
	{125240, 0x3F},
	{125264, 0xFC0},
	{125288, 0x3F000},
	{125308, 0xFC0000},
	/* 5581 */
	{125328, 0x3F},
	/* 5582 */
	{125342, 0x1},
	{125368, 0x2},
	{125391, 0x4},
	{125416, 0x8},
	{125447, 0x10},
	{125481, 0x20},
	{125501, 0xC0},
	{125528, 0x100},
	{125556, 0x200},
	{125591, 0x400},
	{125621, 0x800},
	{125656, 0x1000},
	{125686, 0x2000},
	{125709, 0x4000},
	{125748, 0x8000},
	{125780, 0x10000},
	{125816, 0x20000},
	{125846, 0x40000},
	{125892, 0x80000},
	{125933, 0x100000},
	{125983, 0x200000},
	{126033, 0x400000},
	{126084, 0x800000},
	{126132, 0x1000000},
	{124957, 0x40000000},
	{124968, 0x80000000},
	/* 5608 */
	{100789, 0xFF},
	{118678, 0x100},
	{126178, 0x200},
	{126197, 0x400},
	{126218, 0x800},
	{126237, 0x1000},
	{126259, 0x2000},
	{126280, 0x4000},
	{126303, 0x8000},
	/* 5617 */
	{126333, 0x3},
	{126349, 0xC},
	{126365, 0x30},
	{126381, 0x40},
	{126396, 0x80},
	{126414, 0x100},
	{126429, 0x200},
	{126448, 0x400},
	{126466, 0x800},
	/* 5626 */
	{126487, 0x1},
	{126503, 0x2},
	{126519, 0x4},
	/* 5629 */
	{126539, 0x7F},
	{126543, 0x380},
	{126547, 0x1FFC00},
	/* 5632 */
	{126551, 0x3F},
	{126564, 0xF00},
	{115070, 0x10000000},
	{126576, 0x20000000},
	{120537, 0x40000000},
	{120506, 0x80000000},
	/* 5638 */
	{126590, 0xF},
	{126610, 0xF00},
	{126627, 0x30000},
	{126643, 0xC0000},
	/* 5642 */
	{64283, 0x1},
	{94453, 0x2, 4, 36416},
	{94388, 0x4, 2, 36414},
	{20206, 0x8, 4, 36410},
	{94306, 0x10, 2, 36408},
	{94275, 0x20, 4, 36404},
	{103149, 0x40},
	{103155, 0x1F00},
	{103165, 0x2000},
	/* 5651 */
	{126663, 0xF0000},
	{126681, 0xF00000},
	{126699, 0xF000000},
	{126717, 0xF0000000},
	/* 5655 */
	{64635, 0x1},
	{126735, 0x2},
	{126754, 0xFFF0},
	{126769, 0xFFF0000},
	/* 5659 */
	{101442, 0x1FF},
	{103135, 0xF000},
	{126784, 0xF0000},
	{50481, 0xF00000},
	{126800, 0xF000000},
	{103053, 0xF0000000},
	/* 5665 */
	{126810, 0xFFFF},
	{126826, 0xFFFF0000},
	/* 5667 */
	{124564, 0xF},
	{124573, 0xFF0},
	{124668, 0x40000000},
	{124682, 0x80000000},
	/* 5671 */
	{59029, 0xF},
	{63926, 0x30},
	{126842, 0xFC0},
	{126852, 0x1000},
	{126862, 0x2000},
	{119446, 0x4000},
	{126873, 0x8000},
	{452, 0xFFFF0000},
	/* 5679 */
	{126883, 0x1F},
	{126890, 0x20},
	{68445, 0x80},
	{126897, 0x3000},
	{68458, 0x4000},
	{68471, 0x8000},
	{126908, 0xFFFF0000},
	{126908, 0xFFFF0000},
	/* 5687 */
	{2548, 0xFFFF},
	{126920, 0xFF0000},
	{68483, 0x1000000},
	/* 5690 */
	{126929, 0xFFFF},
	{126938, 0xFFFF0000},
	/* 5692 */
	{2506, 0x3FFFFFFF},
	{126947, 0xC0000000},
	/* 5694 */
	{68597, 0x7},
	{68612, 0x70000},
	{126959, 0x20000000},
	{64635, 0x40000000},
	{77058, 0x80000000},
	/* 5699 */
	{126967, 0x7},
	{126975, 0x38},
	{126983, 0x1C0},
	{126991, 0xE00},
	{126999, 0x7000},
	{127007, 0x38000},
	{127015, 0x1C0000},
	{1398, 0x600000},
	{127023, 0x1800000},
	{127036, 0x2000000},
	{51265, 0x4000000},
	{127049, 0x18000000},
	{127060, 0x20000000},
	{68418, 0x40000000},
	{73369, 0x80000000},
	/* 5714 */
	{127070, 0x80000000},
	/* 5715 */
	{58316, 0x7},
	/* 5716 */
	{127083, 0x3FFF},
	{127093, 0x3FFF0000},
	{127103, 0xC0000000},
	/* 5719 */
	{127116, 0x3FFF},
	{127132, 0x3FF0000},
	{127157, 0x78000000},
	{127182, 0x80000000},
	/* 5723 */
	{77755, 0x1},
	{77327, 0x2},
	{11680, 0x4},
	/* 5726 */
	{127196, 0xFF},
	{127205, 0xFF00},
	{127214, 0xFF0000},
	{127223, 0xFF000000},
	/* 5730 */
	{127232, 0x3F},
	{127240, 0x1F00},
	{127249, 0x1FF0000},
	/* 5733 */
	{127258, 0x3F},
	{127266, 0x1F00},
	{127275, 0x1FF0000},
	/* 5736 */
	{59029, 0xF},
	{63926, 0x30},
	{30927, 0x1C0},
	{63972, 0x1E00},
	/* 5740 */
	{68798, 0x7, 8, 37205},
	{68808, 0x38, 8, 37205},
	{68818, 0x1C0, 8, 37205},
	{68828, 0xE00, 8, 37205},
	{114610, 0x7000, 8, 37213},
	{114598, 0x78000, 16, 37221},
	{127929, 0x180000},
	{73065, 0x600000},
	{73078, 0x800000},
	{92487, 0x1000000},
	{127942, 0x2000000},
	{127954, 0x4000000},
	{92500, 0x38000000},
	{220, 0xC0000000, 4, 37237},
	/* 5754 */
	{68753, 0xFF},
	{73399, 0xFFF00},
	{114598, 0x3F00000, 64, 37241},
	{114610, 0x3C000000, 16, 37305},
	{92500, 0xC0000000},
	/* 5759 */
	{75103, 0x3FFF},
	{75210, 0xFFFC000},
	{75613, 0x70000000},
	{130012, 0x80000000},
	/* 5763 */
	{68798, 0x7, 8, 37205},
	{68808, 0x38, 8, 37205},
	{68818, 0x1C0, 8, 37205},
	{68828, 0xE00, 8, 37205},
	{75432, 0xF000},
	{75443, 0xF0000},
	{130023, 0x1F00000},
	{130036, 0x2000000},
	{92500, 0x4000000},
	{92487, 0x8000000},
	{220, 0xF0000000, 16, 37321},
	/* 5774 */
	{18896, 0x1FFF},
	{21612, 0x7FFE000},
	/* 5776 */
	{75569, 0x1FFF},
	{130347, 0x3FFE000},
	/* 5778 */
	{75600, 0xFFF},
	{75664, 0xFF000},
	{75637, 0x100000},
	{130358, 0xFFE00000},
	/* 5782 */
	{73210, 0x7, 8, 37337},
	{73218, 0x38, 8, 37337},
	{73226, 0x1C0, 8, 37337},
	{73234, 0xE00},
	{73250, 0x7000, 8, 37345},
	{73269, 0x8000},
	{73288, 0x70000},
	{73304, 0x80000},
	{73319, 0x100000},
	{73333, 0x7E00000},
	{73344, 0x8000000},
	{73356, 0x10000000},
	{73374, 0x60000000, 3, 37353},
	/* 5795 */
	{73431, 0x3FFF},
	{73440, 0xFC000},
	{73453, 0x300000, 4, 37356},
	{73467, 0xC00000, 4, 37356},
	{73481, 0x3000000, 3, 37360},
	{73490, 0xC000000, 3, 37363},
	{73501, 0x10000000},
	{131099, 0x20000000},
	{131116, 0x40000000},
	/* 5804 */
	{73550, 0xFFF},
	{131132, 0x20000000},
	{73567, 0xC0000000, 4, 37366},
	/* 5807 */
	{73755, 0x7},
	{73765, 0x70},
	{131274, 0x700},
	{73807, 0x3000},
	{131295, 0x70000},
	{131319, 0x700000},
	{131328, 0x3000000},
	{131348, 0x30000000},
	{131357, 0x40000000},
	/* 5816 */
	{131407, 0x3, 4, 37370},
	{74196, 0x3C, 16, 2765},
	{74624, 0x7C0, 18, 2781},
	{74814, 0x3800, 7, 2800},
	{74973, 0x1C00000, 5, 2807},
	{74993, 0x6000000},
	/* 5822 */
	{75971, 0x3F},
	{75977, 0x3C0},
	{73595, 0xC00},
	{76067, 0xFF000, 193, 2834},
	{51265, 0x100000},
	{63485, 0x200000},
	{116486, 0x400000},
	{76078, 0x800000},
	{76088, 0x1000000},
	{131423, 0xE000000},
	{116497, 0x10000000},
	/* 5833 */
	{76117, 0x1},
	{76128, 0x3E},
	{76138, 0x40},
	{76151, 0x80},
	{76163, 0xFF00},
	{63628, 0x7F0000, 257, 0},
	/* 5839 */
	{75971, 0x3F},
	{75977, 0x3C0},
	{73595, 0xC00},
	{76067, 0xFF000, 193, 2834},
	{51265, 0x100000},
	{63485, 0x200000},
	{116486, 0x400000},
	{76078, 0x800000},
	{76608, 0x3000000},
	{76622, 0x4000000},
	{131423, 0x38000000},
	{116497, 0x40000000},
	/* 5851 */
	{76117, 0x1},
	{76128, 0x3E},
	{76138, 0x40},
	{76638, 0x80},
	{76648, 0x100},
	{76660, 0x200},
	{76672, 0x400},
	{76684, 0x800},
	{76696, 0x1000},
	{63628, 0xFE000, 257, 0},
	/* 5861 */
	{75971, 0x3F},
	{75977, 0x3C0},
	{73595, 0xC00},
	{76067, 0xFF000, 193, 2834},
	{51265, 0x100000},
	{63485, 0x200000},
	{116486, 0x400000},
	{76078, 0x800000},
	{76622, 0x1000000},
	{131423, 0xE000000},
	{116497, 0x10000000},
	/* 5872 */
	{76117, 0x1},
	{76128, 0x3E},
	{76138, 0x40},
	{63628, 0x3F80, 257, 0},
	/* 5876 */
	{76117, 0x1},
	{76128, 0x3E},
	{76138, 0x40},
	{76638, 0x80},
	{63628, 0x7F00, 257, 0},
	{64051, 0x1FF00000},
	/* 5882 */
	{75971, 0x3F},
	{75977, 0x3C0},
	{73595, 0xC00},
	{76067, 0xFF000, 193, 2834},
	{51265, 0x100000},
	{63485, 0x200000},
	{116486, 0x400000},
	{76078, 0x800000},
	{131423, 0x7000000},
	{116497, 0x8000000},
	/* 5892 */
	{76117, 0x1},
	{76128, 0x3E},
	{76138, 0x40},
	{76638, 0x80},
	{76844, 0x100},
	{63628, 0xFE00, 257, 0},
	/* 5898 */
	{75971, 0x3F},
	{75977, 0x3C0},
	{73595, 0xC00},
	{76067, 0xFF000, 193, 2834},
	{51265, 0x100000},
	{63485, 0x200000},
	{116486, 0x400000},
	{76078, 0x800000},
	{76608, 0x3000000},
	{131423, 0x1C000000},
	{116497, 0x20000000},
	/* 5909 */
	{76117, 0x1},
	{76128, 0x3E},
	{76138, 0x40},
	{64051, 0xFF80},
	{63628, 0x7F0000, 257, 0},
	/* 5914 */
	{76855, 0x1},
	{76873, 0x2},
	{76887, 0x4},
	{76906, 0x8},
	{76926, 0x10},
	{76946, 0x20},
	{76968, 0x40},
	{131433, 0x380},
	{76979, 0x400},
	{76997, 0x800},
	{118710, 0x1000},
	{77029, 0x4000},
	/* 5926 */
	{59025, 0xFFF},
	/* 5927 */
	{402, 0xFF},
	{118719, 0x100},
	/* 5929 */
	{75971, 0x3F},
	{75977, 0x3C0},
	{73595, 0xC00},
	{76067, 0xFF000, 193, 2834},
	{51265, 0x100000},
	{63485, 0x200000},
	{116486, 0x400000},
	{76078, 0x800000},
	{77082, 0x1000000},
	{116497, 0x2000000},
	/* 5939 */
	{77145, 0x3F},
	{131453, 0x3F},
	{77158, 0xF000},
	{77168, 0x3F0000},
	{77183, 0x400000},
	{77198, 0x800000},
	{77214, 0x7000000},
	/* 5946 */
	{131471, 0xFFFF},
	{131481, 0xFFFF0000},
	/* 5948 */
	{43402, 0x1},
	{131491, 0x2},
	{131500, 0x4},
	{131509, 0x8},
	{131517, 0x10},
	{131529, 0x20},
	{131541, 0x40},
	{131553, 0x80},
	{131565, 0x100},
	{131576, 0x200},
	{131586, 0x400},
	{131594, 0x800},
	{131620, 0x1000},
	{131633, 0x2000},
	{131644, 0x4000},
	{131654, 0x8000},
	{131668, 0x10000},
	{131684, 0x20000},
	{131700, 0x40000},
	{131716, 0x80000},
	{131727, 0x100000},
	{131744, 0x200000},
	{131760, 0x400000},
	{131779, 0x2000000},
	{131793, 0x4000000},
	{131802, 0x8000000},
	{131816, 0x30000000},
	{131831, 0x40000000},
	{131840, 0x80000000},
	/* 5977 */
	{77535, 0x1},
	{77559, 0x2},
	{77649, 0x70},
	{77661, 0xF00},
	{77674, 0xF000},
	{77687, 0xF0000},
	{77700, 0xF00000},
	{77714, 0xF000000},
	{77732, 0xF0000000},
	/* 5986 */
	{77749, 0x7FF},
	{77776, 0xFFE000},
	{77786, 0x1000000},
	{77798, 0x2000000},
	/* 5990 */
	{131854, 0xF},
	{74196, 0xF0, 16, 2765},
	{74624, 0x1F00, 18, 2781},
	{75098, 0x6000, 4, 2812},
	{75205, 0x18000, 4, 2816},
	{75317, 0x60000, 4, 2820},
	{75404, 0x180000, 4, 2824},
	/* 5997 */
	{17750, 0x3, 4, 3051},
	{79081, 0xC},
	{74814, 0xE000, 7, 2800},
	{98877, 0x700000},
	{79232, 0x8000000},
	{79247, 0x10000000},
	{79257, 0x20000000},
	{79277, 0x80000000},
	/* 6005 */
	{17750, 0x1, 2, 3059},
	{74814, 0xE000, 7, 2800},
	{98877, 0x700000},
	{79232, 0x8000000},
	{79320, 0x20000000},
	/* 6010 */
	{131873, 0x7FF},
	{131888, 0x3FF800},
	/* 6012 */
	{131904, 0x3FFFFF},
	/* 6013 */
	{59239, 0x3},
	/* 6014 */
	{83861, 0x3F},
	{83872, 0x40},
	{83915, 0x4000},
	/* 6017 */
	{12057, 0xFF},
	/* 6018 */
	{87419, 0x8},
	{1398, 0x70, 6, 36013},
	{86692, 0xFF0000, 256, 36021},
	/* 6021 */
	{18912, 0x1F, 29, 37176},
	{90999, 0x4000},
	{91012, 0x8000},
	{91025, 0x70000},
	/* 6025 */
	{92139, 0x3F, 3, 36322},
	{92152, 0x3F00, 3, 36322},
	{92167, 0x3F0000, 3, 36322},
	{92182, 0xFC00000, 3, 36322},
	{92197, 0x80000000},
	/* 6030 */
	{214, 0x3, 2, 36326},
	{92334, 0xC, 4, 36329},
	{92414, 0x30, 3, 36333},
	{92474, 0xC0, 4, 37374},
	{92487, 0x100},
	{86860, 0x200},
	{92491, 0x400},
	/* 6037 */
	{93710, 0x3F, 60, 37378},
	{68758, 0x7FC0000},
	{93721, 0x8000000},
	/* 6040 */
	{98463, 0x1},
	{93924, 0x2},
	{132032, 0x4},
	{132055, 0x8},
	{132063, 0x3F0},
	{132078, 0xFC00},
	{94003, 0x10000},
	/* 6047 */
	{220, 0x3, 3, 36420},
	{94785, 0x1C, 4, 36423},
	{94862, 0xE0, 4, 36427},
	{94871, 0x100},
	{94891, 0x200},
	{94902, 0x3C00},
	{94924, 0x4000},
	{92474, 0x18000, 4, 37374},
	/* 6055 */
	{95291, 0x1},
	{95306, 0x2},
	{95321, 0x4},
	{95336, 0x8},
	{95351, 0x70},
	{95383, 0xF00},
	{95400, 0x80000000},
	/* 6062 */
	{97752, 0x3, 4, 36472},
	{17750, 0x7C, 24, 36476},
	{73846, 0x80},
	{98350, 0x700, 8, 36508},
	{98406, 0x1800, 4, 36516},
	{87468, 0x2000},
	{78369, 0x4000},
	{98416, 0x8000},
	{98428, 0x10000},
	{98441, 0x20000},
	{96020, 0x40000},
	{98454, 0x80000},
	{98681, 0x700000, 8, 36520},
	{98703, 0x3800000, 8, 36520},
	{98727, 0x4000000},
	/* 6077 */
	{100317, 0xF00, 5, 36564},
	{104947, 0x10000},
	{104959, 0x100000},
	{104974, 0xC0000000, 4, 36570},
	/* 6081 */
	{27038, 0xFFFF},
	{100317, 0x300000, 2, 36574},
	{105022, 0x8000000, 2, 36570},
	{105044, 0x60000000, 3, 36578},
	{105052, 0x80000000},
	/* 6086 */
	{99982, 0x1FFFFF},
	{105090, 0x200000},
	{120660, 0xC00000, 4, 37438},
	{120669, 0x3000000, 4, 37438},
	{99993, 0x4000000, 2, 36582},
	{99997, 0x8000000, 2, 36582},
	{100001, 0x10000000, 2, 36584},
	{100006, 0x20000000, 2, 36584},
	{100011, 0x40000000},
	/* 6095 */
	{105022, 0x1, 2, 36570},
	{100317, 0x300000, 2, 36574},
	{105044, 0x60000000, 3, 36578},
	{105052, 0x80000000},
	/* 6099 */
	{63466, 0xF},
	{63475, 0xF0},
	{63485, 0x100},
	{63496, 0x200},
	{63501, 0x400},
	{118678, 0x800},
	{63628, 0x1FF000, 257, 0},
	{63659, 0x10000000},
	{63665, 0xE0000000},
	/* 6108 */
	{63820, 0x1FF, 257, 0},
	{63865, 0x3F0000},
	{63918, 0xE0000000},
	/* 6111 */
	{59029, 0xF},
	{63926, 0x30},
	{63934, 0xC0},
	{63942, 0xF00},
	{63948, 0x1000},
	{29316, 0x6000},
	{63966, 0xF0000},
	{63972, 0xF00000},
	{63978, 0x7000000},
	{63987, 0x38000000},
	{63996, 0xC0000000},
	/* 6122 */
	{64077, 0xF},
	{64084, 0x70},
	{64106, 0xF00},
	{64115, 0x7000},
	/* 6126 */
	{64385, 0xF},
	{64408, 0x10},
	{64431, 0x20},
	{64454, 0x40},
	{64474, 0x80},
	{64494, 0x100},
	{64514, 0x200},
	{64534, 0x400},
	{64554, 0x800},
	{64574, 0x1000},
	{64594, 0x2000},
	{64614, 0x4000},
	{64746, 0x1000000},
	{65684, 0x2000000},
	{64764, 0x10000000},
	{64773, 0x20000000},
	{64782, 0x40000000},
	/* 6143 */
	{65301, 0x1},
	{65311, 0x2},
	{65321, 0x4},
	{65330, 0x8},
	{65339, 0x10},
	{65350, 0x20},
	{65361, 0x40},
	{65371, 0x80},
	{122621, 0x100},
	{122636, 0x200},
	{65381, 0x400},
	{65391, 0x800},
	{65408, 0x1000},
	{65526, 0x20000000},
	{65539, 0x40000000},
	{64773, 0x80000000},
	/* 6159 */
	{132118, 0x1},
	{132139, 0x2},
	{66036, 0x8},
	{66055, 0x10},
	{66075, 0x40},
	{66094, 0x100},
	{66115, 0x200},
	{66133, 0x400},
	{132160, 0x800},
	{132181, 0x1000},
	{66156, 0x2000},
	{66178, 0x10000},
	{66199, 0x20000},
	{66217, 0x40000},
	{132204, 0x80000},
	{132225, 0x100000},
	{66240, 0x200000},
	/* 6176 */
	{66355, 0x1},
	{66374, 0x2},
	{122621, 0x4},
	{122636, 0x8},
	{66383, 0x10},
	{66398, 0x20},
	{66412, 0x40},
	{66431, 0x80},
	{66450, 0x100},
	{66465, 0x200},
	{66482, 0x400},
	{66504, 0x800},
	{66526, 0x1000},
	{66541, 0x2000},
	{65381, 0x4000},
	{66556, 0x8000},
	{66701, 0x40000000},
	{64764, 0x80000000},
	/* 6194 */
	{66714, 0x1},
	{66732, 0x2},
	{66746, 0x4},
	{66765, 0x8},
	{66784, 0x10},
	{66799, 0x20},
	{66817, 0x40},
	{66835, 0x80},
	{66852, 0x100},
	{132248, 0x200},
	{66898, 0x800},
	{66922, 0x1000},
	{66940, 0x2000},
	{66958, 0x4000},
	{66979, 0x8000},
	{67003, 0x10000},
	{67029, 0x20000},
	{67046, 0x40000},
	{67066, 0x80000},
	{67086, 0x100000},
	{67106, 0x200000},
	{67127, 0x400000},
	{67150, 0x800000},
	{67171, 0x1000000},
	{67190, 0x2000000},
	{67207, 0x4000000},
	{67223, 0x8000000},
	{67239, 0x10000000},
	{67255, 0x20000000},
	{67274, 0x40000000},
	{67286, 0x80000000},
	/* 6225 */
	{67298, 0x1},
	{67317, 0x2},
	{67337, 0x4},
	{67357, 0x8},
	{121311, 0x10},
	{67377, 0x20},
	{67398, 0x40},
	/* 6232 */
	{126883, 0x1F},
	{126890, 0x20},
	{68445, 0x80},
	{63761, 0xF00},
	{126897, 0x3000},
	{68458, 0x4000},
	{68471, 0x8000},
	{126908, 0xFFFF0000},
	{126908, 0xFFFF0000},
	/* 6241 */
	{10442, 0xF},
	{92487, 0x10},
	/* 6243 */
	{132270, 0xFFFF},
	/* 6244 */
	{68597, 0x3FF},
	{68612, 0x3FF0000},
	{126959, 0x20000000},
	{64635, 0x40000000},
	{77058, 0x80000000},
	/* 6249 */
	{99505, 0xFFFF},
	{99517, 0x10000},
	{27101, 0xE0000000},
	/* 6252 */
	{132280, 0x1000},
	{99613, 0x6000},
	{132288, 0x8000},
	{99642, 0x300000},
	{132301, 0x1000000},
	{99653, 0x6000000},
	{132309, 0x8000000},
	{99682, 0x60000000},
	/* 6260 */
	{132322, 0x7F},
	{132334, 0x3F000},
	{12037, 0x6000000},
	{100296, 0x8000000},
	/* 6264 */
	{28091, 0xFFFF},
	{100317, 0x30000},
	{100325, 0x7000000},
	{100333, 0xE0000000},
	/* 6268 */
	{101309, 0x3F},
	{101314, 0xC0},
	{101322, 0x100},
	{101328, 0xFFFFFE00},
	/* 6272 */
	{89452, 0x1},
	{983, 0x1FFE},
	{220, 0x2000},
	{97314, 0x4000},
	{101336, 0x8000},
	{101348, 0x7FF0000},
	{101359, 0x8000000},
	{101370, 0x10000000},
	{101314, 0xE0000000},
	/* 6281 */
	{101483, 0x3F},
	{101493, 0xFC00},
	/* 6283 */
	{101442, 0x3F},
	{101451, 0xFC00},
	{102999, 0xF00000},
	/* 6286 */
	{101442, 0xFF},
	{103135, 0xF000},
	{126784, 0xF0000},
	{50481, 0xF00000},
	{126800, 0xF000000},
	{103053, 0xF0000000},
	/* 6292 */
	{60494, 0xFF},
	{10813, 0xFFFFFF00},
	/* 6294 */
	{27038, 0xFFFF},
	{100317, 0x300000, 4, 37442},
	{105022, 0x8000000, 2, 36570},
	{105044, 0x60000000, 4, 36578},
	{105052, 0x80000000},
	/* 6299 */
	{105022, 0x1, 2, 36570},
	{99613, 0x6000},
	{100317, 0x300000, 4, 37442},
	{99653, 0x6000000},
	{105044, 0x60000000, 4, 36578},
	{105052, 0x80000000},
	/* 6305 */
	{63466, 0xF},
	{63475, 0xF0},
	{63485, 0x100},
	{63496, 0x200},
	{63501, 0x400},
	{118678, 0x800},
	{63628, 0x1FF000, 257, 0},
	{132351, 0x8000000},
	{63659, 0x10000000},
	{63665, 0xE0000000},
	/* 6315 */
	{63669, 0x1},
	{63673, 0x6},
	{63682, 0x18},
	{51265, 0x20},
	{63692, 0x40},
	{63700, 0x80},
	{63710, 0x100},
	{63721, 0x200},
	{63727, 0x400},
	{63732, 0x800},
	{63738, 0x1000},
	{54277, 0x2000},
	{63749, 0x4000},
	{118697, 0x8000},
	{63515, 0x10000},
	{63769, 0x20000},
	{63777, 0x40000},
	{63789, 0x80000},
	{115847, 0x100000},
	{115861, 0x200000},
	{132362, 0x400000},
	{118719, 0x800000},
	{63808, 0x8000000},
	/* 6338 */
	{63820, 0x1FF, 257, 0},
	{63825, 0x400},
	{63865, 0x3F0000},
	{63918, 0xE0000000},
	/* 6342 */
	{64077, 0xF},
	{64084, 0x70},
	{64106, 0xF00},
	{64115, 0x7000},
	{64124, 0x8000},
	{64137, 0xF0000},
	/* 6348 */
	{118748, 0x7},
	{118756, 0x8},
	{118767, 0x10},
	{118780, 0xE0},
	{118796, 0x300},
	{118806, 0xC00},
	{118816, 0xF0000},
	{64240, 0xF00000},
	{118828, 0x3000000},
	{118835, 0x4000000},
	{118842, 0x18000000},
	{78027, 0x20000000},
	{118850, 0x40000000},
	/* 6361 */
	{132375, 0x1},
	{64185, 0x2},
	{64191, 0x4},
	{64220, 0xF0},
	{64225, 0xF00},
	/* 6366 */
	{64385, 0xF},
	{64408, 0x10},
	{64431, 0x20},
	{64454, 0x40},
	{64474, 0x80},
	{64494, 0x100},
	{64514, 0x200},
	{64534, 0x400},
	{64554, 0x800},
	{64574, 0x1000},
	{64594, 0x2000},
	{64614, 0x4000},
	{64746, 0x1000000},
	{65684, 0x2000000},
	{132382, 0x4000000},
	{64764, 0x10000000},
	{64773, 0x20000000},
	{64782, 0x40000000},
	/* 6384 */
	{65301, 0x1},
	{65311, 0x2},
	{65321, 0x4},
	{65330, 0x8},
	{65339, 0x10},
	{65350, 0x20},
	{65361, 0x40},
	{65371, 0x80},
	{65381, 0x400},
	{65391, 0x800},
	{65408, 0x1000},
	{132398, 0x2000},
	{65526, 0x20000000},
	{65539, 0x40000000},
	{64773, 0x80000000},
	/* 6399 */
	{66036, 0x8},
	{66055, 0x10},
	{66075, 0x40},
	{66094, 0x100},
	{66115, 0x200},
	{66133, 0x400},
	{66156, 0x2000},
	{66178, 0x10000},
	{66199, 0x20000},
	{66217, 0x40000},
	{66240, 0x200000},
	{132411, 0x400000},
	{132435, 0x800000},
	{132459, 0x1000000},
	/* 6413 */
	{66355, 0x1},
	{66374, 0x2},
	{66383, 0x10},
	{66398, 0x20},
	{66412, 0x40},
	{66431, 0x80},
	{66450, 0x100},
	{66465, 0x200},
	{66482, 0x400},
	{66504, 0x800},
	{66526, 0x1000},
	{66541, 0x2000},
	{65381, 0x4000},
	{66556, 0x8000},
	{66565, 0x10000},
	{132398, 0x20000},
	{66656, 0x4000000},
	{66669, 0x8000000},
	{66682, 0x30000000},
	{66701, 0x40000000},
	{64764, 0x80000000},
	/* 6434 */
	{67298, 0x1},
	{67317, 0x2},
	{67337, 0x4},
	{67357, 0x8},
	{67377, 0x20},
	{67398, 0x40},
	{132411, 0x80},
	{132435, 0x100},
	{132459, 0x200},
	/* 6443 */
	{68798, 0x7, 8, 37205},
	{68808, 0x38, 8, 37205},
	{68818, 0x1C0, 8, 37205},
	{68828, 0xE00, 8, 37205},
	{114610, 0x7000, 8, 37446},
	{114598, 0x78000, 16, 37221},
	{127929, 0x180000},
	{73065, 0x600000},
	{73078, 0x800000},
	{92487, 0x1000000},
	{127942, 0x2000000},
	{127954, 0x4000000},
	{92500, 0x38000000},
	{220, 0xC0000000, 4, 37237},
	/* 6457 */
	{68753, 0xFF},
	{73399, 0xFFF00},
	{114598, 0x3F00000, 64, 37241},
	{114610, 0x3C000000, 16, 37454},
	{92500, 0xC0000000},
	/* 6462 */
	{75600, 0xFFF},
	{75664, 0xFF000},
	{75637, 0x100000},
	{75786, 0x200000},
	{75801, 0x400000},
	{75817, 0x800000},
	{132642, 0xF000000},
	{132658, 0xF0000000},
	/* 6470 */
	{73210, 0x7, 8, 37337},
	{73218, 0x38, 8, 37337},
	{73226, 0x1C0, 8, 37337},
	{73234, 0xE00},
	{73250, 0x7000, 8, 37345},
	{73269, 0x8000},
	{73288, 0x70000},
	{73304, 0x80000},
	{73319, 0x100000},
	{73333, 0x7E00000},
	{73344, 0x8000000},
	{73356, 0x10000000},
	{73374, 0x60000000, 3, 37353},
	{132674, 0x80000000},
	/* 6484 */
	{73431, 0x3FFF},
	{73440, 0xFC000},
	{73453, 0x300000, 4, 37356},
	{73467, 0xC00000, 4, 37356},
	{73481, 0x3000000, 3, 37360},
	{73490, 0xC000000, 4, 37470},
	{73501, 0x10000000},
	{131099, 0x20000000},
	{131116, 0x40000000},
	{73520, 0x80000000},
	/* 6494 */
	{76117, 0x1},
	{76128, 0x3E},
	{76138, 0x40},
	{76638, 0x80},
	{76648, 0x100},
	{76660, 0x200},
	{76672, 0x400},
	{76684, 0x800},
	{76696, 0x1000},
	{63628, 0x3FE000, 257, 0},
	{76713, 0x1000000},
	/* 6505 */
	{92487, 0x1},
	{92500, 0x6},
	/* 6507 */
	{17750, 0x3, 4, 3051},
	{79081, 0xC},
	{74814, 0xE000, 7, 2800},
	{98877, 0x700000},
	{79208, 0x7800000},
	{79232, 0x8000000},
	{79247, 0x10000000},
	{79257, 0x20000000},
	{132720, 0x40000000},
	{79277, 0x80000000},
	/* 6517 */
	{17750, 0x1, 2, 3059},
	{74814, 0xE000, 7, 2800},
	{98877, 0x700000},
	{79232, 0x8000000},
	{79320, 0x20000000},
	{132720, 0x40000000},
	/* 6523 */
	{82409, 0x1},
	{132737, 0x2},
	{82436, 0x7C},
	/* 6526 */
	{87419, 0x8},
	{1398, 0x70, 7, 36013},
	{86692, 0xFF0000, 256, 36021},
	/* 6529 */
	{89164, 0x1},
	{89180, 0x2},
	{89196, 0x4},
	{89212, 0x8},
	{89228, 0x10},
	{89244, 0x20},
	{89260, 0x40},
	{89276, 0x80},
	{89292, 0x100},
	{89308, 0x200},
	{89324, 0x400},
	{89340, 0x800},
	{89356, 0x1000},
	{89372, 0x2000},
	{89388, 0x4000},
	{89404, 0x8000},
	{89420, 0x10000},
	{89439, 0x20000},
	{89457, 0x40000},
	{89484, 0x80000},
	{89506, 0x100000},
	{89524, 0x200000},
	{89544, 0x400000},
	{89567, 0x800000},
	{89590, 0x1000000},
	{89615, 0x2000000},
	{89658, 0x4000000},
	/* 6556 */
	{1398, 0x7, 6, 36312},
	{91192, 0x8},
	{91248, 0x30, 4, 36318},
	{91257, 0x7C0},
	{91268, 0x800},
	{91281, 0x1000},
	{91292, 0x2000},
	{101640, 0x4000},
	{118579, 0x8000},
	{132776, 0x10000},
	{91351, 0x20000},
	{91370, 0x40000},
	{91384, 0x80000},
	{91402, 0x100000},
	{91420, 0x600000},
	/* 6571 */
	{214, 0x3, 3, 36326},
	{92334, 0xC, 4, 36329},
	{92414, 0x30, 4, 36333},
	{92474, 0x40, 2, 36337},
	{86860, 0x200},
	{92491, 0x400},
	{92500, 0x1800},
	/* 6578 */
	{93710, 0x3F, 61, 37474},
	{68758, 0x7FC0000},
	{93721, 0x8000000},
	/* 6581 */
	{93826, 0xFFFF},
	{93841, 0x10000},
	{93860, 0x20000},
	{93874, 0x40000},
	{93893, 0x80000},
	{93907, 0x100000},
	{94551, 0xF0000000},
	/* 6588 */
	{98463, 0x1},
	{93924, 0x2},
	{132032, 0x4},
	{132055, 0x8},
	{132063, 0x3F0},
	{132078, 0xFC00},
	{94003, 0x10000},
	{132787, 0x20000},
	/* 6596 */
	{220, 0x3, 3, 36420},
	{94785, 0x1C, 4, 36423},
	{94862, 0xE0, 4, 36427},
	{94871, 0x100},
	{94891, 0x200},
	{94902, 0x3C00},
	{94924, 0x4000},
	{92474, 0x8000, 2, 36337},
	{94958, 0x60000, 3, 36431},
	{92500, 0x180000},
	/* 6606 */
	{97752, 0x3, 4, 36472},
	{17750, 0x7C, 24, 36476},
	{73846, 0x80},
	{98350, 0x700, 8, 36508},
	{98406, 0x1800, 4, 36516},
	{87468, 0x2000},
	{78369, 0x4000},
	{98416, 0x8000},
	{98428, 0x10000},
	{98441, 0x20000},
	{96020, 0x40000},
	{98454, 0x80000},
	{98681, 0x700000, 8, 36520},
	{98703, 0x3800000, 8, 36520},
	{98727, 0x4000000},
	{98753, 0x8000000},
	{98779, 0x10000000},
	{98847, 0x60000000, 3, 36528},
	/* 6624 */
	{12037, 0x2000000},
	{92500, 0x18000000},
	/* 6626 */
	{99505, 0xFFFF},
	{99517, 0x10000},
	{99433, 0x2000000},
	{92500, 0x18000000},
	{27101, 0xE0000000},
	/* 6631 */
	{26669, 0xFFFF},
	{92500, 0x300000},
	{99433, 0x400000},
	/* 6634 */
	{26741, 0xFFFF},
	{92500, 0x300000},
	{99433, 0x400000},
	/* 6637 */
	{132801, 0xC00},
	{132280, 0x1000},
	{99613, 0x2000},
	{99642, 0x300000},
	{132811, 0xC00000},
	{132301, 0x1000000},
	{99653, 0x2000000},
	{99682, 0x60000000},
	/* 6645 */
	{100496, 0x1},
	{100512, 0x2},
	{132821, 0x4},
	{99730, 0x8},
	{100528, 0x40},
	{100546, 0x80},
	{100564, 0x100},
	{100582, 0x200},
	{100600, 0x400},
	{100618, 0x800},
	{100636, 0x1000},
	{100654, 0x2000},
	{100672, 0x4000},
	{99791, 0x8000},
	{99811, 0x40000},
	{100689, 0x80000},
	{100705, 0x200000},
	{99828, 0x400000},
	{99844, 0x800000},
	{99858, 0x2000000},
	{99872, 0x4000000},
	{99886, 0x8000000},
	{99907, 0x10000000},
	{99932, 0x20000000},
	{99953, 0x40000000},
	{132838, 0x80000000},
	/* 6671 */
	{132322, 0x7F},
	{132334, 0x3F000},
	{12037, 0x2000000},
	{92500, 0x18000000},
	/* 6675 */
	{101387, 0xFFFF},
	{101411, 0xF0000},
	{101398, 0x300000},
	{100789, 0x3FC00000},
	{101419, 0x40000000},
	{10330, 0x80000000},
	/* 6681 */
	{68753, 0xFF},
	{73399, 0xFFF00},
	{114598, 0x3F00000, 64, 37535},
	{114610, 0x3C000000, 16, 37454},
	{92500, 0xC0000000},
	/* 6686 */
	{87401, 0x1},
	{87419, 0x8},
	{1398, 0x70, 7, 36013},
	{86692, 0xFF0000, 256, 36021},
	/* 6690 */
	{94168, 0xFF},
	{94182, 0xFF00},
	{94192, 0xFF0000},
	{94203, 0xFF000000},
	/* 6694 */
	{97752, 0x3, 4, 36472},
	{17750, 0x7C, 31, 36476},
	{73846, 0x80},
	{98350, 0x700, 8, 36508},
	{98406, 0x1800, 4, 36516},
	{87468, 0x2000},
	{78369, 0x4000},
	{98416, 0x8000},
	{98428, 0x10000},
	{98441, 0x20000},
	{96020, 0x40000},
	{98454, 0x80000},
	{98681, 0x700000, 8, 36520},
	{98703, 0x3800000, 8, 36520},
	{98727, 0x4000000},
	{98753, 0x8000000},
	{98779, 0x10000000},
	{98847, 0x60000000, 3, 36528},
	/* 6712 */
	{89452, 0x1},
	{983, 0x1FFE},
	{220, 0x2000},
	{97314, 0x4000},
	{101336, 0x8000},
	{101348, 0xFFF0000},
	{101359, 0x10000000},
	{101370, 0x20000000},
	{101314, 0xC0000000},
	/* 6721 */
	{63466, 0xF},
	{63475, 0xF0},
	{63485, 0x100},
	{63496, 0x200},
	{63501, 0x400},
	{118678, 0x800},
	{63628, 0x1FF000, 257, 0},
	{63636, 0x800000},
	{133156, 0x1000000},
	{133169, 0x2000000},
	{63646, 0x4000000},
	{132351, 0x8000000},
	{63659, 0x10000000},
	{63665, 0xE0000000},
	/* 6735 */
	{63669, 0x1},
	{63673, 0x6},
	{63682, 0x18},
	{51265, 0x20},
	{63692, 0x40},
	{63700, 0x80},
	{63710, 0x100},
	{63721, 0x200},
	{63727, 0x400},
	{63732, 0x800},
	{63738, 0x1000},
	{54277, 0x2000},
	{63749, 0x4000},
	{118697, 0x8000},
	{63515, 0x10000},
	{63769, 0x20000},
	{63777, 0x40000},
	{63789, 0x80000},
	{115847, 0x100000},
	{115861, 0x200000},
	{132362, 0x400000},
	{63797, 0x800000},
	{63808, 0x8000000},
	/* 6758 */
	{63820, 0x1FF, 257, 0},
	{63825, 0x400},
	{63833, 0x800},
	{63846, 0x7000},
	{63865, 0x3F0000},
	{63906, 0x10000000},
	{63918, 0xE0000000},
	/* 6765 */
	{64077, 0xF},
	{64084, 0x70},
	{64106, 0xF00},
	{64115, 0x7000},
	{64124, 0x8000},
	{64137, 0x1F0000},
	{64142, 0xC00000},
	/* 6772 */
	{118748, 0x7},
	{118756, 0x8},
	{118767, 0x10},
	{118780, 0xE0},
	{118796, 0x300},
	{118806, 0xC00},
	{118816, 0xF0000},
	{118828, 0x3000000},
	{118835, 0x4000000},
	{118842, 0x18000000},
	{78027, 0x20000000},
	{118850, 0x40000000},
	{133182, 0x80000000},
	/* 6785 */
	{132375, 0x1},
	{64185, 0x2},
	{64191, 0x4},
	{64220, 0x1F0},
	{64225, 0xF800},
	{64137, 0x7C0000},
	{64240, 0xFE000000},
	/* 6792 */
	{64385, 0xF},
	{64408, 0x10},
	{64431, 0x20},
	{64454, 0x40},
	{64474, 0x80},
	{64494, 0x100},
	{64514, 0x200},
	{64534, 0x400},
	{64554, 0x800},
	{64574, 0x1000},
	{64594, 0x2000},
	{64614, 0x4000},
	{64629, 0x8000},
	{64640, 0x10000},
	{64648, 0x20000},
	{64657, 0x40000},
	{64674, 0x80000},
	{64689, 0x100000},
	{64746, 0x1000000},
	{65684, 0x2000000},
	{132382, 0x4000000},
	{64764, 0x10000000},
	{64773, 0x20000000},
	{64782, 0x40000000},
	{64791, 0x80000000},
	/* 6817 */
	{64802, 0xF},
	{64825, 0x20},
	{64841, 0x80},
	{64864, 0x100},
	{64887, 0x200},
	{64906, 0x1000},
	{64915, 0x2000},
	{64924, 0x4000},
	{64932, 0x8000},
	{119523, 0x10000},
	{119538, 0x20000},
	{119547, 0x40000},
	{119562, 0x80000},
	{64956, 0x100000},
	{119570, 0x200000},
	{64972, 0x400000},
	{64981, 0x800000},
	{64990, 0x1000000},
	{64998, 0x2000000},
	{65006, 0x4000000},
	{65014, 0x10000000},
	{64756, 0x20000000},
	{65032, 0x40000000},
	{65040, 0x80000000},
	/* 6841 */
	{64906, 0x2},
	{64915, 0x4},
	{64648, 0x200000},
	{64981, 0x400000},
	{119538, 0x800000},
	{64998, 0x1000000},
	{64924, 0x2000000},
	{64956, 0x4000000},
	{64972, 0x8000000},
	{64990, 0x20000000},
	{65006, 0x40000000},
	{65032, 0x80000000},
	/* 6853 */
	{65301, 0x1},
	{65311, 0x2},
	{65321, 0x4},
	{65330, 0x8},
	{65339, 0x10},
	{65350, 0x20},
	{65361, 0x40},
	{65371, 0x80},
	{65381, 0x400},
	{65391, 0x800},
	{65408, 0x1000},
	{65416, 0x2000},
	{65429, 0x4000},
	{65526, 0x20000000},
	{65539, 0x40000000},
	{64773, 0x80000000},
	/* 6869 */
	{66355, 0x1},
	{66374, 0x2},
	{66383, 0x10},
	{66398, 0x20},
	{66412, 0x40},
	{66431, 0x80},
	{66450, 0x100},
	{66465, 0x200},
	{66482, 0x400},
	{66504, 0x800},
	{66526, 0x1000},
	{66541, 0x2000},
	{65381, 0x4000},
	{66556, 0x8000},
	{66565, 0x10000},
	{65416, 0x20000},
	{66656, 0x4000000},
	{66669, 0x8000000},
	{66682, 0x30000000},
	{66701, 0x40000000},
	{64764, 0x80000000},
	/* 6890 */
	{68798, 0x7, 8, 37205},
	{68808, 0x38, 8, 37205},
	{68818, 0x1C0, 8, 37205},
	{68828, 0xE00, 8, 37205},
	{114610, 0x7000, 8, 37599},
	{114598, 0x78000, 16, 37221},
	{133227, 0x80000},
	{133242, 0x100000},
	{73065, 0x600000},
	{73078, 0x800000},
	{91086, 0x8000000},
	{220, 0xC0000000, 4, 37237},
	/* 6902 */
	{68753, 0xFF},
	{73399, 0xFFF00},
	{114598, 0x3F00000, 64, 37607},
	{133726, 0x3F00000, 61, 37671},
	{114610, 0x3C000000, 16, 37732},
	{134233, 0x3C000000, 16, 37748},
	{91086, 0x40000000},
	{134250, 0x80000000},
	/* 6910 */
	{68798, 0x7, 8, 37205},
	{68808, 0x38, 8, 37205},
	{68818, 0x1C0, 8, 37205},
	{68828, 0xE00, 8, 37205},
	{75432, 0xF000},
	{75443, 0xF0000},
	{75454, 0x1F00000},
	{220, 0xF0000000, 16, 37321},
	/* 6918 */
	{18896, 0x1FFF},
	{21612, 0x1FFFE000},
	{75558, 0xE0000000, 6, 2828},
	/* 6921 */
	{75569, 0x1FFF},
	{75580, 0x1E000},
	{134262, 0x1FE0000},
	{99327, 0x2000000},
	{75746, 0x4000000},
	{134280, 0x8000000},
	{75592, 0xF0000000},
	/* 6928 */
	{73431, 0x3FFF},
	{73440, 0xFC000},
	{73453, 0x300000, 4, 37356},
	{73467, 0xC00000, 4, 37356},
	{73481, 0x3000000, 3, 37360},
	{73490, 0xC000000, 4, 37470},
	{73501, 0x10000000},
	{73535, 0x20000000},
	{131116, 0x40000000},
	{73520, 0x80000000},
	/* 6938 */
	{73550, 0xFFF},
	{73386, 0x1000},
	{73567, 0xC0000000, 4, 37366},
	/* 6941 */
	{73755, 0x7},
	{73765, 0x38},
	{73786, 0xC0},
	{131274, 0x700},
	{75404, 0x7000, 4, 2824},
	{131295, 0x70000},
	{73807, 0x180000},
	{131319, 0xE00000},
	{131328, 0x3000000},
	{73826, 0xC000000},
	{131348, 0x30000000},
	{131357, 0x40000000},
	{134296, 0x80000000},
	/* 6954 */
	{75926, 0xFFFF},
	{75932, 0x3F0000},
	{75943, 0x3C00000},
	{134306, 0x3C000000},
	/* 6958 */
	{75971, 0x3F},
	{75977, 0x3C0},
	{73595, 0xC00},
	{76067, 0xFF000, 193, 2834},
	{51265, 0x100000},
	{63485, 0x200000},
	{116486, 0x400000},
	{76078, 0x800000},
	{76088, 0x1000000},
	{116497, 0x10000000},
	{63636, 0x20000000},
	/* 6969 */
	{76117, 0x1},
	{76128, 0x3E},
	{76138, 0x40},
	{76151, 0x80},
	{76163, 0xFF00},
	{63628, 0x1FF0000, 257, 0},
	{76178, 0x2000000},
	{76200, 0x4000000},
	{76730, 0x8000000},
	{76225, 0x10000000},
	/* 6979 */
	{75971, 0x3F},
	{75977, 0x3C0},
	{73595, 0xC00},
	{76067, 0xFF000, 193, 2834},
	{51265, 0x100000},
	{63485, 0x200000},
	{116486, 0x400000},
	{76078, 0x800000},
	{76608, 0x3000000},
	{76622, 0x4000000},
	{116497, 0x40000000},
	{63636, 0x80000000},
	/* 6991 */
	{76117, 0x1},
	{76128, 0x3E},
	{76138, 0x40},
	{76638, 0x80},
	{76648, 0x100},
	{76660, 0x200},
	{76672, 0x400},
	{76684, 0x800},
	{76696, 0x1000},
	{63628, 0x3FE000, 257, 0},
	{76702, 0x400000},
	{76713, 0x1000000},
	{76730, 0x8000000},
	{76225, 0x10000000},
	/* 7005 */
	{76767, 0x7F},
	{76742, 0x3F80},
	/* 7007 */
	{75971, 0x3F},
	{75977, 0x3C0},
	{73595, 0xC00},
	{76067, 0xFF000, 193, 2834},
	{51265, 0x100000},
	{63485, 0x200000},
	{116486, 0x400000},
	{76078, 0x800000},
	{76622, 0x1000000},
	{116497, 0x10000000},
	{76793, 0x60000000},
	{63636, 0x80000000},
	/* 7019 */
	{76117, 0x1},
	{76128, 0x3E},
	{76138, 0x40},
	{63628, 0xFF80, 257, 0},
	{76810, 0x30000},
	{76638, 0x40000},
	{64051, 0x7F80000},
	{76730, 0x8000000},
	{76225, 0x10000000},
	/* 7028 */
	{75932, 0x3F},
	{75943, 0x3C0},
	{134306, 0x3C00},
	{75926, 0xFFFF0000},
	/* 7032 */
	{75971, 0x3F},
	{75977, 0x3C0},
	{73595, 0xC00},
	{76067, 0xFF000, 193, 2834},
	{51265, 0x100000},
	{63485, 0x200000},
	{116486, 0x400000},
	{76078, 0x800000},
	{116497, 0x8000000},
	{76827, 0x30000000},
	{63636, 0x40000000},
	/* 7043 */
	{76117, 0x1},
	{76128, 0x3E},
	{76138, 0x40},
	{63628, 0xFF80, 257, 0},
	{64051, 0x1FF0000},
	{76730, 0x8000000},
	{76225, 0x10000000},
	/* 7050 */
	{76855, 0x1},
	{76873, 0x2},
	{76887, 0x4},
	{76906, 0x8},
	{76926, 0x10},
	{76946, 0x20},
	{76968, 0x40},
	{76979, 0x400},
	{76997, 0x800},
	{10813, 0x1000},
	{77029, 0x4000},
	/* 7061 */
	{75971, 0x3F},
	{75977, 0x3C0},
	{73595, 0xC00},
	{76067, 0xFF000, 193, 2834},
	{51265, 0x100000},
	{63485, 0x200000},
	{116486, 0x400000},
	{76078, 0x800000},
	{77082, 0x1000000},
	{116497, 0x2000000},
	{63636, 0x4000000},
	/* 7072 */
	{76117, 0x1},
	{76128, 0x3E},
	{76138, 0x40},
	{77088, 0x80},
	{77098, 0x100},
	{77108, 0x200},
	{76844, 0x400},
	{77118, 0x1800},
	{77133, 0x6000},
	{64051, 0xFF8000},
	{63628, 0x7F000000, 257, 0},
	{76730, 0x80000000},
	/* 7084 */
	{77145, 0x3FF},
	{77158, 0xF000},
	{77168, 0x3F0000},
	{77183, 0x400000},
	{77198, 0x800000},
	{77214, 0x7000000},
	{134306, 0x78000000},
	/* 7091 */
	{77749, 0x7FF},
	{77776, 0xFFE000},
	{77786, 0x1000000},
	{77798, 0x2000000},
	{77816, 0x3C000000},
	/* 7096 */
	{17750, 0x3, 4, 3051},
	{79081, 0xC},
	{75454, 0x1F0},
	{79165, 0x1000},
	{79136, 0x6000, 4, 3055},
	{79151, 0x8000},
	{79201, 0xF0000},
	{79208, 0x7800000},
	{79232, 0x8000000},
	{79247, 0x10000000},
	{79257, 0x20000000},
	{132720, 0x40000000},
	{79277, 0x80000000},
	/* 7109 */
	{17750, 0x1, 2, 3059},
	{75454, 0x1F0},
	{79165, 0x1000},
	{79136, 0x6000, 4, 3055},
	{79151, 0x8000},
	{79232, 0x8000000},
	{79320, 0x20000000},
	{132720, 0x40000000},
	/* 7117 */
	{63164, 0xFFFF},
	/* 7118 */
	{80150, 0x3, 4, 35838},
	{80162, 0xC, 4, 35838},
	{80274, 0x30, 4, 35842},
	{80331, 0x40, 2, 35846},
	{80387, 0x80, 2, 35848},
	{80491, 0x300, 4, 35850},
	{80599, 0xC00, 4, 35854},
	{80708, 0x3000, 4, 35858},
	{80821, 0xC000, 4, 35862},
	{80923, 0x30000, 4, 35866},
	{81069, 0xC0000, 4, 35870},
	{81216, 0x300000, 4, 35874},
	{81316, 0x3000000, 4, 35878},
	{81462, 0x1C000000, 5, 37764},
	{81609, 0xE0000000, 5, 37769},
	/* 7133 */
	{81729, 0x3, 4, 35890},
	{81900, 0x1C, 5, 37774},
	{82072, 0xE0, 5, 37779},
	/* 7136 */
	{82409, 0x1},
	{132737, 0x2},
	{82436, 0x7C},
	{82465, 0x100},
	{82494, 0x200},
	{82525, 0x400},
	{82553, 0x1000},
	{82581, 0x2000},
	{82611, 0x4000},
	/* 7145 */
	{89164, 0x1},
	{89180, 0x2},
	{89196, 0x4},
	{89212, 0x8},
	{89228, 0x10},
	{89244, 0x20},
	{89260, 0x40},
	{89276, 0x80},
	{89292, 0x100},
	{89308, 0x200},
	{89324, 0x400},
	{89340, 0x800},
	{89356, 0x1000},
	{89372, 0x2000},
	{89388, 0x4000},
	{89404, 0x8000},
	{89420, 0x10000},
	{89439, 0x20000},
	{89457, 0x40000},
	{89484, 0x80000},
	{89506, 0x100000},
	{89524, 0x200000},
	{89544, 0x400000},
	{89567, 0x800000},
	{89590, 0x1000000},
	{89615, 0x2000000},
	{89658, 0x4000000},
	{89635, 0x8000000},
	/* 7173 */
	{90312, 0x1},
	{90323, 0x2},
	{134473, 0x4},
	/* 7176 */
	{101090, 0x1},
	{90493, 0x1E},
	{90505, 0xE0},
	{90519, 0x300},
	{90535, 0x1C00},
	{90546, 0x1E000},
	/* 7182 */
	{214, 0x3, 3, 36326},
	{92334, 0xC, 4, 36329},
	{92414, 0x30, 4, 36333},
	{92474, 0x40, 2, 36337},
	{94524, 0x100},
	{86860, 0x200},
	{92491, 0x400},
	/* 7189 */
	{93710, 0x3F, 64, 37784},
	{68758, 0x7FFFC00},
	{93721, 0x8000000},
	/* 7192 */
	{63283, 0xFFFF},
	/* 7193 */
	{93751, 0x1},
	{93765, 0x2},
	{134536, 0x4},
	{93781, 0x8},
	/* 7197 */
	{93924, 0x2},
	{132032, 0x4},
	{132055, 0x8},
	{132063, 0x3F0},
	{132078, 0xFC00},
	{94003, 0x10000},
	{75751, 0x40000},
	{134285, 0x80000},
	/* 7205 */
	{94275, 0x3, 4, 36404},
	{94306, 0x4, 2, 36408},
	{20206, 0x18, 4, 36410},
	{94388, 0x20, 2, 36414},
	{94453, 0xC0, 4, 36416},
	{76713, 0x200},
	{94470, 0x400},
	{94490, 0x800},
	{94510, 0x1000},
	{94524, 0x2000},
	{94535, 0x4000},
	{94551, 0x78000},
	{94571, 0x180000},
	/* 7218 */
	{220, 0x3, 3, 36420},
	{94785, 0x1C, 4, 36423},
	{94862, 0xE0, 4, 36427},
	{94871, 0x100},
	{94891, 0x200},
	{94924, 0x4000},
	{92474, 0x8000, 2, 36337},
	{94958, 0x60000, 4, 36431},
	/* 7226 */
	{77749, 0x7FF},
	{77776, 0xFFE000},
	{97691, 0xF000000},
	/* 7229 */
	{97752, 0x3, 4, 36472},
	{17750, 0x7C, 32, 36476},
	{98350, 0x700, 8, 36508},
	{98406, 0x1800, 4, 36516},
	{87468, 0x2000},
	{78369, 0x4000},
	{98416, 0x8000},
	{98428, 0x10000},
	{98441, 0x20000},
	{96020, 0x40000},
	{98681, 0x700000, 8, 36520},
	{98703, 0x3800000, 8, 36520},
	{98727, 0x4000000},
	{98753, 0x8000000},
	{98779, 0x10000000},
	{98847, 0x60000000, 3, 36528},
	/* 7245 */
	{99316, 0x7FF},
	{99327, 0x800},
	{79081, 0x7000},
	{98933, 0x18000},
	{98947, 0x20000},
	{99339, 0x7C0000},
	{99353, 0xF800000},
	{99367, 0x30000000},
	{134285, 0x40000000},
	{75751, 0x80000000},
	/* 7255 */
	{99505, 0xFFFF},
	{99517, 0x10000},
	{99433, 0x2000000},
	{27101, 0xE0000000},
	/* 7259 */
	{26669, 0xFFFF},
	{99433, 0x400000},
	/* 7261 */
	{26741, 0xFFFF},
	{99433, 0x400000},
	/* 7263 */
	{99600, 0x400},
	{99613, 0x2000},
	{99642, 0x300000},
	{99653, 0x2000000},
	{99682, 0x60000000},
	/* 7268 */
	{100027, 0x1},
	{100061, 0x30},
	{100073, 0xF0000},
	{100086, 0x10000000},
	{100101, 0x20000000},
	{100115, 0xC0000000},
	/* 7274 */
	{132322, 0x7F},
	{132334, 0x3F000},
	{99433, 0x2000000},
	{100309, 0x10000000},
	/* 7278 */
	{100739, 0xF},
	{100751, 0xF0},
	{119684, 0xF00},
	{134555, 0xF000},
	{100779, 0x30000},
	{100789, 0xC0000},
	{10330, 0x100000},
	{10813, 0xFFE00000},
	/* 7286 */
	{214, 0x3, 3, 36326},
	{94524, 0x100},
	/* 7288 */
	{126967, 0x7},
	{126975, 0x38},
	{126983, 0x1C0},
	{126991, 0xE00},
	{126999, 0x7000},
	{127007, 0x38000},
	{127015, 0x1C0000},
	{1398, 0x600000},
	{127023, 0x1800000},
	{127036, 0x2000000},
	{134564, 0x4000000},
	{127049, 0x18000000},
	{127060, 0x20000000},
	{68418, 0x40000000},
	{73369, 0x80000000},
	/* 7303 */
	{68597, 0x3FF},
	{68612, 0x3FF0000},
	{105387, 0x10000000},
	{126959, 0x20000000},
	{64635, 0x40000000},
	{77058, 0x80000000},
	/* 7309 */
	{89452, 0x1},
	{983, 0x1FFE},
	{220, 0x2000},
	{97314, 0x4000},
	{101336, 0x8000},
	{101348, 0xFFF0000},
	{101359, 0x10000000},
	{101370, 0x20000000},
	{101380, 0x40000000},
	{101314, 0x80000000},
	/* 7319 */
	{113793, 0xF},
	{113808, 0x10},
	{134575, 0x20},
	{113832, 0x40},
	{113848, 0x80},
	{134595, 0x100},
	{134621, 0x200},
	{113906, 0x3C00},
	{113922, 0x4000},
	{113943, 0x8000},
	{134638, 0xFFFF0000},
	/* 7330 */
	{114206, 0x3},
	{134652, 0xC},
	{114219, 0x30},
	{114232, 0xC0},
	/* 7334 */
	{134665, 0x3FF},
	{134675, 0xFFC00},
	{50481, 0xF00000},
	{101461, 0xF000000},
	{101472, 0xF0000000},
	/* 7339 */
	{134685, 0x3FF},
	{134695, 0xFFC00},
	{101503, 0xF000000},
	{101514, 0xF0000000},
	/* 7343 */
	{452, 0x7},
	{11680, 0x40000000},
	{10330, 0x80000000},
	/* 7346 */
	{101442, 0x3F},
	{102261, 0x400},
	{102288, 0x800},
	{120329, 0x1000},
	{102315, 0x2000},
	{102341, 0x4000},
	{102367, 0x10000},
	{102394, 0x20000},
	{102420, 0x40000},
	{102446, 0x80000},
	{102474, 0x100000},
	{102500, 0x200000},
	{102526, 0x400000},
	{120356, 0x800000},
	{102552, 0x1000000},
	{102579, 0x2000000},
	{102606, 0x4000000},
	{120382, 0x8000000},
	{120408, 0x10000000},
	{102686, 0x20000000},
	{102715, 0x40000000},
	{102741, 0x80000000},
	/* 7368 */
	{101442, 0x3F},
	{102261, 0x400},
	{102288, 0x800},
	{102315, 0x1000},
	{102341, 0x2000},
	{102367, 0x8000},
	{102394, 0x10000},
	{102474, 0x20000},
	{102500, 0x40000},
	{120329, 0x80000},
	{102420, 0x100000},
	{102579, 0x200000},
	{102741, 0x400000},
	/* 7381 */
	{134705, 0xFF},
	{10813, 0xFFFFFF00},
	/* 7383 */
	{63669, 0x1},
	{63673, 0x6},
	{63682, 0x18},
	{51265, 0x20},
	{63692, 0x40},
	{63700, 0x80},
	{63710, 0x100},
	{63721, 0x200},
	{63727, 0x400},
	{63732, 0x800},
	{63738, 0x1000},
	{54277, 0x2000},
	{63749, 0x4000},
	{118697, 0x8000},
	{63515, 0x10000},
	{63769, 0x20000},
	{63777, 0x40000},
	{63789, 0x80000},
	{115847, 0x100000},
	{115861, 0x200000},
	{132362, 0x400000},
	{63797, 0x800000},
	{63808, 0x8000000},
	{76117, 0x10000000},
	{43402, 0x80000000},
	/* 7408 */
	{63820, 0x1FF, 257, 0},
	{63825, 0x400},
	{63833, 0x800},
	{63846, 0x7000},
	{63865, 0x3F0000},
	{107676, 0x400000},
	{107614, 0x1000000},
	{107710, 0x2000000},
	{107696, 0x4000000},
	{63906, 0x10000000},
	{63918, 0xE0000000},
	/* 7419 */
	{59029, 0xF},
	{63926, 0x30},
	{63934, 0xC0},
	{63942, 0xF00},
	{63948, 0x1000},
	{29316, 0xE000},
	{63966, 0xF0000},
	{63972, 0xF00000},
	{63978, 0x7000000},
	{63987, 0x38000000},
	{63996, 0xC0000000},
	/* 7430 */
	{64002, 0x3F},
	{64012, 0xFC0},
	{134730, 0x3F000},
	{64022, 0xFC0000},
	{64032, 0xF000000},
	/* 7435 */
	{64385, 0xF},
	{64408, 0x10},
	{64431, 0x20},
	{64454, 0x40},
	{64474, 0x80},
	{64494, 0x100},
	{64514, 0x200},
	{64534, 0x400},
	{64554, 0x800},
	{64574, 0x1000},
	{64594, 0x2000},
	{64614, 0x4000},
	{64629, 0x8000},
	{64640, 0x10000},
	{64648, 0x20000},
	{64657, 0x40000},
	{64674, 0x80000},
	{64689, 0x100000},
	{134742, 0x200000},
	{134752, 0x400000},
	{64746, 0x1000000},
	{65684, 0x2000000},
	{132382, 0x4000000},
	{64764, 0x10000000},
	{64773, 0x20000000},
	{64782, 0x40000000},
	{64791, 0x80000000},
	/* 7462 */
	{107773, 0x7F},
	{134767, 0x700},
	{134787, 0x3F0000},
	{134809, 0x80000000},
	/* 7466 */
	{107773, 0x7F},
	{134787, 0x3F0000},
	{134809, 0x80000000},
	/* 7469 */
	{116334, 0x1},
	{116356, 0x2},
	{43436, 0xFFFFC},
	{134827, 0xFFF00000},
	/* 7473 */
	{2288, 0x3FF},
	/* 7474 */
	{68753, 0xFF},
	{73399, 0xFFF00},
	{114598, 0x3F00000, 64, 37607},
	{114610, 0x3C000000, 16, 37732},
	{91086, 0x40000000},
	{134250, 0x80000000},
	/* 7480 */
	{77244, 0x3},
	{77274, 0x1FFE0},
	/* 7482 */
	{63452, 0xFFFF},
	/* 7483 */
	{134854, 0x3F},
	{111521, 0x400},
	{111535, 0x800},
	{134867, 0x10000},
};

static const char sid_strings[] = {
	'N', 'O', 'P', '\0', /* NOP (0, 1) */
	'S', 'E', 'T', '_', 'B', 'A', 'S', 'E', '\0', /* SET_BASE (4, 8) */
	'C', 'L', 'E', 'A', 'R', '_', 'S', 'T', 'A', 'T', 'E', '\0', /* CLEAR_STATE (13) */
	'I', 'N', 'D', 'E', 'X', '_', 'B', 'U', 'F', 'F', 'E', 'R', '_', 'S', 'I', 'Z', 'E', '\0', /* INDEX_BUFFER_SIZE (25, 38) */
	'D', 'I', 'S', 'P', 'A', 'T', 'C', 'H', '_', 'D', 'I', 'R', 'E', 'C', 'T', '\0', /* DISPATCH_DIRECT (43) */
	'D', 'I', 'S', 'P', 'A', 'T', 'C', 'H', '_', 'I', 'N', 'D', 'I', 'R', 'E', 'C', 'T', '\0', /* DISPATCH_INDIRECT (59) */
	'A', 'T', 'O', 'M', 'I', 'C', '_', 'M', 'E', 'M', '\0', /* ATOMIC_MEM (77, 84) */
	'O', 'C', 'C', 'L', 'U', 'S', 'I', 'O', 'N', '_', 'Q', 'U', 'E', 'R', 'Y', '\0', /* OCCLUSION_QUERY (88, 102) */
	'S', 'E', 'T', '_', 'P', 'R', 'E', 'D', 'I', 'C', 'A', 'T', 'I', 'O', 'N', '\0', /* SET_PREDICATION (104) */
	'C', 'O', 'N', 'D', '_', 'E', 'X', 'E', 'C', '\0', /* COND_EXEC (120) */
	'P', 'R', 'E', 'D', '_', 'E', 'X', 'E', 'C', '\0', /* PRED_EXEC (130) */
	'D', 'R', 'A', 'W', '_', 'I', 'N', 'D', 'I', 'R', 'E', 'C', 'T', '\0', /* DRAW_INDIRECT (140) */
	'D', 'R', 'A', 'W', '_', 'I', 'N', 'D', 'E', 'X', '_', 'I', 'N', 'D', 'I', 'R', 'E', 'C', 'T', '\0', /* DRAW_INDEX_INDIRECT (154) */
	'I', 'N', 'D', 'E', 'X', '_', 'B', 'A', 'S', 'E', '\0', /* INDEX_BASE (174) */
	'D', 'R', 'A', 'W', '_', 'I', 'N', 'D', 'E', 'X', '_', '2', '\0', /* DRAW_INDEX_2 (185) */
	'C', 'O', 'N', 'T', 'E', 'X', 'T', '_', 'C', 'O', 'N', 'T', 'R', 'O', 'L', '\0', /* CONTEXT_CONTROL (198, 206) */
	'I', 'N', 'D', 'E', 'X', '_', 'T', 'Y', 'P', 'E', '\0', /* INDEX_TYPE (214, 220) */
	'D', 'R', 'A', 'W', '_', 'I', 'N', 'D', 'I', 'R', 'E', 'C', 'T', '_', 'M', 'U', 'L', 'T', 'I', '\0', /* DRAW_INDIRECT_MULTI (225) */
	'D', 'R', 'A', 'W', '_', 'I', 'N', 'D', 'E', 'X', '_', 'A', 'U', 'T', 'O', '\0', /* DRAW_INDEX_AUTO (245, 256) */
	'D', 'R', 'A', 'W', '_', 'I', 'N', 'D', 'E', 'X', '_', 'I', 'M', 'M', 'D', '\0', /* DRAW_INDEX_IMMD (261) */
	'N', 'U', 'M', '_', 'I', 'N', 'S', 'T', 'A', 'N', 'C', 'E', 'S', '\0', /* NUM_INSTANCES (277) */
	'D', 'R', 'A', 'W', '_', 'I', 'N', 'D', 'E', 'X', '_', 'M', 'U', 'L', 'T', 'I', '_', 'A', 'U', 'T', 'O', '\0', /* DRAW_INDEX_MULTI_AUTO (291) */
	'I', 'N', 'D', 'I', 'R', 'E', 'C', 'T', '_', 'B', 'U', 'F', 'F', 'E', 'R', '_', 'S', 'I', '\0', /* INDIRECT_BUFFER_SI (313) */
	'I', 'N', 'D', 'I', 'R', 'E', 'C', 'T', '_', 'B', 'U', 'F', 'F', 'E', 'R', '_', 'C', 'O', 'N', 'S', 'T', '\0', /* INDIRECT_BUFFER_CONST (332) */
	'S', 'T', 'R', 'M', 'O', 'U', 'T', '_', 'B', 'U', 'F', 'F', 'E', 'R', '_', 'U', 'P', 'D', 'A', 'T', 'E', '\0', /* STRMOUT_BUFFER_UPDATE (354) */
	'D', 'R', 'A', 'W', '_', 'I', 'N', 'D', 'E', 'X', '_', 'O', 'F', 'F', 'S', 'E', 'T', '_', '2', '\0', /* DRAW_INDEX_OFFSET_2 (376) */
	'W', 'R', 'I', 'T', 'E', '_', 'D', 'A', 'T', 'A', '\0', /* WRITE_DATA (396, 402) */
	'D', 'R', 'A', 'W', '_', 'I', 'N', 'D', 'E', 'X', '_', 'I', 'N', 'D', 'I', 'R', 'E', 'C', 'T', '_', 'M', 'U', 'L', 'T', 'I', '\0', /* DRAW_INDEX_INDIRECT_MULTI (407) */
	'M', 'E', 'M', '_', 'S', 'E', 'M', 'A', 'P', 'H', 'O', 'R', 'E', '\0', /* MEM_SEMAPHORE (433) */
	'M', 'P', 'E', 'G', '_', 'I', 'N', 'D', 'E', 'X', '\0', /* MPEG_INDEX (447, 452, 456) */
	'W', 'A', 'I', 'T', '_', 'R', 'E', 'G', '_', 'M', 'E', 'M', '\0', /* WAIT_REG_MEM (458) */
	'M', 'E', 'M', '_', 'W', 'R', 'I', 'T', 'E', '\0', /* MEM_WRITE (471) */
	'I', 'N', 'D', 'I', 'R', 'E', 'C', 'T', '_', 'B', 'U', 'F', 'F', 'E', 'R', '\0', /* INDIRECT_BUFFER (481, 490) */
	'C', 'O', 'P', 'Y', '_', 'D', 'A', 'T', 'A', '\0', /* COPY_DATA (497) */
	'C', 'P', '_', 'D', 'M', 'A', '\0', /* CP_DMA (507) */
	'P', 'F', 'P', '_', 'S', 'Y', 'N', 'C', '_', 'M', 'E', '\0', /* PFP_SYNC_ME (514, 523) */
	'S', 'U', 'R', 'F', 'A', 'C', 'E', '_', 'S', 'Y', 'N', 'C', '\0', /* SURFACE_SYNC (526) */
	'M', 'E', '_', 'I', 'N', 'I', 'T', 'I', 'A', 'L', 'I', 'Z', 'E', '\0', /* ME_INITIALIZE (539) */
	'C', 'O', 'N', 'D', '_', 'W', 'R', 'I', 'T', 'E', '\0', /* COND_WRITE (553) */
	'E', 'V', 'E', 'N', 'T', '_', 'W', 'R', 'I', 'T', 'E', '\0', /* EVENT_WRITE (564) */
	'E', 'V', 'E', 'N', 'T', '_', 'W', 'R', 'I', 'T', 'E', '_', 'E', 'O', 'P', '\0', /* EVENT_WRITE_EOP (576) */
	'E', 'V', 'E', 'N', 'T', '_', 'W', 'R', 'I', 'T', 'E', '_', 'E', 'O', 'S', '\0', /* EVENT_WRITE_EOS (592) */
	'R', 'E', 'L', 'E', 'A', 'S', 'E', '_', 'M', 'E', 'M', '\0', /* RELEASE_MEM (608) */
	'D', 'I', 'S', 'P', 'A', 'T', 'C', 'H', '_', 'M', 'E', 'S', 'H', '_', 'I', 'N', 'D', 'I', 'R', 'E', 'C', 'T', '_', 'M', 'U', 'L', 'T', 'I', '\0', /* DISPATCH_MESH_INDIRECT_MULTI (620) */
	'D', 'I', 'S', 'P', 'A', 'T', 'C', 'H', '_', 'T', 'A', 'S', 'K', 'M', 'E', 'S', 'H', '_', 'G', 'F', 'X', '\0', /* DISPATCH_TASKMESH_GFX (649, 667) */
	'D', 'I', 'S', 'P', 'A', 'T', 'C', 'H', '_', 'M', 'E', 'S', 'H', '_', 'D', 'I', 'R', 'E', 'C', 'T', '\0', /* DISPATCH_MESH_DIRECT (671) */
	'D', 'M', 'A', '_', 'D', 'A', 'T', 'A', '\0', /* DMA_DATA (692) */
	'C', 'O', 'N', 'T', 'E', 'X', 'T', '_', 'R', 'E', 'G', '_', 'R', 'M', 'W', '\0', /* CONTEXT_REG_RMW (701) */
	'O', 'N', 'E', '_', 'R', 'E', 'G', '_', 'W', 'R', 'I', 'T', 'E', '\0', /* ONE_REG_WRITE (717) */
	'A', 'C', 'Q', 'U', 'I', 'R', 'E', '_', 'M', 'E', 'M', '\0', /* ACQUIRE_MEM (731) */
	'R', 'E', 'W', 'I', 'N', 'D', '\0', /* REWIND (743) */
	'P', 'R', 'I', 'M', 'E', '_', 'U', 'T', 'C', 'L', '2', '\0', /* PRIME_UTCL2 (750) */
	'L', 'O', 'A', 'D', '_', 'U', 'C', 'O', 'N', 'F', 'I', 'G', '_', 'R', 'E', 'G', '\0', /* LOAD_UCONFIG_REG (762) */
	'L', 'O', 'A', 'D', '_', 'S', 'H', '_', 'R', 'E', 'G', '\0', /* LOAD_SH_REG (779) */
	'L', 'O', 'A', 'D', '_', 'C', 'O', 'N', 'T', 'E', 'X', 'T', '_', 'R', 'E', 'G', '\0', /* LOAD_CONTEXT_REG (791) */
	'L', 'O', 'A', 'D', '_', 'S', 'H', '_', 'R', 'E', 'G', '_', 'I', 'N', 'D', 'E', 'X', '\0', /* LOAD_SH_REG_INDEX (808) */
	'S', 'E', 'T', '_', 'C', 'O', 'N', 'F', 'I', 'G', '_', 'R', 'E', 'G', '\0', /* SET_CONFIG_REG (826) */
	'S', 'E', 'T', '_', 'C', 'O', 'N', 'T', 'E', 'X', 'T', '_', 'R', 'E', 'G', '\0', /* SET_CONTEXT_REG (841) */
	'S', 'E', 'T', '_', 'S', 'H', '_', 'R', 'E', 'G', '\0', /* SET_SH_REG (857) */
	'S', 'E', 'T', '_', 'S', 'H', '_', 'R', 'E', 'G', '_', 'O', 'F', 'F', 'S', 'E', 'T', '\0', /* SET_SH_REG_OFFSET (868, 879) */
	'S', 'E', 'T', '_', 'U', 'C', 'O', 'N', 'F', 'I', 'G', '_', 'R', 'E', 'G', '\0', /* SET_UCONFIG_REG (886) */
	'S', 'E', 'T', '_', 'U', 'C', 'O', 'N', 'F', 'I', 'G', '_', 'R', 'E', 'G', '_', 'I', 'N', 'D', 'E', 'X', '\0', /* SET_UCONFIG_REG_INDEX (902) */
	'L', 'O', 'A', 'D', '_', 'C', 'O', 'N', 'S', 'T', '_', 'R', 'A', 'M', '\0', /* LOAD_CONST_RAM (924) */
	'W', 'R', 'I', 'T', 'E', '_', 'C', 'O', 'N', 'S', 'T', '_', 'R', 'A', 'M', '\0', /* WRITE_CONST_RAM (939) */
	'D', 'U', 'M', 'P', '_', 'C', 'O', 'N', 'S', 'T', '_', 'R', 'A', 'M', '\0', /* DUMP_CONST_RAM (955) */
	'I', 'N', 'C', 'R', 'E', 'M', 'E', 'N', 'T', '_', 'C', 'E', '_', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '\0', /* INCREMENT_CE_COUNTER (970, 983) */
	'I', 'N', 'C', 'R', 'E', 'M', 'E', 'N', 'T', '_', 'D', 'E', '_', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '\0', /* INCREMENT_DE_COUNTER (991) */
	'W', 'A', 'I', 'T', '_', 'O', 'N', '_', 'C', 'E', '_', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '\0', /* WAIT_ON_CE_COUNTER (1012) */
	'S', 'E', 'T', '_', 'S', 'H', '_', 'R', 'E', 'G', '_', 'I', 'N', 'D', 'E', 'X', '\0', /* SET_SH_REG_INDEX (1031) */
	'L', 'O', 'A', 'D', '_', 'C', 'O', 'N', 'T', 'E', 'X', 'T', '_', 'R', 'E', 'G', '_', 'I', 'N', 'D', 'E', 'X', '\0', /* LOAD_CONTEXT_REG_INDEX (1048) */
	'D', 'I', 'S', 'P', 'A', 'T', 'C', 'H', '_', 'D', 'I', 'R', 'E', 'C', 'T', '_', 'I', 'N', 'T', 'E', 'R', 'L', 'E', 'A', 'V', 'E', 'D', '\0', /* DISPATCH_DIRECT_INTERLEAVED (1071) */
	'D', 'I', 'S', 'P', 'A', 'T', 'C', 'H', '_', 'I', 'N', 'D', 'I', 'R', 'E', 'C', 'T', '_', 'I', 'N', 'T', 'E', 'R', 'L', 'E', 'A', 'V', 'E', 'D', '\0', /* DISPATCH_INDIRECT_INTERLEAVED (1099) */
	'D', 'I', 'S', 'P', 'A', 'T', 'C', 'H', '_', 'T', 'A', 'S', 'K', '_', 'S', 'T', 'A', 'T', 'E', '_', 'I', 'N', 'I', 'T', '\0', /* DISPATCH_TASK_STATE_INIT (1129) */
	'D', 'I', 'S', 'P', 'A', 'T', 'C', 'H', '_', 'T', 'A', 'S', 'K', 'M', 'E', 'S', 'H', '_', 'D', 'I', 'R', 'E', 'C', 'T', '_', 'A', 'C', 'E', '\0', /* DISPATCH_TASKMESH_DIRECT_ACE (1154, 1180) */
	'D', 'I', 'S', 'P', 'A', 'T', 'C', 'H', '_', 'T', 'A', 'S', 'K', 'M', 'E', 'S', 'H', '_', 'I', 'N', 'D', 'I', 'R', 'E', 'C', 'T', '_', 'M', 'U', 'L', 'T', 'I', '_', 'A', 'C', 'E', '\0', /* DISPATCH_TASKMESH_INDIRECT_MULTI_ACE (1183) */
	'E', 'V', 'E', 'N', 'T', '_', 'W', 'R', 'I', 'T', 'E', '_', 'Z', 'P', 'A', 'S', 'S', '\0', /* EVENT_WRITE_ZPASS (1220) */
	'S', 'E', 'T', '_', 'C', 'O', 'N', 'T', 'E', 'X', 'T', '_', 'R', 'E', 'G', '_', 'P', 'A', 'I', 'R', 'S', '\0', /* SET_CONTEXT_REG_PAIRS (1238) */
	'S', 'E', 'T', '_', 'C', 'O', 'N', 'T', 'E', 'X', 'T', '_', 'R', 'E', 'G', '_', 'P', 'A', 'I', 'R', 'S', '_', 'P', 'A', 'C', 'K', 'E', 'D', '\0', /* SET_CONTEXT_REG_PAIRS_PACKED (1260) */
	'S', 'E', 'T', '_', 'S', 'H', '_', 'R', 'E', 'G', '_', 'P', 'A', 'I', 'R', 'S', '\0', /* SET_SH_REG_PAIRS (1289) */
	'S', 'E', 'T', '_', 'S', 'H', '_', 'R', 'E', 'G', '_', 'P', 'A', 'I', 'R', 'S', '_', 'P', 'A', 'C', 'K', 'E', 'D', '\0', /* SET_SH_REG_PAIRS_PACKED (1306) */
	'S', 'E', 'T', '_', 'S', 'H', '_', 'R', 'E', 'G', '_', 'P', 'A', 'I', 'R', 'S', '_', 'P', 'A', 'C', 'K', 'E', 'D', '_', 'N', '\0', /* SET_SH_REG_PAIRS_PACKED_N (1330) */
	'S', 'E', 'T', '_', 'U', 'C', 'O', 'N', 'F', 'I', 'G', '_', 'R', 'E', 'G', '_', 'P', 'A', 'I', 'R', 'S', '\0', /* SET_UCONFIG_REG_PAIRS (1356) */
	'I', 'T', '_', 'O', 'P', 'C', 'O', 'D', 'E', '_', 'C', '\0', /* IT_OPCODE_C (1378) */
	'S', 'Q', '_', 'W', 'A', 'V', 'E', '_', 'M', 'O', 'D', 'E', '\0', /* SQ_WAVE_MODE (1390, 1398, 1400) */
	'S', 'Q', '_', 'W', 'A', 'V', 'E', '_', 'S', 'T', 'A', 'T', 'U', 'S', '\0', /* SQ_WAVE_STATUS (1403, 1411) */
	'S', 'Q', '_', 'W', 'A', 'V', 'E', '_', 'T', 'R', 'A', 'P', 'S', 'T', 'S', '\0', /* SQ_WAVE_TRAPSTS (1418) */
	'S', 'Q', '_', 'W', 'A', 'V', 'E', '_', 'H', 'W', '_', 'I', 'D', '_', 'L', 'E', 'G', 'A', 'C', 'Y', '\0', /* SQ_WAVE_HW_ID_LEGACY (1434) */
	'S', 'Q', '_', 'W', 'A', 'V', 'E', '_', 'G', 'P', 'R', '_', 'A', 'L', 'L', 'O', 'C', '\0', /* SQ_WAVE_GPR_ALLOC (1455) */
	'S', 'Q', '_', 'W', 'A', 'V', 'E', '_', 'L', 'D', 'S', '_', 'A', 'L', 'L', 'O', 'C', '\0', /* SQ_WAVE_LDS_ALLOC (1473) */
	'S', 'Q', '_', 'W', 'A', 'V', 'E', '_', 'I', 'B', '_', 'S', 'T', 'S', '\0', /* SQ_WAVE_IB_STS (1491) */
	'S', 'Q', '_', 'W', 'A', 'V', 'E', '_', 'P', 'C', '_', 'L', 'O', '\0', /* SQ_WAVE_PC_LO (1506) */
	'S', 'Q', '_', 'W', 'A', 'V', 'E', '_', 'P', 'C', '_', 'H', 'I', '\0', /* SQ_WAVE_PC_HI (1520, 1528) */
	'S', 'Q', '_', 'W', 'A', 'V', 'E', '_', 'I', 'N', 'S', 'T', '_', 'D', 'W', '0', '\0', /* SQ_WAVE_INST_DW0 (1534) */
	'S', 'Q', '_', 'W', 'A', 'V', 'E', '_', 'I', 'B', '_', 'D', 'B', 'G', '1', '\0', /* SQ_WAVE_IB_DBG1 (1551) */
	'S', 'Q', '_', 'W', 'A', 'V', 'E', '_', 'F', 'L', 'U', 'S', 'H', '_', 'I', 'B', '\0', /* SQ_WAVE_FLUSH_IB (1567) */
	'S', 'Q', '_', 'W', 'A', 'V', 'E', '_', 'H', 'W', '_', 'I', 'D', '1', '\0', /* SQ_WAVE_HW_ID1 (1584) */
	'S', 'Q', '_', 'W', 'A', 'V', 'E', '_', 'H', 'W', '_', 'I', 'D', '2', '\0', /* SQ_WAVE_HW_ID2 (1599) */
	'S', 'Q', '_', 'W', 'A', 'V', 'E', '_', 'P', 'O', 'P', 'S', '_', 'P', 'A', 'C', 'K', 'E', 'R', '\0', /* SQ_WAVE_POPS_PACKER (1614) */
	'S', 'Q', '_', 'W', 'A', 'V', 'E', '_', 'S', 'C', 'H', 'E', 'D', '_', 'M', 'O', 'D', 'E', '\0', /* SQ_WAVE_SCHED_MODE (1634) */
	'S', 'Q', '_', 'W', 'A', 'V', 'E', '_', 'V', 'G', 'P', 'R', '_', 'O', 'F', 'F', 'S', 'E', 'T', '\0', /* SQ_WAVE_VGPR_OFFSET (1653) */
	'S', 'Q', '_', 'W', 'A', 'V', 'E', '_', 'I', 'B', '_', 'S', 'T', 'S', '2', '\0', /* SQ_WAVE_IB_STS2 (1673) */
	'S', 'Q', '_', 'W', 'A', 'V', 'E', '_', 'T', 'T', 'M', 'P', '0', '\0', /* SQ_WAVE_TTMP0 (1689) */
	'S', 'Q', '_', 'W', 'A', 'V', 'E', '_', 'T', 'T', 'M', 'P', '1', '\0', /* SQ_WAVE_TTMP1 (1703) */
	'S', 'Q', '_', 'W', 'A', 'V', 'E', '_', 'T', 'T', 'M', 'P', '2', '\0', /* SQ_WAVE_TTMP2 (1717) */
	'S', 'Q', '_', 'W', 'A', 'V', 'E', '_', 'T', 'T', 'M', 'P', '3', '\0', /* SQ_WAVE_TTMP3 (1731) */
	'S', 'Q', '_', 'W', 'A', 'V', 'E', '_', 'T', 'T', 'M', 'P', '4', '\0', /* SQ_WAVE_TTMP4 (1745) */
	'S', 'Q', '_', 'W', 'A', 'V', 'E', '_', 'T', 'T', 'M', 'P', '5', '\0', /* SQ_WAVE_TTMP5 (1759) */
	'S', 'Q', '_', 'W', 'A', 'V', 'E', '_', 'T', 'T', 'M', 'P', '6', '\0', /* SQ_WAVE_TTMP6 (1773) */
	'S', 'Q', '_', 'W', 'A', 'V', 'E', '_', 'T', 'T', 'M', 'P', '7', '\0', /* SQ_WAVE_TTMP7 (1787) */
	'S', 'Q', '_', 'W', 'A', 'V', 'E', '_', 'T', 'T', 'M', 'P', '8', '\0', /* SQ_WAVE_TTMP8 (1801) */
	'S', 'Q', '_', 'W', 'A', 'V', 'E', '_', 'T', 'T', 'M', 'P', '9', '\0', /* SQ_WAVE_TTMP9 (1815) */
	'S', 'Q', '_', 'W', 'A', 'V', 'E', '_', 'T', 'T', 'M', 'P', '1', '0', '\0', /* SQ_WAVE_TTMP10 (1829) */
	'S', 'Q', '_', 'W', 'A', 'V', 'E', '_', 'T', 'T', 'M', 'P', '1', '1', '\0', /* SQ_WAVE_TTMP11 (1844) */
	'S', 'Q', '_', 'W', 'A', 'V', 'E', '_', 'T', 'T', 'M', 'P', '1', '2', '\0', /* SQ_WAVE_TTMP12 (1859) */
	'S', 'Q', '_', 'W', 'A', 'V', 'E', '_', 'T', 'T', 'M', 'P', '1', '3', '\0', /* SQ_WAVE_TTMP13 (1874) */
	'S', 'Q', '_', 'W', 'A', 'V', 'E', '_', 'T', 'T', 'M', 'P', '1', '4', '\0', /* SQ_WAVE_TTMP14 (1889) */
	'S', 'Q', '_', 'W', 'A', 'V', 'E', '_', 'T', 'T', 'M', 'P', '1', '5', '\0', /* SQ_WAVE_TTMP15 (1904) */
	'S', 'Q', '_', 'W', 'A', 'V', 'E', '_', 'M', '0', '\0', /* SQ_WAVE_M0 (1919) */
	'S', 'Q', '_', 'W', 'A', 'V', 'E', '_', 'E', 'X', 'E', 'C', '_', 'L', 'O', '\0', /* SQ_WAVE_EXEC_LO (1930) */
	'S', 'Q', '_', 'W', 'A', 'V', 'E', '_', 'E', 'X', 'E', 'C', '_', 'H', 'I', '\0', /* SQ_WAVE_EXEC_HI (1946) */
	'S', 'Q', '_', 'W', 'A', 'V', 'E', '_', 'F', 'L', 'A', 'T', '_', 'S', 'C', 'R', 'A', 'T', 'C', 'H', '_', 'L', 'O', '\0', /* SQ_WAVE_FLAT_SCRATCH_LO (1962) */
	'S', 'Q', '_', 'W', 'A', 'V', 'E', '_', 'F', 'L', 'A', 'T', '_', 'S', 'C', 'R', 'A', 'T', 'C', 'H', '_', 'H', 'I', '\0', /* SQ_WAVE_FLAT_SCRATCH_HI (1986) */
	'S', 'Q', '_', 'W', 'A', 'V', 'E', '_', 'F', 'L', 'A', 'T', '_', 'X', 'N', 'A', 'C', 'K', '_', 'M', 'A', 'S', 'K', '\0', /* SQ_WAVE_FLAT_XNACK_MASK (2010) */
	'G', 'R', 'B', 'M', '_', 'S', 'T', 'A', 'T', 'U', 'S', '2', '\0', /* GRBM_STATUS2 (2034) */
	'G', 'R', 'B', 'M', '_', 'S', 'T', 'A', 'T', 'U', 'S', '\0', /* GRBM_STATUS (2047) */
	'G', 'R', 'B', 'M', '_', 'S', 'T', 'A', 'T', 'U', 'S', '_', 'S', 'E', '0', '\0', /* GRBM_STATUS_SE0 (2059) */
	'G', 'R', 'B', 'M', '_', 'S', 'T', 'A', 'T', 'U', 'S', '_', 'S', 'E', '1', '\0', /* GRBM_STATUS_SE1 (2075) */
	'G', 'R', 'B', 'M', '_', 'S', 'T', 'A', 'T', 'U', 'S', '3', '\0', /* GRBM_STATUS3 (2091) */
	'G', 'R', 'B', 'M', '_', 'S', 'T', 'A', 'T', 'U', 'S', '_', 'S', 'E', '2', '\0', /* GRBM_STATUS_SE2 (2104) */
	'G', 'R', 'B', 'M', '_', 'S', 'T', 'A', 'T', 'U', 'S', '_', 'S', 'E', '3', '\0', /* GRBM_STATUS_SE3 (2120) */
	'C', 'P', '_', 'C', 'P', 'C', '_', 'S', 'T', 'A', 'T', 'U', 'S', '\0', /* CP_CPC_STATUS (2136) */
	'C', 'P', '_', 'C', 'P', 'C', '_', 'B', 'U', 'S', 'Y', '_', 'S', 'T', 'A', 'T', '\0', /* CP_CPC_BUSY_STAT (2150) */
	'C', 'P', '_', 'C', 'P', 'C', '_', 'S', 'T', 'A', 'L', 'L', 'E', 'D', '_', 'S', 'T', 'A', 'T', '1', '\0', /* CP_CPC_STALLED_STAT1 (2167, 2185) */
	'C', 'P', '_', 'C', 'P', 'F', '_', 'S', 'T', 'A', 'T', 'U', 'S', '\0', /* CP_CPF_STATUS (2188) */
	'C', 'P', '_', 'C', 'P', 'F', '_', 'B', 'U', 'S', 'Y', '_', 'S', 'T', 'A', 'T', '\0', /* CP_CPF_BUSY_STAT (2202) */
	'C', 'P', '_', 'C', 'P', 'F', '_', 'S', 'T', 'A', 'L', 'L', 'E', 'D', '_', 'S', 'T', 'A', 'T', '1', '\0', /* CP_CPF_STALLED_STAT1 (2219) */
	'C', 'P', '_', 'C', 'P', 'C', '_', 'B', 'U', 'S', 'Y', '_', 'S', 'T', 'A', 'T', '2', '\0', /* CP_CPC_BUSY_STAT2 (2240, 2255) */
	'C', 'P', '_', 'C', 'P', 'C', '_', 'G', 'R', 'B', 'M', '_', 'F', 'R', 'E', 'E', '_', 'C', 'O', 'U', 'N', 'T', '\0', /* CP_CPC_GRBM_FREE_COUNT (2258, 2270, 2275) */
	'C', 'P', '_', 'C', 'P', 'C', '_', 'S', 'C', 'R', 'A', 'T', 'C', 'H', '_', 'I', 'N', 'D', 'E', 'X', '\0', /* CP_CPC_SCRATCH_INDEX (2281, 2288) */
	'C', 'P', '_', 'C', 'P', 'C', '_', 'S', 'C', 'R', 'A', 'T', 'C', 'H', '_', 'D', 'A', 'T', 'A', '\0', /* CP_CPC_SCRATCH_DATA (2302) */
	'C', 'P', '_', 'C', 'P', 'F', '_', 'G', 'R', 'B', 'M', '_', 'F', 'R', 'E', 'E', '_', 'C', 'O', 'U', 'N', 'T', '\0', /* CP_CPF_GRBM_FREE_COUNT (2322) */
	'C', 'P', '_', 'C', 'P', 'F', '_', 'B', 'U', 'S', 'Y', '_', 'S', 'T', 'A', 'T', '2', '\0', /* CP_CPF_BUSY_STAT2 (2345) */
	'C', 'P', '_', 'C', 'P', 'C', '_', 'H', 'A', 'L', 'T', '_', 'H', 'Y', 'S', 'T', '_', 'C', 'O', 'U', 'N', 'T', '\0', /* CP_CPC_HALT_HYST_COUNT (2363) */
	'S', 'Q', '_', 'T', 'H', 'R', 'E', 'A', 'D', '_', 'T', 'R', 'A', 'C', 'E', '_', 'B', 'U', 'F', '0', '_', 'B', 'A', 'S', 'E', '\0', /* SQ_THREAD_TRACE_BUF0_BASE (2386) */
	'S', 'Q', '_', 'T', 'H', 'R', 'E', 'A', 'D', '_', 'T', 'R', 'A', 'C', 'E', '_', 'B', 'U', 'F', '0', '_', 'S', 'I', 'Z', 'E', '\0', /* SQ_THREAD_TRACE_BUF0_SIZE (2412) */
	'S', 'Q', '_', 'T', 'H', 'R', 'E', 'A', 'D', '_', 'T', 'R', 'A', 'C', 'E', '_', 'B', 'U', 'F', '1', '_', 'B', 'A', 'S', 'E', '\0', /* SQ_THREAD_TRACE_BUF1_BASE (2438) */
	'S', 'Q', '_', 'T', 'H', 'R', 'E', 'A', 'D', '_', 'T', 'R', 'A', 'C', 'E', '_', 'B', 'U', 'F', '1', '_', 'S', 'I', 'Z', 'E', '\0', /* SQ_THREAD_TRACE_BUF1_SIZE (2464) */
	'S', 'Q', '_', 'T', 'H', 'R', 'E', 'A', 'D', '_', 'T', 'R', 'A', 'C', 'E', '_', 'W', 'P', 'T', 'R', '\0', /* SQ_THREAD_TRACE_WPTR (2490, 2506) */
	'S', 'Q', '_', 'T', 'H', 'R', 'E', 'A', 'D', '_', 'T', 'R', 'A', 'C', 'E', '_', 'M', 'A', 'S', 'K', '\0', /* SQ_THREAD_TRACE_MASK (2511) */
	'S', 'Q', '_', 'T', 'H', 'R', 'E', 'A', 'D', '_', 'T', 'R', 'A', 'C', 'E', '_', 'T', 'O', 'K', 'E', 'N', '_', 'M', 'A', 'S', 'K', '\0', /* SQ_THREAD_TRACE_TOKEN_MASK (2532, 2548) */
	'S', 'Q', '_', 'T', 'H', 'R', 'E', 'A', 'D', '_', 'T', 'R', 'A', 'C', 'E', '_', 'C', 'T', 'R', 'L', '\0', /* SQ_THREAD_TRACE_CTRL (2559) */
	'S', 'Q', '_', 'T', 'H', 'R', 'E', 'A', 'D', '_', 'T', 'R', 'A', 'C', 'E', '_', 'S', 'T', 'A', 'T', 'U', 'S', '\0', /* SQ_THREAD_TRACE_STATUS (2580) */
	'S', 'Q', '_', 'T', 'H', 'R', 'E', 'A', 'D', '_', 'T', 'R', 'A', 'C', 'E', '_', 'D', 'R', 'O', 'P', 'P', 'E', 'D', '_', 'C', 'N', 'T', 'R', '\0', /* SQ_THREAD_TRACE_DROPPED_CNTR (2603) */
	'S', 'Q', '_', 'T', 'H', 'R', 'E', 'A', 'D', '_', 'T', 'R', 'A', 'C', 'E', '_', 'G', 'F', 'X', '_', 'D', 'R', 'A', 'W', '_', 'C', 'N', 'T', 'R', '\0', /* SQ_THREAD_TRACE_GFX_DRAW_CNTR (2632) */
	'S', 'Q', '_', 'T', 'H', 'R', 'E', 'A', 'D', '_', 'T', 'R', 'A', 'C', 'E', '_', 'G', 'F', 'X', '_', 'M', 'A', 'R', 'K', 'E', 'R', '_', 'C', 'N', 'T', 'R', '\0', /* SQ_THREAD_TRACE_GFX_MARKER_CNTR (2662) */
	'S', 'Q', '_', 'T', 'H', 'R', 'E', 'A', 'D', '_', 'T', 'R', 'A', 'C', 'E', '_', 'H', 'P', '3', 'D', '_', 'D', 'R', 'A', 'W', '_', 'C', 'N', 'T', 'R', '\0', /* SQ_THREAD_TRACE_HP3D_DRAW_CNTR (2694) */
	'S', 'Q', '_', 'T', 'H', 'R', 'E', 'A', 'D', '_', 'T', 'R', 'A', 'C', 'E', '_', 'H', 'P', '3', 'D', '_', 'M', 'A', 'R', 'K', 'E', 'R', '_', 'C', 'N', 'T', 'R', '\0', /* SQ_THREAD_TRACE_HP3D_MARKER_CNTR (2725) */
	'S', 'Q', '_', 'E', 'X', 'P', '_', '0', '\0', /* SQ_EXP_0 (2758) */
	'S', 'Q', '_', 'B', 'U', 'F', '_', 'R', 'S', 'R', 'C', '_', 'W', 'O', 'R', 'D', '0', '\0', /* SQ_BUF_RSRC_WORD0 (2767) */
	'S', 'Q', '_', 'B', 'U', 'F', '_', 'R', 'S', 'R', 'C', '_', 'W', 'O', 'R', 'D', '1', '\0', /* SQ_BUF_RSRC_WORD1 (2785) */
	'S', 'Q', '_', 'B', 'U', 'F', '_', 'R', 'S', 'R', 'C', '_', 'W', 'O', 'R', 'D', '2', '\0', /* SQ_BUF_RSRC_WORD2 (2803) */
	'S', 'Q', '_', 'B', 'U', 'F', '_', 'R', 'S', 'R', 'C', '_', 'W', 'O', 'R', 'D', '3', '\0', /* SQ_BUF_RSRC_WORD3 (2821) */
	'S', 'Q', '_', 'I', 'M', 'G', '_', 'S', 'A', 'M', 'P', '_', 'W', 'O', 'R', 'D', '0', '\0', /* SQ_IMG_SAMP_WORD0 (2839) */
	'S', 'Q', '_', 'I', 'M', 'G', '_', 'S', 'A', 'M', 'P', '_', 'W', 'O', 'R', 'D', '1', '\0', /* SQ_IMG_SAMP_WORD1 (2857) */
	'S', 'Q', '_', 'I', 'M', 'G', '_', 'S', 'A', 'M', 'P', '_', 'W', 'O', 'R', 'D', '2', '\0', /* SQ_IMG_SAMP_WORD2 (2875) */
	'S', 'Q', '_', 'I', 'M', 'G', '_', 'S', 'A', 'M', 'P', '_', 'W', 'O', 'R', 'D', '3', '\0', /* SQ_IMG_SAMP_WORD3 (2893) */
	'S', 'P', 'I', '_', 'C', 'O', 'N', 'F', 'I', 'G', '_', 'C', 'N', 'T', 'L', '\0', /* SPI_CONFIG_CNTL (2911) */
	'G', 'B', '_', 'A', 'D', 'D', 'R', '_', 'C', 'O', 'N', 'F', 'I', 'G', '\0', /* GB_ADDR_CONFIG (2927) */
	'G', 'B', '_', 'T', 'I', 'L', 'E', '_', 'M', 'O', 'D', 'E', '0', '\0', /* GB_TILE_MODE0 (2942) */
	'G', 'B', '_', 'T', 'I', 'L', 'E', '_', 'M', 'O', 'D', 'E', '1', '\0', /* GB_TILE_MODE1 (2956) */
	'G', 'B', '_', 'T', 'I', 'L', 'E', '_', 'M', 'O', 'D', 'E', '2', '\0', /* GB_TILE_MODE2 (2970) */
	'G', 'B', '_', 'T', 'I', 'L', 'E', '_', 'M', 'O', 'D', 'E', '3', '\0', /* GB_TILE_MODE3 (2984) */
	'G', 'B', '_', 'T', 'I', 'L', 'E', '_', 'M', 'O', 'D', 'E', '4', '\0', /* GB_TILE_MODE4 (2998) */
	'G', 'B', '_', 'T', 'I', 'L', 'E', '_', 'M', 'O', 'D', 'E', '5', '\0', /* GB_TILE_MODE5 (3012) */
	'G', 'B', '_', 'T', 'I', 'L', 'E', '_', 'M', 'O', 'D', 'E', '6', '\0', /* GB_TILE_MODE6 (3026) */
	'G', 'B', '_', 'T', 'I', 'L', 'E', '_', 'M', 'O', 'D', 'E', '7', '\0', /* GB_TILE_MODE7 (3040) */
	'G', 'B', '_', 'T', 'I', 'L', 'E', '_', 'M', 'O', 'D', 'E', '8', '\0', /* GB_TILE_MODE8 (3054) */
	'G', 'B', '_', 'T', 'I', 'L', 'E', '_', 'M', 'O', 'D', 'E', '9', '\0', /* GB_TILE_MODE9 (3068) */
	'G', 'B', '_', 'T', 'I', 'L', 'E', '_', 'M', 'O', 'D', 'E', '1', '0', '\0', /* GB_TILE_MODE10 (3082) */
	'G', 'B', '_', 'T', 'I', 'L', 'E', '_', 'M', 'O', 'D', 'E', '1', '1', '\0', /* GB_TILE_MODE11 (3097) */
	'G', 'B', '_', 'T', 'I', 'L', 'E', '_', 'M', 'O', 'D', 'E', '1', '2', '\0', /* GB_TILE_MODE12 (3112) */
	'G', 'B', '_', 'T', 'I', 'L', 'E', '_', 'M', 'O', 'D', 'E', '1', '3', '\0', /* GB_TILE_MODE13 (3127) */
	'G', 'B', '_', 'T', 'I', 'L', 'E', '_', 'M', 'O', 'D', 'E', '1', '4', '\0', /* GB_TILE_MODE14 (3142) */
	'G', 'B', '_', 'T', 'I', 'L', 'E', '_', 'M', 'O', 'D', 'E', '1', '5', '\0', /* GB_TILE_MODE15 (3157) */
	'G', 'B', '_', 'T', 'I', 'L', 'E', '_', 'M', 'O', 'D', 'E', '1', '6', '\0', /* GB_TILE_MODE16 (3172) */
	'G', 'B', '_', 'T', 'I', 'L', 'E', '_', 'M', 'O', 'D', 'E', '1', '7', '\0', /* GB_TILE_MODE17 (3187) */
	'G', 'B', '_', 'T', 'I', 'L', 'E', '_', 'M', 'O', 'D', 'E', '1', '8', '\0', /* GB_TILE_MODE18 (3202) */
	'G', 'B', '_', 'T', 'I', 'L', 'E', '_', 'M', 'O', 'D', 'E', '1', '9', '\0', /* GB_TILE_MODE19 (3217) */
	'G', 'B', '_', 'T', 'I', 'L', 'E', '_', 'M', 'O', 'D', 'E', '2', '0', '\0', /* GB_TILE_MODE20 (3232) */
	'G', 'B', '_', 'T', 'I', 'L', 'E', '_', 'M', 'O', 'D', 'E', '2', '1', '\0', /* GB_TILE_MODE21 (3247) */
	'G', 'B', '_', 'T', 'I', 'L', 'E', '_', 'M', 'O', 'D', 'E', '2', '2', '\0', /* GB_TILE_MODE22 (3262) */
	'G', 'B', '_', 'T', 'I', 'L', 'E', '_', 'M', 'O', 'D', 'E', '2', '3', '\0', /* GB_TILE_MODE23 (3277) */
	'G', 'B', '_', 'T', 'I', 'L', 'E', '_', 'M', 'O', 'D', 'E', '2', '4', '\0', /* GB_TILE_MODE24 (3292) */
	'G', 'B', '_', 'T', 'I', 'L', 'E', '_', 'M', 'O', 'D', 'E', '2', '5', '\0', /* GB_TILE_MODE25 (3307) */
	'G', 'B', '_', 'T', 'I', 'L', 'E', '_', 'M', 'O', 'D', 'E', '2', '6', '\0', /* GB_TILE_MODE26 (3322) */
	'G', 'B', '_', 'T', 'I', 'L', 'E', '_', 'M', 'O', 'D', 'E', '2', '7', '\0', /* GB_TILE_MODE27 (3337) */
	'G', 'B', '_', 'T', 'I', 'L', 'E', '_', 'M', 'O', 'D', 'E', '2', '8', '\0', /* GB_TILE_MODE28 (3352) */
	'G', 'B', '_', 'T', 'I', 'L', 'E', '_', 'M', 'O', 'D', 'E', '2', '9', '\0', /* GB_TILE_MODE29 (3367) */
	'G', 'B', '_', 'T', 'I', 'L', 'E', '_', 'M', 'O', 'D', 'E', '3', '0', '\0', /* GB_TILE_MODE30 (3382) */
	'G', 'B', '_', 'T', 'I', 'L', 'E', '_', 'M', 'O', 'D', 'E', '3', '1', '\0', /* GB_TILE_MODE31 (3397) */
	'G', 'B', '_', 'M', 'A', 'C', 'R', 'O', 'T', 'I', 'L', 'E', '_', 'M', 'O', 'D', 'E', '0', '\0', /* GB_MACROTILE_MODE0 (3412) */
	'G', 'B', '_', 'M', 'A', 'C', 'R', 'O', 'T', 'I', 'L', 'E', '_', 'M', 'O', 'D', 'E', '1', '\0', /* GB_MACROTILE_MODE1 (3431) */
	'G', 'B', '_', 'M', 'A', 'C', 'R', 'O', 'T', 'I', 'L', 'E', '_', 'M', 'O', 'D', 'E', '2', '\0', /* GB_MACROTILE_MODE2 (3450) */
	'G', 'B', '_', 'M', 'A', 'C', 'R', 'O', 'T', 'I', 'L', 'E', '_', 'M', 'O', 'D', 'E', '3', '\0', /* GB_MACROTILE_MODE3 (3469) */
	'G', 'B', '_', 'M', 'A', 'C', 'R', 'O', 'T', 'I', 'L', 'E', '_', 'M', 'O', 'D', 'E', '4', '\0', /* GB_MACROTILE_MODE4 (3488) */
	'G', 'B', '_', 'M', 'A', 'C', 'R', 'O', 'T', 'I', 'L', 'E', '_', 'M', 'O', 'D', 'E', '5', '\0', /* GB_MACROTILE_MODE5 (3507) */
	'G', 'B', '_', 'M', 'A', 'C', 'R', 'O', 'T', 'I', 'L', 'E', '_', 'M', 'O', 'D', 'E', '6', '\0', /* GB_MACROTILE_MODE6 (3526) */
	'G', 'B', '_', 'M', 'A', 'C', 'R', 'O', 'T', 'I', 'L', 'E', '_', 'M', 'O', 'D', 'E', '7', '\0', /* GB_MACROTILE_MODE7 (3545) */
	'G', 'B', '_', 'M', 'A', 'C', 'R', 'O', 'T', 'I', 'L', 'E', '_', 'M', 'O', 'D', 'E', '8', '\0', /* GB_MACROTILE_MODE8 (3564) */
	'G', 'B', '_', 'M', 'A', 'C', 'R', 'O', 'T', 'I', 'L', 'E', '_', 'M', 'O', 'D', 'E', '9', '\0', /* GB_MACROTILE_MODE9 (3583) */
	'G', 'B', '_', 'M', 'A', 'C', 'R', 'O', 'T', 'I', 'L', 'E', '_', 'M', 'O', 'D', 'E', '1', '0', '\0', /* GB_MACROTILE_MODE10 (3602) */
	'G', 'B', '_', 'M', 'A', 'C', 'R', 'O', 'T', 'I', 'L', 'E', '_', 'M', 'O', 'D', 'E', '1', '1', '\0', /* GB_MACROTILE_MODE11 (3622) */
	'G', 'B', '_', 'M', 'A', 'C', 'R', 'O', 'T', 'I', 'L', 'E', '_', 'M', 'O', 'D', 'E', '1', '2', '\0', /* GB_MACROTILE_MODE12 (3642) */
	'G', 'B', '_', 'M', 'A', 'C', 'R', 'O', 'T', 'I', 'L', 'E', '_', 'M', 'O', 'D', 'E', '1', '3', '\0', /* GB_MACROTILE_MODE13 (3662) */
	'G', 'B', '_', 'M', 'A', 'C', 'R', 'O', 'T', 'I', 'L', 'E', '_', 'M', 'O', 'D', 'E', '1', '4', '\0', /* GB_MACROTILE_MODE14 (3682) */
	'G', 'B', '_', 'M', 'A', 'C', 'R', 'O', 'T', 'I', 'L', 'E', '_', 'M', 'O', 'D', 'E', '1', '5', '\0', /* GB_MACROTILE_MODE15 (3702) */
	'S', 'Q', '_', 'I', 'M', 'G', '_', 'R', 'S', 'R', 'C', '_', 'W', 'O', 'R', 'D', '0', '\0', /* SQ_IMG_RSRC_WORD0 (3722) */
	'S', 'Q', '_', 'I', 'M', 'G', '_', 'R', 'S', 'R', 'C', '_', 'W', 'O', 'R', 'D', '1', '\0', /* SQ_IMG_RSRC_WORD1 (3740) */
	'S', 'Q', '_', 'I', 'M', 'G', '_', 'R', 'S', 'R', 'C', '_', 'W', 'O', 'R', 'D', '2', '\0', /* SQ_IMG_RSRC_WORD2 (3758) */
	'S', 'Q', '_', 'I', 'M', 'G', '_', 'R', 'S', 'R', 'C', '_', 'W', 'O', 'R', 'D', '3', '\0', /* SQ_IMG_RSRC_WORD3 (3776) */
	'S', 'Q', '_', 'I', 'M', 'G', '_', 'R', 'S', 'R', 'C', '_', 'W', 'O', 'R', 'D', '4', '\0', /* SQ_IMG_RSRC_WORD4 (3794) */
	'S', 'Q', '_', 'I', 'M', 'G', '_', 'R', 'S', 'R', 'C', '_', 'W', 'O', 'R', 'D', '5', '\0', /* SQ_IMG_RSRC_WORD5 (3812) */
	'S', 'Q', '_', 'I', 'M', 'G', '_', 'R', 'S', 'R', 'C', '_', 'W', 'O', 'R', 'D', '6', '\0', /* SQ_IMG_RSRC_WORD6 (3830) */
	'S', 'Q', '_', 'I', 'M', 'G', '_', 'R', 'S', 'R', 'C', '_', 'W', 'O', 'R', 'D', '7', '\0', /* SQ_IMG_RSRC_WORD7 (3848) */
	'G', 'C', 'V', 'M', '_', 'L', '2', '_', 'P', 'R', 'O', 'T', 'E', 'C', 'T', 'I', 'O', 'N', '_', 'F', 'A', 'U', 'L', 'T', '_', 'S', 'T', 'A', 'T', 'U', 'S', '\0', /* GCVM_L2_PROTECTION_FAULT_STATUS (3866) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'P', 'G', 'M', '_', 'R', 'S', 'R', 'C', '4', '_', 'P', 'S', '\0', /* SPI_SHADER_PGM_RSRC4_PS (3898) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'P', 'G', 'M', '_', 'C', 'H', 'K', 'S', 'U', 'M', '_', 'P', 'S', '\0', /* SPI_SHADER_PGM_CHKSUM_PS (3922) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'P', 'G', 'M', '_', 'R', 'S', 'R', 'C', '3', '_', 'P', 'S', '\0', /* SPI_SHADER_PGM_RSRC3_PS (3947) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'P', 'G', 'M', '_', 'L', 'O', '_', 'P', 'S', '\0', /* SPI_SHADER_PGM_LO_PS (3971) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'P', 'G', 'M', '_', 'H', 'I', '_', 'P', 'S', '\0', /* SPI_SHADER_PGM_HI_PS (3992) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'P', 'G', 'M', '_', 'R', 'S', 'R', 'C', '1', '_', 'P', 'S', '\0', /* SPI_SHADER_PGM_RSRC1_PS (4013) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'P', 'G', 'M', '_', 'R', 'S', 'R', 'C', '2', '_', 'P', 'S', '\0', /* SPI_SHADER_PGM_RSRC2_PS (4037) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'P', 'S', '_', '0', '\0', /* SPI_SHADER_USER_DATA_PS_0 (4061) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'P', 'S', '_', '1', '\0', /* SPI_SHADER_USER_DATA_PS_1 (4087) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'P', 'S', '_', '2', '\0', /* SPI_SHADER_USER_DATA_PS_2 (4113) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'P', 'S', '_', '3', '\0', /* SPI_SHADER_USER_DATA_PS_3 (4139) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'P', 'S', '_', '4', '\0', /* SPI_SHADER_USER_DATA_PS_4 (4165) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'P', 'S', '_', '5', '\0', /* SPI_SHADER_USER_DATA_PS_5 (4191) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'P', 'S', '_', '6', '\0', /* SPI_SHADER_USER_DATA_PS_6 (4217) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'P', 'S', '_', '7', '\0', /* SPI_SHADER_USER_DATA_PS_7 (4243) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'P', 'S', '_', '8', '\0', /* SPI_SHADER_USER_DATA_PS_8 (4269) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'P', 'S', '_', '9', '\0', /* SPI_SHADER_USER_DATA_PS_9 (4295) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'P', 'S', '_', '1', '0', '\0', /* SPI_SHADER_USER_DATA_PS_10 (4321) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'P', 'S', '_', '1', '1', '\0', /* SPI_SHADER_USER_DATA_PS_11 (4348) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'P', 'S', '_', '1', '2', '\0', /* SPI_SHADER_USER_DATA_PS_12 (4375) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'P', 'S', '_', '1', '3', '\0', /* SPI_SHADER_USER_DATA_PS_13 (4402) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'P', 'S', '_', '1', '4', '\0', /* SPI_SHADER_USER_DATA_PS_14 (4429) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'P', 'S', '_', '1', '5', '\0', /* SPI_SHADER_USER_DATA_PS_15 (4456) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'P', 'S', '_', '1', '6', '\0', /* SPI_SHADER_USER_DATA_PS_16 (4483) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'P', 'S', '_', '1', '7', '\0', /* SPI_SHADER_USER_DATA_PS_17 (4510) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'P', 'S', '_', '1', '8', '\0', /* SPI_SHADER_USER_DATA_PS_18 (4537) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'P', 'S', '_', '1', '9', '\0', /* SPI_SHADER_USER_DATA_PS_19 (4564) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'P', 'S', '_', '2', '0', '\0', /* SPI_SHADER_USER_DATA_PS_20 (4591) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'P', 'S', '_', '2', '1', '\0', /* SPI_SHADER_USER_DATA_PS_21 (4618) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'P', 'S', '_', '2', '2', '\0', /* SPI_SHADER_USER_DATA_PS_22 (4645) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'P', 'S', '_', '2', '3', '\0', /* SPI_SHADER_USER_DATA_PS_23 (4672) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'P', 'S', '_', '2', '4', '\0', /* SPI_SHADER_USER_DATA_PS_24 (4699) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'P', 'S', '_', '2', '5', '\0', /* SPI_SHADER_USER_DATA_PS_25 (4726) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'P', 'S', '_', '2', '6', '\0', /* SPI_SHADER_USER_DATA_PS_26 (4753) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'P', 'S', '_', '2', '7', '\0', /* SPI_SHADER_USER_DATA_PS_27 (4780) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'P', 'S', '_', '2', '8', '\0', /* SPI_SHADER_USER_DATA_PS_28 (4807) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'P', 'S', '_', '2', '9', '\0', /* SPI_SHADER_USER_DATA_PS_29 (4834) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'P', 'S', '_', '3', '0', '\0', /* SPI_SHADER_USER_DATA_PS_30 (4861) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'P', 'S', '_', '3', '1', '\0', /* SPI_SHADER_USER_DATA_PS_31 (4888) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'R', 'E', 'Q', '_', 'C', 'T', 'R', 'L', '_', 'P', 'S', '\0', /* SPI_SHADER_REQ_CTRL_PS (4915) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'P', 'R', 'E', 'F', '_', 'P', 'R', 'I', '_', 'C', 'N', 'T', 'R', '_', 'C', 'T', 'R', 'L', '_', 'P', 'S', '\0', /* SPI_SHADER_PREF_PRI_CNTR_CTRL_PS (4938) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'A', 'C', 'C', 'U', 'M', '_', 'P', 'S', '_', '0', '\0', /* SPI_SHADER_USER_ACCUM_PS_0 (4971) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'A', 'C', 'C', 'U', 'M', '_', 'P', 'S', '_', '1', '\0', /* SPI_SHADER_USER_ACCUM_PS_1 (4998) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'A', 'C', 'C', 'U', 'M', '_', 'P', 'S', '_', '2', '\0', /* SPI_SHADER_USER_ACCUM_PS_2 (5025) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'A', 'C', 'C', 'U', 'M', '_', 'P', 'S', '_', '3', '\0', /* SPI_SHADER_USER_ACCUM_PS_3 (5052) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'P', 'G', 'M', '_', 'R', 'S', 'R', 'C', '4', '_', 'V', 'S', '\0', /* SPI_SHADER_PGM_RSRC4_VS (5079) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'P', 'G', 'M', '_', 'C', 'H', 'K', 'S', 'U', 'M', '_', 'V', 'S', '\0', /* SPI_SHADER_PGM_CHKSUM_VS (5103) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'P', 'G', 'M', '_', 'R', 'S', 'R', 'C', '3', '_', 'V', 'S', '\0', /* SPI_SHADER_PGM_RSRC3_VS (5128) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'L', 'A', 'T', 'E', '_', 'A', 'L', 'L', 'O', 'C', '_', 'V', 'S', '\0', /* SPI_SHADER_LATE_ALLOC_VS (5152) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'P', 'G', 'M', '_', 'L', 'O', '_', 'V', 'S', '\0', /* SPI_SHADER_PGM_LO_VS (5177) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'P', 'G', 'M', '_', 'H', 'I', '_', 'V', 'S', '\0', /* SPI_SHADER_PGM_HI_VS (5198) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'P', 'G', 'M', '_', 'R', 'S', 'R', 'C', '1', '_', 'V', 'S', '\0', /* SPI_SHADER_PGM_RSRC1_VS (5219) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'P', 'G', 'M', '_', 'R', 'S', 'R', 'C', '2', '_', 'V', 'S', '\0', /* SPI_SHADER_PGM_RSRC2_VS (5243) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'V', 'S', '_', '0', '\0', /* SPI_SHADER_USER_DATA_VS_0 (5267) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'V', 'S', '_', '1', '\0', /* SPI_SHADER_USER_DATA_VS_1 (5293) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'V', 'S', '_', '2', '\0', /* SPI_SHADER_USER_DATA_VS_2 (5319) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'V', 'S', '_', '3', '\0', /* SPI_SHADER_USER_DATA_VS_3 (5345) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'V', 'S', '_', '4', '\0', /* SPI_SHADER_USER_DATA_VS_4 (5371) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'V', 'S', '_', '5', '\0', /* SPI_SHADER_USER_DATA_VS_5 (5397) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'V', 'S', '_', '6', '\0', /* SPI_SHADER_USER_DATA_VS_6 (5423) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'V', 'S', '_', '7', '\0', /* SPI_SHADER_USER_DATA_VS_7 (5449) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'V', 'S', '_', '8', '\0', /* SPI_SHADER_USER_DATA_VS_8 (5475) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'V', 'S', '_', '9', '\0', /* SPI_SHADER_USER_DATA_VS_9 (5501) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'V', 'S', '_', '1', '0', '\0', /* SPI_SHADER_USER_DATA_VS_10 (5527) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'V', 'S', '_', '1', '1', '\0', /* SPI_SHADER_USER_DATA_VS_11 (5554) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'V', 'S', '_', '1', '2', '\0', /* SPI_SHADER_USER_DATA_VS_12 (5581) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'V', 'S', '_', '1', '3', '\0', /* SPI_SHADER_USER_DATA_VS_13 (5608) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'V', 'S', '_', '1', '4', '\0', /* SPI_SHADER_USER_DATA_VS_14 (5635) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'V', 'S', '_', '1', '5', '\0', /* SPI_SHADER_USER_DATA_VS_15 (5662) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'V', 'S', '_', '1', '6', '\0', /* SPI_SHADER_USER_DATA_VS_16 (5689) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'V', 'S', '_', '1', '7', '\0', /* SPI_SHADER_USER_DATA_VS_17 (5716) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'V', 'S', '_', '1', '8', '\0', /* SPI_SHADER_USER_DATA_VS_18 (5743) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'V', 'S', '_', '1', '9', '\0', /* SPI_SHADER_USER_DATA_VS_19 (5770) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'V', 'S', '_', '2', '0', '\0', /* SPI_SHADER_USER_DATA_VS_20 (5797) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'V', 'S', '_', '2', '1', '\0', /* SPI_SHADER_USER_DATA_VS_21 (5824) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'V', 'S', '_', '2', '2', '\0', /* SPI_SHADER_USER_DATA_VS_22 (5851) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'V', 'S', '_', '2', '3', '\0', /* SPI_SHADER_USER_DATA_VS_23 (5878) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'V', 'S', '_', '2', '4', '\0', /* SPI_SHADER_USER_DATA_VS_24 (5905) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'V', 'S', '_', '2', '5', '\0', /* SPI_SHADER_USER_DATA_VS_25 (5932) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'V', 'S', '_', '2', '6', '\0', /* SPI_SHADER_USER_DATA_VS_26 (5959) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'V', 'S', '_', '2', '7', '\0', /* SPI_SHADER_USER_DATA_VS_27 (5986) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'V', 'S', '_', '2', '8', '\0', /* SPI_SHADER_USER_DATA_VS_28 (6013) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'V', 'S', '_', '2', '9', '\0', /* SPI_SHADER_USER_DATA_VS_29 (6040) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'V', 'S', '_', '3', '0', '\0', /* SPI_SHADER_USER_DATA_VS_30 (6067) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'V', 'S', '_', '3', '1', '\0', /* SPI_SHADER_USER_DATA_VS_31 (6094) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'R', 'E', 'Q', '_', 'C', 'T', 'R', 'L', '_', 'V', 'S', '\0', /* SPI_SHADER_REQ_CTRL_VS (6121) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'P', 'R', 'E', 'F', '_', 'P', 'R', 'I', '_', 'C', 'N', 'T', 'R', '_', 'C', 'T', 'R', 'L', '_', 'V', 'S', '\0', /* SPI_SHADER_PREF_PRI_CNTR_CTRL_VS (6144) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'A', 'C', 'C', 'U', 'M', '_', 'V', 'S', '_', '0', '\0', /* SPI_SHADER_USER_ACCUM_VS_0 (6177) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'A', 'C', 'C', 'U', 'M', '_', 'V', 'S', '_', '1', '\0', /* SPI_SHADER_USER_ACCUM_VS_1 (6204) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'A', 'C', 'C', 'U', 'M', '_', 'V', 'S', '_', '2', '\0', /* SPI_SHADER_USER_ACCUM_VS_2 (6231) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'A', 'C', 'C', 'U', 'M', '_', 'V', 'S', '_', '3', '\0', /* SPI_SHADER_USER_ACCUM_VS_3 (6258) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'P', 'G', 'M', '_', 'R', 'S', 'R', 'C', '2', '_', 'G', 'S', '_', 'V', 'S', '\0', /* SPI_SHADER_PGM_RSRC2_GS_VS (6285) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'P', 'G', 'M', '_', 'R', 'S', 'R', 'C', '2', '_', 'E', 'S', '_', 'V', 'S', '\0', /* SPI_SHADER_PGM_RSRC2_ES_VS (6312) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'P', 'G', 'M', '_', 'R', 'S', 'R', 'C', '2', '_', 'L', 'S', '_', 'V', 'S', '\0', /* SPI_SHADER_PGM_RSRC2_LS_VS (6339) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'P', 'G', 'M', '_', 'C', 'H', 'K', 'S', 'U', 'M', '_', 'G', 'S', '\0', /* SPI_SHADER_PGM_CHKSUM_GS (6366) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'P', 'G', 'M', '_', 'R', 'S', 'R', 'C', '4', '_', 'G', 'S', '\0', /* SPI_SHADER_PGM_RSRC4_GS (6391) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'A', 'D', 'D', 'R', '_', 'L', 'O', '_', 'G', 'S', '\0', /* SPI_SHADER_USER_DATA_ADDR_LO_GS (6415) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'A', 'D', 'D', 'R', '_', 'H', 'I', '_', 'G', 'S', '\0', /* SPI_SHADER_USER_DATA_ADDR_HI_GS (6447) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'P', 'G', 'M', '_', 'L', 'O', '_', 'E', 'S', '_', 'G', 'S', '\0', /* SPI_SHADER_PGM_LO_ES_GS (6479) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'P', 'G', 'M', '_', 'H', 'I', '_', 'E', 'S', '_', 'G', 'S', '\0', /* SPI_SHADER_PGM_HI_ES_GS (6503) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'P', 'G', 'M', '_', 'R', 'S', 'R', 'C', '3', '_', 'G', 'S', '\0', /* SPI_SHADER_PGM_RSRC3_GS (6527) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'P', 'G', 'M', '_', 'L', 'O', '_', 'G', 'S', '\0', /* SPI_SHADER_PGM_LO_GS (6551) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'P', 'G', 'M', '_', 'H', 'I', '_', 'G', 'S', '\0', /* SPI_SHADER_PGM_HI_GS (6572) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'P', 'G', 'M', '_', 'R', 'S', 'R', 'C', '1', '_', 'G', 'S', '\0', /* SPI_SHADER_PGM_RSRC1_GS (6593) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'P', 'G', 'M', '_', 'R', 'S', 'R', 'C', '2', '_', 'G', 'S', '\0', /* SPI_SHADER_PGM_RSRC2_GS (6617) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'G', 'S', '_', '0', '\0', /* SPI_SHADER_USER_DATA_GS_0 (6641) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'G', 'S', '_', '1', '\0', /* SPI_SHADER_USER_DATA_GS_1 (6667) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'G', 'S', '_', '2', '\0', /* SPI_SHADER_USER_DATA_GS_2 (6693) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'G', 'S', '_', '3', '\0', /* SPI_SHADER_USER_DATA_GS_3 (6719) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'G', 'S', '_', '4', '\0', /* SPI_SHADER_USER_DATA_GS_4 (6745) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'G', 'S', '_', '5', '\0', /* SPI_SHADER_USER_DATA_GS_5 (6771) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'G', 'S', '_', '6', '\0', /* SPI_SHADER_USER_DATA_GS_6 (6797) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'G', 'S', '_', '7', '\0', /* SPI_SHADER_USER_DATA_GS_7 (6823) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'G', 'S', '_', '8', '\0', /* SPI_SHADER_USER_DATA_GS_8 (6849) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'G', 'S', '_', '9', '\0', /* SPI_SHADER_USER_DATA_GS_9 (6875) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'G', 'S', '_', '1', '0', '\0', /* SPI_SHADER_USER_DATA_GS_10 (6901) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'G', 'S', '_', '1', '1', '\0', /* SPI_SHADER_USER_DATA_GS_11 (6928) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'G', 'S', '_', '1', '2', '\0', /* SPI_SHADER_USER_DATA_GS_12 (6955) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'G', 'S', '_', '1', '3', '\0', /* SPI_SHADER_USER_DATA_GS_13 (6982) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'G', 'S', '_', '1', '4', '\0', /* SPI_SHADER_USER_DATA_GS_14 (7009) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'G', 'S', '_', '1', '5', '\0', /* SPI_SHADER_USER_DATA_GS_15 (7036) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'G', 'S', '_', '1', '6', '\0', /* SPI_SHADER_USER_DATA_GS_16 (7063) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'G', 'S', '_', '1', '7', '\0', /* SPI_SHADER_USER_DATA_GS_17 (7090) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'G', 'S', '_', '1', '8', '\0', /* SPI_SHADER_USER_DATA_GS_18 (7117) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'G', 'S', '_', '1', '9', '\0', /* SPI_SHADER_USER_DATA_GS_19 (7144) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'G', 'S', '_', '2', '0', '\0', /* SPI_SHADER_USER_DATA_GS_20 (7171) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'G', 'S', '_', '2', '1', '\0', /* SPI_SHADER_USER_DATA_GS_21 (7198) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'G', 'S', '_', '2', '2', '\0', /* SPI_SHADER_USER_DATA_GS_22 (7225) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'G', 'S', '_', '2', '3', '\0', /* SPI_SHADER_USER_DATA_GS_23 (7252) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'G', 'S', '_', '2', '4', '\0', /* SPI_SHADER_USER_DATA_GS_24 (7279) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'G', 'S', '_', '2', '5', '\0', /* SPI_SHADER_USER_DATA_GS_25 (7306) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'G', 'S', '_', '2', '6', '\0', /* SPI_SHADER_USER_DATA_GS_26 (7333) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'G', 'S', '_', '2', '7', '\0', /* SPI_SHADER_USER_DATA_GS_27 (7360) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'G', 'S', '_', '2', '8', '\0', /* SPI_SHADER_USER_DATA_GS_28 (7387) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'G', 'S', '_', '2', '9', '\0', /* SPI_SHADER_USER_DATA_GS_29 (7414) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'G', 'S', '_', '3', '0', '\0', /* SPI_SHADER_USER_DATA_GS_30 (7441) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'G', 'S', '_', '3', '1', '\0', /* SPI_SHADER_USER_DATA_GS_31 (7468) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'R', 'E', 'Q', '_', 'C', 'T', 'R', 'L', '_', 'E', 'S', 'G', 'S', '\0', /* SPI_SHADER_REQ_CTRL_ESGS (7495) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'P', 'R', 'E', 'F', '_', 'P', 'R', 'I', '_', 'C', 'N', 'T', 'R', '_', 'C', 'T', 'R', 'L', '_', 'E', 'S', 'G', 'S', '\0', /* SPI_SHADER_PREF_PRI_CNTR_CTRL_ESGS (7520) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'A', 'C', 'C', 'U', 'M', '_', 'E', 'S', 'G', 'S', '_', '0', '\0', /* SPI_SHADER_USER_ACCUM_ESGS_0 (7555) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'A', 'C', 'C', 'U', 'M', '_', 'E', 'S', 'G', 'S', '_', '1', '\0', /* SPI_SHADER_USER_ACCUM_ESGS_1 (7584) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'A', 'C', 'C', 'U', 'M', '_', 'E', 'S', 'G', 'S', '_', '2', '\0', /* SPI_SHADER_USER_ACCUM_ESGS_2 (7613) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'A', 'C', 'C', 'U', 'M', '_', 'E', 'S', 'G', 'S', '_', '3', '\0', /* SPI_SHADER_USER_ACCUM_ESGS_3 (7642) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'P', 'G', 'M', '_', 'R', 'S', 'R', 'C', '2', '_', 'E', 'S', '_', 'G', 'S', '\0', /* SPI_SHADER_PGM_RSRC2_ES_GS (7671) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'P', 'G', 'M', '_', 'R', 'S', 'R', 'C', '3', '_', 'E', 'S', '\0', /* SPI_SHADER_PGM_RSRC3_ES (7698) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'P', 'G', 'M', '_', 'L', 'O', '_', 'E', 'S', '\0', /* SPI_SHADER_PGM_LO_ES (7722) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'P', 'G', 'M', '_', 'H', 'I', '_', 'E', 'S', '\0', /* SPI_SHADER_PGM_HI_ES (7743) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'P', 'G', 'M', '_', 'R', 'S', 'R', 'C', '1', '_', 'E', 'S', '\0', /* SPI_SHADER_PGM_RSRC1_ES (7764) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'P', 'G', 'M', '_', 'R', 'S', 'R', 'C', '2', '_', 'E', 'S', '\0', /* SPI_SHADER_PGM_RSRC2_ES (7788) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'E', 'S', '_', '0', '\0', /* SPI_SHADER_USER_DATA_ES_0 (7812) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'E', 'S', '_', '1', '\0', /* SPI_SHADER_USER_DATA_ES_1 (7838) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'E', 'S', '_', '2', '\0', /* SPI_SHADER_USER_DATA_ES_2 (7864) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'E', 'S', '_', '3', '\0', /* SPI_SHADER_USER_DATA_ES_3 (7890) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'E', 'S', '_', '4', '\0', /* SPI_SHADER_USER_DATA_ES_4 (7916) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'E', 'S', '_', '5', '\0', /* SPI_SHADER_USER_DATA_ES_5 (7942) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'E', 'S', '_', '6', '\0', /* SPI_SHADER_USER_DATA_ES_6 (7968) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'E', 'S', '_', '7', '\0', /* SPI_SHADER_USER_DATA_ES_7 (7994) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'E', 'S', '_', '8', '\0', /* SPI_SHADER_USER_DATA_ES_8 (8020) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'E', 'S', '_', '9', '\0', /* SPI_SHADER_USER_DATA_ES_9 (8046) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'E', 'S', '_', '1', '0', '\0', /* SPI_SHADER_USER_DATA_ES_10 (8072) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'E', 'S', '_', '1', '1', '\0', /* SPI_SHADER_USER_DATA_ES_11 (8099) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'E', 'S', '_', '1', '2', '\0', /* SPI_SHADER_USER_DATA_ES_12 (8126) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'E', 'S', '_', '1', '3', '\0', /* SPI_SHADER_USER_DATA_ES_13 (8153) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'E', 'S', '_', '1', '4', '\0', /* SPI_SHADER_USER_DATA_ES_14 (8180) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'E', 'S', '_', '1', '5', '\0', /* SPI_SHADER_USER_DATA_ES_15 (8207) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'P', 'G', 'M', '_', 'R', 'S', 'R', 'C', '2', '_', 'L', 'S', '_', 'E', 'S', '\0', /* SPI_SHADER_PGM_RSRC2_LS_ES (8234) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'P', 'G', 'M', '_', 'C', 'H', 'K', 'S', 'U', 'M', '_', 'H', 'S', '\0', /* SPI_SHADER_PGM_CHKSUM_HS (8261) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'P', 'G', 'M', '_', 'R', 'S', 'R', 'C', '4', '_', 'H', 'S', '\0', /* SPI_SHADER_PGM_RSRC4_HS (8286) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'A', 'D', 'D', 'R', '_', 'L', 'O', '_', 'H', 'S', '\0', /* SPI_SHADER_USER_DATA_ADDR_LO_HS (8310) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'A', 'D', 'D', 'R', '_', 'H', 'I', '_', 'H', 'S', '\0', /* SPI_SHADER_USER_DATA_ADDR_HI_HS (8342) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'P', 'G', 'M', '_', 'L', 'O', '_', 'L', 'S', '_', 'H', 'S', '\0', /* SPI_SHADER_PGM_LO_LS_HS (8374) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'P', 'G', 'M', '_', 'H', 'I', '_', 'L', 'S', '_', 'H', 'S', '\0', /* SPI_SHADER_PGM_HI_LS_HS (8398) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'P', 'G', 'M', '_', 'R', 'S', 'R', 'C', '3', '_', 'H', 'S', '\0', /* SPI_SHADER_PGM_RSRC3_HS (8422) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'P', 'G', 'M', '_', 'L', 'O', '_', 'H', 'S', '\0', /* SPI_SHADER_PGM_LO_HS (8446) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'P', 'G', 'M', '_', 'H', 'I', '_', 'H', 'S', '\0', /* SPI_SHADER_PGM_HI_HS (8467) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'P', 'G', 'M', '_', 'R', 'S', 'R', 'C', '1', '_', 'H', 'S', '\0', /* SPI_SHADER_PGM_RSRC1_HS (8488) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'P', 'G', 'M', '_', 'R', 'S', 'R', 'C', '2', '_', 'H', 'S', '\0', /* SPI_SHADER_PGM_RSRC2_HS (8512) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'H', 'S', '_', '0', '\0', /* SPI_SHADER_USER_DATA_HS_0 (8536) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'H', 'S', '_', '1', '\0', /* SPI_SHADER_USER_DATA_HS_1 (8562) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'H', 'S', '_', '2', '\0', /* SPI_SHADER_USER_DATA_HS_2 (8588) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'H', 'S', '_', '3', '\0', /* SPI_SHADER_USER_DATA_HS_3 (8614) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'H', 'S', '_', '4', '\0', /* SPI_SHADER_USER_DATA_HS_4 (8640) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'H', 'S', '_', '5', '\0', /* SPI_SHADER_USER_DATA_HS_5 (8666) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'H', 'S', '_', '6', '\0', /* SPI_SHADER_USER_DATA_HS_6 (8692) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'H', 'S', '_', '7', '\0', /* SPI_SHADER_USER_DATA_HS_7 (8718) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'H', 'S', '_', '8', '\0', /* SPI_SHADER_USER_DATA_HS_8 (8744) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'H', 'S', '_', '9', '\0', /* SPI_SHADER_USER_DATA_HS_9 (8770) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'H', 'S', '_', '1', '0', '\0', /* SPI_SHADER_USER_DATA_HS_10 (8796) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'H', 'S', '_', '1', '1', '\0', /* SPI_SHADER_USER_DATA_HS_11 (8823) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'H', 'S', '_', '1', '2', '\0', /* SPI_SHADER_USER_DATA_HS_12 (8850) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'H', 'S', '_', '1', '3', '\0', /* SPI_SHADER_USER_DATA_HS_13 (8877) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'H', 'S', '_', '1', '4', '\0', /* SPI_SHADER_USER_DATA_HS_14 (8904) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'H', 'S', '_', '1', '5', '\0', /* SPI_SHADER_USER_DATA_HS_15 (8931) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'H', 'S', '_', '1', '6', '\0', /* SPI_SHADER_USER_DATA_HS_16 (8958) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'H', 'S', '_', '1', '7', '\0', /* SPI_SHADER_USER_DATA_HS_17 (8985) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'H', 'S', '_', '1', '8', '\0', /* SPI_SHADER_USER_DATA_HS_18 (9012) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'H', 'S', '_', '1', '9', '\0', /* SPI_SHADER_USER_DATA_HS_19 (9039) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'H', 'S', '_', '2', '0', '\0', /* SPI_SHADER_USER_DATA_HS_20 (9066) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'H', 'S', '_', '2', '1', '\0', /* SPI_SHADER_USER_DATA_HS_21 (9093) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'H', 'S', '_', '2', '2', '\0', /* SPI_SHADER_USER_DATA_HS_22 (9120) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'H', 'S', '_', '2', '3', '\0', /* SPI_SHADER_USER_DATA_HS_23 (9147) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'H', 'S', '_', '2', '4', '\0', /* SPI_SHADER_USER_DATA_HS_24 (9174) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'H', 'S', '_', '2', '5', '\0', /* SPI_SHADER_USER_DATA_HS_25 (9201) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'H', 'S', '_', '2', '6', '\0', /* SPI_SHADER_USER_DATA_HS_26 (9228) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'H', 'S', '_', '2', '7', '\0', /* SPI_SHADER_USER_DATA_HS_27 (9255) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'H', 'S', '_', '2', '8', '\0', /* SPI_SHADER_USER_DATA_HS_28 (9282) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'H', 'S', '_', '2', '9', '\0', /* SPI_SHADER_USER_DATA_HS_29 (9309) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'H', 'S', '_', '3', '0', '\0', /* SPI_SHADER_USER_DATA_HS_30 (9336) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'H', 'S', '_', '3', '1', '\0', /* SPI_SHADER_USER_DATA_HS_31 (9363) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'R', 'E', 'Q', '_', 'C', 'T', 'R', 'L', '_', 'L', 'S', 'H', 'S', '\0', /* SPI_SHADER_REQ_CTRL_LSHS (9390) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'P', 'R', 'E', 'F', '_', 'P', 'R', 'I', '_', 'C', 'N', 'T', 'R', '_', 'C', 'T', 'R', 'L', '_', 'L', 'S', 'H', 'S', '\0', /* SPI_SHADER_PREF_PRI_CNTR_CTRL_LSHS (9415) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'A', 'C', 'C', 'U', 'M', '_', 'L', 'S', 'H', 'S', '_', '0', '\0', /* SPI_SHADER_USER_ACCUM_LSHS_0 (9450) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'A', 'C', 'C', 'U', 'M', '_', 'L', 'S', 'H', 'S', '_', '1', '\0', /* SPI_SHADER_USER_ACCUM_LSHS_1 (9479) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'A', 'C', 'C', 'U', 'M', '_', 'L', 'S', 'H', 'S', '_', '2', '\0', /* SPI_SHADER_USER_ACCUM_LSHS_2 (9508) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'A', 'C', 'C', 'U', 'M', '_', 'L', 'S', 'H', 'S', '_', '3', '\0', /* SPI_SHADER_USER_ACCUM_LSHS_3 (9537) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'P', 'G', 'M', '_', 'R', 'S', 'R', 'C', '2', '_', 'L', 'S', '_', 'H', 'S', '\0', /* SPI_SHADER_PGM_RSRC2_LS_HS (9566) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'P', 'G', 'M', '_', 'R', 'S', 'R', 'C', '3', '_', 'L', 'S', '\0', /* SPI_SHADER_PGM_RSRC3_LS (9593) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'P', 'G', 'M', '_', 'L', 'O', '_', 'L', 'S', '\0', /* SPI_SHADER_PGM_LO_LS (9617) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'P', 'G', 'M', '_', 'H', 'I', '_', 'L', 'S', '\0', /* SPI_SHADER_PGM_HI_LS (9638) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'P', 'G', 'M', '_', 'R', 'S', 'R', 'C', '1', '_', 'L', 'S', '\0', /* SPI_SHADER_PGM_RSRC1_LS (9659) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'P', 'G', 'M', '_', 'R', 'S', 'R', 'C', '2', '_', 'L', 'S', '\0', /* SPI_SHADER_PGM_RSRC2_LS (9683) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'L', 'S', '_', '0', '\0', /* SPI_SHADER_USER_DATA_LS_0 (9707) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'L', 'S', '_', '1', '\0', /* SPI_SHADER_USER_DATA_LS_1 (9733) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'L', 'S', '_', '2', '\0', /* SPI_SHADER_USER_DATA_LS_2 (9759) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'L', 'S', '_', '3', '\0', /* SPI_SHADER_USER_DATA_LS_3 (9785) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'L', 'S', '_', '4', '\0', /* SPI_SHADER_USER_DATA_LS_4 (9811) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'L', 'S', '_', '5', '\0', /* SPI_SHADER_USER_DATA_LS_5 (9837) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'L', 'S', '_', '6', '\0', /* SPI_SHADER_USER_DATA_LS_6 (9863) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'L', 'S', '_', '7', '\0', /* SPI_SHADER_USER_DATA_LS_7 (9889) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'L', 'S', '_', '8', '\0', /* SPI_SHADER_USER_DATA_LS_8 (9915) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'L', 'S', '_', '9', '\0', /* SPI_SHADER_USER_DATA_LS_9 (9941) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'L', 'S', '_', '1', '0', '\0', /* SPI_SHADER_USER_DATA_LS_10 (9967) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'L', 'S', '_', '1', '1', '\0', /* SPI_SHADER_USER_DATA_LS_11 (9994) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'L', 'S', '_', '1', '2', '\0', /* SPI_SHADER_USER_DATA_LS_12 (10021) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'L', 'S', '_', '1', '3', '\0', /* SPI_SHADER_USER_DATA_LS_13 (10048) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'L', 'S', '_', '1', '4', '\0', /* SPI_SHADER_USER_DATA_LS_14 (10075) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'L', 'S', '_', '1', '5', '\0', /* SPI_SHADER_USER_DATA_LS_15 (10102) */
	'C', 'O', 'M', 'P', 'U', 'T', 'E', '_', 'D', 'I', 'S', 'P', 'A', 'T', 'C', 'H', '_', 'I', 'N', 'I', 'T', 'I', 'A', 'T', 'O', 'R', '\0', /* COMPUTE_DISPATCH_INITIATOR (10129) */
	'C', 'O', 'M', 'P', 'U', 'T', 'E', '_', 'D', 'I', 'M', '_', 'X', '\0', /* COMPUTE_DIM_X (10156) */
	'C', 'O', 'M', 'P', 'U', 'T', 'E', '_', 'D', 'I', 'M', '_', 'Y', '\0', /* COMPUTE_DIM_Y (10170) */
	'C', 'O', 'M', 'P', 'U', 'T', 'E', '_', 'D', 'I', 'M', '_', 'Z', '\0', /* COMPUTE_DIM_Z (10184) */
	'C', 'O', 'M', 'P', 'U', 'T', 'E', '_', 'S', 'T', 'A', 'R', 'T', '_', 'X', '\0', /* COMPUTE_START_X (10198, 10206) */
	'C', 'O', 'M', 'P', 'U', 'T', 'E', '_', 'S', 'T', 'A', 'R', 'T', '_', 'Y', '\0', /* COMPUTE_START_Y (10214, 10222) */
	'C', 'O', 'M', 'P', 'U', 'T', 'E', '_', 'S', 'T', 'A', 'R', 'T', '_', 'Z', '\0', /* COMPUTE_START_Z (10230) */
	'C', 'O', 'M', 'P', 'U', 'T', 'E', '_', 'N', 'U', 'M', '_', 'T', 'H', 'R', 'E', 'A', 'D', '_', 'X', '\0', /* COMPUTE_NUM_THREAD_X (10246) */
	'C', 'O', 'M', 'P', 'U', 'T', 'E', '_', 'N', 'U', 'M', '_', 'T', 'H', 'R', 'E', 'A', 'D', '_', 'Y', '\0', /* COMPUTE_NUM_THREAD_Y (10267) */
	'C', 'O', 'M', 'P', 'U', 'T', 'E', '_', 'N', 'U', 'M', '_', 'T', 'H', 'R', 'E', 'A', 'D', '_', 'Z', '\0', /* COMPUTE_NUM_THREAD_Z (10288) */
	'C', 'O', 'M', 'P', 'U', 'T', 'E', '_', 'P', 'I', 'P', 'E', 'L', 'I', 'N', 'E', 'S', 'T', 'A', 'T', '_', 'E', 'N', 'A', 'B', 'L', 'E', '\0', /* COMPUTE_PIPELINESTAT_ENABLE (10309, 10317, 10330) */
	'C', 'O', 'M', 'P', 'U', 'T', 'E', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', '_', 'E', 'N', 'A', 'B', 'L', 'E', '\0', /* COMPUTE_PERFCOUNT_ENABLE (10337, 10345) */
	'C', 'O', 'M', 'P', 'U', 'T', 'E', '_', 'P', 'G', 'M', '_', 'L', 'O', '\0', /* COMPUTE_PGM_LO (10362) */
	'C', 'O', 'M', 'P', 'U', 'T', 'E', '_', 'P', 'G', 'M', '_', 'H', 'I', '\0', /* COMPUTE_PGM_HI (10377) */
	'C', 'O', 'M', 'P', 'U', 'T', 'E', '_', 'D', 'I', 'S', 'P', 'A', 'T', 'C', 'H', '_', 'P', 'K', 'T', '_', 'A', 'D', 'D', 'R', '_', 'L', 'O', '\0', /* COMPUTE_DISPATCH_PKT_ADDR_LO (10392, 10413) */
	'C', 'O', 'M', 'P', 'U', 'T', 'E', '_', 'D', 'I', 'S', 'P', 'A', 'T', 'C', 'H', '_', 'P', 'K', 'T', '_', 'A', 'D', 'D', 'R', '_', 'H', 'I', '\0', /* COMPUTE_DISPATCH_PKT_ADDR_HI (10421, 10442) */
	'C', 'O', 'M', 'P', 'U', 'T', 'E', '_', 'D', 'I', 'S', 'P', 'A', 'T', 'C', 'H', '_', 'S', 'C', 'R', 'A', 'T', 'C', 'H', '_', 'B', 'A', 'S', 'E', '_', 'L', 'O', '\0', /* COMPUTE_DISPATCH_SCRATCH_BASE_LO (10450) */
	'C', 'O', 'M', 'P', 'U', 'T', 'E', '_', 'D', 'I', 'S', 'P', 'A', 'T', 'C', 'H', '_', 'S', 'C', 'R', 'A', 'T', 'C', 'H', '_', 'B', 'A', 'S', 'E', '_', 'H', 'I', '\0', /* COMPUTE_DISPATCH_SCRATCH_BASE_HI (10483, 10508) */
	'C', 'O', 'M', 'P', 'U', 'T', 'E', '_', 'P', 'G', 'M', '_', 'R', 'S', 'R', 'C', '1', '\0', /* COMPUTE_PGM_RSRC1 (10516, 10529) */
	'C', 'O', 'M', 'P', 'U', 'T', 'E', '_', 'P', 'G', 'M', '_', 'R', 'S', 'R', 'C', '2', '\0', /* COMPUTE_PGM_RSRC2 (10534, 10547) */
	'C', 'O', 'M', 'P', 'U', 'T', 'E', '_', 'V', 'M', 'I', 'D', '\0', /* COMPUTE_VMID (10552, 10560, 10562) */
	'C', 'O', 'M', 'P', 'U', 'T', 'E', '_', 'R', 'E', 'S', 'O', 'U', 'R', 'C', 'E', '_', 'L', 'I', 'M', 'I', 'T', 'S', '\0', /* COMPUTE_RESOURCE_LIMITS (10565) */
	'C', 'O', 'M', 'P', 'U', 'T', 'E', '_', 'D', 'E', 'S', 'T', 'I', 'N', 'A', 'T', 'I', 'O', 'N', '_', 'E', 'N', '_', 'S', 'E', '0', '\0', /* COMPUTE_DESTINATION_EN_SE0 (10589) */
	'C', 'O', 'M', 'P', 'U', 'T', 'E', '_', 'D', 'E', 'S', 'T', 'I', 'N', 'A', 'T', 'I', 'O', 'N', '_', 'E', 'N', '_', 'S', 'E', '1', '\0', /* COMPUTE_DESTINATION_EN_SE1 (10616) */
	'C', 'O', 'M', 'P', 'U', 'T', 'E', '_', 'T', 'M', 'P', 'R', 'I', 'N', 'G', '_', 'S', 'I', 'Z', 'E', '\0', /* COMPUTE_TMPRING_SIZE (10643) */
	'C', 'O', 'M', 'P', 'U', 'T', 'E', '_', 'D', 'E', 'S', 'T', 'I', 'N', 'A', 'T', 'I', 'O', 'N', '_', 'E', 'N', '_', 'S', 'E', '2', '\0', /* COMPUTE_DESTINATION_EN_SE2 (10664) */
	'C', 'O', 'M', 'P', 'U', 'T', 'E', '_', 'D', 'E', 'S', 'T', 'I', 'N', 'A', 'T', 'I', 'O', 'N', '_', 'E', 'N', '_', 'S', 'E', '3', '\0', /* COMPUTE_DESTINATION_EN_SE3 (10691) */
	'C', 'O', 'M', 'P', 'U', 'T', 'E', '_', 'R', 'E', 'S', 'T', 'A', 'R', 'T', '_', 'X', '\0', /* COMPUTE_RESTART_X (10718) */
	'C', 'O', 'M', 'P', 'U', 'T', 'E', '_', 'R', 'E', 'S', 'T', 'A', 'R', 'T', '_', 'Y', '\0', /* COMPUTE_RESTART_Y (10736) */
	'C', 'O', 'M', 'P', 'U', 'T', 'E', '_', 'R', 'E', 'S', 'T', 'A', 'R', 'T', '_', 'Z', '\0', /* COMPUTE_RESTART_Z (10754) */
	'C', 'O', 'M', 'P', 'U', 'T', 'E', '_', 'T', 'H', 'R', 'E', 'A', 'D', '_', 'T', 'R', 'A', 'C', 'E', '_', 'E', 'N', 'A', 'B', 'L', 'E', '\0', /* COMPUTE_THREAD_TRACE_ENABLE (10772, 10780) */
	'C', 'O', 'M', 'P', 'U', 'T', 'E', '_', 'M', 'I', 'S', 'C', '_', 'R', 'E', 'S', 'E', 'R', 'V', 'E', 'D', '\0', /* COMPUTE_MISC_RESERVED (10800, 10813) */
	'C', 'O', 'M', 'P', 'U', 'T', 'E', '_', 'D', 'I', 'S', 'P', 'A', 'T', 'C', 'H', '_', 'I', 'D', '\0', /* COMPUTE_DISPATCH_ID (10822) */
	'C', 'O', 'M', 'P', 'U', 'T', 'E', '_', 'T', 'H', 'R', 'E', 'A', 'D', 'G', 'R', 'O', 'U', 'P', '_', 'I', 'D', '\0', /* COMPUTE_THREADGROUP_ID (10842) */
	'C', 'O', 'M', 'P', 'U', 'T', 'E', '_', 'R', 'E', 'Q', '_', 'C', 'T', 'R', 'L', '\0', /* COMPUTE_REQ_CTRL (10865) */
	'C', 'O', 'M', 'P', 'U', 'T', 'E', '_', 'U', 'S', 'E', 'R', '_', 'A', 'C', 'C', 'U', 'M', '_', '0', '\0', /* COMPUTE_USER_ACCUM_0 (10882) */
	'C', 'O', 'M', 'P', 'U', 'T', 'E', '_', 'U', 'S', 'E', 'R', '_', 'A', 'C', 'C', 'U', 'M', '_', '1', '\0', /* COMPUTE_USER_ACCUM_1 (10903) */
	'C', 'O', 'M', 'P', 'U', 'T', 'E', '_', 'U', 'S', 'E', 'R', '_', 'A', 'C', 'C', 'U', 'M', '_', '2', '\0', /* COMPUTE_USER_ACCUM_2 (10924) */
	'C', 'O', 'M', 'P', 'U', 'T', 'E', '_', 'U', 'S', 'E', 'R', '_', 'A', 'C', 'C', 'U', 'M', '_', '3', '\0', /* COMPUTE_USER_ACCUM_3 (10945) */
	'C', 'O', 'M', 'P', 'U', 'T', 'E', '_', 'P', 'G', 'M', '_', 'R', 'S', 'R', 'C', '3', '\0', /* COMPUTE_PGM_RSRC3 (10966) */
	'C', 'O', 'M', 'P', 'U', 'T', 'E', '_', 'D', 'D', 'I', 'D', '_', 'I', 'N', 'D', 'E', 'X', '\0', /* COMPUTE_DDID_INDEX (10984) */
	'C', 'O', 'M', 'P', 'U', 'T', 'E', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'C', 'H', 'K', 'S', 'U', 'M', '\0', /* COMPUTE_SHADER_CHKSUM (11003) */
	'C', 'O', 'M', 'P', 'U', 'T', 'E', '_', 'R', 'E', 'L', 'A', 'U', 'N', 'C', 'H', '\0', /* COMPUTE_RELAUNCH (11025) */
	'C', 'O', 'M', 'P', 'U', 'T', 'E', '_', 'W', 'A', 'V', 'E', '_', 'R', 'E', 'S', 'T', 'O', 'R', 'E', '_', 'A', 'D', 'D', 'R', '_', 'L', 'O', '\0', /* COMPUTE_WAVE_RESTORE_ADDR_LO (11042) */
	'C', 'O', 'M', 'P', 'U', 'T', 'E', '_', 'W', 'A', 'V', 'E', '_', 'R', 'E', 'S', 'T', 'O', 'R', 'E', '_', 'A', 'D', 'D', 'R', '_', 'H', 'I', '\0', /* COMPUTE_WAVE_RESTORE_ADDR_HI (11071) */
	'C', 'O', 'M', 'P', 'U', 'T', 'E', '_', 'R', 'E', 'L', 'A', 'U', 'N', 'C', 'H', '2', '\0', /* COMPUTE_RELAUNCH2 (11100) */
	'C', 'O', 'M', 'P', 'U', 'T', 'E', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', '0', '\0', /* COMPUTE_USER_DATA_0 (11118) */
	'C', 'O', 'M', 'P', 'U', 'T', 'E', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', '1', '\0', /* COMPUTE_USER_DATA_1 (11138) */
	'C', 'O', 'M', 'P', 'U', 'T', 'E', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', '2', '\0', /* COMPUTE_USER_DATA_2 (11158) */
	'C', 'O', 'M', 'P', 'U', 'T', 'E', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', '3', '\0', /* COMPUTE_USER_DATA_3 (11178) */
	'C', 'O', 'M', 'P', 'U', 'T', 'E', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', '4', '\0', /* COMPUTE_USER_DATA_4 (11198) */
	'C', 'O', 'M', 'P', 'U', 'T', 'E', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', '5', '\0', /* COMPUTE_USER_DATA_5 (11218) */
	'C', 'O', 'M', 'P', 'U', 'T', 'E', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', '6', '\0', /* COMPUTE_USER_DATA_6 (11238) */
	'C', 'O', 'M', 'P', 'U', 'T', 'E', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', '7', '\0', /* COMPUTE_USER_DATA_7 (11258) */
	'C', 'O', 'M', 'P', 'U', 'T', 'E', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', '8', '\0', /* COMPUTE_USER_DATA_8 (11278) */
	'C', 'O', 'M', 'P', 'U', 'T', 'E', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', '9', '\0', /* COMPUTE_USER_DATA_9 (11298) */
	'C', 'O', 'M', 'P', 'U', 'T', 'E', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', '1', '0', '\0', /* COMPUTE_USER_DATA_10 (11318) */
	'C', 'O', 'M', 'P', 'U', 'T', 'E', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', '1', '1', '\0', /* COMPUTE_USER_DATA_11 (11339) */
	'C', 'O', 'M', 'P', 'U', 'T', 'E', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', '1', '2', '\0', /* COMPUTE_USER_DATA_12 (11360) */
	'C', 'O', 'M', 'P', 'U', 'T', 'E', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', '1', '3', '\0', /* COMPUTE_USER_DATA_13 (11381) */
	'C', 'O', 'M', 'P', 'U', 'T', 'E', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', '1', '4', '\0', /* COMPUTE_USER_DATA_14 (11402) */
	'C', 'O', 'M', 'P', 'U', 'T', 'E', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', '1', '5', '\0', /* COMPUTE_USER_DATA_15 (11423) */
	'C', 'O', 'M', 'P', 'U', 'T', 'E', '_', 'D', 'I', 'S', 'P', 'A', 'T', 'C', 'H', '_', 'T', 'U', 'N', 'N', 'E', 'L', '\0', /* COMPUTE_DISPATCH_TUNNEL (11444) */
	'C', 'O', 'M', 'P', 'U', 'T', 'E', '_', 'D', 'I', 'S', 'P', 'A', 'T', 'C', 'H', '_', 'E', 'N', 'D', '\0', /* COMPUTE_DISPATCH_END (11468) */
	'C', 'O', 'M', 'P', 'U', 'T', 'E', '_', 'N', 'O', 'W', 'H', 'E', 'R', 'E', '\0', /* COMPUTE_NOWHERE (11489, 11497) */
	'D', 'B', '_', 'R', 'E', 'N', 'D', 'E', 'R', '_', 'C', 'O', 'N', 'T', 'R', 'O', 'L', '\0', /* DB_RENDER_CONTROL (11505) */
	'D', 'B', '_', 'C', 'O', 'U', 'N', 'T', '_', 'C', 'O', 'N', 'T', 'R', 'O', 'L', '\0', /* DB_COUNT_CONTROL (11523) */
	'D', 'B', '_', 'D', 'E', 'P', 'T', 'H', '_', 'V', 'I', 'E', 'W', '\0', /* DB_DEPTH_VIEW (11540) */
	'D', 'B', '_', 'R', 'E', 'N', 'D', 'E', 'R', '_', 'O', 'V', 'E', 'R', 'R', 'I', 'D', 'E', '\0', /* DB_RENDER_OVERRIDE (11554) */
	'D', 'B', '_', 'R', 'E', 'N', 'D', 'E', 'R', '_', 'O', 'V', 'E', 'R', 'R', 'I', 'D', 'E', '2', '\0', /* DB_RENDER_OVERRIDE2 (11573) */
	'D', 'B', '_', 'H', 'T', 'I', 'L', 'E', '_', 'D', 'A', 'T', 'A', '_', 'B', 'A', 'S', 'E', '\0', /* DB_HTILE_DATA_BASE (11593) */
	'D', 'B', '_', 'D', 'E', 'P', 'T', 'H', '_', 'S', 'I', 'Z', 'E', '_', 'X', 'Y', '\0', /* DB_DEPTH_SIZE_XY (11612) */
	'D', 'B', '_', 'D', 'E', 'P', 'T', 'H', '_', 'B', 'O', 'U', 'N', 'D', 'S', '_', 'M', 'I', 'N', '\0', /* DB_DEPTH_BOUNDS_MIN (11629, 11645) */
	'D', 'B', '_', 'D', 'E', 'P', 'T', 'H', '_', 'B', 'O', 'U', 'N', 'D', 'S', '_', 'M', 'A', 'X', '\0', /* DB_DEPTH_BOUNDS_MAX (11649, 11665) */
	'D', 'B', '_', 'S', 'T', 'E', 'N', 'C', 'I', 'L', '_', 'C', 'L', 'E', 'A', 'R', '\0', /* DB_STENCIL_CLEAR (11669, 11680) */
	'D', 'B', '_', 'D', 'E', 'P', 'T', 'H', '_', 'C', 'L', 'E', 'A', 'R', '\0', /* DB_DEPTH_CLEAR (11686) */
	'P', 'A', '_', 'S', 'C', '_', 'S', 'C', 'R', 'E', 'E', 'N', '_', 'S', 'C', 'I', 'S', 'S', 'O', 'R', '_', 'T', 'L', '\0', /* PA_SC_SCREEN_SCISSOR_TL (11701) */
	'P', 'A', '_', 'S', 'C', '_', 'S', 'C', 'R', 'E', 'E', 'N', '_', 'S', 'C', 'I', 'S', 'S', 'O', 'R', '_', 'B', 'R', '\0', /* PA_SC_SCREEN_SCISSOR_BR (11725) */
	'D', 'B', '_', 'D', 'F', 'S', 'M', '_', 'C', 'O', 'N', 'T', 'R', 'O', 'L', '\0', /* DB_DFSM_CONTROL (11749) */
	'D', 'B', '_', 'R', 'E', 'S', 'E', 'R', 'V', 'E', 'D', '_', 'R', 'E', 'G', '_', '2', '\0', /* DB_RESERVED_REG_2 (11765) */
	'D', 'B', '_', 'Z', '_', 'I', 'N', 'F', 'O', '\0', /* DB_Z_INFO (11783) */
	'D', 'B', '_', 'S', 'T', 'E', 'N', 'C', 'I', 'L', '_', 'I', 'N', 'F', 'O', '\0', /* DB_STENCIL_INFO (11793) */
	'D', 'B', '_', 'Z', '_', 'R', 'E', 'A', 'D', '_', 'B', 'A', 'S', 'E', '\0', /* DB_Z_READ_BASE (11809) */
	'D', 'B', '_', 'S', 'T', 'E', 'N', 'C', 'I', 'L', '_', 'R', 'E', 'A', 'D', '_', 'B', 'A', 'S', 'E', '\0', /* DB_STENCIL_READ_BASE (11824) */
	'D', 'B', '_', 'Z', '_', 'W', 'R', 'I', 'T', 'E', '_', 'B', 'A', 'S', 'E', '\0', /* DB_Z_WRITE_BASE (11845) */
	'D', 'B', '_', 'S', 'T', 'E', 'N', 'C', 'I', 'L', '_', 'W', 'R', 'I', 'T', 'E', '_', 'B', 'A', 'S', 'E', '\0', /* DB_STENCIL_WRITE_BASE (11861) */
	'D', 'B', '_', 'R', 'E', 'S', 'E', 'R', 'V', 'E', 'D', '_', 'R', 'E', 'G', '_', '1', '\0', /* DB_RESERVED_REG_1 (11883) */
	'D', 'B', '_', 'R', 'E', 'S', 'E', 'R', 'V', 'E', 'D', '_', 'R', 'E', 'G', '_', '3', '\0', /* DB_RESERVED_REG_3 (11901) */
	'D', 'B', '_', 'Z', '_', 'R', 'E', 'A', 'D', '_', 'B', 'A', 'S', 'E', '_', 'H', 'I', '\0', /* DB_Z_READ_BASE_HI (11919) */
	'D', 'B', '_', 'S', 'T', 'E', 'N', 'C', 'I', 'L', '_', 'R', 'E', 'A', 'D', '_', 'B', 'A', 'S', 'E', '_', 'H', 'I', '\0', /* DB_STENCIL_READ_BASE_HI (11937) */
	'D', 'B', '_', 'Z', '_', 'W', 'R', 'I', 'T', 'E', '_', 'B', 'A', 'S', 'E', '_', 'H', 'I', '\0', /* DB_Z_WRITE_BASE_HI (11961) */
	'D', 'B', '_', 'S', 'T', 'E', 'N', 'C', 'I', 'L', '_', 'W', 'R', 'I', 'T', 'E', '_', 'B', 'A', 'S', 'E', '_', 'H', 'I', '\0', /* DB_STENCIL_WRITE_BASE_HI (11980) */
	'D', 'B', '_', 'H', 'T', 'I', 'L', 'E', '_', 'D', 'A', 'T', 'A', '_', 'B', 'A', 'S', 'E', '_', 'H', 'I', '\0', /* DB_HTILE_DATA_BASE_HI (12005) */
	'D', 'B', '_', 'R', 'M', 'I', '_', 'L', '2', '_', 'C', 'A', 'C', 'H', 'E', '_', 'C', 'O', 'N', 'T', 'R', 'O', 'L', '\0', /* DB_RMI_L2_CACHE_CONTROL (12027, 12037) */
	'T', 'A', '_', 'B', 'C', '_', 'B', 'A', 'S', 'E', '_', 'A', 'D', 'D', 'R', '\0', /* TA_BC_BASE_ADDR (12051, 12057, 12062) */
	'T', 'A', '_', 'B', 'C', '_', 'B', 'A', 'S', 'E', '_', 'A', 'D', 'D', 'R', '_', 'H', 'I', '\0', /* TA_BC_BASE_ADDR_HI (12067) */
	'C', 'O', 'H', 'E', 'R', '_', 'D', 'E', 'S', 'T', '_', 'B', 'A', 'S', 'E', '_', 'H', 'I', '_', '0', '\0', /* COHER_DEST_BASE_HI_0 (12086) */
	'C', 'O', 'H', 'E', 'R', '_', 'D', 'E', 'S', 'T', '_', 'B', 'A', 'S', 'E', '_', 'H', 'I', '_', '1', '\0', /* COHER_DEST_BASE_HI_1 (12107) */
	'C', 'O', 'H', 'E', 'R', '_', 'D', 'E', 'S', 'T', '_', 'B', 'A', 'S', 'E', '_', 'H', 'I', '_', '2', '\0', /* COHER_DEST_BASE_HI_2 (12128) */
	'C', 'O', 'H', 'E', 'R', '_', 'D', 'E', 'S', 'T', '_', 'B', 'A', 'S', 'E', '_', 'H', 'I', '_', '3', '\0', /* COHER_DEST_BASE_HI_3 (12149) */
	'C', 'O', 'H', 'E', 'R', '_', 'D', 'E', 'S', 'T', '_', 'B', 'A', 'S', 'E', '_', '2', '\0', /* COHER_DEST_BASE_2 (12170) */
	'C', 'O', 'H', 'E', 'R', '_', 'D', 'E', 'S', 'T', '_', 'B', 'A', 'S', 'E', '_', '3', '\0', /* COHER_DEST_BASE_3 (12188) */
	'P', 'A', '_', 'S', 'C', '_', 'W', 'I', 'N', 'D', 'O', 'W', '_', 'O', 'F', 'F', 'S', 'E', 'T', '\0', /* PA_SC_WINDOW_OFFSET (12206, 12217) */
	'P', 'A', '_', 'S', 'C', '_', 'W', 'I', 'N', 'D', 'O', 'W', '_', 'S', 'C', 'I', 'S', 'S', 'O', 'R', '_', 'T', 'L', '\0', /* PA_SC_WINDOW_SCISSOR_TL (12226) */
	'P', 'A', '_', 'S', 'C', '_', 'W', 'I', 'N', 'D', 'O', 'W', '_', 'S', 'C', 'I', 'S', 'S', 'O', 'R', '_', 'B', 'R', '\0', /* PA_SC_WINDOW_SCISSOR_BR (12250) */
	'P', 'A', '_', 'S', 'C', '_', 'C', 'L', 'I', 'P', 'R', 'E', 'C', 'T', '_', 'R', 'U', 'L', 'E', '\0', /* PA_SC_CLIPRECT_RULE (12274) */
	'P', 'A', '_', 'S', 'C', '_', 'C', 'L', 'I', 'P', 'R', 'E', 'C', 'T', '_', '0', '_', 'T', 'L', '\0', /* PA_SC_CLIPRECT_0_TL (12294) */
	'P', 'A', '_', 'S', 'C', '_', 'C', 'L', 'I', 'P', 'R', 'E', 'C', 'T', '_', '0', '_', 'B', 'R', '\0', /* PA_SC_CLIPRECT_0_BR (12314) */
	'P', 'A', '_', 'S', 'C', '_', 'C', 'L', 'I', 'P', 'R', 'E', 'C', 'T', '_', '1', '_', 'T', 'L', '\0', /* PA_SC_CLIPRECT_1_TL (12334) */
	'P', 'A', '_', 'S', 'C', '_', 'C', 'L', 'I', 'P', 'R', 'E', 'C', 'T', '_', '1', '_', 'B', 'R', '\0', /* PA_SC_CLIPRECT_1_BR (12354) */
	'P', 'A', '_', 'S', 'C', '_', 'C', 'L', 'I', 'P', 'R', 'E', 'C', 'T', '_', '2', '_', 'T', 'L', '\0', /* PA_SC_CLIPRECT_2_TL (12374) */
	'P', 'A', '_', 'S', 'C', '_', 'C', 'L', 'I', 'P', 'R', 'E', 'C', 'T', '_', '2', '_', 'B', 'R', '\0', /* PA_SC_CLIPRECT_2_BR (12394) */
	'P', 'A', '_', 'S', 'C', '_', 'C', 'L', 'I', 'P', 'R', 'E', 'C', 'T', '_', '3', '_', 'T', 'L', '\0', /* PA_SC_CLIPRECT_3_TL (12414) */
	'P', 'A', '_', 'S', 'C', '_', 'C', 'L', 'I', 'P', 'R', 'E', 'C', 'T', '_', '3', '_', 'B', 'R', '\0', /* PA_SC_CLIPRECT_3_BR (12434) */
	'P', 'A', '_', 'S', 'C', '_', 'E', 'D', 'G', 'E', 'R', 'U', 'L', 'E', '\0', /* PA_SC_EDGERULE (12454) */
	'P', 'A', '_', 'S', 'U', '_', 'H', 'A', 'R', 'D', 'W', 'A', 'R', 'E', '_', 'S', 'C', 'R', 'E', 'E', 'N', '_', 'O', 'F', 'F', 'S', 'E', 'T', '\0', /* PA_SU_HARDWARE_SCREEN_OFFSET (12469) */
	'C', 'B', '_', 'T', 'A', 'R', 'G', 'E', 'T', '_', 'M', 'A', 'S', 'K', '\0', /* CB_TARGET_MASK (12498) */
	'C', 'B', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'M', 'A', 'S', 'K', '\0', /* CB_SHADER_MASK (12513) */
	'P', 'A', '_', 'S', 'C', '_', 'G', 'E', 'N', 'E', 'R', 'I', 'C', '_', 'S', 'C', 'I', 'S', 'S', 'O', 'R', '_', 'T', 'L', '\0', /* PA_SC_GENERIC_SCISSOR_TL (12528) */
	'P', 'A', '_', 'S', 'C', '_', 'G', 'E', 'N', 'E', 'R', 'I', 'C', '_', 'S', 'C', 'I', 'S', 'S', 'O', 'R', '_', 'B', 'R', '\0', /* PA_SC_GENERIC_SCISSOR_BR (12553) */
	'C', 'O', 'H', 'E', 'R', '_', 'D', 'E', 'S', 'T', '_', 'B', 'A', 'S', 'E', '_', '0', '\0', /* COHER_DEST_BASE_0 (12578) */
	'C', 'O', 'H', 'E', 'R', '_', 'D', 'E', 'S', 'T', '_', 'B', 'A', 'S', 'E', '_', '1', '\0', /* COHER_DEST_BASE_1 (12596) */
	'P', 'A', '_', 'S', 'C', '_', 'V', 'P', 'O', 'R', 'T', '_', 'S', 'C', 'I', 'S', 'S', 'O', 'R', '_', '0', '_', 'T', 'L', '\0', /* PA_SC_VPORT_SCISSOR_0_TL (12614) */
	'P', 'A', '_', 'S', 'C', '_', 'V', 'P', 'O', 'R', 'T', '_', 'S', 'C', 'I', 'S', 'S', 'O', 'R', '_', '0', '_', 'B', 'R', '\0', /* PA_SC_VPORT_SCISSOR_0_BR (12639) */
	'P', 'A', '_', 'S', 'C', '_', 'V', 'P', 'O', 'R', 'T', '_', 'S', 'C', 'I', 'S', 'S', 'O', 'R', '_', '1', '_', 'T', 'L', '\0', /* PA_SC_VPORT_SCISSOR_1_TL (12664) */
	'P', 'A', '_', 'S', 'C', '_', 'V', 'P', 'O', 'R', 'T', '_', 'S', 'C', 'I', 'S', 'S', 'O', 'R', '_', '1', '_', 'B', 'R', '\0', /* PA_SC_VPORT_SCISSOR_1_BR (12689) */
	'P', 'A', '_', 'S', 'C', '_', 'V', 'P', 'O', 'R', 'T', '_', 'S', 'C', 'I', 'S', 'S', 'O', 'R', '_', '2', '_', 'T', 'L', '\0', /* PA_SC_VPORT_SCISSOR_2_TL (12714) */
	'P', 'A', '_', 'S', 'C', '_', 'V', 'P', 'O', 'R', 'T', '_', 'S', 'C', 'I', 'S', 'S', 'O', 'R', '_', '2', '_', 'B', 'R', '\0', /* PA_SC_VPORT_SCISSOR_2_BR (12739) */
	'P', 'A', '_', 'S', 'C', '_', 'V', 'P', 'O', 'R', 'T', '_', 'S', 'C', 'I', 'S', 'S', 'O', 'R', '_', '3', '_', 'T', 'L', '\0', /* PA_SC_VPORT_SCISSOR_3_TL (12764) */
	'P', 'A', '_', 'S', 'C', '_', 'V', 'P', 'O', 'R', 'T', '_', 'S', 'C', 'I', 'S', 'S', 'O', 'R', '_', '3', '_', 'B', 'R', '\0', /* PA_SC_VPORT_SCISSOR_3_BR (12789) */
	'P', 'A', '_', 'S', 'C', '_', 'V', 'P', 'O', 'R', 'T', '_', 'S', 'C', 'I', 'S', 'S', 'O', 'R', '_', '4', '_', 'T', 'L', '\0', /* PA_SC_VPORT_SCISSOR_4_TL (12814) */
	'P', 'A', '_', 'S', 'C', '_', 'V', 'P', 'O', 'R', 'T', '_', 'S', 'C', 'I', 'S', 'S', 'O', 'R', '_', '4', '_', 'B', 'R', '\0', /* PA_SC_VPORT_SCISSOR_4_BR (12839) */
	'P', 'A', '_', 'S', 'C', '_', 'V', 'P', 'O', 'R', 'T', '_', 'S', 'C', 'I', 'S', 'S', 'O', 'R', '_', '5', '_', 'T', 'L', '\0', /* PA_SC_VPORT_SCISSOR_5_TL (12864) */
	'P', 'A', '_', 'S', 'C', '_', 'V', 'P', 'O', 'R', 'T', '_', 'S', 'C', 'I', 'S', 'S', 'O', 'R', '_', '5', '_', 'B', 'R', '\0', /* PA_SC_VPORT_SCISSOR_5_BR (12889) */
	'P', 'A', '_', 'S', 'C', '_', 'V', 'P', 'O', 'R', 'T', '_', 'S', 'C', 'I', 'S', 'S', 'O', 'R', '_', '6', '_', 'T', 'L', '\0', /* PA_SC_VPORT_SCISSOR_6_TL (12914) */
	'P', 'A', '_', 'S', 'C', '_', 'V', 'P', 'O', 'R', 'T', '_', 'S', 'C', 'I', 'S', 'S', 'O', 'R', '_', '6', '_', 'B', 'R', '\0', /* PA_SC_VPORT_SCISSOR_6_BR (12939) */
	'P', 'A', '_', 'S', 'C', '_', 'V', 'P', 'O', 'R', 'T', '_', 'S', 'C', 'I', 'S', 'S', 'O', 'R', '_', '7', '_', 'T', 'L', '\0', /* PA_SC_VPORT_SCISSOR_7_TL (12964) */
	'P', 'A', '_', 'S', 'C', '_', 'V', 'P', 'O', 'R', 'T', '_', 'S', 'C', 'I', 'S', 'S', 'O', 'R', '_', '7', '_', 'B', 'R', '\0', /* PA_SC_VPORT_SCISSOR_7_BR (12989) */
	'P', 'A', '_', 'S', 'C', '_', 'V', 'P', 'O', 'R', 'T', '_', 'S', 'C', 'I', 'S', 'S', 'O', 'R', '_', '8', '_', 'T', 'L', '\0', /* PA_SC_VPORT_SCISSOR_8_TL (13014) */
	'P', 'A', '_', 'S', 'C', '_', 'V', 'P', 'O', 'R', 'T', '_', 'S', 'C', 'I', 'S', 'S', 'O', 'R', '_', '8', '_', 'B', 'R', '\0', /* PA_SC_VPORT_SCISSOR_8_BR (13039) */
	'P', 'A', '_', 'S', 'C', '_', 'V', 'P', 'O', 'R', 'T', '_', 'S', 'C', 'I', 'S', 'S', 'O', 'R', '_', '9', '_', 'T', 'L', '\0', /* PA_SC_VPORT_SCISSOR_9_TL (13064) */
	'P', 'A', '_', 'S', 'C', '_', 'V', 'P', 'O', 'R', 'T', '_', 'S', 'C', 'I', 'S', 'S', 'O', 'R', '_', '9', '_', 'B', 'R', '\0', /* PA_SC_VPORT_SCISSOR_9_BR (13089) */
	'P', 'A', '_', 'S', 'C', '_', 'V', 'P', 'O', 'R', 'T', '_', 'S', 'C', 'I', 'S', 'S', 'O', 'R', '_', '1', '0', '_', 'T', 'L', '\0', /* PA_SC_VPORT_SCISSOR_10_TL (13114) */
	'P', 'A', '_', 'S', 'C', '_', 'V', 'P', 'O', 'R', 'T', '_', 'S', 'C', 'I', 'S', 'S', 'O', 'R', '_', '1', '0', '_', 'B', 'R', '\0', /* PA_SC_VPORT_SCISSOR_10_BR (13140) */
	'P', 'A', '_', 'S', 'C', '_', 'V', 'P', 'O', 'R', 'T', '_', 'S', 'C', 'I', 'S', 'S', 'O', 'R', '_', '1', '1', '_', 'T', 'L', '\0', /* PA_SC_VPORT_SCISSOR_11_TL (13166) */
	'P', 'A', '_', 'S', 'C', '_', 'V', 'P', 'O', 'R', 'T', '_', 'S', 'C', 'I', 'S', 'S', 'O', 'R', '_', '1', '1', '_', 'B', 'R', '\0', /* PA_SC_VPORT_SCISSOR_11_BR (13192) */
	'P', 'A', '_', 'S', 'C', '_', 'V', 'P', 'O', 'R', 'T', '_', 'S', 'C', 'I', 'S', 'S', 'O', 'R', '_', '1', '2', '_', 'T', 'L', '\0', /* PA_SC_VPORT_SCISSOR_12_TL (13218) */
	'P', 'A', '_', 'S', 'C', '_', 'V', 'P', 'O', 'R', 'T', '_', 'S', 'C', 'I', 'S', 'S', 'O', 'R', '_', '1', '2', '_', 'B', 'R', '\0', /* PA_SC_VPORT_SCISSOR_12_BR (13244) */
	'P', 'A', '_', 'S', 'C', '_', 'V', 'P', 'O', 'R', 'T', '_', 'S', 'C', 'I', 'S', 'S', 'O', 'R', '_', '1', '3', '_', 'T', 'L', '\0', /* PA_SC_VPORT_SCISSOR_13_TL (13270) */
	'P', 'A', '_', 'S', 'C', '_', 'V', 'P', 'O', 'R', 'T', '_', 'S', 'C', 'I', 'S', 'S', 'O', 'R', '_', '1', '3', '_', 'B', 'R', '\0', /* PA_SC_VPORT_SCISSOR_13_BR (13296) */
	'P', 'A', '_', 'S', 'C', '_', 'V', 'P', 'O', 'R', 'T', '_', 'S', 'C', 'I', 'S', 'S', 'O', 'R', '_', '1', '4', '_', 'T', 'L', '\0', /* PA_SC_VPORT_SCISSOR_14_TL (13322) */
	'P', 'A', '_', 'S', 'C', '_', 'V', 'P', 'O', 'R', 'T', '_', 'S', 'C', 'I', 'S', 'S', 'O', 'R', '_', '1', '4', '_', 'B', 'R', '\0', /* PA_SC_VPORT_SCISSOR_14_BR (13348) */
	'P', 'A', '_', 'S', 'C', '_', 'V', 'P', 'O', 'R', 'T', '_', 'S', 'C', 'I', 'S', 'S', 'O', 'R', '_', '1', '5', '_', 'T', 'L', '\0', /* PA_SC_VPORT_SCISSOR_15_TL (13374) */
	'P', 'A', '_', 'S', 'C', '_', 'V', 'P', 'O', 'R', 'T', '_', 'S', 'C', 'I', 'S', 'S', 'O', 'R', '_', '1', '5', '_', 'B', 'R', '\0', /* PA_SC_VPORT_SCISSOR_15_BR (13400) */
	'P', 'A', '_', 'S', 'C', '_', 'V', 'P', 'O', 'R', 'T', '_', 'Z', 'M', 'I', 'N', '_', '0', '\0', /* PA_SC_VPORT_ZMIN_0 (13426, 13440) */
	'P', 'A', '_', 'S', 'C', '_', 'V', 'P', 'O', 'R', 'T', '_', 'Z', 'M', 'A', 'X', '_', '0', '\0', /* PA_SC_VPORT_ZMAX_0 (13445) */
	'P', 'A', '_', 'S', 'C', '_', 'V', 'P', 'O', 'R', 'T', '_', 'Z', 'M', 'I', 'N', '_', '1', '\0', /* PA_SC_VPORT_ZMIN_1 (13464, 13478) */
	'P', 'A', '_', 'S', 'C', '_', 'V', 'P', 'O', 'R', 'T', '_', 'Z', 'M', 'A', 'X', '_', '1', '\0', /* PA_SC_VPORT_ZMAX_1 (13483) */
	'P', 'A', '_', 'S', 'C', '_', 'V', 'P', 'O', 'R', 'T', '_', 'Z', 'M', 'I', 'N', '_', '2', '\0', /* PA_SC_VPORT_ZMIN_2 (13502, 13516) */
	'P', 'A', '_', 'S', 'C', '_', 'V', 'P', 'O', 'R', 'T', '_', 'Z', 'M', 'A', 'X', '_', '2', '\0', /* PA_SC_VPORT_ZMAX_2 (13521) */
	'P', 'A', '_', 'S', 'C', '_', 'V', 'P', 'O', 'R', 'T', '_', 'Z', 'M', 'I', 'N', '_', '3', '\0', /* PA_SC_VPORT_ZMIN_3 (13540, 13554) */
	'P', 'A', '_', 'S', 'C', '_', 'V', 'P', 'O', 'R', 'T', '_', 'Z', 'M', 'A', 'X', '_', '3', '\0', /* PA_SC_VPORT_ZMAX_3 (13559) */
	'P', 'A', '_', 'S', 'C', '_', 'V', 'P', 'O', 'R', 'T', '_', 'Z', 'M', 'I', 'N', '_', '4', '\0', /* PA_SC_VPORT_ZMIN_4 (13578) */
	'P', 'A', '_', 'S', 'C', '_', 'V', 'P', 'O', 'R', 'T', '_', 'Z', 'M', 'A', 'X', '_', '4', '\0', /* PA_SC_VPORT_ZMAX_4 (13597) */
	'P', 'A', '_', 'S', 'C', '_', 'V', 'P', 'O', 'R', 'T', '_', 'Z', 'M', 'I', 'N', '_', '5', '\0', /* PA_SC_VPORT_ZMIN_5 (13616) */
	'P', 'A', '_', 'S', 'C', '_', 'V', 'P', 'O', 'R', 'T', '_', 'Z', 'M', 'A', 'X', '_', '5', '\0', /* PA_SC_VPORT_ZMAX_5 (13635) */
	'P', 'A', '_', 'S', 'C', '_', 'V', 'P', 'O', 'R', 'T', '_', 'Z', 'M', 'I', 'N', '_', '6', '\0', /* PA_SC_VPORT_ZMIN_6 (13654) */
	'P', 'A', '_', 'S', 'C', '_', 'V', 'P', 'O', 'R', 'T', '_', 'Z', 'M', 'A', 'X', '_', '6', '\0', /* PA_SC_VPORT_ZMAX_6 (13673) */
	'P', 'A', '_', 'S', 'C', '_', 'V', 'P', 'O', 'R', 'T', '_', 'Z', 'M', 'I', 'N', '_', '7', '\0', /* PA_SC_VPORT_ZMIN_7 (13692) */
	'P', 'A', '_', 'S', 'C', '_', 'V', 'P', 'O', 'R', 'T', '_', 'Z', 'M', 'A', 'X', '_', '7', '\0', /* PA_SC_VPORT_ZMAX_7 (13711) */
	'P', 'A', '_', 'S', 'C', '_', 'V', 'P', 'O', 'R', 'T', '_', 'Z', 'M', 'I', 'N', '_', '8', '\0', /* PA_SC_VPORT_ZMIN_8 (13730) */
	'P', 'A', '_', 'S', 'C', '_', 'V', 'P', 'O', 'R', 'T', '_', 'Z', 'M', 'A', 'X', '_', '8', '\0', /* PA_SC_VPORT_ZMAX_8 (13749) */
	'P', 'A', '_', 'S', 'C', '_', 'V', 'P', 'O', 'R', 'T', '_', 'Z', 'M', 'I', 'N', '_', '9', '\0', /* PA_SC_VPORT_ZMIN_9 (13768) */
	'P', 'A', '_', 'S', 'C', '_', 'V', 'P', 'O', 'R', 'T', '_', 'Z', 'M', 'A', 'X', '_', '9', '\0', /* PA_SC_VPORT_ZMAX_9 (13787) */
	'P', 'A', '_', 'S', 'C', '_', 'V', 'P', 'O', 'R', 'T', '_', 'Z', 'M', 'I', 'N', '_', '1', '0', '\0', /* PA_SC_VPORT_ZMIN_10 (13806, 13820) */
	'P', 'A', '_', 'S', 'C', '_', 'V', 'P', 'O', 'R', 'T', '_', 'Z', 'M', 'A', 'X', '_', '1', '0', '\0', /* PA_SC_VPORT_ZMAX_10 (13826) */
	'P', 'A', '_', 'S', 'C', '_', 'V', 'P', 'O', 'R', 'T', '_', 'Z', 'M', 'I', 'N', '_', '1', '1', '\0', /* PA_SC_VPORT_ZMIN_11 (13846) */
	'P', 'A', '_', 'S', 'C', '_', 'V', 'P', 'O', 'R', 'T', '_', 'Z', 'M', 'A', 'X', '_', '1', '1', '\0', /* PA_SC_VPORT_ZMAX_11 (13866) */
	'P', 'A', '_', 'S', 'C', '_', 'V', 'P', 'O', 'R', 'T', '_', 'Z', 'M', 'I', 'N', '_', '1', '2', '\0', /* PA_SC_VPORT_ZMIN_12 (13886) */
	'P', 'A', '_', 'S', 'C', '_', 'V', 'P', 'O', 'R', 'T', '_', 'Z', 'M', 'A', 'X', '_', '1', '2', '\0', /* PA_SC_VPORT_ZMAX_12 (13906) */
	'P', 'A', '_', 'S', 'C', '_', 'V', 'P', 'O', 'R', 'T', '_', 'Z', 'M', 'I', 'N', '_', '1', '3', '\0', /* PA_SC_VPORT_ZMIN_13 (13926) */
	'P', 'A', '_', 'S', 'C', '_', 'V', 'P', 'O', 'R', 'T', '_', 'Z', 'M', 'A', 'X', '_', '1', '3', '\0', /* PA_SC_VPORT_ZMAX_13 (13946) */
	'P', 'A', '_', 'S', 'C', '_', 'V', 'P', 'O', 'R', 'T', '_', 'Z', 'M', 'I', 'N', '_', '1', '4', '\0', /* PA_SC_VPORT_ZMIN_14 (13966) */
	'P', 'A', '_', 'S', 'C', '_', 'V', 'P', 'O', 'R', 'T', '_', 'Z', 'M', 'A', 'X', '_', '1', '4', '\0', /* PA_SC_VPORT_ZMAX_14 (13986) */
	'P', 'A', '_', 'S', 'C', '_', 'V', 'P', 'O', 'R', 'T', '_', 'Z', 'M', 'I', 'N', '_', '1', '5', '\0', /* PA_SC_VPORT_ZMIN_15 (14006) */
	'P', 'A', '_', 'S', 'C', '_', 'V', 'P', 'O', 'R', 'T', '_', 'Z', 'M', 'A', 'X', '_', '1', '5', '\0', /* PA_SC_VPORT_ZMAX_15 (14026) */
	'P', 'A', '_', 'S', 'C', '_', 'R', 'A', 'S', 'T', 'E', 'R', '_', 'C', 'O', 'N', 'F', 'I', 'G', '\0', /* PA_SC_RASTER_CONFIG (14046) */
	'P', 'A', '_', 'S', 'C', '_', 'R', 'A', 'S', 'T', 'E', 'R', '_', 'C', 'O', 'N', 'F', 'I', 'G', '_', '1', '\0', /* PA_SC_RASTER_CONFIG_1 (14066) */
	'P', 'A', '_', 'S', 'C', '_', 'S', 'C', 'R', 'E', 'E', 'N', '_', 'E', 'X', 'T', 'E', 'N', 'T', '_', 'C', 'O', 'N', 'T', 'R', 'O', 'L', '\0', /* PA_SC_SCREEN_EXTENT_CONTROL (14088) */
	'P', 'A', '_', 'S', 'C', '_', 'T', 'I', 'L', 'E', '_', 'S', 'T', 'E', 'E', 'R', 'I', 'N', 'G', '_', 'O', 'V', 'E', 'R', 'R', 'I', 'D', 'E', '\0', /* PA_SC_TILE_STEERING_OVERRIDE (14116) */
	'C', 'P', '_', 'P', 'E', 'R', 'F', 'M', 'O', 'N', '_', 'C', 'N', 'T', 'X', '_', 'C', 'N', 'T', 'L', '\0', /* CP_PERFMON_CNTX_CNTL (14145) */
	'C', 'P', '_', 'P', 'I', 'P', 'E', 'I', 'D', '\0', /* CP_PIPEID (14166) */
	'C', 'P', '_', 'V', 'M', 'I', 'D', '\0', /* CP_VMID (14176) */
	'P', 'A', '_', 'S', 'C', '_', 'R', 'I', 'G', 'H', 'T', '_', 'V', 'E', 'R', 'T', '_', 'G', 'R', 'I', 'D', '\0', /* PA_SC_RIGHT_VERT_GRID (14184) */
	'P', 'A', '_', 'S', 'C', '_', 'L', 'E', 'F', 'T', '_', 'V', 'E', 'R', 'T', '_', 'G', 'R', 'I', 'D', '\0', /* PA_SC_LEFT_VERT_GRID (14206) */
	'P', 'A', '_', 'S', 'C', '_', 'H', 'O', 'R', 'I', 'Z', '_', 'G', 'R', 'I', 'D', '\0', /* PA_SC_HORIZ_GRID (14227) */
	'V', 'G', 'T', '_', 'M', 'A', 'X', '_', 'V', 'T', 'X', '_', 'I', 'N', 'D', 'X', '\0', /* VGT_MAX_VTX_INDX (14244) */
	'V', 'G', 'T', '_', 'M', 'I', 'N', '_', 'V', 'T', 'X', '_', 'I', 'N', 'D', 'X', '\0', /* VGT_MIN_VTX_INDX (14261) */
	'V', 'G', 'T', '_', 'I', 'N', 'D', 'X', '_', 'O', 'F', 'F', 'S', 'E', 'T', '\0', /* VGT_INDX_OFFSET (14278, 14285) */
	'V', 'G', 'T', '_', 'M', 'U', 'L', 'T', 'I', '_', 'P', 'R', 'I', 'M', '_', 'I', 'B', '_', 'R', 'E', 'S', 'E', 'T', '_', 'I', 'N', 'D', 'X', '\0', /* VGT_MULTI_PRIM_IB_RESET_INDX (14294) */
	'C', 'B', '_', 'R', 'M', 'I', '_', 'G', 'L', '2', '_', 'C', 'A', 'C', 'H', 'E', '_', 'C', 'O', 'N', 'T', 'R', 'O', 'L', '\0', /* CB_RMI_GL2_CACHE_CONTROL (14323) */
	'C', 'B', '_', 'B', 'L', 'E', 'N', 'D', '_', 'R', 'E', 'D', '\0', /* CB_BLEND_RED (14348) */
	'C', 'B', '_', 'B', 'L', 'E', 'N', 'D', '_', 'G', 'R', 'E', 'E', 'N', '\0', /* CB_BLEND_GREEN (14361, 14373) */
	'C', 'B', '_', 'B', 'L', 'E', 'N', 'D', '_', 'B', 'L', 'U', 'E', '\0', /* CB_BLEND_BLUE (14376) */
	'C', 'B', '_', 'B', 'L', 'E', 'N', 'D', '_', 'A', 'L', 'P', 'H', 'A', '\0', /* CB_BLEND_ALPHA (14390) */
	'C', 'B', '_', 'D', 'C', 'C', '_', 'C', 'O', 'N', 'T', 'R', 'O', 'L', '\0', /* CB_DCC_CONTROL (14405) */
	'C', 'B', '_', 'C', 'O', 'V', 'E', 'R', 'A', 'G', 'E', '_', 'O', 'U', 'T', '_', 'C', 'O', 'N', 'T', 'R', 'O', 'L', '\0', /* CB_COVERAGE_OUT_CONTROL (14420) */
	'D', 'B', '_', 'S', 'T', 'E', 'N', 'C', 'I', 'L', '_', 'C', 'O', 'N', 'T', 'R', 'O', 'L', '\0', /* DB_STENCIL_CONTROL (14444) */
	'D', 'B', '_', 'S', 'T', 'E', 'N', 'C', 'I', 'L', 'R', 'E', 'F', 'M', 'A', 'S', 'K', '\0', /* DB_STENCILREFMASK (14463) */
	'D', 'B', '_', 'S', 'T', 'E', 'N', 'C', 'I', 'L', 'R', 'E', 'F', 'M', 'A', 'S', 'K', '_', 'B', 'F', '\0', /* DB_STENCILREFMASK_BF (14481) */
	'P', 'A', '_', 'C', 'L', '_', 'V', 'P', 'O', 'R', 'T', '_', 'X', 'S', 'C', 'A', 'L', 'E', '\0', /* PA_CL_VPORT_XSCALE (14502) */
	'P', 'A', '_', 'C', 'L', '_', 'V', 'P', 'O', 'R', 'T', '_', 'X', 'O', 'F', 'F', 'S', 'E', 'T', '\0', /* PA_CL_VPORT_XOFFSET (14521) */
	'P', 'A', '_', 'C', 'L', '_', 'V', 'P', 'O', 'R', 'T', '_', 'Y', 'S', 'C', 'A', 'L', 'E', '\0', /* PA_CL_VPORT_YSCALE (14541) */
	'P', 'A', '_', 'C', 'L', '_', 'V', 'P', 'O', 'R', 'T', '_', 'Y', 'O', 'F', 'F', 'S', 'E', 'T', '\0', /* PA_CL_VPORT_YOFFSET (14560) */
	'P', 'A', '_', 'C', 'L', '_', 'V', 'P', 'O', 'R', 'T', '_', 'Z', 'S', 'C', 'A', 'L', 'E', '\0', /* PA_CL_VPORT_ZSCALE (14580) */
	'P', 'A', '_', 'C', 'L', '_', 'V', 'P', 'O', 'R', 'T', '_', 'Z', 'O', 'F', 'F', 'S', 'E', 'T', '\0', /* PA_CL_VPORT_ZOFFSET (14599) */
	'P', 'A', '_', 'C', 'L', '_', 'V', 'P', 'O', 'R', 'T', '_', 'X', 'S', 'C', 'A', 'L', 'E', '_', '1', '\0', /* PA_CL_VPORT_XSCALE_1 (14619) */
	'P', 'A', '_', 'C', 'L', '_', 'V', 'P', 'O', 'R', 'T', '_', 'X', 'O', 'F', 'F', 'S', 'E', 'T', '_', '1', '\0', /* PA_CL_VPORT_XOFFSET_1 (14640) */
	'P', 'A', '_', 'C', 'L', '_', 'V', 'P', 'O', 'R', 'T', '_', 'Y', 'S', 'C', 'A', 'L', 'E', '_', '1', '\0', /* PA_CL_VPORT_YSCALE_1 (14662) */
	'P', 'A', '_', 'C', 'L', '_', 'V', 'P', 'O', 'R', 'T', '_', 'Y', 'O', 'F', 'F', 'S', 'E', 'T', '_', '1', '\0', /* PA_CL_VPORT_YOFFSET_1 (14683) */
	'P', 'A', '_', 'C', 'L', '_', 'V', 'P', 'O', 'R', 'T', '_', 'Z', 'S', 'C', 'A', 'L', 'E', '_', '1', '\0', /* PA_CL_VPORT_ZSCALE_1 (14705) */
	'P', 'A', '_', 'C', 'L', '_', 'V', 'P', 'O', 'R', 'T', '_', 'Z', 'O', 'F', 'F', 'S', 'E', 'T', '_', '1', '\0', /* PA_CL_VPORT_ZOFFSET_1 (14726) */
	'P', 'A', '_', 'C', 'L', '_', 'V', 'P', 'O', 'R', 'T', '_', 'X', 'S', 'C', 'A', 'L', 'E', '_', '2', '\0', /* PA_CL_VPORT_XSCALE_2 (14748) */
	'P', 'A', '_', 'C', 'L', '_', 'V', 'P', 'O', 'R', 'T', '_', 'X', 'O', 'F', 'F', 'S', 'E', 'T', '_', '2', '\0', /* PA_CL_VPORT_XOFFSET_2 (14769) */
	'P', 'A', '_', 'C', 'L', '_', 'V', 'P', 'O', 'R', 'T', '_', 'Y', 'S', 'C', 'A', 'L', 'E', '_', '2', '\0', /* PA_CL_VPORT_YSCALE_2 (14791) */
	'P', 'A', '_', 'C', 'L', '_', 'V', 'P', 'O', 'R', 'T', '_', 'Y', 'O', 'F', 'F', 'S', 'E', 'T', '_', '2', '\0', /* PA_CL_VPORT_YOFFSET_2 (14812) */
	'P', 'A', '_', 'C', 'L', '_', 'V', 'P', 'O', 'R', 'T', '_', 'Z', 'S', 'C', 'A', 'L', 'E', '_', '2', '\0', /* PA_CL_VPORT_ZSCALE_2 (14834) */
	'P', 'A', '_', 'C', 'L', '_', 'V', 'P', 'O', 'R', 'T', '_', 'Z', 'O', 'F', 'F', 'S', 'E', 'T', '_', '2', '\0', /* PA_CL_VPORT_ZOFFSET_2 (14855) */
	'P', 'A', '_', 'C', 'L', '_', 'V', 'P', 'O', 'R', 'T', '_', 'X', 'S', 'C', 'A', 'L', 'E', '_', '3', '\0', /* PA_CL_VPORT_XSCALE_3 (14877) */
	'P', 'A', '_', 'C', 'L', '_', 'V', 'P', 'O', 'R', 'T', '_', 'X', 'O', 'F', 'F', 'S', 'E', 'T', '_', '3', '\0', /* PA_CL_VPORT_XOFFSET_3 (14898) */
	'P', 'A', '_', 'C', 'L', '_', 'V', 'P', 'O', 'R', 'T', '_', 'Y', 'S', 'C', 'A', 'L', 'E', '_', '3', '\0', /* PA_CL_VPORT_YSCALE_3 (14920) */
	'P', 'A', '_', 'C', 'L', '_', 'V', 'P', 'O', 'R', 'T', '_', 'Y', 'O', 'F', 'F', 'S', 'E', 'T', '_', '3', '\0', /* PA_CL_VPORT_YOFFSET_3 (14941) */
	'P', 'A', '_', 'C', 'L', '_', 'V', 'P', 'O', 'R', 'T', '_', 'Z', 'S', 'C', 'A', 'L', 'E', '_', '3', '\0', /* PA_CL_VPORT_ZSCALE_3 (14963) */
	'P', 'A', '_', 'C', 'L', '_', 'V', 'P', 'O', 'R', 'T', '_', 'Z', 'O', 'F', 'F', 'S', 'E', 'T', '_', '3', '\0', /* PA_CL_VPORT_ZOFFSET_3 (14984) */
	'P', 'A', '_', 'C', 'L', '_', 'V', 'P', 'O', 'R', 'T', '_', 'X', 'S', 'C', 'A', 'L', 'E', '_', '4', '\0', /* PA_CL_VPORT_XSCALE_4 (15006) */
	'P', 'A', '_', 'C', 'L', '_', 'V', 'P', 'O', 'R', 'T', '_', 'X', 'O', 'F', 'F', 'S', 'E', 'T', '_', '4', '\0', /* PA_CL_VPORT_XOFFSET_4 (15027) */
	'P', 'A', '_', 'C', 'L', '_', 'V', 'P', 'O', 'R', 'T', '_', 'Y', 'S', 'C', 'A', 'L', 'E', '_', '4', '\0', /* PA_CL_VPORT_YSCALE_4 (15049) */
	'P', 'A', '_', 'C', 'L', '_', 'V', 'P', 'O', 'R', 'T', '_', 'Y', 'O', 'F', 'F', 'S', 'E', 'T', '_', '4', '\0', /* PA_CL_VPORT_YOFFSET_4 (15070) */
	'P', 'A', '_', 'C', 'L', '_', 'V', 'P', 'O', 'R', 'T', '_', 'Z', 'S', 'C', 'A', 'L', 'E', '_', '4', '\0', /* PA_CL_VPORT_ZSCALE_4 (15092) */
	'P', 'A', '_', 'C', 'L', '_', 'V', 'P', 'O', 'R', 'T', '_', 'Z', 'O', 'F', 'F', 'S', 'E', 'T', '_', '4', '\0', /* PA_CL_VPORT_ZOFFSET_4 (15113) */
	'P', 'A', '_', 'C', 'L', '_', 'V', 'P', 'O', 'R', 'T', '_', 'X', 'S', 'C', 'A', 'L', 'E', '_', '5', '\0', /* PA_CL_VPORT_XSCALE_5 (15135) */
	'P', 'A', '_', 'C', 'L', '_', 'V', 'P', 'O', 'R', 'T', '_', 'X', 'O', 'F', 'F', 'S', 'E', 'T', '_', '5', '\0', /* PA_CL_VPORT_XOFFSET_5 (15156) */
	'P', 'A', '_', 'C', 'L', '_', 'V', 'P', 'O', 'R', 'T', '_', 'Y', 'S', 'C', 'A', 'L', 'E', '_', '5', '\0', /* PA_CL_VPORT_YSCALE_5 (15178) */
	'P', 'A', '_', 'C', 'L', '_', 'V', 'P', 'O', 'R', 'T', '_', 'Y', 'O', 'F', 'F', 'S', 'E', 'T', '_', '5', '\0', /* PA_CL_VPORT_YOFFSET_5 (15199) */
	'P', 'A', '_', 'C', 'L', '_', 'V', 'P', 'O', 'R', 'T', '_', 'Z', 'S', 'C', 'A', 'L', 'E', '_', '5', '\0', /* PA_CL_VPORT_ZSCALE_5 (15221) */
	'P', 'A', '_', 'C', 'L', '_', 'V', 'P', 'O', 'R', 'T', '_', 'Z', 'O', 'F', 'F', 'S', 'E', 'T', '_', '5', '\0', /* PA_CL_VPORT_ZOFFSET_5 (15242) */
	'P', 'A', '_', 'C', 'L', '_', 'V', 'P', 'O', 'R', 'T', '_', 'X', 'S', 'C', 'A', 'L', 'E', '_', '6', '\0', /* PA_CL_VPORT_XSCALE_6 (15264) */
	'P', 'A', '_', 'C', 'L', '_', 'V', 'P', 'O', 'R', 'T', '_', 'X', 'O', 'F', 'F', 'S', 'E', 'T', '_', '6', '\0', /* PA_CL_VPORT_XOFFSET_6 (15285) */
	'P', 'A', '_', 'C', 'L', '_', 'V', 'P', 'O', 'R', 'T', '_', 'Y', 'S', 'C', 'A', 'L', 'E', '_', '6', '\0', /* PA_CL_VPORT_YSCALE_6 (15307) */
	'P', 'A', '_', 'C', 'L', '_', 'V', 'P', 'O', 'R', 'T', '_', 'Y', 'O', 'F', 'F', 'S', 'E', 'T', '_', '6', '\0', /* PA_CL_VPORT_YOFFSET_6 (15328) */
	'P', 'A', '_', 'C', 'L', '_', 'V', 'P', 'O', 'R', 'T', '_', 'Z', 'S', 'C', 'A', 'L', 'E', '_', '6', '\0', /* PA_CL_VPORT_ZSCALE_6 (15350) */
	'P', 'A', '_', 'C', 'L', '_', 'V', 'P', 'O', 'R', 'T', '_', 'Z', 'O', 'F', 'F', 'S', 'E', 'T', '_', '6', '\0', /* PA_CL_VPORT_ZOFFSET_6 (15371) */
	'P', 'A', '_', 'C', 'L', '_', 'V', 'P', 'O', 'R', 'T', '_', 'X', 'S', 'C', 'A', 'L', 'E', '_', '7', '\0', /* PA_CL_VPORT_XSCALE_7 (15393) */
	'P', 'A', '_', 'C', 'L', '_', 'V', 'P', 'O', 'R', 'T', '_', 'X', 'O', 'F', 'F', 'S', 'E', 'T', '_', '7', '\0', /* PA_CL_VPORT_XOFFSET_7 (15414) */
	'P', 'A', '_', 'C', 'L', '_', 'V', 'P', 'O', 'R', 'T', '_', 'Y', 'S', 'C', 'A', 'L', 'E', '_', '7', '\0', /* PA_CL_VPORT_YSCALE_7 (15436) */
	'P', 'A', '_', 'C', 'L', '_', 'V', 'P', 'O', 'R', 'T', '_', 'Y', 'O', 'F', 'F', 'S', 'E', 'T', '_', '7', '\0', /* PA_CL_VPORT_YOFFSET_7 (15457) */
	'P', 'A', '_', 'C', 'L', '_', 'V', 'P', 'O', 'R', 'T', '_', 'Z', 'S', 'C', 'A', 'L', 'E', '_', '7', '\0', /* PA_CL_VPORT_ZSCALE_7 (15479) */
	'P', 'A', '_', 'C', 'L', '_', 'V', 'P', 'O', 'R', 'T', '_', 'Z', 'O', 'F', 'F', 'S', 'E', 'T', '_', '7', '\0', /* PA_CL_VPORT_ZOFFSET_7 (15500) */
	'P', 'A', '_', 'C', 'L', '_', 'V', 'P', 'O', 'R', 'T', '_', 'X', 'S', 'C', 'A', 'L', 'E', '_', '8', '\0', /* PA_CL_VPORT_XSCALE_8 (15522) */
	'P', 'A', '_', 'C', 'L', '_', 'V', 'P', 'O', 'R', 'T', '_', 'X', 'O', 'F', 'F', 'S', 'E', 'T', '_', '8', '\0', /* PA_CL_VPORT_XOFFSET_8 (15543) */
	'P', 'A', '_', 'C', 'L', '_', 'V', 'P', 'O', 'R', 'T', '_', 'Y', 'S', 'C', 'A', 'L', 'E', '_', '8', '\0', /* PA_CL_VPORT_YSCALE_8 (15565) */
	'P', 'A', '_', 'C', 'L', '_', 'V', 'P', 'O', 'R', 'T', '_', 'Y', 'O', 'F', 'F', 'S', 'E', 'T', '_', '8', '\0', /* PA_CL_VPORT_YOFFSET_8 (15586) */
	'P', 'A', '_', 'C', 'L', '_', 'V', 'P', 'O', 'R', 'T', '_', 'Z', 'S', 'C', 'A', 'L', 'E', '_', '8', '\0', /* PA_CL_VPORT_ZSCALE_8 (15608) */
	'P', 'A', '_', 'C', 'L', '_', 'V', 'P', 'O', 'R', 'T', '_', 'Z', 'O', 'F', 'F', 'S', 'E', 'T', '_', '8', '\0', /* PA_CL_VPORT_ZOFFSET_8 (15629) */
	'P', 'A', '_', 'C', 'L', '_', 'V', 'P', 'O', 'R', 'T', '_', 'X', 'S', 'C', 'A', 'L', 'E', '_', '9', '\0', /* PA_CL_VPORT_XSCALE_9 (15651) */
	'P', 'A', '_', 'C', 'L', '_', 'V', 'P', 'O', 'R', 'T', '_', 'X', 'O', 'F', 'F', 'S', 'E', 'T', '_', '9', '\0', /* PA_CL_VPORT_XOFFSET_9 (15672) */
	'P', 'A', '_', 'C', 'L', '_', 'V', 'P', 'O', 'R', 'T', '_', 'Y', 'S', 'C', 'A', 'L', 'E', '_', '9', '\0', /* PA_CL_VPORT_YSCALE_9 (15694) */
	'P', 'A', '_', 'C', 'L', '_', 'V', 'P', 'O', 'R', 'T', '_', 'Y', 'O', 'F', 'F', 'S', 'E', 'T', '_', '9', '\0', /* PA_CL_VPORT_YOFFSET_9 (15715) */
	'P', 'A', '_', 'C', 'L', '_', 'V', 'P', 'O', 'R', 'T', '_', 'Z', 'S', 'C', 'A', 'L', 'E', '_', '9', '\0', /* PA_CL_VPORT_ZSCALE_9 (15737) */
	'P', 'A', '_', 'C', 'L', '_', 'V', 'P', 'O', 'R', 'T', '_', 'Z', 'O', 'F', 'F', 'S', 'E', 'T', '_', '9', '\0', /* PA_CL_VPORT_ZOFFSET_9 (15758) */
	'P', 'A', '_', 'C', 'L', '_', 'V', 'P', 'O', 'R', 'T', '_', 'X', 'S', 'C', 'A', 'L', 'E', '_', '1', '0', '\0', /* PA_CL_VPORT_XSCALE_10 (15780) */
	'P', 'A', '_', 'C', 'L', '_', 'V', 'P', 'O', 'R', 'T', '_', 'X', 'O', 'F', 'F', 'S', 'E', 'T', '_', '1', '0', '\0', /* PA_CL_VPORT_XOFFSET_10 (15802) */
	'P', 'A', '_', 'C', 'L', '_', 'V', 'P', 'O', 'R', 'T', '_', 'Y', 'S', 'C', 'A', 'L', 'E', '_', '1', '0', '\0', /* PA_CL_VPORT_YSCALE_10 (15825) */
	'P', 'A', '_', 'C', 'L', '_', 'V', 'P', 'O', 'R', 'T', '_', 'Y', 'O', 'F', 'F', 'S', 'E', 'T', '_', '1', '0', '\0', /* PA_CL_VPORT_YOFFSET_10 (15847) */
	'P', 'A', '_', 'C', 'L', '_', 'V', 'P', 'O', 'R', 'T', '_', 'Z', 'S', 'C', 'A', 'L', 'E', '_', '1', '0', '\0', /* PA_CL_VPORT_ZSCALE_10 (15870) */
	'P', 'A', '_', 'C', 'L', '_', 'V', 'P', 'O', 'R', 'T', '_', 'Z', 'O', 'F', 'F', 'S', 'E', 'T', '_', '1', '0', '\0', /* PA_CL_VPORT_ZOFFSET_10 (15892) */
	'P', 'A', '_', 'C', 'L', '_', 'V', 'P', 'O', 'R', 'T', '_', 'X', 'S', 'C', 'A', 'L', 'E', '_', '1', '1', '\0', /* PA_CL_VPORT_XSCALE_11 (15915) */
	'P', 'A', '_', 'C', 'L', '_', 'V', 'P', 'O', 'R', 'T', '_', 'X', 'O', 'F', 'F', 'S', 'E', 'T', '_', '1', '1', '\0', /* PA_CL_VPORT_XOFFSET_11 (15937) */
	'P', 'A', '_', 'C', 'L', '_', 'V', 'P', 'O', 'R', 'T', '_', 'Y', 'S', 'C', 'A', 'L', 'E', '_', '1', '1', '\0', /* PA_CL_VPORT_YSCALE_11 (15960) */
	'P', 'A', '_', 'C', 'L', '_', 'V', 'P', 'O', 'R', 'T', '_', 'Y', 'O', 'F', 'F', 'S', 'E', 'T', '_', '1', '1', '\0', /* PA_CL_VPORT_YOFFSET_11 (15982) */
	'P', 'A', '_', 'C', 'L', '_', 'V', 'P', 'O', 'R', 'T', '_', 'Z', 'S', 'C', 'A', 'L', 'E', '_', '1', '1', '\0', /* PA_CL_VPORT_ZSCALE_11 (16005) */
	'P', 'A', '_', 'C', 'L', '_', 'V', 'P', 'O', 'R', 'T', '_', 'Z', 'O', 'F', 'F', 'S', 'E', 'T', '_', '1', '1', '\0', /* PA_CL_VPORT_ZOFFSET_11 (16027) */
	'P', 'A', '_', 'C', 'L', '_', 'V', 'P', 'O', 'R', 'T', '_', 'X', 'S', 'C', 'A', 'L', 'E', '_', '1', '2', '\0', /* PA_CL_VPORT_XSCALE_12 (16050) */
	'P', 'A', '_', 'C', 'L', '_', 'V', 'P', 'O', 'R', 'T', '_', 'X', 'O', 'F', 'F', 'S', 'E', 'T', '_', '1', '2', '\0', /* PA_CL_VPORT_XOFFSET_12 (16072) */
	'P', 'A', '_', 'C', 'L', '_', 'V', 'P', 'O', 'R', 'T', '_', 'Y', 'S', 'C', 'A', 'L', 'E', '_', '1', '2', '\0', /* PA_CL_VPORT_YSCALE_12 (16095) */
	'P', 'A', '_', 'C', 'L', '_', 'V', 'P', 'O', 'R', 'T', '_', 'Y', 'O', 'F', 'F', 'S', 'E', 'T', '_', '1', '2', '\0', /* PA_CL_VPORT_YOFFSET_12 (16117) */
	'P', 'A', '_', 'C', 'L', '_', 'V', 'P', 'O', 'R', 'T', '_', 'Z', 'S', 'C', 'A', 'L', 'E', '_', '1', '2', '\0', /* PA_CL_VPORT_ZSCALE_12 (16140) */
	'P', 'A', '_', 'C', 'L', '_', 'V', 'P', 'O', 'R', 'T', '_', 'Z', 'O', 'F', 'F', 'S', 'E', 'T', '_', '1', '2', '\0', /* PA_CL_VPORT_ZOFFSET_12 (16162) */
	'P', 'A', '_', 'C', 'L', '_', 'V', 'P', 'O', 'R', 'T', '_', 'X', 'S', 'C', 'A', 'L', 'E', '_', '1', '3', '\0', /* PA_CL_VPORT_XSCALE_13 (16185) */
	'P', 'A', '_', 'C', 'L', '_', 'V', 'P', 'O', 'R', 'T', '_', 'X', 'O', 'F', 'F', 'S', 'E', 'T', '_', '1', '3', '\0', /* PA_CL_VPORT_XOFFSET_13 (16207) */
	'P', 'A', '_', 'C', 'L', '_', 'V', 'P', 'O', 'R', 'T', '_', 'Y', 'S', 'C', 'A', 'L', 'E', '_', '1', '3', '\0', /* PA_CL_VPORT_YSCALE_13 (16230) */
	'P', 'A', '_', 'C', 'L', '_', 'V', 'P', 'O', 'R', 'T', '_', 'Y', 'O', 'F', 'F', 'S', 'E', 'T', '_', '1', '3', '\0', /* PA_CL_VPORT_YOFFSET_13 (16252) */
	'P', 'A', '_', 'C', 'L', '_', 'V', 'P', 'O', 'R', 'T', '_', 'Z', 'S', 'C', 'A', 'L', 'E', '_', '1', '3', '\0', /* PA_CL_VPORT_ZSCALE_13 (16275) */
	'P', 'A', '_', 'C', 'L', '_', 'V', 'P', 'O', 'R', 'T', '_', 'Z', 'O', 'F', 'F', 'S', 'E', 'T', '_', '1', '3', '\0', /* PA_CL_VPORT_ZOFFSET_13 (16297) */
	'P', 'A', '_', 'C', 'L', '_', 'V', 'P', 'O', 'R', 'T', '_', 'X', 'S', 'C', 'A', 'L', 'E', '_', '1', '4', '\0', /* PA_CL_VPORT_XSCALE_14 (16320) */
	'P', 'A', '_', 'C', 'L', '_', 'V', 'P', 'O', 'R', 'T', '_', 'X', 'O', 'F', 'F', 'S', 'E', 'T', '_', '1', '4', '\0', /* PA_CL_VPORT_XOFFSET_14 (16342) */
	'P', 'A', '_', 'C', 'L', '_', 'V', 'P', 'O', 'R', 'T', '_', 'Y', 'S', 'C', 'A', 'L', 'E', '_', '1', '4', '\0', /* PA_CL_VPORT_YSCALE_14 (16365) */
	'P', 'A', '_', 'C', 'L', '_', 'V', 'P', 'O', 'R', 'T', '_', 'Y', 'O', 'F', 'F', 'S', 'E', 'T', '_', '1', '4', '\0', /* PA_CL_VPORT_YOFFSET_14 (16387) */
	'P', 'A', '_', 'C', 'L', '_', 'V', 'P', 'O', 'R', 'T', '_', 'Z', 'S', 'C', 'A', 'L', 'E', '_', '1', '4', '\0', /* PA_CL_VPORT_ZSCALE_14 (16410) */
	'P', 'A', '_', 'C', 'L', '_', 'V', 'P', 'O', 'R', 'T', '_', 'Z', 'O', 'F', 'F', 'S', 'E', 'T', '_', '1', '4', '\0', /* PA_CL_VPORT_ZOFFSET_14 (16432) */
	'P', 'A', '_', 'C', 'L', '_', 'V', 'P', 'O', 'R', 'T', '_', 'X', 'S', 'C', 'A', 'L', 'E', '_', '1', '5', '\0', /* PA_CL_VPORT_XSCALE_15 (16455) */
	'P', 'A', '_', 'C', 'L', '_', 'V', 'P', 'O', 'R', 'T', '_', 'X', 'O', 'F', 'F', 'S', 'E', 'T', '_', '1', '5', '\0', /* PA_CL_VPORT_XOFFSET_15 (16477) */
	'P', 'A', '_', 'C', 'L', '_', 'V', 'P', 'O', 'R', 'T', '_', 'Y', 'S', 'C', 'A', 'L', 'E', '_', '1', '5', '\0', /* PA_CL_VPORT_YSCALE_15 (16500) */
	'P', 'A', '_', 'C', 'L', '_', 'V', 'P', 'O', 'R', 'T', '_', 'Y', 'O', 'F', 'F', 'S', 'E', 'T', '_', '1', '5', '\0', /* PA_CL_VPORT_YOFFSET_15 (16522) */
	'P', 'A', '_', 'C', 'L', '_', 'V', 'P', 'O', 'R', 'T', '_', 'Z', 'S', 'C', 'A', 'L', 'E', '_', '1', '5', '\0', /* PA_CL_VPORT_ZSCALE_15 (16545) */
	'P', 'A', '_', 'C', 'L', '_', 'V', 'P', 'O', 'R', 'T', '_', 'Z', 'O', 'F', 'F', 'S', 'E', 'T', '_', '1', '5', '\0', /* PA_CL_VPORT_ZOFFSET_15 (16567) */
	'P', 'A', '_', 'C', 'L', '_', 'U', 'C', 'P', '_', '0', '_', 'X', '\0', /* PA_CL_UCP_0_X (16590) */
	'P', 'A', '_', 'C', 'L', '_', 'U', 'C', 'P', '_', '0', '_', 'Y', '\0', /* PA_CL_UCP_0_Y (16604) */
	'P', 'A', '_', 'C', 'L', '_', 'U', 'C', 'P', '_', '0', '_', 'Z', '\0', /* PA_CL_UCP_0_Z (16618) */
	'P', 'A', '_', 'C', 'L', '_', 'U', 'C', 'P', '_', '0', '_', 'W', '\0', /* PA_CL_UCP_0_W (16632) */
	'P', 'A', '_', 'C', 'L', '_', 'U', 'C', 'P', '_', '1', '_', 'X', '\0', /* PA_CL_UCP_1_X (16646) */
	'P', 'A', '_', 'C', 'L', '_', 'U', 'C', 'P', '_', '1', '_', 'Y', '\0', /* PA_CL_UCP_1_Y (16660) */
	'P', 'A', '_', 'C', 'L', '_', 'U', 'C', 'P', '_', '1', '_', 'Z', '\0', /* PA_CL_UCP_1_Z (16674) */
	'P', 'A', '_', 'C', 'L', '_', 'U', 'C', 'P', '_', '1', '_', 'W', '\0', /* PA_CL_UCP_1_W (16688) */
	'P', 'A', '_', 'C', 'L', '_', 'U', 'C', 'P', '_', '2', '_', 'X', '\0', /* PA_CL_UCP_2_X (16702) */
	'P', 'A', '_', 'C', 'L', '_', 'U', 'C', 'P', '_', '2', '_', 'Y', '\0', /* PA_CL_UCP_2_Y (16716) */
	'P', 'A', '_', 'C', 'L', '_', 'U', 'C', 'P', '_', '2', '_', 'Z', '\0', /* PA_CL_UCP_2_Z (16730) */
	'P', 'A', '_', 'C', 'L', '_', 'U', 'C', 'P', '_', '2', '_', 'W', '\0', /* PA_CL_UCP_2_W (16744) */
	'P', 'A', '_', 'C', 'L', '_', 'U', 'C', 'P', '_', '3', '_', 'X', '\0', /* PA_CL_UCP_3_X (16758) */
	'P', 'A', '_', 'C', 'L', '_', 'U', 'C', 'P', '_', '3', '_', 'Y', '\0', /* PA_CL_UCP_3_Y (16772) */
	'P', 'A', '_', 'C', 'L', '_', 'U', 'C', 'P', '_', '3', '_', 'Z', '\0', /* PA_CL_UCP_3_Z (16786) */
	'P', 'A', '_', 'C', 'L', '_', 'U', 'C', 'P', '_', '3', '_', 'W', '\0', /* PA_CL_UCP_3_W (16800) */
	'P', 'A', '_', 'C', 'L', '_', 'U', 'C', 'P', '_', '4', '_', 'X', '\0', /* PA_CL_UCP_4_X (16814) */
	'P', 'A', '_', 'C', 'L', '_', 'U', 'C', 'P', '_', '4', '_', 'Y', '\0', /* PA_CL_UCP_4_Y (16828) */
	'P', 'A', '_', 'C', 'L', '_', 'U', 'C', 'P', '_', '4', '_', 'Z', '\0', /* PA_CL_UCP_4_Z (16842) */
	'P', 'A', '_', 'C', 'L', '_', 'U', 'C', 'P', '_', '4', '_', 'W', '\0', /* PA_CL_UCP_4_W (16856) */
	'P', 'A', '_', 'C', 'L', '_', 'U', 'C', 'P', '_', '5', '_', 'X', '\0', /* PA_CL_UCP_5_X (16870) */
	'P', 'A', '_', 'C', 'L', '_', 'U', 'C', 'P', '_', '5', '_', 'Y', '\0', /* PA_CL_UCP_5_Y (16884) */
	'P', 'A', '_', 'C', 'L', '_', 'U', 'C', 'P', '_', '5', '_', 'Z', '\0', /* PA_CL_UCP_5_Z (16898) */
	'P', 'A', '_', 'C', 'L', '_', 'U', 'C', 'P', '_', '5', '_', 'W', '\0', /* PA_CL_UCP_5_W (16912) */
	'P', 'A', '_', 'C', 'L', '_', 'P', 'R', 'O', 'G', '_', 'N', 'E', 'A', 'R', '_', 'C', 'L', 'I', 'P', '_', 'Z', '\0', /* PA_CL_PROG_NEAR_CLIP_Z (16926) */
	'S', 'P', 'I', '_', 'P', 'S', '_', 'I', 'N', 'P', 'U', 'T', '_', 'C', 'N', 'T', 'L', '_', '0', '\0', /* SPI_PS_INPUT_CNTL_0 (16949) */
	'S', 'P', 'I', '_', 'P', 'S', '_', 'I', 'N', 'P', 'U', 'T', '_', 'C', 'N', 'T', 'L', '_', '1', '\0', /* SPI_PS_INPUT_CNTL_1 (16969) */
	'S', 'P', 'I', '_', 'P', 'S', '_', 'I', 'N', 'P', 'U', 'T', '_', 'C', 'N', 'T', 'L', '_', '2', '\0', /* SPI_PS_INPUT_CNTL_2 (16989) */
	'S', 'P', 'I', '_', 'P', 'S', '_', 'I', 'N', 'P', 'U', 'T', '_', 'C', 'N', 'T', 'L', '_', '3', '\0', /* SPI_PS_INPUT_CNTL_3 (17009) */
	'S', 'P', 'I', '_', 'P', 'S', '_', 'I', 'N', 'P', 'U', 'T', '_', 'C', 'N', 'T', 'L', '_', '4', '\0', /* SPI_PS_INPUT_CNTL_4 (17029) */
	'S', 'P', 'I', '_', 'P', 'S', '_', 'I', 'N', 'P', 'U', 'T', '_', 'C', 'N', 'T', 'L', '_', '5', '\0', /* SPI_PS_INPUT_CNTL_5 (17049) */
	'S', 'P', 'I', '_', 'P', 'S', '_', 'I', 'N', 'P', 'U', 'T', '_', 'C', 'N', 'T', 'L', '_', '6', '\0', /* SPI_PS_INPUT_CNTL_6 (17069) */
	'S', 'P', 'I', '_', 'P', 'S', '_', 'I', 'N', 'P', 'U', 'T', '_', 'C', 'N', 'T', 'L', '_', '7', '\0', /* SPI_PS_INPUT_CNTL_7 (17089) */
	'S', 'P', 'I', '_', 'P', 'S', '_', 'I', 'N', 'P', 'U', 'T', '_', 'C', 'N', 'T', 'L', '_', '8', '\0', /* SPI_PS_INPUT_CNTL_8 (17109) */
	'S', 'P', 'I', '_', 'P', 'S', '_', 'I', 'N', 'P', 'U', 'T', '_', 'C', 'N', 'T', 'L', '_', '9', '\0', /* SPI_PS_INPUT_CNTL_9 (17129) */
	'S', 'P', 'I', '_', 'P', 'S', '_', 'I', 'N', 'P', 'U', 'T', '_', 'C', 'N', 'T', 'L', '_', '1', '0', '\0', /* SPI_PS_INPUT_CNTL_10 (17149) */
	'S', 'P', 'I', '_', 'P', 'S', '_', 'I', 'N', 'P', 'U', 'T', '_', 'C', 'N', 'T', 'L', '_', '1', '1', '\0', /* SPI_PS_INPUT_CNTL_11 (17170) */
	'S', 'P', 'I', '_', 'P', 'S', '_', 'I', 'N', 'P', 'U', 'T', '_', 'C', 'N', 'T', 'L', '_', '1', '2', '\0', /* SPI_PS_INPUT_CNTL_12 (17191) */
	'S', 'P', 'I', '_', 'P', 'S', '_', 'I', 'N', 'P', 'U', 'T', '_', 'C', 'N', 'T', 'L', '_', '1', '3', '\0', /* SPI_PS_INPUT_CNTL_13 (17212) */
	'S', 'P', 'I', '_', 'P', 'S', '_', 'I', 'N', 'P', 'U', 'T', '_', 'C', 'N', 'T', 'L', '_', '1', '4', '\0', /* SPI_PS_INPUT_CNTL_14 (17233) */
	'S', 'P', 'I', '_', 'P', 'S', '_', 'I', 'N', 'P', 'U', 'T', '_', 'C', 'N', 'T', 'L', '_', '1', '5', '\0', /* SPI_PS_INPUT_CNTL_15 (17254) */
	'S', 'P', 'I', '_', 'P', 'S', '_', 'I', 'N', 'P', 'U', 'T', '_', 'C', 'N', 'T', 'L', '_', '1', '6', '\0', /* SPI_PS_INPUT_CNTL_16 (17275) */
	'S', 'P', 'I', '_', 'P', 'S', '_', 'I', 'N', 'P', 'U', 'T', '_', 'C', 'N', 'T', 'L', '_', '1', '7', '\0', /* SPI_PS_INPUT_CNTL_17 (17296) */
	'S', 'P', 'I', '_', 'P', 'S', '_', 'I', 'N', 'P', 'U', 'T', '_', 'C', 'N', 'T', 'L', '_', '1', '8', '\0', /* SPI_PS_INPUT_CNTL_18 (17317) */
	'S', 'P', 'I', '_', 'P', 'S', '_', 'I', 'N', 'P', 'U', 'T', '_', 'C', 'N', 'T', 'L', '_', '1', '9', '\0', /* SPI_PS_INPUT_CNTL_19 (17338) */
	'S', 'P', 'I', '_', 'P', 'S', '_', 'I', 'N', 'P', 'U', 'T', '_', 'C', 'N', 'T', 'L', '_', '2', '0', '\0', /* SPI_PS_INPUT_CNTL_20 (17359) */
	'S', 'P', 'I', '_', 'P', 'S', '_', 'I', 'N', 'P', 'U', 'T', '_', 'C', 'N', 'T', 'L', '_', '2', '1', '\0', /* SPI_PS_INPUT_CNTL_21 (17380) */
	'S', 'P', 'I', '_', 'P', 'S', '_', 'I', 'N', 'P', 'U', 'T', '_', 'C', 'N', 'T', 'L', '_', '2', '2', '\0', /* SPI_PS_INPUT_CNTL_22 (17401) */
	'S', 'P', 'I', '_', 'P', 'S', '_', 'I', 'N', 'P', 'U', 'T', '_', 'C', 'N', 'T', 'L', '_', '2', '3', '\0', /* SPI_PS_INPUT_CNTL_23 (17422) */
	'S', 'P', 'I', '_', 'P', 'S', '_', 'I', 'N', 'P', 'U', 'T', '_', 'C', 'N', 'T', 'L', '_', '2', '4', '\0', /* SPI_PS_INPUT_CNTL_24 (17443) */
	'S', 'P', 'I', '_', 'P', 'S', '_', 'I', 'N', 'P', 'U', 'T', '_', 'C', 'N', 'T', 'L', '_', '2', '5', '\0', /* SPI_PS_INPUT_CNTL_25 (17464) */
	'S', 'P', 'I', '_', 'P', 'S', '_', 'I', 'N', 'P', 'U', 'T', '_', 'C', 'N', 'T', 'L', '_', '2', '6', '\0', /* SPI_PS_INPUT_CNTL_26 (17485) */
	'S', 'P', 'I', '_', 'P', 'S', '_', 'I', 'N', 'P', 'U', 'T', '_', 'C', 'N', 'T', 'L', '_', '2', '7', '\0', /* SPI_PS_INPUT_CNTL_27 (17506) */
	'S', 'P', 'I', '_', 'P', 'S', '_', 'I', 'N', 'P', 'U', 'T', '_', 'C', 'N', 'T', 'L', '_', '2', '8', '\0', /* SPI_PS_INPUT_CNTL_28 (17527) */
	'S', 'P', 'I', '_', 'P', 'S', '_', 'I', 'N', 'P', 'U', 'T', '_', 'C', 'N', 'T', 'L', '_', '2', '9', '\0', /* SPI_PS_INPUT_CNTL_29 (17548) */
	'S', 'P', 'I', '_', 'P', 'S', '_', 'I', 'N', 'P', 'U', 'T', '_', 'C', 'N', 'T', 'L', '_', '3', '0', '\0', /* SPI_PS_INPUT_CNTL_30 (17569) */
	'S', 'P', 'I', '_', 'P', 'S', '_', 'I', 'N', 'P', 'U', 'T', '_', 'C', 'N', 'T', 'L', '_', '3', '1', '\0', /* SPI_PS_INPUT_CNTL_31 (17590) */
	'S', 'P', 'I', '_', 'V', 'S', '_', 'O', 'U', 'T', '_', 'C', 'O', 'N', 'F', 'I', 'G', '\0', /* SPI_VS_OUT_CONFIG (17611) */
	'S', 'P', 'I', '_', 'P', 'S', '_', 'I', 'N', 'P', 'U', 'T', '_', 'E', 'N', 'A', '\0', /* SPI_PS_INPUT_ENA (17629) */
	'S', 'P', 'I', '_', 'P', 'S', '_', 'I', 'N', 'P', 'U', 'T', '_', 'A', 'D', 'D', 'R', '\0', /* SPI_PS_INPUT_ADDR (17646) */
	'S', 'P', 'I', '_', 'I', 'N', 'T', 'E', 'R', 'P', '_', 'C', 'O', 'N', 'T', 'R', 'O', 'L', '_', '0', '\0', /* SPI_INTERP_CONTROL_0 (17664) */
	'S', 'P', 'I', '_', 'P', 'S', '_', 'I', 'N', '_', 'C', 'O', 'N', 'T', 'R', 'O', 'L', '\0', /* SPI_PS_IN_CONTROL (17685) */
	'S', 'P', 'I', '_', 'B', 'A', 'R', 'Y', 'C', '_', 'C', 'N', 'T', 'L', '\0', /* SPI_BARYC_CNTL (17703) */
	'S', 'P', 'I', '_', 'T', 'M', 'P', 'R', 'I', 'N', 'G', '_', 'S', 'I', 'Z', 'E', '\0', /* SPI_TMPRING_SIZE (17718) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'I', 'D', 'X', '_', 'F', 'O', 'R', 'M', 'A', 'T', '\0', /* SPI_SHADER_IDX_FORMAT (17735, 17750) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'P', 'O', 'S', '_', 'F', 'O', 'R', 'M', 'A', 'T', '\0', /* SPI_SHADER_POS_FORMAT (17757) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'Z', '_', 'F', 'O', 'R', 'M', 'A', 'T', '\0', /* SPI_SHADER_Z_FORMAT (17779) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'C', 'O', 'L', '_', 'F', 'O', 'R', 'M', 'A', 'T', '\0', /* SPI_SHADER_COL_FORMAT (17799) */
	'S', 'X', '_', 'P', 'S', '_', 'D', 'O', 'W', 'N', 'C', 'O', 'N', 'V', 'E', 'R', 'T', '\0', /* SX_PS_DOWNCONVERT (17821) */
	'S', 'X', '_', 'B', 'L', 'E', 'N', 'D', '_', 'O', 'P', 'T', '_', 'E', 'P', 'S', 'I', 'L', 'O', 'N', '\0', /* SX_BLEND_OPT_EPSILON (17839) */
	'S', 'X', '_', 'B', 'L', 'E', 'N', 'D', '_', 'O', 'P', 'T', '_', 'C', 'O', 'N', 'T', 'R', 'O', 'L', '\0', /* SX_BLEND_OPT_CONTROL (17860) */
	'S', 'X', '_', 'M', 'R', 'T', '0', '_', 'B', 'L', 'E', 'N', 'D', '_', 'O', 'P', 'T', '\0', /* SX_MRT0_BLEND_OPT (17881) */
	'S', 'X', '_', 'M', 'R', 'T', '1', '_', 'B', 'L', 'E', 'N', 'D', '_', 'O', 'P', 'T', '\0', /* SX_MRT1_BLEND_OPT (17899) */
	'S', 'X', '_', 'M', 'R', 'T', '2', '_', 'B', 'L', 'E', 'N', 'D', '_', 'O', 'P', 'T', '\0', /* SX_MRT2_BLEND_OPT (17917) */
	'S', 'X', '_', 'M', 'R', 'T', '3', '_', 'B', 'L', 'E', 'N', 'D', '_', 'O', 'P', 'T', '\0', /* SX_MRT3_BLEND_OPT (17935) */
	'S', 'X', '_', 'M', 'R', 'T', '4', '_', 'B', 'L', 'E', 'N', 'D', '_', 'O', 'P', 'T', '\0', /* SX_MRT4_BLEND_OPT (17953) */
	'S', 'X', '_', 'M', 'R', 'T', '5', '_', 'B', 'L', 'E', 'N', 'D', '_', 'O', 'P', 'T', '\0', /* SX_MRT5_BLEND_OPT (17971) */
	'S', 'X', '_', 'M', 'R', 'T', '6', '_', 'B', 'L', 'E', 'N', 'D', '_', 'O', 'P', 'T', '\0', /* SX_MRT6_BLEND_OPT (17989) */
	'S', 'X', '_', 'M', 'R', 'T', '7', '_', 'B', 'L', 'E', 'N', 'D', '_', 'O', 'P', 'T', '\0', /* SX_MRT7_BLEND_OPT (18007) */
	'C', 'B', '_', 'B', 'L', 'E', 'N', 'D', '0', '_', 'C', 'O', 'N', 'T', 'R', 'O', 'L', '\0', /* CB_BLEND0_CONTROL (18025) */
	'C', 'B', '_', 'B', 'L', 'E', 'N', 'D', '1', '_', 'C', 'O', 'N', 'T', 'R', 'O', 'L', '\0', /* CB_BLEND1_CONTROL (18043) */
	'C', 'B', '_', 'B', 'L', 'E', 'N', 'D', '2', '_', 'C', 'O', 'N', 'T', 'R', 'O', 'L', '\0', /* CB_BLEND2_CONTROL (18061) */
	'C', 'B', '_', 'B', 'L', 'E', 'N', 'D', '3', '_', 'C', 'O', 'N', 'T', 'R', 'O', 'L', '\0', /* CB_BLEND3_CONTROL (18079) */
	'C', 'B', '_', 'B', 'L', 'E', 'N', 'D', '4', '_', 'C', 'O', 'N', 'T', 'R', 'O', 'L', '\0', /* CB_BLEND4_CONTROL (18097) */
	'C', 'B', '_', 'B', 'L', 'E', 'N', 'D', '5', '_', 'C', 'O', 'N', 'T', 'R', 'O', 'L', '\0', /* CB_BLEND5_CONTROL (18115) */
	'C', 'B', '_', 'B', 'L', 'E', 'N', 'D', '6', '_', 'C', 'O', 'N', 'T', 'R', 'O', 'L', '\0', /* CB_BLEND6_CONTROL (18133) */
	'C', 'B', '_', 'B', 'L', 'E', 'N', 'D', '7', '_', 'C', 'O', 'N', 'T', 'R', 'O', 'L', '\0', /* CB_BLEND7_CONTROL (18151) */
	'C', 'S', '_', 'C', 'O', 'P', 'Y', '_', 'S', 'T', 'A', 'T', 'E', '\0', /* CS_COPY_STATE (18169) */
	'G', 'F', 'X', '_', 'C', 'O', 'P', 'Y', '_', 'S', 'T', 'A', 'T', 'E', '\0', /* GFX_COPY_STATE (18183) */
	'P', 'A', '_', 'C', 'L', '_', 'P', 'O', 'I', 'N', 'T', '_', 'X', '_', 'R', 'A', 'D', '\0', /* PA_CL_POINT_X_RAD (18198) */
	'P', 'A', '_', 'C', 'L', '_', 'P', 'O', 'I', 'N', 'T', '_', 'Y', '_', 'R', 'A', 'D', '\0', /* PA_CL_POINT_Y_RAD (18216) */
	'P', 'A', '_', 'C', 'L', '_', 'P', 'O', 'I', 'N', 'T', '_', 'S', 'I', 'Z', 'E', '\0', /* PA_CL_POINT_SIZE (18234) */
	'P', 'A', '_', 'C', 'L', '_', 'P', 'O', 'I', 'N', 'T', '_', 'C', 'U', 'L', 'L', '_', 'R', 'A', 'D', '\0', /* PA_CL_POINT_CULL_RAD (18251) */
	'V', 'G', 'T', '_', 'D', 'M', 'A', '_', 'B', 'A', 'S', 'E', '_', 'H', 'I', '\0', /* VGT_DMA_BASE_HI (18272) */
	'V', 'G', 'T', '_', 'D', 'M', 'A', '_', 'B', 'A', 'S', 'E', '\0', /* VGT_DMA_BASE (18288) */
	'V', 'G', 'T', '_', 'D', 'R', 'A', 'W', '_', 'I', 'N', 'I', 'T', 'I', 'A', 'T', 'O', 'R', '\0', /* VGT_DRAW_INITIATOR (18301) */
	'V', 'G', 'T', '_', 'I', 'M', 'M', 'E', 'D', '_', 'D', 'A', 'T', 'A', '\0', /* VGT_IMMED_DATA (18320) */
	'V', 'G', 'T', '_', 'E', 'V', 'E', 'N', 'T', '_', 'A', 'D', 'D', 'R', 'E', 'S', 'S', '_', 'R', 'E', 'G', '\0', /* VGT_EVENT_ADDRESS_REG (18335) */
	'G', 'E', '_', 'M', 'A', 'X', '_', 'O', 'U', 'T', 'P', 'U', 'T', '_', 'P', 'E', 'R', '_', 'S', 'U', 'B', 'G', 'R', 'O', 'U', 'P', '\0', /* GE_MAX_OUTPUT_PER_SUBGROUP (18357) */
	'D', 'B', '_', 'D', 'E', 'P', 'T', 'H', '_', 'C', 'O', 'N', 'T', 'R', 'O', 'L', '\0', /* DB_DEPTH_CONTROL (18384) */
	'D', 'B', '_', 'E', 'Q', 'A', 'A', '\0', /* DB_EQAA (18401) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '_', 'C', 'O', 'N', 'T', 'R', 'O', 'L', '\0', /* CB_COLOR_CONTROL (18409) */
	'D', 'B', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'C', 'O', 'N', 'T', 'R', 'O', 'L', '\0', /* DB_SHADER_CONTROL (18426) */
	'P', 'A', '_', 'C', 'L', '_', 'C', 'L', 'I', 'P', '_', 'C', 'N', 'T', 'L', '\0', /* PA_CL_CLIP_CNTL (18444) */
	'P', 'A', '_', 'S', 'U', '_', 'S', 'C', '_', 'M', 'O', 'D', 'E', '_', 'C', 'N', 'T', 'L', '\0', /* PA_SU_SC_MODE_CNTL (18460) */
	'P', 'A', '_', 'C', 'L', '_', 'V', 'T', 'E', '_', 'C', 'N', 'T', 'L', '\0', /* PA_CL_VTE_CNTL (18479) */
	'P', 'A', '_', 'C', 'L', '_', 'V', 'S', '_', 'O', 'U', 'T', '_', 'C', 'N', 'T', 'L', '\0', /* PA_CL_VS_OUT_CNTL (18494) */
	'P', 'A', '_', 'C', 'L', '_', 'N', 'A', 'N', 'I', 'N', 'F', '_', 'C', 'N', 'T', 'L', '\0', /* PA_CL_NANINF_CNTL (18512) */
	'P', 'A', '_', 'S', 'U', '_', 'L', 'I', 'N', 'E', '_', 'S', 'T', 'I', 'P', 'P', 'L', 'E', '_', 'C', 'N', 'T', 'L', '\0', /* PA_SU_LINE_STIPPLE_CNTL (18530) */
	'P', 'A', '_', 'S', 'U', '_', 'L', 'I', 'N', 'E', '_', 'S', 'T', 'I', 'P', 'P', 'L', 'E', '_', 'S', 'C', 'A', 'L', 'E', '\0', /* PA_SU_LINE_STIPPLE_SCALE (18554) */
	'P', 'A', '_', 'S', 'U', '_', 'P', 'R', 'I', 'M', '_', 'F', 'I', 'L', 'T', 'E', 'R', '_', 'C', 'N', 'T', 'L', '\0', /* PA_SU_PRIM_FILTER_CNTL (18579) */
	'P', 'A', '_', 'S', 'U', '_', 'S', 'M', 'A', 'L', 'L', '_', 'P', 'R', 'I', 'M', '_', 'F', 'I', 'L', 'T', 'E', 'R', '_', 'C', 'N', 'T', 'L', '\0', /* PA_SU_SMALL_PRIM_FILTER_CNTL (18602) */
	'P', 'A', '_', 'C', 'L', '_', 'O', 'B', 'J', 'P', 'R', 'I', 'M', '_', 'I', 'D', '_', 'C', 'N', 'T', 'L', '\0', /* PA_CL_OBJPRIM_ID_CNTL (18631) */
	'P', 'A', '_', 'C', 'L', '_', 'N', 'G', 'G', '_', 'C', 'N', 'T', 'L', '\0', /* PA_CL_NGG_CNTL (18653) */
	'P', 'A', '_', 'S', 'U', '_', 'O', 'V', 'E', 'R', '_', 'R', 'A', 'S', 'T', 'E', 'R', 'I', 'Z', 'A', 'T', 'I', 'O', 'N', '_', 'C', 'N', 'T', 'L', '\0', /* PA_SU_OVER_RASTERIZATION_CNTL (18668) */
	'P', 'A', '_', 'S', 'T', 'E', 'R', 'E', 'O', '_', 'C', 'N', 'T', 'L', '\0', /* PA_STEREO_CNTL (18698) */
	'P', 'A', '_', 'S', 'T', 'A', 'T', 'E', '_', 'S', 'T', 'E', 'R', 'E', 'O', '_', 'X', '\0', /* PA_STATE_STEREO_X (18713) */
	'P', 'A', '_', 'S', 'U', '_', 'P', 'O', 'I', 'N', 'T', '_', 'S', 'I', 'Z', 'E', '\0', /* PA_SU_POINT_SIZE (18731) */
	'P', 'A', '_', 'S', 'U', '_', 'P', 'O', 'I', 'N', 'T', '_', 'M', 'I', 'N', 'M', 'A', 'X', '\0', /* PA_SU_POINT_MINMAX (18748) */
	'P', 'A', '_', 'S', 'U', '_', 'L', 'I', 'N', 'E', '_', 'C', 'N', 'T', 'L', '\0', /* PA_SU_LINE_CNTL (18767) */
	'P', 'A', '_', 'S', 'C', '_', 'L', 'I', 'N', 'E', '_', 'S', 'T', 'I', 'P', 'P', 'L', 'E', '\0', /* PA_SC_LINE_STIPPLE (18783) */
	'V', 'G', 'T', '_', 'O', 'U', 'T', 'P', 'U', 'T', '_', 'P', 'A', 'T', 'H', '_', 'C', 'N', 'T', 'L', '\0', /* VGT_OUTPUT_PATH_CNTL (18802) */
	'V', 'G', 'T', '_', 'H', 'O', 'S', '_', 'C', 'N', 'T', 'L', '\0', /* VGT_HOS_CNTL (18823) */
	'V', 'G', 'T', '_', 'H', 'O', 'S', '_', 'M', 'A', 'X', '_', 'T', 'E', 'S', 'S', '_', 'L', 'E', 'V', 'E', 'L', '\0', /* VGT_HOS_MAX_TESS_LEVEL (18836) */
	'V', 'G', 'T', '_', 'H', 'O', 'S', '_', 'M', 'I', 'N', '_', 'T', 'E', 'S', 'S', '_', 'L', 'E', 'V', 'E', 'L', '\0', /* VGT_HOS_MIN_TESS_LEVEL (18859) */
	'V', 'G', 'T', '_', 'H', 'O', 'S', '_', 'R', 'E', 'U', 'S', 'E', '_', 'D', 'E', 'P', 'T', 'H', '\0', /* VGT_HOS_REUSE_DEPTH (18882, 18890, 18896) */
	'V', 'G', 'T', '_', 'G', 'R', 'O', 'U', 'P', '_', 'P', 'R', 'I', 'M', '_', 'T', 'Y', 'P', 'E', '\0', /* VGT_GROUP_PRIM_TYPE (18902, 18912) */
	'V', 'G', 'T', '_', 'G', 'R', 'O', 'U', 'P', '_', 'F', 'I', 'R', 'S', 'T', '_', 'D', 'E', 'C', 'R', '\0', /* VGT_GROUP_FIRST_DECR (18922, 18932, 18938) */
	'V', 'G', 'T', '_', 'G', 'R', 'O', 'U', 'P', '_', 'D', 'E', 'C', 'R', '\0', /* VGT_GROUP_DECR (18943) */
	'V', 'G', 'T', '_', 'G', 'R', 'O', 'U', 'P', '_', 'V', 'E', 'C', 'T', '_', '0', '_', 'C', 'N', 'T', 'L', '\0', /* VGT_GROUP_VECT_0_CNTL (18958) */
	'V', 'G', 'T', '_', 'G', 'R', 'O', 'U', 'P', '_', 'V', 'E', 'C', 'T', '_', '1', '_', 'C', 'N', 'T', 'L', '\0', /* VGT_GROUP_VECT_1_CNTL (18980) */
	'V', 'G', 'T', '_', 'G', 'R', 'O', 'U', 'P', '_', 'V', 'E', 'C', 'T', '_', '0', '_', 'F', 'M', 'T', '_', 'C', 'N', 'T', 'L', '\0', /* VGT_GROUP_VECT_0_FMT_CNTL (19002) */
	'V', 'G', 'T', '_', 'G', 'R', 'O', 'U', 'P', '_', 'V', 'E', 'C', 'T', '_', '1', '_', 'F', 'M', 'T', '_', 'C', 'N', 'T', 'L', '\0', /* VGT_GROUP_VECT_1_FMT_CNTL (19028) */
	'V', 'G', 'T', '_', 'G', 'S', '_', 'M', 'O', 'D', 'E', '\0', /* VGT_GS_MODE (19054) */
	'V', 'G', 'T', '_', 'G', 'S', '_', 'O', 'N', 'C', 'H', 'I', 'P', '_', 'C', 'N', 'T', 'L', '\0', /* VGT_GS_ONCHIP_CNTL (19066) */
	'P', 'A', '_', 'S', 'C', '_', 'M', 'O', 'D', 'E', '_', 'C', 'N', 'T', 'L', '_', '0', '\0', /* PA_SC_MODE_CNTL_0 (19085) */
	'P', 'A', '_', 'S', 'C', '_', 'M', 'O', 'D', 'E', '_', 'C', 'N', 'T', 'L', '_', '1', '\0', /* PA_SC_MODE_CNTL_1 (19103) */
	'V', 'G', 'T', '_', 'E', 'N', 'H', 'A', 'N', 'C', 'E', '\0', /* VGT_ENHANCE (19121) */
	'V', 'G', 'T', '_', 'G', 'S', '_', 'P', 'E', 'R', '_', 'E', 'S', '\0', /* VGT_GS_PER_ES (19133, 19137) */
	'V', 'G', 'T', '_', 'E', 'S', '_', 'P', 'E', 'R', '_', 'G', 'S', '\0', /* VGT_ES_PER_GS (19147, 19151) */
	'V', 'G', 'T', '_', 'G', 'S', '_', 'P', 'E', 'R', '_', 'V', 'S', '\0', /* VGT_GS_PER_VS (19161, 19165) */
	'V', 'G', 'T', '_', 'G', 'S', 'V', 'S', '_', 'R', 'I', 'N', 'G', '_', 'O', 'F', 'F', 'S', 'E', 'T', '_', '1', '\0', /* VGT_GSVS_RING_OFFSET_1 (19175) */
	'V', 'G', 'T', '_', 'G', 'S', 'V', 'S', '_', 'R', 'I', 'N', 'G', '_', 'O', 'F', 'F', 'S', 'E', 'T', '_', '2', '\0', /* VGT_GSVS_RING_OFFSET_2 (19198) */
	'V', 'G', 'T', '_', 'G', 'S', 'V', 'S', '_', 'R', 'I', 'N', 'G', '_', 'O', 'F', 'F', 'S', 'E', 'T', '_', '3', '\0', /* VGT_GSVS_RING_OFFSET_3 (19221) */
	'V', 'G', 'T', '_', 'G', 'S', '_', 'O', 'U', 'T', '_', 'P', 'R', 'I', 'M', '_', 'T', 'Y', 'P', 'E', '\0', /* VGT_GS_OUT_PRIM_TYPE (19244) */
	'I', 'A', '_', 'E', 'N', 'H', 'A', 'N', 'C', 'E', '\0', /* IA_ENHANCE (19265) */
	'V', 'G', 'T', '_', 'D', 'M', 'A', '_', 'S', 'I', 'Z', 'E', '\0', /* VGT_DMA_SIZE (19276) */
	'V', 'G', 'T', '_', 'D', 'M', 'A', '_', 'M', 'A', 'X', '_', 'S', 'I', 'Z', 'E', '\0', /* VGT_DMA_MAX_SIZE (19289, 19297) */
	'V', 'G', 'T', '_', 'D', 'M', 'A', '_', 'I', 'N', 'D', 'E', 'X', '_', 'T', 'Y', 'P', 'E', '\0', /* VGT_DMA_INDEX_TYPE (19306) */
	'W', 'D', '_', 'E', 'N', 'H', 'A', 'N', 'C', 'E', '\0', /* WD_ENHANCE (19325) */
	'V', 'G', 'T', '_', 'P', 'R', 'I', 'M', 'I', 'T', 'I', 'V', 'E', 'I', 'D', '_', 'E', 'N', '\0', /* VGT_PRIMITIVEID_EN (19336, 19340) */
	'V', 'G', 'T', '_', 'D', 'M', 'A', '_', 'N', 'U', 'M', '_', 'I', 'N', 'S', 'T', 'A', 'N', 'C', 'E', 'S', '\0', /* VGT_DMA_NUM_INSTANCES (19355) */
	'V', 'G', 'T', '_', 'P', 'R', 'I', 'M', 'I', 'T', 'I', 'V', 'E', 'I', 'D', '_', 'R', 'E', 'S', 'E', 'T', '\0', /* VGT_PRIMITIVEID_RESET (19377, 19393) */
	'V', 'G', 'T', '_', 'E', 'V', 'E', 'N', 'T', '_', 'I', 'N', 'I', 'T', 'I', 'A', 'T', 'O', 'R', '\0', /* VGT_EVENT_INITIATOR (19399) */
	'V', 'G', 'T', '_', 'M', 'U', 'L', 'T', 'I', '_', 'P', 'R', 'I', 'M', '_', 'I', 'B', '_', 'R', 'E', 'S', 'E', 'T', '_', 'E', 'N', '\0', /* VGT_MULTI_PRIM_IB_RESET_EN (19419, 19437) */
	'V', 'G', 'T', '_', 'D', 'R', 'A', 'W', '_', 'P', 'A', 'Y', 'L', 'O', 'A', 'D', '_', 'C', 'N', 'T', 'L', '\0', /* VGT_DRAW_PAYLOAD_CNTL (19446) */
	'V', 'G', 'T', '_', 'I', 'N', 'S', 'T', 'A', 'N', 'C', 'E', '_', 'S', 'T', 'E', 'P', '_', 'R', 'A', 'T', 'E', '_', '0', '\0', /* VGT_INSTANCE_STEP_RATE_0 (19468) */
	'V', 'G', 'T', '_', 'I', 'N', 'S', 'T', 'A', 'N', 'C', 'E', '_', 'S', 'T', 'E', 'P', '_', 'R', 'A', 'T', 'E', '_', '1', '\0', /* VGT_INSTANCE_STEP_RATE_1 (19493) */
	'I', 'A', '_', 'M', 'U', 'L', 'T', 'I', '_', 'V', 'G', 'T', '_', 'P', 'A', 'R', 'A', 'M', '\0', /* IA_MULTI_VGT_PARAM (19518) */
	'V', 'G', 'T', '_', 'E', 'S', 'G', 'S', '_', 'R', 'I', 'N', 'G', '_', 'I', 'T', 'E', 'M', 'S', 'I', 'Z', 'E', '\0', /* VGT_ESGS_RING_ITEMSIZE (19537, 19551) */
	'V', 'G', 'T', '_', 'G', 'S', 'V', 'S', '_', 'R', 'I', 'N', 'G', '_', 'I', 'T', 'E', 'M', 'S', 'I', 'Z', 'E', '\0', /* VGT_GSVS_RING_ITEMSIZE (19560) */
	'V', 'G', 'T', '_', 'R', 'E', 'U', 'S', 'E', '_', 'O', 'F', 'F', '\0', /* VGT_REUSE_OFF (19583, 19587) */
	'V', 'G', 'T', '_', 'V', 'T', 'X', '_', 'C', 'N', 'T', '_', 'E', 'N', '\0', /* VGT_VTX_CNT_EN (19597, 19601) */
	'D', 'B', '_', 'H', 'T', 'I', 'L', 'E', '_', 'S', 'U', 'R', 'F', 'A', 'C', 'E', '\0', /* DB_HTILE_SURFACE (19612, 19624) */
	'D', 'B', '_', 'S', 'R', 'E', 'S', 'U', 'L', 'T', 'S', '_', 'C', 'O', 'M', 'P', 'A', 'R', 'E', '_', 'S', 'T', 'A', 'T', 'E', '0', '\0', /* DB_SRESULTS_COMPARE_STATE0 (19629) */
	'D', 'B', '_', 'S', 'R', 'E', 'S', 'U', 'L', 'T', 'S', '_', 'C', 'O', 'M', 'P', 'A', 'R', 'E', '_', 'S', 'T', 'A', 'T', 'E', '1', '\0', /* DB_SRESULTS_COMPARE_STATE1 (19656) */
	'D', 'B', '_', 'P', 'R', 'E', 'L', 'O', 'A', 'D', '_', 'C', 'O', 'N', 'T', 'R', 'O', 'L', '\0', /* DB_PRELOAD_CONTROL (19683) */
	'V', 'G', 'T', '_', 'S', 'T', 'R', 'M', 'O', 'U', 'T', '_', 'B', 'U', 'F', 'F', 'E', 'R', '_', 'S', 'I', 'Z', 'E', '_', '0', '\0', /* VGT_STRMOUT_BUFFER_SIZE_0 (19702) */
	'V', 'G', 'T', '_', 'S', 'T', 'R', 'M', 'O', 'U', 'T', '_', 'V', 'T', 'X', '_', 'S', 'T', 'R', 'I', 'D', 'E', '_', '0', '\0', /* VGT_STRMOUT_VTX_STRIDE_0 (19728) */
	'V', 'G', 'T', '_', 'S', 'T', 'R', 'M', 'O', 'U', 'T', '_', 'B', 'U', 'F', 'F', 'E', 'R', '_', 'O', 'F', 'F', 'S', 'E', 'T', '_', '0', '\0', /* VGT_STRMOUT_BUFFER_OFFSET_0 (19753) */
	'V', 'G', 'T', '_', 'S', 'T', 'R', 'M', 'O', 'U', 'T', '_', 'B', 'U', 'F', 'F', 'E', 'R', '_', 'S', 'I', 'Z', 'E', '_', '1', '\0', /* VGT_STRMOUT_BUFFER_SIZE_1 (19781) */
	'V', 'G', 'T', '_', 'S', 'T', 'R', 'M', 'O', 'U', 'T', '_', 'V', 'T', 'X', '_', 'S', 'T', 'R', 'I', 'D', 'E', '_', '1', '\0', /* VGT_STRMOUT_VTX_STRIDE_1 (19807) */
	'V', 'G', 'T', '_', 'S', 'T', 'R', 'M', 'O', 'U', 'T', '_', 'B', 'U', 'F', 'F', 'E', 'R', '_', 'O', 'F', 'F', 'S', 'E', 'T', '_', '1', '\0', /* VGT_STRMOUT_BUFFER_OFFSET_1 (19832) */
	'V', 'G', 'T', '_', 'S', 'T', 'R', 'M', 'O', 'U', 'T', '_', 'B', 'U', 'F', 'F', 'E', 'R', '_', 'S', 'I', 'Z', 'E', '_', '2', '\0', /* VGT_STRMOUT_BUFFER_SIZE_2 (19860) */
	'V', 'G', 'T', '_', 'S', 'T', 'R', 'M', 'O', 'U', 'T', '_', 'V', 'T', 'X', '_', 'S', 'T', 'R', 'I', 'D', 'E', '_', '2', '\0', /* VGT_STRMOUT_VTX_STRIDE_2 (19886) */
	'V', 'G', 'T', '_', 'S', 'T', 'R', 'M', 'O', 'U', 'T', '_', 'B', 'U', 'F', 'F', 'E', 'R', '_', 'O', 'F', 'F', 'S', 'E', 'T', '_', '2', '\0', /* VGT_STRMOUT_BUFFER_OFFSET_2 (19911) */
	'V', 'G', 'T', '_', 'S', 'T', 'R', 'M', 'O', 'U', 'T', '_', 'B', 'U', 'F', 'F', 'E', 'R', '_', 'S', 'I', 'Z', 'E', '_', '3', '\0', /* VGT_STRMOUT_BUFFER_SIZE_3 (19939) */
	'V', 'G', 'T', '_', 'S', 'T', 'R', 'M', 'O', 'U', 'T', '_', 'V', 'T', 'X', '_', 'S', 'T', 'R', 'I', 'D', 'E', '_', '3', '\0', /* VGT_STRMOUT_VTX_STRIDE_3 (19965) */
	'V', 'G', 'T', '_', 'S', 'T', 'R', 'M', 'O', 'U', 'T', '_', 'B', 'U', 'F', 'F', 'E', 'R', '_', 'O', 'F', 'F', 'S', 'E', 'T', '_', '3', '\0', /* VGT_STRMOUT_BUFFER_OFFSET_3 (19990) */
	'V', 'G', 'T', '_', 'S', 'T', 'R', 'M', 'O', 'U', 'T', '_', 'D', 'R', 'A', 'W', '_', 'O', 'P', 'A', 'Q', 'U', 'E', '_', 'O', 'F', 'F', 'S', 'E', 'T', '\0', /* VGT_STRMOUT_DRAW_OPAQUE_OFFSET (20018) */
	'V', 'G', 'T', '_', 'S', 'T', 'R', 'M', 'O', 'U', 'T', '_', 'D', 'R', 'A', 'W', '_', 'O', 'P', 'A', 'Q', 'U', 'E', '_', 'B', 'U', 'F', 'F', 'E', 'R', '_', 'F', 'I', 'L', 'L', 'E', 'D', '_', 'S', 'I', 'Z', 'E', '\0', /* VGT_STRMOUT_DRAW_OPAQUE_BUFFER_FILLED_SIZE (20049) */
	'V', 'G', 'T', '_', 'S', 'T', 'R', 'M', 'O', 'U', 'T', '_', 'D', 'R', 'A', 'W', '_', 'O', 'P', 'A', 'Q', 'U', 'E', '_', 'V', 'E', 'R', 'T', 'E', 'X', '_', 'S', 'T', 'R', 'I', 'D', 'E', '\0', /* VGT_STRMOUT_DRAW_OPAQUE_VERTEX_STRIDE (20092, 20116, 20123) */
	'V', 'G', 'T', '_', 'G', 'S', '_', 'M', 'A', 'X', '_', 'V', 'E', 'R', 'T', '_', 'O', 'U', 'T', '\0', /* VGT_GS_MAX_VERT_OUT (20130, 20137, 20146) */
	'G', 'E', '_', 'N', 'G', 'G', '_', 'S', 'U', 'B', 'G', 'R', 'P', '_', 'C', 'N', 'T', 'L', '\0', /* GE_NGG_SUBGRP_CNTL (20150) */
	'V', 'G', 'T', '_', 'T', 'E', 'S', 'S', '_', 'D', 'I', 'S', 'T', 'R', 'I', 'B', 'U', 'T', 'I', 'O', 'N', '\0', /* VGT_TESS_DISTRIBUTION (20169) */
	'V', 'G', 'T', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'S', 'T', 'A', 'G', 'E', 'S', '_', 'E', 'N', '\0', /* VGT_SHADER_STAGES_EN (20191, 20206) */
	'V', 'G', 'T', '_', 'L', 'S', '_', 'H', 'S', '_', 'C', 'O', 'N', 'F', 'I', 'G', '\0', /* VGT_LS_HS_CONFIG (20212) */
	'V', 'G', 'T', '_', 'G', 'S', '_', 'V', 'E', 'R', 'T', '_', 'I', 'T', 'E', 'M', 'S', 'I', 'Z', 'E', '\0', /* VGT_GS_VERT_ITEMSIZE (20229) */
	'V', 'G', 'T', '_', 'G', 'S', '_', 'V', 'E', 'R', 'T', '_', 'I', 'T', 'E', 'M', 'S', 'I', 'Z', 'E', '_', '1', '\0', /* VGT_GS_VERT_ITEMSIZE_1 (20250) */
	'V', 'G', 'T', '_', 'G', 'S', '_', 'V', 'E', 'R', 'T', '_', 'I', 'T', 'E', 'M', 'S', 'I', 'Z', 'E', '_', '2', '\0', /* VGT_GS_VERT_ITEMSIZE_2 (20273) */
	'V', 'G', 'T', '_', 'G', 'S', '_', 'V', 'E', 'R', 'T', '_', 'I', 'T', 'E', 'M', 'S', 'I', 'Z', 'E', '_', '3', '\0', /* VGT_GS_VERT_ITEMSIZE_3 (20296) */
	'V', 'G', 'T', '_', 'T', 'F', '_', 'P', 'A', 'R', 'A', 'M', '\0', /* VGT_TF_PARAM (20319) */
	'D', 'B', '_', 'A', 'L', 'P', 'H', 'A', '_', 'T', 'O', '_', 'M', 'A', 'S', 'K', '\0', /* DB_ALPHA_TO_MASK (20332) */
	'V', 'G', 'T', '_', 'D', 'I', 'S', 'P', 'A', 'T', 'C', 'H', '_', 'D', 'R', 'A', 'W', '_', 'I', 'N', 'D', 'E', 'X', '\0', /* VGT_DISPATCH_DRAW_INDEX (20349) */
	'P', 'A', '_', 'S', 'U', '_', 'P', 'O', 'L', 'Y', '_', 'O', 'F', 'F', 'S', 'E', 'T', '_', 'D', 'B', '_', 'F', 'M', 'T', '_', 'C', 'N', 'T', 'L', '\0', /* PA_SU_POLY_OFFSET_DB_FMT_CNTL (20373) */
	'P', 'A', '_', 'S', 'U', '_', 'P', 'O', 'L', 'Y', '_', 'O', 'F', 'F', 'S', 'E', 'T', '_', 'C', 'L', 'A', 'M', 'P', '\0', /* PA_SU_POLY_OFFSET_CLAMP (20403) */
	'P', 'A', '_', 'S', 'U', '_', 'P', 'O', 'L', 'Y', '_', 'O', 'F', 'F', 'S', 'E', 'T', '_', 'F', 'R', 'O', 'N', 'T', '_', 'S', 'C', 'A', 'L', 'E', '\0', /* PA_SU_POLY_OFFSET_FRONT_SCALE (20427) */
	'P', 'A', '_', 'S', 'U', '_', 'P', 'O', 'L', 'Y', '_', 'O', 'F', 'F', 'S', 'E', 'T', '_', 'F', 'R', 'O', 'N', 'T', '_', 'O', 'F', 'F', 'S', 'E', 'T', '\0', /* PA_SU_POLY_OFFSET_FRONT_OFFSET (20457) */
	'P', 'A', '_', 'S', 'U', '_', 'P', 'O', 'L', 'Y', '_', 'O', 'F', 'F', 'S', 'E', 'T', '_', 'B', 'A', 'C', 'K', '_', 'S', 'C', 'A', 'L', 'E', '\0', /* PA_SU_POLY_OFFSET_BACK_SCALE (20488) */
	'P', 'A', '_', 'S', 'U', '_', 'P', 'O', 'L', 'Y', '_', 'O', 'F', 'F', 'S', 'E', 'T', '_', 'B', 'A', 'C', 'K', '_', 'O', 'F', 'F', 'S', 'E', 'T', '\0', /* PA_SU_POLY_OFFSET_BACK_OFFSET (20517) */
	'V', 'G', 'T', '_', 'G', 'S', '_', 'I', 'N', 'S', 'T', 'A', 'N', 'C', 'E', '_', 'C', 'N', 'T', '\0', /* VGT_GS_INSTANCE_CNT (20547, 20563) */
	'V', 'G', 'T', '_', 'S', 'T', 'R', 'M', 'O', 'U', 'T', '_', 'C', 'O', 'N', 'F', 'I', 'G', '\0', /* VGT_STRMOUT_CONFIG (20567) */
	'V', 'G', 'T', '_', 'S', 'T', 'R', 'M', 'O', 'U', 'T', '_', 'B', 'U', 'F', 'F', 'E', 'R', '_', 'C', 'O', 'N', 'F', 'I', 'G', '\0', /* VGT_STRMOUT_BUFFER_CONFIG (20586) */
	'V', 'G', 'T', '_', 'D', 'M', 'A', '_', 'E', 'V', 'E', 'N', 'T', '_', 'I', 'N', 'I', 'T', 'I', 'A', 'T', 'O', 'R', '\0', /* VGT_DMA_EVENT_INITIATOR (20612) */
	'P', 'A', '_', 'S', 'C', '_', 'C', 'E', 'N', 'T', 'R', 'O', 'I', 'D', '_', 'P', 'R', 'I', 'O', 'R', 'I', 'T', 'Y', '_', '0', '\0', /* PA_SC_CENTROID_PRIORITY_0 (20636) */
	'P', 'A', '_', 'S', 'C', '_', 'C', 'E', 'N', 'T', 'R', 'O', 'I', 'D', '_', 'P', 'R', 'I', 'O', 'R', 'I', 'T', 'Y', '_', '1', '\0', /* PA_SC_CENTROID_PRIORITY_1 (20662) */
	'P', 'A', '_', 'S', 'C', '_', 'L', 'I', 'N', 'E', '_', 'C', 'N', 'T', 'L', '\0', /* PA_SC_LINE_CNTL (20688) */
	'P', 'A', '_', 'S', 'C', '_', 'A', 'A', '_', 'C', 'O', 'N', 'F', 'I', 'G', '\0', /* PA_SC_AA_CONFIG (20704) */
	'P', 'A', '_', 'S', 'U', '_', 'V', 'T', 'X', '_', 'C', 'N', 'T', 'L', '\0', /* PA_SU_VTX_CNTL (20720) */
	'P', 'A', '_', 'C', 'L', '_', 'G', 'B', '_', 'V', 'E', 'R', 'T', '_', 'C', 'L', 'I', 'P', '_', 'A', 'D', 'J', '\0', /* PA_CL_GB_VERT_CLIP_ADJ (20735) */
	'P', 'A', '_', 'C', 'L', '_', 'G', 'B', '_', 'V', 'E', 'R', 'T', '_', 'D', 'I', 'S', 'C', '_', 'A', 'D', 'J', '\0', /* PA_CL_GB_VERT_DISC_ADJ (20758) */
	'P', 'A', '_', 'C', 'L', '_', 'G', 'B', '_', 'H', 'O', 'R', 'Z', '_', 'C', 'L', 'I', 'P', '_', 'A', 'D', 'J', '\0', /* PA_CL_GB_HORZ_CLIP_ADJ (20781) */
	'P', 'A', '_', 'C', 'L', '_', 'G', 'B', '_', 'H', 'O', 'R', 'Z', '_', 'D', 'I', 'S', 'C', '_', 'A', 'D', 'J', '\0', /* PA_CL_GB_HORZ_DISC_ADJ (20804) */
	'P', 'A', '_', 'S', 'C', '_', 'A', 'A', '_', 'S', 'A', 'M', 'P', 'L', 'E', '_', 'L', 'O', 'C', 'S', '_', 'P', 'I', 'X', 'E', 'L', '_', 'X', '0', 'Y', '0', '_', '0', '\0', /* PA_SC_AA_SAMPLE_LOCS_PIXEL_X0Y0_0 (20827) */
	'P', 'A', '_', 'S', 'C', '_', 'A', 'A', '_', 'S', 'A', 'M', 'P', 'L', 'E', '_', 'L', 'O', 'C', 'S', '_', 'P', 'I', 'X', 'E', 'L', '_', 'X', '0', 'Y', '0', '_', '1', '\0', /* PA_SC_AA_SAMPLE_LOCS_PIXEL_X0Y0_1 (20861) */
	'P', 'A', '_', 'S', 'C', '_', 'A', 'A', '_', 'S', 'A', 'M', 'P', 'L', 'E', '_', 'L', 'O', 'C', 'S', '_', 'P', 'I', 'X', 'E', 'L', '_', 'X', '0', 'Y', '0', '_', '2', '\0', /* PA_SC_AA_SAMPLE_LOCS_PIXEL_X0Y0_2 (20895) */
	'P', 'A', '_', 'S', 'C', '_', 'A', 'A', '_', 'S', 'A', 'M', 'P', 'L', 'E', '_', 'L', 'O', 'C', 'S', '_', 'P', 'I', 'X', 'E', 'L', '_', 'X', '0', 'Y', '0', '_', '3', '\0', /* PA_SC_AA_SAMPLE_LOCS_PIXEL_X0Y0_3 (20929) */
	'P', 'A', '_', 'S', 'C', '_', 'A', 'A', '_', 'S', 'A', 'M', 'P', 'L', 'E', '_', 'L', 'O', 'C', 'S', '_', 'P', 'I', 'X', 'E', 'L', '_', 'X', '1', 'Y', '0', '_', '0', '\0', /* PA_SC_AA_SAMPLE_LOCS_PIXEL_X1Y0_0 (20963) */
	'P', 'A', '_', 'S', 'C', '_', 'A', 'A', '_', 'S', 'A', 'M', 'P', 'L', 'E', '_', 'L', 'O', 'C', 'S', '_', 'P', 'I', 'X', 'E', 'L', '_', 'X', '1', 'Y', '0', '_', '1', '\0', /* PA_SC_AA_SAMPLE_LOCS_PIXEL_X1Y0_1 (20997) */
	'P', 'A', '_', 'S', 'C', '_', 'A', 'A', '_', 'S', 'A', 'M', 'P', 'L', 'E', '_', 'L', 'O', 'C', 'S', '_', 'P', 'I', 'X', 'E', 'L', '_', 'X', '1', 'Y', '0', '_', '2', '\0', /* PA_SC_AA_SAMPLE_LOCS_PIXEL_X1Y0_2 (21031) */
	'P', 'A', '_', 'S', 'C', '_', 'A', 'A', '_', 'S', 'A', 'M', 'P', 'L', 'E', '_', 'L', 'O', 'C', 'S', '_', 'P', 'I', 'X', 'E', 'L', '_', 'X', '1', 'Y', '0', '_', '3', '\0', /* PA_SC_AA_SAMPLE_LOCS_PIXEL_X1Y0_3 (21065) */
	'P', 'A', '_', 'S', 'C', '_', 'A', 'A', '_', 'S', 'A', 'M', 'P', 'L', 'E', '_', 'L', 'O', 'C', 'S', '_', 'P', 'I', 'X', 'E', 'L', '_', 'X', '0', 'Y', '1', '_', '0', '\0', /* PA_SC_AA_SAMPLE_LOCS_PIXEL_X0Y1_0 (21099) */
	'P', 'A', '_', 'S', 'C', '_', 'A', 'A', '_', 'S', 'A', 'M', 'P', 'L', 'E', '_', 'L', 'O', 'C', 'S', '_', 'P', 'I', 'X', 'E', 'L', '_', 'X', '0', 'Y', '1', '_', '1', '\0', /* PA_SC_AA_SAMPLE_LOCS_PIXEL_X0Y1_1 (21133) */
	'P', 'A', '_', 'S', 'C', '_', 'A', 'A', '_', 'S', 'A', 'M', 'P', 'L', 'E', '_', 'L', 'O', 'C', 'S', '_', 'P', 'I', 'X', 'E', 'L', '_', 'X', '0', 'Y', '1', '_', '2', '\0', /* PA_SC_AA_SAMPLE_LOCS_PIXEL_X0Y1_2 (21167) */
	'P', 'A', '_', 'S', 'C', '_', 'A', 'A', '_', 'S', 'A', 'M', 'P', 'L', 'E', '_', 'L', 'O', 'C', 'S', '_', 'P', 'I', 'X', 'E', 'L', '_', 'X', '0', 'Y', '1', '_', '3', '\0', /* PA_SC_AA_SAMPLE_LOCS_PIXEL_X0Y1_3 (21201) */
	'P', 'A', '_', 'S', 'C', '_', 'A', 'A', '_', 'S', 'A', 'M', 'P', 'L', 'E', '_', 'L', 'O', 'C', 'S', '_', 'P', 'I', 'X', 'E', 'L', '_', 'X', '1', 'Y', '1', '_', '0', '\0', /* PA_SC_AA_SAMPLE_LOCS_PIXEL_X1Y1_0 (21235) */
	'P', 'A', '_', 'S', 'C', '_', 'A', 'A', '_', 'S', 'A', 'M', 'P', 'L', 'E', '_', 'L', 'O', 'C', 'S', '_', 'P', 'I', 'X', 'E', 'L', '_', 'X', '1', 'Y', '1', '_', '1', '\0', /* PA_SC_AA_SAMPLE_LOCS_PIXEL_X1Y1_1 (21269) */
	'P', 'A', '_', 'S', 'C', '_', 'A', 'A', '_', 'S', 'A', 'M', 'P', 'L', 'E', '_', 'L', 'O', 'C', 'S', '_', 'P', 'I', 'X', 'E', 'L', '_', 'X', '1', 'Y', '1', '_', '2', '\0', /* PA_SC_AA_SAMPLE_LOCS_PIXEL_X1Y1_2 (21303) */
	'P', 'A', '_', 'S', 'C', '_', 'A', 'A', '_', 'S', 'A', 'M', 'P', 'L', 'E', '_', 'L', 'O', 'C', 'S', '_', 'P', 'I', 'X', 'E', 'L', '_', 'X', '1', 'Y', '1', '_', '3', '\0', /* PA_SC_AA_SAMPLE_LOCS_PIXEL_X1Y1_3 (21337) */
	'P', 'A', '_', 'S', 'C', '_', 'A', 'A', '_', 'M', 'A', 'S', 'K', '_', 'X', '0', 'Y', '0', '_', 'X', '1', 'Y', '0', '\0', /* PA_SC_AA_MASK_X0Y0_X1Y0 (21371) */
	'P', 'A', '_', 'S', 'C', '_', 'A', 'A', '_', 'M', 'A', 'S', 'K', '_', 'X', '0', 'Y', '1', '_', 'X', '1', 'Y', '1', '\0', /* PA_SC_AA_MASK_X0Y1_X1Y1 (21395) */
	'P', 'A', '_', 'S', 'C', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'C', 'O', 'N', 'T', 'R', 'O', 'L', '\0', /* PA_SC_SHADER_CONTROL (21419) */
	'P', 'A', '_', 'S', 'C', '_', 'B', 'I', 'N', 'N', 'E', 'R', '_', 'C', 'N', 'T', 'L', '_', '0', '\0', /* PA_SC_BINNER_CNTL_0 (21440) */
	'P', 'A', '_', 'S', 'C', '_', 'B', 'I', 'N', 'N', 'E', 'R', '_', 'C', 'N', 'T', 'L', '_', '1', '\0', /* PA_SC_BINNER_CNTL_1 (21460) */
	'P', 'A', '_', 'S', 'C', '_', 'C', 'O', 'N', 'S', 'E', 'R', 'V', 'A', 'T', 'I', 'V', 'E', '_', 'R', 'A', 'S', 'T', 'E', 'R', 'I', 'Z', 'A', 'T', 'I', 'O', 'N', '_', 'C', 'N', 'T', 'L', '\0', /* PA_SC_CONSERVATIVE_RASTERIZATION_CNTL (21480) */
	'P', 'A', '_', 'S', 'C', '_', 'N', 'G', 'G', '_', 'M', 'O', 'D', 'E', '_', 'C', 'N', 'T', 'L', '\0', /* PA_SC_NGG_MODE_CNTL (21518) */
	'V', 'G', 'T', '_', 'V', 'E', 'R', 'T', 'E', 'X', '_', 'R', 'E', 'U', 'S', 'E', '_', 'B', 'L', 'O', 'C', 'K', '_', 'C', 'N', 'T', 'L', '\0', /* VGT_VERTEX_REUSE_BLOCK_CNTL (21538) */
	'V', 'G', 'T', '_', 'O', 'U', 'T', '_', 'D', 'E', 'A', 'L', 'L', 'O', 'C', '_', 'C', 'N', 'T', 'L', '\0', /* VGT_OUT_DEALLOC_CNTL (21566) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '0', '_', 'B', 'A', 'S', 'E', '\0', /* CB_COLOR0_BASE (21587) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '0', '_', 'P', 'I', 'T', 'C', 'H', '\0', /* CB_COLOR0_PITCH (21602, 21612) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '0', '_', 'S', 'L', 'I', 'C', 'E', '\0', /* CB_COLOR0_SLICE (21618) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '0', '_', 'V', 'I', 'E', 'W', '\0', /* CB_COLOR0_VIEW (21634) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '0', '_', 'I', 'N', 'F', 'O', '\0', /* CB_COLOR0_INFO (21649) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '0', '_', 'A', 'T', 'T', 'R', 'I', 'B', '\0', /* CB_COLOR0_ATTRIB (21664) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '0', '_', 'D', 'C', 'C', '_', 'C', 'O', 'N', 'T', 'R', 'O', 'L', '\0', /* CB_COLOR0_DCC_CONTROL (21681) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '0', '_', 'C', 'M', 'A', 'S', 'K', '\0', /* CB_COLOR0_CMASK (21703) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '0', '_', 'C', 'M', 'A', 'S', 'K', '_', 'S', 'L', 'I', 'C', 'E', '\0', /* CB_COLOR0_CMASK_SLICE (21719) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '0', '_', 'F', 'M', 'A', 'S', 'K', '\0', /* CB_COLOR0_FMASK (21741) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '0', '_', 'F', 'M', 'A', 'S', 'K', '_', 'S', 'L', 'I', 'C', 'E', '\0', /* CB_COLOR0_FMASK_SLICE (21757) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '0', '_', 'C', 'L', 'E', 'A', 'R', '_', 'W', 'O', 'R', 'D', '0', '\0', /* CB_COLOR0_CLEAR_WORD0 (21779) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '0', '_', 'C', 'L', 'E', 'A', 'R', '_', 'W', 'O', 'R', 'D', '1', '\0', /* CB_COLOR0_CLEAR_WORD1 (21801) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '0', '_', 'D', 'C', 'C', '_', 'B', 'A', 'S', 'E', '\0', /* CB_COLOR0_DCC_BASE (21823) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '1', '_', 'B', 'A', 'S', 'E', '\0', /* CB_COLOR1_BASE (21842) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '1', '_', 'P', 'I', 'T', 'C', 'H', '\0', /* CB_COLOR1_PITCH (21857) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '1', '_', 'S', 'L', 'I', 'C', 'E', '\0', /* CB_COLOR1_SLICE (21873) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '1', '_', 'V', 'I', 'E', 'W', '\0', /* CB_COLOR1_VIEW (21889) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '1', '_', 'I', 'N', 'F', 'O', '\0', /* CB_COLOR1_INFO (21904) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '1', '_', 'A', 'T', 'T', 'R', 'I', 'B', '\0', /* CB_COLOR1_ATTRIB (21919) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '1', '_', 'D', 'C', 'C', '_', 'C', 'O', 'N', 'T', 'R', 'O', 'L', '\0', /* CB_COLOR1_DCC_CONTROL (21936) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '1', '_', 'C', 'M', 'A', 'S', 'K', '\0', /* CB_COLOR1_CMASK (21958) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '1', '_', 'C', 'M', 'A', 'S', 'K', '_', 'S', 'L', 'I', 'C', 'E', '\0', /* CB_COLOR1_CMASK_SLICE (21974) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '1', '_', 'F', 'M', 'A', 'S', 'K', '\0', /* CB_COLOR1_FMASK (21996) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '1', '_', 'F', 'M', 'A', 'S', 'K', '_', 'S', 'L', 'I', 'C', 'E', '\0', /* CB_COLOR1_FMASK_SLICE (22012) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '1', '_', 'C', 'L', 'E', 'A', 'R', '_', 'W', 'O', 'R', 'D', '0', '\0', /* CB_COLOR1_CLEAR_WORD0 (22034) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '1', '_', 'C', 'L', 'E', 'A', 'R', '_', 'W', 'O', 'R', 'D', '1', '\0', /* CB_COLOR1_CLEAR_WORD1 (22056) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '1', '_', 'D', 'C', 'C', '_', 'B', 'A', 'S', 'E', '\0', /* CB_COLOR1_DCC_BASE (22078) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '2', '_', 'B', 'A', 'S', 'E', '\0', /* CB_COLOR2_BASE (22097) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '2', '_', 'P', 'I', 'T', 'C', 'H', '\0', /* CB_COLOR2_PITCH (22112) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '2', '_', 'S', 'L', 'I', 'C', 'E', '\0', /* CB_COLOR2_SLICE (22128) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '2', '_', 'V', 'I', 'E', 'W', '\0', /* CB_COLOR2_VIEW (22144) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '2', '_', 'I', 'N', 'F', 'O', '\0', /* CB_COLOR2_INFO (22159) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '2', '_', 'A', 'T', 'T', 'R', 'I', 'B', '\0', /* CB_COLOR2_ATTRIB (22174) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '2', '_', 'D', 'C', 'C', '_', 'C', 'O', 'N', 'T', 'R', 'O', 'L', '\0', /* CB_COLOR2_DCC_CONTROL (22191) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '2', '_', 'C', 'M', 'A', 'S', 'K', '\0', /* CB_COLOR2_CMASK (22213) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '2', '_', 'C', 'M', 'A', 'S', 'K', '_', 'S', 'L', 'I', 'C', 'E', '\0', /* CB_COLOR2_CMASK_SLICE (22229) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '2', '_', 'F', 'M', 'A', 'S', 'K', '\0', /* CB_COLOR2_FMASK (22251) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '2', '_', 'F', 'M', 'A', 'S', 'K', '_', 'S', 'L', 'I', 'C', 'E', '\0', /* CB_COLOR2_FMASK_SLICE (22267) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '2', '_', 'C', 'L', 'E', 'A', 'R', '_', 'W', 'O', 'R', 'D', '0', '\0', /* CB_COLOR2_CLEAR_WORD0 (22289) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '2', '_', 'C', 'L', 'E', 'A', 'R', '_', 'W', 'O', 'R', 'D', '1', '\0', /* CB_COLOR2_CLEAR_WORD1 (22311) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '2', '_', 'D', 'C', 'C', '_', 'B', 'A', 'S', 'E', '\0', /* CB_COLOR2_DCC_BASE (22333) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '3', '_', 'B', 'A', 'S', 'E', '\0', /* CB_COLOR3_BASE (22352) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '3', '_', 'P', 'I', 'T', 'C', 'H', '\0', /* CB_COLOR3_PITCH (22367) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '3', '_', 'S', 'L', 'I', 'C', 'E', '\0', /* CB_COLOR3_SLICE (22383) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '3', '_', 'V', 'I', 'E', 'W', '\0', /* CB_COLOR3_VIEW (22399) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '3', '_', 'I', 'N', 'F', 'O', '\0', /* CB_COLOR3_INFO (22414) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '3', '_', 'A', 'T', 'T', 'R', 'I', 'B', '\0', /* CB_COLOR3_ATTRIB (22429) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '3', '_', 'D', 'C', 'C', '_', 'C', 'O', 'N', 'T', 'R', 'O', 'L', '\0', /* CB_COLOR3_DCC_CONTROL (22446) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '3', '_', 'C', 'M', 'A', 'S', 'K', '\0', /* CB_COLOR3_CMASK (22468) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '3', '_', 'C', 'M', 'A', 'S', 'K', '_', 'S', 'L', 'I', 'C', 'E', '\0', /* CB_COLOR3_CMASK_SLICE (22484) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '3', '_', 'F', 'M', 'A', 'S', 'K', '\0', /* CB_COLOR3_FMASK (22506) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '3', '_', 'F', 'M', 'A', 'S', 'K', '_', 'S', 'L', 'I', 'C', 'E', '\0', /* CB_COLOR3_FMASK_SLICE (22522) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '3', '_', 'C', 'L', 'E', 'A', 'R', '_', 'W', 'O', 'R', 'D', '0', '\0', /* CB_COLOR3_CLEAR_WORD0 (22544) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '3', '_', 'C', 'L', 'E', 'A', 'R', '_', 'W', 'O', 'R', 'D', '1', '\0', /* CB_COLOR3_CLEAR_WORD1 (22566) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '3', '_', 'D', 'C', 'C', '_', 'B', 'A', 'S', 'E', '\0', /* CB_COLOR3_DCC_BASE (22588) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '4', '_', 'B', 'A', 'S', 'E', '\0', /* CB_COLOR4_BASE (22607) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '4', '_', 'P', 'I', 'T', 'C', 'H', '\0', /* CB_COLOR4_PITCH (22622) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '4', '_', 'S', 'L', 'I', 'C', 'E', '\0', /* CB_COLOR4_SLICE (22638) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '4', '_', 'V', 'I', 'E', 'W', '\0', /* CB_COLOR4_VIEW (22654) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '4', '_', 'I', 'N', 'F', 'O', '\0', /* CB_COLOR4_INFO (22669) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '4', '_', 'A', 'T', 'T', 'R', 'I', 'B', '\0', /* CB_COLOR4_ATTRIB (22684) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '4', '_', 'D', 'C', 'C', '_', 'C', 'O', 'N', 'T', 'R', 'O', 'L', '\0', /* CB_COLOR4_DCC_CONTROL (22701) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '4', '_', 'C', 'M', 'A', 'S', 'K', '\0', /* CB_COLOR4_CMASK (22723) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '4', '_', 'C', 'M', 'A', 'S', 'K', '_', 'S', 'L', 'I', 'C', 'E', '\0', /* CB_COLOR4_CMASK_SLICE (22739) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '4', '_', 'F', 'M', 'A', 'S', 'K', '\0', /* CB_COLOR4_FMASK (22761) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '4', '_', 'F', 'M', 'A', 'S', 'K', '_', 'S', 'L', 'I', 'C', 'E', '\0', /* CB_COLOR4_FMASK_SLICE (22777) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '4', '_', 'C', 'L', 'E', 'A', 'R', '_', 'W', 'O', 'R', 'D', '0', '\0', /* CB_COLOR4_CLEAR_WORD0 (22799) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '4', '_', 'C', 'L', 'E', 'A', 'R', '_', 'W', 'O', 'R', 'D', '1', '\0', /* CB_COLOR4_CLEAR_WORD1 (22821) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '4', '_', 'D', 'C', 'C', '_', 'B', 'A', 'S', 'E', '\0', /* CB_COLOR4_DCC_BASE (22843) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '5', '_', 'B', 'A', 'S', 'E', '\0', /* CB_COLOR5_BASE (22862) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '5', '_', 'P', 'I', 'T', 'C', 'H', '\0', /* CB_COLOR5_PITCH (22877) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '5', '_', 'S', 'L', 'I', 'C', 'E', '\0', /* CB_COLOR5_SLICE (22893) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '5', '_', 'V', 'I', 'E', 'W', '\0', /* CB_COLOR5_VIEW (22909) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '5', '_', 'I', 'N', 'F', 'O', '\0', /* CB_COLOR5_INFO (22924) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '5', '_', 'A', 'T', 'T', 'R', 'I', 'B', '\0', /* CB_COLOR5_ATTRIB (22939) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '5', '_', 'D', 'C', 'C', '_', 'C', 'O', 'N', 'T', 'R', 'O', 'L', '\0', /* CB_COLOR5_DCC_CONTROL (22956) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '5', '_', 'C', 'M', 'A', 'S', 'K', '\0', /* CB_COLOR5_CMASK (22978) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '5', '_', 'C', 'M', 'A', 'S', 'K', '_', 'S', 'L', 'I', 'C', 'E', '\0', /* CB_COLOR5_CMASK_SLICE (22994) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '5', '_', 'F', 'M', 'A', 'S', 'K', '\0', /* CB_COLOR5_FMASK (23016) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '5', '_', 'F', 'M', 'A', 'S', 'K', '_', 'S', 'L', 'I', 'C', 'E', '\0', /* CB_COLOR5_FMASK_SLICE (23032) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '5', '_', 'C', 'L', 'E', 'A', 'R', '_', 'W', 'O', 'R', 'D', '0', '\0', /* CB_COLOR5_CLEAR_WORD0 (23054) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '5', '_', 'C', 'L', 'E', 'A', 'R', '_', 'W', 'O', 'R', 'D', '1', '\0', /* CB_COLOR5_CLEAR_WORD1 (23076) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '5', '_', 'D', 'C', 'C', '_', 'B', 'A', 'S', 'E', '\0', /* CB_COLOR5_DCC_BASE (23098) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '6', '_', 'B', 'A', 'S', 'E', '\0', /* CB_COLOR6_BASE (23117) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '6', '_', 'P', 'I', 'T', 'C', 'H', '\0', /* CB_COLOR6_PITCH (23132) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '6', '_', 'S', 'L', 'I', 'C', 'E', '\0', /* CB_COLOR6_SLICE (23148) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '6', '_', 'V', 'I', 'E', 'W', '\0', /* CB_COLOR6_VIEW (23164) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '6', '_', 'I', 'N', 'F', 'O', '\0', /* CB_COLOR6_INFO (23179) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '6', '_', 'A', 'T', 'T', 'R', 'I', 'B', '\0', /* CB_COLOR6_ATTRIB (23194) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '6', '_', 'D', 'C', 'C', '_', 'C', 'O', 'N', 'T', 'R', 'O', 'L', '\0', /* CB_COLOR6_DCC_CONTROL (23211) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '6', '_', 'C', 'M', 'A', 'S', 'K', '\0', /* CB_COLOR6_CMASK (23233) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '6', '_', 'C', 'M', 'A', 'S', 'K', '_', 'S', 'L', 'I', 'C', 'E', '\0', /* CB_COLOR6_CMASK_SLICE (23249) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '6', '_', 'F', 'M', 'A', 'S', 'K', '\0', /* CB_COLOR6_FMASK (23271) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '6', '_', 'F', 'M', 'A', 'S', 'K', '_', 'S', 'L', 'I', 'C', 'E', '\0', /* CB_COLOR6_FMASK_SLICE (23287) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '6', '_', 'C', 'L', 'E', 'A', 'R', '_', 'W', 'O', 'R', 'D', '0', '\0', /* CB_COLOR6_CLEAR_WORD0 (23309) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '6', '_', 'C', 'L', 'E', 'A', 'R', '_', 'W', 'O', 'R', 'D', '1', '\0', /* CB_COLOR6_CLEAR_WORD1 (23331) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '6', '_', 'D', 'C', 'C', '_', 'B', 'A', 'S', 'E', '\0', /* CB_COLOR6_DCC_BASE (23353) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '7', '_', 'B', 'A', 'S', 'E', '\0', /* CB_COLOR7_BASE (23372) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '7', '_', 'P', 'I', 'T', 'C', 'H', '\0', /* CB_COLOR7_PITCH (23387) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '7', '_', 'S', 'L', 'I', 'C', 'E', '\0', /* CB_COLOR7_SLICE (23403) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '7', '_', 'V', 'I', 'E', 'W', '\0', /* CB_COLOR7_VIEW (23419) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '7', '_', 'I', 'N', 'F', 'O', '\0', /* CB_COLOR7_INFO (23434) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '7', '_', 'A', 'T', 'T', 'R', 'I', 'B', '\0', /* CB_COLOR7_ATTRIB (23449) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '7', '_', 'D', 'C', 'C', '_', 'C', 'O', 'N', 'T', 'R', 'O', 'L', '\0', /* CB_COLOR7_DCC_CONTROL (23466) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '7', '_', 'C', 'M', 'A', 'S', 'K', '\0', /* CB_COLOR7_CMASK (23488) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '7', '_', 'C', 'M', 'A', 'S', 'K', '_', 'S', 'L', 'I', 'C', 'E', '\0', /* CB_COLOR7_CMASK_SLICE (23504) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '7', '_', 'F', 'M', 'A', 'S', 'K', '\0', /* CB_COLOR7_FMASK (23526) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '7', '_', 'F', 'M', 'A', 'S', 'K', '_', 'S', 'L', 'I', 'C', 'E', '\0', /* CB_COLOR7_FMASK_SLICE (23542) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '7', '_', 'C', 'L', 'E', 'A', 'R', '_', 'W', 'O', 'R', 'D', '0', '\0', /* CB_COLOR7_CLEAR_WORD0 (23564) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '7', '_', 'C', 'L', 'E', 'A', 'R', '_', 'W', 'O', 'R', 'D', '1', '\0', /* CB_COLOR7_CLEAR_WORD1 (23586) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '7', '_', 'D', 'C', 'C', '_', 'B', 'A', 'S', 'E', '\0', /* CB_COLOR7_DCC_BASE (23608) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '0', '_', 'B', 'A', 'S', 'E', '_', 'E', 'X', 'T', '\0', /* CB_COLOR0_BASE_EXT (23627) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '1', '_', 'B', 'A', 'S', 'E', '_', 'E', 'X', 'T', '\0', /* CB_COLOR1_BASE_EXT (23646) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '2', '_', 'B', 'A', 'S', 'E', '_', 'E', 'X', 'T', '\0', /* CB_COLOR2_BASE_EXT (23665) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '3', '_', 'B', 'A', 'S', 'E', '_', 'E', 'X', 'T', '\0', /* CB_COLOR3_BASE_EXT (23684) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '4', '_', 'B', 'A', 'S', 'E', '_', 'E', 'X', 'T', '\0', /* CB_COLOR4_BASE_EXT (23703) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '5', '_', 'B', 'A', 'S', 'E', '_', 'E', 'X', 'T', '\0', /* CB_COLOR5_BASE_EXT (23722) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '6', '_', 'B', 'A', 'S', 'E', '_', 'E', 'X', 'T', '\0', /* CB_COLOR6_BASE_EXT (23741) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '7', '_', 'B', 'A', 'S', 'E', '_', 'E', 'X', 'T', '\0', /* CB_COLOR7_BASE_EXT (23760) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '0', '_', 'C', 'M', 'A', 'S', 'K', '_', 'B', 'A', 'S', 'E', '_', 'E', 'X', 'T', '\0', /* CB_COLOR0_CMASK_BASE_EXT (23779) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '1', '_', 'C', 'M', 'A', 'S', 'K', '_', 'B', 'A', 'S', 'E', '_', 'E', 'X', 'T', '\0', /* CB_COLOR1_CMASK_BASE_EXT (23804) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '2', '_', 'C', 'M', 'A', 'S', 'K', '_', 'B', 'A', 'S', 'E', '_', 'E', 'X', 'T', '\0', /* CB_COLOR2_CMASK_BASE_EXT (23829) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '3', '_', 'C', 'M', 'A', 'S', 'K', '_', 'B', 'A', 'S', 'E', '_', 'E', 'X', 'T', '\0', /* CB_COLOR3_CMASK_BASE_EXT (23854) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '4', '_', 'C', 'M', 'A', 'S', 'K', '_', 'B', 'A', 'S', 'E', '_', 'E', 'X', 'T', '\0', /* CB_COLOR4_CMASK_BASE_EXT (23879) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '5', '_', 'C', 'M', 'A', 'S', 'K', '_', 'B', 'A', 'S', 'E', '_', 'E', 'X', 'T', '\0', /* CB_COLOR5_CMASK_BASE_EXT (23904) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '6', '_', 'C', 'M', 'A', 'S', 'K', '_', 'B', 'A', 'S', 'E', '_', 'E', 'X', 'T', '\0', /* CB_COLOR6_CMASK_BASE_EXT (23929) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '7', '_', 'C', 'M', 'A', 'S', 'K', '_', 'B', 'A', 'S', 'E', '_', 'E', 'X', 'T', '\0', /* CB_COLOR7_CMASK_BASE_EXT (23954) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '0', '_', 'F', 'M', 'A', 'S', 'K', '_', 'B', 'A', 'S', 'E', '_', 'E', 'X', 'T', '\0', /* CB_COLOR0_FMASK_BASE_EXT (23979) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '1', '_', 'F', 'M', 'A', 'S', 'K', '_', 'B', 'A', 'S', 'E', '_', 'E', 'X', 'T', '\0', /* CB_COLOR1_FMASK_BASE_EXT (24004) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '2', '_', 'F', 'M', 'A', 'S', 'K', '_', 'B', 'A', 'S', 'E', '_', 'E', 'X', 'T', '\0', /* CB_COLOR2_FMASK_BASE_EXT (24029) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '3', '_', 'F', 'M', 'A', 'S', 'K', '_', 'B', 'A', 'S', 'E', '_', 'E', 'X', 'T', '\0', /* CB_COLOR3_FMASK_BASE_EXT (24054) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '4', '_', 'F', 'M', 'A', 'S', 'K', '_', 'B', 'A', 'S', 'E', '_', 'E', 'X', 'T', '\0', /* CB_COLOR4_FMASK_BASE_EXT (24079) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '5', '_', 'F', 'M', 'A', 'S', 'K', '_', 'B', 'A', 'S', 'E', '_', 'E', 'X', 'T', '\0', /* CB_COLOR5_FMASK_BASE_EXT (24104) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '6', '_', 'F', 'M', 'A', 'S', 'K', '_', 'B', 'A', 'S', 'E', '_', 'E', 'X', 'T', '\0', /* CB_COLOR6_FMASK_BASE_EXT (24129) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '7', '_', 'F', 'M', 'A', 'S', 'K', '_', 'B', 'A', 'S', 'E', '_', 'E', 'X', 'T', '\0', /* CB_COLOR7_FMASK_BASE_EXT (24154) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '0', '_', 'D', 'C', 'C', '_', 'B', 'A', 'S', 'E', '_', 'E', 'X', 'T', '\0', /* CB_COLOR0_DCC_BASE_EXT (24179) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '1', '_', 'D', 'C', 'C', '_', 'B', 'A', 'S', 'E', '_', 'E', 'X', 'T', '\0', /* CB_COLOR1_DCC_BASE_EXT (24202) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '2', '_', 'D', 'C', 'C', '_', 'B', 'A', 'S', 'E', '_', 'E', 'X', 'T', '\0', /* CB_COLOR2_DCC_BASE_EXT (24225) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '3', '_', 'D', 'C', 'C', '_', 'B', 'A', 'S', 'E', '_', 'E', 'X', 'T', '\0', /* CB_COLOR3_DCC_BASE_EXT (24248) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '4', '_', 'D', 'C', 'C', '_', 'B', 'A', 'S', 'E', '_', 'E', 'X', 'T', '\0', /* CB_COLOR4_DCC_BASE_EXT (24271) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '5', '_', 'D', 'C', 'C', '_', 'B', 'A', 'S', 'E', '_', 'E', 'X', 'T', '\0', /* CB_COLOR5_DCC_BASE_EXT (24294) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '6', '_', 'D', 'C', 'C', '_', 'B', 'A', 'S', 'E', '_', 'E', 'X', 'T', '\0', /* CB_COLOR6_DCC_BASE_EXT (24317) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '7', '_', 'D', 'C', 'C', '_', 'B', 'A', 'S', 'E', '_', 'E', 'X', 'T', '\0', /* CB_COLOR7_DCC_BASE_EXT (24340) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '0', '_', 'A', 'T', 'T', 'R', 'I', 'B', '2', '\0', /* CB_COLOR0_ATTRIB2 (24363) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '1', '_', 'A', 'T', 'T', 'R', 'I', 'B', '2', '\0', /* CB_COLOR1_ATTRIB2 (24381) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '2', '_', 'A', 'T', 'T', 'R', 'I', 'B', '2', '\0', /* CB_COLOR2_ATTRIB2 (24399) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '3', '_', 'A', 'T', 'T', 'R', 'I', 'B', '2', '\0', /* CB_COLOR3_ATTRIB2 (24417) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '4', '_', 'A', 'T', 'T', 'R', 'I', 'B', '2', '\0', /* CB_COLOR4_ATTRIB2 (24435) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '5', '_', 'A', 'T', 'T', 'R', 'I', 'B', '2', '\0', /* CB_COLOR5_ATTRIB2 (24453) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '6', '_', 'A', 'T', 'T', 'R', 'I', 'B', '2', '\0', /* CB_COLOR6_ATTRIB2 (24471) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '7', '_', 'A', 'T', 'T', 'R', 'I', 'B', '2', '\0', /* CB_COLOR7_ATTRIB2 (24489) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '0', '_', 'A', 'T', 'T', 'R', 'I', 'B', '3', '\0', /* CB_COLOR0_ATTRIB3 (24507) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '1', '_', 'A', 'T', 'T', 'R', 'I', 'B', '3', '\0', /* CB_COLOR1_ATTRIB3 (24525) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '2', '_', 'A', 'T', 'T', 'R', 'I', 'B', '3', '\0', /* CB_COLOR2_ATTRIB3 (24543) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '3', '_', 'A', 'T', 'T', 'R', 'I', 'B', '3', '\0', /* CB_COLOR3_ATTRIB3 (24561) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '4', '_', 'A', 'T', 'T', 'R', 'I', 'B', '3', '\0', /* CB_COLOR4_ATTRIB3 (24579) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '5', '_', 'A', 'T', 'T', 'R', 'I', 'B', '3', '\0', /* CB_COLOR5_ATTRIB3 (24597) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '6', '_', 'A', 'T', 'T', 'R', 'I', 'B', '3', '\0', /* CB_COLOR6_ATTRIB3 (24615) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '7', '_', 'A', 'T', 'T', 'R', 'I', 'B', '3', '\0', /* CB_COLOR7_ATTRIB3 (24633) */
	'C', 'P', '_', 'E', 'O', 'P', '_', 'D', 'O', 'N', 'E', '_', 'A', 'D', 'D', 'R', '_', 'L', 'O', '\0', /* CP_EOP_DONE_ADDR_LO (24651) */
	'C', 'P', '_', 'E', 'O', 'P', '_', 'D', 'O', 'N', 'E', '_', 'A', 'D', 'D', 'R', '_', 'H', 'I', '\0', /* CP_EOP_DONE_ADDR_HI (24671) */
	'C', 'P', '_', 'E', 'O', 'P', '_', 'D', 'O', 'N', 'E', '_', 'D', 'A', 'T', 'A', '_', 'L', 'O', '\0', /* CP_EOP_DONE_DATA_LO (24691) */
	'C', 'P', '_', 'E', 'O', 'P', '_', 'D', 'O', 'N', 'E', '_', 'D', 'A', 'T', 'A', '_', 'H', 'I', '\0', /* CP_EOP_DONE_DATA_HI (24711) */
	'C', 'P', '_', 'E', 'O', 'P', '_', 'L', 'A', 'S', 'T', '_', 'F', 'E', 'N', 'C', 'E', '_', 'L', 'O', '\0', /* CP_EOP_LAST_FENCE_LO (24731) */
	'C', 'P', '_', 'E', 'O', 'P', '_', 'L', 'A', 'S', 'T', '_', 'F', 'E', 'N', 'C', 'E', '_', 'H', 'I', '\0', /* CP_EOP_LAST_FENCE_HI (24752) */
	'C', 'P', '_', 'S', 'T', 'R', 'E', 'A', 'M', '_', 'O', 'U', 'T', '_', 'A', 'D', 'D', 'R', '_', 'L', 'O', '\0', /* CP_STREAM_OUT_ADDR_LO (24773, 24776) */
	'C', 'P', '_', 'S', 'T', 'R', 'E', 'A', 'M', '_', 'O', 'U', 'T', '_', 'A', 'D', 'D', 'R', '_', 'H', 'I', '\0', /* CP_STREAM_OUT_ADDR_HI (24795, 24798) */
	'C', 'P', '_', 'N', 'U', 'M', '_', 'P', 'R', 'I', 'M', '_', 'W', 'R', 'I', 'T', 'T', 'E', 'N', '_', 'C', 'O', 'U', 'N', 'T', '0', '_', 'L', 'O', '\0', /* CP_NUM_PRIM_WRITTEN_COUNT0_LO (24817) */
	'C', 'P', '_', 'N', 'U', 'M', '_', 'P', 'R', 'I', 'M', '_', 'W', 'R', 'I', 'T', 'T', 'E', 'N', '_', 'C', 'O', 'U', 'N', 'T', '0', '_', 'H', 'I', '\0', /* CP_NUM_PRIM_WRITTEN_COUNT0_HI (24847) */
	'C', 'P', '_', 'N', 'U', 'M', '_', 'P', 'R', 'I', 'M', '_', 'N', 'E', 'E', 'D', 'E', 'D', '_', 'C', 'O', 'U', 'N', 'T', '0', '_', 'L', 'O', '\0', /* CP_NUM_PRIM_NEEDED_COUNT0_LO (24877) */
	'C', 'P', '_', 'N', 'U', 'M', '_', 'P', 'R', 'I', 'M', '_', 'N', 'E', 'E', 'D', 'E', 'D', '_', 'C', 'O', 'U', 'N', 'T', '0', '_', 'H', 'I', '\0', /* CP_NUM_PRIM_NEEDED_COUNT0_HI (24906) */
	'C', 'P', '_', 'N', 'U', 'M', '_', 'P', 'R', 'I', 'M', '_', 'W', 'R', 'I', 'T', 'T', 'E', 'N', '_', 'C', 'O', 'U', 'N', 'T', '1', '_', 'L', 'O', '\0', /* CP_NUM_PRIM_WRITTEN_COUNT1_LO (24935) */
	'C', 'P', '_', 'N', 'U', 'M', '_', 'P', 'R', 'I', 'M', '_', 'W', 'R', 'I', 'T', 'T', 'E', 'N', '_', 'C', 'O', 'U', 'N', 'T', '1', '_', 'H', 'I', '\0', /* CP_NUM_PRIM_WRITTEN_COUNT1_HI (24965) */
	'C', 'P', '_', 'N', 'U', 'M', '_', 'P', 'R', 'I', 'M', '_', 'N', 'E', 'E', 'D', 'E', 'D', '_', 'C', 'O', 'U', 'N', 'T', '1', '_', 'L', 'O', '\0', /* CP_NUM_PRIM_NEEDED_COUNT1_LO (24995) */
	'C', 'P', '_', 'N', 'U', 'M', '_', 'P', 'R', 'I', 'M', '_', 'N', 'E', 'E', 'D', 'E', 'D', '_', 'C', 'O', 'U', 'N', 'T', '1', '_', 'H', 'I', '\0', /* CP_NUM_PRIM_NEEDED_COUNT1_HI (25024) */
	'C', 'P', '_', 'N', 'U', 'M', '_', 'P', 'R', 'I', 'M', '_', 'W', 'R', 'I', 'T', 'T', 'E', 'N', '_', 'C', 'O', 'U', 'N', 'T', '2', '_', 'L', 'O', '\0', /* CP_NUM_PRIM_WRITTEN_COUNT2_LO (25053) */
	'C', 'P', '_', 'N', 'U', 'M', '_', 'P', 'R', 'I', 'M', '_', 'W', 'R', 'I', 'T', 'T', 'E', 'N', '_', 'C', 'O', 'U', 'N', 'T', '2', '_', 'H', 'I', '\0', /* CP_NUM_PRIM_WRITTEN_COUNT2_HI (25083) */
	'C', 'P', '_', 'N', 'U', 'M', '_', 'P', 'R', 'I', 'M', '_', 'N', 'E', 'E', 'D', 'E', 'D', '_', 'C', 'O', 'U', 'N', 'T', '2', '_', 'L', 'O', '\0', /* CP_NUM_PRIM_NEEDED_COUNT2_LO (25113) */
	'C', 'P', '_', 'N', 'U', 'M', '_', 'P', 'R', 'I', 'M', '_', 'N', 'E', 'E', 'D', 'E', 'D', '_', 'C', 'O', 'U', 'N', 'T', '2', '_', 'H', 'I', '\0', /* CP_NUM_PRIM_NEEDED_COUNT2_HI (25142) */
	'C', 'P', '_', 'N', 'U', 'M', '_', 'P', 'R', 'I', 'M', '_', 'W', 'R', 'I', 'T', 'T', 'E', 'N', '_', 'C', 'O', 'U', 'N', 'T', '3', '_', 'L', 'O', '\0', /* CP_NUM_PRIM_WRITTEN_COUNT3_LO (25171) */
	'C', 'P', '_', 'N', 'U', 'M', '_', 'P', 'R', 'I', 'M', '_', 'W', 'R', 'I', 'T', 'T', 'E', 'N', '_', 'C', 'O', 'U', 'N', 'T', '3', '_', 'H', 'I', '\0', /* CP_NUM_PRIM_WRITTEN_COUNT3_HI (25201) */
	'C', 'P', '_', 'N', 'U', 'M', '_', 'P', 'R', 'I', 'M', '_', 'N', 'E', 'E', 'D', 'E', 'D', '_', 'C', 'O', 'U', 'N', 'T', '3', '_', 'L', 'O', '\0', /* CP_NUM_PRIM_NEEDED_COUNT3_LO (25231) */
	'C', 'P', '_', 'N', 'U', 'M', '_', 'P', 'R', 'I', 'M', '_', 'N', 'E', 'E', 'D', 'E', 'D', '_', 'C', 'O', 'U', 'N', 'T', '3', '_', 'H', 'I', '\0', /* CP_NUM_PRIM_NEEDED_COUNT3_HI (25260) */
	'C', 'P', '_', 'P', 'I', 'P', 'E', '_', 'S', 'T', 'A', 'T', 'S', '_', 'A', 'D', 'D', 'R', '_', 'L', 'O', '\0', /* CP_PIPE_STATS_ADDR_LO (25289, 25292) */
	'C', 'P', '_', 'P', 'I', 'P', 'E', '_', 'S', 'T', 'A', 'T', 'S', '_', 'A', 'D', 'D', 'R', '_', 'H', 'I', '\0', /* CP_PIPE_STATS_ADDR_HI (25311, 25314) */
	'C', 'P', '_', 'V', 'G', 'T', '_', 'I', 'A', 'V', 'E', 'R', 'T', '_', 'C', 'O', 'U', 'N', 'T', '_', 'L', 'O', '\0', /* CP_VGT_IAVERT_COUNT_LO (25333) */
	'C', 'P', '_', 'V', 'G', 'T', '_', 'I', 'A', 'V', 'E', 'R', 'T', '_', 'C', 'O', 'U', 'N', 'T', '_', 'H', 'I', '\0', /* CP_VGT_IAVERT_COUNT_HI (25356, 25370) */
	'C', 'P', '_', 'V', 'G', 'T', '_', 'I', 'A', 'P', 'R', 'I', 'M', '_', 'C', 'O', 'U', 'N', 'T', '_', 'L', 'O', '\0', /* CP_VGT_IAPRIM_COUNT_LO (25379) */
	'C', 'P', '_', 'V', 'G', 'T', '_', 'I', 'A', 'P', 'R', 'I', 'M', '_', 'C', 'O', 'U', 'N', 'T', '_', 'H', 'I', '\0', /* CP_VGT_IAPRIM_COUNT_HI (25402) */
	'C', 'P', '_', 'V', 'G', 'T', '_', 'G', 'S', 'P', 'R', 'I', 'M', '_', 'C', 'O', 'U', 'N', 'T', '_', 'L', 'O', '\0', /* CP_VGT_GSPRIM_COUNT_LO (25425) */
	'C', 'P', '_', 'V', 'G', 'T', '_', 'G', 'S', 'P', 'R', 'I', 'M', '_', 'C', 'O', 'U', 'N', 'T', '_', 'H', 'I', '\0', /* CP_VGT_GSPRIM_COUNT_HI (25448) */
	'C', 'P', '_', 'V', 'G', 'T', '_', 'V', 'S', 'I', 'N', 'V', 'O', 'C', '_', 'C', 'O', 'U', 'N', 'T', '_', 'L', 'O', '\0', /* CP_VGT_VSINVOC_COUNT_LO (25471) */
	'C', 'P', '_', 'V', 'G', 'T', '_', 'V', 'S', 'I', 'N', 'V', 'O', 'C', '_', 'C', 'O', 'U', 'N', 'T', '_', 'H', 'I', '\0', /* CP_VGT_VSINVOC_COUNT_HI (25495) */
	'C', 'P', '_', 'V', 'G', 'T', '_', 'G', 'S', 'I', 'N', 'V', 'O', 'C', '_', 'C', 'O', 'U', 'N', 'T', '_', 'L', 'O', '\0', /* CP_VGT_GSINVOC_COUNT_LO (25519) */
	'C', 'P', '_', 'V', 'G', 'T', '_', 'G', 'S', 'I', 'N', 'V', 'O', 'C', '_', 'C', 'O', 'U', 'N', 'T', '_', 'H', 'I', '\0', /* CP_VGT_GSINVOC_COUNT_HI (25543) */
	'C', 'P', '_', 'V', 'G', 'T', '_', 'H', 'S', 'I', 'N', 'V', 'O', 'C', '_', 'C', 'O', 'U', 'N', 'T', '_', 'L', 'O', '\0', /* CP_VGT_HSINVOC_COUNT_LO (25567) */
	'C', 'P', '_', 'V', 'G', 'T', '_', 'H', 'S', 'I', 'N', 'V', 'O', 'C', '_', 'C', 'O', 'U', 'N', 'T', '_', 'H', 'I', '\0', /* CP_VGT_HSINVOC_COUNT_HI (25591) */
	'C', 'P', '_', 'V', 'G', 'T', '_', 'D', 'S', 'I', 'N', 'V', 'O', 'C', '_', 'C', 'O', 'U', 'N', 'T', '_', 'L', 'O', '\0', /* CP_VGT_DSINVOC_COUNT_LO (25615) */
	'C', 'P', '_', 'V', 'G', 'T', '_', 'D', 'S', 'I', 'N', 'V', 'O', 'C', '_', 'C', 'O', 'U', 'N', 'T', '_', 'H', 'I', '\0', /* CP_VGT_DSINVOC_COUNT_HI (25639) */
	'C', 'P', '_', 'P', 'A', '_', 'C', 'I', 'N', 'V', 'O', 'C', '_', 'C', 'O', 'U', 'N', 'T', '_', 'L', 'O', '\0', /* CP_PA_CINVOC_COUNT_LO (25663) */
	'C', 'P', '_', 'P', 'A', '_', 'C', 'I', 'N', 'V', 'O', 'C', '_', 'C', 'O', 'U', 'N', 'T', '_', 'H', 'I', '\0', /* CP_PA_CINVOC_COUNT_HI (25685) */
	'C', 'P', '_', 'P', 'A', '_', 'C', 'P', 'R', 'I', 'M', '_', 'C', 'O', 'U', 'N', 'T', '_', 'L', 'O', '\0', /* CP_PA_CPRIM_COUNT_LO (25707) */
	'C', 'P', '_', 'P', 'A', '_', 'C', 'P', 'R', 'I', 'M', '_', 'C', 'O', 'U', 'N', 'T', '_', 'H', 'I', '\0', /* CP_PA_CPRIM_COUNT_HI (25728) */
	'C', 'P', '_', 'S', 'C', '_', 'P', 'S', 'I', 'N', 'V', 'O', 'C', '_', 'C', 'O', 'U', 'N', 'T', '0', '_', 'L', 'O', '\0', /* CP_SC_PSINVOC_COUNT0_LO (25749) */
	'C', 'P', '_', 'S', 'C', '_', 'P', 'S', 'I', 'N', 'V', 'O', 'C', '_', 'C', 'O', 'U', 'N', 'T', '0', '_', 'H', 'I', '\0', /* CP_SC_PSINVOC_COUNT0_HI (25773) */
	'C', 'P', '_', 'S', 'C', '_', 'P', 'S', 'I', 'N', 'V', 'O', 'C', '_', 'C', 'O', 'U', 'N', 'T', '1', '_', 'L', 'O', '\0', /* CP_SC_PSINVOC_COUNT1_LO (25797) */
	'C', 'P', '_', 'S', 'C', '_', 'P', 'S', 'I', 'N', 'V', 'O', 'C', '_', 'C', 'O', 'U', 'N', 'T', '1', '_', 'H', 'I', '\0', /* CP_SC_PSINVOC_COUNT1_HI (25821) */
	'C', 'P', '_', 'V', 'G', 'T', '_', 'C', 'S', 'I', 'N', 'V', 'O', 'C', '_', 'C', 'O', 'U', 'N', 'T', '_', 'L', 'O', '\0', /* CP_VGT_CSINVOC_COUNT_LO (25845) */
	'C', 'P', '_', 'V', 'G', 'T', '_', 'C', 'S', 'I', 'N', 'V', 'O', 'C', '_', 'C', 'O', 'U', 'N', 'T', '_', 'H', 'I', '\0', /* CP_VGT_CSINVOC_COUNT_HI (25869) */
	'C', 'P', '_', 'E', 'O', 'P', '_', 'D', 'O', 'N', 'E', '_', 'D', 'O', 'O', 'R', 'B', 'E', 'L', 'L', '\0', /* CP_EOP_DONE_DOORBELL (25893) */
	'C', 'P', '_', 'S', 'T', 'R', 'E', 'A', 'M', '_', 'O', 'U', 'T', '_', 'D', 'O', 'O', 'R', 'B', 'E', 'L', 'L', '\0', /* CP_STREAM_OUT_DOORBELL (25914) */
	'C', 'P', '_', 'S', 'E', 'M', '_', 'D', 'O', 'O', 'R', 'B', 'E', 'L', 'L', '\0', /* CP_SEM_DOORBELL (25937) */
	'C', 'P', '_', 'P', 'I', 'P', 'E', '_', 'S', 'T', 'A', 'T', 'S', '_', 'C', 'O', 'N', 'T', 'R', 'O', 'L', '\0', /* CP_PIPE_STATS_CONTROL (25953) */
	'C', 'P', '_', 'S', 'T', 'R', 'E', 'A', 'M', '_', 'O', 'U', 'T', '_', 'C', 'O', 'N', 'T', 'R', 'O', 'L', '\0', /* CP_STREAM_OUT_CONTROL (25975) */
	'C', 'P', '_', 'S', 'T', 'R', 'M', 'O', 'U', 'T', '_', 'C', 'N', 'T', 'L', '\0', /* CP_STRMOUT_CNTL (25997) */
	'S', 'C', 'R', 'A', 'T', 'C', 'H', '_', 'R', 'E', 'G', '0', '\0', /* SCRATCH_REG0 (26013) */
	'S', 'C', 'R', 'A', 'T', 'C', 'H', '_', 'R', 'E', 'G', '1', '\0', /* SCRATCH_REG1 (26026) */
	'S', 'C', 'R', 'A', 'T', 'C', 'H', '_', 'R', 'E', 'G', '2', '\0', /* SCRATCH_REG2 (26039) */
	'S', 'C', 'R', 'A', 'T', 'C', 'H', '_', 'R', 'E', 'G', '3', '\0', /* SCRATCH_REG3 (26052) */
	'S', 'C', 'R', 'A', 'T', 'C', 'H', '_', 'R', 'E', 'G', '4', '\0', /* SCRATCH_REG4 (26065) */
	'S', 'C', 'R', 'A', 'T', 'C', 'H', '_', 'R', 'E', 'G', '5', '\0', /* SCRATCH_REG5 (26078) */
	'S', 'C', 'R', 'A', 'T', 'C', 'H', '_', 'R', 'E', 'G', '6', '\0', /* SCRATCH_REG6 (26091) */
	'S', 'C', 'R', 'A', 'T', 'C', 'H', '_', 'R', 'E', 'G', '7', '\0', /* SCRATCH_REG7 (26104) */
	'C', 'P', '_', 'P', 'I', 'P', 'E', '_', 'S', 'T', 'A', 'T', 'S', '_', 'D', 'O', 'O', 'R', 'B', 'E', 'L', 'L', '\0', /* CP_PIPE_STATS_DOORBELL (26117) */
	'C', 'P', '_', 'A', 'P', 'P', 'E', 'N', 'D', '_', 'D', 'D', 'I', 'D', '_', 'C', 'N', 'T', '\0', /* CP_APPEND_DDID_CNT (26140) */
	'C', 'P', '_', 'A', 'P', 'P', 'E', 'N', 'D', '_', 'D', 'A', 'T', 'A', '_', 'H', 'I', '\0', /* CP_APPEND_DATA_HI (26159) */
	'C', 'P', '_', 'A', 'P', 'P', 'E', 'N', 'D', '_', 'L', 'A', 'S', 'T', '_', 'C', 'S', '_', 'F', 'E', 'N', 'C', 'E', '_', 'H', 'I', '\0', /* CP_APPEND_LAST_CS_FENCE_HI (26177) */
	'C', 'P', '_', 'A', 'P', 'P', 'E', 'N', 'D', '_', 'L', 'A', 'S', 'T', '_', 'P', 'S', '_', 'F', 'E', 'N', 'C', 'E', '_', 'H', 'I', '\0', /* CP_APPEND_LAST_PS_FENCE_HI (26204) */
	'S', 'C', 'R', 'A', 'T', 'C', 'H', '_', 'U', 'M', 'S', 'K', '\0', /* SCRATCH_UMSK (26231) */
	'S', 'C', 'R', 'A', 'T', 'C', 'H', '_', 'A', 'D', 'D', 'R', '\0', /* SCRATCH_ADDR (26244) */
	'C', 'P', '_', 'P', 'F', 'P', '_', 'A', 'T', 'O', 'M', 'I', 'C', '_', 'P', 'R', 'E', 'O', 'P', '_', 'L', 'O', '\0', /* CP_PFP_ATOMIC_PREOP_LO (26257) */
	'C', 'P', '_', 'P', 'F', 'P', '_', 'A', 'T', 'O', 'M', 'I', 'C', '_', 'P', 'R', 'E', 'O', 'P', '_', 'H', 'I', '\0', /* CP_PFP_ATOMIC_PREOP_HI (26280) */
	'C', 'P', '_', 'P', 'F', 'P', '_', 'G', 'D', 'S', '_', 'A', 'T', 'O', 'M', 'I', 'C', '0', '_', 'P', 'R', 'E', 'O', 'P', '_', 'L', 'O', '\0', /* CP_PFP_GDS_ATOMIC0_PREOP_LO (26303) */
	'C', 'P', '_', 'P', 'F', 'P', '_', 'G', 'D', 'S', '_', 'A', 'T', 'O', 'M', 'I', 'C', '0', '_', 'P', 'R', 'E', 'O', 'P', '_', 'H', 'I', '\0', /* CP_PFP_GDS_ATOMIC0_PREOP_HI (26331) */
	'C', 'P', '_', 'P', 'F', 'P', '_', 'G', 'D', 'S', '_', 'A', 'T', 'O', 'M', 'I', 'C', '1', '_', 'P', 'R', 'E', 'O', 'P', '_', 'L', 'O', '\0', /* CP_PFP_GDS_ATOMIC1_PREOP_LO (26359) */
	'C', 'P', '_', 'P', 'F', 'P', '_', 'G', 'D', 'S', '_', 'A', 'T', 'O', 'M', 'I', 'C', '1', '_', 'P', 'R', 'E', 'O', 'P', '_', 'H', 'I', '\0', /* CP_PFP_GDS_ATOMIC1_PREOP_HI (26387) */
	'C', 'P', '_', 'A', 'P', 'P', 'E', 'N', 'D', '_', 'A', 'D', 'D', 'R', '_', 'L', 'O', '\0', /* CP_APPEND_ADDR_LO (26415) */
	'C', 'P', '_', 'A', 'P', 'P', 'E', 'N', 'D', '_', 'A', 'D', 'D', 'R', '_', 'H', 'I', '\0', /* CP_APPEND_ADDR_HI (26433) */
	'C', 'P', '_', 'A', 'P', 'P', 'E', 'N', 'D', '_', 'D', 'A', 'T', 'A', '\0', /* CP_APPEND_DATA (26451) */
	'C', 'P', '_', 'A', 'P', 'P', 'E', 'N', 'D', '_', 'L', 'A', 'S', 'T', '_', 'C', 'S', '_', 'F', 'E', 'N', 'C', 'E', '\0', /* CP_APPEND_LAST_CS_FENCE (26466) */
	'C', 'P', '_', 'A', 'P', 'P', 'E', 'N', 'D', '_', 'L', 'A', 'S', 'T', '_', 'P', 'S', '_', 'F', 'E', 'N', 'C', 'E', '\0', /* CP_APPEND_LAST_PS_FENCE (26490) */
	'C', 'P', '_', 'A', 'T', 'O', 'M', 'I', 'C', '_', 'P', 'R', 'E', 'O', 'P', '_', 'L', 'O', '\0', /* CP_ATOMIC_PREOP_LO (26514) */
	'C', 'P', '_', 'A', 'T', 'O', 'M', 'I', 'C', '_', 'P', 'R', 'E', 'O', 'P', '_', 'H', 'I', '\0', /* CP_ATOMIC_PREOP_HI (26533) */
	'C', 'P', '_', 'G', 'D', 'S', '_', 'A', 'T', 'O', 'M', 'I', 'C', '0', '_', 'P', 'R', 'E', 'O', 'P', '_', 'L', 'O', '\0', /* CP_GDS_ATOMIC0_PREOP_LO (26552) */
	'C', 'P', '_', 'G', 'D', 'S', '_', 'A', 'T', 'O', 'M', 'I', 'C', '0', '_', 'P', 'R', 'E', 'O', 'P', '_', 'H', 'I', '\0', /* CP_GDS_ATOMIC0_PREOP_HI (26576) */
	'C', 'P', '_', 'G', 'D', 'S', '_', 'A', 'T', 'O', 'M', 'I', 'C', '1', '_', 'P', 'R', 'E', 'O', 'P', '_', 'L', 'O', '\0', /* CP_GDS_ATOMIC1_PREOP_LO (26600) */
	'C', 'P', '_', 'G', 'D', 'S', '_', 'A', 'T', 'O', 'M', 'I', 'C', '1', '_', 'P', 'R', 'E', 'O', 'P', '_', 'H', 'I', '\0', /* CP_GDS_ATOMIC1_PREOP_HI (26624) */
	'C', 'P', '_', 'M', 'E', '_', 'M', 'C', '_', 'W', 'A', 'D', 'D', 'R', '_', 'L', 'O', '\0', /* CP_ME_MC_WADDR_LO (26648, 26651) */
	'C', 'P', '_', 'M', 'E', '_', 'M', 'C', '_', 'W', 'A', 'D', 'D', 'R', '_', 'H', 'I', '\0', /* CP_ME_MC_WADDR_HI (26666, 26669) */
	'C', 'P', '_', 'M', 'E', '_', 'M', 'C', '_', 'W', 'D', 'A', 'T', 'A', '_', 'L', 'O', '\0', /* CP_ME_MC_WDATA_LO (26684) */
	'C', 'P', '_', 'M', 'E', '_', 'M', 'C', '_', 'W', 'D', 'A', 'T', 'A', '_', 'H', 'I', '\0', /* CP_ME_MC_WDATA_HI (26702) */
	'C', 'P', '_', 'M', 'E', '_', 'M', 'C', '_', 'R', 'A', 'D', 'D', 'R', '_', 'L', 'O', '\0', /* CP_ME_MC_RADDR_LO (26720, 26723) */
	'C', 'P', '_', 'M', 'E', '_', 'M', 'C', '_', 'R', 'A', 'D', 'D', 'R', '_', 'H', 'I', '\0', /* CP_ME_MC_RADDR_HI (26738, 26741) */
	'C', 'P', '_', 'S', 'E', 'M', '_', 'W', 'A', 'I', 'T', '_', 'T', 'I', 'M', 'E', 'R', '\0', /* CP_SEM_WAIT_TIMER (26756) */
	'C', 'P', '_', 'S', 'I', 'G', '_', 'S', 'E', 'M', '_', 'A', 'D', 'D', 'R', '_', 'L', 'O', '\0', /* CP_SIG_SEM_ADDR_LO (26774, 26781) */
	'C', 'P', '_', 'S', 'I', 'G', '_', 'S', 'E', 'M', '_', 'A', 'D', 'D', 'R', '_', 'H', 'I', '\0', /* CP_SIG_SEM_ADDR_HI (26793, 26800) */
	'C', 'P', '_', 'W', 'A', 'I', 'T', '_', 'R', 'E', 'G', '_', 'M', 'E', 'M', '_', 'T', 'I', 'M', 'E', 'O', 'U', 'T', '\0', /* CP_WAIT_REG_MEM_TIMEOUT (26812) */
	'C', 'P', '_', 'W', 'A', 'I', 'T', '_', 'S', 'E', 'M', '_', 'A', 'D', 'D', 'R', '_', 'L', 'O', '\0', /* CP_WAIT_SEM_ADDR_LO (26836) */
	'C', 'P', '_', 'W', 'A', 'I', 'T', '_', 'S', 'E', 'M', '_', 'A', 'D', 'D', 'R', '_', 'H', 'I', '\0', /* CP_WAIT_SEM_ADDR_HI (26856) */
	'C', 'P', '_', 'D', 'M', 'A', '_', 'P', 'F', 'P', '_', 'C', 'O', 'N', 'T', 'R', 'O', 'L', '\0', /* CP_DMA_PFP_CONTROL (26876) */
	'C', 'P', '_', 'D', 'M', 'A', '_', 'M', 'E', '_', 'C', 'O', 'N', 'T', 'R', 'O', 'L', '\0', /* CP_DMA_ME_CONTROL (26895) */
	'C', 'P', '_', 'C', 'O', 'H', 'E', 'R', '_', 'B', 'A', 'S', 'E', '_', 'H', 'I', '\0', /* CP_COHER_BASE_HI (26913) */
	'C', 'P', '_', 'C', 'O', 'H', 'E', 'R', '_', 'S', 'T', 'A', 'R', 'T', '_', 'D', 'E', 'L', 'A', 'Y', '\0', /* CP_COHER_START_DELAY (26930) */
	'C', 'P', '_', 'C', 'O', 'H', 'E', 'R', '_', 'C', 'N', 'T', 'L', '\0', /* CP_COHER_CNTL (26951) */
	'C', 'P', '_', 'C', 'O', 'H', 'E', 'R', '_', 'S', 'I', 'Z', 'E', '\0', /* CP_COHER_SIZE (26965) */
	'C', 'P', '_', 'C', 'O', 'H', 'E', 'R', '_', 'B', 'A', 'S', 'E', '\0', /* CP_COHER_BASE (26979) */
	'C', 'P', '_', 'C', 'O', 'H', 'E', 'R', '_', 'S', 'T', 'A', 'T', 'U', 'S', '\0', /* CP_COHER_STATUS (26993) */
	'C', 'P', '_', 'D', 'M', 'A', '_', 'M', 'E', '_', 'S', 'R', 'C', '_', 'A', 'D', 'D', 'R', '\0', /* CP_DMA_ME_SRC_ADDR (27009, 27019) */
	'C', 'P', '_', 'D', 'M', 'A', '_', 'M', 'E', '_', 'S', 'R', 'C', '_', 'A', 'D', 'D', 'R', '_', 'H', 'I', '\0', /* CP_DMA_ME_SRC_ADDR_HI (27028, 27038) */
	'C', 'P', '_', 'D', 'M', 'A', '_', 'M', 'E', '_', 'D', 'S', 'T', '_', 'A', 'D', 'D', 'R', '\0', /* CP_DMA_ME_DST_ADDR (27050, 27060) */
	'C', 'P', '_', 'D', 'M', 'A', '_', 'M', 'E', '_', 'D', 'S', 'T', '_', 'A', 'D', 'D', 'R', '_', 'H', 'I', '\0', /* CP_DMA_ME_DST_ADDR_HI (27069, 27079) */
	'C', 'P', '_', 'D', 'M', 'A', '_', 'M', 'E', '_', 'C', 'O', 'M', 'M', 'A', 'N', 'D', '\0', /* CP_DMA_ME_COMMAND (27091, 27101) */
	'C', 'P', '_', 'D', 'M', 'A', '_', 'P', 'F', 'P', '_', 'S', 'R', 'C', '_', 'A', 'D', 'D', 'R', '\0', /* CP_DMA_PFP_SRC_ADDR (27109) */
	'C', 'P', '_', 'D', 'M', 'A', '_', 'P', 'F', 'P', '_', 'S', 'R', 'C', '_', 'A', 'D', 'D', 'R', '_', 'H', 'I', '\0', /* CP_DMA_PFP_SRC_ADDR_HI (27129) */
	'C', 'P', '_', 'D', 'M', 'A', '_', 'P', 'F', 'P', '_', 'D', 'S', 'T', '_', 'A', 'D', 'D', 'R', '\0', /* CP_DMA_PFP_DST_ADDR (27152) */
	'C', 'P', '_', 'D', 'M', 'A', '_', 'P', 'F', 'P', '_', 'D', 'S', 'T', '_', 'A', 'D', 'D', 'R', '_', 'H', 'I', '\0', /* CP_DMA_PFP_DST_ADDR_HI (27172) */
	'C', 'P', '_', 'D', 'M', 'A', '_', 'P', 'F', 'P', '_', 'C', 'O', 'M', 'M', 'A', 'N', 'D', '\0', /* CP_DMA_PFP_COMMAND (27195) */
	'C', 'P', '_', 'D', 'M', 'A', '_', 'C', 'N', 'T', 'L', '\0', /* CP_DMA_CNTL (27214) */
	'C', 'P', '_', 'D', 'M', 'A', '_', 'R', 'E', 'A', 'D', '_', 'T', 'A', 'G', 'S', '\0', /* CP_DMA_READ_TAGS (27226) */
	'C', 'P', '_', 'C', 'O', 'H', 'E', 'R', '_', 'S', 'I', 'Z', 'E', '_', 'H', 'I', '\0', /* CP_COHER_SIZE_HI (27243) */
	'C', 'P', '_', 'P', 'F', 'P', '_', 'I', 'B', '_', 'C', 'O', 'N', 'T', 'R', 'O', 'L', '\0', /* CP_PFP_IB_CONTROL (27260, 27267) */
	'C', 'P', '_', 'P', 'F', 'P', '_', 'L', 'O', 'A', 'D', '_', 'C', 'O', 'N', 'T', 'R', 'O', 'L', '\0', /* CP_PFP_LOAD_CONTROL (27278) */
	'C', 'P', '_', 'S', 'C', 'R', 'A', 'T', 'C', 'H', '_', 'I', 'N', 'D', 'E', 'X', '\0', /* CP_SCRATCH_INDEX (27298) */
	'C', 'P', '_', 'S', 'C', 'R', 'A', 'T', 'C', 'H', '_', 'D', 'A', 'T', 'A', '\0', /* CP_SCRATCH_DATA (27315) */
	'C', 'P', '_', 'R', 'B', '_', 'O', 'F', 'F', 'S', 'E', 'T', '\0', /* CP_RB_OFFSET (27331, 27334) */
	'C', 'P', '_', 'I', 'B', '1', '_', 'O', 'F', 'F', 'S', 'E', 'T', '\0', /* CP_IB1_OFFSET (27344, 27347) */
	'C', 'P', '_', 'I', 'B', '2', '_', 'O', 'F', 'F', 'S', 'E', 'T', '\0', /* CP_IB2_OFFSET (27358, 27361) */
	'C', 'P', '_', 'I', 'B', '1', '_', 'P', 'R', 'E', 'A', 'M', 'B', 'L', 'E', '_', 'B', 'E', 'G', 'I', 'N', '\0', /* CP_IB1_PREAMBLE_BEGIN (27372, 27375) */
	'C', 'P', '_', 'I', 'B', '1', '_', 'P', 'R', 'E', 'A', 'M', 'B', 'L', 'E', '_', 'E', 'N', 'D', '\0', /* CP_IB1_PREAMBLE_END (27394, 27397) */
	'C', 'P', '_', 'I', 'B', '2', '_', 'P', 'R', 'E', 'A', 'M', 'B', 'L', 'E', '_', 'B', 'E', 'G', 'I', 'N', '\0', /* CP_IB2_PREAMBLE_BEGIN (27414, 27417) */
	'C', 'P', '_', 'I', 'B', '2', '_', 'P', 'R', 'E', 'A', 'M', 'B', 'L', 'E', '_', 'E', 'N', 'D', '\0', /* CP_IB2_PREAMBLE_END (27436, 27439) */
	'C', 'P', '_', 'C', 'E', '_', 'I', 'B', '1', '_', 'O', 'F', 'F', 'S', 'E', 'T', '\0', /* CP_CE_IB1_OFFSET (27456) */
	'C', 'P', '_', 'C', 'E', '_', 'I', 'B', '2', '_', 'O', 'F', 'F', 'S', 'E', 'T', '\0', /* CP_CE_IB2_OFFSET (27473) */
	'C', 'P', '_', 'C', 'E', '_', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '\0', /* CP_CE_COUNTER (27490) */
	'C', 'P', '_', 'D', 'M', 'A', '_', 'M', 'E', '_', 'C', 'M', 'D', '_', 'A', 'D', 'D', 'R', '_', 'L', 'O', '\0', /* CP_DMA_ME_CMD_ADDR_LO (27504) */
	'C', 'P', '_', 'D', 'M', 'A', '_', 'M', 'E', '_', 'C', 'M', 'D', '_', 'A', 'D', 'D', 'R', '_', 'H', 'I', '\0', /* CP_DMA_ME_CMD_ADDR_HI (27526) */
	'C', 'P', '_', 'D', 'M', 'A', '_', 'P', 'F', 'P', '_', 'C', 'M', 'D', '_', 'A', 'D', 'D', 'R', '_', 'L', 'O', '\0', /* CP_DMA_PFP_CMD_ADDR_LO (27548) */
	'C', 'P', '_', 'D', 'M', 'A', '_', 'P', 'F', 'P', '_', 'C', 'M', 'D', '_', 'A', 'D', 'D', 'R', '_', 'H', 'I', '\0', /* CP_DMA_PFP_CMD_ADDR_HI (27571) */
	'C', 'P', '_', 'A', 'P', 'P', 'E', 'N', 'D', '_', 'C', 'M', 'D', '_', 'A', 'D', 'D', 'R', '_', 'L', 'O', '\0', /* CP_APPEND_CMD_ADDR_LO (27594) */
	'C', 'P', '_', 'A', 'P', 'P', 'E', 'N', 'D', '_', 'C', 'M', 'D', '_', 'A', 'D', 'D', 'R', '_', 'H', 'I', '\0', /* CP_APPEND_CMD_ADDR_HI (27616) */
	'C', 'P', '_', 'C', 'E', '_', 'I', 'N', 'I', 'T', '_', 'C', 'M', 'D', '_', 'B', 'U', 'F', 'S', 'Z', '\0', /* CP_CE_INIT_CMD_BUFSZ (27638) */
	'C', 'P', '_', 'C', 'E', '_', 'I', 'B', '1', '_', 'C', 'M', 'D', '_', 'B', 'U', 'F', 'S', 'Z', '\0', /* CP_CE_IB1_CMD_BUFSZ (27659) */
	'C', 'P', '_', 'C', 'E', '_', 'I', 'B', '2', '_', 'C', 'M', 'D', '_', 'B', 'U', 'F', 'S', 'Z', '\0', /* CP_CE_IB2_CMD_BUFSZ (27679) */
	'C', 'P', '_', 'I', 'B', '1', '_', 'C', 'M', 'D', '_', 'B', 'U', 'F', 'S', 'Z', '\0', /* CP_IB1_CMD_BUFSZ (27699) */
	'C', 'P', '_', 'I', 'B', '2', '_', 'C', 'M', 'D', '_', 'B', 'U', 'F', 'S', 'Z', '\0', /* CP_IB2_CMD_BUFSZ (27716) */
	'C', 'P', '_', 'S', 'T', '_', 'C', 'M', 'D', '_', 'B', 'U', 'F', 'S', 'Z', '\0', /* CP_ST_CMD_BUFSZ (27733) */
	'C', 'P', '_', 'C', 'E', '_', 'I', 'N', 'I', 'T', '_', 'B', 'A', 'S', 'E', '_', 'L', 'O', '\0', /* CP_CE_INIT_BASE_LO (27749, 27755) */
	'C', 'P', '_', 'C', 'E', '_', 'I', 'N', 'I', 'T', '_', 'B', 'A', 'S', 'E', '_', 'H', 'I', '\0', /* CP_CE_INIT_BASE_HI (27768, 27774) */
	'C', 'P', '_', 'C', 'E', '_', 'I', 'N', 'I', 'T', '_', 'B', 'U', 'F', 'S', 'Z', '\0', /* CP_CE_INIT_BUFSZ (27787, 27793) */
	'C', 'P', '_', 'C', 'E', '_', 'I', 'B', '1', '_', 'B', 'A', 'S', 'E', '_', 'L', 'O', '\0', /* CP_CE_IB1_BASE_LO (27804, 27810) */
	'C', 'P', '_', 'C', 'E', '_', 'I', 'B', '1', '_', 'B', 'A', 'S', 'E', '_', 'H', 'I', '\0', /* CP_CE_IB1_BASE_HI (27822, 27828) */
	'C', 'P', '_', 'C', 'E', '_', 'I', 'B', '1', '_', 'B', 'U', 'F', 'S', 'Z', '\0', /* CP_CE_IB1_BUFSZ (27840, 27846) */
	'C', 'P', '_', 'C', 'E', '_', 'I', 'B', '2', '_', 'B', 'A', 'S', 'E', '_', 'L', 'O', '\0', /* CP_CE_IB2_BASE_LO (27856, 27862) */
	'C', 'P', '_', 'C', 'E', '_', 'I', 'B', '2', '_', 'B', 'A', 'S', 'E', '_', 'H', 'I', '\0', /* CP_CE_IB2_BASE_HI (27874, 27880) */
	'C', 'P', '_', 'C', 'E', '_', 'I', 'B', '2', '_', 'B', 'U', 'F', 'S', 'Z', '\0', /* CP_CE_IB2_BUFSZ (27892, 27898) */
	'C', 'P', '_', 'I', 'B', '1', '_', 'B', 'A', 'S', 'E', '_', 'L', 'O', '\0', /* CP_IB1_BASE_LO (27908) */
	'C', 'P', '_', 'I', 'B', '1', '_', 'B', 'A', 'S', 'E', '_', 'H', 'I', '\0', /* CP_IB1_BASE_HI (27923) */
	'C', 'P', '_', 'I', 'B', '1', '_', 'B', 'U', 'F', 'S', 'Z', '\0', /* CP_IB1_BUFSZ (27938) */
	'C', 'P', '_', 'I', 'B', '2', '_', 'B', 'A', 'S', 'E', '_', 'L', 'O', '\0', /* CP_IB2_BASE_LO (27951) */
	'C', 'P', '_', 'I', 'B', '2', '_', 'B', 'A', 'S', 'E', '_', 'H', 'I', '\0', /* CP_IB2_BASE_HI (27966) */
	'C', 'P', '_', 'I', 'B', '2', '_', 'B', 'U', 'F', 'S', 'Z', '\0', /* CP_IB2_BUFSZ (27981) */
	'C', 'P', '_', 'S', 'T', '_', 'B', 'A', 'S', 'E', '_', 'L', 'O', '\0', /* CP_ST_BASE_LO (27994, 27997) */
	'C', 'P', '_', 'S', 'T', '_', 'B', 'A', 'S', 'E', '_', 'H', 'I', '\0', /* CP_ST_BASE_HI (28008, 28011) */
	'C', 'P', '_', 'S', 'T', '_', 'B', 'U', 'F', 'S', 'Z', '\0', /* CP_ST_BUFSZ (28022, 28025) */
	'C', 'P', '_', 'E', 'O', 'P', '_', 'D', 'O', 'N', 'E', '_', 'E', 'V', 'E', 'N', 'T', '_', 'C', 'N', 'T', 'L', '\0', /* CP_EOP_DONE_EVENT_CNTL (28034) */
	'C', 'P', '_', 'E', 'O', 'P', '_', 'D', 'O', 'N', 'E', '_', 'D', 'A', 'T', 'A', '_', 'C', 'N', 'T', 'L', '\0', /* CP_EOP_DONE_DATA_CNTL (28057) */
	'C', 'P', '_', 'E', 'O', 'P', '_', 'D', 'O', 'N', 'E', '_', 'C', 'N', 'T', 'X', '_', 'I', 'D', '\0', /* CP_EOP_DONE_CNTX_ID (28079, 28091) */
	'C', 'P', '_', 'D', 'B', '_', 'B', 'A', 'S', 'E', '_', 'L', 'O', '\0', /* CP_DB_BASE_LO (28099, 28102) */
	'C', 'P', '_', 'D', 'B', '_', 'B', 'A', 'S', 'E', '_', 'H', 'I', '\0', /* CP_DB_BASE_HI (28113, 28116) */
	'C', 'P', '_', 'D', 'B', '_', 'B', 'U', 'F', 'S', 'Z', '\0', /* CP_DB_BUFSZ (28127, 28130) */
	'C', 'P', '_', 'D', 'B', '_', 'C', 'M', 'D', '_', 'B', 'U', 'F', 'S', 'Z', '\0', /* CP_DB_CMD_BUFSZ (28139) */
	'C', 'P', '_', 'C', 'E', '_', 'D', 'B', '_', 'B', 'A', 'S', 'E', '_', 'L', 'O', '\0', /* CP_CE_DB_BASE_LO (28155) */
	'C', 'P', '_', 'C', 'E', '_', 'D', 'B', '_', 'B', 'A', 'S', 'E', '_', 'H', 'I', '\0', /* CP_CE_DB_BASE_HI (28172) */
	'C', 'P', '_', 'C', 'E', '_', 'D', 'B', '_', 'B', 'U', 'F', 'S', 'Z', '\0', /* CP_CE_DB_BUFSZ (28189) */
	'C', 'P', '_', 'C', 'E', '_', 'D', 'B', '_', 'C', 'M', 'D', '_', 'B', 'U', 'F', 'S', 'Z', '\0', /* CP_CE_DB_CMD_BUFSZ (28204) */
	'C', 'P', '_', 'P', 'F', 'P', '_', 'C', 'O', 'M', 'P', 'L', 'E', 'T', 'I', 'O', 'N', '_', 'S', 'T', 'A', 'T', 'U', 'S', '\0', /* CP_PFP_COMPLETION_STATUS (28223) */
	'C', 'P', '_', 'C', 'E', '_', 'C', 'O', 'M', 'P', 'L', 'E', 'T', 'I', 'O', 'N', '_', 'S', 'T', 'A', 'T', 'U', 'S', '\0', /* CP_CE_COMPLETION_STATUS (28248) */
	'C', 'P', '_', 'P', 'R', 'E', 'D', '_', 'N', 'O', 'T', '_', 'V', 'I', 'S', 'I', 'B', 'L', 'E', '\0', /* CP_PRED_NOT_VISIBLE (28272, 28280) */
	'C', 'P', '_', 'P', 'F', 'P', '_', 'M', 'E', 'T', 'A', 'D', 'A', 'T', 'A', '_', 'B', 'A', 'S', 'E', '_', 'A', 'D', 'D', 'R', '\0', /* CP_PFP_METADATA_BASE_ADDR (28292) */
	'C', 'P', '_', 'P', 'F', 'P', '_', 'M', 'E', 'T', 'A', 'D', 'A', 'T', 'A', '_', 'B', 'A', 'S', 'E', '_', 'A', 'D', 'D', 'R', '_', 'H', 'I', '\0', /* CP_PFP_METADATA_BASE_ADDR_HI (28318) */
	'C', 'P', '_', 'C', 'E', '_', 'M', 'E', 'T', 'A', 'D', 'A', 'T', 'A', '_', 'B', 'A', 'S', 'E', '_', 'A', 'D', 'D', 'R', '\0', /* CP_CE_METADATA_BASE_ADDR (28347) */
	'C', 'P', '_', 'C', 'E', '_', 'M', 'E', 'T', 'A', 'D', 'A', 'T', 'A', '_', 'B', 'A', 'S', 'E', '_', 'A', 'D', 'D', 'R', '_', 'H', 'I', '\0', /* CP_CE_METADATA_BASE_ADDR_HI (28372) */
	'C', 'P', '_', 'D', 'R', 'A', 'W', '_', 'I', 'N', 'D', 'X', '_', 'I', 'N', 'D', 'R', '_', 'A', 'D', 'D', 'R', '\0', /* CP_DRAW_INDX_INDR_ADDR (28400) */
	'C', 'P', '_', 'D', 'R', 'A', 'W', '_', 'I', 'N', 'D', 'X', '_', 'I', 'N', 'D', 'R', '_', 'A', 'D', 'D', 'R', '_', 'H', 'I', '\0', /* CP_DRAW_INDX_INDR_ADDR_HI (28423) */
	'C', 'P', '_', 'D', 'I', 'S', 'P', 'A', 'T', 'C', 'H', '_', 'I', 'N', 'D', 'R', '_', 'A', 'D', 'D', 'R', '\0', /* CP_DISPATCH_INDR_ADDR (28449) */
	'C', 'P', '_', 'D', 'I', 'S', 'P', 'A', 'T', 'C', 'H', '_', 'I', 'N', 'D', 'R', '_', 'A', 'D', 'D', 'R', '_', 'H', 'I', '\0', /* CP_DISPATCH_INDR_ADDR_HI (28471) */
	'C', 'P', '_', 'I', 'N', 'D', 'E', 'X', '_', 'B', 'A', 'S', 'E', '_', 'A', 'D', 'D', 'R', '\0', /* CP_INDEX_BASE_ADDR (28496) */
	'C', 'P', '_', 'I', 'N', 'D', 'E', 'X', '_', 'B', 'A', 'S', 'E', '_', 'A', 'D', 'D', 'R', '_', 'H', 'I', '\0', /* CP_INDEX_BASE_ADDR_HI (28515) */
	'C', 'P', '_', 'I', 'N', 'D', 'E', 'X', '_', 'T', 'Y', 'P', 'E', '\0', /* CP_INDEX_TYPE (28537) */
	'C', 'P', '_', 'G', 'D', 'S', '_', 'B', 'K', 'U', 'P', '_', 'A', 'D', 'D', 'R', '\0', /* CP_GDS_BKUP_ADDR (28551) */
	'C', 'P', '_', 'G', 'D', 'S', '_', 'B', 'K', 'U', 'P', '_', 'A', 'D', 'D', 'R', '_', 'H', 'I', '\0', /* CP_GDS_BKUP_ADDR_HI (28568) */
	'C', 'P', '_', 'S', 'A', 'M', 'P', 'L', 'E', '_', 'S', 'T', 'A', 'T', 'U', 'S', '\0', /* CP_SAMPLE_STATUS (28588) */
	'C', 'P', '_', 'M', 'E', '_', 'C', 'O', 'H', 'E', 'R', '_', 'C', 'N', 'T', 'L', '\0', /* CP_ME_COHER_CNTL (28605) */
	'C', 'P', '_', 'M', 'E', '_', 'C', 'O', 'H', 'E', 'R', '_', 'S', 'I', 'Z', 'E', '\0', /* CP_ME_COHER_SIZE (28622) */
	'C', 'P', '_', 'M', 'E', '_', 'C', 'O', 'H', 'E', 'R', '_', 'S', 'I', 'Z', 'E', '_', 'H', 'I', '\0', /* CP_ME_COHER_SIZE_HI (28639) */
	'C', 'P', '_', 'M', 'E', '_', 'C', 'O', 'H', 'E', 'R', '_', 'B', 'A', 'S', 'E', '\0', /* CP_ME_COHER_BASE (28659) */
	'C', 'P', '_', 'M', 'E', '_', 'C', 'O', 'H', 'E', 'R', '_', 'B', 'A', 'S', 'E', '_', 'H', 'I', '\0', /* CP_ME_COHER_BASE_HI (28676) */
	'C', 'P', '_', 'M', 'E', '_', 'C', 'O', 'H', 'E', 'R', '_', 'S', 'T', 'A', 'T', 'U', 'S', '\0', /* CP_ME_COHER_STATUS (28696) */
	'R', 'L', 'C', '_', 'G', 'P', 'M', '_', 'P', 'E', 'R', 'F', '_', 'C', 'O', 'U', 'N', 'T', '_', '0', '\0', /* RLC_GPM_PERF_COUNT_0 (28715) */
	'R', 'L', 'C', '_', 'G', 'P', 'M', '_', 'P', 'E', 'R', 'F', '_', 'C', 'O', 'U', 'N', 'T', '_', '1', '\0', /* RLC_GPM_PERF_COUNT_1 (28736) */
	'G', 'R', 'B', 'M', '_', 'G', 'F', 'X', '_', 'I', 'N', 'D', 'E', 'X', '\0', /* GRBM_GFX_INDEX (28757) */
	'V', 'G', 'T', '_', 'E', 'S', 'G', 'S', '_', 'R', 'I', 'N', 'G', '_', 'S', 'I', 'Z', 'E', '\0', /* VGT_ESGS_RING_SIZE (28772) */
	'V', 'G', 'T', '_', 'G', 'S', 'V', 'S', '_', 'R', 'I', 'N', 'G', '_', 'S', 'I', 'Z', 'E', '\0', /* VGT_GSVS_RING_SIZE (28791) */
	'V', 'G', 'T', '_', 'P', 'R', 'I', 'M', 'I', 'T', 'I', 'V', 'E', '_', 'T', 'Y', 'P', 'E', '\0', /* VGT_PRIMITIVE_TYPE (28810) */
	'V', 'G', 'T', '_', 'I', 'N', 'D', 'E', 'X', '_', 'T', 'Y', 'P', 'E', '\0', /* VGT_INDEX_TYPE (28829) */
	'V', 'G', 'T', '_', 'S', 'T', 'R', 'M', 'O', 'U', 'T', '_', 'B', 'U', 'F', 'F', 'E', 'R', '_', 'F', 'I', 'L', 'L', 'E', 'D', '_', 'S', 'I', 'Z', 'E', '_', '0', '\0', /* VGT_STRMOUT_BUFFER_FILLED_SIZE_0 (28844) */
	'V', 'G', 'T', '_', 'S', 'T', 'R', 'M', 'O', 'U', 'T', '_', 'B', 'U', 'F', 'F', 'E', 'R', '_', 'F', 'I', 'L', 'L', 'E', 'D', '_', 'S', 'I', 'Z', 'E', '_', '1', '\0', /* VGT_STRMOUT_BUFFER_FILLED_SIZE_1 (28877) */
	'V', 'G', 'T', '_', 'S', 'T', 'R', 'M', 'O', 'U', 'T', '_', 'B', 'U', 'F', 'F', 'E', 'R', '_', 'F', 'I', 'L', 'L', 'E', 'D', '_', 'S', 'I', 'Z', 'E', '_', '2', '\0', /* VGT_STRMOUT_BUFFER_FILLED_SIZE_2 (28910) */
	'V', 'G', 'T', '_', 'S', 'T', 'R', 'M', 'O', 'U', 'T', '_', 'B', 'U', 'F', 'F', 'E', 'R', '_', 'F', 'I', 'L', 'L', 'E', 'D', '_', 'S', 'I', 'Z', 'E', '_', '3', '\0', /* VGT_STRMOUT_BUFFER_FILLED_SIZE_3 (28943) */
	'G', 'E', '_', 'M', 'I', 'N', '_', 'V', 'T', 'X', '_', 'I', 'N', 'D', 'X', '\0', /* GE_MIN_VTX_INDX (28976) */
	'G', 'E', '_', 'I', 'N', 'D', 'X', '_', 'O', 'F', 'F', 'S', 'E', 'T', '\0', /* GE_INDX_OFFSET (28992) */
	'G', 'E', '_', 'M', 'U', 'L', 'T', 'I', '_', 'P', 'R', 'I', 'M', '_', 'I', 'B', '_', 'R', 'E', 'S', 'E', 'T', '_', 'E', 'N', '\0', /* GE_MULTI_PRIM_IB_RESET_EN (29007) */
	'V', 'G', 'T', '_', 'N', 'U', 'M', '_', 'I', 'N', 'D', 'I', 'C', 'E', 'S', '\0', /* VGT_NUM_INDICES (29033) */
	'V', 'G', 'T', '_', 'N', 'U', 'M', '_', 'I', 'N', 'S', 'T', 'A', 'N', 'C', 'E', 'S', '\0', /* VGT_NUM_INSTANCES (29049) */
	'V', 'G', 'T', '_', 'T', 'F', '_', 'R', 'I', 'N', 'G', '_', 'S', 'I', 'Z', 'E', '\0', /* VGT_TF_RING_SIZE (29067) */
	'V', 'G', 'T', '_', 'H', 'S', '_', 'O', 'F', 'F', 'C', 'H', 'I', 'P', '_', 'P', 'A', 'R', 'A', 'M', '\0', /* VGT_HS_OFFCHIP_PARAM (29084) */
	'V', 'G', 'T', '_', 'T', 'F', '_', 'M', 'E', 'M', 'O', 'R', 'Y', '_', 'B', 'A', 'S', 'E', '\0', /* VGT_TF_MEMORY_BASE (29105) */
	'G', 'E', '_', 'D', 'M', 'A', '_', 'F', 'I', 'R', 'S', 'T', '_', 'I', 'N', 'D', 'E', 'X', '\0', /* GE_DMA_FIRST_INDEX (29124) */
	'W', 'D', '_', 'P', 'O', 'S', '_', 'B', 'U', 'F', '_', 'B', 'A', 'S', 'E', '\0', /* WD_POS_BUF_BASE (29143) */
	'W', 'D', '_', 'P', 'O', 'S', '_', 'B', 'U', 'F', '_', 'B', 'A', 'S', 'E', '_', 'H', 'I', '\0', /* WD_POS_BUF_BASE_HI (29159) */
	'W', 'D', '_', 'C', 'N', 'T', 'L', '_', 'S', 'B', '_', 'B', 'U', 'F', '_', 'B', 'A', 'S', 'E', '\0', /* WD_CNTL_SB_BUF_BASE (29178) */
	'W', 'D', '_', 'C', 'N', 'T', 'L', '_', 'S', 'B', '_', 'B', 'U', 'F', '_', 'B', 'A', 'S', 'E', '_', 'H', 'I', '\0', /* WD_CNTL_SB_BUF_BASE_HI (29198) */
	'W', 'D', '_', 'I', 'N', 'D', 'E', 'X', '_', 'B', 'U', 'F', '_', 'B', 'A', 'S', 'E', '\0', /* WD_INDEX_BUF_BASE (29221) */
	'W', 'D', '_', 'I', 'N', 'D', 'E', 'X', '_', 'B', 'U', 'F', '_', 'B', 'A', 'S', 'E', '_', 'H', 'I', '\0', /* WD_INDEX_BUF_BASE_HI (29239) */
	'I', 'A', '_', 'M', 'U', 'L', 'T', 'I', '_', 'V', 'G', 'T', '_', 'P', 'A', 'R', 'A', 'M', '_', 'P', 'I', 'P', 'E', 'D', '\0', /* IA_MULTI_VGT_PARAM_PIPED (29260) */
	'G', 'E', '_', 'M', 'A', 'X', '_', 'V', 'T', 'X', '_', 'I', 'N', 'D', 'X', '\0', /* GE_MAX_VTX_INDX (29285) */
	'V', 'G', 'T', '_', 'I', 'N', 'S', 'T', 'A', 'N', 'C', 'E', '_', 'B', 'A', 'S', 'E', '_', 'I', 'D', '\0', /* VGT_INSTANCE_BASE_ID (29301, 29316) */
	'G', 'E', '_', 'C', 'N', 'T', 'L', '\0', /* GE_CNTL (29322) */
	'G', 'E', '_', 'U', 'S', 'E', 'R', '_', 'V', 'G', 'P', 'R', '1', '\0', /* GE_USER_VGPR1 (29330) */
	'G', 'E', '_', 'U', 'S', 'E', 'R', '_', 'V', 'G', 'P', 'R', '2', '\0', /* GE_USER_VGPR2 (29344) */
	'G', 'E', '_', 'U', 'S', 'E', 'R', '_', 'V', 'G', 'P', 'R', '3', '\0', /* GE_USER_VGPR3 (29358) */
	'G', 'E', '_', 'S', 'T', 'E', 'R', 'E', 'O', '_', 'C', 'N', 'T', 'L', '\0', /* GE_STEREO_CNTL (29372) */
	'G', 'E', '_', 'P', 'C', '_', 'A', 'L', 'L', 'O', 'C', '\0', /* GE_PC_ALLOC (29387) */
	'V', 'G', 'T', '_', 'T', 'F', '_', 'M', 'E', 'M', 'O', 'R', 'Y', '_', 'B', 'A', 'S', 'E', '_', 'H', 'I', '\0', /* VGT_TF_MEMORY_BASE_HI (29399) */
	'G', 'E', '_', 'U', 'S', 'E', 'R', '_', 'V', 'G', 'P', 'R', '_', 'E', 'N', '\0', /* GE_USER_VGPR_EN (29421) */
	'P', 'A', '_', 'S', 'U', '_', 'L', 'I', 'N', 'E', '_', 'S', 'T', 'I', 'P', 'P', 'L', 'E', '_', 'V', 'A', 'L', 'U', 'E', '\0', /* PA_SU_LINE_STIPPLE_VALUE (29437, 29443, 29456) */
	'P', 'A', '_', 'S', 'C', '_', 'L', 'I', 'N', 'E', '_', 'S', 'T', 'I', 'P', 'P', 'L', 'E', '_', 'S', 'T', 'A', 'T', 'E', '\0', /* PA_SC_LINE_STIPPLE_STATE (29462) */
	'P', 'A', '_', 'S', 'C', '_', 'S', 'C', 'R', 'E', 'E', 'N', '_', 'E', 'X', 'T', 'E', 'N', 'T', '_', 'M', 'I', 'N', '_', '0', '\0', /* PA_SC_SCREEN_EXTENT_MIN_0 (29487) */
	'P', 'A', '_', 'S', 'C', '_', 'S', 'C', 'R', 'E', 'E', 'N', '_', 'E', 'X', 'T', 'E', 'N', 'T', '_', 'M', 'A', 'X', '_', '0', '\0', /* PA_SC_SCREEN_EXTENT_MAX_0 (29513) */
	'P', 'A', '_', 'S', 'C', '_', 'S', 'C', 'R', 'E', 'E', 'N', '_', 'E', 'X', 'T', 'E', 'N', 'T', '_', 'M', 'I', 'N', '_', '1', '\0', /* PA_SC_SCREEN_EXTENT_MIN_1 (29539) */
	'P', 'A', '_', 'S', 'C', '_', 'S', 'C', 'R', 'E', 'E', 'N', '_', 'E', 'X', 'T', 'E', 'N', 'T', '_', 'M', 'A', 'X', '_', '1', '\0', /* PA_SC_SCREEN_EXTENT_MAX_1 (29565) */
	'P', 'A', '_', 'S', 'C', '_', 'P', '3', 'D', '_', 'T', 'R', 'A', 'P', '_', 'S', 'C', 'R', 'E', 'E', 'N', '_', 'H', 'V', '_', 'E', 'N', '\0', /* PA_SC_P3D_TRAP_SCREEN_HV_EN (29591) */
	'P', 'A', '_', 'S', 'C', '_', 'P', '3', 'D', '_', 'T', 'R', 'A', 'P', '_', 'S', 'C', 'R', 'E', 'E', 'N', '_', 'H', '\0', /* PA_SC_P3D_TRAP_SCREEN_H (29619) */
	'P', 'A', '_', 'S', 'C', '_', 'P', '3', 'D', '_', 'T', 'R', 'A', 'P', '_', 'S', 'C', 'R', 'E', 'E', 'N', '_', 'V', '\0', /* PA_SC_P3D_TRAP_SCREEN_V (29643) */
	'P', 'A', '_', 'S', 'C', '_', 'P', '3', 'D', '_', 'T', 'R', 'A', 'P', '_', 'S', 'C', 'R', 'E', 'E', 'N', '_', 'O', 'C', 'C', 'U', 'R', 'R', 'E', 'N', 'C', 'E', '\0', /* PA_SC_P3D_TRAP_SCREEN_OCCURRENCE (29667) */
	'P', 'A', '_', 'S', 'C', '_', 'P', '3', 'D', '_', 'T', 'R', 'A', 'P', '_', 'S', 'C', 'R', 'E', 'E', 'N', '_', 'C', 'O', 'U', 'N', 'T', '\0', /* PA_SC_P3D_TRAP_SCREEN_COUNT (29700) */
	'P', 'A', '_', 'S', 'C', '_', 'H', 'P', '3', 'D', '_', 'T', 'R', 'A', 'P', '_', 'S', 'C', 'R', 'E', 'E', 'N', '_', 'H', 'V', '_', 'E', 'N', '\0', /* PA_SC_HP3D_TRAP_SCREEN_HV_EN (29728) */
	'P', 'A', '_', 'S', 'C', '_', 'H', 'P', '3', 'D', '_', 'T', 'R', 'A', 'P', '_', 'S', 'C', 'R', 'E', 'E', 'N', '_', 'H', '\0', /* PA_SC_HP3D_TRAP_SCREEN_H (29757) */
	'P', 'A', '_', 'S', 'C', '_', 'H', 'P', '3', 'D', '_', 'T', 'R', 'A', 'P', '_', 'S', 'C', 'R', 'E', 'E', 'N', '_', 'V', '\0', /* PA_SC_HP3D_TRAP_SCREEN_V (29782) */
	'P', 'A', '_', 'S', 'C', '_', 'H', 'P', '3', 'D', '_', 'T', 'R', 'A', 'P', '_', 'S', 'C', 'R', 'E', 'E', 'N', '_', 'O', 'C', 'C', 'U', 'R', 'R', 'E', 'N', 'C', 'E', '\0', /* PA_SC_HP3D_TRAP_SCREEN_OCCURRENCE (29807) */
	'P', 'A', '_', 'S', 'C', '_', 'H', 'P', '3', 'D', '_', 'T', 'R', 'A', 'P', '_', 'S', 'C', 'R', 'E', 'E', 'N', '_', 'C', 'O', 'U', 'N', 'T', '\0', /* PA_SC_HP3D_TRAP_SCREEN_COUNT (29841) */
	'P', 'A', '_', 'S', 'C', '_', 'T', 'R', 'A', 'P', '_', 'S', 'C', 'R', 'E', 'E', 'N', '_', 'H', 'V', '_', 'E', 'N', '\0', /* PA_SC_TRAP_SCREEN_HV_EN (29870) */
	'P', 'A', '_', 'S', 'C', '_', 'T', 'R', 'A', 'P', '_', 'S', 'C', 'R', 'E', 'E', 'N', '_', 'H', '\0', /* PA_SC_TRAP_SCREEN_H (29894) */
	'P', 'A', '_', 'S', 'C', '_', 'T', 'R', 'A', 'P', '_', 'S', 'C', 'R', 'E', 'E', 'N', '_', 'V', '\0', /* PA_SC_TRAP_SCREEN_V (29914) */
	'P', 'A', '_', 'S', 'C', '_', 'T', 'R', 'A', 'P', '_', 'S', 'C', 'R', 'E', 'E', 'N', '_', 'O', 'C', 'C', 'U', 'R', 'R', 'E', 'N', 'C', 'E', '\0', /* PA_SC_TRAP_SCREEN_OCCURRENCE (29934) */
	'P', 'A', '_', 'S', 'C', '_', 'T', 'R', 'A', 'P', '_', 'S', 'C', 'R', 'E', 'E', 'N', '_', 'C', 'O', 'U', 'N', 'T', '\0', /* PA_SC_TRAP_SCREEN_COUNT (29963) */
	'S', 'Q', '_', 'T', 'H', 'R', 'E', 'A', 'D', '_', 'T', 'R', 'A', 'C', 'E', '_', 'U', 'S', 'E', 'R', 'D', 'A', 'T', 'A', '_', '0', '\0', /* SQ_THREAD_TRACE_USERDATA_0 (29987) */
	'S', 'Q', '_', 'T', 'H', 'R', 'E', 'A', 'D', '_', 'T', 'R', 'A', 'C', 'E', '_', 'U', 'S', 'E', 'R', 'D', 'A', 'T', 'A', '_', '1', '\0', /* SQ_THREAD_TRACE_USERDATA_1 (30014) */
	'S', 'Q', '_', 'T', 'H', 'R', 'E', 'A', 'D', '_', 'T', 'R', 'A', 'C', 'E', '_', 'U', 'S', 'E', 'R', 'D', 'A', 'T', 'A', '_', '2', '\0', /* SQ_THREAD_TRACE_USERDATA_2 (30041) */
	'S', 'Q', '_', 'T', 'H', 'R', 'E', 'A', 'D', '_', 'T', 'R', 'A', 'C', 'E', '_', 'U', 'S', 'E', 'R', 'D', 'A', 'T', 'A', '_', '3', '\0', /* SQ_THREAD_TRACE_USERDATA_3 (30068) */
	'S', 'Q', '_', 'T', 'H', 'R', 'E', 'A', 'D', '_', 'T', 'R', 'A', 'C', 'E', '_', 'U', 'S', 'E', 'R', 'D', 'A', 'T', 'A', '_', '4', '\0', /* SQ_THREAD_TRACE_USERDATA_4 (30095) */
	'S', 'Q', '_', 'T', 'H', 'R', 'E', 'A', 'D', '_', 'T', 'R', 'A', 'C', 'E', '_', 'U', 'S', 'E', 'R', 'D', 'A', 'T', 'A', '_', '5', '\0', /* SQ_THREAD_TRACE_USERDATA_5 (30122) */
	'S', 'Q', '_', 'T', 'H', 'R', 'E', 'A', 'D', '_', 'T', 'R', 'A', 'C', 'E', '_', 'U', 'S', 'E', 'R', 'D', 'A', 'T', 'A', '_', '6', '\0', /* SQ_THREAD_TRACE_USERDATA_6 (30149) */
	'S', 'Q', '_', 'T', 'H', 'R', 'E', 'A', 'D', '_', 'T', 'R', 'A', 'C', 'E', '_', 'U', 'S', 'E', 'R', 'D', 'A', 'T', 'A', '_', '7', '\0', /* SQ_THREAD_TRACE_USERDATA_7 (30176) */
	'S', 'Q', 'C', '_', 'C', 'A', 'C', 'H', 'E', 'S', '\0', /* SQC_CACHES (30203) */
	'S', 'Q', 'C', '_', 'W', 'R', 'I', 'T', 'E', 'B', 'A', 'C', 'K', '\0', /* SQC_WRITEBACK (30214, 30218) */
	'T', 'A', '_', 'C', 'S', '_', 'B', 'C', '_', 'B', 'A', 'S', 'E', '_', 'A', 'D', 'D', 'R', '\0', /* TA_CS_BC_BASE_ADDR (30228) */
	'T', 'A', '_', 'C', 'S', '_', 'B', 'C', '_', 'B', 'A', 'S', 'E', '_', 'A', 'D', 'D', 'R', '_', 'H', 'I', '\0', /* TA_CS_BC_BASE_ADDR_HI (30247) */
	'D', 'B', '_', 'O', 'C', 'C', 'L', 'U', 'S', 'I', 'O', 'N', '_', 'C', 'O', 'U', 'N', 'T', '0', '_', 'L', 'O', 'W', '\0', /* DB_OCCLUSION_COUNT0_LOW (30269) */
	'D', 'B', '_', 'O', 'C', 'C', 'L', 'U', 'S', 'I', 'O', 'N', '_', 'C', 'O', 'U', 'N', 'T', '0', '_', 'H', 'I', '\0', /* DB_OCCLUSION_COUNT0_HI (30293) */
	'D', 'B', '_', 'O', 'C', 'C', 'L', 'U', 'S', 'I', 'O', 'N', '_', 'C', 'O', 'U', 'N', 'T', '1', '_', 'L', 'O', 'W', '\0', /* DB_OCCLUSION_COUNT1_LOW (30316) */
	'D', 'B', '_', 'O', 'C', 'C', 'L', 'U', 'S', 'I', 'O', 'N', '_', 'C', 'O', 'U', 'N', 'T', '1', '_', 'H', 'I', '\0', /* DB_OCCLUSION_COUNT1_HI (30340) */
	'D', 'B', '_', 'O', 'C', 'C', 'L', 'U', 'S', 'I', 'O', 'N', '_', 'C', 'O', 'U', 'N', 'T', '2', '_', 'L', 'O', 'W', '\0', /* DB_OCCLUSION_COUNT2_LOW (30363) */
	'D', 'B', '_', 'O', 'C', 'C', 'L', 'U', 'S', 'I', 'O', 'N', '_', 'C', 'O', 'U', 'N', 'T', '2', '_', 'H', 'I', '\0', /* DB_OCCLUSION_COUNT2_HI (30387) */
	'D', 'B', '_', 'O', 'C', 'C', 'L', 'U', 'S', 'I', 'O', 'N', '_', 'C', 'O', 'U', 'N', 'T', '3', '_', 'L', 'O', 'W', '\0', /* DB_OCCLUSION_COUNT3_LOW (30410) */
	'D', 'B', '_', 'O', 'C', 'C', 'L', 'U', 'S', 'I', 'O', 'N', '_', 'C', 'O', 'U', 'N', 'T', '3', '_', 'H', 'I', '\0', /* DB_OCCLUSION_COUNT3_HI (30434) */
	'D', 'B', '_', 'Z', 'P', 'A', 'S', 'S', '_', 'C', 'O', 'U', 'N', 'T', '_', 'L', 'O', 'W', '\0', /* DB_ZPASS_COUNT_LOW (30457) */
	'D', 'B', '_', 'Z', 'P', 'A', 'S', 'S', '_', 'C', 'O', 'U', 'N', 'T', '_', 'H', 'I', '\0', /* DB_ZPASS_COUNT_HI (30476) */
	'G', 'D', 'S', '_', 'R', 'D', '_', 'A', 'D', 'D', 'R', '\0', /* GDS_RD_ADDR (30494) */
	'G', 'D', 'S', '_', 'R', 'D', '_', 'D', 'A', 'T', 'A', '\0', /* GDS_RD_DATA (30506) */
	'G', 'D', 'S', '_', 'R', 'D', '_', 'B', 'U', 'R', 'S', 'T', '_', 'A', 'D', 'D', 'R', '\0', /* GDS_RD_BURST_ADDR (30518) */
	'G', 'D', 'S', '_', 'R', 'D', '_', 'B', 'U', 'R', 'S', 'T', '_', 'C', 'O', 'U', 'N', 'T', '\0', /* GDS_RD_BURST_COUNT (30536) */
	'G', 'D', 'S', '_', 'R', 'D', '_', 'B', 'U', 'R', 'S', 'T', '_', 'D', 'A', 'T', 'A', '\0', /* GDS_RD_BURST_DATA (30555) */
	'G', 'D', 'S', '_', 'W', 'R', '_', 'A', 'D', 'D', 'R', '\0', /* GDS_WR_ADDR (30573) */
	'G', 'D', 'S', '_', 'W', 'R', '_', 'D', 'A', 'T', 'A', '\0', /* GDS_WR_DATA (30585) */
	'G', 'D', 'S', '_', 'W', 'R', '_', 'B', 'U', 'R', 'S', 'T', '_', 'A', 'D', 'D', 'R', '\0', /* GDS_WR_BURST_ADDR (30597) */
	'G', 'D', 'S', '_', 'W', 'R', '_', 'B', 'U', 'R', 'S', 'T', '_', 'D', 'A', 'T', 'A', '\0', /* GDS_WR_BURST_DATA (30615) */
	'G', 'D', 'S', '_', 'W', 'R', 'I', 'T', 'E', '_', 'C', 'O', 'M', 'P', 'L', 'E', 'T', 'E', '\0', /* GDS_WRITE_COMPLETE (30633, 30643) */
	'G', 'D', 'S', '_', 'A', 'T', 'O', 'M', '_', 'C', 'N', 'T', 'L', '\0', /* GDS_ATOM_CNTL (30652) */
	'G', 'D', 'S', '_', 'A', 'T', 'O', 'M', '_', 'C', 'O', 'M', 'P', 'L', 'E', 'T', 'E', '\0', /* GDS_ATOM_COMPLETE (30666) */
	'G', 'D', 'S', '_', 'A', 'T', 'O', 'M', '_', 'B', 'A', 'S', 'E', '\0', /* GDS_ATOM_BASE (30684) */
	'G', 'D', 'S', '_', 'A', 'T', 'O', 'M', '_', 'S', 'I', 'Z', 'E', '\0', /* GDS_ATOM_SIZE (30698) */
	'G', 'D', 'S', '_', 'A', 'T', 'O', 'M', '_', 'O', 'F', 'F', 'S', 'E', 'T', '0', '\0', /* GDS_ATOM_OFFSET0 (30712, 30721, 30726) */
	'G', 'D', 'S', '_', 'A', 'T', 'O', 'M', '_', 'O', 'F', 'F', 'S', 'E', 'T', '1', '\0', /* GDS_ATOM_OFFSET1 (30729, 30738) */
	'G', 'D', 'S', '_', 'A', 'T', 'O', 'M', '_', 'D', 'S', 'T', '\0', /* GDS_ATOM_DST (30746, 30755) */
	'G', 'D', 'S', '_', 'A', 'T', 'O', 'M', '_', 'O', 'P', '\0', /* GDS_ATOM_OP (30759) */
	'G', 'D', 'S', '_', 'A', 'T', 'O', 'M', '_', 'S', 'R', 'C', '0', '\0', /* GDS_ATOM_SRC0 (30771, 30780) */
	'G', 'D', 'S', '_', 'A', 'T', 'O', 'M', '_', 'S', 'R', 'C', '0', '_', 'U', '\0', /* GDS_ATOM_SRC0_U (30785) */
	'G', 'D', 'S', '_', 'A', 'T', 'O', 'M', '_', 'S', 'R', 'C', '1', '\0', /* GDS_ATOM_SRC1 (30801) */
	'G', 'D', 'S', '_', 'A', 'T', 'O', 'M', '_', 'S', 'R', 'C', '1', '_', 'U', '\0', /* GDS_ATOM_SRC1_U (30815) */
	'G', 'D', 'S', '_', 'A', 'T', 'O', 'M', '_', 'R', 'E', 'A', 'D', '0', '\0', /* GDS_ATOM_READ0 (30831) */
	'G', 'D', 'S', '_', 'A', 'T', 'O', 'M', '_', 'R', 'E', 'A', 'D', '0', '_', 'U', '\0', /* GDS_ATOM_READ0_U (30846) */
	'G', 'D', 'S', '_', 'A', 'T', 'O', 'M', '_', 'R', 'E', 'A', 'D', '1', '\0', /* GDS_ATOM_READ1 (30863) */
	'G', 'D', 'S', '_', 'A', 'T', 'O', 'M', '_', 'R', 'E', 'A', 'D', '1', '_', 'U', '\0', /* GDS_ATOM_READ1_U (30878) */
	'G', 'D', 'S', '_', 'G', 'W', 'S', '_', 'R', 'E', 'S', 'O', 'U', 'R', 'C', 'E', '_', 'C', 'N', 'T', 'L', '\0', /* GDS_GWS_RESOURCE_CNTL (30895) */
	'G', 'D', 'S', '_', 'G', 'W', 'S', '_', 'R', 'E', 'S', 'O', 'U', 'R', 'C', 'E', '\0', /* GDS_GWS_RESOURCE (30917, 30927) */
	'G', 'D', 'S', '_', 'G', 'W', 'S', '_', 'R', 'E', 'S', 'O', 'U', 'R', 'C', 'E', '_', 'C', 'N', 'T', '\0', /* GDS_GWS_RESOURCE_CNT (30934, 30942) */
	'G', 'D', 'S', '_', 'O', 'A', '_', 'C', 'N', 'T', 'L', '\0', /* GDS_OA_CNTL (30955) */
	'G', 'D', 'S', '_', 'O', 'A', '_', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '\0', /* GDS_OA_COUNTER (30967) */
	'G', 'D', 'S', '_', 'O', 'A', '_', 'A', 'D', 'D', 'R', 'E', 'S', 'S', '\0', /* GDS_OA_ADDRESS (30982, 30989) */
	'G', 'D', 'S', '_', 'O', 'A', '_', 'I', 'N', 'C', 'D', 'E', 'C', '\0', /* GDS_OA_INCDEC (30997, 31004) */
	'G', 'D', 'S', '_', 'O', 'A', '_', 'R', 'I', 'N', 'G', '_', 'S', 'I', 'Z', 'E', '\0', /* GDS_OA_RING_SIZE (31011) */
	'S', 'P', 'I', '_', 'C', 'O', 'N', 'F', 'I', 'G', '_', 'C', 'N', 'T', 'L', '_', 'R', 'E', 'M', 'A', 'P', '\0', /* SPI_CONFIG_CNTL_REMAP (31028) */
	'S', 'P', 'I', '_', 'C', 'O', 'N', 'F', 'I', 'G', '_', 'C', 'N', 'T', 'L', '_', '1', '_', 'R', 'E', 'M', 'A', 'P', '\0', /* SPI_CONFIG_CNTL_1_REMAP (31050) */
	'S', 'P', 'I', '_', 'C', 'O', 'N', 'F', 'I', 'G', '_', 'C', 'N', 'T', 'L', '_', '2', '_', 'R', 'E', 'M', 'A', 'P', '\0', /* SPI_CONFIG_CNTL_2_REMAP (31074) */
	'S', 'P', 'I', '_', 'W', 'A', 'V', 'E', '_', 'L', 'I', 'M', 'I', 'T', '_', 'C', 'N', 'T', 'L', '_', 'R', 'E', 'M', 'A', 'P', '\0', /* SPI_WAVE_LIMIT_CNTL_REMAP (31098) */
	'C', 'P', 'G', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'L', 'O', '\0', /* CPG_PERFCOUNTER1_LO (31124) */
	'C', 'P', 'G', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'H', 'I', '\0', /* CPG_PERFCOUNTER1_HI (31144) */
	'C', 'P', 'G', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'L', 'O', '\0', /* CPG_PERFCOUNTER0_LO (31164) */
	'C', 'P', 'G', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'H', 'I', '\0', /* CPG_PERFCOUNTER0_HI (31184) */
	'C', 'P', 'C', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'L', 'O', '\0', /* CPC_PERFCOUNTER1_LO (31204, 31205) */
	'C', 'P', 'C', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'H', 'I', '\0', /* CPC_PERFCOUNTER1_HI (31224, 31225) */
	'C', 'P', 'C', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'L', 'O', '\0', /* CPC_PERFCOUNTER0_LO (31244, 31245) */
	'C', 'P', 'C', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'H', 'I', '\0', /* CPC_PERFCOUNTER0_HI (31264, 31265) */
	'C', 'P', 'F', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'L', 'O', '\0', /* CPF_PERFCOUNTER1_LO (31284) */
	'C', 'P', 'F', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'H', 'I', '\0', /* CPF_PERFCOUNTER1_HI (31304) */
	'C', 'P', 'F', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'L', 'O', '\0', /* CPF_PERFCOUNTER0_LO (31324) */
	'C', 'P', 'F', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'H', 'I', '\0', /* CPF_PERFCOUNTER0_HI (31344) */
	'C', 'P', 'F', '_', 'L', 'A', 'T', 'E', 'N', 'C', 'Y', '_', 'S', 'T', 'A', 'T', 'S', '_', 'D', 'A', 'T', 'A', '\0', /* CPF_LATENCY_STATS_DATA (31364) */
	'C', 'P', 'G', '_', 'L', 'A', 'T', 'E', 'N', 'C', 'Y', '_', 'S', 'T', 'A', 'T', 'S', '_', 'D', 'A', 'T', 'A', '\0', /* CPG_LATENCY_STATS_DATA (31387) */
	'C', 'P', 'C', '_', 'L', 'A', 'T', 'E', 'N', 'C', 'Y', '_', 'S', 'T', 'A', 'T', 'S', '_', 'D', 'A', 'T', 'A', '\0', /* CPC_LATENCY_STATS_DATA (31410) */
	'G', 'R', 'B', 'M', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'L', 'O', '\0', /* GRBM_PERFCOUNTER0_LO (31433) */
	'G', 'R', 'B', 'M', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'H', 'I', '\0', /* GRBM_PERFCOUNTER0_HI (31454) */
	'G', 'R', 'B', 'M', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'L', 'O', '\0', /* GRBM_PERFCOUNTER1_LO (31475) */
	'G', 'R', 'B', 'M', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'H', 'I', '\0', /* GRBM_PERFCOUNTER1_HI (31496) */
	'G', 'R', 'B', 'M', '_', 'S', 'E', '0', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '_', 'L', 'O', '\0', /* GRBM_SE0_PERFCOUNTER_LO (31517) */
	'G', 'R', 'B', 'M', '_', 'S', 'E', '0', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '_', 'H', 'I', '\0', /* GRBM_SE0_PERFCOUNTER_HI (31541, 31550, 31554) */
	'G', 'R', 'B', 'M', '_', 'S', 'E', '1', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '_', 'L', 'O', '\0', /* GRBM_SE1_PERFCOUNTER_LO (31565) */
	'G', 'R', 'B', 'M', '_', 'S', 'E', '1', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '_', 'H', 'I', '\0', /* GRBM_SE1_PERFCOUNTER_HI (31589) */
	'G', 'R', 'B', 'M', '_', 'S', 'E', '2', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '_', 'L', 'O', '\0', /* GRBM_SE2_PERFCOUNTER_LO (31613) */
	'G', 'R', 'B', 'M', '_', 'S', 'E', '2', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '_', 'H', 'I', '\0', /* GRBM_SE2_PERFCOUNTER_HI (31637) */
	'G', 'R', 'B', 'M', '_', 'S', 'E', '3', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '_', 'L', 'O', '\0', /* GRBM_SE3_PERFCOUNTER_LO (31661) */
	'G', 'R', 'B', 'M', '_', 'S', 'E', '3', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '_', 'H', 'I', '\0', /* GRBM_SE3_PERFCOUNTER_HI (31685) */
	'G', 'E', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'L', 'O', '\0', /* GE_PERFCOUNTER0_LO (31709) */
	'G', 'E', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'H', 'I', '\0', /* GE_PERFCOUNTER0_HI (31728) */
	'G', 'E', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'L', 'O', '\0', /* GE_PERFCOUNTER1_LO (31747) */
	'G', 'E', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'H', 'I', '\0', /* GE_PERFCOUNTER1_HI (31766) */
	'G', 'E', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', 'L', 'O', '\0', /* GE_PERFCOUNTER2_LO (31785) */
	'G', 'E', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', 'H', 'I', '\0', /* GE_PERFCOUNTER2_HI (31804) */
	'G', 'E', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '3', '_', 'L', 'O', '\0', /* GE_PERFCOUNTER3_LO (31823) */
	'G', 'E', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '3', '_', 'H', 'I', '\0', /* GE_PERFCOUNTER3_HI (31842) */
	'G', 'E', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '4', '_', 'L', 'O', '\0', /* GE_PERFCOUNTER4_LO (31861) */
	'G', 'E', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '4', '_', 'H', 'I', '\0', /* GE_PERFCOUNTER4_HI (31880) */
	'G', 'E', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '5', '_', 'L', 'O', '\0', /* GE_PERFCOUNTER5_LO (31899) */
	'G', 'E', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '5', '_', 'H', 'I', '\0', /* GE_PERFCOUNTER5_HI (31918) */
	'G', 'E', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '6', '_', 'L', 'O', '\0', /* GE_PERFCOUNTER6_LO (31937) */
	'G', 'E', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '6', '_', 'H', 'I', '\0', /* GE_PERFCOUNTER6_HI (31956) */
	'G', 'E', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '7', '_', 'L', 'O', '\0', /* GE_PERFCOUNTER7_LO (31975) */
	'G', 'E', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '7', '_', 'H', 'I', '\0', /* GE_PERFCOUNTER7_HI (31994) */
	'G', 'E', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '8', '_', 'L', 'O', '\0', /* GE_PERFCOUNTER8_LO (32013) */
	'G', 'E', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '8', '_', 'H', 'I', '\0', /* GE_PERFCOUNTER8_HI (32032) */
	'G', 'E', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '9', '_', 'L', 'O', '\0', /* GE_PERFCOUNTER9_LO (32051) */
	'G', 'E', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '9', '_', 'H', 'I', '\0', /* GE_PERFCOUNTER9_HI (32070) */
	'G', 'E', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '0', '_', 'L', 'O', '\0', /* GE_PERFCOUNTER10_LO (32089) */
	'G', 'E', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '0', '_', 'H', 'I', '\0', /* GE_PERFCOUNTER10_HI (32109) */
	'G', 'E', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '1', '_', 'L', 'O', '\0', /* GE_PERFCOUNTER11_LO (32129) */
	'G', 'E', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '1', '_', 'H', 'I', '\0', /* GE_PERFCOUNTER11_HI (32149) */
	'P', 'A', '_', 'S', 'U', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'L', 'O', '\0', /* PA_SU_PERFCOUNTER0_LO (32169) */
	'P', 'A', '_', 'S', 'U', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'H', 'I', '\0', /* PA_SU_PERFCOUNTER0_HI (32191) */
	'P', 'A', '_', 'S', 'U', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'L', 'O', '\0', /* PA_SU_PERFCOUNTER1_LO (32213) */
	'P', 'A', '_', 'S', 'U', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'H', 'I', '\0', /* PA_SU_PERFCOUNTER1_HI (32235) */
	'P', 'A', '_', 'S', 'U', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', 'L', 'O', '\0', /* PA_SU_PERFCOUNTER2_LO (32257) */
	'P', 'A', '_', 'S', 'U', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', 'H', 'I', '\0', /* PA_SU_PERFCOUNTER2_HI (32279) */
	'P', 'A', '_', 'S', 'U', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '3', '_', 'L', 'O', '\0', /* PA_SU_PERFCOUNTER3_LO (32301) */
	'P', 'A', '_', 'S', 'U', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '3', '_', 'H', 'I', '\0', /* PA_SU_PERFCOUNTER3_HI (32323) */
	'P', 'A', '_', 'S', 'C', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'L', 'O', '\0', /* PA_SC_PERFCOUNTER0_LO (32345) */
	'P', 'A', '_', 'S', 'C', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'H', 'I', '\0', /* PA_SC_PERFCOUNTER0_HI (32367) */
	'P', 'A', '_', 'S', 'C', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'L', 'O', '\0', /* PA_SC_PERFCOUNTER1_LO (32389) */
	'P', 'A', '_', 'S', 'C', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'H', 'I', '\0', /* PA_SC_PERFCOUNTER1_HI (32411) */
	'P', 'A', '_', 'S', 'C', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', 'L', 'O', '\0', /* PA_SC_PERFCOUNTER2_LO (32433) */
	'P', 'A', '_', 'S', 'C', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', 'H', 'I', '\0', /* PA_SC_PERFCOUNTER2_HI (32455) */
	'P', 'A', '_', 'S', 'C', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '3', '_', 'L', 'O', '\0', /* PA_SC_PERFCOUNTER3_LO (32477) */
	'P', 'A', '_', 'S', 'C', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '3', '_', 'H', 'I', '\0', /* PA_SC_PERFCOUNTER3_HI (32499) */
	'P', 'A', '_', 'S', 'C', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '4', '_', 'L', 'O', '\0', /* PA_SC_PERFCOUNTER4_LO (32521) */
	'P', 'A', '_', 'S', 'C', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '4', '_', 'H', 'I', '\0', /* PA_SC_PERFCOUNTER4_HI (32543) */
	'P', 'A', '_', 'S', 'C', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '5', '_', 'L', 'O', '\0', /* PA_SC_PERFCOUNTER5_LO (32565) */
	'P', 'A', '_', 'S', 'C', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '5', '_', 'H', 'I', '\0', /* PA_SC_PERFCOUNTER5_HI (32587) */
	'P', 'A', '_', 'S', 'C', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '6', '_', 'L', 'O', '\0', /* PA_SC_PERFCOUNTER6_LO (32609) */
	'P', 'A', '_', 'S', 'C', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '6', '_', 'H', 'I', '\0', /* PA_SC_PERFCOUNTER6_HI (32631) */
	'P', 'A', '_', 'S', 'C', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '7', '_', 'L', 'O', '\0', /* PA_SC_PERFCOUNTER7_LO (32653) */
	'P', 'A', '_', 'S', 'C', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '7', '_', 'H', 'I', '\0', /* PA_SC_PERFCOUNTER7_HI (32675) */
	'S', 'P', 'I', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'H', 'I', '\0', /* SPI_PERFCOUNTER0_HI (32697) */
	'S', 'P', 'I', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'L', 'O', '\0', /* SPI_PERFCOUNTER0_LO (32717) */
	'S', 'P', 'I', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'H', 'I', '\0', /* SPI_PERFCOUNTER1_HI (32737) */
	'S', 'P', 'I', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'L', 'O', '\0', /* SPI_PERFCOUNTER1_LO (32757) */
	'S', 'P', 'I', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', 'H', 'I', '\0', /* SPI_PERFCOUNTER2_HI (32777) */
	'S', 'P', 'I', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', 'L', 'O', '\0', /* SPI_PERFCOUNTER2_LO (32797) */
	'S', 'P', 'I', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '3', '_', 'H', 'I', '\0', /* SPI_PERFCOUNTER3_HI (32817) */
	'S', 'P', 'I', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '3', '_', 'L', 'O', '\0', /* SPI_PERFCOUNTER3_LO (32837) */
	'S', 'P', 'I', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '4', '_', 'H', 'I', '\0', /* SPI_PERFCOUNTER4_HI (32857) */
	'S', 'P', 'I', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '4', '_', 'L', 'O', '\0', /* SPI_PERFCOUNTER4_LO (32877) */
	'S', 'P', 'I', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '5', '_', 'H', 'I', '\0', /* SPI_PERFCOUNTER5_HI (32897) */
	'S', 'P', 'I', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '5', '_', 'L', 'O', '\0', /* SPI_PERFCOUNTER5_LO (32917) */
	'S', 'Q', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'L', 'O', '\0', /* SQ_PERFCOUNTER0_LO (32937) */
	'S', 'Q', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'H', 'I', '\0', /* SQ_PERFCOUNTER0_HI (32956) */
	'S', 'Q', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'L', 'O', '\0', /* SQ_PERFCOUNTER1_LO (32975) */
	'S', 'Q', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'H', 'I', '\0', /* SQ_PERFCOUNTER1_HI (32994) */
	'S', 'Q', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', 'L', 'O', '\0', /* SQ_PERFCOUNTER2_LO (33013) */
	'S', 'Q', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', 'H', 'I', '\0', /* SQ_PERFCOUNTER2_HI (33032) */
	'S', 'Q', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '3', '_', 'L', 'O', '\0', /* SQ_PERFCOUNTER3_LO (33051) */
	'S', 'Q', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '3', '_', 'H', 'I', '\0', /* SQ_PERFCOUNTER3_HI (33070) */
	'S', 'Q', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '4', '_', 'L', 'O', '\0', /* SQ_PERFCOUNTER4_LO (33089) */
	'S', 'Q', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '4', '_', 'H', 'I', '\0', /* SQ_PERFCOUNTER4_HI (33108) */
	'S', 'Q', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '5', '_', 'L', 'O', '\0', /* SQ_PERFCOUNTER5_LO (33127) */
	'S', 'Q', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '5', '_', 'H', 'I', '\0', /* SQ_PERFCOUNTER5_HI (33146) */
	'S', 'Q', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '6', '_', 'L', 'O', '\0', /* SQ_PERFCOUNTER6_LO (33165) */
	'S', 'Q', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '6', '_', 'H', 'I', '\0', /* SQ_PERFCOUNTER6_HI (33184) */
	'S', 'Q', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '7', '_', 'L', 'O', '\0', /* SQ_PERFCOUNTER7_LO (33203) */
	'S', 'Q', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '7', '_', 'H', 'I', '\0', /* SQ_PERFCOUNTER7_HI (33222) */
	'S', 'Q', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '8', '_', 'L', 'O', '\0', /* SQ_PERFCOUNTER8_LO (33241) */
	'S', 'Q', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '8', '_', 'H', 'I', '\0', /* SQ_PERFCOUNTER8_HI (33260) */
	'S', 'Q', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '9', '_', 'L', 'O', '\0', /* SQ_PERFCOUNTER9_LO (33279) */
	'S', 'Q', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '9', '_', 'H', 'I', '\0', /* SQ_PERFCOUNTER9_HI (33298) */
	'S', 'Q', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '0', '_', 'L', 'O', '\0', /* SQ_PERFCOUNTER10_LO (33317) */
	'S', 'Q', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '0', '_', 'H', 'I', '\0', /* SQ_PERFCOUNTER10_HI (33337) */
	'S', 'Q', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '1', '_', 'L', 'O', '\0', /* SQ_PERFCOUNTER11_LO (33357) */
	'S', 'Q', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '1', '_', 'H', 'I', '\0', /* SQ_PERFCOUNTER11_HI (33377) */
	'S', 'Q', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '2', '_', 'L', 'O', '\0', /* SQ_PERFCOUNTER12_LO (33397) */
	'S', 'Q', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '2', '_', 'H', 'I', '\0', /* SQ_PERFCOUNTER12_HI (33417) */
	'S', 'Q', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '3', '_', 'L', 'O', '\0', /* SQ_PERFCOUNTER13_LO (33437) */
	'S', 'Q', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '3', '_', 'H', 'I', '\0', /* SQ_PERFCOUNTER13_HI (33457) */
	'S', 'Q', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '4', '_', 'L', 'O', '\0', /* SQ_PERFCOUNTER14_LO (33477) */
	'S', 'Q', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '4', '_', 'H', 'I', '\0', /* SQ_PERFCOUNTER14_HI (33497) */
	'S', 'Q', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '5', '_', 'L', 'O', '\0', /* SQ_PERFCOUNTER15_LO (33517) */
	'S', 'Q', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '5', '_', 'H', 'I', '\0', /* SQ_PERFCOUNTER15_HI (33537) */
	'S', 'X', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'L', 'O', '\0', /* SX_PERFCOUNTER0_LO (33557) */
	'S', 'X', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'H', 'I', '\0', /* SX_PERFCOUNTER0_HI (33576) */
	'S', 'X', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'L', 'O', '\0', /* SX_PERFCOUNTER1_LO (33595) */
	'S', 'X', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'H', 'I', '\0', /* SX_PERFCOUNTER1_HI (33614) */
	'S', 'X', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', 'L', 'O', '\0', /* SX_PERFCOUNTER2_LO (33633) */
	'S', 'X', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', 'H', 'I', '\0', /* SX_PERFCOUNTER2_HI (33652) */
	'S', 'X', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '3', '_', 'L', 'O', '\0', /* SX_PERFCOUNTER3_LO (33671) */
	'S', 'X', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '3', '_', 'H', 'I', '\0', /* SX_PERFCOUNTER3_HI (33690) */
	'G', 'C', 'E', 'A', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', 'L', 'O', '\0', /* GCEA_PERFCOUNTER2_LO (33709) */
	'G', 'C', 'E', 'A', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', 'H', 'I', '\0', /* GCEA_PERFCOUNTER2_HI (33730) */
	'G', 'D', 'S', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'L', 'O', '\0', /* GDS_PERFCOUNTER0_LO (33751) */
	'G', 'D', 'S', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'H', 'I', '\0', /* GDS_PERFCOUNTER0_HI (33771) */
	'G', 'D', 'S', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'L', 'O', '\0', /* GDS_PERFCOUNTER1_LO (33791) */
	'G', 'D', 'S', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'H', 'I', '\0', /* GDS_PERFCOUNTER1_HI (33811) */
	'G', 'D', 'S', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', 'L', 'O', '\0', /* GDS_PERFCOUNTER2_LO (33831) */
	'G', 'D', 'S', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', 'H', 'I', '\0', /* GDS_PERFCOUNTER2_HI (33851) */
	'G', 'D', 'S', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '3', '_', 'L', 'O', '\0', /* GDS_PERFCOUNTER3_LO (33871) */
	'G', 'D', 'S', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '3', '_', 'H', 'I', '\0', /* GDS_PERFCOUNTER3_HI (33891) */
	'T', 'A', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'L', 'O', '\0', /* TA_PERFCOUNTER0_LO (33911) */
	'T', 'A', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'H', 'I', '\0', /* TA_PERFCOUNTER0_HI (33930) */
	'T', 'A', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'L', 'O', '\0', /* TA_PERFCOUNTER1_LO (33949) */
	'T', 'A', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'H', 'I', '\0', /* TA_PERFCOUNTER1_HI (33968) */
	'T', 'D', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'L', 'O', '\0', /* TD_PERFCOUNTER0_LO (33987) */
	'T', 'D', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'H', 'I', '\0', /* TD_PERFCOUNTER0_HI (34006) */
	'T', 'D', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'L', 'O', '\0', /* TD_PERFCOUNTER1_LO (34025) */
	'T', 'D', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'H', 'I', '\0', /* TD_PERFCOUNTER1_HI (34044) */
	'T', 'C', 'P', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'L', 'O', '\0', /* TCP_PERFCOUNTER0_LO (34063) */
	'T', 'C', 'P', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'H', 'I', '\0', /* TCP_PERFCOUNTER0_HI (34083) */
	'T', 'C', 'P', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'L', 'O', '\0', /* TCP_PERFCOUNTER1_LO (34103) */
	'T', 'C', 'P', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'H', 'I', '\0', /* TCP_PERFCOUNTER1_HI (34123) */
	'T', 'C', 'P', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', 'L', 'O', '\0', /* TCP_PERFCOUNTER2_LO (34143) */
	'T', 'C', 'P', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', 'H', 'I', '\0', /* TCP_PERFCOUNTER2_HI (34163) */
	'T', 'C', 'P', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '3', '_', 'L', 'O', '\0', /* TCP_PERFCOUNTER3_LO (34183) */
	'T', 'C', 'P', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '3', '_', 'H', 'I', '\0', /* TCP_PERFCOUNTER3_HI (34203) */
	'G', 'L', '2', 'C', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'L', 'O', '\0', /* GL2C_PERFCOUNTER0_LO (34223) */
	'G', 'L', '2', 'C', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'H', 'I', '\0', /* GL2C_PERFCOUNTER0_HI (34244) */
	'G', 'L', '2', 'C', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'L', 'O', '\0', /* GL2C_PERFCOUNTER1_LO (34265) */
	'G', 'L', '2', 'C', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'H', 'I', '\0', /* GL2C_PERFCOUNTER1_HI (34286) */
	'G', 'L', '2', 'C', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', 'L', 'O', '\0', /* GL2C_PERFCOUNTER2_LO (34307) */
	'G', 'L', '2', 'C', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', 'H', 'I', '\0', /* GL2C_PERFCOUNTER2_HI (34328) */
	'G', 'L', '2', 'C', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '3', '_', 'L', 'O', '\0', /* GL2C_PERFCOUNTER3_LO (34349) */
	'G', 'L', '2', 'C', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '3', '_', 'H', 'I', '\0', /* GL2C_PERFCOUNTER3_HI (34370) */
	'G', 'L', '2', 'A', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'L', 'O', '\0', /* GL2A_PERFCOUNTER0_LO (34391) */
	'G', 'L', '2', 'A', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'H', 'I', '\0', /* GL2A_PERFCOUNTER0_HI (34412) */
	'G', 'L', '2', 'A', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'L', 'O', '\0', /* GL2A_PERFCOUNTER1_LO (34433) */
	'G', 'L', '2', 'A', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'H', 'I', '\0', /* GL2A_PERFCOUNTER1_HI (34454) */
	'G', 'L', '2', 'A', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', 'L', 'O', '\0', /* GL2A_PERFCOUNTER2_LO (34475) */
	'G', 'L', '2', 'A', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', 'H', 'I', '\0', /* GL2A_PERFCOUNTER2_HI (34496) */
	'G', 'L', '2', 'A', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '3', '_', 'L', 'O', '\0', /* GL2A_PERFCOUNTER3_LO (34517) */
	'G', 'L', '2', 'A', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '3', '_', 'H', 'I', '\0', /* GL2A_PERFCOUNTER3_HI (34538) */
	'G', 'L', '1', 'C', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'L', 'O', '\0', /* GL1C_PERFCOUNTER0_LO (34559) */
	'G', 'L', '1', 'C', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'H', 'I', '\0', /* GL1C_PERFCOUNTER0_HI (34580) */
	'G', 'L', '1', 'C', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'L', 'O', '\0', /* GL1C_PERFCOUNTER1_LO (34601) */
	'G', 'L', '1', 'C', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'H', 'I', '\0', /* GL1C_PERFCOUNTER1_HI (34622) */
	'G', 'L', '1', 'C', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', 'L', 'O', '\0', /* GL1C_PERFCOUNTER2_LO (34643) */
	'G', 'L', '1', 'C', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', 'H', 'I', '\0', /* GL1C_PERFCOUNTER2_HI (34664) */
	'G', 'L', '1', 'C', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '3', '_', 'L', 'O', '\0', /* GL1C_PERFCOUNTER3_LO (34685) */
	'G', 'L', '1', 'C', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '3', '_', 'H', 'I', '\0', /* GL1C_PERFCOUNTER3_HI (34706) */
	'C', 'H', 'C', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'L', 'O', '\0', /* CHC_PERFCOUNTER0_LO (34727) */
	'C', 'H', 'C', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'H', 'I', '\0', /* CHC_PERFCOUNTER0_HI (34747) */
	'C', 'H', 'C', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'L', 'O', '\0', /* CHC_PERFCOUNTER1_LO (34767) */
	'C', 'H', 'C', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'H', 'I', '\0', /* CHC_PERFCOUNTER1_HI (34787) */
	'C', 'H', 'C', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', 'L', 'O', '\0', /* CHC_PERFCOUNTER2_LO (34807) */
	'C', 'H', 'C', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', 'H', 'I', '\0', /* CHC_PERFCOUNTER2_HI (34827) */
	'C', 'H', 'C', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '3', '_', 'L', 'O', '\0', /* CHC_PERFCOUNTER3_LO (34847) */
	'C', 'H', 'C', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '3', '_', 'H', 'I', '\0', /* CHC_PERFCOUNTER3_HI (34867) */
	'C', 'H', 'C', 'G', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'L', 'O', '\0', /* CHCG_PERFCOUNTER0_LO (34887) */
	'C', 'H', 'C', 'G', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'H', 'I', '\0', /* CHCG_PERFCOUNTER0_HI (34908) */
	'C', 'H', 'C', 'G', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'L', 'O', '\0', /* CHCG_PERFCOUNTER1_LO (34929) */
	'C', 'H', 'C', 'G', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'H', 'I', '\0', /* CHCG_PERFCOUNTER1_HI (34950) */
	'C', 'H', 'C', 'G', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', 'L', 'O', '\0', /* CHCG_PERFCOUNTER2_LO (34971) */
	'C', 'H', 'C', 'G', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', 'H', 'I', '\0', /* CHCG_PERFCOUNTER2_HI (34992) */
	'C', 'H', 'C', 'G', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '3', '_', 'L', 'O', '\0', /* CHCG_PERFCOUNTER3_LO (35013) */
	'C', 'H', 'C', 'G', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '3', '_', 'H', 'I', '\0', /* CHCG_PERFCOUNTER3_HI (35034) */
	'C', 'B', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'L', 'O', '\0', /* CB_PERFCOUNTER0_LO (35055) */
	'C', 'B', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'H', 'I', '\0', /* CB_PERFCOUNTER0_HI (35074) */
	'C', 'B', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'L', 'O', '\0', /* CB_PERFCOUNTER1_LO (35093) */
	'C', 'B', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'H', 'I', '\0', /* CB_PERFCOUNTER1_HI (35112) */
	'C', 'B', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', 'L', 'O', '\0', /* CB_PERFCOUNTER2_LO (35131) */
	'C', 'B', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', 'H', 'I', '\0', /* CB_PERFCOUNTER2_HI (35150) */
	'C', 'B', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '3', '_', 'L', 'O', '\0', /* CB_PERFCOUNTER3_LO (35169) */
	'C', 'B', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '3', '_', 'H', 'I', '\0', /* CB_PERFCOUNTER3_HI (35188) */
	'D', 'B', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'L', 'O', '\0', /* DB_PERFCOUNTER0_LO (35207) */
	'D', 'B', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'H', 'I', '\0', /* DB_PERFCOUNTER0_HI (35226) */
	'D', 'B', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'L', 'O', '\0', /* DB_PERFCOUNTER1_LO (35245) */
	'D', 'B', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'H', 'I', '\0', /* DB_PERFCOUNTER1_HI (35264) */
	'D', 'B', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', 'L', 'O', '\0', /* DB_PERFCOUNTER2_LO (35283) */
	'D', 'B', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', 'H', 'I', '\0', /* DB_PERFCOUNTER2_HI (35302) */
	'D', 'B', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '3', '_', 'L', 'O', '\0', /* DB_PERFCOUNTER3_LO (35321) */
	'D', 'B', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '3', '_', 'H', 'I', '\0', /* DB_PERFCOUNTER3_HI (35340) */
	'R', 'L', 'C', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'L', 'O', '\0', /* RLC_PERFCOUNTER0_LO (35359) */
	'R', 'L', 'C', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'H', 'I', '\0', /* RLC_PERFCOUNTER0_HI (35379) */
	'R', 'L', 'C', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'L', 'O', '\0', /* RLC_PERFCOUNTER1_LO (35399) */
	'R', 'L', 'C', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'H', 'I', '\0', /* RLC_PERFCOUNTER1_HI (35419) */
	'R', 'M', 'I', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'L', 'O', '\0', /* RMI_PERFCOUNTER0_LO (35439) */
	'R', 'M', 'I', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'H', 'I', '\0', /* RMI_PERFCOUNTER0_HI (35459) */
	'R', 'M', 'I', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'L', 'O', '\0', /* RMI_PERFCOUNTER1_LO (35479) */
	'R', 'M', 'I', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'H', 'I', '\0', /* RMI_PERFCOUNTER1_HI (35499) */
	'R', 'M', 'I', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', 'L', 'O', '\0', /* RMI_PERFCOUNTER2_LO (35519) */
	'R', 'M', 'I', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', 'H', 'I', '\0', /* RMI_PERFCOUNTER2_HI (35539) */
	'R', 'M', 'I', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '3', '_', 'L', 'O', '\0', /* RMI_PERFCOUNTER3_LO (35559) */
	'R', 'M', 'I', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '3', '_', 'H', 'I', '\0', /* RMI_PERFCOUNTER3_HI (35579) */
	'G', 'C', '_', 'A', 'T', 'C', '_', 'L', '2', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '_', 'L', 'O', '\0', /* GC_ATC_L2_PERFCOUNTER_LO (35599, 35602) */
	'G', 'C', '_', 'A', 'T', 'C', '_', 'L', '2', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '_', 'H', 'I', '\0', /* GC_ATC_L2_PERFCOUNTER_HI (35624, 35627) */
	'G', 'C', 'M', 'C', '_', 'V', 'M', '_', 'L', '2', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '_', 'L', 'O', '\0', /* GCMC_VM_L2_PERFCOUNTER_LO (35649, 35651) */
	'G', 'C', 'M', 'C', '_', 'V', 'M', '_', 'L', '2', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '_', 'H', 'I', '\0', /* GCMC_VM_L2_PERFCOUNTER_HI (35675, 35677) */
	'G', 'C', 'V', 'M', 'L', '2', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', '0', '_', 'L', 'O', '\0', /* GCVML2_PERFCOUNTER2_0_LO (35701) */
	'G', 'C', 'V', 'M', 'L', '2', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', '1', '_', 'L', 'O', '\0', /* GCVML2_PERFCOUNTER2_1_LO (35726) */
	'G', 'C', 'V', 'M', 'L', '2', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', '0', '_', 'H', 'I', '\0', /* GCVML2_PERFCOUNTER2_0_HI (35751) */
	'G', 'C', 'V', 'M', 'L', '2', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', '1', '_', 'H', 'I', '\0', /* GCVML2_PERFCOUNTER2_1_HI (35776) */
	'G', 'C', '_', 'A', 'T', 'C', '_', 'L', '2', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', 'L', 'O', '\0', /* GC_ATC_L2_PERFCOUNTER2_LO (35801) */
	'G', 'C', '_', 'A', 'T', 'C', '_', 'L', '2', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', 'H', 'I', '\0', /* GC_ATC_L2_PERFCOUNTER2_HI (35827) */
	'U', 'T', 'C', 'L', '1', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'L', 'O', '\0', /* UTCL1_PERFCOUNTER0_LO (35853) */
	'U', 'T', 'C', 'L', '1', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'H', 'I', '\0', /* UTCL1_PERFCOUNTER0_HI (35875) */
	'U', 'T', 'C', 'L', '1', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'L', 'O', '\0', /* UTCL1_PERFCOUNTER1_LO (35897) */
	'U', 'T', 'C', 'L', '1', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'H', 'I', '\0', /* UTCL1_PERFCOUNTER1_HI (35919) */
	'G', 'C', 'R', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'L', 'O', '\0', /* GCR_PERFCOUNTER0_LO (35941) */
	'G', 'C', 'R', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'H', 'I', '\0', /* GCR_PERFCOUNTER0_HI (35961) */
	'G', 'C', 'R', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'L', 'O', '\0', /* GCR_PERFCOUNTER1_LO (35981) */
	'G', 'C', 'R', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'H', 'I', '\0', /* GCR_PERFCOUNTER1_HI (36001) */
	'P', 'A', '_', 'P', 'H', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'L', 'O', '\0', /* PA_PH_PERFCOUNTER0_LO (36021) */
	'P', 'A', '_', 'P', 'H', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'H', 'I', '\0', /* PA_PH_PERFCOUNTER0_HI (36043) */
	'P', 'A', '_', 'P', 'H', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'L', 'O', '\0', /* PA_PH_PERFCOUNTER1_LO (36065) */
	'P', 'A', '_', 'P', 'H', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'H', 'I', '\0', /* PA_PH_PERFCOUNTER1_HI (36087) */
	'P', 'A', '_', 'P', 'H', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', 'L', 'O', '\0', /* PA_PH_PERFCOUNTER2_LO (36109) */
	'P', 'A', '_', 'P', 'H', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', 'H', 'I', '\0', /* PA_PH_PERFCOUNTER2_HI (36131) */
	'P', 'A', '_', 'P', 'H', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '3', '_', 'L', 'O', '\0', /* PA_PH_PERFCOUNTER3_LO (36153) */
	'P', 'A', '_', 'P', 'H', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '3', '_', 'H', 'I', '\0', /* PA_PH_PERFCOUNTER3_HI (36175) */
	'P', 'A', '_', 'P', 'H', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '4', '_', 'L', 'O', '\0', /* PA_PH_PERFCOUNTER4_LO (36197) */
	'P', 'A', '_', 'P', 'H', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '4', '_', 'H', 'I', '\0', /* PA_PH_PERFCOUNTER4_HI (36219) */
	'P', 'A', '_', 'P', 'H', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '5', '_', 'L', 'O', '\0', /* PA_PH_PERFCOUNTER5_LO (36241) */
	'P', 'A', '_', 'P', 'H', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '5', '_', 'H', 'I', '\0', /* PA_PH_PERFCOUNTER5_HI (36263) */
	'P', 'A', '_', 'P', 'H', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '6', '_', 'L', 'O', '\0', /* PA_PH_PERFCOUNTER6_LO (36285) */
	'P', 'A', '_', 'P', 'H', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '6', '_', 'H', 'I', '\0', /* PA_PH_PERFCOUNTER6_HI (36307) */
	'P', 'A', '_', 'P', 'H', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '7', '_', 'L', 'O', '\0', /* PA_PH_PERFCOUNTER7_LO (36329) */
	'P', 'A', '_', 'P', 'H', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '7', '_', 'H', 'I', '\0', /* PA_PH_PERFCOUNTER7_HI (36351) */
	'G', 'L', '1', 'A', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'L', 'O', '\0', /* GL1A_PERFCOUNTER0_LO (36373) */
	'G', 'L', '1', 'A', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'H', 'I', '\0', /* GL1A_PERFCOUNTER0_HI (36394) */
	'G', 'L', '1', 'A', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'L', 'O', '\0', /* GL1A_PERFCOUNTER1_LO (36415) */
	'G', 'L', '1', 'A', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'H', 'I', '\0', /* GL1A_PERFCOUNTER1_HI (36436) */
	'G', 'L', '1', 'A', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', 'L', 'O', '\0', /* GL1A_PERFCOUNTER2_LO (36457) */
	'G', 'L', '1', 'A', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', 'H', 'I', '\0', /* GL1A_PERFCOUNTER2_HI (36478) */
	'G', 'L', '1', 'A', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '3', '_', 'L', 'O', '\0', /* GL1A_PERFCOUNTER3_LO (36499) */
	'G', 'L', '1', 'A', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '3', '_', 'H', 'I', '\0', /* GL1A_PERFCOUNTER3_HI (36520) */
	'C', 'H', 'A', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'L', 'O', '\0', /* CHA_PERFCOUNTER0_LO (36541) */
	'C', 'H', 'A', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'H', 'I', '\0', /* CHA_PERFCOUNTER0_HI (36561) */
	'C', 'H', 'A', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'L', 'O', '\0', /* CHA_PERFCOUNTER1_LO (36581) */
	'C', 'H', 'A', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'H', 'I', '\0', /* CHA_PERFCOUNTER1_HI (36601) */
	'C', 'H', 'A', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', 'L', 'O', '\0', /* CHA_PERFCOUNTER2_LO (36621) */
	'C', 'H', 'A', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', 'H', 'I', '\0', /* CHA_PERFCOUNTER2_HI (36641) */
	'C', 'H', 'A', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '3', '_', 'L', 'O', '\0', /* CHA_PERFCOUNTER3_LO (36661) */
	'C', 'H', 'A', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '3', '_', 'H', 'I', '\0', /* CHA_PERFCOUNTER3_HI (36681) */
	'G', 'U', 'S', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', 'L', 'O', '\0', /* GUS_PERFCOUNTER2_LO (36701) */
	'G', 'U', 'S', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', 'H', 'I', '\0', /* GUS_PERFCOUNTER2_HI (36721) */
	'C', 'P', 'G', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* CPG_PERFCOUNTER1_SELECT (36741) */
	'C', 'P', 'G', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'S', 'E', 'L', 'E', 'C', 'T', '1', '\0', /* CPG_PERFCOUNTER0_SELECT1 (36765) */
	'C', 'P', 'G', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* CPG_PERFCOUNTER0_SELECT (36790) */
	'C', 'P', 'C', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* CPC_PERFCOUNTER1_SELECT (36814, 36815) */
	'C', 'P', 'C', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'S', 'E', 'L', 'E', 'C', 'T', '1', '\0', /* CPC_PERFCOUNTER0_SELECT1 (36838, 36839) */
	'C', 'P', 'F', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* CPF_PERFCOUNTER1_SELECT (36863) */
	'C', 'P', 'F', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'S', 'E', 'L', 'E', 'C', 'T', '1', '\0', /* CPF_PERFCOUNTER0_SELECT1 (36887) */
	'C', 'P', 'F', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* CPF_PERFCOUNTER0_SELECT (36912) */
	'C', 'P', '_', 'P', 'E', 'R', 'F', 'M', 'O', 'N', '_', 'C', 'N', 'T', 'L', '\0', /* CP_PERFMON_CNTL (36936) */
	'C', 'P', 'C', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* CPC_PERFCOUNTER0_SELECT (36952, 36953) */
	'C', 'P', 'F', '_', 'T', 'C', '_', 'P', 'E', 'R', 'F', '_', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '_', 'W', 'I', 'N', 'D', 'O', 'W', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* CPF_TC_PERF_COUNTER_WINDOW_SELECT (36976) */
	'C', 'P', 'G', '_', 'T', 'C', '_', 'P', 'E', 'R', 'F', '_', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '_', 'W', 'I', 'N', 'D', 'O', 'W', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* CPG_TC_PERF_COUNTER_WINDOW_SELECT (37010) */
	'C', 'P', 'F', '_', 'L', 'A', 'T', 'E', 'N', 'C', 'Y', '_', 'S', 'T', 'A', 'T', 'S', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* CPF_LATENCY_STATS_SELECT (37044, 37059) */
	'C', 'P', 'G', '_', 'L', 'A', 'T', 'E', 'N', 'C', 'Y', '_', 'S', 'T', 'A', 'T', 'S', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* CPG_LATENCY_STATS_SELECT (37069) */
	'C', 'P', 'C', '_', 'L', 'A', 'T', 'E', 'N', 'C', 'Y', '_', 'S', 'T', 'A', 'T', 'S', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* CPC_LATENCY_STATS_SELECT (37094) */
	'C', 'P', '_', 'D', 'R', 'A', 'W', '_', 'O', 'B', 'J', 'E', 'C', 'T', '\0', /* CP_DRAW_OBJECT (37119) */
	'C', 'P', '_', 'D', 'R', 'A', 'W', '_', 'O', 'B', 'J', 'E', 'C', 'T', '_', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '\0', /* CP_DRAW_OBJECT_COUNTER (37134) */
	'C', 'P', '_', 'D', 'R', 'A', 'W', '_', 'W', 'I', 'N', 'D', 'O', 'W', '_', 'M', 'A', 'S', 'K', '_', 'H', 'I', '\0', /* CP_DRAW_WINDOW_MASK_HI (37157) */
	'C', 'P', '_', 'D', 'R', 'A', 'W', '_', 'W', 'I', 'N', 'D', 'O', 'W', '_', 'H', 'I', '\0', /* CP_DRAW_WINDOW_HI (37180) */
	'C', 'P', '_', 'D', 'R', 'A', 'W', '_', 'W', 'I', 'N', 'D', 'O', 'W', '_', 'L', 'O', '\0', /* CP_DRAW_WINDOW_LO (37198) */
	'C', 'P', '_', 'D', 'R', 'A', 'W', '_', 'W', 'I', 'N', 'D', 'O', 'W', '_', 'C', 'N', 'T', 'L', '\0', /* CP_DRAW_WINDOW_CNTL (37216) */
	'G', 'R', 'B', 'M', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* GRBM_PERFCOUNTER0_SELECT (37236) */
	'G', 'R', 'B', 'M', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* GRBM_PERFCOUNTER1_SELECT (37261) */
	'G', 'R', 'B', 'M', '_', 'S', 'E', '0', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* GRBM_SE0_PERFCOUNTER_SELECT (37286, 37295) */
	'G', 'R', 'B', 'M', '_', 'S', 'E', '1', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* GRBM_SE1_PERFCOUNTER_SELECT (37314) */
	'G', 'R', 'B', 'M', '_', 'S', 'E', '2', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* GRBM_SE2_PERFCOUNTER_SELECT (37342) */
	'G', 'R', 'B', 'M', '_', 'S', 'E', '3', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* GRBM_SE3_PERFCOUNTER_SELECT (37370) */
	'G', 'R', 'B', 'M', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'S', 'E', 'L', 'E', 'C', 'T', '_', 'H', 'I', '\0', /* GRBM_PERFCOUNTER0_SELECT_HI (37398) */
	'G', 'R', 'B', 'M', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'S', 'E', 'L', 'E', 'C', 'T', '_', 'H', 'I', '\0', /* GRBM_PERFCOUNTER1_SELECT_HI (37426) */
	'G', 'E', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* GE_PERFCOUNTER0_SELECT (37454) */
	'G', 'E', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'S', 'E', 'L', 'E', 'C', 'T', '1', '\0', /* GE_PERFCOUNTER0_SELECT1 (37477) */
	'G', 'E', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* GE_PERFCOUNTER1_SELECT (37501) */
	'G', 'E', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'S', 'E', 'L', 'E', 'C', 'T', '1', '\0', /* GE_PERFCOUNTER1_SELECT1 (37524) */
	'G', 'E', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* GE_PERFCOUNTER2_SELECT (37548) */
	'G', 'E', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', 'S', 'E', 'L', 'E', 'C', 'T', '1', '\0', /* GE_PERFCOUNTER2_SELECT1 (37571) */
	'G', 'E', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '3', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* GE_PERFCOUNTER3_SELECT (37595) */
	'G', 'E', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '3', '_', 'S', 'E', 'L', 'E', 'C', 'T', '1', '\0', /* GE_PERFCOUNTER3_SELECT1 (37618) */
	'G', 'E', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '4', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* GE_PERFCOUNTER4_SELECT (37642) */
	'G', 'E', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '5', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* GE_PERFCOUNTER5_SELECT (37665) */
	'G', 'E', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '6', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* GE_PERFCOUNTER6_SELECT (37688) */
	'G', 'E', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '7', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* GE_PERFCOUNTER7_SELECT (37711) */
	'G', 'E', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '8', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* GE_PERFCOUNTER8_SELECT (37734) */
	'G', 'E', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '9', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* GE_PERFCOUNTER9_SELECT (37757) */
	'G', 'E', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '0', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* GE_PERFCOUNTER10_SELECT (37780) */
	'G', 'E', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '1', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* GE_PERFCOUNTER11_SELECT (37804) */
	'P', 'A', '_', 'S', 'U', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* PA_SU_PERFCOUNTER0_SELECT (37828) */
	'P', 'A', '_', 'S', 'U', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'S', 'E', 'L', 'E', 'C', 'T', '1', '\0', /* PA_SU_PERFCOUNTER0_SELECT1 (37854) */
	'P', 'A', '_', 'S', 'U', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* PA_SU_PERFCOUNTER1_SELECT (37881) */
	'P', 'A', '_', 'S', 'U', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'S', 'E', 'L', 'E', 'C', 'T', '1', '\0', /* PA_SU_PERFCOUNTER1_SELECT1 (37907) */
	'P', 'A', '_', 'S', 'U', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* PA_SU_PERFCOUNTER2_SELECT (37934) */
	'P', 'A', '_', 'S', 'U', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', 'S', 'E', 'L', 'E', 'C', 'T', '1', '\0', /* PA_SU_PERFCOUNTER2_SELECT1 (37960) */
	'P', 'A', '_', 'S', 'U', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '3', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* PA_SU_PERFCOUNTER3_SELECT (37987) */
	'P', 'A', '_', 'S', 'U', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '3', '_', 'S', 'E', 'L', 'E', 'C', 'T', '1', '\0', /* PA_SU_PERFCOUNTER3_SELECT1 (38013) */
	'P', 'A', '_', 'S', 'C', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* PA_SC_PERFCOUNTER0_SELECT (38040) */
	'P', 'A', '_', 'S', 'C', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'S', 'E', 'L', 'E', 'C', 'T', '1', '\0', /* PA_SC_PERFCOUNTER0_SELECT1 (38066) */
	'P', 'A', '_', 'S', 'C', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* PA_SC_PERFCOUNTER1_SELECT (38093) */
	'P', 'A', '_', 'S', 'C', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* PA_SC_PERFCOUNTER2_SELECT (38119) */
	'P', 'A', '_', 'S', 'C', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '3', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* PA_SC_PERFCOUNTER3_SELECT (38145) */
	'P', 'A', '_', 'S', 'C', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '4', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* PA_SC_PERFCOUNTER4_SELECT (38171) */
	'P', 'A', '_', 'S', 'C', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '5', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* PA_SC_PERFCOUNTER5_SELECT (38197) */
	'P', 'A', '_', 'S', 'C', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '6', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* PA_SC_PERFCOUNTER6_SELECT (38223) */
	'P', 'A', '_', 'S', 'C', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '7', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* PA_SC_PERFCOUNTER7_SELECT (38249) */
	'S', 'P', 'I', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* SPI_PERFCOUNTER0_SELECT (38275) */
	'S', 'P', 'I', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* SPI_PERFCOUNTER1_SELECT (38299) */
	'S', 'P', 'I', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* SPI_PERFCOUNTER2_SELECT (38323) */
	'S', 'P', 'I', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '3', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* SPI_PERFCOUNTER3_SELECT (38347) */
	'S', 'P', 'I', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'S', 'E', 'L', 'E', 'C', 'T', '1', '\0', /* SPI_PERFCOUNTER0_SELECT1 (38371) */
	'S', 'P', 'I', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'S', 'E', 'L', 'E', 'C', 'T', '1', '\0', /* SPI_PERFCOUNTER1_SELECT1 (38396) */
	'S', 'P', 'I', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', 'S', 'E', 'L', 'E', 'C', 'T', '1', '\0', /* SPI_PERFCOUNTER2_SELECT1 (38421) */
	'S', 'P', 'I', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '3', '_', 'S', 'E', 'L', 'E', 'C', 'T', '1', '\0', /* SPI_PERFCOUNTER3_SELECT1 (38446) */
	'S', 'P', 'I', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '4', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* SPI_PERFCOUNTER4_SELECT (38471) */
	'S', 'P', 'I', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '5', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* SPI_PERFCOUNTER5_SELECT (38495) */
	'S', 'P', 'I', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '_', 'B', 'I', 'N', 'S', '\0', /* SPI_PERFCOUNTER_BINS (38519) */
	'S', 'Q', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* SQ_PERFCOUNTER0_SELECT (38540) */
	'S', 'Q', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* SQ_PERFCOUNTER1_SELECT (38563) */
	'S', 'Q', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* SQ_PERFCOUNTER2_SELECT (38586) */
	'S', 'Q', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '3', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* SQ_PERFCOUNTER3_SELECT (38609) */
	'S', 'Q', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '4', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* SQ_PERFCOUNTER4_SELECT (38632) */
	'S', 'Q', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '5', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* SQ_PERFCOUNTER5_SELECT (38655) */
	'S', 'Q', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '6', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* SQ_PERFCOUNTER6_SELECT (38678) */
	'S', 'Q', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '7', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* SQ_PERFCOUNTER7_SELECT (38701) */
	'S', 'Q', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '8', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* SQ_PERFCOUNTER8_SELECT (38724) */
	'S', 'Q', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '9', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* SQ_PERFCOUNTER9_SELECT (38747) */
	'S', 'Q', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '0', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* SQ_PERFCOUNTER10_SELECT (38770) */
	'S', 'Q', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '1', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* SQ_PERFCOUNTER11_SELECT (38794) */
	'S', 'Q', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '2', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* SQ_PERFCOUNTER12_SELECT (38818) */
	'S', 'Q', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '3', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* SQ_PERFCOUNTER13_SELECT (38842) */
	'S', 'Q', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '4', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* SQ_PERFCOUNTER14_SELECT (38866) */
	'S', 'Q', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '5', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* SQ_PERFCOUNTER15_SELECT (38890) */
	'S', 'Q', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '_', 'C', 'T', 'R', 'L', '\0', /* SQ_PERFCOUNTER_CTRL (38914) */
	'S', 'Q', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '_', 'C', 'T', 'R', 'L', '2', '\0', /* SQ_PERFCOUNTER_CTRL2 (38934) */
	'G', 'C', 'E', 'A', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* GCEA_PERFCOUNTER2_SELECT (38955) */
	'G', 'C', 'E', 'A', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', 'S', 'E', 'L', 'E', 'C', 'T', '1', '\0', /* GCEA_PERFCOUNTER2_SELECT1 (38980) */
	'G', 'C', 'E', 'A', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', 'M', 'O', 'D', 'E', '\0', /* GCEA_PERFCOUNTER2_MODE (39006) */
	'S', 'X', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* SX_PERFCOUNTER0_SELECT (39029) */
	'S', 'X', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* SX_PERFCOUNTER1_SELECT (39052) */
	'S', 'X', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* SX_PERFCOUNTER2_SELECT (39075) */
	'S', 'X', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '3', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* SX_PERFCOUNTER3_SELECT (39098) */
	'S', 'X', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'S', 'E', 'L', 'E', 'C', 'T', '1', '\0', /* SX_PERFCOUNTER0_SELECT1 (39121) */
	'S', 'X', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'S', 'E', 'L', 'E', 'C', 'T', '1', '\0', /* SX_PERFCOUNTER1_SELECT1 (39145) */
	'G', 'D', 'S', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* GDS_PERFCOUNTER0_SELECT (39169) */
	'G', 'D', 'S', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* GDS_PERFCOUNTER1_SELECT (39193) */
	'G', 'D', 'S', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* GDS_PERFCOUNTER2_SELECT (39217) */
	'G', 'D', 'S', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '3', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* GDS_PERFCOUNTER3_SELECT (39241) */
	'G', 'D', 'S', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'S', 'E', 'L', 'E', 'C', 'T', '1', '\0', /* GDS_PERFCOUNTER0_SELECT1 (39265) */
	'T', 'A', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* TA_PERFCOUNTER0_SELECT (39290) */
	'T', 'A', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'S', 'E', 'L', 'E', 'C', 'T', '1', '\0', /* TA_PERFCOUNTER0_SELECT1 (39313) */
	'T', 'A', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* TA_PERFCOUNTER1_SELECT (39337) */
	'T', 'D', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* TD_PERFCOUNTER0_SELECT (39360) */
	'T', 'D', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'S', 'E', 'L', 'E', 'C', 'T', '1', '\0', /* TD_PERFCOUNTER0_SELECT1 (39383) */
	'T', 'D', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* TD_PERFCOUNTER1_SELECT (39407) */
	'T', 'C', 'P', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* TCP_PERFCOUNTER0_SELECT (39430) */
	'T', 'C', 'P', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'S', 'E', 'L', 'E', 'C', 'T', '1', '\0', /* TCP_PERFCOUNTER0_SELECT1 (39454) */
	'T', 'C', 'P', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* TCP_PERFCOUNTER1_SELECT (39479) */
	'T', 'C', 'P', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'S', 'E', 'L', 'E', 'C', 'T', '1', '\0', /* TCP_PERFCOUNTER1_SELECT1 (39503) */
	'T', 'C', 'P', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* TCP_PERFCOUNTER2_SELECT (39528) */
	'T', 'C', 'P', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '3', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* TCP_PERFCOUNTER3_SELECT (39552) */
	'G', 'L', '2', 'C', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* GL2C_PERFCOUNTER0_SELECT (39576) */
	'G', 'L', '2', 'C', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'S', 'E', 'L', 'E', 'C', 'T', '1', '\0', /* GL2C_PERFCOUNTER0_SELECT1 (39601) */
	'G', 'L', '2', 'C', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* GL2C_PERFCOUNTER1_SELECT (39627) */
	'G', 'L', '2', 'C', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'S', 'E', 'L', 'E', 'C', 'T', '1', '\0', /* GL2C_PERFCOUNTER1_SELECT1 (39652) */
	'G', 'L', '2', 'C', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* GL2C_PERFCOUNTER2_SELECT (39678) */
	'G', 'L', '2', 'C', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '3', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* GL2C_PERFCOUNTER3_SELECT (39703) */
	'G', 'L', '2', 'A', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* GL2A_PERFCOUNTER0_SELECT (39728) */
	'G', 'L', '2', 'A', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'S', 'E', 'L', 'E', 'C', 'T', '1', '\0', /* GL2A_PERFCOUNTER0_SELECT1 (39753) */
	'G', 'L', '2', 'A', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* GL2A_PERFCOUNTER1_SELECT (39779) */
	'G', 'L', '2', 'A', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'S', 'E', 'L', 'E', 'C', 'T', '1', '\0', /* GL2A_PERFCOUNTER1_SELECT1 (39804) */
	'G', 'L', '2', 'A', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* GL2A_PERFCOUNTER2_SELECT (39830) */
	'G', 'L', '2', 'A', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '3', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* GL2A_PERFCOUNTER3_SELECT (39855) */
	'G', 'L', '1', 'C', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* GL1C_PERFCOUNTER0_SELECT (39880) */
	'G', 'L', '1', 'C', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'S', 'E', 'L', 'E', 'C', 'T', '1', '\0', /* GL1C_PERFCOUNTER0_SELECT1 (39905) */
	'G', 'L', '1', 'C', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* GL1C_PERFCOUNTER1_SELECT (39931) */
	'G', 'L', '1', 'C', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* GL1C_PERFCOUNTER2_SELECT (39956) */
	'G', 'L', '1', 'C', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '3', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* GL1C_PERFCOUNTER3_SELECT (39981) */
	'C', 'H', 'C', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* CHC_PERFCOUNTER0_SELECT (40006) */
	'C', 'H', 'C', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'S', 'E', 'L', 'E', 'C', 'T', '1', '\0', /* CHC_PERFCOUNTER0_SELECT1 (40030) */
	'C', 'H', 'C', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* CHC_PERFCOUNTER1_SELECT (40055) */
	'C', 'H', 'C', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* CHC_PERFCOUNTER2_SELECT (40079) */
	'C', 'H', 'C', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '3', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* CHC_PERFCOUNTER3_SELECT (40103) */
	'C', 'H', 'C', 'G', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* CHCG_PERFCOUNTER0_SELECT (40127) */
	'C', 'H', 'C', 'G', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'S', 'E', 'L', 'E', 'C', 'T', '1', '\0', /* CHCG_PERFCOUNTER0_SELECT1 (40152) */
	'C', 'H', 'C', 'G', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* CHCG_PERFCOUNTER1_SELECT (40178) */
	'C', 'H', 'C', 'G', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* CHCG_PERFCOUNTER2_SELECT (40203) */
	'C', 'H', 'C', 'G', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '3', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* CHCG_PERFCOUNTER3_SELECT (40228) */
	'C', 'B', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '_', 'F', 'I', 'L', 'T', 'E', 'R', '\0', /* CB_PERFCOUNTER_FILTER (40253) */
	'C', 'B', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* CB_PERFCOUNTER0_SELECT (40275) */
	'C', 'B', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'S', 'E', 'L', 'E', 'C', 'T', '1', '\0', /* CB_PERFCOUNTER0_SELECT1 (40298) */
	'C', 'B', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* CB_PERFCOUNTER1_SELECT (40322) */
	'C', 'B', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* CB_PERFCOUNTER2_SELECT (40345) */
	'C', 'B', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '3', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* CB_PERFCOUNTER3_SELECT (40368) */
	'D', 'B', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* DB_PERFCOUNTER0_SELECT (40391) */
	'D', 'B', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'S', 'E', 'L', 'E', 'C', 'T', '1', '\0', /* DB_PERFCOUNTER0_SELECT1 (40414) */
	'D', 'B', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* DB_PERFCOUNTER1_SELECT (40438) */
	'D', 'B', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'S', 'E', 'L', 'E', 'C', 'T', '1', '\0', /* DB_PERFCOUNTER1_SELECT1 (40461) */
	'D', 'B', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* DB_PERFCOUNTER2_SELECT (40485) */
	'D', 'B', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '3', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* DB_PERFCOUNTER3_SELECT (40508) */
	'R', 'L', 'C', '_', 'S', 'P', 'M', '_', 'P', 'E', 'R', 'F', 'M', 'O', 'N', '_', 'C', 'N', 'T', 'L', '\0', /* RLC_SPM_PERFMON_CNTL (40531) */
	'R', 'L', 'C', '_', 'S', 'P', 'M', '_', 'P', 'E', 'R', 'F', 'M', 'O', 'N', '_', 'R', 'I', 'N', 'G', '_', 'B', 'A', 'S', 'E', '_', 'L', 'O', '\0', /* RLC_SPM_PERFMON_RING_BASE_LO (40552) */
	'R', 'L', 'C', '_', 'S', 'P', 'M', '_', 'P', 'E', 'R', 'F', 'M', 'O', 'N', '_', 'R', 'I', 'N', 'G', '_', 'B', 'A', 'S', 'E', '_', 'H', 'I', '\0', /* RLC_SPM_PERFMON_RING_BASE_HI (40581, 40597) */
	'R', 'L', 'C', '_', 'S', 'P', 'M', '_', 'P', 'E', 'R', 'F', 'M', 'O', 'N', '_', 'R', 'I', 'N', 'G', '_', 'S', 'I', 'Z', 'E', '\0', /* RLC_SPM_PERFMON_RING_SIZE (40610) */
	'R', 'L', 'C', '_', 'S', 'P', 'M', '_', 'P', 'E', 'R', 'F', 'M', 'O', 'N', '_', 'S', 'E', 'G', 'M', 'E', 'N', 'T', '_', 'S', 'I', 'Z', 'E', '\0', /* RLC_SPM_PERFMON_SEGMENT_SIZE (40636, 40644) */
	'R', 'L', 'C', '_', 'S', 'P', 'M', '_', 'R', 'I', 'N', 'G', '_', 'R', 'D', 'P', 'T', 'R', '\0', /* RLC_SPM_RING_RDPTR (40665) */
	'R', 'L', 'C', '_', 'S', 'P', 'M', '_', 'S', 'E', 'G', 'M', 'E', 'N', 'T', '_', 'T', 'H', 'R', 'E', 'S', 'H', 'O', 'L', 'D', '\0', /* RLC_SPM_SEGMENT_THRESHOLD (40684, 40700) */
	'R', 'L', 'C', '_', 'S', 'P', 'M', '_', 'S', 'E', '_', 'M', 'U', 'X', 'S', 'E', 'L', '_', 'A', 'D', 'D', 'R', '\0', /* RLC_SPM_SE_MUXSEL_ADDR (40710) */
	'R', 'L', 'C', '_', 'S', 'P', 'M', '_', 'S', 'E', '_', 'M', 'U', 'X', 'S', 'E', 'L', '_', 'D', 'A', 'T', 'A', '\0', /* RLC_SPM_SE_MUXSEL_DATA (40733) */
	'R', 'L', 'C', '_', 'S', 'P', 'M', '_', 'G', 'L', 'O', 'B', 'A', 'L', '_', 'M', 'U', 'X', 'S', 'E', 'L', '_', 'A', 'D', 'D', 'R', '\0', /* RLC_SPM_GLOBAL_MUXSEL_ADDR (40756) */
	'R', 'L', 'C', '_', 'S', 'P', 'M', '_', 'G', 'L', 'O', 'B', 'A', 'L', '_', 'M', 'U', 'X', 'S', 'E', 'L', '_', 'D', 'A', 'T', 'A', '\0', /* RLC_SPM_GLOBAL_MUXSEL_DATA (40783) */
	'R', 'L', 'C', '_', 'S', 'P', 'M', '_', 'D', 'E', 'S', 'E', 'R', '_', 'S', 'T', 'A', 'R', 'T', '_', 'S', 'K', 'E', 'W', '\0', /* RLC_SPM_DESER_START_SKEW (40810, 40818) */
	'R', 'L', 'C', '_', 'S', 'P', 'M', '_', 'G', 'L', 'O', 'B', 'A', 'L', 'S', '_', 'S', 'A', 'M', 'P', 'L', 'E', '_', 'S', 'K', 'E', 'W', '\0', /* RLC_SPM_GLOBALS_SAMPLE_SKEW (40835, 40843) */
	'R', 'L', 'C', '_', 'S', 'P', 'M', '_', 'G', 'L', 'O', 'B', 'A', 'L', 'S', '_', 'M', 'U', 'X', 'S', 'E', 'L', '_', 'S', 'K', 'E', 'W', '\0', /* RLC_SPM_GLOBALS_MUXSEL_SKEW (40863, 40871) */
	'R', 'L', 'C', '_', 'S', 'P', 'M', '_', 'S', 'E', '_', 'S', 'A', 'M', 'P', 'L', 'E', '_', 'S', 'K', 'E', 'W', '\0', /* RLC_SPM_SE_SAMPLE_SKEW (40891, 40899) */
	'R', 'L', 'C', '_', 'S', 'P', 'M', '_', 'S', 'E', '_', 'M', 'U', 'X', 'S', 'E', 'L', '_', 'S', 'K', 'E', 'W', '\0', /* RLC_SPM_SE_MUXSEL_SKEW (40914, 40922) */
	'R', 'L', 'C', '_', 'S', 'P', 'M', '_', 'G', 'L', 'B', '_', 'S', 'A', 'M', 'P', 'L', 'E', 'D', 'E', 'L', 'A', 'Y', '_', 'I', 'N', 'D', '_', 'A', 'D', 'D', 'R', '\0', /* RLC_SPM_GLB_SAMPLEDELAY_IND_ADDR (40937) */
	'R', 'L', 'C', '_', 'S', 'P', 'M', '_', 'G', 'L', 'B', '_', 'S', 'A', 'M', 'P', 'L', 'E', 'D', 'E', 'L', 'A', 'Y', '_', 'I', 'N', 'D', '_', 'D', 'A', 'T', 'A', '\0', /* RLC_SPM_GLB_SAMPLEDELAY_IND_DATA (40970) */
	'R', 'L', 'C', '_', 'S', 'P', 'M', '_', 'S', 'E', '_', 'S', 'A', 'M', 'P', 'L', 'E', 'D', 'E', 'L', 'A', 'Y', '_', 'I', 'N', 'D', '_', 'A', 'D', 'D', 'R', '\0', /* RLC_SPM_SE_SAMPLEDELAY_IND_ADDR (41003) */
	'R', 'L', 'C', '_', 'S', 'P', 'M', '_', 'S', 'E', '_', 'S', 'A', 'M', 'P', 'L', 'E', 'D', 'E', 'L', 'A', 'Y', '_', 'I', 'N', 'D', '_', 'D', 'A', 'T', 'A', '\0', /* RLC_SPM_SE_SAMPLEDELAY_IND_DATA (41035) */
	'R', 'L', 'C', '_', 'S', 'P', 'M', '_', 'R', 'I', 'N', 'G', '_', 'W', 'R', 'P', 'T', 'R', '\0', /* RLC_SPM_RING_WRPTR (41067) */
	'R', 'L', 'C', '_', 'S', 'P', 'M', '_', 'A', 'C', 'C', 'U', 'M', '_', 'D', 'A', 'T', 'A', 'R', 'A', 'M', '_', 'A', 'D', 'D', 'R', '\0', /* RLC_SPM_ACCUM_DATARAM_ADDR (41086) */
	'R', 'L', 'C', '_', 'S', 'P', 'M', '_', 'A', 'C', 'C', 'U', 'M', '_', 'D', 'A', 'T', 'A', 'R', 'A', 'M', '_', 'D', 'A', 'T', 'A', '\0', /* RLC_SPM_ACCUM_DATARAM_DATA (41113) */
	'R', 'L', 'C', '_', 'S', 'P', 'M', '_', 'A', 'C', 'C', 'U', 'M', '_', 'C', 'T', 'R', 'L', 'R', 'A', 'M', '_', 'A', 'D', 'D', 'R', '\0', /* RLC_SPM_ACCUM_CTRLRAM_ADDR (41140) */
	'R', 'L', 'C', '_', 'S', 'P', 'M', '_', 'A', 'C', 'C', 'U', 'M', '_', 'C', 'T', 'R', 'L', 'R', 'A', 'M', '_', 'D', 'A', 'T', 'A', '\0', /* RLC_SPM_ACCUM_CTRLRAM_DATA (41167) */
	'R', 'L', 'C', '_', 'S', 'P', 'M', '_', 'A', 'C', 'C', 'U', 'M', '_', 'S', 'T', 'A', 'T', 'U', 'S', '\0', /* RLC_SPM_ACCUM_STATUS (41194) */
	'R', 'L', 'C', '_', 'S', 'P', 'M', '_', 'A', 'C', 'C', 'U', 'M', '_', 'C', 'T', 'R', 'L', '\0', /* RLC_SPM_ACCUM_CTRL (41215) */
	'R', 'L', 'C', '_', 'S', 'P', 'M', '_', 'A', 'C', 'C', 'U', 'M', '_', 'M', 'O', 'D', 'E', '\0', /* RLC_SPM_ACCUM_MODE (41234) */
	'R', 'L', 'C', '_', 'S', 'P', 'M', '_', 'A', 'C', 'C', 'U', 'M', '_', 'T', 'H', 'R', 'E', 'S', 'H', 'O', 'L', 'D', '\0', /* RLC_SPM_ACCUM_THRESHOLD (41253) */
	'R', 'L', 'C', '_', 'S', 'P', 'M', '_', 'A', 'C', 'C', 'U', 'M', '_', 'S', 'A', 'M', 'P', 'L', 'E', 'S', '_', 'R', 'E', 'Q', 'U', 'E', 'S', 'T', 'E', 'D', '\0', /* RLC_SPM_ACCUM_SAMPLES_REQUESTED (41277) */
	'R', 'L', 'C', '_', 'S', 'P', 'M', '_', 'A', 'C', 'C', 'U', 'M', '_', 'D', 'A', 'T', 'A', 'R', 'A', 'M', '_', 'W', 'R', 'C', 'O', 'U', 'N', 'T', '\0', /* RLC_SPM_ACCUM_DATARAM_WRCOUNT (41309) */
	'R', 'L', 'C', '_', 'S', 'P', 'M', '_', 'P', 'E', 'R', 'F', 'M', 'O', 'N', '_', 'S', 'E', '3', 'T', 'O', '0', '_', 'S', 'E', 'G', 'M', 'E', 'N', 'T', '_', 'S', 'I', 'Z', 'E', '\0', /* RLC_SPM_PERFMON_SE3TO0_SEGMENT_SIZE (41339) */
	'R', 'L', 'C', '_', 'S', 'P', 'M', '_', 'P', 'E', 'R', 'F', 'M', 'O', 'N', '_', 'G', 'L', 'B', '_', 'S', 'E', 'G', 'M', 'E', 'N', 'T', '_', 'S', 'I', 'Z', 'E', '\0', /* RLC_SPM_PERFMON_GLB_SEGMENT_SIZE (41375) */
	'R', 'L', 'C', '_', 'S', 'P', 'M', '_', 'V', 'I', 'R', 'T', '_', 'C', 'T', 'R', 'L', '\0', /* RLC_SPM_VIRT_CTRL (41408) */
	'R', 'L', 'C', '_', 'S', 'P', 'M', '_', 'V', 'I', 'R', 'T', '_', 'S', 'T', 'A', 'T', 'U', 'S', '\0', /* RLC_SPM_VIRT_STATUS (41426) */
	'R', 'L', 'C', '_', 'P', 'E', 'R', 'F', 'M', 'O', 'N', '_', 'C', 'N', 'T', 'L', '\0', /* RLC_PERFMON_CNTL (41446) */
	'R', 'L', 'C', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* RLC_PERFCOUNTER0_SELECT (41463) */
	'R', 'L', 'C', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* RLC_PERFCOUNTER1_SELECT (41487) */
	'R', 'L', 'C', '_', 'G', 'P', 'U', '_', 'I', 'O', 'V', '_', 'P', 'E', 'R', 'F', '_', 'C', 'N', 'T', '_', 'C', 'N', 'T', 'L', '\0', /* RLC_GPU_IOV_PERF_CNT_CNTL (41511) */
	'R', 'L', 'C', '_', 'G', 'P', 'U', '_', 'I', 'O', 'V', '_', 'P', 'E', 'R', 'F', '_', 'C', 'N', 'T', '_', 'W', 'R', '_', 'A', 'D', 'D', 'R', '\0', /* RLC_GPU_IOV_PERF_CNT_WR_ADDR (41537) */
	'R', 'L', 'C', '_', 'G', 'P', 'U', '_', 'I', 'O', 'V', '_', 'P', 'E', 'R', 'F', '_', 'C', 'N', 'T', '_', 'W', 'R', '_', 'D', 'A', 'T', 'A', '\0', /* RLC_GPU_IOV_PERF_CNT_WR_DATA (41566) */
	'R', 'L', 'C', '_', 'G', 'P', 'U', '_', 'I', 'O', 'V', '_', 'P', 'E', 'R', 'F', '_', 'C', 'N', 'T', '_', 'R', 'D', '_', 'A', 'D', 'D', 'R', '\0', /* RLC_GPU_IOV_PERF_CNT_RD_ADDR (41595) */
	'R', 'L', 'C', '_', 'G', 'P', 'U', '_', 'I', 'O', 'V', '_', 'P', 'E', 'R', 'F', '_', 'C', 'N', 'T', '_', 'R', 'D', '_', 'D', 'A', 'T', 'A', '\0', /* RLC_GPU_IOV_PERF_CNT_RD_DATA (41624) */
	'R', 'L', 'C', '_', 'P', 'E', 'R', 'F', 'M', 'O', 'N', '_', 'C', 'L', 'K', '_', 'C', 'N', 'T', 'L', '\0', /* RLC_PERFMON_CLK_CNTL (41653) */
	'R', 'L', 'C', '_', 'P', 'E', 'R', 'F', 'M', 'O', 'N', '_', 'C', 'L', 'K', '_', 'C', 'N', 'T', 'L', '_', 'U', 'C', 'O', 'D', 'E', '\0', /* RLC_PERFMON_CLK_CNTL_UCODE (41674) */
	'R', 'M', 'I', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* RMI_PERFCOUNTER0_SELECT (41701) */
	'R', 'M', 'I', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'S', 'E', 'L', 'E', 'C', 'T', '1', '\0', /* RMI_PERFCOUNTER0_SELECT1 (41725) */
	'R', 'M', 'I', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* RMI_PERFCOUNTER1_SELECT (41750) */
	'R', 'M', 'I', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* RMI_PERFCOUNTER2_SELECT (41774) */
	'R', 'M', 'I', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', 'S', 'E', 'L', 'E', 'C', 'T', '1', '\0', /* RMI_PERFCOUNTER2_SELECT1 (41798) */
	'R', 'M', 'I', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '3', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* RMI_PERFCOUNTER3_SELECT (41823) */
	'R', 'M', 'I', '_', 'P', 'E', 'R', 'F', '_', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '_', 'C', 'N', 'T', 'L', '\0', /* RMI_PERF_COUNTER_CNTL (41847) */
	'G', 'C', '_', 'A', 'T', 'C', '_', 'L', '2', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'C', 'F', 'G', '\0', /* GC_ATC_L2_PERFCOUNTER0_CFG (41869, 41872) */
	'G', 'C', '_', 'A', 'T', 'C', '_', 'L', '2', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'C', 'F', 'G', '\0', /* GC_ATC_L2_PERFCOUNTER1_CFG (41896, 41899) */
	'G', 'C', '_', 'A', 'T', 'C', '_', 'L', '2', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '_', 'R', 'S', 'L', 'T', '_', 'C', 'N', 'T', 'L', '\0', /* GC_ATC_L2_PERFCOUNTER_RSLT_CNTL (41923, 41926) */
	'G', 'C', 'M', 'C', '_', 'V', 'M', '_', 'L', '2', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'C', 'F', 'G', '\0', /* GCMC_VM_L2_PERFCOUNTER0_CFG (41955, 41957) */
	'G', 'C', 'M', 'C', '_', 'V', 'M', '_', 'L', '2', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'C', 'F', 'G', '\0', /* GCMC_VM_L2_PERFCOUNTER1_CFG (41983, 41985) */
	'G', 'C', 'M', 'C', '_', 'V', 'M', '_', 'L', '2', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', 'C', 'F', 'G', '\0', /* GCMC_VM_L2_PERFCOUNTER2_CFG (42011, 42013) */
	'G', 'C', 'M', 'C', '_', 'V', 'M', '_', 'L', '2', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '3', '_', 'C', 'F', 'G', '\0', /* GCMC_VM_L2_PERFCOUNTER3_CFG (42039, 42041) */
	'G', 'C', 'M', 'C', '_', 'V', 'M', '_', 'L', '2', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '4', '_', 'C', 'F', 'G', '\0', /* GCMC_VM_L2_PERFCOUNTER4_CFG (42067, 42069) */
	'G', 'C', 'M', 'C', '_', 'V', 'M', '_', 'L', '2', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '5', '_', 'C', 'F', 'G', '\0', /* GCMC_VM_L2_PERFCOUNTER5_CFG (42095, 42097) */
	'G', 'C', 'M', 'C', '_', 'V', 'M', '_', 'L', '2', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '6', '_', 'C', 'F', 'G', '\0', /* GCMC_VM_L2_PERFCOUNTER6_CFG (42123, 42125) */
	'G', 'C', 'M', 'C', '_', 'V', 'M', '_', 'L', '2', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '7', '_', 'C', 'F', 'G', '\0', /* GCMC_VM_L2_PERFCOUNTER7_CFG (42151, 42153) */
	'G', 'C', 'M', 'C', '_', 'V', 'M', '_', 'L', '2', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '_', 'R', 'S', 'L', 'T', '_', 'C', 'N', 'T', 'L', '\0', /* GCMC_VM_L2_PERFCOUNTER_RSLT_CNTL (42179, 42181) */
	'G', 'C', 'V', 'M', 'L', '2', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', '0', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* GCVML2_PERFCOUNTER2_0_SELECT (42212) */
	'G', 'C', 'V', 'M', 'L', '2', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', '1', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* GCVML2_PERFCOUNTER2_1_SELECT (42241) */
	'G', 'C', 'V', 'M', 'L', '2', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', '0', '_', 'S', 'E', 'L', 'E', 'C', 'T', '1', '\0', /* GCVML2_PERFCOUNTER2_0_SELECT1 (42270) */
	'G', 'C', 'V', 'M', 'L', '2', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', '1', '_', 'S', 'E', 'L', 'E', 'C', 'T', '1', '\0', /* GCVML2_PERFCOUNTER2_1_SELECT1 (42300) */
	'G', 'C', 'V', 'M', 'L', '2', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', '0', '_', 'M', 'O', 'D', 'E', '\0', /* GCVML2_PERFCOUNTER2_0_MODE (42330) */
	'G', 'C', 'V', 'M', 'L', '2', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', '1', '_', 'M', 'O', 'D', 'E', '\0', /* GCVML2_PERFCOUNTER2_1_MODE (42357) */
	'G', 'C', '_', 'A', 'T', 'C', '_', 'L', '2', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* GC_ATC_L2_PERFCOUNTER2_SELECT (42384) */
	'G', 'C', '_', 'A', 'T', 'C', '_', 'L', '2', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', 'S', 'E', 'L', 'E', 'C', 'T', '1', '\0', /* GC_ATC_L2_PERFCOUNTER2_SELECT1 (42414) */
	'G', 'C', '_', 'A', 'T', 'C', '_', 'L', '2', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', 'M', 'O', 'D', 'E', '\0', /* GC_ATC_L2_PERFCOUNTER2_MODE (42445) */
	'G', 'C', 'R', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* GCR_PERFCOUNTER0_SELECT (42473) */
	'G', 'C', 'R', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'S', 'E', 'L', 'E', 'C', 'T', '1', '\0', /* GCR_PERFCOUNTER0_SELECT1 (42497) */
	'G', 'C', 'R', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* GCR_PERFCOUNTER1_SELECT (42522) */
	'U', 'T', 'C', 'L', '1', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* UTCL1_PERFCOUNTER0_SELECT (42546) */
	'U', 'T', 'C', 'L', '1', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* UTCL1_PERFCOUNTER1_SELECT (42572) */
	'P', 'A', '_', 'P', 'H', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* PA_PH_PERFCOUNTER0_SELECT (42598) */
	'P', 'A', '_', 'P', 'H', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'S', 'E', 'L', 'E', 'C', 'T', '1', '\0', /* PA_PH_PERFCOUNTER0_SELECT1 (42624) */
	'P', 'A', '_', 'P', 'H', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* PA_PH_PERFCOUNTER1_SELECT (42651) */
	'P', 'A', '_', 'P', 'H', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* PA_PH_PERFCOUNTER2_SELECT (42677) */
	'P', 'A', '_', 'P', 'H', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '3', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* PA_PH_PERFCOUNTER3_SELECT (42703) */
	'P', 'A', '_', 'P', 'H', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '4', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* PA_PH_PERFCOUNTER4_SELECT (42729) */
	'P', 'A', '_', 'P', 'H', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '5', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* PA_PH_PERFCOUNTER5_SELECT (42755) */
	'P', 'A', '_', 'P', 'H', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '6', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* PA_PH_PERFCOUNTER6_SELECT (42781) */
	'P', 'A', '_', 'P', 'H', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '7', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* PA_PH_PERFCOUNTER7_SELECT (42807) */
	'P', 'A', '_', 'P', 'H', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'S', 'E', 'L', 'E', 'C', 'T', '1', '\0', /* PA_PH_PERFCOUNTER1_SELECT1 (42833) */
	'P', 'A', '_', 'P', 'H', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', 'S', 'E', 'L', 'E', 'C', 'T', '1', '\0', /* PA_PH_PERFCOUNTER2_SELECT1 (42860) */
	'P', 'A', '_', 'P', 'H', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '3', '_', 'S', 'E', 'L', 'E', 'C', 'T', '1', '\0', /* PA_PH_PERFCOUNTER3_SELECT1 (42887) */
	'G', 'L', '1', 'A', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* GL1A_PERFCOUNTER0_SELECT (42914) */
	'G', 'L', '1', 'A', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'S', 'E', 'L', 'E', 'C', 'T', '1', '\0', /* GL1A_PERFCOUNTER0_SELECT1 (42939) */
	'G', 'L', '1', 'A', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* GL1A_PERFCOUNTER1_SELECT (42965) */
	'G', 'L', '1', 'A', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* GL1A_PERFCOUNTER2_SELECT (42990) */
	'G', 'L', '1', 'A', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '3', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* GL1A_PERFCOUNTER3_SELECT (43015) */
	'C', 'H', 'A', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* CHA_PERFCOUNTER0_SELECT (43040) */
	'C', 'H', 'A', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'S', 'E', 'L', 'E', 'C', 'T', '1', '\0', /* CHA_PERFCOUNTER0_SELECT1 (43064) */
	'C', 'H', 'A', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* CHA_PERFCOUNTER1_SELECT (43089) */
	'C', 'H', 'A', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* CHA_PERFCOUNTER2_SELECT (43113) */
	'C', 'H', 'A', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '3', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* CHA_PERFCOUNTER3_SELECT (43137) */
	'G', 'U', 'S', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* GUS_PERFCOUNTER2_SELECT (43161) */
	'G', 'U', 'S', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', 'S', 'E', 'L', 'E', 'C', 'T', '1', '\0', /* GUS_PERFCOUNTER2_SELECT1 (43185) */
	'G', 'U', 'S', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', 'M', 'O', 'D', 'E', '\0', /* GUS_PERFCOUNTER2_MODE (43210) */
	'D', 'S', 'T', '_', 'A', 'D', 'D', 'R', '_', 'L', 'O', '\0', /* DST_ADDR_LO (43232) */
	'I', 'B', '_', 'B', 'A', 'S', 'E', '_', 'L', 'O', '\0', /* IB_BASE_LO (43244) */
	'I', 'B', '_', 'B', 'A', 'S', 'E', '_', 'H', 'I', '\0', /* IB_BASE_HI (43255) */
	'C', 'P', '_', 'D', 'M', 'A', '_', 'W', 'O', 'R', 'D', '0', '\0', /* CP_DMA_WORD0 (43266) */
	'C', 'P', '_', 'D', 'M', 'A', '_', 'W', 'O', 'R', 'D', '1', '\0', /* CP_DMA_WORD1 (43279) */
	'C', 'P', '_', 'D', 'M', 'A', '_', 'W', 'O', 'R', 'D', '2', '\0', /* CP_DMA_WORD2 (43292) */
	'C', 'P', '_', 'D', 'M', 'A', '_', 'W', 'O', 'R', 'D', '3', '\0', /* CP_DMA_WORD3 (43305) */
	'R', 'E', 'L', 'E', 'A', 'S', 'E', '_', 'M', 'E', 'M', '_', 'O', 'P', '\0', /* RELEASE_MEM_OP (43318) */
	'D', 'M', 'A', '_', 'D', 'A', 'T', 'A', '_', 'W', 'O', 'R', 'D', '0', '\0', /* DMA_DATA_WORD0 (43333) */
	'S', 'R', 'C', '_', 'A', 'D', 'D', 'R', '_', 'L', 'O', '\0', /* SRC_ADDR_LO (43348) */
	'G', 'C', 'R', '_', 'C', 'N', 'T', 'L', '\0', /* GCR_CNTL (43360) */
	'S', 'Q', '_', 'W', 'A', 'V', 'E', '_', 'A', 'C', 'T', 'I', 'V', 'E', '\0', /* SQ_WAVE_ACTIVE (43369) */
	'S', 'Q', '_', 'W', 'A', 'V', 'E', '_', 'V', 'A', 'L', 'I', 'D', '_', 'A', 'N', 'D', '_', 'I', 'D', 'L', 'E', '\0', /* SQ_WAVE_VALID_AND_IDLE (43384, 43402) */
	'S', 'Q', '_', 'W', 'A', 'V', 'E', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'C', 'Y', 'C', 'L', 'E', 'S', '\0', /* SQ_WAVE_SHADER_CYCLES (43407, 43422) */
	'C', 'P', '_', 'C', 'P', 'C', '_', 'P', 'R', 'I', 'V', '_', 'V', 'I', 'O', 'L', 'A', 'T', 'I', 'O', 'N', '_', 'A', 'D', 'D', 'R', '\0', /* CP_CPC_PRIV_VIOLATION_ADDR (43429, 43436) */
	'S', 'Q', '_', 'T', 'H', 'R', 'E', 'A', 'D', '_', 'T', 'R', 'A', 'C', 'E', '_', 'S', 'T', 'A', 'T', 'U', 'S', '2', '\0', /* SQ_THREAD_TRACE_STATUS2 (43456) */
	'D', 'B', '_', 'V', 'R', 'S', '_', 'O', 'V', 'E', 'R', 'R', 'I', 'D', 'E', '_', 'C', 'N', 'T', 'L', '\0', /* DB_VRS_OVERRIDE_CNTL (43480) */
	'C', 'O', 'N', 'T', 'E', 'X', 'T', '_', 'R', 'E', 'S', 'E', 'R', 'V', 'E', 'D', '_', 'R', 'E', 'G', '0', '\0', /* CONTEXT_RESERVED_REG0 (43501) */
	'C', 'O', 'N', 'T', 'E', 'X', 'T', '_', 'R', 'E', 'S', 'E', 'R', 'V', 'E', 'D', '_', 'R', 'E', 'G', '1', '\0', /* CONTEXT_RESERVED_REG1 (43523) */
	'S', 'X', '_', 'P', 'S', '_', 'D', 'O', 'W', 'N', 'C', 'O', 'N', 'V', 'E', 'R', 'T', '_', 'C', 'O', 'N', 'T', 'R', 'O', 'L', '\0', /* SX_PS_DOWNCONVERT_CONTROL (43545) */
	'P', 'A', '_', 'C', 'L', '_', 'V', 'R', 'S', '_', 'C', 'N', 'T', 'L', '\0', /* PA_CL_VRS_CNTL (43571) */
	'S', 'C', 'R', 'A', 'T', 'C', 'H', '_', 'R', 'E', 'G', '_', 'A', 'T', 'O', 'M', 'I', 'C', '\0', /* SCRATCH_REG_ATOMIC (43586, 43598) */
	'U', 'C', 'O', 'N', 'F', 'I', 'G', '_', 'R', 'E', 'S', 'E', 'R', 'V', 'E', 'D', '_', 'R', 'E', 'G', '0', '\0', /* UCONFIG_RESERVED_REG0 (43605) */
	'U', 'C', 'O', 'N', 'F', 'I', 'G', '_', 'R', 'E', 'S', 'E', 'R', 'V', 'E', 'D', '_', 'R', 'E', 'G', '1', '\0', /* UCONFIG_RESERVED_REG1 (43627) */
	'C', 'P', '_', 'C', 'E', '_', 'A', 'T', 'O', 'M', 'I', 'C', '_', 'P', 'R', 'E', 'O', 'P', '_', 'L', 'O', '\0', /* CP_CE_ATOMIC_PREOP_LO (43649) */
	'C', 'P', '_', 'C', 'E', '_', 'A', 'T', 'O', 'M', 'I', 'C', '_', 'P', 'R', 'E', 'O', 'P', '_', 'H', 'I', '\0', /* CP_CE_ATOMIC_PREOP_HI (43671) */
	'C', 'P', '_', 'C', 'E', '_', 'G', 'D', 'S', '_', 'A', 'T', 'O', 'M', 'I', 'C', '0', '_', 'P', 'R', 'E', 'O', 'P', '_', 'L', 'O', '\0', /* CP_CE_GDS_ATOMIC0_PREOP_LO (43693) */
	'C', 'P', '_', 'C', 'E', '_', 'G', 'D', 'S', '_', 'A', 'T', 'O', 'M', 'I', 'C', '0', '_', 'P', 'R', 'E', 'O', 'P', '_', 'H', 'I', '\0', /* CP_CE_GDS_ATOMIC0_PREOP_HI (43720) */
	'C', 'P', '_', 'C', 'E', '_', 'G', 'D', 'S', '_', 'A', 'T', 'O', 'M', 'I', 'C', '1', '_', 'P', 'R', 'E', 'O', 'P', '_', 'L', 'O', '\0', /* CP_CE_GDS_ATOMIC1_PREOP_LO (43747) */
	'C', 'P', '_', 'C', 'E', '_', 'G', 'D', 'S', '_', 'A', 'T', 'O', 'M', 'I', 'C', '1', '_', 'P', 'R', 'E', 'O', 'P', '_', 'H', 'I', '\0', /* CP_CE_GDS_ATOMIC1_PREOP_HI (43774) */
	'G', 'E', '_', 'V', 'R', 'S', '_', 'R', 'A', 'T', 'E', '\0', /* GE_VRS_RATE (43801, 43804) */
	'G', 'E', '1', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'L', 'O', '\0', /* GE1_PERFCOUNTER0_LO (43813) */
	'G', 'E', '1', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'H', 'I', '\0', /* GE1_PERFCOUNTER0_HI (43833) */
	'G', 'E', '1', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'L', 'O', '\0', /* GE1_PERFCOUNTER1_LO (43853) */
	'G', 'E', '1', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'H', 'I', '\0', /* GE1_PERFCOUNTER1_HI (43873) */
	'G', 'E', '1', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', 'L', 'O', '\0', /* GE1_PERFCOUNTER2_LO (43893) */
	'G', 'E', '1', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', 'H', 'I', '\0', /* GE1_PERFCOUNTER2_HI (43913) */
	'G', 'E', '1', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '3', '_', 'L', 'O', '\0', /* GE1_PERFCOUNTER3_LO (43933) */
	'G', 'E', '1', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '3', '_', 'H', 'I', '\0', /* GE1_PERFCOUNTER3_HI (43953) */
	'G', 'E', '2', '_', 'D', 'I', 'S', 'T', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'L', 'O', '\0', /* GE2_DIST_PERFCOUNTER0_LO (43973) */
	'G', 'E', '2', '_', 'D', 'I', 'S', 'T', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'H', 'I', '\0', /* GE2_DIST_PERFCOUNTER0_HI (43998) */
	'G', 'E', '2', '_', 'D', 'I', 'S', 'T', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'L', 'O', '\0', /* GE2_DIST_PERFCOUNTER1_LO (44023) */
	'G', 'E', '2', '_', 'D', 'I', 'S', 'T', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'H', 'I', '\0', /* GE2_DIST_PERFCOUNTER1_HI (44048) */
	'G', 'E', '2', '_', 'D', 'I', 'S', 'T', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', 'L', 'O', '\0', /* GE2_DIST_PERFCOUNTER2_LO (44073) */
	'G', 'E', '2', '_', 'D', 'I', 'S', 'T', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', 'H', 'I', '\0', /* GE2_DIST_PERFCOUNTER2_HI (44098) */
	'G', 'E', '2', '_', 'D', 'I', 'S', 'T', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '3', '_', 'L', 'O', '\0', /* GE2_DIST_PERFCOUNTER3_LO (44123) */
	'G', 'E', '2', '_', 'D', 'I', 'S', 'T', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '3', '_', 'H', 'I', '\0', /* GE2_DIST_PERFCOUNTER3_HI (44148) */
	'G', 'E', '2', '_', 'S', 'E', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'L', 'O', '\0', /* GE2_SE_PERFCOUNTER0_LO (44173) */
	'G', 'E', '2', '_', 'S', 'E', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'H', 'I', '\0', /* GE2_SE_PERFCOUNTER0_HI (44196) */
	'G', 'E', '2', '_', 'S', 'E', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'L', 'O', '\0', /* GE2_SE_PERFCOUNTER1_LO (44219) */
	'G', 'E', '2', '_', 'S', 'E', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'H', 'I', '\0', /* GE2_SE_PERFCOUNTER1_HI (44242) */
	'G', 'E', '2', '_', 'S', 'E', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', 'L', 'O', '\0', /* GE2_SE_PERFCOUNTER2_LO (44265) */
	'G', 'E', '2', '_', 'S', 'E', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', 'H', 'I', '\0', /* GE2_SE_PERFCOUNTER2_HI (44288) */
	'G', 'E', '2', '_', 'S', 'E', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '3', '_', 'L', 'O', '\0', /* GE2_SE_PERFCOUNTER3_LO (44311) */
	'G', 'E', '2', '_', 'S', 'E', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '3', '_', 'H', 'I', '\0', /* GE2_SE_PERFCOUNTER3_HI (44334) */
	'G', 'C', 'E', 'A', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '_', 'L', 'O', '\0', /* GCEA_PERFCOUNTER_LO (44357) */
	'G', 'C', 'E', 'A', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '_', 'H', 'I', '\0', /* GCEA_PERFCOUNTER_HI (44377) */
	'G', 'C', 'U', 'T', 'C', 'L', '2', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '_', 'L', 'O', '\0', /* GCUTCL2_PERFCOUNTER_LO (44397) */
	'G', 'C', 'U', 'T', 'C', 'L', '2', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '_', 'H', 'I', '\0', /* GCUTCL2_PERFCOUNTER_HI (44420) */
	'G', 'U', 'S', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '_', 'L', 'O', '\0', /* GUS_PERFCOUNTER_LO (44443) */
	'G', 'U', 'S', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '_', 'H', 'I', '\0', /* GUS_PERFCOUNTER_HI (44462) */
	'S', 'D', 'M', 'A', '0', '_', 'P', 'E', 'R', 'F', 'C', 'N', 'T', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '_', 'L', 'O', '\0', /* SDMA0_PERFCNT_PERFCOUNTER_LO (44481) */
	'S', 'D', 'M', 'A', '0', '_', 'P', 'E', 'R', 'F', 'C', 'N', 'T', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '_', 'H', 'I', '\0', /* SDMA0_PERFCNT_PERFCOUNTER_HI (44510) */
	'S', 'D', 'M', 'A', '0', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'L', 'O', '\0', /* SDMA0_PERFCOUNTER0_LO (44539) */
	'S', 'D', 'M', 'A', '0', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'H', 'I', '\0', /* SDMA0_PERFCOUNTER0_HI (44561) */
	'S', 'D', 'M', 'A', '0', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'L', 'O', '\0', /* SDMA0_PERFCOUNTER1_LO (44583) */
	'S', 'D', 'M', 'A', '0', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'H', 'I', '\0', /* SDMA0_PERFCOUNTER1_HI (44605) */
	'S', 'D', 'M', 'A', '1', '_', 'P', 'E', 'R', 'F', 'C', 'N', 'T', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '_', 'L', 'O', '\0', /* SDMA1_PERFCNT_PERFCOUNTER_LO (44627) */
	'S', 'D', 'M', 'A', '1', '_', 'P', 'E', 'R', 'F', 'C', 'N', 'T', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '_', 'H', 'I', '\0', /* SDMA1_PERFCNT_PERFCOUNTER_HI (44656) */
	'S', 'D', 'M', 'A', '1', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'L', 'O', '\0', /* SDMA1_PERFCOUNTER0_LO (44685) */
	'S', 'D', 'M', 'A', '1', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'H', 'I', '\0', /* SDMA1_PERFCOUNTER0_HI (44707) */
	'S', 'D', 'M', 'A', '1', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'L', 'O', '\0', /* SDMA1_PERFCOUNTER1_LO (44729) */
	'S', 'D', 'M', 'A', '1', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'H', 'I', '\0', /* SDMA1_PERFCOUNTER1_HI (44751) */
	'S', 'D', 'M', 'A', '2', '_', 'P', 'E', 'R', 'F', 'C', 'N', 'T', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '_', 'L', 'O', '\0', /* SDMA2_PERFCNT_PERFCOUNTER_LO (44773) */
	'S', 'D', 'M', 'A', '2', '_', 'P', 'E', 'R', 'F', 'C', 'N', 'T', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '_', 'H', 'I', '\0', /* SDMA2_PERFCNT_PERFCOUNTER_HI (44802) */
	'S', 'D', 'M', 'A', '2', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'L', 'O', '\0', /* SDMA2_PERFCOUNTER0_LO (44831) */
	'S', 'D', 'M', 'A', '2', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'H', 'I', '\0', /* SDMA2_PERFCOUNTER0_HI (44853) */
	'S', 'D', 'M', 'A', '2', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'L', 'O', '\0', /* SDMA2_PERFCOUNTER1_LO (44875) */
	'S', 'D', 'M', 'A', '2', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'H', 'I', '\0', /* SDMA2_PERFCOUNTER1_HI (44897) */
	'S', 'D', 'M', 'A', '3', '_', 'P', 'E', 'R', 'F', 'C', 'N', 'T', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '_', 'L', 'O', '\0', /* SDMA3_PERFCNT_PERFCOUNTER_LO (44919) */
	'S', 'D', 'M', 'A', '3', '_', 'P', 'E', 'R', 'F', 'C', 'N', 'T', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '_', 'H', 'I', '\0', /* SDMA3_PERFCNT_PERFCOUNTER_HI (44948) */
	'S', 'D', 'M', 'A', '3', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'L', 'O', '\0', /* SDMA3_PERFCOUNTER0_LO (44977) */
	'S', 'D', 'M', 'A', '3', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'H', 'I', '\0', /* SDMA3_PERFCOUNTER0_HI (44999) */
	'S', 'D', 'M', 'A', '3', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'L', 'O', '\0', /* SDMA3_PERFCOUNTER1_LO (45021) */
	'S', 'D', 'M', 'A', '3', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'H', 'I', '\0', /* SDMA3_PERFCOUNTER1_HI (45043) */
	'G', 'E', '1', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* GE1_PERFCOUNTER0_SELECT (45065) */
	'G', 'E', '1', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'S', 'E', 'L', 'E', 'C', 'T', '1', '\0', /* GE1_PERFCOUNTER0_SELECT1 (45089) */
	'G', 'E', '1', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* GE1_PERFCOUNTER1_SELECT (45114) */
	'G', 'E', '1', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'S', 'E', 'L', 'E', 'C', 'T', '1', '\0', /* GE1_PERFCOUNTER1_SELECT1 (45138) */
	'G', 'E', '1', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* GE1_PERFCOUNTER2_SELECT (45163) */
	'G', 'E', '1', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', 'S', 'E', 'L', 'E', 'C', 'T', '1', '\0', /* GE1_PERFCOUNTER2_SELECT1 (45187) */
	'G', 'E', '1', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '3', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* GE1_PERFCOUNTER3_SELECT (45212) */
	'G', 'E', '1', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '3', '_', 'S', 'E', 'L', 'E', 'C', 'T', '1', '\0', /* GE1_PERFCOUNTER3_SELECT1 (45236) */
	'G', 'E', '2', '_', 'D', 'I', 'S', 'T', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* GE2_DIST_PERFCOUNTER0_SELECT (45261) */
	'G', 'E', '2', '_', 'D', 'I', 'S', 'T', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'S', 'E', 'L', 'E', 'C', 'T', '1', '\0', /* GE2_DIST_PERFCOUNTER0_SELECT1 (45290) */
	'G', 'E', '2', '_', 'D', 'I', 'S', 'T', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* GE2_DIST_PERFCOUNTER1_SELECT (45320) */
	'G', 'E', '2', '_', 'D', 'I', 'S', 'T', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'S', 'E', 'L', 'E', 'C', 'T', '1', '\0', /* GE2_DIST_PERFCOUNTER1_SELECT1 (45349) */
	'G', 'E', '2', '_', 'D', 'I', 'S', 'T', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* GE2_DIST_PERFCOUNTER2_SELECT (45379) */
	'G', 'E', '2', '_', 'D', 'I', 'S', 'T', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', 'S', 'E', 'L', 'E', 'C', 'T', '1', '\0', /* GE2_DIST_PERFCOUNTER2_SELECT1 (45408) */
	'G', 'E', '2', '_', 'D', 'I', 'S', 'T', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '3', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* GE2_DIST_PERFCOUNTER3_SELECT (45438) */
	'G', 'E', '2', '_', 'D', 'I', 'S', 'T', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '3', '_', 'S', 'E', 'L', 'E', 'C', 'T', '1', '\0', /* GE2_DIST_PERFCOUNTER3_SELECT1 (45467) */
	'G', 'E', '2', '_', 'S', 'E', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* GE2_SE_PERFCOUNTER0_SELECT (45497) */
	'G', 'E', '2', '_', 'S', 'E', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'S', 'E', 'L', 'E', 'C', 'T', '1', '\0', /* GE2_SE_PERFCOUNTER0_SELECT1 (45524) */
	'G', 'E', '2', '_', 'S', 'E', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* GE2_SE_PERFCOUNTER1_SELECT (45552) */
	'G', 'E', '2', '_', 'S', 'E', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'S', 'E', 'L', 'E', 'C', 'T', '1', '\0', /* GE2_SE_PERFCOUNTER1_SELECT1 (45579) */
	'G', 'E', '2', '_', 'S', 'E', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* GE2_SE_PERFCOUNTER2_SELECT (45607) */
	'G', 'E', '2', '_', 'S', 'E', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', 'S', 'E', 'L', 'E', 'C', 'T', '1', '\0', /* GE2_SE_PERFCOUNTER2_SELECT1 (45634) */
	'G', 'E', '2', '_', 'S', 'E', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '3', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* GE2_SE_PERFCOUNTER3_SELECT (45662) */
	'G', 'E', '2', '_', 'S', 'E', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '3', '_', 'S', 'E', 'L', 'E', 'C', 'T', '1', '\0', /* GE2_SE_PERFCOUNTER3_SELECT1 (45689) */
	'G', 'C', 'E', 'A', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'C', 'F', 'G', '\0', /* GCEA_PERFCOUNTER0_CFG (45717) */
	'G', 'C', 'E', 'A', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'C', 'F', 'G', '\0', /* GCEA_PERFCOUNTER1_CFG (45739) */
	'G', 'C', 'E', 'A', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '_', 'R', 'S', 'L', 'T', '_', 'C', 'N', 'T', 'L', '\0', /* GCEA_PERFCOUNTER_RSLT_CNTL (45761) */
	'G', 'D', 'S', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'S', 'E', 'L', 'E', 'C', 'T', '1', '\0', /* GDS_PERFCOUNTER1_SELECT1 (45788) */
	'G', 'D', 'S', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', 'S', 'E', 'L', 'E', 'C', 'T', '1', '\0', /* GDS_PERFCOUNTER2_SELECT1 (45813) */
	'G', 'D', 'S', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '3', '_', 'S', 'E', 'L', 'E', 'C', 'T', '1', '\0', /* GDS_PERFCOUNTER3_SELECT1 (45838) */
	'R', 'L', 'C', '_', 'S', 'P', 'M', '_', 'P', 'E', 'R', 'F', 'M', 'O', 'N', '_', 'S', 'W', 'A', '_', 'S', 'E', 'G', 'M', 'E', 'N', 'T', '_', 'S', 'I', 'Z', 'E', '\0', /* RLC_SPM_PERFMON_SWA_SEGMENT_SIZE (45863) */
	'R', 'L', 'C', '_', 'S', 'P', 'M', '_', 'G', 'F', 'X', 'C', 'L', 'O', 'C', 'K', '_', 'H', 'I', 'G', 'H', 'C', 'O', 'U', 'N', 'T', '\0', /* RLC_SPM_GFXCLOCK_HIGHCOUNT (45896) */
	'R', 'L', 'C', '_', 'S', 'P', 'M', '_', 'G', 'F', 'X', 'C', 'L', 'O', 'C', 'K', '_', 'L', 'O', 'W', 'C', 'O', 'U', 'N', 'T', '\0', /* RLC_SPM_GFXCLOCK_LOWCOUNT (45923) */
	'R', 'L', 'C', '_', 'S', 'P', 'M', '_', 'P', 'E', 'R', 'F', 'M', 'O', 'N', '_', 'S', 'W', 'A', '_', 'S', 'E', '3', 'T', 'O', '0', '_', 'S', 'E', 'G', 'M', 'E', 'N', 'T', '_', 'S', 'I', 'Z', 'E', '\0', /* RLC_SPM_PERFMON_SWA_SE3TO0_SEGMENT_SIZE (45949) */
	'R', 'L', 'C', '_', 'S', 'P', 'M', '_', 'G', 'L', 'O', 'B', 'A', 'L', '_', 'M', 'U', 'X', 'S', 'E', 'L', '_', 'A', 'D', 'D', 'R', '_', 'O', 'F', 'F', 'S', 'E', 'T', '\0', /* RLC_SPM_GLOBAL_MUXSEL_ADDR_OFFSET (45989) */
	'R', 'L', 'C', '_', 'S', 'P', 'M', '_', 'S', 'E', '_', 'M', 'U', 'X', 'S', 'E', 'L', '_', 'A', 'D', 'D', 'R', '_', 'O', 'F', 'F', 'S', 'E', 'T', '\0', /* RLC_SPM_SE_MUXSEL_ADDR_OFFSET (46023) */
	'R', 'L', 'C', '_', 'S', 'P', 'M', '_', 'A', 'C', 'C', 'U', 'M', '_', 'S', 'W', 'A', '_', 'D', 'A', 'T', 'A', 'R', 'A', 'M', '_', 'A', 'D', 'D', 'R', '\0', /* RLC_SPM_ACCUM_SWA_DATARAM_ADDR (46053) */
	'R', 'L', 'C', '_', 'S', 'P', 'M', '_', 'A', 'C', 'C', 'U', 'M', '_', 'S', 'W', 'A', '_', 'D', 'A', 'T', 'A', 'R', 'A', 'M', '_', 'D', 'A', 'T', 'A', '\0', /* RLC_SPM_ACCUM_SWA_DATARAM_DATA (46084) */
	'R', 'L', 'C', '_', 'S', 'P', 'M', '_', 'A', 'C', 'C', 'U', 'M', '_', 'C', 'T', 'R', 'L', 'R', 'A', 'M', '_', 'A', 'D', 'D', 'R', '_', 'O', 'F', 'F', 'S', 'E', 'T', '\0', /* RLC_SPM_ACCUM_CTRLRAM_ADDR_OFFSET (46115) */
	'R', 'L', 'C', '_', 'S', 'P', 'M', '_', 'P', 'E', 'R', 'F', 'M', 'O', 'N', '_', 'S', 'W', 'A', '_', 'G', 'L', 'B', '_', 'S', 'E', 'G', 'M', 'E', 'N', 'T', '_', 'S', 'I', 'Z', 'E', '\0', /* RLC_SPM_PERFMON_SWA_GLB_SEGMENT_SIZE (46149) */
	'R', 'L', 'C', '_', 'S', 'P', 'M', '_', 'A', 'C', 'C', 'U', 'M', '_', 'D', 'A', 'T', 'A', 'R', 'A', 'M', '_', '3', '2', 'B', 'I', 'T', 'C', 'N', 'T', 'R', 'S', '_', 'R', 'E', 'G', 'I', 'O', 'N', 'S', '\0', /* RLC_SPM_ACCUM_DATARAM_32BITCNTRS_REGIONS (46186) */
	'G', 'C', 'U', 'T', 'C', 'L', '2', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'C', 'F', 'G', '\0', /* GCUTCL2_PERFCOUNTER0_CFG (46227) */
	'G', 'C', 'U', 'T', 'C', 'L', '2', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'C', 'F', 'G', '\0', /* GCUTCL2_PERFCOUNTER1_CFG (46252) */
	'G', 'C', 'U', 'T', 'C', 'L', '2', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', 'C', 'F', 'G', '\0', /* GCUTCL2_PERFCOUNTER2_CFG (46277) */
	'G', 'C', 'U', 'T', 'C', 'L', '2', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '3', '_', 'C', 'F', 'G', '\0', /* GCUTCL2_PERFCOUNTER3_CFG (46302) */
	'G', 'C', 'U', 'T', 'C', 'L', '2', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '_', 'R', 'S', 'L', 'T', '_', 'C', 'N', 'T', 'L', '\0', /* GCUTCL2_PERFCOUNTER_RSLT_CNTL (46327) */
	'G', 'U', 'S', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'C', 'F', 'G', '\0', /* GUS_PERFCOUNTER0_CFG (46357) */
	'G', 'U', 'S', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'C', 'F', 'G', '\0', /* GUS_PERFCOUNTER1_CFG (46378) */
	'G', 'U', 'S', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '_', 'R', 'S', 'L', 'T', '_', 'C', 'N', 'T', 'L', '\0', /* GUS_PERFCOUNTER_RSLT_CNTL (46399) */
	'S', 'D', 'M', 'A', '0', '_', 'P', 'E', 'R', 'F', 'C', 'N', 'T', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'C', 'F', 'G', '\0', /* SDMA0_PERFCNT_PERFCOUNTER0_CFG (46425) */
	'S', 'D', 'M', 'A', '0', '_', 'P', 'E', 'R', 'F', 'C', 'N', 'T', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'C', 'F', 'G', '\0', /* SDMA0_PERFCNT_PERFCOUNTER1_CFG (46456) */
	'S', 'D', 'M', 'A', '0', '_', 'P', 'E', 'R', 'F', 'C', 'N', 'T', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '_', 'R', 'S', 'L', 'T', '_', 'C', 'N', 'T', 'L', '\0', /* SDMA0_PERFCNT_PERFCOUNTER_RSLT_CNTL (46487) */
	'S', 'D', 'M', 'A', '0', '_', 'P', 'E', 'R', 'F', 'C', 'N', 'T', '_', 'M', 'I', 'S', 'C', '_', 'C', 'N', 'T', 'L', '\0', /* SDMA0_PERFCNT_MISC_CNTL (46523) */
	'S', 'D', 'M', 'A', '0', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* SDMA0_PERFCOUNTER0_SELECT (46547) */
	'S', 'D', 'M', 'A', '0', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'S', 'E', 'L', 'E', 'C', 'T', '1', '\0', /* SDMA0_PERFCOUNTER0_SELECT1 (46573) */
	'S', 'D', 'M', 'A', '0', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* SDMA0_PERFCOUNTER1_SELECT (46600) */
	'S', 'D', 'M', 'A', '0', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'S', 'E', 'L', 'E', 'C', 'T', '1', '\0', /* SDMA0_PERFCOUNTER1_SELECT1 (46626) */
	'S', 'D', 'M', 'A', '1', '_', 'P', 'E', 'R', 'F', 'C', 'N', 'T', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'C', 'F', 'G', '\0', /* SDMA1_PERFCNT_PERFCOUNTER0_CFG (46653) */
	'S', 'D', 'M', 'A', '1', '_', 'P', 'E', 'R', 'F', 'C', 'N', 'T', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'C', 'F', 'G', '\0', /* SDMA1_PERFCNT_PERFCOUNTER1_CFG (46684) */
	'S', 'D', 'M', 'A', '1', '_', 'P', 'E', 'R', 'F', 'C', 'N', 'T', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '_', 'R', 'S', 'L', 'T', '_', 'C', 'N', 'T', 'L', '\0', /* SDMA1_PERFCNT_PERFCOUNTER_RSLT_CNTL (46715) */
	'S', 'D', 'M', 'A', '1', '_', 'P', 'E', 'R', 'F', 'C', 'N', 'T', '_', 'M', 'I', 'S', 'C', '_', 'C', 'N', 'T', 'L', '\0', /* SDMA1_PERFCNT_MISC_CNTL (46751) */
	'S', 'D', 'M', 'A', '1', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* SDMA1_PERFCOUNTER0_SELECT (46775) */
	'S', 'D', 'M', 'A', '1', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'S', 'E', 'L', 'E', 'C', 'T', '1', '\0', /* SDMA1_PERFCOUNTER0_SELECT1 (46801) */
	'S', 'D', 'M', 'A', '1', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* SDMA1_PERFCOUNTER1_SELECT (46828) */
	'S', 'D', 'M', 'A', '1', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'S', 'E', 'L', 'E', 'C', 'T', '1', '\0', /* SDMA1_PERFCOUNTER1_SELECT1 (46854) */
	'S', 'D', 'M', 'A', '2', '_', 'P', 'E', 'R', 'F', 'C', 'N', 'T', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'C', 'F', 'G', '\0', /* SDMA2_PERFCNT_PERFCOUNTER0_CFG (46881) */
	'S', 'D', 'M', 'A', '2', '_', 'P', 'E', 'R', 'F', 'C', 'N', 'T', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'C', 'F', 'G', '\0', /* SDMA2_PERFCNT_PERFCOUNTER1_CFG (46912) */
	'S', 'D', 'M', 'A', '2', '_', 'P', 'E', 'R', 'F', 'C', 'N', 'T', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '_', 'R', 'S', 'L', 'T', '_', 'C', 'N', 'T', 'L', '\0', /* SDMA2_PERFCNT_PERFCOUNTER_RSLT_CNTL (46943) */
	'S', 'D', 'M', 'A', '2', '_', 'P', 'E', 'R', 'F', 'C', 'N', 'T', '_', 'M', 'I', 'S', 'C', '_', 'C', 'N', 'T', 'L', '\0', /* SDMA2_PERFCNT_MISC_CNTL (46979) */
	'S', 'D', 'M', 'A', '2', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* SDMA2_PERFCOUNTER0_SELECT (47003) */
	'S', 'D', 'M', 'A', '2', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'S', 'E', 'L', 'E', 'C', 'T', '1', '\0', /* SDMA2_PERFCOUNTER0_SELECT1 (47029) */
	'S', 'D', 'M', 'A', '2', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* SDMA2_PERFCOUNTER1_SELECT (47056) */
	'S', 'D', 'M', 'A', '2', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'S', 'E', 'L', 'E', 'C', 'T', '1', '\0', /* SDMA2_PERFCOUNTER1_SELECT1 (47082) */
	'S', 'D', 'M', 'A', '3', '_', 'P', 'E', 'R', 'F', 'C', 'N', 'T', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'C', 'F', 'G', '\0', /* SDMA3_PERFCNT_PERFCOUNTER0_CFG (47109) */
	'S', 'D', 'M', 'A', '3', '_', 'P', 'E', 'R', 'F', 'C', 'N', 'T', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'C', 'F', 'G', '\0', /* SDMA3_PERFCNT_PERFCOUNTER1_CFG (47140) */
	'S', 'D', 'M', 'A', '3', '_', 'P', 'E', 'R', 'F', 'C', 'N', 'T', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '_', 'R', 'S', 'L', 'T', '_', 'C', 'N', 'T', 'L', '\0', /* SDMA3_PERFCNT_PERFCOUNTER_RSLT_CNTL (47171) */
	'S', 'D', 'M', 'A', '3', '_', 'P', 'E', 'R', 'F', 'C', 'N', 'T', '_', 'M', 'I', 'S', 'C', '_', 'C', 'N', 'T', 'L', '\0', /* SDMA3_PERFCNT_MISC_CNTL (47207) */
	'S', 'D', 'M', 'A', '3', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* SDMA3_PERFCOUNTER0_SELECT (47231) */
	'S', 'D', 'M', 'A', '3', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'S', 'E', 'L', 'E', 'C', 'T', '1', '\0', /* SDMA3_PERFCOUNTER0_SELECT1 (47257) */
	'S', 'D', 'M', 'A', '3', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* SDMA3_PERFCOUNTER1_SELECT (47284) */
	'S', 'D', 'M', 'A', '3', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'S', 'E', 'L', 'E', 'C', 'T', '1', '\0', /* SDMA3_PERFCOUNTER1_SELECT1 (47310) */
	'G', 'R', 'B', 'M', '_', 'S', 'T', 'A', 'T', 'U', 'S', '_', 'S', 'E', '4', '\0', /* GRBM_STATUS_SE4 (47337) */
	'G', 'R', 'B', 'M', '_', 'S', 'T', 'A', 'T', 'U', 'S', '_', 'S', 'E', '5', '\0', /* GRBM_STATUS_SE5 (47353) */
	'C', 'P', '_', 'C', 'P', 'C', '_', 'D', 'E', 'B', 'U', 'G', '_', 'C', 'N', 'T', 'L', '\0', /* CP_CPC_DEBUG_CNTL (47369) */
	'C', 'P', '_', 'C', 'P', 'C', '_', 'D', 'E', 'B', 'U', 'G', '_', 'D', 'A', 'T', 'A', '\0', /* CP_CPC_DEBUG_DATA (47387, 47394) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'G', 'S', '_', 'M', 'E', 'S', 'H', 'L', 'E', 'T', '_', 'D', 'I', 'M', '\0', /* SPI_SHADER_GS_MESHLET_DIM (47405, 47427) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'G', 'S', '_', 'M', 'E', 'S', 'H', 'L', 'E', 'T', '_', 'E', 'X', 'P', '_', 'A', 'L', 'L', 'O', 'C', '\0', /* SPI_SHADER_GS_MESHLET_EXP_ALLOC (47431) */
	'C', 'O', 'M', 'P', 'U', 'T', 'E', '_', 'S', 'T', 'A', 'T', 'I', 'C', '_', 'T', 'H', 'R', 'E', 'A', 'D', '_', 'M', 'G', 'M', 'T', '_', 'S', 'E', '4', '\0', /* COMPUTE_STATIC_THREAD_MGMT_SE4 (47463) */
	'C', 'O', 'M', 'P', 'U', 'T', 'E', '_', 'S', 'T', 'A', 'T', 'I', 'C', '_', 'T', 'H', 'R', 'E', 'A', 'D', '_', 'M', 'G', 'M', 'T', '_', 'S', 'E', '5', '\0', /* COMPUTE_STATIC_THREAD_MGMT_SE5 (47494) */
	'C', 'O', 'M', 'P', 'U', 'T', 'E', '_', 'S', 'T', 'A', 'T', 'I', 'C', '_', 'T', 'H', 'R', 'E', 'A', 'D', '_', 'M', 'G', 'M', 'T', '_', 'S', 'E', '6', '\0', /* COMPUTE_STATIC_THREAD_MGMT_SE6 (47525) */
	'C', 'O', 'M', 'P', 'U', 'T', 'E', '_', 'S', 'T', 'A', 'T', 'I', 'C', '_', 'T', 'H', 'R', 'E', 'A', 'D', '_', 'M', 'G', 'M', 'T', '_', 'S', 'E', '7', '\0', /* COMPUTE_STATIC_THREAD_MGMT_SE7 (47556) */
	'C', 'O', 'M', 'P', 'U', 'T', 'E', '_', 'D', 'I', 'S', 'P', 'A', 'T', 'C', 'H', '_', 'I', 'N', 'T', 'E', 'R', 'L', 'E', 'A', 'V', 'E', '\0', /* COMPUTE_DISPATCH_INTERLEAVE (47587, 47604) */
	'P', 'A', '_', 'S', 'C', '_', 'V', 'R', 'S', '_', 'O', 'V', 'E', 'R', 'R', 'I', 'D', 'E', '_', 'C', 'N', 'T', 'L', '\0', /* PA_SC_VRS_OVERRIDE_CNTL (47615) */
	'P', 'A', '_', 'S', 'C', '_', 'V', 'R', 'S', '_', 'R', 'A', 'T', 'E', '_', 'F', 'E', 'E', 'D', 'B', 'A', 'C', 'K', '_', 'B', 'A', 'S', 'E', '\0', /* PA_SC_VRS_RATE_FEEDBACK_BASE (47639) */
	'P', 'A', '_', 'S', 'C', '_', 'V', 'R', 'S', '_', 'R', 'A', 'T', 'E', '_', 'F', 'E', 'E', 'D', 'B', 'A', 'C', 'K', '_', 'B', 'A', 'S', 'E', '_', 'E', 'X', 'T', '\0', /* PA_SC_VRS_RATE_FEEDBACK_BASE_EXT (47668) */
	'P', 'A', '_', 'S', 'C', '_', 'V', 'R', 'S', '_', 'R', 'A', 'T', 'E', '_', 'F', 'E', 'E', 'D', 'B', 'A', 'C', 'K', '_', 'S', 'I', 'Z', 'E', '_', 'X', 'Y', '\0', /* PA_SC_VRS_RATE_FEEDBACK_SIZE_XY (47701) */
	'P', 'A', '_', 'S', 'C', '_', 'V', 'R', 'S', '_', 'R', 'A', 'T', 'E', '_', 'C', 'A', 'C', 'H', 'E', '_', 'C', 'N', 'T', 'L', '\0', /* PA_SC_VRS_RATE_CACHE_CNTL (47733) */
	'P', 'A', '_', 'S', 'C', '_', 'V', 'R', 'S', '_', 'R', 'A', 'T', 'E', '_', 'B', 'A', 'S', 'E', '\0', /* PA_SC_VRS_RATE_BASE (47759) */
	'P', 'A', '_', 'S', 'C', '_', 'V', 'R', 'S', '_', 'R', 'A', 'T', 'E', '_', 'B', 'A', 'S', 'E', '_', 'E', 'X', 'T', '\0', /* PA_SC_VRS_RATE_BASE_EXT (47779) */
	'P', 'A', '_', 'S', 'C', '_', 'V', 'R', 'S', '_', 'R', 'A', 'T', 'E', '_', 'S', 'I', 'Z', 'E', '_', 'X', 'Y', '\0', /* PA_SC_VRS_RATE_SIZE_XY (47803) */
	'C', 'B', '_', 'F', 'D', 'C', 'C', '_', 'C', 'O', 'N', 'T', 'R', 'O', 'L', '\0', /* CB_FDCC_CONTROL (47826) */
	'P', 'A', '_', 'R', 'A', 'T', 'E', '_', 'C', 'N', 'T', 'L', '\0', /* PA_RATE_CNTL (47842) */
	'S', 'P', 'I', '_', 'G', 'F', 'X', '_', 'S', 'C', 'R', 'A', 'T', 'C', 'H', '_', 'B', 'A', 'S', 'E', '_', 'L', 'O', '\0', /* SPI_GFX_SCRATCH_BASE_LO (47855) */
	'S', 'P', 'I', '_', 'G', 'F', 'X', '_', 'S', 'C', 'R', 'A', 'T', 'C', 'H', '_', 'B', 'A', 'S', 'E', '_', 'H', 'I', '\0', /* SPI_GFX_SCRATCH_BASE_HI (47879) */
	'P', 'A', '_', 'S', 'C', '_', 'B', 'I', 'N', 'N', 'E', 'R', '_', 'C', 'N', 'T', 'L', '_', '2', '\0', /* PA_SC_BINNER_CNTL_2 (47903) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '0', '_', 'F', 'D', 'C', 'C', '_', 'C', 'O', 'N', 'T', 'R', 'O', 'L', '\0', /* CB_COLOR0_FDCC_CONTROL (47923) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '1', '_', 'F', 'D', 'C', 'C', '_', 'C', 'O', 'N', 'T', 'R', 'O', 'L', '\0', /* CB_COLOR1_FDCC_CONTROL (47946) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '2', '_', 'F', 'D', 'C', 'C', '_', 'C', 'O', 'N', 'T', 'R', 'O', 'L', '\0', /* CB_COLOR2_FDCC_CONTROL (47969) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '3', '_', 'F', 'D', 'C', 'C', '_', 'C', 'O', 'N', 'T', 'R', 'O', 'L', '\0', /* CB_COLOR3_FDCC_CONTROL (47992) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '4', '_', 'F', 'D', 'C', 'C', '_', 'C', 'O', 'N', 'T', 'R', 'O', 'L', '\0', /* CB_COLOR4_FDCC_CONTROL (48015) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '5', '_', 'F', 'D', 'C', 'C', '_', 'C', 'O', 'N', 'T', 'R', 'O', 'L', '\0', /* CB_COLOR5_FDCC_CONTROL (48038) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '6', '_', 'F', 'D', 'C', 'C', '_', 'C', 'O', 'N', 'T', 'R', 'O', 'L', '\0', /* CB_COLOR6_FDCC_CONTROL (48061) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '7', '_', 'F', 'D', 'C', 'C', '_', 'C', 'O', 'N', 'T', 'R', 'O', 'L', '\0', /* CB_COLOR7_FDCC_CONTROL (48084) */
	'C', 'P', '_', 'V', 'G', 'T', '_', 'A', 'S', 'I', 'N', 'V', 'O', 'C', '_', 'C', 'O', 'U', 'N', 'T', '_', 'L', 'O', '\0', /* CP_VGT_ASINVOC_COUNT_LO (48107) */
	'C', 'P', '_', 'V', 'G', 'T', '_', 'A', 'S', 'I', 'N', 'V', 'O', 'C', '_', 'C', 'O', 'U', 'N', 'T', '_', 'H', 'I', '\0', /* CP_VGT_ASINVOC_COUNT_HI (48131) */
	'C', 'P', '_', 'P', 'A', '_', 'M', 'S', 'P', 'R', 'I', 'M', '_', 'C', 'O', 'U', 'N', 'T', '_', 'L', 'O', '\0', /* CP_PA_MSPRIM_COUNT_LO (48155) */
	'C', 'P', '_', 'P', 'A', '_', 'M', 'S', 'P', 'R', 'I', 'M', '_', 'C', 'O', 'U', 'N', 'T', '_', 'H', 'I', '\0', /* CP_PA_MSPRIM_COUNT_HI (48177) */
	'C', 'P', '_', 'G', 'E', '_', 'M', 'S', 'I', 'N', 'V', 'O', 'C', '_', 'C', 'O', 'U', 'N', 'T', '_', 'L', 'O', '\0', /* CP_GE_MSINVOC_COUNT_LO (48199) */
	'C', 'P', '_', 'G', 'E', '_', 'M', 'S', 'I', 'N', 'V', 'O', 'C', '_', 'C', 'O', 'U', 'N', 'T', '_', 'H', 'I', '\0', /* CP_GE_MSINVOC_COUNT_HI (48222) */
	'G', 'E', '_', 'G', 'S', '_', 'F', 'A', 'S', 'T', '_', 'L', 'A', 'U', 'N', 'C', 'H', '_', 'W', 'G', '_', 'D', 'I', 'M', '\0', /* GE_GS_FAST_LAUNCH_WG_DIM (48245) */
	'G', 'E', '_', 'G', 'S', '_', 'F', 'A', 'S', 'T', '_', 'L', 'A', 'U', 'N', 'C', 'H', '_', 'W', 'G', '_', 'D', 'I', 'M', '_', '1', '\0', /* GE_GS_FAST_LAUNCH_WG_DIM_1 (48270) */
	'G', 'D', 'S', '_', 'S', 'T', 'R', 'M', 'O', 'U', 'T', '_', 'D', 'W', 'O', 'R', 'D', 'S', '_', 'W', 'R', 'I', 'T', 'T', 'E', 'N', '_', '0', '\0', /* GDS_STRMOUT_DWORDS_WRITTEN_0 (48297) */
	'G', 'D', 'S', '_', 'S', 'T', 'R', 'M', 'O', 'U', 'T', '_', 'D', 'W', 'O', 'R', 'D', 'S', '_', 'W', 'R', 'I', 'T', 'T', 'E', 'N', '_', '1', '\0', /* GDS_STRMOUT_DWORDS_WRITTEN_1 (48326) */
	'G', 'D', 'S', '_', 'S', 'T', 'R', 'M', 'O', 'U', 'T', '_', 'D', 'W', 'O', 'R', 'D', 'S', '_', 'W', 'R', 'I', 'T', 'T', 'E', 'N', '_', '2', '\0', /* GDS_STRMOUT_DWORDS_WRITTEN_2 (48355) */
	'G', 'D', 'S', '_', 'S', 'T', 'R', 'M', 'O', 'U', 'T', '_', 'D', 'W', 'O', 'R', 'D', 'S', '_', 'W', 'R', 'I', 'T', 'T', 'E', 'N', '_', '3', '\0', /* GDS_STRMOUT_DWORDS_WRITTEN_3 (48384) */
	'G', 'D', 'S', '_', 'G', 'S', '_', '0', '\0', /* GDS_GS_0 (48413) */
	'G', 'D', 'S', '_', 'G', 'S', '_', '1', '\0', /* GDS_GS_1 (48422) */
	'G', 'D', 'S', '_', 'G', 'S', '_', '2', '\0', /* GDS_GS_2 (48431) */
	'G', 'D', 'S', '_', 'G', 'S', '_', '3', '\0', /* GDS_GS_3 (48440) */
	'G', 'D', 'S', '_', 'S', 'T', 'R', 'M', 'O', 'U', 'T', '_', 'P', 'R', 'I', 'M', 'S', '_', 'N', 'E', 'E', 'D', 'E', 'D', '_', '0', '_', 'L', 'O', '\0', /* GDS_STRMOUT_PRIMS_NEEDED_0_LO (48449) */
	'G', 'D', 'S', '_', 'S', 'T', 'R', 'M', 'O', 'U', 'T', '_', 'P', 'R', 'I', 'M', 'S', '_', 'N', 'E', 'E', 'D', 'E', 'D', '_', '0', '_', 'H', 'I', '\0', /* GDS_STRMOUT_PRIMS_NEEDED_0_HI (48479) */
	'G', 'D', 'S', '_', 'S', 'T', 'R', 'M', 'O', 'U', 'T', '_', 'P', 'R', 'I', 'M', 'S', '_', 'W', 'R', 'I', 'T', 'T', 'E', 'N', '_', '0', '_', 'L', 'O', '\0', /* GDS_STRMOUT_PRIMS_WRITTEN_0_LO (48509) */
	'G', 'D', 'S', '_', 'S', 'T', 'R', 'M', 'O', 'U', 'T', '_', 'P', 'R', 'I', 'M', 'S', '_', 'W', 'R', 'I', 'T', 'T', 'E', 'N', '_', '0', '_', 'H', 'I', '\0', /* GDS_STRMOUT_PRIMS_WRITTEN_0_HI (48540) */
	'G', 'D', 'S', '_', 'S', 'T', 'R', 'M', 'O', 'U', 'T', '_', 'P', 'R', 'I', 'M', 'S', '_', 'N', 'E', 'E', 'D', 'E', 'D', '_', '1', '_', 'L', 'O', '\0', /* GDS_STRMOUT_PRIMS_NEEDED_1_LO (48571) */
	'G', 'D', 'S', '_', 'S', 'T', 'R', 'M', 'O', 'U', 'T', '_', 'P', 'R', 'I', 'M', 'S', '_', 'N', 'E', 'E', 'D', 'E', 'D', '_', '1', '_', 'H', 'I', '\0', /* GDS_STRMOUT_PRIMS_NEEDED_1_HI (48601) */
	'G', 'D', 'S', '_', 'S', 'T', 'R', 'M', 'O', 'U', 'T', '_', 'P', 'R', 'I', 'M', 'S', '_', 'W', 'R', 'I', 'T', 'T', 'E', 'N', '_', '1', '_', 'L', 'O', '\0', /* GDS_STRMOUT_PRIMS_WRITTEN_1_LO (48631) */
	'G', 'D', 'S', '_', 'S', 'T', 'R', 'M', 'O', 'U', 'T', '_', 'P', 'R', 'I', 'M', 'S', '_', 'W', 'R', 'I', 'T', 'T', 'E', 'N', '_', '1', '_', 'H', 'I', '\0', /* GDS_STRMOUT_PRIMS_WRITTEN_1_HI (48662) */
	'G', 'D', 'S', '_', 'S', 'T', 'R', 'M', 'O', 'U', 'T', '_', 'P', 'R', 'I', 'M', 'S', '_', 'N', 'E', 'E', 'D', 'E', 'D', '_', '2', '_', 'L', 'O', '\0', /* GDS_STRMOUT_PRIMS_NEEDED_2_LO (48693) */
	'G', 'D', 'S', '_', 'S', 'T', 'R', 'M', 'O', 'U', 'T', '_', 'P', 'R', 'I', 'M', 'S', '_', 'N', 'E', 'E', 'D', 'E', 'D', '_', '2', '_', 'H', 'I', '\0', /* GDS_STRMOUT_PRIMS_NEEDED_2_HI (48723) */
	'G', 'D', 'S', '_', 'S', 'T', 'R', 'M', 'O', 'U', 'T', '_', 'P', 'R', 'I', 'M', 'S', '_', 'W', 'R', 'I', 'T', 'T', 'E', 'N', '_', '2', '_', 'L', 'O', '\0', /* GDS_STRMOUT_PRIMS_WRITTEN_2_LO (48753) */
	'G', 'D', 'S', '_', 'S', 'T', 'R', 'M', 'O', 'U', 'T', '_', 'P', 'R', 'I', 'M', 'S', '_', 'W', 'R', 'I', 'T', 'T', 'E', 'N', '_', '2', '_', 'H', 'I', '\0', /* GDS_STRMOUT_PRIMS_WRITTEN_2_HI (48784) */
	'G', 'D', 'S', '_', 'S', 'T', 'R', 'M', 'O', 'U', 'T', '_', 'P', 'R', 'I', 'M', 'S', '_', 'N', 'E', 'E', 'D', 'E', 'D', '_', '3', '_', 'L', 'O', '\0', /* GDS_STRMOUT_PRIMS_NEEDED_3_LO (48815) */
	'G', 'D', 'S', '_', 'S', 'T', 'R', 'M', 'O', 'U', 'T', '_', 'P', 'R', 'I', 'M', 'S', '_', 'N', 'E', 'E', 'D', 'E', 'D', '_', '3', '_', 'H', 'I', '\0', /* GDS_STRMOUT_PRIMS_NEEDED_3_HI (48845) */
	'G', 'D', 'S', '_', 'S', 'T', 'R', 'M', 'O', 'U', 'T', '_', 'P', 'R', 'I', 'M', 'S', '_', 'W', 'R', 'I', 'T', 'T', 'E', 'N', '_', '3', '_', 'L', 'O', '\0', /* GDS_STRMOUT_PRIMS_WRITTEN_3_LO (48875) */
	'G', 'D', 'S', '_', 'S', 'T', 'R', 'M', 'O', 'U', 'T', '_', 'P', 'R', 'I', 'M', 'S', '_', 'W', 'R', 'I', 'T', 'T', 'E', 'N', '_', '3', '_', 'H', 'I', '\0', /* GDS_STRMOUT_PRIMS_WRITTEN_3_HI (48906) */
	'S', 'P', 'I', '_', 'C', 'O', 'N', 'F', 'I', 'G', '_', 'C', 'N', 'T', 'L', '_', '1', '\0', /* SPI_CONFIG_CNTL_1 (48937) */
	'S', 'P', 'I', '_', 'C', 'O', 'N', 'F', 'I', 'G', '_', 'C', 'N', 'T', 'L', '_', '2', '\0', /* SPI_CONFIG_CNTL_2 (48955) */
	'S', 'P', 'I', '_', 'W', 'A', 'V', 'E', '_', 'L', 'I', 'M', 'I', 'T', '_', 'C', 'N', 'T', 'L', '\0', /* SPI_WAVE_LIMIT_CNTL (48973) */
	'S', 'P', 'I', '_', 'G', 'S', '_', 'T', 'H', 'R', 'O', 'T', 'T', 'L', 'E', '_', 'C', 'N', 'T', 'L', '1', '\0', /* SPI_GS_THROTTLE_CNTL1 (48993) */
	'S', 'P', 'I', '_', 'G', 'S', '_', 'T', 'H', 'R', 'O', 'T', 'T', 'L', 'E', '_', 'C', 'N', 'T', 'L', '2', '\0', /* SPI_GS_THROTTLE_CNTL2 (49015) */
	'S', 'P', 'I', '_', 'A', 'T', 'T', 'R', 'I', 'B', 'U', 'T', 'E', '_', 'R', 'I', 'N', 'G', '_', 'B', 'A', 'S', 'E', '\0', /* SPI_ATTRIBUTE_RING_BASE (49037) */
	'S', 'P', 'I', '_', 'A', 'T', 'T', 'R', 'I', 'B', 'U', 'T', 'E', '_', 'R', 'I', 'N', 'G', '_', 'S', 'I', 'Z', 'E', '\0', /* SPI_ATTRIBUTE_RING_SIZE (49061) */
	'G', 'R', 'B', 'M', '_', 'S', 'E', '4', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '_', 'L', 'O', '\0', /* GRBM_SE4_PERFCOUNTER_LO (49085) */
	'G', 'R', 'B', 'M', '_', 'S', 'E', '4', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '_', 'H', 'I', '\0', /* GRBM_SE4_PERFCOUNTER_HI (49109) */
	'G', 'R', 'B', 'M', '_', 'S', 'E', '5', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '_', 'L', 'O', '\0', /* GRBM_SE5_PERFCOUNTER_LO (49133) */
	'G', 'R', 'B', 'M', '_', 'S', 'E', '5', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '_', 'H', 'I', '\0', /* GRBM_SE5_PERFCOUNTER_HI (49157) */
	'G', 'R', 'B', 'M', '_', 'S', 'E', '6', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '_', 'L', 'O', '\0', /* GRBM_SE6_PERFCOUNTER_LO (49181) */
	'G', 'R', 'B', 'M', '_', 'S', 'E', '6', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '_', 'H', 'I', '\0', /* GRBM_SE6_PERFCOUNTER_HI (49205) */
	'P', 'C', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', 'H', 'I', '\0', /* PC_PERFCOUNTER2_HI (49229) */
	'P', 'C', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', 'L', 'O', '\0', /* PC_PERFCOUNTER2_LO (49248) */
	'P', 'C', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '3', '_', 'H', 'I', '\0', /* PC_PERFCOUNTER3_HI (49267) */
	'P', 'C', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '3', '_', 'L', 'O', '\0', /* PC_PERFCOUNTER3_LO (49286) */
	'S', 'Q', 'G', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'L', 'O', '\0', /* SQG_PERFCOUNTER0_LO (49305) */
	'S', 'Q', 'G', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'H', 'I', '\0', /* SQG_PERFCOUNTER0_HI (49325) */
	'S', 'Q', 'G', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'L', 'O', '\0', /* SQG_PERFCOUNTER1_LO (49345) */
	'S', 'Q', 'G', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'H', 'I', '\0', /* SQG_PERFCOUNTER1_HI (49365) */
	'S', 'Q', 'G', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', 'L', 'O', '\0', /* SQG_PERFCOUNTER2_LO (49385) */
	'S', 'Q', 'G', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', 'H', 'I', '\0', /* SQG_PERFCOUNTER2_HI (49405) */
	'S', 'Q', 'G', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '3', '_', 'L', 'O', '\0', /* SQG_PERFCOUNTER3_LO (49425) */
	'S', 'Q', 'G', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '3', '_', 'H', 'I', '\0', /* SQG_PERFCOUNTER3_HI (49445) */
	'S', 'Q', 'G', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '4', '_', 'L', 'O', '\0', /* SQG_PERFCOUNTER4_LO (49465) */
	'S', 'Q', 'G', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '4', '_', 'H', 'I', '\0', /* SQG_PERFCOUNTER4_HI (49485) */
	'S', 'Q', 'G', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '5', '_', 'L', 'O', '\0', /* SQG_PERFCOUNTER5_LO (49505) */
	'S', 'Q', 'G', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '5', '_', 'H', 'I', '\0', /* SQG_PERFCOUNTER5_HI (49525) */
	'S', 'Q', 'G', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '6', '_', 'L', 'O', '\0', /* SQG_PERFCOUNTER6_LO (49545) */
	'S', 'Q', 'G', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '6', '_', 'H', 'I', '\0', /* SQG_PERFCOUNTER6_HI (49565) */
	'S', 'Q', 'G', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '7', '_', 'L', 'O', '\0', /* SQG_PERFCOUNTER7_LO (49585) */
	'S', 'Q', 'G', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '7', '_', 'H', 'I', '\0', /* SQG_PERFCOUNTER7_HI (49605) */
	'T', 'C', 'P', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '_', 'F', 'I', 'L', 'T', 'E', 'R', '\0', /* TCP_PERFCOUNTER_FILTER (49625) */
	'T', 'C', 'P', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '_', 'F', 'I', 'L', 'T', 'E', 'R', '2', '\0', /* TCP_PERFCOUNTER_FILTER2 (49648) */
	'T', 'C', 'P', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '_', 'F', 'I', 'L', 'T', 'E', 'R', '_', 'E', 'N', '\0', /* TCP_PERFCOUNTER_FILTER_EN (49672) */
	'U', 'T', 'C', 'L', '1', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', 'L', 'O', '\0', /* UTCL1_PERFCOUNTER2_LO (49698) */
	'U', 'T', 'C', 'L', '1', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', 'H', 'I', '\0', /* UTCL1_PERFCOUNTER2_HI (49720) */
	'U', 'T', 'C', 'L', '1', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '3', '_', 'L', 'O', '\0', /* UTCL1_PERFCOUNTER3_LO (49742) */
	'U', 'T', 'C', 'L', '1', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '3', '_', 'H', 'I', '\0', /* UTCL1_PERFCOUNTER3_HI (49764) */
	'G', 'L', '1', 'H', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'L', 'O', '\0', /* GL1H_PERFCOUNTER0_LO (49786) */
	'G', 'L', '1', 'H', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'H', 'I', '\0', /* GL1H_PERFCOUNTER0_HI (49807) */
	'G', 'L', '1', 'H', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'L', 'O', '\0', /* GL1H_PERFCOUNTER1_LO (49828) */
	'G', 'L', '1', 'H', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'H', 'I', '\0', /* GL1H_PERFCOUNTER1_HI (49849) */
	'G', 'L', '1', 'H', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', 'L', 'O', '\0', /* GL1H_PERFCOUNTER2_LO (49870) */
	'G', 'L', '1', 'H', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', 'H', 'I', '\0', /* GL1H_PERFCOUNTER2_HI (49891) */
	'G', 'L', '1', 'H', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '3', '_', 'L', 'O', '\0', /* GL1H_PERFCOUNTER3_LO (49912) */
	'G', 'L', '1', 'H', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '3', '_', 'H', 'I', '\0', /* GL1H_PERFCOUNTER3_HI (49933) */
	'C', 'P', 'C', '_', 'T', 'C', '_', 'P', 'E', 'R', 'F', '_', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '_', 'W', 'I', 'N', 'D', 'O', 'W', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* CPC_TC_PERF_COUNTER_WINDOW_SELECT (49954) */
	'G', 'R', 'B', 'M', '_', 'S', 'E', '4', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* GRBM_SE4_PERFCOUNTER_SELECT (49988) */
	'G', 'R', 'B', 'M', '_', 'S', 'E', '5', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* GRBM_SE5_PERFCOUNTER_SELECT (50016) */
	'G', 'R', 'B', 'M', '_', 'S', 'E', '6', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* GRBM_SE6_PERFCOUNTER_SELECT (50044) */
	'P', 'C', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* PC_PERFCOUNTER2_SELECT (50072) */
	'P', 'C', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '3', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* PC_PERFCOUNTER3_SELECT (50095) */
	'P', 'C', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'S', 'E', 'L', 'E', 'C', 'T', '1', '\0', /* PC_PERFCOUNTER1_SELECT1 (50118) */
	'P', 'C', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', 'S', 'E', 'L', 'E', 'C', 'T', '1', '\0', /* PC_PERFCOUNTER2_SELECT1 (50142) */
	'P', 'C', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '3', '_', 'S', 'E', 'L', 'E', 'C', 'T', '1', '\0', /* PC_PERFCOUNTER3_SELECT1 (50166) */
	'S', 'Q', 'G', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* SQG_PERFCOUNTER0_SELECT (50190) */
	'S', 'Q', 'G', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* SQG_PERFCOUNTER1_SELECT (50214) */
	'S', 'Q', 'G', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* SQG_PERFCOUNTER2_SELECT (50238) */
	'S', 'Q', 'G', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '3', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* SQG_PERFCOUNTER3_SELECT (50262) */
	'S', 'Q', 'G', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '4', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* SQG_PERFCOUNTER4_SELECT (50286) */
	'S', 'Q', 'G', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '5', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* SQG_PERFCOUNTER5_SELECT (50310) */
	'S', 'Q', 'G', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '6', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* SQG_PERFCOUNTER6_SELECT (50334) */
	'S', 'Q', 'G', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '7', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* SQG_PERFCOUNTER7_SELECT (50358) */
	'S', 'Q', 'G', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '_', 'C', 'T', 'R', 'L', '\0', /* SQG_PERFCOUNTER_CTRL (50382) */
	'S', 'Q', 'G', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '_', 'C', 'T', 'R', 'L', '2', '\0', /* SQG_PERFCOUNTER_CTRL2 (50403) */
	'S', 'Q', 'G', '_', 'P', 'E', 'R', 'F', '_', 'S', 'A', 'M', 'P', 'L', 'E', '_', 'F', 'I', 'N', 'I', 'S', 'H', '\0', /* SQG_PERF_SAMPLE_FINISH (50425) */
	'R', 'L', 'C', '_', 'S', 'P', 'M', '_', 'P', 'A', 'U', 'S', 'E', '\0', /* RLC_SPM_PAUSE (50448, 50456) */
	'R', 'L', 'C', '_', 'S', 'P', 'M', '_', 'S', 'T', 'A', 'T', 'U', 'S', '\0', /* RLC_SPM_STATUS (50462) */
	'R', 'L', 'C', '_', 'S', 'P', 'M', '_', 'M', 'O', 'D', 'E', '\0', /* RLC_SPM_MODE (50477, 50481) */
	'R', 'L', 'C', '_', 'S', 'P', 'M', '_', 'R', 'S', 'P', 'M', '_', 'R', 'E', 'Q', '_', 'D', 'A', 'T', 'A', '_', 'L', 'O', '\0', /* RLC_SPM_RSPM_REQ_DATA_LO (50490) */
	'R', 'L', 'C', '_', 'S', 'P', 'M', '_', 'R', 'S', 'P', 'M', '_', 'R', 'E', 'Q', '_', 'D', 'A', 'T', 'A', '_', 'H', 'I', '\0', /* RLC_SPM_RSPM_REQ_DATA_HI (50515) */
	'R', 'L', 'C', '_', 'S', 'P', 'M', '_', 'R', 'S', 'P', 'M', '_', 'R', 'E', 'Q', '_', 'O', 'P', '\0', /* RLC_SPM_RSPM_REQ_OP (50540) */
	'R', 'L', 'C', '_', 'S', 'P', 'M', '_', 'R', 'S', 'P', 'M', '_', 'R', 'E', 'T', '_', 'D', 'A', 'T', 'A', '\0', /* RLC_SPM_RSPM_RET_DATA (50560) */
	'R', 'L', 'C', '_', 'S', 'P', 'M', '_', 'R', 'S', 'P', 'M', '_', 'R', 'E', 'T', '_', 'O', 'P', '\0', /* RLC_SPM_RSPM_RET_OP (50582) */
	'R', 'L', 'C', '_', 'S', 'P', 'M', '_', 'S', 'E', '_', 'R', 'S', 'P', 'M', '_', 'R', 'E', 'Q', '_', 'D', 'A', 'T', 'A', '_', 'L', 'O', '\0', /* RLC_SPM_SE_RSPM_REQ_DATA_LO (50602) */
	'R', 'L', 'C', '_', 'S', 'P', 'M', '_', 'S', 'E', '_', 'R', 'S', 'P', 'M', '_', 'R', 'E', 'Q', '_', 'D', 'A', 'T', 'A', '_', 'H', 'I', '\0', /* RLC_SPM_SE_RSPM_REQ_DATA_HI (50630) */
	'R', 'L', 'C', '_', 'S', 'P', 'M', '_', 'S', 'E', '_', 'R', 'S', 'P', 'M', '_', 'R', 'E', 'Q', '_', 'O', 'P', '\0', /* RLC_SPM_SE_RSPM_REQ_OP (50658) */
	'R', 'L', 'C', '_', 'S', 'P', 'M', '_', 'S', 'E', '_', 'R', 'S', 'P', 'M', '_', 'R', 'E', 'T', '_', 'D', 'A', 'T', 'A', '\0', /* RLC_SPM_SE_RSPM_RET_DATA (50681) */
	'R', 'L', 'C', '_', 'S', 'P', 'M', '_', 'S', 'E', '_', 'R', 'S', 'P', 'M', '_', 'R', 'E', 'T', '_', 'O', 'P', '\0', /* RLC_SPM_SE_RSPM_RET_OP (50706) */
	'R', 'L', 'C', '_', 'S', 'P', 'M', '_', 'R', 'S', 'P', 'M', '_', 'C', 'M', 'D', '\0', /* RLC_SPM_RSPM_CMD (50729, 50742) */
	'R', 'L', 'C', '_', 'S', 'P', 'M', '_', 'R', 'S', 'P', 'M', '_', 'C', 'M', 'D', '_', 'A', 'C', 'K', '\0', /* RLC_SPM_RSPM_CMD_ACK (50746) */
	'R', 'L', 'C', '_', 'S', 'P', 'M', '_', 'S', 'P', 'A', 'R', 'E', '\0', /* RLC_SPM_SPARE (50767) */
	'U', 'T', 'C', 'L', '1', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* UTCL1_PERFCOUNTER2_SELECT (50781) */
	'U', 'T', 'C', 'L', '1', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '3', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* UTCL1_PERFCOUNTER3_SELECT (50807) */
	'G', 'L', '1', 'H', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* GL1H_PERFCOUNTER0_SELECT (50833) */
	'G', 'L', '1', 'H', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'S', 'E', 'L', 'E', 'C', 'T', '1', '\0', /* GL1H_PERFCOUNTER0_SELECT1 (50858) */
	'G', 'L', '1', 'H', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* GL1H_PERFCOUNTER1_SELECT (50884) */
	'G', 'L', '1', 'H', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* GL1H_PERFCOUNTER2_SELECT (50909) */
	'G', 'L', '1', 'H', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '3', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* GL1H_PERFCOUNTER3_SELECT (50934) */
	'A', 'C', 'Q', 'U', 'I', 'R', 'E', '_', 'M', 'E', 'M', '_', 'P', 'W', 'S', '_', '2', '\0', /* ACQUIRE_MEM_PWS_2 (50959) */
	'A', 'C', 'Q', 'U', 'I', 'R', 'E', '_', 'M', 'E', 'M', '_', 'P', 'W', 'S', '_', '7', '\0', /* ACQUIRE_MEM_PWS_7 (50977) */
	'D', 'B', '_', 'S', 'P', 'I', '_', 'V', 'R', 'S', '_', 'C', 'E', 'N', 'T', 'E', 'R', '_', 'L', 'O', 'C', 'A', 'T', 'I', 'O', 'N', '\0', /* DB_SPI_VRS_CENTER_LOCATION (50995) */
	'S', 'P', 'I', '_', 'B', 'A', 'R', 'Y', 'C', '_', 'S', 'S', 'A', 'A', '_', 'C', 'N', 'T', 'L', '\0', /* SPI_BARYC_SSAA_CNTL (51022) */
	'P', 'A', '_', 'S', 'C', '_', 'B', 'I', 'N', 'N', 'E', 'R', '_', 'O', 'U', 'T', 'P', 'U', 'T', '_', 'T', 'I', 'M', 'E', 'O', 'U', 'T', '_', 'C', 'N', 'T', 'L', '\0', /* PA_SC_BINNER_OUTPUT_TIMEOUT_CNTL (51042) */
	'G', 'C', 'L', '2', 'T', 'L', 'B', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '_', 'L', 'O', '\0', /* GCL2TLB_PERFCOUNTER_LO (51075) */
	'G', 'C', 'L', '2', 'T', 'L', 'B', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '_', 'H', 'I', '\0', /* GCL2TLB_PERFCOUNTER_HI (51098) */
	'G', 'C', 'L', '2', 'T', 'L', 'B', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'C', 'F', 'G', '\0', /* GCL2TLB_PERFCOUNTER0_CFG (51121) */
	'G', 'C', 'L', '2', 'T', 'L', 'B', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'C', 'F', 'G', '\0', /* GCL2TLB_PERFCOUNTER1_CFG (51146) */
	'G', 'C', 'L', '2', 'T', 'L', 'B', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', 'C', 'F', 'G', '\0', /* GCL2TLB_PERFCOUNTER2_CFG (51171) */
	'G', 'C', 'L', '2', 'T', 'L', 'B', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '3', '_', 'C', 'F', 'G', '\0', /* GCL2TLB_PERFCOUNTER3_CFG (51196) */
	'G', 'C', 'L', '2', 'T', 'L', 'B', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '_', 'R', 'S', 'L', 'T', '_', 'C', 'N', 'T', 'L', '\0', /* GCL2TLB_PERFCOUNTER_RSLT_CNTL (51221) */
	'S', 'Q', '_', 'W', 'A', 'V', 'E', '_', 'S', 'T', 'A', 'T', 'E', '_', 'P', 'R', 'I', 'V', '\0', /* SQ_WAVE_STATE_PRIV (51251, 51265) */
	'S', 'Q', '_', 'W', 'A', 'V', 'E', '_', 'E', 'X', 'C', 'P', '_', 'F', 'L', 'A', 'G', '_', 'P', 'R', 'I', 'V', '\0', /* SQ_WAVE_EXCP_FLAG_PRIV (51270) */
	'S', 'Q', '_', 'W', 'A', 'V', 'E', '_', 'E', 'X', 'C', 'P', '_', 'F', 'L', 'A', 'G', '_', 'U', 'S', 'E', 'R', '\0', /* SQ_WAVE_EXCP_FLAG_USER (51293) */
	'S', 'Q', '_', 'W', 'A', 'V', 'E', '_', 'T', 'R', 'A', 'P', '_', 'C', 'T', 'R', 'L', '\0', /* SQ_WAVE_TRAP_CTRL (51316) */
	'S', 'Q', '_', 'W', 'A', 'V', 'E', '_', 'S', 'C', 'R', 'A', 'T', 'C', 'H', '_', 'B', 'A', 'S', 'E', '_', 'L', 'O', '\0', /* SQ_WAVE_SCRATCH_BASE_LO (51334) */
	'S', 'Q', '_', 'W', 'A', 'V', 'E', '_', 'S', 'C', 'R', 'A', 'T', 'C', 'H', '_', 'B', 'A', 'S', 'E', '_', 'H', 'I', '\0', /* SQ_WAVE_SCRATCH_BASE_HI (51358) */
	'S', 'Q', '_', 'W', 'A', 'V', 'E', '_', 'D', 'V', 'G', 'P', 'R', '_', 'A', 'L', 'L', 'O', 'C', '_', 'L', 'O', '\0', /* SQ_WAVE_DVGPR_ALLOC_LO (51382) */
	'S', 'Q', '_', 'W', 'A', 'V', 'E', '_', 'D', 'V', 'G', 'P', 'R', '_', 'A', 'L', 'L', 'O', 'C', '_', 'H', 'I', '\0', /* SQ_WAVE_DVGPR_ALLOC_HI (51405) */
	'C', 'P', '_', 'C', 'P', 'F', '_', 'D', 'E', 'B', 'U', 'G', '_', 'C', 'N', 'T', 'L', '\0', /* CP_CPF_DEBUG_CNTL (51428) */
	'C', 'P', '_', 'C', 'P', 'C', '_', 'P', 'R', 'I', 'V', '_', 'V', 'I', 'O', 'L', 'A', 'T', 'I', 'O', 'N', '_', 'A', 'D', 'D', 'R', '_', 'H', 'I', '\0', /* CP_CPC_PRIV_VIOLATION_ADDR_HI (51446) */
	'G', 'C', 'V', 'M', '_', 'L', '2', '_', 'P', 'R', 'O', 'T', 'E', 'C', 'T', 'I', 'O', 'N', '_', 'F', 'A', 'U', 'L', 'T', '_', 'S', 'T', 'A', 'T', 'U', 'S', '_', 'L', 'O', '3', '2', '\0', /* GCVM_L2_PROTECTION_FAULT_STATUS_LO32 (51476) */
	'G', 'C', 'V', 'M', '_', 'L', '2', '_', 'P', 'R', 'O', 'T', 'E', 'C', 'T', 'I', 'O', 'N', '_', 'F', 'A', 'U', 'L', 'T', '_', 'S', 'T', 'A', 'T', 'U', 'S', '_', 'H', 'I', '3', '2', '\0', /* GCVM_L2_PROTECTION_FAULT_STATUS_HI32 (51513) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'G', 'S', '_', 'O', 'U', 'T', '_', 'C', 'O', 'N', 'F', 'I', 'G', '_', 'P', 'S', '\0', /* SPI_SHADER_GS_OUT_CONFIG_PS (51550) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'G', 'S', '_', 'M', 'E', 'S', 'H', 'L', 'E', 'T', '_', 'C', 'T', 'R', 'L', '\0', /* SPI_SHADER_GS_MESHLET_CTRL (51578) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'G', 'S', '_', 'O', 'U', 'T', '_', 'C', 'O', 'N', 'F', 'I', 'G', '_', 'P', 'S', '_', 'G', 'S', '\0', /* SPI_SHADER_GS_OUT_CONFIG_PS_GS (51605) */
	'C', 'O', 'M', 'P', 'U', 'T', 'E', '_', 'S', 'T', 'A', 'T', 'I', 'C', '_', 'T', 'H', 'R', 'E', 'A', 'D', '_', 'M', 'G', 'M', 'T', '_', 'S', 'E', '8', '\0', /* COMPUTE_STATIC_THREAD_MGMT_SE8 (51636) */
	'C', 'O', 'M', 'P', 'U', 'T', 'E', '_', 'P', 'R', 'E', 'S', 'C', 'A', 'L', 'E', 'D', '_', 'D', 'I', 'M', '_', 'X', '\0', /* COMPUTE_PRESCALED_DIM_X (51667) */
	'C', 'O', 'M', 'P', 'U', 'T', 'E', '_', 'P', 'R', 'E', 'S', 'C', 'A', 'L', 'E', 'D', '_', 'D', 'I', 'M', '_', 'Y', '\0', /* COMPUTE_PRESCALED_DIM_Y (51691) */
	'C', 'O', 'M', 'P', 'U', 'T', 'E', '_', 'P', 'R', 'E', 'S', 'C', 'A', 'L', 'E', 'D', '_', 'D', 'I', 'M', '_', 'Z', '\0', /* COMPUTE_PRESCALED_DIM_Z (51715) */
	'D', 'B', '_', 'D', 'E', 'P', 'T', 'H', '_', 'V', 'I', 'E', 'W', '1', '\0', /* DB_DEPTH_VIEW1 (51739) */
	'D', 'B', '_', 'G', 'L', '1', '_', 'I', 'N', 'T', 'E', 'R', 'F', 'A', 'C', 'E', '_', 'C', 'O', 'N', 'T', 'R', 'O', 'L', '\0', /* DB_GL1_INTERFACE_CONTROL (51754) */
	'D', 'B', '_', 'M', 'E', 'M', '_', 'T', 'E', 'M', 'P', 'O', 'R', 'A', 'L', '\0', /* DB_MEM_TEMPORAL (51779, 51786) */
	'D', 'B', '_', 'V', 'I', 'E', 'W', 'P', 'O', 'R', 'T', '_', 'C', 'O', 'N', 'T', 'R', 'O', 'L', '\0', /* DB_VIEWPORT_CONTROL (51795) */
	'D', 'B', '_', 'S', 'T', 'E', 'N', 'C', 'I', 'L', '_', 'R', 'E', 'F', '\0', /* DB_STENCIL_REF (51815) */
	'D', 'B', '_', 'S', 'T', 'E', 'N', 'C', 'I', 'L', '_', 'O', 'P', 'V', 'A', 'L', '\0', /* DB_STENCIL_OPVAL (51830, 51841) */
	'D', 'B', '_', 'S', 'T', 'E', 'N', 'C', 'I', 'L', '_', 'R', 'E', 'A', 'D', '_', 'M', 'A', 'S', 'K', '\0', /* DB_STENCIL_READ_MASK (51847) */
	'D', 'B', '_', 'S', 'T', 'E', 'N', 'C', 'I', 'L', '_', 'W', 'R', 'I', 'T', 'E', '_', 'M', 'A', 'S', 'K', '\0', /* DB_STENCIL_WRITE_MASK (51868) */
	'S', 'C', '_', 'M', 'E', 'M', '_', 'T', 'E', 'M', 'P', 'O', 'R', 'A', 'L', '\0', /* SC_MEM_TEMPORAL (51890) */
	'S', 'C', '_', 'M', 'E', 'M', '_', 'S', 'P', 'E', 'C', '_', 'R', 'E', 'A', 'D', '\0', /* SC_MEM_SPEC_READ (51906) */
	'P', 'A', '_', 'S', 'C', '_', 'V', 'P', 'O', 'R', 'T', '_', '0', '_', 'T', 'L', '\0', /* PA_SC_VPORT_0_TL (51923) */
	'P', 'A', '_', 'S', 'C', '_', 'V', 'P', 'O', 'R', 'T', '_', '0', '_', 'B', 'R', '\0', /* PA_SC_VPORT_0_BR (51940) */
	'P', 'A', '_', 'S', 'C', '_', 'V', 'P', 'O', 'R', 'T', '_', '1', '_', 'T', 'L', '\0', /* PA_SC_VPORT_1_TL (51957) */
	'P', 'A', '_', 'S', 'C', '_', 'V', 'P', 'O', 'R', 'T', '_', '1', '_', 'B', 'R', '\0', /* PA_SC_VPORT_1_BR (51974) */
	'P', 'A', '_', 'S', 'C', '_', 'V', 'P', 'O', 'R', 'T', '_', '2', '_', 'T', 'L', '\0', /* PA_SC_VPORT_2_TL (51991) */
	'P', 'A', '_', 'S', 'C', '_', 'V', 'P', 'O', 'R', 'T', '_', '2', '_', 'B', 'R', '\0', /* PA_SC_VPORT_2_BR (52008) */
	'P', 'A', '_', 'S', 'C', '_', 'V', 'P', 'O', 'R', 'T', '_', '3', '_', 'T', 'L', '\0', /* PA_SC_VPORT_3_TL (52025) */
	'P', 'A', '_', 'S', 'C', '_', 'V', 'P', 'O', 'R', 'T', '_', '3', '_', 'B', 'R', '\0', /* PA_SC_VPORT_3_BR (52042) */
	'P', 'A', '_', 'S', 'C', '_', 'V', 'P', 'O', 'R', 'T', '_', '4', '_', 'T', 'L', '\0', /* PA_SC_VPORT_4_TL (52059) */
	'P', 'A', '_', 'S', 'C', '_', 'V', 'P', 'O', 'R', 'T', '_', '4', '_', 'B', 'R', '\0', /* PA_SC_VPORT_4_BR (52076) */
	'P', 'A', '_', 'S', 'C', '_', 'V', 'P', 'O', 'R', 'T', '_', '5', '_', 'T', 'L', '\0', /* PA_SC_VPORT_5_TL (52093) */
	'P', 'A', '_', 'S', 'C', '_', 'V', 'P', 'O', 'R', 'T', '_', '5', '_', 'B', 'R', '\0', /* PA_SC_VPORT_5_BR (52110) */
	'P', 'A', '_', 'S', 'C', '_', 'V', 'P', 'O', 'R', 'T', '_', '6', '_', 'T', 'L', '\0', /* PA_SC_VPORT_6_TL (52127) */
	'P', 'A', '_', 'S', 'C', '_', 'V', 'P', 'O', 'R', 'T', '_', '6', '_', 'B', 'R', '\0', /* PA_SC_VPORT_6_BR (52144) */
	'P', 'A', '_', 'S', 'C', '_', 'V', 'P', 'O', 'R', 'T', '_', '7', '_', 'T', 'L', '\0', /* PA_SC_VPORT_7_TL (52161) */
	'P', 'A', '_', 'S', 'C', '_', 'V', 'P', 'O', 'R', 'T', '_', '7', '_', 'B', 'R', '\0', /* PA_SC_VPORT_7_BR (52178) */
	'P', 'A', '_', 'S', 'C', '_', 'V', 'P', 'O', 'R', 'T', '_', '8', '_', 'T', 'L', '\0', /* PA_SC_VPORT_8_TL (52195) */
	'P', 'A', '_', 'S', 'C', '_', 'V', 'P', 'O', 'R', 'T', '_', '8', '_', 'B', 'R', '\0', /* PA_SC_VPORT_8_BR (52212) */
	'P', 'A', '_', 'S', 'C', '_', 'V', 'P', 'O', 'R', 'T', '_', '9', '_', 'T', 'L', '\0', /* PA_SC_VPORT_9_TL (52229) */
	'P', 'A', '_', 'S', 'C', '_', 'V', 'P', 'O', 'R', 'T', '_', '9', '_', 'B', 'R', '\0', /* PA_SC_VPORT_9_BR (52246) */
	'P', 'A', '_', 'S', 'C', '_', 'V', 'P', 'O', 'R', 'T', '_', '1', '0', '_', 'T', 'L', '\0', /* PA_SC_VPORT_10_TL (52263) */
	'P', 'A', '_', 'S', 'C', '_', 'V', 'P', 'O', 'R', 'T', '_', '1', '0', '_', 'B', 'R', '\0', /* PA_SC_VPORT_10_BR (52281) */
	'P', 'A', '_', 'S', 'C', '_', 'V', 'P', 'O', 'R', 'T', '_', '1', '1', '_', 'T', 'L', '\0', /* PA_SC_VPORT_11_TL (52299) */
	'P', 'A', '_', 'S', 'C', '_', 'V', 'P', 'O', 'R', 'T', '_', '1', '1', '_', 'B', 'R', '\0', /* PA_SC_VPORT_11_BR (52317) */
	'P', 'A', '_', 'S', 'C', '_', 'V', 'P', 'O', 'R', 'T', '_', '1', '2', '_', 'T', 'L', '\0', /* PA_SC_VPORT_12_TL (52335) */
	'P', 'A', '_', 'S', 'C', '_', 'V', 'P', 'O', 'R', 'T', '_', '1', '2', '_', 'B', 'R', '\0', /* PA_SC_VPORT_12_BR (52353) */
	'P', 'A', '_', 'S', 'C', '_', 'V', 'P', 'O', 'R', 'T', '_', '1', '3', '_', 'T', 'L', '\0', /* PA_SC_VPORT_13_TL (52371) */
	'P', 'A', '_', 'S', 'C', '_', 'V', 'P', 'O', 'R', 'T', '_', '1', '3', '_', 'B', 'R', '\0', /* PA_SC_VPORT_13_BR (52389) */
	'P', 'A', '_', 'S', 'C', '_', 'V', 'P', 'O', 'R', 'T', '_', '1', '4', '_', 'T', 'L', '\0', /* PA_SC_VPORT_14_TL (52407) */
	'P', 'A', '_', 'S', 'C', '_', 'V', 'P', 'O', 'R', 'T', '_', '1', '4', '_', 'B', 'R', '\0', /* PA_SC_VPORT_14_BR (52425) */
	'P', 'A', '_', 'S', 'C', '_', 'V', 'P', 'O', 'R', 'T', '_', '1', '5', '_', 'T', 'L', '\0', /* PA_SC_VPORT_15_TL (52443) */
	'P', 'A', '_', 'S', 'C', '_', 'V', 'P', 'O', 'R', 'T', '_', '1', '5', '_', 'B', 'R', '\0', /* PA_SC_VPORT_15_BR (52461) */
	'C', 'P', '_', 'C', 'P', '_', 'P', 'I', 'P', 'E', 'I', 'D', '\0', /* CP_CP_PIPEID (52479) */
	'C', 'P', '_', 'C', 'P', '_', 'V', 'M', 'I', 'D', '\0', /* CP_CP_VMID (52492) */
	'P', 'A', '_', 'S', 'C', '_', 'C', 'L', 'I', 'P', 'R', 'E', 'C', 'T', '_', '0', '_', 'E', 'X', 'T', '\0', /* PA_SC_CLIPRECT_0_EXT (52503) */
	'P', 'A', '_', 'S', 'C', '_', 'C', 'L', 'I', 'P', 'R', 'E', 'C', 'T', '_', '1', '_', 'E', 'X', 'T', '\0', /* PA_SC_CLIPRECT_1_EXT (52524) */
	'P', 'A', '_', 'S', 'C', '_', 'C', 'L', 'I', 'P', 'R', 'E', 'C', 'T', '_', '2', '_', 'E', 'X', 'T', '\0', /* PA_SC_CLIPRECT_2_EXT (52545) */
	'P', 'A', '_', 'S', 'C', '_', 'C', 'L', 'I', 'P', 'R', 'E', 'C', 'T', '_', '3', '_', 'E', 'X', 'T', '\0', /* PA_SC_CLIPRECT_3_EXT (52566) */
	'P', 'A', '_', 'S', 'C', '_', 'V', 'R', 'S', '_', 'I', 'N', 'F', 'O', '\0', /* PA_SC_VRS_INFO (52587) */
	'P', 'A', '_', 'S', 'C', '_', 'L', 'I', 'N', 'E', '_', 'S', 'T', 'I', 'P', 'P', 'L', 'E', '_', 'R', 'E', 'S', 'E', 'T', '\0', /* PA_SC_LINE_STIPPLE_RESET (52602, 52608) */
	'G', 'E', '_', 'S', 'E', '_', 'E', 'N', 'H', 'A', 'N', 'C', 'E', '\0', /* GE_SE_ENHANCE (52627) */
	'G', 'E', '_', 'I', 'A', '_', 'E', 'N', 'H', 'A', 'N', 'C', 'E', '\0', /* GE_IA_ENHANCE (52641) */
	'G', 'E', '_', 'W', 'D', '_', 'E', 'N', 'H', 'A', 'N', 'C', 'E', '\0', /* GE_WD_ENHANCE (52655) */
	'P', 'A', '_', 'S', 'C', '_', 'H', 'I', 'Z', '_', 'I', 'N', 'F', 'O', '\0', /* PA_SC_HIZ_INFO (52669) */
	'P', 'A', '_', 'S', 'C', '_', 'H', 'I', 'S', '_', 'I', 'N', 'F', 'O', '\0', /* PA_SC_HIS_INFO (52684) */
	'P', 'A', '_', 'S', 'C', '_', 'H', 'I', 'Z', '_', 'B', 'A', 'S', 'E', '\0', /* PA_SC_HIZ_BASE (52699) */
	'P', 'A', '_', 'S', 'C', '_', 'H', 'I', 'Z', '_', 'B', 'A', 'S', 'E', '_', 'E', 'X', 'T', '\0', /* PA_SC_HIZ_BASE_EXT (52714) */
	'P', 'A', '_', 'S', 'C', '_', 'H', 'I', 'Z', '_', 'S', 'I', 'Z', 'E', '_', 'X', 'Y', '\0', /* PA_SC_HIZ_SIZE_XY (52733) */
	'P', 'A', '_', 'S', 'C', '_', 'H', 'I', 'S', '_', 'B', 'A', 'S', 'E', '\0', /* PA_SC_HIS_BASE (52751) */
	'P', 'A', '_', 'S', 'C', '_', 'H', 'I', 'S', '_', 'B', 'A', 'S', 'E', '_', 'E', 'X', 'T', '\0', /* PA_SC_HIS_BASE_EXT (52766) */
	'P', 'A', '_', 'S', 'C', '_', 'H', 'I', 'S', '_', 'S', 'I', 'Z', 'E', '_', 'X', 'Y', '\0', /* PA_SC_HIS_SIZE_XY (52785) */
	'P', 'A', '_', 'S', 'C', '_', 'B', 'I', 'N', 'N', 'E', 'R', '_', 'D', 'Y', 'N', 'A', 'M', 'I', 'C', '_', 'B', 'A', 'T', 'C', 'H', '_', 'L', 'I', 'M', 'I', 'T', '\0', /* PA_SC_BINNER_DYNAMIC_BATCH_LIMIT (52803, 52830) */
	'P', 'A', '_', 'S', 'C', '_', 'H', 'I', 'S', 'Z', '_', 'C', 'O', 'N', 'T', 'R', 'O', 'L', '\0', /* PA_SC_HISZ_CONTROL (52836) */
	'P', 'A', '_', 'S', 'C', '_', 'H', 'I', 'S', 'Z', '_', 'R', 'E', 'N', 'D', 'E', 'R', '_', 'O', 'V', 'E', 'R', 'R', 'I', 'D', 'E', '\0', /* PA_SC_HISZ_RENDER_OVERRIDE (52855) */
	'P', 'A', '_', 'S', 'C', '_', 'B', 'I', 'N', 'N', 'E', 'R', '_', 'O', 'U', 'T', 'P', 'U', 'T', '_', 'T', 'I', 'M', 'E', 'O', 'U', 'T', '_', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '\0', /* PA_SC_BINNER_OUTPUT_TIMEOUT_COUNTER (52882) */
	'P', 'A', '_', 'S', 'C', '_', 'S', 'A', 'M', 'P', 'L', 'E', '_', 'P', 'R', 'O', 'P', 'E', 'R', 'T', 'I', 'E', 'S', '\0', /* PA_SC_SAMPLE_PROPERTIES (52918) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '0', '_', 'V', 'I', 'E', 'W', '2', '\0', /* CB_COLOR0_VIEW2 (52942) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '1', '_', 'V', 'I', 'E', 'W', '2', '\0', /* CB_COLOR1_VIEW2 (52958) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '2', '_', 'V', 'I', 'E', 'W', '2', '\0', /* CB_COLOR2_VIEW2 (52974) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '3', '_', 'V', 'I', 'E', 'W', '2', '\0', /* CB_COLOR3_VIEW2 (52990) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '4', '_', 'V', 'I', 'E', 'W', '2', '\0', /* CB_COLOR4_VIEW2 (53006) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '5', '_', 'V', 'I', 'E', 'W', '2', '\0', /* CB_COLOR5_VIEW2 (53022) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '6', '_', 'V', 'I', 'E', 'W', '2', '\0', /* CB_COLOR6_VIEW2 (53038) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '7', '_', 'V', 'I', 'E', 'W', '2', '\0', /* CB_COLOR7_VIEW2 (53054) */
	'C', 'B', '_', 'M', 'E', 'M', '0', '_', 'I', 'N', 'F', 'O', '\0', /* CB_MEM0_INFO (53070) */
	'C', 'B', '_', 'M', 'E', 'M', '1', '_', 'I', 'N', 'F', 'O', '\0', /* CB_MEM1_INFO (53083) */
	'C', 'B', '_', 'M', 'E', 'M', '2', '_', 'I', 'N', 'F', 'O', '\0', /* CB_MEM2_INFO (53096) */
	'C', 'B', '_', 'M', 'E', 'M', '3', '_', 'I', 'N', 'F', 'O', '\0', /* CB_MEM3_INFO (53109) */
	'C', 'B', '_', 'M', 'E', 'M', '4', '_', 'I', 'N', 'F', 'O', '\0', /* CB_MEM4_INFO (53122) */
	'C', 'B', '_', 'M', 'E', 'M', '5', '_', 'I', 'N', 'F', 'O', '\0', /* CB_MEM5_INFO (53135) */
	'C', 'B', '_', 'M', 'E', 'M', '6', '_', 'I', 'N', 'F', 'O', '\0', /* CB_MEM6_INFO (53148) */
	'C', 'B', '_', 'M', 'E', 'M', '7', '_', 'I', 'N', 'F', 'O', '\0', /* CB_MEM7_INFO (53161) */
	'G', 'R', 'B', 'M', '_', 'N', 'O', 'W', 'H', 'E', 'R', 'E', '_', '2', '\0', /* GRBM_NOWHERE_2 (53174) */
	'G', 'E', '_', 'G', 'S', '_', 'T', 'H', 'R', 'O', 'T', 'T', 'L', 'E', '\0', /* GE_GS_THROTTLE (53189) */
	'G', 'E', '_', 'P', 'O', 'S', '_', 'R', 'I', 'N', 'G', '_', 'B', 'A', 'S', 'E', '\0', /* GE_POS_RING_BASE (53204) */
	'G', 'E', '_', 'P', 'O', 'S', '_', 'R', 'I', 'N', 'G', '_', 'S', 'I', 'Z', 'E', '\0', /* GE_POS_RING_SIZE (53221) */
	'G', 'E', '_', 'P', 'R', 'I', 'M', '_', 'R', 'I', 'N', 'G', '_', 'B', 'A', 'S', 'E', '\0', /* GE_PRIM_RING_BASE (53238) */
	'G', 'E', '_', 'P', 'R', 'I', 'M', '_', 'R', 'I', 'N', 'G', '_', 'S', 'I', 'Z', 'E', '\0', /* GE_PRIM_RING_SIZE (53256) */
	'G', 'E', '_', 'G', 'S', '_', 'O', 'R', 'D', 'E', 'R', 'E', 'D', '_', 'I', 'D', '_', 'B', 'A', 'S', 'E', '\0', /* GE_GS_ORDERED_ID_BASE (53274) */
	'S', 'P', 'I', '_', 'S', 'Q', 'G', '_', 'E', 'V', 'E', 'N', 'T', '_', 'C', 'T', 'L', '\0', /* SPI_SQG_EVENT_CTL (53296) */
	'S', 'P', 'I', '_', 'G', 'R', 'P', '_', 'L', 'A', 'U', 'N', 'C', 'H', '_', 'G', 'U', 'A', 'R', 'A', 'N', 'T', 'E', 'E', '_', 'E', 'N', 'A', 'B', 'L', 'E', '\0', /* SPI_GRP_LAUNCH_GUARANTEE_ENABLE (53314) */
	'S', 'P', 'I', '_', 'G', 'R', 'P', '_', 'L', 'A', 'U', 'N', 'C', 'H', '_', 'G', 'U', 'A', 'R', 'A', 'N', 'T', 'E', 'E', '_', 'C', 'T', 'R', 'L', '\0', /* SPI_GRP_LAUNCH_GUARANTEE_CTRL (53346) */
	'G', 'R', 'B', 'M', 'H', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'L', 'O', '\0', /* GRBMH_PERFCOUNTER0_LO (53376) */
	'G', 'R', 'B', 'M', 'H', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'H', 'I', '\0', /* GRBMH_PERFCOUNTER0_HI (53398) */
	'G', 'R', 'B', 'M', 'H', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'L', 'O', '\0', /* GRBMH_PERFCOUNTER1_LO (53420) */
	'G', 'R', 'B', 'M', 'H', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'H', 'I', '\0', /* GRBMH_PERFCOUNTER1_HI (53442) */
	'G', 'C', '_', 'E', 'A', '_', 'C', 'P', 'W', 'D', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'L', 'O', '\0', /* GC_EA_CPWD_PERFCOUNTER0_LO (53464, 53472) */
	'G', 'C', '_', 'E', 'A', '_', 'C', 'P', 'W', 'D', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'H', 'I', '\0', /* GC_EA_CPWD_PERFCOUNTER0_HI (53491, 53499) */
	'G', 'C', '_', 'E', 'A', '_', 'C', 'P', 'W', 'D', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'L', 'O', '\0', /* GC_EA_CPWD_PERFCOUNTER1_LO (53518, 53526) */
	'G', 'C', '_', 'E', 'A', '_', 'C', 'P', 'W', 'D', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'H', 'I', '\0', /* GC_EA_CPWD_PERFCOUNTER1_HI (53545, 53553) */
	'G', 'C', '_', 'E', 'A', '_', 'S', 'E', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'L', 'O', '\0', /* GC_EA_SE_PERFCOUNTER0_LO (53572) */
	'G', 'C', '_', 'E', 'A', '_', 'S', 'E', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'H', 'I', '\0', /* GC_EA_SE_PERFCOUNTER0_HI (53597) */
	'G', 'C', '_', 'E', 'A', '_', 'S', 'E', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'L', 'O', '\0', /* GC_EA_SE_PERFCOUNTER1_LO (53622) */
	'G', 'C', '_', 'E', 'A', '_', 'S', 'E', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'H', 'I', '\0', /* GC_EA_SE_PERFCOUNTER1_HI (53647) */
	'G', 'L', '1', 'X', 'C', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'L', 'O', '\0', /* GL1XC_PERFCOUNTER0_LO (53672) */
	'G', 'L', '1', 'X', 'C', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'H', 'I', '\0', /* GL1XC_PERFCOUNTER0_HI (53694) */
	'G', 'L', '1', 'X', 'C', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'L', 'O', '\0', /* GL1XC_PERFCOUNTER1_LO (53716) */
	'G', 'L', '1', 'X', 'C', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'H', 'I', '\0', /* GL1XC_PERFCOUNTER1_HI (53738) */
	'G', 'L', '1', 'X', 'C', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', 'L', 'O', '\0', /* GL1XC_PERFCOUNTER2_LO (53760) */
	'G', 'L', '1', 'X', 'C', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', 'H', 'I', '\0', /* GL1XC_PERFCOUNTER2_HI (53782) */
	'G', 'L', '1', 'X', 'C', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '3', '_', 'L', 'O', '\0', /* GL1XC_PERFCOUNTER3_LO (53804) */
	'G', 'L', '1', 'X', 'C', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '3', '_', 'H', 'I', '\0', /* GL1XC_PERFCOUNTER3_HI (53826) */
	'G', 'L', '1', 'X', 'A', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'L', 'O', '\0', /* GL1XA_PERFCOUNTER0_LO (53848) */
	'G', 'L', '1', 'X', 'A', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'H', 'I', '\0', /* GL1XA_PERFCOUNTER0_HI (53870) */
	'G', 'L', '1', 'X', 'A', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'L', 'O', '\0', /* GL1XA_PERFCOUNTER1_LO (53892) */
	'G', 'L', '1', 'X', 'A', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'H', 'I', '\0', /* GL1XA_PERFCOUNTER1_HI (53914) */
	'G', 'L', '1', 'X', 'A', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', 'L', 'O', '\0', /* GL1XA_PERFCOUNTER2_LO (53936) */
	'G', 'L', '1', 'X', 'A', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', 'H', 'I', '\0', /* GL1XA_PERFCOUNTER2_HI (53958) */
	'G', 'L', '1', 'X', 'A', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '3', '_', 'L', 'O', '\0', /* GL1XA_PERFCOUNTER3_LO (53980) */
	'G', 'L', '1', 'X', 'A', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '3', '_', 'H', 'I', '\0', /* GL1XA_PERFCOUNTER3_HI (54002) */
	'C', 'P', '_', 'C', 'P', '_', 'P', 'E', 'R', 'F', 'M', 'O', 'N', '_', 'C', 'N', 'T', 'L', '\0', /* CP_CP_PERFMON_CNTL (54024) */
	'G', 'R', 'B', 'M', 'H', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* GRBMH_PERFCOUNTER0_SELECT (54043) */
	'G', 'R', 'B', 'M', 'H', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* GRBMH_PERFCOUNTER1_SELECT (54069) */
	'S', 'P', 'I', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '4', '_', 'S', 'E', 'L', 'E', 'C', 'T', '1', '\0', /* SPI_PERFCOUNTER4_SELECT1 (54095) */
	'S', 'P', 'I', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '5', '_', 'S', 'E', 'L', 'E', 'C', 'T', '1', '\0', /* SPI_PERFCOUNTER5_SELECT1 (54120) */
	'S', 'Q', '_', 'T', 'H', 'R', 'E', 'A', 'D', '_', 'T', 'R', 'A', 'C', 'E', '_', 'B', 'U', 'F', '0', '_', 'B', 'A', 'S', 'E', '_', 'L', 'O', '\0', /* SQ_THREAD_TRACE_BUF0_BASE_LO (54145) */
	'S', 'Q', '_', 'T', 'H', 'R', 'E', 'A', 'D', '_', 'T', 'R', 'A', 'C', 'E', '_', 'B', 'U', 'F', '0', '_', 'B', 'A', 'S', 'E', '_', 'H', 'I', '\0', /* SQ_THREAD_TRACE_BUF0_BASE_HI (54174) */
	'S', 'Q', '_', 'T', 'H', 'R', 'E', 'A', 'D', '_', 'T', 'R', 'A', 'C', 'E', '_', 'B', 'U', 'F', '1', '_', 'B', 'A', 'S', 'E', '_', 'L', 'O', '\0', /* SQ_THREAD_TRACE_BUF1_BASE_LO (54203) */
	'S', 'Q', '_', 'T', 'H', 'R', 'E', 'A', 'D', '_', 'T', 'R', 'A', 'C', 'E', '_', 'B', 'U', 'F', '1', '_', 'B', 'A', 'S', 'E', '_', 'H', 'I', '\0', /* SQ_THREAD_TRACE_BUF1_BASE_HI (54232) */
	'S', 'Q', '_', 'T', 'H', 'R', 'E', 'A', 'D', '_', 'T', 'R', 'A', 'C', 'E', '_', 'H', 'A', 'L', 'T', '\0', /* SQ_THREAD_TRACE_HALT (54261, 54274, 54277) */
	'S', 'Q', '_', 'T', 'H', 'R', 'E', 'A', 'D', '_', 'T', 'R', 'A', 'C', 'E', '_', 'P', 'O', 'W', 'E', 'R', 'O', 'F', 'F', '_', 'R', 'E', 'S', 'T', 'O', 'R', 'E', '_', '1', '\0', /* SQ_THREAD_TRACE_POWEROFF_RESTORE_1 (54282) */
	'S', 'Q', '_', 'T', 'H', 'R', 'E', 'A', 'D', '_', 'T', 'R', 'A', 'C', 'E', '_', 'F', 'I', 'N', 'I', 'S', 'H', '_', 'D', 'O', 'N', 'E', '_', 'D', 'E', 'B', 'U', 'G', '\0', /* SQ_THREAD_TRACE_FINISH_DONE_DEBUG (54317) */
	'G', 'C', '_', 'E', 'A', '_', 'C', 'P', 'W', 'D', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* GC_EA_CPWD_PERFCOUNTER0_SELECT (54351, 54359) */
	'G', 'C', '_', 'E', 'A', '_', 'C', 'P', 'W', 'D', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'S', 'E', 'L', 'E', 'C', 'T', '1', '\0', /* GC_EA_CPWD_PERFCOUNTER0_SELECT1 (54382) */
	'G', 'C', '_', 'E', 'A', '_', 'C', 'P', 'W', 'D', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* GC_EA_CPWD_PERFCOUNTER1_SELECT (54414, 54422) */
	'G', 'C', '_', 'E', 'A', '_', 'S', 'E', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* GC_EA_SE_PERFCOUNTER0_SELECT (54445) */
	'G', 'C', '_', 'E', 'A', '_', 'S', 'E', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'S', 'E', 'L', 'E', 'C', 'T', '1', '\0', /* GC_EA_SE_PERFCOUNTER0_SELECT1 (54474) */
	'G', 'C', '_', 'E', 'A', '_', 'S', 'E', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* GC_EA_SE_PERFCOUNTER1_SELECT (54504) */
	'S', 'X', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', 'S', 'E', 'L', 'E', 'C', 'T', '1', '\0', /* SX_PERFCOUNTER2_SELECT1 (54533) */
	'S', 'X', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '3', '_', 'S', 'E', 'L', 'E', 'C', 'T', '1', '\0', /* SX_PERFCOUNTER3_SELECT1 (54557) */
	'G', 'L', '2', 'C', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', 'S', 'E', 'L', 'E', 'C', 'T', '1', '\0', /* GL2C_PERFCOUNTER2_SELECT1 (54581) */
	'G', 'L', '2', 'C', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '3', '_', 'S', 'E', 'L', 'E', 'C', 'T', '1', '\0', /* GL2C_PERFCOUNTER3_SELECT1 (54607) */
	'G', 'L', '2', 'A', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', 'S', 'E', 'L', 'E', 'C', 'T', '1', '\0', /* GL2A_PERFCOUNTER2_SELECT1 (54633) */
	'G', 'L', '2', 'A', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '3', '_', 'S', 'E', 'L', 'E', 'C', 'T', '1', '\0', /* GL2A_PERFCOUNTER3_SELECT1 (54659) */
	'G', 'L', '1', 'C', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'S', 'E', 'L', 'E', 'C', 'T', '1', '\0', /* GL1C_PERFCOUNTER1_SELECT1 (54685) */
	'G', 'L', '1', 'C', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', 'S', 'E', 'L', 'E', 'C', 'T', '1', '\0', /* GL1C_PERFCOUNTER2_SELECT1 (54711) */
	'G', 'L', '1', 'C', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '3', '_', 'S', 'E', 'L', 'E', 'C', 'T', '1', '\0', /* GL1C_PERFCOUNTER3_SELECT1 (54737) */
	'G', 'L', '1', 'X', 'C', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* GL1XC_PERFCOUNTER0_SELECT (54763) */
	'G', 'L', '1', 'X', 'C', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'S', 'E', 'L', 'E', 'C', 'T', '1', '\0', /* GL1XC_PERFCOUNTER0_SELECT1 (54789) */
	'G', 'L', '1', 'X', 'C', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* GL1XC_PERFCOUNTER1_SELECT (54816) */
	'G', 'L', '1', 'X', 'C', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'S', 'E', 'L', 'E', 'C', 'T', '1', '\0', /* GL1XC_PERFCOUNTER1_SELECT1 (54842) */
	'G', 'L', '1', 'X', 'C', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* GL1XC_PERFCOUNTER2_SELECT (54869) */
	'G', 'L', '1', 'X', 'C', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', 'S', 'E', 'L', 'E', 'C', 'T', '1', '\0', /* GL1XC_PERFCOUNTER2_SELECT1 (54895) */
	'G', 'L', '1', 'X', 'C', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '3', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* GL1XC_PERFCOUNTER3_SELECT (54922) */
	'G', 'L', '1', 'X', 'C', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '3', '_', 'S', 'E', 'L', 'E', 'C', 'T', '1', '\0', /* GL1XC_PERFCOUNTER3_SELECT1 (54948) */
	'C', 'H', 'C', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'S', 'E', 'L', 'E', 'C', 'T', '1', '\0', /* CHC_PERFCOUNTER1_SELECT1 (54975) */
	'C', 'H', 'C', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', 'S', 'E', 'L', 'E', 'C', 'T', '1', '\0', /* CHC_PERFCOUNTER2_SELECT1 (55000) */
	'C', 'H', 'C', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '3', '_', 'S', 'E', 'L', 'E', 'C', 'T', '1', '\0', /* CHC_PERFCOUNTER3_SELECT1 (55025) */
	'D', 'B', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', 'S', 'E', 'L', 'E', 'C', 'T', '1', '\0', /* DB_PERFCOUNTER2_SELECT1 (55050) */
	'D', 'B', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '3', '_', 'S', 'E', 'L', 'E', 'C', 'T', '1', '\0', /* DB_PERFCOUNTER3_SELECT1 (55074) */
	'R', 'L', 'C', '_', 'S', 'P', 'M', '_', 'G', 'T', 'S', '_', 'T', 'R', 'I', 'G', 'G', 'E', 'R', '_', 'V', 'A', 'L', 'U', 'E', '_', 'L', 'O', '\0', /* RLC_SPM_GTS_TRIGGER_VALUE_LO (55098) */
	'R', 'L', 'C', '_', 'S', 'P', 'M', '_', 'G', 'T', 'S', '_', 'T', 'R', 'I', 'G', 'G', 'E', 'R', '_', 'V', 'A', 'L', 'U', 'E', '_', 'H', 'I', '\0', /* RLC_SPM_GTS_TRIGGER_VALUE_HI (55127, 55147) */
	'R', 'L', 'C', '_', 'S', 'P', 'M', '_', 'R', 'S', 'P', 'M', '_', 'R', 'E', 'Q', '_', 'D', 'A', 'T', 'A', '\0', /* RLC_SPM_RSPM_REQ_DATA (55156) */
	'R', 'L', 'C', '_', 'S', 'P', 'M', '_', 'S', 'E', '_', 'R', 'S', 'P', 'M', '_', 'R', 'E', 'Q', '_', 'D', 'A', 'T', 'A', '\0', /* RLC_SPM_SE_RSPM_REQ_DATA (55178) */
	'G', 'C', 'R', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'S', 'E', 'L', 'E', 'C', 'T', '1', '\0', /* GCR_PERFCOUNTER1_SELECT1 (55203) */
	'G', 'L', '1', 'A', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'S', 'E', 'L', 'E', 'C', 'T', '1', '\0', /* GL1A_PERFCOUNTER1_SELECT1 (55228) */
	'G', 'L', '1', 'A', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', 'S', 'E', 'L', 'E', 'C', 'T', '1', '\0', /* GL1A_PERFCOUNTER2_SELECT1 (55254) */
	'G', 'L', '1', 'A', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '3', '_', 'S', 'E', 'L', 'E', 'C', 'T', '1', '\0', /* GL1A_PERFCOUNTER3_SELECT1 (55280) */
	'G', 'L', '1', 'X', 'A', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* GL1XA_PERFCOUNTER0_SELECT (55306) */
	'G', 'L', '1', 'X', 'A', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'S', 'E', 'L', 'E', 'C', 'T', '1', '\0', /* GL1XA_PERFCOUNTER0_SELECT1 (55332) */
	'G', 'L', '1', 'X', 'A', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* GL1XA_PERFCOUNTER1_SELECT (55359) */
	'G', 'L', '1', 'X', 'A', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'S', 'E', 'L', 'E', 'C', 'T', '1', '\0', /* GL1XA_PERFCOUNTER1_SELECT1 (55385) */
	'G', 'L', '1', 'X', 'A', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* GL1XA_PERFCOUNTER2_SELECT (55412) */
	'G', 'L', '1', 'X', 'A', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', 'S', 'E', 'L', 'E', 'C', 'T', '1', '\0', /* GL1XA_PERFCOUNTER2_SELECT1 (55438) */
	'G', 'L', '1', 'X', 'A', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '3', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* GL1XA_PERFCOUNTER3_SELECT (55465) */
	'G', 'L', '1', 'X', 'A', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '3', '_', 'S', 'E', 'L', 'E', 'C', 'T', '1', '\0', /* GL1XA_PERFCOUNTER3_SELECT1 (55491) */
	'C', 'H', 'A', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'S', 'E', 'L', 'E', 'C', 'T', '1', '\0', /* CHA_PERFCOUNTER1_SELECT1 (55518) */
	'C', 'H', 'A', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', 'S', 'E', 'L', 'E', 'C', 'T', '1', '\0', /* CHA_PERFCOUNTER2_SELECT1 (55543) */
	'C', 'H', 'A', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '3', '_', 'S', 'E', 'L', 'E', 'C', 'T', '1', '\0', /* CHA_PERFCOUNTER3_SELECT1 (55568) */
	'S', 'Q', '_', 'W', 'A', 'V', 'E', '_', 'H', 'W', '_', 'I', 'D', '\0', /* SQ_WAVE_HW_ID (55593) */
	'S', 'Q', '_', 'W', 'A', 'V', 'E', '_', 'I', 'N', 'S', 'T', '_', 'D', 'W', '1', '\0', /* SQ_WAVE_INST_DW1 (55607) */
	'S', 'Q', '_', 'W', 'A', 'V', 'E', '_', 'I', 'B', '_', 'D', 'B', 'G', '0', '\0', /* SQ_WAVE_IB_DBG0 (55624) */
	'S', 'Q', '_', 'W', 'A', 'V', 'E', '_', 'T', 'B', 'A', '_', 'L', 'O', '\0', /* SQ_WAVE_TBA_LO (55640) */
	'S', 'Q', '_', 'W', 'A', 'V', 'E', '_', 'T', 'B', 'A', '_', 'H', 'I', '\0', /* SQ_WAVE_TBA_HI (55655) */
	'S', 'Q', '_', 'W', 'A', 'V', 'E', '_', 'T', 'M', 'A', '_', 'L', 'O', '\0', /* SQ_WAVE_TMA_LO (55670) */
	'S', 'Q', '_', 'W', 'A', 'V', 'E', '_', 'T', 'M', 'A', '_', 'H', 'I', '\0', /* SQ_WAVE_TMA_HI (55685) */
	'S', 'R', 'B', 'M', '_', 'S', 'T', 'A', 'T', 'U', 'S', '2', '\0', /* SRBM_STATUS2 (55700) */
	'S', 'R', 'B', 'M', '_', 'S', 'T', 'A', 'T', 'U', 'S', '\0', /* SRBM_STATUS (55713) */
	'S', 'R', 'B', 'M', '_', 'S', 'T', 'A', 'T', 'U', 'S', '3', '\0', /* SRBM_STATUS3 (55725) */
	'G', 'R', 'B', 'M', '_', 'C', 'N', 'T', 'L', '\0', /* GRBM_CNTL (55738) */
	'G', 'R', 'B', 'M', '_', 'S', 'K', 'E', 'W', '_', 'C', 'N', 'T', 'L', '\0', /* GRBM_SKEW_CNTL (55748) */
	'G', 'R', 'B', 'M', '_', 'P', 'W', 'R', '_', 'C', 'N', 'T', 'L', '\0', /* GRBM_PWR_CNTL (55763) */
	'G', 'R', 'B', 'M', '_', 'S', 'O', 'F', 'T', '_', 'R', 'E', 'S', 'E', 'T', '\0', /* GRBM_SOFT_RESET (55777) */
	'G', 'R', 'B', 'M', '_', 'D', 'E', 'B', 'U', 'G', '_', 'C', 'N', 'T', 'L', '\0', /* GRBM_DEBUG_CNTL (55793) */
	'G', 'R', 'B', 'M', '_', 'D', 'E', 'B', 'U', 'G', '_', 'D', 'A', 'T', 'A', '\0', /* GRBM_DEBUG_DATA (55809) */
	'G', 'R', 'B', 'M', '_', 'G', 'F', 'X', '_', 'C', 'L', 'K', 'E', 'N', '_', 'C', 'N', 'T', 'L', '\0', /* GRBM_GFX_CLKEN_CNTL (55825) */
	'G', 'R', 'B', 'M', '_', 'W', 'A', 'I', 'T', '_', 'I', 'D', 'L', 'E', '_', 'C', 'L', 'O', 'C', 'K', 'S', '\0', /* GRBM_WAIT_IDLE_CLOCKS (55845, 55850) */
	'G', 'R', 'B', 'M', '_', 'D', 'E', 'B', 'U', 'G', '\0', /* GRBM_DEBUG (55867) */
	'G', 'R', 'B', 'M', '_', 'D', 'E', 'B', 'U', 'G', '_', 'S', 'N', 'A', 'P', 'S', 'H', 'O', 'T', '\0', /* GRBM_DEBUG_SNAPSHOT (55878) */
	'G', 'R', 'B', 'M', '_', 'R', 'E', 'A', 'D', '_', 'E', 'R', 'R', 'O', 'R', '\0', /* GRBM_READ_ERROR (55898, 55903) */
	'G', 'R', 'B', 'M', '_', 'I', 'N', 'T', '_', 'C', 'N', 'T', 'L', '\0', /* GRBM_INT_CNTL (55914) */
	'D', 'E', 'B', 'U', 'G', '_', 'I', 'N', 'D', 'E', 'X', '\0', /* DEBUG_INDEX (55928) */
	'G', 'R', 'B', 'M', '_', 'N', 'O', 'W', 'H', 'E', 'R', 'E', '\0', /* GRBM_NOWHERE (55940) */
	'G', 'R', 'B', 'M', '_', 'S', 'C', 'R', 'A', 'T', 'C', 'H', '_', 'R', 'E', 'G', '0', '\0', /* GRBM_SCRATCH_REG0 (55953) */
	'G', 'R', 'B', 'M', '_', 'S', 'C', 'R', 'A', 'T', 'C', 'H', '_', 'R', 'E', 'G', '1', '\0', /* GRBM_SCRATCH_REG1 (55971) */
	'G', 'R', 'B', 'M', '_', 'S', 'C', 'R', 'A', 'T', 'C', 'H', '_', 'R', 'E', 'G', '2', '\0', /* GRBM_SCRATCH_REG2 (55989) */
	'G', 'R', 'B', 'M', '_', 'S', 'C', 'R', 'A', 'T', 'C', 'H', '_', 'R', 'E', 'G', '3', '\0', /* GRBM_SCRATCH_REG3 (56007) */
	'G', 'R', 'B', 'M', '_', 'S', 'C', 'R', 'A', 'T', 'C', 'H', '_', 'R', 'E', 'G', '4', '\0', /* GRBM_SCRATCH_REG4 (56025) */
	'G', 'R', 'B', 'M', '_', 'S', 'C', 'R', 'A', 'T', 'C', 'H', '_', 'R', 'E', 'G', '5', '\0', /* GRBM_SCRATCH_REG5 (56043) */
	'G', 'R', 'B', 'M', '_', 'S', 'C', 'R', 'A', 'T', 'C', 'H', '_', 'R', 'E', 'G', '6', '\0', /* GRBM_SCRATCH_REG6 (56061) */
	'G', 'R', 'B', 'M', '_', 'S', 'C', 'R', 'A', 'T', 'C', 'H', '_', 'R', 'E', 'G', '7', '\0', /* GRBM_SCRATCH_REG7 (56079) */
	'S', 'Q', '_', 'I', 'N', 'T', 'E', 'R', 'R', 'U', 'P', 'T', '_', 'W', 'O', 'R', 'D', '_', 'A', 'U', 'T', 'O', '\0', /* SQ_INTERRUPT_WORD_AUTO (56097) */
	'C', 'P', '_', 'S', 'T', 'A', 'L', 'L', 'E', 'D', '_', 'S', 'T', 'A', 'T', '3', '\0', /* CP_STALLED_STAT3 (56120) */
	'C', 'P', '_', 'S', 'T', 'A', 'L', 'L', 'E', 'D', '_', 'S', 'T', 'A', 'T', '1', '\0', /* CP_STALLED_STAT1 (56137) */
	'C', 'P', '_', 'S', 'T', 'A', 'L', 'L', 'E', 'D', '_', 'S', 'T', 'A', 'T', '2', '\0', /* CP_STALLED_STAT2 (56154) */
	'C', 'P', '_', 'B', 'U', 'S', 'Y', '_', 'S', 'T', 'A', 'T', '\0', /* CP_BUSY_STAT (56171) */
	'C', 'P', '_', 'S', 'T', 'A', 'T', '\0', /* CP_STAT (56184) */
	'C', 'P', '_', 'M', 'E', '_', 'H', 'E', 'A', 'D', 'E', 'R', '_', 'D', 'U', 'M', 'P', '\0', /* CP_ME_HEADER_DUMP (56192) */
	'C', 'P', '_', 'P', 'F', 'P', '_', 'H', 'E', 'A', 'D', 'E', 'R', '_', 'D', 'U', 'M', 'P', '\0', /* CP_PFP_HEADER_DUMP (56210) */
	'C', 'P', '_', 'G', 'R', 'B', 'M', '_', 'F', 'R', 'E', 'E', '_', 'C', 'O', 'U', 'N', 'T', '\0', /* CP_GRBM_FREE_COUNT (56229) */
	'C', 'P', '_', 'C', 'E', '_', 'H', 'E', 'A', 'D', 'E', 'R', '_', 'D', 'U', 'M', 'P', '\0', /* CP_CE_HEADER_DUMP (56248) */
	'C', 'P', '_', 'M', 'C', '_', 'P', 'A', 'C', 'K', '_', 'D', 'E', 'L', 'A', 'Y', '_', 'C', 'N', 'T', '\0', /* CP_MC_PACK_DELAY_CNT (56266, 56272) */
	'C', 'P', '_', 'C', 'S', 'F', '_', 'S', 'T', 'A', 'T', '\0', /* CP_CSF_STAT (56287) */
	'C', 'P', '_', 'C', 'S', 'F', '_', 'C', 'N', 'T', 'L', '\0', /* CP_CSF_CNTL (56299) */
	'C', 'P', '_', 'M', 'E', '_', 'C', 'N', 'T', 'L', '\0', /* CP_ME_CNTL (56311) */
	'C', 'P', '_', 'C', 'N', 'T', 'X', '_', 'S', 'T', 'A', 'T', '\0', /* CP_CNTX_STAT (56322) */
	'C', 'P', '_', 'M', 'E', '_', 'P', 'R', 'E', 'E', 'M', 'P', 'T', 'I', 'O', 'N', '\0', /* CP_ME_PREEMPTION (56335) */
	'C', 'P', '_', 'R', 'B', '2', '_', 'R', 'P', 'T', 'R', '\0', /* CP_RB2_RPTR (56352) */
	'C', 'P', '_', 'R', 'B', '1', '_', 'R', 'P', 'T', 'R', '\0', /* CP_RB1_RPTR (56364) */
	'C', 'P', '_', 'R', 'B', '0', '_', 'R', 'P', 'T', 'R', '\0', /* CP_RB0_RPTR (56376) */
	'C', 'P', '_', 'R', 'B', '_', 'W', 'P', 'T', 'R', '_', 'D', 'E', 'L', 'A', 'Y', '\0', /* CP_RB_WPTR_DELAY (56388) */
	'C', 'P', '_', 'R', 'B', '_', 'W', 'P', 'T', 'R', '_', 'P', 'O', 'L', 'L', '_', 'C', 'N', 'T', 'L', '\0', /* CP_RB_WPTR_POLL_CNTL (56405) */
	'C', 'P', '_', 'R', 'O', 'Q', '1', '_', 'T', 'H', 'R', 'E', 'S', 'H', 'O', 'L', 'D', 'S', '\0', /* CP_ROQ1_THRESHOLDS (56426) */
	'C', 'P', '_', 'R', 'O', 'Q', '2', '_', 'T', 'H', 'R', 'E', 'S', 'H', 'O', 'L', 'D', 'S', '\0', /* CP_ROQ2_THRESHOLDS (56445) */
	'C', 'P', '_', 'S', 'T', 'Q', '_', 'T', 'H', 'R', 'E', 'S', 'H', 'O', 'L', 'D', 'S', '\0', /* CP_STQ_THRESHOLDS (56464) */
	'C', 'P', '_', 'Q', 'U', 'E', 'U', 'E', '_', 'T', 'H', 'R', 'E', 'S', 'H', 'O', 'L', 'D', 'S', '\0', /* CP_QUEUE_THRESHOLDS (56482) */
	'C', 'P', '_', 'M', 'E', 'Q', '_', 'T', 'H', 'R', 'E', 'S', 'H', 'O', 'L', 'D', 'S', '\0', /* CP_MEQ_THRESHOLDS (56502) */
	'C', 'P', '_', 'R', 'O', 'Q', '_', 'A', 'V', 'A', 'I', 'L', '\0', /* CP_ROQ_AVAIL (56520) */
	'C', 'P', '_', 'S', 'T', 'Q', '_', 'A', 'V', 'A', 'I', 'L', '\0', /* CP_STQ_AVAIL (56533) */
	'C', 'P', '_', 'R', 'O', 'Q', '2', '_', 'A', 'V', 'A', 'I', 'L', '\0', /* CP_ROQ2_AVAIL (56546) */
	'C', 'P', '_', 'M', 'E', 'Q', '_', 'A', 'V', 'A', 'I', 'L', '\0', /* CP_MEQ_AVAIL (56560) */
	'C', 'P', '_', 'C', 'M', 'D', '_', 'I', 'N', 'D', 'E', 'X', '\0', /* CP_CMD_INDEX (56573, 56576) */
	'C', 'P', '_', 'C', 'M', 'D', '_', 'D', 'A', 'T', 'A', '\0', /* CP_CMD_DATA (56586) */
	'C', 'P', '_', 'R', 'O', 'Q', '_', 'R', 'B', '_', 'S', 'T', 'A', 'T', '\0', /* CP_ROQ_RB_STAT (56598) */
	'C', 'P', '_', 'R', 'O', 'Q', '_', 'I', 'B', '1', '_', 'S', 'T', 'A', 'T', '\0', /* CP_ROQ_IB1_STAT (56613) */
	'C', 'P', '_', 'R', 'O', 'Q', '_', 'I', 'B', '2', '_', 'S', 'T', 'A', 'T', '\0', /* CP_ROQ_IB2_STAT (56629) */
	'C', 'P', '_', 'S', 'T', 'Q', '_', 'S', 'T', 'A', 'T', '\0', /* CP_STQ_STAT (56645) */
	'C', 'P', '_', 'M', 'E', 'Q', '_', 'S', 'T', 'A', 'T', '\0', /* CP_MEQ_STAT (56657) */
	'C', 'P', '_', 'C', 'E', 'Q', '1', '_', 'A', 'V', 'A', 'I', 'L', '\0', /* CP_CEQ1_AVAIL (56669) */
	'C', 'P', '_', 'C', 'E', 'Q', '2', '_', 'A', 'V', 'A', 'I', 'L', '\0', /* CP_CEQ2_AVAIL (56683) */
	'C', 'P', '_', 'C', 'E', '_', 'R', 'O', 'Q', '_', 'R', 'B', '_', 'S', 'T', 'A', 'T', '\0', /* CP_CE_ROQ_RB_STAT (56697) */
	'C', 'P', '_', 'C', 'E', '_', 'R', 'O', 'Q', '_', 'I', 'B', '1', '_', 'S', 'T', 'A', 'T', '\0', /* CP_CE_ROQ_IB1_STAT (56715) */
	'C', 'P', '_', 'C', 'E', '_', 'R', 'O', 'Q', '_', 'I', 'B', '2', '_', 'S', 'T', 'A', 'T', '\0', /* CP_CE_ROQ_IB2_STAT (56734) */
	'C', 'P', '_', 'I', 'N', 'T', '_', 'S', 'T', 'A', 'T', '_', 'D', 'E', 'B', 'U', 'G', '\0', /* CP_INT_STAT_DEBUG (56753) */
	'I', 'A', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* IA_PERFCOUNTER0_SELECT (56771) */
	'I', 'A', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* IA_PERFCOUNTER1_SELECT (56794) */
	'I', 'A', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* IA_PERFCOUNTER2_SELECT (56817) */
	'I', 'A', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '3', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* IA_PERFCOUNTER3_SELECT (56840) */
	'I', 'A', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'L', 'O', '\0', /* IA_PERFCOUNTER0_LO (56863) */
	'I', 'A', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'H', 'I', '\0', /* IA_PERFCOUNTER0_HI (56882) */
	'I', 'A', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'L', 'O', '\0', /* IA_PERFCOUNTER1_LO (56901) */
	'I', 'A', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'H', 'I', '\0', /* IA_PERFCOUNTER1_HI (56920) */
	'I', 'A', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', 'L', 'O', '\0', /* IA_PERFCOUNTER2_LO (56939) */
	'I', 'A', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', 'H', 'I', '\0', /* IA_PERFCOUNTER2_HI (56958) */
	'I', 'A', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '3', '_', 'L', 'O', '\0', /* IA_PERFCOUNTER3_LO (56977) */
	'I', 'A', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '3', '_', 'H', 'I', '\0', /* IA_PERFCOUNTER3_HI (56996) */
	'V', 'G', 'T', '_', 'V', 'T', 'X', '_', 'V', 'E', 'C', 'T', '_', 'E', 'J', 'E', 'C', 'T', '_', 'R', 'E', 'G', '\0', /* VGT_VTX_VECT_EJECT_REG (57015) */
	'V', 'G', 'T', '_', 'D', 'M', 'A', '_', 'D', 'A', 'T', 'A', '_', 'F', 'I', 'F', 'O', '_', 'D', 'E', 'P', 'T', 'H', '\0', /* VGT_DMA_DATA_FIFO_DEPTH (57038, 57042) */
	'V', 'G', 'T', '_', 'D', 'M', 'A', '_', 'R', 'E', 'Q', '_', 'F', 'I', 'F', 'O', '_', 'D', 'E', 'P', 'T', 'H', '\0', /* VGT_DMA_REQ_FIFO_DEPTH (57062, 57066) */
	'V', 'G', 'T', '_', 'D', 'R', 'A', 'W', '_', 'I', 'N', 'I', 'T', '_', 'F', 'I', 'F', 'O', '_', 'D', 'E', 'P', 'T', 'H', '\0', /* VGT_DRAW_INIT_FIFO_DEPTH (57085, 57089) */
	'V', 'G', 'T', '_', 'L', 'A', 'S', 'T', '_', 'C', 'O', 'P', 'Y', '_', 'S', 'T', 'A', 'T', 'E', '\0', /* VGT_LAST_COPY_STATE (57110) */
	'V', 'G', 'T', '_', 'C', 'A', 'C', 'H', 'E', '_', 'I', 'N', 'V', 'A', 'L', 'I', 'D', 'A', 'T', 'I', 'O', 'N', '\0', /* VGT_CACHE_INVALIDATION (57130, 57134) */
	'V', 'G', 'T', '_', 'F', 'I', 'F', 'O', '_', 'D', 'E', 'P', 'T', 'H', 'S', '\0', /* VGT_FIFO_DEPTHS (57153) */
	'V', 'G', 'T', '_', 'G', 'S', '_', 'V', 'E', 'R', 'T', 'E', 'X', '_', 'R', 'E', 'U', 'S', 'E', '\0', /* VGT_GS_VERTEX_REUSE (57169) */
	'V', 'G', 'T', '_', 'M', 'C', '_', 'L', 'A', 'T', '_', 'C', 'N', 'T', 'L', '\0', /* VGT_MC_LAT_CNTL (57189) */
	'I', 'A', '_', 'C', 'N', 'T', 'L', '_', 'S', 'T', 'A', 'T', 'U', 'S', '\0', /* IA_CNTL_STATUS (57205) */
	'V', 'G', 'T', '_', 'D', 'E', 'B', 'U', 'G', '_', 'C', 'N', 'T', 'L', '\0', /* VGT_DEBUG_CNTL (57220) */
	'V', 'G', 'T', '_', 'D', 'E', 'B', 'U', 'G', '_', 'D', 'A', 'T', 'A', '\0', /* VGT_DEBUG_DATA (57235) */
	'I', 'A', '_', 'D', 'E', 'B', 'U', 'G', '_', 'C', 'N', 'T', 'L', '\0', /* IA_DEBUG_CNTL (57250) */
	'I', 'A', '_', 'D', 'E', 'B', 'U', 'G', '_', 'D', 'A', 'T', 'A', '\0', /* IA_DEBUG_DATA (57264) */
	'V', 'G', 'T', '_', 'C', 'N', 'T', 'L', '_', 'S', 'T', 'A', 'T', 'U', 'S', '\0', /* VGT_CNTL_STATUS (57278) */
	'V', 'G', 'T', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '_', 'S', 'E', 'I', 'D', '_', 'M', 'A', 'S', 'K', '\0', /* VGT_PERFCOUNTER_SEID_MASK (57294) */
	'V', 'G', 'T', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* VGT_PERFCOUNTER0_SELECT (57320) */
	'V', 'G', 'T', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* VGT_PERFCOUNTER1_SELECT (57344) */
	'V', 'G', 'T', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* VGT_PERFCOUNTER2_SELECT (57368) */
	'V', 'G', 'T', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '3', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* VGT_PERFCOUNTER3_SELECT (57392) */
	'V', 'G', 'T', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'L', 'O', '\0', /* VGT_PERFCOUNTER0_LO (57416) */
	'V', 'G', 'T', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'H', 'I', '\0', /* VGT_PERFCOUNTER0_HI (57436) */
	'V', 'G', 'T', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'L', 'O', '\0', /* VGT_PERFCOUNTER1_LO (57456) */
	'V', 'G', 'T', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'H', 'I', '\0', /* VGT_PERFCOUNTER1_HI (57476) */
	'V', 'G', 'T', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', 'L', 'O', '\0', /* VGT_PERFCOUNTER2_LO (57496) */
	'V', 'G', 'T', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', 'H', 'I', '\0', /* VGT_PERFCOUNTER2_HI (57516) */
	'V', 'G', 'T', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '3', '_', 'L', 'O', '\0', /* VGT_PERFCOUNTER3_LO (57536) */
	'V', 'G', 'T', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '3', '_', 'H', 'I', '\0', /* VGT_PERFCOUNTER3_HI (57556) */
	'C', 'G', 'T', 'T', '_', 'V', 'G', 'T', '_', 'C', 'L', 'K', '_', 'C', 'T', 'R', 'L', '\0', /* CGTT_VGT_CLK_CTRL (57576) */
	'I', 'A', '_', 'V', 'M', 'I', 'D', '_', 'O', 'V', 'E', 'R', 'R', 'I', 'D', 'E', '\0', /* IA_VMID_OVERRIDE (57594) */
	'C', 'G', 'T', 'T', '_', 'I', 'A', '_', 'C', 'L', 'K', '_', 'C', 'T', 'R', 'L', '\0', /* CGTT_IA_CLK_CTRL (57611) */
	'V', 'G', 'T', '_', 'S', 'Y', 'S', '_', 'C', 'O', 'N', 'F', 'I', 'G', '\0', /* VGT_SYS_CONFIG (57628) */
	'C', 'C', '_', 'G', 'C', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'A', 'R', 'R', 'A', 'Y', '_', 'C', 'O', 'N', 'F', 'I', 'G', '\0', /* CC_GC_SHADER_ARRAY_CONFIG (57643) */
	'G', 'C', '_', 'U', 'S', 'E', 'R', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'A', 'R', 'R', 'A', 'Y', '_', 'C', 'O', 'N', 'F', 'I', 'G', '\0', /* GC_USER_SHADER_ARRAY_CONFIG (57669) */
	'P', 'A', '_', 'S', 'U', '_', 'D', 'E', 'B', 'U', 'G', '_', 'C', 'N', 'T', 'L', '\0', /* PA_SU_DEBUG_CNTL (57697) */
	'P', 'A', '_', 'S', 'U', '_', 'D', 'E', 'B', 'U', 'G', '_', 'D', 'A', 'T', 'A', '\0', /* PA_SU_DEBUG_DATA (57714) */
	'P', 'A', '_', 'C', 'L', '_', 'C', 'N', 'T', 'L', '_', 'S', 'T', 'A', 'T', 'U', 'S', '\0', /* PA_CL_CNTL_STATUS (57731) */
	'P', 'A', '_', 'C', 'L', '_', 'E', 'N', 'H', 'A', 'N', 'C', 'E', '\0', /* PA_CL_ENHANCE (57749) */
	'C', 'G', 'T', 'T', '_', 'P', 'A', '_', 'C', 'L', 'K', '_', 'C', 'T', 'R', 'L', '\0', /* CGTT_PA_CLK_CTRL (57763) */
	'P', 'A', '_', 'S', 'U', '_', 'C', 'N', 'T', 'L', '_', 'S', 'T', 'A', 'T', 'U', 'S', '\0', /* PA_SU_CNTL_STATUS (57780) */
	'P', 'A', '_', 'S', 'C', '_', 'F', 'I', 'F', 'O', '_', 'D', 'E', 'P', 'T', 'H', '_', 'C', 'N', 'T', 'L', '\0', /* PA_SC_FIFO_DEPTH_CNTL (57798) */
	'P', 'A', '_', 'S', 'C', '_', 'F', 'O', 'R', 'C', 'E', '_', 'E', 'O', 'V', '_', 'M', 'A', 'X', '_', 'C', 'N', 'T', 'S', '\0', /* PA_SC_FORCE_EOV_MAX_CNTS (57820) */
	'C', 'G', 'T', 'T', '_', 'S', 'C', '_', 'C', 'L', 'K', '_', 'C', 'T', 'R', 'L', '\0', /* CGTT_SC_CLK_CTRL (57845) */
	'P', 'A', '_', 'S', 'C', '_', 'F', 'I', 'F', 'O', '_', 'S', 'I', 'Z', 'E', '\0', /* PA_SC_FIFO_SIZE (57862) */
	'P', 'A', '_', 'S', 'C', '_', 'I', 'F', '_', 'F', 'I', 'F', 'O', '_', 'S', 'I', 'Z', 'E', '\0', /* PA_SC_IF_FIFO_SIZE (57878) */
	'P', 'A', '_', 'S', 'C', '_', 'D', 'E', 'B', 'U', 'G', '_', 'C', 'N', 'T', 'L', '\0', /* PA_SC_DEBUG_CNTL (57897) */
	'P', 'A', '_', 'S', 'C', '_', 'D', 'E', 'B', 'U', 'G', '_', 'D', 'A', 'T', 'A', '\0', /* PA_SC_DEBUG_DATA (57914) */
	'P', 'A', '_', 'S', 'C', '_', 'E', 'N', 'H', 'A', 'N', 'C', 'E', '\0', /* PA_SC_ENHANCE (57931) */
	'S', 'Q', '_', 'C', 'O', 'N', 'F', 'I', 'G', '\0', /* SQ_CONFIG (57945) */
	'S', 'Q', 'C', '_', 'C', 'O', 'N', 'F', 'I', 'G', '\0', /* SQC_CONFIG (57955) */
	'S', 'Q', '_', 'R', 'A', 'N', 'D', 'O', 'M', '_', 'W', 'A', 'V', 'E', '_', 'P', 'R', 'I', '\0', /* SQ_RANDOM_WAVE_PRI (57966) */
	'S', 'Q', '_', 'R', 'E', 'G', '_', 'C', 'R', 'E', 'D', 'I', 'T', 'S', '\0', /* SQ_REG_CREDITS (57985) */
	'S', 'Q', '_', 'F', 'I', 'F', 'O', '_', 'S', 'I', 'Z', 'E', 'S', '\0', /* SQ_FIFO_SIZES (58000) */
	'C', 'C', '_', 'S', 'Q', 'C', '_', 'B', 'A', 'N', 'K', '_', 'D', 'I', 'S', 'A', 'B', 'L', 'E', '\0', /* CC_SQC_BANK_DISABLE (58014) */
	'U', 'S', 'E', 'R', '_', 'S', 'Q', 'C', '_', 'B', 'A', 'N', 'K', '_', 'D', 'I', 'S', 'A', 'B', 'L', 'E', '\0', /* USER_SQC_BANK_DISABLE (58034) */
	'S', 'Q', '_', 'D', 'E', 'B', 'U', 'G', '_', 'S', 'T', 'S', '_', 'G', 'L', 'O', 'B', 'A', 'L', '\0', /* SQ_DEBUG_STS_GLOBAL (58056) */
	'S', 'Q', '_', 'A', 'L', 'U', '_', 'C', 'L', 'K', '_', 'C', 'T', 'R', 'L', '\0', /* SQ_ALU_CLK_CTRL (58076) */
	'S', 'Q', '_', 'T', 'E', 'X', '_', 'C', 'L', 'K', '_', 'C', 'T', 'R', 'L', '\0', /* SQ_TEX_CLK_CTRL (58092) */
	'C', 'G', 'T', 'T', '_', 'S', 'Q', '_', 'C', 'L', 'K', '_', 'C', 'T', 'R', 'L', '\0', /* CGTT_SQ_CLK_CTRL (58108) */
	'C', 'G', 'T', 'T', '_', 'S', 'Q', 'G', '_', 'C', 'L', 'K', '_', 'C', 'T', 'R', 'L', '\0', /* CGTT_SQG_CLK_CTRL (58125) */
	'S', 'Q', '_', 'I', 'N', 'D', '_', 'I', 'N', 'D', 'E', 'X', '\0', /* SQ_IND_INDEX (58143) */
	'S', 'Q', '_', 'I', 'N', 'D', '_', 'D', 'A', 'T', 'A', '\0', /* SQ_IND_DATA (58156) */
	'S', 'Q', '_', 'T', 'I', 'M', 'E', '_', 'H', 'I', '\0', /* SQ_TIME_HI (58168) */
	'S', 'Q', '_', 'T', 'I', 'M', 'E', '_', 'L', 'O', '\0', /* SQ_TIME_LO (58179) */
	'S', 'Q', '_', 'T', 'H', 'R', 'E', 'A', 'D', '_', 'T', 'R', 'A', 'C', 'E', '_', 'B', 'A', 'S', 'E', '\0', /* SQ_THREAD_TRACE_BASE (58190) */
	'S', 'Q', '_', 'T', 'H', 'R', 'E', 'A', 'D', '_', 'T', 'R', 'A', 'C', 'E', '_', 'S', 'I', 'Z', 'E', '\0', /* SQ_THREAD_TRACE_SIZE (58211) */
	'S', 'Q', '_', 'T', 'H', 'R', 'E', 'A', 'D', '_', 'T', 'R', 'A', 'C', 'E', '_', 'P', 'E', 'R', 'F', '_', 'M', 'A', 'S', 'K', '\0', /* SQ_THREAD_TRACE_PERF_MASK (58232) */
	'S', 'Q', '_', 'T', 'H', 'R', 'E', 'A', 'D', '_', 'T', 'R', 'A', 'C', 'E', '_', 'M', 'O', 'D', 'E', '\0', /* SQ_THREAD_TRACE_MODE (58258) */
	'S', 'Q', '_', 'T', 'H', 'R', 'E', 'A', 'D', '_', 'T', 'R', 'A', 'C', 'E', '_', 'C', 'N', 'T', 'R', '\0', /* SQ_THREAD_TRACE_CNTR (58279) */
	'S', 'Q', '_', 'T', 'H', 'R', 'E', 'A', 'D', '_', 'T', 'R', 'A', 'C', 'E', '_', 'H', 'I', 'W', 'A', 'T', 'E', 'R', '\0', /* SQ_THREAD_TRACE_HIWATER (58300, 58316) */
	'S', 'Q', '_', 'P', 'O', 'W', 'E', 'R', '_', 'T', 'H', 'R', 'O', 'T', 'T', 'L', 'E', '\0', /* SQ_POWER_THROTTLE (58324) */
	'S', 'Q', '_', 'P', 'O', 'W', 'E', 'R', '_', 'T', 'H', 'R', 'O', 'T', 'T', 'L', 'E', '2', '\0', /* SQ_POWER_THROTTLE2 (58342) */
	'S', 'Q', '_', 'L', 'B', '_', 'C', 'T', 'R', '_', 'C', 'T', 'R', 'L', '\0', /* SQ_LB_CTR_CTRL (58361) */
	'S', 'Q', '_', 'L', 'B', '_', 'D', 'A', 'T', 'A', '_', 'A', 'L', 'U', '_', 'C', 'Y', 'C', 'L', 'E', 'S', '\0', /* SQ_LB_DATA_ALU_CYCLES (58376) */
	'S', 'Q', '_', 'L', 'B', '_', 'D', 'A', 'T', 'A', '_', 'T', 'E', 'X', '_', 'C', 'Y', 'C', 'L', 'E', 'S', '\0', /* SQ_LB_DATA_TEX_CYCLES (58398) */
	'S', 'Q', '_', 'L', 'B', '_', 'D', 'A', 'T', 'A', '_', 'A', 'L', 'U', '_', 'S', 'T', 'A', 'L', 'L', 'S', '\0', /* SQ_LB_DATA_ALU_STALLS (58420) */
	'S', 'Q', '_', 'L', 'B', '_', 'D', 'A', 'T', 'A', '_', 'T', 'E', 'X', '_', 'S', 'T', 'A', 'L', 'L', 'S', '\0', /* SQ_LB_DATA_TEX_STALLS (58442) */
	'S', 'Q', 'C', '_', 'S', 'E', 'C', 'D', 'E', 'D', '_', 'C', 'N', 'T', '\0', /* SQC_SECDED_CNT (58464) */
	'S', 'Q', '_', 'S', 'E', 'C', '_', 'C', 'N', 'T', '\0', /* SQ_SEC_CNT (58479) */
	'S', 'Q', '_', 'D', 'E', 'D', '_', 'C', 'N', 'T', '\0', /* SQ_DED_CNT (58490) */
	'S', 'Q', '_', 'D', 'E', 'D', '_', 'I', 'N', 'F', 'O', '\0', /* SQ_DED_INFO (58501) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'T', 'B', 'A', '_', 'L', 'O', '_', 'P', 'S', '\0', /* SPI_SHADER_TBA_LO_PS (58513) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'T', 'B', 'A', '_', 'H', 'I', '_', 'P', 'S', '\0', /* SPI_SHADER_TBA_HI_PS (58534) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'T', 'M', 'A', '_', 'L', 'O', '_', 'P', 'S', '\0', /* SPI_SHADER_TMA_LO_PS (58555) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'T', 'M', 'A', '_', 'H', 'I', '_', 'P', 'S', '\0', /* SPI_SHADER_TMA_HI_PS (58576) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'T', 'B', 'A', '_', 'L', 'O', '_', 'V', 'S', '\0', /* SPI_SHADER_TBA_LO_VS (58597) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'T', 'B', 'A', '_', 'H', 'I', '_', 'V', 'S', '\0', /* SPI_SHADER_TBA_HI_VS (58618) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'T', 'M', 'A', '_', 'L', 'O', '_', 'V', 'S', '\0', /* SPI_SHADER_TMA_LO_VS (58639) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'T', 'M', 'A', '_', 'H', 'I', '_', 'V', 'S', '\0', /* SPI_SHADER_TMA_HI_VS (58660) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'T', 'B', 'A', '_', 'L', 'O', '_', 'G', 'S', '\0', /* SPI_SHADER_TBA_LO_GS (58681) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'T', 'B', 'A', '_', 'H', 'I', '_', 'G', 'S', '\0', /* SPI_SHADER_TBA_HI_GS (58702) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'T', 'M', 'A', '_', 'L', 'O', '_', 'G', 'S', '\0', /* SPI_SHADER_TMA_LO_GS (58723) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'T', 'M', 'A', '_', 'H', 'I', '_', 'G', 'S', '\0', /* SPI_SHADER_TMA_HI_GS (58744) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'T', 'B', 'A', '_', 'L', 'O', '_', 'E', 'S', '\0', /* SPI_SHADER_TBA_LO_ES (58765) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'T', 'B', 'A', '_', 'H', 'I', '_', 'E', 'S', '\0', /* SPI_SHADER_TBA_HI_ES (58786) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'T', 'M', 'A', '_', 'L', 'O', '_', 'E', 'S', '\0', /* SPI_SHADER_TMA_LO_ES (58807) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'T', 'M', 'A', '_', 'H', 'I', '_', 'E', 'S', '\0', /* SPI_SHADER_TMA_HI_ES (58828) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'T', 'B', 'A', '_', 'L', 'O', '_', 'H', 'S', '\0', /* SPI_SHADER_TBA_LO_HS (58849) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'T', 'B', 'A', '_', 'H', 'I', '_', 'H', 'S', '\0', /* SPI_SHADER_TBA_HI_HS (58870) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'T', 'M', 'A', '_', 'L', 'O', '_', 'H', 'S', '\0', /* SPI_SHADER_TMA_LO_HS (58891) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'T', 'M', 'A', '_', 'H', 'I', '_', 'H', 'S', '\0', /* SPI_SHADER_TMA_HI_HS (58912) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'T', 'B', 'A', '_', 'L', 'O', '_', 'L', 'S', '\0', /* SPI_SHADER_TBA_LO_LS (58933) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'T', 'B', 'A', '_', 'H', 'I', '_', 'L', 'S', '\0', /* SPI_SHADER_TBA_HI_LS (58954) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'T', 'M', 'A', '_', 'L', 'O', '_', 'L', 'S', '\0', /* SPI_SHADER_TMA_LO_LS (58975) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'T', 'M', 'A', '_', 'H', 'I', '_', 'L', 'S', '\0', /* SPI_SHADER_TMA_HI_LS (58996) */
	'C', 'O', 'M', 'P', 'U', 'T', 'E', '_', 'M', 'A', 'X', '_', 'W', 'A', 'V', 'E', '_', 'I', 'D', '\0', /* COMPUTE_MAX_WAVE_ID (59017, 59025, 59029) */
	'C', 'O', 'M', 'P', 'U', 'T', 'E', '_', 'T', 'B', 'A', '_', 'L', 'O', '\0', /* COMPUTE_TBA_LO (59037) */
	'C', 'O', 'M', 'P', 'U', 'T', 'E', '_', 'T', 'B', 'A', '_', 'H', 'I', '\0', /* COMPUTE_TBA_HI (59052) */
	'C', 'O', 'M', 'P', 'U', 'T', 'E', '_', 'T', 'M', 'A', '_', 'L', 'O', '\0', /* COMPUTE_TMA_LO (59067) */
	'C', 'O', 'M', 'P', 'U', 'T', 'E', '_', 'T', 'M', 'A', '_', 'H', 'I', '\0', /* COMPUTE_TMA_HI (59082) */
	'C', 'O', 'M', 'P', 'U', 'T', 'E', '_', 'S', 'T', 'A', 'T', 'I', 'C', '_', 'T', 'H', 'R', 'E', 'A', 'D', '_', 'M', 'G', 'M', 'T', '_', 'S', 'E', '0', '\0', /* COMPUTE_STATIC_THREAD_MGMT_SE0 (59097) */
	'C', 'O', 'M', 'P', 'U', 'T', 'E', '_', 'S', 'T', 'A', 'T', 'I', 'C', '_', 'T', 'H', 'R', 'E', 'A', 'D', '_', 'M', 'G', 'M', 'T', '_', 'S', 'E', '1', '\0', /* COMPUTE_STATIC_THREAD_MGMT_SE1 (59128) */
	'S', 'D', 'M', 'A', '0', '_', 'S', 'T', 'A', 'T', 'U', 'S', '_', 'R', 'E', 'G', '\0', /* SDMA0_STATUS_REG (59159) */
	'S', 'D', 'M', 'A', '1', '_', 'S', 'T', 'A', 'T', 'U', 'S', '_', 'R', 'E', 'G', '\0', /* SDMA1_STATUS_REG (59176) */
	'D', 'B', '_', 'D', 'E', 'P', 'T', 'H', '_', 'I', 'N', 'F', 'O', '\0', /* DB_DEPTH_INFO (59193) */
	'D', 'B', '_', 'D', 'E', 'P', 'T', 'H', '_', 'S', 'I', 'Z', 'E', '\0', /* DB_DEPTH_SIZE (59207) */
	'D', 'B', '_', 'D', 'E', 'P', 'T', 'H', '_', 'S', 'L', 'I', 'C', 'E', '\0', /* DB_DEPTH_SLICE (59221) */
	'C', 'P', '_', 'R', 'I', 'N', 'G', 'I', 'D', '\0', /* CP_RINGID (59236, 59239) */
	'C', 'P', '_', 'C', 'P', 'C', '_', 'M', 'C', '_', 'C', 'N', 'T', 'L', '\0', /* CP_CPC_MC_CNTL (59246) */
	'S', 'Q', '_', 'T', 'H', 'R', 'E', 'A', 'D', '_', 'T', 'R', 'A', 'C', 'E', '_', 'B', 'A', 'S', 'E', '2', '\0', /* SQ_THREAD_TRACE_BASE2 (59261) */
	'S', 'Q', '_', 'T', 'H', 'R', 'E', 'A', 'D', '_', 'T', 'R', 'A', 'C', 'E', '_', 'T', 'O', 'K', 'E', 'N', '_', 'M', 'A', 'S', 'K', '2', '\0', /* SQ_THREAD_TRACE_TOKEN_MASK2 (59283) */
	'C', 'O', 'M', 'P', 'U', 'T', 'E', '_', 'S', 'T', 'A', 'T', 'I', 'C', '_', 'T', 'H', 'R', 'E', 'A', 'D', '_', 'M', 'G', 'M', 'T', '_', 'S', 'E', '2', '\0', /* COMPUTE_STATIC_THREAD_MGMT_SE2 (59311) */
	'C', 'O', 'M', 'P', 'U', 'T', 'E', '_', 'S', 'T', 'A', 'T', 'I', 'C', '_', 'T', 'H', 'R', 'E', 'A', 'D', '_', 'M', 'G', 'M', 'T', '_', 'S', 'E', '3', '\0', /* COMPUTE_STATIC_THREAD_MGMT_SE3 (59342) */
	'W', 'D', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', 'L', 'O', '\0', /* WD_PERFCOUNTER2_LO (59373) */
	'W', 'D', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', 'H', 'I', '\0', /* WD_PERFCOUNTER2_HI (59392) */
	'W', 'D', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '3', '_', 'L', 'O', '\0', /* WD_PERFCOUNTER3_LO (59411) */
	'W', 'D', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '3', '_', 'H', 'I', '\0', /* WD_PERFCOUNTER3_HI (59430) */
	'T', 'C', 'C', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'L', 'O', '\0', /* TCC_PERFCOUNTER0_LO (59449) */
	'T', 'C', 'C', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'H', 'I', '\0', /* TCC_PERFCOUNTER0_HI (59469) */
	'T', 'C', 'C', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'L', 'O', '\0', /* TCC_PERFCOUNTER1_LO (59489) */
	'T', 'C', 'C', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'H', 'I', '\0', /* TCC_PERFCOUNTER1_HI (59509) */
	'T', 'C', 'C', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', 'L', 'O', '\0', /* TCC_PERFCOUNTER2_LO (59529) */
	'T', 'C', 'C', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', 'H', 'I', '\0', /* TCC_PERFCOUNTER2_HI (59549) */
	'T', 'C', 'C', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '3', '_', 'L', 'O', '\0', /* TCC_PERFCOUNTER3_LO (59569) */
	'T', 'C', 'C', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '3', '_', 'H', 'I', '\0', /* TCC_PERFCOUNTER3_HI (59589) */
	'T', 'C', 'A', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'L', 'O', '\0', /* TCA_PERFCOUNTER0_LO (59609) */
	'T', 'C', 'A', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'H', 'I', '\0', /* TCA_PERFCOUNTER0_HI (59629) */
	'T', 'C', 'A', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'L', 'O', '\0', /* TCA_PERFCOUNTER1_LO (59649) */
	'T', 'C', 'A', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'H', 'I', '\0', /* TCA_PERFCOUNTER1_HI (59669) */
	'T', 'C', 'A', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', 'L', 'O', '\0', /* TCA_PERFCOUNTER2_LO (59689) */
	'T', 'C', 'A', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', 'H', 'I', '\0', /* TCA_PERFCOUNTER2_HI (59709) */
	'T', 'C', 'A', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '3', '_', 'L', 'O', '\0', /* TCA_PERFCOUNTER3_LO (59729) */
	'T', 'C', 'A', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '3', '_', 'H', 'I', '\0', /* TCA_PERFCOUNTER3_HI (59749) */
	'T', 'C', 'S', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'L', 'O', '\0', /* TCS_PERFCOUNTER0_LO (59769) */
	'T', 'C', 'S', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'H', 'I', '\0', /* TCS_PERFCOUNTER0_HI (59789) */
	'T', 'C', 'S', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'L', 'O', '\0', /* TCS_PERFCOUNTER1_LO (59809) */
	'T', 'C', 'S', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'H', 'I', '\0', /* TCS_PERFCOUNTER1_HI (59829) */
	'T', 'C', 'S', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', 'L', 'O', '\0', /* TCS_PERFCOUNTER2_LO (59849) */
	'T', 'C', 'S', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', 'H', 'I', '\0', /* TCS_PERFCOUNTER2_HI (59869) */
	'T', 'C', 'S', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '3', '_', 'L', 'O', '\0', /* TCS_PERFCOUNTER3_LO (59889) */
	'T', 'C', 'S', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '3', '_', 'H', 'I', '\0', /* TCS_PERFCOUNTER3_HI (59909) */
	'W', 'D', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* WD_PERFCOUNTER2_SELECT (59929) */
	'W', 'D', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '3', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* WD_PERFCOUNTER3_SELECT (59952) */
	'I', 'A', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'S', 'E', 'L', 'E', 'C', 'T', '1', '\0', /* IA_PERFCOUNTER0_SELECT1 (59975) */
	'V', 'G', 'T', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'S', 'E', 'L', 'E', 'C', 'T', '1', '\0', /* VGT_PERFCOUNTER0_SELECT1 (59999) */
	'V', 'G', 'T', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'S', 'E', 'L', 'E', 'C', 'T', '1', '\0', /* VGT_PERFCOUNTER1_SELECT1 (60024) */
	'S', 'Q', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '_', 'M', 'A', 'S', 'K', '\0', /* SQ_PERFCOUNTER_MASK (60049) */
	'T', 'C', 'C', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* TCC_PERFCOUNTER0_SELECT (60069) */
	'T', 'C', 'C', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'S', 'E', 'L', 'E', 'C', 'T', '1', '\0', /* TCC_PERFCOUNTER0_SELECT1 (60093) */
	'T', 'C', 'C', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* TCC_PERFCOUNTER1_SELECT (60118) */
	'T', 'C', 'C', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'S', 'E', 'L', 'E', 'C', 'T', '1', '\0', /* TCC_PERFCOUNTER1_SELECT1 (60142) */
	'T', 'C', 'C', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* TCC_PERFCOUNTER2_SELECT (60167) */
	'T', 'C', 'C', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '3', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* TCC_PERFCOUNTER3_SELECT (60191) */
	'T', 'C', 'A', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* TCA_PERFCOUNTER0_SELECT (60215) */
	'T', 'C', 'A', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'S', 'E', 'L', 'E', 'C', 'T', '1', '\0', /* TCA_PERFCOUNTER0_SELECT1 (60239) */
	'T', 'C', 'A', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* TCA_PERFCOUNTER1_SELECT (60264) */
	'T', 'C', 'A', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'S', 'E', 'L', 'E', 'C', 'T', '1', '\0', /* TCA_PERFCOUNTER1_SELECT1 (60288) */
	'T', 'C', 'A', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* TCA_PERFCOUNTER2_SELECT (60313) */
	'T', 'C', 'A', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '3', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* TCA_PERFCOUNTER3_SELECT (60337) */
	'T', 'C', 'S', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* TCS_PERFCOUNTER0_SELECT (60361) */
	'T', 'C', 'S', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'S', 'E', 'L', 'E', 'C', 'T', '1', '\0', /* TCS_PERFCOUNTER0_SELECT1 (60385) */
	'T', 'C', 'S', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* TCS_PERFCOUNTER1_SELECT (60410) */
	'T', 'C', 'S', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* TCS_PERFCOUNTER2_SELECT (60434) */
	'T', 'C', 'S', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '3', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* TCS_PERFCOUNTER3_SELECT (60458) */
	'R', 'L', 'C', '_', 'S', 'P', 'M', '_', 'C', 'P', 'G', '_', 'P', 'E', 'R', 'F', 'M', 'O', 'N', '_', 'S', 'A', 'M', 'P', 'L', 'E', '_', 'D', 'E', 'L', 'A', 'Y', '\0', /* RLC_SPM_CPG_PERFMON_SAMPLE_DELAY (60482, 60494) */
	'R', 'L', 'C', '_', 'S', 'P', 'M', '_', 'C', 'P', 'C', '_', 'P', 'E', 'R', 'F', 'M', 'O', 'N', '_', 'S', 'A', 'M', 'P', 'L', 'E', '_', 'D', 'E', 'L', 'A', 'Y', '\0', /* RLC_SPM_CPC_PERFMON_SAMPLE_DELAY (60515) */
	'R', 'L', 'C', '_', 'S', 'P', 'M', '_', 'C', 'P', 'F', '_', 'P', 'E', 'R', 'F', 'M', 'O', 'N', '_', 'S', 'A', 'M', 'P', 'L', 'E', '_', 'D', 'E', 'L', 'A', 'Y', '\0', /* RLC_SPM_CPF_PERFMON_SAMPLE_DELAY (60548) */
	'R', 'L', 'C', '_', 'S', 'P', 'M', '_', 'C', 'B', '_', 'P', 'E', 'R', 'F', 'M', 'O', 'N', '_', 'S', 'A', 'M', 'P', 'L', 'E', '_', 'D', 'E', 'L', 'A', 'Y', '\0', /* RLC_SPM_CB_PERFMON_SAMPLE_DELAY (60581) */
	'R', 'L', 'C', '_', 'S', 'P', 'M', '_', 'D', 'B', '_', 'P', 'E', 'R', 'F', 'M', 'O', 'N', '_', 'S', 'A', 'M', 'P', 'L', 'E', '_', 'D', 'E', 'L', 'A', 'Y', '\0', /* RLC_SPM_DB_PERFMON_SAMPLE_DELAY (60613) */
	'R', 'L', 'C', '_', 'S', 'P', 'M', '_', 'P', 'A', '_', 'P', 'E', 'R', 'F', 'M', 'O', 'N', '_', 'S', 'A', 'M', 'P', 'L', 'E', '_', 'D', 'E', 'L', 'A', 'Y', '\0', /* RLC_SPM_PA_PERFMON_SAMPLE_DELAY (60645) */
	'R', 'L', 'C', '_', 'S', 'P', 'M', '_', 'G', 'D', 'S', '_', 'P', 'E', 'R', 'F', 'M', 'O', 'N', '_', 'S', 'A', 'M', 'P', 'L', 'E', '_', 'D', 'E', 'L', 'A', 'Y', '\0', /* RLC_SPM_GDS_PERFMON_SAMPLE_DELAY (60677) */
	'R', 'L', 'C', '_', 'S', 'P', 'M', '_', 'I', 'A', '_', 'P', 'E', 'R', 'F', 'M', 'O', 'N', '_', 'S', 'A', 'M', 'P', 'L', 'E', '_', 'D', 'E', 'L', 'A', 'Y', '\0', /* RLC_SPM_IA_PERFMON_SAMPLE_DELAY (60710) */
	'R', 'L', 'C', '_', 'S', 'P', 'M', '_', 'S', 'C', '_', 'P', 'E', 'R', 'F', 'M', 'O', 'N', '_', 'S', 'A', 'M', 'P', 'L', 'E', '_', 'D', 'E', 'L', 'A', 'Y', '\0', /* RLC_SPM_SC_PERFMON_SAMPLE_DELAY (60742) */
	'R', 'L', 'C', '_', 'S', 'P', 'M', '_', 'T', 'C', 'C', '_', 'P', 'E', 'R', 'F', 'M', 'O', 'N', '_', 'S', 'A', 'M', 'P', 'L', 'E', '_', 'D', 'E', 'L', 'A', 'Y', '\0', /* RLC_SPM_TCC_PERFMON_SAMPLE_DELAY (60774) */
	'R', 'L', 'C', '_', 'S', 'P', 'M', '_', 'T', 'C', 'A', '_', 'P', 'E', 'R', 'F', 'M', 'O', 'N', '_', 'S', 'A', 'M', 'P', 'L', 'E', '_', 'D', 'E', 'L', 'A', 'Y', '\0', /* RLC_SPM_TCA_PERFMON_SAMPLE_DELAY (60807) */
	'R', 'L', 'C', '_', 'S', 'P', 'M', '_', 'T', 'C', 'P', '_', 'P', 'E', 'R', 'F', 'M', 'O', 'N', '_', 'S', 'A', 'M', 'P', 'L', 'E', '_', 'D', 'E', 'L', 'A', 'Y', '\0', /* RLC_SPM_TCP_PERFMON_SAMPLE_DELAY (60840) */
	'R', 'L', 'C', '_', 'S', 'P', 'M', '_', 'T', 'A', '_', 'P', 'E', 'R', 'F', 'M', 'O', 'N', '_', 'S', 'A', 'M', 'P', 'L', 'E', '_', 'D', 'E', 'L', 'A', 'Y', '\0', /* RLC_SPM_TA_PERFMON_SAMPLE_DELAY (60873) */
	'R', 'L', 'C', '_', 'S', 'P', 'M', '_', 'T', 'D', '_', 'P', 'E', 'R', 'F', 'M', 'O', 'N', '_', 'S', 'A', 'M', 'P', 'L', 'E', '_', 'D', 'E', 'L', 'A', 'Y', '\0', /* RLC_SPM_TD_PERFMON_SAMPLE_DELAY (60905) */
	'R', 'L', 'C', '_', 'S', 'P', 'M', '_', 'V', 'G', 'T', '_', 'P', 'E', 'R', 'F', 'M', 'O', 'N', '_', 'S', 'A', 'M', 'P', 'L', 'E', '_', 'D', 'E', 'L', 'A', 'Y', '\0', /* RLC_SPM_VGT_PERFMON_SAMPLE_DELAY (60937) */
	'R', 'L', 'C', '_', 'S', 'P', 'M', '_', 'S', 'P', 'I', '_', 'P', 'E', 'R', 'F', 'M', 'O', 'N', '_', 'S', 'A', 'M', 'P', 'L', 'E', '_', 'D', 'E', 'L', 'A', 'Y', '\0', /* RLC_SPM_SPI_PERFMON_SAMPLE_DELAY (60970) */
	'R', 'L', 'C', '_', 'S', 'P', 'M', '_', 'S', 'Q', 'G', '_', 'P', 'E', 'R', 'F', 'M', 'O', 'N', '_', 'S', 'A', 'M', 'P', 'L', 'E', '_', 'D', 'E', 'L', 'A', 'Y', '\0', /* RLC_SPM_SQG_PERFMON_SAMPLE_DELAY (61003) */
	'R', 'L', 'C', '_', 'S', 'P', 'M', '_', 'T', 'C', 'S', '_', 'P', 'E', 'R', 'F', 'M', 'O', 'N', '_', 'S', 'A', 'M', 'P', 'L', 'E', '_', 'D', 'E', 'L', 'A', 'Y', '\0', /* RLC_SPM_TCS_PERFMON_SAMPLE_DELAY (61036) */
	'R', 'L', 'C', '_', 'S', 'P', 'M', '_', 'S', 'X', '_', 'P', 'E', 'R', 'F', 'M', 'O', 'N', '_', 'S', 'A', 'M', 'P', 'L', 'E', '_', 'D', 'E', 'L', 'A', 'Y', '\0', /* RLC_SPM_SX_PERFMON_SAMPLE_DELAY (61069) */
	'R', 'L', 'C', '_', 'S', 'P', 'M', '_', 'D', 'B', 'R', '0', '_', 'P', 'E', 'R', 'F', 'M', 'O', 'N', '_', 'S', 'A', 'M', 'P', 'L', 'E', '_', 'D', 'E', 'L', 'A', 'Y', '\0', /* RLC_SPM_DBR0_PERFMON_SAMPLE_DELAY (61101) */
	'R', 'L', 'C', '_', 'S', 'P', 'M', '_', 'D', 'B', 'R', '1', '_', 'P', 'E', 'R', 'F', 'M', 'O', 'N', '_', 'S', 'A', 'M', 'P', 'L', 'E', '_', 'D', 'E', 'L', 'A', 'Y', '\0', /* RLC_SPM_DBR1_PERFMON_SAMPLE_DELAY (61135) */
	'R', 'L', 'C', '_', 'S', 'P', 'M', '_', 'C', 'B', 'R', '0', '_', 'P', 'E', 'R', 'F', 'M', 'O', 'N', '_', 'S', 'A', 'M', 'P', 'L', 'E', '_', 'D', 'E', 'L', 'A', 'Y', '\0', /* RLC_SPM_CBR0_PERFMON_SAMPLE_DELAY (61169) */
	'R', 'L', 'C', '_', 'S', 'P', 'M', '_', 'C', 'B', 'R', '1', '_', 'P', 'E', 'R', 'F', 'M', 'O', 'N', '_', 'S', 'A', 'M', 'P', 'L', 'E', '_', 'D', 'E', 'L', 'A', 'Y', '\0', /* RLC_SPM_CBR1_PERFMON_SAMPLE_DELAY (61203) */
	'C', 'O', 'M', 'P', 'U', 'T', 'E', '_', 'W', 'A', 'V', 'E', '_', 'R', 'E', 'S', 'T', 'O', 'R', 'E', '_', 'C', 'O', 'N', 'T', 'R', 'O', 'L', '\0', /* COMPUTE_WAVE_RESTORE_CONTROL (61237) */
	'C', 'P', '_', 'C', 'E', '_', 'R', 'B', '_', 'O', 'F', 'F', 'S', 'E', 'T', '\0', /* CP_CE_RB_OFFSET (61266) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'E', 'S', '_', '1', '6', '\0', /* SPI_SHADER_USER_DATA_ES_16 (61282) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'E', 'S', '_', '1', '7', '\0', /* SPI_SHADER_USER_DATA_ES_17 (61309) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'E', 'S', '_', '1', '8', '\0', /* SPI_SHADER_USER_DATA_ES_18 (61336) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'E', 'S', '_', '1', '9', '\0', /* SPI_SHADER_USER_DATA_ES_19 (61363) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'E', 'S', '_', '2', '0', '\0', /* SPI_SHADER_USER_DATA_ES_20 (61390) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'E', 'S', '_', '2', '1', '\0', /* SPI_SHADER_USER_DATA_ES_21 (61417) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'E', 'S', '_', '2', '2', '\0', /* SPI_SHADER_USER_DATA_ES_22 (61444) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'E', 'S', '_', '2', '3', '\0', /* SPI_SHADER_USER_DATA_ES_23 (61471) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'E', 'S', '_', '2', '4', '\0', /* SPI_SHADER_USER_DATA_ES_24 (61498) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'E', 'S', '_', '2', '5', '\0', /* SPI_SHADER_USER_DATA_ES_25 (61525) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'E', 'S', '_', '2', '6', '\0', /* SPI_SHADER_USER_DATA_ES_26 (61552) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'E', 'S', '_', '2', '7', '\0', /* SPI_SHADER_USER_DATA_ES_27 (61579) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'E', 'S', '_', '2', '8', '\0', /* SPI_SHADER_USER_DATA_ES_28 (61606) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'E', 'S', '_', '2', '9', '\0', /* SPI_SHADER_USER_DATA_ES_29 (61633) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'E', 'S', '_', '3', '0', '\0', /* SPI_SHADER_USER_DATA_ES_30 (61660) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'E', 'S', '_', '3', '1', '\0', /* SPI_SHADER_USER_DATA_ES_31 (61687) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'L', 'S', '_', '1', '6', '\0', /* SPI_SHADER_USER_DATA_LS_16 (61714) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'L', 'S', '_', '1', '7', '\0', /* SPI_SHADER_USER_DATA_LS_17 (61741) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'L', 'S', '_', '1', '8', '\0', /* SPI_SHADER_USER_DATA_LS_18 (61768) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'L', 'S', '_', '1', '9', '\0', /* SPI_SHADER_USER_DATA_LS_19 (61795) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'L', 'S', '_', '2', '0', '\0', /* SPI_SHADER_USER_DATA_LS_20 (61822) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'L', 'S', '_', '2', '1', '\0', /* SPI_SHADER_USER_DATA_LS_21 (61849) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'L', 'S', '_', '2', '2', '\0', /* SPI_SHADER_USER_DATA_LS_22 (61876) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'L', 'S', '_', '2', '3', '\0', /* SPI_SHADER_USER_DATA_LS_23 (61903) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'L', 'S', '_', '2', '4', '\0', /* SPI_SHADER_USER_DATA_LS_24 (61930) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'L', 'S', '_', '2', '5', '\0', /* SPI_SHADER_USER_DATA_LS_25 (61957) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'L', 'S', '_', '2', '6', '\0', /* SPI_SHADER_USER_DATA_LS_26 (61984) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'L', 'S', '_', '2', '7', '\0', /* SPI_SHADER_USER_DATA_LS_27 (62011) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'L', 'S', '_', '2', '8', '\0', /* SPI_SHADER_USER_DATA_LS_28 (62038) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'L', 'S', '_', '2', '9', '\0', /* SPI_SHADER_USER_DATA_LS_29 (62065) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'L', 'S', '_', '3', '0', '\0', /* SPI_SHADER_USER_DATA_LS_30 (62092) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'L', 'S', '_', '3', '1', '\0', /* SPI_SHADER_USER_DATA_LS_31 (62119) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'C', 'O', 'M', 'M', 'O', 'N', '_', '0', '\0', /* SPI_SHADER_USER_DATA_COMMON_0 (62146) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'C', 'O', 'M', 'M', 'O', 'N', '_', '1', '\0', /* SPI_SHADER_USER_DATA_COMMON_1 (62176) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'C', 'O', 'M', 'M', 'O', 'N', '_', '2', '\0', /* SPI_SHADER_USER_DATA_COMMON_2 (62206) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'C', 'O', 'M', 'M', 'O', 'N', '_', '3', '\0', /* SPI_SHADER_USER_DATA_COMMON_3 (62236) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'C', 'O', 'M', 'M', 'O', 'N', '_', '4', '\0', /* SPI_SHADER_USER_DATA_COMMON_4 (62266) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'C', 'O', 'M', 'M', 'O', 'N', '_', '5', '\0', /* SPI_SHADER_USER_DATA_COMMON_5 (62296) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'C', 'O', 'M', 'M', 'O', 'N', '_', '6', '\0', /* SPI_SHADER_USER_DATA_COMMON_6 (62326) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'C', 'O', 'M', 'M', 'O', 'N', '_', '7', '\0', /* SPI_SHADER_USER_DATA_COMMON_7 (62356) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'C', 'O', 'M', 'M', 'O', 'N', '_', '8', '\0', /* SPI_SHADER_USER_DATA_COMMON_8 (62386) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'C', 'O', 'M', 'M', 'O', 'N', '_', '9', '\0', /* SPI_SHADER_USER_DATA_COMMON_9 (62416) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'C', 'O', 'M', 'M', 'O', 'N', '_', '1', '0', '\0', /* SPI_SHADER_USER_DATA_COMMON_10 (62446) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'C', 'O', 'M', 'M', 'O', 'N', '_', '1', '1', '\0', /* SPI_SHADER_USER_DATA_COMMON_11 (62477) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'C', 'O', 'M', 'M', 'O', 'N', '_', '1', '2', '\0', /* SPI_SHADER_USER_DATA_COMMON_12 (62508) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'C', 'O', 'M', 'M', 'O', 'N', '_', '1', '3', '\0', /* SPI_SHADER_USER_DATA_COMMON_13 (62539) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'C', 'O', 'M', 'M', 'O', 'N', '_', '1', '4', '\0', /* SPI_SHADER_USER_DATA_COMMON_14 (62570) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'C', 'O', 'M', 'M', 'O', 'N', '_', '1', '5', '\0', /* SPI_SHADER_USER_DATA_COMMON_15 (62601) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'C', 'O', 'M', 'M', 'O', 'N', '_', '1', '6', '\0', /* SPI_SHADER_USER_DATA_COMMON_16 (62632) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'C', 'O', 'M', 'M', 'O', 'N', '_', '1', '7', '\0', /* SPI_SHADER_USER_DATA_COMMON_17 (62663) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'C', 'O', 'M', 'M', 'O', 'N', '_', '1', '8', '\0', /* SPI_SHADER_USER_DATA_COMMON_18 (62694) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'C', 'O', 'M', 'M', 'O', 'N', '_', '1', '9', '\0', /* SPI_SHADER_USER_DATA_COMMON_19 (62725) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'C', 'O', 'M', 'M', 'O', 'N', '_', '2', '0', '\0', /* SPI_SHADER_USER_DATA_COMMON_20 (62756) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'C', 'O', 'M', 'M', 'O', 'N', '_', '2', '1', '\0', /* SPI_SHADER_USER_DATA_COMMON_21 (62787) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'C', 'O', 'M', 'M', 'O', 'N', '_', '2', '2', '\0', /* SPI_SHADER_USER_DATA_COMMON_22 (62818) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'C', 'O', 'M', 'M', 'O', 'N', '_', '2', '3', '\0', /* SPI_SHADER_USER_DATA_COMMON_23 (62849) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'C', 'O', 'M', 'M', 'O', 'N', '_', '2', '4', '\0', /* SPI_SHADER_USER_DATA_COMMON_24 (62880) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'C', 'O', 'M', 'M', 'O', 'N', '_', '2', '5', '\0', /* SPI_SHADER_USER_DATA_COMMON_25 (62911) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'C', 'O', 'M', 'M', 'O', 'N', '_', '2', '6', '\0', /* SPI_SHADER_USER_DATA_COMMON_26 (62942) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'C', 'O', 'M', 'M', 'O', 'N', '_', '2', '7', '\0', /* SPI_SHADER_USER_DATA_COMMON_27 (62973) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'C', 'O', 'M', 'M', 'O', 'N', '_', '2', '8', '\0', /* SPI_SHADER_USER_DATA_COMMON_28 (63004) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'C', 'O', 'M', 'M', 'O', 'N', '_', '2', '9', '\0', /* SPI_SHADER_USER_DATA_COMMON_29 (63035) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'C', 'O', 'M', 'M', 'O', 'N', '_', '3', '0', '\0', /* SPI_SHADER_USER_DATA_COMMON_30 (63066) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'C', 'O', 'M', 'M', 'O', 'N', '_', '3', '1', '\0', /* SPI_SHADER_USER_DATA_COMMON_31 (63097) */
	'D', 'B', '_', 'Z', '_', 'I', 'N', 'F', 'O', '2', '\0', /* DB_Z_INFO2 (63128) */
	'D', 'B', '_', 'S', 'T', 'E', 'N', 'C', 'I', 'L', '_', 'I', 'N', 'F', 'O', '2', '\0', /* DB_STENCIL_INFO2 (63139) */
	'C', 'B', '_', 'M', 'R', 'T', '0', '_', 'E', 'P', 'I', 'T', 'C', 'H', '\0', /* CB_MRT0_EPITCH (63156, 63164) */
	'C', 'B', '_', 'M', 'R', 'T', '1', '_', 'E', 'P', 'I', 'T', 'C', 'H', '\0', /* CB_MRT1_EPITCH (63171) */
	'C', 'B', '_', 'M', 'R', 'T', '2', '_', 'E', 'P', 'I', 'T', 'C', 'H', '\0', /* CB_MRT2_EPITCH (63186) */
	'C', 'B', '_', 'M', 'R', 'T', '3', '_', 'E', 'P', 'I', 'T', 'C', 'H', '\0', /* CB_MRT3_EPITCH (63201) */
	'C', 'B', '_', 'M', 'R', 'T', '4', '_', 'E', 'P', 'I', 'T', 'C', 'H', '\0', /* CB_MRT4_EPITCH (63216) */
	'C', 'B', '_', 'M', 'R', 'T', '5', '_', 'E', 'P', 'I', 'T', 'C', 'H', '\0', /* CB_MRT5_EPITCH (63231) */
	'C', 'B', '_', 'M', 'R', 'T', '6', '_', 'E', 'P', 'I', 'T', 'C', 'H', '\0', /* CB_MRT6_EPITCH (63246) */
	'C', 'B', '_', 'M', 'R', 'T', '7', '_', 'E', 'P', 'I', 'T', 'C', 'H', '\0', /* CB_MRT7_EPITCH (63261) */
	'V', 'G', 'T', '_', 'G', 'S', '_', 'M', 'A', 'X', '_', 'P', 'R', 'I', 'M', 'S', '_', 'P', 'E', 'R', '_', 'S', 'U', 'B', 'G', 'R', 'O', 'U', 'P', '\0', /* VGT_GS_MAX_PRIMS_PER_SUBGROUP (63276, 63283, 63287) */
	'C', 'P', '_', 'A', 'P', 'P', 'E', 'N', 'D', '_', 'D', 'A', 'T', 'A', '_', 'L', 'O', '\0', /* CP_APPEND_DATA_LO (63306) */
	'C', 'P', '_', 'A', 'P', 'P', 'E', 'N', 'D', '_', 'L', 'A', 'S', 'T', '_', 'C', 'S', '_', 'F', 'E', 'N', 'C', 'E', '_', 'L', 'O', '\0', /* CP_APPEND_LAST_CS_FENCE_LO (63324) */
	'C', 'P', '_', 'A', 'P', 'P', 'E', 'N', 'D', '_', 'L', 'A', 'S', 'T', '_', 'P', 'S', '_', 'F', 'E', 'N', 'C', 'E', '_', 'L', 'O', '\0', /* CP_APPEND_LAST_PS_FENCE_LO (63351) */
	'R', 'L', 'C', '_', 'S', 'P', 'M', '_', 'R', 'M', 'I', '_', 'P', 'E', 'R', 'F', 'M', 'O', 'N', '_', 'S', 'A', 'M', 'P', 'L', 'E', '_', 'D', 'E', 'L', 'A', 'Y', '\0', /* RLC_SPM_RMI_PERFMON_SAMPLE_DELAY (63378) */
	'R', 'L', 'C', '_', 'S', 'P', 'M', '_', 'P', 'E', 'R', 'F', 'M', 'O', 'N', '_', 'S', 'A', 'M', 'P', 'L', 'E', '_', 'D', 'E', 'L', 'A', 'Y', '_', 'M', 'A', 'X', '\0', /* RLC_SPM_PERFMON_SAMPLE_DELAY_MAX (63411, 63438) */
	'C', 'O', 'M', 'P', 'U', 'T', 'E', '_', 'T', 'G', '_', 'C', 'H', 'U', 'N', 'K', '_', 'S', 'I', 'Z', 'E', '\0', /* COMPUTE_TG_CHUNK_SIZE (63444, 63452) */
	'F', 'P', '_', 'R', 'O', 'U', 'N', 'D', '\0', /* FP_ROUND (63466, 63469) */
	'F', 'P', '_', 'D', 'E', 'N', 'O', 'R', 'M', '\0', /* FP_DENORM (63475) */
	'D', 'X', '1', '0', '_', 'C', 'L', 'A', 'M', 'P', '\0', /* DX10_CLAMP (63485) */
	'I', 'E', 'E', 'E', '\0', /* IEEE (63496) */
	'L', 'O', 'D', '_', 'C', 'L', 'A', 'M', 'P', 'E', 'D', '\0', /* LOD_CLAMPED (63501) */
	'I', 'N', 'V', 'A', 'L', 'I', 'D', '\0', /* INVALID (63513, 63515) */
	'I', 'N', 'P', 'U', 'T', '_', 'D', 'E', 'N', 'O', 'R', 'M', 'A', 'L', '\0', /* INPUT_DENORMAL (63521) */
	'D', 'I', 'V', 'I', 'D', 'E', '_', 'B', 'Y', '_', 'Z', 'E', 'R', 'O', '\0', /* DIVIDE_BY_ZERO (63536) */
	'O', 'V', 'E', 'R', 'F', 'L', 'O', 'W', '\0', /* OVERFLOW (63551) */
	'U', 'N', 'D', 'E', 'R', 'F', 'L', 'O', 'W', '\0', /* UNDERFLOW (63560) */
	'I', 'N', 'E', 'X', 'A', 'C', 'T', '\0', /* INEXACT (63570, 63572) */
	'I', 'N', 'T', '_', 'D', 'I', 'V', 'I', 'D', 'E', '_', 'B', 'Y', '_', 'Z', 'E', 'R', 'O', '\0', /* INT_DIVIDE_BY_ZERO (63578) */
	'A', 'D', 'D', 'R', 'E', 'S', 'S', '_', 'W', 'A', 'T', 'C', 'H', '\0', /* ADDRESS_WATCH (63597) */
	'M', 'E', 'M', 'O', 'R', 'Y', '_', 'V', 'I', 'O', 'L', 'A', 'T', 'I', 'O', 'N', '\0', /* MEMORY_VIOLATION (63611) */
	'E', 'X', 'C', 'P', '_', 'E', 'N', '\0', /* EXCP_EN (63628) */
	'F', 'P', '1', '6', '_', 'O', 'V', 'F', 'L', '\0', /* FP16_OVFL (63636) */
	'D', 'I', 'S', 'A', 'B', 'L', 'E', '_', 'P', 'E', 'R', 'F', '\0', /* DISABLE_PERF (63646) */
	'V', 'S', 'K', 'I', 'P', '\0', /* VSKIP (63659) */
	'C', 'S', 'P', '\0', /* CSP (63665) */
	'S', 'C', 'C', '\0', /* SCC (63669) */
	'S', 'P', 'I', '_', 'P', 'R', 'I', 'O', '\0', /* SPI_PRIO (63673) */
	'U', 'S', 'E', 'R', '_', 'P', 'R', 'I', 'O', '\0', /* USER_PRIO (63682) */
	'T', 'R', 'A', 'P', '_', 'E', 'N', '\0', /* TRAP_EN (63692) */
	'T', 'T', 'R', 'A', 'C', 'E', '_', 'E', 'N', '\0', /* TTRACE_EN (63700) */
	'E', 'X', 'P', 'O', 'R', 'T', '_', 'R', 'D', 'Y', '\0', /* EXPORT_RDY (63710) */
	'E', 'X', 'E', 'C', 'Z', '\0', /* EXECZ (63721) */
	'V', 'C', 'C', 'Z', '\0', /* VCCZ (63727) */
	'I', 'N', '_', 'T', 'G', '\0', /* IN_TG (63732) */
	'I', 'N', '_', 'B', 'A', 'R', 'R', 'I', 'E', 'R', '\0', /* IN_BARRIER (63738) */
	'T', 'R', 'A', 'P', '\0', /* TRAP (63749) */
	'T', 'T', 'R', 'A', 'C', 'E', '_', 'S', 'I', 'M', 'D', '_', 'E', 'N', '\0', /* TTRACE_SIMD_EN (63754, 63761) */
	'E', 'C', 'C', '_', 'E', 'R', 'R', '\0', /* ECC_ERR (63769) */
	'S', 'K', 'I', 'P', '_', 'E', 'X', 'P', 'O', 'R', 'T', '\0', /* SKIP_EXPORT (63777) */
	'P', 'E', 'R', 'F', '_', 'E', 'N', '\0', /* PERF_EN (63789) */
	'F', 'A', 'T', 'A', 'L', '_', 'H', 'A', 'L', 'T', '\0', /* FATAL_HALT (63797) */
	'M', 'U', 'S', 'T', '_', 'E', 'X', 'P', 'O', 'R', 'T', '\0', /* MUST_EXPORT (63808) */
	'E', 'X', 'C', 'P', '\0', /* EXCP (63820) */
	'S', 'A', 'V', 'E', 'C', 'T', 'X', '\0', /* SAVECTX (63825) */
	'I', 'L', 'L', 'E', 'G', 'A', 'L', '_', 'I', 'N', 'S', 'T', '\0', /* ILLEGAL_INST (63833) */
	'E', 'X', 'C', 'P', '_', 'H', 'I', '\0', /* EXCP_HI (63846) */
	'B', 'U', 'F', 'F', 'E', 'R', '_', 'O', 'O', 'B', '\0', /* BUFFER_OOB (63854) */
	'E', 'X', 'C', 'P', '_', 'C', 'Y', 'C', 'L', 'E', '\0', /* EXCP_CYCLE (63865) */
	'E', 'X', 'C', 'P', '_', 'G', 'R', 'O', 'U', 'P', '_', 'M', 'A', 'S', 'K', '\0', /* EXCP_GROUP_MASK (63876) */
	'E', 'X', 'C', 'P', '_', 'W', 'A', 'V', 'E', '6', '4', 'H', 'I', '\0', /* EXCP_WAVE64HI (63892, 63897) */
	'X', 'N', 'A', 'C', 'K', '_', 'E', 'R', 'R', 'O', 'R', '\0', /* XNACK_ERROR (63906) */
	'D', 'P', '_', 'R', 'A', 'T', 'E', '\0', /* DP_RATE (63918) */
	'S', 'I', 'M', 'D', '_', 'I', 'D', '\0', /* SIMD_ID (63926) */
	'P', 'I', 'P', 'E', '_', 'I', 'D', '\0', /* PIPE_ID (63934) */
	'C', 'U', '_', 'I', 'D', '\0', /* CU_ID (63942) */
	'S', 'H', '_', 'I', 'D', '\0', /* SH_ID (63948) */
	'W', 'A', 'V', 'E', '_', 'I', 'D', '_', 'M', 'S', 'B', '\0', /* WAVE_ID_MSB (63954) */
	'T', 'G', '_', 'I', 'D', '\0', /* TG_ID (63966) */
	'V', 'M', '_', 'I', 'D', '\0', /* VM_ID (63972) */
	'Q', 'U', 'E', 'U', 'E', '_', 'I', 'D', '\0', /* QUEUE_ID (63978) */
	'S', 'T', 'A', 'T', 'E', '_', 'I', 'D', '\0', /* STATE_ID (63987) */
	'M', 'E', '_', 'I', 'D', '\0', /* ME_ID (63996) */
	'V', 'G', 'P', 'R', '_', 'B', 'A', 'S', 'E', '\0', /* VGPR_BASE (64002) */
	'V', 'G', 'P', 'R', '_', 'S', 'I', 'Z', 'E', '\0', /* VGPR_SIZE (64012) */
	'S', 'G', 'P', 'R', '_', 'B', 'A', 'S', 'E', '\0', /* SGPR_BASE (64022) */
	'S', 'G', 'P', 'R', '_', 'S', 'I', 'Z', 'E', '\0', /* SGPR_SIZE (64032) */
	'L', 'D', 'S', '_', 'B', 'A', 'S', 'E', '\0', /* LDS_BASE (64042) */
	'L', 'D', 'S', '_', 'S', 'I', 'Z', 'E', '\0', /* LDS_SIZE (64051) */
	'V', 'G', 'P', 'R', '_', 'S', 'H', 'A', 'R', 'E', 'D', '_', 'S', 'I', 'Z', 'E', '\0', /* VGPR_SHARED_SIZE (64060) */
	'V', 'M', '_', 'C', 'N', 'T', '\0', /* VM_CNT (64077) */
	'E', 'X', 'P', '_', 'C', 'N', 'T', '\0', /* EXP_CNT (64084) */
	'L', 'G', 'K', 'M', '_', 'C', 'N', 'T', '_', 'B', 'I', 'T', '4', '\0', /* LGKM_CNT_BIT4 (64092) */
	'L', 'G', 'K', 'M', '_', 'C', 'N', 'T', '\0', /* LGKM_CNT (64106, 64108) */
	'V', 'A', 'L', 'U', '_', 'C', 'N', 'T', '\0', /* VALU_CNT (64115) */
	'F', 'I', 'R', 'S', 'T', '_', 'R', 'E', 'P', 'L', 'A', 'Y', '\0', /* FIRST_REPLAY (64124) */
	'R', 'C', 'N', 'T', '\0', /* RCNT (64137) */
	'V', 'M', '_', 'C', 'N', 'T', '_', 'H', 'I', '\0', /* VM_CNT_HI (64142) */
	'L', 'G', 'K', 'M', '_', 'C', 'N', 'T', '_', 'B', 'I', 'T', '5', '\0', /* LGKM_CNT_BIT5 (64152) */
	'R', 'E', 'P', 'L', 'A', 'Y', '_', 'W', '6', '4', 'H', '\0', /* REPLAY_W64H (64166) */
	'V', 'S', '_', 'C', 'N', 'T', '\0', /* VS_CNT (64178) */
	'X', 'N', 'A', 'C', 'K', '\0', /* XNACK (64185) */
	'T', 'A', '_', 'N', 'E', 'E', 'D', '_', 'R', 'E', 'S', 'E', 'T', '\0', /* TA_NEED_RESET (64191) */
	'X', 'N', 'A', 'C', 'K', '_', 'O', 'V', 'E', 'R', 'R', 'I', 'D', 'E', '\0', /* XNACK_OVERRIDE (64205) */
	'X', 'C', 'N', 'T', '\0', /* XCNT (64220) */
	'Q', 'C', 'N', 'T', '\0', /* QCNT (64225) */
	'W', 'A', 'V', 'E', '_', 'I', 'D', 'L', 'E', '\0', /* WAVE_IDLE (64230) */
	'M', 'I', 'S', 'C', '_', 'C', 'N', 'T', '\0', /* MISC_CNT (64240) */
	'W', 'G', 'P', '_', 'I', 'D', '\0', /* WGP_ID (64249) */
	'S', 'A', '_', 'I', 'D', '\0', /* SA_ID (64256) */
	'W', 'G', '_', 'I', 'D', '\0', /* WG_ID (64262) */
	'C', 'O', 'M', 'P', 'A', 'T', '_', 'L', 'E', 'V', 'E', 'L', '\0', /* COMPAT_LEVEL (64268) */
	'P', 'O', 'P', 'S', '_', 'E', 'N', '\0', /* POPS_EN (64281, 64283) */
	'P', 'O', 'P', 'S', '_', 'P', 'A', 'C', 'K', 'E', 'R', '_', 'I', 'D', '\0', /* POPS_PACKER_ID (64289) */
	'D', 'E', 'P', '_', 'M', 'O', 'D', 'E', '\0', /* DEP_MODE (64304) */
	'I', 'N', 'S', 'T', '_', 'P', 'R', 'E', 'F', 'E', 'T', 'C', 'H', '\0', /* INST_PREFETCH (64313) */
	'R', 'E', 'S', 'O', 'U', 'R', 'C', 'E', '_', 'O', 'V', 'E', 'R', 'R', 'I', 'D', 'E', '\0', /* RESOURCE_OVERRIDE (64327) */
	'M', 'E', 'M', '_', 'O', 'R', 'D', 'E', 'R', '\0', /* MEM_ORDER (64345) */
	'F', 'W', 'D', '_', 'P', 'R', 'O', 'G', 'R', 'E', 'S', 'S', '\0', /* FWD_PROGRESS (64355) */
	'W', 'A', 'V', 'E', '6', '4', '\0', /* WAVE64 (64368) */
	'S', 'U', 'B', 'V', '_', 'L', 'O', 'O', 'P', '\0', /* SUBV_LOOP (64375) */
	'M', 'E', '0', 'P', 'I', 'P', 'E', '1', '_', 'C', 'M', 'D', 'F', 'I', 'F', 'O', '_', 'A', 'V', 'A', 'I', 'L', '\0', /* ME0PIPE1_CMDFIFO_AVAIL (64385) */
	'M', 'E', '0', 'P', 'I', 'P', 'E', '1', '_', 'C', 'F', '_', 'R', 'Q', '_', 'P', 'E', 'N', 'D', 'I', 'N', 'G', '\0', /* ME0PIPE1_CF_RQ_PENDING (64408) */
	'M', 'E', '0', 'P', 'I', 'P', 'E', '1', '_', 'P', 'F', '_', 'R', 'Q', '_', 'P', 'E', 'N', 'D', 'I', 'N', 'G', '\0', /* ME0PIPE1_PF_RQ_PENDING (64431) */
	'M', 'E', '1', 'P', 'I', 'P', 'E', '0', '_', 'R', 'Q', '_', 'P', 'E', 'N', 'D', 'I', 'N', 'G', '\0', /* ME1PIPE0_RQ_PENDING (64454) */
	'M', 'E', '1', 'P', 'I', 'P', 'E', '1', '_', 'R', 'Q', '_', 'P', 'E', 'N', 'D', 'I', 'N', 'G', '\0', /* ME1PIPE1_RQ_PENDING (64474) */
	'M', 'E', '1', 'P', 'I', 'P', 'E', '2', '_', 'R', 'Q', '_', 'P', 'E', 'N', 'D', 'I', 'N', 'G', '\0', /* ME1PIPE2_RQ_PENDING (64494) */
	'M', 'E', '1', 'P', 'I', 'P', 'E', '3', '_', 'R', 'Q', '_', 'P', 'E', 'N', 'D', 'I', 'N', 'G', '\0', /* ME1PIPE3_RQ_PENDING (64514) */
	'M', 'E', '2', 'P', 'I', 'P', 'E', '0', '_', 'R', 'Q', '_', 'P', 'E', 'N', 'D', 'I', 'N', 'G', '\0', /* ME2PIPE0_RQ_PENDING (64534) */
	'M', 'E', '2', 'P', 'I', 'P', 'E', '1', '_', 'R', 'Q', '_', 'P', 'E', 'N', 'D', 'I', 'N', 'G', '\0', /* ME2PIPE1_RQ_PENDING (64554) */
	'M', 'E', '2', 'P', 'I', 'P', 'E', '2', '_', 'R', 'Q', '_', 'P', 'E', 'N', 'D', 'I', 'N', 'G', '\0', /* ME2PIPE2_RQ_PENDING (64574) */
	'M', 'E', '2', 'P', 'I', 'P', 'E', '3', '_', 'R', 'Q', '_', 'P', 'E', 'N', 'D', 'I', 'N', 'G', '\0', /* ME2PIPE3_RQ_PENDING (64594) */
	'R', 'L', 'C', '_', 'R', 'Q', '_', 'P', 'E', 'N', 'D', 'I', 'N', 'G', '\0', /* RLC_RQ_PENDING (64614) */
	'U', 'T', 'C', 'L', '2', '_', 'B', 'U', 'S', 'Y', '\0', /* UTCL2_BUSY (64629, 64635) */
	'E', 'A', '_', 'B', 'U', 'S', 'Y', '\0', /* EA_BUSY (64640) */
	'R', 'M', 'I', '_', 'B', 'U', 'S', 'Y', '\0', /* RMI_BUSY (64648) */
	'U', 'T', 'C', 'L', '2', '_', 'R', 'Q', '_', 'P', 'E', 'N', 'D', 'I', 'N', 'G', '\0', /* UTCL2_RQ_PENDING (64657) */
	'C', 'P', 'F', '_', 'R', 'Q', '_', 'P', 'E', 'N', 'D', 'I', 'N', 'G', '\0', /* CPF_RQ_PENDING (64674) */
	'E', 'A', '_', 'L', 'I', 'N', 'K', '_', 'B', 'U', 'S', 'Y', '\0', /* EA_LINK_BUSY (64689) */
	'S', 'D', 'M', 'A', '_', 'B', 'U', 'S', 'Y', '\0', /* SDMA_BUSY (64702, 64703) */
	'S', 'D', 'M', 'A', '0', '_', 'R', 'Q', '_', 'P', 'E', 'N', 'D', 'I', 'N', 'G', '\0', /* SDMA0_RQ_PENDING (64712) */
	'S', 'D', 'M', 'A', '1', '_', 'R', 'Q', '_', 'P', 'E', 'N', 'D', 'I', 'N', 'G', '\0', /* SDMA1_RQ_PENDING (64729) */
	'R', 'L', 'C', '_', 'B', 'U', 'S', 'Y', '\0', /* RLC_BUSY (64746) */
	'T', 'C', 'P', '_', 'B', 'U', 'S', 'Y', '\0', /* TCP_BUSY (64755, 64756) */
	'C', 'P', 'F', '_', 'B', 'U', 'S', 'Y', '\0', /* CPF_BUSY (64764) */
	'C', 'P', 'C', '_', 'B', 'U', 'S', 'Y', '\0', /* CPC_BUSY (64773, 64774) */
	'C', 'P', 'G', '_', 'B', 'U', 'S', 'Y', '\0', /* CPG_BUSY (64782) */
	'C', 'P', 'A', 'X', 'I', '_', 'B', 'U', 'S', 'Y', '\0', /* CPAXI_BUSY (64791) */
	'M', 'E', '0', 'P', 'I', 'P', 'E', '0', '_', 'C', 'M', 'D', 'F', 'I', 'F', 'O', '_', 'A', 'V', 'A', 'I', 'L', '\0', /* ME0PIPE0_CMDFIFO_AVAIL (64802) */
	'R', 'S', 'M', 'U', '_', 'R', 'Q', '_', 'P', 'E', 'N', 'D', 'I', 'N', 'G', '\0', /* RSMU_RQ_PENDING (64825, 64826) */
	'M', 'E', '0', 'P', 'I', 'P', 'E', '0', '_', 'C', 'F', '_', 'R', 'Q', '_', 'P', 'E', 'N', 'D', 'I', 'N', 'G', '\0', /* ME0PIPE0_CF_RQ_PENDING (64841) */
	'M', 'E', '0', 'P', 'I', 'P', 'E', '0', '_', 'P', 'F', '_', 'R', 'Q', '_', 'P', 'E', 'N', 'D', 'I', 'N', 'G', '\0', /* ME0PIPE0_PF_RQ_PENDING (64864) */
	'G', 'D', 'S', '_', 'D', 'M', 'A', '_', 'R', 'Q', '_', 'P', 'E', 'N', 'D', 'I', 'N', 'G', '\0', /* GDS_DMA_RQ_PENDING (64887) */
	'D', 'B', '_', 'C', 'L', 'E', 'A', 'N', '\0', /* DB_CLEAN (64906) */
	'C', 'B', '_', 'C', 'L', 'E', 'A', 'N', '\0', /* CB_CLEAN (64915) */
	'T', 'A', '_', 'B', 'U', 'S', 'Y', '\0', /* TA_BUSY (64924) */
	'G', 'D', 'S', '_', 'B', 'U', 'S', 'Y', '\0', /* GDS_BUSY (64932) */
	'G', 'E', '_', 'B', 'U', 'S', 'Y', '_', 'N', 'O', '_', 'D', 'M', 'A', '\0', /* GE_BUSY_NO_DMA (64941) */
	'S', 'X', '_', 'B', 'U', 'S', 'Y', '\0', /* SX_BUSY (64956) */
	'G', 'E', '_', 'B', 'U', 'S', 'Y', '\0', /* GE_BUSY (64964) */
	'S', 'P', 'I', '_', 'B', 'U', 'S', 'Y', '\0', /* SPI_BUSY (64972) */
	'B', 'C', 'I', '_', 'B', 'U', 'S', 'Y', '\0', /* BCI_BUSY (64981) */
	'S', 'C', '_', 'B', 'U', 'S', 'Y', '\0', /* SC_BUSY (64990) */
	'P', 'A', '_', 'B', 'U', 'S', 'Y', '\0', /* PA_BUSY (64998) */
	'D', 'B', '_', 'B', 'U', 'S', 'Y', '\0', /* DB_BUSY (65006) */
	'C', 'P', '_', 'C', 'O', 'H', 'E', 'R', 'E', 'N', 'C', 'Y', '_', 'B', 'U', 'S', 'Y', '\0', /* CP_COHERENCY_BUSY (65014) */
	'C', 'B', '_', 'B', 'U', 'S', 'Y', '\0', /* CB_BUSY (65032) */
	'G', 'U', 'I', '_', 'A', 'C', 'T', 'I', 'V', 'E', '\0', /* GUI_ACTIVE (65040) */
	'U', 'T', 'C', 'L', '1', '_', 'B', 'U', 'S', 'Y', '\0', /* UTCL1_BUSY (65051) */
	'G', 'L', '1', 'C', 'C', '_', 'B', 'U', 'S', 'Y', '\0', /* GL1CC_BUSY (65062) */
	'G', 'R', 'B', 'M', '_', 'R', 'L', 'C', '_', 'I', 'N', 'T', 'R', '_', 'C', 'R', 'E', 'D', 'I', 'T', '_', 'P', 'E', 'N', 'D', 'I', 'N', 'G', '\0', /* GRBM_RLC_INTR_CREDIT_PENDING (65073) */
	'G', 'R', 'B', 'M', '_', 'U', 'T', 'C', 'L', '2', '_', 'I', 'N', 'T', 'R', '_', 'C', 'R', 'E', 'D', 'I', 'T', '_', 'P', 'E', 'N', 'D', 'I', 'N', 'G', '\0', /* GRBM_UTCL2_INTR_CREDIT_PENDING (65102) */
	'G', 'R', 'B', 'M', '_', 'C', 'P', 'F', '_', 'I', 'N', 'T', 'R', '_', 'C', 'R', 'E', 'D', 'I', 'T', '_', 'P', 'E', 'N', 'D', 'I', 'N', 'G', '\0', /* GRBM_CPF_INTR_CREDIT_PENDING (65133) */
	'M', 'E', 'S', 'P', 'I', 'P', 'E', '0', '_', 'R', 'Q', '_', 'P', 'E', 'N', 'D', 'I', 'N', 'G', '\0', /* MESPIPE0_RQ_PENDING (65162) */
	'M', 'E', 'S', 'P', 'I', 'P', 'E', '1', '_', 'R', 'Q', '_', 'P', 'E', 'N', 'D', 'I', 'N', 'G', '\0', /* MESPIPE1_RQ_PENDING (65182) */
	'M', 'E', 'S', 'P', 'I', 'P', 'E', '2', '_', 'R', 'Q', '_', 'P', 'E', 'N', 'D', 'I', 'N', 'G', '\0', /* MESPIPE2_RQ_PENDING (65202) */
	'M', 'E', 'S', 'P', 'I', 'P', 'E', '3', '_', 'R', 'Q', '_', 'P', 'E', 'N', 'D', 'I', 'N', 'G', '\0', /* MESPIPE3_RQ_PENDING (65222) */
	'P', 'H', '_', 'B', 'U', 'S', 'Y', '\0', /* PH_BUSY (65242) */
	'C', 'H', '_', 'B', 'U', 'S', 'Y', '\0', /* CH_BUSY (65250) */
	'G', 'L', '2', 'C', 'C', '_', 'B', 'U', 'S', 'Y', '\0', /* GL2CC_BUSY (65258) */
	'G', 'U', 'S', '_', 'L', 'I', 'N', 'K', '_', 'B', 'U', 'S', 'Y', '\0', /* GUS_LINK_BUSY (65269) */
	'G', 'U', 'S', '_', 'B', 'U', 'S', 'Y', '\0', /* GUS_BUSY (65283) */
	'P', 'M', 'M', '_', 'B', 'U', 'S', 'Y', '\0', /* PMM_BUSY (65292) */
	'M', 'E', 'C', '1', '_', 'B', 'U', 'S', 'Y', '\0', /* MEC1_BUSY (65301) */
	'M', 'E', 'C', '2', '_', 'B', 'U', 'S', 'Y', '\0', /* MEC2_BUSY (65311) */
	'D', 'C', '0', '_', 'B', 'U', 'S', 'Y', '\0', /* DC0_BUSY (65321) */
	'D', 'C', '1', '_', 'B', 'U', 'S', 'Y', '\0', /* DC1_BUSY (65330) */
	'R', 'C', 'I', 'U', '1', '_', 'B', 'U', 'S', 'Y', '\0', /* RCIU1_BUSY (65339) */
	'R', 'C', 'I', 'U', '2', '_', 'B', 'U', 'S', 'Y', '\0', /* RCIU2_BUSY (65350) */
	'R', 'O', 'Q', '1', '_', 'B', 'U', 'S', 'Y', '\0', /* ROQ1_BUSY (65361) */
	'R', 'O', 'Q', '2', '_', 'B', 'U', 'S', 'Y', '\0', /* ROQ2_BUSY (65371) */
	'T', 'C', 'I', 'U', '_', 'B', 'U', 'S', 'Y', '\0', /* TCIU_BUSY (65381) */
	'S', 'C', 'R', 'A', 'T', 'C', 'H', '_', 'R', 'A', 'M', '_', 'B', 'U', 'S', 'Y', '\0', /* SCRATCH_RAM_BUSY (65391) */
	'Q', 'U', '_', 'B', 'U', 'S', 'Y', '\0', /* QU_BUSY (65408) */
	'U', 'T', 'C', 'L', '2', 'I', 'U', '_', 'B', 'U', 'S', 'Y', '\0', /* UTCL2IU_BUSY (65416) */
	'S', 'A', 'V', 'E', '_', 'R', 'E', 'S', 'T', 'O', 'R', 'E', '_', 'B', 'U', 'S', 'Y', '\0', /* SAVE_RESTORE_BUSY (65429) */
	'G', 'C', 'R', 'I', 'U', '_', 'B', 'U', 'S', 'Y', '\0', /* GCRIU_BUSY (65447) */
	'M', 'E', 'S', '_', 'B', 'U', 'S', 'Y', '\0', /* MES_BUSY (65458) */
	'M', 'E', 'S', '_', 'S', 'C', 'R', 'A', 'T', 'C', 'H', '_', 'R', 'A', 'M', '_', 'B', 'U', 'S', 'Y', '\0', /* MES_SCRATCH_RAM_BUSY (65467) */
	'R', 'C', 'I', 'U', '3', '_', 'B', 'U', 'S', 'Y', '\0', /* RCIU3_BUSY (65488) */
	'M', 'E', 'S', '_', 'I', 'N', 'S', 'T', 'R', 'U', 'C', 'T', 'I', 'O', 'N', '_', 'C', 'A', 'C', 'H', 'E', '_', 'B', 'U', 'S', 'Y', '\0', /* MES_INSTRUCTION_CACHE_BUSY (65499) */
	'C', 'P', 'G', '_', 'C', 'P', 'C', '_', 'B', 'U', 'S', 'Y', '\0', /* CPG_CPC_BUSY (65526) */
	'C', 'P', 'F', '_', 'C', 'P', 'C', '_', 'B', 'U', 'S', 'Y', '\0', /* CPF_CPC_BUSY (65539) */
	'M', 'E', 'C', '1', '_', 'L', 'O', 'A', 'D', '_', 'B', 'U', 'S', 'Y', '\0', /* MEC1_LOAD_BUSY (65552) */
	'M', 'E', 'C', '1', '_', 'S', 'E', 'M', 'A', 'P', 'O', 'H', 'R', 'E', '_', 'B', 'U', 'S', 'Y', '\0', /* MEC1_SEMAPOHRE_BUSY (65567) */
	'M', 'E', 'C', '1', '_', 'M', 'U', 'T', 'E', 'X', '_', 'B', 'U', 'S', 'Y', '\0', /* MEC1_MUTEX_BUSY (65587) */
	'M', 'E', 'C', '1', '_', 'M', 'E', 'S', 'S', 'A', 'G', 'E', '_', 'B', 'U', 'S', 'Y', '\0', /* MEC1_MESSAGE_BUSY (65603) */
	'M', 'E', 'C', '1', '_', 'E', 'O', 'P', '_', 'Q', 'U', 'E', 'U', 'E', '_', 'B', 'U', 'S', 'Y', '\0', /* MEC1_EOP_QUEUE_BUSY (65621) */
	'M', 'E', 'C', '1', '_', 'I', 'Q', '_', 'Q', 'U', 'E', 'U', 'E', '_', 'B', 'U', 'S', 'Y', '\0', /* MEC1_IQ_QUEUE_BUSY (65641) */
	'M', 'E', 'C', '1', '_', 'I', 'B', '_', 'Q', 'U', 'E', 'U', 'E', '_', 'B', 'U', 'S', 'Y', '\0', /* MEC1_IB_QUEUE_BUSY (65660) */
	'M', 'E', 'C', '1', '_', 'T', 'C', '_', 'B', 'U', 'S', 'Y', '\0', /* MEC1_TC_BUSY (65679, 65684) */
	'M', 'E', 'C', '1', '_', 'D', 'M', 'A', '_', 'B', 'U', 'S', 'Y', '\0', /* MEC1_DMA_BUSY (65692) */
	'M', 'E', 'C', '1', '_', 'P', 'A', 'R', 'T', 'I', 'A', 'L', '_', 'F', 'L', 'U', 'S', 'H', '_', 'B', 'U', 'S', 'Y', '\0', /* MEC1_PARTIAL_FLUSH_BUSY (65706) */
	'M', 'E', 'C', '1', '_', 'P', 'I', 'P', 'E', '0', '_', 'B', 'U', 'S', 'Y', '\0', /* MEC1_PIPE0_BUSY (65730) */
	'M', 'E', 'C', '1', '_', 'P', 'I', 'P', 'E', '1', '_', 'B', 'U', 'S', 'Y', '\0', /* MEC1_PIPE1_BUSY (65746) */
	'M', 'E', 'C', '1', '_', 'P', 'I', 'P', 'E', '2', '_', 'B', 'U', 'S', 'Y', '\0', /* MEC1_PIPE2_BUSY (65762) */
	'M', 'E', 'C', '1', '_', 'P', 'I', 'P', 'E', '3', '_', 'B', 'U', 'S', 'Y', '\0', /* MEC1_PIPE3_BUSY (65778) */
	'M', 'E', 'C', '2', '_', 'L', 'O', 'A', 'D', '_', 'B', 'U', 'S', 'Y', '\0', /* MEC2_LOAD_BUSY (65794) */
	'M', 'E', 'C', '2', '_', 'S', 'E', 'M', 'A', 'P', 'O', 'H', 'R', 'E', '_', 'B', 'U', 'S', 'Y', '\0', /* MEC2_SEMAPOHRE_BUSY (65809) */
	'M', 'E', 'C', '2', '_', 'M', 'U', 'T', 'E', 'X', '_', 'B', 'U', 'S', 'Y', '\0', /* MEC2_MUTEX_BUSY (65829) */
	'M', 'E', 'C', '2', '_', 'M', 'E', 'S', 'S', 'A', 'G', 'E', '_', 'B', 'U', 'S', 'Y', '\0', /* MEC2_MESSAGE_BUSY (65845) */
	'M', 'E', 'C', '2', '_', 'E', 'O', 'P', '_', 'Q', 'U', 'E', 'U', 'E', '_', 'B', 'U', 'S', 'Y', '\0', /* MEC2_EOP_QUEUE_BUSY (65863) */
	'M', 'E', 'C', '2', '_', 'I', 'Q', '_', 'Q', 'U', 'E', 'U', 'E', '_', 'B', 'U', 'S', 'Y', '\0', /* MEC2_IQ_QUEUE_BUSY (65883) */
	'M', 'E', 'C', '2', '_', 'I', 'B', '_', 'Q', 'U', 'E', 'U', 'E', '_', 'B', 'U', 'S', 'Y', '\0', /* MEC2_IB_QUEUE_BUSY (65902) */
	'M', 'E', 'C', '2', '_', 'T', 'C', '_', 'B', 'U', 'S', 'Y', '\0', /* MEC2_TC_BUSY (65921) */
	'M', 'E', 'C', '2', '_', 'D', 'M', 'A', '_', 'B', 'U', 'S', 'Y', '\0', /* MEC2_DMA_BUSY (65934) */
	'M', 'E', 'C', '2', '_', 'P', 'A', 'R', 'T', 'I', 'A', 'L', '_', 'F', 'L', 'U', 'S', 'H', '_', 'B', 'U', 'S', 'Y', '\0', /* MEC2_PARTIAL_FLUSH_BUSY (65948) */
	'M', 'E', 'C', '2', '_', 'P', 'I', 'P', 'E', '0', '_', 'B', 'U', 'S', 'Y', '\0', /* MEC2_PIPE0_BUSY (65972) */
	'M', 'E', 'C', '2', '_', 'P', 'I', 'P', 'E', '1', '_', 'B', 'U', 'S', 'Y', '\0', /* MEC2_PIPE1_BUSY (65988) */
	'M', 'E', 'C', '2', '_', 'P', 'I', 'P', 'E', '2', '_', 'B', 'U', 'S', 'Y', '\0', /* MEC2_PIPE2_BUSY (66004) */
	'M', 'E', 'C', '2', '_', 'P', 'I', 'P', 'E', '3', '_', 'B', 'U', 'S', 'Y', '\0', /* MEC2_PIPE3_BUSY (66020) */
	'R', 'C', 'I', 'U', '_', 'T', 'X', '_', 'F', 'R', 'E', 'E', '_', 'S', 'T', 'A', 'L', 'L', '\0', /* RCIU_TX_FREE_STALL (66036) */
	'R', 'C', 'I', 'U', '_', 'P', 'R', 'I', 'V', '_', 'V', 'I', 'O', 'L', 'A', 'T', 'I', 'O', 'N', '\0', /* RCIU_PRIV_VIOLATION (66055) */
	'T', 'C', 'I', 'U', '_', 'T', 'X', '_', 'F', 'R', 'E', 'E', '_', 'S', 'T', 'A', 'L', 'L', '\0', /* TCIU_TX_FREE_STALL (66075) */
	'M', 'E', 'C', '1', '_', 'D', 'E', 'C', 'O', 'D', 'I', 'N', 'G', '_', 'P', 'A', 'C', 'K', 'E', 'T', '\0', /* MEC1_DECODING_PACKET (66094) */
	'M', 'E', 'C', '1', '_', 'W', 'A', 'I', 'T', '_', 'O', 'N', '_', 'R', 'C', 'I', 'U', '\0', /* MEC1_WAIT_ON_RCIU (66115) */
	'M', 'E', 'C', '1', '_', 'W', 'A', 'I', 'T', '_', 'O', 'N', '_', 'R', 'C', 'I', 'U', '_', 'R', 'E', 'A', 'D', '\0', /* MEC1_WAIT_ON_RCIU_READ (66133) */
	'M', 'E', 'C', '1', '_', 'W', 'A', 'I', 'T', '_', 'O', 'N', '_', 'R', 'O', 'Q', '_', 'D', 'A', 'T', 'A', '\0', /* MEC1_WAIT_ON_ROQ_DATA (66156) */
	'M', 'E', 'C', '2', '_', 'D', 'E', 'C', 'O', 'D', 'I', 'N', 'G', '_', 'P', 'A', 'C', 'K', 'E', 'T', '\0', /* MEC2_DECODING_PACKET (66178) */
	'M', 'E', 'C', '2', '_', 'W', 'A', 'I', 'T', '_', 'O', 'N', '_', 'R', 'C', 'I', 'U', '\0', /* MEC2_WAIT_ON_RCIU (66199) */
	'M', 'E', 'C', '2', '_', 'W', 'A', 'I', 'T', '_', 'O', 'N', '_', 'R', 'C', 'I', 'U', '_', 'R', 'E', 'A', 'D', '\0', /* MEC2_WAIT_ON_RCIU_READ (66217) */
	'M', 'E', 'C', '2', '_', 'W', 'A', 'I', 'T', '_', 'O', 'N', '_', 'R', 'O', 'Q', '_', 'D', 'A', 'T', 'A', '\0', /* MEC2_WAIT_ON_ROQ_DATA (66240) */
	'U', 'T', 'C', 'L', '2', 'I', 'U', '_', 'W', 'A', 'I', 'T', 'I', 'N', 'G', '_', 'O', 'N', '_', 'F', 'R', 'E', 'E', '\0', /* UTCL2IU_WAITING_ON_FREE (66262) */
	'U', 'T', 'C', 'L', '2', 'I', 'U', '_', 'W', 'A', 'I', 'T', 'I', 'N', 'G', '_', 'O', 'N', '_', 'T', 'A', 'G', 'S', '\0', /* UTCL2IU_WAITING_ON_TAGS (66286) */
	'U', 'T', 'C', 'L', '1', '_', 'W', 'A', 'I', 'T', 'I', 'N', 'G', '_', 'O', 'N', '_', 'T', 'R', 'A', 'N', 'S', '\0', /* UTCL1_WAITING_ON_TRANS (66310) */
	'G', 'C', 'R', 'I', 'U', '_', 'W', 'A', 'I', 'T', 'I', 'N', 'G', '_', 'O', 'N', '_', 'F', 'R', 'E', 'E', '\0', /* GCRIU_WAITING_ON_FREE (66333) */
	'P', 'O', 'S', 'T', '_', 'W', 'P', 'T', 'R', '_', 'G', 'F', 'X', '_', 'B', 'U', 'S', 'Y', '\0', /* POST_WPTR_GFX_BUSY (66355) */
	'C', 'S', 'F', '_', 'B', 'U', 'S', 'Y', '\0', /* CSF_BUSY (66374) */
	'R', 'O', 'Q', '_', 'A', 'L', 'I', 'G', 'N', '_', 'B', 'U', 'S', 'Y', '\0', /* ROQ_ALIGN_BUSY (66383) */
	'R', 'O', 'Q', '_', 'R', 'I', 'N', 'G', '_', 'B', 'U', 'S', 'Y', '\0', /* ROQ_RING_BUSY (66398) */
	'R', 'O', 'Q', '_', 'I', 'N', 'D', 'I', 'R', 'E', 'C', 'T', '1', '_', 'B', 'U', 'S', 'Y', '\0', /* ROQ_INDIRECT1_BUSY (66412) */
	'R', 'O', 'Q', '_', 'I', 'N', 'D', 'I', 'R', 'E', 'C', 'T', '2', '_', 'B', 'U', 'S', 'Y', '\0', /* ROQ_INDIRECT2_BUSY (66431) */
	'R', 'O', 'Q', '_', 'S', 'T', 'A', 'T', 'E', '_', 'B', 'U', 'S', 'Y', '\0', /* ROQ_STATE_BUSY (66450) */
	'R', 'O', 'Q', '_', 'C', 'E', '_', 'R', 'I', 'N', 'G', '_', 'B', 'U', 'S', 'Y', '\0', /* ROQ_CE_RING_BUSY (66465) */
	'R', 'O', 'Q', '_', 'C', 'E', '_', 'I', 'N', 'D', 'I', 'R', 'E', 'C', 'T', '1', '_', 'B', 'U', 'S', 'Y', '\0', /* ROQ_CE_INDIRECT1_BUSY (66482) */
	'R', 'O', 'Q', '_', 'C', 'E', '_', 'I', 'N', 'D', 'I', 'R', 'E', 'C', 'T', '2', '_', 'B', 'U', 'S', 'Y', '\0', /* ROQ_CE_INDIRECT2_BUSY (66504) */
	'S', 'E', 'M', 'A', 'P', 'H', 'O', 'R', 'E', '_', 'B', 'U', 'S', 'Y', '\0', /* SEMAPHORE_BUSY (66526) */
	'I', 'N', 'T', 'E', 'R', 'R', 'U', 'P', 'T', '_', 'B', 'U', 'S', 'Y', '\0', /* INTERRUPT_BUSY (66541) */
	'H', 'Q', 'D', '_', 'B', 'U', 'S', 'Y', '\0', /* HQD_BUSY (66556) */
	'P', 'R', 'T', '_', 'B', 'U', 'S', 'Y', '\0', /* PRT_BUSY (66565) */
	'R', 'C', 'I', 'U', '_', 'B', 'U', 'S', 'Y', '\0', /* RCIU_BUSY (66574) */
	'R', 'C', 'I', 'U', '_', 'G', 'F', 'X', '_', 'B', 'U', 'S', 'Y', '\0', /* RCIU_GFX_BUSY (66584) */
	'R', 'C', 'I', 'U', '_', 'C', 'M', 'P', '_', 'B', 'U', 'S', 'Y', '\0', /* RCIU_CMP_BUSY (66598) */
	'R', 'O', 'Q', '_', 'D', 'A', 'T', 'A', '_', 'B', 'U', 'S', 'Y', '\0', /* ROQ_DATA_BUSY (66612) */
	'R', 'O', 'Q', '_', 'C', 'E', '_', 'D', 'A', 'T', 'A', '_', 'B', 'U', 'S', 'Y', '\0', /* ROQ_CE_DATA_BUSY (66626) */
	'M', 'E', 'S', '_', 'H', 'Q', 'D', '_', 'B', 'U', 'S', 'Y', '\0', /* MES_HQD_BUSY (66643) */
	'C', 'P', 'F', '_', 'G', 'F', 'X', '_', 'B', 'U', 'S', 'Y', '\0', /* CPF_GFX_BUSY (66656) */
	'C', 'P', 'F', '_', 'C', 'M', 'P', '_', 'B', 'U', 'S', 'Y', '\0', /* CPF_CMP_BUSY (66669) */
	'G', 'R', 'B', 'M', '_', 'C', 'P', 'F', '_', 'S', 'T', 'A', 'T', '_', 'B', 'U', 'S', 'Y', '\0', /* GRBM_CPF_STAT_BUSY (66682) */
	'C', 'P', 'C', '_', 'C', 'P', 'F', '_', 'B', 'U', 'S', 'Y', '\0', /* CPC_CPF_BUSY (66701) */
	'R', 'E', 'G', '_', 'B', 'U', 'S', '_', 'F', 'I', 'F', 'O', '_', 'B', 'U', 'S', 'Y', '\0', /* REG_BUS_FIFO_BUSY (66714) */
	'C', 'S', 'F', '_', 'R', 'I', 'N', 'G', '_', 'B', 'U', 'S', 'Y', '\0', /* CSF_RING_BUSY (66732) */
	'C', 'S', 'F', '_', 'I', 'N', 'D', 'I', 'R', 'E', 'C', 'T', '1', '_', 'B', 'U', 'S', 'Y', '\0', /* CSF_INDIRECT1_BUSY (66746) */
	'C', 'S', 'F', '_', 'I', 'N', 'D', 'I', 'R', 'E', 'C', 'T', '2', '_', 'B', 'U', 'S', 'Y', '\0', /* CSF_INDIRECT2_BUSY (66765) */
	'C', 'S', 'F', '_', 'S', 'T', 'A', 'T', 'E', '_', 'B', 'U', 'S', 'Y', '\0', /* CSF_STATE_BUSY (66784) */
	'C', 'S', 'F', '_', 'C', 'E', '_', 'I', 'N', 'D', 'R', '1', '_', 'B', 'U', 'S', 'Y', '\0', /* CSF_CE_INDR1_BUSY (66799) */
	'C', 'S', 'F', '_', 'C', 'E', '_', 'I', 'N', 'D', 'R', '2', '_', 'B', 'U', 'S', 'Y', '\0', /* CSF_CE_INDR2_BUSY (66817) */
	'C', 'S', 'F', '_', 'A', 'R', 'B', 'I', 'T', 'E', 'R', '_', 'B', 'U', 'S', 'Y', '\0', /* CSF_ARBITER_BUSY (66835) */
	'C', 'S', 'F', '_', 'I', 'N', 'P', 'U', 'T', '_', 'B', 'U', 'S', 'Y', '\0', /* CSF_INPUT_BUSY (66852) */
	'C', 'S', 'F', '_', 'D', 'A', 'T', 'A', '_', 'B', 'U', 'S', 'Y', '\0', /* CSF_DATA_BUSY (66867) */
	'C', 'S', 'F', '_', 'C', 'E', '_', 'D', 'A', 'T', 'A', '_', 'B', 'U', 'S', 'Y', '\0', /* CSF_CE_DATA_BUSY (66881) */
	'H', 'P', 'D', '_', 'P', 'R', 'O', 'C', 'E', 'S', 'S', 'I', 'N', 'G', '_', 'E', 'O', 'P', '_', 'B', 'U', 'S', 'Y', '\0', /* HPD_PROCESSING_EOP_BUSY (66898) */
	'H', 'Q', 'D', '_', 'D', 'I', 'S', 'P', 'A', 'T', 'C', 'H', '_', 'B', 'U', 'S', 'Y', '\0', /* HQD_DISPATCH_BUSY (66922) */
	'H', 'Q', 'D', '_', 'I', 'Q', '_', 'T', 'I', 'M', 'E', 'R', '_', 'B', 'U', 'S', 'Y', '\0', /* HQD_IQ_TIMER_BUSY (66940) */
	'H', 'Q', 'D', '_', 'D', 'M', 'A', '_', 'O', 'F', 'F', 'L', 'O', 'A', 'D', '_', 'B', 'U', 'S', 'Y', '\0', /* HQD_DMA_OFFLOAD_BUSY (66958) */
	'H', 'Q', 'D', '_', 'W', 'A', 'I', 'T', '_', 'S', 'E', 'M', 'A', 'P', 'H', 'O', 'R', 'E', '_', 'B', 'U', 'S', 'Y', '\0', /* HQD_WAIT_SEMAPHORE_BUSY (66979) */
	'H', 'Q', 'D', '_', 'S', 'I', 'G', 'N', 'A', 'L', '_', 'S', 'E', 'M', 'A', 'P', 'H', 'O', 'R', 'E', '_', 'B', 'U', 'S', 'Y', '\0', /* HQD_SIGNAL_SEMAPHORE_BUSY (67003) */
	'H', 'Q', 'D', '_', 'M', 'E', 'S', 'S', 'A', 'G', 'E', '_', 'B', 'U', 'S', 'Y', '\0', /* HQD_MESSAGE_BUSY (67029) */
	'H', 'Q', 'D', '_', 'P', 'Q', '_', 'F', 'E', 'T', 'C', 'H', 'E', 'R', '_', 'B', 'U', 'S', 'Y', '\0', /* HQD_PQ_FETCHER_BUSY (67046) */
	'H', 'Q', 'D', '_', 'I', 'B', '_', 'F', 'E', 'T', 'C', 'H', 'E', 'R', '_', 'B', 'U', 'S', 'Y', '\0', /* HQD_IB_FETCHER_BUSY (67066) */
	'H', 'Q', 'D', '_', 'I', 'Q', '_', 'F', 'E', 'T', 'C', 'H', 'E', 'R', '_', 'B', 'U', 'S', 'Y', '\0', /* HQD_IQ_FETCHER_BUSY (67086) */
	'H', 'Q', 'D', '_', 'E', 'O', 'P', '_', 'F', 'E', 'T', 'C', 'H', 'E', 'R', '_', 'B', 'U', 'S', 'Y', '\0', /* HQD_EOP_FETCHER_BUSY (67106) */
	'H', 'Q', 'D', '_', 'C', 'O', 'N', 'S', 'U', 'M', 'E', 'D', '_', 'R', 'P', 'T', 'R', '_', 'B', 'U', 'S', 'Y', '\0', /* HQD_CONSUMED_RPTR_BUSY (67127) */
	'H', 'Q', 'D', '_', 'F', 'E', 'T', 'C', 'H', 'E', 'R', '_', 'A', 'R', 'B', '_', 'B', 'U', 'S', 'Y', '\0', /* HQD_FETCHER_ARB_BUSY (67150) */
	'H', 'Q', 'D', '_', 'R', 'O', 'Q', '_', 'A', 'L', 'I', 'G', 'N', '_', 'B', 'U', 'S', 'Y', '\0', /* HQD_ROQ_ALIGN_BUSY (67171) */
	'H', 'Q', 'D', '_', 'R', 'O', 'Q', '_', 'E', 'O', 'P', '_', 'B', 'U', 'S', 'Y', '\0', /* HQD_ROQ_EOP_BUSY (67190) */
	'H', 'Q', 'D', '_', 'R', 'O', 'Q', '_', 'I', 'Q', '_', 'B', 'U', 'S', 'Y', '\0', /* HQD_ROQ_IQ_BUSY (67207) */
	'H', 'Q', 'D', '_', 'R', 'O', 'Q', '_', 'P', 'Q', '_', 'B', 'U', 'S', 'Y', '\0', /* HQD_ROQ_PQ_BUSY (67223) */
	'H', 'Q', 'D', '_', 'R', 'O', 'Q', '_', 'I', 'B', '_', 'B', 'U', 'S', 'Y', '\0', /* HQD_ROQ_IB_BUSY (67239) */
	'H', 'Q', 'D', '_', 'W', 'P', 'T', 'R', '_', 'P', 'O', 'L', 'L', '_', 'B', 'U', 'S', 'Y', '\0', /* HQD_WPTR_POLL_BUSY (67255) */
	'H', 'Q', 'D', '_', 'P', 'Q', '_', 'B', 'U', 'S', 'Y', '\0', /* HQD_PQ_BUSY (67274) */
	'H', 'Q', 'D', '_', 'I', 'B', '_', 'B', 'U', 'S', 'Y', '\0', /* HQD_IB_BUSY (67286) */
	'R', 'I', 'N', 'G', '_', 'F', 'E', 'T', 'C', 'H', 'I', 'N', 'G', '_', 'D', 'A', 'T', 'A', '\0', /* RING_FETCHING_DATA (67298) */
	'I', 'N', 'D', 'R', '1', '_', 'F', 'E', 'T', 'C', 'H', 'I', 'N', 'G', '_', 'D', 'A', 'T', 'A', '\0', /* INDR1_FETCHING_DATA (67317) */
	'I', 'N', 'D', 'R', '2', '_', 'F', 'E', 'T', 'C', 'H', 'I', 'N', 'G', '_', 'D', 'A', 'T', 'A', '\0', /* INDR2_FETCHING_DATA (67337) */
	'S', 'T', 'A', 'T', 'E', '_', 'F', 'E', 'T', 'C', 'H', 'I', 'N', 'G', '_', 'D', 'A', 'T', 'A', '\0', /* STATE_FETCHING_DATA (67357) */
	'T', 'C', 'I', 'U', '_', 'W', 'A', 'I', 'T', 'I', 'N', 'G', '_', 'O', 'N', '_', 'F', 'R', 'E', 'E', '\0', /* TCIU_WAITING_ON_FREE (67377) */
	'T', 'C', 'I', 'U', '_', 'W', 'A', 'I', 'T', 'I', 'N', 'G', '_', 'O', 'N', '_', 'T', 'A', 'G', 'S', '\0', /* TCIU_WAITING_ON_TAGS (67398) */
	'G', 'F', 'X', '_', 'U', 'T', 'C', 'L', '1', '_', 'W', 'A', 'I', 'T', 'I', 'N', 'G', '_', 'O', 'N', '_', 'T', 'R', 'A', 'N', 'S', '\0', /* GFX_UTCL1_WAITING_ON_TRANS (67419) */
	'C', 'M', 'P', '_', 'U', 'T', 'C', 'L', '1', '_', 'W', 'A', 'I', 'T', 'I', 'N', 'G', '_', 'O', 'N', '_', 'T', 'R', 'A', 'N', 'S', '\0', /* CMP_UTCL1_WAITING_ON_TRANS (67446) */
	'R', 'C', 'I', 'U', '_', 'W', 'A', 'I', 'T', 'I', 'N', 'G', '_', 'O', 'N', '_', 'F', 'R', 'E', 'E', '\0', /* RCIU_WAITING_ON_FREE (67473) */
	'D', 'A', 'T', 'A', '_', 'F', 'E', 'T', 'C', 'H', 'I', 'N', 'G', '_', 'D', 'A', 'T', 'A', '\0', /* DATA_FETCHING_DATA (67494) */
	'G', 'C', 'R', 'I', 'U', '_', 'W', 'A', 'I', 'T', '_', 'O', 'N', '_', 'F', 'R', 'E', 'E', '\0', /* GCRIU_WAIT_ON_FREE (67513) */
	'M', 'E', 'S', '_', 'L', 'O', 'A', 'D', '_', 'B', 'U', 'S', 'Y', '\0', /* MES_LOAD_BUSY (67532) */
	'M', 'E', 'S', '_', 'M', 'U', 'T', 'E', 'X', '_', 'B', 'U', 'S', 'Y', '\0', /* MES_MUTEX_BUSY (67546) */
	'M', 'E', 'S', '_', 'M', 'E', 'S', 'S', 'A', 'G', 'E', '_', 'B', 'U', 'S', 'Y', '\0', /* MES_MESSAGE_BUSY (67561) */
	'M', 'E', 'S', '_', 'T', 'C', '_', 'B', 'U', 'S', 'Y', '\0', /* MES_TC_BUSY (67578) */
	'M', 'E', 'S', '_', 'D', 'M', 'A', '_', 'B', 'U', 'S', 'Y', '\0', /* MES_DMA_BUSY (67590) */
	'M', 'E', 'S', '_', 'P', 'I', 'P', 'E', '0', '_', 'B', 'U', 'S', 'Y', '\0', /* MES_PIPE0_BUSY (67603) */
	'M', 'E', 'S', '_', 'P', 'I', 'P', 'E', '1', '_', 'B', 'U', 'S', 'Y', '\0', /* MES_PIPE1_BUSY (67618) */
	'M', 'E', 'S', '_', 'P', 'I', 'P', 'E', '2', '_', 'B', 'U', 'S', 'Y', '\0', /* MES_PIPE2_BUSY (67633) */
	'M', 'E', 'S', '_', 'P', 'I', 'P', 'E', '3', '_', 'B', 'U', 'S', 'Y', '\0', /* MES_PIPE3_BUSY (67648) */
	'S', 'C', 'R', 'A', 'T', 'C', 'H', '_', 'I', 'N', 'D', 'E', 'X', '_', '6', '4', 'B', 'I', 'T', '_', 'M', 'O', 'D', 'E', '\0', /* SCRATCH_INDEX_64BIT_MODE (67663) */
	'M', 'E', 'S', '_', 'H', 'Q', 'D', '_', 'D', 'I', 'S', 'P', 'A', 'T', 'C', 'H', '_', 'B', 'U', 'S', 'Y', '\0', /* MES_HQD_DISPATCH_BUSY (67688) */
	'M', 'E', 'S', '_', 'H', 'Q', 'D', '_', 'D', 'M', 'A', '_', 'O', 'F', 'F', 'L', 'O', 'A', 'D', '_', 'B', 'U', 'S', 'Y', '\0', /* MES_HQD_DMA_OFFLOAD_BUSY (67710) */
	'M', 'E', 'S', '_', 'H', 'Q', 'D', '_', 'M', 'E', 'S', 'S', 'A', 'G', 'E', '_', 'B', 'U', 'S', 'Y', '\0', /* MES_HQD_MESSAGE_BUSY (67735) */
	'M', 'E', 'S', '_', 'H', 'Q', 'D', '_', 'P', 'Q', '_', 'F', 'E', 'T', 'C', 'H', 'E', 'R', '_', 'B', 'U', 'S', 'Y', '\0', /* MES_HQD_PQ_FETCHER_BUSY (67756) */
	'M', 'E', 'S', '_', 'H', 'Q', 'D', '_', 'C', 'O', 'N', 'S', 'U', 'M', 'E', 'D', '_', 'R', 'P', 'T', 'R', '_', 'B', 'U', 'S', 'Y', '\0', /* MES_HQD_CONSUMED_RPTR_BUSY (67780) */
	'M', 'E', 'S', '_', 'H', 'Q', 'D', '_', 'F', 'E', 'T', 'C', 'H', 'E', 'R', '_', 'A', 'R', 'B', '_', 'B', 'U', 'S', 'Y', '\0', /* MES_HQD_FETCHER_ARB_BUSY (67807) */
	'M', 'E', 'S', '_', 'H', 'Q', 'D', '_', 'R', 'O', 'Q', '_', 'A', 'L', 'I', 'G', 'N', '_', 'B', 'U', 'S', 'Y', '\0', /* MES_HQD_ROQ_ALIGN_BUSY (67832) */
	'M', 'E', 'S', '_', 'H', 'Q', 'D', '_', 'R', 'O', 'Q', '_', 'P', 'Q', '_', 'B', 'U', 'S', 'Y', '\0', /* MES_HQD_ROQ_PQ_BUSY (67855) */
	'M', 'E', 'S', '_', 'H', 'Q', 'D', '_', 'P', 'Q', '_', 'B', 'U', 'S', 'Y', '\0', /* MES_HQD_PQ_BUSY (67875) */
	'B', 'U', 'F', 'F', 'E', 'R', '_', 'I', 'D', '\0', /* BUFFER_ID (67891) */
	'S', 'I', 'M', 'D', '_', 'S', 'E', 'L', '\0', /* SIMD_SEL (67901) */
	'W', 'G', 'P', '_', 'S', 'E', 'L', '\0', /* WGP_SEL (67910) */
	'S', 'A', '_', 'S', 'E', 'L', '\0', /* SA_SEL (67918) */
	'W', 'T', 'Y', 'P', 'E', '_', 'I', 'N', 'C', 'L', 'U', 'D', 'E', '\0', /* WTYPE_INCLUDE (67925) */
	'T', 'O', 'K', 'E', 'N', '_', 'E', 'X', 'C', 'L', 'U', 'D', 'E', '_', 'V', 'M', 'E', 'M', 'E', 'X', 'E', 'C', '\0', /* TOKEN_EXCLUDE_VMEMEXEC (67939) */
	'T', 'O', 'K', 'E', 'N', '_', 'E', 'X', 'C', 'L', 'U', 'D', 'E', '_', 'A', 'L', 'U', 'E', 'X', 'E', 'C', '\0', /* TOKEN_EXCLUDE_ALUEXEC (67962) */
	'T', 'O', 'K', 'E', 'N', '_', 'E', 'X', 'C', 'L', 'U', 'D', 'E', '_', 'V', 'A', 'L', 'U', 'I', 'N', 'S', 'T', '\0', /* TOKEN_EXCLUDE_VALUINST (67984) */
	'T', 'O', 'K', 'E', 'N', '_', 'E', 'X', 'C', 'L', 'U', 'D', 'E', '_', 'W', 'A', 'V', 'E', 'R', 'D', 'Y', '\0', /* TOKEN_EXCLUDE_WAVERDY (68007) */
	'T', 'O', 'K', 'E', 'N', '_', 'E', 'X', 'C', 'L', 'U', 'D', 'E', '_', 'I', 'M', 'M', 'E', 'D', '1', '\0', /* TOKEN_EXCLUDE_IMMED1 (68029) */
	'T', 'O', 'K', 'E', 'N', '_', 'E', 'X', 'C', 'L', 'U', 'D', 'E', '_', 'I', 'M', 'M', 'E', 'D', 'I', 'A', 'T', 'E', '\0', /* TOKEN_EXCLUDE_IMMEDIATE (68050, 68064) */
	'T', 'O', 'K', 'E', 'N', '_', 'E', 'X', 'C', 'L', 'U', 'D', 'E', '_', 'R', 'E', 'G', '\0', /* TOKEN_EXCLUDE_REG (68074) */
	'T', 'O', 'K', 'E', 'N', '_', 'E', 'X', 'C', 'L', 'U', 'D', 'E', '_', 'E', 'V', 'E', 'N', 'T', '\0', /* TOKEN_EXCLUDE_EVENT (68092) */
	'T', 'O', 'K', 'E', 'N', '_', 'E', 'X', 'C', 'L', 'U', 'D', 'E', '_', 'I', 'N', 'S', 'T', '\0', /* TOKEN_EXCLUDE_INST (68112) */
	'T', 'O', 'K', 'E', 'N', '_', 'E', 'X', 'C', 'L', 'U', 'D', 'E', '_', 'U', 'T', 'I', 'L', 'C', 'T', 'R', '\0', /* TOKEN_EXCLUDE_UTILCTR (68131) */
	'T', 'O', 'K', 'E', 'N', '_', 'E', 'X', 'C', 'L', 'U', 'D', 'E', '_', 'W', 'A', 'V', 'E', 'A', 'L', 'L', 'O', 'C', '\0', /* TOKEN_EXCLUDE_WAVEALLOC (68153) */
	'T', 'O', 'K', 'E', 'N', '_', 'E', 'X', 'C', 'L', 'U', 'D', 'E', '_', 'P', 'E', 'R', 'F', '\0', /* TOKEN_EXCLUDE_PERF (68177) */
	'T', 'O', 'K', 'E', 'N', '_', 'E', 'X', 'C', 'L', 'U', 'D', 'E', '\0', /* TOKEN_EXCLUDE (68196) */
	'R', 'E', 'G', '_', 'I', 'N', 'C', 'L', 'U', 'D', 'E', '_', 'S', 'Q', 'D', 'E', 'C', '\0', /* REG_INCLUDE_SQDEC (68210) */
	'R', 'E', 'G', '_', 'I', 'N', 'C', 'L', 'U', 'D', 'E', '_', 'S', 'H', 'D', 'E', 'C', '\0', /* REG_INCLUDE_SHDEC (68228) */
	'R', 'E', 'G', '_', 'I', 'N', 'C', 'L', 'U', 'D', 'E', '_', 'G', 'F', 'X', 'U', 'D', 'E', 'C', '\0', /* REG_INCLUDE_GFXUDEC (68246) */
	'R', 'E', 'G', '_', 'I', 'N', 'C', 'L', 'U', 'D', 'E', '_', 'C', 'O', 'M', 'P', '\0', /* REG_INCLUDE_COMP (68266) */
	'R', 'E', 'G', '_', 'I', 'N', 'C', 'L', 'U', 'D', 'E', '_', 'C', 'O', 'N', 'T', 'E', 'X', 'T', '\0', /* REG_INCLUDE_CONTEXT (68283) */
	'R', 'E', 'G', '_', 'I', 'N', 'C', 'L', 'U', 'D', 'E', '_', 'C', 'O', 'N', 'F', 'I', 'G', '\0', /* REG_INCLUDE_CONFIG (68303) */
	'R', 'E', 'G', '_', 'I', 'N', 'C', 'L', 'U', 'D', 'E', '_', 'O', 'T', 'H', 'E', 'R', '\0', /* REG_INCLUDE_OTHER (68322) */
	'R', 'E', 'G', '_', 'I', 'N', 'C', 'L', 'U', 'D', 'E', '_', 'R', 'E', 'A', 'D', 'S', '\0', /* REG_INCLUDE_READS (68340) */
	'R', 'E', 'G', '_', 'I', 'N', 'C', 'L', 'U', 'D', 'E', '\0', /* REG_INCLUDE (68358) */
	'I', 'N', 'S', 'T', '_', 'E', 'X', 'C', 'L', 'U', 'D', 'E', '\0', /* INST_EXCLUDE (68370) */
	'R', 'E', 'G', '_', 'D', 'E', 'T', 'A', 'I', 'L', '_', 'A', 'L', 'L', '\0', /* REG_DETAIL_ALL (68383) */
	'A', 'L', 'L', '_', 'V', 'M', 'I', 'D', '\0', /* ALL_VMID (68398) */
	'C', 'H', '_', 'P', 'E', 'R', 'F', '_', 'E', 'N', '\0', /* CH_PERF_EN (68407) */
	'I', 'N', 'T', 'E', 'R', 'R', 'U', 'P', 'T', '_', 'E',