/* Generated by wayland-scanner 1.23.1 */

#ifndef TEARING_CONTROL_V1_CLIENT_PROTOCOL_H
#define TEARING_CONTROL_V1_CLIENT_PROTOCOL_H

#include <stdint.h>
#include <stddef.h>
#include "wayland-client.h"

#ifdef  __cplusplus
extern "C" {
#endif

/**
 * @page page_tearing_control_v1 The tearing_control_v1 protocol
 * @section page_ifaces_tearing_control_v1 Interfaces
 * - @subpage page_iface_wp_tearing_control_manager_v1 - protocol for tearing control
 * - @subpage page_iface_wp_tearing_control_v1 - per-surface tearing control interface
 * @section page_copyright_tearing_control_v1 Copyright
 * <pre>
 *
 * Copyright © 2021 Xaver Hugl
 *
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of this software and associated documentation files (the "Software"),
 * to deal in the Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, sublicense,
 * and/or sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice (including the next
 * paragraph) shall be included in all copies or substantial portions of the
 * Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
 * THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
 * DEALINGS IN THE SOFTWARE.
 * </pre>
 */
struct wl_surface;
struct wp_tearing_control_manager_v1;
struct wp_tearing_control_v1;

#ifndef WP_TEARING_CONTROL_MANAGER_V1_INTERFACE
#define WP_TEARING_CONTROL_MANAGER_V1_INTERFACE
/**
 * @page page_iface_wp_tearing_control_manager_v1 wp_tearing_control_manager_v1
 * @section page_iface_wp_tearing_control_manager_v1_desc Description
 *
 * For some use cases like games or drawing tablets it can make sense to
 * reduce latency by accepting tearing with the use of asynchronous page
 * flips. This global is a factory interface, allowing clients to inform
 * which type of presentation the content of their surfaces is suitable for.
 *
 * Graphics APIs like EGL or Vulkan, that manage the buffer queue and commits
 * of a wl_surface themselves, are likely to be using this extension
 * internally. If a client is using such an API for a wl_surface, it should
 * not directly use this extension on that surface, to avoid raising a
 * tearing_control_exists protocol error.
 *
 * Warning! The protocol described in this file is currently in the testing
 * phase. Backward compatible changes may be added together with the
 * corresponding interface version bump. Backward incompatible changes can
 * only be done by creating a new major version of the extension.
 * @section page_iface_wp_tearing_control_manager_v1_api API
 * See @ref iface_wp_tearing_control_manager_v1.
 */
/**
 * @defgroup iface_wp_tearing_control_manager_v1 The wp_tearing_control_manager_v1 interface
 *
 * For some use cases like games or drawing tablets it can make sense to
 * reduce latency by accepting tearing with the use of asynchronous page
 * flips. This global is a factory interface, allowing clients to inform
 * which type of presentation the content of their surfaces is suitable for.
 *
 * Graphics APIs like EGL or Vulkan, that manage the buffer queue and commits
 * of a wl_surface themselves, are likely to be using this extension
 * internally. If a client is using such an API for a wl_surface, it should
 * not directly use this extension on that surface, to avoid raising a
 * tearing_control_exists protocol error.
 *
 * Warning! The protocol described in this file is currently in the testing
 * phase. Backward compatible changes may be added together with the
 * corresponding interface version bump. Backward incompatible changes can
 * only be done by creating a new major version of the extension.
 */
extern const struct wl_interface wp_tearing_control_manager_v1_interface;
#endif
#ifndef WP_TEARING_CONTROL_V1_INTERFACE
#define WP_TEARING_CONTROL_V1_INTERFACE
/**
 * @page page_iface_wp_tearing_control_v1 wp_tearing_control_v1
 * @section page_iface_wp_tearing_control_v1_desc Description
 *
 * An additional interface to a wl_surface object, which allows the client
 * to hint to the compositor if the content on the surface is suitable for
 * presentation with tearing.
 * The default presentation hint is vsync. See presentation_hint for more
 * details.
 *
 * If the associated wl_surface is destroyed, this object becomes inert and
 * should be destroyed.
 * @section page_iface_wp_tearing_control_v1_api API
 * See @ref iface_wp_tearing_control_v1.
 */
/**
 * @defgroup iface_wp_tearing_control_v1 The wp_tearing_control_v1 interface
 *
 * An additional interface to a wl_surface object, which allows the client
 * to hint to the compositor if the content on the surface is suitable for
 * presentation with tearing.
 * The default presentation hint is vsync. See presentation_hint for more
 * details.
 *
 * If the associated wl_surface is destroyed, this object becomes inert and
 * should be destroyed.
 */
extern const struct wl_interface wp_tearing_control_v1_interface;
#endif

#ifndef WP_TEARING_CONTROL_MANAGER_V1_ERROR_ENUM
#define WP_TEARING_CONTROL_MANAGER_V1_ERROR_ENUM
enum wp_tearing_control_manager_v1_error {
	/**
	 * the surface already has a tearing object associated
	 */
	WP_TEARING_CONTROL_MANAGER_V1_ERROR_TEARING_CONTROL_EXISTS = 0,
};
#endif /* WP_TEARING_CONTROL_MANAGER_V1_ERROR_ENUM */

#define WP_TEARING_CONTROL_MANAGER_V1_DESTROY 0
#define WP_TEARING_CONTROL_MANAGER_V1_GET_TEARING_CONTROL 1


/**
 * @ingroup iface_wp_tearing_control_manager_v1
 */
#define WP_TEARING_CONTROL_MANAGER_V1_DESTROY_SINCE_VERSION 1
/**
 * @ingroup iface_wp_tearing_control_manager_v1
 */
#define WP_TEARING_CONTROL_MANAGER_V1_GET_TEARING_CONTROL_SINCE_VERSION 1

/** @ingroup iface_wp_tearing_control_manager_v1 */
static inline void
wp_tearing_control_manager_v1_set_user_data(struct wp_tearing_control_manager_v1 *wp_tearing_control_manager_v1, void *user_data)
{
	wl_proxy_set_user_data((struct wl_proxy *) wp_tearing_control_manager_v1, user_data);
}

/** @ingroup iface_wp_tearing_control_manager_v1 */
static inline void *
wp_tearing_control_manager_v1_get_user_data(struct wp_tearing_control_manager_v1 *wp_tearing_control_manager_v1)
{
	return wl_proxy_get_user_data((struct wl_proxy *) wp_tearing_control_manager_v1);
}

static inline uint32_t
wp_tearing_control_manager_v1_get_version(struct wp_tearing_control_manager_v1 *wp_tearing_control_manager_v1)
{
	return wl_proxy_get_version((struct wl_proxy *) wp_tearing_control_manager_v1);
}

/**
 * @ingroup iface_wp_tearing_control_manager_v1
 *
 * Destroy this tearing control factory object. Other objects, including
 * wp_tearing_control_v1 objects created by this factory, are not affected
 * by this request.
 */
static inline void
wp_tearing_control_manager_v1_destroy(struct wp_tearing_control_manager_v1 *wp_tearing_control_manager_v1)
{
	wl_proxy_marshal_flags((struct wl_proxy *) wp_tearing_control_manager_v1,
			 WP_TEARING_CONTROL_MANAGER_V1_DESTROY, NULL, wl_proxy_get_version((struct wl_proxy *) wp_tearing_control_manager_v1), WL_MARSHAL_FLAG_DESTROY);
}

/**
 * @ingroup iface_wp_tearing_control_manager_v1
 *
 * Instantiate an interface extension for the given wl_surface to request
 * asynchronous page flips for presentation.
 *
 * If the given wl_surface already has a wp_tearing_control_v1 object
 * associated, the tearing_control_exists protocol error is raised.
 */
static inline struct wp_tearing_control_v1 *
wp_tearing_control_manager_v1_get_tearing_control(struct wp_tearing_control_manager_v1 *wp_tearing_control_manager_v1, struct wl_surface *surface)
{
	struct wl_proxy *id;

	id = wl_proxy_marshal_flags((struct wl_proxy *) wp_tearing_control_manager_v1,
			 WP_TEARING_CONTROL_MANAGER_V1_GET_TEARING_CONTROL, &wp_tearing_control_v1_interface, wl_proxy_get_version((struct wl_proxy *) wp_tearing_control_manager_v1), 0, NULL, surface);

	return (struct wp_tearing_control_v1 *) id;
}

#ifndef WP_TEARING_CONTROL_V1_PRESENTATION_HINT_ENUM
#define WP_TEARING_CONTROL_V1_PRESENTATION_HINT_ENUM
/**
 * @ingroup iface_wp_tearing_control_v1
 * presentation hint values
 *
 * This enum provides information for if submitted frames from the client
 * may be presented with tearing.
 */
enum wp_tearing_control_v1_presentation_hint {
	/**
	 * tearing-free presentation
	 *
	 * The content of this surface is meant to be synchronized to the
	 * vertical blanking period. This should not result in visible
	 * tearing and may result in a delay before a surface commit is
	 * presented.
	 */
	WP_TEARING_CONTROL_V1_PRESENTATION_HINT_VSYNC = 0,
	/**
	 * asynchronous presentation
	 *
	 * The content of this surface is meant to be presented with
	 * minimal latency and tearing is acceptable.
	 */
	WP_TEARING_CONTROL_V1_PRESENTATION_HINT_ASYNC = 1,
};
#endif /* WP_TEARING_CONTROL_V1_PRESENTATION_HINT_ENUM */

#define WP_TEARING_CONTROL_V1_SET_PRESENTATION_HINT 0
#define WP_TEARING_CONTROL_V1_DESTROY 1


/**
 * @ingroup iface_wp_tearing_control_v1
 */
#define WP_TEARING_CONTROL_V1_SET_PRESENTATION_HINT_SINCE_VERSION 1
/**
 * @ingroup iface_wp_tearing_control_v1
 */
#define WP_TEARING_CONTROL_V1_DESTROY_SINCE_VERSION 1

/** @ingroup iface_wp_tearing_control_v1 */
static inline void
wp_tearing_control_v1_set_user_data(struct wp_tearing_control_v1 *wp_tearing_control_v1, void *user_data)
{
	wl_proxy_set_user_data((struct wl_proxy *) wp_tearing_control_v1, user_data);
}

/** @ingroup iface_wp_tearing_control_v1 */
static inline void *
wp_tearing_control_v1_get_user_data(struct wp_tearing_control_v1 *wp_tearing_control_v1)
{
	return wl_proxy_get_user_data((struct wl_proxy *) wp_tearing_control_v1);
}

static inline uint32_t
wp_tearing_control_v1_get_version(struct wp_tearing_control_v1 *wp_tearing_control_v1)
{
	return wl_proxy_get_version((struct wl_proxy *) wp_tearing_control_v1);
}

/**
 * @ingroup iface_wp_tearing_control_v1
 *
 * Set the presentation hint for the associated wl_surface. This state is
 * double-buffered, see wl_surface.commit.
 *
 * The compositor is free to dynamically respect or ignore this hint based
 * on various conditions like hardware capabilities, surface state and
 * user preferences.
 */
static inline void
wp_tearing_control_v1_set_presentation_hint(struct wp_tearing_control_v1 *wp_tearing_control_v1, uint32_t hint)
{
	wl_proxy_marshal_flags((struct wl_proxy *) wp_tearing_control_v1,
			 WP_TEARING_CONTROL_V1_SET_PRESENTATION_HINT, NULL, wl_proxy_get_version((struct wl_proxy *) wp_tearing_control_v1), 0, hint);
}

/**
 * @ingroup iface_wp_tearing_control_v1
 *
 * Destroy this surface tearing object and revert the presentation hint to
 * vsync. The change will be applied on the next wl_surface.commit.
 */
static inline void
wp_tearing_control_v1_destroy(struct wp_tearing_control_v1 *wp_tearing_control_v1)
{
	wl_proxy_marshal_flags((struct wl_proxy *) wp_tearing_control_v1,
			 WP_TEARING_CONTROL_V1_DESTROY, NULL, wl_proxy_get_version((struct wl_proxy *) wp_tearing_control_v1), WL_MARSHAL_FLAG_DESTROY);
}

#ifdef  __cplusplus
}
#endif

#endif
