
/* Copyright © 2021 Intel Corporation
 *
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of this software and associated documentation files (the "Software"),
 * to deal in the Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, sublicense,
 * and/or sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice (including the next
 * paragraph) shall be included in all copies or substantial portions of the
 * Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
 * THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS
 * IN THE SOFTWARE.
 */

/* This file generated from vk_physical_device_properties_gen.py, don"t edit directly. */
#ifndef VK_PROPERTIES_H
#define VK_PROPERTIES_H

#if DETECT_OS_ANDROID
#include "vulkan/vk_android_native_buffer.h"
#endif /* DETECT_OS_ANDROID */

#ifdef __cplusplus
extern "C" {
#endif

struct vk_properties {
   uint32_t apiVersion;
   uint32_t driverVersion;
   uint32_t vendorID;
   uint32_t deviceID;
   VkPhysicalDeviceType deviceType;
   char deviceName[VK_MAX_PHYSICAL_DEVICE_NAME_SIZE];
   uint8_t pipelineCacheUUID[VK_UUID_SIZE];
   uint32_t maxImageDimension1D;
   uint32_t maxImageDimension2D;
   uint32_t maxImageDimension3D;
   uint32_t maxImageDimensionCube;
   uint32_t maxImageArrayLayers;
   uint32_t maxTexelBufferElements;
   uint32_t maxUniformBufferRange;
   uint32_t maxStorageBufferRange;
   uint32_t maxPushConstantsSize;
   uint32_t maxMemoryAllocationCount;
   uint32_t maxSamplerAllocationCount;
   VkDeviceSize bufferImageGranularity;
   VkDeviceSize sparseAddressSpaceSize;
   uint32_t maxBoundDescriptorSets;
   uint32_t maxPerStageDescriptorSamplers;
   uint32_t maxPerStageDescriptorUniformBuffers;
   uint32_t maxPerStageDescriptorStorageBuffers;
   uint32_t maxPerStageDescriptorSampledImages;
   uint32_t maxPerStageDescriptorStorageImages;
   uint32_t maxPerStageDescriptorInputAttachments;
   uint32_t maxPerStageResources;
   uint32_t maxDescriptorSetSamplers;
   uint32_t maxDescriptorSetUniformBuffers;
   uint32_t maxDescriptorSetUniformBuffersDynamic;
   uint32_t maxDescriptorSetStorageBuffers;
   uint32_t maxDescriptorSetStorageBuffersDynamic;
   uint32_t maxDescriptorSetSampledImages;
   uint32_t maxDescriptorSetStorageImages;
   uint32_t maxDescriptorSetInputAttachments;
   uint32_t maxVertexInputAttributes;
   uint32_t maxVertexInputBindings;
   uint32_t maxVertexInputAttributeOffset;
   uint32_t maxVertexInputBindingStride;
   uint32_t maxVertexOutputComponents;
   uint32_t maxTessellationGenerationLevel;
   uint32_t maxTessellationPatchSize;
   uint32_t maxTessellationControlPerVertexInputComponents;
   uint32_t maxTessellationControlPerVertexOutputComponents;
   uint32_t maxTessellationControlPerPatchOutputComponents;
   uint32_t maxTessellationControlTotalOutputComponents;
   uint32_t maxTessellationEvaluationInputComponents;
   uint32_t maxTessellationEvaluationOutputComponents;
   uint32_t maxGeometryShaderInvocations;
   uint32_t maxGeometryInputComponents;
   uint32_t maxGeometryOutputComponents;
   uint32_t maxGeometryOutputVertices;
   uint32_t maxGeometryTotalOutputComponents;
   uint32_t maxFragmentInputComponents;
   uint32_t maxFragmentOutputAttachments;
   uint32_t maxFragmentDualSrcAttachments;
   uint32_t maxFragmentCombinedOutputResources;
   uint32_t maxComputeSharedMemorySize;
   uint32_t maxComputeWorkGroupCount[3];
   uint32_t maxComputeWorkGroupInvocations;
   uint32_t maxComputeWorkGroupSize[3];
   uint32_t subPixelPrecisionBits;
   uint32_t subTexelPrecisionBits;
   uint32_t mipmapPrecisionBits;
   uint32_t maxDrawIndexedIndexValue;
   uint32_t maxDrawIndirectCount;
   float maxSamplerLodBias;
   float maxSamplerAnisotropy;
   uint32_t maxViewports;
   uint32_t maxViewportDimensions[2];
   float viewportBoundsRange[2];
   uint32_t viewportSubPixelBits;
   size_t minMemoryMapAlignment;
   VkDeviceSize minTexelBufferOffsetAlignment;
   VkDeviceSize minUniformBufferOffsetAlignment;
   VkDeviceSize minStorageBufferOffsetAlignment;
   int32_t minTexelOffset;
   uint32_t maxTexelOffset;
   int32_t minTexelGatherOffset;
   uint32_t maxTexelGatherOffset;
   float minInterpolationOffset;
   float maxInterpolationOffset;
   uint32_t subPixelInterpolationOffsetBits;
   uint32_t maxFramebufferWidth;
   uint32_t maxFramebufferHeight;
   uint32_t maxFramebufferLayers;
   VkSampleCountFlags framebufferColorSampleCounts;
   VkSampleCountFlags framebufferDepthSampleCounts;
   VkSampleCountFlags framebufferStencilSampleCounts;
   VkSampleCountFlags framebufferNoAttachmentsSampleCounts;
   uint32_t maxColorAttachments;
   VkSampleCountFlags sampledImageColorSampleCounts;
   VkSampleCountFlags sampledImageIntegerSampleCounts;
   VkSampleCountFlags sampledImageDepthSampleCounts;
   VkSampleCountFlags sampledImageStencilSampleCounts;
   VkSampleCountFlags storageImageSampleCounts;
   uint32_t maxSampleMaskWords;
   VkBool32 timestampComputeAndGraphics;
   float timestampPeriod;
   uint32_t maxClipDistances;
   uint32_t maxCullDistances;
   uint32_t maxCombinedClipAndCullDistances;
   uint32_t discreteQueuePriorities;
   float pointSizeRange[2];
   float lineWidthRange[2];
   float pointSizeGranularity;
   float lineWidthGranularity;
   VkBool32 strictLines;
   VkBool32 standardSampleLocations;
   VkDeviceSize optimalBufferCopyOffsetAlignment;
   VkDeviceSize optimalBufferCopyRowPitchAlignment;
   VkDeviceSize nonCoherentAtomSize;
   VkBool32 sparseResidencyStandard2DBlockShape;
   VkBool32 sparseResidencyStandard2DMultisampleBlockShape;
   VkBool32 sparseResidencyStandard3DBlockShape;
   VkBool32 sparseResidencyAlignedMipSize;
   VkBool32 sparseResidencyNonResidentStrict;
   uint32_t maxGraphicsShaderGroupCount;
   uint32_t maxIndirectSequenceCount;
   uint32_t maxIndirectCommandsTokenCount;
   uint32_t maxIndirectCommandsStreamCount;
   uint32_t maxIndirectCommandsTokenOffset;
   uint32_t maxIndirectCommandsStreamStride;
   uint32_t minSequencesCountBufferOffsetAlignment;
   uint32_t minSequencesIndexBufferOffsetAlignment;
   uint32_t minIndirectCommandsBufferOffsetAlignment;
   uint32_t maxMultiDrawCount;
   uint32_t maxPushDescriptors;
   VkDriverId driverID;
   char driverName[VK_MAX_DRIVER_NAME_SIZE];
   char driverInfo[VK_MAX_DRIVER_INFO_SIZE];
   VkConformanceVersion conformanceVersion;
   uint8_t deviceUUID[VK_UUID_SIZE];
   uint8_t driverUUID[VK_UUID_SIZE];
   uint8_t deviceLUID[VK_LUID_SIZE];
   uint32_t deviceNodeMask;
   VkBool32 deviceLUIDValid;
   uint32_t maxMultiviewViewCount;
   uint32_t maxMultiviewInstanceIndex;
   uint32_t maxDiscardRectangles;
   VkBool32 perViewPositionAllComponents;
   uint32_t subgroupSize;
   VkShaderStageFlags subgroupSupportedStages;
   VkSubgroupFeatureFlags subgroupSupportedOperations;
   VkBool32 subgroupQuadOperationsInAllStages;
   VkPointClippingBehavior pointClippingBehavior;
   VkBool32 protectedNoFault;
   VkBool32 filterMinmaxSingleComponentFormats;
   VkBool32 filterMinmaxImageComponentMapping;
   VkSampleCountFlags sampleLocationSampleCounts;
   VkExtent2D maxSampleLocationGridSize;
   float sampleLocationCoordinateRange[2];
   uint32_t sampleLocationSubPixelBits;
   VkBool32 variableSampleLocations;
   uint32_t advancedBlendMaxColorAttachments;
   VkBool32 advancedBlendIndependentBlend;
   VkBool32 advancedBlendNonPremultipliedSrcColor;
   VkBool32 advancedBlendNonPremultipliedDstColor;
   VkBool32 advancedBlendCorrelatedOverlap;
   VkBool32 advancedBlendAllOperations;
   uint32_t maxInlineUniformBlockSize;
   uint32_t maxPerStageDescriptorInlineUniformBlocks;
   uint32_t maxPerStageDescriptorUpdateAfterBindInlineUniformBlocks;
   uint32_t maxDescriptorSetInlineUniformBlocks;
   uint32_t maxDescriptorSetUpdateAfterBindInlineUniformBlocks;
   uint32_t maxPerSetDescriptors;
   VkDeviceSize maxMemoryAllocationSize;
   VkDeviceSize maxBufferSize;
   VkBool32 earlyFragmentMultisampleCoverageAfterSampleCounting;
   VkBool32 earlyFragmentSampleMaskTestBeforeSampleCounting;
   VkBool32 depthStencilSwizzleOneSupport;
   VkBool32 polygonModePointSize;
   VkBool32 nonStrictSinglePixelWideLinesUseParallelogram;
   VkBool32 nonStrictWideLinesUseParallelogram;
   VkBool32 blockTexelViewCompatibleMultipleLayers;
   uint32_t maxCombinedImageSamplerDescriptorCount;
   VkBool32 fragmentShadingRateClampCombinerInputs;
   VkBool32 robustFragmentShadingRateAttachmentAccess;
   VkBool32 separateDepthStencilAttachmentAccess;
   uint32_t maxDescriptorSetTotalUniformBuffersDynamic;
   uint32_t maxDescriptorSetTotalStorageBuffersDynamic;
   uint32_t maxDescriptorSetTotalBuffersDynamic;
   uint32_t maxDescriptorSetUpdateAfterBindTotalUniformBuffersDynamic;
   uint32_t maxDescriptorSetUpdateAfterBindTotalStorageBuffersDynamic;
   uint32_t maxDescriptorSetUpdateAfterBindTotalBuffersDynamic;
   uint32_t layeredApiCount;
   VkPhysicalDeviceLayeredApiPropertiesKHR* pLayeredApis;
   VkShaderFloatControlsIndependence denormBehaviorIndependence;
   VkShaderFloatControlsIndependence roundingModeIndependence;
   VkBool32 shaderSignedZeroInfNanPreserveFloat16;
   VkBool32 shaderSignedZeroInfNanPreserveFloat32;
   VkBool32 shaderSignedZeroInfNanPreserveFloat64;
   VkBool32 shaderDenormPreserveFloat16;
   VkBool32 shaderDenormPreserveFloat32;
   VkBool32 shaderDenormPreserveFloat64;
   VkBool32 shaderDenormFlushToZeroFloat16;
   VkBool32 shaderDenormFlushToZeroFloat32;
   VkBool32 shaderDenormFlushToZeroFloat64;
   VkBool32 shaderRoundingModeRTEFloat16;
   VkBool32 shaderRoundingModeRTEFloat32;
   VkBool32 shaderRoundingModeRTEFloat64;
   VkBool32 shaderRoundingModeRTZFloat16;
   VkBool32 shaderRoundingModeRTZFloat32;
   VkBool32 shaderRoundingModeRTZFloat64;
#if DETECT_OS_ANDROID
   VkBool32 sharedImage;
#endif /* DETECT_OS_ANDROID */
   VkDeviceSize minImportedHostPointerAlignment;
   float primitiveOverestimationSize;
   float maxExtraPrimitiveOverestimationSize;
   float extraPrimitiveOverestimationSizeGranularity;
   VkBool32 primitiveUnderestimation;
   VkBool32 conservativePointAndLineRasterization;
   VkBool32 degenerateTrianglesRasterized;
   VkBool32 degenerateLinesRasterized;
   VkBool32 fullyCoveredFragmentShaderInputVariable;
   VkBool32 conservativeRasterizationPostDepthCoverage;
   uint32_t shaderEngineCount;
   uint32_t shaderArraysPerEngineCount;
   uint32_t computeUnitsPerShaderArray;
   uint32_t simdPerComputeUnit;
   uint32_t wavefrontsPerSimd;
   uint32_t wavefrontSize;
   uint32_t sgprsPerSimd;
   uint32_t minSgprAllocation;
   uint32_t maxSgprAllocation;
   uint32_t sgprAllocationGranularity;
   uint32_t vgprsPerSimd;
   uint32_t minVgprAllocation;
   uint32_t maxVgprAllocation;
   uint32_t vgprAllocationGranularity;
   VkShaderCorePropertiesFlagsAMD shaderCoreFeatures;
   uint32_t activeComputeUnitCount;
   uint32_t maxUpdateAfterBindDescriptorsInAllPools;
   VkBool32 shaderUniformBufferArrayNonUniformIndexingNative;
   VkBool32 shaderSampledImageArrayNonUniformIndexingNative;
   VkBool32 shaderStorageBufferArrayNonUniformIndexingNative;
   VkBool32 shaderStorageImageArrayNonUniformIndexingNative;
   VkBool32 shaderInputAttachmentArrayNonUniformIndexingNative;
   VkBool32 robustBufferAccessUpdateAfterBind;
   VkBool32 quadDivergentImplicitLod;
   uint32_t maxPerStageDescriptorUpdateAfterBindSamplers;
   uint32_t maxPerStageDescriptorUpdateAfterBindUniformBuffers;
   uint32_t maxPerStageDescriptorUpdateAfterBindStorageBuffers;
   uint32_t maxPerStageDescriptorUpdateAfterBindSampledImages;
   uint32_t maxPerStageDescriptorUpdateAfterBindStorageImages;
   uint32_t maxPerStageDescriptorUpdateAfterBindInputAttachments;
   uint32_t maxPerStageUpdateAfterBindResources;
   uint32_t maxDescriptorSetUpdateAfterBindSamplers;
   uint32_t maxDescriptorSetUpdateAfterBindUniformBuffers;
   uint32_t maxDescriptorSetUpdateAfterBindUniformBuffersDynamic;
   uint32_t maxDescriptorSetUpdateAfterBindStorageBuffers;
   uint32_t maxDescriptorSetUpdateAfterBindStorageBuffersDynamic;
   uint32_t maxDescriptorSetUpdateAfterBindSampledImages;
   uint32_t maxDescriptorSetUpdateAfterBindStorageImages;
   uint32_t maxDescriptorSetUpdateAfterBindInputAttachments;
   uint64_t maxTimelineSemaphoreValueDifference;
   uint32_t maxVertexAttribDivisor;
   VkBool32 supportsNonZeroFirstInstance;
   uint32_t pciDomain;
   uint32_t pciBus;
   uint32_t pciDevice;
   uint32_t pciFunction;
   VkResolveModeFlags supportedDepthResolveModes;
   VkResolveModeFlags supportedStencilResolveModes;
   VkBool32 independentResolveNone;
   VkBool32 independentResolve;
   uint32_t maxTransformFeedbackStreams;
   uint32_t maxTransformFeedbackBuffers;
   VkDeviceSize maxTransformFeedbackBufferSize;
   uint32_t maxTransformFeedbackStreamDataSize;
   uint32_t maxTransformFeedbackBufferDataSize;
   uint32_t maxTransformFeedbackBufferDataStride;
   VkBool32 transformFeedbackQueries;
   VkBool32 transformFeedbackStreamsLinesTriangles;
   VkBool32 transformFeedbackRasterizationStreamSelect;
   VkBool32 transformFeedbackDraw;
   VkBool32 meshAndTaskShaderDerivatives;
   VkQueueFlags supportedQueues;
   VkMemoryDecompressionMethodFlagsNV decompressionMethods;
   uint64_t maxDecompressionIndirectCount;
   VkExtent2D shadingRateTexelSize;
   uint32_t shadingRatePaletteSize;
   uint32_t shadingRateMaxCoarseSamples;
   uint32_t maxDrawMeshTasksCount;
   uint32_t maxTaskWorkGroupInvocations;
   uint32_t maxTaskWorkGroupSize[3];
   uint32_t maxTaskTotalMemorySize;
   uint32_t maxTaskOutputCount;
   uint32_t maxMeshWorkGroupInvocations;
   uint32_t maxMeshWorkGroupSize[3];
   uint32_t maxMeshTotalMemorySize;
   uint32_t maxMeshOutputVertices;
   uint32_t maxMeshOutputPrimitives;
   uint32_t maxMeshMultiviewViewCount;
   uint32_t meshOutputPerVertexGranularity;
   uint32_t meshOutputPerPrimitiveGranularity;
   uint32_t maxTaskWorkGroupTotalCount;
   uint32_t maxTaskWorkGroupCount[3];
   uint32_t maxTaskPayloadSize;
   uint32_t maxTaskSharedMemorySize;
   uint32_t maxTaskPayloadAndSharedMemorySize;
   uint32_t maxMeshWorkGroupTotalCount;
   uint32_t maxMeshWorkGroupCount[3];
   uint32_t maxMeshSharedMemorySize;
   uint32_t maxMeshPayloadAndSharedMemorySize;
   uint32_t maxMeshOutputMemorySize;
   uint32_t maxMeshPayloadAndOutputMemorySize;
   uint32_t maxMeshOutputComponents;
   uint32_t maxMeshOutputLayers;
   uint32_t maxPreferredTaskWorkGroupInvocations;
   uint32_t maxPreferredMeshWorkGroupInvocations;
   VkBool32 prefersLocalInvocationVertexOutput;
   VkBool32 prefersLocalInvocationPrimitiveOutput;
   VkBool32 prefersCompactVertexOutput;
   VkBool32 prefersCompactPrimitiveOutput;
   uint64_t maxGeometryCount;
   uint64_t maxInstanceCount;
   uint64_t maxPrimitiveCount;
   uint32_t maxPerStageDescriptorAccelerationStructures;
   uint32_t maxPerStageDescriptorUpdateAfterBindAccelerationStructures;
   uint32_t maxDescriptorSetAccelerationStructures;
   uint32_t maxDescriptorSetUpdateAfterBindAccelerationStructures;
   uint32_t minAccelerationStructureScratchOffsetAlignment;
   uint32_t shaderGroupHandleSize;
   uint32_t maxRayRecursionDepth;
   uint32_t maxShaderGroupStride;
   uint32_t shaderGroupBaseAlignment;
   uint32_t shaderGroupHandleCaptureReplaySize;
   uint32_t maxRayDispatchInvocationCount;
   uint32_t shaderGroupHandleAlignment;
   uint32_t maxRayHitAttributeSize;
   uint32_t maxRecursionDepth;
   uint64_t maxTriangleCount;
   VkExtent2D minFragmentDensityTexelSize;
   VkExtent2D maxFragmentDensityTexelSize;
   VkBool32 fragmentDensityInvocations;
   VkBool32 subsampledLoads;
   VkBool32 subsampledCoarseReconstructionEarlyAccess;
   uint32_t maxSubsampledArrayLayers;
   uint32_t maxDescriptorSetSubsampledSamplers;
   VkExtent2D fragmentDensityOffsetGranularity;
   VkShaderStageFlags cooperativeMatrixSupportedStages;
   VkBool32 allowCommandBufferQueryCopies;
   uint32_t shaderSMCount;
   uint32_t shaderWarpsPerSM;
   VkDeviceSize storageTexelBufferOffsetAlignmentBytes;
   VkBool32 storageTexelBufferOffsetSingleTexelAlignment;
   VkDeviceSize uniformTexelBufferOffsetAlignmentBytes;
   VkBool32 uniformTexelBufferOffsetSingleTexelAlignment;
   uint32_t minSubgroupSize;
   uint32_t maxSubgroupSize;
   uint32_t maxComputeWorkgroupSubgroups;
   VkShaderStageFlags requiredSubgroupSizeStages;
   uint32_t maxSubpassShadingWorkgroupSizeAspectRatio;
   uint32_t maxWorkGroupCount[3];
   uint32_t maxWorkGroupSize[3];
   uint32_t maxOutputClusterCount;
   VkDeviceSize indirectBufferOffsetAlignment;
   uint32_t lineSubPixelPrecisionBits;
   VkSampleCountFlags framebufferIntegerColorSampleCounts;
   uint32_t maxInlineUniformTotalSize;
   VkBool32 integerDotProduct8BitUnsignedAccelerated;
   VkBool32 integerDotProduct8BitSignedAccelerated;
   VkBool32 integerDotProduct8BitMixedSignednessAccelerated;
   VkBool32 integerDotProduct4x8BitPackedUnsignedAccelerated;
   VkBool32 integerDotProduct4x8BitPackedSignedAccelerated;
   VkBool32 integerDotProduct4x8BitPackedMixedSignednessAccelerated;
   VkBool32 integerDotProduct16BitUnsignedAccelerated;
   VkBool32 integerDotProduct16BitSignedAccelerated;
   VkBool32 integerDotProduct16BitMixedSignednessAccelerated;
   VkBool32 integerDotProduct32BitUnsignedAccelerated;
   VkBool32 integerDotProduct32BitSignedAccelerated;
   VkBool32 integerDotProduct32BitMixedSignednessAccelerated;
   VkBool32 integerDotProduct64BitUnsignedAccelerated;
   VkBool32 integerDotProduct64BitSignedAccelerated;
   VkBool32 integerDotProduct64BitMixedSignednessAccelerated;
   VkBool32 integerDotProductAccumulatingSaturating8BitUnsignedAccelerated;
   VkBool32 integerDotProductAccumulatingSaturating8BitSignedAccelerated;
   VkBool32 integerDotProductAccumulatingSaturating8BitMixedSignednessAccelerated;
   VkBool32 integerDotProductAccumulatingSaturating4x8BitPackedUnsignedAccelerated;
   VkBool32 integerDotProductAccumulatingSaturating4x8BitPackedSignedAccelerated;
   VkBool32 integerDotProductAccumulatingSaturating4x8BitPackedMixedSignednessAccelerated;
   VkBool32 integerDotProductAccumulatingSaturating16BitUnsignedAccelerated;
   VkBool32 integerDotProductAccumulatingSaturating16BitSignedAccelerated;
   VkBool32 integerDotProductAccumulatingSaturating16BitMixedSignednessAccelerated;
   VkBool32 integerDotProductAccumulatingSaturating32BitUnsignedAccelerated;
   VkBool32 integerDotProductAccumulatingSaturating32BitSignedAccelerated;
   VkBool32 integerDotProductAccumulatingSaturating32BitMixedSignednessAccelerated;
   VkBool32 integerDotProductAccumulatingSaturating64BitUnsignedAccelerated;
   VkBool32 integerDotProductAccumulatingSaturating64BitSignedAccelerated;
   VkBool32 integerDotProductAccumulatingSaturating64BitMixedSignednessAccelerated;
   uint32_t maxCustomBorderColorSamplers;
   VkBool32 dynamicPrimitiveTopologyUnrestricted;
   VkDeviceSize robustStorageBufferAccessSizeAlignment;
   VkDeviceSize robustUniformBufferAccessSizeAlignment;
   VkExtent2D minFragmentShadingRateAttachmentTexelSize;
   VkExtent2D maxFragmentShadingRateAttachmentTexelSize;
   uint32_t maxFragmentShadingRateAttachmentTexelSizeAspectRatio;
   VkBool32 primitiveFragmentShadingRateWithMultipleViewports;
   VkBool32 layeredShadingRateAttachments;
   VkBool32 fragmentShadingRateNonTrivialCombinerOps;
   VkExtent2D maxFragmentSize;
   uint32_t maxFragmentSizeAspectRatio;
   uint32_t maxFragmentShadingRateCoverageSamples;
   VkSampleCountFlagBits maxFragmentShadingRateRasterizationSamples;
   VkBool32 fragmentShadingRateWithShaderDepthStencilWrites;
   VkBool32 fragmentShadingRateWithSampleMask;
   VkBool32 fragmentShadingRateWithShaderSampleMask;
   VkBool32 fragmentShadingRateWithConservativeRasterization;
   VkBool32 fragmentShadingRateWithFragmentShaderInterlock;
   VkBool32 fragmentShadingRateWithCustomSampleLocations;
   VkBool32 fragmentShadingRateStrictMultiplyCombiner;
   VkSampleCountFlagBits maxFragmentShadingRateInvocationCount;
   VkBool32 nativeUnalignedPerformance;
   uint32_t maxIndirectPipelineCount;
   uint32_t maxIndirectShaderObjectCount;
   uint32_t maxIndirectCommandsIndirectStride;
   VkIndirectCommandsInputModeFlagsEXT supportedIndirectCommandsInputModes;
   VkShaderStageFlags supportedIndirectCommandsShaderStages;
   VkShaderStageFlags supportedIndirectCommandsShaderStagesPipelineBinding;
   VkShaderStageFlags supportedIndirectCommandsShaderStagesShaderBinding;
   VkBool32 deviceGeneratedCommandsTransformFeedback;
   VkBool32 deviceGeneratedCommandsMultiDrawIndirectCount;
   uint32_t copySrcLayoutCount;
   VkImageLayout* pCopySrcLayouts;
   uint32_t copyDstLayoutCount;
   VkImageLayout* pCopyDstLayouts;
   uint8_t optimalTilingLayoutUUID[VK_UUID_SIZE];
   VkBool32 identicalMemoryTypeRequirements;
   VkBool32 provokingVertexModePerPipeline;
   VkBool32 transformFeedbackPreservesTriangleFanProvokingVertex;
   VkBool32 combinedImageSamplerDescriptorSingleArray;
   VkBool32 bufferlessPushDescriptors;
   VkBool32 allowSamplerImageViewPostSubmitCreation;
   VkDeviceSize descriptorBufferOffsetAlignment;
   uint32_t maxDescriptorBufferBindings;
   uint32_t maxResourceDescriptorBufferBindings;
   uint32_t maxSamplerDescriptorBufferBindings;
   uint32_t maxEmbeddedImmutableSamplerBindings;
   uint32_t maxEmbeddedImmutableSamplers;
   size_t bufferCaptureReplayDescriptorDataSize;
   size_t imageCaptureReplayDescriptorDataSize;
   size_t imageViewCaptureReplayDescriptorDataSize;
   size_t samplerCaptureReplayDescriptorDataSize;
   size_t accelerationStructureCaptureReplayDescriptorDataSize;
   size_t samplerDescriptorSize;
   size_t combinedImageSamplerDescriptorSize;
   size_t sampledImageDescriptorSize;
   size_t storageImageDescriptorSize;
   size_t uniformTexelBufferDescriptorSize;
   size_t robustUniformTexelBufferDescriptorSize;
   size_t storageTexelBufferDescriptorSize;
   size_t robustStorageTexelBufferDescriptorSize;
   size_t uniformBufferDescriptorSize;
   size_t robustUniformBufferDescriptorSize;
   size_t storageBufferDescriptorSize;
   size_t robustStorageBufferDescriptorSize;
   size_t inputAttachmentDescriptorSize;
   size_t accelerationStructureDescriptorSize;
   VkDeviceSize maxSamplerDescriptorBufferRange;
   VkDeviceSize maxResourceDescriptorBufferRange;
   VkDeviceSize samplerDescriptorBufferAddressSpaceSize;
   VkDeviceSize resourceDescriptorBufferAddressSpaceSize;
   VkDeviceSize descriptorBufferAddressSpaceSize;
   size_t combinedImageSamplerDensityMapDescriptorSize;
   VkBool32 drmHasPrimary;
   VkBool32 drmHasRender;
   int64_t drmPrimaryMajor;
   int64_t drmPrimaryMinor;
   int64_t drmRenderMajor;
   int64_t drmRenderMinor;
   VkBool32 triStripVertexOrderIndependentOfProvokingVertex;
   VkBool32 pipelineBinaryInternalCache;
   VkBool32 pipelineBinaryInternalCacheControl;
   VkBool32 pipelineBinaryPrefersInternalCache;
   VkBool32 pipelineBinaryPrecompiledInternalCache;
   VkBool32 pipelineBinaryCompressedData;
   VkBool32 graphicsPipelineLibraryFastLinking;
   VkBool32 graphicsPipelineLibraryIndependentInterpolationDecoration;
   uint32_t maxCommandBufferNestingLevel;
   uint8_t shaderModuleIdentifierAlgorithmUUID[VK_UUID_SIZE];
   uint32_t maxOpacity2StateSubdivisionLevel;
   uint32_t maxOpacity4StateSubdivisionLevel;
   VkPipelineRobustnessBufferBehaviorEXT defaultRobustnessStorageBuffers;
   VkPipelineRobustnessBufferBehaviorEXT defaultRobustnessUniformBuffers;
   VkPipelineRobustnessBufferBehaviorEXT defaultRobustnessVertexInputs;
   VkPipelineRobustnessImageBehaviorEXT defaultRobustnessImages;
   uint32_t maxWeightFilterPhases;
   VkExtent2D maxWeightFilterDimension;
   VkExtent2D maxBlockMatchRegion;
   VkExtent2D maxBoxFilterBlockSize;
   VkOpticalFlowGridSizeFlagsNV supportedOutputGridSizes;
   VkOpticalFlowGridSizeFlagsNV supportedHintGridSizes;
   VkBool32 hintSupported;
   VkBool32 costSupported;
   VkBool32 bidirectionalFlowSupported;
   VkBool32 globalFlowSupported;
   uint32_t minWidth;
   uint32_t minHeight;
   uint32_t maxWidth;
   uint32_t maxHeight;
   uint32_t maxNumRegionsOfInterest;
   uint64_t shaderCoreMask;
   uint32_t shaderCoreCount;
   uint32_t shaderWarpsPerCore;
   VkRayTracingInvocationReorderModeNV rayTracingInvocationReorderReorderingHint;
   VkDeviceSize extendedSparseAddressSpaceSize;
   VkImageUsageFlags extendedSparseImageUsageFlags;
   VkBufferUsageFlags extendedSparseBufferUsageFlags;
   uint32_t pixelRate;
   uint32_t texelRate;
   uint32_t fmaRate;
   uint8_t shaderBinaryUUID[VK_UUID_SIZE];
   uint32_t shaderBinaryVersion;
   VkBool32 shaderTileImageCoherentReadAccelerated;
   VkBool32 shaderTileImageReadSampleFromPixelRateInvocation;
   VkBool32 shaderTileImageReadFromHelperInvocation;
   VkExtent2D maxBlockMatchWindow;
   VkLayeredDriverUnderlyingApiMSFT underlyingAPI;
   VkPhysicalDeviceSchedulingControlsFlagsARM schedulingControlsFlags;
   VkExtent2D renderPassStripeGranularity;
   uint32_t maxRenderPassStripes;
   VkDeviceSize minPlacedMemoryMapAlignment;
   uint32_t supportedImageAlignmentMask;
};

void
vk_set_physical_device_properties_struct(struct vk_properties *all_properties,
                                         const VkBaseInStructure *pProperties);

#ifdef __cplusplus
}
#endif

#endif
