
#include "nir.h"
#include "nir_builder.h"
#include "nir_search.h"
#include "nir_search_helpers.h"

/* What follows is NIR algebraic transform code for the following 2434
 * transforms:
 *    ('fgeu', 'a', 'b') => ('inot', ('flt', 'a', 'b'))
 *    ('fltu', 'a', 'b') => ('inot', ('fge', 'a', 'b'))
 *    ('fneo', 0.0, 'a') => ('flt', 0.0, ('fabs', 'a'))
 *    ('fequ', 0.0, 'a') => ('inot', ('flt', 0.0, ('fabs', 'a')))
 *    ('imul', 'a', '#b(is_pos_power_of_two)') => ('ishl', 'a', ('find_lsb', 'b'))
 *    ('imul', 'a@8', 128) => ('ishl', 'a', 7)
 *    ('imul', 'a@16', 32768) => ('ishl', 'a', 15)
 *    ('imul', 'a@32', 2147483648) => ('ishl', 'a', 31)
 *    ('imul', 'a@64', 9223372036854775808) => ('ishl', 'a', 63)
 *    ('imul', 'a', '#b(is_neg_power_of_two)') => ('ineg', ('ishl', 'a', ('find_lsb', ('iabs', 'b'))))
 *    ('ishl', 'a', '#b') => ('imul', 'a', ('ishl', 1, 'b'))
 *    ('imul@64', 'a', '#b(is_bitcount2)') => ('iadd', ('ishl', 'a', ('ufind_msb', 'b')), ('ishl', 'a', ('find_lsb', 'b')))
 *    ('unpack_64_2x32_split_x', ('imul_2x32_64(is_used_once)', 'a', 'b')) => ('imul', 'a', 'b')
 *    ('unpack_64_2x32_split_x', ('umul_2x32_64(is_used_once)', 'a', 'b')) => ('imul', 'a', 'b')
 *    ('imul_2x32_64', 'a', 'b') => ('pack_64_2x32_split', ('imul', 'a', 'b'), ('imul_high', 'a', 'b'))
 *    ('umul_2x32_64', 'a', 'b') => ('pack_64_2x32_split', ('imul', 'a', 'b'), ('umul_high', 'a', 'b'))
 *    ('udiv', 'a', 1) => a
 *    ('idiv', 'a', 1) => a
 *    ('umod', 'a', 1) => 0
 *    ('imod', 'a', 1) => 0
 *    ('imod', 'a', -1) => 0
 *    ('irem', 'a', 1) => 0
 *    ('irem', 'a', -1) => 0
 *    ('udiv', 'a', '#b(is_pos_power_of_two)') => ('ushr', 'a', ('find_lsb', 'b'))
 *    ('idiv', 'a', '#b(is_pos_power_of_two)') => ('imul', ('isign', 'a'), ('ushr', ('iabs', 'a'), ('find_lsb', 'b')))
 *    ('idiv', 'a', '#b(is_neg_power_of_two)') => ('ineg', ('imul', ('isign', 'a'), ('ushr', ('iabs', 'a'), ('find_lsb', ('iabs', 'b')))))
 *    ('umod', 'a', '#b(is_pos_power_of_two)') => ('iand', 'a', ('isub', 'b', 1))
 *    ('imod', 'a', '#b(is_pos_power_of_two)') => ('iand', 'a', ('isub', 'b', 1))
 *    ('imod', 'a', '#b(is_neg_power_of_two)') => ('bcsel', ('ieq', ('ior', 'a', 'b'), 'b'), 0, ('ior', 'a', 'b'))
 *    ('irem', 'a', '#b(is_pos_power_of_two)') => ('isub', 'a', ('iand', ('bcsel', ('ilt', 'a', 0), ('iadd', 'a', ('isub', 'b', 1)), 'a'), ('ineg', 'b')))
 *    ('irem', 'a', '#b(is_neg_power_of_two)') => ('irem', 'a', ('iabs', 'b'))
 *    ('~fmul', ('fsign', 'a'), ('ffloor', ('fadd', ('fabs', 'a'), 0.5))) => ('ftrunc', ('fadd', 'a', ('fmul', ('fsign', 'a'), 0.5)))
 *    ('~fneg', ('fneg', 'a')) => a
 *    ('ineg', ('ineg', 'a')) => a
 *    ('fabs', ('fneg', 'a')) => ('fabs', 'a')
 *    ('fabs', ('u2f', 'a')) => ('u2f', 'a')
 *    ('iabs', ('iabs', 'a')) => ('iabs', 'a')
 *    ('iabs', ('ineg', 'a')) => ('iabs', 'a')
 *    ('~fadd', 'a', 0.0) => a
 *    ('fadd(is_only_used_as_float,nsz)', 'a', 0.0) => a
 *    ('fadd(is_only_used_as_float)', 'a', '#b(is_negative_zero)') => a
 *    ('fadd', ('fneg', 'a'), '#b(is_negative_zero)') => ('fneg', 'a')
 *    ('iadd', 'a', 0) => a
 *    ('iadd_sat', 'a', 0) => a
 *    ('isub_sat', 'a', 0) => a
 *    ('uadd_sat', 'a', 0) => a
 *    ('usub_sat', 'a', 0) => a
 *    ('usadd_4x8_vc4', 'a', 0) => a
 *    ('usadd_4x8_vc4', 'a', -1) => -1
 *    ('~fadd', ('fmul', 'a', 'b'), ('fmul', 'a', 'c')) => ('fmul', 'a', ('fadd', 'b', 'c'))
 *    ('~fadd', ('fmulz', 'a', 'b'), ('fmulz', 'a', 'c')) => ('fmulz', 'a', ('fadd', 'b', 'c'))
 *    ('~ffma', 'a', 'b', ('ffma(is_used_once)', 'a', 'c', 'd')) => ('ffma', 'a', ('fadd', 'b', 'c'), 'd')
 *    ('~ffma', 'a', 'b', ('fmul(is_used_once)', 'a', 'c')) => ('fmul', 'a', ('fadd', 'b', 'c'))
 *    ('~fadd', ('fmul(is_used_once)', 'a', 'b'), ('ffma(is_used_once)', 'a', 'c', 'd')) => ('ffma', 'a', ('fadd', 'b', 'c'), 'd')
 *    ('~ffma', 'a', ('fmul(is_used_once)', 'b', 'c'), ('fmul(is_used_once)', 'b', 'd')) => ('fmul', 'b', ('ffma', 'a', 'c', 'd'))
 *    ('~ffmaz', 'a', 'b', ('ffmaz(is_used_once)', 'a', 'c', 'd')) => ('ffmaz', 'a', ('fadd', 'b', 'c'), 'd')
 *    ('~ffmaz', 'a', 'b', ('fmulz(is_used_once)', 'a', 'c')) => ('fmulz', 'a', ('fadd', 'b', 'c'))
 *    ('~fadd', ('fmulz(is_used_once)', 'a', 'b'), ('ffmaz(is_used_once)', 'a', 'c', 'd')) => ('ffmaz', 'a', ('fadd', 'b', 'c'), 'd')
 *    ('~ffmaz', 'a', ('fmulz(is_used_once)', 'b', 'c'), ('fmulz(is_used_once)', 'b', 'd')) => ('fmulz', 'b', ('ffmaz', 'a', 'c', 'd'))
 *    ('iadd', ('imul', 'a', 'b'), ('imul', 'a', 'c')) => ('imul', 'a', ('iadd', 'b', 'c'))
 *    ('iadd', ('ishl', 'b', 'a'), ('ishl', 'c', 'a')) => ('ishl', ('iadd', 'b', 'c'), 'a')
 *    ('iand', ('ior', 'a', 'b'), ('ior', 'a', 'c')) => ('ior', 'a', ('iand', 'b', 'c'))
 *    ('ior', ('iand', 'a', 'b'), ('iand', 'a', 'c')) => ('iand', 'a', ('ior', 'b', 'c'))
 *    ('ieq', ('iand', 'a', '#b(is_pos_power_of_two)'), 'b') => ('ine', ('iand', 'a', 'b'), 0)
 *    ('ine', ('iand', 'a', '#b(is_pos_power_of_two)'), 'b') => ('ieq', ('iand', 'a', 'b'), 0)
 *    ('ieq', ('ushr(is_used_once)', 'a', '#b'), 0) => ('ult', 'a', ('ishl', 1, 'b'))
 *    ('ine', ('ushr(is_used_once)', 'a', '#b'), 0) => ('uge', 'a', ('ishl', 1, 'b'))
 *    ('~fadd', ('fneg', 'a'), 'a') => 0.0
 *    ('iadd', ('ineg', 'a'), 'a') => 0
 *    ('iadd', ('ineg', 'a'), ('iadd', 'a', 'b')) => b
 *    ('iadd', 'a', ('iadd', ('ineg', 'a'), 'b')) => b
 *    ('~fadd', ('fneg', 'a'), ('fadd', 'a', 'b')) => b
 *    ('~fadd', 'a', ('fadd', ('fneg', 'a'), 'b')) => b
 *    ('fadd', ('fsat', 'a'), ('fsat', ('fneg', 'a'))) => ('fsat', ('fabs', 'a'))
 *    ('~fmul', 'a', 0.0) => 0.0
 *    ('fmul(nsz,nnan)', 'a', 0.0) => 0.0
 *    ('fmulz', 'a', 0.0) => 0.0
 *    ('fmulz(nsz)', 'a', 'b(is_finite_not_zero)') => ('fmul', 'a', 'b')
 *    ('fmulz', 'a(is_finite)', 'b(is_finite)') => ('fmul', 'a', 'b')
 *    ('fmulz', 'a', 'a') => ('fmul', 'a', 'a')
 *    ('ffmaz(nsz)', 'a', 'b(is_finite_not_zero)', 'c') => ('ffma', 'a', 'b', 'c')
 *    ('ffmaz', 'a(is_finite)', 'b(is_finite)', 'c') => ('ffma', 'a', 'b', 'c')
 *    ('ffmaz', 'a', 'a', 'b') => ('ffma', 'a', 'a', 'b')
 *    ('imul', 'a', 0) => 0
 *    ('umul_unorm_4x8_vc4', 'a', 0) => 0
 *    ('umul_unorm_4x8_vc4', 'a', -1) => a
 *    ('~fmul', 'a', 1.0) => a
 *    ('~fmulz', 'a', 1.0) => a
 *    ('fmul(is_only_used_as_float)', 'a', 1.0) => a
 *    ('imul', 'a', 1) => a
 *    ('fmul', 'a', -1.0) => ('fneg', 'a')
 *    ('imul', 'a', -1) => ('ineg', 'a')
 *    ('fmul', ('fsign', 'a'), ('fmul', 'a', 'a')) => ('fmul', ('fabs', 'a'), 'a')
 *    ('fmul', ('fmul', ('fsign', 'a'), 'a'), 'a') => ('fmul', ('fabs', 'a'), 'a')
 *    ('~ffma', 0.0, 'a', 'b') => b
 *    ('ffma(is_only_used_as_float,nsz,nnan,ninf)', 0.0, 'a', 'b') => b
 *    ('ffmaz', 0.0, 'a', 'b') => ('fadd', 0.0, 'b')
 *    ('~ffma', 'a', 'b', 0.0) => ('fmul', 'a', 'b')
 *    ('ffma(nsz)', 'a', 'b', 0.0) => ('fmul', 'a', 'b')
 *    ('ffmaz(nsz)', 'a', 'b', 0.0) => ('fmulz', 'a', 'b')
 *    ('ffma', 1.0, 'a', 'b') => ('fadd', 'a', 'b')
 *    ('ffmaz(nsz)', 1.0, 'a', 'b') => ('fadd', 'a', 'b')
 *    ('ffma', -1.0, 'a', 'b') => ('fadd', ('fneg', 'a'), 'b')
 *    ('ffmaz(nsz)', -1.0, 'a', 'b') => ('fadd', ('fneg', 'a'), 'b')
 *    ('~ffma', '#a', '#b', 'c') => ('fadd', ('fmul', 'a', 'b'), 'c')
 *    ('~ffmaz', '#a', '#b', 'c') => ('fadd', ('fmulz', 'a', 'b'), 'c')
 *    ('~flrp', 'a', 'b', 0.0) => a
 *    ('~flrp', 'a', 'b', 1.0) => b
 *    ('~flrp', 'a', 'a', 'b') => a
 *    ('~flrp', 0.0, 'a', 'b') => ('fmul', 'a', 'b')
 *    ('~flrp', 'a', ('fadd(is_used_once)', 'a', 'b'), 'c') => ('fadd', ('fmul', 'b', 'c'), 'a')
 *    ('sdot_4x8_iadd', 'a', 0, 'b') => b
 *    ('udot_4x8_uadd', 'a', 0, 'b') => b
 *    ('sdot_4x8_iadd_sat', 'a', 0, 'b') => b
 *    ('udot_4x8_uadd_sat', 'a', 0, 'b') => b
 *    ('sdot_2x16_iadd', 'a', 0, 'b') => b
 *    ('udot_2x16_uadd', 'a', 0, 'b') => b
 *    ('sdot_2x16_iadd_sat', 'a', 0, 'b') => b
 *    ('udot_2x16_uadd_sat', 'a', 0, 'b') => b
 *    ('sudot_4x8_iadd', 'a', 0, 'b') => b
 *    ('sudot_4x8_iadd', 0, 'a', 'b') => b
 *    ('sudot_4x8_iadd_sat', 'a', 0, 'b') => b
 *    ('sudot_4x8_iadd_sat', 0, 'a', 'b') => b
 *    ('iadd', ('sdot_4x8_iadd(is_used_once)', 'a', 'b', '#c'), '#d') => ('sdot_4x8_iadd', 'a', 'b', ('iadd', 'c', 'd'))
 *    ('iadd', ('udot_4x8_uadd(is_used_once)', 'a', 'b', '#c'), '#d') => ('udot_4x8_uadd', 'a', 'b', ('iadd', 'c', 'd'))
 *    ('iadd', ('sudot_4x8_iadd(is_used_once)', 'a', 'b', '#c'), '#d') => ('sudot_4x8_iadd', 'a', 'b', ('iadd', 'c', 'd'))
 *    ('iadd', ('sdot_2x16_iadd(is_used_once)', 'a', 'b', '#c'), '#d') => ('sdot_2x16_iadd', 'a', 'b', ('iadd', 'c', 'd'))
 *    ('iadd', ('udot_2x16_uadd(is_used_once)', 'a', 'b', '#c'), '#d') => ('udot_2x16_uadd', 'a', 'b', ('iadd', 'c', 'd'))
 *    ('iadd', ('sdot_4x8_iadd', 'a(is_not_const)', 'b', 0), 'c') => ('sdot_4x8_iadd', 'a', 'b', 'c')
 *    ('iadd', ('udot_4x8_uadd', 'a(is_not_const)', 'b', 0), 'c') => ('udot_4x8_uadd', 'a', 'b', 'c')
 *    ('iadd', ('sudot_4x8_iadd', 'a(is_not_const)', 'b', 0), 'c') => ('sudot_4x8_iadd', 'a', 'b', 'c')
 *    ('iadd', ('sudot_4x8_iadd', 'a', 'b(is_not_const)', 0), 'c') => ('sudot_4x8_iadd', 'a', 'b', 'c')
 *    ('iadd', ('sdot_2x16_iadd', 'a(is_not_const)', 'b', 0), 'c') => ('sdot_2x16_iadd', 'a', 'b', 'c')
 *    ('iadd', ('udot_2x16_uadd', 'a(is_not_const)', 'b', 0), 'c') => ('udot_2x16_uadd', 'a', 'b', 'c')
 *    ('sdot_4x8_iadd', '#a', '#b', 'c(is_not_const)') => ('iadd', ('sdot_4x8_iadd', 'a', 'b', 0), 'c')
 *    ('udot_4x8_uadd', '#a', '#b', 'c(is_not_const)') => ('iadd', ('udot_4x8_uadd', 'a', 'b', 0), 'c')
 *    ('sudot_4x8_iadd', '#a', '#b', 'c(is_not_const)') => ('iadd', ('sudot_4x8_iadd', 'a', 'b', 0), 'c')
 *    ('sdot_2x16_iadd', '#a', '#b', 'c(is_not_const)') => ('iadd', ('sdot_2x16_iadd', 'a', 'b', 0), 'c')
 *    ('udot_2x16_uadd', '#a', '#b', 'c(is_not_const)') => ('iadd', ('udot_2x16_uadd', 'a', 'b', 0), 'c')
 *    ('sdot_4x8_iadd_sat', '#a', '#b', 'c(is_not_const)') => ('iadd_sat', ('sdot_4x8_iadd', 'a', 'b', 0), 'c')
 *    ('udot_4x8_uadd_sat', '#a', '#b', 'c(is_not_const)') => ('uadd_sat', ('udot_4x8_uadd', 'a', 'b', 0), 'c')
 *    ('sudot_4x8_iadd_sat', '#a', '#b', 'c(is_not_const)') => ('iadd_sat', ('sudot_4x8_iadd', 'a', 'b', 0), 'c')
 *    ('sdot_2x16_iadd_sat', '#a', '#b', 'c(is_not_const)') => ('iadd_sat', ('sdot_2x16_iadd', 'a', 'b', 0), 'c')
 *    ('udot_2x16_uadd_sat', '#a', '#b', 'c(is_not_const)') => ('uadd_sat', ('udot_2x16_uadd', 'a', 'b', 0), 'c')
 *    ('fmul@32(nsz)', ('bcsel', ('feq', 'b', 0.0, 'ignore_exact'), 0.0, ('fneg', ('fabs', 'a'))), ('bcsel', ('feq', 'a', 0.0, 'ignore_exact'), 0.0, ('fneg', ('fabs', 'b')))) => ('fmulz', ('fneg', ('fabs', 'a')), ('fneg', ('fabs', 'b')))
 *    ('fmul@32(nsz)', ('bcsel', ('feq', 'b', 0.0, 'ignore_exact'), 0.0, ('fneg', ('fabs', 'a'))), ('bcsel', ('feq', 'a', 0.0, 'ignore_exact'), 0.0, ('fabs', 'b'))) => ('fmulz', ('fneg', ('fabs', 'a')), ('fabs', 'b'))
 *    ('fmul@32(nsz)', ('bcsel', ('feq', 'b', 0.0, 'ignore_exact'), 0.0, ('fneg', ('fabs', 'a'))), ('bcsel', ('feq', 'a', 0.0, 'ignore_exact'), 0.0, ('fneg', 'b'))) => ('fmulz', ('fneg', ('fabs', 'a')), ('fneg', 'b'))
 *    ('fmul@32(nsz)', ('bcsel', ('feq', 'b', 0.0, 'ignore_exact'), 0.0, ('fneg', ('fabs', 'a'))), ('bcsel', ('feq', 'a', 0.0, 'ignore_exact'), 0.0, 'b')) => ('fmulz', ('fneg', ('fabs', 'a')), 'b')
 *    ('fmul@32(nsz)', ('bcsel', ('feq', 'b', 0.0, 'ignore_exact'), 0.0, ('fabs', 'a')), ('bcsel', ('feq', 'a', 0.0, 'ignore_exact'), 0.0, ('fabs', 'b'))) => ('fmulz', ('fabs', 'a'), ('fabs', 'b'))
 *    ('fmul@32(nsz)', ('bcsel', ('feq', 'b', 0.0, 'ignore_exact'), 0.0, ('fabs', 'a')), ('bcsel', ('feq', 'a', 0.0, 'ignore_exact'), 0.0, ('fneg', 'b'))) => ('fmulz', ('fabs', 'a'), ('fneg', 'b'))
 *    ('fmul@32(nsz)', ('bcsel', ('feq', 'b', 0.0, 'ignore_exact'), 0.0, ('fabs', 'a')), ('bcsel', ('feq', 'a', 0.0, 'ignore_exact'), 0.0, 'b')) => ('fmulz', ('fabs', 'a'), 'b')
 *    ('fmul@32(nsz)', ('bcsel', ('feq', 'b', 0.0, 'ignore_exact'), 0.0, ('fneg', 'a')), ('bcsel', ('feq', 'a', 0.0, 'ignore_exact'), 0.0, ('fneg', 'b'))) => ('fmulz', ('fneg', 'a'), ('fneg', 'b'))
 *    ('fmul@32(nsz)', ('bcsel', ('feq', 'b', 0.0, 'ignore_exact'), 0.0, ('fneg', 'a')), ('bcsel', ('feq', 'a', 0.0, 'ignore_exact'), 0.0, 'b')) => ('fmulz', ('fneg', 'a'), 'b')
 *    ('fmul@32(nsz)', ('bcsel', ('feq', 'b', 0.0, 'ignore_exact'), 0.0, 'a'), ('bcsel', ('feq', 'a', 0.0, 'ignore_exact'), 0.0, 'b')) => ('fmulz', 'a', 'b')
 *    ('fmul@32(nsz)', ('fneg', ('fabs', 'a')), ('bcsel', ('feq', 'a', 0.0, 'ignore_exact'), 0.0, '#b(is_not_const_zero)')) => ('fmulz', ('fneg', ('fabs', 'a')), 'b')
 *    ('fmul@32(nsz)', ('fabs', 'a'), ('bcsel', ('feq', 'a', 0.0, 'ignore_exact'), 0.0, '#b(is_not_const_zero)')) => ('fmulz', ('fabs', 'a'), 'b')
 *    ('fmul@32(nsz)', ('fneg', 'a'), ('bcsel', ('feq', 'a', 0.0, 'ignore_exact'), 0.0, '#b(is_not_const_zero)')) => ('fmulz', ('fneg', 'a'), 'b')
 *    ('fmul@32(nsz)', 'a', ('bcsel', ('feq', 'a', 0.0, 'ignore_exact'), 0.0, '#b(is_not_const_zero)')) => ('fmulz', 'a', 'b')
 *    ('ffma@32(nsz)', ('bcsel', ('feq', 'b', 0.0, 'ignore_exact'), 0.0, ('fneg', ('fabs', 'a'))), ('bcsel', ('feq', 'a', 0.0, 'ignore_exact'), 0.0, ('fneg', ('fabs', 'b'))), 'c') => ('ffmaz', ('fneg', ('fabs', 'a')), ('fneg', ('fabs', 'b')), 'c')
 *    ('ffma@32(nsz)', ('bcsel', ('feq', 'b', 0.0, 'ignore_exact'), 0.0, ('fneg', ('fabs', 'a'))), ('bcsel', ('feq', 'a', 0.0, 'ignore_exact'), 0.0, ('fabs', 'b')), 'c') => ('ffmaz', ('fneg', ('fabs', 'a')), ('fabs', 'b'), 'c')
 *    ('ffma@32(nsz)', ('bcsel', ('feq', 'b', 0.0, 'ignore_exact'), 0.0, ('fneg', ('fabs', 'a'))), ('bcsel', ('feq', 'a', 0.0, 'ignore_exact'), 0.0, ('fneg', 'b')), 'c') => ('ffmaz', ('fneg', ('fabs', 'a')), ('fneg', 'b'), 'c')
 *    ('ffma@32(nsz)', ('bcsel', ('feq', 'b', 0.0, 'ignore_exact'), 0.0, ('fneg', ('fabs', 'a'))), ('bcsel', ('feq', 'a', 0.0, 'ignore_exact'), 0.0, 'b'), 'c') => ('ffmaz', ('fneg', ('fabs', 'a')), 'b', 'c')
 *    ('ffma@32(nsz)', ('bcsel', ('feq', 'b', 0.0, 'ignore_exact'), 0.0, ('fabs', 'a')), ('bcsel', ('feq', 'a', 0.0, 'ignore_exact'), 0.0, ('fabs', 'b')), 'c') => ('ffmaz', ('fabs', 'a'), ('fabs', 'b'), 'c')
 *    ('ffma@32(nsz)', ('bcsel', ('feq', 'b', 0.0, 'ignore_exact'), 0.0, ('fabs', 'a')), ('bcsel', ('feq', 'a', 0.0, 'ignore_exact'), 0.0, ('fneg', 'b')), 'c') => ('ffmaz', ('fabs', 'a'), ('fneg', 'b'), 'c')
 *    ('ffma@32(nsz)', ('bcsel', ('feq', 'b', 0.0, 'ignore_exact'), 0.0, ('fabs', 'a')), ('bcsel', ('feq', 'a', 0.0, 'ignore_exact'), 0.0, 'b'), 'c') => ('ffmaz', ('fabs', 'a'), 'b', 'c')
 *    ('ffma@32(nsz)', ('bcsel', ('feq', 'b', 0.0, 'ignore_exact'), 0.0, ('fneg', 'a')), ('bcsel', ('feq', 'a', 0.0, 'ignore_exact'), 0.0, ('fneg', 'b')), 'c') => ('ffmaz', ('fneg', 'a'), ('fneg', 'b'), 'c')
 *    ('ffma@32(nsz)', ('bcsel', ('feq', 'b', 0.0, 'ignore_exact'), 0.0, ('fneg', 'a')), ('bcsel', ('feq', 'a', 0.0, 'ignore_exact'), 0.0, 'b'), 'c') => ('ffmaz', ('fneg', 'a'), 'b', 'c')
 *    ('ffma@32(nsz)', ('bcsel', ('feq', 'b', 0.0, 'ignore_exact'), 0.0, 'a'), ('bcsel', ('feq', 'a', 0.0, 'ignore_exact'), 0.0, 'b'), 'c') => ('ffmaz', 'a', 'b', 'c')
 *    ('ffma@32(nsz)', ('fneg', ('fabs', 'a')), ('bcsel', ('feq', 'a', 0.0, 'ignore_exact'), 0.0, '#b(is_not_const_zero)'), 'c') => ('ffmaz', ('fneg', ('fabs', 'a')), 'b', 'c')
 *    ('ffma@32(nsz)', ('fabs', 'a'), ('bcsel', ('feq', 'a', 0.0, 'ignore_exact'), 0.0, '#b(is_not_const_zero)'), 'c') => ('ffmaz', ('fabs', 'a'), 'b', 'c')
 *    ('ffma@32(nsz)', ('fneg', 'a'), ('bcsel', ('feq', 'a', 0.0, 'ignore_exact'), 0.0, '#b(is_not_const_zero)'), 'c') => ('ffmaz', ('fneg', 'a'), 'b', 'c')
 *    ('ffma@32(nsz)', 'a', ('bcsel', ('feq', 'a', 0.0, 'ignore_exact'), 0.0, '#b(is_not_const_zero)'), 'c') => ('ffmaz', 'a', 'b', 'c')
 *    ('bcsel(nsz,nnan,ninf)', ('feq', 'b', 0.0, 'ignore_exact'), 1.0, ('fexp2', ('fmul@32', 'a', ('fneg', ('fabs', 'b'))))) => ('fexp2', ('fmulz', 'a', ('fneg', ('fabs', 'b'))))
 *    ('bcsel(nsz,nnan,ninf)', ('feq', 'b', 0.0, 'ignore_exact'), 1.0, ('fexp2', ('fmul@32', 'a', ('fabs', 'b')))) => ('fexp2', ('fmulz', 'a', ('fabs', 'b')))
 *    ('bcsel(nsz,nnan,ninf)', ('feq', 'b', 0.0, 'ignore_exact'), 1.0, ('fexp2', ('fmul@32', 'a', ('fneg', 'b')))) => ('fexp2', ('fmulz', 'a', ('fneg', 'b')))
 *    ('bcsel(nsz,nnan,ninf)', ('feq', 'b', 0.0, 'ignore_exact'), 1.0, ('fexp2', ('fmul@32', 'a', 'b'))) => ('fexp2', ('fmulz', 'a', 'b'))
 *    ('bcsel', ('feq', 'b', 0.0, 'ignore_exact'), 1.0, ('fexp2', ('fmulz', 'a', ('fneg', ('fabs', 'b'))))) => ('fexp2', ('fmulz', 'a', ('fneg', ('fabs', 'b'))))
 *    ('bcsel', ('feq', 'b', 0.0, 'ignore_exact'), 1.0, ('fexp2', ('fmulz', 'a', ('fabs', 'b')))) => ('fexp2', ('fmulz', 'a', ('fabs', 'b')))
 *    ('bcsel', ('feq', 'b', 0.0, 'ignore_exact'), 1.0, ('fexp2', ('fmulz', 'a', ('fneg', 'b')))) => ('fexp2', ('fmulz', 'a', ('fneg', 'b')))
 *    ('bcsel', ('feq', 'b', 0.0, 'ignore_exact'), 1.0, ('fexp2', ('fmulz', 'a', 'b'))) => ('fexp2', ('fmulz', 'a', 'b'))
 *    ('sdot_4x8_iadd', 'a', 'b', 'c') => ('iadd', ('iadd', ('iadd', ('imul', ('extract_i8', 'a', 0), ('extract_i8', 'b', 0)), ('imul', ('extract_i8', 'a', 1), ('extract_i8', 'b', 1))), ('iadd', ('imul', ('extract_i8', 'a', 2), ('extract_i8', 'b', 2)), ('imul', ('extract_i8', 'a', 3), ('extract_i8', 'b', 3)))), 'c')
 *    ('udot_4x8_uadd', 'a', 'b', 'c') => ('iadd', ('iadd', ('iadd', ('imul', ('extract_u8', 'a', 0), ('extract_u8', 'b', 0)), ('imul', ('extract_u8', 'a', 1), ('extract_u8', 'b', 1))), ('iadd', ('imul', ('extract_u8', 'a', 2), ('extract_u8', 'b', 2)), ('imul', ('extract_u8', 'a', 3), ('extract_u8', 'b', 3)))), 'c')
 *    ('sudot_4x8_iadd', 'a', 'b', 'c') => ('iadd', ('iadd', ('iadd', ('imul', ('extract_i8', 'a', 0), ('extract_u8', 'b', 0)), ('imul', ('extract_i8', 'a', 1), ('extract_u8', 'b', 1))), ('iadd', ('imul', ('extract_i8', 'a', 2), ('extract_u8', 'b', 2)), ('imul', ('extract_i8', 'a', 3), ('extract_u8', 'b', 3)))), 'c')
 *    ('sdot_2x16_iadd', 'a', 'b', 'c') => ('iadd', ('iadd', ('imul', ('extract_i16', 'a', 0), ('extract_i16', 'b', 0)), ('imul', ('extract_i16', 'a', 1), ('extract_i16', 'b', 1))), 'c')
 *    ('udot_2x16_uadd', 'a', 'b', 'c') => ('iadd', ('iadd', ('imul', ('extract_u16', 'a', 0), ('extract_u16', 'b', 0)), ('imul', ('extract_u16', 'a', 1), ('extract_u16', 'b', 1))), 'c')
 *    ('udot_4x8_uadd_sat', 'a', 'b', '#c(is_ult_0xfffc07fc)') => ('udot_4x8_uadd', 'a', 'b', 'c')
 *    ('udot_4x8_uadd_sat', 'a', 'b', 'c') => ('uadd_sat', ('udot_4x8_uadd', 'a', 'b', 0), 'c')
 *    ('sdot_4x8_iadd_sat', 'a', 'b', 'c') => ('iadd_sat', ('sdot_4x8_iadd', 'a', 'b', 0), 'c')
 *    ('sudot_4x8_iadd_sat', 'a', 'b', 'c') => ('iadd_sat', ('sudot_4x8_iadd', 'a', 'b', 0), 'c')
 *    ('udot_2x16_uadd_sat', 'a', 'b', 'c') => ('uadd_sat', ('iadd', ('imul', ('extract_u16', 'a', 0), ('extract_u16', 'b', 0)), ('imul', ('extract_u16', 'a', 1), ('extract_u16', 'b', 1))), 'c')
 *    ('sdot_2x16_iadd_sat', 'a', 'b', 'c') => ('iadd_sat', ('iadd', ('imul', ('extract_i16', 'a', 0), ('extract_i16', 'b', 0)), ('imul', ('extract_i16', 'a', 1), ('extract_i16', 'b', 1))), 'c')
 *    ('~flrp@16', 'a', 'b', ('b2f', 'c@1')) => ('bcsel', 'c', 'b', 'a')
 *    ('~flrp@16', 'a', ('fadd', 'a', 'b'), 'c') => ('fadd', ('fmul', 'b', 'c'), 'a')
 *    ('~flrp@16', ('fadd(is_used_once)', 'a', 'b'), ('fadd(is_used_once)', 'a', 'c'), 'd') => ('fadd', ('flrp', 'b', 'c', 'd'), 'a')
 *    ('~flrp@16', 'a', ('fmul(is_used_once)', 'a', 'b'), 'c') => ('fmul', ('flrp', 1.0, 'b', 'c'), 'a')
 *    ('~fadd@16', ('fmul', 'a', ('fadd', 1.0, ('fneg', 'c'))), ('fmul', 'b', 'c')) => ('flrp', 'a', 'b', 'c')
 *    ('~fadd@16', ('fmul', 'a', ('fsat', ('fadd', 1.0, ('fneg', 'c')))), ('fmul', 'b', ('fsat', 'c'))) => ('flrp', 'a', 'b', ('fsat', 'c'))
 *    ('~fadd@16', 'a', ('fmul', 'c', ('fadd', 'b', ('fneg', 'a')))) => ('flrp', 'a', 'b', 'c')
 *    ('~fadd@16', ('fmul', 'a', ('fadd', 1.0, ('fneg', ('b2f', 'c@1')))), ('fmul', 'b', ('b2f', 'c'))) => ('bcsel', 'c', 'b', 'a')
 *    ('~fadd@16', 'a', ('fmul', ('b2f', 'c@1'), ('fadd', 'b', ('fneg', 'a')))) => ('bcsel', 'c', 'b', 'a')
 *    ('~ffma@16', 'a', ('fadd', 1.0, ('fneg', ('b2f', 'c@1'))), ('fmul', 'b', ('b2f', 'c@1'))) => ('bcsel', 'c', 'b', 'a')
 *    ('~ffma@16', 'b', ('b2f', 'c@1'), ('ffma', ('fneg', 'a'), ('b2f', 'c@1'), 'a')) => ('bcsel', 'c', 'b', 'a')
 *    ('~ffma@16', ('b2f', 'c@1'), ('fadd', 'b', ('fneg', 'a')), 'a') => ('bcsel', 'c', 'b', 'a')
 *    ('~ffma@16', ('b2f', 'c@1'), ('ffma', ('fneg', 'a'), 'b', 'd'), ('fmul', 'a', 'b')) => ('bcsel', 'c', 'd', ('fmul', 'a', 'b'))
 *    ('~fadd@16', 1.0, ('fneg', ('fmul', ('fadd', 1.0, ('fneg', 'a')), ('fadd', 1.0, ('fneg', 'b'))))) => ('flrp', 'b', 1.0, 'a')
 *    ('~flrp@32', 'a', 'b', ('b2f', 'c@1')) => ('bcsel', 'c', 'b', 'a')
 *    ('~flrp@32', 'a', ('fadd', 'a', 'b'), 'c') => ('fadd', ('fmul', 'b', 'c'), 'a')
 *    ('~flrp@32', ('fadd(is_used_once)', 'a', 'b'), ('fadd(is_used_once)', 'a', 'c'), 'd') => ('fadd', ('flrp', 'b', 'c', 'd'), 'a')
 *    ('~flrp@32', 'a', ('fmul(is_used_once)', 'a', 'b'), 'c') => ('fmul', ('flrp', 1.0, 'b', 'c'), 'a')
 *    ('~fadd@32', ('fmul', 'a', ('fadd', 1.0, ('fneg', 'c'))), ('fmul', 'b', 'c')) => ('flrp', 'a', 'b', 'c')
 *    ('~fadd@32', ('fmul', 'a', ('fsat', ('fadd', 1.0, ('fneg', 'c')))), ('fmul', 'b', ('fsat', 'c'))) => ('flrp', 'a', 'b', ('fsat', 'c'))
 *    ('~fadd@32', 'a', ('fmul', 'c', ('fadd', 'b', ('fneg', 'a')))) => ('flrp', 'a', 'b', 'c')
 *    ('~fadd@32', ('fmul', 'a', ('fadd', 1.0, ('fneg', ('b2f', 'c@1')))), ('fmul', 'b', ('b2f', 'c'))) => ('bcsel', 'c', 'b', 'a')
 *    ('~fadd@32', 'a', ('fmul', ('b2f', 'c@1'), ('fadd', 'b', ('fneg', 'a')))) => ('bcsel', 'c', 'b', 'a')
 *    ('~ffma@32', 'a', ('fadd', 1.0, ('fneg', ('b2f', 'c@1'))), ('fmul', 'b', ('b2f', 'c@1'))) => ('bcsel', 'c', 'b', 'a')
 *    ('~ffma@32', 'b', ('b2f', 'c@1'), ('ffma', ('fneg', 'a'), ('b2f', 'c@1'), 'a')) => ('bcsel', 'c', 'b', 'a')
 *    ('~ffma@32', ('b2f', 'c@1'), ('fadd', 'b', ('fneg', 'a')), 'a') => ('bcsel', 'c', 'b', 'a')
 *    ('~ffma@32', ('b2f', 'c@1'), ('ffma', ('fneg', 'a'), 'b', 'd'), ('fmul', 'a', 'b')) => ('bcsel', 'c', 'd', ('fmul', 'a', 'b'))
 *    ('~fadd@32', 1.0, ('fneg', ('fmul', ('fadd', 1.0, ('fneg', 'a')), ('fadd', 1.0, ('fneg', 'b'))))) => ('flrp', 'b', 1.0, 'a')
 *    ('~flrp@64', 'a', 'b', ('b2f', 'c@1')) => ('bcsel', 'c', 'b', 'a')
 *    ('~flrp@64', 'a', ('fadd', 'a', 'b'), 'c') => ('fadd', ('fmul', 'b', 'c'), 'a')
 *    ('~flrp@64', ('fadd(is_used_once)', 'a', 'b'), ('fadd(is_used_once)', 'a', 'c'), 'd') => ('fadd', ('flrp', 'b', 'c', 'd'), 'a')
 *    ('~flrp@64', 'a', ('fmul(is_used_once)', 'a', 'b'), 'c') => ('fmul', ('flrp', 1.0, 'b', 'c'), 'a')
 *    ('~fadd@64', ('fmul', 'a', ('fadd', 1.0, ('fneg', 'c'))), ('fmul', 'b', 'c')) => ('flrp', 'a', 'b', 'c')
 *    ('~fadd@64', ('fmul', 'a', ('fsat', ('fadd', 1.0, ('fneg', 'c')))), ('fmul', 'b', ('fsat', 'c'))) => ('flrp', 'a', 'b', ('fsat', 'c'))
 *    ('~fadd@64', 'a', ('fmul', 'c', ('fadd', 'b', ('fneg', 'a')))) => ('flrp', 'a', 'b', 'c')
 *    ('~fadd@64', ('fmul', 'a', ('fadd', 1.0, ('fneg', ('b2f', 'c@1')))), ('fmul', 'b', ('b2f', 'c'))) => ('bcsel', 'c', 'b', 'a')
 *    ('~fadd@64', 'a', ('fmul', ('b2f', 'c@1'), ('fadd', 'b', ('fneg', 'a')))) => ('bcsel', 'c', 'b', 'a')
 *    ('~ffma@64', 'a', ('fadd', 1.0, ('fneg', ('b2f', 'c@1'))), ('fmul', 'b', ('b2f', 'c@1'))) => ('bcsel', 'c', 'b', 'a')
 *    ('~ffma@64', 'b', ('b2f', 'c@1'), ('ffma', ('fneg', 'a'), ('b2f', 'c@1'), 'a')) => ('bcsel', 'c', 'b', 'a')
 *    ('~ffma@64', ('b2f', 'c@1'), ('fadd', 'b', ('fneg', 'a')), 'a') => ('bcsel', 'c', 'b', 'a')
 *    ('~ffma@64', ('b2f', 'c@1'), ('ffma', ('fneg', 'a'), 'b', 'd'), ('fmul', 'a', 'b')) => ('bcsel', 'c', 'd', ('fmul', 'a', 'b'))
 *    ('~fadd@64', 1.0, ('fneg', ('fmul', ('fadd', 1.0, ('fneg', 'a')), ('fadd', 1.0, ('fneg', 'b'))))) => ('flrp', 'b', 1.0, 'a')
 *    ('~flrp', ('fmul(is_used_once)', 'a', 'b'), ('fmul(is_used_once)', 'a', 'c'), 'd') => ('fmul', ('flrp', 'b', 'c', 'd'), 'a')
 *    ('~flrp', 'a', 0.0, 'c') => ('fadd', ('fmul', ('fneg', 'a'), 'c'), 'a')
 *    ('ftrunc@16', 'a') => ('bcsel', ('flt', 'a', 0.0), ('fneg', ('ffloor', ('fabs', 'a'))), ('ffloor', ('fabs', 'a')))
 *    ('ftrunc@32', 'a') => ('bcsel', ('flt', 'a', 0.0), ('fneg', ('ffloor', ('fabs', 'a'))), ('ffloor', ('fabs', 'a')))
 *    ('ftrunc@64', 'a') => ('bcsel', ('flt', 'a', 0.0), ('fneg', ('ffloor', ('fabs', 'a'))), ('ffloor', ('fabs', 'a')))
 *    ('ffloor@16', 'a') => ('fsub', 'a', ('ffract', 'a'))
 *    ('ffloor@32', 'a') => ('fsub', 'a', ('ffract', 'a'))
 *    ('ffloor@64', 'a') => ('fsub', 'a', ('ffract', 'a'))
 *    ('fadd@16', 'a', ('fadd@16', 'b', ('fneg', ('ffract', 'a')))) => ('fadd@16', 'b', ('ffloor', 'a'))
 *    ('fadd@32', 'a', ('fadd@32', 'b', ('fneg', ('ffract', 'a')))) => ('fadd@32', 'b', ('ffloor', 'a'))
 *    ('fadd@64', 'a', ('fadd@64', 'b', ('fneg', ('ffract', 'a')))) => ('fadd@64', 'b', ('ffloor', 'a'))
 *    ('fadd@16', 'a', ('fneg', ('ffract', 'a'))) => ('ffloor', 'a')
 *    ('fadd@32', 'a', ('fneg', ('ffract', 'a'))) => ('ffloor', 'a')
 *    ('fadd@64', 'a', ('fneg', ('ffract', 'a'))) => ('ffloor', 'a')
 *    ('ffract@16', 'a') => ('fsub', 'a', ('ffloor', 'a'))
 *    ('ffract@32', 'a') => ('fsub', 'a', ('ffloor', 'a'))
 *    ('ffract@64', 'a') => ('fsub', 'a', ('ffloor', 'a'))
 *    ('fceil', 'a') => ('fneg', ('ffloor', ('fneg', 'a')))
 *    ('ffma@16', 'a', 'b', 'c') => ('fadd', ('fmul', 'a', 'b'), 'c')
 *    ('ffma@32', 'a', 'b', 'c') => ('fadd', ('fmul', 'a', 'b'), 'c')
 *    ('ffma@64', 'a', 'b', 'c') => ('fadd', ('fmul', 'a', 'b'), 'c')
 *    ('ffmaz', 'a', 'b', 'c') => ('fadd', ('fmulz', 'a', 'b'), 'c')
 *    ('~ffma@16', 'a', 'b', 'c') => ('fadd', ('fmul', 'a', 'b'), 'c')
 *    ('~ffma@32', 'a', 'b', 'c') => ('fadd', ('fmul', 'a', 'b'), 'c')
 *    ('~ffma@64', 'a', 'b', 'c') => ('fadd', ('fmul', 'a', 'b'), 'c')
 *    ('~ffmaz', 'a', 'b', 'c') => ('fadd', ('fmulz', 'a', 'b'), 'c')
 *    ('~fmul', ('fadd', ('iand', ('ineg', ('b2i', 'a@bool')), ('fmul', 'b', 'c')), '#d'), '#e') => ('bcsel', 'a', ('fmul', ('fadd', ('fmul', 'b', 'c'), 'd'), 'e'), ('fmul', 'd', 'e'))
 *    ('fdph', 'a', 'b') => ('fdot4', ('vec4', 'a.x', 'a.y', 'a.z', 1.0), 'b')
 *    ('fdot4', 'a', 0.0) => 0.0
 *    ('fdot3', 'a', 0.0) => 0.0
 *    ('fdot2', 'a', 0.0) => 0.0
 *    ('fdot4', ('vec4', 'a', 'b', 'c', 1.0), 'd') => ('fdph', ('vec3', 'a', 'b', 'c'), 'd')
 *    ('fdot4', ('vec4', 'a', 0.0, 0.0, 0.0), 'b') => ('fmul', 'a', 'b')
 *    ('fdot4', ('vec4', 'a', 'b', 0.0, 0.0), 'c') => ('fdot2', ('vec2', 'a', 'b'), 'c')
 *    ('fdot4', ('vec4', 'a', 'b', 'c', 0.0), 'd') => ('fdot3', ('vec3', 'a', 'b', 'c'), 'd')
 *    ('fdot3', ('vec3', 'a', 0.0, 0.0), 'b') => ('fmul', 'a', 'b')
 *    ('fdot3', ('vec3', 'a', 'b', 0.0), 'c') => ('fdot2', ('vec2', 'a', 'b'), 'c')
 *    ('fdot2', ('vec2', 'a', 0.0), 'b') => ('fmul', 'a', 'b')
 *    ('fdot2', 'a', 1.0) => ('fadd', 'a.x', 'a.y')
 *    ('fdot2', 'a', 'b') => ('fsum2', ('fmul', 'a', 'b'))
 *    ('fdot3', 'a', 'b') => ('fsum3', ('fmul', 'a', 'b'))
 *    ('fdot4', 'a', 'b') => ('fsum4', ('fmul', 'a', 'b'))
 *    ('fsum2', 'a') => ('fadd', 'a.x', 'a.y')
 *    ('~fadd', ('fneg(is_used_once)', ('fsat(is_used_once)', 'a(is_not_fmul)')), 1.0) => ('fsat', ('fadd', 1.0, ('fneg', 'a')))
 *    ('ishl', ('iadd', ('imul', 'a', '#b'), '#c'), '#d') => ('iadd', ('imul', 'a', ('ishl', 'b', 'd')), ('ishl', 'c', 'd'))
 *    ('ishl', ('imul', 'a', '#b'), '#c') => ('imul', 'a', ('ishl', 'b', 'c'))
 *    ('ishl@8', ('ishl@8', 'a', '#b'), '#c') => ('bcsel', ('ult', ('iadd', ('iand', 'b', 7), ('iand', 'c', 7)), 8), ('ishl@8', 'a', ('iadd', 'b', 'c')), 0)
 *    ('ushr@8', ('ushr@8', 'a', '#b'), '#c') => ('bcsel', ('ult', ('iadd', ('iand', 'b', 7), ('iand', 'c', 7)), 8), ('ushr@8', 'a', ('iadd', 'b', 'c')), 0)
 *    ('ishr@8', ('ishr@8', 'a', '#b'), '#c') => ('ishr@8', 'a', ('imin', ('iadd', ('iand', 'b', 7), ('iand', 'c', 7)), 7))
 *    ('ishl@16', ('ishl@16', 'a', '#b'), '#c') => ('bcsel', ('ult', ('iadd', ('iand', 'b', 15), ('iand', 'c', 15)), 16), ('ishl@16', 'a', ('iadd', 'b', 'c')), 0)
 *    ('ushr@16', ('ushr@16', 'a', '#b'), '#c') => ('bcsel', ('ult', ('iadd', ('iand', 'b', 15), ('iand', 'c', 15)), 16), ('ushr@16', 'a', ('iadd', 'b', 'c')), 0)
 *    ('ishr@16', ('ishr@16', 'a', '#b'), '#c') => ('ishr@16', 'a', ('imin', ('iadd', ('iand', 'b', 15), ('iand', 'c', 15)), 15))
 *    ('ishl@32', ('ishl@32', 'a', '#b'), '#c') => ('bcsel', ('ult', ('iadd', ('iand', 'b', 31), ('iand', 'c', 31)), 32), ('ishl@32', 'a', ('iadd', 'b', 'c')), 0)
 *    ('ushr@32', ('ushr@32', 'a', '#b'), '#c') => ('bcsel', ('ult', ('iadd', ('iand', 'b', 31), ('iand', 'c', 31)), 32), ('ushr@32', 'a', ('iadd', 'b', 'c')), 0)
 *    ('ishr@32', ('ishr@32', 'a', '#b'), '#c') => ('ishr@32', 'a', ('imin', ('iadd', ('iand', 'b', 31), ('iand', 'c', 31)), 31))
 *    ('ishl@64', ('ishl@64', 'a', '#b'), '#c') => ('bcsel', ('ult', ('iadd', ('iand', 'b', 63), ('iand', 'c', 63)), 64), ('ishl@64', 'a', ('iadd', 'b', 'c')), 0)
 *    ('ushr@64', ('ushr@64', 'a', '#b'), '#c') => ('bcsel', ('ult', ('iadd', ('iand', 'b', 63), ('iand', 'c', 63)), 64), ('ushr@64', 'a', ('iadd', 'b', 'c')), 0)
 *    ('ishr@64', ('ishr@64', 'a', '#b'), '#c') => ('ishr@64', 'a', ('imin', ('iadd', ('iand', 'b', 63), ('iand', 'c', 63)), 63))
 *    ('ishl', ('ushr', 'a@8', '#b'), 'b') => ('iand', 'a', ('ishl', 255, 'b'))
 *    ('ishl', ('ishr', 'a@8', '#b'), 'b') => ('iand', 'a', ('ishl', 255, 'b'))
 *    ('ushr', ('ishl', 'a@8', '#b'), 'b') => ('iand', 'a', ('ushr', 255, 'b'))
 *    ('ishl', ('ushr', 'a@16', '#b'), 'b') => ('iand', 'a', ('ishl', 65535, 'b'))
 *    ('ishl', ('ishr', 'a@16', '#b'), 'b') => ('iand', 'a', ('ishl', 65535, 'b'))
 *    ('ushr', ('ishl', 'a@16', '#b'), 'b') => ('iand', 'a', ('ushr', 65535, 'b'))
 *    ('ishl', ('ushr', 'a@32', '#b'), 'b') => ('iand', 'a', ('ishl', 4294967295, 'b'))
 *    ('ishl', ('ishr', 'a@32', '#b'), 'b') => ('iand', 'a', ('ishl', 4294967295, 'b'))
 *    ('ushr', ('ishl', 'a@32', '#b'), 'b') => ('iand', 'a', ('ushr', 4294967295, 'b'))
 *    ('ishl', ('ushr', 'a@64', '#b'), 'b') => ('iand', 'a', ('ishl', 18446744073709551615, 'b'))
 *    ('ishl', ('ishr', 'a@64', '#b'), 'b') => ('iand', 'a', ('ishl', 18446744073709551615, 'b'))
 *    ('ushr', ('ishl', 'a@64', '#b'), 'b') => ('iand', 'a', ('ushr', 18446744073709551615, 'b'))
 *    ('iand@32', ('ushr@32(is_used_once)', 'a', 'b'), '#c(is_const_bitmask)') => ('ubfe', 'a', 'b', ('bit_count', 'c'))
 *    ('iand@32', ('ushr@32', 'a', 'b'), ('bfm', 'c', 0)) => ('ubfe', 'a', 'b', 'c')
 *    ('ushr', ('iand', 'a', ('bfm', 'c', 'b')), 'b') => ('ubfe', 'a', 'b', 'c')
 *    ('ubfe', ('ubfe', 'a', '#b', '#c'), '#d', '#e') => ('bcsel', ('ilt', 31, ('iadd', ('iand', 'b', 31), ('iand', 'd', 31))), 0, ('ubfe', 'a', ('iadd', ('iand', 'b', 31), ('iand', 'd', 31)), ('umin', ('iand', 'e', 31), ('imax', ('isub', ('umin', ('iand', 'c', 31), ('isub', 32, ('iand', 'b', 31))), ('iand', 'd', 31)), 0))))
 *    ('ushr@32', ('ubfe', 'a', '#b', '#c'), '#d(is_5lsb_not_zero)') => ('bcsel', ('ilt', 31, ('iadd', ('iand', 'b', 31), ('iand', 'd', 31))), 0, ('ubfe', 'a', ('iadd', ('iand', 'b', 31), ('iand', 'd', 31)), ('umin', ('iand', 31, 31), ('imax', ('isub', ('umin', ('iand', 'c', 31), ('isub', 32, ('iand', 'b', 31))), ('iand', 'd', 31)), 0))))
 *    ('iand', ('ishl', 'a@32', '#b(is_first_5_bits_uge_2)'), -4) => ('ishl', 'a', 'b')
 *    ('iand', ('imul', 'a', '#b(is_unsigned_multiple_of_4)'), -4) => ('imul', 'a', 'b')
 *    ('iand@32', ('iadd@32', 'a', '#b(is_unsigned_multiple_of_2)'), 4294967294) => ('iadd', ('iand', 'a', 4294967294), 'b')
 *    ('iand@32', ('iadd@32', 'a', '#b(is_unsigned_multiple_of_4)'), 4294967292) => ('iadd', ('iand', 'a', 4294967292), 'b')
 *    ('iand@32', ('iadd@32', 'a', '#b(is_unsigned_multiple_of_8)'), 4294967288) => ('iadd', ('iand', 'a', 4294967288), 'b')
 *    ('iand@32', ('iadd@32', 'a', '#b(is_unsigned_multiple_of_16)'), 4294967280) => ('iadd', ('iand', 'a', 4294967280), 'b')
 *    ('iand@32', ('iadd@32', 'a', '#b(is_unsigned_multiple_of_32)'), 4294967264) => ('iadd', ('iand', 'a', 4294967264), 'b')
 *    ('iand@32', ('iadd@32', 'a', '#b(is_unsigned_multiple_of_64)'), 4294967232) => ('iadd', ('iand', 'a', 4294967232), 'b')
 *    ('ishl@32', ('iand', 'a@32', 2147483647), 1) => ('ishl', 'a', 1)
 *    ('iand', ('ishl', 'a@32', 1), 4294967294) => ('ishl', 'a', 1)
 *    ('iand', ('ushr', 'a@32', 1), 2147483647) => ('ushr', 'a', 1)
 *    ('ishl@32', ('iand', 'a@32', 1073741823), 2) => ('ishl', 'a', 2)
 *    ('iand', ('ishl', 'a@32', 2), 4294967292) => ('ishl', 'a', 2)
 *    ('iand', ('ushr', 'a@32', 2), 1073741823) => ('ushr', 'a', 2)
 *    ('ishl@32', ('iand', 'a@32', 65535), 16) => ('ishl', 'a', 16)
 *    ('iand', ('ishl', 'a@32', 16), 4294901760) => ('ishl', 'a', 16)
 *    ('iand', ('ushr', 'a@32', 16), 65535) => ('ushr', 'a', 16)
 *    ('ishl@32', ('iand', 'a@32', 255), 24) => ('ishl', 'a', 24)
 *    ('iand', ('ishl', 'a@32', 24), 4278190080) => ('ishl', 'a', 24)
 *    ('iand', ('ushr', 'a@32', 24), 255) => ('ushr', 'a', 24)
 *    ('ishl', ('iadd', 'a', '#b'), '#c') => ('iadd', ('ishl', 'a', 'c'), ('ishl', 'b', 'c'))
 *    ('imul', ('iadd(is_used_once)', 'a', '#b'), '#c') => ('iadd', ('imul', 'a', 'c'), ('imul', 'b', 'c'))
 *    ('imul', ('iadd(is_used_once)', ('iadd(is_used_once)', 'a', '#b'), 'c'), '#d') => ('iadd', ('imul', ('iadd', 'a', 'c'), 'd'), ('imul', 'b', 'd'))
 *    ('ishl', ('iadd(is_used_once)', ('iadd(is_used_once)', 'a', '#b'), 'c'), '#d') => ('iadd', ('ishl', ('iadd', 'a', 'c'), 'd'), ('ishl', 'b', 'd'))
 *    ('inot', ('flt(is_used_once)', 'a(is_a_number)', 'b(is_a_number)')) => ('fge', 'a', 'b')
 *    ('inot', ('fge(is_used_once)', 'a(is_a_number)', 'b(is_a_number)')) => ('flt', 'a', 'b')
 *    ('inot', ('feq(is_used_once)', 'a', 'b')) => ('fneu', 'a', 'b')
 *    ('inot', ('fneu(is_used_once)', 'a', 'b')) => ('feq', 'a', 'b')
 *    ('inot', ('ilt(is_used_once)', 'a', 'b')) => ('ige', 'a', 'b')
 *    ('inot', ('ult(is_used_once)', 'a', 'b')) => ('uge', 'a', 'b')
 *    ('inot', ('ige(is_used_once)', 'a', 'b')) => ('ilt', 'a', 'b')
 *    ('inot', ('uge(is_used_once)', 'a', 'b')) => ('ult', 'a', 'b')
 *    ('inot', ('ieq(is_used_once)', 'a', 'b')) => ('ine', 'a', 'b')
 *    ('inot', ('ine(is_used_once)', 'a', 'b')) => ('ieq', 'a', 'b')
 *    ('iand', ('feq', 'a', 'b'), ('fneu', 'a', 'b')) => False
 *    ('iand', ('flt', 'a', 'b'), ('flt', 'b', 'a')) => False
 *    ('iand', ('ieq', 'a', 'b'), ('ine', 'a', 'b')) => False
 *    ('iand', ('ilt', 'a', 'b'), ('ilt', 'b', 'a')) => False
 *    ('iand', ('ult', 'a', 'b'), ('ult', 'b', 'a')) => False
 *    ('flt', ('fneg', 'a'), ('fneg', 'b')) => ('flt', 'b', 'a')
 *    ('fge', ('fneg', 'a'), ('fneg', 'b')) => ('fge', 'b', 'a')
 *    ('feq', ('fneg', 'a'), ('fneg', 'b')) => ('feq', 'b', 'a')
 *    ('fneu', ('fneg', 'a'), ('fneg', 'b')) => ('fneu', 'b', 'a')
 *    ('flt', ('fneg', 'a(is_not_const)'), '#b') => ('flt', ('fneg', 'b'), 'a')
 *    ('flt', '#b', ('fneg', 'a(is_not_const)')) => ('flt', 'a', ('fneg', 'b'))
 *    ('fge', ('fneg', 'a(is_not_const)'), '#b') => ('fge', ('fneg', 'b'), 'a')
 *    ('fge', '#b', ('fneg', 'a(is_not_const)')) => ('fge', 'a', ('fneg', 'b'))
 *    ('fneu', ('fneg', 'a(is_not_const)'), '#b') => ('fneu', ('fneg', 'b'), 'a')
 *    ('feq', '#b', ('fneg', 'a(is_not_const)')) => ('feq', 'a', ('fneg', 'b'))
 *    ('flt', 'a', '#b(is_negative_zero)') => ('flt', 'a', 0.0)
 *    ('flt', '#b(is_negative_zero)', 'a') => ('flt', 0.0, 'a')
 *    ('fge', 'a', '#b(is_negative_zero)') => ('fge', 'a', 0.0)
 *    ('fge', '#b(is_negative_zero)', 'a') => ('fge', 0.0, 'a')
 *    ('fneu', 'a', '#b(is_negative_zero)') => ('fneu', 0.0, 'a')
 *    ('feq', '#b(is_negative_zero)', 'a') => ('feq', 'a', 0.0)
 *    ('ieq', ('ineg', 'a'), 0) => ('ieq', 'a', 0)
 *    ('ine', ('ineg', 'a'), 0) => ('ine', 'a', 0)
 *    ('ieq', ('iabs', 'a'), 0) => ('ieq', 'a', 0)
 *    ('ine', ('iabs', 'a'), 0) => ('ine', 'a', 0)
 *    ('fneu', ('fabs', 'a'), 0.0) => ('fneu', 'a', 0.0)
 *    ('feq', ('fabs', 'a'), 0.0) => ('feq', 'a', 0.0)
 *    ('fneu', ('fabs', 'a'), ('fabs', 'a')) => ('fneu', 'a', 'a')
 *    ('feq', ('fabs', 'a'), ('fabs', 'a')) => ('feq', 'a', 'a')
 *    ('flt', '#b(is_gt_0_and_lt_1)', ('fsat(is_used_once)', 'a')) => ('flt', 'b', 'a')
 *    ('fge', ('fsat(is_used_once)', 'a'), '#b(is_gt_0_and_lt_1)') => ('fge', 'a', 'b')
 *    ('feq', ('fsat(is_used_once)', 'a'), '#b(is_gt_0_and_lt_1)') => ('feq', 'a', 'b')
 *    ('fneu', ('fsat(is_used_once)', 'a'), '#b(is_gt_0_and_lt_1)') => ('fneu', 'a', 'b')
 *    ('fge', ('fsat(is_used_once)', 'a'), 1.0) => ('fge', 'a', 1.0)
 *    ('flt', 0.0, ('fsat(is_used_once)', 'a')) => ('flt', 0.0, 'a')
 *    ('fge', 0.0, ('b2f', 'a@1')) => ('inot', 'a')
 *    ('fge', ('fneg', ('b2f', 'a@1')), 0.0) => ('inot', 'a')
 *    ('fneu', ('fadd', ('b2f', 'a@1'), ('b2f', 'b@1')), 0.0) => ('ior', 'a', 'b')
 *    ('fneu', ('bcsel', 'a', 1.0, ('b2f', 'b@1')), 0.0) => ('ior', 'a', 'b')
 *    ('fneu', ('b2f', 'a@1'), ('fneg', ('b2f', 'b@1'))) => ('ior', 'a', 'b')
 *    ('fneu', ('fmul', ('b2f', 'a@1'), ('b2f', 'b@1')), 0.0) => ('iand', 'a', 'b')
 *    ('fneu', ('bcsel', 'a', ('b2f', 'b@1'), 0.0), 0.0) => ('iand', 'a', 'b')
 *    ('fneu', ('fadd', ('b2f', 'a@1'), ('fneg', ('b2f', 'b@1'))), 0.0) => ('ixor', 'a', 'b')
 *    ('fneu', ('b2f', 'a@1'), ('b2f', 'b@1')) => ('ixor', 'a', 'b')
 *    ('fneu', ('fneg', ('b2f', 'a@1')), ('fneg', ('b2f', 'b@1'))) => ('ixor', 'a', 'b')
 *    ('feq', ('fadd', ('b2f', 'a@1'), ('b2f', 'b@1')), 0.0) => ('inot', ('ior', 'a', 'b'))
 *    ('feq', ('bcsel', 'a', 1.0, ('b2f', 'b@1')), 0.0) => ('inot', ('ior', 'a', 'b'))
 *    ('feq', ('b2f', 'a@1'), ('fneg', ('b2f', 'b@1'))) => ('inot', ('ior', 'a', 'b'))
 *    ('feq', ('fmul', ('b2f', 'a@1'), ('b2f', 'b@1')), 0.0) => ('inot', ('iand', 'a', 'b'))
 *    ('feq', ('bcsel', 'a', ('b2f', 'b@1'), 0.0), 0.0) => ('inot', ('iand', 'a', 'b'))
 *    ('feq', ('fadd', ('b2f', 'a@1'), ('fneg', ('b2f', 'b@1'))), 0.0) => ('ieq', 'a', 'b')
 *    ('feq', ('b2f', 'a@1'), ('b2f', 'b@1')) => ('ieq', 'a', 'b')
 *    ('feq', ('fneg', ('b2f', 'a@1')), ('fneg', ('b2f', 'b@1'))) => ('ieq', 'a', 'b')
 *    ('flt', ('fneg', ('fadd', ('b2f', 'a@1'), ('b2f', 'b@1'))), 0.0) => ('ior', 'a', 'b')
 *    ('flt', 0.0, ('fadd', ('b2f', 'a@1'), ('b2f', 'b@1'))) => ('ior', 'a', 'b')
 *    ('fge', ('fneg', ('fadd', ('b2f', 'a@1'), ('b2f', 'b@1'))), 0.0) => ('inot', ('ior', 'a', 'b'))
 *    ('fge', 0.0, ('fadd', ('b2f', 'a@1'), ('b2f', 'b@1'))) => ('inot', ('ior', 'a', 'b'))
 *    ('flt', 'a', ('fneg', 'a')) => ('flt', 'a', 0.0)
 *    ('fge', 'a', ('fneg', 'a')) => ('fge', 'a', 0.0)
 *    ('flt', ('fmin', 'c', ('fneg', ('fadd', ('b2f', 'a@1'), ('b2f', 'b@1')))), 0.0) => ('ior', ('flt', 'c', 0.0), ('ior', 'a', 'b'))
 *    ('~flt', ('fadd', 'a', 'b'), 'a') => ('flt', 'b', 0.0)
 *    ('~fge', ('fadd', 'a', 'b'), 'a') => ('fge', 'b', 0.0)
 *    ('~feq', ('fadd', 'a', 'b'), 'a') => ('feq', 'b', 0.0)
 *    ('~fneu', ('fadd', 'a', 'b'), 'a') => ('fneu', 'b', 0.0)
 *    ('~flt', ('fadd(is_used_once)', 'a', '#b'), '#c') => ('flt', 'a', ('fadd', 'c', ('fneg', 'b')))
 *    ('~flt', ('fneg(is_used_once)', ('fadd(is_used_once)', 'a', '#b')), '#c') => ('flt', ('fneg', ('fadd', 'c', 'b')), 'a')
 *    ('~fge', ('fadd(is_used_once)', 'a', '#b'), '#c') => ('fge', 'a', ('fadd', 'c', ('fneg', 'b')))
 *    ('~fge', ('fneg(is_used_once)', ('fadd(is_used_once)', 'a', '#b')), '#c') => ('fge', ('fneg', ('fadd', 'c', 'b')), 'a')
 *    ('~feq', ('fadd(is_used_once)', 'a', '#b'), '#c') => ('feq', 'a', ('fadd', 'c', ('fneg', 'b')))
 *    ('~feq', ('fneg(is_used_once)', ('fadd(is_used_once)', 'a', '#b')), '#c') => ('feq', ('fneg', ('fadd', 'c', 'b')), 'a')
 *    ('~fneu', ('fadd(is_used_once)', 'a', '#b'), '#c') => ('fneu', 'a', ('fadd', 'c', ('fneg', 'b')))
 *    ('~fneu', ('fneg(is_used_once)', ('fadd(is_used_once)', 'a', '#b')), '#c') => ('fneu', ('fneg', ('fadd', 'c', 'b')), 'a')
 *    ('ieq', ('iadd', 'a', 'b'), 'a') => ('ieq', 'b', 0)
 *    ('ine', ('iadd', 'a', 'b'), 'a') => ('ine', 'b', 0)
 *    ('feq', ('b2f', 'a@1'), 0.0) => ('inot', 'a')
 *    ('fge', 0.0, ('b2f', 'a@1')) => ('inot', 'a')
 *    ('fneu', ('b2f', 'a@1'), 0.0) => a
 *    ('flt', 0.0, ('b2f', 'a@1')) => a
 *    ('ieq', ('b2i', 'a@1'), 0) => ('inot', 'a')
 *    ('ine', ('b2i', 'a@1'), 0) => a
 *    ('ieq', 'a@1', False) => ('inot', 'a')
 *    ('ieq', 'a@1', True) => a
 *    ('ine', 'a@1', False) => a
 *    ('ine', 'a@1', True) => ('inot', 'a')
 *    ('fneu', ('u2f', 'a'), 0.0) => ('ine', 'a', 0)
 *    ('feq', ('u2f', 'a'), 0.0) => ('ieq', 'a', 0)
 *    ('fge', ('u2f', 'a'), 0.0) => True
 *    ('fge', 0.0, ('u2f', 'a')) => ('uge', 0, 'a')
 *    ('flt', ('u2f', 'a'), 0.0) => False
 *    ('flt', 0.0, ('u2f', 'a')) => ('ult', 0, 'a')
 *    ('fneu', ('i2f', 'a'), 0.0) => ('ine', 'a', 0)
 *    ('feq', ('i2f', 'a'), 0.0) => ('ieq', 'a', 0)
 *    ('fge', ('i2f', 'a'), 0.0) => ('ige', 'a', 0)
 *    ('fge', 0.0, ('i2f', 'a')) => ('ige', 0, 'a')
 *    ('flt', ('i2f', 'a'), 0.0) => ('ilt', 'a', 0)
 *    ('flt', 0.0, ('i2f', 'a')) => ('ilt', 0, 'a')
 *    ('~flt', 0.0, ('fabs', 'a')) => ('fneu', 'a', 0.0)
 *    ('~flt', ('fneg', ('fabs', 'a')), 0.0) => ('fneu', 'a', 0.0)
 *    ('fge', 0.0, ('fabs', 'a')) => ('feq', 'a', 0.0)
 *    ('fge', ('fneg', ('fabs', 'a')), 0.0) => ('feq', 'a', 0.0)
 *    ('iand', ('fge', 'a', 0.0), ('fge', 1.0, 'a')) => ('feq', 'a', ('fsat', 'a'))
 *    ('fmax', ('b2f(is_used_once)', 'a@1'), ('b2f', 'b@1')) => ('b2f', ('ior', 'a', 'b'))
 *    ('fmax', ('fneg(is_used_once)', ('b2f(is_used_once)', 'a@1')), ('fneg', ('b2f', 'b@1'))) => ('fneg', ('b2f', ('iand', 'a', 'b')))
 *    ('fmin', ('b2f(is_used_once)', 'a@1'), ('b2f', 'b@1')) => ('b2f', ('iand', 'a', 'b'))
 *    ('fmin', ('fneg(is_used_once)', ('b2f(is_used_once)', 'a@1')), ('fneg', ('b2f', 'b@1'))) => ('fneg', ('b2f', ('ior', 'a', 'b')))
 *    ('fmin', ('b2f', 'a@1'), '#b') => ('bcsel', 'a', ('fmin', 'b', 1.0), ('fmin', 'b', 0.0))
 *    ('flt', ('fadd(is_used_once)', 'a', ('fneg', 'b')), 0.0) => ('flt', 'a', 'b')
 *    ('fge', ('fneg', ('fabs', 'a')), 0.0) => ('feq', 'a', 0.0)
 *    ('~bcsel', ('flt', 'b', 'a'), 'b', 'a') => ('fmin', 'a', 'b')
 *    ('~bcsel', ('flt', 'a', 'b'), 'b', 'a') => ('fmax', 'a', 'b')
 *    ('~bcsel', ('fge', 'a', 'b'), 'b', 'a') => ('fmin', 'a', 'b')
 *    ('~bcsel', ('fge', 'b', 'a'), 'b', 'a') => ('fmax', 'a', 'b')
 *    ('bcsel', ('inot', 'a'), 'b', 'c') => ('bcsel', 'a', 'c', 'b')
 *    ('bcsel', 'a', ('bcsel', 'a', 'b', 'c'), 'd') => ('bcsel', 'a', 'b', 'd')
 *    ('bcsel', 'a', 'b', ('bcsel', 'a', 'c', 'd')) => ('bcsel', 'a', 'b', 'd')
 *    ('bcsel', 'a', ('bcsel', 'b', 'c', 'd'), ('bcsel(is_used_once)', 'b', 'c', 'e')) => ('bcsel', 'b', 'c', ('bcsel', 'a', 'd', 'e'))
 *    ('bcsel', 'a', ('bcsel(is_used_once)', 'b', 'c', 'd'), ('bcsel', 'b', 'c', 'e')) => ('bcsel', 'b', 'c', ('bcsel', 'a', 'd', 'e'))
 *    ('bcsel', 'a', ('bcsel', 'b', 'c', 'd'), ('bcsel(is_used_once)', 'b', 'e', 'd')) => ('bcsel', 'b', ('bcsel', 'a', 'c', 'e'), 'd')
 *    ('bcsel', 'a', ('bcsel(is_used_once)', 'b', 'c', 'd'), ('bcsel', 'b', 'e', 'd')) => ('bcsel', 'b', ('bcsel', 'a', 'c', 'e'), 'd')
 *    ('bcsel', 'a', True, 'b') => ('ior', 'a', 'b')
 *    ('bcsel', 'a', 'a', 'b') => ('ior', 'a', 'b')
 *    ('bcsel', 'a', 'b', False) => ('iand', 'a', 'b')
 *    ('bcsel', 'a', 'b', 'a') => ('iand', 'a', 'b')
 *    ('~fmin', 'a', 'a') => a
 *    ('~fmax', 'a', 'a') => a
 *    ('imin', 'a', 'a') => a
 *    ('imax', 'a', 'a') => a
 *    ('umin', 'a', 'a') => a
 *    ('umin', 'a', 0) => 0
 *    ('umin', 'a', -1) => a
 *    ('umax', 'a', 'a') => a
 *    ('umax', 'a', 0) => a
 *    ('umax', 'a', -1) => -1
 *    ('fmax', ('fmax', 'a', 'b'), 'b') => ('fmax', 'a', 'b')
 *    ('umax', ('umax', 'a', 'b'), 'b') => ('umax', 'a', 'b')
 *    ('imax', ('imax', 'a', 'b'), 'b') => ('imax', 'a', 'b')
 *    ('fmin', ('fmin', 'a', 'b'), 'b') => ('fmin', 'a', 'b')
 *    ('umin', ('umin', 'a', 'b'), 'b') => ('umin', 'a', 'b')
 *    ('imin', ('imin', 'a', 'b'), 'b') => ('imin', 'a', 'b')
 *    ('fmax', ('fmax', ('fmax', 'a', 'b'), 'c'), 'a') => ('fmax', ('fmax', 'a', 'b'), 'c')
 *    ('umax', ('umax', ('umax', 'a', 'b'), 'c'), 'a') => ('umax', ('umax', 'a', 'b'), 'c')
 *    ('imax', ('imax', ('imax', 'a', 'b'), 'c'), 'a') => ('imax', ('imax', 'a', 'b'), 'c')
 *    ('fmin', ('fmin', ('fmin', 'a', 'b'), 'c'), 'a') => ('fmin', ('fmin', 'a', 'b'), 'c')
 *    ('umin', ('umin', ('umin', 'a', 'b'), 'c'), 'a') => ('umin', ('umin', 'a', 'b'), 'c')
 *    ('imin', ('imin', ('imin', 'a', 'b'), 'c'), 'a') => ('imin', ('imin', 'a', 'b'), 'c')
 *    ('ieq', ('b2i8', 'a@1'), ('b2i8', 'b@1')) => ('ieq', 'a', 'b')
 *    ('ine', ('b2i8', 'a@1'), ('b2i8', 'b@1')) => ('ine', 'a', 'b')
 *    ('ieq', ('b2i16', 'a@1'), ('b2i16', 'b@1')) => ('ieq', 'a', 'b')
 *    ('ine', ('b2i16', 'a@1'), ('b2i16', 'b@1')) => ('ine', 'a', 'b')
 *    ('ieq', ('b2i32', 'a@1'), ('b2i32', 'b@1')) => ('ieq', 'a', 'b')
 *    ('ine', ('b2i32', 'a@1'), ('b2i32', 'b@1')) => ('ine', 'a', 'b')
 *    ('ieq', ('b2i64', 'a@1'), ('b2i64', 'b@1')) => ('ieq', 'a', 'b')
 *    ('ine', ('b2i64', 'a@1'), ('b2i64', 'b@1')) => ('ine', 'a', 'b')
 *    ('feq', ('b2f16', 'a@1'), ('b2f16', 'b@1')) => ('ieq', 'a', 'b')
 *    ('fneu', ('b2f16', 'a@1'), ('b2f16', 'b@1')) => ('ine', 'a', 'b')
 *    ('feq', ('b2f32', 'a@1'), ('b2f32', 'b@1')) => ('ieq', 'a', 'b')
 *    ('fneu', ('b2f32', 'a@1'), ('b2f32', 'b@1')) => ('ine', 'a', 'b')
 *    ('feq', ('b2f64', 'a@1'), ('b2f64', 'b@1')) => ('ieq', 'a', 'b')
 *    ('fneu', ('b2f64', 'a@1'), ('b2f64', 'b@1')) => ('ine', 'a', 'b')
 *    ('iand@8', 'a', ('inot', ('ishr', 'a', 7))) => ('imax', 'a', 0)
 *    ('ieq', ('iand', 'a@8', 128), 0) => ('ige', 'a', 0)
 *    ('ine', ('iand', 'a@8', 128), 128) => ('ige', 'a', 0)
 *    ('ine', ('iand', 'a@8', 128), 0) => ('ilt', 'a', 0)
 *    ('ieq', ('iand', 'a@8', 128), 128) => ('ilt', 'a', 0)
 *    ('ine', ('ushr', 'a@8', 7), 0) => ('ilt', 'a', 0)
 *    ('ieq', ('ushr', 'a@8', 7), 0) => ('ige', 'a', 0)
 *    ('ieq', ('ushr', 'a@8', 7), 1) => ('ilt', 'a', 0)
 *    ('ine', ('ushr', 'a@8', 7), 1) => ('ige', 'a', 0)
 *    ('ine', ('ishr', 'a@8', 7), 0) => ('ilt', 'a', 0)
 *    ('ieq', ('ishr', 'a@8', 7), 0) => ('ige', 'a', 0)
 *    ('ieq', ('ishr', 'a@8', 7), -1) => ('ilt', 'a', 0)
 *    ('ine', ('ishr', 'a@8', 7), -1) => ('ige', 'a', 0)
 *    ('iand@16', 'a', ('inot', ('ishr', 'a', 15))) => ('imax', 'a', 0)
 *    ('ieq', ('iand', 'a@16', 32768), 0) => ('ige', 'a', 0)
 *    ('ine', ('iand', 'a@16', 32768), 32768) => ('ige', 'a', 0)
 *    ('ine', ('iand', 'a@16', 32768), 0) => ('ilt', 'a', 0)
 *    ('ieq', ('iand', 'a@16', 32768), 32768) => ('ilt', 'a', 0)
 *    ('ine', ('ushr', 'a@16', 15), 0) => ('ilt', 'a', 0)
 *    ('ieq', ('ushr', 'a@16', 15), 0) => ('ige', 'a', 0)
 *    ('ieq', ('ushr', 'a@16', 15), 1) => ('ilt', 'a', 0)
 *    ('ine', ('ushr', 'a@16', 15), 1) => ('ige', 'a', 0)
 *    ('ine', ('ishr', 'a@16', 15), 0) => ('ilt', 'a', 0)
 *    ('ieq', ('ishr', 'a@16', 15), 0) => ('ige', 'a', 0)
 *    ('ieq', ('ishr', 'a@16', 15), -1) => ('ilt', 'a', 0)
 *    ('ine', ('ishr', 'a@16', 15), -1) => ('ige', 'a', 0)
 *    ('iand@32', 'a', ('inot', ('ishr', 'a', 31))) => ('imax', 'a', 0)
 *    ('ieq', ('iand', 'a@32', 2147483648), 0) => ('ige', 'a', 0)
 *    ('ine', ('iand', 'a@32', 2147483648), 2147483648) => ('ige', 'a', 0)
 *    ('ine', ('iand', 'a@32', 2147483648), 0) => ('ilt', 'a', 0)
 *    ('ieq', ('iand', 'a@32', 2147483648), 2147483648) => ('ilt', 'a', 0)
 *    ('ine', ('ushr', 'a@32', 31), 0) => ('ilt', 'a', 0)
 *    ('ieq', ('ushr', 'a@32', 31), 0) => ('ige', 'a', 0)
 *    ('ieq', ('ushr', 'a@32', 31), 1) => ('ilt', 'a', 0)
 *    ('ine', ('ushr', 'a@32', 31), 1) => ('ige', 'a', 0)
 *    ('ine', ('ishr', 'a@32', 31), 0) => ('ilt', 'a', 0)
 *    ('ieq', ('ishr', 'a@32', 31), 0) => ('ige', 'a', 0)
 *    ('ieq', ('ishr', 'a@32', 31), -1) => ('ilt', 'a', 0)
 *    ('ine', ('ishr', 'a@32', 31), -1) => ('ige', 'a', 0)
 *    ('iand@64', 'a', ('inot', ('ishr', 'a', 63))) => ('imax', 'a', 0)
 *    ('ieq', ('iand', 'a@64', 9223372036854775808), 0) => ('ige', 'a', 0)
 *    ('ine', ('iand', 'a@64', 9223372036854775808), 9223372036854775808) => ('ige', 'a', 0)
 *    ('ine', ('iand', 'a@64', 9223372036854775808), 0) => ('ilt', 'a', 0)
 *    ('ieq', ('iand', 'a@64', 9223372036854775808), 9223372036854775808) => ('ilt', 'a', 0)
 *    ('ine', ('ushr', 'a@64', 63), 0) => ('ilt', 'a', 0)
 *    ('ieq', ('ushr', 'a@64', 63), 0) => ('ige', 'a', 0)
 *    ('ieq', ('ushr', 'a@64', 63), 1) => ('ilt', 'a', 0)
 *    ('ine', ('ushr', 'a@64', 63), 1) => ('ige', 'a', 0)
 *    ('ine', ('ishr', 'a@64', 63), 0) => ('ilt', 'a', 0)
 *    ('ieq', ('ishr', 'a@64', 63), 0) => ('ige', 'a', 0)
 *    ('ieq', ('ishr', 'a@64', 63), -1) => ('ilt', 'a', 0)
 *    ('ine', ('ishr', 'a@64', 63), -1) => ('ige', 'a', 0)
 *    ('fmin', 'a', ('fneg', 'a')) => ('fneg', ('fabs', 'a'))
 *    ('imin', 'a', ('ineg', 'a')) => ('ineg', ('iabs', 'a'))
 *    ('fmin', 'a', ('fneg', ('fabs', 'a'))) => ('fneg', ('fabs', 'a'))
 *    ('imin', 'a', ('ineg', ('iabs', 'a'))) => ('ineg', ('iabs', 'a'))
 *    ('~fmin', 'a', ('fabs', 'a')) => a
 *    ('imin', 'a', ('iabs', 'a')) => a
 *    ('~fmax', 'a', ('fneg', ('fabs', 'a'))) => a
 *    ('imax', 'a', ('ineg', ('iabs', 'a'))) => a
 *    ('fmax', 'a', ('fabs', 'a')) => ('fabs', 'a')
 *    ('imax', 'a', ('iabs', 'a')) => ('iabs', 'a')
 *    ('fmax', 'a', ('fneg', 'a')) => ('fabs', 'a')
 *    ('imax', 'a', ('ineg', 'a')) => ('iabs', 'a')
 *    ('~fmax', ('fabs', 'a'), 0.0) => ('fabs', 'a')
 *    ('fmin', ('fmax', 'a', 0.0), 1.0) => ('fsat', 'a')
 *    ('~fmax', ('fmin', 'a', 1.0), 0.0) => ('fsat', 'a')
 *    ('~fmin', ('fmax', 'a', -1.0), 0.0) => ('fneg', ('fsat', ('fneg', 'a')))
 *    ('~fmax', ('fmin', 'a', 0.0), -1.0) => ('fneg', ('fsat', ('fneg', 'a')))
 *    ('fsat', ('fsign', 'a')) => ('b2f', ('!flt', 0.0, 'a'))
 *    ('fsat', ('b2f', 'a')) => ('b2f', 'a')
 *    ('fsat', 'a') => ('fmin', ('fmax', 'a', 0.0), 1.0)
 *    ('fsat', ('fsat', 'a')) => ('fsat', 'a')
 *    ('fsat', ('fneg(is_used_once)', ('fadd(is_used_once)', 'a', 'b'))) => ('fsat', ('fadd', ('fneg', 'a'), ('fneg', 'b')))
 *    ('fsat', ('fneg(is_used_once)', ('fmul(is_used_once)', 'a', 'b'))) => ('fsat', ('fmul', ('fneg', 'a'), 'b'))
 *    ('fsat(nsz)', ('fneg(is_used_once)', ('fmulz(is_used_once)', 'a', 'b'))) => ('fsat', ('fmulz', ('fneg', 'a'), 'b'))
 *    ('fsat', ('fabs(is_used_once)', ('fmul(is_used_once)', 'a', 'b'))) => ('fsat', ('fmul', ('fabs', 'a'), ('fabs', 'b')))
 *    ('fmin', ('fmax', ('fmin', ('fmax', 'a', 'b'), 'c'), 'b'), 'c') => ('fmin', ('fmax', 'a', 'b'), 'c')
 *    ('imin', ('imax', ('imin', ('imax', 'a', 'b'), 'c'), 'b'), 'c') => ('imin', ('imax', 'a', 'b'), 'c')
 *    ('umin', ('umax', ('umin', ('umax', 'a', 'b'), 'c'), 'b'), 'c') => ('umin', ('umax', 'a', 'b'), 'c')
 *    ('fmax', ('fsat', 'a'), '#b(is_zero_to_one)') => ('fsat', ('fmax', 'a', 'b'))
 *    ('fmax', ('fsat(is_used_once)', 'a'), ('fsat(is_used_once)', 'b')) => ('fsat', ('fmax', 'a', 'b'))
 *    ('~fmin', ('fsat', 'a'), '#b(is_zero_to_one)') => ('fsat', ('fmin', 'a', 'b'))
 *    ('fsat', ('fadd', 1.0, 'a(is_ge_zero)')) => 1.0
 *    ('fneg', ('bcsel(is_used_once)', 'a', '#b', '#c')) => ('bcsel', 'a', ('fneg', 'b'), ('fneg', 'c'))
 *    ('fmax', ('fneg', ('fmin', 'b', 'a')), 'b') => ('fmax', ('fabs', 'b'), ('fneg', 'a'))
 *    ('fmin', ('fneg', ('fmax', 'b', 'a')), 'b') => ('fmin', ('fneg', ('fabs', 'b')), ('fneg', 'a'))
 *    ('fmax', ('fadd(is_used_once)', ('fneg', 'a(is_not_negative)'), '#b(is_zero_to_one)'), 0.0) => ('fsat', ('fadd', ('fneg', 'a'), 'b'))
 *    ('extract_u8', ('imin', ('imax', 'a', 0), 255), 0) => ('imin', ('imax', 'a', 0), 255)
 *    ('ior', ('flt(is_used_once)', 'a', 'b'), ('flt', 'a', 'c')) => ('flt', 'a', ('!fmax', 'b', 'c'))
 *    ('ior', ('flt(is_used_once)', 'a', 'c'), ('flt', 'b', 'c')) => ('flt', ('!fmin', 'a', 'b'), 'c')
 *    ('ior', ('fge(is_used_once)', 'a', 'b'), ('fge', 'a', 'c')) => ('fge', 'a', ('!fmin', 'b', 'c'))
 *    ('ior', ('fge(is_used_once)', 'a', 'c'), ('fge', 'b', 'c')) => ('fge', ('!fmax', 'a', 'b'), 'c')
 *    ('ior', ('flt', 'a', '#b'), ('flt', 'a', '#c')) => ('flt', 'a', ('!fmax', 'b', 'c'))
 *    ('ior', ('flt', '#a', 'c'), ('flt', '#b', 'c')) => ('flt', ('!fmin', 'a', 'b'), 'c')
 *    ('ior', ('fge', 'a', '#b'), ('fge', 'a', '#c')) => ('fge', 'a', ('!fmin', 'b', 'c'))
 *    ('ior', ('fge', '#a', 'c'), ('fge', '#b', 'c')) => ('fge', ('!fmax', 'a', 'b'), 'c')
 *    ('~iand', ('flt(is_used_once)', 'a', 'b'), ('flt', 'a', 'c')) => ('flt', 'a', ('fmin', 'b', 'c'))
 *    ('~iand', ('flt(is_used_once)', 'a', 'c'), ('flt', 'b', 'c')) => ('flt', ('fmax', 'a', 'b'), 'c')
 *    ('~iand', ('fge(is_used_once)', 'a', 'b'), ('fge', 'a', 'c')) => ('fge', 'a', ('fmax', 'b', 'c'))
 *    ('~iand', ('fge(is_used_once)', 'a', 'c'), ('fge', 'b', 'c')) => ('fge', ('fmin', 'a', 'b'), 'c')
 *    ('iand', ('flt', 'a', '#b(is_a_number)'), ('flt', 'a', '#c(is_a_number)')) => ('flt', 'a', ('fmin', 'b', 'c'))
 *    ('iand', ('flt', '#a(is_a_number)', 'c'), ('flt', '#b(is_a_number)', 'c')) => ('flt', ('fmax', 'a', 'b'), 'c')
 *    ('iand', ('fge', 'a', '#b(is_a_number)'), ('fge', 'a', '#c(is_a_number)')) => ('fge', 'a', ('fmax', 'b', 'c'))
 *    ('iand', ('fge', '#a(is_a_number)', 'c'), ('fge', '#b(is_a_number)', 'c')) => ('fge', ('fmin', 'a', 'b'), 'c')
 *    ('ior', ('ilt(is_used_once)', 'a', 'b'), ('ilt', 'a', 'c')) => ('ilt', 'a', ('imax', 'b', 'c'))
 *    ('ior', ('ilt(is_used_once)', 'a', 'c'), ('ilt', 'b', 'c')) => ('ilt', ('imin', 'a', 'b'), 'c')
 *    ('ior', ('ige(is_used_once)', 'a', 'b'), ('ige', 'a', 'c')) => ('ige', 'a', ('imin', 'b', 'c'))
 *    ('ior', ('ige(is_used_once)', 'a', 'c'), ('ige', 'b', 'c')) => ('ige', ('imax', 'a', 'b'), 'c')
 *    ('ior', ('ult(is_used_once)', 'a', 'b'), ('ult', 'a', 'c')) => ('ult', 'a', ('umax', 'b', 'c'))
 *    ('ior', ('ult(is_used_once)', 'a', 'c'), ('ult', 'b', 'c')) => ('ult', ('umin', 'a', 'b'), 'c')
 *    ('ior', ('uge(is_used_once)', 'a', 'b'), ('uge', 'a', 'c')) => ('uge', 'a', ('umin', 'b', 'c'))
 *    ('ior', ('uge(is_used_once)', 'a', 'c'), ('uge', 'b', 'c')) => ('uge', ('umax', 'a', 'b'), 'c')
 *    ('iand', ('ilt(is_used_once)', 'a', 'b'), ('ilt', 'a', 'c')) => ('ilt', 'a', ('imin', 'b', 'c'))
 *    ('iand', ('ilt(is_used_once)', 'a', 'c'), ('ilt', 'b', 'c')) => ('ilt', ('imax', 'a', 'b'), 'c')
 *    ('iand', ('ige(is_used_once)', 'a', 'b'), ('ige', 'a', 'c')) => ('ige', 'a', ('imax', 'b', 'c'))
 *    ('iand', ('ige(is_used_once)', 'a', 'c'), ('ige', 'b', 'c')) => ('ige', ('imin', 'a', 'b'), 'c')
 *    ('iand', ('ult(is_used_once)', 'a', 'b'), ('ult', 'a', 'c')) => ('ult', 'a', ('umin', 'b', 'c'))
 *    ('iand', ('ult(is_used_once)', 'a', 'c'), ('ult', 'b', 'c')) => ('ult', ('umax', 'a', 'b'), 'c')
 *    ('iand', ('uge(is_used_once)', 'a', 'b'), ('uge', 'a', 'c')) => ('uge', 'a', ('umax', 'b', 'c'))
 *    ('iand', ('uge(is_used_once)', 'a', 'c'), ('uge', 'b', 'c')) => ('uge', ('umin', 'a', 'b'), 'c')
 *    ('ior', ('ior(is_used_once)', ('flt(is_used_once)', 'a', 'c'), 'd'), ('flt', 'b', 'c')) => ('ior', ('flt', ('!fmin', 'a', 'b'), 'c'), 'd')
 *    ('ior', ('ior(is_used_once)', ('flt', 'a', 'c'), 'd'), ('flt(is_used_once)', 'b', 'c')) => ('ior', ('flt', ('!fmin', 'a', 'b'), 'c'), 'd')
 *    ('ior', ('ior(is_used_once)', ('flt(is_used_once)', 'a', 'b'), 'd'), ('flt', 'a', 'c')) => ('ior', ('flt', 'a', ('!fmax', 'b', 'c')), 'd')
 *    ('ior', ('ior(is_used_once)', ('flt', 'a', 'b'), 'd'), ('flt(is_used_once)', 'a', 'c')) => ('ior', ('flt', 'a', ('!fmax', 'b', 'c')), 'd')
 *    ('ior', ('flt', 'a(is_a_number)', 'b(is_a_number)'), ('flt', 'b', 'a')) => ('fneu', 'a', 'b')
 *    ('umin', ('iand', 'a', '#b(is_pos_power_of_two)'), ('iand', 'c', 'b')) => ('iand', ('iand', 'a', 'b'), ('iand', 'c', 'b'))
 *    ('ior', ('flt(is_used_once)', 0.0, 'a@16'), ('flt', 'b@16', 0.0)) => ('flt', 0.0, ('fmax', 'a', ('fneg', 'b')))
 *    ('ior', ('flt', 0.0, 'a@16'), ('flt(is_used_once)', 'b@16', 0.0)) => ('flt', 0.0, ('fmax', 'a', ('fneg', 'b')))
 *    ('ior', ('fge(is_used_once)', 0.0, 'a@16'), ('fge', 'b@16', 0.0)) => ('fge', 0.0, ('fmin', 'a', ('fneg', 'b')))
 *    ('ior', ('fge', 0.0, 'a@16'), ('fge(is_used_once)', 'b@16', 0.0)) => ('fge', 0.0, ('fmin', 'a', ('fneg', 'b')))
 *    ('~iand', ('flt(is_used_once)', 0.0, 'a@16'), ('flt', 'b@16', 0.0)) => ('flt', 0.0, ('fmin', 'a', ('fneg', 'b')))
 *    ('~iand', ('flt', 0.0, 'a@16'), ('flt(is_used_once)', 'b@16', 0.0)) => ('flt', 0.0, ('fmin', 'a', ('fneg', 'b')))
 *    ('~iand', ('fge(is_used_once)', 0.0, 'a@16'), ('fge', 'b@16', 0.0)) => ('fge', 0.0, ('fmax', 'a', ('fneg', 'b')))
 *    ('~iand', ('fge', 0.0, 'a@16'), ('fge(is_used_once)', 'b@16', 0.0)) => ('fge', 0.0, ('fmax', 'a', ('fneg', 'b')))
 *    ('ior', ('feq(is_used_once)', 'a@16', 0.0), ('feq', 'b@16', 0.0)) => ('feq', ('fmin', ('fabs', 'a'), ('fabs', 'b')), 0.0)
 *    ('ior', ('fneu(is_used_once)', 'a@16', 0.0), ('fneu', 'b@16', 0.0)) => ('fneu', ('fadd', ('fabs', 'a'), ('fabs', 'b')), 0.0)
 *    ('iand', ('feq(is_used_once)', 'a@16', 0.0), ('feq', 'b@16', 0.0)) => ('feq', ('fadd', ('fabs', 'a'), ('fabs', 'b')), 0.0)
 *    ('iand', ('fneu(is_used_once)', 'a@16', 0.0), ('fneu', 'b@16', 0.0)) => ('fneu', ('fmin', ('fabs', 'a'), ('fabs', 'b')), 0.0)
 *    ('bcsel@16', ('feq', 'a', 0.0), 1.0, ('i2f16', ('iadd', ('b2i16', ('flt', 0.0, 'a@16')), ('ineg', ('b2i16', ('flt', 'a@16', 0.0)))))) => ('i2f16', ('iadd', ('b2i32', ('!fge', 'a', 0.0)), ('ineg', ('b2i32', ('!flt', 'a', 0.0)))))
 *    ('bcsel', 'a', ('b2f(is_used_once)', 'b@16'), ('b2f', 'c@16')) => ('b2f', ('bcsel', 'a', 'b', 'c'))
 *    ('~i2f16', ('f2i', 'a@16')) => ('ftrunc', 'a')
 *    ('~f2i16', ('i2f', 'a@16')) => a
 *    ('~f2i16', ('u2f', 'a@16')) => a
 *    ('~f2u16', ('i2f', 'a@16')) => a
 *    ('~f2u16', ('u2f', 'a@16')) => a
 *    ('fadd', ('b2f16', ('flt', 0.0, 'a@16')), ('fneg', ('b2f16', ('flt', 'a@16', 0.0)))) => ('fsign', 'a')
 *    ('iadd', ('b2i16', ('flt', 0, 'a@16')), ('ineg', ('b2i16', ('flt', 'a@16', 0)))) => ('f2i16', ('fsign', 'a'))
 *    ('~f2f16', ('f2f', 'a')) => ('f2f16', 'a')
 *    ('~f2f16', ('u2f', 'a')) => ('u2f16', 'a')
 *    ('~f2f16', ('i2f', 'a')) => ('i2f16', 'a')
 *    ('~f2u16', ('f2f', 'a')) => ('f2u16', 'a')
 *    ('~f2i16', ('f2f', 'a')) => ('f2i16', 'a')
 *    ('i2f16', ('f2i', ('fsign', 'a@16'))) => ('fsign', 'a')
 *    ('~f2f16', ('f2f32', 'a@16')) => a
 *    ('f2u32', ('f2f32', 'a@16')) => ('f2u32', 'a')
 *    ('f2i32', ('f2f32', 'a@16')) => ('f2i32', 'a')
 *    ('f2f16', ('u2f32', 'a')) => ('u2f16', 'a')
 *    ('f2f16', ('i2f32', 'a')) => ('i2f16', 'a')
 *    ('~f2f16', ('f2f64', 'a@16')) => a
 *    ('f2u64', ('f2f64', 'a@16')) => ('f2u64', 'a')
 *    ('f2i64', ('f2f64', 'a@16')) => ('f2i64', 'a')
 *    ('f2f16', ('u2f64', 'a')) => ('u2f16', 'a')
 *    ('f2f16', ('i2f64', 'a')) => ('i2f16', 'a')
 *    ('ior', ('flt(is_used_once)', 0.0, 'a@32'), ('flt', 'b@32', 0.0)) => ('flt', 0.0, ('fmax', 'a', ('fneg', 'b')))
 *    ('ior', ('flt', 0.0, 'a@32'), ('flt(is_used_once)', 'b@32', 0.0)) => ('flt', 0.0, ('fmax', 'a', ('fneg', 'b')))
 *    ('ior', ('fge(is_used_once)', 0.0, 'a@32'), ('fge', 'b@32', 0.0)) => ('fge', 0.0, ('fmin', 'a', ('fneg', 'b')))
 *    ('ior', ('fge', 0.0, 'a@32'), ('fge(is_used_once)', 'b@32', 0.0)) => ('fge', 0.0, ('fmin', 'a', ('fneg', 'b')))
 *    ('~iand', ('flt(is_used_once)', 0.0, 'a@32'), ('flt', 'b@32', 0.0)) => ('flt', 0.0, ('fmin', 'a', ('fneg', 'b')))
 *    ('~iand', ('flt', 0.0, 'a@32'), ('flt(is_used_once)', 'b@32', 0.0)) => ('flt', 0.0, ('fmin', 'a', ('fneg', 'b')))
 *    ('~iand', ('fge(is_used_once)', 0.0, 'a@32'), ('fge', 'b@32', 0.0)) => ('fge', 0.0, ('fmax', 'a', ('fneg', 'b')))
 *    ('~iand', ('fge', 0.0, 'a@32'), ('fge(is_used_once)', 'b@32', 0.0)) => ('fge', 0.0, ('fmax', 'a', ('fneg', 'b')))
 *    ('ior', ('feq(is_used_once)', 'a@32', 0.0), ('feq', 'b@32', 0.0)) => ('feq', ('fmin', ('fabs', 'a'), ('fabs', 'b')), 0.0)
 *    ('ior', ('fneu(is_used_once)', 'a@32', 0.0), ('fneu', 'b@32', 0.0)) => ('fneu', ('fadd', ('fabs', 'a'), ('fabs', 'b')), 0.0)
 *    ('iand', ('feq(is_used_once)', 'a@32', 0.0), ('feq', 'b@32', 0.0)) => ('feq', ('fadd', ('fabs', 'a'), ('fabs', 'b')), 0.0)
 *    ('iand', ('fneu(is_used_once)', 'a@32', 0.0), ('fneu', 'b@32', 0.0)) => ('fneu', ('fmin', ('fabs', 'a'), ('fabs', 'b')), 0.0)
 *    ('bcsel@32', ('feq', 'a', 0.0), 1.0, ('i2f32', ('iadd', ('b2i32', ('flt', 0.0, 'a@32')), ('ineg', ('b2i32', ('flt', 'a@32', 0.0)))))) => ('i2f32', ('iadd', ('b2i32', ('!fge', 'a', 0.0)), ('ineg', ('b2i32', ('!flt', 'a', 0.0)))))
 *    ('bcsel', 'a', ('b2f(is_used_once)', 'b@32'), ('b2f', 'c@32')) => ('b2f', ('bcsel', 'a', 'b', 'c'))
 *    ('~i2f32', ('f2i', 'a@32')) => ('ftrunc', 'a')
 *    ('~f2i32', ('i2f', 'a@32')) => a
 *    ('~f2i32', ('u2f', 'a@32')) => a
 *    ('~f2u32', ('i2f', 'a@32')) => a
 *    ('~f2u32', ('u2f', 'a@32')) => a
 *    ('fadd', ('b2f32', ('flt', 0.0, 'a@32')), ('fneg', ('b2f32', ('flt', 'a@32', 0.0)))) => ('fsign', 'a')
 *    ('iadd', ('b2i32', ('flt', 0, 'a@32')), ('ineg', ('b2i32', ('flt', 'a@32', 0)))) => ('f2i32', ('fsign', 'a'))
 *    ('~f2f32', ('f2f', 'a')) => ('f2f32', 'a')
 *    ('~f2f32', ('u2f', 'a')) => ('u2f32', 'a')
 *    ('~f2f32', ('i2f', 'a')) => ('i2f32', 'a')
 *    ('~f2u32', ('f2f', 'a')) => ('f2u32', 'a')
 *    ('~f2i32', ('f2f', 'a')) => ('f2i32', 'a')
 *    ('i2f32', ('f2i', ('fsign', 'a@32'))) => ('fsign', 'a')
 *    ('~f2f32', ('f2f64', 'a@32')) => a
 *    ('f2u64', ('f2f64', 'a@32')) => ('f2u64', 'a')
 *    ('f2i64', ('f2f64', 'a@32')) => ('f2i64', 'a')
 *    ('f2f32', ('u2f64', 'a')) => ('u2f32', 'a')
 *    ('f2f32', ('i2f64', 'a')) => ('i2f32', 'a')
 *    ('ior', ('flt(is_used_once)', 0.0, 'a@64'), ('flt', 'b@64', 0.0)) => ('flt', 0.0, ('fmax', 'a', ('fneg', 'b')))
 *    ('ior', ('flt', 0.0, 'a@64'), ('flt(is_used_once)', 'b@64', 0.0)) => ('flt', 0.0, ('fmax', 'a', ('fneg', 'b')))
 *    ('ior', ('fge(is_used_once)', 0.0, 'a@64'), ('fge', 'b@64', 0.0)) => ('fge', 0.0, ('fmin', 'a', ('fneg', 'b')))
 *    ('ior', ('fge', 0.0, 'a@64'), ('fge(is_used_once)', 'b@64', 0.0)) => ('fge', 0.0, ('fmin', 'a', ('fneg', 'b')))
 *    ('~iand', ('flt(is_used_once)', 0.0, 'a@64'), ('flt', 'b@64', 0.0)) => ('flt', 0.0, ('fmin', 'a', ('fneg', 'b')))
 *    ('~iand', ('flt', 0.0, 'a@64'), ('flt(is_used_once)', 'b@64', 0.0)) => ('flt', 0.0, ('fmin', 'a', ('fneg', 'b')))
 *    ('~iand', ('fge(is_used_once)', 0.0, 'a@64'), ('fge', 'b@64', 0.0)) => ('fge', 0.0, ('fmax', 'a', ('fneg', 'b')))
 *    ('~iand', ('fge', 0.0, 'a@64'), ('fge(is_used_once)', 'b@64', 0.0)) => ('fge', 0.0, ('fmax', 'a', ('fneg', 'b')))
 *    ('ior', ('feq(is_used_once)', 'a@64', 0.0), ('feq', 'b@64', 0.0)) => ('feq', ('fmin', ('fabs', 'a'), ('fabs', 'b')), 0.0)
 *    ('ior', ('fneu(is_used_once)', 'a@64', 0.0), ('fneu', 'b@64', 0.0)) => ('fneu', ('fadd', ('fabs', 'a'), ('fabs', 'b')), 0.0)
 *    ('iand', ('feq(is_used_once)', 'a@64', 0.0), ('feq', 'b@64', 0.0)) => ('feq', ('fadd', ('fabs', 'a'), ('fabs', 'b')), 0.0)
 *    ('iand', ('fneu(is_used_once)', 'a@64', 0.0), ('fneu', 'b@64', 0.0)) => ('fneu', ('fmin', ('fabs', 'a'), ('fabs', 'b')), 0.0)
 *    ('bcsel@64', ('feq', 'a', 0.0), 1.0, ('i2f64', ('iadd', ('b2i64', ('flt', 0.0, 'a@64')), ('ineg', ('b2i64', ('flt', 'a@64', 0.0)))))) => ('i2f64', ('iadd', ('b2i32', ('!fge', 'a', 0.0)), ('ineg', ('b2i32', ('!flt', 'a', 0.0)))))
 *    ('bcsel', 'a', ('b2f(is_used_once)', 'b@64'), ('b2f', 'c@64')) => ('b2f', ('bcsel', 'a', 'b', 'c'))
 *    ('~i2f64', ('f2i', 'a@64')) => ('ftrunc', 'a')
 *    ('~f2i64', ('i2f', 'a@64')) => a
 *    ('~f2i64', ('u2f', 'a@64')) => a
 *    ('~f2u64', ('i2f', 'a@64')) => a
 *    ('~f2u64', ('u2f', 'a@64')) => a
 *    ('fadd', ('b2f64', ('flt', 0.0, 'a@64')), ('fneg', ('b2f64', ('flt', 'a@64', 0.0)))) => ('fsign', 'a')
 *    ('iadd', ('b2i64', ('flt', 0, 'a@64')), ('ineg', ('b2i64', ('flt', 'a@64', 0)))) => ('f2i64', ('fsign', 'a'))
 *    ('~f2f64', ('f2f', 'a')) => ('f2f64', 'a')
 *    ('~f2f64', ('u2f', 'a')) => ('u2f64', 'a')
 *    ('~f2f64', ('i2f', 'a')) => ('i2f64', 'a')
 *    ('~f2u64', ('f2f', 'a')) => ('f2u64', 'a')
 *    ('~f2i64', ('f2f', 'a')) => ('f2i64', 'a')
 *    ('i2f64', ('f2i', ('fsign', 'a@64'))) => ('fsign', 'a')
 *    ('i2i1', ('i2i8', 'a@1')) => a
 *    ('u2u1', ('u2u8', 'a@1')) => a
 *    ('i2i1', ('i2i16', 'a@1')) => a
 *    ('u2u1', ('u2u16', 'a@1')) => a
 *    ('u2f16', ('u2u8', 'a@1')) => ('u2f16', 'a')
 *    ('i2f16', ('i2i8', 'a@1')) => ('i2f16', 'a')
 *    ('u2f16', ('u2u16', 'a@1')) => ('u2f16', 'a')
 *    ('i2f16', ('i2i16', 'a@1')) => ('i2f16', 'a')
 *    ('u2f16', ('u2u32', 'a@1')) => ('u2f16', 'a')
 *    ('i2f16', ('i2i32', 'a@1')) => ('i2f16', 'a')
 *    ('u2f16', ('u2u64', 'a@1')) => ('u2f16', 'a')
 *    ('i2f16', ('i2i64', 'a@1')) => ('i2f16', 'a')
 *    ('i2i1', ('i2i32', 'a@1')) => a
 *    ('u2u1', ('u2u32', 'a@1')) => a
 *    ('u2f32', ('u2u8', 'a@1')) => ('u2f32', 'a')
 *    ('i2f32', ('i2i8', 'a@1')) => ('i2f32', 'a')
 *    ('u2f32', ('u2u16', 'a@1')) => ('u2f32', 'a')
 *    ('i2f32', ('i2i16', 'a@1')) => ('i2f32', 'a')
 *    ('u2f32', ('u2u32', 'a@1')) => ('u2f32', 'a')
 *    ('i2f32', ('i2i32', 'a@1')) => ('i2f32', 'a')
 *    ('u2f32', ('u2u64', 'a@1')) => ('u2f32', 'a')
 *    ('i2f32', ('i2i64', 'a@1')) => ('i2f32', 'a')
 *    ('i2i1', ('i2i64', 'a@1')) => a
 *    ('u2u1', ('u2u64', 'a@1')) => a
 *    ('u2f64', ('u2u8', 'a@1')) => ('u2f64', 'a')
 *    ('i2f64', ('i2i8', 'a@1')) => ('i2f64', 'a')
 *    ('u2f64', ('u2u16', 'a@1')) => ('u2f64', 'a')
 *    ('i2f64', ('i2i16', 'a@1')) => ('i2f64', 'a')
 *    ('u2f64', ('u2u32', 'a@1')) => ('u2f64', 'a')
 *    ('i2f64', ('i2i32', 'a@1')) => ('i2f64', 'a')
 *    ('u2f64', ('u2u64', 'a@1')) => ('u2f64', 'a')
 *    ('i2f64', ('i2i64', 'a@1')) => ('i2f64', 'a')
 *    ('i2i8', ('i2i16', 'a@8')) => a
 *    ('u2u8', ('u2u16', 'a@8')) => a
 *    ('u2f16', ('u2u16', 'a@8')) => ('u2f16', 'a')
 *    ('i2f16', ('i2i16', 'a@8')) => ('i2f16', 'a')
 *    ('u2f16', ('u2u32', 'a@8')) => ('u2f16', 'a')
 *    ('i2f16', ('i2i32', 'a@8')) => ('i2f16', 'a')
 *    ('u2f16', ('u2u64', 'a@8')) => ('u2f16', 'a')
 *    ('i2f16', ('i2i64', 'a@8')) => ('i2f16', 'a')
 *    ('i2i8', ('i2i32', 'a@8')) => a
 *    ('u2u8', ('u2u32', 'a@8')) => a
 *    ('u2f32', ('u2u16', 'a@8')) => ('u2f32', 'a')
 *    ('i2f32', ('i2i16', 'a@8')) => ('i2f32', 'a')
 *    ('u2f32', ('u2u32', 'a@8')) => ('u2f32', 'a')
 *    ('i2f32', ('i2i32', 'a@8')) => ('i2f32', 'a')
 *    ('u2f32', ('u2u64', 'a@8')) => ('u2f32', 'a')
 *    ('i2f32', ('i2i64', 'a@8')) => ('i2f32', 'a')
 *    ('i2i8', ('i2i64', 'a@8')) => a
 *    ('u2u8', ('u2u64', 'a@8')) => a
 *    ('u2f64', ('u2u16', 'a@8')) => ('u2f64', 'a')
 *    ('i2f64', ('i2i16', 'a@8')) => ('i2f64', 'a')
 *    ('u2f64', ('u2u32', 'a@8')) => ('u2f64', 'a')
 *    ('i2f64', ('i2i32', 'a@8')) => ('i2f64', 'a')
 *    ('u2f64', ('u2u64', 'a@8')) => ('u2f64', 'a')
 *    ('i2f64', ('i2i64', 'a@8')) => ('i2f64', 'a')
 *    ('i2i16', ('i2i32', 'a@16')) => a
 *    ('u2u16', ('u2u32', 'a@16')) => a
 *    ('u2f32', ('u2u32', 'a@16')) => ('u2f32', 'a')
 *    ('i2f32', ('i2i32', 'a@16')) => ('i2f32', 'a')
 *    ('u2f32', ('u2u64', 'a@16')) => ('u2f32', 'a')
 *    ('i2f32', ('i2i64', 'a@16')) => ('i2f32', 'a')
 *    ('i2i16', ('i2i64', 'a@16')) => a
 *    ('u2u16', ('u2u64', 'a@16')) => a
 *    ('u2f64', ('u2u32', 'a@16')) => ('u2f64', 'a')
 *    ('i2f64', ('i2i32', 'a@16')) => ('i2f64', 'a')
 *    ('u2f64', ('u2u64', 'a@16')) => ('u2f64', 'a')
 *    ('i2f64', ('i2i64', 'a@16')) => ('i2f64', 'a')
 *    ('i2i32', ('i2i64', 'a@32')) => a
 *    ('u2u32', ('u2u64', 'a@32')) => a
 *    ('u2f64', ('u2u64', 'a@32')) => ('u2f64', 'a')
 *    ('i2f64', ('i2i64', 'a@32')) => ('i2f64', 'a')
 *    ('f2fmp', ('u2f32', 'a@32')) => ('u2fmp', 'a')
 *    ('f2fmp', ('i2f32', 'a@32')) => ('i2fmp', 'a')
 *    ('f2u16', ('f2fmp', 'a@32')) => ('f2u16', 'a')
 *    ('f2i16', ('f2fmp', 'a@32')) => ('f2i16', 'a')
 *    ('i2imp', ('f2u32', 'a@32')) => ('f2ump', 'a')
 *    ('i2imp', ('f2i32', 'a@32')) => ('f2imp', 'a')
 *    ('u2f16', ('i2imp', 'a@32')) => ('u2f16', 'a')
 *    ('i2f16', ('i2imp', 'a@32')) => ('i2f16', 'a')
 *    ('iand', ('u2u16', ('u2u8', 'a@16')), '#b') => ('iand', 'a', ('iand', 'b', 255))
 *    ('u2u16', ('u2u8(is_used_once)', ('iand', 'a@16', '#b'))) => ('iand', 'a', ('iand', 'b', 255))
 *    ('u2u8', ('iand', ('u2u16', ('u2u8', 'a@16')), ('u2u16', ('u2u8', 'b@16')))) => ('u2u8', ('iand', 'a', 'b'))
 *    ('u2u8', ('iand', ('u2u16', ('u2u8', 'a@32')), ('u2u16', ('u2u8', 'b@32')))) => ('u2u8', ('iand', 'a', 'b'))
 *    ('iand', ('extract_i8', 'a', '#b'), ('extract_i8', 'c', 'b')) => ('extract_i8', ('iand', 'a', 'c'), 'b')
 *    ('iand', ('extract_u8', 'a', '#b'), ('extract_u8', 'c', 'b')) => ('extract_u8', ('iand', 'a', 'c'), 'b')
 *    ('iand', ('extract_i16', 'a', '#b'), ('extract_i16', 'c', 'b')) => ('extract_i16', ('iand', 'a', 'c'), 'b')
 *    ('iand', ('extract_u16', 'a', '#b'), ('extract_u16', 'c', 'b')) => ('extract_u16', ('iand', 'a', 'c'), 'b')
 *    ('iand', ('ushr(is_used_once)', 'a', '#b'), ('ushr', 'c', 'b')) => ('ushr', ('iand', 'a', 'c'), 'b')
 *    ('iand', ('ishr(is_used_once)', 'a', '#b'), ('ishr', 'c', 'b')) => ('ishr', ('iand', 'a', 'c'), 'b')
 *    ('iand', ('ishl(is_used_once)', 'a', '#b'), ('ishl', 'c', 'b')) => ('ishl', ('iand', 'a', 'c'), 'b')
 *    ('u2u8', ('ior', ('u2u16', ('u2u8', 'a@16')), ('u2u16', ('u2u8', 'b@16')))) => ('u2u8', ('ior', 'a', 'b'))
 *    ('u2u8', ('ior', ('u2u16', ('u2u8', 'a@32')), ('u2u16', ('u2u8', 'b@32')))) => ('u2u8', ('ior', 'a', 'b'))
 *    ('ior', ('extract_i8', 'a', '#b'), ('extract_i8', 'c', 'b')) => ('extract_i8', ('ior', 'a', 'c'), 'b')
 *    ('ior', ('extract_u8', 'a', '#b'), ('extract_u8', 'c', 'b')) => ('extract_u8', ('ior', 'a', 'c'), 'b')
 *    ('ior', ('extract_i16', 'a', '#b'), ('extract_i16', 'c', 'b')) => ('extract_i16', ('ior', 'a', 'c'), 'b')
 *    ('ior', ('extract_u16', 'a', '#b'), ('extract_u16', 'c', 'b')) => ('extract_u16', ('ior', 'a', 'c'), 'b')
 *    ('ior', ('ushr(is_used_once)', 'a', '#b'), ('ushr', 'c', 'b')) => ('ushr', ('ior', 'a', 'c'), 'b')
 *    ('ior', ('ishr(is_used_once)', 'a', '#b'), ('ishr', 'c', 'b')) => ('ishr', ('ior', 'a', 'c'), 'b')
 *    ('ior', ('ishl(is_used_once)', 'a', '#b'), ('ishl', 'c', 'b')) => ('ishl', ('ior', 'a', 'c'), 'b')
 *    ('u2u8', ('ixor', ('u2u16', ('u2u8', 'a@16')), ('u2u16', ('u2u8', 'b@16')))) => ('u2u8', ('ixor', 'a', 'b'))
 *    ('u2u8', ('ixor', ('u2u16', ('u2u8', 'a@32')), ('u2u16', ('u2u8', 'b@32')))) => ('u2u8', ('ixor', 'a', 'b'))
 *    ('ixor', ('extract_i8', 'a', '#b'), ('extract_i8', 'c', 'b')) => ('extract_i8', ('ixor', 'a', 'c'), 'b')
 *    ('ixor', ('extract_u8', 'a', '#b'), ('extract_u8', 'c', 'b')) => ('extract_u8', ('ixor', 'a', 'c'), 'b')
 *    ('ixor', ('extract_i16', 'a', '#b'), ('extract_i16', 'c', 'b')) => ('extract_i16', ('ixor', 'a', 'c'), 'b')
 *    ('ixor', ('extract_u16', 'a', '#b'), ('extract_u16', 'c', 'b')) => ('extract_u16', ('ixor', 'a', 'c'), 'b')
 *    ('ixor', ('ushr(is_used_once)', 'a', '#b'), ('ushr', 'c', 'b')) => ('ushr', ('ixor', 'a', 'c'), 'b')
 *    ('ixor', ('ishr(is_used_once)', 'a', '#b'), ('ishr', 'c', 'b')) => ('ishr', ('ixor', 'a', 'c'), 'b')
 *    ('ixor', ('ishl(is_used_once)', 'a', '#b'), ('ishl', 'c', 'b')) => ('ishl', ('ixor', 'a', 'c'), 'b')
 *    ('iand', ('ieq', 'a@8', 0), ('ieq', 'b@8', 0)) => ('ieq', ('ior', 'a', 'b'), 0)
 *    ('ior', ('ine', 'a@8', 0), ('ine', 'b@8', 0)) => ('ine', ('ior', 'a', 'b'), 0)
 *    ('iand', ('ieq', 'a@8', 0), ('ieq', 'b@8', 0)) => ('ieq', ('umax', 'a', 'b'), 0)
 *    ('ior', ('ieq', 'a@8', 0), ('ieq', 'b@8', 0)) => ('ieq', ('umin', 'a', 'b'), 0)
 *    ('iand', ('ine', 'a@8', 0), ('ine', 'b@8', 0)) => ('ine', ('umin', 'a', 'b'), 0)
 *    ('ior', ('ine', 'a@8', 0), ('ine', 'b@8', 0)) => ('ine', ('umax', 'a', 'b'), 0)
 *    ('bcsel', ('ult', 'b@8', 'a'), 'b', 'a') => ('umin', 'a', 'b')
 *    ('bcsel', ('ult', 'a@8', 'b'), 'b', 'a') => ('umax', 'a', 'b')
 *    ('bcsel', ('uge', 'a@8', 'b'), 'b', 'a') => ('umin', 'a', 'b')
 *    ('bcsel', ('uge', 'b@8', 'a'), 'b', 'a') => ('umax', 'a', 'b')
 *    ('bcsel', ('ilt', 'b@8', 'a'), 'b', 'a') => ('imin', 'a', 'b')
 *    ('bcsel', ('ilt', 'a@8', 'b'), 'b', 'a') => ('imax', 'a', 'b')
 *    ('bcsel', ('ige', 'a@8', 'b'), 'b', 'a') => ('imin', 'a', 'b')
 *    ('bcsel', ('ige', 'b@8', 'a'), 'b', 'a') => ('imax', 'a', 'b')
 *    ('ineg', ('b2i8', 'a@8')) => a
 *    ('ishl', 'a@8', ('iand', 7, 'b')) => ('ishl', 'a', 'b')
 *    ('ishr', 'a@8', ('iand', 7, 'b')) => ('ishr', 'a', 'b')
 *    ('ushr', 'a@8', ('iand', 7, 'b')) => ('ushr', 'a', 'b')
 *    ('ushr', 'a@8', ('ishl(is_used_once)', ('iand', 'b', 1), 2)) => ('ushr', 'a', ('ishl', 'b', 2))
 *    ('ushr', 'a@8', ('ishl(is_used_once)', ('iand', 'b', 3), 1)) => ('ushr', 'a', ('ishl', 'b', 1))
 *    ('iand', ('ieq', 'a@16', 0), ('ieq', 'b@16', 0)) => ('ieq', ('ior', 'a', 'b'), 0)
 *    ('ior', ('ine', 'a@16', 0), ('ine', 'b@16', 0)) => ('ine', ('ior', 'a', 'b'), 0)
 *    ('iand', ('ieq', 'a@16', 0), ('ieq', 'b@16', 0)) => ('ieq', ('umax', 'a', 'b'), 0)
 *    ('ior', ('ieq', 'a@16', 0), ('ieq', 'b@16', 0)) => ('ieq', ('umin', 'a', 'b'), 0)
 *    ('iand', ('ine', 'a@16', 0), ('ine', 'b@16', 0)) => ('ine', ('umin', 'a', 'b'), 0)
 *    ('ior', ('ine', 'a@16', 0), ('ine', 'b@16', 0)) => ('ine', ('umax', 'a', 'b'), 0)
 *    ('bcsel', ('ult', 'b@16', 'a'), 'b', 'a') => ('umin', 'a', 'b')
 *    ('bcsel', ('ult', 'a@16', 'b'), 'b', 'a') => ('umax', 'a', 'b')
 *    ('bcsel', ('uge', 'a@16', 'b'), 'b', 'a') => ('umin', 'a', 'b')
 *    ('bcsel', ('uge', 'b@16', 'a'), 'b', 'a') => ('umax', 'a', 'b')
 *    ('bcsel', ('ilt', 'b@16', 'a'), 'b', 'a') => ('imin', 'a', 'b')
 *    ('bcsel', ('ilt', 'a@16', 'b'), 'b', 'a') => ('imax', 'a', 'b')
 *    ('bcsel', ('ige', 'a@16', 'b'), 'b', 'a') => ('imin', 'a', 'b')
 *    ('bcsel', ('ige', 'b@16', 'a'), 'b', 'a') => ('imax', 'a', 'b')
 *    ('ineg', ('b2i16', 'a@16')) => a
 *    ('ishl', 'a@16', ('iand', 15, 'b')) => ('ishl', 'a', 'b')
 *    ('ishr', 'a@16', ('iand', 15, 'b')) => ('ishr', 'a', 'b')
 *    ('ushr', 'a@16', ('iand', 15, 'b')) => ('ushr', 'a', 'b')
 *    ('ushr', 'a@16', ('ishl(is_used_once)', ('iand', 'b', 1), 3)) => ('ushr', 'a', ('ishl', 'b', 3))
 *    ('ushr', 'a@16', ('ishl(is_used_once)', ('iand', 'b', 3), 2)) => ('ushr', 'a', ('ishl', 'b', 2))
 *    ('iand', ('ieq', 'a@32', 0), ('ieq', 'b@32', 0)) => ('ieq', ('ior', 'a', 'b'), 0)
 *    ('ior', ('ine', 'a@32', 0), ('ine', 'b@32', 0)) => ('ine', ('ior', 'a', 'b'), 0)
 *    ('iand', ('ieq', 'a@32', 0), ('ieq', 'b@32', 0)) => ('ieq', ('umax', 'a', 'b'), 0)
 *    ('ior', ('ieq', 'a@32', 0), ('ieq', 'b@32', 0)) => ('ieq', ('umin', 'a', 'b'), 0)
 *    ('iand', ('ine', 'a@32', 0), ('ine', 'b@32', 0)) => ('ine', ('umin', 'a', 'b'), 0)
 *    ('ior', ('ine', 'a@32', 0), ('ine', 'b@32', 0)) => ('ine', ('umax', 'a', 'b'), 0)
 *    ('bcsel', ('ult', 'b@32', 'a'), 'b', 'a') => ('umin', 'a', 'b')
 *    ('bcsel', ('ult', 'a@32', 'b'), 'b', 'a') => ('umax', 'a', 'b')
 *    ('bcsel', ('uge', 'a@32', 'b'), 'b', 'a') => ('umin', 'a', 'b')
 *    ('bcsel', ('uge', 'b@32', 'a'), 'b', 'a') => ('umax', 'a', 'b')
 *    ('bcsel', ('ilt', 'b@32', 'a'), 'b', 'a') => ('imin', 'a', 'b')
 *    ('bcsel', ('ilt', 'a@32', 'b'), 'b', 'a') => ('imax', 'a', 'b')
 *    ('bcsel', ('ige', 'a@32', 'b'), 'b', 'a') => ('imin', 'a', 'b')
 *    ('bcsel', ('ige', 'b@32', 'a'), 'b', 'a') => ('imax', 'a', 'b')
 *    ('ineg', ('b2i32', 'a@32')) => a
 *    ('ishl', 'a@32', ('iand', 31, 'b')) => ('ishl', 'a', 'b')
 *    ('ishr', 'a@32', ('iand', 31, 'b')) => ('ishr', 'a', 'b')
 *    ('ushr', 'a@32', ('iand', 31, 'b')) => ('ushr', 'a', 'b')
 *    ('ushr', 'a@32', ('ishl(is_used_once)', ('iand', 'b', 1), 4)) => ('ushr', 'a', ('ishl', 'b', 4))
 *    ('ushr', 'a@32', ('ishl(is_used_once)', ('iand', 'b', 3), 3)) => ('ushr', 'a', ('ishl', 'b', 3))
 *    ('iand', ('ieq', 'a@64', 0), ('ieq', 'b@64', 0)) => ('ieq', ('ior', 'a', 'b'), 0)
 *    ('ior', ('ine', 'a@64', 0), ('ine', 'b@64', 0)) => ('ine', ('ior', 'a', 'b'), 0)
 *    ('iand', ('ieq', 'a@64', 0), ('ieq', 'b@64', 0)) => ('ieq', ('umax', 'a', 'b'), 0)
 *    ('ior', ('ieq', 'a@64', 0), ('ieq', 'b@64', 0)) => ('ieq', ('umin', 'a', 'b'), 0)
 *    ('iand', ('ine', 'a@64', 0), ('ine', 'b@64', 0)) => ('ine', ('umin', 'a', 'b'), 0)
 *    ('ior', ('ine', 'a@64', 0), ('ine', 'b@64', 0)) => ('ine', ('umax', 'a', 'b'), 0)
 *    ('bcsel', ('ult', 'b@64', 'a'), 'b', 'a') => ('umin', 'a', 'b')
 *    ('bcsel', ('ult', 'a@64', 'b'), 'b', 'a') => ('umax', 'a', 'b')
 *    ('bcsel', ('uge', 'a@64', 'b'), 'b', 'a') => ('umin', 'a', 'b')
 *    ('bcsel', ('uge', 'b@64', 'a'), 'b', 'a') => ('umax', 'a', 'b')
 *    ('bcsel', ('ilt', 'b@64', 'a'), 'b', 'a') => ('imin', 'a', 'b')
 *    ('bcsel', ('ilt', 'a@64', 'b'), 'b', 'a') => ('imax', 'a', 'b')
 *    ('bcsel', ('ige', 'a@64', 'b'), 'b', 'a') => ('imin', 'a', 'b')
 *    ('bcsel', ('ige', 'b@64', 'a'), 'b', 'a') => ('imax', 'a', 'b')
 *    ('ineg', ('b2i64', 'a@64')) => a
 *    ('ishl', 'a@64', ('iand', 63, 'b')) => ('ishl', 'a', 'b')
 *    ('ishr', 'a@64', ('iand', 63, 'b')) => ('ishr', 'a', 'b')
 *    ('ushr', 'a@64', ('iand', 63, 'b')) => ('ushr', 'a', 'b')
 *    ('ushr', 'a@64', ('ishl(is_used_once)', ('iand', 'b', 1), 5)) => ('ushr', 'a', ('ishl', 'b', 5))
 *    ('ushr', 'a@64', ('ishl(is_used_once)', ('iand', 'b', 3), 4)) => ('ushr', 'a', ('ishl', 'b', 4))
 *    ('ior', ('ieq', 'a', 0), ('ieq', 'a', 1)) => ('uge', 1, 'a')
 *    ('ior', ('uge', 1, 'a'), ('ieq', 'a', 2)) => ('uge', 2, 'a')
 *    ('ior', ('uge', 2, 'a'), ('ieq', 'a', 3)) => ('uge', 3, 'a')
 *    ('ior', 'a', ('ieq', 'a', False)) => True
 *    ('ine', ('ineg', ('b2i', 'a@1')), ('ineg', ('b2i', 'b@1'))) => ('ine', 'a', 'b')
 *    ('b2i', ('ine', 'a@1', 'b@1')) => ('b2i', ('ixor', 'a', 'b'))
 *    ('ishl', ('b2i32', ('ine', ('iand', 'a@32', '#b(is_pos_power_of_two)'), 0)), '#c') => ('bcsel', ('ige', ('iand', 'c', 31), ('find_lsb', 'b')), ('ishl', ('iand', 'a', 'b'), ('iadd', ('iand', 'c', 31), ('ineg', ('find_lsb', 'b')))), ('ushr', ('iand', 'a', 'b'), ('iadd', ('ineg', ('iand', 'c', 31)), ('find_lsb', 'b'))))
 *    ('b2i32', ('ine', ('iand', 'a@32', '#b(is_pos_power_of_two)'), 0)) => ('ushr', ('iand', 'a', 'b'), ('find_lsb', 'b'))
 *    ('ior', ('b2i', 'a'), ('iand', 'b', 1)) => ('iand', ('ior', ('b2i', 'a'), 'b'), 1)
 *    ('iand', ('b2i', 'a'), ('iand', 'b', 1)) => ('iand', ('b2i', 'a'), 'b')
 *    ('iand', ('inot', ('iand', ('ior', ('ieq', 'a', 0), 'b'), 'c')), ('ilt', 'a', 0)) => ('iand', ('inot', ('iand', 'b', 'c')), ('ilt', 'a', 0))
 *    ('iand', ('inot', ('iand', ('ieq', ('umin', 'a', 'b'), 0), 'c')), ('ilt', 'a', 0)) => ('iand', ('inot', ('iand', ('ieq', 'b', 0), 'c')), ('ilt', 'a', 0))
 *    ('flt', 'a', ('fmax', 'b', 'a')) => ('flt', 'a', 'b')
 *    ('flt', ('fmin', 'a', 'b'), 'a') => ('flt', 'b', 'a')
 *    ('~fge', 'a', ('fmin', 'b', 'a')) => True
 *    ('~fge', ('fmax', 'a', 'b'), 'a') => True
 *    ('flt', 'a', ('fmin', 'b', 'a')) => False
 *    ('flt', ('fmax', 'a', 'b'), 'a') => False
 *    ('~fge', 'a', ('fmax', 'b', 'a')) => ('fge', 'a', 'b')
 *    ('~fge', ('fmin', 'a', 'b'), 'a') => ('fge', 'b', 'a')
 *    ('ilt', 'a', ('imax', 'b', 'a')) => ('ilt', 'a', 'b')
 *    ('ilt', ('imin', 'a', 'b'), 'a') => ('ilt', 'b', 'a')
 *    ('ige', 'a', ('imin', 'b', 'a')) => True
 *    ('ige', ('imax', 'a', 'b'), 'a') => True
 *    ('ult', 'a', ('umax', 'b', 'a')) => ('ult', 'a', 'b')
 *    ('ult', ('umin', 'a', 'b'), 'a') => ('ult', 'b', 'a')
 *    ('uge', 'a', ('umin', 'b', 'a')) => True
 *    ('uge', ('umax', 'a', 'b'), 'a') => True
 *    ('ilt', 'a', ('imin', 'b', 'a')) => False
 *    ('ilt', ('imax', 'a', 'b'), 'a') => False
 *    ('ige', 'a', ('imax', 'b', 'a')) => ('ige', 'a', 'b')
 *    ('ige', ('imin', 'a', 'b'), 'a') => ('ige', 'b', 'a')
 *    ('ult', 'a', ('umin', 'b', 'a')) => False
 *    ('ult', ('umax', 'a', 'b'), 'a') => False
 *    ('uge', 'a', ('umax', 'b', 'a')) => ('uge', 'a', 'b')
 *    ('uge', ('umin', 'a', 'b'), 'a') => ('uge', 'b', 'a')
 *    ('ult', 'a', ('iand', 'b', 'a')) => False
 *    ('ult', ('ior', 'a', 'b'), 'a') => False
 *    ('uge', 'a', ('iand', 'b', 'a')) => True
 *    ('uge', ('ior', 'a', 'b'), 'a') => True
 *    ('ilt', '#a', ('imax', '#b', 'c')) => ('ior', ('ilt', 'a', 'b'), ('ilt', 'a', 'c'))
 *    ('ilt', ('imin', '#a', 'b'), '#c') => ('ior', ('ilt', 'a', 'c'), ('ilt', 'b', 'c'))
 *    ('ige', '#a', ('imin', '#b', 'c')) => ('ior', ('ige', 'a', 'b'), ('ige', 'a', 'c'))
 *    ('ige', ('imax', '#a', 'b'), '#c') => ('ior', ('ige', 'a', 'c'), ('ige', 'b', 'c'))
 *    ('ult', '#a', ('umax', '#b', 'c')) => ('ior', ('ult', 'a', 'b'), ('ult', 'a', 'c'))
 *    ('ult', ('umin', '#a', 'b'), '#c') => ('ior', ('ult', 'a', 'c'), ('ult', 'b', 'c'))
 *    ('uge', '#a', ('umin', '#b', 'c')) => ('ior', ('uge', 'a', 'b'), ('uge', 'a', 'c'))
 *    ('uge', ('umax', '#a', 'b'), '#c') => ('ior', ('uge', 'a', 'c'), ('uge', 'b', 'c'))
 *    ('ilt', '#a', ('imin', '#b', 'c')) => ('iand', ('ilt', 'a', 'b'), ('ilt', 'a', 'c'))
 *    ('ilt', ('imax', '#a', 'b'), '#c') => ('iand', ('ilt', 'a', 'c'), ('ilt', 'b', 'c'))
 *    ('ige', '#a', ('imax', '#b', 'c')) => ('iand', ('ige', 'a', 'b'), ('ige', 'a', 'c'))
 *    ('ige', ('imin', '#a', 'b'), '#c') => ('iand', ('ige', 'a', 'c'), ('ige', 'b', 'c'))
 *    ('ult', '#a', ('umin', '#b', 'c')) => ('iand', ('ult', 'a', 'b'), ('ult', 'a', 'c'))
 *    ('ult', ('umax', '#a', 'b'), '#c') => ('iand', ('ult', 'a', 'c'), ('ult', 'b', 'c'))
 *    ('uge', '#a', ('umax', '#b', 'c')) => ('iand', ('uge', 'a', 'b'), ('uge', 'a', 'c'))
 *    ('uge', ('umin', '#a', 'b'), '#c') => ('iand', ('uge', 'a', 'c'), ('uge', 'b', 'c'))
 *    ('bcsel', ('ilt', 'a', 0), ('ineg', ('ishr', 'a', 'b')), ('ishr', 'a', 'b')) => ('iabs', ('ishr', 'a', 'b'))
 *    ('iabs', ('ishr', ('iabs', 'a'), 'b')) => ('ishr', ('iabs', 'a'), 'b')
 *    ('fabs', ('slt', 'a', 'b')) => ('slt', 'a', 'b')
 *    ('fabs', ('sge', 'a', 'b')) => ('sge', 'a', 'b')
 *    ('fabs', ('seq', 'a', 'b')) => ('seq', 'a', 'b')
 *    ('fabs', ('sne', 'a', 'b')) => ('sne', 'a', 'b')
 *    ('slt', 'a', 'b') => ('b2f', ('flt', 'a', 'b'))
 *    ('sge', 'a', 'b') => ('b2f', ('fge', 'a', 'b'))
 *    ('seq', 'a', 'b') => ('b2f', ('feq', 'a', 'b'))
 *    ('sne', 'a', 'b') => ('b2f', ('fneu', 'a', 'b'))
 *    ('seq', ('seq', 'a', 'b'), 1.0) => ('seq', 'a', 'b')
 *    ('seq', ('sne', 'a', 'b'), 1.0) => ('sne', 'a', 'b')
 *    ('seq', ('slt', 'a', 'b'), 1.0) => ('slt', 'a', 'b')
 *    ('seq', ('sge', 'a', 'b'), 1.0) => ('sge', 'a', 'b')
 *    ('sne', ('seq', 'a', 'b'), 0.0) => ('seq', 'a', 'b')
 *    ('sne', ('sne', 'a', 'b'), 0.0) => ('sne', 'a', 'b')
 *    ('sne', ('slt', 'a', 'b'), 0.0) => ('slt', 'a', 'b')
 *    ('sne', ('sge', 'a', 'b'), 0.0) => ('sge', 'a', 'b')
 *    ('seq', ('seq', 'a', 'b'), 0.0) => ('sne', 'a', 'b')
 *    ('seq', ('sne', 'a', 'b'), 0.0) => ('seq', 'a', 'b')
 *    ('seq', ('slt', 'a', 'b'), 0.0) => ('sge', 'a', 'b')
 *    ('seq', ('sge', 'a', 'b'), 0.0) => ('slt', 'a', 'b')
 *    ('sne', ('seq', 'a', 'b'), 1.0) => ('sne', 'a', 'b')
 *    ('sne', ('sne', 'a', 'b'), 1.0) => ('seq', 'a', 'b')
 *    ('sne', ('slt', 'a', 'b'), 1.0) => ('sge', 'a', 'b')
 *    ('sne', ('sge', 'a', 'b'), 1.0) => ('slt', 'a', 'b')
 *    ('fall_equal2', 'a', 'b') => ('fmin', ('seq', 'a.x', 'b.x'), ('seq', 'a.y', 'b.y'))
 *    ('fall_equal3', 'a', 'b') => ('seq', ('fany_nequal3', 'a', 'b'), 0.0)
 *    ('fall_equal4', 'a', 'b') => ('seq', ('fany_nequal4', 'a', 'b'), 0.0)
 *    ('fall_equal8', 'a', 'b') => ('seq', ('fany_nequal8', 'a', 'b'), 0.0)
 *    ('fall_equal16', 'a', 'b') => ('seq', ('fany_nequal16', 'a', 'b'), 0.0)
 *    ('fany_nequal2', 'a', 'b') => ('fmax', ('sne', 'a.x', 'b.x'), ('sne', 'a.y', 'b.y'))
 *    ('fany_nequal3', 'a', 'b') => ('fsat', ('fdot3', ('sne', 'a', 'b'), ('sne', 'a', 'b')))
 *    ('fany_nequal4', 'a', 'b') => ('fsat', ('fdot4', ('sne', 'a', 'b'), ('sne', 'a', 'b')))
 *    ('fany_nequal8', 'a', 'b') => ('fsat', ('fdot8', ('sne', 'a', 'b'), ('sne', 'a', 'b')))
 *    ('fany_nequal16', 'a', 'b') => ('fsat', ('fdot16', ('sne', 'a', 'b'), ('sne', 'a', 'b')))
 *    ('ball_iequal2', 'a', 'b') => ('iand', ('ieq', 'a.x', 'b.x'), ('ieq', 'a.y', 'b.y'))
 *    ('ball_iequal3', 'a', 'b') => ('iand', ('ieq', 'a.x', 'b.x'), ('iand', ('ieq', 'a.y', 'b.y'), ('ieq', 'a.z', 'b.z')))
 *    ('ball_iequal4', 'a', 'b') => ('iand', ('iand', ('ieq', 'a.x', 'b.x'), ('ieq', 'a.y', 'b.y')), ('iand', ('ieq', 'a.z', 'b.z'), ('ieq', 'a.w', 'b.w')))
 *    ('ball_iequal8', 'a', 'b') => ('iand', ('iand', ('iand', ('ieq', 'a.a', 'b.a'), ('ieq', 'a.b', 'b.b')), ('iand', ('ieq', 'a.c', 'b.c'), ('ieq', 'a.d', 'b.d'))), ('iand', ('iand', ('ieq', 'a.e', 'b.e'), ('ieq', 'a.f', 'b.f')), ('iand', ('ieq', 'a.g', 'b.g'), ('ieq', 'a.h', 'b.h'))))
 *    ('ball_iequal16', 'a', 'b') => ('iand', ('iand', ('iand', ('iand', ('ieq', 'a.a', 'b.a'), ('ieq', 'a.b', 'b.b')), ('iand', ('ieq', 'a.c', 'b.c'), ('ieq', 'a.d', 'b.d'))), ('iand', ('iand', ('ieq', 'a.e', 'b.e'), ('ieq', 'a.f', 'b.f')), ('iand', ('ieq', 'a.g', 'b.g'), ('ieq', 'a.h', 'b.h')))), ('iand', ('iand', ('iand', ('ieq', 'a.i', 'b.i'), ('ieq', 'a.j', 'b.j')), ('iand', ('ieq', 'a.k', 'b.k'), ('ieq', 'a.l', 'b.l'))), ('iand', ('iand', ('ieq', 'a.m', 'b.m'), ('ieq', 'a.n', 'b.n')), ('iand', ('ieq', 'a.o', 'b.o'), ('ieq', 'a.p', 'b.p')))))
 *    ('ball_fequal2', 'a', 'b') => ('iand', ('feq', 'a.x', 'b.x'), ('feq', 'a.y', 'b.y'))
 *    ('ball_fequal3', 'a', 'b') => ('iand', ('feq', 'a.x', 'b.x'), ('iand', ('feq', 'a.y', 'b.y'), ('feq', 'a.z', 'b.z')))
 *    ('ball_fequal4', 'a', 'b') => ('iand', ('iand', ('feq', 'a.x', 'b.x'), ('feq', 'a.y', 'b.y')), ('iand', ('feq', 'a.z', 'b.z'), ('feq', 'a.w', 'b.w')))
 *    ('ball_fequal8', 'a', 'b') => ('iand', ('iand', ('iand', ('feq', 'a.a', 'b.a'), ('feq', 'a.b', 'b.b')), ('iand', ('feq', 'a.c', 'b.c'), ('feq', 'a.d', 'b.d'))), ('iand', ('iand', ('feq', 'a.e', 'b.e'), ('feq', 'a.f', 'b.f')), ('iand', ('feq', 'a.g', 'b.g'), ('feq', 'a.h', 'b.h'))))
 *    ('ball_fequal16', 'a', 'b') => ('iand', ('iand', ('iand', ('iand', ('feq', 'a.a', 'b.a'), ('feq', 'a.b', 'b.b')), ('iand', ('feq', 'a.c', 'b.c'), ('feq', 'a.d', 'b.d'))), ('iand', ('iand', ('feq', 'a.e', 'b.e'), ('feq', 'a.f', 'b.f')), ('iand', ('feq', 'a.g', 'b.g'), ('feq', 'a.h', 'b.h')))), ('iand', ('iand', ('iand', ('feq', 'a.i', 'b.i'), ('feq', 'a.j', 'b.j')), ('iand', ('feq', 'a.k', 'b.k'), ('feq', 'a.l', 'b.l'))), ('iand', ('iand', ('feq', 'a.m', 'b.m'), ('feq', 'a.n', 'b.n')), ('iand', ('feq', 'a.o', 'b.o'), ('feq', 'a.p', 'b.p')))))
 *    ('bany_inequal2', 'a', 'b') => ('ior', ('ine', 'a.x', 'b.x'), ('ine', 'a.y', 'b.y'))
 *    ('bany_inequal3', 'a', 'b') => ('ior', ('ine', 'a.x', 'b.x'), ('ior', ('ine', 'a.y', 'b.y'), ('ine', 'a.z', 'b.z')))
 *    ('bany_inequal4', 'a', 'b') => ('ior', ('ior', ('ine', 'a.x', 'b.x'), ('ine', 'a.y', 'b.y')), ('ior', ('ine', 'a.z', 'b.z'), ('ine', 'a.w', 'b.w')))
 *    ('bany_inequal8', 'a', 'b') => ('ior', ('ior', ('ior', ('ine', 'a.a', 'b.a'), ('ine', 'a.b', 'b.b')), ('ior', ('ine', 'a.c', 'b.c'), ('ine', 'a.d', 'b.d'))), ('ior', ('ior', ('ine', 'a.e', 'b.e'), ('ine', 'a.f', 'b.f')), ('ior', ('ine', 'a.g', 'b.g'), ('ine', 'a.h', 'b.h'))))
 *    ('bany_inequal16', 'a', 'b') => ('ior', ('ior', ('ior', ('ior', ('ine', 'a.a', 'b.a'), ('ine', 'a.b', 'b.b')), ('ior', ('ine', 'a.c', 'b.c'), ('ine', 'a.d', 'b.d'))), ('ior', ('ior', ('ine', 'a.e', 'b.e'), ('ine', 'a.f', 'b.f')), ('ior', ('ine', 'a.g', 'b.g'), ('ine', 'a.h', 'b.h')))), ('ior', ('ior', ('ior', ('ine', 'a.i', 'b.i'), ('ine', 'a.j', 'b.j')), ('ior', ('ine', 'a.k', 'b.k'), ('ine', 'a.l', 'b.l'))), ('ior', ('ior', ('ine', 'a.m', 'b.m'), ('ine', 'a.n', 'b.n')), ('ior', ('ine', 'a.o', 'b.o'), ('ine', 'a.p', 'b.p')))))
 *    ('bany_fnequal2', 'a', 'b') => ('ior', ('fneu', 'a.x', 'b.x'), ('fneu', 'a.y', 'b.y'))
 *    ('bany_fnequal3', 'a', 'b') => ('ior', ('fneu', 'a.x', 'b.x'), ('ior', ('fneu', 'a.y', 'b.y'), ('fneu', 'a.z', 'b.z')))
 *    ('bany_fnequal4', 'a', 'b') => ('ior', ('ior', ('fneu', 'a.x', 'b.x'), ('fneu', 'a.y', 'b.y')), ('ior', ('fneu', 'a.z', 'b.z'), ('fneu', 'a.w', 'b.w')))
 *    ('bany_fnequal8', 'a', 'b') => ('ior', ('ior', ('ior', ('fneu', 'a.a', 'b.a'), ('fneu', 'a.b', 'b.b')), ('ior', ('fneu', 'a.c', 'b.c'), ('fneu', 'a.d', 'b.d'))), ('ior', ('ior', ('fneu', 'a.e', 'b.e'), ('fneu', 'a.f', 'b.f')), ('ior', ('fneu', 'a.g', 'b.g'), ('fneu', 'a.h', 'b.h'))))
 *    ('bany_fnequal16', 'a', 'b') => ('ior', ('ior', ('ior', ('ior', ('fneu', 'a.a', 'b.a'), ('fneu', 'a.b', 'b.b')), ('ior', ('fneu', 'a.c', 'b.c'), ('fneu', 'a.d', 'b.d'))), ('ior', ('ior', ('fneu', 'a.e', 'b.e'), ('fneu', 'a.f', 'b.f')), ('ior', ('fneu', 'a.g', 'b.g'), ('fneu', 'a.h', 'b.h')))), ('ior', ('ior', ('ior', ('fneu', 'a.i', 'b.i'), ('fneu', 'a.j', 'b.j')), ('ior', ('fneu', 'a.k', 'b.k'), ('fneu', 'a.l', 'b.l'))), ('ior', ('ior', ('fneu', 'a.m', 'b.m'), ('fneu', 'a.n', 'b.n')), ('ior', ('fneu', 'a.o', 'b.o'), ('fneu', 'a.p', 'b.p')))))
 *    ('feq', ('seq', 'a', 'b'), 1.0) => ('feq', 'a', 'b')
 *    ('feq', ('sne', 'a', 'b'), 1.0) => ('fneu', 'a', 'b')
 *    ('feq', ('slt', 'a', 'b'), 1.0) => ('flt', 'a', 'b')
 *    ('feq', ('sge', 'a', 'b'), 1.0) => ('fge', 'a', 'b')
 *    ('fneu', ('seq', 'a', 'b'), 0.0) => ('feq', 'a', 'b')
 *    ('fneu', ('sne', 'a', 'b'), 0.0) => ('fneu', 'a', 'b')
 *    ('fneu', ('slt', 'a', 'b'), 0.0) => ('flt', 'a', 'b')
 *    ('fneu', ('sge', 'a', 'b'), 0.0) => ('fge', 'a', 'b')
 *    ('feq', ('seq', 'a', 'b'), 0.0) => ('fneu', 'a', 'b')
 *    ('feq', ('sne', 'a', 'b'), 0.0) => ('feq', 'a', 'b')
 *    ('feq', ('slt', 'a', 'b'), 0.0) => ('fge', 'a', 'b')
 *    ('feq', ('sge', 'a', 'b'), 0.0) => ('flt', 'a', 'b')
 *    ('fneu', ('seq', 'a', 'b'), 1.0) => ('fneu', 'a', 'b')
 *    ('fneu', ('sne', 'a', 'b'), 1.0) => ('feq', 'a', 'b')
 *    ('fneu', ('slt', 'a', 'b'), 1.0) => ('fge', 'a', 'b')
 *    ('fneu', ('sge', 'a', 'b'), 1.0) => ('flt', 'a', 'b')
 *    ('fneu', ('fneg', 'a'), 'a') => ('fneu', 'a', 0.0)
 *    ('feq', ('fneg', 'a'), 'a') => ('feq', 'a', 0.0)
 *    ('imul', ('b2i', 'a@1'), ('b2i', 'b@1')) => ('b2i', ('iand', 'a', 'b'))
 *    ('iand', ('b2i', 'a@1'), ('b2i', 'b@1')) => ('b2i', ('iand', 'a', 'b'))
 *    ('ior', ('b2i', 'a@1'), ('b2i', 'b@1')) => ('b2i', ('ior', 'a', 'b'))
 *    ('fmul', ('b2f', 'a@1'), ('b2f', 'b@1')) => ('b2f', ('iand', 'a', 'b'))
 *    ('fsat', ('fadd', ('b2f', 'a@1'), ('b2f', 'b@1'))) => ('b2f', ('ior', 'a', 'b'))
 *    ('iand', 'a@bool16', 1.0) => ('b2f', 'a')
 *    ('iand', 'a@bool32', 1.0) => ('b2f', 'a')
 *    ('flt', ('fneg', ('b2f', 'a@1')), 0) => a
 *    ('ilt', 'a', 'a') => False
 *    ('ige', 'a', 'a') => True
 *    ('ieq', 'a', 'a') => True
 *    ('ine', 'a', 'a') => False
 *    ('ult', 'a', 'a') => False
 *    ('uge', 'a', 'a') => True
 *    ('flt', 'a', 'a') => False
 *    ('fge', 'a(is_a_number)', 'a') => True
 *    ('feq', 'a(is_a_number)', 'a') => True
 *    ('fneu', 'a(is_a_number)', 'a') => False
 *    ('iand', 'a', 'a') => a
 *    ('iand', 'a', 0) => 0
 *    ('iand', 'a', -1) => a
 *    ('iand', 'a', ('inot', 'a')) => 0
 *    ('ior', 'a', 'a') => a
 *    ('ior', 'a', 0) => a
 *    ('ior', 'a', -1) => -1
 *    ('ior', 'a', ('inot', 'a')) => -1
 *    ('ixor', 'a', 'a') => 0
 *    ('ixor', 'a', 0) => a
 *    ('ixor', 'a', ('ixor', 'a', 'b')) => b
 *    ('ixor', 'a', -1) => ('inot', 'a')
 *    ('inot', ('inot', 'a')) => a
 *    ('ior', ('iand', 'a', 'b'), 'b') => b
 *    ('ior', ('ior', 'a', 'b'), 'b') => ('ior', 'a', 'b')
 *    ('iand', ('ior', 'a', 'b'), 'b') => b
 *    ('iand', ('iand', 'a', 'b'), 'b') => ('iand', 'a', 'b')
 *    ('iand', ('iand(is_used_once)', 'a', 'b'), ('iand(is_used_once)', 'a', 'c')) => ('iand', 'a', ('iand', 'b', 'c'))
 *    ('iand@64', 'a', '#b(is_lower_half_zero)') => ('pack_64_2x32_split', 0, ('iand', ('unpack_64_2x32_split_y', 'a'), ('unpack_64_2x32_split_y', 'b')))
 *    ('iand@64', 'a', '#b(is_upper_half_zero)') => ('pack_64_2x32_split', ('iand', ('unpack_64_2x32_split_x', 'a'), ('unpack_64_2x32_split_x', 'b')), 0)
 *    ('iand@64', 'a', '#b(is_lower_half_negative_one)') => ('pack_64_2x32_split', ('unpack_64_2x32_split_x', 'a'), ('iand', ('unpack_64_2x32_split_y', 'a'), ('unpack_64_2x32_split_y', 'b')))
 *    ('iand@64', 'a', '#b(is_upper_half_negative_one)') => ('pack_64_2x32_split', ('iand', ('unpack_64_2x32_split_x', 'a'), ('unpack_64_2x32_split_x', 'b')), ('unpack_64_2x32_split_y', 'a'))
 *    ('ior@64', 'a', '#b(is_lower_half_zero)') => ('pack_64_2x32_split', ('unpack_64_2x32_split_x', 'a'), ('ior', ('unpack_64_2x32_split_y', 'a'), ('unpack_64_2x32_split_y', 'b')))
 *    ('ior@64', 'a', '#b(is_upper_half_zero)') => ('pack_64_2x32_split', ('ior', ('unpack_64_2x32_split_x', 'a'), ('unpack_64_2x32_split_x', 'b')), ('unpack_64_2x32_split_y', 'a'))
 *    ('ior@64', 'a', '#b(is_lower_half_negative_one)') => ('pack_64_2x32_split', -1, ('ior', ('unpack_64_2x32_split_y', 'a'), ('unpack_64_2x32_split_y', 'b')))
 *    ('ior@64', 'a', '#b(is_upper_half_negative_one)') => ('pack_64_2x32_split', ('ior', ('unpack_64_2x32_split_x', 'a'), ('unpack_64_2x32_split_x', 'b')), -1)
 *    ('ixor@64', 'a', '#b(is_lower_half_zero)') => ('pack_64_2x32_split', ('unpack_64_2x32_split_x', 'a'), ('ixor', ('unpack_64_2x32_split_y', 'a'), ('unpack_64_2x32_split_y', 'b')))
 *    ('ixor@64', 'a', '#b(is_upper_half_zero)') => ('pack_64_2x32_split', ('ixor', ('unpack_64_2x32_split_x', 'a'), ('unpack_64_2x32_split_x', 'b')), ('unpack_64_2x32_split_y', 'a'))
 *    ('iand', ('inot', 'a'), ('inot', 'b')) => ('inot', ('ior', 'a', 'b'))
 *    ('ior', ('inot', 'a'), ('inot', 'b')) => ('inot', ('iand', 'a', 'b'))
 *    ('ishl', 0, 'a') => 0
 *    ('ishl', 'a', 0) => a
 *    ('ishr', 0, 'a') => 0
 *    ('ishr', -1, 'a') => -1
 *    ('ishr', 'a', 0) => a
 *    ('ushr', 0, 'a') => 0
 *    ('ushr', 'a', 0) => a
 *    ('bcsel', ('ieq', 'b', 0), 'a', ('ushr', 'a', 'b')) => ('ushr', 'a', 'b')
 *    ('bcsel', ('ieq', 'b', 0), 'a', ('ishr', 'a', 'b')) => ('ishr', 'a', 'b')
 *    ('bcsel', ('ieq', 'b', 0), 'a', ('ishl', 'a', 'b')) => ('ishl', 'a', 'b')
 *    ('bcsel', ('ine', 'b', 0), ('ushr', 'a', 'b'), 'a') => ('ushr', 'a', 'b')
 *    ('bcsel', ('ine', 'b', 0), ('ishr', 'a', 'b'), 'a') => ('ishr', 'a', 'b')
 *    ('bcsel', ('ine', 'b', 0), ('ishl', 'a', 'b'), 'a') => ('ishl', 'a', 'b')
 *    ('ior', ('ishl@16', 'a', 'b'), ('ushr@16', 'a', ('iadd', 16, ('ineg', 'b')))) => ('urol', 'a', 'b')
 *    ('ior', ('ishl@16', 'a', 'b'), ('ushr@16', 'a', ('isub', 16, 'b'))) => ('urol', 'a', 'b')
 *    ('ior', ('ishl@32', 'a', 'b'), ('ushr@32', 'a', ('iadd', 32, ('ineg', 'b')))) => ('urol', 'a', 'b')
 *    ('ior', ('ishl@32', 'a', 'b'), ('ushr@32', 'a', ('isub', 32, 'b'))) => ('urol', 'a', 'b')
 *    ('ior', ('ushr@16', 'a', 'b'), ('ishl@16', 'a', ('iadd', 16, ('ineg', 'b')))) => ('uror', 'a', 'b')
 *    ('ior', ('ushr@16', 'a', 'b'), ('ishl@16', 'a', ('isub', 16, 'b'))) => ('uror', 'a', 'b')
 *    ('ior', ('ushr@32', 'a', 'b'), ('ishl@32', 'a', ('iadd', 32, ('ineg', 'b')))) => ('uror', 'a', 'b')
 *    ('ior', ('ushr@32', 'a', 'b'), ('ishl@32', 'a', ('isub', 32, 'b'))) => ('uror', 'a', 'b')
 *    ('urol@8', 'a', 'b') => ('ior', ('ishl', 'a', 'b'), ('ushr', 'a', ('isub', 8, 'b')))
 *    ('urol@16', 'a', 'b') => ('ior', ('ishl', 'a', 'b'), ('ushr', 'a', ('isub', 16, 'b')))
 *    ('urol@32', 'a', 'b') => ('ior', ('ishl', 'a', 'b'), ('ushr', 'a', ('isub', 32, 'b')))
 *    ('urol@64', 'a', 'b') => ('ior', ('ishl', 'a', 'b'), ('ushr', 'a', ('isub', 64, 'b')))
 *    ('uror@8', 'a', 'b') => ('ior', ('ushr', 'a', 'b'), ('ishl', 'a', ('isub', 8, 'b')))
 *    ('uror@16', 'a', 'b') => ('ior', ('ushr', 'a', 'b'), ('ishl', 'a', ('isub', 16, 'b')))
 *    ('uror@32', 'a', 'b') => ('ior', ('ushr', 'a', 'b'), ('ishl', 'a', ('isub', 32, 'b')))
 *    ('uror@64', 'a', 'b') => ('ior', ('ushr', 'a', 'b'), ('ishl', 'a', ('isub', 64, 'b')))
 *    ('bitfield_select', 4278190080, ('ishl', 'b@32', 24), ('ushr', 'a', 8)) => ('shfr', 'b', 'a', 8)
 *    ('bitfield_select', 4294901760, ('ishl', 'b@32', 16), ('extract_u16', 'a', 1)) => ('shfr', 'b', 'a', 16)
 *    ('bitfield_select', 4294967040, ('ishl', 'b@32', 8), ('extract_u8', 'a', 3)) => ('shfr', 'b', 'a', 24)
 *    ('ior', ('ishl', 'b@32', 24), ('ushr', 'a', 8)) => ('shfr', 'b', 'a', 8)
 *    ('ior', ('ishl', 'b@32', 16), ('extract_u16', 'a', 1)) => ('shfr', 'b', 'a', 16)
 *    ('ior', ('ishl', 'b@32', 8), ('extract_u8', 'a', 3)) => ('shfr', 'b', 'a', 24)
 *    ('bcsel', ('ieq', 'c', 0), 'a', ('ior', ('ishl', 'b@32', ('iadd', 32, ('ineg', 'c'))), ('ushr@32', 'a', 'c'))) => ('shfr', 'b', 'a', 'c')
 *    ('bcsel', ('ine', 'c', 0), ('ior', ('ishl', 'b@32', ('iadd', 32, ('ineg', 'c'))), ('ushr@32', 'a', 'c')), 'a') => ('shfr', 'b', 'a', 'c')
 *    ('ior', ('ishl', 'a@32', ('iadd', 32, ('ineg', 'b'))), ('ushr@32', 'a', 'b')) => ('shfr', 'a', 'a', 'b')
 *    ('bfi', 4294967295, 'a', 'b') => a
 *    ('bfi', 0, 'a', 'b') => b
 *    ('bfi', ('ineg', ('b2i', 'a@1')), 'b', 'c') => ('bcsel', 'a', 'b', 'c')
 *    ('bfi', '#a(is_odd)', 'a', 'b') => ('ior', 'a', 'b')
 *    ('bfi', '#a(is_odd)', 'b', 0) => ('iand', 'a', 'b')
 *    ('u2f32', ('bfi', '#a(is_pos_power_of_two)', 'b', 0)) => ('bcsel', ('ieq', ('iand', 'b', 1), 0), ('iand', 'b', 1), ('u2f', 'a'))
 *    ('u2f', ('bfi', '#a(is_pos_power_of_two)', 'b', 0)) => ('bcsel', ('ieq', ('iand', 'b', 1), 0), 0, ('u2f', 'a'))
 *    ('~fexp2', ('flog2', 'a')) => a
 *    ('~flog2', ('fexp2', 'a')) => a
 *    ('fpow@32', 'a', 'b') => ('fexp2', ('fmulz', ('flog2', 'a'), 'b'))
 *    ('fpow', 'a', 'b') => ('fexp2', ('fmul', ('flog2', 'a'), 'b'))
 *    ('~fexp2', ('fmul', ('flog2', 'a'), 'b')) => ('fpow', 'a', 'b')
 *    ('~fexp2', ('fadd', ('fmul', ('flog2', 'a'), 'b'), ('fmul', ('flog2', 'c'), 'd'))) => ('~fmul', ('fpow', 'a', 'b'), ('fpow', 'c', 'd'))
 *    ('~fexp2', ('fmul', ('flog2', 'a'), 0.5)) => ('fsqrt', 'a')
 *    ('~fexp2', ('fmul', ('flog2', 'a'), 2.0)) => ('fmul', 'a', 'a')
 *    ('~fexp2', ('fmul', ('flog2', 'a'), 3.0)) => ('fmul', ('fmul', 'a', 'a'), 'a')
 *    ('~fexp2', ('fmul', ('flog2', 'a'), 4.0)) => ('fmul', ('fmul', 'a', 'a'), ('fmul', 'a', 'a'))
 *    ('~fexp2', ('fmul', ('flog2', 'a'), 5.0)) => ('fmul', ('fmul', ('fmul', 'a', 'a'), ('fmul', 'a', 'a')), 'a')
 *    ('~fexp2', ('fmul', ('flog2', 'a'), 6.0)) => ('fmul', ('fmul', ('fmul', 'a', 'a'), ('fmul', 'a', 'a')), ('fmul', 'a', 'a'))
 *    ('~fexp2', ('fmul', ('flog2', 'a'), 8.0)) => ('fmul', ('fmul', ('fmul', 'a', 'a'), ('fmul', 'a', 'a')), ('fmul', ('fmul', 'a', 'a'), ('fmul', 'a', 'a')))
 *    ('~fpow', 'a', 1.0) => a
 *    ('~fpow', 'a', 2.0) => ('fmul', 'a', 'a')
 *    ('~fpow', 'a', 3.0) => ('fmul', ('fmul', 'a', 'a'), 'a')
 *    ('~fpow', 'a', 4.0) => ('fmul', ('fmul', 'a', 'a'), ('fmul', 'a', 'a'))
 *    ('~fpow', 2.0, 'a') => ('fexp2', 'a')
 *    ('~fpow', ('fpow', 'a', 2.2), 0.454545) => a
 *    ('~fpow', ('fabs', ('fpow', 'a', 2.2)), 0.454545) => ('fabs', 'a')
 *    ('~fsqrt', ('fexp2', 'a')) => ('fexp2', ('fmul', 0.5, 'a'))
 *    ('~frcp', ('fexp2', 'a')) => ('fexp2', ('fneg', 'a'))
 *    ('~frsq', ('fexp2', 'a')) => ('fexp2', ('fmul', -0.5, 'a'))
 *    ('~flog2', ('fsqrt', 'a')) => ('fmul', 0.5, ('flog2', 'a'))
 *    ('~flog2', ('frcp', 'a')) => ('fneg', ('flog2', 'a'))
 *    ('~flog2', ('frsq', 'a')) => ('fmul', -0.5, ('flog2', 'a'))
 *    ('~flog2', ('fpow', 'a', 'b')) => ('fmul', 'b', ('flog2', 'a'))
 *    ('~fmul', ('fexp2(is_used_once)', 'a'), ('fexp2(is_used_once)', 'b')) => ('fexp2', ('fadd', 'a', 'b'))
 *    ('bcsel', ('flt', 'a', 0.0), 0.0, ('fsqrt', 'a')) => ('fsqrt', ('fmax', 'a', 0.0))
 *    ('~fmul', ('fsqrt', 'a'), ('fsqrt', 'a')) => ('fabs', 'a')
 *    ('~fmulz', ('fsqrt', 'a'), ('fsqrt', 'a')) => ('fabs', 'a')
 *    ('~fdiv', 1.0, 'a') => ('frcp', 'a')
 *    ('fdiv', 'a', 'b') => ('fmul', 'a', ('frcp', 'b'))
 *    ('~frcp', ('frcp', 'a')) => a
 *    ('~frcp', ('fsqrt', 'a')) => ('frsq', 'a')
 *    ('fsqrt', 'a') => ('frcp', ('frsq', 'a'))
 *    ('~frcp', ('frsq', 'a')) => ('fsqrt', 'a')
 *    ('fsin', 'a') => ('ffma', ('ffma', ('fmul', ('fsub', ('fsub', ('fmul', 2.0, ('ffract', ('fadd', ('fmul', 0.15915494309189535, 'a'), 0.5))), 1.0), ('fmul', ('fsub', ('fmul', 2.0, ('ffract', ('fadd', ('fmul', 0.15915494309189535, 'a'), 0.5))), 1.0), ('fabs', ('fsub', ('fmul', 2.0, ('ffract', ('fadd', ('fmul', 0.15915494309189535, 'a'), 0.5))), 1.0)))), 4.0), ('fabs', ('fmul', ('fsub', ('fsub', ('fmul', 2.0, ('ffract', ('fadd', ('fmul', 0.15915494309189535, 'a'), 0.5))), 1.0), ('fmul', ('fsub', ('fmul', 2.0, ('ffract', ('fadd', ('fmul', 0.15915494309189535, 'a'), 0.5))), 1.0), ('fabs', ('fsub', ('fmul', 2.0, ('ffract', ('fadd', ('fmul', 0.15915494309189535, 'a'), 0.5))), 1.0)))), 4.0)), ('fneg', ('fmul', ('fsub', ('fsub', ('fmul', 2.0, ('ffract', ('fadd', ('fmul', 0.15915494309189535, 'a'), 0.5))), 1.0), ('fmul', ('fsub', ('fmul', 2.0, ('ffract', ('fadd', ('fmul', 0.15915494309189535, 'a'), 0.5))), 1.0), ('fabs', ('fsub', ('fmul', 2.0, ('ffract', ('fadd', ('fmul', 0.15915494309189535, 'a'), 0.5))), 1.0)))), 4.0))), 0.225, ('fmul', ('fsub', ('fsub', ('fmul', 2.0, ('ffract', ('fadd', ('fmul', 0.15915494309189535, 'a'), 0.5))), 1.0), ('fmul', ('fsub', ('fmul', 2.0, ('ffract', ('fadd', ('fmul', 0.15915494309189535, 'a'), 0.5))), 1.0), ('fabs', ('fsub', ('fmul', 2.0, ('ffract', ('fadd', ('fmul', 0.15915494309189535, 'a'), 0.5))), 1.0)))), 4.0))
 *    ('fcos', 'a') => ('ffma', ('ffma', ('fmul', ('fsub', ('fsub', ('fmul', 2.0, ('ffract', ('fadd', ('fmul', 0.15915494309189535, 'a'), 0.75))), 1.0), ('fmul', ('fsub', ('fmul', 2.0, ('ffract', ('fadd', ('fmul', 0.15915494309189535, 'a'), 0.75))), 1.0), ('fabs', ('fsub', ('fmul', 2.0, ('ffract', ('fadd', ('fmul', 0.15915494309189535, 'a'), 0.75))), 1.0)))), 4.0), ('fabs', ('fmul', ('fsub', ('fsub', ('fmul', 2.0, ('ffract', ('fadd', ('fmul', 0.15915494309189535, 'a'), 0.75))), 1.0), ('fmul', ('fsub', ('fmul', 2.0, ('ffract', ('fadd', ('fmul', 0.15915494309189535, 'a'), 0.75))), 1.0), ('fabs', ('fsub', ('fmul', 2.0, ('ffract', ('fadd', ('fmul', 0.15915494309189535, 'a'), 0.75))), 1.0)))), 4.0)), ('fneg', ('fmul', ('fsub', ('fsub', ('fmul', 2.0, ('ffract', ('fadd', ('fmul', 0.15915494309189535, 'a'), 0.75))), 1.0), ('fmul', ('fsub', ('fmul', 2.0, ('ffract', ('fadd', ('fmul', 0.15915494309189535, 'a'), 0.75))), 1.0), ('fabs', ('fsub', ('fmul', 2.0, ('ffract', ('fadd', ('fmul', 0.15915494309189535, 'a'), 0.75))), 1.0)))), 4.0))), 0.225, ('fmul', ('fsub', ('fsub', ('fmul', 2.0, ('ffract', ('fadd', ('fmul', 0.15915494309189535, 'a'), 0.75))), 1.0), ('fmul', ('fsub', ('fmul', 2.0, ('ffract', ('fadd', ('fmul', 0.15915494309189535, 'a'), 0.75))), 1.0), ('fabs', ('fsub', ('fmul', 2.0, ('ffract', ('fadd', ('fmul', 0.15915494309189535, 'a'), 0.75))), 1.0)))), 4.0))
 *    ('ieq', 'a', True) => a
 *    ('ine(is_not_used_by_if)', 'a', True) => ('inot', 'a')
 *    ('ine', 'a', False) => a
 *    ('ieq(is_not_used_by_if)', 'a', False) => ('inot', 'a')
 *    ('bcsel', 'a', True, False) => a
 *    ('bcsel', 'a', False, True) => ('inot', 'a')
 *    ('bcsel', True, 'b', 'c') => b
 *    ('bcsel', False, 'b', 'c') => c
 *    ('bcsel@16', 'a', 1.0, 0.0) => ('b2f', 'a')
 *    ('bcsel@16', 'a', 0.0, 1.0) => ('b2f', ('inot', 'a'))
 *    ('bcsel@16', 'a', -1.0, -0.0) => ('fneg', ('b2f', 'a'))
 *    ('bcsel@16', 'a', -0.0, -1.0) => ('fneg', ('b2f', ('inot', 'a')))
 *    ('bcsel@32', 'a', 1.0, 0.0) => ('b2f', 'a')
 *    ('bcsel@32', 'a', 0.0, 1.0) => ('b2f', ('inot', 'a'))
 *    ('bcsel@32', 'a', -1.0, -0.0) => ('fneg', ('b2f', 'a'))
 *    ('bcsel@32', 'a', -0.0, -1.0) => ('fneg', ('b2f', ('inot', 'a')))
 *    ('bcsel@64', 'a', 1.0, 0.0) => ('b2f', 'a')
 *    ('bcsel@64', 'a', 0.0, 1.0) => ('b2f', ('inot', 'a'))
 *    ('bcsel@64', 'a', -1.0, -0.0) => ('fneg', ('b2f', 'a'))
 *    ('bcsel@64', 'a', -0.0, -1.0) => ('fneg', ('b2f', ('inot', 'a')))
 *    ('bcsel', 'a', 'b', 'b') => b
 *    ('~fcsel', 'a', 'b', 'b') => b
 *    ('bcsel', 'a', -1, 0) => ('ineg', ('b2i', 'a@1'))
 *    ('bcsel', 'a', 0, -1) => ('ineg', ('b2i', ('inot', 'a')))
 *    ('bcsel', 'a', 1, 0) => ('b2i', 'a@1')
 *    ('bcsel', 'a', 0, 1) => ('b2i', ('inot', 'a'))
 *    ('iand', ('ineg', ('b2i', 'a@1')), ('ineg', ('b2i', 'b@1'))) => ('ineg', ('b2i', ('iand', 'a', 'b')))
 *    ('ior', ('ineg', ('b2i', 'a@1')), ('ineg', ('b2i', 'b@1'))) => ('ineg', ('b2i', ('ior', 'a', 'b')))
 *    ('ieq', ('ineg', ('b2i', 'a@1')), -1) => a
 *    ('ine', ('ineg', ('b2i', 'a@1')), -1) => ('inot', 'a')
 *    ('ige', ('ineg', ('b2i', 'a@1')), 0) => ('inot', 'a')
 *    ('ilt', ('ineg', ('b2i', 'a@1')), 0) => a
 *    ('ult', 0, ('ineg', ('b2i', 'a@1'))) => a
 *    ('iand', ('ineg', ('b2i', 'a')), 1.0) => ('b2f', 'a')
 *    ('iand', ('ineg', ('b2i', 'a')), 1) => ('b2i', 'a')
 *    ('imax', ('ineg', ('b2i', 'a@1')), ('ineg', ('b2i', 'b@1'))) => ('ineg', ('b2i', ('iand', 'a', 'b')))
 *    ('imin', ('ineg', ('b2i', 'a@1')), ('ineg', ('b2i', 'b@1'))) => ('ineg', ('b2i', ('ior', 'a', 'b')))
 *    ('umax', ('ineg', ('b2i', 'a@1')), ('ineg', ('b2i', 'b@1'))) => ('ineg', ('b2i', ('ior', 'a', 'b')))
 *    ('umin', ('ineg', ('b2i', 'a@1')), ('ineg', ('b2i', 'b@1'))) => ('ineg', ('b2i', ('iand', 'a', 'b')))
 *    ('umax', ('b2i', 'a@1'), ('b2i', 'b@1')) => ('b2i', ('ior', 'a', 'b'))
 *    ('umin', ('b2i', 'a@1'), ('b2i', 'b@1')) => ('b2i', ('iand', 'a', 'b'))
 *    ('iand', ('b2i', 'a'), 1) => ('b2i', 'a')
 *    ('ine', ('umin', ('ineg', ('b2i', 'a@1')), 'b'), 0) => ('iand', 'a', ('ine', 'b', 0))
 *    ('ine', ('umax', ('ineg', ('b2i', 'a@1')), 'b'), 0) => ('ior', 'a', ('ine', 'b', 0))
 *    ('f2i', ('ftrunc', 'a')) => ('f2i', 'a')
 *    ('f2u', ('ftrunc', 'a')) => ('f2u', 'a')
 *    ('f2fmp', ('f2f32', 'a@16')) => a
 *    ('i2imp', ('i2i32', 'a@16')) => a
 *    ('i2imp', ('u2u32', 'a@16')) => a
 *    ('f2imp', ('f2f32', 'a@16')) => ('f2i16', 'a')
 *    ('f2ump', ('f2f32', 'a@16')) => ('f2u16', 'a')
 *    ('i2fmp', ('i2i32', 'a@16')) => ('i2f16', 'a')
 *    ('u2fmp', ('u2u32', 'a@16')) => ('u2f16', 'a')
 *    ('f2fmp', ('b2f32', 'a@1')) => ('b2f16', 'a')
 *    ('i2imp', ('b2i32', 'a@1')) => ('b2i16', 'a')
 *    ('i2imp', ('b2i32', 'a@1')) => ('b2i16', 'a')
 *    ('f2imp', ('b2f32', 'a@1')) => ('b2i16', 'a')
 *    ('f2ump', ('b2f32', 'a@1')) => ('b2i16', 'a')
 *    ('i2fmp', ('b2i32', 'a@1')) => ('b2f16', 'a')
 *    ('u2fmp', ('b2i32', 'a@1')) => ('b2f16', 'a')
 *    ('f2f32', ('f2fmp', 'a@32')) => a
 *    ('i2i32', ('i2imp', 'a@32')) => a
 *    ('u2u32', ('i2imp', 'a@32')) => a
 *    ('i2i32', ('f2imp', 'a@32')) => ('f2i32', 'a')
 *    ('u2u32', ('f2ump', 'a@32')) => ('f2u32', 'a')
 *    ('f2f32', ('i2fmp', 'a@32')) => ('i2f32', 'a')
 *    ('f2f32', ('u2fmp', 'a@32')) => ('u2f32', 'a')
 *    ('f2i32', ('f2fmp', 'a@32')) => ('f2i32', 'a')
 *    ('f2u32', ('f2fmp', 'a@32')) => ('f2u32', 'a')
 *    ('i2f32', ('i2imp', 'a@32')) => ('i2f32', 'a')
 *    ('ffloor', 'a(is_integral)') => a
 *    ('fceil', 'a(is_integral)') => a
 *    ('ftrunc', 'a(is_integral)') => a
 *    ('fround_even', 'a(is_integral)') => a
 *    ('~ffract', 'a(is_integral)') => 0.0
 *    ('fabs', 'a(is_not_negative)') => a
 *    ('iabs', 'a(is_not_negative)') => a
 *    ('fsat', 'a(is_not_positive)') => 0.0
 *    ('~fmin', 'a(is_not_negative)', 1.0) => ('fsat', 'a')
 *    ('flt', ('fadd', ('fmul', ('fsat', 'a'), ('fneg', ('fsat', 'a'))), 1.0), 0.0) => False
 *    ('flt', ('fadd', ('fneg', ('fmul', ('fsat', 'a'), ('fsat', 'a'))), 1.0), 0.0) => False
 *    ('fmax', ('fadd', ('fmul', ('fsat', 'a'), ('fneg', ('fsat', 'a'))), 1.0), 0.0) => ('fadd', ('fmul', ('fsat', 'a'), ('fneg', ('fsat', 'a'))), 1.0)
 *    ('fmax', ('fadd', ('fneg', ('fmul', ('fsat', 'a'), ('fsat', 'a'))), 1.0), 0.0) => ('fadd', ('fneg', ('fmul', ('fsat', 'a'), ('fsat', 'a'))), 1.0)
 *    ('fneu', 'a(is_not_zero)', 0.0) => True
 *    ('feq', 'a(is_not_zero)', 0.0) => False
 *    ('fge', 'a(is_a_number_not_negative)', 'b(is_a_number_not_positive)') => True
 *    ('fge', 'a(is_not_positive)', 'b(is_gt_zero)') => False
 *    ('fge', 'a(is_lt_zero)', 'b(is_not_negative)') => False
 *    ('flt', 'a(is_not_negative)', 'b(is_not_positive)') => False
 *    ('flt', 'a(is_a_number_not_positive)', 'b(is_a_number_gt_zero)') => True
 *    ('flt', 'a(is_a_number_lt_zero)', 'b(is_a_number_not_negative)') => True
 *    ('ine', 'a(is_not_zero)', 0) => True
 *    ('ieq', 'a(is_not_zero)', 0) => False
 *    ('ige', 'a(is_not_negative)', 'b(is_not_positive)') => True
 *    ('ige', 'a(is_not_positive)', 'b(is_gt_zero)') => False
 *    ('ige', 'a(is_lt_zero)', 'b(is_not_negative)') => False
 *    ('ilt', 'a(is_not_negative)', 'b(is_not_positive)') => False
 *    ('ilt', 'a(is_not_positive)', 'b(is_gt_zero)') => True
 *    ('ilt', 'a(is_lt_zero)', 'b(is_not_negative)') => True
 *    ('ult', 0, 'a(is_gt_zero)') => True
 *    ('ult', 'a', 0) => False
 *    ('unpack_64_2x32_split_x', ('pack_64_2x32_split', 'a', 'b')) => a
 *    ('unpack_64_2x32_split_y', ('pack_64_2x32_split', 'a', 'b')) => b
 *    ('unpack_64_2x32_split_x', ('pack_64_2x32', 'a')) => a.x
 *    ('unpack_64_2x32_split_y', ('pack_64_2x32', 'a')) => a.y
 *    ('unpack_64_2x32_split_x', ('u2u64', 'a@32')) => a
 *    ('unpack_64_2x32_split_y', ('u2u64', 'a')) => 0
 *    ('unpack_64_2x32_split_x', ('i2i64', 'a@32')) => a
 *    ('unpack_64_2x32_split_y', ('i2i64(is_used_once)', 'a@32')) => ('ishr', 'a', 31)
 *    ('unpack_64_2x32', ('pack_64_2x32_split', 'a', 'b')) => ('vec2', 'a', 'b')
 *    ('unpack_64_2x32', ('pack_64_2x32', 'a')) => a
 *    ('unpack_double_2x32_dxil', ('pack_double_2x32_dxil', 'a')) => a
 *    ('pack_64_2x32_split', ('unpack_64_2x32_split_x', 'a'), ('unpack_64_2x32_split_y', 'a')) => a
 *    ('pack_64_2x32', ('vec2', ('unpack_64_2x32_split_x', 'a'), ('unpack_64_2x32_split_y', 'a'))) => a
 *    ('pack_64_2x32', ('unpack_64_2x32', 'a')) => a
 *    ('pack_double_2x32_dxil', ('unpack_double_2x32_dxil', 'a')) => a
 *    ('unpack_64_4x16', ('pack_64_4x16', 'a')) => a
 *    ('unpack_64_4x16', ('pack_64_2x32', ('vec2', ('pack_32_2x16_split', 'a', 'b'), ('pack_32_2x16_split', 'c', 'd')))) => ('vec4', 'a', 'b', 'c', 'd')
 *    ('unpack_64_4x16', ('pack_64_2x32_split', ('pack_32_2x16_split', 'a', 'b'), ('pack_32_2x16_split', 'c', 'd'))) => ('vec4', 'a', 'b', 'c', 'd')
 *    ('iand', ('ieq', ('unpack_32_2x16_split_x', 'a'), '#b'), ('ieq', ('unpack_32_2x16_split_y', 'a'), '#c')) => ('ieq', 'a', ('pack_32_2x16_split', 'b', 'c'))
 *    ('ushr', 'a@16', 8) => ('extract_u8', 'a', 1)
 *    ('ushr', 'a@32', 24) => ('extract_u8', 'a', 3)
 *    ('ushr', 'a@64', 56) => ('extract_u8', 'a', 7)
 *    ('ishr', 'a@16', 8) => ('extract_i8', 'a', 1)
 *    ('ishr', 'a@32', 24) => ('extract_i8', 'a', 3)
 *    ('ishr', 'a@64', 56) => ('extract_i8', 'a', 7)
 *    ('iand', 255, 'a') => ('extract_u8', 'a', 0)
 *    ('ishr', ('iand', 'a@32', 65280), 8) => ('extract_u8', 'a', 1)
 *    ('ishr', ('iand', 'a@64', 65280), 8) => ('extract_u8', 'a', 1)
 *    ('ishr', ('iand', 'a', 16711680), 16) => ('extract_u8', 'a', 2)
 *    ('u2u8', ('extract_u16', 'a', 1)) => ('u2u8', ('extract_u8', 'a', 2))
 *    ('u2u8', ('ushr', 'a', 8)) => ('u2u8', ('extract_u8', 'a', 1))
 *    ('i2i16', ('u2u8', ('extract_u8', 'a', 'b'))) => ('i2i16', ('extract_i8', 'a', 'b'))
 *    ('u2u16', ('u2u8', ('extract_u8', 'a', 'b'))) => ('u2u16', ('extract_u8', 'a', 'b'))
 *    ('ubfe', 'a', 0, 8) => ('extract_u8', 'a', 0)
 *    ('ubfe', 'a', 8, 8) => ('extract_u8', 'a', 1)
 *    ('ubfe', 'a', 16, 8) => ('extract_u8', 'a', 2)
 *    ('ubfe', 'a', 24, 8) => ('extract_u8', 'a', 3)
 *    ('ibfe', 'a', 0, 8) => ('extract_i8', 'a', 0)
 *    ('ibfe', 'a', 8, 8) => ('extract_i8', 'a', 1)
 *    ('ibfe', 'a', 16, 8) => ('extract_i8', 'a', 2)
 *    ('ibfe', 'a', 24, 8) => ('extract_i8', 'a', 3)
 *    ('extract_u8', ('extract_i8', 'a', 'b'), 0) => ('extract_u8', 'a', 'b')
 *    ('extract_u8', ('extract_u8', 'a', 'b'), 0) => ('extract_u8', 'a', 'b')
 *    ('extract_i8', ('iand', 'a', 65280), 1) => ('extract_i8', 'a', 1)
 *    ('extract_i8', ('iand', 'a', 16711680), 2) => ('extract_i8', 'a', 2)
 *    ('extract_i8', ('iand', 'a', 4278190080), 3) => ('extract_i8', 'a', 3)
 *    ('extract_u8', ('iand', 'a', 65280), 1) => ('extract_u8', 'a', 1)
 *    ('extract_u8', ('iand', 'a', 16711680), 2) => ('extract_u8', 'a', 2)
 *    ('extract_u8', ('iand', 'a', 4278190080), 3) => ('extract_u8', 'a', 3)
 *    ('iand', ('extract_u8', 'a', 0), '#b') => ('iand', 'a', ('iand', 'b', 255))
 *    ('iand', ('extract_u16', 'a', 0), '#b') => ('iand', 'a', ('iand', 'b', 65535))
 *    ('ieq', ('iand', ('extract_u8', 'a', '#b'), '#c'), 0) => ('ieq', ('iand', 'a', ('ishl', ('iand', 'c', 255), ('imul', ('i2i32', 'b'), 8))), 0)
 *    ('ine', ('iand', ('extract_u8', 'a', '#b'), '#c'), 0) => ('ine', ('iand', 'a', ('ishl', ('iand', 'c', 255), ('imul', ('i2i32', 'b'), 8))), 0)
 *    ('ieq', ('iand', ('extract_u16(is_used_once)', 'a', '#b'), '#c'), 0) => ('ieq', ('iand', 'a', ('ishl', ('iand', 'c', 65535), ('imul', ('i2i32', 'b'), 16))), 0)
 *    ('ine', ('iand', ('extract_u16(is_used_once)', 'a', '#b'), '#c'), 0) => ('ine', ('iand', 'a', ('ishl', ('iand', 'c', 65535), ('imul', ('i2i32', 'b'), 16))), 0)
 *    ('ushr', ('ishl', 'a@32', 16), 16) => ('extract_u16', 'a', 0)
 *    ('ushr', 'a@32', 16) => ('extract_u16', 'a', 1)
 *    ('ishr', ('ishl', 'a@32', 16), 16) => ('extract_i16', 'a', 0)
 *    ('ishr', 'a@32', 16) => ('extract_i16', 'a', 1)
 *    ('iand', 65535, 'a') => ('extract_u16', 'a', 0)
 *    ('ubfe', 'a', 0, 16) => ('extract_u16', 'a', 0)
 *    ('ubfe', 'a', 16, 16) => ('extract_u16', 'a', 1)
 *    ('ibfe', 'a', 0, 16) => ('extract_i16', 'a', 0)
 *    ('ibfe', 'a', 16, 16) => ('extract_i16', 'a', 1)
 *    ('unpack_32_4x8', ('pack_32_4x8', 'a')) => a
 *    ('unpack_32_2x16', ('pack_32_2x16', 'a')) => a
 *    ('unpack_64_4x16', ('pack_64_4x16', 'a')) => a
 *    ('unpack_64_2x32', ('pack_64_2x32', 'a')) => a
 *    ('pack_32_4x8', ('unpack_32_4x8', 'a')) => a
 *    ('pack_32_2x16', ('unpack_32_2x16', 'a')) => a
 *    ('pack_64_4x16', ('unpack_64_4x16', 'a')) => a
 *    ('pack_64_2x32', ('unpack_64_2x32', 'a')) => a
 *    ('ior', ('ishl', ('u2u32', 'a@8'), 24), ('ior', ('ishl', ('u2u32', 'b@8'), 16), ('ior', ('ishl', ('u2u32', 'c@8'), 8), ('u2u32', 'd@8')))) => ('pack_32_4x8', ('vec4', 'd', 'c', 'b', 'a'))
 *    ('extract_u16', ('extract_i16', 'a', 'b'), 0) => ('extract_u16', 'a', 'b')
 *    ('extract_u16', ('extract_u16', 'a', 'b'), 0) => ('extract_u16', 'a', 'b')
 *    ('extract_i16', ('iand', 'a', 16711680), 1) => ('extract_u8', 'a', 2)
 *    ('extract_u16', ('iand', 'a', 16711680), 1) => ('extract_u8', 'a', 2)
 *    ('pack_64_2x32_split', 'a', 'b') => ('ior', ('u2u64', 'a'), ('ishl', ('u2u64', 'b'), 32))
 *    ('pack_32_2x16_split', 'a', 'b') => ('ior', ('u2u32', 'a'), ('ishl', ('u2u32', 'b'), 16))
 *    ('pack_half_2x16_split', 'a', 'b') => ('pack_half_2x16_rtz_split', 'a', 'b')
 *    ('unpack_64_2x32_split_x', 'a') => ('u2u32', 'a')
 *    ('unpack_64_2x32_split_y', 'a') => ('u2u32', ('ushr', 'a', 32))
 *    ('unpack_32_2x16_split_x', 'a') => ('u2u16', 'a')
 *    ('unpack_32_2x16_split_y', 'a') => ('u2u16', ('ushr', 'a', 16))
 *    ('unpack_64_2x32_split_x', ('ushr', 'a', 32)) => ('unpack_64_2x32_split_y', 'a')
 *    ('u2u32', ('ushr', 'a@64', 32)) => ('unpack_64_2x32_split_y', 'a')
 *    ('unpack_half_2x16_split_x', ('iand', 'a', 65535)) => ('unpack_half_2x16_split_x', 'a')
 *    ('unpack_32_2x16_split_x', ('iand', 'a', 65535)) => ('unpack_32_2x16_split_x', 'a')
 *    ('unpack_64_2x32_split_x', ('iand', 'a', 4294967295)) => ('unpack_64_2x32_split_x', 'a')
 *    ('unpack_half_2x16_split_y', ('iand', 'a', 4294901760)) => ('unpack_half_2x16_split_y', 'a')
 *    ('unpack_32_2x16_split_y', ('iand', 'a', 4294901760)) => ('unpack_32_2x16_split_y', 'a')
 *    ('unpack_64_2x32_split_y', ('iand', 'a', 18446744069414584320)) => ('unpack_64_2x32_split_y', 'a')
 *    ('unpack_half_2x16_split_x', ('extract_u16', 'a', 0)) => ('unpack_half_2x16_split_x', 'a')
 *    ('unpack_half_2x16_split_x', ('extract_u16', 'a', 1)) => ('unpack_half_2x16_split_y', 'a')
 *    ('unpack_half_2x16_split_x', ('ushr', 'a', 16)) => ('unpack_half_2x16_split_y', 'a')
 *    ('unpack_32_2x16_split_x', ('extract_u16', 'a', 0)) => ('unpack_32_2x16_split_x', 'a')
 *    ('unpack_32_2x16_split_x', ('extract_u16', 'a', 1)) => ('unpack_32_2x16_split_y', 'a')
 *    ('ishl', ('pack_half_2x16', ('vec2', 'a', 0)), 16) => ('pack_half_2x16', ('vec2', 0, 'a'))
 *    ('ushr', ('pack_half_2x16', ('vec2', 0, 'a')), 16) => ('pack_half_2x16', ('vec2', 'a', 0))
 *    ('iadd', ('pack_half_2x16', ('vec2', 'a', 0)), ('pack_half_2x16', ('vec2', 0, 'b'))) => ('pack_half_2x16', ('vec2', 'a', 'b'))
 *    ('ior', ('pack_half_2x16', ('vec2', 'a', 0)), ('pack_half_2x16', ('vec2', 0, 'b'))) => ('pack_half_2x16', ('vec2', 'a', 'b'))
 *    ('ishl', ('pack_half_2x16_split', 'a', 0), 16) => ('pack_half_2x16_split', 0, 'a')
 *    ('ushr', ('pack_half_2x16_split', 0, 'a'), 16) => ('pack_half_2x16_split', 'a', 0)
 *    ('extract_u16', ('pack_half_2x16_split', 0, 'a'), 1) => ('pack_half_2x16_split', 'a', 0)
 *    ('ishl', ('pack_half_2x16_rtz_split', 'a', 0), 16) => ('pack_half_2x16_rtz_split', 0, 'a')
 *    ('ushr', ('pack_half_2x16_rtz_split', 0, 'a'), 16) => ('pack_half_2x16_rtz_split', 'a', 0)
 *    ('extract_u16', ('pack_half_2x16_rtz_split', 0, 'a'), 1) => ('pack_half_2x16_rtz_split', 'a', 0)
 *    ('iadd', ('pack_half_2x16_split', 'a', 0), ('pack_half_2x16_split', 0, 'b')) => ('pack_half_2x16_split', 'a', 'b')
 *    ('ior', ('pack_half_2x16_split', 'a', 0), ('pack_half_2x16_split', 0, 'b')) => ('pack_half_2x16_split', 'a', 'b')
 *    ('iadd', ('pack_half_2x16_rtz_split', 'a', 0), ('pack_half_2x16_rtz_split', 0, 'b')) => ('pack_half_2x16_rtz_split', 'a', 'b')
 *    ('ior', ('pack_half_2x16_rtz_split', 'a', 0), ('pack_half_2x16_rtz_split', 0, 'b')) => ('pack_half_2x16_rtz_split', 'a', 'b')
 *    ('pack_uint_2x16', ('vec2', ('pack_half_2x16_rtz_split', 'a', 0), ('pack_half_2x16_rtz_split', 'b', 0))) => ('pack_half_2x16_rtz_split', 'a', 'b')
 *    ('bfi', 4294901760, ('pack_half_2x16_split', 'a', 'b'), ('pack_half_2x16_split', 'c', 'd')) => ('pack_half_2x16_split', 'c', 'a')
 *    ('iand', ('bfi', 15, '#a', 'b'), 4294967292) => ('bfi', 15, ('iand', 'a', 4294967292), 'b')
 *    ('iand', ('bfi', 7, '#a', 'b'), 4294967292) => ('bfi', 7, ('iand', 'a', 4294967292), 'b')
 *    ('umin', ('ishl', ('iand', 'a', 15), 3), 120) => ('ishl', ('iand', 'a', 15), 3)
 *    ('extract_i8', ('pack_32_4x8_split', 'a', 'b', 'c', 'd'), 0) => ('i2i', 'a')
 *    ('extract_i8', ('pack_32_4x8_split', 'a', 'b', 'c', 'd'), 1) => ('i2i', 'b')
 *    ('extract_i8', ('pack_32_4x8_split', 'a', 'b', 'c', 'd'), 2) => ('i2i', 'c')
 *    ('extract_i8', ('pack_32_4x8_split', 'a', 'b', 'c', 'd'), 3) => ('i2i', 'd')
 *    ('extract_u8', ('pack_32_4x8_split', 'a', 'b', 'c', 'd'), 0) => ('u2u', 'a')
 *    ('extract_u8', ('pack_32_4x8_split', 'a', 'b', 'c', 'd'), 1) => ('u2u', 'b')
 *    ('extract_u8', ('pack_32_4x8_split', 'a', 'b', 'c', 'd'), 2) => ('u2u', 'c')
 *    ('extract_u8', ('pack_32_4x8_split', 'a', 'b', 'c', 'd'), 3) => ('u2u', 'd')
 *    ('u2u32', ('iadd(is_used_once)', 'a@64', 'b')) => ('iadd', ('u2u32', 'a'), ('u2u32', 'b'))
 *    ('u2u32', ('imul(is_used_once)', 'a@64', 'b')) => ('imul', ('u2u32', 'a'), ('u2u32', 'b'))
 *    ('u2f32', ('u2u64', 'a@32')) => ('u2f32', 'a')
 *    ('i2i16', ('u2u8', ('iand', 'a@16', 1))) => ('iand', 'a@16', 1)
 *    ('u2u16', ('u2u8', ('iand', 'a@16', 1))) => ('iand', 'a@16', 1)
 *    ('bcsel', 'a', 0, ('b2i16', 'b@1')) => ('b2i16', ('iand', ('inot', 'a'), 'b'))
 *    ('bcsel', 'a', ('b2i16', 'b@1'), ('b2i16', 'c@1')) => ('b2i16', ('bcsel', 'a', 'b', 'c'))
 *    ('u2u32', ('ushr', ('ior', ('ishl', 'a', 32), ('u2u64', 'b')), 32)) => ('u2u32', 'a')
 *    ('u2u16', ('ushr', ('ior', ('ishl', 'a', 16), ('u2u32', 'b')), 16)) => ('u2u16', 'a')
 *    ('extract_u8', ('ushr', 'a@16', 8), 0) => ('extract_u8', 'a', 1)
 *    ('extract_u8', ('ushr', 'a@32', 8), 0) => ('extract_u8', 'a', 1)
 *    ('extract_u8', ('ushr', 'a@32', 16), 0) => ('extract_u8', 'a', 2)
 *    ('extract_u8', ('ushr', 'a@32', 24), 0) => ('extract_u8', 'a', 3)
 *    ('extract_u8', ('ushr', 'a@64', 8), 0) => ('extract_u8', 'a', 1)
 *    ('extract_u8', ('ushr', 'a@64', 16), 0) => ('extract_u8', 'a', 2)
 *    ('extract_u8', ('ushr', 'a@64', 24), 0) => ('extract_u8', 'a', 3)
 *    ('extract_u8', ('ushr', 'a@64', 32), 0) => ('extract_u8', 'a', 4)
 *    ('extract_u8', ('ushr', 'a@64', 40), 0) => ('extract_u8', 'a', 5)
 *    ('extract_u8', ('ushr', 'a@64', 48), 0) => ('extract_u8', 'a', 6)
 *    ('extract_u8', ('ushr', 'a@64', 56), 0) => ('extract_u8', 'a', 7)
 *    ('extract_u8', ('ishr', 'a@16', 8), 0) => ('extract_u8', 'a', 1)
 *    ('extract_u8', ('ishr', 'a@32', 8), 0) => ('extract_u8', 'a', 1)
 *    ('extract_u8', ('ishr', 'a@32', 16), 0) => ('extract_u8', 'a', 2)
 *    ('extract_u8', ('ishr', 'a@32', 24), 0) => ('extract_u8', 'a', 3)
 *    ('extract_u8', ('ishr', 'a@64', 8), 0) => ('extract_u8', 'a', 1)
 *    ('extract_u8', ('ishr', 'a@64', 16), 0) => ('extract_u8', 'a', 2)
 *    ('extract_u8', ('ishr', 'a@64', 24), 0) => ('extract_u8', 'a', 3)
 *    ('extract_u8', ('ishr', 'a@64', 32), 0) => ('extract_u8', 'a', 4)
 *    ('extract_u8', ('ishr', 'a@64', 40), 0) => ('extract_u8', 'a', 5)
 *    ('extract_u8', ('ishr', 'a@64', 48), 0) => ('extract_u8', 'a', 6)
 *    ('extract_u8', ('ishr', 'a@64', 56), 0) => ('extract_u8', 'a', 7)
 *    ('extract_u8', ('extract_u16', 'a', 1), 0) => ('extract_u8', 'a', 2)
 *    ('extract_u8', ('ishl', 'a@16', 8), 1) => ('extract_u8', 'a', 0)
 *    ('extract_u8', ('ishl', 'a@32', 8), 3) => ('extract_u8', 'a', 2)
 *    ('extract_u8', ('ishl', 'a@32', 16), 3) => ('extract_u8', 'a', 1)
 *    ('extract_u8', ('ishl', 'a@32', 24), 3) => ('extract_u8', 'a', 0)
 *    ('extract_u8', ('ishl', 'a@64', 8), 7) => ('extract_u8', 'a', 6)
 *    ('extract_u8', ('ishl', 'a@64', 16), 7) => ('extract_u8', 'a', 5)
 *    ('extract_u8', ('ishl', 'a@64', 24), 7) => ('extract_u8', 'a', 4)
 *    ('extract_u8', ('ishl', 'a@64', 32), 7) => ('extract_u8', 'a', 3)
 *    ('extract_u8', ('ishl', 'a@64', 40), 7) => ('extract_u8', 'a', 2)
 *    ('extract_u8', ('ishl', 'a@64', 48), 7) => ('extract_u8', 'a', 1)
 *    ('extract_u8', ('ishl', 'a@64', 56), 7) => ('extract_u8', 'a', 0)
 *    ('extract_i8', ('ishl', 'a@16', 8), 1) => ('extract_i8', 'a', 0)
 *    ('extract_i8', ('ishl', 'a@32', 8), 3) => ('extract_i8', 'a', 2)
 *    ('extract_i8', ('ishl', 'a@32', 16), 3) => ('extract_i8', 'a', 1)
 *    ('extract_i8', ('ishl', 'a@32', 24), 3) => ('extract_i8', 'a', 0)
 *    ('extract_i8', ('ishl', 'a@64', 8), 7) => ('extract_i8', 'a', 6)
 *    ('extract_i8', ('ishl', 'a@64', 16), 7) => ('extract_i8', 'a', 5)
 *    ('extract_i8', ('ishl', 'a@64', 24), 7) => ('extract_i8', 'a', 4)
 *    ('extract_i8', ('ishl', 'a@64', 32), 7) => ('extract_i8', 'a', 3)
 *    ('extract_i8', ('ishl', 'a@64', 40), 7) => ('extract_i8', 'a', 2)
 *    ('extract_i8', ('ishl', 'a@64', 48), 7) => ('extract_i8', 'a', 1)
 *    ('extract_i8', ('ishl', 'a@64', 56), 7) => ('extract_i8', 'a', 0)
 *    ('ieq', ('pack_64_2x32_split', 'a', 0), ('pack_64_2x32_split', 'b', 0)) => ('ieq', 'a', 'b')
 *    ('ieq', ('pack_64_2x32_split', 'a', 0), '#b(is_upper_half_zero)') => ('ieq', 'a', ('unpack_64_2x32_split_x', 'b'))
 *    ('ieq', '#a(is_upper_half_zero)', ('pack_64_2x32_split', 'b', 0)) => ('ieq', ('unpack_64_2x32_split_x', 'a'), 'b')
 *    ('ieq', ('pack_64_2x32_split', 0, 'a'), ('pack_64_2x32_split', 0, 'b')) => ('ieq', 'a', 'b')
 *    ('ieq', ('pack_64_2x32_split', 0, 'a'), '#b(is_lower_half_zero)') => ('ieq', 'a', ('unpack_64_2x32_split_y', 'b'))
 *    ('ieq', '#a(is_lower_half_zero)', ('pack_64_2x32_split', 0, 'b')) => ('ieq', ('unpack_64_2x32_split_y', 'a'), 'b')
 *    ('ine', ('pack_64_2x32_split', 'a', 0), ('pack_64_2x32_split', 'b', 0)) => ('ine', 'a', 'b')
 *    ('ine', ('pack_64_2x32_split', 'a', 0), '#b(is_upper_half_zero)') => ('ine', 'a', ('unpack_64_2x32_split_x', 'b'))
 *    ('ine', '#a(is_upper_half_zero)', ('pack_64_2x32_split', 'b', 0)) => ('ine', ('unpack_64_2x32_split_x', 'a'), 'b')
 *    ('ine', ('pack_64_2x32_split', 0, 'a'), ('pack_64_2x32_split', 0, 'b')) => ('ine', 'a', 'b')
 *    ('ine', ('pack_64_2x32_split', 0, 'a'), '#b(is_lower_half_zero)') => ('ine', 'a', ('unpack_64_2x32_split_y', 'b'))
 *    ('ine', '#a(is_lower_half_zero)', ('pack_64_2x32_split', 0, 'b')) => ('ine', ('unpack_64_2x32_split_y', 'a'), 'b')
 *    ('ult', ('pack_64_2x32_split', 'a', 0), ('pack_64_2x32_split', 'b', 0)) => ('ult', 'a', 'b')
 *    ('ult', ('pack_64_2x32_split', 'a', 0), '#b(is_upper_half_zero)') => ('ult', 'a', ('unpack_64_2x32_split_x', 'b'))
 *    ('ult', '#a(is_upper_half_zero)', ('pack_64_2x32_split', 'b', 0)) => ('ult', ('unpack_64_2x32_split_x', 'a'), 'b')
 *    ('ult', ('pack_64_2x32_split', 0, 'a'), ('pack_64_2x32_split', 0, 'b')) => ('ult', 'a', 'b')
 *    ('ult', ('pack_64_2x32_split', 0, 'a'), '#b(is_lower_half_zero)') => ('ult', 'a', ('unpack_64_2x32_split_y', 'b'))
 *    ('ult', '#a(is_lower_half_zero)', ('pack_64_2x32_split', 0, 'b')) => ('ult', ('unpack_64_2x32_split_y', 'a'), 'b')
 *    ('ilt', ('pack_64_2x32_split', 'a', 0), ('pack_64_2x32_split', 'b', 0)) => ('ult', 'a', 'b')
 *    ('ilt', ('pack_64_2x32_split', 'a', 0), '#b(is_upper_half_zero)') => ('ult', 'a', ('unpack_64_2x32_split_x', 'b'))
 *    ('ilt', '#a(is_upper_half_zero)', ('pack_64_2x32_split', 'b', 0)) => ('ult', ('unpack_64_2x32_split_x', 'a'), 'b')
 *    ('ilt', ('pack_64_2x32_split', 0, 'a'), ('pack_64_2x32_split', 0, 'b')) => ('ilt', 'a', 'b')
 *    ('ilt', ('pack_64_2x32_split', 0, 'a'), '#b(is_lower_half_zero)') => ('ilt', 'a', ('unpack_64_2x32_split_y', 'b'))
 *    ('ilt', '#a(is_lower_half_zero)', ('pack_64_2x32_split', 0, 'b')) => ('ilt', ('unpack_64_2x32_split_y', 'a'), 'b')
 *    ('uge', ('pack_64_2x32_split', 'a', 0), ('pack_64_2x32_split', 'b', 0)) => ('uge', 'a', 'b')
 *    ('uge', ('pack_64_2x32_split', 'a', 0), '#b(is_upper_half_zero)') => ('uge', 'a', ('unpack_64_2x32_split_x', 'b'))
 *    ('uge', '#a(is_upper_half_zero)', ('pack_64_2x32_split', 'b', 0)) => ('uge', ('unpack_64_2x32_split_x', 'a'), 'b')
 *    ('uge', ('pack_64_2x32_split', 0, 'a'), ('pack_64_2x32_split', 0, 'b')) => ('uge', 'a', 'b')
 *    ('uge', ('pack_64_2x32_split', 0, 'a'), '#b(is_lower_half_zero)') => ('uge', 'a', ('unpack_64_2x32_split_y', 'b'))
 *    ('uge', '#a(is_lower_half_zero)', ('pack_64_2x32_split', 0, 'b')) => ('uge', ('unpack_64_2x32_split_y', 'a'), 'b')
 *    ('ige', ('pack_64_2x32_split', 'a', 0), ('pack_64_2x32_split', 'b', 0)) => ('uge', 'a', 'b')
 *    ('ige', ('pack_64_2x32_split', 'a', 0), '#b(is_upper_half_zero)') => ('uge', 'a', ('unpack_64_2x32_split_x', 'b'))
 *    ('ige', '#a(is_upper_half_zero)', ('pack_64_2x32_split', 'b', 0)) => ('uge', ('unpack_64_2x32_split_x', 'a'), 'b')
 *    ('ige', ('pack_64_2x32_split', 0, 'a'), ('pack_64_2x32_split', 0, 'b')) => ('ige', 'a', 'b')
 *    ('ige', ('pack_64_2x32_split', 0, 'a'), '#b(is_lower_half_zero)') => ('ige', 'a', ('unpack_64_2x32_split_y', 'b'))
 *    ('ige', '#a(is_lower_half_zero)', ('pack_64_2x32_split', 0, 'b')) => ('ige', ('unpack_64_2x32_split_y', 'a'), 'b')
 *    ('ussub_4x8_vc4', 'a', 0) => a
 *    ('ussub_4x8_vc4', 'a', -1) => 0
 *    ('fsub', 'a', 'b') => ('fadd', 'a', ('fneg', 'b'))
 *    ('isub', 'a', 'b') => ('iadd', 'a', ('ineg', 'b'))
 *    ('uabs_usub', 'a', 'b') => ('bcsel', ('ult', 'a', 'b'), ('ineg', ('isub', 'a', 'b')), ('isub', 'a', 'b'))
 *    ('uabs_isub', 'a', 'b') => ('bcsel', ('ilt', 'a', 'b'), ('ineg', ('isub', 'a', 'b')), ('isub', 'a', 'b'))
 *    ('bitz', 'a', 'b') => ('inot', ('bitnz', 'a', 'b'))
 *    ('fmul(is_used_by_non_fsat)', ('fneg', 'a'), 'b') => ('fneg', ('fmul', 'a', 'b'))
 *    ('fmulz(is_used_by_non_fsat,nsz)', ('fneg', 'a'), 'b') => ('fneg', ('fmulz', 'a', 'b'))
 *    ('ffma', ('fneg', 'a'), ('fneg', 'b'), 'c') => ('ffma', 'a', 'b', 'c')
 *    ('ffmaz', ('fneg', 'a'), ('fneg', 'b'), 'c') => ('ffmaz', 'a', 'b', 'c')
 *    ('imul', ('ineg', 'a'), 'b') => ('ineg', ('imul', 'a', 'b'))
 *    ('~fmul(is_used_once)', ('fmul(is_used_once)', 'a(is_not_const)', 'b(is_not_const)'), '#c') => ('fmul', ('fmul', 'a', 'c'), 'b')
 *    ('~fmulz(is_used_once)', ('fmulz(is_used_once)', 'a(is_not_const)', 'b(is_not_const)'), '#c') => ('fmulz', ('fmulz', 'a', 'c'), 'b')
 *    ('~fmul(is_used_once)', ('fmulz(is_used_once)', 'a(is_not_const)', 'b(is_not_const)'), '#c(is_finite_not_zero)') => ('fmulz', ('fmul', 'a', 'c'), 'b')
 *    ('imul(is_used_once)', ('imul(is_used_once)', 'a(is_not_const)', 'b(is_not_const)'), '#c') => ('imul', ('imul', 'a', 'c'), 'b')
 *    ('~ffma', ('fmul(is_used_once)', 'a(is_not_const)', 'b(is_not_const)'), '#c', 'd') => ('ffma', ('fmul', 'a', 'c'), 'b', 'd')
 *    ('~ffmaz', ('fmulz(is_used_once)', 'a(is_not_const)', 'b(is_not_const)'), '#c', 'd') => ('ffmaz', ('fmulz', 'a', 'c'), 'b', 'd')
 *    ('~ffma', ('fmulz(is_used_once)', 'a(is_not_const)', 'b(is_not_const)'), '#c(is_finite_not_zero)', 'd') => ('ffmaz', ('fmul', 'a', 'c'), 'b', 'd')
 *    ('~fadd(is_used_once)', ('fadd(is_used_once)', 'a(is_not_const)', 'b(is_fmul)'), '#c') => ('fadd', ('fadd', 'a', 'c'), 'b')
 *    ('~fadd(is_used_once)', ('fadd(is_used_once)', 'a(is_not_const)', 'b(is_not_const)'), '#c') => ('fadd', ('fadd', 'a', 'c'), 'b')
 *    ('~fadd(is_used_once)', ('ffma(is_used_once)', 'a(is_not_const)', 'b', 'c(is_not_const)'), '#d') => ('fadd', ('ffma', 'a', 'b', 'd'), 'c')
 *    ('~fadd(is_used_once)', ('ffmaz(is_used_once)', 'a(is_not_const)', 'b', 'c(is_not_const)'), '#d') => ('fadd', ('ffmaz', 'a', 'b', 'd'), 'c')
 *    ('iadd(is_used_once)', ('iadd(is_used_once)', 'a(is_not_const)', 'b(is_not_const)'), '#c') => ('iadd', ('iadd', 'a', 'c'), 'b')
 *    ('~fmul', '#a', ('fmul', 'b(is_not_const)', '#c')) => ('fmul', ('fmul', 'a', 'c'), 'b')
 *    ('~fmulz', '#a', ('fmulz', 'b(is_not_const)', '#c')) => ('fmulz', ('fmulz', 'a', 'c'), 'b')
 *    ('~fmul', '#a(is_finite_not_zero)', ('fmulz', 'b(is_not_const)', '#c')) => ('fmulz', ('fmul', 'a', 'c'), 'b')
 *    ('~ffma', '#a', ('fmul', 'b(is_not_const)', '#c'), 'd') => ('ffma', ('fmul', 'a', 'c'), 'b', 'd')
 *    ('~ffmaz', '#a', ('fmulz', 'b(is_not_const)', '#c'), 'd') => ('ffmaz', ('fmulz', 'a', 'c'), 'b', 'd')
 *    ('~ffmaz', '#a(is_finite_not_zero)', ('fmulz', 'b(is_not_const)', '#c'), 'd') => ('ffmaz', ('fmul', 'a', 'c'), 'b', 'd')
 *    ('imul', '#a', ('imul', 'b(is_not_const)', '#c')) => ('imul', ('imul', 'a', 'c'), 'b')
 *    ('~fadd', '#a', ('fadd', 'b(is_not_const)', '#c')) => ('fadd', ('fadd', 'a', 'c'), 'b')
 *    ('~fadd', '#a', ('fneg', ('fadd', 'b(is_not_const)', '#c'))) => ('fadd', ('fadd', 'a', ('fneg', 'c')), ('fneg', 'b'))
 *    ('~fadd', '#a', ('ffma', 'b(is_not_const)', 'c(is_not_const)', '#d')) => ('ffma', 'b', 'c', ('fadd', 'a', 'd'))
 *    ('~fadd', '#a', ('fneg', ('ffma', 'b(is_not_const)', 'c(is_not_const)', '#d'))) => ('ffma', ('fneg', 'b'), 'c', ('fadd', 'a', ('fneg', 'd')))
 *    ('~fadd', '#a', ('ffmaz', 'b(is_not_const)', 'c(is_not_const)', '#d')) => ('ffmaz', 'b', 'c', ('fadd', 'a', 'd'))
 *    ('~fadd', '#a', ('fneg', ('ffmaz', 'b(is_not_const)', 'c(is_not_const)', '#d'))) => ('ffmaz', ('fneg', 'b'), 'c', ('fadd', 'a', ('fneg', 'd')))
 *    ('iadd', '#a', ('iadd', 'b(is_not_const)', '#c')) => ('iadd', ('iadd', 'a', 'c'), 'b')
 *    ('iand', '#a', ('iand', 'b(is_not_const)', '#c')) => ('iand', ('iand', 'a', 'c'), 'b')
 *    ('ior', '#a', ('ior', 'b(is_not_const)', '#c')) => ('ior', ('ior', 'a', 'c'), 'b')
 *    ('ixor', '#a', ('ixor', 'b(is_not_const)', '#c')) => ('ixor', ('ixor', 'a', 'c'), 'b')
 *    ('ior', ('iand', 'a', '#c'), ('ior', 'b', ('iand', 'a', '#d'))) => ('ior', 'b', ('iand', 'a', ('ior', 'c', 'd')))
 *    ('~fadd', ('fadd(is_used_once)', 'a(is_fmul)', 'b(is_fmul)'), 'c(is_not_fmul)') => ('fadd', ('fadd', 'a', 'c'), 'b')
 *    ('idiv', ('imul(no_signed_wrap)', 'a', 'b'), 'b') => a
 *    ('bcsel', ('ige', ('find_lsb', 'a'), 0), ('find_lsb', 'a'), -1) => ('find_lsb', 'a')
 *    ('bcsel', ('ige', ('ifind_msb', 'a'), 0), ('ifind_msb', 'a'), -1) => ('ifind_msb', 'a')
 *    ('bcsel', ('ige', ('ufind_msb', 'a'), 0), ('ufind_msb', 'a'), -1) => ('ufind_msb', 'a')
 *    ('bcsel', ('ige', ('ifind_msb_rev', 'a'), 0), ('ifind_msb_rev', 'a'), -1) => ('ifind_msb_rev', 'a')
 *    ('bcsel', ('ige', ('ufind_msb_rev', 'a'), 0), ('ufind_msb_rev', 'a'), -1) => ('ufind_msb_rev', 'a')
 *    ('bcsel', ('ine', 'a', 0), ('find_lsb', 'a'), -1) => ('find_lsb', 'a')
 *    ('bcsel', ('ine', 'a', 0), ('ifind_msb', 'a'), -1) => ('ifind_msb', 'a')
 *    ('bcsel', ('ine', 'a', 0), ('ufind_msb', 'a'), -1) => ('ufind_msb', 'a')
 *    ('bcsel', ('ine', 'a', 0), ('ifind_msb_rev', 'a'), -1) => ('ifind_msb_rev', 'a')
 *    ('bcsel', ('ine', 'a', 0), ('ufind_msb_rev', 'a'), -1) => ('ufind_msb_rev', 'a')
 *    ('bcsel', ('ine', 'a', -1), ('ifind_msb', 'a'), -1) => ('ifind_msb', 'a')
 *    ('bcsel', ('ine', 'a', -1), ('ifind_msb_rev', 'a'), -1) => ('ifind_msb_rev', 'a')
 *    ('bcsel', ('ine', ('ifind_msb', 'a@32'), -1), ('iadd', 31, ('ineg', ('ifind_msb', 'a'))), -1) => ('ifind_msb_rev', 'a')
 *    ('bcsel', ('ine', ('ufind_msb', 'a@32'), -1), ('iadd', 31, ('ineg', ('ufind_msb', 'a'))), -1) => ('ufind_msb_rev', 'a')
 *    ('bcsel', ('ieq', ('ifind_msb', 'a@32'), -1), -1, ('iadd', 31, ('ineg', ('ifind_msb', 'a')))) => ('ifind_msb_rev', 'a')
 *    ('bcsel', ('ieq', ('ufind_msb', 'a@32'), -1), -1, ('iadd', 31, ('ineg', ('ufind_msb', 'a')))) => ('ufind_msb_rev', 'a')
 *    ('bcsel', ('ine', ('ifind_msb', 'a@32'), -1), ('iadd', 31, ('ineg', ('ifind_msb', 'a'))), ('ifind_msb', 'a')) => ('ifind_msb_rev', 'a')
 *    ('bcsel', ('ine', ('ufind_msb', 'a@32'), -1), ('iadd', 31, ('ineg', ('ufind_msb', 'a'))), ('ufind_msb', 'a')) => ('ufind_msb_rev', 'a')
 *    ('bcsel', ('ieq', ('ifind_msb', 'a@32'), -1), ('ifind_msb', 'a'), ('iadd', 31, ('ineg', ('ifind_msb', 'a')))) => ('ifind_msb_rev', 'a')
 *    ('bcsel', ('ieq', ('ufind_msb', 'a@32'), -1), ('ufind_msb', 'a'), ('iadd', 31, ('ineg', ('ufind_msb', 'a')))) => ('ufind_msb_rev', 'a')
 *    ('bcsel', ('ine', 'a@32', 0), ('iadd', 31, ('ineg', ('ufind_msb', 'a'))), -1) => ('ufind_msb_rev', 'a')
 *    ('bcsel', ('ieq', 'a@32', 0), -1, ('iadd', 31, ('ineg', ('ufind_msb', 'a')))) => ('ufind_msb_rev', 'a')
 *    ('bcsel', ('ine', 'a@32', 0), ('iadd', 31, ('ineg', ('ufind_msb', 'a'))), ('ufind_msb', 'a')) => ('ufind_msb_rev', 'a')
 *    ('bcsel', ('ieq', 'a@32', 0), ('ufind_msb', 'a'), ('iadd', 31, ('ineg', ('ufind_msb', 'a')))) => ('ufind_msb_rev', 'a')
 *    ('bcsel', ('ine', ('ifind_msb_rev', 'a@32'), -1), ('iadd', 31, ('ineg', ('ifind_msb_rev', 'a'))), -1) => ('ifind_msb', 'a')
 *    ('bcsel', ('ine', ('ufind_msb_rev', 'a@32'), -1), ('iadd', 31, ('ineg', ('ufind_msb_rev', 'a'))), -1) => ('ufind_msb', 'a')
 *    ('bcsel', ('ieq', ('ifind_msb_rev', 'a@32'), -1), -1, ('iadd', 31, ('ineg', ('ifind_msb_rev', 'a')))) => ('ifind_msb', 'a')
 *    ('bcsel', ('ieq', ('ufind_msb_rev', 'a@32'), -1), -1, ('iadd', 31, ('ineg', ('ufind_msb_rev', 'a')))) => ('ufind_msb', 'a')
 *    ('bcsel', ('ine', ('ifind_msb_rev', 'a@32'), -1), ('iadd', 31, ('ineg', ('ifind_msb_rev', 'a'))), ('ifind_msb_rev', 'a')) => ('ifind_msb', 'a')
 *    ('bcsel', ('ine', ('ufind_msb_rev', 'a@32'), -1), ('iadd', 31, ('ineg', ('ufind_msb_rev', 'a'))), ('ufind_msb_rev', 'a')) => ('ufind_msb', 'a')
 *    ('bcsel', ('ieq', ('ifind_msb_rev', 'a@32'), -1), ('ifind_msb_rev', 'a'), ('iadd', 31, ('ineg', ('ifind_msb_rev', 'a')))) => ('ifind_msb', 'a')
 *    ('bcsel', ('ieq', ('ufind_msb_rev', 'a@32'), -1), ('ufind_msb_rev', 'a'), ('iadd', 31, ('ineg', ('ufind_msb_rev', 'a')))) => ('ufind_msb', 'a')
 *    ('bcsel', ('ine', 'a@32', 0), ('iadd', 31, ('ineg', ('ufind_msb_rev', 'a'))), -1) => ('ufind_msb', 'a')
 *    ('bcsel', ('ieq', 'a@32', 0), -1, ('iadd', 31, ('ineg', ('ufind_msb_rev', 'a')))) => ('ufind_msb', 'a')
 *    ('bcsel', ('ine', 'a@32', 0), ('iadd', 31, ('ineg', ('ufind_msb_rev', 'a'))), ('ufind_msb_rev', 'a')) => ('ufind_msb', 'a')
 *    ('bcsel', ('ieq', 'a@32', 0), ('ufind_msb_rev', 'a'), ('iadd', 31, ('ineg', ('ufind_msb_rev', 'a')))) => ('ufind_msb', 'a')
 *    ('iand', 'a', ('inot', ('ishl', 1, ('find_lsb', 'a')))) => ('iand', 'a', ('inot', ('ineg', 'a')))
 *    ('find_lsb', ('bitfield_reverse', 'a')) => ('ufind_msb_rev', 'a')
 *    ('ufind_msb_rev', ('bitfield_reverse', 'a')) => ('find_lsb', 'a')
 *    ('ifind_msb', ('f2i32(is_used_once)', 'a')) => ('ufind_msb', ('f2i32', ('fabs', 'a')))
 *    ('ifind_msb', ('extract_u8', 'a', 'b')) => ('ufind_msb', ('extract_u8', 'a', 'b'))
 *    ('ifind_msb', ('extract_u16', 'a', 'b')) => ('ufind_msb', ('extract_u16', 'a', 'b'))
 *    ('ifind_msb', ('imax', 'a', 1)) => ('ufind_msb', ('imax', 'a', 1))
 *    ('~fmul', ('bcsel(is_used_once)', 'c', -1.0, 1.0), 'b') => ('bcsel', 'c', ('fneg', 'b'), 'b')
 *    ('~fmul', ('bcsel(is_used_once)', 'c', 1.0, -1.0), 'b') => ('bcsel', 'c', 'b', ('fneg', 'b'))
 *    ('~fmulz', ('bcsel(is_used_once)', 'c', -1.0, 1.0), 'b') => ('bcsel', 'c', ('fneg', 'b'), 'b')
 *    ('~fmulz', ('bcsel(is_used_once)', 'c', 1.0, -1.0), 'b') => ('bcsel', 'c', 'b', ('fneg', 'b'))
 *    ('fabs', ('bcsel(is_used_once)', 'b', ('fneg', 'a'), 'a')) => ('fabs', 'a')
 *    ('fabs', ('bcsel(is_used_once)', 'b', 'a', ('fneg', 'a'))) => ('fabs', 'a')
 *    ('~bcsel', ('flt', 'a', 0.0), ('fneg', 'a'), 'a') => ('fabs', 'a')
 *    ('bcsel', 'a', ('bcsel', 'b', 'c', 'd'), 'd') => ('bcsel', ('iand', 'a', 'b'), 'c', 'd')
 *    ('bcsel', 'a', 'b', ('bcsel', 'c', 'b', 'd')) => ('bcsel', ('ior', 'a', 'c'), 'b', 'd')
 *    ('fmod', 'a', 'b') => ('fsub', 'a', ('fmul', 'b', ('ffloor', ('fdiv', 'a', 'b'))))
 *    ('frem', 'a', 'b') => ('fsub', 'a', ('fmul', 'b', ('ftrunc', ('fdiv', 'a', 'b'))))
 *    ('uadd_carry', 'a', 'b') => ('b2i', ('ult', ('iadd', 'a', 'b'), 'a'))
 *    ('usub_borrow', 'a', 'b') => ('b2i', ('ult', 'a', 'b'))
 *    ('bitfield_insert', 'base', 'insert', 'offset', 'bits') => ('bcsel', ('ult', 31, 'bits'), 'insert', ('bfi', ('bfm', 'bits', 'offset'), 'insert', 'base'))
 *    ('ihadd', 'a', 'b') => ('iadd', ('iand', 'a', 'b'), ('ishr', ('ixor', 'a', 'b'), 1))
 *    ('uhadd', 'a', 'b') => ('iadd', ('iand', 'a', 'b'), ('ushr', ('ixor', 'a', 'b'), 1))
 *    ('irhadd', 'a', 'b') => ('isub', ('ior', 'a', 'b'), ('ishr', ('ixor', 'a', 'b'), 1))
 *    ('urhadd', 'a', 'b') => ('isub', ('ior', 'a', 'b'), ('ushr', ('ixor', 'a', 'b'), 1))
 *    ('ihadd@64', 'a', 'b') => ('iadd', ('iand', 'a', 'b'), ('ishr', ('ixor', 'a', 'b'), 1))
 *    ('uhadd@64', 'a', 'b') => ('iadd', ('iand', 'a', 'b'), ('ushr', ('ixor', 'a', 'b'), 1))
 *    ('irhadd@64', 'a', 'b') => ('isub', ('ior', 'a', 'b'), ('ishr', ('ixor', 'a', 'b'), 1))
 *    ('urhadd@64', 'a', 'b') => ('isub', ('ior', 'a', 'b'), ('ushr', ('ixor', 'a', 'b'), 1))
 *    ('imul_32x16', 'a', 'b') => ('imul', 'a', ('extract_i16', 'b', 0))
 *    ('umul_32x16', 'a', 'b') => ('imul', 'a', ('extract_u16', 'b', 0))
 *    ('uadd_sat@64', 'a', 'b') => ('bcsel', ('ult', ('iadd', 'a', 'b'), 'a'), -1, ('iadd', 'a', 'b'))
 *    ('uadd_sat', 'a', 'b') => ('bcsel', ('ult', ('iadd', 'a', 'b'), 'a'), -1, ('iadd', 'a', 'b'))
 *    ('usub_sat', 'a', 'b') => ('bcsel', ('ult', 'a', 'b'), 0, ('isub', 'a', 'b'))
 *    ('usub_sat@64', 'a', 'b') => ('bcsel', ('ult', 'a', 'b'), 0, ('isub', 'a', 'b'))
 *    ('iadd_sat@64', 'a', 'b') => ('bcsel', ('iand', ('iand', ('ilt', 'a', 0), ('ilt', 'b', 0)), ('ige', ('iadd', 'a', 'b'), 0)), 9223372036854775808, ('bcsel', ('ior', ('ior', ('ilt', 'a', 0), ('ilt', 'b', 0)), ('ige', ('iadd', 'a', 'b'), 0)), ('iadd', 'a', 'b'), 9223372036854775807))
 *    ('isub_sat@64', 'a', 'b') => ('bcsel', ('iand', ('iand', ('ilt', 'a', 0), ('ige', 'b', 0)), ('ige', ('isub', 'a', 'b'), 0)), 9223372036854775808, ('bcsel', ('ior', ('ior', ('ilt', 'a', 0), ('ige', 'b', 0)), ('ige', ('isub', 'a', 'b'), 0)), ('isub', 'a', 'b'), 9223372036854775807))
 *    ('ilt', ('imax(is_used_once)', 'a@64', 'b@64'), 0) => ('ilt', ('imax', ('unpack_64_2x32_split_y', 'a'), ('unpack_64_2x32_split_y', 'b')), 0)
 *    ('ilt', ('imin(is_used_once)', 'a@64', 'b@64'), 0) => ('ilt', ('imin', ('unpack_64_2x32_split_y', 'a'), ('unpack_64_2x32_split_y', 'b')), 0)
 *    ('ige', ('imax(is_used_once)', 'a@64', 'b@64'), 0) => ('ige', ('imax', ('unpack_64_2x32_split_y', 'a'), ('unpack_64_2x32_split_y', 'b')), 0)
 *    ('ige', ('imin(is_used_once)', 'a@64', 'b@64'), 0) => ('ige', ('imin', ('unpack_64_2x32_split_y', 'a'), ('unpack_64_2x32_split_y', 'b')), 0)
 *    ('ilt', 'a@64', 0) => ('ilt', ('unpack_64_2x32_split_y', 'a'), 0)
 *    ('ige', 'a@64', 0) => ('ige', ('unpack_64_2x32_split_y', 'a'), 0)
 *    ('ine', 'a@64', 0) => ('ine', ('ior', ('unpack_64_2x32_split_x', 'a'), ('unpack_64_2x32_split_y', 'a')), 0)
 *    ('ieq', 'a@64', 0) => ('ieq', ('ior', ('unpack_64_2x32_split_x', 'a'), ('unpack_64_2x32_split_y', 'a')), 0)
 *    ('ult', 0, 'a@64') => ('ine', ('ior', ('unpack_64_2x32_split_x', 'a'), ('unpack_64_2x32_split_y', 'a')), 0)
 *    ('bitfield_insert', 'base', 'insert', 'offset', 'bits') => ('bcsel', ('ult', 31, 'bits'), 'insert', ('ior', ('iand', 'base', ('inot', ('ishl', ('isub', ('ishl', 1, 'bits'), 1), 'offset'))), ('iand', ('ishl', 'insert', 'offset'), ('ishl', ('isub', ('ishl', 1, 'bits'), 1), 'offset'))))
 *    ('bitfield_insert', 'base', 'insert', 'offset', 'bits') => ('bcsel', ('ult', 31, 'bits'), 'insert', ('bitfield_select', ('bfm', 'bits', 'offset'), ('ishl', 'insert', 'offset'), 'base'))
 *    ('ibitfield_extract', 'value', 'offset', 'bits') => ('bcsel', ('ult', 31, 'bits'), 'value', ('ibfe', 'value', 'offset', 'bits'))
 *    ('ubitfield_extract', 'value', 'offset', 'bits') => ('bcsel', ('ult', 31, 'bits'), 'value', ('ubfe', 'value', 'offset', 'bits'))
 *    ('bitfield_select', 'a', 'b', 0) => ('iand', 'a', 'b')
 *    ('bitfield_select', 'a', ('iand', 'a', 'b'), 'c') => ('bitfield_select', 'a', 'b', 'c')
 *    ('ubfe', 'value', 'offset', ('iand', 31, 'bits')) => ('ubfe', 'value', 'offset', 'bits')
 *    ('ubfe', 'value', ('iand', 31, 'offset'), 'bits') => ('ubfe', 'value', 'offset', 'bits')
 *    ('ibfe', 'value', 'offset', ('iand', 31, 'bits')) => ('ibfe', 'value', 'offset', 'bits')
 *    ('ibfe', 'value', ('iand', 31, 'offset'), 'bits') => ('ibfe', 'value', 'offset', 'bits')
 *    ('bfm', 'bits', ('iand', 31, 'offset')) => ('bfm', 'bits', 'offset')
 *    ('bfm', ('iand', 31, 'bits'), 'offset') => ('bfm', 'bits', 'offset')
 *    ('ult', 'a', ('umin', ('iand', 'a', 'b'), 'c')) => False
 *    ('ult', 31, ('umin', '#bits(is_ult_32)', 'a')) => False
 *    ('ubfe', 'value', 'offset', ('umin', 'width', ('iadd', 32, ('ineg', ('iand', 31, 'offset'))))) => ('ubfe', 'value', 'offset', 'width')
 *    ('ibfe', 'value', 'offset', ('umin', 'width', ('iadd', 32, ('ineg', ('iand', 31, 'offset'))))) => ('ibfe', 'value', 'offset', 'width')
 *    ('bfm', ('umin', 'width', ('iadd', 32, ('ineg', ('iand', 31, 'offset')))), 'offset') => ('bfm', 'width', 'offset')
 *    ('iadd@32', ('ishl', 1, 'a'), -1) => ('bfm', 'a', 0)
 *    ('ishl', ('bfm', 'a', 0), 'b') => ('bfm', 'a', 'b')
 *    ('ubfe', 'a', 'b', 0) => 0
 *    ('ibfe', 'a', 'b', 0) => 0
 *    ('ubfe', 'a', 0, '#b') => ('iand', 'a', ('ushr', 4294967295, ('ineg', 'b')))
 *    ('b2i32', ('ine', ('ubfe', 'a', 'b', 1), 0)) => ('ubfe', 'a', 'b', 1)
 *    ('b2i32', ('ine', ('ibfe', 'a', 'b', 1), 0)) => ('ubfe', 'a', 'b', 1)
 *    ('ine', ('ibfe(is_used_once)', 'a', '#b', '#c'), 0) => ('ine', ('iand', 'a', ('ishl', ('ushr', 4294967295, ('ineg', 'c')), 'b')), 0)
 *    ('ieq', ('ibfe(is_used_once)', 'a', '#b', '#c'), 0) => ('ieq', ('iand', 'a', ('ishl', ('ushr', 4294967295, ('ineg', 'c')), 'b')), 0)
 *    ('ine', ('ubfe(is_used_once)', 'a', '#b', '#c'), 0) => ('ine', ('iand', 'a', ('ishl', ('ushr', 4294967295, ('ineg', 'c')), 'b')), 0)
 *    ('ieq', ('ubfe(is_used_once)', 'a', '#b', '#c'), 0) => ('ieq', ('iand', 'a', ('ishl', ('ushr', 4294967295, ('ineg', 'c')), 'b')), 0)
 *    ('ibitfield_extract', 'value', 'offset', 'bits') => ('bcsel', ('ieq', 0, 'bits'), 0, ('ishr', ('ishl', 'value', ('isub', ('isub', 32, 'bits'), 'offset')), ('isub', 32, 'bits')))
 *    ('ubitfield_extract', 'value', 'offset', 'bits') => ('iand', ('ushr', 'value', 'offset'), ('bcsel', ('ieq', 'bits', 32), 4294967295, ('isub', ('ishl', 1, 'bits'), 1)))
 *    ('ifind_msb', 'value') => ('ufind_msb', ('bcsel', ('ilt', 'value', 0), ('inot', 'value'), 'value'))
 *    ('ifind_msb', 'value') => ('bcsel', ('ige', ('ifind_msb_rev', 'value'), 0), ('isub', 31, ('ifind_msb_rev', 'value')), ('ifind_msb_rev', 'value'))
 *    ('ifind_msb', 'value') => ('isub', 31, ('uclz', ('ixor', 'value', ('ishr', 'value', 31))))
 *    ('ufind_msb', 'value@32') => ('bcsel', ('ige', ('ufind_msb_rev', 'value'), 0), ('isub', 31, ('ufind_msb_rev', 'value')), ('ufind_msb_rev', 'value'))
 *    ('ufind_msb', 'value@32') => ('isub', 31, ('uclz', 'value'))
 *    ('uclz', 'a') => ('umin', 32, ('ufind_msb_rev', 'a'))
 *    ('find_lsb', 'value@64') => ('ufind_msb', ('iand', 'value', ('ineg', 'value')))
 *    ('find_lsb', 'value') => ('ufind_msb', ('u2u32', ('iand', 'value', ('ineg', 'value'))))
 *    ('extract_i8', 'a', 'b@32') => ('ishr', ('ishl', 'a', ('imul', ('isub', 3, 'b'), 8)), 24)
 *    ('extract_u8', 'a', 'b@32') => ('iand', ('ushr', 'a', ('imul', 'b', 8)), 255)
 *    ('extract_i16', 'a', 'b@32') => ('ishr', ('ishl', 'a', ('imul', ('isub', 1, 'b'), 16)), 16)
 *    ('extract_u16', 'a', 'b@32') => ('iand', ('ushr', 'a', ('imul', 'b', 16)), 65535)
 *    ('pack_unorm_2x16', 'v') => ('pack_uvec2_to_uint', ('f2u32', ('fround_even', ('fmul', ('fsat', 'v'), 65535.0))))
 *    ('pack_unorm_4x8', 'v') => ('pack_uvec4_to_uint', ('f2u32', ('fround_even', ('fmul', ('fsat', 'v'), 255.0))))
 *    ('pack_unorm_4x8', 'v') => ('pack_32_4x8', ('f2u8', ('fround_even', ('fmul', ('fsat', 'v'), 255.0))))
 *    ('pack_snorm_2x16', 'v') => ('pack_uvec2_to_uint', ('f2i32', ('fround_even', ('fmul', ('fmin', 1.0, ('fmax', -1.0, 'v')), 32767.0))))
 *    ('pack_snorm_4x8', 'v') => ('pack_uvec4_to_uint', ('f2i32', ('fround_even', ('fmul', ('fmin', 1.0, ('fmax', -1.0, 'v')), 127.0))))
 *    ('pack_snorm_4x8', 'v') => ('pack_32_4x8', ('f2i8', ('fround_even', ('fmul', ('fmin', 1.0, ('fmax', -1.0, 'v')), 127.0))))
 *    ('unpack_unorm_2x16', 'v') => ('fdiv', ('u2f32', ('vec2', ('extract_u16', 'v', 0), ('extract_u16', 'v', 1))), 65535.0)
 *    ('unpack_unorm_4x8', 'v') => ('fdiv', ('u2f32', ('vec4', ('extract_u8', 'v', 0), ('extract_u8', 'v', 1), ('extract_u8', 'v', 2), ('extract_u8', 'v', 3))), 255.0)
 *    ('unpack_snorm_2x16', 'v') => ('fmin', 1.0, ('fmax', -1.0, ('fdiv', ('i2f', ('vec2', ('extract_i16', 'v', 0), ('extract_i16', 'v', 1))), 32767.0)))
 *    ('unpack_snorm_4x8', 'v') => ('fmin', 1.0, ('fmax', -1.0, ('fdiv', ('i2f', ('vec4', ('extract_i8', 'v', 0), ('extract_i8', 'v', 1), ('extract_i8', 'v', 2), ('extract_i8', 'v', 3))), 127.0)))
 *    ('pack_half_2x16_split', 'a@32', 'b@32') => ('ior', ('ishl', ('u2u32', ('f2f16', 'b')), 16), ('u2u32', ('f2f16', 'a')))
 *    ('unpack_half_2x16_split_x', 'a@32') => ('f2f32', ('u2u16', 'a'))
 *    ('unpack_half_2x16_split_x', 'a@32') => ('f2f32', ('fmul', 1.0, ('u2u16', 'a')))
 *    ('unpack_half_2x16_split_y', 'a@32') => ('f2f32', ('u2u16', ('ushr', 'a', 16)))
 *    ('unpack_half_2x16_split_y', 'a@32') => ('f2f32', ('fmul', 1.0, ('u2u16', ('ushr', 'a', 16))))
 *    ('isign', 'a') => ('imin', ('imax', 'a', -1), 1)
 *    ('imin', ('imax', 'a', -1), 1) => ('isign', 'a')
 *    ('imax', ('imin', 'a', 1), -1) => ('isign', 'a')
 *    ('fsign', 'a') => ('fsub', ('b2f', ('!flt', 0.0, 'a')), ('b2f', ('!flt', 'a', 0.0)))
 *    ('fsign', 'a@64') => ('fsub', ('b2f', ('!flt', 0.0, 'a')), ('b2f', ('!flt', 'a', 0.0)))
 *    ('amul', 'a', 'b') => ('imul', 'a', 'b')
 *    ('umul24', 'a', 'b') => ('imul', ('iand', 'a', 16777215), ('iand', 'b', 16777215))
 *    ('umad24', 'a', 'b', 'c') => ('iadd', ('imul', ('iand', 'a', 16777215), ('iand', 'b', 16777215)), 'c')
 *    ('imul24_relaxed', 'a', 'b') => ('imul24', 'a', 'b')
 *    ('imul24_relaxed', 'a', 'b') => ('imul', 'a', 'b')
 *    ('umad24_relaxed', 'a', 'b', 'c') => ('umad24', 'a', 'b', 'c')
 *    ('umad24_relaxed', 'a', 'b', 'c') => ('iadd', ('umul24_relaxed', 'a', 'b'), 'c')
 *    ('umul24_relaxed', 'a', 'b') => ('umul24', 'a', 'b')
 *    ('umul24_relaxed', 'a', 'b') => ('imul', 'a', 'b')
 *    ('imad24_ir3', 'a', 'b', 0) => ('imul24', 'a', 'b')
 *    ('imad24_ir3', 'a', 0, 'c') => c
 *    ('imad24_ir3', 'a', 1, 'c') => ('iadd', 'a', 'c')
 *    ('imad24_ir3', '#a', '#b', 'c') => ('iadd', ('imul', 'a', 'b'), 'c')
 *    ('imul24', 'a', '#b@32(is_pos_power_of_two)') => ('ishl', 'a', ('find_lsb', 'b'))
 *    ('imul24', 'a', '#b@32(is_neg_power_of_two)') => ('ineg', ('ishl', 'a', ('find_lsb', ('iabs', 'b'))))
 *    ('imul24', 'a', 0) => 0
 *    ('bcsel', ('ult', ('iadd', 'a', 'b'), 'a'), -1, ('iadd@8', 'a', 'b')) => ('uadd_sat', 'a', 'b')
 *    ('bcsel', ('uge', ('iadd', 'a', 'b'), 'a'), ('iadd@8', 'a', 'b'), -1) => ('uadd_sat', 'a', 'b')
 *    ('bcsel', ('ieq', ('uadd_carry', 'a', 'b'), 0), ('iadd@8', 'a', 'b'), -1) => ('uadd_sat', 'a', 'b')
 *    ('bcsel', ('ine', ('uadd_carry', 'a', 'b'), 0), -1, ('iadd@8', 'a', 'b')) => ('uadd_sat', 'a', 'b')
 *    ('bcsel', ('ult', ('iadd', 'a', 'b'), 'a'), -1, ('iadd@16', 'a', 'b')) => ('uadd_sat', 'a', 'b')
 *    ('bcsel', ('uge', ('iadd', 'a', 'b'), 'a'), ('iadd@16', 'a', 'b'), -1) => ('uadd_sat', 'a', 'b')
 *    ('bcsel', ('ieq', ('uadd_carry', 'a', 'b'), 0), ('iadd@16', 'a', 'b'), -1) => ('uadd_sat', 'a', 'b')
 *    ('bcsel', ('ine', ('uadd_carry', 'a', 'b'), 0), -1, ('iadd@16', 'a', 'b')) => ('uadd_sat', 'a', 'b')
 *    ('bcsel', ('ult', ('iadd', 'a', 'b'), 'a'), -1, ('iadd@32', 'a', 'b')) => ('uadd_sat', 'a', 'b')
 *    ('bcsel', ('uge', ('iadd', 'a', 'b'), 'a'), ('iadd@32', 'a', 'b'), -1) => ('uadd_sat', 'a', 'b')
 *    ('bcsel', ('ieq', ('uadd_carry', 'a', 'b'), 0), ('iadd@32', 'a', 'b'), -1) => ('uadd_sat', 'a', 'b')
 *    ('bcsel', ('ine', ('uadd_carry', 'a', 'b'), 0), -1, ('iadd@32', 'a', 'b')) => ('uadd_sat', 'a', 'b')
 *    ('bcsel', ('ult', ('iadd', 'a', 'b'), 'a'), -1, ('iadd@64', 'a', 'b')) => ('uadd_sat', 'a', 'b')
 *    ('bcsel', ('uge', ('iadd', 'a', 'b'), 'a'), ('iadd@64', 'a', 'b'), -1) => ('uadd_sat', 'a', 'b')
 *    ('bcsel', ('ieq', ('uadd_carry', 'a', 'b'), 0), ('iadd@64', 'a', 'b'), -1) => ('uadd_sat', 'a', 'b')
 *    ('bcsel', ('ine', ('uadd_carry', 'a', 'b'), 0), -1, ('iadd@64', 'a', 'b')) => ('uadd_sat', 'a', 'b')
 *    ('bcsel', ('ult', 'a', 'b'), 0, ('iadd@8', 'a', ('ineg', 'b'))) => ('usub_sat', 'a', 'b')
 *    ('bcsel', ('uge', 'a', 'b'), ('iadd@8', 'a', ('ineg', 'b')), 0) => ('usub_sat', 'a', 'b')
 *    ('bcsel', ('ieq', ('usub_borrow', 'a', 'b'), 0), ('iadd@8', 'a', ('ineg', 'b')), 0) => ('usub_sat', 'a', 'b')
 *    ('bcsel', ('ine', ('usub_borrow', 'a', 'b'), 0), 0, ('iadd@8', 'a', ('ineg', 'b'))) => ('usub_sat', 'a', 'b')
 *    ('bcsel', ('ult', 'a', 'b'), 0, ('iadd@16', 'a', ('ineg', 'b'))) => ('usub_sat', 'a', 'b')
 *    ('bcsel', ('uge', 'a', 'b'), ('iadd@16', 'a', ('ineg', 'b')), 0) => ('usub_sat', 'a', 'b')
 *    ('bcsel', ('ieq', ('usub_borrow', 'a', 'b'), 0), ('iadd@16', 'a', ('ineg', 'b')), 0) => ('usub_sat', 'a', 'b')
 *    ('bcsel', ('ine', ('usub_borrow', 'a', 'b'), 0), 0, ('iadd@16', 'a', ('ineg', 'b'))) => ('usub_sat', 'a', 'b')
 *    ('bcsel', ('ult', 'a', 'b'), 0, ('iadd@32', 'a', ('ineg', 'b'))) => ('usub_sat', 'a', 'b')
 *    ('bcsel', ('uge', 'a', 'b'), ('iadd@32', 'a', ('ineg', 'b')), 0) => ('usub_sat', 'a', 'b')
 *    ('bcsel', ('ieq', ('usub_borrow', 'a', 'b'), 0), ('iadd@32', 'a', ('ineg', 'b')), 0) => ('usub_sat', 'a', 'b')
 *    ('bcsel', ('ine', ('usub_borrow', 'a', 'b'), 0), 0, ('iadd@32', 'a', ('ineg', 'b'))) => ('usub_sat', 'a', 'b')
 *    ('bcsel', ('ult', 'a', 'b'), 0, ('iadd@64', 'a', ('ineg', 'b'))) => ('usub_sat', 'a', 'b')
 *    ('bcsel', ('uge', 'a', 'b'), ('iadd@64', 'a', ('ineg', 'b')), 0) => ('usub_sat', 'a', 'b')
 *    ('bcsel', ('ieq', ('usub_borrow', 'a', 'b'), 0), ('iadd@64', 'a', ('ineg', 'b')), 0) => ('usub_sat', 'a', 'b')
 *    ('bcsel', ('ine', ('usub_borrow', 'a', 'b'), 0), 0, ('iadd@64', 'a', ('ineg', 'b'))) => ('usub_sat', 'a', 'b')
 *    ('iadd_sat@8', 'a', 'b') => ('bcsel', ('ige', 'b', 1), ('bcsel', ('ilt', ('iadd', 'a', 'b'), 'a'), 127, ('iadd', 'a', 'b')), ('bcsel', ('ilt', 'a', ('iadd', 'a', 'b')), 128, ('iadd', 'a', 'b')))
 *    ('isub_sat@8', 'a', 'b') => ('bcsel', ('ilt', 'b', 0), ('bcsel', ('ilt', ('isub', 'a', 'b'), 'a'), 127, ('isub', 'a', 'b')), ('bcsel', ('ilt', 'a', ('isub', 'a', 'b')), 128, ('isub', 'a', 'b')))
 *    ('iadd_sat@16', 'a', 'b') => ('bcsel', ('ige', 'b', 1), ('bcsel', ('ilt', ('iadd', 'a', 'b'), 'a'), 32767, ('iadd', 'a', 'b')), ('bcsel', ('ilt', 'a', ('iadd', 'a', 'b')), 32768, ('iadd', 'a', 'b')))
 *    ('isub_sat@16', 'a', 'b') => ('bcsel', ('ilt', 'b', 0), ('bcsel', ('ilt', ('isub', 'a', 'b'), 'a'), 32767, ('isub', 'a', 'b')), ('bcsel', ('ilt', 'a', ('isub', 'a', 'b')), 32768, ('isub', 'a', 'b')))
 *    ('iadd_sat@32', 'a', 'b') => ('bcsel', ('ige', 'b', 1), ('bcsel', ('ilt', ('iadd', 'a', 'b'), 'a'), 2147483647, ('iadd', 'a', 'b')), ('bcsel', ('ilt', 'a', ('iadd', 'a', 'b')), 2147483648, ('iadd', 'a', 'b')))
 *    ('isub_sat@32', 'a', 'b') => ('bcsel', ('ilt', 'b', 0), ('bcsel', ('ilt', ('isub', 'a', 'b'), 'a'), 2147483647, ('isub', 'a', 'b')), ('bcsel', ('ilt', 'a', ('isub', 'a', 'b')), 2147483648, ('isub', 'a', 'b')))
 *    ('iadd_sat@64', 'a', 'b') => ('bcsel', ('ige', 'b', 1), ('bcsel', ('ilt', ('iadd', 'a', 'b'), 'a'), 9223372036854775807, ('iadd', 'a', 'b')), ('bcsel', ('ilt', 'a', ('iadd', 'a', 'b')), 9223372036854775808, ('iadd', 'a', 'b')))
 *    ('isub_sat@64', 'a', 'b') => ('bcsel', ('ilt', 'b', 0), ('bcsel', ('ilt', ('isub', 'a', 'b'), 'a'), 9223372036854775807, ('isub', 'a', 'b')), ('bcsel', ('ilt', 'a', ('isub', 'a', 'b')), 9223372036854775808, ('isub', 'a', 'b')))
 *    ('inot', ('ior(is_used_once)', ('feq', 'a', 'b'), ('feq', 'c', 'd'))) => ('iand', ('fneu', 'a', 'b'), ('fneu', 'c', 'd'))
 *    ('inot', ('iand(is_used_once)', ('feq', 'a', 'b'), ('feq', 'c', 'd'))) => ('ior', ('fneu', 'a', 'b'), ('fneu', 'c', 'd'))
 *    ('inot', ('ior(is_used_once)', ('feq', 'a', 'b'), ('fneu', 'c', 'd'))) => ('iand', ('fneu', 'a', 'b'), ('feq', 'c', 'd'))
 *    ('inot', ('iand(is_used_once)', ('feq', 'a', 'b'), ('fneu', 'c', 'd'))) => ('ior', ('fneu', 'a', 'b'), ('feq', 'c', 'd'))
 *    ('inot', ('ior(is_used_once)', ('fneu', 'a', 'b'), ('fneu', 'c', 'd'))) => ('iand', ('feq', 'a', 'b'), ('feq', 'c', 'd'))
 *    ('inot', ('iand(is_used_once)', ('fneu', 'a', 'b'), ('fneu', 'c', 'd'))) => ('ior', ('feq', 'a', 'b'), ('feq', 'c', 'd'))
 *    ('f2f', ('b2f', 'a')) => ('b2f', 'a')
 *    ('f2u', ('b2f', 'a')) => ('b2i', 'a')
 *    ('f2i', ('b2f', 'a')) => ('b2i', 'a')
 *    ('u2f', ('b2i', 'a')) => ('b2f', 'a')
 *    ('u2u', ('b2i', 'a')) => ('b2i', 'a')
 *    ('i2f', ('b2i', 'a')) => ('b2f', 'a')
 *    ('i2i', ('b2i', 'a')) => ('b2i', 'a')
 *    ('i2i1', 'a@1') => a
 *    ('i2i8', 'a@8') => a
 *    ('i2i16', 'a@16') => a
 *    ('i2i32', 'a@32') => a
 *    ('i2i64', 'a@64') => a
 *    ('u2u1', 'a@1') => a
 *    ('u2u8', 'a@8') => a
 *    ('u2u16', 'a@16') => a
 *    ('u2u32', 'a@32') => a
 *    ('u2u64', 'a@64') => a
 *    ('f2f16', 'a@16') => a
 *    ('f2f32', 'a@32') => a
 *    ('f2f64', 'a@64') => a
 *    ('b2b1', 'a@1') => a
 *    ('b2b8', 'a@8') => a
 *    ('b2b16', 'a@16') => a
 *    ('b2b32', 'a@32') => a
 *    ('i2i1', ('i2i8', 'a')) => ('i2i1', 'a')
 *    ('i2i1', ('u2u8', 'a')) => ('u2u1', 'a')
 *    ('u2u1', ('i2i8', 'a')) => ('i2i1', 'a')
 *    ('u2u1', ('u2u8', 'a')) => ('u2u1', 'a')
 *    ('i2i1', ('i2i16', 'a')) => ('i2i1', 'a')
 *    ('i2i1', ('u2u16', 'a')) => ('u2u1', 'a')
 *    ('u2u1', ('i2i16', 'a')) => ('i2i1', 'a')
 *    ('u2u1', ('u2u16', 'a')) => ('u2u1', 'a')
 *    ('i2i1', ('i2i32', 'a')) => ('i2i1', 'a')
 *    ('i2i1', ('u2u32', 'a')) => ('u2u1', 'a')
 *    ('u2u1', ('i2i32', 'a')) => ('i2i1', 'a')
 *    ('u2u1', ('u2u32', 'a')) => ('u2u1', 'a')
 *    ('i2i1', ('i2i64', 'a')) => ('i2i1', 'a')
 *    ('i2i1', ('u2u64', 'a')) => ('u2u1', 'a')
 *    ('u2u1', ('i2i64', 'a')) => ('i2i1', 'a')
 *    ('u2u1', ('u2u64', 'a')) => ('u2u1', 'a')
 *    ('i2i8', ('i2i1', 'a@1')) => ('i2i8', 'a')
 *    ('u2u8', ('u2u1', 'a@1')) => ('u2u8', 'a')
 *    ('i2i8', ('i2i16', 'a')) => ('i2i8', 'a')
 *    ('i2i8', ('u2u16', 'a')) => ('u2u8', 'a')
 *    ('u2u8', ('i2i16', 'a')) => ('i2i8', 'a')
 *    ('u2u8', ('u2u16', 'a')) => ('u2u8', 'a')
 *    ('i2i8', ('i2i32', 'a')) => ('i2i8', 'a')
 *    ('i2i8', ('u2u32', 'a')) => ('u2u8', 'a')
 *    ('u2u8', ('i2i32', 'a')) => ('i2i8', 'a')
 *    ('u2u8', ('u2u32', 'a')) => ('u2u8', 'a')
 *    ('i2i8', ('i2i64', 'a')) => ('i2i8', 'a')
 *    ('i2i8', ('u2u64', 'a')) => ('u2u8', 'a')
 *    ('u2u8', ('i2i64', 'a')) => ('i2i8', 'a')
 *    ('u2u8', ('u2u64', 'a')) => ('u2u8', 'a')
 *    ('i2i16', ('i2i1', 'a@1')) => ('i2i16', 'a')
 *    ('u2u16', ('u2u1', 'a@1')) => ('u2u16', 'a')
 *    ('i2i16', ('i2i8', 'a@1')) => ('i2i16', 'a')
 *    ('u2u16', ('u2u8', 'a@1')) => ('u2u16', 'a')
 *    ('i2i16', ('i2i8', 'a@8')) => ('i2i16', 'a')
 *    ('u2u16', ('u2u8', 'a@8')) => ('u2u16', 'a')
 *    ('i2i16', ('i2i32', 'a')) => ('i2i16', 'a')
 *    ('i2i16', ('u2u32', 'a')) => ('u2u16', 'a')
 *    ('u2u16', ('i2i32', 'a')) => ('i2i16', 'a')
 *    ('u2u16', ('u2u32', 'a')) => ('u2u16', 'a')
 *    ('i2i16', ('i2i64', 'a')) => ('i2i16', 'a')
 *    ('i2i16', ('u2u64', 'a')) => ('u2u16', 'a')
 *    ('u2u16', ('i2i64', 'a')) => ('i2i16', 'a')
 *    ('u2u16', ('u2u64', 'a')) => ('u2u16', 'a')
 *    ('i2i32', ('i2i1', 'a@1')) => ('i2i32', 'a')
 *    ('u2u32', ('u2u1', 'a@1')) => ('u2u32', 'a')
 *    ('i2i32', ('i2i8', 'a@1')) => ('i2i32', 'a')
 *    ('u2u32', ('u2u8', 'a@1')) => ('u2u32', 'a')
 *    ('i2i32', ('i2i8', 'a@8')) => ('i2i32', 'a')
 *    ('u2u32', ('u2u8', 'a@8')) => ('u2u32', 'a')
 *    ('i2i32', ('i2i16', 'a@1')) => ('i2i32', 'a')
 *    ('u2u32', ('u2u16', 'a@1')) => ('u2u32', 'a')
 *    ('i2i32', ('i2i16', 'a@8')) => ('i2i32', 'a')
 *    ('u2u32', ('u2u16', 'a@8')) => ('u2u32', 'a')
 *    ('i2i32', ('i2i16', 'a@16')) => ('i2i32', 'a')
 *    ('u2u32', ('u2u16', 'a@16')) => ('u2u32', 'a')
 *    ('i2i32', ('i2i64', 'a')) => ('i2i32', 'a')
 *    ('i2i32', ('u2u64', 'a')) => ('u2u32', 'a')
 *    ('u2u32', ('i2i64', 'a')) => ('i2i32', 'a')
 *    ('u2u32', ('u2u64', 'a')) => ('u2u32', 'a')
 *    ('i2i64', ('i2i1', 'a@1')) => ('i2i64', 'a')
 *    ('u2u64', ('u2u1', 'a@1')) => ('u2u64', 'a')
 *    ('i2i64', ('i2i8', 'a@1')) => ('i2i64', 'a')
 *    ('u2u64', ('u2u8', 'a@1')) => ('u2u64', 'a')
 *    ('i2i64', ('i2i8', 'a@8')) => ('i2i64', 'a')
 *    ('u2u64', ('u2u8', 'a@8')) => ('u2u64', 'a')
 *    ('i2i64', ('i2i16', 'a@1')) => ('i2i64', 'a')
 *    ('u2u64', ('u2u16', 'a@1')) => ('u2u64', 'a')
 *    ('i2i64', ('i2i16', 'a@8')) => ('i2i64', 'a')
 *    ('u2u64', ('u2u16', 'a@8')) => ('u2u64', 'a')
 *    ('i2i64', ('i2i16', 'a@16')) => ('i2i64', 'a')
 *    ('u2u64', ('u2u16', 'a@16')) => ('u2u64', 'a')
 *    ('i2i64', ('i2i32', 'a@1')) => ('i2i64', 'a')
 *    ('u2u64', ('u2u32', 'a@1')) => ('u2u64', 'a')
 *    ('i2i64', ('i2i32', 'a@8')) => ('i2i64', 'a')
 *    ('u2u64', ('u2u32', 'a@8')) => ('u2u64', 'a')
 *    ('i2i64', ('i2i32', 'a@16')) => ('i2i64', 'a')
 *    ('u2u64', ('u2u32', 'a@16')) => ('u2u64', 'a')
 *    ('i2i64', ('i2i32', 'a@32')) => ('i2i64', 'a')
 *    ('u2u64', ('u2u32', 'a@32')) => ('u2u64', 'a')
 *    ('i2i8', ('pack_64_2x32_split', 'a', 'b')) => ('i2i8', 'a')
 *    ('i2i8', ('pack_64_2x32_split', 'a', 'b')) => ('i2i8', 'a')
 *    ('i2i16', ('pack_64_2x32_split', 'a', 'b')) => ('i2i16', 'a')
 *    ('i2i16', ('pack_64_2x32_split', 'a', 'b')) => ('i2i16', 'a')
 *    ('i2i32', ('pack_64_2x32_split', 'a', 'b')) => ('i2i32', 'a')
 *    ('i2i32', ('pack_64_2x32_split', 'a', 'b')) => ('i2i32', 'a')
 *    ('u2u8', ('pack_64_2x32_split', 'a', 'b')) => ('u2u8', 'a')
 *    ('u2u8', ('pack_64_2x32_split', 'a', 'b')) => ('u2u8', 'a')
 *    ('u2u16', ('pack_64_2x32_split', 'a', 'b')) => ('u2u16', 'a')
 *    ('u2u16', ('pack_64_2x32_split', 'a', 'b')) => ('u2u16', 'a')
 *    ('u2u32', ('pack_64_2x32_split', 'a', 'b')) => ('u2u32', 'a')
 *    ('u2u32', ('pack_64_2x32_split', 'a', 'b')) => ('u2u32', 'a')
 *    ('ieq', ('i2i16', 'a@8'), ('i2i16', 'b@8')) => ('ieq', 'a', ('i2i8', 'b'))
 *    ('ine', ('i2i16', 'a@8'), ('i2i16', 'b@8')) => ('ine', 'a', ('i2i8', 'b'))
 *    ('ige', ('i2i16', 'a@8'), ('i2i16', 'b@8')) => ('ige', 'a', ('i2i8', 'b'))
 *    ('ilt', ('i2i16', 'a@8'), ('i2i16', 'b@8')) => ('ilt', 'a', ('i2i8', 'b'))
 *    ('ige', ('i2i16', 'b@8'), ('i2i16', 'a@8')) => ('ige', ('i2i8', 'b'), 'a')
 *    ('ilt', ('i2i16', 'b@8'), ('i2i16', 'a@8')) => ('ilt', ('i2i8', 'b'), 'a')
 *    ('ieq', ('i2i16', 'a@8'), '#b') => ('iand', ('ieq', 'a', ('i2i8', 'b')), ('ieq', ('i2i16', ('i2i8', 'b')), 'b'))
 *    ('ine', ('i2i16', 'a@8'), '#b') => ('ior', ('ine', 'a', ('i2i8', 'b')), ('ine', ('i2i16', ('i2i8', 'b')), 'b'))
 *    ('ilt', ('i2i16', 'a@8'), '#b') => ('iand', ('ilt', -128, 'b'), ('ior', ('ilt', 127, 'b'), ('ilt', 'a', ('i2i8', 'b'))))
 *    ('ilt', '#a', ('i2i16', 'b@8')) => ('iand', ('ilt', 'a', 127), ('ior', ('ilt', 'a', -128), ('ilt', ('i2i8', 'a'), 'b')))
 *    ('ige', ('i2i16', 'a@8'), '#b') => ('iand', ('ige', 127, 'b'), ('ior', ('ige', -128, 'b'), ('ige', 'a', ('i2i8', 'b'))))
 *    ('ige', '#a', ('i2i16', 'b@8')) => ('iand', ('ige', 'a', -128), ('ior', ('ige', 'a', 127), ('ige', ('i2i8', 'a'), 'b')))
 *    ('ieq', ('i2i32', 'a@8'), ('i2i32', 'b@8')) => ('ieq', 'a', ('i2i8', 'b'))
 *    ('ine', ('i2i32', 'a@8'), ('i2i32', 'b@8')) => ('ine', 'a', ('i2i8', 'b'))
 *    ('ige', ('i2i32', 'a@8'), ('i2i32', 'b@8')) => ('ige', 'a', ('i2i8', 'b'))
 *    ('ilt', ('i2i32', 'a@8'), ('i2i32', 'b@8')) => ('ilt', 'a', ('i2i8', 'b'))
 *    ('ige', ('i2i32', 'b@8'), ('i2i32', 'a@8')) => ('ige', ('i2i8', 'b'), 'a')
 *    ('ilt', ('i2i32', 'b@8'), ('i2i32', 'a@8')) => ('ilt', ('i2i8', 'b'), 'a')
 *    ('ieq', ('i2i32', 'a@8'), '#b') => ('iand', ('ieq', 'a', ('i2i8', 'b')), ('ieq', ('i2i32', ('i2i8', 'b')), 'b'))
 *    ('ine', ('i2i32', 'a@8'), '#b') => ('ior', ('ine', 'a', ('i2i8', 'b')), ('ine', ('i2i32', ('i2i8', 'b')), 'b'))
 *    ('ilt', ('i2i32', 'a@8'), '#b') => ('iand', ('ilt', -128, 'b'), ('ior', ('ilt', 127, 'b'), ('ilt', 'a', ('i2i8', 'b'))))
 *    ('ilt', '#a', ('i2i32', 'b@8')) => ('iand', ('ilt', 'a', 127), ('ior', ('ilt', 'a', -128), ('ilt', ('i2i8', 'a'), 'b')))
 *    ('ige', ('i2i32', 'a@8'), '#b') => ('iand', ('ige', 127, 'b'), ('ior', ('ige', -128, 'b'), ('ige', 'a', ('i2i8', 'b'))))
 *    ('ige', '#a', ('i2i32', 'b@8')) => ('iand', ('ige', 'a', -128), ('ior', ('ige', 'a', 127), ('ige', ('i2i8', 'a'), 'b')))
 *    ('ieq', ('i2i64', 'a@8'), ('i2i64', 'b@8')) => ('ieq', 'a', ('i2i8', 'b'))
 *    ('ine', ('i2i64', 'a@8'), ('i2i64', 'b@8')) => ('ine', 'a', ('i2i8', 'b'))
 *    ('ige', ('i2i64', 'a@8'), ('i2i64', 'b@8')) => ('ige', 'a', ('i2i8', 'b'))
 *    ('ilt', ('i2i64', 'a@8'), ('i2i64', 'b@8')) => ('ilt', 'a', ('i2i8', 'b'))
 *    ('ige', ('i2i64', 'b@8'), ('i2i64', 'a@8')) => ('ige', ('i2i8', 'b'), 'a')
 *    ('ilt', ('i2i64', 'b@8'), ('i2i64', 'a@8')) => ('ilt', ('i2i8', 'b'), 'a')
 *    ('ieq', ('i2i64', 'a@8'), '#b') => ('iand', ('ieq', 'a', ('i2i8', 'b')), ('ieq', ('i2i64', ('i2i8', 'b')), 'b'))
 *    ('ine', ('i2i64', 'a@8'), '#b') => ('ior', ('ine', 'a', ('i2i8', 'b')), ('ine', ('i2i64', ('i2i8', 'b')), 'b'))
 *    ('ilt', ('i2i64', 'a@8'), '#b') => ('iand', ('ilt', -128, 'b'), ('ior', ('ilt', 127, 'b'), ('ilt', 'a', ('i2i8', 'b'))))
 *    ('ilt', '#a', ('i2i64', 'b@8')) => ('iand', ('ilt', 'a', 127), ('ior', ('ilt', 'a', -128), ('ilt', ('i2i8', 'a'), 'b')))
 *    ('ige', ('i2i64', 'a@8'), '#b') => ('iand', ('ige', 127, 'b'), ('ior', ('ige', -128, 'b'), ('ige', 'a', ('i2i8', 'b'))))
 *    ('ige', '#a', ('i2i64', 'b@8')) => ('iand', ('ige', 'a', -128), ('ior', ('ige', 'a', 127), ('ige', ('i2i8', 'a'), 'b')))
 *    ('ieq', ('i2i32', 'a@16'), ('i2i32', 'b@8')) => ('ieq', 'a', ('i2i16', 'b'))
 *    ('ine', ('i2i32', 'a@16'), ('i2i32', 'b@8')) => ('ine', 'a', ('i2i16', 'b'))
 *    ('ige', ('i2i32', 'a@16'), ('i2i32', 'b@8')) => ('ige', 'a', ('i2i16', 'b'))
 *    ('ilt', ('i2i32', 'a@16'), ('i2i32', 'b@8')) => ('ilt', 'a', ('i2i16', 'b'))
 *    ('ige', ('i2i32', 'b@8'), ('i2i32', 'a@16')) => ('ige', ('i2i16', 'b'), 'a')
 *    ('ilt', ('i2i32', 'b@8'), ('i2i32', 'a@16')) => ('ilt', ('i2i16', 'b'), 'a')
 *    ('ieq', ('i2i32', 'a@16'), ('i2i32', 'b@16')) => ('ieq', 'a', ('i2i16', 'b'))
 *    ('ine', ('i2i32', 'a@16'), ('i2i32', 'b@16')) => ('ine', 'a', ('i2i16', 'b'))
 *    ('ige', ('i2i32', 'a@16'), ('i2i32', 'b@16')) => ('ige', 'a', ('i2i16', 'b'))
 *    ('ilt', ('i2i32', 'a@16'), ('i2i32', 'b@16')) => ('ilt', 'a', ('i2i16', 'b'))
 *    ('ige', ('i2i32', 'b@16'), ('i2i32', 'a@16')) => ('ige', ('i2i16', 'b'), 'a')
 *    ('ilt', ('i2i32', 'b@16'), ('i2i32', 'a@16')) => ('ilt', ('i2i16', 'b'), 'a')
 *    ('ieq', ('i2i32', 'a@16'), '#b') => ('iand', ('ieq', 'a', ('i2i16', 'b')), ('ieq', ('i2i32', ('i2i16', 'b')), 'b'))
 *    ('ine', ('i2i32', 'a@16'), '#b') => ('ior', ('ine', 'a', ('i2i16', 'b')), ('ine', ('i2i32', ('i2i16', 'b')), 'b'))
 *    ('ilt', ('i2i32', 'a@16'), '#b') => ('iand', ('ilt', -32768, 'b'), ('ior', ('ilt', 32767, 'b'), ('ilt', 'a', ('i2i16', 'b'))))
 *    ('ilt', '#a', ('i2i32', 'b@16')) => ('iand', ('ilt', 'a', 32767), ('ior', ('ilt', 'a', -32768), ('ilt', ('i2i16', 'a'), 'b')))
 *    ('ige', ('i2i32', 'a@16'), '#b') => ('iand', ('ige', 32767, 'b'), ('ior', ('ige', -32768, 'b'), ('ige', 'a', ('i2i16', 'b'))))
 *    ('ige', '#a', ('i2i32', 'b@16')) => ('iand', ('ige', 'a', -32768), ('ior', ('ige', 'a', 32767), ('ige', ('i2i16', 'a'), 'b')))
 *    ('ieq', ('i2i64', 'a@16'), ('i2i64', 'b@8')) => ('ieq', 'a', ('i2i16', 'b'))
 *    ('ine', ('i2i64', 'a@16'), ('i2i64', 'b@8')) => ('ine', 'a', ('i2i16', 'b'))
 *    ('ige', ('i2i64', 'a@16'), ('i2i64', 'b@8')) => ('ige', 'a', ('i2i16', 'b'))
 *    ('ilt', ('i2i64', 'a@16'), ('i2i64', 'b@8')) => ('ilt', 'a', ('i2i16', 'b'))
 *    ('ige', ('i2i64', 'b@8'), ('i2i64', 'a@16')) => ('ige', ('i2i16', 'b'), 'a')
 *    ('ilt', ('i2i64', 'b@8'), ('i2i64', 'a@16')) => ('ilt', ('i2i16', 'b'), 'a')
 *    ('ieq', ('i2i64', 'a@16'), ('i2i64', 'b@16')) => ('ieq', 'a', ('i2i16', 'b'))
 *    ('ine', ('i2i64', 'a@16'), ('i2i64', 'b@16')) => ('ine', 'a', ('i2i16', 'b'))
 *    ('ige', ('i2i64', 'a@16'), ('i2i64', 'b@16')) => ('ige', 'a', ('i2i16', 'b'))
 *    ('ilt', ('i2i64', 'a@16'), ('i2i64', 'b@16')) => ('ilt', 'a', ('i2i16', 'b'))
 *    ('ige', ('i2i64', 'b@16'), ('i2i64', 'a@16')) => ('ige', ('i2i16', 'b'), 'a')
 *    ('ilt', ('i2i64', 'b@16'), ('i2i64', 'a@16')) => ('ilt', ('i2i16', 'b'), 'a')
 *    ('ieq', ('i2i64', 'a@16'), '#b') => ('iand', ('ieq', 'a', ('i2i16', 'b')), ('ieq', ('i2i64', ('i2i16', 'b')), 'b'))
 *    ('ine', ('i2i64', 'a@16'), '#b') => ('ior', ('ine', 'a', ('i2i16', 'b')), ('ine', ('i2i64', ('i2i16', 'b')), 'b'))
 *    ('ilt', ('i2i64', 'a@16'), '#b') => ('iand', ('ilt', -32768, 'b'), ('ior', ('ilt', 32767, 'b'), ('ilt', 'a', ('i2i16', 'b'))))
 *    ('ilt', '#a', ('i2i64', 'b@16')) => ('iand', ('ilt', 'a', 32767), ('ior', ('ilt', 'a', -32768), ('ilt', ('i2i16', 'a'), 'b')))
 *    ('ige', ('i2i64', 'a@16'), '#b') => ('iand', ('ige', 32767, 'b'), ('ior', ('ige', -32768, 'b'), ('ige', 'a', ('i2i16', 'b'))))
 *    ('ige', '#a', ('i2i64', 'b@16')) => ('iand', ('ige', 'a', -32768), ('ior', ('ige', 'a', 32767), ('ige', ('i2i16', 'a'), 'b')))
 *    ('ieq', ('i2i64', 'a@32'), ('i2i64', 'b@8')) => ('ieq', 'a', ('i2i32', 'b'))
 *    ('ine', ('i2i64', 'a@32'), ('i2i64', 'b@8')) => ('ine', 'a', ('i2i32', 'b'))
 *    ('ige', ('i2i64', 'a@32'), ('i2i64', 'b@8')) => ('ige', 'a', ('i2i32', 'b'))
 *    ('ilt', ('i2i64', 'a@32'), ('i2i64', 'b@8')) => ('ilt', 'a', ('i2i32', 'b'))
 *    ('ige', ('i2i64', 'b@8'), ('i2i64', 'a@32')) => ('ige', ('i2i32', 'b'), 'a')
 *    ('ilt', ('i2i64', 'b@8'), ('i2i64', 'a@32')) => ('ilt', ('i2i32', 'b'), 'a')
 *    ('ieq', ('i2i64', 'a@32'), ('i2i64', 'b@16')) => ('ieq', 'a', ('i2i32', 'b'))
 *    ('ine', ('i2i64', 'a@32'), ('i2i64', 'b@16')) => ('ine', 'a', ('i2i32', 'b'))
 *    ('ige', ('i2i64', 'a@32'), ('i2i64', 'b@16')) => ('ige', 'a', ('i2i32', 'b'))
 *    ('ilt', ('i2i64', 'a@32'), ('i2i64', 'b@16')) => ('ilt', 'a', ('i2i32', 'b'))
 *    ('ige', ('i2i64', 'b@16'), ('i2i64', 'a@32')) => ('ige', ('i2i32', 'b'), 'a')
 *    ('ilt', ('i2i64', 'b@16'), ('i2i64', 'a@32')) => ('ilt', ('i2i32', 'b'), 'a')
 *    ('ieq', ('i2i64', 'a@32'), ('i2i64', 'b@32')) => ('ieq', 'a', ('i2i32', 'b'))
 *    ('ine', ('i2i64', 'a@32'), ('i2i64', 'b@32')) => ('ine', 'a', ('i2i32', 'b'))
 *    ('ige', ('i2i64', 'a@32'), ('i2i64', 'b@32')) => ('ige', 'a', ('i2i32', 'b'))
 *    ('ilt', ('i2i64', 'a@32'), ('i2i64', 'b@32')) => ('ilt', 'a', ('i2i32', 'b'))
 *    ('ige', ('i2i64', 'b@32'), ('i2i64', 'a@32')) => ('ige', ('i2i32', 'b'), 'a')
 *    ('ilt', ('i2i64', 'b@32'), ('i2i64', 'a@32')) => ('ilt', ('i2i32', 'b'), 'a')
 *    ('ieq', ('i2i64', 'a@32'), '#b') => ('iand', ('ieq', 'a', ('i2i32', 'b')), ('ieq', ('i2i64', ('i2i32', 'b')), 'b'))
 *    ('ine', ('i2i64', 'a@32'), '#b') => ('ior', ('ine', 'a', ('i2i32', 'b')), ('ine', ('i2i64', ('i2i32', 'b')), 'b'))
 *    ('ilt', ('i2i64', 'a@32'), '#b') => ('iand', ('ilt', -2147483648, 'b'), ('ior', ('ilt', 2147483647, 'b'), ('ilt', 'a', ('i2i32', 'b'))))
 *    ('ilt', '#a', ('i2i64', 'b@32')) => ('iand', ('ilt', 'a', 2147483647), ('ior', ('ilt', 'a', -2147483648), ('ilt', ('i2i32', 'a'), 'b')))
 *    ('ige', ('i2i64', 'a@32'), '#b') => ('iand', ('ige', 2147483647, 'b'), ('ior', ('ige', -2147483648, 'b'), ('ige', 'a', ('i2i32', 'b'))))
 *    ('ige', '#a', ('i2i64', 'b@32')) => ('iand', ('ige', 'a', -2147483648), ('ior', ('ige', 'a', 2147483647), ('ige', ('i2i32', 'a'), 'b')))
 *    ('ieq', ('u2u16', 'a@8'), ('u2u16', 'b@8')) => ('ieq', 'a', ('u2u8', 'b'))
 *    ('ine', ('u2u16', 'a@8'), ('u2u16', 'b@8')) => ('ine', 'a', ('u2u8', 'b'))
 *    ('uge', ('u2u16', 'a@8'), ('u2u16', 'b@8')) => ('uge', 'a', ('u2u8', 'b'))
 *    ('ult', ('u2u16', 'a@8'), ('u2u16', 'b@8')) => ('ult', 'a', ('u2u8', 'b'))
 *    ('uge', ('u2u16', 'b@8'), ('u2u16', 'a@8')) => ('uge', ('u2u8', 'b'), 'a')
 *    ('ult', ('u2u16', 'b@8'), ('u2u16', 'a@8')) => ('ult', ('u2u8', 'b'), 'a')
 *    ('ieq', ('u2u16', 'a@8'), '#b') => ('iand', ('ieq', 'a', ('u2u8', 'b')), ('ieq', ('u2u16', ('u2u8', 'b')), 'b'))
 *    ('ine', ('u2u16', 'a@8'), '#b') => ('ior', ('ine', 'a', ('u2u8', 'b')), ('ine', ('u2u16', ('u2u8', 'b')), 'b'))
 *    ('ult', ('u2u16', 'a@8'), '#b') => ('iand', ('ult', 0, 'b'), ('ior', ('ult', 255, 'b'), ('ult', 'a', ('u2u8', 'b'))))
 *    ('ult', '#a', ('u2u16', 'b@8')) => ('iand', ('ult', 'a', 255), ('ior', ('ult', 'a', 0), ('ult', ('u2u8', 'a'), 'b')))
 *    ('uge', ('u2u16', 'a@8'), '#b') => ('iand', ('uge', 255, 'b'), ('ior', ('uge', 0, 'b'), ('uge', 'a', ('u2u8', 'b'))))
 *    ('uge', '#a', ('u2u16', 'b@8')) => ('iand', ('uge', 'a', 0), ('ior', ('uge', 'a', 255), ('uge', ('u2u8', 'a'), 'b')))
 *    ('ieq', ('u2u32', 'a@8'), ('u2u32', 'b@8')) => ('ieq', 'a', ('u2u8', 'b'))
 *    ('ine', ('u2u32', 'a@8'), ('u2u32', 'b@8')) => ('ine', 'a', ('u2u8', 'b'))
 *    ('uge', ('u2u32', 'a@8'), ('u2u32', 'b@8')) => ('uge', 'a', ('u2u8', 'b'))
 *    ('ult', ('u2u32', 'a@8'), ('u2u32', 'b@8')) => ('ult', 'a', ('u2u8', 'b'))
 *    ('uge', ('u2u32', 'b@8'), ('u2u32', 'a@8')) => ('uge', ('u2u8', 'b'), 'a')
 *    ('ult', ('u2u32', 'b@8'), ('u2u32', 'a@8')) => ('ult', ('u2u8', 'b'), 'a')
 *    ('ieq', ('u2u32', 'a@8'), '#b') => ('iand', ('ieq', 'a', ('u2u8', 'b')), ('ieq', ('u2u32', ('u2u8', 'b')), 'b'))
 *    ('ine', ('u2u32', 'a@8'), '#b') => ('ior', ('ine', 'a', ('u2u8', 'b')), ('ine', ('u2u32', ('u2u8', 'b')), 'b'))
 *    ('ult', ('u2u32', 'a@8'), '#b') => ('iand', ('ult', 0, 'b'), ('ior', ('ult', 255, 'b'), ('ult', 'a', ('u2u8', 'b'))))
 *    ('ult', '#a', ('u2u32', 'b@8')) => ('iand', ('ult', 'a', 255), ('ior', ('ult', 'a', 0), ('ult', ('u2u8', 'a'), 'b')))
 *    ('uge', ('u2u32', 'a@8'), '#b') => ('iand', ('uge', 255, 'b'), ('ior', ('uge', 0, 'b'), ('uge', 'a', ('u2u8', 'b'))))
 *    ('uge', '#a', ('u2u32', 'b@8')) => ('iand', ('uge', 'a', 0), ('ior', ('uge', 'a', 255), ('uge', ('u2u8', 'a'), 'b')))
 *    ('ieq', ('u2u64', 'a@8'), ('u2u64', 'b@8')) => ('ieq', 'a', ('u2u8', 'b'))
 *    ('ine', ('u2u64', 'a@8'), ('u2u64', 'b@8')) => ('ine', 'a', ('u2u8', 'b'))
 *    ('uge', ('u2u64', 'a@8'), ('u2u64', 'b@8')) => ('uge', 'a', ('u2u8', 'b'))
 *    ('ult', ('u2u64', 'a@8'), ('u2u64', 'b@8')) => ('ult', 'a', ('u2u8', 'b'))
 *    ('uge', ('u2u64', 'b@8'), ('u2u64', 'a@8')) => ('uge', ('u2u8', 'b'), 'a')
 *    ('ult', ('u2u64', 'b@8'), ('u2u64', 'a@8')) => ('ult', ('u2u8', 'b'), 'a')
 *    ('ieq', ('u2u64', 'a@8'), '#b') => ('iand', ('ieq', 'a', ('u2u8', 'b')), ('ieq', ('u2u64', ('u2u8', 'b')), 'b'))
 *    ('ine', ('u2u64', 'a@8'), '#b') => ('ior', ('ine', 'a', ('u2u8', 'b')), ('ine', ('u2u64', ('u2u8', 'b')), 'b'))
 *    ('ult', ('u2u64', 'a@8'), '#b') => ('iand', ('ult', 0, 'b'), ('ior', ('ult', 255, 'b'), ('ult', 'a', ('u2u8', 'b'))))
 *    ('ult', '#a', ('u2u64', 'b@8')) => ('iand', ('ult', 'a', 255), ('ior', ('ult', 'a', 0), ('ult', ('u2u8', 'a'), 'b')))
 *    ('uge', ('u2u64', 'a@8'), '#b') => ('iand', ('uge', 255, 'b'), ('ior', ('uge', 0, 'b'), ('uge', 'a', ('u2u8', 'b'))))
 *    ('uge', '#a', ('u2u64', 'b@8')) => ('iand', ('uge', 'a', 0), ('ior', ('uge', 'a', 255), ('uge', ('u2u8', 'a'), 'b')))
 *    ('ieq', ('u2u32', 'a@16'), ('u2u32', 'b@8')) => ('ieq', 'a', ('u2u16', 'b'))
 *    ('ine', ('u2u32', 'a@16'), ('u2u32', 'b@8')) => ('ine', 'a', ('u2u16', 'b'))
 *    ('uge', ('u2u32', 'a@16'), ('u2u32', 'b@8')) => ('uge', 'a', ('u2u16', 'b'))
 *    ('ult', ('u2u32', 'a@16'), ('u2u32', 'b@8')) => ('ult', 'a', ('u2u16', 'b'))
 *    ('uge', ('u2u32', 'b@8'), ('u2u32', 'a@16')) => ('uge', ('u2u16', 'b'), 'a')
 *    ('ult', ('u2u32', 'b@8'), ('u2u32', 'a@16')) => ('ult', ('u2u16', 'b'), 'a')
 *    ('ieq', ('u2u32', 'a@16'), ('u2u32', 'b@16')) => ('ieq', 'a', ('u2u16', 'b'))
 *    ('ine', ('u2u32', 'a@16'), ('u2u32', 'b@16')) => ('ine', 'a', ('u2u16', 'b'))
 *    ('uge', ('u2u32', 'a@16'), ('u2u32', 'b@16')) => ('uge', 'a', ('u2u16', 'b'))
 *    ('ult', ('u2u32', 'a@16'), ('u2u32', 'b@16')) => ('ult', 'a', ('u2u16', 'b'))
 *    ('uge', ('u2u32', 'b@16'), ('u2u32', 'a@16')) => ('uge', ('u2u16', 'b'), 'a')
 *    ('ult', ('u2u32', 'b@16'), ('u2u32', 'a@16')) => ('ult', ('u2u16', 'b'), 'a')
 *    ('ieq', ('u2u32', 'a@16'), '#b') => ('iand', ('ieq', 'a', ('u2u16', 'b')), ('ieq', ('u2u32', ('u2u16', 'b')), 'b'))
 *    ('ine', ('u2u32', 'a@16'), '#b') => ('ior', ('ine', 'a', ('u2u16', 'b')), ('ine', ('u2u32', ('u2u16', 'b')), 'b'))
 *    ('ult', ('u2u32', 'a@16'), '#b') => ('iand', ('ult', 0, 'b'), ('ior', ('ult', 65535, 'b'), ('ult', 'a', ('u2u16', 'b'))))
 *    ('ult', '#a', ('u2u32', 'b@16')) => ('iand', ('ult', 'a', 65535), ('ior', ('ult', 'a', 0), ('ult', ('u2u16', 'a'), 'b')))
 *    ('uge', ('u2u32', 'a@16'), '#b') => ('iand', ('uge', 65535, 'b'), ('ior', ('uge', 0, 'b'), ('uge', 'a', ('u2u16', 'b'))))
 *    ('uge', '#a', ('u2u32', 'b@16')) => ('iand', ('uge', 'a', 0), ('ior', ('uge', 'a', 65535), ('uge', ('u2u16', 'a'), 'b')))
 *    ('ieq', ('u2u64', 'a@16'), ('u2u64', 'b@8')) => ('ieq', 'a', ('u2u16', 'b'))
 *    ('ine', ('u2u64', 'a@16'), ('u2u64', 'b@8')) => ('ine', 'a', ('u2u16', 'b'))
 *    ('uge', ('u2u64', 'a@16'), ('u2u64', 'b@8')) => ('uge', 'a', ('u2u16', 'b'))
 *    ('ult', ('u2u64', 'a@16'), ('u2u64', 'b@8')) => ('ult', 'a', ('u2u16', 'b'))
 *    ('uge', ('u2u64', 'b@8'), ('u2u64', 'a@16')) => ('uge', ('u2u16', 'b'), 'a')
 *    ('ult', ('u2u64', 'b@8'), ('u2u64', 'a@16')) => ('ult', ('u2u16', 'b'), 'a')
 *    ('ieq', ('u2u64', 'a@16'), ('u2u64', 'b@16')) => ('ieq', 'a', ('u2u16', 'b'))
 *    ('ine', ('u2u64', 'a@16'), ('u2u64', 'b@16')) => ('ine', 'a', ('u2u16', 'b'))
 *    ('uge', ('u2u64', 'a@16'), ('u2u64', 'b@16')) => ('uge', 'a', ('u2u16', 'b'))
 *    ('ult', ('u2u64', 'a@16'), ('u2u64', 'b@16')) => ('ult', 'a', ('u2u16', 'b'))
 *    ('uge', ('u2u64', 'b@16'), ('u2u64', 'a@16')) => ('uge', ('u2u16', 'b'), 'a')
 *    ('ult', ('u2u64', 'b@16'), ('u2u64', 'a@16')) => ('ult', ('u2u16', 'b'), 'a')
 *    ('ieq', ('u2u64', 'a@16'), '#b') => ('iand', ('ieq', 'a', ('u2u16', 'b')), ('ieq', ('u2u64', ('u2u16', 'b')), 'b'))
 *    ('ine', ('u2u64', 'a@16'), '#b') => ('ior', ('ine', 'a', ('u2u16', 'b')), ('ine', ('u2u64', ('u2u16', 'b')), 'b'))
 *    ('ult', ('u2u64', 'a@16'), '#b') => ('iand', ('ult', 0, 'b'), ('ior', ('ult', 65535, 'b'), ('ult', 'a', ('u2u16', 'b'))))
 *    ('ult', '#a', ('u2u64', 'b@16')) => ('iand', ('ult', 'a', 65535), ('ior', ('ult', 'a', 0), ('ult', ('u2u16', 'a'), 'b')))
 *    ('uge', ('u2u64', 'a@16'), '#b') => ('iand', ('uge', 65535, 'b'), ('ior', ('uge', 0, 'b'), ('uge', 'a', ('u2u16', 'b'))))
 *    ('uge', '#a', ('u2u64', 'b@16')) => ('iand', ('uge', 'a', 0), ('ior', ('uge', 'a', 65535), ('uge', ('u2u16', 'a'), 'b')))
 *    ('ieq', ('u2u64', 'a@32'), ('u2u64', 'b@8')) => ('ieq', 'a', ('u2u32', 'b'))
 *    ('ine', ('u2u64', 'a@32'), ('u2u64', 'b@8')) => ('ine', 'a', ('u2u32', 'b'))
 *    ('uge', ('u2u64', 'a@32'), ('u2u64', 'b@8')) => ('uge', 'a', ('u2u32', 'b'))
 *    ('ult', ('u2u64', 'a@32'), ('u2u64', 'b@8')) => ('ult', 'a', ('u2u32', 'b'))
 *    ('uge', ('u2u64', 'b@8'), ('u2u64', 'a@32')) => ('uge', ('u2u32', 'b'), 'a')
 *    ('ult', ('u2u64', 'b@8'), ('u2u64', 'a@32')) => ('ult', ('u2u32', 'b'), 'a')
 *    ('ieq', ('u2u64', 'a@32'), ('u2u64', 'b@16')) => ('ieq', 'a', ('u2u32', 'b'))
 *    ('ine', ('u2u64', 'a@32'), ('u2u64', 'b@16')) => ('ine', 'a', ('u2u32', 'b'))
 *    ('uge', ('u2u64', 'a@32'), ('u2u64', 'b@16')) => ('uge', 'a', ('u2u32', 'b'))
 *    ('ult', ('u2u64', 'a@32'), ('u2u64', 'b@16')) => ('ult', 'a', ('u2u32', 'b'))
 *    ('uge', ('u2u64', 'b@16'), ('u2u64', 'a@32')) => ('uge', ('u2u32', 'b'), 'a')
 *    ('ult', ('u2u64', 'b@16'), ('u2u64', 'a@32')) => ('ult', ('u2u32', 'b'), 'a')
 *    ('ieq', ('u2u64', 'a@32'), ('u2u64', 'b@32')) => ('ieq', 'a', ('u2u32', 'b'))
 *    ('ine', ('u2u64', 'a@32'), ('u2u64', 'b@32')) => ('ine', 'a', ('u2u32', 'b'))
 *    ('uge', ('u2u64', 'a@32'), ('u2u64', 'b@32')) => ('uge', 'a', ('u2u32', 'b'))
 *    ('ult', ('u2u64', 'a@32'), ('u2u64', 'b@32')) => ('ult', 'a', ('u2u32', 'b'))
 *    ('uge', ('u2u64', 'b@32'), ('u2u64', 'a@32')) => ('uge', ('u2u32', 'b'), 'a')
 *    ('ult', ('u2u64', 'b@32'), ('u2u64', 'a@32')) => ('ult', ('u2u32', 'b'), 'a')
 *    ('ieq', ('u2u64', 'a@32'), '#b') => ('iand', ('ieq', 'a', ('u2u32', 'b')), ('ieq', ('u2u64', ('u2u32', 'b')), 'b'))
 *    ('ine', ('u2u64', 'a@32'), '#b') => ('ior', ('ine', 'a', ('u2u32', 'b')), ('ine', ('u2u64', ('u2u32', 'b')), 'b'))
 *    ('ult', ('u2u64', 'a@32'), '#b') => ('iand', ('ult', 0, 'b'), ('ior', ('ult', 4294967295, 'b'), ('ult', 'a', ('u2u32', 'b'))))
 *    ('ult', '#a', ('u2u64', 'b@32')) => ('iand', ('ult', 'a', 4294967295), ('ior', ('ult', 'a', 0), ('ult', ('u2u32', 'a'), 'b')))
 *    ('uge', ('u2u64', 'a@32'), '#b') => ('iand', ('uge', 4294967295, 'b'), ('ior', ('uge', 0, 'b'), ('uge', 'a', ('u2u32', 'b'))))
 *    ('uge', '#a', ('u2u64', 'b@32')) => ('iand', ('uge', 'a', 0), ('ior', ('uge', 'a', 4294967295), ('uge', ('u2u32', 'a'), 'b')))
 *    ('feq', ('f2f32', 'a@16'), ('f2f32', 'b@16')) => ('feq', 'a', ('f2f16', 'b'))
 *    ('fneu', ('f2f32', 'a@16'), ('f2f32', 'b@16')) => ('fneu', 'a', ('f2f16', 'b'))
 *    ('fge', ('f2f32', 'a@16'), ('f2f32', 'b@16')) => ('fge', 'a', ('f2f16', 'b'))
 *    ('flt', ('f2f32', 'a@16'), ('f2f32', 'b@16')) => ('flt', 'a', ('f2f16', 'b'))
 *    ('fge', ('f2f32', 'b@16'), ('f2f32', 'a@16')) => ('fge', ('f2f16', 'b'), 'a')
 *    ('flt', ('f2f32', 'b@16'), ('f2f32', 'a@16')) => ('flt', ('f2f16', 'b'), 'a')
 *    ('feq', ('f2f64', 'a@16'), ('f2f64', 'b@16')) => ('feq', 'a', ('f2f16', 'b'))
 *    ('fneu', ('f2f64', 'a@16'), ('f2f64', 'b@16')) => ('fneu', 'a', ('f2f16', 'b'))
 *    ('fge', ('f2f64', 'a@16'), ('f2f64', 'b@16')) => ('fge', 'a', ('f2f16', 'b'))
 *    ('flt', ('f2f64', 'a@16'), ('f2f64', 'b@16')) => ('flt', 'a', ('f2f16', 'b'))
 *    ('fge', ('f2f64', 'b@16'), ('f2f64', 'a@16')) => ('fge', ('f2f16', 'b'), 'a')
 *    ('flt', ('f2f64', 'b@16'), ('f2f64', 'a@16')) => ('flt', ('f2f16', 'b'), 'a')
 *    ('feq', ('f2f64', 'a@32'), ('f2f64', 'b@16')) => ('feq', 'a', ('f2f32', 'b'))
 *    ('fneu', ('f2f64', 'a@32'), ('f2f64', 'b@16')) => ('fneu', 'a', ('f2f32', 'b'))
 *    ('fge', ('f2f64', 'a@32'), ('f2f64', 'b@16')) => ('fge', 'a', ('f2f32', 'b'))
 *    ('flt', ('f2f64', 'a@32'), ('f2f64', 'b@16')) => ('flt', 'a', ('f2f32', 'b'))
 *    ('fge', ('f2f64', 'b@16'), ('f2f64', 'a@32')) => ('fge', ('f2f32', 'b'), 'a')
 *    ('flt', ('f2f64', 'b@16'), ('f2f64', 'a@32')) => ('flt', ('f2f32', 'b'), 'a')
 *    ('feq', ('f2f64', 'a@32'), ('f2f64', 'b@32')) => ('feq', 'a', ('f2f32', 'b'))
 *    ('fneu', ('f2f64', 'a@32'), ('f2f64', 'b@32')) => ('fneu', 'a', ('f2f32', 'b'))
 *    ('fge', ('f2f64', 'a@32'), ('f2f64', 'b@32')) => ('fge', 'a', ('f2f32', 'b'))
 *    ('flt', ('f2f64', 'a@32'), ('f2f64', 'b@32')) => ('flt', 'a', ('f2f32', 'b'))
 *    ('fge', ('f2f64', 'b@32'), ('f2f64', 'a@32')) => ('fge', ('f2f32', 'b'), 'a')
 *    ('flt', ('f2f64', 'b@32'), ('f2f64', 'a@32')) => ('flt', ('f2f32', 'b'), 'a')
 *    ('i2i32', ('iand', 'a@64', 4294967295)) => ('u2u32', 'a')
 *    ('i2i16', ('iand', 'a@32', 65535)) => ('u2u16', 'a')
 *    ('i2i16', ('iand', 'a@64', 65535)) => ('u2u16', 'a')
 *    ('i2i8', ('iand', 'a@16', 255)) => ('u2u8', 'a')
 *    ('i2i8', ('iand', 'a@32', 255)) => ('u2u8', 'a')
 *    ('i2i8', ('iand', 'a@64', 255)) => ('u2u8', 'a')
 *    ('u2u16(only_lower_8_bits_used)', ('u2u8', 'a@16')) => a
 *    ('extract_u8(only_lower_8_bits_used)', 'a@16', 0) => a
 *    ('bcsel(only_lower_8_bits_used)', 'c', ('u2u16', ('u2u8', 'a@16')), 'b') => ('bcsel', 'c', 'a', 'b')
 *    ('bcsel(only_lower_8_bits_used)', 'c', ('u2u16', ('i2i8', 'a@16')), 'b') => ('bcsel', 'c', 'a', 'b')
 *    ('bcsel(only_lower_8_bits_used)', 'c', ('extract_u8', 'a@16', 0), 'b') => ('bcsel', 'c', 'a', 'b')
 *    ('iadd(only_lower_8_bits_used)', ('u2u16', ('u2u8', 'a@16')), 'b') => ('iadd', 'a', 'b')
 *    ('iadd(only_lower_8_bits_used)', ('u2u16', ('i2i8', 'a@16')), 'b') => ('iadd', 'a', 'b')
 *    ('iadd(only_lower_8_bits_used)', ('extract_u8', 'a@16', 0), 'b') => ('iadd', 'a', 'b')
 *    ('imul(only_lower_8_bits_used)', ('u2u16', ('u2u8', 'a@16')), 'b') => ('imul', 'a', 'b')
 *    ('imul(only_lower_8_bits_used)', ('u2u16', ('i2i8', 'a@16')), 'b') => ('imul', 'a', 'b')
 *    ('imul(only_lower_8_bits_used)', ('extract_u8', 'a@16', 0), 'b') => ('imul', 'a', 'b')
 *    ('iand(only_lower_8_bits_used)', ('u2u16', ('u2u8', 'a@16')), 'b') => ('iand', 'a', 'b')
 *    ('iand(only_lower_8_bits_used)', ('u2u16', ('i2i8', 'a@16')), 'b') => ('iand', 'a', 'b')
 *    ('iand(only_lower_8_bits_used)', ('extract_u8', 'a@16', 0), 'b') => ('iand', 'a', 'b')
 *    ('ior(only_lower_8_bits_used)', ('u2u16', ('u2u8', 'a@16')), 'b') => ('ior', 'a', 'b')
 *    ('ior(only_lower_8_bits_used)', ('u2u16', ('i2i8', 'a@16')), 'b') => ('ior', 'a', 'b')
 *    ('ior(only_lower_8_bits_used)', ('extract_u8', 'a@16', 0), 'b') => ('ior', 'a', 'b')
 *    ('ixor(only_lower_8_bits_used)', ('u2u16', ('u2u8', 'a@16')), 'b') => ('ixor', 'a', 'b')
 *    ('ixor(only_lower_8_bits_used)', ('u2u16', ('i2i8', 'a@16')), 'b') => ('ixor', 'a', 'b')
 *    ('ixor(only_lower_8_bits_used)', ('extract_u8', 'a@16', 0), 'b') => ('ixor', 'a', 'b')
 *    ('i2i16(only_lower_8_bits_used)', ('u2u8', 'a@16')) => a
 *    ('extract_i8(only_lower_8_bits_used)', 'a@16', 0) => a
 *    ('bcsel(only_lower_8_bits_used)', 'c', ('i2i16', ('u2u8', 'a@16')), 'b') => ('bcsel', 'c', 'a', 'b')
 *    ('bcsel(only_lower_8_bits_used)', 'c', ('i2i16', ('i2i8', 'a@16')), 'b') => ('bcsel', 'c', 'a', 'b')
 *    ('bcsel(only_lower_8_bits_used)', 'c', ('extract_i8', 'a@16', 0), 'b') => ('bcsel', 'c', 'a', 'b')
 *    ('iadd(only_lower_8_bits_used)', ('i2i16', ('u2u8', 'a@16')), 'b') => ('iadd', 'a', 'b')
 *    ('iadd(only_lower_8_bits_used)', ('i2i16', ('i2i8', 'a@16')), 'b') => ('iadd', 'a', 'b')
 *    ('iadd(only_lower_8_bits_used)', ('extract_i8', 'a@16', 0), 'b') => ('iadd', 'a', 'b')
 *    ('imul(only_lower_8_bits_used)', ('i2i16', ('u2u8', 'a@16')), 'b') => ('imul', 'a', 'b')
 *    ('imul(only_lower_8_bits_used)', ('i2i16', ('i2i8', 'a@16')), 'b') => ('imul', 'a', 'b')
 *    ('imul(only_lower_8_bits_used)', ('extract_i8', 'a@16', 0), 'b') => ('imul', 'a', 'b')
 *    ('iand(only_lower_8_bits_used)', ('i2i16', ('u2u8', 'a@16')), 'b') => ('iand', 'a', 'b')
 *    ('iand(only_lower_8_bits_used)', ('i2i16', ('i2i8', 'a@16')), 'b') => ('iand', 'a', 'b')
 *    ('iand(only_lower_8_bits_used)', ('extract_i8', 'a@16', 0), 'b') => ('iand', 'a', 'b')
 *    ('ior(only_lower_8_bits_used)', ('i2i16', ('u2u8', 'a@16')), 'b') => ('ior', 'a', 'b')
 *    ('ior(only_lower_8_bits_used)', ('i2i16', ('i2i8', 'a@16')), 'b') => ('ior', 'a', 'b')
 *    ('ior(only_lower_8_bits_used)', ('extract_i8', 'a@16', 0), 'b') => ('ior', 'a', 'b')
 *    ('ixor(only_lower_8_bits_used)', ('i2i16', ('u2u8', 'a@16')), 'b') => ('ixor', 'a', 'b')
 *    ('ixor(only_lower_8_bits_used)', ('i2i16', ('i2i8', 'a@16')), 'b') => ('ixor', 'a', 'b')
 *    ('ixor(only_lower_8_bits_used)', ('extract_i8', 'a@16', 0), 'b') => ('ixor', 'a', 'b')
 *    ('u2u32(only_lower_8_bits_used)', ('u2u8', 'a@32')) => a
 *    ('extract_u8(only_lower_8_bits_used)', 'a@32', 0) => a
 *    ('bcsel(only_lower_8_bits_used)', 'c', ('u2u32', ('u2u8', 'a@32')), 'b') => ('bcsel', 'c', 'a', 'b')
 *    ('bcsel(only_lower_8_bits_used)', 'c', ('u2u32', ('i2i8', 'a@32')), 'b') => ('bcsel', 'c', 'a', 'b')
 *    ('bcsel(only_lower_8_bits_used)', 'c', ('extract_u8', 'a@32', 0), 'b') => ('bcsel', 'c', 'a', 'b')
 *    ('iadd(only_lower_8_bits_used)', ('u2u32', ('u2u8', 'a@32')), 'b') => ('iadd', 'a', 'b')
 *    ('iadd(only_lower_8_bits_used)', ('u2u32', ('i2i8', 'a@32')), 'b') => ('iadd', 'a', 'b')
 *    ('iadd(only_lower_8_bits_used)', ('extract_u8', 'a@32', 0), 'b') => ('iadd', 'a', 'b')
 *    ('imul(only_lower_8_bits_used)', ('u2u32', ('u2u8', 'a@32')), 'b') => ('imul', 'a', 'b')
 *    ('imul(only_lower_8_bits_used)', ('u2u32', ('i2i8', 'a@32')), 'b') => ('imul', 'a', 'b')
 *    ('imul(only_lower_8_bits_used)', ('extract_u8', 'a@32', 0), 'b') => ('imul', 'a', 'b')
 *    ('iand(only_lower_8_bits_used)', ('u2u32', ('u2u8', 'a@32')), 'b') => ('iand', 'a', 'b')
 *    ('iand(only_lower_8_bits_used)', ('u2u32', ('i2i8', 'a@32')), 'b') => ('iand', 'a', 'b')
 *    ('iand(only_lower_8_bits_used)', ('extract_u8', 'a@32', 0), 'b') => ('iand', 'a', 'b')
 *    ('ior(only_lower_8_bits_used)', ('u2u32', ('u2u8', 'a@32')), 'b') => ('ior', 'a', 'b')
 *    ('ior(only_lower_8_bits_used)', ('u2u32', ('i2i8', 'a@32')), 'b') => ('ior', 'a', 'b')
 *    ('ior(only_lower_8_bits_used)', ('extract_u8', 'a@32', 0), 'b') => ('ior', 'a', 'b')
 *    ('ixor(only_lower_8_bits_used)', ('u2u32', ('u2u8', 'a@32')), 'b') => ('ixor', 'a', 'b')
 *    ('ixor(only_lower_8_bits_used)', ('u2u32', ('i2i8', 'a@32')), 'b') => ('ixor', 'a', 'b')
 *    ('ixor(only_lower_8_bits_used)', ('extract_u8', 'a@32', 0), 'b') => ('ixor', 'a', 'b')
 *    ('i2i32(only_lower_8_bits_used)', ('u2u8', 'a@32')) => a
 *    ('extract_i8(only_lower_8_bits_used)', 'a@32', 0) => a
 *    ('bcsel(only_lower_8_bits_used)', 'c', ('i2i32', ('u2u8', 'a@32')), 'b') => ('bcsel', 'c', 'a', 'b')
 *    ('bcsel(only_lower_8_bits_used)', 'c', ('i2i32', ('i2i8', 'a@32')), 'b') => ('bcsel', 'c', 'a', 'b')
 *    ('bcsel(only_lower_8_bits_used)', 'c', ('extract_i8', 'a@32', 0), 'b') => ('bcsel', 'c', 'a', 'b')
 *    ('iadd(only_lower_8_bits_used)', ('i2i32', ('u2u8', 'a@32')), 'b') => ('iadd', 'a', 'b')
 *    ('iadd(only_lower_8_bits_used)', ('i2i32', ('i2i8', 'a@32')), 'b') => ('iadd', 'a', 'b')
 *    ('iadd(only_lower_8_bits_used)', ('extract_i8', 'a@32', 0), 'b') => ('iadd', 'a', 'b')
 *    ('imul(only_lower_8_bits_used)', ('i2i32', ('u2u8', 'a@32')), 'b') => ('imul', 'a', 'b')
 *    ('imul(only_lower_8_bits_used)', ('i2i32', ('i2i8', 'a@32')), 'b') => ('imul', 'a', 'b')
 *    ('imul(only_lower_8_bits_used)', ('extract_i8', 'a@32', 0), 'b') => ('imul', 'a', 'b')
 *    ('iand(only_lower_8_bits_used)', ('i2i32', ('u2u8', 'a@32')), 'b') => ('iand', 'a', 'b')
 *    ('iand(only_lower_8_bits_used)', ('i2i32', ('i2i8', 'a@32')), 'b') => ('iand', 'a', 'b')
 *    ('iand(only_lower_8_bits_used)', ('extract_i8', 'a@32', 0), 'b') => ('iand', 'a', 'b')
 *    ('ior(only_lower_8_bits_used)', ('i2i32', ('u2u8', 'a@32')), 'b') => ('ior', 'a', 'b')
 *    ('ior(only_lower_8_bits_used)', ('i2i32', ('i2i8', 'a@32')), 'b') => ('ior', 'a', 'b')
 *    ('ior(only_lower_8_bits_used)', ('extract_i8', 'a@32', 0), 'b') => ('ior', 'a', 'b')
 *    ('ixor(only_lower_8_bits_used)', ('i2i32', ('u2u8', 'a@32')), 'b') => ('ixor', 'a', 'b')
 *    ('ixor(only_lower_8_bits_used)', ('i2i32', ('i2i8', 'a@32')), 'b') => ('ixor', 'a', 'b')
 *    ('ixor(only_lower_8_bits_used)', ('extract_i8', 'a@32', 0), 'b') => ('ixor', 'a', 'b')
 *    ('u2u32(only_lower_16_bits_used)', ('u2u16', 'a@32')) => a
 *    ('extract_u16(only_lower_16_bits_used)', 'a@32', 0) => a
 *    ('bcsel(only_lower_16_bits_used)', 'c', ('u2u32', ('u2u16', 'a@32')), 'b') => ('bcsel', 'c', 'a', 'b')
 *    ('bcsel(only_lower_16_bits_used)', 'c', ('u2u32', ('i2i16', 'a@32')), 'b') => ('bcsel', 'c', 'a', 'b')
 *    ('bcsel(only_lower_16_bits_used)', 'c', ('extract_u16', 'a@32', 0), 'b') => ('bcsel', 'c', 'a', 'b')
 *    ('iadd(only_lower_16_bits_used)', ('u2u32', ('u2u16', 'a@32')), 'b') => ('iadd', 'a', 'b')
 *    ('iadd(only_lower_16_bits_used)', ('u2u32', ('i2i16', 'a@32')), 'b') => ('iadd', 'a', 'b')
 *    ('iadd(only_lower_16_bits_used)', ('extract_u16', 'a@32', 0), 'b') => ('iadd', 'a', 'b')
 *    ('imul(only_lower_16_bits_used)', ('u2u32', ('u2u16', 'a@32')), 'b') => ('imul', 'a', 'b')
 *    ('imul(only_lower_16_bits_used)', ('u2u32', ('i2i16', 'a@32')), 'b') => ('imul', 'a', 'b')
 *    ('imul(only_lower_16_bits_used)', ('extract_u16', 'a@32', 0), 'b') => ('imul', 'a', 'b')
 *    ('iand(only_lower_16_bits_used)', ('u2u32', ('u2u16', 'a@32')), 'b') => ('iand', 'a', 'b')
 *    ('iand(only_lower_16_bits_used)', ('u2u32', ('i2i16', 'a@32')), 'b') => ('iand', 'a', 'b')
 *    ('iand(only_lower_16_bits_used)', ('extract_u16', 'a@32', 0), 'b') => ('iand', 'a', 'b')
 *    ('ior(only_lower_16_bits_used)', ('u2u32', ('u2u16', 'a@32')), 'b') => ('ior', 'a', 'b')
 *    ('ior(only_lower_16_bits_used)', ('u2u32', ('i2i16', 'a@32')), 'b') => ('ior', 'a', 'b')
 *    ('ior(only_lower_16_bits_used)', ('extract_u16', 'a@32', 0), 'b') => ('ior', 'a', 'b')
 *    ('ixor(only_lower_16_bits_used)', ('u2u32', ('u2u16', 'a@32')), 'b') => ('ixor', 'a', 'b')
 *    ('ixor(only_lower_16_bits_used)', ('u2u32', ('i2i16', 'a@32')), 'b') => ('ixor', 'a', 'b')
 *    ('ixor(only_lower_16_bits_used)', ('extract_u16', 'a@32', 0), 'b') => ('ixor', 'a', 'b')
 *    ('i2i32(only_lower_16_bits_used)', ('u2u16', 'a@32')) => a
 *    ('extract_i16(only_lower_16_bits_used)', 'a@32', 0) => a
 *    ('bcsel(only_lower_16_bits_used)', 'c', ('i2i32', ('u2u16', 'a@32')), 'b') => ('bcsel', 'c', 'a', 'b')
 *    ('bcsel(only_lower_16_bits_used)', 'c', ('i2i32', ('i2i16', 'a@32')), 'b') => ('bcsel', 'c', 'a', 'b')
 *    ('bcsel(only_lower_16_bits_used)', 'c', ('extract_i16', 'a@32', 0), 'b') => ('bcsel', 'c', 'a', 'b')
 *    ('iadd(only_lower_16_bits_used)', ('i2i32', ('u2u16', 'a@32')), 'b') => ('iadd', 'a', 'b')
 *    ('iadd(only_lower_16_bits_used)', ('i2i32', ('i2i16', 'a@32')), 'b') => ('iadd', 'a', 'b')
 *    ('iadd(only_lower_16_bits_used)', ('extract_i16', 'a@32', 0), 'b') => ('iadd', 'a', 'b')
 *    ('imul(only_lower_16_bits_used)', ('i2i32', ('u2u16', 'a@32')), 'b') => ('imul', 'a', 'b')
 *    ('imul(only_lower_16_bits_used)', ('i2i32', ('i2i16', 'a@32')), 'b') => ('imul', 'a', 'b')
 *    ('imul(only_lower_16_bits_used)', ('extract_i16', 'a@32', 0), 'b') => ('imul', 'a', 'b')
 *    ('iand(only_lower_16_bits_used)', ('i2i32', ('u2u16', 'a@32')), 'b') => ('iand', 'a', 'b')
 *    ('iand(only_lower_16_bits_used)', ('i2i32', ('i2i16', 'a@32')), 'b') => ('iand', 'a', 'b')
 *    ('iand(only_lower_16_bits_used)', ('extract_i16', 'a@32', 0), 'b') => ('iand', 'a', 'b')
 *    ('ior(only_lower_16_bits_used)', ('i2i32', ('u2u16', 'a@32')), 'b') => ('ior', 'a', 'b')
 *    ('ior(only_lower_16_bits_used)', ('i2i32', ('i2i16', 'a@32')), 'b') => ('ior', 'a', 'b')
 *    ('ior(only_lower_16_bits_used)', ('extract_i16', 'a@32', 0), 'b') => ('ior', 'a', 'b')
 *    ('ixor(only_lower_16_bits_used)', ('i2i32', ('u2u16', 'a@32')), 'b') => ('ixor', 'a', 'b')
 *    ('ixor(only_lower_16_bits_used)', ('i2i32', ('i2i16', 'a@32')), 'b') => ('ixor', 'a', 'b')
 *    ('ixor(only_lower_16_bits_used)', ('extract_i16', 'a@32', 0), 'b') => ('ixor', 'a', 'b')
 *    ('ldexp@16', 'x', 'exp') => ('fmul', ('fmul', 'x', ('i2i16', ('ishl', ('iadd', ('ishr', ('imin', ('imax', 'exp', -30), 30), 1), 15), 10))), ('i2i16', ('ishl', ('iadd', ('isub', ('imin', ('imax', 'exp', -30), 30), ('ishr', ('imin', ('imax', 'exp', -30), 30), 1)), 15), 10)))
 *    ('ldexp@32', 'x', 'exp') => ('fmul', ('fmul', 'x', ('ishl', ('iadd', ('ishr', ('imin', ('imax', 'exp', -254), 254), 1), 127), 23)), ('ishl', ('iadd', ('isub', ('imin', ('imax', 'exp', -254), 254), ('ishr', ('imin', ('imax', 'exp', -254), 254), 1)), 127), 23))
 *    ('ldexp@64', 'x', 'exp') => ('fmul', ('fmul', 'x', ('pack_64_2x32_split', 0, ('ishl', ('iadd', ('ishr', ('imin', ('imax', 'exp', -2046), 2046), 1), 1023), 20))), ('pack_64_2x32_split', 0, ('ishl', ('iadd', ('isub', ('imin', ('imax', 'exp', -2046), 2046), ('ishr', ('imin', ('imax', 'exp', -2046), 2046), 1)), 1023), 20)))
 *    ('iadd(many-comm-expr)', ('iand', ('ishl', ('iadd', ('iand', ('ishl', ('iadd', ('iand', ('ishl', ('iadd', ('iand', ('ishl', ('iadd', ('ishl', 'x@32', 16), ('ushr', 'x@32', 16)), 1), 2863311530), ('iand', ('ushr', ('iadd', ('ishl', 'x@32', 16), ('ushr', 'x@32', 16)), 1), 1431655765)), 2), 3435973836), ('iand', ('ushr', ('iadd', ('iand', ('ishl', ('iadd', ('ishl', 'x@32', 16), ('ushr', 'x@32', 16)), 1), 2863311530), ('iand', ('ushr', ('iadd', ('ishl', 'x@32', 16), ('ushr', 'x@32', 16)), 1), 1431655765)), 2), 858993459)), 4), 4042322160), ('iand', ('ushr', ('iadd', ('iand', ('ishl', ('iadd', ('iand', ('ishl', ('iadd', ('ishl', 'x@32', 16), ('ushr', 'x@32', 16)), 1), 2863311530), ('iand', ('ushr', ('iadd', ('ishl', 'x@32', 16), ('ushr', 'x@32', 16)), 1), 1431655765)), 2), 3435973836), ('iand', ('ushr', ('iadd', ('iand', ('ishl', ('iadd', ('ishl', 'x@32', 16), ('ushr', 'x@32', 16)), 1), 2863311530), ('iand', ('ushr', ('iadd', ('ishl', 'x@32', 16), ('ushr', 'x@32', 16)), 1), 1431655765)), 2), 858993459)), 4), 252645135)), 8), 4278255360), ('iand', ('ushr', ('iadd', ('iand', ('ishl', ('iadd', ('iand', ('ishl', ('iadd', ('iand', ('ishl', ('iadd', ('ishl', 'x@32', 16), ('ushr', 'x@32', 16)), 1), 2863311530), ('iand', ('ushr', ('iadd', ('ishl', 'x@32', 16), ('ushr', 'x@32', 16)), 1), 1431655765)), 2), 3435973836), ('iand', ('ushr', ('iadd', ('iand', ('ishl', ('iadd', ('ishl', 'x@32', 16), ('ushr', 'x@32', 16)), 1), 2863311530), ('iand', ('ushr', ('iadd', ('ishl', 'x@32', 16), ('ushr', 'x@32', 16)), 1), 1431655765)), 2), 858993459)), 4), 4042322160), ('iand', ('ushr', ('iadd', ('iand', ('ishl', ('iadd', ('iand', ('ishl', ('iadd', ('ishl', 'x@32', 16), ('ushr', 'x@32', 16)), 1), 2863311530), ('iand', ('ushr', ('iadd', ('ishl', 'x@32', 16), ('ushr', 'x@32', 16)), 1), 1431655765)), 2), 3435973836), ('iand', ('ushr', ('iadd', ('iand', ('ishl', ('iadd', ('ishl', 'x@32', 16), ('ushr', 'x@32', 16)), 1), 2863311530), ('iand', ('ushr', ('iadd', ('ishl', 'x@32', 16), ('ushr', 'x@32', 16)), 1), 1431655765)), 2), 858993459)), 4), 252645135)), 8), 16711935)) => ('bitfield_reverse', 'x')
 *    ('ior(many-comm-expr)', ('ishl', ('iand', ('ior', ('ishl', ('iand', ('ior', ('ishl', ('iand', ('ior', ('ishl', ('iand', ('ior', ('ishl', 'x@32', 16), ('ushr', 'x@32', 16)), 16711935), 8), ('ushr', ('iand', ('ior', ('ishl', 'x@32', 16), ('ushr', 'x@32', 16)), 4278255360), 8)), 252645135), 4), ('ushr', ('iand', ('ior', ('ishl', ('iand', ('ior', ('ishl', 'x@32', 16), ('ushr', 'x@32', 16)), 16711935), 8), ('ushr', ('iand', ('ior', ('ishl', 'x@32', 16), ('ushr', 'x@32', 16)), 4278255360), 8)), 4042322160), 4)), 858993459), 2), ('ushr', ('iand', ('ior', ('ishl', ('iand', ('ior', ('ishl', ('iand', ('ior', ('ishl', 'x@32', 16), ('ushr', 'x@32', 16)), 16711935), 8), ('ushr', ('iand', ('ior', ('ishl', 'x@32', 16), ('ushr', 'x@32', 16)), 4278255360), 8)), 252645135), 4), ('ushr', ('iand', ('ior', ('ishl', ('iand', ('ior', ('ishl', 'x@32', 16), ('ushr', 'x@32', 16)), 16711935), 8), ('ushr', ('iand', ('ior', ('ishl', 'x@32', 16), ('ushr', 'x@32', 16)), 4278255360), 8)), 4042322160), 4)), 3435973836), 2)), 1431655765), 1), ('ushr', ('iand', ('ior', ('ishl', ('iand', ('ior', ('ishl', ('iand', ('ior', ('ishl', ('iand', ('ior', ('ishl', 'x@32', 16), ('ushr', 'x@32', 16)), 16711935), 8), ('ushr', ('iand', ('ior', ('ishl', 'x@32', 16), ('ushr', 'x@32', 16)), 4278255360), 8)), 252645135), 4), ('ushr', ('iand', ('ior', ('ishl', ('iand', ('ior', ('ishl', 'x@32', 16), ('ushr', 'x@32', 16)), 16711935), 8), ('ushr', ('iand', ('ior', ('ishl', 'x@32', 16), ('ushr', 'x@32', 16)), 4278255360), 8)), 4042322160), 4)), 858993459), 2), ('ushr', ('iand', ('ior', ('ishl', ('iand', ('ior', ('ishl', ('iand', ('ior', ('ishl', 'x@32', 16), ('ushr', 'x@32', 16)), 16711935), 8), ('ushr', ('iand', ('ior', ('ishl', 'x@32', 16), ('ushr', 'x@32', 16)), 4278255360), 8)), 252645135), 4), ('ushr', ('iand', ('ior', ('ishl', ('iand', ('ior', ('ishl', 'x@32', 16), ('ushr', 'x@32', 16)), 16711935), 8), ('ushr', ('iand', ('ior', ('ishl', 'x@32', 16), ('ushr', 'x@32', 16)), 4278255360), 8)), 4042322160), 4)), 3435973836), 2)), 2863311530), 1)) => ('bitfield_reverse', 'x')
 *    ('ior(many-comm-expr)', ('iand', ('ishl', ('ior', ('iand', ('ishl', ('ior', ('iand', ('ishl', ('ior', ('iand', ('ishl', ('ior', ('ishl', 'x@32', 16), ('ushr', 'x@32', 16)), 1), 2863311530), ('iand', ('ushr', ('ior', ('ishl', 'x@32', 16), ('ushr', 'x@32', 16)), 1), 1431655765)), 2), 3435973836), ('iand', ('ushr', ('ior', ('iand', ('ishl', ('ior', ('ishl', 'x@32', 16), ('ushr', 'x@32', 16)), 1), 2863311530), ('iand', ('ushr', ('ior', ('ishl', 'x@32', 16), ('ushr', 'x@32', 16)), 1), 1431655765)), 2), 858993459)), 4), 4042322160), ('iand', ('ushr', ('ior', ('iand', ('ishl', ('ior', ('iand', ('ishl', ('ior', ('ishl', 'x@32', 16), ('ushr', 'x@32', 16)), 1), 2863311530), ('iand', ('ushr', ('ior', ('ishl', 'x@32', 16), ('ushr', 'x@32', 16)), 1), 1431655765)), 2), 3435973836), ('iand', ('ushr', ('ior', ('iand', ('ishl', ('ior', ('ishl', 'x@32', 16), ('ushr', 'x@32', 16)), 1), 2863311530), ('iand', ('ushr', ('ior', ('ishl', 'x@32', 16), ('ushr', 'x@32', 16)), 1), 1431655765)), 2), 858993459)), 4), 252645135)), 8), 4278255360), ('iand', ('ushr', ('ior', ('iand', ('ishl', ('ior', ('iand', ('ishl', ('ior', ('iand', ('ishl', ('ior', ('ishl', 'x@32', 16), ('ushr', 'x@32', 16)), 1), 2863311530), ('iand', ('ushr', ('ior', ('ishl', 'x@32', 16), ('ushr', 'x@32', 16)), 1), 1431655765)), 2), 3435973836), ('iand', ('ushr', ('ior', ('iand', ('ishl', ('ior', ('ishl', 'x@32', 16), ('ushr', 'x@32', 16)), 1), 2863311530), ('iand', ('ushr', ('ior', ('ishl', 'x@32', 16), ('ushr', 'x@32', 16)), 1), 1431655765)), 2), 858993459)), 4), 4042322160), ('iand', ('ushr', ('ior', ('iand', ('ishl', ('ior', ('iand', ('ishl', ('ior', ('ishl', 'x@32', 16), ('ushr', 'x@32', 16)), 1), 2863311530), ('iand', ('ushr', ('ior', ('ishl', 'x@32', 16), ('ushr', 'x@32', 16)), 1), 1431655765)), 2), 3435973836), ('iand', ('ushr', ('ior', ('iand', ('ishl', ('ior', ('ishl', 'x@32', 16), ('ushr', 'x@32', 16)), 1), 2863311530), ('iand', ('ushr', ('ior', ('ishl', 'x@32', 16), ('ushr', 'x@32', 16)), 1), 1431655765)), 2), 858993459)), 4), 252645135)), 8), 16711935)) => ('bitfield_reverse', 'x')
 *    ('bcsel', ('iand', ('ine', ('fabs', 'x'), 2139095040), ('ieq', ('iand', ('pack_half_2x16_rtz_split', 'x', 0), 32767), 31744)), ('iadd', ('pack_half_2x16_rtz_split', 'x', 0), 4294967295), ('pack_half_2x16_rtz_split', 'x', 0)) => ('pack_half_2x16_rtz_split', 'x', 0)
 *    ('bcsel', ('iand', ('ine', 'x', 2139095040), ('ieq', ('iand', ('pack_half_2x16_rtz_split', 'x(is_not_negative)', 0), 32767), 31744)), ('iadd', ('pack_half_2x16_rtz_split', 'x(is_not_negative)', 0), 4294967295), ('pack_half_2x16_rtz_split', 'x(is_not_negative)', 0)) => ('pack_half_2x16_rtz_split', 'x', 0)
 *    ('bcsel', ('iand', ('ine', ('fabs', 'x'), 2139095040), ('ieq', ('iand', ('pack_half_2x16_rtz_split', ('fneg', 'x'), 0), 32767), 31744)), ('iadd', ('pack_half_2x16_rtz_split', ('fneg', 'x'), 0), 4294967295), ('pack_half_2x16_rtz_split', ('fneg', 'x'), 0)) => ('pack_half_2x16_rtz_split', ('fneg', 'x'), 0)
 *    ('iadd(many-comm-expr)', ('iadd', ('iadd', ('bcsel', ('ieq', ('extract_u8', 'a@32', 0), 0), 0, ('iabs', ('iadd', ('extract_u8', 'a@32', 0), ('ineg', ('extract_u8', 'b@32', 0))))), ('bcsel', ('ieq', ('extract_u8', 'a@32', 1), 0), 0, ('iabs', ('iadd', ('extract_u8', 'a@32', 1), ('ineg', ('extract_u8', 'b@32', 1)))))), ('bcsel', ('ieq', ('extract_u8', 'a@32', 2), 0), 0, ('iabs', ('iadd', ('extract_u8', 'a@32', 2), ('ineg', ('extract_u8', 'b@32', 2)))))), ('bcsel', ('ieq', ('extract_u8', 'a@32', 3), 0), 0, ('iabs', ('iadd', ('extract_u8', 'a@32', 3), ('ineg', ('extract_u8', 'b@32', 3)))))) => ('msad_4x8', 'a', 'b', 0)
 *    ('iadd', ('msad_4x8', 'a', 'b', 0), 'c') => ('msad_4x8', 'a', 'b', 'c')
 *    ('ball_iequal2', ('ieq', 'a', 'b'), -1) => ('ball_iequal2', 'a', 'b')
 *    ('ball_iequal2', ('feq', 'a', 'b'), -1) => ('ball_fequal2', 'a', 'b')
 *    ('bany_inequal2', ('ine', 'a', 'b'), 0) => ('bany_inequal2', 'a', 'b')
 *    ('bany_inequal2', ('fneu', 'a', 'b'), 0) => ('bany_fnequal2', 'a', 'b')
 *    ('ball_iequal3', ('ieq', 'a', 'b'), -1) => ('ball_iequal3', 'a', 'b')
 *    ('ball_iequal3', ('feq', 'a', 'b'), -1) => ('ball_fequal3', 'a', 'b')
 *    ('bany_inequal3', ('ine', 'a', 'b'), 0) => ('bany_inequal3', 'a', 'b')
 *    ('bany_inequal3', ('fneu', 'a', 'b'), 0) => ('bany_fnequal3', 'a', 'b')
 *    ('ball_iequal4', ('ieq', 'a', 'b'), -1) => ('ball_iequal4', 'a', 'b')
 *    ('ball_iequal4', ('feq', 'a', 'b'), -1) => ('ball_fequal4', 'a', 'b')
 *    ('bany_inequal4', ('ine', 'a', 'b'), 0) => ('bany_inequal4', 'a', 'b')
 *    ('bany_inequal4', ('fneu', 'a', 'b'), 0) => ('bany_fnequal4', 'a', 'b')
 *    ('ball_iequal8', ('ieq', 'a', 'b'), -1) => ('ball_iequal8', 'a', 'b')
 *    ('ball_iequal8', ('feq', 'a', 'b'), -1) => ('ball_fequal8', 'a', 'b')
 *    ('bany_inequal8', ('ine', 'a', 'b'), 0) => ('bany_inequal8', 'a', 'b')
 *    ('bany_inequal8', ('fneu', 'a', 'b'), 0) => ('bany_fnequal8', 'a', 'b')
 *    ('ball_iequal16', ('ieq', 'a', 'b'), -1) => ('ball_iequal16', 'a', 'b')
 *    ('ball_iequal16', ('feq', 'a', 'b'), -1) => ('ball_fequal16', 'a', 'b')
 *    ('bany_inequal16', ('ine', 'a', 'b'), 0) => ('bany_inequal16', 'a', 'b')
 *    ('bany_inequal16', ('fneu', 'a', 'b'), 0) => ('bany_fnequal16', 'a', 'b')
 *    ('iand', ('feq', 'a', 'a'), ('flt', 'a', 'b')) => ('!flt', 'a', 'b')
 *    ('iand', ('feq', 'a', 'a'), ('flt', 'b', 'a')) => ('!flt', 'b', 'a')
 *    ('iand', ('feq', 'a', 'a'), ('fge', 'a', 'b')) => ('!fge', 'a', 'b')
 *    ('iand', ('feq', 'a', 'a'), ('fge', 'b', 'a')) => ('!fge', 'b', 'a')
 *    ('iand', ('feq', 'a', 'a'), ('feq', 'a', 'b')) => ('!feq', 'a', 'b')
 *    ('iand', ('feq', 'a', 'a'), ('feq', 'b', 'a')) => ('!feq', 'b', 'a')
 *    ('feq', ('bcsel', 'a', '#b', '#c'), '#d') => ('bcsel', 'a', ('feq', 'b', 'd'), ('feq', 'c', 'd'))
 *    ('fneu', ('bcsel', 'a', '#b', '#c'), '#d') => ('bcsel', 'a', ('fneu', 'b', 'd'), ('fneu', 'c', 'd'))
 *    ('ieq', ('bcsel', 'a', '#b', '#c'), '#d') => ('bcsel', 'a', ('ieq', 'b', 'd'), ('ieq', 'c', 'd'))
 *    ('ine', ('bcsel', 'a', '#b', '#c'), '#d') => ('bcsel', 'a', ('ine', 'b', 'd'), ('ine', 'c', 'd'))
 *    ('flt', ('bcsel', 'a', '#b', '#c'), '#d') => ('bcsel', 'a', ('flt', 'b', 'd'), ('flt', 'c', 'd'))
 *    ('flt', '#d', ('bcsel', 'a', '#b', '#c')) => ('bcsel', 'a', ('flt', 'd', 'b'), ('flt', 'd', 'c'))
 *    ('fge', ('bcsel', 'a', '#b', '#c'), '#d') => ('bcsel', 'a', ('fge', 'b', 'd'), ('fge', 'c', 'd'))
 *    ('fge', '#d', ('bcsel', 'a', '#b', '#c')) => ('bcsel', 'a', ('fge', 'd', 'b'), ('fge', 'd', 'c'))
 *    ('ilt', ('bcsel', 'a', '#b', '#c'), '#d') => ('bcsel', 'a', ('ilt', 'b', 'd'), ('ilt', 'c', 'd'))
 *    ('ilt', '#d', ('bcsel', 'a', '#b', '#c')) => ('bcsel', 'a', ('ilt', 'd', 'b'), ('ilt', 'd', 'c'))
 *    ('ige', ('bcsel', 'a', '#b', '#c'), '#d') => ('bcsel', 'a', ('ige', 'b', 'd'), ('ige', 'c', 'd'))
 *    ('ige', '#d', ('bcsel', 'a', '#b', '#c')) => ('bcsel', 'a', ('ige', 'd', 'b'), ('ige', 'd', 'c'))
 *    ('ult', ('bcsel', 'a', '#b', '#c'), '#d') => ('bcsel', 'a', ('ult', 'b', 'd'), ('ult', 'c', 'd'))
 *    ('ult', '#d', ('bcsel', 'a', '#b', '#c')) => ('bcsel', 'a', ('ult', 'd', 'b'), ('ult', 'd', 'c'))
 *    ('uge', ('bcsel', 'a', '#b', '#c'), '#d') => ('bcsel', 'a', ('uge', 'b', 'd'), ('uge', 'c', 'd'))
 *    ('uge', '#d', ('bcsel', 'a', '#b', '#c')) => ('bcsel', 'a', ('uge', 'd', 'b'), ('uge', 'd', 'c'))
 *    ('fadd', ('bcsel(is_used_once)', 'a', '#b', 'c'), '#d') => ('bcsel', 'a', ('fadd', 'b', 'd'), ('fadd', 'c', 'd'))
 *    ('fmul', ('bcsel(is_used_once)', 'a', '#b', 'c'), '#d') => ('bcsel', 'a', ('fmul', 'b', 'd'), ('fmul', 'c', 'd'))
 *    ('fmulz', ('bcsel(is_used_once)', 'a', '#b', 'c'), '#d') => ('bcsel', 'a', ('fmulz', 'b', 'd'), ('fmulz', 'c', 'd'))
 *    ('iadd', ('bcsel(is_used_once)', 'a', '#b', 'c'), '#d') => ('bcsel', 'a', ('iadd', 'b', 'd'), ('iadd', 'c', 'd'))
 *    ('imul', ('bcsel(is_used_once)', 'a', '#b', 'c'), '#d') => ('bcsel', 'a', ('imul', 'b', 'd'), ('imul', 'c', 'd'))
 *    ('umul_low', '#a(is_lower_half_zero)', 'b') => 0
 *    ('imadsh_mix16', '#a@32(is_lower_half_zero)', 'b@32', 'c@32') => c
 *    ('imadsh_mix16', 'a@32', '#b@32(is_upper_half_zero)', 'c@32') => c
 *    ('bcsel', 'a', ('flrp(is_used_once)', 'b', 'c', 'd'), ('flrp', 'b', 'c', 'e')) => ('flrp', 'b', 'c', ('bcsel', 'a', 'd', 'e'))
 *    ('bcsel', 'a', ('flrp', 'b', 'c', 'd'), ('flrp(is_used_once)', 'b', 'c', 'e')) => ('flrp', 'b', 'c', ('bcsel', 'a', 'd', 'e'))
 *    ('bcsel', 'a', ('flrp(is_used_once)', 'b', 'c', 'd'), ('flrp', 'b', 'e', 'd')) => ('flrp', 'b', ('bcsel', 'a', 'c', 'e'), 'd')
 *    ('bcsel', 'a', ('flrp', 'b', 'c', 'd'), ('flrp(is_used_once)', 'b', 'e', 'd')) => ('flrp', 'b', ('bcsel', 'a', 'c', 'e'), 'd')
 *    ('bcsel', 'a', ('flrp(is_used_once)', 'b', 'c', 'd'), ('flrp', 'e', 'c', 'd')) => ('flrp', ('bcsel', 'a', 'b', 'e'), 'c', 'd')
 *    ('bcsel', 'a', ('flrp', 'b', 'c', 'd'), ('flrp(is_used_once)', 'e', 'c', 'd')) => ('flrp', ('bcsel', 'a', 'b', 'e'), 'c', 'd')
 *    ('bcsel', 'a', ('fmulz(is_used_once)', 'b', 'c'), ('fmulz', 'b', 'd(is_not_const)')) => ('fmulz', 'b', ('bcsel', 'a', 'c', 'd'))
 *    ('bcsel', 'a', ('fmulz(is_used_once)', 'b', 'c(is_not_const)'), ('fmulz', 'b', 'd')) => ('fmulz', 'b', ('bcsel', 'a', 'c', 'd'))
 *    ('bcsel', 'a', ('fmulz', 'b', 'c(is_not_const)'), ('fmulz(is_used_once)', 'b', 'd')) => ('fmulz', 'b', ('bcsel', 'a', 'c', 'd'))
 *    ('bcsel', 'a', ('fmulz', 'b', 'c'), ('fmulz(is_used_once)', 'b', 'd(is_not_const)')) => ('fmulz', 'b', ('bcsel', 'a', 'c', 'd'))
 *    ('bcsel', 'a', ('fmul(is_used_once)', 'b', 'c'), ('fmul', 'b', 'd(is_not_const)')) => ('fmul', 'b', ('bcsel', 'a', 'c', 'd'))
 *    ('bcsel', 'a', ('fmul(is_used_once)', 'b', 'c(is_not_const)'), ('fmul', 'b', 'd')) => ('fmul', 'b', ('bcsel', 'a', 'c', 'd'))
 *    ('bcsel', 'a', ('fmul', 'b', 'c(is_not_const)'), ('fmul(is_used_once)', 'b', 'd')) => ('fmul', 'b', ('bcsel', 'a', 'c', 'd'))
 *    ('bcsel', 'a', ('fmul', 'b', 'c'), ('fmul(is_used_once)', 'b', 'd(is_not_const)')) => ('fmul', 'b', ('bcsel', 'a', 'c', 'd'))
 *    ('bcsel', 'a', ('iadd(is_used_once)', 'b', 'c'), ('iadd', 'b', 'd(is_not_const)')) => ('iadd', 'b', ('bcsel', 'a', 'c', 'd'))
 *    ('bcsel', 'a', ('iadd(is_used_once)', 'b', 'c(is_not_const)'), ('iadd', 'b', 'd')) => ('iadd', 'b', ('bcsel', 'a', 'c', 'd'))
 *    ('bcsel', 'a', ('iadd', 'b', 'c(is_not_const)'), ('iadd(is_used_once)', 'b', 'd')) => ('iadd', 'b', ('bcsel', 'a', 'c', 'd'))
 *    ('bcsel', 'a', ('iadd', 'b', 'c'), ('iadd(is_used_once)', 'b', 'd(is_not_const)')) => ('iadd', 'b', ('bcsel', 'a', 'c', 'd'))
 *    ('bcsel', 'a', ('imul(is_used_once)', 'b', 'c'), ('imul', 'b', 'd(is_not_const)')) => ('imul', 'b', ('bcsel', 'a', 'c', 'd'))
 *    ('bcsel', 'a', ('imul(is_used_once)', 'b', 'c(is_not_const)'), ('imul', 'b', 'd')) => ('imul', 'b', ('bcsel', 'a', 'c', 'd'))
 *    ('bcsel', 'a', ('imul', 'b', 'c(is_not_const)'), ('imul(is_used_once)', 'b', 'd')) => ('imul', 'b', ('bcsel', 'a', 'c', 'd'))
 *    ('bcsel', 'a', ('imul', 'b', 'c'), ('imul(is_used_once)', 'b', 'd(is_not_const)')) => ('imul', 'b', ('bcsel', 'a', 'c', 'd'))
 *    ('bcsel', 'a', ('iand(is_used_once)', 'b', 'c'), ('iand', 'b', 'd(is_not_const)')) => ('iand', 'b', ('bcsel', 'a', 'c', 'd'))
 *    ('bcsel', 'a', ('iand(is_used_once)', 'b', 'c(is_not_const)'), ('iand', 'b', 'd')) => ('iand', 'b', ('bcsel', 'a', 'c', 'd'))
 *    ('bcsel', 'a', ('iand', 'b', 'c(is_not_const)'), ('iand(is_used_once)', 'b', 'd')) => ('iand', 'b', ('bcsel', 'a', 'c', 'd'))
 *    ('bcsel', 'a', ('iand', 'b', 'c'), ('iand(is_used_once)', 'b', 'd(is_not_const)')) => ('iand', 'b', ('bcsel', 'a', 'c', 'd'))
 *    ('bcsel', 'a', ('ior(is_used_once)', 'b', 'c'), ('ior', 'b', 'd(is_not_const)')) => ('ior', 'b', ('bcsel', 'a', 'c', 'd'))
 *    ('bcsel', 'a', ('ior(is_used_once)', 'b', 'c(is_not_const)'), ('ior', 'b', 'd')) => ('ior', 'b', ('bcsel', 'a', 'c', 'd'))
 *    ('bcsel', 'a', ('ior', 'b', 'c(is_not_const)'), ('ior(is_used_once)', 'b', 'd')) => ('ior', 'b', ('bcsel', 'a', 'c', 'd'))
 *    ('bcsel', 'a', ('ior', 'b', 'c'), ('ior(is_used_once)', 'b', 'd(is_not_const)')) => ('ior', 'b', ('bcsel', 'a', 'c', 'd'))
 *    ('bcsel', 'a', ('ixor(is_used_once)', 'b', 'c'), ('ixor', 'b', 'd(is_not_const)')) => ('ixor', 'b', ('bcsel', 'a', 'c', 'd'))
 *    ('bcsel', 'a', ('ixor(is_used_once)', 'b', 'c(is_not_const)'), ('ixor', 'b', 'd')) => ('ixor', 'b', ('bcsel', 'a', 'c', 'd'))
 *    ('bcsel', 'a', ('ixor', 'b', 'c(is_not_const)'), ('ixor(is_used_once)', 'b', 'd')) => ('ixor', 'b', ('bcsel', 'a', 'c', 'd'))
 *    ('bcsel', 'a', ('ixor', 'b', 'c'), ('ixor(is_used_once)', 'b', 'd(is_not_const)')) => ('ixor', 'b', ('bcsel', 'a', 'c', 'd'))
 *    ('bcsel', 'a', ('fmin(is_used_once)', 'b', 'c'), ('fmin', 'b', 'd(is_not_const)')) => ('fmin', 'b', ('bcsel', 'a', 'c', 'd'))
 *    ('bcsel', 'a', ('fmin(is_used_once)', 'b', 'c(is_not_const)'), ('fmin', 'b', 'd')) => ('fmin', 'b', ('bcsel', 'a', 'c', 'd'))
 *    ('bcsel', 'a', ('fmin', 'b', 'c(is_not_const)'), ('fmin(is_used_once)', 'b', 'd')) => ('fmin', 'b', ('bcsel', 'a', 'c', 'd'))
 *    ('bcsel', 'a', ('fmin', 'b', 'c'), ('fmin(is_used_once)', 'b', 'd(is_not_const)')) => ('fmin', 'b', ('bcsel', 'a', 'c', 'd'))
 *    ('bcsel', 'a', ('fmax(is_used_once)', 'b', 'c'), ('fmax', 'b', 'd(is_not_const)')) => ('fmax', 'b', ('bcsel', 'a', 'c', 'd'))
 *    ('bcsel', 'a', ('fmax(is_used_once)', 'b', 'c(is_not_const)'), ('fmax', 'b', 'd')) => ('fmax', 'b', ('bcsel', 'a', 'c', 'd'))
 *    ('bcsel', 'a', ('fmax', 'b', 'c(is_not_const)'), ('fmax(is_used_once)', 'b', 'd')) => ('fmax', 'b', ('bcsel', 'a', 'c', 'd'))
 *    ('bcsel', 'a', ('fmax', 'b', 'c'), ('fmax(is_used_once)', 'b', 'd(is_not_const)')) => ('fmax', 'b', ('bcsel', 'a', 'c', 'd'))
 *    ('bcsel', 'a', ('imin(is_used_once)', 'b', 'c'), ('imin', 'b', 'd(is_not_const)')) => ('imin', 'b', ('bcsel', 'a', 'c', 'd'))
 *    ('bcsel', 'a', ('imin(is_used_once)', 'b', 'c(is_not_const)'), ('imin', 'b', 'd')) => ('imin', 'b', ('bcsel', 'a', 'c', 'd'))
 *    ('bcsel', 'a', ('imin', 'b', 'c(is_not_const)'), ('imin(is_used_once)', 'b', 'd')) => ('imin', 'b', ('bcsel', 'a', 'c', 'd'))
 *    ('bcsel', 'a', ('imin', 'b', 'c'), ('imin(is_used_once)', 'b', 'd(is_not_const)')) => ('imin', 'b', ('bcsel', 'a', 'c', 'd'))
 *    ('bcsel', 'a', ('imax(is_used_once)', 'b', 'c'), ('imax', 'b', 'd(is_not_const)')) => ('imax', 'b', ('bcsel', 'a', 'c', 'd'))
 *    ('bcsel', 'a', ('imax(is_used_once)', 'b', 'c(is_not_const)'), ('imax', 'b', 'd')) => ('imax', 'b', ('bcsel', 'a', 'c', 'd'))
 *    ('bcsel', 'a', ('imax', 'b', 'c(is_not_const)'), ('imax(is_used_once)', 'b', 'd')) => ('imax', 'b', ('bcsel', 'a', 'c', 'd'))
 *    ('bcsel', 'a', ('imax', 'b', 'c'), ('imax(is_used_once)', 'b', 'd(is_not_const)')) => ('imax', 'b', ('bcsel', 'a', 'c', 'd'))
 *    ('bcsel', 'a', ('umin(is_used_once)', 'b', 'c'), ('umin', 'b', 'd(is_not_const)')) => ('umin', 'b', ('bcsel', 'a', 'c', 'd'))
 *    ('bcsel', 'a', ('umin(is_used_once)', 'b', 'c(is_not_const)'), ('umin', 'b', 'd')) => ('umin', 'b', ('bcsel', 'a', 'c', 'd'))
 *    ('bcsel', 'a', ('umin', 'b', 'c(is_not_const)'), ('umin(is_used_once)', 'b', 'd')) => ('umin', 'b', ('bcsel', 'a', 'c', 'd'))
 *    ('bcsel', 'a', ('umin', 'b', 'c'), ('umin(is_used_once)', 'b', 'd(is_not_const)')) => ('umin', 'b', ('bcsel', 'a', 'c', 'd'))
 *    ('bcsel', 'a', ('umax(is_used_once)', 'b', 'c'), ('umax', 'b', 'd(is_not_const)')) => ('umax', 'b', ('bcsel', 'a', 'c', 'd'))
 *    ('bcsel', 'a', ('umax(is_used_once)', 'b', 'c(is_not_const)'), ('umax', 'b', 'd')) => ('umax', 'b', ('bcsel', 'a', 'c', 'd'))
 *    ('bcsel', 'a', ('umax', 'b', 'c(is_not_const)'), ('umax(is_used_once)', 'b', 'd')) => ('umax', 'b', ('bcsel', 'a', 'c', 'd'))
 *    ('bcsel', 'a', ('umax', 'b', 'c'), ('umax(is_used_once)', 'b', 'd(is_not_const)')) => ('umax', 'b', ('bcsel', 'a', 'c', 'd'))
 *    ('bcsel', 'a', ('fpow(is_used_once)', 'b', 'c'), ('fpow', 'b', 'd')) => ('fpow', 'b', ('bcsel', 'a', 'c', 'd'))
 *    ('bcsel', 'a', ('fpow', 'b', 'c'), ('fpow(is_used_once)', 'b', 'd')) => ('fpow', 'b', ('bcsel', 'a', 'c', 'd'))
 *    ('bcsel', 'a', ('fpow(is_used_once)', 'b', 'c'), ('fpow', 'd', 'c')) => ('fpow', ('bcsel', 'a', 'b', 'd'), 'c')
 *    ('bcsel', 'a', ('fpow', 'b', 'c'), ('fpow(is_used_once)', 'd', 'c')) => ('fpow', ('bcsel', 'a', 'b', 'd'), 'c')
 *    ('bcsel', 'c', ('frcp(is_used_once)', 'a'), ('frcp(is_used_once)', 'b')) => ('frcp', ('bcsel', 'c', 'a', 'b'))
 *    ('bcsel', 'c', ('frsq(is_used_once)', 'a'), ('frsq(is_used_once)', 'b')) => ('frsq', ('bcsel', 'c', 'a', 'b'))
 *    ('bcsel', 'c', ('fsqrt(is_used_once)', 'a'), ('fsqrt(is_used_once)', 'b')) => ('fsqrt', ('bcsel', 'c', 'a', 'b'))
 *    ('bcsel', 'c', ('fexp2(is_used_once)', 'a'), ('fexp2(is_used_once)', 'b')) => ('fexp2', ('bcsel', 'c', 'a', 'b'))
 *    ('bcsel', 'c', ('flog2(is_used_once)', 'a'), ('flog2(is_used_once)', 'b')) => ('flog2', ('bcsel', 'c', 'a', 'b'))
 *    ('bcsel', 'c', ('fsign(is_used_once)', 'a'), ('fsign(is_used_once)', 'b')) => ('fsign', ('bcsel', 'c', 'a', 'b'))
 *    ('bcsel', 'c', ('fsin(is_used_once)', 'a'), ('fsin(is_used_once)', 'b')) => ('fsin', ('bcsel', 'c', 'a', 'b'))
 *    ('bcsel', 'c', ('fcos(is_used_once)', 'a'), ('fcos(is_used_once)', 'b')) => ('fcos', ('bcsel', 'c', 'a', 'b'))
 *    ('bcsel', 'c', ('fsin_amd(is_used_once)', 'a'), ('fsin_amd(is_used_once)', 'b')) => ('fsin_amd', ('bcsel', 'c', 'a', 'b'))
 *    ('bcsel', 'c', ('fcos_amd(is_used_once)', 'a'), ('fcos_amd(is_used_once)', 'b')) => ('fcos_amd', ('bcsel', 'c', 'a', 'b'))
 *    ('bcsel', 'c', ('fsin_mdg(is_used_once)', 'a'), ('fsin_mdg(is_used_once)', 'b')) => ('fsin_mdg', ('bcsel', 'c', 'a', 'b'))
 *    ('bcsel', 'c', ('fcos_mdg(is_used_once)', 'a'), ('fcos_mdg(is_used_once)', 'b')) => ('fcos_mdg', ('bcsel', 'c', 'a', 'b'))
 *    ('bcsel', 'c', ('fsin_agx(is_used_once)', 'a'), ('fsin_agx(is_used_once)', 'b')) => ('fsin_agx', ('bcsel', 'c', 'a', 'b'))
 *    ('bcsel', 'c', ('fneg(is_used_once)', 'a'), ('fneg(is_used_once)', 'b')) => ('fneg', ('bcsel', 'c', 'a', 'b'))
 *    ('bcsel', 'c', ('fabs(is_used_once)', 'a'), ('fabs(is_used_once)', 'b')) => ('fabs', ('bcsel', 'c', 'a', 'b'))
 *    ('bcsel', 'c', ('fsign(is_used_once)', 'a'), ('fsign(is_used_once)', 'b')) => ('fsign', ('bcsel', 'c', 'a', 'b'))
 *    ('ineg', ('bcsel', 'c', '#a', '#b')) => ('bcsel', 'c', ('ineg', 'a'), ('ineg', 'b'))
 *    ('iabs', ('bcsel', 'c', '#a', '#b')) => ('bcsel', 'c', ('iabs', 'a'), ('iabs', 'b'))
 *    ('inot', ('bcsel', 'c', '#a', '#b')) => ('bcsel', 'c', ('inot', 'a'), ('inot', 'b'))
 *    ('isign', ('bcsel', 'c', '#a', '#b')) => ('bcsel', 'c', ('isign', 'a'), ('isign', 'b'))
 *    ('fisnormal', 'a@16') => ('ult', 4095, ('iadd', ('ishl', 'a', 1), 2048))
 *    ('fisnormal', 'a@32') => ('ult', 33554431, ('iadd', ('ishl', 'a', 1), 16777216))
 *    ('fisnormal', 'a@64') => ('ult', 18014398509481983, ('iadd', ('ishl', 'a', 1), 9007199254740992))
 *    ('fquantize2f16', 'a@32') => ('bcsel', ('!flt', ('!fabs', 'a'), 6.103515625e-05), ('iand', 'a', 2147483648), ('!f2f32', ('!f2f16_rtne', 'a')))
 *    ('bfi', 4294967295, 'a', '#b') => ('iadd', ('ishl', 'a', 0), ('iand', 'b', -4294967296))
 *    ('bfi', 8589934590, 'a', '#b') => ('iadd', ('ishl', 'a', 1), ('iand', 'b', -8589934591))
 *    ('bfi', 17179869180, 'a', '#b') => ('iadd', ('ishl', 'a', 2), ('iand', 'b', -17179869181))
 *    ('bfi', 34359738360, 'a', '#b') => ('iadd', ('ishl', 'a', 3), ('iand', 'b', -34359738361))
 *    ('bfi', 68719476720, 'a', '#b') => ('iadd', ('ishl', 'a', 4), ('iand', 'b', -68719476721))
 *    ('bfi', 137438953440, 'a', '#b') => ('iadd', ('ishl', 'a', 5), ('iand', 'b', -137438953441))
 *    ('bfi', 274877906880, 'a', '#b') => ('iadd', ('ishl', 'a', 6), ('iand', 'b', -274877906881))
 *    ('bfi', 549755813760, 'a', '#b') => ('iadd', ('ishl', 'a', 7), ('iand', 'b', -549755813761))
 *    ('bfi', 1099511627520, 'a', '#b') => ('iadd', ('ishl', 'a', 8), ('iand', 'b', -1099511627521))
 *    ('bfi', 2199023255040, 'a', '#b') => ('iadd', ('ishl', 'a', 9), ('iand', 'b', -2199023255041))
 *    ('bfi', 4398046510080, 'a', '#b') => ('iadd', ('ishl', 'a', 10), ('iand', 'b', -4398046510081))
 *    ('bfi', 8796093020160, 'a', '#b') => ('iadd', ('ishl', 'a', 11), ('iand', 'b', -8796093020161))
 *    ('bfi', 17592186040320, 'a', '#b') => ('iadd', ('ishl', 'a', 12), ('iand', 'b', -17592186040321))
 *    ('bfi', 35184372080640, 'a', '#b') => ('iadd', ('ishl', 'a', 13), ('iand', 'b', -35184372080641))
 *    ('bfi', 70368744161280, 'a', '#b') => ('iadd', ('ishl', 'a', 14), ('iand', 'b', -70368744161281))
 *    ('bfi', 140737488322560, 'a', '#b') => ('iadd', ('ishl', 'a', 15), ('iand', 'b', -140737488322561))
 *    ('bfi', 281474976645120, 'a', '#b') => ('iadd', ('ishl', 'a', 16), ('iand', 'b', -281474976645121))
 *    ('bfi', 562949953290240, 'a', '#b') => ('iadd', ('ishl', 'a', 17), ('iand', 'b', -562949953290241))
 *    ('bfi', 1125899906580480, 'a', '#b') => ('iadd', ('ishl', 'a', 18), ('iand', 'b', -1125899906580481))
 *    ('bfi', 2251799813160960, 'a', '#b') => ('iadd', ('ishl', 'a', 19), ('iand', 'b', -2251799813160961))
 *    ('bfi', 4503599626321920, 'a', '#b') => ('iadd', ('ishl', 'a', 20), ('iand', 'b', -4503599626321921))
 *    ('bfi', 9007199252643840, 'a', '#b') => ('iadd', ('ishl', 'a', 21), ('iand', 'b', -9007199252643841))
 *    ('bfi', 18014398505287680, 'a', '#b') => ('iadd', ('ishl', 'a', 22), ('iand', 'b', -18014398505287681))
 *    ('bfi', 36028797010575360, 'a', '#b') => ('iadd', ('ishl', 'a', 23), ('iand', 'b', -36028797010575361))
 *    ('bfi', 72057594021150720, 'a', '#b') => ('iadd', ('ishl', 'a', 24), ('iand', 'b', -72057594021150721))
 *    ('bfi', 144115188042301440, 'a', '#b') => ('iadd', ('ishl', 'a', 25), ('iand', 'b', -144115188042301441))
 *    ('bfi', 288230376084602880, 'a', '#b') => ('iadd', ('ishl', 'a', 26), ('iand', 'b', -288230376084602881))
 *    ('bfi', 576460752169205760, 'a', '#b') => ('iadd', ('ishl', 'a', 27), ('iand', 'b', -576460752169205761))
 *    ('bfi', 1152921504338411520, 'a', '#b') => ('iadd', ('ishl', 'a', 28), ('iand', 'b', -1152921504338411521))
 *    ('bfi', 2305843008676823040, 'a', '#b') => ('iadd', ('ishl', 'a', 29), ('iand', 'b', -2305843008676823041))
 *    ('bfi', 4611686017353646080, 'a', '#b') => ('iadd', ('ishl', 'a', 30), ('iand', 'b', -4611686017353646081))
 *    ('fadd', '#a(is_nan)', 'b') => nan
 *    ('fadd', 'a', '#b(is_nan)') => nan
 *    ('fdiv', '#a(is_nan)', 'b') => nan
 *    ('fdiv', 'a', '#b(is_nan)') => nan
 *    ('fmod', '#a(is_nan)', 'b') => nan
 *    ('fmod', 'a', '#b(is_nan)') => nan
 *    ('fmul', '#a(is_nan)', 'b') => nan
 *    ('fmul', 'a', '#b(is_nan)') => nan
 *    ('fpow', '#a(is_nan)', 'b') => nan
 *    ('fpow', 'a', '#b(is_nan)') => nan
 *    ('frem', '#a(is_nan)', 'b') => nan
 *    ('frem', 'a', '#b(is_nan)') => nan
 *    ('fsub', '#a(is_nan)', 'b') => nan
 *    ('fsub', 'a', '#b(is_nan)') => nan
 *    ('ffma', '#a(is_nan)', 'b', 'c') => nan
 *    ('ffma', 'a', '#b(is_nan)', 'c') => nan
 *    ('ffma', 'a', 'b', '#c(is_nan)') => nan
 *    ('flrp', '#a(is_nan)', 'b', 'c') => nan
 *    ('flrp', 'a', '#b(is_nan)', 'c') => nan
 *    ('flrp', 'a', 'b', '#c(is_nan)') => nan
 *    ('fmin', '#a(is_nan)', 'b') => b
 *    ('fmax', '#a(is_nan)', 'b') => b
 *    ('ldexp', '#a(is_nan)', 'b') => nan
 *    ('fdot2', '#a(is_any_comp_nan)', 'b') => nan
 *    ('fdot3', '#a(is_any_comp_nan)', 'b') => nan
 *    ('fdot4', '#a(is_any_comp_nan)', 'b') => nan
 *    ('fdot5', '#a(is_any_comp_nan)', 'b') => nan
 *    ('fdot8', '#a(is_any_comp_nan)', 'b') => nan
 *    ('fdot16', '#a(is_any_comp_nan)', 'b') => nan
 *    ('feq', '#a(is_nan)', 'b') => False
 *    ('feq', 'a', '#b(is_nan)') => False
 *    ('fge', '#a(is_nan)', 'b') => False
 *    ('fge', 'a', '#b(is_nan)') => False
 *    ('flt', '#a(is_nan)', 'b') => False
 *    ('flt', 'a', '#b(is_nan)') => False
 *    ('fneu', '#a(is_nan)', 'b') => True
 *    ('seq', '#a(is_nan)', 'b') => 0.0
 *    ('seq', 'a', '#b(is_nan)') => 0.0
 *    ('sge', '#a(is_nan)', 'b') => 0.0
 *    ('sge', 'a', '#b(is_nan)') => 0.0
 *    ('slt', '#a(is_nan)', 'b') => 0.0
 *    ('slt', 'a', '#b(is_nan)') => 0.0
 *    ('sne', '#a(is_nan)', 'b') => 1.0
 *    ('f2f16', ('vec2', 'a@32', 'b@32')) => ('vec2', ('f2f16', 'a'), ('f2f16', 'b'))
 *    ('f2fmp', ('vec2', 'a@32', 'b@32')) => ('vec2', ('f2fmp', 'a'), ('f2fmp', 'b'))
 *    ('u2u16', ('vec2', 'a@32', 'b@32')) => ('vec2', ('u2u16', 'a'), ('u2u16', 'b'))
 *    ('i2i16', ('vec2', 'a@32', 'b@32')) => ('vec2', ('i2i16', 'a'), ('i2i16', 'b'))
 *    ('i2imp', ('vec2', 'a@32', 'b@32')) => ('vec2', ('i2imp', 'a'), ('i2imp', 'b'))
 *    ('f2f16', ('vec3', 'a@32', 'b@32', 'c@32')) => ('vec3', ('f2f16', 'a'), ('f2f16', 'b'), ('f2f16', 'c'))
 *    ('f2fmp', ('vec3', 'a@32', 'b@32', 'c@32')) => ('vec3', ('f2fmp', 'a'), ('f2fmp', 'b'), ('f2fmp', 'c'))
 *    ('u2u16', ('vec3', 'a@32', 'b@32', 'c@32')) => ('vec3', ('u2u16', 'a'), ('u2u16', 'b'), ('u2u16', 'c'))
 *    ('i2i16', ('vec3', 'a@32', 'b@32', 'c@32')) => ('vec3', ('i2i16', 'a'), ('i2i16', 'b'), ('i2i16', 'c'))
 *    ('i2imp', ('vec3', 'a@32', 'b@32', 'c@32')) => ('vec3', ('i2imp', 'a'), ('i2imp', 'b'), ('i2imp', 'c'))
 *    ('f2f16', ('vec4', 'a@32', 'b@32', 'c@32', 'd@32')) => ('vec4', ('f2f16', 'a'), ('f2f16', 'b'), ('f2f16', 'c'), ('f2f16', 'd'))
 *    ('f2fmp', ('vec4', 'a@32', 'b@32', 'c@32', 'd@32')) => ('vec4', ('f2fmp', 'a'), ('f2fmp', 'b'), ('f2fmp', 'c'), ('f2fmp', 'd'))
 *    ('u2u16', ('vec4', 'a@32', 'b@32', 'c@32', 'd@32')) => ('vec4', ('u2u16', 'a'), ('u2u16', 'b'), ('u2u16', 'c'), ('u2u16', 'd'))
 *    ('i2i16', ('vec4', 'a@32', 'b@32', 'c@32', 'd@32')) => ('vec4', ('i2i16', 'a'), ('i2i16', 'b'), ('i2i16', 'c'), ('i2i16', 'd'))
 *    ('i2imp', ('vec4', 'a@32', 'b@32', 'c@32', 'd@32')) => ('vec4', ('i2imp', 'a'), ('i2imp', 'b'), ('i2imp', 'c'), ('i2imp', 'd'))
 */


static const nir_search_value_union nir_opt_algebraic_values[] = {
   /* ('fgeu', 'a', 'b') => ('inot', ('flt', 'a', 'b')) */
   { .variable = {
      { nir_search_value_variable, -2 },
      0, /* a */
      false,
      nir_type_invalid,
      -1,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .variable = {
      { nir_search_value_variable, -2 },
      1, /* b */
      false,
      nir_type_invalid,
      -1,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fgeu,
      -1, 0,
      { 0, 1 },
      -1,
   } },

   /* replace0_0_0 -> 0 in the cache */
   /* replace0_0_1 -> 1 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_flt,
      -1, 0,
      { 0, 1 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_inot,
      -1, 0,
      { 3 },
      -1,
   } },

   /* ('fltu', 'a', 'b') => ('inot', ('fge', 'a', 'b')) */
   /* search1_0 -> 0 in the cache */
   /* search1_1 -> 1 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fltu,
      -1, 0,
      { 0, 1 },
      -1,
   } },

   /* replace1_0_0 -> 0 in the cache */
   /* replace1_0_1 -> 1 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fge,
      -1, 0,
      { 0, 1 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_inot,
      -1, 0,
      { 6 },
      -1,
   } },

   /* ('fneo', 0.0, 'a') => ('flt', 0.0, ('fabs', 'a')) */
   { .constant = {
      { nir_search_value_constant, -1 },
      nir_type_float, { 0x0ull /* 0.0 */ },
   } },
   { .variable = {
      { nir_search_value_variable, -1 },
      0, /* a */
      false,
      nir_type_invalid,
      -1,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fneo,
      0, 1,
      { 8, 9 },
      -1,
   } },

   /* replace2_0 -> 8 in the cache */
   /* replace2_1_0 -> 9 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fabs,
      -1, 0,
      { 9 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_flt,
      -1, 0,
      { 8, 11 },
      -1,
   } },

   /* ('fequ', 0.0, 'a') => ('inot', ('flt', 0.0, ('fabs', 'a'))) */
   /* search3_0 -> 8 in the cache */
   /* search3_1 -> 9 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fequ,
      0, 1,
      { 8, 9 },
      -1,
   } },

   /* replace3_0_0 -> 8 in the cache */
   /* replace3_0_1_0 -> 9 in the cache */
   /* replace3_0_1 -> 11 in the cache */
   /* replace3_0 -> 12 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_inot,
      -1, 0,
      { 12 },
      -1,
   } },

   /* ('imul', 'a', '#b(is_pos_power_of_two)') => ('ishl', 'a', ('find_lsb', 'b')) */
   /* search4_0 -> 0 in the cache */
   { .variable = {
      { nir_search_value_variable, -2 },
      1, /* b */
      true,
      nir_type_invalid,
      0,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_imul,
      0, 1,
      { 0, 15 },
      -1,
   } },

   /* replace4_0 -> 0 in the cache */
   /* replace4_1_0 -> 1 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_find_lsb,
      -1, 0,
      { 1 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ishl,
      -1, 0,
      { 0, 17 },
      -1,
   } },

   /* ('imul', 'a@8', 128) => ('ishl', 'a', 7) */
   { .variable = {
      { nir_search_value_variable, 8 },
      0, /* a */
      false,
      nir_type_invalid,
      -1,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .constant = {
      { nir_search_value_constant, 8 },
      nir_type_int, { 0x80ull /* 128 */ },
   } },
   { .expression = {
      { nir_search_value_expression, 8 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_imul,
      0, 1,
      { 19, 20 },
      -1,
   } },

   /* replace5_0 -> 19 in the cache */
   { .constant = {
      { nir_search_value_constant, 32 },
      nir_type_int, { 0x7ull /* 7 */ },
   } },
   { .expression = {
      { nir_search_value_expression, 8 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ishl,
      -1, 0,
      { 19, 22 },
      -1,
   } },

   /* ('imul', 'a@16', 32768) => ('ishl', 'a', 15) */
   { .variable = {
      { nir_search_value_variable, 16 },
      0, /* a */
      false,
      nir_type_invalid,
      -1,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .constant = {
      { nir_search_value_constant, 16 },
      nir_type_int, { 0x8000ull /* 32768 */ },
   } },
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_imul,
      0, 1,
      { 24, 25 },
      -1,
   } },

   /* replace6_0 -> 24 in the cache */
   { .constant = {
      { nir_search_value_constant, 32 },
      nir_type_int, { 0xfull /* 15 */ },
   } },
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ishl,
      -1, 0,
      { 24, 27 },
      -1,
   } },

   /* ('imul', 'a@32', 2147483648) => ('ishl', 'a', 31) */
   { .variable = {
      { nir_search_value_variable, 32 },
      0, /* a */
      false,
      nir_type_invalid,
      -1,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .constant = {
      { nir_search_value_constant, 32 },
      nir_type_int, { 0x80000000ull /* 2147483648 */ },
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_imul,
      0, 1,
      { 29, 30 },
      -1,
   } },

   /* replace7_0 -> 29 in the cache */
   { .constant = {
      { nir_search_value_constant, 32 },
      nir_type_int, { 0x1full /* 31 */ },
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ishl,
      -1, 0,
      { 29, 32 },
      -1,
   } },

   /* ('imul', 'a@64', 9223372036854775808) => ('ishl', 'a', 63) */
   { .variable = {
      { nir_search_value_variable, 64 },
      0, /* a */
      false,
      nir_type_invalid,
      -1,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .constant = {
      { nir_search_value_constant, 64 },
      nir_type_int, { 0x8000000000000000ull /* 9223372036854775808 */ },
   } },
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_imul,
      0, 1,
      { 34, 35 },
      -1,
   } },

   /* replace8_0 -> 34 in the cache */
   { .constant = {
      { nir_search_value_constant, 32 },
      nir_type_int, { 0x3full /* 63 */ },
   } },
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ishl,
      -1, 0,
      { 34, 37 },
      -1,
   } },

   /* ('imul', 'a', '#b(is_neg_power_of_two)') => ('ineg', ('ishl', 'a', ('find_lsb', ('iabs', 'b')))) */
   /* search9_0 -> 0 in the cache */
   { .variable = {
      { nir_search_value_variable, -2 },
      1, /* b */
      true,
      nir_type_invalid,
      1,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_imul,
      0, 1,
      { 0, 39 },
      -1,
   } },

   /* replace9_0_0 -> 0 in the cache */
   /* replace9_0_1_0_0 -> 1 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_iabs,
      -1, 0,
      { 1 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_find_lsb,
      -1, 0,
      { 41 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ishl,
      -1, 0,
      { 0, 42 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ineg,
      -1, 0,
      { 43 },
      -1,
   } },

   /* ('ishl', 'a', '#b') => ('imul', 'a', ('ishl', 1, 'b')) */
   /* search10_0 -> 9 in the cache */
   { .variable = {
      { nir_search_value_variable, 32 },
      1, /* b */
      true,
      nir_type_invalid,
      -1,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ishl,
      -1, 0,
      { 9, 45 },
      -1,
   } },

   /* replace10_0 -> 9 in the cache */
   { .constant = {
      { nir_search_value_constant, -1 },
      nir_type_int, { 0x1ull /* 1 */ },
   } },
   { .variable = {
      { nir_search_value_variable, 32 },
      1, /* b */
      false,
      nir_type_invalid,
      -1,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ishl,
      -1, 0,
      { 47, 48 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_imul,
      0, 1,
      { 9, 49 },
      -1,
   } },

   /* ('imul@64', 'a', '#b(is_bitcount2)') => ('iadd', ('ishl', 'a', ('ufind_msb', 'b')), ('ishl', 'a', ('find_lsb', 'b'))) */
   /* search11_0 -> 34 in the cache */
   { .variable = {
      { nir_search_value_variable, 64 },
      1, /* b */
      true,
      nir_type_invalid,
      2,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_imul,
      0, 1,
      { 34, 51 },
      -1,
   } },

   /* replace11_0_0 -> 34 in the cache */
   { .variable = {
      { nir_search_value_variable, 64 },
      1, /* b */
      false,
      nir_type_invalid,
      -1,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ufind_msb,
      -1, 0,
      { 53 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ishl,
      -1, 0,
      { 34, 54 },
      -1,
   } },
   /* replace11_1_0 -> 34 in the cache */
   /* replace11_1_1_0 -> 53 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_find_lsb,
      -1, 0,
      { 53 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ishl,
      -1, 0,
      { 34, 56 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_iadd,
      0, 1,
      { 55, 57 },
      -1,
   } },

   /* ('unpack_64_2x32_split_x', ('imul_2x32_64(is_used_once)', 'a', 'b')) => ('imul', 'a', 'b') */
   /* search12_0_0 -> 29 in the cache */
   /* search12_0_1 -> 48 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_imul_2x32_64,
      0, 1,
      { 29, 48 },
      0,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_unpack_64_2x32_split_x,
      -1, 1,
      { 59 },
      -1,
   } },

   /* replace12_0 -> 29 in the cache */
   /* replace12_1 -> 48 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_imul,
      0, 1,
      { 29, 48 },
      -1,
   } },

   /* ('unpack_64_2x32_split_x', ('umul_2x32_64(is_used_once)', 'a', 'b')) => ('imul', 'a', 'b') */
   /* search13_0_0 -> 29 in the cache */
   /* search13_0_1 -> 48 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_umul_2x32_64,
      0, 1,
      { 29, 48 },
      0,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_unpack_64_2x32_split_x,
      -1, 1,
      { 62 },
      -1,
   } },

   /* replace13_0 -> 29 in the cache */
   /* replace13_1 -> 48 in the cache */
   /* replace13 -> 61 in the cache */

   /* ('imul_2x32_64', 'a', 'b') => ('pack_64_2x32_split', ('imul', 'a', 'b'), ('imul_high', 'a', 'b')) */
   /* search14_0 -> 29 in the cache */
   /* search14_1 -> 48 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_imul_2x32_64,
      0, 1,
      { 29, 48 },
      -1,
   } },

   /* replace14_0_0 -> 29 in the cache */
   /* replace14_0_1 -> 48 in the cache */
   /* replace14_0 -> 61 in the cache */
   /* replace14_1_0 -> 29 in the cache */
   /* replace14_1_1 -> 48 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_imul_high,
      1, 1,
      { 29, 48 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_pack_64_2x32_split,
      -1, 2,
      { 61, 65 },
      -1,
   } },

   /* ('umul_2x32_64', 'a', 'b') => ('pack_64_2x32_split', ('imul', 'a', 'b'), ('umul_high', 'a', 'b')) */
   /* search15_0 -> 29 in the cache */
   /* search15_1 -> 48 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_umul_2x32_64,
      0, 1,
      { 29, 48 },
      -1,
   } },

   /* replace15_0_0 -> 29 in the cache */
   /* replace15_0_1 -> 48 in the cache */
   /* replace15_0 -> 61 in the cache */
   /* replace15_1_0 -> 29 in the cache */
   /* replace15_1_1 -> 48 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_umul_high,
      1, 1,
      { 29, 48 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_pack_64_2x32_split,
      -1, 2,
      { 61, 68 },
      -1,
   } },

   /* ('udiv', 'a', 1) => a */
   /* search16_0 -> 9 in the cache */
   /* search16_1 -> 47 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_udiv,
      -1, 0,
      { 9, 47 },
      -1,
   } },

   /* replace16 -> 9 in the cache */

   /* ('idiv', 'a', 1) => a */
   /* search17_0 -> 9 in the cache */
   /* search17_1 -> 47 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_idiv,
      -1, 0,
      { 9, 47 },
      -1,
   } },

   /* replace17 -> 9 in the cache */

   /* ('umod', 'a', 1) => 0 */
   /* search18_0 -> 9 in the cache */
   /* search18_1 -> 47 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_umod,
      -1, 0,
      { 9, 47 },
      -1,
   } },

   { .constant = {
      { nir_search_value_constant, -1 },
      nir_type_int, { 0x0ull /* 0 */ },
   } },

   /* ('imod', 'a', 1) => 0 */
   /* search19_0 -> 9 in the cache */
   /* search19_1 -> 47 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_imod,
      -1, 0,
      { 9, 47 },
      -1,
   } },

   /* replace19 -> 73 in the cache */

   /* ('imod', 'a', -1) => 0 */
   /* search20_0 -> 9 in the cache */
   { .constant = {
      { nir_search_value_constant, -1 },
      nir_type_int, { 0xffffffffffffffffull /* -1 */ },
   } },
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_imod,
      -1, 0,
      { 9, 75 },
      -1,
   } },

   /* replace20 -> 73 in the cache */

   /* ('irem', 'a', 1) => 0 */
   /* search21_0 -> 9 in the cache */
   /* search21_1 -> 47 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_irem,
      -1, 0,
      { 9, 47 },
      -1,
   } },

   /* replace21 -> 73 in the cache */

   /* ('irem', 'a', -1) => 0 */
   /* search22_0 -> 9 in the cache */
   /* search22_1 -> 75 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_irem,
      -1, 0,
      { 9, 75 },
      -1,
   } },

   /* replace22 -> 73 in the cache */

   /* ('udiv', 'a', '#b(is_pos_power_of_two)') => ('ushr', 'a', ('find_lsb', 'b')) */
   /* search23_0 -> 0 in the cache */
   /* search23_1 -> 15 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_udiv,
      -1, 0,
      { 0, 15 },
      -1,
   } },

   /* replace23_0 -> 0 in the cache */
   /* replace23_1_0 -> 1 in the cache */
   /* replace23_1 -> 17 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ushr,
      -1, 0,
      { 0, 17 },
      -1,
   } },

   /* ('idiv', 'a', '#b(is_pos_power_of_two)') => ('imul', ('isign', 'a'), ('ushr', ('iabs', 'a'), ('find_lsb', 'b'))) */
   /* search24_0 -> 0 in the cache */
   /* search24_1 -> 15 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_idiv,
      -1, 0,
      { 0, 15 },
      -1,
   } },

   /* replace24_0_0 -> 0 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_isign,
      -1, 0,
      { 0 },
      -1,
   } },
   /* replace24_1_0_0 -> 0 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_iabs,
      -1, 0,
      { 0 },
      -1,
   } },
   /* replace24_1_1_0 -> 1 in the cache */
   /* replace24_1_1 -> 17 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ushr,
      -1, 0,
      { 83, 17 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_imul,
      0, 1,
      { 82, 84 },
      -1,
   } },

   /* ('idiv', 'a', '#b(is_neg_power_of_two)') => ('ineg', ('imul', ('isign', 'a'), ('ushr', ('iabs', 'a'), ('find_lsb', ('iabs', 'b'))))) */
   /* search25_0 -> 0 in the cache */
   /* search25_1 -> 39 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_idiv,
      -1, 0,
      { 0, 39 },
      -1,
   } },

   /* replace25_0_0_0 -> 0 in the cache */
   /* replace25_0_0 -> 82 in the cache */
   /* replace25_0_1_0_0 -> 0 in the cache */
   /* replace25_0_1_0 -> 83 in the cache */
   /* replace25_0_1_1_0_0 -> 1 in the cache */
   /* replace25_0_1_1_0 -> 41 in the cache */
   /* replace25_0_1_1 -> 42 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ushr,
      -1, 0,
      { 83, 42 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_imul,
      0, 1,
      { 82, 87 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ineg,
      -1, 1,
      { 88 },
      -1,
   } },

   /* ('umod', 'a', '#b(is_pos_power_of_two)') => ('iand', 'a', ('isub', 'b', 1)) */
   /* search26_0 -> 0 in the cache */
   /* search26_1 -> 15 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_umod,
      -1, 0,
      { 0, 15 },
      -1,
   } },

   /* replace26_0 -> 0 in the cache */
   /* replace26_1_0 -> 1 in the cache */
   { .constant = {
      { nir_search_value_constant, -2 },
      nir_type_int, { 0x1ull /* 1 */ },
   } },
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_isub,
      -1, 0,
      { 1, 91 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_iand,
      0, 1,
      { 0, 92 },
      -1,
   } },

   /* ('imod', 'a', '#b(is_pos_power_of_two)') => ('iand', 'a', ('isub', 'b', 1)) */
   /* search27_0 -> 0 in the cache */
   /* search27_1 -> 15 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_imod,
      -1, 0,
      { 0, 15 },
      -1,
   } },

   /* replace27_0 -> 0 in the cache */
   /* replace27_1_0 -> 1 in the cache */
   /* replace27_1_1 -> 91 in the cache */
   /* replace27_1 -> 92 in the cache */
   /* replace27 -> 93 in the cache */

   /* ('imod', 'a', '#b(is_neg_power_of_two)') => ('bcsel', ('ieq', ('ior', 'a', 'b'), 'b'), 0, ('ior', 'a', 'b')) */
   /* search28_0 -> 0 in the cache */
   /* search28_1 -> 39 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_imod,
      -1, 0,
      { 0, 39 },
      -1,
   } },

   /* replace28_0_0_0 -> 0 in the cache */
   /* replace28_0_0_1 -> 1 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ior,
      1, 1,
      { 0, 1 },
      -1,
   } },
   /* replace28_0_1 -> 1 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ieq,
      0, 2,
      { 96, 1 },
      -1,
   } },
   { .constant = {
      { nir_search_value_constant, -2 },
      nir_type_int, { 0x0ull /* 0 */ },
   } },
   /* replace28_2_0 -> 0 in the cache */
   /* replace28_2_1 -> 1 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ior,
      2, 1,
      { 0, 1 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_bcsel,
      -1, 3,
      { 97, 98, 99 },
      -1,
   } },

   /* ('irem', 'a', '#b(is_pos_power_of_two)') => ('isub', 'a', ('iand', ('bcsel', ('ilt', 'a', 0), ('iadd', 'a', ('isub', 'b', 1)), 'a'), ('ineg', 'b'))) */
   /* search29_0 -> 0 in the cache */
   /* search29_1 -> 15 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_irem,
      -1, 0,
      { 0, 15 },
      -1,
   } },

   /* replace29_0 -> 0 in the cache */
   /* replace29_1_0_0_0 -> 0 in the cache */
   /* replace29_1_0_0_1 -> 98 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ilt,
      -1, 0,
      { 0, 98 },
      -1,
   } },
   /* replace29_1_0_1_0 -> 0 in the cache */
   /* replace29_1_0_1_1_0 -> 1 in the cache */
   /* replace29_1_0_1_1_1 -> 91 in the cache */
   /* replace29_1_0_1_1 -> 92 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_iadd,
      1, 1,
      { 0, 92 },
      -1,
   } },
   /* replace29_1_0_2 -> 0 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_bcsel,
      -1, 1,
      { 102, 103, 0 },
      -1,
   } },
   /* replace29_1_1_0 -> 1 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ineg,
      -1, 0,
      { 1 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_iand,
      0, 2,
      { 104, 105 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_isub,
      -1, 2,
      { 0, 106 },
      -1,
   } },

   /* ('irem', 'a', '#b(is_neg_power_of_two)') => ('irem', 'a', ('iabs', 'b')) */
   /* search30_0 -> 0 in the cache */
   /* search30_1 -> 39 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_irem,
      -1, 0,
      { 0, 39 },
      -1,
   } },

   /* replace30_0 -> 0 in the cache */
   /* replace30_1_0 -> 1 in the cache */
   /* replace30_1 -> 41 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_irem,
      -1, 0,
      { 0, 41 },
      -1,
   } },

   /* ('~fmul', ('fsign', 'a'), ('ffloor', ('fadd', ('fabs', 'a'), 0.5))) => ('ftrunc', ('fadd', 'a', ('fmul', ('fsign', 'a'), 0.5))) */
   /* search31_0_0 -> 9 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fsign,
      -1, 0,
      { 9 },
      -1,
   } },
   /* search31_1_0_0_0 -> 9 in the cache */
   /* search31_1_0_0 -> 11 in the cache */
   { .constant = {
      { nir_search_value_constant, -1 },
      nir_type_float, { 0x3fe0000000000000ull /* 0.5 */ },
   } },
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fadd,
      1, 1,
      { 11, 111 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ffloor,
      -1, 1,
      { 112 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -1 },
      true,
      false,
      false,
      false,
      false,
      false,
      nir_op_fmul,
      0, 2,
      { 110, 113 },
      -1,
   } },

   /* replace31_0_0 -> 9 in the cache */
   /* replace31_0_1_0_0 -> 9 in the cache */
   /* replace31_0_1_0 -> 110 in the cache */
   /* replace31_0_1_1 -> 111 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fmul,
      1, 1,
      { 110, 111 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fadd,
      0, 2,
      { 9, 115 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ftrunc,
      -1, 2,
      { 116 },
      -1,
   } },

   /* ('~fneg', ('fneg', 'a')) => a */
   /* search32_0_0 -> 9 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fneg,
      -1, 0,
      { 9 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -1 },
      true,
      false,
      false,
      false,
      false,
      false,
      nir_op_fneg,
      -1, 0,
      { 118 },
      -1,
   } },

   /* replace32 -> 9 in the cache */

   /* ('ineg', ('ineg', 'a')) => a */
   /* search33_0_0 -> 9 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ineg,
      -1, 0,
      { 9 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ineg,
      -1, 0,
      { 120 },
      -1,
   } },

   /* replace33 -> 9 in the cache */

   /* ('fabs', ('fneg', 'a')) => ('fabs', 'a') */
   /* search34_0_0 -> 9 in the cache */
   /* search34_0 -> 118 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fabs,
      -1, 0,
      { 118 },
      -1,
   } },

   /* replace34_0 -> 9 in the cache */
   /* replace34 -> 11 in the cache */

   /* ('fabs', ('u2f', 'a')) => ('u2f', 'a') */
   /* search35_0_0 -> 9 in the cache */
   { .expression = {
      { nir_search_value_expression, 0 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_search_op_u2f,
      -1, 0,
      { 9 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 0 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fabs,
      -1, 0,
      { 123 },
      -1,
   } },

   /* replace35_0 -> 9 in the cache */
   /* replace35 -> 123 in the cache */

   /* ('iabs', ('iabs', 'a')) => ('iabs', 'a') */
   /* search36_0_0 -> 9 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_iabs,
      -1, 0,
      { 9 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_iabs,
      -1, 0,
      { 125 },
      -1,
   } },

   /* replace36_0 -> 9 in the cache */
   /* replace36 -> 125 in the cache */

   /* ('iabs', ('ineg', 'a')) => ('iabs', 'a') */
   /* search37_0_0 -> 9 in the cache */
   /* search37_0 -> 120 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_iabs,
      -1, 0,
      { 120 },
      -1,
   } },

   /* replace37_0 -> 9 in the cache */
   /* replace37 -> 125 in the cache */

   /* ('~fadd', 'a', 0.0) => a */
   /* search38_0 -> 9 in the cache */
   /* search38_1 -> 8 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      true,
      false,
      false,
      false,
      false,
      false,
      nir_op_fadd,
      0, 1,
      { 9, 8 },
      -1,
   } },

   /* replace38 -> 9 in the cache */

   /* ('fadd(is_only_used_as_float,nsz)', 'a', 0.0) => a */
   /* search39_0 -> 9 in the cache */
   /* search39_1 -> 8 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      true,
      false,
      false,
      nir_op_fadd,
      0, 1,
      { 9, 8 },
      1,
   } },

   /* replace39 -> 9 in the cache */

   /* ('fadd(is_only_used_as_float)', 'a', '#b(is_negative_zero)') => a */
   /* search40_0 -> 0 in the cache */
   { .variable = {
      { nir_search_value_variable, -2 },
      1, /* b */
      true,
      nir_type_invalid,
      3,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fadd,
      0, 1,
      { 0, 130 },
      1,
   } },

   /* replace40 -> 0 in the cache */

   /* ('fadd', ('fneg', 'a'), '#b(is_negative_zero)') => ('fneg', 'a') */
   /* search41_0_0 -> 0 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fneg,
      -1, 0,
      { 0 },
      -1,
   } },
   /* search41_1 -> 130 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fadd,
      0, 1,
      { 132, 130 },
      -1,
   } },

   /* replace41_0 -> 0 in the cache */
   /* replace41 -> 132 in the cache */

   /* ('iadd', 'a', 0) => a */
   /* search42_0 -> 9 in the cache */
   /* search42_1 -> 73 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_iadd,
      0, 1,
      { 9, 73 },
      -1,
   } },

   /* replace42 -> 9 in the cache */

   /* ('iadd_sat', 'a', 0) => a */
   /* search43_0 -> 9 in the cache */
   /* search43_1 -> 73 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_iadd_sat,
      0, 1,
      { 9, 73 },
      -1,
   } },

   /* replace43 -> 9 in the cache */

   /* ('isub_sat', 'a', 0) => a */
   /* search44_0 -> 9 in the cache */
   /* search44_1 -> 73 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_isub_sat,
      -1, 0,
      { 9, 73 },
      -1,
   } },

   /* replace44 -> 9 in the cache */

   /* ('uadd_sat', 'a', 0) => a */
   /* search45_0 -> 9 in the cache */
   /* search45_1 -> 73 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_uadd_sat,
      0, 1,
      { 9, 73 },
      -1,
   } },

   /* replace45 -> 9 in the cache */

   /* ('usub_sat', 'a', 0) => a */
   /* search46_0 -> 9 in the cache */
   /* search46_1 -> 73 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_usub_sat,
      -1, 0,
      { 9, 73 },
      -1,
   } },

   /* replace46 -> 9 in the cache */

   /* ('usadd_4x8_vc4', 'a', 0) => a */
   /* search47_0 -> 29 in the cache */
   { .constant = {
      { nir_search_value_constant, 32 },
      nir_type_int, { 0x0ull /* 0 */ },
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_usadd_4x8_vc4,
      0, 1,
      { 29, 139 },
      -1,
   } },

   /* replace47 -> 29 in the cache */

   /* ('usadd_4x8_vc4', 'a', -1) => -1 */
   /* search48_0 -> 29 in the cache */
   { .constant = {
      { nir_search_value_constant, 32 },
      nir_type_int, { 0xffffffffffffffffull /* -1 */ },
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_usadd_4x8_vc4,
      0, 1,
      { 29, 141 },
      -1,
   } },

   /* replace48 -> 141 in the cache */

   /* ('~fadd', ('fmul', 'a', 'b'), ('fmul', 'a', 'c')) => ('fmul', 'a', ('fadd', 'b', 'c')) */
   { .variable = {
      { nir_search_value_variable, -3 },
      0, /* a */
      false,
      nir_type_invalid,
      -1,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .variable = {
      { nir_search_value_variable, -3 },
      1, /* b */
      false,
      nir_type_invalid,
      -1,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fmul,
      1, 1,
      { 143, 144 },
      -1,
   } },
   /* search49_1_0 -> 143 in the cache */
   { .variable = {
      { nir_search_value_variable, -3 },
      2, /* c */
      false,
      nir_type_invalid,
      -1,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fmul,
      2, 1,
      { 143, 146 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -3 },
      true,
      false,
      false,
      false,
      false,
      false,
      nir_op_fadd,
      0, 3,
      { 145, 147 },
      -1,
   } },

   /* replace49_0 -> 143 in the cache */
   /* replace49_1_0 -> 144 in the cache */
   /* replace49_1_1 -> 146 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fadd,
      1, 1,
      { 144, 146 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fmul,
      0, 2,
      { 143, 149 },
      -1,
   } },

   /* ('~fadd', ('fmulz', 'a', 'b'), ('fmulz', 'a', 'c')) => ('fmulz', 'a', ('fadd', 'b', 'c')) */
   /* search50_0_0 -> 29 in the cache */
   /* search50_0_1 -> 48 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fmulz,
      1, 1,
      { 29, 48 },
      -1,
   } },
   /* search50_1_0 -> 29 in the cache */
   { .variable = {
      { nir_search_value_variable, 32 },
      2, /* c */
      false,
      nir_type_invalid,
      -1,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fmulz,
      2, 1,
      { 29, 152 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      true,
      false,
      false,
      false,
      false,
      false,
      nir_op_fadd,
      0, 3,
      { 151, 153 },
      -1,
   } },

   /* replace50_0 -> 29 in the cache */
   /* replace50_1_0 -> 48 in the cache */
   /* replace50_1_1 -> 152 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fadd,
      1, 1,
      { 48, 152 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fmulz,
      0, 2,
      { 29, 155 },
      -1,
   } },

   /* ('~ffma', 'a', 'b', ('ffma(is_used_once)', 'a', 'c', 'd')) => ('ffma', 'a', ('fadd', 'b', 'c'), 'd') */
   /* search51_0 -> 0 in the cache */
   /* search51_1 -> 1 in the cache */
   /* search51_2_0 -> 0 in the cache */
   { .variable = {
      { nir_search_value_variable, -2 },
      2, /* c */
      false,
      nir_type_invalid,
      -1,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .variable = {
      { nir_search_value_variable, -2 },
      3, /* d */
      false,
      nir_type_invalid,
      -1,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ffma,
      1, 1,
      { 0, 157, 158 },
      0,
   } },
   { .expression = {
      { nir_search_value_expression, -2 },
      true,
      false,
      false,
      false,
      false,
      false,
      nir_op_ffma,
      0, 2,
      { 0, 1, 159 },
      -1,
   } },

   /* replace51_0 -> 0 in the cache */
   /* replace51_1_0 -> 1 in the cache */
   /* replace51_1_1 -> 157 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fadd,
      1, 1,
      { 1, 157 },
      -1,
   } },
   /* replace51_2 -> 158 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ffma,
      0, 2,
      { 0, 161, 158 },
      -1,
   } },

   /* ('~ffma', 'a', 'b', ('fmul(is_used_once)', 'a', 'c')) => ('fmul', 'a', ('fadd', 'b', 'c')) */
   /* search52_0 -> 0 in the cache */
   /* search52_1 -> 1 in the cache */
   /* search52_2_0 -> 0 in the cache */
   /* search52_2_1 -> 157 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fmul,
      1, 1,
      { 0, 157 },
      0,
   } },
   { .expression = {
      { nir_search_value_expression, -2 },
      true,
      false,
      false,
      false,
      false,
      false,
      nir_op_ffma,
      0, 2,
      { 0, 1, 163 },
      -1,
   } },

   /* replace52_0 -> 0 in the cache */
   /* replace52_1_0 -> 1 in the cache */
   /* replace52_1_1 -> 157 in the cache */
   /* replace52_1 -> 161 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fmul,
      0, 2,
      { 0, 161 },
      -1,
   } },

   /* ('~fadd', ('fmul(is_used_once)', 'a', 'b'), ('ffma(is_used_once)', 'a', 'c', 'd')) => ('ffma', 'a', ('fadd', 'b', 'c'), 'd') */
   { .variable = {
      { nir_search_value_variable, -4 },
      0, /* a */
      false,
      nir_type_invalid,
      -1,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .variable = {
      { nir_search_value_variable, -4 },
      1, /* b */
      false,
      nir_type_invalid,
      -1,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .expression = {
      { nir_search_value_expression, -4 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fmul,
      1, 1,
      { 166, 167 },
      0,
   } },
   /* search53_1_0 -> 166 in the cache */
   { .variable = {
      { nir_search_value_variable, -4 },
      2, /* c */
      false,
      nir_type_invalid,
      -1,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .variable = {
      { nir_search_value_variable, -4 },
      3, /* d */
      false,
      nir_type_invalid,
      -1,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .expression = {
      { nir_search_value_expression, -4 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ffma,
      2, 1,
      { 166, 169, 170 },
      0,
   } },
   { .expression = {
      { nir_search_value_expression, -4 },
      true,
      false,
      false,
      false,
      false,
      false,
      nir_op_fadd,
      0, 3,
      { 168, 171 },
      -1,
   } },

   /* replace53_0 -> 166 in the cache */
   /* replace53_1_0 -> 167 in the cache */
   /* replace53_1_1 -> 169 in the cache */
   { .expression = {
      { nir_search_value_expression, -4 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fadd,
      1, 1,
      { 167, 169 },
      -1,
   } },
   /* replace53_2 -> 170 in the cache */
   { .expression = {
      { nir_search_value_expression, -4 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ffma,
      0, 2,
      { 166, 173, 170 },
      -1,
   } },

   /* ('~ffma', 'a', ('fmul(is_used_once)', 'b', 'c'), ('fmul(is_used_once)', 'b', 'd')) => ('fmul', 'b', ('ffma', 'a', 'c', 'd')) */
   /* search54_0 -> 166 in the cache */
   /* search54_1_0 -> 167 in the cache */
   /* search54_1_1 -> 169 in the cache */
   { .expression = {
      { nir_search_value_expression, -4 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fmul,
      1, 1,
      { 167, 169 },
      0,
   } },
   /* search54_2_0 -> 167 in the cache */
   /* search54_2_1 -> 170 in the cache */
   { .expression = {
      { nir_search_value_expression, -4 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fmul,
      2, 1,
      { 167, 170 },
      0,
   } },
   { .expression = {
      { nir_search_value_expression, -4 },
      true,
      false,
      false,
      false,
      false,
      false,
      nir_op_ffma,
      0, 3,
      { 166, 175, 176 },
      -1,
   } },

   /* replace54_0 -> 167 in the cache */
   /* replace54_1_0 -> 166 in the cache */
   /* replace54_1_1 -> 169 in the cache */
   /* replace54_1_2 -> 170 in the cache */
   { .expression = {
      { nir_search_value_expression, -4 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ffma,
      1, 1,
      { 166, 169, 170 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -4 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fmul,
      0, 2,
      { 167, 178 },
      -1,
   } },

   /* ('~ffmaz', 'a', 'b', ('ffmaz(is_used_once)', 'a', 'c', 'd')) => ('ffmaz', 'a', ('fadd', 'b', 'c'), 'd') */
   /* search55_0 -> 29 in the cache */
   /* search55_1 -> 48 in the cache */
   /* search55_2_0 -> 29 in the cache */
   /* search55_2_1 -> 152 in the cache */
   { .variable = {
      { nir_search_value_variable, 32 },
      3, /* d */
      false,
      nir_type_invalid,
      -1,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ffmaz,
      1, 1,
      { 29, 152, 180 },
      0,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      true,
      false,
      false,
      false,
      false,
      false,
      nir_op_ffmaz,
      0, 2,
      { 29, 48, 181 },
      -1,
   } },

   /* replace55_0 -> 29 in the cache */
   /* replace55_1_0 -> 48 in the cache */
   /* replace55_1_1 -> 152 in the cache */
   /* replace55_1 -> 155 in the cache */
   /* replace55_2 -> 180 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ffmaz,
      0, 2,
      { 29, 155, 180 },
      -1,
   } },

   /* ('~ffmaz', 'a', 'b', ('fmulz(is_used_once)', 'a', 'c')) => ('fmulz', 'a', ('fadd', 'b', 'c')) */
   /* search56_0 -> 29 in the cache */
   /* search56_1 -> 48 in the cache */
   /* search56_2_0 -> 29 in the cache */
   /* search56_2_1 -> 152 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fmulz,
      1, 1,
      { 29, 152 },
      0,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      true,
      false,
      false,
      false,
      false,
      false,
      nir_op_ffmaz,
      0, 2,
      { 29, 48, 184 },
      -1,
   } },

   /* replace56_0 -> 29 in the cache */
   /* replace56_1_0 -> 48 in the cache */
   /* replace56_1_1 -> 152 in the cache */
   /* replace56_1 -> 155 in the cache */
   /* replace56 -> 156 in the cache */

   /* ('~fadd', ('fmulz(is_used_once)', 'a', 'b'), ('ffmaz(is_used_once)', 'a', 'c', 'd')) => ('ffmaz', 'a', ('fadd', 'b', 'c'), 'd') */
   /* search57_0_0 -> 29 in the cache */
   /* search57_0_1 -> 48 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fmulz,
      1, 1,
      { 29, 48 },
      0,
   } },
   /* search57_1_0 -> 29 in the cache */
   /* search57_1_1 -> 152 in the cache */
   /* search57_1_2 -> 180 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ffmaz,
      2, 1,
      { 29, 152, 180 },
      0,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      true,
      false,
      false,
      false,
      false,
      false,
      nir_op_fadd,
      0, 3,
      { 186, 187 },
      -1,
   } },

   /* replace57_0 -> 29 in the cache */
   /* replace57_1_0 -> 48 in the cache */
   /* replace57_1_1 -> 152 in the cache */
   /* replace57_1 -> 155 in the cache */
   /* replace57_2 -> 180 in the cache */
   /* replace57 -> 183 in the cache */

   /* ('~ffmaz', 'a', ('fmulz(is_used_once)', 'b', 'c'), ('fmulz(is_used_once)', 'b', 'd')) => ('fmulz', 'b', ('ffmaz', 'a', 'c', 'd')) */
   /* search58_0 -> 29 in the cache */
   /* search58_1_0 -> 48 in the cache */
   /* search58_1_1 -> 152 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fmulz,
      1, 1,
      { 48, 152 },
      0,
   } },
   /* search58_2_0 -> 48 in the cache */
   /* search58_2_1 -> 180 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fmulz,
      2, 1,
      { 48, 180 },
      0,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      true,
      false,
      false,
      false,
      false,
      false,
      nir_op_ffmaz,
      0, 3,
      { 29, 189, 190 },
      -1,
   } },

   /* replace58_0 -> 48 in the cache */
   /* replace58_1_0 -> 29 in the cache */
   /* replace58_1_1 -> 152 in the cache */
   /* replace58_1_2 -> 180 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ffmaz,
      1, 1,
      { 29, 152, 180 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fmulz,
      0, 2,
      { 48, 192 },
      -1,
   } },

   /* ('iadd', ('imul', 'a', 'b'), ('imul', 'a', 'c')) => ('imul', 'a', ('iadd', 'b', 'c')) */
   /* search59_0_0 -> 143 in the cache */
   /* search59_0_1 -> 144 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_imul,
      1, 1,
      { 143, 144 },
      -1,
   } },
   /* search59_1_0 -> 143 in the cache */
   /* search59_1_1 -> 146 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_imul,
      2, 1,
      { 143, 146 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_iadd,
      0, 3,
      { 194, 195 },
      -1,
   } },

   /* replace59_0 -> 143 in the cache */
   /* replace59_1_0 -> 144 in the cache */
   /* replace59_1_1 -> 146 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_iadd,
      1, 1,
      { 144, 146 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_imul,
      0, 2,
      { 143, 197 },
      -1,
   } },

   /* ('iadd', ('ishl', 'b', 'a'), ('ishl', 'c', 'a')) => ('ishl', ('iadd', 'b', 'c'), 'a') */
   { .variable = {
      { nir_search_value_variable, -3 },
      0, /* b */
      false,
      nir_type_invalid,
      -1,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .variable = {
      { nir_search_value_variable, 32 },
      1, /* a */
      false,
      nir_type_invalid,
      -1,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ishl,
      -1, 0,
      { 199, 200 },
      -1,
   } },
   /* search60_1_0 -> 146 in the cache */
   /* search60_1_1 -> 200 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ishl,
      -1, 0,
      { 146, 200 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_iadd,
      0, 1,
      { 201, 202 },
      -1,
   } },

   /* replace60_0_0 -> 199 in the cache */
   /* replace60_0_1 -> 146 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_iadd,
      0, 1,
      { 199, 146 },
      -1,
   } },
   /* replace60_1 -> 200 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ishl,
      -1, 1,
      { 204, 200 },
      -1,
   } },

   /* ('iand', ('ior', 'a', 'b'), ('ior', 'a', 'c')) => ('ior', 'a', ('iand', 'b', 'c')) */
   /* search61_0_0 -> 143 in the cache */
   /* search61_0_1 -> 144 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ior,
      1, 1,
      { 143, 144 },
      -1,
   } },
   /* search61_1_0 -> 143 in the cache */
   /* search61_1_1 -> 146 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ior,
      2, 1,
      { 143, 146 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_iand,
      0, 3,
      { 206, 207 },
      -1,
   } },

   /* replace61_0 -> 143 in the cache */
   /* replace61_1_0 -> 144 in the cache */
   /* replace61_1_1 -> 146 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_iand,
      1, 1,
      { 144, 146 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ior,
      0, 2,
      { 143, 209 },
      -1,
   } },

   /* ('ior', ('iand', 'a', 'b'), ('iand', 'a', 'c')) => ('iand', 'a', ('ior', 'b', 'c')) */
   /* search62_0_0 -> 143 in the cache */
   /* search62_0_1 -> 144 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_iand,
      1, 1,
      { 143, 144 },
      -1,
   } },
   /* search62_1_0 -> 143 in the cache */
   /* search62_1_1 -> 146 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_iand,
      2, 1,
      { 143, 146 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ior,
      0, 3,
      { 211, 212 },
      -1,
   } },

   /* replace62_0 -> 143 in the cache */
   /* replace62_1_0 -> 144 in the cache */
   /* replace62_1_1 -> 146 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ior,
      1, 1,
      { 144, 146 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_iand,
      0, 2,
      { 143, 214 },
      -1,
   } },

   /* ('ieq', ('iand', 'a', '#b(is_pos_power_of_two)'), 'b') => ('ine', ('iand', 'a', 'b'), 0) */
   /* search63_0_0 -> 0 in the cache */
   /* search63_0_1 -> 15 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_iand,
      1, 1,
      { 0, 15 },
      -1,
   } },
   /* search63_1 -> 1 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ieq,
      0, 2,
      { 216, 1 },
      -1,
   } },

   /* replace63_0_0 -> 0 in the cache */
   /* replace63_0_1 -> 1 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_iand,
      1, 1,
      { 0, 1 },
      -1,
   } },
   /* replace63_1 -> 98 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ine,
      0, 2,
      { 218, 98 },
      -1,
   } },

   /* ('ine', ('iand', 'a', '#b(is_pos_power_of_two)'), 'b') => ('ieq', ('iand', 'a', 'b'), 0) */
   /* search64_0_0 -> 0 in the cache */
   /* search64_0_1 -> 15 in the cache */
   /* search64_0 -> 216 in the cache */
   /* search64_1 -> 1 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ine,
      0, 2,
      { 216, 1 },
      -1,
   } },

   /* replace64_0_0 -> 0 in the cache */
   /* replace64_0_1 -> 1 in the cache */
   /* replace64_0 -> 218 in the cache */
   /* replace64_1 -> 98 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ieq,
      0, 2,
      { 218, 98 },
      -1,
   } },

   /* ('ieq', ('ushr(is_used_once)', 'a', '#b'), 0) => ('ult', 'a', ('ishl', 1, 'b')) */
   /* search65_0_0 -> 9 in the cache */
   /* search65_0_1 -> 45 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ushr,
      -1, 0,
      { 9, 45 },
      0,
   } },
   /* search65_1 -> 73 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ieq,
      0, 1,
      { 222, 73 },
      -1,
   } },

   /* replace65_0 -> 9 in the cache */
   /* replace65_1_0 -> 47 in the cache */
   /* replace65_1_1 -> 48 in the cache */
   /* replace65_1 -> 49 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ult,
      -1, 0,
      { 9, 49 },
      -1,
   } },

   /* ('ine', ('ushr(is_used_once)', 'a', '#b'), 0) => ('uge', 'a', ('ishl', 1, 'b')) */
   /* search66_0_0 -> 9 in the cache */
   /* search66_0_1 -> 45 in the cache */
   /* search66_0 -> 222 in the cache */
   /* search66_1 -> 73 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ine,
      0, 1,
      { 222, 73 },
      -1,
   } },

   /* replace66_0 -> 9 in the cache */
   /* replace66_1_0 -> 47 in the cache */
   /* replace66_1_1 -> 48 in the cache */
   /* replace66_1 -> 49 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_uge,
      -1, 0,
      { 9, 49 },
      -1,
   } },

   /* ('~fadd', ('fneg', 'a'), 'a') => 0.0 */
   /* search67_0_0 -> 9 in the cache */
   /* search67_0 -> 118 in the cache */
   /* search67_1 -> 9 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      true,
      false,
      false,
      false,
      false,
      false,
      nir_op_fadd,
      0, 1,
      { 118, 9 },
      -1,
   } },

   /* replace67 -> 8 in the cache */

   /* ('iadd', ('ineg', 'a'), 'a') => 0 */
   /* search68_0_0 -> 9 in the cache */
   /* search68_0 -> 120 in the cache */
   /* search68_1 -> 9 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_iadd,
      0, 1,
      { 120, 9 },
      -1,
   } },

   /* replace68 -> 73 in the cache */

   /* ('iadd', ('ineg', 'a'), ('iadd', 'a', 'b')) => b */
   /* search69_0_0 -> 0 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ineg,
      -1, 0,
      { 0 },
      -1,
   } },
   /* search69_1_0 -> 0 in the cache */
   /* search69_1_1 -> 1 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_iadd,
      1, 1,
      { 0, 1 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_iadd,
      0, 2,
      { 229, 230 },
      -1,
   } },

   /* replace69 -> 1 in the cache */

   /* ('iadd', 'a', ('iadd', ('ineg', 'a'), 'b')) => b */
   /* search70_0 -> 0 in the cache */
   /* search70_1_0_0 -> 0 in the cache */
   /* search70_1_0 -> 229 in the cache */
   /* search70_1_1 -> 1 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_iadd,
      1, 1,
      { 229, 1 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_iadd,
      0, 2,
      { 0, 232 },
      -1,
   } },

   /* replace70 -> 1 in the cache */

   /* ('~fadd', ('fneg', 'a'), ('fadd', 'a', 'b')) => b */
   /* search71_0_0 -> 0 in the cache */
   /* search71_0 -> 132 in the cache */
   /* search71_1_0 -> 0 in the cache */
   /* search71_1_1 -> 1 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fadd,
      1, 1,
      { 0, 1 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -2 },
      true,
      false,
      false,
      false,
      false,
      false,
      nir_op_fadd,
      0, 2,
      { 132, 234 },
      -1,
   } },

   /* replace71 -> 1 in the cache */

   /* ('~fadd', 'a', ('fadd', ('fneg', 'a'), 'b')) => b */
   /* search72_0 -> 0 in the cache */
   /* search72_1_0_0 -> 0 in the cache */
   /* search72_1_0 -> 132 in the cache */
   /* search72_1_1 -> 1 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fadd,
      1, 1,
      { 132, 1 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -2 },
      true,
      false,
      false,
      false,
      false,
      false,
      nir_op_fadd,
      0, 2,
      { 0, 236 },
      -1,
   } },

   /* replace72 -> 1 in the cache */

   /* ('fadd', ('fsat', 'a'), ('fsat', ('fneg', 'a'))) => ('fsat', ('fabs', 'a')) */
   /* search73_0_0 -> 9 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fsat,
      -1, 0,
      { 9 },
      -1,
   } },
   /* search73_1_0_0 -> 9 in the cache */
   /* search73_1_0 -> 118 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fsat,
      -1, 0,
      { 118 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fadd,
      0, 1,
      { 238, 239 },
      -1,
   } },

   /* replace73_0_0 -> 9 in the cache */
   /* replace73_0 -> 11 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fsat,
      -1, 0,
      { 11 },
      -1,
   } },

   /* ('~fmul', 'a', 0.0) => 0.0 */
   /* search74_0 -> 9 in the cache */
   /* search74_1 -> 8 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      true,
      false,
      false,
      false,
      false,
      false,
      nir_op_fmul,
      0, 1,
      { 9, 8 },
      -1,
   } },

   /* replace74 -> 8 in the cache */

   /* ('fmul(nsz,nnan)', 'a', 0.0) => 0.0 */
   /* search75_0 -> 9 in the cache */
   /* search75_1 -> 8 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      true,
      true,
      false,
      nir_op_fmul,
      0, 1,
      { 9, 8 },
      -1,
   } },

   /* replace75 -> 8 in the cache */

   /* ('fmulz', 'a', 0.0) => 0.0 */
   /* search76_0 -> 29 in the cache */
   { .constant = {
      { nir_search_value_constant, 32 },
      nir_type_float, { 0x0ull /* 0.0 */ },
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fmulz,
      0, 1,
      { 29, 244 },
      -1,
   } },

   /* replace76 -> 244 in the cache */

   /* ('fmulz(nsz)', 'a', 'b(is_finite_not_zero)') => ('fmul', 'a', 'b') */
   /* search77_0 -> 29 in the cache */
   { .variable = {
      { nir_search_value_variable, 32 },
      1, /* b */
      false,
      nir_type_invalid,
      4,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      true,
      false,
      false,
      nir_op_fmulz,
      0, 1,
      { 29, 246 },
      -1,
   } },

   /* replace77_0 -> 29 in the cache */
   /* replace77_1 -> 48 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fmul,
      0, 1,
      { 29, 48 },
      -1,
   } },

   /* ('fmulz', 'a(is_finite)', 'b(is_finite)') => ('fmul', 'a', 'b') */
   { .variable = {
      { nir_search_value_variable, 32 },
      0, /* a */
      false,
      nir_type_invalid,
      5,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .variable = {
      { nir_search_value_variable, 32 },
      1, /* b */
      false,
      nir_type_invalid,
      5,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fmulz,
      0, 1,
      { 249, 250 },
      -1,
   } },

   /* replace78_0 -> 29 in the cache */
   /* replace78_1 -> 48 in the cache */
   /* replace78 -> 248 in the cache */

   /* ('fmulz', 'a', 'a') => ('fmul', 'a', 'a') */
   /* search79_0 -> 29 in the cache */
   /* search79_1 -> 29 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fmulz,
      -1, 0,
      { 29, 29 },
      -1,
   } },

   /* replace79_0 -> 29 in the cache */
   /* replace79_1 -> 29 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fmul,
      -1, 0,
      { 29, 29 },
      -1,
   } },

   /* ('ffmaz(nsz)', 'a', 'b(is_finite_not_zero)', 'c') => ('ffma', 'a', 'b', 'c') */
   /* search80_0 -> 29 in the cache */
   /* search80_1 -> 246 in the cache */
   /* search80_2 -> 152 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      true,
      false,
      false,
      nir_op_ffmaz,
      0, 1,
      { 29, 246, 152 },
      -1,
   } },

   /* replace80_0 -> 29 in the cache */
   /* replace80_1 -> 48 in the cache */
   /* replace80_2 -> 152 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ffma,
      0, 1,
      { 29, 48, 152 },
      -1,
   } },

   /* ('ffmaz', 'a(is_finite)', 'b(is_finite)', 'c') => ('ffma', 'a', 'b', 'c') */
   /* search81_0 -> 249 in the cache */
   /* search81_1 -> 250 in the cache */
   /* search81_2 -> 152 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ffmaz,
      0, 1,
      { 249, 250, 152 },
      -1,
   } },

   /* replace81_0 -> 29 in the cache */
   /* replace81_1 -> 48 in the cache */
   /* replace81_2 -> 152 in the cache */
   /* replace81 -> 255 in the cache */

   /* ('ffmaz', 'a', 'a', 'b') => ('ffma', 'a', 'a', 'b') */
   /* search82_0 -> 29 in the cache */
   /* search82_1 -> 29 in the cache */
   /* search82_2 -> 48 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ffmaz,
      -1, 0,
      { 29, 29, 48 },
      -1,
   } },

   /* replace82_0 -> 29 in the cache */
   /* replace82_1 -> 29 in the cache */
   /* replace82_2 -> 48 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ffma,
      -1, 0,
      { 29, 29, 48 },
      -1,
   } },

   /* ('imul', 'a', 0) => 0 */
   /* search83_0 -> 9 in the cache */
   /* search83_1 -> 73 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_imul,
      0, 1,
      { 9, 73 },
      -1,
   } },

   /* replace83 -> 73 in the cache */

   /* ('umul_unorm_4x8_vc4', 'a', 0) => 0 */
   /* search84_0 -> 29 in the cache */
   /* search84_1 -> 139 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_umul_unorm_4x8_vc4,
      0, 1,
      { 29, 139 },
      -1,
   } },

   /* replace84 -> 139 in the cache */

   /* ('umul_unorm_4x8_vc4', 'a', -1) => a */
   /* search85_0 -> 29 in the cache */
   /* search85_1 -> 141 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_umul_unorm_4x8_vc4,
      0, 1,
      { 29, 141 },
      -1,
   } },

   /* replace85 -> 29 in the cache */

   /* ('~fmul', 'a', 1.0) => a */
   /* search86_0 -> 9 in the cache */
   { .constant = {
      { nir_search_value_constant, -1 },
      nir_type_float, { 0x3ff0000000000000ull /* 1.0 */ },
   } },
   { .expression = {
      { nir_search_value_expression, -1 },
      true,
      false,
      false,
      false,
      false,
      false,
      nir_op_fmul,
      0, 1,
      { 9, 262 },
      -1,
   } },

   /* replace86 -> 9 in the cache */

   /* ('~fmulz', 'a', 1.0) => a */
   /* search87_0 -> 29 in the cache */
   { .constant = {
      { nir_search_value_constant, 32 },
      nir_type_float, { 0x3ff0000000000000ull /* 1.0 */ },
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      true,
      false,
      false,
      false,
      false,
      false,
      nir_op_fmulz,
      0, 1,
      { 29, 264 },
      -1,
   } },

   /* replace87 -> 29 in the cache */

   /* ('fmul(is_only_used_as_float)', 'a', 1.0) => a */
   /* search88_0 -> 9 in the cache */
   /* search88_1 -> 262 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fmul,
      0, 1,
      { 9, 262 },
      1,
   } },

   /* replace88 -> 9 in the cache */

   /* ('imul', 'a', 1) => a */
   /* search89_0 -> 9 in the cache */
   /* search89_1 -> 47 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_imul,
      0, 1,
      { 9, 47 },
      -1,
   } },

   /* replace89 -> 9 in the cache */

   /* ('fmul', 'a', -1.0) => ('fneg', 'a') */
   /* search90_0 -> 9 in the cache */
   { .constant = {
      { nir_search_value_constant, -1 },
      nir_type_float, { 0xbff0000000000000ull /* -1.0 */ },
   } },
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fmul,
      0, 1,
      { 9, 268 },
      -1,
   } },

   /* replace90_0 -> 9 in the cache */
   /* replace90 -> 118 in the cache */

   /* ('imul', 'a', -1) => ('ineg', 'a') */
   /* search91_0 -> 9 in the cache */
   /* search91_1 -> 75 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_imul,
      0, 1,
      { 9, 75 },
      -1,
   } },

   /* replace91_0 -> 9 in the cache */
   /* replace91 -> 120 in the cache */

   /* ('fmul', ('fsign', 'a'), ('fmul', 'a', 'a')) => ('fmul', ('fabs', 'a'), 'a') */
   /* search92_0_0 -> 9 in the cache */
   /* search92_0 -> 110 in the cache */
   /* search92_1_0 -> 9 in the cache */
   /* search92_1_1 -> 9 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fmul,
      -1, 0,
      { 9, 9 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fmul,
      0, 1,
      { 110, 271 },
      -1,
   } },

   /* replace92_0_0 -> 9 in the cache */
   /* replace92_0 -> 11 in the cache */
   /* replace92_1 -> 9 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fmul,
      0, 1,
      { 11, 9 },
      -1,
   } },

   /* ('fmul', ('fmul', ('fsign', 'a'), 'a'), 'a') => ('fmul', ('fabs', 'a'), 'a') */
   /* search93_0_0_0 -> 9 in the cache */
   /* search93_0_0 -> 110 in the cache */
   /* search93_0_1 -> 9 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fmul,
      1, 1,
      { 110, 9 },
      -1,
   } },
   /* search93_1 -> 9 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fmul,
      0, 2,
      { 274, 9 },
      -1,
   } },

   /* replace93_0_0 -> 9 in the cache */
   /* replace93_0 -> 11 in the cache */
   /* replace93_1 -> 9 in the cache */
   /* replace93 -> 273 in the cache */

   /* ('~ffma', 0.0, 'a', 'b') => b */
   { .constant = {
      { nir_search_value_constant, -2 },
      nir_type_float, { 0x0ull /* 0.0 */ },
   } },
   /* search94_1 -> 0 in the cache */
   /* search94_2 -> 1 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      true,
      false,
      false,
      false,
      false,
      false,
      nir_op_ffma,
      0, 1,
      { 276, 0, 1 },
      -1,
   } },

   /* replace94 -> 1 in the cache */

   /* ('ffma(is_only_used_as_float,nsz,nnan,ninf)', 0.0, 'a', 'b') => b */
   /* search95_0 -> 276 in the cache */
   /* search95_1 -> 0 in the cache */
   /* search95_2 -> 1 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      true,
      true,
      true,
      nir_op_ffma,
      0, 1,
      { 276, 0, 1 },
      1,
   } },

   /* replace95 -> 1 in the cache */

   /* ('ffmaz', 0.0, 'a', 'b') => ('fadd', 0.0, 'b') */
   /* search96_0 -> 244 in the cache */
   /* search96_1 -> 29 in the cache */
   /* search96_2 -> 48 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ffmaz,
      0, 1,
      { 244, 29, 48 },
      -1,
   } },

   /* replace96_0 -> 244 in the cache */
   /* replace96_1 -> 48 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fadd,
      0, 1,
      { 244, 48 },
      -1,
   } },

   /* ('~ffma', 'a', 'b', 0.0) => ('fmul', 'a', 'b') */
   /* search97_0 -> 0 in the cache */
   /* search97_1 -> 1 in the cache */
   /* search97_2 -> 276 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      true,
      false,
      false,
      false,
      false,
      false,
      nir_op_ffma,
      0, 1,
      { 0, 1, 276 },
      -1,
   } },

   /* replace97_0 -> 0 in the cache */
   /* replace97_1 -> 1 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fmul,
      0, 1,
      { 0, 1 },
      -1,
   } },

   /* ('ffma(nsz)', 'a', 'b', 0.0) => ('fmul', 'a', 'b') */
   /* search98_0 -> 0 in the cache */
   /* search98_1 -> 1 in the cache */
   /* search98_2 -> 276 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      true,
      false,
      false,
      nir_op_ffma,
      0, 1,
      { 0, 1, 276 },
      -1,
   } },

   /* replace98_0 -> 0 in the cache */
   /* replace98_1 -> 1 in the cache */
   /* replace98 -> 282 in the cache */

   /* ('ffmaz(nsz)', 'a', 'b', 0.0) => ('fmulz', 'a', 'b') */
   /* search99_0 -> 29 in the cache */
   /* search99_1 -> 48 in the cache */
   /* search99_2 -> 244 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      true,
      false,
      false,
      nir_op_ffmaz,
      0, 1,
      { 29, 48, 244 },
      -1,
   } },

   /* replace99_0 -> 29 in the cache */
   /* replace99_1 -> 48 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fmulz,
      0, 1,
      { 29, 48 },
      -1,
   } },

   /* ('ffma', 1.0, 'a', 'b') => ('fadd', 'a', 'b') */
   { .constant = {
      { nir_search_value_constant, -2 },
      nir_type_float, { 0x3ff0000000000000ull /* 1.0 */ },
   } },
   /* search100_1 -> 0 in the cache */
   /* search100_2 -> 1 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ffma,
      0, 1,
      { 286, 0, 1 },
      -1,
   } },

   /* replace100_0 -> 0 in the cache */
   /* replace100_1 -> 1 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fadd,
      0, 1,
      { 0, 1 },
      -1,
   } },

   /* ('ffmaz(nsz)', 1.0, 'a', 'b') => ('fadd', 'a', 'b') */
   /* search101_0 -> 264 in the cache */
   /* search101_1 -> 29 in the cache */
   /* search101_2 -> 48 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      true,
      false,
      false,
      nir_op_ffmaz,
      0, 1,
      { 264, 29, 48 },
      -1,
   } },

   /* replace101_0 -> 29 in the cache */
   /* replace101_1 -> 48 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fadd,
      0, 1,
      { 29, 48 },
      -1,
   } },

   /* ('ffma', -1.0, 'a', 'b') => ('fadd', ('fneg', 'a'), 'b') */
   { .constant = {
      { nir_search_value_constant, -2 },
      nir_type_float, { 0xbff0000000000000ull /* -1.0 */ },
   } },
   /* search102_1 -> 0 in the cache */
   /* search102_2 -> 1 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ffma,
      0, 1,
      { 291, 0, 1 },
      -1,
   } },

   /* replace102_0_0 -> 0 in the cache */
   /* replace102_0 -> 132 in the cache */
   /* replace102_1 -> 1 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fadd,
      0, 1,
      { 132, 1 },
      -1,
   } },

   /* ('ffmaz(nsz)', -1.0, 'a', 'b') => ('fadd', ('fneg', 'a'), 'b') */
   { .constant = {
      { nir_search_value_constant, 32 },
      nir_type_float, { 0xbff0000000000000ull /* -1.0 */ },
   } },
   /* search103_1 -> 29 in the cache */
   /* search103_2 -> 48 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      true,
      false,
      false,
      nir_op_ffmaz,
      0, 1,
      { 294, 29, 48 },
      -1,
   } },

   /* replace103_0_0 -> 29 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fneg,
      -1, 0,
      { 29 },
      -1,
   } },
   /* replace103_1 -> 48 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fadd,
      0, 1,
      { 296, 48 },
      -1,
   } },

   /* ('~ffma', '#a', '#b', 'c') => ('fadd', ('fmul', 'a', 'b'), 'c') */
   { .variable = {
      { nir_search_value_variable, -3 },
      0, /* a */
      true,
      nir_type_invalid,
      -1,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .variable = {
      { nir_search_value_variable, -3 },
      1, /* b */
      true,
      nir_type_invalid,
      -1,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   /* search104_2 -> 146 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      true,
      false,
      false,
      false,
      false,
      false,
      nir_op_ffma,
      0, 1,
      { 298, 299, 146 },
      -1,
   } },

   /* replace104_0_0 -> 143 in the cache */
   /* replace104_0_1 -> 144 in the cache */
   /* replace104_0 -> 145 in the cache */
   /* replace104_1 -> 146 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fadd,
      0, 2,
      { 145, 146 },
      -1,
   } },

   /* ('~ffmaz', '#a', '#b', 'c') => ('fadd', ('fmulz', 'a', 'b'), 'c') */
   { .variable = {
      { nir_search_value_variable, 32 },
      0, /* a */
      true,
      nir_type_invalid,
      -1,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   /* search105_1 -> 45 in the cache */
   /* search105_2 -> 152 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      true,
      false,
      false,
      false,
      false,
      false,
      nir_op_ffmaz,
      0, 1,
      { 302, 45, 152 },
      -1,
   } },

   /* replace105_0_0 -> 29 in the cache */
   /* replace105_0_1 -> 48 in the cache */
   /* replace105_0 -> 151 in the cache */
   /* replace105_1 -> 152 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fadd,
      0, 2,
      { 151, 152 },
      -1,
   } },

   /* ('~flrp', 'a', 'b', 0.0) => a */
   /* search106_0 -> 0 in the cache */
   /* search106_1 -> 1 in the cache */
   /* search106_2 -> 276 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      true,
      false,
      false,
      false,
      false,
      false,
      nir_op_flrp,
      -1, 0,
      { 0, 1, 276 },
      -1,
   } },

   /* replace106 -> 0 in the cache */

   /* ('~flrp', 'a', 'b', 1.0) => b */
   /* search107_0 -> 0 in the cache */
   /* search107_1 -> 1 in the cache */
   /* search107_2 -> 286 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      true,
      false,
      false,
      false,
      false,
      false,
      nir_op_flrp,
      -1, 0,
      { 0, 1, 286 },
      -1,
   } },

   /* replace107 -> 1 in the cache */

   /* ('~flrp', 'a', 'a', 'b') => a */
   /* search108_0 -> 0 in the cache */
   /* search108_1 -> 0 in the cache */
   /* search108_2 -> 1 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      true,
      false,
      false,
      false,
      false,
      false,
      nir_op_flrp,
      -1, 0,
      { 0, 0, 1 },
      -1,
   } },

   /* replace108 -> 0 in the cache */

   /* ('~flrp', 0.0, 'a', 'b') => ('fmul', 'a', 'b') */
   /* search109_0 -> 276 in the cache */
   /* search109_1 -> 0 in the cache */
   /* search109_2 -> 1 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      true,
      false,
      false,
      false,
      false,
      false,
      nir_op_flrp,
      -1, 0,
      { 276, 0, 1 },
      -1,
   } },

   /* replace109_0 -> 0 in the cache */
   /* replace109_1 -> 1 in the cache */
   /* replace109 -> 282 in the cache */

   /* ('~flrp', 'a', ('fadd(is_used_once)', 'a', 'b'), 'c') => ('fadd', ('fmul', 'b', 'c'), 'a') */
   /* search110_0 -> 143 in the cache */
   /* search110_1_0 -> 143 in the cache */
   /* search110_1_1 -> 144 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fadd,
      0, 1,
      { 143, 144 },
      0,
   } },
   /* search110_2 -> 146 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      true,
      false,
      false,
      false,
      false,
      false,
      nir_op_flrp,
      -1, 1,
      { 143, 309, 146 },
      -1,
   } },

   /* replace110_0_0 -> 144 in the cache */
   /* replace110_0_1 -> 146 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fmul,
      1, 1,
      { 144, 146 },
      -1,
   } },
   /* replace110_1 -> 143 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fadd,
      0, 2,
      { 311, 143 },
      -1,
   } },

   /* ('sdot_4x8_iadd', 'a', 0, 'b') => b */
   /* search111_0 -> 29 in the cache */
   /* search111_1 -> 139 in the cache */
   /* search111_2 -> 48 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_sdot_4x8_iadd,
      0, 1,
      { 29, 139, 48 },
      -1,
   } },

   /* replace111 -> 48 in the cache */

   /* ('udot_4x8_uadd', 'a', 0, 'b') => b */
   /* search112_0 -> 29 in the cache */
   /* search112_1 -> 139 in the cache */
   /* search112_2 -> 48 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_udot_4x8_uadd,
      0, 1,
      { 29, 139, 48 },
      -1,
   } },

   /* replace112 -> 48 in the cache */

   /* ('sdot_4x8_iadd_sat', 'a', 0, 'b') => b */
   /* search113_0 -> 29 in the cache */
   /* search113_1 -> 139 in the cache */
   /* search113_2 -> 48 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_sdot_4x8_iadd_sat,
      0, 1,
      { 29, 139, 48 },
      -1,
   } },

   /* replace113 -> 48 in the cache */

   /* ('udot_4x8_uadd_sat', 'a', 0, 'b') => b */
   /* search114_0 -> 29 in the cache */
   /* search114_1 -> 139 in the cache */
   /* search114_2 -> 48 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_udot_4x8_uadd_sat,
      0, 1,
      { 29, 139, 48 },
      -1,
   } },

   /* replace114 -> 48 in the cache */

   /* ('sdot_2x16_iadd', 'a', 0, 'b') => b */
   /* search115_0 -> 29 in the cache */
   /* search115_1 -> 139 in the cache */
   /* search115_2 -> 48 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_sdot_2x16_iadd,
      0, 1,
      { 29, 139, 48 },
      -1,
   } },

   /* replace115 -> 48 in the cache */

   /* ('udot_2x16_uadd', 'a', 0, 'b') => b */
   /* search116_0 -> 29 in the cache */
   /* search116_1 -> 139 in the cache */
   /* search116_2 -> 48 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_udot_2x16_uadd,
      0, 1,
      { 29, 139, 48 },
      -1,
   } },

   /* replace116 -> 48 in the cache */

   /* ('sdot_2x16_iadd_sat', 'a', 0, 'b') => b */
   /* search117_0 -> 29 in the cache */
   /* search117_1 -> 139 in the cache */
   /* search117_2 -> 48 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_sdot_2x16_iadd_sat,
      0, 1,
      { 29, 139, 48 },
      -1,
   } },

   /* replace117 -> 48 in the cache */

   /* ('udot_2x16_uadd_sat', 'a', 0, 'b') => b */
   /* search118_0 -> 29 in the cache */
   /* search118_1 -> 139 in the cache */
   /* search118_2 -> 48 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_udot_2x16_uadd_sat,
      0, 1,
      { 29, 139, 48 },
      -1,
   } },

   /* replace118 -> 48 in the cache */

   /* ('sudot_4x8_iadd', 'a', 0, 'b') => b */
   /* search119_0 -> 29 in the cache */
   /* search119_1 -> 139 in the cache */
   /* search119_2 -> 48 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_sudot_4x8_iadd,
      -1, 0,
      { 29, 139, 48 },
      -1,
   } },

   /* replace119 -> 48 in the cache */

   /* ('sudot_4x8_iadd', 0, 'a', 'b') => b */
   /* search120_0 -> 139 in the cache */
   /* search120_1 -> 29 in the cache */
   /* search120_2 -> 48 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_sudot_4x8_iadd,
      -1, 0,
      { 139, 29, 48 },
      -1,
   } },

   /* replace120 -> 48 in the cache */

   /* ('sudot_4x8_iadd_sat', 'a', 0, 'b') => b */
   /* search121_0 -> 29 in the cache */
   /* search121_1 -> 139 in the cache */
   /* search121_2 -> 48 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_sudot_4x8_iadd_sat,
      -1, 0,
      { 29, 139, 48 },
      -1,
   } },

   /* replace121 -> 48 in the cache */

   /* ('sudot_4x8_iadd_sat', 0, 'a', 'b') => b */
   /* search122_0 -> 139 in the cache */
   /* search122_1 -> 29 in the cache */
   /* search122_2 -> 48 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_sudot_4x8_iadd_sat,
      -1, 0,
      { 139, 29, 48 },
      -1,
   } },

   /* replace122 -> 48 in the cache */

   /* ('iadd', ('sdot_4x8_iadd(is_used_once)', 'a', 'b', '#c'), '#d') => ('sdot_4x8_iadd', 'a', 'b', ('iadd', 'c', 'd')) */
   /* search123_0_0 -> 29 in the cache */
   /* search123_0_1 -> 48 in the cache */
   { .variable = {
      { nir_search_value_variable, 32 },
      2, /* c */
      true,
      nir_type_invalid,
      -1,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_sdot_4x8_iadd,
      1, 1,
      { 29, 48, 325 },
      0,
   } },
   { .variable = {
      { nir_search_value_variable, 32 },
      3, /* d */
      true,
      nir_type_invalid,
      -1,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_iadd,
      0, 2,
      { 326, 327 },
      -1,
   } },

   /* replace123_0 -> 29 in the cache */
   /* replace123_1 -> 48 in the cache */
   /* replace123_2_0 -> 152 in the cache */
   /* replace123_2_1 -> 180 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_iadd,
      1, 1,
      { 152, 180 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_sdot_4x8_iadd,
      0, 2,
      { 29, 48, 329 },
      -1,
   } },

   /* ('iadd', ('udot_4x8_uadd(is_used_once)', 'a', 'b', '#c'), '#d') => ('udot_4x8_uadd', 'a', 'b', ('iadd', 'c', 'd')) */
   /* search124_0_0 -> 29 in the cache */
   /* search124_0_1 -> 48 in the cache */
   /* search124_0_2 -> 325 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_udot_4x8_uadd,
      1, 1,
      { 29, 48, 325 },
      0,
   } },
   /* search124_1 -> 327 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_iadd,
      0, 2,
      { 331, 327 },
      -1,
   } },

   /* replace124_0 -> 29 in the cache */
   /* replace124_1 -> 48 in the cache */
   /* replace124_2_0 -> 152 in the cache */
   /* replace124_2_1 -> 180 in the cache */
   /* replace124_2 -> 329 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_udot_4x8_uadd,
      0, 2,
      { 29, 48, 329 },
      -1,
   } },

   /* ('iadd', ('sudot_4x8_iadd(is_used_once)', 'a', 'b', '#c'), '#d') => ('sudot_4x8_iadd', 'a', 'b', ('iadd', 'c', 'd')) */
   /* search125_0_0 -> 29 in the cache */
   /* search125_0_1 -> 48 in the cache */
   /* search125_0_2 -> 325 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_sudot_4x8_iadd,
      -1, 0,
      { 29, 48, 325 },
      0,
   } },
   /* search125_1 -> 327 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_iadd,
      0, 1,
      { 334, 327 },
      -1,
   } },

   /* replace125_0 -> 29 in the cache */
   /* replace125_1 -> 48 in the cache */
   /* replace125_2_0 -> 152 in the cache */
   /* replace125_2_1 -> 180 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_iadd,
      0, 1,
      { 152, 180 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_sudot_4x8_iadd,
      -1, 1,
      { 29, 48, 336 },
      -1,
   } },

   /* ('iadd', ('sdot_2x16_iadd(is_used_once)', 'a', 'b', '#c'), '#d') => ('sdot_2x16_iadd', 'a', 'b', ('iadd', 'c', 'd')) */
   /* search126_0_0 -> 29 in the cache */
   /* search126_0_1 -> 48 in the cache */
   /* search126_0_2 -> 325 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_sdot_2x16_iadd,
      1, 1,
      { 29, 48, 325 },
      0,
   } },
   /* search126_1 -> 327 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_iadd,
      0, 2,
      { 338, 327 },
      -1,
   } },

   /* replace126_0 -> 29 in the cache */
   /* replace126_1 -> 48 in the cache */
   /* replace126_2_0 -> 152 in the cache */
   /* replace126_2_1 -> 180 in the cache */
   /* replace126_2 -> 329 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_sdot_2x16_iadd,
      0, 2,
      { 29, 48, 329 },
      -1,
   } },

   /* ('iadd', ('udot_2x16_uadd(is_used_once)', 'a', 'b', '#c'), '#d') => ('udot_2x16_uadd', 'a', 'b', ('iadd', 'c', 'd')) */
   /* search127_0_0 -> 29 in the cache */
   /* search127_0_1 -> 48 in the cache */
   /* search127_0_2 -> 325 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_udot_2x16_uadd,
      1, 1,
      { 29, 48, 325 },
      0,
   } },
   /* search127_1 -> 327 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_iadd,
      0, 2,
      { 341, 327 },
      -1,
   } },

   /* replace127_0 -> 29 in the cache */
   /* replace127_1 -> 48 in the cache */
   /* replace127_2_0 -> 152 in the cache */
   /* replace127_2_1 -> 180 in the cache */
   /* replace127_2 -> 329 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_udot_2x16_uadd,
      0, 2,
      { 29, 48, 329 },
      -1,
   } },

   /* ('iadd', ('sdot_4x8_iadd', 'a(is_not_const)', 'b', 0), 'c') => ('sdot_4x8_iadd', 'a', 'b', 'c') */
   { .variable = {
      { nir_search_value_variable, 32 },
      0, /* a */
      false,
      nir_type_invalid,
      6,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   /* search128_0_1 -> 48 in the cache */
   /* search128_0_2 -> 139 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_sdot_4x8_iadd,
      1, 1,
      { 344, 48, 139 },
      -1,
   } },
   /* search128_1 -> 152 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_iadd,
      0, 2,
      { 345, 152 },
      -1,
   } },

   /* replace128_0 -> 29 in the cache */
   /* replace128_1 -> 48 in the cache */
   /* replace128_2 -> 152 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_sdot_4x8_iadd,
      0, 1,
      { 29, 48, 152 },
      -1,
   } },

   /* ('iadd', ('udot_4x8_uadd', 'a(is_not_const)', 'b', 0), 'c') => ('udot_4x8_uadd', 'a', 'b', 'c') */
   /* search129_0_0 -> 344 in the cache */
   /* search129_0_1 -> 48 in the cache */
   /* search129_0_2 -> 139 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_udot_4x8_uadd,
      1, 1,
      { 344, 48, 139 },
      -1,
   } },
   /* search129_1 -> 152 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_iadd,
      0, 2,
      { 348, 152 },
      -1,
   } },

   /* replace129_0 -> 29 in the cache */
   /* replace129_1 -> 48 in the cache */
   /* replace129_2 -> 152 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_udot_4x8_uadd,
      0, 1,
      { 29, 48, 152 },
      -1,
   } },

   /* ('iadd', ('sudot_4x8_iadd', 'a(is_not_const)', 'b', 0), 'c') => ('sudot_4x8_iadd', 'a', 'b', 'c') */
   /* search130_0_0 -> 344 in the cache */
   /* search130_0_1 -> 48 in the cache */
   /* search130_0_2 -> 139 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_sudot_4x8_iadd,
      -1, 0,
      { 344, 48, 139 },
      -1,
   } },
   /* search130_1 -> 152 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_iadd,
      0, 1,
      { 351, 152 },
      -1,
   } },

   /* replace130_0 -> 29 in the cache */
   /* replace130_1 -> 48 in the cache */
   /* replace130_2 -> 152 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_sudot_4x8_iadd,
      -1, 0,
      { 29, 48, 152 },
      -1,
   } },

   /* ('iadd', ('sudot_4x8_iadd', 'a', 'b(is_not_const)', 0), 'c') => ('sudot_4x8_iadd', 'a', 'b', 'c') */
   /* search131_0_0 -> 29 in the cache */
   { .variable = {
      { nir_search_value_variable, 32 },
      1, /* b */
      false,
      nir_type_invalid,
      6,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   /* search131_0_2 -> 139 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_sudot_4x8_iadd,
      -1, 0,
      { 29, 354, 139 },
      -1,
   } },
   /* search131_1 -> 152 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_iadd,
      0, 1,
      { 355, 152 },
      -1,
   } },

   /* replace131_0 -> 29 in the cache */
   /* replace131_1 -> 48 in the cache */
   /* replace131_2 -> 152 in the cache */
   /* replace131 -> 353 in the cache */

   /* ('iadd', ('sdot_2x16_iadd', 'a(is_not_const)', 'b', 0), 'c') => ('sdot_2x16_iadd', 'a', 'b', 'c') */
   /* search132_0_0 -> 344 in the cache */
   /* search132_0_1 -> 48 in the cache */
   /* search132_0_2 -> 139 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_sdot_2x16_iadd,
      1, 1,
      { 344, 48, 139 },
      -1,
   } },
   /* search132_1 -> 152 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_iadd,
      0, 2,
      { 357, 152 },
      -1,
   } },

   /* replace132_0 -> 29 in the cache */
   /* replace132_1 -> 48 in the cache */
   /* replace132_2 -> 152 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_sdot_2x16_iadd,
      0, 1,
      { 29, 48, 152 },
      -1,
   } },

   /* ('iadd', ('udot_2x16_uadd', 'a(is_not_const)', 'b', 0), 'c') => ('udot_2x16_uadd', 'a', 'b', 'c') */
   /* search133_0_0 -> 344 in the cache */
   /* search133_0_1 -> 48 in the cache */
   /* search133_0_2 -> 139 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_udot_2x16_uadd,
      1, 1,
      { 344, 48, 139 },
      -1,
   } },
   /* search133_1 -> 152 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_iadd,
      0, 2,
      { 360, 152 },
      -1,
   } },

   /* replace133_0 -> 29 in the cache */
   /* replace133_1 -> 48 in the cache */
   /* replace133_2 -> 152 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_udot_2x16_uadd,
      0, 1,
      { 29, 48, 152 },
      -1,
   } },

   /* ('sdot_4x8_iadd', '#a', '#b', 'c(is_not_const)') => ('iadd', ('sdot_4x8_iadd', 'a', 'b', 0), 'c') */
   /* search134_0 -> 302 in the cache */
   /* search134_1 -> 45 in the cache */
   { .variable = {
      { nir_search_value_variable, 32 },
      2, /* c */
      false,
      nir_type_invalid,
      6,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_sdot_4x8_iadd,
      0, 1,
      { 302, 45, 363 },
      -1,
   } },

   /* replace134_0_0 -> 29 in the cache */
   /* replace134_0_1 -> 48 in the cache */
   /* replace134_0_2 -> 139 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_sdot_4x8_iadd,
      1, 1,
      { 29, 48, 139 },
      -1,
   } },
   /* replace134_1 -> 152 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_iadd,
      0, 2,
      { 365, 152 },
      -1,
   } },

   /* ('udot_4x8_uadd', '#a', '#b', 'c(is_not_const)') => ('iadd', ('udot_4x8_uadd', 'a', 'b', 0), 'c') */
   /* search135_0 -> 302 in the cache */
   /* search135_1 -> 45 in the cache */
   /* search135_2 -> 363 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_udot_4x8_uadd,
      0, 1,
      { 302, 45, 363 },
      -1,
   } },

   /* replace135_0_0 -> 29 in the cache */
   /* replace135_0_1 -> 48 in the cache */
   /* replace135_0_2 -> 139 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_udot_4x8_uadd,
      1, 1,
      { 29, 48, 139 },
      -1,
   } },
   /* replace135_1 -> 152 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_iadd,
      0, 2,
      { 368, 152 },
      -1,
   } },

   /* ('sudot_4x8_iadd', '#a', '#b', 'c(is_not_const)') => ('iadd', ('sudot_4x8_iadd', 'a', 'b', 0), 'c') */
   /* search136_0 -> 302 in the cache */
   /* search136_1 -> 45 in the cache */
   /* search136_2 -> 363 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_sudot_4x8_iadd,
      -1, 0,
      { 302, 45, 363 },
      -1,
   } },

   /* replace136_0_0 -> 29 in the cache */
   /* replace136_0_1 -> 48 in the cache */
   /* replace136_0_2 -> 139 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_sudot_4x8_iadd,
      -1, 0,
      { 29, 48, 139 },
      -1,
   } },
   /* replace136_1 -> 152 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_iadd,
      0, 1,
      { 371, 152 },
      -1,
   } },

   /* ('sdot_2x16_iadd', '#a', '#b', 'c(is_not_const)') => ('iadd', ('sdot_2x16_iadd', 'a', 'b', 0), 'c') */
   /* search137_0 -> 302 in the cache */
   /* search137_1 -> 45 in the cache */
   /* search137_2 -> 363 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_sdot_2x16_iadd,
      0, 1,
      { 302, 45, 363 },
      -1,
   } },

   /* replace137_0_0 -> 29 in the cache */
   /* replace137_0_1 -> 48 in the cache */
   /* replace137_0_2 -> 139 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_sdot_2x16_iadd,
      1, 1,
      { 29, 48, 139 },
      -1,
   } },
   /* replace137_1 -> 152 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_iadd,
      0, 2,
      { 374, 152 },
      -1,
   } },

   /* ('udot_2x16_uadd', '#a', '#b', 'c(is_not_const)') => ('iadd', ('udot_2x16_uadd', 'a', 'b', 0), 'c') */
   /* search138_0 -> 302 in the cache */
   /* search138_1 -> 45 in the cache */
   /* search138_2 -> 363 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_udot_2x16_uadd,
      0, 1,
      { 302, 45, 363 },
      -1,
   } },

   /* replace138_0_0 -> 29 in the cache */
   /* replace138_0_1 -> 48 in the cache */
   /* replace138_0_2 -> 139 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_udot_2x16_uadd,
      1, 1,
      { 29, 48, 139 },
      -1,
   } },
   /* replace138_1 -> 152 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_iadd,
      0, 2,
      { 377, 152 },
      -1,
   } },

   /* ('sdot_4x8_iadd_sat', '#a', '#b', 'c(is_not_const)') => ('iadd_sat', ('sdot_4x8_iadd', 'a', 'b', 0), 'c') */
   /* search139_0 -> 302 in the cache */
   /* search139_1 -> 45 in the cache */
   /* search139_2 -> 363 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_sdot_4x8_iadd_sat,
      0, 1,
      { 302, 45, 363 },
      -1,
   } },

   /* replace139_0_0 -> 29 in the cache */
   /* replace139_0_1 -> 48 in the cache */
   /* replace139_0_2 -> 139 in the cache */
   /* replace139_0 -> 365 in the cache */
   /* replace139_1 -> 152 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_iadd_sat,
      0, 2,
      { 365, 152 },
      -1,
   } },

   /* ('udot_4x8_uadd_sat', '#a', '#b', 'c(is_not_const)') => ('uadd_sat', ('udot_4x8_uadd', 'a', 'b', 0), 'c') */
   /* search140_0 -> 302 in the cache */
   /* search140_1 -> 45 in the cache */
   /* search140_2 -> 363 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_udot_4x8_uadd_sat,
      0, 1,
      { 302, 45, 363 },
      -1,
   } },

   /* replace140_0_0 -> 29 in the cache */
   /* replace140_0_1 -> 48 in the cache */
   /* replace140_0_2 -> 139 in the cache */
   /* replace140_0 -> 368 in the cache */
   /* replace140_1 -> 152 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_uadd_sat,
      0, 2,
      { 368, 152 },
      -1,
   } },

   /* ('sudot_4x8_iadd_sat', '#a', '#b', 'c(is_not_const)') => ('iadd_sat', ('sudot_4x8_iadd', 'a', 'b', 0), 'c') */
   /* search141_0 -> 302 in the cache */
   /* search141_1 -> 45 in the cache */
   /* search141_2 -> 363 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_sudot_4x8_iadd_sat,
      -1, 0,
      { 302, 45, 363 },
      -1,
   } },

   /* replace141_0_0 -> 29 in the cache */
   /* replace141_0_1 -> 48 in the cache */
   /* replace141_0_2 -> 139 in the cache */
   /* replace141_0 -> 371 in the cache */
   /* replace141_1 -> 152 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_iadd_sat,
      0, 1,
      { 371, 152 },
      -1,
   } },

   /* ('sdot_2x16_iadd_sat', '#a', '#b', 'c(is_not_const)') => ('iadd_sat', ('sdot_2x16_iadd', 'a', 'b', 0), 'c') */
   /* search142_0 -> 302 in the cache */
   /* search142_1 -> 45 in the cache */
   /* search142_2 -> 363 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_sdot_2x16_iadd_sat,
      0, 1,
      { 302, 45, 363 },
      -1,
   } },

   /* replace142_0_0 -> 29 in the cache */
   /* replace142_0_1 -> 48 in the cache */
   /* replace142_0_2 -> 139 in the cache */
   /* replace142_0 -> 374 in the cache */
   /* replace142_1 -> 152 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_iadd_sat,
      0, 2,
      { 374, 152 },
      -1,
   } },

   /* ('udot_2x16_uadd_sat', '#a', '#b', 'c(is_not_const)') => ('uadd_sat', ('udot_2x16_uadd', 'a', 'b', 0), 'c') */
   /* search143_0 -> 302 in the cache */
   /* search143_1 -> 45 in the cache */
   /* search143_2 -> 363 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_udot_2x16_uadd_sat,
      0, 1,
      { 302, 45, 363 },
      -1,
   } },

   /* replace143_0_0 -> 29 in the cache */
   /* replace143_0_1 -> 48 in the cache */
   /* replace143_0_2 -> 139 in the cache */
   /* replace143_0 -> 377 in the cache */
   /* replace143_1 -> 152 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_uadd_sat,
      0, 2,
      { 377, 152 },
      -1,
   } },

   /* ('fmul@32(nsz)', ('bcsel', ('feq', 'b', 0.0, 'ignore_exact'), 0.0, ('fneg', ('fabs', 'a'))), ('bcsel', ('feq', 'a', 0.0, 'ignore_exact'), 0.0, ('fneg', ('fabs', 'b')))) => ('fmulz', ('fneg', ('fabs', 'a')), ('fneg', ('fabs', 'b'))) */
   { .variable = {
      { nir_search_value_variable, 32 },
      0, /* b */
      false,
      nir_type_invalid,
      -1,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   /* search144_0_0_1 -> 244 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      true,
      false,
      false,
      false,
      nir_op_feq,
      1, 1,
      { 389, 244 },
      -1,
   } },
   /* search144_0_1 -> 244 in the cache */
   /* search144_0_2_0_0 -> 200 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fabs,
      -1, 0,
      { 200 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fneg,
      -1, 0,
      { 391 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_bcsel,
      -1, 1,
      { 390, 244, 392 },
      -1,
   } },
   /* search144_1_0_0 -> 200 in the cache */
   /* search144_1_0_1 -> 244 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      true,
      false,
      false,
      false,
      nir_op_feq,
      2, 1,
      { 200, 244 },
      -1,
   } },
   /* search144_1_1 -> 244 in the cache */
   /* search144_1_2_0_0 -> 389 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fabs,
      -1, 0,
      { 389 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fneg,
      -1, 0,
      { 395 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_bcsel,
      -1, 1,
      { 394, 244, 396 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      true,
      false,
      false,
      nir_op_fmul,
      0, 3,
      { 393, 397 },
      -1,
   } },

   /* replace144_0_0_0 -> 200 in the cache */
   /* replace144_0_0 -> 391 in the cache */
   /* replace144_0 -> 392 in the cache */
   /* replace144_1_0_0 -> 389 in the cache */
   /* replace144_1_0 -> 395 in the cache */
   /* replace144_1 -> 396 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fmulz,
      0, 1,
      { 392, 396 },
      -1,
   } },

   /* ('fmul@32(nsz)', ('bcsel', ('feq', 'b', 0.0, 'ignore_exact'), 0.0, ('fneg', ('fabs', 'a'))), ('bcsel', ('feq', 'a', 0.0, 'ignore_exact'), 0.0, ('fabs', 'b'))) => ('fmulz', ('fneg', ('fabs', 'a')), ('fabs', 'b')) */
   /* search145_0_0_0 -> 389 in the cache */
   /* search145_0_0_1 -> 244 in the cache */
   /* search145_0_0 -> 390 in the cache */
   /* search145_0_1 -> 244 in the cache */
   /* search145_0_2_0_0 -> 200 in the cache */
   /* search145_0_2_0 -> 391 in the cache */
   /* search145_0_2 -> 392 in the cache */
   /* search145_0 -> 393 in the cache */
   /* search145_1_0_0 -> 200 in the cache */
   /* search145_1_0_1 -> 244 in the cache */
   /* search145_1_0 -> 394 in the cache */
   /* search145_1_1 -> 244 in the cache */
   /* search145_1_2_0 -> 389 in the cache */
   /* search145_1_2 -> 395 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_bcsel,
      -1, 1,
      { 394, 244, 395 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      true,
      false,
      false,
      nir_op_fmul,
      0, 3,
      { 393, 400 },
      -1,
   } },

   /* replace145_0_0_0 -> 200 in the cache */
   /* replace145_0_0 -> 391 in the cache */
   /* replace145_0 -> 392 in the cache */
   /* replace145_1_0 -> 389 in the cache */
   /* replace145_1 -> 395 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fmulz,
      0, 1,
      { 392, 395 },
      -1,
   } },

   /* ('fmul@32(nsz)', ('bcsel', ('feq', 'b', 0.0, 'ignore_exact'), 0.0, ('fneg', ('fabs', 'a'))), ('bcsel', ('feq', 'a', 0.0, 'ignore_exact'), 0.0, ('fneg', 'b'))) => ('fmulz', ('fneg', ('fabs', 'a')), ('fneg', 'b')) */
   /* search146_0_0_0 -> 389 in the cache */
   /* search146_0_0_1 -> 244 in the cache */
   /* search146_0_0 -> 390 in the cache */
   /* search146_0_1 -> 244 in the cache */
   /* search146_0_2_0_0 -> 200 in the cache */
   /* search146_0_2_0 -> 391 in the cache */
   /* search146_0_2 -> 392 in the cache */
   /* search146_0 -> 393 in the cache */
   /* search146_1_0_0 -> 200 in the cache */
   /* search146_1_0_1 -> 244 in the cache */
   /* search146_1_0 -> 394 in the cache */
   /* search146_1_1 -> 244 in the cache */
   /* search146_1_2_0 -> 389 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fneg,
      -1, 0,
      { 389 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_bcsel,
      -1, 1,
      { 394, 244, 403 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      true,
      false,
      false,
      nir_op_fmul,
      0, 3,
      { 393, 404 },
      -1,
   } },

   /* replace146_0_0_0 -> 200 in the cache */
   /* replace146_0_0 -> 391 in the cache */
   /* replace146_0 -> 392 in the cache */
   /* replace146_1_0 -> 389 in the cache */
   /* replace146_1 -> 403 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fmulz,
      0, 1,
      { 392, 403 },
      -1,
   } },

   /* ('fmul@32(nsz)', ('bcsel', ('feq', 'b', 0.0, 'ignore_exact'), 0.0, ('fneg', ('fabs', 'a'))), ('bcsel', ('feq', 'a', 0.0, 'ignore_exact'), 0.0, 'b')) => ('fmulz', ('fneg', ('fabs', 'a')), 'b') */
   /* search147_0_0_0 -> 389 in the cache */
   /* search147_0_0_1 -> 244 in the cache */
   /* search147_0_0 -> 390 in the cache */
   /* search147_0_1 -> 244 in the cache */
   /* search147_0_2_0_0 -> 200 in the cache */
   /* search147_0_2_0 -> 391 in the cache */
   /* search147_0_2 -> 392 in the cache */
   /* search147_0 -> 393 in the cache */
   /* search147_1_0_0 -> 200 in the cache */
   /* search147_1_0_1 -> 244 in the cache */
   /* search147_1_0 -> 394 in the cache */
   /* search147_1_1 -> 244 in the cache */
   /* search147_1_2 -> 389 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_bcsel,
      -1, 1,
      { 394, 244, 389 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      true,
      false,
      false,
      nir_op_fmul,
      0, 3,
      { 393, 407 },
      -1,
   } },

   /* replace147_0_0_0 -> 200 in the cache */
   /* replace147_0_0 -> 391 in the cache */
   /* replace147_0 -> 392 in the cache */
   /* replace147_1 -> 389 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fmulz,
      0, 1,
      { 392, 389 },
      -1,
   } },

   /* ('fmul@32(nsz)', ('bcsel', ('feq', 'b', 0.0, 'ignore_exact'), 0.0, ('fabs', 'a')), ('bcsel', ('feq', 'a', 0.0, 'ignore_exact'), 0.0, ('fabs', 'b'))) => ('fmulz', ('fabs', 'a'), ('fabs', 'b')) */
   /* search148_0_0_0 -> 389 in the cache */
   /* search148_0_0_1 -> 244 in the cache */
   /* search148_0_0 -> 390 in the cache */
   /* search148_0_1 -> 244 in the cache */
   /* search148_0_2_0 -> 200 in the cache */
   /* search148_0_2 -> 391 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_bcsel,
      -1, 1,
      { 390, 244, 391 },
      -1,
   } },
   /* search148_1_0_0 -> 200 in the cache */
   /* search148_1_0_1 -> 244 in the cache */
   /* search148_1_0 -> 394 in the cache */
   /* search148_1_1 -> 244 in the cache */
   /* search148_1_2_0 -> 389 in the cache */
   /* search148_1_2 -> 395 in the cache */
   /* search148_1 -> 400 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      true,
      false,
      false,
      nir_op_fmul,
      0, 3,
      { 410, 400 },
      -1,
   } },

   /* replace148_0_0 -> 200 in the cache */
   /* replace148_0 -> 391 in the cache */
   /* replace148_1_0 -> 389 in the cache */
   /* replace148_1 -> 395 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fmulz,
      0, 1,
      { 391, 395 },
      -1,
   } },

   /* ('fmul@32(nsz)', ('bcsel', ('feq', 'b', 0.0, 'ignore_exact'), 0.0, ('fabs', 'a')), ('bcsel', ('feq', 'a', 0.0, 'ignore_exact'), 0.0, ('fneg', 'b'))) => ('fmulz', ('fabs', 'a'), ('fneg', 'b')) */
   /* search149_0_0_0 -> 389 in the cache */
   /* search149_0_0_1 -> 244 in the cache */
   /* search149_0_0 -> 390 in the cache */
   /* search149_0_1 -> 244 in the cache */
   /* search149_0_2_0 -> 200 in the cache */
   /* search149_0_2 -> 391 in the cache */
   /* search149_0 -> 410 in the cache */
   /* search149_1_0_0 -> 200 in the cache */
   /* search149_1_0_1 -> 244 in the cache */
   /* search149_1_0 -> 394 in the cache */
   /* search149_1_1 -> 244 in the cache */
   /* search149_1_2_0 -> 389 in the cache */
   /* search149_1_2 -> 403 in the cache */
   /* search149_1 -> 404 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      true,
      false,
      false,
      nir_op_fmul,
      0, 3,
      { 410, 404 },
      -1,
   } },

   /* replace149_0_0 -> 200 in the cache */
   /* replace149_0 -> 391 in the cache */
   /* replace149_1_0 -> 389 in the cache */
   /* replace149_1 -> 403 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fmulz,
      0, 1,
      { 391, 403 },
      -1,
   } },

   /* ('fmul@32(nsz)', ('bcsel', ('feq', 'b', 0.0, 'ignore_exact'), 0.0, ('fabs', 'a')), ('bcsel', ('feq', 'a', 0.0, 'ignore_exact'), 0.0, 'b')) => ('fmulz', ('fabs', 'a'), 'b') */
   /* search150_0_0_0 -> 389 in the cache */
   /* search150_0_0_1 -> 244 in the cache */
   /* search150_0_0 -> 390 in the cache */
   /* search150_0_1 -> 244 in the cache */
   /* search150_0_2_0 -> 200 in the cache */
   /* search150_0_2 -> 391 in the cache */
   /* search150_0 -> 410 in the cache */
   /* search150_1_0_0 -> 200 in the cache */
   /* search150_1_0_1 -> 244 in the cache */
   /* search150_1_0 -> 394 in the cache */
   /* search150_1_1 -> 244 in the cache */
   /* search150_1_2 -> 389 in the cache */
   /* search150_1 -> 407 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      true,
      false,
      false,
      nir_op_fmul,
      0, 3,
      { 410, 407 },
      -1,
   } },

   /* replace150_0_0 -> 200 in the cache */
   /* replace150_0 -> 391 in the cache */
   /* replace150_1 -> 389 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fmulz,
      0, 1,
      { 391, 389 },
      -1,
   } },

   /* ('fmul@32(nsz)', ('bcsel', ('feq', 'b', 0.0, 'ignore_exact'), 0.0, ('fneg', 'a')), ('bcsel', ('feq', 'a', 0.0, 'ignore_exact'), 0.0, ('fneg', 'b'))) => ('fmulz', ('fneg', 'a'), ('fneg', 'b')) */
   /* search151_0_0_0 -> 389 in the cache */
   /* search151_0_0_1 -> 244 in the cache */
   /* search151_0_0 -> 390 in the cache */
   /* search151_0_1 -> 244 in the cache */
   /* search151_0_2_0 -> 200 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fneg,
      -1, 0,
      { 200 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_bcsel,
      -1, 1,
      { 390, 244, 417 },
      -1,
   } },
   /* search151_1_0_0 -> 200 in the cache */
   /* search151_1_0_1 -> 244 in the cache */
   /* search151_1_0 -> 394 in the cache */
   /* search151_1_1 -> 244 in the cache */
   /* search151_1_2_0 -> 389 in the cache */
   /* search151_1_2 -> 403 in the cache */
   /* search151_1 -> 404 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      true,
      false,
      false,
      nir_op_fmul,
      0, 3,
      { 418, 404 },
      -1,
   } },

   /* replace151_0_0 -> 200 in the cache */
   /* replace151_0 -> 417 in the cache */
   /* replace151_1_0 -> 389 in the cache */
   /* replace151_1 -> 403 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fmulz,
      0, 1,
      { 417, 403 },
      -1,
   } },

   /* ('fmul@32(nsz)', ('bcsel', ('feq', 'b', 0.0, 'ignore_exact'), 0.0, ('fneg', 'a')), ('bcsel', ('feq', 'a', 0.0, 'ignore_exact'), 0.0, 'b')) => ('fmulz', ('fneg', 'a'), 'b') */
   /* search152_0_0_0 -> 389 in the cache */
   /* search152_0_0_1 -> 244 in the cache */
   /* search152_0_0 -> 390 in the cache */
   /* search152_0_1 -> 244 in the cache */
   /* search152_0_2_0 -> 200 in the cache */
   /* search152_0_2 -> 417 in the cache */
   /* search152_0 -> 418 in the cache */
   /* search152_1_0_0 -> 200 in the cache */
   /* search152_1_0_1 -> 244 in the cache */
   /* search152_1_0 -> 394 in the cache */
   /* search152_1_1 -> 244 in the cache */
   /* search152_1_2 -> 389 in the cache */
   /* search152_1 -> 407 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      true,
      false,
      false,
      nir_op_fmul,
      0, 3,
      { 418, 407 },
      -1,
   } },

   /* replace152_0_0 -> 200 in the cache */
   /* replace152_0 -> 417 in the cache */
   /* replace152_1 -> 389 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fmulz,
      0, 1,
      { 417, 389 },
      -1,
   } },

   /* ('fmul@32(nsz)', ('bcsel', ('feq', 'b', 0.0, 'ignore_exact'), 0.0, 'a'), ('bcsel', ('feq', 'a', 0.0, 'ignore_exact'), 0.0, 'b')) => ('fmulz', 'a', 'b') */
   /* search153_0_0_0 -> 389 in the cache */
   /* search153_0_0_1 -> 244 in the cache */
   /* search153_0_0 -> 390 in the cache */
   /* search153_0_1 -> 244 in the cache */
   /* search153_0_2 -> 200 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_bcsel,
      -1, 1,
      { 390, 244, 200 },
      -1,
   } },
   /* search153_1_0_0 -> 200 in the cache */
   /* search153_1_0_1 -> 244 in the cache */
   /* search153_1_0 -> 394 in the cache */
   /* search153_1_1 -> 244 in the cache */
   /* search153_1_2 -> 389 in the cache */
   /* search153_1 -> 407 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      true,
      false,
      false,
      nir_op_fmul,
      0, 3,
      { 423, 407 },
      -1,
   } },

   /* replace153_0 -> 200 in the cache */
   /* replace153_1 -> 389 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fmulz,
      0, 1,
      { 200, 389 },
      -1,
   } },

   /* ('fmul@32(nsz)', ('fneg', ('fabs', 'a')), ('bcsel', ('feq', 'a', 0.0, 'ignore_exact'), 0.0, '#b(is_not_const_zero)')) => ('fmulz', ('fneg', ('fabs', 'a')), 'b') */
   /* search154_0_0_0 -> 29 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fabs,
      -1, 0,
      { 29 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fneg,
      -1, 0,
      { 426 },
      -1,
   } },
   /* search154_1_0_0 -> 29 in the cache */
   /* search154_1_0_1 -> 244 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      true,
      false,
      false,
      false,
      nir_op_feq,
      1, 1,
      { 29, 244 },
      -1,
   } },
   /* search154_1_1 -> 244 in the cache */
   { .variable = {
      { nir_search_value_variable, 32 },
      1, /* b */
      true,
      nir_type_invalid,
      7,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_bcsel,
      -1, 1,
      { 428, 244, 429 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      true,
      false,
      false,
      nir_op_fmul,
      0, 2,
      { 427, 430 },
      -1,
   } },

   /* replace154_0_0_0 -> 29 in the cache */
   /* replace154_0_0 -> 426 in the cache */
   /* replace154_0 -> 427 in the cache */
   /* replace154_1 -> 48 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fmulz,
      0, 1,
      { 427, 48 },
      -1,
   } },

   /* ('fmul@32(nsz)', ('fabs', 'a'), ('bcsel', ('feq', 'a', 0.0, 'ignore_exact'), 0.0, '#b(is_not_const_zero)')) => ('fmulz', ('fabs', 'a'), 'b') */
   /* search155_0_0 -> 29 in the cache */
   /* search155_0 -> 426 in the cache */
   /* search155_1_0_0 -> 29 in the cache */
   /* search155_1_0_1 -> 244 in the cache */
   /* search155_1_0 -> 428 in the cache */
   /* search155_1_1 -> 244 in the cache */
   /* search155_1_2 -> 429 in the cache */
   /* search155_1 -> 430 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      true,
      false,
      false,
      nir_op_fmul,
      0, 2,
      { 426, 430 },
      -1,
   } },

   /* replace155_0_0 -> 29 in the cache */
   /* replace155_0 -> 426 in the cache */
   /* replace155_1 -> 48 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fmulz,
      0, 1,
      { 426, 48 },
      -1,
   } },

   /* ('fmul@32(nsz)', ('fneg', 'a'), ('bcsel', ('feq', 'a', 0.0, 'ignore_exact'), 0.0, '#b(is_not_const_zero)')) => ('fmulz', ('fneg', 'a'), 'b') */
   /* search156_0_0 -> 29 in the cache */
   /* search156_0 -> 296 in the cache */
   /* search156_1_0_0 -> 29 in the cache */
   /* search156_1_0_1 -> 244 in the cache */
   /* search156_1_0 -> 428 in the cache */
   /* search156_1_1 -> 244 in the cache */
   /* search156_1_2 -> 429 in the cache */
   /* search156_1 -> 430 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      true,
      false,
      false,
      nir_op_fmul,
      0, 2,
      { 296, 430 },
      -1,
   } },

   /* replace156_0_0 -> 29 in the cache */
   /* replace156_0 -> 296 in the cache */
   /* replace156_1 -> 48 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fmulz,
      0, 1,
      { 296, 48 },
      -1,
   } },

   /* ('fmul@32(nsz)', 'a', ('bcsel', ('feq', 'a', 0.0, 'ignore_exact'), 0.0, '#b(is_not_const_zero)')) => ('fmulz', 'a', 'b') */
   /* search157_0 -> 29 in the cache */
   /* search157_1_0_0 -> 29 in the cache */
   /* search157_1_0_1 -> 244 in the cache */
   /* search157_1_0 -> 428 in the cache */
   /* search157_1_1 -> 244 in the cache */
   /* search157_1_2 -> 429 in the cache */
   /* search157_1 -> 430 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      true,
      false,
      false,
      nir_op_fmul,
      0, 2,
      { 29, 430 },
      -1,
   } },

   /* replace157_0 -> 29 in the cache */
   /* replace157_1 -> 48 in the cache */
   /* replace157 -> 285 in the cache */

   /* ('ffma@32(nsz)', ('bcsel', ('feq', 'b', 0.0, 'ignore_exact'), 0.0, ('fneg', ('fabs', 'a'))), ('bcsel', ('feq', 'a', 0.0, 'ignore_exact'), 0.0, ('fneg', ('fabs', 'b'))), 'c') => ('ffmaz', ('fneg', ('fabs', 'a')), ('fneg', ('fabs', 'b')), 'c') */
   /* search158_0_0_0 -> 389 in the cache */
   /* search158_0_0_1 -> 244 in the cache */
   /* search158_0_0 -> 390 in the cache */
   /* search158_0_1 -> 244 in the cache */
   /* search158_0_2_0_0 -> 200 in the cache */
   /* search158_0_2_0 -> 391 in the cache */
   /* search158_0_2 -> 392 in the cache */
   /* search158_0 -> 393 in the cache */
   /* search158_1_0_0 -> 200 in the cache */
   /* search158_1_0_1 -> 244 in the cache */
   /* search158_1_0 -> 394 in the cache */
   /* search158_1_1 -> 244 in the cache */
   /* search158_1_2_0_0 -> 389 in the cache */
   /* search158_1_2_0 -> 395 in the cache */
   /* search158_1_2 -> 396 in the cache */
   /* search158_1 -> 397 in the cache */
   /* search158_2 -> 152 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      true,
      false,
      false,
      nir_op_ffma,
      0, 3,
      { 393, 397, 152 },
      -1,
   } },

   /* replace158_0_0_0 -> 200 in the cache */
   /* replace158_0_0 -> 391 in the cache */
   /* replace158_0 -> 392 in the cache */
   /* replace158_1_0_0 -> 389 in the cache */
   /* replace158_1_0 -> 395 in the cache */
   /* replace158_1 -> 396 in the cache */
   /* replace158_2 -> 152 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ffmaz,
      0, 1,
      { 392, 396, 152 },
      -1,
   } },

   /* ('ffma@32(nsz)', ('bcsel', ('feq', 'b', 0.0, 'ignore_exact'), 0.0, ('fneg', ('fabs', 'a'))), ('bcsel', ('feq', 'a', 0.0, 'ignore_exact'), 0.0, ('fabs', 'b')), 'c') => ('ffmaz', ('fneg', ('fabs', 'a')), ('fabs', 'b'), 'c') */
   /* search159_0_0_0 -> 389 in the cache */
   /* search159_0_0_1 -> 244 in the cache */
   /* search159_0_0 -> 390 in the cache */
   /* search159_0_1 -> 244 in the cache */
   /* search159_0_2_0_0 -> 200 in the cache */
   /* search159_0_2_0 -> 391 in the cache */
   /* search159_0_2 -> 392 in the cache */
   /* search159_0 -> 393 in the cache */
   /* search159_1_0_0 -> 200 in the cache */
   /* search159_1_0_1 -> 244 in the cache */
   /* search159_1_0 -> 394 in the cache */
   /* search159_1_1 -> 244 in the cache */
   /* search159_1_2_0 -> 389 in the cache */
   /* search159_1_2 -> 395 in the cache */
   /* search159_1 -> 400 in the cache */
   /* search159_2 -> 152 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      true,
      false,
      false,
      nir_op_ffma,
      0, 3,
      { 393, 400, 152 },
      -1,
   } },

   /* replace159_0_0_0 -> 200 in the cache */
   /* replace159_0_0 -> 391 in the cache */
   /* replace159_0 -> 392 in the cache */
   /* replace159_1_0 -> 389 in the cache */
   /* replace159_1 -> 395 in the cache */
   /* replace159_2 -> 152 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ffmaz,
      0, 1,
      { 392, 395, 152 },
      -1,
   } },

   /* ('ffma@32(nsz)', ('bcsel', ('feq', 'b', 0.0, 'ignore_exact'), 0.0, ('fneg', ('fabs', 'a'))), ('bcsel', ('feq', 'a', 0.0, 'ignore_exact'), 0.0, ('fneg', 'b')), 'c') => ('ffmaz', ('fneg', ('fabs', 'a')), ('fneg', 'b'), 'c') */
   /* search160_0_0_0 -> 389 in the cache */
   /* search160_0_0_1 -> 244 in the cache */
   /* search160_0_0 -> 390 in the cache */
   /* search160_0_1 -> 244 in the cache */
   /* search160_0_2_0_0 -> 200 in the cache */
   /* search160_0_2_0 -> 391 in the cache */
   /* search160_0_2 -> 392 in the cache */
   /* search160_0 -> 393 in the cache */
   /* search160_1_0_0 -> 200 in the cache */
   /* search160_1_0_1 -> 244 in the cache */
   /* search160_1_0 -> 394 in the cache */
   /* search160_1_1 -> 244 in the cache */
   /* search160_1_2_0 -> 389 in the cache */
   /* search160_1_2 -> 403 in the cache */
   /* search160_1 -> 404 in the cache */
   /* search160_2 -> 152 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      true,
      false,
      false,
      nir_op_ffma,
      0, 3,
      { 393, 404, 152 },
      -1,
   } },

   /* replace160_0_0_0 -> 200 in the cache */
   /* replace160_0_0 -> 391 in the cache */
   /* replace160_0 -> 392 in the cache */
   /* replace160_1_0 -> 389 in the cache */
   /* replace160_1 -> 403 in the cache */
   /* replace160_2 -> 152 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ffmaz,
      0, 1,
      { 392, 403, 152 },
      -1,
   } },

   /* ('ffma@32(nsz)', ('bcsel', ('feq', 'b', 0.0, 'ignore_exact'), 0.0, ('fneg', ('fabs', 'a'))), ('bcsel', ('feq', 'a', 0.0, 'ignore_exact'), 0.0, 'b'), 'c') => ('ffmaz', ('fneg', ('fabs', 'a')), 'b', 'c') */
   /* search161_0_0_0 -> 389 in the cache */
   /* search161_0_0_1 -> 244 in the cache */
   /* search161_0_0 -> 390 in the cache */
   /* search161_0_1 -> 244 in the cache */
   /* search161_0_2_0_0 -> 200 in the cache */
   /* search161_0_2_0 -> 391 in the cache */
   /* search161_0_2 -> 392 in the cache */
   /* search161_0 -> 393 in the cache */
   /* search161_1_0_0 -> 200 in the cache */
   /* search161_1_0_1 -> 244 in the cache */
   /* search161_1_0 -> 394 in the cache */
   /* search161_1_1 -> 244 in the cache */
   /* search161_1_2 -> 389 in the cache */
   /* search161_1 -> 407 in the cache */
   /* search161_2 -> 152 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      true,
      false,
      false,
      nir_op_ffma,
      0, 3,
      { 393, 407, 152 },
      -1,
   } },

   /* replace161_0_0_0 -> 200 in the cache */
   /* replace161_0_0 -> 391 in the cache */
   /* replace161_0 -> 392 in the cache */
   /* replace161_1 -> 389 in the cache */
   /* replace161_2 -> 152 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ffmaz,
      0, 1,
      { 392, 389, 152 },
      -1,
   } },

   /* ('ffma@32(nsz)', ('bcsel', ('feq', 'b', 0.0, 'ignore_exact'), 0.0, ('fabs', 'a')), ('bcsel', ('feq', 'a', 0.0, 'ignore_exact'), 0.0, ('fabs', 'b')), 'c') => ('ffmaz', ('fabs', 'a'), ('fabs', 'b'), 'c') */
   /* search162_0_0_0 -> 389 in the cache */
   /* search162_0_0_1 -> 244 in the cache */
   /* search162_0_0 -> 390 in the cache */
   /* search162_0_1 -> 244 in the cache */
   /* search162_0_2_0 -> 200 in the cache */
   /* search162_0_2 -> 391 in the cache */
   /* search162_0 -> 410 in the cache */
   /* search162_1_0_0 -> 200 in the cache */
   /* search162_1_0_1 -> 244 in the cache */
   /* search162_1_0 -> 394 in the cache */
   /* search162_1_1 -> 244 in the cache */
   /* search162_1_2_0 -> 389 in the cache */
   /* search162_1_2 -> 395 in the cache */
   /* search162_1 -> 400 in the cache */
   /* search162_2 -> 152 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      true,
      false,
      false,
      nir_op_ffma,
      0, 3,
      { 410, 400, 152 },
      -1,
   } },

   /* replace162_0_0 -> 200 in the cache */
   /* replace162_0 -> 391 in the cache */
   /* replace162_1_0 -> 389 in the cache */
   /* replace162_1 -> 395 in the cache */
   /* replace162_2 -> 152 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ffmaz,
      0, 1,
      { 391, 395, 152 },
      -1,
   } },

   /* ('ffma@32(nsz)', ('bcsel', ('feq', 'b', 0.0, 'ignore_exact'), 0.0, ('fabs', 'a')), ('bcsel', ('feq', 'a', 0.0, 'ignore_exact'), 0.0, ('fneg', 'b')), 'c') => ('ffmaz', ('fabs', 'a'), ('fneg', 'b'), 'c') */
   /* search163_0_0_0 -> 389 in the cache */
   /* search163_0_0_1 -> 244 in the cache */
   /* search163_0_0 -> 390 in the cache */
   /* search163_0_1 -> 244 in the cache */
   /* search163_0_2_0 -> 200 in the cache */
   /* search163_0_2 -> 391 in the cache */
   /* search163_0 -> 410 in the cache */
   /* search163_1_0_0 -> 200 in the cache */
   /* search163_1_0_1 -> 244 in the cache */
   /* search163_1_0 -> 394 in the cache */
   /* search163_1_1 -> 244 in the cache */
   /* search163_1_2_0 -> 389 in the cache */
   /* search163_1_2 -> 403 in the cache */
   /* search163_1 -> 404 in the cache */
   /* search163_2 -> 152 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      true,
      false,
      false,
      nir_op_ffma,
      0, 3,
      { 410, 404, 152 },
      -1,
   } },

   /* replace163_0_0 -> 200 in the cache */
   /* replace163_0 -> 391 in the cache */
   /* replace163_1_0 -> 389 in the cache */
   /* replace163_1 -> 403 in the cache */
   /* replace163_2 -> 152 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ffmaz,
      0, 1,
      { 391, 403, 152 },
      -1,
   } },

   /* ('ffma@32(nsz)', ('bcsel', ('feq', 'b', 0.0, 'ignore_exact'), 0.0, ('fabs', 'a')), ('bcsel', ('feq', 'a', 0.0, 'ignore_exact'), 0.0, 'b'), 'c') => ('ffmaz', ('fabs', 'a'), 'b', 'c') */
   /* search164_0_0_0 -> 389 in the cache */
   /* search164_0_0_1 -> 244 in the cache */
   /* search164_0_0 -> 390 in the cache */
   /* search164_0_1 -> 244 in the cache */
   /* search164_0_2_0 -> 200 in the cache */
   /* search164_0_2 -> 391 in the cache */
   /* search164_0 -> 410 in the cache */
   /* search164_1_0_0 -> 200 in the cache */
   /* search164_1_0_1 -> 244 in the cache */
   /* search164_1_0 -> 394 in the cache */
   /* search164_1_1 -> 244 in the cache */
   /* search164_1_2 -> 389 in the cache */
   /* search164_1 -> 407 in the cache */
   /* search164_2 -> 152 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      true,
      false,
      false,
      nir_op_ffma,
      0, 3,
      { 410, 407, 152 },
      -1,
   } },

   /* replace164_0_0 -> 200 in the cache */
   /* replace164_0 -> 391 in the cache */
   /* replace164_1 -> 389 in the cache */
   /* replace164_2 -> 152 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ffmaz,
      0, 1,
      { 391, 389, 152 },
      -1,
   } },

   /* ('ffma@32(nsz)', ('bcsel', ('feq', 'b', 0.0, 'ignore_exact'), 0.0, ('fneg', 'a')), ('bcsel', ('feq', 'a', 0.0, 'ignore_exact'), 0.0, ('fneg', 'b')), 'c') => ('ffmaz', ('fneg', 'a'), ('fneg', 'b'), 'c') */
   /* search165_0_0_0 -> 389 in the cache */
   /* search165_0_0_1 -> 244 in the cache */
   /* search165_0_0 -> 390 in the cache */
   /* search165_0_1 -> 244 in the cache */
   /* search165_0_2_0 -> 200 in the cache */
   /* search165_0_2 -> 417 in the cache */
   /* search165_0 -> 418 in the cache */
   /* search165_1_0_0 -> 200 in the cache */
   /* search165_1_0_1 -> 244 in the cache */
   /* search165_1_0 -> 394 in the cache */
   /* search165_1_1 -> 244 in the cache */
   /* search165_1_2_0 -> 389 in the cache */
   /* search165_1_2 -> 403 in the cache */
   /* search165_1 -> 404 in the cache */
   /* search165_2 -> 152 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      true,
      false,
      false,
      nir_op_ffma,
      0, 3,
      { 418, 404, 152 },
      -1,
   } },

   /* replace165_0_0 -> 200 in the cache */
   /* replace165_0 -> 417 in the cache */
   /* replace165_1_0 -> 389 in the cache */
   /* replace165_1 -> 403 in the cache */
   /* replace165_2 -> 152 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ffmaz,
      0, 1,
      { 417, 403, 152 },
      -1,
   } },

   /* ('ffma@32(nsz)', ('bcsel', ('feq', 'b', 0.0, 'ignore_exact'), 0.0, ('fneg', 'a')), ('bcsel', ('feq', 'a', 0.0, 'ignore_exact'), 0.0, 'b'), 'c') => ('ffmaz', ('fneg', 'a'), 'b', 'c') */
   /* search166_0_0_0 -> 389 in the cache */
   /* search166_0_0_1 -> 244 in the cache */
   /* search166_0_0 -> 390 in the cache */
   /* search166_0_1 -> 244 in the cache */
   /* search166_0_2_0 -> 200 in the cache */
   /* search166_0_2 -> 417 in the cache */
   /* search166_0 -> 418 in the cache */
   /* search166_1_0_0 -> 200 in the cache */
   /* search166_1_0_1 -> 244 in the cache */
   /* search166_1_0 -> 394 in the cache */
   /* search166_1_1 -> 244 in the cache */
   /* search166_1_2 -> 389 in the cache */
   /* search166_1 -> 407 in the cache */
   /* search166_2 -> 152 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      true,
      false,
      false,
      nir_op_ffma,
      0, 3,
      { 418, 407, 152 },
      -1,
   } },

   /* replace166_0_0 -> 200 in the cache */
   /* replace166_0 -> 417 in the cache */
   /* replace166_1 -> 389 in the cache */
   /* replace166_2 -> 152 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ffmaz,
      0, 1,
      { 417, 389, 152 },
      -1,
   } },

   /* ('ffma@32(nsz)', ('bcsel', ('feq', 'b', 0.0, 'ignore_exact'), 0.0, 'a'), ('bcsel', ('feq', 'a', 0.0, 'ignore_exact'), 0.0, 'b'), 'c') => ('ffmaz', 'a', 'b', 'c') */
   /* search167_0_0_0 -> 389 in the cache */
   /* search167_0_0_1 -> 244 in the cache */
   /* search167_0_0 -> 390 in the cache */
   /* search167_0_1 -> 244 in the cache */
   /* search167_0_2 -> 200 in the cache */
   /* search167_0 -> 423 in the cache */
   /* search167_1_0_0 -> 200 in the cache */
   /* search167_1_0_1 -> 244 in the cache */
   /* search167_1_0 -> 394 in the cache */
   /* search167_1_1 -> 244 in the cache */
   /* search167_1_2 -> 389 in the cache */
   /* search167_1 -> 407 in the cache */
   /* search167_2 -> 152 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      true,
      false,
      false,
      nir_op_ffma,
      0, 3,
      { 423, 407, 152 },
      -1,
   } },

   /* replace167_0 -> 200 in the cache */
   /* replace167_1 -> 389 in the cache */
   /* replace167_2 -> 152 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ffmaz,
      0, 1,
      { 200, 389, 152 },
      -1,
   } },

   /* ('ffma@32(nsz)', ('fneg', ('fabs', 'a')), ('bcsel', ('feq', 'a', 0.0, 'ignore_exact'), 0.0, '#b(is_not_const_zero)'), 'c') => ('ffmaz', ('fneg', ('fabs', 'a')), 'b', 'c') */
   /* search168_0_0_0 -> 29 in the cache */
   /* search168_0_0 -> 426 in the cache */
   /* search168_0 -> 427 in the cache */
   /* search168_1_0_0 -> 29 in the cache */
   /* search168_1_0_1 -> 244 in the cache */
   /* search168_1_0 -> 428 in the cache */
   /* search168_1_1 -> 244 in the cache */
   /* search168_1_2 -> 429 in the cache */
   /* search168_1 -> 430 in the cache */
   /* search168_2 -> 152 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      true,
      false,
      false,
      nir_op_ffma,
      0, 2,
      { 427, 430, 152 },
      -1,
   } },

   /* replace168_0_0_0 -> 29 in the cache */
   /* replace168_0_0 -> 426 in the cache */
   /* replace168_0 -> 427 in the cache */
   /* replace168_1 -> 48 in the cache */
   /* replace168_2 -> 152 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ffmaz,
      0, 1,
      { 427, 48, 152 },
      -1,
   } },

   /* ('ffma@32(nsz)', ('fabs', 'a'), ('bcsel', ('feq', 'a', 0.0, 'ignore_exact'), 0.0, '#b(is_not_const_zero)'), 'c') => ('ffmaz', ('fabs', 'a'), 'b', 'c') */
   /* search169_0_0 -> 29 in the cache */
   /* search169_0 -> 426 in the cache */
   /* search169_1_0_0 -> 29 in the cache */
   /* search169_1_0_1 -> 244 in the cache */
   /* search169_1_0 -> 428 in the cache */
   /* search169_1_1 -> 244 in the cache */
   /* search169_1_2 -> 429 in the cache */
   /* search169_1 -> 430 in the cache */
   /* search169_2 -> 152 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      true,
      false,
      false,
      nir_op_ffma,
      0, 2,
      { 426, 430, 152 },
      -1,
   } },

   /* replace169_0_0 -> 29 in the cache */
   /* replace169_0 -> 426 in the cache */
   /* replace169_1 -> 48 in the cache */
   /* replace169_2 -> 152 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ffmaz,
      0, 1,
      { 426, 48, 152 },
      -1,
   } },

   /* ('ffma@32(nsz)', ('fneg', 'a'), ('bcsel', ('feq', 'a', 0.0, 'ignore_exact'), 0.0, '#b(is_not_const_zero)'), 'c') => ('ffmaz', ('fneg', 'a'), 'b', 'c') */
   /* search170_0_0 -> 29 in the cache */
   /* search170_0 -> 296 in the cache */
   /* search170_1_0_0 -> 29 in the cache */
   /* search170_1_0_1 -> 244 in the cache */
   /* search170_1_0 -> 428 in the cache */
   /* search170_1_1 -> 244 in the cache */
   /* search170_1_2 -> 429 in the cache */
   /* search170_1 -> 430 in the cache */
   /* search170_2 -> 152 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      true,
      false,
      false,
      nir_op_ffma,
      0, 2,
      { 296, 430, 152 },
      -1,
   } },

   /* replace170_0_0 -> 29 in the cache */
   /* replace170_0 -> 296 in the cache */
   /* replace170_1 -> 48 in the cache */
   /* replace170_2 -> 152 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ffmaz,
      0, 1,
      { 296, 48, 152 },
      -1,
   } },

   /* ('ffma@32(nsz)', 'a', ('bcsel', ('feq', 'a', 0.0, 'ignore_exact'), 0.0, '#b(is_not_const_zero)'), 'c') => ('ffmaz', 'a', 'b', 'c') */
   /* search171_0 -> 29 in the cache */
   /* search171_1_0_0 -> 29 in the cache */
   /* search171_1_0_1 -> 244 in the cache */
   /* search171_1_0 -> 428 in the cache */
   /* search171_1_1 -> 244 in the cache */
   /* search171_1_2 -> 429 in the cache */
   /* search171_1 -> 430 in the cache */
   /* search171_2 -> 152 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      true,
      false,
      false,
      nir_op_ffma,
      0, 2,
      { 29, 430, 152 },
      -1,
   } },

   /* replace171_0 -> 29 in the cache */
   /* replace171_1 -> 48 in the cache */
   /* replace171_2 -> 152 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ffmaz,
      0, 1,
      { 29, 48, 152 },
      -1,
   } },

   /* ('bcsel(nsz,nnan,ninf)', ('feq', 'b', 0.0, 'ignore_exact'), 1.0, ('fexp2', ('fmul@32', 'a', ('fneg', ('fabs', 'b'))))) => ('fexp2', ('fmulz', 'a', ('fneg', ('fabs', 'b')))) */
   /* search172_0_0 -> 389 in the cache */
   /* search172_0_1 -> 244 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      true,
      false,
      false,
      false,
      nir_op_feq,
      0, 1,
      { 389, 244 },
      -1,
   } },
   /* search172_1 -> 264 in the cache */
   /* search172_2_0_0 -> 200 in the cache */
   /* search172_2_0_1_0_0 -> 389 in the cache */
   /* search172_2_0_1_0 -> 395 in the cache */
   /* search172_2_0_1 -> 396 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fmul,
      1, 1,
      { 200, 396 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fexp2,
      -1, 1,
      { 467 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      true,
      true,
      true,
      nir_op_bcsel,
      -1, 2,
      { 466, 264, 468 },
      -1,
   } },

   /* replace172_0_0 -> 200 in the cache */
   /* replace172_0_1_0_0 -> 389 in the cache */
   /* replace172_0_1_0 -> 395 in the cache */
   /* replace172_0_1 -> 396 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fmulz,
      0, 1,
      { 200, 396 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fexp2,
      -1, 1,
      { 470 },
      -1,
   } },

   /* ('bcsel(nsz,nnan,ninf)', ('feq', 'b', 0.0, 'ignore_exact'), 1.0, ('fexp2', ('fmul@32', 'a', ('fabs', 'b')))) => ('fexp2', ('fmulz', 'a', ('fabs', 'b'))) */
   /* search173_0_0 -> 389 in the cache */
   /* search173_0_1 -> 244 in the cache */
   /* search173_0 -> 466 in the cache */
   /* search173_1 -> 264 in the cache */
   /* search173_2_0_0 -> 200 in the cache */
   /* search173_2_0_1_0 -> 389 in the cache */
   /* search173_2_0_1 -> 395 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fmul,
      1, 1,
      { 200, 395 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fexp2,
      -1, 1,
      { 472 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      true,
      true,
      true,
      nir_op_bcsel,
      -1, 2,
      { 466, 264, 473 },
      -1,
   } },

   /* replace173_0_0 -> 200 in the cache */
   /* replace173_0_1_0 -> 389 in the cache */
   /* replace173_0_1 -> 395 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fmulz,
      0, 1,
      { 200, 395 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fexp2,
      -1, 1,
      { 475 },
      -1,
   } },

   /* ('bcsel(nsz,nnan,ninf)', ('feq', 'b', 0.0, 'ignore_exact'), 1.0, ('fexp2', ('fmul@32', 'a', ('fneg', 'b')))) => ('fexp2', ('fmulz', 'a', ('fneg', 'b'))) */
   /* search174_0_0 -> 389 in the cache */
   /* search174_0_1 -> 244 in the cache */
   /* search174_0 -> 466 in the cache */
   /* search174_1 -> 264 in the cache */
   /* search174_2_0_0 -> 200 in the cache */
   /* search174_2_0_1_0 -> 389 in the cache */
   /* search174_2_0_1 -> 403 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fmul,
      1, 1,
      { 200, 403 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fexp2,
      -1, 1,
      { 477 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      true,
      true,
      true,
      nir_op_bcsel,
      -1, 2,
      { 466, 264, 478 },
      -1,
   } },

   /* replace174_0_0 -> 200 in the cache */
   /* replace174_0_1_0 -> 389 in the cache */
   /* replace174_0_1 -> 403 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fmulz,
      0, 1,
      { 200, 403 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fexp2,
      -1, 1,
      { 480 },
      -1,
   } },

   /* ('bcsel(nsz,nnan,ninf)', ('feq', 'b', 0.0, 'ignore_exact'), 1.0, ('fexp2', ('fmul@32', 'a', 'b'))) => ('fexp2', ('fmulz', 'a', 'b')) */
   /* search175_0_0 -> 389 in the cache */
   /* search175_0_1 -> 244 in the cache */
   /* search175_0 -> 466 in the cache */
   /* search175_1 -> 264 in the cache */
   /* search175_2_0_0 -> 200 in the cache */
   /* search175_2_0_1 -> 389 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fmul,
      1, 1,
      { 200, 389 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fexp2,
      -1, 1,
      { 482 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      true,
      true,
      true,
      nir_op_bcsel,
      -1, 2,
      { 466, 264, 483 },
      -1,
   } },

   /* replace175_0_0 -> 200 in the cache */
   /* replace175_0_1 -> 389 in the cache */
   /* replace175_0 -> 425 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fexp2,
      -1, 1,
      { 425 },
      -1,
   } },

   /* ('bcsel', ('feq', 'b', 0.0, 'ignore_exact'), 1.0, ('fexp2', ('fmulz', 'a', ('fneg', ('fabs', 'b'))))) => ('fexp2', ('fmulz', 'a', ('fneg', ('fabs', 'b')))) */
   /* search176_0_0 -> 389 in the cache */
   /* search176_0_1 -> 244 in the cache */
   /* search176_0 -> 466 in the cache */
   /* search176_1 -> 264 in the cache */
   /* search176_2_0_0 -> 200 in the cache */
   /* search176_2_0_1_0_0 -> 389 in the cache */
   /* search176_2_0_1_0 -> 395 in the cache */
   /* search176_2_0_1 -> 396 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fmulz,
      1, 1,
      { 200, 396 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fexp2,
      -1, 1,
      { 486 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_bcsel,
      -1, 2,
      { 466, 264, 487 },
      -1,
   } },

   /* replace176_0_0 -> 200 in the cache */
   /* replace176_0_1_0_0 -> 389 in the cache */
   /* replace176_0_1_0 -> 395 in the cache */
   /* replace176_0_1 -> 396 in the cache */
   /* replace176_0 -> 470 in the cache */
   /* replace176 -> 471 in the cache */

   /* ('bcsel', ('feq', 'b', 0.0, 'ignore_exact'), 1.0, ('fexp2', ('fmulz', 'a', ('fabs', 'b')))) => ('fexp2', ('fmulz', 'a', ('fabs', 'b'))) */
   /* search177_0_0 -> 389 in the cache */
   /* search177_0_1 -> 244 in the cache */
   /* search177_0 -> 466 in the cache */
   /* search177_1 -> 264 in the cache */
   /* search177_2_0_0 -> 200 in the cache */
   /* search177_2_0_1_0 -> 389 in the cache */
   /* search177_2_0_1 -> 395 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fmulz,
      1, 1,
      { 200, 395 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fexp2,
      -1, 1,
      { 489 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_bcsel,
      -1, 2,
      { 466, 264, 490 },
      -1,
   } },

   /* replace177_0_0 -> 200 in the cache */
   /* replace177_0_1_0 -> 389 in the cache */
   /* replace177_0_1 -> 395 in the cache */
   /* replace177_0 -> 475 in the cache */
   /* replace177 -> 476 in the cache */

   /* ('bcsel', ('feq', 'b', 0.0, 'ignore_exact'), 1.0, ('fexp2', ('fmulz', 'a', ('fneg', 'b')))) => ('fexp2', ('fmulz', 'a', ('fneg', 'b'))) */
   /* search178_0_0 -> 389 in the cache */
   /* search178_0_1 -> 244 in the cache */
   /* search178_0 -> 466 in the cache */
   /* search178_1 -> 264 in the cache */
   /* search178_2_0_0 -> 200 in the cache */
   /* search178_2_0_1_0 -> 389 in the cache */
   /* search178_2_0_1 -> 403 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fmulz,
      1, 1,
      { 200, 403 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fexp2,
      -1, 1,
      { 492 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_bcsel,
      -1, 2,
      { 466, 264, 493 },
      -1,
   } },

   /* replace178_0_0 -> 200 in the cache */
   /* replace178_0_1_0 -> 389 in the cache */
   /* replace178_0_1 -> 403 in the cache */
   /* replace178_0 -> 480 in the cache */
   /* replace178 -> 481 in the cache */

   /* ('bcsel', ('feq', 'b', 0.0, 'ignore_exact'), 1.0, ('fexp2', ('fmulz', 'a', 'b'))) => ('fexp2', ('fmulz', 'a', 'b')) */
   /* search179_0_0 -> 389 in the cache */
   /* search179_0_1 -> 244 in the cache */
   /* search179_0 -> 466 in the cache */
   /* search179_1 -> 264 in the cache */
   /* search179_2_0_0 -> 200 in the cache */
   /* search179_2_0_1 -> 389 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fmulz,
      1, 1,
      { 200, 389 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fexp2,
      -1, 1,
      { 495 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_bcsel,
      -1, 2,
      { 466, 264, 496 },
      -1,
   } },

   /* replace179_0_0 -> 200 in the cache */
   /* replace179_0_1 -> 389 in the cache */
   /* replace179_0 -> 425 in the cache */
   /* replace179 -> 485 in the cache */

   /* ('sdot_4x8_iadd', 'a', 'b', 'c') => ('iadd', ('iadd', ('iadd', ('imul', ('extract_i8', 'a', 0), ('extract_i8', 'b', 0)), ('imul', ('extract_i8', 'a', 1), ('extract_i8', 'b', 1))), ('iadd', ('imul', ('extract_i8', 'a', 2), ('extract_i8', 'b', 2)), ('imul', ('extract_i8', 'a', 3), ('extract_i8', 'b', 3)))), 'c') */
   /* search180_0 -> 29 in the cache */
   /* search180_1 -> 48 in the cache */
   /* search180_2 -> 152 in the cache */
   /* search180 -> 347 in the cache */

   /* replace180_0_0_0_0_0 -> 29 in the cache */
   /* replace180_0_0_0_0_1 -> 139 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_extract_i8,
      -1, 0,
      { 29, 139 },
      -1,
   } },
   /* replace180_0_0_0_1_0 -> 48 in the cache */
   /* replace180_0_0_0_1_1 -> 139 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_extract_i8,
      -1, 0,
      { 48, 139 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_imul,
      3, 1,
      { 498, 499 },
      -1,
   } },
   /* replace180_0_0_1_0_0 -> 29 in the cache */
   { .constant = {
      { nir_search_value_constant, 32 },
      nir_type_int, { 0x1ull /* 1 */ },
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_extract_i8,
      -1, 0,
      { 29, 501 },
      -1,
   } },
   /* replace180_0_0_1_1_0 -> 48 in the cache */
   /* replace180_0_0_1_1_1 -> 501 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_extract_i8,
      -1, 0,
      { 48, 501 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_imul,
      4, 1,
      { 502, 503 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_iadd,
      2, 3,
      { 500, 504 },
      -1,
   } },
   /* replace180_0_1_0_0_0 -> 29 in the cache */
   { .constant = {
      { nir_search_value_constant, 32 },
      nir_type_int, { 0x2ull /* 2 */ },
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_extract_i8,
      -1, 0,
      { 29, 506 },
      -1,
   } },
   /* replace180_0_1_0_1_0 -> 48 in the cache */
   /* replace180_0_1_0_1_1 -> 506 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_extract_i8,
      -1, 0,
      { 48, 506 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_imul,
      6, 1,
      { 507, 508 },
      -1,
   } },
   /* replace180_0_1_1_0_0 -> 29 in the cache */
   { .constant = {
      { nir_search_value_constant, 32 },
      nir_type_int, { 0x3ull /* 3 */ },
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_extract_i8,
      -1, 0,
      { 29, 510 },
      -1,
   } },
   /* replace180_0_1_1_1_0 -> 48 in the cache */
   /* replace180_0_1_1_1_1 -> 510 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_extract_i8,
      -1, 0,
      { 48, 510 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_imul,
      7, 1,
      { 511, 512 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_iadd,
      5, 3,
      { 509, 513 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_iadd,
      1, 7,
      { 505, 514 },
      -1,
   } },
   /* replace180_1 -> 152 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_iadd,
      0, 8,
      { 515, 152 },
      -1,
   } },

   /* ('udot_4x8_uadd', 'a', 'b', 'c') => ('iadd', ('iadd', ('iadd', ('imul', ('extract_u8', 'a', 0), ('extract_u8', 'b', 0)), ('imul', ('extract_u8', 'a', 1), ('extract_u8', 'b', 1))), ('iadd', ('imul', ('extract_u8', 'a', 2), ('extract_u8', 'b', 2)), ('imul', ('extract_u8', 'a', 3), ('extract_u8', 'b', 3)))), 'c') */
   /* search181_0 -> 29 in the cache */
   /* search181_1 -> 48 in the cache */
   /* search181_2 -> 152 in the cache */
   /* search181 -> 350 in the cache */

   /* replace181_0_0_0_0_0 -> 29 in the cache */
   /* replace181_0_0_0_0_1 -> 139 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_extract_u8,
      -1, 0,
      { 29, 139 },
      -1,
   } },
   /* replace181_0_0_0_1_0 -> 48 in the cache */
   /* replace181_0_0_0_1_1 -> 139 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_extract_u8,
      -1, 0,
      { 48, 139 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_imul,
      3, 1,
      { 517, 518 },
      -1,
   } },
   /* replace181_0_0_1_0_0 -> 29 in the cache */
   /* replace181_0_0_1_0_1 -> 501 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_extract_u8,
      -1, 0,
      { 29, 501 },
      -1,
   } },
   /* replace181_0_0_1_1_0 -> 48 in the cache */
   /* replace181_0_0_1_1_1 -> 501 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_extract_u8,
      -1, 0,
      { 48, 501 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_imul,
      4, 1,
      { 520, 521 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_iadd,
      2, 3,
      { 519, 522 },
      -1,
   } },
   /* replace181_0_1_0_0_0 -> 29 in the cache */
   /* replace181_0_1_0_0_1 -> 506 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_extract_u8,
      -1, 0,
      { 29, 506 },
      -1,
   } },
   /* replace181_0_1_0_1_0 -> 48 in the cache */
   /* replace181_0_1_0_1_1 -> 506 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_extract_u8,
      -1, 0,
      { 48, 506 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_imul,
      6, 1,
      { 524, 525 },
      -1,
   } },
   /* replace181_0_1_1_0_0 -> 29 in the cache */
   /* replace181_0_1_1_0_1 -> 510 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_extract_u8,
      -1, 0,
      { 29, 510 },
      -1,
   } },
   /* replace181_0_1_1_1_0 -> 48 in the cache */
   /* replace181_0_1_1_1_1 -> 510 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_extract_u8,
      -1, 0,
      { 48, 510 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_imul,
      7, 1,
      { 527, 528 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_iadd,
      5, 3,
      { 526, 529 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_iadd,
      1, 7,
      { 523, 530 },
      -1,
   } },
   /* replace181_1 -> 152 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_iadd,
      0, 8,
      { 531, 152 },
      -1,
   } },

   /* ('sudot_4x8_iadd', 'a', 'b', 'c') => ('iadd', ('iadd', ('iadd', ('imul', ('extract_i8', 'a', 0), ('extract_u8', 'b', 0)), ('imul', ('extract_i8', 'a', 1), ('extract_u8', 'b', 1))), ('iadd', ('imul', ('extract_i8', 'a', 2), ('extract_u8', 'b', 2)), ('imul', ('extract_i8', 'a', 3), ('extract_u8', 'b', 3)))), 'c') */
   /* search182_0 -> 29 in the cache */
   /* search182_1 -> 48 in the cache */
   /* search182_2 -> 152 in the cache */
   /* search182 -> 353 in the cache */

   /* replace182_0_0_0_0_0 -> 29 in the cache */
   /* replace182_0_0_0_0_1 -> 139 in the cache */
   /* replace182_0_0_0_0 -> 498 in the cache */
   /* replace182_0_0_0_1_0 -> 48 in the cache */
   /* replace182_0_0_0_1_1 -> 139 in the cache */
   /* replace182_0_0_0_1 -> 518 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_imul,
      3, 1,
      { 498, 518 },
      -1,
   } },
   /* replace182_0_0_1_0_0 -> 29 in the cache */
   /* replace182_0_0_1_0_1 -> 501 in the cache */
   /* replace182_0_0_1_0 -> 502 in the cache */
   /* replace182_0_0_1_1_0 -> 48 in the cache */
   /* replace182_0_0_1_1_1 -> 501 in the cache */
   /* replace182_0_0_1_1 -> 521 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_imul,
      4, 1,
      { 502, 521 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_iadd,
      2, 3,
      { 533, 534 },
      -1,
   } },
   /* replace182_0_1_0_0_0 -> 29 in the cache */
   /* replace182_0_1_0_0_1 -> 506 in the cache */
   /* replace182_0_1_0_0 -> 507 in the cache */
   /* replace182_0_1_0_1_0 -> 48 in the cache */
   /* replace182_0_1_0_1_1 -> 506 in the cache */
   /* replace182_0_1_0_1 -> 525 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_imul,
      6, 1,
      { 507, 525 },
      -1,
   } },
   /* replace182_0_1_1_0_0 -> 29 in the cache */
   /* replace182_0_1_1_0_1 -> 510 in the cache */
   /* replace182_0_1_1_0 -> 511 in the cache */
   /* replace182_0_1_1_1_0 -> 48 in the cache */
   /* replace182_0_1_1_1_1 -> 510 in the cache */
   /* replace182_0_1_1_1 -> 528 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_imul,
      7, 1,
      { 511, 528 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_iadd,
      5, 3,
      { 536, 537 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_iadd,
      1, 7,
      { 535, 538 },
      -1,
   } },
   /* replace182_1 -> 152 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_iadd,
      0, 8,
      { 539, 152 },
      -1,
   } },

   /* ('sdot_2x16_iadd', 'a', 'b', 'c') => ('iadd', ('iadd', ('imul', ('extract_i16', 'a', 0), ('extract_i16', 'b', 0)), ('imul', ('extract_i16', 'a', 1), ('extract_i16', 'b', 1))), 'c') */
   /* search183_0 -> 29 in the cache */
   /* search183_1 -> 48 in the cache */
   /* search183_2 -> 152 in the cache */
   /* search183 -> 359 in the cache */

   /* replace183_0_0_0_0 -> 29 in the cache */
   /* replace183_0_0_0_1 -> 139 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_extract_i16,
      -1, 0,
      { 29, 139 },
      -1,
   } },
   /* replace183_0_0_1_0 -> 48 in the cache */
   /* replace183_0_0_1_1 -> 139 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_extract_i16,
      -1, 0,
      { 48, 139 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_imul,
      2, 1,
      { 541, 542 },
      -1,
   } },
   /* replace183_0_1_0_0 -> 29 in the cache */
   /* replace183_0_1_0_1 -> 501 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_extract_i16,
      -1, 0,
      { 29, 501 },
      -1,
   } },
   /* replace183_0_1_1_0 -> 48 in the cache */
   /* replace183_0_1_1_1 -> 501 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_extract_i16,
      -1, 0,
      { 48, 501 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_imul,
      3, 1,
      { 544, 545 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_iadd,
      1, 3,
      { 543, 546 },
      -1,
   } },
   /* replace183_1 -> 152 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_iadd,
      0, 4,
      { 547, 152 },
      -1,
   } },

   /* ('udot_2x16_uadd', 'a', 'b', 'c') => ('iadd', ('iadd', ('imul', ('extract_u16', 'a', 0), ('extract_u16', 'b', 0)), ('imul', ('extract_u16', 'a', 1), ('extract_u16', 'b', 1))), 'c') */
   /* search184_0 -> 29 in the cache */
   /* search184_1 -> 48 in the cache */
   /* search184_2 -> 152 in the cache */
   /* search184 -> 362 in the cache */

   /* replace184_0_0_0_0 -> 29 in the cache */
   /* replace184_0_0_0_1 -> 139 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_extract_u16,
      -1, 0,
      { 29, 139 },
      -1,
   } },
   /* replace184_0_0_1_0 -> 48 in the cache */
   /* replace184_0_0_1_1 -> 139 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_extract_u16,
      -1, 0,
      { 48, 139 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_imul,
      2, 1,
      { 549, 550 },
      -1,
   } },
   /* replace184_0_1_0_0 -> 29 in the cache */
   /* replace184_0_1_0_1 -> 501 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_extract_u16,
      -1, 0,
      { 29, 501 },
      -1,
   } },
   /* replace184_0_1_1_0 -> 48 in the cache */
   /* replace184_0_1_1_1 -> 501 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_extract_u16,
      -1, 0,
      { 48, 501 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_imul,
      3, 1,
      { 552, 553 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_iadd,
      1, 3,
      { 551, 554 },
      -1,
   } },
   /* replace184_1 -> 152 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_iadd,
      0, 4,
      { 555, 152 },
      -1,
   } },

   /* ('udot_4x8_uadd_sat', 'a', 'b', '#c(is_ult_0xfffc07fc)') => ('udot_4x8_uadd', 'a', 'b', 'c') */
   /* search185_0 -> 29 in the cache */
   /* search185_1 -> 48 in the cache */
   { .variable = {
      { nir_search_value_variable, 32 },
      2, /* c */
      true,
      nir_type_invalid,
      8,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_udot_4x8_uadd_sat,
      0, 1,
      { 29, 48, 557 },
      -1,
   } },

   /* replace185_0 -> 29 in the cache */
   /* replace185_1 -> 48 in the cache */
   /* replace185_2 -> 152 in the cache */
   /* replace185 -> 350 in the cache */

   /* ('udot_4x8_uadd_sat', 'a', 'b', 'c') => ('uadd_sat', ('udot_4x8_uadd', 'a', 'b', 0), 'c') */
   /* search186_0 -> 29 in the cache */
   /* search186_1 -> 48 in the cache */
   /* search186_2 -> 152 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_udot_4x8_uadd_sat,
      0, 1,
      { 29, 48, 152 },
      -1,
   } },

   /* replace186_0_0 -> 29 in the cache */
   /* replace186_0_1 -> 48 in the cache */
   /* replace186_0_2 -> 139 in the cache */
   /* replace186_0 -> 368 in the cache */
   /* replace186_1 -> 152 in the cache */
   /* replace186 -> 382 in the cache */

   /* ('sdot_4x8_iadd_sat', 'a', 'b', 'c') => ('iadd_sat', ('sdot_4x8_iadd', 'a', 'b', 0), 'c') */
   /* search187_0 -> 29 in the cache */
   /* search187_1 -> 48 in the cache */
   /* search187_2 -> 152 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_sdot_4x8_iadd_sat,
      0, 1,
      { 29, 48, 152 },
      -1,
   } },

   /* replace187_0_0 -> 29 in the cache */
   /* replace187_0_1 -> 48 in the cache */
   /* replace187_0_2 -> 139 in the cache */
   /* replace187_0 -> 365 in the cache */
   /* replace187_1 -> 152 in the cache */
   /* replace187 -> 380 in the cache */

   /* ('sudot_4x8_iadd_sat', 'a', 'b', 'c') => ('iadd_sat', ('sudot_4x8_iadd', 'a', 'b', 0), 'c') */
   /* search188_0 -> 29 in the cache */
   /* search188_1 -> 48 in the cache */
   /* search188_2 -> 152 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_sudot_4x8_iadd_sat,
      -1, 0,
      { 29, 48, 152 },
      -1,
   } },

   /* replace188_0_0 -> 29 in the cache */
   /* replace188_0_1 -> 48 in the cache */
   /* replace188_0_2 -> 139 in the cache */
   /* replace188_0 -> 371 in the cache */
   /* replace188_1 -> 152 in the cache */
   /* replace188 -> 384 in the cache */

   /* ('udot_2x16_uadd_sat', 'a', 'b', 'c') => ('uadd_sat', ('iadd', ('imul', ('extract_u16', 'a', 0), ('extract_u16', 'b', 0)), ('imul', ('extract_u16', 'a', 1), ('extract_u16', 'b', 1))), 'c') */
   /* search189_0 -> 29 in the cache */
   /* search189_1 -> 48 in the cache */
   /* search189_2 -> 152 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_udot_2x16_uadd_sat,
      0, 1,
      { 29, 48, 152 },
      -1,
   } },

   /* replace189_0_0_0_0 -> 29 in the cache */
   /* replace189_0_0_0_1 -> 139 in the cache */
   /* replace189_0_0_0 -> 549 in the cache */
   /* replace189_0_0_1_0 -> 48 in the cache */
   /* replace189_0_0_1_1 -> 139 in the cache */
   /* replace189_0_0_1 -> 550 in the cache */
   /* replace189_0_0 -> 551 in the cache */
   /* replace189_0_1_0_0 -> 29 in the cache */
   /* replace189_0_1_0_1 -> 501 in the cache */
   /* replace189_0_1_0 -> 552 in the cache */
   /* replace189_0_1_1_0 -> 48 in the cache */
   /* replace189_0_1_1_1 -> 501 in the cache */
   /* replace189_0_1_1 -> 553 in the cache */
   /* replace189_0_1 -> 554 in the cache */
   /* replace189_0 -> 555 in the cache */
   /* replace189_1 -> 152 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_uadd_sat,
      0, 4,
      { 555, 152 },
      -1,
   } },

   /* ('sdot_2x16_iadd_sat', 'a', 'b', 'c') => ('iadd_sat', ('iadd', ('imul', ('extract_i16', 'a', 0), ('extract_i16', 'b', 0)), ('imul', ('extract_i16', 'a', 1), ('extract_i16', 'b', 1))), 'c') */
   /* search190_0 -> 29 in the cache */
   /* search190_1 -> 48 in the cache */
   /* search190_2 -> 152 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_sdot_2x16_iadd_sat,
      0, 1,
      { 29, 48, 152 },
      -1,
   } },

   /* replace190_0_0_0_0 -> 29 in the cache */
   /* replace190_0_0_0_1 -> 139 in the cache */
   /* replace190_0_0_0 -> 541 in the cache */
   /* replace190_0_0_1_0 -> 48 in the cache */
   /* replace190_0_0_1_1 -> 139 in the cache */
   /* replace190_0_0_1 -> 542 in the cache */
   /* replace190_0_0 -> 543 in the cache */
   /* replace190_0_1_0_0 -> 29 in the cache */
   /* replace190_0_1_0_1 -> 501 in the cache */
   /* replace190_0_1_0 -> 544 in the cache */
   /* replace190_0_1_1_0 -> 48 in the cache */
   /* replace190_0_1_1_1 -> 501 in the cache */
   /* replace190_0_1_1 -> 545 in the cache */
   /* replace190_0_1 -> 546 in the cache */
   /* replace190_0 -> 547 in the cache */
   /* replace190_1 -> 152 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_iadd_sat,
      0, 4,
      { 547, 152 },
      -1,
   } },

   /* ('~flrp@16', 'a', 'b', ('b2f', 'c@1')) => ('bcsel', 'c', 'b', 'a') */
   /* search191_0 -> 24 in the cache */
   { .variable = {
      { nir_search_value_variable, 16 },
      1, /* b */
      false,
      nir_type_invalid,
      -1,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .variable = {
      { nir_search_value_variable, 1 },
      2, /* c */
      false,
      nir_type_invalid,
      -1,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_search_op_b2f,
      -1, 0,
      { 567 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 16 },
      true,
      false,
      false,
      false,
      false,
      false,
      nir_op_flrp,
      -1, 0,
      { 24, 566, 568 },
      -1,
   } },

   /* replace191_0 -> 567 in the cache */
   /* replace191_1 -> 566 in the cache */
   /* replace191_2 -> 24 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_bcsel,
      -1, 0,
      { 567, 566, 24 },
      -1,
   } },

   /* ('~flrp@16', 'a', ('fadd', 'a', 'b'), 'c') => ('fadd', ('fmul', 'b', 'c'), 'a') */
   /* search192_0 -> 24 in the cache */
   /* search192_1_0 -> 24 in the cache */
   /* search192_1_1 -> 566 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fadd,
      0, 1,
      { 24, 566 },
      -1,
   } },
   { .variable = {
      { nir_search_value_variable, 16 },
      2, /* c */
      false,
      nir_type_invalid,
      -1,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .expression = {
      { nir_search_value_expression, 16 },
      true,
      false,
      false,
      false,
      false,
      false,
      nir_op_flrp,
      -1, 1,
      { 24, 571, 572 },
      -1,
   } },

   /* replace192_0_0 -> 566 in the cache */
   /* replace192_0_1 -> 572 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fmul,
      1, 1,
      { 566, 572 },
      -1,
   } },
   /* replace192_1 -> 24 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fadd,
      0, 2,
      { 574, 24 },
      -1,
   } },

   /* ('~flrp@16', ('fadd(is_used_once)', 'a', 'b'), ('fadd(is_used_once)', 'a', 'c'), 'd') => ('fadd', ('flrp', 'b', 'c', 'd'), 'a') */
   /* search193_0_0 -> 24 in the cache */
   /* search193_0_1 -> 566 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fadd,
      0, 1,
      { 24, 566 },
      0,
   } },
   /* search193_1_0 -> 24 in the cache */
   /* search193_1_1 -> 572 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fadd,
      1, 1,
      { 24, 572 },
      0,
   } },
   { .variable = {
      { nir_search_value_variable, 16 },
      3, /* d */
      false,
      nir_type_invalid,
      -1,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .expression = {
      { nir_search_value_expression, 16 },
      true,
      false,
      false,
      false,
      false,
      false,
      nir_op_flrp,
      -1, 2,
      { 576, 577, 578 },
      -1,
   } },

   /* replace193_0_0 -> 566 in the cache */
   /* replace193_0_1 -> 572 in the cache */
   /* replace193_0_2 -> 578 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_flrp,
      -1, 0,
      { 566, 572, 578 },
      -1,
   } },
   /* replace193_1 -> 24 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fadd,
      0, 1,
      { 580, 24 },
      -1,
   } },

   /* ('~flrp@16', 'a', ('fmul(is_used_once)', 'a', 'b'), 'c') => ('fmul', ('flrp', 1.0, 'b', 'c'), 'a') */
   /* search194_0 -> 24 in the cache */
   /* search194_1_0 -> 24 in the cache */
   /* search194_1_1 -> 566 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fmul,
      0, 1,
      { 24, 566 },
      0,
   } },
   /* search194_2 -> 572 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      true,
      false,
      false,
      false,
      false,
      false,
      nir_op_flrp,
      -1, 1,
      { 24, 582, 572 },
      -1,
   } },

   { .constant = {
      { nir_search_value_constant, 16 },
      nir_type_float, { 0x3ff0000000000000ull /* 1.0 */ },
   } },
   /* replace194_0_1 -> 566 in the cache */
   /* replace194_0_2 -> 572 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_flrp,
      -1, 0,
      { 584, 566, 572 },
      -1,
   } },
   /* replace194_1 -> 24 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fmul,
      0, 1,
      { 585, 24 },
      -1,
   } },

   /* ('~fadd@16', ('fmul', 'a', ('fadd', 1.0, ('fneg', 'c'))), ('fmul', 'b', 'c')) => ('flrp', 'a', 'b', 'c') */
   /* search195_0_0 -> 24 in the cache */
   /* search195_0_1_0 -> 584 in the cache */
   { .variable = {
      { nir_search_value_variable, 16 },
      1, /* c */
      false,
      nir_type_invalid,
      -1,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fneg,
      -1, 0,
      { 587 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fadd,
      2, 1,
      { 584, 588 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fmul,
      1, 2,
      { 24, 589 },
      -1,
   } },
   { .variable = {
      { nir_search_value_variable, 16 },
      2, /* b */
      false,
      nir_type_invalid,
      -1,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   /* search195_1_1 -> 587 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fmul,
      3, 1,
      { 591, 587 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 16 },
      true,
      false,
      false,
      false,
      false,
      false,
      nir_op_fadd,
      0, 4,
      { 590, 592 },
      -1,
   } },

   /* replace195_0 -> 24 in the cache */
   /* replace195_1 -> 591 in the cache */
   /* replace195_2 -> 587 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_flrp,
      -1, 0,
      { 24, 591, 587 },
      -1,
   } },

   /* ('~fadd@16', ('fmul', 'a', ('fsat', ('fadd', 1.0, ('fneg', 'c')))), ('fmul', 'b', ('fsat', 'c'))) => ('flrp', 'a', 'b', ('fsat', 'c')) */
   /* search196_0_0 -> 24 in the cache */
   /* search196_0_1_0_0 -> 584 in the cache */
   /* search196_0_1_0_1_0 -> 587 in the cache */
   /* search196_0_1_0_1 -> 588 in the cache */
   /* search196_0_1_0 -> 589 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fsat,
      -1, 1,
      { 589 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fmul,
      1, 2,
      { 24, 595 },
      -1,
   } },
   /* search196_1_0 -> 591 in the cache */
   /* search196_1_1_0 -> 587 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fsat,
      -1, 0,
      { 587 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fmul,
      3, 1,
      { 591, 597 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 16 },
      true,
      false,
      false,
      false,
      false,
      false,
      nir_op_fadd,
      0, 4,
      { 596, 598 },
      -1,
   } },

   /* replace196_0 -> 24 in the cache */
   /* replace196_1 -> 591 in the cache */
   /* replace196_2_0 -> 587 in the cache */
   /* replace196_2 -> 597 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_flrp,
      -1, 0,
      { 24, 591, 597 },
      -1,
   } },

   /* ('~fadd@16', 'a', ('fmul', 'c', ('fadd', 'b', ('fneg', 'a')))) => ('flrp', 'a', 'b', 'c') */
   /* search197_0 -> 24 in the cache */
   /* search197_1_0 -> 587 in the cache */
   /* search197_1_1_0 -> 591 in the cache */
   /* search197_1_1_1_0 -> 24 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fneg,
      -1, 0,
      { 24 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fadd,
      2, 1,
      { 591, 601 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fmul,
      1, 2,
      { 587, 602 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 16 },
      true,
      false,
      false,
      false,
      false,
      false,
      nir_op_fadd,
      0, 3,
      { 24, 603 },
      -1,
   } },

   /* replace197_0 -> 24 in the cache */
   /* replace197_1 -> 591 in the cache */
   /* replace197_2 -> 587 in the cache */
   /* replace197 -> 594 in the cache */

   /* ('~fadd@16', ('fmul', 'a', ('fadd', 1.0, ('fneg', ('b2f', 'c@1')))), ('fmul', 'b', ('b2f', 'c'))) => ('bcsel', 'c', 'b', 'a') */
   /* search198_0_0 -> 24 in the cache */
   /* search198_0_1_0 -> 584 in the cache */
   { .variable = {
      { nir_search_value_variable, 1 },
      1, /* c */
      false,
      nir_type_invalid,
      -1,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_search_op_b2f,
      -1, 0,
      { 605 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fneg,
      -1, 0,
      { 606 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fadd,
      2, 1,
      { 584, 607 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fmul,
      1, 2,
      { 24, 608 },
      -1,
   } },
   /* search198_1_0 -> 591 in the cache */
   /* search198_1_1_0 -> 605 in the cache */
   /* search198_1_1 -> 606 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fmul,
      3, 1,
      { 591, 606 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 16 },
      true,
      false,
      false,
      false,
      false,
      false,
      nir_op_fadd,
      0, 4,
      { 609, 610 },
      -1,
   } },

   /* replace198_0 -> 605 in the cache */
   /* replace198_1 -> 591 in the cache */
   /* replace198_2 -> 24 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_bcsel,
      -1, 0,
      { 605, 591, 24 },
      -1,
   } },

   /* ('~fadd@16', 'a', ('fmul', ('b2f', 'c@1'), ('fadd', 'b', ('fneg', 'a')))) => ('bcsel', 'c', 'b', 'a') */
   /* search199_0 -> 24 in the cache */
   /* search199_1_0_0 -> 605 in the cache */
   /* search199_1_0 -> 606 in the cache */
   /* search199_1_1_0 -> 591 in the cache */
   /* search199_1_1_1_0 -> 24 in the cache */
   /* search199_1_1_1 -> 601 in the cache */
   /* search199_1_1 -> 602 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fmul,
      1, 2,
      { 606, 602 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 16 },
      true,
      false,
      false,
      false,
      false,
      false,
      nir_op_fadd,
      0, 3,
      { 24, 613 },
      -1,
   } },

   /* replace199_0 -> 605 in the cache */
   /* replace199_1 -> 591 in the cache */
   /* replace199_2 -> 24 in the cache */
   /* replace199 -> 612 in the cache */

   /* ('~ffma@16', 'a', ('fadd', 1.0, ('fneg', ('b2f', 'c@1'))), ('fmul', 'b', ('b2f', 'c@1'))) => ('bcsel', 'c', 'b', 'a') */
   /* search200_0 -> 24 in the cache */
   /* search200_1_0 -> 584 in the cache */
   /* search200_1_1_0_0 -> 605 in the cache */
   /* search200_1_1_0 -> 606 in the cache */
   /* search200_1_1 -> 607 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fadd,
      1, 1,
      { 584, 607 },
      -1,
   } },
   /* search200_2_0 -> 591 in the cache */
   /* search200_2_1_0 -> 605 in the cache */
   /* search200_2_1 -> 606 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fmul,
      2, 1,
      { 591, 606 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 16 },
      true,
      false,
      false,
      false,
      false,
      false,
      nir_op_ffma,
      0, 3,
      { 24, 615, 616 },
      -1,
   } },

   /* replace200_0 -> 605 in the cache */
   /* replace200_1 -> 591 in the cache */
   /* replace200_2 -> 24 in the cache */
   /* replace200 -> 612 in the cache */

   /* ('~ffma@16', 'b', ('b2f', 'c@1'), ('ffma', ('fneg', 'a'), ('b2f', 'c@1'), 'a')) => ('bcsel', 'c', 'b', 'a') */
   { .variable = {
      { nir_search_value_variable, 16 },
      0, /* b */
      false,
      nir_type_invalid,
      -1,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   /* search201_1_0 -> 605 in the cache */
   /* search201_1 -> 606 in the cache */
   { .variable = {
      { nir_search_value_variable, 16 },
      2, /* a */
      false,
      nir_type_invalid,
      -1,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fneg,
      -1, 0,
      { 619 },
      -1,
   } },
   /* search201_2_1_0 -> 605 in the cache */
   /* search201_2_1 -> 606 in the cache */
   /* search201_2_2 -> 619 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ffma,
      1, 1,
      { 620, 606, 619 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 16 },
      true,
      false,
      false,
      false,
      false,
      false,
      nir_op_ffma,
      0, 2,
      { 618, 606, 621 },
      -1,
   } },

   /* replace201_0 -> 605 in the cache */
   /* replace201_1 -> 618 in the cache */
   /* replace201_2 -> 619 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_bcsel,
      -1, 0,
      { 605, 618, 619 },
      -1,
   } },

   /* ('~ffma@16', ('b2f', 'c@1'), ('fadd', 'b', ('fneg', 'a')), 'a') => ('bcsel', 'c', 'b', 'a') */
   { .variable = {
      { nir_search_value_variable, 1 },
      0, /* c */
      false,
      nir_type_invalid,
      -1,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_search_op_b2f,
      -1, 0,
      { 624 },
      -1,
   } },
   /* search202_1_0 -> 566 in the cache */
   /* search202_1_1_0 -> 619 in the cache */
   /* search202_1_1 -> 620 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fadd,
      1, 1,
      { 566, 620 },
      -1,
   } },
   /* search202_2 -> 619 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      true,
      false,
      false,
      false,
      false,
      false,
      nir_op_ffma,
      0, 2,
      { 625, 626, 619 },
      -1,
   } },

   /* replace202_0 -> 624 in the cache */
   /* replace202_1 -> 566 in the cache */
   /* replace202_2 -> 619 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_bcsel,
      -1, 0,
      { 624, 566, 619 },
      -1,
   } },

   /* ('~ffma@16', ('b2f', 'c@1'), ('ffma', ('fneg', 'a'), 'b', 'd'), ('fmul', 'a', 'b')) => ('bcsel', 'c', 'd', ('fmul', 'a', 'b')) */
   /* search203_0_0 -> 624 in the cache */
   /* search203_0 -> 625 in the cache */
   { .variable = {
      { nir_search_value_variable, 16 },
      1, /* a */
      false,
      nir_type_invalid,
      -1,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fneg,
      -1, 0,
      { 629 },
      -1,
   } },
   /* search203_1_1 -> 591 in the cache */
   /* search203_1_2 -> 578 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ffma,
      1, 1,
      { 630, 591, 578 },
      -1,
   } },
   /* search203_2_0 -> 629 in the cache */
   /* search203_2_1 -> 591 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fmul,
      2, 1,
      { 629, 591 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 16 },
      true,
      false,
      false,
      false,
      false,
      false,
      nir_op_ffma,
      0, 3,
      { 625, 631, 632 },
      -1,
   } },

   /* replace203_0 -> 624 in the cache */
   /* replace203_1 -> 578 in the cache */
   /* replace203_2_0 -> 629 in the cache */
   /* replace203_2_1 -> 591 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fmul,
      0, 1,
      { 629, 591 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_bcsel,
      -1, 1,
      { 624, 578, 634 },
      -1,
   } },

   /* ('~fadd@16', 1.0, ('fneg', ('fmul', ('fadd', 1.0, ('fneg', 'a')), ('fadd', 1.0, ('fneg', 'b'))))) => ('flrp', 'b', 1.0, 'a') */
   /* search204_0 -> 584 in the cache */
   /* search204_1_0_0_0 -> 584 in the cache */
   /* search204_1_0_0_1_0 -> 24 in the cache */
   /* search204_1_0_0_1 -> 601 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fadd,
      2, 1,
      { 584, 601 },
      -1,
   } },
   /* search204_1_0_1_0 -> 584 in the cache */
   /* search204_1_0_1_1_0 -> 566 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fneg,
      -1, 0,
      { 566 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fadd,
      3, 1,
      { 584, 637 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fmul,
      1, 3,
      { 636, 638 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fneg,
      -1, 3,
      { 639 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 16 },
      true,
      false,
      false,
      false,
      false,
      false,
      nir_op_fadd,
      0, 4,
      { 584, 640 },
      -1,
   } },

   /* replace204_0 -> 566 in the cache */
   /* replace204_1 -> 584 in the cache */
   /* replace204_2 -> 24 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_flrp,
      -1, 0,
      { 566, 584, 24 },
      -1,
   } },

   /* ('~flrp@32', 'a', 'b', ('b2f', 'c@1')) => ('bcsel', 'c', 'b', 'a') */
   /* search205_0 -> 29 in the cache */
   /* search205_1 -> 48 in the cache */
   /* search205_2_0 -> 567 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_search_op_b2f,
      -1, 0,
      { 567 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      true,
      false,
      false,
      false,
      false,
      false,
      nir_op_flrp,
      -1, 0,
      { 29, 48, 643 },
      -1,
   } },

   /* replace205_0 -> 567 in the cache */
   /* replace205_1 -> 48 in the cache */
   /* replace205_2 -> 29 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_bcsel,
      -1, 0,
      { 567, 48, 29 },
      -1,
   } },

   /* ('~flrp@32', 'a', ('fadd', 'a', 'b'), 'c') => ('fadd', ('fmul', 'b', 'c'), 'a') */
   /* search206_0 -> 29 in the cache */
   /* search206_1_0 -> 29 in the cache */
   /* search206_1_1 -> 48 in the cache */
   /* search206_1 -> 290 in the cache */
   /* search206_2 -> 152 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      true,
      false,
      false,
      false,
      false,
      false,
      nir_op_flrp,
      -1, 1,
      { 29, 290, 152 },
      -1,
   } },

   /* replace206_0_0 -> 48 in the cache */
   /* replace206_0_1 -> 152 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fmul,
      1, 1,
      { 48, 152 },
      -1,
   } },
   /* replace206_1 -> 29 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fadd,
      0, 2,
      { 647, 29 },
      -1,
   } },

   /* ('~flrp@32', ('fadd(is_used_once)', 'a', 'b'), ('fadd(is_used_once)', 'a', 'c'), 'd') => ('fadd', ('flrp', 'b', 'c', 'd'), 'a') */
   /* search207_0_0 -> 29 in the cache */
   /* search207_0_1 -> 48 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fadd,
      0, 1,
      { 29, 48 },
      0,
   } },
   /* search207_1_0 -> 29 in the cache */
   /* search207_1_1 -> 152 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fadd,
      1, 1,
      { 29, 152 },
      0,
   } },
   /* search207_2 -> 180 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      true,
      false,
      false,
      false,
      false,
      false,
      nir_op_flrp,
      -1, 2,
      { 649, 650, 180 },
      -1,
   } },

   /* replace207_0_0 -> 48 in the cache */
   /* replace207_0_1 -> 152 in the cache */
   /* replace207_0_2 -> 180 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_flrp,
      -1, 0,
      { 48, 152, 180 },
      -1,
   } },
   /* replace207_1 -> 29 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fadd,
      0, 1,
      { 652, 29 },
      -1,
   } },

   /* ('~flrp@32', 'a', ('fmul(is_used_once)', 'a', 'b'), 'c') => ('fmul', ('flrp', 1.0, 'b', 'c'), 'a') */
   /* search208_0 -> 29 in the cache */
   /* search208_1_0 -> 29 in the cache */
   /* search208_1_1 -> 48 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fmul,
      0, 1,
      { 29, 48 },
      0,
   } },
   /* search208_2 -> 152 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      true,
      false,
      false,
      false,
      false,
      false,
      nir_op_flrp,
      -1, 1,
      { 29, 654, 152 },
      -1,
   } },

   /* replace208_0_0 -> 264 in the cache */
   /* replace208_0_1 -> 48 in the cache */
   /* replace208_0_2 -> 152 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_flrp,
      -1, 0,
      { 264, 48, 152 },
      -1,
   } },
   /* replace208_1 -> 29 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fmul,
      0, 1,
      { 656, 29 },
      -1,
   } },

   /* ('~fadd@32', ('fmul', 'a', ('fadd', 1.0, ('fneg', 'c'))), ('fmul', 'b', 'c')) => ('flrp', 'a', 'b', 'c') */
   /* search209_0_0 -> 29 in the cache */
   /* search209_0_1_0 -> 264 in the cache */
   { .variable = {
      { nir_search_value_variable, 32 },
      1, /* c */
      false,
      nir_type_invalid,
      -1,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fneg,
      -1, 0,
      { 658 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fadd,
      2, 1,
      { 264, 659 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fmul,
      1, 2,
      { 29, 660 },
      -1,
   } },
   { .variable = {
      { nir_search_value_variable, 32 },
      2, /* b */
      false,
      nir_type_invalid,
      -1,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   /* search209_1_1 -> 658 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fmul,
      3, 1,
      { 662, 658 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      true,
      false,
      false,
      false,
      false,
      false,
      nir_op_fadd,
      0, 4,
      { 661, 663 },
      -1,
   } },

   /* replace209_0 -> 29 in the cache */
   /* replace209_1 -> 662 in the cache */
   /* replace209_2 -> 658 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_flrp,
      -1, 0,
      { 29, 662, 658 },
      -1,
   } },

   /* ('~fadd@32', ('fmul', 'a', ('fsat', ('fadd', 1.0, ('fneg', 'c')))), ('fmul', 'b', ('fsat', 'c'))) => ('flrp', 'a', 'b', ('fsat', 'c')) */
   /* search210_0_0 -> 29 in the cache */
   /* search210_0_1_0_0 -> 264 in the cache */
   /* search210_0_1_0_1_0 -> 658 in the cache */
   /* search210_0_1_0_1 -> 659 in the cache */
   /* search210_0_1_0 -> 660 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fsat,
      -1, 1,
      { 660 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fmul,
      1, 2,
      { 29, 666 },
      -1,
   } },
   /* search210_1_0 -> 662 in the cache */
   /* search210_1_1_0 -> 658 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fsat,
      -1, 0,
      { 658 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fmul,
      3, 1,
      { 662, 668 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      true,
      false,
      false,
      false,
      false,
      false,
      nir_op_fadd,
      0, 4,
      { 667, 669 },
      -1,
   } },

   /* replace210_0 -> 29 in the cache */
   /* replace210_1 -> 662 in the cache */
   /* replace210_2_0 -> 658 in the cache */
   /* replace210_2 -> 668 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_flrp,
      -1, 0,
      { 29, 662, 668 },
      -1,
   } },

   /* ('~fadd@32', 'a', ('fmul', 'c', ('fadd', 'b', ('fneg', 'a')))) => ('flrp', 'a', 'b', 'c') */
   /* search211_0 -> 29 in the cache */
   /* search211_1_0 -> 658 in the cache */
   /* search211_1_1_0 -> 662 in the cache */
   /* search211_1_1_1_0 -> 29 in the cache */
   /* search211_1_1_1 -> 296 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fadd,
      2, 1,
      { 662, 296 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fmul,
      1, 2,
      { 658, 672 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      true,
      false,
      false,
      false,
      false,
      false,
      nir_op_fadd,
      0, 3,
      { 29, 673 },
      -1,
   } },

   /* replace211_0 -> 29 in the cache */
   /* replace211_1 -> 662 in the cache */
   /* replace211_2 -> 658 in the cache */
   /* replace211 -> 665 in the cache */

   /* ('~fadd@32', ('fmul', 'a', ('fadd', 1.0, ('fneg', ('b2f', 'c@1')))), ('fmul', 'b', ('b2f', 'c'))) => ('bcsel', 'c', 'b', 'a') */
   /* search212_0_0 -> 29 in the cache */
   /* search212_0_1_0 -> 264 in the cache */
   /* search212_0_1_1_0_0 -> 605 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_search_op_b2f,
      -1, 0,
      { 605 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fneg,
      -1, 0,
      { 675 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fadd,
      2, 1,
      { 264, 676 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fmul,
      1, 2,
      { 29, 677 },
      -1,
   } },
   /* search212_1_0 -> 662 in the cache */
   /* search212_1_1_0 -> 605 in the cache */
   /* search212_1_1 -> 675 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fmul,
      3, 1,
      { 662, 675 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      true,
      false,
      false,
      false,
      false,
      false,
      nir_op_fadd,
      0, 4,
      { 678, 679 },
      -1,
   } },

   /* replace212_0 -> 605 in the cache */
   /* replace212_1 -> 662 in the cache */
   /* replace212_2 -> 29 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_bcsel,
      -1, 0,
      { 605, 662, 29 },
      -1,
   } },

   /* ('~fadd@32', 'a', ('fmul', ('b2f', 'c@1'), ('fadd', 'b', ('fneg', 'a')))) => ('bcsel', 'c', 'b', 'a') */
   /* search213_0 -> 29 in the cache */
   /* search213_1_0_0 -> 605 in the cache */
   /* search213_1_0 -> 675 in the cache */
   /* search213_1_1_0 -> 662 in the cache */
   /* search213_1_1_1_0 -> 29 in the cache */
   /* search213_1_1_1 -> 296 in the cache */
   /* search213_1_1 -> 672 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fmul,
      1, 2,
      { 675, 672 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      true,
      false,
      false,
      false,
      false,
      false,
      nir_op_fadd,
      0, 3,
      { 29, 682 },
      -1,
   } },

   /* replace213_0 -> 605 in the cache */
   /* replace213_1 -> 662 in the cache */
   /* replace213_2 -> 29 in the cache */
   /* replace213 -> 681 in the cache */

   /* ('~ffma@32', 'a', ('fadd', 1.0, ('fneg', ('b2f', 'c@1'))), ('fmul', 'b', ('b2f', 'c@1'))) => ('bcsel', 'c', 'b', 'a') */
   /* search214_0 -> 29 in the cache */
   /* search214_1_0 -> 264 in the cache */
   /* search214_1_1_0_0 -> 605 in the cache */
   /* search214_1_1_0 -> 675 in the cache */
   /* search214_1_1 -> 676 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fadd,
      1, 1,
      { 264, 676 },
      -1,
   } },
   /* search214_2_0 -> 662 in the cache */
   /* search214_2_1_0 -> 605 in the cache */
   /* search214_2_1 -> 675 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fmul,
      2, 1,
      { 662, 675 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      true,
      false,
      false,
      false,
      false,
      false,
      nir_op_ffma,
      0, 3,
      { 29, 684, 685 },
      -1,
   } },

   /* replace214_0 -> 605 in the cache */
   /* replace214_1 -> 662 in the cache */
   /* replace214_2 -> 29 in the cache */
   /* replace214 -> 681 in the cache */

   /* ('~ffma@32', 'b', ('b2f', 'c@1'), ('ffma', ('fneg', 'a'), ('b2f', 'c@1'), 'a')) => ('bcsel', 'c', 'b', 'a') */
   /* search215_0 -> 389 in the cache */
   /* search215_1_0 -> 605 in the cache */
   /* search215_1 -> 675 in the cache */
   { .variable = {
      { nir_search_value_variable, 32 },
      2, /* a */
      false,
      nir_type_invalid,
      -1,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fneg,
      -1, 0,
      { 687 },
      -1,
   } },
   /* search215_2_1_0 -> 605 in the cache */
   /* search215_2_1 -> 675 in the cache */
   /* search215_2_2 -> 687 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ffma,
      1, 1,
      { 688, 675, 687 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      true,
      false,
      false,
      false,
      false,
      false,
      nir_op_ffma,
      0, 2,
      { 389, 675, 689 },
      -1,
   } },

   /* replace215_0 -> 605 in the cache */
   /* replace215_1 -> 389 in the cache */
   /* replace215_2 -> 687 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_bcsel,
      -1, 0,
      { 605, 389, 687 },
      -1,
   } },

   /* ('~ffma@32', ('b2f', 'c@1'), ('fadd', 'b', ('fneg', 'a')), 'a') => ('bcsel', 'c', 'b', 'a') */
   /* search216_0_0 -> 624 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_search_op_b2f,
      -1, 0,
      { 624 },
      -1,
   } },
   /* search216_1_0 -> 48 in the cache */
   /* search216_1_1_0 -> 687 in the cache */
   /* search216_1_1 -> 688 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fadd,
      1, 1,
      { 48, 688 },
      -1,
   } },
   /* search216_2 -> 687 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      true,
      false,
      false,
      false,
      false,
      false,
      nir_op_ffma,
      0, 2,
      { 692, 693, 687 },
      -1,
   } },

   /* replace216_0 -> 624 in the cache */
   /* replace216_1 -> 48 in the cache */
   /* replace216_2 -> 687 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_bcsel,
      -1, 0,
      { 624, 48, 687 },
      -1,
   } },

   /* ('~ffma@32', ('b2f', 'c@1'), ('ffma', ('fneg', 'a'), 'b', 'd'), ('fmul', 'a', 'b')) => ('bcsel', 'c', 'd', ('fmul', 'a', 'b')) */
   /* search217_0_0 -> 624 in the cache */
   /* search217_0 -> 692 in the cache */
   /* search217_1_0_0 -> 200 in the cache */
   /* search217_1_0 -> 417 in the cache */
   /* search217_1_1 -> 662 in the cache */
   /* search217_1_2 -> 180 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ffma,
      1, 1,
      { 417, 662, 180 },
      -1,
   } },
   /* search217_2_0 -> 200 in the cache */
   /* search217_2_1 -> 662 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fmul,
      2, 1,
      { 200, 662 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      true,
      false,
      false,
      false,
      false,
      false,
      nir_op_ffma,
      0, 3,
      { 692, 696, 697 },
      -1,
   } },

   /* replace217_0 -> 624 in the cache */
   /* replace217_1 -> 180 in the cache */
   /* replace217_2_0 -> 200 in the cache */
   /* replace217_2_1 -> 662 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fmul,
      0, 1,
      { 200, 662 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_bcsel,
      -1, 1,
      { 624, 180, 699 },
      -1,
   } },

   /* ('~fadd@32', 1.0, ('fneg', ('fmul', ('fadd', 1.0, ('fneg', 'a')), ('fadd', 1.0, ('fneg', 'b'))))) => ('flrp', 'b', 1.0, 'a') */
   /* search218_0 -> 264 in the cache */
   /* search218_1_0_0_0 -> 264 in the cache */
   /* search218_1_0_0_1_0 -> 29 in the cache */
   /* search218_1_0_0_1 -> 296 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fadd,
      2, 1,
      { 264, 296 },
      -1,
   } },
   /* search218_1_0_1_0 -> 264 in the cache */
   /* search218_1_0_1_1_0 -> 48 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fneg,
      -1, 0,
      { 48 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fadd,
      3, 1,
      { 264, 702 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fmul,
      1, 3,
      { 701, 703 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fneg,
      -1, 3,
      { 704 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      true,
      false,
      false,
      false,
      false,
      false,
      nir_op_fadd,
      0, 4,
      { 264, 705 },
      -1,
   } },

   /* replace218_0 -> 48 in the cache */
   /* replace218_1 -> 264 in the cache */
   /* replace218_2 -> 29 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_flrp,
      -1, 0,
      { 48, 264, 29 },
      -1,
   } },

   /* ('~flrp@64', 'a', 'b', ('b2f', 'c@1')) => ('bcsel', 'c', 'b', 'a') */
   /* search219_0 -> 34 in the cache */
   /* search219_1 -> 53 in the cache */
   /* search219_2_0 -> 567 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_search_op_b2f,
      -1, 0,
      { 567 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 64 },
      true,
      false,
      false,
      false,
      false,
      false,
      nir_op_flrp,
      -1, 0,
      { 34, 53, 708 },
      -1,
   } },

   /* replace219_0 -> 567 in the cache */
   /* replace219_1 -> 53 in the cache */
   /* replace219_2 -> 34 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_bcsel,
      -1, 0,
      { 567, 53, 34 },
      -1,
   } },

   /* ('~flrp@64', 'a', ('fadd', 'a', 'b'), 'c') => ('fadd', ('fmul', 'b', 'c'), 'a') */
   /* search220_0 -> 34 in the cache */
   /* search220_1_0 -> 34 in the cache */
   /* search220_1_1 -> 53 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fadd,
      0, 1,
      { 34, 53 },
      -1,
   } },
   { .variable = {
      { nir_search_value_variable, 64 },
      2, /* c */
      false,
      nir_type_invalid,
      -1,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .expression = {
      { nir_search_value_expression, 64 },
      true,
      false,
      false,
      false,
      false,
      false,
      nir_op_flrp,
      -1, 1,
      { 34, 711, 712 },
      -1,
   } },

   /* replace220_0_0 -> 53 in the cache */
   /* replace220_0_1 -> 712 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fmul,
      1, 1,
      { 53, 712 },
      -1,
   } },
   /* replace220_1 -> 34 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fadd,
      0, 2,
      { 714, 34 },
      -1,
   } },

   /* ('~flrp@64', ('fadd(is_used_once)', 'a', 'b'), ('fadd(is_used_once)', 'a', 'c'), 'd') => ('fadd', ('flrp', 'b', 'c', 'd'), 'a') */
   /* search221_0_0 -> 34 in the cache */
   /* search221_0_1 -> 53 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fadd,
      0, 1,
      { 34, 53 },
      0,
   } },
   /* search221_1_0 -> 34 in the cache */
   /* search221_1_1 -> 712 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fadd,
      1, 1,
      { 34, 712 },
      0,
   } },
   { .variable = {
      { nir_search_value_variable, 64 },
      3, /* d */
      false,
      nir_type_invalid,
      -1,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .expression = {
      { nir_search_value_expression, 64 },
      true,
      false,
      false,
      false,
      false,
      false,
      nir_op_flrp,
      -1, 2,
      { 716, 717, 718 },
      -1,
   } },

   /* replace221_0_0 -> 53 in the cache */
   /* replace221_0_1 -> 712 in the cache */
   /* replace221_0_2 -> 718 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_flrp,
      -1, 0,
      { 53, 712, 718 },
      -1,
   } },
   /* replace221_1 -> 34 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fadd,
      0, 1,
      { 720, 34 },
      -1,
   } },

   /* ('~flrp@64', 'a', ('fmul(is_used_once)', 'a', 'b'), 'c') => ('fmul', ('flrp', 1.0, 'b', 'c'), 'a') */
   /* search222_0 -> 34 in the cache */
   /* search222_1_0 -> 34 in the cache */
   /* search222_1_1 -> 53 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fmul,
      0, 1,
      { 34, 53 },
      0,
   } },
   /* search222_2 -> 712 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      true,
      false,
      false,
      false,
      false,
      false,
      nir_op_flrp,
      -1, 1,
      { 34, 722, 712 },
      -1,
   } },

   { .constant = {
      { nir_search_value_constant, 64 },
      nir_type_float, { 0x3ff0000000000000ull /* 1.0 */ },
   } },
   /* replace222_0_1 -> 53 in the cache */
   /* replace222_0_2 -> 712 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_flrp,
      -1, 0,
      { 724, 53, 712 },
      -1,
   } },
   /* replace222_1 -> 34 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fmul,
      0, 1,
      { 725, 34 },
      -1,
   } },

   /* ('~fadd@64', ('fmul', 'a', ('fadd', 1.0, ('fneg', 'c'))), ('fmul', 'b', 'c')) => ('flrp', 'a', 'b', 'c') */
   /* search223_0_0 -> 34 in the cache */
   /* search223_0_1_0 -> 724 in the cache */
   { .variable = {
      { nir_search_value_variable, 64 },
      1, /* c */
      false,
      nir_type_invalid,
      -1,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fneg,
      -1, 0,
      { 727 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fadd,
      2, 1,
      { 724, 728 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fmul,
      1, 2,
      { 34, 729 },
      -1,
   } },
   { .variable = {
      { nir_search_value_variable, 64 },
      2, /* b */
      false,
      nir_type_invalid,
      -1,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   /* search223_1_1 -> 727 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fmul,
      3, 1,
      { 731, 727 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 64 },
      true,
      false,
      false,
      false,
      false,
      false,
      nir_op_fadd,
      0, 4,
      { 730, 732 },
      -1,
   } },

   /* replace223_0 -> 34 in the cache */
   /* replace223_1 -> 731 in the cache */
   /* replace223_2 -> 727 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_flrp,
      -1, 0,
      { 34, 731, 727 },
      -1,
   } },

   /* ('~fadd@64', ('fmul', 'a', ('fsat', ('fadd', 1.0, ('fneg', 'c')))), ('fmul', 'b', ('fsat', 'c'))) => ('flrp', 'a', 'b', ('fsat', 'c')) */
   /* search224_0_0 -> 34 in the cache */
   /* search224_0_1_0_0 -> 724 in the cache */
   /* search224_0_1_0_1_0 -> 727 in the cache */
   /* search224_0_1_0_1 -> 728 in the cache */
   /* search224_0_1_0 -> 729 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fsat,
      -1, 1,
      { 729 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fmul,
      1, 2,
      { 34, 735 },
      -1,
   } },
   /* search224_1_0 -> 731 in the cache */
   /* search224_1_1_0 -> 727 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fsat,
      -1, 0,
      { 727 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fmul,
      3, 1,
      { 731, 737 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 64 },
      true,
      false,
      false,
      false,
      false,
      false,
      nir_op_fadd,
      0, 4,
      { 736, 738 },
      -1,
   } },

   /* replace224_0 -> 34 in the cache */
   /* replace224_1 -> 731 in the cache */
   /* replace224_2_0 -> 727 in the cache */
   /* replace224_2 -> 737 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_flrp,
      -1, 0,
      { 34, 731, 737 },
      -1,
   } },

   /* ('~fadd@64', 'a', ('fmul', 'c', ('fadd', 'b', ('fneg', 'a')))) => ('flrp', 'a', 'b', 'c') */
   /* search225_0 -> 34 in the cache */
   /* search225_1_0 -> 727 in the cache */
   /* search225_1_1_0 -> 731 in the cache */
   /* search225_1_1_1_0 -> 34 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fneg,
      -1, 0,
      { 34 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fadd,
      2, 1,
      { 731, 741 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fmul,
      1, 2,
      { 727, 742 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 64 },
      true,
      false,
      false,
      false,
      false,
      false,
      nir_op_fadd,
      0, 3,
      { 34, 743 },
      -1,
   } },

   /* replace225_0 -> 34 in the cache */
   /* replace225_1 -> 731 in the cache */
   /* replace225_2 -> 727 in the cache */
   /* replace225 -> 734 in the cache */

   /* ('~fadd@64', ('fmul', 'a', ('fadd', 1.0, ('fneg', ('b2f', 'c@1')))), ('fmul', 'b', ('b2f', 'c'))) => ('bcsel', 'c', 'b', 'a') */
   /* search226_0_0 -> 34 in the cache */
   /* search226_0_1_0 -> 724 in the cache */
   /* search226_0_1_1_0_0 -> 605 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_search_op_b2f,
      -1, 0,
      { 605 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fneg,
      -1, 0,
      { 745 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fadd,
      2, 1,
      { 724, 746 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fmul,
      1, 2,
      { 34, 747 },
      -1,
   } },
   /* search226_1_0 -> 731 in the cache */
   /* search226_1_1_0 -> 605 in the cache */
   /* search226_1_1 -> 745 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fmul,
      3, 1,
      { 731, 745 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 64 },
      true,
      false,
      false,
      false,
      false,
      false,
      nir_op_fadd,
      0, 4,
      { 748, 749 },
      -1,
   } },

   /* replace226_0 -> 605 in the cache */
   /* replace226_1 -> 731 in the cache */
   /* replace226_2 -> 34 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_bcsel,
      -1, 0,
      { 605, 731, 34 },
      -1,
   } },

   /* ('~fadd@64', 'a', ('fmul', ('b2f', 'c@1'), ('fadd', 'b', ('fneg', 'a')))) => ('bcsel', 'c', 'b', 'a') */
   /* search227_0 -> 34 in the cache */
   /* search227_1_0_0 -> 605 in the cache */
   /* search227_1_0 -> 745 in the cache */
   /* search227_1_1_0 -> 731 in the cache */
   /* search227_1_1_1_0 -> 34 in the cache */
   /* search227_1_1_1 -> 741 in the cache */
   /* search227_1_1 -> 742 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fmul,
      1, 2,
      { 745, 742 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 64 },
      true,
      false,
      false,
      false,
      false,
      false,
      nir_op_fadd,
      0, 3,
      { 34, 752 },
      -1,
   } },

   /* replace227_0 -> 605 in the cache */
   /* replace227_1 -> 731 in the cache */
   /* replace227_2 -> 34 in the cache */
   /* replace227 -> 751 in the cache */

   /* ('~ffma@64', 'a', ('fadd', 1.0, ('fneg', ('b2f', 'c@1'))), ('fmul', 'b', ('b2f', 'c@1'))) => ('bcsel', 'c', 'b', 'a') */
   /* search228_0 -> 34 in the cache */
   /* search228_1_0 -> 724 in the cache */
   /* search228_1_1_0_0 -> 605 in the cache */
   /* search228_1_1_0 -> 745 in the cache */
   /* search228_1_1 -> 746 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fadd,
      1, 1,
      { 724, 746 },
      -1,
   } },
   /* search228_2_0 -> 731 in the cache */
   /* search228_2_1_0 -> 605 in the cache */
   /* search228_2_1 -> 745 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fmul,
      2, 1,
      { 731, 745 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 64 },
      true,
      false,
      false,
      false,
      false,
      false,
      nir_op_ffma,
      0, 3,
      { 34, 754, 755 },
      -1,
   } },

   /* replace228_0 -> 605 in the cache */
   /* replace228_1 -> 731 in the cache */
   /* replace228_2 -> 34 in the cache */
   /* replace228 -> 751 in the cache */

   /* ('~ffma@64', 'b', ('b2f', 'c@1'), ('ffma', ('fneg', 'a'), ('b2f', 'c@1'), 'a')) => ('bcsel', 'c', 'b', 'a') */
   { .variable = {
      { nir_search_value_variable, 64 },
      0, /* b */
      false,
      nir_type_invalid,
      -1,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   /* search229_1_0 -> 605 in the cache */
   /* search229_1 -> 745 in the cache */
   { .variable = {
      { nir_search_value_variable, 64 },
      2, /* a */
      false,
      nir_type_invalid,
      -1,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fneg,
      -1, 0,
      { 758 },
      -1,
   } },
   /* search229_2_1_0 -> 605 in the cache */
   /* search229_2_1 -> 745 in the cache */
   /* search229_2_2 -> 758 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ffma,
      1, 1,
      { 759, 745, 758 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 64 },
      true,
      false,
      false,
      false,
      false,
      false,
      nir_op_ffma,
      0, 2,
      { 757, 745, 760 },
      -1,
   } },

   /* replace229_0 -> 605 in the cache */
   /* replace229_1 -> 757 in the cache */
   /* replace229_2 -> 758 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_bcsel,
      -1, 0,
      { 605, 757, 758 },
      -1,
   } },

   /* ('~ffma@64', ('b2f', 'c@1'), ('fadd', 'b', ('fneg', 'a')), 'a') => ('bcsel', 'c', 'b', 'a') */
   /* search230_0_0 -> 624 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_search_op_b2f,
      -1, 0,
      { 624 },
      -1,
   } },
   /* search230_1_0 -> 53 in the cache */
   /* search230_1_1_0 -> 758 in the cache */
   /* search230_1_1 -> 759 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fadd,
      1, 1,
      { 53, 759 },
      -1,
   } },
   /* search230_2 -> 758 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      true,
      false,
      false,
      false,
      false,
      false,
      nir_op_ffma,
      0, 2,
      { 763, 764, 758 },
      -1,
   } },

   /* replace230_0 -> 624 in the cache */
   /* replace230_1 -> 53 in the cache */
   /* replace230_2 -> 758 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_bcsel,
      -1, 0,
      { 624, 53, 758 },
      -1,
   } },

   /* ('~ffma@64', ('b2f', 'c@1'), ('ffma', ('fneg', 'a'), 'b', 'd'), ('fmul', 'a', 'b')) => ('bcsel', 'c', 'd', ('fmul', 'a', 'b')) */
   /* search231_0_0 -> 624 in the cache */
   /* search231_0 -> 763 in the cache */
   { .variable = {
      { nir_search_value_variable, 64 },
      1, /* a */
      false,
      nir_type_invalid,
      -1,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fneg,
      -1, 0,
      { 767 },
      -1,
   } },
   /* search231_1_1 -> 731 in the cache */
   /* search231_1_2 -> 718 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ffma,
      1, 1,
      { 768, 731, 718 },
      -1,
   } },
   /* search231_2_0 -> 767 in the cache */
   /* search231_2_1 -> 731 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fmul,
      2, 1,
      { 767, 731 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 64 },
      true,
      false,
      false,
      false,
      false,
      false,
      nir_op_ffma,
      0, 3,
      { 763, 769, 770 },
      -1,
   } },

   /* replace231_0 -> 624 in the cache */
   /* replace231_1 -> 718 in the cache */
   /* replace231_2_0 -> 767 in the cache */
   /* replace231_2_1 -> 731 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fmul,
      0, 1,
      { 767, 731 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_bcsel,
      -1, 1,
      { 624, 718, 772 },
      -1,
   } },

   /* ('~fadd@64', 1.0, ('fneg', ('fmul', ('fadd', 1.0, ('fneg', 'a')), ('fadd', 1.0, ('fneg', 'b'))))) => ('flrp', 'b', 1.0, 'a') */
   /* search232_0 -> 724 in the cache */
   /* search232_1_0_0_0 -> 724 in the cache */
   /* search232_1_0_0_1_0 -> 34 in the cache */
   /* search232_1_0_0_1 -> 741 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fadd,
      2, 1,
      { 724, 741 },
      -1,
   } },
   /* search232_1_0_1_0 -> 724 in the cache */
   /* search232_1_0_1_1_0 -> 53 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fneg,
      -1, 0,
      { 53 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fadd,
      3, 1,
      { 724, 775 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fmul,
      1, 3,
      { 774, 776 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fneg,
      -1, 3,
      { 777 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 64 },
      true,
      false,
      false,
      false,
      false,
      false,
      nir_op_fadd,
      0, 4,
      { 724, 778 },
      -1,
   } },

   /* replace232_0 -> 53 in the cache */
   /* replace232_1 -> 724 in the cache */
   /* replace232_2 -> 34 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_flrp,
      -1, 0,
      { 53, 724, 34 },
      -1,
   } },

   /* ('~flrp', ('fmul(is_used_once)', 'a', 'b'), ('fmul(is_used_once)', 'a', 'c'), 'd') => ('fmul', ('flrp', 'b', 'c', 'd'), 'a') */
   /* search233_0_0 -> 166 in the cache */
   /* search233_0_1 -> 167 in the cache */
   { .expression = {
      { nir_search_value_expression, -4 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fmul,
      0, 1,
      { 166, 167 },
      0,
   } },
   /* search233_1_0 -> 166 in the cache */
   /* search233_1_1 -> 169 in the cache */
   { .expression = {
      { nir_search_value_expression, -4 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fmul,
      1, 1,
      { 166, 169 },
      0,
   } },
   /* search233_2 -> 170 in the cache */
   { .expression = {
      { nir_search_value_expression, -4 },
      true,
      false,
      false,
      false,
      false,
      false,
      nir_op_flrp,
      -1, 2,
      { 781, 782, 170 },
      -1,
   } },

   /* replace233_0_0 -> 167 in the cache */
   /* replace233_0_1 -> 169 in the cache */
   /* replace233_0_2 -> 170 in the cache */
   { .expression = {
      { nir_search_value_expression, -4 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_flrp,
      -1, 0,
      { 167, 169, 170 },
      -1,
   } },
   /* replace233_1 -> 166 in the cache */
   { .expression = {
      { nir_search_value_expression, -4 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fmul,
      0, 1,
      { 784, 166 },
      -1,
   } },

   /* ('~flrp', 'a', 0.0, 'c') => ('fadd', ('fmul', ('fneg', 'a'), 'c'), 'a') */
   /* search234_0 -> 0 in the cache */
   /* search234_1 -> 276 in the cache */
   { .variable = {
      { nir_search_value_variable, -2 },
      1, /* c */
      false,
      nir_type_invalid,
      -1,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .expression = {
      { nir_search_value_expression, -2 },
      true,
      false,
      false,
      false,
      false,
      false,
      nir_op_flrp,
      -1, 0,
      { 0, 276, 786 },
      -1,
   } },

   /* replace234_0_0_0 -> 0 in the cache */
   /* replace234_0_0 -> 132 in the cache */
   /* replace234_0_1 -> 786 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fmul,
      1, 1,
      { 132, 786 },
      -1,
   } },
   /* replace234_1 -> 0 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fadd,
      0, 2,
      { 788, 0 },
      -1,
   } },

   /* ('ftrunc@16', 'a') => ('bcsel', ('flt', 'a', 0.0), ('fneg', ('ffloor', ('fabs', 'a'))), ('ffloor', ('fabs', 'a'))) */
   /* search235_0 -> 24 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ftrunc,
      -1, 0,
      { 24 },
      -1,
   } },

   /* replace235_0_0 -> 24 in the cache */
   { .constant = {
      { nir_search_value_constant, 16 },
      nir_type_float, { 0x0ull /* 0.0 */ },
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_flt,
      -1, 0,
      { 24, 791 },
      -1,
   } },
   /* replace235_1_0_0_0 -> 24 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fabs,
      -1, 0,
      { 24 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ffloor,
      -1, 0,
      { 793 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fneg,
      -1, 0,
      { 794 },
      -1,
   } },
   /* replace235_2_0_0 -> 24 in the cache */
   /* replace235_2_0 -> 793 in the cache */
   /* replace235_2 -> 794 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_bcsel,
      -1, 0,
      { 792, 795, 794 },
      -1,
   } },

   /* ('ftrunc@32', 'a') => ('bcsel', ('flt', 'a', 0.0), ('fneg', ('ffloor', ('fabs', 'a'))), ('ffloor', ('fabs', 'a'))) */
   /* search236_0 -> 29 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ftrunc,
      -1, 0,
      { 29 },
      -1,
   } },

   /* replace236_0_0 -> 29 in the cache */
   /* replace236_0_1 -> 244 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_flt,
      -1, 0,
      { 29, 244 },
      -1,
   } },
   /* replace236_1_0_0_0 -> 29 in the cache */
   /* replace236_1_0_0 -> 426 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ffloor,
      -1, 0,
      { 426 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fneg,
      -1, 0,
      { 799 },
      -1,
   } },
   /* replace236_2_0_0 -> 29 in the cache */
   /* replace236_2_0 -> 426 in the cache */
   /* replace236_2 -> 799 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_bcsel,
      -1, 0,
      { 798, 800, 799 },
      -1,
   } },

   /* ('ftrunc@64', 'a') => ('bcsel', ('flt', 'a', 0.0), ('fneg', ('ffloor', ('fabs', 'a'))), ('ffloor', ('fabs', 'a'))) */
   /* search237_0 -> 34 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ftrunc,
      -1, 0,
      { 34 },
      -1,
   } },

   /* replace237_0_0 -> 34 in the cache */
   { .constant = {
      { nir_search_value_constant, 64 },
      nir_type_float, { 0x0ull /* 0.0 */ },
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_flt,
      -1, 0,
      { 34, 803 },
      -1,
   } },
   /* replace237_1_0_0_0 -> 34 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fabs,
      -1, 0,
      { 34 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ffloor,
      -1, 0,
      { 805 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fneg,
      -1, 0,
      { 806 },
      -1,
   } },
   /* replace237_2_0_0 -> 34 in the cache */
   /* replace237_2_0 -> 805 in the cache */
   /* replace237_2 -> 806 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_bcsel,
      -1, 0,
      { 804, 807, 806 },
      -1,
   } },

   /* ('ffloor@16', 'a') => ('fsub', 'a', ('ffract', 'a')) */
   /* search238_0 -> 24 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ffloor,
      -1, 0,
      { 24 },
      -1,
   } },

   /* replace238_0 -> 24 in the cache */
   /* replace238_1_0 -> 24 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ffract,
      -1, 0,
      { 24 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fsub,
      -1, 0,
      { 24, 810 },
      -1,
   } },

   /* ('ffloor@32', 'a') => ('fsub', 'a', ('ffract', 'a')) */
   /* search239_0 -> 29 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ffloor,
      -1, 0,
      { 29 },
      -1,
   } },

   /* replace239_0 -> 29 in the cache */
   /* replace239_1_0 -> 29 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ffract,
      -1, 0,
      { 29 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fsub,
      -1, 0,
      { 29, 813 },
      -1,
   } },

   /* ('ffloor@64', 'a') => ('fsub', 'a', ('ffract', 'a')) */
   /* search240_0 -> 34 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ffloor,
      -1, 0,
      { 34 },
      -1,
   } },

   /* replace240_0 -> 34 in the cache */
   /* replace240_1_0 -> 34 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ffract,
      -1, 0,
      { 34 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fsub,
      -1, 0,
      { 34, 816 },
      -1,
   } },

   /* ('fadd@16', 'a', ('fadd@16', 'b', ('fneg', ('ffract', 'a')))) => ('fadd@16', 'b', ('ffloor', 'a')) */
   /* search241_0 -> 24 in the cache */
   /* search241_1_0 -> 566 in the cache */
   /* search241_1_1_0_0 -> 24 in the cache */
   /* search241_1_1_0 -> 810 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fneg,
      -1, 0,
      { 810 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fadd,
      1, 1,
      { 566, 818 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fadd,
      0, 2,
      { 24, 819 },
      -1,
   } },

   /* replace241_0 -> 566 in the cache */
   /* replace241_1_0 -> 24 in the cache */
   /* replace241_1 -> 809 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fadd,
      0, 1,
      { 566, 809 },
      -1,
   } },

   /* ('fadd@32', 'a', ('fadd@32', 'b', ('fneg', ('ffract', 'a')))) => ('fadd@32', 'b', ('ffloor', 'a')) */
   /* search242_0 -> 29 in the cache */
   /* search242_1_0 -> 48 in the cache */
   /* search242_1_1_0_0 -> 29 in the cache */
   /* search242_1_1_0 -> 813 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fneg,
      -1, 0,
      { 813 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fadd,
      1, 1,
      { 48, 822 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fadd,
      0, 2,
      { 29, 823 },
      -1,
   } },

   /* replace242_0 -> 48 in the cache */
   /* replace242_1_0 -> 29 in the cache */
   /* replace242_1 -> 812 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fadd,
      0, 1,
      { 48, 812 },
      -1,
   } },

   /* ('fadd@64', 'a', ('fadd@64', 'b', ('fneg', ('ffract', 'a')))) => ('fadd@64', 'b', ('ffloor', 'a')) */
   /* search243_0 -> 34 in the cache */
   /* search243_1_0 -> 53 in the cache */
   /* search243_1_1_0_0 -> 34 in the cache */
   /* search243_1_1_0 -> 816 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fneg,
      -1, 0,
      { 816 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fadd,
      1, 1,
      { 53, 826 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fadd,
      0, 2,
      { 34, 827 },
      -1,
   } },

   /* replace243_0 -> 53 in the cache */
   /* replace243_1_0 -> 34 in the cache */
   /* replace243_1 -> 815 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fadd,
      0, 1,
      { 53, 815 },
      -1,
   } },

   /* ('fadd@16', 'a', ('fneg', ('ffract', 'a'))) => ('ffloor', 'a') */
   /* search244_0 -> 24 in the cache */
   /* search244_1_0_0 -> 24 in the cache */
   /* search244_1_0 -> 810 in the cache */
   /* search244_1 -> 818 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fadd,
      0, 1,
      { 24, 818 },
      -1,
   } },

   /* replace244_0 -> 24 in the cache */
   /* replace244 -> 809 in the cache */

   /* ('fadd@32', 'a', ('fneg', ('ffract', 'a'))) => ('ffloor', 'a') */
   /* search245_0 -> 29 in the cache */
   /* search245_1_0_0 -> 29 in the cache */
   /* search245_1_0 -> 813 in the cache */
   /* search245_1 -> 822 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fadd,
      0, 1,
      { 29, 822 },
      -1,
   } },

   /* replace245_0 -> 29 in the cache */
   /* replace245 -> 812 in the cache */

   /* ('fadd@64', 'a', ('fneg', ('ffract', 'a'))) => ('ffloor', 'a') */
   /* search246_0 -> 34 in the cache */
   /* search246_1_0_0 -> 34 in the cache */
   /* search246_1_0 -> 816 in the cache */
   /* search246_1 -> 826 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fadd,
      0, 1,
      { 34, 826 },
      -1,
   } },

   /* replace246_0 -> 34 in the cache */
   /* replace246 -> 815 in the cache */

   /* ('ffract@16', 'a') => ('fsub', 'a', ('ffloor', 'a')) */
   /* search247_0 -> 24 in the cache */
   /* search247 -> 810 in the cache */

   /* replace247_0 -> 24 in the cache */
   /* replace247_1_0 -> 24 in the cache */
   /* replace247_1 -> 809 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fsub,
      -1, 0,
      { 24, 809 },
      -1,
   } },

   /* ('ffract@32', 'a') => ('fsub', 'a', ('ffloor', 'a')) */
   /* search248_0 -> 29 in the cache */
   /* search248 -> 813 in the cache */

   /* replace248_0 -> 29 in the cache */
   /* replace248_1_0 -> 29 in the cache */
   /* replace248_1 -> 812 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fsub,
      -1, 0,
      { 29, 812 },
      -1,
   } },

   /* ('ffract@64', 'a') => ('fsub', 'a', ('ffloor', 'a')) */
   /* search249_0 -> 34 in the cache */
   /* search249 -> 816 in the cache */

   /* replace249_0 -> 34 in the cache */
   /* replace249_1_0 -> 34 in the cache */
   /* replace249_1 -> 815 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fsub,
      -1, 0,
      { 34, 815 },
      -1,
   } },

   /* ('fceil', 'a') => ('fneg', ('ffloor', ('fneg', 'a'))) */
   /* search250_0 -> 9 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fceil,
      -1, 0,
      { 9 },
      -1,
   } },

   /* replace250_0_0_0 -> 9 in the cache */
   /* replace250_0_0 -> 118 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ffloor,
      -1, 0,
      { 118 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fneg,
      -1, 0,
      { 837 },
      -1,
   } },

   /* ('ffma@16', 'a', 'b', 'c') => ('fadd', ('fmul', 'a', 'b'), 'c') */
   /* search251_0 -> 24 in the cache */
   /* search251_1 -> 566 in the cache */
   /* search251_2 -> 572 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ffma,
      0, 1,
      { 24, 566, 572 },
      -1,
   } },

   /* replace251_0_0 -> 24 in the cache */
   /* replace251_0_1 -> 566 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fmul,
      1, 1,
      { 24, 566 },
      -1,
   } },
   /* replace251_1 -> 572 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fadd,
      0, 2,
      { 840, 572 },
      -1,
   } },

   /* ('ffma@32', 'a', 'b', 'c') => ('fadd', ('fmul', 'a', 'b'), 'c') */
   /* search252_0 -> 29 in the cache */
   /* search252_1 -> 48 in the cache */
   /* search252_2 -> 152 in the cache */
   /* search252 -> 255 in the cache */

   /* replace252_0_0 -> 29 in the cache */
   /* replace252_0_1 -> 48 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fmul,
      1, 1,
      { 29, 48 },
      -1,
   } },
   /* replace252_1 -> 152 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fadd,
      0, 2,
      { 842, 152 },
      -1,
   } },

   /* ('ffma@64', 'a', 'b', 'c') => ('fadd', ('fmul', 'a', 'b'), 'c') */
   /* search253_0 -> 34 in the cache */
   /* search253_1 -> 53 in the cache */
   /* search253_2 -> 712 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ffma,
      0, 1,
      { 34, 53, 712 },
      -1,
   } },

   /* replace253_0_0 -> 34 in the cache */
   /* replace253_0_1 -> 53 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fmul,
      1, 1,
      { 34, 53 },
      -1,
   } },
   /* replace253_1 -> 712 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fadd,
      0, 2,
      { 845, 712 },
      -1,
   } },

   /* ('ffmaz', 'a', 'b', 'c') => ('fadd', ('fmulz', 'a', 'b'), 'c') */
   /* search254_0 -> 29 in the cache */
   /* search254_1 -> 48 in the cache */
   /* search254_2 -> 152 in the cache */
   /* search254 -> 465 in the cache */

   /* replace254_0_0 -> 29 in the cache */
   /* replace254_0_1 -> 48 in the cache */
   /* replace254_0 -> 151 in the cache */
   /* replace254_1 -> 152 in the cache */
   /* replace254 -> 304 in the cache */

   /* ('~ffma@16', 'a', 'b', 'c') => ('fadd', ('fmul', 'a', 'b'), 'c') */
   /* search255_0 -> 24 in the cache */
   /* search255_1 -> 566 in the cache */
   /* search255_2 -> 572 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      true,
      false,
      false,
      false,
      false,
      false,
      nir_op_ffma,
      0, 1,
      { 24, 566, 572 },
      -1,
   } },

   /* replace255_0_0 -> 24 in the cache */
   /* replace255_0_1 -> 566 in the cache */
   /* replace255_0 -> 840 in the cache */
   /* replace255_1 -> 572 in the cache */
   /* replace255 -> 841 in the cache */

   /* ('~ffma@32', 'a', 'b', 'c') => ('fadd', ('fmul', 'a', 'b'), 'c') */
   /* search256_0 -> 29 in the cache */
   /* search256_1 -> 48 in the cache */
   /* search256_2 -> 152 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      true,
      false,
      false,
      false,
      false,
      false,
      nir_op_ffma,
      0, 1,
      { 29, 48, 152 },
      -1,
   } },

   /* replace256_0_0 -> 29 in the cache */
   /* replace256_0_1 -> 48 in the cache */
   /* replace256_0 -> 842 in the cache */
   /* replace256_1 -> 152 in the cache */
   /* replace256 -> 843 in the cache */

   /* ('~ffma@64', 'a', 'b', 'c') => ('fadd', ('fmul', 'a', 'b'), 'c') */
   /* search257_0 -> 34 in the cache */
   /* search257_1 -> 53 in the cache */
   /* search257_2 -> 712 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      true,
      false,
      false,
      false,
      false,
      false,
      nir_op_ffma,
      0, 1,
      { 34, 53, 712 },
      -1,
   } },

   /* replace257_0_0 -> 34 in the cache */
   /* replace257_0_1 -> 53 in the cache */
   /* replace257_0 -> 845 in the cache */
   /* replace257_1 -> 712 in the cache */
   /* replace257 -> 846 in the cache */

   /* ('~ffmaz', 'a', 'b', 'c') => ('fadd', ('fmulz', 'a', 'b'), 'c') */
   /* search258_0 -> 29 in the cache */
   /* search258_1 -> 48 in the cache */
   /* search258_2 -> 152 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      true,
      false,
      false,
      false,
      false,
      false,
      nir_op_ffmaz,
      0, 1,
      { 29, 48, 152 },
      -1,
   } },

   /* replace258_0_0 -> 29 in the cache */
   /* replace258_0_1 -> 48 in the cache */
   /* replace258_0 -> 151 in the cache */
   /* replace258_1 -> 152 in the cache */
   /* replace258 -> 304 in the cache */

   /* ('~fmul', ('fadd', ('iand', ('ineg', ('b2i', 'a@bool')), ('fmul', 'b', 'c')), '#d'), '#e') => ('bcsel', 'a', ('fmul', ('fadd', ('fmul', 'b', 'c'), 'd'), 'e'), ('fmul', 'd', 'e')) */
   { .variable = {
      { nir_search_value_variable, 1 },
      0, /* a */
      false,
      nir_type_bool,
      -1,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .expression = {
      { nir_search_value_expression, -5 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_search_op_b2i,
      -1, 0,
      { 851 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -5 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ineg,
      -1, 0,
      { 852 },
      -1,
   } },
   { .variable = {
      { nir_search_value_variable, -5 },
      1, /* b */
      false,
      nir_type_invalid,
      -1,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .variable = {
      { nir_search_value_variable, -5 },
      2, /* c */
      false,
      nir_type_invalid,
      -1,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .expression = {
      { nir_search_value_expression, -5 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fmul,
      3, 1,
      { 854, 855 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -5 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_iand,
      2, 2,
      { 853, 856 },
      -1,
   } },
   { .variable = {
      { nir_search_value_variable, -5 },
      3, /* d */
      true,
      nir_type_invalid,
      -1,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .expression = {
      { nir_search_value_expression, -5 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fadd,
      1, 3,
      { 857, 858 },
      -1,
   } },
   { .variable = {
      { nir_search_value_variable, -5 },
      4, /* e */
      true,
      nir_type_invalid,
      -1,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .expression = {
      { nir_search_value_expression, -5 },
      true,
      false,
      false,
      false,
      false,
      false,
      nir_op_fmul,
      0, 4,
      { 859, 860 },
      -1,
   } },

   { .variable = {
      { nir_search_value_variable, 1 },
      0, /* a */
      false,
      nir_type_invalid,
      -1,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   /* replace259_1_0_0_0 -> 854 in the cache */
   /* replace259_1_0_0_1 -> 855 in the cache */
   { .expression = {
      { nir_search_value_expression, -5 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fmul,
      2, 1,
      { 854, 855 },
      -1,
   } },
   { .variable = {
      { nir_search_value_variable, -5 },
      3, /* d */
      false,
      nir_type_invalid,
      -1,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .expression = {
      { nir_search_value_expression, -5 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fadd,
      1, 2,
      { 863, 864 },
      -1,
   } },
   { .variable = {
      { nir_search_value_variable, -5 },
      4, /* e */
      false,
      nir_type_invalid,
      -1,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .expression = {
      { nir_search_value_expression, -5 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fmul,
      0, 3,
      { 865, 866 },
      -1,
   } },
   /* replace259_2_0 -> 864 in the cache */
   /* replace259_2_1 -> 866 in the cache */
   { .expression = {
      { nir_search_value_expression, -5 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fmul,
      3, 1,
      { 864, 866 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -5 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_bcsel,
      -1, 4,
      { 862, 867, 868 },
      -1,
   } },

   /* ('fdph', 'a', 'b') => ('fdot4', ('vec4', 'a.x', 'a.y', 'a.z', 1.0), 'b') */
   /* search260_0 -> 0 in the cache */
   /* search260_1 -> 1 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fdph,
      -1, 0,
      { 0, 1 },
      -1,
   } },

   { .variable = {
      { nir_search_value_variable, -2 },
      0, /* a */
      false,
      nir_type_invalid,
      -1,
      {0},
   } },
   { .variable = {
      { nir_search_value_variable, -2 },
      0, /* a */
      false,
      nir_type_invalid,
      -1,
      {1},
   } },
   { .variable = {
      { nir_search_value_variable, -2 },
      0, /* a */
      false,
      nir_type_invalid,
      -1,
      {2},
   } },
   /* replace260_0_3 -> 286 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_vec4,
      -1, 0,
      { 871, 872, 873, 286 },
      -1,
   } },
   /* replace260_1 -> 1 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fdot4,
      0, 1,
      { 874, 1 },
      -1,
   } },

   /* ('fdot4', 'a', 0.0) => 0.0 */
   /* search261_0 -> 9 in the cache */
   /* search261_1 -> 8 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fdot4,
      0, 1,
      { 9, 8 },
      -1,
   } },

   /* replace261 -> 8 in the cache */

   /* ('fdot3', 'a', 0.0) => 0.0 */
   /* search262_0 -> 9 in the cache */
   /* search262_1 -> 8 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fdot3,
      0, 1,
      { 9, 8 },
      -1,
   } },

   /* replace262 -> 8 in the cache */

   /* ('fdot2', 'a', 0.0) => 0.0 */
   /* search263_0 -> 9 in the cache */
   /* search263_1 -> 8 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fdot2,
      0, 1,
      { 9, 8 },
      -1,
   } },

   /* replace263 -> 8 in the cache */

   /* ('fdot4', ('vec4', 'a', 'b', 'c', 1.0), 'd') => ('fdph', ('vec3', 'a', 'b', 'c'), 'd') */
   /* search264_0_0 -> 166 in the cache */
   /* search264_0_1 -> 167 in the cache */
   /* search264_0_2 -> 169 in the cache */
   { .constant = {
      { nir_search_value_constant, -4 },
      nir_type_float, { 0x3ff0000000000000ull /* 1.0 */ },
   } },
   { .expression = {
      { nir_search_value_expression, -4 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_vec4,
      -1, 0,
      { 166, 167, 169, 879 },
      -1,
   } },
   /* search264_1 -> 170 in the cache */
   { .expression = {
      { nir_search_value_expression, -4 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fdot4,
      0, 1,
      { 880, 170 },
      -1,
   } },

   /* replace264_0_0 -> 166 in the cache */
   /* replace264_0_1 -> 167 in the cache */
   /* replace264_0_2 -> 169 in the cache */
   { .expression = {
      { nir_search_value_expression, -4 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_vec3,
      -1, 0,
      { 166, 167, 169 },
      -1,
   } },
   /* replace264_1 -> 170 in the cache */
   { .expression = {
      { nir_search_value_expression, -4 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fdph,
      -1, 0,
      { 882, 170 },
      -1,
   } },

   /* ('fdot4', ('vec4', 'a', 0.0, 0.0, 0.0), 'b') => ('fmul', 'a', 'b') */
   /* search265_0_0 -> 0 in the cache */
   /* search265_0_1 -> 276 in the cache */
   /* search265_0_2 -> 276 in the cache */
   /* search265_0_3 -> 276 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_vec4,
      -1, 0,
      { 0, 276, 276, 276 },
      -1,
   } },
   /* search265_1 -> 1 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fdot4,
      0, 1,
      { 884, 1 },
      -1,
   } },

   /* replace265_0 -> 0 in the cache */
   /* replace265_1 -> 1 in the cache */
   /* replace265 -> 282 in the cache */

   /* ('fdot4', ('vec4', 'a', 'b', 0.0, 0.0), 'c') => ('fdot2', ('vec2', 'a', 'b'), 'c') */
   /* search266_0_0 -> 143 in the cache */
   /* search266_0_1 -> 144 in the cache */
   { .constant = {
      { nir_search_value_constant, -3 },
      nir_type_float, { 0x0ull /* 0.0 */ },
   } },
   /* search266_0_3 -> 886 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_vec4,
      -1, 0,
      { 143, 144, 886, 886 },
      -1,
   } },
   /* search266_1 -> 146 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fdot4,
      0, 1,
      { 887, 146 },
      -1,
   } },

   /* replace266_0_0 -> 143 in the cache */
   /* replace266_0_1 -> 144 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_vec2,
      -1, 0,
      { 143, 144 },
      -1,
   } },
   /* replace266_1 -> 146 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fdot2,
      0, 1,
      { 889, 146 },
      -1,
   } },

   /* ('fdot4', ('vec4', 'a', 'b', 'c', 0.0), 'd') => ('fdot3', ('vec3', 'a', 'b', 'c'), 'd') */
   /* search267_0_0 -> 166 in the cache */
   /* search267_0_1 -> 167 in the cache */
   /* search267_0_2 -> 169 in the cache */
   { .constant = {
      { nir_search_value_constant, -4 },
      nir_type_float, { 0x0ull /* 0.0 */ },
   } },
   { .expression = {
      { nir_search_value_expression, -4 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_vec4,
      -1, 0,
      { 166, 167, 169, 891 },
      -1,
   } },
   /* search267_1 -> 170 in the cache */
   { .expression = {
      { nir_search_value_expression, -4 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fdot4,
      0, 1,
      { 892, 170 },
      -1,
   } },

   /* replace267_0_0 -> 166 in the cache */
   /* replace267_0_1 -> 167 in the cache */
   /* replace267_0_2 -> 169 in the cache */
   /* replace267_0 -> 882 in the cache */
   /* replace267_1 -> 170 in the cache */
   { .expression = {
      { nir_search_value_expression, -4 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fdot3,
      0, 1,
      { 882, 170 },
      -1,
   } },

   /* ('fdot3', ('vec3', 'a', 0.0, 0.0), 'b') => ('fmul', 'a', 'b') */
   /* search268_0_0 -> 0 in the cache */
   /* search268_0_1 -> 276 in the cache */
   /* search268_0_2 -> 276 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_vec3,
      -1, 0,
      { 0, 276, 276 },
      -1,
   } },
   /* search268_1 -> 1 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fdot3,
      0, 1,
      { 895, 1 },
      -1,
   } },

   /* replace268_0 -> 0 in the cache */
   /* replace268_1 -> 1 in the cache */
   /* replace268 -> 282 in the cache */

   /* ('fdot3', ('vec3', 'a', 'b', 0.0), 'c') => ('fdot2', ('vec2', 'a', 'b'), 'c') */
   /* search269_0_0 -> 143 in the cache */
   /* search269_0_1 -> 144 in the cache */
   /* search269_0_2 -> 886 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_vec3,
      -1, 0,
      { 143, 144, 886 },
      -1,
   } },
   /* search269_1 -> 146 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fdot3,
      0, 1,
      { 897, 146 },
      -1,
   } },

   /* replace269_0_0 -> 143 in the cache */
   /* replace269_0_1 -> 144 in the cache */
   /* replace269_0 -> 889 in the cache */
   /* replace269_1 -> 146 in the cache */
   /* replace269 -> 890 in the cache */

   /* ('fdot2', ('vec2', 'a', 0.0), 'b') => ('fmul', 'a', 'b') */
   /* search270_0_0 -> 0 in the cache */
   /* search270_0_1 -> 276 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_vec2,
      -1, 0,
      { 0, 276 },
      -1,
   } },
   /* search270_1 -> 1 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fdot2,
      0, 1,
      { 899, 1 },
      -1,
   } },

   /* replace270_0 -> 0 in the cache */
   /* replace270_1 -> 1 in the cache */
   /* replace270 -> 282 in the cache */

   /* ('fdot2', 'a', 1.0) => ('fadd', 'a.x', 'a.y') */
   /* search271_0 -> 9 in the cache */
   /* search271_1 -> 262 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fdot2,
      0, 1,
      { 9, 262 },
      -1,
   } },

   { .variable = {
      { nir_search_value_variable, -1 },
      0, /* a */
      false,
      nir_type_invalid,
      -1,
      {0},
   } },
   { .variable = {
      { nir_search_value_variable, -1 },
      0, /* a */
      false,
      nir_type_invalid,
      -1,
      {1},
   } },
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fadd,
      -1, 0,
      { 902, 903 },
      -1,
   } },

   /* ('fdot2', 'a', 'b') => ('fsum2', ('fmul', 'a', 'b')) */
   /* search272_0 -> 0 in the cache */
   /* search272_1 -> 1 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fdot2,
      0, 1,
      { 0, 1 },
      -1,
   } },

   /* replace272_0_0 -> 0 in the cache */
   /* replace272_0_1 -> 1 in the cache */
   /* replace272_0 -> 282 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fsum2,
      -1, 1,
      { 282 },
      -1,
   } },

   /* ('fdot3', 'a', 'b') => ('fsum3', ('fmul', 'a', 'b')) */
   /* search273_0 -> 0 in the cache */
   /* search273_1 -> 1 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fdot3,
      0, 1,
      { 0, 1 },
      -1,
   } },

   /* replace273_0_0 -> 0 in the cache */
   /* replace273_0_1 -> 1 in the cache */
   /* replace273_0 -> 282 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fsum3,
      -1, 1,
      { 282 },
      -1,
   } },

   /* ('fdot4', 'a', 'b') => ('fsum4', ('fmul', 'a', 'b')) */
   /* search274_0 -> 0 in the cache */
   /* search274_1 -> 1 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fdot4,
      0, 1,
      { 0, 1 },
      -1,
   } },

   /* replace274_0_0 -> 0 in the cache */
   /* replace274_0_1 -> 1 in the cache */
   /* replace274_0 -> 282 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fsum4,
      -1, 1,
      { 282 },
      -1,
   } },

   /* ('fsum2', 'a') => ('fadd', 'a.x', 'a.y') */
   /* search275_0 -> 9 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fsum2,
      -1, 0,
      { 9 },
      -1,
   } },

   /* replace275_0 -> 902 in the cache */
   /* replace275_1 -> 903 in the cache */
   /* replace275 -> 904 in the cache */

   /* ('~fadd', ('fneg(is_used_once)', ('fsat(is_used_once)', 'a(is_not_fmul)')), 1.0) => ('fsat', ('fadd', 1.0, ('fneg', 'a'))) */
   { .variable = {
      { nir_search_value_variable, -1 },
      0, /* a */
      false,
      nir_type_invalid,
      9,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fsat,
      -1, 0,
      { 912 },
      0,
   } },
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fneg,
      -1, 0,
      { 913 },
      0,
   } },
   /* search276_1 -> 262 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      true,
      false,
      false,
      false,
      false,
      false,
      nir_op_fadd,
      0, 1,
      { 914, 262 },
      -1,
   } },

   /* replace276_0_0 -> 262 in the cache */
   /* replace276_0_1_0 -> 9 in the cache */
   /* replace276_0_1 -> 118 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fadd,
      0, 1,
      { 262, 118 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fsat,
      -1, 1,
      { 916 },
      -1,
   } },

   /* ('ishl', ('iadd', ('imul', 'a', '#b'), '#c'), '#d') => ('iadd', ('imul', 'a', ('ishl', 'b', 'd')), ('ishl', 'c', 'd')) */
   /* search277_0_0_0 -> 143 in the cache */
   /* search277_0_0_1 -> 299 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_imul,
      1, 1,
      { 143, 299 },
      -1,
   } },
   { .variable = {
      { nir_search_value_variable, -3 },
      2, /* c */
      true,
      nir_type_invalid,
      -1,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_iadd,
      0, 2,
      { 918, 919 },
      -1,
   } },
   /* search277_1 -> 327 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ishl,
      -1, 2,
      { 920, 327 },
      -1,
   } },

   /* replace277_0_0 -> 143 in the cache */
   /* replace277_0_1_0 -> 144 in the cache */
   /* replace277_0_1_1 -> 180 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ishl,
      -1, 0,
      { 144, 180 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_imul,
      1, 1,
      { 143, 922 },
      -1,
   } },
   /* replace277_1_0 -> 146 in the cache */
   /* replace277_1_1 -> 180 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ishl,
      -1, 0,
      { 146, 180 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_iadd,
      0, 2,
      { 923, 924 },
      -1,
   } },

   /* ('ishl', ('imul', 'a', '#b'), '#c') => ('imul', 'a', ('ishl', 'b', 'c')) */
   /* search278_0_0 -> 0 in the cache */
   { .variable = {
      { nir_search_value_variable, -2 },
      1, /* b */
      true,
      nir_type_invalid,
      -1,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_imul,
      0, 1,
      { 0, 926 },
      -1,
   } },
   /* search278_1 -> 325 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ishl,
      -1, 1,
      { 927, 325 },
      -1,
   } },

   /* replace278_0 -> 0 in the cache */
   /* replace278_1_0 -> 1 in the cache */
   /* replace278_1_1 -> 152 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ishl,
      -1, 0,
      { 1, 152 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_imul,
      0, 1,
      { 0, 929 },
      -1,
   } },

   /* ('ishl@8', ('ishl@8', 'a', '#b'), '#c') => ('bcsel', ('ult', ('iadd', ('iand', 'b', 7), ('iand', 'c', 7)), 8), ('ishl@8', 'a', ('iadd', 'b', 'c')), 0) */
   /* search279_0_0 -> 19 in the cache */
   /* search279_0_1 -> 45 in the cache */
   { .expression = {
      { nir_search_value_expression, 8 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ishl,
      -1, 0,
      { 19, 45 },
      -1,
   } },
   /* search279_1 -> 325 in the cache */
   { .expression = {
      { nir_search_value_expression, 8 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ishl,
      -1, 0,
      { 931, 325 },
      -1,
   } },

   /* replace279_0_0_0_0 -> 48 in the cache */
   /* replace279_0_0_0_1 -> 22 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_iand,
      1, 1,
      { 48, 22 },
      -1,
   } },
   /* replace279_0_0_1_0 -> 152 in the cache */
   /* replace279_0_0_1_1 -> 22 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_iand,
      2, 1,
      { 152, 22 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_iadd,
      0, 3,
      { 933, 934 },
      -1,
   } },
   { .constant = {
      { nir_search_value_constant, 32 },
      nir_type_int, { 0x8ull /* 8 */ },
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ult,
      -1, 3,
      { 935, 936 },
      -1,
   } },
   /* replace279_1_0 -> 19 in the cache */
   /* replace279_1_1_0 -> 48 in the cache */
   /* replace279_1_1_1 -> 152 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_iadd,
      3, 1,
      { 48, 152 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 8 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ishl,
      -1, 1,
      { 19, 938 },
      -1,
   } },
   { .constant = {
      { nir_search_value_constant, 8 },
      nir_type_int, { 0x0ull /* 0 */ },
   } },
   { .expression = {
      { nir_search_value_expression, 8 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_bcsel,
      -1, 4,
      { 937, 939, 940 },
      -1,
   } },

   /* ('ushr@8', ('ushr@8', 'a', '#b'), '#c') => ('bcsel', ('ult', ('iadd', ('iand', 'b', 7), ('iand', 'c', 7)), 8), ('ushr@8', 'a', ('iadd', 'b', 'c')), 0) */
   /* search280_0_0 -> 19 in the cache */
   /* search280_0_1 -> 45 in the cache */
   { .expression = {
      { nir_search_value_expression, 8 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ushr,
      -1, 0,
      { 19, 45 },
      -1,
   } },
   /* search280_1 -> 325 in the cache */
   { .expression = {
      { nir_search_value_expression, 8 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ushr,
      -1, 0,
      { 942, 325 },
      -1,
   } },

   /* replace280_0_0_0_0 -> 48 in the cache */
   /* replace280_0_0_0_1 -> 22 in the cache */
   /* replace280_0_0_0 -> 933 in the cache */
   /* replace280_0_0_1_0 -> 152 in the cache */
   /* replace280_0_0_1_1 -> 22 in the cache */
   /* replace280_0_0_1 -> 934 in the cache */
   /* replace280_0_0 -> 935 in the cache */
   /* replace280_0_1 -> 936 in the cache */
   /* replace280_0 -> 937 in the cache */
   /* replace280_1_0 -> 19 in the cache */
   /* replace280_1_1_0 -> 48 in the cache */
   /* replace280_1_1_1 -> 152 in the cache */
   /* replace280_1_1 -> 938 in the cache */
   { .expression = {
      { nir_search_value_expression, 8 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ushr,
      -1, 1,
      { 19, 938 },
      -1,
   } },
   /* replace280_2 -> 940 in the cache */
   { .expression = {
      { nir_search_value_expression, 8 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_bcsel,
      -1, 4,
      { 937, 944, 940 },
      -1,
   } },

   /* ('ishr@8', ('ishr@8', 'a', '#b'), '#c') => ('ishr@8', 'a', ('imin', ('iadd', ('iand', 'b', 7), ('iand', 'c', 7)), 7)) */
   /* search281_0_0 -> 19 in the cache */
   /* search281_0_1 -> 45 in the cache */
   { .expression = {
      { nir_search_value_expression, 8 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ishr,
      -1, 0,
      { 19, 45 },
      -1,
   } },
   /* search281_1 -> 325 in the cache */
   { .expression = {
      { nir_search_value_expression, 8 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ishr,
      -1, 0,
      { 946, 325 },
      -1,
   } },

   /* replace281_0 -> 19 in the cache */
   /* replace281_1_0_0_0 -> 48 in the cache */
   /* replace281_1_0_0_1 -> 22 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_iand,
      2, 1,
      { 48, 22 },
      -1,
   } },
   /* replace281_1_0_1_0 -> 152 in the cache */
   /* replace281_1_0_1_1 -> 22 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_iand,
      3, 1,
      { 152, 22 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_iadd,
      1, 3,
      { 948, 949 },
      -1,
   } },
   /* replace281_1_1 -> 22 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_imin,
      0, 4,
      { 950, 22 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 8 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ishr,
      -1, 4,
      { 19, 951 },
      -1,
   } },

   /* ('ishl@16', ('ishl@16', 'a', '#b'), '#c') => ('bcsel', ('ult', ('iadd', ('iand', 'b', 15), ('iand', 'c', 15)), 16), ('ishl@16', 'a', ('iadd', 'b', 'c')), 0) */
   /* search282_0_0 -> 24 in the cache */
   /* search282_0_1 -> 45 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ishl,
      -1, 0,
      { 24, 45 },
      -1,
   } },
   /* search282_1 -> 325 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ishl,
      -1, 0,
      { 953, 325 },
      -1,
   } },

   /* replace282_0_0_0_0 -> 48 in the cache */
   /* replace282_0_0_0_1 -> 27 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_iand,
      1, 1,
      { 48, 27 },
      -1,
   } },
   /* replace282_0_0_1_0 -> 152 in the cache */
   /* replace282_0_0_1_1 -> 27 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_iand,
      2, 1,
      { 152, 27 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_iadd,
      0, 3,
      { 955, 956 },
      -1,
   } },
   { .constant = {
      { nir_search_value_constant, 32 },
      nir_type_int, { 0x10ull /* 16 */ },
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ult,
      -1, 3,
      { 957, 958 },
      -1,
   } },
   /* replace282_1_0 -> 24 in the cache */
   /* replace282_1_1_0 -> 48 in the cache */
   /* replace282_1_1_1 -> 152 in the cache */
   /* replace282_1_1 -> 938 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ishl,
      -1, 1,
      { 24, 938 },
      -1,
   } },
   { .constant = {
      { nir_search_value_constant, 16 },
      nir_type_int, { 0x0ull /* 0 */ },
   } },
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_bcsel,
      -1, 4,
      { 959, 960, 961 },
      -1,
   } },

   /* ('ushr@16', ('ushr@16', 'a', '#b'), '#c') => ('bcsel', ('ult', ('iadd', ('iand', 'b', 15), ('iand', 'c', 15)), 16), ('ushr@16', 'a', ('iadd', 'b', 'c')), 0) */
   /* search283_0_0 -> 24 in the cache */
   /* search283_0_1 -> 45 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ushr,
      -1, 0,
      { 24, 45 },
      -1,
   } },
   /* search283_1 -> 325 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ushr,
      -1, 0,
      { 963, 325 },
      -1,
   } },

   /* replace283_0_0_0_0 -> 48 in the cache */
   /* replace283_0_0_0_1 -> 27 in the cache */
   /* replace283_0_0_0 -> 955 in the cache */
   /* replace283_0_0_1_0 -> 152 in the cache */
   /* replace283_0_0_1_1 -> 27 in the cache */
   /* replace283_0_0_1 -> 956 in the cache */
   /* replace283_0_0 -> 957 in the cache */
   /* replace283_0_1 -> 958 in the cache */
   /* replace283_0 -> 959 in the cache */
   /* replace283_1_0 -> 24 in the cache */
   /* replace283_1_1_0 -> 48 in the cache */
   /* replace283_1_1_1 -> 152 in the cache */
   /* replace283_1_1 -> 938 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ushr,
      -1, 1,
      { 24, 938 },
      -1,
   } },
   /* replace283_2 -> 961 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_bcsel,
      -1, 4,
      { 959, 965, 961 },
      -1,
   } },

   /* ('ishr@16', ('ishr@16', 'a', '#b'), '#c') => ('ishr@16', 'a', ('imin', ('iadd', ('iand', 'b', 15), ('iand', 'c', 15)), 15)) */
   /* search284_0_0 -> 24 in the cache */
   /* search284_0_1 -> 45 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ishr,
      -1, 0,
      { 24, 45 },
      -1,
   } },
   /* search284_1 -> 325 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ishr,
      -1, 0,
      { 967, 325 },
      -1,
   } },

   /* replace284_0 -> 24 in the cache */
   /* replace284_1_0_0_0 -> 48 in the cache */
   /* replace284_1_0_0_1 -> 27 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_iand,
      2, 1,
      { 48, 27 },
      -1,
   } },
   /* replace284_1_0_1_0 -> 152 in the cache */
   /* replace284_1_0_1_1 -> 27 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_iand,
      3, 1,
      { 152, 27 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_iadd,
      1, 3,
      { 969, 970 },
      -1,
   } },
   /* replace284_1_1 -> 27 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_imin,
      0, 4,
      { 971, 27 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ishr,
      -1, 4,
      { 24, 972 },
      -1,
   } },

   /* ('ishl@32', ('ishl@32', 'a', '#b'), '#c') => ('bcsel', ('ult', ('iadd', ('iand', 'b', 31), ('iand', 'c', 31)), 32), ('ishl@32', 'a', ('iadd', 'b', 'c')), 0) */
   /* search285_0_0 -> 29 in the cache */
   /* search285_0_1 -> 45 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ishl,
      -1, 0,
      { 29, 45 },
      -1,
   } },
   /* search285_1 -> 325 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ishl,
      -1, 0,
      { 974, 325 },
      -1,
   } },

   /* replace285_0_0_0_0 -> 48 in the cache */
   /* replace285_0_0_0_1 -> 32 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_iand,
      1, 1,
      { 48, 32 },
      -1,
   } },
   /* replace285_0_0_1_0 -> 152 in the cache */
   /* replace285_0_0_1_1 -> 32 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_iand,
      2, 1,
      { 152, 32 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_iadd,
      0, 3,
      { 976, 977 },
      -1,
   } },
   { .constant = {
      { nir_search_value_constant, 32 },
      nir_type_int, { 0x20ull /* 32 */ },
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ult,
      -1, 3,
      { 978, 979 },
      -1,
   } },
   /* replace285_1_0 -> 29 in the cache */
   /* replace285_1_1_0 -> 48 in the cache */
   /* replace285_1_1_1 -> 152 in the cache */
   /* replace285_1_1 -> 938 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ishl,
      -1, 1,
      { 29, 938 },
      -1,
   } },
   /* replace285_2 -> 139 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_bcsel,
      -1, 4,
      { 980, 981, 139 },
      -1,
   } },

   /* ('ushr@32', ('ushr@32', 'a', '#b'), '#c') => ('bcsel', ('ult', ('iadd', ('iand', 'b', 31), ('iand', 'c', 31)), 32), ('ushr@32', 'a', ('iadd', 'b', 'c')), 0) */
   /* search286_0_0 -> 29 in the cache */
   /* search286_0_1 -> 45 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ushr,
      -1, 0,
      { 29, 45 },
      -1,
   } },
   /* search286_1 -> 325 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ushr,
      -1, 0,
      { 983, 325 },
      -1,
   } },

   /* replace286_0_0_0_0 -> 48 in the cache */
   /* replace286_0_0_0_1 -> 32 in the cache */
   /* replace286_0_0_0 -> 976 in the cache */
   /* replace286_0_0_1_0 -> 152 in the cache */
   /* replace286_0_0_1_1 -> 32 in the cache */
   /* replace286_0_0_1 -> 977 in the cache */
   /* replace286_0_0 -> 978 in the cache */
   /* replace286_0_1 -> 979 in the cache */
   /* replace286_0 -> 980 in the cache */
   /* replace286_1_0 -> 29 in the cache */
   /* replace286_1_1_0 -> 48 in the cache */
   /* replace286_1_1_1 -> 152 in the cache */
   /* replace286_1_1 -> 938 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ushr,
      -1, 1,
      { 29, 938 },
      -1,
   } },
   /* replace286_2 -> 139 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_bcsel,
      -1, 4,
      { 980, 985, 139 },
      -1,
   } },

   /* ('ishr@32', ('ishr@32', 'a', '#b'), '#c') => ('ishr@32', 'a', ('imin', ('iadd', ('iand', 'b', 31), ('iand', 'c', 31)), 31)) */
   /* search287_0_0 -> 29 in the cache */
   /* search287_0_1 -> 45 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ishr,
      -1, 0,
      { 29, 45 },
      -1,
   } },
   /* search287_1 -> 325 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ishr,
      -1, 0,
      { 987, 325 },
      -1,
   } },

   /* replace287_0 -> 29 in the cache */
   /* replace287_1_0_0_0 -> 48 in the cache */
   /* replace287_1_0_0_1 -> 32 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_iand,
      2, 1,
      { 48, 32 },
      -1,
   } },
   /* replace287_1_0_1_0 -> 152 in the cache */
   /* replace287_1_0_1_1 -> 32 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_iand,
      3, 1,
      { 152, 32 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_iadd,
      1, 3,
      { 989, 990 },
      -1,
   } },
   /* replace287_1_1 -> 32 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_imin,
      0, 4,
      { 991, 32 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ishr,
      -1, 4,
      { 29, 992 },
      -1,
   } },

   /* ('ishl@64', ('ishl@64', 'a', '#b'), '#c') => ('bcsel', ('ult', ('iadd', ('iand', 'b', 63), ('iand', 'c', 63)), 64), ('ishl@64', 'a', ('iadd', 'b', 'c')), 0) */
   /* search288_0_0 -> 34 in the cache */
   /* search288_0_1 -> 45 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ishl,
      -1, 0,
      { 34, 45 },
      -1,
   } },
   /* search288_1 -> 325 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ishl,
      -1, 0,
      { 994, 325 },
      -1,
   } },

   /* replace288_0_0_0_0 -> 48 in the cache */
   /* replace288_0_0_0_1 -> 37 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_iand,
      1, 1,
      { 48, 37 },
      -1,
   } },
   /* replace288_0_0_1_0 -> 152 in the cache */
   /* replace288_0_0_1_1 -> 37 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_iand,
      2, 1,
      { 152, 37 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_iadd,
      0, 3,
      { 996, 997 },
      -1,
   } },
   { .constant = {
      { nir_search_value_constant, 32 },
      nir_type_int, { 0x40ull /* 64 */ },
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ult,
      -1, 3,
      { 998, 999 },
      -1,
   } },
   /* replace288_1_0 -> 34 in the cache */
   /* replace288_1_1_0 -> 48 in the cache */
   /* replace288_1_1_1 -> 152 in the cache */
   /* replace288_1_1 -> 938 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ishl,
      -1, 1,
      { 34, 938 },
      -1,
   } },
   { .constant = {
      { nir_search_value_constant, 64 },
      nir_type_int, { 0x0ull /* 0 */ },
   } },
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_bcsel,
      -1, 4,
      { 1000, 1001, 1002 },
      -1,
   } },

   /* ('ushr@64', ('ushr@64', 'a', '#b'), '#c') => ('bcsel', ('ult', ('iadd', ('iand', 'b', 63), ('iand', 'c', 63)), 64), ('ushr@64', 'a', ('iadd', 'b', 'c')), 0) */
   /* search289_0_0 -> 34 in the cache */
   /* search289_0_1 -> 45 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ushr,
      -1, 0,
      { 34, 45 },
      -1,
   } },
   /* search289_1 -> 325 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ushr,
      -1, 0,
      { 1004, 325 },
      -1,
   } },

   /* replace289_0_0_0_0 -> 48 in the cache */
   /* replace289_0_0_0_1 -> 37 in the cache */
   /* replace289_0_0_0 -> 996 in the cache */
   /* replace289_0_0_1_0 -> 152 in the cache */
   /* replace289_0_0_1_1 -> 37 in the cache */
   /* replace289_0_0_1 -> 997 in the cache */
   /* replace289_0_0 -> 998 in the cache */
   /* replace289_0_1 -> 999 in the cache */
   /* replace289_0 -> 1000 in the cache */
   /* replace289_1_0 -> 34 in the cache */
   /* replace289_1_1_0 -> 48 in the cache */
   /* replace289_1_1_1 -> 152 in the cache */
   /* replace289_1_1 -> 938 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ushr,
      -1, 1,
      { 34, 938 },
      -1,
   } },
   /* replace289_2 -> 1002 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_bcsel,
      -1, 4,
      { 1000, 1006, 1002 },
      -1,
   } },

   /* ('ishr@64', ('ishr@64', 'a', '#b'), '#c') => ('ishr@64', 'a', ('imin', ('iadd', ('iand', 'b', 63), ('iand', 'c', 63)), 63)) */
   /* search290_0_0 -> 34 in the cache */
   /* search290_0_1 -> 45 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ishr,
      -1, 0,
      { 34, 45 },
      -1,
   } },
   /* search290_1 -> 325 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ishr,
      -1, 0,
      { 1008, 325 },
      -1,
   } },

   /* replace290_0 -> 34 in the cache */
   /* replace290_1_0_0_0 -> 48 in the cache */
   /* replace290_1_0_0_1 -> 37 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_iand,
      2, 1,
      { 48, 37 },
      -1,
   } },
   /* replace290_1_0_1_0 -> 152 in the cache */
   /* replace290_1_0_1_1 -> 37 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_iand,
      3, 1,
      { 152, 37 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_iadd,
      1, 3,
      { 1010, 1011 },
      -1,
   } },
   /* replace290_1_1 -> 37 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_imin,
      0, 4,
      { 1012, 37 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ishr,
      -1, 4,
      { 34, 1013 },
      -1,
   } },

   /* ('ishl', ('ushr', 'a@8', '#b'), 'b') => ('iand', 'a', ('ishl', 255, 'b')) */
   /* search291_0_0 -> 19 in the cache */
   /* search291_0_1 -> 45 in the cache */
   /* search291_0 -> 942 in the cache */
   /* search291_1 -> 48 in the cache */
   { .expression = {
      { nir_search_value_expression, 8 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ishl,
      -1, 0,
      { 942, 48 },
      -1,
   } },

   /* replace291_0 -> 19 in the cache */
   { .constant = {
      { nir_search_value_constant, 8 },
      nir_type_int, { 0xffull /* 255 */ },
   } },
   /* replace291_1_1 -> 48 in the cache */
   { .expression = {
      { nir_search_value_expression, 8 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ishl,
      -1, 0,
      { 1016, 48 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 8 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_iand,
      0, 1,
      { 19, 1017 },
      -1,
   } },

   /* ('ishl', ('ishr', 'a@8', '#b'), 'b') => ('iand', 'a', ('ishl', 255, 'b')) */
   /* search292_0_0 -> 19 in the cache */
   /* search292_0_1 -> 45 in the cache */
   /* search292_0 -> 946 in the cache */
   /* search292_1 -> 48 in the cache */
   { .expression = {
      { nir_search_value_expression, 8 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ishl,
      -1, 0,
      { 946, 48 },
      -1,
   } },

   /* replace292_0 -> 19 in the cache */
   /* replace292_1_0 -> 1016 in the cache */
   /* replace292_1_1 -> 48 in the cache */
   /* replace292_1 -> 1017 in the cache */
   /* replace292 -> 1018 in the cache */

   /* ('ushr', ('ishl', 'a@8', '#b'), 'b') => ('iand', 'a', ('ushr', 255, 'b')) */
   /* search293_0_0 -> 19 in the cache */
   /* search293_0_1 -> 45 in the cache */
   /* search293_0 -> 931 in the cache */
   /* search293_1 -> 48 in the cache */
   { .expression = {
      { nir_search_value_expression, 8 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ushr,
      -1, 0,
      { 931, 48 },
      -1,
   } },

   /* replace293_0 -> 19 in the cache */
   /* replace293_1_0 -> 1016 in the cache */
   /* replace293_1_1 -> 48 in the cache */
   { .expression = {
      { nir_search_value_expression, 8 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ushr,
      -1, 0,
      { 1016, 48 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 8 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_iand,
      0, 1,
      { 19, 1021 },
      -1,
   } },

   /* ('ishl', ('ushr', 'a@16', '#b'), 'b') => ('iand', 'a', ('ishl', 65535, 'b')) */
   /* search294_0_0 -> 24 in the cache */
   /* search294_0_1 -> 45 in the cache */
   /* search294_0 -> 963 in the cache */
   /* search294_1 -> 48 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ishl,
      -1, 0,
      { 963, 48 },
      -1,
   } },

   /* replace294_0 -> 24 in the cache */
   { .constant = {
      { nir_search_value_constant, 16 },
      nir_type_int, { 0xffffull /* 65535 */ },
   } },
   /* replace294_1_1 -> 48 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ishl,
      -1, 0,
      { 1024, 48 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_iand,
      0, 1,
      { 24, 1025 },
      -1,
   } },

   /* ('ishl', ('ishr', 'a@16', '#b'), 'b') => ('iand', 'a', ('ishl', 65535, 'b')) */
   /* search295_0_0 -> 24 in the cache */
   /* search295_0_1 -> 45 in the cache */
   /* search295_0 -> 967 in the cache */
   /* search295_1 -> 48 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ishl,
      -1, 0,
      { 967, 48 },
      -1,
   } },

   /* replace295_0 -> 24 in the cache */
   /* replace295_1_0 -> 1024 in the cache */
   /* replace295_1_1 -> 48 in the cache */
   /* replace295_1 -> 1025 in the cache */
   /* replace295 -> 1026 in the cache */

   /* ('ushr', ('ishl', 'a@16', '#b'), 'b') => ('iand', 'a', ('ushr', 65535, 'b')) */
   /* search296_0_0 -> 24 in the cache */
   /* search296_0_1 -> 45 in the cache */
   /* search296_0 -> 953 in the cache */
   /* search296_1 -> 48 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ushr,
      -1, 0,
      { 953, 48 },
      -1,
   } },

   /* replace296_0 -> 24 in the cache */
   /* replace296_1_0 -> 1024 in the cache */
   /* replace296_1_1 -> 48 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ushr,
      -1, 0,
      { 1024, 48 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_iand,
      0, 1,
      { 24, 1029 },
      -1,
   } },

   /* ('ishl', ('ushr', 'a@32', '#b'), 'b') => ('iand', 'a', ('ishl', 4294967295, 'b')) */
   /* search297_0_0 -> 29 in the cache */
   /* search297_0_1 -> 45 in the cache */
   /* search297_0 -> 983 in the cache */
   /* search297_1 -> 48 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ishl,
      -1, 0,
      { 983, 48 },
      -1,
   } },

   /* replace297_0 -> 29 in the cache */
   { .constant = {
      { nir_search_value_constant, 32 },
      nir_type_int, { 0xffffffffull /* 4294967295 */ },
   } },
   /* replace297_1_1 -> 48 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ishl,
      -1, 0,
      { 1032, 48 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_iand,
      0, 1,
      { 29, 1033 },
      -1,
   } },

   /* ('ishl', ('ishr', 'a@32', '#b'), 'b') => ('iand', 'a', ('ishl', 4294967295, 'b')) */
   /* search298_0_0 -> 29 in the cache */
   /* search298_0_1 -> 45 in the cache */
   /* search298_0 -> 987 in the cache */
   /* search298_1 -> 48 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ishl,
      -1, 0,
      { 987, 48 },
      -1,
   } },

   /* replace298_0 -> 29 in the cache */
   /* replace298_1_0 -> 1032 in the cache */
   /* replace298_1_1 -> 48 in the cache */
   /* replace298_1 -> 1033 in the cache */
   /* replace298 -> 1034 in the cache */

   /* ('ushr', ('ishl', 'a@32', '#b'), 'b') => ('iand', 'a', ('ushr', 4294967295, 'b')) */
   /* search299_0_0 -> 29 in the cache */
   /* search299_0_1 -> 45 in the cache */
   /* search299_0 -> 974 in the cache */
   /* search299_1 -> 48 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ushr,
      -1, 0,
      { 974, 48 },
      -1,
   } },

   /* replace299_0 -> 29 in the cache */
   /* replace299_1_0 -> 1032 in the cache */
   /* replace299_1_1 -> 48 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ushr,
      -1, 0,
      { 1032, 48 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_iand,
      0, 1,
      { 29, 1037 },
      -1,
   } },

   /* ('ishl', ('ushr', 'a@64', '#b'), 'b') => ('iand', 'a', ('ishl', 18446744073709551615, 'b')) */
   /* search300_0_0 -> 34 in the cache */
   /* search300_0_1 -> 45 in the cache */
   /* search300_0 -> 1004 in the cache */
   /* search300_1 -> 48 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ishl,
      -1, 0,
      { 1004, 48 },
      -1,
   } },

   /* replace300_0 -> 34 in the cache */
   { .constant = {
      { nir_search_value_constant, 64 },
      nir_type_int, { 0xffffffffffffffffull /* 18446744073709551615 */ },
   } },
   /* replace300_1_1 -> 48 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ishl,
      -1, 0,
      { 1040, 48 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_iand,
      0, 1,
      { 34, 1041 },
      -1,
   } },

   /* ('ishl', ('ishr', 'a@64', '#b'), 'b') => ('iand', 'a', ('ishl', 18446744073709551615, 'b')) */
   /* search301_0_0 -> 34 in the cache */
   /* search301_0_1 -> 45 in the cache */
   /* search301_0 -> 1008 in the cache */
   /* search301_1 -> 48 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ishl,
      -1, 0,
      { 1008, 48 },
      -1,
   } },

   /* replace301_0 -> 34 in the cache */
   /* replace301_1_0 -> 1040 in the cache */
   /* replace301_1_1 -> 48 in the cache */
   /* replace301_1 -> 1041 in the cache */
   /* replace301 -> 1042 in the cache */

   /* ('ushr', ('ishl', 'a@64', '#b'), 'b') => ('iand', 'a', ('ushr', 18446744073709551615, 'b')) */
   /* search302_0_0 -> 34 in the cache */
   /* search302_0_1 -> 45 in the cache */
   /* search302_0 -> 994 in the cache */
   /* search302_1 -> 48 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ushr,
      -1, 0,
      { 994, 48 },
      -1,
   } },

   /* replace302_0 -> 34 in the cache */
   /* replace302_1_0 -> 1040 in the cache */
   /* replace302_1_1 -> 48 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ushr,
      -1, 0,
      { 1040, 48 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_iand,
      0, 1,
      { 34, 1045 },
      -1,
   } },

   /* ('iand@32', ('ushr@32(is_used_once)', 'a', 'b'), '#c(is_const_bitmask)') => ('ubfe', 'a', 'b', ('bit_count', 'c')) */
   /* search303_0_0 -> 29 in the cache */
   /* search303_0_1 -> 48 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ushr,
      -1, 0,
      { 29, 48 },
      0,
   } },
   { .variable = {
      { nir_search_value_variable, 32 },
      2, /* c */
      true,
      nir_type_invalid,
      10,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_iand,
      0, 1,
      { 1047, 1048 },
      -1,
   } },

   /* replace303_0 -> 29 in the cache */
   /* replace303_1 -> 48 in the cache */
   /* replace303_2_0 -> 152 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_bit_count,
      -1, 0,
      { 152 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ubfe,
      -1, 0,
      { 29, 48, 1050 },
      -1,
   } },

   /* ('iand@32', ('ushr@32', 'a', 'b'), ('bfm', 'c', 0)) => ('ubfe', 'a', 'b', 'c') */
   /* search304_0_0 -> 29 in the cache */
   /* search304_0_1 -> 48 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ushr,
      -1, 0,
      { 29, 48 },
      -1,
   } },
   /* search304_1_0 -> 152 in the cache */
   /* search304_1_1 -> 139 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_bfm,
      -1, 0,
      { 152, 139 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_iand,
      0, 1,
      { 1052, 1053 },
      -1,
   } },

   /* replace304_0 -> 29 in the cache */
   /* replace304_1 -> 48 in the cache */
   /* replace304_2 -> 152 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ubfe,
      -1, 0,
      { 29, 48, 152 },
      -1,
   } },

   /* ('ushr', ('iand', 'a', ('bfm', 'c', 'b')), 'b') => ('ubfe', 'a', 'b', 'c') */
   /* search305_0_0 -> 29 in the cache */
   /* search305_0_1_0 -> 658 in the cache */
   /* search305_0_1_1 -> 662 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_bfm,
      -1, 0,
      { 658, 662 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_iand,
      0, 1,
      { 29, 1056 },
      -1,
   } },
   /* search305_1 -> 662 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ushr,
      -1, 1,
      { 1057, 662 },
      -1,
   } },

   /* replace305_0 -> 29 in the cache */
   /* replace305_1 -> 662 in the cache */
   /* replace305_2 -> 658 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ubfe,
      -1, 0,
      { 29, 662, 658 },
      -1,
   } },

   /* ('ubfe', ('ubfe', 'a', '#b', '#c'), '#d', '#e') => ('bcsel', ('ilt', 31, ('iadd', ('iand', 'b', 31), ('iand', 'd', 31))), 0, ('ubfe', 'a', ('iadd', ('iand', 'b', 31), ('iand', 'd', 31)), ('umin', ('iand', 'e', 31), ('imax', ('isub', ('umin', ('iand', 'c', 31), ('isub', 32, ('iand', 'b', 31))), ('iand', 'd', 31)), 0)))) */
   /* search306_0_0 -> 29 in the cache */
   /* search306_0_1 -> 45 in the cache */
   /* search306_0_2 -> 325 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ubfe,
      -1, 0,
      { 29, 45, 325 },
      -1,
   } },
   /* search306_1 -> 327 in the cache */
   { .variable = {
      { nir_search_value_variable, 32 },
      4, /* e */
      true,
      nir_type_invalid,
      -1,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ubfe,
      -1, 0,
      { 1060, 327, 1061 },
      -1,
   } },

   /* replace306_0_0 -> 32 in the cache */
   /* replace306_0_1_0_0 -> 48 in the cache */
   /* replace306_0_1_0_1 -> 32 in the cache */
   /* replace306_0_1_0 -> 976 in the cache */
   /* replace306_0_1_1_0 -> 180 in the cache */
   /* replace306_0_1_1_1 -> 32 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_iand,
      2, 1,
      { 180, 32 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_iadd,
      0, 3,
      { 976, 1063 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ilt,
      -1, 3,
      { 32, 1064 },
      -1,
   } },
   /* replace306_1 -> 139 in the cache */
   /* replace306_2_0 -> 29 in the cache */
   /* replace306_2_1_0_0 -> 48 in the cache */
   /* replace306_2_1_0_1 -> 32 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_iand,
      4, 1,
      { 48, 32 },
      -1,
   } },
   /* replace306_2_1_1_0 -> 180 in the cache */
   /* replace306_2_1_1_1 -> 32 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_iand,
      5, 1,
      { 180, 32 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_iadd,
      3, 3,
      { 1066, 1067 },
      -1,
   } },
   { .variable = {
      { nir_search_value_variable, 32 },
      4, /* e */
      false,
      nir_type_invalid,
      -1,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   /* replace306_2_2_0_1 -> 32 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_iand,
      7, 1,
      { 1069, 32 },
      -1,
   } },
   /* replace306_2_2_1_0_0_0_0 -> 152 in the cache */
   /* replace306_2_2_1_0_0_0_1 -> 32 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_iand,
      10, 1,
      { 152, 32 },
      -1,
   } },
   /* replace306_2_2_1_0_0_1_0 -> 979 in the cache */
   /* replace306_2_2_1_0_0_1_1_0 -> 48 in the cache */
   /* replace306_2_2_1_0_0_1_1_1 -> 32 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_iand,
      11, 1,
      { 48, 32 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_isub,
      -1, 1,
      { 979, 1072 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_umin,
      9, 3,
      { 1071, 1073 },
      -1,
   } },
   /* replace306_2_2_1_0_1_0 -> 180 in the cache */
   /* replace306_2_2_1_0_1_1 -> 32 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_iand,
      12, 1,
      { 180, 32 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_isub,
      -1, 4,
      { 1074, 1075 },
      -1,
   } },
   /* replace306_2_2_1_1 -> 139 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_imax,
      8, 5,
      { 1076, 139 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_umin,
      6, 7,
      { 1070, 1077 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ubfe,
      -1, 10,
      { 29, 1068, 1078 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_bcsel,
      -1, 13,
      { 1065, 139, 1079 },
      -1,
   } },

   /* ('ushr@32', ('ubfe', 'a', '#b', '#c'), '#d(is_5lsb_not_zero)') => ('bcsel', ('ilt', 31, ('iadd', ('iand', 'b', 31), ('iand', 'd', 31))), 0, ('ubfe', 'a', ('iadd', ('iand', 'b', 31), ('iand', 'd', 31)), ('umin', ('iand', 31, 31), ('imax', ('isub', ('umin', ('iand', 'c', 31), ('isub', 32, ('iand', 'b', 31))), ('iand', 'd', 31)), 0)))) */
   /* search307_0_0 -> 29 in the cache */
   /* search307_0_1 -> 45 in the cache */
   /* search307_0_2 -> 325 in the cache */
   /* search307_0 -> 1060 in the cache */
   { .variable = {
      { nir_search_value_variable, 32 },
      3, /* d */
      true,
      nir_type_invalid,
      11,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ushr,
      -1, 0,
      { 1060, 1081 },
      -1,
   } },

   /* replace307_0_0 -> 32 in the cache */
   /* replace307_0_1_0_0 -> 48 in the cache */
   /* replace307_0_1_0_1 -> 32 in the cache */
   /* replace307_0_1_0 -> 976 in the cache */
   /* replace307_0_1_1_0 -> 180 in the cache */
   /* replace307_0_1_1_1 -> 32 in the cache */
   /* replace307_0_1_1 -> 1063 in the cache */
   /* replace307_0_1 -> 1064 in the cache */
   /* replace307_0 -> 1065 in the cache */
   /* replace307_1 -> 139 in the cache */
   /* replace307_2_0 -> 29 in the cache */
   /* replace307_2_1_0_0 -> 48 in the cache */
   /* replace307_2_1_0_1 -> 32 in the cache */
   /* replace307_2_1_0 -> 1066 in the cache */
   /* replace307_2_1_1_0 -> 180 in the cache */
   /* replace307_2_1_1_1 -> 32 in the cache */
   /* replace307_2_1_1 -> 1067 in the cache */
   /* replace307_2_1 -> 1068 in the cache */
   /* replace307_2_2_0_0 -> 32 in the cache */
   /* replace307_2_2_0_1 -> 32 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_iand,
      -1, 0,
      { 32, 32 },
      -1,
   } },
   /* replace307_2_2_1_0_0_0_0 -> 152 in the cache */
   /* replace307_2_2_1_0_0_0_1 -> 32 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_iand,
      9, 1,
      { 152, 32 },
      -1,
   } },
   /* replace307_2_2_1_0_0_1_0 -> 979 in the cache */
   /* replace307_2_2_1_0_0_1_1_0 -> 48 in the cache */
   /* replace307_2_2_1_0_0_1_1_1 -> 32 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_iand,
      10, 1,
      { 48, 32 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_isub,
      -1, 1,
      { 979, 1085 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_umin,
      8, 3,
      { 1084, 1086 },
      -1,
   } },
   /* replace307_2_2_1_0_1_0 -> 180 in the cache */
   /* replace307_2_2_1_0_1_1 -> 32 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_iand,
      11, 1,
      { 180, 32 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_isub,
      -1, 4,
      { 1087, 1088 },
      -1,
   } },
   /* replace307_2_2_1_1 -> 139 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_imax,
      7, 5,
      { 1089, 139 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_umin,
      6, 6,
      { 1083, 1090 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ubfe,
      -1, 9,
      { 29, 1068, 1091 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_bcsel,
      -1, 12,
      { 1065, 139, 1092 },
      -1,
   } },

   /* ('iand', ('ishl', 'a@32', '#b(is_first_5_bits_uge_2)'), -4) => ('ishl', 'a', 'b') */
   /* search308_0_0 -> 29 in the cache */
   { .variable = {
      { nir_search_value_variable, 32 },
      1, /* b */
      true,
      nir_type_invalid,
      12,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ishl,
      -1, 0,
      { 29, 1094 },
      -1,
   } },
   { .constant = {
      { nir_search_value_constant, 32 },
      nir_type_int, { 0xfffffffffffffffcull /* -4 */ },
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_iand,
      0, 1,
      { 1095, 1096 },
      -1,
   } },

   /* replace308_0 -> 29 in the cache */
   /* replace308_1 -> 48 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ishl,
      -1, 0,
      { 29, 48 },
      -1,
   } },

   /* ('iand', ('imul', 'a', '#b(is_unsigned_multiple_of_4)'), -4) => ('imul', 'a', 'b') */
   /* search309_0_0 -> 0 in the cache */
   { .variable = {
      { nir_search_value_variable, -2 },
      1, /* b */
      true,
      nir_type_invalid,
      13,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_imul,
      1, 1,
      { 0, 1099 },
      -1,
   } },
   { .constant = {
      { nir_search_value_constant, -2 },
      nir_type_int, { 0xfffffffffffffffcull /* -4 */ },
   } },
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_iand,
      0, 2,
      { 1100, 1101 },
      -1,
   } },

   /* replace309_0 -> 0 in the cache */
   /* replace309_1 -> 1 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_imul,
      0, 1,
      { 0, 1 },
      -1,
   } },

   /* ('iand@32', ('iadd@32', 'a', '#b(is_unsigned_multiple_of_2)'), 4294967294) => ('iadd', ('iand', 'a', 4294967294), 'b') */
   /* search310_0_0 -> 29 in the cache */
   { .variable = {
      { nir_search_value_variable, 32 },
      1, /* b */
      true,
      nir_type_invalid,
      14,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_iadd,
      1, 1,
      { 29, 1104 },
      -1,
   } },
   { .constant = {
      { nir_search_value_constant, 32 },
      nir_type_int, { 0xfffffffeull /* 4294967294 */ },
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_iand,
      0, 2,
      { 1105, 1106 },
      -1,
   } },

   /* replace310_0_0 -> 29 in the cache */
   /* replace310_0_1 -> 1106 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_iand,
      1, 1,
      { 29, 1106 },
      -1,
   } },
   /* replace310_1 -> 48 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_iadd,
      0, 2,
      { 1108, 48 },
      -1,
   } },

   /* ('iand@32', ('iadd@32', 'a', '#b(is_unsigned_multiple_of_4)'), 4294967292) => ('iadd', ('iand', 'a', 4294967292), 'b') */
   /* search311_0_0 -> 29 in the cache */
   { .variable = {
      { nir_search_value_variable, 32 },
      1, /* b */
      true,
      nir_type_invalid,
      13,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_iadd,
      1, 1,
      { 29, 1110 },
      -1,
   } },
   { .constant = {
      { nir_search_value_constant, 32 },
      nir_type_int, { 0xfffffffcull /* 4294967292 */ },
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_iand,
      0, 2,
      { 1111, 1112 },
      -1,
   } },

   /* replace311_0_0 -> 29 in the cache */
   /* replace311_0_1 -> 1112 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_iand,
      1, 1,
      { 29, 1112 },
      -1,
   } },
   /* replace311_1 -> 48 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_iadd,
      0, 2,
      { 1114, 48 },
      -1,
   } },

   /* ('iand@32', ('iadd@32', 'a', '#b(is_unsigned_multiple_of_8)'), 4294967288) => ('iadd', ('iand', 'a', 4294967288), 'b') */
   /* search312_0_0 -> 29 in the cache */
   { .variable = {
      { nir_search_value_variable, 32 },
      1, /* b */
      true,
      nir_type_invalid,
      15,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_iadd,
      1, 1,
      { 29, 1116 },
      -1,
   } },
   { .constant = {
      { nir_search_value_constant, 32 },
      nir_type_int, { 0xfffffff8ull /* 4294967288 */ },
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_iand,
      0, 2,
      { 1117, 1118 },
      -1,
   } },

   /* replace312_0_0 -> 29 in the cache */
   /* replace312_0_1 -> 1118 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_iand,
      1, 1,
      { 29, 1118 },
      -1,
   } },
   /* replace312_1 -> 48 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_iadd,
      0, 2,
      { 1120, 48 },
      -1,
   } },

   /* ('iand@32', ('iadd@32', 'a', '#b(is_unsigned_multiple_of_16)'), 4294967280) => ('iadd', ('iand', 'a', 4294967280), 'b') */
   /* search313_0_0 -> 29 in the cache */
   { .variable = {
      { nir_search_value_variable, 32 },
      1, /* b */
      true,
      nir_type_invalid,
      16,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_iadd,
      1, 1,
      { 29, 1122 },
      -1,
   } },
   { .constant = {
      { nir_search_value_constant, 32 },
      nir_type_int, { 0xfffffff0ull /* 4294967280 */ },
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_iand,
      0, 2,
      { 1123, 1124 },
      -1,
   } },

   /* replace313_0_0 -> 29 in the cache */
   /* replace313_0_1 -> 1124 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_iand,
      1, 1,
      { 29, 1124 },
      -1,
   } },
   /* replace313_1 -> 48 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_iadd,
      0, 2,
      { 1126, 48 },
      -1,
   } },

   /* ('iand@32', ('iadd@32', 'a', '#b(is_unsigned_multiple_of_32)'), 4294967264) => ('iadd', ('iand', 'a', 4294967264), 'b') */
   /* search314_0_0 -> 29 in the cache */
   { .variable = {
      { nir_search_value_variable, 32 },
      1, /* b */
      true,
      nir_type_invalid,
      17,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_iadd,
      1, 1,
      { 29, 1128 },
      -1,
   } },
   { .constant = {
      { nir_search_value_constant, 32 },
      nir_type_int, { 0xffffffe0ull /* 4294967264 */ },
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_iand,
      0, 2,
      { 1129, 1130 },
      -1,
   } },

   /* replace314_0_0 -> 29 in the cache */
   /* replace314_0_1 -> 1130 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_iand,
      1, 1,
      { 29, 1130 },
      -1,
   } },
   /* replace314_1 -> 48 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_iadd,
      0, 2,
      { 1132, 48 },
      -1,
   } },

   /* ('iand@32', ('iadd@32', 'a', '#b(is_unsigned_multiple_of_64)'), 4294967232) => ('iadd', ('iand', 'a', 4294967232), 'b') */
   /* search315_0_0 -> 29 in the cache */
   { .variable = {
      { nir_search_value_variable, 32 },
      1, /* b */
      true,
      nir_type_invalid,
      18,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_iadd,
      1, 1,
      { 29, 1134 },
      -1,
   } },
   { .constant = {
      { nir_search_value_constant, 32 },
      nir_type_int, { 0xffffffc0ull /* 4294967232 */ },
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_iand,
      0, 2,
      { 1135, 1136 },
      -1,
   } },

   /* replace315_0_0 -> 29 in the cache */
   /* replace315_0_1 -> 1136 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_iand,
      1, 1,
      { 29, 1136 },
      -1,
   } },
   /* replace315_1 -> 48 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_iadd,
      0, 2,
      { 1138, 48 },
      -1,
   } },

   /* ('ishl@32', ('iand', 'a@32', 2147483647), 1) => ('ishl', 'a', 1) */
   /* search316_0_0 -> 29 in the cache */
   { .constant = {
      { nir_search_value_constant, 32 },
      nir_type_int, { 0x7fffffffull /* 2147483647 */ },
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_iand,
      0, 1,
      { 29, 1140 },
      -1,
   } },
   /* search316_1 -> 501 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ishl,
      -1, 1,
      { 1141, 501 },
      -1,
   } },

   /* replace316_0 -> 29 in the cache */
   /* replace316_1 -> 501 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ishl,
      -1, 0,
      { 29, 501 },
      -1,
   } },

   /* ('iand', ('ishl', 'a@32', 1), 4294967294) => ('ishl', 'a', 1) */
   /* search317_0_0 -> 29 in the cache */
   /* search317_0_1 -> 501 in the cache */
   /* search317_0 -> 1143 in the cache */
   /* search317_1 -> 1106 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_iand,
      0, 1,
      { 1143, 1106 },
      -1,
   } },

   /* replace317_0 -> 29 in the cache */
   /* replace317_1 -> 501 in the cache */
   /* replace317 -> 1143 in the cache */

   /* ('iand', ('ushr', 'a@32', 1), 2147483647) => ('ushr', 'a', 1) */
   /* search318_0_0 -> 29 in the cache */
   /* search318_0_1 -> 501 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ushr,
      -1, 0,
      { 29, 501 },
      -1,
   } },
   /* search318_1 -> 1140 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_iand,
      0, 1,
      { 1145, 1140 },
      -1,
   } },

   /* replace318_0 -> 29 in the cache */
   /* replace318_1 -> 501 in the cache */
   /* replace318 -> 1145 in the cache */

   /* ('ishl@32', ('iand', 'a@32', 1073741823), 2) => ('ishl', 'a', 2) */
   /* search319_0_0 -> 29 in the cache */
   { .constant = {
      { nir_search_value_constant, 32 },
      nir_type_int, { 0x3fffffffull /* 1073741823 */ },
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_iand,
      0, 1,
      { 29, 1147 },
      -1,
   } },
   /* search319_1 -> 506 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ishl,
      -1, 1,
      { 1148, 506 },
      -1,
   } },

   /* replace319_0 -> 29 in the cache */
   /* replace319_1 -> 506 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ishl,
      -1, 0,
      { 29, 506 },
      -1,
   } },

   /* ('iand', ('ishl', 'a@32', 2), 4294967292) => ('ishl', 'a', 2) */
   /* search320_0_0 -> 29 in the cache */
   /* search320_0_1 -> 506 in the cache */
   /* search320_0 -> 1150 in the cache */
   /* search320_1 -> 1112 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_iand,
      0, 1,
      { 1150, 1112 },
      -1,
   } },

   /* replace320_0 -> 29 in the cache */
   /* replace320_1 -> 506 in the cache */
   /* replace320 -> 1150 in the cache */

   /* ('iand', ('ushr', 'a@32', 2), 1073741823) => ('ushr', 'a', 2) */
   /* search321_0_0 -> 29 in the cache */
   /* search321_0_1 -> 506 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ushr,
      -1, 0,
      { 29, 506 },
      -1,
   } },
   /* search321_1 -> 1147 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_iand,
      0, 1,
      { 1152, 1147 },
      -1,
   } },

   /* replace321_0 -> 29 in the cache */
   /* replace321_1 -> 506 in the cache */
   /* replace321 -> 1152 in the cache */

   /* ('ishl@32', ('iand', 'a@32', 65535), 16) => ('ishl', 'a', 16) */
   /* search322_0_0 -> 29 in the cache */
   { .constant = {
      { nir_search_value_constant, 32 },
      nir_type_int, { 0xffffull /* 65535 */ },
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_iand,
      0, 1,
      { 29, 1154 },
      -1,
   } },
   /* search322_1 -> 958 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ishl,
      -1, 1,
      { 1155, 958 },
      -1,
   } },

   /* replace322_0 -> 29 in the cache */
   /* replace322_1 -> 958 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ishl,
      -1, 0,
      { 29, 958 },
      -1,
   } },

   /* ('iand', ('ishl', 'a@32', 16), 4294901760) => ('ishl', 'a', 16) */
   /* search323_0_0 -> 29 in the cache */
   /* search323_0_1 -> 958 in the cache */
   /* search323_0 -> 1157 in the cache */
   { .constant = {
      { nir_search_value_constant, 32 },
      nir_type_int, { 0xffff0000ull /* 4294901760 */ },
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_iand,
      0, 1,
      { 1157, 1158 },
      -1,
   } },

   /* replace323_0 -> 29 in the cache */
   /* replace323_1 -> 958 in the cache */
   /* replace323 -> 1157 in the cache */

   /* ('iand', ('ushr', 'a@32', 16), 65535) => ('ushr', 'a', 16) */
   /* search324_0_0 -> 29 in the cache */
   /* search324_0_1 -> 958 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ushr,
      -1, 0,
      { 29, 958 },
      -1,
   } },
   /* search324_1 -> 1154 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_iand,
      0, 1,
      { 1160, 1154 },
      -1,
   } },

   /* replace324_0 -> 29 in the cache */
   /* replace324_1 -> 958 in the cache */
   /* replace324 -> 1160 in the cache */

   /* ('ishl@32', ('iand', 'a@32', 255), 24) => ('ishl', 'a', 24) */
   /* search325_0_0 -> 29 in the cache */
   { .constant = {
      { nir_search_value_constant, 32 },
      nir_type_int, { 0xffull /* 255 */ },
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_iand,
      0, 1,
      { 29, 1162 },
      -1,
   } },
   { .constant = {
      { nir_search_value_constant, 32 },
      nir_type_int, { 0x18ull /* 24 */ },
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ishl,
      -1, 1,
      { 1163, 1164 },
      -1,
   } },

   /* replace325_0 -> 29 in the cache */
   /* replace325_1 -> 1164 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ishl,
      -1, 0,
      { 29, 1164 },
      -1,
   } },

   /* ('iand', ('ishl', 'a@32', 24), 4278190080) => ('ishl', 'a', 24) */
   /* search326_0_0 -> 29 in the cache */
   /* search326_0_1 -> 1164 in the cache */
   /* search326_0 -> 1166 in the cache */
   { .constant = {
      { nir_search_value_constant, 32 },
      nir_type_int, { 0xff000000ull /* 4278190080 */ },
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_iand,
      0, 1,
      { 1166, 1167 },
      -1,
   } },

   /* replace326_0 -> 29 in the cache */
   /* replace326_1 -> 1164 in the cache */
   /* replace326 -> 1166 in the cache */

   /* ('iand', ('ushr', 'a@32', 24), 255) => ('ushr', 'a', 24) */
   /* search327_0_0 -> 29 in the cache */
   /* search327_0_1 -> 1164 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ushr,
      -1, 0,
      { 29, 1164 },
      -1,
   } },
   /* search327_1 -> 1162 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_iand,
      0, 1,
      { 1169, 1162 },
      -1,
   } },

   /* replace327_0 -> 29 in the cache */
   /* replace327_1 -> 1164 in the cache */
   /* replace327 -> 1169 in the cache */

   /* ('ishl', ('iadd', 'a', '#b'), '#c') => ('iadd', ('ishl', 'a', 'c'), ('ishl', 'b', 'c')) */
   /* search328_0_0 -> 0 in the cache */
   /* search328_0_1 -> 926 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_iadd,
      0, 1,
      { 0, 926 },
      -1,
   } },
   /* search328_1 -> 325 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ishl,
      -1, 1,
      { 1171, 325 },
      -1,
   } },

   /* replace328_0_0 -> 0 in the cache */
   /* replace328_0_1 -> 152 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ishl,
      -1, 0,
      { 0, 152 },
      -1,
   } },
   /* replace328_1_0 -> 1 in the cache */
   /* replace328_1_1 -> 152 in the cache */
   /* replace328_1 -> 929 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_iadd,
      0, 1,
      { 1173, 929 },
      -1,
   } },

   /* ('imul', ('iadd(is_used_once)', 'a', '#b'), '#c') => ('iadd', ('imul', 'a', 'c'), ('imul', 'b', 'c')) */
   /* search329_0_0 -> 143 in the cache */
   /* search329_0_1 -> 299 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_iadd,
      1, 1,
      { 143, 299 },
      0,
   } },
   /* search329_1 -> 919 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_imul,
      0, 2,
      { 1175, 919 },
      -1,
   } },

   /* replace329_0_0 -> 143 in the cache */
   /* replace329_0_1 -> 146 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_imul,
      1, 1,
      { 143, 146 },
      -1,
   } },
   /* replace329_1_0 -> 144 in the cache */
   /* replace329_1_1 -> 146 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_imul,
      2, 1,
      { 144, 146 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_iadd,
      0, 3,
      { 1177, 1178 },
      -1,
   } },

   /* ('imul', ('iadd(is_used_once)', ('iadd(is_used_once)', 'a', '#b'), 'c'), '#d') => ('iadd', ('imul', ('iadd', 'a', 'c'), 'd'), ('imul', 'b', 'd')) */
   /* search330_0_0_0 -> 166 in the cache */
   { .variable = {
      { nir_search_value_variable, -4 },
      1, /* b */
      true,
      nir_type_invalid,
      -1,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .expression = {
      { nir_search_value_expression, -4 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_iadd,
      2, 1,
      { 166, 1180 },
      0,
   } },
   /* search330_0_1 -> 169 in the cache */
   { .expression = {
      { nir_search_value_expression, -4 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_iadd,
      1, 2,
      { 1181, 169 },
      0,
   } },
   { .variable = {
      { nir_search_value_variable, -4 },
      3, /* d */
      true,
      nir_type_invalid,
      -1,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .expression = {
      { nir_search_value_expression, -4 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_imul,
      0, 3,
      { 1182, 1183 },
      -1,
   } },

   /* replace330_0_0_0 -> 166 in the cache */
   /* replace330_0_0_1 -> 169 in the cache */
   { .expression = {
      { nir_search_value_expression, -4 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_iadd,
      2, 1,
      { 166, 169 },
      -1,
   } },
   /* replace330_0_1 -> 170 in the cache */
   { .expression = {
      { nir_search_value_expression, -4 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_imul,
      1, 2,
      { 1185, 170 },
      -1,
   } },
   /* replace330_1_0 -> 167 in the cache */
   /* replace330_1_1 -> 170 in the cache */
   { .expression = {
      { nir_search_value_expression, -4 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_imul,
      3, 1,
      { 167, 170 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -4 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_iadd,
      0, 4,
      { 1186, 1187 },
      -1,
   } },

   /* ('ishl', ('iadd(is_used_once)', ('iadd(is_used_once)', 'a', '#b'), 'c'), '#d') => ('iadd', ('ishl', ('iadd', 'a', 'c'), 'd'), ('ishl', 'b', 'd')) */
   /* search331_0_0_0 -> 143 in the cache */
   /* search331_0_0_1 -> 299 in the cache */
   /* search331_0_0 -> 1175 in the cache */
   /* search331_0_1 -> 146 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_iadd,
      0, 2,
      { 1175, 146 },
      0,
   } },
   /* search331_1 -> 327 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ishl,
      -1, 2,
      { 1189, 327 },
      -1,
   } },

   /* replace331_0_0_0 -> 143 in the cache */
   /* replace331_0_0_1 -> 146 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_iadd,
      1, 1,
      { 143, 146 },
      -1,
   } },
   /* replace331_0_1 -> 180 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ishl,
      -1, 1,
      { 1191, 180 },
      -1,
   } },
   /* replace331_1_0 -> 144 in the cache */
   /* replace331_1_1 -> 180 in the cache */
   /* replace331_1 -> 922 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_iadd,
      0, 2,
      { 1192, 922 },
      -1,
   } },

   /* ('inot', ('flt(is_used_once)', 'a(is_a_number)', 'b(is_a_number)')) => ('fge', 'a', 'b') */
   { .variable = {
      { nir_search_value_variable, -2 },
      0, /* a */
      false,
      nir_type_invalid,
      19,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .variable = {
      { nir_search_value_variable, -2 },
      1, /* b */
      false,
      nir_type_invalid,
      19,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_flt,
      -1, 0,
      { 1194, 1195 },
      0,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_inot,
      -1, 0,
      { 1196 },
      -1,
   } },

   /* replace332_0 -> 0 in the cache */
   /* replace332_1 -> 1 in the cache */
   /* replace332 -> 6 in the cache */

   /* ('inot', ('fge(is_used_once)', 'a(is_a_number)', 'b(is_a_number)')) => ('flt', 'a', 'b') */
   /* search333_0_0 -> 1194 in the cache */
   /* search333_0_1 -> 1195 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fge,
      -1, 0,
      { 1194, 1195 },
      0,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_inot,
      -1, 0,
      { 1198 },
      -1,
   } },

   /* replace333_0 -> 0 in the cache */
   /* replace333_1 -> 1 in the cache */
   /* replace333 -> 3 in the cache */

   /* ('inot', ('feq(is_used_once)', 'a', 'b')) => ('fneu', 'a', 'b') */
   /* search334_0_0 -> 0 in the cache */
   /* search334_0_1 -> 1 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_feq,
      0, 1,
      { 0, 1 },
      0,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_inot,
      -1, 1,
      { 1200 },
      -1,
   } },

   /* replace334_0 -> 0 in the cache */
   /* replace334_1 -> 1 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fneu,
      0, 1,
      { 0, 1 },
      -1,
   } },

   /* ('inot', ('fneu(is_used_once)', 'a', 'b')) => ('feq', 'a', 'b') */
   /* search335_0_0 -> 0 in the cache */
   /* search335_0_1 -> 1 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fneu,
      0, 1,
      { 0, 1 },
      0,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_inot,
      -1, 1,
      { 1203 },
      -1,
   } },

   /* replace335_0 -> 0 in the cache */
   /* replace335_1 -> 1 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_feq,
      0, 1,
      { 0, 1 },
      -1,
   } },

   /* ('inot', ('ilt(is_used_once)', 'a', 'b')) => ('ige', 'a', 'b') */
   /* search336_0_0 -> 0 in the cache */
   /* search336_0_1 -> 1 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ilt,
      -1, 0,
      { 0, 1 },
      0,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_inot,
      -1, 0,
      { 1206 },
      -1,
   } },

   /* replace336_0 -> 0 in the cache */
   /* replace336_1 -> 1 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ige,
      -1, 0,
      { 0, 1 },
      -1,
   } },

   /* ('inot', ('ult(is_used_once)', 'a', 'b')) => ('uge', 'a', 'b') */
   /* search337_0_0 -> 0 in the cache */
   /* search337_0_1 -> 1 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ult,
      -1, 0,
      { 0, 1 },
      0,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_inot,
      -1, 0,
      { 1209 },
      -1,
   } },

   /* replace337_0 -> 0 in the cache */
   /* replace337_1 -> 1 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_uge,
      -1, 0,
      { 0, 1 },
      -1,
   } },

   /* ('inot', ('ige(is_used_once)', 'a', 'b')) => ('ilt', 'a', 'b') */
   /* search338_0_0 -> 0 in the cache */
   /* search338_0_1 -> 1 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ige,
      -1, 0,
      { 0, 1 },
      0,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_inot,
      -1, 0,
      { 1212 },
      -1,
   } },

   /* replace338_0 -> 0 in the cache */
   /* replace338_1 -> 1 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ilt,
      -1, 0,
      { 0, 1 },
      -1,
   } },

   /* ('inot', ('uge(is_used_once)', 'a', 'b')) => ('ult', 'a', 'b') */
   /* search339_0_0 -> 0 in the cache */
   /* search339_0_1 -> 1 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_uge,
      -1, 0,
      { 0, 1 },
      0,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_inot,
      -1, 0,
      { 1215 },
      -1,
   } },

   /* replace339_0 -> 0 in the cache */
   /* replace339_1 -> 1 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ult,
      -1, 0,
      { 0, 1 },
      -1,
   } },

   /* ('inot', ('ieq(is_used_once)', 'a', 'b')) => ('ine', 'a', 'b') */
   /* search340_0_0 -> 0 in the cache */
   /* search340_0_1 -> 1 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ieq,
      0, 1,
      { 0, 1 },
      0,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_inot,
      -1, 1,
      { 1218 },
      -1,
   } },

   /* replace340_0 -> 0 in the cache */
   /* replace340_1 -> 1 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ine,
      0, 1,
      { 0, 1 },
      -1,
   } },

   /* ('inot', ('ine(is_used_once)', 'a', 'b')) => ('ieq', 'a', 'b') */
   /* search341_0_0 -> 0 in the cache */
   /* search341_0_1 -> 1 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ine,
      0, 1,
      { 0, 1 },
      0,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_inot,
      -1, 1,
      { 1221 },
      -1,
   } },

   /* replace341_0 -> 0 in the cache */
   /* replace341_1 -> 1 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ieq,
      0, 1,
      { 0, 1 },
      -1,
   } },

   /* ('iand', ('feq', 'a', 'b'), ('fneu', 'a', 'b')) => False */
   /* search342_0_0 -> 0 in the cache */
   /* search342_0_1 -> 1 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_feq,
      1, 1,
      { 0, 1 },
      -1,
   } },
   /* search342_1_0 -> 0 in the cache */
   /* search342_1_1 -> 1 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fneu,
      2, 1,
      { 0, 1 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_iand,
      0, 3,
      { 1224, 1225 },
      -1,
   } },

   { .constant = {
      { nir_search_value_constant, 1 },
      nir_type_bool, { NIR_FALSE /* False */ },
   } },

   /* ('iand', ('flt', 'a', 'b'), ('flt', 'b', 'a')) => False */
   /* search343_0_0 -> 0 in the cache */
   /* search343_0_1 -> 1 in the cache */
   /* search343_0 -> 3 in the cache */
   /* search343_1_0 -> 1 in the cache */
   /* search343_1_1 -> 0 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_flt,
      -1, 0,
      { 1, 0 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_iand,
      0, 1,
      { 3, 1228 },
      -1,
   } },

   /* replace343 -> 1227 in the cache */

   /* ('iand', ('ieq', 'a', 'b'), ('ine', 'a', 'b')) => False */
   /* search344_0_0 -> 0 in the cache */
   /* search344_0_1 -> 1 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ieq,
      1, 1,
      { 0, 1 },
      -1,
   } },
   /* search344_1_0 -> 0 in the cache */
   /* search344_1_1 -> 1 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ine,
      2, 1,
      { 0, 1 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_iand,
      0, 3,
      { 1230, 1231 },
      -1,
   } },

   /* replace344 -> 1227 in the cache */

   /* ('iand', ('ilt', 'a', 'b'), ('ilt', 'b', 'a')) => False */
   /* search345_0_0 -> 0 in the cache */
   /* search345_0_1 -> 1 in the cache */
   /* search345_0 -> 1214 in the cache */
   /* search345_1_0 -> 1 in the cache */
   /* search345_1_1 -> 0 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ilt,
      -1, 0,
      { 1, 0 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_iand,
      0, 1,
      { 1214, 1233 },
      -1,
   } },

   /* replace345 -> 1227 in the cache */

   /* ('iand', ('ult', 'a', 'b'), ('ult', 'b', 'a')) => False */
   /* search346_0_0 -> 0 in the cache */
   /* search346_0_1 -> 1 in the cache */
   /* search346_0 -> 1217 in the cache */
   /* search346_1_0 -> 1 in the cache */
   /* search346_1_1 -> 0 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ult,
      -1, 0,
      { 1, 0 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_iand,
      0, 1,
      { 1217, 1235 },
      -1,
   } },

   /* replace346 -> 1227 in the cache */

   /* ('flt', ('fneg', 'a'), ('fneg', 'b')) => ('flt', 'b', 'a') */
   /* search347_0_0 -> 0 in the cache */
   /* search347_0 -> 132 in the cache */
   /* search347_1_0 -> 1 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fneg,
      -1, 0,
      { 1 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_flt,
      -1, 0,
      { 132, 1237 },
      -1,
   } },

   /* replace347_0 -> 1 in the cache */
   /* replace347_1 -> 0 in the cache */
   /* replace347 -> 1228 in the cache */

   /* ('fge', ('fneg', 'a'), ('fneg', 'b')) => ('fge', 'b', 'a') */
   /* search348_0_0 -> 0 in the cache */
   /* search348_0 -> 132 in the cache */
   /* search348_1_0 -> 1 in the cache */
   /* search348_1 -> 1237 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fge,
      -1, 0,
      { 132, 1237 },
      -1,
   } },

   /* replace348_0 -> 1 in the cache */
   /* replace348_1 -> 0 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fge,
      -1, 0,
      { 1, 0 },
      -1,
   } },

   /* ('feq', ('fneg', 'a'), ('fneg', 'b')) => ('feq', 'b', 'a') */
   /* search349_0_0 -> 0 in the cache */
   /* search349_0 -> 132 in the cache */
   /* search349_1_0 -> 1 in the cache */
   /* search349_1 -> 1237 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_feq,
      0, 1,
      { 132, 1237 },
      -1,
   } },

   /* replace349_0 -> 1 in the cache */
   /* replace349_1 -> 0 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_feq,
      0, 1,
      { 1, 0 },
      -1,
   } },

   /* ('fneu', ('fneg', 'a'), ('fneg', 'b')) => ('fneu', 'b', 'a') */
   /* search350_0_0 -> 0 in the cache */
   /* search350_0 -> 132 in the cache */
   /* search350_1_0 -> 1 in the cache */
   /* search350_1 -> 1237 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fneu,
      0, 1,
      { 132, 1237 },
      -1,
   } },

   /* replace350_0 -> 1 in the cache */
   /* replace350_1 -> 0 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fneu,
      0, 1,
      { 1, 0 },
      -1,
   } },

   /* ('flt', ('fneg', 'a(is_not_const)'), '#b') => ('flt', ('fneg', 'b'), 'a') */
   { .variable = {
      { nir_search_value_variable, -2 },
      0, /* a */
      false,
      nir_type_invalid,
      6,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fneg,
      -1, 0,
      { 1245 },
      -1,
   } },
   /* search351_1 -> 926 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_flt,
      -1, 0,
      { 1246, 926 },
      -1,
   } },

   /* replace351_0_0 -> 1 in the cache */
   /* replace351_0 -> 1237 in the cache */
   /* replace351_1 -> 0 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_flt,
      -1, 0,
      { 1237, 0 },
      -1,
   } },

   /* ('flt', '#b', ('fneg', 'a(is_not_const)')) => ('flt', 'a', ('fneg', 'b')) */
   { .variable = {
      { nir_search_value_variable, -2 },
      0, /* b */
      true,
      nir_type_invalid,
      -1,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .variable = {
      { nir_search_value_variable, -2 },
      1, /* a */
      false,
      nir_type_invalid,
      6,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fneg,
      -1, 0,
      { 1250 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_flt,
      -1, 0,
      { 1249, 1251 },
      -1,
   } },

   { .variable = {
      { nir_search_value_variable, -2 },
      1, /* a */
      false,
      nir_type_invalid,
      -1,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .variable = {
      { nir_search_value_variable, -2 },
      0, /* b */
      false,
      nir_type_invalid,
      -1,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fneg,
      -1, 0,
      { 1254 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_flt,
      -1, 0,
      { 1253, 1255 },
      -1,
   } },

   /* ('fge', ('fneg', 'a(is_not_const)'), '#b') => ('fge', ('fneg', 'b'), 'a') */
   /* search353_0_0 -> 1245 in the cache */
   /* search353_0 -> 1246 in the cache */
   /* search353_1 -> 926 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fge,
      -1, 0,
      { 1246, 926 },
      -1,
   } },

   /* replace353_0_0 -> 1 in the cache */
   /* replace353_0 -> 1237 in the cache */
   /* replace353_1 -> 0 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fge,
      -1, 0,
      { 1237, 0 },
      -1,
   } },

   /* ('fge', '#b', ('fneg', 'a(is_not_const)')) => ('fge', 'a', ('fneg', 'b')) */
   /* search354_0 -> 1249 in the cache */
   /* search354_1_0 -> 1250 in the cache */
   /* search354_1 -> 1251 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fge,
      -1, 0,
      { 1249, 1251 },
      -1,
   } },

   /* replace354_0 -> 1253 in the cache */
   /* replace354_1_0 -> 1254 in the cache */
   /* replace354_1 -> 1255 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fge,
      -1, 0,
      { 1253, 1255 },
      -1,
   } },

   /* ('fneu', ('fneg', 'a(is_not_const)'), '#b') => ('fneu', ('fneg', 'b'), 'a') */
   /* search355_0_0 -> 1245 in the cache */
   /* search355_0 -> 1246 in the cache */
   /* search355_1 -> 926 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fneu,
      0, 1,
      { 1246, 926 },
      -1,
   } },

   /* replace355_0_0 -> 1 in the cache */
   /* replace355_0 -> 1237 in the cache */
   /* replace355_1 -> 0 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fneu,
      0, 1,
      { 1237, 0 },
      -1,
   } },

   /* ('feq', '#b', ('fneg', 'a(is_not_const)')) => ('feq', 'a', ('fneg', 'b')) */
   /* search356_0 -> 1249 in the cache */
   /* search356_1_0 -> 1250 in the cache */
   /* search356_1 -> 1251 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_feq,
      0, 1,
      { 1249, 1251 },
      -1,
   } },

   /* replace356_0 -> 1253 in the cache */
   /* replace356_1_0 -> 1254 in the cache */
   /* replace356_1 -> 1255 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_feq,
      0, 1,
      { 1253, 1255 },
      -1,
   } },

   /* ('flt', 'a', '#b(is_negative_zero)') => ('flt', 'a', 0.0) */
   /* search357_0 -> 0 in the cache */
   /* search357_1 -> 130 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_flt,
      -1, 0,
      { 0, 130 },
      -1,
   } },

   /* replace357_0 -> 0 in the cache */
   /* replace357_1 -> 276 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_flt,
      -1, 0,
      { 0, 276 },
      -1,
   } },

   /* ('flt', '#b(is_negative_zero)', 'a') => ('flt', 0.0, 'a') */
   { .variable = {
      { nir_search_value_variable, -2 },
      0, /* b */
      true,
      nir_type_invalid,
      3,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   /* search358_1 -> 1253 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_flt,
      -1, 0,
      { 1267, 1253 },
      -1,
   } },

   /* replace358_0 -> 276 in the cache */
   /* replace358_1 -> 1253 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_flt,
      -1, 0,
      { 276, 1253 },
      -1,
   } },

   /* ('fge', 'a', '#b(is_negative_zero)') => ('fge', 'a', 0.0) */
   /* search359_0 -> 0 in the cache */
   /* search359_1 -> 130 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fge,
      -1, 0,
      { 0, 130 },
      -1,
   } },

   /* replace359_0 -> 0 in the cache */
   /* replace359_1 -> 276 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fge,
      -1, 0,
      { 0, 276 },
      -1,
   } },

   /* ('fge', '#b(is_negative_zero)', 'a') => ('fge', 0.0, 'a') */
   /* search360_0 -> 1267 in the cache */
   /* search360_1 -> 1253 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fge,
      -1, 0,
      { 1267, 1253 },
      -1,
   } },

   /* replace360_0 -> 276 in the cache */
   /* replace360_1 -> 1253 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fge,
      -1, 0,
      { 276, 1253 },
      -1,
   } },

   /* ('fneu', 'a', '#b(is_negative_zero)') => ('fneu', 0.0, 'a') */
   /* search361_0 -> 0 in the cache */
   /* search361_1 -> 130 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fneu,
      0, 1,
      { 0, 130 },
      -1,
   } },

   /* replace361_0 -> 276 in the cache */
   /* replace361_1 -> 0 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fneu,
      0, 1,
      { 276, 0 },
      -1,
   } },

   /* ('feq', '#b(is_negative_zero)', 'a') => ('feq', 'a', 0.0) */
   /* search362_0 -> 1267 in the cache */
   /* search362_1 -> 1253 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_feq,
      0, 1,
      { 1267, 1253 },
      -1,
   } },

   /* replace362_0 -> 1253 in the cache */
   /* replace362_1 -> 276 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_feq,
      0, 1,
      { 1253, 276 },
      -1,
   } },

   /* ('ieq', ('ineg', 'a'), 0) => ('ieq', 'a', 0) */
   /* search363_0_0 -> 9 in the cache */
   /* search363_0 -> 120 in the cache */
   /* search363_1 -> 73 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ieq,
      0, 1,
      { 120, 73 },
      -1,
   } },

   /* replace363_0 -> 9 in the cache */
   /* replace363_1 -> 73 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ieq,
      0, 1,
      { 9, 73 },
      -1,
   } },

   /* ('ine', ('ineg', 'a'), 0) => ('ine', 'a', 0) */
   /* search364_0_0 -> 9 in the cache */
   /* search364_0 -> 120 in the cache */
   /* search364_1 -> 73 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ine,
      0, 1,
      { 120, 73 },
      -1,
   } },

   /* replace364_0 -> 9 in the cache */
   /* replace364_1 -> 73 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ine,
      0, 1,
      { 9, 73 },
      -1,
   } },

   /* ('ieq', ('iabs', 'a'), 0) => ('ieq', 'a', 0) */
   /* search365_0_0 -> 9 in the cache */
   /* search365_0 -> 125 in the cache */
   /* search365_1 -> 73 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ieq,
      0, 1,
      { 125, 73 },
      -1,
   } },

   /* replace365_0 -> 9 in the cache */
   /* replace365_1 -> 73 in the cache */
   /* replace365 -> 1279 in the cache */

   /* ('ine', ('iabs', 'a'), 0) => ('ine', 'a', 0) */
   /* search366_0_0 -> 9 in the cache */
   /* search366_0 -> 125 in the cache */
   /* search366_1 -> 73 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ine,
      0, 1,
      { 125, 73 },
      -1,
   } },

   /* replace366_0 -> 9 in the cache */
   /* replace366_1 -> 73 in the cache */
   /* replace366 -> 1281 in the cache */

   /* ('fneu', ('fabs', 'a'), 0.0) => ('fneu', 'a', 0.0) */
   /* search367_0_0 -> 9 in the cache */
   /* search367_0 -> 11 in the cache */
   /* search367_1 -> 8 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fneu,
      0, 1,
      { 11, 8 },
      -1,
   } },

   /* replace367_0 -> 9 in the cache */
   /* replace367_1 -> 8 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fneu,
      0, 1,
      { 9, 8 },
      -1,
   } },

   /* ('feq', ('fabs', 'a'), 0.0) => ('feq', 'a', 0.0) */
   /* search368_0_0 -> 9 in the cache */
   /* search368_0 -> 11 in the cache */
   /* search368_1 -> 8 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_feq,
      0, 1,
      { 11, 8 },
      -1,
   } },

   /* replace368_0 -> 9 in the cache */
   /* replace368_1 -> 8 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_feq,
      0, 1,
      { 9, 8 },
      -1,
   } },

   /* ('fneu', ('fabs', 'a'), ('fabs', 'a')) => ('fneu', 'a', 'a') */
   /* search369_0_0 -> 9 in the cache */
   /* search369_0 -> 11 in the cache */
   /* search369_1_0 -> 9 in the cache */
   /* search369_1 -> 11 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fneu,
      -1, 0,
      { 11, 11 },
      -1,
   } },

   /* replace369_0 -> 9 in the cache */
   /* replace369_1 -> 9 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fneu,
      -1, 0,
      { 9, 9 },
      -1,
   } },

   /* ('feq', ('fabs', 'a'), ('fabs', 'a')) => ('feq', 'a', 'a') */
   /* search370_0_0 -> 9 in the cache */
   /* search370_0 -> 11 in the cache */
   /* search370_1_0 -> 9 in the cache */
   /* search370_1 -> 11 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_feq,
      -1, 0,
      { 11, 11 },
      -1,
   } },

   /* replace370_0 -> 9 in the cache */
   /* replace370_1 -> 9 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_feq,
      -1, 0,
      { 9, 9 },
      -1,
   } },

   /* ('flt', '#b(is_gt_0_and_lt_1)', ('fsat(is_used_once)', 'a')) => ('flt', 'b', 'a') */
   { .variable = {
      { nir_search_value_variable, -2 },
      0, /* b */
      true,
      nir_type_invalid,
      20,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   /* search371_1_0 -> 1253 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fsat,
      -1, 0,
      { 1253 },
      0,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_flt,
      -1, 0,
      { 1292, 1293 },
      -1,
   } },

   /* replace371_0 -> 1254 in the cache */
   /* replace371_1 -> 1253 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_flt,
      -1, 0,
      { 1254, 1253 },
      -1,
   } },

   /* ('fge', ('fsat(is_used_once)', 'a'), '#b(is_gt_0_and_lt_1)') => ('fge', 'a', 'b') */
   /* search372_0_0 -> 0 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fsat,
      -1, 0,
      { 0 },
      0,
   } },
   { .variable = {
      { nir_search_value_variable, -2 },
      1, /* b */
      true,
      nir_type_invalid,
      20,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fge,
      -1, 0,
      { 1296, 1297 },
      -1,
   } },

   /* replace372_0 -> 0 in the cache */
   /* replace372_1 -> 1 in the cache */
   /* replace372 -> 6 in the cache */

   /* ('feq', ('fsat(is_used_once)', 'a'), '#b(is_gt_0_and_lt_1)') => ('feq', 'a', 'b') */
   /* search373_0_0 -> 0 in the cache */
   /* search373_0 -> 1296 in the cache */
   /* search373_1 -> 1297 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_feq,
      0, 1,
      { 1296, 1297 },
      -1,
   } },

   /* replace373_0 -> 0 in the cache */
   /* replace373_1 -> 1 in the cache */
   /* replace373 -> 1205 in the cache */

   /* ('fneu', ('fsat(is_used_once)', 'a'), '#b(is_gt_0_and_lt_1)') => ('fneu', 'a', 'b') */
   /* search374_0_0 -> 0 in the cache */
   /* search374_0 -> 1296 in the cache */
   /* search374_1 -> 1297 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fneu,
      0, 1,
      { 1296, 1297 },
      -1,
   } },

   /* replace374_0 -> 0 in the cache */
   /* replace374_1 -> 1 in the cache */
   /* replace374 -> 1202 in the cache */

   /* ('fge', ('fsat(is_used_once)', 'a'), 1.0) => ('fge', 'a', 1.0) */
   /* search375_0_0 -> 9 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fsat,
      -1, 0,
      { 9 },
      0,
   } },
   /* search375_1 -> 262 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fge,
      -1, 0,
      { 1301, 262 },
      -1,
   } },

   /* replace375_0 -> 9 in the cache */
   /* replace375_1 -> 262 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fge,
      -1, 0,
      { 9, 262 },
      -1,
   } },

   /* ('flt', 0.0, ('fsat(is_used_once)', 'a')) => ('flt', 0.0, 'a') */
   /* search376_0 -> 8 in the cache */
   /* search376_1_0 -> 9 in the cache */
   /* search376_1 -> 1301 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_flt,
      -1, 0,
      { 8, 1301 },
      -1,
   } },

   /* replace376_0 -> 8 in the cache */
   /* replace376_1 -> 9 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_flt,
      -1, 0,
      { 8, 9 },
      -1,
   } },

   /* ('fge', 0.0, ('b2f', 'a@1')) => ('inot', 'a') */
   { .constant = {
      { nir_search_value_constant, 0 },
      nir_type_float, { 0x0ull /* 0.0 */ },
   } },
   /* search377_1_0 -> 862 in the cache */
   { .expression = {
      { nir_search_value_expression, 0 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_search_op_b2f,
      -1, 0,
      { 862 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fge,
      -1, 0,
      { 1306, 1307 },
      -1,
   } },

   /* replace377_0 -> 862 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_inot,
      -1, 0,
      { 862 },
      -1,
   } },

   /* ('fge', ('fneg', ('b2f', 'a@1')), 0.0) => ('inot', 'a') */
   /* search378_0_0_0 -> 862 in the cache */
   /* search378_0_0 -> 1307 in the cache */
   { .expression = {
      { nir_search_value_expression, 0 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fneg,
      -1, 0,
      { 1307 },
      -1,
   } },
   /* search378_1 -> 1306 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fge,
      -1, 0,
      { 1310, 1306 },
      -1,
   } },

   /* replace378_0 -> 862 in the cache */
   /* replace378 -> 1309 in the cache */

   /* ('fneu', ('fadd', ('b2f', 'a@1'), ('b2f', 'b@1')), 0.0) => ('ior', 'a', 'b') */
   /* search379_0_0_0 -> 862 in the cache */
   /* search379_0_0 -> 1307 in the cache */
   { .variable = {
      { nir_search_value_variable, 1 },
      1, /* b */
      false,
      nir_type_invalid,
      -1,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .expression = {
      { nir_search_value_expression, 0 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_search_op_b2f,
      -1, 0,
      { 1312 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 0 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fadd,
      1, 1,
      { 1307, 1313 },
      -1,
   } },
   /* search379_1 -> 1306 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fneu,
      0, 2,
      { 1314, 1306 },
      -1,
   } },

   /* replace379_0 -> 862 in the cache */
   /* replace379_1 -> 1312 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ior,
      0, 1,
      { 862, 1312 },
      -1,
   } },

   /* ('fneu', ('bcsel', 'a', 1.0, ('b2f', 'b@1')), 0.0) => ('ior', 'a', 'b') */
   /* search380_0_0 -> 862 in the cache */
   { .constant = {
      { nir_search_value_constant, 0 },
      nir_type_float, { 0x3ff0000000000000ull /* 1.0 */ },
   } },
   /* search380_0_2_0 -> 1312 in the cache */
   /* search380_0_2 -> 1313 in the cache */
   { .expression = {
      { nir_search_value_expression, 0 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_bcsel,
      -1, 0,
      { 862, 1317, 1313 },
      -1,
   } },
   /* search380_1 -> 1306 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fneu,
      0, 1,
      { 1318, 1306 },
      -1,
   } },

   /* replace380_0 -> 862 in the cache */
   /* replace380_1 -> 1312 in the cache */
   /* replace380 -> 1316 in the cache */

   /* ('fneu', ('b2f', 'a@1'), ('fneg', ('b2f', 'b@1'))) => ('ior', 'a', 'b') */
   /* search381_0_0 -> 862 in the cache */
   /* search381_0 -> 1307 in the cache */
   /* search381_1_0_0 -> 1312 in the cache */
   /* search381_1_0 -> 1313 in the cache */
   { .expression = {
      { nir_search_value_expression, 0 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fneg,
      -1, 0,
      { 1313 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fneu,
      0, 1,
      { 1307, 1320 },
      -1,
   } },

   /* replace381_0 -> 862 in the cache */
   /* replace381_1 -> 1312 in the cache */
   /* replace381 -> 1316 in the cache */

   /* ('fneu', ('fmul', ('b2f', 'a@1'), ('b2f', 'b@1')), 0.0) => ('iand', 'a', 'b') */
   /* search382_0_0_0 -> 862 in the cache */
   /* search382_0_0 -> 1307 in the cache */
   /* search382_0_1_0 -> 1312 in the cache */
   /* search382_0_1 -> 1313 in the cache */
   { .expression = {
      { nir_search_value_expression, 0 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fmul,
      1, 1,
      { 1307, 1313 },
      -1,
   } },
   /* search382_1 -> 1306 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fneu,
      0, 2,
      { 1322, 1306 },
      -1,
   } },

   /* replace382_0 -> 862 in the cache */
   /* replace382_1 -> 1312 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_iand,
      0, 1,
      { 862, 1312 },
      -1,
   } },

   /* ('fneu', ('bcsel', 'a', ('b2f', 'b@1'), 0.0), 0.0) => ('iand', 'a', 'b') */
   /* search383_0_0 -> 862 in the cache */
   /* search383_0_1_0 -> 1312 in the cache */
   /* search383_0_1 -> 1313 in the cache */
   /* search383_0_2 -> 1306 in the cache */
   { .expression = {
      { nir_search_value_expression, 0 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_bcsel,
      -1, 0,
      { 862, 1313, 1306 },
      -1,
   } },
   /* search383_1 -> 1306 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fneu,
      0, 1,
      { 1325, 1306 },
      -1,
   } },

   /* replace383_0 -> 862 in the cache */
   /* replace383_1 -> 1312 in the cache */
   /* replace383 -> 1324 in the cache */

   /* ('fneu', ('fadd', ('b2f', 'a@1'), ('fneg', ('b2f', 'b@1'))), 0.0) => ('ixor', 'a', 'b') */
   /* search384_0_0_0 -> 862 in the cache */
   /* search384_0_0 -> 1307 in the cache */
   /* search384_0_1_0_0 -> 1312 in the cache */
   /* search384_0_1_0 -> 1313 in the cache */
   /* search384_0_1 -> 1320 in the cache */
   { .expression = {
      { nir_search_value_expression, 0 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fadd,
      1, 1,
      { 1307, 1320 },
      -1,
   } },
   /* search384_1 -> 1306 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fneu,
      0, 2,
      { 1327, 1306 },
      -1,
   } },

   /* replace384_0 -> 862 in the cache */
   /* replace384_1 -> 1312 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ixor,
      0, 1,
      { 862, 1312 },
      -1,
   } },

   /* ('fneu', ('b2f', 'a@1'), ('b2f', 'b@1')) => ('ixor', 'a', 'b') */
   /* search385_0_0 -> 862 in the cache */
   /* search385_0 -> 1307 in the cache */
   /* search385_1_0 -> 1312 in the cache */
   /* search385_1 -> 1313 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fneu,
      0, 1,
      { 1307, 1313 },
      -1,
   } },

   /* replace385_0 -> 862 in the cache */
   /* replace385_1 -> 1312 in the cache */
   /* replace385 -> 1329 in the cache */

   /* ('fneu', ('fneg', ('b2f', 'a@1')), ('fneg', ('b2f', 'b@1'))) => ('ixor', 'a', 'b') */
   /* search386_0_0_0 -> 862 in the cache */
   /* search386_0_0 -> 1307 in the cache */
   /* search386_0 -> 1310 in the cache */
   /* search386_1_0_0 -> 1312 in the cache */
   /* search386_1_0 -> 1313 in the cache */
   /* search386_1 -> 1320 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fneu,
      0, 1,
      { 1310, 1320 },
      -1,
   } },

   /* replace386_0 -> 862 in the cache */
   /* replace386_1 -> 1312 in the cache */
   /* replace386 -> 1329 in the cache */

   /* ('feq', ('fadd', ('b2f', 'a@1'), ('b2f', 'b@1')), 0.0) => ('inot', ('ior', 'a', 'b')) */
   /* search387_0_0_0 -> 862 in the cache */
   /* search387_0_0 -> 1307 in the cache */
   /* search387_0_1_0 -> 1312 in the cache */
   /* search387_0_1 -> 1313 in the cache */
   /* search387_0 -> 1314 in the cache */
   /* search387_1 -> 1306 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_feq,
      0, 2,
      { 1314, 1306 },
      -1,
   } },

   /* replace387_0_0 -> 862 in the cache */
   /* replace387_0_1 -> 1312 in the cache */
   /* replace387_0 -> 1316 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_inot,
      -1, 1,
      { 1316 },
      -1,
   } },

   /* ('feq', ('bcsel', 'a', 1.0, ('b2f', 'b@1')), 0.0) => ('inot', ('ior', 'a', 'b')) */
   /* search388_0_0 -> 862 in the cache */
   /* search388_0_1 -> 1317 in the cache */
   /* search388_0_2_0 -> 1312 in the cache */
   /* search388_0_2 -> 1313 in the cache */
   /* search388_0 -> 1318 in the cache */
   /* search388_1 -> 1306 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_feq,
      0, 1,
      { 1318, 1306 },
      -1,
   } },

   /* replace388_0_0 -> 862 in the cache */
   /* replace388_0_1 -> 1312 in the cache */
   /* replace388_0 -> 1316 in the cache */
   /* replace388 -> 1333 in the cache */

   /* ('feq', ('b2f', 'a@1'), ('fneg', ('b2f', 'b@1'))) => ('inot', ('ior', 'a', 'b')) */
   /* search389_0_0 -> 862 in the cache */
   /* search389_0 -> 1307 in the cache */
   /* search389_1_0_0 -> 1312 in the cache */
   /* search389_1_0 -> 1313 in the cache */
   /* search389_1 -> 1320 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_feq,
      0, 1,
      { 1307, 1320 },
      -1,
   } },

   /* replace389_0_0 -> 862 in the cache */
   /* replace389_0_1 -> 1312 in the cache */
   /* replace389_0 -> 1316 in the cache */
   /* replace389 -> 1333 in the cache */

   /* ('feq', ('fmul', ('b2f', 'a@1'), ('b2f', 'b@1')), 0.0) => ('inot', ('iand', 'a', 'b')) */
   /* search390_0_0_0 -> 862 in the cache */
   /* search390_0_0 -> 1307 in the cache */
   /* search390_0_1_0 -> 1312 in the cache */
   /* search390_0_1 -> 1313 in the cache */
   /* search390_0 -> 1322 in the cache */
   /* search390_1 -> 1306 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_feq,
      0, 2,
      { 1322, 1306 },
      -1,
   } },

   /* replace390_0_0 -> 862 in the cache */
   /* replace390_0_1 -> 1312 in the cache */
   /* replace390_0 -> 1324 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_inot,
      -1, 1,
      { 1324 },
      -1,
   } },

   /* ('feq', ('bcsel', 'a', ('b2f', 'b@1'), 0.0), 0.0) => ('inot', ('iand', 'a', 'b')) */
   /* search391_0_0 -> 862 in the cache */
   /* search391_0_1_0 -> 1312 in the cache */
   /* search391_0_1 -> 1313 in the cache */
   /* search391_0_2 -> 1306 in the cache */
   /* search391_0 -> 1325 in the cache */
   /* search391_1 -> 1306 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_feq,
      0, 1,
      { 1325, 1306 },
      -1,
   } },

   /* replace391_0_0 -> 862 in the cache */
   /* replace391_0_1 -> 1312 in the cache */
   /* replace391_0 -> 1324 in the cache */
   /* replace391 -> 1337 in the cache */

   /* ('feq', ('fadd', ('b2f', 'a@1'), ('fneg', ('b2f', 'b@1'))), 0.0) => ('ieq', 'a', 'b') */
   /* search392_0_0_0 -> 862 in the cache */
   /* search392_0_0 -> 1307 in the cache */
   /* search392_0_1_0_0 -> 1312 in the cache */
   /* search392_0_1_0 -> 1313 in the cache */
   /* search392_0_1 -> 1320 in the cache */
   /* search392_0 -> 1327 in the cache */
   /* search392_1 -> 1306 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_feq,
      0, 2,
      { 1327, 1306 },
      -1,
   } },

   /* replace392_0 -> 862 in the cache */
   /* replace392_1 -> 1312 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ieq,
      0, 1,
      { 862, 1312 },
      -1,
   } },

   /* ('feq', ('b2f', 'a@1'), ('b2f', 'b@1')) => ('ieq', 'a', 'b') */
   /* search393_0_0 -> 862 in the cache */
   /* search393_0 -> 1307 in the cache */
   /* search393_1_0 -> 1312 in the cache */
   /* search393_1 -> 1313 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_feq,
      0, 1,
      { 1307, 1313 },
      -1,
   } },

   /* replace393_0 -> 862 in the cache */
   /* replace393_1 -> 1312 in the cache */
   /* replace393 -> 1340 in the cache */

   /* ('feq', ('fneg', ('b2f', 'a@1')), ('fneg', ('b2f', 'b@1'))) => ('ieq', 'a', 'b') */
   /* search394_0_0_0 -> 862 in the cache */
   /* search394_0_0 -> 1307 in the cache */
   /* search394_0 -> 1310 in the cache */
   /* search394_1_0_0 -> 1312 in the cache */
   /* search394_1_0 -> 1313 in the cache */
   /* search394_1 -> 1320 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_feq,
      0, 1,
      { 1310, 1320 },
      -1,
   } },

   /* replace394_0 -> 862 in the cache */
   /* replace394_1 -> 1312 in the cache */
   /* replace394 -> 1340 in the cache */

   /* ('flt', ('fneg', ('fadd', ('b2f', 'a@1'), ('b2f', 'b@1'))), 0.0) => ('ior', 'a', 'b') */
   /* search395_0_0_0_0 -> 862 in the cache */
   /* search395_0_0_0 -> 1307 in the cache */
   /* search395_0_0_1_0 -> 1312 in the cache */
   /* search395_0_0_1 -> 1313 in the cache */
   { .expression = {
      { nir_search_value_expression, 0 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fadd,
      0, 1,
      { 1307, 1313 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 0 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fneg,
      -1, 1,
      { 1343 },
      -1,
   } },
   /* search395_1 -> 1306 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_flt,
      -1, 1,
      { 1344, 1306 },
      -1,
   } },

   /* replace395_0 -> 862 in the cache */
   /* replace395_1 -> 1312 in the cache */
   /* replace395 -> 1316 in the cache */

   /* ('flt', 0.0, ('fadd', ('b2f', 'a@1'), ('b2f', 'b@1'))) => ('ior', 'a', 'b') */
   /* search396_0 -> 1306 in the cache */
   /* search396_1_0_0 -> 862 in the cache */
   /* search396_1_0 -> 1307 in the cache */
   /* search396_1_1_0 -> 1312 in the cache */
   /* search396_1_1 -> 1313 in the cache */
   /* search396_1 -> 1343 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_flt,
      -1, 1,
      { 1306, 1343 },
      -1,
   } },

   /* replace396_0 -> 862 in the cache */
   /* replace396_1 -> 1312 in the cache */
   /* replace396 -> 1316 in the cache */

   /* ('fge', ('fneg', ('fadd', ('b2f', 'a@1'), ('b2f', 'b@1'))), 0.0) => ('inot', ('ior', 'a', 'b')) */
   /* search397_0_0_0_0 -> 862 in the cache */
   /* search397_0_0_0 -> 1307 in the cache */
   /* search397_0_0_1_0 -> 1312 in the cache */
   /* search397_0_0_1 -> 1313 in the cache */
   /* search397_0_0 -> 1343 in the cache */
   /* search397_0 -> 1344 in the cache */
   /* search397_1 -> 1306 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fge,
      -1, 1,
      { 1344, 1306 },
      -1,
   } },

   /* replace397_0_0 -> 862 in the cache */
   /* replace397_0_1 -> 1312 in the cache */
   /* replace397_0 -> 1316 in the cache */
   /* replace397 -> 1333 in the cache */

   /* ('fge', 0.0, ('fadd', ('b2f', 'a@1'), ('b2f', 'b@1'))) => ('inot', ('ior', 'a', 'b')) */
   /* search398_0 -> 1306 in the cache */
   /* search398_1_0_0 -> 862 in the cache */
   /* search398_1_0 -> 1307 in the cache */
   /* search398_1_1_0 -> 1312 in the cache */
   /* search398_1_1 -> 1313 in the cache */
   /* search398_1 -> 1343 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fge,
      -1, 1,
      { 1306, 1343 },
      -1,
   } },

   /* replace398_0_0 -> 862 in the cache */
   /* replace398_0_1 -> 1312 in the cache */
   /* replace398_0 -> 1316 in the cache */
   /* replace398 -> 1333 in the cache */

   /* ('flt', 'a', ('fneg', 'a')) => ('flt', 'a', 0.0) */
   /* search399_0 -> 9 in the cache */
   /* search399_1_0 -> 9 in the cache */
   /* search399_1 -> 118 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_flt,
      -1, 0,
      { 9, 118 },
      -1,
   } },

   /* replace399_0 -> 9 in the cache */
   /* replace399_1 -> 8 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_flt,
      -1, 0,
      { 9, 8 },
      -1,
   } },

   /* ('fge', 'a', ('fneg', 'a')) => ('fge', 'a', 0.0) */
   /* search400_0 -> 9 in the cache */
   /* search400_1_0 -> 9 in the cache */
   /* search400_1 -> 118 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fge,
      -1, 0,
      { 9, 118 },
      -1,
   } },

   /* replace400_0 -> 9 in the cache */
   /* replace400_1 -> 8 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fge,
      -1, 0,
      { 9, 8 },
      -1,
   } },

   /* ('flt', ('fmin', 'c', ('fneg', ('fadd', ('b2f', 'a@1'), ('b2f', 'b@1')))), 0.0) => ('ior', ('flt', 'c', 0.0), ('ior', 'a', 'b')) */
   { .variable = {
      { nir_search_value_variable, -1 },
      0, /* c */
      false,
      nir_type_invalid,
      -1,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .variable = {
      { nir_search_value_variable, 1 },
      1, /* a */
      false,
      nir_type_invalid,
      -1,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_search_op_b2f,
      -1, 0,
      { 1354 },
      -1,
   } },
   { .variable = {
      { nir_search_value_variable, 1 },
      2, /* b */
      false,
      nir_type_invalid,
      -1,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_search_op_b2f,
      -1, 0,
      { 1356 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fadd,
      1, 1,
      { 1355, 1357 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fneg,
      -1, 1,
      { 1358 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fmin,
      0, 2,
      { 1353, 1359 },
      -1,
   } },
   /* search401_1 -> 8 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_flt,
      -1, 2,
      { 1360, 8 },
      -1,
   } },

   /* replace401_0_0 -> 1353 in the cache */
   /* replace401_0_1 -> 8 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_flt,
      -1, 0,
      { 1353, 8 },
      -1,
   } },
   /* replace401_1_0 -> 1354 in the cache */
   /* replace401_1_1 -> 1356 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ior,
      1, 1,
      { 1354, 1356 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ior,
      0, 2,
      { 1362, 1363 },
      -1,
   } },

   /* ('~flt', ('fadd', 'a', 'b'), 'a') => ('flt', 'b', 0.0) */
   /* search402_0_0 -> 0 in the cache */
   /* search402_0_1 -> 1 in the cache */
   /* search402_0 -> 288 in the cache */
   /* search402_1 -> 0 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      true,
      false,
      false,
      false,
      false,
      false,
      nir_op_flt,
      -1, 1,
      { 288, 0 },
      -1,
   } },

   /* replace402_0 -> 1 in the cache */
   /* replace402_1 -> 276 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_flt,
      -1, 0,
      { 1, 276 },
      -1,
   } },

   /* ('~fge', ('fadd', 'a', 'b'), 'a') => ('fge', 'b', 0.0) */
   /* search403_0_0 -> 0 in the cache */
   /* search403_0_1 -> 1 in the cache */
   /* search403_0 -> 288 in the cache */
   /* search403_1 -> 0 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      true,
      false,
      false,
      false,
      false,
      false,
      nir_op_fge,
      -1, 1,
      { 288, 0 },
      -1,
   } },

   /* replace403_0 -> 1 in the cache */
   /* replace403_1 -> 276 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fge,
      -1, 0,
      { 1, 276 },
      -1,
   } },

   /* ('~feq', ('fadd', 'a', 'b'), 'a') => ('feq', 'b', 0.0) */
   /* search404_0_0 -> 0 in the cache */
   /* search404_0_1 -> 1 in the cache */
   /* search404_0 -> 234 in the cache */
   /* search404_1 -> 0 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      true,
      false,
      false,
      false,
      false,
      false,
      nir_op_feq,
      0, 2,
      { 234, 0 },
      -1,
   } },

   /* replace404_0 -> 1 in the cache */
   /* replace404_1 -> 276 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_feq,
      0, 1,
      { 1, 276 },
      -1,
   } },

   /* ('~fneu', ('fadd', 'a', 'b'), 'a') => ('fneu', 'b', 0.0) */
   /* search405_0_0 -> 0 in the cache */
   /* search405_0_1 -> 1 in the cache */
   /* search405_0 -> 234 in the cache */
   /* search405_1 -> 0 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      true,
      false,
      false,
      false,
      false,
      false,
      nir_op_fneu,
      0, 2,
      { 234, 0 },
      -1,
   } },

   /* replace405_0 -> 1 in the cache */
   /* replace405_1 -> 276 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fneu,
      0, 1,
      { 1, 276 },
      -1,
   } },

   /* ('~flt', ('fadd(is_used_once)', 'a', '#b'), '#c') => ('flt', 'a', ('fadd', 'c', ('fneg', 'b'))) */
   /* search406_0_0 -> 143 in the cache */
   /* search406_0_1 -> 299 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fadd,
      0, 1,
      { 143, 299 },
      0,
   } },
   /* search406_1 -> 919 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      true,
      false,
      false,
      false,
      false,
      false,
      nir_op_flt,
      -1, 1,
      { 1373, 919 },
      -1,
   } },

   /* replace406_0 -> 143 in the cache */
   /* replace406_1_0 -> 146 in the cache */
   /* replace406_1_1_0 -> 144 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fneg,
      -1, 0,
      { 144 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fadd,
      0, 1,
      { 146, 1375 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_flt,
      -1, 1,
      { 143, 1376 },
      -1,
   } },

   /* ('~flt', ('fneg(is_used_once)', ('fadd(is_used_once)', 'a', '#b')), '#c') => ('flt', ('fneg', ('fadd', 'c', 'b')), 'a') */
   /* search407_0_0_0 -> 143 in the cache */
   /* search407_0_0_1 -> 299 in the cache */
   /* search407_0_0 -> 1373 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fneg,
      -1, 1,
      { 1373 },
      0,
   } },
   /* search407_1 -> 919 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      true,
      false,
      false,
      false,
      false,
      false,
      nir_op_flt,
      -1, 1,
      { 1378, 919 },
      -1,
   } },

   /* replace407_0_0_0 -> 146 in the cache */
   /* replace407_0_0_1 -> 144 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fadd,
      0, 1,
      { 146, 144 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fneg,
      -1, 1,
      { 1380 },
      -1,
   } },
   /* replace407_1 -> 143 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_flt,
      -1, 1,
      { 1381, 143 },
      -1,
   } },

   /* ('~fge', ('fadd(is_used_once)', 'a', '#b'), '#c') => ('fge', 'a', ('fadd', 'c', ('fneg', 'b'))) */
   /* search408_0_0 -> 143 in the cache */
   /* search408_0_1 -> 299 in the cache */
   /* search408_0 -> 1373 in the cache */
   /* search408_1 -> 919 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      true,
      false,
      false,
      false,
      false,
      false,
      nir_op_fge,
      -1, 1,
      { 1373, 919 },
      -1,
   } },

   /* replace408_0 -> 143 in the cache */
   /* replace408_1_0 -> 146 in the cache */
   /* replace408_1_1_0 -> 144 in the cache */
   /* replace408_1_1 -> 1375 in the cache */
   /* replace408_1 -> 1376 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fge,
      -1, 1,
      { 143, 1376 },
      -1,
   } },

   /* ('~fge', ('fneg(is_used_once)', ('fadd(is_used_once)', 'a', '#b')), '#c') => ('fge', ('fneg', ('fadd', 'c', 'b')), 'a') */
   /* search409_0_0_0 -> 143 in the cache */
   /* search409_0_0_1 -> 299 in the cache */
   /* search409_0_0 -> 1373 in the cache */
   /* search409_0 -> 1378 in the cache */
   /* search409_1 -> 919 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      true,
      false,
      false,
      false,
      false,
      false,
      nir_op_fge,
      -1, 1,
      { 1378, 919 },
      -1,
   } },

   /* replace409_0_0_0 -> 146 in the cache */
   /* replace409_0_0_1 -> 144 in the cache */
   /* replace409_0_0 -> 1380 in the cache */
   /* replace409_0 -> 1381 in the cache */
   /* replace409_1 -> 143 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fge,
      -1, 1,
      { 1381, 143 },
      -1,
   } },

   /* ('~feq', ('fadd(is_used_once)', 'a', '#b'), '#c') => ('feq', 'a', ('fadd', 'c', ('fneg', 'b'))) */
   /* search410_0_0 -> 143 in the cache */
   /* search410_0_1 -> 299 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fadd,
      1, 1,
      { 143, 299 },
      0,
   } },
   /* search410_1 -> 919 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      true,
      false,
      false,
      false,
      false,
      false,
      nir_op_feq,
      0, 2,
      { 1387, 919 },
      -1,
   } },

   /* replace410_0 -> 143 in the cache */
   /* replace410_1_0 -> 146 in the cache */
   /* replace410_1_1_0 -> 144 in the cache */
   /* replace410_1_1 -> 1375 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fadd,
      1, 1,
      { 146, 1375 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_feq,
      0, 2,
      { 143, 1389 },
      -1,
   } },

   /* ('~feq', ('fneg(is_used_once)', ('fadd(is_used_once)', 'a', '#b')), '#c') => ('feq', ('fneg', ('fadd', 'c', 'b')), 'a') */
   /* search411_0_0_0 -> 143 in the cache */
   /* search411_0_0_1 -> 299 in the cache */
   /* search411_0_0 -> 1387 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fneg,
      -1, 1,
      { 1387 },
      0,
   } },
   /* search411_1 -> 919 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      true,
      false,
      false,
      false,
      false,
      false,
      nir_op_feq,
      0, 2,
      { 1391, 919 },
      -1,
   } },

   /* replace411_0_0_0 -> 146 in the cache */
   /* replace411_0_0_1 -> 144 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fadd,
      1, 1,
      { 146, 144 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fneg,
      -1, 1,
      { 1393 },
      -1,
   } },
   /* replace411_1 -> 143 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_feq,
      0, 2,
      { 1394, 143 },
      -1,
   } },

   /* ('~fneu', ('fadd(is_used_once)', 'a', '#b'), '#c') => ('fneu', 'a', ('fadd', 'c', ('fneg', 'b'))) */
   /* search412_0_0 -> 143 in the cache */
   /* search412_0_1 -> 299 in the cache */
   /* search412_0 -> 1387 in the cache */
   /* search412_1 -> 919 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      true,
      false,
      false,
      false,
      false,
      false,
      nir_op_fneu,
      0, 2,
      { 1387, 919 },
      -1,
   } },

   /* replace412_0 -> 143 in the cache */
   /* replace412_1_0 -> 146 in the cache */
   /* replace412_1_1_0 -> 144 in the cache */
   /* replace412_1_1 -> 1375 in the cache */
   /* replace412_1 -> 1389 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fneu,
      0, 2,
      { 143, 1389 },
      -1,
   } },

   /* ('~fneu', ('fneg(is_used_once)', ('fadd(is_used_once)', 'a', '#b')), '#c') => ('fneu', ('fneg', ('fadd', 'c', 'b')), 'a') */
   /* search413_0_0_0 -> 143 in the cache */
   /* search413_0_0_1 -> 299 in the cache */
   /* search413_0_0 -> 1387 in the cache */
   /* search413_0 -> 1391 in the cache */
   /* search413_1 -> 919 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      true,
      false,
      false,
      false,
      false,
      false,
      nir_op_fneu,
      0, 2,
      { 1391, 919 },
      -1,
   } },

   /* replace413_0_0_0 -> 146 in the cache */
   /* replace413_0_0_1 -> 144 in the cache */
   /* replace413_0_0 -> 1393 in the cache */
   /* replace413_0 -> 1394 in the cache */
   /* replace413_1 -> 143 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fneu,
      0, 2,
      { 1394, 143 },
      -1,
   } },

   /* ('ieq', ('iadd', 'a', 'b'), 'a') => ('ieq', 'b', 0) */
   /* search414_0_0 -> 0 in the cache */
   /* search414_0_1 -> 1 in the cache */
   /* search414_0 -> 230 in the cache */
   /* search414_1 -> 0 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ieq,
      0, 2,
      { 230, 0 },
      -1,
   } },

   /* replace414_0 -> 1 in the cache */
   /* replace414_1 -> 98 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ieq,
      0, 1,
      { 1, 98 },
      -1,
   } },

   /* ('ine', ('iadd', 'a', 'b'), 'a') => ('ine', 'b', 0) */
   /* search415_0_0 -> 0 in the cache */
   /* search415_0_1 -> 1 in the cache */
   /* search415_0 -> 230 in the cache */
   /* search415_1 -> 0 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ine,
      0, 2,
      { 230, 0 },
      -1,
   } },

   /* replace415_0 -> 1 in the cache */
   /* replace415_1 -> 98 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ine,
      0, 1,
      { 1, 98 },
      -1,
   } },

   /* ('feq', ('b2f', 'a@1'), 0.0) => ('inot', 'a') */
   /* search416_0_0 -> 862 in the cache */
   /* search416_0 -> 1307 in the cache */
   /* search416_1 -> 1306 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_feq,
      0, 1,
      { 1307, 1306 },
      -1,
   } },

   /* replace416_0 -> 862 in the cache */
   /* replace416 -> 1309 in the cache */

   /* ('fge', 0.0, ('b2f', 'a@1')) => ('inot', 'a') */
   /* search417_0 -> 1306 in the cache */
   /* search417_1_0 -> 862 in the cache */
   /* search417_1 -> 1307 in the cache */
   /* search417 -> 1308 in the cache */

   /* replace417_0 -> 862 in the cache */
   /* replace417 -> 1309 in the cache */

   /* ('fneu', ('b2f', 'a@1'), 0.0) => a */
   /* search418_0_0 -> 862 in the cache */
   /* search418_0 -> 1307 in the cache */
   /* search418_1 -> 1306 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fneu,
      0, 1,
      { 1307, 1306 },
      -1,
   } },

   /* replace418 -> 862 in the cache */

   /* ('flt', 0.0, ('b2f', 'a@1')) => a */
   /* search419_0 -> 1306 in the cache */
   /* search419_1_0 -> 862 in the cache */
   /* search419_1 -> 1307 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_flt,
      -1, 0,
      { 1306, 1307 },
      -1,
   } },

   /* replace419 -> 862 in the cache */

   /* ('ieq', ('b2i', 'a@1'), 0) => ('inot', 'a') */
   /* search420_0_0 -> 862 in the cache */
   { .expression = {
      { nir_search_value_expression, 0 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_search_op_b2i,
      -1, 0,
      { 862 },
      -1,
   } },
   { .constant = {
      { nir_search_value_constant, 0 },
      nir_type_int, { 0x0ull /* 0 */ },
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ieq,
      0, 1,
      { 1407, 1408 },
      -1,
   } },

   /* replace420_0 -> 862 in the cache */
   /* replace420 -> 1309 in the cache */

   /* ('ine', ('b2i', 'a@1'), 0) => a */
   /* search421_0_0 -> 862 in the cache */
   /* search421_0 -> 1407 in the cache */
   /* search421_1 -> 1408 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ine,
      0, 1,
      { 1407, 1408 },
      -1,
   } },

   /* replace421 -> 862 in the cache */

   /* ('ieq', 'a@1', False) => ('inot', 'a') */
   /* search422_0 -> 862 in the cache */
   /* search422_1 -> 1227 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ieq,
      0, 1,
      { 862, 1227 },
      -1,
   } },

   /* replace422_0 -> 862 in the cache */
   /* replace422 -> 1309 in the cache */

   /* ('ieq', 'a@1', True) => a */
   /* search423_0 -> 862 in the cache */
   { .constant = {
      { nir_search_value_constant, 1 },
      nir_type_bool, { NIR_TRUE /* True */ },
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ieq,
      0, 1,
      { 862, 1412 },
      -1,
   } },

   /* replace423 -> 862 in the cache */

   /* ('ine', 'a@1', False) => a */
   /* search424_0 -> 862 in the cache */
   /* search424_1 -> 1227 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ine,
      0, 1,
      { 862, 1227 },
      -1,
   } },

   /* replace424 -> 862 in the cache */

   /* ('ine', 'a@1', True) => ('inot', 'a') */
   /* search425_0 -> 862 in the cache */
   /* search425_1 -> 1412 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ine,
      0, 1,
      { 862, 1412 },
      -1,
   } },

   /* replace425_0 -> 862 in the cache */
   /* replace425 -> 1309 in the cache */

   /* ('fneu', ('u2f', 'a'), 0.0) => ('ine', 'a', 0) */
   /* search426_0_0 -> 9 in the cache */
   /* search426_0 -> 123 in the cache */
   /* search426_1 -> 1306 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fneu,
      0, 1,
      { 123, 1306 },
      -1,
   } },

   /* replace426_0 -> 9 in the cache */
   /* replace426_1 -> 73 in the cache */
   /* replace426 -> 1281 in the cache */

   /* ('feq', ('u2f', 'a'), 0.0) => ('ieq', 'a', 0) */
   /* search427_0_0 -> 9 in the cache */
   /* search427_0 -> 123 in the cache */
   /* search427_1 -> 1306 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_feq,
      0, 1,
      { 123, 1306 },
      -1,
   } },

   /* replace427_0 -> 9 in the cache */
   /* replace427_1 -> 73 in the cache */
   /* replace427 -> 1279 in the cache */

   /* ('fge', ('u2f', 'a'), 0.0) => True */
   /* search428_0_0 -> 9 in the cache */
   /* search428_0 -> 123 in the cache */
   /* search428_1 -> 1306 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fge,
      -1, 0,
      { 123, 1306 },
      -1,
   } },

   /* replace428 -> 1412 in the cache */

   /* ('fge', 0.0, ('u2f', 'a')) => ('uge', 0, 'a') */
   /* search429_0 -> 1306 in the cache */
   /* search429_1_0 -> 9 in the cache */
   /* search429_1 -> 123 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fge,
      -1, 0,
      { 1306, 123 },
      -1,
   } },

   /* replace429_0 -> 73 in the cache */
   /* replace429_1 -> 9 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_uge,
      -1, 0,
      { 73, 9 },
      -1,
   } },

   /* ('flt', ('u2f', 'a'), 0.0) => False */
   /* search430_0_0 -> 9 in the cache */
   /* search430_0 -> 123 in the cache */
   /* search430_1 -> 1306 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_flt,
      -1, 0,
      { 123, 1306 },
      -1,
   } },

   /* replace430 -> 1227 in the cache */

   /* ('flt', 0.0, ('u2f', 'a')) => ('ult', 0, 'a') */
   /* search431_0 -> 1306 in the cache */
   /* search431_1_0 -> 9 in the cache */
   /* search431_1 -> 123 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_flt,
      -1, 0,
      { 1306, 123 },
      -1,
   } },

   /* replace431_0 -> 73 in the cache */
   /* replace431_1 -> 9 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ult,
      -1, 0,
      { 73, 9 },
      -1,
   } },

   /* ('fneu', ('i2f', 'a'), 0.0) => ('ine', 'a', 0) */
   /* search432_0_0 -> 9 in the cache */
   { .expression = {
      { nir_search_value_expression, 0 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_search_op_i2f,
      -1, 0,
      { 9 },
      -1,
   } },
   /* search432_1 -> 1306 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fneu,
      0, 1,
      { 1424, 1306 },
      -1,
   } },

   /* replace432_0 -> 9 in the cache */
   /* replace432_1 -> 73 in the cache */
   /* replace432 -> 1281 in the cache */

   /* ('feq', ('i2f', 'a'), 0.0) => ('ieq', 'a', 0) */
   /* search433_0_0 -> 9 in the cache */
   /* search433_0 -> 1424 in the cache */
   /* search433_1 -> 1306 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_feq,
      0, 1,
      { 1424, 1306 },
      -1,
   } },

   /* replace433_0 -> 9 in the cache */
   /* replace433_1 -> 73 in the cache */
   /* replace433 -> 1279 in the cache */

   /* ('fge', ('i2f', 'a'), 0.0) => ('ige', 'a', 0) */
   /* search434_0_0 -> 9 in the cache */
   /* search434_0 -> 1424 in the cache */
   /* search434_1 -> 1306 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fge,
      -1, 0,
      { 1424, 1306 },
      -1,
   } },

   /* replace434_0 -> 9 in the cache */
   /* replace434_1 -> 73 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ige,
      -1, 0,
      { 9, 73 },
      -1,
   } },

   /* ('fge', 0.0, ('i2f', 'a')) => ('ige', 0, 'a') */
   /* search435_0 -> 1306 in the cache */
   /* search435_1_0 -> 9 in the cache */
   /* search435_1 -> 1424 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fge,
      -1, 0,
      { 1306, 1424 },
      -1,
   } },

   /* replace435_0 -> 73 in the cache */
   /* replace435_1 -> 9 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ige,
      -1, 0,
      { 73, 9 },
      -1,
   } },

   /* ('flt', ('i2f', 'a'), 0.0) => ('ilt', 'a', 0) */
   /* search436_0_0 -> 9 in the cache */
   /* search436_0 -> 1424 in the cache */
   /* search436_1 -> 1306 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_flt,
      -1, 0,
      { 1424, 1306 },
      -1,
   } },

   /* replace436_0 -> 9 in the cache */
   /* replace436_1 -> 73 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ilt,
      -1, 0,
      { 9, 73 },
      -1,
   } },

   /* ('flt', 0.0, ('i2f', 'a')) => ('ilt', 0, 'a') */
   /* search437_0 -> 1306 in the cache */
   /* search437_1_0 -> 9 in the cache */
   /* search437_1 -> 1424 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_flt,
      -1, 0,
      { 1306, 1424 },
      -1,
   } },

   /* replace437_0 -> 73 in the cache */
   /* replace437_1 -> 9 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ilt,
      -1, 0,
      { 73, 9 },
      -1,
   } },

   /* ('~flt', 0.0, ('fabs', 'a')) => ('fneu', 'a', 0.0) */
   /* search438_0 -> 8 in the cache */
   /* search438_1_0 -> 9 in the cache */
   /* search438_1 -> 11 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      true,
      false,
      false,
      false,
      false,
      false,
      nir_op_flt,
      -1, 0,
      { 8, 11 },
      -1,
   } },

   /* replace438_0 -> 9 in the cache */
   /* replace438_1 -> 8 in the cache */
   /* replace438 -> 1285 in the cache */

   /* ('~flt', ('fneg', ('fabs', 'a')), 0.0) => ('fneu', 'a', 0.0) */
   /* search439_0_0_0 -> 9 in the cache */
   /* search439_0_0 -> 11 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fneg,
      -1, 0,
      { 11 },
      -1,
   } },
   /* search439_1 -> 8 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      true,
      false,
      false,
      false,
      false,
      false,
      nir_op_flt,
      -1, 0,
      { 1436, 8 },
      -1,
   } },

   /* replace439_0 -> 9 in the cache */
   /* replace439_1 -> 8 in the cache */
   /* replace439 -> 1285 in the cache */

   /* ('fge', 0.0, ('fabs', 'a')) => ('feq', 'a', 0.0) */
   /* search440_0 -> 8 in the cache */
   /* search440_1_0 -> 9 in the cache */
   /* search440_1 -> 11 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fge,
      -1, 0,
      { 8, 11 },
      -1,
   } },

   /* replace440_0 -> 9 in the cache */
   /* replace440_1 -> 8 in the cache */
   /* replace440 -> 1287 in the cache */

   /* ('fge', ('fneg', ('fabs', 'a')), 0.0) => ('feq', 'a', 0.0) */
   /* search441_0_0_0 -> 9 in the cache */
   /* search441_0_0 -> 11 in the cache */
   /* search441_0 -> 1436 in the cache */
   /* search441_1 -> 8 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fge,
      -1, 0,
      { 1436, 8 },
      -1,
   } },

   /* replace441_0 -> 9 in the cache */
   /* replace441_1 -> 8 in the cache */
   /* replace441 -> 1287 in the cache */

   /* ('iand', ('fge', 'a', 0.0), ('fge', 1.0, 'a')) => ('feq', 'a', ('fsat', 'a')) */
   /* search442_0_0 -> 9 in the cache */
   /* search442_0_1 -> 8 in the cache */
   /* search442_0 -> 1352 in the cache */
   /* search442_1_0 -> 262 in the cache */
   /* search442_1_1 -> 9 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fge,
      -1, 0,
      { 262, 9 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_iand,
      0, 1,
      { 1352, 1440 },
      -1,
   } },

   /* replace442_0 -> 9 in the cache */
   /* replace442_1_0 -> 9 in the cache */
   /* replace442_1 -> 238 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_feq,
      0, 1,
      { 9, 238 },
      -1,
   } },

   /* ('fmax', ('b2f(is_used_once)', 'a@1'), ('b2f', 'b@1')) => ('b2f', ('ior', 'a', 'b')) */
   /* search443_0_0 -> 862 in the cache */
   { .expression = {
      { nir_search_value_expression, 0 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_search_op_b2f,
      -1, 0,
      { 862 },
      0,
   } },
   /* search443_1_0 -> 1312 in the cache */
   /* search443_1 -> 1313 in the cache */
   { .expression = {
      { nir_search_value_expression, 0 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fmax,
      0, 1,
      { 1443, 1313 },
      -1,
   } },

   /* replace443_0_0 -> 862 in the cache */
   /* replace443_0_1 -> 1312 in the cache */
   /* replace443_0 -> 1316 in the cache */
   { .expression = {
      { nir_search_value_expression, 0 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_search_op_b2f,
      -1, 1,
      { 1316 },
      -1,
   } },

   /* ('fmax', ('fneg(is_used_once)', ('b2f(is_used_once)', 'a@1')), ('fneg', ('b2f', 'b@1'))) => ('fneg', ('b2f', ('iand', 'a', 'b'))) */
   /* search444_0_0_0 -> 862 in the cache */
   /* search444_0_0 -> 1443 in the cache */
   { .expression = {
      { nir_search_value_expression, 0 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fneg,
      -1, 0,
      { 1443 },
      0,
   } },
   /* search444_1_0_0 -> 1312 in the cache */
   /* search444_1_0 -> 1313 in the cache */
   /* search444_1 -> 1320 in the cache */
   { .expression = {
      { nir_search_value_expression, 0 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fmax,
      0, 1,
      { 1446, 1320 },
      -1,
   } },

   /* replace444_0_0_0 -> 862 in the cache */
   /* replace444_0_0_1 -> 1312 in the cache */
   /* replace444_0_0 -> 1324 in the cache */
   { .expression = {
      { nir_search_value_expression, 0 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_search_op_b2f,
      -1, 1,
      { 1324 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 0 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fneg,
      -1, 1,
      { 1448 },
      -1,
   } },

   /* ('fmin', ('b2f(is_used_once)', 'a@1'), ('b2f', 'b@1')) => ('b2f', ('iand', 'a', 'b')) */
   /* search445_0_0 -> 862 in the cache */
   /* search445_0 -> 1443 in the cache */
   /* search445_1_0 -> 1312 in the cache */
   /* search445_1 -> 1313 in the cache */
   { .expression = {
      { nir_search_value_expression, 0 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fmin,
      0, 1,
      { 1443, 1313 },
      -1,
   } },

   /* replace445_0_0 -> 862 in the cache */
   /* replace445_0_1 -> 1312 in the cache */
   /* replace445_0 -> 1324 in the cache */
   /* replace445 -> 1448 in the cache */

   /* ('fmin', ('fneg(is_used_once)', ('b2f(is_used_once)', 'a@1')), ('fneg', ('b2f', 'b@1'))) => ('fneg', ('b2f', ('ior', 'a', 'b'))) */
   /* search446_0_0_0 -> 862 in the cache */
   /* search446_0_0 -> 1443 in the cache */
   /* search446_0 -> 1446 in the cache */
   /* search446_1_0_0 -> 1312 in the cache */
   /* search446_1_0 -> 1313 in the cache */
   /* search446_1 -> 1320 in the cache */
   { .expression = {
      { nir_search_value_expression, 0 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fmin,
      0, 1,
      { 1446, 1320 },
      -1,
   } },

   /* replace446_0_0_0 -> 862 in the cache */
   /* replace446_0_0_1 -> 1312 in the cache */
   /* replace446_0_0 -> 1316 in the cache */
   /* replace446_0 -> 1445 in the cache */
   { .expression = {
      { nir_search_value_expression, 0 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fneg,
      -1, 1,
      { 1445 },
      -1,
   } },

   /* ('fmin', ('b2f', 'a@1'), '#b') => ('bcsel', 'a', ('fmin', 'b', 1.0), ('fmin', 'b', 0.0)) */
   /* search447_0_0 -> 862 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_search_op_b2f,
      -1, 0,
      { 862 },
      -1,
   } },
   /* search447_1 -> 926 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fmin,
      0, 1,
      { 1453, 926 },
      -1,
   } },

   /* replace447_0 -> 862 in the cache */
   /* replace447_1_0 -> 1 in the cache */
   /* replace447_1_1 -> 286 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fmin,
      0, 1,
      { 1, 286 },
      -1,
   } },
   /* replace447_2_0 -> 1 in the cache */
   /* replace447_2_1 -> 276 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fmin,
      1, 1,
      { 1, 276 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_bcsel,
      -1, 2,
      { 862, 1455, 1456 },
      -1,
   } },

   /* ('flt', ('fadd(is_used_once)', 'a', ('fneg', 'b')), 0.0) => ('flt', 'a', 'b') */
   /* search448_0_0 -> 0 in the cache */
   /* search448_0_1_0 -> 1 in the cache */
   /* search448_0_1 -> 1237 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fadd,
      0, 1,
      { 0, 1237 },
      0,
   } },
   /* search448_1 -> 276 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_flt,
      -1, 1,
      { 1458, 276 },
      -1,
   } },

   /* replace448_0 -> 0 in the cache */
   /* replace448_1 -> 1 in the cache */
   /* replace448 -> 3 in the cache */

   /* ('fge', ('fneg', ('fabs', 'a')), 0.0) => ('feq', 'a', 0.0) */
   /* search449_0_0_0 -> 9 in the cache */
   /* search449_0_0 -> 11 in the cache */
   /* search449_0 -> 1436 in the cache */
   /* search449_1 -> 8 in the cache */
   /* search449 -> 1439 in the cache */

   /* replace449_0 -> 9 in the cache */
   /* replace449_1 -> 8 in the cache */
   /* replace449 -> 1287 in the cache */

   /* ('~bcsel', ('flt', 'b', 'a'), 'b', 'a') => ('fmin', 'a', 'b') */
   /* search450_0_0 -> 1254 in the cache */
   /* search450_0_1 -> 1253 in the cache */
   /* search450_0 -> 1295 in the cache */
   /* search450_1 -> 1254 in the cache */
   /* search450_2 -> 1253 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      true,
      false,
      false,
      false,
      false,
      false,
      nir_op_bcsel,
      -1, 0,
      { 1295, 1254, 1253 },
      -1,
   } },

   /* replace450_0 -> 1253 in the cache */
   /* replace450_1 -> 1254 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fmin,
      0, 1,
      { 1253, 1254 },
      -1,
   } },

   /* ('~bcsel', ('flt', 'a', 'b'), 'b', 'a') => ('fmax', 'a', 'b') */
   /* search451_0_0 -> 0 in the cache */
   /* search451_0_1 -> 1 in the cache */
   /* search451_0 -> 3 in the cache */
   /* search451_1 -> 1 in the cache */
   /* search451_2 -> 0 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      true,
      false,
      false,
      false,
      false,
      false,
      nir_op_bcsel,
      -1, 0,
      { 3, 1, 0 },
      -1,
   } },

   /* replace451_0 -> 0 in the cache */
   /* replace451_1 -> 1 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fmax,
      0, 1,
      { 0, 1 },
      -1,
   } },

   /* ('~bcsel', ('fge', 'a', 'b'), 'b', 'a') => ('fmin', 'a', 'b') */
   /* search452_0_0 -> 0 in the cache */
   /* search452_0_1 -> 1 in the cache */
   /* search452_0 -> 6 in the cache */
   /* search452_1 -> 1 in the cache */
   /* search452_2 -> 0 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      true,
      false,
      false,
      false,
      false,
      false,
      nir_op_bcsel,
      -1, 0,
      { 6, 1, 0 },
      -1,
   } },

   /* replace452_0 -> 0 in the cache */
   /* replace452_1 -> 1 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fmin,
      0, 1,
      { 0, 1 },
      -1,
   } },

   /* ('~bcsel', ('fge', 'b', 'a'), 'b', 'a') => ('fmax', 'a', 'b') */
   /* search453_0_0 -> 1254 in the cache */
   /* search453_0_1 -> 1253 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fge,
      -1, 0,
      { 1254, 1253 },
      -1,
   } },
   /* search453_1 -> 1254 in the cache */
   /* search453_2 -> 1253 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      true,
      false,
      false,
      false,
      false,
      false,
      nir_op_bcsel,
      -1, 0,
      { 1466, 1254, 1253 },
      -1,
   } },

   /* replace453_0 -> 1253 in the cache */
   /* replace453_1 -> 1254 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fmax,
      0, 1,
      { 1253, 1254 },
      -1,
   } },

   /* ('bcsel', ('inot', 'a'), 'b', 'c') => ('bcsel', 'a', 'c', 'b') */
   /* search454_0_0 -> 862 in the cache */
   /* search454_0 -> 1309 in the cache */
   /* search454_1 -> 144 in the cache */
   /* search454_2 -> 146 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_bcsel,
      -1, 0,
      { 1309, 144, 146 },
      -1,
   } },

   /* replace454_0 -> 862 in the cache */
   /* replace454_1 -> 146 in the cache */
   /* replace454_2 -> 144 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_bcsel,
      -1, 0,
      { 862, 146, 144 },
      -1,
   } },

   /* ('bcsel', 'a', ('bcsel', 'a', 'b', 'c'), 'd') => ('bcsel', 'a', 'b', 'd') */
   /* search455_0 -> 862 in the cache */
   /* search455_1_0 -> 862 in the cache */
   /* search455_1_1 -> 167 in the cache */
   /* search455_1_2 -> 169 in the cache */
   { .expression = {
      { nir_search_value_expression, -4 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_bcsel,
      -1, 0,
      { 862, 167, 169 },
      -1,
   } },
   /* search455_2 -> 170 in the cache */
   { .expression = {
      { nir_search_value_expression, -4 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_bcsel,
      -1, 0,
      { 862, 1471, 170 },
      -1,
   } },

   /* replace455_0 -> 862 in the cache */
   /* replace455_1 -> 167 in the cache */
   /* replace455_2 -> 170 in the cache */
   { .expression = {
      { nir_search_value_expression, -4 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_bcsel,
      -1, 0,
      { 862, 167, 170 },
      -1,
   } },

   /* ('bcsel', 'a', 'b', ('bcsel', 'a', 'c', 'd')) => ('bcsel', 'a', 'b', 'd') */
   /* search456_0 -> 862 in the cache */
   /* search456_1 -> 167 in the cache */
   /* search456_2_0 -> 862 in the cache */
   /* search456_2_1 -> 169 in the cache */
   /* search456_2_2 -> 170 in the cache */
   { .expression = {
      { nir_search_value_expression, -4 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_bcsel,
      -1, 0,
      { 862, 169, 170 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -4 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_bcsel,
      -1, 0,
      { 862, 167, 1474 },
      -1,
   } },

   /* replace456_0 -> 862 in the cache */
   /* replace456_1 -> 167 in the cache */
   /* replace456_2 -> 170 in the cache */
   /* replace456 -> 1473 in the cache */

   /* ('bcsel', 'a', ('bcsel', 'b', 'c', 'd'), ('bcsel(is_used_once)', 'b', 'c', 'e')) => ('bcsel', 'b', 'c', ('bcsel', 'a', 'd', 'e')) */
   /* search457_0 -> 862 in the cache */
   /* search457_1_0 -> 1312 in the cache */
   /* search457_1_1 -> 855 in the cache */
   /* search457_1_2 -> 864 in the cache */
   { .expression = {
      { nir_search_value_expression, -5 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_bcsel,
      -1, 0,
      { 1312, 855, 864 },
      -1,
   } },
   /* search457_2_0 -> 1312 in the cache */
   /* search457_2_1 -> 855 in the cache */
   /* search457_2_2 -> 866 in the cache */
   { .expression = {
      { nir_search_value_expression, -5 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_bcsel,
      -1, 0,
      { 1312, 855, 866 },
      0,
   } },
   { .expression = {
      { nir_search_value_expression, -5 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_bcsel,
      -1, 0,
      { 862, 1476, 1477 },
      -1,
   } },

   /* replace457_0 -> 1312 in the cache */
   /* replace457_1 -> 855 in the cache */
   /* replace457_2_0 -> 862 in the cache */
   /* replace457_2_1 -> 864 in the cache */
   /* replace457_2_2 -> 866 in the cache */
   { .expression = {
      { nir_search_value_expression, -5 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_bcsel,
      -1, 0,
      { 862, 864, 866 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -5 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_bcsel,
      -1, 0,
      { 1312, 855, 1479 },
      -1,
   } },

   /* ('bcsel', 'a', ('bcsel(is_used_once)', 'b', 'c', 'd'), ('bcsel', 'b', 'c', 'e')) => ('bcsel', 'b', 'c', ('bcsel', 'a', 'd', 'e')) */
   /* search458_0 -> 862 in the cache */
   /* search458_1_0 -> 1312 in the cache */
   /* search458_1_1 -> 855 in the cache */
   /* search458_1_2 -> 864 in the cache */
   { .expression = {
      { nir_search_value_expression, -5 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_bcsel,
      -1, 0,
      { 1312, 855, 864 },
      0,
   } },
   /* search458_2_0 -> 1312 in the cache */
   /* search458_2_1 -> 855 in the cache */
   /* search458_2_2 -> 866 in the cache */
   { .expression = {
      { nir_search_value_expression, -5 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_bcsel,
      -1, 0,
      { 1312, 855, 866 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -5 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_bcsel,
      -1, 0,
      { 862, 1481, 1482 },
      -1,
   } },

   /* replace458_0 -> 1312 in the cache */
   /* replace458_1 -> 855 in the cache */
   /* replace458_2_0 -> 862 in the cache */
   /* replace458_2_1 -> 864 in the cache */
   /* replace458_2_2 -> 866 in the cache */
   /* replace458_2 -> 1479 in the cache */
   /* replace458 -> 1480 in the cache */

   /* ('bcsel', 'a', ('bcsel', 'b', 'c', 'd'), ('bcsel(is_used_once)', 'b', 'e', 'd')) => ('bcsel', 'b', ('bcsel', 'a', 'c', 'e'), 'd') */
   /* search459_0 -> 862 in the cache */
   /* search459_1_0 -> 1312 in the cache */
   /* search459_1_1 -> 169 in the cache */
   /* search459_1_2 -> 170 in the cache */
   { .expression = {
      { nir_search_value_expression, -4 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_bcsel,
      -1, 0,
      { 1312, 169, 170 },
      -1,
   } },
   /* search459_2_0 -> 1312 in the cache */
   { .variable = {
      { nir_search_value_variable, -4 },
      4, /* e */
      false,
      nir_type_invalid,
      -1,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   /* search459_2_2 -> 170 in the cache */
   { .expression = {
      { nir_search_value_expression, -4 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_bcsel,
      -1, 0,
      { 1312, 1485, 170 },
      0,
   } },
   { .expression = {
      { nir_search_value_expression, -4 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_bcsel,
      -1, 0,
      { 862, 1484, 1486 },
      -1,
   } },

   /* replace459_0 -> 1312 in the cache */
   /* replace459_1_0 -> 862 in the cache */
   /* replace459_1_1 -> 169 in the cache */
   /* replace459_1_2 -> 1485 in the cache */
   { .expression = {
      { nir_search_value_expression, -4 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_bcsel,
      -1, 0,
      { 862, 169, 1485 },
      -1,
   } },
   /* replace459_2 -> 170 in the cache */
   { .expression = {
      { nir_search_value_expression, -4 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_bcsel,
      -1, 0,
      { 1312, 1488, 170 },
      -1,
   } },

   /* ('bcsel', 'a', ('bcsel(is_used_once)', 'b', 'c', 'd'), ('bcsel', 'b', 'e', 'd')) => ('bcsel', 'b', ('bcsel', 'a', 'c', 'e'), 'd') */
   /* search460_0 -> 862 in the cache */
   /* search460_1_0 -> 1312 in the cache */
   /* search460_1_1 -> 169 in the cache */
   /* search460_1_2 -> 170 in the cache */
   { .expression = {
      { nir_search_value_expression, -4 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_bcsel,
      -1, 0,
      { 1312, 169, 170 },
      0,
   } },
   /* search460_2_0 -> 1312 in the cache */
   /* search460_2_1 -> 1485 in the cache */
   /* search460_2_2 -> 170 in the cache */
   { .expression = {
      { nir_search_value_expression, -4 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_bcsel,
      -1, 0,
      { 1312, 1485, 170 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -4 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_bcsel,
      -1, 0,
      { 862, 1490, 1491 },
      -1,
   } },

   /* replace460_0 -> 1312 in the cache */
   /* replace460_1_0 -> 862 in the cache */
   /* replace460_1_1 -> 169 in the cache */
   /* replace460_1_2 -> 1485 in the cache */
   /* replace460_1 -> 1488 in the cache */
   /* replace460_2 -> 170 in the cache */
   /* replace460 -> 1489 in the cache */

   /* ('bcsel', 'a', True, 'b') => ('ior', 'a', 'b') */
   /* search461_0 -> 862 in the cache */
   /* search461_1 -> 1412 in the cache */
   /* search461_2 -> 1312 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_bcsel,
      -1, 0,
      { 862, 1412, 1312 },
      -1,
   } },

   /* replace461_0 -> 862 in the cache */
   /* replace461_1 -> 1312 in the cache */
   /* replace461 -> 1316 in the cache */

   /* ('bcsel', 'a', 'a', 'b') => ('ior', 'a', 'b') */
   /* search462_0 -> 862 in the cache */
   /* search462_1 -> 862 in the cache */
   /* search462_2 -> 1312 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_bcsel,
      -1, 0,
      { 862, 862, 1312 },
      -1,
   } },

   /* replace462_0 -> 862 in the cache */
   /* replace462_1 -> 1312 in the cache */
   /* replace462 -> 1316 in the cache */

   /* ('bcsel', 'a', 'b', False) => ('iand', 'a', 'b') */
   /* search463_0 -> 862 in the cache */
   /* search463_1 -> 1312 in the cache */
   /* search463_2 -> 1227 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_bcsel,
      -1, 0,
      { 862, 1312, 1227 },
      -1,
   } },

   /* replace463_0 -> 862 in the cache */
   /* replace463_1 -> 1312 in the cache */
   /* replace463 -> 1324 in the cache */

   /* ('bcsel', 'a', 'b', 'a') => ('iand', 'a', 'b') */
   /* search464_0 -> 862 in the cache */
   /* search464_1 -> 1312 in the cache */
   /* search464_2 -> 862 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_bcsel,
      -1, 0,
      { 862, 1312, 862 },
      -1,
   } },

   /* replace464_0 -> 862 in the cache */
   /* replace464_1 -> 1312 in the cache */
   /* replace464 -> 1324 in the cache */

   /* ('~fmin', 'a', 'a') => a */
   /* search465_0 -> 9 in the cache */
   /* search465_1 -> 9 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      true,
      false,
      false,
      false,
      false,
      false,
      nir_op_fmin,
      -1, 0,
      { 9, 9 },
      -1,
   } },

   /* replace465 -> 9 in the cache */

   /* ('~fmax', 'a', 'a') => a */
   /* search466_0 -> 9 in the cache */
   /* search466_1 -> 9 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      true,
      false,
      false,
      false,
      false,
      false,
      nir_op_fmax,
      -1, 0,
      { 9, 9 },
      -1,
   } },

   /* replace466 -> 9 in the cache */

   /* ('imin', 'a', 'a') => a */
   /* search467_0 -> 9 in the cache */
   /* search467_1 -> 9 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_imin,
      -1, 0,
      { 9, 9 },
      -1,
   } },

   /* replace467 -> 9 in the cache */

   /* ('imax', 'a', 'a') => a */
   /* search468_0 -> 9 in the cache */
   /* search468_1 -> 9 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_imax,
      -1, 0,
      { 9, 9 },
      -1,
   } },

   /* replace468 -> 9 in the cache */

   /* ('umin', 'a', 'a') => a */
   /* search469_0 -> 9 in the cache */
   /* search469_1 -> 9 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_umin,
      -1, 0,
      { 9, 9 },
      -1,
   } },

   /* replace469 -> 9 in the cache */

   /* ('umin', 'a', 0) => 0 */
   /* search470_0 -> 9 in the cache */
   /* search470_1 -> 73 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_umin,
      0, 1,
      { 9, 73 },
      -1,
   } },

   /* replace470 -> 73 in the cache */

   /* ('umin', 'a', -1) => a */
   /* search471_0 -> 9 in the cache */
   /* search471_1 -> 75 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_umin,
      0, 1,
      { 9, 75 },
      -1,
   } },

   /* replace471 -> 9 in the cache */

   /* ('umax', 'a', 'a') => a */
   /* search472_0 -> 9 in the cache */
   /* search472_1 -> 9 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_umax,
      -1, 0,
      { 9, 9 },
      -1,
   } },

   /* replace472 -> 9 in the cache */

   /* ('umax', 'a', 0) => a */
   /* search473_0 -> 9 in the cache */
   /* search473_1 -> 73 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_umax,
      0, 1,
      { 9, 73 },
      -1,
   } },

   /* replace473 -> 9 in the cache */

   /* ('umax', 'a', -1) => -1 */
   /* search474_0 -> 9 in the cache */
   /* search474_1 -> 75 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_umax,
      0, 1,
      { 9, 75 },
      -1,
   } },

   /* replace474 -> 75 in the cache */

   /* ('fmax', ('fmax', 'a', 'b'), 'b') => ('fmax', 'a', 'b') */
   /* search475_0_0 -> 0 in the cache */
   /* search475_0_1 -> 1 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fmax,
      1, 1,
      { 0, 1 },
      -1,
   } },
   /* search475_1 -> 1 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fmax,
      0, 2,
      { 1507, 1 },
      -1,
   } },

   /* replace475_0 -> 0 in the cache */
   /* replace475_1 -> 1 in the cache */
   /* replace475 -> 1463 in the cache */

   /* ('umax', ('umax', 'a', 'b'), 'b') => ('umax', 'a', 'b') */
   /* search476_0_0 -> 0 in the cache */
   /* search476_0_1 -> 1 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_umax,
      1, 1,
      { 0, 1 },
      -1,
   } },
   /* search476_1 -> 1 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_umax,
      0, 2,
      { 1509, 1 },
      -1,
   } },

   /* replace476_0 -> 0 in the cache */
   /* replace476_1 -> 1 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_umax,
      0, 1,
      { 0, 1 },
      -1,
   } },

   /* ('imax', ('imax', 'a', 'b'), 'b') => ('imax', 'a', 'b') */
   /* search477_0_0 -> 0 in the cache */
   /* search477_0_1 -> 1 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_imax,
      1, 1,
      { 0, 1 },
      -1,
   } },
   /* search477_1 -> 1 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_imax,
      0, 2,
      { 1512, 1 },
      -1,
   } },

   /* replace477_0 -> 0 in the cache */
   /* replace477_1 -> 1 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_imax,
      0, 1,
      { 0, 1 },
      -1,
   } },

   /* ('fmin', ('fmin', 'a', 'b'), 'b') => ('fmin', 'a', 'b') */
   /* search478_0_0 -> 0 in the cache */
   /* search478_0_1 -> 1 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fmin,
      1, 1,
      { 0, 1 },
      -1,
   } },
   /* search478_1 -> 1 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fmin,
      0, 2,
      { 1515, 1 },
      -1,
   } },

   /* replace478_0 -> 0 in the cache */
   /* replace478_1 -> 1 in the cache */
   /* replace478 -> 1465 in the cache */

   /* ('umin', ('umin', 'a', 'b'), 'b') => ('umin', 'a', 'b') */
   /* search479_0_0 -> 0 in the cache */
   /* search479_0_1 -> 1 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_umin,
      1, 1,
      { 0, 1 },
      -1,
   } },
   /* search479_1 -> 1 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_umin,
      0, 2,
      { 1517, 1 },
      -1,
   } },

   /* replace479_0 -> 0 in the cache */
   /* replace479_1 -> 1 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_umin,
      0, 1,
      { 0, 1 },
      -1,
   } },

   /* ('imin', ('imin', 'a', 'b'), 'b') => ('imin', 'a', 'b') */
   /* search480_0_0 -> 0 in the cache */
   /* search480_0_1 -> 1 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_imin,
      1, 1,
      { 0, 1 },
      -1,
   } },
   /* search480_1 -> 1 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_imin,
      0, 2,
      { 1520, 1 },
      -1,
   } },

   /* replace480_0 -> 0 in the cache */
   /* replace480_1 -> 1 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_imin,
      0, 1,
      { 0, 1 },
      -1,
   } },

   /* ('fmax', ('fmax', ('fmax', 'a', 'b'), 'c'), 'a') => ('fmax', ('fmax', 'a', 'b'), 'c') */
   /* search481_0_0_0 -> 143 in the cache */
   /* search481_0_0_1 -> 144 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fmax,
      2, 1,
      { 143, 144 },
      -1,
   } },
   /* search481_0_1 -> 146 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fmax,
      1, 2,
      { 1523, 146 },
      -1,
   } },
   /* search481_1 -> 143 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fmax,
      0, 3,
      { 1524, 143 },
      -1,
   } },

   /* replace481_0_0 -> 143 in the cache */
   /* replace481_0_1 -> 144 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fmax,
      1, 1,
      { 143, 144 },
      -1,
   } },
   /* replace481_1 -> 146 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fmax,
      0, 2,
      { 1526, 146 },
      -1,
   } },

   /* ('umax', ('umax', ('umax', 'a', 'b'), 'c'), 'a') => ('umax', ('umax', 'a', 'b'), 'c') */
   /* search482_0_0_0 -> 143 in the cache */
   /* search482_0_0_1 -> 144 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_umax,
      2, 1,
      { 143, 144 },
      -1,
   } },
   /* search482_0_1 -> 146 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_umax,
      1, 2,
      { 1528, 146 },
      -1,
   } },
   /* search482_1 -> 143 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_umax,
      0, 3,
      { 1529, 143 },
      -1,
   } },

   /* replace482_0_0 -> 143 in the cache */
   /* replace482_0_1 -> 144 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_umax,
      1, 1,
      { 143, 144 },
      -1,
   } },
   /* replace482_1 -> 146 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_umax,
      0, 2,
      { 1531, 146 },
      -1,
   } },

   /* ('imax', ('imax', ('imax', 'a', 'b'), 'c'), 'a') => ('imax', ('imax', 'a', 'b'), 'c') */
   /* search483_0_0_0 -> 143 in the cache */
   /* search483_0_0_1 -> 144 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_imax,
      2, 1,
      { 143, 144 },
      -1,
   } },
   /* search483_0_1 -> 146 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_imax,
      1, 2,
      { 1533, 146 },
      -1,
   } },
   /* search483_1 -> 143 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_imax,
      0, 3,
      { 1534, 143 },
      -1,
   } },

   /* replace483_0_0 -> 143 in the cache */
   /* replace483_0_1 -> 144 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_imax,
      1, 1,
      { 143, 144 },
      -1,
   } },
   /* replace483_1 -> 146 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_imax,
      0, 2,
      { 1536, 146 },
      -1,
   } },

   /* ('fmin', ('fmin', ('fmin', 'a', 'b'), 'c'), 'a') => ('fmin', ('fmin', 'a', 'b'), 'c') */
   /* search484_0_0_0 -> 143 in the cache */
   /* search484_0_0_1 -> 144 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fmin,
      2, 1,
      { 143, 144 },
      -1,
   } },
   /* search484_0_1 -> 146 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fmin,
      1, 2,
      { 1538, 146 },
      -1,
   } },
   /* search484_1 -> 143 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fmin,
      0, 3,
      { 1539, 143 },
      -1,
   } },

   /* replace484_0_0 -> 143 in the cache */
   /* replace484_0_1 -> 144 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fmin,
      1, 1,
      { 143, 144 },
      -1,
   } },
   /* replace484_1 -> 146 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fmin,
      0, 2,
      { 1541, 146 },
      -1,
   } },

   /* ('umin', ('umin', ('umin', 'a', 'b'), 'c'), 'a') => ('umin', ('umin', 'a', 'b'), 'c') */
   /* search485_0_0_0 -> 143 in the cache */
   /* search485_0_0_1 -> 144 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_umin,
      2, 1,
      { 143, 144 },
      -1,
   } },
   /* search485_0_1 -> 146 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_umin,
      1, 2,
      { 1543, 146 },
      -1,
   } },
   /* search485_1 -> 143 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_umin,
      0, 3,
      { 1544, 143 },
      -1,
   } },

   /* replace485_0_0 -> 143 in the cache */
   /* replace485_0_1 -> 144 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_umin,
      1, 1,
      { 143, 144 },
      -1,
   } },
   /* replace485_1 -> 146 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_umin,
      0, 2,
      { 1546, 146 },
      -1,
   } },

   /* ('imin', ('imin', ('imin', 'a', 'b'), 'c'), 'a') => ('imin', ('imin', 'a', 'b'), 'c') */
   /* search486_0_0_0 -> 143 in the cache */
   /* search486_0_0_1 -> 144 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_imin,
      2, 1,
      { 143, 144 },
      -1,
   } },
   /* search486_0_1 -> 146 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_imin,
      1, 2,
      { 1548, 146 },
      -1,
   } },
   /* search486_1 -> 143 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_imin,
      0, 3,
      { 1549, 143 },
      -1,
   } },

   /* replace486_0_0 -> 143 in the cache */
   /* replace486_0_1 -> 144 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_imin,
      1, 1,
      { 143, 144 },
      -1,
   } },
   /* replace486_1 -> 146 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_imin,
      0, 2,
      { 1551, 146 },
      -1,
   } },

   /* ('ieq', ('b2i8', 'a@1'), ('b2i8', 'b@1')) => ('ieq', 'a', 'b') */
   /* search487_0_0 -> 862 in the cache */
   { .expression = {
      { nir_search_value_expression, 8 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_b2i8,
      -1, 0,
      { 862 },
      -1,
   } },
   /* search487_1_0 -> 1312 in the cache */
   { .expression = {
      { nir_search_value_expression, 8 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_b2i8,
      -1, 0,
      { 1312 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ieq,
      0, 1,
      { 1553, 1554 },
      -1,
   } },

   /* replace487_0 -> 862 in the cache */
   /* replace487_1 -> 1312 in the cache */
   /* replace487 -> 1340 in the cache */

   /* ('ine', ('b2i8', 'a@1'), ('b2i8', 'b@1')) => ('ine', 'a', 'b') */
   /* search488_0_0 -> 862 in the cache */
   /* search488_0 -> 1553 in the cache */
   /* search488_1_0 -> 1312 in the cache */
   /* search488_1 -> 1554 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ine,
      0, 1,
      { 1553, 1554 },
      -1,
   } },

   /* replace488_0 -> 862 in the cache */
   /* replace488_1 -> 1312 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ine,
      0, 1,
      { 862, 1312 },
      -1,
   } },

   /* ('ieq', ('b2i16', 'a@1'), ('b2i16', 'b@1')) => ('ieq', 'a', 'b') */
   /* search489_0_0 -> 862 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_b2i16,
      -1, 0,
      { 862 },
      -1,
   } },
   /* search489_1_0 -> 1312 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_b2i16,
      -1, 0,
      { 1312 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ieq,
      0, 1,
      { 1558, 1559 },
      -1,
   } },

   /* replace489_0 -> 862 in the cache */
   /* replace489_1 -> 1312 in the cache */
   /* replace489 -> 1340 in the cache */

   /* ('ine', ('b2i16', 'a@1'), ('b2i16', 'b@1')) => ('ine', 'a', 'b') */
   /* search490_0_0 -> 862 in the cache */
   /* search490_0 -> 1558 in the cache */
   /* search490_1_0 -> 1312 in the cache */
   /* search490_1 -> 1559 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ine,
      0, 1,
      { 1558, 1559 },
      -1,
   } },

   /* replace490_0 -> 862 in the cache */
   /* replace490_1 -> 1312 in the cache */
   /* replace490 -> 1557 in the cache */

   /* ('ieq', ('b2i32', 'a@1'), ('b2i32', 'b@1')) => ('ieq', 'a', 'b') */
   /* search491_0_0 -> 862 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_b2i32,
      -1, 0,
      { 862 },
      -1,
   } },
   /* search491_1_0 -> 1312 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_b2i32,
      -1, 0,
      { 1312 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ieq,
      0, 1,
      { 1562, 1563 },
      -1,
   } },

   /* replace491_0 -> 862 in the cache */
   /* replace491_1 -> 1312 in the cache */
   /* replace491 -> 1340 in the cache */

   /* ('ine', ('b2i32', 'a@1'), ('b2i32', 'b@1')) => ('ine', 'a', 'b') */
   /* search492_0_0 -> 862 in the cache */
   /* search492_0 -> 1562 in the cache */
   /* search492_1_0 -> 1312 in the cache */
   /* search492_1 -> 1563 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ine,
      0, 1,
      { 1562, 1563 },
      -1,
   } },

   /* replace492_0 -> 862 in the cache */
   /* replace492_1 -> 1312 in the cache */
   /* replace492 -> 1557 in the cache */

   /* ('ieq', ('b2i64', 'a@1'), ('b2i64', 'b@1')) => ('ieq', 'a', 'b') */
   /* search493_0_0 -> 862 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_b2i64,
      -1, 0,
      { 862 },
      -1,
   } },
   /* search493_1_0 -> 1312 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_b2i64,
      -1, 0,
      { 1312 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ieq,
      0, 1,
      { 1566, 1567 },
      -1,
   } },

   /* replace493_0 -> 862 in the cache */
   /* replace493_1 -> 1312 in the cache */
   /* replace493 -> 1340 in the cache */

   /* ('ine', ('b2i64', 'a@1'), ('b2i64', 'b@1')) => ('ine', 'a', 'b') */
   /* search494_0_0 -> 862 in the cache */
   /* search494_0 -> 1566 in the cache */
   /* search494_1_0 -> 1312 in the cache */
   /* search494_1 -> 1567 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ine,
      0, 1,
      { 1566, 1567 },
      -1,
   } },

   /* replace494_0 -> 862 in the cache */
   /* replace494_1 -> 1312 in the cache */
   /* replace494 -> 1557 in the cache */

   /* ('feq', ('b2f16', 'a@1'), ('b2f16', 'b@1')) => ('ieq', 'a', 'b') */
   /* search495_0_0 -> 862 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_b2f16,
      -1, 0,
      { 862 },
      -1,
   } },
   /* search495_1_0 -> 1312 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_b2f16,
      -1, 0,
      { 1312 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_feq,
      0, 1,
      { 1570, 1571 },
      -1,
   } },

   /* replace495_0 -> 862 in the cache */
   /* replace495_1 -> 1312 in the cache */
   /* replace495 -> 1340 in the cache */

   /* ('fneu', ('b2f16', 'a@1'), ('b2f16', 'b@1')) => ('ine', 'a', 'b') */
   /* search496_0_0 -> 862 in the cache */
   /* search496_0 -> 1570 in the cache */
   /* search496_1_0 -> 1312 in the cache */
   /* search496_1 -> 1571 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fneu,
      0, 1,
      { 1570, 1571 },
      -1,
   } },

   /* replace496_0 -> 862 in the cache */
   /* replace496_1 -> 1312 in the cache */
   /* replace496 -> 1557 in the cache */

   /* ('feq', ('b2f32', 'a@1'), ('b2f32', 'b@1')) => ('ieq', 'a', 'b') */
   /* search497_0_0 -> 862 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_b2f32,
      -1, 0,
      { 862 },
      -1,
   } },
   /* search497_1_0 -> 1312 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_b2f32,
      -1, 0,
      { 1312 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_feq,
      0, 1,
      { 1574, 1575 },
      -1,
   } },

   /* replace497_0 -> 862 in the cache */
   /* replace497_1 -> 1312 in the cache */
   /* replace497 -> 1340 in the cache */

   /* ('fneu', ('b2f32', 'a@1'), ('b2f32', 'b@1')) => ('ine', 'a', 'b') */
   /* search498_0_0 -> 862 in the cache */
   /* search498_0 -> 1574 in the cache */
   /* search498_1_0 -> 1312 in the cache */
   /* search498_1 -> 1575 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fneu,
      0, 1,
      { 1574, 1575 },
      -1,
   } },

   /* replace498_0 -> 862 in the cache */
   /* replace498_1 -> 1312 in the cache */
   /* replace498 -> 1557 in the cache */

   /* ('feq', ('b2f64', 'a@1'), ('b2f64', 'b@1')) => ('ieq', 'a', 'b') */
   /* search499_0_0 -> 862 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_b2f64,
      -1, 0,
      { 862 },
      -1,
   } },
   /* search499_1_0 -> 1312 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_b2f64,
      -1, 0,
      { 1312 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_feq,
      0, 1,
      { 1578, 1579 },
      -1,
   } },

   /* replace499_0 -> 862 in the cache */
   /* replace499_1 -> 1312 in the cache */
   /* replace499 -> 1340 in the cache */

   /* ('fneu', ('b2f64', 'a@1'), ('b2f64', 'b@1')) => ('ine', 'a', 'b') */
   /* search500_0_0 -> 862 in the cache */
   /* search500_0 -> 1578 in the cache */
   /* search500_1_0 -> 1312 in the cache */
   /* search500_1 -> 1579 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fneu,
      0, 1,
      { 1578, 1579 },
      -1,
   } },

   /* replace500_0 -> 862 in the cache */
   /* replace500_1 -> 1312 in the cache */
   /* replace500 -> 1557 in the cache */

   /* ('iand@8', 'a', ('inot', ('ishr', 'a', 7))) => ('imax', 'a', 0) */
   /* search501_0 -> 19 in the cache */
   /* search501_1_0_0 -> 19 in the cache */
   /* search501_1_0_1 -> 22 in the cache */
   { .expression = {
      { nir_search_value_expression, 8 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ishr,
      -1, 0,
      { 19, 22 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 8 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_inot,
      -1, 0,
      { 1582 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 8 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_iand,
      0, 1,
      { 19, 1583 },
      -1,
   } },

   /* replace501_0 -> 19 in the cache */
   /* replace501_1 -> 940 in the cache */
   { .expression = {
      { nir_search_value_expression, 8 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_imax,
      0, 1,
      { 19, 940 },
      -1,
   } },

   /* ('ieq', ('iand', 'a@8', 128), 0) => ('ige', 'a', 0) */
   /* search502_0_0 -> 19 in the cache */
   /* search502_0_1 -> 20 in the cache */
   { .expression = {
      { nir_search_value_expression, 8 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_iand,
      1, 1,
      { 19, 20 },
      -1,
   } },
   /* search502_1 -> 940 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ieq,
      0, 2,
      { 1586, 940 },
      -1,
   } },

   /* replace502_0 -> 19 in the cache */
   /* replace502_1 -> 940 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ige,
      -1, 0,
      { 19, 940 },
      -1,
   } },

   /* ('ine', ('iand', 'a@8', 128), 128) => ('ige', 'a', 0) */
   /* search503_0_0 -> 19 in the cache */
   /* search503_0_1 -> 20 in the cache */
   /* search503_0 -> 1586 in the cache */
   /* search503_1 -> 20 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ine,
      0, 2,
      { 1586, 20 },
      -1,
   } },

   /* replace503_0 -> 19 in the cache */
   /* replace503_1 -> 940 in the cache */
   /* replace503 -> 1588 in the cache */

   /* ('ine', ('iand', 'a@8', 128), 0) => ('ilt', 'a', 0) */
   /* search504_0_0 -> 19 in the cache */
   /* search504_0_1 -> 20 in the cache */
   /* search504_0 -> 1586 in the cache */
   /* search504_1 -> 940 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ine,
      0, 2,
      { 1586, 940 },
      -1,
   } },

   /* replace504_0 -> 19 in the cache */
   /* replace504_1 -> 940 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ilt,
      -1, 0,
      { 19, 940 },
      -1,
   } },

   /* ('ieq', ('iand', 'a@8', 128), 128) => ('ilt', 'a', 0) */
   /* search505_0_0 -> 19 in the cache */
   /* search505_0_1 -> 20 in the cache */
   /* search505_0 -> 1586 in the cache */
   /* search505_1 -> 20 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ieq,
      0, 2,
      { 1586, 20 },
      -1,
   } },

   /* replace505_0 -> 19 in the cache */
   /* replace505_1 -> 940 in the cache */
   /* replace505 -> 1591 in the cache */

   /* ('ine', ('ushr', 'a@8', 7), 0) => ('ilt', 'a', 0) */
   /* search506_0_0 -> 19 in the cache */
   /* search506_0_1 -> 22 in the cache */
   { .expression = {
      { nir_search_value_expression, 8 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ushr,
      -1, 0,
      { 19, 22 },
      -1,
   } },
   /* search506_1 -> 940 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ine,
      0, 1,
      { 1593, 940 },
      -1,
   } },

   /* replace506_0 -> 19 in the cache */
   /* replace506_1 -> 940 in the cache */
   /* replace506 -> 1591 in the cache */

   /* ('ieq', ('ushr', 'a@8', 7), 0) => ('ige', 'a', 0) */
   /* search507_0_0 -> 19 in the cache */
   /* search507_0_1 -> 22 in the cache */
   /* search507_0 -> 1593 in the cache */
   /* search507_1 -> 940 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ieq,
      0, 1,
      { 1593, 940 },
      -1,
   } },

   /* replace507_0 -> 19 in the cache */
   /* replace507_1 -> 940 in the cache */
   /* replace507 -> 1588 in the cache */

   /* ('ieq', ('ushr', 'a@8', 7), 1) => ('ilt', 'a', 0) */
   /* search508_0_0 -> 19 in the cache */
   /* search508_0_1 -> 22 in the cache */
   /* search508_0 -> 1593 in the cache */
   { .constant = {
      { nir_search_value_constant, 8 },
      nir_type_int, { 0x1ull /* 1 */ },
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ieq,
      0, 1,
      { 1593, 1596 },
      -1,
   } },

   /* replace508_0 -> 19 in the cache */
   /* replace508_1 -> 940 in the cache */
   /* replace508 -> 1591 in the cache */

   /* ('ine', ('ushr', 'a@8', 7), 1) => ('ige', 'a', 0) */
   /* search509_0_0 -> 19 in the cache */
   /* search509_0_1 -> 22 in the cache */
   /* search509_0 -> 1593 in the cache */
   /* search509_1 -> 1596 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ine,
      0, 1,
      { 1593, 1596 },
      -1,
   } },

   /* replace509_0 -> 19 in the cache */
   /* replace509_1 -> 940 in the cache */
   /* replace509 -> 1588 in the cache */

   /* ('ine', ('ishr', 'a@8', 7), 0) => ('ilt', 'a', 0) */
   /* search510_0_0 -> 19 in the cache */
   /* search510_0_1 -> 22 in the cache */
   /* search510_0 -> 1582 in the cache */
   /* search510_1 -> 940 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ine,
      0, 1,
      { 1582, 940 },
      -1,
   } },

   /* replace510_0 -> 19 in the cache */
   /* replace510_1 -> 940 in the cache */
   /* replace510 -> 1591 in the cache */

   /* ('ieq', ('ishr', 'a@8', 7), 0) => ('ige', 'a', 0) */
   /* search511_0_0 -> 19 in the cache */
   /* search511_0_1 -> 22 in the cache */
   /* search511_0 -> 1582 in the cache */
   /* search511_1 -> 940 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ieq,
      0, 1,
      { 1582, 940 },
      -1,
   } },

   /* replace511_0 -> 19 in the cache */
   /* replace511_1 -> 940 in the cache */
   /* replace511 -> 1588 in the cache */

   /* ('ieq', ('ishr', 'a@8', 7), -1) => ('ilt', 'a', 0) */
   /* search512_0_0 -> 19 in the cache */
   /* search512_0_1 -> 22 in the cache */
   /* search512_0 -> 1582 in the cache */
   { .constant = {
      { nir_search_value_constant, 8 },
      nir_type_int, { 0xffffffffffffffffull /* -1 */ },
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ieq,
      0, 1,
      { 1582, 1601 },
      -1,
   } },

   /* replace512_0 -> 19 in the cache */
   /* replace512_1 -> 940 in the cache */
   /* replace512 -> 1591 in the cache */

   /* ('ine', ('ishr', 'a@8', 7), -1) => ('ige', 'a', 0) */
   /* search513_0_0 -> 19 in the cache */
   /* search513_0_1 -> 22 in the cache */
   /* search513_0 -> 1582 in the cache */
   /* search513_1 -> 1601 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ine,
      0, 1,
      { 1582, 1601 },
      -1,
   } },

   /* replace513_0 -> 19 in the cache */
   /* replace513_1 -> 940 in the cache */
   /* replace513 -> 1588 in the cache */

   /* ('iand@16', 'a', ('inot', ('ishr', 'a', 15))) => ('imax', 'a', 0) */
   /* search514_0 -> 24 in the cache */
   /* search514_1_0_0 -> 24 in the cache */
   /* search514_1_0_1 -> 27 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ishr,
      -1, 0,
      { 24, 27 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_inot,
      -1, 0,
      { 1604 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_iand,
      0, 1,
      { 24, 1605 },
      -1,
   } },

   /* replace514_0 -> 24 in the cache */
   /* replace514_1 -> 961 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_imax,
      0, 1,
      { 24, 961 },
      -1,
   } },

   /* ('ieq', ('iand', 'a@16', 32768), 0) => ('ige', 'a', 0) */
   /* search515_0_0 -> 24 in the cache */
   /* search515_0_1 -> 25 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_iand,
      1, 1,
      { 24, 25 },
      -1,
   } },
   /* search515_1 -> 961 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ieq,
      0, 2,
      { 1608, 961 },
      -1,
   } },

   /* replace515_0 -> 24 in the cache */
   /* replace515_1 -> 961 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ige,
      -1, 0,
      { 24, 961 },
      -1,
   } },

   /* ('ine', ('iand', 'a@16', 32768), 32768) => ('ige', 'a', 0) */
   /* search516_0_0 -> 24 in the cache */
   /* search516_0_1 -> 25 in the cache */
   /* search516_0 -> 1608 in the cache */
   /* search516_1 -> 25 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ine,
      0, 2,
      { 1608, 25 },
      -1,
   } },

   /* replace516_0 -> 24 in the cache */
   /* replace516_1 -> 961 in the cache */
   /* replace516 -> 1610 in the cache */

   /* ('ine', ('iand', 'a@16', 32768), 0) => ('ilt', 'a', 0) */
   /* search517_0_0 -> 24 in the cache */
   /* search517_0_1 -> 25 in the cache */
   /* search517_0 -> 1608 in the cache */
   /* search517_1 -> 961 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ine,
      0, 2,
      { 1608, 961 },
      -1,
   } },

   /* replace517_0 -> 24 in the cache */
   /* replace517_1 -> 961 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ilt,
      -1, 0,
      { 24, 961 },
      -1,
   } },

   /* ('ieq', ('iand', 'a@16', 32768), 32768) => ('ilt', 'a', 0) */
   /* search518_0_0 -> 24 in the cache */
   /* search518_0_1 -> 25 in the cache */
   /* search518_0 -> 1608 in the cache */
   /* search518_1 -> 25 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ieq,
      0, 2,
      { 1608, 25 },
      -1,
   } },

   /* replace518_0 -> 24 in the cache */
   /* replace518_1 -> 961 in the cache */
   /* replace518 -> 1613 in the cache */

   /* ('ine', ('ushr', 'a@16', 15), 0) => ('ilt', 'a', 0) */
   /* search519_0_0 -> 24 in the cache */
   /* search519_0_1 -> 27 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ushr,
      -1, 0,
      { 24, 27 },
      -1,
   } },
   /* search519_1 -> 961 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ine,
      0, 1,
      { 1615, 961 },
      -1,
   } },

   /* replace519_0 -> 24 in the cache */
   /* replace519_1 -> 961 in the cache */
   /* replace519 -> 1613 in the cache */

   /* ('ieq', ('ushr', 'a@16', 15), 0) => ('ige', 'a', 0) */
   /* search520_0_0 -> 24 in the cache */
   /* search520_0_1 -> 27 in the cache */
   /* search520_0 -> 1615 in the cache */
   /* search520_1 -> 961 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ieq,
      0, 1,
      { 1615, 961 },
      -1,
   } },

   /* replace520_0 -> 24 in the cache */
   /* replace520_1 -> 961 in the cache */
   /* replace520 -> 1610 in the cache */

   /* ('ieq', ('ushr', 'a@16', 15), 1) => ('ilt', 'a', 0) */
   /* search521_0_0 -> 24 in the cache */
   /* search521_0_1 -> 27 in the cache */
   /* search521_0 -> 1615 in the cache */
   { .constant = {
      { nir_search_value_constant, 16 },
      nir_type_int, { 0x1ull /* 1 */ },
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ieq,
      0, 1,
      { 1615, 1618 },
      -1,
   } },

   /* replace521_0 -> 24 in the cache */
   /* replace521_1 -> 961 in the cache */
   /* replace521 -> 1613 in the cache */

   /* ('ine', ('ushr', 'a@16', 15), 1) => ('ige', 'a', 0) */
   /* search522_0_0 -> 24 in the cache */
   /* search522_0_1 -> 27 in the cache */
   /* search522_0 -> 1615 in the cache */
   /* search522_1 -> 1618 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ine,
      0, 1,
      { 1615, 1618 },
      -1,
   } },

   /* replace522_0 -> 24 in the cache */
   /* replace522_1 -> 961 in the cache */
   /* replace522 -> 1610 in the cache */

   /* ('ine', ('ishr', 'a@16', 15), 0) => ('ilt', 'a', 0) */
   /* search523_0_0 -> 24 in the cache */
   /* search523_0_1 -> 27 in the cache */
   /* search523_0 -> 1604 in the cache */
   /* search523_1 -> 961 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ine,
      0, 1,
      { 1604, 961 },
      -1,
   } },

   /* replace523_0 -> 24 in the cache */
   /* replace523_1 -> 961 in the cache */
   /* replace523 -> 1613 in the cache */

   /* ('ieq', ('ishr', 'a@16', 15), 0) => ('ige', 'a', 0) */
   /* search524_0_0 -> 24 in the cache */
   /* search524_0_1 -> 27 in the cache */
   /* search524_0 -> 1604 in the cache */
   /* search524_1 -> 961 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ieq,
      0, 1,
      { 1604, 961 },
      -1,
   } },

   /* replace524_0 -> 24 in the cache */
   /* replace524_1 -> 961 in the cache */
   /* replace524 -> 1610 in the cache */

   /* ('ieq', ('ishr', 'a@16', 15), -1) => ('ilt', 'a', 0) */
   /* search525_0_0 -> 24 in the cache */
   /* search525_0_1 -> 27 in the cache */
   /* search525_0 -> 1604 in the cache */
   { .constant = {
      { nir_search_value_constant, 16 },
      nir_type_int, { 0xffffffffffffffffull /* -1 */ },
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ieq,
      0, 1,
      { 1604, 1623 },
      -1,
   } },

   /* replace525_0 -> 24 in the cache */
   /* replace525_1 -> 961 in the cache */
   /* replace525 -> 1613 in the cache */

   /* ('ine', ('ishr', 'a@16', 15), -1) => ('ige', 'a', 0) */
   /* search526_0_0 -> 24 in the cache */
   /* search526_0_1 -> 27 in the cache */
   /* search526_0 -> 1604 in the cache */
   /* search526_1 -> 1623 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ine,
      0, 1,
      { 1604, 1623 },
      -1,
   } },

   /* replace526_0 -> 24 in the cache */
   /* replace526_1 -> 961 in the cache */
   /* replace526 -> 1610 in the cache */

   /* ('iand@32', 'a', ('inot', ('ishr', 'a', 31))) => ('imax', 'a', 0) */
   /* search527_0 -> 29 in the cache */
   /* search527_1_0_0 -> 29 in the cache */
   /* search527_1_0_1 -> 32 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ishr,
      -1, 0,
      { 29, 32 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_inot,
      -1, 0,
      { 1626 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_iand,
      0, 1,
      { 29, 1627 },
      -1,
   } },

   /* replace527_0 -> 29 in the cache */
   /* replace527_1 -> 139 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_imax,
      0, 1,
      { 29, 139 },
      -1,
   } },

   /* ('ieq', ('iand', 'a@32', 2147483648), 0) => ('ige', 'a', 0) */
   /* search528_0_0 -> 29 in the cache */
   /* search528_0_1 -> 30 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_iand,
      1, 1,
      { 29, 30 },
      -1,
   } },
   /* search528_1 -> 139 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ieq,
      0, 2,
      { 1630, 139 },
      -1,
   } },

   /* replace528_0 -> 29 in the cache */
   /* replace528_1 -> 139 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ige,
      -1, 0,
      { 29, 139 },
      -1,
   } },

   /* ('ine', ('iand', 'a@32', 2147483648), 2147483648) => ('ige', 'a', 0) */
   /* search529_0_0 -> 29 in the cache */
   /* search529_0_1 -> 30 in the cache */
   /* search529_0 -> 1630 in the cache */
   /* search529_1 -> 30 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ine,
      0, 2,
      { 1630, 30 },
      -1,
   } },

   /* replace529_0 -> 29 in the cache */
   /* replace529_1 -> 139 in the cache */
   /* replace529 -> 1632 in the cache */

   /* ('ine', ('iand', 'a@32', 2147483648), 0) => ('ilt', 'a', 0) */
   /* search530_0_0 -> 29 in the cache */
   /* search530_0_1 -> 30 in the cache */
   /* search530_0 -> 1630 in the cache */
   /* search530_1 -> 139 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ine,
      0, 2,
      { 1630, 139 },
      -1,
   } },

   /* replace530_0 -> 29 in the cache */
   /* replace530_1 -> 139 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ilt,
      -1, 0,
      { 29, 139 },
      -1,
   } },

   /* ('ieq', ('iand', 'a@32', 2147483648), 2147483648) => ('ilt', 'a', 0) */
   /* search531_0_0 -> 29 in the cache */
   /* search531_0_1 -> 30 in the cache */
   /* search531_0 -> 1630 in the cache */
   /* search531_1 -> 30 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ieq,
      0, 2,
      { 1630, 30 },
      -1,
   } },

   /* replace531_0 -> 29 in the cache */
   /* replace531_1 -> 139 in the cache */
   /* replace531 -> 1635 in the cache */

   /* ('ine', ('ushr', 'a@32', 31), 0) => ('ilt', 'a', 0) */
   /* search532_0_0 -> 29 in the cache */
   /* search532_0_1 -> 32 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ushr,
      -1, 0,
      { 29, 32 },
      -1,
   } },
   /* search532_1 -> 139 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ine,
      0, 1,
      { 1637, 139 },
      -1,
   } },

   /* replace532_0 -> 29 in the cache */
   /* replace532_1 -> 139 in the cache */
   /* replace532 -> 1635 in the cache */

   /* ('ieq', ('ushr', 'a@32', 31), 0) => ('ige', 'a', 0) */
   /* search533_0_0 -> 29 in the cache */
   /* search533_0_1 -> 32 in the cache */
   /* search533_0 -> 1637 in the cache */
   /* search533_1 -> 139 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ieq,
      0, 1,
      { 1637, 139 },
      -1,
   } },

   /* replace533_0 -> 29 in the cache */
   /* replace533_1 -> 139 in the cache */
   /* replace533 -> 1632 in the cache */

   /* ('ieq', ('ushr', 'a@32', 31), 1) => ('ilt', 'a', 0) */
   /* search534_0_0 -> 29 in the cache */
   /* search534_0_1 -> 32 in the cache */
   /* search534_0 -> 1637 in the cache */
   /* search534_1 -> 501 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ieq,
      0, 1,
      { 1637, 501 },
      -1,
   } },

   /* replace534_0 -> 29 in the cache */
   /* replace534_1 -> 139 in the cache */
   /* replace534 -> 1635 in the cache */

   /* ('ine', ('ushr', 'a@32', 31), 1) => ('ige', 'a', 0) */
   /* search535_0_0 -> 29 in the cache */
   /* search535_0_1 -> 32 in the cache */
   /* search535_0 -> 1637 in the cache */
   /* search535_1 -> 501 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ine,
      0, 1,
      { 1637, 501 },
      -1,
   } },

   /* replace535_0 -> 29 in the cache */
   /* replace535_1 -> 139 in the cache */
   /* replace535 -> 1632 in the cache */

   /* ('ine', ('ishr', 'a@32', 31), 0) => ('ilt', 'a', 0) */
   /* search536_0_0 -> 29 in the cache */
   /* search536_0_1 -> 32 in the cache */
   /* search536_0 -> 1626 in the cache */
   /* search536_1 -> 139 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ine,
      0, 1,
      { 1626, 139 },
      -1,
   } },

   /* replace536_0 -> 29 in the cache */
   /* replace536_1 -> 139 in the cache */
   /* replace536 -> 1635 in the cache */

   /* ('ieq', ('ishr', 'a@32', 31), 0) => ('ige', 'a', 0) */
   /* search537_0_0 -> 29 in the cache */
   /* search537_0_1 -> 32 in the cache */
   /* search537_0 -> 1626 in the cache */
   /* search537_1 -> 139 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ieq,
      0, 1,
      { 1626, 139 },
      -1,
   } },

   /* replace537_0 -> 29 in the cache */
   /* replace537_1 -> 139 in the cache */
   /* replace537 -> 1632 in the cache */

   /* ('ieq', ('ishr', 'a@32', 31), -1) => ('ilt', 'a', 0) */
   /* search538_0_0 -> 29 in the cache */
   /* search538_0_1 -> 32 in the cache */
   /* search538_0 -> 1626 in the cache */
   /* search538_1 -> 141 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ieq,
      0, 1,
      { 1626, 141 },
      -1,
   } },

   /* replace538_0 -> 29 in the cache */
   /* replace538_1 -> 139 in the cache */
   /* replace538 -> 1635 in the cache */

   /* ('ine', ('ishr', 'a@32', 31), -1) => ('ige', 'a', 0) */
   /* search539_0_0 -> 29 in the cache */
   /* search539_0_1 -> 32 in the cache */
   /* search539_0 -> 1626 in the cache */
   /* search539_1 -> 141 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ine,
      0, 1,
      { 1626, 141 },
      -1,
   } },

   /* replace539_0 -> 29 in the cache */
   /* replace539_1 -> 139 in the cache */
   /* replace539 -> 1632 in the cache */

   /* ('iand@64', 'a', ('inot', ('ishr', 'a', 63))) => ('imax', 'a', 0) */
   /* search540_0 -> 34 in the cache */
   /* search540_1_0_0 -> 34 in the cache */
   /* search540_1_0_1 -> 37 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ishr,
      -1, 0,
      { 34, 37 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_inot,
      -1, 0,
      { 1646 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_iand,
      0, 1,
      { 34, 1647 },
      -1,
   } },

   /* replace540_0 -> 34 in the cache */
   /* replace540_1 -> 1002 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_imax,
      0, 1,
      { 34, 1002 },
      -1,
   } },

   /* ('ieq', ('iand', 'a@64', 9223372036854775808), 0) => ('ige', 'a', 0) */
   /* search541_0_0 -> 34 in the cache */
   /* search541_0_1 -> 35 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_iand,
      1, 1,
      { 34, 35 },
      -1,
   } },
   /* search541_1 -> 1002 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ieq,
      0, 2,
      { 1650, 1002 },
      -1,
   } },

   /* replace541_0 -> 34 in the cache */
   /* replace541_1 -> 1002 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ige,
      -1, 0,
      { 34, 1002 },
      -1,
   } },

   /* ('ine', ('iand', 'a@64', 9223372036854775808), 9223372036854775808) => ('ige', 'a', 0) */
   /* search542_0_0 -> 34 in the cache */
   /* search542_0_1 -> 35 in the cache */
   /* search542_0 -> 1650 in the cache */
   /* search542_1 -> 35 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ine,
      0, 2,
      { 1650, 35 },
      -1,
   } },

   /* replace542_0 -> 34 in the cache */
   /* replace542_1 -> 1002 in the cache */
   /* replace542 -> 1652 in the cache */

   /* ('ine', ('iand', 'a@64', 9223372036854775808), 0) => ('ilt', 'a', 0) */
   /* search543_0_0 -> 34 in the cache */
   /* search543_0_1 -> 35 in the cache */
   /* search543_0 -> 1650 in the cache */
   /* search543_1 -> 1002 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ine,
      0, 2,
      { 1650, 1002 },
      -1,
   } },

   /* replace543_0 -> 34 in the cache */
   /* replace543_1 -> 1002 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ilt,
      -1, 0,
      { 34, 1002 },
      -1,
   } },

   /* ('ieq', ('iand', 'a@64', 9223372036854775808), 9223372036854775808) => ('ilt', 'a', 0) */
   /* search544_0_0 -> 34 in the cache */
   /* search544_0_1 -> 35 in the cache */
   /* search544_0 -> 1650 in the cache */
   /* search544_1 -> 35 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ieq,
      0, 2,
      { 1650, 35 },
      -1,
   } },

   /* replace544_0 -> 34 in the cache */
   /* replace544_1 -> 1002 in the cache */
   /* replace544 -> 1655 in the cache */

   /* ('ine', ('ushr', 'a@64', 63), 0) => ('ilt', 'a', 0) */
   /* search545_0_0 -> 34 in the cache */
   /* search545_0_1 -> 37 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ushr,
      -1, 0,
      { 34, 37 },
      -1,
   } },
   /* search545_1 -> 1002 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ine,
      0, 1,
      { 1657, 1002 },
      -1,
   } },

   /* replace545_0 -> 34 in the cache */
   /* replace545_1 -> 1002 in the cache */
   /* replace545 -> 1655 in the cache */

   /* ('ieq', ('ushr', 'a@64', 63), 0) => ('ige', 'a', 0) */
   /* search546_0_0 -> 34 in the cache */
   /* search546_0_1 -> 37 in the cache */
   /* search546_0 -> 1657 in the cache */
   /* search546_1 -> 1002 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ieq,
      0, 1,
      { 1657, 1002 },
      -1,
   } },

   /* replace546_0 -> 34 in the cache */
   /* replace546_1 -> 1002 in the cache */
   /* replace546 -> 1652 in the cache */

   /* ('ieq', ('ushr', 'a@64', 63), 1) => ('ilt', 'a', 0) */
   /* search547_0_0 -> 34 in the cache */
   /* search547_0_1 -> 37 in the cache */
   /* search547_0 -> 1657 in the cache */
   { .constant = {
      { nir_search_value_constant, 64 },
      nir_type_int, { 0x1ull /* 1 */ },
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ieq,
      0, 1,
      { 1657, 1660 },
      -1,
   } },

   /* replace547_0 -> 34 in the cache */
   /* replace547_1 -> 1002 in the cache */
   /* replace547 -> 1655 in the cache */

   /* ('ine', ('ushr', 'a@64', 63), 1) => ('ige', 'a', 0) */
   /* search548_0_0 -> 34 in the cache */
   /* search548_0_1 -> 37 in the cache */
   /* search548_0 -> 1657 in the cache */
   /* search548_1 -> 1660 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ine,
      0, 1,
      { 1657, 1660 },
      -1,
   } },

   /* replace548_0 -> 34 in the cache */
   /* replace548_1 -> 1002 in the cache */
   /* replace548 -> 1652 in the cache */

   /* ('ine', ('ishr', 'a@64', 63), 0) => ('ilt', 'a', 0) */
   /* search549_0_0 -> 34 in the cache */
   /* search549_0_1 -> 37 in the cache */
   /* search549_0 -> 1646 in the cache */
   /* search549_1 -> 1002 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ine,
      0, 1,
      { 1646, 1002 },
      -1,
   } },

   /* replace549_0 -> 34 in the cache */
   /* replace549_1 -> 1002 in the cache */
   /* replace549 -> 1655 in the cache */

   /* ('ieq', ('ishr', 'a@64', 63), 0) => ('ige', 'a', 0) */
   /* search550_0_0 -> 34 in the cache */
   /* search550_0_1 -> 37 in the cache */
   /* search550_0 -> 1646 in the cache */
   /* search550_1 -> 1002 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ieq,
      0, 1,
      { 1646, 1002 },
      -1,
   } },

   /* replace550_0 -> 34 in the cache */
   /* replace550_1 -> 1002 in the cache */
   /* replace550 -> 1652 in the cache */

   /* ('ieq', ('ishr', 'a@64', 63), -1) => ('ilt', 'a', 0) */
   /* search551_0_0 -> 34 in the cache */
   /* search551_0_1 -> 37 in the cache */
   /* search551_0 -> 1646 in the cache */
   { .constant = {
      { nir_search_value_constant, 64 },
      nir_type_int, { 0xffffffffffffffffull /* -1 */ },
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ieq,
      0, 1,
      { 1646, 1665 },
      -1,
   } },

   /* replace551_0 -> 34 in the cache */
   /* replace551_1 -> 1002 in the cache */
   /* replace551 -> 1655 in the cache */

   /* ('ine', ('ishr', 'a@64', 63), -1) => ('ige', 'a', 0) */
   /* search552_0_0 -> 34 in the cache */
   /* search552_0_1 -> 37 in the cache */
   /* search552_0 -> 1646 in the cache */
   /* search552_1 -> 1665 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ine,
      0, 1,
      { 1646, 1665 },
      -1,
   } },

   /* replace552_0 -> 34 in the cache */
   /* replace552_1 -> 1002 in the cache */
   /* replace552 -> 1652 in the cache */

   /* ('fmin', 'a', ('fneg', 'a')) => ('fneg', ('fabs', 'a')) */
   /* search553_0 -> 9 in the cache */
   /* search553_1_0 -> 9 in the cache */
   /* search553_1 -> 118 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fmin,
      0, 1,
      { 9, 118 },
      -1,
   } },

   /* replace553_0_0 -> 9 in the cache */
   /* replace553_0 -> 11 in the cache */
   /* replace553 -> 1436 in the cache */

   /* ('imin', 'a', ('ineg', 'a')) => ('ineg', ('iabs', 'a')) */
   /* search554_0 -> 9 in the cache */
   /* search554_1_0 -> 9 in the cache */
   /* search554_1 -> 120 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_imin,
      0, 1,
      { 9, 120 },
      -1,
   } },

   /* replace554_0_0 -> 9 in the cache */
   /* replace554_0 -> 125 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ineg,
      -1, 0,
      { 125 },
      -1,
   } },

   /* ('fmin', 'a', ('fneg', ('fabs', 'a'))) => ('fneg', ('fabs', 'a')) */
   /* search555_0 -> 9 in the cache */
   /* search555_1_0_0 -> 9 in the cache */
   /* search555_1_0 -> 11 in the cache */
   /* search555_1 -> 1436 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fmin,
      0, 1,
      { 9, 1436 },
      -1,
   } },

   /* replace555_0_0 -> 9 in the cache */
   /* replace555_0 -> 11 in the cache */
   /* replace555 -> 1436 in the cache */

   /* ('imin', 'a', ('ineg', ('iabs', 'a'))) => ('ineg', ('iabs', 'a')) */
   /* search556_0 -> 9 in the cache */
   /* search556_1_0_0 -> 9 in the cache */
   /* search556_1_0 -> 125 in the cache */
   /* search556_1 -> 1670 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_imin,
      0, 1,
      { 9, 1670 },
      -1,
   } },

   /* replace556_0_0 -> 9 in the cache */
   /* replace556_0 -> 125 in the cache */
   /* replace556 -> 1670 in the cache */

   /* ('~fmin', 'a', ('fabs', 'a')) => a */
   /* search557_0 -> 9 in the cache */
   /* search557_1_0 -> 9 in the cache */
   /* search557_1 -> 11 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      true,
      false,
      false,
      false,
      false,
      false,
      nir_op_fmin,
      0, 1,
      { 9, 11 },
      -1,
   } },

   /* replace557 -> 9 in the cache */

   /* ('imin', 'a', ('iabs', 'a')) => a */
   /* search558_0 -> 9 in the cache */
   /* search558_1_0 -> 9 in the cache */
   /* search558_1 -> 125 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_imin,
      0, 1,
      { 9, 125 },
      -1,
   } },

   /* replace558 -> 9 in the cache */

   /* ('~fmax', 'a', ('fneg', ('fabs', 'a'))) => a */
   /* search559_0 -> 9 in the cache */
   /* search559_1_0_0 -> 9 in the cache */
   /* search559_1_0 -> 11 in the cache */
   /* search559_1 -> 1436 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      true,
      false,
      false,
      false,
      false,
      false,
      nir_op_fmax,
      0, 1,
      { 9, 1436 },
      -1,
   } },

   /* replace559 -> 9 in the cache */

   /* ('imax', 'a', ('ineg', ('iabs', 'a'))) => a */
   /* search560_0 -> 9 in the cache */
   /* search560_1_0_0 -> 9 in the cache */
   /* search560_1_0 -> 125 in the cache */
   /* search560_1 -> 1670 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_imax,
      0, 1,
      { 9, 1670 },
      -1,
   } },

   /* replace560 -> 9 in the cache */

   /* ('fmax', 'a', ('fabs', 'a')) => ('fabs', 'a') */
   /* search561_0 -> 9 in the cache */
   /* search561_1_0 -> 9 in the cache */
   /* search561_1 -> 11 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fmax,
      0, 1,
      { 9, 11 },
      -1,
   } },

   /* replace561_0 -> 9 in the cache */
   /* replace561 -> 11 in the cache */

   /* ('imax', 'a', ('iabs', 'a')) => ('iabs', 'a') */
   /* search562_0 -> 9 in the cache */
   /* search562_1_0 -> 9 in the cache */
   /* search562_1 -> 125 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_imax,
      0, 1,
      { 9, 125 },
      -1,
   } },

   /* replace562_0 -> 9 in the cache */
   /* replace562 -> 125 in the cache */

   /* ('fmax', 'a', ('fneg', 'a')) => ('fabs', 'a') */
   /* search563_0 -> 9 in the cache */
   /* search563_1_0 -> 9 in the cache */
   /* search563_1 -> 118 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fmax,
      0, 1,
      { 9, 118 },
      -1,
   } },

   /* replace563_0 -> 9 in the cache */
   /* replace563 -> 11 in the cache */

   /* ('imax', 'a', ('ineg', 'a')) => ('iabs', 'a') */
   /* search564_0 -> 9 in the cache */
   /* search564_1_0 -> 9 in the cache */
   /* search564_1 -> 120 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_imax,
      0, 1,
      { 9, 120 },
      -1,
   } },

   /* replace564_0 -> 9 in the cache */
   /* replace564 -> 125 in the cache */

   /* ('~fmax', ('fabs', 'a'), 0.0) => ('fabs', 'a') */
   /* search565_0_0 -> 9 in the cache */
   /* search565_0 -> 11 in the cache */
   /* search565_1 -> 8 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      true,
      false,
      false,
      false,
      false,
      false,
      nir_op_fmax,
      0, 1,
      { 11, 8 },
      -1,
   } },

   /* replace565_0 -> 9 in the cache */
   /* replace565 -> 11 in the cache */

   /* ('fmin', ('fmax', 'a', 0.0), 1.0) => ('fsat', 'a') */
   /* search566_0_0 -> 9 in the cache */
   /* search566_0_1 -> 8 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fmax,
      1, 1,
      { 9, 8 },
      -1,
   } },
   /* search566_1 -> 262 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fmin,
      0, 2,
      { 1682, 262 },
      -1,
   } },

   /* replace566_0 -> 9 in the cache */
   /* replace566 -> 238 in the cache */

   /* ('~fmax', ('fmin', 'a', 1.0), 0.0) => ('fsat', 'a') */
   /* search567_0_0 -> 9 in the cache */
   /* search567_0_1 -> 262 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fmin,
      1, 1,
      { 9, 262 },
      -1,
   } },
   /* search567_1 -> 8 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      true,
      false,
      false,
      false,
      false,
      false,
      nir_op_fmax,
      0, 2,
      { 1684, 8 },
      -1,
   } },

   /* replace567_0 -> 9 in the cache */
   /* replace567 -> 238 in the cache */

   /* ('~fmin', ('fmax', 'a', -1.0), 0.0) => ('fneg', ('fsat', ('fneg', 'a'))) */
   /* search568_0_0 -> 9 in the cache */
   /* search568_0_1 -> 268 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fmax,
      1, 1,
      { 9, 268 },
      -1,
   } },
   /* search568_1 -> 8 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      true,
      false,
      false,
      false,
      false,
      false,
      nir_op_fmin,
      0, 2,
      { 1686, 8 },
      -1,
   } },

   /* replace568_0_0_0 -> 9 in the cache */
   /* replace568_0_0 -> 118 in the cache */
   /* replace568_0 -> 239 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fneg,
      -1, 0,
      { 239 },
      -1,
   } },

   /* ('~fmax', ('fmin', 'a', 0.0), -1.0) => ('fneg', ('fsat', ('fneg', 'a'))) */
   /* search569_0_0 -> 9 in the cache */
   /* search569_0_1 -> 8 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fmin,
      1, 1,
      { 9, 8 },
      -1,
   } },
   /* search569_1 -> 268 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      true,
      false,
      false,
      false,
      false,
      false,
      nir_op_fmax,
      0, 2,
      { 1689, 268 },
      -1,
   } },

   /* replace569_0_0_0 -> 9 in the cache */
   /* replace569_0_0 -> 118 in the cache */
   /* replace569_0 -> 239 in the cache */
   /* replace569 -> 1688 in the cache */

   /* ('fsat', ('fsign', 'a')) => ('b2f', ('!flt', 0.0, 'a')) */
   /* search570_0_0 -> 9 in the cache */
   /* search570_0 -> 110 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fsat,
      -1, 0,
      { 110 },
      -1,
   } },

   /* replace570_0_0 -> 8 in the cache */
   /* replace570_0_1 -> 9 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      true,
      false,
      false,
      false,
      false,
      nir_op_flt,
      -1, 0,
      { 8, 9 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_search_op_b2f,
      -1, 0,
      { 1692 },
      -1,
   } },

   /* ('fsat', ('b2f', 'a')) => ('b2f', 'a') */
   /* search571_0_0 -> 9 in the cache */
   { .expression = {
      { nir_search_value_expression, 0 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_search_op_b2f,
      -1, 0,
      { 9 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 0 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fsat,
      -1, 0,
      { 1694 },
      -1,
   } },

   /* replace571_0 -> 9 in the cache */
   /* replace571 -> 1694 in the cache */

   /* ('fsat', 'a') => ('fmin', ('fmax', 'a', 0.0), 1.0) */
   /* search572_0 -> 9 in the cache */
   /* search572 -> 238 in the cache */

   /* replace572_0_0 -> 9 in the cache */
   /* replace572_0_1 -> 8 in the cache */
   /* replace572_0 -> 1682 in the cache */
   /* replace572_1 -> 262 in the cache */
   /* replace572 -> 1683 in the cache */

   /* ('fsat', ('fsat', 'a')) => ('fsat', 'a') */
   /* search573_0_0 -> 9 in the cache */
   /* search573_0 -> 238 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fsat,
      -1, 0,
      { 238 },
      -1,
   } },

   /* replace573_0 -> 9 in the cache */
   /* replace573 -> 238 in the cache */

   /* ('fsat', ('fneg(is_used_once)', ('fadd(is_used_once)', 'a', 'b'))) => ('fsat', ('fadd', ('fneg', 'a'), ('fneg', 'b'))) */
   /* search574_0_0_0 -> 0 in the cache */
   /* search574_0_0_1 -> 1 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fadd,
      0, 1,
      { 0, 1 },
      0,
   } },
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fneg,
      -1, 1,
      { 1697 },
      0,
   } },
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fsat,
      -1, 1,
      { 1698 },
      -1,
   } },

   /* replace574_0_0_0 -> 0 in the cache */
   /* replace574_0_0 -> 132 in the cache */
   /* replace574_0_1_0 -> 1 in the cache */
   /* replace574_0_1 -> 1237 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fadd,
      0, 1,
      { 132, 1237 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fsat,
      -1, 1,
      { 1700 },
      -1,
   } },

   /* ('fsat', ('fneg(is_used_once)', ('fmul(is_used_once)', 'a', 'b'))) => ('fsat', ('fmul', ('fneg', 'a'), 'b')) */
   /* search575_0_0_0 -> 0 in the cache */
   /* search575_0_0_1 -> 1 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fmul,
      0, 1,
      { 0, 1 },
      0,
   } },
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fneg,
      -1, 1,
      { 1702 },
      0,
   } },
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fsat,
      -1, 1,
      { 1703 },
      -1,
   } },

   /* replace575_0_0_0 -> 0 in the cache */
   /* replace575_0_0 -> 132 in the cache */
   /* replace575_0_1 -> 1 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fmul,
      0, 1,
      { 132, 1 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fsat,
      -1, 1,
      { 1705 },
      -1,
   } },

   /* ('fsat(nsz)', ('fneg(is_used_once)', ('fmulz(is_used_once)', 'a', 'b'))) => ('fsat', ('fmulz', ('fneg', 'a'), 'b')) */
   /* search576_0_0_0 -> 29 in the cache */
   /* search576_0_0_1 -> 48 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fmulz,
      0, 1,
      { 29, 48 },
      0,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fneg,
      -1, 1,
      { 1707 },
      0,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      true,
      false,
      false,
      nir_op_fsat,
      -1, 1,
      { 1708 },
      -1,
   } },

   /* replace576_0_0_0 -> 29 in the cache */
   /* replace576_0_0 -> 296 in the cache */
   /* replace576_0_1 -> 48 in the cache */
   /* replace576_0 -> 436 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fsat,
      -1, 1,
      { 436 },
      -1,
   } },

   /* ('fsat', ('fabs(is_used_once)', ('fmul(is_used_once)', 'a', 'b'))) => ('fsat', ('fmul', ('fabs', 'a'), ('fabs', 'b'))) */
   /* search577_0_0_0 -> 0 in the cache */
   /* search577_0_0_1 -> 1 in the cache */
   /* search577_0_0 -> 1702 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fabs,
      -1, 1,
      { 1702 },
      0,
   } },
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fsat,
      -1, 1,
      { 1711 },
      -1,
   } },

   /* replace577_0_0_0 -> 0 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fabs,
      -1, 0,
      { 0 },
      -1,
   } },
   /* replace577_0_1_0 -> 1 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fabs,
      -1, 0,
      { 1 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fmul,
      0, 1,
      { 1713, 1714 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fsat,
      -1, 1,
      { 1715 },
      -1,
   } },

   /* ('fmin', ('fmax', ('fmin', ('fmax', 'a', 'b'), 'c'), 'b'), 'c') => ('fmin', ('fmax', 'a', 'b'), 'c') */
   /* search578_0_0_0_0 -> 143 in the cache */
   /* search578_0_0_0_1 -> 144 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fmax,
      3, 1,
      { 143, 144 },
      -1,
   } },
   /* search578_0_0_1 -> 146 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fmin,
      2, 2,
      { 1717, 146 },
      -1,
   } },
   /* search578_0_1 -> 144 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fmax,
      1, 3,
      { 1718, 144 },
      -1,
   } },
   /* search578_1 -> 146 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fmin,
      0, 4,
      { 1719, 146 },
      -1,
   } },

   /* replace578_0_0 -> 143 in the cache */
   /* replace578_0_1 -> 144 in the cache */
   /* replace578_0 -> 1526 in the cache */
   /* replace578_1 -> 146 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fmin,
      0, 2,
      { 1526, 146 },
      -1,
   } },

   /* ('imin', ('imax', ('imin', ('imax', 'a', 'b'), 'c'), 'b'), 'c') => ('imin', ('imax', 'a', 'b'), 'c') */
   /* search579_0_0_0_0 -> 143 in the cache */
   /* search579_0_0_0_1 -> 144 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_imax,
      3, 1,
      { 143, 144 },
      -1,
   } },
   /* search579_0_0_1 -> 146 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_imin,
      2, 2,
      { 1722, 146 },
      -1,
   } },
   /* search579_0_1 -> 144 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_imax,
      1, 3,
      { 1723, 144 },
      -1,
   } },
   /* search579_1 -> 146 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_imin,
      0, 4,
      { 1724, 146 },
      -1,
   } },

   /* replace579_0_0 -> 143 in the cache */
   /* replace579_0_1 -> 144 in the cache */
   /* replace579_0 -> 1536 in the cache */
   /* replace579_1 -> 146 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_imin,
      0, 2,
      { 1536, 146 },
      -1,
   } },

   /* ('umin', ('umax', ('umin', ('umax', 'a', 'b'), 'c'), 'b'), 'c') => ('umin', ('umax', 'a', 'b'), 'c') */
   /* search580_0_0_0_0 -> 143 in the cache */
   /* search580_0_0_0_1 -> 144 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_umax,
      3, 1,
      { 143, 144 },
      -1,
   } },
   /* search580_0_0_1 -> 146 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_umin,
      2, 2,
      { 1727, 146 },
      -1,
   } },
   /* search580_0_1 -> 144 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_umax,
      1, 3,
      { 1728, 144 },
      -1,
   } },
   /* search580_1 -> 146 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_umin,
      0, 4,
      { 1729, 146 },
      -1,
   } },

   /* replace580_0_0 -> 143 in the cache */
   /* replace580_0_1 -> 144 in the cache */
   /* replace580_0 -> 1531 in the cache */
   /* replace580_1 -> 146 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_umin,
      0, 2,
      { 1531, 146 },
      -1,
   } },

   /* ('fmax', ('fsat', 'a'), '#b(is_zero_to_one)') => ('fsat', ('fmax', 'a', 'b')) */
   /* search581_0_0 -> 0 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fsat,
      -1, 0,
      { 0 },
      -1,
   } },
   { .variable = {
      { nir_search_value_variable, -2 },
      1, /* b */
      true,
      nir_type_invalid,
      21,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fmax,
      0, 1,
      { 1732, 1733 },
      -1,
   } },

   /* replace581_0_0 -> 0 in the cache */
   /* replace581_0_1 -> 1 in the cache */
   /* replace581_0 -> 1463 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fsat,
      -1, 1,
      { 1463 },
      -1,
   } },

   /* ('fmax', ('fsat(is_used_once)', 'a'), ('fsat(is_used_once)', 'b')) => ('fsat', ('fmax', 'a', 'b')) */
   /* search582_0_0 -> 0 in the cache */
   /* search582_0 -> 1296 in the cache */
   /* search582_1_0 -> 1 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fsat,
      -1, 0,
      { 1 },
      0,
   } },
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fmax,
      0, 1,
      { 1296, 1736 },
      -1,
   } },

   /* replace582_0_0 -> 0 in the cache */
   /* replace582_0_1 -> 1 in the cache */
   /* replace582_0 -> 1463 in the cache */
   /* replace582 -> 1735 in the cache */

   /* ('~fmin', ('fsat', 'a'), '#b(is_zero_to_one)') => ('fsat', ('fmin', 'a', 'b')) */
   /* search583_0_0 -> 0 in the cache */
   /* search583_0 -> 1732 in the cache */
   /* search583_1 -> 1733 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      true,
      false,
      false,
      false,
      false,
      false,
      nir_op_fmin,
      0, 1,
      { 1732, 1733 },
      -1,
   } },

   /* replace583_0_0 -> 0 in the cache */
   /* replace583_0_1 -> 1 in the cache */
   /* replace583_0 -> 1465 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fsat,
      -1, 1,
      { 1465 },
      -1,
   } },

   /* ('fsat', ('fadd', 1.0, 'a(is_ge_zero)')) => 1.0 */
   /* search584_0_0 -> 262 in the cache */
   { .variable = {
      { nir_search_value_variable, -1 },
      0, /* a */
      false,
      nir_type_invalid,
      22,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fadd,
      0, 1,
      { 262, 1740 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fsat,
      -1, 1,
      { 1741 },
      -1,
   } },

   /* replace584 -> 262 in the cache */

   /* ('fneg', ('bcsel(is_used_once)', 'a', '#b', '#c')) => ('bcsel', 'a', ('fneg', 'b'), ('fneg', 'c')) */
   /* search585_0_0 -> 862 in the cache */
   /* search585_0_1 -> 299 in the cache */
   /* search585_0_2 -> 919 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_bcsel,
      -1, 0,
      { 862, 299, 919 },
      0,
   } },
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fneg,
      -1, 0,
      { 1743 },
      -1,
   } },

   /* replace585_0 -> 862 in the cache */
   /* replace585_1_0 -> 144 in the cache */
   /* replace585_1 -> 1375 in the cache */
   /* replace585_2_0 -> 146 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fneg,
      -1, 0,
      { 146 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_bcsel,
      -1, 0,
      { 862, 1375, 1745 },
      -1,
   } },

   /* ('fmax', ('fneg', ('fmin', 'b', 'a')), 'b') => ('fmax', ('fabs', 'b'), ('fneg', 'a')) */
   /* search586_0_0_0 -> 1254 in the cache */
   /* search586_0_0_1 -> 1253 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fmin,
      1, 1,
      { 1254, 1253 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fneg,
      -1, 1,
      { 1747 },
      -1,
   } },
   /* search586_1 -> 1254 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fmax,
      0, 2,
      { 1748, 1254 },
      -1,
   } },

   /* replace586_0_0 -> 1254 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fabs,
      -1, 0,
      { 1254 },
      -1,
   } },
   /* replace586_1_0 -> 1253 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fneg,
      -1, 0,
      { 1253 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fmax,
      0, 1,
      { 1750, 1751 },
      -1,
   } },

   /* ('fmin', ('fneg', ('fmax', 'b', 'a')), 'b') => ('fmin', ('fneg', ('fabs', 'b')), ('fneg', 'a')) */
   /* search587_0_0_0 -> 1254 in the cache */
   /* search587_0_0_1 -> 1253 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fmax,
      1, 1,
      { 1254, 1253 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fneg,
      -1, 1,
      { 1753 },
      -1,
   } },
   /* search587_1 -> 1254 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fmin,
      0, 2,
      { 1754, 1254 },
      -1,
   } },

   /* replace587_0_0_0 -> 1254 in the cache */
   /* replace587_0_0 -> 1750 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fneg,
      -1, 0,
      { 1750 },
      -1,
   } },
   /* replace587_1_0 -> 1253 in the cache */
   /* replace587_1 -> 1751 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fmin,
      0, 1,
      { 1756, 1751 },
      -1,
   } },

   /* ('fmax', ('fadd(is_used_once)', ('fneg', 'a(is_not_negative)'), '#b(is_zero_to_one)'), 0.0) => ('fsat', ('fadd', ('fneg', 'a'), 'b')) */
   { .variable = {
      { nir_search_value_variable, -2 },
      0, /* a */
      false,
      nir_type_invalid,
      23,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fneg,
      -1, 0,
      { 1758 },
      -1,
   } },
   /* search588_0_1 -> 1733 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fadd,
      1, 1,
      { 1759, 1733 },
      0,
   } },
   /* search588_1 -> 276 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fmax,
      0, 2,
      { 1760, 276 },
      -1,
   } },

   /* replace588_0_0_0 -> 0 in the cache */
   /* replace588_0_0 -> 132 in the cache */
   /* replace588_0_1 -> 1 in the cache */
   /* replace588_0 -> 293 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fsat,
      -1, 1,
      { 293 },
      -1,
   } },

   /* ('extract_u8', ('imin', ('imax', 'a', 0), 255), 0) => ('imin', ('imax', 'a', 0), 255) */
   /* search589_0_0_0 -> 9 in the cache */
   /* search589_0_0_1 -> 73 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_imax,
      1, 1,
      { 9, 73 },
      -1,
   } },
   { .constant = {
      { nir_search_value_constant, -1 },
      nir_type_int, { 0xffull /* 255 */ },
   } },
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_imin,
      0, 2,
      { 1763, 1764 },
      -1,
   } },
   /* search589_1 -> 73 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_extract_u8,
      -1, 2,
      { 1765, 73 },
      -1,
   } },

   /* replace589_0_0 -> 9 in the cache */
   /* replace589_0_1 -> 73 in the cache */
   /* replace589_0 -> 1763 in the cache */
   /* replace589_1 -> 1764 in the cache */
   /* replace589 -> 1765 in the cache */

   /* ('ior', ('flt(is_used_once)', 'a', 'b'), ('flt', 'a', 'c')) => ('flt', 'a', ('!fmax', 'b', 'c')) */
   /* search590_0_0 -> 143 in the cache */
   /* search590_0_1 -> 144 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_flt,
      -1, 0,
      { 143, 144 },
      0,
   } },
   /* search590_1_0 -> 143 in the cache */
   /* search590_1_1 -> 146 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_flt,
      -1, 0,
      { 143, 146 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ior,
      0, 1,
      { 1767, 1768 },
      -1,
   } },

   /* replace590_0 -> 143 in the cache */
   /* replace590_1_0 -> 144 in the cache */
   /* replace590_1_1 -> 146 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      true,
      false,
      false,
      false,
      false,
      nir_op_fmax,
      0, 1,
      { 144, 146 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_flt,
      -1, 1,
      { 143, 1770 },
      -1,
   } },

   /* ('ior', ('flt(is_used_once)', 'a', 'c'), ('flt', 'b', 'c')) => ('flt', ('!fmin', 'a', 'b'), 'c') */
   /* search591_0_0 -> 0 in the cache */
   /* search591_0_1 -> 786 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_flt,
      -1, 0,
      { 0, 786 },
      0,
   } },
   { .variable = {
      { nir_search_value_variable, -2 },
      2, /* b */
      false,
      nir_type_invalid,
      -1,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   /* search591_1_1 -> 786 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_flt,
      -1, 0,
      { 1773, 786 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ior,
      0, 1,
      { 1772, 1774 },
      -1,
   } },

   /* replace591_0_0 -> 0 in the cache */
   /* replace591_0_1 -> 1773 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      true,
      false,
      false,
      false,
      false,
      nir_op_fmin,
      0, 1,
      { 0, 1773 },
      -1,
   } },
   /* replace591_1 -> 786 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_flt,
      -1, 1,
      { 1776, 786 },
      -1,
   } },

   /* ('ior', ('fge(is_used_once)', 'a', 'b'), ('fge', 'a', 'c')) => ('fge', 'a', ('!fmin', 'b', 'c')) */
   /* search592_0_0 -> 143 in the cache */
   /* search592_0_1 -> 144 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fge,
      -1, 0,
      { 143, 144 },
      0,
   } },
   /* search592_1_0 -> 143 in the cache */
   /* search592_1_1 -> 146 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fge,
      -1, 0,
      { 143, 146 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ior,
      0, 1,
      { 1778, 1779 },
      -1,
   } },

   /* replace592_0 -> 143 in the cache */
   /* replace592_1_0 -> 144 in the cache */
   /* replace592_1_1 -> 146 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      true,
      false,
      false,
      false,
      false,
      nir_op_fmin,
      0, 1,
      { 144, 146 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fge,
      -1, 1,
      { 143, 1781 },
      -1,
   } },

   /* ('ior', ('fge(is_used_once)', 'a', 'c'), ('fge', 'b', 'c')) => ('fge', ('!fmax', 'a', 'b'), 'c') */
   /* search593_0_0 -> 0 in the cache */
   /* search593_0_1 -> 786 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fge,
      -1, 0,
      { 0, 786 },
      0,
   } },
   /* search593_1_0 -> 1773 in the cache */
   /* search593_1_1 -> 786 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fge,
      -1, 0,
      { 1773, 786 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ior,
      0, 1,
      { 1783, 1784 },
      -1,
   } },

   /* replace593_0_0 -> 0 in the cache */
   /* replace593_0_1 -> 1773 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      true,
      false,
      false,
      false,
      false,
      nir_op_fmax,
      0, 1,
      { 0, 1773 },
      -1,
   } },
   /* replace593_1 -> 786 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fge,
      -1, 1,
      { 1786, 786 },
      -1,
   } },

   /* ('ior', ('flt', 'a', '#b'), ('flt', 'a', '#c')) => ('flt', 'a', ('!fmax', 'b', 'c')) */
   /* search594_0_0 -> 143 in the cache */
   /* search594_0_1 -> 299 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_flt,
      -1, 0,
      { 143, 299 },
      -1,
   } },
   /* search594_1_0 -> 143 in the cache */
   /* search594_1_1 -> 919 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_flt,
      -1, 0,
      { 143, 919 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ior,
      0, 1,
      { 1788, 1789 },
      -1,
   } },

   /* replace594_0 -> 143 in the cache */
   /* replace594_1_0 -> 144 in the cache */
   /* replace594_1_1 -> 146 in the cache */
   /* replace594_1 -> 1770 in the cache */
   /* replace594 -> 1771 in the cache */

   /* ('ior', ('flt', '#a', 'c'), ('flt', '#b', 'c')) => ('flt', ('!fmin', 'a', 'b'), 'c') */
   { .variable = {
      { nir_search_value_variable, -2 },
      0, /* a */
      true,
      nir_type_invalid,
      -1,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   /* search595_0_1 -> 786 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_flt,
      -1, 0,
      { 1791, 786 },
      -1,
   } },
   { .variable = {
      { nir_search_value_variable, -2 },
      2, /* b */
      true,
      nir_type_invalid,
      -1,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   /* search595_1_1 -> 786 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_flt,
      -1, 0,
      { 1793, 786 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ior,
      0, 1,
      { 1792, 1794 },
      -1,
   } },

   /* replace595_0_0 -> 0 in the cache */
   /* replace595_0_1 -> 1773 in the cache */
   /* replace595_0 -> 1776 in the cache */
   /* replace595_1 -> 786 in the cache */
   /* replace595 -> 1777 in the cache */

   /* ('ior', ('fge', 'a', '#b'), ('fge', 'a', '#c')) => ('fge', 'a', ('!fmin', 'b', 'c')) */
   /* search596_0_0 -> 143 in the cache */
   /* search596_0_1 -> 299 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fge,
      -1, 0,
      { 143, 299 },
      -1,
   } },
   /* search596_1_0 -> 143 in the cache */
   /* search596_1_1 -> 919 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fge,
      -1, 0,
      { 143, 919 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ior,
      0, 1,
      { 1796, 1797 },
      -1,
   } },

   /* replace596_0 -> 143 in the cache */
   /* replace596_1_0 -> 144 in the cache */
   /* replace596_1_1 -> 146 in the cache */
   /* replace596_1 -> 1781 in the cache */
   /* replace596 -> 1782 in the cache */

   /* ('ior', ('fge', '#a', 'c'), ('fge', '#b', 'c')) => ('fge', ('!fmax', 'a', 'b'), 'c') */
   /* search597_0_0 -> 1791 in the cache */
   /* search597_0_1 -> 786 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fge,
      -1, 0,
      { 1791, 786 },
      -1,
   } },
   /* search597_1_0 -> 1793 in the cache */
   /* search597_1_1 -> 786 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fge,
      -1, 0,
      { 1793, 786 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ior,
      0, 1,
      { 1799, 1800 },
      -1,
   } },

   /* replace597_0_0 -> 0 in the cache */
   /* replace597_0_1 -> 1773 in the cache */
   /* replace597_0 -> 1786 in the cache */
   /* replace597_1 -> 786 in the cache */
   /* replace597 -> 1787 in the cache */

   /* ('~iand', ('flt(is_used_once)', 'a', 'b'), ('flt', 'a', 'c')) => ('flt', 'a', ('fmin', 'b', 'c')) */
   /* search598_0_0 -> 143 in the cache */
   /* search598_0_1 -> 144 in the cache */
   /* search598_0 -> 1767 in the cache */
   /* search598_1_0 -> 143 in the cache */
   /* search598_1_1 -> 146 in the cache */
   /* search598_1 -> 1768 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      true,
      false,
      false,
      false,
      false,
      false,
      nir_op_iand,
      0, 1,
      { 1767, 1768 },
      -1,
   } },

   /* replace598_0 -> 143 in the cache */
   /* replace598_1_0 -> 144 in the cache */
   /* replace598_1_1 -> 146 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fmin,
      0, 1,
      { 144, 146 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_flt,
      -1, 1,
      { 143, 1803 },
      -1,
   } },

   /* ('~iand', ('flt(is_used_once)', 'a', 'c'), ('flt', 'b', 'c')) => ('flt', ('fmax', 'a', 'b'), 'c') */
   /* search599_0_0 -> 0 in the cache */
   /* search599_0_1 -> 786 in the cache */
   /* search599_0 -> 1772 in the cache */
   /* search599_1_0 -> 1773 in the cache */
   /* search599_1_1 -> 786 in the cache */
   /* search599_1 -> 1774 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      true,
      false,
      false,
      false,
      false,
      false,
      nir_op_iand,
      0, 1,
      { 1772, 1774 },
      -1,
   } },

   /* replace599_0_0 -> 0 in the cache */
   /* replace599_0_1 -> 1773 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fmax,
      0, 1,
      { 0, 1773 },
      -1,
   } },
   /* replace599_1 -> 786 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_flt,
      -1, 1,
      { 1806, 786 },
      -1,
   } },

   /* ('~iand', ('fge(is_used_once)', 'a', 'b'), ('fge', 'a', 'c')) => ('fge', 'a', ('fmax', 'b', 'c')) */
   /* search600_0_0 -> 143 in the cache */
   /* search600_0_1 -> 144 in the cache */
   /* search600_0 -> 1778 in the cache */
   /* search600_1_0 -> 143 in the cache */
   /* search600_1_1 -> 146 in the cache */
   /* search600_1 -> 1779 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      true,
      false,
      false,
      false,
      false,
      false,
      nir_op_iand,
      0, 1,
      { 1778, 1779 },
      -1,
   } },

   /* replace600_0 -> 143 in the cache */
   /* replace600_1_0 -> 144 in the cache */
   /* replace600_1_1 -> 146 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fmax,
      0, 1,
      { 144, 146 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fge,
      -1, 1,
      { 143, 1809 },
      -1,
   } },

   /* ('~iand', ('fge(is_used_once)', 'a', 'c'), ('fge', 'b', 'c')) => ('fge', ('fmin', 'a', 'b'), 'c') */
   /* search601_0_0 -> 0 in the cache */
   /* search601_0_1 -> 786 in the cache */
   /* search601_0 -> 1783 in the cache */
   /* search601_1_0 -> 1773 in the cache */
   /* search601_1_1 -> 786 in the cache */
   /* search601_1 -> 1784 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      true,
      false,
      false,
      false,
      false,
      false,
      nir_op_iand,
      0, 1,
      { 1783, 1784 },
      -1,
   } },

   /* replace601_0_0 -> 0 in the cache */
   /* replace601_0_1 -> 1773 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fmin,
      0, 1,
      { 0, 1773 },
      -1,
   } },
   /* replace601_1 -> 786 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fge,
      -1, 1,
      { 1812, 786 },
      -1,
   } },

   /* ('iand', ('flt', 'a', '#b(is_a_number)'), ('flt', 'a', '#c(is_a_number)')) => ('flt', 'a', ('fmin', 'b', 'c')) */
   /* search602_0_0 -> 143 in the cache */
   { .variable = {
      { nir_search_value_variable, -3 },
      1, /* b */
      true,
      nir_type_invalid,
      19,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_flt,
      -1, 0,
      { 143, 1814 },
      -1,
   } },
   /* search602_1_0 -> 143 in the cache */
   { .variable = {
      { nir_search_value_variable, -3 },
      2, /* c */
      true,
      nir_type_invalid,
      19,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_flt,
      -1, 0,
      { 143, 1816 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_iand,
      0, 1,
      { 1815, 1817 },
      -1,
   } },

   /* replace602_0 -> 143 in the cache */
   /* replace602_1_0 -> 144 in the cache */
   /* replace602_1_1 -> 146 in the cache */
   /* replace602_1 -> 1803 in the cache */
   /* replace602 -> 1804 in the cache */

   /* ('iand', ('flt', '#a(is_a_number)', 'c'), ('flt', '#b(is_a_number)', 'c')) => ('flt', ('fmax', 'a', 'b'), 'c') */
   { .variable = {
      { nir_search_value_variable, -2 },
      0, /* a */
      true,
      nir_type_invalid,
      19,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   /* search603_0_1 -> 786 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_flt,
      -1, 0,
      { 1819, 786 },
      -1,
   } },
   { .variable = {
      { nir_search_value_variable, -2 },
      2, /* b */
      true,
      nir_type_invalid,
      19,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   /* search603_1_1 -> 786 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_flt,
      -1, 0,
      { 1821, 786 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_iand,
      0, 1,
      { 1820, 1822 },
      -1,
   } },

   /* replace603_0_0 -> 0 in the cache */
   /* replace603_0_1 -> 1773 in the cache */
   /* replace603_0 -> 1806 in the cache */
   /* replace603_1 -> 786 in the cache */
   /* replace603 -> 1807 in the cache */

   /* ('iand', ('fge', 'a', '#b(is_a_number)'), ('fge', 'a', '#c(is_a_number)')) => ('fge', 'a', ('fmax', 'b', 'c')) */
   /* search604_0_0 -> 143 in the cache */
   /* search604_0_1 -> 1814 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fge,
      -1, 0,
      { 143, 1814 },
      -1,
   } },
   /* search604_1_0 -> 143 in the cache */
   /* search604_1_1 -> 1816 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fge,
      -1, 0,
      { 143, 1816 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_iand,
      0, 1,
      { 1824, 1825 },
      -1,
   } },

   /* replace604_0 -> 143 in the cache */
   /* replace604_1_0 -> 144 in the cache */
   /* replace604_1_1 -> 146 in the cache */
   /* replace604_1 -> 1809 in the cache */
   /* replace604 -> 1810 in the cache */

   /* ('iand', ('fge', '#a(is_a_number)', 'c'), ('fge', '#b(is_a_number)', 'c')) => ('fge', ('fmin', 'a', 'b'), 'c') */
   /* search605_0_0 -> 1819 in the cache */
   /* search605_0_1 -> 786 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fge,
      -1, 0,
      { 1819, 786 },
      -1,
   } },
   /* search605_1_0 -> 1821 in the cache */
   /* search605_1_1 -> 786 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fge,
      -1, 0,
      { 1821, 786 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_iand,
      0, 1,
      { 1827, 1828 },
      -1,
   } },

   /* replace605_0_0 -> 0 in the cache */
   /* replace605_0_1 -> 1773 in the cache */
   /* replace605_0 -> 1812 in the cache */
   /* replace605_1 -> 786 in the cache */
   /* replace605 -> 1813 in the cache */

   /* ('ior', ('ilt(is_used_once)', 'a', 'b'), ('ilt', 'a', 'c')) => ('ilt', 'a', ('imax', 'b', 'c')) */
   /* search606_0_0 -> 143 in the cache */
   /* search606_0_1 -> 144 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ilt,
      -1, 0,
      { 143, 144 },
      0,
   } },
   /* search606_1_0 -> 143 in the cache */
   /* search606_1_1 -> 146 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ilt,
      -1, 0,
      { 143, 146 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ior,
      0, 1,
      { 1830, 1831 },
      -1,
   } },

   /* replace606_0 -> 143 in the cache */
   /* replace606_1_0 -> 144 in the cache */
   /* replace606_1_1 -> 146 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_imax,
      0, 1,
      { 144, 146 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ilt,
      -1, 1,
      { 143, 1833 },
      -1,
   } },

   /* ('ior', ('ilt(is_used_once)', 'a', 'c'), ('ilt', 'b', 'c')) => ('ilt', ('imin', 'a', 'b'), 'c') */
   /* search607_0_0 -> 0 in the cache */
   /* search607_0_1 -> 786 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ilt,
      -1, 0,
      { 0, 786 },
      0,
   } },
   /* search607_1_0 -> 1773 in the cache */
   /* search607_1_1 -> 786 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ilt,
      -1, 0,
      { 1773, 786 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ior,
      0, 1,
      { 1835, 1836 },
      -1,
   } },

   /* replace607_0_0 -> 0 in the cache */
   /* replace607_0_1 -> 1773 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_imin,
      0, 1,
      { 0, 1773 },
      -1,
   } },
   /* replace607_1 -> 786 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ilt,
      -1, 1,
      { 1838, 786 },
      -1,
   } },

   /* ('ior', ('ige(is_used_once)', 'a', 'b'), ('ige', 'a', 'c')) => ('ige', 'a', ('imin', 'b', 'c')) */
   /* search608_0_0 -> 143 in the cache */
   /* search608_0_1 -> 144 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ige,
      -1, 0,
      { 143, 144 },
      0,
   } },
   /* search608_1_0 -> 143 in the cache */
   /* search608_1_1 -> 146 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ige,
      -1, 0,
      { 143, 146 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ior,
      0, 1,
      { 1840, 1841 },
      -1,
   } },

   /* replace608_0 -> 143 in the cache */
   /* replace608_1_0 -> 144 in the cache */
   /* replace608_1_1 -> 146 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_imin,
      0, 1,
      { 144, 146 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ige,
      -1, 1,
      { 143, 1843 },
      -1,
   } },

   /* ('ior', ('ige(is_used_once)', 'a', 'c'), ('ige', 'b', 'c')) => ('ige', ('imax', 'a', 'b'), 'c') */
   /* search609_0_0 -> 0 in the cache */
   /* search609_0_1 -> 786 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ige,
      -1, 0,
      { 0, 786 },
      0,
   } },
   /* search609_1_0 -> 1773 in the cache */
   /* search609_1_1 -> 786 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ige,
      -1, 0,
      { 1773, 786 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ior,
      0, 1,
      { 1845, 1846 },
      -1,
   } },

   /* replace609_0_0 -> 0 in the cache */
   /* replace609_0_1 -> 1773 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_imax,
      0, 1,
      { 0, 1773 },
      -1,
   } },
   /* replace609_1 -> 786 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ige,
      -1, 1,
      { 1848, 786 },
      -1,
   } },

   /* ('ior', ('ult(is_used_once)', 'a', 'b'), ('ult', 'a', 'c')) => ('ult', 'a', ('umax', 'b', 'c')) */
   /* search610_0_0 -> 143 in the cache */
   /* search610_0_1 -> 144 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ult,
      -1, 0,
      { 143, 144 },
      0,
   } },
   /* search610_1_0 -> 143 in the cache */
   /* search610_1_1 -> 146 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ult,
      -1, 0,
      { 143, 146 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ior,
      0, 1,
      { 1850, 1851 },
      -1,
   } },

   /* replace610_0 -> 143 in the cache */
   /* replace610_1_0 -> 144 in the cache */
   /* replace610_1_1 -> 146 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_umax,
      0, 1,
      { 144, 146 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ult,
      -1, 1,
      { 143, 1853 },
      -1,
   } },

   /* ('ior', ('ult(is_used_once)', 'a', 'c'), ('ult', 'b', 'c')) => ('ult', ('umin', 'a', 'b'), 'c') */
   /* search611_0_0 -> 0 in the cache */
   /* search611_0_1 -> 786 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ult,
      -1, 0,
      { 0, 786 },
      0,
   } },
   /* search611_1_0 -> 1773 in the cache */
   /* search611_1_1 -> 786 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ult,
      -1, 0,
      { 1773, 786 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ior,
      0, 1,
      { 1855, 1856 },
      -1,
   } },

   /* replace611_0_0 -> 0 in the cache */
   /* replace611_0_1 -> 1773 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_umin,
      0, 1,
      { 0, 1773 },
      -1,
   } },
   /* replace611_1 -> 786 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ult,
      -1, 1,
      { 1858, 786 },
      -1,
   } },

   /* ('ior', ('uge(is_used_once)', 'a', 'b'), ('uge', 'a', 'c')) => ('uge', 'a', ('umin', 'b', 'c')) */
   /* search612_0_0 -> 143 in the cache */
   /* search612_0_1 -> 144 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_uge,
      -1, 0,
      { 143, 144 },
      0,
   } },
   /* search612_1_0 -> 143 in the cache */
   /* search612_1_1 -> 146 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_uge,
      -1, 0,
      { 143, 146 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ior,
      0, 1,
      { 1860, 1861 },
      -1,
   } },

   /* replace612_0 -> 143 in the cache */
   /* replace612_1_0 -> 144 in the cache */
   /* replace612_1_1 -> 146 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_umin,
      0, 1,
      { 144, 146 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_uge,
      -1, 1,
      { 143, 1863 },
      -1,
   } },

   /* ('ior', ('uge(is_used_once)', 'a', 'c'), ('uge', 'b', 'c')) => ('uge', ('umax', 'a', 'b'), 'c') */
   /* search613_0_0 -> 0 in the cache */
   /* search613_0_1 -> 786 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_uge,
      -1, 0,
      { 0, 786 },
      0,
   } },
   /* search613_1_0 -> 1773 in the cache */
   /* search613_1_1 -> 786 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_uge,
      -1, 0,
      { 1773, 786 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ior,
      0, 1,
      { 1865, 1866 },
      -1,
   } },

   /* replace613_0_0 -> 0 in the cache */
   /* replace613_0_1 -> 1773 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_umax,
      0, 1,
      { 0, 1773 },
      -1,
   } },
   /* replace613_1 -> 786 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_uge,
      -1, 1,
      { 1868, 786 },
      -1,
   } },

   /* ('iand', ('ilt(is_used_once)', 'a', 'b'), ('ilt', 'a', 'c')) => ('ilt', 'a', ('imin', 'b', 'c')) */
   /* search614_0_0 -> 143 in the cache */
   /* search614_0_1 -> 144 in the cache */
   /* search614_0 -> 1830 in the cache */
   /* search614_1_0 -> 143 in the cache */
   /* search614_1_1 -> 146 in the cache */
   /* search614_1 -> 1831 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_iand,
      0, 1,
      { 1830, 1831 },
      -1,
   } },

   /* replace614_0 -> 143 in the cache */
   /* replace614_1_0 -> 144 in the cache */
   /* replace614_1_1 -> 146 in the cache */
   /* replace614_1 -> 1843 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ilt,
      -1, 1,
      { 143, 1843 },
      -1,
   } },

   /* ('iand', ('ilt(is_used_once)', 'a', 'c'), ('ilt', 'b', 'c')) => ('ilt', ('imax', 'a', 'b'), 'c') */
   /* search615_0_0 -> 0 in the cache */
   /* search615_0_1 -> 786 in the cache */
   /* search615_0 -> 1835 in the cache */
   /* search615_1_0 -> 1773 in the cache */
   /* search615_1_1 -> 786 in the cache */
   /* search615_1 -> 1836 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_iand,
      0, 1,
      { 1835, 1836 },
      -1,
   } },

   /* replace615_0_0 -> 0 in the cache */
   /* replace615_0_1 -> 1773 in the cache */
   /* replace615_0 -> 1848 in the cache */
   /* replace615_1 -> 786 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ilt,
      -1, 1,
      { 1848, 786 },
      -1,
   } },

   /* ('iand', ('ige(is_used_once)', 'a', 'b'), ('ige', 'a', 'c')) => ('ige', 'a', ('imax', 'b', 'c')) */
   /* search616_0_0 -> 143 in the cache */
   /* search616_0_1 -> 144 in the cache */
   /* search616_0 -> 1840 in the cache */
   /* search616_1_0 -> 143 in the cache */
   /* search616_1_1 -> 146 in the cache */
   /* search616_1 -> 1841 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_iand,
      0, 1,
      { 1840, 1841 },
      -1,
   } },

   /* replace616_0 -> 143 in the cache */
   /* replace616_1_0 -> 144 in the cache */
   /* replace616_1_1 -> 146 in the cache */
   /* replace616_1 -> 1833 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ige,
      -1, 1,
      { 143, 1833 },
      -1,
   } },

   /* ('iand', ('ige(is_used_once)', 'a', 'c'), ('ige', 'b', 'c')) => ('ige', ('imin', 'a', 'b'), 'c') */
   /* search617_0_0 -> 0 in the cache */
   /* search617_0_1 -> 786 in the cache */
   /* search617_0 -> 1845 in the cache */
   /* search617_1_0 -> 1773 in the cache */
   /* search617_1_1 -> 786 in the cache */
   /* search617_1 -> 1846 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_iand,
      0, 1,
      { 1845, 1846 },
      -1,
   } },

   /* replace617_0_0 -> 0 in the cache */
   /* replace617_0_1 -> 1773 in the cache */
   /* replace617_0 -> 1838 in the cache */
   /* replace617_1 -> 786 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ige,
      -1, 1,
      { 1838, 786 },
      -1,
   } },

   /* ('iand', ('ult(is_used_once)', 'a', 'b'), ('ult', 'a', 'c')) => ('ult', 'a', ('umin', 'b', 'c')) */
   /* search618_0_0 -> 143 in the cache */
   /* search618_0_1 -> 144 in the cache */
   /* search618_0 -> 1850 in the cache */
   /* search618_1_0 -> 143 in the cache */
   /* search618_1_1 -> 146 in the cache */
   /* search618_1 -> 1851 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_iand,
      0, 1,
      { 1850, 1851 },
      -1,
   } },

   /* replace618_0 -> 143 in the cache */
   /* replace618_1_0 -> 144 in the cache */
   /* replace618_1_1 -> 146 in the cache */
   /* replace618_1 -> 1863 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ult,
      -1, 1,
      { 143, 1863 },
      -1,
   } },

   /* ('iand', ('ult(is_used_once)', 'a', 'c'), ('ult', 'b', 'c')) => ('ult', ('umax', 'a', 'b'), 'c') */
   /* search619_0_0 -> 0 in the cache */
   /* search619_0_1 -> 786 in the cache */
   /* search619_0 -> 1855 in the cache */
   /* search619_1_0 -> 1773 in the cache */
   /* search619_1_1 -> 786 in the cache */
   /* search619_1 -> 1856 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_iand,
      0, 1,
      { 1855, 1856 },
      -1,
   } },

   /* replace619_0_0 -> 0 in the cache */
   /* replace619_0_1 -> 1773 in the cache */
   /* replace619_0 -> 1868 in the cache */
   /* replace619_1 -> 786 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ult,
      -1, 1,
      { 1868, 786 },
      -1,
   } },

   /* ('iand', ('uge(is_used_once)', 'a', 'b'), ('uge', 'a', 'c')) => ('uge', 'a', ('umax', 'b', 'c')) */
   /* search620_0_0 -> 143 in the cache */
   /* search620_0_1 -> 144 in the cache */
   /* search620_0 -> 1860 in the cache */
   /* search620_1_0 -> 143 in the cache */
   /* search620_1_1 -> 146 in the cache */
   /* search620_1 -> 1861 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_iand,
      0, 1,
      { 1860, 1861 },
      -1,
   } },

   /* replace620_0 -> 143 in the cache */
   /* replace620_1_0 -> 144 in the cache */
   /* replace620_1_1 -> 146 in the cache */
   /* replace620_1 -> 1853 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_uge,
      -1, 1,
      { 143, 1853 },
      -1,
   } },

   /* ('iand', ('uge(is_used_once)', 'a', 'c'), ('uge', 'b', 'c')) => ('uge', ('umin', 'a', 'b'), 'c') */
   /* search621_0_0 -> 0 in the cache */
   /* search621_0_1 -> 786 in the cache */
   /* search621_0 -> 1865 in the cache */
   /* search621_1_0 -> 1773 in the cache */
   /* search621_1_1 -> 786 in the cache */
   /* search621_1 -> 1866 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_iand,
      0, 1,
      { 1865, 1866 },
      -1,
   } },

   /* replace621_0_0 -> 0 in the cache */
   /* replace621_0_1 -> 1773 in the cache */
   /* replace621_0 -> 1858 in the cache */
   /* replace621_1 -> 786 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_uge,
      -1, 1,
      { 1858, 786 },
      -1,
   } },

   /* ('ior', ('ior(is_used_once)', ('flt(is_used_once)', 'a', 'c'), 'd'), ('flt', 'b', 'c')) => ('ior', ('flt', ('!fmin', 'a', 'b'), 'c'), 'd') */
   /* search622_0_0_0 -> 0 in the cache */
   /* search622_0_0_1 -> 786 in the cache */
   /* search622_0_0 -> 1772 in the cache */
   { .variable = {
      { nir_search_value_variable, 1 },
      2, /* d */
      false,
      nir_type_invalid,
      -1,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ior,
      1, 1,
      { 1772, 1886 },
      0,
   } },
   { .variable = {
      { nir_search_value_variable, -2 },
      3, /* b */
      false,
      nir_type_invalid,
      -1,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   /* search622_1_1 -> 786 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_flt,
      -1, 0,
      { 1888, 786 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ior,
      0, 2,
      { 1887, 1889 },
      -1,
   } },

   /* replace622_0_0_0 -> 0 in the cache */
   /* replace622_0_0_1 -> 1888 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      true,
      false,
      false,
      false,
      false,
      nir_op_fmin,
      1, 1,
      { 0, 1888 },
      -1,
   } },
   /* replace622_0_1 -> 786 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_flt,
      -1, 1,
      { 1891, 786 },
      -1,
   } },
   /* replace622_1 -> 1886 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ior,
      0, 2,
      { 1892, 1886 },
      -1,
   } },

   /* ('ior', ('ior(is_used_once)', ('flt', 'a', 'c'), 'd'), ('flt(is_used_once)', 'b', 'c')) => ('ior', ('flt', ('!fmin', 'a', 'b'), 'c'), 'd') */
   /* search623_0_0_0 -> 0 in the cache */
   /* search623_0_0_1 -> 786 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_flt,
      -1, 0,
      { 0, 786 },
      -1,
   } },
   /* search623_0_1 -> 1886 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ior,
      1, 1,
      { 1894, 1886 },
      0,
   } },
   /* search623_1_0 -> 1888 in the cache */
   /* search623_1_1 -> 786 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_flt,
      -1, 0,
      { 1888, 786 },
      0,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ior,
      0, 2,
      { 1895, 1896 },
      -1,
   } },

   /* replace623_0_0_0 -> 0 in the cache */
   /* replace623_0_0_1 -> 1888 in the cache */
   /* replace623_0_0 -> 1891 in the cache */
   /* replace623_0_1 -> 786 in the cache */
   /* replace623_0 -> 1892 in the cache */
   /* replace623_1 -> 1886 in the cache */
   /* replace623 -> 1893 in the cache */

   /* ('ior', ('ior(is_used_once)', ('flt(is_used_once)', 'a', 'b'), 'd'), ('flt', 'a', 'c')) => ('ior', ('flt', 'a', ('!fmax', 'b', 'c')), 'd') */
   /* search624_0_0_0 -> 166 in the cache */
   /* search624_0_0_1 -> 167 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_flt,
      -1, 0,
      { 166, 167 },
      0,
   } },
   /* search624_0_1 -> 1886 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ior,
      1, 1,
      { 1898, 1886 },
      0,
   } },
   /* search624_1_0 -> 166 in the cache */
   { .variable = {
      { nir_search_value_variable, -4 },
      3, /* c */
      false,
      nir_type_invalid,
      -1,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_flt,
      -1, 0,
      { 166, 1900 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ior,
      0, 2,
      { 1899, 1901 },
      -1,
   } },

   /* replace624_0_0 -> 166 in the cache */
   /* replace624_0_1_0 -> 167 in the cache */
   /* replace624_0_1_1 -> 1900 in the cache */
   { .expression = {
      { nir_search_value_expression, -4 },
      false,
      true,
      false,
      false,
      false,
      false,
      nir_op_fmax,
      1, 1,
      { 167, 1900 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_flt,
      -1, 1,
      { 166, 1903 },
      -1,
   } },
   /* replace624_1 -> 1886 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ior,
      0, 2,
      { 1904, 1886 },
      -1,
   } },

   /* ('ior', ('ior(is_used_once)', ('flt', 'a', 'b'), 'd'), ('flt(is_used_once)', 'a', 'c')) => ('ior', ('flt', 'a', ('!fmax', 'b', 'c')), 'd') */
   /* search625_0_0_0 -> 166 in the cache */
   /* search625_0_0_1 -> 167 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_flt,
      -1, 0,
      { 166, 167 },
      -1,
   } },
   /* search625_0_1 -> 1886 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ior,
      1, 1,
      { 1906, 1886 },
      0,
   } },
   /* search625_1_0 -> 166 in the cache */
   /* search625_1_1 -> 1900 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_flt,
      -1, 0,
      { 166, 1900 },
      0,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ior,
      0, 2,
      { 1907, 1908 },
      -1,
   } },

   /* replace625_0_0 -> 166 in the cache */
   /* replace625_0_1_0 -> 167 in the cache */
   /* replace625_0_1_1 -> 1900 in the cache */
   /* replace625_0_1 -> 1903 in the cache */
   /* replace625_0 -> 1904 in the cache */
   /* replace625_1 -> 1886 in the cache */
   /* replace625 -> 1905 in the cache */

   /* ('ior', ('flt', 'a(is_a_number)', 'b(is_a_number)'), ('flt', 'b', 'a')) => ('fneu', 'a', 'b') */
   /* search626_0_0 -> 1194 in the cache */
   /* search626_0_1 -> 1195 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_flt,
      -1, 0,
      { 1194, 1195 },
      -1,
   } },
   /* search626_1_0 -> 1 in the cache */
   /* search626_1_1 -> 0 in the cache */
   /* search626_1 -> 1228 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ior,
      0, 1,
      { 1910, 1228 },
      -1,
   } },

   /* replace626_0 -> 0 in the cache */
   /* replace626_1 -> 1 in the cache */
   /* replace626 -> 1202 in the cache */

   /* ('umin', ('iand', 'a', '#b(is_pos_power_of_two)'), ('iand', 'c', 'b')) => ('iand', ('iand', 'a', 'b'), ('iand', 'c', 'b')) */
   /* search627_0_0 -> 0 in the cache */
   /* search627_0_1 -> 15 in the cache */
   /* search627_0 -> 216 in the cache */
   /* search627_1_0 -> 157 in the cache */
   /* search627_1_1 -> 1 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_iand,
      2, 1,
      { 157, 1 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_umin,
      0, 3,
      { 216, 1912 },
      -1,
   } },

   /* replace627_0_0 -> 0 in the cache */
   /* replace627_0_1 -> 1 in the cache */
   /* replace627_0 -> 218 in the cache */
   /* replace627_1_0 -> 157 in the cache */
   /* replace627_1_1 -> 1 in the cache */
   /* replace627_1 -> 1912 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_iand,
      0, 3,
      { 218, 1912 },
      -1,
   } },

   /* ('ior', ('flt(is_used_once)', 0.0, 'a@16'), ('flt', 'b@16', 0.0)) => ('flt', 0.0, ('fmax', 'a', ('fneg', 'b'))) */
   /* search628_0_0 -> 791 in the cache */
   /* search628_0_1 -> 24 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_flt,
      -1, 0,
      { 791, 24 },
      0,
   } },
   /* search628_1_0 -> 566 in the cache */
   /* search628_1_1 -> 791 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_flt,
      -1, 0,
      { 566, 791 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ior,
      0, 1,
      { 1915, 1916 },
      -1,
   } },

   /* replace628_0 -> 791 in the cache */
   /* replace628_1_0 -> 24 in the cache */
   /* replace628_1_1_0 -> 566 in the cache */
   /* replace628_1_1 -> 637 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fmax,
      0, 1,
      { 24, 637 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_flt,
      -1, 1,
      { 791, 1918 },
      -1,
   } },

   /* ('ior', ('flt', 0.0, 'a@16'), ('flt(is_used_once)', 'b@16', 0.0)) => ('flt', 0.0, ('fmax', 'a', ('fneg', 'b'))) */
   /* search629_0_0 -> 791 in the cache */
   /* search629_0_1 -> 24 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_flt,
      -1, 0,
      { 791, 24 },
      -1,
   } },
   /* search629_1_0 -> 566 in the cache */
   /* search629_1_1 -> 791 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_flt,
      -1, 0,
      { 566, 791 },
      0,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ior,
      0, 1,
      { 1920, 1921 },
      -1,
   } },

   /* replace629_0 -> 791 in the cache */
   /* replace629_1_0 -> 24 in the cache */
   /* replace629_1_1_0 -> 566 in the cache */
   /* replace629_1_1 -> 637 in the cache */
   /* replace629_1 -> 1918 in the cache */
   /* replace629 -> 1919 in the cache */

   /* ('ior', ('fge(is_used_once)', 0.0, 'a@16'), ('fge', 'b@16', 0.0)) => ('fge', 0.0, ('fmin', 'a', ('fneg', 'b'))) */
   /* search630_0_0 -> 791 in the cache */
   /* search630_0_1 -> 24 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fge,
      -1, 0,
      { 791, 24 },
      0,
   } },
   /* search630_1_0 -> 566 in the cache */
   /* search630_1_1 -> 791 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fge,
      -1, 0,
      { 566, 791 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ior,
      0, 1,
      { 1923, 1924 },
      -1,
   } },

   /* replace630_0 -> 791 in the cache */
   /* replace630_1_0 -> 24 in the cache */
   /* replace630_1_1_0 -> 566 in the cache */
   /* replace630_1_1 -> 637 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fmin,
      0, 1,
      { 24, 637 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fge,
      -1, 1,
      { 791, 1926 },
      -1,
   } },

   /* ('ior', ('fge', 0.0, 'a@16'), ('fge(is_used_once)', 'b@16', 0.0)) => ('fge', 0.0, ('fmin', 'a', ('fneg', 'b'))) */
   /* search631_0_0 -> 791 in the cache */
   /* search631_0_1 -> 24 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fge,
      -1, 0,
      { 791, 24 },
      -1,
   } },
   /* search631_1_0 -> 566 in the cache */
   /* search631_1_1 -> 791 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fge,
      -1, 0,
      { 566, 791 },
      0,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ior,
      0, 1,
      { 1928, 1929 },
      -1,
   } },

   /* replace631_0 -> 791 in the cache */
   /* replace631_1_0 -> 24 in the cache */
   /* replace631_1_1_0 -> 566 in the cache */
   /* replace631_1_1 -> 637 in the cache */
   /* replace631_1 -> 1926 in the cache */
   /* replace631 -> 1927 in the cache */

   /* ('~iand', ('flt(is_used_once)', 0.0, 'a@16'), ('flt', 'b@16', 0.0)) => ('flt', 0.0, ('fmin', 'a', ('fneg', 'b'))) */
   /* search632_0_0 -> 791 in the cache */
   /* search632_0_1 -> 24 in the cache */
   /* search632_0 -> 1915 in the cache */
   /* search632_1_0 -> 566 in the cache */
   /* search632_1_1 -> 791 in the cache */
   /* search632_1 -> 1916 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      true,
      false,
      false,
      false,
      false,
      false,
      nir_op_iand,
      0, 1,
      { 1915, 1916 },
      -1,
   } },

   /* replace632_0 -> 791 in the cache */
   /* replace632_1_0 -> 24 in the cache */
   /* replace632_1_1_0 -> 566 in the cache */
   /* replace632_1_1 -> 637 in the cache */
   /* replace632_1 -> 1926 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_flt,
      -1, 1,
      { 791, 1926 },
      -1,
   } },

   /* ('~iand', ('flt', 0.0, 'a@16'), ('flt(is_used_once)', 'b@16', 0.0)) => ('flt', 0.0, ('fmin', 'a', ('fneg', 'b'))) */
   /* search633_0_0 -> 791 in the cache */
   /* search633_0_1 -> 24 in the cache */
   /* search633_0 -> 1920 in the cache */
   /* search633_1_0 -> 566 in the cache */
   /* search633_1_1 -> 791 in the cache */
   /* search633_1 -> 1921 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      true,
      false,
      false,
      false,
      false,
      false,
      nir_op_iand,
      0, 1,
      { 1920, 1921 },
      -1,
   } },

   /* replace633_0 -> 791 in the cache */
   /* replace633_1_0 -> 24 in the cache */
   /* replace633_1_1_0 -> 566 in the cache */
   /* replace633_1_1 -> 637 in the cache */
   /* replace633_1 -> 1926 in the cache */
   /* replace633 -> 1932 in the cache */

   /* ('~iand', ('fge(is_used_once)', 0.0, 'a@16'), ('fge', 'b@16', 0.0)) => ('fge', 0.0, ('fmax', 'a', ('fneg', 'b'))) */
   /* search634_0_0 -> 791 in the cache */
   /* search634_0_1 -> 24 in the cache */
   /* search634_0 -> 1923 in the cache */
   /* search634_1_0 -> 566 in the cache */
   /* search634_1_1 -> 791 in the cache */
   /* search634_1 -> 1924 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      true,
      false,
      false,
      false,
      false,
      false,
      nir_op_iand,
      0, 1,
      { 1923, 1924 },
      -1,
   } },

   /* replace634_0 -> 791 in the cache */
   /* replace634_1_0 -> 24 in the cache */
   /* replace634_1_1_0 -> 566 in the cache */
   /* replace634_1_1 -> 637 in the cache */
   /* replace634_1 -> 1918 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fge,
      -1, 1,
      { 791, 1918 },
      -1,
   } },

   /* ('~iand', ('fge', 0.0, 'a@16'), ('fge(is_used_once)', 'b@16', 0.0)) => ('fge', 0.0, ('fmax', 'a', ('fneg', 'b'))) */
   /* search635_0_0 -> 791 in the cache */
   /* search635_0_1 -> 24 in the cache */
   /* search635_0 -> 1928 in the cache */
   /* search635_1_0 -> 566 in the cache */
   /* search635_1_1 -> 791 in the cache */
   /* search635_1 -> 1929 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      true,
      false,
      false,
      false,
      false,
      false,
      nir_op_iand,
      0, 1,
      { 1928, 1929 },
      -1,
   } },

   /* replace635_0 -> 791 in the cache */
   /* replace635_1_0 -> 24 in the cache */
   /* replace635_1_1_0 -> 566 in the cache */
   /* replace635_1_1 -> 637 in the cache */
   /* replace635_1 -> 1918 in the cache */
   /* replace635 -> 1935 in the cache */

   /* ('ior', ('feq(is_used_once)', 'a@16', 0.0), ('feq', 'b@16', 0.0)) => ('feq', ('fmin', ('fabs', 'a'), ('fabs', 'b')), 0.0) */
   /* search636_0_0 -> 24 in the cache */
   /* search636_0_1 -> 791 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_feq,
      1, 1,
      { 24, 791 },
      0,
   } },
   /* search636_1_0 -> 566 in the cache */
   /* search636_1_1 -> 791 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_feq,
      2, 1,
      { 566, 791 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ior,
      0, 3,
      { 1937, 1938 },
      -1,
   } },

   /* replace636_0_0_0 -> 24 in the cache */
   /* replace636_0_0 -> 793 in the cache */
   /* replace636_0_1_0 -> 566 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fabs,
      -1, 0,
      { 566 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fmin,
      1, 1,
      { 793, 1940 },
      -1,
   } },
   /* replace636_1 -> 791 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_feq,
      0, 2,
      { 1941, 791 },
      -1,
   } },

   /* ('ior', ('fneu(is_used_once)', 'a@16', 0.0), ('fneu', 'b@16', 0.0)) => ('fneu', ('fadd', ('fabs', 'a'), ('fabs', 'b')), 0.0) */
   /* search637_0_0 -> 24 in the cache */
   /* search637_0_1 -> 791 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fneu,
      1, 1,
      { 24, 791 },
      0,
   } },
   /* search637_1_0 -> 566 in the cache */
   /* search637_1_1 -> 791 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fneu,
      2, 1,
      { 566, 791 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ior,
      0, 3,
      { 1943, 1944 },
      -1,
   } },

   /* replace637_0_0_0 -> 24 in the cache */
   /* replace637_0_0 -> 793 in the cache */
   /* replace637_0_1_0 -> 566 in the cache */
   /* replace637_0_1 -> 1940 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fadd,
      1, 1,
      { 793, 1940 },
      -1,
   } },
   /* replace637_1 -> 791 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fneu,
      0, 2,
      { 1946, 791 },
      -1,
   } },

   /* ('iand', ('feq(is_used_once)', 'a@16', 0.0), ('feq', 'b@16', 0.0)) => ('feq', ('fadd', ('fabs', 'a'), ('fabs', 'b')), 0.0) */
   /* search638_0_0 -> 24 in the cache */
   /* search638_0_1 -> 791 in the cache */
   /* search638_0 -> 1937 in the cache */
   /* search638_1_0 -> 566 in the cache */
   /* search638_1_1 -> 791 in the cache */
   /* search638_1 -> 1938 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_iand,
      0, 3,
      { 1937, 1938 },
      -1,
   } },

   /* replace638_0_0_0 -> 24 in the cache */
   /* replace638_0_0 -> 793 in the cache */
   /* replace638_0_1_0 -> 566 in the cache */
   /* replace638_0_1 -> 1940 in the cache */
   /* replace638_0 -> 1946 in the cache */
   /* replace638_1 -> 791 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_feq,
      0, 2,
      { 1946, 791 },
      -1,
   } },

   /* ('iand', ('fneu(is_used_once)', 'a@16', 0.0), ('fneu', 'b@16', 0.0)) => ('fneu', ('fmin', ('fabs', 'a'), ('fabs', 'b')), 0.0) */
   /* search639_0_0 -> 24 in the cache */
   /* search639_0_1 -> 791 in the cache */
   /* search639_0 -> 1943 in the cache */
   /* search639_1_0 -> 566 in the cache */
   /* search639_1_1 -> 791 in the cache */
   /* search639_1 -> 1944 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_iand,
      0, 3,
      { 1943, 1944 },
      -1,
   } },

   /* replace639_0_0_0 -> 24 in the cache */
   /* replace639_0_0 -> 793 in the cache */
   /* replace639_0_1_0 -> 566 in the cache */
   /* replace639_0_1 -> 1940 in the cache */
   /* replace639_0 -> 1941 in the cache */
   /* replace639_1 -> 791 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fneu,
      0, 2,
      { 1941, 791 },
      -1,
   } },

   /* ('bcsel@16', ('feq', 'a', 0.0), 1.0, ('i2f16', ('iadd', ('b2i16', ('flt', 0.0, 'a@16')), ('ineg', ('b2i16', ('flt', 'a@16', 0.0)))))) => ('i2f16', ('iadd', ('b2i32', ('!fge', 'a', 0.0)), ('ineg', ('b2i32', ('!flt', 'a', 0.0))))) */
   /* search640_0_0 -> 24 in the cache */
   /* search640_0_1 -> 791 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_feq,
      0, 1,
      { 24, 791 },
      -1,
   } },
   /* search640_1 -> 584 in the cache */
   /* search640_2_0_0_0_0 -> 791 in the cache */
   /* search640_2_0_0_0_1 -> 24 in the cache */
   /* search640_2_0_0_0 -> 1920 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_b2i16,
      -1, 0,
      { 1920 },
      -1,
   } },
   /* search640_2_0_1_0_0_0 -> 24 in the cache */
   /* search640_2_0_1_0_0_1 -> 791 in the cache */
   /* search640_2_0_1_0_0 -> 792 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_b2i16,
      -1, 0,
      { 792 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ineg,
      -1, 0,
      { 1954 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_iadd,
      1, 1,
      { 1953, 1955 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_i2f16,
      -1, 1,
      { 1956 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_bcsel,
      -1, 2,
      { 1952, 584, 1957 },
      -1,
   } },

   /* replace640_0_0_0_0 -> 24 in the cache */
   /* replace640_0_0_0_1 -> 791 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      true,
      false,
      false,
      false,
      false,
      nir_op_fge,
      -1, 0,
      { 24, 791 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_b2i32,
      -1, 0,
      { 1959 },
      -1,
   } },
   /* replace640_0_1_0_0_0 -> 24 in the cache */
   /* replace640_0_1_0_0_1 -> 791 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      true,
      false,
      false,
      false,
      false,
      nir_op_flt,
      -1, 0,
      { 24, 791 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_b2i32,
      -1, 0,
      { 1961 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ineg,
      -1, 0,
      { 1962 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_iadd,
      0, 1,
      { 1960, 1963 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_i2f16,
      -1, 1,
      { 1964 },
      -1,
   } },

   /* ('bcsel', 'a', ('b2f(is_used_once)', 'b@16'), ('b2f', 'c@16')) => ('b2f', ('bcsel', 'a', 'b', 'c')) */
   /* search641_0 -> 862 in the cache */
   /* search641_1_0 -> 566 in the cache */
   { .expression = {
      { nir_search_value_expression, 0 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_search_op_b2f,
      -1, 0,
      { 566 },
      0,
   } },
   /* search641_2_0 -> 572 in the cache */
   { .expression = {
      { nir_search_value_expression, 0 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_search_op_b2f,
      -1, 0,
      { 572 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 0 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_bcsel,
      -1, 0,
      { 862, 1966, 1967 },
      -1,
   } },

   /* replace641_0_0 -> 862 in the cache */
   /* replace641_0_1 -> 566 in the cache */
   /* replace641_0_2 -> 572 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_bcsel,
      -1, 0,
      { 862, 566, 572 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 0 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_search_op_b2f,
      -1, 0,
      { 1969 },
      -1,
   } },

   /* ('~i2f16', ('f2i', 'a@16')) => ('ftrunc', 'a') */
   /* search642_0_0 -> 24 in the cache */
   { .expression = {
      { nir_search_value_expression, 0 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_search_op_f2i,
      -1, 0,
      { 24 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 16 },
      true,
      false,
      false,
      false,
      false,
      false,
      nir_op_i2f16,
      -1, 0,
      { 1971 },
      -1,
   } },

   /* replace642_0 -> 24 in the cache */
   /* replace642 -> 790 in the cache */

   /* ('~f2i16', ('i2f', 'a@16')) => a */
   /* search643_0_0 -> 24 in the cache */
   { .expression = {
      { nir_search_value_expression, 0 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_search_op_i2f,
      -1, 0,
      { 24 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 16 },
      true,
      false,
      false,
      false,
      false,
      false,
      nir_op_f2i16,
      -1, 0,
      { 1973 },
      -1,
   } },

   /* replace643 -> 24 in the cache */

   /* ('~f2i16', ('u2f', 'a@16')) => a */
   /* search644_0_0 -> 24 in the cache */
   { .expression = {
      { nir_search_value_expression, 0 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_search_op_u2f,
      -1, 0,
      { 24 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 16 },
      true,
      false,
      false,
      false,
      false,
      false,
      nir_op_f2i16,
      -1, 0,
      { 1975 },
      -1,
   } },

   /* replace644 -> 24 in the cache */

   /* ('~f2u16', ('i2f', 'a@16')) => a */
   /* search645_0_0 -> 24 in the cache */
   /* search645_0 -> 1973 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      true,
      false,
      false,
      false,
      false,
      false,
      nir_op_f2u16,
      -1, 0,
      { 1973 },
      -1,
   } },

   /* replace645 -> 24 in the cache */

   /* ('~f2u16', ('u2f', 'a@16')) => a */
   /* search646_0_0 -> 24 in the cache */
   /* search646_0 -> 1975 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      true,
      false,
      false,
      false,
      false,
      false,
      nir_op_f2u16,
      -1, 0,
      { 1975 },
      -1,
   } },

   /* replace646 -> 24 in the cache */

   /* ('fadd', ('b2f16', ('flt', 0.0, 'a@16')), ('fneg', ('b2f16', ('flt', 'a@16', 0.0)))) => ('fsign', 'a') */
   /* search647_0_0_0 -> 791 in the cache */
   /* search647_0_0_1 -> 24 in the cache */
   /* search647_0_0 -> 1920 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_b2f16,
      -1, 0,
      { 1920 },
      -1,
   } },
   /* search647_1_0_0_0 -> 24 in the cache */
   /* search647_1_0_0_1 -> 791 in the cache */
   /* search647_1_0_0 -> 792 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_b2f16,
      -1, 0,
      { 792 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fneg,
      -1, 0,
      { 1980 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fadd,
      0, 1,
      { 1979, 1981 },
      -1,
   } },

   /* replace647_0 -> 24 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fsign,
      -1, 0,
      { 24 },
      -1,
   } },

   /* ('iadd', ('b2i16', ('flt', 0, 'a@16')), ('ineg', ('b2i16', ('flt', 'a@16', 0)))) => ('f2i16', ('fsign', 'a')) */
   /* search648_0_0_0 -> 961 in the cache */
   /* search648_0_0_1 -> 24 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_flt,
      -1, 0,
      { 961, 24 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_b2i16,
      -1, 0,
      { 1984 },
      -1,
   } },
   /* search648_1_0_0_0 -> 24 in the cache */
   /* search648_1_0_0_1 -> 961 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_flt,
      -1, 0,
      { 24, 961 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_b2i16,
      -1, 0,
      { 1986 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ineg,
      -1, 0,
      { 1987 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_iadd,
      0, 1,
      { 1985, 1988 },
      -1,
   } },

   /* replace648_0_0 -> 24 in the cache */
   /* replace648_0 -> 1983 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_f2i16,
      -1, 0,
      { 1983 },
      -1,
   } },

   /* ('~f2f16', ('f2f', 'a')) => ('f2f16', 'a') */
   /* search649_0_0 -> 9 in the cache */
   { .expression = {
      { nir_search_value_expression, 0 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_search_op_f2f,
      -1, 0,
      { 9 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 16 },
      true,
      false,
      false,
      false,
      false,
      false,
      nir_op_f2f16,
      -1, 0,
      { 1991 },
      -1,
   } },

   /* replace649_0 -> 9 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_f2f16,
      -1, 0,
      { 9 },
      -1,
   } },

   /* ('~f2f16', ('u2f', 'a')) => ('u2f16', 'a') */
   /* search650_0_0 -> 9 in the cache */
   /* search650_0 -> 123 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      true,
      false,
      false,
      false,
      false,
      false,
      nir_op_f2f16,
      -1, 0,
      { 123 },
      -1,
   } },

   /* replace650_0 -> 9 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_u2f16,
      -1, 0,
      { 9 },
      -1,
   } },

   /* ('~f2f16', ('i2f', 'a')) => ('i2f16', 'a') */
   /* search651_0_0 -> 9 in the cache */
   /* search651_0 -> 1424 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      true,
      false,
      false,
      false,
      false,
      false,
      nir_op_f2f16,
      -1, 0,
      { 1424 },
      -1,
   } },

   /* replace651_0 -> 9 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_i2f16,
      -1, 0,
      { 9 },
      -1,
   } },

   /* ('~f2u16', ('f2f', 'a')) => ('f2u16', 'a') */
   /* search652_0_0 -> 9 in the cache */
   /* search652_0 -> 1991 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      true,
      false,
      false,
      false,
      false,
      false,
      nir_op_f2u16,
      -1, 0,
      { 1991 },
      -1,
   } },

   /* replace652_0 -> 9 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_f2u16,
      -1, 0,
      { 9 },
      -1,
   } },

   /* ('~f2i16', ('f2f', 'a')) => ('f2i16', 'a') */
   /* search653_0_0 -> 9 in the cache */
   /* search653_0 -> 1991 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      true,
      false,
      false,
      false,
      false,
      false,
      nir_op_f2i16,
      -1, 0,
      { 1991 },
      -1,
   } },

   /* replace653_0 -> 9 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_f2i16,
      -1, 0,
      { 9 },
      -1,
   } },

   /* ('i2f16', ('f2i', ('fsign', 'a@16'))) => ('fsign', 'a') */
   /* search654_0_0_0 -> 24 in the cache */
   /* search654_0_0 -> 1983 in the cache */
   { .expression = {
      { nir_search_value_expression, 0 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_search_op_f2i,
      -1, 0,
      { 1983 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_i2f16,
      -1, 0,
      { 2002 },
      -1,
   } },

   /* replace654_0 -> 24 in the cache */
   /* replace654 -> 1983 in the cache */

   /* ('~f2f16', ('f2f32', 'a@16')) => a */
   /* search655_0_0 -> 24 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_f2f32,
      -1, 0,
      { 24 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 16 },
      true,
      false,
      false,
      false,
      false,
      false,
      nir_op_f2f16,
      -1, 0,
      { 2004 },
      -1,
   } },

   /* replace655 -> 24 in the cache */

   /* ('f2u32', ('f2f32', 'a@16')) => ('f2u32', 'a') */
   /* search656_0_0 -> 24 in the cache */
   /* search656_0 -> 2004 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_f2u32,
      -1, 0,
      { 2004 },
      -1,
   } },

   /* replace656_0 -> 24 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_f2u32,
      -1, 0,
      { 24 },
      -1,
   } },

   /* ('f2i32', ('f2f32', 'a@16')) => ('f2i32', 'a') */
   /* search657_0_0 -> 24 in the cache */
   /* search657_0 -> 2004 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_f2i32,
      -1, 0,
      { 2004 },
      -1,
   } },

   /* replace657_0 -> 24 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_f2i32,
      -1, 0,
      { 24 },
      -1,
   } },

   /* ('f2f16', ('u2f32', 'a')) => ('u2f16', 'a') */
   /* search658_0_0 -> 9 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_u2f32,
      -1, 0,
      { 9 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_f2f16,
      -1, 0,
      { 2010 },
      -1,
   } },

   /* replace658_0 -> 9 in the cache */
   /* replace658 -> 1995 in the cache */

   /* ('f2f16', ('i2f32', 'a')) => ('i2f16', 'a') */
   /* search659_0_0 -> 9 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_i2f32,
      -1, 0,
      { 9 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_f2f16,
      -1, 0,
      { 2012 },
      -1,
   } },

   /* replace659_0 -> 9 in the cache */
   /* replace659 -> 1997 in the cache */

   /* ('~f2f16', ('f2f64', 'a@16')) => a */
   /* search660_0_0 -> 24 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_f2f64,
      -1, 0,
      { 24 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 16 },
      true,
      false,
      false,
      false,
      false,
      false,
      nir_op_f2f16,
      -1, 0,
      { 2014 },
      -1,
   } },

   /* replace660 -> 24 in the cache */

   /* ('f2u64', ('f2f64', 'a@16')) => ('f2u64', 'a') */
   /* search661_0_0 -> 24 in the cache */
   /* search661_0 -> 2014 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_f2u64,
      -1, 0,
      { 2014 },
      -1,
   } },

   /* replace661_0 -> 24 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_f2u64,
      -1, 0,
      { 24 },
      -1,
   } },

   /* ('f2i64', ('f2f64', 'a@16')) => ('f2i64', 'a') */
   /* search662_0_0 -> 24 in the cache */
   /* search662_0 -> 2014 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_f2i64,
      -1, 0,
      { 2014 },
      -1,
   } },

   /* replace662_0 -> 24 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_f2i64,
      -1, 0,
      { 24 },
      -1,
   } },

   /* ('f2f16', ('u2f64', 'a')) => ('u2f16', 'a') */
   /* search663_0_0 -> 9 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_u2f64,
      -1, 0,
      { 9 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_f2f16,
      -1, 0,
      { 2020 },
      -1,
   } },

   /* replace663_0 -> 9 in the cache */
   /* replace663 -> 1995 in the cache */

   /* ('f2f16', ('i2f64', 'a')) => ('i2f16', 'a') */
   /* search664_0_0 -> 9 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_i2f64,
      -1, 0,
      { 9 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_f2f16,
      -1, 0,
      { 2022 },
      -1,
   } },

   /* replace664_0 -> 9 in the cache */
   /* replace664 -> 1997 in the cache */

   /* ('ior', ('flt(is_used_once)', 0.0, 'a@32'), ('flt', 'b@32', 0.0)) => ('flt', 0.0, ('fmax', 'a', ('fneg', 'b'))) */
   /* search665_0_0 -> 244 in the cache */
   /* search665_0_1 -> 29 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_flt,
      -1, 0,
      { 244, 29 },
      0,
   } },
   /* search665_1_0 -> 48 in the cache */
   /* search665_1_1 -> 244 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_flt,
      -1, 0,
      { 48, 244 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ior,
      0, 1,
      { 2024, 2025 },
      -1,
   } },

   /* replace665_0 -> 244 in the cache */
   /* replace665_1_0 -> 29 in the cache */
   /* replace665_1_1_0 -> 48 in the cache */
   /* replace665_1_1 -> 702 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fmax,
      0, 1,
      { 29, 702 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_flt,
      -1, 1,
      { 244, 2027 },
      -1,
   } },

   /* ('ior', ('flt', 0.0, 'a@32'), ('flt(is_used_once)', 'b@32', 0.0)) => ('flt', 0.0, ('fmax', 'a', ('fneg', 'b'))) */
   /* search666_0_0 -> 244 in the cache */
   /* search666_0_1 -> 29 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_flt,
      -1, 0,
      { 244, 29 },
      -1,
   } },
   /* search666_1_0 -> 48 in the cache */
   /* search666_1_1 -> 244 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_flt,
      -1, 0,
      { 48, 244 },
      0,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ior,
      0, 1,
      { 2029, 2030 },
      -1,
   } },

   /* replace666_0 -> 244 in the cache */
   /* replace666_1_0 -> 29 in the cache */
   /* replace666_1_1_0 -> 48 in the cache */
   /* replace666_1_1 -> 702 in the cache */
   /* replace666_1 -> 2027 in the cache */
   /* replace666 -> 2028 in the cache */

   /* ('ior', ('fge(is_used_once)', 0.0, 'a@32'), ('fge', 'b@32', 0.0)) => ('fge', 0.0, ('fmin', 'a', ('fneg', 'b'))) */
   /* search667_0_0 -> 244 in the cache */
   /* search667_0_1 -> 29 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fge,
      -1, 0,
      { 244, 29 },
      0,
   } },
   /* search667_1_0 -> 48 in the cache */
   /* search667_1_1 -> 244 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fge,
      -1, 0,
      { 48, 244 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ior,
      0, 1,
      { 2032, 2033 },
      -1,
   } },

   /* replace667_0 -> 244 in the cache */
   /* replace667_1_0 -> 29 in the cache */
   /* replace667_1_1_0 -> 48 in the cache */
   /* replace667_1_1 -> 702 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fmin,
      0, 1,
      { 29, 702 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fge,
      -1, 1,
      { 244, 2035 },
      -1,
   } },

   /* ('ior', ('fge', 0.0, 'a@32'), ('fge(is_used_once)', 'b@32', 0.0)) => ('fge', 0.0, ('fmin', 'a', ('fneg', 'b'))) */
   /* search668_0_0 -> 244 in the cache */
   /* search668_0_1 -> 29 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fge,
      -1, 0,
      { 244, 29 },
      -1,
   } },
   /* search668_1_0 -> 48 in the cache */
   /* search668_1_1 -> 244 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fge,
      -1, 0,
      { 48, 244 },
      0,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ior,
      0, 1,
      { 2037, 2038 },
      -1,
   } },

   /* replace668_0 -> 244 in the cache */
   /* replace668_1_0 -> 29 in the cache */
   /* replace668_1_1_0 -> 48 in the cache */
   /* replace668_1_1 -> 702 in the cache */
   /* replace668_1 -> 2035 in the cache */
   /* replace668 -> 2036 in the cache */

   /* ('~iand', ('flt(is_used_once)', 0.0, 'a@32'), ('flt', 'b@32', 0.0)) => ('flt', 0.0, ('fmin', 'a', ('fneg', 'b'))) */
   /* search669_0_0 -> 244 in the cache */
   /* search669_0_1 -> 29 in the cache */
   /* search669_0 -> 2024 in the cache */
   /* search669_1_0 -> 48 in the cache */
   /* search669_1_1 -> 244 in the cache */
   /* search669_1 -> 2025 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      true,
      false,
      false,
      false,
      false,
      false,
      nir_op_iand,
      0, 1,
      { 2024, 2025 },
      -1,
   } },

   /* replace669_0 -> 244 in the cache */
   /* replace669_1_0 -> 29 in the cache */
   /* replace669_1_1_0 -> 48 in the cache */
   /* replace669_1_1 -> 702 in the cache */
   /* replace669_1 -> 2035 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_flt,
      -1, 1,
      { 244, 2035 },
      -1,
   } },

   /* ('~iand', ('flt', 0.0, 'a@32'), ('flt(is_used_once)', 'b@32', 0.0)) => ('flt', 0.0, ('fmin', 'a', ('fneg', 'b'))) */
   /* search670_0_0 -> 244 in the cache */
   /* search670_0_1 -> 29 in the cache */
   /* search670_0 -> 2029 in the cache */
   /* search670_1_0 -> 48 in the cache */
   /* search670_1_1 -> 244 in the cache */
   /* search670_1 -> 2030 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      true,
      false,
      false,
      false,
      false,
      false,
      nir_op_iand,
      0, 1,
      { 2029, 2030 },
      -1,
   } },

   /* replace670_0 -> 244 in the cache */
   /* replace670_1_0 -> 29 in the cache */
   /* replace670_1_1_0 -> 48 in the cache */
   /* replace670_1_1 -> 702 in the cache */
   /* replace670_1 -> 2035 in the cache */
   /* replace670 -> 2041 in the cache */

   /* ('~iand', ('fge(is_used_once)', 0.0, 'a@32'), ('fge', 'b@32', 0.0)) => ('fge', 0.0, ('fmax', 'a', ('fneg', 'b'))) */
   /* search671_0_0 -> 244 in the cache */
   /* search671_0_1 -> 29 in the cache */
   /* search671_0 -> 2032 in the cache */
   /* search671_1_0 -> 48 in the cache */
   /* search671_1_1 -> 244 in the cache */
   /* search671_1 -> 2033 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      true,
      false,
      false,
      false,
      false,
      false,
      nir_op_iand,
      0, 1,
      { 2032, 2033 },
      -1,
   } },

   /* replace671_0 -> 244 in the cache */
   /* replace671_1_0 -> 29 in the cache */
   /* replace671_1_1_0 -> 48 in the cache */
   /* replace671_1_1 -> 702 in the cache */
   /* replace671_1 -> 2027 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fge,
      -1, 1,
      { 244, 2027 },
      -1,
   } },

   /* ('~iand', ('fge', 0.0, 'a@32'), ('fge(is_used_once)', 'b@32', 0.0)) => ('fge', 0.0, ('fmax', 'a', ('fneg', 'b'))) */
   /* search672_0_0 -> 244 in the cache */
   /* search672_0_1 -> 29 in the cache */
   /* search672_0 -> 2037 in the cache */
   /* search672_1_0 -> 48 in the cache */
   /* search672_1_1 -> 244 in the cache */
   /* search672_1 -> 2038 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      true,
      false,
      false,
      false,
      false,
      false,
      nir_op_iand,
      0, 1,
      { 2037, 2038 },
      -1,
   } },

   /* replace672_0 -> 244 in the cache */
   /* replace672_1_0 -> 29 in the cache */
   /* replace672_1_1_0 -> 48 in the cache */
   /* replace672_1_1 -> 702 in the cache */
   /* replace672_1 -> 2027 in the cache */
   /* replace672 -> 2044 in the cache */

   /* ('ior', ('feq(is_used_once)', 'a@32', 0.0), ('feq', 'b@32', 0.0)) => ('feq', ('fmin', ('fabs', 'a'), ('fabs', 'b')), 0.0) */
   /* search673_0_0 -> 29 in the cache */
   /* search673_0_1 -> 244 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_feq,
      1, 1,
      { 29, 244 },
      0,
   } },
   /* search673_1_0 -> 48 in the cache */
   /* search673_1_1 -> 244 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_feq,
      2, 1,
      { 48, 244 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ior,
      0, 3,
      { 2046, 2047 },
      -1,
   } },

   /* replace673_0_0_0 -> 29 in the cache */
   /* replace673_0_0 -> 426 in the cache */
   /* replace673_0_1_0 -> 48 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fabs,
      -1, 0,
      { 48 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fmin,
      1, 1,
      { 426, 2049 },
      -1,
   } },
   /* replace673_1 -> 244 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_feq,
      0, 2,
      { 2050, 244 },
      -1,
   } },

   /* ('ior', ('fneu(is_used_once)', 'a@32', 0.0), ('fneu', 'b@32', 0.0)) => ('fneu', ('fadd', ('fabs', 'a'), ('fabs', 'b')), 0.0) */
   /* search674_0_0 -> 29 in the cache */
   /* search674_0_1 -> 244 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fneu,
      1, 1,
      { 29, 244 },
      0,
   } },
   /* search674_1_0 -> 48 in the cache */
   /* search674_1_1 -> 244 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fneu,
      2, 1,
      { 48, 244 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ior,
      0, 3,
      { 2052, 2053 },
      -1,
   } },

   /* replace674_0_0_0 -> 29 in the cache */
   /* replace674_0_0 -> 426 in the cache */
   /* replace674_0_1_0 -> 48 in the cache */
   /* replace674_0_1 -> 2049 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fadd,
      1, 1,
      { 426, 2049 },
      -1,
   } },
   /* replace674_1 -> 244 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fneu,
      0, 2,
      { 2055, 244 },
      -1,
   } },

   /* ('iand', ('feq(is_used_once)', 'a@32', 0.0), ('feq', 'b@32', 0.0)) => ('feq', ('fadd', ('fabs', 'a'), ('fabs', 'b')), 0.0) */
   /* search675_0_0 -> 29 in the cache */
   /* search675_0_1 -> 244 in the cache */
   /* search675_0 -> 2046 in the cache */
   /* search675_1_0 -> 48 in the cache */
   /* search675_1_1 -> 244 in the cache */
   /* search675_1 -> 2047 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_iand,
      0, 3,
      { 2046, 2047 },
      -1,
   } },

   /* replace675_0_0_0 -> 29 in the cache */
   /* replace675_0_0 -> 426 in the cache */
   /* replace675_0_1_0 -> 48 in the cache */
   /* replace675_0_1 -> 2049 in the cache */
   /* replace675_0 -> 2055 in the cache */
   /* replace675_1 -> 244 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_feq,
      0, 2,
      { 2055, 244 },
      -1,
   } },

   /* ('iand', ('fneu(is_used_once)', 'a@32', 0.0), ('fneu', 'b@32', 0.0)) => ('fneu', ('fmin', ('fabs', 'a'), ('fabs', 'b')), 0.0) */
   /* search676_0_0 -> 29 in the cache */
   /* search676_0_1 -> 244 in the cache */
   /* search676_0 -> 2052 in the cache */
   /* search676_1_0 -> 48 in the cache */
   /* search676_1_1 -> 244 in the cache */
   /* search676_1 -> 2053 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_iand,
      0, 3,
      { 2052, 2053 },
      -1,
   } },

   /* replace676_0_0_0 -> 29 in the cache */
   /* replace676_0_0 -> 426 in the cache */
   /* replace676_0_1_0 -> 48 in the cache */
   /* replace676_0_1 -> 2049 in the cache */
   /* replace676_0 -> 2050 in the cache */
   /* replace676_1 -> 244 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fneu,
      0, 2,
      { 2050, 244 },
      -1,
   } },

   /* ('bcsel@32', ('feq', 'a', 0.0), 1.0, ('i2f32', ('iadd', ('b2i32', ('flt', 0.0, 'a@32')), ('ineg', ('b2i32', ('flt', 'a@32', 0.0)))))) => ('i2f32', ('iadd', ('b2i32', ('!fge', 'a', 0.0)), ('ineg', ('b2i32', ('!flt', 'a', 0.0))))) */
   /* search677_0_0 -> 29 in the cache */
   /* search677_0_1 -> 244 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_feq,
      0, 1,
      { 29, 244 },
      -1,
   } },
   /* search677_1 -> 264 in the cache */
   /* search677_2_0_0_0_0 -> 244 in the cache */
   /* search677_2_0_0_0_1 -> 29 in the cache */
   /* search677_2_0_0_0 -> 2029 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_b2i32,
      -1, 0,
      { 2029 },
      -1,
   } },
   /* search677_2_0_1_0_0_0 -> 29 in the cache */
   /* search677_2_0_1_0_0_1 -> 244 in the cache */
   /* search677_2_0_1_0_0 -> 798 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_b2i32,
      -1, 0,
      { 798 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ineg,
      -1, 0,
      { 2063 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_iadd,
      1, 1,
      { 2062, 2064 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_i2f32,
      -1, 1,
      { 2065 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_bcsel,
      -1, 2,
      { 2061, 264, 2066 },
      -1,
   } },

   /* replace677_0_0_0_0 -> 29 in the cache */
   /* replace677_0_0_0_1 -> 244 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      true,
      false,
      false,
      false,
      false,
      nir_op_fge,
      -1, 0,
      { 29, 244 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_b2i32,
      -1, 0,
      { 2068 },
      -1,
   } },
   /* replace677_0_1_0_0_0 -> 29 in the cache */
   /* replace677_0_1_0_0_1 -> 244 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      true,
      false,
      false,
      false,
      false,
      nir_op_flt,
      -1, 0,
      { 29, 244 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_b2i32,
      -1, 0,
      { 2070 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ineg,
      -1, 0,
      { 2071 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_iadd,
      0, 1,
      { 2069, 2072 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_i2f32,
      -1, 1,
      { 2073 },
      -1,
   } },

   /* ('bcsel', 'a', ('b2f(is_used_once)', 'b@32'), ('b2f', 'c@32')) => ('b2f', ('bcsel', 'a', 'b', 'c')) */
   /* search678_0 -> 862 in the cache */
   /* search678_1_0 -> 48 in the cache */
   { .expression = {
      { nir_search_value_expression, 0 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_search_op_b2f,
      -1, 0,
      { 48 },
      0,
   } },
   /* search678_2_0 -> 152 in the cache */
   { .expression = {
      { nir_search_value_expression, 0 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_search_op_b2f,
      -1, 0,
      { 152 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 0 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_bcsel,
      -1, 0,
      { 862, 2075, 2076 },
      -1,
   } },

   /* replace678_0_0 -> 862 in the cache */
   /* replace678_0_1 -> 48 in the cache */
   /* replace678_0_2 -> 152 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_bcsel,
      -1, 0,
      { 862, 48, 152 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 0 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_search_op_b2f,
      -1, 0,
      { 2078 },
      -1,
   } },

   /* ('~i2f32', ('f2i', 'a@32')) => ('ftrunc', 'a') */
   /* search679_0_0 -> 29 in the cache */
   { .expression = {
      { nir_search_value_expression, 0 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_search_op_f2i,
      -1, 0,
      { 29 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      true,
      false,
      false,
      false,
      false,
      false,
      nir_op_i2f32,
      -1, 0,
      { 2080 },
      -1,
   } },

   /* replace679_0 -> 29 in the cache */
   /* replace679 -> 797 in the cache */

   /* ('~f2i32', ('i2f', 'a@32')) => a */
   /* search680_0_0 -> 29 in the cache */
   { .expression = {
      { nir_search_value_expression, 0 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_search_op_i2f,
      -1, 0,
      { 29 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      true,
      false,
      false,
      false,
      false,
      false,
      nir_op_f2i32,
      -1, 0,
      { 2082 },
      -1,
   } },

   /* replace680 -> 29 in the cache */

   /* ('~f2i32', ('u2f', 'a@32')) => a */
   /* search681_0_0 -> 29 in the cache */
   { .expression = {
      { nir_search_value_expression, 0 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_search_op_u2f,
      -1, 0,
      { 29 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      true,
      false,
      false,
      false,
      false,
      false,
      nir_op_f2i32,
      -1, 0,
      { 2084 },
      -1,
   } },

   /* replace681 -> 29 in the cache */

   /* ('~f2u32', ('i2f', 'a@32')) => a */
   /* search682_0_0 -> 29 in the cache */
   /* search682_0 -> 2082 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      true,
      false,
      false,
      false,
      false,
      false,
      nir_op_f2u32,
      -1, 0,
      { 2082 },
      -1,
   } },

   /* replace682 -> 29 in the cache */

   /* ('~f2u32', ('u2f', 'a@32')) => a */
   /* search683_0_0 -> 29 in the cache */
   /* search683_0 -> 2084 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      true,
      false,
      false,
      false,
      false,
      false,
      nir_op_f2u32,
      -1, 0,
      { 2084 },
      -1,
   } },

   /* replace683 -> 29 in the cache */

   /* ('fadd', ('b2f32', ('flt', 0.0, 'a@32')), ('fneg', ('b2f32', ('flt', 'a@32', 0.0)))) => ('fsign', 'a') */
   /* search684_0_0_0 -> 244 in the cache */
   /* search684_0_0_1 -> 29 in the cache */
   /* search684_0_0 -> 2029 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_b2f32,
      -1, 0,
      { 2029 },
      -1,
   } },
   /* search684_1_0_0_0 -> 29 in the cache */
   /* search684_1_0_0_1 -> 244 in the cache */
   /* search684_1_0_0 -> 798 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_b2f32,
      -1, 0,
      { 798 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fneg,
      -1, 0,
      { 2089 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fadd,
      0, 1,
      { 2088, 2090 },
      -1,
   } },

   /* replace684_0 -> 29 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fsign,
      -1, 0,
      { 29 },
      -1,
   } },

   /* ('iadd', ('b2i32', ('flt', 0, 'a@32')), ('ineg', ('b2i32', ('flt', 'a@32', 0)))) => ('f2i32', ('fsign', 'a')) */
   /* search685_0_0_0 -> 139 in the cache */
   /* search685_0_0_1 -> 29 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_flt,
      -1, 0,
      { 139, 29 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_b2i32,
      -1, 0,
      { 2093 },
      -1,
   } },
   /* search685_1_0_0_0 -> 29 in the cache */
   /* search685_1_0_0_1 -> 139 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_flt,
      -1, 0,
      { 29, 139 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_b2i32,
      -1, 0,
      { 2095 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ineg,
      -1, 0,
      { 2096 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_iadd,
      0, 1,
      { 2094, 2097 },
      -1,
   } },

   /* replace685_0_0 -> 29 in the cache */
   /* replace685_0 -> 2092 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_f2i32,
      -1, 0,
      { 2092 },
      -1,
   } },

   /* ('~f2f32', ('f2f', 'a')) => ('f2f32', 'a') */
   /* search686_0_0 -> 9 in the cache */
   /* search686_0 -> 1991 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      true,
      false,
      false,
      false,
      false,
      false,
      nir_op_f2f32,
      -1, 0,
      { 1991 },
      -1,
   } },

   /* replace686_0 -> 9 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_f2f32,
      -1, 0,
      { 9 },
      -1,
   } },

   /* ('~f2f32', ('u2f', 'a')) => ('u2f32', 'a') */
   /* search687_0_0 -> 9 in the cache */
   /* search687_0 -> 123 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      true,
      false,
      false,
      false,
      false,
      false,
      nir_op_f2f32,
      -1, 0,
      { 123 },
      -1,
   } },

   /* replace687_0 -> 9 in the cache */
   /* replace687 -> 2010 in the cache */

   /* ('~f2f32', ('i2f', 'a')) => ('i2f32', 'a') */
   /* search688_0_0 -> 9 in the cache */
   /* search688_0 -> 1424 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      true,
      false,
      false,
      false,
      false,
      false,
      nir_op_f2f32,
      -1, 0,
      { 1424 },
      -1,
   } },

   /* replace688_0 -> 9 in the cache */
   /* replace688 -> 2012 in the cache */

   /* ('~f2u32', ('f2f', 'a')) => ('f2u32', 'a') */
   /* search689_0_0 -> 9 in the cache */
   /* search689_0 -> 1991 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      true,
      false,
      false,
      false,
      false,
      false,
      nir_op_f2u32,
      -1, 0,
      { 1991 },
      -1,
   } },

   /* replace689_0 -> 9 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_f2u32,
      -1, 0,
      { 9 },
      -1,
   } },

   /* ('~f2i32', ('f2f', 'a')) => ('f2i32', 'a') */
   /* search690_0_0 -> 9 in the cache */
   /* search690_0 -> 1991 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      true,
      false,
      false,
      false,
      false,
      false,
      nir_op_f2i32,
      -1, 0,
      { 1991 },
      -1,
   } },

   /* replace690_0 -> 9 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_f2i32,
      -1, 0,
      { 9 },
      -1,
   } },

   /* ('i2f32', ('f2i', ('fsign', 'a@32'))) => ('fsign', 'a') */
   /* search691_0_0_0 -> 29 in the cache */
   /* search691_0_0 -> 2092 in the cache */
   { .expression = {
      { nir_search_value_expression, 0 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_search_op_f2i,
      -1, 0,
      { 2092 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_i2f32,
      -1, 0,
      { 2108 },
      -1,
   } },

   /* replace691_0 -> 29 in the cache */
   /* replace691 -> 2092 in the cache */

   /* ('~f2f32', ('f2f64', 'a@32')) => a */
   /* search692_0_0 -> 29 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_f2f64,
      -1, 0,
      { 29 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      true,
      false,
      false,
      false,
      false,
      false,
      nir_op_f2f32,
      -1, 0,
      { 2110 },
      -1,
   } },

   /* replace692 -> 29 in the cache */

   /* ('f2u64', ('f2f64', 'a@32')) => ('f2u64', 'a') */
   /* search693_0_0 -> 29 in the cache */
   /* search693_0 -> 2110 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_f2u64,
      -1, 0,
      { 2110 },
      -1,
   } },

   /* replace693_0 -> 29 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_f2u64,
      -1, 0,
      { 29 },
      -1,
   } },

   /* ('f2i64', ('f2f64', 'a@32')) => ('f2i64', 'a') */
   /* search694_0_0 -> 29 in the cache */
   /* search694_0 -> 2110 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_f2i64,
      -1, 0,
      { 2110 },
      -1,
   } },

   /* replace694_0 -> 29 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_f2i64,
      -1, 0,
      { 29 },
      -1,
   } },

   /* ('f2f32', ('u2f64', 'a')) => ('u2f32', 'a') */
   /* search695_0_0 -> 9 in the cache */
   /* search695_0 -> 2020 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_f2f32,
      -1, 0,
      { 2020 },
      -1,
   } },

   /* replace695_0 -> 9 in the cache */
   /* replace695 -> 2010 in the cache */

   /* ('f2f32', ('i2f64', 'a')) => ('i2f32', 'a') */
   /* search696_0_0 -> 9 in the cache */
   /* search696_0 -> 2022 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_f2f32,
      -1, 0,
      { 2022 },
      -1,
   } },

   /* replace696_0 -> 9 in the cache */
   /* replace696 -> 2012 in the cache */

   /* ('ior', ('flt(is_used_once)', 0.0, 'a@64'), ('flt', 'b@64', 0.0)) => ('flt', 0.0, ('fmax', 'a', ('fneg', 'b'))) */
   /* search697_0_0 -> 803 in the cache */
   /* search697_0_1 -> 34 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_flt,
      -1, 0,
      { 803, 34 },
      0,
   } },
   /* search697_1_0 -> 53 in the cache */
   /* search697_1_1 -> 803 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_flt,
      -1, 0,
      { 53, 803 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ior,
      0, 1,
      { 2118, 2119 },
      -1,
   } },

   /* replace697_0 -> 803 in the cache */
   /* replace697_1_0 -> 34 in the cache */
   /* replace697_1_1_0 -> 53 in the cache */
   /* replace697_1_1 -> 775 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fmax,
      0, 1,
      { 34, 775 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_flt,
      -1, 1,
      { 803, 2121 },
      -1,
   } },

   /* ('ior', ('flt', 0.0, 'a@64'), ('flt(is_used_once)', 'b@64', 0.0)) => ('flt', 0.0, ('fmax', 'a', ('fneg', 'b'))) */
   /* search698_0_0 -> 803 in the cache */
   /* search698_0_1 -> 34 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_flt,
      -1, 0,
      { 803, 34 },
      -1,
   } },
   /* search698_1_0 -> 53 in the cache */
   /* search698_1_1 -> 803 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_flt,
      -1, 0,
      { 53, 803 },
      0,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ior,
      0, 1,
      { 2123, 2124 },
      -1,
   } },

   /* replace698_0 -> 803 in the cache */
   /* replace698_1_0 -> 34 in the cache */
   /* replace698_1_1_0 -> 53 in the cache */
   /* replace698_1_1 -> 775 in the cache */
   /* replace698_1 -> 2121 in the cache */
   /* replace698 -> 2122 in the cache */

   /* ('ior', ('fge(is_used_once)', 0.0, 'a@64'), ('fge', 'b@64', 0.0)) => ('fge', 0.0, ('fmin', 'a', ('fneg', 'b'))) */
   /* search699_0_0 -> 803 in the cache */
   /* search699_0_1 -> 34 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fge,
      -1, 0,
      { 803, 34 },
      0,
   } },
   /* search699_1_0 -> 53 in the cache */
   /* search699_1_1 -> 803 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fge,
      -1, 0,
      { 53, 803 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ior,
      0, 1,
      { 2126, 2127 },
      -1,
   } },

   /* replace699_0 -> 803 in the cache */
   /* replace699_1_0 -> 34 in the cache */
   /* replace699_1_1_0 -> 53 in the cache */
   /* replace699_1_1 -> 775 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fmin,
      0, 1,
      { 34, 775 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fge,
      -1, 1,
      { 803, 2129 },
      -1,
   } },

   /* ('ior', ('fge', 0.0, 'a@64'), ('fge(is_used_once)', 'b@64', 0.0)) => ('fge', 0.0, ('fmin', 'a', ('fneg', 'b'))) */
   /* search700_0_0 -> 803 in the cache */
   /* search700_0_1 -> 34 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fge,
      -1, 0,
      { 803, 34 },
      -1,
   } },
   /* search700_1_0 -> 53 in the cache */
   /* search700_1_1 -> 803 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fge,
      -1, 0,
      { 53, 803 },
      0,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ior,
      0, 1,
      { 2131, 2132 },
      -1,
   } },

   /* replace700_0 -> 803 in the cache */
   /* replace700_1_0 -> 34 in the cache */
   /* replace700_1_1_0 -> 53 in the cache */
   /* replace700_1_1 -> 775 in the cache */
   /* replace700_1 -> 2129 in the cache */
   /* replace700 -> 2130 in the cache */

   /* ('~iand', ('flt(is_used_once)', 0.0, 'a@64'), ('flt', 'b@64', 0.0)) => ('flt', 0.0, ('fmin', 'a', ('fneg', 'b'))) */
   /* search701_0_0 -> 803 in the cache */
   /* search701_0_1 -> 34 in the cache */
   /* search701_0 -> 2118 in the cache */
   /* search701_1_0 -> 53 in the cache */
   /* search701_1_1 -> 803 in the cache */
   /* search701_1 -> 2119 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      true,
      false,
      false,
      false,
      false,
      false,
      nir_op_iand,
      0, 1,
      { 2118, 2119 },
      -1,
   } },

   /* replace701_0 -> 803 in the cache */
   /* replace701_1_0 -> 34 in the cache */
   /* replace701_1_1_0 -> 53 in the cache */
   /* replace701_1_1 -> 775 in the cache */
   /* replace701_1 -> 2129 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_flt,
      -1, 1,
      { 803, 2129 },
      -1,
   } },

   /* ('~iand', ('flt', 0.0, 'a@64'), ('flt(is_used_once)', 'b@64', 0.0)) => ('flt', 0.0, ('fmin', 'a', ('fneg', 'b'))) */
   /* search702_0_0 -> 803 in the cache */
   /* search702_0_1 -> 34 in the cache */
   /* search702_0 -> 2123 in the cache */
   /* search702_1_0 -> 53 in the cache */
   /* search702_1_1 -> 803 in the cache */
   /* search702_1 -> 2124 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      true,
      false,
      false,
      false,
      false,
      false,
      nir_op_iand,
      0, 1,
      { 2123, 2124 },
      -1,
   } },

   /* replace702_0 -> 803 in the cache */
   /* replace702_1_0 -> 34 in the cache */
   /* replace702_1_1_0 -> 53 in the cache */
   /* replace702_1_1 -> 775 in the cache */
   /* replace702_1 -> 2129 in the cache */
   /* replace702 -> 2135 in the cache */

   /* ('~iand', ('fge(is_used_once)', 0.0, 'a@64'), ('fge', 'b@64', 0.0)) => ('fge', 0.0, ('fmax', 'a', ('fneg', 'b'))) */
   /* search703_0_0 -> 803 in the cache */
   /* search703_0_1 -> 34 in the cache */
   /* search703_0 -> 2126 in the cache */
   /* search703_1_0 -> 53 in the cache */
   /* search703_1_1 -> 803 in the cache */
   /* search703_1 -> 2127 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      true,
      false,
      false,
      false,
      false,
      false,
      nir_op_iand,
      0, 1,
      { 2126, 2127 },
      -1,
   } },

   /* replace703_0 -> 803 in the cache */
   /* replace703_1_0 -> 34 in the cache */
   /* replace703_1_1_0 -> 53 in the cache */
   /* replace703_1_1 -> 775 in the cache */
   /* replace703_1 -> 2121 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fge,
      -1, 1,
      { 803, 2121 },
      -1,
   } },

   /* ('~iand', ('fge', 0.0, 'a@64'), ('fge(is_used_once)', 'b@64', 0.0)) => ('fge', 0.0, ('fmax', 'a', ('fneg', 'b'))) */
   /* search704_0_0 -> 803 in the cache */
   /* search704_0_1 -> 34 in the cache */
   /* search704_0 -> 2131 in the cache */
   /* search704_1_0 -> 53 in the cache */
   /* search704_1_1 -> 803 in the cache */
   /* search704_1 -> 2132 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      true,
      false,
      false,
      false,
      false,
      false,
      nir_op_iand,
      0, 1,
      { 2131, 2132 },
      -1,
   } },

   /* replace704_0 -> 803 in the cache */
   /* replace704_1_0 -> 34 in the cache */
   /* replace704_1_1_0 -> 53 in the cache */
   /* replace704_1_1 -> 775 in the cache */
   /* replace704_1 -> 2121 in the cache */
   /* replace704 -> 2138 in the cache */

   /* ('ior', ('feq(is_used_once)', 'a@64', 0.0), ('feq', 'b@64', 0.0)) => ('feq', ('fmin', ('fabs', 'a'), ('fabs', 'b')), 0.0) */
   /* search705_0_0 -> 34 in the cache */
   /* search705_0_1 -> 803 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_feq,
      1, 1,
      { 34, 803 },
      0,
   } },
   /* search705_1_0 -> 53 in the cache */
   /* search705_1_1 -> 803 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_feq,
      2, 1,
      { 53, 803 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ior,
      0, 3,
      { 2140, 2141 },
      -1,
   } },

   /* replace705_0_0_0 -> 34 in the cache */
   /* replace705_0_0 -> 805 in the cache */
   /* replace705_0_1_0 -> 53 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fabs,
      -1, 0,
      { 53 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fmin,
      1, 1,
      { 805, 2143 },
      -1,
   } },
   /* replace705_1 -> 803 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_feq,
      0, 2,
      { 2144, 803 },
      -1,
   } },

   /* ('ior', ('fneu(is_used_once)', 'a@64', 0.0), ('fneu', 'b@64', 0.0)) => ('fneu', ('fadd', ('fabs', 'a'), ('fabs', 'b')), 0.0) */
   /* search706_0_0 -> 34 in the cache */
   /* search706_0_1 -> 803 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fneu,
      1, 1,
      { 34, 803 },
      0,
   } },
   /* search706_1_0 -> 53 in the cache */
   /* search706_1_1 -> 803 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fneu,
      2, 1,
      { 53, 803 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ior,
      0, 3,
      { 2146, 2147 },
      -1,
   } },

   /* replace706_0_0_0 -> 34 in the cache */
   /* replace706_0_0 -> 805 in the cache */
   /* replace706_0_1_0 -> 53 in the cache */
   /* replace706_0_1 -> 2143 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fadd,
      1, 1,
      { 805, 2143 },
      -1,
   } },
   /* replace706_1 -> 803 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fneu,
      0, 2,
      { 2149, 803 },
      -1,
   } },

   /* ('iand', ('feq(is_used_once)', 'a@64', 0.0), ('feq', 'b@64', 0.0)) => ('feq', ('fadd', ('fabs', 'a'), ('fabs', 'b')), 0.0) */
   /* search707_0_0 -> 34 in the cache */
   /* search707_0_1 -> 803 in the cache */
   /* search707_0 -> 2140 in the cache */
   /* search707_1_0 -> 53 in the cache */
   /* search707_1_1 -> 803 in the cache */
   /* search707_1 -> 2141 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_iand,
      0, 3,
      { 2140, 2141 },
      -1,
   } },

   /* replace707_0_0_0 -> 34 in the cache */
   /* replace707_0_0 -> 805 in the cache */
   /* replace707_0_1_0 -> 53 in the cache */
   /* replace707_0_1 -> 2143 in the cache */
   /* replace707_0 -> 2149 in the cache */
   /* replace707_1 -> 803 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_feq,
      0, 2,
      { 2149, 803 },
      -1,
   } },

   /* ('iand', ('fneu(is_used_once)', 'a@64', 0.0), ('fneu', 'b@64', 0.0)) => ('fneu', ('fmin', ('fabs', 'a'), ('fabs', 'b')), 0.0) */
   /* search708_0_0 -> 34 in the cache */
   /* search708_0_1 -> 803 in the cache */
   /* search708_0 -> 2146 in the cache */
   /* search708_1_0 -> 53 in the cache */
   /* search708_1_1 -> 803 in the cache */
   /* search708_1 -> 2147 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_iand,
      0, 3,
      { 2146, 2147 },
      -1,
   } },

   /* replace708_0_0_0 -> 34 in the cache */
   /* replace708_0_0 -> 805 in the cache */
   /* replace708_0_1_0 -> 53 in the cache */
   /* replace708_0_1 -> 2143 in the cache */
   /* replace708_0 -> 2144 in the cache */
   /* replace708_1 -> 803 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fneu,
      0, 2,
      { 2144, 803 },
      -1,
   } },

   /* ('bcsel@64', ('feq', 'a', 0.0), 1.0, ('i2f64', ('iadd', ('b2i64', ('flt', 0.0, 'a@64')), ('ineg', ('b2i64', ('flt', 'a@64', 0.0)))))) => ('i2f64', ('iadd', ('b2i32', ('!fge', 'a', 0.0)), ('ineg', ('b2i32', ('!flt', 'a', 0.0))))) */
   /* search709_0_0 -> 34 in the cache */
   /* search709_0_1 -> 803 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_feq,
      0, 1,
      { 34, 803 },
      -1,
   } },
   /* search709_1 -> 724 in the cache */
   /* search709_2_0_0_0_0 -> 803 in the cache */
   /* search709_2_0_0_0_1 -> 34 in the cache */
   /* search709_2_0_0_0 -> 2123 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_b2i64,
      -1, 0,
      { 2123 },
      -1,
   } },
   /* search709_2_0_1_0_0_0 -> 34 in the cache */
   /* search709_2_0_1_0_0_1 -> 803 in the cache */
   /* search709_2_0_1_0_0 -> 804 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_b2i64,
      -1, 0,
      { 804 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ineg,
      -1, 0,
      { 2157 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_iadd,
      1, 1,
      { 2156, 2158 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_i2f64,
      -1, 1,
      { 2159 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_bcsel,
      -1, 2,
      { 2155, 724, 2160 },
      -1,
   } },

   /* replace709_0_0_0_0 -> 34 in the cache */
   /* replace709_0_0_0_1 -> 803 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      true,
      false,
      false,
      false,
      false,
      nir_op_fge,
      -1, 0,
      { 34, 803 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_b2i32,
      -1, 0,
      { 2162 },
      -1,
   } },
   /* replace709_0_1_0_0_0 -> 34 in the cache */
   /* replace709_0_1_0_0_1 -> 803 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      true,
      false,
      false,
      false,
      false,
      nir_op_flt,
      -1, 0,
      { 34, 803 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_b2i32,
      -1, 0,
      { 2164 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ineg,
      -1, 0,
      { 2165 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_iadd,
      0, 1,
      { 2163, 2166 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_i2f64,
      -1, 1,
      { 2167 },
      -1,
   } },

   /* ('bcsel', 'a', ('b2f(is_used_once)', 'b@64'), ('b2f', 'c@64')) => ('b2f', ('bcsel', 'a', 'b', 'c')) */
   /* search710_0 -> 862 in the cache */
   /* search710_1_0 -> 53 in the cache */
   { .expression = {
      { nir_search_value_expression, 0 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_search_op_b2f,
      -1, 0,
      { 53 },
      0,
   } },
   /* search710_2_0 -> 712 in the cache */
   { .expression = {
      { nir_search_value_expression, 0 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_search_op_b2f,
      -1, 0,
      { 712 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 0 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_bcsel,
      -1, 0,
      { 862, 2169, 2170 },
      -1,
   } },

   /* replace710_0_0 -> 862 in the cache */
   /* replace710_0_1 -> 53 in the cache */
   /* replace710_0_2 -> 712 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_bcsel,
      -1, 0,
      { 862, 53, 712 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 0 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_search_op_b2f,
      -1, 0,
      { 2172 },
      -1,
   } },

   /* ('~i2f64', ('f2i', 'a@64')) => ('ftrunc', 'a') */
   /* search711_0_0 -> 34 in the cache */
   { .expression = {
      { nir_search_value_expression, 0 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_search_op_f2i,
      -1, 0,
      { 34 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 64 },
      true,
      false,
      false,
      false,
      false,
      false,
      nir_op_i2f64,
      -1, 0,
      { 2174 },
      -1,
   } },

   /* replace711_0 -> 34 in the cache */
   /* replace711 -> 802 in the cache */

   /* ('~f2i64', ('i2f', 'a@64')) => a */
   /* search712_0_0 -> 34 in the cache */
   { .expression = {
      { nir_search_value_expression, 0 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_search_op_i2f,
      -1, 0,
      { 34 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 64 },
      true,
      false,
      false,
      false,
      false,
      false,
      nir_op_f2i64,
      -1, 0,
      { 2176 },
      -1,
   } },

   /* replace712 -> 34 in the cache */

   /* ('~f2i64', ('u2f', 'a@64')) => a */
   /* search713_0_0 -> 34 in the cache */
   { .expression = {
      { nir_search_value_expression, 0 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_search_op_u2f,
      -1, 0,
      { 34 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 64 },
      true,
      false,
      false,
      false,
      false,
      false,
      nir_op_f2i64,
      -1, 0,
      { 2178 },
      -1,
   } },

   /* replace713 -> 34 in the cache */

   /* ('~f2u64', ('i2f', 'a@64')) => a */
   /* search714_0_0 -> 34 in the cache */
   /* search714_0 -> 2176 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      true,
      false,
      false,
      false,
      false,
      false,
      nir_op_f2u64,
      -1, 0,
      { 2176 },
      -1,
   } },

   /* replace714 -> 34 in the cache */

   /* ('~f2u64', ('u2f', 'a@64')) => a */
   /* search715_0_0 -> 34 in the cache */
   /* search715_0 -> 2178 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      true,
      false,
      false,
      false,
      false,
      false,
      nir_op_f2u64,
      -1, 0,
      { 2178 },
      -1,
   } },

   /* replace715 -> 34 in the cache */

   /* ('fadd', ('b2f64', ('flt', 0.0, 'a@64')), ('fneg', ('b2f64', ('flt', 'a@64', 0.0)))) => ('fsign', 'a') */
   /* search716_0_0_0 -> 803 in the cache */
   /* search716_0_0_1 -> 34 in the cache */
   /* search716_0_0 -> 2123 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_b2f64,
      -1, 0,
      { 2123 },
      -1,
   } },
   /* search716_1_0_0_0 -> 34 in the cache */
   /* search716_1_0_0_1 -> 803 in the cache */
   /* search716_1_0_0 -> 804 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_b2f64,
      -1, 0,
      { 804 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fneg,
      -1, 0,
      { 2183 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fadd,
      0, 1,
      { 2182, 2184 },
      -1,
   } },

   /* replace716_0 -> 34 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fsign,
      -1, 0,
      { 34 },
      -1,
   } },

   /* ('iadd', ('b2i64', ('flt', 0, 'a@64')), ('ineg', ('b2i64', ('flt', 'a@64', 0)))) => ('f2i64', ('fsign', 'a')) */
   /* search717_0_0_0 -> 1002 in the cache */
   /* search717_0_0_1 -> 34 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_flt,
      -1, 0,
      { 1002, 34 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_b2i64,
      -1, 0,
      { 2187 },
      -1,
   } },
   /* search717_1_0_0_0 -> 34 in the cache */
   /* search717_1_0_0_1 -> 1002 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_flt,
      -1, 0,
      { 34, 1002 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_b2i64,
      -1, 0,
      { 2189 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ineg,
      -1, 0,
      { 2190 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_iadd,
      0, 1,
      { 2188, 2191 },
      -1,
   } },

   /* replace717_0_0 -> 34 in the cache */
   /* replace717_0 -> 2186 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_f2i64,
      -1, 0,
      { 2186 },
      -1,
   } },

   /* ('~f2f64', ('f2f', 'a')) => ('f2f64', 'a') */
   /* search718_0_0 -> 9 in the cache */
   /* search718_0 -> 1991 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      true,
      false,
      false,
      false,
      false,
      false,
      nir_op_f2f64,
      -1, 0,
      { 1991 },
      -1,
   } },

   /* replace718_0 -> 9 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_f2f64,
      -1, 0,
      { 9 },
      -1,
   } },

   /* ('~f2f64', ('u2f', 'a')) => ('u2f64', 'a') */
   /* search719_0_0 -> 9 in the cache */
   /* search719_0 -> 123 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      true,
      false,
      false,
      false,
      false,
      false,
      nir_op_f2f64,
      -1, 0,
      { 123 },
      -1,
   } },

   /* replace719_0 -> 9 in the cache */
   /* replace719 -> 2020 in the cache */

   /* ('~f2f64', ('i2f', 'a')) => ('i2f64', 'a') */
   /* search720_0_0 -> 9 in the cache */
   /* search720_0 -> 1424 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      true,
      false,
      false,
      false,
      false,
      false,
      nir_op_f2f64,
      -1, 0,
      { 1424 },
      -1,
   } },

   /* replace720_0 -> 9 in the cache */
   /* replace720 -> 2022 in the cache */

   /* ('~f2u64', ('f2f', 'a')) => ('f2u64', 'a') */
   /* search721_0_0 -> 9 in the cache */
   /* search721_0 -> 1991 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      true,
      false,
      false,
      false,
      false,
      false,
      nir_op_f2u64,
      -1, 0,
      { 1991 },
      -1,
   } },

   /* replace721_0 -> 9 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_f2u64,
      -1, 0,
      { 9 },
      -1,
   } },

   /* ('~f2i64', ('f2f', 'a')) => ('f2i64', 'a') */
   /* search722_0_0 -> 9 in the cache */
   /* search722_0 -> 1991 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      true,
      false,
      false,
      false,
      false,
      false,
      nir_op_f2i64,
      -1, 0,
      { 1991 },
      -1,
   } },

   /* replace722_0 -> 9 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_f2i64,
      -1, 0,
      { 9 },
      -1,
   } },

   /* ('i2f64', ('f2i', ('fsign', 'a@64'))) => ('fsign', 'a') */
   /* search723_0_0_0 -> 34 in the cache */
   /* search723_0_0 -> 2186 in the cache */
   { .expression = {
      { nir_search_value_expression, 0 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_search_op_f2i,
      -1, 0,
      { 2186 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_i2f64,
      -1, 0,
      { 2202 },
      -1,
   } },

   /* replace723_0 -> 34 in the cache */
   /* replace723 -> 2186 in the cache */

   /* ('i2i1', ('i2i8', 'a@1')) => a */
   /* search724_0_0 -> 862 in the cache */
   { .expression = {
      { nir_search_value_expression, 8 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_i2i8,
      -1, 0,
      { 862 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_i2i1,
      -1, 0,
      { 2204 },
      -1,
   } },

   /* replace724 -> 862 in the cache */

   /* ('u2u1', ('u2u8', 'a@1')) => a */
   /* search725_0_0 -> 862 in the cache */
   { .expression = {
      { nir_search_value_expression, 8 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_u2u8,
      -1, 0,
      { 862 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_u2u1,
      -1, 0,
      { 2206 },
      -1,
   } },

   /* replace725 -> 862 in the cache */

   /* ('i2i1', ('i2i16', 'a@1')) => a */
   /* search726_0_0 -> 862 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_i2i16,
      -1, 0,
      { 862 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_i2i1,
      -1, 0,
      { 2208 },
      -1,
   } },

   /* replace726 -> 862 in the cache */

   /* ('u2u1', ('u2u16', 'a@1')) => a */
   /* search727_0_0 -> 862 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_u2u16,
      -1, 0,
      { 862 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_u2u1,
      -1, 0,
      { 2210 },
      -1,
   } },

   /* replace727 -> 862 in the cache */

   /* ('u2f16', ('u2u8', 'a@1')) => ('u2f16', 'a') */
   /* search728_0_0 -> 862 in the cache */
   /* search728_0 -> 2206 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_u2f16,
      -1, 0,
      { 2206 },
      -1,
   } },

   /* replace728_0 -> 862 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_u2f16,
      -1, 0,
      { 862 },
      -1,
   } },

   /* ('i2f16', ('i2i8', 'a@1')) => ('i2f16', 'a') */
   /* search729_0_0 -> 862 in the cache */
   /* search729_0 -> 2204 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_i2f16,
      -1, 0,
      { 2204 },
      -1,
   } },

   /* replace729_0 -> 862 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_i2f16,
      -1, 0,
      { 862 },
      -1,
   } },

   /* ('u2f16', ('u2u16', 'a@1')) => ('u2f16', 'a') */
   /* search730_0_0 -> 862 in the cache */
   /* search730_0 -> 2210 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_u2f16,
      -1, 0,
      { 2210 },
      -1,
   } },

   /* replace730_0 -> 862 in the cache */
   /* replace730 -> 2213 in the cache */

   /* ('i2f16', ('i2i16', 'a@1')) => ('i2f16', 'a') */
   /* search731_0_0 -> 862 in the cache */
   /* search731_0 -> 2208 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_i2f16,
      -1, 0,
      { 2208 },
      -1,
   } },

   /* replace731_0 -> 862 in the cache */
   /* replace731 -> 2215 in the cache */

   /* ('u2f16', ('u2u32', 'a@1')) => ('u2f16', 'a') */
   /* search732_0_0 -> 862 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_u2u32,
      -1, 0,
      { 862 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_u2f16,
      -1, 0,
      { 2218 },
      -1,
   } },

   /* replace732_0 -> 862 in the cache */
   /* replace732 -> 2213 in the cache */

   /* ('i2f16', ('i2i32', 'a@1')) => ('i2f16', 'a') */
   /* search733_0_0 -> 862 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_i2i32,
      -1, 0,
      { 862 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_i2f16,
      -1, 0,
      { 2220 },
      -1,
   } },

   /* replace733_0 -> 862 in the cache */
   /* replace733 -> 2215 in the cache */

   /* ('u2f16', ('u2u64', 'a@1')) => ('u2f16', 'a') */
   /* search734_0_0 -> 862 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_u2u64,
      -1, 0,
      { 862 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_u2f16,
      -1, 0,
      { 2222 },
      -1,
   } },

   /* replace734_0 -> 862 in the cache */
   /* replace734 -> 2213 in the cache */

   /* ('i2f16', ('i2i64', 'a@1')) => ('i2f16', 'a') */
   /* search735_0_0 -> 862 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_i2i64,
      -1, 0,
      { 862 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_i2f16,
      -1, 0,
      { 2224 },
      -1,
   } },

   /* replace735_0 -> 862 in the cache */
   /* replace735 -> 2215 in the cache */

   /* ('i2i1', ('i2i32', 'a@1')) => a */
   /* search736_0_0 -> 862 in the cache */
   /* search736_0 -> 2220 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_i2i1,
      -1, 0,
      { 2220 },
      -1,
   } },

   /* replace736 -> 862 in the cache */

   /* ('u2u1', ('u2u32', 'a@1')) => a */
   /* search737_0_0 -> 862 in the cache */
   /* search737_0 -> 2218 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_u2u1,
      -1, 0,
      { 2218 },
      -1,
   } },

   /* replace737 -> 862 in the cache */

   /* ('u2f32', ('u2u8', 'a@1')) => ('u2f32', 'a') */
   /* search738_0_0 -> 862 in the cache */
   /* search738_0 -> 2206 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_u2f32,
      -1, 0,
      { 2206 },
      -1,
   } },

   /* replace738_0 -> 862 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_u2f32,
      -1, 0,
      { 862 },
      -1,
   } },

   /* ('i2f32', ('i2i8', 'a@1')) => ('i2f32', 'a') */
   /* search739_0_0 -> 862 in the cache */
   /* search739_0 -> 2204 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_i2f32,
      -1, 0,
      { 2204 },
      -1,
   } },

   /* replace739_0 -> 862 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_i2f32,
      -1, 0,
      { 862 },
      -1,
   } },

   /* ('u2f32', ('u2u16', 'a@1')) => ('u2f32', 'a') */
   /* search740_0_0 -> 862 in the cache */
   /* search740_0 -> 2210 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_u2f32,
      -1, 0,
      { 2210 },
      -1,
   } },

   /* replace740_0 -> 862 in the cache */
   /* replace740 -> 2229 in the cache */

   /* ('i2f32', ('i2i16', 'a@1')) => ('i2f32', 'a') */
   /* search741_0_0 -> 862 in the cache */
   /* search741_0 -> 2208 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_i2f32,
      -1, 0,
      { 2208 },
      -1,
   } },

   /* replace741_0 -> 862 in the cache */
   /* replace741 -> 2231 in the cache */

   /* ('u2f32', ('u2u32', 'a@1')) => ('u2f32', 'a') */
   /* search742_0_0 -> 862 in the cache */
   /* search742_0 -> 2218 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_u2f32,
      -1, 0,
      { 2218 },
      -1,
   } },

   /* replace742_0 -> 862 in the cache */
   /* replace742 -> 2229 in the cache */

   /* ('i2f32', ('i2i32', 'a@1')) => ('i2f32', 'a') */
   /* search743_0_0 -> 862 in the cache */
   /* search743_0 -> 2220 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_i2f32,
      -1, 0,
      { 2220 },
      -1,
   } },

   /* replace743_0 -> 862 in the cache */
   /* replace743 -> 2231 in the cache */

   /* ('u2f32', ('u2u64', 'a@1')) => ('u2f32', 'a') */
   /* search744_0_0 -> 862 in the cache */
   /* search744_0 -> 2222 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_u2f32,
      -1, 0,
      { 2222 },
      -1,
   } },

   /* replace744_0 -> 862 in the cache */
   /* replace744 -> 2229 in the cache */

   /* ('i2f32', ('i2i64', 'a@1')) => ('i2f32', 'a') */
   /* search745_0_0 -> 862 in the cache */
   /* search745_0 -> 2224 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_i2f32,
      -1, 0,
      { 2224 },
      -1,
   } },

   /* replace745_0 -> 862 in the cache */
   /* replace745 -> 2231 in the cache */

   /* ('i2i1', ('i2i64', 'a@1')) => a */
   /* search746_0_0 -> 862 in the cache */
   /* search746_0 -> 2224 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_i2i1,
      -1, 0,
      { 2224 },
      -1,
   } },

   /* replace746 -> 862 in the cache */

   /* ('u2u1', ('u2u64', 'a@1')) => a */
   /* search747_0_0 -> 862 in the cache */
   /* search747_0 -> 2222 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_u2u1,
      -1, 0,
      { 2222 },
      -1,
   } },

   /* replace747 -> 862 in the cache */

   /* ('u2f64', ('u2u8', 'a@1')) => ('u2f64', 'a') */
   /* search748_0_0 -> 862 in the cache */
   /* search748_0 -> 2206 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_u2f64,
      -1, 0,
      { 2206 },
      -1,
   } },

   /* replace748_0 -> 862 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_u2f64,
      -1, 0,
      { 862 },
      -1,
   } },

   /* ('i2f64', ('i2i8', 'a@1')) => ('i2f64', 'a') */
   /* search749_0_0 -> 862 in the cache */
   /* search749_0 -> 2204 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_i2f64,
      -1, 0,
      { 2204 },
      -1,
   } },

   /* replace749_0 -> 862 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_i2f64,
      -1, 0,
      { 862 },
      -1,
   } },

   /* ('u2f64', ('u2u16', 'a@1')) => ('u2f64', 'a') */
   /* search750_0_0 -> 862 in the cache */
   /* search750_0 -> 2210 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_u2f64,
      -1, 0,
      { 2210 },
      -1,
   } },

   /* replace750_0 -> 862 in the cache */
   /* replace750 -> 2241 in the cache */

   /* ('i2f64', ('i2i16', 'a@1')) => ('i2f64', 'a') */
   /* search751_0_0 -> 862 in the cache */
   /* search751_0 -> 2208 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_i2f64,
      -1, 0,
      { 2208 },
      -1,
   } },

   /* replace751_0 -> 862 in the cache */
   /* replace751 -> 2243 in the cache */

   /* ('u2f64', ('u2u32', 'a@1')) => ('u2f64', 'a') */
   /* search752_0_0 -> 862 in the cache */
   /* search752_0 -> 2218 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_u2f64,
      -1, 0,
      { 2218 },
      -1,
   } },

   /* replace752_0 -> 862 in the cache */
   /* replace752 -> 2241 in the cache */

   /* ('i2f64', ('i2i32', 'a@1')) => ('i2f64', 'a') */
   /* search753_0_0 -> 862 in the cache */
   /* search753_0 -> 2220 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_i2f64,
      -1, 0,
      { 2220 },
      -1,
   } },

   /* replace753_0 -> 862 in the cache */
   /* replace753 -> 2243 in the cache */

   /* ('u2f64', ('u2u64', 'a@1')) => ('u2f64', 'a') */
   /* search754_0_0 -> 862 in the cache */
   /* search754_0 -> 2222 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_u2f64,
      -1, 0,
      { 2222 },
      -1,
   } },

   /* replace754_0 -> 862 in the cache */
   /* replace754 -> 2241 in the cache */

   /* ('i2f64', ('i2i64', 'a@1')) => ('i2f64', 'a') */
   /* search755_0_0 -> 862 in the cache */
   /* search755_0 -> 2224 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_i2f64,
      -1, 0,
      { 2224 },
      -1,
   } },

   /* replace755_0 -> 862 in the cache */
   /* replace755 -> 2243 in the cache */

   /* ('i2i8', ('i2i16', 'a@8')) => a */
   /* search756_0_0 -> 19 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_i2i16,
      -1, 0,
      { 19 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 8 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_i2i8,
      -1, 0,
      { 2250 },
      -1,
   } },

   /* replace756 -> 19 in the cache */

   /* ('u2u8', ('u2u16', 'a@8')) => a */
   /* search757_0_0 -> 19 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_u2u16,
      -1, 0,
      { 19 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 8 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_u2u8,
      -1, 0,
      { 2252 },
      -1,
   } },

   /* replace757 -> 19 in the cache */

   /* ('u2f16', ('u2u16', 'a@8')) => ('u2f16', 'a') */
   /* search758_0_0 -> 19 in the cache */
   /* search758_0 -> 2252 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_u2f16,
      -1, 0,
      { 2252 },
      -1,
   } },

   /* replace758_0 -> 19 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_u2f16,
      -1, 0,
      { 19 },
      -1,
   } },

   /* ('i2f16', ('i2i16', 'a@8')) => ('i2f16', 'a') */
   /* search759_0_0 -> 19 in the cache */
   /* search759_0 -> 2250 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_i2f16,
      -1, 0,
      { 2250 },
      -1,
   } },

   /* replace759_0 -> 19 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_i2f16,
      -1, 0,
      { 19 },
      -1,
   } },

   /* ('u2f16', ('u2u32', 'a@8')) => ('u2f16', 'a') */
   /* search760_0_0 -> 19 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_u2u32,
      -1, 0,
      { 19 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_u2f16,
      -1, 0,
      { 2258 },
      -1,
   } },

   /* replace760_0 -> 19 in the cache */
   /* replace760 -> 2255 in the cache */

   /* ('i2f16', ('i2i32', 'a@8')) => ('i2f16', 'a') */
   /* search761_0_0 -> 19 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_i2i32,
      -1, 0,
      { 19 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_i2f16,
      -1, 0,
      { 2260 },
      -1,
   } },

   /* replace761_0 -> 19 in the cache */
   /* replace761 -> 2257 in the cache */

   /* ('u2f16', ('u2u64', 'a@8')) => ('u2f16', 'a') */
   /* search762_0_0 -> 19 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_u2u64,
      -1, 0,
      { 19 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_u2f16,
      -1, 0,
      { 2262 },
      -1,
   } },

   /* replace762_0 -> 19 in the cache */
   /* replace762 -> 2255 in the cache */

   /* ('i2f16', ('i2i64', 'a@8')) => ('i2f16', 'a') */
   /* search763_0_0 -> 19 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_i2i64,
      -1, 0,
      { 19 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_i2f16,
      -1, 0,
      { 2264 },
      -1,
   } },

   /* replace763_0 -> 19 in the cache */
   /* replace763 -> 2257 in the cache */

   /* ('i2i8', ('i2i32', 'a@8')) => a */
   /* search764_0_0 -> 19 in the cache */
   /* search764_0 -> 2260 in the cache */
   { .expression = {
      { nir_search_value_expression, 8 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_i2i8,
      -1, 0,
      { 2260 },
      -1,
   } },

   /* replace764 -> 19 in the cache */

   /* ('u2u8', ('u2u32', 'a@8')) => a */
   /* search765_0_0 -> 19 in the cache */
   /* search765_0 -> 2258 in the cache */
   { .expression = {
      { nir_search_value_expression, 8 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_u2u8,
      -1, 0,
      { 2258 },
      -1,
   } },

   /* replace765 -> 19 in the cache */

   /* ('u2f32', ('u2u16', 'a@8')) => ('u2f32', 'a') */
   /* search766_0_0 -> 19 in the cache */
   /* search766_0 -> 2252 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_u2f32,
      -1, 0,
      { 2252 },
      -1,
   } },

   /* replace766_0 -> 19 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_u2f32,
      -1, 0,
      { 19 },
      -1,
   } },

   /* ('i2f32', ('i2i16', 'a@8')) => ('i2f32', 'a') */
   /* search767_0_0 -> 19 in the cache */
   /* search767_0 -> 2250 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_i2f32,
      -1, 0,
      { 2250 },
      -1,
   } },

   /* replace767_0 -> 19 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_i2f32,
      -1, 0,
      { 19 },
      -1,
   } },

   /* ('u2f32', ('u2u32', 'a@8')) => ('u2f32', 'a') */
   /* search768_0_0 -> 19 in the cache */
   /* search768_0 -> 2258 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_u2f32,
      -1, 0,
      { 2258 },
      -1,
   } },

   /* replace768_0 -> 19 in the cache */
   /* replace768 -> 2269 in the cache */

   /* ('i2f32', ('i2i32', 'a@8')) => ('i2f32', 'a') */
   /* search769_0_0 -> 19 in the cache */
   /* search769_0 -> 2260 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_i2f32,
      -1, 0,
      { 2260 },
      -1,
   } },

   /* replace769_0 -> 19 in the cache */
   /* replace769 -> 2271 in the cache */

   /* ('u2f32', ('u2u64', 'a@8')) => ('u2f32', 'a') */
   /* search770_0_0 -> 19 in the cache */
   /* search770_0 -> 2262 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_u2f32,
      -1, 0,
      { 2262 },
      -1,
   } },

   /* replace770_0 -> 19 in the cache */
   /* replace770 -> 2269 in the cache */

   /* ('i2f32', ('i2i64', 'a@8')) => ('i2f32', 'a') */
   /* search771_0_0 -> 19 in the cache */
   /* search771_0 -> 2264 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_i2f32,
      -1, 0,
      { 2264 },
      -1,
   } },

   /* replace771_0 -> 19 in the cache */
   /* replace771 -> 2271 in the cache */

   /* ('i2i8', ('i2i64', 'a@8')) => a */
   /* search772_0_0 -> 19 in the cache */
   /* search772_0 -> 2264 in the cache */
   { .expression = {
      { nir_search_value_expression, 8 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_i2i8,
      -1, 0,
      { 2264 },
      -1,
   } },

   /* replace772 -> 19 in the cache */

   /* ('u2u8', ('u2u64', 'a@8')) => a */
   /* search773_0_0 -> 19 in the cache */
   /* search773_0 -> 2262 in the cache */
   { .expression = {
      { nir_search_value_expression, 8 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_u2u8,
      -1, 0,
      { 2262 },
      -1,
   } },

   /* replace773 -> 19 in the cache */

   /* ('u2f64', ('u2u16', 'a@8')) => ('u2f64', 'a') */
   /* search774_0_0 -> 19 in the cache */
   /* search774_0 -> 2252 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_u2f64,
      -1, 0,
      { 2252 },
      -1,
   } },

   /* replace774_0 -> 19 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_u2f64,
      -1, 0,
      { 19 },
      -1,
   } },

   /* ('i2f64', ('i2i16', 'a@8')) => ('i2f64', 'a') */
   /* search775_0_0 -> 19 in the cache */
   /* search775_0 -> 2250 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_i2f64,
      -1, 0,
      { 2250 },
      -1,
   } },

   /* replace775_0 -> 19 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_i2f64,
      -1, 0,
      { 19 },
      -1,
   } },

   /* ('u2f64', ('u2u32', 'a@8')) => ('u2f64', 'a') */
   /* search776_0_0 -> 19 in the cache */
   /* search776_0 -> 2258 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_u2f64,
      -1, 0,
      { 2258 },
      -1,
   } },

   /* replace776_0 -> 19 in the cache */
   /* replace776 -> 2279 in the cache */

   /* ('i2f64', ('i2i32', 'a@8')) => ('i2f64', 'a') */
   /* search777_0_0 -> 19 in the cache */
   /* search777_0 -> 2260 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_i2f64,
      -1, 0,
      { 2260 },
      -1,
   } },

   /* replace777_0 -> 19 in the cache */
   /* replace777 -> 2281 in the cache */

   /* ('u2f64', ('u2u64', 'a@8')) => ('u2f64', 'a') */
   /* search778_0_0 -> 19 in the cache */
   /* search778_0 -> 2262 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_u2f64,
      -1, 0,
      { 2262 },
      -1,
   } },

   /* replace778_0 -> 19 in the cache */
   /* replace778 -> 2279 in the cache */

   /* ('i2f64', ('i2i64', 'a@8')) => ('i2f64', 'a') */
   /* search779_0_0 -> 19 in the cache */
   /* search779_0 -> 2264 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_i2f64,
      -1, 0,
      { 2264 },
      -1,
   } },

   /* replace779_0 -> 19 in the cache */
   /* replace779 -> 2281 in the cache */

   /* ('i2i16', ('i2i32', 'a@16')) => a */
   /* search780_0_0 -> 24 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_i2i32,
      -1, 0,
      { 24 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_i2i16,
      -1, 0,
      { 2286 },
      -1,
   } },

   /* replace780 -> 24 in the cache */

   /* ('u2u16', ('u2u32', 'a@16')) => a */
   /* search781_0_0 -> 24 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_u2u32,
      -1, 0,
      { 24 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_u2u16,
      -1, 0,
      { 2288 },
      -1,
   } },

   /* replace781 -> 24 in the cache */

   /* ('u2f32', ('u2u32', 'a@16')) => ('u2f32', 'a') */
   /* search782_0_0 -> 24 in the cache */
   /* search782_0 -> 2288 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_u2f32,
      -1, 0,
      { 2288 },
      -1,
   } },

   /* replace782_0 -> 24 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_u2f32,
      -1, 0,
      { 24 },
      -1,
   } },

   /* ('i2f32', ('i2i32', 'a@16')) => ('i2f32', 'a') */
   /* search783_0_0 -> 24 in the cache */
   /* search783_0 -> 2286 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_i2f32,
      -1, 0,
      { 2286 },
      -1,
   } },

   /* replace783_0 -> 24 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_i2f32,
      -1, 0,
      { 24 },
      -1,
   } },

   /* ('u2f32', ('u2u64', 'a@16')) => ('u2f32', 'a') */
   /* search784_0_0 -> 24 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_u2u64,
      -1, 0,
      { 24 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_u2f32,
      -1, 0,
      { 2294 },
      -1,
   } },

   /* replace784_0 -> 24 in the cache */
   /* replace784 -> 2291 in the cache */

   /* ('i2f32', ('i2i64', 'a@16')) => ('i2f32', 'a') */
   /* search785_0_0 -> 24 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_i2i64,
      -1, 0,
      { 24 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_i2f32,
      -1, 0,
      { 2296 },
      -1,
   } },

   /* replace785_0 -> 24 in the cache */
   /* replace785 -> 2293 in the cache */

   /* ('i2i16', ('i2i64', 'a@16')) => a */
   /* search786_0_0 -> 24 in the cache */
   /* search786_0 -> 2296 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_i2i16,
      -1, 0,
      { 2296 },
      -1,
   } },

   /* replace786 -> 24 in the cache */

   /* ('u2u16', ('u2u64', 'a@16')) => a */
   /* search787_0_0 -> 24 in the cache */
   /* search787_0 -> 2294 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_u2u16,
      -1, 0,
      { 2294 },
      -1,
   } },

   /* replace787 -> 24 in the cache */

   /* ('u2f64', ('u2u32', 'a@16')) => ('u2f64', 'a') */
   /* search788_0_0 -> 24 in the cache */
   /* search788_0 -> 2288 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_u2f64,
      -1, 0,
      { 2288 },
      -1,
   } },

   /* replace788_0 -> 24 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_u2f64,
      -1, 0,
      { 24 },
      -1,
   } },

   /* ('i2f64', ('i2i32', 'a@16')) => ('i2f64', 'a') */
   /* search789_0_0 -> 24 in the cache */
   /* search789_0 -> 2286 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_i2f64,
      -1, 0,
      { 2286 },
      -1,
   } },

   /* replace789_0 -> 24 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_i2f64,
      -1, 0,
      { 24 },
      -1,
   } },

   /* ('u2f64', ('u2u64', 'a@16')) => ('u2f64', 'a') */
   /* search790_0_0 -> 24 in the cache */
   /* search790_0 -> 2294 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_u2f64,
      -1, 0,
      { 2294 },
      -1,
   } },

   /* replace790_0 -> 24 in the cache */
   /* replace790 -> 2301 in the cache */

   /* ('i2f64', ('i2i64', 'a@16')) => ('i2f64', 'a') */
   /* search791_0_0 -> 24 in the cache */
   /* search791_0 -> 2296 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_i2f64,
      -1, 0,
      { 2296 },
      -1,
   } },

   /* replace791_0 -> 24 in the cache */
   /* replace791 -> 2303 in the cache */

   /* ('i2i32', ('i2i64', 'a@32')) => a */
   /* search792_0_0 -> 29 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_i2i64,
      -1, 0,
      { 29 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_i2i32,
      -1, 0,
      { 2306 },
      -1,
   } },

   /* replace792 -> 29 in the cache */

   /* ('u2u32', ('u2u64', 'a@32')) => a */
   /* search793_0_0 -> 29 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_u2u64,
      -1, 0,
      { 29 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_u2u32,
      -1, 0,
      { 2308 },
      -1,
   } },

   /* replace793 -> 29 in the cache */

   /* ('u2f64', ('u2u64', 'a@32')) => ('u2f64', 'a') */
   /* search794_0_0 -> 29 in the cache */
   /* search794_0 -> 2308 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_u2f64,
      -1, 0,
      { 2308 },
      -1,
   } },

   /* replace794_0 -> 29 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_u2f64,
      -1, 0,
      { 29 },
      -1,
   } },

   /* ('i2f64', ('i2i64', 'a@32')) => ('i2f64', 'a') */
   /* search795_0_0 -> 29 in the cache */
   /* search795_0 -> 2306 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_i2f64,
      -1, 0,
      { 2306 },
      -1,
   } },

   /* replace795_0 -> 29 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_i2f64,
      -1, 0,
      { 29 },
      -1,
   } },

   /* ('f2fmp', ('u2f32', 'a@32')) => ('u2fmp', 'a') */
   /* search796_0_0 -> 29 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_u2f32,
      -1, 0,
      { 29 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_f2fmp,
      -1, 0,
      { 2314 },
      -1,
   } },

   /* replace796_0 -> 29 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_u2fmp,
      -1, 0,
      { 29 },
      -1,
   } },

   /* ('f2fmp', ('i2f32', 'a@32')) => ('i2fmp', 'a') */
   /* search797_0_0 -> 29 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_i2f32,
      -1, 0,
      { 29 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_f2fmp,
      -1, 0,
      { 2317 },
      -1,
   } },

   /* replace797_0 -> 29 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_i2fmp,
      -1, 0,
      { 29 },
      -1,
   } },

   /* ('f2u16', ('f2fmp', 'a@32')) => ('f2u16', 'a') */
   /* search798_0_0 -> 29 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_f2fmp,
      -1, 0,
      { 29 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_f2u16,
      -1, 0,
      { 2320 },
      -1,
   } },

   /* replace798_0 -> 29 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_f2u16,
      -1, 0,
      { 29 },
      -1,
   } },

   /* ('f2i16', ('f2fmp', 'a@32')) => ('f2i16', 'a') */
   /* search799_0_0 -> 29 in the cache */
   /* search799_0 -> 2320 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_f2i16,
      -1, 0,
      { 2320 },
      -1,
   } },

   /* replace799_0 -> 29 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_f2i16,
      -1, 0,
      { 29 },
      -1,
   } },

   /* ('i2imp', ('f2u32', 'a@32')) => ('f2ump', 'a') */
   /* search800_0_0 -> 29 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_f2u32,
      -1, 0,
      { 29 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_i2imp,
      -1, 0,
      { 2325 },
      -1,
   } },

   /* replace800_0 -> 29 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_f2ump,
      -1, 0,
      { 29 },
      -1,
   } },

   /* ('i2imp', ('f2i32', 'a@32')) => ('f2imp', 'a') */
   /* search801_0_0 -> 29 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_f2i32,
      -1, 0,
      { 29 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_i2imp,
      -1, 0,
      { 2328 },
      -1,
   } },

   /* replace801_0 -> 29 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_f2imp,
      -1, 0,
      { 29 },
      -1,
   } },

   /* ('u2f16', ('i2imp', 'a@32')) => ('u2f16', 'a') */
   /* search802_0_0 -> 29 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_i2imp,
      -1, 0,
      { 29 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_u2f16,
      -1, 0,
      { 2331 },
      -1,
   } },

   /* replace802_0 -> 29 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_u2f16,
      -1, 0,
      { 29 },
      -1,
   } },

   /* ('i2f16', ('i2imp', 'a@32')) => ('i2f16', 'a') */
   /* search803_0_0 -> 29 in the cache */
   /* search803_0 -> 2331 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_i2f16,
      -1, 0,
      { 2331 },
      -1,
   } },

   /* replace803_0 -> 29 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_i2f16,
      -1, 0,
      { 29 },
      -1,
   } },

   /* ('iand', ('u2u16', ('u2u8', 'a@16')), '#b') => ('iand', 'a', ('iand', 'b', 255)) */
   /* search804_0_0_0 -> 24 in the cache */
   { .expression = {
      { nir_search_value_expression, 8 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_u2u8,
      -1, 0,
      { 24 },
      -1,
   } },
   { .expression = {
      { nir_search_value_e