
#include "nir.h"
#include "nir_builder.h"
#include "nir_search.h"
#include "nir_search_helpers.h"

/* What follows is NIR algebraic transform code for the following 2463
 * transforms:
 *    ('fgeu', 'a', 'b') => ('inot', ('flt', 'a', 'b'))
 *    ('fltu', 'a', 'b') => ('inot', ('fge', 'a', 'b'))
 *    ('fneo', 0.0, 'a') => ('flt', 0.0, ('fabs', 'a'))
 *    ('fequ', 0.0, 'a') => ('inot', ('flt', 0.0, ('fabs', 'a')))
 *    ('imul', 'a', '#b(is_pos_power_of_two)') => ('ishl', 'a', ('find_lsb', 'b'))
 *    ('imul', 'a@8', 128) => ('ishl', 'a', 7)
 *    ('imul', 'a@16', 32768) => ('ishl', 'a', 15)
 *    ('imul', 'a@32', 2147483648) => ('ishl', 'a', 31)
 *    ('imul', 'a@64', 9223372036854775808) => ('ishl', 'a', 63)
 *    ('imul', 'a', '#b(is_neg_power_of_two)') => ('ineg', ('ishl', 'a', ('find_lsb', ('iabs', 'b'))))
 *    ('ishl', 'a', '#b') => ('imul', 'a', ('ishl', 1, 'b'))
 *    ('imul@64', 'a', '#b(is_bitcount2)') => ('iadd', ('ishl', 'a', ('ufind_msb', 'b')), ('ishl', 'a', ('find_lsb', 'b')))
 *    ('unpack_64_2x32_split_x', ('imul_2x32_64(is_used_once)', 'a', 'b')) => ('imul', 'a', 'b')
 *    ('unpack_64_2x32_split_x', ('umul_2x32_64(is_used_once)', 'a', 'b')) => ('imul', 'a', 'b')
 *    ('imul_2x32_64', 'a', 'b') => ('pack_64_2x32_split', ('imul', 'a', 'b'), ('imul_high', 'a', 'b'))
 *    ('umul_2x32_64', 'a', 'b') => ('pack_64_2x32_split', ('imul', 'a', 'b'), ('umul_high', 'a', 'b'))
 *    ('udiv', 'a', 1) => a
 *    ('idiv', 'a', 1) => a
 *    ('umod', 'a', 1) => 0
 *    ('imod', 'a', 1) => 0
 *    ('imod', 'a', -1) => 0
 *    ('irem', 'a', 1) => 0
 *    ('irem', 'a', -1) => 0
 *    ('udiv', 'a', '#b(is_pos_power_of_two)') => ('ushr', 'a', ('find_lsb', 'b'))
 *    ('idiv', 'a', '#b(is_pos_power_of_two)') => ('imul', ('isign', 'a'), ('ushr', ('iabs', 'a'), ('find_lsb', 'b')))
 *    ('idiv', 'a', '#b(is_neg_power_of_two)') => ('ineg', ('imul', ('isign', 'a'), ('ushr', ('iabs', 'a'), ('find_lsb', ('iabs', 'b')))))
 *    ('umod', 'a', '#b(is_pos_power_of_two)') => ('iand', 'a', ('isub', 'b', 1))
 *    ('imod', 'a', '#b(is_pos_power_of_two)') => ('iand', 'a', ('isub', 'b', 1))
 *    ('imod', 'a', '#b(is_neg_power_of_two)') => ('bcsel', ('ieq', ('ior', 'a', 'b'), 'b'), 0, ('ior', 'a', 'b'))
 *    ('irem', 'a', '#b(is_pos_power_of_two)') => ('isub', 'a', ('iand', ('bcsel', ('ilt', 'a', 0), ('iadd', 'a', ('isub', 'b', 1)), 'a'), ('ineg', 'b')))
 *    ('irem', 'a', '#b(is_neg_power_of_two)') => ('irem', 'a', ('iabs', 'b'))
 *    ('~fmul', ('fsign', 'a'), ('ffloor', ('fadd', ('fabs', 'a'), 0.5))) => ('ftrunc', ('fadd', 'a', ('fmul', ('fsign', 'a'), 0.5)))
 *    ('~fneg', ('fneg', 'a')) => a
 *    ('ineg', ('ineg', 'a')) => a
 *    ('fabs', ('fneg', 'a')) => ('fabs', 'a')
 *    ('fabs', ('u2f', 'a')) => ('u2f', 'a')
 *    ('iabs', ('iabs', 'a')) => ('iabs', 'a')
 *    ('iabs', ('ineg', 'a')) => ('iabs', 'a')
 *    ('~fadd', 'a', 0.0) => a
 *    ('fadd(is_only_used_as_float,nsz)', 'a', 0.0) => a
 *    ('fadd(is_only_used_as_float)', 'a', '#b(is_negative_zero)') => a
 *    ('fadd', ('fneg', 'a'), '#b(is_negative_zero)') => ('fneg', 'a')
 *    ('iadd', 'a', 0) => a
 *    ('iadd_sat', 'a', 0) => a
 *    ('isub_sat', 'a', 0) => a
 *    ('uadd_sat', 'a', 0) => a
 *    ('usub_sat', 'a', 0) => a
 *    ('usadd_4x8_vc4', 'a', 0) => a
 *    ('usadd_4x8_vc4', 'a', -1) => -1
 *    ('~fadd', ('fmul', 'a', 'b'), ('fmul', 'a', 'c')) => ('fmul', 'a', ('fadd', 'b', 'c'))
 *    ('~fadd', ('fmulz', 'a', 'b'), ('fmulz', 'a', 'c')) => ('fmulz', 'a', ('fadd', 'b', 'c'))
 *    ('~ffma', 'a', 'b', ('ffma(is_used_once)', 'a', 'c', 'd')) => ('ffma', 'a', ('fadd', 'b', 'c'), 'd')
 *    ('~ffma', 'a', 'b', ('fmul(is_used_once)', 'a', 'c')) => ('fmul', 'a', ('fadd', 'b', 'c'))
 *    ('~fadd', ('fmul(is_used_once)', 'a', 'b'), ('ffma(is_used_once)', 'a', 'c', 'd')) => ('ffma', 'a', ('fadd', 'b', 'c'), 'd')
 *    ('~ffma', 'a', ('fmul(is_used_once)', 'b', 'c'), ('fmul(is_used_once)', 'b', 'd')) => ('fmul', 'b', ('ffma', 'a', 'c', 'd'))
 *    ('~ffmaz', 'a', 'b', ('ffmaz(is_used_once)', 'a', 'c', 'd')) => ('ffmaz', 'a', ('fadd', 'b', 'c'), 'd')
 *    ('~ffmaz', 'a', 'b', ('fmulz(is_used_once)', 'a', 'c')) => ('fmulz', 'a', ('fadd', 'b', 'c'))
 *    ('~fadd', ('fmulz(is_used_once)', 'a', 'b'), ('ffmaz(is_used_once)', 'a', 'c', 'd')) => ('ffmaz', 'a', ('fadd', 'b', 'c'), 'd')
 *    ('~ffmaz', 'a', ('fmulz(is_used_once)', 'b', 'c'), ('fmulz(is_used_once)', 'b', 'd')) => ('fmulz', 'b', ('ffmaz', 'a', 'c', 'd'))
 *    ('iadd', ('imul', 'a', 'b'), ('imul', 'a', 'c')) => ('imul', 'a', ('iadd', 'b', 'c'))
 *    ('iadd', ('ishl', 'b', 'a'), ('ishl', 'c', 'a')) => ('ishl', ('iadd', 'b', 'c'), 'a')
 *    ('iand', ('iand', 'a', 'b'), ('iand(is_used_once)', 'a', 'c')) => ('iand', ('iand', 'a', 'b'), 'c')
 *    ('ior', ('ior', 'a', 'b'), ('ior(is_used_once)', 'a', 'c')) => ('ior', ('ior', 'a', 'b'), 'c')
 *    ('iand', ('ior(is_used_once)', 'a', 'b'), ('ior(is_used_once)', 'a', 'c')) => ('ior', 'a', ('iand', 'b', 'c'))
 *    ('ior', ('iand(is_used_once)', 'a', 'b'), ('iand(is_used_once)', 'a', 'c')) => ('iand', 'a', ('ior', 'b', 'c'))
 *    ('ior', ('iand', 'a', 'b'), ('ior', 'a', 'c')) => ('ior', 'a', 'c')
 *    ('iand', ('iand', 'a', 'b'), ('ior', 'a', 'c')) => ('iand', 'a', 'b')
 *    ('ieq', ('iand', 'a', '#b(is_pos_power_of_two)'), 'b') => ('ine', ('iand', 'a', 'b'), 0)
 *    ('ine', ('iand', 'a', '#b(is_pos_power_of_two)'), 'b') => ('ieq', ('iand', 'a', 'b'), 0)
 *    ('ieq', ('ushr(is_used_once)', 'a', '#b'), 0) => ('ult', 'a', ('ishl', 1, 'b'))
 *    ('ine', ('ushr(is_used_once)', 'a', '#b'), 0) => ('uge', 'a', ('ishl', 1, 'b'))
 *    ('~fadd', ('fneg', 'a'), 'a') => 0.0
 *    ('iadd', ('ineg', 'a'), 'a') => 0
 *    ('iadd', ('ineg', 'a'), ('iadd', 'a', 'b')) => b
 *    ('iadd', 'a', ('iadd', ('ineg', 'a'), 'b')) => b
 *    ('~fadd', ('fneg', 'a'), ('fadd', 'a', 'b')) => b
 *    ('~fadd', 'a', ('fadd', ('fneg', 'a'), 'b')) => b
 *    ('fadd', ('fsat', 'a'), ('fsat', ('fneg', 'a'))) => ('fsat', ('fabs', 'a'))
 *    ('~fmul', 'a', 0.0) => 0.0
 *    ('fmul(nsz,nnan)', 'a', 0.0) => 0.0
 *    ('fmulz', 'a', 0.0) => 0.0
 *    ('fmulz(nsz)', 'a', 'b(is_finite_not_zero)') => ('fmul', 'a', 'b')
 *    ('fmulz', 'a(is_finite)', 'b(is_finite)') => ('fmul', 'a', 'b')
 *    ('fmulz', 'a', 'a') => ('fmul', 'a', 'a')
 *    ('ffmaz(nsz)', 'a', 'b(is_finite_not_zero)', 'c') => ('ffma', 'a', 'b', 'c')
 *    ('ffmaz', 'a(is_finite)', 'b(is_finite)', 'c') => ('ffma', 'a', 'b', 'c')
 *    ('ffmaz', 'a', 'a', 'b') => ('ffma', 'a', 'a', 'b')
 *    ('imul', 'a', 0) => 0
 *    ('umul_unorm_4x8_vc4', 'a', 0) => 0
 *    ('umul_unorm_4x8_vc4', 'a', -1) => a
 *    ('~fmul', 'a', 1.0) => a
 *    ('~fmulz', 'a', 1.0) => a
 *    ('fmul(is_only_used_as_float)', 'a', 1.0) => a
 *    ('imul', 'a', 1) => a
 *    ('fmul', 'a', -1.0) => ('fneg', 'a')
 *    ('imul', 'a', -1) => ('ineg', 'a')
 *    ('fmul', ('fsign', 'a'), ('fmul', 'a', 'a')) => ('fmul', ('fabs', 'a'), 'a')
 *    ('fmul', ('fmul', ('fsign', 'a'), 'a'), 'a') => ('fmul', ('fabs', 'a'), 'a')
 *    ('~ffma', 0.0, 'a', 'b') => b
 *    ('ffma(is_only_used_as_float,nsz,nnan,ninf)', 0.0, 'a', 'b') => b
 *    ('ffmaz', 0.0, 'a', 'b') => ('fadd', 0.0, 'b')
 *    ('~ffma', 'a', 'b', 0.0) => ('fmul', 'a', 'b')
 *    ('ffma(nsz)', 'a', 'b', 0.0) => ('fmul', 'a', 'b')
 *    ('ffmaz(nsz)', 'a', 'b', 0.0) => ('fmulz', 'a', 'b')
 *    ('ffma', 1.0, 'a', 'b') => ('fadd', 'a', 'b')
 *    ('ffmaz(nsz)', 1.0, 'a', 'b') => ('fadd', 'a', 'b')
 *    ('ffma', -1.0, 'a', 'b') => ('fadd', ('fneg', 'a'), 'b')
 *    ('ffmaz(nsz)', -1.0, 'a', 'b') => ('fadd', ('fneg', 'a'), 'b')
 *    ('~ffma', '#a', '#b', 'c') => ('fadd', ('fmul', 'a', 'b'), 'c')
 *    ('~ffmaz', '#a', '#b', 'c') => ('fadd', ('fmulz', 'a', 'b'), 'c')
 *    ('~flrp', 'a', 'b', 0.0) => a
 *    ('~flrp', 'a', 'b', 1.0) => b
 *    ('~flrp', 'a', 'a', 'b') => a
 *    ('~flrp', 0.0, 'a', 'b') => ('fmul', 'a', 'b')
 *    ('~flrp', 'a', ('fadd(is_used_once)', 'a', 'b'), 'c') => ('fadd', ('fmul', 'b', 'c'), 'a')
 *    ('sdot_4x8_iadd', 'a', 0, 'b') => b
 *    ('udot_4x8_uadd', 'a', 0, 'b') => b
 *    ('sdot_4x8_iadd_sat', 'a', 0, 'b') => b
 *    ('udot_4x8_uadd_sat', 'a', 0, 'b') => b
 *    ('sdot_2x16_iadd', 'a', 0, 'b') => b
 *    ('udot_2x16_uadd', 'a', 0, 'b') => b
 *    ('sdot_2x16_iadd_sat', 'a', 0, 'b') => b
 *    ('udot_2x16_uadd_sat', 'a', 0, 'b') => b
 *    ('sudot_4x8_iadd', 'a', 0, 'b') => b
 *    ('sudot_4x8_iadd', 0, 'a', 'b') => b
 *    ('sudot_4x8_iadd_sat', 'a', 0, 'b') => b
 *    ('sudot_4x8_iadd_sat', 0, 'a', 'b') => b
 *    ('iadd', ('sdot_4x8_iadd(is_used_once)', 'a', 'b', '#c'), '#d') => ('sdot_4x8_iadd', 'a', 'b', ('iadd', 'c', 'd'))
 *    ('iadd', ('udot_4x8_uadd(is_used_once)', 'a', 'b', '#c'), '#d') => ('udot_4x8_uadd', 'a', 'b', ('iadd', 'c', 'd'))
 *    ('iadd', ('sudot_4x8_iadd(is_used_once)', 'a', 'b', '#c'), '#d') => ('sudot_4x8_iadd', 'a', 'b', ('iadd', 'c', 'd'))
 *    ('iadd', ('sdot_2x16_iadd(is_used_once)', 'a', 'b', '#c'), '#d') => ('sdot_2x16_iadd', 'a', 'b', ('iadd', 'c', 'd'))
 *    ('iadd', ('udot_2x16_uadd(is_used_once)', 'a', 'b', '#c'), '#d') => ('udot_2x16_uadd', 'a', 'b', ('iadd', 'c', 'd'))
 *    ('iadd', ('sdot_4x8_iadd', 'a(is_not_const)', 'b', 0), 'c') => ('sdot_4x8_iadd', 'a', 'b', 'c')
 *    ('iadd', ('udot_4x8_uadd', 'a(is_not_const)', 'b', 0), 'c') => ('udot_4x8_uadd', 'a', 'b', 'c')
 *    ('iadd', ('sudot_4x8_iadd', 'a(is_not_const)', 'b', 0), 'c') => ('sudot_4x8_iadd', 'a', 'b', 'c')
 *    ('iadd', ('sudot_4x8_iadd', 'a', 'b(is_not_const)', 0), 'c') => ('sudot_4x8_iadd', 'a', 'b', 'c')
 *    ('iadd', ('sdot_2x16_iadd', 'a(is_not_const)', 'b', 0), 'c') => ('sdot_2x16_iadd', 'a', 'b', 'c')
 *    ('iadd', ('udot_2x16_uadd', 'a(is_not_const)', 'b', 0), 'c') => ('udot_2x16_uadd', 'a', 'b', 'c')
 *    ('sdot_4x8_iadd', '#a', '#b', 'c(is_not_const)') => ('iadd', ('sdot_4x8_iadd', 'a', 'b', 0), 'c')
 *    ('udot_4x8_uadd', '#a', '#b', 'c(is_not_const)') => ('iadd', ('udot_4x8_uadd', 'a', 'b', 0), 'c')
 *    ('sudot_4x8_iadd', '#a', '#b', 'c(is_not_const)') => ('iadd', ('sudot_4x8_iadd', 'a', 'b', 0), 'c')
 *    ('sdot_2x16_iadd', '#a', '#b', 'c(is_not_const)') => ('iadd', ('sdot_2x16_iadd', 'a', 'b', 0), 'c')
 *    ('udot_2x16_uadd', '#a', '#b', 'c(is_not_const)') => ('iadd', ('udot_2x16_uadd', 'a', 'b', 0), 'c')
 *    ('sdot_4x8_iadd_sat', '#a', '#b', 'c(is_not_const)') => ('iadd_sat', ('sdot_4x8_iadd', 'a', 'b', 0), 'c')
 *    ('udot_4x8_uadd_sat', '#a', '#b', 'c(is_not_const)') => ('uadd_sat', ('udot_4x8_uadd', 'a', 'b', 0), 'c')
 *    ('sudot_4x8_iadd_sat', '#a', '#b', 'c(is_not_const)') => ('iadd_sat', ('sudot_4x8_iadd', 'a', 'b', 0), 'c')
 *    ('sdot_2x16_iadd_sat', '#a', '#b', 'c(is_not_const)') => ('iadd_sat', ('sdot_2x16_iadd', 'a', 'b', 0), 'c')
 *    ('udot_2x16_uadd_sat', '#a', '#b', 'c(is_not_const)') => ('uadd_sat', ('udot_2x16_uadd', 'a', 'b', 0), 'c')
 *    ('fmul@32(nsz)', ('bcsel', ('feq', 'b', 0.0, 'ignore_exact'), 0.0, ('fneg', ('fabs', 'a'))), ('bcsel', ('feq', 'a', 0.0, 'ignore_exact'), 0.0, ('fneg', ('fabs', 'b')))) => ('fmulz', ('fneg', ('fabs', 'a')), ('fneg', ('fabs', 'b')))
 *    ('fmul@32(nsz)', ('bcsel', ('feq', 'b', 0.0, 'ignore_exact'), 0.0, ('fneg', ('fabs', 'a'))), ('bcsel', ('feq', 'a', 0.0, 'ignore_exact'), 0.0, ('fabs', 'b'))) => ('fmulz', ('fneg', ('fabs', 'a')), ('fabs', 'b'))
 *    ('fmul@32(nsz)', ('bcsel', ('feq', 'b', 0.0, 'ignore_exact'), 0.0, ('fneg', ('fabs', 'a'))), ('bcsel', ('feq', 'a', 0.0, 'ignore_exact'), 0.0, ('fneg', 'b'))) => ('fmulz', ('fneg', ('fabs', 'a')), ('fneg', 'b'))
 *    ('fmul@32(nsz)', ('bcsel', ('feq', 'b', 0.0, 'ignore_exact'), 0.0, ('fneg', ('fabs', 'a'))), ('bcsel', ('feq', 'a', 0.0, 'ignore_exact'), 0.0, 'b')) => ('fmulz', ('fneg', ('fabs', 'a')), 'b')
 *    ('fmul@32(nsz)', ('bcsel', ('feq', 'b', 0.0, 'ignore_exact'), 0.0, ('fabs', 'a')), ('bcsel', ('feq', 'a', 0.0, 'ignore_exact'), 0.0, ('fabs', 'b'))) => ('fmulz', ('fabs', 'a'), ('fabs', 'b'))
 *    ('fmul@32(nsz)', ('bcsel', ('feq', 'b', 0.0, 'ignore_exact'), 0.0, ('fabs', 'a')), ('bcsel', ('feq', 'a', 0.0, 'ignore_exact'), 0.0, ('fneg', 'b'))) => ('fmulz', ('fabs', 'a'), ('fneg', 'b'))
 *    ('fmul@32(nsz)', ('bcsel', ('feq', 'b', 0.0, 'ignore_exact'), 0.0, ('fabs', 'a')), ('bcsel', ('feq', 'a', 0.0, 'ignore_exact'), 0.0, 'b')) => ('fmulz', ('fabs', 'a'), 'b')
 *    ('fmul@32(nsz)', ('bcsel', ('feq', 'b', 0.0, 'ignore_exact'), 0.0, ('fneg', 'a')), ('bcsel', ('feq', 'a', 0.0, 'ignore_exact'), 0.0, ('fneg', 'b'))) => ('fmulz', ('fneg', 'a'), ('fneg', 'b'))
 *    ('fmul@32(nsz)', ('bcsel', ('feq', 'b', 0.0, 'ignore_exact'), 0.0, ('fneg', 'a')), ('bcsel', ('feq', 'a', 0.0, 'ignore_exact'), 0.0, 'b')) => ('fmulz', ('fneg', 'a'), 'b')
 *    ('fmul@32(nsz)', ('bcsel', ('feq', 'b', 0.0, 'ignore_exact'), 0.0, 'a'), ('bcsel', ('feq', 'a', 0.0, 'ignore_exact'), 0.0, 'b')) => ('fmulz', 'a', 'b')
 *    ('fmul@32(nsz)', ('fneg', ('fabs', 'a')), ('bcsel', ('feq', 'a', 0.0, 'ignore_exact'), 0.0, '#b(is_not_const_zero)')) => ('fmulz', ('fneg', ('fabs', 'a')), 'b')
 *    ('fmul@32(nsz)', ('fabs', 'a'), ('bcsel', ('feq', 'a', 0.0, 'ignore_exact'), 0.0, '#b(is_not_const_zero)')) => ('fmulz', ('fabs', 'a'), 'b')
 *    ('fmul@32(nsz)', ('fneg', 'a'), ('bcsel', ('feq', 'a', 0.0, 'ignore_exact'), 0.0, '#b(is_not_const_zero)')) => ('fmulz', ('fneg', 'a'), 'b')
 *    ('fmul@32(nsz)', 'a', ('bcsel', ('feq', 'a', 0.0, 'ignore_exact'), 0.0, '#b(is_not_const_zero)')) => ('fmulz', 'a', 'b')
 *    ('ffma@32(nsz)', ('bcsel', ('feq', 'b', 0.0, 'ignore_exact'), 0.0, ('fneg', ('fabs', 'a'))), ('bcsel', ('feq', 'a', 0.0, 'ignore_exact'), 0.0, ('fneg', ('fabs', 'b'))), 'c') => ('ffmaz', ('fneg', ('fabs', 'a')), ('fneg', ('fabs', 'b')), 'c')
 *    ('ffma@32(nsz)', ('bcsel', ('feq', 'b', 0.0, 'ignore_exact'), 0.0, ('fneg', ('fabs', 'a'))), ('bcsel', ('feq', 'a', 0.0, 'ignore_exact'), 0.0, ('fabs', 'b')), 'c') => ('ffmaz', ('fneg', ('fabs', 'a')), ('fabs', 'b'), 'c')
 *    ('ffma@32(nsz)', ('bcsel', ('feq', 'b', 0.0, 'ignore_exact'), 0.0, ('fneg', ('fabs', 'a'))), ('bcsel', ('feq', 'a', 0.0, 'ignore_exact'), 0.0, ('fneg', 'b')), 'c') => ('ffmaz', ('fneg', ('fabs', 'a')), ('fneg', 'b'), 'c')
 *    ('ffma@32(nsz)', ('bcsel', ('feq', 'b', 0.0, 'ignore_exact'), 0.0, ('fneg', ('fabs', 'a'))), ('bcsel', ('feq', 'a', 0.0, 'ignore_exact'), 0.0, 'b'), 'c') => ('ffmaz', ('fneg', ('fabs', 'a')), 'b', 'c')
 *    ('ffma@32(nsz)', ('bcsel', ('feq', 'b', 0.0, 'ignore_exact'), 0.0, ('fabs', 'a')), ('bcsel', ('feq', 'a', 0.0, 'ignore_exact'), 0.0, ('fabs', 'b')), 'c') => ('ffmaz', ('fabs', 'a'), ('fabs', 'b'), 'c')
 *    ('ffma@32(nsz)', ('bcsel', ('feq', 'b', 0.0, 'ignore_exact'), 0.0, ('fabs', 'a')), ('bcsel', ('feq', 'a', 0.0, 'ignore_exact'), 0.0, ('fneg', 'b')), 'c') => ('ffmaz', ('fabs', 'a'), ('fneg', 'b'), 'c')
 *    ('ffma@32(nsz)', ('bcsel', ('feq', 'b', 0.0, 'ignore_exact'), 0.0, ('fabs', 'a')), ('bcsel', ('feq', 'a', 0.0, 'ignore_exact'), 0.0, 'b'), 'c') => ('ffmaz', ('fabs', 'a'), 'b', 'c')
 *    ('ffma@32(nsz)', ('bcsel', ('feq', 'b', 0.0, 'ignore_exact'), 0.0, ('fneg', 'a')), ('bcsel', ('feq', 'a', 0.0, 'ignore_exact'), 0.0, ('fneg', 'b')), 'c') => ('ffmaz', ('fneg', 'a'), ('fneg', 'b'), 'c')
 *    ('ffma@32(nsz)', ('bcsel', ('feq', 'b', 0.0, 'ignore_exact'), 0.0, ('fneg', 'a')), ('bcsel', ('feq', 'a', 0.0, 'ignore_exact'), 0.0, 'b'), 'c') => ('ffmaz', ('fneg', 'a'), 'b', 'c')
 *    ('ffma@32(nsz)', ('bcsel', ('feq', 'b', 0.0, 'ignore_exact'), 0.0, 'a'), ('bcsel', ('feq', 'a', 0.0, 'ignore_exact'), 0.0, 'b'), 'c') => ('ffmaz', 'a', 'b', 'c')
 *    ('ffma@32(nsz)', ('fneg', ('fabs', 'a')), ('bcsel', ('feq', 'a', 0.0, 'ignore_exact'), 0.0, '#b(is_not_const_zero)'), 'c') => ('ffmaz', ('fneg', ('fabs', 'a')), 'b', 'c')
 *    ('ffma@32(nsz)', ('fabs', 'a'), ('bcsel', ('feq', 'a', 0.0, 'ignore_exact'), 0.0, '#b(is_not_const_zero)'), 'c') => ('ffmaz', ('fabs', 'a'), 'b', 'c')
 *    ('ffma@32(nsz)', ('fneg', 'a'), ('bcsel', ('feq', 'a', 0.0, 'ignore_exact'), 0.0, '#b(is_not_const_zero)'), 'c') => ('ffmaz', ('fneg', 'a'), 'b', 'c')
 *    ('ffma@32(nsz)', 'a', ('bcsel', ('feq', 'a', 0.0, 'ignore_exact'), 0.0, '#b(is_not_const_zero)'), 'c') => ('ffmaz', 'a', 'b', 'c')
 *    ('bcsel(nsz,nnan,ninf)', ('feq', 'b', 0.0, 'ignore_exact'), 1.0, ('fexp2', ('fmul@32', 'a', ('fneg', ('fabs', 'b'))))) => ('fexp2', ('fmulz', 'a', ('fneg', ('fabs', 'b'))))
 *    ('bcsel(nsz,nnan,ninf)', ('feq', 'b', 0.0, 'ignore_exact'), 1.0, ('fexp2', ('fmul@32', 'a', ('fabs', 'b')))) => ('fexp2', ('fmulz', 'a', ('fabs', 'b')))
 *    ('bcsel(nsz,nnan,ninf)', ('feq', 'b', 0.0, 'ignore_exact'), 1.0, ('fexp2', ('fmul@32', 'a', ('fneg', 'b')))) => ('fexp2', ('fmulz', 'a', ('fneg', 'b')))
 *    ('bcsel(nsz,nnan,ninf)', ('feq', 'b', 0.0, 'ignore_exact'), 1.0, ('fexp2', ('fmul@32', 'a', 'b'))) => ('fexp2', ('fmulz', 'a', 'b'))
 *    ('bcsel', ('feq', 'b', 0.0, 'ignore_exact'), 1.0, ('fexp2', ('fmulz', 'a', ('fneg', ('fabs', 'b'))))) => ('fexp2', ('fmulz', 'a', ('fneg', ('fabs', 'b'))))
 *    ('bcsel', ('feq', 'b', 0.0, 'ignore_exact'), 1.0, ('fexp2', ('fmulz', 'a', ('fabs', 'b')))) => ('fexp2', ('fmulz', 'a', ('fabs', 'b')))
 *    ('bcsel', ('feq', 'b', 0.0, 'ignore_exact'), 1.0, ('fexp2', ('fmulz', 'a', ('fneg', 'b')))) => ('fexp2', ('fmulz', 'a', ('fneg', 'b')))
 *    ('bcsel', ('feq', 'b', 0.0, 'ignore_exact'), 1.0, ('fexp2', ('fmulz', 'a', 'b'))) => ('fexp2', ('fmulz', 'a', 'b'))
 *    ('iand(is_only_used_as_float)', 'a@16', 32767) => ('fabs', 'a')
 *    ('ixor(is_only_used_as_float)', 'a@16', 32768) => ('fneg', 'a')
 *    ('ior(is_only_used_as_float)', 'a@16', 32768) => ('fneg', ('fabs', 'a'))
 *    ('iand(is_only_used_as_float)', 'a@32', 2147483647) => ('fabs', 'a')
 *    ('ixor(is_only_used_as_float)', 'a@32', 2147483648) => ('fneg', 'a')
 *    ('ior(is_only_used_as_float)', 'a@32', 2147483648) => ('fneg', ('fabs', 'a'))
 *    ('iand(is_only_used_as_float)', 'a@64', 9223372036854775807) => ('fabs', 'a')
 *    ('ixor(is_only_used_as_float)', 'a@64', 9223372036854775808) => ('fneg', 'a')
 *    ('ior(is_only_used_as_float)', 'a@64', 9223372036854775808) => ('fneg', ('fabs', 'a'))
 *    ('sdot_4x8_iadd', 'a', 'b', 'c') => ('iadd', ('iadd', ('iadd', ('imul', ('extract_i8', 'a', 0), ('extract_i8', 'b', 0)), ('imul', ('extract_i8', 'a', 1), ('extract_i8', 'b', 1))), ('iadd', ('imul', ('extract_i8', 'a', 2), ('extract_i8', 'b', 2)), ('imul', ('extract_i8', 'a', 3), ('extract_i8', 'b', 3)))), 'c')
 *    ('udot_4x8_uadd', 'a', 'b', 'c') => ('iadd', ('iadd', ('iadd', ('imul', ('extract_u8', 'a', 0), ('extract_u8', 'b', 0)), ('imul', ('extract_u8', 'a', 1), ('extract_u8', 'b', 1))), ('iadd', ('imul', ('extract_u8', 'a', 2), ('extract_u8', 'b', 2)), ('imul', ('extract_u8', 'a', 3), ('extract_u8', 'b', 3)))), 'c')
 *    ('sudot_4x8_iadd', 'a', 'b', 'c') => ('iadd', ('iadd', ('iadd', ('imul', ('extract_i8', 'a', 0), ('extract_u8', 'b', 0)), ('imul', ('extract_i8', 'a', 1), ('extract_u8', 'b', 1))), ('iadd', ('imul', ('extract_i8', 'a', 2), ('extract_u8', 'b', 2)), ('imul', ('extract_i8', 'a', 3), ('extract_u8', 'b', 3)))), 'c')
 *    ('sdot_2x16_iadd', 'a', 'b', 'c') => ('iadd', ('iadd', ('imul', ('extract_i16', 'a', 0), ('extract_i16', 'b', 0)), ('imul', ('extract_i16', 'a', 1), ('extract_i16', 'b', 1))), 'c')
 *    ('udot_2x16_uadd', 'a', 'b', 'c') => ('iadd', ('iadd', ('imul', ('extract_u16', 'a', 0), ('extract_u16', 'b', 0)), ('imul', ('extract_u16', 'a', 1), ('extract_u16', 'b', 1))), 'c')
 *    ('udot_4x8_uadd_sat', 'a', 'b', '#c(is_ult_0xfffc07fc)') => ('udot_4x8_uadd', 'a', 'b', 'c')
 *    ('udot_4x8_uadd_sat', 'a', 'b', 'c') => ('uadd_sat', ('udot_4x8_uadd', 'a', 'b', 0), 'c')
 *    ('sdot_4x8_iadd_sat', 'a', 'b', 'c') => ('iadd_sat', ('sdot_4x8_iadd', 'a', 'b', 0), 'c')
 *    ('sudot_4x8_iadd_sat', 'a', 'b', 'c') => ('iadd_sat', ('sudot_4x8_iadd', 'a', 'b', 0), 'c')
 *    ('udot_2x16_uadd_sat', 'a', 'b', 'c') => ('uadd_sat', ('iadd', ('imul', ('extract_u16', 'a', 0), ('extract_u16', 'b', 0)), ('imul', ('extract_u16', 'a', 1), ('extract_u16', 'b', 1))), 'c')
 *    ('sdot_2x16_iadd_sat', 'a', 'b', 'c') => ('iadd_sat', ('iadd', ('imul', ('extract_i16', 'a', 0), ('extract_i16', 'b', 0)), ('imul', ('extract_i16', 'a', 1), ('extract_i16', 'b', 1))), 'c')
 *    ('~flrp@16', 'a', 'b', ('b2f', 'c@1')) => ('bcsel', 'c', 'b', 'a')
 *    ('~flrp@16', 'a', ('fadd', 'a', 'b'), 'c') => ('fadd', ('fmul', 'b', 'c'), 'a')
 *    ('~flrp@16', ('fadd(is_used_once)', 'a', 'b'), ('fadd(is_used_once)', 'a', 'c'), 'd') => ('fadd', ('flrp', 'b', 'c', 'd'), 'a')
 *    ('~flrp@16', 'a', ('fmul(is_used_once)', 'a', 'b'), 'c') => ('fmul', ('flrp', 1.0, 'b', 'c'), 'a')
 *    ('~fadd@16', ('fmul', 'a', ('fadd', 1.0, ('fneg', 'c'))), ('fmul', 'b', 'c')) => ('flrp', 'a', 'b', 'c')
 *    ('~fadd@16', ('fmul', 'a', ('fsat', ('fadd', 1.0, ('fneg', 'c')))), ('fmul', 'b', ('fsat', 'c'))) => ('flrp', 'a', 'b', ('fsat', 'c'))
 *    ('~fadd@16', 'a', ('fmul', 'c', ('fadd', 'b', ('fneg', 'a')))) => ('flrp', 'a', 'b', 'c')
 *    ('~fadd@16', ('fmul', 'a', ('fadd', 1.0, ('fneg', ('b2f', 'c@1')))), ('fmul', 'b', ('b2f', 'c'))) => ('bcsel', 'c', 'b', 'a')
 *    ('~fadd@16', 'a', ('fmul', ('b2f', 'c@1'), ('fadd', 'b', ('fneg', 'a')))) => ('bcsel', 'c', 'b', 'a')
 *    ('~ffma@16', 'a', ('fadd', 1.0, ('fneg', ('b2f', 'c@1'))), ('fmul', 'b', ('b2f', 'c@1'))) => ('bcsel', 'c', 'b', 'a')
 *    ('~ffma@16', 'b', ('b2f', 'c@1'), ('ffma', ('fneg', 'a'), ('b2f', 'c@1'), 'a')) => ('bcsel', 'c', 'b', 'a')
 *    ('~ffma@16', ('b2f', 'c@1'), ('fadd', 'b', ('fneg', 'a')), 'a') => ('bcsel', 'c', 'b', 'a')
 *    ('~ffma@16', ('b2f', 'c@1'), ('ffma', ('fneg', 'a'), 'b', 'd'), ('fmul', 'a', 'b')) => ('bcsel', 'c', 'd', ('fmul', 'a', 'b'))
 *    ('~fadd@16', 1.0, ('fneg', ('fmul', ('fadd', 1.0, ('fneg', 'a')), ('fadd', 1.0, ('fneg', 'b'))))) => ('flrp', 'b', 1.0, 'a')
 *    ('~flrp@32', 'a', 'b', ('b2f', 'c@1')) => ('bcsel', 'c', 'b', 'a')
 *    ('~flrp@32', 'a', ('fadd', 'a', 'b'), 'c') => ('fadd', ('fmul', 'b', 'c'), 'a')
 *    ('~flrp@32', ('fadd(is_used_once)', 'a', 'b'), ('fadd(is_used_once)', 'a', 'c'), 'd') => ('fadd', ('flrp', 'b', 'c', 'd'), 'a')
 *    ('~flrp@32', 'a', ('fmul(is_used_once)', 'a', 'b'), 'c') => ('fmul', ('flrp', 1.0, 'b', 'c'), 'a')
 *    ('~fadd@32', ('fmul', 'a', ('fadd', 1.0, ('fneg', 'c'))), ('fmul', 'b', 'c')) => ('flrp', 'a', 'b', 'c')
 *    ('~fadd@32', ('fmul', 'a', ('fsat', ('fadd', 1.0, ('fneg', 'c')))), ('fmul', 'b', ('fsat', 'c'))) => ('flrp', 'a', 'b', ('fsat', 'c'))
 *    ('~fadd@32', 'a', ('fmul', 'c', ('fadd', 'b', ('fneg', 'a')))) => ('flrp', 'a', 'b', 'c')
 *    ('~fadd@32', ('fmul', 'a', ('fadd', 1.0, ('fneg', ('b2f', 'c@1')))), ('fmul', 'b', ('b2f', 'c'))) => ('bcsel', 'c', 'b', 'a')
 *    ('~fadd@32', 'a', ('fmul', ('b2f', 'c@1'), ('fadd', 'b', ('fneg', 'a')))) => ('bcsel', 'c', 'b', 'a')
 *    ('~ffma@32', 'a', ('fadd', 1.0, ('fneg', ('b2f', 'c@1'))), ('fmul', 'b', ('b2f', 'c@1'))) => ('bcsel', 'c', 'b', 'a')
 *    ('~ffma@32', 'b', ('b2f', 'c@1'), ('ffma', ('fneg', 'a'), ('b2f', 'c@1'), 'a')) => ('bcsel', 'c', 'b', 'a')
 *    ('~ffma@32', ('b2f', 'c@1'), ('fadd', 'b', ('fneg', 'a')), 'a') => ('bcsel', 'c', 'b', 'a')
 *    ('~ffma@32', ('b2f', 'c@1'), ('ffma', ('fneg', 'a'), 'b', 'd'), ('fmul', 'a', 'b')) => ('bcsel', 'c', 'd', ('fmul', 'a', 'b'))
 *    ('~fadd@32', 1.0, ('fneg', ('fmul', ('fadd', 1.0, ('fneg', 'a')), ('fadd', 1.0, ('fneg', 'b'))))) => ('flrp', 'b', 1.0, 'a')
 *    ('~flrp@64', 'a', 'b', ('b2f', 'c@1')) => ('bcsel', 'c', 'b', 'a')
 *    ('~flrp@64', 'a', ('fadd', 'a', 'b'), 'c') => ('fadd', ('fmul', 'b', 'c'), 'a')
 *    ('~flrp@64', ('fadd(is_used_once)', 'a', 'b'), ('fadd(is_used_once)', 'a', 'c'), 'd') => ('fadd', ('flrp', 'b', 'c', 'd'), 'a')
 *    ('~flrp@64', 'a', ('fmul(is_used_once)', 'a', 'b'), 'c') => ('fmul', ('flrp', 1.0, 'b', 'c'), 'a')
 *    ('~fadd@64', ('fmul', 'a', ('fadd', 1.0, ('fneg', 'c'))), ('fmul', 'b', 'c')) => ('flrp', 'a', 'b', 'c')
 *    ('~fadd@64', ('fmul', 'a', ('fsat', ('fadd', 1.0, ('fneg', 'c')))), ('fmul', 'b', ('fsat', 'c'))) => ('flrp', 'a', 'b', ('fsat', 'c'))
 *    ('~fadd@64', 'a', ('fmul', 'c', ('fadd', 'b', ('fneg', 'a')))) => ('flrp', 'a', 'b', 'c')
 *    ('~fadd@64', ('fmul', 'a', ('fadd', 1.0, ('fneg', ('b2f', 'c@1')))), ('fmul', 'b', ('b2f', 'c'))) => ('bcsel', 'c', 'b', 'a')
 *    ('~fadd@64', 'a', ('fmul', ('b2f', 'c@1'), ('fadd', 'b', ('fneg', 'a')))) => ('bcsel', 'c', 'b', 'a')
 *    ('~ffma@64', 'a', ('fadd', 1.0, ('fneg', ('b2f', 'c@1'))), ('fmul', 'b', ('b2f', 'c@1'))) => ('bcsel', 'c', 'b', 'a')
 *    ('~ffma@64', 'b', ('b2f', 'c@1'), ('ffma', ('fneg', 'a'), ('b2f', 'c@1'), 'a')) => ('bcsel', 'c', 'b', 'a')
 *    ('~ffma@64', ('b2f', 'c@1'), ('fadd', 'b', ('fneg', 'a')), 'a') => ('bcsel', 'c', 'b', 'a')
 *    ('~ffma@64', ('b2f', 'c@1'), ('ffma', ('fneg', 'a'), 'b', 'd'), ('fmul', 'a', 'b')) => ('bcsel', 'c', 'd', ('fmul', 'a', 'b'))
 *    ('~fadd@64', 1.0, ('fneg', ('fmul', ('fadd', 1.0, ('fneg', 'a')), ('fadd', 1.0, ('fneg', 'b'))))) => ('flrp', 'b', 1.0, 'a')
 *    ('~flrp', ('fmul(is_used_once)', 'a', 'b'), ('fmul(is_used_once)', 'a', 'c'), 'd') => ('fmul', ('flrp', 'b', 'c', 'd'), 'a')
 *    ('~flrp', 'a', 0.0, 'c') => ('fadd', ('fmul', ('fneg', 'a'), 'c'), 'a')
 *    ('fadd', ('ffloor', 'a'), ('b2f', ('iand', ('flt', 'a', 0), ('flt', ('fneg', ('ffract', 'a')), ('ffract', 'a'))))) => ('ftrunc', ('fadd', 'a', 0))
 *    ('fadd', ('ffloor', 'a'), ('b2f', ('inot', ('fge', 0, ('fmin', ('fneg', 'a'), ('ffract', 'a')))))) => ('ftrunc', ('fadd', 'a', 0))
 *    ('fadd', ('ffloor', 'a'), ('b2f', ('flt', 0, ('fmin', ('fneg', 'a'), ('ffract', 'a'))))) => ('ftrunc', ('fadd', 'a', 0))
 *    ('fadd(nnan,nsz)', 'a', ('ffract', ('fneg', 'a'))) => ('fceil', 'a')
 *    ('ftrunc@16', 'a') => ('bcsel', ('flt', 'a', 0.0), ('fneg', ('ffloor', ('fabs', 'a'))), ('ffloor', ('fabs', 'a')))
 *    ('ftrunc@32', 'a') => ('bcsel', ('flt', 'a', 0.0), ('fneg', ('ffloor', ('fabs', 'a'))), ('ffloor', ('fabs', 'a')))
 *    ('ftrunc@64', 'a') => ('bcsel', ('flt', 'a', 0.0), ('fneg', ('ffloor', ('fabs', 'a'))), ('ffloor', ('fabs', 'a')))
 *    ('ffloor@16', 'a') => ('fsub', 'a', ('ffract', 'a'))
 *    ('ffloor@32', 'a') => ('fsub', 'a', ('ffract', 'a'))
 *    ('ffloor@64', 'a') => ('fsub', 'a', ('ffract', 'a'))
 *    ('fadd@16', 'a', ('fadd@16', 'b', ('fneg', ('ffract', 'a')))) => ('fadd@16', 'b', ('ffloor', 'a'))
 *    ('fadd@32', 'a', ('fadd@32', 'b', ('fneg', ('ffract', 'a')))) => ('fadd@32', 'b', ('ffloor', 'a'))
 *    ('fadd@64', 'a', ('fadd@64', 'b', ('fneg', ('ffract', 'a')))) => ('fadd@64', 'b', ('ffloor', 'a'))
 *    ('fadd@16(nnan)', 'a', ('fneg', ('ffract', 'a'))) => ('ffloor', 'a')
 *    ('fadd@32(nnan)', 'a', ('fneg', ('ffract', 'a'))) => ('ffloor', 'a')
 *    ('fadd@64(nnan)', 'a', ('fneg', ('ffract', 'a'))) => ('ffloor', 'a')
 *    ('ffract@16', 'a') => ('fsub', 'a', ('ffloor', 'a'))
 *    ('ffract@32', 'a') => ('fsub', 'a', ('ffloor', 'a'))
 *    ('ffract@64', 'a') => ('fsub', 'a', ('ffloor', 'a'))
 *    ('fceil', 'a') => ('fneg', ('ffloor', ('fneg', 'a')))
 *    ('ffma@16', 'a', 'b', 'c') => ('fadd', ('fmul', 'a', 'b'), 'c')
 *    ('ffma@32', 'a', 'b', 'c') => ('fadd', ('fmul', 'a', 'b'), 'c')
 *    ('ffma@64', 'a', 'b', 'c') => ('fadd', ('fmul', 'a', 'b'), 'c')
 *    ('ffmaz', 'a', 'b', 'c') => ('fadd', ('fmulz', 'a', 'b'), 'c')
 *    ('~ffma@16', 'a', 'b', 'c') => ('fadd', ('fmul', 'a', 'b'), 'c')
 *    ('~ffma@32', 'a', 'b', 'c') => ('fadd', ('fmul', 'a', 'b'), 'c')
 *    ('~ffma@64', 'a', 'b', 'c') => ('fadd', ('fmul', 'a', 'b'), 'c')
 *    ('~ffmaz', 'a', 'b', 'c') => ('fadd', ('fmulz', 'a', 'b'), 'c')
 *    ('~fmul', ('fadd', ('iand', ('ineg', ('b2i', 'a@bool')), ('fmul', 'b', 'c')), '#d'), '#e') => ('bcsel', 'a', ('fmul', ('fadd', ('fmul', 'b', 'c'), 'd'), 'e'), ('fmul', 'd', 'e'))
 *    ('fdph', 'a', 'b') => ('fdot4', ('vec4', 'a.x', 'a.y', 'a.z', 1.0), 'b')
 *    ('fdot4', 'a', 0.0) => 0.0
 *    ('fdot3', 'a', 0.0) => 0.0
 *    ('fdot2', 'a', 0.0) => 0.0
 *    ('fdot4', ('vec4', 'a', 'b', 'c', 1.0), 'd') => ('fdph', ('vec3', 'a', 'b', 'c'), 'd')
 *    ('fdot4', ('vec4', 'a', 0.0, 0.0, 0.0), 'b') => ('fmul', 'a', 'b')
 *    ('fdot4', ('vec4', 'a', 'b', 0.0, 0.0), 'c') => ('fdot2', ('vec2', 'a', 'b'), 'c')
 *    ('fdot4', ('vec4', 'a', 'b', 'c', 0.0), 'd') => ('fdot3', ('vec3', 'a', 'b', 'c'), 'd')
 *    ('fdot3', ('vec3', 'a', 0.0, 0.0), 'b') => ('fmul', 'a', 'b')
 *    ('fdot3', ('vec3', 'a', 'b', 0.0), 'c') => ('fdot2', ('vec2', 'a', 'b'), 'c')
 *    ('fdot2', ('vec2', 'a', 0.0), 'b') => ('fmul', 'a', 'b')
 *    ('fdot2', 'a', 1.0) => ('fadd', 'a.x', 'a.y')
 *    ('fdot2', 'a', 'b') => ('fsum2', ('fmul', 'a', 'b'))
 *    ('fdot3', 'a', 'b') => ('fsum3', ('fmul', 'a', 'b'))
 *    ('fdot4', 'a', 'b') => ('fsum4', ('fmul', 'a', 'b'))
 *    ('fsum2', 'a') => ('fadd', 'a.x', 'a.y')
 *    ('~fadd', ('fneg(is_used_once)', ('fsat(is_used_once)', 'a(is_not_fmul)')), 1.0) => ('fsat', ('fadd', 1.0, ('fneg', 'a')))
 *    ('ishl', ('iadd', ('imul', 'a', '#b'), '#c'), '#d') => ('iadd', ('imul', 'a', ('ishl', 'b', 'd')), ('ishl', 'c', 'd'))
 *    ('ishl', ('imul', 'a', '#b'), '#c') => ('imul', 'a', ('ishl', 'b', 'c'))
 *    ('ishl@8', ('ishl@8', 'a', '#b'), '#c') => ('bcsel', ('ult', ('iadd', ('iand', 'b', 7), ('iand', 'c', 7)), 8), ('ishl@8', 'a', ('iadd', 'b', 'c')), 0)
 *    ('ushr@8', ('ushr@8', 'a', '#b'), '#c') => ('bcsel', ('ult', ('iadd', ('iand', 'b', 7), ('iand', 'c', 7)), 8), ('ushr@8', 'a', ('iadd', 'b', 'c')), 0)
 *    ('ishr@8', ('ishr@8', 'a', '#b'), '#c') => ('ishr@8', 'a', ('imin', ('iadd', ('iand', 'b', 7), ('iand', 'c', 7)), 7))
 *    ('ishl@16', ('ishl@16', 'a', '#b'), '#c') => ('bcsel', ('ult', ('iadd', ('iand', 'b', 15), ('iand', 'c', 15)), 16), ('ishl@16', 'a', ('iadd', 'b', 'c')), 0)
 *    ('ushr@16', ('ushr@16', 'a', '#b'), '#c') => ('bcsel', ('ult', ('iadd', ('iand', 'b', 15), ('iand', 'c', 15)), 16), ('ushr@16', 'a', ('iadd', 'b', 'c')), 0)
 *    ('ishr@16', ('ishr@16', 'a', '#b'), '#c') => ('ishr@16', 'a', ('imin', ('iadd', ('iand', 'b', 15), ('iand', 'c', 15)), 15))
 *    ('ishl@32', ('ishl@32', 'a', '#b'), '#c') => ('bcsel', ('ult', ('iadd', ('iand', 'b', 31), ('iand', 'c', 31)), 32), ('ishl@32', 'a', ('iadd', 'b', 'c')), 0)
 *    ('ushr@32', ('ushr@32', 'a', '#b'), '#c') => ('bcsel', ('ult', ('iadd', ('iand', 'b', 31), ('iand', 'c', 31)), 32), ('ushr@32', 'a', ('iadd', 'b', 'c')), 0)
 *    ('ishr@32', ('ishr@32', 'a', '#b'), '#c') => ('ishr@32', 'a', ('imin', ('iadd', ('iand', 'b', 31), ('iand', 'c', 31)), 31))
 *    ('ishl@64', ('ishl@64', 'a', '#b'), '#c') => ('bcsel', ('ult', ('iadd', ('iand', 'b', 63), ('iand', 'c', 63)), 64), ('ishl@64', 'a', ('iadd', 'b', 'c')), 0)
 *    ('ushr@64', ('ushr@64', 'a', '#b'), '#c') => ('bcsel', ('ult', ('iadd', ('iand', 'b', 63), ('iand', 'c', 63)), 64), ('ushr@64', 'a', ('iadd', 'b', 'c')), 0)
 *    ('ishr@64', ('ishr@64', 'a', '#b'), '#c') => ('ishr@64', 'a', ('imin', ('iadd', ('iand', 'b', 63), ('iand', 'c', 63)), 63))
 *    ('ishl', ('ushr', 'a@8', '#b'), 'b') => ('iand', 'a', ('ishl', 255, 'b'))
 *    ('ishl', ('ishr', 'a@8', '#b'), 'b') => ('iand', 'a', ('ishl', 255, 'b'))
 *    ('ushr', ('ishl', 'a@8', '#b'), 'b') => ('iand', 'a', ('ushr', 255, 'b'))
 *    ('ishl', ('ushr', 'a@16', '#b'), 'b') => ('iand', 'a', ('ishl', 65535, 'b'))
 *    ('ishl', ('ishr', 'a@16', '#b'), 'b') => ('iand', 'a', ('ishl', 65535, 'b'))
 *    ('ushr', ('ishl', 'a@16', '#b'), 'b') => ('iand', 'a', ('ushr', 65535, 'b'))
 *    ('ishl', ('ushr', 'a@32', '#b'), 'b') => ('iand', 'a', ('ishl', 4294967295, 'b'))
 *    ('ishl', ('ishr', 'a@32', '#b'), 'b') => ('iand', 'a', ('ishl', 4294967295, 'b'))
 *    ('ushr', ('ishl', 'a@32', '#b'), 'b') => ('iand', 'a', ('ushr', 4294967295, 'b'))
 *    ('ishl', ('ushr', 'a@64', '#b'), 'b') => ('iand', 'a', ('ishl', 18446744073709551615, 'b'))
 *    ('ishl', ('ishr', 'a@64', '#b'), 'b') => ('iand', 'a', ('ishl', 18446744073709551615, 'b'))
 *    ('ushr', ('ishl', 'a@64', '#b'), 'b') => ('iand', 'a', ('ushr', 18446744073709551615, 'b'))
 *    ('iand@32', ('ushr@32(is_used_once)', 'a', 'b'), '#c(is_const_bitmask)') => ('ubfe', 'a', 'b', ('bit_count', 'c'))
 *    ('iand@32', ('ushr@32', 'a', 'b'), ('bfm', 'c', 0)) => ('ubfe', 'a', 'b', 'c')
 *    ('ushr', ('iand', 'a', ('bfm', 'c', 'b')), 'b') => ('ubfe', 'a', 'b', 'c')
 *    ('ubfe', ('ubfe', 'a', '#b', '#c'), '#d', '#e') => ('bcsel', ('ilt', 31, ('iadd', ('iand', 'b', 31), ('iand', 'd', 31))), 0, ('ubfe', 'a', ('iadd', ('iand', 'b', 31), ('iand', 'd', 31)), ('umin', ('iand', 'e', 31), ('imax', ('isub', ('umin', ('iand', 'c', 31), ('isub', 32, ('iand', 'b', 31))), ('iand', 'd', 31)), 0))))
 *    ('ushr@32', ('ubfe', 'a', '#b', '#c'), '#d(is_5lsb_not_zero)') => ('bcsel', ('ilt', 31, ('iadd', ('iand', 'b', 31), ('iand', 'd', 31))), 0, ('ubfe', 'a', ('iadd', ('iand', 'b', 31), ('iand', 'd', 31)), ('umin', ('iand', 31, 31), ('imax', ('isub', ('umin', ('iand', 'c', 31), ('isub', 32, ('iand', 'b', 31))), ('iand', 'd', 31)), 0))))
 *    ('iand', ('ishl', 'a@32', '#b(is_first_5_bits_uge_2)'), -4) => ('ishl', 'a', 'b')
 *    ('iand', ('imul', 'a', '#b(is_unsigned_multiple_of_4)'), -4) => ('imul', 'a', 'b')
 *    ('iand@32', ('iadd@32', 'a', '#b(is_unsigned_multiple_of_2)'), 4294967294) => ('iadd', ('iand', 'a', 4294967294), 'b')
 *    ('iand@32', ('iadd@32', 'a', '#b(is_unsigned_multiple_of_4)'), 4294967292) => ('iadd', ('iand', 'a', 4294967292), 'b')
 *    ('iand@32', ('iadd@32', 'a', '#b(is_unsigned_multiple_of_8)'), 4294967288) => ('iadd', ('iand', 'a', 4294967288), 'b')
 *    ('iand@32', ('iadd@32', 'a', '#b(is_unsigned_multiple_of_16)'), 4294967280) => ('iadd', ('iand', 'a', 4294967280), 'b')
 *    ('iand@32', ('iadd@32', 'a', '#b(is_unsigned_multiple_of_32)'), 4294967264) => ('iadd', ('iand', 'a', 4294967264), 'b')
 *    ('iand@32', ('iadd@32', 'a', '#b(is_unsigned_multiple_of_64)'), 4294967232) => ('iadd', ('iand', 'a', 4294967232), 'b')
 *    ('ishl@32', ('iand', 'a@32', 2147483647), 1) => ('ishl', 'a', 1)
 *    ('iand', ('ishl', 'a@32', 1), 4294967294) => ('ishl', 'a', 1)
 *    ('iand', ('ushr', 'a@32', 1), 2147483647) => ('ushr', 'a', 1)
 *    ('ishl@32', ('iand', 'a@32', 1073741823), 2) => ('ishl', 'a', 2)
 *    ('iand', ('ishl', 'a@32', 2), 4294967292) => ('ishl', 'a', 2)
 *    ('iand', ('ushr', 'a@32', 2), 1073741823) => ('ushr', 'a', 2)
 *    ('ishl@32', ('iand', 'a@32', 65535), 16) => ('ishl', 'a', 16)
 *    ('iand', ('ishl', 'a@32', 16), 4294901760) => ('ishl', 'a', 16)
 *    ('iand', ('ushr', 'a@32', 16), 65535) => ('ushr', 'a', 16)
 *    ('ishl@32', ('iand', 'a@32', 255), 24) => ('ishl', 'a', 24)
 *    ('iand', ('ishl', 'a@32', 24), 4278190080) => ('ishl', 'a', 24)
 *    ('iand', ('ushr', 'a@32', 24), 255) => ('ushr', 'a', 24)
 *    ('ishl', ('iadd', 'a', '#b'), '#c') => ('iadd', ('ishl', 'a', 'c'), ('ishl', 'b', 'c'))
 *    ('imul', ('iadd(is_used_once)', 'a', '#b'), '#c') => ('iadd', ('imul', 'a', 'c'), ('imul', 'b', 'c'))
 *    ('imul', ('iadd(is_used_once)', ('iadd(is_used_once)', 'a', '#b'), 'c'), '#d') => ('iadd', ('imul', ('iadd', 'a', 'c'), 'd'), ('imul', 'b', 'd'))
 *    ('ishl', ('iadd(is_used_once)', ('iadd(is_used_once)', 'a', '#b'), 'c'), '#d') => ('iadd', ('ishl', ('iadd', 'a', 'c'), 'd'), ('ishl', 'b', 'd'))
 *    ('inot', ('flt(is_used_once)', 'a(is_a_number)', 'b(is_a_number)')) => ('fge', 'a', 'b')
 *    ('inot', ('fge(is_used_once)', 'a(is_a_number)', 'b(is_a_number)')) => ('flt', 'a', 'b')
 *    ('inot', ('feq(is_used_once)', 'a', 'b')) => ('fneu', 'a', 'b')
 *    ('inot', ('fneu(is_used_once)', 'a', 'b')) => ('feq', 'a', 'b')
 *    ('inot', ('ilt(is_used_once)', 'a', 'b')) => ('ige', 'a', 'b')
 *    ('inot', ('ult(is_used_once)', 'a', 'b')) => ('uge', 'a', 'b')
 *    ('inot', ('ige(is_used_once)', 'a', 'b')) => ('ilt', 'a', 'b')
 *    ('inot', ('uge(is_used_once)', 'a', 'b')) => ('ult', 'a', 'b')
 *    ('inot', ('ieq(is_used_once)', 'a', 'b')) => ('ine', 'a', 'b')
 *    ('inot', ('ine(is_used_once)', 'a', 'b')) => ('ieq', 'a', 'b')
 *    ('iand', ('feq', 'a', 'b'), ('fneu', 'a', 'b')) => False
 *    ('iand', ('flt', 'a', 'b'), ('flt', 'b', 'a')) => False
 *    ('iand', ('ieq', 'a', 'b'), ('ine', 'a', 'b')) => False
 *    ('iand', ('ilt', 'a', 'b'), ('ilt', 'b', 'a')) => False
 *    ('iand', ('ult', 'a', 'b'), ('ult', 'b', 'a')) => False
 *    ('flt', ('fneg', 'a'), ('fneg', 'b')) => ('flt', 'b', 'a')
 *    ('fge', ('fneg', 'a'), ('fneg', 'b')) => ('fge', 'b', 'a')
 *    ('feq', ('fneg', 'a'), ('fneg', 'b')) => ('feq', 'b', 'a')
 *    ('fneu', ('fneg', 'a'), ('fneg', 'b')) => ('fneu', 'b', 'a')
 *    ('flt', ('fneg', 'a(is_not_const)'), '#b') => ('flt', ('fneg', 'b'), 'a')
 *    ('flt', '#b', ('fneg', 'a(is_not_const)')) => ('flt', 'a', ('fneg', 'b'))
 *    ('fge', ('fneg', 'a(is_not_const)'), '#b') => ('fge', ('fneg', 'b'), 'a')
 *    ('fge', '#b', ('fneg', 'a(is_not_const)')) => ('fge', 'a', ('fneg', 'b'))
 *    ('fneu', ('fneg', 'a(is_not_const)'), '#b') => ('fneu', ('fneg', 'b'), 'a')
 *    ('feq', '#b', ('fneg', 'a(is_not_const)')) => ('feq', 'a', ('fneg', 'b'))
 *    ('flt', 'a', '#b(is_negative_zero)') => ('flt', 'a', 0.0)
 *    ('flt', '#b(is_negative_zero)', 'a') => ('flt', 0.0, 'a')
 *    ('fge', 'a', '#b(is_negative_zero)') => ('fge', 'a', 0.0)
 *    ('fge', '#b(is_negative_zero)', 'a') => ('fge', 0.0, 'a')
 *    ('fneu', 'a', '#b(is_negative_zero)') => ('fneu', 0.0, 'a')
 *    ('feq', '#b(is_negative_zero)', 'a') => ('feq', 'a', 0.0)
 *    ('ieq', ('ineg', 'a'), 0) => ('ieq', 'a', 0)
 *    ('ine', ('ineg', 'a'), 0) => ('ine', 'a', 0)
 *    ('ieq', ('iabs', 'a'), 0) => ('ieq', 'a', 0)
 *    ('ine', ('iabs', 'a'), 0) => ('ine', 'a', 0)
 *    ('fneu', ('fabs', 'a'), 0.0) => ('fneu', 'a', 0.0)
 *    ('feq', ('fabs', 'a'), 0.0) => ('feq', 'a', 0.0)
 *    ('fneu', ('fabs', 'a'), ('fabs', 'a')) => ('fneu', 'a', 'a')
 *    ('feq', ('fabs', 'a'), ('fabs', 'a')) => ('feq', 'a', 'a')
 *    ('flt', '#b(is_gt_0_and_lt_1)', ('fsat(is_used_once)', 'a')) => ('flt', 'b', 'a')
 *    ('fge', ('fsat(is_used_once)', 'a'), '#b(is_gt_0_and_lt_1)') => ('fge', 'a', 'b')
 *    ('feq', ('fsat(is_used_once)', 'a'), '#b(is_gt_0_and_lt_1)') => ('feq', 'a', 'b')
 *    ('fneu', ('fsat(is_used_once)', 'a'), '#b(is_gt_0_and_lt_1)') => ('fneu', 'a', 'b')
 *    ('fge', ('fsat(is_used_once)', 'a'), 1.0) => ('fge', 'a', 1.0)
 *    ('flt', 0.0, ('fsat(is_used_once)', 'a')) => ('flt', 0.0, 'a')
 *    ('fge', 0.0, ('b2f', 'a@1')) => ('inot', 'a')
 *    ('fge', ('fneg', ('b2f', 'a@1')), 0.0) => ('inot', 'a')
 *    ('fneu', ('fadd', ('b2f', 'a@1'), ('b2f', 'b@1')), 0.0) => ('ior', 'a', 'b')
 *    ('fneu', ('bcsel', 'a', 1.0, ('b2f', 'b@1')), 0.0) => ('ior', 'a', 'b')
 *    ('fneu', ('b2f', 'a@1'), ('fneg', ('b2f', 'b@1'))) => ('ior', 'a', 'b')
 *    ('fneu', ('fmul', ('b2f', 'a@1'), ('b2f', 'b@1')), 0.0) => ('iand', 'a', 'b')
 *    ('fneu', ('bcsel', 'a', ('b2f', 'b@1'), 0.0), 0.0) => ('iand', 'a', 'b')
 *    ('fneu', ('fadd', ('b2f', 'a@1'), ('fneg', ('b2f', 'b@1'))), 0.0) => ('ixor', 'a', 'b')
 *    ('fneu', ('b2f', 'a@1'), ('b2f', 'b@1')) => ('ixor', 'a', 'b')
 *    ('fneu', ('fneg', ('b2f', 'a@1')), ('fneg', ('b2f', 'b@1'))) => ('ixor', 'a', 'b')
 *    ('feq', ('fadd', ('b2f', 'a@1'), ('b2f', 'b@1')), 0.0) => ('inot', ('ior', 'a', 'b'))
 *    ('feq', ('bcsel', 'a', 1.0, ('b2f', 'b@1')), 0.0) => ('inot', ('ior', 'a', 'b'))
 *    ('feq', ('b2f', 'a@1'), ('fneg', ('b2f', 'b@1'))) => ('inot', ('ior', 'a', 'b'))
 *    ('feq', ('fmul', ('b2f', 'a@1'), ('b2f', 'b@1')), 0.0) => ('inot', ('iand', 'a', 'b'))
 *    ('feq', ('bcsel', 'a', ('b2f', 'b@1'), 0.0), 0.0) => ('inot', ('iand', 'a', 'b'))
 *    ('feq', ('fadd', ('b2f', 'a@1'), ('fneg', ('b2f', 'b@1'))), 0.0) => ('ieq', 'a', 'b')
 *    ('feq', ('b2f', 'a@1'), ('b2f', 'b@1')) => ('ieq', 'a', 'b')
 *    ('feq', ('fneg', ('b2f', 'a@1')), ('fneg', ('b2f', 'b@1'))) => ('ieq', 'a', 'b')
 *    ('flt', ('fneg', ('fadd', ('b2f', 'a@1'), ('b2f', 'b@1'))), 0.0) => ('ior', 'a', 'b')
 *    ('flt', 0.0, ('fadd', ('b2f', 'a@1'), ('b2f', 'b@1'))) => ('ior', 'a', 'b')
 *    ('fge', ('fneg', ('fadd', ('b2f', 'a@1'), ('b2f', 'b@1'))), 0.0) => ('inot', ('ior', 'a', 'b'))
 *    ('fge', 0.0, ('fadd', ('b2f', 'a@1'), ('b2f', 'b@1'))) => ('inot', ('ior', 'a', 'b'))
 *    ('flt', 'a', ('fneg', 'a')) => ('flt', 'a', 0.0)
 *    ('fge', 'a', ('fneg', 'a')) => ('fge', 'a', 0.0)
 *    ('flt', ('fmin', 'c', ('fneg', ('fadd', ('b2f', 'a@1'), ('b2f', 'b@1')))), 0.0) => ('ior', ('flt', 'c', 0.0), ('ior', 'a', 'b'))
 *    ('~flt', ('fadd', 'a', 'b'), 'a') => ('flt', 'b', 0.0)
 *    ('~fge', ('fadd', 'a', 'b'), 'a') => ('fge', 'b', 0.0)
 *    ('~feq', ('fadd', 'a', 'b'), 'a') => ('feq', 'b', 0.0)
 *    ('~fneu', ('fadd', 'a', 'b'), 'a') => ('fneu', 'b', 0.0)
 *    ('~flt', ('fadd(is_used_once)', 'a', '#b'), '#c') => ('flt', 'a', ('fadd', 'c', ('fneg', 'b')))
 *    ('~flt', ('fneg(is_used_once)', ('fadd(is_used_once)', 'a', '#b')), '#c') => ('flt', ('fneg', ('fadd', 'c', 'b')), 'a')
 *    ('~fge', ('fadd(is_used_once)', 'a', '#b'), '#c') => ('fge', 'a', ('fadd', 'c', ('fneg', 'b')))
 *    ('~fge', ('fneg(is_used_once)', ('fadd(is_used_once)', 'a', '#b')), '#c') => ('fge', ('fneg', ('fadd', 'c', 'b')), 'a')
 *    ('~feq', ('fadd(is_used_once)', 'a', '#b'), '#c') => ('feq', 'a', ('fadd', 'c', ('fneg', 'b')))
 *    ('~feq', ('fneg(is_used_once)', ('fadd(is_used_once)', 'a', '#b')), '#c') => ('feq', ('fneg', ('fadd', 'c', 'b')), 'a')
 *    ('~fneu', ('fadd(is_used_once)', 'a', '#b'), '#c') => ('fneu', 'a', ('fadd', 'c', ('fneg', 'b')))
 *    ('~fneu', ('fneg(is_used_once)', ('fadd(is_used_once)', 'a', '#b')), '#c') => ('fneu', ('fneg', ('fadd', 'c', 'b')), 'a')
 *    ('ieq', ('iadd', 'a', 'b'), 'a') => ('ieq', 'b', 0)
 *    ('ine', ('iadd', 'a', 'b'), 'a') => ('ine', 'b', 0)
 *    ('feq', ('b2f', 'a@1'), 0.0) => ('inot', 'a')
 *    ('fge', 0.0, ('b2f', 'a@1')) => ('inot', 'a')
 *    ('fneu', ('b2f', 'a@1'), 0.0) => a
 *    ('flt', 0.0, ('b2f', 'a@1')) => a
 *    ('ieq', ('b2i', 'a@1'), 0) => ('inot', 'a')
 *    ('ine', ('b2i', 'a@1'), 0) => a
 *    ('ieq', 'a@1', False) => ('inot', 'a')
 *    ('ieq', 'a@1', True) => a
 *    ('ine', 'a@1', False) => a
 *    ('ine', 'a@1', True) => ('inot', 'a')
 *    ('fneu', ('u2f', 'a'), 0.0) => ('ine', 'a', 0)
 *    ('feq', ('u2f', 'a'), 0.0) => ('ieq', 'a', 0)
 *    ('fge', ('u2f', 'a'), 0.0) => True
 *    ('fge', 0.0, ('u2f', 'a')) => ('uge', 0, 'a')
 *    ('flt', ('u2f', 'a'), 0.0) => False
 *    ('flt', 0.0, ('u2f', 'a')) => ('ult', 0, 'a')
 *    ('fneu', ('i2f', 'a'), 0.0) => ('ine', 'a', 0)
 *    ('feq', ('i2f', 'a'), 0.0) => ('ieq', 'a', 0)
 *    ('fge', ('i2f', 'a'), 0.0) => ('ige', 'a', 0)
 *    ('fge', 0.0, ('i2f', 'a')) => ('ige', 0, 'a')
 *    ('flt', ('i2f', 'a'), 0.0) => ('ilt', 'a', 0)
 *    ('flt', 0.0, ('i2f', 'a')) => ('ilt', 0, 'a')
 *    ('~flt', 0.0, ('fabs', 'a')) => ('fneu', 'a', 0.0)
 *    ('~flt', ('fneg', ('fabs', 'a')), 0.0) => ('fneu', 'a', 0.0)
 *    ('fge', 0.0, ('fabs', 'a')) => ('feq', 'a', 0.0)
 *    ('fge', ('fneg', ('fabs', 'a')), 0.0) => ('feq', 'a', 0.0)
 *    ('iand', ('fge', 'a', 0.0), ('fge', 1.0, 'a')) => ('feq', 'a', ('fsat', 'a'))
 *    ('fmax', ('b2f(is_used_once)', 'a@1'), ('b2f', 'b@1')) => ('b2f', ('ior', 'a', 'b'))
 *    ('fmax', ('fneg(is_used_once)', ('b2f(is_used_once)', 'a@1')), ('fneg', ('b2f', 'b@1'))) => ('fneg', ('b2f', ('iand', 'a', 'b')))
 *    ('fmin', ('b2f(is_used_once)', 'a@1'), ('b2f', 'b@1')) => ('b2f', ('iand', 'a', 'b'))
 *    ('fmin', ('fneg(is_used_once)', ('b2f(is_used_once)', 'a@1')), ('fneg', ('b2f', 'b@1'))) => ('fneg', ('b2f', ('ior', 'a', 'b')))
 *    ('fmin', ('b2f', 'a@1'), '#b') => ('bcsel', 'a', ('fmin', 'b', 1.0), ('fmin', 'b', 0.0))
 *    ('flt', ('fadd(is_used_once)', 'a', ('fneg', 'b')), 0.0) => ('flt', 'a', 'b')
 *    ('fge', ('fneg', ('fabs', 'a')), 0.0) => ('feq', 'a', 0.0)
 *    ('~bcsel', ('flt', 'b', 'a'), 'b', 'a') => ('fmin', 'a', 'b')
 *    ('~bcsel', ('flt', 'a', 'b'), 'b', 'a') => ('fmax', 'a', 'b')
 *    ('~bcsel', ('fge', 'a', 'b'), 'b', 'a') => ('fmin', 'a', 'b')
 *    ('~bcsel', ('fge', 'b', 'a'), 'b', 'a') => ('fmax', 'a', 'b')
 *    ('bcsel', ('inot', 'a'), 'b', 'c') => ('bcsel', 'a', 'c', 'b')
 *    ('bcsel', 'a', ('bcsel', 'a', 'b', 'c'), 'd') => ('bcsel', 'a', 'b', 'd')
 *    ('bcsel', 'a', 'b', ('bcsel', 'a', 'c', 'd')) => ('bcsel', 'a', 'b', 'd')
 *    ('bcsel', 'a', ('bcsel', 'b', 'c', 'd'), ('bcsel(is_used_once)', 'b', 'c', 'e')) => ('bcsel', 'b', 'c', ('bcsel', 'a', 'd', 'e'))
 *    ('bcsel', 'a', ('bcsel(is_used_once)', 'b', 'c', 'd'), ('bcsel', 'b', 'c', 'e')) => ('bcsel', 'b', 'c', ('bcsel', 'a', 'd', 'e'))
 *    ('bcsel', 'a', ('bcsel', 'b', 'c', 'd'), ('bcsel(is_used_once)', 'b', 'e', 'd')) => ('bcsel', 'b', ('bcsel', 'a', 'c', 'e'), 'd')
 *    ('bcsel', 'a', ('bcsel(is_used_once)', 'b', 'c', 'd'), ('bcsel', 'b', 'e', 'd')) => ('bcsel', 'b', ('bcsel', 'a', 'c', 'e'), 'd')
 *    ('bcsel', 'a', True, 'b') => ('ior', 'a', 'b')
 *    ('bcsel', 'a', 'a', 'b') => ('ior', 'a', 'b')
 *    ('bcsel', 'a', 'b', False) => ('iand', 'a', 'b')
 *    ('bcsel', 'a', 'b', 'a') => ('iand', 'a', 'b')
 *    ('~fmin', 'a', 'a') => a
 *    ('~fmax', 'a', 'a') => a
 *    ('imin', 'a', 'a') => a
 *    ('imax', 'a', 'a') => a
 *    ('umin', 'a', 'a') => a
 *    ('umin', 'a', 0) => 0
 *    ('umin', 'a', -1) => a
 *    ('umax', 'a', 'a') => a
 *    ('umax', 'a', 0) => a
 *    ('umax', 'a', -1) => -1
 *    ('fmax', ('fmax', 'a', 'b'), 'b') => ('fmax', 'a', 'b')
 *    ('umax', ('umax', 'a', 'b'), 'b') => ('umax', 'a', 'b')
 *    ('imax', ('imax', 'a', 'b'), 'b') => ('imax', 'a', 'b')
 *    ('fmin', ('fmin', 'a', 'b'), 'b') => ('fmin', 'a', 'b')
 *    ('umin', ('umin', 'a', 'b'), 'b') => ('umin', 'a', 'b')
 *    ('imin', ('imin', 'a', 'b'), 'b') => ('imin', 'a', 'b')
 *    ('fmax', ('fmax', ('fmax', 'a', 'b'), 'c'), 'a') => ('fmax', ('fmax', 'a', 'b'), 'c')
 *    ('umax', ('umax', ('umax', 'a', 'b'), 'c'), 'a') => ('umax', ('umax', 'a', 'b'), 'c')
 *    ('imax', ('imax', ('imax', 'a', 'b'), 'c'), 'a') => ('imax', ('imax', 'a', 'b'), 'c')
 *    ('fmin', ('fmin', ('fmin', 'a', 'b'), 'c'), 'a') => ('fmin', ('fmin', 'a', 'b'), 'c')
 *    ('umin', ('umin', ('umin', 'a', 'b'), 'c'), 'a') => ('umin', ('umin', 'a', 'b'), 'c')
 *    ('imin', ('imin', ('imin', 'a', 'b'), 'c'), 'a') => ('imin', ('imin', 'a', 'b'), 'c')
 *    ('ieq', ('b2i8', 'a@1'), ('b2i8', 'b@1')) => ('ieq', 'a', 'b')
 *    ('ine', ('b2i8', 'a@1'), ('b2i8', 'b@1')) => ('ine', 'a', 'b')
 *    ('ieq', ('b2i16', 'a@1'), ('b2i16', 'b@1')) => ('ieq', 'a', 'b')
 *    ('ine', ('b2i16', 'a@1'), ('b2i16', 'b@1')) => ('ine', 'a', 'b')
 *    ('ieq', ('b2i32', 'a@1'), ('b2i32', 'b@1')) => ('ieq', 'a', 'b')
 *    ('ine', ('b2i32', 'a@1'), ('b2i32', 'b@1')) => ('ine', 'a', 'b')
 *    ('ieq', ('b2i64', 'a@1'), ('b2i64', 'b@1')) => ('ieq', 'a', 'b')
 *    ('ine', ('b2i64', 'a@1'), ('b2i64', 'b@1')) => ('ine', 'a', 'b')
 *    ('feq', ('b2f16', 'a@1'), ('b2f16', 'b@1')) => ('ieq', 'a', 'b')
 *    ('fneu', ('b2f16', 'a@1'), ('b2f16', 'b@1')) => ('ine', 'a', 'b')
 *    ('feq', ('b2f32', 'a@1'), ('b2f32', 'b@1')) => ('ieq', 'a', 'b')
 *    ('fneu', ('b2f32', 'a@1'), ('b2f32', 'b@1')) => ('ine', 'a', 'b')
 *    ('feq', ('b2f64', 'a@1'), ('b2f64', 'b@1')) => ('ieq', 'a', 'b')
 *    ('fneu', ('b2f64', 'a@1'), ('b2f64', 'b@1')) => ('ine', 'a', 'b')
 *    ('iand@8', 'a', ('inot', ('ishr', 'a', 7))) => ('imax', 'a', 0)
 *    ('ieq', ('iand', 'a@8', 128), 0) => ('ige', 'a', 0)
 *    ('ine', ('iand', 'a@8', 128), 128) => ('ige', 'a', 0)
 *    ('ine', ('iand', 'a@8', 128), 0) => ('ilt', 'a', 0)
 *    ('ieq', ('iand', 'a@8', 128), 128) => ('ilt', 'a', 0)
 *    ('ine', ('ushr', 'a@8', 7), 0) => ('ilt', 'a', 0)
 *    ('ieq', ('ushr', 'a@8', 7), 0) => ('ige', 'a', 0)
 *    ('ieq', ('ushr', 'a@8', 7), 1) => ('ilt', 'a', 0)
 *    ('ine', ('ushr', 'a@8', 7), 1) => ('ige', 'a', 0)
 *    ('ine', ('ishr', 'a@8', 7), 0) => ('ilt', 'a', 0)
 *    ('ieq', ('ishr', 'a@8', 7), 0) => ('ige', 'a', 0)
 *    ('ieq', ('ishr', 'a@8', 7), -1) => ('ilt', 'a', 0)
 *    ('ine', ('ishr', 'a@8', 7), -1) => ('ige', 'a', 0)
 *    ('iand@16', 'a', ('inot', ('ishr', 'a', 15))) => ('imax', 'a', 0)
 *    ('ieq', ('iand', 'a@16', 32768), 0) => ('ige', 'a', 0)
 *    ('ine', ('iand', 'a@16', 32768), 32768) => ('ige', 'a', 0)
 *    ('ine', ('iand', 'a@16', 32768), 0) => ('ilt', 'a', 0)
 *    ('ieq', ('iand', 'a@16', 32768), 32768) => ('ilt', 'a', 0)
 *    ('ine', ('ushr', 'a@16', 15), 0) => ('ilt', 'a', 0)
 *    ('ieq', ('ushr', 'a@16', 15), 0) => ('ige', 'a', 0)
 *    ('ieq', ('ushr', 'a@16', 15), 1) => ('ilt', 'a', 0)
 *    ('ine', ('ushr', 'a@16', 15), 1) => ('ige', 'a', 0)
 *    ('ine', ('ishr', 'a@16', 15), 0) => ('ilt', 'a', 0)
 *    ('ieq', ('ishr', 'a@16', 15), 0) => ('ige', 'a', 0)
 *    ('ieq', ('ishr', 'a@16', 15), -1) => ('ilt', 'a', 0)
 *    ('ine', ('ishr', 'a@16', 15), -1) => ('ige', 'a', 0)
 *    ('iand@32', 'a', ('inot', ('ishr', 'a', 31))) => ('imax', 'a', 0)
 *    ('ieq', ('iand', 'a@32', 2147483648), 0) => ('ige', 'a', 0)
 *    ('ine', ('iand', 'a@32', 2147483648), 2147483648) => ('ige', 'a', 0)
 *    ('ine', ('iand', 'a@32', 2147483648), 0) => ('ilt', 'a', 0)
 *    ('ieq', ('iand', 'a@32', 2147483648), 2147483648) => ('ilt', 'a', 0)
 *    ('ine', ('ushr', 'a@32', 31), 0) => ('ilt', 'a', 0)
 *    ('ieq', ('ushr', 'a@32', 31), 0) => ('ige', 'a', 0)
 *    ('ieq', ('ushr', 'a@32', 31), 1) => ('ilt', 'a', 0)
 *    ('ine', ('ushr', 'a@32', 31), 1) => ('ige', 'a', 0)
 *    ('ine', ('ishr', 'a@32', 31), 0) => ('ilt', 'a', 0)
 *    ('ieq', ('ishr', 'a@32', 31), 0) => ('ige', 'a', 0)
 *    ('ieq', ('ishr', 'a@32', 31), -1) => ('ilt', 'a', 0)
 *    ('ine', ('ishr', 'a@32', 31), -1) => ('ige', 'a', 0)
 *    ('iand@64', 'a', ('inot', ('ishr', 'a', 63))) => ('imax', 'a', 0)
 *    ('ieq', ('iand', 'a@64', 9223372036854775808), 0) => ('ige', 'a', 0)
 *    ('ine', ('iand', 'a@64', 9223372036854775808), 9223372036854775808) => ('ige', 'a', 0)
 *    ('ine', ('iand', 'a@64', 9223372036854775808), 0) => ('ilt', 'a', 0)
 *    ('ieq', ('iand', 'a@64', 9223372036854775808), 9223372036854775808) => ('ilt', 'a', 0)
 *    ('ine', ('ushr', 'a@64', 63), 0) => ('ilt', 'a', 0)
 *    ('ieq', ('ushr', 'a@64', 63), 0) => ('ige', 'a', 0)
 *    ('ieq', ('ushr', 'a@64', 63), 1) => ('ilt', 'a', 0)
 *    ('ine', ('ushr', 'a@64', 63), 1) => ('ige', 'a', 0)
 *    ('ine', ('ishr', 'a@64', 63), 0) => ('ilt', 'a', 0)
 *    ('ieq', ('ishr', 'a@64', 63), 0) => ('ige', 'a', 0)
 *    ('ieq', ('ishr', 'a@64', 63), -1) => ('ilt', 'a', 0)
 *    ('ine', ('ishr', 'a@64', 63), -1) => ('ige', 'a', 0)
 *    ('fmin', 'a', ('fneg', 'a')) => ('fneg', ('fabs', 'a'))
 *    ('imin', 'a', ('ineg', 'a')) => ('ineg', ('iabs', 'a'))
 *    ('fmin', 'a', ('fneg', ('fabs', 'a'))) => ('fneg', ('fabs', 'a'))
 *    ('imin', 'a', ('ineg', ('iabs', 'a'))) => ('ineg', ('iabs', 'a'))
 *    ('~fmin', 'a', ('fabs', 'a')) => a
 *    ('imin', 'a', ('iabs', 'a')) => a
 *    ('~fmax', 'a', ('fneg', ('fabs', 'a'))) => a
 *    ('imax', 'a', ('ineg', ('iabs', 'a'))) => a
 *    ('fmax', 'a', ('fabs', 'a')) => ('fabs', 'a')
 *    ('imax', 'a', ('iabs', 'a')) => ('iabs', 'a')
 *    ('fmax', 'a', ('fneg', 'a')) => ('fabs', 'a')
 *    ('imax', 'a', ('ineg', 'a')) => ('iabs', 'a')
 *    ('~fmax', ('fabs', 'a'), 0.0) => ('fabs', 'a')
 *    ('fmin', ('fmax', 'a', 0.0), 1.0) => ('fsat', 'a')
 *    ('~fmax', ('fmin', 'a', 1.0), 0.0) => ('fsat', 'a')
 *    ('~fmin', ('fmax', 'a', -1.0), 0.0) => ('fneg', ('fsat', ('fneg', 'a')))
 *    ('~fmax', ('fmin', 'a', 0.0), -1.0) => ('fneg', ('fsat', ('fneg', 'a')))
 *    ('fsat', ('fsign', 'a')) => ('b2f', ('!flt', 0.0, 'a'))
 *    ('fsat', ('b2f', 'a')) => ('b2f', 'a')
 *    ('fsat', 'a') => ('fmin', ('fmax', 'a', 0.0), 1.0)
 *    ('fsat', ('fsat', 'a')) => ('fsat', 'a')
 *    ('fsat', ('fneg(is_used_once)', ('fadd(is_used_once)', 'a', 'b'))) => ('fsat', ('fadd', ('fneg', 'a'), ('fneg', 'b')))
 *    ('fsat', ('fneg(is_used_once)', ('fmul(is_used_once)', 'a', 'b'))) => ('fsat', ('fmul', ('fneg', 'a'), 'b'))
 *    ('fsat(nsz)', ('fneg(is_used_once)', ('fmulz(is_used_once)', 'a', 'b'))) => ('fsat', ('fmulz', ('fneg', 'a'), 'b'))
 *    ('fsat', ('fabs(is_used_once)', ('fmul(is_used_once)', 'a', 'b'))) => ('fsat', ('fmul', ('fabs', 'a'), ('fabs', 'b')))
 *    ('fmin', ('fmax', ('fmin', ('fmax', 'a', 'b'), 'c'), 'b'), 'c') => ('fmin', ('fmax', 'a', 'b'), 'c')
 *    ('imin', ('imax', ('imin', ('imax', 'a', 'b'), 'c'), 'b'), 'c') => ('imin', ('imax', 'a', 'b'), 'c')
 *    ('umin', ('umax', ('umin', ('umax', 'a', 'b'), 'c'), 'b'), 'c') => ('umin', ('umax', 'a', 'b'), 'c')
 *    ('fmax', ('fsat', 'a'), '#b(is_zero_to_one)') => ('fsat', ('fmax', 'a', 'b'))
 *    ('fmax', ('fsat(is_used_once)', 'a'), ('fsat(is_used_once)', 'b')) => ('fsat', ('fmax', 'a', 'b'))
 *    ('~fmin', ('fsat', 'a'), '#b(is_zero_to_one)') => ('fsat', ('fmin', 'a', 'b'))
 *    ('fsat', ('fadd', 1.0, 'a(is_ge_zero)')) => 1.0
 *    ('fneg', ('bcsel(is_used_once)', 'a', '#b', '#c')) => ('bcsel', 'a', ('fneg', 'b'), ('fneg', 'c'))
 *    ('fmax', ('fneg', ('fmin', 'b', 'a')), 'b') => ('fmax', ('fabs', 'b'), ('fneg', 'a'))
 *    ('fmin', ('fneg', ('fmax', 'b', 'a')), 'b') => ('fmin', ('fneg', ('fabs', 'b')), ('fneg', 'a'))
 *    ('fmax', ('fadd(is_used_once)', ('fneg', 'a(is_not_negative)'), '#b(is_zero_to_one)'), 0.0) => ('fsat', ('fadd', ('fneg', 'a'), 'b'))
 *    ('extract_u8', ('imin', ('imax', 'a', 0), 255), 0) => ('imin', ('imax', 'a', 0), 255)
 *    ('ior', ('flt(is_used_once)', 'a', 'b'), ('flt', 'a', 'c')) => ('flt', 'a', ('!fmax', 'b', 'c'))
 *    ('ior', ('flt(is_used_once)', 'a', 'c'), ('flt', 'b', 'c')) => ('flt', ('!fmin', 'a', 'b'), 'c')
 *    ('ior', ('fge(is_used_once)', 'a', 'b'), ('fge', 'a', 'c')) => ('fge', 'a', ('!fmin', 'b', 'c'))
 *    ('ior', ('fge(is_used_once)', 'a', 'c'), ('fge', 'b', 'c')) => ('fge', ('!fmax', 'a', 'b'), 'c')
 *    ('ior', ('flt', 'a', '#b'), ('flt', 'a', '#c')) => ('flt', 'a', ('!fmax', 'b', 'c'))
 *    ('ior', ('flt', '#a', 'c'), ('flt', '#b', 'c')) => ('flt', ('!fmin', 'a', 'b'), 'c')
 *    ('ior', ('fge', 'a', '#b'), ('fge', 'a', '#c')) => ('fge', 'a', ('!fmin', 'b', 'c'))
 *    ('ior', ('fge', '#a', 'c'), ('fge', '#b', 'c')) => ('fge', ('!fmax', 'a', 'b'), 'c')
 *    ('~iand', ('flt(is_used_once)', 'a', 'b'), ('flt', 'a', 'c')) => ('flt', 'a', ('fmin', 'b', 'c'))
 *    ('~iand', ('flt(is_used_once)', 'a', 'c'), ('flt', 'b', 'c')) => ('flt', ('fmax', 'a', 'b'), 'c')
 *    ('~iand', ('fge(is_used_once)', 'a', 'b'), ('fge', 'a', 'c')) => ('fge', 'a', ('fmax', 'b', 'c'))
 *    ('~iand', ('fge(is_used_once)', 'a', 'c'), ('fge', 'b', 'c')) => ('fge', ('fmin', 'a', 'b'), 'c')
 *    ('iand', ('flt', 'a', '#b(is_a_number)'), ('flt', 'a', '#c(is_a_number)')) => ('flt', 'a', ('fmin', 'b', 'c'))
 *    ('iand', ('flt', '#a(is_a_number)', 'c'), ('flt', '#b(is_a_number)', 'c')) => ('flt', ('fmax', 'a', 'b'), 'c')
 *    ('iand', ('fge', 'a', '#b(is_a_number)'), ('fge', 'a', '#c(is_a_number)')) => ('fge', 'a', ('fmax', 'b', 'c'))
 *    ('iand', ('fge', '#a(is_a_number)', 'c'), ('fge', '#b(is_a_number)', 'c')) => ('fge', ('fmin', 'a', 'b'), 'c')
 *    ('ior', ('ilt(is_used_once)', 'a', 'b'), ('ilt', 'a', 'c')) => ('ilt', 'a', ('imax', 'b', 'c'))
 *    ('ior', ('ilt(is_used_once)', 'a', 'c'), ('ilt', 'b', 'c')) => ('ilt', ('imin', 'a', 'b'), 'c')
 *    ('ior', ('ige(is_used_once)', 'a', 'b'), ('ige', 'a', 'c')) => ('ige', 'a', ('imin', 'b', 'c'))
 *    ('ior', ('ige(is_used_once)', 'a', 'c'), ('ige', 'b', 'c')) => ('ige', ('imax', 'a', 'b'), 'c')
 *    ('ior', ('ult(is_used_once)', 'a', 'b'), ('ult', 'a', 'c')) => ('ult', 'a', ('umax', 'b', 'c'))
 *    ('ior', ('ult(is_used_once)', 'a', 'c'), ('ult', 'b', 'c')) => ('ult', ('umin', 'a', 'b'), 'c')
 *    ('ior', ('uge(is_used_once)', 'a', 'b'), ('uge', 'a', 'c')) => ('uge', 'a', ('umin', 'b', 'c'))
 *    ('ior', ('uge(is_used_once)', 'a', 'c'), ('uge', 'b', 'c')) => ('uge', ('umax', 'a', 'b'), 'c')
 *    ('iand', ('ilt(is_used_once)', 'a', 'b'), ('ilt', 'a', 'c')) => ('ilt', 'a', ('imin', 'b', 'c'))
 *    ('iand', ('ilt(is_used_once)', 'a', 'c'), ('ilt', 'b', 'c')) => ('ilt', ('imax', 'a', 'b'), 'c')
 *    ('iand', ('ige(is_used_once)', 'a', 'b'), ('ige', 'a', 'c')) => ('ige', 'a', ('imax', 'b', 'c'))
 *    ('iand', ('ige(is_used_once)', 'a', 'c'), ('ige', 'b', 'c')) => ('ige', ('imin', 'a', 'b'), 'c')
 *    ('iand', ('ult(is_used_once)', 'a', 'b'), ('ult', 'a', 'c')) => ('ult', 'a', ('umin', 'b', 'c'))
 *    ('iand', ('ult(is_used_once)', 'a', 'c'), ('ult', 'b', 'c')) => ('ult', ('umax', 'a', 'b'), 'c')
 *    ('iand', ('uge(is_used_once)', 'a', 'b'), ('uge', 'a', 'c')) => ('uge', 'a', ('umax', 'b', 'c'))
 *    ('iand', ('uge(is_used_once)', 'a', 'c'), ('uge', 'b', 'c')) => ('uge', ('umin', 'a', 'b'), 'c')
 *    ('ior', ('ior(is_used_once)', ('flt(is_used_once)', 'a', 'c'), 'd'), ('flt', 'b', 'c')) => ('ior', ('flt', ('!fmin', 'a', 'b'), 'c'), 'd')
 *    ('ior', ('ior(is_used_once)', ('flt', 'a', 'c'), 'd'), ('flt(is_used_once)', 'b', 'c')) => ('ior', ('flt', ('!fmin', 'a', 'b'), 'c'), 'd')
 *    ('ior', ('ior(is_used_once)', ('flt(is_used_once)', 'a', 'b'), 'd'), ('flt', 'a', 'c')) => ('ior', ('flt', 'a', ('!fmax', 'b', 'c')), 'd')
 *    ('ior', ('ior(is_used_once)', ('flt', 'a', 'b'), 'd'), ('flt(is_used_once)', 'a', 'c')) => ('ior', ('flt', 'a', ('!fmax', 'b', 'c')), 'd')
 *    ('ior', ('flt', 'a(is_a_number)', 'b(is_a_number)'), ('flt', 'b', 'a')) => ('fneu', 'a', 'b')
 *    ('umin', ('iand', 'a', '#b(is_pos_power_of_two)'), ('iand', 'c', 'b')) => ('iand', ('iand', 'a', 'b'), ('iand', 'c', 'b'))
 *    ('ior', ('flt(is_used_once)', 0.0, 'a@16'), ('flt', 'b@16', 0.0)) => ('flt', 0.0, ('fmax', 'a', ('fneg', 'b')))
 *    ('ior', ('flt', 0.0, 'a@16'), ('flt(is_used_once)', 'b@16', 0.0)) => ('flt', 0.0, ('fmax', 'a', ('fneg', 'b')))
 *    ('ior', ('fge(is_used_once)', 0.0, 'a@16'), ('fge', 'b@16', 0.0)) => ('fge', 0.0, ('fmin', 'a', ('fneg', 'b')))
 *    ('ior', ('fge', 0.0, 'a@16'), ('fge(is_used_once)', 'b@16', 0.0)) => ('fge', 0.0, ('fmin', 'a', ('fneg', 'b')))
 *    ('~iand', ('flt(is_used_once)', 0.0, 'a@16'), ('flt', 'b@16', 0.0)) => ('flt', 0.0, ('fmin', 'a', ('fneg', 'b')))
 *    ('~iand', ('flt', 0.0, 'a@16'), ('flt(is_used_once)', 'b@16', 0.0)) => ('flt', 0.0, ('fmin', 'a', ('fneg', 'b')))
 *    ('~iand', ('fge(is_used_once)', 0.0, 'a@16'), ('fge', 'b@16', 0.0)) => ('fge', 0.0, ('fmax', 'a', ('fneg', 'b')))
 *    ('~iand', ('fge', 0.0, 'a@16'), ('fge(is_used_once)', 'b@16', 0.0)) => ('fge', 0.0, ('fmax', 'a', ('fneg', 'b')))
 *    ('ior', ('feq(is_used_once)', 'a@16', 0.0), ('feq', 'b@16', 0.0)) => ('feq', ('fmin', ('fabs', 'a'), ('fabs', 'b')), 0.0)
 *    ('ior', ('fneu(is_used_once)', 'a@16', 0.0), ('fneu', 'b@16', 0.0)) => ('fneu', ('fadd', ('fabs', 'a'), ('fabs', 'b')), 0.0)
 *    ('iand', ('feq(is_used_once)', 'a@16', 0.0), ('feq', 'b@16', 0.0)) => ('feq', ('fadd', ('fabs', 'a'), ('fabs', 'b')), 0.0)
 *    ('iand', ('fneu(is_used_once)', 'a@16', 0.0), ('fneu', 'b@16', 0.0)) => ('fneu', ('fmin', ('fabs', 'a'), ('fabs', 'b')), 0.0)
 *    ('bcsel@16', ('feq', 'a', 0.0), 1.0, ('i2f16', ('iadd', ('b2i16', ('flt', 0.0, 'a@16')), ('ineg', ('b2i16', ('flt', 'a@16', 0.0)))))) => ('i2f16', ('iadd', ('b2i32', ('!fge', 'a', 0.0)), ('ineg', ('b2i32', ('!flt', 'a', 0.0)))))
 *    ('bcsel', 'a', ('b2f(is_used_once)', 'b@16'), ('b2f', 'c@16')) => ('b2f', ('bcsel', 'a', 'b', 'c'))
 *    ('~i2f16', ('f2i', 'a@16')) => ('ftrunc', 'a')
 *    ('~f2i16', ('i2f', 'a@16')) => a
 *    ('~f2i16', ('u2f', 'a@16')) => a
 *    ('~f2u16', ('i2f', 'a@16')) => a
 *    ('~f2u16', ('u2f', 'a@16')) => a
 *    ('fadd', ('b2f16', ('flt', 0.0, 'a@16')), ('fneg', ('b2f16', ('flt', 'a@16', 0.0)))) => ('fsign', 'a')
 *    ('iadd', ('b2i16', ('flt', 0, 'a@16')), ('ineg', ('b2i16', ('flt', 'a@16', 0)))) => ('f2i16', ('fsign', 'a'))
 *    ('~f2f16', ('f2f', 'a')) => ('f2f16', 'a')
 *    ('~f2f16', ('u2f', 'a')) => ('u2f16', 'a')
 *    ('~f2f16', ('i2f', 'a')) => ('i2f16', 'a')
 *    ('~f2u16', ('f2f', 'a')) => ('f2u16', 'a')
 *    ('~f2i16', ('f2f', 'a')) => ('f2i16', 'a')
 *    ('i2f16', ('f2i', ('fsign', 'a@16'))) => ('fsign', 'a')
 *    ('~f2f16', ('f2f32', 'a@16')) => a
 *    ('f2u32', ('f2f32', 'a@16')) => ('f2u32', 'a')
 *    ('f2i32', ('f2f32', 'a@16')) => ('f2i32', 'a')
 *    ('f2f16', ('u2f32', 'a')) => ('u2f16', 'a')
 *    ('f2f16', ('i2f32', 'a')) => ('i2f16', 'a')
 *    ('~f2f16', ('f2f64', 'a@16')) => a
 *    ('f2u64', ('f2f64', 'a@16')) => ('f2u64', 'a')
 *    ('f2i64', ('f2f64', 'a@16')) => ('f2i64', 'a')
 *    ('f2f16', ('u2f64', 'a')) => ('u2f16', 'a')
 *    ('f2f16', ('i2f64', 'a')) => ('i2f16', 'a')
 *    ('ior', ('flt(is_used_once)', 0.0, 'a@32'), ('flt', 'b@32', 0.0)) => ('flt', 0.0, ('fmax', 'a', ('fneg', 'b')))
 *    ('ior', ('flt', 0.0, 'a@32'), ('flt(is_used_once)', 'b@32', 0.0)) => ('flt', 0.0, ('fmax', 'a', ('fneg', 'b')))
 *    ('ior', ('fge(is_used_once)', 0.0, 'a@32'), ('fge', 'b@32', 0.0)) => ('fge', 0.0, ('fmin', 'a', ('fneg', 'b')))
 *    ('ior', ('fge', 0.0, 'a@32'), ('fge(is_used_once)', 'b@32', 0.0)) => ('fge', 0.0, ('fmin', 'a', ('fneg', 'b')))
 *    ('~iand', ('flt(is_used_once)', 0.0, 'a@32'), ('flt', 'b@32', 0.0)) => ('flt', 0.0, ('fmin', 'a', ('fneg', 'b')))
 *    ('~iand', ('flt', 0.0, 'a@32'), ('flt(is_used_once)', 'b@32', 0.0)) => ('flt', 0.0, ('fmin', 'a', ('fneg', 'b')))
 *    ('~iand', ('fge(is_used_once)', 0.0, 'a@32'), ('fge', 'b@32', 0.0)) => ('fge', 0.0, ('fmax', 'a', ('fneg', 'b')))
 *    ('~iand', ('fge', 0.0, 'a@32'), ('fge(is_used_once)', 'b@32', 0.0)) => ('fge', 0.0, ('fmax', 'a', ('fneg', 'b')))
 *    ('ior', ('feq(is_used_once)', 'a@32', 0.0), ('feq', 'b@32', 0.0)) => ('feq', ('fmin', ('fabs', 'a'), ('fabs', 'b')), 0.0)
 *    ('ior', ('fneu(is_used_once)', 'a@32', 0.0), ('fneu', 'b@32', 0.0)) => ('fneu', ('fadd', ('fabs', 'a'), ('fabs', 'b')), 0.0)
 *    ('iand', ('feq(is_used_once)', 'a@32', 0.0), ('feq', 'b@32', 0.0)) => ('feq', ('fadd', ('fabs', 'a'), ('fabs', 'b')), 0.0)
 *    ('iand', ('fneu(is_used_once)', 'a@32', 0.0), ('fneu', 'b@32', 0.0)) => ('fneu', ('fmin', ('fabs', 'a'), ('fabs', 'b')), 0.0)
 *    ('bcsel@32', ('feq', 'a', 0.0), 1.0, ('i2f32', ('iadd', ('b2i32', ('flt', 0.0, 'a@32')), ('ineg', ('b2i32', ('flt', 'a@32', 0.0)))))) => ('i2f32', ('iadd', ('b2i32', ('!fge', 'a', 0.0)), ('ineg', ('b2i32', ('!flt', 'a', 0.0)))))
 *    ('bcsel', 'a', ('b2f(is_used_once)', 'b@32'), ('b2f', 'c@32')) => ('b2f', ('bcsel', 'a', 'b', 'c'))
 *    ('~i2f32', ('f2i', 'a@32')) => ('ftrunc', 'a')
 *    ('~f2i32', ('i2f', 'a@32')) => a
 *    ('~f2i32', ('u2f', 'a@32')) => a
 *    ('~f2u32', ('i2f', 'a@32')) => a
 *    ('~f2u32', ('u2f', 'a@32')) => a
 *    ('fadd', ('b2f32', ('flt', 0.0, 'a@32')), ('fneg', ('b2f32', ('flt', 'a@32', 0.0)))) => ('fsign', 'a')
 *    ('iadd', ('b2i32', ('flt', 0, 'a@32')), ('ineg', ('b2i32', ('flt', 'a@32', 0)))) => ('f2i32', ('fsign', 'a'))
 *    ('~f2f32', ('f2f', 'a')) => ('f2f32', 'a')
 *    ('~f2f32', ('u2f', 'a')) => ('u2f32', 'a')
 *    ('~f2f32', ('i2f', 'a')) => ('i2f32', 'a')
 *    ('~f2u32', ('f2f', 'a')) => ('f2u32', 'a')
 *    ('~f2i32', ('f2f', 'a')) => ('f2i32', 'a')
 *    ('i2f32', ('f2i', ('fsign', 'a@32'))) => ('fsign', 'a')
 *    ('~f2f32', ('f2f64', 'a@32')) => a
 *    ('f2u64', ('f2f64', 'a@32')) => ('f2u64', 'a')
 *    ('f2i64', ('f2f64', 'a@32')) => ('f2i64', 'a')
 *    ('f2f32', ('u2f64', 'a')) => ('u2f32', 'a')
 *    ('f2f32', ('i2f64', 'a')) => ('i2f32', 'a')
 *    ('ior', ('flt(is_used_once)', 0.0, 'a@64'), ('flt', 'b@64', 0.0)) => ('flt', 0.0, ('fmax', 'a', ('fneg', 'b')))
 *    ('ior', ('flt', 0.0, 'a@64'), ('flt(is_used_once)', 'b@64', 0.0)) => ('flt', 0.0, ('fmax', 'a', ('fneg', 'b')))
 *    ('ior', ('fge(is_used_once)', 0.0, 'a@64'), ('fge', 'b@64', 0.0)) => ('fge', 0.0, ('fmin', 'a', ('fneg', 'b')))
 *    ('ior', ('fge', 0.0, 'a@64'), ('fge(is_used_once)', 'b@64', 0.0)) => ('fge', 0.0, ('fmin', 'a', ('fneg', 'b')))
 *    ('~iand', ('flt(is_used_once)', 0.0, 'a@64'), ('flt', 'b@64', 0.0)) => ('flt', 0.0, ('fmin', 'a', ('fneg', 'b')))
 *    ('~iand', ('flt', 0.0, 'a@64'), ('flt(is_used_once)', 'b@64', 0.0)) => ('flt', 0.0, ('fmin', 'a', ('fneg', 'b')))
 *    ('~iand', ('fge(is_used_once)', 0.0, 'a@64'), ('fge', 'b@64', 0.0)) => ('fge', 0.0, ('fmax', 'a', ('fneg', 'b')))
 *    ('~iand', ('fge', 0.0, 'a@64'), ('fge(is_used_once)', 'b@64', 0.0)) => ('fge', 0.0, ('fmax', 'a', ('fneg', 'b')))
 *    ('ior', ('feq(is_used_once)', 'a@64', 0.0), ('feq', 'b@64', 0.0)) => ('feq', ('fmin', ('fabs', 'a'), ('fabs', 'b')), 0.0)
 *    ('ior', ('fneu(is_used_once)', 'a@64', 0.0), ('fneu', 'b@64', 0.0)) => ('fneu', ('fadd', ('fabs', 'a'), ('fabs', 'b')), 0.0)
 *    ('iand', ('feq(is_used_once)', 'a@64', 0.0), ('feq', 'b@64', 0.0)) => ('feq', ('fadd', ('fabs', 'a'), ('fabs', 'b')), 0.0)
 *    ('iand', ('fneu(is_used_once)', 'a@64', 0.0), ('fneu', 'b@64', 0.0)) => ('fneu', ('fmin', ('fabs', 'a'), ('fabs', 'b')), 0.0)
 *    ('bcsel@64', ('feq', 'a', 0.0), 1.0, ('i2f64', ('iadd', ('b2i64', ('flt', 0.0, 'a@64')), ('ineg', ('b2i64', ('flt', 'a@64', 0.0)))))) => ('i2f64', ('iadd', ('b2i32', ('!fge', 'a', 0.0)), ('ineg', ('b2i32', ('!flt', 'a', 0.0)))))
 *    ('bcsel', 'a', ('b2f(is_used_once)', 'b@64'), ('b2f', 'c@64')) => ('b2f', ('bcsel', 'a', 'b', 'c'))
 *    ('~i2f64', ('f2i', 'a@64')) => ('ftrunc', 'a')
 *    ('~f2i64', ('i2f', 'a@64')) => a
 *    ('~f2i64', ('u2f', 'a@64')) => a
 *    ('~f2u64', ('i2f', 'a@64')) => a
 *    ('~f2u64', ('u2f', 'a@64')) => a
 *    ('fadd', ('b2f64', ('flt', 0.0, 'a@64')), ('fneg', ('b2f64', ('flt', 'a@64', 0.0)))) => ('fsign', 'a')
 *    ('iadd', ('b2i64', ('flt', 0, 'a@64')), ('ineg', ('b2i64', ('flt', 'a@64', 0)))) => ('f2i64', ('fsign', 'a'))
 *    ('~f2f64', ('f2f', 'a')) => ('f2f64', 'a')
 *    ('~f2f64', ('u2f', 'a')) => ('u2f64', 'a')
 *    ('~f2f64', ('i2f', 'a')) => ('i2f64', 'a')
 *    ('~f2u64', ('f2f', 'a')) => ('f2u64', 'a')
 *    ('~f2i64', ('f2f', 'a')) => ('f2i64', 'a')
 *    ('i2f64', ('f2i', ('fsign', 'a@64'))) => ('fsign', 'a')
 *    ('i2i1', ('i2i8', 'a@1')) => a
 *    ('u2u1', ('u2u8', 'a@1')) => a
 *    ('i2i1', ('i2i16', 'a@1')) => a
 *    ('u2u1', ('u2u16', 'a@1')) => a
 *    ('u2f16', ('u2u8', 'a@1')) => ('u2f16', 'a')
 *    ('i2f16', ('i2i8', 'a@1')) => ('i2f16', 'a')
 *    ('u2f16', ('u2u16', 'a@1')) => ('u2f16', 'a')
 *    ('i2f16', ('i2i16', 'a@1')) => ('i2f16', 'a')
 *    ('u2f16', ('u2u32', 'a@1')) => ('u2f16', 'a')
 *    ('i2f16', ('i2i32', 'a@1')) => ('i2f16', 'a')
 *    ('u2f16', ('u2u64', 'a@1')) => ('u2f16', 'a')
 *    ('i2f16', ('i2i64', 'a@1')) => ('i2f16', 'a')
 *    ('i2i1', ('i2i32', 'a@1')) => a
 *    ('u2u1', ('u2u32', 'a@1')) => a
 *    ('u2f32', ('u2u8', 'a@1')) => ('u2f32', 'a')
 *    ('i2f32', ('i2i8', 'a@1')) => ('i2f32', 'a')
 *    ('u2f32', ('u2u16', 'a@1')) => ('u2f32', 'a')
 *    ('i2f32', ('i2i16', 'a@1')) => ('i2f32', 'a')
 *    ('u2f32', ('u2u32', 'a@1')) => ('u2f32', 'a')
 *    ('i2f32', ('i2i32', 'a@1')) => ('i2f32', 'a')
 *    ('u2f32', ('u2u64', 'a@1')) => ('u2f32', 'a')
 *    ('i2f32', ('i2i64', 'a@1')) => ('i2f32', 'a')
 *    ('i2i1', ('i2i64', 'a@1')) => a
 *    ('u2u1', ('u2u64', 'a@1')) => a
 *    ('u2f64', ('u2u8', 'a@1')) => ('u2f64', 'a')
 *    ('i2f64', ('i2i8', 'a@1')) => ('i2f64', 'a')
 *    ('u2f64', ('u2u16', 'a@1')) => ('u2f64', 'a')
 *    ('i2f64', ('i2i16', 'a@1')) => ('i2f64', 'a')
 *    ('u2f64', ('u2u32', 'a@1')) => ('u2f64', 'a')
 *    ('i2f64', ('i2i32', 'a@1')) => ('i2f64', 'a')
 *    ('u2f64', ('u2u64', 'a@1')) => ('u2f64', 'a')
 *    ('i2f64', ('i2i64', 'a@1')) => ('i2f64', 'a')
 *    ('i2i8', ('i2i16', 'a@8')) => a
 *    ('u2u8', ('u2u16', 'a@8')) => a
 *    ('u2f16', ('u2u16', 'a@8')) => ('u2f16', 'a')
 *    ('i2f16', ('i2i16', 'a@8')) => ('i2f16', 'a')
 *    ('u2f16', ('u2u32', 'a@8')) => ('u2f16', 'a')
 *    ('i2f16', ('i2i32', 'a@8')) => ('i2f16', 'a')
 *    ('u2f16', ('u2u64', 'a@8')) => ('u2f16', 'a')
 *    ('i2f16', ('i2i64', 'a@8')) => ('i2f16', 'a')
 *    ('i2i8', ('i2i32', 'a@8')) => a
 *    ('u2u8', ('u2u32', 'a@8')) => a
 *    ('u2f32', ('u2u16', 'a@8')) => ('u2f32', 'a')
 *    ('i2f32', ('i2i16', 'a@8')) => ('i2f32', 'a')
 *    ('u2f32', ('u2u32', 'a@8')) => ('u2f32', 'a')
 *    ('i2f32', ('i2i32', 'a@8')) => ('i2f32', 'a')
 *    ('u2f32', ('u2u64', 'a@8')) => ('u2f32', 'a')
 *    ('i2f32', ('i2i64', 'a@8')) => ('i2f32', 'a')
 *    ('i2i8', ('i2i64', 'a@8')) => a
 *    ('u2u8', ('u2u64', 'a@8')) => a
 *    ('u2f64', ('u2u16', 'a@8')) => ('u2f64', 'a')
 *    ('i2f64', ('i2i16', 'a@8')) => ('i2f64', 'a')
 *    ('u2f64', ('u2u32', 'a@8')) => ('u2f64', 'a')
 *    ('i2f64', ('i2i32', 'a@8')) => ('i2f64', 'a')
 *    ('u2f64', ('u2u64', 'a@8')) => ('u2f64', 'a')
 *    ('i2f64', ('i2i64', 'a@8')) => ('i2f64', 'a')
 *    ('i2i16', ('i2i32', 'a@16')) => a
 *    ('u2u16', ('u2u32', 'a@16')) => a
 *    ('u2f32', ('u2u32', 'a@16')) => ('u2f32', 'a')
 *    ('i2f32', ('i2i32', 'a@16')) => ('i2f32', 'a')
 *    ('u2f32', ('u2u64', 'a@16')) => ('u2f32', 'a')
 *    ('i2f32', ('i2i64', 'a@16')) => ('i2f32', 'a')
 *    ('i2i16', ('i2i64', 'a@16')) => a
 *    ('u2u16', ('u2u64', 'a@16')) => a
 *    ('u2f64', ('u2u32', 'a@16')) => ('u2f64', 'a')
 *    ('i2f64', ('i2i32', 'a@16')) => ('i2f64', 'a')
 *    ('u2f64', ('u2u64', 'a@16')) => ('u2f64', 'a')
 *    ('i2f64', ('i2i64', 'a@16')) => ('i2f64', 'a')
 *    ('i2i32', ('i2i64', 'a@32')) => a
 *    ('u2u32', ('u2u64', 'a@32')) => a
 *    ('u2f64', ('u2u64', 'a@32')) => ('u2f64', 'a')
 *    ('i2f64', ('i2i64', 'a@32')) => ('i2f64', 'a')
 *    ('f2fmp', ('u2f32', 'a@32')) => ('u2fmp', 'a')
 *    ('f2fmp', ('i2f32', 'a@32')) => ('i2fmp', 'a')
 *    ('f2u16', ('f2fmp', 'a@32')) => ('f2u16', 'a')
 *    ('f2i16', ('f2fmp', 'a@32')) => ('f2i16', 'a')
 *    ('i2imp', ('f2u32', 'a@32')) => ('f2ump', 'a')
 *    ('i2imp', ('f2i32', 'a@32')) => ('f2imp', 'a')
 *    ('u2f16', ('i2imp', 'a@32')) => ('u2f16', 'a')
 *    ('i2f16', ('i2imp', 'a@32')) => ('i2f16', 'a')
 *    ('iand', ('u2u16', ('u2u8', 'a@16')), '#b') => ('iand', 'a', ('iand', 'b', 255))
 *    ('u2u16', ('u2u8(is_used_once)', ('iand', 'a@16', '#b'))) => ('iand', 'a', ('iand', 'b', 255))
 *    ('u2u8', ('iand', ('u2u16', ('u2u8', 'a@16')), ('u2u16', ('u2u8', 'b@16')))) => ('u2u8', ('iand', 'a', 'b'))
 *    ('u2u8', ('iand', ('u2u16', ('u2u8', 'a@32')), ('u2u16', ('u2u8', 'b@32')))) => ('u2u8', ('iand', 'a', 'b'))
 *    ('iand', ('extract_i8', 'a', '#b'), ('extract_i8', 'c', 'b')) => ('extract_i8', ('iand', 'a', 'c'), 'b')
 *    ('iand', ('extract_u8', 'a', '#b'), ('extract_u8', 'c', 'b')) => ('extract_u8', ('iand', 'a', 'c'), 'b')
 *    ('iand', ('extract_i16', 'a', '#b'), ('extract_i16', 'c', 'b')) => ('extract_i16', ('iand', 'a', 'c'), 'b')
 *    ('iand', ('extract_u16', 'a', '#b'), ('extract_u16', 'c', 'b')) => ('extract_u16', ('iand', 'a', 'c'), 'b')
 *    ('iand', ('ushr(is_used_once)', 'a', '#b'), ('ushr', 'c', 'b')) => ('ushr', ('iand', 'a', 'c'), 'b')
 *    ('iand', ('ishr(is_used_once)', 'a', '#b'), ('ishr', 'c', 'b')) => ('ishr', ('iand', 'a', 'c'), 'b')
 *    ('iand', ('ishl(is_used_once)', 'a', '#b'), ('ishl', 'c', 'b')) => ('ishl', ('iand', 'a', 'c'), 'b')
 *    ('u2u8', ('ior', ('u2u16', ('u2u8', 'a@16')), ('u2u16', ('u2u8', 'b@16')))) => ('u2u8', ('ior', 'a', 'b'))
 *    ('u2u8', ('ior', ('u2u16', ('u2u8', 'a@32')), ('u2u16', ('u2u8', 'b@32')))) => ('u2u8', ('ior', 'a', 'b'))
 *    ('ior', ('extract_i8', 'a', '#b'), ('extract_i8', 'c', 'b')) => ('extract_i8', ('ior', 'a', 'c'), 'b')
 *    ('ior', ('extract_u8', 'a', '#b'), ('extract_u8', 'c', 'b')) => ('extract_u8', ('ior', 'a', 'c'), 'b')
 *    ('ior', ('extract_i16', 'a', '#b'), ('extract_i16', 'c', 'b')) => ('extract_i16', ('ior', 'a', 'c'), 'b')
 *    ('ior', ('extract_u16', 'a', '#b'), ('extract_u16', 'c', 'b')) => ('extract_u16', ('ior', 'a', 'c'), 'b')
 *    ('ior', ('ushr(is_used_once)', 'a', '#b'), ('ushr', 'c', 'b')) => ('ushr', ('ior', 'a', 'c'), 'b')
 *    ('ior', ('ishr(is_used_once)', 'a', '#b'), ('ishr', 'c', 'b')) => ('ishr', ('ior', 'a', 'c'), 'b')
 *    ('ior', ('ishl(is_used_once)', 'a', '#b'), ('ishl', 'c', 'b')) => ('ishl', ('ior', 'a', 'c'), 'b')
 *    ('u2u8', ('ixor', ('u2u16', ('u2u8', 'a@16')), ('u2u16', ('u2u8', 'b@16')))) => ('u2u8', ('ixor', 'a', 'b'))
 *    ('u2u8', ('ixor', ('u2u16', ('u2u8', 'a@32')), ('u2u16', ('u2u8', 'b@32')))) => ('u2u8', ('ixor', 'a', 'b'))
 *    ('ixor', ('extract_i8', 'a', '#b'), ('extract_i8', 'c', 'b')) => ('extract_i8', ('ixor', 'a', 'c'), 'b')
 *    ('ixor', ('extract_u8', 'a', '#b'), ('extract_u8', 'c', 'b')) => ('extract_u8', ('ixor', 'a', 'c'), 'b')
 *    ('ixor', ('extract_i16', 'a', '#b'), ('extract_i16', 'c', 'b')) => ('extract_i16', ('ixor', 'a', 'c'), 'b')
 *    ('ixor', ('extract_u16', 'a', '#b'), ('extract_u16', 'c', 'b')) => ('extract_u16', ('ixor', 'a', 'c'), 'b')
 *    ('ixor', ('ushr(is_used_once)', 'a', '#b'), ('ushr', 'c', 'b')) => ('ushr', ('ixor', 'a', 'c'), 'b')
 *    ('ixor', ('ishr(is_used_once)', 'a', '#b'), ('ishr', 'c', 'b')) => ('ishr', ('ixor', 'a', 'c'), 'b')
 *    ('ixor', ('ishl(is_used_once)', 'a', '#b'), ('ishl', 'c', 'b')) => ('ishl', ('ixor', 'a', 'c'), 'b')
 *    ('iand', ('ieq', 'a@8', 0), ('ieq', 'b@8', 0)) => ('ieq', ('ior', 'a', 'b'), 0)
 *    ('ior', ('ine', 'a@8', 0), ('ine', 'b@8', 0)) => ('ine', ('ior', 'a', 'b'), 0)
 *    ('iand', ('ieq', 'a@8', 0), ('ieq', 'b@8', 0)) => ('ieq', ('umax', 'a', 'b'), 0)
 *    ('ior', ('ieq', 'a@8', 0), ('ieq', 'b@8', 0)) => ('ieq', ('umin', 'a', 'b'), 0)
 *    ('iand', ('ine', 'a@8', 0), ('ine', 'b@8', 0)) => ('ine', ('umin', 'a', 'b'), 0)
 *    ('ior', ('ine', 'a@8', 0), ('ine', 'b@8', 0)) => ('ine', ('umax', 'a', 'b'), 0)
 *    ('bcsel', ('ult', 'b@8', 'a'), 'b', 'a') => ('umin', 'a', 'b')
 *    ('bcsel', ('ult', 'a@8', 'b'), 'b', 'a') => ('umax', 'a', 'b')
 *    ('bcsel', ('uge', 'a@8', 'b'), 'b', 'a') => ('umin', 'a', 'b')
 *    ('bcsel', ('uge', 'b@8', 'a'), 'b', 'a') => ('umax', 'a', 'b')
 *    ('bcsel', ('ilt', 'b@8', 'a'), 'b', 'a') => ('imin', 'a', 'b')
 *    ('bcsel', ('ilt', 'a@8', 'b'), 'b', 'a') => ('imax', 'a', 'b')
 *    ('bcsel', ('ige', 'a@8', 'b'), 'b', 'a') => ('imin', 'a', 'b')
 *    ('bcsel', ('ige', 'b@8', 'a'), 'b', 'a') => ('imax', 'a', 'b')
 *    ('ineg', ('b2i8', 'a@8')) => a
 *    ('ishl', 'a@8', ('iand', 7, 'b')) => ('ishl', 'a', 'b')
 *    ('ishr', 'a@8', ('iand', 7, 'b')) => ('ishr', 'a', 'b')
 *    ('ushr', 'a@8', ('iand', 7, 'b')) => ('ushr', 'a', 'b')
 *    ('ushr', 'a@8', ('ishl(is_used_once)', ('iand', 'b', 1), 2)) => ('ushr', 'a', ('ishl', 'b', 2))
 *    ('ushr', 'a@8', ('ishl(is_used_once)', ('iand', 'b', 3), 1)) => ('ushr', 'a', ('ishl', 'b', 1))
 *    ('iand', ('ieq', 'a@16', 0), ('ieq', 'b@16', 0)) => ('ieq', ('ior', 'a', 'b'), 0)
 *    ('ior', ('ine', 'a@16', 0), ('ine', 'b@16', 0)) => ('ine', ('ior', 'a', 'b'), 0)
 *    ('iand', ('ieq', 'a@16', 0), ('ieq', 'b@16', 0)) => ('ieq', ('umax', 'a', 'b'), 0)
 *    ('ior', ('ieq', 'a@16', 0), ('ieq', 'b@16', 0)) => ('ieq', ('umin', 'a', 'b'), 0)
 *    ('iand', ('ine', 'a@16', 0), ('ine', 'b@16', 0)) => ('ine', ('umin', 'a', 'b'), 0)
 *    ('ior', ('ine', 'a@16', 0), ('ine', 'b@16', 0)) => ('ine', ('umax', 'a', 'b'), 0)
 *    ('bcsel', ('ult', 'b@16', 'a'), 'b', 'a') => ('umin', 'a', 'b')
 *    ('bcsel', ('ult', 'a@16', 'b'), 'b', 'a') => ('umax', 'a', 'b')
 *    ('bcsel', ('uge', 'a@16', 'b'), 'b', 'a') => ('umin', 'a', 'b')
 *    ('bcsel', ('uge', 'b@16', 'a'), 'b', 'a') => ('umax', 'a', 'b')
 *    ('bcsel', ('ilt', 'b@16', 'a'), 'b', 'a') => ('imin', 'a', 'b')
 *    ('bcsel', ('ilt', 'a@16', 'b'), 'b', 'a') => ('imax', 'a', 'b')
 *    ('bcsel', ('ige', 'a@16', 'b'), 'b', 'a') => ('imin', 'a', 'b')
 *    ('bcsel', ('ige', 'b@16', 'a'), 'b', 'a') => ('imax', 'a', 'b')
 *    ('ineg', ('b2i16', 'a@16')) => a
 *    ('ishl', 'a@16', ('iand', 15, 'b')) => ('ishl', 'a', 'b')
 *    ('ishr', 'a@16', ('iand', 15, 'b')) => ('ishr', 'a', 'b')
 *    ('ushr', 'a@16', ('iand', 15, 'b')) => ('ushr', 'a', 'b')
 *    ('ushr', 'a@16', ('ishl(is_used_once)', ('iand', 'b', 1), 3)) => ('ushr', 'a', ('ishl', 'b', 3))
 *    ('ushr', 'a@16', ('ishl(is_used_once)', ('iand', 'b', 3), 2)) => ('ushr', 'a', ('ishl', 'b', 2))
 *    ('iand', ('ieq', 'a@32', 0), ('ieq', 'b@32', 0)) => ('ieq', ('ior', 'a', 'b'), 0)
 *    ('ior', ('ine', 'a@32', 0), ('ine', 'b@32', 0)) => ('ine', ('ior', 'a', 'b'), 0)
 *    ('iand', ('ieq', 'a@32', 0), ('ieq', 'b@32', 0)) => ('ieq', ('umax', 'a', 'b'), 0)
 *    ('ior', ('ieq', 'a@32', 0), ('ieq', 'b@32', 0)) => ('ieq', ('umin', 'a', 'b'), 0)
 *    ('iand', ('ine', 'a@32', 0), ('ine', 'b@32', 0)) => ('ine', ('umin', 'a', 'b'), 0)
 *    ('ior', ('ine', 'a@32', 0), ('ine', 'b@32', 0)) => ('ine', ('umax', 'a', 'b'), 0)
 *    ('bcsel', ('ult', 'b@32', 'a'), 'b', 'a') => ('umin', 'a', 'b')
 *    ('bcsel', ('ult', 'a@32', 'b'), 'b', 'a') => ('umax', 'a', 'b')
 *    ('bcsel', ('uge', 'a@32', 'b'), 'b', 'a') => ('umin', 'a', 'b')
 *    ('bcsel', ('uge', 'b@32', 'a'), 'b', 'a') => ('umax', 'a', 'b')
 *    ('bcsel', ('ilt', 'b@32', 'a'), 'b', 'a') => ('imin', 'a', 'b')
 *    ('bcsel', ('ilt', 'a@32', 'b'), 'b', 'a') => ('imax', 'a', 'b')
 *    ('bcsel', ('ige', 'a@32', 'b'), 'b', 'a') => ('imin', 'a', 'b')
 *    ('bcsel', ('ige', 'b@32', 'a'), 'b', 'a') => ('imax', 'a', 'b')
 *    ('ineg', ('b2i32', 'a@32')) => a
 *    ('ishl', 'a@32', ('iand', 31, 'b')) => ('ishl', 'a', 'b')
 *    ('ishr', 'a@32', ('iand', 31, 'b')) => ('ishr', 'a', 'b')
 *    ('ushr', 'a@32', ('iand', 31, 'b')) => ('ushr', 'a', 'b')
 *    ('ushr', 'a@32', ('ishl(is_used_once)', ('iand', 'b', 1), 4)) => ('ushr', 'a', ('ishl', 'b', 4))
 *    ('ushr', 'a@32', ('ishl(is_used_once)', ('iand', 'b', 3), 3)) => ('ushr', 'a', ('ishl', 'b', 3))
 *    ('iand', ('ieq', 'a@64', 0), ('ieq', 'b@64', 0)) => ('ieq', ('ior', 'a', 'b'), 0)
 *    ('ior', ('ine', 'a@64', 0), ('ine', 'b@64', 0)) => ('ine', ('ior', 'a', 'b'), 0)
 *    ('iand', ('ieq', 'a@64', 0), ('ieq', 'b@64', 0)) => ('ieq', ('umax', 'a', 'b'), 0)
 *    ('ior', ('ieq', 'a@64', 0), ('ieq', 'b@64', 0)) => ('ieq', ('umin', 'a', 'b'), 0)
 *    ('iand', ('ine', 'a@64', 0), ('ine', 'b@64', 0)) => ('ine', ('umin', 'a', 'b'), 0)
 *    ('ior', ('ine', 'a@64', 0), ('ine', 'b@64', 0)) => ('ine', ('umax', 'a', 'b'), 0)
 *    ('bcsel', ('ult', 'b@64', 'a'), 'b', 'a') => ('umin', 'a', 'b')
 *    ('bcsel', ('ult', 'a@64', 'b'), 'b', 'a') => ('umax', 'a', 'b')
 *    ('bcsel', ('uge', 'a@64', 'b'), 'b', 'a') => ('umin', 'a', 'b')
 *    ('bcsel', ('uge', 'b@64', 'a'), 'b', 'a') => ('umax', 'a', 'b')
 *    ('bcsel', ('ilt', 'b@64', 'a'), 'b', 'a') => ('imin', 'a', 'b')
 *    ('bcsel', ('ilt', 'a@64', 'b'), 'b', 'a') => ('imax', 'a', 'b')
 *    ('bcsel', ('ige', 'a@64', 'b'), 'b', 'a') => ('imin', 'a', 'b')
 *    ('bcsel', ('ige', 'b@64', 'a'), 'b', 'a') => ('imax', 'a', 'b')
 *    ('ineg', ('b2i64', 'a@64')) => a
 *    ('ishl', 'a@64', ('iand', 63, 'b')) => ('ishl', 'a', 'b')
 *    ('ishr', 'a@64', ('iand', 63, 'b')) => ('ishr', 'a', 'b')
 *    ('ushr', 'a@64', ('iand', 63, 'b')) => ('ushr', 'a', 'b')
 *    ('ushr', 'a@64', ('ishl(is_used_once)', ('iand', 'b', 1), 5)) => ('ushr', 'a', ('ishl', 'b', 5))
 *    ('ushr', 'a@64', ('ishl(is_used_once)', ('iand', 'b', 3), 4)) => ('ushr', 'a', ('ishl', 'b', 4))
 *    ('ior', ('ieq', 'a', 0), ('ieq', 'a', 1)) => ('uge', 1, 'a')
 *    ('ior', ('uge', 1, 'a'), ('ieq', 'a', 2)) => ('uge', 2, 'a')
 *    ('ior', ('uge', 2, 'a'), ('ieq', 'a', 3)) => ('uge', 3, 'a')
 *    ('ior', 'a', ('ieq', 'a', False)) => True
 *    ('uge', 'a', 1) => ('ine', 'a', 0)
 *    ('ult', 'a', 1) => ('ieq', 'a', 0)
 *    ('ine', ('ineg', ('b2i', 'a@1')), ('ineg', ('b2i', 'b@1'))) => ('ine', 'a', 'b')
 *    ('b2i', ('ine', 'a@1', 'b@1')) => ('b2i', ('ixor', 'a', 'b'))
 *    ('ishl', ('b2i32', ('ine', ('iand', 'a@32', '#b(is_pos_power_of_two)'), 0)), '#c') => ('bcsel', ('ige', ('iand', 'c', 31), ('find_lsb', 'b')), ('ishl', ('iand', 'a', 'b'), ('iadd', ('iand', 'c', 31), ('ineg', ('find_lsb', 'b')))), ('ushr', ('iand', 'a', 'b'), ('iadd', ('ineg', ('iand', 'c', 31)), ('find_lsb', 'b'))))
 *    ('b2i32', ('ine', ('iand', 'a@32', '#b(is_pos_power_of_two)'), 0)) => ('ushr', ('iand', 'a', 'b'), ('find_lsb', 'b'))
 *    ('ior', ('b2i', 'a'), ('iand', 'b', 1)) => ('iand', ('ior', ('b2i', 'a'), 'b'), 1)
 *    ('iand', ('b2i', 'a'), ('iand', 'b', 1)) => ('iand', ('b2i', 'a'), 'b')
 *    ('iand', ('inot', ('iand', ('ior', ('ieq', 'a', 0), 'b'), 'c')), ('ilt', 'a', 0)) => ('iand', ('inot', ('iand', 'b', 'c')), ('ilt', 'a', 0))
 *    ('iand', ('inot', ('iand', ('ieq', ('umin', 'a', 'b'), 0), 'c')), ('ilt', 'a', 0)) => ('iand', ('inot', ('iand', ('ieq', 'b', 0), 'c')), ('ilt', 'a', 0))
 *    ('flt', 'a', ('fmax', 'b', 'a')) => ('flt', 'a', 'b')
 *    ('flt', ('fmin', 'a', 'b'), 'a') => ('flt', 'b', 'a')
 *    ('~fge', 'a', ('fmin', 'b', 'a')) => True
 *    ('~fge', ('fmax', 'a', 'b'), 'a') => True
 *    ('flt', 'a', ('fmin', 'b', 'a')) => False
 *    ('flt', ('fmax', 'a', 'b'), 'a') => False
 *    ('~fge', 'a', ('fmax', 'b', 'a')) => ('fge', 'a', 'b')
 *    ('~fge', ('fmin', 'a', 'b'), 'a') => ('fge', 'b', 'a')
 *    ('ilt', 'a', ('imax', 'b', 'a')) => ('ilt', 'a', 'b')
 *    ('ilt', ('imin', 'a', 'b'), 'a') => ('ilt', 'b', 'a')
 *    ('ige', 'a', ('imin', 'b', 'a')) => True
 *    ('ige', ('imax', 'a', 'b'), 'a') => True
 *    ('ult', 'a', ('umax', 'b', 'a')) => ('ult', 'a', 'b')
 *    ('ult', ('umin', 'a', 'b'), 'a') => ('ult', 'b', 'a')
 *    ('uge', 'a', ('umin', 'b', 'a')) => True
 *    ('uge', ('umax', 'a', 'b'), 'a') => True
 *    ('ilt', 'a', ('imin', 'b', 'a')) => False
 *    ('ilt', ('imax', 'a', 'b'), 'a') => False
 *    ('ige', 'a', ('imax', 'b', 'a')) => ('ige', 'a', 'b')
 *    ('ige', ('imin', 'a', 'b'), 'a') => ('ige', 'b', 'a')
 *    ('ult', 'a', ('umin', 'b', 'a')) => False
 *    ('ult', ('umax', 'a', 'b'), 'a') => False
 *    ('uge', 'a', ('umax', 'b', 'a')) => ('uge', 'a', 'b')
 *    ('uge', ('umin', 'a', 'b'), 'a') => ('uge', 'b', 'a')
 *    ('ult', 'a', ('iand', 'b', 'a')) => False
 *    ('ult', ('ior', 'a', 'b'), 'a') => False
 *    ('uge', 'a', ('iand', 'b', 'a')) => True
 *    ('uge', ('ior', 'a', 'b'), 'a') => True
 *    ('ilt', '#a', ('imax', '#b', 'c')) => ('ior', ('ilt', 'a', 'b'), ('ilt', 'a', 'c'))
 *    ('ilt', ('imin', '#a', 'b'), '#c') => ('ior', ('ilt', 'a', 'c'), ('ilt', 'b', 'c'))
 *    ('ige', '#a', ('imin', '#b', 'c')) => ('ior', ('ige', 'a', 'b'), ('ige', 'a', 'c'))
 *    ('ige', ('imax', '#a', 'b'), '#c') => ('ior', ('ige', 'a', 'c'), ('ige', 'b', 'c'))
 *    ('ult', '#a', ('umax', '#b', 'c')) => ('ior', ('ult', 'a', 'b'), ('ult', 'a', 'c'))
 *    ('ult', ('umin', '#a', 'b'), '#c') => ('ior', ('ult', 'a', 'c'), ('ult', 'b', 'c'))
 *    ('uge', '#a', ('umin', '#b', 'c')) => ('ior', ('uge', 'a', 'b'), ('uge', 'a', 'c'))
 *    ('uge', ('umax', '#a', 'b'), '#c') => ('ior', ('uge', 'a', 'c'), ('uge', 'b', 'c'))
 *    ('ilt', '#a', ('imin', '#b', 'c')) => ('iand', ('ilt', 'a', 'b'), ('ilt', 'a', 'c'))
 *    ('ilt', ('imax', '#a', 'b'), '#c') => ('iand', ('ilt', 'a', 'c'), ('ilt', 'b', 'c'))
 *    ('ige', '#a', ('imax', '#b', 'c')) => ('iand', ('ige', 'a', 'b'), ('ige', 'a', 'c'))
 *    ('ige', ('imin', '#a', 'b'), '#c') => ('iand', ('ige', 'a', 'c'), ('ige', 'b', 'c'))
 *    ('ult', '#a', ('umin', '#b', 'c')) => ('iand', ('ult', 'a', 'b'), ('ult', 'a', 'c'))
 *    ('ult', ('umax', '#a', 'b'), '#c') => ('iand', ('ult', 'a', 'c'), ('ult', 'b', 'c'))
 *    ('uge', '#a', ('umax', '#b', 'c')) => ('iand', ('uge', 'a', 'b'), ('uge', 'a', 'c'))
 *    ('uge', ('umin', '#a', 'b'), '#c') => ('iand', ('uge', 'a', 'c'), ('uge', 'b', 'c'))
 *    ('bcsel', ('ilt', 'a', 0), ('ineg', ('ishr', 'a', 'b')), ('ishr', 'a', 'b')) => ('iabs', ('ishr', 'a', 'b'))
 *    ('iabs', ('ishr', ('iabs', 'a'), 'b')) => ('ushr', ('iabs', 'a'), 'b')
 *    ('iabs', ('ushr', ('iabs', 'a'), 'b')) => ('ushr', ('iabs', 'a'), 'b')
 *    ('fabs', ('slt', 'a', 'b')) => ('slt', 'a', 'b')
 *    ('fabs', ('sge', 'a', 'b')) => ('sge', 'a', 'b')
 *    ('fabs', ('seq', 'a', 'b')) => ('seq', 'a', 'b')
 *    ('fabs', ('sne', 'a', 'b')) => ('sne', 'a', 'b')
 *    ('slt', 'a', 'b') => ('b2f', ('flt', 'a', 'b'))
 *    ('sge', 'a', 'b') => ('b2f', ('fge', 'a', 'b'))
 *    ('seq', 'a', 'b') => ('b2f', ('feq', 'a', 'b'))
 *    ('sne', 'a', 'b') => ('b2f', ('fneu', 'a', 'b'))
 *    ('seq', ('seq', 'a', 'b'), 1.0) => ('seq', 'a', 'b')
 *    ('seq', ('sne', 'a', 'b'), 1.0) => ('sne', 'a', 'b')
 *    ('seq', ('slt', 'a', 'b'), 1.0) => ('slt', 'a', 'b')
 *    ('seq', ('sge', 'a', 'b'), 1.0) => ('sge', 'a', 'b')
 *    ('sne', ('seq', 'a', 'b'), 0.0) => ('seq', 'a', 'b')
 *    ('sne', ('sne', 'a', 'b'), 0.0) => ('sne', 'a', 'b')
 *    ('sne', ('slt', 'a', 'b'), 0.0) => ('slt', 'a', 'b')
 *    ('sne', ('sge', 'a', 'b'), 0.0) => ('sge', 'a', 'b')
 *    ('seq', ('seq', 'a', 'b'), 0.0) => ('sne', 'a', 'b')
 *    ('seq', ('sne', 'a', 'b'), 0.0) => ('seq', 'a', 'b')
 *    ('seq', ('slt', 'a', 'b'), 0.0) => ('sge', 'a', 'b')
 *    ('seq', ('sge', 'a', 'b'), 0.0) => ('slt', 'a', 'b')
 *    ('sne', ('seq', 'a', 'b'), 1.0) => ('sne', 'a', 'b')
 *    ('sne', ('sne', 'a', 'b'), 1.0) => ('seq', 'a', 'b')
 *    ('sne', ('slt', 'a', 'b'), 1.0) => ('sge', 'a', 'b')
 *    ('sne', ('sge', 'a', 'b'), 1.0) => ('slt', 'a', 'b')
 *    ('fall_equal2', 'a', 'b') => ('fmin', ('seq', 'a.x', 'b.x'), ('seq', 'a.y', 'b.y'))
 *    ('fall_equal3', 'a', 'b') => ('seq', ('fany_nequal3', 'a', 'b'), 0.0)
 *    ('fall_equal4', 'a', 'b') => ('seq', ('fany_nequal4', 'a', 'b'), 0.0)
 *    ('fall_equal8', 'a', 'b') => ('seq', ('fany_nequal8', 'a', 'b'), 0.0)
 *    ('fall_equal16', 'a', 'b') => ('seq', ('fany_nequal16', 'a', 'b'), 0.0)
 *    ('fany_nequal2', 'a', 'b') => ('fmax', ('sne', 'a.x', 'b.x'), ('sne', 'a.y', 'b.y'))
 *    ('fany_nequal3', 'a', 'b') => ('fsat', ('fdot3', ('sne', 'a', 'b'), ('sne', 'a', 'b')))
 *    ('fany_nequal4', 'a', 'b') => ('fsat', ('fdot4', ('sne', 'a', 'b'), ('sne', 'a', 'b')))
 *    ('fany_nequal8', 'a', 'b') => ('fsat', ('fdot8', ('sne', 'a', 'b'), ('sne', 'a', 'b')))
 *    ('fany_nequal16', 'a', 'b') => ('fsat', ('fdot16', ('sne', 'a', 'b'), ('sne', 'a', 'b')))
 *    ('ball_iequal2', 'a', 'b') => ('iand', ('ieq', 'a.x', 'b.x'), ('ieq', 'a.y', 'b.y'))
 *    ('ball_iequal3', 'a', 'b') => ('iand', ('ieq', 'a.x', 'b.x'), ('iand', ('ieq', 'a.y', 'b.y'), ('ieq', 'a.z', 'b.z')))
 *    ('ball_iequal4', 'a', 'b') => ('iand', ('iand', ('ieq', 'a.x', 'b.x'), ('ieq', 'a.y', 'b.y')), ('iand', ('ieq', 'a.z', 'b.z'), ('ieq', 'a.w', 'b.w')))
 *    ('ball_iequal8', 'a', 'b') => ('iand', ('iand', ('iand', ('ieq', 'a.a', 'b.a'), ('ieq', 'a.b', 'b.b')), ('iand', ('ieq', 'a.c', 'b.c'), ('ieq', 'a.d', 'b.d'))), ('iand', ('iand', ('ieq', 'a.e', 'b.e'), ('ieq', 'a.f', 'b.f')), ('iand', ('ieq', 'a.g', 'b.g'), ('ieq', 'a.h', 'b.h'))))
 *    ('ball_iequal16', 'a', 'b') => ('iand', ('iand', ('iand', ('iand', ('ieq', 'a.a', 'b.a'), ('ieq', 'a.b', 'b.b')), ('iand', ('ieq', 'a.c', 'b.c'), ('ieq', 'a.d', 'b.d'))), ('iand', ('iand', ('ieq', 'a.e', 'b.e'), ('ieq', 'a.f', 'b.f')), ('iand', ('ieq', 'a.g', 'b.g'), ('ieq', 'a.h', 'b.h')))), ('iand', ('iand', ('iand', ('ieq', 'a.i', 'b.i'), ('ieq', 'a.j', 'b.j')), ('iand', ('ieq', 'a.k', 'b.k'), ('ieq', 'a.l', 'b.l'))), ('iand', ('iand', ('ieq', 'a.m', 'b.m'), ('ieq', 'a.n', 'b.n')), ('iand', ('ieq', 'a.o', 'b.o'), ('ieq', 'a.p', 'b.p')))))
 *    ('ball_fequal2', 'a', 'b') => ('iand', ('feq', 'a.x', 'b.x'), ('feq', 'a.y', 'b.y'))
 *    ('ball_fequal3', 'a', 'b') => ('iand', ('feq', 'a.x', 'b.x'), ('iand', ('feq', 'a.y', 'b.y'), ('feq', 'a.z', 'b.z')))
 *    ('ball_fequal4', 'a', 'b') => ('iand', ('iand', ('feq', 'a.x', 'b.x'), ('feq', 'a.y', 'b.y')), ('iand', ('feq', 'a.z', 'b.z'), ('feq', 'a.w', 'b.w')))
 *    ('ball_fequal8', 'a', 'b') => ('iand', ('iand', ('iand', ('feq', 'a.a', 'b.a'), ('feq', 'a.b', 'b.b')), ('iand', ('feq', 'a.c', 'b.c'), ('feq', 'a.d', 'b.d'))), ('iand', ('iand', ('feq', 'a.e', 'b.e'), ('feq', 'a.f', 'b.f')), ('iand', ('feq', 'a.g', 'b.g'), ('feq', 'a.h', 'b.h'))))
 *    ('ball_fequal16', 'a', 'b') => ('iand', ('iand', ('iand', ('iand', ('feq', 'a.a', 'b.a'), ('feq', 'a.b', 'b.b')), ('iand', ('feq', 'a.c', 'b.c'), ('feq', 'a.d', 'b.d'))), ('iand', ('iand', ('feq', 'a.e', 'b.e'), ('feq', 'a.f', 'b.f')), ('iand', ('feq', 'a.g', 'b.g'), ('feq', 'a.h', 'b.h')))), ('iand', ('iand', ('iand', ('feq', 'a.i', 'b.i'), ('feq', 'a.j', 'b.j')), ('iand', ('feq', 'a.k', 'b.k'), ('feq', 'a.l', 'b.l'))), ('iand', ('iand', ('feq', 'a.m', 'b.m'), ('feq', 'a.n', 'b.n')), ('iand', ('feq', 'a.o', 'b.o'), ('feq', 'a.p', 'b.p')))))
 *    ('bany_inequal2', 'a', 'b') => ('ior', ('ine', 'a.x', 'b.x'), ('ine', 'a.y', 'b.y'))
 *    ('bany_inequal3', 'a', 'b') => ('ior', ('ine', 'a.x', 'b.x'), ('ior', ('ine', 'a.y', 'b.y'), ('ine', 'a.z', 'b.z')))
 *    ('bany_inequal4', 'a', 'b') => ('ior', ('ior', ('ine', 'a.x', 'b.x'), ('ine', 'a.y', 'b.y')), ('ior', ('ine', 'a.z', 'b.z'), ('ine', 'a.w', 'b.w')))
 *    ('bany_inequal8', 'a', 'b') => ('ior', ('ior', ('ior', ('ine', 'a.a', 'b.a'), ('ine', 'a.b', 'b.b')), ('ior', ('ine', 'a.c', 'b.c'), ('ine', 'a.d', 'b.d'))), ('ior', ('ior', ('ine', 'a.e', 'b.e'), ('ine', 'a.f', 'b.f')), ('ior', ('ine', 'a.g', 'b.g'), ('ine', 'a.h', 'b.h'))))
 *    ('bany_inequal16', 'a', 'b') => ('ior', ('ior', ('ior', ('ior', ('ine', 'a.a', 'b.a'), ('ine', 'a.b', 'b.b')), ('ior', ('ine', 'a.c', 'b.c'), ('ine', 'a.d', 'b.d'))), ('ior', ('ior', ('ine', 'a.e', 'b.e'), ('ine', 'a.f', 'b.f')), ('ior', ('ine', 'a.g', 'b.g'), ('ine', 'a.h', 'b.h')))), ('ior', ('ior', ('ior', ('ine', 'a.i', 'b.i'), ('ine', 'a.j', 'b.j')), ('ior', ('ine', 'a.k', 'b.k'), ('ine', 'a.l', 'b.l'))), ('ior', ('ior', ('ine', 'a.m', 'b.m'), ('ine', 'a.n', 'b.n')), ('ior', ('ine', 'a.o', 'b.o'), ('ine', 'a.p', 'b.p')))))
 *    ('bany_fnequal2', 'a', 'b') => ('ior', ('fneu', 'a.x', 'b.x'), ('fneu', 'a.y', 'b.y'))
 *    ('bany_fnequal3', 'a', 'b') => ('ior', ('fneu', 'a.x', 'b.x'), ('ior', ('fneu', 'a.y', 'b.y'), ('fneu', 'a.z', 'b.z')))
 *    ('bany_fnequal4', 'a', 'b') => ('ior', ('ior', ('fneu', 'a.x', 'b.x'), ('fneu', 'a.y', 'b.y')), ('ior', ('fneu', 'a.z', 'b.z'), ('fneu', 'a.w', 'b.w')))
 *    ('bany_fnequal8', 'a', 'b') => ('ior', ('ior', ('ior', ('fneu', 'a.a', 'b.a'), ('fneu', 'a.b', 'b.b')), ('ior', ('fneu', 'a.c', 'b.c'), ('fneu', 'a.d', 'b.d'))), ('ior', ('ior', ('fneu', 'a.e', 'b.e'), ('fneu', 'a.f', 'b.f')), ('ior', ('fneu', 'a.g', 'b.g'), ('fneu', 'a.h', 'b.h'))))
 *    ('bany_fnequal16', 'a', 'b') => ('ior', ('ior', ('ior', ('ior', ('fneu', 'a.a', 'b.a'), ('fneu', 'a.b', 'b.b')), ('ior', ('fneu', 'a.c', 'b.c'), ('fneu', 'a.d', 'b.d'))), ('ior', ('ior', ('fneu', 'a.e', 'b.e'), ('fneu', 'a.f', 'b.f')), ('ior', ('fneu', 'a.g', 'b.g'), ('fneu', 'a.h', 'b.h')))), ('ior', ('ior', ('ior', ('fneu', 'a.i', 'b.i'), ('fneu', 'a.j', 'b.j')), ('ior', ('fneu', 'a.k', 'b.k'), ('fneu', 'a.l', 'b.l'))), ('ior', ('ior', ('fneu', 'a.m', 'b.m'), ('fneu', 'a.n', 'b.n')), ('ior', ('fneu', 'a.o', 'b.o'), ('fneu', 'a.p', 'b.p')))))
 *    ('feq', ('seq', 'a', 'b'), 1.0) => ('feq', 'a', 'b')
 *    ('feq', ('sne', 'a', 'b'), 1.0) => ('fneu', 'a', 'b')
 *    ('feq', ('slt', 'a', 'b'), 1.0) => ('flt', 'a', 'b')
 *    ('feq', ('sge', 'a', 'b'), 1.0) => ('fge', 'a', 'b')
 *    ('fneu', ('seq', 'a', 'b'), 0.0) => ('feq', 'a', 'b')
 *    ('fneu', ('sne', 'a', 'b'), 0.0) => ('fneu', 'a', 'b')
 *    ('fneu', ('slt', 'a', 'b'), 0.0) => ('flt', 'a', 'b')
 *    ('fneu', ('sge', 'a', 'b'), 0.0) => ('fge', 'a', 'b')
 *    ('feq', ('seq', 'a', 'b'), 0.0) => ('fneu', 'a', 'b')
 *    ('feq', ('sne', 'a', 'b'), 0.0) => ('feq', 'a', 'b')
 *    ('feq', ('slt', 'a', 'b'), 0.0) => ('fge', 'a', 'b')
 *    ('feq', ('sge', 'a', 'b'), 0.0) => ('flt', 'a', 'b')
 *    ('fneu', ('seq', 'a', 'b'), 1.0) => ('fneu', 'a', 'b')
 *    ('fneu', ('sne', 'a', 'b'), 1.0) => ('feq', 'a', 'b')
 *    ('fneu', ('slt', 'a', 'b'), 1.0) => ('fge', 'a', 'b')
 *    ('fneu', ('sge', 'a', 'b'), 1.0) => ('flt', 'a', 'b')
 *    ('fneu', ('fneg', 'a'), 'a') => ('fneu', 'a', 0.0)
 *    ('feq', ('fneg', 'a'), 'a') => ('feq', 'a', 0.0)
 *    ('imul', ('b2i', 'a@1'), ('b2i', 'b@1')) => ('b2i', ('iand', 'a', 'b'))
 *    ('iand', ('b2i', 'a@1'), ('b2i', 'b@1')) => ('b2i', ('iand', 'a', 'b'))
 *    ('ior', ('b2i', 'a@1'), ('b2i', 'b@1')) => ('b2i', ('ior', 'a', 'b'))
 *    ('fmul', ('b2f', 'a@1'), ('b2f', 'b@1')) => ('b2f', ('iand', 'a', 'b'))
 *    ('ffma', ('b2f', 'a@1'), ('b2f', 'b@1'), 'c') => ('fadd', ('b2f', ('iand', 'a', 'b')), 'c')
 *    ('fsat', ('fadd', ('b2f', 'a@1'), ('b2f', 'b@1'))) => ('b2f', ('ior', 'a', 'b'))
 *    ('iand', 'a@bool16', 1.0) => ('b2f', 'a')
 *    ('iand', 'a@bool32', 1.0) => ('b2f', 'a')
 *    ('flt', ('fneg', ('b2f', 'a@1')), 0) => a
 *    ('ilt', 'a', 'a') => False
 *    ('ige', 'a', 'a') => True
 *    ('ieq', 'a', 'a') => True
 *    ('ine', 'a', 'a') => False
 *    ('ult', 'a', 'a') => False
 *    ('uge', 'a', 'a') => True
 *    ('flt', 'a', 'a') => False
 *    ('fge', 'a(is_a_number)', 'a') => True
 *    ('feq', 'a(is_a_number)', 'a') => True
 *    ('fneu', 'a(is_a_number)', 'a') => False
 *    ('iand', 'a', 'a') => a
 *    ('iand', 'a', 0) => 0
 *    ('iand', 'a', -1) => a
 *    ('iand', 'a', ('inot', 'a')) => 0
 *    ('ior', 'a', 'a') => a
 *    ('ior', 'a', 0) => a
 *    ('ior', 'a', -1) => -1
 *    ('ior', 'a', ('inot', 'a')) => -1
 *    ('ixor', 'a', 'a') => 0
 *    ('ixor', 'a', 0) => a
 *    ('ixor', 'a', ('ixor', 'a', 'b')) => b
 *    ('ixor', 'a', -1) => ('inot', 'a')
 *    ('inot', ('inot', 'a')) => a
 *    ('ior', ('iand', 'a', 'b'), 'b') => b
 *    ('ior', ('ior', 'a', 'b'), 'b') => ('ior', 'a', 'b')
 *    ('iand', ('ior', 'a', 'b'), 'b') => b
 *    ('iand', ('iand', 'a', 'b'), 'b') => ('iand', 'a', 'b')
 *    ('iand', ('iand(is_used_once)', 'a', 'b'), ('iand(is_used_once)', 'a', 'c')) => ('iand', 'a', ('iand', 'b', 'c'))
 *    ('iand@64', 'a', '#b(is_lower_half_zero)') => ('pack_64_2x32_split', 0, ('iand', ('unpack_64_2x32_split_y', 'a'), ('unpack_64_2x32_split_y', 'b')))
 *    ('iand@64', 'a', '#b(is_upper_half_zero)') => ('pack_64_2x32_split', ('iand', ('unpack_64_2x32_split_x', 'a'), ('unpack_64_2x32_split_x', 'b')), 0)
 *    ('iand@64', 'a', '#b(is_lower_half_negative_one)') => ('pack_64_2x32_split', ('unpack_64_2x32_split_x', 'a'), ('iand', ('unpack_64_2x32_split_y', 'a'), ('unpack_64_2x32_split_y', 'b')))
 *    ('iand@64', 'a', '#b(is_upper_half_negative_one)') => ('pack_64_2x32_split', ('iand', ('unpack_64_2x32_split_x', 'a'), ('unpack_64_2x32_split_x', 'b')), ('unpack_64_2x32_split_y', 'a'))
 *    ('ior@64', 'a', '#b(is_lower_half_zero)') => ('pack_64_2x32_split', ('unpack_64_2x32_split_x', 'a'), ('ior', ('unpack_64_2x32_split_y', 'a'), ('unpack_64_2x32_split_y', 'b')))
 *    ('ior@64', 'a', '#b(is_upper_half_zero)') => ('pack_64_2x32_split', ('ior', ('unpack_64_2x32_split_x', 'a'), ('unpack_64_2x32_split_x', 'b')), ('unpack_64_2x32_split_y', 'a'))
 *    ('ior@64', 'a', '#b(is_lower_half_negative_one)') => ('pack_64_2x32_split', -1, ('ior', ('unpack_64_2x32_split_y', 'a'), ('unpack_64_2x32_split_y', 'b')))
 *    ('ior@64', 'a', '#b(is_upper_half_negative_one)') => ('pack_64_2x32_split', ('ior', ('unpack_64_2x32_split_x', 'a'), ('unpack_64_2x32_split_x', 'b')), -1)
 *    ('ixor@64', 'a', '#b(is_lower_half_zero)') => ('pack_64_2x32_split', ('unpack_64_2x32_split_x', 'a'), ('ixor', ('unpack_64_2x32_split_y', 'a'), ('unpack_64_2x32_split_y', 'b')))
 *    ('ixor@64', 'a', '#b(is_upper_half_zero)') => ('pack_64_2x32_split', ('ixor', ('unpack_64_2x32_split_x', 'a'), ('unpack_64_2x32_split_x', 'b')), ('unpack_64_2x32_split_y', 'a'))
 *    ('iand', ('inot', 'a'), ('inot', 'b')) => ('inot', ('ior', 'a', 'b'))
 *    ('ior', ('inot', 'a'), ('inot', 'b')) => ('inot', ('iand', 'a', 'b'))
 *    ('ishl', 0, 'a') => 0
 *    ('ishl', 'a', 0) => a
 *    ('ishr', 0, 'a') => 0
 *    ('ishr', -1, 'a') => -1
 *    ('ishr', 'a', 0) => a
 *    ('ushr', 0, 'a') => 0
 *    ('ushr', 'a', 0) => a
 *    ('bcsel', ('ieq', 'b', 0), 'a', ('ushr', 'a', 'b')) => ('ushr', 'a', 'b')
 *    ('bcsel', ('ieq', 'b', 0), 'a', ('ishr', 'a', 'b')) => ('ishr', 'a', 'b')
 *    ('bcsel', ('ieq', 'b', 0), 'a', ('ishl', 'a', 'b')) => ('ishl', 'a', 'b')
 *    ('bcsel', ('ine', 'b', 0), ('ushr', 'a', 'b'), 'a') => ('ushr', 'a', 'b')
 *    ('bcsel', ('ine', 'b', 0), ('ishr', 'a', 'b'), 'a') => ('ishr', 'a', 'b')
 *    ('bcsel', ('ine', 'b', 0), ('ishl', 'a', 'b'), 'a') => ('ishl', 'a', 'b')
 *    ('ior', ('ishl@16', 'a', 'b'), ('ushr@16', 'a', ('iadd', 16, ('ineg', 'b')))) => ('urol', 'a', 'b')
 *    ('ior', ('ishl@16', 'a', 'b'), ('ushr@16', 'a', ('isub', 16, 'b'))) => ('urol', 'a', 'b')
 *    ('ior', ('ishl@32', 'a', 'b'), ('ushr@32', 'a', ('iadd', 32, ('ineg', 'b')))) => ('urol', 'a', 'b')
 *    ('ior', ('ishl@32', 'a', 'b'), ('ushr@32', 'a', ('isub', 32, 'b'))) => ('urol', 'a', 'b')
 *    ('ior', ('ushr@16', 'a', 'b'), ('ishl@16', 'a', ('iadd', 16, ('ineg', 'b')))) => ('uror', 'a', 'b')
 *    ('ior', ('ushr@16', 'a', 'b'), ('ishl@16', 'a', ('isub', 16, 'b'))) => ('uror', 'a', 'b')
 *    ('ior', ('ushr@32', 'a', 'b'), ('ishl@32', 'a', ('iadd', 32, ('ineg', 'b')))) => ('uror', 'a', 'b')
 *    ('ior', ('ushr@32', 'a', 'b'), ('ishl@32', 'a', ('isub', 32, 'b'))) => ('uror', 'a', 'b')
 *    ('urol@8', 'a', 'b') => ('ior', ('ishl', 'a', 'b'), ('ushr', 'a', ('isub', 8, 'b')))
 *    ('urol@16', 'a', 'b') => ('ior', ('ishl', 'a', 'b'), ('ushr', 'a', ('isub', 16, 'b')))
 *    ('urol@32', 'a', 'b') => ('ior', ('ishl', 'a', 'b'), ('ushr', 'a', ('isub', 32, 'b')))
 *    ('urol@64', 'a', 'b') => ('ior', ('ishl', 'a', 'b'), ('ushr', 'a', ('isub', 64, 'b')))
 *    ('uror@8', 'a', 'b') => ('ior', ('ushr', 'a', 'b'), ('ishl', 'a', ('isub', 8, 'b')))
 *    ('uror@16', 'a', 'b') => ('ior', ('ushr', 'a', 'b'), ('ishl', 'a', ('isub', 16, 'b')))
 *    ('uror@32', 'a', 'b') => ('ior', ('ushr', 'a', 'b'), ('ishl', 'a', ('isub', 32, 'b')))
 *    ('uror@64', 'a', 'b') => ('ior', ('ushr', 'a', 'b'), ('ishl', 'a', ('isub', 64, 'b')))
 *    ('bitfield_select', 4278190080, ('ishl', 'b@32', 24), ('ushr', 'a', 8)) => ('shfr', 'b', 'a', 8)
 *    ('bitfield_select', 4294901760, ('ishl', 'b@32', 16), ('extract_u16', 'a', 1)) => ('shfr', 'b', 'a', 16)
 *    ('bitfield_select', 4294967040, ('ishl', 'b@32', 8), ('extract_u8', 'a', 3)) => ('shfr', 'b', 'a', 24)
 *    ('ior', ('ishl', 'b@32', 24), ('ushr', 'a', 8)) => ('shfr', 'b', 'a', 8)
 *    ('ior', ('ishl', 'b@32', 16), ('extract_u16', 'a', 1)) => ('shfr', 'b', 'a', 16)
 *    ('ior', ('ishl', 'b@32', 8), ('extract_u8', 'a', 3)) => ('shfr', 'b', 'a', 24)
 *    ('bcsel', ('ieq', 'c', 0), 'a', ('ior', ('ishl', 'b@32', ('iadd', 32, ('ineg', 'c'))), ('ushr@32', 'a', 'c'))) => ('shfr', 'b', 'a', 'c')
 *    ('bcsel', ('ine', 'c', 0), ('ior', ('ishl', 'b@32', ('iadd', 32, ('ineg', 'c'))), ('ushr@32', 'a', 'c')), 'a') => ('shfr', 'b', 'a', 'c')
 *    ('ior', ('ishl', 'a@32', ('iadd', 32, ('ineg', 'b'))), ('ushr@32', 'a', 'b')) => ('shfr', 'a', 'a', 'b')
 *    ('bfi', 4294967295, 'a', 'b') => a
 *    ('bfi', 0, 'a', 'b') => b
 *    ('bfi', ('ineg', ('b2i', 'a@1')), 'b', 'c') => ('bcsel', 'a', 'b', 'c')
 *    ('bfi', 'a', 0, 0) => 0
 *    ('bfi', '#a(is_odd)', 'b', 'b') => b
 *    ('bfi', '#a(is_odd)', 'a', 'b') => ('ior', 'a', 'b')
 *    ('bfi', '#a(is_odd)', 'b', 0) => ('iand', 'a', 'b')
 *    ('u2f32', ('bfi', '#a(is_pos_power_of_two)', 'b', 0)) => ('bcsel', ('ieq', ('iand', 'b', 1), 0), ('iand', 'b', 1), ('u2f', 'a'))
 *    ('u2f', ('bfi', '#a(is_pos_power_of_two)', 'b', 0)) => ('bcsel', ('ieq', ('iand', 'b', 1), 0), 0, ('u2f', 'a'))
 *    ('~fexp2', ('flog2', 'a')) => a
 *    ('~flog2', ('fexp2', 'a')) => a
 *    ('fpow@32', 'a', 'b') => ('fexp2', ('fmulz', ('flog2', 'a'), 'b'))
 *    ('fpow', 'a', 'b') => ('fexp2', ('fmul', ('flog2', 'a'), 'b'))
 *    ('~fexp2', ('fmul', ('flog2', 'a'), 'b')) => ('fpow', 'a', 'b')
 *    ('~fexp2', ('fadd', ('fmul', ('flog2', 'a'), 'b'), ('fmul', ('flog2', 'c'), 'd'))) => ('~fmul', ('fpow', 'a', 'b'), ('fpow', 'c', 'd'))
 *    ('~fexp2', ('fmul', ('flog2', 'a'), 0.5)) => ('fsqrt', 'a')
 *    ('~fexp2', ('fmul', ('flog2', 'a'), 2.0)) => ('fmul', 'a', 'a')
 *    ('~fexp2', ('fmul', ('flog2', 'a'), 3.0)) => ('fmul', ('fmul', 'a', 'a'), 'a')
 *    ('~fexp2', ('fmul', ('flog2', 'a'), 4.0)) => ('fmul', ('fmul', 'a', 'a'), ('fmul', 'a', 'a'))
 *    ('~fexp2', ('fmul', ('flog2', 'a'), 5.0)) => ('fmul', ('fmul', ('fmul', 'a', 'a'), ('fmul', 'a', 'a')), 'a')
 *    ('~fexp2', ('fmul', ('flog2', 'a'), 6.0)) => ('fmul', ('fmul', ('fmul', 'a', 'a'), ('fmul', 'a', 'a')), ('fmul', 'a', 'a'))
 *    ('~fexp2', ('fmul', ('flog2', 'a'), 8.0)) => ('fmul', ('fmul', ('fmul', 'a', 'a'), ('fmul', 'a', 'a')), ('fmul', ('fmul', 'a', 'a'), ('fmul', 'a', 'a')))
 *    ('~fpow', 'a', 1.0) => a
 *    ('~fpow', 'a', 2.0) => ('fmul', 'a', 'a')
 *    ('~fpow', 'a', 3.0) => ('fmul', ('fmul', 'a', 'a'), 'a')
 *    ('~fpow', 'a', 4.0) => ('fmul', ('fmul', 'a', 'a'), ('fmul', 'a', 'a'))
 *    ('~fpow', 2.0, 'a') => ('fexp2', 'a')
 *    ('~fpow', ('fpow', 'a', 2.2), 0.454545) => a
 *    ('~fpow', ('fabs', ('fpow', 'a', 2.2)), 0.454545) => ('fabs', 'a')
 *    ('~fsqrt', ('fexp2', 'a')) => ('fexp2', ('fmul', 0.5, 'a'))
 *    ('~frcp', ('fexp2', 'a')) => ('fexp2', ('fneg', 'a'))
 *    ('~frsq', ('fexp2', 'a')) => ('fexp2', ('fmul', -0.5, 'a'))
 *    ('~flog2', ('fsqrt', 'a')) => ('fmul', 0.5, ('flog2', 'a'))
 *    ('~flog2', ('frcp', 'a')) => ('fneg', ('flog2', 'a'))
 *    ('~flog2', ('frsq', 'a')) => ('fmul', -0.5, ('flog2', 'a'))
 *    ('~flog2', ('fpow', 'a', 'b')) => ('fmul', 'b', ('flog2', 'a'))
 *    ('~fmul', ('fexp2(is_used_once)', 'a'), ('fexp2(is_used_once)', 'b')) => ('fexp2', ('fadd', 'a', 'b'))
 *    ('bcsel', ('flt', 'a', 0.0), 0.0, ('fsqrt', 'a')) => ('fsqrt', ('fmax', 'a', 0.0))
 *    ('~fmul', ('fsqrt', 'a'), ('fsqrt', 'a')) => ('fabs', 'a')
 *    ('~fmulz', ('fsqrt', 'a'), ('fsqrt', 'a')) => ('fabs', 'a')
 *    ('~fdiv', 1.0, 'a') => ('frcp', 'a')
 *    ('fdiv', 'a', 'b') => ('fmul', 'a', ('frcp', 'b'))
 *    ('~frcp', ('frcp', 'a')) => a
 *    ('~frcp', ('fsqrt', 'a')) => ('frsq', 'a')
 *    ('fsqrt', 'a') => ('frcp', ('frsq', 'a'))
 *    ('~frcp', ('frsq', 'a')) => ('fsqrt', 'a')
 *    ('fsin', 'a') => ('ffma', ('ffma', ('fmul', ('fsub', ('fsub', ('fmul', 2.0, ('ffract', ('fadd', ('fmul', 0.15915494309189535, 'a'), 0.5))), 1.0), ('fmul', ('fsub', ('fmul', 2.0, ('ffract', ('fadd', ('fmul', 0.15915494309189535, 'a'), 0.5))), 1.0), ('fabs', ('fsub', ('fmul', 2.0, ('ffract', ('fadd', ('fmul', 0.15915494309189535, 'a'), 0.5))), 1.0)))), 4.0), ('fabs', ('fmul', ('fsub', ('fsub', ('fmul', 2.0, ('ffract', ('fadd', ('fmul', 0.15915494309189535, 'a'), 0.5))), 1.0), ('fmul', ('fsub', ('fmul', 2.0, ('ffract', ('fadd', ('fmul', 0.15915494309189535, 'a'), 0.5))), 1.0), ('fabs', ('fsub', ('fmul', 2.0, ('ffract', ('fadd', ('fmul', 0.15915494309189535, 'a'), 0.5))), 1.0)))), 4.0)), ('fneg', ('fmul', ('fsub', ('fsub', ('fmul', 2.0, ('ffract', ('fadd', ('fmul', 0.15915494309189535, 'a'), 0.5))), 1.0), ('fmul', ('fsub', ('fmul', 2.0, ('ffract', ('fadd', ('fmul', 0.15915494309189535, 'a'), 0.5))), 1.0), ('fabs', ('fsub', ('fmul', 2.0, ('ffract', ('fadd', ('fmul', 0.15915494309189535, 'a'), 0.5))), 1.0)))), 4.0))), 0.225, ('fmul', ('fsub', ('fsub', ('fmul', 2.0, ('ffract', ('fadd', ('fmul', 0.15915494309189535, 'a'), 0.5))), 1.0), ('fmul', ('fsub', ('fmul', 2.0, ('ffract', ('fadd', ('fmul', 0.15915494309189535, 'a'), 0.5))), 1.0), ('fabs', ('fsub', ('fmul', 2.0, ('ffract', ('fadd', ('fmul', 0.15915494309189535, 'a'), 0.5))), 1.0)))), 4.0))
 *    ('fcos', 'a') => ('ffma', ('ffma', ('fmul', ('fsub', ('fsub', ('fmul', 2.0, ('ffract', ('fadd', ('fmul', 0.15915494309189535, 'a'), 0.75))), 1.0), ('fmul', ('fsub', ('fmul', 2.0, ('ffract', ('fadd', ('fmul', 0.15915494309189535, 'a'), 0.75))), 1.0), ('fabs', ('fsub', ('fmul', 2.0, ('ffract', ('fadd', ('fmul', 0.15915494309189535, 'a'), 0.75))), 1.0)))), 4.0), ('fabs', ('fmul', ('fsub', ('fsub', ('fmul', 2.0, ('ffract', ('fadd', ('fmul', 0.15915494309189535, 'a'), 0.75))), 1.0), ('fmul', ('fsub', ('fmul', 2.0, ('ffract', ('fadd', ('fmul', 0.15915494309189535, 'a'), 0.75))), 1.0), ('fabs', ('fsub', ('fmul', 2.0, ('ffract', ('fadd', ('fmul', 0.15915494309189535, 'a'), 0.75))), 1.0)))), 4.0)), ('fneg', ('fmul', ('fsub', ('fsub', ('fmul', 2.0, ('ffract', ('fadd', ('fmul', 0.15915494309189535, 'a'), 0.75))), 1.0), ('fmul', ('fsub', ('fmul', 2.0, ('ffract', ('fadd', ('fmul', 0.15915494309189535, 'a'), 0.75))), 1.0), ('fabs', ('fsub', ('fmul', 2.0, ('ffract', ('fadd', ('fmul', 0.15915494309189535, 'a'), 0.75))), 1.0)))), 4.0))), 0.225, ('fmul', ('fsub', ('fsub', ('fmul', 2.0, ('ffract', ('fadd', ('fmul', 0.15915494309189535, 'a'), 0.75))), 1.0), ('fmul', ('fsub', ('fmul', 2.0, ('ffract', ('fadd', ('fmul', 0.15915494309189535, 'a'), 0.75))), 1.0), ('fabs', ('fsub', ('fmul', 2.0, ('ffract', ('fadd', ('fmul', 0.15915494309189535, 'a'), 0.75))), 1.0)))), 4.0))
 *    ('ieq', 'a', True) => a
 *    ('ine(is_not_used_by_if)', 'a', True) => ('inot', 'a')
 *    ('ine', 'a', False) => a
 *    ('ieq(is_not_used_by_if)', 'a', False) => ('inot', 'a')
 *    ('bcsel', 'a', True, False) => a
 *    ('bcsel', 'a', False, True) => ('inot', 'a')
 *    ('bcsel', True, 'b', 'c') => b
 *    ('bcsel', False, 'b', 'c') => c
 *    ('bcsel@16', 'a', 1.0, 0.0) => ('b2f', 'a')
 *    ('bcsel@16', 'a', 0.0, 1.0) => ('b2f', ('inot', 'a'))
 *    ('bcsel@16', 'a', -1.0, -0.0) => ('fneg', ('b2f', 'a'))
 *    ('bcsel@16', 'a', -0.0, -1.0) => ('fneg', ('b2f', ('inot', 'a')))
 *    ('bcsel@32', 'a', 1.0, 0.0) => ('b2f', 'a')
 *    ('bcsel@32', 'a', 0.0, 1.0) => ('b2f', ('inot', 'a'))
 *    ('bcsel@32', 'a', -1.0, -0.0) => ('fneg', ('b2f', 'a'))
 *    ('bcsel@32', 'a', -0.0, -1.0) => ('fneg', ('b2f', ('inot', 'a')))
 *    ('bcsel@64', 'a', 1.0, 0.0) => ('b2f', 'a')
 *    ('bcsel@64', 'a', 0.0, 1.0) => ('b2f', ('inot', 'a'))
 *    ('bcsel@64', 'a', -1.0, -0.0) => ('fneg', ('b2f', 'a'))
 *    ('bcsel@64', 'a', -0.0, -1.0) => ('fneg', ('b2f', ('inot', 'a')))
 *    ('bcsel', 'a', 'b', 'b') => b
 *    ('~fcsel', 'a', 'b', 'b') => b
 *    ('bcsel', 'a', -1, 0) => ('ineg', ('b2i', 'a@1'))
 *    ('bcsel', 'a', 0, -1) => ('ineg', ('b2i', ('inot', 'a')))
 *    ('bcsel', 'a', 1, 0) => ('b2i', 'a@1')
 *    ('bcsel', 'a', 0, 1) => ('b2i', ('inot', 'a'))
 *    ('iand', ('ineg', ('b2i', 'a@1')), ('ineg', ('b2i', 'b@1'))) => ('ineg', ('b2i', ('iand', 'a', 'b')))
 *    ('ior', ('ineg', ('b2i', 'a@1')), ('ineg', ('b2i', 'b@1'))) => ('ineg', ('b2i', ('ior', 'a', 'b')))
 *    ('ieq', ('ineg', ('b2i', 'a@1')), -1) => a
 *    ('ine', ('ineg', ('b2i', 'a@1')), -1) => ('inot', 'a')
 *    ('ige', ('ineg', ('b2i', 'a@1')), 0) => ('inot', 'a')
 *    ('ilt', ('ineg', ('b2i', 'a@1')), 0) => a
 *    ('ult', 0, ('ineg', ('b2i', 'a@1'))) => a
 *    ('iand', ('ineg', ('b2i', 'a')), 1.0) => ('b2f', 'a')
 *    ('iand', ('ineg', ('b2i', 'a')), 1) => ('b2i', 'a')
 *    ('imax', ('ineg', ('b2i', 'a@1')), ('ineg', ('b2i', 'b@1'))) => ('ineg', ('b2i', ('iand', 'a', 'b')))
 *    ('imin', ('ineg', ('b2i', 'a@1')), ('ineg', ('b2i', 'b@1'))) => ('ineg', ('b2i', ('ior', 'a', 'b')))
 *    ('umax', ('ineg', ('b2i', 'a@1')), ('ineg', ('b2i', 'b@1'))) => ('ineg', ('b2i', ('ior', 'a', 'b')))
 *    ('umin', ('ineg', ('b2i', 'a@1')), ('ineg', ('b2i', 'b@1'))) => ('ineg', ('b2i', ('iand', 'a', 'b')))
 *    ('umax', ('b2i', 'a@1'), ('b2i', 'b@1')) => ('b2i', ('ior', 'a', 'b'))
 *    ('umin', ('b2i', 'a@1'), ('b2i', 'b@1')) => ('b2i', ('iand', 'a', 'b'))
 *    ('iand', ('b2i', 'a'), 1) => ('b2i', 'a')
 *    ('ine', ('umin', ('ineg', ('b2i', 'a@1')), 'b'), 0) => ('iand', 'a', ('ine', 'b', 0))
 *    ('ine', ('umax', ('ineg', ('b2i', 'a@1')), 'b'), 0) => ('ior', 'a', ('ine', 'b', 0))
 *    ('f2i', ('ftrunc', 'a')) => ('f2i', 'a')
 *    ('f2u', ('ftrunc', 'a')) => ('f2u', 'a')
 *    ('f2fmp', ('f2f32', 'a@16')) => a
 *    ('i2imp', ('i2i32', 'a@16')) => a
 *    ('i2imp', ('u2u32', 'a@16')) => a
 *    ('f2imp', ('f2f32', 'a@16')) => ('f2i16', 'a')
 *    ('f2ump', ('f2f32', 'a@16')) => ('f2u16', 'a')
 *    ('i2fmp', ('i2i32', 'a@16')) => ('i2f16', 'a')
 *    ('u2fmp', ('u2u32', 'a@16')) => ('u2f16', 'a')
 *    ('f2fmp', ('b2f32', 'a@1')) => ('b2f16', 'a')
 *    ('i2imp', ('b2i32', 'a@1')) => ('b2i16', 'a')
 *    ('i2imp', ('b2i32', 'a@1')) => ('b2i16', 'a')
 *    ('f2imp', ('b2f32', 'a@1')) => ('b2i16', 'a')
 *    ('f2ump', ('b2f32', 'a@1')) => ('b2i16', 'a')
 *    ('i2fmp', ('b2i32', 'a@1')) => ('b2f16', 'a')
 *    ('u2fmp', ('b2i32', 'a@1')) => ('b2f16', 'a')
 *    ('f2f32', ('f2fmp', 'a@32')) => a
 *    ('i2i32', ('i2imp', 'a@32')) => a
 *    ('u2u32', ('i2imp', 'a@32')) => a
 *    ('i2i32', ('f2imp', 'a@32')) => ('f2i32', 'a')
 *    ('u2u32', ('f2ump', 'a@32')) => ('f2u32', 'a')
 *    ('f2f32', ('i2fmp', 'a@32')) => ('i2f32', 'a')
 *    ('f2f32', ('u2fmp', 'a@32')) => ('u2f32', 'a')
 *    ('f2i32', ('f2fmp', 'a@32')) => ('f2i32', 'a')
 *    ('f2u32', ('f2fmp', 'a@32')) => ('f2u32', 'a')
 *    ('i2f32', ('i2imp', 'a@32')) => ('i2f32', 'a')
 *    ('ffloor', 'a(is_integral)') => a
 *    ('fceil', 'a(is_integral)') => a
 *    ('ftrunc', 'a(is_integral)') => a
 *    ('fround_even', 'a(is_integral)') => a
 *    ('~ffract', 'a(is_integral)') => 0.0
 *    ('fabs', 'a(is_not_negative)') => a
 *    ('iabs', 'a(is_not_negative)') => a
 *    ('fsat', 'a(is_not_positive)') => 0.0
 *    ('~fmin', 'a(is_not_negative)', 1.0) => ('fsat', 'a')
 *    ('flt', ('fadd', ('fmul', ('fsat', 'a'), ('fneg', ('fsat', 'a'))), 1.0), 0.0) => False
 *    ('flt', ('fadd', ('fneg', ('fmul', ('fsat', 'a'), ('fsat', 'a'))), 1.0), 0.0) => False
 *    ('fmax', ('fadd', ('fmul', ('fsat', 'a'), ('fneg', ('fsat', 'a'))), 1.0), 0.0) => ('fadd', ('fmul', ('fsat', 'a'), ('fneg', ('fsat', 'a'))), 1.0)
 *    ('fmax', ('fadd', ('fneg', ('fmul', ('fsat', 'a'), ('fsat', 'a'))), 1.0), 0.0) => ('fadd', ('fneg', ('fmul', ('fsat', 'a'), ('fsat', 'a'))), 1.0)
 *    ('fneu', 'a(is_not_zero)', 0.0) => True
 *    ('feq', 'a(is_not_zero)', 0.0) => False
 *    ('fge', 'a(is_a_number_not_negative)', 'b(is_a_number_not_positive)') => True
 *    ('fge', 'a(is_not_positive)', 'b(is_gt_zero)') => False
 *    ('fge', 'a(is_lt_zero)', 'b(is_not_negative)') => False
 *    ('flt', 'a(is_not_negative)', 'b(is_not_positive)') => False
 *    ('flt', 'a(is_a_number_not_positive)', 'b(is_a_number_gt_zero)') => True
 *    ('flt', 'a(is_a_number_lt_zero)', 'b(is_a_number_not_negative)') => True
 *    ('ine', 'a(is_not_zero)', 0) => True
 *    ('ieq', 'a(is_not_zero)', 0) => False
 *    ('ige', 'a(is_not_negative)', 'b(is_not_positive)') => True
 *    ('ige', 'a(is_not_positive)', 'b(is_gt_zero)') => False
 *    ('ige', 'a(is_lt_zero)', 'b(is_not_negative)') => False
 *    ('ilt', 'a(is_not_negative)', 'b(is_not_positive)') => False
 *    ('ilt', 'a(is_not_positive)', 'b(is_gt_zero)') => True
 *    ('ilt', 'a(is_lt_zero)', 'b(is_not_negative)') => True
 *    ('ult', 0, 'a(is_gt_zero)') => True
 *    ('ult', 'a', 0) => False
 *    ('unpack_64_2x32_split_x', ('pack_64_2x32_split', 'a', 'b')) => a
 *    ('unpack_64_2x32_split_y', ('pack_64_2x32_split', 'a', 'b')) => b
 *    ('unpack_64_2x32_split_x', ('pack_64_2x32', 'a')) => a.x
 *    ('unpack_64_2x32_split_y', ('pack_64_2x32', 'a')) => a.y
 *    ('unpack_64_2x32_split_x', ('u2u64', 'a@32')) => a
 *    ('unpack_64_2x32_split_y', ('u2u64', 'a')) => 0
 *    ('unpack_64_2x32_split_x', ('i2i64', 'a@32')) => a
 *    ('unpack_64_2x32_split_y', ('i2i64(is_used_once)', 'a@32')) => ('ishr', 'a', 31)
 *    ('unpack_64_2x32', ('pack_64_2x32_split', 'a', 'b')) => ('vec2', 'a', 'b')
 *    ('unpack_64_2x32', ('pack_64_2x32', 'a')) => a
 *    ('unpack_double_2x32_dxil', ('pack_double_2x32_dxil', 'a')) => a
 *    ('pack_64_2x32_split', ('unpack_64_2x32_split_x', 'a'), ('unpack_64_2x32_split_y', 'a')) => a
 *    ('pack_64_2x32', ('vec2', ('unpack_64_2x32_split_x', 'a'), ('unpack_64_2x32_split_y', 'a'))) => a
 *    ('pack_64_2x32', ('unpack_64_2x32', 'a')) => a
 *    ('pack_double_2x32_dxil', ('unpack_double_2x32_dxil', 'a')) => a
 *    ('unpack_64_4x16', ('pack_64_4x16', 'a')) => a
 *    ('unpack_64_4x16', ('pack_64_2x32', ('vec2', ('pack_32_2x16_split', 'a', 'b'), ('pack_32_2x16_split', 'c', 'd')))) => ('vec4', 'a', 'b', 'c', 'd')
 *    ('unpack_64_4x16', ('pack_64_2x32_split', ('pack_32_2x16_split', 'a', 'b'), ('pack_32_2x16_split', 'c', 'd'))) => ('vec4', 'a', 'b', 'c', 'd')
 *    ('iand', ('ieq', ('unpack_32_2x16_split_x', 'a'), '#b'), ('ieq', ('unpack_32_2x16_split_y', 'a'), '#c')) => ('ieq', 'a', ('pack_32_2x16_split', 'b', 'c'))
 *    ('ushr', 'a@16', 8) => ('extract_u8', 'a', 1)
 *    ('ushr', 'a@32', 24) => ('extract_u8', 'a', 3)
 *    ('ushr', 'a@64', 56) => ('extract_u8', 'a', 7)
 *    ('ishr', 'a@16', 8) => ('extract_i8', 'a', 1)
 *    ('ishr', 'a@32', 24) => ('extract_i8', 'a', 3)
 *    ('ishr', 'a@64', 56) => ('extract_i8', 'a', 7)
 *    ('iand', 255, 'a') => ('extract_u8', 'a', 0)
 *    ('ishr', ('iand', 'a@32', 65280), 8) => ('extract_u8', 'a', 1)
 *    ('ishr', ('iand', 'a@64', 65280), 8) => ('extract_u8', 'a', 1)
 *    ('ishr', ('iand', 'a', 16711680), 16) => ('extract_u8', 'a', 2)
 *    ('u2u8', ('extract_u16', 'a', 1)) => ('u2u8', ('extract_u8', 'a', 2))
 *    ('u2u8', ('ushr', 'a', 8)) => ('u2u8', ('extract_u8', 'a', 1))
 *    ('i2i16', ('u2u8', ('extract_u8', 'a', 'b'))) => ('i2i16', ('extract_i8', 'a', 'b'))
 *    ('u2u16', ('u2u8', ('extract_u8', 'a', 'b'))) => ('u2u16', ('extract_u8', 'a', 'b'))
 *    ('ubfe', 'a', 0, 8) => ('extract_u8', 'a', 0)
 *    ('ubfe', 'a', 8, 8) => ('extract_u8', 'a', 1)
 *    ('ubfe', 'a', 16, 8) => ('extract_u8', 'a', 2)
 *    ('ubfe', 'a', 24, 8) => ('extract_u8', 'a', 3)
 *    ('ibfe', 'a', 0, 8) => ('extract_i8', 'a', 0)
 *    ('ibfe', 'a', 8, 8) => ('extract_i8', 'a', 1)
 *    ('ibfe', 'a', 16, 8) => ('extract_i8', 'a', 2)
 *    ('ibfe', 'a', 24, 8) => ('extract_i8', 'a', 3)
 *    ('extract_u8', ('extract_i8', 'a', 'b'), 0) => ('extract_u8', 'a', 'b')
 *    ('extract_u8', ('extract_u8', 'a', 'b'), 0) => ('extract_u8', 'a', 'b')
 *    ('extract_i8', ('iand', 'a', 65280), 1) => ('extract_i8', 'a', 1)
 *    ('extract_i8', ('iand', 'a', 16711680), 2) => ('extract_i8', 'a', 2)
 *    ('extract_i8', ('iand', 'a', 4278190080), 3) => ('extract_i8', 'a', 3)
 *    ('extract_u8', ('iand', 'a', 65280), 1) => ('extract_u8', 'a', 1)
 *    ('extract_u8', ('iand', 'a', 16711680), 2) => ('extract_u8', 'a', 2)
 *    ('extract_u8', ('iand', 'a', 4278190080), 3) => ('extract_u8', 'a', 3)
 *    ('iand', ('extract_u8', 'a', 0), '#b') => ('iand', 'a', ('iand', 'b', 255))
 *    ('iand', ('extract_u16', 'a', 0), '#b') => ('iand', 'a', ('iand', 'b', 65535))
 *    ('ieq', ('iand', ('extract_u8', 'a', '#b'), '#c'), 0) => ('ieq', ('iand', 'a', ('ishl', ('iand', 'c', 255), ('imul', ('i2i32', 'b'), 8))), 0)
 *    ('ine', ('iand', ('extract_u8', 'a', '#b'), '#c'), 0) => ('ine', ('iand', 'a', ('ishl', ('iand', 'c', 255), ('imul', ('i2i32', 'b'), 8))), 0)
 *    ('ieq', ('iand', ('extract_u16(is_used_once)', 'a', '#b'), '#c'), 0) => ('ieq', ('iand', 'a', ('ishl', ('iand', 'c', 65535), ('imul', ('i2i32', 'b'), 16))), 0)
 *    ('ine', ('iand', ('extract_u16(is_used_once)', 'a', '#b'), '#c'), 0) => ('ine', ('iand', 'a', ('ishl', ('iand', 'c', 65535), ('imul', ('i2i32', 'b'), 16))), 0)
 *    ('ushr', ('ishl', 'a@32', 16), 16) => ('extract_u16', 'a', 0)
 *    ('ushr', 'a@32', 16) => ('extract_u16', 'a', 1)
 *    ('ishr', ('ishl', 'a@32', 16), 16) => ('extract_i16', 'a', 0)
 *    ('ishr', 'a@32', 16) => ('extract_i16', 'a', 1)
 *    ('iand', 65535, 'a') => ('extract_u16', 'a', 0)
 *    ('ubfe', 'a', 0, 16) => ('extract_u16', 'a', 0)
 *    ('ubfe', 'a', 16, 16) => ('extract_u16', 'a', 1)
 *    ('ibfe', 'a', 0, 16) => ('extract_i16', 'a', 0)
 *    ('ibfe', 'a', 16, 16) => ('extract_i16', 'a', 1)
 *    ('unpack_32_4x8', ('pack_32_4x8', 'a')) => a
 *    ('unpack_32_2x16', ('pack_32_2x16', 'a')) => a
 *    ('unpack_64_4x16', ('pack_64_4x16', 'a')) => a
 *    ('unpack_64_2x32', ('pack_64_2x32', 'a')) => a
 *    ('pack_32_4x8', ('unpack_32_4x8', 'a')) => a
 *    ('pack_32_2x16', ('unpack_32_2x16', 'a')) => a
 *    ('pack_64_4x16', ('unpack_64_4x16', 'a')) => a
 *    ('pack_64_2x32', ('unpack_64_2x32', 'a')) => a
 *    ('ior', ('ishl', ('u2u32', 'a@8'), 24), ('ior', ('ishl', ('u2u32', 'b@8'), 16), ('ior', ('ishl', ('u2u32', 'c@8'), 8), ('u2u32', 'd@8')))) => ('pack_32_4x8', ('vec4', 'd', 'c', 'b', 'a'))
 *    ('extract_u16', ('extract_i16', 'a', 'b'), 0) => ('extract_u16', 'a', 'b')
 *    ('extract_u16', ('extract_u16', 'a', 'b'), 0) => ('extract_u16', 'a', 'b')
 *    ('extract_i16', ('iand', 'a', 16711680), 1) => ('extract_u8', 'a', 2)
 *    ('extract_u16', ('iand', 'a', 16711680), 1) => ('extract_u8', 'a', 2)
 *    ('pack_64_2x32_split', 'a', 'b') => ('ior', ('u2u64', 'a'), ('ishl', ('u2u64', 'b'), 32))
 *    ('pack_32_2x16_split', 'a', 'b') => ('ior', ('u2u32', 'a'), ('ishl', ('u2u32', 'b'), 16))
 *    ('pack_half_2x16_split', 'a', 'b') => ('pack_half_2x16_rtz_split', 'a', 'b')
 *    ('unpack_64_2x32_split_x', 'a') => ('u2u32', 'a')
 *    ('unpack_64_2x32_split_y', 'a') => ('u2u32', ('ushr', 'a', 32))
 *    ('unpack_32_2x16_split_x', 'a') => ('u2u16', 'a')
 *    ('unpack_32_2x16_split_y', 'a') => ('u2u16', ('ushr', 'a', 16))
 *    ('unpack_64_2x32_split_x', ('ushr', 'a', 32)) => ('unpack_64_2x32_split_y', 'a')
 *    ('u2u32', ('ushr', 'a@64', 32)) => ('unpack_64_2x32_split_y', 'a')
 *    ('unpack_half_2x16_split_x', ('iand', 'a', 65535)) => ('unpack_half_2x16_split_x', 'a')
 *    ('unpack_32_2x16_split_x', ('iand', 'a', 65535)) => ('unpack_32_2x16_split_x', 'a')
 *    ('unpack_64_2x32_split_x', ('iand', 'a', 4294967295)) => ('unpack_64_2x32_split_x', 'a')
 *    ('unpack_half_2x16_split_y', ('iand', 'a', 4294901760)) => ('unpack_half_2x16_split_y', 'a')
 *    ('unpack_32_2x16_split_y', ('iand', 'a', 4294901760)) => ('unpack_32_2x16_split_y', 'a')
 *    ('unpack_64_2x32_split_y', ('iand', 'a', 18446744069414584320)) => ('unpack_64_2x32_split_y', 'a')
 *    ('unpack_half_2x16_split_x', ('extract_u16', 'a', 0)) => ('unpack_half_2x16_split_x', 'a')
 *    ('unpack_half_2x16_split_x', ('extract_u16', 'a', 1)) => ('unpack_half_2x16_split_y', 'a')
 *    ('unpack_half_2x16_split_x', ('ushr', 'a', 16)) => ('unpack_half_2x16_split_y', 'a')
 *    ('unpack_32_2x16_split_x', ('extract_u16', 'a', 0)) => ('unpack_32_2x16_split_x', 'a')
 *    ('unpack_32_2x16_split_x', ('extract_u16', 'a', 1)) => ('unpack_32_2x16_split_y', 'a')
 *    ('ishl', ('pack_half_2x16', ('vec2', 'a', 0)), 16) => ('pack_half_2x16', ('vec2', 0, 'a'))
 *    ('ushr', ('pack_half_2x16', ('vec2', 0, 'a')), 16) => ('pack_half_2x16', ('vec2', 'a', 0))
 *    ('iadd', ('pack_half_2x16', ('vec2', 'a', 0)), ('pack_half_2x16', ('vec2', 0, 'b'))) => ('pack_half_2x16', ('vec2', 'a', 'b'))
 *    ('ior', ('pack_half_2x16', ('vec2', 'a', 0)), ('pack_half_2x16', ('vec2', 0, 'b'))) => ('pack_half_2x16', ('vec2', 'a', 'b'))
 *    ('ishl', ('pack_half_2x16_split', 'a', 0), 16) => ('pack_half_2x16_split', 0, 'a')
 *    ('ushr', ('pack_half_2x16_split', 0, 'a'), 16) => ('pack_half_2x16_split', 'a', 0)
 *    ('extract_u16', ('pack_half_2x16_split', 0, 'a'), 1) => ('pack_half_2x16_split', 'a', 0)
 *    ('ishl', ('pack_half_2x16_rtz_split', 'a', 0), 16) => ('pack_half_2x16_rtz_split', 0, 'a')
 *    ('ushr', ('pack_half_2x16_rtz_split', 0, 'a'), 16) => ('pack_half_2x16_rtz_split', 'a', 0)
 *    ('extract_u16', ('pack_half_2x16_rtz_split', 0, 'a'), 1) => ('pack_half_2x16_rtz_split', 'a', 0)
 *    ('iadd', ('pack_half_2x16_split', 'a', 0), ('pack_half_2x16_split', 0, 'b')) => ('pack_half_2x16_split', 'a', 'b')
 *    ('ior', ('pack_half_2x16_split', 'a', 0), ('pack_half_2x16_split', 0, 'b')) => ('pack_half_2x16_split', 'a', 'b')
 *    ('iadd', ('pack_half_2x16_rtz_split', 'a', 0), ('pack_half_2x16_rtz_split', 0, 'b')) => ('pack_half_2x16_rtz_split', 'a', 'b')
 *    ('ior', ('pack_half_2x16_rtz_split', 'a', 0), ('pack_half_2x16_rtz_split', 0, 'b')) => ('pack_half_2x16_rtz_split', 'a', 'b')
 *    ('pack_uint_2x16', ('vec2', ('pack_half_2x16_rtz_split', 'a', 0), ('pack_half_2x16_rtz_split', 'b', 0))) => ('pack_half_2x16_rtz_split', 'a', 'b')
 *    ('bfi', 4294901760, ('pack_half_2x16_split', 'a', 'b'), ('pack_half_2x16_split', 'c', 'd')) => ('pack_half_2x16_split', 'c', 'a')
 *    ('iand', ('bfi', 15, '#a', 'b'), 4294967292) => ('bfi', 15, ('iand', 'a', 4294967292), 'b')
 *    ('iand', ('bfi', 7, '#a', 'b'), 4294967292) => ('bfi', 7, ('iand', 'a', 4294967292), 'b')
 *    ('umin', ('ishl', ('iand', 'a', 15), 3), 120) => ('ishl', ('iand', 'a', 15), 3)
 *    ('extract_i8', ('pack_32_4x8_split', 'a', 'b', 'c', 'd'), 0) => ('i2i', 'a')
 *    ('extract_i8', ('pack_32_4x8_split', 'a', 'b', 'c', 'd'), 1) => ('i2i', 'b')
 *    ('extract_i8', ('pack_32_4x8_split', 'a', 'b', 'c', 'd'), 2) => ('i2i', 'c')
 *    ('extract_i8', ('pack_32_4x8_split', 'a', 'b', 'c', 'd'), 3) => ('i2i', 'd')
 *    ('extract_u8', ('pack_32_4x8_split', 'a', 'b', 'c', 'd'), 0) => ('u2u', 'a')
 *    ('extract_u8', ('pack_32_4x8_split', 'a', 'b', 'c', 'd'), 1) => ('u2u', 'b')
 *    ('extract_u8', ('pack_32_4x8_split', 'a', 'b', 'c', 'd'), 2) => ('u2u', 'c')
 *    ('extract_u8', ('pack_32_4x8_split', 'a', 'b', 'c', 'd'), 3) => ('u2u', 'd')
 *    ('u2u32', ('iadd(is_used_once)', 'a@64', 'b')) => ('iadd', ('u2u32', 'a'), ('u2u32', 'b'))
 *    ('u2u32', ('imul(is_used_once)', 'a@64', 'b')) => ('imul', ('u2u32', 'a'), ('u2u32', 'b'))
 *    ('u2f32', ('u2u64', 'a@32')) => ('u2f32', 'a')
 *    ('ult', 4294967295, 'a@64') => ('ine', ('unpack_64_2x32_split_y', 'a'), 0)
 *    ('i2i16', ('u2u8', ('iand', 'a@16', 1))) => ('iand', 'a@16', 1)
 *    ('u2u16', ('u2u8', ('iand', 'a@16', 1))) => ('iand', 'a@16', 1)
 *    ('bcsel', 'a', 0, ('b2i16', 'b@1')) => ('b2i16', ('iand', ('inot', 'a'), 'b'))
 *    ('bcsel', 'a', ('b2i16', 'b@1'), ('b2i16', 'c@1')) => ('b2i16', ('bcsel', 'a', 'b', 'c'))
 *    ('u2u32', ('ushr', ('ior', ('ishl', 'a', 32), ('u2u64', 'b@8')), 32)) => ('u2u32', 'a')
 *    ('u2u32', ('ushr', ('ior', ('ishl', 'a', 32), ('u2u64', 'b@16')), 32)) => ('u2u32', 'a')
 *    ('u2u32', ('ushr', ('ior', ('ishl', 'a', 32), ('u2u64', 'b@32')), 32)) => ('u2u32', 'a')
 *    ('u2u16', ('ushr', ('ior', ('ishl', 'a', 16), ('u2u32', 'b@8')), 16)) => ('u2u16', 'a')
 *    ('u2u16', ('ushr', ('ior', ('ishl', 'a', 16), ('u2u32', 'b@16')), 16)) => ('u2u16', 'a')
 *    ('extract_u8', ('ushr', 'a@16', 8), 0) => ('extract_u8', 'a', 1)
 *    ('extract_u8', ('ushr', 'a@32', 8), 0) => ('extract_u8', 'a', 1)
 *    ('extract_u8', ('ushr', 'a@32', 16), 0) => ('extract_u8', 'a', 2)
 *    ('extract_u8', ('ushr', 'a@32', 24), 0) => ('extract_u8', 'a', 3)
 *    ('extract_u8', ('ushr', 'a@64', 8), 0) => ('extract_u8', 'a', 1)
 *    ('extract_u8', ('ushr', 'a@64', 16), 0) => ('extract_u8', 'a', 2)
 *    ('extract_u8', ('ushr', 'a@64', 24), 0) => ('extract_u8', 'a', 3)
 *    ('extract_u8', ('ushr', 'a@64', 32), 0) => ('extract_u8', 'a', 4)
 *    ('extract_u8', ('ushr', 'a@64', 40), 0) => ('extract_u8', 'a', 5)
 *    ('extract_u8', ('ushr', 'a@64', 48), 0) => ('extract_u8', 'a', 6)
 *    ('extract_u8', ('ushr', 'a@64', 56), 0) => ('extract_u8', 'a', 7)
 *    ('extract_u8', ('ishr', 'a@16', 8), 0) => ('extract_u8', 'a', 1)
 *    ('extract_u8', ('ishr', 'a@32', 8), 0) => ('extract_u8', 'a', 1)
 *    ('extract_u8', ('ishr', 'a@32', 16), 0) => ('extract_u8', 'a', 2)
 *    ('extract_u8', ('ishr', 'a@32', 24), 0) => ('extract_u8', 'a', 3)
 *    ('extract_u8', ('ishr', 'a@64', 8), 0) => ('extract_u8', 'a', 1)
 *    ('extract_u8', ('ishr', 'a@64', 16), 0) => ('extract_u8', 'a', 2)
 *    ('extract_u8', ('ishr', 'a@64', 24), 0) => ('extract_u8', 'a', 3)
 *    ('extract_u8', ('ishr', 'a@64', 32), 0) => ('extract_u8', 'a', 4)
 *    ('extract_u8', ('ishr', 'a@64', 40), 0) => ('extract_u8', 'a', 5)
 *    ('extract_u8', ('ishr', 'a@64', 48), 0) => ('extract_u8', 'a', 6)
 *    ('extract_u8', ('ishr', 'a@64', 56), 0) => ('extract_u8', 'a', 7)
 *    ('extract_u8', ('extract_u16', 'a', 1), 0) => ('extract_u8', 'a', 2)
 *    ('extract_u8', ('ishl', 'a@16', 8), 1) => ('extract_u8', 'a', 0)
 *    ('extract_u8', ('ishl', 'a@32', 8), 3) => ('extract_u8', 'a', 2)
 *    ('extract_u8', ('ishl', 'a@32', 16), 3) => ('extract_u8', 'a', 1)
 *    ('extract_u8', ('ishl', 'a@32', 24), 3) => ('extract_u8', 'a', 0)
 *    ('extract_u8', ('ishl', 'a@64', 8), 7) => ('extract_u8', 'a', 6)
 *    ('extract_u8', ('ishl', 'a@64', 16), 7) => ('extract_u8', 'a', 5)
 *    ('extract_u8', ('ishl', 'a@64', 24), 7) => ('extract_u8', 'a', 4)
 *    ('extract_u8', ('ishl', 'a@64', 32), 7) => ('extract_u8', 'a', 3)
 *    ('extract_u8', ('ishl', 'a@64', 40), 7) => ('extract_u8', 'a', 2)
 *    ('extract_u8', ('ishl', 'a@64', 48), 7) => ('extract_u8', 'a', 1)
 *    ('extract_u8', ('ishl', 'a@64', 56), 7) => ('extract_u8', 'a', 0)
 *    ('extract_i8', ('ishl', 'a@16', 8), 1) => ('extract_i8', 'a', 0)
 *    ('extract_i8', ('ishl', 'a@32', 8), 3) => ('extract_i8', 'a', 2)
 *    ('extract_i8', ('ishl', 'a@32', 16), 3) => ('extract_i8', 'a', 1)
 *    ('extract_i8', ('ishl', 'a@32', 24), 3) => ('extract_i8', 'a', 0)
 *    ('extract_i8', ('ishl', 'a@64', 8), 7) => ('extract_i8', 'a', 6)
 *    ('extract_i8', ('ishl', 'a@64', 16), 7) => ('extract_i8', 'a', 5)
 *    ('extract_i8', ('ishl', 'a@64', 24), 7) => ('extract_i8', 'a', 4)
 *    ('extract_i8', ('ishl', 'a@64', 32), 7) => ('extract_i8', 'a', 3)
 *    ('extract_i8', ('ishl', 'a@64', 40), 7) => ('extract_i8', 'a', 2)
 *    ('extract_i8', ('ishl', 'a@64', 48), 7) => ('extract_i8', 'a', 1)
 *    ('extract_i8', ('ishl', 'a@64', 56), 7) => ('extract_i8', 'a', 0)
 *    ('ieq', ('pack_64_2x32_split', 'a', 0), ('pack_64_2x32_split', 'b', 0)) => ('ieq', 'a', 'b')
 *    ('ieq', ('pack_64_2x32_split', 'a', 0), '#b(is_upper_half_zero)') => ('ieq', 'a', ('unpack_64_2x32_split_x', 'b'))
 *    ('ieq', '#a(is_upper_half_zero)', ('pack_64_2x32_split', 'b', 0)) => ('ieq', ('unpack_64_2x32_split_x', 'a'), 'b')
 *    ('ieq', ('pack_64_2x32_split', 0, 'a'), ('pack_64_2x32_split', 0, 'b')) => ('ieq', 'a', 'b')
 *    ('ieq', ('pack_64_2x32_split', 0, 'a'), '#b(is_lower_half_zero)') => ('ieq', 'a', ('unpack_64_2x32_split_y', 'b'))
 *    ('ieq', '#a(is_lower_half_zero)', ('pack_64_2x32_split', 0, 'b')) => ('ieq', ('unpack_64_2x32_split_y', 'a'), 'b')
 *    ('ine', ('pack_64_2x32_split', 'a', 0), ('pack_64_2x32_split', 'b', 0)) => ('ine', 'a', 'b')
 *    ('ine', ('pack_64_2x32_split', 'a', 0), '#b(is_upper_half_zero)') => ('ine', 'a', ('unpack_64_2x32_split_x', 'b'))
 *    ('ine', '#a(is_upper_half_zero)', ('pack_64_2x32_split', 'b', 0)) => ('ine', ('unpack_64_2x32_split_x', 'a'), 'b')
 *    ('ine', ('pack_64_2x32_split', 0, 'a'), ('pack_64_2x32_split', 0, 'b')) => ('ine', 'a', 'b')
 *    ('ine', ('pack_64_2x32_split', 0, 'a'), '#b(is_lower_half_zero)') => ('ine', 'a', ('unpack_64_2x32_split_y', 'b'))
 *    ('ine', '#a(is_lower_half_zero)', ('pack_64_2x32_split', 0, 'b')) => ('ine', ('unpack_64_2x32_split_y', 'a'), 'b')
 *    ('ult', ('pack_64_2x32_split', 'a', 0), ('pack_64_2x32_split', 'b', 0)) => ('ult', 'a', 'b')
 *    ('ult', ('pack_64_2x32_split', 'a', 0), '#b(is_upper_half_zero)') => ('ult', 'a', ('unpack_64_2x32_split_x', 'b'))
 *    ('ult', '#a(is_upper_half_zero)', ('pack_64_2x32_split', 'b', 0)) => ('ult', ('unpack_64_2x32_split_x', 'a'), 'b')
 *    ('ult', ('pack_64_2x32_split', 0, 'a'), ('pack_64_2x32_split', 0, 'b')) => ('ult', 'a', 'b')
 *    ('ult', ('pack_64_2x32_split', 0, 'a'), '#b(is_lower_half_zero)') => ('ult', 'a', ('unpack_64_2x32_split_y', 'b'))
 *    ('ult', '#a(is_lower_half_zero)', ('pack_64_2x32_split', 0, 'b')) => ('ult', ('unpack_64_2x32_split_y', 'a'), 'b')
 *    ('ilt', ('pack_64_2x32_split', 'a', 0), ('pack_64_2x32_split', 'b', 0)) => ('ult', 'a', 'b')
 *    ('ilt', ('pack_64_2x32_split', 'a', 0), '#b(is_upper_half_zero)') => ('ult', 'a', ('unpack_64_2x32_split_x', 'b'))
 *    ('ilt', '#a(is_upper_half_zero)', ('pack_64_2x32_split', 'b', 0)) => ('ult', ('unpack_64_2x32_split_x', 'a'), 'b')
 *    ('ilt', ('pack_64_2x32_split', 0, 'a'), ('pack_64_2x32_split', 0, 'b')) => ('ilt', 'a', 'b')
 *    ('ilt', ('pack_64_2x32_split', 0, 'a'), '#b(is_lower_half_zero)') => ('ilt', 'a', ('unpack_64_2x32_split_y', 'b'))
 *    ('ilt', '#a(is_lower_half_zero)', ('pack_64_2x32_split', 0, 'b')) => ('ilt', ('unpack_64_2x32_split_y', 'a'), 'b')
 *    ('uge', ('pack_64_2x32_split', 'a', 0), ('pack_64_2x32_split', 'b', 0)) => ('uge', 'a', 'b')
 *    ('uge', ('pack_64_2x32_split', 'a', 0), '#b(is_upper_half_zero)') => ('uge', 'a', ('unpack_64_2x32_split_x', 'b'))
 *    ('uge', '#a(is_upper_half_zero)', ('pack_64_2x32_split', 'b', 0)) => ('uge', ('unpack_64_2x32_split_x', 'a'), 'b')
 *    ('uge', ('pack_64_2x32_split', 0, 'a'), ('pack_64_2x32_split', 0, 'b')) => ('uge', 'a', 'b')
 *    ('uge', ('pack_64_2x32_split', 0, 'a'), '#b(is_lower_half_zero)') => ('uge', 'a', ('unpack_64_2x32_split_y', 'b'))
 *    ('uge', '#a(is_lower_half_zero)', ('pack_64_2x32_split', 0, 'b')) => ('uge', ('unpack_64_2x32_split_y', 'a'), 'b')
 *    ('ige', ('pack_64_2x32_split', 'a', 0), ('pack_64_2x32_split', 'b', 0)) => ('uge', 'a', 'b')
 *    ('ige', ('pack_64_2x32_split', 'a', 0), '#b(is_upper_half_zero)') => ('uge', 'a', ('unpack_64_2x32_split_x', 'b'))
 *    ('ige', '#a(is_upper_half_zero)', ('pack_64_2x32_split', 'b', 0)) => ('uge', ('unpack_64_2x32_split_x', 'a'), 'b')
 *    ('ige', ('pack_64_2x32_split', 0, 'a'), ('pack_64_2x32_split', 0, 'b')) => ('ige', 'a', 'b')
 *    ('ige', ('pack_64_2x32_split', 0, 'a'), '#b(is_lower_half_zero)') => ('ige', 'a', ('unpack_64_2x32_split_y', 'b'))
 *    ('ige', '#a(is_lower_half_zero)', ('pack_64_2x32_split', 0, 'b')) => ('ige', ('unpack_64_2x32_split_y', 'a'), 'b')
 *    ('ussub_4x8_vc4', 'a', 0) => a
 *    ('ussub_4x8_vc4', 'a', -1) => 0
 *    ('fsub', 'a', 'b') => ('fadd', 'a', ('fneg', 'b'))
 *    ('isub', 'a', 'b') => ('iadd', 'a', ('ineg', 'b'))
 *    ('uabs_usub', 'a', 'b') => ('bcsel', ('ult', 'a', 'b'), ('ineg', ('isub', 'a', 'b')), ('isub', 'a', 'b'))
 *    ('uabs_isub', 'a', 'b') => ('bcsel', ('ilt', 'a', 'b'), ('ineg', ('isub', 'a', 'b')), ('isub', 'a', 'b'))
 *    ('bitz', 'a', 'b') => ('inot', ('bitnz', 'a', 'b'))
 *    ('fmul(is_used_by_non_fsat)', ('fneg', 'a'), 'b') => ('fneg', ('fmul', 'a', 'b'))
 *    ('fmulz(is_used_by_non_fsat,nsz)', ('fneg', 'a'), 'b') => ('fneg', ('fmulz', 'a', 'b'))
 *    ('ffma', ('fneg', 'a'), ('fneg', 'b'), 'c') => ('ffma', 'a', 'b', 'c')
 *    ('ffmaz', ('fneg', 'a'), ('fneg', 'b'), 'c') => ('ffmaz', 'a', 'b', 'c')
 *    ('imul', ('ineg', 'a'), 'b') => ('ineg', ('imul', 'a', 'b'))
 *    ('~fmul(is_used_once)', ('fmul(is_used_once)', 'a(is_not_const)', 'b(is_not_const)'), '#c') => ('fmul', ('fmul', 'a', 'c'), 'b')
 *    ('~fmulz(is_used_once)', ('fmulz(is_used_once)', 'a(is_not_const)', 'b(is_not_const)'), '#c') => ('fmulz', ('fmulz', 'a', 'c'), 'b')
 *    ('~fmul(is_used_once)', ('fmulz(is_used_once)', 'a(is_not_const)', 'b(is_not_const)'), '#c(is_finite_not_zero)') => ('fmulz', ('fmul', 'a', 'c'), 'b')
 *    ('imul(is_used_once)', ('imul(is_used_once)', 'a(is_not_const)', 'b(is_not_const)'), '#c') => ('imul', ('imul', 'a', 'c'), 'b')
 *    ('~ffma', ('fmul(is_used_once)', 'a(is_not_const)', 'b(is_not_const)'), '#c', 'd') => ('ffma', ('fmul', 'a', 'c'), 'b', 'd')
 *    ('~ffmaz', ('fmulz(is_used_once)', 'a(is_not_const)', 'b(is_not_const)'), '#c', 'd') => ('ffmaz', ('fmulz', 'a', 'c'), 'b', 'd')
 *    ('~ffma', ('fmulz(is_used_once)', 'a(is_not_const)', 'b(is_not_const)'), '#c(is_finite_not_zero)', 'd') => ('ffmaz', ('fmul', 'a', 'c'), 'b', 'd')
 *    ('~fadd(is_used_once)', ('fadd(is_used_once)', 'a(is_not_const)', 'b(is_fmul)'), '#c') => ('fadd', ('fadd', 'a', 'c'), 'b')
 *    ('~fadd(is_used_once)', ('fadd(is_used_once)', 'a(is_not_const)', 'b(is_not_const)'), '#c') => ('fadd', ('fadd', 'a', 'c'), 'b')
 *    ('~fadd(is_used_once)', ('ffma(is_used_once)', 'a(is_not_const)', 'b', 'c(is_not_const)'), '#d') => ('fadd', ('ffma', 'a', 'b', 'd'), 'c')
 *    ('~fadd(is_used_once)', ('ffmaz(is_used_once)', 'a(is_not_const)', 'b', 'c(is_not_const)'), '#d') => ('fadd', ('ffmaz', 'a', 'b', 'd'), 'c')
 *    ('iadd(is_used_once)', ('iadd(is_used_once)', 'a(is_not_const)', 'b(is_not_const)'), '#c') => ('iadd', ('iadd', 'a', 'c'), 'b')
 *    ('~fmul', '#a', ('fmul', 'b(is_not_const)', '#c')) => ('fmul', ('fmul', 'a', 'c'), 'b')
 *    ('~fmulz', '#a', ('fmulz', 'b(is_not_const)', '#c')) => ('fmulz', ('fmulz', 'a', 'c'), 'b')
 *    ('~fmul', '#a(is_finite_not_zero)', ('fmulz', 'b(is_not_const)', '#c')) => ('fmulz', ('fmul', 'a', 'c'), 'b')
 *    ('~ffma', '#a', ('fmul', 'b(is_not_const)', '#c'), 'd') => ('ffma', ('fmul', 'a', 'c'), 'b', 'd')
 *    ('~ffmaz', '#a', ('fmulz', 'b(is_not_const)', '#c'), 'd') => ('ffmaz', ('fmulz', 'a', 'c'), 'b', 'd')
 *    ('~ffmaz', '#a(is_finite_not_zero)', ('fmulz', 'b(is_not_const)', '#c'), 'd') => ('ffmaz', ('fmul', 'a', 'c'), 'b', 'd')
 *    ('imul', '#a', ('imul', 'b(is_not_const)', '#c')) => ('imul', ('imul', 'a', 'c'), 'b')
 *    ('~fadd', '#a', ('fadd', 'b(is_not_const)', '#c')) => ('fadd', ('fadd', 'a', 'c'), 'b')
 *    ('~fadd', '#a', ('fneg', ('fadd', 'b(is_not_const)', '#c'))) => ('fadd', ('fadd', 'a', ('fneg', 'c')), ('fneg', 'b'))
 *    ('~fadd', '#a', ('ffma', 'b(is_not_const)', 'c(is_not_const)', '#d')) => ('ffma', 'b', 'c', ('fadd', 'a', 'd'))
 *    ('~fadd', '#a', ('fneg', ('ffma', 'b(is_not_const)', 'c(is_not_const)', '#d'))) => ('ffma', ('fneg', 'b'), 'c', ('fadd', 'a', ('fneg', 'd')))
 *    ('~fadd', '#a', ('ffmaz', 'b(is_not_const)', 'c(is_not_const)', '#d')) => ('ffmaz', 'b', 'c', ('fadd', 'a', 'd'))
 *    ('~fadd', '#a', ('fneg', ('ffmaz', 'b(is_not_const)', 'c(is_not_const)', '#d'))) => ('ffmaz', ('fneg', 'b'), 'c', ('fadd', 'a', ('fneg', 'd')))
 *    ('iadd', '#a', ('iadd', 'b(is_not_const)', '#c')) => ('iadd', ('iadd', 'a', 'c'), 'b')
 *    ('iand', '#a', ('iand', 'b(is_not_const)', '#c')) => ('iand', ('iand', 'a', 'c'), 'b')
 *    ('ior', '#a', ('ior', 'b(is_not_const)', '#c')) => ('ior', ('ior', 'a', 'c'), 'b')
 *    ('ixor', '#a', ('ixor', 'b(is_not_const)', '#c')) => ('ixor', ('ixor', 'a', 'c'), 'b')
 *    ('ior', ('iand', 'a', '#c'), ('ior', 'b', ('iand', 'a', '#d'))) => ('ior', 'b', ('iand', 'a', ('ior', 'c', 'd')))
 *    ('~fadd', ('fadd(is_used_once)', 'a(is_fmul)', 'b(is_fmul)'), 'c(is_not_fmul)') => ('fadd', ('fadd', 'a', 'c'), 'b')
 *    ('idiv', ('imul(no_signed_wrap)', 'a', 'b'), 'b') => a
 *    ('bcsel', ('ige', ('find_lsb', 'a'), 0), ('find_lsb', 'a'), -1) => ('find_lsb', 'a')
 *    ('bcsel', ('ige', ('ifind_msb', 'a'), 0), ('ifind_msb', 'a'), -1) => ('ifind_msb', 'a')
 *    ('bcsel', ('ige', ('ufind_msb', 'a'), 0), ('ufind_msb', 'a'), -1) => ('ufind_msb', 'a')
 *    ('bcsel', ('ige', ('ifind_msb_rev', 'a'), 0), ('ifind_msb_rev', 'a'), -1) => ('ifind_msb_rev', 'a')
 *    ('bcsel', ('ige', ('ufind_msb_rev', 'a'), 0), ('ufind_msb_rev', 'a'), -1) => ('ufind_msb_rev', 'a')
 *    ('bcsel', ('ine', 'a', 0), ('find_lsb', 'a'), -1) => ('find_lsb', 'a')
 *    ('bcsel', ('ine', 'a', 0), ('ifind_msb', 'a'), -1) => ('ifind_msb', 'a')
 *    ('bcsel', ('ine', 'a', 0), ('ufind_msb', 'a'), -1) => ('ufind_msb', 'a')
 *    ('bcsel', ('ine', 'a', 0), ('ifind_msb_rev', 'a'), -1) => ('ifind_msb_rev', 'a')
 *    ('bcsel', ('ine', 'a', 0), ('ufind_msb_rev', 'a'), -1) => ('ufind_msb_rev', 'a')
 *    ('bcsel', ('ine', 'a', -1), ('ifind_msb', 'a'), -1) => ('ifind_msb', 'a')
 *    ('bcsel', ('ine', 'a', -1), ('ifind_msb_rev', 'a'), -1) => ('ifind_msb_rev', 'a')
 *    ('bcsel', ('ine', ('ifind_msb', 'a@32'), -1), ('iadd', 31, ('ineg', ('ifind_msb', 'a'))), -1) => ('ifind_msb_rev', 'a')
 *    ('bcsel', ('ine', ('ufind_msb', 'a@32'), -1), ('iadd', 31, ('ineg', ('ufind_msb', 'a'))), -1) => ('ufind_msb_rev', 'a')
 *    ('bcsel', ('ieq', ('ifind_msb', 'a@32'), -1), -1, ('iadd', 31, ('ineg', ('ifind_msb', 'a')))) => ('ifind_msb_rev', 'a')
 *    ('bcsel', ('ieq', ('ufind_msb', 'a@32'), -1), -1, ('iadd', 31, ('ineg', ('ufind_msb', 'a')))) => ('ufind_msb_rev', 'a')
 *    ('bcsel', ('ine', ('ifind_msb', 'a@32'), -1), ('iadd', 31, ('ineg', ('ifind_msb', 'a'))), ('ifind_msb', 'a')) => ('ifind_msb_rev', 'a')
 *    ('bcsel', ('ine', ('ufind_msb', 'a@32'), -1), ('iadd', 31, ('ineg', ('ufind_msb', 'a'))), ('ufind_msb', 'a')) => ('ufind_msb_rev', 'a')
 *    ('bcsel', ('ieq', ('ifind_msb', 'a@32'), -1), ('ifind_msb', 'a'), ('iadd', 31, ('ineg', ('ifind_msb', 'a')))) => ('ifind_msb_rev', 'a')
 *    ('bcsel', ('ieq', ('ufind_msb', 'a@32'), -1), ('ufind_msb', 'a'), ('iadd', 31, ('ineg', ('ufind_msb', 'a')))) => ('ufind_msb_rev', 'a')
 *    ('bcsel', ('ine', 'a@32', 0), ('iadd', 31, ('ineg', ('ufind_msb', 'a'))), -1) => ('ufind_msb_rev', 'a')
 *    ('bcsel', ('ieq', 'a@32', 0), -1, ('iadd', 31, ('ineg', ('ufind_msb', 'a')))) => ('ufind_msb_rev', 'a')
 *    ('bcsel', ('ine', 'a@32', 0), ('iadd', 31, ('ineg', ('ufind_msb', 'a'))), ('ufind_msb', 'a')) => ('ufind_msb_rev', 'a')
 *    ('bcsel', ('ieq', 'a@32', 0), ('ufind_msb', 'a'), ('iadd', 31, ('ineg', ('ufind_msb', 'a')))) => ('ufind_msb_rev', 'a')
 *    ('bcsel', ('ine', ('ifind_msb_rev', 'a@32'), -1), ('iadd', 31, ('ineg', ('ifind_msb_rev', 'a'))), -1) => ('ifind_msb', 'a')
 *    ('bcsel', ('ine', ('ufind_msb_rev', 'a@32'), -1), ('iadd', 31, ('ineg', ('ufind_msb_rev', 'a'))), -1) => ('ufind_msb', 'a')
 *    ('bcsel', ('ieq', ('ifind_msb_rev', 'a@32'), -1), -1, ('iadd', 31, ('ineg', ('ifind_msb_rev', 'a')))) => ('ifind_msb', 'a')
 *    ('bcsel', ('ieq', ('ufind_msb_rev', 'a@32'), -1), -1, ('iadd', 31, ('ineg', ('ufind_msb_rev', 'a')))) => ('ufind_msb', 'a')
 *    ('bcsel', ('ine', ('ifind_msb_rev', 'a@32'), -1), ('iadd', 31, ('ineg', ('ifind_msb_rev', 'a'))), ('ifind_msb_rev', 'a')) => ('ifind_msb', 'a')
 *    ('bcsel', ('ine', ('ufind_msb_rev', 'a@32'), -1), ('iadd', 31, ('ineg', ('ufind_msb_rev', 'a'))), ('ufind_msb_rev', 'a')) => ('ufind_msb', 'a')
 *    ('bcsel', ('ieq', ('ifind_msb_rev', 'a@32'), -1), ('ifind_msb_rev', 'a'), ('iadd', 31, ('ineg', ('ifind_msb_rev', 'a')))) => ('ifind_msb', 'a')
 *    ('bcsel', ('ieq', ('ufind_msb_rev', 'a@32'), -1), ('ufind_msb_rev', 'a'), ('iadd', 31, ('ineg', ('ufind_msb_rev', 'a')))) => ('ufind_msb', 'a')
 *    ('bcsel', ('ine', 'a@32', 0), ('iadd', 31, ('ineg', ('ufind_msb_rev', 'a'))), -1) => ('ufind_msb', 'a')
 *    ('bcsel', ('ieq', 'a@32', 0), -1, ('iadd', 31, ('ineg', ('ufind_msb_rev', 'a')))) => ('ufind_msb', 'a')
 *    ('bcsel', ('ine', 'a@32', 0), ('iadd', 31, ('ineg', ('ufind_msb_rev', 'a'))), ('ufind_msb_rev', 'a')) => ('ufind_msb', 'a')
 *    ('bcsel', ('ieq', 'a@32', 0), ('ufind_msb_rev', 'a'), ('iadd', 31, ('ineg', ('ufind_msb_rev', 'a')))) => ('ufind_msb', 'a')
 *    ('iand', 'a', ('inot', ('ishl', 1, ('find_lsb', 'a')))) => ('iand', 'a', ('inot', ('ineg', 'a')))
 *    ('find_lsb', ('bitfield_reverse', 'a')) => ('ufind_msb_rev', 'a')
 *    ('ufind_msb_rev', ('bitfield_reverse', 'a')) => ('find_lsb', 'a')
 *    ('ifind_msb', ('f2i32(is_used_once)', 'a')) => ('ufind_msb', ('f2i32', ('fabs', 'a')))
 *    ('ifind_msb', ('extract_u8', 'a', 'b')) => ('ufind_msb', ('extract_u8', 'a', 'b'))
 *    ('ifind_msb', ('extract_u16', 'a', 'b')) => ('ufind_msb', ('extract_u16', 'a', 'b'))
 *    ('ifind_msb', ('imax', 'a', 1)) => ('ufind_msb', ('imax', 'a', 1))
 *    ('~fmul', ('bcsel(is_used_once)', 'c', -1.0, 1.0), 'b') => ('bcsel', 'c', ('fneg', 'b'), 'b')
 *    ('~fmul', ('bcsel(is_used_once)', 'c', 1.0, -1.0), 'b') => ('bcsel', 'c', 'b', ('fneg', 'b'))
 *    ('~fmulz', ('bcsel(is_used_once)', 'c', -1.0, 1.0), 'b') => ('bcsel', 'c', ('fneg', 'b'), 'b')
 *    ('~fmulz', ('bcsel(is_used_once)', 'c', 1.0, -1.0), 'b') => ('bcsel', 'c', 'b', ('fneg', 'b'))
 *    ('fabs', ('bcsel(is_used_once)', 'b', ('fneg', 'a'), 'a')) => ('fabs', 'a')
 *    ('fabs', ('bcsel(is_used_once)', 'b', 'a', ('fneg', 'a'))) => ('fabs', 'a')
 *    ('~bcsel', ('flt', 'a', 0.0), ('fneg', 'a'), 'a') => ('fabs', 'a')
 *    ('bcsel', 'a', ('bcsel(is_used_once)', 'b', 'c', 'd'), 'd') => ('bcsel', ('iand', 'a', 'b'), 'c', 'd')
 *    ('bcsel', 'a', ('bcsel(is_used_once)', 'b', 'd', 'c'), 'd') => ('bcsel', ('iand', 'a', ('inot', 'b')), 'c', 'd')
 *    ('bcsel', 'a', 'b', ('bcsel(is_used_once)', 'c', 'b', 'd')) => ('bcsel', ('ior', 'a', 'c'), 'b', 'd')
 *    ('bcsel', 'a', 'b', ('bcsel(is_used_once)', 'c', 'd', 'b')) => ('bcsel', ('iand', 'c', ('inot', 'a')), 'd', 'b')
 *    ('fmod', 'a', 'b') => ('fsub', 'a', ('fmul', 'b', ('ffloor', ('fdiv', 'a', 'b'))))
 *    ('frem', 'a', 'b') => ('fsub', 'a', ('fmul', 'b', ('ftrunc', ('fdiv', 'a', 'b'))))
 *    ('uadd_carry', 'a', 'b') => ('b2i', ('ult', ('iadd', 'a', 'b'), 'a'))
 *    ('usub_borrow', 'a', 'b') => ('b2i', ('ult', 'a', 'b'))
 *    ('bitfield_insert', 'base', 'insert', 'offset', 'bits') => ('bcsel', ('ult', 31, 'bits'), 'insert', ('bfi', ('bfm', 'bits', 'offset'), 'insert', 'base'))
 *    ('ihadd', 'a', 'b') => ('iadd', ('iand', 'a', 'b'), ('ishr', ('ixor', 'a', 'b'), 1))
 *    ('uhadd', 'a', 'b') => ('iadd', ('iand', 'a', 'b'), ('ushr', ('ixor', 'a', 'b'), 1))
 *    ('irhadd', 'a', 'b') => ('isub', ('ior', 'a', 'b'), ('ishr', ('ixor', 'a', 'b'), 1))
 *    ('urhadd', 'a', 'b') => ('isub', ('ior', 'a', 'b'), ('ushr', ('ixor', 'a', 'b'), 1))
 *    ('ihadd@64', 'a', 'b') => ('iadd', ('iand', 'a', 'b'), ('ishr', ('ixor', 'a', 'b'), 1))
 *    ('uhadd@64', 'a', 'b') => ('iadd', ('iand', 'a', 'b'), ('ushr', ('ixor', 'a', 'b'), 1))
 *    ('irhadd@64', 'a', 'b') => ('isub', ('ior', 'a', 'b'), ('ishr', ('ixor', 'a', 'b'), 1))
 *    ('urhadd@64', 'a', 'b') => ('isub', ('ior', 'a', 'b'), ('ushr', ('ixor', 'a', 'b'), 1))
 *    ('imul_32x16', 'a', 'b') => ('imul', 'a', ('extract_i16', 'b', 0))
 *    ('umul_32x16', 'a', 'b') => ('imul', 'a', ('extract_u16', 'b', 0))
 *    ('uadd_sat@64', 'a', 'b') => ('bcsel', ('ult', ('iadd', 'a', 'b'), 'a'), -1, ('iadd', 'a', 'b'))
 *    ('uadd_sat', 'a', 'b') => ('bcsel', ('ult', ('iadd', 'a', 'b'), 'a'), -1, ('iadd', 'a', 'b'))
 *    ('usub_sat', 'a', 'b') => ('bcsel', ('ult', 'a', 'b'), 0, ('isub', 'a', 'b'))
 *    ('usub_sat@64', 'a', 'b') => ('bcsel', ('ult', 'a', 'b'), 0, ('isub', 'a', 'b'))
 *    ('iadd_sat@64', 'a', 'b') => ('bcsel', ('iand', ('iand', ('ilt', 'a', 0), ('ilt', 'b', 0)), ('ige', ('iadd', 'a', 'b'), 0)), 9223372036854775808, ('bcsel', ('ior', ('ior', ('ilt', 'a', 0), ('ilt', 'b', 0)), ('ige', ('iadd', 'a', 'b'), 0)), ('iadd', 'a', 'b'), 9223372036854775807))
 *    ('isub_sat@64', 'a', 'b') => ('bcsel', ('iand', ('iand', ('ilt', 'a', 0), ('ige', 'b', 0)), ('ige', ('isub', 'a', 'b'), 0)), 9223372036854775808, ('bcsel', ('ior', ('ior', ('ilt', 'a', 0), ('ige', 'b', 0)), ('ige', ('isub', 'a', 'b'), 0)), ('isub', 'a', 'b'), 9223372036854775807))
 *    ('ilt', ('imax(is_used_once)', 'a@64', 'b@64'), 0) => ('ilt', ('imax', ('unpack_64_2x32_split_y', 'a'), ('unpack_64_2x32_split_y', 'b')), 0)
 *    ('ilt', ('imin(is_used_once)', 'a@64', 'b@64'), 0) => ('ilt', ('imin', ('unpack_64_2x32_split_y', 'a'), ('unpack_64_2x32_split_y', 'b')), 0)
 *    ('ige', ('imax(is_used_once)', 'a@64', 'b@64'), 0) => ('ige', ('imax', ('unpack_64_2x32_split_y', 'a'), ('unpack_64_2x32_split_y', 'b')), 0)
 *    ('ige', ('imin(is_used_once)', 'a@64', 'b@64'), 0) => ('ige', ('imin', ('unpack_64_2x32_split_y', 'a'), ('unpack_64_2x32_split_y', 'b')), 0)
 *    ('ilt', 'a@64', 0) => ('ilt', ('unpack_64_2x32_split_y', 'a'), 0)
 *    ('ige', 'a@64', 0) => ('ige', ('unpack_64_2x32_split_y', 'a'), 0)
 *    ('ine', 'a@64', 0) => ('ine', ('ior', ('unpack_64_2x32_split_x', 'a'), ('unpack_64_2x32_split_y', 'a')), 0)
 *    ('ieq', 'a@64', 0) => ('ieq', ('ior', ('unpack_64_2x32_split_x', 'a'), ('unpack_64_2x32_split_y', 'a')), 0)
 *    ('ult', 0, 'a@64') => ('ine', ('ior', ('unpack_64_2x32_split_x', 'a'), ('unpack_64_2x32_split_y', 'a')), 0)
 *    ('bitfield_insert', 'base', 'insert', 'offset', 'bits') => ('bcsel', ('ult', 31, 'bits'), 'insert', ('ior', ('iand', 'base', ('inot', ('ishl', ('isub', ('ishl', 1, 'bits'), 1), 'offset'))), ('iand', ('ishl', 'insert', 'offset'), ('ishl', ('isub', ('ishl', 1, 'bits'), 1), 'offset'))))
 *    ('bitfield_insert', 'base', 'insert', 'offset', 'bits') => ('bcsel', ('ult', 31, 'bits'), 'insert', ('bitfield_select', ('bfm', 'bits', 'offset'), ('ishl', 'insert', 'offset'), 'base'))
 *    ('ibitfield_extract', 'value', 'offset', 'bits') => ('bcsel', ('ult', 31, 'bits'), 'value', ('ibfe', 'value', 'offset', 'bits'))
 *    ('ubitfield_extract', 'value', 'offset', 'bits') => ('bcsel', ('ult', 31, 'bits'), 'value', ('ubfe', 'value', 'offset', 'bits'))
 *    ('bitfield_select', 'a', 'b', 0) => ('iand', 'a', 'b')
 *    ('bitfield_select', 'a', ('iand', 'a', 'b'), 'c') => ('bitfield_select', 'a', 'b', 'c')
 *    ('ubfe', 'value', 'offset', ('iand', 31, 'bits')) => ('ubfe', 'value', 'offset', 'bits')
 *    ('ubfe', 'value', ('iand', 31, 'offset'), 'bits') => ('ubfe', 'value', 'offset', 'bits')
 *    ('ibfe', 'value', 'offset', ('iand', 31, 'bits')) => ('ibfe', 'value', 'offset', 'bits')
 *    ('ibfe', 'value', ('iand', 31, 'offset'), 'bits') => ('ibfe', 'value', 'offset', 'bits')
 *    ('bfm', 'bits', ('iand', 31, 'offset')) => ('bfm', 'bits', 'offset')
 *    ('bfm', ('iand', 31, 'bits'), 'offset') => ('bfm', 'bits', 'offset')
 *    ('ult', 'a', ('umin', ('iand', 'a', 'b'), 'c')) => False
 *    ('ult', 31, ('umin', '#bits(is_ult_32)', 'a')) => False
 *    ('ubfe', 'value', 'offset', ('umin', 'width', ('iadd', 32, ('ineg', ('iand', 31, 'offset'))))) => ('ubfe', 'value', 'offset', 'width')
 *    ('ibfe', 'value', 'offset', ('umin', 'width', ('iadd', 32, ('ineg', ('iand', 31, 'offset'))))) => ('ibfe', 'value', 'offset', 'width')
 *    ('bfm', ('umin', 'width', ('iadd', 32, ('ineg', ('iand', 31, 'offset')))), 'offset') => ('bfm', 'width', 'offset')
 *    ('iadd@32', ('ishl', 1, 'a'), -1) => ('bfm', 'a', 0)
 *    ('ishl', ('bfm', 'a', 0), 'b') => ('bfm', 'a', 'b')
 *    ('ubfe', 'a', 'b', 0) => 0
 *    ('ibfe', 'a', 'b', 0) => 0
 *    ('ubfe', 'a', 0, '#b') => ('iand', 'a', ('ushr', 4294967295, ('ineg', 'b')))
 *    ('b2i32', ('ine', ('ubfe', 'a', 'b', 1), 0)) => ('ubfe', 'a', 'b', 1)
 *    ('b2i32', ('ine', ('ibfe', 'a', 'b', 1), 0)) => ('ubfe', 'a', 'b', 1)
 *    ('ine', ('ibfe(is_used_once)', 'a', '#b', '#c'), 0) => ('ine', ('iand', 'a', ('ishl', ('ushr', 4294967295, ('ineg', 'c')), 'b')), 0)
 *    ('ieq', ('ibfe(is_used_once)', 'a', '#b', '#c'), 0) => ('ieq', ('iand', 'a', ('ishl', ('ushr', 4294967295, ('ineg', 'c')), 'b')), 0)
 *    ('ine', ('ubfe(is_used_once)', 'a', '#b', '#c'), 0) => ('ine', ('iand', 'a', ('ishl', ('ushr', 4294967295, ('ineg', 'c')), 'b')), 0)
 *    ('ieq', ('ubfe(is_used_once)', 'a', '#b', '#c'), 0) => ('ieq', ('iand', 'a', ('ishl', ('ushr', 4294967295, ('ineg', 'c')), 'b')), 0)
 *    ('ibitfield_extract', 'value', 'offset', 'bits') => ('bcsel', ('ieq', 0, 'bits'), 0, ('ishr', ('ishl', 'value', ('isub', ('isub', 32, 'bits'), 'offset')), ('isub', 32, 'bits')))
 *    ('ubitfield_extract', 'value', 'offset', 'bits') => ('iand', ('ushr', 'value', 'offset'), ('bcsel', ('ieq', 'bits', 32), 4294967295, ('isub', ('ishl', 1, 'bits'), 1)))
 *    ('ifind_msb', 'value') => ('ufind_msb', ('bcsel', ('ilt', 'value', 0), ('inot', 'value'), 'value'))
 *    ('ifind_msb', 'value') => ('bcsel', ('ige', ('ifind_msb_rev', 'value'), 0), ('isub', 31, ('ifind_msb_rev', 'value')), ('ifind_msb_rev', 'value'))
 *    ('ifind_msb', 'value') => ('isub', 31, ('uclz', ('ixor', 'value', ('ishr', 'value', 31))))
 *    ('ufind_msb', 'value@32') => ('bcsel', ('ige', ('ufind_msb_rev', 'value'), 0), ('isub', 31, ('ufind_msb_rev', 'value')), ('ufind_msb_rev', 'value'))
 *    ('ufind_msb', 'value@32') => ('isub', 31, ('uclz', 'value'))
 *    ('uclz', 'a') => ('umin', 32, ('ufind_msb_rev', 'a'))
 *    ('find_lsb', 'value@64') => ('ufind_msb', ('iand', 'value', ('ineg', 'value')))
 *    ('find_lsb', 'value') => ('ufind_msb', ('u2u32', ('iand', 'value', ('ineg', 'value'))))
 *    ('extract_i8', 'a', 'b@32') => ('ishr', ('ishl', 'a', ('imul', ('isub', 3, 'b'), 8)), 24)
 *    ('extract_u8', 'a', 'b@32') => ('iand', ('ushr', 'a', ('imul', 'b', 8)), 255)
 *    ('extract_i16', 'a', 'b@32') => ('ishr', ('ishl', 'a', ('imul', ('isub', 1, 'b'), 16)), 16)
 *    ('extract_u16', 'a', 'b@32') => ('iand', ('ushr', 'a', ('imul', 'b', 16)), 65535)
 *    ('pack_unorm_2x16', 'v') => ('pack_uvec2_to_uint', ('f2u32', ('fround_even', ('fmul', ('fsat', 'v'), 65535.0))))
 *    ('pack_unorm_4x8', 'v') => ('pack_uvec4_to_uint', ('f2u32', ('fround_even', ('fmul', ('fsat', 'v'), 255.0))))
 *    ('pack_unorm_4x8', 'v') => ('pack_32_4x8', ('f2u8', ('fround_even', ('fmul', ('fsat', 'v'), 255.0))))
 *    ('pack_snorm_2x16', 'v') => ('pack_uvec2_to_uint', ('f2i32', ('fround_even', ('fmul', ('fmin', 1.0, ('fmax', -1.0, 'v')), 32767.0))))
 *    ('pack_snorm_4x8', 'v') => ('pack_uvec4_to_uint', ('f2i32', ('fround_even', ('fmul', ('fmin', 1.0, ('fmax', -1.0, 'v')), 127.0))))
 *    ('pack_snorm_4x8', 'v') => ('pack_32_4x8', ('f2i8', ('fround_even', ('fmul', ('fmin', 1.0, ('fmax', -1.0, 'v')), 127.0))))
 *    ('unpack_unorm_2x16', 'v') => ('fdiv', ('u2f32', ('vec2', ('extract_u16', 'v', 0), ('extract_u16', 'v', 1))), 65535.0)
 *    ('unpack_unorm_4x8', 'v') => ('fdiv', ('u2f32', ('vec4', ('extract_u8', 'v', 0), ('extract_u8', 'v', 1), ('extract_u8', 'v', 2), ('extract_u8', 'v', 3))), 255.0)
 *    ('unpack_snorm_2x16', 'v') => ('fmin', 1.0, ('fmax', -1.0, ('fdiv', ('i2f', ('vec2', ('extract_i16', 'v', 0), ('extract_i16', 'v', 1))), 32767.0)))
 *    ('unpack_snorm_4x8', 'v') => ('fmin', 1.0, ('fmax', -1.0, ('fdiv', ('i2f', ('vec4', ('extract_i8', 'v', 0), ('extract_i8', 'v', 1), ('extract_i8', 'v', 2), ('extract_i8', 'v', 3))), 127.0)))
 *    ('pack_half_2x16_split', 'a@32', 'b@32') => ('ior', ('ishl', ('u2u32', ('f2f16', 'b')), 16), ('u2u32', ('f2f16', 'a')))
 *    ('unpack_half_2x16_split_x', 'a@32') => ('f2f32', ('u2u16', 'a'))
 *    ('unpack_half_2x16_split_x', 'a@32') => ('f2f32', ('fmul', 1.0, ('u2u16', 'a')))
 *    ('unpack_half_2x16_split_y', 'a@32') => ('f2f32', ('u2u16', ('ushr', 'a', 16)))
 *    ('unpack_half_2x16_split_y', 'a@32') => ('f2f32', ('fmul', 1.0, ('u2u16', ('ushr', 'a', 16))))
 *    ('isign', 'a') => ('imin', ('imax', 'a', -1), 1)
 *    ('imin', ('imax', 'a', -1), 1) => ('isign', 'a')
 *    ('imax', ('imin', 'a', 1), -1) => ('isign', 'a')
 *    ('fsign', 'a') => ('fsub', ('b2f', ('!flt', 0.0, 'a')), ('b2f', ('!flt', 'a', 0.0)))
 *    ('fsign', 'a@64') => ('fsub', ('b2f', ('!flt', 0.0, 'a')), ('b2f', ('!flt', 'a', 0.0)))
 *    ('amul', 'a', 'b') => ('imul', 'a', 'b')
 *    ('umul24', 'a', 'b') => ('imul', ('iand', 'a', 16777215), ('iand', 'b', 16777215))
 *    ('umad24', 'a', 'b', 'c') => ('iadd', ('imul', ('iand', 'a', 16777215), ('iand', 'b', 16777215)), 'c')
 *    ('imul24_relaxed', 'a', 'b') => ('imul24', 'a', 'b')
 *    ('imul24_relaxed', 'a', 'b') => ('imul', 'a', 'b')
 *    ('umad24_relaxed', 'a', 'b', 'c') => ('umad24', 'a', 'b', 'c')
 *    ('umad24_relaxed', 'a', 'b', 'c') => ('iadd', ('umul24_relaxed', 'a', 'b'), 'c')
 *    ('umul24_relaxed', 'a', 'b') => ('umul24', 'a', 'b')
 *    ('umul24_relaxed', 'a', 'b') => ('imul', 'a', 'b')
 *    ('imad24_ir3', 'a', 'b', 0) => ('imul24', 'a', 'b')
 *    ('imad24_ir3', 'a', 0, 'c') => c
 *    ('imad24_ir3', 'a', 1, 'c') => ('iadd', 'a', 'c')
 *    ('imad24_ir3', '#a', '#b', 'c') => ('iadd', ('imul', 'a', 'b'), 'c')
 *    ('imul24', 'a', '#b@32(is_pos_power_of_two)') => ('ishl', 'a', ('find_lsb', 'b'))
 *    ('imul24', 'a', '#b@32(is_neg_power_of_two)') => ('ineg', ('ishl', 'a', ('find_lsb', ('iabs', 'b'))))
 *    ('imul24', 'a', 0) => 0
 *    ('bcsel', ('ult', ('iadd', 'a', 'b'), 'a'), -1, ('iadd@8', 'a', 'b')) => ('uadd_sat', 'a', 'b')
 *    ('bcsel', ('uge', ('iadd', 'a', 'b'), 'a'), ('iadd@8', 'a', 'b'), -1) => ('uadd_sat', 'a', 'b')
 *    ('bcsel', ('ieq', ('uadd_carry', 'a', 'b'), 0), ('iadd@8', 'a', 'b'), -1) => ('uadd_sat', 'a', 'b')
 *    ('bcsel', ('ine', ('uadd_carry', 'a', 'b'), 0), -1, ('iadd@8', 'a', 'b')) => ('uadd_sat', 'a', 'b')
 *    ('bcsel', ('ult', ('iadd', 'a', 'b'), 'a'), -1, ('iadd@16', 'a', 'b')) => ('uadd_sat', 'a', 'b')
 *    ('bcsel', ('uge', ('iadd', 'a', 'b'), 'a'), ('iadd@16', 'a', 'b'), -1) => ('uadd_sat', 'a', 'b')
 *    ('bcsel', ('ieq', ('uadd_carry', 'a', 'b'), 0), ('iadd@16', 'a', 'b'), -1) => ('uadd_sat', 'a', 'b')
 *    ('bcsel', ('ine', ('uadd_carry', 'a', 'b'), 0), -1, ('iadd@16', 'a', 'b')) => ('uadd_sat', 'a', 'b')
 *    ('bcsel', ('ult', ('iadd', 'a', 'b'), 'a'), -1, ('iadd@32', 'a', 'b')) => ('uadd_sat', 'a', 'b')
 *    ('bcsel', ('uge', ('iadd', 'a', 'b'), 'a'), ('iadd@32', 'a', 'b'), -1) => ('uadd_sat', 'a', 'b')
 *    ('bcsel', ('ieq', ('uadd_carry', 'a', 'b'), 0), ('iadd@32', 'a', 'b'), -1) => ('uadd_sat', 'a', 'b')
 *    ('bcsel', ('ine', ('uadd_carry', 'a', 'b'), 0), -1, ('iadd@32', 'a', 'b')) => ('uadd_sat', 'a', 'b')
 *    ('bcsel', ('ult', ('iadd', 'a', 'b'), 'a'), -1, ('iadd@64', 'a', 'b')) => ('uadd_sat', 'a', 'b')
 *    ('bcsel', ('uge', ('iadd', 'a', 'b'), 'a'), ('iadd@64', 'a', 'b'), -1) => ('uadd_sat', 'a', 'b')
 *    ('bcsel', ('ieq', ('uadd_carry', 'a', 'b'), 0), ('iadd@64', 'a', 'b'), -1) => ('uadd_sat', 'a', 'b')
 *    ('bcsel', ('ine', ('uadd_carry', 'a', 'b'), 0), -1, ('iadd@64', 'a', 'b')) => ('uadd_sat', 'a', 'b')
 *    ('bcsel', ('ult', 'a', 'b'), 0, ('iadd@8', 'a', ('ineg', 'b'))) => ('usub_sat', 'a', 'b')
 *    ('bcsel', ('uge', 'a', 'b'), ('iadd@8', 'a', ('ineg', 'b')), 0) => ('usub_sat', 'a', 'b')
 *    ('bcsel', ('ieq', ('usub_borrow', 'a', 'b'), 0), ('iadd@8', 'a', ('ineg', 'b')), 0) => ('usub_sat', 'a', 'b')
 *    ('bcsel', ('ine', ('usub_borrow', 'a', 'b'), 0), 0, ('iadd@8', 'a', ('ineg', 'b'))) => ('usub_sat', 'a', 'b')
 *    ('bcsel', ('ult', 'a', 'b'), 0, ('iadd@16', 'a', ('ineg', 'b'))) => ('usub_sat', 'a', 'b')
 *    ('bcsel', ('uge', 'a', 'b'), ('iadd@16', 'a', ('ineg', 'b')), 0) => ('usub_sat', 'a', 'b')
 *    ('bcsel', ('ieq', ('usub_borrow', 'a', 'b'), 0), ('iadd@16', 'a', ('ineg', 'b')), 0) => ('usub_sat', 'a', 'b')
 *    ('bcsel', ('ine', ('usub_borrow', 'a', 'b'), 0), 0, ('iadd@16', 'a', ('ineg', 'b'))) => ('usub_sat', 'a', 'b')
 *    ('bcsel', ('ult', 'a', 'b'), 0, ('iadd@32', 'a', ('ineg', 'b'))) => ('usub_sat', 'a', 'b')
 *    ('bcsel', ('uge', 'a', 'b'), ('iadd@32', 'a', ('ineg', 'b')), 0) => ('usub_sat', 'a', 'b')
 *    ('bcsel', ('ieq', ('usub_borrow', 'a', 'b'), 0), ('iadd@32', 'a', ('ineg', 'b')), 0) => ('usub_sat', 'a', 'b')
 *    ('bcsel', ('ine', ('usub_borrow', 'a', 'b'), 0), 0, ('iadd@32', 'a', ('ineg', 'b'))) => ('usub_sat', 'a', 'b')
 *    ('bcsel', ('ult', 'a', 'b'), 0, ('iadd@64', 'a', ('ineg', 'b'))) => ('usub_sat', 'a', 'b')
 *    ('bcsel', ('uge', 'a', 'b'), ('iadd@64', 'a', ('ineg', 'b')), 0) => ('usub_sat', 'a', 'b')
 *    ('bcsel', ('ieq', ('usub_borrow', 'a', 'b'), 0), ('iadd@64', 'a', ('ineg', 'b')), 0) => ('usub_sat', 'a', 'b')
 *    ('bcsel', ('ine', ('usub_borrow', 'a', 'b'), 0), 0, ('iadd@64', 'a', ('ineg', 'b'))) => ('usub_sat', 'a', 'b')
 *    ('iadd_sat@8', 'a', 'b') => ('bcsel', ('ige', 'b', 1), ('bcsel', ('ilt', ('iadd', 'a', 'b'), 'a'), 127, ('iadd', 'a', 'b')), ('bcsel', ('ilt', 'a', ('iadd', 'a', 'b')), 128, ('iadd', 'a', 'b')))
 *    ('isub_sat@8', 'a', 'b') => ('bcsel', ('ilt', 'b', 0), ('bcsel', ('ilt', ('isub', 'a', 'b'), 'a'), 127, ('isub', 'a', 'b')), ('bcsel', ('ilt', 'a', ('isub', 'a', 'b')), 128, ('isub', 'a', 'b')))
 *    ('iadd_sat@16', 'a', 'b') => ('bcsel', ('ige', 'b', 1), ('bcsel', ('ilt', ('iadd', 'a', 'b'), 'a'), 32767, ('iadd', 'a', 'b')), ('bcsel', ('ilt', 'a', ('iadd', 'a', 'b')), 32768, ('iadd', 'a', 'b')))
 *    ('isub_sat@16', 'a', 'b') => ('bcsel', ('ilt', 'b', 0), ('bcsel', ('ilt', ('isub', 'a', 'b'), 'a'), 32767, ('isub', 'a', 'b')), ('bcsel', ('ilt', 'a', ('isub', 'a', 'b')), 32768, ('isub', 'a', 'b')))
 *    ('iadd_sat@32', 'a', 'b') => ('bcsel', ('ige', 'b', 1), ('bcsel', ('ilt', ('iadd', 'a', 'b'), 'a'), 2147483647, ('iadd', 'a', 'b')), ('bcsel', ('ilt', 'a', ('iadd', 'a', 'b')), 2147483648, ('iadd', 'a', 'b')))
 *    ('isub_sat@32', 'a', 'b') => ('bcsel', ('ilt', 'b', 0), ('bcsel', ('ilt', ('isub', 'a', 'b'), 'a'), 2147483647, ('isub', 'a', 'b')), ('bcsel', ('ilt', 'a', ('isub', 'a', 'b')), 2147483648, ('isub', 'a', 'b')))
 *    ('iadd_sat@64', 'a', 'b') => ('bcsel', ('ige', 'b', 1), ('bcsel', ('ilt', ('iadd', 'a', 'b'), 'a'), 9223372036854775807, ('iadd', 'a', 'b')), ('bcsel', ('ilt', 'a', ('iadd', 'a', 'b')), 9223372036854775808, ('iadd', 'a', 'b')))
 *    ('isub_sat@64', 'a', 'b') => ('bcsel', ('ilt', 'b', 0), ('bcsel', ('ilt', ('isub', 'a', 'b'), 'a'), 9223372036854775807, ('isub', 'a', 'b')), ('bcsel', ('ilt', 'a', ('isub', 'a', 'b')), 9223372036854775808, ('isub', 'a', 'b')))
 *    ('inot', ('ior(is_used_once)', ('feq', 'a', 'b'), ('feq', 'c', 'd'))) => ('iand', ('fneu', 'a', 'b'), ('fneu', 'c', 'd'))
 *    ('inot', ('iand(is_used_once)', ('feq', 'a', 'b'), ('feq', 'c', 'd'))) => ('ior', ('fneu', 'a', 'b'), ('fneu', 'c', 'd'))
 *    ('inot', ('ior(is_used_once)', ('feq', 'a', 'b'), ('fneu', 'c', 'd'))) => ('iand', ('fneu', 'a', 'b'), ('feq', 'c', 'd'))
 *    ('inot', ('iand(is_used_once)', ('feq', 'a', 'b'), ('fneu', 'c', 'd'))) => ('ior', ('fneu', 'a', 'b'), ('feq', 'c', 'd'))
 *    ('inot', ('ior(is_used_once)', ('fneu', 'a', 'b'), ('fneu', 'c', 'd'))) => ('iand', ('feq', 'a', 'b'), ('feq', 'c', 'd'))
 *    ('inot', ('iand(is_used_once)', ('fneu', 'a', 'b'), ('fneu', 'c', 'd'))) => ('ior', ('feq', 'a', 'b'), ('feq', 'c', 'd'))
 *    ('f2f', ('b2f', 'a')) => ('b2f', 'a')
 *    ('f2u', ('b2f', 'a')) => ('b2i', 'a')
 *    ('f2i', ('b2f', 'a')) => ('b2i', 'a')
 *    ('u2f', ('b2i', 'a')) => ('b2f', 'a')
 *    ('u2u', ('b2i', 'a')) => ('b2i', 'a')
 *    ('i2f', ('b2i', 'a')) => ('b2f', 'a')
 *    ('i2i', ('b2i', 'a')) => ('b2i', 'a')
 *    ('i2i1', 'a@1') => a
 *    ('i2i8', 'a@8') => a
 *    ('i2i16', 'a@16') => a
 *    ('i2i32', 'a@32') => a
 *    ('i2i64', 'a@64') => a
 *    ('u2u1', 'a@1') => a
 *    ('u2u8', 'a@8') => a
 *    ('u2u16', 'a@16') => a
 *    ('u2u32', 'a@32') => a
 *    ('u2u64', 'a@64') => a
 *    ('f2f16', 'a@16') => a
 *    ('f2f32', 'a@32') => a
 *    ('f2f64', 'a@64') => a
 *    ('b2b1', 'a@1') => a
 *    ('b2b8', 'a@8') => a
 *    ('b2b16', 'a@16') => a
 *    ('b2b32', 'a@32') => a
 *    ('i2i1', ('i2i8', 'a')) => ('i2i1', 'a')
 *    ('i2i1', ('u2u8', 'a')) => ('u2u1', 'a')
 *    ('u2u1', ('i2i8', 'a')) => ('i2i1', 'a')
 *    ('u2u1', ('u2u8', 'a')) => ('u2u1', 'a')
 *    ('i2i1', ('i2i16', 'a')) => ('i2i1', 'a')
 *    ('i2i1', ('u2u16', 'a')) => ('u2u1', 'a')
 *    ('u2u1', ('i2i16', 'a')) => ('i2i1', 'a')
 *    ('u2u1', ('u2u16', 'a')) => ('u2u1', 'a')
 *    ('i2i1', ('i2i32', 'a')) => ('i2i1', 'a')
 *    ('i2i1', ('u2u32', 'a')) => ('u2u1', 'a')
 *    ('u2u1', ('i2i32', 'a')) => ('i2i1', 'a')
 *    ('u2u1', ('u2u32', 'a')) => ('u2u1', 'a')
 *    ('i2i1', ('i2i64', 'a')) => ('i2i1', 'a')
 *    ('i2i1', ('u2u64', 'a')) => ('u2u1', 'a')
 *    ('u2u1', ('i2i64', 'a')) => ('i2i1', 'a')
 *    ('u2u1', ('u2u64', 'a')) => ('u2u1', 'a')
 *    ('i2i8', ('i2i1', 'a@1')) => ('i2i8', 'a')
 *    ('u2u8', ('u2u1', 'a@1')) => ('u2u8', 'a')
 *    ('i2i8', ('i2i16', 'a')) => ('i2i8', 'a')
 *    ('i2i8', ('u2u16', 'a')) => ('u2u8', 'a')
 *    ('u2u8', ('i2i16', 'a')) => ('i2i8', 'a')
 *    ('u2u8', ('u2u16', 'a')) => ('u2u8', 'a')
 *    ('i2i8', ('i2i32', 'a')) => ('i2i8', 'a')
 *    ('i2i8', ('u2u32', 'a')) => ('u2u8', 'a')
 *    ('u2u8', ('i2i32', 'a')) => ('i2i8', 'a')
 *    ('u2u8', ('u2u32', 'a')) => ('u2u8', 'a')
 *    ('i2i8', ('i2i64', 'a')) => ('i2i8', 'a')
 *    ('i2i8', ('u2u64', 'a')) => ('u2u8', 'a')
 *    ('u2u8', ('i2i64', 'a')) => ('i2i8', 'a')
 *    ('u2u8', ('u2u64', 'a')) => ('u2u8', 'a')
 *    ('i2i16', ('i2i1', 'a@1')) => ('i2i16', 'a')
 *    ('u2u16', ('u2u1', 'a@1')) => ('u2u16', 'a')
 *    ('i2i16', ('i2i8', 'a@1')) => ('i2i16', 'a')
 *    ('u2u16', ('u2u8', 'a@1')) => ('u2u16', 'a')
 *    ('i2i16', ('i2i8', 'a@8')) => ('i2i16', 'a')
 *    ('u2u16', ('u2u8', 'a@8')) => ('u2u16', 'a')
 *    ('i2i16', ('i2i32', 'a')) => ('i2i16', 'a')
 *    ('i2i16', ('u2u32', 'a')) => ('u2u16', 'a')
 *    ('u2u16', ('i2i32', 'a')) => ('i2i16', 'a')
 *    ('u2u16', ('u2u32', 'a')) => ('u2u16', 'a')
 *    ('i2i16', ('i2i64', 'a')) => ('i2i16', 'a')
 *    ('i2i16', ('u2u64', 'a')) => ('u2u16', 'a')
 *    ('u2u16', ('i2i64', 'a')) => ('i2i16', 'a')
 *    ('u2u16', ('u2u64', 'a')) => ('u2u16', 'a')
 *    ('i2i32', ('i2i1', 'a@1')) => ('i2i32', 'a')
 *    ('u2u32', ('u2u1', 'a@1')) => ('u2u32', 'a')
 *    ('i2i32', ('i2i8', 'a@1')) => ('i2i32', 'a')
 *    ('u2u32', ('u2u8', 'a@1')) => ('u2u32', 'a')
 *    ('i2i32', ('i2i8', 'a@8')) => ('i2i32', 'a')
 *    ('u2u32', ('u2u8', 'a@8')) => ('u2u32', 'a')
 *    ('i2i32', ('i2i16', 'a@1')) => ('i2i32', 'a')
 *    ('u2u32', ('u2u16', 'a@1')) => ('u2u32', 'a')
 *    ('i2i32', ('i2i16', 'a@8')) => ('i2i32', 'a')
 *    ('u2u32', ('u2u16', 'a@8')) => ('u2u32', 'a')
 *    ('i2i32', ('i2i16', 'a@16')) => ('i2i32', 'a')
 *    ('u2u32', ('u2u16', 'a@16')) => ('u2u32', 'a')
 *    ('i2i32', ('i2i64', 'a')) => ('i2i32', 'a')
 *    ('i2i32', ('u2u64', 'a')) => ('u2u32', 'a')
 *    ('u2u32', ('i2i64', 'a')) => ('i2i32', 'a')
 *    ('u2u32', ('u2u64', 'a')) => ('u2u32', 'a')
 *    ('i2i64', ('i2i1', 'a@1')) => ('i2i64', 'a')
 *    ('u2u64', ('u2u1', 'a@1')) => ('u2u64', 'a')
 *    ('i2i64', ('i2i8', 'a@1')) => ('i2i64', 'a')
 *    ('u2u64', ('u2u8', 'a@1')) => ('u2u64', 'a')
 *    ('i2i64', ('i2i8', 'a@8')) => ('i2i64', 'a')
 *    ('u2u64', ('u2u8', 'a@8')) => ('u2u64', 'a')
 *    ('i2i64', ('i2i16', 'a@1')) => ('i2i64', 'a')
 *    ('u2u64', ('u2u16', 'a@1')) => ('u2u64', 'a')
 *    ('i2i64', ('i2i16', 'a@8')) => ('i2i64', 'a')
 *    ('u2u64', ('u2u16', 'a@8')) => ('u2u64', 'a')
 *    ('i2i64', ('i2i16', 'a@16')) => ('i2i64', 'a')
 *    ('u2u64', ('u2u16', 'a@16')) => ('u2u64', 'a')
 *    ('i2i64', ('i2i32', 'a@1')) => ('i2i64', 'a')
 *    ('u2u64', ('u2u32', 'a@1')) => ('u2u64', 'a')
 *    ('i2i64', ('i2i32', 'a@8')) => ('i2i64', 'a')
 *    ('u2u64', ('u2u32', 'a@8')) => ('u2u64', 'a')
 *    ('i2i64', ('i2i32', 'a@16')) => ('i2i64', 'a')
 *    ('u2u64', ('u2u32', 'a@16')) => ('u2u64', 'a')
 *    ('i2i64', ('i2i32', 'a@32')) => ('i2i64', 'a')
 *    ('u2u64', ('u2u32', 'a@32')) => ('u2u64', 'a')
 *    ('i2i8', ('pack_64_2x32_split', 'a', 'b')) => ('i2i8', 'a')
 *    ('i2i8', ('pack_64_2x32_split', 'a', 'b')) => ('i2i8', 'a')
 *    ('i2i16', ('pack_64_2x32_split', 'a', 'b')) => ('i2i16', 'a')
 *    ('i2i16', ('pack_64_2x32_split', 'a', 'b')) => ('i2i16', 'a')
 *    ('i2i32', ('pack_64_2x32_split', 'a', 'b')) => ('i2i32', 'a')
 *    ('i2i32', ('pack_64_2x32_split', 'a', 'b')) => ('i2i32', 'a')
 *    ('u2u8', ('pack_64_2x32_split', 'a', 'b')) => ('u2u8', 'a')
 *    ('u2u8', ('pack_64_2x32_split', 'a', 'b')) => ('u2u8', 'a')
 *    ('u2u16', ('pack_64_2x32_split', 'a', 'b')) => ('u2u16', 'a')
 *    ('u2u16', ('pack_64_2x32_split', 'a', 'b')) => ('u2u16', 'a')
 *    ('u2u32', ('pack_64_2x32_split', 'a', 'b')) => ('u2u32', 'a')
 *    ('u2u32', ('pack_64_2x32_split', 'a', 'b')) => ('u2u32', 'a')
 *    ('ieq', ('i2i16', 'a@8'), ('i2i16', 'b@8')) => ('ieq', 'a', ('i2i8', 'b'))
 *    ('ine', ('i2i16', 'a@8'), ('i2i16', 'b@8')) => ('ine', 'a', ('i2i8', 'b'))
 *    ('ige', ('i2i16', 'a@8'), ('i2i16', 'b@8')) => ('ige', 'a', ('i2i8', 'b'))
 *    ('ilt', ('i2i16', 'a@8'), ('i2i16', 'b@8')) => ('ilt', 'a', ('i2i8', 'b'))
 *    ('ige', ('i2i16', 'b@8'), ('i2i16', 'a@8')) => ('ige', ('i2i8', 'b'), 'a')
 *    ('ilt', ('i2i16', 'b@8'), ('i2i16', 'a@8')) => ('ilt', ('i2i8', 'b'), 'a')
 *    ('ieq', ('i2i16', 'a@8'), '#b') => ('iand', ('ieq', 'a', ('i2i8', 'b')), ('ieq', ('i2i16', ('i2i8', 'b')), 'b'))
 *    ('ine', ('i2i16', 'a@8'), '#b') => ('ior', ('ine', 'a', ('i2i8', 'b')), ('ine', ('i2i16', ('i2i8', 'b')), 'b'))
 *    ('ilt', ('i2i16', 'a@8'), '#b') => ('iand', ('ilt', -128, 'b'), ('ior', ('ilt', 127, 'b'), ('ilt', 'a', ('i2i8', 'b'))))
 *    ('ilt', '#a', ('i2i16', 'b@8')) => ('iand', ('ilt', 'a', 127), ('ior', ('ilt', 'a', -128), ('ilt', ('i2i8', 'a'), 'b')))
 *    ('ige', ('i2i16', 'a@8'), '#b') => ('iand', ('ige', 127, 'b'), ('ior', ('ige', -128, 'b'), ('ige', 'a', ('i2i8', 'b'))))
 *    ('ige', '#a', ('i2i16', 'b@8')) => ('iand', ('ige', 'a', -128), ('ior', ('ige', 'a', 127), ('ige', ('i2i8', 'a'), 'b')))
 *    ('ieq', ('i2i32', 'a@8'), ('i2i32', 'b@8')) => ('ieq', 'a', ('i2i8', 'b'))
 *    ('ine', ('i2i32', 'a@8'), ('i2i32', 'b@8')) => ('ine', 'a', ('i2i8', 'b'))
 *    ('ige', ('i2i32', 'a@8'), ('i2i32', 'b@8')) => ('ige', 'a', ('i2i8', 'b'))
 *    ('ilt', ('i2i32', 'a@8'), ('i2i32', 'b@8')) => ('ilt', 'a', ('i2i8', 'b'))
 *    ('ige', ('i2i32', 'b@8'), ('i2i32', 'a@8')) => ('ige', ('i2i8', 'b'), 'a')
 *    ('ilt', ('i2i32', 'b@8'), ('i2i32', 'a@8')) => ('ilt', ('i2i8', 'b'), 'a')
 *    ('ieq', ('i2i32', 'a@8'), '#b') => ('iand', ('ieq', 'a', ('i2i8', 'b')), ('ieq', ('i2i32', ('i2i8', 'b')), 'b'))
 *    ('ine', ('i2i32', 'a@8'), '#b') => ('ior', ('ine', 'a', ('i2i8', 'b')), ('ine', ('i2i32', ('i2i8', 'b')), 'b'))
 *    ('ilt', ('i2i32', 'a@8'), '#b') => ('iand', ('ilt', -128, 'b'), ('ior', ('ilt', 127, 'b'), ('ilt', 'a', ('i2i8', 'b'))))
 *    ('ilt', '#a', ('i2i32', 'b@8')) => ('iand', ('ilt', 'a', 127), ('ior', ('ilt', 'a', -128), ('ilt', ('i2i8', 'a'), 'b')))
 *    ('ige', ('i2i32', 'a@8'), '#b') => ('iand', ('ige', 127, 'b'), ('ior', ('ige', -128, 'b'), ('ige', 'a', ('i2i8', 'b'))))
 *    ('ige', '#a', ('i2i32', 'b@8')) => ('iand', ('ige', 'a', -128), ('ior', ('ige', 'a', 127), ('ige', ('i2i8', 'a'), 'b')))
 *    ('ieq', ('i2i64', 'a@8'), ('i2i64', 'b@8')) => ('ieq', 'a', ('i2i8', 'b'))
 *    ('ine', ('i2i64', 'a@8'), ('i2i64', 'b@8')) => ('ine', 'a', ('i2i8', 'b'))
 *    ('ige', ('i2i64', 'a@8'), ('i2i64', 'b@8')) => ('ige', 'a', ('i2i8', 'b'))
 *    ('ilt', ('i2i64', 'a@8'), ('i2i64', 'b@8')) => ('ilt', 'a', ('i2i8', 'b'))
 *    ('ige', ('i2i64', 'b@8'), ('i2i64', 'a@8')) => ('ige', ('i2i8', 'b'), 'a')
 *    ('ilt', ('i2i64', 'b@8'), ('i2i64', 'a@8')) => ('ilt', ('i2i8', 'b'), 'a')
 *    ('ieq', ('i2i64', 'a@8'), '#b') => ('iand', ('ieq', 'a', ('i2i8', 'b')), ('ieq', ('i2i64', ('i2i8', 'b')), 'b'))
 *    ('ine', ('i2i64', 'a@8'), '#b') => ('ior', ('ine', 'a', ('i2i8', 'b')), ('ine', ('i2i64', ('i2i8', 'b')), 'b'))
 *    ('ilt', ('i2i64', 'a@8'), '#b') => ('iand', ('ilt', -128, 'b'), ('ior', ('ilt', 127, 'b'), ('ilt', 'a', ('i2i8', 'b'))))
 *    ('ilt', '#a', ('i2i64', 'b@8')) => ('iand', ('ilt', 'a', 127), ('ior', ('ilt', 'a', -128), ('ilt', ('i2i8', 'a'), 'b')))
 *    ('ige', ('i2i64', 'a@8'), '#b') => ('iand', ('ige', 127, 'b'), ('ior', ('ige', -128, 'b'), ('ige', 'a', ('i2i8', 'b'))))
 *    ('ige', '#a', ('i2i64', 'b@8')) => ('iand', ('ige', 'a', -128), ('ior', ('ige', 'a', 127), ('ige', ('i2i8', 'a'), 'b')))
 *    ('ieq', ('i2i32', 'a@16'), ('i2i32', 'b@8')) => ('ieq', 'a', ('i2i16', 'b'))
 *    ('ine', ('i2i32', 'a@16'), ('i2i32', 'b@8')) => ('ine', 'a', ('i2i16', 'b'))
 *    ('ige', ('i2i32', 'a@16'), ('i2i32', 'b@8')) => ('ige', 'a', ('i2i16', 'b'))
 *    ('ilt', ('i2i32', 'a@16'), ('i2i32', 'b@8')) => ('ilt', 'a', ('i2i16', 'b'))
 *    ('ige', ('i2i32', 'b@8'), ('i2i32', 'a@16')) => ('ige', ('i2i16', 'b'), 'a')
 *    ('ilt', ('i2i32', 'b@8'), ('i2i32', 'a@16')) => ('ilt', ('i2i16', 'b'), 'a')
 *    ('ieq', ('i2i32', 'a@16'), ('i2i32', 'b@16')) => ('ieq', 'a', ('i2i16', 'b'))
 *    ('ine', ('i2i32', 'a@16'), ('i2i32', 'b@16')) => ('ine', 'a', ('i2i16', 'b'))
 *    ('ige', ('i2i32', 'a@16'), ('i2i32', 'b@16')) => ('ige', 'a', ('i2i16', 'b'))
 *    ('ilt', ('i2i32', 'a@16'), ('i2i32', 'b@16')) => ('ilt', 'a', ('i2i16', 'b'))
 *    ('ige', ('i2i32', 'b@16'), ('i2i32', 'a@16')) => ('ige', ('i2i16', 'b'), 'a')
 *    ('ilt', ('i2i32', 'b@16'), ('i2i32', 'a@16')) => ('ilt', ('i2i16', 'b'), 'a')
 *    ('ieq', ('i2i32', 'a@16'), '#b') => ('iand', ('ieq', 'a', ('i2i16', 'b')), ('ieq', ('i2i32', ('i2i16', 'b')), 'b'))
 *    ('ine', ('i2i32', 'a@16'), '#b') => ('ior', ('ine', 'a', ('i2i16', 'b')), ('ine', ('i2i32', ('i2i16', 'b')), 'b'))
 *    ('ilt', ('i2i32', 'a@16'), '#b') => ('iand', ('ilt', -32768, 'b'), ('ior', ('ilt', 32767, 'b'), ('ilt', 'a', ('i2i16', 'b'))))
 *    ('ilt', '#a', ('i2i32', 'b@16')) => ('iand', ('ilt', 'a', 32767), ('ior', ('ilt', 'a', -32768), ('ilt', ('i2i16', 'a'), 'b')))
 *    ('ige', ('i2i32', 'a@16'), '#b') => ('iand', ('ige', 32767, 'b'), ('ior', ('ige', -32768, 'b'), ('ige', 'a', ('i2i16', 'b'))))
 *    ('ige', '#a', ('i2i32', 'b@16')) => ('iand', ('ige', 'a', -32768), ('ior', ('ige', 'a', 32767), ('ige', ('i2i16', 'a'), 'b')))
 *    ('ieq', ('i2i64', 'a@16'), ('i2i64', 'b@8')) => ('ieq', 'a', ('i2i16', 'b'))
 *    ('ine', ('i2i64', 'a@16'), ('i2i64', 'b@8')) => ('ine', 'a', ('i2i16', 'b'))
 *    ('ige', ('i2i64', 'a@16'), ('i2i64', 'b@8')) => ('ige', 'a', ('i2i16', 'b'))
 *    ('ilt', ('i2i64', 'a@16'), ('i2i64', 'b@8')) => ('ilt', 'a', ('i2i16', 'b'))
 *    ('ige', ('i2i64', 'b@8'), ('i2i64', 'a@16')) => ('ige', ('i2i16', 'b'), 'a')
 *    ('ilt', ('i2i64', 'b@8'), ('i2i64', 'a@16')) => ('ilt', ('i2i16', 'b'), 'a')
 *    ('ieq', ('i2i64', 'a@16'), ('i2i64', 'b@16')) => ('ieq', 'a', ('i2i16', 'b'))
 *    ('ine', ('i2i64', 'a@16'), ('i2i64', 'b@16')) => ('ine', 'a', ('i2i16', 'b'))
 *    ('ige', ('i2i64', 'a@16'), ('i2i64', 'b@16')) => ('ige', 'a', ('i2i16', 'b'))
 *    ('ilt', ('i2i64', 'a@16'), ('i2i64', 'b@16')) => ('ilt', 'a', ('i2i16', 'b'))
 *    ('ige', ('i2i64', 'b@16'), ('i2i64', 'a@16')) => ('ige', ('i2i16', 'b'), 'a')
 *    ('ilt', ('i2i64', 'b@16'), ('i2i64', 'a@16')) => ('ilt', ('i2i16', 'b'), 'a')
 *    ('ieq', ('i2i64', 'a@16'), '#b') => ('iand', ('ieq', 'a', ('i2i16', 'b')), ('ieq', ('i2i64', ('i2i16', 'b')), 'b'))
 *    ('ine', ('i2i64', 'a@16'), '#b') => ('ior', ('ine', 'a', ('i2i16', 'b')), ('ine', ('i2i64', ('i2i16', 'b')), 'b'))
 *    ('ilt', ('i2i64', 'a@16'), '#b') => ('iand', ('ilt', -32768, 'b'), ('ior', ('ilt', 32767, 'b'), ('ilt', 'a', ('i2i16', 'b'))))
 *    ('ilt', '#a', ('i2i64', 'b@16')) => ('iand', ('ilt', 'a', 32767), ('ior', ('ilt', 'a', -32768), ('ilt', ('i2i16', 'a'), 'b')))
 *    ('ige', ('i2i64', 'a@16'), '#b') => ('iand', ('ige', 32767, 'b'), ('ior', ('ige', -32768, 'b'), ('ige', 'a', ('i2i16', 'b'))))
 *    ('ige', '#a', ('i2i64', 'b@16')) => ('iand', ('ige', 'a', -32768), ('ior', ('ige', 'a', 32767), ('ige', ('i2i16', 'a'), 'b')))
 *    ('ieq', ('i2i64', 'a@32'), ('i2i64', 'b@8')) => ('ieq', 'a', ('i2i32', 'b'))
 *    ('ine', ('i2i64', 'a@32'), ('i2i64', 'b@8')) => ('ine', 'a', ('i2i32', 'b'))
 *    ('ige', ('i2i64', 'a@32'), ('i2i64', 'b@8')) => ('ige', 'a', ('i2i32', 'b'))
 *    ('ilt', ('i2i64', 'a@32'), ('i2i64', 'b@8')) => ('ilt', 'a', ('i2i32', 'b'))
 *    ('ige', ('i2i64', 'b@8'), ('i2i64', 'a@32')) => ('ige', ('i2i32', 'b'), 'a')
 *    ('ilt', ('i2i64', 'b@8'), ('i2i64', 'a@32')) => ('ilt', ('i2i32', 'b'), 'a')
 *    ('ieq', ('i2i64', 'a@32'), ('i2i64', 'b@16')) => ('ieq', 'a', ('i2i32', 'b'))
 *    ('ine', ('i2i64', 'a@32'), ('i2i64', 'b@16')) => ('ine', 'a', ('i2i32', 'b'))
 *    ('ige', ('i2i64', 'a@32'), ('i2i64', 'b@16')) => ('ige', 'a', ('i2i32', 'b'))
 *    ('ilt', ('i2i64', 'a@32'), ('i2i64', 'b@16')) => ('ilt', 'a', ('i2i32', 'b'))
 *    ('ige', ('i2i64', 'b@16'), ('i2i64', 'a@32')) => ('ige', ('i2i32', 'b'), 'a')
 *    ('ilt', ('i2i64', 'b@16'), ('i2i64', 'a@32')) => ('ilt', ('i2i32', 'b'), 'a')
 *    ('ieq', ('i2i64', 'a@32'), ('i2i64', 'b@32')) => ('ieq', 'a', ('i2i32', 'b'))
 *    ('ine', ('i2i64', 'a@32'), ('i2i64', 'b@32')) => ('ine', 'a', ('i2i32', 'b'))
 *    ('ige', ('i2i64', 'a@32'), ('i2i64', 'b@32')) => ('ige', 'a', ('i2i32', 'b'))
 *    ('ilt', ('i2i64', 'a@32'), ('i2i64', 'b@32')) => ('ilt', 'a', ('i2i32', 'b'))
 *    ('ige', ('i2i64', 'b@32'), ('i2i64', 'a@32')) => ('ige', ('i2i32', 'b'), 'a')
 *    ('ilt', ('i2i64', 'b@32'), ('i2i64', 'a@32')) => ('ilt', ('i2i32', 'b'), 'a')
 *    ('ieq', ('i2i64', 'a@32'), '#b') => ('iand', ('ieq', 'a', ('i2i32', 'b')), ('ieq', ('i2i64', ('i2i32', 'b')), 'b'))
 *    ('ine', ('i2i64', 'a@32'), '#b') => ('ior', ('ine', 'a', ('i2i32', 'b')), ('ine', ('i2i64', ('i2i32', 'b')), 'b'))
 *    ('ilt', ('i2i64', 'a@32'), '#b') => ('iand', ('ilt', -2147483648, 'b'), ('ior', ('ilt', 2147483647, 'b'), ('ilt', 'a', ('i2i32', 'b'))))
 *    ('ilt', '#a', ('i2i64', 'b@32')) => ('iand', ('ilt', 'a', 2147483647), ('ior', ('ilt', 'a', -2147483648), ('ilt', ('i2i32', 'a'), 'b')))
 *    ('ige', ('i2i64', 'a@32'), '#b') => ('iand', ('ige', 2147483647, 'b'), ('ior', ('ige', -2147483648, 'b'), ('ige', 'a', ('i2i32', 'b'))))
 *    ('ige', '#a', ('i2i64', 'b@32')) => ('iand', ('ige', 'a', -2147483648), ('ior', ('ige', 'a', 2147483647), ('ige', ('i2i32', 'a'), 'b')))
 *    ('ieq', ('u2u16', 'a@8'), ('u2u16', 'b@8')) => ('ieq', 'a', ('u2u8', 'b'))
 *    ('ine', ('u2u16', 'a@8'), ('u2u16', 'b@8')) => ('ine', 'a', ('u2u8', 'b'))
 *    ('uge', ('u2u16', 'a@8'), ('u2u16', 'b@8')) => ('uge', 'a', ('u2u8', 'b'))
 *    ('ult', ('u2u16', 'a@8'), ('u2u16', 'b@8')) => ('ult', 'a', ('u2u8', 'b'))
 *    ('uge', ('u2u16', 'b@8'), ('u2u16', 'a@8')) => ('uge', ('u2u8', 'b'), 'a')
 *    ('ult', ('u2u16', 'b@8'), ('u2u16', 'a@8')) => ('ult', ('u2u8', 'b'), 'a')
 *    ('ieq', ('u2u16', 'a@8'), '#b') => ('iand', ('ieq', 'a', ('u2u8', 'b')), ('ieq', ('u2u16', ('u2u8', 'b')), 'b'))
 *    ('ine', ('u2u16', 'a@8'), '#b') => ('ior', ('ine', 'a', ('u2u8', 'b')), ('ine', ('u2u16', ('u2u8', 'b')), 'b'))
 *    ('ult', ('u2u16', 'a@8'), '#b') => ('iand', ('ult', 0, 'b'), ('ior', ('ult', 255, 'b'), ('ult', 'a', ('u2u8', 'b'))))
 *    ('ult', '#a', ('u2u16', 'b@8')) => ('iand', ('ult', 'a', 255), ('ior', ('ult', 'a', 0), ('ult', ('u2u8', 'a'), 'b')))
 *    ('uge', ('u2u16', 'a@8'), '#b') => ('iand', ('uge', 255, 'b'), ('ior', ('uge', 0, 'b'), ('uge', 'a', ('u2u8', 'b'))))
 *    ('uge', '#a', ('u2u16', 'b@8')) => ('iand', ('uge', 'a', 0), ('ior', ('uge', 'a', 255), ('uge', ('u2u8', 'a'), 'b')))
 *    ('ieq', ('u2u32', 'a@8'), ('u2u32', 'b@8')) => ('ieq', 'a', ('u2u8', 'b'))
 *    ('ine', ('u2u32', 'a@8'), ('u2u32', 'b@8')) => ('ine', 'a', ('u2u8', 'b'))
 *    ('uge', ('u2u32', 'a@8'), ('u2u32', 'b@8')) => ('uge', 'a', ('u2u8', 'b'))
 *    ('ult', ('u2u32', 'a@8'), ('u2u32', 'b@8')) => ('ult', 'a', ('u2u8', 'b'))
 *    ('uge', ('u2u32', 'b@8'), ('u2u32', 'a@8')) => ('uge', ('u2u8', 'b'), 'a')
 *    ('ult', ('u2u32', 'b@8'), ('u2u32', 'a@8')) => ('ult', ('u2u8', 'b'), 'a')
 *    ('ieq', ('u2u32', 'a@8'), '#b') => ('iand', ('ieq', 'a', ('u2u8', 'b')), ('ieq', ('u2u32', ('u2u8', 'b')), 'b'))
 *    ('ine', ('u2u32', 'a@8'), '#b') => ('ior', ('ine', 'a', ('u2u8', 'b')), ('ine', ('u2u32', ('u2u8', 'b')), 'b'))
 *    ('ult', ('u2u32', 'a@8'), '#b') => ('iand', ('ult', 0, 'b'), ('ior', ('ult', 255, 'b'), ('ult', 'a', ('u2u8', 'b'))))
 *    ('ult', '#a', ('u2u32', 'b@8')) => ('iand', ('ult', 'a', 255), ('ior', ('ult', 'a', 0), ('ult', ('u2u8', 'a'), 'b')))
 *    ('uge', ('u2u32', 'a@8'), '#b') => ('iand', ('uge', 255, 'b'), ('ior', ('uge', 0, 'b'), ('uge', 'a', ('u2u8', 'b'))))
 *    ('uge', '#a', ('u2u32', 'b@8')) => ('iand', ('uge', 'a', 0), ('ior', ('uge', 'a', 255), ('uge', ('u2u8', 'a'), 'b')))
 *    ('ieq', ('u2u64', 'a@8'), ('u2u64', 'b@8')) => ('ieq', 'a', ('u2u8', 'b'))
 *    ('ine', ('u2u64', 'a@8'), ('u2u64', 'b@8')) => ('ine', 'a', ('u2u8', 'b'))
 *    ('uge', ('u2u64', 'a@8'), ('u2u64', 'b@8')) => ('uge', 'a', ('u2u8', 'b'))
 *    ('ult', ('u2u64', 'a@8'), ('u2u64', 'b@8')) => ('ult', 'a', ('u2u8', 'b'))
 *    ('uge', ('u2u64', 'b@8'), ('u2u64', 'a@8')) => ('uge', ('u2u8', 'b'), 'a')
 *    ('ult', ('u2u64', 'b@8'), ('u2u64', 'a@8')) => ('ult', ('u2u8', 'b'), 'a')
 *    ('ieq', ('u2u64', 'a@8'), '#b') => ('iand', ('ieq', 'a', ('u2u8', 'b')), ('ieq', ('u2u64', ('u2u8', 'b')), 'b'))
 *    ('ine', ('u2u64', 'a@8'), '#b') => ('ior', ('ine', 'a', ('u2u8', 'b')), ('ine', ('u2u64', ('u2u8', 'b')), 'b'))
 *    ('ult', ('u2u64', 'a@8'), '#b') => ('iand', ('ult', 0, 'b'), ('ior', ('ult', 255, 'b'), ('ult', 'a', ('u2u8', 'b'))))
 *    ('ult', '#a', ('u2u64', 'b@8')) => ('iand', ('ult', 'a', 255), ('ior', ('ult', 'a', 0), ('ult', ('u2u8', 'a'), 'b')))
 *    ('uge', ('u2u64', 'a@8'), '#b') => ('iand', ('uge', 255, 'b'), ('ior', ('uge', 0, 'b'), ('uge', 'a', ('u2u8', 'b'))))
 *    ('uge', '#a', ('u2u64', 'b@8')) => ('iand', ('uge', 'a', 0), ('ior', ('uge', 'a', 255), ('uge', ('u2u8', 'a'), 'b')))
 *    ('ieq', ('u2u32', 'a@16'), ('u2u32', 'b@8')) => ('ieq', 'a', ('u2u16', 'b'))
 *    ('ine', ('u2u32', 'a@16'), ('u2u32', 'b@8')) => ('ine', 'a', ('u2u16', 'b'))
 *    ('uge', ('u2u32', 'a@16'), ('u2u32', 'b@8')) => ('uge', 'a', ('u2u16', 'b'))
 *    ('ult', ('u2u32', 'a@16'), ('u2u32', 'b@8')) => ('ult', 'a', ('u2u16', 'b'))
 *    ('uge', ('u2u32', 'b@8'), ('u2u32', 'a@16')) => ('uge', ('u2u16', 'b'), 'a')
 *    ('ult', ('u2u32', 'b@8'), ('u2u32', 'a@16')) => ('ult', ('u2u16', 'b'), 'a')
 *    ('ieq', ('u2u32', 'a@16'), ('u2u32', 'b@16')) => ('ieq', 'a', ('u2u16', 'b'))
 *    ('ine', ('u2u32', 'a@16'), ('u2u32', 'b@16')) => ('ine', 'a', ('u2u16', 'b'))
 *    ('uge', ('u2u32', 'a@16'), ('u2u32', 'b@16')) => ('uge', 'a', ('u2u16', 'b'))
 *    ('ult', ('u2u32', 'a@16'), ('u2u32', 'b@16')) => ('ult', 'a', ('u2u16', 'b'))
 *    ('uge', ('u2u32', 'b@16'), ('u2u32', 'a@16')) => ('uge', ('u2u16', 'b'), 'a')
 *    ('ult', ('u2u32', 'b@16'), ('u2u32', 'a@16')) => ('ult', ('u2u16', 'b'), 'a')
 *    ('ieq', ('u2u32', 'a@16'), '#b') => ('iand', ('ieq', 'a', ('u2u16', 'b')), ('ieq', ('u2u32', ('u2u16', 'b')), 'b'))
 *    ('ine', ('u2u32', 'a@16'), '#b') => ('ior', ('ine', 'a', ('u2u16', 'b')), ('ine', ('u2u32', ('u2u16', 'b')), 'b'))
 *    ('ult', ('u2u32', 'a@16'), '#b') => ('iand', ('ult', 0, 'b'), ('ior', ('ult', 65535, 'b'), ('ult', 'a', ('u2u16', 'b'))))
 *    ('ult', '#a', ('u2u32', 'b@16')) => ('iand', ('ult', 'a', 65535), ('ior', ('ult', 'a', 0), ('ult', ('u2u16', 'a'), 'b')))
 *    ('uge', ('u2u32', 'a@16'), '#b') => ('iand', ('uge', 65535, 'b'), ('ior', ('uge', 0, 'b'), ('uge', 'a', ('u2u16', 'b'))))
 *    ('uge', '#a', ('u2u32', 'b@16')) => ('iand', ('uge', 'a', 0), ('ior', ('uge', 'a', 65535), ('uge', ('u2u16', 'a'), 'b')))
 *    ('ieq', ('u2u64', 'a@16'), ('u2u64', 'b@8')) => ('ieq', 'a', ('u2u16', 'b'))
 *    ('ine', ('u2u64', 'a@16'), ('u2u64', 'b@8')) => ('ine', 'a', ('u2u16', 'b'))
 *    ('uge', ('u2u64', 'a@16'), ('u2u64', 'b@8')) => ('uge', 'a', ('u2u16', 'b'))
 *    ('ult', ('u2u64', 'a@16'), ('u2u64', 'b@8')) => ('ult', 'a', ('u2u16', 'b'))
 *    ('uge', ('u2u64', 'b@8'), ('u2u64', 'a@16')) => ('uge', ('u2u16', 'b'), 'a')
 *    ('ult', ('u2u64', 'b@8'), ('u2u64', 'a@16')) => ('ult', ('u2u16', 'b'), 'a')
 *    ('ieq', ('u2u64', 'a@16'), ('u2u64', 'b@16')) => ('ieq', 'a', ('u2u16', 'b'))
 *    ('ine', ('u2u64', 'a@16'), ('u2u64', 'b@16')) => ('ine', 'a', ('u2u16', 'b'))
 *    ('uge', ('u2u64', 'a@16'), ('u2u64', 'b@16')) => ('uge', 'a', ('u2u16', 'b'))
 *    ('ult', ('u2u64', 'a@16'), ('u2u64', 'b@16')) => ('ult', 'a', ('u2u16', 'b'))
 *    ('uge', ('u2u64', 'b@16'), ('u2u64', 'a@16')) => ('uge', ('u2u16', 'b'), 'a')
 *    ('ult', ('u2u64', 'b@16'), ('u2u64', 'a@16')) => ('ult', ('u2u16', 'b'), 'a')
 *    ('ieq', ('u2u64', 'a@16'), '#b') => ('iand', ('ieq', 'a', ('u2u16', 'b')), ('ieq', ('u2u64', ('u2u16', 'b')), 'b'))
 *    ('ine', ('u2u64', 'a@16'), '#b') => ('ior', ('ine', 'a', ('u2u16', 'b')), ('ine', ('u2u64', ('u2u16', 'b')), 'b'))
 *    ('ult', ('u2u64', 'a@16'), '#b') => ('iand', ('ult', 0, 'b'), ('ior', ('ult', 65535, 'b'), ('ult', 'a', ('u2u16', 'b'))))
 *    ('ult', '#a', ('u2u64', 'b@16')) => ('iand', ('ult', 'a', 65535), ('ior', ('ult', 'a', 0), ('ult', ('u2u16', 'a'), 'b')))
 *    ('uge', ('u2u64', 'a@16'), '#b') => ('iand', ('uge', 65535, 'b'), ('ior', ('uge', 0, 'b'), ('uge', 'a', ('u2u16', 'b'))))
 *    ('uge', '#a', ('u2u64', 'b@16')) => ('iand', ('uge', 'a', 0), ('ior', ('uge', 'a', 65535), ('uge', ('u2u16', 'a'), 'b')))
 *    ('ieq', ('u2u64', 'a@32'), ('u2u64', 'b@8')) => ('ieq', 'a', ('u2u32', 'b'))
 *    ('ine', ('u2u64', 'a@32'), ('u2u64', 'b@8')) => ('ine', 'a', ('u2u32', 'b'))
 *    ('uge', ('u2u64', 'a@32'), ('u2u64', 'b@8')) => ('uge', 'a', ('u2u32', 'b'))
 *    ('ult', ('u2u64', 'a@32'), ('u2u64', 'b@8')) => ('ult', 'a', ('u2u32', 'b'))
 *    ('uge', ('u2u64', 'b@8'), ('u2u64', 'a@32')) => ('uge', ('u2u32', 'b'), 'a')
 *    ('ult', ('u2u64', 'b@8'), ('u2u64', 'a@32')) => ('ult', ('u2u32', 'b'), 'a')
 *    ('ieq', ('u2u64', 'a@32'), ('u2u64', 'b@16')) => ('ieq', 'a', ('u2u32', 'b'))
 *    ('ine', ('u2u64', 'a@32'), ('u2u64', 'b@16')) => ('ine', 'a', ('u2u32', 'b'))
 *    ('uge', ('u2u64', 'a@32'), ('u2u64', 'b@16')) => ('uge', 'a', ('u2u32', 'b'))
 *    ('ult', ('u2u64', 'a@32'), ('u2u64', 'b@16')) => ('ult', 'a', ('u2u32', 'b'))
 *    ('uge', ('u2u64', 'b@16'), ('u2u64', 'a@32')) => ('uge', ('u2u32', 'b'), 'a')
 *    ('ult', ('u2u64', 'b@16'), ('u2u64', 'a@32')) => ('ult', ('u2u32', 'b'), 'a')
 *    ('ieq', ('u2u64', 'a@32'), ('u2u64', 'b@32')) => ('ieq', 'a', ('u2u32', 'b'))
 *    ('ine', ('u2u64', 'a@32'), ('u2u64', 'b@32')) => ('ine', 'a', ('u2u32', 'b'))
 *    ('uge', ('u2u64', 'a@32'), ('u2u64', 'b@32')) => ('uge', 'a', ('u2u32', 'b'))
 *    ('ult', ('u2u64', 'a@32'), ('u2u64', 'b@32')) => ('ult', 'a', ('u2u32', 'b'))
 *    ('uge', ('u2u64', 'b@32'), ('u2u64', 'a@32')) => ('uge', ('u2u32', 'b'), 'a')
 *    ('ult', ('u2u64', 'b@32'), ('u2u64', 'a@32')) => ('ult', ('u2u32', 'b'), 'a')
 *    ('ieq', ('u2u64', 'a@32'), '#b') => ('iand', ('ieq', 'a', ('u2u32', 'b')), ('ieq', ('u2u64', ('u2u32', 'b')), 'b'))
 *    ('ine', ('u2u64', 'a@32'), '#b') => ('ior', ('ine', 'a', ('u2u32', 'b')), ('ine', ('u2u64', ('u2u32', 'b')), 'b'))
 *    ('ult', ('u2u64', 'a@32'), '#b') => ('iand', ('ult', 0, 'b'), ('ior', ('ult', 4294967295, 'b'), ('ult', 'a', ('u2u32', 'b'))))
 *    ('ult', '#a', ('u2u64', 'b@32')) => ('iand', ('ult', 'a', 4294967295), ('ior', ('ult', 'a', 0), ('ult', ('u2u32', 'a'), 'b')))
 *    ('uge', ('u2u64', 'a@32'), '#b') => ('iand', ('uge', 4294967295, 'b'), ('ior', ('uge', 0, 'b'), ('uge', 'a', ('u2u32', 'b'))))
 *    ('uge', '#a', ('u2u64', 'b@32')) => ('iand', ('uge', 'a', 0), ('ior', ('uge', 'a', 4294967295), ('uge', ('u2u32', 'a'), 'b')))
 *    ('feq', ('f2f32', 'a@16'), ('f2f32', 'b@16')) => ('feq', 'a', ('f2f16', 'b'))
 *    ('fneu', ('f2f32', 'a@16'), ('f2f32', 'b@16')) => ('fneu', 'a', ('f2f16', 'b'))
 *    ('fge', ('f2f32', 'a@16'), ('f2f32', 'b@16')) => ('fge', 'a', ('f2f16', 'b'))
 *    ('flt', ('f2f32', 'a@16'), ('f2f32', 'b@16')) => ('flt', 'a', ('f2f16', 'b'))
 *    ('fge', ('f2f32', 'b@16'), ('f2f32', 'a@16')) => ('fge', ('f2f16', 'b'), 'a')
 *    ('flt', ('f2f32', 'b@16'), ('f2f32', 'a@16')) => ('flt', ('f2f16', 'b'), 'a')
 *    ('feq', ('f2f64', 'a@16'), ('f2f64', 'b@16')) => ('feq', 'a', ('f2f16', 'b'))
 *    ('fneu', ('f2f64', 'a@16'), ('f2f64', 'b@16')) => ('fneu', 'a', ('f2f16', 'b'))
 *    ('fge', ('f2f64', 'a@16'), ('f2f64', 'b@16')) => ('fge', 'a', ('f2f16', 'b'))
 *    ('flt', ('f2f64', 'a@16'), ('f2f64', 'b@16')) => ('flt', 'a', ('f2f16', 'b'))
 *    ('fge', ('f2f64', 'b@16'), ('f2f64', 'a@16')) => ('fge', ('f2f16', 'b'), 'a')
 *    ('flt', ('f2f64', 'b@16'), ('f2f64', 'a@16')) => ('flt', ('f2f16', 'b'), 'a')
 *    ('feq', ('f2f64', 'a@32'), ('f2f64', 'b@16')) => ('feq', 'a', ('f2f32', 'b'))
 *    ('fneu', ('f2f64', 'a@32'), ('f2f64', 'b@16')) => ('fneu', 'a', ('f2f32', 'b'))
 *    ('fge', ('f2f64', 'a@32'), ('f2f64', 'b@16')) => ('fge', 'a', ('f2f32', 'b'))
 *    ('flt', ('f2f64', 'a@32'), ('f2f64', 'b@16')) => ('flt', 'a', ('f2f32', 'b'))
 *    ('fge', ('f2f64', 'b@16'), ('f2f64', 'a@32')) => ('fge', ('f2f32', 'b'), 'a')
 *    ('flt', ('f2f64', 'b@16'), ('f2f64', 'a@32')) => ('flt', ('f2f32', 'b'), 'a')
 *    ('feq', ('f2f64', 'a@32'), ('f2f64', 'b@32')) => ('feq', 'a', ('f2f32', 'b'))
 *    ('fneu', ('f2f64', 'a@32'), ('f2f64', 'b@32')) => ('fneu', 'a', ('f2f32', 'b'))
 *    ('fge', ('f2f64', 'a@32'), ('f2f64', 'b@32')) => ('fge', 'a', ('f2f32', 'b'))
 *    ('flt', ('f2f64', 'a@32'), ('f2f64', 'b@32')) => ('flt', 'a', ('f2f32', 'b'))
 *    ('fge', ('f2f64', 'b@32'), ('f2f64', 'a@32')) => ('fge', ('f2f32', 'b'), 'a')
 *    ('flt', ('f2f64', 'b@32'), ('f2f64', 'a@32')) => ('flt', ('f2f32', 'b'), 'a')
 *    ('i2i32', ('iand', 'a@64', 4294967295)) => ('u2u32', 'a')
 *    ('i2i16', ('iand', 'a@32', 65535)) => ('u2u16', 'a')
 *    ('i2i16', ('iand', 'a@64', 65535)) => ('u2u16', 'a')
 *    ('i2i8', ('iand', 'a@16', 255)) => ('u2u8', 'a')
 *    ('i2i8', ('iand', 'a@32', 255)) => ('u2u8', 'a')
 *    ('i2i8', ('iand', 'a@64', 255)) => ('u2u8', 'a')
 *    ('u2u16(only_lower_8_bits_used)', ('u2u8', 'a@16')) => a
 *    ('extract_u8(only_lower_8_bits_used)', 'a@16', 0) => a
 *    ('bcsel(only_lower_8_bits_used)', 'c', ('u2u16', ('u2u8', 'a@16')), 'b') => ('bcsel', 'c', 'a', 'b')
 *    ('bcsel(only_lower_8_bits_used)', 'c', ('u2u16', ('i2i8', 'a@16')), 'b') => ('bcsel', 'c', 'a', 'b')
 *    ('bcsel(only_lower_8_bits_used)', 'c', ('extract_u8', 'a@16', 0), 'b') => ('bcsel', 'c', 'a', 'b')
 *    ('iadd(only_lower_8_bits_used)', ('u2u16', ('u2u8', 'a@16')), 'b') => ('iadd', 'a', 'b')
 *    ('iadd(only_lower_8_bits_used)', ('u2u16', ('i2i8', 'a@16')), 'b') => ('iadd', 'a', 'b')
 *    ('iadd(only_lower_8_bits_used)', ('extract_u8', 'a@16', 0), 'b') => ('iadd', 'a', 'b')
 *    ('imul(only_lower_8_bits_used)', ('u2u16', ('u2u8', 'a@16')), 'b') => ('imul', 'a', 'b')
 *    ('imul(only_lower_8_bits_used)', ('u2u16', ('i2i8', 'a@16')), 'b') => ('imul', 'a', 'b')
 *    ('imul(only_lower_8_bits_used)', ('extract_u8', 'a@16', 0), 'b') => ('imul', 'a', 'b')
 *    ('iand(only_lower_8_bits_used)', ('u2u16', ('u2u8', 'a@16')), 'b') => ('iand', 'a', 'b')
 *    ('iand(only_lower_8_bits_used)', ('u2u16', ('i2i8', 'a@16')), 'b') => ('iand', 'a', 'b')
 *    ('iand(only_lower_8_bits_used)', ('extract_u8', 'a@16', 0), 'b') => ('iand', 'a', 'b')
 *    ('ior(only_lower_8_bits_used)', ('u2u16', ('u2u8', 'a@16')), 'b') => ('ior', 'a', 'b')
 *    ('ior(only_lower_8_bits_used)', ('u2u16', ('i2i8', 'a@16')), 'b') => ('ior', 'a', 'b')
 *    ('ior(only_lower_8_bits_used)', ('extract_u8', 'a@16', 0), 'b') => ('ior', 'a', 'b')
 *    ('ixor(only_lower_8_bits_used)', ('u2u16', ('u2u8', 'a@16')), 'b') => ('ixor', 'a', 'b')
 *    ('ixor(only_lower_8_bits_used)', ('u2u16', ('i2i8', 'a@16')), 'b') => ('ixor', 'a', 'b')
 *    ('ixor(only_lower_8_bits_used)', ('extract_u8', 'a@16', 0), 'b') => ('ixor', 'a', 'b')
 *    ('i2i16(only_lower_8_bits_used)', ('u2u8', 'a@16')) => a
 *    ('extract_i8(only_lower_8_bits_used)', 'a@16', 0) => a
 *    ('bcsel(only_lower_8_bits_used)', 'c', ('i2i16', ('u2u8', 'a@16')), 'b') => ('bcsel', 'c', 'a', 'b')
 *    ('bcsel(only_lower_8_bits_used)', 'c', ('i2i16', ('i2i8', 'a@16')), 'b') => ('bcsel', 'c', 'a', 'b')
 *    ('bcsel(only_lower_8_bits_used)', 'c', ('extract_i8', 'a@16', 0), 'b') => ('bcsel', 'c', 'a', 'b')
 *    ('iadd(only_lower_8_bits_used)', ('i2i16', ('u2u8', 'a@16')), 'b') => ('iadd', 'a', 'b')
 *    ('iadd(only_lower_8_bits_used)', ('i2i16', ('i2i8', 'a@16')), 'b') => ('iadd', 'a', 'b')
 *    ('iadd(only_lower_8_bits_used)', ('extract_i8', 'a@16', 0), 'b') => ('iadd', 'a', 'b')
 *    ('imul(only_lower_8_bits_used)', ('i2i16', ('u2u8', 'a@16')), 'b') => ('imul', 'a', 'b')
 *    ('imul(only_lower_8_bits_used)', ('i2i16', ('i2i8', 'a@16')), 'b') => ('imul', 'a', 'b')
 *    ('imul(only_lower_8_bits_used)', ('extract_i8', 'a@16', 0), 'b') => ('imul', 'a', 'b')
 *    ('iand(only_lower_8_bits_used)', ('i2i16', ('u2u8', 'a@16')), 'b') => ('iand', 'a', 'b')
 *    ('iand(only_lower_8_bits_used)', ('i2i16', ('i2i8', 'a@16')), 'b') => ('iand', 'a', 'b')
 *    ('iand(only_lower_8_bits_used)', ('extract_i8', 'a@16', 0), 'b') => ('iand', 'a', 'b')
 *    ('ior(only_lower_8_bits_used)', ('i2i16', ('u2u8', 'a@16')), 'b') => ('ior', 'a', 'b')
 *    ('ior(only_lower_8_bits_used)', ('i2i16', ('i2i8', 'a@16')), 'b') => ('ior', 'a', 'b')
 *    ('ior(only_lower_8_bits_used)', ('extract_i8', 'a@16', 0), 'b') => ('ior', 'a', 'b')
 *    ('ixor(only_lower_8_bits_used)', ('i2i16', ('u2u8', 'a@16')), 'b') => ('ixor', 'a', 'b')
 *    ('ixor(only_lower_8_bits_used)', ('i2i16', ('i2i8', 'a@16')), 'b') => ('ixor', 'a', 'b')
 *    ('ixor(only_lower_8_bits_used)', ('extract_i8', 'a@16', 0), 'b') => ('ixor', 'a', 'b')
 *    ('u2u32(only_lower_8_bits_used)', ('u2u8', 'a@32')) => a
 *    ('extract_u8(only_lower_8_bits_used)', 'a@32', 0) => a
 *    ('bcsel(only_lower_8_bits_used)', 'c', ('u2u32', ('u2u8', 'a@32')), 'b') => ('bcsel', 'c', 'a', 'b')
 *    ('bcsel(only_lower_8_bits_used)', 'c', ('u2u32', ('i2i8', 'a@32')), 'b') => ('bcsel', 'c', 'a', 'b')
 *    ('bcsel(only_lower_8_bits_used)', 'c', ('extract_u8', 'a@32', 0), 'b') => ('bcsel', 'c', 'a', 'b')
 *    ('iadd(only_lower_8_bits_used)', ('u2u32', ('u2u8', 'a@32')), 'b') => ('iadd', 'a', 'b')
 *    ('iadd(only_lower_8_bits_used)', ('u2u32', ('i2i8', 'a@32')), 'b') => ('iadd', 'a', 'b')
 *    ('iadd(only_lower_8_bits_used)', ('extract_u8', 'a@32', 0), 'b') => ('iadd', 'a', 'b')
 *    ('imul(only_lower_8_bits_used)', ('u2u32', ('u2u8', 'a@32')), 'b') => ('imul', 'a', 'b')
 *    ('imul(only_lower_8_bits_used)', ('u2u32', ('i2i8', 'a@32')), 'b') => ('imul', 'a', 'b')
 *    ('imul(only_lower_8_bits_used)', ('extract_u8', 'a@32', 0), 'b') => ('imul', 'a', 'b')
 *    ('iand(only_lower_8_bits_used)', ('u2u32', ('u2u8', 'a@32')), 'b') => ('iand', 'a', 'b')
 *    ('iand(only_lower_8_bits_used)', ('u2u32', ('i2i8', 'a@32')), 'b') => ('iand', 'a', 'b')
 *    ('iand(only_lower_8_bits_used)', ('extract_u8', 'a@32', 0), 'b') => ('iand', 'a', 'b')
 *    ('ior(only_lower_8_bits_used)', ('u2u32', ('u2u8', 'a@32')), 'b') => ('ior', 'a', 'b')
 *    ('ior(only_lower_8_bits_used)', ('u2u32', ('i2i8', 'a@32')), 'b') => ('ior', 'a', 'b')
 *    ('ior(only_lower_8_bits_used)', ('extract_u8', 'a@32', 0), 'b') => ('ior', 'a', 'b')
 *    ('ixor(only_lower_8_bits_used)', ('u2u32', ('u2u8', 'a@32')), 'b') => ('ixor', 'a', 'b')
 *    ('ixor(only_lower_8_bits_used)', ('u2u32', ('i2i8', 'a@32')), 'b') => ('ixor', 'a', 'b')
 *    ('ixor(only_lower_8_bits_used)', ('extract_u8', 'a@32', 0), 'b') => ('ixor', 'a', 'b')
 *    ('i2i32(only_lower_8_bits_used)', ('u2u8', 'a@32')) => a
 *    ('extract_i8(only_lower_8_bits_used)', 'a@32', 0) => a
 *    ('bcsel(only_lower_8_bits_used)', 'c', ('i2i32', ('u2u8', 'a@32')), 'b') => ('bcsel', 'c', 'a', 'b')
 *    ('bcsel(only_lower_8_bits_used)', 'c', ('i2i32', ('i2i8', 'a@32')), 'b') => ('bcsel', 'c', 'a', 'b')
 *    ('bcsel(only_lower_8_bits_used)', 'c', ('extract_i8', 'a@32', 0), 'b') => ('bcsel', 'c', 'a', 'b')
 *    ('iadd(only_lower_8_bits_used)', ('i2i32', ('u2u8', 'a@32')), 'b') => ('iadd', 'a', 'b')
 *    ('iadd(only_lower_8_bits_used)', ('i2i32', ('i2i8', 'a@32')), 'b') => ('iadd', 'a', 'b')
 *    ('iadd(only_lower_8_bits_used)', ('extract_i8', 'a@32', 0), 'b') => ('iadd', 'a', 'b')
 *    ('imul(only_lower_8_bits_used)', ('i2i32', ('u2u8', 'a@32')), 'b') => ('imul', 'a', 'b')
 *    ('imul(only_lower_8_bits_used)', ('i2i32', ('i2i8', 'a@32')), 'b') => ('imul', 'a', 'b')
 *    ('imul(only_lower_8_bits_used)', ('extract_i8', 'a@32', 0), 'b') => ('imul', 'a', 'b')
 *    ('iand(only_lower_8_bits_used)', ('i2i32', ('u2u8', 'a@32')), 'b') => ('iand', 'a', 'b')
 *    ('iand(only_lower_8_bits_used)', ('i2i32', ('i2i8', 'a@32')), 'b') => ('iand', 'a', 'b')
 *    ('iand(only_lower_8_bits_used)', ('extract_i8', 'a@32', 0), 'b') => ('iand', 'a', 'b')
 *    ('ior(only_lower_8_bits_used)', ('i2i32', ('u2u8', 'a@32')), 'b') => ('ior', 'a', 'b')
 *    ('ior(only_lower_8_bits_used)', ('i2i32', ('i2i8', 'a@32')), 'b') => ('ior', 'a', 'b')
 *    ('ior(only_lower_8_bits_used)', ('extract_i8', 'a@32', 0), 'b') => ('ior', 'a', 'b')
 *    ('ixor(only_lower_8_bits_used)', ('i2i32', ('u2u8', 'a@32')), 'b') => ('ixor', 'a', 'b')
 *    ('ixor(only_lower_8_bits_used)', ('i2i32', ('i2i8', 'a@32')), 'b') => ('ixor', 'a', 'b')
 *    ('ixor(only_lower_8_bits_used)', ('extract_i8', 'a@32', 0), 'b') => ('ixor', 'a', 'b')
 *    ('u2u32(only_lower_16_bits_used)', ('u2u16', 'a@32')) => a
 *    ('extract_u16(only_lower_16_bits_used)', 'a@32', 0) => a
 *    ('bcsel(only_lower_16_bits_used)', 'c', ('u2u32', ('u2u16', 'a@32')), 'b') => ('bcsel', 'c', 'a', 'b')
 *    ('bcsel(only_lower_16_bits_used)', 'c', ('u2u32', ('i2i16', 'a@32')), 'b') => ('bcsel', 'c', 'a', 'b')
 *    ('bcsel(only_lower_16_bits_used)', 'c', ('extract_u16', 'a@32', 0), 'b') => ('bcsel', 'c', 'a', 'b')
 *    ('iadd(only_lower_16_bits_used)', ('u2u32', ('u2u16', 'a@32')), 'b') => ('iadd', 'a', 'b')
 *    ('iadd(only_lower_16_bits_used)', ('u2u32', ('i2i16', 'a@32')), 'b') => ('iadd', 'a', 'b')
 *    ('iadd(only_lower_16_bits_used)', ('extract_u16', 'a@32', 0), 'b') => ('iadd', 'a', 'b')
 *    ('imul(only_lower_16_bits_used)', ('u2u32', ('u2u16', 'a@32')), 'b') => ('imul', 'a', 'b')
 *    ('imul(only_lower_16_bits_used)', ('u2u32', ('i2i16', 'a@32')), 'b') => ('imul', 'a', 'b')
 *    ('imul(only_lower_16_bits_used)', ('extract_u16', 'a@32', 0), 'b') => ('imul', 'a', 'b')
 *    ('iand(only_lower_16_bits_used)', ('u2u32', ('u2u16', 'a@32')), 'b') => ('iand', 'a', 'b')
 *    ('iand(only_lower_16_bits_used)', ('u2u32', ('i2i16', 'a@32')), 'b') => ('iand', 'a', 'b')
 *    ('iand(only_lower_16_bits_used)', ('extract_u16', 'a@32', 0), 'b') => ('iand', 'a', 'b')
 *    ('ior(only_lower_16_bits_used)', ('u2u32', ('u2u16', 'a@32')), 'b') => ('ior', 'a', 'b')
 *    ('ior(only_lower_16_bits_used)', ('u2u32', ('i2i16', 'a@32')), 'b') => ('ior', 'a', 'b')
 *    ('ior(only_lower_16_bits_used)', ('extract_u16', 'a@32', 0), 'b') => ('ior', 'a', 'b')
 *    ('ixor(only_lower_16_bits_used)', ('u2u32', ('u2u16', 'a@32')), 'b') => ('ixor', 'a', 'b')
 *    ('ixor(only_lower_16_bits_used)', ('u2u32', ('i2i16', 'a@32')), 'b') => ('ixor', 'a', 'b')
 *    ('ixor(only_lower_16_bits_used)', ('extract_u16', 'a@32', 0), 'b') => ('ixor', 'a', 'b')
 *    ('i2i32(only_lower_16_bits_used)', ('u2u16', 'a@32')) => a
 *    ('extract_i16(only_lower_16_bits_used)', 'a@32', 0) => a
 *    ('bcsel(only_lower_16_bits_used)', 'c', ('i2i32', ('u2u16', 'a@32')), 'b') => ('bcsel', 'c', 'a', 'b')
 *    ('bcsel(only_lower_16_bits_used)', 'c', ('i2i32', ('i2i16', 'a@32')), 'b') => ('bcsel', 'c', 'a', 'b')
 *    ('bcsel(only_lower_16_bits_used)', 'c', ('extract_i16', 'a@32', 0), 'b') => ('bcsel', 'c', 'a', 'b')
 *    ('iadd(only_lower_16_bits_used)', ('i2i32', ('u2u16', 'a@32')), 'b') => ('iadd', 'a', 'b')
 *    ('iadd(only_lower_16_bits_used)', ('i2i32', ('i2i16', 'a@32')), 'b') => ('iadd', 'a', 'b')
 *    ('iadd(only_lower_16_bits_used)', ('extract_i16', 'a@32', 0), 'b') => ('iadd', 'a', 'b')
 *    ('imul(only_lower_16_bits_used)', ('i2i32', ('u2u16', 'a@32')), 'b') => ('imul', 'a', 'b')
 *    ('imul(only_lower_16_bits_used)', ('i2i32', ('i2i16', 'a@32')), 'b') => ('imul', 'a', 'b')
 *    ('imul(only_lower_16_bits_used)', ('extract_i16', 'a@32', 0), 'b') => ('imul', 'a', 'b')
 *    ('iand(only_lower_16_bits_used)', ('i2i32', ('u2u16', 'a@32')), 'b') => ('iand', 'a', 'b')
 *    ('iand(only_lower_16_bits_used)', ('i2i32', ('i2i16', 'a@32')), 'b') => ('iand', 'a', 'b')
 *    ('iand(only_lower_16_bits_used)', ('extract_i16', 'a@32', 0), 'b') => ('iand', 'a', 'b')
 *    ('ior(only_lower_16_bits_used)', ('i2i32', ('u2u16', 'a@32')), 'b') => ('ior', 'a', 'b')
 *    ('ior(only_lower_16_bits_used)', ('i2i32', ('i2i16', 'a@32')), 'b') => ('ior', 'a', 'b')
 *    ('ior(only_lower_16_bits_used)', ('extract_i16', 'a@32', 0), 'b') => ('ior', 'a', 'b')
 *    ('ixor(only_lower_16_bits_used)', ('i2i32', ('u2u16', 'a@32')), 'b') => ('ixor', 'a', 'b')
 *    ('ixor(only_lower_16_bits_used)', ('i2i32', ('i2i16', 'a@32')), 'b') => ('ixor', 'a', 'b')
 *    ('ixor(only_lower_16_bits_used)', ('extract_i16', 'a@32', 0), 'b') => ('ixor', 'a', 'b')
 *    ('ldexp@16', 'x', 'exp') => ('fmul', ('fmul', 'x', ('i2i16', ('ishl', ('iadd', ('ishr', ('imin', ('imax', 'exp', -30), 30), 1), 15), 10))), ('i2i16', ('ishl', ('iadd', ('isub', ('imin', ('imax', 'exp', -30), 30), ('ishr', ('imin', ('imax', 'exp', -30), 30), 1)), 15), 10)))
 *    ('ldexp@32', 'x', 'exp') => ('fmul', ('fmul', 'x', ('ishl', ('iadd', ('ishr', ('imin', ('imax', 'exp', -254), 254), 1), 127), 23)), ('ishl', ('iadd', ('isub', ('imin', ('imax', 'exp', -254), 254), ('ishr', ('imin', ('imax', 'exp', -254), 254), 1)), 127), 23))
 *    ('ldexp@64', 'x', 'exp') => ('fmul', ('fmul', 'x', ('pack_64_2x32_split', 0, ('ishl', ('iadd', ('ishr', ('imin', ('imax', 'exp', -2046), 2046), 1), 1023), 20))), ('pack_64_2x32_split', 0, ('ishl', ('iadd', ('isub', ('imin', ('imax', 'exp', -2046), 2046), ('ishr', ('imin', ('imax', 'exp', -2046), 2046), 1)), 1023), 20)))
 *    ('iadd(many-comm-expr)', ('iand', ('ishl', ('iadd', ('iand', ('ishl', ('iadd', ('iand', ('ishl', ('iadd', ('iand', ('ishl', ('iadd', ('ishl', 'x@32', 16), ('ushr', 'x@32', 16)), 1), 2863311530), ('iand', ('ushr', ('iadd', ('ishl', 'x@32', 16), ('ushr', 'x@32', 16)), 1), 1431655765)), 2), 3435973836), ('iand', ('ushr', ('iadd', ('iand', ('ishl', ('iadd', ('ishl', 'x@32', 16), ('ushr', 'x@32', 16)), 1), 2863311530), ('iand', ('ushr', ('iadd', ('ishl', 'x@32', 16), ('ushr', 'x@32', 16)), 1), 1431655765)), 2), 858993459)), 4), 4042322160), ('iand', ('ushr', ('iadd', ('iand', ('ishl', ('iadd', ('iand', ('ishl', ('iadd', ('ishl', 'x@32', 16), ('ushr', 'x@32', 16)), 1), 2863311530), ('iand', ('ushr', ('iadd', ('ishl', 'x@32', 16), ('ushr', 'x@32', 16)), 1), 1431655765)), 2), 3435973836), ('iand', ('ushr', ('iadd', ('iand', ('ishl', ('iadd', ('ishl', 'x@32', 16), ('ushr', 'x@32', 16)), 1), 2863311530), ('iand', ('ushr', ('iadd', ('ishl', 'x@32', 16), ('ushr', 'x@32', 16)), 1), 1431655765)), 2), 858993459)), 4), 252645135)), 8), 4278255360), ('iand', ('ushr', ('iadd', ('iand', ('ishl', ('iadd', ('iand', ('ishl', ('iadd', ('iand', ('ishl', ('iadd', ('ishl', 'x@32', 16), ('ushr', 'x@32', 16)), 1), 2863311530), ('iand', ('ushr', ('iadd', ('ishl', 'x@32', 16), ('ushr', 'x@32', 16)), 1), 1431655765)), 2), 3435973836), ('iand', ('ushr', ('iadd', ('iand', ('ishl', ('iadd', ('ishl', 'x@32', 16), ('ushr', 'x@32', 16)), 1), 2863311530), ('iand', ('ushr', ('iadd', ('ishl', 'x@32', 16), ('ushr', 'x@32', 16)), 1), 1431655765)), 2), 858993459)), 4), 4042322160), ('iand', ('ushr', ('iadd', ('iand', ('ishl', ('iadd', ('iand', ('ishl', ('iadd', ('ishl', 'x@32', 16), ('ushr', 'x@32', 16)), 1), 2863311530), ('iand', ('ushr', ('iadd', ('ishl', 'x@32', 16), ('ushr', 'x@32', 16)), 1), 1431655765)), 2), 3435973836), ('iand', ('ushr', ('iadd', ('iand', ('ishl', ('iadd', ('ishl', 'x@32', 16), ('ushr', 'x@32', 16)), 1), 2863311530), ('iand', ('ushr', ('iadd', ('ishl', 'x@32', 16), ('ushr', 'x@32', 16)), 1), 1431655765)), 2), 858993459)), 4), 252645135)), 8), 16711935)) => ('bitfield_reverse', 'x')
 *    ('ior(many-comm-expr)', ('ishl', ('iand', ('ior', ('ishl', ('iand', ('ior', ('ishl', ('iand', ('ior', ('ishl', ('iand', ('ior', ('ishl', 'x@32', 16), ('ushr', 'x@32', 16)), 16711935), 8), ('ushr', ('iand', ('ior', ('ishl', 'x@32', 16), ('ushr', 'x@32', 16)), 4278255360), 8)), 252645135), 4), ('ushr', ('iand', ('ior', ('ishl', ('iand', ('ior', ('ishl', 'x@32', 16), ('ushr', 'x@32', 16)), 16711935), 8), ('ushr', ('iand', ('ior', ('ishl', 'x@32', 16), ('ushr', 'x@32', 16)), 4278255360), 8)), 4042322160), 4)), 858993459), 2), ('ushr', ('iand', ('ior', ('ishl', ('iand', ('ior', ('ishl', ('iand', ('ior', ('ishl', 'x@32', 16), ('ushr', 'x@32', 16)), 16711935), 8), ('ushr', ('iand', ('ior', ('ishl', 'x@32', 16), ('ushr', 'x@32', 16)), 4278255360), 8)), 252645135), 4), ('ushr', ('iand', ('ior', ('ishl', ('iand', ('ior', ('ishl', 'x@32', 16), ('ushr', 'x@32', 16)), 16711935), 8), ('ushr', ('iand', ('ior', ('ishl', 'x@32', 16), ('ushr', 'x@32', 16)), 4278255360), 8)), 4042322160), 4)), 3435973836), 2)), 1431655765), 1), ('ushr', ('iand', ('ior', ('ishl', ('iand', ('ior', ('ishl', ('iand', ('ior', ('ishl', ('iand', ('ior', ('ishl', 'x@32', 16), ('ushr', 'x@32', 16)), 16711935), 8), ('ushr', ('iand', ('ior', ('ishl', 'x@32', 16), ('ushr', 'x@32', 16)), 4278255360), 8)), 252645135), 4), ('ushr', ('iand', ('ior', ('ishl', ('iand', ('ior', ('ishl', 'x@32', 16), ('ushr', 'x@32', 16)), 16711935), 8), ('ushr', ('iand', ('ior', ('ishl', 'x@32', 16), ('ushr', 'x@32', 16)), 4278255360), 8)), 4042322160), 4)), 858993459), 2), ('ushr', ('iand', ('ior', ('ishl', ('iand', ('ior', ('ishl', ('iand', ('ior', ('ishl', 'x@32', 16), ('ushr', 'x@32', 16)), 16711935), 8), ('ushr', ('iand', ('ior', ('ishl', 'x@32', 16), ('ushr', 'x@32', 16)), 4278255360), 8)), 252645135), 4), ('ushr', ('iand', ('ior', ('ishl', ('iand', ('ior', ('ishl', 'x@32', 16), ('ushr', 'x@32', 16)), 16711935), 8), ('ushr', ('iand', ('ior', ('ishl', 'x@32', 16), ('ushr', 'x@32', 16)), 4278255360), 8)), 4042322160), 4)), 3435973836), 2)), 2863311530), 1)) => ('bitfield_reverse', 'x')
 *    ('ior(many-comm-expr)', ('iand', ('ishl', ('ior', ('iand', ('ishl', ('ior', ('iand', ('ishl', ('ior', ('iand', ('ishl', ('ior', ('ishl', 'x@32', 16), ('ushr', 'x@32', 16)), 1), 2863311530), ('iand', ('ushr', ('ior', ('ishl', 'x@32', 16), ('ushr', 'x@32', 16)), 1), 1431655765)), 2), 3435973836), ('iand', ('ushr', ('ior', ('iand', ('ishl', ('ior', ('ishl', 'x@32', 16), ('ushr', 'x@32', 16)), 1), 2863311530), ('iand', ('ushr', ('ior', ('ishl', 'x@32', 16), ('ushr', 'x@32', 16)), 1), 1431655765)), 2), 858993459)), 4), 4042322160), ('iand', ('ushr', ('ior', ('iand', ('ishl', ('ior', ('iand', ('ishl', ('ior', ('ishl', 'x@32', 16), ('ushr', 'x@32', 16)), 1), 2863311530), ('iand', ('ushr', ('ior', ('ishl', 'x@32', 16), ('ushr', 'x@32', 16)), 1), 1431655765)), 2), 3435973836), ('iand', ('ushr', ('ior', ('iand', ('ishl', ('ior', ('ishl', 'x@32', 16), ('ushr', 'x@32', 16)), 1), 2863311530), ('iand', ('ushr', ('ior', ('ishl', 'x@32', 16), ('ushr', 'x@32', 16)), 1), 1431655765)), 2), 858993459)), 4), 252645135)), 8), 4278255360), ('iand', ('ushr', ('ior', ('iand', ('ishl', ('ior', ('iand', ('ishl', ('ior', ('iand', ('ishl', ('ior', ('ishl', 'x@32', 16), ('ushr', 'x@32', 16)), 1), 2863311530), ('iand', ('ushr', ('ior', ('ishl', 'x@32', 16), ('ushr', 'x@32', 16)), 1), 1431655765)), 2), 3435973836), ('iand', ('ushr', ('ior', ('iand', ('ishl', ('ior', ('ishl', 'x@32', 16), ('ushr', 'x@32', 16)), 1), 2863311530), ('iand', ('ushr', ('ior', ('ishl', 'x@32', 16), ('ushr', 'x@32', 16)), 1), 1431655765)), 2), 858993459)), 4), 4042322160), ('iand', ('ushr', ('ior', ('iand', ('ishl', ('ior', ('iand', ('ishl', ('ior', ('ishl', 'x@32', 16), ('ushr', 'x@32', 16)), 1), 2863311530), ('iand', ('ushr', ('ior', ('ishl', 'x@32', 16), ('ushr', 'x@32', 16)), 1), 1431655765)), 2), 3435973836), ('iand', ('ushr', ('ior', ('iand', ('ishl', ('ior', ('ishl', 'x@32', 16), ('ushr', 'x@32', 16)), 1), 2863311530), ('iand', ('ushr', ('ior', ('ishl', 'x@32', 16), ('ushr', 'x@32', 16)), 1), 1431655765)), 2), 858993459)), 4), 252645135)), 8), 16711935)) => ('bitfield_reverse', 'x')
 *    ('bcsel', ('iand', ('ine', ('fabs', 'x'), 2139095040), ('ieq', ('iand', ('pack_half_2x16_rtz_split', 'x', 0), 32767), 31744)), ('iadd', ('pack_half_2x16_rtz_split', 'x', 0), 4294967295), ('pack_half_2x16_rtz_split', 'x', 0)) => ('pack_half_2x16_rtz_split', 'x', 0)
 *    ('bcsel', ('iand', ('ine', 'x', 2139095040), ('ieq', ('iand', ('pack_half_2x16_rtz_split', 'x(is_not_negative)', 0), 32767), 31744)), ('iadd', ('pack_half_2x16_rtz_split', 'x(is_not_negative)', 0), 4294967295), ('pack_half_2x16_rtz_split', 'x(is_not_negative)', 0)) => ('pack_half_2x16_rtz_split', 'x', 0)
 *    ('bcsel', ('iand', ('ine', ('fabs', 'x'), 2139095040), ('ieq', ('iand', ('pack_half_2x16_rtz_split', ('fneg', 'x'), 0), 32767), 31744)), ('iadd', ('pack_half_2x16_rtz_split', ('fneg', 'x'), 0), 4294967295), ('pack_half_2x16_rtz_split', ('fneg', 'x'), 0)) => ('pack_half_2x16_rtz_split', ('fneg', 'x'), 0)
 *    ('iadd(many-comm-expr)', ('iadd', ('iadd', ('bcsel', ('ieq', ('extract_u8', 'a@32', 0), 0), 0, ('iabs', ('iadd', ('extract_u8', 'a@32', 0), ('ineg', ('extract_u8', 'b@32', 0))))), ('bcsel', ('ieq', ('extract_u8', 'a@32', 1), 0), 0, ('iabs', ('iadd', ('extract_u8', 'a@32', 1), ('ineg', ('extract_u8', 'b@32', 1)))))), ('bcsel', ('ieq', ('extract_u8', 'a@32', 2), 0), 0, ('iabs', ('iadd', ('extract_u8', 'a@32', 2), ('ineg', ('extract_u8', 'b@32', 2)))))), ('bcsel', ('ieq', ('extract_u8', 'a@32', 3), 0), 0, ('iabs', ('iadd', ('extract_u8', 'a@32', 3), ('ineg', ('extract_u8', 'b@32', 3)))))) => ('msad_4x8', 'a', 'b', 0)
 *    ('iadd', ('msad_4x8', 'a', 'b', 0), 'c') => ('msad_4x8', 'a', 'b', 'c')
 *    ('ball_iequal2', ('ieq', 'a', 'b'), -1) => ('ball_iequal2', 'a', 'b')
 *    ('ball_iequal2', ('feq', 'a', 'b'), -1) => ('ball_fequal2', 'a', 'b')
 *    ('bany_inequal2', ('ine', 'a', 'b'), 0) => ('bany_inequal2', 'a', 'b')
 *    ('bany_inequal2', ('fneu', 'a', 'b'), 0) => ('bany_fnequal2', 'a', 'b')
 *    ('ball_iequal3', ('ieq', 'a', 'b'), -1) => ('ball_iequal3', 'a', 'b')
 *    ('ball_iequal3', ('feq', 'a', 'b'), -1) => ('ball_fequal3', 'a', 'b')
 *    ('bany_inequal3', ('ine', 'a', 'b'), 0) => ('bany_inequal3', 'a', 'b')
 *    ('bany_inequal3', ('fneu', 'a', 'b'), 0) => ('bany_fnequal3', 'a', 'b')
 *    ('ball_iequal4', ('ieq', 'a', 'b'), -1) => ('ball_iequal4', 'a', 'b')
 *    ('ball_iequal4', ('feq', 'a', 'b'), -1) => ('ball_fequal4', 'a', 'b')
 *    ('bany_inequal4', ('ine', 'a', 'b'), 0) => ('bany_inequal4', 'a', 'b')
 *    ('bany_inequal4', ('fneu', 'a', 'b'), 0) => ('bany_fnequal4', 'a', 'b')
 *    ('ball_iequal8', ('ieq', 'a', 'b'), -1) => ('ball_iequal8', 'a', 'b')
 *    ('ball_iequal8', ('feq', 'a', 'b'), -1) => ('ball_fequal8', 'a', 'b')
 *    ('bany_inequal8', ('ine', 'a', 'b'), 0) => ('bany_inequal8', 'a', 'b')
 *    ('bany_inequal8', ('fneu', 'a', 'b'), 0) => ('bany_fnequal8', 'a', 'b')
 *    ('ball_iequal16', ('ieq', 'a', 'b'), -1) => ('ball_iequal16', 'a', 'b')
 *    ('ball_iequal16', ('feq', 'a', 'b'), -1) => ('ball_fequal16', 'a', 'b')
 *    ('bany_inequal16', ('ine', 'a', 'b'), 0) => ('bany_inequal16', 'a', 'b')
 *    ('bany_inequal16', ('fneu', 'a', 'b'), 0) => ('bany_fnequal16', 'a', 'b')
 *    ('iand', ('feq', 'a', 'a'), ('flt', 'a', 'b')) => ('!flt', 'a', 'b')
 *    ('iand', ('feq', 'a', 'a'), ('flt', 'b', 'a')) => ('!flt', 'b', 'a')
 *    ('iand', ('feq', 'a', 'a'), ('fge', 'a', 'b')) => ('!fge', 'a', 'b')
 *    ('iand', ('feq', 'a', 'a'), ('fge', 'b', 'a')) => ('!fge', 'b', 'a')
 *    ('iand', ('feq', 'a', 'a'), ('feq', 'a', 'b')) => ('!feq', 'a', 'b')
 *    ('iand', ('feq', 'a', 'a'), ('feq', 'b', 'a')) => ('!feq', 'b', 'a')
 *    ('feq', ('bcsel', 'a', '#b', '#c'), '#d') => ('bcsel', 'a', ('feq', 'b', 'd'), ('feq', 'c', 'd'))
 *    ('fneu', ('bcsel', 'a', '#b', '#c'), '#d') => ('bcsel', 'a', ('fneu', 'b', 'd'), ('fneu', 'c', 'd'))
 *    ('ieq', ('bcsel', 'a', '#b', '#c'), '#d') => ('bcsel', 'a', ('ieq', 'b', 'd'), ('ieq', 'c', 'd'))
 *    ('ine', ('bcsel', 'a', '#b', '#c'), '#d') => ('bcsel', 'a', ('ine', 'b', 'd'), ('ine', 'c', 'd'))
 *    ('flt', ('bcsel', 'a', '#b', '#c'), '#d') => ('bcsel', 'a', ('flt', 'b', 'd'), ('flt', 'c', 'd'))
 *    ('flt', '#d', ('bcsel', 'a', '#b', '#c')) => ('bcsel', 'a', ('flt', 'd', 'b'), ('flt', 'd', 'c'))
 *    ('fge', ('bcsel', 'a', '#b', '#c'), '#d') => ('bcsel', 'a', ('fge', 'b', 'd'), ('fge', 'c', 'd'))
 *    ('fge', '#d', ('bcsel', 'a', '#b', '#c')) => ('bcsel', 'a', ('fge', 'd', 'b'), ('fge', 'd', 'c'))
 *    ('ilt', ('bcsel', 'a', '#b', '#c'), '#d') => ('bcsel', 'a', ('ilt', 'b', 'd'), ('ilt', 'c', 'd'))
 *    ('ilt', '#d', ('bcsel', 'a', '#b', '#c')) => ('bcsel', 'a', ('ilt', 'd', 'b'), ('ilt', 'd', 'c'))
 *    ('ige', ('bcsel', 'a', '#b', '#c'), '#d') => ('bcsel', 'a', ('ige', 'b', 'd'), ('ige', 'c', 'd'))
 *    ('ige', '#d', ('bcsel', 'a', '#b', '#c')) => ('bcsel', 'a', ('ige', 'd', 'b'), ('ige', 'd', 'c'))
 *    ('ult', ('bcsel', 'a', '#b', '#c'), '#d') => ('bcsel', 'a', ('ult', 'b', 'd'), ('ult', 'c', 'd'))
 *    ('ult', '#d', ('bcsel', 'a', '#b', '#c')) => ('bcsel', 'a', ('ult', 'd', 'b'), ('ult', 'd', 'c'))
 *    ('uge', ('bcsel', 'a', '#b', '#c'), '#d') => ('bcsel', 'a', ('uge', 'b', 'd'), ('uge', 'c', 'd'))
 *    ('uge', '#d', ('bcsel', 'a', '#b', '#c')) => ('bcsel', 'a', ('uge', 'd', 'b'), ('uge', 'd', 'c'))
 *    ('fadd', ('bcsel(is_used_once)', 'a', '#b', 'c'), '#d') => ('bcsel', 'a', ('fadd', 'b', 'd'), ('fadd', 'c', 'd'))
 *    ('fmul', ('bcsel(is_used_once)', 'a', '#b', 'c'), '#d') => ('bcsel', 'a', ('fmul', 'b', 'd'), ('fmul', 'c', 'd'))
 *    ('fmulz', ('bcsel(is_used_once)', 'a', '#b', 'c'), '#d') => ('bcsel', 'a', ('fmulz', 'b', 'd'), ('fmulz', 'c', 'd'))
 *    ('iadd', ('bcsel(is_used_once)', 'a', '#b', 'c'), '#d') => ('bcsel', 'a', ('iadd', 'b', 'd'), ('iadd', 'c', 'd'))
 *    ('imul', ('bcsel(is_used_once)', 'a', '#b', 'c'), '#d') => ('bcsel', 'a', ('imul', 'b', 'd'), ('imul', 'c', 'd'))
 *    ('umul_low', '#a(is_lower_half_zero)', 'b') => 0
 *    ('imadsh_mix16', '#a@32(is_lower_half_zero)', 'b@32', 'c@32') => c
 *    ('imadsh_mix16', 'a@32', '#b@32(is_upper_half_zero)', 'c@32') => c
 *    ('bcsel', 'a', ('flrp(is_used_once)', 'b', 'c', 'd'), ('flrp', 'b', 'c', 'e')) => ('flrp', 'b', 'c', ('bcsel', 'a', 'd', 'e'))
 *    ('bcsel', 'a', ('flrp', 'b', 'c', 'd'), ('flrp(is_used_once)', 'b', 'c', 'e')) => ('flrp', 'b', 'c', ('bcsel', 'a', 'd', 'e'))
 *    ('bcsel', 'a', ('flrp(is_used_once)', 'b', 'c', 'd'), ('flrp', 'b', 'e', 'd')) => ('flrp', 'b', ('bcsel', 'a', 'c', 'e'), 'd')
 *    ('bcsel', 'a', ('flrp', 'b', 'c', 'd'), ('flrp(is_used_once)', 'b', 'e', 'd')) => ('flrp', 'b', ('bcsel', 'a', 'c', 'e'), 'd')
 *    ('bcsel', 'a', ('flrp(is_used_once)', 'b', 'c', 'd'), ('flrp', 'e', 'c', 'd')) => ('flrp', ('bcsel', 'a', 'b', 'e'), 'c', 'd')
 *    ('bcsel', 'a', ('flrp', 'b', 'c', 'd'), ('flrp(is_used_once)', 'e', 'c', 'd')) => ('flrp', ('bcsel', 'a', 'b', 'e'), 'c', 'd')
 *    ('bcsel', 'a', ('fmulz(is_used_once)', 'b', 'c'), ('fmulz', 'b', 'd(is_not_const)')) => ('fmulz', 'b', ('bcsel', 'a', 'c', 'd'))
 *    ('bcsel', 'a', ('fmulz(is_used_once)', 'b', 'c(is_not_const)'), ('fmulz', 'b', 'd')) => ('fmulz', 'b', ('bcsel', 'a', 'c', 'd'))
 *    ('bcsel', 'a', ('fmulz', 'b', 'c(is_not_const)'), ('fmulz(is_used_once)', 'b', 'd')) => ('fmulz', 'b', ('bcsel', 'a', 'c', 'd'))
 *    ('bcsel', 'a', ('fmulz', 'b', 'c'), ('fmulz(is_used_once)', 'b', 'd(is_not_const)')) => ('fmulz', 'b', ('bcsel', 'a', 'c', 'd'))
 *    ('bcsel', 'a', ('fmul(is_used_once)', 'b', 'c'), ('fmul', 'b', 'd(is_not_const)')) => ('fmul', 'b', ('bcsel', 'a', 'c', 'd'))
 *    ('bcsel', 'a', ('fmul(is_used_once)', 'b', 'c(is_not_const)'), ('fmul', 'b', 'd')) => ('fmul', 'b', ('bcsel', 'a', 'c', 'd'))
 *    ('bcsel', 'a', ('fmul', 'b', 'c(is_not_const)'), ('fmul(is_used_once)', 'b', 'd')) => ('fmul', 'b', ('bcsel', 'a', 'c', 'd'))
 *    ('bcsel', 'a', ('fmul', 'b', 'c'), ('fmul(is_used_once)', 'b', 'd(is_not_const)')) => ('fmul', 'b', ('bcsel', 'a', 'c', 'd'))
 *    ('bcsel', 'a', ('iadd(is_used_once)', 'b', 'c'), ('iadd', 'b', 'd(is_not_const)')) => ('iadd', 'b', ('bcsel', 'a', 'c', 'd'))
 *    ('bcsel', 'a', ('iadd(is_used_once)', 'b', 'c(is_not_const)'), ('iadd', 'b', 'd')) => ('iadd', 'b', ('bcsel', 'a', 'c', 'd'))
 *    ('bcsel', 'a', ('iadd', 'b', 'c(is_not_const)'), ('iadd(is_used_once)', 'b', 'd')) => ('iadd', 'b', ('bcsel', 'a', 'c', 'd'))
 *    ('bcsel', 'a', ('iadd', 'b', 'c'), ('iadd(is_used_once)', 'b', 'd(is_not_const)')) => ('iadd', 'b', ('bcsel', 'a', 'c', 'd'))
 *    ('bcsel', 'a', ('imul(is_used_once)', 'b', 'c'), ('imul', 'b', 'd(is_not_const)')) => ('imul', 'b', ('bcsel', 'a', 'c', 'd'))
 *    ('bcsel', 'a', ('imul(is_used_once)', 'b', 'c(is_not_const)'), ('imul', 'b', 'd')) => ('imul', 'b', ('bcsel', 'a', 'c', 'd'))
 *    ('bcsel', 'a', ('imul', 'b', 'c(is_not_const)'), ('imul(is_used_once)', 'b', 'd')) => ('imul', 'b', ('bcsel', 'a', 'c', 'd'))
 *    ('bcsel', 'a', ('imul', 'b', 'c'), ('imul(is_used_once)', 'b', 'd(is_not_const)')) => ('imul', 'b', ('bcsel', 'a', 'c', 'd'))
 *    ('bcsel', 'a', ('iand(is_used_once)', 'b', 'c'), ('iand', 'b', 'd(is_not_const)')) => ('iand', 'b', ('bcsel', 'a', 'c', 'd'))
 *    ('bcsel', 'a', ('iand(is_used_once)', 'b', 'c(is_not_const)'), ('iand', 'b', 'd')) => ('iand', 'b', ('bcsel', 'a', 'c', 'd'))
 *    ('bcsel', 'a', ('iand', 'b', 'c(is_not_const)'), ('iand(is_used_once)', 'b', 'd')) => ('iand', 'b', ('bcsel', 'a', 'c', 'd'))
 *    ('bcsel', 'a', ('iand', 'b', 'c'), ('iand(is_used_once)', 'b', 'd(is_not_const)')) => ('iand', 'b', ('bcsel', 'a', 'c', 'd'))
 *    ('bcsel', 'a', ('ior(is_used_once)', 'b', 'c'), ('ior', 'b', 'd(is_not_const)')) => ('ior', 'b', ('bcsel', 'a', 'c', 'd'))
 *    ('bcsel', 'a', ('ior(is_used_once)', 'b', 'c(is_not_const)'), ('ior', 'b', 'd')) => ('ior', 'b', ('bcsel', 'a', 'c', 'd'))
 *    ('bcsel', 'a', ('ior', 'b', 'c(is_not_const)'), ('ior(is_used_once)', 'b', 'd')) => ('ior', 'b', ('bcsel', 'a', 'c', 'd'))
 *    ('bcsel', 'a', ('ior', 'b', 'c'), ('ior(is_used_once)', 'b', 'd(is_not_const)')) => ('ior', 'b', ('bcsel', 'a', 'c', 'd'))
 *    ('bcsel', 'a', ('ixor(is_used_once)', 'b', 'c'), ('ixor', 'b', 'd(is_not_const)')) => ('ixor', 'b', ('bcsel', 'a', 'c', 'd'))
 *    ('bcsel', 'a', ('ixor(is_used_once)', 'b', 'c(is_not_const)'), ('ixor', 'b', 'd')) => ('ixor', 'b', ('bcsel', 'a', 'c', 'd'))
 *    ('bcsel', 'a', ('ixor', 'b', 'c(is_not_const)'), ('ixor(is_used_once)', 'b', 'd')) => ('ixor', 'b', ('bcsel', 'a', 'c', 'd'))
 *    ('bcsel', 'a', ('ixor', 'b', 'c'), ('ixor(is_used_once)', 'b', 'd(is_not_const)')) => ('ixor', 'b', ('bcsel', 'a', 'c', 'd'))
 *    ('bcsel', 'a', ('fmin(is_used_once)', 'b', 'c'), ('fmin', 'b', 'd(is_not_const)')) => ('fmin', 'b', ('bcsel', 'a', 'c', 'd'))
 *    ('bcsel', 'a', ('fmin(is_used_once)', 'b', 'c(is_not_const)'), ('fmin', 'b', 'd')) => ('fmin', 'b', ('bcsel', 'a', 'c', 'd'))
 *    ('bcsel', 'a', ('fmin', 'b', 'c(is_not_const)'), ('fmin(is_used_once)', 'b', 'd')) => ('fmin', 'b', ('bcsel', 'a', 'c', 'd'))
 *    ('bcsel', 'a', ('fmin', 'b', 'c'), ('fmin(is_used_once)', 'b', 'd(is_not_const)')) => ('fmin', 'b', ('bcsel', 'a', 'c', 'd'))
 *    ('bcsel', 'a', ('fmax(is_used_once)', 'b', 'c'), ('fmax', 'b', 'd(is_not_const)')) => ('fmax', 'b', ('bcsel', 'a', 'c', 'd'))
 *    ('bcsel', 'a', ('fmax(is_used_once)', 'b', 'c(is_not_const)'), ('fmax', 'b', 'd')) => ('fmax', 'b', ('bcsel', 'a', 'c', 'd'))
 *    ('bcsel', 'a', ('fmax', 'b', 'c(is_not_const)'), ('fmax(is_used_once)', 'b', 'd')) => ('fmax', 'b', ('bcsel', 'a', 'c', 'd'))
 *    ('bcsel', 'a', ('fmax', 'b', 'c'), ('fmax(is_used_once)', 'b', 'd(is_not_const)')) => ('fmax', 'b', ('bcsel', 'a', 'c', 'd'))
 *    ('bcsel', 'a', ('imin(is_used_once)', 'b', 'c'), ('imin', 'b', 'd(is_not_const)')) => ('imin', 'b', ('bcsel', 'a', 'c', 'd'))
 *    ('bcsel', 'a', ('imin(is_used_once)', 'b', 'c(is_not_const)'), ('imin', 'b', 'd')) => ('imin', 'b', ('bcsel', 'a', 'c', 'd'))
 *    ('bcsel', 'a', ('imin', 'b', 'c(is_not_const)'), ('imin(is_used_once)', 'b', 'd')) => ('imin', 'b', ('bcsel', 'a', 'c', 'd'))
 *    ('bcsel', 'a', ('imin', 'b', 'c'), ('imin(is_used_once)', 'b', 'd(is_not_const)')) => ('imin', 'b', ('bcsel', 'a', 'c', 'd'))
 *    ('bcsel', 'a', ('imax(is_used_once)', 'b', 'c'), ('imax', 'b', 'd(is_not_const)')) => ('imax', 'b', ('bcsel', 'a', 'c', 'd'))
 *    ('bcsel', 'a', ('imax(is_used_once)', 'b', 'c(is_not_const)'), ('imax', 'b', 'd')) => ('imax', 'b', ('bcsel', 'a', 'c', 'd'))
 *    ('bcsel', 'a', ('imax', 'b', 'c(is_not_const)'), ('imax(is_used_once)', 'b', 'd')) => ('imax', 'b', ('bcsel', 'a', 'c', 'd'))
 *    ('bcsel', 'a', ('imax', 'b', 'c'), ('imax(is_used_once)', 'b', 'd(is_not_const)')) => ('imax', 'b', ('bcsel', 'a', 'c', 'd'))
 *    ('bcsel', 'a', ('umin(is_used_once)', 'b', 'c'), ('umin', 'b', 'd(is_not_const)')) => ('umin', 'b', ('bcsel', 'a', 'c', 'd'))
 *    ('bcsel', 'a', ('umin(is_used_once)', 'b', 'c(is_not_const)'), ('umin', 'b', 'd')) => ('umin', 'b', ('bcsel', 'a', 'c', 'd'))
 *    ('bcsel', 'a', ('umin', 'b', 'c(is_not_const)'), ('umin(is_used_once)', 'b', 'd')) => ('umin', 'b', ('bcsel', 'a', 'c', 'd'))
 *    ('bcsel', 'a', ('umin', 'b', 'c'), ('umin(is_used_once)', 'b', 'd(is_not_const)')) => ('umin', 'b', ('bcsel', 'a', 'c', 'd'))
 *    ('bcsel', 'a', ('umax(is_used_once)', 'b', 'c'), ('umax', 'b', 'd(is_not_const)')) => ('umax', 'b', ('bcsel', 'a', 'c', 'd'))
 *    ('bcsel', 'a', ('umax(is_used_once)', 'b', 'c(is_not_const)'), ('umax', 'b', 'd')) => ('umax', 'b', ('bcsel', 'a', 'c', 'd'))
 *    ('bcsel', 'a', ('umax', 'b', 'c(is_not_const)'), ('umax(is_used_once)', 'b', 'd')) => ('umax', 'b', ('bcsel', 'a', 'c', 'd'))
 *    ('bcsel', 'a', ('umax', 'b', 'c'), ('umax(is_used_once)', 'b', 'd(is_not_const)')) => ('umax', 'b', ('bcsel', 'a', 'c', 'd'))
 *    ('bcsel', 'a', ('fpow(is_used_once)', 'b', 'c'), ('fpow', 'b', 'd')) => ('fpow', 'b', ('bcsel', 'a', 'c', 'd'))
 *    ('bcsel', 'a', ('fpow', 'b', 'c'), ('fpow(is_used_once)', 'b', 'd')) => ('fpow', 'b', ('bcsel', 'a', 'c', 'd'))
 *    ('bcsel', 'a', ('fpow(is_used_once)', 'b', 'c'), ('fpow', 'd', 'c')) => ('fpow', ('bcsel', 'a', 'b', 'd'), 'c')
 *    ('bcsel', 'a', ('fpow', 'b', 'c'), ('fpow(is_used_once)', 'd', 'c')) => ('fpow', ('bcsel', 'a', 'b', 'd'), 'c')
 *    ('bcsel', 'c', ('frcp(is_used_once)', 'a'), ('frcp(is_used_once)', 'b')) => ('frcp', ('bcsel', 'c', 'a', 'b'))
 *    ('bcsel', 'c', ('frsq(is_used_once)', 'a'), ('frsq(is_used_once)', 'b')) => ('frsq', ('bcsel', 'c', 'a', 'b'))
 *    ('bcsel', 'c', ('fsqrt(is_used_once)', 'a'), ('fsqrt(is_used_once)', 'b')) => ('fsqrt', ('bcsel', 'c', 'a', 'b'))
 *    ('bcsel', 'c', ('fexp2(is_used_once)', 'a'), ('fexp2(is_used_once)', 'b')) => ('fexp2', ('bcsel', 'c', 'a', 'b'))
 *    ('bcsel', 'c', ('flog2(is_used_once)', 'a'), ('flog2(is_used_once)', 'b')) => ('flog2', ('bcsel', 'c', 'a', 'b'))
 *    ('bcsel', 'c', ('fsign(is_used_once)', 'a'), ('fsign(is_used_once)', 'b')) => ('fsign', ('bcsel', 'c', 'a', 'b'))
 *    ('bcsel', 'c', ('fsin(is_used_once)', 'a'), ('fsin(is_used_once)', 'b')) => ('fsin', ('bcsel', 'c', 'a', 'b'))
 *    ('bcsel', 'c', ('fcos(is_used_once)', 'a'), ('fcos(is_used_once)', 'b')) => ('fcos', ('bcsel', 'c', 'a', 'b'))
 *    ('bcsel', 'c', ('fsin_amd(is_used_once)', 'a'), ('fsin_amd(is_used_once)', 'b')) => ('fsin_amd', ('bcsel', 'c', 'a', 'b'))
 *    ('bcsel', 'c', ('fcos_amd(is_used_once)', 'a'), ('fcos_amd(is_used_once)', 'b')) => ('fcos_amd', ('bcsel', 'c', 'a', 'b'))
 *    ('bcsel', 'c', ('fsin_mdg(is_used_once)', 'a'), ('fsin_mdg(is_used_once)', 'b')) => ('fsin_mdg', ('bcsel', 'c', 'a', 'b'))
 *    ('bcsel', 'c', ('fcos_mdg(is_used_once)', 'a'), ('fcos_mdg(is_used_once)', 'b')) => ('fcos_mdg', ('bcsel', 'c', 'a', 'b'))
 *    ('bcsel', 'c', ('fsin_agx(is_used_once)', 'a'), ('fsin_agx(is_used_once)', 'b')) => ('fsin_agx', ('bcsel', 'c', 'a', 'b'))
 *    ('bcsel', 'c', ('fneg(is_used_once)', 'a'), ('fneg(is_used_once)', 'b')) => ('fneg', ('bcsel', 'c', 'a', 'b'))
 *    ('bcsel', 'c', ('fabs(is_used_once)', 'a'), ('fabs(is_used_once)', 'b')) => ('fabs', ('bcsel', 'c', 'a', 'b'))
 *    ('bcsel', 'c', ('fsign(is_used_once)', 'a'), ('fsign(is_used_once)', 'b')) => ('fsign', ('bcsel', 'c', 'a', 'b'))
 *    ('ineg', ('bcsel', 'c', '#a', '#b')) => ('bcsel', 'c', ('ineg', 'a'), ('ineg', 'b'))
 *    ('iabs', ('bcsel', 'c', '#a', '#b')) => ('bcsel', 'c', ('iabs', 'a'), ('iabs', 'b'))
 *    ('inot', ('bcsel', 'c', '#a', '#b')) => ('bcsel', 'c', ('inot', 'a'), ('inot', 'b'))
 *    ('isign', ('bcsel', 'c', '#a', '#b')) => ('bcsel', 'c', ('isign', 'a'), ('isign', 'b'))
 *    ('fisnormal', 'a@16') => ('ult', 4095, ('iadd', ('ishl', 'a', 1), 2048))
 *    ('fisnormal', 'a@32') => ('ult', 33554431, ('iadd', ('ishl', 'a', 1), 16777216))
 *    ('fisnormal', 'a@64') => ('ult', 18014398509481983, ('iadd', ('ishl', 'a', 1), 9007199254740992))
 *    ('fquantize2f16', 'a@32') => ('bcsel', ('!flt', ('!fabs', 'a'), 6.103515625e-05), ('iand', 'a', 2147483648), ('!f2f32', ('!f2f16_rtne', 'a')))
 *    ('bfi', 4294967295, 'a', '#b') => ('iadd', ('ishl', 'a', 0), ('iand', 'b', -4294967296))
 *    ('bfi', 8589934590, 'a', '#b') => ('iadd', ('ishl', 'a', 1), ('iand', 'b', -8589934591))
 *    ('bfi', 17179869180, 'a', '#b') => ('iadd', ('ishl', 'a', 2), ('iand', 'b', -17179869181))
 *    ('bfi', 34359738360, 'a', '#b') => ('iadd', ('ishl', 'a', 3), ('iand', 'b', -34359738361))
 *    ('bfi', 68719476720, 'a', '#b') => ('iadd', ('ishl', 'a', 4), ('iand', 'b', -68719476721))
 *    ('bfi', 137438953440, 'a', '#b') => ('iadd', ('ishl', 'a', 5), ('iand', 'b', -137438953441))
 *    ('bfi', 274877906880, 'a', '#b') => ('iadd', ('ishl', 'a', 6), ('iand', 'b', -274877906881))
 *    ('bfi', 549755813760, 'a', '#b') => ('iadd', ('ishl', 'a', 7), ('iand', 'b', -549755813761))
 *    ('bfi', 1099511627520, 'a', '#b') => ('iadd', ('ishl', 'a', 8), ('iand', 'b', -1099511627521))
 *    ('bfi', 2199023255040, 'a', '#b') => ('iadd', ('ishl', 'a', 9), ('iand', 'b', -2199023255041))
 *    ('bfi', 4398046510080, 'a', '#b') => ('iadd', ('ishl', 'a', 10), ('iand', 'b', -4398046510081))
 *    ('bfi', 8796093020160, 'a', '#b') => ('iadd', ('ishl', 'a', 11), ('iand', 'b', -8796093020161))
 *    ('bfi', 17592186040320, 'a', '#b') => ('iadd', ('ishl', 'a', 12), ('iand', 'b', -17592186040321))
 *    ('bfi', 35184372080640, 'a', '#b') => ('iadd', ('ishl', 'a', 13), ('iand', 'b', -35184372080641))
 *    ('bfi', 70368744161280, 'a', '#b') => ('iadd', ('ishl', 'a', 14), ('iand', 'b', -70368744161281))
 *    ('bfi', 140737488322560, 'a', '#b') => ('iadd', ('ishl', 'a', 15), ('iand', 'b', -140737488322561))
 *    ('bfi', 281474976645120, 'a', '#b') => ('iadd', ('ishl', 'a', 16), ('iand', 'b', -281474976645121))
 *    ('bfi', 562949953290240, 'a', '#b') => ('iadd', ('ishl', 'a', 17), ('iand', 'b', -562949953290241))
 *    ('bfi', 1125899906580480, 'a', '#b') => ('iadd', ('ishl', 'a', 18), ('iand', 'b', -1125899906580481))
 *    ('bfi', 2251799813160960, 'a', '#b') => ('iadd', ('ishl', 'a', 19), ('iand', 'b', -2251799813160961))
 *    ('bfi', 4503599626321920, 'a', '#b') => ('iadd', ('ishl', 'a', 20), ('iand', 'b', -4503599626321921))
 *    ('bfi', 9007199252643840, 'a', '#b') => ('iadd', ('ishl', 'a', 21), ('iand', 'b', -9007199252643841))
 *    ('bfi', 18014398505287680, 'a', '#b') => ('iadd', ('ishl', 'a', 22), ('iand', 'b', -18014398505287681))
 *    ('bfi', 36028797010575360, 'a', '#b') => ('iadd', ('ishl', 'a', 23), ('iand', 'b', -36028797010575361))
 *    ('bfi', 72057594021150720, 'a', '#b') => ('iadd', ('ishl', 'a', 24), ('iand', 'b', -72057594021150721))
 *    ('bfi', 144115188042301440, 'a', '#b') => ('iadd', ('ishl', 'a', 25), ('iand', 'b', -144115188042301441))
 *    ('bfi', 288230376084602880, 'a', '#b') => ('iadd', ('ishl', 'a', 26), ('iand', 'b', -288230376084602881))
 *    ('bfi', 576460752169205760, 'a', '#b') => ('iadd', ('ishl', 'a', 27), ('iand', 'b', -576460752169205761))
 *    ('bfi', 1152921504338411520, 'a', '#b') => ('iadd', ('ishl', 'a', 28), ('iand', 'b', -1152921504338411521))
 *    ('bfi', 2305843008676823040, 'a', '#b') => ('iadd', ('ishl', 'a', 29), ('iand', 'b', -2305843008676823041))
 *    ('bfi', 4611686017353646080, 'a', '#b') => ('iadd', ('ishl', 'a', 30), ('iand', 'b', -4611686017353646081))
 *    ('fadd', '#a(is_nan)', 'b') => nan
 *    ('fadd', 'a', '#b(is_nan)') => nan
 *    ('fdiv', '#a(is_nan)', 'b') => nan
 *    ('fdiv', 'a', '#b(is_nan)') => nan
 *    ('fmod', '#a(is_nan)', 'b') => nan
 *    ('fmod', 'a', '#b(is_nan)') => nan
 *    ('fmul', '#a(is_nan)', 'b') => nan
 *    ('fmul', 'a', '#b(is_nan)') => nan
 *    ('fpow', '#a(is_nan)', 'b') => nan
 *    ('fpow', 'a', '#b(is_nan)') => nan
 *    ('frem', '#a(is_nan)', 'b') => nan
 *    ('frem', 'a', '#b(is_nan)') => nan
 *    ('fsub', '#a(is_nan)', 'b') => nan
 *    ('fsub', 'a', '#b(is_nan)') => nan
 *    ('ffma', '#a(is_nan)', 'b', 'c') => nan
 *    ('ffma', 'a', '#b(is_nan)', 'c') => nan
 *    ('ffma', 'a', 'b', '#c(is_nan)') => nan
 *    ('flrp', '#a(is_nan)', 'b', 'c') => nan
 *    ('flrp', 'a', '#b(is_nan)', 'c') => nan
 *    ('flrp', 'a', 'b', '#c(is_nan)') => nan
 *    ('fmin', '#a(is_nan)', 'b') => b
 *    ('fmax', '#a(is_nan)', 'b') => b
 *    ('ldexp', '#a(is_nan)', 'b') => nan
 *    ('fdot2', '#a(is_any_comp_nan)', 'b') => nan
 *    ('fdot3', '#a(is_any_comp_nan)', 'b') => nan
 *    ('fdot4', '#a(is_any_comp_nan)', 'b') => nan
 *    ('fdot5', '#a(is_any_comp_nan)', 'b') => nan
 *    ('fdot8', '#a(is_any_comp_nan)', 'b') => nan
 *    ('fdot16', '#a(is_any_comp_nan)', 'b') => nan
 *    ('feq', '#a(is_nan)', 'b') => False
 *    ('feq', 'a', '#b(is_nan)') => False
 *    ('fge', '#a(is_nan)', 'b') => False
 *    ('fge', 'a', '#b(is_nan)') => False
 *    ('flt', '#a(is_nan)', 'b') => False
 *    ('flt', 'a', '#b(is_nan)') => False
 *    ('fneu', '#a(is_nan)', 'b') => True
 *    ('seq', '#a(is_nan)', 'b') => 0.0
 *    ('seq', 'a', '#b(is_nan)') => 0.0
 *    ('sge', '#a(is_nan)', 'b') => 0.0
 *    ('sge', 'a', '#b(is_nan)') => 0.0
 *    ('slt', '#a(is_nan)', 'b') => 0.0
 *    ('slt', 'a', '#b(is_nan)') => 0.0
 *    ('sne', '#a(is_nan)', 'b') => 1.0
 *    ('f2f16', ('vec2', 'a@32', 'b@32')) => ('vec2', ('f2f16', 'a'), ('f2f16', 'b'))
 *    ('f2fmp', ('vec2', 'a@32', 'b@32')) => ('vec2', ('f2fmp', 'a'), ('f2fmp', 'b'))
 *    ('u2u16', ('vec2', 'a@32', 'b@32')) => ('vec2', ('u2u16', 'a'), ('u2u16', 'b'))
 *    ('i2i16', ('vec2', 'a@32', 'b@32')) => ('vec2', ('i2i16', 'a'), ('i2i16', 'b'))
 *    ('i2imp', ('vec2', 'a@32', 'b@32')) => ('vec2', ('i2imp', 'a'), ('i2imp', 'b'))
 *    ('f2f16', ('vec3', 'a@32', 'b@32', 'c@32')) => ('vec3', ('f2f16', 'a'), ('f2f16', 'b'), ('f2f16', 'c'))
 *    ('f2fmp', ('vec3', 'a@32', 'b@32', 'c@32')) => ('vec3', ('f2fmp', 'a'), ('f2fmp', 'b'), ('f2fmp', 'c'))
 *    ('u2u16', ('vec3', 'a@32', 'b@32', 'c@32')) => ('vec3', ('u2u16', 'a'), ('u2u16', 'b'), ('u2u16', 'c'))
 *    ('i2i16', ('vec3', 'a@32', 'b@32', 'c@32')) => ('vec3', ('i2i16', 'a'), ('i2i16', 'b'), ('i2i16', 'c'))
 *    ('i2imp', ('vec3', 'a@32', 'b@32', 'c@32')) => ('vec3', ('i2imp', 'a'), ('i2imp', 'b'), ('i2imp', 'c'))
 *    ('f2f16', ('vec4', 'a@32', 'b@32', 'c@32', 'd@32')) => ('vec4', ('f2f16', 'a'), ('f2f16', 'b'), ('f2f16', 'c'), ('f2f16', 'd'))
 *    ('f2fmp', ('vec4', 'a@32', 'b@32', 'c@32', 'd@32')) => ('vec4', ('f2fmp', 'a'), ('f2fmp', 'b'), ('f2fmp', 'c'), ('f2fmp', 'd'))
 *    ('u2u16', ('vec4', 'a@32', 'b@32', 'c@32', 'd@32')) => ('vec4', ('u2u16', 'a'), ('u2u16', 'b'), ('u2u16', 'c'), ('u2u16', 'd'))
 *    ('i2i16', ('vec4', 'a@32', 'b@32', 'c@32', 'd@32')) => ('vec4', ('i2i16', 'a'), ('i2i16', 'b'), ('i2i16', 'c'), ('i2i16', 'd'))
 *    ('i2imp', ('vec4', 'a@32', 'b@32', 'c@32', 'd@32')) => ('vec4', ('i2imp', 'a'), ('i2imp', 'b'), ('i2imp', 'c'), ('i2imp', 'd'))
 */


static const nir_search_value_union nir_opt_algebraic_values[] = {
   /* ('fgeu', 'a', 'b') => ('inot', ('flt', 'a', 'b')) */
   { .variable = {
      { nir_search_value_variable, -2 },
      0, /* a */
      false,
      nir_type_invalid,
      -1,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .variable = {
      { nir_search_value_variable, -2 },
      1, /* b */
      false,
      nir_type_invalid,
      -1,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fgeu,
      -1, 0,
      { 0, 1 },
      -1,
   } },

   /* replace0_0_0 -> 0 in the cache */
   /* replace0_0_1 -> 1 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_flt,
      -1, 0,
      { 0, 1 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_inot,
      -1, 0,
      { 3 },
      -1,
   } },

   /* ('fltu', 'a', 'b') => ('inot', ('fge', 'a', 'b')) */
   /* search1_0 -> 0 in the cache */
   /* search1_1 -> 1 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fltu,
      -1, 0,
      { 0, 1 },
      -1,
   } },

   /* replace1_0_0 -> 0 in the cache */
   /* replace1_0_1 -> 1 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fge,
      -1, 0,
      { 0, 1 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_inot,
      -1, 0,
      { 6 },
      -1,
   } },

   /* ('fneo', 0.0, 'a') => ('flt', 0.0, ('fabs', 'a')) */
   { .constant = {
      { nir_search_value_constant, -1 },
      nir_type_float, { 0x0ull /* 0.0 */ },
   } },
   { .variable = {
      { nir_search_value_variable, -1 },
      0, /* a */
      false,
      nir_type_invalid,
      -1,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fneo,
      0, 1,
      { 8, 9 },
      -1,
   } },

   /* replace2_0 -> 8 in the cache */
   /* replace2_1_0 -> 9 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fabs,
      -1, 0,
      { 9 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_flt,
      -1, 0,
      { 8, 11 },
      -1,
   } },

   /* ('fequ', 0.0, 'a') => ('inot', ('flt', 0.0, ('fabs', 'a'))) */
   /* search3_0 -> 8 in the cache */
   /* search3_1 -> 9 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fequ,
      0, 1,
      { 8, 9 },
      -1,
   } },

   /* replace3_0_0 -> 8 in the cache */
   /* replace3_0_1_0 -> 9 in the cache */
   /* replace3_0_1 -> 11 in the cache */
   /* replace3_0 -> 12 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_inot,
      -1, 0,
      { 12 },
      -1,
   } },

   /* ('imul', 'a', '#b(is_pos_power_of_two)') => ('ishl', 'a', ('find_lsb', 'b')) */
   /* search4_0 -> 0 in the cache */
   { .variable = {
      { nir_search_value_variable, -2 },
      1, /* b */
      true,
      nir_type_invalid,
      0,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_imul,
      0, 1,
      { 0, 15 },
      -1,
   } },

   /* replace4_0 -> 0 in the cache */
   /* replace4_1_0 -> 1 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_find_lsb,
      -1, 0,
      { 1 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ishl,
      -1, 0,
      { 0, 17 },
      -1,
   } },

   /* ('imul', 'a@8', 128) => ('ishl', 'a', 7) */
   { .variable = {
      { nir_search_value_variable, 8 },
      0, /* a */
      false,
      nir_type_invalid,
      -1,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .constant = {
      { nir_search_value_constant, 8 },
      nir_type_int, { 0x80ull /* 128 */ },
   } },
   { .expression = {
      { nir_search_value_expression, 8 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_imul,
      0, 1,
      { 19, 20 },
      -1,
   } },

   /* replace5_0 -> 19 in the cache */
   { .constant = {
      { nir_search_value_constant, 32 },
      nir_type_int, { 0x7ull /* 7 */ },
   } },
   { .expression = {
      { nir_search_value_expression, 8 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ishl,
      -1, 0,
      { 19, 22 },
      -1,
   } },

   /* ('imul', 'a@16', 32768) => ('ishl', 'a', 15) */
   { .variable = {
      { nir_search_value_variable, 16 },
      0, /* a */
      false,
      nir_type_invalid,
      -1,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .constant = {
      { nir_search_value_constant, 16 },
      nir_type_int, { 0x8000ull /* 32768 */ },
   } },
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_imul,
      0, 1,
      { 24, 25 },
      -1,
   } },

   /* replace6_0 -> 24 in the cache */
   { .constant = {
      { nir_search_value_constant, 32 },
      nir_type_int, { 0xfull /* 15 */ },
   } },
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ishl,
      -1, 0,
      { 24, 27 },
      -1,
   } },

   /* ('imul', 'a@32', 2147483648) => ('ishl', 'a', 31) */
   { .variable = {
      { nir_search_value_variable, 32 },
      0, /* a */
      false,
      nir_type_invalid,
      -1,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .constant = {
      { nir_search_value_constant, 32 },
      nir_type_int, { 0x80000000ull /* 2147483648 */ },
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_imul,
      0, 1,
      { 29, 30 },
      -1,
   } },

   /* replace7_0 -> 29 in the cache */
   { .constant = {
      { nir_search_value_constant, 32 },
      nir_type_int, { 0x1full /* 31 */ },
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ishl,
      -1, 0,
      { 29, 32 },
      -1,
   } },

   /* ('imul', 'a@64', 9223372036854775808) => ('ishl', 'a', 63) */
   { .variable = {
      { nir_search_value_variable, 64 },
      0, /* a */
      false,
      nir_type_invalid,
      -1,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .constant = {
      { nir_search_value_constant, 64 },
      nir_type_int, { 0x8000000000000000ull /* 9223372036854775808 */ },
   } },
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_imul,
      0, 1,
      { 34, 35 },
      -1,
   } },

   /* replace8_0 -> 34 in the cache */
   { .constant = {
      { nir_search_value_constant, 32 },
      nir_type_int, { 0x3full /* 63 */ },
   } },
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ishl,
      -1, 0,
      { 34, 37 },
      -1,
   } },

   /* ('imul', 'a', '#b(is_neg_power_of_two)') => ('ineg', ('ishl', 'a', ('find_lsb', ('iabs', 'b')))) */
   /* search9_0 -> 0 in the cache */
   { .variable = {
      { nir_search_value_variable, -2 },
      1, /* b */
      true,
      nir_type_invalid,
      1,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_imul,
      0, 1,
      { 0, 39 },
      -1,
   } },

   /* replace9_0_0 -> 0 in the cache */
   /* replace9_0_1_0_0 -> 1 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_iabs,
      -1, 0,
      { 1 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_find_lsb,
      -1, 0,
      { 41 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ishl,
      -1, 0,
      { 0, 42 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ineg,
      -1, 0,
      { 43 },
      -1,
   } },

   /* ('ishl', 'a', '#b') => ('imul', 'a', ('ishl', 1, 'b')) */
   /* search10_0 -> 9 in the cache */
   { .variable = {
      { nir_search_value_variable, 32 },
      1, /* b */
      true,
      nir_type_invalid,
      -1,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ishl,
      -1, 0,
      { 9, 45 },
      -1,
   } },

   /* replace10_0 -> 9 in the cache */
   { .constant = {
      { nir_search_value_constant, -1 },
      nir_type_int, { 0x1ull /* 1 */ },
   } },
   { .variable = {
      { nir_search_value_variable, 32 },
      1, /* b */
      false,
      nir_type_invalid,
      -1,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ishl,
      -1, 0,
      { 47, 48 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_imul,
      0, 1,
      { 9, 49 },
      -1,
   } },

   /* ('imul@64', 'a', '#b(is_bitcount2)') => ('iadd', ('ishl', 'a', ('ufind_msb', 'b')), ('ishl', 'a', ('find_lsb', 'b'))) */
   /* search11_0 -> 34 in the cache */
   { .variable = {
      { nir_search_value_variable, 64 },
      1, /* b */
      true,
      nir_type_invalid,
      2,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_imul,
      0, 1,
      { 34, 51 },
      -1,
   } },

   /* replace11_0_0 -> 34 in the cache */
   { .variable = {
      { nir_search_value_variable, 64 },
      1, /* b */
      false,
      nir_type_invalid,
      -1,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ufind_msb,
      -1, 0,
      { 53 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ishl,
      -1, 0,
      { 34, 54 },
      -1,
   } },
   /* replace11_1_0 -> 34 in the cache */
   /* replace11_1_1_0 -> 53 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_find_lsb,
      -1, 0,
      { 53 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ishl,
      -1, 0,
      { 34, 56 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_iadd,
      0, 1,
      { 55, 57 },
      -1,
   } },

   /* ('unpack_64_2x32_split_x', ('imul_2x32_64(is_used_once)', 'a', 'b')) => ('imul', 'a', 'b') */
   /* search12_0_0 -> 29 in the cache */
   /* search12_0_1 -> 48 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_imul_2x32_64,
      0, 1,
      { 29, 48 },
      0,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_unpack_64_2x32_split_x,
      -1, 1,
      { 59 },
      -1,
   } },

   /* replace12_0 -> 29 in the cache */
   /* replace12_1 -> 48 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_imul,
      0, 1,
      { 29, 48 },
      -1,
   } },

   /* ('unpack_64_2x32_split_x', ('umul_2x32_64(is_used_once)', 'a', 'b')) => ('imul', 'a', 'b') */
   /* search13_0_0 -> 29 in the cache */
   /* search13_0_1 -> 48 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_umul_2x32_64,
      0, 1,
      { 29, 48 },
      0,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_unpack_64_2x32_split_x,
      -1, 1,
      { 62 },
      -1,
   } },

   /* replace13_0 -> 29 in the cache */
   /* replace13_1 -> 48 in the cache */
   /* replace13 -> 61 in the cache */

   /* ('imul_2x32_64', 'a', 'b') => ('pack_64_2x32_split', ('imul', 'a', 'b'), ('imul_high', 'a', 'b')) */
   /* search14_0 -> 29 in the cache */
   /* search14_1 -> 48 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_imul_2x32_64,
      0, 1,
      { 29, 48 },
      -1,
   } },

   /* replace14_0_0 -> 29 in the cache */
   /* replace14_0_1 -> 48 in the cache */
   /* replace14_0 -> 61 in the cache */
   /* replace14_1_0 -> 29 in the cache */
   /* replace14_1_1 -> 48 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_imul_high,
      1, 1,
      { 29, 48 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_pack_64_2x32_split,
      -1, 2,
      { 61, 65 },
      -1,
   } },

   /* ('umul_2x32_64', 'a', 'b') => ('pack_64_2x32_split', ('imul', 'a', 'b'), ('umul_high', 'a', 'b')) */
   /* search15_0 -> 29 in the cache */
   /* search15_1 -> 48 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_umul_2x32_64,
      0, 1,
      { 29, 48 },
      -1,
   } },

   /* replace15_0_0 -> 29 in the cache */
   /* replace15_0_1 -> 48 in the cache */
   /* replace15_0 -> 61 in the cache */
   /* replace15_1_0 -> 29 in the cache */
   /* replace15_1_1 -> 48 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_umul_high,
      1, 1,
      { 29, 48 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_pack_64_2x32_split,
      -1, 2,
      { 61, 68 },
      -1,
   } },

   /* ('udiv', 'a', 1) => a */
   /* search16_0 -> 9 in the cache */
   /* search16_1 -> 47 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_udiv,
      -1, 0,
      { 9, 47 },
      -1,
   } },

   /* replace16 -> 9 in the cache */

   /* ('idiv', 'a', 1) => a */
   /* search17_0 -> 9 in the cache */
   /* search17_1 -> 47 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_idiv,
      -1, 0,
      { 9, 47 },
      -1,
   } },

   /* replace17 -> 9 in the cache */

   /* ('umod', 'a', 1) => 0 */
   /* search18_0 -> 9 in the cache */
   /* search18_1 -> 47 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_umod,
      -1, 0,
      { 9, 47 },
      -1,
   } },

   { .constant = {
      { nir_search_value_constant, -1 },
      nir_type_int, { 0x0ull /* 0 */ },
   } },

   /* ('imod', 'a', 1) => 0 */
   /* search19_0 -> 9 in the cache */
   /* search19_1 -> 47 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_imod,
      -1, 0,
      { 9, 47 },
      -1,
   } },

   /* replace19 -> 73 in the cache */

   /* ('imod', 'a', -1) => 0 */
   /* search20_0 -> 9 in the cache */
   { .constant = {
      { nir_search_value_constant, -1 },
      nir_type_int, { 0xffffffffffffffffull /* -1 */ },
   } },
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_imod,
      -1, 0,
      { 9, 75 },
      -1,
   } },

   /* replace20 -> 73 in the cache */

   /* ('irem', 'a', 1) => 0 */
   /* search21_0 -> 9 in the cache */
   /* search21_1 -> 47 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_irem,
      -1, 0,
      { 9, 47 },
      -1,
   } },

   /* replace21 -> 73 in the cache */

   /* ('irem', 'a', -1) => 0 */
   /* search22_0 -> 9 in the cache */
   /* search22_1 -> 75 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_irem,
      -1, 0,
      { 9, 75 },
      -1,
   } },

   /* replace22 -> 73 in the cache */

   /* ('udiv', 'a', '#b(is_pos_power_of_two)') => ('ushr', 'a', ('find_lsb', 'b')) */
   /* search23_0 -> 0 in the cache */
   /* search23_1 -> 15 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_udiv,
      -1, 0,
      { 0, 15 },
      -1,
   } },

   /* replace23_0 -> 0 in the cache */
   /* replace23_1_0 -> 1 in the cache */
   /* replace23_1 -> 17 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ushr,
      -1, 0,
      { 0, 17 },
      -1,
   } },

   /* ('idiv', 'a', '#b(is_pos_power_of_two)') => ('imul', ('isign', 'a'), ('ushr', ('iabs', 'a'), ('find_lsb', 'b'))) */
   /* search24_0 -> 0 in the cache */
   /* search24_1 -> 15 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_idiv,
      -1, 0,
      { 0, 15 },
      -1,
   } },

   /* replace24_0_0 -> 0 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_isign,
      -1, 0,
      { 0 },
      -1,
   } },
   /* replace24_1_0_0 -> 0 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_iabs,
      -1, 0,
      { 0 },
      -1,
   } },
   /* replace24_1_1_0 -> 1 in the cache */
   /* replace24_1_1 -> 17 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ushr,
      -1, 0,
      { 83, 17 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_imul,
      0, 1,
      { 82, 84 },
      -1,
   } },

   /* ('idiv', 'a', '#b(is_neg_power_of_two)') => ('ineg', ('imul', ('isign', 'a'), ('ushr', ('iabs', 'a'), ('find_lsb', ('iabs', 'b'))))) */
   /* search25_0 -> 0 in the cache */
   /* search25_1 -> 39 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_idiv,
      -1, 0,
      { 0, 39 },
      -1,
   } },

   /* replace25_0_0_0 -> 0 in the cache */
   /* replace25_0_0 -> 82 in the cache */
   /* replace25_0_1_0_0 -> 0 in the cache */
   /* replace25_0_1_0 -> 83 in the cache */
   /* replace25_0_1_1_0_0 -> 1 in the cache */
   /* replace25_0_1_1_0 -> 41 in the cache */
   /* replace25_0_1_1 -> 42 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ushr,
      -1, 0,
      { 83, 42 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_imul,
      0, 1,
      { 82, 87 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ineg,
      -1, 1,
      { 88 },
      -1,
   } },

   /* ('umod', 'a', '#b(is_pos_power_of_two)') => ('iand', 'a', ('isub', 'b', 1)) */
   /* search26_0 -> 0 in the cache */
   /* search26_1 -> 15 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_umod,
      -1, 0,
      { 0, 15 },
      -1,
   } },

   /* replace26_0 -> 0 in the cache */
   /* replace26_1_0 -> 1 in the cache */
   { .constant = {
      { nir_search_value_constant, -2 },
      nir_type_int, { 0x1ull /* 1 */ },
   } },
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_isub,
      -1, 0,
      { 1, 91 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_iand,
      0, 1,
      { 0, 92 },
      -1,
   } },

   /* ('imod', 'a', '#b(is_pos_power_of_two)') => ('iand', 'a', ('isub', 'b', 1)) */
   /* search27_0 -> 0 in the cache */
   /* search27_1 -> 15 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_imod,
      -1, 0,
      { 0, 15 },
      -1,
   } },

   /* replace27_0 -> 0 in the cache */
   /* replace27_1_0 -> 1 in the cache */
   /* replace27_1_1 -> 91 in the cache */
   /* replace27_1 -> 92 in the cache */
   /* replace27 -> 93 in the cache */

   /* ('imod', 'a', '#b(is_neg_power_of_two)') => ('bcsel', ('ieq', ('ior', 'a', 'b'), 'b'), 0, ('ior', 'a', 'b')) */
   /* search28_0 -> 0 in the cache */
   /* search28_1 -> 39 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_imod,
      -1, 0,
      { 0, 39 },
      -1,
   } },

   /* replace28_0_0_0 -> 0 in the cache */
   /* replace28_0_0_1 -> 1 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ior,
      1, 1,
      { 0, 1 },
      -1,
   } },
   /* replace28_0_1 -> 1 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ieq,
      0, 2,
      { 96, 1 },
      -1,
   } },
   { .constant = {
      { nir_search_value_constant, -2 },
      nir_type_int, { 0x0ull /* 0 */ },
   } },
   /* replace28_2_0 -> 0 in the cache */
   /* replace28_2_1 -> 1 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ior,
      2, 1,
      { 0, 1 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_bcsel,
      -1, 3,
      { 97, 98, 99 },
      -1,
   } },

   /* ('irem', 'a', '#b(is_pos_power_of_two)') => ('isub', 'a', ('iand', ('bcsel', ('ilt', 'a', 0), ('iadd', 'a', ('isub', 'b', 1)), 'a'), ('ineg', 'b'))) */
   /* search29_0 -> 0 in the cache */
   /* search29_1 -> 15 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_irem,
      -1, 0,
      { 0, 15 },
      -1,
   } },

   /* replace29_0 -> 0 in the cache */
   /* replace29_1_0_0_0 -> 0 in the cache */
   /* replace29_1_0_0_1 -> 98 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ilt,
      -1, 0,
      { 0, 98 },
      -1,
   } },
   /* replace29_1_0_1_0 -> 0 in the cache */
   /* replace29_1_0_1_1_0 -> 1 in the cache */
   /* replace29_1_0_1_1_1 -> 91 in the cache */
   /* replace29_1_0_1_1 -> 92 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_iadd,
      1, 1,
      { 0, 92 },
      -1,
   } },
   /* replace29_1_0_2 -> 0 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_bcsel,
      -1, 1,
      { 102, 103, 0 },
      -1,
   } },
   /* replace29_1_1_0 -> 1 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ineg,
      -1, 0,
      { 1 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_iand,
      0, 2,
      { 104, 105 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_isub,
      -1, 2,
      { 0, 106 },
      -1,
   } },

   /* ('irem', 'a', '#b(is_neg_power_of_two)') => ('irem', 'a', ('iabs', 'b')) */
   /* search30_0 -> 0 in the cache */
   /* search30_1 -> 39 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_irem,
      -1, 0,
      { 0, 39 },
      -1,
   } },

   /* replace30_0 -> 0 in the cache */
   /* replace30_1_0 -> 1 in the cache */
   /* replace30_1 -> 41 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_irem,
      -1, 0,
      { 0, 41 },
      -1,
   } },

   /* ('~fmul', ('fsign', 'a'), ('ffloor', ('fadd', ('fabs', 'a'), 0.5))) => ('ftrunc', ('fadd', 'a', ('fmul', ('fsign', 'a'), 0.5))) */
   /* search31_0_0 -> 9 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fsign,
      -1, 0,
      { 9 },
      -1,
   } },
   /* search31_1_0_0_0 -> 9 in the cache */
   /* search31_1_0_0 -> 11 in the cache */
   { .constant = {
      { nir_search_value_constant, -1 },
      nir_type_float, { 0x3fe0000000000000ull /* 0.5 */ },
   } },
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fadd,
      1, 1,
      { 11, 111 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ffloor,
      -1, 1,
      { 112 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -1 },
      true,
      false,
      false,
      false,
      false,
      false,
      nir_op_fmul,
      0, 2,
      { 110, 113 },
      -1,
   } },

   /* replace31_0_0 -> 9 in the cache */
   /* replace31_0_1_0_0 -> 9 in the cache */
   /* replace31_0_1_0 -> 110 in the cache */
   /* replace31_0_1_1 -> 111 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fmul,
      1, 1,
      { 110, 111 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fadd,
      0, 2,
      { 9, 115 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ftrunc,
      -1, 2,
      { 116 },
      -1,
   } },

   /* ('~fneg', ('fneg', 'a')) => a */
   /* search32_0_0 -> 9 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fneg,
      -1, 0,
      { 9 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -1 },
      true,
      false,
      false,
      false,
      false,
      false,
      nir_op_fneg,
      -1, 0,
      { 118 },
      -1,
   } },

   /* replace32 -> 9 in the cache */

   /* ('ineg', ('ineg', 'a')) => a */
   /* search33_0_0 -> 9 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ineg,
      -1, 0,
      { 9 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ineg,
      -1, 0,
      { 120 },
      -1,
   } },

   /* replace33 -> 9 in the cache */

   /* ('fabs', ('fneg', 'a')) => ('fabs', 'a') */
   /* search34_0_0 -> 9 in the cache */
   /* search34_0 -> 118 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fabs,
      -1, 0,
      { 118 },
      -1,
   } },

   /* replace34_0 -> 9 in the cache */
   /* replace34 -> 11 in the cache */

   /* ('fabs', ('u2f', 'a')) => ('u2f', 'a') */
   /* search35_0_0 -> 9 in the cache */
   { .expression = {
      { nir_search_value_expression, 0 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_search_op_u2f,
      -1, 0,
      { 9 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 0 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fabs,
      -1, 0,
      { 123 },
      -1,
   } },

   /* replace35_0 -> 9 in the cache */
   /* replace35 -> 123 in the cache */

   /* ('iabs', ('iabs', 'a')) => ('iabs', 'a') */
   /* search36_0_0 -> 9 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_iabs,
      -1, 0,
      { 9 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_iabs,
      -1, 0,
      { 125 },
      -1,
   } },

   /* replace36_0 -> 9 in the cache */
   /* replace36 -> 125 in the cache */

   /* ('iabs', ('ineg', 'a')) => ('iabs', 'a') */
   /* search37_0_0 -> 9 in the cache */
   /* search37_0 -> 120 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_iabs,
      -1, 0,
      { 120 },
      -1,
   } },

   /* replace37_0 -> 9 in the cache */
   /* replace37 -> 125 in the cache */

   /* ('~fadd', 'a', 0.0) => a */
   /* search38_0 -> 9 in the cache */
   /* search38_1 -> 8 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      true,
      false,
      false,
      false,
      false,
      false,
      nir_op_fadd,
      0, 1,
      { 9, 8 },
      -1,
   } },

   /* replace38 -> 9 in the cache */

   /* ('fadd(is_only_used_as_float,nsz)', 'a', 0.0) => a */
   /* search39_0 -> 9 in the cache */
   /* search39_1 -> 8 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      true,
      false,
      false,
      nir_op_fadd,
      0, 1,
      { 9, 8 },
      1,
   } },

   /* replace39 -> 9 in the cache */

   /* ('fadd(is_only_used_as_float)', 'a', '#b(is_negative_zero)') => a */
   /* search40_0 -> 0 in the cache */
   { .variable = {
      { nir_search_value_variable, -2 },
      1, /* b */
      true,
      nir_type_invalid,
      3,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fadd,
      0, 1,
      { 0, 130 },
      1,
   } },

   /* replace40 -> 0 in the cache */

   /* ('fadd', ('fneg', 'a'), '#b(is_negative_zero)') => ('fneg', 'a') */
   /* search41_0_0 -> 0 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fneg,
      -1, 0,
      { 0 },
      -1,
   } },
   /* search41_1 -> 130 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fadd,
      0, 1,
      { 132, 130 },
      -1,
   } },

   /* replace41_0 -> 0 in the cache */
   /* replace41 -> 132 in the cache */

   /* ('iadd', 'a', 0) => a */
   /* search42_0 -> 9 in the cache */
   /* search42_1 -> 73 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_iadd,
      0, 1,
      { 9, 73 },
      -1,
   } },

   /* replace42 -> 9 in the cache */

   /* ('iadd_sat', 'a', 0) => a */
   /* search43_0 -> 9 in the cache */
   /* search43_1 -> 73 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_iadd_sat,
      0, 1,
      { 9, 73 },
      -1,
   } },

   /* replace43 -> 9 in the cache */

   /* ('isub_sat', 'a', 0) => a */
   /* search44_0 -> 9 in the cache */
   /* search44_1 -> 73 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_isub_sat,
      -1, 0,
      { 9, 73 },
      -1,
   } },

   /* replace44 -> 9 in the cache */

   /* ('uadd_sat', 'a', 0) => a */
   /* search45_0 -> 9 in the cache */
   /* search45_1 -> 73 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_uadd_sat,
      0, 1,
      { 9, 73 },
      -1,
   } },

   /* replace45 -> 9 in the cache */

   /* ('usub_sat', 'a', 0) => a */
   /* search46_0 -> 9 in the cache */
   /* search46_1 -> 73 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_usub_sat,
      -1, 0,
      { 9, 73 },
      -1,
   } },

   /* replace46 -> 9 in the cache */

   /* ('usadd_4x8_vc4', 'a', 0) => a */
   /* search47_0 -> 29 in the cache */
   { .constant = {
      { nir_search_value_constant, 32 },
      nir_type_int, { 0x0ull /* 0 */ },
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_usadd_4x8_vc4,
      0, 1,
      { 29, 139 },
      -1,
   } },

   /* replace47 -> 29 in the cache */

   /* ('usadd_4x8_vc4', 'a', -1) => -1 */
   /* search48_0 -> 29 in the cache */
   { .constant = {
      { nir_search_value_constant, 32 },
      nir_type_int, { 0xffffffffffffffffull /* -1 */ },
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_usadd_4x8_vc4,
      0, 1,
      { 29, 141 },
      -1,
   } },

   /* replace48 -> 141 in the cache */

   /* ('~fadd', ('fmul', 'a', 'b'), ('fmul', 'a', 'c')) => ('fmul', 'a', ('fadd', 'b', 'c')) */
   { .variable = {
      { nir_search_value_variable, -3 },
      0, /* a */
      false,
      nir_type_invalid,
      -1,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .variable = {
      { nir_search_value_variable, -3 },
      1, /* b */
      false,
      nir_type_invalid,
      -1,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fmul,
      1, 1,
      { 143, 144 },
      -1,
   } },
   /* search49_1_0 -> 143 in the cache */
   { .variable = {
      { nir_search_value_variable, -3 },
      2, /* c */
      false,
      nir_type_invalid,
      -1,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fmul,
      2, 1,
      { 143, 146 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -3 },
      true,
      false,
      false,
      false,
      false,
      false,
      nir_op_fadd,
      0, 3,
      { 145, 147 },
      -1,
   } },

   /* replace49_0 -> 143 in the cache */
   /* replace49_1_0 -> 144 in the cache */
   /* replace49_1_1 -> 146 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fadd,
      1, 1,
      { 144, 146 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fmul,
      0, 2,
      { 143, 149 },
      -1,
   } },

   /* ('~fadd', ('fmulz', 'a', 'b'), ('fmulz', 'a', 'c')) => ('fmulz', 'a', ('fadd', 'b', 'c')) */
   /* search50_0_0 -> 29 in the cache */
   /* search50_0_1 -> 48 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fmulz,
      1, 1,
      { 29, 48 },
      -1,
   } },
   /* search50_1_0 -> 29 in the cache */
   { .variable = {
      { nir_search_value_variable, 32 },
      2, /* c */
      false,
      nir_type_invalid,
      -1,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fmulz,
      2, 1,
      { 29, 152 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      true,
      false,
      false,
      false,
      false,
      false,
      nir_op_fadd,
      0, 3,
      { 151, 153 },
      -1,
   } },

   /* replace50_0 -> 29 in the cache */
   /* replace50_1_0 -> 48 in the cache */
   /* replace50_1_1 -> 152 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fadd,
      1, 1,
      { 48, 152 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fmulz,
      0, 2,
      { 29, 155 },
      -1,
   } },

   /* ('~ffma', 'a', 'b', ('ffma(is_used_once)', 'a', 'c', 'd')) => ('ffma', 'a', ('fadd', 'b', 'c'), 'd') */
   /* search51_0 -> 0 in the cache */
   /* search51_1 -> 1 in the cache */
   /* search51_2_0 -> 0 in the cache */
   { .variable = {
      { nir_search_value_variable, -2 },
      2, /* c */
      false,
      nir_type_invalid,
      -1,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .variable = {
      { nir_search_value_variable, -2 },
      3, /* d */
      false,
      nir_type_invalid,
      -1,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ffma,
      1, 1,
      { 0, 157, 158 },
      0,
   } },
   { .expression = {
      { nir_search_value_expression, -2 },
      true,
      false,
      false,
      false,
      false,
      false,
      nir_op_ffma,
      0, 2,
      { 0, 1, 159 },
      -1,
   } },

   /* replace51_0 -> 0 in the cache */
   /* replace51_1_0 -> 1 in the cache */
   /* replace51_1_1 -> 157 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fadd,
      1, 1,
      { 1, 157 },
      -1,
   } },
   /* replace51_2 -> 158 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ffma,
      0, 2,
      { 0, 161, 158 },
      -1,
   } },

   /* ('~ffma', 'a', 'b', ('fmul(is_used_once)', 'a', 'c')) => ('fmul', 'a', ('fadd', 'b', 'c')) */
   /* search52_0 -> 0 in the cache */
   /* search52_1 -> 1 in the cache */
   /* search52_2_0 -> 0 in the cache */
   /* search52_2_1 -> 157 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fmul,
      1, 1,
      { 0, 157 },
      0,
   } },
   { .expression = {
      { nir_search_value_expression, -2 },
      true,
      false,
      false,
      false,
      false,
      false,
      nir_op_ffma,
      0, 2,
      { 0, 1, 163 },
      -1,
   } },

   /* replace52_0 -> 0 in the cache */
   /* replace52_1_0 -> 1 in the cache */
   /* replace52_1_1 -> 157 in the cache */
   /* replace52_1 -> 161 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fmul,
      0, 2,
      { 0, 161 },
      -1,
   } },

   /* ('~fadd', ('fmul(is_used_once)', 'a', 'b'), ('ffma(is_used_once)', 'a', 'c', 'd')) => ('ffma', 'a', ('fadd', 'b', 'c'), 'd') */
   { .variable = {
      { nir_search_value_variable, -4 },
      0, /* a */
      false,
      nir_type_invalid,
      -1,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .variable = {
      { nir_search_value_variable, -4 },
      1, /* b */
      false,
      nir_type_invalid,
      -1,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .expression = {
      { nir_search_value_expression, -4 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fmul,
      1, 1,
      { 166, 167 },
      0,
   } },
   /* search53_1_0 -> 166 in the cache */
   { .variable = {
      { nir_search_value_variable, -4 },
      2, /* c */
      false,
      nir_type_invalid,
      -1,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .variable = {
      { nir_search_value_variable, -4 },
      3, /* d */
      false,
      nir_type_invalid,
      -1,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .expression = {
      { nir_search_value_expression, -4 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ffma,
      2, 1,
      { 166, 169, 170 },
      0,
   } },
   { .expression = {
      { nir_search_value_expression, -4 },
      true,
      false,
      false,
      false,
      false,
      false,
      nir_op_fadd,
      0, 3,
      { 168, 171 },
      -1,
   } },

   /* replace53_0 -> 166 in the cache */
   /* replace53_1_0 -> 167 in the cache */
   /* replace53_1_1 -> 169 in the cache */
   { .expression = {
      { nir_search_value_expression, -4 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fadd,
      1, 1,
      { 167, 169 },
      -1,
   } },
   /* replace53_2 -> 170 in the cache */
   { .expression = {
      { nir_search_value_expression, -4 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ffma,
      0, 2,
      { 166, 173, 170 },
      -1,
   } },

   /* ('~ffma', 'a', ('fmul(is_used_once)', 'b', 'c'), ('fmul(is_used_once)', 'b', 'd')) => ('fmul', 'b', ('ffma', 'a', 'c', 'd')) */
   /* search54_0 -> 166 in the cache */
   /* search54_1_0 -> 167 in the cache */
   /* search54_1_1 -> 169 in the cache */
   { .expression = {
      { nir_search_value_expression, -4 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fmul,
      1, 1,
      { 167, 169 },
      0,
   } },
   /* search54_2_0 -> 167 in the cache */
   /* search54_2_1 -> 170 in the cache */
   { .expression = {
      { nir_search_value_expression, -4 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fmul,
      2, 1,
      { 167, 170 },
      0,
   } },
   { .expression = {
      { nir_search_value_expression, -4 },
      true,
      false,
      false,
      false,
      false,
      false,
      nir_op_ffma,
      0, 3,
      { 166, 175, 176 },
      -1,
   } },

   /* replace54_0 -> 167 in the cache */
   /* replace54_1_0 -> 166 in the cache */
   /* replace54_1_1 -> 169 in the cache */
   /* replace54_1_2 -> 170 in the cache */
   { .expression = {
      { nir_search_value_expression, -4 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ffma,
      1, 1,
      { 166, 169, 170 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -4 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fmul,
      0, 2,
      { 167, 178 },
      -1,
   } },

   /* ('~ffmaz', 'a', 'b', ('ffmaz(is_used_once)', 'a', 'c', 'd')) => ('ffmaz', 'a', ('fadd', 'b', 'c'), 'd') */
   /* search55_0 -> 29 in the cache */
   /* search55_1 -> 48 in the cache */
   /* search55_2_0 -> 29 in the cache */
   /* search55_2_1 -> 152 in the cache */
   { .variable = {
      { nir_search_value_variable, 32 },
      3, /* d */
      false,
      nir_type_invalid,
      -1,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ffmaz,
      1, 1,
      { 29, 152, 180 },
      0,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      true,
      false,
      false,
      false,
      false,
      false,
      nir_op_ffmaz,
      0, 2,
      { 29, 48, 181 },
      -1,
   } },

   /* replace55_0 -> 29 in the cache */
   /* replace55_1_0 -> 48 in the cache */
   /* replace55_1_1 -> 152 in the cache */
   /* replace55_1 -> 155 in the cache */
   /* replace55_2 -> 180 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ffmaz,
      0, 2,
      { 29, 155, 180 },
      -1,
   } },

   /* ('~ffmaz', 'a', 'b', ('fmulz(is_used_once)', 'a', 'c')) => ('fmulz', 'a', ('fadd', 'b', 'c')) */
   /* search56_0 -> 29 in the cache */
   /* search56_1 -> 48 in the cache */
   /* search56_2_0 -> 29 in the cache */
   /* search56_2_1 -> 152 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fmulz,
      1, 1,
      { 29, 152 },
      0,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      true,
      false,
      false,
      false,
      false,
      false,
      nir_op_ffmaz,
      0, 2,
      { 29, 48, 184 },
      -1,
   } },

   /* replace56_0 -> 29 in the cache */
   /* replace56_1_0 -> 48 in the cache */
   /* replace56_1_1 -> 152 in the cache */
   /* replace56_1 -> 155 in the cache */
   /* replace56 -> 156 in the cache */

   /* ('~fadd', ('fmulz(is_used_once)', 'a', 'b'), ('ffmaz(is_used_once)', 'a', 'c', 'd')) => ('ffmaz', 'a', ('fadd', 'b', 'c'), 'd') */
   /* search57_0_0 -> 29 in the cache */
   /* search57_0_1 -> 48 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fmulz,
      1, 1,
      { 29, 48 },
      0,
   } },
   /* search57_1_0 -> 29 in the cache */
   /* search57_1_1 -> 152 in the cache */
   /* search57_1_2 -> 180 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ffmaz,
      2, 1,
      { 29, 152, 180 },
      0,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      true,
      false,
      false,
      false,
      false,
      false,
      nir_op_fadd,
      0, 3,
      { 186, 187 },
      -1,
   } },

   /* replace57_0 -> 29 in the cache */
   /* replace57_1_0 -> 48 in the cache */
   /* replace57_1_1 -> 152 in the cache */
   /* replace57_1 -> 155 in the cache */
   /* replace57_2 -> 180 in the cache */
   /* replace57 -> 183 in the cache */

   /* ('~ffmaz', 'a', ('fmulz(is_used_once)', 'b', 'c'), ('fmulz(is_used_once)', 'b', 'd')) => ('fmulz', 'b', ('ffmaz', 'a', 'c', 'd')) */
   /* search58_0 -> 29 in the cache */
   /* search58_1_0 -> 48 in the cache */
   /* search58_1_1 -> 152 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fmulz,
      1, 1,
      { 48, 152 },
      0,
   } },
   /* search58_2_0 -> 48 in the cache */
   /* search58_2_1 -> 180 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fmulz,
      2, 1,
      { 48, 180 },
      0,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      true,
      false,
      false,
      false,
      false,
      false,
      nir_op_ffmaz,
      0, 3,
      { 29, 189, 190 },
      -1,
   } },

   /* replace58_0 -> 48 in the cache */
   /* replace58_1_0 -> 29 in the cache */
   /* replace58_1_1 -> 152 in the cache */
   /* replace58_1_2 -> 180 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ffmaz,
      1, 1,
      { 29, 152, 180 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fmulz,
      0, 2,
      { 48, 192 },
      -1,
   } },

   /* ('iadd', ('imul', 'a', 'b'), ('imul', 'a', 'c')) => ('imul', 'a', ('iadd', 'b', 'c')) */
   /* search59_0_0 -> 143 in the cache */
   /* search59_0_1 -> 144 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_imul,
      1, 1,
      { 143, 144 },
      -1,
   } },
   /* search59_1_0 -> 143 in the cache */
   /* search59_1_1 -> 146 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_imul,
      2, 1,
      { 143, 146 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_iadd,
      0, 3,
      { 194, 195 },
      -1,
   } },

   /* replace59_0 -> 143 in the cache */
   /* replace59_1_0 -> 144 in the cache */
   /* replace59_1_1 -> 146 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_iadd,
      1, 1,
      { 144, 146 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_imul,
      0, 2,
      { 143, 197 },
      -1,
   } },

   /* ('iadd', ('ishl', 'b', 'a'), ('ishl', 'c', 'a')) => ('ishl', ('iadd', 'b', 'c'), 'a') */
   { .variable = {
      { nir_search_value_variable, -3 },
      0, /* b */
      false,
      nir_type_invalid,
      -1,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .variable = {
      { nir_search_value_variable, 32 },
      1, /* a */
      false,
      nir_type_invalid,
      -1,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ishl,
      -1, 0,
      { 199, 200 },
      -1,
   } },
   /* search60_1_0 -> 146 in the cache */
   /* search60_1_1 -> 200 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ishl,
      -1, 0,
      { 146, 200 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_iadd,
      0, 1,
      { 201, 202 },
      -1,
   } },

   /* replace60_0_0 -> 199 in the cache */
   /* replace60_0_1 -> 146 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_iadd,
      0, 1,
      { 199, 146 },
      -1,
   } },
   /* replace60_1 -> 200 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ishl,
      -1, 1,
      { 204, 200 },
      -1,
   } },

   /* ('iand', ('iand', 'a', 'b'), ('iand(is_used_once)', 'a', 'c')) => ('iand', ('iand', 'a', 'b'), 'c') */
   /* search61_0_0 -> 143 in the cache */
   /* search61_0_1 -> 144 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_iand,
      1, 1,
      { 143, 144 },
      -1,
   } },
   /* search61_1_0 -> 143 in the cache */
   /* search61_1_1 -> 146 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_iand,
      2, 1,
      { 143, 146 },
      0,
   } },
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_iand,
      0, 3,
      { 206, 207 },
      -1,
   } },

   /* replace61_0_0 -> 143 in the cache */
   /* replace61_0_1 -> 144 in the cache */
   /* replace61_0 -> 206 in the cache */
   /* replace61_1 -> 146 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_iand,
      0, 2,
      { 206, 146 },
      -1,
   } },

   /* ('ior', ('ior', 'a', 'b'), ('ior(is_used_once)', 'a', 'c')) => ('ior', ('ior', 'a', 'b'), 'c') */
   /* search62_0_0 -> 143 in the cache */
   /* search62_0_1 -> 144 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ior,
      1, 1,
      { 143, 144 },
      -1,
   } },
   /* search62_1_0 -> 143 in the cache */
   /* search62_1_1 -> 146 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ior,
      2, 1,
      { 143, 146 },
      0,
   } },
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ior,
      0, 3,
      { 210, 211 },
      -1,
   } },

   /* replace62_0_0 -> 143 in the cache */
   /* replace62_0_1 -> 144 in the cache */
   /* replace62_0 -> 210 in the cache */
   /* replace62_1 -> 146 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ior,
      0, 2,
      { 210, 146 },
      -1,
   } },

   /* ('iand', ('ior(is_used_once)', 'a', 'b'), ('ior(is_used_once)', 'a', 'c')) => ('ior', 'a', ('iand', 'b', 'c')) */
   /* search63_0_0 -> 143 in the cache */
   /* search63_0_1 -> 144 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ior,
      1, 1,
      { 143, 144 },
      0,
   } },
   /* search63_1_0 -> 143 in the cache */
   /* search63_1_1 -> 146 in the cache */
   /* search63_1 -> 211 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_iand,
      0, 3,
      { 214, 211 },
      -1,
   } },

   /* replace63_0 -> 143 in the cache */
   /* replace63_1_0 -> 144 in the cache */
   /* replace63_1_1 -> 146 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_iand,
      1, 1,
      { 144, 146 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ior,
      0, 2,
      { 143, 216 },
      -1,
   } },

   /* ('ior', ('iand(is_used_once)', 'a', 'b'), ('iand(is_used_once)', 'a', 'c')) => ('iand', 'a', ('ior', 'b', 'c')) */
   /* search64_0_0 -> 143 in the cache */
   /* search64_0_1 -> 144 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_iand,
      1, 1,
      { 143, 144 },
      0,
   } },
   /* search64_1_0 -> 143 in the cache */
   /* search64_1_1 -> 146 in the cache */
   /* search64_1 -> 207 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ior,
      0, 3,
      { 218, 207 },
      -1,
   } },

   /* replace64_0 -> 143 in the cache */
   /* replace64_1_0 -> 144 in the cache */
   /* replace64_1_1 -> 146 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ior,
      1, 1,
      { 144, 146 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_iand,
      0, 2,
      { 143, 220 },
      -1,
   } },

   /* ('ior', ('iand', 'a', 'b'), ('ior', 'a', 'c')) => ('ior', 'a', 'c') */
   /* search65_0_0 -> 143 in the cache */
   /* search65_0_1 -> 144 in the cache */
   /* search65_0 -> 206 in the cache */
   /* search65_1_0 -> 143 in the cache */
   /* search65_1_1 -> 146 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ior,
      2, 1,
      { 143, 146 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ior,
      0, 3,
      { 206, 222 },
      -1,
   } },

   /* replace65_0 -> 143 in the cache */
   /* replace65_1 -> 146 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ior,
      0, 1,
      { 143, 146 },
      -1,
   } },

   /* ('iand', ('iand', 'a', 'b'), ('ior', 'a', 'c')) => ('iand', 'a', 'b') */
   /* search66_0_0 -> 143 in the cache */
   /* search66_0_1 -> 144 in the cache */
   /* search66_0 -> 206 in the cache */
   /* search66_1_0 -> 143 in the cache */
   /* search66_1_1 -> 146 in the cache */
   /* search66_1 -> 222 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_iand,
      0, 3,
      { 206, 222 },
      -1,
   } },

   /* replace66_0 -> 143 in the cache */
   /* replace66_1 -> 144 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_iand,
      0, 1,
      { 143, 144 },
      -1,
   } },

   /* ('ieq', ('iand', 'a', '#b(is_pos_power_of_two)'), 'b') => ('ine', ('iand', 'a', 'b'), 0) */
   /* search67_0_0 -> 0 in the cache */
   /* search67_0_1 -> 15 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_iand,
      1, 1,
      { 0, 15 },
      -1,
   } },
   /* search67_1 -> 1 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ieq,
      0, 2,
      { 227, 1 },
      -1,
   } },

   /* replace67_0_0 -> 0 in the cache */
   /* replace67_0_1 -> 1 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_iand,
      1, 1,
      { 0, 1 },
      -1,
   } },
   /* replace67_1 -> 98 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ine,
      0, 2,
      { 229, 98 },
      -1,
   } },

   /* ('ine', ('iand', 'a', '#b(is_pos_power_of_two)'), 'b') => ('ieq', ('iand', 'a', 'b'), 0) */
   /* search68_0_0 -> 0 in the cache */
   /* search68_0_1 -> 15 in the cache */
   /* search68_0 -> 227 in the cache */
   /* search68_1 -> 1 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ine,
      0, 2,
      { 227, 1 },
      -1,
   } },

   /* replace68_0_0 -> 0 in the cache */
   /* replace68_0_1 -> 1 in the cache */
   /* replace68_0 -> 229 in the cache */
   /* replace68_1 -> 98 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ieq,
      0, 2,
      { 229, 98 },
      -1,
   } },

   /* ('ieq', ('ushr(is_used_once)', 'a', '#b'), 0) => ('ult', 'a', ('ishl', 1, 'b')) */
   /* search69_0_0 -> 9 in the cache */
   /* search69_0_1 -> 45 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ushr,
      -1, 0,
      { 9, 45 },
      0,
   } },
   /* search69_1 -> 73 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ieq,
      0, 1,
      { 233, 73 },
      -1,
   } },

   /* replace69_0 -> 9 in the cache */
   /* replace69_1_0 -> 47 in the cache */
   /* replace69_1_1 -> 48 in the cache */
   /* replace69_1 -> 49 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ult,
      -1, 0,
      { 9, 49 },
      -1,
   } },

   /* ('ine', ('ushr(is_used_once)', 'a', '#b'), 0) => ('uge', 'a', ('ishl', 1, 'b')) */
   /* search70_0_0 -> 9 in the cache */
   /* search70_0_1 -> 45 in the cache */
   /* search70_0 -> 233 in the cache */
   /* search70_1 -> 73 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ine,
      0, 1,
      { 233, 73 },
      -1,
   } },

   /* replace70_0 -> 9 in the cache */
   /* replace70_1_0 -> 47 in the cache */
   /* replace70_1_1 -> 48 in the cache */
   /* replace70_1 -> 49 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_uge,
      -1, 0,
      { 9, 49 },
      -1,
   } },

   /* ('~fadd', ('fneg', 'a'), 'a') => 0.0 */
   /* search71_0_0 -> 9 in the cache */
   /* search71_0 -> 118 in the cache */
   /* search71_1 -> 9 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      true,
      false,
      false,
      false,
      false,
      false,
      nir_op_fadd,
      0, 1,
      { 118, 9 },
      -1,
   } },

   /* replace71 -> 8 in the cache */

   /* ('iadd', ('ineg', 'a'), 'a') => 0 */
   /* search72_0_0 -> 9 in the cache */
   /* search72_0 -> 120 in the cache */
   /* search72_1 -> 9 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_iadd,
      0, 1,
      { 120, 9 },
      -1,
   } },

   /* replace72 -> 73 in the cache */

   /* ('iadd', ('ineg', 'a'), ('iadd', 'a', 'b')) => b */
   /* search73_0_0 -> 0 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ineg,
      -1, 0,
      { 0 },
      -1,
   } },
   /* search73_1_0 -> 0 in the cache */
   /* search73_1_1 -> 1 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_iadd,
      1, 1,
      { 0, 1 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_iadd,
      0, 2,
      { 240, 241 },
      -1,
   } },

   /* replace73 -> 1 in the cache */

   /* ('iadd', 'a', ('iadd', ('ineg', 'a'), 'b')) => b */
   /* search74_0 -> 0 in the cache */
   /* search74_1_0_0 -> 0 in the cache */
   /* search74_1_0 -> 240 in the cache */
   /* search74_1_1 -> 1 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_iadd,
      1, 1,
      { 240, 1 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_iadd,
      0, 2,
      { 0, 243 },
      -1,
   } },

   /* replace74 -> 1 in the cache */

   /* ('~fadd', ('fneg', 'a'), ('fadd', 'a', 'b')) => b */
   /* search75_0_0 -> 0 in the cache */
   /* search75_0 -> 132 in the cache */
   /* search75_1_0 -> 0 in the cache */
   /* search75_1_1 -> 1 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fadd,
      1, 1,
      { 0, 1 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -2 },
      true,
      false,
      false,
      false,
      false,
      false,
      nir_op_fadd,
      0, 2,
      { 132, 245 },
      -1,
   } },

   /* replace75 -> 1 in the cache */

   /* ('~fadd', 'a', ('fadd', ('fneg', 'a'), 'b')) => b */
   /* search76_0 -> 0 in the cache */
   /* search76_1_0_0 -> 0 in the cache */
   /* search76_1_0 -> 132 in the cache */
   /* search76_1_1 -> 1 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fadd,
      1, 1,
      { 132, 1 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -2 },
      true,
      false,
      false,
      false,
      false,
      false,
      nir_op_fadd,
      0, 2,
      { 0, 247 },
      -1,
   } },

   /* replace76 -> 1 in the cache */

   /* ('fadd', ('fsat', 'a'), ('fsat', ('fneg', 'a'))) => ('fsat', ('fabs', 'a')) */
   /* search77_0_0 -> 9 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fsat,
      -1, 0,
      { 9 },
      -1,
   } },
   /* search77_1_0_0 -> 9 in the cache */
   /* search77_1_0 -> 118 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fsat,
      -1, 0,
      { 118 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fadd,
      0, 1,
      { 249, 250 },
      -1,
   } },

   /* replace77_0_0 -> 9 in the cache */
   /* replace77_0 -> 11 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fsat,
      -1, 0,
      { 11 },
      -1,
   } },

   /* ('~fmul', 'a', 0.0) => 0.0 */
   /* search78_0 -> 9 in the cache */
   /* search78_1 -> 8 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      true,
      false,
      false,
      false,
      false,
      false,
      nir_op_fmul,
      0, 1,
      { 9, 8 },
      -1,
   } },

   /* replace78 -> 8 in the cache */

   /* ('fmul(nsz,nnan)', 'a', 0.0) => 0.0 */
   /* search79_0 -> 9 in the cache */
   /* search79_1 -> 8 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      true,
      true,
      false,
      nir_op_fmul,
      0, 1,
      { 9, 8 },
      -1,
   } },

   /* replace79 -> 8 in the cache */

   /* ('fmulz', 'a', 0.0) => 0.0 */
   /* search80_0 -> 29 in the cache */
   { .constant = {
      { nir_search_value_constant, 32 },
      nir_type_float, { 0x0ull /* 0.0 */ },
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fmulz,
      0, 1,
      { 29, 255 },
      -1,
   } },

   /* replace80 -> 255 in the cache */

   /* ('fmulz(nsz)', 'a', 'b(is_finite_not_zero)') => ('fmul', 'a', 'b') */
   /* search81_0 -> 29 in the cache */
   { .variable = {
      { nir_search_value_variable, 32 },
      1, /* b */
      false,
      nir_type_invalid,
      4,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      true,
      false,
      false,
      nir_op_fmulz,
      0, 1,
      { 29, 257 },
      -1,
   } },

   /* replace81_0 -> 29 in the cache */
   /* replace81_1 -> 48 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fmul,
      0, 1,
      { 29, 48 },
      -1,
   } },

   /* ('fmulz', 'a(is_finite)', 'b(is_finite)') => ('fmul', 'a', 'b') */
   { .variable = {
      { nir_search_value_variable, 32 },
      0, /* a */
      false,
      nir_type_invalid,
      5,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .variable = {
      { nir_search_value_variable, 32 },
      1, /* b */
      false,
      nir_type_invalid,
      5,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fmulz,
      0, 1,
      { 260, 261 },
      -1,
   } },

   /* replace82_0 -> 29 in the cache */
   /* replace82_1 -> 48 in the cache */
   /* replace82 -> 259 in the cache */

   /* ('fmulz', 'a', 'a') => ('fmul', 'a', 'a') */
   /* search83_0 -> 29 in the cache */
   /* search83_1 -> 29 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fmulz,
      -1, 0,
      { 29, 29 },
      -1,
   } },

   /* replace83_0 -> 29 in the cache */
   /* replace83_1 -> 29 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fmul,
      -1, 0,
      { 29, 29 },
      -1,
   } },

   /* ('ffmaz(nsz)', 'a', 'b(is_finite_not_zero)', 'c') => ('ffma', 'a', 'b', 'c') */
   /* search84_0 -> 29 in the cache */
   /* search84_1 -> 257 in the cache */
   /* search84_2 -> 152 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      true,
      false,
      false,
      nir_op_ffmaz,
      0, 1,
      { 29, 257, 152 },
      -1,
   } },

   /* replace84_0 -> 29 in the cache */
   /* replace84_1 -> 48 in the cache */
   /* replace84_2 -> 152 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ffma,
      0, 1,
      { 29, 48, 152 },
      -1,
   } },

   /* ('ffmaz', 'a(is_finite)', 'b(is_finite)', 'c') => ('ffma', 'a', 'b', 'c') */
   /* search85_0 -> 260 in the cache */
   /* search85_1 -> 261 in the cache */
   /* search85_2 -> 152 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ffmaz,
      0, 1,
      { 260, 261, 152 },
      -1,
   } },

   /* replace85_0 -> 29 in the cache */
   /* replace85_1 -> 48 in the cache */
   /* replace85_2 -> 152 in the cache */
   /* replace85 -> 266 in the cache */

   /* ('ffmaz', 'a', 'a', 'b') => ('ffma', 'a', 'a', 'b') */
   /* search86_0 -> 29 in the cache */
   /* search86_1 -> 29 in the cache */
   /* search86_2 -> 48 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ffmaz,
      -1, 0,
      { 29, 29, 48 },
      -1,
   } },

   /* replace86_0 -> 29 in the cache */
   /* replace86_1 -> 29 in the cache */
   /* replace86_2 -> 48 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ffma,
      -1, 0,
      { 29, 29, 48 },
      -1,
   } },

   /* ('imul', 'a', 0) => 0 */
   /* search87_0 -> 9 in the cache */
   /* search87_1 -> 73 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_imul,
      0, 1,
      { 9, 73 },
      -1,
   } },

   /* replace87 -> 73 in the cache */

   /* ('umul_unorm_4x8_vc4', 'a', 0) => 0 */
   /* search88_0 -> 29 in the cache */
   /* search88_1 -> 139 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_umul_unorm_4x8_vc4,
      0, 1,
      { 29, 139 },
      -1,
   } },

   /* replace88 -> 139 in the cache */

   /* ('umul_unorm_4x8_vc4', 'a', -1) => a */
   /* search89_0 -> 29 in the cache */
   /* search89_1 -> 141 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_umul_unorm_4x8_vc4,
      0, 1,
      { 29, 141 },
      -1,
   } },

   /* replace89 -> 29 in the cache */

   /* ('~fmul', 'a', 1.0) => a */
   /* search90_0 -> 9 in the cache */
   { .constant = {
      { nir_search_value_constant, -1 },
      nir_type_float, { 0x3ff0000000000000ull /* 1.0 */ },
   } },
   { .expression = {
      { nir_search_value_expression, -1 },
      true,
      false,
      false,
      false,
      false,
      false,
      nir_op_fmul,
      0, 1,
      { 9, 273 },
      -1,
   } },

   /* replace90 -> 9 in the cache */

   /* ('~fmulz', 'a', 1.0) => a */
   /* search91_0 -> 29 in the cache */
   { .constant = {
      { nir_search_value_constant, 32 },
      nir_type_float, { 0x3ff0000000000000ull /* 1.0 */ },
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      true,
      false,
      false,
      false,
      false,
      false,
      nir_op_fmulz,
      0, 1,
      { 29, 275 },
      -1,
   } },

   /* replace91 -> 29 in the cache */

   /* ('fmul(is_only_used_as_float)', 'a', 1.0) => a */
   /* search92_0 -> 9 in the cache */
   /* search92_1 -> 273 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fmul,
      0, 1,
      { 9, 273 },
      1,
   } },

   /* replace92 -> 9 in the cache */

   /* ('imul', 'a', 1) => a */
   /* search93_0 -> 9 in the cache */
   /* search93_1 -> 47 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_imul,
      0, 1,
      { 9, 47 },
      -1,
   } },

   /* replace93 -> 9 in the cache */

   /* ('fmul', 'a', -1.0) => ('fneg', 'a') */
   /* search94_0 -> 9 in the cache */
   { .constant = {
      { nir_search_value_constant, -1 },
      nir_type_float, { 0xbff0000000000000ull /* -1.0 */ },
   } },
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fmul,
      0, 1,
      { 9, 279 },
      -1,
   } },

   /* replace94_0 -> 9 in the cache */
   /* replace94 -> 118 in the cache */

   /* ('imul', 'a', -1) => ('ineg', 'a') */
   /* search95_0 -> 9 in the cache */
   /* search95_1 -> 75 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_imul,
      0, 1,
      { 9, 75 },
      -1,
   } },

   /* replace95_0 -> 9 in the cache */
   /* replace95 -> 120 in the cache */

   /* ('fmul', ('fsign', 'a'), ('fmul', 'a', 'a')) => ('fmul', ('fabs', 'a'), 'a') */
   /* search96_0_0 -> 9 in the cache */
   /* search96_0 -> 110 in the cache */
   /* search96_1_0 -> 9 in the cache */
   /* search96_1_1 -> 9 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fmul,
      -1, 0,
      { 9, 9 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fmul,
      0, 1,
      { 110, 282 },
      -1,
   } },

   /* replace96_0_0 -> 9 in the cache */
   /* replace96_0 -> 11 in the cache */
   /* replace96_1 -> 9 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fmul,
      0, 1,
      { 11, 9 },
      -1,
   } },

   /* ('fmul', ('fmul', ('fsign', 'a'), 'a'), 'a') => ('fmul', ('fabs', 'a'), 'a') */
   /* search97_0_0_0 -> 9 in the cache */
   /* search97_0_0 -> 110 in the cache */
   /* search97_0_1 -> 9 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fmul,
      1, 1,
      { 110, 9 },
      -1,
   } },
   /* search97_1 -> 9 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fmul,
      0, 2,
      { 285, 9 },
      -1,
   } },

   /* replace97_0_0 -> 9 in the cache */
   /* replace97_0 -> 11 in the cache */
   /* replace97_1 -> 9 in the cache */
   /* replace97 -> 284 in the cache */

   /* ('~ffma', 0.0, 'a', 'b') => b */
   { .constant = {
      { nir_search_value_constant, -2 },
      nir_type_float, { 0x0ull /* 0.0 */ },
   } },
   /* search98_1 -> 0 in the cache */
   /* search98_2 -> 1 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      true,
      false,
      false,
      false,
      false,
      false,
      nir_op_ffma,
      0, 1,
      { 287, 0, 1 },
      -1,
   } },

   /* replace98 -> 1 in the cache */

   /* ('ffma(is_only_used_as_float,nsz,nnan,ninf)', 0.0, 'a', 'b') => b */
   /* search99_0 -> 287 in the cache */
   /* search99_1 -> 0 in the cache */
   /* search99_2 -> 1 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      true,
      true,
      true,
      nir_op_ffma,
      0, 1,
      { 287, 0, 1 },
      1,
   } },

   /* replace99 -> 1 in the cache */

   /* ('ffmaz', 0.0, 'a', 'b') => ('fadd', 0.0, 'b') */
   /* search100_0 -> 255 in the cache */
   /* search100_1 -> 29 in the cache */
   /* search100_2 -> 48 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ffmaz,
      0, 1,
      { 255, 29, 48 },
      -1,
   } },

   /* replace100_0 -> 255 in the cache */
   /* replace100_1 -> 48 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fadd,
      0, 1,
      { 255, 48 },
      -1,
   } },

   /* ('~ffma', 'a', 'b', 0.0) => ('fmul', 'a', 'b') */
   /* search101_0 -> 0 in the cache */
   /* search101_1 -> 1 in the cache */
   /* search101_2 -> 287 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      true,
      false,
      false,
      false,
      false,
      false,
      nir_op_ffma,
      0, 1,
      { 0, 1, 287 },
      -1,
   } },

   /* replace101_0 -> 0 in the cache */
   /* replace101_1 -> 1 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fmul,
      0, 1,
      { 0, 1 },
      -1,
   } },

   /* ('ffma(nsz)', 'a', 'b', 0.0) => ('fmul', 'a', 'b') */
   /* search102_0 -> 0 in the cache */
   /* search102_1 -> 1 in the cache */
   /* search102_2 -> 287 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      true,
      false,
      false,
      nir_op_ffma,
      0, 1,
      { 0, 1, 287 },
      -1,
   } },

   /* replace102_0 -> 0 in the cache */
   /* replace102_1 -> 1 in the cache */
   /* replace102 -> 293 in the cache */

   /* ('ffmaz(nsz)', 'a', 'b', 0.0) => ('fmulz', 'a', 'b') */
   /* search103_0 -> 29 in the cache */
   /* search103_1 -> 48 in the cache */
   /* search103_2 -> 255 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      true,
      false,
      false,
      nir_op_ffmaz,
      0, 1,
      { 29, 48, 255 },
      -1,
   } },

   /* replace103_0 -> 29 in the cache */
   /* replace103_1 -> 48 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fmulz,
      0, 1,
      { 29, 48 },
      -1,
   } },

   /* ('ffma', 1.0, 'a', 'b') => ('fadd', 'a', 'b') */
   { .constant = {
      { nir_search_value_constant, -2 },
      nir_type_float, { 0x3ff0000000000000ull /* 1.0 */ },
   } },
   /* search104_1 -> 0 in the cache */
   /* search104_2 -> 1 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ffma,
      0, 1,
      { 297, 0, 1 },
      -1,
   } },

   /* replace104_0 -> 0 in the cache */
   /* replace104_1 -> 1 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fadd,
      0, 1,
      { 0, 1 },
      -1,
   } },

   /* ('ffmaz(nsz)', 1.0, 'a', 'b') => ('fadd', 'a', 'b') */
   /* search105_0 -> 275 in the cache */
   /* search105_1 -> 29 in the cache */
   /* search105_2 -> 48 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      true,
      false,
      false,
      nir_op_ffmaz,
      0, 1,
      { 275, 29, 48 },
      -1,
   } },

   /* replace105_0 -> 29 in the cache */
   /* replace105_1 -> 48 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fadd,
      0, 1,
      { 29, 48 },
      -1,
   } },

   /* ('ffma', -1.0, 'a', 'b') => ('fadd', ('fneg', 'a'), 'b') */
   { .constant = {
      { nir_search_value_constant, -2 },
      nir_type_float, { 0xbff0000000000000ull /* -1.0 */ },
   } },
   /* search106_1 -> 0 in the cache */
   /* search106_2 -> 1 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ffma,
      0, 1,
      { 302, 0, 1 },
      -1,
   } },

   /* replace106_0_0 -> 0 in the cache */
   /* replace106_0 -> 132 in the cache */
   /* replace106_1 -> 1 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fadd,
      0, 1,
      { 132, 1 },
      -1,
   } },

   /* ('ffmaz(nsz)', -1.0, 'a', 'b') => ('fadd', ('fneg', 'a'), 'b') */
   { .constant = {
      { nir_search_value_constant, 32 },
      nir_type_float, { 0xbff0000000000000ull /* -1.0 */ },
   } },
   /* search107_1 -> 29 in the cache */
   /* search107_2 -> 48 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      true,
      false,
      false,
      nir_op_ffmaz,
      0, 1,
      { 305, 29, 48 },
      -1,
   } },

   /* replace107_0_0 -> 29 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fneg,
      -1, 0,
      { 29 },
      -1,
   } },
   /* replace107_1 -> 48 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fadd,
      0, 1,
      { 307, 48 },
      -1,
   } },

   /* ('~ffma', '#a', '#b', 'c') => ('fadd', ('fmul', 'a', 'b'), 'c') */
   { .variable = {
      { nir_search_value_variable, -3 },
      0, /* a */
      true,
      nir_type_invalid,
      -1,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .variable = {
      { nir_search_value_variable, -3 },
      1, /* b */
      true,
      nir_type_invalid,
      -1,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   /* search108_2 -> 146 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      true,
      false,
      false,
      false,
      false,
      false,
      nir_op_ffma,
      0, 1,
      { 309, 310, 146 },
      -1,
   } },

   /* replace108_0_0 -> 143 in the cache */
   /* replace108_0_1 -> 144 in the cache */
   /* replace108_0 -> 145 in the cache */
   /* replace108_1 -> 146 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fadd,
      0, 2,
      { 145, 146 },
      -1,
   } },

   /* ('~ffmaz', '#a', '#b', 'c') => ('fadd', ('fmulz', 'a', 'b'), 'c') */
   { .variable = {
      { nir_search_value_variable, 32 },
      0, /* a */
      true,
      nir_type_invalid,
      -1,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   /* search109_1 -> 45 in the cache */
   /* search109_2 -> 152 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      true,
      false,
      false,
      false,
      false,
      false,
      nir_op_ffmaz,
      0, 1,
      { 313, 45, 152 },
      -1,
   } },

   /* replace109_0_0 -> 29 in the cache */
   /* replace109_0_1 -> 48 in the cache */
   /* replace109_0 -> 151 in the cache */
   /* replace109_1 -> 152 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fadd,
      0, 2,
      { 151, 152 },
      -1,
   } },

   /* ('~flrp', 'a', 'b', 0.0) => a */
   /* search110_0 -> 0 in the cache */
   /* search110_1 -> 1 in the cache */
   /* search110_2 -> 287 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      true,
      false,
      false,
      false,
      false,
      false,
      nir_op_flrp,
      -1, 0,
      { 0, 1, 287 },
      -1,
   } },

   /* replace110 -> 0 in the cache */

   /* ('~flrp', 'a', 'b', 1.0) => b */
   /* search111_0 -> 0 in the cache */
   /* search111_1 -> 1 in the cache */
   /* search111_2 -> 297 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      true,
      false,
      false,
      false,
      false,
      false,
      nir_op_flrp,
      -1, 0,
      { 0, 1, 297 },
      -1,
   } },

   /* replace111 -> 1 in the cache */

   /* ('~flrp', 'a', 'a', 'b') => a */
   /* search112_0 -> 0 in the cache */
   /* search112_1 -> 0 in the cache */
   /* search112_2 -> 1 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      true,
      false,
      false,
      false,
      false,
      false,
      nir_op_flrp,
      -1, 0,
      { 0, 0, 1 },
      -1,
   } },

   /* replace112 -> 0 in the cache */

   /* ('~flrp', 0.0, 'a', 'b') => ('fmul', 'a', 'b') */
   /* search113_0 -> 287 in the cache */
   /* search113_1 -> 0 in the cache */
   /* search113_2 -> 1 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      true,
      false,
      false,
      false,
      false,
      false,
      nir_op_flrp,
      -1, 0,
      { 287, 0, 1 },
      -1,
   } },

   /* replace113_0 -> 0 in the cache */
   /* replace113_1 -> 1 in the cache */
   /* replace113 -> 293 in the cache */

   /* ('~flrp', 'a', ('fadd(is_used_once)', 'a', 'b'), 'c') => ('fadd', ('fmul', 'b', 'c'), 'a') */
   /* search114_0 -> 143 in the cache */
   /* search114_1_0 -> 143 in the cache */
   /* search114_1_1 -> 144 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fadd,
      0, 1,
      { 143, 144 },
      0,
   } },
   /* search114_2 -> 146 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      true,
      false,
      false,
      false,
      false,
      false,
      nir_op_flrp,
      -1, 1,
      { 143, 320, 146 },
      -1,
   } },

   /* replace114_0_0 -> 144 in the cache */
   /* replace114_0_1 -> 146 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fmul,
      1, 1,
      { 144, 146 },
      -1,
   } },
   /* replace114_1 -> 143 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fadd,
      0, 2,
      { 322, 143 },
      -1,
   } },

   /* ('sdot_4x8_iadd', 'a', 0, 'b') => b */
   /* search115_0 -> 29 in the cache */
   /* search115_1 -> 139 in the cache */
   /* search115_2 -> 48 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_sdot_4x8_iadd,
      0, 1,
      { 29, 139, 48 },
      -1,
   } },

   /* replace115 -> 48 in the cache */

   /* ('udot_4x8_uadd', 'a', 0, 'b') => b */
   /* search116_0 -> 29 in the cache */
   /* search116_1 -> 139 in the cache */
   /* search116_2 -> 48 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_udot_4x8_uadd,
      0, 1,
      { 29, 139, 48 },
      -1,
   } },

   /* replace116 -> 48 in the cache */

   /* ('sdot_4x8_iadd_sat', 'a', 0, 'b') => b */
   /* search117_0 -> 29 in the cache */
   /* search117_1 -> 139 in the cache */
   /* search117_2 -> 48 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_sdot_4x8_iadd_sat,
      0, 1,
      { 29, 139, 48 },
      -1,
   } },

   /* replace117 -> 48 in the cache */

   /* ('udot_4x8_uadd_sat', 'a', 0, 'b') => b */
   /* search118_0 -> 29 in the cache */
   /* search118_1 -> 139 in the cache */
   /* search118_2 -> 48 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_udot_4x8_uadd_sat,
      0, 1,
      { 29, 139, 48 },
      -1,
   } },

   /* replace118 -> 48 in the cache */

   /* ('sdot_2x16_iadd', 'a', 0, 'b') => b */
   /* search119_0 -> 29 in the cache */
   /* search119_1 -> 139 in the cache */
   /* search119_2 -> 48 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_sdot_2x16_iadd,
      0, 1,
      { 29, 139, 48 },
      -1,
   } },

   /* replace119 -> 48 in the cache */

   /* ('udot_2x16_uadd', 'a', 0, 'b') => b */
   /* search120_0 -> 29 in the cache */
   /* search120_1 -> 139 in the cache */
   /* search120_2 -> 48 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_udot_2x16_uadd,
      0, 1,
      { 29, 139, 48 },
      -1,
   } },

   /* replace120 -> 48 in the cache */

   /* ('sdot_2x16_iadd_sat', 'a', 0, 'b') => b */
   /* search121_0 -> 29 in the cache */
   /* search121_1 -> 139 in the cache */
   /* search121_2 -> 48 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_sdot_2x16_iadd_sat,
      0, 1,
      { 29, 139, 48 },
      -1,
   } },

   /* replace121 -> 48 in the cache */

   /* ('udot_2x16_uadd_sat', 'a', 0, 'b') => b */
   /* search122_0 -> 29 in the cache */
   /* search122_1 -> 139 in the cache */
   /* search122_2 -> 48 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_udot_2x16_uadd_sat,
      0, 1,
      { 29, 139, 48 },
      -1,
   } },

   /* replace122 -> 48 in the cache */

   /* ('sudot_4x8_iadd', 'a', 0, 'b') => b */
   /* search123_0 -> 29 in the cache */
   /* search123_1 -> 139 in the cache */
   /* search123_2 -> 48 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_sudot_4x8_iadd,
      -1, 0,
      { 29, 139, 48 },
      -1,
   } },

   /* replace123 -> 48 in the cache */

   /* ('sudot_4x8_iadd', 0, 'a', 'b') => b */
   /* search124_0 -> 139 in the cache */
   /* search124_1 -> 29 in the cache */
   /* search124_2 -> 48 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_sudot_4x8_iadd,
      -1, 0,
      { 139, 29, 48 },
      -1,
   } },

   /* replace124 -> 48 in the cache */

   /* ('sudot_4x8_iadd_sat', 'a', 0, 'b') => b */
   /* search125_0 -> 29 in the cache */
   /* search125_1 -> 139 in the cache */
   /* search125_2 -> 48 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_sudot_4x8_iadd_sat,
      -1, 0,
      { 29, 139, 48 },
      -1,
   } },

   /* replace125 -> 48 in the cache */

   /* ('sudot_4x8_iadd_sat', 0, 'a', 'b') => b */
   /* search126_0 -> 139 in the cache */
   /* search126_1 -> 29 in the cache */
   /* search126_2 -> 48 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_sudot_4x8_iadd_sat,
      -1, 0,
      { 139, 29, 48 },
      -1,
   } },

   /* replace126 -> 48 in the cache */

   /* ('iadd', ('sdot_4x8_iadd(is_used_once)', 'a', 'b', '#c'), '#d') => ('sdot_4x8_iadd', 'a', 'b', ('iadd', 'c', 'd')) */
   /* search127_0_0 -> 29 in the cache */
   /* search127_0_1 -> 48 in the cache */
   { .variable = {
      { nir_search_value_variable, 32 },
      2, /* c */
      true,
      nir_type_invalid,
      -1,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_sdot_4x8_iadd,
      1, 1,
      { 29, 48, 336 },
      0,
   } },
   { .variable = {
      { nir_search_value_variable, 32 },
      3, /* d */
      true,
      nir_type_invalid,
      -1,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_iadd,
      0, 2,
      { 337, 338 },
      -1,
   } },

   /* replace127_0 -> 29 in the cache */
   /* replace127_1 -> 48 in the cache */
   /* replace127_2_0 -> 152 in the cache */
   /* replace127_2_1 -> 180 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_iadd,
      1, 1,
      { 152, 180 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_sdot_4x8_iadd,
      0, 2,
      { 29, 48, 340 },
      -1,
   } },

   /* ('iadd', ('udot_4x8_uadd(is_used_once)', 'a', 'b', '#c'), '#d') => ('udot_4x8_uadd', 'a', 'b', ('iadd', 'c', 'd')) */
   /* search128_0_0 -> 29 in the cache */
   /* search128_0_1 -> 48 in the cache */
   /* search128_0_2 -> 336 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_udot_4x8_uadd,
      1, 1,
      { 29, 48, 336 },
      0,
   } },
   /* search128_1 -> 338 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_iadd,
      0, 2,
      { 342, 338 },
      -1,
   } },

   /* replace128_0 -> 29 in the cache */
   /* replace128_1 -> 48 in the cache */
   /* replace128_2_0 -> 152 in the cache */
   /* replace128_2_1 -> 180 in the cache */
   /* replace128_2 -> 340 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_udot_4x8_uadd,
      0, 2,
      { 29, 48, 340 },
      -1,
   } },

   /* ('iadd', ('sudot_4x8_iadd(is_used_once)', 'a', 'b', '#c'), '#d') => ('sudot_4x8_iadd', 'a', 'b', ('iadd', 'c', 'd')) */
   /* search129_0_0 -> 29 in the cache */
   /* search129_0_1 -> 48 in the cache */
   /* search129_0_2 -> 336 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_sudot_4x8_iadd,
      -1, 0,
      { 29, 48, 336 },
      0,
   } },
   /* search129_1 -> 338 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_iadd,
      0, 1,
      { 345, 338 },
      -1,
   } },

   /* replace129_0 -> 29 in the cache */
   /* replace129_1 -> 48 in the cache */
   /* replace129_2_0 -> 152 in the cache */
   /* replace129_2_1 -> 180 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_iadd,
      0, 1,
      { 152, 180 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_sudot_4x8_iadd,
      -1, 1,
      { 29, 48, 347 },
      -1,
   } },

   /* ('iadd', ('sdot_2x16_iadd(is_used_once)', 'a', 'b', '#c'), '#d') => ('sdot_2x16_iadd', 'a', 'b', ('iadd', 'c', 'd')) */
   /* search130_0_0 -> 29 in the cache */
   /* search130_0_1 -> 48 in the cache */
   /* search130_0_2 -> 336 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_sdot_2x16_iadd,
      1, 1,
      { 29, 48, 336 },
      0,
   } },
   /* search130_1 -> 338 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_iadd,
      0, 2,
      { 349, 338 },
      -1,
   } },

   /* replace130_0 -> 29 in the cache */
   /* replace130_1 -> 48 in the cache */
   /* replace130_2_0 -> 152 in the cache */
   /* replace130_2_1 -> 180 in the cache */
   /* replace130_2 -> 340 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_sdot_2x16_iadd,
      0, 2,
      { 29, 48, 340 },
      -1,
   } },

   /* ('iadd', ('udot_2x16_uadd(is_used_once)', 'a', 'b', '#c'), '#d') => ('udot_2x16_uadd', 'a', 'b', ('iadd', 'c', 'd')) */
   /* search131_0_0 -> 29 in the cache */
   /* search131_0_1 -> 48 in the cache */
   /* search131_0_2 -> 336 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_udot_2x16_uadd,
      1, 1,
      { 29, 48, 336 },
      0,
   } },
   /* search131_1 -> 338 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_iadd,
      0, 2,
      { 352, 338 },
      -1,
   } },

   /* replace131_0 -> 29 in the cache */
   /* replace131_1 -> 48 in the cache */
   /* replace131_2_0 -> 152 in the cache */
   /* replace131_2_1 -> 180 in the cache */
   /* replace131_2 -> 340 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_udot_2x16_uadd,
      0, 2,
      { 29, 48, 340 },
      -1,
   } },

   /* ('iadd', ('sdot_4x8_iadd', 'a(is_not_const)', 'b', 0), 'c') => ('sdot_4x8_iadd', 'a', 'b', 'c') */
   { .variable = {
      { nir_search_value_variable, 32 },
      0, /* a */
      false,
      nir_type_invalid,
      6,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   /* search132_0_1 -> 48 in the cache */
   /* search132_0_2 -> 139 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_sdot_4x8_iadd,
      1, 1,
      { 355, 48, 139 },
      -1,
   } },
   /* search132_1 -> 152 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_iadd,
      0, 2,
      { 356, 152 },
      -1,
   } },

   /* replace132_0 -> 29 in the cache */
   /* replace132_1 -> 48 in the cache */
   /* replace132_2 -> 152 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_sdot_4x8_iadd,
      0, 1,
      { 29, 48, 152 },
      -1,
   } },

   /* ('iadd', ('udot_4x8_uadd', 'a(is_not_const)', 'b', 0), 'c') => ('udot_4x8_uadd', 'a', 'b', 'c') */
   /* search133_0_0 -> 355 in the cache */
   /* search133_0_1 -> 48 in the cache */
   /* search133_0_2 -> 139 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_udot_4x8_uadd,
      1, 1,
      { 355, 48, 139 },
      -1,
   } },
   /* search133_1 -> 152 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_iadd,
      0, 2,
      { 359, 152 },
      -1,
   } },

   /* replace133_0 -> 29 in the cache */
   /* replace133_1 -> 48 in the cache */
   /* replace133_2 -> 152 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_udot_4x8_uadd,
      0, 1,
      { 29, 48, 152 },
      -1,
   } },

   /* ('iadd', ('sudot_4x8_iadd', 'a(is_not_const)', 'b', 0), 'c') => ('sudot_4x8_iadd', 'a', 'b', 'c') */
   /* search134_0_0 -> 355 in the cache */
   /* search134_0_1 -> 48 in the cache */
   /* search134_0_2 -> 139 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_sudot_4x8_iadd,
      -1, 0,
      { 355, 48, 139 },
      -1,
   } },
   /* search134_1 -> 152 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_iadd,
      0, 1,
      { 362, 152 },
      -1,
   } },

   /* replace134_0 -> 29 in the cache */
   /* replace134_1 -> 48 in the cache */
   /* replace134_2 -> 152 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_sudot_4x8_iadd,
      -1, 0,
      { 29, 48, 152 },
      -1,
   } },

   /* ('iadd', ('sudot_4x8_iadd', 'a', 'b(is_not_const)', 0), 'c') => ('sudot_4x8_iadd', 'a', 'b', 'c') */
   /* search135_0_0 -> 29 in the cache */
   { .variable = {
      { nir_search_value_variable, 32 },
      1, /* b */
      false,
      nir_type_invalid,
      6,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   /* search135_0_2 -> 139 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_sudot_4x8_iadd,
      -1, 0,
      { 29, 365, 139 },
      -1,
   } },
   /* search135_1 -> 152 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_iadd,
      0, 1,
      { 366, 152 },
      -1,
   } },

   /* replace135_0 -> 29 in the cache */
   /* replace135_1 -> 48 in the cache */
   /* replace135_2 -> 152 in the cache */
   /* replace135 -> 364 in the cache */

   /* ('iadd', ('sdot_2x16_iadd', 'a(is_not_const)', 'b', 0), 'c') => ('sdot_2x16_iadd', 'a', 'b', 'c') */
   /* search136_0_0 -> 355 in the cache */
   /* search136_0_1 -> 48 in the cache */
   /* search136_0_2 -> 139 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_sdot_2x16_iadd,
      1, 1,
      { 355, 48, 139 },
      -1,
   } },
   /* search136_1 -> 152 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_iadd,
      0, 2,
      { 368, 152 },
      -1,
   } },

   /* replace136_0 -> 29 in the cache */
   /* replace136_1 -> 48 in the cache */
   /* replace136_2 -> 152 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_sdot_2x16_iadd,
      0, 1,
      { 29, 48, 152 },
      -1,
   } },

   /* ('iadd', ('udot_2x16_uadd', 'a(is_not_const)', 'b', 0), 'c') => ('udot_2x16_uadd', 'a', 'b', 'c') */
   /* search137_0_0 -> 355 in the cache */
   /* search137_0_1 -> 48 in the cache */
   /* search137_0_2 -> 139 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_udot_2x16_uadd,
      1, 1,
      { 355, 48, 139 },
      -1,
   } },
   /* search137_1 -> 152 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_iadd,
      0, 2,
      { 371, 152 },
      -1,
   } },

   /* replace137_0 -> 29 in the cache */
   /* replace137_1 -> 48 in the cache */
   /* replace137_2 -> 152 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_udot_2x16_uadd,
      0, 1,
      { 29, 48, 152 },
      -1,
   } },

   /* ('sdot_4x8_iadd', '#a', '#b', 'c(is_not_const)') => ('iadd', ('sdot_4x8_iadd', 'a', 'b', 0), 'c') */
   /* search138_0 -> 313 in the cache */
   /* search138_1 -> 45 in the cache */
   { .variable = {
      { nir_search_value_variable, 32 },
      2, /* c */
      false,
      nir_type_invalid,
      6,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_sdot_4x8_iadd,
      0, 1,
      { 313, 45, 374 },
      -1,
   } },

   /* replace138_0_0 -> 29 in the cache */
   /* replace138_0_1 -> 48 in the cache */
   /* replace138_0_2 -> 139 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_sdot_4x8_iadd,
      1, 1,
      { 29, 48, 139 },
      -1,
   } },
   /* replace138_1 -> 152 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_iadd,
      0, 2,
      { 376, 152 },
      -1,
   } },

   /* ('udot_4x8_uadd', '#a', '#b', 'c(is_not_const)') => ('iadd', ('udot_4x8_uadd', 'a', 'b', 0), 'c') */
   /* search139_0 -> 313 in the cache */
   /* search139_1 -> 45 in the cache */
   /* search139_2 -> 374 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_udot_4x8_uadd,
      0, 1,
      { 313, 45, 374 },
      -1,
   } },

   /* replace139_0_0 -> 29 in the cache */
   /* replace139_0_1 -> 48 in the cache */
   /* replace139_0_2 -> 139 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_udot_4x8_uadd,
      1, 1,
      { 29, 48, 139 },
      -1,
   } },
   /* replace139_1 -> 152 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_iadd,
      0, 2,
      { 379, 152 },
      -1,
   } },

   /* ('sudot_4x8_iadd', '#a', '#b', 'c(is_not_const)') => ('iadd', ('sudot_4x8_iadd', 'a', 'b', 0), 'c') */
   /* search140_0 -> 313 in the cache */
   /* search140_1 -> 45 in the cache */
   /* search140_2 -> 374 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_sudot_4x8_iadd,
      -1, 0,
      { 313, 45, 374 },
      -1,
   } },

   /* replace140_0_0 -> 29 in the cache */
   /* replace140_0_1 -> 48 in the cache */
   /* replace140_0_2 -> 139 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_sudot_4x8_iadd,
      -1, 0,
      { 29, 48, 139 },
      -1,
   } },
   /* replace140_1 -> 152 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_iadd,
      0, 1,
      { 382, 152 },
      -1,
   } },

   /* ('sdot_2x16_iadd', '#a', '#b', 'c(is_not_const)') => ('iadd', ('sdot_2x16_iadd', 'a', 'b', 0), 'c') */
   /* search141_0 -> 313 in the cache */
   /* search141_1 -> 45 in the cache */
   /* search141_2 -> 374 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_sdot_2x16_iadd,
      0, 1,
      { 313, 45, 374 },
      -1,
   } },

   /* replace141_0_0 -> 29 in the cache */
   /* replace141_0_1 -> 48 in the cache */
   /* replace141_0_2 -> 139 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_sdot_2x16_iadd,
      1, 1,
      { 29, 48, 139 },
      -1,
   } },
   /* replace141_1 -> 152 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_iadd,
      0, 2,
      { 385, 152 },
      -1,
   } },

   /* ('udot_2x16_uadd', '#a', '#b', 'c(is_not_const)') => ('iadd', ('udot_2x16_uadd', 'a', 'b', 0), 'c') */
   /* search142_0 -> 313 in the cache */
   /* search142_1 -> 45 in the cache */
   /* search142_2 -> 374 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_udot_2x16_uadd,
      0, 1,
      { 313, 45, 374 },
      -1,
   } },

   /* replace142_0_0 -> 29 in the cache */
   /* replace142_0_1 -> 48 in the cache */
   /* replace142_0_2 -> 139 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_udot_2x16_uadd,
      1, 1,
      { 29, 48, 139 },
      -1,
   } },
   /* replace142_1 -> 152 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_iadd,
      0, 2,
      { 388, 152 },
      -1,
   } },

   /* ('sdot_4x8_iadd_sat', '#a', '#b', 'c(is_not_const)') => ('iadd_sat', ('sdot_4x8_iadd', 'a', 'b', 0), 'c') */
   /* search143_0 -> 313 in the cache */
   /* search143_1 -> 45 in the cache */
   /* search143_2 -> 374 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_sdot_4x8_iadd_sat,
      0, 1,
      { 313, 45, 374 },
      -1,
   } },

   /* replace143_0_0 -> 29 in the cache */
   /* replace143_0_1 -> 48 in the cache */
   /* replace143_0_2 -> 139 in the cache */
   /* replace143_0 -> 376 in the cache */
   /* replace143_1 -> 152 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_iadd_sat,
      0, 2,
      { 376, 152 },
      -1,
   } },

   /* ('udot_4x8_uadd_sat', '#a', '#b', 'c(is_not_const)') => ('uadd_sat', ('udot_4x8_uadd', 'a', 'b', 0), 'c') */
   /* search144_0 -> 313 in the cache */
   /* search144_1 -> 45 in the cache */
   /* search144_2 -> 374 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_udot_4x8_uadd_sat,
      0, 1,
      { 313, 45, 374 },
      -1,
   } },

   /* replace144_0_0 -> 29 in the cache */
   /* replace144_0_1 -> 48 in the cache */
   /* replace144_0_2 -> 139 in the cache */
   /* replace144_0 -> 379 in the cache */
   /* replace144_1 -> 152 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_uadd_sat,
      0, 2,
      { 379, 152 },
      -1,
   } },

   /* ('sudot_4x8_iadd_sat', '#a', '#b', 'c(is_not_const)') => ('iadd_sat', ('sudot_4x8_iadd', 'a', 'b', 0), 'c') */
   /* search145_0 -> 313 in the cache */
   /* search145_1 -> 45 in the cache */
   /* search145_2 -> 374 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_sudot_4x8_iadd_sat,
      -1, 0,
      { 313, 45, 374 },
      -1,
   } },

   /* replace145_0_0 -> 29 in the cache */
   /* replace145_0_1 -> 48 in the cache */
   /* replace145_0_2 -> 139 in the cache */
   /* replace145_0 -> 382 in the cache */
   /* replace145_1 -> 152 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_iadd_sat,
      0, 1,
      { 382, 152 },
      -1,
   } },

   /* ('sdot_2x16_iadd_sat', '#a', '#b', 'c(is_not_const)') => ('iadd_sat', ('sdot_2x16_iadd', 'a', 'b', 0), 'c') */
   /* search146_0 -> 313 in the cache */
   /* search146_1 -> 45 in the cache */
   /* search146_2 -> 374 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_sdot_2x16_iadd_sat,
      0, 1,
      { 313, 45, 374 },
      -1,
   } },

   /* replace146_0_0 -> 29 in the cache */
   /* replace146_0_1 -> 48 in the cache */
   /* replace146_0_2 -> 139 in the cache */
   /* replace146_0 -> 385 in the cache */
   /* replace146_1 -> 152 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_iadd_sat,
      0, 2,
      { 385, 152 },
      -1,
   } },

   /* ('udot_2x16_uadd_sat', '#a', '#b', 'c(is_not_const)') => ('uadd_sat', ('udot_2x16_uadd', 'a', 'b', 0), 'c') */
   /* search147_0 -> 313 in the cache */
   /* search147_1 -> 45 in the cache */
   /* search147_2 -> 374 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_udot_2x16_uadd_sat,
      0, 1,
      { 313, 45, 374 },
      -1,
   } },

   /* replace147_0_0 -> 29 in the cache */
   /* replace147_0_1 -> 48 in the cache */
   /* replace147_0_2 -> 139 in the cache */
   /* replace147_0 -> 388 in the cache */
   /* replace147_1 -> 152 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_uadd_sat,
      0, 2,
      { 388, 152 },
      -1,
   } },

   /* ('fmul@32(nsz)', ('bcsel', ('feq', 'b', 0.0, 'ignore_exact'), 0.0, ('fneg', ('fabs', 'a'))), ('bcsel', ('feq', 'a', 0.0, 'ignore_exact'), 0.0, ('fneg', ('fabs', 'b')))) => ('fmulz', ('fneg', ('fabs', 'a')), ('fneg', ('fabs', 'b'))) */
   { .variable = {
      { nir_search_value_variable, 32 },
      0, /* b */
      false,
      nir_type_invalid,
      -1,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   /* search148_0_0_1 -> 255 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      true,
      false,
      false,
      false,
      nir_op_feq,
      1, 1,
      { 400, 255 },
      -1,
   } },
   /* search148_0_1 -> 255 in the cache */
   /* search148_0_2_0_0 -> 200 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fabs,
      -1, 0,
      { 200 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fneg,
      -1, 0,
      { 402 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_bcsel,
      -1, 1,
      { 401, 255, 403 },
      -1,
   } },
   /* search148_1_0_0 -> 200 in the cache */
   /* search148_1_0_1 -> 255 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      true,
      false,
      false,
      false,
      nir_op_feq,
      2, 1,
      { 200, 255 },
      -1,
   } },
   /* search148_1_1 -> 255 in the cache */
   /* search148_1_2_0_0 -> 400 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fabs,
      -1, 0,
      { 400 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fneg,
      -1, 0,
      { 406 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_bcsel,
      -1, 1,
      { 405, 255, 407 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      true,
      false,
      false,
      nir_op_fmul,
      0, 3,
      { 404, 408 },
      -1,
   } },

   /* replace148_0_0_0 -> 200 in the cache */
   /* replace148_0_0 -> 402 in the cache */
   /* replace148_0 -> 403 in the cache */
   /* replace148_1_0_0 -> 400 in the cache */
   /* replace148_1_0 -> 406 in the cache */
   /* replace148_1 -> 407 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fmulz,
      0, 1,
      { 403, 407 },
      -1,
   } },

   /* ('fmul@32(nsz)', ('bcsel', ('feq', 'b', 0.0, 'ignore_exact'), 0.0, ('fneg', ('fabs', 'a'))), ('bcsel', ('feq', 'a', 0.0, 'ignore_exact'), 0.0, ('fabs', 'b'))) => ('fmulz', ('fneg', ('fabs', 'a')), ('fabs', 'b')) */
   /* search149_0_0_0 -> 400 in the cache */
   /* search149_0_0_1 -> 255 in the cache */
   /* search149_0_0 -> 401 in the cache */
   /* search149_0_1 -> 255 in the cache */
   /* search149_0_2_0_0 -> 200 in the cache */
   /* search149_0_2_0 -> 402 in the cache */
   /* search149_0_2 -> 403 in the cache */
   /* search149_0 -> 404 in the cache */
   /* search149_1_0_0 -> 200 in the cache */
   /* search149_1_0_1 -> 255 in the cache */
   /* search149_1_0 -> 405 in the cache */
   /* search149_1_1 -> 255 in the cache */
   /* search149_1_2_0 -> 400 in the cache */
   /* search149_1_2 -> 406 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_bcsel,
      -1, 1,
      { 405, 255, 406 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      true,
      false,
      false,
      nir_op_fmul,
      0, 3,
      { 404, 411 },
      -1,
   } },

   /* replace149_0_0_0 -> 200 in the cache */
   /* replace149_0_0 -> 402 in the cache */
   /* replace149_0 -> 403 in the cache */
   /* replace149_1_0 -> 400 in the cache */
   /* replace149_1 -> 406 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fmulz,
      0, 1,
      { 403, 406 },
      -1,
   } },

   /* ('fmul@32(nsz)', ('bcsel', ('feq', 'b', 0.0, 'ignore_exact'), 0.0, ('fneg', ('fabs', 'a'))), ('bcsel', ('feq', 'a', 0.0, 'ignore_exact'), 0.0, ('fneg', 'b'))) => ('fmulz', ('fneg', ('fabs', 'a')), ('fneg', 'b')) */
   /* search150_0_0_0 -> 400 in the cache */
   /* search150_0_0_1 -> 255 in the cache */
   /* search150_0_0 -> 401 in the cache */
   /* search150_0_1 -> 255 in the cache */
   /* search150_0_2_0_0 -> 200 in the cache */
   /* search150_0_2_0 -> 402 in the cache */
   /* search150_0_2 -> 403 in the cache */
   /* search150_0 -> 404 in the cache */
   /* search150_1_0_0 -> 200 in the cache */
   /* search150_1_0_1 -> 255 in the cache */
   /* search150_1_0 -> 405 in the cache */
   /* search150_1_1 -> 255 in the cache */
   /* search150_1_2_0 -> 400 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fneg,
      -1, 0,
      { 400 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_bcsel,
      -1, 1,
      { 405, 255, 414 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      true,
      false,
      false,
      nir_op_fmul,
      0, 3,
      { 404, 415 },
      -1,
   } },

   /* replace150_0_0_0 -> 200 in the cache */
   /* replace150_0_0 -> 402 in the cache */
   /* replace150_0 -> 403 in the cache */
   /* replace150_1_0 -> 400 in the cache */
   /* replace150_1 -> 414 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fmulz,
      0, 1,
      { 403, 414 },
      -1,
   } },

   /* ('fmul@32(nsz)', ('bcsel', ('feq', 'b', 0.0, 'ignore_exact'), 0.0, ('fneg', ('fabs', 'a'))), ('bcsel', ('feq', 'a', 0.0, 'ignore_exact'), 0.0, 'b')) => ('fmulz', ('fneg', ('fabs', 'a')), 'b') */
   /* search151_0_0_0 -> 400 in the cache */
   /* search151_0_0_1 -> 255 in the cache */
   /* search151_0_0 -> 401 in the cache */
   /* search151_0_1 -> 255 in the cache */
   /* search151_0_2_0_0 -> 200 in the cache */
   /* search151_0_2_0 -> 402 in the cache */
   /* search151_0_2 -> 403 in the cache */
   /* search151_0 -> 404 in the cache */
   /* search151_1_0_0 -> 200 in the cache */
   /* search151_1_0_1 -> 255 in the cache */
   /* search151_1_0 -> 405 in the cache */
   /* search151_1_1 -> 255 in the cache */
   /* search151_1_2 -> 400 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_bcsel,
      -1, 1,
      { 405, 255, 400 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      true,
      false,
      false,
      nir_op_fmul,
      0, 3,
      { 404, 418 },
      -1,
   } },

   /* replace151_0_0_0 -> 200 in the cache */
   /* replace151_0_0 -> 402 in the cache */
   /* replace151_0 -> 403 in the cache */
   /* replace151_1 -> 400 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fmulz,
      0, 1,
      { 403, 400 },
      -1,
   } },

   /* ('fmul@32(nsz)', ('bcsel', ('feq', 'b', 0.0, 'ignore_exact'), 0.0, ('fabs', 'a')), ('bcsel', ('feq', 'a', 0.0, 'ignore_exact'), 0.0, ('fabs', 'b'))) => ('fmulz', ('fabs', 'a'), ('fabs', 'b')) */
   /* search152_0_0_0 -> 400 in the cache */
   /* search152_0_0_1 -> 255 in the cache */
   /* search152_0_0 -> 401 in the cache */
   /* search152_0_1 -> 255 in the cache */
   /* search152_0_2_0 -> 200 in the cache */
   /* search152_0_2 -> 402 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_bcsel,
      -1, 1,
      { 401, 255, 402 },
      -1,
   } },
   /* search152_1_0_0 -> 200 in the cache */
   /* search152_1_0_1 -> 255 in the cache */
   /* search152_1_0 -> 405 in the cache */
   /* search152_1_1 -> 255 in the cache */
   /* search152_1_2_0 -> 400 in the cache */
   /* search152_1_2 -> 406 in the cache */
   /* search152_1 -> 411 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      true,
      false,
      false,
      nir_op_fmul,
      0, 3,
      { 421, 411 },
      -1,
   } },

   /* replace152_0_0 -> 200 in the cache */
   /* replace152_0 -> 402 in the cache */
   /* replace152_1_0 -> 400 in the cache */
   /* replace152_1 -> 406 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fmulz,
      0, 1,
      { 402, 406 },
      -1,
   } },

   /* ('fmul@32(nsz)', ('bcsel', ('feq', 'b', 0.0, 'ignore_exact'), 0.0, ('fabs', 'a')), ('bcsel', ('feq', 'a', 0.0, 'ignore_exact'), 0.0, ('fneg', 'b'))) => ('fmulz', ('fabs', 'a'), ('fneg', 'b')) */
   /* search153_0_0_0 -> 400 in the cache */
   /* search153_0_0_1 -> 255 in the cache */
   /* search153_0_0 -> 401 in the cache */
   /* search153_0_1 -> 255 in the cache */
   /* search153_0_2_0 -> 200 in the cache */
   /* search153_0_2 -> 402 in the cache */
   /* search153_0 -> 421 in the cache */
   /* search153_1_0_0 -> 200 in the cache */
   /* search153_1_0_1 -> 255 in the cache */
   /* search153_1_0 -> 405 in the cache */
   /* search153_1_1 -> 255 in the cache */
   /* search153_1_2_0 -> 400 in the cache */
   /* search153_1_2 -> 414 in the cache */
   /* search153_1 -> 415 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      true,
      false,
      false,
      nir_op_fmul,
      0, 3,
      { 421, 415 },
      -1,
   } },

   /* replace153_0_0 -> 200 in the cache */
   /* replace153_0 -> 402 in the cache */
   /* replace153_1_0 -> 400 in the cache */
   /* replace153_1 -> 414 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fmulz,
      0, 1,
      { 402, 414 },
      -1,
   } },

   /* ('fmul@32(nsz)', ('bcsel', ('feq', 'b', 0.0, 'ignore_exact'), 0.0, ('fabs', 'a')), ('bcsel', ('feq', 'a', 0.0, 'ignore_exact'), 0.0, 'b')) => ('fmulz', ('fabs', 'a'), 'b') */
   /* search154_0_0_0 -> 400 in the cache */
   /* search154_0_0_1 -> 255 in the cache */
   /* search154_0_0 -> 401 in the cache */
   /* search154_0_1 -> 255 in the cache */
   /* search154_0_2_0 -> 200 in the cache */
   /* search154_0_2 -> 402 in the cache */
   /* search154_0 -> 421 in the cache */
   /* search154_1_0_0 -> 200 in the cache */
   /* search154_1_0_1 -> 255 in the cache */
   /* search154_1_0 -> 405 in the cache */
   /* search154_1_1 -> 255 in the cache */
   /* search154_1_2 -> 400 in the cache */
   /* search154_1 -> 418 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      true,
      false,
      false,
      nir_op_fmul,
      0, 3,
      { 421, 418 },
      -1,
   } },

   /* replace154_0_0 -> 200 in the cache */
   /* replace154_0 -> 402 in the cache */
   /* replace154_1 -> 400 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fmulz,
      0, 1,
      { 402, 400 },
      -1,
   } },

   /* ('fmul@32(nsz)', ('bcsel', ('feq', 'b', 0.0, 'ignore_exact'), 0.0, ('fneg', 'a')), ('bcsel', ('feq', 'a', 0.0, 'ignore_exact'), 0.0, ('fneg', 'b'))) => ('fmulz', ('fneg', 'a'), ('fneg', 'b')) */
   /* search155_0_0_0 -> 400 in the cache */
   /* search155_0_0_1 -> 255 in the cache */
   /* search155_0_0 -> 401 in the cache */
   /* search155_0_1 -> 255 in the cache */
   /* search155_0_2_0 -> 200 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fneg,
      -1, 0,
      { 200 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_bcsel,
      -1, 1,
      { 401, 255, 428 },
      -1,
   } },
   /* search155_1_0_0 -> 200 in the cache */
   /* search155_1_0_1 -> 255 in the cache */
   /* search155_1_0 -> 405 in the cache */
   /* search155_1_1 -> 255 in the cache */
   /* search155_1_2_0 -> 400 in the cache */
   /* search155_1_2 -> 414 in the cache */
   /* search155_1 -> 415 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      true,
      false,
      false,
      nir_op_fmul,
      0, 3,
      { 429, 415 },
      -1,
   } },

   /* replace155_0_0 -> 200 in the cache */
   /* replace155_0 -> 428 in the cache */
   /* replace155_1_0 -> 400 in the cache */
   /* replace155_1 -> 414 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fmulz,
      0, 1,
      { 428, 414 },
      -1,
   } },

   /* ('fmul@32(nsz)', ('bcsel', ('feq', 'b', 0.0, 'ignore_exact'), 0.0, ('fneg', 'a')), ('bcsel', ('feq', 'a', 0.0, 'ignore_exact'), 0.0, 'b')) => ('fmulz', ('fneg', 'a'), 'b') */
   /* search156_0_0_0 -> 400 in the cache */
   /* search156_0_0_1 -> 255 in the cache */
   /* search156_0_0 -> 401 in the cache */
   /* search156_0_1 -> 255 in the cache */
   /* search156_0_2_0 -> 200 in the cache */
   /* search156_0_2 -> 428 in the cache */
   /* search156_0 -> 429 in the cache */
   /* search156_1_0_0 -> 200 in the cache */
   /* search156_1_0_1 -> 255 in the cache */
   /* search156_1_0 -> 405 in the cache */
   /* search156_1_1 -> 255 in the cache */
   /* search156_1_2 -> 400 in the cache */
   /* search156_1 -> 418 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      true,
      false,
      false,
      nir_op_fmul,
      0, 3,
      { 429, 418 },
      -1,
   } },

   /* replace156_0_0 -> 200 in the cache */
   /* replace156_0 -> 428 in the cache */
   /* replace156_1 -> 400 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fmulz,
      0, 1,
      { 428, 400 },
      -1,
   } },

   /* ('fmul@32(nsz)', ('bcsel', ('feq', 'b', 0.0, 'ignore_exact'), 0.0, 'a'), ('bcsel', ('feq', 'a', 0.0, 'ignore_exact'), 0.0, 'b')) => ('fmulz', 'a', 'b') */
   /* search157_0_0_0 -> 400 in the cache */
   /* search157_0_0_1 -> 255 in the cache */
   /* search157_0_0 -> 401 in the cache */
   /* search157_0_1 -> 255 in the cache */
   /* search157_0_2 -> 200 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_bcsel,
      -1, 1,
      { 401, 255, 200 },
      -1,
   } },
   /* search157_1_0_0 -> 200 in the cache */
   /* search157_1_0_1 -> 255 in the cache */
   /* search157_1_0 -> 405 in the cache */
   /* search157_1_1 -> 255 in the cache */
   /* search157_1_2 -> 400 in the cache */
   /* search157_1 -> 418 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      true,
      false,
      false,
      nir_op_fmul,
      0, 3,
      { 434, 418 },
      -1,
   } },

   /* replace157_0 -> 200 in the cache */
   /* replace157_1 -> 400 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fmulz,
      0, 1,
      { 200, 400 },
      -1,
   } },

   /* ('fmul@32(nsz)', ('fneg', ('fabs', 'a')), ('bcsel', ('feq', 'a', 0.0, 'ignore_exact'), 0.0, '#b(is_not_const_zero)')) => ('fmulz', ('fneg', ('fabs', 'a')), 'b') */
   /* search158_0_0_0 -> 29 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fabs,
      -1, 0,
      { 29 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fneg,
      -1, 0,
      { 437 },
      -1,
   } },
   /* search158_1_0_0 -> 29 in the cache */
   /* search158_1_0_1 -> 255 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      true,
      false,
      false,
      false,
      nir_op_feq,
      1, 1,
      { 29, 255 },
      -1,
   } },
   /* search158_1_1 -> 255 in the cache */
   { .variable = {
      { nir_search_value_variable, 32 },
      1, /* b */
      true,
      nir_type_invalid,
      7,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_bcsel,
      -1, 1,
      { 439, 255, 440 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      true,
      false,
      false,
      nir_op_fmul,
      0, 2,
      { 438, 441 },
      -1,
   } },

   /* replace158_0_0_0 -> 29 in the cache */
   /* replace158_0_0 -> 437 in the cache */
   /* replace158_0 -> 438 in the cache */
   /* replace158_1 -> 48 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fmulz,
      0, 1,
      { 438, 48 },
      -1,
   } },

   /* ('fmul@32(nsz)', ('fabs', 'a'), ('bcsel', ('feq', 'a', 0.0, 'ignore_exact'), 0.0, '#b(is_not_const_zero)')) => ('fmulz', ('fabs', 'a'), 'b') */
   /* search159_0_0 -> 29 in the cache */
   /* search159_0 -> 437 in the cache */
   /* search159_1_0_0 -> 29 in the cache */
   /* search159_1_0_1 -> 255 in the cache */
   /* search159_1_0 -> 439 in the cache */
   /* search159_1_1 -> 255 in the cache */
   /* search159_1_2 -> 440 in the cache */
   /* search159_1 -> 441 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      true,
      false,
      false,
      nir_op_fmul,
      0, 2,
      { 437, 441 },
      -1,
   } },

   /* replace159_0_0 -> 29 in the cache */
   /* replace159_0 -> 437 in the cache */
   /* replace159_1 -> 48 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fmulz,
      0, 1,
      { 437, 48 },
      -1,
   } },

   /* ('fmul@32(nsz)', ('fneg', 'a'), ('bcsel', ('feq', 'a', 0.0, 'ignore_exact'), 0.0, '#b(is_not_const_zero)')) => ('fmulz', ('fneg', 'a'), 'b') */
   /* search160_0_0 -> 29 in the cache */
   /* search160_0 -> 307 in the cache */
   /* search160_1_0_0 -> 29 in the cache */
   /* search160_1_0_1 -> 255 in the cache */
   /* search160_1_0 -> 439 in the cache */
   /* search160_1_1 -> 255 in the cache */
   /* search160_1_2 -> 440 in the cache */
   /* search160_1 -> 441 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      true,
      false,
      false,
      nir_op_fmul,
      0, 2,
      { 307, 441 },
      -1,
   } },

   /* replace160_0_0 -> 29 in the cache */
   /* replace160_0 -> 307 in the cache */
   /* replace160_1 -> 48 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fmulz,
      0, 1,
      { 307, 48 },
      -1,
   } },

   /* ('fmul@32(nsz)', 'a', ('bcsel', ('feq', 'a', 0.0, 'ignore_exact'), 0.0, '#b(is_not_const_zero)')) => ('fmulz', 'a', 'b') */
   /* search161_0 -> 29 in the cache */
   /* search161_1_0_0 -> 29 in the cache */
   /* search161_1_0_1 -> 255 in the cache */
   /* search161_1_0 -> 439 in the cache */
   /* search161_1_1 -> 255 in the cache */
   /* search161_1_2 -> 440 in the cache */
   /* search161_1 -> 441 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      true,
      false,
      false,
      nir_op_fmul,
      0, 2,
      { 29, 441 },
      -1,
   } },

   /* replace161_0 -> 29 in the cache */
   /* replace161_1 -> 48 in the cache */
   /* replace161 -> 296 in the cache */

   /* ('ffma@32(nsz)', ('bcsel', ('feq', 'b', 0.0, 'ignore_exact'), 0.0, ('fneg', ('fabs', 'a'))), ('bcsel', ('feq', 'a', 0.0, 'ignore_exact'), 0.0, ('fneg', ('fabs', 'b'))), 'c') => ('ffmaz', ('fneg', ('fabs', 'a')), ('fneg', ('fabs', 'b')), 'c') */
   /* search162_0_0_0 -> 400 in the cache */
   /* search162_0_0_1 -> 255 in the cache */
   /* search162_0_0 -> 401 in the cache */
   /* search162_0_1 -> 255 in the cache */
   /* search162_0_2_0_0 -> 200 in the cache */
   /* search162_0_2_0 -> 402 in the cache */
   /* search162_0_2 -> 403 in the cache */
   /* search162_0 -> 404 in the cache */
   /* search162_1_0_0 -> 200 in the cache */
   /* search162_1_0_1 -> 255 in the cache */
   /* search162_1_0 -> 405 in the cache */
   /* search162_1_1 -> 255 in the cache */
   /* search162_1_2_0_0 -> 400 in the cache */
   /* search162_1_2_0 -> 406 in the cache */
   /* search162_1_2 -> 407 in the cache */
   /* search162_1 -> 408 in the cache */
   /* search162_2 -> 152 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      true,
      false,
      false,
      nir_op_ffma,
      0, 3,
      { 404, 408, 152 },
      -1,
   } },

   /* replace162_0_0_0 -> 200 in the cache */
   /* replace162_0_0 -> 402 in the cache */
   /* replace162_0 -> 403 in the cache */
   /* replace162_1_0_0 -> 400 in the cache */
   /* replace162_1_0 -> 406 in the cache */
   /* replace162_1 -> 407 in the cache */
   /* replace162_2 -> 152 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ffmaz,
      0, 1,
      { 403, 407, 152 },
      -1,
   } },

   /* ('ffma@32(nsz)', ('bcsel', ('feq', 'b', 0.0, 'ignore_exact'), 0.0, ('fneg', ('fabs', 'a'))), ('bcsel', ('feq', 'a', 0.0, 'ignore_exact'), 0.0, ('fabs', 'b')), 'c') => ('ffmaz', ('fneg', ('fabs', 'a')), ('fabs', 'b'), 'c') */
   /* search163_0_0_0 -> 400 in the cache */
   /* search163_0_0_1 -> 255 in the cache */
   /* search163_0_0 -> 401 in the cache */
   /* search163_0_1 -> 255 in the cache */
   /* search163_0_2_0_0 -> 200 in the cache */
   /* search163_0_2_0 -> 402 in the cache */
   /* search163_0_2 -> 403 in the cache */
   /* search163_0 -> 404 in the cache */
   /* search163_1_0_0 -> 200 in the cache */
   /* search163_1_0_1 -> 255 in the cache */
   /* search163_1_0 -> 405 in the cache */
   /* search163_1_1 -> 255 in the cache */
   /* search163_1_2_0 -> 400 in the cache */
   /* search163_1_2 -> 406 in the cache */
   /* search163_1 -> 411 in the cache */
   /* search163_2 -> 152 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      true,
      false,
      false,
      nir_op_ffma,
      0, 3,
      { 404, 411, 152 },
      -1,
   } },

   /* replace163_0_0_0 -> 200 in the cache */
   /* replace163_0_0 -> 402 in the cache */
   /* replace163_0 -> 403 in the cache */
   /* replace163_1_0 -> 400 in the cache */
   /* replace163_1 -> 406 in the cache */
   /* replace163_2 -> 152 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ffmaz,
      0, 1,
      { 403, 406, 152 },
      -1,
   } },

   /* ('ffma@32(nsz)', ('bcsel', ('feq', 'b', 0.0, 'ignore_exact'), 0.0, ('fneg', ('fabs', 'a'))), ('bcsel', ('feq', 'a', 0.0, 'ignore_exact'), 0.0, ('fneg', 'b')), 'c') => ('ffmaz', ('fneg', ('fabs', 'a')), ('fneg', 'b'), 'c') */
   /* search164_0_0_0 -> 400 in the cache */
   /* search164_0_0_1 -> 255 in the cache */
   /* search164_0_0 -> 401 in the cache */
   /* search164_0_1 -> 255 in the cache */
   /* search164_0_2_0_0 -> 200 in the cache */
   /* search164_0_2_0 -> 402 in the cache */
   /* search164_0_2 -> 403 in the cache */
   /* search164_0 -> 404 in the cache */
   /* search164_1_0_0 -> 200 in the cache */
   /* search164_1_0_1 -> 255 in the cache */
   /* search164_1_0 -> 405 in the cache */
   /* search164_1_1 -> 255 in the cache */
   /* search164_1_2_0 -> 400 in the cache */
   /* search164_1_2 -> 414 in the cache */
   /* search164_1 -> 415 in the cache */
   /* search164_2 -> 152 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      true,
      false,
      false,
      nir_op_ffma,
      0, 3,
      { 404, 415, 152 },
      -1,
   } },

   /* replace164_0_0_0 -> 200 in the cache */
   /* replace164_0_0 -> 402 in the cache */
   /* replace164_0 -> 403 in the cache */
   /* replace164_1_0 -> 400 in the cache */
   /* replace164_1 -> 414 in the cache */
   /* replace164_2 -> 152 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ffmaz,
      0, 1,
      { 403, 414, 152 },
      -1,
   } },

   /* ('ffma@32(nsz)', ('bcsel', ('feq', 'b', 0.0, 'ignore_exact'), 0.0, ('fneg', ('fabs', 'a'))), ('bcsel', ('feq', 'a', 0.0, 'ignore_exact'), 0.0, 'b'), 'c') => ('ffmaz', ('fneg', ('fabs', 'a')), 'b', 'c') */
   /* search165_0_0_0 -> 400 in the cache */
   /* search165_0_0_1 -> 255 in the cache */
   /* search165_0_0 -> 401 in the cache */
   /* search165_0_1 -> 255 in the cache */
   /* search165_0_2_0_0 -> 200 in the cache */
   /* search165_0_2_0 -> 402 in the cache */
   /* search165_0_2 -> 403 in the cache */
   /* search165_0 -> 404 in the cache */
   /* search165_1_0_0 -> 200 in the cache */
   /* search165_1_0_1 -> 255 in the cache */
   /* search165_1_0 -> 405 in the cache */
   /* search165_1_1 -> 255 in the cache */
   /* search165_1_2 -> 400 in the cache */
   /* search165_1 -> 418 in the cache */
   /* search165_2 -> 152 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      true,
      false,
      false,
      nir_op_ffma,
      0, 3,
      { 404, 418, 152 },
      -1,
   } },

   /* replace165_0_0_0 -> 200 in the cache */
   /* replace165_0_0 -> 402 in the cache */
   /* replace165_0 -> 403 in the cache */
   /* replace165_1 -> 400 in the cache */
   /* replace165_2 -> 152 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ffmaz,
      0, 1,
      { 403, 400, 152 },
      -1,
   } },

   /* ('ffma@32(nsz)', ('bcsel', ('feq', 'b', 0.0, 'ignore_exact'), 0.0, ('fabs', 'a')), ('bcsel', ('feq', 'a', 0.0, 'ignore_exact'), 0.0, ('fabs', 'b')), 'c') => ('ffmaz', ('fabs', 'a'), ('fabs', 'b'), 'c') */
   /* search166_0_0_0 -> 400 in the cache */
   /* search166_0_0_1 -> 255 in the cache */
   /* search166_0_0 -> 401 in the cache */
   /* search166_0_1 -> 255 in the cache */
   /* search166_0_2_0 -> 200 in the cache */
   /* search166_0_2 -> 402 in the cache */
   /* search166_0 -> 421 in the cache */
   /* search166_1_0_0 -> 200 in the cache */
   /* search166_1_0_1 -> 255 in the cache */
   /* search166_1_0 -> 405 in the cache */
   /* search166_1_1 -> 255 in the cache */
   /* search166_1_2_0 -> 400 in the cache */
   /* search166_1_2 -> 406 in the cache */
   /* search166_1 -> 411 in the cache */
   /* search166_2 -> 152 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      true,
      false,
      false,
      nir_op_ffma,
      0, 3,
      { 421, 411, 152 },
      -1,
   } },

   /* replace166_0_0 -> 200 in the cache */
   /* replace166_0 -> 402 in the cache */
   /* replace166_1_0 -> 400 in the cache */
   /* replace166_1 -> 406 in the cache */
   /* replace166_2 -> 152 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ffmaz,
      0, 1,
      { 402, 406, 152 },
      -1,
   } },

   /* ('ffma@32(nsz)', ('bcsel', ('feq', 'b', 0.0, 'ignore_exact'), 0.0, ('fabs', 'a')), ('bcsel', ('feq', 'a', 0.0, 'ignore_exact'), 0.0, ('fneg', 'b')), 'c') => ('ffmaz', ('fabs', 'a'), ('fneg', 'b'), 'c') */
   /* search167_0_0_0 -> 400 in the cache */
   /* search167_0_0_1 -> 255 in the cache */
   /* search167_0_0 -> 401 in the cache */
   /* search167_0_1 -> 255 in the cache */
   /* search167_0_2_0 -> 200 in the cache */
   /* search167_0_2 -> 402 in the cache */
   /* search167_0 -> 421 in the cache */
   /* search167_1_0_0 -> 200 in the cache */
   /* search167_1_0_1 -> 255 in the cache */
   /* search167_1_0 -> 405 in the cache */
   /* search167_1_1 -> 255 in the cache */
   /* search167_1_2_0 -> 400 in the cache */
   /* search167_1_2 -> 414 in the cache */
   /* search167_1 -> 415 in the cache */
   /* search167_2 -> 152 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      true,
      false,
      false,
      nir_op_ffma,
      0, 3,
      { 421, 415, 152 },
      -1,
   } },

   /* replace167_0_0 -> 200 in the cache */
   /* replace167_0 -> 402 in the cache */
   /* replace167_1_0 -> 400 in the cache */
   /* replace167_1 -> 414 in the cache */
   /* replace167_2 -> 152 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ffmaz,
      0, 1,
      { 402, 414, 152 },
      -1,
   } },

   /* ('ffma@32(nsz)', ('bcsel', ('feq', 'b', 0.0, 'ignore_exact'), 0.0, ('fabs', 'a')), ('bcsel', ('feq', 'a', 0.0, 'ignore_exact'), 0.0, 'b'), 'c') => ('ffmaz', ('fabs', 'a'), 'b', 'c') */
   /* search168_0_0_0 -> 400 in the cache */
   /* search168_0_0_1 -> 255 in the cache */
   /* search168_0_0 -> 401 in the cache */
   /* search168_0_1 -> 255 in the cache */
   /* search168_0_2_0 -> 200 in the cache */
   /* search168_0_2 -> 402 in the cache */
   /* search168_0 -> 421 in the cache */
   /* search168_1_0_0 -> 200 in the cache */
   /* search168_1_0_1 -> 255 in the cache */
   /* search168_1_0 -> 405 in the cache */
   /* search168_1_1 -> 255 in the cache */
   /* search168_1_2 -> 400 in the cache */
   /* search168_1 -> 418 in the cache */
   /* search168_2 -> 152 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      true,
      false,
      false,
      nir_op_ffma,
      0, 3,
      { 421, 418, 152 },
      -1,
   } },

   /* replace168_0_0 -> 200 in the cache */
   /* replace168_0 -> 402 in the cache */
   /* replace168_1 -> 400 in the cache */
   /* replace168_2 -> 152 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ffmaz,
      0, 1,
      { 402, 400, 152 },
      -1,
   } },

   /* ('ffma@32(nsz)', ('bcsel', ('feq', 'b', 0.0, 'ignore_exact'), 0.0, ('fneg', 'a')), ('bcsel', ('feq', 'a', 0.0, 'ignore_exact'), 0.0, ('fneg', 'b')), 'c') => ('ffmaz', ('fneg', 'a'), ('fneg', 'b'), 'c') */
   /* search169_0_0_0 -> 400 in the cache */
   /* search169_0_0_1 -> 255 in the cache */
   /* search169_0_0 -> 401 in the cache */
   /* search169_0_1 -> 255 in the cache */
   /* search169_0_2_0 -> 200 in the cache */
   /* search169_0_2 -> 428 in the cache */
   /* search169_0 -> 429 in the cache */
   /* search169_1_0_0 -> 200 in the cache */
   /* search169_1_0_1 -> 255 in the cache */
   /* search169_1_0 -> 405 in the cache */
   /* search169_1_1 -> 255 in the cache */
   /* search169_1_2_0 -> 400 in the cache */
   /* search169_1_2 -> 414 in the cache */
   /* search169_1 -> 415 in the cache */
   /* search169_2 -> 152 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      true,
      false,
      false,
      nir_op_ffma,
      0, 3,
      { 429, 415, 152 },
      -1,
   } },

   /* replace169_0_0 -> 200 in the cache */
   /* replace169_0 -> 428 in the cache */
   /* replace169_1_0 -> 400 in the cache */
   /* replace169_1 -> 414 in the cache */
   /* replace169_2 -> 152 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ffmaz,
      0, 1,
      { 428, 414, 152 },
      -1,
   } },

   /* ('ffma@32(nsz)', ('bcsel', ('feq', 'b', 0.0, 'ignore_exact'), 0.0, ('fneg', 'a')), ('bcsel', ('feq', 'a', 0.0, 'ignore_exact'), 0.0, 'b'), 'c') => ('ffmaz', ('fneg', 'a'), 'b', 'c') */
   /* search170_0_0_0 -> 400 in the cache */
   /* search170_0_0_1 -> 255 in the cache */
   /* search170_0_0 -> 401 in the cache */
   /* search170_0_1 -> 255 in the cache */
   /* search170_0_2_0 -> 200 in the cache */
   /* search170_0_2 -> 428 in the cache */
   /* search170_0 -> 429 in the cache */
   /* search170_1_0_0 -> 200 in the cache */
   /* search170_1_0_1 -> 255 in the cache */
   /* search170_1_0 -> 405 in the cache */
   /* search170_1_1 -> 255 in the cache */
   /* search170_1_2 -> 400 in the cache */
   /* search170_1 -> 418 in the cache */
   /* search170_2 -> 152 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      true,
      false,
      false,
      nir_op_ffma,
      0, 3,
      { 429, 418, 152 },
      -1,
   } },

   /* replace170_0_0 -> 200 in the cache */
   /* replace170_0 -> 428 in the cache */
   /* replace170_1 -> 400 in the cache */
   /* replace170_2 -> 152 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ffmaz,
      0, 1,
      { 428, 400, 152 },
      -1,
   } },

   /* ('ffma@32(nsz)', ('bcsel', ('feq', 'b', 0.0, 'ignore_exact'), 0.0, 'a'), ('bcsel', ('feq', 'a', 0.0, 'ignore_exact'), 0.0, 'b'), 'c') => ('ffmaz', 'a', 'b', 'c') */
   /* search171_0_0_0 -> 400 in the cache */
   /* search171_0_0_1 -> 255 in the cache */
   /* search171_0_0 -> 401 in the cache */
   /* search171_0_1 -> 255 in the cache */
   /* search171_0_2 -> 200 in the cache */
   /* search171_0 -> 434 in the cache */
   /* search171_1_0_0 -> 200 in the cache */
   /* search171_1_0_1 -> 255 in the cache */
   /* search171_1_0 -> 405 in the cache */
   /* search171_1_1 -> 255 in the cache */
   /* search171_1_2 -> 400 in the cache */
   /* search171_1 -> 418 in the cache */
   /* search171_2 -> 152 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      true,
      false,
      false,
      nir_op_ffma,
      0, 3,
      { 434, 418, 152 },
      -1,
   } },

   /* replace171_0 -> 200 in the cache */
   /* replace171_1 -> 400 in the cache */
   /* replace171_2 -> 152 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ffmaz,
      0, 1,
      { 200, 400, 152 },
      -1,
   } },

   /* ('ffma@32(nsz)', ('fneg', ('fabs', 'a')), ('bcsel', ('feq', 'a', 0.0, 'ignore_exact'), 0.0, '#b(is_not_const_zero)'), 'c') => ('ffmaz', ('fneg', ('fabs', 'a')), 'b', 'c') */
   /* search172_0_0_0 -> 29 in the cache */
   /* search172_0_0 -> 437 in the cache */
   /* search172_0 -> 438 in the cache */
   /* search172_1_0_0 -> 29 in the cache */
   /* search172_1_0_1 -> 255 in the cache */
   /* search172_1_0 -> 439 in the cache */
   /* search172_1_1 -> 255 in the cache */
   /* search172_1_2 -> 440 in the cache */
   /* search172_1 -> 441 in the cache */
   /* search172_2 -> 152 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      true,
      false,
      false,
      nir_op_ffma,
      0, 2,
      { 438, 441, 152 },
      -1,
   } },

   /* replace172_0_0_0 -> 29 in the cache */
   /* replace172_0_0 -> 437 in the cache */
   /* replace172_0 -> 438 in the cache */
   /* replace172_1 -> 48 in the cache */
   /* replace172_2 -> 152 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ffmaz,
      0, 1,
      { 438, 48, 152 },
      -1,
   } },

   /* ('ffma@32(nsz)', ('fabs', 'a'), ('bcsel', ('feq', 'a', 0.0, 'ignore_exact'), 0.0, '#b(is_not_const_zero)'), 'c') => ('ffmaz', ('fabs', 'a'), 'b', 'c') */
   /* search173_0_0 -> 29 in the cache */
   /* search173_0 -> 437 in the cache */
   /* search173_1_0_0 -> 29 in the cache */
   /* search173_1_0_1 -> 255 in the cache */
   /* search173_1_0 -> 439 in the cache */
   /* search173_1_1 -> 255 in the cache */
   /* search173_1_2 -> 440 in the cache */
   /* search173_1 -> 441 in the cache */
   /* search173_2 -> 152 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      true,
      false,
      false,
      nir_op_ffma,
      0, 2,
      { 437, 441, 152 },
      -1,
   } },

   /* replace173_0_0 -> 29 in the cache */
   /* replace173_0 -> 437 in the cache */
   /* replace173_1 -> 48 in the cache */
   /* replace173_2 -> 152 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ffmaz,
      0, 1,
      { 437, 48, 152 },
      -1,
   } },

   /* ('ffma@32(nsz)', ('fneg', 'a'), ('bcsel', ('feq', 'a', 0.0, 'ignore_exact'), 0.0, '#b(is_not_const_zero)'), 'c') => ('ffmaz', ('fneg', 'a'), 'b', 'c') */
   /* search174_0_0 -> 29 in the cache */
   /* search174_0 -> 307 in the cache */
   /* search174_1_0_0 -> 29 in the cache */
   /* search174_1_0_1 -> 255 in the cache */
   /* search174_1_0 -> 439 in the cache */
   /* search174_1_1 -> 255 in the cache */
   /* search174_1_2 -> 440 in the cache */
   /* search174_1 -> 441 in the cache */
   /* search174_2 -> 152 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      true,
      false,
      false,
      nir_op_ffma,
      0, 2,
      { 307, 441, 152 },
      -1,
   } },

   /* replace174_0_0 -> 29 in the cache */
   /* replace174_0 -> 307 in the cache */
   /* replace174_1 -> 48 in the cache */
   /* replace174_2 -> 152 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ffmaz,
      0, 1,
      { 307, 48, 152 },
      -1,
   } },

   /* ('ffma@32(nsz)', 'a', ('bcsel', ('feq', 'a', 0.0, 'ignore_exact'), 0.0, '#b(is_not_const_zero)'), 'c') => ('ffmaz', 'a', 'b', 'c') */
   /* search175_0 -> 29 in the cache */
   /* search175_1_0_0 -> 29 in the cache */
   /* search175_1_0_1 -> 255 in the cache */
   /* search175_1_0 -> 439 in the cache */
   /* search175_1_1 -> 255 in the cache */
   /* search175_1_2 -> 440 in the cache */
   /* search175_1 -> 441 in the cache */
   /* search175_2 -> 152 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      true,
      false,
      false,
      nir_op_ffma,
      0, 2,
      { 29, 441, 152 },
      -1,
   } },

   /* replace175_0 -> 29 in the cache */
   /* replace175_1 -> 48 in the cache */
   /* replace175_2 -> 152 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ffmaz,
      0, 1,
      { 29, 48, 152 },
      -1,
   } },

   /* ('bcsel(nsz,nnan,ninf)', ('feq', 'b', 0.0, 'ignore_exact'), 1.0, ('fexp2', ('fmul@32', 'a', ('fneg', ('fabs', 'b'))))) => ('fexp2', ('fmulz', 'a', ('fneg', ('fabs', 'b')))) */
   /* search176_0_0 -> 400 in the cache */
   /* search176_0_1 -> 255 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      true,
      false,
      false,
      false,
      nir_op_feq,
      0, 1,
      { 400, 255 },
      -1,
   } },
   /* search176_1 -> 275 in the cache */
   /* search176_2_0_0 -> 200 in the cache */
   /* search176_2_0_1_0_0 -> 400 in the cache */
   /* search176_2_0_1_0 -> 406 in the cache */
   /* search176_2_0_1 -> 407 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fmul,
      1, 1,
      { 200, 407 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fexp2,
      -1, 1,
      { 478 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      true,
      true,
      true,
      nir_op_bcsel,
      -1, 2,
      { 477, 275, 479 },
      -1,
   } },

   /* replace176_0_0 -> 200 in the cache */
   /* replace176_0_1_0_0 -> 400 in the cache */
   /* replace176_0_1_0 -> 406 in the cache */
   /* replace176_0_1 -> 407 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fmulz,
      0, 1,
      { 200, 407 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fexp2,
      -1, 1,
      { 481 },
      -1,
   } },

   /* ('bcsel(nsz,nnan,ninf)', ('feq', 'b', 0.0, 'ignore_exact'), 1.0, ('fexp2', ('fmul@32', 'a', ('fabs', 'b')))) => ('fexp2', ('fmulz', 'a', ('fabs', 'b'))) */
   /* search177_0_0 -> 400 in the cache */
   /* search177_0_1 -> 255 in the cache */
   /* search177_0 -> 477 in the cache */
   /* search177_1 -> 275 in the cache */
   /* search177_2_0_0 -> 200 in the cache */
   /* search177_2_0_1_0 -> 400 in the cache */
   /* search177_2_0_1 -> 406 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fmul,
      1, 1,
      { 200, 406 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fexp2,
      -1, 1,
      { 483 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      true,
      true,
      true,
      nir_op_bcsel,
      -1, 2,
      { 477, 275, 484 },
      -1,
   } },

   /* replace177_0_0 -> 200 in the cache */
   /* replace177_0_1_0 -> 400 in the cache */
   /* replace177_0_1 -> 406 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fmulz,
      0, 1,
      { 200, 406 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fexp2,
      -1, 1,
      { 486 },
      -1,
   } },

   /* ('bcsel(nsz,nnan,ninf)', ('feq', 'b', 0.0, 'ignore_exact'), 1.0, ('fexp2', ('fmul@32', 'a', ('fneg', 'b')))) => ('fexp2', ('fmulz', 'a', ('fneg', 'b'))) */
   /* search178_0_0 -> 400 in the cache */
   /* search178_0_1 -> 255 in the cache */
   /* search178_0 -> 477 in the cache */
   /* search178_1 -> 275 in the cache */
   /* search178_2_0_0 -> 200 in the cache */
   /* search178_2_0_1_0 -> 400 in the cache */
   /* search178_2_0_1 -> 414 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fmul,
      1, 1,
      { 200, 414 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fexp2,
      -1, 1,
      { 488 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      true,
      true,
      true,
      nir_op_bcsel,
      -1, 2,
      { 477, 275, 489 },
      -1,
   } },

   /* replace178_0_0 -> 200 in the cache */
   /* replace178_0_1_0 -> 400 in the cache */
   /* replace178_0_1 -> 414 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fmulz,
      0, 1,
      { 200, 414 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fexp2,
      -1, 1,
      { 491 },
      -1,
   } },

   /* ('bcsel(nsz,nnan,ninf)', ('feq', 'b', 0.0, 'ignore_exact'), 1.0, ('fexp2', ('fmul@32', 'a', 'b'))) => ('fexp2', ('fmulz', 'a', 'b')) */
   /* search179_0_0 -> 400 in the cache */
   /* search179_0_1 -> 255 in the cache */
   /* search179_0 -> 477 in the cache */
   /* search179_1 -> 275 in the cache */
   /* search179_2_0_0 -> 200 in the cache */
   /* search179_2_0_1 -> 400 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fmul,
      1, 1,
      { 200, 400 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fexp2,
      -1, 1,
      { 493 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      true,
      true,
      true,
      nir_op_bcsel,
      -1, 2,
      { 477, 275, 494 },
      -1,
   } },

   /* replace179_0_0 -> 200 in the cache */
   /* replace179_0_1 -> 400 in the cache */
   /* replace179_0 -> 436 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fexp2,
      -1, 1,
      { 436 },
      -1,
   } },

   /* ('bcsel', ('feq', 'b', 0.0, 'ignore_exact'), 1.0, ('fexp2', ('fmulz', 'a', ('fneg', ('fabs', 'b'))))) => ('fexp2', ('fmulz', 'a', ('fneg', ('fabs', 'b')))) */
   /* search180_0_0 -> 400 in the cache */
   /* search180_0_1 -> 255 in the cache */
   /* search180_0 -> 477 in the cache */
   /* search180_1 -> 275 in the cache */
   /* search180_2_0_0 -> 200 in the cache */
   /* search180_2_0_1_0_0 -> 400 in the cache */
   /* search180_2_0_1_0 -> 406 in the cache */
   /* search180_2_0_1 -> 407 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fmulz,
      1, 1,
      { 200, 407 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fexp2,
      -1, 1,
      { 497 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_bcsel,
      -1, 2,
      { 477, 275, 498 },
      -1,
   } },

   /* replace180_0_0 -> 200 in the cache */
   /* replace180_0_1_0_0 -> 400 in the cache */
   /* replace180_0_1_0 -> 406 in the cache */
   /* replace180_0_1 -> 407 in the cache */
   /* replace180_0 -> 481 in the cache */
   /* replace180 -> 482 in the cache */

   /* ('bcsel', ('feq', 'b', 0.0, 'ignore_exact'), 1.0, ('fexp2', ('fmulz', 'a', ('fabs', 'b')))) => ('fexp2', ('fmulz', 'a', ('fabs', 'b'))) */
   /* search181_0_0 -> 400 in the cache */
   /* search181_0_1 -> 255 in the cache */
   /* search181_0 -> 477 in the cache */
   /* search181_1 -> 275 in the cache */
   /* search181_2_0_0 -> 200 in the cache */
   /* search181_2_0_1_0 -> 400 in the cache */
   /* search181_2_0_1 -> 406 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fmulz,
      1, 1,
      { 200, 406 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fexp2,
      -1, 1,
      { 500 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_bcsel,
      -1, 2,
      { 477, 275, 501 },
      -1,
   } },

   /* replace181_0_0 -> 200 in the cache */
   /* replace181_0_1_0 -> 400 in the cache */
   /* replace181_0_1 -> 406 in the cache */
   /* replace181_0 -> 486 in the cache */
   /* replace181 -> 487 in the cache */

   /* ('bcsel', ('feq', 'b', 0.0, 'ignore_exact'), 1.0, ('fexp2', ('fmulz', 'a', ('fneg', 'b')))) => ('fexp2', ('fmulz', 'a', ('fneg', 'b'))) */
   /* search182_0_0 -> 400 in the cache */
   /* search182_0_1 -> 255 in the cache */
   /* search182_0 -> 477 in the cache */
   /* search182_1 -> 275 in the cache */
   /* search182_2_0_0 -> 200 in the cache */
   /* search182_2_0_1_0 -> 400 in the cache */
   /* search182_2_0_1 -> 414 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fmulz,
      1, 1,
      { 200, 414 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fexp2,
      -1, 1,
      { 503 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_bcsel,
      -1, 2,
      { 477, 275, 504 },
      -1,
   } },

   /* replace182_0_0 -> 200 in the cache */
   /* replace182_0_1_0 -> 400 in the cache */
   /* replace182_0_1 -> 414 in the cache */
   /* replace182_0 -> 491 in the cache */
   /* replace182 -> 492 in the cache */

   /* ('bcsel', ('feq', 'b', 0.0, 'ignore_exact'), 1.0, ('fexp2', ('fmulz', 'a', 'b'))) => ('fexp2', ('fmulz', 'a', 'b')) */
   /* search183_0_0 -> 400 in the cache */
   /* search183_0_1 -> 255 in the cache */
   /* search183_0 -> 477 in the cache */
   /* search183_1 -> 275 in the cache */
   /* search183_2_0_0 -> 200 in the cache */
   /* search183_2_0_1 -> 400 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fmulz,
      1, 1,
      { 200, 400 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fexp2,
      -1, 1,
      { 506 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_bcsel,
      -1, 2,
      { 477, 275, 507 },
      -1,
   } },

   /* replace183_0_0 -> 200 in the cache */
   /* replace183_0_1 -> 400 in the cache */
   /* replace183_0 -> 436 in the cache */
   /* replace183 -> 496 in the cache */

   /* ('iand(is_only_used_as_float)', 'a@16', 32767) => ('fabs', 'a') */
   /* search184_0 -> 24 in the cache */
   { .constant = {
      { nir_search_value_constant, 16 },
      nir_type_int, { 0x7fffull /* 32767 */ },
   } },
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_iand,
      0, 1,
      { 24, 509 },
      1,
   } },

   /* replace184_0 -> 24 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fabs,
      -1, 0,
      { 24 },
      -1,
   } },

   /* ('ixor(is_only_used_as_float)', 'a@16', 32768) => ('fneg', 'a') */
   /* search185_0 -> 24 in the cache */
   /* search185_1 -> 25 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ixor,
      0, 1,
      { 24, 25 },
      1,
   } },

   /* replace185_0 -> 24 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fneg,
      -1, 0,
      { 24 },
      -1,
   } },

   /* ('ior(is_only_used_as_float)', 'a@16', 32768) => ('fneg', ('fabs', 'a')) */
   /* search186_0 -> 24 in the cache */
   /* search186_1 -> 25 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ior,
      0, 1,
      { 24, 25 },
      1,
   } },

   /* replace186_0_0 -> 24 in the cache */
   /* replace186_0 -> 511 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fneg,
      -1, 0,
      { 511 },
      -1,
   } },

   /* ('iand(is_only_used_as_float)', 'a@32', 2147483647) => ('fabs', 'a') */
   /* search187_0 -> 29 in the cache */
   { .constant = {
      { nir_search_value_constant, 32 },
      nir_type_int, { 0x7fffffffull /* 2147483647 */ },
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_iand,
      0, 1,
      { 29, 516 },
      1,
   } },

   /* replace187_0 -> 29 in the cache */
   /* replace187 -> 437 in the cache */

   /* ('ixor(is_only_used_as_float)', 'a@32', 2147483648) => ('fneg', 'a') */
   /* search188_0 -> 29 in the cache */
   /* search188_1 -> 30 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ixor,
      0, 1,
      { 29, 30 },
      1,
   } },

   /* replace188_0 -> 29 in the cache */
   /* replace188 -> 307 in the cache */

   /* ('ior(is_only_used_as_float)', 'a@32', 2147483648) => ('fneg', ('fabs', 'a')) */
   /* search189_0 -> 29 in the cache */
   /* search189_1 -> 30 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ior,
      0, 1,
      { 29, 30 },
      1,
   } },

   /* replace189_0_0 -> 29 in the cache */
   /* replace189_0 -> 437 in the cache */
   /* replace189 -> 438 in the cache */

   /* ('iand(is_only_used_as_float)', 'a@64', 9223372036854775807) => ('fabs', 'a') */
   /* search190_0 -> 34 in the cache */
   { .constant = {
      { nir_search_value_constant, 64 },
      nir_type_int, { 0x7fffffffffffffffull /* 9223372036854775807 */ },
   } },
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_iand,
      0, 1,
      { 34, 520 },
      1,
   } },

   /* replace190_0 -> 34 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fabs,
      -1, 0,
      { 34 },
      -1,
   } },

   /* ('ixor(is_only_used_as_float)', 'a@64', 9223372036854775808) => ('fneg', 'a') */
   /* search191_0 -> 34 in the cache */
   /* search191_1 -> 35 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ixor,
      0, 1,
      { 34, 35 },
      1,
   } },

   /* replace191_0 -> 34 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fneg,
      -1, 0,
      { 34 },
      -1,
   } },

   /* ('ior(is_only_used_as_float)', 'a@64', 9223372036854775808) => ('fneg', ('fabs', 'a')) */
   /* search192_0 -> 34 in the cache */
   /* search192_1 -> 35 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ior,
      0, 1,
      { 34, 35 },
      1,
   } },

   /* replace192_0_0 -> 34 in the cache */
   /* replace192_0 -> 522 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fneg,
      -1, 0,
      { 522 },
      -1,
   } },

   /* ('sdot_4x8_iadd', 'a', 'b', 'c') => ('iadd', ('iadd', ('iadd', ('imul', ('extract_i8', 'a', 0), ('extract_i8', 'b', 0)), ('imul', ('extract_i8', 'a', 1), ('extract_i8', 'b', 1))), ('iadd', ('imul', ('extract_i8', 'a', 2), ('extract_i8', 'b', 2)), ('imul', ('extract_i8', 'a', 3), ('extract_i8', 'b', 3)))), 'c') */
   /* search193_0 -> 29 in the cache */
   /* search193_1 -> 48 in the cache */
   /* search193_2 -> 152 in the cache */
   /* search193 -> 358 in the cache */

   /* replace193_0_0_0_0_0 -> 29 in the cache */
   /* replace193_0_0_0_0_1 -> 139 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_extract_i8,
      -1, 0,
      { 29, 139 },
      -1,
   } },
   /* replace193_0_0_0_1_0 -> 48 in the cache */
   /* replace193_0_0_0_1_1 -> 139 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_extract_i8,
      -1, 0,
      { 48, 139 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_imul,
      3, 1,
      { 527, 528 },
      -1,
   } },
   /* replace193_0_0_1_0_0 -> 29 in the cache */
   { .constant = {
      { nir_search_value_constant, 32 },
      nir_type_int, { 0x1ull /* 1 */ },
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_extract_i8,
      -1, 0,
      { 29, 530 },
      -1,
   } },
   /* replace193_0_0_1_1_0 -> 48 in the cache */
   /* replace193_0_0_1_1_1 -> 530 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_extract_i8,
      -1, 0,
      { 48, 530 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_imul,
      4, 1,
      { 531, 532 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_iadd,
      2, 3,
      { 529, 533 },
      -1,
   } },
   /* replace193_0_1_0_0_0 -> 29 in the cache */
   { .constant = {
      { nir_search_value_constant, 32 },
      nir_type_int, { 0x2ull /* 2 */ },
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_extract_i8,
      -1, 0,
      { 29, 535 },
      -1,
   } },
   /* replace193_0_1_0_1_0 -> 48 in the cache */
   /* replace193_0_1_0_1_1 -> 535 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_extract_i8,
      -1, 0,
      { 48, 535 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_imul,
      6, 1,
      { 536, 537 },
      -1,
   } },
   /* replace193_0_1_1_0_0 -> 29 in the cache */
   { .constant = {
      { nir_search_value_constant, 32 },
      nir_type_int, { 0x3ull /* 3 */ },
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_extract_i8,
      -1, 0,
      { 29, 539 },
      -1,
   } },
   /* replace193_0_1_1_1_0 -> 48 in the cache */
   /* replace193_0_1_1_1_1 -> 539 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_extract_i8,
      -1, 0,
      { 48, 539 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_imul,
      7, 1,
      { 540, 541 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_iadd,
      5, 3,
      { 538, 542 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_iadd,
      1, 7,
      { 534, 543 },
      -1,
   } },
   /* replace193_1 -> 152 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_iadd,
      0, 8,
      { 544, 152 },
      -1,
   } },

   /* ('udot_4x8_uadd', 'a', 'b', 'c') => ('iadd', ('iadd', ('iadd', ('imul', ('extract_u8', 'a', 0), ('extract_u8', 'b', 0)), ('imul', ('extract_u8', 'a', 1), ('extract_u8', 'b', 1))), ('iadd', ('imul', ('extract_u8', 'a', 2), ('extract_u8', 'b', 2)), ('imul', ('extract_u8', 'a', 3), ('extract_u8', 'b', 3)))), 'c') */
   /* search194_0 -> 29 in the cache */
   /* search194_1 -> 48 in the cache */
   /* search194_2 -> 152 in the cache */
   /* search194 -> 361 in the cache */

   /* replace194_0_0_0_0_0 -> 29 in the cache */
   /* replace194_0_0_0_0_1 -> 139 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_extract_u8,
      -1, 0,
      { 29, 139 },
      -1,
   } },
   /* replace194_0_0_0_1_0 -> 48 in the cache */
   /* replace194_0_0_0_1_1 -> 139 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_extract_u8,
      -1, 0,
      { 48, 139 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_imul,
      3, 1,
      { 546, 547 },
      -1,
   } },
   /* replace194_0_0_1_0_0 -> 29 in the cache */
   /* replace194_0_0_1_0_1 -> 530 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_extract_u8,
      -1, 0,
      { 29, 530 },
      -1,
   } },
   /* replace194_0_0_1_1_0 -> 48 in the cache */
   /* replace194_0_0_1_1_1 -> 530 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_extract_u8,
      -1, 0,
      { 48, 530 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_imul,
      4, 1,
      { 549, 550 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_iadd,
      2, 3,
      { 548, 551 },
      -1,
   } },
   /* replace194_0_1_0_0_0 -> 29 in the cache */
   /* replace194_0_1_0_0_1 -> 535 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_extract_u8,
      -1, 0,
      { 29, 535 },
      -1,
   } },
   /* replace194_0_1_0_1_0 -> 48 in the cache */
   /* replace194_0_1_0_1_1 -> 535 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_extract_u8,
      -1, 0,
      { 48, 535 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_imul,
      6, 1,
      { 553, 554 },
      -1,
   } },
   /* replace194_0_1_1_0_0 -> 29 in the cache */
   /* replace194_0_1_1_0_1 -> 539 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_extract_u8,
      -1, 0,
      { 29, 539 },
      -1,
   } },
   /* replace194_0_1_1_1_0 -> 48 in the cache */
   /* replace194_0_1_1_1_1 -> 539 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_extract_u8,
      -1, 0,
      { 48, 539 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_imul,
      7, 1,
      { 556, 557 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_iadd,
      5, 3,
      { 555, 558 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_iadd,
      1, 7,
      { 552, 559 },
      -1,
   } },
   /* replace194_1 -> 152 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_iadd,
      0, 8,
      { 560, 152 },
      -1,
   } },

   /* ('sudot_4x8_iadd', 'a', 'b', 'c') => ('iadd', ('iadd', ('iadd', ('imul', ('extract_i8', 'a', 0), ('extract_u8', 'b', 0)), ('imul', ('extract_i8', 'a', 1), ('extract_u8', 'b', 1))), ('iadd', ('imul', ('extract_i8', 'a', 2), ('extract_u8', 'b', 2)), ('imul', ('extract_i8', 'a', 3), ('extract_u8', 'b', 3)))), 'c') */
   /* search195_0 -> 29 in the cache */
   /* search195_1 -> 48 in the cache */
   /* search195_2 -> 152 in the cache */
   /* search195 -> 364 in the cache */

   /* replace195_0_0_0_0_0 -> 29 in the cache */
   /* replace195_0_0_0_0_1 -> 139 in the cache */
   /* replace195_0_0_0_0 -> 527 in the cache */
   /* replace195_0_0_0_1_0 -> 48 in the cache */
   /* replace195_0_0_0_1_1 -> 139 in the cache */
   /* replace195_0_0_0_1 -> 547 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_imul,
      3, 1,
      { 527, 547 },
      -1,
   } },
   /* replace195_0_0_1_0_0 -> 29 in the cache */
   /* replace195_0_0_1_0_1 -> 530 in the cache */
   /* replace195_0_0_1_0 -> 531 in the cache */
   /* replace195_0_0_1_1_0 -> 48 in the cache */
   /* replace195_0_0_1_1_1 -> 530 in the cache */
   /* replace195_0_0_1_1 -> 550 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_imul,
      4, 1,
      { 531, 550 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_iadd,
      2, 3,
      { 562, 563 },
      -1,
   } },
   /* replace195_0_1_0_0_0 -> 29 in the cache */
   /* replace195_0_1_0_0_1 -> 535 in the cache */
   /* replace195_0_1_0_0 -> 536 in the cache */
   /* replace195_0_1_0_1_0 -> 48 in the cache */
   /* replace195_0_1_0_1_1 -> 535 in the cache */
   /* replace195_0_1_0_1 -> 554 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_imul,
      6, 1,
      { 536, 554 },
      -1,
   } },
   /* replace195_0_1_1_0_0 -> 29 in the cache */
   /* replace195_0_1_1_0_1 -> 539 in the cache */
   /* replace195_0_1_1_0 -> 540 in the cache */
   /* replace195_0_1_1_1_0 -> 48 in the cache */
   /* replace195_0_1_1_1_1 -> 539 in the cache */
   /* replace195_0_1_1_1 -> 557 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_imul,
      7, 1,
      { 540, 557 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_iadd,
      5, 3,
      { 565, 566 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_iadd,
      1, 7,
      { 564, 567 },
      -1,
   } },
   /* replace195_1 -> 152 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_iadd,
      0, 8,
      { 568, 152 },
      -1,
   } },

   /* ('sdot_2x16_iadd', 'a', 'b', 'c') => ('iadd', ('iadd', ('imul', ('extract_i16', 'a', 0), ('extract_i16', 'b', 0)), ('imul', ('extract_i16', 'a', 1), ('extract_i16', 'b', 1))), 'c') */
   /* search196_0 -> 29 in the cache */
   /* search196_1 -> 48 in the cache */
   /* search196_2 -> 152 in the cache */
   /* search196 -> 370 in the cache */

   /* replace196_0_0_0_0 -> 29 in the cache */
   /* replace196_0_0_0_1 -> 139 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_extract_i16,
      -1, 0,
      { 29, 139 },
      -1,
   } },
   /* replace196_0_0_1_0 -> 48 in the cache */
   /* replace196_0_0_1_1 -> 139 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_extract_i16,
      -1, 0,
      { 48, 139 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_imul,
      2, 1,
      { 570, 571 },
      -1,
   } },
   /* replace196_0_1_0_0 -> 29 in the cache */
   /* replace196_0_1_0_1 -> 530 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_extract_i16,
      -1, 0,
      { 29, 530 },
      -1,
   } },
   /* replace196_0_1_1_0 -> 48 in the cache */
   /* replace196_0_1_1_1 -> 530 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_extract_i16,
      -1, 0,
      { 48, 530 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_imul,
      3, 1,
      { 573, 574 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_iadd,
      1, 3,
      { 572, 575 },
      -1,
   } },
   /* replace196_1 -> 152 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_iadd,
      0, 4,
      { 576, 152 },
      -1,
   } },

   /* ('udot_2x16_uadd', 'a', 'b', 'c') => ('iadd', ('iadd', ('imul', ('extract_u16', 'a', 0), ('extract_u16', 'b', 0)), ('imul', ('extract_u16', 'a', 1), ('extract_u16', 'b', 1))), 'c') */
   /* search197_0 -> 29 in the cache */
   /* search197_1 -> 48 in the cache */
   /* search197_2 -> 152 in the cache */
   /* search197 -> 373 in the cache */

   /* replace197_0_0_0_0 -> 29 in the cache */
   /* replace197_0_0_0_1 -> 139 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_extract_u16,
      -1, 0,
      { 29, 139 },
      -1,
   } },
   /* replace197_0_0_1_0 -> 48 in the cache */
   /* replace197_0_0_1_1 -> 139 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_extract_u16,
      -1, 0,
      { 48, 139 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_imul,
      2, 1,
      { 578, 579 },
      -1,
   } },
   /* replace197_0_1_0_0 -> 29 in the cache */
   /* replace197_0_1_0_1 -> 530 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_extract_u16,
      -1, 0,
      { 29, 530 },
      -1,
   } },
   /* replace197_0_1_1_0 -> 48 in the cache */
   /* replace197_0_1_1_1 -> 530 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_extract_u16,
      -1, 0,
      { 48, 530 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_imul,
      3, 1,
      { 581, 582 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_iadd,
      1, 3,
      { 580, 583 },
      -1,
   } },
   /* replace197_1 -> 152 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_iadd,
      0, 4,
      { 584, 152 },
      -1,
   } },

   /* ('udot_4x8_uadd_sat', 'a', 'b', '#c(is_ult_0xfffc07fc)') => ('udot_4x8_uadd', 'a', 'b', 'c') */
   /* search198_0 -> 29 in the cache */
   /* search198_1 -> 48 in the cache */
   { .variable = {
      { nir_search_value_variable, 32 },
      2, /* c */
      true,
      nir_type_invalid,
      8,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_udot_4x8_uadd_sat,
      0, 1,
      { 29, 48, 586 },
      -1,
   } },

   /* replace198_0 -> 29 in the cache */
   /* replace198_1 -> 48 in the cache */
   /* replace198_2 -> 152 in the cache */
   /* replace198 -> 361 in the cache */

   /* ('udot_4x8_uadd_sat', 'a', 'b', 'c') => ('uadd_sat', ('udot_4x8_uadd', 'a', 'b', 0), 'c') */
   /* search199_0 -> 29 in the cache */
   /* search199_1 -> 48 in the cache */
   /* search199_2 -> 152 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_udot_4x8_uadd_sat,
      0, 1,
      { 29, 48, 152 },
      -1,
   } },

   /* replace199_0_0 -> 29 in the cache */
   /* replace199_0_1 -> 48 in the cache */
   /* replace199_0_2 -> 139 in the cache */
   /* replace199_0 -> 379 in the cache */
   /* replace199_1 -> 152 in the cache */
   /* replace199 -> 393 in the cache */

   /* ('sdot_4x8_iadd_sat', 'a', 'b', 'c') => ('iadd_sat', ('sdot_4x8_iadd', 'a', 'b', 0), 'c') */
   /* search200_0 -> 29 in the cache */
   /* search200_1 -> 48 in the cache */
   /* search200_2 -> 152 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_sdot_4x8_iadd_sat,
      0, 1,
      { 29, 48, 152 },
      -1,
   } },

   /* replace200_0_0 -> 29 in the cache */
   /* replace200_0_1 -> 48 in the cache */
   /* replace200_0_2 -> 139 in the cache */
   /* replace200_0 -> 376 in the cache */
   /* replace200_1 -> 152 in the cache */
   /* replace200 -> 391 in the cache */

   /* ('sudot_4x8_iadd_sat', 'a', 'b', 'c') => ('iadd_sat', ('sudot_4x8_iadd', 'a', 'b', 0), 'c') */
   /* search201_0 -> 29 in the cache */
   /* search201_1 -> 48 in the cache */
   /* search201_2 -> 152 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_sudot_4x8_iadd_sat,
      -1, 0,
      { 29, 48, 152 },
      -1,
   } },

   /* replace201_0_0 -> 29 in the cache */
   /* replace201_0_1 -> 48 in the cache */
   /* replace201_0_2 -> 139 in the cache */
   /* replace201_0 -> 382 in the cache */
   /* replace201_1 -> 152 in the cache */
   /* replace201 -> 395 in the cache */

   /* ('udot_2x16_uadd_sat', 'a', 'b', 'c') => ('uadd_sat', ('iadd', ('imul', ('extract_u16', 'a', 0), ('extract_u16', 'b', 0)), ('imul', ('extract_u16', 'a', 1), ('extract_u16', 'b', 1))), 'c') */
   /* search202_0 -> 29 in the cache */
   /* search202_1 -> 48 in the cache */
   /* search202_2 -> 152 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_udot_2x16_uadd_sat,
      0, 1,
      { 29, 48, 152 },
      -1,
   } },

   /* replace202_0_0_0_0 -> 29 in the cache */
   /* replace202_0_0_0_1 -> 139 in the cache */
   /* replace202_0_0_0 -> 578 in the cache */
   /* replace202_0_0_1_0 -> 48 in the cache */
   /* replace202_0_0_1_1 -> 139 in the cache */
   /* replace202_0_0_1 -> 579 in the cache */
   /* replace202_0_0 -> 580 in the cache */
   /* replace202_0_1_0_0 -> 29 in the cache */
   /* replace202_0_1_0_1 -> 530 in the cache */
   /* replace202_0_1_0 -> 581 in the cache */
   /* replace202_0_1_1_0 -> 48 in the cache */
   /* replace202_0_1_1_1 -> 530 in the cache */
   /* replace202_0_1_1 -> 582 in the cache */
   /* replace202_0_1 -> 583 in the cache */
   /* replace202_0 -> 584 in the cache */
   /* replace202_1 -> 152 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_uadd_sat,
      0, 4,
      { 584, 152 },
      -1,
   } },

   /* ('sdot_2x16_iadd_sat', 'a', 'b', 'c') => ('iadd_sat', ('iadd', ('imul', ('extract_i16', 'a', 0), ('extract_i16', 'b', 0)), ('imul', ('extract_i16', 'a', 1), ('extract_i16', 'b', 1))), 'c') */
   /* search203_0 -> 29 in the cache */
   /* search203_1 -> 48 in the cache */
   /* search203_2 -> 152 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_sdot_2x16_iadd_sat,
      0, 1,
      { 29, 48, 152 },
      -1,
   } },

   /* replace203_0_0_0_0 -> 29 in the cache */
   /* replace203_0_0_0_1 -> 139 in the cache */
   /* replace203_0_0_0 -> 570 in the cache */
   /* replace203_0_0_1_0 -> 48 in the cache */
   /* replace203_0_0_1_1 -> 139 in the cache */
   /* replace203_0_0_1 -> 571 in the cache */
   /* replace203_0_0 -> 572 in the cache */
   /* replace203_0_1_0_0 -> 29 in the cache */
   /* replace203_0_1_0_1 -> 530 in the cache */
   /* replace203_0_1_0 -> 573 in the cache */
   /* replace203_0_1_1_0 -> 48 in the cache */
   /* replace203_0_1_1_1 -> 530 in the cache */
   /* replace203_0_1_1 -> 574 in the cache */
   /* replace203_0_1 -> 575 in the cache */
   /* replace203_0 -> 576 in the cache */
   /* replace203_1 -> 152 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_iadd_sat,
      0, 4,
      { 576, 152 },
      -1,
   } },

   /* ('~flrp@16', 'a', 'b', ('b2f', 'c@1')) => ('bcsel', 'c', 'b', 'a') */
   /* search204_0 -> 24 in the cache */
   { .variable = {
      { nir_search_value_variable, 16 },
      1, /* b */
      false,
      nir_type_invalid,
      -1,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .variable = {
      { nir_search_value_variable, 1 },
      2, /* c */
      false,
      nir_type_invalid,
      -1,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_search_op_b2f,
      -1, 0,
      { 596 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 16 },
      true,
      false,
      false,
      false,
      false,
      false,
      nir_op_flrp,
      -1, 0,
      { 24, 595, 597 },
      -1,
   } },

   /* replace204_0 -> 596 in the cache */
   /* replace204_1 -> 595 in the cache */
   /* replace204_2 -> 24 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_bcsel,
      -1, 0,
      { 596, 595, 24 },
      -1,
   } },

   /* ('~flrp@16', 'a', ('fadd', 'a', 'b'), 'c') => ('fadd', ('fmul', 'b', 'c'), 'a') */
   /* search205_0 -> 24 in the cache */
   /* search205_1_0 -> 24 in the cache */
   /* search205_1_1 -> 595 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fadd,
      0, 1,
      { 24, 595 },
      -1,
   } },
   { .variable = {
      { nir_search_value_variable, 16 },
      2, /* c */
      false,
      nir_type_invalid,
      -1,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .expression = {
      { nir_search_value_expression, 16 },
      true,
      false,
      false,
      false,
      false,
      false,
      nir_op_flrp,
      -1, 1,
      { 24, 600, 601 },
      -1,
   } },

   /* replace205_0_0 -> 595 in the cache */
   /* replace205_0_1 -> 601 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fmul,
      1, 1,
      { 595, 601 },
      -1,
   } },
   /* replace205_1 -> 24 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fadd,
      0, 2,
      { 603, 24 },
      -1,
   } },

   /* ('~flrp@16', ('fadd(is_used_once)', 'a', 'b'), ('fadd(is_used_once)', 'a', 'c'), 'd') => ('fadd', ('flrp', 'b', 'c', 'd'), 'a') */
   /* search206_0_0 -> 24 in the cache */
   /* search206_0_1 -> 595 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fadd,
      0, 1,
      { 24, 595 },
      0,
   } },
   /* search206_1_0 -> 24 in the cache */
   /* search206_1_1 -> 601 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fadd,
      1, 1,
      { 24, 601 },
      0,
   } },
   { .variable = {
      { nir_search_value_variable, 16 },
      3, /* d */
      false,
      nir_type_invalid,
      -1,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .expression = {
      { nir_search_value_expression, 16 },
      true,
      false,
      false,
      false,
      false,
      false,
      nir_op_flrp,
      -1, 2,
      { 605, 606, 607 },
      -1,
   } },

   /* replace206_0_0 -> 595 in the cache */
   /* replace206_0_1 -> 601 in the cache */
   /* replace206_0_2 -> 607 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_flrp,
      -1, 0,
      { 595, 601, 607 },
      -1,
   } },
   /* replace206_1 -> 24 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fadd,
      0, 1,
      { 609, 24 },
      -1,
   } },

   /* ('~flrp@16', 'a', ('fmul(is_used_once)', 'a', 'b'), 'c') => ('fmul', ('flrp', 1.0, 'b', 'c'), 'a') */
   /* search207_0 -> 24 in the cache */
   /* search207_1_0 -> 24 in the cache */
   /* search207_1_1 -> 595 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fmul,
      0, 1,
      { 24, 595 },
      0,
   } },
   /* search207_2 -> 601 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      true,
      false,
      false,
      false,
      false,
      false,
      nir_op_flrp,
      -1, 1,
      { 24, 611, 601 },
      -1,
   } },

   { .constant = {
      { nir_search_value_constant, 16 },
      nir_type_float, { 0x3ff0000000000000ull /* 1.0 */ },
   } },
   /* replace207_0_1 -> 595 in the cache */
   /* replace207_0_2 -> 601 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_flrp,
      -1, 0,
      { 613, 595, 601 },
      -1,
   } },
   /* replace207_1 -> 24 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fmul,
      0, 1,
      { 614, 24 },
      -1,
   } },

   /* ('~fadd@16', ('fmul', 'a', ('fadd', 1.0, ('fneg', 'c'))), ('fmul', 'b', 'c')) => ('flrp', 'a', 'b', 'c') */
   /* search208_0_0 -> 24 in the cache */
   /* search208_0_1_0 -> 613 in the cache */
   { .variable = {
      { nir_search_value_variable, 16 },
      1, /* c */
      false,
      nir_type_invalid,
      -1,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fneg,
      -1, 0,
      { 616 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fadd,
      2, 1,
      { 613, 617 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fmul,
      1, 2,
      { 24, 618 },
      -1,
   } },
   { .variable = {
      { nir_search_value_variable, 16 },
      2, /* b */
      false,
      nir_type_invalid,
      -1,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   /* search208_1_1 -> 616 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fmul,
      3, 1,
      { 620, 616 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 16 },
      true,
      false,
      false,
      false,
      false,
      false,
      nir_op_fadd,
      0, 4,
      { 619, 621 },
      -1,
   } },

   /* replace208_0 -> 24 in the cache */
   /* replace208_1 -> 620 in the cache */
   /* replace208_2 -> 616 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_flrp,
      -1, 0,
      { 24, 620, 616 },
      -1,
   } },

   /* ('~fadd@16', ('fmul', 'a', ('fsat', ('fadd', 1.0, ('fneg', 'c')))), ('fmul', 'b', ('fsat', 'c'))) => ('flrp', 'a', 'b', ('fsat', 'c')) */
   /* search209_0_0 -> 24 in the cache */
   /* search209_0_1_0_0 -> 613 in the cache */
   /* search209_0_1_0_1_0 -> 616 in the cache */
   /* search209_0_1_0_1 -> 617 in the cache */
   /* search209_0_1_0 -> 618 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fsat,
      -1, 1,
      { 618 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fmul,
      1, 2,
      { 24, 624 },
      -1,
   } },
   /* search209_1_0 -> 620 in the cache */
   /* search209_1_1_0 -> 616 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fsat,
      -1, 0,
      { 616 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fmul,
      3, 1,
      { 620, 626 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 16 },
      true,
      false,
      false,
      false,
      false,
      false,
      nir_op_fadd,
      0, 4,
      { 625, 627 },
      -1,
   } },

   /* replace209_0 -> 24 in the cache */
   /* replace209_1 -> 620 in the cache */
   /* replace209_2_0 -> 616 in the cache */
   /* replace209_2 -> 626 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_flrp,
      -1, 0,
      { 24, 620, 626 },
      -1,
   } },

   /* ('~fadd@16', 'a', ('fmul', 'c', ('fadd', 'b', ('fneg', 'a')))) => ('flrp', 'a', 'b', 'c') */
   /* search210_0 -> 24 in the cache */
   /* search210_1_0 -> 616 in the cache */
   /* search210_1_1_0 -> 620 in the cache */
   /* search210_1_1_1_0 -> 24 in the cache */
   /* search210_1_1_1 -> 513 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fadd,
      2, 1,
      { 620, 513 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fmul,
      1, 2,
      { 616, 630 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 16 },
      true,
      false,
      false,
      false,
      false,
      false,
      nir_op_fadd,
      0, 3,
      { 24, 631 },
      -1,
   } },

   /* replace210_0 -> 24 in the cache */
   /* replace210_1 -> 620 in the cache */
   /* replace210_2 -> 616 in the cache */
   /* replace210 -> 623 in the cache */

   /* ('~fadd@16', ('fmul', 'a', ('fadd', 1.0, ('fneg', ('b2f', 'c@1')))), ('fmul', 'b', ('b2f', 'c'))) => ('bcsel', 'c', 'b', 'a') */
   /* search211_0_0 -> 24 in the cache */
   /* search211_0_1_0 -> 613 in the cache */
   { .variable = {
      { nir_search_value_variable, 1 },
      1, /* c */
      false,
      nir_type_invalid,
      -1,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_search_op_b2f,
      -1, 0,
      { 633 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fneg,
      -1, 0,
      { 634 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fadd,
      2, 1,
      { 613, 635 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fmul,
      1, 2,
      { 24, 636 },
      -1,
   } },
   /* search211_1_0 -> 620 in the cache */
   /* search211_1_1_0 -> 633 in the cache */
   /* search211_1_1 -> 634 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fmul,
      3, 1,
      { 620, 634 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 16 },
      true,
      false,
      false,
      false,
      false,
      false,
      nir_op_fadd,
      0, 4,
      { 637, 638 },
      -1,
   } },

   /* replace211_0 -> 633 in the cache */
   /* replace211_1 -> 620 in the cache */
   /* replace211_2 -> 24 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_bcsel,
      -1, 0,
      { 633, 620, 24 },
      -1,
   } },

   /* ('~fadd@16', 'a', ('fmul', ('b2f', 'c@1'), ('fadd', 'b', ('fneg', 'a')))) => ('bcsel', 'c', 'b', 'a') */
   /* search212_0 -> 24 in the cache */
   /* search212_1_0_0 -> 633 in the cache */
   /* search212_1_0 -> 634 in the cache */
   /* search212_1_1_0 -> 620 in the cache */
   /* search212_1_1_1_0 -> 24 in the cache */
   /* search212_1_1_1 -> 513 in the cache */
   /* search212_1_1 -> 630 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fmul,
      1, 2,
      { 634, 630 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 16 },
      true,
      false,
      false,
      false,
      false,
      false,
      nir_op_fadd,
      0, 3,
      { 24, 641 },
      -1,
   } },

   /* replace212_0 -> 633 in the cache */
   /* replace212_1 -> 620 in the cache */
   /* replace212_2 -> 24 in the cache */
   /* replace212 -> 640 in the cache */

   /* ('~ffma@16', 'a', ('fadd', 1.0, ('fneg', ('b2f', 'c@1'))), ('fmul', 'b', ('b2f', 'c@1'))) => ('bcsel', 'c', 'b', 'a') */
   /* search213_0 -> 24 in the cache */
   /* search213_1_0 -> 613 in the cache */
   /* search213_1_1_0_0 -> 633 in the cache */
   /* search213_1_1_0 -> 634 in the cache */
   /* search213_1_1 -> 635 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fadd,
      1, 1,
      { 613, 635 },
      -1,
   } },
   /* search213_2_0 -> 620 in the cache */
   /* search213_2_1_0 -> 633 in the cache */
   /* search213_2_1 -> 634 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fmul,
      2, 1,
      { 620, 634 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 16 },
      true,
      false,
      false,
      false,
      false,
      false,
      nir_op_ffma,
      0, 3,
      { 24, 643, 644 },
      -1,
   } },

   /* replace213_0 -> 633 in the cache */
   /* replace213_1 -> 620 in the cache */
   /* replace213_2 -> 24 in the cache */
   /* replace213 -> 640 in the cache */

   /* ('~ffma@16', 'b', ('b2f', 'c@1'), ('ffma', ('fneg', 'a'), ('b2f', 'c@1'), 'a')) => ('bcsel', 'c', 'b', 'a') */
   { .variable = {
      { nir_search_value_variable, 16 },
      0, /* b */
      false,
      nir_type_invalid,
      -1,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   /* search214_1_0 -> 633 in the cache */
   /* search214_1 -> 634 in the cache */
   { .variable = {
      { nir_search_value_variable, 16 },
      2, /* a */
      false,
      nir_type_invalid,
      -1,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fneg,
      -1, 0,
      { 647 },
      -1,
   } },
   /* search214_2_1_0 -> 633 in the cache */
   /* search214_2_1 -> 634 in the cache */
   /* search214_2_2 -> 647 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ffma,
      1, 1,
      { 648, 634, 647 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 16 },
      true,
      false,
      false,
      false,
      false,
      false,
      nir_op_ffma,
      0, 2,
      { 646, 634, 649 },
      -1,
   } },

   /* replace214_0 -> 633 in the cache */
   /* replace214_1 -> 646 in the cache */
   /* replace214_2 -> 647 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_bcsel,
      -1, 0,
      { 633, 646, 647 },
      -1,
   } },

   /* ('~ffma@16', ('b2f', 'c@1'), ('fadd', 'b', ('fneg', 'a')), 'a') => ('bcsel', 'c', 'b', 'a') */
   { .variable = {
      { nir_search_value_variable, 1 },
      0, /* c */
      false,
      nir_type_invalid,
      -1,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_search_op_b2f,
      -1, 0,
      { 652 },
      -1,
   } },
   /* search215_1_0 -> 595 in the cache */
   /* search215_1_1_0 -> 647 in the cache */
   /* search215_1_1 -> 648 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fadd,
      1, 1,
      { 595, 648 },
      -1,
   } },
   /* search215_2 -> 647 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      true,
      false,
      false,
      false,
      false,
      false,
      nir_op_ffma,
      0, 2,
      { 653, 654, 647 },
      -1,
   } },

   /* replace215_0 -> 652 in the cache */
   /* replace215_1 -> 595 in the cache */
   /* replace215_2 -> 647 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_bcsel,
      -1, 0,
      { 652, 595, 647 },
      -1,
   } },

   /* ('~ffma@16', ('b2f', 'c@1'), ('ffma', ('fneg', 'a'), 'b', 'd'), ('fmul', 'a', 'b')) => ('bcsel', 'c', 'd', ('fmul', 'a', 'b')) */
   /* search216_0_0 -> 652 in the cache */
   /* search216_0 -> 653 in the cache */
   { .variable = {
      { nir_search_value_variable, 16 },
      1, /* a */
      false,
      nir_type_invalid,
      -1,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fneg,
      -1, 0,
      { 657 },
      -1,
   } },
   /* search216_1_1 -> 620 in the cache */
   /* search216_1_2 -> 607 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ffma,
      1, 1,
      { 658, 620, 607 },
      -1,
   } },
   /* search216_2_0 -> 657 in the cache */
   /* search216_2_1 -> 620 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fmul,
      2, 1,
      { 657, 620 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 16 },
      true,
      false,
      false,
      false,
      false,
      false,
      nir_op_ffma,
      0, 3,
      { 653, 659, 660 },
      -1,
   } },

   /* replace216_0 -> 652 in the cache */
   /* replace216_1 -> 607 in the cache */
   /* replace216_2_0 -> 657 in the cache */
   /* replace216_2_1 -> 620 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fmul,
      0, 1,
      { 657, 620 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_bcsel,
      -1, 1,
      { 652, 607, 662 },
      -1,
   } },

   /* ('~fadd@16', 1.0, ('fneg', ('fmul', ('fadd', 1.0, ('fneg', 'a')), ('fadd', 1.0, ('fneg', 'b'))))) => ('flrp', 'b', 1.0, 'a') */
   /* search217_0 -> 613 in the cache */
   /* search217_1_0_0_0 -> 613 in the cache */
   /* search217_1_0_0_1_0 -> 24 in the cache */
   /* search217_1_0_0_1 -> 513 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fadd,
      2, 1,
      { 613, 513 },
      -1,
   } },
   /* search217_1_0_1_0 -> 613 in the cache */
   /* search217_1_0_1_1_0 -> 595 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fneg,
      -1, 0,
      { 595 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fadd,
      3, 1,
      { 613, 665 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fmul,
      1, 3,
      { 664, 666 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fneg,
      -1, 3,
      { 667 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 16 },
      true,
      false,
      false,
      false,
      false,
      false,
      nir_op_fadd,
      0, 4,
      { 613, 668 },
      -1,
   } },

   /* replace217_0 -> 595 in the cache */
   /* replace217_1 -> 613 in the cache */
   /* replace217_2 -> 24 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_flrp,
      -1, 0,
      { 595, 613, 24 },
      -1,
   } },

   /* ('~flrp@32', 'a', 'b', ('b2f', 'c@1')) => ('bcsel', 'c', 'b', 'a') */
   /* search218_0 -> 29 in the cache */
   /* search218_1 -> 48 in the cache */
   /* search218_2_0 -> 596 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_search_op_b2f,
      -1, 0,
      { 596 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      true,
      false,
      false,
      false,
      false,
      false,
      nir_op_flrp,
      -1, 0,
      { 29, 48, 671 },
      -1,
   } },

   /* replace218_0 -> 596 in the cache */
   /* replace218_1 -> 48 in the cache */
   /* replace218_2 -> 29 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_bcsel,
      -1, 0,
      { 596, 48, 29 },
      -1,
   } },

   /* ('~flrp@32', 'a', ('fadd', 'a', 'b'), 'c') => ('fadd', ('fmul', 'b', 'c'), 'a') */
   /* search219_0 -> 29 in the cache */
   /* search219_1_0 -> 29 in the cache */
   /* search219_1_1 -> 48 in the cache */
   /* search219_1 -> 301 in the cache */
   /* search219_2 -> 152 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      true,
      false,
      false,
      false,
      false,
      false,
      nir_op_flrp,
      -1, 1,
      { 29, 301, 152 },
      -1,
   } },

   /* replace219_0_0 -> 48 in the cache */
   /* replace219_0_1 -> 152 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fmul,
      1, 1,
      { 48, 152 },
      -1,
   } },
   /* replace219_1 -> 29 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fadd,
      0, 2,
      { 675, 29 },
      -1,
   } },

   /* ('~flrp@32', ('fadd(is_used_once)', 'a', 'b'), ('fadd(is_used_once)', 'a', 'c'), 'd') => ('fadd', ('flrp', 'b', 'c', 'd'), 'a') */
   /* search220_0_0 -> 29 in the cache */
   /* search220_0_1 -> 48 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fadd,
      0, 1,
      { 29, 48 },
      0,
   } },
   /* search220_1_0 -> 29 in the cache */
   /* search220_1_1 -> 152 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fadd,
      1, 1,
      { 29, 152 },
      0,
   } },
   /* search220_2 -> 180 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      true,
      false,
      false,
      false,
      false,
      false,
      nir_op_flrp,
      -1, 2,
      { 677, 678, 180 },
      -1,
   } },

   /* replace220_0_0 -> 48 in the cache */
   /* replace220_0_1 -> 152 in the cache */
   /* replace220_0_2 -> 180 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_flrp,
      -1, 0,
      { 48, 152, 180 },
      -1,
   } },
   /* replace220_1 -> 29 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fadd,
      0, 1,
      { 680, 29 },
      -1,
   } },

   /* ('~flrp@32', 'a', ('fmul(is_used_once)', 'a', 'b'), 'c') => ('fmul', ('flrp', 1.0, 'b', 'c'), 'a') */
   /* search221_0 -> 29 in the cache */
   /* search221_1_0 -> 29 in the cache */
   /* search221_1_1 -> 48 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fmul,
      0, 1,
      { 29, 48 },
      0,
   } },
   /* search221_2 -> 152 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      true,
      false,
      false,
      false,
      false,
      false,
      nir_op_flrp,
      -1, 1,
      { 29, 682, 152 },
      -1,
   } },

   /* replace221_0_0 -> 275 in the cache */
   /* replace221_0_1 -> 48 in the cache */
   /* replace221_0_2 -> 152 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_flrp,
      -1, 0,
      { 275, 48, 152 },
      -1,
   } },
   /* replace221_1 -> 29 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fmul,
      0, 1,
      { 684, 29 },
      -1,
   } },

   /* ('~fadd@32', ('fmul', 'a', ('fadd', 1.0, ('fneg', 'c'))), ('fmul', 'b', 'c')) => ('flrp', 'a', 'b', 'c') */
   /* search222_0_0 -> 29 in the cache */
   /* search222_0_1_0 -> 275 in the cache */
   { .variable = {
      { nir_search_value_variable, 32 },
      1, /* c */
      false,
      nir_type_invalid,
      -1,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fneg,
      -1, 0,
      { 686 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fadd,
      2, 1,
      { 275, 687 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fmul,
      1, 2,
      { 29, 688 },
      -1,
   } },
   { .variable = {
      { nir_search_value_variable, 32 },
      2, /* b */
      false,
      nir_type_invalid,
      -1,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   /* search222_1_1 -> 686 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fmul,
      3, 1,
      { 690, 686 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      true,
      false,
      false,
      false,
      false,
      false,
      nir_op_fadd,
      0, 4,
      { 689, 691 },
      -1,
   } },

   /* replace222_0 -> 29 in the cache */
   /* replace222_1 -> 690 in the cache */
   /* replace222_2 -> 686 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_flrp,
      -1, 0,
      { 29, 690, 686 },
      -1,
   } },

   /* ('~fadd@32', ('fmul', 'a', ('fsat', ('fadd', 1.0, ('fneg', 'c')))), ('fmul', 'b', ('fsat', 'c'))) => ('flrp', 'a', 'b', ('fsat', 'c')) */
   /* search223_0_0 -> 29 in the cache */
   /* search223_0_1_0_0 -> 275 in the cache */
   /* search223_0_1_0_1_0 -> 686 in the cache */
   /* search223_0_1_0_1 -> 687 in the cache */
   /* search223_0_1_0 -> 688 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fsat,
      -1, 1,
      { 688 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fmul,
      1, 2,
      { 29, 694 },
      -1,
   } },
   /* search223_1_0 -> 690 in the cache */
   /* search223_1_1_0 -> 686 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fsat,
      -1, 0,
      { 686 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fmul,
      3, 1,
      { 690, 696 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      true,
      false,
      false,
      false,
      false,
      false,
      nir_op_fadd,
      0, 4,
      { 695, 697 },
      -1,
   } },

   /* replace223_0 -> 29 in the cache */
   /* replace223_1 -> 690 in the cache */
   /* replace223_2_0 -> 686 in the cache */
   /* replace223_2 -> 696 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_flrp,
      -1, 0,
      { 29, 690, 696 },
      -1,
   } },

   /* ('~fadd@32', 'a', ('fmul', 'c', ('fadd', 'b', ('fneg', 'a')))) => ('flrp', 'a', 'b', 'c') */
   /* search224_0 -> 29 in the cache */
   /* search224_1_0 -> 686 in the cache */
   /* search224_1_1_0 -> 690 in the cache */
   /* search224_1_1_1_0 -> 29 in the cache */
   /* search224_1_1_1 -> 307 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fadd,
      2, 1,
      { 690, 307 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fmul,
      1, 2,
      { 686, 700 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      true,
      false,
      false,
      false,
      false,
      false,
      nir_op_fadd,
      0, 3,
      { 29, 701 },
      -1,
   } },

   /* replace224_0 -> 29 in the cache */
   /* replace224_1 -> 690 in the cache */
   /* replace224_2 -> 686 in the cache */
   /* replace224 -> 693 in the cache */

   /* ('~fadd@32', ('fmul', 'a', ('fadd', 1.0, ('fneg', ('b2f', 'c@1')))), ('fmul', 'b', ('b2f', 'c'))) => ('bcsel', 'c', 'b', 'a') */
   /* search225_0_0 -> 29 in the cache */
   /* search225_0_1_0 -> 275 in the cache */
   /* search225_0_1_1_0_0 -> 633 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_search_op_b2f,
      -1, 0,
      { 633 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fneg,
      -1, 0,
      { 703 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fadd,
      2, 1,
      { 275, 704 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fmul,
      1, 2,
      { 29, 705 },
      -1,
   } },
   /* search225_1_0 -> 690 in the cache */
   /* search225_1_1_0 -> 633 in the cache */
   /* search225_1_1 -> 703 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fmul,
      3, 1,
      { 690, 703 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      true,
      false,
      false,
      false,
      false,
      false,
      nir_op_fadd,
      0, 4,
      { 706, 707 },
      -1,
   } },

   /* replace225_0 -> 633 in the cache */
   /* replace225_1 -> 690 in the cache */
   /* replace225_2 -> 29 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_bcsel,
      -1, 0,
      { 633, 690, 29 },
      -1,
   } },

   /* ('~fadd@32', 'a', ('fmul', ('b2f', 'c@1'), ('fadd', 'b', ('fneg', 'a')))) => ('bcsel', 'c', 'b', 'a') */
   /* search226_0 -> 29 in the cache */
   /* search226_1_0_0 -> 633 in the cache */
   /* search226_1_0 -> 703 in the cache */
   /* search226_1_1_0 -> 690 in the cache */
   /* search226_1_1_1_0 -> 29 in the cache */
   /* search226_1_1_1 -> 307 in the cache */
   /* search226_1_1 -> 700 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fmul,
      1, 2,
      { 703, 700 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      true,
      false,
      false,
      false,
      false,
      false,
      nir_op_fadd,
      0, 3,
      { 29, 710 },
      -1,
   } },

   /* replace226_0 -> 633 in the cache */
   /* replace226_1 -> 690 in the cache */
   /* replace226_2 -> 29 in the cache */
   /* replace226 -> 709 in the cache */

   /* ('~ffma@32', 'a', ('fadd', 1.0, ('fneg', ('b2f', 'c@1'))), ('fmul', 'b', ('b2f', 'c@1'))) => ('bcsel', 'c', 'b', 'a') */
   /* search227_0 -> 29 in the cache */
   /* search227_1_0 -> 275 in the cache */
   /* search227_1_1_0_0 -> 633 in the cache */
   /* search227_1_1_0 -> 703 in the cache */
   /* search227_1_1 -> 704 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fadd,
      1, 1,
      { 275, 704 },
      -1,
   } },
   /* search227_2_0 -> 690 in the cache */
   /* search227_2_1_0 -> 633 in the cache */
   /* search227_2_1 -> 703 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fmul,
      2, 1,
      { 690, 703 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      true,
      false,
      false,
      false,
      false,
      false,
      nir_op_ffma,
      0, 3,
      { 29, 712, 713 },
      -1,
   } },

   /* replace227_0 -> 633 in the cache */
   /* replace227_1 -> 690 in the cache */
   /* replace227_2 -> 29 in the cache */
   /* replace227 -> 709 in the cache */

   /* ('~ffma@32', 'b', ('b2f', 'c@1'), ('ffma', ('fneg', 'a'), ('b2f', 'c@1'), 'a')) => ('bcsel', 'c', 'b', 'a') */
   /* search228_0 -> 400 in the cache */
   /* search228_1_0 -> 633 in the cache */
   /* search228_1 -> 703 in the cache */
   { .variable = {
      { nir_search_value_variable, 32 },
      2, /* a */
      false,
      nir_type_invalid,
      -1,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fneg,
      -1, 0,
      { 715 },
      -1,
   } },
   /* search228_2_1_0 -> 633 in the cache */
   /* search228_2_1 -> 703 in the cache */
   /* search228_2_2 -> 715 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ffma,
      1, 1,
      { 716, 703, 715 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      true,
      false,
      false,
      false,
      false,
      false,
      nir_op_ffma,
      0, 2,
      { 400, 703, 717 },
      -1,
   } },

   /* replace228_0 -> 633 in the cache */
   /* replace228_1 -> 400 in the cache */
   /* replace228_2 -> 715 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_bcsel,
      -1, 0,
      { 633, 400, 715 },
      -1,
   } },

   /* ('~ffma@32', ('b2f', 'c@1'), ('fadd', 'b', ('fneg', 'a')), 'a') => ('bcsel', 'c', 'b', 'a') */
   /* search229_0_0 -> 652 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_search_op_b2f,
      -1, 0,
      { 652 },
      -1,
   } },
   /* search229_1_0 -> 48 in the cache */
   /* search229_1_1_0 -> 715 in the cache */
   /* search229_1_1 -> 716 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fadd,
      1, 1,
      { 48, 716 },
      -1,
   } },
   /* search229_2 -> 715 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      true,
      false,
      false,
      false,
      false,
      false,
      nir_op_ffma,
      0, 2,
      { 720, 721, 715 },
      -1,
   } },

   /* replace229_0 -> 652 in the cache */
   /* replace229_1 -> 48 in the cache */
   /* replace229_2 -> 715 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_bcsel,
      -1, 0,
      { 652, 48, 715 },
      -1,
   } },

   /* ('~ffma@32', ('b2f', 'c@1'), ('ffma', ('fneg', 'a'), 'b', 'd'), ('fmul', 'a', 'b')) => ('bcsel', 'c', 'd', ('fmul', 'a', 'b')) */
   /* search230_0_0 -> 652 in the cache */
   /* search230_0 -> 720 in the cache */
   /* search230_1_0_0 -> 200 in the cache */
   /* search230_1_0 -> 428 in the cache */
   /* search230_1_1 -> 690 in the cache */
   /* search230_1_2 -> 180 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ffma,
      1, 1,
      { 428, 690, 180 },
      -1,
   } },
   /* search230_2_0 -> 200 in the cache */
   /* search230_2_1 -> 690 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fmul,
      2, 1,
      { 200, 690 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      true,
      false,
      false,
      false,
      false,
      false,
      nir_op_ffma,
      0, 3,
      { 720, 724, 725 },
      -1,
   } },

   /* replace230_0 -> 652 in the cache */
   /* replace230_1 -> 180 in the cache */
   /* replace230_2_0 -> 200 in the cache */
   /* replace230_2_1 -> 690 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fmul,
      0, 1,
      { 200, 690 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_bcsel,
      -1, 1,
      { 652, 180, 727 },
      -1,
   } },

   /* ('~fadd@32', 1.0, ('fneg', ('fmul', ('fadd', 1.0, ('fneg', 'a')), ('fadd', 1.0, ('fneg', 'b'))))) => ('flrp', 'b', 1.0, 'a') */
   /* search231_0 -> 275 in the cache */
   /* search231_1_0_0_0 -> 275 in the cache */
   /* search231_1_0_0_1_0 -> 29 in the cache */
   /* search231_1_0_0_1 -> 307 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fadd,
      2, 1,
      { 275, 307 },
      -1,
   } },
   /* search231_1_0_1_0 -> 275 in the cache */
   /* search231_1_0_1_1_0 -> 48 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fneg,
      -1, 0,
      { 48 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fadd,
      3, 1,
      { 275, 730 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fmul,
      1, 3,
      { 729, 731 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fneg,
      -1, 3,
      { 732 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      true,
      false,
      false,
      false,
      false,
      false,
      nir_op_fadd,
      0, 4,
      { 275, 733 },
      -1,
   } },

   /* replace231_0 -> 48 in the cache */
   /* replace231_1 -> 275 in the cache */
   /* replace231_2 -> 29 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_flrp,
      -1, 0,
      { 48, 275, 29 },
      -1,
   } },

   /* ('~flrp@64', 'a', 'b', ('b2f', 'c@1')) => ('bcsel', 'c', 'b', 'a') */
   /* search232_0 -> 34 in the cache */
   /* search232_1 -> 53 in the cache */
   /* search232_2_0 -> 596 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_search_op_b2f,
      -1, 0,
      { 596 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 64 },
      true,
      false,
      false,
      false,
      false,
      false,
      nir_op_flrp,
      -1, 0,
      { 34, 53, 736 },
      -1,
   } },

   /* replace232_0 -> 596 in the cache */
   /* replace232_1 -> 53 in the cache */
   /* replace232_2 -> 34 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_bcsel,
      -1, 0,
      { 596, 53, 34 },
      -1,
   } },

   /* ('~flrp@64', 'a', ('fadd', 'a', 'b'), 'c') => ('fadd', ('fmul', 'b', 'c'), 'a') */
   /* search233_0 -> 34 in the cache */
   /* search233_1_0 -> 34 in the cache */
   /* search233_1_1 -> 53 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fadd,
      0, 1,
      { 34, 53 },
      -1,
   } },
   { .variable = {
      { nir_search_value_variable, 64 },
      2, /* c */
      false,
      nir_type_invalid,
      -1,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .expression = {
      { nir_search_value_expression, 64 },
      true,
      false,
      false,
      false,
      false,
      false,
      nir_op_flrp,
      -1, 1,
      { 34, 739, 740 },
      -1,
   } },

   /* replace233_0_0 -> 53 in the cache */
   /* replace233_0_1 -> 740 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fmul,
      1, 1,
      { 53, 740 },
      -1,
   } },
   /* replace233_1 -> 34 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fadd,
      0, 2,
      { 742, 34 },
      -1,
   } },

   /* ('~flrp@64', ('fadd(is_used_once)', 'a', 'b'), ('fadd(is_used_once)', 'a', 'c'), 'd') => ('fadd', ('flrp', 'b', 'c', 'd'), 'a') */
   /* search234_0_0 -> 34 in the cache */
   /* search234_0_1 -> 53 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fadd,
      0, 1,
      { 34, 53 },
      0,
   } },
   /* search234_1_0 -> 34 in the cache */
   /* search234_1_1 -> 740 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fadd,
      1, 1,
      { 34, 740 },
      0,
   } },
   { .variable = {
      { nir_search_value_variable, 64 },
      3, /* d */
      false,
      nir_type_invalid,
      -1,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .expression = {
      { nir_search_value_expression, 64 },
      true,
      false,
      false,
      false,
      false,
      false,
      nir_op_flrp,
      -1, 2,
      { 744, 745, 746 },
      -1,
   } },

   /* replace234_0_0 -> 53 in the cache */
   /* replace234_0_1 -> 740 in the cache */
   /* replace234_0_2 -> 746 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_flrp,
      -1, 0,
      { 53, 740, 746 },
      -1,
   } },
   /* replace234_1 -> 34 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fadd,
      0, 1,
      { 748, 34 },
      -1,
   } },

   /* ('~flrp@64', 'a', ('fmul(is_used_once)', 'a', 'b'), 'c') => ('fmul', ('flrp', 1.0, 'b', 'c'), 'a') */
   /* search235_0 -> 34 in the cache */
   /* search235_1_0 -> 34 in the cache */
   /* search235_1_1 -> 53 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fmul,
      0, 1,
      { 34, 53 },
      0,
   } },
   /* search235_2 -> 740 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      true,
      false,
      false,
      false,
      false,
      false,
      nir_op_flrp,
      -1, 1,
      { 34, 750, 740 },
      -1,
   } },

   { .constant = {
      { nir_search_value_constant, 64 },
      nir_type_float, { 0x3ff0000000000000ull /* 1.0 */ },
   } },
   /* replace235_0_1 -> 53 in the cache */
   /* replace235_0_2 -> 740 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_flrp,
      -1, 0,
      { 752, 53, 740 },
      -1,
   } },
   /* replace235_1 -> 34 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fmul,
      0, 1,
      { 753, 34 },
      -1,
   } },

   /* ('~fadd@64', ('fmul', 'a', ('fadd', 1.0, ('fneg', 'c'))), ('fmul', 'b', 'c')) => ('flrp', 'a', 'b', 'c') */
   /* search236_0_0 -> 34 in the cache */
   /* search236_0_1_0 -> 752 in the cache */
   { .variable = {
      { nir_search_value_variable, 64 },
      1, /* c */
      false,
      nir_type_invalid,
      -1,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fneg,
      -1, 0,
      { 755 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fadd,
      2, 1,
      { 752, 756 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fmul,
      1, 2,
      { 34, 757 },
      -1,
   } },
   { .variable = {
      { nir_search_value_variable, 64 },
      2, /* b */
      false,
      nir_type_invalid,
      -1,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   /* search236_1_1 -> 755 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fmul,
      3, 1,
      { 759, 755 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 64 },
      true,
      false,
      false,
      false,
      false,
      false,
      nir_op_fadd,
      0, 4,
      { 758, 760 },
      -1,
   } },

   /* replace236_0 -> 34 in the cache */
   /* replace236_1 -> 759 in the cache */
   /* replace236_2 -> 755 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_flrp,
      -1, 0,
      { 34, 759, 755 },
      -1,
   } },

   /* ('~fadd@64', ('fmul', 'a', ('fsat', ('fadd', 1.0, ('fneg', 'c')))), ('fmul', 'b', ('fsat', 'c'))) => ('flrp', 'a', 'b', ('fsat', 'c')) */
   /* search237_0_0 -> 34 in the cache */
   /* search237_0_1_0_0 -> 752 in the cache */
   /* search237_0_1_0_1_0 -> 755 in the cache */
   /* search237_0_1_0_1 -> 756 in the cache */
   /* search237_0_1_0 -> 757 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fsat,
      -1, 1,
      { 757 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fmul,
      1, 2,
      { 34, 763 },
      -1,
   } },
   /* search237_1_0 -> 759 in the cache */
   /* search237_1_1_0 -> 755 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fsat,
      -1, 0,
      { 755 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fmul,
      3, 1,
      { 759, 765 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 64 },
      true,
      false,
      false,
      false,
      false,
      false,
      nir_op_fadd,
      0, 4,
      { 764, 766 },
      -1,
   } },

   /* replace237_0 -> 34 in the cache */
   /* replace237_1 -> 759 in the cache */
   /* replace237_2_0 -> 755 in the cache */
   /* replace237_2 -> 765 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_flrp,
      -1, 0,
      { 34, 759, 765 },
      -1,
   } },

   /* ('~fadd@64', 'a', ('fmul', 'c', ('fadd', 'b', ('fneg', 'a')))) => ('flrp', 'a', 'b', 'c') */
   /* search238_0 -> 34 in the cache */
   /* search238_1_0 -> 755 in the cache */
   /* search238_1_1_0 -> 759 in the cache */
   /* search238_1_1_1_0 -> 34 in the cache */
   /* search238_1_1_1 -> 524 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fadd,
      2, 1,
      { 759, 524 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fmul,
      1, 2,
      { 755, 769 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 64 },
      true,
      false,
      false,
      false,
      false,
      false,
      nir_op_fadd,
      0, 3,
      { 34, 770 },
      -1,
   } },

   /* replace238_0 -> 34 in the cache */
   /* replace238_1 -> 759 in the cache */
   /* replace238_2 -> 755 in the cache */
   /* replace238 -> 762 in the cache */

   /* ('~fadd@64', ('fmul', 'a', ('fadd', 1.0, ('fneg', ('b2f', 'c@1')))), ('fmul', 'b', ('b2f', 'c'))) => ('bcsel', 'c', 'b', 'a') */
   /* search239_0_0 -> 34 in the cache */
   /* search239_0_1_0 -> 752 in the cache */
   /* search239_0_1_1_0_0 -> 633 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_search_op_b2f,
      -1, 0,
      { 633 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fneg,
      -1, 0,
      { 772 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fadd,
      2, 1,
      { 752, 773 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fmul,
      1, 2,
      { 34, 774 },
      -1,
   } },
   /* search239_1_0 -> 759 in the cache */
   /* search239_1_1_0 -> 633 in the cache */
   /* search239_1_1 -> 772 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fmul,
      3, 1,
      { 759, 772 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 64 },
      true,
      false,
      false,
      false,
      false,
      false,
      nir_op_fadd,
      0, 4,
      { 775, 776 },
      -1,
   } },

   /* replace239_0 -> 633 in the cache */
   /* replace239_1 -> 759 in the cache */
   /* replace239_2 -> 34 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_bcsel,
      -1, 0,
      { 633, 759, 34 },
      -1,
   } },

   /* ('~fadd@64', 'a', ('fmul', ('b2f', 'c@1'), ('fadd', 'b', ('fneg', 'a')))) => ('bcsel', 'c', 'b', 'a') */
   /* search240_0 -> 34 in the cache */
   /* search240_1_0_0 -> 633 in the cache */
   /* search240_1_0 -> 772 in the cache */
   /* search240_1_1_0 -> 759 in the cache */
   /* search240_1_1_1_0 -> 34 in the cache */
   /* search240_1_1_1 -> 524 in the cache */
   /* search240_1_1 -> 769 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fmul,
      1, 2,
      { 772, 769 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 64 },
      true,
      false,
      false,
      false,
      false,
      false,
      nir_op_fadd,
      0, 3,
      { 34, 779 },
      -1,
   } },

   /* replace240_0 -> 633 in the cache */
   /* replace240_1 -> 759 in the cache */
   /* replace240_2 -> 34 in the cache */
   /* replace240 -> 778 in the cache */

   /* ('~ffma@64', 'a', ('fadd', 1.0, ('fneg', ('b2f', 'c@1'))), ('fmul', 'b', ('b2f', 'c@1'))) => ('bcsel', 'c', 'b', 'a') */
   /* search241_0 -> 34 in the cache */
   /* search241_1_0 -> 752 in the cache */
   /* search241_1_1_0_0 -> 633 in the cache */
   /* search241_1_1_0 -> 772 in the cache */
   /* search241_1_1 -> 773 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fadd,
      1, 1,
      { 752, 773 },
      -1,
   } },
   /* search241_2_0 -> 759 in the cache */
   /* search241_2_1_0 -> 633 in the cache */
   /* search241_2_1 -> 772 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fmul,
      2, 1,
      { 759, 772 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 64 },
      true,
      false,
      false,
      false,
      false,
      false,
      nir_op_ffma,
      0, 3,
      { 34, 781, 782 },
      -1,
   } },

   /* replace241_0 -> 633 in the cache */
   /* replace241_1 -> 759 in the cache */
   /* replace241_2 -> 34 in the cache */
   /* replace241 -> 778 in the cache */

   /* ('~ffma@64', 'b', ('b2f', 'c@1'), ('ffma', ('fneg', 'a'), ('b2f', 'c@1'), 'a')) => ('bcsel', 'c', 'b', 'a') */
   { .variable = {
      { nir_search_value_variable, 64 },
      0, /* b */
      false,
      nir_type_invalid,
      -1,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   /* search242_1_0 -> 633 in the cache */
   /* search242_1 -> 772 in the cache */
   { .variable = {
      { nir_search_value_variable, 64 },
      2, /* a */
      false,
      nir_type_invalid,
      -1,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fneg,
      -1, 0,
      { 785 },
      -1,
   } },
   /* search242_2_1_0 -> 633 in the cache */
   /* search242_2_1 -> 772 in the cache */
   /* search242_2_2 -> 785 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ffma,
      1, 1,
      { 786, 772, 785 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 64 },
      true,
      false,
      false,
      false,
      false,
      false,
      nir_op_ffma,
      0, 2,
      { 784, 772, 787 },
      -1,
   } },

   /* replace242_0 -> 633 in the cache */
   /* replace242_1 -> 784 in the cache */
   /* replace242_2 -> 785 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_bcsel,
      -1, 0,
      { 633, 784, 785 },
      -1,
   } },

   /* ('~ffma@64', ('b2f', 'c@1'), ('fadd', 'b', ('fneg', 'a')), 'a') => ('bcsel', 'c', 'b', 'a') */
   /* search243_0_0 -> 652 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_search_op_b2f,
      -1, 0,
      { 652 },
      -1,
   } },
   /* search243_1_0 -> 53 in the cache */
   /* search243_1_1_0 -> 785 in the cache */
   /* search243_1_1 -> 786 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fadd,
      1, 1,
      { 53, 786 },
      -1,
   } },
   /* search243_2 -> 785 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      true,
      false,
      false,
      false,
      false,
      false,
      nir_op_ffma,
      0, 2,
      { 790, 791, 785 },
      -1,
   } },

   /* replace243_0 -> 652 in the cache */
   /* replace243_1 -> 53 in the cache */
   /* replace243_2 -> 785 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_bcsel,
      -1, 0,
      { 652, 53, 785 },
      -1,
   } },

   /* ('~ffma@64', ('b2f', 'c@1'), ('ffma', ('fneg', 'a'), 'b', 'd'), ('fmul', 'a', 'b')) => ('bcsel', 'c', 'd', ('fmul', 'a', 'b')) */
   /* search244_0_0 -> 652 in the cache */
   /* search244_0 -> 790 in the cache */
   { .variable = {
      { nir_search_value_variable, 64 },
      1, /* a */
      false,
      nir_type_invalid,
      -1,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fneg,
      -1, 0,
      { 794 },
      -1,
   } },
   /* search244_1_1 -> 759 in the cache */
   /* search244_1_2 -> 746 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ffma,
      1, 1,
      { 795, 759, 746 },
      -1,
   } },
   /* search244_2_0 -> 794 in the cache */
   /* search244_2_1 -> 759 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fmul,
      2, 1,
      { 794, 759 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 64 },
      true,
      false,
      false,
      false,
      false,
      false,
      nir_op_ffma,
      0, 3,
      { 790, 796, 797 },
      -1,
   } },

   /* replace244_0 -> 652 in the cache */
   /* replace244_1 -> 746 in the cache */
   /* replace244_2_0 -> 794 in the cache */
   /* replace244_2_1 -> 759 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fmul,
      0, 1,
      { 794, 759 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_bcsel,
      -1, 1,
      { 652, 746, 799 },
      -1,
   } },

   /* ('~fadd@64', 1.0, ('fneg', ('fmul', ('fadd', 1.0, ('fneg', 'a')), ('fadd', 1.0, ('fneg', 'b'))))) => ('flrp', 'b', 1.0, 'a') */
   /* search245_0 -> 752 in the cache */
   /* search245_1_0_0_0 -> 752 in the cache */
   /* search245_1_0_0_1_0 -> 34 in the cache */
   /* search245_1_0_0_1 -> 524 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fadd,
      2, 1,
      { 752, 524 },
      -1,
   } },
   /* search245_1_0_1_0 -> 752 in the cache */
   /* search245_1_0_1_1_0 -> 53 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fneg,
      -1, 0,
      { 53 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fadd,
      3, 1,
      { 752, 802 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fmul,
      1, 3,
      { 801, 803 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fneg,
      -1, 3,
      { 804 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 64 },
      true,
      false,
      false,
      false,
      false,
      false,
      nir_op_fadd,
      0, 4,
      { 752, 805 },
      -1,
   } },

   /* replace245_0 -> 53 in the cache */
   /* replace245_1 -> 752 in the cache */
   /* replace245_2 -> 34 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_flrp,
      -1, 0,
      { 53, 752, 34 },
      -1,
   } },

   /* ('~flrp', ('fmul(is_used_once)', 'a', 'b'), ('fmul(is_used_once)', 'a', 'c'), 'd') => ('fmul', ('flrp', 'b', 'c', 'd'), 'a') */
   /* search246_0_0 -> 166 in the cache */
   /* search246_0_1 -> 167 in the cache */
   { .expression = {
      { nir_search_value_expression, -4 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fmul,
      0, 1,
      { 166, 167 },
      0,
   } },
   /* search246_1_0 -> 166 in the cache */
   /* search246_1_1 -> 169 in the cache */
   { .expression = {
      { nir_search_value_expression, -4 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fmul,
      1, 1,
      { 166, 169 },
      0,
   } },
   /* search246_2 -> 170 in the cache */
   { .expression = {
      { nir_search_value_expression, -4 },
      true,
      false,
      false,
      false,
      false,
      false,
      nir_op_flrp,
      -1, 2,
      { 808, 809, 170 },
      -1,
   } },

   /* replace246_0_0 -> 167 in the cache */
   /* replace246_0_1 -> 169 in the cache */
   /* replace246_0_2 -> 170 in the cache */
   { .expression = {
      { nir_search_value_expression, -4 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_flrp,
      -1, 0,
      { 167, 169, 170 },
      -1,
   } },
   /* replace246_1 -> 166 in the cache */
   { .expression = {
      { nir_search_value_expression, -4 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fmul,
      0, 1,
      { 811, 166 },
      -1,
   } },

   /* ('~flrp', 'a', 0.0, 'c') => ('fadd', ('fmul', ('fneg', 'a'), 'c'), 'a') */
   /* search247_0 -> 0 in the cache */
   /* search247_1 -> 287 in the cache */
   { .variable = {
      { nir_search_value_variable, -2 },
      1, /* c */
      false,
      nir_type_invalid,
      -1,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .expression = {
      { nir_search_value_expression, -2 },
      true,
      false,
      false,
      false,
      false,
      false,
      nir_op_flrp,
      -1, 0,
      { 0, 287, 813 },
      -1,
   } },

   /* replace247_0_0_0 -> 0 in the cache */
   /* replace247_0_0 -> 132 in the cache */
   /* replace247_0_1 -> 813 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fmul,
      1, 1,
      { 132, 813 },
      -1,
   } },
   /* replace247_1 -> 0 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fadd,
      0, 2,
      { 815, 0 },
      -1,
   } },

   /* ('fadd', ('ffloor', 'a'), ('b2f', ('iand', ('flt', 'a', 0), ('flt', ('fneg', ('ffract', 'a')), ('ffract', 'a'))))) => ('ftrunc', ('fadd', 'a', 0)) */
   /* search248_0_0 -> 9 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ffloor,
      -1, 0,
      { 9 },
      -1,
   } },
   /* search248_1_0_0_0 -> 9 in the cache */
   /* search248_1_0_0_1 -> 73 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_flt,
      -1, 0,
      { 9, 73 },
      -1,
   } },
   /* search248_1_0_1_0_0_0 -> 9 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ffract,
      -1, 0,
      { 9 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fneg,
      -1, 0,
      { 819 },
      -1,
   } },
   /* search248_1_0_1_1_0 -> 9 in the cache */
   /* search248_1_0_1_1 -> 819 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_flt,
      -1, 0,
      { 820, 819 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_iand,
      1, 1,
      { 818, 821 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_search_op_b2f,
      -1, 1,
      { 822 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fadd,
      0, 2,
      { 817, 823 },
      -1,
   } },

   /* replace248_0_0 -> 9 in the cache */
   /* replace248_0_1 -> 73 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fadd,
      0, 1,
      { 9, 73 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ftrunc,
      -1, 1,
      { 825 },
      -1,
   } },

   /* ('fadd', ('ffloor', 'a'), ('b2f', ('inot', ('fge', 0, ('fmin', ('fneg', 'a'), ('ffract', 'a')))))) => ('ftrunc', ('fadd', 'a', 0)) */
   /* search249_0_0 -> 9 in the cache */
   /* search249_0 -> 817 in the cache */
   /* search249_1_0_0_0 -> 73 in the cache */
   /* search249_1_0_0_1_0_0 -> 9 in the cache */
   /* search249_1_0_0_1_0 -> 118 in the cache */
   /* search249_1_0_0_1_1_0 -> 9 in the cache */
   /* search249_1_0_0_1_1 -> 819 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fmin,
      1, 1,
      { 118, 819 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fge,
      -1, 1,
      { 73, 827 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_inot,
      -1, 1,
      { 828 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_search_op_b2f,
      -1, 1,
      { 829 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fadd,
      0, 2,
      { 817, 830 },
      -1,
   } },

   /* replace249_0_0 -> 9 in the cache */
   /* replace249_0_1 -> 73 in the cache */
   /* replace249_0 -> 825 in the cache */
   /* replace249 -> 826 in the cache */

   /* ('fadd', ('ffloor', 'a'), ('b2f', ('flt', 0, ('fmin', ('fneg', 'a'), ('ffract', 'a'))))) => ('ftrunc', ('fadd', 'a', 0)) */
   /* search250_0_0 -> 9 in the cache */
   /* search250_0 -> 817 in the cache */
   /* search250_1_0_0 -> 73 in the cache */
   /* search250_1_0_1_0_0 -> 9 in the cache */
   /* search250_1_0_1_0 -> 118 in the cache */
   /* search250_1_0_1_1_0 -> 9 in the cache */
   /* search250_1_0_1_1 -> 819 in the cache */
   /* search250_1_0_1 -> 827 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_flt,
      -1, 1,
      { 73, 827 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_search_op_b2f,
      -1, 1,
      { 832 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fadd,
      0, 2,
      { 817, 833 },
      -1,
   } },

   /* replace250_0_0 -> 9 in the cache */
   /* replace250_0_1 -> 73 in the cache */
   /* replace250_0 -> 825 in the cache */
   /* replace250 -> 826 in the cache */

   /* ('fadd(nnan,nsz)', 'a', ('ffract', ('fneg', 'a'))) => ('fceil', 'a') */
   /* search251_0 -> 9 in the cache */
   /* search251_1_0_0 -> 9 in the cache */
   /* search251_1_0 -> 118 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ffract,
      -1, 0,
      { 118 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      true,
      true,
      false,
      nir_op_fadd,
      0, 1,
      { 9, 835 },
      -1,
   } },

   /* replace251_0 -> 9 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fceil,
      -1, 0,
      { 9 },
      -1,
   } },

   /* ('ftrunc@16', 'a') => ('bcsel', ('flt', 'a', 0.0), ('fneg', ('ffloor', ('fabs', 'a'))), ('ffloor', ('fabs', 'a'))) */
   /* search252_0 -> 24 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ftrunc,
      -1, 0,
      { 24 },
      -1,
   } },

   /* replace252_0_0 -> 24 in the cache */
   { .constant = {
      { nir_search_value_constant, 16 },
      nir_type_float, { 0x0ull /* 0.0 */ },
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_flt,
      -1, 0,
      { 24, 839 },
      -1,
   } },
   /* replace252_1_0_0_0 -> 24 in the cache */
   /* replace252_1_0_0 -> 511 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ffloor,
      -1, 0,
      { 511 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fneg,
      -1, 0,
      { 841 },
      -1,
   } },
   /* replace252_2_0_0 -> 24 in the cache */
   /* replace252_2_0 -> 511 in the cache */
   /* replace252_2 -> 841 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_bcsel,
      -1, 0,
      { 840, 842, 841 },
      -1,
   } },

   /* ('ftrunc@32', 'a') => ('bcsel', ('flt', 'a', 0.0), ('fneg', ('ffloor', ('fabs', 'a'))), ('ffloor', ('fabs', 'a'))) */
   /* search253_0 -> 29 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ftrunc,
      -1, 0,
      { 29 },
      -1,
   } },

   /* replace253_0_0 -> 29 in the cache */
   /* replace253_0_1 -> 255 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_flt,
      -1, 0,
      { 29, 255 },
      -1,
   } },
   /* replace253_1_0_0_0 -> 29 in the cache */
   /* replace253_1_0_0 -> 437 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ffloor,
      -1, 0,
      { 437 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fneg,
      -1, 0,
      { 846 },
      -1,
   } },
   /* replace253_2_0_0 -> 29 in the cache */
   /* replace253_2_0 -> 437 in the cache */
   /* replace253_2 -> 846 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_bcsel,
      -1, 0,
      { 845, 847, 846 },
      -1,
   } },

   /* ('ftrunc@64', 'a') => ('bcsel', ('flt', 'a', 0.0), ('fneg', ('ffloor', ('fabs', 'a'))), ('ffloor', ('fabs', 'a'))) */
   /* search254_0 -> 34 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ftrunc,
      -1, 0,
      { 34 },
      -1,
   } },

   /* replace254_0_0 -> 34 in the cache */
   { .constant = {
      { nir_search_value_constant, 64 },
      nir_type_float, { 0x0ull /* 0.0 */ },
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_flt,
      -1, 0,
      { 34, 850 },
      -1,
   } },
   /* replace254_1_0_0_0 -> 34 in the cache */
   /* replace254_1_0_0 -> 522 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ffloor,
      -1, 0,
      { 522 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fneg,
      -1, 0,
      { 852 },
      -1,
   } },
   /* replace254_2_0_0 -> 34 in the cache */
   /* replace254_2_0 -> 522 in the cache */
   /* replace254_2 -> 852 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_bcsel,
      -1, 0,
      { 851, 853, 852 },
      -1,
   } },

   /* ('ffloor@16', 'a') => ('fsub', 'a', ('ffract', 'a')) */
   /* search255_0 -> 24 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ffloor,
      -1, 0,
      { 24 },
      -1,
   } },

   /* replace255_0 -> 24 in the cache */
   /* replace255_1_0 -> 24 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ffract,
      -1, 0,
      { 24 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fsub,
      -1, 0,
      { 24, 856 },
      -1,
   } },

   /* ('ffloor@32', 'a') => ('fsub', 'a', ('ffract', 'a')) */
   /* search256_0 -> 29 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ffloor,
      -1, 0,
      { 29 },
      -1,
   } },

   /* replace256_0 -> 29 in the cache */
   /* replace256_1_0 -> 29 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ffract,
      -1, 0,
      { 29 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fsub,
      -1, 0,
      { 29, 859 },
      -1,
   } },

   /* ('ffloor@64', 'a') => ('fsub', 'a', ('ffract', 'a')) */
   /* search257_0 -> 34 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ffloor,
      -1, 0,
      { 34 },
      -1,
   } },

   /* replace257_0 -> 34 in the cache */
   /* replace257_1_0 -> 34 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ffract,
      -1, 0,
      { 34 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fsub,
      -1, 0,
      { 34, 862 },
      -1,
   } },

   /* ('fadd@16', 'a', ('fadd@16', 'b', ('fneg', ('ffract', 'a')))) => ('fadd@16', 'b', ('ffloor', 'a')) */
   /* search258_0 -> 24 in the cache */
   /* search258_1_0 -> 595 in the cache */
   /* search258_1_1_0_0 -> 24 in the cache */
   /* search258_1_1_0 -> 856 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fneg,
      -1, 0,
      { 856 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fadd,
      1, 1,
      { 595, 864 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fadd,
      0, 2,
      { 24, 865 },
      -1,
   } },

   /* replace258_0 -> 595 in the cache */
   /* replace258_1_0 -> 24 in the cache */
   /* replace258_1 -> 855 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fadd,
      0, 1,
      { 595, 855 },
      -1,
   } },

   /* ('fadd@32', 'a', ('fadd@32', 'b', ('fneg', ('ffract', 'a')))) => ('fadd@32', 'b', ('ffloor', 'a')) */
   /* search259_0 -> 29 in the cache */
   /* search259_1_0 -> 48 in the cache */
   /* search259_1_1_0_0 -> 29 in the cache */
   /* search259_1_1_0 -> 859 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fneg,
      -1, 0,
      { 859 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fadd,
      1, 1,
      { 48, 868 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fadd,
      0, 2,
      { 29, 869 },
      -1,
   } },

   /* replace259_0 -> 48 in the cache */
   /* replace259_1_0 -> 29 in the cache */
   /* replace259_1 -> 858 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fadd,
      0, 1,
      { 48, 858 },
      -1,
   } },

   /* ('fadd@64', 'a', ('fadd@64', 'b', ('fneg', ('ffract', 'a')))) => ('fadd@64', 'b', ('ffloor', 'a')) */
   /* search260_0 -> 34 in the cache */
   /* search260_1_0 -> 53 in the cache */
   /* search260_1_1_0_0 -> 34 in the cache */
   /* search260_1_1_0 -> 862 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fneg,
      -1, 0,
      { 862 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fadd,
      1, 1,
      { 53, 872 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fadd,
      0, 2,
      { 34, 873 },
      -1,
   } },

   /* replace260_0 -> 53 in the cache */
   /* replace260_1_0 -> 34 in the cache */
   /* replace260_1 -> 861 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fadd,
      0, 1,
      { 53, 861 },
      -1,
   } },

   /* ('fadd@16(nnan)', 'a', ('fneg', ('ffract', 'a'))) => ('ffloor', 'a') */
   /* search261_0 -> 24 in the cache */
   /* search261_1_0_0 -> 24 in the cache */
   /* search261_1_0 -> 856 in the cache */
   /* search261_1 -> 864 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      false,
      true,
      false,
      nir_op_fadd,
      0, 1,
      { 24, 864 },
      -1,
   } },

   /* replace261_0 -> 24 in the cache */
   /* replace261 -> 855 in the cache */

   /* ('fadd@32(nnan)', 'a', ('fneg', ('ffract', 'a'))) => ('ffloor', 'a') */
   /* search262_0 -> 29 in the cache */
   /* search262_1_0_0 -> 29 in the cache */
   /* search262_1_0 -> 859 in the cache */
   /* search262_1 -> 868 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      true,
      false,
      nir_op_fadd,
      0, 1,
      { 29, 868 },
      -1,
   } },

   /* replace262_0 -> 29 in the cache */
   /* replace262 -> 858 in the cache */

   /* ('fadd@64(nnan)', 'a', ('fneg', ('ffract', 'a'))) => ('ffloor', 'a') */
   /* search263_0 -> 34 in the cache */
   /* search263_1_0_0 -> 34 in the cache */
   /* search263_1_0 -> 862 in the cache */
   /* search263_1 -> 872 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      true,
      false,
      nir_op_fadd,
      0, 1,
      { 34, 872 },
      -1,
   } },

   /* replace263_0 -> 34 in the cache */
   /* replace263 -> 861 in the cache */

   /* ('ffract@16', 'a') => ('fsub', 'a', ('ffloor', 'a')) */
   /* search264_0 -> 24 in the cache */
   /* search264 -> 856 in the cache */

   /* replace264_0 -> 24 in the cache */
   /* replace264_1_0 -> 24 in the cache */
   /* replace264_1 -> 855 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fsub,
      -1, 0,
      { 24, 855 },
      -1,
   } },

   /* ('ffract@32', 'a') => ('fsub', 'a', ('ffloor', 'a')) */
   /* search265_0 -> 29 in the cache */
   /* search265 -> 859 in the cache */

   /* replace265_0 -> 29 in the cache */
   /* replace265_1_0 -> 29 in the cache */
   /* replace265_1 -> 858 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fsub,
      -1, 0,
      { 29, 858 },
      -1,
   } },

   /* ('ffract@64', 'a') => ('fsub', 'a', ('ffloor', 'a')) */
   /* search266_0 -> 34 in the cache */
   /* search266 -> 862 in the cache */

   /* replace266_0 -> 34 in the cache */
   /* replace266_1_0 -> 34 in the cache */
   /* replace266_1 -> 861 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fsub,
      -1, 0,
      { 34, 861 },
      -1,
   } },

   /* ('fceil', 'a') => ('fneg', ('ffloor', ('fneg', 'a'))) */
   /* search267_0 -> 9 in the cache */
   /* search267 -> 837 in the cache */

   /* replace267_0_0_0 -> 9 in the cache */
   /* replace267_0_0 -> 118 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ffloor,
      -1, 0,
      { 118 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fneg,
      -1, 0,
      { 882 },
      -1,
   } },

   /* ('ffma@16', 'a', 'b', 'c') => ('fadd', ('fmul', 'a', 'b'), 'c') */
   /* search268_0 -> 24 in the cache */
   /* search268_1 -> 595 in the cache */
   /* search268_2 -> 601 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ffma,
      0, 1,
      { 24, 595, 601 },
      -1,
   } },

   /* replace268_0_0 -> 24 in the cache */
   /* replace268_0_1 -> 595 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fmul,
      1, 1,
      { 24, 595 },
      -1,
   } },
   /* replace268_1 -> 601 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fadd,
      0, 2,
      { 885, 601 },
      -1,
   } },

   /* ('ffma@32', 'a', 'b', 'c') => ('fadd', ('fmul', 'a', 'b'), 'c') */
   /* search269_0 -> 29 in the cache */
   /* search269_1 -> 48 in the cache */
   /* search269_2 -> 152 in the cache */
   /* search269 -> 266 in the cache */

   /* replace269_0_0 -> 29 in the cache */
   /* replace269_0_1 -> 48 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fmul,
      1, 1,
      { 29, 48 },
      -1,
   } },
   /* replace269_1 -> 152 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fadd,
      0, 2,
      { 887, 152 },
      -1,
   } },

   /* ('ffma@64', 'a', 'b', 'c') => ('fadd', ('fmul', 'a', 'b'), 'c') */
   /* search270_0 -> 34 in the cache */
   /* search270_1 -> 53 in the cache */
   /* search270_2 -> 740 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ffma,
      0, 1,
      { 34, 53, 740 },
      -1,
   } },

   /* replace270_0_0 -> 34 in the cache */
   /* replace270_0_1 -> 53 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fmul,
      1, 1,
      { 34, 53 },
      -1,
   } },
   /* replace270_1 -> 740 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fadd,
      0, 2,
      { 890, 740 },
      -1,
   } },

   /* ('ffmaz', 'a', 'b', 'c') => ('fadd', ('fmulz', 'a', 'b'), 'c') */
   /* search271_0 -> 29 in the cache */
   /* search271_1 -> 48 in the cache */
   /* search271_2 -> 152 in the cache */
   /* search271 -> 476 in the cache */

   /* replace271_0_0 -> 29 in the cache */
   /* replace271_0_1 -> 48 in the cache */
   /* replace271_0 -> 151 in the cache */
   /* replace271_1 -> 152 in the cache */
   /* replace271 -> 315 in the cache */

   /* ('~ffma@16', 'a', 'b', 'c') => ('fadd', ('fmul', 'a', 'b'), 'c') */
   /* search272_0 -> 24 in the cache */
   /* search272_1 -> 595 in the cache */
   /* search272_2 -> 601 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      true,
      false,
      false,
      false,
      false,
      false,
      nir_op_ffma,
      0, 1,
      { 24, 595, 601 },
      -1,
   } },

   /* replace272_0_0 -> 24 in the cache */
   /* replace272_0_1 -> 595 in the cache */
   /* replace272_0 -> 885 in the cache */
   /* replace272_1 -> 601 in the cache */
   /* replace272 -> 886 in the cache */

   /* ('~ffma@32', 'a', 'b', 'c') => ('fadd', ('fmul', 'a', 'b'), 'c') */
   /* search273_0 -> 29 in the cache */
   /* search273_1 -> 48 in the cache */
   /* search273_2 -> 152 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      true,
      false,
      false,
      false,
      false,
      false,
      nir_op_ffma,
      0, 1,
      { 29, 48, 152 },
      -1,
   } },

   /* replace273_0_0 -> 29 in the cache */
   /* replace273_0_1 -> 48 in the cache */
   /* replace273_0 -> 887 in the cache */
   /* replace273_1 -> 152 in the cache */
   /* replace273 -> 888 in the cache */

   /* ('~ffma@64', 'a', 'b', 'c') => ('fadd', ('fmul', 'a', 'b'), 'c') */
   /* search274_0 -> 34 in the cache */
   /* search274_1 -> 53 in the cache */
   /* search274_2 -> 740 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      true,
      false,
      false,
      false,
      false,
      false,
      nir_op_ffma,
      0, 1,
      { 34, 53, 740 },
      -1,
   } },

   /* replace274_0_0 -> 34 in the cache */
   /* replace274_0_1 -> 53 in the cache */
   /* replace274_0 -> 890 in the cache */
   /* replace274_1 -> 740 in the cache */
   /* replace274 -> 891 in the cache */

   /* ('~ffmaz', 'a', 'b', 'c') => ('fadd', ('fmulz', 'a', 'b'), 'c') */
   /* search275_0 -> 29 in the cache */
   /* search275_1 -> 48 in the cache */
   /* search275_2 -> 152 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      true,
      false,
      false,
      false,
      false,
      false,
      nir_op_ffmaz,
      0, 1,
      { 29, 48, 152 },
      -1,
   } },

   /* replace275_0_0 -> 29 in the cache */
   /* replace275_0_1 -> 48 in the cache */
   /* replace275_0 -> 151 in the cache */
   /* replace275_1 -> 152 in the cache */
   /* replace275 -> 315 in the cache */

   /* ('~fmul', ('fadd', ('iand', ('ineg', ('b2i', 'a@bool')), ('fmul', 'b', 'c')), '#d'), '#e') => ('bcsel', 'a', ('fmul', ('fadd', ('fmul', 'b', 'c'), 'd'), 'e'), ('fmul', 'd', 'e')) */
   { .variable = {
      { nir_search_value_variable, 1 },
      0, /* a */
      false,
      nir_type_bool,
      -1,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .expression = {
      { nir_search_value_expression, -5 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_search_op_b2i,
      -1, 0,
      { 896 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -5 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ineg,
      -1, 0,
      { 897 },
      -1,
   } },
   { .variable = {
      { nir_search_value_variable, -5 },
      1, /* b */
      false,
      nir_type_invalid,
      -1,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .variable = {
      { nir_search_value_variable, -5 },
      2, /* c */
      false,
      nir_type_invalid,
      -1,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .expression = {
      { nir_search_value_expression, -5 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fmul,
      3, 1,
      { 899, 900 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -5 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_iand,
      2, 2,
      { 898, 901 },
      -1,
   } },
   { .variable = {
      { nir_search_value_variable, -5 },
      3, /* d */
      true,
      nir_type_invalid,
      -1,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .expression = {
      { nir_search_value_expression, -5 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fadd,
      1, 3,
      { 902, 903 },
      -1,
   } },
   { .variable = {
      { nir_search_value_variable, -5 },
      4, /* e */
      true,
      nir_type_invalid,
      -1,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .expression = {
      { nir_search_value_expression, -5 },
      true,
      false,
      false,
      false,
      false,
      false,
      nir_op_fmul,
      0, 4,
      { 904, 905 },
      -1,
   } },

   { .variable = {
      { nir_search_value_variable, 1 },
      0, /* a */
      false,
      nir_type_invalid,
      -1,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   /* replace276_1_0_0_0 -> 899 in the cache */
   /* replace276_1_0_0_1 -> 900 in the cache */
   { .expression = {
      { nir_search_value_expression, -5 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fmul,
      2, 1,
      { 899, 900 },
      -1,
   } },
   { .variable = {
      { nir_search_value_variable, -5 },
      3, /* d */
      false,
      nir_type_invalid,
      -1,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .expression = {
      { nir_search_value_expression, -5 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fadd,
      1, 2,
      { 908, 909 },
      -1,
   } },
   { .variable = {
      { nir_search_value_variable, -5 },
      4, /* e */
      false,
      nir_type_invalid,
      -1,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .expression = {
      { nir_search_value_expression, -5 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fmul,
      0, 3,
      { 910, 911 },
      -1,
   } },
   /* replace276_2_0 -> 909 in the cache */
   /* replace276_2_1 -> 911 in the cache */
   { .expression = {
      { nir_search_value_expression, -5 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fmul,
      3, 1,
      { 909, 911 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -5 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_bcsel,
      -1, 4,
      { 907, 912, 913 },
      -1,
   } },

   /* ('fdph', 'a', 'b') => ('fdot4', ('vec4', 'a.x', 'a.y', 'a.z', 1.0), 'b') */
   /* search277_0 -> 0 in the cache */
   /* search277_1 -> 1 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fdph,
      -1, 0,
      { 0, 1 },
      -1,
   } },

   { .variable = {
      { nir_search_value_variable, -2 },
      0, /* a */
      false,
      nir_type_invalid,
      -1,
      {0},
   } },
   { .variable = {
      { nir_search_value_variable, -2 },
      0, /* a */
      false,
      nir_type_invalid,
      -1,
      {1},
   } },
   { .variable = {
      { nir_search_value_variable, -2 },
      0, /* a */
      false,
      nir_type_invalid,
      -1,
      {2},
   } },
   /* replace277_0_3 -> 297 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_vec4,
      -1, 0,
      { 916, 917, 918, 297 },
      -1,
   } },
   /* replace277_1 -> 1 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fdot4,
      0, 1,
      { 919, 1 },
      -1,
   } },

   /* ('fdot4', 'a', 0.0) => 0.0 */
   /* search278_0 -> 9 in the cache */
   /* search278_1 -> 8 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fdot4,
      0, 1,
      { 9, 8 },
      -1,
   } },

   /* replace278 -> 8 in the cache */

   /* ('fdot3', 'a', 0.0) => 0.0 */
   /* search279_0 -> 9 in the cache */
   /* search279_1 -> 8 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fdot3,
      0, 1,
      { 9, 8 },
      -1,
   } },

   /* replace279 -> 8 in the cache */

   /* ('fdot2', 'a', 0.0) => 0.0 */
   /* search280_0 -> 9 in the cache */
   /* search280_1 -> 8 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fdot2,
      0, 1,
      { 9, 8 },
      -1,
   } },

   /* replace280 -> 8 in the cache */

   /* ('fdot4', ('vec4', 'a', 'b', 'c', 1.0), 'd') => ('fdph', ('vec3', 'a', 'b', 'c'), 'd') */
   /* search281_0_0 -> 166 in the cache */
   /* search281_0_1 -> 167 in the cache */
   /* search281_0_2 -> 169 in the cache */
   { .constant = {
      { nir_search_value_constant, -4 },
      nir_type_float, { 0x3ff0000000000000ull /* 1.0 */ },
   } },
   { .expression = {
      { nir_search_value_expression, -4 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_vec4,
      -1, 0,
      { 166, 167, 169, 924 },
      -1,
   } },
   /* search281_1 -> 170 in the cache */
   { .expression = {
      { nir_search_value_expression, -4 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fdot4,
      0, 1,
      { 925, 170 },
      -1,
   } },

   /* replace281_0_0 -> 166 in the cache */
   /* replace281_0_1 -> 167 in the cache */
   /* replace281_0_2 -> 169 in the cache */
   { .expression = {
      { nir_search_value_expression, -4 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_vec3,
      -1, 0,
      { 166, 167, 169 },
      -1,
   } },
   /* replace281_1 -> 170 in the cache */
   { .expression = {
      { nir_search_value_expression, -4 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fdph,
      -1, 0,
      { 927, 170 },
      -1,
   } },

   /* ('fdot4', ('vec4', 'a', 0.0, 0.0, 0.0), 'b') => ('fmul', 'a', 'b') */
   /* search282_0_0 -> 0 in the cache */
   /* search282_0_1 -> 287 in the cache */
   /* search282_0_2 -> 287 in the cache */
   /* search282_0_3 -> 287 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_vec4,
      -1, 0,
      { 0, 287, 287, 287 },
      -1,
   } },
   /* search282_1 -> 1 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fdot4,
      0, 1,
      { 929, 1 },
      -1,
   } },

   /* replace282_0 -> 0 in the cache */
   /* replace282_1 -> 1 in the cache */
   /* replace282 -> 293 in the cache */

   /* ('fdot4', ('vec4', 'a', 'b', 0.0, 0.0), 'c') => ('fdot2', ('vec2', 'a', 'b'), 'c') */
   /* search283_0_0 -> 143 in the cache */
   /* search283_0_1 -> 144 in the cache */
   { .constant = {
      { nir_search_value_constant, -3 },
      nir_type_float, { 0x0ull /* 0.0 */ },
   } },
   /* search283_0_3 -> 931 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_vec4,
      -1, 0,
      { 143, 144, 931, 931 },
      -1,
   } },
   /* search283_1 -> 146 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fdot4,
      0, 1,
      { 932, 146 },
      -1,
   } },

   /* replace283_0_0 -> 143 in the cache */
   /* replace283_0_1 -> 144 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_vec2,
      -1, 0,
      { 143, 144 },
      -1,
   } },
   /* replace283_1 -> 146 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fdot2,
      0, 1,
      { 934, 146 },
      -1,
   } },

   /* ('fdot4', ('vec4', 'a', 'b', 'c', 0.0), 'd') => ('fdot3', ('vec3', 'a', 'b', 'c'), 'd') */
   /* search284_0_0 -> 166 in the cache */
   /* search284_0_1 -> 167 in the cache */
   /* search284_0_2 -> 169 in the cache */
   { .constant = {
      { nir_search_value_constant, -4 },
      nir_type_float, { 0x0ull /* 0.0 */ },
   } },
   { .expression = {
      { nir_search_value_expression, -4 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_vec4,
      -1, 0,
      { 166, 167, 169, 936 },
      -1,
   } },
   /* search284_1 -> 170 in the cache */
   { .expression = {
      { nir_search_value_expression, -4 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fdot4,
      0, 1,
      { 937, 170 },
      -1,
   } },

   /* replace284_0_0 -> 166 in the cache */
   /* replace284_0_1 -> 167 in the cache */
   /* replace284_0_2 -> 169 in the cache */
   /* replace284_0 -> 927 in the cache */
   /* replace284_1 -> 170 in the cache */
   { .expression = {
      { nir_search_value_expression, -4 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fdot3,
      0, 1,
      { 927, 170 },
      -1,
   } },

   /* ('fdot3', ('vec3', 'a', 0.0, 0.0), 'b') => ('fmul', 'a', 'b') */
   /* search285_0_0 -> 0 in the cache */
   /* search285_0_1 -> 287 in the cache */
   /* search285_0_2 -> 287 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_vec3,
      -1, 0,
      { 0, 287, 287 },
      -1,
   } },
   /* search285_1 -> 1 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fdot3,
      0, 1,
      { 940, 1 },
      -1,
   } },

   /* replace285_0 -> 0 in the cache */
   /* replace285_1 -> 1 in the cache */
   /* replace285 -> 293 in the cache */

   /* ('fdot3', ('vec3', 'a', 'b', 0.0), 'c') => ('fdot2', ('vec2', 'a', 'b'), 'c') */
   /* search286_0_0 -> 143 in the cache */
   /* search286_0_1 -> 144 in the cache */
   /* search286_0_2 -> 931 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_vec3,
      -1, 0,
      { 143, 144, 931 },
      -1,
   } },
   /* search286_1 -> 146 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fdot3,
      0, 1,
      { 942, 146 },
      -1,
   } },

   /* replace286_0_0 -> 143 in the cache */
   /* replace286_0_1 -> 144 in the cache */
   /* replace286_0 -> 934 in the cache */
   /* replace286_1 -> 146 in the cache */
   /* replace286 -> 935 in the cache */

   /* ('fdot2', ('vec2', 'a', 0.0), 'b') => ('fmul', 'a', 'b') */
   /* search287_0_0 -> 0 in the cache */
   /* search287_0_1 -> 287 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_vec2,
      -1, 0,
      { 0, 287 },
      -1,
   } },
   /* search287_1 -> 1 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fdot2,
      0, 1,
      { 944, 1 },
      -1,
   } },

   /* replace287_0 -> 0 in the cache */
   /* replace287_1 -> 1 in the cache */
   /* replace287 -> 293 in the cache */

   /* ('fdot2', 'a', 1.0) => ('fadd', 'a.x', 'a.y') */
   /* search288_0 -> 9 in the cache */
   /* search288_1 -> 273 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fdot2,
      0, 1,
      { 9, 273 },
      -1,
   } },

   { .variable = {
      { nir_search_value_variable, -1 },
      0, /* a */
      false,
      nir_type_invalid,
      -1,
      {0},
   } },
   { .variable = {
      { nir_search_value_variable, -1 },
      0, /* a */
      false,
      nir_type_invalid,
      -1,
      {1},
   } },
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fadd,
      -1, 0,
      { 947, 948 },
      -1,
   } },

   /* ('fdot2', 'a', 'b') => ('fsum2', ('fmul', 'a', 'b')) */
   /* search289_0 -> 0 in the cache */
   /* search289_1 -> 1 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fdot2,
      0, 1,
      { 0, 1 },
      -1,
   } },

   /* replace289_0_0 -> 0 in the cache */
   /* replace289_0_1 -> 1 in the cache */
   /* replace289_0 -> 293 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fsum2,
      -1, 1,
      { 293 },
      -1,
   } },

   /* ('fdot3', 'a', 'b') => ('fsum3', ('fmul', 'a', 'b')) */
   /* search290_0 -> 0 in the cache */
   /* search290_1 -> 1 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fdot3,
      0, 1,
      { 0, 1 },
      -1,
   } },

   /* replace290_0_0 -> 0 in the cache */
   /* replace290_0_1 -> 1 in the cache */
   /* replace290_0 -> 293 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fsum3,
      -1, 1,
      { 293 },
      -1,
   } },

   /* ('fdot4', 'a', 'b') => ('fsum4', ('fmul', 'a', 'b')) */
   /* search291_0 -> 0 in the cache */
   /* search291_1 -> 1 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fdot4,
      0, 1,
      { 0, 1 },
      -1,
   } },

   /* replace291_0_0 -> 0 in the cache */
   /* replace291_0_1 -> 1 in the cache */
   /* replace291_0 -> 293 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fsum4,
      -1, 1,
      { 293 },
      -1,
   } },

   /* ('fsum2', 'a') => ('fadd', 'a.x', 'a.y') */
   /* search292_0 -> 9 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fsum2,
      -1, 0,
      { 9 },
      -1,
   } },

   /* replace292_0 -> 947 in the cache */
   /* replace292_1 -> 948 in the cache */
   /* replace292 -> 949 in the cache */

   /* ('~fadd', ('fneg(is_used_once)', ('fsat(is_used_once)', 'a(is_not_fmul)')), 1.0) => ('fsat', ('fadd', 1.0, ('fneg', 'a'))) */
   { .variable = {
      { nir_search_value_variable, -1 },
      0, /* a */
      false,
      nir_type_invalid,
      9,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fsat,
      -1, 0,
      { 957 },
      0,
   } },
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fneg,
      -1, 0,
      { 958 },
      0,
   } },
   /* search293_1 -> 273 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      true,
      false,
      false,
      false,
      false,
      false,
      nir_op_fadd,
      0, 1,
      { 959, 273 },
      -1,
   } },

   /* replace293_0_0 -> 273 in the cache */
   /* replace293_0_1_0 -> 9 in the cache */
   /* replace293_0_1 -> 118 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fadd,
      0, 1,
      { 273, 118 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fsat,
      -1, 1,
      { 961 },
      -1,
   } },

   /* ('ishl', ('iadd', ('imul', 'a', '#b'), '#c'), '#d') => ('iadd', ('imul', 'a', ('ishl', 'b', 'd')), ('ishl', 'c', 'd')) */
   /* search294_0_0_0 -> 143 in the cache */
   /* search294_0_0_1 -> 310 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_imul,
      1, 1,
      { 143, 310 },
      -1,
   } },
   { .variable = {
      { nir_search_value_variable, -3 },
      2, /* c */
      true,
      nir_type_invalid,
      -1,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_iadd,
      0, 2,
      { 963, 964 },
      -1,
   } },
   /* search294_1 -> 338 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ishl,
      -1, 2,
      { 965, 338 },
      -1,
   } },

   /* replace294_0_0 -> 143 in the cache */
   /* replace294_0_1_0 -> 144 in the cache */
   /* replace294_0_1_1 -> 180 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ishl,
      -1, 0,
      { 144, 180 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_imul,
      1, 1,
      { 143, 967 },
      -1,
   } },
   /* replace294_1_0 -> 146 in the cache */
   /* replace294_1_1 -> 180 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ishl,
      -1, 0,
      { 146, 180 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_iadd,
      0, 2,
      { 968, 969 },
      -1,
   } },

   /* ('ishl', ('imul', 'a', '#b'), '#c') => ('imul', 'a', ('ishl', 'b', 'c')) */
   /* search295_0_0 -> 0 in the cache */
   { .variable = {
      { nir_search_value_variable, -2 },
      1, /* b */
      true,
      nir_type_invalid,
      -1,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_imul,
      0, 1,
      { 0, 971 },
      -1,
   } },
   /* search295_1 -> 336 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ishl,
      -1, 1,
      { 972, 336 },
      -1,
   } },

   /* replace295_0 -> 0 in the cache */
   /* replace295_1_0 -> 1 in the cache */
   /* replace295_1_1 -> 152 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ishl,
      -1, 0,
      { 1, 152 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_imul,
      0, 1,
      { 0, 974 },
      -1,
   } },

   /* ('ishl@8', ('ishl@8', 'a', '#b'), '#c') => ('bcsel', ('ult', ('iadd', ('iand', 'b', 7), ('iand', 'c', 7)), 8), ('ishl@8', 'a', ('iadd', 'b', 'c')), 0) */
   /* search296_0_0 -> 19 in the cache */
   /* search296_0_1 -> 45 in the cache */
   { .expression = {
      { nir_search_value_expression, 8 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ishl,
      -1, 0,
      { 19, 45 },
      -1,
   } },
   /* search296_1 -> 336 in the cache */
   { .expression = {
      { nir_search_value_expression, 8 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ishl,
      -1, 0,
      { 976, 336 },
      -1,
   } },

   /* replace296_0_0_0_0 -> 48 in the cache */
   /* replace296_0_0_0_1 -> 22 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_iand,
      1, 1,
      { 48, 22 },
      -1,
   } },
   /* replace296_0_0_1_0 -> 152 in the cache */
   /* replace296_0_0_1_1 -> 22 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_iand,
      2, 1,
      { 152, 22 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_iadd,
      0, 3,
      { 978, 979 },
      -1,
   } },
   { .constant = {
      { nir_search_value_constant, 32 },
      nir_type_int, { 0x8ull /* 8 */ },
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ult,
      -1, 3,
      { 980, 981 },
      -1,
   } },
   /* replace296_1_0 -> 19 in the cache */
   /* replace296_1_1_0 -> 48 in the cache */
   /* replace296_1_1_1 -> 152 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_iadd,
      3, 1,
      { 48, 152 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 8 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ishl,
      -1, 1,
      { 19, 983 },
      -1,
   } },
   { .constant = {
      { nir_search_value_constant, 8 },
      nir_type_int, { 0x0ull /* 0 */ },
   } },
   { .expression = {
      { nir_search_value_expression, 8 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_bcsel,
      -1, 4,
      { 982, 984, 985 },
      -1,
   } },

   /* ('ushr@8', ('ushr@8', 'a', '#b'), '#c') => ('bcsel', ('ult', ('iadd', ('iand', 'b', 7), ('iand', 'c', 7)), 8), ('ushr@8', 'a', ('iadd', 'b', 'c')), 0) */
   /* search297_0_0 -> 19 in the cache */
   /* search297_0_1 -> 45 in the cache */
   { .expression = {
      { nir_search_value_expression, 8 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ushr,
      -1, 0,
      { 19, 45 },
      -1,
   } },
   /* search297_1 -> 336 in the cache */
   { .expression = {
      { nir_search_value_expression, 8 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ushr,
      -1, 0,
      { 987, 336 },
      -1,
   } },

   /* replace297_0_0_0_0 -> 48 in the cache */
   /* replace297_0_0_0_1 -> 22 in the cache */
   /* replace297_0_0_0 -> 978 in the cache */
   /* replace297_0_0_1_0 -> 152 in the cache */
   /* replace297_0_0_1_1 -> 22 in the cache */
   /* replace297_0_0_1 -> 979 in the cache */
   /* replace297_0_0 -> 980 in the cache */
   /* replace297_0_1 -> 981 in the cache */
   /* replace297_0 -> 982 in the cache */
   /* replace297_1_0 -> 19 in the cache */
   /* replace297_1_1_0 -> 48 in the cache */
   /* replace297_1_1_1 -> 152 in the cache */
   /* replace297_1_1 -> 983 in the cache */
   { .expression = {
      { nir_search_value_expression, 8 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ushr,
      -1, 1,
      { 19, 983 },
      -1,
   } },
   /* replace297_2 -> 985 in the cache */
   { .expression = {
      { nir_search_value_expression, 8 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_bcsel,
      -1, 4,
      { 982, 989, 985 },
      -1,
   } },

   /* ('ishr@8', ('ishr@8', 'a', '#b'), '#c') => ('ishr@8', 'a', ('imin', ('iadd', ('iand', 'b', 7), ('iand', 'c', 7)), 7)) */
   /* search298_0_0 -> 19 in the cache */
   /* search298_0_1 -> 45 in the cache */
   { .expression = {
      { nir_search_value_expression, 8 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ishr,
      -1, 0,
      { 19, 45 },
      -1,
   } },
   /* search298_1 -> 336 in the cache */
   { .expression = {
      { nir_search_value_expression, 8 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ishr,
      -1, 0,
      { 991, 336 },
      -1,
   } },

   /* replace298_0 -> 19 in the cache */
   /* replace298_1_0_0_0 -> 48 in the cache */
   /* replace298_1_0_0_1 -> 22 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_iand,
      2, 1,
      { 48, 22 },
      -1,
   } },
   /* replace298_1_0_1_0 -> 152 in the cache */
   /* replace298_1_0_1_1 -> 22 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_iand,
      3, 1,
      { 152, 22 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_iadd,
      1, 3,
      { 993, 994 },
      -1,
   } },
   /* replace298_1_1 -> 22 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_imin,
      0, 4,
      { 995, 22 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 8 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ishr,
      -1, 4,
      { 19, 996 },
      -1,
   } },

   /* ('ishl@16', ('ishl@16', 'a', '#b'), '#c') => ('bcsel', ('ult', ('iadd', ('iand', 'b', 15), ('iand', 'c', 15)), 16), ('ishl@16', 'a', ('iadd', 'b', 'c')), 0) */
   /* search299_0_0 -> 24 in the cache */
   /* search299_0_1 -> 45 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ishl,
      -1, 0,
      { 24, 45 },
      -1,
   } },
   /* search299_1 -> 336 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ishl,
      -1, 0,
      { 998, 336 },
      -1,
   } },

   /* replace299_0_0_0_0 -> 48 in the cache */
   /* replace299_0_0_0_1 -> 27 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_iand,
      1, 1,
      { 48, 27 },
      -1,
   } },
   /* replace299_0_0_1_0 -> 152 in the cache */
   /* replace299_0_0_1_1 -> 27 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_iand,
      2, 1,
      { 152, 27 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_iadd,
      0, 3,
      { 1000, 1001 },
      -1,
   } },
   { .constant = {
      { nir_search_value_constant, 32 },
      nir_type_int, { 0x10ull /* 16 */ },
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ult,
      -1, 3,
      { 1002, 1003 },
      -1,
   } },
   /* replace299_1_0 -> 24 in the cache */
   /* replace299_1_1_0 -> 48 in the cache */
   /* replace299_1_1_1 -> 152 in the cache */
   /* replace299_1_1 -> 983 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ishl,
      -1, 1,
      { 24, 983 },
      -1,
   } },
   { .constant = {
      { nir_search_value_constant, 16 },
      nir_type_int, { 0x0ull /* 0 */ },
   } },
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_bcsel,
      -1, 4,
      { 1004, 1005, 1006 },
      -1,
   } },

   /* ('ushr@16', ('ushr@16', 'a', '#b'), '#c') => ('bcsel', ('ult', ('iadd', ('iand', 'b', 15), ('iand', 'c', 15)), 16), ('ushr@16', 'a', ('iadd', 'b', 'c')), 0) */
   /* search300_0_0 -> 24 in the cache */
   /* search300_0_1 -> 45 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ushr,
      -1, 0,
      { 24, 45 },
      -1,
   } },
   /* search300_1 -> 336 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ushr,
      -1, 0,
      { 1008, 336 },
      -1,
   } },

   /* replace300_0_0_0_0 -> 48 in the cache */
   /* replace300_0_0_0_1 -> 27 in the cache */
   /* replace300_0_0_0 -> 1000 in the cache */
   /* replace300_0_0_1_0 -> 152 in the cache */
   /* replace300_0_0_1_1 -> 27 in the cache */
   /* replace300_0_0_1 -> 1001 in the cache */
   /* replace300_0_0 -> 1002 in the cache */
   /* replace300_0_1 -> 1003 in the cache */
   /* replace300_0 -> 1004 in the cache */
   /* replace300_1_0 -> 24 in the cache */
   /* replace300_1_1_0 -> 48 in the cache */
   /* replace300_1_1_1 -> 152 in the cache */
   /* replace300_1_1 -> 983 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ushr,
      -1, 1,
      { 24, 983 },
      -1,
   } },
   /* replace300_2 -> 1006 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_bcsel,
      -1, 4,
      { 1004, 1010, 1006 },
      -1,
   } },

   /* ('ishr@16', ('ishr@16', 'a', '#b'), '#c') => ('ishr@16', 'a', ('imin', ('iadd', ('iand', 'b', 15), ('iand', 'c', 15)), 15)) */
   /* search301_0_0 -> 24 in the cache */
   /* search301_0_1 -> 45 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ishr,
      -1, 0,
      { 24, 45 },
      -1,
   } },
   /* search301_1 -> 336 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ishr,
      -1, 0,
      { 1012, 336 },
      -1,
   } },

   /* replace301_0 -> 24 in the cache */
   /* replace301_1_0_0_0 -> 48 in the cache */
   /* replace301_1_0_0_1 -> 27 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_iand,
      2, 1,
      { 48, 27 },
      -1,
   } },
   /* replace301_1_0_1_0 -> 152 in the cache */
   /* replace301_1_0_1_1 -> 27 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_iand,
      3, 1,
      { 152, 27 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_iadd,
      1, 3,
      { 1014, 1015 },
      -1,
   } },
   /* replace301_1_1 -> 27 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_imin,
      0, 4,
      { 1016, 27 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ishr,
      -1, 4,
      { 24, 1017 },
      -1,
   } },

   /* ('ishl@32', ('ishl@32', 'a', '#b'), '#c') => ('bcsel', ('ult', ('iadd', ('iand', 'b', 31), ('iand', 'c', 31)), 32), ('ishl@32', 'a', ('iadd', 'b', 'c')), 0) */
   /* search302_0_0 -> 29 in the cache */
   /* search302_0_1 -> 45 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ishl,
      -1, 0,
      { 29, 45 },
      -1,
   } },
   /* search302_1 -> 336 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ishl,
      -1, 0,
      { 1019, 336 },
      -1,
   } },

   /* replace302_0_0_0_0 -> 48 in the cache */
   /* replace302_0_0_0_1 -> 32 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_iand,
      1, 1,
      { 48, 32 },
      -1,
   } },
   /* replace302_0_0_1_0 -> 152 in the cache */
   /* replace302_0_0_1_1 -> 32 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_iand,
      2, 1,
      { 152, 32 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_iadd,
      0, 3,
      { 1021, 1022 },
      -1,
   } },
   { .constant = {
      { nir_search_value_constant, 32 },
      nir_type_int, { 0x20ull /* 32 */ },
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ult,
      -1, 3,
      { 1023, 1024 },
      -1,
   } },
   /* replace302_1_0 -> 29 in the cache */
   /* replace302_1_1_0 -> 48 in the cache */
   /* replace302_1_1_1 -> 152 in the cache */
   /* replace302_1_1 -> 983 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ishl,
      -1, 1,
      { 29, 983 },
      -1,
   } },
   /* replace302_2 -> 139 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_bcsel,
      -1, 4,
      { 1025, 1026, 139 },
      -1,
   } },

   /* ('ushr@32', ('ushr@32', 'a', '#b'), '#c') => ('bcsel', ('ult', ('iadd', ('iand', 'b', 31), ('iand', 'c', 31)), 32), ('ushr@32', 'a', ('iadd', 'b', 'c')), 0) */
   /* search303_0_0 -> 29 in the cache */
   /* search303_0_1 -> 45 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ushr,
      -1, 0,
      { 29, 45 },
      -1,
   } },
   /* search303_1 -> 336 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ushr,
      -1, 0,
      { 1028, 336 },
      -1,
   } },

   /* replace303_0_0_0_0 -> 48 in the cache */
   /* replace303_0_0_0_1 -> 32 in the cache */
   /* replace303_0_0_0 -> 1021 in the cache */
   /* replace303_0_0_1_0 -> 152 in the cache */
   /* replace303_0_0_1_1 -> 32 in the cache */
   /* replace303_0_0_1 -> 1022 in the cache */
   /* replace303_0_0 -> 1023 in the cache */
   /* replace303_0_1 -> 1024 in the cache */
   /* replace303_0 -> 1025 in the cache */
   /* replace303_1_0 -> 29 in the cache */
   /* replace303_1_1_0 -> 48 in the cache */
   /* replace303_1_1_1 -> 152 in the cache */
   /* replace303_1_1 -> 983 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ushr,
      -1, 1,
      { 29, 983 },
      -1,
   } },
   /* replace303_2 -> 139 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_bcsel,
      -1, 4,
      { 1025, 1030, 139 },
      -1,
   } },

   /* ('ishr@32', ('ishr@32', 'a', '#b'), '#c') => ('ishr@32', 'a', ('imin', ('iadd', ('iand', 'b', 31), ('iand', 'c', 31)), 31)) */
   /* search304_0_0 -> 29 in the cache */
   /* search304_0_1 -> 45 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ishr,
      -1, 0,
      { 29, 45 },
      -1,
   } },
   /* search304_1 -> 336 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ishr,
      -1, 0,
      { 1032, 336 },
      -1,
   } },

   /* replace304_0 -> 29 in the cache */
   /* replace304_1_0_0_0 -> 48 in the cache */
   /* replace304_1_0_0_1 -> 32 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_iand,
      2, 1,
      { 48, 32 },
      -1,
   } },
   /* replace304_1_0_1_0 -> 152 in the cache */
   /* replace304_1_0_1_1 -> 32 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_iand,
      3, 1,
      { 152, 32 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_iadd,
      1, 3,
      { 1034, 1035 },
      -1,
   } },
   /* replace304_1_1 -> 32 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_imin,
      0, 4,
      { 1036, 32 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ishr,
      -1, 4,
      { 29, 1037 },
      -1,
   } },

   /* ('ishl@64', ('ishl@64', 'a', '#b'), '#c') => ('bcsel', ('ult', ('iadd', ('iand', 'b', 63), ('iand', 'c', 63)), 64), ('ishl@64', 'a', ('iadd', 'b', 'c')), 0) */
   /* search305_0_0 -> 34 in the cache */
   /* search305_0_1 -> 45 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ishl,
      -1, 0,
      { 34, 45 },
      -1,
   } },
   /* search305_1 -> 336 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ishl,
      -1, 0,
      { 1039, 336 },
      -1,
   } },

   /* replace305_0_0_0_0 -> 48 in the cache */
   /* replace305_0_0_0_1 -> 37 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_iand,
      1, 1,
      { 48, 37 },
      -1,
   } },
   /* replace305_0_0_1_0 -> 152 in the cache */
   /* replace305_0_0_1_1 -> 37 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_iand,
      2, 1,
      { 152, 37 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_iadd,
      0, 3,
      { 1041, 1042 },
      -1,
   } },
   { .constant = {
      { nir_search_value_constant, 32 },
      nir_type_int, { 0x40ull /* 64 */ },
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ult,
      -1, 3,
      { 1043, 1044 },
      -1,
   } },
   /* replace305_1_0 -> 34 in the cache */
   /* replace305_1_1_0 -> 48 in the cache */
   /* replace305_1_1_1 -> 152 in the cache */
   /* replace305_1_1 -> 983 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ishl,
      -1, 1,
      { 34, 983 },
      -1,
   } },
   { .constant = {
      { nir_search_value_constant, 64 },
      nir_type_int, { 0x0ull /* 0 */ },
   } },
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_bcsel,
      -1, 4,
      { 1045, 1046, 1047 },
      -1,
   } },

   /* ('ushr@64', ('ushr@64', 'a', '#b'), '#c') => ('bcsel', ('ult', ('iadd', ('iand', 'b', 63), ('iand', 'c', 63)), 64), ('ushr@64', 'a', ('iadd', 'b', 'c')), 0) */
   /* search306_0_0 -> 34 in the cache */
   /* search306_0_1 -> 45 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ushr,
      -1, 0,
      { 34, 45 },
      -1,
   } },
   /* search306_1 -> 336 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ushr,
      -1, 0,
      { 1049, 336 },
      -1,
   } },

   /* replace306_0_0_0_0 -> 48 in the cache */
   /* replace306_0_0_0_1 -> 37 in the cache */
   /* replace306_0_0_0 -> 1041 in the cache */
   /* replace306_0_0_1_0 -> 152 in the cache */
   /* replace306_0_0_1_1 -> 37 in the cache */
   /* replace306_0_0_1 -> 1042 in the cache */
   /* replace306_0_0 -> 1043 in the cache */
   /* replace306_0_1 -> 1044 in the cache */
   /* replace306_0 -> 1045 in the cache */
   /* replace306_1_0 -> 34 in the cache */
   /* replace306_1_1_0 -> 48 in the cache */
   /* replace306_1_1_1 -> 152 in the cache */
   /* replace306_1_1 -> 983 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ushr,
      -1, 1,
      { 34, 983 },
      -1,
   } },
   /* replace306_2 -> 1047 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_bcsel,
      -1, 4,
      { 1045, 1051, 1047 },
      -1,
   } },

   /* ('ishr@64', ('ishr@64', 'a', '#b'), '#c') => ('ishr@64', 'a', ('imin', ('iadd', ('iand', 'b', 63), ('iand', 'c', 63)), 63)) */
   /* search307_0_0 -> 34 in the cache */
   /* search307_0_1 -> 45 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ishr,
      -1, 0,
      { 34, 45 },
      -1,
   } },
   /* search307_1 -> 336 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ishr,
      -1, 0,
      { 1053, 336 },
      -1,
   } },

   /* replace307_0 -> 34 in the cache */
   /* replace307_1_0_0_0 -> 48 in the cache */
   /* replace307_1_0_0_1 -> 37 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_iand,
      2, 1,
      { 48, 37 },
      -1,
   } },
   /* replace307_1_0_1_0 -> 152 in the cache */
   /* replace307_1_0_1_1 -> 37 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_iand,
      3, 1,
      { 152, 37 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_iadd,
      1, 3,
      { 1055, 1056 },
      -1,
   } },
   /* replace307_1_1 -> 37 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_imin,
      0, 4,
      { 1057, 37 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ishr,
      -1, 4,
      { 34, 1058 },
      -1,
   } },

   /* ('ishl', ('ushr', 'a@8', '#b'), 'b') => ('iand', 'a', ('ishl', 255, 'b')) */
   /* search308_0_0 -> 19 in the cache */
   /* search308_0_1 -> 45 in the cache */
   /* search308_0 -> 987 in the cache */
   /* search308_1 -> 48 in the cache */
   { .expression = {
      { nir_search_value_expression, 8 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ishl,
      -1, 0,
      { 987, 48 },
      -1,
   } },

   /* replace308_0 -> 19 in the cache */
   { .constant = {
      { nir_search_value_constant, 8 },
      nir_type_int, { 0xffull /* 255 */ },
   } },
   /* replace308_1_1 -> 48 in the cache */
   { .expression = {
      { nir_search_value_expression, 8 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ishl,
      -1, 0,
      { 1061, 48 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 8 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_iand,
      0, 1,
      { 19, 1062 },
      -1,
   } },

   /* ('ishl', ('ishr', 'a@8', '#b'), 'b') => ('iand', 'a', ('ishl', 255, 'b')) */
   /* search309_0_0 -> 19 in the cache */
   /* search309_0_1 -> 45 in the cache */
   /* search309_0 -> 991 in the cache */
   /* search309_1 -> 48 in the cache */
   { .expression = {
      { nir_search_value_expression, 8 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ishl,
      -1, 0,
      { 991, 48 },
      -1,
   } },

   /* replace309_0 -> 19 in the cache */
   /* replace309_1_0 -> 1061 in the cache */
   /* replace309_1_1 -> 48 in the cache */
   /* replace309_1 -> 1062 in the cache */
   /* replace309 -> 1063 in the cache */

   /* ('ushr', ('ishl', 'a@8', '#b'), 'b') => ('iand', 'a', ('ushr', 255, 'b')) */
   /* search310_0_0 -> 19 in the cache */
   /* search310_0_1 -> 45 in the cache */
   /* search310_0 -> 976 in the cache */
   /* search310_1 -> 48 in the cache */
   { .expression = {
      { nir_search_value_expression, 8 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ushr,
      -1, 0,
      { 976, 48 },
      -1,
   } },

   /* replace310_0 -> 19 in the cache */
   /* replace310_1_0 -> 1061 in the cache */
   /* replace310_1_1 -> 48 in the cache */
   { .expression = {
      { nir_search_value_expression, 8 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ushr,
      -1, 0,
      { 1061, 48 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 8 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_iand,
      0, 1,
      { 19, 1066 },
      -1,
   } },

   /* ('ishl', ('ushr', 'a@16', '#b'), 'b') => ('iand', 'a', ('ishl', 65535, 'b')) */
   /* search311_0_0 -> 24 in the cache */
   /* search311_0_1 -> 45 in the cache */
   /* search311_0 -> 1008 in the cache */
   /* search311_1 -> 48 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ishl,
      -1, 0,
      { 1008, 48 },
      -1,
   } },

   /* replace311_0 -> 24 in the cache */
   { .constant = {
      { nir_search_value_constant, 16 },
      nir_type_int, { 0xffffull /* 65535 */ },
   } },
   /* replace311_1_1 -> 48 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ishl,
      -1, 0,
      { 1069, 48 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_iand,
      0, 1,
      { 24, 1070 },
      -1,
   } },

   /* ('ishl', ('ishr', 'a@16', '#b'), 'b') => ('iand', 'a', ('ishl', 65535, 'b')) */
   /* search312_0_0 -> 24 in the cache */
   /* search312_0_1 -> 45 in the cache */
   /* search312_0 -> 1012 in the cache */
   /* search312_1 -> 48 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ishl,
      -1, 0,
      { 1012, 48 },
      -1,
   } },

   /* replace312_0 -> 24 in the cache */
   /* replace312_1_0 -> 1069 in the cache */
   /* replace312_1_1 -> 48 in the cache */
   /* replace312_1 -> 1070 in the cache */
   /* replace312 -> 1071 in the cache */

   /* ('ushr', ('ishl', 'a@16', '#b'), 'b') => ('iand', 'a', ('ushr', 65535, 'b')) */
   /* search313_0_0 -> 24 in the cache */
   /* search313_0_1 -> 45 in the cache */
   /* search313_0 -> 998 in the cache */
   /* search313_1 -> 48 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ushr,
      -1, 0,
      { 998, 48 },
      -1,
   } },

   /* replace313_0 -> 24 in the cache */
   /* replace313_1_0 -> 1069 in the cache */
   /* replace313_1_1 -> 48 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ushr,
      -1, 0,
      { 1069, 48 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_iand,
      0, 1,
      { 24, 1074 },
      -1,
   } },

   /* ('ishl', ('ushr', 'a@32', '#b'), 'b') => ('iand', 'a', ('ishl', 4294967295, 'b')) */
   /* search314_0_0 -> 29 in the cache */
   /* search314_0_1 -> 45 in the cache */
   /* search314_0 -> 1028 in the cache */
   /* search314_1 -> 48 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ishl,
      -1, 0,
      { 1028, 48 },
      -1,
   } },

   /* replace314_0 -> 29 in the cache */
   { .constant = {
      { nir_search_value_constant, 32 },
      nir_type_int, { 0xffffffffull /* 4294967295 */ },
   } },
   /* replace314_1_1 -> 48 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ishl,
      -1, 0,
      { 1077, 48 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_iand,
      0, 1,
      { 29, 1078 },
      -1,
   } },

   /* ('ishl', ('ishr', 'a@32', '#b'), 'b') => ('iand', 'a', ('ishl', 4294967295, 'b')) */
   /* search315_0_0 -> 29 in the cache */
   /* search315_0_1 -> 45 in the cache */
   /* search315_0 -> 1032 in the cache */
   /* search315_1 -> 48 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ishl,
      -1, 0,
      { 1032, 48 },
      -1,
   } },

   /* replace315_0 -> 29 in the cache */
   /* replace315_1_0 -> 1077 in the cache */
   /* replace315_1_1 -> 48 in the cache */
   /* replace315_1 -> 1078 in the cache */
   /* replace315 -> 1079 in the cache */

   /* ('ushr', ('ishl', 'a@32', '#b'), 'b') => ('iand', 'a', ('ushr', 4294967295, 'b')) */
   /* search316_0_0 -> 29 in the cache */
   /* search316_0_1 -> 45 in the cache */
   /* search316_0 -> 1019 in the cache */
   /* search316_1 -> 48 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ushr,
      -1, 0,
      { 1019, 48 },
      -1,
   } },

   /* replace316_0 -> 29 in the cache */
   /* replace316_1_0 -> 1077 in the cache */
   /* replace316_1_1 -> 48 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ushr,
      -1, 0,
      { 1077, 48 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_iand,
      0, 1,
      { 29, 1082 },
      -1,
   } },

   /* ('ishl', ('ushr', 'a@64', '#b'), 'b') => ('iand', 'a', ('ishl', 18446744073709551615, 'b')) */
   /* search317_0_0 -> 34 in the cache */
   /* search317_0_1 -> 45 in the cache */
   /* search317_0 -> 1049 in the cache */
   /* search317_1 -> 48 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ishl,
      -1, 0,
      { 1049, 48 },
      -1,
   } },

   /* replace317_0 -> 34 in the cache */
   { .constant = {
      { nir_search_value_constant, 64 },
      nir_type_int, { 0xffffffffffffffffull /* 18446744073709551615 */ },
   } },
   /* replace317_1_1 -> 48 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ishl,
      -1, 0,
      { 1085, 48 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_iand,
      0, 1,
      { 34, 1086 },
      -1,
   } },

   /* ('ishl', ('ishr', 'a@64', '#b'), 'b') => ('iand', 'a', ('ishl', 18446744073709551615, 'b')) */
   /* search318_0_0 -> 34 in the cache */
   /* search318_0_1 -> 45 in the cache */
   /* search318_0 -> 1053 in the cache */
   /* search318_1 -> 48 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ishl,
      -1, 0,
      { 1053, 48 },
      -1,
   } },

   /* replace318_0 -> 34 in the cache */
   /* replace318_1_0 -> 1085 in the cache */
   /* replace318_1_1 -> 48 in the cache */
   /* replace318_1 -> 1086 in the cache */
   /* replace318 -> 1087 in the cache */

   /* ('ushr', ('ishl', 'a@64', '#b'), 'b') => ('iand', 'a', ('ushr', 18446744073709551615, 'b')) */
   /* search319_0_0 -> 34 in the cache */
   /* search319_0_1 -> 45 in the cache */
   /* search319_0 -> 1039 in the cache */
   /* search319_1 -> 48 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ushr,
      -1, 0,
      { 1039, 48 },
      -1,
   } },

   /* replace319_0 -> 34 in the cache */
   /* replace319_1_0 -> 1085 in the cache */
   /* replace319_1_1 -> 48 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ushr,
      -1, 0,
      { 1085, 48 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_iand,
      0, 1,
      { 34, 1090 },
      -1,
   } },

   /* ('iand@32', ('ushr@32(is_used_once)', 'a', 'b'), '#c(is_const_bitmask)') => ('ubfe', 'a', 'b', ('bit_count', 'c')) */
   /* search320_0_0 -> 29 in the cache */
   /* search320_0_1 -> 48 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ushr,
      -1, 0,
      { 29, 48 },
      0,
   } },
   { .variable = {
      { nir_search_value_variable, 32 },
      2, /* c */
      true,
      nir_type_invalid,
      10,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_iand,
      0, 1,
      { 1092, 1093 },
      -1,
   } },

   /* replace320_0 -> 29 in the cache */
   /* replace320_1 -> 48 in the cache */
   /* replace320_2_0 -> 152 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_bit_count,
      -1, 0,
      { 152 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ubfe,
      -1, 0,
      { 29, 48, 1095 },
      -1,
   } },

   /* ('iand@32', ('ushr@32', 'a', 'b'), ('bfm', 'c', 0)) => ('ubfe', 'a', 'b', 'c') */
   /* search321_0_0 -> 29 in the cache */
   /* search321_0_1 -> 48 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ushr,
      -1, 0,
      { 29, 48 },
      -1,
   } },
   /* search321_1_0 -> 152 in the cache */
   /* search321_1_1 -> 139 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_bfm,
      -1, 0,
      { 152, 139 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_iand,
      0, 1,
      { 1097, 1098 },
      -1,
   } },

   /* replace321_0 -> 29 in the cache */
   /* replace321_1 -> 48 in the cache */
   /* replace321_2 -> 152 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ubfe,
      -1, 0,
      { 29, 48, 152 },
      -1,
   } },

   /* ('ushr', ('iand', 'a', ('bfm', 'c', 'b')), 'b') => ('ubfe', 'a', 'b', 'c') */
   /* search322_0_0 -> 29 in the cache */
   /* search322_0_1_0 -> 686 in the cache */
   /* search322_0_1_1 -> 690 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_bfm,
      -1, 0,
      { 686, 690 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_iand,
      0, 1,
      { 29, 1101 },
      -1,
   } },
   /* search322_1 -> 690 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ushr,
      -1, 1,
      { 1102, 690 },
      -1,
   } },

   /* replace322_0 -> 29 in the cache */
   /* replace322_1 -> 690 in the cache */
   /* replace322_2 -> 686 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ubfe,
      -1, 0,
      { 29, 690, 686 },
      -1,
   } },

   /* ('ubfe', ('ubfe', 'a', '#b', '#c'), '#d', '#e') => ('bcsel', ('ilt', 31, ('iadd', ('iand', 'b', 31), ('iand', 'd', 31))), 0, ('ubfe', 'a', ('iadd', ('iand', 'b', 31), ('iand', 'd', 31)), ('umin', ('iand', 'e', 31), ('imax', ('isub', ('umin', ('iand', 'c', 31), ('isub', 32, ('iand', 'b', 31))), ('iand', 'd', 31)), 0)))) */
   /* search323_0_0 -> 29 in the cache */
   /* search323_0_1 -> 45 in the cache */
   /* search323_0_2 -> 336 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ubfe,
      -1, 0,
      { 29, 45, 336 },
      -1,
   } },
   /* search323_1 -> 338 in the cache */
   { .variable = {
      { nir_search_value_variable, 32 },
      4, /* e */
      true,
      nir_type_invalid,
      -1,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ubfe,
      -1, 0,
      { 1105, 338, 1106 },
      -1,
   } },

   /* replace323_0_0 -> 32 in the cache */
   /* replace323_0_1_0_0 -> 48 in the cache */
   /* replace323_0_1_0_1 -> 32 in the cache */
   /* replace323_0_1_0 -> 1021 in the cache */
   /* replace323_0_1_1_0 -> 180 in the cache */
   /* replace323_0_1_1_1 -> 32 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_iand,
      2, 1,
      { 180, 32 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_iadd,
      0, 3,
      { 1021, 1108 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ilt,
      -1, 3,
      { 32, 1109 },
      -1,
   } },
   /* replace323_1 -> 139 in the cache */
   /* replace323_2_0 -> 29 in the cache */
   /* replace323_2_1_0_0 -> 48 in the cache */
   /* replace323_2_1_0_1 -> 32 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_iand,
      4, 1,
      { 48, 32 },
      -1,
   } },
   /* replace323_2_1_1_0 -> 180 in the cache */
   /* replace323_2_1_1_1 -> 32 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_iand,
      5, 1,
      { 180, 32 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_iadd,
      3, 3,
      { 1111, 1112 },
      -1,
   } },
   { .variable = {
      { nir_search_value_variable, 32 },
      4, /* e */
      false,
      nir_type_invalid,
      -1,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   /* replace323_2_2_0_1 -> 32 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_iand,
      7, 1,
      { 1114, 32 },
      -1,
   } },
   /* replace323_2_2_1_0_0_0_0 -> 152 in the cache */
   /* replace323_2_2_1_0_0_0_1 -> 32 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_iand,
      10, 1,
      { 152, 32 },
      -1,
   } },
   /* replace323_2_2_1_0_0_1_0 -> 1024 in the cache */
   /* replace323_2_2_1_0_0_1_1_0 -> 48 in the cache */
   /* replace323_2_2_1_0_0_1_1_1 -> 32 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_iand,
      11, 1,
      { 48, 32 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_isub,
      -1, 1,
      { 1024, 1117 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_umin,
      9, 3,
      { 1116, 1118 },
      -1,
   } },
   /* replace323_2_2_1_0_1_0 -> 180 in the cache */
   /* replace323_2_2_1_0_1_1 -> 32 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_iand,
      12, 1,
      { 180, 32 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_isub,
      -1, 4,
      { 1119, 1120 },
      -1,
   } },
   /* replace323_2_2_1_1 -> 139 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_imax,
      8, 5,
      { 1121, 139 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_umin,
      6, 7,
      { 1115, 1122 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ubfe,
      -1, 10,
      { 29, 1113, 1123 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_bcsel,
      -1, 13,
      { 1110, 139, 1124 },
      -1,
   } },

   /* ('ushr@32', ('ubfe', 'a', '#b', '#c'), '#d(is_5lsb_not_zero)') => ('bcsel', ('ilt', 31, ('iadd', ('iand', 'b', 31), ('iand', 'd', 31))), 0, ('ubfe', 'a', ('iadd', ('iand', 'b', 31), ('iand', 'd', 31)), ('umin', ('iand', 31, 31), ('imax', ('isub', ('umin', ('iand', 'c', 31), ('isub', 32, ('iand', 'b', 31))), ('iand', 'd', 31)), 0)))) */
   /* search324_0_0 -> 29 in the cache */
   /* search324_0_1 -> 45 in the cache */
   /* search324_0_2 -> 336 in the cache */
   /* search324_0 -> 1105 in the cache */
   { .variable = {
      { nir_search_value_variable, 32 },
      3, /* d */
      true,
      nir_type_invalid,
      11,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ushr,
      -1, 0,
      { 1105, 1126 },
      -1,
   } },

   /* replace324_0_0 -> 32 in the cache */
   /* replace324_0_1_0_0 -> 48 in the cache */
   /* replace324_0_1_0_1 -> 32 in the cache */
   /* replace324_0_1_0 -> 1021 in the cache */
   /* replace324_0_1_1_0 -> 180 in the cache */
   /* replace324_0_1_1_1 -> 32 in the cache */
   /* replace324_0_1_1 -> 1108 in the cache */
   /* replace324_0_1 -> 1109 in the cache */
   /* replace324_0 -> 1110 in the cache */
   /* replace324_1 -> 139 in the cache */
   /* replace324_2_0 -> 29 in the cache */
   /* replace324_2_1_0_0 -> 48 in the cache */
   /* replace324_2_1_0_1 -> 32 in the cache */
   /* replace324_2_1_0 -> 1111 in the cache */
   /* replace324_2_1_1_0 -> 180 in the cache */
   /* replace324_2_1_1_1 -> 32 in the cache */
   /* replace324_2_1_1 -> 1112 in the cache */
   /* replace324_2_1 -> 1113 in the cache */
   /* replace324_2_2_0_0 -> 32 in the cache */
   /* replace324_2_2_0_1 -> 32 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_iand,
      -1, 0,
      { 32, 32 },
      -1,
   } },
   /* replace324_2_2_1_0_0_0_0 -> 152 in the cache */
   /* replace324_2_2_1_0_0_0_1 -> 32 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_iand,
      9, 1,
      { 152, 32 },
      -1,
   } },
   /* replace324_2_2_1_0_0_1_0 -> 1024 in the cache */
   /* replace324_2_2_1_0_0_1_1_0 -> 48 in the cache */
   /* replace324_2_2_1_0_0_1_1_1 -> 32 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_iand,
      10, 1,
      { 48, 32 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_isub,
      -1, 1,
      { 1024, 1130 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_umin,
      8, 3,
      { 1129, 1131 },
      -1,
   } },
   /* replace324_2_2_1_0_1_0 -> 180 in the cache */
   /* replace324_2_2_1_0_1_1 -> 32 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_iand,
      11, 1,
      { 180, 32 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_isub,
      -1, 4,
      { 1132, 1133 },
      -1,
   } },
   /* replace324_2_2_1_1 -> 139 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_imax,
      7, 5,
      { 1134, 139 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_umin,
      6, 6,
      { 1128, 1135 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ubfe,
      -1, 9,
      { 29, 1113, 1136 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_bcsel,
      -1, 12,
      { 1110, 139, 1137 },
      -1,
   } },

   /* ('iand', ('ishl', 'a@32', '#b(is_first_5_bits_uge_2)'), -4) => ('ishl', 'a', 'b') */
   /* search325_0_0 -> 29 in the cache */
   { .variable = {
      { nir_search_value_variable, 32 },
      1, /* b */
      true,
      nir_type_invalid,
      12,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ishl,
      -1, 0,
      { 29, 1139 },
      -1,
   } },
   { .constant = {
      { nir_search_value_constant, 32 },
      nir_type_int, { 0xfffffffffffffffcull /* -4 */ },
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_iand,
      0, 1,
      { 1140, 1141 },
      -1,
   } },

   /* replace325_0 -> 29 in the cache */
   /* replace325_1 -> 48 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ishl,
      -1, 0,
      { 29, 48 },
      -1,
   } },

   /* ('iand', ('imul', 'a', '#b(is_unsigned_multiple_of_4)'), -4) => ('imul', 'a', 'b') */
   /* search326_0_0 -> 0 in the cache */
   { .variable = {
      { nir_search_value_variable, -2 },
      1, /* b */
      true,
      nir_type_invalid,
      13,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_imul,
      1, 1,
      { 0, 1144 },
      -1,
   } },
   { .constant = {
      { nir_search_value_constant, -2 },
      nir_type_int, { 0xfffffffffffffffcull /* -4 */ },
   } },
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_iand,
      0, 2,
      { 1145, 1146 },
      -1,
   } },

   /* replace326_0 -> 0 in the cache */
   /* replace326_1 -> 1 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_imul,
      0, 1,
      { 0, 1 },
      -1,
   } },

   /* ('iand@32', ('iadd@32', 'a', '#b(is_unsigned_multiple_of_2)'), 4294967294) => ('iadd', ('iand', 'a', 4294967294), 'b') */
   /* search327_0_0 -> 29 in the cache */
   { .variable = {
      { nir_search_value_variable, 32 },
      1, /* b */
      true,
      nir_type_invalid,
      14,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_iadd,
      1, 1,
      { 29, 1149 },
      -1,
   } },
   { .constant = {
      { nir_search_value_constant, 32 },
      nir_type_int, { 0xfffffffeull /* 4294967294 */ },
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_iand,
      0, 2,
      { 1150, 1151 },
      -1,
   } },

   /* replace327_0_0 -> 29 in the cache */
   /* replace327_0_1 -> 1151 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_iand,
      1, 1,
      { 29, 1151 },
      -1,
   } },
   /* replace327_1 -> 48 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_iadd,
      0, 2,
      { 1153, 48 },
      -1,
   } },

   /* ('iand@32', ('iadd@32', 'a', '#b(is_unsigned_multiple_of_4)'), 4294967292) => ('iadd', ('iand', 'a', 4294967292), 'b') */
   /* search328_0_0 -> 29 in the cache */
   { .variable = {
      { nir_search_value_variable, 32 },
      1, /* b */
      true,
      nir_type_invalid,
      13,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_iadd,
      1, 1,
      { 29, 1155 },
      -1,
   } },
   { .constant = {
      { nir_search_value_constant, 32 },
      nir_type_int, { 0xfffffffcull /* 4294967292 */ },
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_iand,
      0, 2,
      { 1156, 1157 },
      -1,
   } },

   /* replace328_0_0 -> 29 in the cache */
   /* replace328_0_1 -> 1157 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_iand,
      1, 1,
      { 29, 1157 },
      -1,
   } },
   /* replace328_1 -> 48 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_iadd,
      0, 2,
      { 1159, 48 },
      -1,
   } },

   /* ('iand@32', ('iadd@32', 'a', '#b(is_unsigned_multiple_of_8)'), 4294967288) => ('iadd', ('iand', 'a', 4294967288), 'b') */
   /* search329_0_0 -> 29 in the cache */
   { .variable = {
      { nir_search_value_variable, 32 },
      1, /* b */
      true,
      nir_type_invalid,
      15,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_iadd,
      1, 1,
      { 29, 1161 },
      -1,
   } },
   { .constant = {
      { nir_search_value_constant, 32 },
      nir_type_int, { 0xfffffff8ull /* 4294967288 */ },
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_iand,
      0, 2,
      { 1162, 1163 },
      -1,
   } },

   /* replace329_0_0 -> 29 in the cache */
   /* replace329_0_1 -> 1163 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_iand,
      1, 1,
      { 29, 1163 },
      -1,
   } },
   /* replace329_1 -> 48 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_iadd,
      0, 2,
      { 1165, 48 },
      -1,
   } },

   /* ('iand@32', ('iadd@32', 'a', '#b(is_unsigned_multiple_of_16)'), 4294967280) => ('iadd', ('iand', 'a', 4294967280), 'b') */
   /* search330_0_0 -> 29 in the cache */
   { .variable = {
      { nir_search_value_variable, 32 },
      1, /* b */
      true,
      nir_type_invalid,
      16,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_iadd,
      1, 1,
      { 29, 1167 },
      -1,
   } },
   { .constant = {
      { nir_search_value_constant, 32 },
      nir_type_int, { 0xfffffff0ull /* 4294967280 */ },
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_iand,
      0, 2,
      { 1168, 1169 },
      -1,
   } },

   /* replace330_0_0 -> 29 in the cache */
   /* replace330_0_1 -> 1169 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_iand,
      1, 1,
      { 29, 1169 },
      -1,
   } },
   /* replace330_1 -> 48 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_iadd,
      0, 2,
      { 1171, 48 },
      -1,
   } },

   /* ('iand@32', ('iadd@32', 'a', '#b(is_unsigned_multiple_of_32)'), 4294967264) => ('iadd', ('iand', 'a', 4294967264), 'b') */
   /* search331_0_0 -> 29 in the cache */
   { .variable = {
      { nir_search_value_variable, 32 },
      1, /* b */
      true,
      nir_type_invalid,
      17,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_iadd,
      1, 1,
      { 29, 1173 },
      -1,
   } },
   { .constant = {
      { nir_search_value_constant, 32 },
      nir_type_int, { 0xffffffe0ull /* 4294967264 */ },
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_iand,
      0, 2,
      { 1174, 1175 },
      -1,
   } },

   /* replace331_0_0 -> 29 in the cache */
   /* replace331_0_1 -> 1175 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_iand,
      1, 1,
      { 29, 1175 },
      -1,
   } },
   /* replace331_1 -> 48 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_iadd,
      0, 2,
      { 1177, 48 },
      -1,
   } },

   /* ('iand@32', ('iadd@32', 'a', '#b(is_unsigned_multiple_of_64)'), 4294967232) => ('iadd', ('iand', 'a', 4294967232), 'b') */
   /* search332_0_0 -> 29 in the cache */
   { .variable = {
      { nir_search_value_variable, 32 },
      1, /* b */
      true,
      nir_type_invalid,
      18,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_iadd,
      1, 1,
      { 29, 1179 },
      -1,
   } },
   { .constant = {
      { nir_search_value_constant, 32 },
      nir_type_int, { 0xffffffc0ull /* 4294967232 */ },
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_iand,
      0, 2,
      { 1180, 1181 },
      -1,
   } },

   /* replace332_0_0 -> 29 in the cache */
   /* replace332_0_1 -> 1181 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_iand,
      1, 1,
      { 29, 1181 },
      -1,
   } },
   /* replace332_1 -> 48 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_iadd,
      0, 2,
      { 1183, 48 },
      -1,
   } },

   /* ('ishl@32', ('iand', 'a@32', 2147483647), 1) => ('ishl', 'a', 1) */
   /* search333_0_0 -> 29 in the cache */
   /* search333_0_1 -> 516 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_iand,
      0, 1,
      { 29, 516 },
      -1,
   } },
   /* search333_1 -> 530 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ishl,
      -1, 1,
      { 1185, 530 },
      -1,
   } },

   /* replace333_0 -> 29 in the cache */
   /* replace333_1 -> 530 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ishl,
      -1, 0,
      { 29, 530 },
      -1,
   } },

   /* ('iand', ('ishl', 'a@32', 1), 4294967294) => ('ishl', 'a', 1) */
   /* search334_0_0 -> 29 in the cache */
   /* search334_0_1 -> 530 in the cache */
   /* search334_0 -> 1187 in the cache */
   /* search334_1 -> 1151 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_iand,
      0, 1,
      { 1187, 1151 },
      -1,
   } },

   /* replace334_0 -> 29 in the cache */
   /* replace334_1 -> 530 in the cache */
   /* replace334 -> 1187 in the cache */

   /* ('iand', ('ushr', 'a@32', 1), 2147483647) => ('ushr', 'a', 1) */
   /* search335_0_0 -> 29 in the cache */
   /* search335_0_1 -> 530 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ushr,
      -1, 0,
      { 29, 530 },
      -1,
   } },
   /* search335_1 -> 516 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_iand,
      0, 1,
      { 1189, 516 },
      -1,
   } },

   /* replace335_0 -> 29 in the cache */
   /* replace335_1 -> 530 in the cache */
   /* replace335 -> 1189 in the cache */

   /* ('ishl@32', ('iand', 'a@32', 1073741823), 2) => ('ishl', 'a', 2) */
   /* search336_0_0 -> 29 in the cache */
   { .constant = {
      { nir_search_value_constant, 32 },
      nir_type_int, { 0x3fffffffull /* 1073741823 */ },
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_iand,
      0, 1,
      { 29, 1191 },
      -1,
   } },
   /* search336_1 -> 535 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ishl,
      -1, 1,
      { 1192, 535 },
      -1,
   } },

   /* replace336_0 -> 29 in the cache */
   /* replace336_1 -> 535 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ishl,
      -1, 0,
      { 29, 535 },
      -1,
   } },

   /* ('iand', ('ishl', 'a@32', 2), 4294967292) => ('ishl', 'a', 2) */
   /* search337_0_0 -> 29 in the cache */
   /* search337_0_1 -> 535 in the cache */
   /* search337_0 -> 1194 in the cache */
   /* search337_1 -> 1157 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_iand,
      0, 1,
      { 1194, 1157 },
      -1,
   } },

   /* replace337_0 -> 29 in the cache */
   /* replace337_1 -> 535 in the cache */
   /* replace337 -> 1194 in the cache */

   /* ('iand', ('ushr', 'a@32', 2), 1073741823) => ('ushr', 'a', 2) */
   /* search338_0_0 -> 29 in the cache */
   /* search338_0_1 -> 535 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ushr,
      -1, 0,
      { 29, 535 },
      -1,
   } },
   /* search338_1 -> 1191 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_iand,
      0, 1,
      { 1196, 1191 },
      -1,
   } },

   /* replace338_0 -> 29 in the cache */
   /* replace338_1 -> 535 in the cache */
   /* replace338 -> 1196 in the cache */

   /* ('ishl@32', ('iand', 'a@32', 65535), 16) => ('ishl', 'a', 16) */
   /* search339_0_0 -> 29 in the cache */
   { .constant = {
      { nir_search_value_constant, 32 },
      nir_type_int, { 0xffffull /* 65535 */ },
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_iand,
      0, 1,
      { 29, 1198 },
      -1,
   } },
   /* search339_1 -> 1003 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ishl,
      -1, 1,
      { 1199, 1003 },
      -1,
   } },

   /* replace339_0 -> 29 in the cache */
   /* replace339_1 -> 1003 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ishl,
      -1, 0,
      { 29, 1003 },
      -1,
   } },

   /* ('iand', ('ishl', 'a@32', 16), 4294901760) => ('ishl', 'a', 16) */
   /* search340_0_0 -> 29 in the cache */
   /* search340_0_1 -> 1003 in the cache */
   /* search340_0 -> 1201 in the cache */
   { .constant = {
      { nir_search_value_constant, 32 },
      nir_type_int, { 0xffff0000ull /* 4294901760 */ },
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_iand,
      0, 1,
      { 1201, 1202 },
      -1,
   } },

   /* replace340_0 -> 29 in the cache */
   /* replace340_1 -> 1003 in the cache */
   /* replace340 -> 1201 in the cache */

   /* ('iand', ('ushr', 'a@32', 16), 65535) => ('ushr', 'a', 16) */
   /* search341_0_0 -> 29 in the cache */
   /* search341_0_1 -> 1003 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ushr,
      -1, 0,
      { 29, 1003 },
      -1,
   } },
   /* search341_1 -> 1198 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_iand,
      0, 1,
      { 1204, 1198 },
      -1,
   } },

   /* replace341_0 -> 29 in the cache */
   /* replace341_1 -> 1003 in the cache */
   /* replace341 -> 1204 in the cache */

   /* ('ishl@32', ('iand', 'a@32', 255), 24) => ('ishl', 'a', 24) */
   /* search342_0_0 -> 29 in the cache */
   { .constant = {
      { nir_search_value_constant, 32 },
      nir_type_int, { 0xffull /* 255 */ },
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_iand,
      0, 1,
      { 29, 1206 },
      -1,
   } },
   { .constant = {
      { nir_search_value_constant, 32 },
      nir_type_int, { 0x18ull /* 24 */ },
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ishl,
      -1, 1,
      { 1207, 1208 },
      -1,
   } },

   /* replace342_0 -> 29 in the cache */
   /* replace342_1 -> 1208 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ishl,
      -1, 0,
      { 29, 1208 },
      -1,
   } },

   /* ('iand', ('ishl', 'a@32', 24), 4278190080) => ('ishl', 'a', 24) */
   /* search343_0_0 -> 29 in the cache */
   /* search343_0_1 -> 1208 in the cache */
   /* search343_0 -> 1210 in the cache */
   { .constant = {
      { nir_search_value_constant, 32 },
      nir_type_int, { 0xff000000ull /* 4278190080 */ },
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_iand,
      0, 1,
      { 1210, 1211 },
      -1,
   } },

   /* replace343_0 -> 29 in the cache */
   /* replace343_1 -> 1208 in the cache */
   /* replace343 -> 1210 in the cache */

   /* ('iand', ('ushr', 'a@32', 24), 255) => ('ushr', 'a', 24) */
   /* search344_0_0 -> 29 in the cache */
   /* search344_0_1 -> 1208 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ushr,
      -1, 0,
      { 29, 1208 },
      -1,
   } },
   /* search344_1 -> 1206 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_iand,
      0, 1,
      { 1213, 1206 },
      -1,
   } },

   /* replace344_0 -> 29 in the cache */
   /* replace344_1 -> 1208 in the cache */
   /* replace344 -> 1213 in the cache */

   /* ('ishl', ('iadd', 'a', '#b'), '#c') => ('iadd', ('ishl', 'a', 'c'), ('ishl', 'b', 'c')) */
   /* search345_0_0 -> 0 in the cache */
   /* search345_0_1 -> 971 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_iadd,
      0, 1,
      { 0, 971 },
      -1,
   } },
   /* search345_1 -> 336 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ishl,
      -1, 1,
      { 1215, 336 },
      -1,
   } },

   /* replace345_0_0 -> 0 in the cache */
   /* replace345_0_1 -> 152 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ishl,
      -1, 0,
      { 0, 152 },
      -1,
   } },
   /* replace345_1_0 -> 1 in the cache */
   /* replace345_1_1 -> 152 in the cache */
   /* replace345_1 -> 974 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_iadd,
      0, 1,
      { 1217, 974 },
      -1,
   } },

   /* ('imul', ('iadd(is_used_once)', 'a', '#b'), '#c') => ('iadd', ('imul', 'a', 'c'), ('imul', 'b', 'c')) */
   /* search346_0_0 -> 143 in the cache */
   /* search346_0_1 -> 310 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_iadd,
      1, 1,
      { 143, 310 },
      0,
   } },
   /* search346_1 -> 964 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_imul,
      0, 2,
      { 1219, 964 },
      -1,
   } },

   /* replace346_0_0 -> 143 in the cache */
   /* replace346_0_1 -> 146 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_imul,
      1, 1,
      { 143, 146 },
      -1,
   } },
   /* replace346_1_0 -> 144 in the cache */
   /* replace346_1_1 -> 146 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_imul,
      2, 1,
      { 144, 146 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_iadd,
      0, 3,
      { 1221, 1222 },
      -1,
   } },

   /* ('imul', ('iadd(is_used_once)', ('iadd(is_used_once)', 'a', '#b'), 'c'), '#d') => ('iadd', ('imul', ('iadd', 'a', 'c'), 'd'), ('imul', 'b', 'd')) */
   /* search347_0_0_0 -> 166 in the cache */
   { .variable = {
      { nir_search_value_variable, -4 },
      1, /* b */
      true,
      nir_type_invalid,
      -1,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .expression = {
      { nir_search_value_expression, -4 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_iadd,
      2, 1,
      { 166, 1224 },
      0,
   } },
   /* search347_0_1 -> 169 in the cache */
   { .expression = {
      { nir_search_value_expression, -4 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_iadd,
      1, 2,
      { 1225, 169 },
      0,
   } },
   { .variable = {
      { nir_search_value_variable, -4 },
      3, /* d */
      true,
      nir_type_invalid,
      -1,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .expression = {
      { nir_search_value_expression, -4 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_imul,
      0, 3,
      { 1226, 1227 },
      -1,
   } },

   /* replace347_0_0_0 -> 166 in the cache */
   /* replace347_0_0_1 -> 169 in the cache */
   { .expression = {
      { nir_search_value_expression, -4 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_iadd,
      2, 1,
      { 166, 169 },
      -1,
   } },
   /* replace347_0_1 -> 170 in the cache */
   { .expression = {
      { nir_search_value_expression, -4 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_imul,
      1, 2,
      { 1229, 170 },
      -1,
   } },
   /* replace347_1_0 -> 167 in the cache */
   /* replace347_1_1 -> 170 in the cache */
   { .expression = {
      { nir_search_value_expression, -4 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_imul,
      3, 1,
      { 167, 170 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -4 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_iadd,
      0, 4,
      { 1230, 1231 },
      -1,
   } },

   /* ('ishl', ('iadd(is_used_once)', ('iadd(is_used_once)', 'a', '#b'), 'c'), '#d') => ('iadd', ('ishl', ('iadd', 'a', 'c'), 'd'), ('ishl', 'b', 'd')) */
   /* search348_0_0_0 -> 143 in the cache */
   /* search348_0_0_1 -> 310 in the cache */
   /* search348_0_0 -> 1219 in the cache */
   /* search348_0_1 -> 146 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_iadd,
      0, 2,
      { 1219, 146 },
      0,
   } },
   /* search348_1 -> 338 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ishl,
      -1, 2,
      { 1233, 338 },
      -1,
   } },

   /* replace348_0_0_0 -> 143 in the cache */
   /* replace348_0_0_1 -> 146 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_iadd,
      1, 1,
      { 143, 146 },
      -1,
   } },
   /* replace348_0_1 -> 180 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ishl,
      -1, 1,
      { 1235, 180 },
      -1,
   } },
   /* replace348_1_0 -> 144 in the cache */
   /* replace348_1_1 -> 180 in the cache */
   /* replace348_1 -> 967 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_iadd,
      0, 2,
      { 1236, 967 },
      -1,
   } },

   /* ('inot', ('flt(is_used_once)', 'a(is_a_number)', 'b(is_a_number)')) => ('fge', 'a', 'b') */
   { .variable = {
      { nir_search_value_variable, -2 },
      0, /* a */
      false,
      nir_type_invalid,
      19,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .variable = {
      { nir_search_value_variable, -2 },
      1, /* b */
      false,
      nir_type_invalid,
      19,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_flt,
      -1, 0,
      { 1238, 1239 },
      0,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_inot,
      -1, 0,
      { 1240 },
      -1,
   } },

   /* replace349_0 -> 0 in the cache */
   /* replace349_1 -> 1 in the cache */
   /* replace349 -> 6 in the cache */

   /* ('inot', ('fge(is_used_once)', 'a(is_a_number)', 'b(is_a_number)')) => ('flt', 'a', 'b') */
   /* search350_0_0 -> 1238 in the cache */
   /* search350_0_1 -> 1239 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fge,
      -1, 0,
      { 1238, 1239 },
      0,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_inot,
      -1, 0,
      { 1242 },
      -1,
   } },

   /* replace350_0 -> 0 in the cache */
   /* replace350_1 -> 1 in the cache */
   /* replace350 -> 3 in the cache */

   /* ('inot', ('feq(is_used_once)', 'a', 'b')) => ('fneu', 'a', 'b') */
   /* search351_0_0 -> 0 in the cache */
   /* search351_0_1 -> 1 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_feq,
      0, 1,
      { 0, 1 },
      0,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_inot,
      -1, 1,
      { 1244 },
      -1,
   } },

   /* replace351_0 -> 0 in the cache */
   /* replace351_1 -> 1 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fneu,
      0, 1,
      { 0, 1 },
      -1,
   } },

   /* ('inot', ('fneu(is_used_once)', 'a', 'b')) => ('feq', 'a', 'b') */
   /* search352_0_0 -> 0 in the cache */
   /* search352_0_1 -> 1 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fneu,
      0, 1,
      { 0, 1 },
      0,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_inot,
      -1, 1,
      { 1247 },
      -1,
   } },

   /* replace352_0 -> 0 in the cache */
   /* replace352_1 -> 1 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_feq,
      0, 1,
      { 0, 1 },
      -1,
   } },

   /* ('inot', ('ilt(is_used_once)', 'a', 'b')) => ('ige', 'a', 'b') */
   /* search353_0_0 -> 0 in the cache */
   /* search353_0_1 -> 1 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ilt,
      -1, 0,
      { 0, 1 },
      0,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_inot,
      -1, 0,
      { 1250 },
      -1,
   } },

   /* replace353_0 -> 0 in the cache */
   /* replace353_1 -> 1 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ige,
      -1, 0,
      { 0, 1 },
      -1,
   } },

   /* ('inot', ('ult(is_used_once)', 'a', 'b')) => ('uge', 'a', 'b') */
   /* search354_0_0 -> 0 in the cache */
   /* search354_0_1 -> 1 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ult,
      -1, 0,
      { 0, 1 },
      0,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_inot,
      -1, 0,
      { 1253 },
      -1,
   } },

   /* replace354_0 -> 0 in the cache */
   /* replace354_1 -> 1 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_uge,
      -1, 0,
      { 0, 1 },
      -1,
   } },

   /* ('inot', ('ige(is_used_once)', 'a', 'b')) => ('ilt', 'a', 'b') */
   /* search355_0_0 -> 0 in the cache */
   /* search355_0_1 -> 1 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ige,
      -1, 0,
      { 0, 1 },
      0,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_inot,
      -1, 0,
      { 1256 },
      -1,
   } },

   /* replace355_0 -> 0 in the cache */
   /* replace355_1 -> 1 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ilt,
      -1, 0,
      { 0, 1 },
      -1,
   } },

   /* ('inot', ('uge(is_used_once)', 'a', 'b')) => ('ult', 'a', 'b') */
   /* search356_0_0 -> 0 in the cache */
   /* search356_0_1 -> 1 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_uge,
      -1, 0,
      { 0, 1 },
      0,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_inot,
      -1, 0,
      { 1259 },
      -1,
   } },

   /* replace356_0 -> 0 in the cache */
   /* replace356_1 -> 1 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ult,
      -1, 0,
      { 0, 1 },
      -1,
   } },

   /* ('inot', ('ieq(is_used_once)', 'a', 'b')) => ('ine', 'a', 'b') */
   /* search357_0_0 -> 0 in the cache */
   /* search357_0_1 -> 1 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ieq,
      0, 1,
      { 0, 1 },
      0,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_inot,
      -1, 1,
      { 1262 },
      -1,
   } },

   /* replace357_0 -> 0 in the cache */
   /* replace357_1 -> 1 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ine,
      0, 1,
      { 0, 1 },
      -1,
   } },

   /* ('inot', ('ine(is_used_once)', 'a', 'b')) => ('ieq', 'a', 'b') */
   /* search358_0_0 -> 0 in the cache */
   /* search358_0_1 -> 1 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ine,
      0, 1,
      { 0, 1 },
      0,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_inot,
      -1, 1,
      { 1265 },
      -1,
   } },

   /* replace358_0 -> 0 in the cache */
   /* replace358_1 -> 1 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ieq,
      0, 1,
      { 0, 1 },
      -1,
   } },

   /* ('iand', ('feq', 'a', 'b'), ('fneu', 'a', 'b')) => False */
   /* search359_0_0 -> 0 in the cache */
   /* search359_0_1 -> 1 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_feq,
      1, 1,
      { 0, 1 },
      -1,
   } },
   /* search359_1_0 -> 0 in the cache */
   /* search359_1_1 -> 1 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fneu,
      2, 1,
      { 0, 1 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_iand,
      0, 3,
      { 1268, 1269 },
      -1,
   } },

   { .constant = {
      { nir_search_value_constant, 1 },
      nir_type_bool, { NIR_FALSE /* False */ },
   } },

   /* ('iand', ('flt', 'a', 'b'), ('flt', 'b', 'a')) => False */
   /* search360_0_0 -> 0 in the cache */
   /* search360_0_1 -> 1 in the cache */
   /* search360_0 -> 3 in the cache */
   /* search360_1_0 -> 1 in the cache */
   /* search360_1_1 -> 0 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_flt,
      -1, 0,
      { 1, 0 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_iand,
      0, 1,
      { 3, 1272 },
      -1,
   } },

   /* replace360 -> 1271 in the cache */

   /* ('iand', ('ieq', 'a', 'b'), ('ine', 'a', 'b')) => False */
   /* search361_0_0 -> 0 in the cache */
   /* search361_0_1 -> 1 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ieq,
      1, 1,
      { 0, 1 },
      -1,
   } },
   /* search361_1_0 -> 0 in the cache */
   /* search361_1_1 -> 1 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ine,
      2, 1,
      { 0, 1 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_iand,
      0, 3,
      { 1274, 1275 },
      -1,
   } },

   /* replace361 -> 1271 in the cache */

   /* ('iand', ('ilt', 'a', 'b'), ('ilt', 'b', 'a')) => False */
   /* search362_0_0 -> 0 in the cache */
   /* search362_0_1 -> 1 in the cache */
   /* search362_0 -> 1258 in the cache */
   /* search362_1_0 -> 1 in the cache */
   /* search362_1_1 -> 0 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ilt,
      -1, 0,
      { 1, 0 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_iand,
      0, 1,
      { 1258, 1277 },
      -1,
   } },

   /* replace362 -> 1271 in the cache */

   /* ('iand', ('ult', 'a', 'b'), ('ult', 'b', 'a')) => False */
   /* search363_0_0 -> 0 in the cache */
   /* search363_0_1 -> 1 in the cache */
   /* search363_0 -> 1261 in the cache */
   /* search363_1_0 -> 1 in the cache */
   /* search363_1_1 -> 0 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ult,
      -1, 0,
      { 1, 0 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_iand,
      0, 1,
      { 1261, 1279 },
      -1,
   } },

   /* replace363 -> 1271 in the cache */

   /* ('flt', ('fneg', 'a'), ('fneg', 'b')) => ('flt', 'b', 'a') */
   /* search364_0_0 -> 0 in the cache */
   /* search364_0 -> 132 in the cache */
   /* search364_1_0 -> 1 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fneg,
      -1, 0,
      { 1 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_flt,
      -1, 0,
      { 132, 1281 },
      -1,
   } },

   /* replace364_0 -> 1 in the cache */
   /* replace364_1 -> 0 in the cache */
   /* replace364 -> 1272 in the cache */

   /* ('fge', ('fneg', 'a'), ('fneg', 'b')) => ('fge', 'b', 'a') */
   /* search365_0_0 -> 0 in the cache */
   /* search365_0 -> 132 in the cache */
   /* search365_1_0 -> 1 in the cache */
   /* search365_1 -> 1281 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fge,
      -1, 0,
      { 132, 1281 },
      -1,
   } },

   /* replace365_0 -> 1 in the cache */
   /* replace365_1 -> 0 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fge,
      -1, 0,
      { 1, 0 },
      -1,
   } },

   /* ('feq', ('fneg', 'a'), ('fneg', 'b')) => ('feq', 'b', 'a') */
   /* search366_0_0 -> 0 in the cache */
   /* search366_0 -> 132 in the cache */
   /* search366_1_0 -> 1 in the cache */
   /* search366_1 -> 1281 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_feq,
      0, 1,
      { 132, 1281 },
      -1,
   } },

   /* replace366_0 -> 1 in the cache */
   /* replace366_1 -> 0 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_feq,
      0, 1,
      { 1, 0 },
      -1,
   } },

   /* ('fneu', ('fneg', 'a'), ('fneg', 'b')) => ('fneu', 'b', 'a') */
   /* search367_0_0 -> 0 in the cache */
   /* search367_0 -> 132 in the cache */
   /* search367_1_0 -> 1 in the cache */
   /* search367_1 -> 1281 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fneu,
      0, 1,
      { 132, 1281 },
      -1,
   } },

   /* replace367_0 -> 1 in the cache */
   /* replace367_1 -> 0 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fneu,
      0, 1,
      { 1, 0 },
      -1,
   } },

   /* ('flt', ('fneg', 'a(is_not_const)'), '#b') => ('flt', ('fneg', 'b'), 'a') */
   { .variable = {
      { nir_search_value_variable, -2 },
      0, /* a */
      false,
      nir_type_invalid,
      6,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fneg,
      -1, 0,
      { 1289 },
      -1,
   } },
   /* search368_1 -> 971 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_flt,
      -1, 0,
      { 1290, 971 },
      -1,
   } },

   /* replace368_0_0 -> 1 in the cache */
   /* replace368_0 -> 1281 in the cache */
   /* replace368_1 -> 0 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_flt,
      -1, 0,
      { 1281, 0 },
      -1,
   } },

   /* ('flt', '#b', ('fneg', 'a(is_not_const)')) => ('flt', 'a', ('fneg', 'b')) */
   { .variable = {
      { nir_search_value_variable, -2 },
      0, /* b */
      true,
      nir_type_invalid,
      -1,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .variable = {
      { nir_search_value_variable, -2 },
      1, /* a */
      false,
      nir_type_invalid,
      6,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fneg,
      -1, 0,
      { 1294 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_flt,
      -1, 0,
      { 1293, 1295 },
      -1,
   } },

   { .variable = {
      { nir_search_value_variable, -2 },
      1, /* a */
      false,
      nir_type_invalid,
      -1,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .variable = {
      { nir_search_value_variable, -2 },
      0, /* b */
      false,
      nir_type_invalid,
      -1,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fneg,
      -1, 0,
      { 1298 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_flt,
      -1, 0,
      { 1297, 1299 },
      -1,
   } },

   /* ('fge', ('fneg', 'a(is_not_const)'), '#b') => ('fge', ('fneg', 'b'), 'a') */
   /* search370_0_0 -> 1289 in the cache */
   /* search370_0 -> 1290 in the cache */
   /* search370_1 -> 971 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fge,
      -1, 0,
      { 1290, 971 },
      -1,
   } },

   /* replace370_0_0 -> 1 in the cache */
   /* replace370_0 -> 1281 in the cache */
   /* replace370_1 -> 0 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fge,
      -1, 0,
      { 1281, 0 },
      -1,
   } },

   /* ('fge', '#b', ('fneg', 'a(is_not_const)')) => ('fge', 'a', ('fneg', 'b')) */
   /* search371_0 -> 1293 in the cache */
   /* search371_1_0 -> 1294 in the cache */
   /* search371_1 -> 1295 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fge,
      -1, 0,
      { 1293, 1295 },
      -1,
   } },

   /* replace371_0 -> 1297 in the cache */
   /* replace371_1_0 -> 1298 in the cache */
   /* replace371_1 -> 1299 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fge,
      -1, 0,
      { 1297, 1299 },
      -1,
   } },

   /* ('fneu', ('fneg', 'a(is_not_const)'), '#b') => ('fneu', ('fneg', 'b'), 'a') */
   /* search372_0_0 -> 1289 in the cache */
   /* search372_0 -> 1290 in the cache */
   /* search372_1 -> 971 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fneu,
      0, 1,
      { 1290, 971 },
      -1,
   } },

   /* replace372_0_0 -> 1 in the cache */
   /* replace372_0 -> 1281 in the cache */
   /* replace372_1 -> 0 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fneu,
      0, 1,
      { 1281, 0 },
      -1,
   } },

   /* ('feq', '#b', ('fneg', 'a(is_not_const)')) => ('feq', 'a', ('fneg', 'b')) */
   /* search373_0 -> 1293 in the cache */
   /* search373_1_0 -> 1294 in the cache */
   /* search373_1 -> 1295 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_feq,
      0, 1,
      { 1293, 1295 },
      -1,
   } },

   /* replace373_0 -> 1297 in the cache */
   /* replace373_1_0 -> 1298 in the cache */
   /* replace373_1 -> 1299 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_feq,
      0, 1,
      { 1297, 1299 },
      -1,
   } },

   /* ('flt', 'a', '#b(is_negative_zero)') => ('flt', 'a', 0.0) */
   /* search374_0 -> 0 in the cache */
   /* search374_1 -> 130 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_flt,
      -1, 0,
      { 0, 130 },
      -1,
   } },

   /* replace374_0 -> 0 in the cache */
   /* replace374_1 -> 287 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_flt,
      -1, 0,
      { 0, 287 },
      -1,
   } },

   /* ('flt', '#b(is_negative_zero)', 'a') => ('flt', 0.0, 'a') */
   { .variable = {
      { nir_search_value_variable, -2 },
      0, /* b */
      true,
      nir_type_invalid,
      3,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   /* search375_1 -> 1297 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_flt,
      -1, 0,
      { 1311, 1297 },
      -1,
   } },

   /* replace375_0 -> 287 in the cache */
   /* replace375_1 -> 1297 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_flt,
      -1, 0,
      { 287, 1297 },
      -1,
   } },

   /* ('fge', 'a', '#b(is_negative_zero)') => ('fge', 'a', 0.0) */
   /* search376_0 -> 0 in the cache */
   /* search376_1 -> 130 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fge,
      -1, 0,
      { 0, 130 },
      -1,
   } },

   /* replace376_0 -> 0 in the cache */
   /* replace376_1 -> 287 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fge,
      -1, 0,
      { 0, 287 },
      -1,
   } },

   /* ('fge', '#b(is_negative_zero)', 'a') => ('fge', 0.0, 'a') */
   /* search377_0 -> 1311 in the cache */
   /* search377_1 -> 1297 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fge,
      -1, 0,
      { 1311, 1297 },
      -1,
   } },

   /* replace377_0 -> 287 in the cache */
   /* replace377_1 -> 1297 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fge,
      -1, 0,
      { 287, 1297 },
      -1,
   } },

   /* ('fneu', 'a', '#b(is_negative_zero)') => ('fneu', 0.0, 'a') */
   /* search378_0 -> 0 in the cache */
   /* search378_1 -> 130 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fneu,
      0, 1,
      { 0, 130 },
      -1,
   } },

   /* replace378_0 -> 287 in the cache */
   /* replace378_1 -> 0 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fneu,
      0, 1,
      { 287, 0 },
      -1,
   } },

   /* ('feq', '#b(is_negative_zero)', 'a') => ('feq', 'a', 0.0) */
   /* search379_0 -> 1311 in the cache */
   /* search379_1 -> 1297 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_feq,
      0, 1,
      { 1311, 1297 },
      -1,
   } },

   /* replace379_0 -> 1297 in the cache */
   /* replace379_1 -> 287 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_feq,
      0, 1,
      { 1297, 287 },
      -1,
   } },

   /* ('ieq', ('ineg', 'a'), 0) => ('ieq', 'a', 0) */
   /* search380_0_0 -> 9 in the cache */
   /* search380_0 -> 120 in the cache */
   /* search380_1 -> 73 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ieq,
      0, 1,
      { 120, 73 },
      -1,
   } },

   /* replace380_0 -> 9 in the cache */
   /* replace380_1 -> 73 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ieq,
      0, 1,
      { 9, 73 },
      -1,
   } },

   /* ('ine', ('ineg', 'a'), 0) => ('ine', 'a', 0) */
   /* search381_0_0 -> 9 in the cache */
   /* search381_0 -> 120 in the cache */
   /* search381_1 -> 73 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ine,
      0, 1,
      { 120, 73 },
      -1,
   } },

   /* replace381_0 -> 9 in the cache */
   /* replace381_1 -> 73 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ine,
      0, 1,
      { 9, 73 },
      -1,
   } },

   /* ('ieq', ('iabs', 'a'), 0) => ('ieq', 'a', 0) */
   /* search382_0_0 -> 9 in the cache */
   /* search382_0 -> 125 in the cache */
   /* search382_1 -> 73 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ieq,
      0, 1,
      { 125, 73 },
      -1,
   } },

   /* replace382_0 -> 9 in the cache */
   /* replace382_1 -> 73 in the cache */
   /* replace382 -> 1323 in the cache */

   /* ('ine', ('iabs', 'a'), 0) => ('ine', 'a', 0) */
   /* search383_0_0 -> 9 in the cache */
   /* search383_0 -> 125 in the cache */
   /* search383_1 -> 73 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ine,
      0, 1,
      { 125, 73 },
      -1,
   } },

   /* replace383_0 -> 9 in the cache */
   /* replace383_1 -> 73 in the cache */
   /* replace383 -> 1325 in the cache */

   /* ('fneu', ('fabs', 'a'), 0.0) => ('fneu', 'a', 0.0) */
   /* search384_0_0 -> 9 in the cache */
   /* search384_0 -> 11 in the cache */
   /* search384_1 -> 8 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fneu,
      0, 1,
      { 11, 8 },
      -1,
   } },

   /* replace384_0 -> 9 in the cache */
   /* replace384_1 -> 8 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fneu,
      0, 1,
      { 9, 8 },
      -1,
   } },

   /* ('feq', ('fabs', 'a'), 0.0) => ('feq', 'a', 0.0) */
   /* search385_0_0 -> 9 in the cache */
   /* search385_0 -> 11 in the cache */
   /* search385_1 -> 8 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_feq,
      0, 1,
      { 11, 8 },
      -1,
   } },

   /* replace385_0 -> 9 in the cache */
   /* replace385_1 -> 8 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_feq,
      0, 1,
      { 9, 8 },
      -1,
   } },

   /* ('fneu', ('fabs', 'a'), ('fabs', 'a')) => ('fneu', 'a', 'a') */
   /* search386_0_0 -> 9 in the cache */
   /* search386_0 -> 11 in the cache */
   /* search386_1_0 -> 9 in the cache */
   /* search386_1 -> 11 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fneu,
      -1, 0,
      { 11, 11 },
      -1,
   } },

   /* replace386_0 -> 9 in the cache */
   /* replace386_1 -> 9 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fneu,
      -1, 0,
      { 9, 9 },
      -1,
   } },

   /* ('feq', ('fabs', 'a'), ('fabs', 'a')) => ('feq', 'a', 'a') */
   /* search387_0_0 -> 9 in the cache */
   /* search387_0 -> 11 in the cache */
   /* search387_1_0 -> 9 in the cache */
   /* search387_1 -> 11 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_feq,
      -1, 0,
      { 11, 11 },
      -1,
   } },

   /* replace387_0 -> 9 in the cache */
   /* replace387_1 -> 9 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_feq,
      -1, 0,
      { 9, 9 },
      -1,
   } },

   /* ('flt', '#b(is_gt_0_and_lt_1)', ('fsat(is_used_once)', 'a')) => ('flt', 'b', 'a') */
   { .variable = {
      { nir_search_value_variable, -2 },
      0, /* b */
      true,
      nir_type_invalid,
      20,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   /* search388_1_0 -> 1297 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fsat,
      -1, 0,
      { 1297 },
      0,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_flt,
      -1, 0,
      { 1336, 1337 },
      -1,
   } },

   /* replace388_0 -> 1298 in the cache */
   /* replace388_1 -> 1297 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_flt,
      -1, 0,
      { 1298, 1297 },
      -1,
   } },

   /* ('fge', ('fsat(is_used_once)', 'a'), '#b(is_gt_0_and_lt_1)') => ('fge', 'a', 'b') */
   /* search389_0_0 -> 0 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fsat,
      -1, 0,
      { 0 },
      0,
   } },
   { .variable = {
      { nir_search_value_variable, -2 },
      1, /* b */
      true,
      nir_type_invalid,
      20,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fge,
      -1, 0,
      { 1340, 1341 },
      -1,
   } },

   /* replace389_0 -> 0 in the cache */
   /* replace389_1 -> 1 in the cache */
   /* replace389 -> 6 in the cache */

   /* ('feq', ('fsat(is_used_once)', 'a'), '#b(is_gt_0_and_lt_1)') => ('feq', 'a', 'b') */
   /* search390_0_0 -> 0 in the cache */
   /* search390_0 -> 1340 in the cache */
   /* search390_1 -> 1341 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_feq,
      0, 1,
      { 1340, 1341 },
      -1,
   } },

   /* replace390_0 -> 0 in the cache */
   /* replace390_1 -> 1 in the cache */
   /* replace390 -> 1249 in the cache */

   /* ('fneu', ('fsat(is_used_once)', 'a'), '#b(is_gt_0_and_lt_1)') => ('fneu', 'a', 'b') */
   /* search391_0_0 -> 0 in the cache */
   /* search391_0 -> 1340 in the cache */
   /* search391_1 -> 1341 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fneu,
      0, 1,
      { 1340, 1341 },
      -1,
   } },

   /* replace391_0 -> 0 in the cache */
   /* replace391_1 -> 1 in the cache */
   /* replace391 -> 1246 in the cache */

   /* ('fge', ('fsat(is_used_once)', 'a'), 1.0) => ('fge', 'a', 1.0) */
   /* search392_0_0 -> 9 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fsat,
      -1, 0,
      { 9 },
      0,
   } },
   /* search392_1 -> 273 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fge,
      -1, 0,
      { 1345, 273 },
      -1,
   } },

   /* replace392_0 -> 9 in the cache */
   /* replace392_1 -> 273 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fge,
      -1, 0,
      { 9, 273 },
      -1,
   } },

   /* ('flt', 0.0, ('fsat(is_used_once)', 'a')) => ('flt', 0.0, 'a') */
   /* search393_0 -> 8 in the cache */
   /* search393_1_0 -> 9 in the cache */
   /* search393_1 -> 1345 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_flt,
      -1, 0,
      { 8, 1345 },
      -1,
   } },

   /* replace393_0 -> 8 in the cache */
   /* replace393_1 -> 9 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_flt,
      -1, 0,
      { 8, 9 },
      -1,
   } },

   /* ('fge', 0.0, ('b2f', 'a@1')) => ('inot', 'a') */
   { .constant = {
      { nir_search_value_constant, 0 },
      nir_type_float, { 0x0ull /* 0.0 */ },
   } },
   /* search394_1_0 -> 907 in the cache */
   { .expression = {
      { nir_search_value_expression, 0 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_search_op_b2f,
      -1, 0,
      { 907 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fge,
      -1, 0,
      { 1350, 1351 },
      -1,
   } },

   /* replace394_0 -> 907 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_inot,
      -1, 0,
      { 907 },
      -1,
   } },

   /* ('fge', ('fneg', ('b2f', 'a@1')), 0.0) => ('inot', 'a') */
   /* search395_0_0_0 -> 907 in the cache */
   /* search395_0_0 -> 1351 in the cache */
   { .expression = {
      { nir_search_value_expression, 0 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fneg,
      -1, 0,
      { 1351 },
      -1,
   } },
   /* search395_1 -> 1350 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fge,
      -1, 0,
      { 1354, 1350 },
      -1,
   } },

   /* replace395_0 -> 907 in the cache */
   /* replace395 -> 1353 in the cache */

   /* ('fneu', ('fadd', ('b2f', 'a@1'), ('b2f', 'b@1')), 0.0) => ('ior', 'a', 'b') */
   /* search396_0_0_0 -> 907 in the cache */
   /* search396_0_0 -> 1351 in the cache */
   { .variable = {
      { nir_search_value_variable, 1 },
      1, /* b */
      false,
      nir_type_invalid,
      -1,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .expression = {
      { nir_search_value_expression, 0 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_search_op_b2f,
      -1, 0,
      { 1356 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 0 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fadd,
      1, 1,
      { 1351, 1357 },
      -1,
   } },
   /* search396_1 -> 1350 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fneu,
      0, 2,
      { 1358, 1350 },
      -1,
   } },

   /* replace396_0 -> 907 in the cache */
   /* replace396_1 -> 1356 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ior,
      0, 1,
      { 907, 1356 },
      -1,
   } },

   /* ('fneu', ('bcsel', 'a', 1.0, ('b2f', 'b@1')), 0.0) => ('ior', 'a', 'b') */
   /* search397_0_0 -> 907 in the cache */
   { .constant = {
      { nir_search_value_constant, 0 },
      nir_type_float, { 0x3ff0000000000000ull /* 1.0 */ },
   } },
   /* search397_0_2_0 -> 1356 in the cache */
   /* search397_0_2 -> 1357 in the cache */
   { .expression = {
      { nir_search_value_expression, 0 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_bcsel,
      -1, 0,
      { 907, 1361, 1357 },
      -1,
   } },
   /* search397_1 -> 1350 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fneu,
      0, 1,
      { 1362, 1350 },
      -1,
   } },

   /* replace397_0 -> 907 in the cache */
   /* replace397_1 -> 1356 in the cache */
   /* replace397 -> 1360 in the cache */

   /* ('fneu', ('b2f', 'a@1'), ('fneg', ('b2f', 'b@1'))) => ('ior', 'a', 'b') */
   /* search398_0_0 -> 907 in the cache */
   /* search398_0 -> 1351 in the cache */
   /* search398_1_0_0 -> 1356 in the cache */
   /* search398_1_0 -> 1357 in the cache */
   { .expression = {
      { nir_search_value_expression, 0 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fneg,
      -1, 0,
      { 1357 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fneu,
      0, 1,
      { 1351, 1364 },
      -1,
   } },

   /* replace398_0 -> 907 in the cache */
   /* replace398_1 -> 1356 in the cache */
   /* replace398 -> 1360 in the cache */

   /* ('fneu', ('fmul', ('b2f', 'a@1'), ('b2f', 'b@1')), 0.0) => ('iand', 'a', 'b') */
   /* search399_0_0_0 -> 907 in the cache */
   /* search399_0_0 -> 1351 in the cache */
   /* search399_0_1_0 -> 1356 in the cache */
   /* search399_0_1 -> 1357 in the cache */
   { .expression = {
      { nir_search_value_expression, 0 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fmul,
      1, 1,
      { 1351, 1357 },
      -1,
   } },
   /* search399_1 -> 1350 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fneu,
      0, 2,
      { 1366, 1350 },
      -1,
   } },

   /* replace399_0 -> 907 in the cache */
   /* replace399_1 -> 1356 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_iand,
      0, 1,
      { 907, 1356 },
      -1,
   } },

   /* ('fneu', ('bcsel', 'a', ('b2f', 'b@1'), 0.0), 0.0) => ('iand', 'a', 'b') */
   /* search400_0_0 -> 907 in the cache */
   /* search400_0_1_0 -> 1356 in the cache */
   /* search400_0_1 -> 1357 in the cache */
   /* search400_0_2 -> 1350 in the cache */
   { .expression = {
      { nir_search_value_expression, 0 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_bcsel,
      -1, 0,
      { 907, 1357, 1350 },
      -1,
   } },
   /* search400_1 -> 1350 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fneu,
      0, 1,
      { 1369, 1350 },
      -1,
   } },

   /* replace400_0 -> 907 in the cache */
   /* replace400_1 -> 1356 in the cache */
   /* replace400 -> 1368 in the cache */

   /* ('fneu', ('fadd', ('b2f', 'a@1'), ('fneg', ('b2f', 'b@1'))), 0.0) => ('ixor', 'a', 'b') */
   /* search401_0_0_0 -> 907 in the cache */
   /* search401_0_0 -> 1351 in the cache */
   /* search401_0_1_0_0 -> 1356 in the cache */
   /* search401_0_1_0 -> 1357 in the cache */
   /* search401_0_1 -> 1364 in the cache */
   { .expression = {
      { nir_search_value_expression, 0 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fadd,
      1, 1,
      { 1351, 1364 },
      -1,
   } },
   /* search401_1 -> 1350 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fneu,
      0, 2,
      { 1371, 1350 },
      -1,
   } },

   /* replace401_0 -> 907 in the cache */
   /* replace401_1 -> 1356 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ixor,
      0, 1,
      { 907, 1356 },
      -1,
   } },

   /* ('fneu', ('b2f', 'a@1'), ('b2f', 'b@1')) => ('ixor', 'a', 'b') */
   /* search402_0_0 -> 907 in the cache */
   /* search402_0 -> 1351 in the cache */
   /* search402_1_0 -> 1356 in the cache */
   /* search402_1 -> 1357 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fneu,
      0, 1,
      { 1351, 1357 },
      -1,
   } },

   /* replace402_0 -> 907 in the cache */
   /* replace402_1 -> 1356 in the cache */
   /* replace402 -> 1373 in the cache */

   /* ('fneu', ('fneg', ('b2f', 'a@1')), ('fneg', ('b2f', 'b@1'))) => ('ixor', 'a', 'b') */
   /* search403_0_0_0 -> 907 in the cache */
   /* search403_0_0 -> 1351 in the cache */
   /* search403_0 -> 1354 in the cache */
   /* search403_1_0_0 -> 1356 in the cache */
   /* search403_1_0 -> 1357 in the cache */
   /* search403_1 -> 1364 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fneu,
      0, 1,
      { 1354, 1364 },
      -1,
   } },

   /* replace403_0 -> 907 in the cache */
   /* replace403_1 -> 1356 in the cache */
   /* replace403 -> 1373 in the cache */

   /* ('feq', ('fadd', ('b2f', 'a@1'), ('b2f', 'b@1')), 0.0) => ('inot', ('ior', 'a', 'b')) */
   /* search404_0_0_0 -> 907 in the cache */
   /* search404_0_0 -> 1351 in the cache */
   /* search404_0_1_0 -> 1356 in the cache */
   /* search404_0_1 -> 1357 in the cache */
   /* search404_0 -> 1358 in the cache */
   /* search404_1 -> 1350 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_feq,
      0, 2,
      { 1358, 1350 },
      -1,
   } },

   /* replace404_0_0 -> 907 in the cache */
   /* replace404_0_1 -> 1356 in the cache */
   /* replace404_0 -> 1360 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_inot,
      -1, 1,
      { 1360 },
      -1,
   } },

   /* ('feq', ('bcsel', 'a', 1.0, ('b2f', 'b@1')), 0.0) => ('inot', ('ior', 'a', 'b')) */
   /* search405_0_0 -> 907 in the cache */
   /* search405_0_1 -> 1361 in the cache */
   /* search405_0_2_0 -> 1356 in the cache */
   /* search405_0_2 -> 1357 in the cache */
   /* search405_0 -> 1362 in the cache */
   /* search405_1 -> 1350 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_feq,
      0, 1,
      { 1362, 1350 },
      -1,
   } },

   /* replace405_0_0 -> 907 in the cache */
   /* replace405_0_1 -> 1356 in the cache */
   /* replace405_0 -> 1360 in the cache */
   /* replace405 -> 1377 in the cache */

   /* ('feq', ('b2f', 'a@1'), ('fneg', ('b2f', 'b@1'))) => ('inot', ('ior', 'a', 'b')) */
   /* search406_0_0 -> 907 in the cache */
   /* search406_0 -> 1351 in the cache */
   /* search406_1_0_0 -> 1356 in the cache */
   /* search406_1_0 -> 1357 in the cache */
   /* search406_1 -> 1364 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_feq,
      0, 1,
      { 1351, 1364 },
      -1,
   } },

   /* replace406_0_0 -> 907 in the cache */
   /* replace406_0_1 -> 1356 in the cache */
   /* replace406_0 -> 1360 in the cache */
   /* replace406 -> 1377 in the cache */

   /* ('feq', ('fmul', ('b2f', 'a@1'), ('b2f', 'b@1')), 0.0) => ('inot', ('iand', 'a', 'b')) */
   /* search407_0_0_0 -> 907 in the cache */
   /* search407_0_0 -> 1351 in the cache */
   /* search407_0_1_0 -> 1356 in the cache */
   /* search407_0_1 -> 1357 in the cache */
   /* search407_0 -> 1366 in the cache */
   /* search407_1 -> 1350 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_feq,
      0, 2,
      { 1366, 1350 },
      -1,
   } },

   /* replace407_0_0 -> 907 in the cache */
   /* replace407_0_1 -> 1356 in the cache */
   /* replace407_0 -> 1368 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_inot,
      -1, 1,
      { 1368 },
      -1,
   } },

   /* ('feq', ('bcsel', 'a', ('b2f', 'b@1'), 0.0), 0.0) => ('inot', ('iand', 'a', 'b')) */
   /* search408_0_0 -> 907 in the cache */
   /* search408_0_1_0 -> 1356 in the cache */
   /* search408_0_1 -> 1357 in the cache */
   /* search408_0_2 -> 1350 in the cache */
   /* search408_0 -> 1369 in the cache */
   /* search408_1 -> 1350 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_feq,
      0, 1,
      { 1369, 1350 },
      -1,
   } },

   /* replace408_0_0 -> 907 in the cache */
   /* replace408_0_1 -> 1356 in the cache */
   /* replace408_0 -> 1368 in the cache */
   /* replace408 -> 1381 in the cache */

   /* ('feq', ('fadd', ('b2f', 'a@1'), ('fneg', ('b2f', 'b@1'))), 0.0) => ('ieq', 'a', 'b') */
   /* search409_0_0_0 -> 907 in the cache */
   /* search409_0_0 -> 1351 in the cache */
   /* search409_0_1_0_0 -> 1356 in the cache */
   /* search409_0_1_0 -> 1357 in the cache */
   /* search409_0_1 -> 1364 in the cache */
   /* search409_0 -> 1371 in the cache */
   /* search409_1 -> 1350 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_feq,
      0, 2,
      { 1371, 1350 },
      -1,
   } },

   /* replace409_0 -> 907 in the cache */
   /* replace409_1 -> 1356 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ieq,
      0, 1,
      { 907, 1356 },
      -1,
   } },

   /* ('feq', ('b2f', 'a@1'), ('b2f', 'b@1')) => ('ieq', 'a', 'b') */
   /* search410_0_0 -> 907 in the cache */
   /* search410_0 -> 1351 in the cache */
   /* search410_1_0 -> 1356 in the cache */
   /* search410_1 -> 1357 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_feq,
      0, 1,
      { 1351, 1357 },
      -1,
   } },

   /* replace410_0 -> 907 in the cache */
   /* replace410_1 -> 1356 in the cache */
   /* replace410 -> 1384 in the cache */

   /* ('feq', ('fneg', ('b2f', 'a@1')), ('fneg', ('b2f', 'b@1'))) => ('ieq', 'a', 'b') */
   /* search411_0_0_0 -> 907 in the cache */
   /* search411_0_0 -> 1351 in the cache */
   /* search411_0 -> 1354 in the cache */
   /* search411_1_0_0 -> 1356 in the cache */
   /* search411_1_0 -> 1357 in the cache */
   /* search411_1 -> 1364 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_feq,
      0, 1,
      { 1354, 1364 },
      -1,
   } },

   /* replace411_0 -> 907 in the cache */
   /* replace411_1 -> 1356 in the cache */
   /* replace411 -> 1384 in the cache */

   /* ('flt', ('fneg', ('fadd', ('b2f', 'a@1'), ('b2f', 'b@1'))), 0.0) => ('ior', 'a', 'b') */
   /* search412_0_0_0_0 -> 907 in the cache */
   /* search412_0_0_0 -> 1351 in the cache */
   /* search412_0_0_1_0 -> 1356 in the cache */
   /* search412_0_0_1 -> 1357 in the cache */
   { .expression = {
      { nir_search_value_expression, 0 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fadd,
      0, 1,
      { 1351, 1357 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 0 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fneg,
      -1, 1,
      { 1387 },
      -1,
   } },
   /* search412_1 -> 1350 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_flt,
      -1, 1,
      { 1388, 1350 },
      -1,
   } },

   /* replace412_0 -> 907 in the cache */
   /* replace412_1 -> 1356 in the cache */
   /* replace412 -> 1360 in the cache */

   /* ('flt', 0.0, ('fadd', ('b2f', 'a@1'), ('b2f', 'b@1'))) => ('ior', 'a', 'b') */
   /* search413_0 -> 1350 in the cache */
   /* search413_1_0_0 -> 907 in the cache */
   /* search413_1_0 -> 1351 in the cache */
   /* search413_1_1_0 -> 1356 in the cache */
   /* search413_1_1 -> 1357 in the cache */
   /* search413_1 -> 1387 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_flt,
      -1, 1,
      { 1350, 1387 },
      -1,
   } },

   /* replace413_0 -> 907 in the cache */
   /* replace413_1 -> 1356 in the cache */
   /* replace413 -> 1360 in the cache */

   /* ('fge', ('fneg', ('fadd', ('b2f', 'a@1'), ('b2f', 'b@1'))), 0.0) => ('inot', ('ior', 'a', 'b')) */
   /* search414_0_0_0_0 -> 907 in the cache */
   /* search414_0_0_0 -> 1351 in the cache */
   /* search414_0_0_1_0 -> 1356 in the cache */
   /* search414_0_0_1 -> 1357 in the cache */
   /* search414_0_0 -> 1387 in the cache */
   /* search414_0 -> 1388 in the cache */
   /* search414_1 -> 1350 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fge,
      -1, 1,
      { 1388, 1350 },
      -1,
   } },

   /* replace414_0_0 -> 907 in the cache */
   /* replace414_0_1 -> 1356 in the cache */
   /* replace414_0 -> 1360 in the cache */
   /* replace414 -> 1377 in the cache */

   /* ('fge', 0.0, ('fadd', ('b2f', 'a@1'), ('b2f', 'b@1'))) => ('inot', ('ior', 'a', 'b')) */
   /* search415_0 -> 1350 in the cache */
   /* search415_1_0_0 -> 907 in the cache */
   /* search415_1_0 -> 1351 in the cache */
   /* search415_1_1_0 -> 1356 in the cache */
   /* search415_1_1 -> 1357 in the cache */
   /* search415_1 -> 1387 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fge,
      -1, 1,
      { 1350, 1387 },
      -1,
   } },

   /* replace415_0_0 -> 907 in the cache */
   /* replace415_0_1 -> 1356 in the cache */
   /* replace415_0 -> 1360 in the cache */
   /* replace415 -> 1377 in the cache */

   /* ('flt', 'a', ('fneg', 'a')) => ('flt', 'a', 0.0) */
   /* search416_0 -> 9 in the cache */
   /* search416_1_0 -> 9 in the cache */
   /* search416_1 -> 118 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_flt,
      -1, 0,
      { 9, 118 },
      -1,
   } },

   /* replace416_0 -> 9 in the cache */
   /* replace416_1 -> 8 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_flt,
      -1, 0,
      { 9, 8 },
      -1,
   } },

   /* ('fge', 'a', ('fneg', 'a')) => ('fge', 'a', 0.0) */
   /* search417_0 -> 9 in the cache */
   /* search417_1_0 -> 9 in the cache */
   /* search417_1 -> 118 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fge,
      -1, 0,
      { 9, 118 },
      -1,
   } },

   /* replace417_0 -> 9 in the cache */
   /* replace417_1 -> 8 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fge,
      -1, 0,
      { 9, 8 },
      -1,
   } },

   /* ('flt', ('fmin', 'c', ('fneg', ('fadd', ('b2f', 'a@1'), ('b2f', 'b@1')))), 0.0) => ('ior', ('flt', 'c', 0.0), ('ior', 'a', 'b')) */
   { .variable = {
      { nir_search_value_variable, -1 },
      0, /* c */
      false,
      nir_type_invalid,
      -1,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .variable = {
      { nir_search_value_variable, 1 },
      1, /* a */
      false,
      nir_type_invalid,
      -1,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_search_op_b2f,
      -1, 0,
      { 1398 },
      -1,
   } },
   { .variable = {
      { nir_search_value_variable, 1 },
      2, /* b */
      false,
      nir_type_invalid,
      -1,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_search_op_b2f,
      -1, 0,
      { 1400 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fadd,
      1, 1,
      { 1399, 1401 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fneg,
      -1, 1,
      { 1402 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fmin,
      0, 2,
      { 1397, 1403 },
      -1,
   } },
   /* search418_1 -> 8 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_flt,
      -1, 2,
      { 1404, 8 },
      -1,
   } },

   /* replace418_0_0 -> 1397 in the cache */
   /* replace418_0_1 -> 8 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_flt,
      -1, 0,
      { 1397, 8 },
      -1,
   } },
   /* replace418_1_0 -> 1398 in the cache */
   /* replace418_1_1 -> 1400 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ior,
      1, 1,
      { 1398, 1400 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ior,
      0, 2,
      { 1406, 1407 },
      -1,
   } },

   /* ('~flt', ('fadd', 'a', 'b'), 'a') => ('flt', 'b', 0.0) */
   /* search419_0_0 -> 0 in the cache */
   /* search419_0_1 -> 1 in the cache */
   /* search419_0 -> 299 in the cache */
   /* search419_1 -> 0 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      true,
      false,
      false,
      false,
      false,
      false,
      nir_op_flt,
      -1, 1,
      { 299, 0 },
      -1,
   } },

   /* replace419_0 -> 1 in the cache */
   /* replace419_1 -> 287 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_flt,
      -1, 0,
      { 1, 287 },
      -1,
   } },

   /* ('~fge', ('fadd', 'a', 'b'), 'a') => ('fge', 'b', 0.0) */
   /* search420_0_0 -> 0 in the cache */
   /* search420_0_1 -> 1 in the cache */
   /* search420_0 -> 299 in the cache */
   /* search420_1 -> 0 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      true,
      false,
      false,
      false,
      false,
      false,
      nir_op_fge,
      -1, 1,
      { 299, 0 },
      -1,
   } },

   /* replace420_0 -> 1 in the cache */
   /* replace420_1 -> 287 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fge,
      -1, 0,
      { 1, 287 },
      -1,
   } },

   /* ('~feq', ('fadd', 'a', 'b'), 'a') => ('feq', 'b', 0.0) */
   /* search421_0_0 -> 0 in the cache */
   /* search421_0_1 -> 1 in the cache */
   /* search421_0 -> 245 in the cache */
   /* search421_1 -> 0 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      true,
      false,
      false,
      false,
      false,
      false,
      nir_op_feq,
      0, 2,
      { 245, 0 },
      -1,
   } },

   /* replace421_0 -> 1 in the cache */
   /* replace421_1 -> 287 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_feq,
      0, 1,
      { 1, 287 },
      -1,
   } },

   /* ('~fneu', ('fadd', 'a', 'b'), 'a') => ('fneu', 'b', 0.0) */
   /* search422_0_0 -> 0 in the cache */
   /* search422_0_1 -> 1 in the cache */
   /* search422_0 -> 245 in the cache */
   /* search422_1 -> 0 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      true,
      false,
      false,
      false,
      false,
      false,
      nir_op_fneu,
      0, 2,
      { 245, 0 },
      -1,
   } },

   /* replace422_0 -> 1 in the cache */
   /* replace422_1 -> 287 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fneu,
      0, 1,
      { 1, 287 },
      -1,
   } },

   /* ('~flt', ('fadd(is_used_once)', 'a', '#b'), '#c') => ('flt', 'a', ('fadd', 'c', ('fneg', 'b'))) */
   /* search423_0_0 -> 143 in the cache */
   /* search423_0_1 -> 310 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fadd,
      0, 1,
      { 143, 310 },
      0,
   } },
   /* search423_1 -> 964 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      true,
      false,
      false,
      false,
      false,
      false,
      nir_op_flt,
      -1, 1,
      { 1417, 964 },
      -1,
   } },

   /* replace423_0 -> 143 in the cache */
   /* replace423_1_0 -> 146 in the cache */
   /* replace423_1_1_0 -> 144 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fneg,
      -1, 0,
      { 144 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fadd,
      0, 1,
      { 146, 1419 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_flt,
      -1, 1,
      { 143, 1420 },
      -1,
   } },

   /* ('~flt', ('fneg(is_used_once)', ('fadd(is_used_once)', 'a', '#b')), '#c') => ('flt', ('fneg', ('fadd', 'c', 'b')), 'a') */
   /* search424_0_0_0 -> 143 in the cache */
   /* search424_0_0_1 -> 310 in the cache */
   /* search424_0_0 -> 1417 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fneg,
      -1, 1,
      { 1417 },
      0,
   } },
   /* search424_1 -> 964 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      true,
      false,
      false,
      false,
      false,
      false,
      nir_op_flt,
      -1, 1,
      { 1422, 964 },
      -1,
   } },

   /* replace424_0_0_0 -> 146 in the cache */
   /* replace424_0_0_1 -> 144 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fadd,
      0, 1,
      { 146, 144 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fneg,
      -1, 1,
      { 1424 },
      -1,
   } },
   /* replace424_1 -> 143 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_flt,
      -1, 1,
      { 1425, 143 },
      -1,
   } },

   /* ('~fge', ('fadd(is_used_once)', 'a', '#b'), '#c') => ('fge', 'a', ('fadd', 'c', ('fneg', 'b'))) */
   /* search425_0_0 -> 143 in the cache */
   /* search425_0_1 -> 310 in the cache */
   /* search425_0 -> 1417 in the cache */
   /* search425_1 -> 964 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      true,
      false,
      false,
      false,
      false,
      false,
      nir_op_fge,
      -1, 1,
      { 1417, 964 },
      -1,
   } },

   /* replace425_0 -> 143 in the cache */
   /* replace425_1_0 -> 146 in the cache */
   /* replace425_1_1_0 -> 144 in the cache */
   /* replace425_1_1 -> 1419 in the cache */
   /* replace425_1 -> 1420 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fge,
      -1, 1,
      { 143, 1420 },
      -1,
   } },

   /* ('~fge', ('fneg(is_used_once)', ('fadd(is_used_once)', 'a', '#b')), '#c') => ('fge', ('fneg', ('fadd', 'c', 'b')), 'a') */
   /* search426_0_0_0 -> 143 in the cache */
   /* search426_0_0_1 -> 310 in the cache */
   /* search426_0_0 -> 1417 in the cache */
   /* search426_0 -> 1422 in the cache */
   /* search426_1 -> 964 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      true,
      false,
      false,
      false,
      false,
      false,
      nir_op_fge,
      -1, 1,
      { 1422, 964 },
      -1,
   } },

   /* replace426_0_0_0 -> 146 in the cache */
   /* replace426_0_0_1 -> 144 in the cache */
   /* replace426_0_0 -> 1424 in the cache */
   /* replace426_0 -> 1425 in the cache */
   /* replace426_1 -> 143 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fge,
      -1, 1,
      { 1425, 143 },
      -1,
   } },

   /* ('~feq', ('fadd(is_used_once)', 'a', '#b'), '#c') => ('feq', 'a', ('fadd', 'c', ('fneg', 'b'))) */
   /* search427_0_0 -> 143 in the cache */
   /* search427_0_1 -> 310 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fadd,
      1, 1,
      { 143, 310 },
      0,
   } },
   /* search427_1 -> 964 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      true,
      false,
      false,
      false,
      false,
      false,
      nir_op_feq,
      0, 2,
      { 1431, 964 },
      -1,
   } },

   /* replace427_0 -> 143 in the cache */
   /* replace427_1_0 -> 146 in the cache */
   /* replace427_1_1_0 -> 144 in the cache */
   /* replace427_1_1 -> 1419 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fadd,
      1, 1,
      { 146, 1419 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_feq,
      0, 2,
      { 143, 1433 },
      -1,
   } },

   /* ('~feq', ('fneg(is_used_once)', ('fadd(is_used_once)', 'a', '#b')), '#c') => ('feq', ('fneg', ('fadd', 'c', 'b')), 'a') */
   /* search428_0_0_0 -> 143 in the cache */
   /* search428_0_0_1 -> 310 in the cache */
   /* search428_0_0 -> 1431 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fneg,
      -1, 1,
      { 1431 },
      0,
   } },
   /* search428_1 -> 964 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      true,
      false,
      false,
      false,
      false,
      false,
      nir_op_feq,
      0, 2,
      { 1435, 964 },
      -1,
   } },

   /* replace428_0_0_0 -> 146 in the cache */
   /* replace428_0_0_1 -> 144 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fadd,
      1, 1,
      { 146, 144 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fneg,
      -1, 1,
      { 1437 },
      -1,
   } },
   /* replace428_1 -> 143 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_feq,
      0, 2,
      { 1438, 143 },
      -1,
   } },

   /* ('~fneu', ('fadd(is_used_once)', 'a', '#b'), '#c') => ('fneu', 'a', ('fadd', 'c', ('fneg', 'b'))) */
   /* search429_0_0 -> 143 in the cache */
   /* search429_0_1 -> 310 in the cache */
   /* search429_0 -> 1431 in the cache */
   /* search429_1 -> 964 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      true,
      false,
      false,
      false,
      false,
      false,
      nir_op_fneu,
      0, 2,
      { 1431, 964 },
      -1,
   } },

   /* replace429_0 -> 143 in the cache */
   /* replace429_1_0 -> 146 in the cache */
   /* replace429_1_1_0 -> 144 in the cache */
   /* replace429_1_1 -> 1419 in the cache */
   /* replace429_1 -> 1433 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fneu,
      0, 2,
      { 143, 1433 },
      -1,
   } },

   /* ('~fneu', ('fneg(is_used_once)', ('fadd(is_used_once)', 'a', '#b')), '#c') => ('fneu', ('fneg', ('fadd', 'c', 'b')), 'a') */
   /* search430_0_0_0 -> 143 in the cache */
   /* search430_0_0_1 -> 310 in the cache */
   /* search430_0_0 -> 1431 in the cache */
   /* search430_0 -> 1435 in the cache */
   /* search430_1 -> 964 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      true,
      false,
      false,
      false,
      false,
      false,
      nir_op_fneu,
      0, 2,
      { 1435, 964 },
      -1,
   } },

   /* replace430_0_0_0 -> 146 in the cache */
   /* replace430_0_0_1 -> 144 in the cache */
   /* replace430_0_0 -> 1437 in the cache */
   /* replace430_0 -> 1438 in the cache */
   /* replace430_1 -> 143 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fneu,
      0, 2,
      { 1438, 143 },
      -1,
   } },

   /* ('ieq', ('iadd', 'a', 'b'), 'a') => ('ieq', 'b', 0) */
   /* search431_0_0 -> 0 in the cache */
   /* search431_0_1 -> 1 in the cache */
   /* search431_0 -> 241 in the cache */
   /* search431_1 -> 0 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ieq,
      0, 2,
      { 241, 0 },
      -1,
   } },

   /* replace431_0 -> 1 in the cache */
   /* replace431_1 -> 98 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ieq,
      0, 1,
      { 1, 98 },
      -1,
   } },

   /* ('ine', ('iadd', 'a', 'b'), 'a') => ('ine', 'b', 0) */
   /* search432_0_0 -> 0 in the cache */
   /* search432_0_1 -> 1 in the cache */
   /* search432_0 -> 241 in the cache */
   /* search432_1 -> 0 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ine,
      0, 2,
      { 241, 0 },
      -1,
   } },

   /* replace432_0 -> 1 in the cache */
   /* replace432_1 -> 98 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ine,
      0, 1,
      { 1, 98 },
      -1,
   } },

   /* ('feq', ('b2f', 'a@1'), 0.0) => ('inot', 'a') */
   /* search433_0_0 -> 907 in the cache */
   /* search433_0 -> 1351 in the cache */
   /* search433_1 -> 1350 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_feq,
      0, 1,
      { 1351, 1350 },
      -1,
   } },

   /* replace433_0 -> 907 in the cache */
   /* replace433 -> 1353 in the cache */

   /* ('fge', 0.0, ('b2f', 'a@1')) => ('inot', 'a') */
   /* search434_0 -> 1350 in the cache */
   /* search434_1_0 -> 907 in the cache */
   /* search434_1 -> 1351 in the cache */
   /* search434 -> 1352 in the cache */

   /* replace434_0 -> 907 in the cache */
   /* replace434 -> 1353 in the cache */

   /* ('fneu', ('b2f', 'a@1'), 0.0) => a */
   /* search435_0_0 -> 907 in the cache */
   /* search435_0 -> 1351 in the cache */
   /* search435_1 -> 1350 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fneu,
      0, 1,
      { 1351, 1350 },
      -1,
   } },

   /* replace435 -> 907 in the cache */

   /* ('flt', 0.0, ('b2f', 'a@1')) => a */
   /* search436_0 -> 1350 in the cache */
   /* search436_1_0 -> 907 in the cache */
   /* search436_1 -> 1351 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_flt,
      -1, 0,
      { 1350, 1351 },
      -1,
   } },

   /* replace436 -> 907 in the cache */

   /* ('ieq', ('b2i', 'a@1'), 0) => ('inot', 'a') */
   /* search437_0_0 -> 907 in the cache */
   { .expression = {
      { nir_search_value_expression, 0 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_search_op_b2i,
      -1, 0,
      { 907 },
      -1,
   } },
   { .constant = {
      { nir_search_value_constant, 0 },
      nir_type_int, { 0x0ull /* 0 */ },
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ieq,
      0, 1,
      { 1451, 1452 },
      -1,
   } },

   /* replace437_0 -> 907 in the cache */
   /* replace437 -> 1353 in the cache */

   /* ('ine', ('b2i', 'a@1'), 0) => a */
   /* search438_0_0 -> 907 in the cache */
   /* search438_0 -> 1451 in the cache */
   /* search438_1 -> 1452 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ine,
      0, 1,
      { 1451, 1452 },
      -1,
   } },

   /* replace438 -> 907 in the cache */

   /* ('ieq', 'a@1', False) => ('inot', 'a') */
   /* search439_0 -> 907 in the cache */
   /* search439_1 -> 1271 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ieq,
      0, 1,
      { 907, 1271 },
      -1,
   } },

   /* replace439_0 -> 907 in the cache */
   /* replace439 -> 1353 in the cache */

   /* ('ieq', 'a@1', True) => a */
   /* search440_0 -> 907 in the cache */
   { .constant = {
      { nir_search_value_constant, 1 },
      nir_type_bool, { NIR_TRUE /* True */ },
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ieq,
      0, 1,
      { 907, 1456 },
      -1,
   } },

   /* replace440 -> 907 in the cache */

   /* ('ine', 'a@1', False) => a */
   /* search441_0 -> 907 in the cache */
   /* search441_1 -> 1271 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ine,
      0, 1,
      { 907, 1271 },
      -1,
   } },

   /* replace441 -> 907 in the cache */

   /* ('ine', 'a@1', True) => ('inot', 'a') */
   /* search442_0 -> 907 in the cache */
   /* search442_1 -> 1456 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ine,
      0, 1,
      { 907, 1456 },
      -1,
   } },

   /* replace442_0 -> 907 in the cache */
   /* replace442 -> 1353 in the cache */

   /* ('fneu', ('u2f', 'a'), 0.0) => ('ine', 'a', 0) */
   /* search443_0_0 -> 9 in the cache */
   /* search443_0 -> 123 in the cache */
   /* search443_1 -> 1350 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fneu,
      0, 1,
      { 123, 1350 },
      -1,
   } },

   /* replace443_0 -> 9 in the cache */
   /* replace443_1 -> 73 in the cache */
   /* replace443 -> 1325 in the cache */

   /* ('feq', ('u2f', 'a'), 0.0) => ('ieq', 'a', 0) */
   /* search444_0_0 -> 9 in the cache */
   /* search444_0 -> 123 in the cache */
   /* search444_1 -> 1350 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_feq,
      0, 1,
      { 123, 1350 },
      -1,
   } },

   /* replace444_0 -> 9 in the cache */
   /* replace444_1 -> 73 in the cache */
   /* replace444 -> 1323 in the cache */

   /* ('fge', ('u2f', 'a'), 0.0) => True */
   /* search445_0_0 -> 9 in the cache */
   /* search445_0 -> 123 in the cache */
   /* search445_1 -> 1350 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fge,
      -1, 0,
      { 123, 1350 },
      -1,
   } },

   /* replace445 -> 1456 in the cache */

   /* ('fge', 0.0, ('u2f', 'a')) => ('uge', 0, 'a') */
   /* search446_0 -> 1350 in the cache */
   /* search446_1_0 -> 9 in the cache */
   /* search446_1 -> 123 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fge,
      -1, 0,
      { 1350, 123 },
      -1,
   } },

   /* replace446_0 -> 73 in the cache */
   /* replace446_1 -> 9 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_uge,
      -1, 0,
      { 73, 9 },
      -1,
   } },

   /* ('flt', ('u2f', 'a'), 0.0) => False */
   /* search447_0_0 -> 9 in the cache */
   /* search447_0 -> 123 in the cache */
   /* search447_1 -> 1350 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_flt,
      -1, 0,
      { 123, 1350 },
      -1,
   } },

   /* replace447 -> 1271 in the cache */

   /* ('flt', 0.0, ('u2f', 'a')) => ('ult', 0, 'a') */
   /* search448_0 -> 1350 in the cache */
   /* search448_1_0 -> 9 in the cache */
   /* search448_1 -> 123 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_flt,
      -1, 0,
      { 1350, 123 },
      -1,
   } },

   /* replace448_0 -> 73 in the cache */
   /* replace448_1 -> 9 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ult,
      -1, 0,
      { 73, 9 },
      -1,
   } },

   /* ('fneu', ('i2f', 'a'), 0.0) => ('ine', 'a', 0) */
   /* search449_0_0 -> 9 in the cache */
   { .expression = {
      { nir_search_value_expression, 0 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_search_op_i2f,
      -1, 0,
      { 9 },
      -1,
   } },
   /* search449_1 -> 1350 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fneu,
      0, 1,
      { 1468, 1350 },
      -1,
   } },

   /* replace449_0 -> 9 in the cache */
   /* replace449_1 -> 73 in the cache */
   /* replace449 -> 1325 in the cache */

   /* ('feq', ('i2f', 'a'), 0.0) => ('ieq', 'a', 0) */
   /* search450_0_0 -> 9 in the cache */
   /* search450_0 -> 1468 in the cache */
   /* search450_1 -> 1350 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_feq,
      0, 1,
      { 1468, 1350 },
      -1,
   } },

   /* replace450_0 -> 9 in the cache */
   /* replace450_1 -> 73 in the cache */
   /* replace450 -> 1323 in the cache */

   /* ('fge', ('i2f', 'a'), 0.0) => ('ige', 'a', 0) */
   /* search451_0_0 -> 9 in the cache */
   /* search451_0 -> 1468 in the cache */
   /* search451_1 -> 1350 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fge,
      -1, 0,
      { 1468, 1350 },
      -1,
   } },

   /* replace451_0 -> 9 in the cache */
   /* replace451_1 -> 73 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ige,
      -1, 0,
      { 9, 73 },
      -1,
   } },

   /* ('fge', 0.0, ('i2f', 'a')) => ('ige', 0, 'a') */
   /* search452_0 -> 1350 in the cache */
   /* search452_1_0 -> 9 in the cache */
   /* search452_1 -> 1468 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fge,
      -1, 0,
      { 1350, 1468 },
      -1,
   } },

   /* replace452_0 -> 73 in the cache */
   /* replace452_1 -> 9 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ige,
      -1, 0,
      { 73, 9 },
      -1,
   } },

   /* ('flt', ('i2f', 'a'), 0.0) => ('ilt', 'a', 0) */
   /* search453_0_0 -> 9 in the cache */
   /* search453_0 -> 1468 in the cache */
   /* search453_1 -> 1350 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_flt,
      -1, 0,
      { 1468, 1350 },
      -1,
   } },

   /* replace453_0 -> 9 in the cache */
   /* replace453_1 -> 73 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ilt,
      -1, 0,
      { 9, 73 },
      -1,
   } },

   /* ('flt', 0.0, ('i2f', 'a')) => ('ilt', 0, 'a') */
   /* search454_0 -> 1350 in the cache */
   /* search454_1_0 -> 9 in the cache */
   /* search454_1 -> 1468 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_flt,
      -1, 0,
      { 1350, 1468 },
      -1,
   } },

   /* replace454_0 -> 73 in the cache */
   /* replace454_1 -> 9 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ilt,
      -1, 0,
      { 73, 9 },
      -1,
   } },

   /* ('~flt', 0.0, ('fabs', 'a')) => ('fneu', 'a', 0.0) */
   /* search455_0 -> 8 in the cache */
   /* search455_1_0 -> 9 in the cache */
   /* search455_1 -> 11 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      true,
      false,
      false,
      false,
      false,
      false,
      nir_op_flt,
      -1, 0,
      { 8, 11 },
      -1,
   } },

   /* replace455_0 -> 9 in the cache */
   /* replace455_1 -> 8 in the cache */
   /* replace455 -> 1329 in the cache */

   /* ('~flt', ('fneg', ('fabs', 'a')), 0.0) => ('fneu', 'a', 0.0) */
   /* search456_0_0_0 -> 9 in the cache */
   /* search456_0_0 -> 11 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fneg,
      -1, 0,
      { 11 },
      -1,
   } },
   /* search456_1 -> 8 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      true,
      false,
      false,
      false,
      false,
      false,
      nir_op_flt,
      -1, 0,
      { 1480, 8 },
      -1,
   } },

   /* replace456_0 -> 9 in the cache */
   /* replace456_1 -> 8 in the cache */
   /* replace456 -> 1329 in the cache */

   /* ('fge', 0.0, ('fabs', 'a')) => ('feq', 'a', 0.0) */
   /* search457_0 -> 8 in the cache */
   /* search457_1_0 -> 9 in the cache */
   /* search457_1 -> 11 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fge,
      -1, 0,
      { 8, 11 },
      -1,
   } },

   /* replace457_0 -> 9 in the cache */
   /* replace457_1 -> 8 in the cache */
   /* replace457 -> 1331 in the cache */

   /* ('fge', ('fneg', ('fabs', 'a')), 0.0) => ('feq', 'a', 0.0) */
   /* search458_0_0_0 -> 9 in the cache */
   /* search458_0_0 -> 11 in the cache */
   /* search458_0 -> 1480 in the cache */
   /* search458_1 -> 8 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fge,
      -1, 0,
      { 1480, 8 },
      -1,
   } },

   /* replace458_0 -> 9 in the cache */
   /* replace458_1 -> 8 in the cache */
   /* replace458 -> 1331 in the cache */

   /* ('iand', ('fge', 'a', 0.0), ('fge', 1.0, 'a')) => ('feq', 'a', ('fsat', 'a')) */
   /* search459_0_0 -> 9 in the cache */
   /* search459_0_1 -> 8 in the cache */
   /* search459_0 -> 1396 in the cache */
   /* search459_1_0 -> 273 in the cache */
   /* search459_1_1 -> 9 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fge,
      -1, 0,
      { 273, 9 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_iand,
      0, 1,
      { 1396, 1484 },
      -1,
   } },

   /* replace459_0 -> 9 in the cache */
   /* replace459_1_0 -> 9 in the cache */
   /* replace459_1 -> 249 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_feq,
      0, 1,
      { 9, 249 },
      -1,
   } },

   /* ('fmax', ('b2f(is_used_once)', 'a@1'), ('b2f', 'b@1')) => ('b2f', ('ior', 'a', 'b')) */
   /* search460_0_0 -> 907 in the cache */
   { .expression = {
      { nir_search_value_expression, 0 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_search_op_b2f,
      -1, 0,
      { 907 },
      0,
   } },
   /* search460_1_0 -> 1356 in the cache */
   /* search460_1 -> 1357 in the cache */
   { .expression = {
      { nir_search_value_expression, 0 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fmax,
      0, 1,
      { 1487, 1357 },
      -1,
   } },

   /* replace460_0_0 -> 907 in the cache */
   /* replace460_0_1 -> 1356 in the cache */
   /* replace460_0 -> 1360 in the cache */
   { .expression = {
      { nir_search_value_expression, 0 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_search_op_b2f,
      -1, 1,
      { 1360 },
      -1,
   } },

   /* ('fmax', ('fneg(is_used_once)', ('b2f(is_used_once)', 'a@1')), ('fneg', ('b2f', 'b@1'))) => ('fneg', ('b2f', ('iand', 'a', 'b'))) */
   /* search461_0_0_0 -> 907 in the cache */
   /* search461_0_0 -> 1487 in the cache */
   { .expression = {
      { nir_search_value_expression, 0 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fneg,
      -1, 0,
      { 1487 },
      0,
   } },
   /* search461_1_0_0 -> 1356 in the cache */
   /* search461_1_0 -> 1357 in the cache */
   /* search461_1 -> 1364 in the cache */
   { .expression = {
      { nir_search_value_expression, 0 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fmax,
      0, 1,
      { 1490, 1364 },
      -1,
   } },

   /* replace461_0_0_0 -> 907 in the cache */
   /* replace461_0_0_1 -> 1356 in the cache */
   /* replace461_0_0 -> 1368 in the cache */
   { .expression = {
      { nir_search_value_expression, 0 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_search_op_b2f,
      -1, 1,
      { 1368 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 0 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fneg,
      -1, 1,
      { 1492 },
      -1,
   } },

   /* ('fmin', ('b2f(is_used_once)', 'a@1'), ('b2f', 'b@1')) => ('b2f', ('iand', 'a', 'b')) */
   /* search462_0_0 -> 907 in the cache */
   /* search462_0 -> 1487 in the cache */
   /* search462_1_0 -> 1356 in the cache */
   /* search462_1 -> 1357 in the cache */
   { .expression = {
      { nir_search_value_expression, 0 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fmin,
      0, 1,
      { 1487, 1357 },
      -1,
   } },

   /* replace462_0_0 -> 907 in the cache */
   /* replace462_0_1 -> 1356 in the cache */
   /* replace462_0 -> 1368 in the cache */
   /* replace462 -> 1492 in the cache */

   /* ('fmin', ('fneg(is_used_once)', ('b2f(is_used_once)', 'a@1')), ('fneg', ('b2f', 'b@1'))) => ('fneg', ('b2f', ('ior', 'a', 'b'))) */
   /* search463_0_0_0 -> 907 in the cache */
   /* search463_0_0 -> 1487 in the cache */
   /* search463_0 -> 1490 in the cache */
   /* search463_1_0_0 -> 1356 in the cache */
   /* search463_1_0 -> 1357 in the cache */
   /* search463_1 -> 1364 in the cache */
   { .expression = {
      { nir_search_value_expression, 0 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fmin,
      0, 1,
      { 1490, 1364 },
      -1,
   } },

   /* replace463_0_0_0 -> 907 in the cache */
   /* replace463_0_0_1 -> 1356 in the cache */
   /* replace463_0_0 -> 1360 in the cache */
   /* replace463_0 -> 1489 in the cache */
   { .expression = {
      { nir_search_value_expression, 0 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fneg,
      -1, 1,
      { 1489 },
      -1,
   } },

   /* ('fmin', ('b2f', 'a@1'), '#b') => ('bcsel', 'a', ('fmin', 'b', 1.0), ('fmin', 'b', 0.0)) */
   /* search464_0_0 -> 907 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_search_op_b2f,
      -1, 0,
      { 907 },
      -1,
   } },
   /* search464_1 -> 971 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fmin,
      0, 1,
      { 1497, 971 },
      -1,
   } },

   /* replace464_0 -> 907 in the cache */
   /* replace464_1_0 -> 1 in the cache */
   /* replace464_1_1 -> 297 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fmin,
      0, 1,
      { 1, 297 },
      -1,
   } },
   /* replace464_2_0 -> 1 in the cache */
   /* replace464_2_1 -> 287 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fmin,
      1, 1,
      { 1, 287 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_bcsel,
      -1, 2,
      { 907, 1499, 1500 },
      -1,
   } },

   /* ('flt', ('fadd(is_used_once)', 'a', ('fneg', 'b')), 0.0) => ('flt', 'a', 'b') */
   /* search465_0_0 -> 0 in the cache */
   /* search465_0_1_0 -> 1 in the cache */
   /* search465_0_1 -> 1281 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fadd,
      0, 1,
      { 0, 1281 },
      0,
   } },
   /* search465_1 -> 287 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_flt,
      -1, 1,
      { 1502, 287 },
      -1,
   } },

   /* replace465_0 -> 0 in the cache */
   /* replace465_1 -> 1 in the cache */
   /* replace465 -> 3 in the cache */

   /* ('fge', ('fneg', ('fabs', 'a')), 0.0) => ('feq', 'a', 0.0) */
   /* search466_0_0_0 -> 9 in the cache */
   /* search466_0_0 -> 11 in the cache */
   /* search466_0 -> 1480 in the cache */
   /* search466_1 -> 8 in the cache */
   /* search466 -> 1483 in the cache */

   /* replace466_0 -> 9 in the cache */
   /* replace466_1 -> 8 in the cache */
   /* replace466 -> 1331 in the cache */

   /* ('~bcsel', ('flt', 'b', 'a'), 'b', 'a') => ('fmin', 'a', 'b') */
   /* search467_0_0 -> 1298 in the cache */
   /* search467_0_1 -> 1297 in the cache */
   /* search467_0 -> 1339 in the cache */
   /* search467_1 -> 1298 in the cache */
   /* search467_2 -> 1297 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      true,
      false,
      false,
      false,
      false,
      false,
      nir_op_bcsel,
      -1, 0,
      { 1339, 1298, 1297 },
      -1,
   } },

   /* replace467_0 -> 1297 in the cache */
   /* replace467_1 -> 1298 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fmin,
      0, 1,
      { 1297, 1298 },
      -1,
   } },

   /* ('~bcsel', ('flt', 'a', 'b'), 'b', 'a') => ('fmax', 'a', 'b') */
   /* search468_0_0 -> 0 in the cache */
   /* search468_0_1 -> 1 in the cache */
   /* search468_0 -> 3 in the cache */
   /* search468_1 -> 1 in the cache */
   /* search468_2 -> 0 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      true,
      false,
      false,
      false,
      false,
      false,
      nir_op_bcsel,
      -1, 0,
      { 3, 1, 0 },
      -1,
   } },

   /* replace468_0 -> 0 in the cache */
   /* replace468_1 -> 1 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fmax,
      0, 1,
      { 0, 1 },
      -1,
   } },

   /* ('~bcsel', ('fge', 'a', 'b'), 'b', 'a') => ('fmin', 'a', 'b') */
   /* search469_0_0 -> 0 in the cache */
   /* search469_0_1 -> 1 in the cache */
   /* search469_0 -> 6 in the cache */
   /* search469_1 -> 1 in the cache */
   /* search469_2 -> 0 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      true,
      false,
      false,
      false,
      false,
      false,
      nir_op_bcsel,
      -1, 0,
      { 6, 1, 0 },
      -1,
   } },

   /* replace469_0 -> 0 in the cache */
   /* replace469_1 -> 1 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fmin,
      0, 1,
      { 0, 1 },
      -1,
   } },

   /* ('~bcsel', ('fge', 'b', 'a'), 'b', 'a') => ('fmax', 'a', 'b') */
   /* search470_0_0 -> 1298 in the cache */
   /* search470_0_1 -> 1297 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fge,
      -1, 0,
      { 1298, 1297 },
      -1,
   } },
   /* search470_1 -> 1298 in the cache */
   /* search470_2 -> 1297 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      true,
      false,
      false,
      false,
      false,
      false,
      nir_op_bcsel,
      -1, 0,
      { 1510, 1298, 1297 },
      -1,
   } },

   /* replace470_0 -> 1297 in the cache */
   /* replace470_1 -> 1298 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fmax,
      0, 1,
      { 1297, 1298 },
      -1,
   } },

   /* ('bcsel', ('inot', 'a'), 'b', 'c') => ('bcsel', 'a', 'c', 'b') */
   /* search471_0_0 -> 907 in the cache */
   /* search471_0 -> 1353 in the cache */
   /* search471_1 -> 144 in the cache */
   /* search471_2 -> 146 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_bcsel,
      -1, 0,
      { 1353, 144, 146 },
      -1,
   } },

   /* replace471_0 -> 907 in the cache */
   /* replace471_1 -> 146 in the cache */
   /* replace471_2 -> 144 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_bcsel,
      -1, 0,
      { 907, 146, 144 },
      -1,
   } },

   /* ('bcsel', 'a', ('bcsel', 'a', 'b', 'c'), 'd') => ('bcsel', 'a', 'b', 'd') */
   /* search472_0 -> 907 in the cache */
   /* search472_1_0 -> 907 in the cache */
   /* search472_1_1 -> 167 in the cache */
   /* search472_1_2 -> 169 in the cache */
   { .expression = {
      { nir_search_value_expression, -4 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_bcsel,
      -1, 0,
      { 907, 167, 169 },
      -1,
   } },
   /* search472_2 -> 170 in the cache */
   { .expression = {
      { nir_search_value_expression, -4 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_bcsel,
      -1, 0,
      { 907, 1515, 170 },
      -1,
   } },

   /* replace472_0 -> 907 in the cache */
   /* replace472_1 -> 167 in the cache */
   /* replace472_2 -> 170 in the cache */
   { .expression = {
      { nir_search_value_expression, -4 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_bcsel,
      -1, 0,
      { 907, 167, 170 },
      -1,
   } },

   /* ('bcsel', 'a', 'b', ('bcsel', 'a', 'c', 'd')) => ('bcsel', 'a', 'b', 'd') */
   /* search473_0 -> 907 in the cache */
   /* search473_1 -> 167 in the cache */
   /* search473_2_0 -> 907 in the cache */
   /* search473_2_1 -> 169 in the cache */
   /* search473_2_2 -> 170 in the cache */
   { .expression = {
      { nir_search_value_expression, -4 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_bcsel,
      -1, 0,
      { 907, 169, 170 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -4 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_bcsel,
      -1, 0,
      { 907, 167, 1518 },
      -1,
   } },

   /* replace473_0 -> 907 in the cache */
   /* replace473_1 -> 167 in the cache */
   /* replace473_2 -> 170 in the cache */
   /* replace473 -> 1517 in the cache */

   /* ('bcsel', 'a', ('bcsel', 'b', 'c', 'd'), ('bcsel(is_used_once)', 'b', 'c', 'e')) => ('bcsel', 'b', 'c', ('bcsel', 'a', 'd', 'e')) */
   /* search474_0 -> 907 in the cache */
   /* search474_1_0 -> 1356 in the cache */
   /* search474_1_1 -> 900 in the cache */
   /* search474_1_2 -> 909 in the cache */
   { .expression = {
      { nir_search_value_expression, -5 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_bcsel,
      -1, 0,
      { 1356, 900, 909 },
      -1,
   } },
   /* search474_2_0 -> 1356 in the cache */
   /* search474_2_1 -> 900 in the cache */
   /* search474_2_2 -> 911 in the cache */
   { .expression = {
      { nir_search_value_expression, -5 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_bcsel,
      -1, 0,
      { 1356, 900, 911 },
      0,
   } },
   { .expression = {
      { nir_search_value_expression, -5 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_bcsel,
      -1, 0,
      { 907, 1520, 1521 },
      -1,
   } },

   /* replace474_0 -> 1356 in the cache */
   /* replace474_1 -> 900 in the cache */
   /* replace474_2_0 -> 907 in the cache */
   /* replace474_2_1 -> 909 in the cache */
   /* replace474_2_2 -> 911 in the cache */
   { .expression = {
      { nir_search_value_expression, -5 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_bcsel,
      -1, 0,
      { 907, 909, 911 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -5 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_bcsel,
      -1, 0,
      { 1356, 900, 1523 },
      -1,
   } },

   /* ('bcsel', 'a', ('bcsel(is_used_once)', 'b', 'c', 'd'), ('bcsel', 'b', 'c', 'e')) => ('bcsel', 'b', 'c', ('bcsel', 'a', 'd', 'e')) */
   /* search475_0 -> 907 in the cache */
   /* search475_1_0 -> 1356 in the cache */
   /* search475_1_1 -> 900 in the cache */
   /* search475_1_2 -> 909 in the cache */
   { .expression = {
      { nir_search_value_expression, -5 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_bcsel,
      -1, 0,
      { 1356, 900, 909 },
      0,
   } },
   /* search475_2_0 -> 1356 in the cache */
   /* search475_2_1 -> 900 in the cache */
   /* search475_2_2 -> 911 in the cache */
   { .expression = {
      { nir_search_value_expression, -5 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_bcsel,
      -1, 0,
      { 1356, 900, 911 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -5 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_bcsel,
      -1, 0,
      { 907, 1525, 1526 },
      -1,
   } },

   /* replace475_0 -> 1356 in the cache */
   /* replace475_1 -> 900 in the cache */
   /* replace475_2_0 -> 907 in the cache */
   /* replace475_2_1 -> 909 in the cache */
   /* replace475_2_2 -> 911 in the cache */
   /* replace475_2 -> 1523 in the cache */
   /* replace475 -> 1524 in the cache */

   /* ('bcsel', 'a', ('bcsel', 'b', 'c', 'd'), ('bcsel(is_used_once)', 'b', 'e', 'd')) => ('bcsel', 'b', ('bcsel', 'a', 'c', 'e'), 'd') */
   /* search476_0 -> 907 in the cache */
   /* search476_1_0 -> 1356 in the cache */
   /* search476_1_1 -> 169 in the cache */
   /* search476_1_2 -> 170 in the cache */
   { .expression = {
      { nir_search_value_expression, -4 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_bcsel,
      -1, 0,
      { 1356, 169, 170 },
      -1,
   } },
   /* search476_2_0 -> 1356 in the cache */
   { .variable = {
      { nir_search_value_variable, -4 },
      4, /* e */
      false,
      nir_type_invalid,
      -1,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   /* search476_2_2 -> 170 in the cache */
   { .expression = {
      { nir_search_value_expression, -4 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_bcsel,
      -1, 0,
      { 1356, 1529, 170 },
      0,
   } },
   { .expression = {
      { nir_search_value_expression, -4 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_bcsel,
      -1, 0,
      { 907, 1528, 1530 },
      -1,
   } },

   /* replace476_0 -> 1356 in the cache */
   /* replace476_1_0 -> 907 in the cache */
   /* replace476_1_1 -> 169 in the cache */
   /* replace476_1_2 -> 1529 in the cache */
   { .expression = {
      { nir_search_value_expression, -4 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_bcsel,
      -1, 0,
      { 907, 169, 1529 },
      -1,
   } },
   /* replace476_2 -> 170 in the cache */
   { .expression = {
      { nir_search_value_expression, -4 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_bcsel,
      -1, 0,
      { 1356, 1532, 170 },
      -1,
   } },

   /* ('bcsel', 'a', ('bcsel(is_used_once)', 'b', 'c', 'd'), ('bcsel', 'b', 'e', 'd')) => ('bcsel', 'b', ('bcsel', 'a', 'c', 'e'), 'd') */
   /* search477_0 -> 907 in the cache */
   /* search477_1_0 -> 1356 in the cache */
   /* search477_1_1 -> 169 in the cache */
   /* search477_1_2 -> 170 in the cache */
   { .expression = {
      { nir_search_value_expression, -4 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_bcsel,
      -1, 0,
      { 1356, 169, 170 },
      0,
   } },
   /* search477_2_0 -> 1356 in the cache */
   /* search477_2_1 -> 1529 in the cache */
   /* search477_2_2 -> 170 in the cache */
   { .expression = {
      { nir_search_value_expression, -4 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_bcsel,
      -1, 0,
      { 1356, 1529, 170 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -4 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_bcsel,
      -1, 0,
      { 907, 1534, 1535 },
      -1,
   } },

   /* replace477_0 -> 1356 in the cache */
   /* replace477_1_0 -> 907 in the cache */
   /* replace477_1_1 -> 169 in the cache */
   /* replace477_1_2 -> 1529 in the cache */
   /* replace477_1 -> 1532 in the cache */
   /* replace477_2 -> 170 in the cache */
   /* replace477 -> 1533 in the cache */

   /* ('bcsel', 'a', True, 'b') => ('ior', 'a', 'b') */
   /* search478_0 -> 907 in the cache */
   /* search478_1 -> 1456 in the cache */
   /* search478_2 -> 1356 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_bcsel,
      -1, 0,
      { 907, 1456, 1356 },
      -1,
   } },

   /* replace478_0 -> 907 in the cache */
   /* replace478_1 -> 1356 in the cache */
   /* replace478 -> 1360 in the cache */

   /* ('bcsel', 'a', 'a', 'b') => ('ior', 'a', 'b') */
   /* search479_0 -> 907 in the cache */
   /* search479_1 -> 907 in the cache */
   /* search479_2 -> 1356 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_bcsel,
      -1, 0,
      { 907, 907, 1356 },
      -1,
   } },

   /* replace479_0 -> 907 in the cache */
   /* replace479_1 -> 1356 in the cache */
   /* replace479 -> 1360 in the cache */

   /* ('bcsel', 'a', 'b', False) => ('iand', 'a', 'b') */
   /* search480_0 -> 907 in the cache */
   /* search480_1 -> 1356 in the cache */
   /* search480_2 -> 1271 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_bcsel,
      -1, 0,
      { 907, 1356, 1271 },
      -1,
   } },

   /* replace480_0 -> 907 in the cache */
   /* replace480_1 -> 1356 in the cache */
   /* replace480 -> 1368 in the cache */

   /* ('bcsel', 'a', 'b', 'a') => ('iand', 'a', 'b') */
   /* search481_0 -> 907 in the cache */
   /* search481_1 -> 1356 in the cache */
   /* search481_2 -> 907 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_bcsel,
      -1, 0,
      { 907, 1356, 907 },
      -1,
   } },

   /* replace481_0 -> 907 in the cache */
   /* replace481_1 -> 1356 in the cache */
   /* replace481 -> 1368 in the cache */

   /* ('~fmin', 'a', 'a') => a */
   /* search482_0 -> 9 in the cache */
   /* search482_1 -> 9 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      true,
      false,
      false,
      false,
      false,
      false,
      nir_op_fmin,
      -1, 0,
      { 9, 9 },
      -1,
   } },

   /* replace482 -> 9 in the cache */

   /* ('~fmax', 'a', 'a') => a */
   /* search483_0 -> 9 in the cache */
   /* search483_1 -> 9 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      true,
      false,
      false,
      false,
      false,
      false,
      nir_op_fmax,
      -1, 0,
      { 9, 9 },
      -1,
   } },

   /* replace483 -> 9 in the cache */

   /* ('imin', 'a', 'a') => a */
   /* search484_0 -> 9 in the cache */
   /* search484_1 -> 9 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_imin,
      -1, 0,
      { 9, 9 },
      -1,
   } },

   /* replace484 -> 9 in the cache */

   /* ('imax', 'a', 'a') => a */
   /* search485_0 -> 9 in the cache */
   /* search485_1 -> 9 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_imax,
      -1, 0,
      { 9, 9 },
      -1,
   } },

   /* replace485 -> 9 in the cache */

   /* ('umin', 'a', 'a') => a */
   /* search486_0 -> 9 in the cache */
   /* search486_1 -> 9 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_umin,
      -1, 0,
      { 9, 9 },
      -1,
   } },

   /* replace486 -> 9 in the cache */

   /* ('umin', 'a', 0) => 0 */
   /* search487_0 -> 9 in the cache */
   /* search487_1 -> 73 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_umin,
      0, 1,
      { 9, 73 },
      -1,
   } },

   /* replace487 -> 73 in the cache */

   /* ('umin', 'a', -1) => a */
   /* search488_0 -> 9 in the cache */
   /* search488_1 -> 75 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_umin,
      0, 1,
      { 9, 75 },
      -1,
   } },

   /* replace488 -> 9 in the cache */

   /* ('umax', 'a', 'a') => a */
   /* search489_0 -> 9 in the cache */
   /* search489_1 -> 9 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_umax,
      -1, 0,
      { 9, 9 },
      -1,
   } },

   /* replace489 -> 9 in the cache */

   /* ('umax', 'a', 0) => a */
   /* search490_0 -> 9 in the cache */
   /* search490_1 -> 73 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_umax,
      0, 1,
      { 9, 73 },
      -1,
   } },

   /* replace490 -> 9 in the cache */

   /* ('umax', 'a', -1) => -1 */
   /* search491_0 -> 9 in the cache */
   /* search491_1 -> 75 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_umax,
      0, 1,
      { 9, 75 },
      -1,
   } },

   /* replace491 -> 75 in the cache */

   /* ('fmax', ('fmax', 'a', 'b'), 'b') => ('fmax', 'a', 'b') */
   /* search492_0_0 -> 0 in the cache */
   /* search492_0_1 -> 1 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fmax,
      1, 1,
      { 0, 1 },
      -1,
   } },
   /* search492_1 -> 1 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fmax,
      0, 2,
      { 1551, 1 },
      -1,
   } },

   /* replace492_0 -> 0 in the cache */
   /* replace492_1 -> 1 in the cache */
   /* replace492 -> 1507 in the cache */

   /* ('umax', ('umax', 'a', 'b'), 'b') => ('umax', 'a', 'b') */
   /* search493_0_0 -> 0 in the cache */
   /* search493_0_1 -> 1 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_umax,
      1, 1,
      { 0, 1 },
      -1,
   } },
   /* search493_1 -> 1 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_umax,
      0, 2,
      { 1553, 1 },
      -1,
   } },

   /* replace493_0 -> 0 in the cache */
   /* replace493_1 -> 1 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_umax,
      0, 1,
      { 0, 1 },
      -1,
   } },

   /* ('imax', ('imax', 'a', 'b'), 'b') => ('imax', 'a', 'b') */
   /* search494_0_0 -> 0 in the cache */
   /* search494_0_1 -> 1 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_imax,
      1, 1,
      { 0, 1 },
      -1,
   } },
   /* search494_1 -> 1 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_imax,
      0, 2,
      { 1556, 1 },
      -1,
   } },

   /* replace494_0 -> 0 in the cache */
   /* replace494_1 -> 1 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_imax,
      0, 1,
      { 0, 1 },
      -1,
   } },

   /* ('fmin', ('fmin', 'a', 'b'), 'b') => ('fmin', 'a', 'b') */
   /* search495_0_0 -> 0 in the cache */
   /* search495_0_1 -> 1 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fmin,
      1, 1,
      { 0, 1 },
      -1,
   } },
   /* search495_1 -> 1 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fmin,
      0, 2,
      { 1559, 1 },
      -1,
   } },

   /* replace495_0 -> 0 in the cache */
   /* replace495_1 -> 1 in the cache */
   /* replace495 -> 1509 in the cache */

   /* ('umin', ('umin', 'a', 'b'), 'b') => ('umin', 'a', 'b') */
   /* search496_0_0 -> 0 in the cache */
   /* search496_0_1 -> 1 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_umin,
      1, 1,
      { 0, 1 },
      -1,
   } },
   /* search496_1 -> 1 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_umin,
      0, 2,
      { 1561, 1 },
      -1,
   } },

   /* replace496_0 -> 0 in the cache */
   /* replace496_1 -> 1 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_umin,
      0, 1,
      { 0, 1 },
      -1,
   } },

   /* ('imin', ('imin', 'a', 'b'), 'b') => ('imin', 'a', 'b') */
   /* search497_0_0 -> 0 in the cache */
   /* search497_0_1 -> 1 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_imin,
      1, 1,
      { 0, 1 },
      -1,
   } },
   /* search497_1 -> 1 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_imin,
      0, 2,
      { 1564, 1 },
      -1,
   } },

   /* replace497_0 -> 0 in the cache */
   /* replace497_1 -> 1 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_imin,
      0, 1,
      { 0, 1 },
      -1,
   } },

   /* ('fmax', ('fmax', ('fmax', 'a', 'b'), 'c'), 'a') => ('fmax', ('fmax', 'a', 'b'), 'c') */
   /* search498_0_0_0 -> 143 in the cache */
   /* search498_0_0_1 -> 144 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fmax,
      2, 1,
      { 143, 144 },
      -1,
   } },
   /* search498_0_1 -> 146 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fmax,
      1, 2,
      { 1567, 146 },
      -1,
   } },
   /* search498_1 -> 143 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fmax,
      0, 3,
      { 1568, 143 },
      -1,
   } },

   /* replace498_0_0 -> 143 in the cache */
   /* replace498_0_1 -> 144 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fmax,
      1, 1,
      { 143, 144 },
      -1,
   } },
   /* replace498_1 -> 146 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fmax,
      0, 2,
      { 1570, 146 },
      -1,
   } },

   /* ('umax', ('umax', ('umax', 'a', 'b'), 'c'), 'a') => ('umax', ('umax', 'a', 'b'), 'c') */
   /* search499_0_0_0 -> 143 in the cache */
   /* search499_0_0_1 -> 144 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_umax,
      2, 1,
      { 143, 144 },
      -1,
   } },
   /* search499_0_1 -> 146 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_umax,
      1, 2,
      { 1572, 146 },
      -1,
   } },
   /* search499_1 -> 143 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_umax,
      0, 3,
      { 1573, 143 },
      -1,
   } },

   /* replace499_0_0 -> 143 in the cache */
   /* replace499_0_1 -> 144 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_umax,
      1, 1,
      { 143, 144 },
      -1,
   } },
   /* replace499_1 -> 146 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_umax,
      0, 2,
      { 1575, 146 },
      -1,
   } },

   /* ('imax', ('imax', ('imax', 'a', 'b'), 'c'), 'a') => ('imax', ('imax', 'a', 'b'), 'c') */
   /* search500_0_0_0 -> 143 in the cache */
   /* search500_0_0_1 -> 144 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_imax,
      2, 1,
      { 143, 144 },
      -1,
   } },
   /* search500_0_1 -> 146 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_imax,
      1, 2,
      { 1577, 146 },
      -1,
   } },
   /* search500_1 -> 143 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_imax,
      0, 3,
      { 1578, 143 },
      -1,
   } },

   /* replace500_0_0 -> 143 in the cache */
   /* replace500_0_1 -> 144 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_imax,
      1, 1,
      { 143, 144 },
      -1,
   } },
   /* replace500_1 -> 146 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_imax,
      0, 2,
      { 1580, 146 },
      -1,
   } },

   /* ('fmin', ('fmin', ('fmin', 'a', 'b'), 'c'), 'a') => ('fmin', ('fmin', 'a', 'b'), 'c') */
   /* search501_0_0_0 -> 143 in the cache */
   /* search501_0_0_1 -> 144 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fmin,
      2, 1,
      { 143, 144 },
      -1,
   } },
   /* search501_0_1 -> 146 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fmin,
      1, 2,
      { 1582, 146 },
      -1,
   } },
   /* search501_1 -> 143 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fmin,
      0, 3,
      { 1583, 143 },
      -1,
   } },

   /* replace501_0_0 -> 143 in the cache */
   /* replace501_0_1 -> 144 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fmin,
      1, 1,
      { 143, 144 },
      -1,
   } },
   /* replace501_1 -> 146 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fmin,
      0, 2,
      { 1585, 146 },
      -1,
   } },

   /* ('umin', ('umin', ('umin', 'a', 'b'), 'c'), 'a') => ('umin', ('umin', 'a', 'b'), 'c') */
   /* search502_0_0_0 -> 143 in the cache */
   /* search502_0_0_1 -> 144 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_umin,
      2, 1,
      { 143, 144 },
      -1,
   } },
   /* search502_0_1 -> 146 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_umin,
      1, 2,
      { 1587, 146 },
      -1,
   } },
   /* search502_1 -> 143 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_umin,
      0, 3,
      { 1588, 143 },
      -1,
   } },

   /* replace502_0_0 -> 143 in the cache */
   /* replace502_0_1 -> 144 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_umin,
      1, 1,
      { 143, 144 },
      -1,
   } },
   /* replace502_1 -> 146 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_umin,
      0, 2,
      { 1590, 146 },
      -1,
   } },

   /* ('imin', ('imin', ('imin', 'a', 'b'), 'c'), 'a') => ('imin', ('imin', 'a', 'b'), 'c') */
   /* search503_0_0_0 -> 143 in the cache */
   /* search503_0_0_1 -> 144 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_imin,
      2, 1,
      { 143, 144 },
      -1,
   } },
   /* search503_0_1 -> 146 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_imin,
      1, 2,
      { 1592, 146 },
      -1,
   } },
   /* search503_1 -> 143 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_imin,
      0, 3,
      { 1593, 143 },
      -1,
   } },

   /* replace503_0_0 -> 143 in the cache */
   /* replace503_0_1 -> 144 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_imin,
      1, 1,
      { 143, 144 },
      -1,
   } },
   /* replace503_1 -> 146 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_imin,
      0, 2,
      { 1595, 146 },
      -1,
   } },

   /* ('ieq', ('b2i8', 'a@1'), ('b2i8', 'b@1')) => ('ieq', 'a', 'b') */
   /* search504_0_0 -> 907 in the cache */
   { .expression = {
      { nir_search_value_expression, 8 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_b2i8,
      -1, 0,
      { 907 },
      -1,
   } },
   /* search504_1_0 -> 1356 in the cache */
   { .expression = {
      { nir_search_value_expression, 8 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_b2i8,
      -1, 0,
      { 1356 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ieq,
      0, 1,
      { 1597, 1598 },
      -1,
   } },

   /* replace504_0 -> 907 in the cache */
   /* replace504_1 -> 1356 in the cache */
   /* replace504 -> 1384 in the cache */

   /* ('ine', ('b2i8', 'a@1'), ('b2i8', 'b@1')) => ('ine', 'a', 'b') */
   /* search505_0_0 -> 907 in the cache */
   /* search505_0 -> 1597 in the cache */
   /* search505_1_0 -> 1356 in the cache */
   /* search505_1 -> 1598 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ine,
      0, 1,
      { 1597, 1598 },
      -1,
   } },

   /* replace505_0 -> 907 in the cache */
   /* replace505_1 -> 1356 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ine,
      0, 1,
      { 907, 1356 },
      -1,
   } },

   /* ('ieq', ('b2i16', 'a@1'), ('b2i16', 'b@1')) => ('ieq', 'a', 'b') */
   /* search506_0_0 -> 907 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_b2i16,
      -1, 0,
      { 907 },
      -1,
   } },
   /* search506_1_0 -> 1356 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_b2i16,
      -1, 0,
      { 1356 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ieq,
      0, 1,
      { 1602, 1603 },
      -1,
   } },

   /* replace506_0 -> 907 in the cache */
   /* replace506_1 -> 1356 in the cache */
   /* replace506 -> 1384 in the cache */

   /* ('ine', ('b2i16', 'a@1'), ('b2i16', 'b@1')) => ('ine', 'a', 'b') */
   /* search507_0_0 -> 907 in the cache */
   /* search507_0 -> 1602 in the cache */
   /* search507_1_0 -> 1356 in the cache */
   /* search507_1 -> 1603 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ine,
      0, 1,
      { 1602, 1603 },
      -1,
   } },

   /* replace507_0 -> 907 in the cache */
   /* replace507_1 -> 1356 in the cache */
   /* replace507 -> 1601 in the cache */

   /* ('ieq', ('b2i32', 'a@1'), ('b2i32', 'b@1')) => ('ieq', 'a', 'b') */
   /* search508_0_0 -> 907 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_b2i32,
      -1, 0,
      { 907 },
      -1,
   } },
   /* search508_1_0 -> 1356 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_b2i32,
      -1, 0,
      { 1356 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ieq,
      0, 1,
      { 1606, 1607 },
      -1,
   } },

   /* replace508_0 -> 907 in the cache */
   /* replace508_1 -> 1356 in the cache */
   /* replace508 -> 1384 in the cache */

   /* ('ine', ('b2i32', 'a@1'), ('b2i32', 'b@1')) => ('ine', 'a', 'b') */
   /* search509_0_0 -> 907 in the cache */
   /* search509_0 -> 1606 in the cache */
   /* search509_1_0 -> 1356 in the cache */
   /* search509_1 -> 1607 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ine,
      0, 1,
      { 1606, 1607 },
      -1,
   } },

   /* replace509_0 -> 907 in the cache */
   /* replace509_1 -> 1356 in the cache */
   /* replace509 -> 1601 in the cache */

   /* ('ieq', ('b2i64', 'a@1'), ('b2i64', 'b@1')) => ('ieq', 'a', 'b') */
   /* search510_0_0 -> 907 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_b2i64,
      -1, 0,
      { 907 },
      -1,
   } },
   /* search510_1_0 -> 1356 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_b2i64,
      -1, 0,
      { 1356 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ieq,
      0, 1,
      { 1610, 1611 },
      -1,
   } },

   /* replace510_0 -> 907 in the cache */
   /* replace510_1 -> 1356 in the cache */
   /* replace510 -> 1384 in the cache */

   /* ('ine', ('b2i64', 'a@1'), ('b2i64', 'b@1')) => ('ine', 'a', 'b') */
   /* search511_0_0 -> 907 in the cache */
   /* search511_0 -> 1610 in the cache */
   /* search511_1_0 -> 1356 in the cache */
   /* search511_1 -> 1611 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ine,
      0, 1,
      { 1610, 1611 },
      -1,
   } },

   /* replace511_0 -> 907 in the cache */
   /* replace511_1 -> 1356 in the cache */
   /* replace511 -> 1601 in the cache */

   /* ('feq', ('b2f16', 'a@1'), ('b2f16', 'b@1')) => ('ieq', 'a', 'b') */
   /* search512_0_0 -> 907 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_b2f16,
      -1, 0,
      { 907 },
      -1,
   } },
   /* search512_1_0 -> 1356 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_b2f16,
      -1, 0,
      { 1356 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_feq,
      0, 1,
      { 1614, 1615 },
      -1,
   } },

   /* replace512_0 -> 907 in the cache */
   /* replace512_1 -> 1356 in the cache */
   /* replace512 -> 1384 in the cache */

   /* ('fneu', ('b2f16', 'a@1'), ('b2f16', 'b@1')) => ('ine', 'a', 'b') */
   /* search513_0_0 -> 907 in the cache */
   /* search513_0 -> 1614 in the cache */
   /* search513_1_0 -> 1356 in the cache */
   /* search513_1 -> 1615 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fneu,
      0, 1,
      { 1614, 1615 },
      -1,
   } },

   /* replace513_0 -> 907 in the cache */
   /* replace513_1 -> 1356 in the cache */
   /* replace513 -> 1601 in the cache */

   /* ('feq', ('b2f32', 'a@1'), ('b2f32', 'b@1')) => ('ieq', 'a', 'b') */
   /* search514_0_0 -> 907 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_b2f32,
      -1, 0,
      { 907 },
      -1,
   } },
   /* search514_1_0 -> 1356 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_b2f32,
      -1, 0,
      { 1356 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_feq,
      0, 1,
      { 1618, 1619 },
      -1,
   } },

   /* replace514_0 -> 907 in the cache */
   /* replace514_1 -> 1356 in the cache */
   /* replace514 -> 1384 in the cache */

   /* ('fneu', ('b2f32', 'a@1'), ('b2f32', 'b@1')) => ('ine', 'a', 'b') */
   /* search515_0_0 -> 907 in the cache */
   /* search515_0 -> 1618 in the cache */
   /* search515_1_0 -> 1356 in the cache */
   /* search515_1 -> 1619 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fneu,
      0, 1,
      { 1618, 1619 },
      -1,
   } },

   /* replace515_0 -> 907 in the cache */
   /* replace515_1 -> 1356 in the cache */
   /* replace515 -> 1601 in the cache */

   /* ('feq', ('b2f64', 'a@1'), ('b2f64', 'b@1')) => ('ieq', 'a', 'b') */
   /* search516_0_0 -> 907 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_b2f64,
      -1, 0,
      { 907 },
      -1,
   } },
   /* search516_1_0 -> 1356 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_b2f64,
      -1, 0,
      { 1356 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_feq,
      0, 1,
      { 1622, 1623 },
      -1,
   } },

   /* replace516_0 -> 907 in the cache */
   /* replace516_1 -> 1356 in the cache */
   /* replace516 -> 1384 in the cache */

   /* ('fneu', ('b2f64', 'a@1'), ('b2f64', 'b@1')) => ('ine', 'a', 'b') */
   /* search517_0_0 -> 907 in the cache */
   /* search517_0 -> 1622 in the cache */
   /* search517_1_0 -> 1356 in the cache */
   /* search517_1 -> 1623 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fneu,
      0, 1,
      { 1622, 1623 },
      -1,
   } },

   /* replace517_0 -> 907 in the cache */
   /* replace517_1 -> 1356 in the cache */
   /* replace517 -> 1601 in the cache */

   /* ('iand@8', 'a', ('inot', ('ishr', 'a', 7))) => ('imax', 'a', 0) */
   /* search518_0 -> 19 in the cache */
   /* search518_1_0_0 -> 19 in the cache */
   /* search518_1_0_1 -> 22 in the cache */
   { .expression = {
      { nir_search_value_expression, 8 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ishr,
      -1, 0,
      { 19, 22 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 8 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_inot,
      -1, 0,
      { 1626 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 8 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_iand,
      0, 1,
      { 19, 1627 },
      -1,
   } },

   /* replace518_0 -> 19 in the cache */
   /* replace518_1 -> 985 in the cache */
   { .expression = {
      { nir_search_value_expression, 8 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_imax,
      0, 1,
      { 19, 985 },
      -1,
   } },

   /* ('ieq', ('iand', 'a@8', 128), 0) => ('ige', 'a', 0) */
   /* search519_0_0 -> 19 in the cache */
   /* search519_0_1 -> 20 in the cache */
   { .expression = {
      { nir_search_value_expression, 8 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_iand,
      1, 1,
      { 19, 20 },
      -1,
   } },
   /* search519_1 -> 985 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ieq,
      0, 2,
      { 1630, 985 },
      -1,
   } },

   /* replace519_0 -> 19 in the cache */
   /* replace519_1 -> 985 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ige,
      -1, 0,
      { 19, 985 },
      -1,
   } },

   /* ('ine', ('iand', 'a@8', 128), 128) => ('ige', 'a', 0) */
   /* search520_0_0 -> 19 in the cache */
   /* search520_0_1 -> 20 in the cache */
   /* search520_0 -> 1630 in the cache */
   /* search520_1 -> 20 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ine,
      0, 2,
      { 1630, 20 },
      -1,
   } },

   /* replace520_0 -> 19 in the cache */
   /* replace520_1 -> 985 in the cache */
   /* replace520 -> 1632 in the cache */

   /* ('ine', ('iand', 'a@8', 128), 0) => ('ilt', 'a', 0) */
   /* search521_0_0 -> 19 in the cache */
   /* search521_0_1 -> 20 in the cache */
   /* search521_0 -> 1630 in the cache */
   /* search521_1 -> 985 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ine,
      0, 2,
      { 1630, 985 },
      -1,
   } },

   /* replace521_0 -> 19 in the cache */
   /* replace521_1 -> 985 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ilt,
      -1, 0,
      { 19, 985 },
      -1,
   } },

   /* ('ieq', ('iand', 'a@8', 128), 128) => ('ilt', 'a', 0) */
   /* search522_0_0 -> 19 in the cache */
   /* search522_0_1 -> 20 in the cache */
   /* search522_0 -> 1630 in the cache */
   /* search522_1 -> 20 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ieq,
      0, 2,
      { 1630, 20 },
      -1,
   } },

   /* replace522_0 -> 19 in the cache */
   /* replace522_1 -> 985 in the cache */
   /* replace522 -> 1635 in the cache */

   /* ('ine', ('ushr', 'a@8', 7), 0) => ('ilt', 'a', 0) */
   /* search523_0_0 -> 19 in the cache */
   /* search523_0_1 -> 22 in the cache */
   { .expression = {
      { nir_search_value_expression, 8 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ushr,
      -1, 0,
      { 19, 22 },
      -1,
   } },
   /* search523_1 -> 985 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ine,
      0, 1,
      { 1637, 985 },
      -1,
   } },

   /* replace523_0 -> 19 in the cache */
   /* replace523_1 -> 985 in the cache */
   /* replace523 -> 1635 in the cache */

   /* ('ieq', ('ushr', 'a@8', 7), 0) => ('ige', 'a', 0) */
   /* search524_0_0 -> 19 in the cache */
   /* search524_0_1 -> 22 in the cache */
   /* search524_0 -> 1637 in the cache */
   /* search524_1 -> 985 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ieq,
      0, 1,
      { 1637, 985 },
      -1,
   } },

   /* replace524_0 -> 19 in the cache */
   /* replace524_1 -> 985 in the cache */
   /* replace524 -> 1632 in the cache */

   /* ('ieq', ('ushr', 'a@8', 7), 1) => ('ilt', 'a', 0) */
   /* search525_0_0 -> 19 in the cache */
   /* search525_0_1 -> 22 in the cache */
   /* search525_0 -> 1637 in the cache */
   { .constant = {
      { nir_search_value_constant, 8 },
      nir_type_int, { 0x1ull /* 1 */ },
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ieq,
      0, 1,
      { 1637, 1640 },
      -1,
   } },

   /* replace525_0 -> 19 in the cache */
   /* replace525_1 -> 985 in the cache */
   /* replace525 -> 1635 in the cache */

   /* ('ine', ('ushr', 'a@8', 7), 1) => ('ige', 'a', 0) */
   /* search526_0_0 -> 19 in the cache */
   /* search526_0_1 -> 22 in the cache */
   /* search526_0 -> 1637 in the cache */
   /* search526_1 -> 1640 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ine,
      0, 1,
      { 1637, 1640 },
      -1,
   } },

   /* replace526_0 -> 19 in the cache */
   /* replace526_1 -> 985 in the cache */
   /* replace526 -> 1632 in the cache */

   /* ('ine', ('ishr', 'a@8', 7), 0) => ('ilt', 'a', 0) */
   /* search527_0_0 -> 19 in the cache */
   /* search527_0_1 -> 22 in the cache */
   /* search527_0 -> 1626 in the cache */
   /* search527_1 -> 985 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ine,
      0, 1,
      { 1626, 985 },
      -1,
   } },

   /* replace527_0 -> 19 in the cache */
   /* replace527_1 -> 985 in the cache */
   /* replace527 -> 1635 in the cache */

   /* ('ieq', ('ishr', 'a@8', 7), 0) => ('ige', 'a', 0) */
   /* search528_0_0 -> 19 in the cache */
   /* search528_0_1 -> 22 in the cache */
   /* search528_0 -> 1626 in the cache */
   /* search528_1 -> 985 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ieq,
      0, 1,
      { 1626, 985 },
      -1,
   } },

   /* replace528_0 -> 19 in the cache */
   /* replace528_1 -> 985 in the cache */
   /* replace528 -> 1632 in the cache */

   /* ('ieq', ('ishr', 'a@8', 7), -1) => ('ilt', 'a', 0) */
   /* search529_0_0 -> 19 in the cache */
   /* search529_0_1 -> 22 in the cache */
   /* search529_0 -> 1626 in the cache */
   { .constant = {
      { nir_search_value_constant, 8 },
      nir_type_int, { 0xffffffffffffffffull /* -1 */ },
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ieq,
      0, 1,
      { 1626, 1645 },
      -1,
   } },

   /* replace529_0 -> 19 in the cache */
   /* replace529_1 -> 985 in the cache */
   /* replace529 -> 1635 in the cache */

   /* ('ine', ('ishr', 'a@8', 7), -1) => ('ige', 'a', 0) */
   /* search530_0_0 -> 19 in the cache */
   /* search530_0_1 -> 22 in the cache */
   /* search530_0 -> 1626 in the cache */
   /* search530_1 -> 1645 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ine,
      0, 1,
      { 1626, 1645 },
      -1,
   } },

   /* replace530_0 -> 19 in the cache */
   /* replace530_1 -> 985 in the cache */
   /* replace530 -> 1632 in the cache */

   /* ('iand@16', 'a', ('inot', ('ishr', 'a', 15))) => ('imax', 'a', 0) */
   /* search531_0 -> 24 in the cache */
   /* search531_1_0_0 -> 24 in the cache */
   /* search531_1_0_1 -> 27 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ishr,
      -1, 0,
      { 24, 27 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_inot,
      -1, 0,
      { 1648 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_iand,
      0, 1,
      { 24, 1649 },
      -1,
   } },

   /* replace531_0 -> 24 in the cache */
   /* replace531_1 -> 1006 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_imax,
      0, 1,
      { 24, 1006 },
      -1,
   } },

   /* ('ieq', ('iand', 'a@16', 32768), 0) => ('ige', 'a', 0) */
   /* search532_0_0 -> 24 in the cache */
   /* search532_0_1 -> 25 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_iand,
      1, 1,
      { 24, 25 },
      -1,
   } },
   /* search532_1 -> 1006 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ieq,
      0, 2,
      { 1652, 1006 },
      -1,
   } },

   /* replace532_0 -> 24 in the cache */
   /* replace532_1 -> 1006 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ige,
      -1, 0,
      { 24, 1006 },
      -1,
   } },

   /* ('ine', ('iand', 'a@16', 32768), 32768) => ('ige', 'a', 0) */
   /* search533_0_0 -> 24 in the cache */
   /* search533_0_1 -> 25 in the cache */
   /* search533_0 -> 1652 in the cache */
   /* search533_1 -> 25 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ine,
      0, 2,
      { 1652, 25 },
      -1,
   } },

   /* replace533_0 -> 24 in the cache */
   /* replace533_1 -> 1006 in the cache */
   /* replace533 -> 1654 in the cache */

   /* ('ine', ('iand', 'a@16', 32768), 0) => ('ilt', 'a', 0) */
   /* search534_0_0 -> 24 in the cache */
   /* search534_0_1 -> 25 in the cache */
   /* search534_0 -> 1652 in the cache */
   /* search534_1 -> 1006 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ine,
      0, 2,
      { 1652, 1006 },
      -1,
   } },

   /* replace534_0 -> 24 in the cache */
   /* replace534_1 -> 1006 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ilt,
      -1, 0,
      { 24, 1006 },
      -1,
   } },

   /* ('ieq', ('iand', 'a@16', 32768), 32768) => ('ilt', 'a', 0) */
   /* search535_0_0 -> 24 in the cache */
   /* search535_0_1 -> 25 in the cache */
   /* search535_0 -> 1652 in the cache */
   /* search535_1 -> 25 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ieq,
      0, 2,
      { 1652, 25 },
      -1,
   } },

   /* replace535_0 -> 24 in the cache */
   /* replace535_1 -> 1006 in the cache */
   /* replace535 -> 1657 in the cache */

   /* ('ine', ('ushr', 'a@16', 15), 0) => ('ilt', 'a', 0) */
   /* search536_0_0 -> 24 in the cache */
   /* search536_0_1 -> 27 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ushr,
      -1, 0,
      { 24, 27 },
      -1,
   } },
   /* search536_1 -> 1006 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ine,
      0, 1,
      { 1659, 1006 },
      -1,
   } },

   /* replace536_0 -> 24 in the cache */
   /* replace536_1 -> 1006 in the cache */
   /* replace536 -> 1657 in the cache */

   /* ('ieq', ('ushr', 'a@16', 15), 0) => ('ige', 'a', 0) */
   /* search537_0_0 -> 24 in the cache */
   /* search537_0_1 -> 27 in the cache */
   /* search537_0 -> 1659 in the cache */
   /* search537_1 -> 1006 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ieq,
      0, 1,
      { 1659, 1006 },
      -1,
   } },

   /* replace537_0 -> 24 in the cache */
   /* replace537_1 -> 1006 in the cache */
   /* replace537 -> 1654 in the cache */

   /* ('ieq', ('ushr', 'a@16', 15), 1) => ('ilt', 'a', 0) */
   /* search538_0_0 -> 24 in the cache */
   /* search538_0_1 -> 27 in the cache */
   /* search538_0 -> 1659 in the cache */
   { .constant = {
      { nir_search_value_constant, 16 },
      nir_type_int, { 0x1ull /* 1 */ },
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ieq,
      0, 1,
      { 1659, 1662 },
      -1,
   } },

   /* replace538_0 -> 24 in the cache */
   /* replace538_1 -> 1006 in the cache */
   /* replace538 -> 1657 in the cache */

   /* ('ine', ('ushr', 'a@16', 15), 1) => ('ige', 'a', 0) */
   /* search539_0_0 -> 24 in the cache */
   /* search539_0_1 -> 27 in the cache */
   /* search539_0 -> 1659 in the cache */
   /* search539_1 -> 1662 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ine,
      0, 1,
      { 1659, 1662 },
      -1,
   } },

   /* replace539_0 -> 24 in the cache */
   /* replace539_1 -> 1006 in the cache */
   /* replace539 -> 1654 in the cache */

   /* ('ine', ('ishr', 'a@16', 15), 0) => ('ilt', 'a', 0) */
   /* search540_0_0 -> 24 in the cache */
   /* search540_0_1 -> 27 in the cache */
   /* search540_0 -> 1648 in the cache */
   /* search540_1 -> 1006 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ine,
      0, 1,
      { 1648, 1006 },
      -1,
   } },

   /* replace540_0 -> 24 in the cache */
   /* replace540_1 -> 1006 in the cache */
   /* replace540 -> 1657 in the cache */

   /* ('ieq', ('ishr', 'a@16', 15), 0) => ('ige', 'a', 0) */
   /* search541_0_0 -> 24 in the cache */
   /* search541_0_1 -> 27 in the cache */
   /* search541_0 -> 1648 in the cache */
   /* search541_1 -> 1006 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ieq,
      0, 1,
      { 1648, 1006 },
      -1,
   } },

   /* replace541_0 -> 24 in the cache */
   /* replace541_1 -> 1006 in the cache */
   /* replace541 -> 1654 in the cache */

   /* ('ieq', ('ishr', 'a@16', 15), -1) => ('ilt', 'a', 0) */
   /* search542_0_0 -> 24 in the cache */
   /* search542_0_1 -> 27 in the cache */
   /* search542_0 -> 1648 in the cache */
   { .constant = {
      { nir_search_value_constant, 16 },
      nir_type_int, { 0xffffffffffffffffull /* -1 */ },
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ieq,
      0, 1,
      { 1648, 1667 },
      -1,
   } },

   /* replace542_0 -> 24 in the cache */
   /* replace542_1 -> 1006 in the cache */
   /* replace542 -> 1657 in the cache */

   /* ('ine', ('ishr', 'a@16', 15), -1) => ('ige', 'a', 0) */
   /* search543_0_0 -> 24 in the cache */
   /* search543_0_1 -> 27 in the cache */
   /* search543_0 -> 1648 in the cache */
   /* search543_1 -> 1667 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ine,
      0, 1,
      { 1648, 1667 },
      -1,
   } },

   /* replace543_0 -> 24 in the cache */
   /* replace543_1 -> 1006 in the cache */
   /* replace543 -> 1654 in the cache */

   /* ('iand@32', 'a', ('inot', ('ishr', 'a', 31))) => ('imax', 'a', 0) */
   /* search544_0 -> 29 in the cache */
   /* search544_1_0_0 -> 29 in the cache */
   /* search544_1_0_1 -> 32 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ishr,
      -1, 0,
      { 29, 32 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_inot,
      -1, 0,
      { 1670 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_iand,
      0, 1,
      { 29, 1671 },
      -1,
   } },

   /* replace544_0 -> 29 in the cache */
   /* replace544_1 -> 139 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_imax,
      0, 1,
      { 29, 139 },
      -1,
   } },

   /* ('ieq', ('iand', 'a@32', 2147483648), 0) => ('ige', 'a', 0) */
   /* search545_0_0 -> 29 in the cache */
   /* search545_0_1 -> 30 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_iand,
      1, 1,
      { 29, 30 },
      -1,
   } },
   /* search545_1 -> 139 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ieq,
      0, 2,
      { 1674, 139 },
      -1,
   } },

   /* replace545_0 -> 29 in the cache */
   /* replace545_1 -> 139 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ige,
      -1, 0,
      { 29, 139 },
      -1,
   } },

   /* ('ine', ('iand', 'a@32', 2147483648), 2147483648) => ('ige', 'a', 0) */
   /* search546_0_0 -> 29 in the cache */
   /* search546_0_1 -> 30 in the cache */
   /* search546_0 -> 1674 in the cache */
   /* search546_1 -> 30 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ine,
      0, 2,
      { 1674, 30 },
      -1,
   } },

   /* replace546_0 -> 29 in the cache */
   /* replace546_1 -> 139 in the cache */
   /* replace546 -> 1676 in the cache */

   /* ('ine', ('iand', 'a@32', 2147483648), 0) => ('ilt', 'a', 0) */
   /* search547_0_0 -> 29 in the cache */
   /* search547_0_1 -> 30 in the cache */
   /* search547_0 -> 1674 in the cache */
   /* search547_1 -> 139 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ine,
      0, 2,
      { 1674, 139 },
      -1,
   } },

   /* replace547_0 -> 29 in the cache */
   /* replace547_1 -> 139 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ilt,
      -1, 0,
      { 29, 139 },
      -1,
   } },

   /* ('ieq', ('iand', 'a@32', 2147483648), 2147483648) => ('ilt', 'a', 0) */
   /* search548_0_0 -> 29 in the cache */
   /* search548_0_1 -> 30 in the cache */
   /* search548_0 -> 1674 in the cache */
   /* search548_1 -> 30 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ieq,
      0, 2,
      { 1674, 30 },
      -1,
   } },

   /* replace548_0 -> 29 in the cache */
   /* replace548_1 -> 139 in the cache */
   /* replace548 -> 1679 in the cache */

   /* ('ine', ('ushr', 'a@32', 31), 0) => ('ilt', 'a', 0) */
   /* search549_0_0 -> 29 in the cache */
   /* search549_0_1 -> 32 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ushr,
      -1, 0,
      { 29, 32 },
      -1,
   } },
   /* search549_1 -> 139 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ine,
      0, 1,
      { 1681, 139 },
      -1,
   } },

   /* replace549_0 -> 29 in the cache */
   /* replace549_1 -> 139 in the cache */
   /* replace549 -> 1679 in the cache */

   /* ('ieq', ('ushr', 'a@32', 31), 0) => ('ige', 'a', 0) */
   /* search550_0_0 -> 29 in the cache */
   /* search550_0_1 -> 32 in the cache */
   /* search550_0 -> 1681 in the cache */
   /* search550_1 -> 139 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ieq,
      0, 1,
      { 1681, 139 },
      -1,
   } },

   /* replace550_0 -> 29 in the cache */
   /* replace550_1 -> 139 in the cache */
   /* replace550 -> 1676 in the cache */

   /* ('ieq', ('ushr', 'a@32', 31), 1) => ('ilt', 'a', 0) */
   /* search551_0_0 -> 29 in the cache */
   /* search551_0_1 -> 32 in the cache */
   /* search551_0 -> 1681 in the cache */
   /* search551_1 -> 530 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ieq,
      0, 1,
      { 1681, 530 },
      -1,
   } },

   /* replace551_0 -> 29 in the cache */
   /* replace551_1 -> 139 in the cache */
   /* replace551 -> 1679 in the cache */

   /* ('ine', ('ushr', 'a@32', 31), 1) => ('ige', 'a', 0) */
   /* search552_0_0 -> 29 in the cache */
   /* search552_0_1 -> 32 in the cache */
   /* search552_0 -> 1681 in the cache */
   /* search552_1 -> 530 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ine,
      0, 1,
      { 1681, 530 },
      -1,
   } },

   /* replace552_0 -> 29 in the cache */
   /* replace552_1 -> 139 in the cache */
   /* replace552 -> 1676 in the cache */

   /* ('ine', ('ishr', 'a@32', 31), 0) => ('ilt', 'a', 0) */
   /* search553_0_0 -> 29 in the cache */
   /* search553_0_1 -> 32 in the cache */
   /* search553_0 -> 1670 in the cache */
   /* search553_1 -> 139 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ine,
      0, 1,
      { 1670, 139 },
      -1,
   } },

   /* replace553_0 -> 29 in the cache */
   /* replace553_1 -> 139 in the cache */
   /* replace553 -> 1679 in the cache */

   /* ('ieq', ('ishr', 'a@32', 31), 0) => ('ige', 'a', 0) */
   /* search554_0_0 -> 29 in the cache */
   /* search554_0_1 -> 32 in the cache */
   /* search554_0 -> 1670 in the cache */
   /* search554_1 -> 139 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ieq,
      0, 1,
      { 1670, 139 },
      -1,
   } },

   /* replace554_0 -> 29 in the cache */
   /* replace554_1 -> 139 in the cache */
   /* replace554 -> 1676 in the cache */

   /* ('ieq', ('ishr', 'a@32', 31), -1) => ('ilt', 'a', 0) */
   /* search555_0_0 -> 29 in the cache */
   /* search555_0_1 -> 32 in the cache */
   /* search555_0 -> 1670 in the cache */
   /* search555_1 -> 141 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ieq,
      0, 1,
      { 1670, 141 },
      -1,
   } },

   /* replace555_0 -> 29 in the cache */
   /* replace555_1 -> 139 in the cache */
   /* replace555 -> 1679 in the cache */

   /* ('ine', ('ishr', 'a@32', 31), -1) => ('ige', 'a', 0) */
   /* search556_0_0 -> 29 in the cache */
   /* search556_0_1 -> 32 in the cache */
   /* search556_0 -> 1670 in the cache */
   /* search556_1 -> 141 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ine,
      0, 1,
      { 1670, 141 },
      -1,
   } },

   /* replace556_0 -> 29 in the cache */
   /* replace556_1 -> 139 in the cache */
   /* replace556 -> 1676 in the cache */

   /* ('iand@64', 'a', ('inot', ('ishr', 'a', 63))) => ('imax', 'a', 0) */
   /* search557_0 -> 34 in the cache */
   /* search557_1_0_0 -> 34 in the cache */
   /* search557_1_0_1 -> 37 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ishr,
      -1, 0,
      { 34, 37 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_inot,
      -1, 0,
      { 1690 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_iand,
      0, 1,
      { 34, 1691 },
      -1,
   } },

   /* replace557_0 -> 34 in the cache */
   /* replace557_1 -> 1047 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_imax,
      0, 1,
      { 34, 1047 },
      -1,
   } },

   /* ('ieq', ('iand', 'a@64', 9223372036854775808), 0) => ('ige', 'a', 0) */
   /* search558_0_0 -> 34 in the cache */
   /* search558_0_1 -> 35 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_iand,
      1, 1,
      { 34, 35 },
      -1,
   } },
   /* search558_1 -> 1047 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ieq,
      0, 2,
      { 1694, 1047 },
      -1,
   } },

   /* replace558_0 -> 34 in the cache */
   /* replace558_1 -> 1047 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ige,
      -1, 0,
      { 34, 1047 },
      -1,
   } },

   /* ('ine', ('iand', 'a@64', 9223372036854775808), 9223372036854775808) => ('ige', 'a', 0) */
   /* search559_0_0 -> 34 in the cache */
   /* search559_0_1 -> 35 in the cache */
   /* search559_0 -> 1694 in the cache */
   /* search559_1 -> 35 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ine,
      0, 2,
      { 1694, 35 },
      -1,
   } },

   /* replace559_0 -> 34 in the cache */
   /* replace559_1 -> 1047 in the cache */
   /* replace559 -> 1696 in the cache */

   /* ('ine', ('iand', 'a@64', 9223372036854775808), 0) => ('ilt', 'a', 0) */
   /* search560_0_0 -> 34 in the cache */
   /* search560_0_1 -> 35 in the cache */
   /* search560_0 -> 1694 in the cache */
   /* search560_1 -> 1047 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ine,
      0, 2,
      { 1694, 1047 },
      -1,
   } },

   /* replace560_0 -> 34 in the cache */
   /* replace560_1 -> 1047 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ilt,
      -1, 0,
      { 34, 1047 },
      -1,
   } },

   /* ('ieq', ('iand', 'a@64', 9223372036854775808), 9223372036854775808) => ('ilt', 'a', 0) */
   /* search561_0_0 -> 34 in the cache */
   /* search561_0_1 -> 35 in the cache */
   /* search561_0 -> 1694 in the cache */
   /* search561_1 -> 35 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ieq,
      0, 2,
      { 1694, 35 },
      -1,
   } },

   /* replace561_0 -> 34 in the cache */
   /* replace561_1 -> 1047 in the cache */
   /* replace561 -> 1699 in the cache */

   /* ('ine', ('ushr', 'a@64', 63), 0) => ('ilt', 'a', 0) */
   /* search562_0_0 -> 34 in the cache */
   /* search562_0_1 -> 37 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ushr,
      -1, 0,
      { 34, 37 },
      -1,
   } },
   /* search562_1 -> 1047 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ine,
      0, 1,
      { 1701, 1047 },
      -1,
   } },

   /* replace562_0 -> 34 in the cache */
   /* replace562_1 -> 1047 in the cache */
   /* replace562 -> 1699 in the cache */

   /* ('ieq', ('ushr', 'a@64', 63), 0) => ('ige', 'a', 0) */
   /* search563_0_0 -> 34 in the cache */
   /* search563_0_1 -> 37 in the cache */
   /* search563_0 -> 1701 in the cache */
   /* search563_1 -> 1047 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ieq,
      0, 1,
      { 1701, 1047 },
      -1,
   } },

   /* replace563_0 -> 34 in the cache */
   /* replace563_1 -> 1047 in the cache */
   /* replace563 -> 1696 in the cache */

   /* ('ieq', ('ushr', 'a@64', 63), 1) => ('ilt', 'a', 0) */
   /* search564_0_0 -> 34 in the cache */
   /* search564_0_1 -> 37 in the cache */
   /* search564_0 -> 1701 in the cache */
   { .constant = {
      { nir_search_value_constant, 64 },
      nir_type_int, { 0x1ull /* 1 */ },
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ieq,
      0, 1,
      { 1701, 1704 },
      -1,
   } },

   /* replace564_0 -> 34 in the cache */
   /* replace564_1 -> 1047 in the cache */
   /* replace564 -> 1699 in the cache */

   /* ('ine', ('ushr', 'a@64', 63), 1) => ('ige', 'a', 0) */
   /* search565_0_0 -> 34 in the cache */
   /* search565_0_1 -> 37 in the cache */
   /* search565_0 -> 1701 in the cache */
   /* search565_1 -> 1704 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ine,
      0, 1,
      { 1701, 1704 },
      -1,
   } },

   /* replace565_0 -> 34 in the cache */
   /* replace565_1 -> 1047 in the cache */
   /* replace565 -> 1696 in the cache */

   /* ('ine', ('ishr', 'a@64', 63), 0) => ('ilt', 'a', 0) */
   /* search566_0_0 -> 34 in the cache */
   /* search566_0_1 -> 37 in the cache */
   /* search566_0 -> 1690 in the cache */
   /* search566_1 -> 1047 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ine,
      0, 1,
      { 1690, 1047 },
      -1,
   } },

   /* replace566_0 -> 34 in the cache */
   /* replace566_1 -> 1047 in the cache */
   /* replace566 -> 1699 in the cache */

   /* ('ieq', ('ishr', 'a@64', 63), 0) => ('ige', 'a', 0) */
   /* search567_0_0 -> 34 in the cache */
   /* search567_0_1 -> 37 in the cache */
   /* search567_0 -> 1690 in the cache */
   /* search567_1 -> 1047 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ieq,
      0, 1,
      { 1690, 1047 },
      -1,
   } },

   /* replace567_0 -> 34 in the cache */
   /* replace567_1 -> 1047 in the cache */
   /* replace567 -> 1696 in the cache */

   /* ('ieq', ('ishr', 'a@64', 63), -1) => ('ilt', 'a', 0) */
   /* search568_0_0 -> 34 in the cache */
   /* search568_0_1 -> 37 in the cache */
   /* search568_0 -> 1690 in the cache */
   { .constant = {
      { nir_search_value_constant, 64 },
      nir_type_int, { 0xffffffffffffffffull /* -1 */ },
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ieq,
      0, 1,
      { 1690, 1709 },
      -1,
   } },

   /* replace568_0 -> 34 in the cache */
   /* replace568_1 -> 1047 in the cache */
   /* replace568 -> 1699 in the cache */

   /* ('ine', ('ishr', 'a@64', 63), -1) => ('ige', 'a', 0) */
   /* search569_0_0 -> 34 in the cache */
   /* search569_0_1 -> 37 in the cache */
   /* search569_0 -> 1690 in the cache */
   /* search569_1 -> 1709 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ine,
      0, 1,
      { 1690, 1709 },
      -1,
   } },

   /* replace569_0 -> 34 in the cache */
   /* replace569_1 -> 1047 in the cache */
   /* replace569 -> 1696 in the cache */

   /* ('fmin', 'a', ('fneg', 'a')) => ('fneg', ('fabs', 'a')) */
   /* search570_0 -> 9 in the cache */
   /* search570_1_0 -> 9 in the cache */
   /* search570_1 -> 118 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fmin,
      0, 1,
      { 9, 118 },
      -1,
   } },

   /* replace570_0_0 -> 9 in the cache */
   /* replace570_0 -> 11 in the cache */
   /* replace570 -> 1480 in the cache */

   /* ('imin', 'a', ('ineg', 'a')) => ('ineg', ('iabs', 'a')) */
   /* search571_0 -> 9 in the cache */
   /* search571_1_0 -> 9 in the cache */
   /* search571_1 -> 120 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_imin,
      0, 1,
      { 9, 120 },
      -1,
   } },

   /* replace571_0_0 -> 9 in the cache */
   /* replace571_0 -> 125 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ineg,
      -1, 0,
      { 125 },
      -1,
   } },

   /* ('fmin', 'a', ('fneg', ('fabs', 'a'))) => ('fneg', ('fabs', 'a')) */
   /* search572_0 -> 9 in the cache */
   /* search572_1_0_0 -> 9 in the cache */
   /* search572_1_0 -> 11 in the cache */
   /* search572_1 -> 1480 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fmin,
      0, 1,
      { 9, 1480 },
      -1,
   } },

   /* replace572_0_0 -> 9 in the cache */
   /* replace572_0 -> 11 in the cache */
   /* replace572 -> 1480 in the cache */

   /* ('imin', 'a', ('ineg', ('iabs', 'a'))) => ('ineg', ('iabs', 'a')) */
   /* search573_0 -> 9 in the cache */
   /* search573_1_0_0 -> 9 in the cache */
   /* search573_1_0 -> 125 in the cache */
   /* search573_1 -> 1714 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_imin,
      0, 1,
      { 9, 1714 },
      -1,
   } },

   /* replace573_0_0 -> 9 in the cache */
   /* replace573_0 -> 125 in the cache */
   /* replace573 -> 1714 in the cache */

   /* ('~fmin', 'a', ('fabs', 'a')) => a */
   /* search574_0 -> 9 in the cache */
   /* search574_1_0 -> 9 in the cache */
   /* search574_1 -> 11 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      true,
      false,
      false,
      false,
      false,
      false,
      nir_op_fmin,
      0, 1,
      { 9, 11 },
      -1,
   } },

   /* replace574 -> 9 in the cache */

   /* ('imin', 'a', ('iabs', 'a')) => a */
   /* search575_0 -> 9 in the cache */
   /* search575_1_0 -> 9 in the cache */
   /* search575_1 -> 125 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_imin,
      0, 1,
      { 9, 125 },
      -1,
   } },

   /* replace575 -> 9 in the cache */

   /* ('~fmax', 'a', ('fneg', ('fabs', 'a'))) => a */
   /* search576_0 -> 9 in the cache */
   /* search576_1_0_0 -> 9 in the cache */
   /* search576_1_0 -> 11 in the cache */
   /* search576_1 -> 1480 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      true,
      false,
      false,
      false,
      false,
      false,
      nir_op_fmax,
      0, 1,
      { 9, 1480 },
      -1,
   } },

   /* replace576 -> 9 in the cache */

   /* ('imax', 'a', ('ineg', ('iabs', 'a'))) => a */
   /* search577_0 -> 9 in the cache */
   /* search577_1_0_0 -> 9 in the cache */
   /* search577_1_0 -> 125 in the cache */
   /* search577_1 -> 1714 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_imax,
      0, 1,
      { 9, 1714 },
      -1,
   } },

   /* replace577 -> 9 in the cache */

   /* ('fmax', 'a', ('fabs', 'a')) => ('fabs', 'a') */
   /* search578_0 -> 9 in the cache */
   /* search578_1_0 -> 9 in the cache */
   /* search578_1 -> 11 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fmax,
      0, 1,
      { 9, 11 },
      -1,
   } },

   /* replace578_0 -> 9 in the cache */
   /* replace578 -> 11 in the cache */

   /* ('imax', 'a', ('iabs', 'a')) => ('iabs', 'a') */
   /* search579_0 -> 9 in the cache */
   /* search579_1_0 -> 9 in the cache */
   /* search579_1 -> 125 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_imax,
      0, 1,
      { 9, 125 },
      -1,
   } },

   /* replace579_0 -> 9 in the cache */
   /* replace579 -> 125 in the cache */

   /* ('fmax', 'a', ('fneg', 'a')) => ('fabs', 'a') */
   /* search580_0 -> 9 in the cache */
   /* search580_1_0 -> 9 in the cache */
   /* search580_1 -> 118 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fmax,
      0, 1,
      { 9, 118 },
      -1,
   } },

   /* replace580_0 -> 9 in the cache */
   /* replace580 -> 11 in the cache */

   /* ('imax', 'a', ('ineg', 'a')) => ('iabs', 'a') */
   /* search581_0 -> 9 in the cache */
   /* search581_1_0 -> 9 in the cache */
   /* search581_1 -> 120 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_imax,
      0, 1,
      { 9, 120 },
      -1,
   } },

   /* replace581_0 -> 9 in the cache */
   /* replace581 -> 125 in the cache */

   /* ('~fmax', ('fabs', 'a'), 0.0) => ('fabs', 'a') */
   /* search582_0_0 -> 9 in the cache */
   /* search582_0 -> 11 in the cache */
   /* search582_1 -> 8 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      true,
      false,
      false,
      false,
      false,
      false,
      nir_op_fmax,
      0, 1,
      { 11, 8 },
      -1,
   } },

   /* replace582_0 -> 9 in the cache */
   /* replace582 -> 11 in the cache */

   /* ('fmin', ('fmax', 'a', 0.0), 1.0) => ('fsat', 'a') */
   /* search583_0_0 -> 9 in the cache */
   /* search583_0_1 -> 8 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fmax,
      1, 1,
      { 9, 8 },
      -1,
   } },
   /* search583_1 -> 273 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fmin,
      0, 2,
      { 1726, 273 },
      -1,
   } },

   /* replace583_0 -> 9 in the cache */
   /* replace583 -> 249 in the cache */

   /* ('~fmax', ('fmin', 'a', 1.0), 0.0) => ('fsat', 'a') */
   /* search584_0_0 -> 9 in the cache */
   /* search584_0_1 -> 273 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fmin,
      1, 1,
      { 9, 273 },
      -1,
   } },
   /* search584_1 -> 8 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      true,
      false,
      false,
      false,
      false,
      false,
      nir_op_fmax,
      0, 2,
      { 1728, 8 },
      -1,
   } },

   /* replace584_0 -> 9 in the cache */
   /* replace584 -> 249 in the cache */

   /* ('~fmin', ('fmax', 'a', -1.0), 0.0) => ('fneg', ('fsat', ('fneg', 'a'))) */
   /* search585_0_0 -> 9 in the cache */
   /* search585_0_1 -> 279 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fmax,
      1, 1,
      { 9, 279 },
      -1,
   } },
   /* search585_1 -> 8 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      true,
      false,
      false,
      false,
      false,
      false,
      nir_op_fmin,
      0, 2,
      { 1730, 8 },
      -1,
   } },

   /* replace585_0_0_0 -> 9 in the cache */
   /* replace585_0_0 -> 118 in the cache */
   /* replace585_0 -> 250 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fneg,
      -1, 0,
      { 250 },
      -1,
   } },

   /* ('~fmax', ('fmin', 'a', 0.0), -1.0) => ('fneg', ('fsat', ('fneg', 'a'))) */
   /* search586_0_0 -> 9 in the cache */
   /* search586_0_1 -> 8 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fmin,
      1, 1,
      { 9, 8 },
      -1,
   } },
   /* search586_1 -> 279 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      true,
      false,
      false,
      false,
      false,
      false,
      nir_op_fmax,
      0, 2,
      { 1733, 279 },
      -1,
   } },

   /* replace586_0_0_0 -> 9 in the cache */
   /* replace586_0_0 -> 118 in the cache */
   /* replace586_0 -> 250 in the cache */
   /* replace586 -> 1732 in the cache */

   /* ('fsat', ('fsign', 'a')) => ('b2f', ('!flt', 0.0, 'a')) */
   /* search587_0_0 -> 9 in the cache */
   /* search587_0 -> 110 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fsat,
      -1, 0,
      { 110 },
      -1,
   } },

   /* replace587_0_0 -> 8 in the cache */
   /* replace587_0_1 -> 9 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      true,
      false,
      false,
      false,
      false,
      nir_op_flt,
      -1, 0,
      { 8, 9 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_search_op_b2f,
      -1, 0,
      { 1736 },
      -1,
   } },

   /* ('fsat', ('b2f', 'a')) => ('b2f', 'a') */
   /* search588_0_0 -> 9 in the cache */
   { .expression = {
      { nir_search_value_expression, 0 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_search_op_b2f,
      -1, 0,
      { 9 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 0 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fsat,
      -1, 0,
      { 1738 },
      -1,
   } },

   /* replace588_0 -> 9 in the cache */
   /* replace588 -> 1738 in the cache */

   /* ('fsat', 'a') => ('fmin', ('fmax', 'a', 0.0), 1.0) */
   /* search589_0 -> 9 in the cache */
   /* search589 -> 249 in the cache */

   /* replace589_0_0 -> 9 in the cache */
   /* replace589_0_1 -> 8 in the cache */
   /* replace589_0 -> 1726 in the cache */
   /* replace589_1 -> 273 in the cache */
   /* replace589 -> 1727 in the cache */

   /* ('fsat', ('fsat', 'a')) => ('fsat', 'a') */
   /* search590_0_0 -> 9 in the cache */
   /* search590_0 -> 249 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fsat,
      -1, 0,
      { 249 },
      -1,
   } },

   /* replace590_0 -> 9 in the cache */
   /* replace590 -> 249 in the cache */

   /* ('fsat', ('fneg(is_used_once)', ('fadd(is_used_once)', 'a', 'b'))) => ('fsat', ('fadd', ('fneg', 'a'), ('fneg', 'b'))) */
   /* search591_0_0_0 -> 0 in the cache */
   /* search591_0_0_1 -> 1 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fadd,
      0, 1,
      { 0, 1 },
      0,
   } },
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fneg,
      -1, 1,
      { 1741 },
      0,
   } },
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fsat,
      -1, 1,
      { 1742 },
      -1,
   } },

   /* replace591_0_0_0 -> 0 in the cache */
   /* replace591_0_0 -> 132 in the cache */
   /* replace591_0_1_0 -> 1 in the cache */
   /* replace591_0_1 -> 1281 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fadd,
      0, 1,
      { 132, 1281 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fsat,
      -1, 1,
      { 1744 },
      -1,
   } },

   /* ('fsat', ('fneg(is_used_once)', ('fmul(is_used_once)', 'a', 'b'))) => ('fsat', ('fmul', ('fneg', 'a'), 'b')) */
   /* search592_0_0_0 -> 0 in the cache */
   /* search592_0_0_1 -> 1 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fmul,
      0, 1,
      { 0, 1 },
      0,
   } },
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fneg,
      -1, 1,
      { 1746 },
      0,
   } },
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fsat,
      -1, 1,
      { 1747 },
      -1,
   } },

   /* replace592_0_0_0 -> 0 in the cache */
   /* replace592_0_0 -> 132 in the cache */
   /* replace592_0_1 -> 1 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fmul,
      0, 1,
      { 132, 1 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fsat,
      -1, 1,
      { 1749 },
      -1,
   } },

   /* ('fsat(nsz)', ('fneg(is_used_once)', ('fmulz(is_used_once)', 'a', 'b'))) => ('fsat', ('fmulz', ('fneg', 'a'), 'b')) */
   /* search593_0_0_0 -> 29 in the cache */
   /* search593_0_0_1 -> 48 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fmulz,
      0, 1,
      { 29, 48 },
      0,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fneg,
      -1, 1,
      { 1751 },
      0,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      true,
      false,
      false,
      nir_op_fsat,
      -1, 1,
      { 1752 },
      -1,
   } },

   /* replace593_0_0_0 -> 29 in the cache */
   /* replace593_0_0 -> 307 in the cache */
   /* replace593_0_1 -> 48 in the cache */
   /* replace593_0 -> 447 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fsat,
      -1, 1,
      { 447 },
      -1,
   } },

   /* ('fsat', ('fabs(is_used_once)', ('fmul(is_used_once)', 'a', 'b'))) => ('fsat', ('fmul', ('fabs', 'a'), ('fabs', 'b'))) */
   /* search594_0_0_0 -> 0 in the cache */
   /* search594_0_0_1 -> 1 in the cache */
   /* search594_0_0 -> 1746 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fabs,
      -1, 1,
      { 1746 },
      0,
   } },
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fsat,
      -1, 1,
      { 1755 },
      -1,
   } },

   /* replace594_0_0_0 -> 0 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fabs,
      -1, 0,
      { 0 },
      -1,
   } },
   /* replace594_0_1_0 -> 1 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fabs,
      -1, 0,
      { 1 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fmul,
      0, 1,
      { 1757, 1758 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fsat,
      -1, 1,
      { 1759 },
      -1,
   } },

   /* ('fmin', ('fmax', ('fmin', ('fmax', 'a', 'b'), 'c'), 'b'), 'c') => ('fmin', ('fmax', 'a', 'b'), 'c') */
   /* search595_0_0_0_0 -> 143 in the cache */
   /* search595_0_0_0_1 -> 144 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fmax,
      3, 1,
      { 143, 144 },
      -1,
   } },
   /* search595_0_0_1 -> 146 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fmin,
      2, 2,
      { 1761, 146 },
      -1,
   } },
   /* search595_0_1 -> 144 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fmax,
      1, 3,
      { 1762, 144 },
      -1,
   } },
   /* search595_1 -> 146 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fmin,
      0, 4,
      { 1763, 146 },
      -1,
   } },

   /* replace595_0_0 -> 143 in the cache */
   /* replace595_0_1 -> 144 in the cache */
   /* replace595_0 -> 1570 in the cache */
   /* replace595_1 -> 146 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fmin,
      0, 2,
      { 1570, 146 },
      -1,
   } },

   /* ('imin', ('imax', ('imin', ('imax', 'a', 'b'), 'c'), 'b'), 'c') => ('imin', ('imax', 'a', 'b'), 'c') */
   /* search596_0_0_0_0 -> 143 in the cache */
   /* search596_0_0_0_1 -> 144 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_imax,
      3, 1,
      { 143, 144 },
      -1,
   } },
   /* search596_0_0_1 -> 146 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_imin,
      2, 2,
      { 1766, 146 },
      -1,
   } },
   /* search596_0_1 -> 144 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_imax,
      1, 3,
      { 1767, 144 },
      -1,
   } },
   /* search596_1 -> 146 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_imin,
      0, 4,
      { 1768, 146 },
      -1,
   } },

   /* replace596_0_0 -> 143 in the cache */
   /* replace596_0_1 -> 144 in the cache */
   /* replace596_0 -> 1580 in the cache */
   /* replace596_1 -> 146 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_imin,
      0, 2,
      { 1580, 146 },
      -1,
   } },

   /* ('umin', ('umax', ('umin', ('umax', 'a', 'b'), 'c'), 'b'), 'c') => ('umin', ('umax', 'a', 'b'), 'c') */
   /* search597_0_0_0_0 -> 143 in the cache */
   /* search597_0_0_0_1 -> 144 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_umax,
      3, 1,
      { 143, 144 },
      -1,
   } },
   /* search597_0_0_1 -> 146 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_umin,
      2, 2,
      { 1771, 146 },
      -1,
   } },
   /* search597_0_1 -> 144 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_umax,
      1, 3,
      { 1772, 144 },
      -1,
   } },
   /* search597_1 -> 146 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_umin,
      0, 4,
      { 1773, 146 },
      -1,
   } },

   /* replace597_0_0 -> 143 in the cache */
   /* replace597_0_1 -> 144 in the cache */
   /* replace597_0 -> 1575 in the cache */
   /* replace597_1 -> 146 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_umin,
      0, 2,
      { 1575, 146 },
      -1,
   } },

   /* ('fmax', ('fsat', 'a'), '#b(is_zero_to_one)') => ('fsat', ('fmax', 'a', 'b')) */
   /* search598_0_0 -> 0 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fsat,
      -1, 0,
      { 0 },
      -1,
   } },
   { .variable = {
      { nir_search_value_variable, -2 },
      1, /* b */
      true,
      nir_type_invalid,
      21,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fmax,
      0, 1,
      { 1776, 1777 },
      -1,
   } },

   /* replace598_0_0 -> 0 in the cache */
   /* replace598_0_1 -> 1 in the cache */
   /* replace598_0 -> 1507 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fsat,
      -1, 1,
      { 1507 },
      -1,
   } },

   /* ('fmax', ('fsat(is_used_once)', 'a'), ('fsat(is_used_once)', 'b')) => ('fsat', ('fmax', 'a', 'b')) */
   /* search599_0_0 -> 0 in the cache */
   /* search599_0 -> 1340 in the cache */
   /* search599_1_0 -> 1 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fsat,
      -1, 0,
      { 1 },
      0,
   } },
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fmax,
      0, 1,
      { 1340, 1780 },
      -1,
   } },

   /* replace599_0_0 -> 0 in the cache */
   /* replace599_0_1 -> 1 in the cache */
   /* replace599_0 -> 1507 in the cache */
   /* replace599 -> 1779 in the cache */

   /* ('~fmin', ('fsat', 'a'), '#b(is_zero_to_one)') => ('fsat', ('fmin', 'a', 'b')) */
   /* search600_0_0 -> 0 in the cache */
   /* search600_0 -> 1776 in the cache */
   /* search600_1 -> 1777 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      true,
      false,
      false,
      false,
      false,
      false,
      nir_op_fmin,
      0, 1,
      { 1776, 1777 },
      -1,
   } },

   /* replace600_0_0 -> 0 in the cache */
   /* replace600_0_1 -> 1 in the cache */
   /* replace600_0 -> 1509 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fsat,
      -1, 1,
      { 1509 },
      -1,
   } },

   /* ('fsat', ('fadd', 1.0, 'a(is_ge_zero)')) => 1.0 */
   /* search601_0_0 -> 273 in the cache */
   { .variable = {
      { nir_search_value_variable, -1 },
      0, /* a */
      false,
      nir_type_invalid,
      22,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fadd,
      0, 1,
      { 273, 1784 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fsat,
      -1, 1,
      { 1785 },
      -1,
   } },

   /* replace601 -> 273 in the cache */

   /* ('fneg', ('bcsel(is_used_once)', 'a', '#b', '#c')) => ('bcsel', 'a', ('fneg', 'b'), ('fneg', 'c')) */
   /* search602_0_0 -> 907 in the cache */
   /* search602_0_1 -> 310 in the cache */
   /* search602_0_2 -> 964 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_bcsel,
      -1, 0,
      { 907, 310, 964 },
      0,
   } },
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fneg,
      -1, 0,
      { 1787 },
      -1,
   } },

   /* replace602_0 -> 907 in the cache */
   /* replace602_1_0 -> 144 in the cache */
   /* replace602_1 -> 1419 in the cache */
   /* replace602_2_0 -> 146 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fneg,
      -1, 0,
      { 146 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_bcsel,
      -1, 0,
      { 907, 1419, 1789 },
      -1,
   } },

   /* ('fmax', ('fneg', ('fmin', 'b', 'a')), 'b') => ('fmax', ('fabs', 'b'), ('fneg', 'a')) */
   /* search603_0_0_0 -> 1298 in the cache */
   /* search603_0_0_1 -> 1297 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fmin,
      1, 1,
      { 1298, 1297 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fneg,
      -1, 1,
      { 1791 },
      -1,
   } },
   /* search603_1 -> 1298 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fmax,
      0, 2,
      { 1792, 1298 },
      -1,
   } },

   /* replace603_0_0 -> 1298 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fabs,
      -1, 0,
      { 1298 },
      -1,
   } },
   /* replace603_1_0 -> 1297 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fneg,
      -1, 0,
      { 1297 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fmax,
      0, 1,
      { 1794, 1795 },
      -1,
   } },

   /* ('fmin', ('fneg', ('fmax', 'b', 'a')), 'b') => ('fmin', ('fneg', ('fabs', 'b')), ('fneg', 'a')) */
   /* search604_0_0_0 -> 1298 in the cache */
   /* search604_0_0_1 -> 1297 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fmax,
      1, 1,
      { 1298, 1297 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fneg,
      -1, 1,
      { 1797 },
      -1,
   } },
   /* search604_1 -> 1298 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fmin,
      0, 2,
      { 1798, 1298 },
      -1,
   } },

   /* replace604_0_0_0 -> 1298 in the cache */
   /* replace604_0_0 -> 1794 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fneg,
      -1, 0,
      { 1794 },
      -1,
   } },
   /* replace604_1_0 -> 1297 in the cache */
   /* replace604_1 -> 1795 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fmin,
      0, 1,
      { 1800, 1795 },
      -1,
   } },

   /* ('fmax', ('fadd(is_used_once)', ('fneg', 'a(is_not_negative)'), '#b(is_zero_to_one)'), 0.0) => ('fsat', ('fadd', ('fneg', 'a'), 'b')) */
   { .variable = {
      { nir_search_value_variable, -2 },
      0, /* a */
      false,
      nir_type_invalid,
      23,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fneg,
      -1, 0,
      { 1802 },
      -1,
   } },
   /* search605_0_1 -> 1777 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fadd,
      1, 1,
      { 1803, 1777 },
      0,
   } },
   /* search605_1 -> 287 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fmax,
      0, 2,
      { 1804, 287 },
      -1,
   } },

   /* replace605_0_0_0 -> 0 in the cache */
   /* replace605_0_0 -> 132 in the cache */
   /* replace605_0_1 -> 1 in the cache */
   /* replace605_0 -> 304 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fsat,
      -1, 1,
      { 304 },
      -1,
   } },

   /* ('extract_u8', ('imin', ('imax', 'a', 0), 255), 0) => ('imin', ('imax', 'a', 0), 255) */
   /* search606_0_0_0 -> 9 in the cache */
   /* search606_0_0_1 -> 73 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_imax,
      1, 1,
      { 9, 73 },
      -1,
   } },
   { .constant = {
      { nir_search_value_constant, -1 },
      nir_type_int, { 0xffull /* 255 */ },
   } },
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_imin,
      0, 2,
      { 1807, 1808 },
      -1,
   } },
   /* search606_1 -> 73 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_extract_u8,
      -1, 2,
      { 1809, 73 },
      -1,
   } },

   /* replace606_0_0 -> 9 in the cache */
   /* replace606_0_1 -> 73 in the cache */
   /* replace606_0 -> 1807 in the cache */
   /* replace606_1 -> 1808 in the cache */
   /* replace606 -> 1809 in the cache */

   /* ('ior', ('flt(is_used_once)', 'a', 'b'), ('flt', 'a', 'c')) => ('flt', 'a', ('!fmax', 'b', 'c')) */
   /* search607_0_0 -> 143 in the cache */
   /* search607_0_1 -> 144 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_flt,
      -1, 0,
      { 143, 144 },
      0,
   } },
   /* search607_1_0 -> 143 in the cache */
   /* search607_1_1 -> 146 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_flt,
      -1, 0,
      { 143, 146 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ior,
      0, 1,
      { 1811, 1812 },
      -1,
   } },

   /* replace607_0 -> 143 in the cache */
   /* replace607_1_0 -> 144 in the cache */
   /* replace607_1_1 -> 146 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      true,
      false,
      false,
      false,
      false,
      nir_op_fmax,
      0, 1,
      { 144, 146 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_flt,
      -1, 1,
      { 143, 1814 },
      -1,
   } },

   /* ('ior', ('flt(is_used_once)', 'a', 'c'), ('flt', 'b', 'c')) => ('flt', ('!fmin', 'a', 'b'), 'c') */
   /* search608_0_0 -> 0 in the cache */
   /* search608_0_1 -> 813 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_flt,
      -1, 0,
      { 0, 813 },
      0,
   } },
   { .variable = {
      { nir_search_value_variable, -2 },
      2, /* b */
      false,
      nir_type_invalid,
      -1,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   /* search608_1_1 -> 813 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_flt,
      -1, 0,
      { 1817, 813 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ior,
      0, 1,
      { 1816, 1818 },
      -1,
   } },

   /* replace608_0_0 -> 0 in the cache */
   /* replace608_0_1 -> 1817 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      true,
      false,
      false,
      false,
      false,
      nir_op_fmin,
      0, 1,
      { 0, 1817 },
      -1,
   } },
   /* replace608_1 -> 813 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_flt,
      -1, 1,
      { 1820, 813 },
      -1,
   } },

   /* ('ior', ('fge(is_used_once)', 'a', 'b'), ('fge', 'a', 'c')) => ('fge', 'a', ('!fmin', 'b', 'c')) */
   /* search609_0_0 -> 143 in the cache */
   /* search609_0_1 -> 144 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fge,
      -1, 0,
      { 143, 144 },
      0,
   } },
   /* search609_1_0 -> 143 in the cache */
   /* search609_1_1 -> 146 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fge,
      -1, 0,
      { 143, 146 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ior,
      0, 1,
      { 1822, 1823 },
      -1,
   } },

   /* replace609_0 -> 143 in the cache */
   /* replace609_1_0 -> 144 in the cache */
   /* replace609_1_1 -> 146 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      true,
      false,
      false,
      false,
      false,
      nir_op_fmin,
      0, 1,
      { 144, 146 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fge,
      -1, 1,
      { 143, 1825 },
      -1,
   } },

   /* ('ior', ('fge(is_used_once)', 'a', 'c'), ('fge', 'b', 'c')) => ('fge', ('!fmax', 'a', 'b'), 'c') */
   /* search610_0_0 -> 0 in the cache */
   /* search610_0_1 -> 813 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fge,
      -1, 0,
      { 0, 813 },
      0,
   } },
   /* search610_1_0 -> 1817 in the cache */
   /* search610_1_1 -> 813 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fge,
      -1, 0,
      { 1817, 813 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ior,
      0, 1,
      { 1827, 1828 },
      -1,
   } },

   /* replace610_0_0 -> 0 in the cache */
   /* replace610_0_1 -> 1817 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      true,
      false,
      false,
      false,
      false,
      nir_op_fmax,
      0, 1,
      { 0, 1817 },
      -1,
   } },
   /* replace610_1 -> 813 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fge,
      -1, 1,
      { 1830, 813 },
      -1,
   } },

   /* ('ior', ('flt', 'a', '#b'), ('flt', 'a', '#c')) => ('flt', 'a', ('!fmax', 'b', 'c')) */
   /* search611_0_0 -> 143 in the cache */
   /* search611_0_1 -> 310 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_flt,
      -1, 0,
      { 143, 310 },
      -1,
   } },
   /* search611_1_0 -> 143 in the cache */
   /* search611_1_1 -> 964 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_flt,
      -1, 0,
      { 143, 964 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ior,
      0, 1,
      { 1832, 1833 },
      -1,
   } },

   /* replace611_0 -> 143 in the cache */
   /* replace611_1_0 -> 144 in the cache */
   /* replace611_1_1 -> 146 in the cache */
   /* replace611_1 -> 1814 in the cache */
   /* replace611 -> 1815 in the cache */

   /* ('ior', ('flt', '#a', 'c'), ('flt', '#b', 'c')) => ('flt', ('!fmin', 'a', 'b'), 'c') */
   { .variable = {
      { nir_search_value_variable, -2 },
      0, /* a */
      true,
      nir_type_invalid,
      -1,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   /* search612_0_1 -> 813 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_flt,
      -1, 0,
      { 1835, 813 },
      -1,
   } },
   { .variable = {
      { nir_search_value_variable, -2 },
      2, /* b */
      true,
      nir_type_invalid,
      -1,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   /* search612_1_1 -> 813 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_flt,
      -1, 0,
      { 1837, 813 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ior,
      0, 1,
      { 1836, 1838 },
      -1,
   } },

   /* replace612_0_0 -> 0 in the cache */
   /* replace612_0_1 -> 1817 in the cache */
   /* replace612_0 -> 1820 in the cache */
   /* replace612_1 -> 813 in the cache */
   /* replace612 -> 1821 in the cache */

   /* ('ior', ('fge', 'a', '#b'), ('fge', 'a', '#c')) => ('fge', 'a', ('!fmin', 'b', 'c')) */
   /* search613_0_0 -> 143 in the cache */
   /* search613_0_1 -> 310 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fge,
      -1, 0,
      { 143, 310 },
      -1,
   } },
   /* search613_1_0 -> 143 in the cache */
   /* search613_1_1 -> 964 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fge,
      -1, 0,
      { 143, 964 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ior,
      0, 1,
      { 1840, 1841 },
      -1,
   } },

   /* replace613_0 -> 143 in the cache */
   /* replace613_1_0 -> 144 in the cache */
   /* replace613_1_1 -> 146 in the cache */
   /* replace613_1 -> 1825 in the cache */
   /* replace613 -> 1826 in the cache */

   /* ('ior', ('fge', '#a', 'c'), ('fge', '#b', 'c')) => ('fge', ('!fmax', 'a', 'b'), 'c') */
   /* search614_0_0 -> 1835 in the cache */
   /* search614_0_1 -> 813 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fge,
      -1, 0,
      { 1835, 813 },
      -1,
   } },
   /* search614_1_0 -> 1837 in the cache */
   /* search614_1_1 -> 813 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fge,
      -1, 0,
      { 1837, 813 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ior,
      0, 1,
      { 1843, 1844 },
      -1,
   } },

   /* replace614_0_0 -> 0 in the cache */
   /* replace614_0_1 -> 1817 in the cache */
   /* replace614_0 -> 1830 in the cache */
   /* replace614_1 -> 813 in the cache */
   /* replace614 -> 1831 in the cache */

   /* ('~iand', ('flt(is_used_once)', 'a', 'b'), ('flt', 'a', 'c')) => ('flt', 'a', ('fmin', 'b', 'c')) */
   /* search615_0_0 -> 143 in the cache */
   /* search615_0_1 -> 144 in the cache */
   /* search615_0 -> 1811 in the cache */
   /* search615_1_0 -> 143 in the cache */
   /* search615_1_1 -> 146 in the cache */
   /* search615_1 -> 1812 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      true,
      false,
      false,
      false,
      false,
      false,
      nir_op_iand,
      0, 1,
      { 1811, 1812 },
      -1,
   } },

   /* replace615_0 -> 143 in the cache */
   /* replace615_1_0 -> 144 in the cache */
   /* replace615_1_1 -> 146 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fmin,
      0, 1,
      { 144, 146 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_flt,
      -1, 1,
      { 143, 1847 },
      -1,
   } },

   /* ('~iand', ('flt(is_used_once)', 'a', 'c'), ('flt', 'b', 'c')) => ('flt', ('fmax', 'a', 'b'), 'c') */
   /* search616_0_0 -> 0 in the cache */
   /* search616_0_1 -> 813 in the cache */
   /* search616_0 -> 1816 in the cache */
   /* search616_1_0 -> 1817 in the cache */
   /* search616_1_1 -> 813 in the cache */
   /* search616_1 -> 1818 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      true,
      false,
      false,
      false,
      false,
      false,
      nir_op_iand,
      0, 1,
      { 1816, 1818 },
      -1,
   } },

   /* replace616_0_0 -> 0 in the cache */
   /* replace616_0_1 -> 1817 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fmax,
      0, 1,
      { 0, 1817 },
      -1,
   } },
   /* replace616_1 -> 813 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_flt,
      -1, 1,
      { 1850, 813 },
      -1,
   } },

   /* ('~iand', ('fge(is_used_once)', 'a', 'b'), ('fge', 'a', 'c')) => ('fge', 'a', ('fmax', 'b', 'c')) */
   /* search617_0_0 -> 143 in the cache */
   /* search617_0_1 -> 144 in the cache */
   /* search617_0 -> 1822 in the cache */
   /* search617_1_0 -> 143 in the cache */
   /* search617_1_1 -> 146 in the cache */
   /* search617_1 -> 1823 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      true,
      false,
      false,
      false,
      false,
      false,
      nir_op_iand,
      0, 1,
      { 1822, 1823 },
      -1,
   } },

   /* replace617_0 -> 143 in the cache */
   /* replace617_1_0 -> 144 in the cache */
   /* replace617_1_1 -> 146 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fmax,
      0, 1,
      { 144, 146 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fge,
      -1, 1,
      { 143, 1853 },
      -1,
   } },

   /* ('~iand', ('fge(is_used_once)', 'a', 'c'), ('fge', 'b', 'c')) => ('fge', ('fmin', 'a', 'b'), 'c') */
   /* search618_0_0 -> 0 in the cache */
   /* search618_0_1 -> 813 in the cache */
   /* search618_0 -> 1827 in the cache */
   /* search618_1_0 -> 1817 in the cache */
   /* search618_1_1 -> 813 in the cache */
   /* search618_1 -> 1828 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      true,
      false,
      false,
      false,
      false,
      false,
      nir_op_iand,
      0, 1,
      { 1827, 1828 },
      -1,
   } },

   /* replace618_0_0 -> 0 in the cache */
   /* replace618_0_1 -> 1817 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fmin,
      0, 1,
      { 0, 1817 },
      -1,
   } },
   /* replace618_1 -> 813 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fge,
      -1, 1,
      { 1856, 813 },
      -1,
   } },

   /* ('iand', ('flt', 'a', '#b(is_a_number)'), ('flt', 'a', '#c(is_a_number)')) => ('flt', 'a', ('fmin', 'b', 'c')) */
   /* search619_0_0 -> 143 in the cache */
   { .variable = {
      { nir_search_value_variable, -3 },
      1, /* b */
      true,
      nir_type_invalid,
      19,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_flt,
      -1, 0,
      { 143, 1858 },
      -1,
   } },
   /* search619_1_0 -> 143 in the cache */
   { .variable = {
      { nir_search_value_variable, -3 },
      2, /* c */
      true,
      nir_type_invalid,
      19,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_flt,
      -1, 0,
      { 143, 1860 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_iand,
      0, 1,
      { 1859, 1861 },
      -1,
   } },

   /* replace619_0 -> 143 in the cache */
   /* replace619_1_0 -> 144 in the cache */
   /* replace619_1_1 -> 146 in the cache */
   /* replace619_1 -> 1847 in the cache */
   /* replace619 -> 1848 in the cache */

   /* ('iand', ('flt', '#a(is_a_number)', 'c'), ('flt', '#b(is_a_number)', 'c')) => ('flt', ('fmax', 'a', 'b'), 'c') */
   { .variable = {
      { nir_search_value_variable, -2 },
      0, /* a */
      true,
      nir_type_invalid,
      19,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   /* search620_0_1 -> 813 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_flt,
      -1, 0,
      { 1863, 813 },
      -1,
   } },
   { .variable = {
      { nir_search_value_variable, -2 },
      2, /* b */
      true,
      nir_type_invalid,
      19,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   /* search620_1_1 -> 813 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_flt,
      -1, 0,
      { 1865, 813 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_iand,
      0, 1,
      { 1864, 1866 },
      -1,
   } },

   /* replace620_0_0 -> 0 in the cache */
   /* replace620_0_1 -> 1817 in the cache */
   /* replace620_0 -> 1850 in the cache */
   /* replace620_1 -> 813 in the cache */
   /* replace620 -> 1851 in the cache */

   /* ('iand', ('fge', 'a', '#b(is_a_number)'), ('fge', 'a', '#c(is_a_number)')) => ('fge', 'a', ('fmax', 'b', 'c')) */
   /* search621_0_0 -> 143 in the cache */
   /* search621_0_1 -> 1858 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fge,
      -1, 0,
      { 143, 1858 },
      -1,
   } },
   /* search621_1_0 -> 143 in the cache */
   /* search621_1_1 -> 1860 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fge,
      -1, 0,
      { 143, 1860 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_iand,
      0, 1,
      { 1868, 1869 },
      -1,
   } },

   /* replace621_0 -> 143 in the cache */
   /* replace621_1_0 -> 144 in the cache */
   /* replace621_1_1 -> 146 in the cache */
   /* replace621_1 -> 1853 in the cache */
   /* replace621 -> 1854 in the cache */

   /* ('iand', ('fge', '#a(is_a_number)', 'c'), ('fge', '#b(is_a_number)', 'c')) => ('fge', ('fmin', 'a', 'b'), 'c') */
   /* search622_0_0 -> 1863 in the cache */
   /* search622_0_1 -> 813 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fge,
      -1, 0,
      { 1863, 813 },
      -1,
   } },
   /* search622_1_0 -> 1865 in the cache */
   /* search622_1_1 -> 813 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fge,
      -1, 0,
      { 1865, 813 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_iand,
      0, 1,
      { 1871, 1872 },
      -1,
   } },

   /* replace622_0_0 -> 0 in the cache */
   /* replace622_0_1 -> 1817 in the cache */
   /* replace622_0 -> 1856 in the cache */
   /* replace622_1 -> 813 in the cache */
   /* replace622 -> 1857 in the cache */

   /* ('ior', ('ilt(is_used_once)', 'a', 'b'), ('ilt', 'a', 'c')) => ('ilt', 'a', ('imax', 'b', 'c')) */
   /* search623_0_0 -> 143 in the cache */
   /* search623_0_1 -> 144 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ilt,
      -1, 0,
      { 143, 144 },
      0,
   } },
   /* search623_1_0 -> 143 in the cache */
   /* search623_1_1 -> 146 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ilt,
      -1, 0,
      { 143, 146 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ior,
      0, 1,
      { 1874, 1875 },
      -1,
   } },

   /* replace623_0 -> 143 in the cache */
   /* replace623_1_0 -> 144 in the cache */
   /* replace623_1_1 -> 146 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_imax,
      0, 1,
      { 144, 146 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ilt,
      -1, 1,
      { 143, 1877 },
      -1,
   } },

   /* ('ior', ('ilt(is_used_once)', 'a', 'c'), ('ilt', 'b', 'c')) => ('ilt', ('imin', 'a', 'b'), 'c') */
   /* search624_0_0 -> 0 in the cache */
   /* search624_0_1 -> 813 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ilt,
      -1, 0,
      { 0, 813 },
      0,
   } },
   /* search624_1_0 -> 1817 in the cache */
   /* search624_1_1 -> 813 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ilt,
      -1, 0,
      { 1817, 813 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ior,
      0, 1,
      { 1879, 1880 },
      -1,
   } },

   /* replace624_0_0 -> 0 in the cache */
   /* replace624_0_1 -> 1817 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_imin,
      0, 1,
      { 0, 1817 },
      -1,
   } },
   /* replace624_1 -> 813 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ilt,
      -1, 1,
      { 1882, 813 },
      -1,
   } },

   /* ('ior', ('ige(is_used_once)', 'a', 'b'), ('ige', 'a', 'c')) => ('ige', 'a', ('imin', 'b', 'c')) */
   /* search625_0_0 -> 143 in the cache */
   /* search625_0_1 -> 144 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ige,
      -1, 0,
      { 143, 144 },
      0,
   } },
   /* search625_1_0 -> 143 in the cache */
   /* search625_1_1 -> 146 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ige,
      -1, 0,
      { 143, 146 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ior,
      0, 1,
      { 1884, 1885 },
      -1,
   } },

   /* replace625_0 -> 143 in the cache */
   /* replace625_1_0 -> 144 in the cache */
   /* replace625_1_1 -> 146 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_imin,
      0, 1,
      { 144, 146 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ige,
      -1, 1,
      { 143, 1887 },
      -1,
   } },

   /* ('ior', ('ige(is_used_once)', 'a', 'c'), ('ige', 'b', 'c')) => ('ige', ('imax', 'a', 'b'), 'c') */
   /* search626_0_0 -> 0 in the cache */
   /* search626_0_1 -> 813 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ige,
      -1, 0,
      { 0, 813 },
      0,
   } },
   /* search626_1_0 -> 1817 in the cache */
   /* search626_1_1 -> 813 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ige,
      -1, 0,
      { 1817, 813 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ior,
      0, 1,
      { 1889, 1890 },
      -1,
   } },

   /* replace626_0_0 -> 0 in the cache */
   /* replace626_0_1 -> 1817 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_imax,
      0, 1,
      { 0, 1817 },
      -1,
   } },
   /* replace626_1 -> 813 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ige,
      -1, 1,
      { 1892, 813 },
      -1,
   } },

   /* ('ior', ('ult(is_used_once)', 'a', 'b'), ('ult', 'a', 'c')) => ('ult', 'a', ('umax', 'b', 'c')) */
   /* search627_0_0 -> 143 in the cache */
   /* search627_0_1 -> 144 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ult,
      -1, 0,
      { 143, 144 },
      0,
   } },
   /* search627_1_0 -> 143 in the cache */
   /* search627_1_1 -> 146 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ult,
      -1, 0,
      { 143, 146 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ior,
      0, 1,
      { 1894, 1895 },
      -1,
   } },

   /* replace627_0 -> 143 in the cache */
   /* replace627_1_0 -> 144 in the cache */
   /* replace627_1_1 -> 146 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_umax,
      0, 1,
      { 144, 146 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ult,
      -1, 1,
      { 143, 1897 },
      -1,
   } },

   /* ('ior', ('ult(is_used_once)', 'a', 'c'), ('ult', 'b', 'c')) => ('ult', ('umin', 'a', 'b'), 'c') */
   /* search628_0_0 -> 0 in the cache */
   /* search628_0_1 -> 813 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ult,
      -1, 0,
      { 0, 813 },
      0,
   } },
   /* search628_1_0 -> 1817 in the cache */
   /* search628_1_1 -> 813 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ult,
      -1, 0,
      { 1817, 813 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ior,
      0, 1,
      { 1899, 1900 },
      -1,
   } },

   /* replace628_0_0 -> 0 in the cache */
   /* replace628_0_1 -> 1817 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_umin,
      0, 1,
      { 0, 1817 },
      -1,
   } },
   /* replace628_1 -> 813 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ult,
      -1, 1,
      { 1902, 813 },
      -1,
   } },

   /* ('ior', ('uge(is_used_once)', 'a', 'b'), ('uge', 'a', 'c')) => ('uge', 'a', ('umin', 'b', 'c')) */
   /* search629_0_0 -> 143 in the cache */
   /* search629_0_1 -> 144 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_uge,
      -1, 0,
      { 143, 144 },
      0,
   } },
   /* search629_1_0 -> 143 in the cache */
   /* search629_1_1 -> 146 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_uge,
      -1, 0,
      { 143, 146 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ior,
      0, 1,
      { 1904, 1905 },
      -1,
   } },

   /* replace629_0 -> 143 in the cache */
   /* replace629_1_0 -> 144 in the cache */
   /* replace629_1_1 -> 146 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_umin,
      0, 1,
      { 144, 146 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_uge,
      -1, 1,
      { 143, 1907 },
      -1,
   } },

   /* ('ior', ('uge(is_used_once)', 'a', 'c'), ('uge', 'b', 'c')) => ('uge', ('umax', 'a', 'b'), 'c') */
   /* search630_0_0 -> 0 in the cache */
   /* search630_0_1 -> 813 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_uge,
      -1, 0,
      { 0, 813 },
      0,
   } },
   /* search630_1_0 -> 1817 in the cache */
   /* search630_1_1 -> 813 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_uge,
      -1, 0,
      { 1817, 813 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ior,
      0, 1,
      { 1909, 1910 },
      -1,
   } },

   /* replace630_0_0 -> 0 in the cache */
   /* replace630_0_1 -> 1817 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_umax,
      0, 1,
      { 0, 1817 },
      -1,
   } },
   /* replace630_1 -> 813 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_uge,
      -1, 1,
      { 1912, 813 },
      -1,
   } },

   /* ('iand', ('ilt(is_used_once)', 'a', 'b'), ('ilt', 'a', 'c')) => ('ilt', 'a', ('imin', 'b', 'c')) */
   /* search631_0_0 -> 143 in the cache */
   /* search631_0_1 -> 144 in the cache */
   /* search631_0 -> 1874 in the cache */
   /* search631_1_0 -> 143 in the cache */
   /* search631_1_1 -> 146 in the cache */
   /* search631_1 -> 1875 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_iand,
      0, 1,
      { 1874, 1875 },
      -1,
   } },

   /* replace631_0 -> 143 in the cache */
   /* replace631_1_0 -> 144 in the cache */
   /* replace631_1_1 -> 146 in the cache */
   /* replace631_1 -> 1887 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ilt,
      -1, 1,
      { 143, 1887 },
      -1,
   } },

   /* ('iand', ('ilt(is_used_once)', 'a', 'c'), ('ilt', 'b', 'c')) => ('ilt', ('imax', 'a', 'b'), 'c') */
   /* search632_0_0 -> 0 in the cache */
   /* search632_0_1 -> 813 in the cache */
   /* search632_0 -> 1879 in the cache */
   /* search632_1_0 -> 1817 in the cache */
   /* search632_1_1 -> 813 in the cache */
   /* search632_1 -> 1880 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_iand,
      0, 1,
      { 1879, 1880 },
      -1,
   } },

   /* replace632_0_0 -> 0 in the cache */
   /* replace632_0_1 -> 1817 in the cache */
   /* replace632_0 -> 1892 in the cache */
   /* replace632_1 -> 813 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ilt,
      -1, 1,
      { 1892, 813 },
      -1,
   } },

   /* ('iand', ('ige(is_used_once)', 'a', 'b'), ('ige', 'a', 'c')) => ('ige', 'a', ('imax', 'b', 'c')) */
   /* search633_0_0 -> 143 in the cache */
   /* search633_0_1 -> 144 in the cache */
   /* search633_0 -> 1884 in the cache */
   /* search633_1_0 -> 143 in the cache */
   /* search633_1_1 -> 146 in the cache */
   /* search633_1 -> 1885 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_iand,
      0, 1,
      { 1884, 1885 },
      -1,
   } },

   /* replace633_0 -> 143 in the cache */
   /* replace633_1_0 -> 144 in the cache */
   /* replace633_1_1 -> 146 in the cache */
   /* replace633_1 -> 1877 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ige,
      -1, 1,
      { 143, 1877 },
      -1,
   } },

   /* ('iand', ('ige(is_used_once)', 'a', 'c'), ('ige', 'b', 'c')) => ('ige', ('imin', 'a', 'b'), 'c') */
   /* search634_0_0 -> 0 in the cache */
   /* search634_0_1 -> 813 in the cache */
   /* search634_0 -> 1889 in the cache */
   /* search634_1_0 -> 1817 in the cache */
   /* search634_1_1 -> 813 in the cache */
   /* search634_1 -> 1890 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_iand,
      0, 1,
      { 1889, 1890 },
      -1,
   } },

   /* replace634_0_0 -> 0 in the cache */
   /* replace634_0_1 -> 1817 in the cache */
   /* replace634_0 -> 1882 in the cache */
   /* replace634_1 -> 813 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ige,
      -1, 1,
      { 1882, 813 },
      -1,
   } },

   /* ('iand', ('ult(is_used_once)', 'a', 'b'), ('ult', 'a', 'c')) => ('ult', 'a', ('umin', 'b', 'c')) */
   /* search635_0_0 -> 143 in the cache */
   /* search635_0_1 -> 144 in the cache */
   /* search635_0 -> 1894 in the cache */
   /* search635_1_0 -> 143 in the cache */
   /* search635_1_1 -> 146 in the cache */
   /* search635_1 -> 1895 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_iand,
      0, 1,
      { 1894, 1895 },
      -1,
   } },

   /* replace635_0 -> 143 in the cache */
   /* replace635_1_0 -> 144 in the cache */
   /* replace635_1_1 -> 146 in the cache */
   /* replace635_1 -> 1907 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ult,
      -1, 1,
      { 143, 1907 },
      -1,
   } },

   /* ('iand', ('ult(is_used_once)', 'a', 'c'), ('ult', 'b', 'c')) => ('ult', ('umax', 'a', 'b'), 'c') */
   /* search636_0_0 -> 0 in the cache */
   /* search636_0_1 -> 813 in the cache */
   /* search636_0 -> 1899 in the cache */
   /* search636_1_0 -> 1817 in the cache */
   /* search636_1_1 -> 813 in the cache */
   /* search636_1 -> 1900 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_iand,
      0, 1,
      { 1899, 1900 },
      -1,
   } },

   /* replace636_0_0 -> 0 in the cache */
   /* replace636_0_1 -> 1817 in the cache */
   /* replace636_0 -> 1912 in the cache */
   /* replace636_1 -> 813 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ult,
      -1, 1,
      { 1912, 813 },
      -1,
   } },

   /* ('iand', ('uge(is_used_once)', 'a', 'b'), ('uge', 'a', 'c')) => ('uge', 'a', ('umax', 'b', 'c')) */
   /* search637_0_0 -> 143 in the cache */
   /* search637_0_1 -> 144 in the cache */
   /* search637_0 -> 1904 in the cache */
   /* search637_1_0 -> 143 in the cache */
   /* search637_1_1 -> 146 in the cache */
   /* search637_1 -> 1905 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_iand,
      0, 1,
      { 1904, 1905 },
      -1,
   } },

   /* replace637_0 -> 143 in the cache */
   /* replace637_1_0 -> 144 in the cache */
   /* replace637_1_1 -> 146 in the cache */
   /* replace637_1 -> 1897 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_uge,
      -1, 1,
      { 143, 1897 },
      -1,
   } },

   /* ('iand', ('uge(is_used_once)', 'a', 'c'), ('uge', 'b', 'c')) => ('uge', ('umin', 'a', 'b'), 'c') */
   /* search638_0_0 -> 0 in the cache */
   /* search638_0_1 -> 813 in the cache */
   /* search638_0 -> 1909 in the cache */
   /* search638_1_0 -> 1817 in the cache */
   /* search638_1_1 -> 813 in the cache */
   /* search638_1 -> 1910 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_iand,
      0, 1,
      { 1909, 1910 },
      -1,
   } },

   /* replace638_0_0 -> 0 in the cache */
   /* replace638_0_1 -> 1817 in the cache */
   /* replace638_0 -> 1902 in the cache */
   /* replace638_1 -> 813 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_uge,
      -1, 1,
      { 1902, 813 },
      -1,
   } },

   /* ('ior', ('ior(is_used_once)', ('flt(is_used_once)', 'a', 'c'), 'd'), ('flt', 'b', 'c')) => ('ior', ('flt', ('!fmin', 'a', 'b'), 'c'), 'd') */
   /* search639_0_0_0 -> 0 in the cache */
   /* search639_0_0_1 -> 813 in the cache */
   /* search639_0_0 -> 1816 in the cache */
   { .variable = {
      { nir_search_value_variable, 1 },
      2, /* d */
      false,
      nir_type_invalid,
      -1,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ior,
      1, 1,
      { 1816, 1930 },
      0,
   } },
   { .variable = {
      { nir_search_value_variable, -2 },
      3, /* b */
      false,
      nir_type_invalid,
      -1,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   /* search639_1_1 -> 813 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_flt,
      -1, 0,
      { 1932, 813 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ior,
      0, 2,
      { 1931, 1933 },
      -1,
   } },

   /* replace639_0_0_0 -> 0 in the cache */
   /* replace639_0_0_1 -> 1932 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      true,
      false,
      false,
      false,
      false,
      nir_op_fmin,
      1, 1,
      { 0, 1932 },
      -1,
   } },
   /* replace639_0_1 -> 813 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_flt,
      -1, 1,
      { 1935, 813 },
      -1,
   } },
   /* replace639_1 -> 1930 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ior,
      0, 2,
      { 1936, 1930 },
      -1,
   } },

   /* ('ior', ('ior(is_used_once)', ('flt', 'a', 'c'), 'd'), ('flt(is_used_once)', 'b', 'c')) => ('ior', ('flt', ('!fmin', 'a', 'b'), 'c'), 'd') */
   /* search640_0_0_0 -> 0 in the cache */
   /* search640_0_0_1 -> 813 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_flt,
      -1, 0,
      { 0, 813 },
      -1,
   } },
   /* search640_0_1 -> 1930 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ior,
      1, 1,
      { 1938, 1930 },
      0,
   } },
   /* search640_1_0 -> 1932 in the cache */
   /* search640_1_1 -> 813 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_flt,
      -1, 0,
      { 1932, 813 },
      0,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ior,
      0, 2,
      { 1939, 1940 },
      -1,
   } },

   /* replace640_0_0_0 -> 0 in the cache */
   /* replace640_0_0_1 -> 1932 in the cache */
   /* replace640_0_0 -> 1935 in the cache */
   /* replace640_0_1 -> 813 in the cache */
   /* replace640_0 -> 1936 in the cache */
   /* replace640_1 -> 1930 in the cache */
   /* replace640 -> 1937 in the cache */

   /* ('ior', ('ior(is_used_once)', ('flt(is_used_once)', 'a', 'b'), 'd'), ('flt', 'a', 'c')) => ('ior', ('flt', 'a', ('!fmax', 'b', 'c')), 'd') */
   /* search641_0_0_0 -> 166 in the cache */
   /* search641_0_0_1 -> 167 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_flt,
      -1, 0,
      { 166, 167 },
      0,
   } },
   /* search641_0_1 -> 1930 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ior,
      1, 1,
      { 1942, 1930 },
      0,
   } },
   /* search641_1_0 -> 166 in the cache */
   { .variable = {
      { nir_search_value_variable, -4 },
      3, /* c */
      false,
      nir_type_invalid,
      -1,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_flt,
      -1, 0,
      { 166, 1944 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ior,
      0, 2,
      { 1943, 1945 },
      -1,
   } },

   /* replace641_0_0 -> 166 in the cache */
   /* replace641_0_1_0 -> 167 in the cache */
   /* replace641_0_1_1 -> 1944 in the cache */
   { .expression = {
      { nir_search_value_expression, -4 },
      false,
      true,
      false,
      false,
      false,
      false,
      nir_op_fmax,
      1, 1,
      { 167, 1944 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_flt,
      -1, 1,
      { 166, 1947 },
      -1,
   } },
   /* replace641_1 -> 1930 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ior,
      0, 2,
      { 1948, 1930 },
      -1,
   } },

   /* ('ior', ('ior(is_used_once)', ('flt', 'a', 'b'), 'd'), ('flt(is_used_once)', 'a', 'c')) => ('ior', ('flt', 'a', ('!fmax', 'b', 'c')), 'd') */
   /* search642_0_0_0 -> 166 in the cache */
   /* search642_0_0_1 -> 167 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_flt,
      -1, 0,
      { 166, 167 },
      -1,
   } },
   /* search642_0_1 -> 1930 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ior,
      1, 1,
      { 1950, 1930 },
      0,
   } },
   /* search642_1_0 -> 166 in the cache */
   /* search642_1_1 -> 1944 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_flt,
      -1, 0,
      { 166, 1944 },
      0,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ior,
      0, 2,
      { 1951, 1952 },
      -1,
   } },

   /* replace642_0_0 -> 166 in the cache */
   /* replace642_0_1_0 -> 167 in the cache */
   /* replace642_0_1_1 -> 1944 in the cache */
   /* replace642_0_1 -> 1947 in the cache */
   /* replace642_0 -> 1948 in the cache */
   /* replace642_1 -> 1930 in the cache */
   /* replace642 -> 1949 in the cache */

   /* ('ior', ('flt', 'a(is_a_number)', 'b(is_a_number)'), ('flt', 'b', 'a')) => ('fneu', 'a', 'b') */
   /* search643_0_0 -> 1238 in the cache */
   /* search643_0_1 -> 1239 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_flt,
      -1, 0,
      { 1238, 1239 },
      -1,
   } },
   /* search643_1_0 -> 1 in the cache */
   /* search643_1_1 -> 0 in the cache */
   /* search643_1 -> 1272 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ior,
      0, 1,
      { 1954, 1272 },
      -1,
   } },

   /* replace643_0 -> 0 in the cache */
   /* replace643_1 -> 1 in the cache */
   /* replace643 -> 1246 in the cache */

   /* ('umin', ('iand', 'a', '#b(is_pos_power_of_two)'), ('iand', 'c', 'b')) => ('iand', ('iand', 'a', 'b'), ('iand', 'c', 'b')) */
   /* search644_0_0 -> 0 in the cache */
   /* search644_0_1 -> 15 in the cache */
   /* search644_0 -> 227 in the cache */
   /* search644_1_0 -> 157 in the cache */
   /* search644_1_1 -> 1 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_iand,
      2, 1,
      { 157, 1 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_umin,
      0, 3,
      { 227, 1956 },
      -1,
   } },

   /* replace644_0_0 -> 0 in the cache */
   /* replace644_0_1 -> 1 in the cache */
   /* replace644_0 -> 229 in the cache */
   /* replace644_1_0 -> 157 in the cache */
   /* replace644_1_1 -> 1 in the cache */
   /* replace644_1 -> 1956 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_iand,
      0, 3,
      { 229, 1956 },
      -1,
   } },

   /* ('ior', ('flt(is_used_once)', 0.0, 'a@16'), ('flt', 'b@16', 0.0)) => ('flt', 0.0, ('fmax', 'a', ('fneg', 'b'))) */
   /* search645_0_0 -> 839 in the cache */
   /* search645_0_1 -> 24 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_flt,
      -1, 0,
      { 839, 24 },
      0,
   } },
   /* search645_1_0 -> 595 in the cache */
   /* search645_1_1 -> 839 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_flt,
      -1, 0,
      { 595, 839 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ior,
      0, 1,
      { 1959, 1960 },
      -1,
   } },

   /* replace645_0 -> 839 in the cache */
   /* replace645_1_0 -> 24 in the cache */
   /* replace645_1_1_0 -> 595 in the cache */
   /* replace645_1_1 -> 665 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fmax,
      0, 1,
      { 24, 665 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_flt,
      -1, 1,
      { 839, 1962 },
      -1,
   } },

   /* ('ior', ('flt', 0.0, 'a@16'), ('flt(is_used_once)', 'b@16', 0.0)) => ('flt', 0.0, ('fmax', 'a', ('fneg', 'b'))) */
   /* search646_0_0 -> 839 in the cache */
   /* search646_0_1 -> 24 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_flt,
      -1, 0,
      { 839, 24 },
      -1,
   } },
   /* search646_1_0 -> 595 in the cache */
   /* search646_1_1 -> 839 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_flt,
      -1, 0,
      { 595, 839 },
      0,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ior,
      0, 1,
      { 1964, 1965 },
      -1,
   } },

   /* replace646_0 -> 839 in the cache */
   /* replace646_1_0 -> 24 in the cache */
   /* replace646_1_1_0 -> 595 in the cache */
   /* replace646_1_1 -> 665 in the cache */
   /* replace646_1 -> 1962 in the cache */
   /* replace646 -> 1963 in the cache */

   /* ('ior', ('fge(is_used_once)', 0.0, 'a@16'), ('fge', 'b@16', 0.0)) => ('fge', 0.0, ('fmin', 'a', ('fneg', 'b'))) */
   /* search647_0_0 -> 839 in the cache */
   /* search647_0_1 -> 24 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fge,
      -1, 0,
      { 839, 24 },
      0,
   } },
   /* search647_1_0 -> 595 in the cache */
   /* search647_1_1 -> 839 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fge,
      -1, 0,
      { 595, 839 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ior,
      0, 1,
      { 1967, 1968 },
      -1,
   } },

   /* replace647_0 -> 839 in the cache */
   /* replace647_1_0 -> 24 in the cache */
   /* replace647_1_1_0 -> 595 in the cache */
   /* replace647_1_1 -> 665 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fmin,
      0, 1,
      { 24, 665 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fge,
      -1, 1,
      { 839, 1970 },
      -1,
   } },

   /* ('ior', ('fge', 0.0, 'a@16'), ('fge(is_used_once)', 'b@16', 0.0)) => ('fge', 0.0, ('fmin', 'a', ('fneg', 'b'))) */
   /* search648_0_0 -> 839 in the cache */
   /* search648_0_1 -> 24 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fge,
      -1, 0,
      { 839, 24 },
      -1,
   } },
   /* search648_1_0 -> 595 in the cache */
   /* search648_1_1 -> 839 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fge,
      -1, 0,
      { 595, 839 },
      0,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ior,
      0, 1,
      { 1972, 1973 },
      -1,
   } },

   /* replace648_0 -> 839 in the cache */
   /* replace648_1_0 -> 24 in the cache */
   /* replace648_1_1_0 -> 595 in the cache */
   /* replace648_1_1 -> 665 in the cache */
   /* replace648_1 -> 1970 in the cache */
   /* replace648 -> 1971 in the cache */

   /* ('~iand', ('flt(is_used_once)', 0.0, 'a@16'), ('flt', 'b@16', 0.0)) => ('flt', 0.0, ('fmin', 'a', ('fneg', 'b'))) */
   /* search649_0_0 -> 839 in the cache */
   /* search649_0_1 -> 24 in the cache */
   /* search649_0 -> 1959 in the cache */
   /* search649_1_0 -> 595 in the cache */
   /* search649_1_1 -> 839 in the cache */
   /* search649_1 -> 1960 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      true,
      false,
      false,
      false,
      false,
      false,
      nir_op_iand,
      0, 1,
      { 1959, 1960 },
      -1,
   } },

   /* replace649_0 -> 839 in the cache */
   /* replace649_1_0 -> 24 in the cache */
   /* replace649_1_1_0 -> 595 in the cache */
   /* replace649_1_1 -> 665 in the cache */
   /* replace649_1 -> 1970 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_flt,
      -1, 1,
      { 839, 1970 },
      -1,
   } },

   /* ('~iand', ('flt', 0.0, 'a@16'), ('flt(is_used_once)', 'b@16', 0.0)) => ('flt', 0.0, ('fmin', 'a', ('fneg', 'b'))) */
   /* search650_0_0 -> 839 in the cache */
   /* search650_0_1 -> 24 in the cache */
   /* search650_0 -> 1964 in the cache */
   /* search650_1_0 -> 595 in the cache */
   /* search650_1_1 -> 839 in the cache */
   /* search650_1 -> 1965 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      true,
      false,
      false,
      false,
      false,
      false,
      nir_op_iand,
      0, 1,
      { 1964, 1965 },
      -1,
   } },

   /* replace650_0 -> 839 in the cache */
   /* replace650_1_0 -> 24 in the cache */
   /* replace650_1_1_0 -> 595 in the cache */
   /* replace650_1_1 -> 665 in the cache */
   /* replace650_1 -> 1970 in the cache */
   /* replace650 -> 1976 in the cache */

   /* ('~iand', ('fge(is_used_once)', 0.0, 'a@16'), ('fge', 'b@16', 0.0)) => ('fge', 0.0, ('fmax', 'a', ('fneg', 'b'))) */
   /* search651_0_0 -> 839 in the cache */
   /* search651_0_1 -> 24 in the cache */
   /* search651_0 -> 1967 in the cache */
   /* search651_1_0 -> 595 in the cache */
   /* search651_1_1 -> 839 in the cache */
   /* search651_1 -> 1968 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      true,
      false,
      false,
      false,
      false,
      false,
      nir_op_iand,
      0, 1,
      { 1967, 1968 },
      -1,
   } },

   /* replace651_0 -> 839 in the cache */
   /* replace651_1_0 -> 24 in the cache */
   /* replace651_1_1_0 -> 595 in the cache */
   /* replace651_1_1 -> 665 in the cache */
   /* replace651_1 -> 1962 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fge,
      -1, 1,
      { 839, 1962 },
      -1,
   } },

   /* ('~iand', ('fge', 0.0, 'a@16'), ('fge(is_used_once)', 'b@16', 0.0)) => ('fge', 0.0, ('fmax', 'a', ('fneg', 'b'))) */
   /* search652_0_0 -> 839 in the cache */
   /* search652_0_1 -> 24 in the cache */
   /* search652_0 -> 1972 in the cache */
   /* search652_1_0 -> 595 in the cache */
   /* search652_1_1 -> 839 in the cache */
   /* search652_1 -> 1973 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      true,
      false,
      false,
      false,
      false,
      false,
      nir_op_iand,
      0, 1,
      { 1972, 1973 },
      -1,
   } },

   /* replace652_0 -> 839 in the cache */
   /* replace652_1_0 -> 24 in the cache */
   /* replace652_1_1_0 -> 595 in the cache */
   /* replace652_1_1 -> 665 in the cache */
   /* replace652_1 -> 1962 in the cache */
   /* replace652 -> 1979 in the cache */

   /* ('ior', ('feq(is_used_once)', 'a@16', 0.0), ('feq', 'b@16', 0.0)) => ('feq', ('fmin', ('fabs', 'a'), ('fabs', 'b')), 0.0) */
   /* search653_0_0 -> 24 in the cache */
   /* search653_0_1 -> 839 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_feq,
      1, 1,
      { 24, 839 },
      0,
   } },
   /* search653_1_0 -> 595 in the cache */
   /* search653_1_1 -> 839 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_feq,
      2, 1,
      { 595, 839 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ior,
      0, 3,
      { 1981, 1982 },
      -1,
   } },

   /* replace653_0_0_0 -> 24 in the cache */
   /* replace653_0_0 -> 511 in the cache */
   /* replace653_0_1_0 -> 595 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fabs,
      -1, 0,
      { 595 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fmin,
      1, 1,
      { 511, 1984 },
      -1,
   } },
   /* replace653_1 -> 839 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_feq,
      0, 2,
      { 1985, 839 },
      -1,
   } },

   /* ('ior', ('fneu(is_used_once)', 'a@16', 0.0), ('fneu', 'b@16', 0.0)) => ('fneu', ('fadd', ('fabs', 'a'), ('fabs', 'b')), 0.0) */
   /* search654_0_0 -> 24 in the cache */
   /* search654_0_1 -> 839 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fneu,
      1, 1,
      { 24, 839 },
      0,
   } },
   /* search654_1_0 -> 595 in the cache */
   /* search654_1_1 -> 839 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fneu,
      2, 1,
      { 595, 839 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ior,
      0, 3,
      { 1987, 1988 },
      -1,
   } },

   /* replace654_0_0_0 -> 24 in the cache */
   /* replace654_0_0 -> 511 in the cache */
   /* replace654_0_1_0 -> 595 in the cache */
   /* replace654_0_1 -> 1984 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fadd,
      1, 1,
      { 511, 1984 },
      -1,
   } },
   /* replace654_1 -> 839 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fneu,
      0, 2,
      { 1990, 839 },
      -1,
   } },

   /* ('iand', ('feq(is_used_once)', 'a@16', 0.0), ('feq', 'b@16', 0.0)) => ('feq', ('fadd', ('fabs', 'a'), ('fabs', 'b')), 0.0) */
   /* search655_0_0 -> 24 in the cache */
   /* search655_0_1 -> 839 in the cache */
   /* search655_0 -> 1981 in the cache */
   /* search655_1_0 -> 595 in the cache */
   /* search655_1_1 -> 839 in the cache */
   /* search655_1 -> 1982 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_iand,
      0, 3,
      { 1981, 1982 },
      -1,
   } },

   /* replace655_0_0_0 -> 24 in the cache */
   /* replace655_0_0 -> 511 in the cache */
   /* replace655_0_1_0 -> 595 in the cache */
   /* replace655_0_1 -> 1984 in the cache */
   /* replace655_0 -> 1990 in the cache */
   /* replace655_1 -> 839 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_feq,
      0, 2,
      { 1990, 839 },
      -1,
   } },

   /* ('iand', ('fneu(is_used_once)', 'a@16', 0.0), ('fneu', 'b@16', 0.0)) => ('fneu', ('fmin', ('fabs', 'a'), ('fabs', 'b')), 0.0) */
   /* search656_0_0 -> 24 in the cache */
   /* search656_0_1 -> 839 in the cache */
   /* search656_0 -> 1987 in the cache */
   /* search656_1_0 -> 595 in the cache */
   /* search656_1_1 -> 839 in the cache */
   /* search656_1 -> 1988 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_iand,
      0, 3,
      { 1987, 1988 },
      -1,
   } },

   /* replace656_0_0_0 -> 24 in the cache */
   /* replace656_0_0 -> 511 in the cache */
   /* replace656_0_1_0 -> 595 in the cache */
   /* replace656_0_1 -> 1984 in the cache */
   /* replace656_0 -> 1985 in the cache */
   /* replace656_1 -> 839 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fneu,
      0, 2,
      { 1985, 839 },
      -1,
   } },

   /* ('bcsel@16', ('feq', 'a', 0.0), 1.0, ('i2f16', ('iadd', ('b2i16', ('flt', 0.0, 'a@16')), ('ineg', ('b2i16', ('flt', 'a@16', 0.0)))))) => ('i2f16', ('iadd', ('b2i32', ('!fge', 'a', 0.0)), ('ineg', ('b2i32', ('!flt', 'a', 0.0))))) */
   /* search657_0_0 -> 24 in the cache */
   /* search657_0_1 -> 839 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_feq,
      0, 1,
      { 24, 839 },
      -1,
   } },
   /* search657_1 -> 613 in the cache */
   /* search657_2_0_0_0_0 -> 839 in the cache */
   /* search657_2_0_0_0_1 -> 24 in the cache */
   /* search657_2_0_0_0 -> 1964 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_b2i16,
      -1, 0,
      { 1964 },
      -1,
   } },
   /* search657_2_0_1_0_0_0 -> 24 in the cache */
   /* search657_2_0_1_0_0_1 -> 839 in the cache */
   /* search657_2_0_1_0_0 -> 840 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_b2i16,
      -1, 0,
      { 840 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ineg,
      -1, 0,
      { 1998 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_iadd,
      1, 1,
      { 1997, 1999 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_i2f16,
      -1, 1,
      { 2000 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_bcsel,
      -1, 2,
      { 1996, 613, 2001 },
      -1,
   } },

   /* replace657_0_0_0_0 -> 24 in the cache */
   /* replace657_0_0_0_1 -> 839 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      true,
      false,
      false,
      false,
      false,
      nir_op_fge,
      -1, 0,
      { 24, 839 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_b2i32,
      -1, 0,
      { 2003 },
      -1,
   } },
   /* replace657_0_1_0_0_0 -> 24 in the cache */
   /* replace657_0_1_0_0_1 -> 839 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      true,
      false,
      false,
      false,
      false,
      nir_op_flt,
      -1, 0,
      { 24, 839 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_b2i32,
      -1, 0,
      { 2005 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ineg,
      -1, 0,
      { 2006 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_iadd,
      0, 1,
      { 2004, 2007 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_i2f16,
      -1, 1,
      { 2008 },
      -1,
   } },

   /* ('bcsel', 'a', ('b2f(is_used_once)', 'b@16'), ('b2f', 'c@16')) => ('b2f', ('bcsel', 'a', 'b', 'c')) */
   /* search658_0 -> 907 in the cache */
   /* search658_1_0 -> 595 in the cache */
   { .expression = {
      { nir_search_value_expression, 0 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_search_op_b2f,
      -1, 0,
      { 595 },
      0,
   } },
   /* search658_2_0 -> 601 in the cache */
   { .expression = {
      { nir_search_value_expression, 0 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_search_op_b2f,
      -1, 0,
      { 601 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 0 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_bcsel,
      -1, 0,
      { 907, 2010, 2011 },
      -1,
   } },

   /* replace658_0_0 -> 907 in the cache */
   /* replace658_0_1 -> 595 in the cache */
   /* replace658_0_2 -> 601 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_bcsel,
      -1, 0,
      { 907, 595, 601 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 0 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_search_op_b2f,
      -1, 0,
      { 2013 },
      -1,
   } },

   /* ('~i2f16', ('f2i', 'a@16')) => ('ftrunc', 'a') */
   /* search659_0_0 -> 24 in the cache */
   { .expression = {
      { nir_search_value_expression, 0 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_search_op_f2i,
      -1, 0,
      { 24 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 16 },
      true,
      false,
      false,
      false,
      false,
      false,
      nir_op_i2f16,
      -1, 0,
      { 2015 },
      -1,
   } },

   /* replace659_0 -> 24 in the cache */
   /* replace659 -> 838 in the cache */

   /* ('~f2i16', ('i2f', 'a@16')) => a */
   /* search660_0_0 -> 24 in the cache */
   { .expression = {
      { nir_search_value_expression, 0 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_search_op_i2f,
      -1, 0,
      { 24 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 16 },
      true,
      false,
      false,
      false,
      false,
      false,
      nir_op_f2i16,
      -1, 0,
      { 2017 },
      -1,
   } },

   /* replace660 -> 24 in the cache */

   /* ('~f2i16', ('u2f', 'a@16')) => a */
   /* search661_0_0 -> 24 in the cache */
   { .expression = {
      { nir_search_value_expression, 0 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_search_op_u2f,
      -1, 0,
      { 24 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 16 },
      true,
      false,
      false,
      false,
      false,
      false,
      nir_op_f2i16,
      -1, 0,
      { 2019 },
      -1,
   } },

   /* replace661 -> 24 in the cache */

   /* ('~f2u16', ('i2f', 'a@16')) => a */
   /* search662_0_0 -> 24 in the cache */
   /* search662_0 -> 2017 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      true,
      false,
      false,
      false,
      false,
      false,
      nir_op_f2u16,
      -1, 0,
      { 2017 },
      -1,
   } },

   /* replace662 -> 24 in the cache */

   /* ('~f2u16', ('u2f', 'a@16')) => a */
   /* search663_0_0 -> 24 in the cache */
   /* search663_0 -> 2019 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      true,
      false,
      false,
      false,
      false,
      false,
      nir_op_f2u16,
      -1, 0,
      { 2019 },
      -1,
   } },

   /* replace663 -> 24 in the cache */

   /* ('fadd', ('b2f16', ('flt', 0.0, 'a@16')), ('fneg', ('b2f16', ('flt', 'a@16', 0.0)))) => ('fsign', 'a') */
   /* search664_0_0_0 -> 839 in the cache */
   /* search664_0_0_1 -> 24 in the cache */
   /* search664_0_0 -> 1964 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_b2f16,
      -1, 0,
      { 1964 },
      -1,
   } },
   /* search664_1_0_0_0 -> 24 in the cache */
   /* search664_1_0_0_1 -> 839 in the cache */
   /* search664_1_0_0 -> 840 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_b2f16,
      -1, 0,
      { 840 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fneg,
      -1, 0,
      { 2024 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fadd,
      0, 1,
      { 2023, 2025 },
      -1,
   } },

   /* replace664_0 -> 24 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fsign,
      -1, 0,
      { 24 },
      -1,
   } },

   /* ('iadd', ('b2i16', ('flt', 0, 'a@16')), ('ineg', ('b2i16', ('flt', 'a@16', 0)))) => ('f2i16', ('fsign', 'a')) */
   /* search665_0_0_0 -> 1006 in the cache */
   /* search665_0_0_1 -> 24 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_flt,
      -1, 0,
      { 1006, 24 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_b2i16,
      -1, 0,
      { 2028 },
      -1,
   } },
   /* search665_1_0_0_0 -> 24 in the cache */
   /* search665_1_0_0_1 -> 1006 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_flt,
      -1, 0,
      { 24, 1006 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_b2i16,
      -1, 0,
      { 2030 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ineg,
      -1, 0,
      { 2031 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_iadd,
      0, 1,
      { 2029, 2032 },
      -1,
   } },

   /* replace665_0_0 -> 24 in the cache */
   /* replace665_0 -> 2027 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_f2i16,
      -1, 0,
      { 2027 },
      -1,
   } },

   /* ('~f2f16', ('f2f', 'a')) => ('f2f16', 'a') */
   /* search666_0_0 -> 9 in the cache */
   { .expression = {
      { nir_search_value_expression, 0 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_search_op_f2f,
      -1, 0,
      { 9 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 16 },
      true,
      false,
      false,
      false,
      false,
      false,
      nir_op_f2f16,
      -1, 0,
      { 2035 },
      -1,
   } },

   /* replace666_0 -> 9 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_f2f16,
      -1, 0,
      { 9 },
      -1,
   } },

   /* ('~f2f16', ('u2f', 'a')) => ('u2f16', 'a') */
   /* search667_0_0 -> 9 in the cache */
   /* search667_0 -> 123 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      true,
      false,
      false,
      false,
      false,
      false,
      nir_op_f2f16,
      -1, 0,
      { 123 },
      -1,
   } },

   /* replace667_0 -> 9 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_u2f16,
      -1, 0,
      { 9 },
      -1,
   } },

   /* ('~f2f16', ('i2f', 'a')) => ('i2f16', 'a') */
   /* search668_0_0 -> 9 in the cache */
   /* search668_0 -> 1468 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      true,
      false,
      false,
      false,
      false,
      false,
      nir_op_f2f16,
      -1, 0,
      { 1468 },
      -1,
   } },

   /* replace668_0 -> 9 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_i2f16,
      -1, 0,
      { 9 },
      -1,
   } },

   /* ('~f2u16', ('f2f', 'a')) => ('f2u16', 'a') */
   /* search669_0_0 -> 9 in the cache */
   /* search669_0 -> 2035 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      true,
      false,
      false,
      false,
      false,
      false,
      nir_op_f2u16,
      -1, 0,
      { 2035 },
      -1,
   } },

   /* replace669_0 -> 9 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_f2u16,
      -1, 0,
      { 9 },
      -1,
   } },

   /* ('~f2i16', ('f2f', 'a')) => ('f2i16', 'a') */
   /* search670_0_0 -> 9 in the cache */
   /* search670_0 -> 2035 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      true,
      false,
      false,
      false,
      false,
      false,
      nir_op_f2i16,
      -1, 0,
      { 2035 },
      -1,
   } },

   /* replace670_0 -> 9 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_f2i16,
      -1, 0,
      { 9 },
      -1,
   } },

   /* ('i2f16', ('f2i', ('fsign', 'a@16'))) => ('fsign', 'a') */
   /* search671_0_0_0 -> 24 in the cache */
   /* search671_0_0 -> 2027 in the cache */
   { .expression = {
      { nir_search_value_expression, 0 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_search_op_f2i,
      -1, 0,
      { 2027 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_i2f16,
      -1, 0,
      { 2046 },
      -1,
   } },

   /* replace671_0 -> 24 in the cache */
   /* replace671 -> 2027 in the cache */

   /* ('~f2f16', ('f2f32', 'a@16')) => a */
   /* search672_0_0 -> 24 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_f2f32,
      -1, 0,
      { 24 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 16 },
      true,
      false,
      false,
      false,
      false,
      false,
      nir_op_f2f16,
      -1, 0,
      { 2048 },
      -1,
   } },

   /* replace672 -> 24 in the cache */

   /* ('f2u32', ('f2f32', 'a@16')) => ('f2u32', 'a') */
   /* search673_0_0 -> 24 in the cache */
   /* search673_0 -> 2048 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_f2u32,
      -1, 0,
      { 2048 },
      -1,
   } },

   /* replace673_0 -> 24 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_f2u32,
      -1, 0,
      { 24 },
      -1,
   } },

   /* ('f2i32', ('f2f32', 'a@16')) => ('f2i32', 'a') */
   /* search674_0_0 -> 24 in the cache */
   /* search674_0 -> 2048 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_f2i32,
      -1, 0,
      { 2048 },
      -1,
   } },

   /* replace674_0 -> 24 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_f2i32,
      -1, 0,
      { 24 },
      -1,
   } },

   /* ('f2f16', ('u2f32', 'a')) => ('u2f16', 'a') */
   /* search675_0_0 -> 9 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_u2f32,
      -1, 0,
      { 9 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_f2f16,
      -1, 0,
      { 2054 },
      -1,
   } },

   /* replace675_0 -> 9 in the cache */
   /* replace675 -> 2039 in the cache */

   /* ('f2f16', ('i2f32', 'a')) => ('i2f16', 'a') */
   /* search676_0_0 -> 9 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_i2f32,
      -1, 0,
      { 9 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_f2f16,
      -1, 0,
      { 2056 },
      -1,
   } },

   /* replace676_0 -> 9 in the cache */
   /* replace676 -> 2041 in the cache */

   /* ('~f2f16', ('f2f64', 'a@16')) => a */
   /* search677_0_0 -> 24 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_f2f64,
      -1, 0,
      { 24 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 16 },
      true,
      false,
      false,
      false,
      false,
      false,
      nir_op_f2f16,
      -1, 0,
      { 2058 },
      -1,
   } },

   /* replace677 -> 24 in the cache */

   /* ('f2u64', ('f2f64', 'a@16')) => ('f2u64', 'a') */
   /* search678_0_0 -> 24 in the cache */
   /* search678_0 -> 2058 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_f2u64,
      -1, 0,
      { 2058 },
      -1,
   } },

   /* replace678_0 -> 24 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_f2u64,
      -1, 0,
      { 24 },
      -1,
   } },

   /* ('f2i64', ('f2f64', 'a@16')) => ('f2i64', 'a') */
   /* search679_0_0 -> 24 in the cache */
   /* search679_0 -> 2058 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_f2i64,
      -1, 0,
      { 2058 },
      -1,
   } },

   /* replace679_0 -> 24 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_f2i64,
      -1, 0,
      { 24 },
      -1,
   } },

   /* ('f2f16', ('u2f64', 'a')) => ('u2f16', 'a') */
   /* search680_0_0 -> 9 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_u2f64,
      -1, 0,
      { 9 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_f2f16,
      -1, 0,
      { 2064 },
      -1,
   } },

   /* replace680_0 -> 9 in the cache */
   /* replace680 -> 2039 in the cache */

   /* ('f2f16', ('i2f64', 'a')) => ('i2f16', 'a') */
   /* search681_0_0 -> 9 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_i2f64,
      -1, 0,
      { 9 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_f2f16,
      -1, 0,
      { 2066 },
      -1,
   } },

   /* replace681_0 -> 9 in the cache */
   /* replace681 -> 2041 in the cache */

   /* ('ior', ('flt(is_used_once)', 0.0, 'a@32'), ('flt', 'b@32', 0.0)) => ('flt', 0.0, ('fmax', 'a', ('fneg', 'b'))) */
   /* search682_0_0 -> 255 in the cache */
   /* search682_0_1 -> 29 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_flt,
      -1, 0,
      { 255, 29 },
      0,
   } },
   /* search682_1_0 -> 48 in the cache */
   /* search682_1_1 -> 255 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_flt,
      -1, 0,
      { 48, 255 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ior,
      0, 1,
      { 2068, 2069 },
      -1,
   } },

   /* replace682_0 -> 255 in the cache */
   /* replace682_1_0 -> 29 in the cache */
   /* replace682_1_1_0 -> 48 in the cache */
   /* replace682_1_1 -> 730 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fmax,
      0, 1,
      { 29, 730 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_flt,
      -1, 1,
      { 255, 2071 },
      -1,
   } },

   /* ('ior', ('flt', 0.0, 'a@32'), ('flt(is_used_once)', 'b@32', 0.0)) => ('flt', 0.0, ('fmax', 'a', ('fneg', 'b'))) */
   /* search683_0_0 -> 255 in the cache */
   /* search683_0_1 -> 29 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_flt,
      -1, 0,
      { 255, 29 },
      -1,
   } },
   /* search683_1_0 -> 48 in the cache */
   /* search683_1_1 -> 255 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_flt,
      -1, 0,
      { 48, 255 },
      0,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ior,
      0, 1,
      { 2073, 2074 },
      -1,
   } },

   /* replace683_0 -> 255 in the cache */
   /* replace683_1_0 -> 29 in the cache */
   /* replace683_1_1_0 -> 48 in the cache */
   /* replace683_1_1 -> 730 in the cache */
   /* replace683_1 -> 2071 in the cache */
   /* replace683 -> 2072 in the cache */

   /* ('ior', ('fge(is_used_once)', 0.0, 'a@32'), ('fge', 'b@32', 0.0)) => ('fge', 0.0, ('fmin', 'a', ('fneg', 'b'))) */
   /* search684_0_0 -> 255 in the cache */
   /* search684_0_1 -> 29 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fge,
      -1, 0,
      { 255, 29 },
      0,
   } },
   /* search684_1_0 -> 48 in the cache */
   /* search684_1_1 -> 255 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fge,
      -1, 0,
      { 48, 255 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ior,
      0, 1,
      { 2076, 2077 },
      -1,
   } },

   /* replace684_0 -> 255 in the cache */
   /* replace684_1_0 -> 29 in the cache */
   /* replace684_1_1_0 -> 48 in the cache */
   /* replace684_1_1 -> 730 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fmin,
      0, 1,
      { 29, 730 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fge,
      -1, 1,
      { 255, 2079 },
      -1,
   } },

   /* ('ior', ('fge', 0.0, 'a@32'), ('fge(is_used_once)', 'b@32', 0.0)) => ('fge', 0.0, ('fmin', 'a', ('fneg', 'b'))) */
   /* search685_0_0 -> 255 in the cache */
   /* search685_0_1 -> 29 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fge,
      -1, 0,
      { 255, 29 },
      -1,
   } },
   /* search685_1_0 -> 48 in the cache */
   /* search685_1_1 -> 255 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fge,
      -1, 0,
      { 48, 255 },
      0,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ior,
      0, 1,
      { 2081, 2082 },
      -1,
   } },

   /* replace685_0 -> 255 in the cache */
   /* replace685_1_0 -> 29 in the cache */
   /* replace685_1_1_0 -> 48 in the cache */
   /* replace685_1_1 -> 730 in the cache */
   /* replace685_1 -> 2079 in the cache */
   /* replace685 -> 2080 in the cache */

   /* ('~iand', ('flt(is_used_once)', 0.0, 'a@32'), ('flt', 'b@32', 0.0)) => ('flt', 0.0, ('fmin', 'a', ('fneg', 'b'))) */
   /* search686_0_0 -> 255 in the cache */
   /* search686_0_1 -> 29 in the cache */
   /* search686_0 -> 2068 in the cache */
   /* search686_1_0 -> 48 in the cache */
   /* search686_1_1 -> 255 in the cache */
   /* search686_1 -> 2069 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      true,
      false,
      false,
      false,
      false,
      false,
      nir_op_iand,
      0, 1,
      { 2068, 2069 },
      -1,
   } },

   /* replace686_0 -> 255 in the cache */
   /* replace686_1_0 -> 29 in the cache */
   /* replace686_1_1_0 -> 48 in the cache */
   /* replace686_1_1 -> 730 in the cache */
   /* replace686_1 -> 2079 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_flt,
      -1, 1,
      { 255, 2079 },
      -1,
   } },

   /* ('~iand', ('flt', 0.0, 'a@32'), ('flt(is_used_once)', 'b@32', 0.0)) => ('flt', 0.0, ('fmin', 'a', ('fneg', 'b'))) */
   /* search687_0_0 -> 255 in the cache */
   /* search687_0_1 -> 29 in the cache */
   /* search687_0 -> 2073 in the cache */
   /* search687_1_0 -> 48 in the cache */
   /* search687_1_1 -> 255 in the cache */
   /* search687_1 -> 2074 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      true,
      false,
      false,
      false,
      false,
      false,
      nir_op_iand,
      0, 1,
      { 2073, 2074 },
      -1,
   } },

   /* replace687_0 -> 255 in the cache */
   /* replace687_1_0 -> 29 in the cache */
   /* replace687_1_1_0 -> 48 in the cache */
   /* replace687_1_1 -> 730 in the cache */
   /* replace687_1 -> 2079 in the cache */
   /* replace687 -> 2085 in the cache */

   /* ('~iand', ('fge(is_used_once)', 0.0, 'a@32'), ('fge', 'b@32', 0.0)) => ('fge', 0.0, ('fmax', 'a', ('fneg', 'b'))) */
   /* search688_0_0 -> 255 in the cache */
   /* search688_0_1 -> 29 in the cache */
   /* search688_0 -> 2076 in the cache */
   /* search688_1_0 -> 48 in the cache */
   /* search688_1_1 -> 255 in the cache */
   /* search688_1 -> 2077 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      true,
      false,
      false,
      false,
      false,
      false,
      nir_op_iand,
      0, 1,
      { 2076, 2077 },
      -1,
   } },

   /* replace688_0 -> 255 in the cache */
   /* replace688_1_0 -> 29 in the cache */
   /* replace688_1_1_0 -> 48 in the cache */
   /* replace688_1_1 -> 730 in the cache */
   /* replace688_1 -> 2071 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fge,
      -1, 1,
      { 255, 2071 },
      -1,
   } },

   /* ('~iand', ('fge', 0.0, 'a@32'), ('fge(is_used_once)', 'b@32', 0.0)) => ('fge', 0.0, ('fmax', 'a', ('fneg', 'b'))) */
   /* search689_0_0 -> 255 in the cache */
   /* search689_0_1 -> 29 in the cache */
   /* search689_0 -> 2081 in the cache */
   /* search689_1_0 -> 48 in the cache */
   /* search689_1_1 -> 255 in the cache */
   /* search689_1 -> 2082 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      true,
      false,
      false,
      false,
      false,
      false,
      nir_op_iand,
      0, 1,
      { 2081, 2082 },
      -1,
   } },

   /* replace689_0 -> 255 in the cache */
   /* replace689_1_0 -> 29 in the cache */
   /* replace689_1_1_0 -> 48 in the cache */
   /* replace689_1_1 -> 730 in the cache */
   /* replace689_1 -> 2071 in the cache */
   /* replace689 -> 2088 in the cache */

   /* ('ior', ('feq(is_used_once)', 'a@32', 0.0), ('feq', 'b@32', 0.0)) => ('feq', ('fmin', ('fabs', 'a'), ('fabs', 'b')), 0.0) */
   /* search690_0_0 -> 29 in the cache */
   /* search690_0_1 -> 255 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_feq,
      1, 1,
      { 29, 255 },
      0,
   } },
   /* search690_1_0 -> 48 in the cache */
   /* search690_1_1 -> 255 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_feq,
      2, 1,
      { 48, 255 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ior,
      0, 3,
      { 2090, 2091 },
      -1,
   } },

   /* replace690_0_0_0 -> 29 in the cache */
   /* replace690_0_0 -> 437 in the cache */
   /* replace690_0_1_0 -> 48 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fabs,
      -1, 0,
      { 48 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fmin,
      1, 1,
      { 437, 2093 },
      -1,
   } },
   /* replace690_1 -> 255 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_feq,
      0, 2,
      { 2094, 255 },
      -1,
   } },

   /* ('ior', ('fneu(is_used_once)', 'a@32', 0.0), ('fneu', 'b@32', 0.0)) => ('fneu', ('fadd', ('fabs', 'a'), ('fabs', 'b')), 0.0) */
   /* search691_0_0 -> 29 in the cache */
   /* search691_0_1 -> 255 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fneu,
      1, 1,
      { 29, 255 },
      0,
   } },
   /* search691_1_0 -> 48 in the cache */
   /* search691_1_1 -> 255 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fneu,
      2, 1,
      { 48, 255 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ior,
      0, 3,
      { 2096, 2097 },
      -1,
   } },

   /* replace691_0_0_0 -> 29 in the cache */
   /* replace691_0_0 -> 437 in the cache */
   /* replace691_0_1_0 -> 48 in the cache */
   /* replace691_0_1 -> 2093 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fadd,
      1, 1,
      { 437, 2093 },
      -1,
   } },
   /* replace691_1 -> 255 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fneu,
      0, 2,
      { 2099, 255 },
      -1,
   } },

   /* ('iand', ('feq(is_used_once)', 'a@32', 0.0), ('feq', 'b@32', 0.0)) => ('feq', ('fadd', ('fabs', 'a'), ('fabs', 'b')), 0.0) */
   /* search692_0_0 -> 29 in the cache */
   /* search692_0_1 -> 255 in the cache */
   /* search692_0 -> 2090 in the cache */
   /* search692_1_0 -> 48 in the cache */
   /* search692_1_1 -> 255 in the cache */
   /* search692_1 -> 2091 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_iand,
      0, 3,
      { 2090, 2091 },
      -1,
   } },

   /* replace692_0_0_0 -> 29 in the cache */
   /* replace692_0_0 -> 437 in the cache */
   /* replace692_0_1_0 -> 48 in the cache */
   /* replace692_0_1 -> 2093 in the cache */
   /* replace692_0 -> 2099 in the cache */
   /* replace692_1 -> 255 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_feq,
      0, 2,
      { 2099, 255 },
      -1,
   } },

   /* ('iand', ('fneu(is_used_once)', 'a@32', 0.0), ('fneu', 'b@32', 0.0)) => ('fneu', ('fmin', ('fabs', 'a'), ('fabs', 'b')), 0.0) */
   /* search693_0_0 -> 29 in the cache */
   /* search693_0_1 -> 255 in the cache */
   /* search693_0 -> 2096 in the cache */
   /* search693_1_0 -> 48 in the cache */
   /* search693_1_1 -> 255 in the cache */
   /* search693_1 -> 2097 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_iand,
      0, 3,
      { 2096, 2097 },
      -1,
   } },

   /* replace693_0_0_0 -> 29 in the cache */
   /* replace693_0_0 -> 437 in the cache */
   /* replace693_0_1_0 -> 48 in the cache */
   /* replace693_0_1 -> 2093 in the cache */
   /* replace693_0 -> 2094 in the cache */
   /* replace693_1 -> 255 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fneu,
      0, 2,
      { 2094, 255 },
      -1,
   } },

   /* ('bcsel@32', ('feq', 'a', 0.0), 1.0, ('i2f32', ('iadd', ('b2i32', ('flt', 0.0, 'a@32')), ('ineg', ('b2i32', ('flt', 'a@32', 0.0)))))) => ('i2f32', ('iadd', ('b2i32', ('!fge', 'a', 0.0)), ('ineg', ('b2i32', ('!flt', 'a', 0.0))))) */
   /* search694_0_0 -> 29 in the cache */
   /* search694_0_1 -> 255 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_feq,
      0, 1,
      { 29, 255 },
      -1,
   } },
   /* search694_1 -> 275 in the cache */
   /* search694_2_0_0_0_0 -> 255 in the cache */
   /* search694_2_0_0_0_1 -> 29 in the cache */
   /* search694_2_0_0_0 -> 2073 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_b2i32,
      -1, 0,
      { 2073 },
      -1,
   } },
   /* search694_2_0_1_0_0_0 -> 29 in the cache */
   /* search694_2_0_1_0_0_1 -> 255 in the cache */
   /* search694_2_0_1_0_0 -> 845 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_b2i32,
      -1, 0,
      { 845 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ineg,
      -1, 0,
      { 2107 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_iadd,
      1, 1,
      { 2106, 2108 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_i2f32,
      -1, 1,
      { 2109 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_bcsel,
      -1, 2,
      { 2105, 275, 2110 },
      -1,
   } },

   /* replace694_0_0_0_0 -> 29 in the cache */
   /* replace694_0_0_0_1 -> 255 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      true,
      false,
      false,
      false,
      false,
      nir_op_fge,
      -1, 0,
      { 29, 255 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_b2i32,
      -1, 0,
      { 2112 },
      -1,
   } },
   /* replace694_0_1_0_0_0 -> 29 in the cache */
   /* replace694_0_1_0_0_1 -> 255 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      true,
      false,
      false,
      false,
      false,
      nir_op_flt,
      -1, 0,
      { 29, 255 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_b2i32,
      -1, 0,
      { 2114 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ineg,
      -1, 0,
      { 2115 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_iadd,
      0, 1,
      { 2113, 2116 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_i2f32,
      -1, 1,
      { 2117 },
      -1,
   } },

   /* ('bcsel', 'a', ('b2f(is_used_once)', 'b@32'), ('b2f', 'c@32')) => ('b2f', ('bcsel', 'a', 'b', 'c')) */
   /* search695_0 -> 907 in the cache */
   /* search695_1_0 -> 48 in the cache */
   { .expression = {
      { nir_search_value_expression, 0 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_search_op_b2f,
      -1, 0,
      { 48 },
      0,
   } },
   /* search695_2_0 -> 152 in the cache */
   { .expression = {
      { nir_search_value_expression, 0 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_search_op_b2f,
      -1, 0,
      { 152 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 0 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_bcsel,
      -1, 0,
      { 907, 2119, 2120 },
      -1,
   } },

   /* replace695_0_0 -> 907 in the cache */
   /* replace695_0_1 -> 48 in the cache */
   /* replace695_0_2 -> 152 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_bcsel,
      -1, 0,
      { 907, 48, 152 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 0 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_search_op_b2f,
      -1, 0,
      { 2122 },
      -1,
   } },

   /* ('~i2f32', ('f2i', 'a@32')) => ('ftrunc', 'a') */
   /* search696_0_0 -> 29 in the cache */
   { .expression = {
      { nir_search_value_expression, 0 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_search_op_f2i,
      -1, 0,
      { 29 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      true,
      false,
      false,
      false,
      false,
      false,
      nir_op_i2f32,
      -1, 0,
      { 2124 },
      -1,
   } },

   /* replace696_0 -> 29 in the cache */
   /* replace696 -> 844 in the cache */

   /* ('~f2i32', ('i2f', 'a@32')) => a */
   /* search697_0_0 -> 29 in the cache */
   { .expression = {
      { nir_search_value_expression, 0 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_search_op_i2f,
      -1, 0,
      { 29 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      true,
      false,
      false,
      false,
      false,
      false,
      nir_op_f2i32,
      -1, 0,
      { 2126 },
      -1,
   } },

   /* replace697 -> 29 in the cache */

   /* ('~f2i32', ('u2f', 'a@32')) => a */
   /* search698_0_0 -> 29 in the cache */
   { .expression = {
      { nir_search_value_expression, 0 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_search_op_u2f,
      -1, 0,
      { 29 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      true,
      false,
      false,
      false,
      false,
      false,
      nir_op_f2i32,
      -1, 0,
      { 2128 },
      -1,
   } },

   /* replace698 -> 29 in the cache */

   /* ('~f2u32', ('i2f', 'a@32')) => a */
   /* search699_0_0 -> 29 in the cache */
   /* search699_0 -> 2126 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      true,
      false,
      false,
      false,
      false,
      false,
      nir_op_f2u32,
      -1, 0,
      { 2126 },
      -1,
   } },

   /* replace699 -> 29 in the cache */

   /* ('~f2u32', ('u2f', 'a@32')) => a */
   /* search700_0_0 -> 29 in the cache */
   /* search700_0 -> 2128 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      true,
      false,
      false,
      false,
      false,
      false,
      nir_op_f2u32,
      -1, 0,
      { 2128 },
      -1,
   } },

   /* replace700 -> 29 in the cache */

   /* ('fadd', ('b2f32', ('flt', 0.0, 'a@32')), ('fneg', ('b2f32', ('flt', 'a@32', 0.0)))) => ('fsign', 'a') */
   /* search701_0_0_0 -> 255 in the cache */
   /* search701_0_0_1 -> 29 in the cache */
   /* search701_0_0 -> 2073 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_b2f32,
      -1, 0,
      { 2073 },
      -1,
   } },
   /* search701_1_0_0_0 -> 29 in the cache */
   /* search701_1_0_0_1 -> 255 in the cache */
   /* search701_1_0_0 -> 845 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_b2f32,
      -1, 0,
      { 845 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fneg,
      -1, 0,
      { 2133 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fadd,
      0, 1,
      { 2132, 2134 },
      -1,
   } },

   /* replace701_0 -> 29 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fsign,
      -1, 0,
      { 29 },
      -1,
   } },

   /* ('iadd', ('b2i32', ('flt', 0, 'a@32')), ('ineg', ('b2i32', ('flt', 'a@32', 0)))) => ('f2i32', ('fsign', 'a')) */
   /* search702_0_0_0 -> 139 in the cache */
   /* search702_0_0_1 -> 29 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_flt,
      -1, 0,
      { 139, 29 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_b2i32,
      -1, 0,
      { 2137 },
      -1,
   } },
   /* search702_1_0_0_0 -> 29 in the cache */
   /* search702_1_0_0_1 -> 139 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_flt,
      -1, 0,
      { 29, 139 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_b2i32,
      -1, 0,
      { 2139 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ineg,
      -1, 0,
      { 2140 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_iadd,
      0, 1,
      { 2138, 2141 },
      -1,
   } },

   /* replace702_0_0 -> 29 in the cache */
   /* replace702_0 -> 2136 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_f2i32,
      -1, 0,
      { 2136 },
      -1,
   } },

   /* ('~f2f32', ('f2f', 'a')) => ('f2f32', 'a') */
   /* search703_0_0 -> 9 in the cache */
   /* search703_0 -> 2035 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      true,
      false,
      false,
      false,
      false,
      false,
      nir_op_f2f32,
      -1, 0,
      { 2035 },
      -1,
   } },

   /* replace703_0 -> 9 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_f2f32,
      -1, 0,
      { 9 },
      -1,
   } },

   /* ('~f2f32', ('u2f', 'a')) => ('u2f32', 'a') */
   /* search704_0_0 -> 9 in the cache */
   /* search704_0 -> 123 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      true,
      false,
      false,
      false,
      false,
      false,
      nir_op_f2f32,
      -1, 0,
      { 123 },
      -1,
   } },

   /* replace704_0 -> 9 in the cache */
   /* replace704 -> 2054 in the cache */

   /* ('~f2f32', ('i2f', 'a')) => ('i2f32', 'a') */
   /* search705_0_0 -> 9 in the cache */
   /* search705_0 -> 1468 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      true,
      false,
      false,
      false,
      false,
      false,
      nir_op_f2f32,
      -1, 0,
      { 1468 },
      -1,
   } },

   /* replace705_0 -> 9 in the cache */
   /* replace705 -> 2056 in the cache */

   /* ('~f2u32', ('f2f', 'a')) => ('f2u32', 'a') */
   /* search706_0_0 -> 9 in the cache */
   /* search706_0 -> 2035 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      true,
      false,
      false,
      false,
      false,
      false,
      nir_op_f2u32,
      -1, 0,
      { 2035 },
      -1,
   } },

   /* replace706_0 -> 9 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_f2u32,
      -1, 0,
      { 9 },
      -1,
   } },

   /* ('~f2i32', ('f2f', 'a')) => ('f2i32', 'a') */
   /* search707_0_0 -> 9 in the cache */
   /* search707_0 -> 2035 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      true,
      false,
      false,
      false,
      false,
      false,
      nir_op_f2i32,
      -1, 0,
      { 2035 },
      -1,
   } },

   /* replace707_0 -> 9 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_f2i32,
      -1, 0,
      { 9 },
      -1,
   } },

   /* ('i2f32', ('f2i', ('fsign', 'a@32'))) => ('fsign', 'a') */
   /* search708_0_0_0 -> 29 in the cache */
   /* search708_0_0 -> 2136 in the cache */
   { .expression = {
      { nir_search_value_expression, 0 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_search_op_f2i,
      -1, 0,
      { 2136 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_i2f32,
      -1, 0,
      { 2152 },
      -1,
   } },

   /* replace708_0 -> 29 in the cache */
   /* replace708 -> 2136 in the cache */

   /* ('~f2f32', ('f2f64', 'a@32')) => a */
   /* search709_0_0 -> 29 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_f2f64,
      -1, 0,
      { 29 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      true,
      false,
      false,
      false,
      false,
      false,
      nir_op_f2f32,
      -1, 0,
      { 2154 },
      -1,
   } },

   /* replace709 -> 29 in the cache */

   /* ('f2u64', ('f2f64', 'a@32')) => ('f2u64', 'a') */
   /* search710_0_0 -> 29 in the cache */
   /* search710_0 -> 2154 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_f2u64,
      -1, 0,
      { 2154 },
      -1,
   } },

   /* replace710_0 -> 29 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_f2u64,
      -1, 0,
      { 29 },
      -1,
   } },

   /* ('f2i64', ('f2f64', 'a@32')) => ('f2i64', 'a') */
   /* search711_0_0 -> 29 in the cache */
   /* search711_0 -> 2154 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_f2i64,
      -1, 0,
      { 2154 },
      -1,
   } },

   /* replace711_0 -> 29 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_f2i64,
      -1, 0,
      { 29 },
      -1,
   } },

   /* ('f2f32', ('u2f64', 'a')) => ('u2f32', 'a') */
   /* search712_0_0 -> 9 in the cache */
   /* search712_0 -> 2064 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_f2f32,
      -1, 0,
      { 2064 },
      -1,
   } },

   /* replace712_0 -> 9 in the cache */
   /* replace712 -> 2054 in the cache */

   /* ('f2f32', ('i2f64', 'a')) => ('i2f32', 'a') */
   /* search713_0_0 -> 9 in the cache */
   /* search713_0 -> 2066 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_f2f32,
      -1, 0,
      { 2066 },
      -1,
   } },

   /* replace713_0 -> 9 in the cache */
   /* replace713 -> 2056 in the cache */

   /* ('ior', ('flt(is_used_once)', 0.0, 'a@64'), ('flt', 'b@64', 0.0)) => ('flt', 0.0, ('fmax', 'a', ('fneg', 'b'))) */
   /* search714_0_0 -> 850 in the cache */
   /* search714_0_1 -> 34 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_flt,
      -1, 0,
      { 850, 34 },
      0,
   } },
   /* search714_1_0 -> 53 in the cache */
   /* search714_1_1 -> 850 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_flt,
      -1, 0,
      { 53, 850 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ior,
      0, 1,
      { 2162, 2163 },
      -1,
   } },

   /* replace714_0 -> 850 in the cache */
   /* replace714_1_0 -> 34 in the cache */
   /* replace714_1_1_0 -> 53 in the cache */
   /* replace714_1_1 -> 802 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fmax,
      0, 1,
      { 34, 802 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_flt,
      -1, 1,
      { 850, 2165 },
      -1,
   } },

   /* ('ior', ('flt', 0.0, 'a@64'), ('flt(is_used_once)', 'b@64', 0.0)) => ('flt', 0.0, ('fmax', 'a', ('fneg', 'b'))) */
   /* search715_0_0 -> 850 in the cache */
   /* search715_0_1 -> 34 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_flt,
      -1, 0,
      { 850, 34 },
      -1,
   } },
   /* search715_1_0 -> 53 in the cache */
   /* search715_1_1 -> 850 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_flt,
      -1, 0,
      { 53, 850 },
      0,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ior,
      0, 1,
      { 2167, 2168 },
      -1,
   } },

   /* replace715_0 -> 850 in the cache */
   /* replace715_1_0 -> 34 in the cache */
   /* replace715_1_1_0 -> 53 in the cache */
   /* replace715_1_1 -> 802 in the cache */
   /* replace715_1 -> 2165 in the cache */
   /* replace715 -> 2166 in the cache */

   /* ('ior', ('fge(is_used_once)', 0.0, 'a@64'), ('fge', 'b@64', 0.0)) => ('fge', 0.0, ('fmin', 'a', ('fneg', 'b'))) */
   /* search716_0_0 -> 850 in the cache */
   /* search716_0_1 -> 34 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fge,
      -1, 0,
      { 850, 34 },
      0,
   } },
   /* search716_1_0 -> 53 in the cache */
   /* search716_1_1 -> 850 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fge,
      -1, 0,
      { 53, 850 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ior,
      0, 1,
      { 2170, 2171 },
      -1,
   } },

   /* replace716_0 -> 850 in the cache */
   /* replace716_1_0 -> 34 in the cache */
   /* replace716_1_1_0 -> 53 in the cache */
   /* replace716_1_1 -> 802 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fmin,
      0, 1,
      { 34, 802 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fge,
      -1, 1,
      { 850, 2173 },
      -1,
   } },

   /* ('ior', ('fge', 0.0, 'a@64'), ('fge(is_used_once)', 'b@64', 0.0)) => ('fge', 0.0, ('fmin', 'a', ('fneg', 'b'))) */
   /* search717_0_0 -> 850 in the cache */
   /* search717_0_1 -> 34 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fge,
      -1, 0,
      { 850, 34 },
      -1,
   } },
   /* search717_1_0 -> 53 in the cache */
   /* search717_1_1 -> 850 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fge,
      -1, 0,
      { 53, 850 },
      0,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ior,
      0, 1,
      { 2175, 2176 },
      -1,
   } },

   /* replace717_0 -> 850 in the cache */
   /* replace717_1_0 -> 34 in the cache */
   /* replace717_1_1_0 -> 53 in the cache */
   /* replace717_1_1 -> 802 in the cache */
   /* replace717_1 -> 2173 in the cache */
   /* replace717 -> 2174 in the cache */

   /* ('~iand', ('flt(is_used_once)', 0.0, 'a@64'), ('flt', 'b@64', 0.0)) => ('flt', 0.0, ('fmin', 'a', ('fneg', 'b'))) */
   /* search718_0_0 -> 850 in the cache */
   /* search718_0_1 -> 34 in the cache */
   /* search718_0 -> 2162 in the cache */
   /* search718_1_0 -> 53 in the cache */
   /* search718_1_1 -> 850 in the cache */
   /* search718_1 -> 2163 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      true,
      false,
      false,
      false,
      false,
      false,
      nir_op_iand,
      0, 1,
      { 2162, 2163 },
      -1,
   } },

   /* replace718_0 -> 850 in the cache */
   /* replace718_1_0 -> 34 in the cache */
   /* replace718_1_1_0 -> 53 in the cache */
   /* replace718_1_1 -> 802 in the cache */
   /* replace718_1 -> 2173 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_flt,
      -1, 1,
      { 850, 2173 },
      -1,
   } },

   /* ('~iand', ('flt', 0.0, 'a@64'), ('flt(is_used_once)', 'b@64', 0.0)) => ('flt', 0.0, ('fmin', 'a', ('fneg', 'b'))) */
   /* search719_0_0 -> 850 in the cache */
   /* search719_0_1 -> 34 in the cache */
   /* search719_0 -> 2167 in the cache */
   /* search719_1_0 -> 53 in the cache */
   /* search719_1_1 -> 850 in the cache */
   /* search719_1 -> 2168 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      true,
      false,
      false,
      false,
      false,
      false,
      nir_op_iand,
      0, 1,
      { 2167, 2168 },
      -1,
   } },

   /* replace719_0 -> 850 in the cache */
   /* replace719_1_0 -> 34 in the cache */
   /* replace719_1_1_0 -> 53 in the cache */
   /* replace719_1_1 -> 802 in the cache */
   /* replace719_1 -> 2173 in the cache */
   /* replace719 -> 2179 in the cache */

   /* ('~iand', ('fge(is_used_once)', 0.0, 'a@64'), ('fge', 'b@64', 0.0)) => ('fge', 0.0, ('fmax', 'a', ('fneg', 'b'))) */
   /* search720_0_0 -> 850 in the cache */
   /* search720_0_1 -> 34 in the cache */
   /* search720_0 -> 2170 in the cache */
   /* search720_1_0 -> 53 in the cache */
   /* search720_1_1 -> 850 in the cache */
   /* search720_1 -> 2171 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      true,
      false,
      false,
      false,
      false,
      false,
      nir_op_iand,
      0, 1,
      { 2170, 2171 },
      -1,
   } },

   /* replace720_0 -> 850 in the cache */
   /* replace720_1_0 -> 34 in the cache */
   /* replace720_1_1_0 -> 53 in the cache */
   /* replace720_1_1 -> 802 in the cache */
   /* replace720_1 -> 2165 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fge,
      -1, 1,
      { 850, 2165 },
      -1,
   } },

   /* ('~iand', ('fge', 0.0, 'a@64'), ('fge(is_used_once)', 'b@64', 0.0)) => ('fge', 0.0, ('fmax', 'a', ('fneg', 'b'))) */
   /* search721_0_0 -> 850 in the cache */
   /* search721_0_1 -> 34 in the cache */
   /* search721_0 -> 2175 in the cache */
   /* search721_1_0 -> 53 in the cache */
   /* search721_1_1 -> 850 in the cache */
   /* search721_1 -> 2176 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      true,
      false,
      false,
      false,
      false,
      false,
      nir_op_iand,
      0, 1,
      { 2175, 2176 },
      -1,
   } },

   /* replace721_0 -> 850 in the cache */
   /* replace721_1_0 -> 34 in the cache */
   /* replace721_1_1_0 -> 53 in the cache */
   /* replace721_1_1 -> 802 in the cache */
   /* replace721_1 -> 2165 in the cache */
   /* replace721 -> 2182 in the cache */

   /* ('ior', ('feq(is_used_once)', 'a@64', 0.0), ('feq', 'b@64', 0.0)) => ('feq', ('fmin', ('fabs', 'a'), ('fabs', 'b')), 0.0) */
   /* search722_0_0 -> 34 in the cache */
   /* search722_0_1 -> 850 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_feq,
      1, 1,
      { 34, 850 },
      0,
   } },
   /* search722_1_0 -> 53 in the cache */
   /* search722_1_1 -> 850 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_feq,
      2, 1,
      { 53, 850 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ior,
      0, 3,
      { 2184, 2185 },
      -1,
   } },

   /* replace722_0_0_0 -> 34 in the cache */
   /* replace722_0_0 -> 522 in the cache */
   /* replace722_0_1_0 -> 53 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fabs,
      -1, 0,
      { 53 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fmin,
      1, 1,
      { 522, 2187 },
      -1,
   } },
   /* replace722_1 -> 850 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_feq,
      0, 2,
      { 2188, 850 },
      -1,
   } },

   /* ('ior', ('fneu(is_used_once)', 'a@64', 0.0), ('fneu', 'b@64', 0.0)) => ('fneu', ('fadd', ('fabs', 'a'), ('fabs', 'b')), 0.0) */
   /* search723_0_0 -> 34 in the cache */
   /* search723_0_1 -> 850 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fneu,
      1, 1,
      { 34, 850 },
      0,
   } },
   /* search723_1_0 -> 53 in the cache */
   /* search723_1_1 -> 850 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fneu,
      2, 1,
      { 53, 850 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ior,
      0, 3,
      { 2190, 2191 },
      -1,
   } },

   /* replace723_0_0_0 -> 34 in the cache */
   /* replace723_0_0 -> 522 in the cache */
   /* replace723_0_1_0 -> 53 in the cache */
   /* replace723_0_1 -> 2187 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fadd,
      1, 1,
      { 522, 2187 },
      -1,
   } },
   /* replace723_1 -> 850 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fneu,
      0, 2,
      { 2193, 850 },
      -1,
   } },

   /* ('iand', ('feq(is_used_once)', 'a@64', 0.0), ('feq', 'b@64', 0.0)) => ('feq', ('fadd', ('fabs', 'a'), ('fabs', 'b')), 0.0) */
   /* search724_0_0 -> 34 in the cache */
   /* search724_0_1 -> 850 in the cache */
   /* search724_0 -> 2184 in the cache */
   /* search724_1_0 -> 53 in the cache */
   /* search724_1_1 -> 850 in the cache */
   /* search724_1 -> 2185 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_iand,
      0, 3,
      { 2184, 2185 },
      -1,
   } },

   /* replace724_0_0_0 -> 34 in the cache */
   /* replace724_0_0 -> 522 in the cache */
   /* replace724_0_1_0 -> 53 in the cache */
   /* replace724_0_1 -> 2187 in the cache */
   /* replace724_0 -> 2193 in the cache */
   /* replace724_1 -> 850 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_feq,
      0, 2,
      { 2193, 850 },
      -1,
   } },

   /* ('iand', ('fneu(is_used_once)', 'a@64', 0.0), ('fneu', 'b@64', 0.0)) => ('fneu', ('fmin', ('fabs', 'a'), ('fabs', 'b')), 0.0) */
   /* search725_0_0 -> 34 in the cache */
   /* search725_0_1 -> 850 in the cache */
   /* search725_0 -> 2190 in the cache */
   /* search725_1_0 -> 53 in the cache */
   /* search725_1_1 -> 850 in the cache */
   /* search725_1 -> 2191 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_iand,
      0, 3,
      { 2190, 2191 },
      -1,
   } },

   /* replace725_0_0_0 -> 34 in the cache */
   /* replace725_0_0 -> 522 in the cache */
   /* replace725_0_1_0 -> 53 in the cache */
   /* replace725_0_1 -> 2187 in the cache */
   /* replace725_0 -> 2188 in the cache */
   /* replace725_1 -> 850 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fneu,
      0, 2,
      { 2188, 850 },
      -1,
   } },

   /* ('bcsel@64', ('feq', 'a', 0.0), 1.0, ('i2f64', ('iadd', ('b2i64', ('flt', 0.0, 'a@64')), ('ineg', ('b2i64', ('flt', 'a@64', 0.0)))))) => ('i2f64', ('iadd', ('b2i32', ('!fge', 'a', 0.0)), ('ineg', ('b2i32', ('!flt', 'a', 0.0))))) */
   /* search726_0_0 -> 34 in the cache */
   /* search726_0_1 -> 850 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_feq,
      0, 1,
      { 34, 850 },
      -1,
   } },
   /* search726_1 -> 752 in the cache */
   /* search726_2_0_0_0_0 -> 850 in the cache */
   /* search726_2_0_0_0_1 -> 34 in the cache */
   /* search726_2_0_0_0 -> 2167 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_b2i64,
      -1, 0,
      { 2167 },
      -1,
   } },
   /* search726_2_0_1_0_0_0 -> 34 in the cache */
   /* search726_2_0_1_0_0_1 -> 850 in the cache */
   /* search726_2_0_1_0_0 -> 851 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_b2i64,
      -1, 0,
      { 851 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ineg,
      -1, 0,
      { 2201 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_iadd,
      1, 1,
      { 2200, 2202 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_i2f64,
      -1, 1,
      { 2203 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_bcsel,
      -1, 2,
      { 2199, 752, 2204 },
      -1,
   } },

   /* replace726_0_0_0_0 -> 34 in the cache */
   /* replace726_0_0_0_1 -> 850 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      true,
      false,
      false,
      false,
      false,
      nir_op_fge,
      -1, 0,
      { 34, 850 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_b2i32,
      -1, 0,
      { 2206 },
      -1,
   } },
   /* replace726_0_1_0_0_0 -> 34 in the cache */
   /* replace726_0_1_0_0_1 -> 850 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      true,
      false,
      false,
      false,
      false,
      nir_op_flt,
      -1, 0,
      { 34, 850 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_b2i32,
      -1, 0,
      { 2208 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ineg,
      -1, 0,
      { 2209 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_iadd,
      0, 1,
      { 2207, 2210 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_i2f64,
      -1, 1,
      { 2211 },
      -1,
   } },

   /* ('bcsel', 'a', ('b2f(is_used_once)', 'b@64'), ('b2f', 'c@64')) => ('b2f', ('bcsel', 'a', 'b', 'c')) */
   /* search727_0 -> 907 in the cache */
   /* search727_1_0 -> 53 in the cache */
   { .expression = {
      { nir_search_value_expression, 0 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_search_op_b2f,
      -1, 0,
      { 53 },
      0,
   } },
   /* search727_2_0 -> 740 in the cache */
   { .expression = {
      { nir_search_value_expression, 0 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_search_op_b2f,
      -1, 0,
      { 740 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 0 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_bcsel,
      -1, 0,
      { 907, 2213, 2214 },
      -1,
   } },

   /* replace727_0_0 -> 907 in the cache */
   /* replace727_0_1 -> 53 in the cache */
   /* replace727_0_2 -> 740 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_bcsel,
      -1, 0,
      { 907, 53, 740 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 0 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_search_op_b2f,
      -1, 0,
      { 2216 },
      -1,
   } },

   /* ('~i2f64', ('f2i', 'a@64')) => ('ftrunc', 'a') */
   /* search728_0_0 -> 34 in the cache */
   { .expression = {
      { nir_search_value_expression, 0 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_search_op_f2i,
      -1, 0,
      { 34 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 64 },
      true,
      false,
      false,
      false,
      false,
      false,
      nir_op_i2f64,
      -1, 0,
      { 2218 },
      -1,
   } },

   /* replace728_0 -> 34 in the cache */
   /* replace728 -> 849 in the cache */

   /* ('~f2i64', ('i2f', 'a@64')) => a */
   /* search729_0_0 -> 34 in the cache */
   { .expression = {
      { nir_search_value_expression, 0 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_search_op_i2f,
      -1, 0,
      { 34 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 64 },
      true,
      false,
      false,
      false,
      false,
      false,
      nir_op_f2i64,
      -1, 0,
      { 2220 },
      -1,
   } },

   /* replace729 -> 34 in the cache */

   /* ('~f2i64', ('u2f', 'a@64')) => a */
   /* search730_0_0 -> 34 in the cache */
   { .expression = {
      { nir_search_value_expression, 0 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_search_op_u2f,
      -1, 0,
      { 34 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 64 },
      true,
      false,
      false,
      false,
      false,
      false,
      nir_op_f2i64,
      -1, 0,
      { 2222 },
      -1,
   } },

   /* replace730 -> 34 in the cache */

   /* ('~f2u64', ('i2f', 'a@64')) => a */
   /* search731_0_0 -> 34 in the cache */
   /* search731_0 -> 2220 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      true,
      false,
      false,
      false,
      false,
      false,
      nir_op_f2u64,
      -1, 0,
      { 2220 },
      -1,
   } },

   /* replace731 -> 34 in the cache */

   /* ('~f2u64', ('u2f', 'a@64')) => a */
   /* search732_0_0 -> 34 in the cache */
   /* search732_0 -> 2222 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      true,
      false,
      false,
      false,
      false,
      false,
      nir_op_f2u64,
      -1, 0,
      { 2222 },
      -1,
   } },

   /* replace732 -> 34 in the cache */

   /* ('fadd', ('b2f64', ('flt', 0.0, 'a@64')), ('fneg', ('b2f64', ('flt', 'a@64', 0.0)))) => ('fsign', 'a') */
   /* search733_0_0_0 -> 850 in the cache */
   /* search733_0_0_1 -> 34 in the cache */
   /* search733_0_0 -> 2167 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_b2f64,
      -1, 0,
      { 2167 },
      -1,
   } },
   /* search733_1_0_0_0 -> 34 in the cache */
   /* search733_1_0_0_1 -> 850 in the cache */
   /* search733_1_0_0 -> 851 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_b2f64,
      -1, 0,
      { 851 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fneg,
      -1, 0,
      { 2227 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fadd,
      0, 1,
      { 2226, 2228 },
      -1,
   } },

   /* replace733_0 -> 34 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_fsign,
      -1, 0,
      { 34 },
      -1,
   } },

   /* ('iadd', ('b2i64', ('flt', 0, 'a@64')), ('ineg', ('b2i64', ('flt', 'a@64', 0)))) => ('f2i64', ('fsign', 'a')) */
   /* search734_0_0_0 -> 1047 in the cache */
   /* search734_0_0_1 -> 34 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_flt,
      -1, 0,
      { 1047, 34 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_b2i64,
      -1, 0,
      { 2231 },
      -1,
   } },
   /* search734_1_0_0_0 -> 34 in the cache */
   /* search734_1_0_0_1 -> 1047 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_flt,
      -1, 0,
      { 34, 1047 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_b2i64,
      -1, 0,
      { 2233 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ineg,
      -1, 0,
      { 2234 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_iadd,
      0, 1,
      { 2232, 2235 },
      -1,
   } },

   /* replace734_0_0 -> 34 in the cache */
   /* replace734_0 -> 2230 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_f2i64,
      -1, 0,
      { 2230 },
      -1,
   } },

   /* ('~f2f64', ('f2f', 'a')) => ('f2f64', 'a') */
   /* search735_0_0 -> 9 in the cache */
   /* search735_0 -> 2035 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      true,
      false,
      false,
      false,
      false,
      false,
      nir_op_f2f64,
      -1, 0,
      { 2035 },
      -1,
   } },

   /* replace735_0 -> 9 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_f2f64,
      -1, 0,
      { 9 },
      -1,
   } },

   /* ('~f2f64', ('u2f', 'a')) => ('u2f64', 'a') */
   /* search736_0_0 -> 9 in the cache */
   /* search736_0 -> 123 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      true,
      false,
      false,
      false,
      false,
      false,
      nir_op_f2f64,
      -1, 0,
      { 123 },
      -1,
   } },

   /* replace736_0 -> 9 in the cache */
   /* replace736 -> 2064 in the cache */

   /* ('~f2f64', ('i2f', 'a')) => ('i2f64', 'a') */
   /* search737_0_0 -> 9 in the cache */
   /* search737_0 -> 1468 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      true,
      false,
      false,
      false,
      false,
      false,
      nir_op_f2f64,
      -1, 0,
      { 1468 },
      -1,
   } },

   /* replace737_0 -> 9 in the cache */
   /* replace737 -> 2066 in the cache */

   /* ('~f2u64', ('f2f', 'a')) => ('f2u64', 'a') */
   /* search738_0_0 -> 9 in the cache */
   /* search738_0 -> 2035 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      true,
      false,
      false,
      false,
      false,
      false,
      nir_op_f2u64,
      -1, 0,
      { 2035 },
      -1,
   } },

   /* replace738_0 -> 9 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_f2u64,
      -1, 0,
      { 9 },
      -1,
   } },

   /* ('~f2i64', ('f2f', 'a')) => ('f2i64', 'a') */
   /* search739_0_0 -> 9 in the cache */
   /* search739_0 -> 2035 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      true,
      false,
      false,
      false,
      false,
      false,
      nir_op_f2i64,
      -1, 0,
      { 2035 },
      -1,
   } },

   /* replace739_0 -> 9 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_f2i64,
      -1, 0,
      { 9 },
      -1,
   } },

   /* ('i2f64', ('f2i', ('fsign', 'a@64'))) => ('fsign', 'a') */
   /* search740_0_0_0 -> 34 in the cache */
   /* search740_0_0 -> 2230 in the cache */
   { .expression = {
      { nir_search_value_expression, 0 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_search_op_f2i,
      -1, 0,
      { 2230 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_i2f64,
      -1, 0,
      { 2246 },
      -1,
   } },

   /* replace740_0 -> 34 in the cache */
   /* replace740 -> 2230 in the cache */

   /* ('i2i1', ('i2i8', 'a@1')) => a */
   /* search741_0_0 -> 907 in the cache */
   { .expression = {
      { nir_search_value_expression, 8 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_i2i8,
      -1, 0,
      { 907 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_i2i1,
      -1, 0,
      { 2248 },
      -1,
   } },

   /* replace741 -> 907 in the cache */

   /* ('u2u1', ('u2u8', 'a@1')) => a */
   /* search742_0_0 -> 907 in the cache */
   { .expression = {
      { nir_search_value_expression, 8 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_u2u8,
      -1, 0,
      { 907 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_u2u1,
      -1, 0,
      { 2250 },
      -1,
   } },

   /* replace742 -> 907 in the cache */

   /* ('i2i1', ('i2i16', 'a@1')) => a */
   /* search743_0_0 -> 907 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_i2i16,
      -1, 0,
      { 907 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_i2i1,
      -1, 0,
      { 2252 },
      -1,
   } },

   /* replace743 -> 907 in the cache */

   /* ('u2u1', ('u2u16', 'a@1')) => a */
   /* search744_0_0 -> 907 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_u2u16,
      -1, 0,
      { 907 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_u2u1,
      -1, 0,
      { 2254 },
      -1,
   } },

   /* replace744 -> 907 in the cache */

   /* ('u2f16', ('u2u8', 'a@1')) => ('u2f16', 'a') */
   /* search745_0_0 -> 907 in the cache */
   /* search745_0 -> 2250 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_u2f16,
      -1, 0,
      { 2250 },
      -1,
   } },

   /* replace745_0 -> 907 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_u2f16,
      -1, 0,
      { 907 },
      -1,
   } },

   /* ('i2f16', ('i2i8', 'a@1')) => ('i2f16', 'a') */
   /* search746_0_0 -> 907 in the cache */
   /* search746_0 -> 2248 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_i2f16,
      -1, 0,
      { 2248 },
      -1,
   } },

   /* replace746_0 -> 907 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_i2f16,
      -1, 0,
      { 907 },
      -1,
   } },

   /* ('u2f16', ('u2u16', 'a@1')) => ('u2f16', 'a') */
   /* search747_0_0 -> 907 in the cache */
   /* search747_0 -> 2254 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_u2f16,
      -1, 0,
      { 2254 },
      -1,
   } },

   /* replace747_0 -> 907 in the cache */
   /* replace747 -> 2257 in the cache */

   /* ('i2f16', ('i2i16', 'a@1')) => ('i2f16', 'a') */
   /* search748_0_0 -> 907 in the cache */
   /* search748_0 -> 2252 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_i2f16,
      -1, 0,
      { 2252 },
      -1,
   } },

   /* replace748_0 -> 907 in the cache */
   /* replace748 -> 2259 in the cache */

   /* ('u2f16', ('u2u32', 'a@1')) => ('u2f16', 'a') */
   /* search749_0_0 -> 907 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_u2u32,
      -1, 0,
      { 907 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_u2f16,
      -1, 0,
      { 2262 },
      -1,
   } },

   /* replace749_0 -> 907 in the cache */
   /* replace749 -> 2257 in the cache */

   /* ('i2f16', ('i2i32', 'a@1')) => ('i2f16', 'a') */
   /* search750_0_0 -> 907 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_i2i32,
      -1, 0,
      { 907 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_i2f16,
      -1, 0,
      { 2264 },
      -1,
   } },

   /* replace750_0 -> 907 in the cache */
   /* replace750 -> 2259 in the cache */

   /* ('u2f16', ('u2u64', 'a@1')) => ('u2f16', 'a') */
   /* search751_0_0 -> 907 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_u2u64,
      -1, 0,
      { 907 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_u2f16,
      -1, 0,
      { 2266 },
      -1,
   } },

   /* replace751_0 -> 907 in the cache */
   /* replace751 -> 2257 in the cache */

   /* ('i2f16', ('i2i64', 'a@1')) => ('i2f16', 'a') */
   /* search752_0_0 -> 907 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_i2i64,
      -1, 0,
      { 907 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_i2f16,
      -1, 0,
      { 2268 },
      -1,
   } },

   /* replace752_0 -> 907 in the cache */
   /* replace752 -> 2259 in the cache */

   /* ('i2i1', ('i2i32', 'a@1')) => a */
   /* search753_0_0 -> 907 in the cache */
   /* search753_0 -> 2264 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_i2i1,
      -1, 0,
      { 2264 },
      -1,
   } },

   /* replace753 -> 907 in the cache */

   /* ('u2u1', ('u2u32', 'a@1')) => a */
   /* search754_0_0 -> 907 in the cache */
   /* search754_0 -> 2262 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_u2u1,
      -1, 0,
      { 2262 },
      -1,
   } },

   /* replace754 -> 907 in the cache */

   /* ('u2f32', ('u2u8', 'a@1')) => ('u2f32', 'a') */
   /* search755_0_0 -> 907 in the cache */
   /* search755_0 -> 2250 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_u2f32,
      -1, 0,
      { 2250 },
      -1,
   } },

   /* replace755_0 -> 907 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_u2f32,
      -1, 0,
      { 907 },
      -1,
   } },

   /* ('i2f32', ('i2i8', 'a@1')) => ('i2f32', 'a') */
   /* search756_0_0 -> 907 in the cache */
   /* search756_0 -> 2248 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_i2f32,
      -1, 0,
      { 2248 },
      -1,
   } },

   /* replace756_0 -> 907 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_i2f32,
      -1, 0,
      { 907 },
      -1,
   } },

   /* ('u2f32', ('u2u16', 'a@1')) => ('u2f32', 'a') */
   /* search757_0_0 -> 907 in the cache */
   /* search757_0 -> 2254 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_u2f32,
      -1, 0,
      { 2254 },
      -1,
   } },

   /* replace757_0 -> 907 in the cache */
   /* replace757 -> 2273 in the cache */

   /* ('i2f32', ('i2i16', 'a@1')) => ('i2f32', 'a') */
   /* search758_0_0 -> 907 in the cache */
   /* search758_0 -> 2252 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_i2f32,
      -1, 0,
      { 2252 },
      -1,
   } },

   /* replace758_0 -> 907 in the cache */
   /* replace758 -> 2275 in the cache */

   /* ('u2f32', ('u2u32', 'a@1')) => ('u2f32', 'a') */
   /* search759_0_0 -> 907 in the cache */
   /* search759_0 -> 2262 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_u2f32,
      -1, 0,
      { 2262 },
      -1,
   } },

   /* replace759_0 -> 907 in the cache */
   /* replace759 -> 2273 in the cache */

   /* ('i2f32', ('i2i32', 'a@1')) => ('i2f32', 'a') */
   /* search760_0_0 -> 907 in the cache */
   /* search760_0 -> 2264 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_i2f32,
      -1, 0,
      { 2264 },
      -1,
   } },

   /* replace760_0 -> 907 in the cache */
   /* replace760 -> 2275 in the cache */

   /* ('u2f32', ('u2u64', 'a@1')) => ('u2f32', 'a') */
   /* search761_0_0 -> 907 in the cache */
   /* search761_0 -> 2266 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_u2f32,
      -1, 0,
      { 2266 },
      -1,
   } },

   /* replace761_0 -> 907 in the cache */
   /* replace761 -> 2273 in the cache */

   /* ('i2f32', ('i2i64', 'a@1')) => ('i2f32', 'a') */
   /* search762_0_0 -> 907 in the cache */
   /* search762_0 -> 2268 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_i2f32,
      -1, 0,
      { 2268 },
      -1,
   } },

   /* replace762_0 -> 907 in the cache */
   /* replace762 -> 2275 in the cache */

   /* ('i2i1', ('i2i64', 'a@1')) => a */
   /* search763_0_0 -> 907 in the cache */
   /* search763_0 -> 2268 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_i2i1,
      -1, 0,
      { 2268 },
      -1,
   } },

   /* replace763 -> 907 in the cache */

   /* ('u2u1', ('u2u64', 'a@1')) => a */
   /* search764_0_0 -> 907 in the cache */
   /* search764_0 -> 2266 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_u2u1,
      -1, 0,
      { 2266 },
      -1,
   } },

   /* replace764 -> 907 in the cache */

   /* ('u2f64', ('u2u8', 'a@1')) => ('u2f64', 'a') */
   /* search765_0_0 -> 907 in the cache */
   /* search765_0 -> 2250 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_u2f64,
      -1, 0,
      { 2250 },
      -1,
   } },

   /* replace765_0 -> 907 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_u2f64,
      -1, 0,
      { 907 },
      -1,
   } },

   /* ('i2f64', ('i2i8', 'a@1')) => ('i2f64', 'a') */
   /* search766_0_0 -> 907 in the cache */
   /* search766_0 -> 2248 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_i2f64,
      -1, 0,
      { 2248 },
      -1,
   } },

   /* replace766_0 -> 907 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_i2f64,
      -1, 0,
      { 907 },
      -1,
   } },

   /* ('u2f64', ('u2u16', 'a@1')) => ('u2f64', 'a') */
   /* search767_0_0 -> 907 in the cache */
   /* search767_0 -> 2254 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_u2f64,
      -1, 0,
      { 2254 },
      -1,
   } },

   /* replace767_0 -> 907 in the cache */
   /* replace767 -> 2285 in the cache */

   /* ('i2f64', ('i2i16', 'a@1')) => ('i2f64', 'a') */
   /* search768_0_0 -> 907 in the cache */
   /* search768_0 -> 2252 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_i2f64,
      -1, 0,
      { 2252 },
      -1,
   } },

   /* replace768_0 -> 907 in the cache */
   /* replace768 -> 2287 in the cache */

   /* ('u2f64', ('u2u32', 'a@1')) => ('u2f64', 'a') */
   /* search769_0_0 -> 907 in the cache */
   /* search769_0 -> 2262 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_u2f64,
      -1, 0,
      { 2262 },
      -1,
   } },

   /* replace769_0 -> 907 in the cache */
   /* replace769 -> 2285 in the cache */

   /* ('i2f64', ('i2i32', 'a@1')) => ('i2f64', 'a') */
   /* search770_0_0 -> 907 in the cache */
   /* search770_0 -> 2264 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_i2f64,
      -1, 0,
      { 2264 },
      -1,
   } },

   /* replace770_0 -> 907 in the cache */
   /* replace770 -> 2287 in the cache */

   /* ('u2f64', ('u2u64', 'a@1')) => ('u2f64', 'a') */
   /* search771_0_0 -> 907 in the cache */
   /* search771_0 -> 2266 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_u2f64,
      -1, 0,
      { 2266 },
      -1,
   } },

   /* replace771_0 -> 907 in the cache */
   /* replace771 -> 2285 in the cache */

   /* ('i2f64', ('i2i64', 'a@1')) => ('i2f64', 'a') */
   /* search772_0_0 -> 907 in the cache */
   /* search772_0 -> 2268 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_i2f64,
      -1, 0,
      { 2268 },
      -1,
   } },

   /* replace772_0 -> 907 in the cache */
   /* replace772 -> 2287 in the cache */

   /* ('i2i8', ('i2i16', 'a@8')) => a */
   /* search773_0_0 -> 19 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_i2i16,
      -1, 0,
      { 19 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 8 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_i2i8,
      -1, 0,
      { 2294 },
      -1,
   } },

   /* replace773 -> 19 in the cache */

   /* ('u2u8', ('u2u16', 'a@8')) => a */
   /* search774_0_0 -> 19 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_u2u16,
      -1, 0,
      { 19 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 8 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_u2u8,
      -1, 0,
      { 2296 },
      -1,
   } },

   /* replace774 -> 19 in the cache */

   /* ('u2f16', ('u2u16', 'a@8')) => ('u2f16', 'a') */
   /* search775_0_0 -> 19 in the cache */
   /* search775_0 -> 2296 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_u2f16,
      -1, 0,
      { 2296 },
      -1,
   } },

   /* replace775_0 -> 19 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_u2f16,
      -1, 0,
      { 19 },
      -1,
   } },

   /* ('i2f16', ('i2i16', 'a@8')) => ('i2f16', 'a') */
   /* search776_0_0 -> 19 in the cache */
   /* search776_0 -> 2294 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_i2f16,
      -1, 0,
      { 2294 },
      -1,
   } },

   /* replace776_0 -> 19 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_i2f16,
      -1, 0,
      { 19 },
      -1,
   } },

   /* ('u2f16', ('u2u32', 'a@8')) => ('u2f16', 'a') */
   /* search777_0_0 -> 19 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_u2u32,
      -1, 0,
      { 19 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_u2f16,
      -1, 0,
      { 2302 },
      -1,
   } },

   /* replace777_0 -> 19 in the cache */
   /* replace777 -> 2299 in the cache */

   /* ('i2f16', ('i2i32', 'a@8')) => ('i2f16', 'a') */
   /* search778_0_0 -> 19 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_i2i32,
      -1, 0,
      { 19 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_i2f16,
      -1, 0,
      { 2304 },
      -1,
   } },

   /* replace778_0 -> 19 in the cache */
   /* replace778 -> 2301 in the cache */

   /* ('u2f16', ('u2u64', 'a@8')) => ('u2f16', 'a') */
   /* search779_0_0 -> 19 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_u2u64,
      -1, 0,
      { 19 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_u2f16,
      -1, 0,
      { 2306 },
      -1,
   } },

   /* replace779_0 -> 19 in the cache */
   /* replace779 -> 2299 in the cache */

   /* ('i2f16', ('i2i64', 'a@8')) => ('i2f16', 'a') */
   /* search780_0_0 -> 19 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_i2i64,
      -1, 0,
      { 19 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_i2f16,
      -1, 0,
      { 2308 },
      -1,
   } },

   /* replace780_0 -> 19 in the cache */
   /* replace780 -> 2301 in the cache */

   /* ('i2i8', ('i2i32', 'a@8')) => a */
   /* search781_0_0 -> 19 in the cache */
   /* search781_0 -> 2304 in the cache */
   { .expression = {
      { nir_search_value_expression, 8 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_i2i8,
      -1, 0,
      { 2304 },
      -1,
   } },

   /* replace781 -> 19 in the cache */

   /* ('u2u8', ('u2u32', 'a@8')) => a */
   /* search782_0_0 -> 19 in the cache */
   /* search782_0 -> 2302 in the cache */
   { .expression = {
      { nir_search_value_expression, 8 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_u2u8,
      -1, 0,
      { 2302 },
      -1,
   } },

   /* replace782 -> 19 in the cache */

   /* ('u2f32', ('u2u16', 'a@8')) => ('u2f32', 'a') */
   /* search783_0_0 -> 19 in the cache */
   /* search783_0 -> 2296 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_u2f32,
      -1, 0,
      { 2296 },
      -1,
   } },

   /* replace783_0 -> 19 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_u2f32,
      -1, 0,
      { 19 },
      -1,
   } },

   /* ('i2f32', ('i2i16', 'a@8')) => ('i2f32', 'a') */
   /* search784_0_0 -> 19 in the cache */
   /* search784_0 -> 2294 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_i2f32,
      -1, 0,
      { 2294 },
      -1,
   } },

   /* replace784_0 -> 19 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_i2f32,
      -1, 0,
      { 19 },
      -1,
   } },

   /* ('u2f32', ('u2u32', 'a@8')) => ('u2f32', 'a') */
   /* search785_0_0 -> 19 in the cache */
   /* search785_0 -> 2302 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_u2f32,
      -1, 0,
      { 2302 },
      -1,
   } },

   /* replace785_0 -> 19 in the cache */
   /* replace785 -> 2313 in the cache */

   /* ('i2f32', ('i2i32', 'a@8')) => ('i2f32', 'a') */
   /* search786_0_0 -> 19 in the cache */
   /* search786_0 -> 2304 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_i2f32,
      -1, 0,
      { 2304 },
      -1,
   } },

   /* replace786_0 -> 19 in the cache */
   /* replace786 -> 2315 in the cache */

   /* ('u2f32', ('u2u64', 'a@8')) => ('u2f32', 'a') */
   /* search787_0_0 -> 19 in the cache */
   /* search787_0 -> 2306 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_u2f32,
      -1, 0,
      { 2306 },
      -1,
   } },

   /* replace787_0 -> 19 in the cache */
   /* replace787 -> 2313 in the cache */

   /* ('i2f32', ('i2i64', 'a@8')) => ('i2f32', 'a') */
   /* search788_0_0 -> 19 in the cache */
   /* search788_0 -> 2308 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_i2f32,
      -1, 0,
      { 2308 },
      -1,
   } },

   /* replace788_0 -> 19 in the cache */
   /* replace788 -> 2315 in the cache */

   /* ('i2i8', ('i2i64', 'a@8')) => a */
   /* search789_0_0 -> 19 in the cache */
   /* search789_0 -> 2308 in the cache */
   { .expression = {
      { nir_search_value_expression, 8 },
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_i2i8,
      -1, 0,
      { 2308 },
      -1,
   } },

   /* replace789 -> 19 in the cache */

   /* ('u2u8', ('u2u64', 'a@8')) => a */
   /* search790_0_0 -> 19 in the cache */
   /* search790_0 -> 2306 in the cache */
   { .expression = {
      