#include "nv_push_clc7c0.h"

#include <stdio.h>

const char*
P_PARSE_NVC7C0_MTHD(uint16_t idx)
{
    switch (idx) {
    case NVC7C0_SET_OBJECT:
        return "NVC7C0_SET_OBJECT";
    case NVC7C0_NO_OPERATION:
        return "NVC7C0_NO_OPERATION";
    case NVC7C0_SET_NOTIFY_A:
        return "NVC7C0_SET_NOTIFY_A";
    case NVC7C0_SET_NOTIFY_B:
        return "NVC7C0_SET_NOTIFY_B";
    case NVC7C0_NOTIFY:
        return "NVC7C0_NOTIFY";
    case NVC7C0_WAIT_FOR_IDLE:
        return "NVC7C0_WAIT_FOR_IDLE";
    case NVC7C0_LOAD_MME_INSTRUCTION_RAM_POINTER:
        return "NVC7C0_LOAD_MME_INSTRUCTION_RAM_POINTER";
    case NVC7C0_LOAD_MME_INSTRUCTION_RAM:
        return "NVC7C0_LOAD_MME_INSTRUCTION_RAM";
    case NVC7C0_LOAD_MME_START_ADDRESS_RAM_POINTER:
        return "NVC7C0_LOAD_MME_START_ADDRESS_RAM_POINTER";
    case NVC7C0_LOAD_MME_START_ADDRESS_RAM:
        return "NVC7C0_LOAD_MME_START_ADDRESS_RAM";
    case NVC7C0_SET_MME_SHADOW_RAM_CONTROL:
        return "NVC7C0_SET_MME_SHADOW_RAM_CONTROL";
    case NVC7C0_SET_GLOBAL_RENDER_ENABLE_A:
        return "NVC7C0_SET_GLOBAL_RENDER_ENABLE_A";
    case NVC7C0_SET_GLOBAL_RENDER_ENABLE_B:
        return "NVC7C0_SET_GLOBAL_RENDER_ENABLE_B";
    case NVC7C0_SET_GLOBAL_RENDER_ENABLE_C:
        return "NVC7C0_SET_GLOBAL_RENDER_ENABLE_C";
    case NVC7C0_SEND_GO_IDLE:
        return "NVC7C0_SEND_GO_IDLE";
    case NVC7C0_PM_TRIGGER:
        return "NVC7C0_PM_TRIGGER";
    case NVC7C0_PM_TRIGGER_WFI:
        return "NVC7C0_PM_TRIGGER_WFI";
    case NVC7C0_FE_ATOMIC_SEQUENCE_BEGIN:
        return "NVC7C0_FE_ATOMIC_SEQUENCE_BEGIN";
    case NVC7C0_FE_ATOMIC_SEQUENCE_END:
        return "NVC7C0_FE_ATOMIC_SEQUENCE_END";
    case NVC7C0_SET_INSTRUMENTATION_METHOD_HEADER:
        return "NVC7C0_SET_INSTRUMENTATION_METHOD_HEADER";
    case NVC7C0_SET_INSTRUMENTATION_METHOD_DATA:
        return "NVC7C0_SET_INSTRUMENTATION_METHOD_DATA";
    case NVC7C0_SET_REPORT_SEMAPHORE_PAYLOAD_LOWER:
        return "NVC7C0_SET_REPORT_SEMAPHORE_PAYLOAD_LOWER";
    case NVC7C0_SET_REPORT_SEMAPHORE_PAYLOAD_UPPER:
        return "NVC7C0_SET_REPORT_SEMAPHORE_PAYLOAD_UPPER";
    case NVC7C0_SET_REPORT_SEMAPHORE_ADDRESS_LOWER:
        return "NVC7C0_SET_REPORT_SEMAPHORE_ADDRESS_LOWER";
    case NVC7C0_SET_REPORT_SEMAPHORE_ADDRESS_UPPER:
        return "NVC7C0_SET_REPORT_SEMAPHORE_ADDRESS_UPPER";
    case NVC7C0_REPORT_SEMAPHORE_EXECUTE:
        return "NVC7C0_REPORT_SEMAPHORE_EXECUTE";
    case NVC7C0_LINE_LENGTH_IN:
        return "NVC7C0_LINE_LENGTH_IN";
    case NVC7C0_LINE_COUNT:
        return "NVC7C0_LINE_COUNT";
    case NVC7C0_OFFSET_OUT_UPPER:
        return "NVC7C0_OFFSET_OUT_UPPER";
    case NVC7C0_OFFSET_OUT:
        return "NVC7C0_OFFSET_OUT";
    case NVC7C0_PITCH_OUT:
        return "NVC7C0_PITCH_OUT";
    case NVC7C0_SET_DST_BLOCK_SIZE:
        return "NVC7C0_SET_DST_BLOCK_SIZE";
    case NVC7C0_SET_DST_WIDTH:
        return "NVC7C0_SET_DST_WIDTH";
    case NVC7C0_SET_DST_HEIGHT:
        return "NVC7C0_SET_DST_HEIGHT";
    case NVC7C0_SET_DST_DEPTH:
        return "NVC7C0_SET_DST_DEPTH";
    case NVC7C0_SET_DST_LAYER:
        return "NVC7C0_SET_DST_LAYER";
    case NVC7C0_SET_DST_ORIGIN_BYTES_X:
        return "NVC7C0_SET_DST_ORIGIN_BYTES_X";
    case NVC7C0_SET_DST_ORIGIN_SAMPLES_Y:
        return "NVC7C0_SET_DST_ORIGIN_SAMPLES_Y";
    case NVC7C0_LAUNCH_DMA:
        return "NVC7C0_LAUNCH_DMA";
    case NVC7C0_LOAD_INLINE_DATA:
        return "NVC7C0_LOAD_INLINE_DATA";
    case NVC7C0_SET_I2M_SEMAPHORE_A:
        return "NVC7C0_SET_I2M_SEMAPHORE_A";
    case NVC7C0_SET_I2M_SEMAPHORE_B:
        return "NVC7C0_SET_I2M_SEMAPHORE_B";
    case NVC7C0_SET_I2M_SEMAPHORE_C:
        return "NVC7C0_SET_I2M_SEMAPHORE_C";
    case NVC7C0_SET_SM_SCG_CONTROL:
        return "NVC7C0_SET_SM_SCG_CONTROL";
    case NVC7C0_SET_MME_SWITCH_STATE:
        return "NVC7C0_SET_MME_SWITCH_STATE";
    case NVC7C0_SET_I2M_SPARE_NOOP00:
        return "NVC7C0_SET_I2M_SPARE_NOOP00";
    case NVC7C0_SET_I2M_SPARE_NOOP01:
        return "NVC7C0_SET_I2M_SPARE_NOOP01";
    case NVC7C0_SET_I2M_SPARE_NOOP02:
        return "NVC7C0_SET_I2M_SPARE_NOOP02";
    case NVC7C0_SET_I2M_SPARE_NOOP03:
        return "NVC7C0_SET_I2M_SPARE_NOOP03";
    case NVC7C0_SET_VALID_SPAN_OVERFLOW_AREA_A:
        return "NVC7C0_SET_VALID_SPAN_OVERFLOW_AREA_A";
    case NVC7C0_SET_VALID_SPAN_OVERFLOW_AREA_B:
        return "NVC7C0_SET_VALID_SPAN_OVERFLOW_AREA_B";
    case NVC7C0_SET_VALID_SPAN_OVERFLOW_AREA_C:
        return "NVC7C0_SET_VALID_SPAN_OVERFLOW_AREA_C";
    case NVC7C0_PERFMON_TRANSFER:
        return "NVC7C0_PERFMON_TRANSFER";
    case NVC7C0_SET_QMD_VIRTUALIZATION_BASE_A:
        return "NVC7C0_SET_QMD_VIRTUALIZATION_BASE_A";
    case NVC7C0_SET_QMD_VIRTUALIZATION_BASE_B:
        return "NVC7C0_SET_QMD_VIRTUALIZATION_BASE_B";
    case NVC7C0_INVALIDATE_SHADER_CACHES:
        return "NVC7C0_INVALIDATE_SHADER_CACHES";
    case NVC7C0_SET_RESERVED_SW_METHOD00:
        return "NVC7C0_SET_RESERVED_SW_METHOD00";
    case NVC7C0_SET_RESERVED_SW_METHOD01:
        return "NVC7C0_SET_RESERVED_SW_METHOD01";
    case NVC7C0_SET_RESERVED_SW_METHOD02:
        return "NVC7C0_SET_RESERVED_SW_METHOD02";
    case NVC7C0_SET_RESERVED_SW_METHOD03:
        return "NVC7C0_SET_RESERVED_SW_METHOD03";
    case NVC7C0_SET_RESERVED_SW_METHOD04:
        return "NVC7C0_SET_RESERVED_SW_METHOD04";
    case NVC7C0_SET_RESERVED_SW_METHOD05:
        return "NVC7C0_SET_RESERVED_SW_METHOD05";
    case NVC7C0_SET_RESERVED_SW_METHOD06:
        return "NVC7C0_SET_RESERVED_SW_METHOD06";
    case NVC7C0_SET_RESERVED_SW_METHOD07:
        return "NVC7C0_SET_RESERVED_SW_METHOD07";
    case NVC7C0_INVALIDATE_TEXTURE_HEADER_CACHE_NO_WFI:
        return "NVC7C0_INVALIDATE_TEXTURE_HEADER_CACHE_NO_WFI";
    case NVC7C0_SET_CWD_REF_COUNTER:
        return "NVC7C0_SET_CWD_REF_COUNTER";
    case NVC7C0_SET_RESERVED_SW_METHOD08:
        return "NVC7C0_SET_RESERVED_SW_METHOD08";
    case NVC7C0_SET_RESERVED_SW_METHOD09:
        return "NVC7C0_SET_RESERVED_SW_METHOD09";
    case NVC7C0_SET_RESERVED_SW_METHOD10:
        return "NVC7C0_SET_RESERVED_SW_METHOD10";
    case NVC7C0_SET_RESERVED_SW_METHOD11:
        return "NVC7C0_SET_RESERVED_SW_METHOD11";
    case NVC7C0_SET_RESERVED_SW_METHOD12:
        return "NVC7C0_SET_RESERVED_SW_METHOD12";
    case NVC7C0_SET_RESERVED_SW_METHOD13:
        return "NVC7C0_SET_RESERVED_SW_METHOD13";
    case NVC7C0_SET_RESERVED_SW_METHOD14:
        return "NVC7C0_SET_RESERVED_SW_METHOD14";
    case NVC7C0_SET_RESERVED_SW_METHOD15:
        return "NVC7C0_SET_RESERVED_SW_METHOD15";
    case NVC7C0_SET_SCG_CONTROL:
        return "NVC7C0_SET_SCG_CONTROL";
    case NVC7C0_SET_COMPUTE_CLASS_VERSION:
        return "NVC7C0_SET_COMPUTE_CLASS_VERSION";
    case NVC7C0_CHECK_COMPUTE_CLASS_VERSION:
        return "NVC7C0_CHECK_COMPUTE_CLASS_VERSION";
    case NVC7C0_SET_QMD_VERSION:
        return "NVC7C0_SET_QMD_VERSION";
    case NVC7C0_CHECK_QMD_VERSION:
        return "NVC7C0_CHECK_QMD_VERSION";
    case NVC7C0_INVALIDATE_SKED_CACHES:
        return "NVC7C0_INVALIDATE_SKED_CACHES";
    case NVC7C0_SET_QMD_VIRTUALIZATION_CONTROL:
        return "NVC7C0_SET_QMD_VIRTUALIZATION_CONTROL";
    case NVC7C0_SET_SHADER_SHARED_MEMORY_WINDOW_A:
        return "NVC7C0_SET_SHADER_SHARED_MEMORY_WINDOW_A";
    case NVC7C0_SET_SHADER_SHARED_MEMORY_WINDOW_B:
        return "NVC7C0_SET_SHADER_SHARED_MEMORY_WINDOW_B";
    case NVC7C0_SCG_HYSTERESIS_CONTROL:
        return "NVC7C0_SCG_HYSTERESIS_CONTROL";
    case NVC7C0_SET_CWD_SLOT_COUNT:
        return "NVC7C0_SET_CWD_SLOT_COUNT";
    case NVC7C0_SEND_PCAS_A:
        return "NVC7C0_SEND_PCAS_A";
    case NVC7C0_SEND_PCAS_B:
        return "NVC7C0_SEND_PCAS_B";
    case NVC7C0_SEND_SIGNALING_PCAS_B:
        return "NVC7C0_SEND_SIGNALING_PCAS_B";
    case NVC7C0_SEND_SIGNALING_PCAS2_B:
        return "NVC7C0_SEND_SIGNALING_PCAS2_B";
    case NVC7C0_SET_SKED_CACHE_CONTROL:
        return "NVC7C0_SET_SKED_CACHE_CONTROL";
    case NVC7C0_SET_SHADER_LOCAL_MEMORY_NON_THROTTLED_A:
        return "NVC7C0_SET_SHADER_LOCAL_MEMORY_NON_THROTTLED_A";
    case NVC7C0_SET_SHADER_LOCAL_MEMORY_NON_THROTTLED_B:
        return "NVC7C0_SET_SHADER_LOCAL_MEMORY_NON_THROTTLED_B";
    case NVC7C0_SET_SHADER_LOCAL_MEMORY_NON_THROTTLED_C:
        return "NVC7C0_SET_SHADER_LOCAL_MEMORY_NON_THROTTLED_C";
    case NVC7C0_SET_SPA_VERSION:
        return "NVC7C0_SET_SPA_VERSION";
    case NVC7C0_SET_INLINE_QMD_ADDRESS_A:
        return "NVC7C0_SET_INLINE_QMD_ADDRESS_A";
    case NVC7C0_SET_INLINE_QMD_ADDRESS_B:
        return "NVC7C0_SET_INLINE_QMD_ADDRESS_B";
    case NVC7C0_LOAD_INLINE_QMD_DATA(0):
        return "NVC7C0_LOAD_INLINE_QMD_DATA(0)";
    case NVC7C0_LOAD_INLINE_QMD_DATA(1):
        return "NVC7C0_LOAD_INLINE_QMD_DATA(1)";
    case NVC7C0_LOAD_INLINE_QMD_DATA(2):
        return "NVC7C0_LOAD_INLINE_QMD_DATA(2)";
    case NVC7C0_LOAD_INLINE_QMD_DATA(3):
        return "NVC7C0_LOAD_INLINE_QMD_DATA(3)";
    case NVC7C0_LOAD_INLINE_QMD_DATA(4):
        return "NVC7C0_LOAD_INLINE_QMD_DATA(4)";
    case NVC7C0_LOAD_INLINE_QMD_DATA(5):
        return "NVC7C0_LOAD_INLINE_QMD_DATA(5)";
    case NVC7C0_LOAD_INLINE_QMD_DATA(6):
        return "NVC7C0_LOAD_INLINE_QMD_DATA(6)";
    case NVC7C0_LOAD_INLINE_QMD_DATA(7):
        return "NVC7C0_LOAD_INLINE_QMD_DATA(7)";
    case NVC7C0_LOAD_INLINE_QMD_DATA(8):
        return "NVC7C0_LOAD_INLINE_QMD_DATA(8)";
    case NVC7C0_LOAD_INLINE_QMD_DATA(9):
        return "NVC7C0_LOAD_INLINE_QMD_DATA(9)";
    case NVC7C0_LOAD_INLINE_QMD_DATA(10):
        return "NVC7C0_LOAD_INLINE_QMD_DATA(10)";
    case NVC7C0_LOAD_INLINE_QMD_DATA(11):
        return "NVC7C0_LOAD_INLINE_QMD_DATA(11)";
    case NVC7C0_LOAD_INLINE_QMD_DATA(12):
        return "NVC7C0_LOAD_INLINE_QMD_DATA(12)";
    case NVC7C0_LOAD_INLINE_QMD_DATA(13):
        return "NVC7C0_LOAD_INLINE_QMD_DATA(13)";
    case NVC7C0_LOAD_INLINE_QMD_DATA(14):
        return "NVC7C0_LOAD_INLINE_QMD_DATA(14)";
    case NVC7C0_LOAD_INLINE_QMD_DATA(15):
        return "NVC7C0_LOAD_INLINE_QMD_DATA(15)";
    case NVC7C0_LOAD_INLINE_QMD_DATA(16):
        return "NVC7C0_LOAD_INLINE_QMD_DATA(16)";
    case NVC7C0_LOAD_INLINE_QMD_DATA(17):
        return "NVC7C0_LOAD_INLINE_QMD_DATA(17)";
    case NVC7C0_LOAD_INLINE_QMD_DATA(18):
        return "NVC7C0_LOAD_INLINE_QMD_DATA(18)";
    case NVC7C0_LOAD_INLINE_QMD_DATA(19):
        return "NVC7C0_LOAD_INLINE_QMD_DATA(19)";
    case NVC7C0_LOAD_INLINE_QMD_DATA(20):
        return "NVC7C0_LOAD_INLINE_QMD_DATA(20)";
    case NVC7C0_LOAD_INLINE_QMD_DATA(21):
        return "NVC7C0_LOAD_INLINE_QMD_DATA(21)";
    case NVC7C0_LOAD_INLINE_QMD_DATA(22):
        return "NVC7C0_LOAD_INLINE_QMD_DATA(22)";
    case NVC7C0_LOAD_INLINE_QMD_DATA(23):
        return "NVC7C0_LOAD_INLINE_QMD_DATA(23)";
    case NVC7C0_LOAD_INLINE_QMD_DATA(24):
        return "NVC7C0_LOAD_INLINE_QMD_DATA(24)";
    case NVC7C0_LOAD_INLINE_QMD_DATA(25):
        return "NVC7C0_LOAD_INLINE_QMD_DATA(25)";
    case NVC7C0_LOAD_INLINE_QMD_DATA(26):
        return "NVC7C0_LOAD_INLINE_QMD_DATA(26)";
    case NVC7C0_LOAD_INLINE_QMD_DATA(27):
        return "NVC7C0_LOAD_INLINE_QMD_DATA(27)";
    case NVC7C0_LOAD_INLINE_QMD_DATA(28):
        return "NVC7C0_LOAD_INLINE_QMD_DATA(28)";
    case NVC7C0_LOAD_INLINE_QMD_DATA(29):
        return "NVC7C0_LOAD_INLINE_QMD_DATA(29)";
    case NVC7C0_LOAD_INLINE_QMD_DATA(30):
        return "NVC7C0_LOAD_INLINE_QMD_DATA(30)";
    case NVC7C0_LOAD_INLINE_QMD_DATA(31):
        return "NVC7C0_LOAD_INLINE_QMD_DATA(31)";
    case NVC7C0_LOAD_INLINE_QMD_DATA(32):
        return "NVC7C0_LOAD_INLINE_QMD_DATA(32)";
    case NVC7C0_LOAD_INLINE_QMD_DATA(33):
        return "NVC7C0_LOAD_INLINE_QMD_DATA(33)";
    case NVC7C0_LOAD_INLINE_QMD_DATA(34):
        return "NVC7C0_LOAD_INLINE_QMD_DATA(34)";
    case NVC7C0_LOAD_INLINE_QMD_DATA(35):
        return "NVC7C0_LOAD_INLINE_QMD_DATA(35)";
    case NVC7C0_LOAD_INLINE_QMD_DATA(36):
        return "NVC7C0_LOAD_INLINE_QMD_DATA(36)";
    case NVC7C0_LOAD_INLINE_QMD_DATA(37):
        return "NVC7C0_LOAD_INLINE_QMD_DATA(37)";
    case NVC7C0_LOAD_INLINE_QMD_DATA(38):
        return "NVC7C0_LOAD_INLINE_QMD_DATA(38)";
    case NVC7C0_LOAD_INLINE_QMD_DATA(39):
        return "NVC7C0_LOAD_INLINE_QMD_DATA(39)";
    case NVC7C0_LOAD_INLINE_QMD_DATA(40):
        return "NVC7C0_LOAD_INLINE_QMD_DATA(40)";
    case NVC7C0_LOAD_INLINE_QMD_DATA(41):
        return "NVC7C0_LOAD_INLINE_QMD_DATA(41)";
    case NVC7C0_LOAD_INLINE_QMD_DATA(42):
        return "NVC7C0_LOAD_INLINE_QMD_DATA(42)";
    case NVC7C0_LOAD_INLINE_QMD_DATA(43):
        return "NVC7C0_LOAD_INLINE_QMD_DATA(43)";
    case NVC7C0_LOAD_INLINE_QMD_DATA(44):
        return "NVC7C0_LOAD_INLINE_QMD_DATA(44)";
    case NVC7C0_LOAD_INLINE_QMD_DATA(45):
        return "NVC7C0_LOAD_INLINE_QMD_DATA(45)";
    case NVC7C0_LOAD_INLINE_QMD_DATA(46):
        return "NVC7C0_LOAD_INLINE_QMD_DATA(46)";
    case NVC7C0_LOAD_INLINE_QMD_DATA(47):
        return "NVC7C0_LOAD_INLINE_QMD_DATA(47)";
    case NVC7C0_LOAD_INLINE_QMD_DATA(48):
        return "NVC7C0_LOAD_INLINE_QMD_DATA(48)";
    case NVC7C0_LOAD_INLINE_QMD_DATA(49):
        return "NVC7C0_LOAD_INLINE_QMD_DATA(49)";
    case NVC7C0_LOAD_INLINE_QMD_DATA(50):
        return "NVC7C0_LOAD_INLINE_QMD_DATA(50)";
    case NVC7C0_LOAD_INLINE_QMD_DATA(51):
        return "NVC7C0_LOAD_INLINE_QMD_DATA(51)";
    case NVC7C0_LOAD_INLINE_QMD_DATA(52):
        return "NVC7C0_LOAD_INLINE_QMD_DATA(52)";
    case NVC7C0_LOAD_INLINE_QMD_DATA(53):
        return "NVC7C0_LOAD_INLINE_QMD_DATA(53)";
    case NVC7C0_LOAD_INLINE_QMD_DATA(54):
        return "NVC7C0_LOAD_INLINE_QMD_DATA(54)";
    case NVC7C0_LOAD_INLINE_QMD_DATA(55):
        return "NVC7C0_LOAD_INLINE_QMD_DATA(55)";
    case NVC7C0_LOAD_INLINE_QMD_DATA(56):
        return "NVC7C0_LOAD_INLINE_QMD_DATA(56)";
    case NVC7C0_LOAD_INLINE_QMD_DATA(57):
        return "NVC7C0_LOAD_INLINE_QMD_DATA(57)";
    case NVC7C0_LOAD_INLINE_QMD_DATA(58):
        return "NVC7C0_LOAD_INLINE_QMD_DATA(58)";
    case NVC7C0_LOAD_INLINE_QMD_DATA(59):
        return "NVC7C0_LOAD_INLINE_QMD_DATA(59)";
    case NVC7C0_LOAD_INLINE_QMD_DATA(60):
        return "NVC7C0_LOAD_INLINE_QMD_DATA(60)";
    case NVC7C0_LOAD_INLINE_QMD_DATA(61):
        return "NVC7C0_LOAD_INLINE_QMD_DATA(61)";
    case NVC7C0_LOAD_INLINE_QMD_DATA(62):
        return "NVC7C0_LOAD_INLINE_QMD_DATA(62)";
    case NVC7C0_LOAD_INLINE_QMD_DATA(63):
        return "NVC7C0_LOAD_INLINE_QMD_DATA(63)";
    case NVC7C0_SET_FALCON00:
        return "NVC7C0_SET_FALCON00";
    case NVC7C0_SET_FALCON01:
        return "NVC7C0_SET_FALCON01";
    case NVC7C0_SET_FALCON02:
        return "NVC7C0_SET_FALCON02";
    case NVC7C0_SET_FALCON03:
        return "NVC7C0_SET_FALCON03";
    case NVC7C0_SET_FALCON04:
        return "NVC7C0_SET_FALCON04";
    case NVC7C0_SET_FALCON05:
        return "NVC7C0_SET_FALCON05";
    case NVC7C0_SET_FALCON06:
        return "NVC7C0_SET_FALCON06";
    case NVC7C0_SET_FALCON07:
        return "NVC7C0_SET_FALCON07";
    case NVC7C0_SET_FALCON08:
        return "NVC7C0_SET_FALCON08";
    case NVC7C0_SET_FALCON09:
        return "NVC7C0_SET_FALCON09";
    case NVC7C0_SET_FALCON10:
        return "NVC7C0_SET_FALCON10";
    case NVC7C0_SET_FALCON11:
        return "NVC7C0_SET_FALCON11";
    case NVC7C0_SET_FALCON12:
        return "NVC7C0_SET_FALCON12";
    case NVC7C0_SET_FALCON13:
        return "NVC7C0_SET_FALCON13";
    case NVC7C0_SET_FALCON14:
        return "NVC7C0_SET_FALCON14";
    case NVC7C0_SET_FALCON15:
        return "NVC7C0_SET_FALCON15";
    case NVC7C0_SET_MME_MEM_ADDRESS_A:
        return "NVC7C0_SET_MME_MEM_ADDRESS_A";
    case NVC7C0_SET_MME_MEM_ADDRESS_B:
        return "NVC7C0_SET_MME_MEM_ADDRESS_B";
    case NVC7C0_SET_MME_DATA_RAM_ADDRESS:
        return "NVC7C0_SET_MME_DATA_RAM_ADDRESS";
    case NVC7C0_MME_DMA_READ:
        return "NVC7C0_MME_DMA_READ";
    case NVC7C0_MME_DMA_READ_FIFOED:
        return "NVC7C0_MME_DMA_READ_FIFOED";
    case NVC7C0_MME_DMA_WRITE:
        return "NVC7C0_MME_DMA_WRITE";
    case NVC7C0_MME_DMA_REDUCTION:
        return "NVC7C0_MME_DMA_REDUCTION";
    case NVC7C0_MME_DMA_SYSMEMBAR:
        return "NVC7C0_MME_DMA_SYSMEMBAR";
    case NVC7C0_MME_DMA_SYNC:
        return "NVC7C0_MME_DMA_SYNC";
    case NVC7C0_SET_MME_DATA_FIFO_CONFIG:
        return "NVC7C0_SET_MME_DATA_FIFO_CONFIG";
    case NVC7C0_SET_SHADER_LOCAL_MEMORY_A:
        return "NVC7C0_SET_SHADER_LOCAL_MEMORY_A";
    case NVC7C0_SET_SHADER_LOCAL_MEMORY_B:
        return "NVC7C0_SET_SHADER_LOCAL_MEMORY_B";
    case NVC7C0_SET_SHADER_LOCAL_MEMORY_WINDOW_A:
        return "NVC7C0_SET_SHADER_LOCAL_MEMORY_WINDOW_A";
    case NVC7C0_SET_SHADER_LOCAL_MEMORY_WINDOW_B:
        return "NVC7C0_SET_SHADER_LOCAL_MEMORY_WINDOW_B";
    case NVC7C0_THROTTLE_SM:
        return "NVC7C0_THROTTLE_SM";
    case NVC7C0_SET_SHADER_CACHE_CONTROL:
        return "NVC7C0_SET_SHADER_CACHE_CONTROL";
    case NVC7C0_SET_SCG_COMPUTE_SCHEDULING_PARAMETERS(0):
        return "NVC7C0_SET_SCG_COMPUTE_SCHEDULING_PARAMETERS(0)";
    case NVC7C0_SET_SCG_COMPUTE_SCHEDULING_PARAMETERS(1):
        return "NVC7C0_SET_SCG_COMPUTE_SCHEDULING_PARAMETERS(1)";
    case NVC7C0_SET_SCG_COMPUTE_SCHEDULING_PARAMETERS(2):
        return "NVC7C0_SET_SCG_COMPUTE_SCHEDULING_PARAMETERS(2)";
    case NVC7C0_SET_SCG_COMPUTE_SCHEDULING_PARAMETERS(3):
        return "NVC7C0_SET_SCG_COMPUTE_SCHEDULING_PARAMETERS(3)";
    case NVC7C0_SET_SCG_COMPUTE_SCHEDULING_PARAMETERS(4):
        return "NVC7C0_SET_SCG_COMPUTE_SCHEDULING_PARAMETERS(4)";
    case NVC7C0_SET_SCG_COMPUTE_SCHEDULING_PARAMETERS(5):
        return "NVC7C0_SET_SCG_COMPUTE_SCHEDULING_PARAMETERS(5)";
    case NVC7C0_SET_SCG_COMPUTE_SCHEDULING_PARAMETERS(6):
        return "NVC7C0_SET_SCG_COMPUTE_SCHEDULING_PARAMETERS(6)";
    case NVC7C0_SET_SCG_COMPUTE_SCHEDULING_PARAMETERS(7):
        return "NVC7C0_SET_SCG_COMPUTE_SCHEDULING_PARAMETERS(7)";
    case NVC7C0_SET_SCG_COMPUTE_SCHEDULING_PARAMETERS(8):
        return "NVC7C0_SET_SCG_COMPUTE_SCHEDULING_PARAMETERS(8)";
    case NVC7C0_SET_SCG_COMPUTE_SCHEDULING_PARAMETERS(9):
        return "NVC7C0_SET_SCG_COMPUTE_SCHEDULING_PARAMETERS(9)";
    case NVC7C0_SET_SCG_COMPUTE_SCHEDULING_PARAMETERS(10):
        return "NVC7C0_SET_SCG_COMPUTE_SCHEDULING_PARAMETERS(10)";
    case NVC7C0_SET_SCG_COMPUTE_SCHEDULING_PARAMETERS(11):
        return "NVC7C0_SET_SCG_COMPUTE_SCHEDULING_PARAMETERS(11)";
    case NVC7C0_SET_SCG_COMPUTE_SCHEDULING_PARAMETERS(12):
        return "NVC7C0_SET_SCG_COMPUTE_SCHEDULING_PARAMETERS(12)";
    case NVC7C0_SET_SCG_COMPUTE_SCHEDULING_PARAMETERS(13):
        return "NVC7C0_SET_SCG_COMPUTE_SCHEDULING_PARAMETERS(13)";
    case NVC7C0_SET_SCG_COMPUTE_SCHEDULING_PARAMETERS(14):
        return "NVC7C0_SET_SCG_COMPUTE_SCHEDULING_PARAMETERS(14)";
    case NVC7C0_SET_SCG_COMPUTE_SCHEDULING_PARAMETERS(15):
        return "NVC7C0_SET_SCG_COMPUTE_SCHEDULING_PARAMETERS(15)";
    case NVC7C0_SET_SM_TIMEOUT_INTERVAL:
        return "NVC7C0_SET_SM_TIMEOUT_INTERVAL";
    case NVC7C0_MME_DMA_WRITE_METHOD_BARRIER:
        return "NVC7C0_MME_DMA_WRITE_METHOD_BARRIER";
    case NVC7C0_INVALIDATE_TEXTURE_DATA_CACHE_NO_WFI:
        return "NVC7C0_INVALIDATE_TEXTURE_DATA_CACHE_NO_WFI";
    case NVC7C0_ACTIVATE_PERF_SETTINGS_FOR_COMPUTE_CONTEXT:
        return "NVC7C0_ACTIVATE_PERF_SETTINGS_FOR_COMPUTE_CONTEXT";
    case NVC7C0_INVALIDATE_SAMPLER_CACHE:
        return "NVC7C0_INVALIDATE_SAMPLER_CACHE";
    case NVC7C0_INVALIDATE_TEXTURE_HEADER_CACHE:
        return "NVC7C0_INVALIDATE_TEXTURE_HEADER_CACHE";
    case NVC7C0_INVALIDATE_TEXTURE_DATA_CACHE:
        return "NVC7C0_INVALIDATE_TEXTURE_DATA_CACHE";
    case NVC7C0_INVALIDATE_SAMPLER_CACHE_NO_WFI:
        return "NVC7C0_INVALIDATE_SAMPLER_CACHE_NO_WFI";
    case NVC7C0_SET_SHADER_EXCEPTIONS:
        return "NVC7C0_SET_SHADER_EXCEPTIONS";
    case NVC7C0_SET_RENDER_ENABLE_A:
        return "NVC7C0_SET_RENDER_ENABLE_A";
    case NVC7C0_SET_RENDER_ENABLE_B:
        return "NVC7C0_SET_RENDER_ENABLE_B";
    case NVC7C0_SET_RENDER_ENABLE_C:
        return "NVC7C0_SET_RENDER_ENABLE_C";
    case NVC7C0_SET_TEX_SAMPLER_POOL_A:
        return "NVC7C0_SET_TEX_SAMPLER_POOL_A";
    case NVC7C0_SET_TEX_SAMPLER_POOL_B:
        return "NVC7C0_SET_TEX_SAMPLER_POOL_B";
    case NVC7C0_SET_TEX_SAMPLER_POOL_C:
        return "NVC7C0_SET_TEX_SAMPLER_POOL_C";
    case NVC7C0_SET_TEX_HEADER_POOL_A:
        return "NVC7C0_SET_TEX_HEADER_POOL_A";
    case NVC7C0_SET_TEX_HEADER_POOL_B:
        return "NVC7C0_SET_TEX_HEADER_POOL_B";
    case NVC7C0_SET_TEX_HEADER_POOL_C:
        return "NVC7C0_SET_TEX_HEADER_POOL_C";
    case NVC7C0_INVALIDATE_SHADER_CACHES_NO_WFI:
        return "NVC7C0_INVALIDATE_SHADER_CACHES_NO_WFI";
    case NVC7C0_SET_RENDER_ENABLE_OVERRIDE:
        return "NVC7C0_SET_RENDER_ENABLE_OVERRIDE";
    case NVC7C0_PIPE_NOP:
        return "NVC7C0_PIPE_NOP";
    case NVC7C0_SET_SPARE00:
        return "NVC7C0_SET_SPARE00";
    case NVC7C0_SET_SPARE01:
        return "NVC7C0_SET_SPARE01";
    case NVC7C0_SET_SPARE02:
        return "NVC7C0_SET_SPARE02";
    case NVC7C0_SET_SPARE03:
        return "NVC7C0_SET_SPARE03";
    case NVC7C0_SET_REPORT_SEMAPHORE_A:
        return "NVC7C0_SET_REPORT_SEMAPHORE_A";
    case NVC7C0_SET_REPORT_SEMAPHORE_B:
        return "NVC7C0_SET_REPORT_SEMAPHORE_B";
    case NVC7C0_SET_REPORT_SEMAPHORE_C:
        return "NVC7C0_SET_REPORT_SEMAPHORE_C";
    case NVC7C0_SET_REPORT_SEMAPHORE_D:
        return "NVC7C0_SET_REPORT_SEMAPHORE_D";
    case NVC7C0_SET_TRAP_HANDLER_A:
        return "NVC7C0_SET_TRAP_HANDLER_A";
    case NVC7C0_SET_TRAP_HANDLER_B:
        return "NVC7C0_SET_TRAP_HANDLER_B";
    case NVC7C0_SET_BINDLESS_TEXTURE:
        return "NVC7C0_SET_BINDLESS_TEXTURE";
    case NVC7C0_SET_SHADER_PERFORMANCE_SNAPSHOT_COUNTER_VALUE(0):
        return "NVC7C0_SET_SHADER_PERFORMANCE_SNAPSHOT_COUNTER_VALUE(0)";
    case NVC7C0_SET_SHADER_PERFORMANCE_SNAPSHOT_COUNTER_VALUE(1):
        return "NVC7C0_SET_SHADER_PERFORMANCE_SNAPSHOT_COUNTER_VALUE(1)";
    case NVC7C0_SET_SHADER_PERFORMANCE_SNAPSHOT_COUNTER_VALUE(2):
        return "NVC7C0_SET_SHADER_PERFORMANCE_SNAPSHOT_COUNTER_VALUE(2)";
    case NVC7C0_SET_SHADER_PERFORMANCE_SNAPSHOT_COUNTER_VALUE(3):
        return "NVC7C0_SET_SHADER_PERFORMANCE_SNAPSHOT_COUNTER_VALUE(3)";
    case NVC7C0_SET_SHADER_PERFORMANCE_SNAPSHOT_COUNTER_VALUE(4):
        return "NVC7C0_SET_SHADER_PERFORMANCE_SNAPSHOT_COUNTER_VALUE(4)";
    case NVC7C0_SET_SHADER_PERFORMANCE_SNAPSHOT_COUNTER_VALUE(5):
        return "NVC7C0_SET_SHADER_PERFORMANCE_SNAPSHOT_COUNTER_VALUE(5)";
    case NVC7C0_SET_SHADER_PERFORMANCE_SNAPSHOT_COUNTER_VALUE(6):
        return "NVC7C0_SET_SHADER_PERFORMANCE_SNAPSHOT_COUNTER_VALUE(6)";
    case NVC7C0_SET_SHADER_PERFORMANCE_SNAPSHOT_COUNTER_VALUE(7):
        return "NVC7C0_SET_SHADER_PERFORMANCE_SNAPSHOT_COUNTER_VALUE(7)";
    case NVC7C0_SET_SHADER_PERFORMANCE_SNAPSHOT_COUNTER_VALUE_UPPER(0):
        return "NVC7C0_SET_SHADER_PERFORMANCE_SNAPSHOT_COUNTER_VALUE_UPPER(0)";
    case NVC7C0_SET_SHADER_PERFORMANCE_SNAPSHOT_COUNTER_VALUE_UPPER(1):
        return "NVC7C0_SET_SHADER_PERFORMANCE_SNAPSHOT_COUNTER_VALUE_UPPER(1)";
    case NVC7C0_SET_SHADER_PERFORMANCE_SNAPSHOT_COUNTER_VALUE_UPPER(2):
        return "NVC7C0_SET_SHADER_PERFORMANCE_SNAPSHOT_COUNTER_VALUE_UPPER(2)";
    case NVC7C0_SET_SHADER_PERFORMANCE_SNAPSHOT_COUNTER_VALUE_UPPER(3):
        return "NVC7C0_SET_SHADER_PERFORMANCE_SNAPSHOT_COUNTER_VALUE_UPPER(3)";
    case NVC7C0_SET_SHADER_PERFORMANCE_SNAPSHOT_COUNTER_VALUE_UPPER(4):
        return "NVC7C0_SET_SHADER_PERFORMANCE_SNAPSHOT_COUNTER_VALUE_UPPER(4)";
    case NVC7C0_SET_SHADER_PERFORMANCE_SNAPSHOT_COUNTER_VALUE_UPPER(5):
        return "NVC7C0_SET_SHADER_PERFORMANCE_SNAPSHOT_COUNTER_VALUE_UPPER(5)";
    case NVC7C0_SET_SHADER_PERFORMANCE_SNAPSHOT_COUNTER_VALUE_UPPER(6):
        return "NVC7C0_SET_SHADER_PERFORMANCE_SNAPSHOT_COUNTER_VALUE_UPPER(6)";
    case NVC7C0_SET_SHADER_PERFORMANCE_SNAPSHOT_COUNTER_VALUE_UPPER(7):
        return "NVC7C0_SET_SHADER_PERFORMANCE_SNAPSHOT_COUNTER_VALUE_UPPER(7)";
    case NVC7C0_ENABLE_SHADER_PERFORMANCE_SNAPSHOT_COUNTER:
        return "NVC7C0_ENABLE_SHADER_PERFORMANCE_SNAPSHOT_COUNTER";
    case NVC7C0_DISABLE_SHADER_PERFORMANCE_SNAPSHOT_COUNTER:
        return "NVC7C0_DISABLE_SHADER_PERFORMANCE_SNAPSHOT_COUNTER";
    case NVC7C0_SET_SHADER_PERFORMANCE_COUNTER_VALUE_UPPER(0):
        return "NVC7C0_SET_SHADER_PERFORMANCE_COUNTER_VALUE_UPPER(0)";
    case NVC7C0_SET_SHADER_PERFORMANCE_COUNTER_VALUE_UPPER(1):
        return "NVC7C0_SET_SHADER_PERFORMANCE_COUNTER_VALUE_UPPER(1)";
    case NVC7C0_SET_SHADER_PERFORMANCE_COUNTER_VALUE_UPPER(2):
        return "NVC7C0_SET_SHADER_PERFORMANCE_COUNTER_VALUE_UPPER(2)";
    case NVC7C0_SET_SHADER_PERFORMANCE_COUNTER_VALUE_UPPER(3):
        return "NVC7C0_SET_SHADER_PERFORMANCE_COUNTER_VALUE_UPPER(3)";
    case NVC7C0_SET_SHADER_PERFORMANCE_COUNTER_VALUE_UPPER(4):
        return "NVC7C0_SET_SHADER_PERFORMANCE_COUNTER_VALUE_UPPER(4)";
    case NVC7C0_SET_SHADER_PERFORMANCE_COUNTER_VALUE_UPPER(5):
        return "NVC7C0_SET_SHADER_PERFORMANCE_COUNTER_VALUE_UPPER(5)";
    case NVC7C0_SET_SHADER_PERFORMANCE_COUNTER_VALUE_UPPER(6):
        return "NVC7C0_SET_SHADER_PERFORMANCE_COUNTER_VALUE_UPPER(6)";
    case NVC7C0_SET_SHADER_PERFORMANCE_COUNTER_VALUE_UPPER(7):
        return "NVC7C0_SET_SHADER_PERFORMANCE_COUNTER_VALUE_UPPER(7)";
    case NVC7C0_SET_SHADER_PERFORMANCE_COUNTER_VALUE(0):
        return "NVC7C0_SET_SHADER_PERFORMANCE_COUNTER_VALUE(0)";
    case NVC7C0_SET_SHADER_PERFORMANCE_COUNTER_VALUE(1):
        return "NVC7C0_SET_SHADER_PERFORMANCE_COUNTER_VALUE(1)";
    case NVC7C0_SET_SHADER_PERFORMANCE_COUNTER_VALUE(2):
        return "NVC7C0_SET_SHADER_PERFORMANCE_COUNTER_VALUE(2)";
    case NVC7C0_SET_SHADER_PERFORMANCE_COUNTER_VALUE(3):
        return "NVC7C0_SET_SHADER_PERFORMANCE_COUNTER_VALUE(3)";
    case NVC7C0_SET_SHADER_PERFORMANCE_COUNTER_VALUE(4):
        return "NVC7C0_SET_SHADER_PERFORMANCE_COUNTER_VALUE(4)";
    case NVC7C0_SET_SHADER_PERFORMANCE_COUNTER_VALUE(5):
        return "NVC7C0_SET_SHADER_PERFORMANCE_COUNTER_VALUE(5)";
    case NVC7C0_SET_SHADER_PERFORMANCE_COUNTER_VALUE(6):
        return "NVC7C0_SET_SHADER_PERFORMANCE_COUNTER_VALUE(6)";
    case NVC7C0_SET_SHADER_PERFORMANCE_COUNTER_VALUE(7):
        return "NVC7C0_SET_SHADER_PERFORMANCE_COUNTER_VALUE(7)";
    case NVC7C0_SET_SHADER_PERFORMANCE_COUNTER_EVENT(0):
        return "NVC7C0_SET_SHADER_PERFORMANCE_COUNTER_EVENT(0)";
    case NVC7C0_SET_SHADER_PERFORMANCE_COUNTER_EVENT(1):
        return "NVC7C0_SET_SHADER_PERFORMANCE_COUNTER_EVENT(1)";
    case NVC7C0_SET_SHADER_PERFORMANCE_COUNTER_EVENT(2):
        return "NVC7C0_SET_SHADER_PERFORMANCE_COUNTER_EVENT(2)";
    case NVC7C0_SET_SHADER_PERFORMANCE_COUNTER_EVENT(3):
        return "NVC7C0_SET_SHADER_PERFORMANCE_COUNTER_EVENT(3)";
    case NVC7C0_SET_SHADER_PERFORMANCE_COUNTER_EVENT(4):
        return "NVC7C0_SET_SHADER_PERFORMANCE_COUNTER_EVENT(4)";
    case NVC7C0_SET_SHADER_PERFORMANCE_COUNTER_EVENT(5):
        return "NVC7C0_SET_SHADER_PERFORMANCE_COUNTER_EVENT(5)";
    case NVC7C0_SET_SHADER_PERFORMANCE_COUNTER_EVENT(6):
        return "NVC7C0_SET_SHADER_PERFORMANCE_COUNTER_EVENT(6)";
    case NVC7C0_SET_SHADER_PERFORMANCE_COUNTER_EVENT(7):
        return "NVC7C0_SET_SHADER_PERFORMANCE_COUNTER_EVENT(7)";
    case NVC7C0_SET_SHADER_PERFORMANCE_COUNTER_CONTROL_A(0):
        return "NVC7C0_SET_SHADER_PERFORMANCE_COUNTER_CONTROL_A(0)";
    case NVC7C0_SET_SHADER_PERFORMANCE_COUNTER_CONTROL_A(1):
        return "NVC7C0_SET_SHADER_PERFORMANCE_COUNTER_CONTROL_A(1)";
    case NVC7C0_SET_SHADER_PERFORMANCE_COUNTER_CONTROL_A(2):
        return "NVC7C0_SET_SHADER_PERFORMANCE_COUNTER_CONTROL_A(2)";
    case NVC7C0_SET_SHADER_PERFORMANCE_COUNTER_CONTROL_A(3):
        return "NVC7C0_SET_SHADER_PERFORMANCE_COUNTER_CONTROL_A(3)";
    case NVC7C0_SET_SHADER_PERFORMANCE_COUNTER_CONTROL_A(4):
        return "NVC7C0_SET_SHADER_PERFORMANCE_COUNTER_CONTROL_A(4)";
    case NVC7C0_SET_SHADER_PERFORMANCE_COUNTER_CONTROL_A(5):
        return "NVC7C0_SET_SHADER_PERFORMANCE_COUNTER_CONTROL_A(5)";
    case NVC7C0_SET_SHADER_PERFORMANCE_COUNTER_CONTROL_A(6):
        return "NVC7C0_SET_SHADER_PERFORMANCE_COUNTER_CONTROL_A(6)";
    case NVC7C0_SET_SHADER_PERFORMANCE_COUNTER_CONTROL_A(7):
        return "NVC7C0_SET_SHADER_PERFORMANCE_COUNTER_CONTROL_A(7)";
    case NVC7C0_SET_SHADER_PERFORMANCE_COUNTER_CONTROL_B(0):
        return "NVC7C0_SET_SHADER_PERFORMANCE_COUNTER_CONTROL_B(0)";
    case NVC7C0_SET_SHADER_PERFORMANCE_COUNTER_CONTROL_B(1):
        return "NVC7C0_SET_SHADER_PERFORMANCE_COUNTER_CONTROL_B(1)";
    case NVC7C0_SET_SHADER_PERFORMANCE_COUNTER_CONTROL_B(2):
        return "NVC7C0_SET_SHADER_PERFORMANCE_COUNTER_CONTROL_B(2)";
    case NVC7C0_SET_SHADER_PERFORMANCE_COUNTER_CONTROL_B(3):
        return "NVC7C0_SET_SHADER_PERFORMANCE_COUNTER_CONTROL_B(3)";
    case NVC7C0_SET_SHADER_PERFORMANCE_COUNTER_CONTROL_B(4):
        return "NVC7C0_SET_SHADER_PERFORMANCE_COUNTER_CONTROL_B(4)";
    case NVC7C0_SET_SHADER_PERFORMANCE_COUNTER_CONTROL_B(5):
        return "NVC7C0_SET_SHADER_PERFORMANCE_COUNTER_CONTROL_B(5)";
    case NVC7C0_SET_SHADER_PERFORMANCE_COUNTER_CONTROL_B(6):
        return "NVC7C0_SET_SHADER_PERFORMANCE_COUNTER_CONTROL_B(6)";
    case NVC7C0_SET_SHADER_PERFORMANCE_COUNTER_CONTROL_B(7):
        return "NVC7C0_SET_SHADER_PERFORMANCE_COUNTER_CONTROL_B(7)";
    case NVC7C0_SET_SHADER_PERFORMANCE_COUNTER_TRAP_CONTROL:
        return "NVC7C0_SET_SHADER_PERFORMANCE_COUNTER_TRAP_CONTROL";
    case NVC7C0_START_SHADER_PERFORMANCE_COUNTER:
        return "NVC7C0_START_SHADER_PERFORMANCE_COUNTER";
    case NVC7C0_STOP_SHADER_PERFORMANCE_COUNTER:
        return "NVC7C0_STOP_SHADER_PERFORMANCE_COUNTER";
    case NVC7C0_SET_SHADER_PERFORMANCE_COUNTER_SCTL_FILTER:
        return "NVC7C0_SET_SHADER_PERFORMANCE_COUNTER_SCTL_FILTER";
    case NVC7C0_SET_SHADER_PERFORMANCE_COUNTER_CORE_MIO_FILTER:
        return "NVC7C0_SET_SHADER_PERFORMANCE_COUNTER_CORE_MIO_FILTER";
    case NVC7C0_SET_MME_SHADOW_SCRATCH(0):
        return "NVC7C0_SET_MME_SHADOW_SCRATCH(0)";
    case NVC7C0_SET_MME_SHADOW_SCRATCH(1):
        return "NVC7C0_SET_MME_SHADOW_SCRATCH(1)";
    case NVC7C0_SET_MME_SHADOW_SCRATCH(2):
        return "NVC7C0_SET_MME_SHADOW_SCRATCH(2)";
    case NVC7C0_SET_MME_SHADOW_SCRATCH(3):
        return "NVC7C0_SET_MME_SHADOW_SCRATCH(3)";
    case NVC7C0_SET_MME_SHADOW_SCRATCH(4):
        return "NVC7C0_SET_MME_SHADOW_SCRATCH(4)";
    case NVC7C0_SET_MME_SHADOW_SCRATCH(5):
        return "NVC7C0_SET_MME_SHADOW_SCRATCH(5)";
    case NVC7C0_SET_MME_SHADOW_SCRATCH(6):
        return "NVC7C0_SET_MME_SHADOW_SCRATCH(6)";
    case NVC7C0_SET_MME_SHADOW_SCRATCH(7):
        return "NVC7C0_SET_MME_SHADOW_SCRATCH(7)";
    case NVC7C0_SET_MME_SHADOW_SCRATCH(8):
        return "NVC7C0_SET_MME_SHADOW_SCRATCH(8)";
    case NVC7C0_SET_MME_SHADOW_SCRATCH(9):
        return "NVC7C0_SET_MME_SHADOW_SCRATCH(9)";
    case NVC7C0_SET_MME_SHADOW_SCRATCH(10):
        return "NVC7C0_SET_MME_SHADOW_SCRATCH(10)";
    case NVC7C0_SET_MME_SHADOW_SCRATCH(11):
        return "NVC7C0_SET_MME_SHADOW_SCRATCH(11)";
    case NVC7C0_SET_MME_SHADOW_SCRATCH(12):
        return "NVC7C0_SET_MME_SHADOW_SCRATCH(12)";
    case NVC7C0_SET_MME_SHADOW_SCRATCH(13):
        return "NVC7C0_SET_MME_SHADOW_SCRATCH(13)";
    case NVC7C0_SET_MME_SHADOW_SCRATCH(14):
        return "NVC7C0_SET_MME_SHADOW_SCRATCH(14)";
    case NVC7C0_SET_MME_SHADOW_SCRATCH(15):
        return "NVC7C0_SET_MME_SHADOW_SCRATCH(15)";
    case NVC7C0_SET_MME_SHADOW_SCRATCH(16):
        return "NVC7C0_SET_MME_SHADOW_SCRATCH(16)";
    case NVC7C0_SET_MME_SHADOW_SCRATCH(17):
        return "NVC7C0_SET_MME_SHADOW_SCRATCH(17)";
    case NVC7C0_SET_MME_SHADOW_SCRATCH(18):
        return "NVC7C0_SET_MME_SHADOW_SCRATCH(18)";
    case NVC7C0_SET_MME_SHADOW_SCRATCH(19):
        return "NVC7C0_SET_MME_SHADOW_SCRATCH(19)";
    case NVC7C0_SET_MME_SHADOW_SCRATCH(20):
        return "NVC7C0_SET_MME_SHADOW_SCRATCH(20)";
    case NVC7C0_SET_MME_SHADOW_SCRATCH(21):
        return "NVC7C0_SET_MME_SHADOW_SCRATCH(21)";
    case NVC7C0_SET_MME_SHADOW_SCRATCH(22):
        return "NVC7C0_SET_MME_SHADOW_SCRATCH(22)";
    case NVC7C0_SET_MME_SHADOW_SCRATCH(23):
        return "NVC7C0_SET_MME_SHADOW_SCRATCH(23)";
    case NVC7C0_SET_MME_SHADOW_SCRATCH(24):
        return "NVC7C0_SET_MME_SHADOW_SCRATCH(24)";
    case NVC7C0_SET_MME_SHADOW_SCRATCH(25):
        return "NVC7C0_SET_MME_SHADOW_SCRATCH(25)";
    case NVC7C0_SET_MME_SHADOW_SCRATCH(26):
        return "NVC7C0_SET_MME_SHADOW_SCRATCH(26)";
    case NVC7C0_SET_MME_SHADOW_SCRATCH(27):
        return "NVC7C0_SET_MME_SHADOW_SCRATCH(27)";
    case NVC7C0_SET_MME_SHADOW_SCRATCH(28):
        return "NVC7C0_SET_MME_SHADOW_SCRATCH(28)";
    case NVC7C0_SET_MME_SHADOW_SCRATCH(29):
        return "NVC7C0_SET_MME_SHADOW_SCRATCH(29)";
    case NVC7C0_SET_MME_SHADOW_SCRATCH(30):
        return "NVC7C0_SET_MME_SHADOW_SCRATCH(30)";
    case NVC7C0_SET_MME_SHADOW_SCRATCH(31):
        return "NVC7C0_SET_MME_SHADOW_SCRATCH(31)";
    case NVC7C0_SET_MME_SHADOW_SCRATCH(32):
        return "NVC7C0_SET_MME_SHADOW_SCRATCH(32)";
    case NVC7C0_SET_MME_SHADOW_SCRATCH(33):
        return "NVC7C0_SET_MME_SHADOW_SCRATCH(33)";
    case NVC7C0_SET_MME_SHADOW_SCRATCH(34):
        return "NVC7C0_SET_MME_SHADOW_SCRATCH(34)";
    case NVC7C0_SET_MME_SHADOW_SCRATCH(35):
        return "NVC7C0_SET_MME_SHADOW_SCRATCH(35)";
    case NVC7C0_SET_MME_SHADOW_SCRATCH(36):
        return "NVC7C0_SET_MME_SHADOW_SCRATCH(36)";
    case NVC7C0_SET_MME_SHADOW_SCRATCH(37):
        return "NVC7C0_SET_MME_SHADOW_SCRATCH(37)";
    case NVC7C0_SET_MME_SHADOW_SCRATCH(38):
        return "NVC7C0_SET_MME_SHADOW_SCRATCH(38)";
    case NVC7C0_SET_MME_SHADOW_SCRATCH(39):
        return "NVC7C0_SET_MME_SHADOW_SCRATCH(39)";
    case NVC7C0_SET_MME_SHADOW_SCRATCH(40):
        return "NVC7C0_SET_MME_SHADOW_SCRATCH(40)";
    case NVC7C0_SET_MME_SHADOW_SCRATCH(41):
        return "NVC7C0_SET_MME_SHADOW_SCRATCH(41)";
    case NVC7C0_SET_MME_SHADOW_SCRATCH(42):
        return "NVC7C0_SET_MME_SHADOW_SCRATCH(42)";
    case NVC7C0_SET_MME_SHADOW_SCRATCH(43):
        return "NVC7C0_SET_MME_SHADOW_SCRATCH(43)";
    case NVC7C0_SET_MME_SHADOW_SCRATCH(44):
        return "NVC7C0_SET_MME_SHADOW_SCRATCH(44)";
    case NVC7C0_SET_MME_SHADOW_SCRATCH(45):
        return "NVC7C0_SET_MME_SHADOW_SCRATCH(45)";
    case NVC7C0_SET_MME_SHADOW_SCRATCH(46):
        return "NVC7C0_SET_MME_SHADOW_SCRATCH(46)";
    case NVC7C0_SET_MME_SHADOW_SCRATCH(47):
        return "NVC7C0_SET_MME_SHADOW_SCRATCH(47)";
    case NVC7C0_SET_MME_SHADOW_SCRATCH(48):
        return "NVC7C0_SET_MME_SHADOW_SCRATCH(48)";
    case NVC7C0_SET_MME_SHADOW_SCRATCH(49):
        return "NVC7C0_SET_MME_SHADOW_SCRATCH(49)";
    case NVC7C0_SET_MME_SHADOW_SCRATCH(50):
        return "NVC7C0_SET_MME_SHADOW_SCRATCH(50)";
    case NVC7C0_SET_MME_SHADOW_SCRATCH(51):
        return "NVC7C0_SET_MME_SHADOW_SCRATCH(51)";
    case NVC7C0_SET_MME_SHADOW_SCRATCH(52):
        return "NVC7C0_SET_MME_SHADOW_SCRATCH(52)";
    case NVC7C0_SET_MME_SHADOW_SCRATCH(53):
        return "NVC7C0_SET_MME_SHADOW_SCRATCH(53)";
    case NVC7C0_SET_MME_SHADOW_SCRATCH(54):
        return "NVC7C0_SET_MME_SHADOW_SCRATCH(54)";
    case NVC7C0_SET_MME_SHADOW_SCRATCH(55):
        return "NVC7C0_SET_MME_SHADOW_SCRATCH(55)";
    case NVC7C0_SET_MME_SHADOW_SCRATCH(56):
        return "NVC7C0_SET_MME_SHADOW_SCRATCH(56)";
    case NVC7C0_SET_MME_SHADOW_SCRATCH(57):
        return "NVC7C0_SET_MME_SHADOW_SCRATCH(57)";
    case NVC7C0_SET_MME_SHADOW_SCRATCH(58):
        return "NVC7C0_SET_MME_SHADOW_SCRATCH(58)";
    case NVC7C0_SET_MME_SHADOW_SCRATCH(59):
        return "NVC7C0_SET_MME_SHADOW_SCRATCH(59)";
    case NVC7C0_SET_MME_SHADOW_SCRATCH(60):
        return "NVC7C0_SET_MME_SHADOW_SCRATCH(60)";
    case NVC7C0_SET_MME_SHADOW_SCRATCH(61):
        return "NVC7C0_SET_MME_SHADOW_SCRATCH(61)";
    case NVC7C0_SET_MME_SHADOW_SCRATCH(62):
        return "NVC7C0_SET_MME_SHADOW_SCRATCH(62)";
    case NVC7C0_SET_MME_SHADOW_SCRATCH(63):
        return "NVC7C0_SET_MME_SHADOW_SCRATCH(63)";
    case NVC7C0_SET_MME_SHADOW_SCRATCH(64):
        return "NVC7C0_SET_MME_SHADOW_SCRATCH(64)";
    case NVC7C0_SET_MME_SHADOW_SCRATCH(65):
        return "NVC7C0_SET_MME_SHADOW_SCRATCH(65)";
    case NVC7C0_SET_MME_SHADOW_SCRATCH(66):
        return "NVC7C0_SET_MME_SHADOW_SCRATCH(66)";
    case NVC7C0_SET_MME_SHADOW_SCRATCH(67):
        return "NVC7C0_SET_MME_SHADOW_SCRATCH(67)";
    case NVC7C0_SET_MME_SHADOW_SCRATCH(68):
        return "NVC7C0_SET_MME_SHADOW_SCRATCH(68)";
    case NVC7C0_SET_MME_SHADOW_SCRATCH(69):
        return "NVC7C0_SET_MME_SHADOW_SCRATCH(69)";
    case NVC7C0_SET_MME_SHADOW_SCRATCH(70):
        return "NVC7C0_SET_MME_SHADOW_SCRATCH(70)";
    case NVC7C0_SET_MME_SHADOW_SCRATCH(71):
        return "NVC7C0_SET_MME_SHADOW_SCRATCH(71)";
    case NVC7C0_SET_MME_SHADOW_SCRATCH(72):
        return "NVC7C0_SET_MME_SHADOW_SCRATCH(72)";
    case NVC7C0_SET_MME_SHADOW_SCRATCH(73):
        return "NVC7C0_SET_MME_SHADOW_SCRATCH(73)";
    case NVC7C0_SET_MME_SHADOW_SCRATCH(74):
        return "NVC7C0_SET_MME_SHADOW_SCRATCH(74)";
    case NVC7C0_SET_MME_SHADOW_SCRATCH(75):
        return "NVC7C0_SET_MME_SHADOW_SCRATCH(75)";
    case NVC7C0_SET_MME_SHADOW_SCRATCH(76):
        return "NVC7C0_SET_MME_SHADOW_SCRATCH(76)";
    case NVC7C0_SET_MME_SHADOW_SCRATCH(77):
        return "NVC7C0_SET_MME_SHADOW_SCRATCH(77)";
    case NVC7C0_SET_MME_SHADOW_SCRATCH(78):
        return "NVC7C0_SET_MME_SHADOW_SCRATCH(78)";
    case NVC7C0_SET_MME_SHADOW_SCRATCH(79):
        return "NVC7C0_SET_MME_SHADOW_SCRATCH(79)";
    case NVC7C0_SET_MME_SHADOW_SCRATCH(80):
        return "NVC7C0_SET_MME_SHADOW_SCRATCH(80)";
    case NVC7C0_SET_MME_SHADOW_SCRATCH(81):
        return "NVC7C0_SET_MME_SHADOW_SCRATCH(81)";
    case NVC7C0_SET_MME_SHADOW_SCRATCH(82):
        return "NVC7C0_SET_MME_SHADOW_SCRATCH(82)";
    case NVC7C0_SET_MME_SHADOW_SCRATCH(83):
        return "NVC7C0_SET_MME_SHADOW_SCRATCH(83)";
    case NVC7C0_SET_MME_SHADOW_SCRATCH(84):
        return "NVC7C0_SET_MME_SHADOW_SCRATCH(84)";
    case NVC7C0_SET_MME_SHADOW_SCRATCH(85):
        return "NVC7C0_SET_MME_SHADOW_SCRATCH(85)";
    case NVC7C0_SET_MME_SHADOW_SCRATCH(86):
        return "NVC7C0_SET_MME_SHADOW_SCRATCH(86)";
    case NVC7C0_SET_MME_SHADOW_SCRATCH(87):
        return "NVC7C0_SET_MME_SHADOW_SCRATCH(87)";
    case NVC7C0_SET_MME_SHADOW_SCRATCH(88):
        return "NVC7C0_SET_MME_SHADOW_SCRATCH(88)";
    case NVC7C0_SET_MME_SHADOW_SCRATCH(89):
        return "NVC7C0_SET_MME_SHADOW_SCRATCH(89)";
    case NVC7C0_SET_MME_SHADOW_SCRATCH(90):
        return "NVC7C0_SET_MME_SHADOW_SCRATCH(90)";
    case NVC7C0_SET_MME_SHADOW_SCRATCH(91):
        return "NVC7C0_SET_MME_SHADOW_SCRATCH(91)";
    case NVC7C0_SET_MME_SHADOW_SCRATCH(92):
        return "NVC7C0_SET_MME_SHADOW_SCRATCH(92)";
    case NVC7C0_SET_MME_SHADOW_SCRATCH(93):
        return "NVC7C0_SET_MME_SHADOW_SCRATCH(93)";
    case NVC7C0_SET_MME_SHADOW_SCRATCH(94):
        return "NVC7C0_SET_MME_SHADOW_SCRATCH(94)";
    case NVC7C0_SET_MME_SHADOW_SCRATCH(95):
        return "NVC7C0_SET_MME_SHADOW_SCRATCH(95)";
    case NVC7C0_SET_MME_SHADOW_SCRATCH(96):
        return "NVC7C0_SET_MME_SHADOW_SCRATCH(96)";
    case NVC7C0_SET_MME_SHADOW_SCRATCH(97):
        return "NVC7C0_SET_MME_SHADOW_SCRATCH(97)";
    case NVC7C0_SET_MME_SHADOW_SCRATCH(98):
        return "NVC7C0_SET_MME_SHADOW_SCRATCH(98)";
    case NVC7C0_SET_MME_SHADOW_SCRATCH(99):
        return "NVC7C0_SET_MME_SHADOW_SCRATCH(99)";
    case NVC7C0_SET_MME_SHADOW_SCRATCH(100):
        return "NVC7C0_SET_MME_SHADOW_SCRATCH(100)";
    case NVC7C0_SET_MME_SHADOW_SCRATCH(101):
        return "NVC7C0_SET_MME_SHADOW_SCRATCH(101)";
    case NVC7C0_SET_MME_SHADOW_SCRATCH(102):
        return "NVC7C0_SET_MME_SHADOW_SCRATCH(102)";
    case NVC7C0_SET_MME_SHADOW_SCRATCH(103):
        return "NVC7C0_SET_MME_SHADOW_SCRATCH(103)";
    case NVC7C0_SET_MME_SHADOW_SCRATCH(104):
        return "NVC7C0_SET_MME_SHADOW_SCRATCH(104)";
    case NVC7C0_SET_MME_SHADOW_SCRATCH(105):
        return "NVC7C0_SET_MME_SHADOW_SCRATCH(105)";
    case NVC7C0_SET_MME_SHADOW_SCRATCH(106):
        return "NVC7C0_SET_MME_SHADOW_SCRATCH(106)";
    case NVC7C0_SET_MME_SHADOW_SCRATCH(107):
        return "NVC7C0_SET_MME_SHADOW_SCRATCH(107)";
    case NVC7C0_SET_MME_SHADOW_SCRATCH(108):
        return "NVC7C0_SET_MME_SHADOW_SCRATCH(108)";
    case NVC7C0_SET_MME_SHADOW_SCRATCH(109):
        return "NVC7C0_SET_MME_SHADOW_SCRATCH(109)";
    case NVC7C0_SET_MME_SHADOW_SCRATCH(110):
        return "NVC7C0_SET_MME_SHADOW_SCRATCH(110)";
    case NVC7C0_SET_MME_SHADOW_SCRATCH(111):
        return "NVC7C0_SET_MME_SHADOW_SCRATCH(111)";
    case NVC7C0_SET_MME_SHADOW_SCRATCH(112):
        return "NVC7C0_SET_MME_SHADOW_SCRATCH(112)";
    case NVC7C0_SET_MME_SHADOW_SCRATCH(113):
        return "NVC7C0_SET_MME_SHADOW_SCRATCH(113)";
    case NVC7C0_SET_MME_SHADOW_SCRATCH(114):
        return "NVC7C0_SET_MME_SHADOW_SCRATCH(114)";
    case NVC7C0_SET_MME_SHADOW_SCRATCH(115):
        return "NVC7C0_SET_MME_SHADOW_SCRATCH(115)";
    case NVC7C0_SET_MME_SHADOW_SCRATCH(116):
        return "NVC7C0_SET_MME_SHADOW_SCRATCH(116)";
    case NVC7C0_SET_MME_SHADOW_SCRATCH(117):
        return "NVC7C0_SET_MME_SHADOW_SCRATCH(117)";
    case NVC7C0_SET_MME_SHADOW_SCRATCH(118):
        return "NVC7C0_SET_MME_SHADOW_SCRATCH(118)";
    case NVC7C0_SET_MME_SHADOW_SCRATCH(119):
        return "NVC7C0_SET_MME_SHADOW_SCRATCH(119)";
    case NVC7C0_SET_MME_SHADOW_SCRATCH(120):
        return "NVC7C0_SET_MME_SHADOW_SCRATCH(120)";
    case NVC7C0_SET_MME_SHADOW_SCRATCH(121):
        return "NVC7C0_SET_MME_SHADOW_SCRATCH(121)";
    case NVC7C0_SET_MME_SHADOW_SCRATCH(122):
        return "NVC7C0_SET_MME_SHADOW_SCRATCH(122)";
    case NVC7C0_SET_MME_SHADOW_SCRATCH(123):
        return "NVC7C0_SET_MME_SHADOW_SCRATCH(123)";
    case NVC7C0_SET_MME_SHADOW_SCRATCH(124):
        return "NVC7C0_SET_MME_SHADOW_SCRATCH(124)";
    case NVC7C0_SET_MME_SHADOW_SCRATCH(125):
        return "NVC7C0_SET_MME_SHADOW_SCRATCH(125)";
    case NVC7C0_SET_MME_SHADOW_SCRATCH(126):
        return "NVC7C0_SET_MME_SHADOW_SCRATCH(126)";
    case NVC7C0_SET_MME_SHADOW_SCRATCH(127):
        return "NVC7C0_SET_MME_SHADOW_SCRATCH(127)";
    case NVC7C0_SET_MME_SHADOW_SCRATCH(128):
        return "NVC7C0_SET_MME_SHADOW_SCRATCH(128)";
    case NVC7C0_SET_MME_SHADOW_SCRATCH(129):
        return "NVC7C0_SET_MME_SHADOW_SCRATCH(129)";
    case NVC7C0_SET_MME_SHADOW_SCRATCH(130):
        return "NVC7C0_SET_MME_SHADOW_SCRATCH(130)";
    case NVC7C0_SET_MME_SHADOW_SCRATCH(131):
        return "NVC7C0_SET_MME_SHADOW_SCRATCH(131)";
    case NVC7C0_SET_MME_SHADOW_SCRATCH(132):
        return "NVC7C0_SET_MME_SHADOW_SCRATCH(132)";
    case NVC7C0_SET_MME_SHADOW_SCRATCH(133):
        return "NVC7C0_SET_MME_SHADOW_SCRATCH(133)";
    case NVC7C0_SET_MME_SHADOW_SCRATCH(134):
        return "NVC7C0_SET_MME_SHADOW_SCRATCH(134)";
    case NVC7C0_SET_MME_SHADOW_SCRATCH(135):
        return "NVC7C0_SET_MME_SHADOW_SCRATCH(135)";
    case NVC7C0_SET_MME_SHADOW_SCRATCH(136):
        return "NVC7C0_SET_MME_SHADOW_SCRATCH(136)";
    case NVC7C0_SET_MME_SHADOW_SCRATCH(137):
        return "NVC7C0_SET_MME_SHADOW_SCRATCH(137)";
    case NVC7C0_SET_MME_SHADOW_SCRATCH(138):
        return "NVC7C0_SET_MME_SHADOW_SCRATCH(138)";
    case NVC7C0_SET_MME_SHADOW_SCRATCH(139):
        return "NVC7C0_SET_MME_SHADOW_SCRATCH(139)";
    case NVC7C0_SET_MME_SHADOW_SCRATCH(140):
        return "NVC7C0_SET_MME_SHADOW_SCRATCH(140)";
    case NVC7C0_SET_MME_SHADOW_SCRATCH(141):
        return "NVC7C0_SET_MME_SHADOW_SCRATCH(141)";
    case NVC7C0_SET_MME_SHADOW_SCRATCH(142):
        return "NVC7C0_SET_MME_SHADOW_SCRATCH(142)";
    case NVC7C0_SET_MME_SHADOW_SCRATCH(143):
        return "NVC7C0_SET_MME_SHADOW_SCRATCH(143)";
    case NVC7C0_SET_MME_SHADOW_SCRATCH(144):
        return "NVC7C0_SET_MME_SHADOW_SCRATCH(144)";
    case NVC7C0_SET_MME_SHADOW_SCRATCH(145):
        return "NVC7C0_SET_MME_SHADOW_SCRATCH(145)";
    case NVC7C0_SET_MME_SHADOW_SCRATCH(146):
        return "NVC7C0_SET_MME_SHADOW_SCRATCH(146)";
    case NVC7C0_SET_MME_SHADOW_SCRATCH(147):
        return "NVC7C0_SET_MME_SHADOW_SCRATCH(147)";
    case NVC7C0_SET_MME_SHADOW_SCRATCH(148):
        return "NVC7C0_SET_MME_SHADOW_SCRATCH(148)";
    case NVC7C0_SET_MME_SHADOW_SCRATCH(149):
        return "NVC7C0_SET_MME_SHADOW_SCRATCH(149)";
    case NVC7C0_SET_MME_SHADOW_SCRATCH(150):
        return "NVC7C0_SET_MME_SHADOW_SCRATCH(150)";
    case NVC7C0_SET_MME_SHADOW_SCRATCH(151):
        return "NVC7C0_SET_MME_SHADOW_SCRATCH(151)";
    case NVC7C0_SET_MME_SHADOW_SCRATCH(152):
        return "NVC7C0_SET_MME_SHADOW_SCRATCH(152)";
    case NVC7C0_SET_MME_SHADOW_SCRATCH(153):
        return "NVC7C0_SET_MME_SHADOW_SCRATCH(153)";
    case NVC7C0_SET_MME_SHADOW_SCRATCH(154):
        return "NVC7C0_SET_MME_SHADOW_SCRATCH(154)";
    case NVC7C0_SET_MME_SHADOW_SCRATCH(155):
        return "NVC7C0_SET_MME_SHADOW_SCRATCH(155)";
    case NVC7C0_SET_MME_SHADOW_SCRATCH(156):
        return "NVC7C0_SET_MME_SHADOW_SCRATCH(156)";
    case NVC7C0_SET_MME_SHADOW_SCRATCH(157):
        return "NVC7C0_SET_MME_SHADOW_SCRATCH(157)";
    case NVC7C0_SET_MME_SHADOW_SCRATCH(158):
        return "NVC7C0_SET_MME_SHADOW_SCRATCH(158)";
    case NVC7C0_SET_MME_SHADOW_SCRATCH(159):
        return "NVC7C0_SET_MME_SHADOW_SCRATCH(159)";
    case NVC7C0_SET_MME_SHADOW_SCRATCH(160):
        return "NVC7C0_SET_MME_SHADOW_SCRATCH(160)";
    case NVC7C0_SET_MME_SHADOW_SCRATCH(161):
        return "NVC7C0_SET_MME_SHADOW_SCRATCH(161)";
    case NVC7C0_SET_MME_SHADOW_SCRATCH(162):
        return "NVC7C0_SET_MME_SHADOW_SCRATCH(162)";
    case NVC7C0_SET_MME_SHADOW_SCRATCH(163):
        return "NVC7C0_SET_MME_SHADOW_SCRATCH(163)";
    case NVC7C0_SET_MME_SHADOW_SCRATCH(164):
        return "NVC7C0_SET_MME_SHADOW_SCRATCH(164)";
    case NVC7C0_SET_MME_SHADOW_SCRATCH(165):
        return "NVC7C0_SET_MME_SHADOW_SCRATCH(165)";
    case NVC7C0_SET_MME_SHADOW_SCRATCH(166):
        return "NVC7C0_SET_MME_SHADOW_SCRATCH(166)";
    case NVC7C0_SET_MME_SHADOW_SCRATCH(167):
        return "NVC7C0_SET_MME_SHADOW_SCRATCH(167)";
    case NVC7C0_SET_MME_SHADOW_SCRATCH(168):
        return "NVC7C0_SET_MME_SHADOW_SCRATCH(168)";
    case NVC7C0_SET_MME_SHADOW_SCRATCH(169):
        return "NVC7C0_SET_MME_SHADOW_SCRATCH(169)";
    case NVC7C0_SET_MME_SHADOW_SCRATCH(170):
        return "NVC7C0_SET_MME_SHADOW_SCRATCH(170)";
    case NVC7C0_SET_MME_SHADOW_SCRATCH(171):
        return "NVC7C0_SET_MME_SHADOW_SCRATCH(171)";
    case NVC7C0_SET_MME_SHADOW_SCRATCH(172):
        return "NVC7C0_SET_MME_SHADOW_SCRATCH(172)";
    case NVC7C0_SET_MME_SHADOW_SCRATCH(173):
        return "NVC7C0_SET_MME_SHADOW_SCRATCH(173)";
    case NVC7C0_SET_MME_SHADOW_SCRATCH(174):
        return "NVC7C0_SET_MME_SHADOW_SCRATCH(174)";
    case NVC7C0_SET_MME_SHADOW_SCRATCH(175):
        return "NVC7C0_SET_MME_SHADOW_SCRATCH(175)";
    case NVC7C0_SET_MME_SHADOW_SCRATCH(176):
        return "NVC7C0_SET_MME_SHADOW_SCRATCH(176)";
    case NVC7C0_SET_MME_SHADOW_SCRATCH(177):
        return "NVC7C0_SET_MME_SHADOW_SCRATCH(177)";
    case NVC7C0_SET_MME_SHADOW_SCRATCH(178):
        return "NVC7C0_SET_MME_SHADOW_SCRATCH(178)";
    case NVC7C0_SET_MME_SHADOW_SCRATCH(179):
        return "NVC7C0_SET_MME_SHADOW_SCRATCH(179)";
    case NVC7C0_SET_MME_SHADOW_SCRATCH(180):
        return "NVC7C0_SET_MME_SHADOW_SCRATCH(180)";
    case NVC7C0_SET_MME_SHADOW_SCRATCH(181):
        return "NVC7C0_SET_MME_SHADOW_SCRATCH(181)";
    case NVC7C0_SET_MME_SHADOW_SCRATCH(182):
        return "NVC7C0_SET_MME_SHADOW_SCRATCH(182)";
    case NVC7C0_SET_MME_SHADOW_SCRATCH(183):
        return "NVC7C0_SET_MME_SHADOW_SCRATCH(183)";
    case NVC7C0_SET_MME_SHADOW_SCRATCH(184):
        return "NVC7C0_SET_MME_SHADOW_SCRATCH(184)";
    case NVC7C0_SET_MME_SHADOW_SCRATCH(185):
        return "NVC7C0_SET_MME_SHADOW_SCRATCH(185)";
    case NVC7C0_SET_MME_SHADOW_SCRATCH(186):
        return "NVC7C0_SET_MME_SHADOW_SCRATCH(186)";
    case NVC7C0_SET_MME_SHADOW_SCRATCH(187):
        return "NVC7C0_SET_MME_SHADOW_SCRATCH(187)";
    case NVC7C0_SET_MME_SHADOW_SCRATCH(188):
        return "NVC7C0_SET_MME_SHADOW_SCRATCH(188)";
    case NVC7C0_SET_MME_SHADOW_SCRATCH(189):
        return "NVC7C0_SET_MME_SHADOW_SCRATCH(189)";
    case NVC7C0_SET_MME_SHADOW_SCRATCH(190):
        return "NVC7C0_SET_MME_SHADOW_SCRATCH(190)";
    case NVC7C0_SET_MME_SHADOW_SCRATCH(191):
        return "NVC7C0_SET_MME_SHADOW_SCRATCH(191)";
    case NVC7C0_SET_MME_SHADOW_SCRATCH(192):
        return "NVC7C0_SET_MME_SHADOW_SCRATCH(192)";
    case NVC7C0_SET_MME_SHADOW_SCRATCH(193):
        return "NVC7C0_SET_MME_SHADOW_SCRATCH(193)";
    case NVC7C0_SET_MME_SHADOW_SCRATCH(194):
        return "NVC7C0_SET_MME_SHADOW_SCRATCH(194)";
    case NVC7C0_SET_MME_SHADOW_SCRATCH(195):
        return "NVC7C0_SET_MME_SHADOW_SCRATCH(195)";
    case NVC7C0_SET_MME_SHADOW_SCRATCH(196):
        return "NVC7C0_SET_MME_SHADOW_SCRATCH(196)";
    case NVC7C0_SET_MME_SHADOW_SCRATCH(197):
        return "NVC7C0_SET_MME_SHADOW_SCRATCH(197)";
    case NVC7C0_SET_MME_SHADOW_SCRATCH(198):
        return "NVC7C0_SET_MME_SHADOW_SCRATCH(198)";
    case NVC7C0_SET_MME_SHADOW_SCRATCH(199):
        return "NVC7C0_SET_MME_SHADOW_SCRATCH(199)";
    case NVC7C0_SET_MME_SHADOW_SCRATCH(200):
        return "NVC7C0_SET_MME_SHADOW_SCRATCH(200)";
    case NVC7C0_SET_MME_SHADOW_SCRATCH(201):
        return "NVC7C0_SET_MME_SHADOW_SCRATCH(201)";
    case NVC7C0_SET_MME_SHADOW_SCRATCH(202):
        return "NVC7C0_SET_MME_SHADOW_SCRATCH(202)";
    case NVC7C0_SET_MME_SHADOW_SCRATCH(203):
        return "NVC7C0_SET_MME_SHADOW_SCRATCH(203)";
    case NVC7C0_SET_MME_SHADOW_SCRATCH(204):
        return "NVC7C0_SET_MME_SHADOW_SCRATCH(204)";
    case NVC7C0_SET_MME_SHADOW_SCRATCH(205):
        return "NVC7C0_SET_MME_SHADOW_SCRATCH(205)";
    case NVC7C0_SET_MME_SHADOW_SCRATCH(206):
        return "NVC7C0_SET_MME_SHADOW_SCRATCH(206)";
    case NVC7C0_SET_MME_SHADOW_SCRATCH(207):
        return "NVC7C0_SET_MME_SHADOW_SCRATCH(207)";
    case NVC7C0_SET_MME_SHADOW_SCRATCH(208):
        return "NVC7C0_SET_MME_SHADOW_SCRATCH(208)";
    case NVC7C0_SET_MME_SHADOW_SCRATCH(209):
        return "NVC7C0_SET_MME_SHADOW_SCRATCH(209)";
    case NVC7C0_SET_MME_SHADOW_SCRATCH(210):
        return "NVC7C0_SET_MME_SHADOW_SCRATCH(210)";
    case NVC7C0_SET_MME_SHADOW_SCRATCH(211):
        return "NVC7C0_SET_MME_SHADOW_SCRATCH(211)";
    case NVC7C0_SET_MME_SHADOW_SCRATCH(212):
        return "NVC7C0_SET_MME_SHADOW_SCRATCH(212)";
    case NVC7C0_SET_MME_SHADOW_SCRATCH(213):
        return "NVC7C0_SET_MME_SHADOW_SCRATCH(213)";
    case NVC7C0_SET_MME_SHADOW_SCRATCH(214):
        return "NVC7C0_SET_MME_SHADOW_SCRATCH(214)";
    case NVC7C0_SET_MME_SHADOW_SCRATCH(215):
        return "NVC7C0_SET_MME_SHADOW_SCRATCH(215)";
    case NVC7C0_SET_MME_SHADOW_SCRATCH(216):
        return "NVC7C0_SET_MME_SHADOW_SCRATCH(216)";
    case NVC7C0_SET_MME_SHADOW_SCRATCH(217):
        return "NVC7C0_SET_MME_SHADOW_SCRATCH(217)";
    case NVC7C0_SET_MME_SHADOW_SCRATCH(218):
        return "NVC7C0_SET_MME_SHADOW_SCRATCH(218)";
    case NVC7C0_SET_MME_SHADOW_SCRATCH(219):
        return "NVC7C0_SET_MME_SHADOW_SCRATCH(219)";
    case NVC7C0_SET_MME_SHADOW_SCRATCH(220):
        return "NVC7C0_SET_MME_SHADOW_SCRATCH(220)";
    case NVC7C0_SET_MME_SHADOW_SCRATCH(221):
        return "NVC7C0_SET_MME_SHADOW_SCRATCH(221)";
    case NVC7C0_SET_MME_SHADOW_SCRATCH(222):
        return "NVC7C0_SET_MME_SHADOW_SCRATCH(222)";
    case NVC7C0_SET_MME_SHADOW_SCRATCH(223):
        return "NVC7C0_SET_MME_SHADOW_SCRATCH(223)";
    case NVC7C0_SET_MME_SHADOW_SCRATCH(224):
        return "NVC7C0_SET_MME_SHADOW_SCRATCH(224)";
    case NVC7C0_SET_MME_SHADOW_SCRATCH(225):
        return "NVC7C0_SET_MME_SHADOW_SCRATCH(225)";
    case NVC7C0_SET_MME_SHADOW_SCRATCH(226):
        return "NVC7C0_SET_MME_SHADOW_SCRATCH(226)";
    case NVC7C0_SET_MME_SHADOW_SCRATCH(227):
        return "NVC7C0_SET_MME_SHADOW_SCRATCH(227)";
    case NVC7C0_SET_MME_SHADOW_SCRATCH(228):
        return "NVC7C0_SET_MME_SHADOW_SCRATCH(228)";
    case NVC7C0_SET_MME_SHADOW_SCRATCH(229):
        return "NVC7C0_SET_MME_SHADOW_SCRATCH(229)";
    case NVC7C0_SET_MME_SHADOW_SCRATCH(230):
        return "NVC7C0_SET_MME_SHADOW_SCRATCH(230)";
    case NVC7C0_SET_MME_SHADOW_SCRATCH(231):
        return "NVC7C0_SET_MME_SHADOW_SCRATCH(231)";
    case NVC7C0_SET_MME_SHADOW_SCRATCH(232):
        return "NVC7C0_SET_MME_SHADOW_SCRATCH(232)";
    case NVC7C0_SET_MME_SHADOW_SCRATCH(233):
        return "NVC7C0_SET_MME_SHADOW_SCRATCH(233)";
    case NVC7C0_SET_MME_SHADOW_SCRATCH(234):
        return "NVC7C0_SET_MME_SHADOW_SCRATCH(234)";
    case NVC7C0_SET_MME_SHADOW_SCRATCH(235):
        return "NVC7C0_SET_MME_SHADOW_SCRATCH(235)";
    case NVC7C0_SET_MME_SHADOW_SCRATCH(236):
        return "NVC7C0_SET_MME_SHADOW_SCRATCH(236)";
    case NVC7C0_SET_MME_SHADOW_SCRATCH(237):
        return "NVC7C0_SET_MME_SHADOW_SCRATCH(237)";
    case NVC7C0_SET_MME_SHADOW_SCRATCH(238):
        return "NVC7C0_SET_MME_SHADOW_SCRATCH(238)";
    case NVC7C0_SET_MME_SHADOW_SCRATCH(239):
        return "NVC7C0_SET_MME_SHADOW_SCRATCH(239)";
    case NVC7C0_SET_MME_SHADOW_SCRATCH(240):
        return "NVC7C0_SET_MME_SHADOW_SCRATCH(240)";
    case NVC7C0_SET_MME_SHADOW_SCRATCH(241):
        return "NVC7C0_SET_MME_SHADOW_SCRATCH(241)";
    case NVC7C0_SET_MME_SHADOW_SCRATCH(242):
        return "NVC7C0_SET_MME_SHADOW_SCRATCH(242)";
    case NVC7C0_SET_MME_SHADOW_SCRATCH(243):
        return "NVC7C0_SET_MME_SHADOW_SCRATCH(243)";
    case NVC7C0_SET_MME_SHADOW_SCRATCH(244):
        return "NVC7C0_SET_MME_SHADOW_SCRATCH(244)";
    case NVC7C0_SET_MME_SHADOW_SCRATCH(245):
        return "NVC7C0_SET_MME_SHADOW_SCRATCH(245)";
    case NVC7C0_SET_MME_SHADOW_SCRATCH(246):
        return "NVC7C0_SET_MME_SHADOW_SCRATCH(246)";
    case NVC7C0_SET_MME_SHADOW_SCRATCH(247):
        return "NVC7C0_SET_MME_SHADOW_SCRATCH(247)";
    case NVC7C0_SET_MME_SHADOW_SCRATCH(248):
        return "NVC7C0_SET_MME_SHADOW_SCRATCH(248)";
    case NVC7C0_SET_MME_SHADOW_SCRATCH(249):
        return "NVC7C0_SET_MME_SHADOW_SCRATCH(249)";
    case NVC7C0_SET_MME_SHADOW_SCRATCH(250):
        return "NVC7C0_SET_MME_SHADOW_SCRATCH(250)";
    case NVC7C0_SET_MME_SHADOW_SCRATCH(251):
        return "NVC7C0_SET_MME_SHADOW_SCRATCH(251)";
    case NVC7C0_SET_MME_SHADOW_SCRATCH(252):
        return "NVC7C0_SET_MME_SHADOW_SCRATCH(252)";
    case NVC7C0_SET_MME_SHADOW_SCRATCH(253):
        return "NVC7C0_SET_MME_SHADOW_SCRATCH(253)";
    case NVC7C0_SET_MME_SHADOW_SCRATCH(254):
        return "NVC7C0_SET_MME_SHADOW_SCRATCH(254)";
    case NVC7C0_SET_MME_SHADOW_SCRATCH(255):
        return "NVC7C0_SET_MME_SHADOW_SCRATCH(255)";
    case NVC7C0_CALL_MME_MACRO(0):
        return "NVC7C0_CALL_MME_MACRO(0)";
    case NVC7C0_CALL_MME_MACRO(1):
        return "NVC7C0_CALL_MME_MACRO(1)";
    case NVC7C0_CALL_MME_MACRO(2):
        return "NVC7C0_CALL_MME_MACRO(2)";
    case NVC7C0_CALL_MME_MACRO(3):
        return "NVC7C0_CALL_MME_MACRO(3)";
    case NVC7C0_CALL_MME_MACRO(4):
        return "NVC7C0_CALL_MME_MACRO(4)";
    case NVC7C0_CALL_MME_MACRO(5):
        return "NVC7C0_CALL_MME_MACRO(5)";
    case NVC7C0_CALL_MME_MACRO(6):
        return "NVC7C0_CALL_MME_MACRO(6)";
    case NVC7C0_CALL_MME_MACRO(7):
        return "NVC7C0_CALL_MME_MACRO(7)";
    case NVC7C0_CALL_MME_MACRO(8):
        return "NVC7C0_CALL_MME_MACRO(8)";
    case NVC7C0_CALL_MME_MACRO(9):
        return "NVC7C0_CALL_MME_MACRO(9)";
    case NVC7C0_CALL_MME_MACRO(10):
        return "NVC7C0_CALL_MME_MACRO(10)";
    case NVC7C0_CALL_MME_MACRO(11):
        return "NVC7C0_CALL_MME_MACRO(11)";
    case NVC7C0_CALL_MME_MACRO(12):
        return "NVC7C0_CALL_MME_MACRO(12)";
    case NVC7C0_CALL_MME_MACRO(13):
        return "NVC7C0_CALL_MME_MACRO(13)";
    case NVC7C0_CALL_MME_MACRO(14):
        return "NVC7C0_CALL_MME_MACRO(14)";
    case NVC7C0_CALL_MME_MACRO(15):
        return "NVC7C0_CALL_MME_MACRO(15)";
    case NVC7C0_CALL_MME_MACRO(16):
        return "NVC7C0_CALL_MME_MACRO(16)";
    case NVC7C0_CALL_MME_MACRO(17):
        return "NVC7C0_CALL_MME_MACRO(17)";
    case NVC7C0_CALL_MME_MACRO(18):
        return "NVC7C0_CALL_MME_MACRO(18)";
    case NVC7C0_CALL_MME_MACRO(19):
        return "NVC7C0_CALL_MME_MACRO(19)";
    case NVC7C0_CALL_MME_MACRO(20):
        return "NVC7C0_CALL_MME_MACRO(20)";
    case NVC7C0_CALL_MME_MACRO(21):
        return "NVC7C0_CALL_MME_MACRO(21)";
    case NVC7C0_CALL_MME_MACRO(22):
        return "NVC7C0_CALL_MME_MACRO(22)";
    case NVC7C0_CALL_MME_MACRO(23):
        return "NVC7C0_CALL_MME_MACRO(23)";
    case NVC7C0_CALL_MME_MACRO(24):
        return "NVC7C0_CALL_MME_MACRO(24)";
    case NVC7C0_CALL_MME_MACRO(25):
        return "NVC7C0_CALL_MME_MACRO(25)";
    case NVC7C0_CALL_MME_MACRO(26):
        return "NVC7C0_CALL_MME_MACRO(26)";
    case NVC7C0_CALL_MME_MACRO(27):
        return "NVC7C0_CALL_MME_MACRO(27)";
    case NVC7C0_CALL_MME_MACRO(28):
        return "NVC7C0_CALL_MME_MACRO(28)";
    case NVC7C0_CALL_MME_MACRO(29):
        return "NVC7C0_CALL_MME_MACRO(29)";
    case NVC7C0_CALL_MME_MACRO(30):
        return "NVC7C0_CALL_MME_MACRO(30)";
    case NVC7C0_CALL_MME_MACRO(31):
        return "NVC7C0_CALL_MME_MACRO(31)";
    case NVC7C0_CALL_MME_MACRO(32):
        return "NVC7C0_CALL_MME_MACRO(32)";
    case NVC7C0_CALL_MME_MACRO(33):
        return "NVC7C0_CALL_MME_MACRO(33)";
    case NVC7C0_CALL_MME_MACRO(34):
        return "NVC7C0_CALL_MME_MACRO(34)";
    case NVC7C0_CALL_MME_MACRO(35):
        return "NVC7C0_CALL_MME_MACRO(35)";
    case NVC7C0_CALL_MME_MACRO(36):
        return "NVC7C0_CALL_MME_MACRO(36)";
    case NVC7C0_CALL_MME_MACRO(37):
        return "NVC7C0_CALL_MME_MACRO(37)";
    case NVC7C0_CALL_MME_MACRO(38):
        return "NVC7C0_CALL_MME_MACRO(38)";
    case NVC7C0_CALL_MME_MACRO(39):
        return "NVC7C0_CALL_MME_MACRO(39)";
    case NVC7C0_CALL_MME_MACRO(40):
        return "NVC7C0_CALL_MME_MACRO(40)";
    case NVC7C0_CALL_MME_MACRO(41):
        return "NVC7C0_CALL_MME_MACRO(41)";
    case NVC7C0_CALL_MME_MACRO(42):
        return "NVC7C0_CALL_MME_MACRO(42)";
    case NVC7C0_CALL_MME_MACRO(43):
        return "NVC7C0_CALL_MME_MACRO(43)";
    case NVC7C0_CALL_MME_MACRO(44):
        return "NVC7C0_CALL_MME_MACRO(44)";
    case NVC7C0_CALL_MME_MACRO(45):
        return "NVC7C0_CALL_MME_MACRO(45)";
    case NVC7C0_CALL_MME_MACRO(46):
        return "NVC7C0_CALL_MME_MACRO(46)";
    case NVC7C0_CALL_MME_MACRO(47):
        return "NVC7C0_CALL_MME_MACRO(47)";
    case NVC7C0_CALL_MME_MACRO(48):
        return "NVC7C0_CALL_MME_MACRO(48)";
    case NVC7C0_CALL_MME_MACRO(49):
        return "NVC7C0_CALL_MME_MACRO(49)";
    case NVC7C0_CALL_MME_MACRO(50):
        return "NVC7C0_CALL_MME_MACRO(50)";
    case NVC7C0_CALL_MME_MACRO(51):
        return "NVC7C0_CALL_MME_MACRO(51)";
    case NVC7C0_CALL_MME_MACRO(52):
        return "NVC7C0_CALL_MME_MACRO(52)";
    case NVC7C0_CALL_MME_MACRO(53):
        return "NVC7C0_CALL_MME_MACRO(53)";
    case NVC7C0_CALL_MME_MACRO(54):
        return "NVC7C0_CALL_MME_MACRO(54)";
    case NVC7C0_CALL_MME_MACRO(55):
        return "NVC7C0_CALL_MME_MACRO(55)";
    case NVC7C0_CALL_MME_MACRO(56):
        return "NVC7C0_CALL_MME_MACRO(56)";
    case NVC7C0_CALL_MME_MACRO(57):
        return "NVC7C0_CALL_MME_MACRO(57)";
    case NVC7C0_CALL_MME_MACRO(58):
        return "NVC7C0_CALL_MME_MACRO(58)";
    case NVC7C0_CALL_MME_MACRO(59):
        return "NVC7C0_CALL_MME_MACRO(59)";
    case NVC7C0_CALL_MME_MACRO(60):
        return "NVC7C0_CALL_MME_MACRO(60)";
    case NVC7C0_CALL_MME_MACRO(61):
        return "NVC7C0_CALL_MME_MACRO(61)";
    case NVC7C0_CALL_MME_MACRO(62):
        return "NVC7C0_CALL_MME_MACRO(62)";
    case NVC7C0_CALL_MME_MACRO(63):
        return "NVC7C0_CALL_MME_MACRO(63)";
    case NVC7C0_CALL_MME_MACRO(64):
        return "NVC7C0_CALL_MME_MACRO(64)";
    case NVC7C0_CALL_MME_MACRO(65):
        return "NVC7C0_CALL_MME_MACRO(65)";
    case NVC7C0_CALL_MME_MACRO(66):
        return "NVC7C0_CALL_MME_MACRO(66)";
    case NVC7C0_CALL_MME_MACRO(67):
        return "NVC7C0_CALL_MME_MACRO(67)";
    case NVC7C0_CALL_MME_MACRO(68):
        return "NVC7C0_CALL_MME_MACRO(68)";
    case NVC7C0_CALL_MME_MACRO(69):
        return "NVC7C0_CALL_MME_MACRO(69)";
    case NVC7C0_CALL_MME_MACRO(70):
        return "NVC7C0_CALL_MME_MACRO(70)";
    case NVC7C0_CALL_MME_MACRO(71):
        return "NVC7C0_CALL_MME_MACRO(71)";
    case NVC7C0_CALL_MME_MACRO(72):
        return "NVC7C0_CALL_MME_MACRO(72)";
    case NVC7C0_CALL_MME_MACRO(73):
        return "NVC7C0_CALL_MME_MACRO(73)";
    case NVC7C0_CALL_MME_MACRO(74):
        return "NVC7C0_CALL_MME_MACRO(74)";
    case NVC7C0_CALL_MME_MACRO(75):
        return "NVC7C0_CALL_MME_MACRO(75)";
    case NVC7C0_CALL_MME_MACRO(76):
        return "NVC7C0_CALL_MME_MACRO(76)";
    case NVC7C0_CALL_MME_MACRO(77):
        return "NVC7C0_CALL_MME_MACRO(77)";
    case NVC7C0_CALL_MME_MACRO(78):
        return "NVC7C0_CALL_MME_MACRO(78)";
    case NVC7C0_CALL_MME_MACRO(79):
        return "NVC7C0_CALL_MME_MACRO(79)";
    case NVC7C0_CALL_MME_MACRO(80):
        return "NVC7C0_CALL_MME_MACRO(80)";
    case NVC7C0_CALL_MME_MACRO(81):
        return "NVC7C0_CALL_MME_MACRO(81)";
    case NVC7C0_CALL_MME_MACRO(82):
        return "NVC7C0_CALL_MME_MACRO(82)";
    case NVC7C0_CALL_MME_MACRO(83):
        return "NVC7C0_CALL_MME_MACRO(83)";
    case NVC7C0_CALL_MME_MACRO(84):
        return "NVC7C0_CALL_MME_MACRO(84)";
    case NVC7C0_CALL_MME_MACRO(85):
        return "NVC7C0_CALL_MME_MACRO(85)";
    case NVC7C0_CALL_MME_MACRO(86):
        return "NVC7C0_CALL_MME_MACRO(86)";
    case NVC7C0_CALL_MME_MACRO(87):
        return "NVC7C0_CALL_MME_MACRO(87)";
    case NVC7C0_CALL_MME_MACRO(88):
        return "NVC7C0_CALL_MME_MACRO(88)";
    case NVC7C0_CALL_MME_MACRO(89):
        return "NVC7C0_CALL_MME_MACRO(89)";
    case NVC7C0_CALL_MME_MACRO(90):
        return "NVC7C0_CALL_MME_MACRO(90)";
    case NVC7C0_CALL_MME_MACRO(91):
        return "NVC7C0_CALL_MME_MACRO(91)";
    case NVC7C0_CALL_MME_MACRO(92):
        return "NVC7C0_CALL_MME_MACRO(92)";
    case NVC7C0_CALL_MME_MACRO(93):
        return "NVC7C0_CALL_MME_MACRO(93)";
    case NVC7C0_CALL_MME_MACRO(94):
        return "NVC7C0_CALL_MME_MACRO(94)";
    case NVC7C0_CALL_MME_MACRO(95):
        return "NVC7C0_CALL_MME_MACRO(95)";
    case NVC7C0_CALL_MME_MACRO(96):
        return "NVC7C0_CALL_MME_MACRO(96)";
    case NVC7C0_CALL_MME_MACRO(97):
        return "NVC7C0_CALL_MME_MACRO(97)";
    case NVC7C0_CALL_MME_MACRO(98):
        return "NVC7C0_CALL_MME_MACRO(98)";
    case NVC7C0_CALL_MME_MACRO(99):
        return "NVC7C0_CALL_MME_MACRO(99)";
    case NVC7C0_CALL_MME_MACRO(100):
        return "NVC7C0_CALL_MME_MACRO(100)";
    case NVC7C0_CALL_MME_MACRO(101):
        return "NVC7C0_CALL_MME_MACRO(101)";
    case NVC7C0_CALL_MME_MACRO(102):
        return "NVC7C0_CALL_MME_MACRO(102)";
    case NVC7C0_CALL_MME_MACRO(103):
        return "NVC7C0_CALL_MME_MACRO(103)";
    case NVC7C0_CALL_MME_MACRO(104):
        return "NVC7C0_CALL_MME_MACRO(104)";
    case NVC7C0_CALL_MME_MACRO(105):
        return "NVC7C0_CALL_MME_MACRO(105)";
    case NVC7C0_CALL_MME_MACRO(106):
        return "NVC7C0_CALL_MME_MACRO(106)";
    case NVC7C0_CALL_MME_MACRO(107):
        return "NVC7C0_CALL_MME_MACRO(107)";
    case NVC7C0_CALL_MME_MACRO(108):
        return "NVC7C0_CALL_MME_MACRO(108)";
    case NVC7C0_CALL_MME_MACRO(109):
        return "NVC7C0_CALL_MME_MACRO(109)";
    case NVC7C0_CALL_MME_MACRO(110):
        return "NVC7C0_CALL_MME_MACRO(110)";
    case NVC7C0_CALL_MME_MACRO(111):
        return "NVC7C0_CALL_MME_MACRO(111)";
    case NVC7C0_CALL_MME_MACRO(112):
        return "NVC7C0_CALL_MME_MACRO(112)";
    case NVC7C0_CALL_MME_MACRO(113):
        return "NVC7C0_CALL_MME_MACRO(113)";
    case NVC7C0_CALL_MME_MACRO(114):
        return "NVC7C0_CALL_MME_MACRO(114)";
    case NVC7C0_CALL_MME_MACRO(115):
        return "NVC7C0_CALL_MME_MACRO(115)";
    case NVC7C0_CALL_MME_MACRO(116):
        return "NVC7C0_CALL_MME_MACRO(116)";
    case NVC7C0_CALL_MME_MACRO(117):
        return "NVC7C0_CALL_MME_MACRO(117)";
    case NVC7C0_CALL_MME_MACRO(118):
        return "NVC7C0_CALL_MME_MACRO(118)";
    case NVC7C0_CALL_MME_MACRO(119):
        return "NVC7C0_CALL_MME_MACRO(119)";
    case NVC7C0_CALL_MME_MACRO(120):
        return "NVC7C0_CALL_MME_MACRO(120)";
    case NVC7C0_CALL_MME_MACRO(121):
        return "NVC7C0_CALL_MME_MACRO(121)";
    case NVC7C0_CALL_MME_MACRO(122):
        return "NVC7C0_CALL_MME_MACRO(122)";
    case NVC7C0_CALL_MME_MACRO(123):
        return "NVC7C0_CALL_MME_MACRO(123)";
    case NVC7C0_CALL_MME_MACRO(124):
        return "NVC7C0_CALL_MME_MACRO(124)";
    case NVC7C0_CALL_MME_MACRO(125):
        return "NVC7C0_CALL_MME_MACRO(125)";
    case NVC7C0_CALL_MME_MACRO(126):
        return "NVC7C0_CALL_MME_MACRO(126)";
    case NVC7C0_CALL_MME_MACRO(127):
        return "NVC7C0_CALL_MME_MACRO(127)";
    case NVC7C0_CALL_MME_MACRO(128):
        return "NVC7C0_CALL_MME_MACRO(128)";
    case NVC7C0_CALL_MME_MACRO(129):
        return "NVC7C0_CALL_MME_MACRO(129)";
    case NVC7C0_CALL_MME_MACRO(130):
        return "NVC7C0_CALL_MME_MACRO(130)";
    case NVC7C0_CALL_MME_MACRO(131):
        return "NVC7C0_CALL_MME_MACRO(131)";
    case NVC7C0_CALL_MME_MACRO(132):
        return "NVC7C0_CALL_MME_MACRO(132)";
    case NVC7C0_CALL_MME_MACRO(133):
        return "NVC7C0_CALL_MME_MACRO(133)";
    case NVC7C0_CALL_MME_MACRO(134):
        return "NVC7C0_CALL_MME_MACRO(134)";
    case NVC7C0_CALL_MME_MACRO(135):
        return "NVC7C0_CALL_MME_MACRO(135)";
    case NVC7C0_CALL_MME_MACRO(136):
        return "NVC7C0_CALL_MME_MACRO(136)";
    case NVC7C0_CALL_MME_MACRO(137):
        return "NVC7C0_CALL_MME_MACRO(137)";
    case NVC7C0_CALL_MME_MACRO(138):
        return "NVC7C0_CALL_MME_MACRO(138)";
    case NVC7C0_CALL_MME_MACRO(139):
        return "NVC7C0_CALL_MME_MACRO(139)";
    case NVC7C0_CALL_MME_MACRO(140):
        return "NVC7C0_CALL_MME_MACRO(140)";
    case NVC7C0_CALL_MME_MACRO(141):
        return "NVC7C0_CALL_MME_MACRO(141)";
    case NVC7C0_CALL_MME_MACRO(142):
        return "NVC7C0_CALL_MME_MACRO(142)";
    case NVC7C0_CALL_MME_MACRO(143):
        return "NVC7C0_CALL_MME_MACRO(143)";
    case NVC7C0_CALL_MME_MACRO(144):
        return "NVC7C0_CALL_MME_MACRO(144)";
    case NVC7C0_CALL_MME_MACRO(145):
        return "NVC7C0_CALL_MME_MACRO(145)";
    case NVC7C0_CALL_MME_MACRO(146):
        return "NVC7C0_CALL_MME_MACRO(146)";
    case NVC7C0_CALL_MME_MACRO(147):
        return "NVC7C0_CALL_MME_MACRO(147)";
    case NVC7C0_CALL_MME_MACRO(148):
        return "NVC7C0_CALL_MME_MACRO(148)";
    case NVC7C0_CALL_MME_MACRO(149):
        return "NVC7C0_CALL_MME_MACRO(149)";
    case NVC7C0_CALL_MME_MACRO(150):
        return "NVC7C0_CALL_MME_MACRO(150)";
    case NVC7C0_CALL_MME_MACRO(151):
        return "NVC7C0_CALL_MME_MACRO(151)";
    case NVC7C0_CALL_MME_MACRO(152):
        return "NVC7C0_CALL_MME_MACRO(152)";
    case NVC7C0_CALL_MME_MACRO(153):
        return "NVC7C0_CALL_MME_MACRO(153)";
    case NVC7C0_CALL_MME_MACRO(154):
        return "NVC7C0_CALL_MME_MACRO(154)";
    case NVC7C0_CALL_MME_MACRO(155):
        return "NVC7C0_CALL_MME_MACRO(155)";
    case NVC7C0_CALL_MME_MACRO(156):
        return "NVC7C0_CALL_MME_MACRO(156)";
    case NVC7C0_CALL_MME_MACRO(157):
        return "NVC7C0_CALL_MME_MACRO(157)";
    case NVC7C0_CALL_MME_MACRO(158):
        return "NVC7C0_CALL_MME_MACRO(158)";
    case NVC7C0_CALL_MME_MACRO(159):
        return "NVC7C0_CALL_MME_MACRO(159)";
    case NVC7C0_CALL_MME_MACRO(160):
        return "NVC7C0_CALL_MME_MACRO(160)";
    case NVC7C0_CALL_MME_MACRO(161):
        return "NVC7C0_CALL_MME_MACRO(161)";
    case NVC7C0_CALL_MME_MACRO(162):
        return "NVC7C0_CALL_MME_MACRO(162)";
    case NVC7C0_CALL_MME_MACRO(163):
        return "NVC7C0_CALL_MME_MACRO(163)";
    case NVC7C0_CALL_MME_MACRO(164):
        return "NVC7C0_CALL_MME_MACRO(164)";
    case NVC7C0_CALL_MME_MACRO(165):
        return "NVC7C0_CALL_MME_MACRO(165)";
    case NVC7C0_CALL_MME_MACRO(166):
        return "NVC7C0_CALL_MME_MACRO(166)";
    case NVC7C0_CALL_MME_MACRO(167):
        return "NVC7C0_CALL_MME_MACRO(167)";
    case NVC7C0_CALL_MME_MACRO(168):
        return "NVC7C0_CALL_MME_MACRO(168)";
    case NVC7C0_CALL_MME_MACRO(169):
        return "NVC7C0_CALL_MME_MACRO(169)";
    case NVC7C0_CALL_MME_MACRO(170):
        return "NVC7C0_CALL_MME_MACRO(170)";
    case NVC7C0_CALL_MME_MACRO(171):
        return "NVC7C0_CALL_MME_MACRO(171)";
    case NVC7C0_CALL_MME_MACRO(172):
        return "NVC7C0_CALL_MME_MACRO(172)";
    case NVC7C0_CALL_MME_MACRO(173):
        return "NVC7C0_CALL_MME_MACRO(173)";
    case NVC7C0_CALL_MME_MACRO(174):
        return "NVC7C0_CALL_MME_MACRO(174)";
    case NVC7C0_CALL_MME_MACRO(175):
        return "NVC7C0_CALL_MME_MACRO(175)";
    case NVC7C0_CALL_MME_MACRO(176):
        return "NVC7C0_CALL_MME_MACRO(176)";
    case NVC7C0_CALL_MME_MACRO(177):
        return "NVC7C0_CALL_MME_MACRO(177)";
    case NVC7C0_CALL_MME_MACRO(178):
        return "NVC7C0_CALL_MME_MACRO(178)";
    case NVC7C0_CALL_MME_MACRO(179):
        return "NVC7C0_CALL_MME_MACRO(179)";
    case NVC7C0_CALL_MME_MACRO(180):
        return "NVC7C0_CALL_MME_MACRO(180)";
    case NVC7C0_CALL_MME_MACRO(181):
        return "NVC7C0_CALL_MME_MACRO(181)";
    case NVC7C0_CALL_MME_MACRO(182):
        return "NVC7C0_CALL_MME_MACRO(182)";
    case NVC7C0_CALL_MME_MACRO(183):
        return "NVC7C0_CALL_MME_MACRO(183)";
    case NVC7C0_CALL_MME_MACRO(184):
        return "NVC7C0_CALL_MME_MACRO(184)";
    case NVC7C0_CALL_MME_MACRO(185):
        return "NVC7C0_CALL_MME_MACRO(185)";
    case NVC7C0_CALL_MME_MACRO(186):
        return "NVC7C0_CALL_MME_MACRO(186)";
    case NVC7C0_CALL_MME_MACRO(187):
        return "NVC7C0_CALL_MME_MACRO(187)";
    case NVC7C0_CALL_MME_MACRO(188):
        return "NVC7C0_CALL_MME_MACRO(188)";
    case NVC7C0_CALL_MME_MACRO(189):
        return "NVC7C0_CALL_MME_MACRO(189)";
    case NVC7C0_CALL_MME_MACRO(190):
        return "NVC7C0_CALL_MME_MACRO(190)";
    case NVC7C0_CALL_MME_MACRO(191):
        return "NVC7C0_CALL_MME_MACRO(191)";
    case NVC7C0_CALL_MME_MACRO(192):
        return "NVC7C0_CALL_MME_MACRO(192)";
    case NVC7C0_CALL_MME_MACRO(193):
        return "NVC7C0_CALL_MME_MACRO(193)";
    case NVC7C0_CALL_MME_MACRO(194):
        return "NVC7C0_CALL_MME_MACRO(194)";
    case NVC7C0_CALL_MME_MACRO(195):
        return "NVC7C0_CALL_MME_MACRO(195)";
    case NVC7C0_CALL_MME_MACRO(196):
        return "NVC7C0_CALL_MME_MACRO(196)";
    case NVC7C0_CALL_MME_MACRO(197):
        return "NVC7C0_CALL_MME_MACRO(197)";
    case NVC7C0_CALL_MME_MACRO(198):
        return "NVC7C0_CALL_MME_MACRO(198)";
    case NVC7C0_CALL_MME_MACRO(199):
        return "NVC7C0_CALL_MME_MACRO(199)";
    case NVC7C0_CALL_MME_MACRO(200):
        return "NVC7C0_CALL_MME_MACRO(200)";
    case NVC7C0_CALL_MME_MACRO(201):
        return "NVC7C0_CALL_MME_MACRO(201)";
    case NVC7C0_CALL_MME_MACRO(202):
        return "NVC7C0_CALL_MME_MACRO(202)";
    case NVC7C0_CALL_MME_MACRO(203):
        return "NVC7C0_CALL_MME_MACRO(203)";
    case NVC7C0_CALL_MME_MACRO(204):
        return "NVC7C0_CALL_MME_MACRO(204)";
    case NVC7C0_CALL_MME_MACRO(205):
        return "NVC7C0_CALL_MME_MACRO(205)";
    case NVC7C0_CALL_MME_MACRO(206):
        return "NVC7C0_CALL_MME_MACRO(206)";
    case NVC7C0_CALL_MME_MACRO(207):
        return "NVC7C0_CALL_MME_MACRO(207)";
    case NVC7C0_CALL_MME_MACRO(208):
        return "NVC7C0_CALL_MME_MACRO(208)";
    case NVC7C0_CALL_MME_MACRO(209):
        return "NVC7C0_CALL_MME_MACRO(209)";
    case NVC7C0_CALL_MME_MACRO(210):
        return "NVC7C0_CALL_MME_MACRO(210)";
    case NVC7C0_CALL_MME_MACRO(211):
        return "NVC7C0_CALL_MME_MACRO(211)";
    case NVC7C0_CALL_MME_MACRO(212):
        return "NVC7C0_CALL_MME_MACRO(212)";
    case NVC7C0_CALL_MME_MACRO(213):
        return "NVC7C0_CALL_MME_MACRO(213)";
    case NVC7C0_CALL_MME_MACRO(214):
        return "NVC7C0_CALL_MME_MACRO(214)";
    case NVC7C0_CALL_MME_MACRO(215):
        return "NVC7C0_CALL_MME_MACRO(215)";
    case NVC7C0_CALL_MME_MACRO(216):
        return "NVC7C0_CALL_MME_MACRO(216)";
    case NVC7C0_CALL_MME_MACRO(217):
        return "NVC7C0_CALL_MME_MACRO(217)";
    case NVC7C0_CALL_MME_MACRO(218):
        return "NVC7C0_CALL_MME_MACRO(218)";
    case NVC7C0_CALL_MME_MACRO(219):
        return "NVC7C0_CALL_MME_MACRO(219)";
    case NVC7C0_CALL_MME_MACRO(220):
        return "NVC7C0_CALL_MME_MACRO(220)";
    case NVC7C0_CALL_MME_MACRO(221):
        return "NVC7C0_CALL_MME_MACRO(221)";
    case NVC7C0_CALL_MME_MACRO(222):
        return "NVC7C0_CALL_MME_MACRO(222)";
    case NVC7C0_CALL_MME_MACRO(223):
        return "NVC7C0_CALL_MME_MACRO(223)";
    case NVC7C0_CALL_MME_MACRO(224):
        return "NVC7C0_CALL_MME_MACRO(224)";
    case NVC7C0_CALL_MME_MACRO(225):
        return "NVC7C0_CALL_MME_MACRO(225)";
    case NVC7C0_CALL_MME_MACRO(226):
        return "NVC7C0_CALL_MME_MACRO(226)";
    case NVC7C0_CALL_MME_MACRO(227):
        return "NVC7C0_CALL_MME_MACRO(227)";
    case NVC7C0_CALL_MME_MACRO(228):
        return "NVC7C0_CALL_MME_MACRO(228)";
    case NVC7C0_CALL_MME_MACRO(229):
        return "NVC7C0_CALL_MME_MACRO(229)";
    case NVC7C0_CALL_MME_MACRO(230):
        return "NVC7C0_CALL_MME_MACRO(230)";
    case NVC7C0_CALL_MME_MACRO(231):
        return "NVC7C0_CALL_MME_MACRO(231)";
    case NVC7C0_CALL_MME_MACRO(232):
        return "NVC7C0_CALL_MME_MACRO(232)";
    case NVC7C0_CALL_MME_MACRO(233):
        return "NVC7C0_CALL_MME_MACRO(233)";
    case NVC7C0_CALL_MME_MACRO(234):
        return "NVC7C0_CALL_MME_MACRO(234)";
    case NVC7C0_CALL_MME_MACRO(235):
        return "NVC7C0_CALL_MME_MACRO(235)";
    case NVC7C0_CALL_MME_MACRO(236):
        return "NVC7C0_CALL_MME_MACRO(236)";
    case NVC7C0_CALL_MME_MACRO(237):
        return "NVC7C0_CALL_MME_MACRO(237)";
    case NVC7C0_CALL_MME_MACRO(238):
        return "NVC7C0_CALL_MME_MACRO(238)";
    case NVC7C0_CALL_MME_MACRO(239):
        return "NVC7C0_CALL_MME_MACRO(239)";
    case NVC7C0_CALL_MME_MACRO(240):
        return "NVC7C0_CALL_MME_MACRO(240)";
    case NVC7C0_CALL_MME_MACRO(241):
        return "NVC7C0_CALL_MME_MACRO(241)";
    case NVC7C0_CALL_MME_MACRO(242):
        return "NVC7C0_CALL_MME_MACRO(242)";
    case NVC7C0_CALL_MME_MACRO(243):
        return "NVC7C0_CALL_MME_MACRO(243)";
    case NVC7C0_CALL_MME_MACRO(244):
        return "NVC7C0_CALL_MME_MACRO(244)";
    case NVC7C0_CALL_MME_MACRO(245):
        return "NVC7C0_CALL_MME_MACRO(245)";
    case NVC7C0_CALL_MME_MACRO(246):
        return "NVC7C0_CALL_MME_MACRO(246)";
    case NVC7C0_CALL_MME_MACRO(247):
        return "NVC7C0_CALL_MME_MACRO(247)";
    case NVC7C0_CALL_MME_MACRO(248):
        return "NVC7C0_CALL_MME_MACRO(248)";
    case NVC7C0_CALL_MME_MACRO(249):
        return "NVC7C0_CALL_MME_MACRO(249)";
    case NVC7C0_CALL_MME_MACRO(250):
        return "NVC7C0_CALL_MME_MACRO(250)";
    case NVC7C0_CALL_MME_MACRO(251):
        return "NVC7C0_CALL_MME_MACRO(251)";
    case NVC7C0_CALL_MME_MACRO(252):
        return "NVC7C0_CALL_MME_MACRO(252)";
    case NVC7C0_CALL_MME_MACRO(253):
        return "NVC7C0_CALL_MME_MACRO(253)";
    case NVC7C0_CALL_MME_MACRO(254):
        return "NVC7C0_CALL_MME_MACRO(254)";
    case NVC7C0_CALL_MME_MACRO(255):
        return "NVC7C0_CALL_MME_MACRO(255)";
    case NVC7C0_CALL_MME_DATA(0):
        return "NVC7C0_CALL_MME_DATA(0)";
    case NVC7C0_CALL_MME_DATA(1):
        return "NVC7C0_CALL_MME_DATA(1)";
    case NVC7C0_CALL_MME_DATA(2):
        return "NVC7C0_CALL_MME_DATA(2)";
    case NVC7C0_CALL_MME_DATA(3):
        return "NVC7C0_CALL_MME_DATA(3)";
    case NVC7C0_CALL_MME_DATA(4):
        return "NVC7C0_CALL_MME_DATA(4)";
    case NVC7C0_CALL_MME_DATA(5):
        return "NVC7C0_CALL_MME_DATA(5)";
    case NVC7C0_CALL_MME_DATA(6):
        return "NVC7C0_CALL_MME_DATA(6)";
    case NVC7C0_CALL_MME_DATA(7):
        return "NVC7C0_CALL_MME_DATA(7)";
    case NVC7C0_CALL_MME_DATA(8):
        return "NVC7C0_CALL_MME_DATA(8)";
    case NVC7C0_CALL_MME_DATA(9):
        return "NVC7C0_CALL_MME_DATA(9)";
    case NVC7C0_CALL_MME_DATA(10):
        return "NVC7C0_CALL_MME_DATA(10)";
    case NVC7C0_CALL_MME_DATA(11):
        return "NVC7C0_CALL_MME_DATA(11)";
    case NVC7C0_CALL_MME_DATA(12):
        return "NVC7C0_CALL_MME_DATA(12)";
    case NVC7C0_CALL_MME_DATA(13):
        return "NVC7C0_CALL_MME_DATA(13)";
    case NVC7C0_CALL_MME_DATA(14):
        return "NVC7C0_CALL_MME_DATA(14)";
    case NVC7C0_CALL_MME_DATA(15):
        return "NVC7C0_CALL_MME_DATA(15)";
    case NVC7C0_CALL_MME_DATA(16):
        return "NVC7C0_CALL_MME_DATA(16)";
    case NVC7C0_CALL_MME_DATA(17):
        return "NVC7C0_CALL_MME_DATA(17)";
    case NVC7C0_CALL_MME_DATA(18):
        return "NVC7C0_CALL_MME_DATA(18)";
    case NVC7C0_CALL_MME_DATA(19):
        return "NVC7C0_CALL_MME_DATA(19)";
    case NVC7C0_CALL_MME_DATA(20):
        return "NVC7C0_CALL_MME_DATA(20)";
    case NVC7C0_CALL_MME_DATA(21):
        return "NVC7C0_CALL_MME_DATA(21)";
    case NVC7C0_CALL_MME_DATA(22):
        return "NVC7C0_CALL_MME_DATA(22)";
    case NVC7C0_CALL_MME_DATA(23):
        return "NVC7C0_CALL_MME_DATA(23)";
    case NVC7C0_CALL_MME_DATA(24):
        return "NVC7C0_CALL_MME_DATA(24)";
    case NVC7C0_CALL_MME_DATA(25):
        return "NVC7C0_CALL_MME_DATA(25)";
    case NVC7C0_CALL_MME_DATA(26):
        return "NVC7C0_CALL_MME_DATA(26)";
    case NVC7C0_CALL_MME_DATA(27):
        return "NVC7C0_CALL_MME_DATA(27)";
    case NVC7C0_CALL_MME_DATA(28):
        return "NVC7C0_CALL_MME_DATA(28)";
    case NVC7C0_CALL_MME_DATA(29):
        return "NVC7C0_CALL_MME_DATA(29)";
    case NVC7C0_CALL_MME_DATA(30):
        return "NVC7C0_CALL_MME_DATA(30)";
    case NVC7C0_CALL_MME_DATA(31):
        return "NVC7C0_CALL_MME_DATA(31)";
    case NVC7C0_CALL_MME_DATA(32):
        return "NVC7C0_CALL_MME_DATA(32)";
    case NVC7C0_CALL_MME_DATA(33):
        return "NVC7C0_CALL_MME_DATA(33)";
    case NVC7C0_CALL_MME_DATA(34):
        return "NVC7C0_CALL_MME_DATA(34)";
    case NVC7C0_CALL_MME_DATA(35):
        return "NVC7C0_CALL_MME_DATA(35)";
    case NVC7C0_CALL_MME_DATA(36):
        return "NVC7C0_CALL_MME_DATA(36)";
    case NVC7C0_CALL_MME_DATA(37):
        return "NVC7C0_CALL_MME_DATA(37)";
    case NVC7C0_CALL_MME_DATA(38):
        return "NVC7C0_CALL_MME_DATA(38)";
    case NVC7C0_CALL_MME_DATA(39):
        return "NVC7C0_CALL_MME_DATA(39)";
    case NVC7C0_CALL_MME_DATA(40):
        return "NVC7C0_CALL_MME_DATA(40)";
    case NVC7C0_CALL_MME_DATA(41):
        return "NVC7C0_CALL_MME_DATA(41)";
    case NVC7C0_CALL_MME_DATA(42):
        return "NVC7C0_CALL_MME_DATA(42)";
    case NVC7C0_CALL_MME_DATA(43):
        return "NVC7C0_CALL_MME_DATA(43)";
    case NVC7C0_CALL_MME_DATA(44):
        return "NVC7C0_CALL_MME_DATA(44)";
    case NVC7C0_CALL_MME_DATA(45):
        return "NVC7C0_CALL_MME_DATA(45)";
    case NVC7C0_CALL_MME_DATA(46):
        return "NVC7C0_CALL_MME_DATA(46)";
    case NVC7C0_CALL_MME_DATA(47):
        return "NVC7C0_CALL_MME_DATA(47)";
    case NVC7C0_CALL_MME_DATA(48):
        return "NVC7C0_CALL_MME_DATA(48)";
    case NVC7C0_CALL_MME_DATA(49):
        return "NVC7C0_CALL_MME_DATA(49)";
    case NVC7C0_CALL_MME_DATA(50):
        return "NVC7C0_CALL_MME_DATA(50)";
    case NVC7C0_CALL_MME_DATA(51):
        return "NVC7C0_CALL_MME_DATA(51)";
    case NVC7C0_CALL_MME_DATA(52):
        return "NVC7C0_CALL_MME_DATA(52)";
    case NVC7C0_CALL_MME_DATA(53):
        return "NVC7C0_CALL_MME_DATA(53)";
    case NVC7C0_CALL_MME_DATA(54):
        return "NVC7C0_CALL_MME_DATA(54)";
    case NVC7C0_CALL_MME_DATA(55):
        return "NVC7C0_CALL_MME_DATA(55)";
    case NVC7C0_CALL_MME_DATA(56):
        return "NVC7C0_CALL_MME_DATA(56)";
    case NVC7C0_CALL_MME_DATA(57):
        return "NVC7C0_CALL_MME_DATA(57)";
    case NVC7C0_CALL_MME_DATA(58):
        return "NVC7C0_CALL_MME_DATA(58)";
    case NVC7C0_CALL_MME_DATA(59):
        return "NVC7C0_CALL_MME_DATA(59)";
    case NVC7C0_CALL_MME_DATA(60):
        return "NVC7C0_CALL_MME_DATA(60)";
    case NVC7C0_CALL_MME_DATA(61):
        return "NVC7C0_CALL_MME_DATA(61)";
    case NVC7C0_CALL_MME_DATA(62):
        return "NVC7C0_CALL_MME_DATA(62)";
    case NVC7C0_CALL_MME_DATA(63):
        return "NVC7C0_CALL_MME_DATA(63)";
    case NVC7C0_CALL_MME_DATA(64):
        return "NVC7C0_CALL_MME_DATA(64)";
    case NVC7C0_CALL_MME_DATA(65):
        return "NVC7C0_CALL_MME_DATA(65)";
    case NVC7C0_CALL_MME_DATA(66):
        return "NVC7C0_CALL_MME_DATA(66)";
    case NVC7C0_CALL_MME_DATA(67):
        return "NVC7C0_CALL_MME_DATA(67)";
    case NVC7C0_CALL_MME_DATA(68):
        return "NVC7C0_CALL_MME_DATA(68)";
    case NVC7C0_CALL_MME_DATA(69):
        return "NVC7C0_CALL_MME_DATA(69)";
    case NVC7C0_CALL_MME_DATA(70):
        return "NVC7C0_CALL_MME_DATA(70)";
    case NVC7C0_CALL_MME_DATA(71):
        return "NVC7C0_CALL_MME_DATA(71)";
    case NVC7C0_CALL_MME_DATA(72):
        return "NVC7C0_CALL_MME_DATA(72)";
    case NVC7C0_CALL_MME_DATA(73):
        return "NVC7C0_CALL_MME_DATA(73)";
    case NVC7C0_CALL_MME_DATA(74):
        return "NVC7C0_CALL_MME_DATA(74)";
    case NVC7C0_CALL_MME_DATA(75):
        return "NVC7C0_CALL_MME_DATA(75)";
    case NVC7C0_CALL_MME_DATA(76):
        return "NVC7C0_CALL_MME_DATA(76)";
    case NVC7C0_CALL_MME_DATA(77):
        return "NVC7C0_CALL_MME_DATA(77)";
    case NVC7C0_CALL_MME_DATA(78):
        return "NVC7C0_CALL_MME_DATA(78)";
    case NVC7C0_CALL_MME_DATA(79):
        return "NVC7C0_CALL_MME_DATA(79)";
    case NVC7C0_CALL_MME_DATA(80):
        return "NVC7C0_CALL_MME_DATA(80)";
    case NVC7C0_CALL_MME_DATA(81):
        return "NVC7C0_CALL_MME_DATA(81)";
    case NVC7C0_CALL_MME_DATA(82):
        return "NVC7C0_CALL_MME_DATA(82)";
    case NVC7C0_CALL_MME_DATA(83):
        return "NVC7C0_CALL_MME_DATA(83)";
    case NVC7C0_CALL_MME_DATA(84):
        return "NVC7C0_CALL_MME_DATA(84)";
    case NVC7C0_CALL_MME_DATA(85):
        return "NVC7C0_CALL_MME_DATA(85)";
    case NVC7C0_CALL_MME_DATA(86):
        return "NVC7C0_CALL_MME_DATA(86)";
    case NVC7C0_CALL_MME_DATA(87):
        return "NVC7C0_CALL_MME_DATA(87)";
    case NVC7C0_CALL_MME_DATA(88):
        return "NVC7C0_CALL_MME_DATA(88)";
    case NVC7C0_CALL_MME_DATA(89):
        return "NVC7C0_CALL_MME_DATA(89)";
    case NVC7C0_CALL_MME_DATA(90):
        return "NVC7C0_CALL_MME_DATA(90)";
    case NVC7C0_CALL_MME_DATA(91):
        return "NVC7C0_CALL_MME_DATA(91)";
    case NVC7C0_CALL_MME_DATA(92):
        return "NVC7C0_CALL_MME_DATA(92)";
    case NVC7C0_CALL_MME_DATA(93):
        return "NVC7C0_CALL_MME_DATA(93)";
    case NVC7C0_CALL_MME_DATA(94):
        return "NVC7C0_CALL_MME_DATA(94)";
    case NVC7C0_CALL_MME_DATA(95):
        return "NVC7C0_CALL_MME_DATA(95)";
    case NVC7C0_CALL_MME_DATA(96):
        return "NVC7C0_CALL_MME_DATA(96)";
    case NVC7C0_CALL_MME_DATA(97):
        return "NVC7C0_CALL_MME_DATA(97)";
    case NVC7C0_CALL_MME_DATA(98):
        return "NVC7C0_CALL_MME_DATA(98)";
    case NVC7C0_CALL_MME_DATA(99):
        return "NVC7C0_CALL_MME_DATA(99)";
    case NVC7C0_CALL_MME_DATA(100):
        return "NVC7C0_CALL_MME_DATA(100)";
    case NVC7C0_CALL_MME_DATA(101):
        return "NVC7C0_CALL_MME_DATA(101)";
    case NVC7C0_CALL_MME_DATA(102):
        return "NVC7C0_CALL_MME_DATA(102)";
    case NVC7C0_CALL_MME_DATA(103):
        return "NVC7C0_CALL_MME_DATA(103)";
    case NVC7C0_CALL_MME_DATA(104):
        return "NVC7C0_CALL_MME_DATA(104)";
    case NVC7C0_CALL_MME_DATA(105):
        return "NVC7C0_CALL_MME_DATA(105)";
    case NVC7C0_CALL_MME_DATA(106):
        return "NVC7C0_CALL_MME_DATA(106)";
    case NVC7C0_CALL_MME_DATA(107):
        return "NVC7C0_CALL_MME_DATA(107)";
    case NVC7C0_CALL_MME_DATA(108):
        return "NVC7C0_CALL_MME_DATA(108)";
    case NVC7C0_CALL_MME_DATA(109):
        return "NVC7C0_CALL_MME_DATA(109)";
    case NVC7C0_CALL_MME_DATA(110):
        return "NVC7C0_CALL_MME_DATA(110)";
    case NVC7C0_CALL_MME_DATA(111):
        return "NVC7C0_CALL_MME_DATA(111)";
    case NVC7C0_CALL_MME_DATA(112):
        return "NVC7C0_CALL_MME_DATA(112)";
    case NVC7C0_CALL_MME_DATA(113):
        return "NVC7C0_CALL_MME_DATA(113)";
    case NVC7C0_CALL_MME_DATA(114):
        return "NVC7C0_CALL_MME_DATA(114)";
    case NVC7C0_CALL_MME_DATA(115):
        return "NVC7C0_CALL_MME_DATA(115)";
    case NVC7C0_CALL_MME_DATA(116):
        return "NVC7C0_CALL_MME_DATA(116)";
    case NVC7C0_CALL_MME_DATA(117):
        return "NVC7C0_CALL_MME_DATA(117)";
    case NVC7C0_CALL_MME_DATA(118):
        return "NVC7C0_CALL_MME_DATA(118)";
    case NVC7C0_CALL_MME_DATA(119):
        return "NVC7C0_CALL_MME_DATA(119)";
    case NVC7C0_CALL_MME_DATA(120):
        return "NVC7C0_CALL_MME_DATA(120)";
    case NVC7C0_CALL_MME_DATA(121):
        return "NVC7C0_CALL_MME_DATA(121)";
    case NVC7C0_CALL_MME_DATA(122):
        return "NVC7C0_CALL_MME_DATA(122)";
    case NVC7C0_CALL_MME_DATA(123):
        return "NVC7C0_CALL_MME_DATA(123)";
    case NVC7C0_CALL_MME_DATA(124):
        return "NVC7C0_CALL_MME_DATA(124)";
    case NVC7C0_CALL_MME_DATA(125):
        return "NVC7C0_CALL_MME_DATA(125)";
    case NVC7C0_CALL_MME_DATA(126):
        return "NVC7C0_CALL_MME_DATA(126)";
    case NVC7C0_CALL_MME_DATA(127):
        return "NVC7C0_CALL_MME_DATA(127)";
    case NVC7C0_CALL_MME_DATA(128):
        return "NVC7C0_CALL_MME_DATA(128)";
    case NVC7C0_CALL_MME_DATA(129):
        return "NVC7C0_CALL_MME_DATA(129)";
    case NVC7C0_CALL_MME_DATA(130):
        return "NVC7C0_CALL_MME_DATA(130)";
    case NVC7C0_CALL_MME_DATA(131):
        return "NVC7C0_CALL_MME_DATA(131)";
    case NVC7C0_CALL_MME_DATA(132):
        return "NVC7C0_CALL_MME_DATA(132)";
    case NVC7C0_CALL_MME_DATA(133):
        return "NVC7C0_CALL_MME_DATA(133)";
    case NVC7C0_CALL_MME_DATA(134):
        return "NVC7C0_CALL_MME_DATA(134)";
    case NVC7C0_CALL_MME_DATA(135):
        return "NVC7C0_CALL_MME_DATA(135)";
    case NVC7C0_CALL_MME_DATA(136):
        return "NVC7C0_CALL_MME_DATA(136)";
    case NVC7C0_CALL_MME_DATA(137):
        return "NVC7C0_CALL_MME_DATA(137)";
    case NVC7C0_CALL_MME_DATA(138):
        return "NVC7C0_CALL_MME_DATA(138)";
    case NVC7C0_CALL_MME_DATA(139):
        return "NVC7C0_CALL_MME_DATA(139)";
    case NVC7C0_CALL_MME_DATA(140):
        return "NVC7C0_CALL_MME_DATA(140)";
    case NVC7C0_CALL_MME_DATA(141):
        return "NVC7C0_CALL_MME_DATA(141)";
    case NVC7C0_CALL_MME_DATA(142):
        return "NVC7C0_CALL_MME_DATA(142)";
    case NVC7C0_CALL_MME_DATA(143):
        return "NVC7C0_CALL_MME_DATA(143)";
    case NVC7C0_CALL_MME_DATA(144):
        return "NVC7C0_CALL_MME_DATA(144)";
    case NVC7C0_CALL_MME_DATA(145):
        return "NVC7C0_CALL_MME_DATA(145)";
    case NVC7C0_CALL_MME_DATA(146):
        return "NVC7C0_CALL_MME_DATA(146)";
    case NVC7C0_CALL_MME_DATA(147):
        return "NVC7C0_CALL_MME_DATA(147)";
    case NVC7C0_CALL_MME_DATA(148):
        return "NVC7C0_CALL_MME_DATA(148)";
    case NVC7C0_CALL_MME_DATA(149):
        return "NVC7C0_CALL_MME_DATA(149)";
    case NVC7C0_CALL_MME_DATA(150):
        return "NVC7C0_CALL_MME_DATA(150)";
    case NVC7C0_CALL_MME_DATA(151):
        return "NVC7C0_CALL_MME_DATA(151)";
    case NVC7C0_CALL_MME_DATA(152):
        return "NVC7C0_CALL_MME_DATA(152)";
    case NVC7C0_CALL_MME_DATA(153):
        return "NVC7C0_CALL_MME_DATA(153)";
    case NVC7C0_CALL_MME_DATA(154):
        return "NVC7C0_CALL_MME_DATA(154)";
    case NVC7C0_CALL_MME_DATA(155):
        return "NVC7C0_CALL_MME_DATA(155)";
    case NVC7C0_CALL_MME_DATA(156):
        return "NVC7C0_CALL_MME_DATA(156)";
    case NVC7C0_CALL_MME_DATA(157):
        return "NVC7C0_CALL_MME_DATA(157)";
    case NVC7C0_CALL_MME_DATA(158):
        return "NVC7C0_CALL_MME_DATA(158)";
    case NVC7C0_CALL_MME_DATA(159):
        return "NVC7C0_CALL_MME_DATA(159)";
    case NVC7C0_CALL_MME_DATA(160):
        return "NVC7C0_CALL_MME_DATA(160)";
    case NVC7C0_CALL_MME_DATA(161):
        return "NVC7C0_CALL_MME_DATA(161)";
    case NVC7C0_CALL_MME_DATA(162):
        return "NVC7C0_CALL_MME_DATA(162)";
    case NVC7C0_CALL_MME_DATA(163):
        return "NVC7C0_CALL_MME_DATA(163)";
    case NVC7C0_CALL_MME_DATA(164):
        return "NVC7C0_CALL_MME_DATA(164)";
    case NVC7C0_CALL_MME_DATA(165):
        return "NVC7C0_CALL_MME_DATA(165)";
    case NVC7C0_CALL_MME_DATA(166):
        return "NVC7C0_CALL_MME_DATA(166)";
    case NVC7C0_CALL_MME_DATA(167):
        return "NVC7C0_CALL_MME_DATA(167)";
    case NVC7C0_CALL_MME_DATA(168):
        return "NVC7C0_CALL_MME_DATA(168)";
    case NVC7C0_CALL_MME_DATA(169):
        return "NVC7C0_CALL_MME_DATA(169)";
    case NVC7C0_CALL_MME_DATA(170):
        return "NVC7C0_CALL_MME_DATA(170)";
    case NVC7C0_CALL_MME_DATA(171):
        return "NVC7C0_CALL_MME_DATA(171)";
    case NVC7C0_CALL_MME_DATA(172):
        return "NVC7C0_CALL_MME_DATA(172)";
    case NVC7C0_CALL_MME_DATA(173):
        return "NVC7C0_CALL_MME_DATA(173)";
    case NVC7C0_CALL_MME_DATA(174):
        return "NVC7C0_CALL_MME_DATA(174)";
    case NVC7C0_CALL_MME_DATA(175):
        return "NVC7C0_CALL_MME_DATA(175)";
    case NVC7C0_CALL_MME_DATA(176):
        return "NVC7C0_CALL_MME_DATA(176)";
    case NVC7C0_CALL_MME_DATA(177):
        return "NVC7C0_CALL_MME_DATA(177)";
    case NVC7C0_CALL_MME_DATA(178):
        return "NVC7C0_CALL_MME_DATA(178)";
    case NVC7C0_CALL_MME_DATA(179):
        return "NVC7C0_CALL_MME_DATA(179)";
    case NVC7C0_CALL_MME_DATA(180):
        return "NVC7C0_CALL_MME_DATA(180)";
    case NVC7C0_CALL_MME_DATA(181):
        return "NVC7C0_CALL_MME_DATA(181)";
    case NVC7C0_CALL_MME_DATA(182):
        return "NVC7C0_CALL_MME_DATA(182)";
    case NVC7C0_CALL_MME_DATA(183):
        return "NVC7C0_CALL_MME_DATA(183)";
    case NVC7C0_CALL_MME_DATA(184):
        return "NVC7C0_CALL_MME_DATA(184)";
    case NVC7C0_CALL_MME_DATA(185):
        return "NVC7C0_CALL_MME_DATA(185)";
    case NVC7C0_CALL_MME_DATA(186):
        return "NVC7C0_CALL_MME_DATA(186)";
    case NVC7C0_CALL_MME_DATA(187):
        return "NVC7C0_CALL_MME_DATA(187)";
    case NVC7C0_CALL_MME_DATA(188):
        return "NVC7C0_CALL_MME_DATA(188)";
    case NVC7C0_CALL_MME_DATA(189):
        return "NVC7C0_CALL_MME_DATA(189)";
    case NVC7C0_CALL_MME_DATA(190):
        return "NVC7C0_CALL_MME_DATA(190)";
    case NVC7C0_CALL_MME_DATA(191):
        return "NVC7C0_CALL_MME_DATA(191)";
    case NVC7C0_CALL_MME_DATA(192):
        return "NVC7C0_CALL_MME_DATA(192)";
    case NVC7C0_CALL_MME_DATA(193):
        return "NVC7C0_CALL_MME_DATA(193)";
    case NVC7C0_CALL_MME_DATA(194):
        return "NVC7C0_CALL_MME_DATA(194)";
    case NVC7C0_CALL_MME_DATA(195):
        return "NVC7C0_CALL_MME_DATA(195)";
    case NVC7C0_CALL_MME_DATA(196):
        return "NVC7C0_CALL_MME_DATA(196)";
    case NVC7C0_CALL_MME_DATA(197):
        return "NVC7C0_CALL_MME_DATA(197)";
    case NVC7C0_CALL_MME_DATA(198):
        return "NVC7C0_CALL_MME_DATA(198)";
    case NVC7C0_CALL_MME_DATA(199):
        return "NVC7C0_CALL_MME_DATA(199)";
    case NVC7C0_CALL_MME_DATA(200):
        return "NVC7C0_CALL_MME_DATA(200)";
    case NVC7C0_CALL_MME_DATA(201):
        return "NVC7C0_CALL_MME_DATA(201)";
    case NVC7C0_CALL_MME_DATA(202):
        return "NVC7C0_CALL_MME_DATA(202)";
    case NVC7C0_CALL_MME_DATA(203):
        return "NVC7C0_CALL_MME_DATA(203)";
    case NVC7C0_CALL_MME_DATA(204):
        return "NVC7C0_CALL_MME_DATA(204)";
    case NVC7C0_CALL_MME_DATA(205):
        return "NVC7C0_CALL_MME_DATA(205)";
    case NVC7C0_CALL_MME_DATA(206):
        return "NVC7C0_CALL_MME_DATA(206)";
    case NVC7C0_CALL_MME_DATA(207):
        return "NVC7C0_CALL_MME_DATA(207)";
    case NVC7C0_CALL_MME_DATA(208):
        return "NVC7C0_CALL_MME_DATA(208)";
    case NVC7C0_CALL_MME_DATA(209):
        return "NVC7C0_CALL_MME_DATA(209)";
    case NVC7C0_CALL_MME_DATA(210):
        return "NVC7C0_CALL_MME_DATA(210)";
    case NVC7C0_CALL_MME_DATA(211):
        return "NVC7C0_CALL_MME_DATA(211)";
    case NVC7C0_CALL_MME_DATA(212):
        return "NVC7C0_CALL_MME_DATA(212)";
    case NVC7C0_CALL_MME_DATA(213):
        return "NVC7C0_CALL_MME_DATA(213)";
    case NVC7C0_CALL_MME_DATA(214):
        return "NVC7C0_CALL_MME_DATA(214)";
    case NVC7C0_CALL_MME_DATA(215):
        return "NVC7C0_CALL_MME_DATA(215)";
    case NVC7C0_CALL_MME_DATA(216):
        return "NVC7C0_CALL_MME_DATA(216)";
    case NVC7C0_CALL_MME_DATA(217):
        return "NVC7C0_CALL_MME_DATA(217)";
    case NVC7C0_CALL_MME_DATA(218):
        return "NVC7C0_CALL_MME_DATA(218)";
    case NVC7C0_CALL_MME_DATA(219):
        return "NVC7C0_CALL_MME_DATA(219)";
    case NVC7C0_CALL_MME_DATA(220):
        return "NVC7C0_CALL_MME_DATA(220)";
    case NVC7C0_CALL_MME_DATA(221):
        return "NVC7C0_CALL_MME_DATA(221)";
    case NVC7C0_CALL_MME_DATA(222):
        return "NVC7C0_CALL_MME_DATA(222)";
    case NVC7C0_CALL_MME_DATA(223):
        return "NVC7C0_CALL_MME_DATA(223)";
    case NVC7C0_CALL_MME_DATA(224):
        return "NVC7C0_CALL_MME_DATA(224)";
    case NVC7C0_CALL_MME_DATA(225):
        return "NVC7C0_CALL_MME_DATA(225)";
    case NVC7C0_CALL_MME_DATA(226):
        return "NVC7C0_CALL_MME_DATA(226)";
    case NVC7C0_CALL_MME_DATA(227):
        return "NVC7C0_CALL_MME_DATA(227)";
    case NVC7C0_CALL_MME_DATA(228):
        return "NVC7C0_CALL_MME_DATA(228)";
    case NVC7C0_CALL_MME_DATA(229):
        return "NVC7C0_CALL_MME_DATA(229)";
    case NVC7C0_CALL_MME_DATA(230):
        return "NVC7C0_CALL_MME_DATA(230)";
    case NVC7C0_CALL_MME_DATA(231):
        return "NVC7C0_CALL_MME_DATA(231)";
    case NVC7C0_CALL_MME_DATA(232):
        return "NVC7C0_CALL_MME_DATA(232)";
    case NVC7C0_CALL_MME_DATA(233):
        return "NVC7C0_CALL_MME_DATA(233)";
    case NVC7C0_CALL_MME_DATA(234):
        return "NVC7C0_CALL_MME_DATA(234)";
    case NVC7C0_CALL_MME_DATA(235):
        return "NVC7C0_CALL_MME_DATA(235)";
    case NVC7C0_CALL_MME_DATA(236):
        return "NVC7C0_CALL_MME_DATA(236)";
    case NVC7C0_CALL_MME_DATA(237):
        return "NVC7C0_CALL_MME_DATA(237)";
    case NVC7C0_CALL_MME_DATA(238):
        return "NVC7C0_CALL_MME_DATA(238)";
    case NVC7C0_CALL_MME_DATA(239):
        return "NVC7C0_CALL_MME_DATA(239)";
    case NVC7C0_CALL_MME_DATA(240):
        return "NVC7C0_CALL_MME_DATA(240)";
    case NVC7C0_CALL_MME_DATA(241):
        return "NVC7C0_CALL_MME_DATA(241)";
    case NVC7C0_CALL_MME_DATA(242):
        return "NVC7C0_CALL_MME_DATA(242)";
    case NVC7C0_CALL_MME_DATA(243):
        return "NVC7C0_CALL_MME_DATA(243)";
    case NVC7C0_CALL_MME_DATA(244):
        return "NVC7C0_CALL_MME_DATA(244)";
    case NVC7C0_CALL_MME_DATA(245):
        return "NVC7C0_CALL_MME_DATA(245)";
    case NVC7C0_CALL_MME_DATA(246):
        return "NVC7C0_CALL_MME_DATA(246)";
    case NVC7C0_CALL_MME_DATA(247):
        return "NVC7C0_CALL_MME_DATA(247)";
    case NVC7C0_CALL_MME_DATA(248):
        return "NVC7C0_CALL_MME_DATA(248)";
    case NVC7C0_CALL_MME_DATA(249):
        return "NVC7C0_CALL_MME_DATA(249)";
    case NVC7C0_CALL_MME_DATA(250):
        return "NVC7C0_CALL_MME_DATA(250)";
    case NVC7C0_CALL_MME_DATA(251):
        return "NVC7C0_CALL_MME_DATA(251)";
    case NVC7C0_CALL_MME_DATA(252):
        return "NVC7C0_CALL_MME_DATA(252)";
    case NVC7C0_CALL_MME_DATA(253):
        return "NVC7C0_CALL_MME_DATA(253)";
    case NVC7C0_CALL_MME_DATA(254):
        return "NVC7C0_CALL_MME_DATA(254)";
    case NVC7C0_CALL_MME_DATA(255):
        return "NVC7C0_CALL_MME_DATA(255)";
    default:
        return "unknown method";
    }
}

void
P_DUMP_NVC7C0_MTHD_DATA(FILE *fp, uint16_t idx, uint32_t data,
                         const char *prefix)
{
    uint32_t parsed;
    switch (idx) {
    case NVC7C0_SET_OBJECT:
    
        parsed = (data >> 0) & ((1u << 16) - 1);
        fprintf(fp, "%s.CLASS_ID = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
    
        parsed = (data >> 16) & ((1u << 5) - 1);
        fprintf(fp, "%s.ENGINE_ID = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVC7C0_NO_OPERATION:
    
        parsed = data;
        fprintf(fp, "%s.V = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVC7C0_SET_NOTIFY_A:
    
        parsed = (data >> 0) & ((1u << 8) - 1);
        fprintf(fp, "%s.ADDRESS_UPPER = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVC7C0_SET_NOTIFY_B:
    
        parsed = data;
        fprintf(fp, "%s.ADDRESS_LOWER = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVC7C0_NOTIFY:
    
        parsed = data;
        fprintf(fp, "%s.TYPE = ", prefix);
        switch (parsed) {
        case NVC7C0_NOTIFY_TYPE_WRITE_ONLY:
            fprintf(fp, "WRITE_ONLY\n");
            break;
        case NVC7C0_NOTIFY_TYPE_WRITE_THEN_AWAKEN:
            fprintf(fp, "WRITE_THEN_AWAKEN\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
        break;
    case NVC7C0_WAIT_FOR_IDLE:
    
        parsed = data;
        fprintf(fp, "%s.V = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVC7C0_LOAD_MME_INSTRUCTION_RAM_POINTER:
    
        parsed = data;
        fprintf(fp, "%s.V = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVC7C0_LOAD_MME_INSTRUCTION_RAM:
    
        parsed = data;
        fprintf(fp, "%s.V = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVC7C0_LOAD_MME_START_ADDRESS_RAM_POINTER:
    
        parsed = data;
        fprintf(fp, "%s.V = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVC7C0_LOAD_MME_START_ADDRESS_RAM:
    
        parsed = data;
        fprintf(fp, "%s.V = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVC7C0_SET_MME_SHADOW_RAM_CONTROL:
    
        parsed = (data >> 0) & ((1u << 2) - 1);
        fprintf(fp, "%s.MODE = ", prefix);
        switch (parsed) {
        case NVC7C0_SET_MME_SHADOW_RAM_CONTROL_MODE_METHOD_TRACK:
            fprintf(fp, "METHOD_TRACK\n");
            break;
        case NVC7C0_SET_MME_SHADOW_RAM_CONTROL_MODE_METHOD_TRACK_WITH_FILTER:
            fprintf(fp, "METHOD_TRACK_WITH_FILTER\n");
            break;
        case NVC7C0_SET_MME_SHADOW_RAM_CONTROL_MODE_METHOD_PASSTHROUGH:
            fprintf(fp, "METHOD_PASSTHROUGH\n");
            break;
        case NVC7C0_SET_MME_SHADOW_RAM_CONTROL_MODE_METHOD_REPLAY:
            fprintf(fp, "METHOD_REPLAY\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
        break;
    case NVC7C0_SET_GLOBAL_RENDER_ENABLE_A:
    
        parsed = (data >> 0) & ((1u << 8) - 1);
        fprintf(fp, "%s.OFFSET_UPPER = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVC7C0_SET_GLOBAL_RENDER_ENABLE_B:
    
        parsed = data;
        fprintf(fp, "%s.OFFSET_LOWER = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVC7C0_SET_GLOBAL_RENDER_ENABLE_C:
    
        parsed = (data >> 0) & ((1u << 3) - 1);
        fprintf(fp, "%s.MODE = ", prefix);
        switch (parsed) {
        case NVC7C0_SET_GLOBAL_RENDER_ENABLE_C_MODE_FALSE:
            fprintf(fp, "FALSE\n");
            break;
        case NVC7C0_SET_GLOBAL_RENDER_ENABLE_C_MODE_TRUE:
            fprintf(fp, "TRUE\n");
            break;
        case NVC7C0_SET_GLOBAL_RENDER_ENABLE_C_MODE_CONDITIONAL:
            fprintf(fp, "CONDITIONAL\n");
            break;
        case NVC7C0_SET_GLOBAL_RENDER_ENABLE_C_MODE_RENDER_IF_EQUAL:
            fprintf(fp, "RENDER_IF_EQUAL\n");
            break;
        case NVC7C0_SET_GLOBAL_RENDER_ENABLE_C_MODE_RENDER_IF_NOT_EQUAL:
            fprintf(fp, "RENDER_IF_NOT_EQUAL\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
        break;
    case NVC7C0_SEND_GO_IDLE:
    
        parsed = data;
        fprintf(fp, "%s.V = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVC7C0_PM_TRIGGER:
    
        parsed = data;
        fprintf(fp, "%s.V = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVC7C0_PM_TRIGGER_WFI:
    
        parsed = data;
        fprintf(fp, "%s.V = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVC7C0_FE_ATOMIC_SEQUENCE_BEGIN:
    
        parsed = data;
        fprintf(fp, "%s.V = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVC7C0_FE_ATOMIC_SEQUENCE_END:
    
        parsed = data;
        fprintf(fp, "%s.V = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVC7C0_SET_INSTRUMENTATION_METHOD_HEADER:
    
        parsed = data;
        fprintf(fp, "%s.V = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVC7C0_SET_INSTRUMENTATION_METHOD_DATA:
    
        parsed = data;
        fprintf(fp, "%s.V = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVC7C0_SET_REPORT_SEMAPHORE_PAYLOAD_LOWER:
    
        parsed = data;
        fprintf(fp, "%s.PAYLOAD_LOWER = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVC7C0_SET_REPORT_SEMAPHORE_PAYLOAD_UPPER:
    
        parsed = data;
        fprintf(fp, "%s.PAYLOAD_UPPER = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVC7C0_SET_REPORT_SEMAPHORE_ADDRESS_LOWER:
    
        parsed = data;
        fprintf(fp, "%s.LOWER = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVC7C0_SET_REPORT_SEMAPHORE_ADDRESS_UPPER:
    
        parsed = (data >> 0) & ((1u << 8) - 1);
        fprintf(fp, "%s.UPPER = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVC7C0_REPORT_SEMAPHORE_EXECUTE:
    
        parsed = (data >> 0) & ((1u << 2) - 1);
        fprintf(fp, "%s.OPERATION = ", prefix);
        switch (parsed) {
        case NVC7C0_REPORT_SEMAPHORE_EXECUTE_OPERATION_RELEASE:
            fprintf(fp, "RELEASE\n");
            break;
        case NVC7C0_REPORT_SEMAPHORE_EXECUTE_OPERATION_ACQUIRE:
            fprintf(fp, "ACQUIRE\n");
            break;
        case NVC7C0_REPORT_SEMAPHORE_EXECUTE_OPERATION_REPORT_ONLY:
            fprintf(fp, "REPORT_ONLY\n");
            break;
        case NVC7C0_REPORT_SEMAPHORE_EXECUTE_OPERATION_TRAP:
            fprintf(fp, "TRAP\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
    
        parsed = (data >> 2) & ((1u << 1) - 1);
        fprintf(fp, "%s.AWAKEN_ENABLE = ", prefix);
        switch (parsed) {
        case NVC7C0_REPORT_SEMAPHORE_EXECUTE_AWAKEN_ENABLE_FALSE:
            fprintf(fp, "FALSE\n");
            break;
        case NVC7C0_REPORT_SEMAPHORE_EXECUTE_AWAKEN_ENABLE_TRUE:
            fprintf(fp, "TRUE\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
    
        parsed = (data >> 3) & ((1u << 2) - 1);
        fprintf(fp, "%s.STRUCTURE_SIZE = ", prefix);
        switch (parsed) {
        case NVC7C0_REPORT_SEMAPHORE_EXECUTE_STRUCTURE_SIZE_SEMAPHORE_FOUR_WORDS:
            fprintf(fp, "SEMAPHORE_FOUR_WORDS\n");
            break;
        case NVC7C0_REPORT_SEMAPHORE_EXECUTE_STRUCTURE_SIZE_SEMAPHORE_ONE_WORD:
            fprintf(fp, "SEMAPHORE_ONE_WORD\n");
            break;
        case NVC7C0_REPORT_SEMAPHORE_EXECUTE_STRUCTURE_SIZE_SEMAPHORE_TWO_WORDS:
            fprintf(fp, "SEMAPHORE_TWO_WORDS\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
    
        parsed = (data >> 5) & ((1u << 1) - 1);
        fprintf(fp, "%s.FLUSH_DISABLE = ", prefix);
        switch (parsed) {
        case NVC7C0_REPORT_SEMAPHORE_EXECUTE_FLUSH_DISABLE_FALSE:
            fprintf(fp, "FALSE\n");
            break;
        case NVC7C0_REPORT_SEMAPHORE_EXECUTE_FLUSH_DISABLE_TRUE:
            fprintf(fp, "TRUE\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
    
        parsed = (data >> 6) & ((1u << 1) - 1);
        fprintf(fp, "%s.REDUCTION_ENABLE = ", prefix);
        switch (parsed) {
        case NVC7C0_REPORT_SEMAPHORE_EXECUTE_REDUCTION_ENABLE_FALSE:
            fprintf(fp, "FALSE\n");
            break;
        case NVC7C0_REPORT_SEMAPHORE_EXECUTE_REDUCTION_ENABLE_TRUE:
            fprintf(fp, "TRUE\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
    
        parsed = (data >> 7) & ((1u << 3) - 1);
        fprintf(fp, "%s.REDUCTION_OP = ", prefix);
        switch (parsed) {
        case NVC7C0_REPORT_SEMAPHORE_EXECUTE_REDUCTION_OP_RED_ADD:
            fprintf(fp, "RED_ADD\n");
            break;
        case NVC7C0_REPORT_SEMAPHORE_EXECUTE_REDUCTION_OP_RED_MIN:
            fprintf(fp, "RED_MIN\n");
            break;
        case NVC7C0_REPORT_SEMAPHORE_EXECUTE_REDUCTION_OP_RED_MAX:
            fprintf(fp, "RED_MAX\n");
            break;
        case NVC7C0_REPORT_SEMAPHORE_EXECUTE_REDUCTION_OP_RED_INC:
            fprintf(fp, "RED_INC\n");
            break;
        case NVC7C0_REPORT_SEMAPHORE_EXECUTE_REDUCTION_OP_RED_DEC:
            fprintf(fp, "RED_DEC\n");
            break;
        case NVC7C0_REPORT_SEMAPHORE_EXECUTE_REDUCTION_OP_RED_AND:
            fprintf(fp, "RED_AND\n");
            break;
        case NVC7C0_REPORT_SEMAPHORE_EXECUTE_REDUCTION_OP_RED_OR:
            fprintf(fp, "RED_OR\n");
            break;
        case NVC7C0_REPORT_SEMAPHORE_EXECUTE_REDUCTION_OP_RED_XOR:
            fprintf(fp, "RED_XOR\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
    
        parsed = (data >> 10) & ((1u << 2) - 1);
        fprintf(fp, "%s.REDUCTION_FORMAT = ", prefix);
        switch (parsed) {
        case NVC7C0_REPORT_SEMAPHORE_EXECUTE_REDUCTION_FORMAT_UNSIGNED:
            fprintf(fp, "UNSIGNED\n");
            break;
        case NVC7C0_REPORT_SEMAPHORE_EXECUTE_REDUCTION_FORMAT_SIGNED:
            fprintf(fp, "SIGNED\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
    
        parsed = (data >> 12) & ((1u << 1) - 1);
        fprintf(fp, "%s.PAYLOAD_SIZE64 = ", prefix);
        switch (parsed) {
        case NVC7C0_REPORT_SEMAPHORE_EXECUTE_PAYLOAD_SIZE64_FALSE:
            fprintf(fp, "FALSE\n");
            break;
        case NVC7C0_REPORT_SEMAPHORE_EXECUTE_PAYLOAD_SIZE64_TRUE:
            fprintf(fp, "TRUE\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
    
        parsed = (data >> 13) & ((1u << 2) - 1);
        fprintf(fp, "%s.TRAP_TYPE = ", prefix);
        switch (parsed) {
        case NVC7C0_REPORT_SEMAPHORE_EXECUTE_TRAP_TYPE_TRAP_NONE:
            fprintf(fp, "TRAP_NONE\n");
            break;
        case NVC7C0_REPORT_SEMAPHORE_EXECUTE_TRAP_TYPE_TRAP_UNCONDITIONAL:
            fprintf(fp, "TRAP_UNCONDITIONAL\n");
            break;
        case NVC7C0_REPORT_SEMAPHORE_EXECUTE_TRAP_TYPE_TRAP_CONDITIONAL:
            fprintf(fp, "TRAP_CONDITIONAL\n");
            break;
        case NVC7C0_REPORT_SEMAPHORE_EXECUTE_TRAP_TYPE_TRAP_CONDITIONAL_EXT:
            fprintf(fp, "TRAP_CONDITIONAL_EXT\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
        break;
    case NVC7C0_LINE_LENGTH_IN:
    
        parsed = data;
        fprintf(fp, "%s.VALUE = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVC7C0_LINE_COUNT:
    
        parsed = data;
        fprintf(fp, "%s.VALUE = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVC7C0_OFFSET_OUT_UPPER:
    
        parsed = (data >> 0) & ((1u << 17) - 1);
        fprintf(fp, "%s.VALUE = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVC7C0_OFFSET_OUT:
    
        parsed = data;
        fprintf(fp, "%s.VALUE = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVC7C0_PITCH_OUT:
    
        parsed = data;
        fprintf(fp, "%s.VALUE = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVC7C0_SET_DST_BLOCK_SIZE:
    
        parsed = (data >> 0) & ((1u << 4) - 1);
        fprintf(fp, "%s.WIDTH = ", prefix);
        switch (parsed) {
        case NVC7C0_SET_DST_BLOCK_SIZE_WIDTH_ONE_GOB:
            fprintf(fp, "ONE_GOB\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
    
        parsed = (data >> 4) & ((1u << 4) - 1);
        fprintf(fp, "%s.HEIGHT = ", prefix);
        switch (parsed) {
        case NVC7C0_SET_DST_BLOCK_SIZE_HEIGHT_ONE_GOB:
            fprintf(fp, "ONE_GOB\n");
            break;
        case NVC7C0_SET_DST_BLOCK_SIZE_HEIGHT_TWO_GOBS:
            fprintf(fp, "TWO_GOBS\n");
            break;
        case NVC7C0_SET_DST_BLOCK_SIZE_HEIGHT_FOUR_GOBS:
            fprintf(fp, "FOUR_GOBS\n");
            break;
        case NVC7C0_SET_DST_BLOCK_SIZE_HEIGHT_EIGHT_GOBS:
            fprintf(fp, "EIGHT_GOBS\n");
            break;
        case NVC7C0_SET_DST_BLOCK_SIZE_HEIGHT_SIXTEEN_GOBS:
            fprintf(fp, "SIXTEEN_GOBS\n");
            break;
        case NVC7C0_SET_DST_BLOCK_SIZE_HEIGHT_THIRTYTWO_GOBS:
            fprintf(fp, "THIRTYTWO_GOBS\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
    
        parsed = (data >> 8) & ((1u << 4) - 1);
        fprintf(fp, "%s.DEPTH = ", prefix);
        switch (parsed) {
        case NVC7C0_SET_DST_BLOCK_SIZE_DEPTH_ONE_GOB:
            fprintf(fp, "ONE_GOB\n");
            break;
        case NVC7C0_SET_DST_BLOCK_SIZE_DEPTH_TWO_GOBS:
            fprintf(fp, "TWO_GOBS\n");
            break;
        case NVC7C0_SET_DST_BLOCK_SIZE_DEPTH_FOUR_GOBS:
            fprintf(fp, "FOUR_GOBS\n");
            break;
        case NVC7C0_SET_DST_BLOCK_SIZE_DEPTH_EIGHT_GOBS:
            fprintf(fp, "EIGHT_GOBS\n");
            break;
        case NVC7C0_SET_DST_BLOCK_SIZE_DEPTH_SIXTEEN_GOBS:
            fprintf(fp, "SIXTEEN_GOBS\n");
            break;
        case NVC7C0_SET_DST_BLOCK_SIZE_DEPTH_THIRTYTWO_GOBS:
            fprintf(fp, "THIRTYTWO_GOBS\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
        break;
    case NVC7C0_SET_DST_WIDTH:
    
        parsed = data;
        fprintf(fp, "%s.V = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVC7C0_SET_DST_HEIGHT:
    
        parsed = data;
        fprintf(fp, "%s.V = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVC7C0_SET_DST_DEPTH:
    
        parsed = data;
        fprintf(fp, "%s.V = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVC7C0_SET_DST_LAYER:
    
        parsed = data;
        fprintf(fp, "%s.V = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVC7C0_SET_DST_ORIGIN_BYTES_X:
    
        parsed = (data >> 0) & ((1u << 21) - 1);
        fprintf(fp, "%s.V = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVC7C0_SET_DST_ORIGIN_SAMPLES_Y:
    
        parsed = (data >> 0) & ((1u << 17) - 1);
        fprintf(fp, "%s.V = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVC7C0_LAUNCH_DMA:
    
        parsed = (data >> 0) & ((1u << 1) - 1);
        fprintf(fp, "%s.DST_MEMORY_LAYOUT = ", prefix);
        switch (parsed) {
        case NVC7C0_LAUNCH_DMA_DST_MEMORY_LAYOUT_BLOCKLINEAR:
            fprintf(fp, "BLOCKLINEAR\n");
            break;
        case NVC7C0_LAUNCH_DMA_DST_MEMORY_LAYOUT_PITCH:
            fprintf(fp, "PITCH\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
    
        parsed = (data >> 4) & ((1u << 2) - 1);
        fprintf(fp, "%s.COMPLETION_TYPE = ", prefix);
        switch (parsed) {
        case NVC7C0_LAUNCH_DMA_COMPLETION_TYPE_FLUSH_DISABLE:
            fprintf(fp, "FLUSH_DISABLE\n");
            break;
        case NVC7C0_LAUNCH_DMA_COMPLETION_TYPE_FLUSH_ONLY:
            fprintf(fp, "FLUSH_ONLY\n");
            break;
        case NVC7C0_LAUNCH_DMA_COMPLETION_TYPE_RELEASE_SEMAPHORE:
            fprintf(fp, "RELEASE_SEMAPHORE\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
    
        parsed = (data >> 8) & ((1u << 2) - 1);
        fprintf(fp, "%s.INTERRUPT_TYPE = ", prefix);
        switch (parsed) {
        case NVC7C0_LAUNCH_DMA_INTERRUPT_TYPE_NONE:
            fprintf(fp, "NONE\n");
            break;
        case NVC7C0_LAUNCH_DMA_INTERRUPT_TYPE_INTERRUPT:
            fprintf(fp, "INTERRUPT\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
    
        parsed = (data >> 12) & ((1u << 1) - 1);
        fprintf(fp, "%s.SEMAPHORE_STRUCT_SIZE = ", prefix);
        switch (parsed) {
        case NVC7C0_LAUNCH_DMA_SEMAPHORE_STRUCT_SIZE_FOUR_WORDS:
            fprintf(fp, "FOUR_WORDS\n");
            break;
        case NVC7C0_LAUNCH_DMA_SEMAPHORE_STRUCT_SIZE_ONE_WORD:
            fprintf(fp, "ONE_WORD\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
    
        parsed = (data >> 1) & ((1u << 1) - 1);
        fprintf(fp, "%s.REDUCTION_ENABLE = ", prefix);
        switch (parsed) {
        case NVC7C0_LAUNCH_DMA_REDUCTION_ENABLE_FALSE:
            fprintf(fp, "FALSE\n");
            break;
        case NVC7C0_LAUNCH_DMA_REDUCTION_ENABLE_TRUE:
            fprintf(fp, "TRUE\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
    
        parsed = (data >> 13) & ((1u << 3) - 1);
        fprintf(fp, "%s.REDUCTION_OP = ", prefix);
        switch (parsed) {
        case NVC7C0_LAUNCH_DMA_REDUCTION_OP_RED_ADD:
            fprintf(fp, "RED_ADD\n");
            break;
        case NVC7C0_LAUNCH_DMA_REDUCTION_OP_RED_MIN:
            fprintf(fp, "RED_MIN\n");
            break;
        case NVC7C0_LAUNCH_DMA_REDUCTION_OP_RED_MAX:
            fprintf(fp, "RED_MAX\n");
            break;
        case NVC7C0_LAUNCH_DMA_REDUCTION_OP_RED_INC:
            fprintf(fp, "RED_INC\n");
            break;
        case NVC7C0_LAUNCH_DMA_REDUCTION_OP_RED_DEC:
            fprintf(fp, "RED_DEC\n");
            break;
        case NVC7C0_LAUNCH_DMA_REDUCTION_OP_RED_AND:
            fprintf(fp, "RED_AND\n");
            break;
        case NVC7C0_LAUNCH_DMA_REDUCTION_OP_RED_OR:
            fprintf(fp, "RED_OR\n");
            break;
        case NVC7C0_LAUNCH_DMA_REDUCTION_OP_RED_XOR:
            fprintf(fp, "RED_XOR\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
    
        parsed = (data >> 2) & ((1u << 2) - 1);
        fprintf(fp, "%s.REDUCTION_FORMAT = ", prefix);
        switch (parsed) {
        case NVC7C0_LAUNCH_DMA_REDUCTION_FORMAT_UNSIGNED_32:
            fprintf(fp, "UNSIGNED_32\n");
            break;
        case NVC7C0_LAUNCH_DMA_REDUCTION_FORMAT_SIGNED_32:
            fprintf(fp, "SIGNED_32\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
    
        parsed = (data >> 6) & ((1u << 1) - 1);
        fprintf(fp, "%s.SYSMEMBAR_DISABLE = ", prefix);
        switch (parsed) {
        case NVC7C0_LAUNCH_DMA_SYSMEMBAR_DISABLE_FALSE:
            fprintf(fp, "FALSE\n");
            break;
        case NVC7C0_LAUNCH_DMA_SYSMEMBAR_DISABLE_TRUE:
            fprintf(fp, "TRUE\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
        break;
    case NVC7C0_LOAD_INLINE_DATA:
    
        parsed = data;
        fprintf(fp, "%s.V = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVC7C0_SET_I2M_SEMAPHORE_A:
    
        parsed = (data >> 0) & ((1u << 8) - 1);
        fprintf(fp, "%s.OFFSET_UPPER = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVC7C0_SET_I2M_SEMAPHORE_B:
    
        parsed = data;
        fprintf(fp, "%s.OFFSET_LOWER = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVC7C0_SET_I2M_SEMAPHORE_C:
    
        parsed = data;
        fprintf(fp, "%s.PAYLOAD = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVC7C0_SET_SM_SCG_CONTROL:
    
        parsed = (data >> 0) & ((1u << 1) - 1);
        fprintf(fp, "%s.COMPUTE_IN_GRAPHICS = ", prefix);
        switch (parsed) {
        case NVC7C0_SET_SM_SCG_CONTROL_COMPUTE_IN_GRAPHICS_FALSE:
            fprintf(fp, "FALSE\n");
            break;
        case NVC7C0_SET_SM_SCG_CONTROL_COMPUTE_IN_GRAPHICS_TRUE:
            fprintf(fp, "TRUE\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
        break;
    case NVC7C0_SET_MME_SWITCH_STATE:
    
        parsed = (data >> 0) & ((1u << 1) - 1);
        fprintf(fp, "%s.VALID = ", prefix);
        switch (parsed) {
        case NVC7C0_SET_MME_SWITCH_STATE_VALID_FALSE:
            fprintf(fp, "FALSE\n");
            break;
        case NVC7C0_SET_MME_SWITCH_STATE_VALID_TRUE:
            fprintf(fp, "TRUE\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
    
        parsed = (data >> 4) & ((1u << 8) - 1);
        fprintf(fp, "%s.SAVE_MACRO = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
    
        parsed = (data >> 12) & ((1u << 8) - 1);
        fprintf(fp, "%s.RESTORE_MACRO = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVC7C0_SET_I2M_SPARE_NOOP00:
    
        parsed = data;
        fprintf(fp, "%s.V = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVC7C0_SET_I2M_SPARE_NOOP01:
    
        parsed = data;
        fprintf(fp, "%s.V = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVC7C0_SET_I2M_SPARE_NOOP02:
    
        parsed = data;
        fprintf(fp, "%s.V = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVC7C0_SET_I2M_SPARE_NOOP03:
    
        parsed = data;
        fprintf(fp, "%s.V = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVC7C0_SET_VALID_SPAN_OVERFLOW_AREA_A:
    
        parsed = (data >> 0) & ((1u << 8) - 1);
        fprintf(fp, "%s.ADDRESS_UPPER = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVC7C0_SET_VALID_SPAN_OVERFLOW_AREA_B:
    
        parsed = data;
        fprintf(fp, "%s.ADDRESS_LOWER = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVC7C0_SET_VALID_SPAN_OVERFLOW_AREA_C:
    
        parsed = data;
        fprintf(fp, "%s.SIZE = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVC7C0_PERFMON_TRANSFER:
    
        parsed = data;
        fprintf(fp, "%s.V = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVC7C0_SET_QMD_VIRTUALIZATION_BASE_A:
    
        parsed = (data >> 0) & ((1u << 8) - 1);
        fprintf(fp, "%s.ADDRESS_UPPER = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVC7C0_SET_QMD_VIRTUALIZATION_BASE_B:
    
        parsed = data;
        fprintf(fp, "%s.ADDRESS_LOWER = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVC7C0_INVALIDATE_SHADER_CACHES:
    
        parsed = (data >> 0) & ((1u << 1) - 1);
        fprintf(fp, "%s.INSTRUCTION = ", prefix);
        switch (parsed) {
        case NVC7C0_INVALIDATE_SHADER_CACHES_INSTRUCTION_FALSE:
            fprintf(fp, "FALSE\n");
            break;
        case NVC7C0_INVALIDATE_SHADER_CACHES_INSTRUCTION_TRUE:
            fprintf(fp, "TRUE\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
    
        parsed = (data >> 4) & ((1u << 1) - 1);
        fprintf(fp, "%s.DATA = ", prefix);
        switch (parsed) {
        case NVC7C0_INVALIDATE_SHADER_CACHES_DATA_FALSE:
            fprintf(fp, "FALSE\n");
            break;
        case NVC7C0_INVALIDATE_SHADER_CACHES_DATA_TRUE:
            fprintf(fp, "TRUE\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
    
        parsed = (data >> 12) & ((1u << 1) - 1);
        fprintf(fp, "%s.CONSTANT = ", prefix);
        switch (parsed) {
        case NVC7C0_INVALIDATE_SHADER_CACHES_CONSTANT_FALSE:
            fprintf(fp, "FALSE\n");
            break;
        case NVC7C0_INVALIDATE_SHADER_CACHES_CONSTANT_TRUE:
            fprintf(fp, "TRUE\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
    
        parsed = (data >> 1) & ((1u << 1) - 1);
        fprintf(fp, "%s.LOCKS = ", prefix);
        switch (parsed) {
        case NVC7C0_INVALIDATE_SHADER_CACHES_LOCKS_FALSE:
            fprintf(fp, "FALSE\n");
            break;
        case NVC7C0_INVALIDATE_SHADER_CACHES_LOCKS_TRUE:
            fprintf(fp, "TRUE\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
    
        parsed = (data >> 2) & ((1u << 1) - 1);
        fprintf(fp, "%s.FLUSH_DATA = ", prefix);
        switch (parsed) {
        case NVC7C0_INVALIDATE_SHADER_CACHES_FLUSH_DATA_FALSE:
            fprintf(fp, "FALSE\n");
            break;
        case NVC7C0_INVALIDATE_SHADER_CACHES_FLUSH_DATA_TRUE:
            fprintf(fp, "TRUE\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
        break;
    case NVC7C0_SET_RESERVED_SW_METHOD00:
    
        parsed = data;
        fprintf(fp, "%s.V = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVC7C0_SET_RESERVED_SW_METHOD01:
    
        parsed = data;
        fprintf(fp, "%s.V = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVC7C0_SET_RESERVED_SW_METHOD02:
    
        parsed = data;
        fprintf(fp, "%s.V = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVC7C0_SET_RESERVED_SW_METHOD03:
    
        parsed = data;
        fprintf(fp, "%s.V = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVC7C0_SET_RESERVED_SW_METHOD04:
    
        parsed = data;
        fprintf(fp, "%s.V = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVC7C0_SET_RESERVED_SW_METHOD05:
    
        parsed = data;
        fprintf(fp, "%s.V = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVC7C0_SET_RESERVED_SW_METHOD06:
    
        parsed = data;
        fprintf(fp, "%s.V = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVC7C0_SET_RESERVED_SW_METHOD07:
    
        parsed = data;
        fprintf(fp, "%s.V = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVC7C0_INVALIDATE_TEXTURE_HEADER_CACHE_NO_WFI:
    
        parsed = (data >> 0) & ((1u << 1) - 1);
        fprintf(fp, "%s.LINES = ", prefix);
        switch (parsed) {
        case NVC7C0_INVALIDATE_TEXTURE_HEADER_CACHE_NO_WFI_LINES_ALL:
            fprintf(fp, "ALL\n");
            break;
        case NVC7C0_INVALIDATE_TEXTURE_HEADER_CACHE_NO_WFI_LINES_ONE:
            fprintf(fp, "ONE\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
    
        parsed = (data >> 4) & ((1u << 22) - 1);
        fprintf(fp, "%s.TAG = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVC7C0_SET_CWD_REF_COUNTER:
    
        parsed = (data >> 0) & ((1u << 6) - 1);
        fprintf(fp, "%s.SELECT = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
    
        parsed = (data >> 8) & ((1u << 16) - 1);
        fprintf(fp, "%s.VALUE = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVC7C0_SET_RESERVED_SW_METHOD08:
    
        parsed = data;
        fprintf(fp, "%s.V = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVC7C0_SET_RESERVED_SW_METHOD09:
    
        parsed = data;
        fprintf(fp, "%s.V = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVC7C0_SET_RESERVED_SW_METHOD10:
    
        parsed = data;
        fprintf(fp, "%s.V = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVC7C0_SET_RESERVED_SW_METHOD11:
    
        parsed = data;
        fprintf(fp, "%s.V = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVC7C0_SET_RESERVED_SW_METHOD12:
    
        parsed = data;
        fprintf(fp, "%s.V = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVC7C0_SET_RESERVED_SW_METHOD13:
    
        parsed = data;
        fprintf(fp, "%s.V = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVC7C0_SET_RESERVED_SW_METHOD14:
    
        parsed = data;
        fprintf(fp, "%s.V = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVC7C0_SET_RESERVED_SW_METHOD15:
    
        parsed = data;
        fprintf(fp, "%s.V = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVC7C0_SET_SCG_CONTROL:
    
        parsed = (data >> 0) & ((1u << 9) - 1);
        fprintf(fp, "%s.COMPUTE1_MAX_SM_COUNT = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
    
        parsed = (data >> 12) & ((1u << 9) - 1);
        fprintf(fp, "%s.COMPUTE1_MIN_SM_COUNT = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
    
        parsed = (data >> 24) & ((1u << 1) - 1);
        fprintf(fp, "%s.DISABLE_COMPUTE1_LIMIT_IN_ALL_COMPUTE = ", prefix);
        switch (parsed) {
        case NVC7C0_SET_SCG_CONTROL_DISABLE_COMPUTE1_LIMIT_IN_ALL_COMPUTE_FALSE:
            fprintf(fp, "FALSE\n");
            break;
        case NVC7C0_SET_SCG_CONTROL_DISABLE_COMPUTE1_LIMIT_IN_ALL_COMPUTE_TRUE:
            fprintf(fp, "TRUE\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
        break;
    case NVC7C0_SET_COMPUTE_CLASS_VERSION:
    
        parsed = (data >> 0) & ((1u << 16) - 1);
        fprintf(fp, "%s.CURRENT = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
    
        parsed = (data >> 16) & ((1u << 16) - 1);
        fprintf(fp, "%s.OLDEST_SUPPORTED = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVC7C0_CHECK_COMPUTE_CLASS_VERSION:
    
        parsed = (data >> 0) & ((1u << 16) - 1);
        fprintf(fp, "%s.CURRENT = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
    
        parsed = (data >> 16) & ((1u << 16) - 1);
        fprintf(fp, "%s.OLDEST_SUPPORTED = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVC7C0_SET_QMD_VERSION:
    
        parsed = (data >> 0) & ((1u << 16) - 1);
        fprintf(fp, "%s.CURRENT = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
    
        parsed = (data >> 16) & ((1u << 16) - 1);
        fprintf(fp, "%s.OLDEST_SUPPORTED = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVC7C0_CHECK_QMD_VERSION:
    
        parsed = (data >> 0) & ((1u << 16) - 1);
        fprintf(fp, "%s.CURRENT = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
    
        parsed = (data >> 16) & ((1u << 16) - 1);
        fprintf(fp, "%s.OLDEST_SUPPORTED = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVC7C0_INVALIDATE_SKED_CACHES:
    
        parsed = (data >> 0) & ((1u << 1) - 1);
        fprintf(fp, "%s.V = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVC7C0_SET_QMD_VIRTUALIZATION_CONTROL:
    
        parsed = (data >> 0) & ((1u << 8) - 1);
        fprintf(fp, "%s.CONSTANT_BUFFER_MASK = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
    
        parsed = (data >> 8) & ((1u << 1) - 1);
        fprintf(fp, "%s.I2M_ADDR_ENABLE = ", prefix);
        switch (parsed) {
        case NVC7C0_SET_QMD_VIRTUALIZATION_CONTROL_I2M_ADDR_ENABLE_FALSE:
            fprintf(fp, "FALSE\n");
            break;
        case NVC7C0_SET_QMD_VIRTUALIZATION_CONTROL_I2M_ADDR_ENABLE_TRUE:
            fprintf(fp, "TRUE\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
    
        parsed = (data >> 12) & ((1u << 1) - 1);
        fprintf(fp, "%s.I2M_CONSTANT_BUFFER_ENABLE = ", prefix);
        switch (parsed) {
        case NVC7C0_SET_QMD_VIRTUALIZATION_CONTROL_I2M_CONSTANT_BUFFER_ENABLE_FALSE:
            fprintf(fp, "FALSE\n");
            break;
        case NVC7C0_SET_QMD_VIRTUALIZATION_CONTROL_I2M_CONSTANT_BUFFER_ENABLE_TRUE:
            fprintf(fp, "TRUE\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
    
        parsed = (data >> 9) & ((1u << 1) - 1);
        fprintf(fp, "%s.I2M_DEPENDENT_ENABLE = ", prefix);
        switch (parsed) {
        case NVC7C0_SET_QMD_VIRTUALIZATION_CONTROL_I2M_DEPENDENT_ENABLE_FALSE:
            fprintf(fp, "FALSE\n");
            break;
        case NVC7C0_SET_QMD_VIRTUALIZATION_CONTROL_I2M_DEPENDENT_ENABLE_TRUE:
            fprintf(fp, "TRUE\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
    
        parsed = (data >> 16) & ((1u << 1) - 1);
        fprintf(fp, "%s.IQ2M_ADDR_ENABLE = ", prefix);
        switch (parsed) {
        case NVC7C0_SET_QMD_VIRTUALIZATION_CONTROL_IQ2M_ADDR_ENABLE_FALSE:
            fprintf(fp, "FALSE\n");
            break;
        case NVC7C0_SET_QMD_VIRTUALIZATION_CONTROL_IQ2M_ADDR_ENABLE_TRUE:
            fprintf(fp, "TRUE\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
    
        parsed = (data >> 20) & ((1u << 1) - 1);
        fprintf(fp, "%s.IQ2M_CONSTANT_BUFFER_ENABLE = ", prefix);
        switch (parsed) {
        case NVC7C0_SET_QMD_VIRTUALIZATION_CONTROL_IQ2M_CONSTANT_BUFFER_ENABLE_FALSE:
            fprintf(fp, "FALSE\n");
            break;
        case NVC7C0_SET_QMD_VIRTUALIZATION_CONTROL_IQ2M_CONSTANT_BUFFER_ENABLE_TRUE:
            fprintf(fp, "TRUE\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
    
        parsed = (data >> 10) & ((1u << 1) - 1);
        fprintf(fp, "%s.IQ2M_DEPENDENT_ENABLE = ", prefix);
        switch (parsed) {
        case NVC7C0_SET_QMD_VIRTUALIZATION_CONTROL_IQ2M_DEPENDENT_ENABLE_FALSE:
            fprintf(fp, "FALSE\n");
            break;
        case NVC7C0_SET_QMD_VIRTUALIZATION_CONTROL_IQ2M_DEPENDENT_ENABLE_TRUE:
            fprintf(fp, "TRUE\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
    
        parsed = (data >> 24) & ((1u << 1) - 1);
        fprintf(fp, "%s.SEND_PCAS_ENABLE = ", prefix);
        switch (parsed) {
        case NVC7C0_SET_QMD_VIRTUALIZATION_CONTROL_SEND_PCAS_ENABLE_FALSE:
            fprintf(fp, "FALSE\n");
            break;
        case NVC7C0_SET_QMD_VIRTUALIZATION_CONTROL_SEND_PCAS_ENABLE_TRUE:
            fprintf(fp, "TRUE\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
        break;
    case NVC7C0_SET_SHADER_SHARED_MEMORY_WINDOW_A:
    
        parsed = (data >> 0) & ((1u << 17) - 1);
        fprintf(fp, "%s.BASE_ADDRESS_UPPER = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVC7C0_SET_SHADER_SHARED_MEMORY_WINDOW_B:
    
        parsed = data;
        fprintf(fp, "%s.BASE_ADDRESS = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVC7C0_SCG_HYSTERESIS_CONTROL:
    
        parsed = (data >> 0) & ((1u << 1) - 1);
        fprintf(fp, "%s.USE_TIMEOUT_ONCE = ", prefix);
        switch (parsed) {
        case NVC7C0_SCG_HYSTERESIS_CONTROL_USE_TIMEOUT_ONCE_FALSE:
            fprintf(fp, "FALSE\n");
            break;
        case NVC7C0_SCG_HYSTERESIS_CONTROL_USE_TIMEOUT_ONCE_TRUE:
            fprintf(fp, "TRUE\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
    
        parsed = (data >> 1) & ((1u << 1) - 1);
        fprintf(fp, "%s.USE_NULL_TIMEOUT_ONCE = ", prefix);
        switch (parsed) {
        case NVC7C0_SCG_HYSTERESIS_CONTROL_USE_NULL_TIMEOUT_ONCE_FALSE:
            fprintf(fp, "FALSE\n");
            break;
        case NVC7C0_SCG_HYSTERESIS_CONTROL_USE_NULL_TIMEOUT_ONCE_TRUE:
            fprintf(fp, "TRUE\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
        break;
    case NVC7C0_SET_CWD_SLOT_COUNT:
    
        parsed = (data >> 0) & ((1u << 8) - 1);
        fprintf(fp, "%s.V = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVC7C0_SEND_PCAS_A:
    
        parsed = data;
        fprintf(fp, "%s.QMD_ADDRESS_SHIFTED8 = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVC7C0_SEND_PCAS_B:
    
        parsed = (data >> 0) & ((1u << 24) - 1);
        fprintf(fp, "%s.FROM = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
    
        parsed = (data >> 24) & ((1u << 8) - 1);
        fprintf(fp, "%s.DELTA = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVC7C0_SEND_SIGNALING_PCAS_B:
    
        parsed = (data >> 0) & ((1u << 1) - 1);
        fprintf(fp, "%s.INVALIDATE = ", prefix);
        switch (parsed) {
        case NVC7C0_SEND_SIGNALING_PCAS_B_INVALIDATE_FALSE:
            fprintf(fp, "FALSE\n");
            break;
        case NVC7C0_SEND_SIGNALING_PCAS_B_INVALIDATE_TRUE:
            fprintf(fp, "TRUE\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
    
        parsed = (data >> 1) & ((1u << 1) - 1);
        fprintf(fp, "%s.SCHEDULE = ", prefix);
        switch (parsed) {
        case NVC7C0_SEND_SIGNALING_PCAS_B_SCHEDULE_FALSE:
            fprintf(fp, "FALSE\n");
            break;
        case NVC7C0_SEND_SIGNALING_PCAS_B_SCHEDULE_TRUE:
            fprintf(fp, "TRUE\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
        break;
    case NVC7C0_SEND_SIGNALING_PCAS2_B:
    
        parsed = (data >> 0) & ((1u << 4) - 1);
        fprintf(fp, "%s.PCAS_ACTION = ", prefix);
        switch (parsed) {
        case NVC7C0_SEND_SIGNALING_PCAS2_B_PCAS_ACTION_NOP:
            fprintf(fp, "NOP\n");
            break;
        case NVC7C0_SEND_SIGNALING_PCAS2_B_PCAS_ACTION_INVALIDATE:
            fprintf(fp, "INVALIDATE\n");
            break;
        case NVC7C0_SEND_SIGNALING_PCAS2_B_PCAS_ACTION_SCHEDULE:
            fprintf(fp, "SCHEDULE\n");
            break;
        case NVC7C0_SEND_SIGNALING_PCAS2_B_PCAS_ACTION_INVALIDATE_COPY_SCHEDULE:
            fprintf(fp, "INVALIDATE_COPY_SCHEDULE\n");
            break;
        case NVC7C0_SEND_SIGNALING_PCAS2_B_PCAS_ACTION_INCREMENT_PUT:
            fprintf(fp, "INCREMENT_PUT\n");
            break;
        case NVC7C0_SEND_SIGNALING_PCAS2_B_PCAS_ACTION_DECREMENT_DEPENDENCE:
            fprintf(fp, "DECREMENT_DEPENDENCE\n");
            break;
        case NVC7C0_SEND_SIGNALING_PCAS2_B_PCAS_ACTION_PREFETCH:
            fprintf(fp, "PREFETCH\n");
            break;
        case NVC7C0_SEND_SIGNALING_PCAS2_B_PCAS_ACTION_PREFETCH_SCHEDULE:
            fprintf(fp, "PREFETCH_SCHEDULE\n");
            break;
        case NVC7C0_SEND_SIGNALING_PCAS2_B_PCAS_ACTION_INVALIDATE_PREFETCH_COPY_SCHEDULE:
            fprintf(fp, "INVALIDATE_PREFETCH_COPY_SCHEDULE\n");
            break;
        case NVC7C0_SEND_SIGNALING_PCAS2_B_PCAS_ACTION_INVALIDATE_PREFETCH_COPY_FORCE_REQUIRE_SCHEDULING:
            fprintf(fp, "INVALIDATE_PREFETCH_COPY_FORCE_REQUIRE_SCHEDULING\n");
            break;
        case NVC7C0_SEND_SIGNALING_PCAS2_B_PCAS_ACTION_INCREMENT_DEPENDENCE:
            fprintf(fp, "INCREMENT_DEPENDENCE\n");
            break;
        case NVC7C0_SEND_SIGNALING_PCAS2_B_PCAS_ACTION_INCREMENT_CWD_REF_COUNTER:
            fprintf(fp, "INCREMENT_CWD_REF_COUNTER\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
    
        parsed = (data >> 8) & ((1u << 6) - 1);
        fprintf(fp, "%s.SELECT = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
    
        parsed = (data >> 14) & ((1u << 10) - 1);
        fprintf(fp, "%s.OFFSET_MINUS_ONE = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVC7C0_SET_SKED_CACHE_CONTROL:
    
        parsed = (data >> 0) & ((1u << 1) - 1);
        fprintf(fp, "%s.IGNORE_VEID = ", prefix);
        switch (parsed) {
        case NVC7C0_SET_SKED_CACHE_CONTROL_IGNORE_VEID_FALSE:
            fprintf(fp, "FALSE\n");
            break;
        case NVC7C0_SET_SKED_CACHE_CONTROL_IGNORE_VEID_TRUE:
            fprintf(fp, "TRUE\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
        break;
    case NVC7C0_SET_SHADER_LOCAL_MEMORY_NON_THROTTLED_A:
    
        parsed = (data >> 0) & ((1u << 8) - 1);
        fprintf(fp, "%s.SIZE_UPPER = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVC7C0_SET_SHADER_LOCAL_MEMORY_NON_THROTTLED_B:
    
        parsed = data;
        fprintf(fp, "%s.SIZE_LOWER = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVC7C0_SET_SHADER_LOCAL_MEMORY_NON_THROTTLED_C:
    
        parsed = (data >> 0) & ((1u << 9) - 1);
        fprintf(fp, "%s.MAX_SM_COUNT = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVC7C0_SET_SPA_VERSION:
    
        parsed = (data >> 0) & ((1u << 8) - 1);
        fprintf(fp, "%s.MINOR = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
    
        parsed = (data >> 8) & ((1u << 8) - 1);
        fprintf(fp, "%s.MAJOR = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVC7C0_SET_INLINE_QMD_ADDRESS_A:
    
        parsed = data;
        fprintf(fp, "%s.QMD_ADDRESS_SHIFTED8_UPPER = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVC7C0_SET_INLINE_QMD_ADDRESS_B:
    
        parsed = data;
        fprintf(fp, "%s.QMD_ADDRESS_SHIFTED8_LOWER = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVC7C0_LOAD_INLINE_QMD_DATA(0):
    case NVC7C0_LOAD_INLINE_QMD_DATA(1):
    case NVC7C0_LOAD_INLINE_QMD_DATA(2):
    case NVC7C0_LOAD_INLINE_QMD_DATA(3):
    case NVC7C0_LOAD_INLINE_QMD_DATA(4):
    case NVC7C0_LOAD_INLINE_QMD_DATA(5):
    case NVC7C0_LOAD_INLINE_QMD_DATA(6):
    case NVC7C0_LOAD_INLINE_QMD_DATA(7):
    case NVC7C0_LOAD_INLINE_QMD_DATA(8):
    case NVC7C0_LOAD_INLINE_QMD_DATA(9):
    case NVC7C0_LOAD_INLINE_QMD_DATA(10):
    case NVC7C0_LOAD_INLINE_QMD_DATA(11):
    case NVC7C0_LOAD_INLINE_QMD_DATA(12):
    case NVC7C0_LOAD_INLINE_QMD_DATA(13):
    case NVC7C0_LOAD_INLINE_QMD_DATA(14):
    case NVC7C0_LOAD_INLINE_QMD_DATA(15):
    case NVC7C0_LOAD_INLINE_QMD_DATA(16):
    case NVC7C0_LOAD_INLINE_QMD_DATA(17):
    case NVC7C0_LOAD_INLINE_QMD_DATA(18):
    case NVC7C0_LOAD_INLINE_QMD_DATA(19):
    case NVC7C0_LOAD_INLINE_QMD_DATA(20):
    case NVC7C0_LOAD_INLINE_QMD_DATA(21):
    case NVC7C0_LOAD_INLINE_QMD_DATA(22):
    case NVC7C0_LOAD_INLINE_QMD_DATA(23):
    case NVC7C0_LOAD_INLINE_QMD_DATA(24):
    case NVC7C0_LOAD_INLINE_QMD_DATA(25):
    case NVC7C0_LOAD_INLINE_QMD_DATA(26):
    case NVC7C0_LOAD_INLINE_QMD_DATA(27):
    case NVC7C0_LOAD_INLINE_QMD_DATA(28):
    case NVC7C0_LOAD_INLINE_QMD_DATA(29):
    case NVC7C0_LOAD_INLINE_QMD_DATA(30):
    case NVC7C0_LOAD_INLINE_QMD_DATA(31):
    case NVC7C0_LOAD_INLINE_QMD_DATA(32):
    case NVC7C0_LOAD_INLINE_QMD_DATA(33):
    case NVC7C0_LOAD_INLINE_QMD_DATA(34):
    case NVC7C0_LOAD_INLINE_QMD_DATA(35):
    case NVC7C0_LOAD_INLINE_QMD_DATA(36):
    case NVC7C0_LOAD_INLINE_QMD_DATA(37):
    case NVC7C0_LOAD_INLINE_QMD_DATA(38):
    case NVC7C0_LOAD_INLINE_QMD_DATA(39):
    case NVC7C0_LOAD_INLINE_QMD_DATA(40):
    case NVC7C0_LOAD_INLINE_QMD_DATA(41):
    case NVC7C0_LOAD_INLINE_QMD_DATA(42):
    case NVC7C0_LOAD_INLINE_QMD_DATA(43):
    case NVC7C0_LOAD_INLINE_QMD_DATA(44):
    case NVC7C0_LOAD_INLINE_QMD_DATA(45):
    case NVC7C0_LOAD_INLINE_QMD_DATA(46):
    case NVC7C0_LOAD_INLINE_QMD_DATA(47):
    case NVC7C0_LOAD_INLINE_QMD_DATA(48):
    case NVC7C0_LOAD_INLINE_QMD_DATA(49):
    case NVC7C0_LOAD_INLINE_QMD_DATA(50):
    case NVC7C0_LOAD_INLINE_QMD_DATA(51):
    case NVC7C0_LOAD_INLINE_QMD_DATA(52):
    case NVC7C0_LOAD_INLINE_QMD_DATA(53):
    case NVC7C0_LOAD_INLINE_QMD_DATA(54):
    case NVC7C0_LOAD_INLINE_QMD_DATA(55):
    case NVC7C0_LOAD_INLINE_QMD_DATA(56):
    case NVC7C0_LOAD_INLINE_QMD_DATA(57):
    case NVC7C0_LOAD_INLINE_QMD_DATA(58):
    case NVC7C0_LOAD_INLINE_QMD_DATA(59):
    case NVC7C0_LOAD_INLINE_QMD_DATA(60):
    case NVC7C0_LOAD_INLINE_QMD_DATA(61):
    case NVC7C0_LOAD_INLINE_QMD_DATA(62):
    case NVC7C0_LOAD_INLINE_QMD_DATA(63):
    
        parsed = data;
        fprintf(fp, "%s.V = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVC7C0_SET_FALCON00:
    
        parsed = data;
        fprintf(fp, "%s.V = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVC7C0_SET_FALCON01:
    
        parsed = data;
        fprintf(fp, "%s.V = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVC7C0_SET_FALCON02:
    
        parsed = data;
        fprintf(fp, "%s.V = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVC7C0_SET_FALCON03:
    
        parsed = data;
        fprintf(fp, "%s.V = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVC7C0_SET_FALCON04:
    
        parsed = data;
        fprintf(fp, "%s.V = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVC7C0_SET_FALCON05:
    
        parsed = data;
        fprintf(fp, "%s.V = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVC7C0_SET_FALCON06:
    
        parsed = data;
        fprintf(fp, "%s.V = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVC7C0_SET_FALCON07:
    
        parsed = data;
        fprintf(fp, "%s.V = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVC7C0_SET_FALCON08:
    
        parsed = data;
        fprintf(fp, "%s.V = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVC7C0_SET_FALCON09:
    
        parsed = data;
        fprintf(fp, "%s.V = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVC7C0_SET_FALCON10:
    
        parsed = data;
        fprintf(fp, "%s.V = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVC7C0_SET_FALCON11:
    
        parsed = data;
        fprintf(fp, "%s.V = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVC7C0_SET_FALCON12:
    
        parsed = data;
        fprintf(fp, "%s.V = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVC7C0_SET_FALCON13:
    
        parsed = data;
        fprintf(fp, "%s.V = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVC7C0_SET_FALCON14:
    
        parsed = data;
        fprintf(fp, "%s.V = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVC7C0_SET_FALCON15:
    
        parsed = data;
        fprintf(fp, "%s.V = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVC7C0_SET_MME_MEM_ADDRESS_A:
    
        parsed = (data >> 0) & ((1u << 17) - 1);
        fprintf(fp, "%s.UPPER = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVC7C0_SET_MME_MEM_ADDRESS_B:
    
        parsed = data;
        fprintf(fp, "%s.LOWER = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVC7C0_SET_MME_DATA_RAM_ADDRESS:
    
        parsed = data;
        fprintf(fp, "%s.WORD = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVC7C0_MME_DMA_READ:
    
        parsed = data;
        fprintf(fp, "%s.LENGTH = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVC7C0_MME_DMA_READ_FIFOED:
    
        parsed = data;
        fprintf(fp, "%s.LENGTH = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVC7C0_MME_DMA_WRITE:
    
        parsed = data;
        fprintf(fp, "%s.LENGTH = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVC7C0_MME_DMA_REDUCTION:
    
        parsed = (data >> 0) & ((1u << 3) - 1);
        fprintf(fp, "%s.REDUCTION_OP = ", prefix);
        switch (parsed) {
        case NVC7C0_MME_DMA_REDUCTION_REDUCTION_OP_RED_ADD:
            fprintf(fp, "RED_ADD\n");
            break;
        case NVC7C0_MME_DMA_REDUCTION_REDUCTION_OP_RED_MIN:
            fprintf(fp, "RED_MIN\n");
            break;
        case NVC7C0_MME_DMA_REDUCTION_REDUCTION_OP_RED_MAX:
            fprintf(fp, "RED_MAX\n");
            break;
        case NVC7C0_MME_DMA_REDUCTION_REDUCTION_OP_RED_INC:
            fprintf(fp, "RED_INC\n");
            break;
        case NVC7C0_MME_DMA_REDUCTION_REDUCTION_OP_RED_DEC:
            fprintf(fp, "RED_DEC\n");
            break;
        case NVC7C0_MME_DMA_REDUCTION_REDUCTION_OP_RED_AND:
            fprintf(fp, "RED_AND\n");
            break;
        case NVC7C0_MME_DMA_REDUCTION_REDUCTION_OP_RED_OR:
            fprintf(fp, "RED_OR\n");
            break;
        case NVC7C0_MME_DMA_REDUCTION_REDUCTION_OP_RED_XOR:
            fprintf(fp, "RED_XOR\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
    
        parsed = (data >> 4) & ((1u << 2) - 1);
        fprintf(fp, "%s.REDUCTION_FORMAT = ", prefix);
        switch (parsed) {
        case NVC7C0_MME_DMA_REDUCTION_REDUCTION_FORMAT_UNSIGNED:
            fprintf(fp, "UNSIGNED\n");
            break;
        case NVC7C0_MME_DMA_REDUCTION_REDUCTION_FORMAT_SIGNED:
            fprintf(fp, "SIGNED\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
    
        parsed = (data >> 8) & ((1u << 1) - 1);
        fprintf(fp, "%s.REDUCTION_SIZE = ", prefix);
        switch (parsed) {
        case NVC7C0_MME_DMA_REDUCTION_REDUCTION_SIZE_FOUR_BYTES:
            fprintf(fp, "FOUR_BYTES\n");
            break;
        case NVC7C0_MME_DMA_REDUCTION_REDUCTION_SIZE_EIGHT_BYTES:
            fprintf(fp, "EIGHT_BYTES\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
        break;
    case NVC7C0_MME_DMA_SYSMEMBAR:
    
        parsed = (data >> 0) & ((1u << 1) - 1);
        fprintf(fp, "%s.V = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVC7C0_MME_DMA_SYNC:
    
        parsed = data;
        fprintf(fp, "%s.VALUE = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVC7C0_SET_MME_DATA_FIFO_CONFIG:
    
        parsed = (data >> 0) & ((1u << 3) - 1);
        fprintf(fp, "%s.FIFO_SIZE = ", prefix);
        switch (parsed) {
        case NVC7C0_SET_MME_DATA_FIFO_CONFIG_FIFO_SIZE_SIZE_0KB:
            fprintf(fp, "SIZE_0KB\n");
            break;
        case NVC7C0_SET_MME_DATA_FIFO_CONFIG_FIFO_SIZE_SIZE_4KB:
            fprintf(fp, "SIZE_4KB\n");
            break;
        case NVC7C0_SET_MME_DATA_FIFO_CONFIG_FIFO_SIZE_SIZE_8KB:
            fprintf(fp, "SIZE_8KB\n");
            break;
        case NVC7C0_SET_MME_DATA_FIFO_CONFIG_FIFO_SIZE_SIZE_12KB:
            fprintf(fp, "SIZE_12KB\n");
            break;
        case NVC7C0_SET_MME_DATA_FIFO_CONFIG_FIFO_SIZE_SIZE_16KB:
            fprintf(fp, "SIZE_16KB\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
        break;
    case NVC7C0_SET_SHADER_LOCAL_MEMORY_A:
    
        parsed = (data >> 0) & ((1u << 17) - 1);
        fprintf(fp, "%s.ADDRESS_UPPER = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVC7C0_SET_SHADER_LOCAL_MEMORY_B:
    
        parsed = data;
        fprintf(fp, "%s.ADDRESS_LOWER = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVC7C0_SET_SHADER_LOCAL_MEMORY_WINDOW_A:
    
        parsed = (data >> 0) & ((1u << 17) - 1);
        fprintf(fp, "%s.BASE_ADDRESS_UPPER = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVC7C0_SET_SHADER_LOCAL_MEMORY_WINDOW_B:
    
        parsed = data;
        fprintf(fp, "%s.BASE_ADDRESS = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVC7C0_THROTTLE_SM:
    
        parsed = (data >> 0) & ((1u << 1) - 1);
        fprintf(fp, "%s.MULTIPLY_ADD = ", prefix);
        switch (parsed) {
        case NVC7C0_THROTTLE_SM_MULTIPLY_ADD_FALSE:
            fprintf(fp, "FALSE\n");
            break;
        case NVC7C0_THROTTLE_SM_MULTIPLY_ADD_TRUE:
            fprintf(fp, "TRUE\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
        break;
    case NVC7C0_SET_SHADER_CACHE_CONTROL:
    
        parsed = (data >> 0) & ((1u << 1) - 1);
        fprintf(fp, "%s.ICACHE_PREFETCH_ENABLE = ", prefix);
        switch (parsed) {
        case NVC7C0_SET_SHADER_CACHE_CONTROL_ICACHE_PREFETCH_ENABLE_FALSE:
            fprintf(fp, "FALSE\n");
            break;
        case NVC7C0_SET_SHADER_CACHE_CONTROL_ICACHE_PREFETCH_ENABLE_TRUE:
            fprintf(fp, "TRUE\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
        break;
    case NVC7C0_SET_SCG_COMPUTE_SCHEDULING_PARAMETERS(0):
    case NVC7C0_SET_SCG_COMPUTE_SCHEDULING_PARAMETERS(1):
    case NVC7C0_SET_SCG_COMPUTE_SCHEDULING_PARAMETERS(2):
    case NVC7C0_SET_SCG_COMPUTE_SCHEDULING_PARAMETERS(3):
    case NVC7C0_SET_SCG_COMPUTE_SCHEDULING_PARAMETERS(4):
    case NVC7C0_SET_SCG_COMPUTE_SCHEDULING_PARAMETERS(5):
    case NVC7C0_SET_SCG_COMPUTE_SCHEDULING_PARAMETERS(6):
    case NVC7C0_SET_SCG_COMPUTE_SCHEDULING_PARAMETERS(7):
    case NVC7C0_SET_SCG_COMPUTE_SCHEDULING_PARAMETERS(8):
    case NVC7C0_SET_SCG_COMPUTE_SCHEDULING_PARAMETERS(9):
    case NVC7C0_SET_SCG_COMPUTE_SCHEDULING_PARAMETERS(10):
    case NVC7C0_SET_SCG_COMPUTE_SCHEDULING_PARAMETERS(11):
    case NVC7C0_SET_SCG_COMPUTE_SCHEDULING_PARAMETERS(12):
    case NVC7C0_SET_SCG_COMPUTE_SCHEDULING_PARAMETERS(13):
    case NVC7C0_SET_SCG_COMPUTE_SCHEDULING_PARAMETERS(14):
    case NVC7C0_SET_SCG_COMPUTE_SCHEDULING_PARAMETERS(15):
    
        parsed = data;
        fprintf(fp, "%s.V = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVC7C0_SET_SM_TIMEOUT_INTERVAL:
    
        parsed = (data >> 0) & ((1u << 6) - 1);
        fprintf(fp, "%s.COUNTER_BIT = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVC7C0_MME_DMA_WRITE_METHOD_BARRIER:
    
        parsed = (data >> 0) & ((1u << 1) - 1);
        fprintf(fp, "%s.V = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVC7C0_INVALIDATE_TEXTURE_DATA_CACHE_NO_WFI:
    
        parsed = (data >> 0) & ((1u << 1) - 1);
        fprintf(fp, "%s.LINES = ", prefix);
        switch (parsed) {
        case NVC7C0_INVALIDATE_TEXTURE_DATA_CACHE_NO_WFI_LINES_ALL:
            fprintf(fp, "ALL\n");
            break;
        case NVC7C0_INVALIDATE_TEXTURE_DATA_CACHE_NO_WFI_LINES_ONE:
            fprintf(fp, "ONE\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
    
        parsed = (data >> 4) & ((1u << 22) - 1);
        fprintf(fp, "%s.TAG = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVC7C0_ACTIVATE_PERF_SETTINGS_FOR_COMPUTE_CONTEXT:
    
        parsed = (data >> 0) & ((1u << 1) - 1);
        fprintf(fp, "%s.ALL = ", prefix);
        switch (parsed) {
        case NVC7C0_ACTIVATE_PERF_SETTINGS_FOR_COMPUTE_CONTEXT_ALL_FALSE:
            fprintf(fp, "FALSE\n");
            break;
        case NVC7C0_ACTIVATE_PERF_SETTINGS_FOR_COMPUTE_CONTEXT_ALL_TRUE:
            fprintf(fp, "TRUE\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
        break;
    case NVC7C0_INVALIDATE_SAMPLER_CACHE:
    
        parsed = (data >> 0) & ((1u << 1) - 1);
        fprintf(fp, "%s.LINES = ", prefix);
        switch (parsed) {
        case NVC7C0_INVALIDATE_SAMPLER_CACHE_LINES_ALL:
            fprintf(fp, "ALL\n");
            break;
        case NVC7C0_INVALIDATE_SAMPLER_CACHE_LINES_ONE:
            fprintf(fp, "ONE\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
    
        parsed = (data >> 4) & ((1u << 22) - 1);
        fprintf(fp, "%s.TAG = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVC7C0_INVALIDATE_TEXTURE_HEADER_CACHE:
    
        parsed = (data >> 0) & ((1u << 1) - 1);
        fprintf(fp, "%s.LINES = ", prefix);
        switch (parsed) {
        case NVC7C0_INVALIDATE_TEXTURE_HEADER_CACHE_LINES_ALL:
            fprintf(fp, "ALL\n");
            break;
        case NVC7C0_INVALIDATE_TEXTURE_HEADER_CACHE_LINES_ONE:
            fprintf(fp, "ONE\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
    
        parsed = (data >> 4) & ((1u << 22) - 1);
        fprintf(fp, "%s.TAG = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVC7C0_INVALIDATE_TEXTURE_DATA_CACHE:
    
        parsed = (data >> 0) & ((1u << 1) - 1);
        fprintf(fp, "%s.LINES = ", prefix);
        switch (parsed) {
        case NVC7C0_INVALIDATE_TEXTURE_DATA_CACHE_LINES_ALL:
            fprintf(fp, "ALL\n");
            break;
        case NVC7C0_INVALIDATE_TEXTURE_DATA_CACHE_LINES_ONE:
            fprintf(fp, "ONE\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
    
        parsed = (data >> 4) & ((1u << 22) - 1);
        fprintf(fp, "%s.TAG = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVC7C0_INVALIDATE_SAMPLER_CACHE_NO_WFI:
    
        parsed = (data >> 0) & ((1u << 1) - 1);
        fprintf(fp, "%s.LINES = ", prefix);
        switch (parsed) {
        case NVC7C0_INVALIDATE_SAMPLER_CACHE_NO_WFI_LINES_ALL:
            fprintf(fp, "ALL\n");
            break;
        case NVC7C0_INVALIDATE_SAMPLER_CACHE_NO_WFI_LINES_ONE:
            fprintf(fp, "ONE\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
    
        parsed = (data >> 4) & ((1u << 22) - 1);
        fprintf(fp, "%s.TAG = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVC7C0_SET_SHADER_EXCEPTIONS:
    
        parsed = (data >> 0) & ((1u << 1) - 1);
        fprintf(fp, "%s.ENABLE = ", prefix);
        switch (parsed) {
        case NVC7C0_SET_SHADER_EXCEPTIONS_ENABLE_FALSE:
            fprintf(fp, "FALSE\n");
            break;
        case NVC7C0_SET_SHADER_EXCEPTIONS_ENABLE_TRUE:
            fprintf(fp, "TRUE\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
        break;
    case NVC7C0_SET_RENDER_ENABLE_A:
    
        parsed = (data >> 0) & ((1u << 8) - 1);
        fprintf(fp, "%s.OFFSET_UPPER = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVC7C0_SET_RENDER_ENABLE_B:
    
        parsed = data;
        fprintf(fp, "%s.OFFSET_LOWER = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVC7C0_SET_RENDER_ENABLE_C:
    
        parsed = (data >> 0) & ((1u << 3) - 1);
        fprintf(fp, "%s.MODE = ", prefix);
        switch (parsed) {
        case NVC7C0_SET_RENDER_ENABLE_C_MODE_FALSE:
            fprintf(fp, "FALSE\n");
            break;
        case NVC7C0_SET_RENDER_ENABLE_C_MODE_TRUE:
            fprintf(fp, "TRUE\n");
            break;
        case NVC7C0_SET_RENDER_ENABLE_C_MODE_CONDITIONAL:
            fprintf(fp, "CONDITIONAL\n");
            break;
        case NVC7C0_SET_RENDER_ENABLE_C_MODE_RENDER_IF_EQUAL:
            fprintf(fp, "RENDER_IF_EQUAL\n");
            break;
        case NVC7C0_SET_RENDER_ENABLE_C_MODE_RENDER_IF_NOT_EQUAL:
            fprintf(fp, "RENDER_IF_NOT_EQUAL\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
        break;
    case NVC7C0_SET_TEX_SAMPLER_POOL_A:
    
        parsed = (data >> 0) & ((1u << 17) - 1);
        fprintf(fp, "%s.OFFSET_UPPER = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVC7C0_SET_TEX_SAMPLER_POOL_B:
    
        parsed = data;
        fprintf(fp, "%s.OFFSET_LOWER = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVC7C0_SET_TEX_SAMPLER_POOL_C:
    
        parsed = (data >> 0) & ((1u << 20) - 1);
        fprintf(fp, "%s.MAXIMUM_INDEX = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVC7C0_SET_TEX_HEADER_POOL_A:
    
        parsed = (data >> 0) & ((1u << 17) - 1);
        fprintf(fp, "%s.OFFSET_UPPER = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVC7C0_SET_TEX_HEADER_POOL_B:
    
        parsed = data;
        fprintf(fp, "%s.OFFSET_LOWER = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVC7C0_SET_TEX_HEADER_POOL_C:
    
        parsed = (data >> 0) & ((1u << 22) - 1);
        fprintf(fp, "%s.MAXIMUM_INDEX = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVC7C0_INVALIDATE_SHADER_CACHES_NO_WFI:
    
        parsed = (data >> 0) & ((1u << 1) - 1);
        fprintf(fp, "%s.INSTRUCTION = ", prefix);
        switch (parsed) {
        case NVC7C0_INVALIDATE_SHADER_CACHES_NO_WFI_INSTRUCTION_FALSE:
            fprintf(fp, "FALSE\n");
            break;
        case NVC7C0_INVALIDATE_SHADER_CACHES_NO_WFI_INSTRUCTION_TRUE:
            fprintf(fp, "TRUE\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
    
        parsed = (data >> 4) & ((1u << 1) - 1);
        fprintf(fp, "%s.GLOBAL_DATA = ", prefix);
        switch (parsed) {
        case NVC7C0_INVALIDATE_SHADER_CACHES_NO_WFI_GLOBAL_DATA_FALSE:
            fprintf(fp, "FALSE\n");
            break;
        case NVC7C0_INVALIDATE_SHADER_CACHES_NO_WFI_GLOBAL_DATA_TRUE:
            fprintf(fp, "TRUE\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
    
        parsed = (data >> 12) & ((1u << 1) - 1);
        fprintf(fp, "%s.CONSTANT = ", prefix);
        switch (parsed) {
        case NVC7C0_INVALIDATE_SHADER_CACHES_NO_WFI_CONSTANT_FALSE:
            fprintf(fp, "FALSE\n");
            break;
        case NVC7C0_INVALIDATE_SHADER_CACHES_NO_WFI_CONSTANT_TRUE:
            fprintf(fp, "TRUE\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
        break;
    case NVC7C0_SET_RENDER_ENABLE_OVERRIDE:
    
        parsed = (data >> 0) & ((1u << 2) - 1);
        fprintf(fp, "%s.MODE = ", prefix);
        switch (parsed) {
        case NVC7C0_SET_RENDER_ENABLE_OVERRIDE_MODE_USE_RENDER_ENABLE:
            fprintf(fp, "USE_RENDER_ENABLE\n");
            break;
        case NVC7C0_SET_RENDER_ENABLE_OVERRIDE_MODE_ALWAYS_RENDER:
            fprintf(fp, "ALWAYS_RENDER\n");
            break;
        case NVC7C0_SET_RENDER_ENABLE_OVERRIDE_MODE_NEVER_RENDER:
            fprintf(fp, "NEVER_RENDER\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
        break;
    case NVC7C0_PIPE_NOP:
    
        parsed = data;
        fprintf(fp, "%s.V = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVC7C0_SET_SPARE00:
    
        parsed = data;
        fprintf(fp, "%s.V = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVC7C0_SET_SPARE01:
    
        parsed = data;
        fprintf(fp, "%s.V = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVC7C0_SET_SPARE02:
    
        parsed = data;
        fprintf(fp, "%s.V = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVC7C0_SET_SPARE03:
    
        parsed = data;
        fprintf(fp, "%s.V = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVC7C0_SET_REPORT_SEMAPHORE_A:
    
        parsed = (data >> 0) & ((1u << 8) - 1);
        fprintf(fp, "%s.OFFSET_UPPER = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVC7C0_SET_REPORT_SEMAPHORE_B:
    
        parsed = data;
        fprintf(fp, "%s.OFFSET_LOWER = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVC7C0_SET_REPORT_SEMAPHORE_C:
    
        parsed = data;
        fprintf(fp, "%s.PAYLOAD = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVC7C0_SET_REPORT_SEMAPHORE_D:
    
        parsed = (data >> 0) & ((1u << 2) - 1);
        fprintf(fp, "%s.OPERATION = ", prefix);
        switch (parsed) {
        case NVC7C0_SET_REPORT_SEMAPHORE_D_OPERATION_RELEASE:
            fprintf(fp, "RELEASE\n");
            break;
        case NVC7C0_SET_REPORT_SEMAPHORE_D_OPERATION_TRAP:
            fprintf(fp, "TRAP\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
    
        parsed = (data >> 20) & ((1u << 1) - 1);
        fprintf(fp, "%s.AWAKEN_ENABLE = ", prefix);
        switch (parsed) {
        case NVC7C0_SET_REPORT_SEMAPHORE_D_AWAKEN_ENABLE_FALSE:
            fprintf(fp, "FALSE\n");
            break;
        case NVC7C0_SET_REPORT_SEMAPHORE_D_AWAKEN_ENABLE_TRUE:
            fprintf(fp, "TRUE\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
    
        parsed = (data >> 28) & ((1u << 1) - 1);
        fprintf(fp, "%s.STRUCTURE_SIZE = ", prefix);
        switch (parsed) {
        case NVC7C0_SET_REPORT_SEMAPHORE_D_STRUCTURE_SIZE_FOUR_WORDS:
            fprintf(fp, "FOUR_WORDS\n");
            break;
        case NVC7C0_SET_REPORT_SEMAPHORE_D_STRUCTURE_SIZE_ONE_WORD:
            fprintf(fp, "ONE_WORD\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
    
        parsed = (data >> 2) & ((1u << 1) - 1);
        fprintf(fp, "%s.FLUSH_DISABLE = ", prefix);
        switch (parsed) {
        case NVC7C0_SET_REPORT_SEMAPHORE_D_FLUSH_DISABLE_FALSE:
            fprintf(fp, "FALSE\n");
            break;
        case NVC7C0_SET_REPORT_SEMAPHORE_D_FLUSH_DISABLE_TRUE:
            fprintf(fp, "TRUE\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
    
        parsed = (data >> 3) & ((1u << 1) - 1);
        fprintf(fp, "%s.REDUCTION_ENABLE = ", prefix);
        switch (parsed) {
        case NVC7C0_SET_REPORT_SEMAPHORE_D_REDUCTION_ENABLE_FALSE:
            fprintf(fp, "FALSE\n");
            break;
        case NVC7C0_SET_REPORT_SEMAPHORE_D_REDUCTION_ENABLE_TRUE:
            fprintf(fp, "TRUE\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
    
        parsed = (data >> 9) & ((1u << 3) - 1);
        fprintf(fp, "%s.REDUCTION_OP = ", prefix);
        switch (parsed) {
        case NVC7C0_SET_REPORT_SEMAPHORE_D_REDUCTION_OP_RED_ADD:
            fprintf(fp, "RED_ADD\n");
            break;
        case NVC7C0_SET_REPORT_SEMAPHORE_D_REDUCTION_OP_RED_MIN:
            fprintf(fp, "RED_MIN\n");
            break;
        case NVC7C0_SET_REPORT_SEMAPHORE_D_REDUCTION_OP_RED_MAX:
            fprintf(fp, "RED_MAX\n");
            break;
        case NVC7C0_SET_REPORT_SEMAPHORE_D_REDUCTION_OP_RED_INC:
            fprintf(fp, "RED_INC\n");
            break;
        case NVC7C0_SET_REPORT_SEMAPHORE_D_REDUCTION_OP_RED_DEC:
            fprintf(fp, "RED_DEC\n");
            break;
        case NVC7C0_SET_REPORT_SEMAPHORE_D_REDUCTION_OP_RED_AND:
            fprintf(fp, "RED_AND\n");
            break;
        case NVC7C0_SET_REPORT_SEMAPHORE_D_REDUCTION_OP_RED_OR:
            fprintf(fp, "RED_OR\n");
            break;
        case NVC7C0_SET_REPORT_SEMAPHORE_D_REDUCTION_OP_RED_XOR:
            fprintf(fp, "RED_XOR\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
    
        parsed = (data >> 17) & ((1u << 2) - 1);
        fprintf(fp, "%s.REDUCTION_FORMAT = ", prefix);
        switch (parsed) {
        case NVC7C0_SET_REPORT_SEMAPHORE_D_REDUCTION_FORMAT_UNSIGNED_32:
            fprintf(fp, "UNSIGNED_32\n");
            break;
        case NVC7C0_SET_REPORT_SEMAPHORE_D_REDUCTION_FORMAT_SIGNED_32:
            fprintf(fp, "SIGNED_32\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
    
        parsed = (data >> 19) & ((1u << 1) - 1);
        fprintf(fp, "%s.CONDITIONAL_TRAP = ", prefix);
        switch (parsed) {
        case NVC7C0_SET_REPORT_SEMAPHORE_D_CONDITIONAL_TRAP_FALSE:
            fprintf(fp, "FALSE\n");
            break;
        case NVC7C0_SET_REPORT_SEMAPHORE_D_CONDITIONAL_TRAP_TRUE:
            fprintf(fp, "TRUE\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
        break;
    case NVC7C0_SET_TRAP_HANDLER_A:
    
        parsed = (data >> 0) & ((1u << 17) - 1);
        fprintf(fp, "%s.ADDRESS_UPPER = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVC7C0_SET_TRAP_HANDLER_B:
    
        parsed = data;
        fprintf(fp, "%s.ADDRESS_LOWER = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVC7C0_SET_BINDLESS_TEXTURE:
    
        parsed = (data >> 0) & ((1u << 3) - 1);
        fprintf(fp, "%s.CONSTANT_BUFFER_SLOT_SELECT = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVC7C0_SET_SHADER_PERFORMANCE_SNAPSHOT_COUNTER_VALUE(0):
    case NVC7C0_SET_SHADER_PERFORMANCE_SNAPSHOT_COUNTER_VALUE(1):
    case NVC7C0_SET_SHADER_PERFORMANCE_SNAPSHOT_COUNTER_VALUE(2):
    case NVC7C0_SET_SHADER_PERFORMANCE_SNAPSHOT_COUNTER_VALUE(3):
    case NVC7C0_SET_SHADER_PERFORMANCE_SNAPSHOT_COUNTER_VALUE(4):
    case NVC7C0_SET_SHADER_PERFORMANCE_SNAPSHOT_COUNTER_VALUE(5):
    case NVC7C0_SET_SHADER_PERFORMANCE_SNAPSHOT_COUNTER_VALUE(6):
    case NVC7C0_SET_SHADER_PERFORMANCE_SNAPSHOT_COUNTER_VALUE(7):
    
        parsed = data;
        fprintf(fp, "%s.V = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVC7C0_SET_SHADER_PERFORMANCE_SNAPSHOT_COUNTER_VALUE_UPPER(0):
    case NVC7C0_SET_SHADER_PERFORMANCE_SNAPSHOT_COUNTER_VALUE_UPPER(1):
    case NVC7C0_SET_SHADER_PERFORMANCE_SNAPSHOT_COUNTER_VALUE_UPPER(2):
    case NVC7C0_SET_SHADER_PERFORMANCE_SNAPSHOT_COUNTER_VALUE_UPPER(3):
    case NVC7C0_SET_SHADER_PERFORMANCE_SNAPSHOT_COUNTER_VALUE_UPPER(4):
    case NVC7C0_SET_SHADER_PERFORMANCE_SNAPSHOT_COUNTER_VALUE_UPPER(5):
    case NVC7C0_SET_SHADER_PERFORMANCE_SNAPSHOT_COUNTER_VALUE_UPPER(6):
    case NVC7C0_SET_SHADER_PERFORMANCE_SNAPSHOT_COUNTER_VALUE_UPPER(7):
    
        parsed = data;
        fprintf(fp, "%s.V = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVC7C0_ENABLE_SHADER_PERFORMANCE_SNAPSHOT_COUNTER:
    
        parsed = (data >> 0) & ((1u << 1) - 1);
        fprintf(fp, "%s.V = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVC7C0_DISABLE_SHADER_PERFORMANCE_SNAPSHOT_COUNTER:
    
        parsed = (data >> 0) & ((1u << 1) - 1);
        fprintf(fp, "%s.V = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVC7C0_SET_SHADER_PERFORMANCE_COUNTER_VALUE_UPPER(0):
    case NVC7C0_SET_SHADER_PERFORMANCE_COUNTER_VALUE_UPPER(1):
    case NVC7C0_SET_SHADER_PERFORMANCE_COUNTER_VALUE_UPPER(2):
    case NVC7C0_SET_SHADER_PERFORMANCE_COUNTER_VALUE_UPPER(3):
    case NVC7C0_SET_SHADER_PERFORMANCE_COUNTER_VALUE_UPPER(4):
    case NVC7C0_SET_SHADER_PERFORMANCE_COUNTER_VALUE_UPPER(5):
    case NVC7C0_SET_SHADER_PERFORMANCE_COUNTER_VALUE_UPPER(6):
    case NVC7C0_SET_SHADER_PERFORMANCE_COUNTER_VALUE_UPPER(7):
    
        parsed = data;
        fprintf(fp, "%s.V = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVC7C0_SET_SHADER_PERFORMANCE_COUNTER_VALUE(0):
    case NVC7C0_SET_SHADER_PERFORMANCE_COUNTER_VALUE(1):
    case NVC7C0_SET_SHADER_PERFORMANCE_COUNTER_VALUE(2):
    case NVC7C0_SET_SHADER_PERFORMANCE_COUNTER_VALUE(3):
    case NVC7C0_SET_SHADER_PERFORMANCE_COUNTER_VALUE(4):
    case NVC7C0_SET_SHADER_PERFORMANCE_COUNTER_VALUE(5):
    case NVC7C0_SET_SHADER_PERFORMANCE_COUNTER_VALUE(6):
    case NVC7C0_SET_SHADER_PERFORMANCE_COUNTER_VALUE(7):
    
        parsed = data;
        fprintf(fp, "%s.V = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVC7C0_SET_SHADER_PERFORMANCE_COUNTER_EVENT(0):
    case NVC7C0_SET_SHADER_PERFORMANCE_COUNTER_EVENT(1):
    case NVC7C0_SET_SHADER_PERFORMANCE_COUNTER_EVENT(2):
    case NVC7C0_SET_SHADER_PERFORMANCE_COUNTER_EVENT(3):
    case NVC7C0_SET_SHADER_PERFORMANCE_COUNTER_EVENT(4):
    case NVC7C0_SET_SHADER_PERFORMANCE_COUNTER_EVENT(5):
    case NVC7C0_SET_SHADER_PERFORMANCE_COUNTER_EVENT(6):
    case NVC7C0_SET_SHADER_PERFORMANCE_COUNTER_EVENT(7):
    
        parsed = (data >> 0) & ((1u << 8) - 1);
        fprintf(fp, "%s.EVENT = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVC7C0_SET_SHADER_PERFORMANCE_COUNTER_CONTROL_A(0):
    case NVC7C0_SET_SHADER_PERFORMANCE_COUNTER_CONTROL_A(1):
    case NVC7C0_SET_SHADER_PERFORMANCE_COUNTER_CONTROL_A(2):
    case NVC7C0_SET_SHADER_PERFORMANCE_COUNTER_CONTROL_A(3):
    case NVC7C0_SET_SHADER_PERFORMANCE_COUNTER_CONTROL_A(4):
    case NVC7C0_SET_SHADER_PERFORMANCE_COUNTER_CONTROL_A(5):
    case NVC7C0_SET_SHADER_PERFORMANCE_COUNTER_CONTROL_A(6):
    case NVC7C0_SET_SHADER_PERFORMANCE_COUNTER_CONTROL_A(7):
    
        parsed = (data >> 0) & ((1u << 2) - 1);
        fprintf(fp, "%s.EVENT0 = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
    
        parsed = (data >> 2) & ((1u << 3) - 1);
        fprintf(fp, "%s.BIT_SELECT0 = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
    
        parsed = (data >> 5) & ((1u << 2) - 1);
        fprintf(fp, "%s.EVENT1 = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
    
        parsed = (data >> 7) & ((1u << 3) - 1);
        fprintf(fp, "%s.BIT_SELECT1 = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
    
        parsed = (data >> 10) & ((1u << 2) - 1);
        fprintf(fp, "%s.EVENT2 = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
    
        parsed = (data >> 12) & ((1u << 3) - 1);
        fprintf(fp, "%s.BIT_SELECT2 = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
    
        parsed = (data >> 15) & ((1u << 2) - 1);
        fprintf(fp, "%s.EVENT3 = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
    
        parsed = (data >> 17) & ((1u << 3) - 1);
        fprintf(fp, "%s.BIT_SELECT3 = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
    
        parsed = (data >> 20) & ((1u << 2) - 1);
        fprintf(fp, "%s.EVENT4 = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
    
        parsed = (data >> 22) & ((1u << 3) - 1);
        fprintf(fp, "%s.BIT_SELECT4 = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
    
        parsed = (data >> 25) & ((1u << 2) - 1);
        fprintf(fp, "%s.EVENT5 = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
    
        parsed = (data >> 27) & ((1u << 3) - 1);
        fprintf(fp, "%s.BIT_SELECT5 = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
    
        parsed = (data >> 30) & ((1u << 2) - 1);
        fprintf(fp, "%s.SPARE = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVC7C0_SET_SHADER_PERFORMANCE_COUNTER_CONTROL_B(0):
    case NVC7C0_SET_SHADER_PERFORMANCE_COUNTER_CONTROL_B(1):
    case NVC7C0_SET_SHADER_PERFORMANCE_COUNTER_CONTROL_B(2):
    case NVC7C0_SET_SHADER_PERFORMANCE_COUNTER_CONTROL_B(3):
    case NVC7C0_SET_SHADER_PERFORMANCE_COUNTER_CONTROL_B(4):
    case NVC7C0_SET_SHADER_PERFORMANCE_COUNTER_CONTROL_B(5):
    case NVC7C0_SET_SHADER_PERFORMANCE_COUNTER_CONTROL_B(6):
    case NVC7C0_SET_SHADER_PERFORMANCE_COUNTER_CONTROL_B(7):
    
        parsed = (data >> 0) & ((1u << 1) - 1);
        fprintf(fp, "%s.EDGE = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
    
        parsed = (data >> 1) & ((1u << 2) - 1);
        fprintf(fp, "%s.MODE = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
    
        parsed = (data >> 3) & ((1u << 1) - 1);
        fprintf(fp, "%s.WINDOWED = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
    
        parsed = (data >> 4) & ((1u << 16) - 1);
        fprintf(fp, "%s.FUNC = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVC7C0_SET_SHADER_PERFORMANCE_COUNTER_TRAP_CONTROL:
    
        parsed = (data >> 0) & ((1u << 8) - 1);
        fprintf(fp, "%s.MASK = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVC7C0_START_SHADER_PERFORMANCE_COUNTER:
    
        parsed = (data >> 0) & ((1u << 8) - 1);
        fprintf(fp, "%s.COUNTER_MASK = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVC7C0_STOP_SHADER_PERFORMANCE_COUNTER:
    
        parsed = (data >> 0) & ((1u << 8) - 1);
        fprintf(fp, "%s.COUNTER_MASK = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVC7C0_SET_SHADER_PERFORMANCE_COUNTER_SCTL_FILTER:
    
        parsed = data;
        fprintf(fp, "%s.V = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVC7C0_SET_SHADER_PERFORMANCE_COUNTER_CORE_MIO_FILTER:
    
        parsed = data;
        fprintf(fp, "%s.V = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVC7C0_SET_MME_SHADOW_SCRATCH(0):
    case NVC7C0_SET_MME_SHADOW_SCRATCH(1):
    case NVC7C0_SET_MME_SHADOW_SCRATCH(2):
    case NVC7C0_SET_MME_SHADOW_SCRATCH(3):
    case NVC7C0_SET_MME_SHADOW_SCRATCH(4):
    case NVC7C0_SET_MME_SHADOW_SCRATCH(5):
    case NVC7C0_SET_MME_SHADOW_SCRATCH(6):
    case NVC7C0_SET_MME_SHADOW_SCRATCH(7):
    case NVC7C0_SET_MME_SHADOW_SCRATCH(8):
    case NVC7C0_SET_MME_SHADOW_SCRATCH(9):
    case NVC7C0_SET_MME_SHADOW_SCRATCH(10):
    case NVC7C0_SET_MME_SHADOW_SCRATCH(11):
    case NVC7C0_SET_MME_SHADOW_SCRATCH(12):
    case NVC7C0_SET_MME_SHADOW_SCRATCH(13):
    case NVC7C0_SET_MME_SHADOW_SCRATCH(14):
    case NVC7C0_SET_MME_SHADOW_SCRATCH(15):
    case NVC7C0_SET_MME_SHADOW_SCRATCH(16):
    case NVC7C0_SET_MME_SHADOW_SCRATCH(17):
    case NVC7C0_SET_MME_SHADOW_SCRATCH(18):
    case NVC7C0_SET_MME_SHADOW_SCRATCH(19):
    case NVC7C0_SET_MME_SHADOW_SCRATCH(20):
    case NVC7C0_SET_MME_SHADOW_SCRATCH(21):
    case NVC7C0_SET_MME_SHADOW_SCRATCH(22):
    case NVC7C0_SET_MME_SHADOW_SCRATCH(23):
    case NVC7C0_SET_MME_SHADOW_SCRATCH(24):
    case NVC7C0_SET_MME_SHADOW_SCRATCH(25):
    case NVC7C0_SET_MME_SHADOW_SCRATCH(26):
    case NVC7C0_SET_MME_SHADOW_SCRATCH(27):
    case NVC7C0_SET_MME_SHADOW_SCRATCH(28):
    case NVC7C0_SET_MME_SHADOW_SCRATCH(29):
    case NVC7C0_SET_MME_SHADOW_SCRATCH(30):
    case NVC7C0_SET_MME_SHADOW_SCRATCH(31):
    case NVC7C0_SET_MME_SHADOW_SCRATCH(32):
    case NVC7C0_SET_MME_SHADOW_SCRATCH(33):
    case NVC7C0_SET_MME_SHADOW_SCRATCH(34):
    case NVC7C0_SET_MME_SHADOW_SCRATCH(35):
    case NVC7C0_SET_MME_SHADOW_SCRATCH(36):
    case NVC7C0_SET_MME_SHADOW_SCRATCH(37):
    case NVC7C0_SET_MME_SHADOW_SCRATCH(38):
    case NVC7C0_SET_MME_SHADOW_SCRATCH(39):
    case NVC7C0_SET_MME_SHADOW_SCRATCH(40):
    case NVC7C0_SET_MME_SHADOW_SCRATCH(41):
    case NVC7C0_SET_MME_SHADOW_SCRATCH(42):
    case NVC7C0_SET_MME_SHADOW_SCRATCH(43):
    case NVC7C0_SET_MME_SHADOW_SCRATCH(44):
    case NVC7C0_SET_MME_SHADOW_SCRATCH(45):
    case NVC7C0_SET_MME_SHADOW_SCRATCH(46):
    case NVC7C0_SET_MME_SHADOW_SCRATCH(47):
    case NVC7C0_SET_MME_SHADOW_SCRATCH(48):
    case NVC7C0_SET_MME_SHADOW_SCRATCH(49):
    case NVC7C0_SET_MME_SHADOW_SCRATCH(50):
    case NVC7C0_SET_MME_SHADOW_SCRATCH(51):
    case NVC7C0_SET_MME_SHADOW_SCRATCH(52):
    case NVC7C0_SET_MME_SHADOW_SCRATCH(53):
    case NVC7C0_SET_MME_SHADOW_SCRATCH(54):
    case NVC7C0_SET_MME_SHADOW_SCRATCH(55):
    case NVC7C0_SET_MME_SHADOW_SCRATCH(56):
    case NVC7C0_SET_MME_SHADOW_SCRATCH(57):
    case NVC7C0_SET_MME_SHADOW_SCRATCH(58):
    case NVC7C0_SET_MME_SHADOW_SCRATCH(59):
    case NVC7C0_SET_MME_SHADOW_SCRATCH(60):
    case NVC7C0_SET_MME_SHADOW_SCRATCH(61):
    case NVC7C0_SET_MME_SHADOW_SCRATCH(62):
    case NVC7C0_SET_MME_SHADOW_SCRATCH(63):
    case NVC7C0_SET_MME_SHADOW_SCRATCH(64):
    case NVC7C0_SET_MME_SHADOW_SCRATCH(65):
    case NVC7C0_SET_MME_SHADOW_SCRATCH(66):
    case NVC7C0_SET_MME_SHADOW_SCRATCH(67):
    case NVC7C0_SET_MME_SHADOW_SCRATCH(68):
    case NVC7C0_SET_MME_SHADOW_SCRATCH(69):
    case NVC7C0_SET_MME_SHADOW_SCRATCH(70):
    case NVC7C0_SET_MME_SHADOW_SCRATCH(71):
    case NVC7C0_SET_MME_SHADOW_SCRATCH(72):
    case NVC7C0_SET_MME_SHADOW_SCRATCH(73):
    case NVC7C0_SET_MME_SHADOW_SCRATCH(74):
    case NVC7C0_SET_MME_SHADOW_SCRATCH(75):
    case NVC7C0_SET_MME_SHADOW_SCRATCH(76):
    case NVC7C0_SET_MME_SHADOW_SCRATCH(77):
    case NVC7C0_SET_MME_SHADOW_SCRATCH(78):
    case NVC7C0_SET_MME_SHADOW_SCRATCH(79):
    case NVC7C0_SET_MME_SHADOW_SCRATCH(80):
    case NVC7C0_SET_MME_SHADOW_SCRATCH(81):
    case NVC7C0_SET_MME_SHADOW_SCRATCH(82):
    case NVC7C0_SET_MME_SHADOW_SCRATCH(83):
    case NVC7C0_SET_MME_SHADOW_SCRATCH(84):
    case NVC7C0_SET_MME_SHADOW_SCRATCH(85):
    case NVC7C0_SET_MME_SHADOW_SCRATCH(86):
    case NVC7C0_SET_MME_SHADOW_SCRATCH(87):
    case NVC7C0_SET_MME_SHADOW_SCRATCH(88):
    case NVC7C0_SET_MME_SHADOW_SCRATCH(89):
    case NVC7C0_SET_MME_SHADOW_SCRATCH(90):
    case NVC7C0_SET_MME_SHADOW_SCRATCH(91):
    case NVC7C0_SET_MME_SHADOW_SCRATCH(92):
    case NVC7C0_SET_MME_SHADOW_SCRATCH(93):
    case NVC7C0_SET_MME_SHADOW_SCRATCH(94):
    case NVC7C0_SET_MME_SHADOW_SCRATCH(95):
    case NVC7C0_SET_MME_SHADOW_SCRATCH(96):
    case NVC7C0_SET_MME_SHADOW_SCRATCH(97):
    case NVC7C0_SET_MME_SHADOW_SCRATCH(98):
    case NVC7C0_SET_MME_SHADOW_SCRATCH(99):
    case NVC7C0_SET_MME_SHADOW_SCRATCH(100):
    case NVC7C0_SET_MME_SHADOW_SCRATCH(101):
    case NVC7C0_SET_MME_SHADOW_SCRATCH(102):
    case NVC7C0_SET_MME_SHADOW_SCRATCH(103):
    case NVC7C0_SET_MME_SHADOW_SCRATCH(104):
    case NVC7C0_SET_MME_SHADOW_SCRATCH(105):
    case NVC7C0_SET_MME_SHADOW_SCRATCH(106):
    case NVC7C0_SET_MME_SHADOW_SCRATCH(107):
    case NVC7C0_SET_MME_SHADOW_SCRATCH(108):
    case NVC7C0_SET_MME_SHADOW_SCRATCH(109):
    case NVC7C0_SET_MME_SHADOW_SCRATCH(110):
    case NVC7C0_SET_MME_SHADOW_SCRATCH(111):
    case NVC7C0_SET_MME_SHADOW_SCRATCH(112):
    case NVC7C0_SET_MME_SHADOW_SCRATCH(113):
    case NVC7C0_SET_MME_SHADOW_SCRATCH(114):
    case NVC7C0_SET_MME_SHADOW_SCRATCH(115):
    case NVC7C0_SET_MME_SHADOW_SCRATCH(116):
    case NVC7C0_SET_MME_SHADOW_SCRATCH(117):
    case NVC7C0_SET_MME_SHADOW_SCRATCH(118):
    case NVC7C0_SET_MME_SHADOW_SCRATCH(119):
    case NVC7C0_SET_MME_SHADOW_SCRATCH(120):
    case NVC7C0_SET_MME_SHADOW_SCRATCH(121):
    case NVC7C0_SET_MME_SHADOW_SCRATCH(122):
    case NVC7C0_SET_MME_SHADOW_SCRATCH(123):
    case NVC7C0_SET_MME_SHADOW_SCRATCH(124):
    case NVC7C0_SET_MME_SHADOW_SCRATCH(125):
    case NVC7C0_SET_MME_SHADOW_SCRATCH(126):
    case NVC7C0_SET_MME_SHADOW_SCRATCH(127):
    case NVC7C0_SET_MME_SHADOW_SCRATCH(128):
    case NVC7C0_SET_MME_SHADOW_SCRATCH(129):
    case NVC7C0_SET_MME_SHADOW_SCRATCH(130):
    case NVC7C0_SET_MME_SHADOW_SCRATCH(131):
    case NVC7C0_SET_MME_SHADOW_SCRATCH(132):
    case NVC7C0_SET_MME_SHADOW_SCRATCH(133):
    case NVC7C0_SET_MME_SHADOW_SCRATCH(134):
    case NVC7C0_SET_MME_SHADOW_SCRATCH(135):
    case NVC7C0_SET_MME_SHADOW_SCRATCH(136):
    case NVC7C0_SET_MME_SHADOW_SCRATCH(137):
    case NVC7C0_SET_MME_SHADOW_SCRATCH(138):
    case NVC7C0_SET_MME_SHADOW_SCRATCH(139):
    case NVC7C0_SET_MME_SHADOW_SCRATCH(140):
    case NVC7C0_SET_MME_SHADOW_SCRATCH(141):
    case NVC7C0_SET_MME_SHADOW_SCRATCH(142):
    case NVC7C0_SET_MME_SHADOW_SCRATCH(143):
    case NVC7C0_SET_MME_SHADOW_SCRATCH(144):
    case NVC7C0_SET_MME_SHADOW_SCRATCH(145):
    case NVC7C0_SET_MME_SHADOW_SCRATCH(146):
    case NVC7C0_SET_MME_SHADOW_SCRATCH(147):
    case NVC7C0_SET_MME_SHADOW_SCRATCH(148):
    case NVC7C0_SET_MME_SHADOW_SCRATCH(149):
    case NVC7C0_SET_MME_SHADOW_SCRATCH(150):
    case NVC7C0_SET_MME_SHADOW_SCRATCH(151):
    case NVC7C0_SET_MME_SHADOW_SCRATCH(152):
    case NVC7C0_SET_MME_SHADOW_SCRATCH(153):
    case NVC7C0_SET_MME_SHADOW_SCRATCH(154):
    case NVC7C0_SET_MME_SHADOW_SCRATCH(155):
    case NVC7C0_SET_MME_SHADOW_SCRATCH(156):
    case NVC7C0_SET_MME_SHADOW_SCRATCH(157):
    case NVC7C0_SET_MME_SHADOW_SCRATCH(158):
    case NVC7C0_SET_MME_SHADOW_SCRATCH(159):
    case NVC7C0_SET_MME_SHADOW_SCRATCH(160):
    case NVC7C0_SET_MME_SHADOW_SCRATCH(161):
    case NVC7C0_SET_MME_SHADOW_SCRATCH(162):
    case NVC7C0_SET_MME_SHADOW_SCRATCH(163):
    case NVC7C0_SET_MME_SHADOW_SCRATCH(164):
    case NVC7C0_SET_MME_SHADOW_SCRATCH(165):
    case NVC7C0_SET_MME_SHADOW_SCRATCH(166):
    case NVC7C0_SET_MME_SHADOW_SCRATCH(167):
    case NVC7C0_SET_MME_SHADOW_SCRATCH(168):
    case NVC7C0_SET_MME_SHADOW_SCRATCH(169):
    case NVC7C0_SET_MME_SHADOW_SCRATCH(170):
    case NVC7C0_SET_MME_SHADOW_SCRATCH(171):
    case NVC7C0_SET_MME_SHADOW_SCRATCH(172):
    case NVC7C0_SET_MME_SHADOW_SCRATCH(173):
    case NVC7C0_SET_MME_SHADOW_SCRATCH(174):
    case NVC7C0_SET_MME_SHADOW_SCRATCH(175):
    case NVC7C0_SET_MME_SHADOW_SCRATCH(176):
    case NVC7C0_SET_MME_SHADOW_SCRATCH(177):
    case NVC7C0_SET_MME_SHADOW_SCRATCH(178):
    case NVC7C0_SET_MME_SHADOW_SCRATCH(179):
    case NVC7C0_SET_MME_SHADOW_SCRATCH(180):
    case NVC7C0_SET_MME_SHADOW_SCRATCH(181):
    case NVC7C0_SET_MME_SHADOW_SCRATCH(182):
    case NVC7C0_SET_MME_SHADOW_SCRATCH(183):
    case NVC7C0_SET_MME_SHADOW_SCRATCH(184):
    case NVC7C0_SET_MME_SHADOW_SCRATCH(185):
    case NVC7C0_SET_MME_SHADOW_SCRATCH(186):
    case NVC7C0_SET_MME_SHADOW_SCRATCH(187):
    case NVC7C0_SET_MME_SHADOW_SCRATCH(188):
    case NVC7C0_SET_MME_SHADOW_SCRATCH(189):
    case NVC7C0_SET_MME_SHADOW_SCRATCH(190):
    case NVC7C0_SET_MME_SHADOW_SCRATCH(191):
    case NVC7C0_SET_MME_SHADOW_SCRATCH(192):
    case NVC7C0_SET_MME_SHADOW_SCRATCH(193):
    case NVC7C0_SET_MME_SHADOW_SCRATCH(194):
    case NVC7C0_SET_MME_SHADOW_SCRATCH(195):
    case NVC7C0_SET_MME_SHADOW_SCRATCH(196):
    case NVC7C0_SET_MME_SHADOW_SCRATCH(197):
    case NVC7C0_SET_MME_SHADOW_SCRATCH(198):
    case NVC7C0_SET_MME_SHADOW_SCRATCH(199):
    case NVC7C0_SET_MME_SHADOW_SCRATCH(200):
    case NVC7C0_SET_MME_SHADOW_SCRATCH(201):
    case NVC7C0_SET_MME_SHADOW_SCRATCH(202):
    case NVC7C0_SET_MME_SHADOW_SCRATCH(203):
    case NVC7C0_SET_MME_SHADOW_SCRATCH(204):
    case NVC7C0_SET_MME_SHADOW_SCRATCH(205):
    case NVC7C0_SET_MME_SHADOW_SCRATCH(206):
    case NVC7C0_SET_MME_SHADOW_SCRATCH(207):
    case NVC7C0_SET_MME_SHADOW_SCRATCH(208):
    case NVC7C0_SET_MME_SHADOW_SCRATCH(209):
    case NVC7C0_SET_MME_SHADOW_SCRATCH(210):
    case NVC7C0_SET_MME_SHADOW_SCRATCH(211):
    case NVC7C0_SET_MME_SHADOW_SCRATCH(212):
    case NVC7C0_SET_MME_SHADOW_SCRATCH(213):
    case NVC7C0_SET_MME_SHADOW_SCRATCH(214):
    case NVC7C0_SET_MME_SHADOW_SCRATCH(215):
    case NVC7C0_SET_MME_SHADOW_SCRATCH(216):
    case NVC7C0_SET_MME_SHADOW_SCRATCH(217):
    case NVC7C0_SET_MME_SHADOW_SCRATCH(218):
    case NVC7C0_SET_MME_SHADOW_SCRATCH(219):
    case NVC7C0_SET_MME_SHADOW_SCRATCH(220):
    case NVC7C0_SET_MME_SHADOW_SCRATCH(221):
    case NVC7C0_SET_MME_SHADOW_SCRATCH(222):
    case NVC7C0_SET_MME_SHADOW_SCRATCH(223):
    case NVC7C0_SET_MME_SHADOW_SCRATCH(224):
    case NVC7C0_SET_MME_SHADOW_SCRATCH(225):
    case NVC7C0_SET_MME_SHADOW_SCRATCH(226):
    case NVC7C0_SET_MME_SHADOW_SCRATCH(227):
    case NVC7C0_SET_MME_SHADOW_SCRATCH(228):
    case NVC7C0_SET_MME_SHADOW_SCRATCH(229):
    case NVC7C0_SET_MME_SHADOW_SCRATCH(230):
    case NVC7C0_SET_MME_SHADOW_SCRATCH(231):
    case NVC7C0_SET_MME_SHADOW_SCRATCH(232):
    case NVC7C0_SET_MME_SHADOW_SCRATCH(233):
    case NVC7C0_SET_MME_SHADOW_SCRATCH(234):
    case NVC7C0_SET_MME_SHADOW_SCRATCH(235):
    case NVC7C0_SET_MME_SHADOW_SCRATCH(236):
    case NVC7C0_SET_MME_SHADOW_SCRATCH(237):
    case NVC7C0_SET_MME_SHADOW_SCRATCH(238):
    case NVC7C0_SET_MME_SHADOW_SCRATCH(239):
    case NVC7C0_SET_MME_SHADOW_SCRATCH(240):
    case NVC7C0_SET_MME_SHADOW_SCRATCH(241):
    case NVC7C0_SET_MME_SHADOW_SCRATCH(242):
    case NVC7C0_SET_MME_SHADOW_SCRATCH(243):
    case NVC7C0_SET_MME_SHADOW_SCRATCH(244):
    case NVC7C0_SET_MME_SHADOW_SCRATCH(245):
    case NVC7C0_SET_MME_SHADOW_SCRATCH(246):
    case NVC7C0_SET_MME_SHADOW_SCRATCH(247):
    case NVC7C0_SET_MME_SHADOW_SCRATCH(248):
    case NVC7C0_SET_MME_SHADOW_SCRATCH(249):
    case NVC7C0_SET_MME_SHADOW_SCRATCH(250):
    case NVC7C0_SET_MME_SHADOW_SCRATCH(251):
    case NVC7C0_SET_MME_SHADOW_SCRATCH(252):
    case NVC7C0_SET_MME_SHADOW_SCRATCH(253):
    case NVC7C0_SET_MME_SHADOW_SCRATCH(254):
    case NVC7C0_SET_MME_SHADOW_SCRATCH(255):
    
        parsed = data;
        fprintf(fp, "%s.V = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVC7C0_CALL_MME_MACRO(0):
    case NVC7C0_CALL_MME_MACRO(1):
    case NVC7C0_CALL_MME_MACRO(2):
    case NVC7C0_CALL_MME_MACRO(3):
    case NVC7C0_CALL_MME_MACRO(4):
    case NVC7C0_CALL_MME_MACRO(5):
    case NVC7C0_CALL_MME_MACRO(6):
    case NVC7C0_CALL_MME_MACRO(7):
    case NVC7C0_CALL_MME_MACRO(8):
    case NVC7C0_CALL_MME_MACRO(9):
    case NVC7C0_CALL_MME_MACRO(10):
    case NVC7C0_CALL_MME_MACRO(11):
    case NVC7C0_CALL_MME_MACRO(12):
    case NVC7C0_CALL_MME_MACRO(13):
    case NVC7C0_CALL_MME_MACRO(14):
    case NVC7C0_CALL_MME_MACRO(15):
    case NVC7C0_CALL_MME_MACRO(16):
    case NVC7C0_CALL_MME_MACRO(17):
    case NVC7C0_CALL_MME_MACRO(18):
    case NVC7C0_CALL_MME_MACRO(19):
    case NVC7C0_CALL_MME_MACRO(20):
    case NVC7C0_CALL_MME_MACRO(21):
    case NVC7C0_CALL_MME_MACRO(22):
    case NVC7C0_CALL_MME_MACRO(23):
    case NVC7C0_CALL_MME_MACRO(24):
    case NVC7C0_CALL_MME_MACRO(25):
    case NVC7C0_CALL_MME_MACRO(26):
    case NVC7C0_CALL_MME_MACRO(27):
    case NVC7C0_CALL_MME_MACRO(28):
    case NVC7C0_CALL_MME_MACRO(29):
    case NVC7C0_CALL_MME_MACRO(30):
    case NVC7C0_CALL_MME_MACRO(31):
    case NVC7C0_CALL_MME_MACRO(32):
    case NVC7C0_CALL_MME_MACRO(33):
    case NVC7C0_CALL_MME_MACRO(34):
    case NVC7C0_CALL_MME_MACRO(35):
    case NVC7C0_CALL_MME_MACRO(36):
    case NVC7C0_CALL_MME_MACRO(37):
    case NVC7C0_CALL_MME_MACRO(38):
    case NVC7C0_CALL_MME_MACRO(39):
    case NVC7C0_CALL_MME_MACRO(40):
    case NVC7C0_CALL_MME_MACRO(41):
    case NVC7C0_CALL_MME_MACRO(42):
    case NVC7C0_CALL_MME_MACRO(43):
    case NVC7C0_CALL_MME_MACRO(44):
    case NVC7C0_CALL_MME_MACRO(45):
    case NVC7C0_CALL_MME_MACRO(46):
    case NVC7C0_CALL_MME_MACRO(47):
    case NVC7C0_CALL_MME_MACRO(48):
    case NVC7C0_CALL_MME_MACRO(49):
    case NVC7C0_CALL_MME_MACRO(50):
    case NVC7C0_CALL_MME_MACRO(51):
    case NVC7C0_CALL_MME_MACRO(52):
    case NVC7C0_CALL_MME_MACRO(53):
    case NVC7C0_CALL_MME_MACRO(54):
    case NVC7C0_CALL_MME_MACRO(55):
    case NVC7C0_CALL_MME_MACRO(56):
    case NVC7C0_CALL_MME_MACRO(57):
    case NVC7C0_CALL_MME_MACRO(58):
    case NVC7C0_CALL_MME_MACRO(59):
    case NVC7C0_CALL_MME_MACRO(60):
    case NVC7C0_CALL_MME_MACRO(61):
    case NVC7C0_CALL_MME_MACRO(62):
    case NVC7C0_CALL_MME_MACRO(63):
    case NVC7C0_CALL_MME_MACRO(64):
    case NVC7C0_CALL_MME_MACRO(65):
    case NVC7C0_CALL_MME_MACRO(66):
    case NVC7C0_CALL_MME_MACRO(67):
    case NVC7C0_CALL_MME_MACRO(68):
    case NVC7C0_CALL_MME_MACRO(69):
    case NVC7C0_CALL_MME_MACRO(70):
    case NVC7C0_CALL_MME_MACRO(71):
    case NVC7C0_CALL_MME_MACRO(72):
    case NVC7C0_CALL_MME_MACRO(73):
    case NVC7C0_CALL_MME_MACRO(74):
    case NVC7C0_CALL_MME_MACRO(75):
    case NVC7C0_CALL_MME_MACRO(76):
    case NVC7C0_CALL_MME_MACRO(77):
    case NVC7C0_CALL_MME_MACRO(78):
    case NVC7C0_CALL_MME_MACRO(79):
    case NVC7C0_CALL_MME_MACRO(80):
    case NVC7C0_CALL_MME_MACRO(81):
    case NVC7C0_CALL_MME_MACRO(82):
    case NVC7C0_CALL_MME_MACRO(83):
    case NVC7C0_CALL_MME_MACRO(84):
    case NVC7C0_CALL_MME_MACRO(85):
    case NVC7C0_CALL_MME_MACRO(86):
    case NVC7C0_CALL_MME_MACRO(87):
    case NVC7C0_CALL_MME_MACRO(88):
    case NVC7C0_CALL_MME_MACRO(89):
    case NVC7C0_CALL_MME_MACRO(90):
    case NVC7C0_CALL_MME_MACRO(91):
    case NVC7C0_CALL_MME_MACRO(92):
    case NVC7C0_CALL_MME_MACRO(93):
    case NVC7C0_CALL_MME_MACRO(94):
    case NVC7C0_CALL_MME_MACRO(95):
    case NVC7C0_CALL_MME_MACRO(96):
    case NVC7C0_CALL_MME_MACRO(97):
    case NVC7C0_CALL_MME_MACRO(98):
    case NVC7C0_CALL_MME_MACRO(99):
    case NVC7C0_CALL_MME_MACRO(100):
    case NVC7C0_CALL_MME_MACRO(101):
    case NVC7C0_CALL_MME_MACRO(102):
    case NVC7C0_CALL_MME_MACRO(103):
    case NVC7C0_CALL_MME_MACRO(104):
    case NVC7C0_CALL_MME_MACRO(105):
    case NVC7C0_CALL_MME_MACRO(106):
    case NVC7C0_CALL_MME_MACRO(107):
    case NVC7C0_CALL_MME_MACRO(108):
    case NVC7C0_CALL_MME_MACRO(109):
    case NVC7C0_CALL_MME_MACRO(110):
    case NVC7C0_CALL_MME_MACRO(111):
    case NVC7C0_CALL_MME_MACRO(112):
    case NVC7C0_CALL_MME_MACRO(113):
    case NVC7C0_CALL_MME_MACRO(114):
    case NVC7C0_CALL_MME_MACRO(115):
    case NVC7C0_CALL_MME_MACRO(116):
    case NVC7C0_CALL_MME_MACRO(117):
    case NVC7C0_CALL_MME_MACRO(118):
    case NVC7C0_CALL_MME_MACRO(119):
    case NVC7C0_CALL_MME_MACRO(120):
    case NVC7C0_CALL_MME_MACRO(121):
    case NVC7C0_CALL_MME_MACRO(122):
    case NVC7C0_CALL_MME_MACRO(123):
    case NVC7C0_CALL_MME_MACRO(124):
    case NVC7C0_CALL_MME_MACRO(125):
    case NVC7C0_CALL_MME_MACRO(126):
    case NVC7C0_CALL_MME_MACRO(127):
    case NVC7C0_CALL_MME_MACRO(128):
    case NVC7C0_CALL_MME_MACRO(129):
    case NVC7C0_CALL_MME_MACRO(130):
    case NVC7C0_CALL_MME_MACRO(131):
    case NVC7C0_CALL_MME_MACRO(132):
    case NVC7C0_CALL_MME_MACRO(133):
    case NVC7C0_CALL_MME_MACRO(134):
    case NVC7C0_CALL_MME_MACRO(135):
    case NVC7C0_CALL_MME_MACRO(136):
    case NVC7C0_CALL_MME_MACRO(137):
    case NVC7C0_CALL_MME_MACRO(138):
    case NVC7C0_CALL_MME_MACRO(139):
    case NVC7C0_CALL_MME_MACRO(140):
    case NVC7C0_CALL_MME_MACRO(141):
    case NVC7C0_CALL_MME_MACRO(142):
    case NVC7C0_CALL_MME_MACRO(143):
    case NVC7C0_CALL_MME_MACRO(144):
    case NVC7C0_CALL_MME_MACRO(145):
    case NVC7C0_CALL_MME_MACRO(146):
    case NVC7C0_CALL_MME_MACRO(147):
    case NVC7C0_CALL_MME_MACRO(148):
    case NVC7C0_CALL_MME_MACRO(149):
    case NVC7C0_CALL_MME_MACRO(150):
    case NVC7C0_CALL_MME_MACRO(151):
    case NVC7C0_CALL_MME_MACRO(152):
    case NVC7C0_CALL_MME_MACRO(153):
    case NVC7C0_CALL_MME_MACRO(154):
    case NVC7C0_CALL_MME_MACRO(155):
    case NVC7C0_CALL_MME_MACRO(156):
    case NVC7C0_CALL_MME_MACRO(157):
    case NVC7C0_CALL_MME_MACRO(158):
    case NVC7C0_CALL_MME_MACRO(159):
    case NVC7C0_CALL_MME_MACRO(160):
    case NVC7C0_CALL_MME_MACRO(161):
    case NVC7C0_CALL_MME_MACRO(162):
    case NVC7C0_CALL_MME_MACRO(163):
    case NVC7C0_CALL_MME_MACRO(164):
    case NVC7C0_CALL_MME_MACRO(165):
    case NVC7C0_CALL_MME_MACRO(166):
    case NVC7C0_CALL_MME_MACRO(167):
    case NVC7C0_CALL_MME_MACRO(168):
    case NVC7C0_CALL_MME_MACRO(169):
    case NVC7C0_CALL_MME_MACRO(170):
    case NVC7C0_CALL_MME_MACRO(171):
    case NVC7C0_CALL_MME_MACRO(172):
    case NVC7C0_CALL_MME_MACRO(173):
    case NVC7C0_CALL_MME_MACRO(174):
    case NVC7C0_CALL_MME_MACRO(175):
    case NVC7C0_CALL_MME_MACRO(176):
    case NVC7C0_CALL_MME_MACRO(177):
    case NVC7C0_CALL_MME_MACRO(178):
    case NVC7C0_CALL_MME_MACRO(179):
    case NVC7C0_CALL_MME_MACRO(180):
    case NVC7C0_CALL_MME_MACRO(181):
    case NVC7C0_CALL_MME_MACRO(182):
    case NVC7C0_CALL_MME_MACRO(183):
    case NVC7C0_CALL_MME_MACRO(184):
    case NVC7C0_CALL_MME_MACRO(185):
    case NVC7C0_CALL_MME_MACRO(186):
    case NVC7C0_CALL_MME_MACRO(187):
    case NVC7C0_CALL_MME_MACRO(188):
    case NVC7C0_CALL_MME_MACRO(189):
    case NVC7C0_CALL_MME_MACRO(190):
    case NVC7C0_CALL_MME_MACRO(191):
    case NVC7C0_CALL_MME_MACRO(192):
    case NVC7C0_CALL_MME_MACRO(193):
    case NVC7C0_CALL_MME_MACRO(194):
    case NVC7C0_CALL_MME_MACRO(195):
    case NVC7C0_CALL_MME_MACRO(196):
    case NVC7C0_CALL_MME_MACRO(197):
    case NVC7C0_CALL_MME_MACRO(198):
    case NVC7C0_CALL_MME_MACRO(199):
    case NVC7C0_CALL_MME_MACRO(200):
    case NVC7C0_CALL_MME_MACRO(201):
    case NVC7C0_CALL_MME_MACRO(202):
    case NVC7C0_CALL_MME_MACRO(203):
    case NVC7C0_CALL_MME_MACRO(204):
    case NVC7C0_CALL_MME_MACRO(205):
    case NVC7C0_CALL_MME_MACRO(206):
    case NVC7C0_CALL_MME_MACRO(207):
    case NVC7C0_CALL_MME_MACRO(208):
    case NVC7C0_CALL_MME_MACRO(209):
    case NVC7C0_CALL_MME_MACRO(210):
    case NVC7C0_CALL_MME_MACRO(211):
    case NVC7C0_CALL_MME_MACRO(212):
    case NVC7C0_CALL_MME_MACRO(213):
    case NVC7C0_CALL_MME_MACRO(214):
    case NVC7C0_CALL_MME_MACRO(215):
    case NVC7C0_CALL_MME_MACRO(216):
    case NVC7C0_CALL_MME_MACRO(217):
    case NVC7C0_CALL_MME_MACRO(218):
    case NVC7C0_CALL_MME_MACRO(219):
    case NVC7C0_CALL_MME_MACRO(220):
    case NVC7C0_CALL_MME_MACRO(221):
    case NVC7C0_CALL_MME_MACRO(222):
    case NVC7C0_CALL_MME_MACRO(223):
    case NVC7C0_CALL_MME_MACRO(224):
    case NVC7C0_CALL_MME_MACRO(225):
    case NVC7C0_CALL_MME_MACRO(226):
    case NVC7C0_CALL_MME_MACRO(227):
    case NVC7C0_CALL_MME_MACRO(228):
    case NVC7C0_CALL_MME_MACRO(229):
    case NVC7C0_CALL_MME_MACRO(230):
    case NVC7C0_CALL_MME_MACRO(231):
    case NVC7C0_CALL_MME_MACRO(232):
    case NVC7C0_CALL_MME_MACRO(233):
    case NVC7C0_CALL_MME_MACRO(234):
    case NVC7C0_CALL_MME_MACRO(235):
    case NVC7C0_CALL_MME_MACRO(236):
    case NVC7C0_CALL_MME_MACRO(237):
    case NVC7C0_CALL_MME_MACRO(238):
    case NVC7C0_CALL_MME_MACRO(239):
    case NVC7C0_CALL_MME_MACRO(240):
    case NVC7C0_CALL_MME_MACRO(241):
    case NVC7C0_CALL_MME_MACRO(242):
    case NVC7C0_CALL_MME_MACRO(243):
    case NVC7C0_CALL_MME_MACRO(244):
    case NVC7C0_CALL_MME_MACRO(245):
    case NVC7C0_CALL_MME_MACRO(246):
    case NVC7C0_CALL_MME_MACRO(247):
    case NVC7C0_CALL_MME_MACRO(248):
    case NVC7C0_CALL_MME_MACRO(249):
    case NVC7C0_CALL_MME_MACRO(250):
    case NVC7C0_CALL_MME_MACRO(251):
    case NVC7C0_CALL_MME_MACRO(252):
    case NVC7C0_CALL_MME_MACRO(253):
    case NVC7C0_CALL_MME_MACRO(254):
    case NVC7C0_CALL_MME_MACRO(255):
    
        parsed = data;
        fprintf(fp, "%s.V = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVC7C0_CALL_MME_DATA(0):
    case NVC7C0_CALL_MME_DATA(1):
    case NVC7C0_CALL_MME_DATA(2):
    case NVC7C0_CALL_MME_DATA(3):
    case NVC7C0_CALL_MME_DATA(4):
    case NVC7C0_CALL_MME_DATA(5):
    case NVC7C0_CALL_MME_DATA(6):
    case NVC7C0_CALL_MME_DATA(7):
    case NVC7C0_CALL_MME_DATA(8):
    case NVC7C0_CALL_MME_DATA(9):
    case NVC7C0_CALL_MME_DATA(10):
    case NVC7C0_CALL_MME_DATA(11):
    case NVC7C0_CALL_MME_DATA(12):
    case NVC7C0_CALL_MME_DATA(13):
    case NVC7C0_CALL_MME_DATA(14):
    case NVC7C0_CALL_MME_DATA(15):
    case NVC7C0_CALL_MME_DATA(16):
    case NVC7C0_CALL_MME_DATA(17):
    case NVC7C0_CALL_MME_DATA(18):
    case NVC7C0_CALL_MME_DATA(19):
    case NVC7C0_CALL_MME_DATA(20):
    case NVC7C0_CALL_MME_DATA(21):
    case NVC7C0_CALL_MME_DATA(22):
    case NVC7C0_CALL_MME_DATA(23):
    case NVC7C0_CALL_MME_DATA(24):
    case NVC7C0_CALL_MME_DATA(25):
    case NVC7C0_CALL_MME_DATA(26):
    case NVC7C0_CALL_MME_DATA(27):
    case NVC7C0_CALL_MME_DATA(28):
    case NVC7C0_CALL_MME_DATA(29):
    case NVC7C0_CALL_MME_DATA(30):
    case NVC7C0_CALL_MME_DATA(31):
    case NVC7C0_CALL_MME_DATA(32):
    case NVC7C0_CALL_MME_DATA(33):
    case NVC7C0_CALL_MME_DATA(34):
    case NVC7C0_CALL_MME_DATA(35):
    case NVC7C0_CALL_MME_DATA(36):
    case NVC7C0_CALL_MME_DATA(37):
    case NVC7C0_CALL_MME_DATA(38):
    case NVC7C0_CALL_MME_DATA(39):
    case NVC7C0_CALL_MME_DATA(40):
    case NVC7C0_CALL_MME_DATA(41):
    case NVC7C0_CALL_MME_DATA(42):
    case NVC7C0_CALL_MME_DATA(43):
    case NVC7C0_CALL_MME_DATA(44):
    case NVC7C0_CALL_MME_DATA(45):
    case NVC7C0_CALL_MME_DATA(46):
    case NVC7C0_CALL_MME_DATA(47):
    case NVC7C0_CALL_MME_DATA(48):
    case NVC7C0_CALL_MME_DATA(49):
    case NVC7C0_CALL_MME_DATA(50):
    case NVC7C0_CALL_MME_DATA(51):
    case NVC7C0_CALL_MME_DATA(52):
    case NVC7C0_CALL_MME_DATA(53):
    case NVC7C0_CALL_MME_DATA(54):
    case NVC7C0_CALL_MME_DATA(55):
    case NVC7C0_CALL_MME_DATA(56):
    case NVC7C0_CALL_MME_DATA(57):
    case NVC7C0_CALL_MME_DATA(58):
    case NVC7C0_CALL_MME_DATA(59):
    case NVC7C0_CALL_MME_DATA(60):
    case NVC7C0_CALL_MME_DATA(61):
    case NVC7C0_CALL_MME_DATA(62):
    case NVC7C0_CALL_MME_DATA(63):
    case NVC7C0_CALL_MME_DATA(64):
    case NVC7C0_CALL_MME_DATA(65):
    case NVC7C0_CALL_MME_DATA(66):
    case NVC7C0_CALL_MME_DATA(67):
    case NVC7C0_CALL_MME_DATA(68):
    case NVC7C0_CALL_MME_DATA(69):
    case NVC7C0_CALL_MME_DATA(70):
    case NVC7C0_CALL_MME_DATA(71):
    case NVC7C0_CALL_MME_DATA(72):
    case NVC7C0_CALL_MME_DATA(73):
    case NVC7C0_CALL_MME_DATA(74):
    case NVC7C0_CALL_MME_DATA(75):
    case NVC7C0_CALL_MME_DATA(76):
    case NVC7C0_CALL_MME_DATA(77):
    case NVC7C0_CALL_MME_DATA(78):
    case NVC7C0_CALL_MME_DATA(79):
    case NVC7C0_CALL_MME_DATA(80):
    case NVC7C0_CALL_MME_DATA(81):
    case NVC7C0_CALL_MME_DATA(82):
    case NVC7C0_CALL_MME_DATA(83):
    case NVC7C0_CALL_MME_DATA(84):
    case NVC7C0_CALL_MME_DATA(85):
    case NVC7C0_CALL_MME_DATA(86):
    case NVC7C0_CALL_MME_DATA(87):
    case NVC7C0_CALL_MME_DATA(88):
    case NVC7C0_CALL_MME_DATA(89):
    case NVC7C0_CALL_MME_DATA(90):
    case NVC7C0_CALL_MME_DATA(91):
    case NVC7C0_CALL_MME_DATA(92):
    case NVC7C0_CALL_MME_DATA(93):
    case NVC7C0_CALL_MME_DATA(94):
    case NVC7C0_CALL_MME_DATA(95):
    case NVC7C0_CALL_MME_DATA(96):
    case NVC7C0_CALL_MME_DATA(97):
    case NVC7C0_CALL_MME_DATA(98):
    case NVC7C0_CALL_MME_DATA(99):
    case NVC7C0_CALL_MME_DATA(100):
    case NVC7C0_CALL_MME_DATA(101):
    case NVC7C0_CALL_MME_DATA(102):
    case NVC7C0_CALL_MME_DATA(103):
    case NVC7C0_CALL_MME_DATA(104):
    case NVC7C0_CALL_MME_DATA(105):
    case NVC7C0_CALL_MME_DATA(106):
    case NVC7C0_CALL_MME_DATA(107):
    case NVC7C0_CALL_MME_DATA(108):
    case NVC7C0_CALL_MME_DATA(109):
    case NVC7C0_CALL_MME_DATA(110):
    case NVC7C0_CALL_MME_DATA(111):
    case NVC7C0_CALL_MME_DATA(112):
    case NVC7C0_CALL_MME_DATA(113):
    case NVC7C0_CALL_MME_DATA(114):
    case NVC7C0_CALL_MME_DATA(115):
    case NVC7C0_CALL_MME_DATA(116):
    case NVC7C0_CALL_MME_DATA(117):
    case NVC7C0_CALL_MME_DATA(118):
    case NVC7C0_CALL_MME_DATA(119):
    case NVC7C0_CALL_MME_DATA(120):
    case NVC7C0_CALL_MME_DATA(121):
    case NVC7C0_CALL_MME_DATA(122):
    case NVC7C0_CALL_MME_DATA(123):
    case NVC7C0_CALL_MME_DATA(124):
    case NVC7C0_CALL_MME_DATA(125):
    case NVC7C0_CALL_MME_DATA(126):
    case NVC7C0_CALL_MME_DATA(127):
    case NVC7C0_CALL_MME_DATA(128):
    case NVC7C0_CALL_MME_DATA(129):
    case NVC7C0_CALL_MME_DATA(130):
    case NVC7C0_CALL_MME_DATA(131):
    case NVC7C0_CALL_MME_DATA(132):
    case NVC7C0_CALL_MME_DATA(133):
    case NVC7C0_CALL_MME_DATA(134):
    case NVC7C0_CALL_MME_DATA(135):
    case NVC7C0_CALL_MME_DATA(136):
    case NVC7C0_CALL_MME_DATA(137):
    case NVC7C0_CALL_MME_DATA(138):
    case NVC7C0_CALL_MME_DATA(139):
    case NVC7C0_CALL_MME_DATA(140):
    case NVC7C0_CALL_MME_DATA(141):
    case NVC7C0_CALL_MME_DATA(142):
    case NVC7C0_CALL_MME_DATA(143):
    case NVC7C0_CALL_MME_DATA(144):
    case NVC7C0_CALL_MME_DATA(145):
    case NVC7C0_CALL_MME_DATA(146):
    case NVC7C0_CALL_MME_DATA(147):
    case NVC7C0_CALL_MME_DATA(148):
    case NVC7C0_CALL_MME_DATA(149):
    case NVC7C0_CALL_MME_DATA(150):
    case NVC7C0_CALL_MME_DATA(151):
    case NVC7C0_CALL_MME_DATA(152):
    case NVC7C0_CALL_MME_DATA(153):
    case NVC7C0_CALL_MME_DATA(154):
    case NVC7C0_CALL_MME_DATA(155):
    case NVC7C0_CALL_MME_DATA(156):
    case NVC7C0_CALL_MME_DATA(157):
    case NVC7C0_CALL_MME_DATA(158):
    case NVC7C0_CALL_MME_DATA(159):
    case NVC7C0_CALL_MME_DATA(160):
    case NVC7C0_CALL_MME_DATA(161):
    case NVC7C0_CALL_MME_DATA(162):
    case NVC7C0_CALL_MME_DATA(163):
    case NVC7C0_CALL_MME_DATA(164):
    case NVC7C0_CALL_MME_DATA(165):
    case NVC7C0_CALL_MME_DATA(166):
    case NVC7C0_CALL_MME_DATA(167):
    case NVC7C0_CALL_MME_DATA(168):
    case NVC7C0_CALL_MME_DATA(169):
    case NVC7C0_CALL_MME_DATA(170):
    case NVC7C0_CALL_MME_DATA(171):
    case NVC7C0_CALL_MME_DATA(172):
    case NVC7C0_CALL_MME_DATA(173):
    case NVC7C0_CALL_MME_DATA(174):
    case NVC7C0_CALL_MME_DATA(175):
    case NVC7C0_CALL_MME_DATA(176):
    case NVC7C0_CALL_MME_DATA(177):
    case NVC7C0_CALL_MME_DATA(178):
    case NVC7C0_CALL_MME_DATA(179):
    case NVC7C0_CALL_MME_DATA(180):
    case NVC7C0_CALL_MME_DATA(181):
    case NVC7C0_CALL_MME_DATA(182):
    case NVC7C0_CALL_MME_DATA(183):
    case NVC7C0_CALL_MME_DATA(184):
    case NVC7C0_CALL_MME_DATA(185):
    case NVC7C0_CALL_MME_DATA(186):
    case NVC7C0_CALL_MME_DATA(187):
    case NVC7C0_CALL_MME_DATA(188):
    case NVC7C0_CALL_MME_DATA(189):
    case NVC7C0_CALL_MME_DATA(190):
    case NVC7C0_CALL_MME_DATA(191):
    case NVC7C0_CALL_MME_DATA(192):
    case NVC7C0_CALL_MME_DATA(193):
    case NVC7C0_CALL_MME_DATA(194):
    case NVC7C0_CALL_MME_DATA(195):
    case NVC7C0_CALL_MME_DATA(196):
    case NVC7C0_CALL_MME_DATA(197):
    case NVC7C0_CALL_MME_DATA(198):
    case NVC7C0_CALL_MME_DATA(199):
    case NVC7C0_CALL_MME_DATA(200):
    case NVC7C0_CALL_MME_DATA(201):
    case NVC7C0_CALL_MME_DATA(202):
    case NVC7C0_CALL_MME_DATA(203):
    case NVC7C0_CALL_MME_DATA(204):
    case NVC7C0_CALL_MME_DATA(205):
    case NVC7C0_CALL_MME_DATA(206):
    case NVC7C0_CALL_MME_DATA(207):
    case NVC7C0_CALL_MME_DATA(208):
    case NVC7C0_CALL_MME_DATA(209):
    case NVC7C0_CALL_MME_DATA(210):
    case NVC7C0_CALL_MME_DATA(211):
    case NVC7C0_CALL_MME_DATA(212):
    case NVC7C0_CALL_MME_DATA(213):
    case NVC7C0_CALL_MME_DATA(214):
    case NVC7C0_CALL_MME_DATA(215):
    case NVC7C0_CALL_MME_DATA(216):
    case NVC7C0_CALL_MME_DATA(217):
    case NVC7C0_CALL_MME_DATA(218):
    case NVC7C0_CALL_MME_DATA(219):
    case NVC7C0_CALL_MME_DATA(220):
    case NVC7C0_CALL_MME_DATA(221):
    case NVC7C0_CALL_MME_DATA(222):
    case NVC7C0_CALL_MME_DATA(223):
    case NVC7C0_CALL_MME_DATA(224):
    case NVC7C0_CALL_MME_DATA(225):
    case NVC7C0_CALL_MME_DATA(226):
    case NVC7C0_CALL_MME_DATA(227):
    case NVC7C0_CALL_MME_DATA(228):
    case NVC7C0_CALL_MME_DATA(229):
    case NVC7C0_CALL_MME_DATA(230):
    case NVC7C0_CALL_MME_DATA(231):
    case NVC7C0_CALL_MME_DATA(232):
    case NVC7C0_CALL_MME_DATA(233):
    case NVC7C0_CALL_MME_DATA(234):
    case NVC7C0_CALL_MME_DATA(235):
    case NVC7C0_CALL_MME_DATA(236):
    case NVC7C0_CALL_MME_DATA(237):
    case NVC7C0_CALL_MME_DATA(238):
    case NVC7C0_CALL_MME_DATA(239):
    case NVC7C0_CALL_MME_DATA(240):
    case NVC7C0_CALL_MME_DATA(241):
    case NVC7C0_CALL_MME_DATA(242):
    case NVC7C0_CALL_MME_DATA(243):
    case NVC7C0_CALL_MME_DATA(244):
    case NVC7C0_CALL_MME_DATA(245):
    case NVC7C0_CALL_MME_DATA(246):
    case NVC7C0_CALL_MME_DATA(247):
    case NVC7C0_CALL_MME_DATA(248):
    case NVC7C0_CALL_MME_DATA(249):
    case NVC7C0_CALL_MME_DATA(250):
    case NVC7C0_CALL_MME_DATA(251):
    case NVC7C0_CALL_MME_DATA(252):
    case NVC7C0_CALL_MME_DATA(253):
    case NVC7C0_CALL_MME_DATA(254):
    case NVC7C0_CALL_MME_DATA(255):
    
        parsed = data;
        fprintf(fp, "%s.V = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    default:
        fprintf(fp, "%s.VALUE = 0x%x\n", prefix, data);
        break;
    }
}
