/*
 * Copyright © 2017 Connor Abbott
 *
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of this software and associated documentation files (the "Software"),
 * to deal in the Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, sublicense,
 * and/or sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice (including the next
 * paragraph) shall be included in all copies or substantial portions of the
 * Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
 * THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS
 * IN THE SOFTWARE.
 */

#ifndef _NIR_SERIALIZE_H
#define _NIR_SERIALIZE_H

#include "util/blob.h"
#include "nir.h"

#ifdef __cplusplus
extern "C" {
#endif

void nir_serialize(struct blob *blob, const nir_shader *nir, bool strip);
nir_shader *nir_deserialize(void *mem_ctx,
                            const struct nir_shader_compiler_options *options,
                            struct blob_reader *blob);

void
nir_serialize_function(struct blob *blob, const nir_function *fxn);

nir_function *
nir_deserialize_function(void *mem_ctx,
                         const struct nir_shader_compiler_options *options,
                         struct blob_reader *blob);

#ifdef __cplusplus
} /* extern "C" */
#endif

#endif
