#include "nv_push_cla140.h"

#include <stdio.h>

const char*
P_PARSE_NVA140_MTHD(uint16_t idx)
{
    switch (idx) {
    case NVA140_SET_OBJECT:
        return "NVA140_SET_OBJECT";
    case NVA140_NO_OPERATION:
        return "NVA140_NO_OPERATION";
    case NVA140_SET_NOTIFY_A:
        return "NVA140_SET_NOTIFY_A";
    case NVA140_SET_NOTIFY_B:
        return "NVA140_SET_NOTIFY_B";
    case NVA140_NOTIFY:
        return "NVA140_NOTIFY";
    case NVA140_WAIT_FOR_IDLE:
        return "NVA140_WAIT_FOR_IDLE";
    case NVA140_SET_GLOBAL_RENDER_ENABLE_A:
        return "NVA140_SET_GLOBAL_RENDER_ENABLE_A";
    case NVA140_SET_GLOBAL_RENDER_ENABLE_B:
        return "NVA140_SET_GLOBAL_RENDER_ENABLE_B";
    case NVA140_SET_GLOBAL_RENDER_ENABLE_C:
        return "NVA140_SET_GLOBAL_RENDER_ENABLE_C";
    case NVA140_SEND_GO_IDLE:
        return "NVA140_SEND_GO_IDLE";
    case NVA140_PM_TRIGGER:
        return "NVA140_PM_TRIGGER";
    case NVA140_PM_TRIGGER_WFI:
        return "NVA140_PM_TRIGGER_WFI";
    case NVA140_SET_INSTRUMENTATION_METHOD_HEADER:
        return "NVA140_SET_INSTRUMENTATION_METHOD_HEADER";
    case NVA140_SET_INSTRUMENTATION_METHOD_DATA:
        return "NVA140_SET_INSTRUMENTATION_METHOD_DATA";
    case NVA140_LINE_LENGTH_IN:
        return "NVA140_LINE_LENGTH_IN";
    case NVA140_LINE_COUNT:
        return "NVA140_LINE_COUNT";
    case NVA140_OFFSET_OUT_UPPER:
        return "NVA140_OFFSET_OUT_UPPER";
    case NVA140_OFFSET_OUT:
        return "NVA140_OFFSET_OUT";
    case NVA140_PITCH_OUT:
        return "NVA140_PITCH_OUT";
    case NVA140_SET_DST_BLOCK_SIZE:
        return "NVA140_SET_DST_BLOCK_SIZE";
    case NVA140_SET_DST_WIDTH:
        return "NVA140_SET_DST_WIDTH";
    case NVA140_SET_DST_HEIGHT:
        return "NVA140_SET_DST_HEIGHT";
    case NVA140_SET_DST_DEPTH:
        return "NVA140_SET_DST_DEPTH";
    case NVA140_SET_DST_LAYER:
        return "NVA140_SET_DST_LAYER";
    case NVA140_SET_DST_ORIGIN_BYTES_X:
        return "NVA140_SET_DST_ORIGIN_BYTES_X";
    case NVA140_SET_DST_ORIGIN_SAMPLES_Y:
        return "NVA140_SET_DST_ORIGIN_SAMPLES_Y";
    case NVA140_LAUNCH_DMA:
        return "NVA140_LAUNCH_DMA";
    case NVA140_LOAD_INLINE_DATA:
        return "NVA140_LOAD_INLINE_DATA";
    case NVA140_SET_I2M_SEMAPHORE_A:
        return "NVA140_SET_I2M_SEMAPHORE_A";
    case NVA140_SET_I2M_SEMAPHORE_B:
        return "NVA140_SET_I2M_SEMAPHORE_B";
    case NVA140_SET_I2M_SEMAPHORE_C:
        return "NVA140_SET_I2M_SEMAPHORE_C";
    case NVA140_SET_I2M_SPARE_NOOP00:
        return "NVA140_SET_I2M_SPARE_NOOP00";
    case NVA140_SET_I2M_SPARE_NOOP01:
        return "NVA140_SET_I2M_SPARE_NOOP01";
    case NVA140_SET_I2M_SPARE_NOOP02:
        return "NVA140_SET_I2M_SPARE_NOOP02";
    case NVA140_SET_I2M_SPARE_NOOP03:
        return "NVA140_SET_I2M_SPARE_NOOP03";
    case NVA140_SET_FALCON00:
        return "NVA140_SET_FALCON00";
    case NVA140_SET_FALCON01:
        return "NVA140_SET_FALCON01";
    case NVA140_SET_FALCON02:
        return "NVA140_SET_FALCON02";
    case NVA140_SET_FALCON03:
        return "NVA140_SET_FALCON03";
    case NVA140_SET_FALCON04:
        return "NVA140_SET_FALCON04";
    case NVA140_SET_FALCON05:
        return "NVA140_SET_FALCON05";
    case NVA140_SET_FALCON06:
        return "NVA140_SET_FALCON06";
    case NVA140_SET_FALCON07:
        return "NVA140_SET_FALCON07";
    case NVA140_SET_FALCON08:
        return "NVA140_SET_FALCON08";
    case NVA140_SET_FALCON09:
        return "NVA140_SET_FALCON09";
    case NVA140_SET_FALCON10:
        return "NVA140_SET_FALCON10";
    case NVA140_SET_FALCON11:
        return "NVA140_SET_FALCON11";
    case NVA140_SET_FALCON12:
        return "NVA140_SET_FALCON12";
    case NVA140_SET_FALCON13:
        return "NVA140_SET_FALCON13";
    case NVA140_SET_FALCON14:
        return "NVA140_SET_FALCON14";
    case NVA140_SET_FALCON15:
        return "NVA140_SET_FALCON15";
    case NVA140_SET_FALCON16:
        return "NVA140_SET_FALCON16";
    case NVA140_SET_FALCON17:
        return "NVA140_SET_FALCON17";
    case NVA140_SET_FALCON18:
        return "NVA140_SET_FALCON18";
    case NVA140_SET_FALCON19:
        return "NVA140_SET_FALCON19";
    case NVA140_SET_FALCON20:
        return "NVA140_SET_FALCON20";
    case NVA140_SET_FALCON21:
        return "NVA140_SET_FALCON21";
    case NVA140_SET_FALCON22:
        return "NVA140_SET_FALCON22";
    case NVA140_SET_FALCON23:
        return "NVA140_SET_FALCON23";
    case NVA140_SET_FALCON24:
        return "NVA140_SET_FALCON24";
    case NVA140_SET_FALCON25:
        return "NVA140_SET_FALCON25";
    case NVA140_SET_FALCON26:
        return "NVA140_SET_FALCON26";
    case NVA140_SET_FALCON27:
        return "NVA140_SET_FALCON27";
    case NVA140_SET_FALCON28:
        return "NVA140_SET_FALCON28";
    case NVA140_SET_FALCON29:
        return "NVA140_SET_FALCON29";
    case NVA140_SET_FALCON30:
        return "NVA140_SET_FALCON30";
    case NVA140_SET_FALCON31:
        return "NVA140_SET_FALCON31";
    case NVA140_SET_RENDER_ENABLE_A:
        return "NVA140_SET_RENDER_ENABLE_A";
    case NVA140_SET_RENDER_ENABLE_B:
        return "NVA140_SET_RENDER_ENABLE_B";
    case NVA140_SET_RENDER_ENABLE_C:
        return "NVA140_SET_RENDER_ENABLE_C";
    case NVA140_SET_RENDER_ENABLE_OVERRIDE:
        return "NVA140_SET_RENDER_ENABLE_OVERRIDE";
    case NVA140_SET_MME_SHADOW_SCRATCH(0):
        return "NVA140_SET_MME_SHADOW_SCRATCH(0)";
    case NVA140_SET_MME_SHADOW_SCRATCH(1):
        return "NVA140_SET_MME_SHADOW_SCRATCH(1)";
    case NVA140_SET_MME_SHADOW_SCRATCH(2):
        return "NVA140_SET_MME_SHADOW_SCRATCH(2)";
    case NVA140_SET_MME_SHADOW_SCRATCH(3):
        return "NVA140_SET_MME_SHADOW_SCRATCH(3)";
    case NVA140_SET_MME_SHADOW_SCRATCH(4):
        return "NVA140_SET_MME_SHADOW_SCRATCH(4)";
    case NVA140_SET_MME_SHADOW_SCRATCH(5):
        return "NVA140_SET_MME_SHADOW_SCRATCH(5)";
    case NVA140_SET_MME_SHADOW_SCRATCH(6):
        return "NVA140_SET_MME_SHADOW_SCRATCH(6)";
    case NVA140_SET_MME_SHADOW_SCRATCH(7):
        return "NVA140_SET_MME_SHADOW_SCRATCH(7)";
    case NVA140_SET_MME_SHADOW_SCRATCH(8):
        return "NVA140_SET_MME_SHADOW_SCRATCH(8)";
    case NVA140_SET_MME_SHADOW_SCRATCH(9):
        return "NVA140_SET_MME_SHADOW_SCRATCH(9)";
    case NVA140_SET_MME_SHADOW_SCRATCH(10):
        return "NVA140_SET_MME_SHADOW_SCRATCH(10)";
    case NVA140_SET_MME_SHADOW_SCRATCH(11):
        return "NVA140_SET_MME_SHADOW_SCRATCH(11)";
    case NVA140_SET_MME_SHADOW_SCRATCH(12):
        return "NVA140_SET_MME_SHADOW_SCRATCH(12)";
    case NVA140_SET_MME_SHADOW_SCRATCH(13):
        return "NVA140_SET_MME_SHADOW_SCRATCH(13)";
    case NVA140_SET_MME_SHADOW_SCRATCH(14):
        return "NVA140_SET_MME_SHADOW_SCRATCH(14)";
    case NVA140_SET_MME_SHADOW_SCRATCH(15):
        return "NVA140_SET_MME_SHADOW_SCRATCH(15)";
    case NVA140_SET_MME_SHADOW_SCRATCH(16):
        return "NVA140_SET_MME_SHADOW_SCRATCH(16)";
    case NVA140_SET_MME_SHADOW_SCRATCH(17):
        return "NVA140_SET_MME_SHADOW_SCRATCH(17)";
    case NVA140_SET_MME_SHADOW_SCRATCH(18):
        return "NVA140_SET_MME_SHADOW_SCRATCH(18)";
    case NVA140_SET_MME_SHADOW_SCRATCH(19):
        return "NVA140_SET_MME_SHADOW_SCRATCH(19)";
    case NVA140_SET_MME_SHADOW_SCRATCH(20):
        return "NVA140_SET_MME_SHADOW_SCRATCH(20)";
    case NVA140_SET_MME_SHADOW_SCRATCH(21):
        return "NVA140_SET_MME_SHADOW_SCRATCH(21)";
    case NVA140_SET_MME_SHADOW_SCRATCH(22):
        return "NVA140_SET_MME_SHADOW_SCRATCH(22)";
    case NVA140_SET_MME_SHADOW_SCRATCH(23):
        return "NVA140_SET_MME_SHADOW_SCRATCH(23)";
    case NVA140_SET_MME_SHADOW_SCRATCH(24):
        return "NVA140_SET_MME_SHADOW_SCRATCH(24)";
    case NVA140_SET_MME_SHADOW_SCRATCH(25):
        return "NVA140_SET_MME_SHADOW_SCRATCH(25)";
    case NVA140_SET_MME_SHADOW_SCRATCH(26):
        return "NVA140_SET_MME_SHADOW_SCRATCH(26)";
    case NVA140_SET_MME_SHADOW_SCRATCH(27):
        return "NVA140_SET_MME_SHADOW_SCRATCH(27)";
    case NVA140_SET_MME_SHADOW_SCRATCH(28):
        return "NVA140_SET_MME_SHADOW_SCRATCH(28)";
    case NVA140_SET_MME_SHADOW_SCRATCH(29):
        return "NVA140_SET_MME_SHADOW_SCRATCH(29)";
    case NVA140_SET_MME_SHADOW_SCRATCH(30):
        return "NVA140_SET_MME_SHADOW_SCRATCH(30)";
    case NVA140_SET_MME_SHADOW_SCRATCH(31):
        return "NVA140_SET_MME_SHADOW_SCRATCH(31)";
    case NVA140_SET_MME_SHADOW_SCRATCH(32):
        return "NVA140_SET_MME_SHADOW_SCRATCH(32)";
    case NVA140_SET_MME_SHADOW_SCRATCH(33):
        return "NVA140_SET_MME_SHADOW_SCRATCH(33)";
    case NVA140_SET_MME_SHADOW_SCRATCH(34):
        return "NVA140_SET_MME_SHADOW_SCRATCH(34)";
    case NVA140_SET_MME_SHADOW_SCRATCH(35):
        return "NVA140_SET_MME_SHADOW_SCRATCH(35)";
    case NVA140_SET_MME_SHADOW_SCRATCH(36):
        return "NVA140_SET_MME_SHADOW_SCRATCH(36)";
    case NVA140_SET_MME_SHADOW_SCRATCH(37):
        return "NVA140_SET_MME_SHADOW_SCRATCH(37)";
    case NVA140_SET_MME_SHADOW_SCRATCH(38):
        return "NVA140_SET_MME_SHADOW_SCRATCH(38)";
    case NVA140_SET_MME_SHADOW_SCRATCH(39):
        return "NVA140_SET_MME_SHADOW_SCRATCH(39)";
    case NVA140_SET_MME_SHADOW_SCRATCH(40):
        return "NVA140_SET_MME_SHADOW_SCRATCH(40)";
    case NVA140_SET_MME_SHADOW_SCRATCH(41):
        return "NVA140_SET_MME_SHADOW_SCRATCH(41)";
    case NVA140_SET_MME_SHADOW_SCRATCH(42):
        return "NVA140_SET_MME_SHADOW_SCRATCH(42)";
    case NVA140_SET_MME_SHADOW_SCRATCH(43):
        return "NVA140_SET_MME_SHADOW_SCRATCH(43)";
    case NVA140_SET_MME_SHADOW_SCRATCH(44):
        return "NVA140_SET_MME_SHADOW_SCRATCH(44)";
    case NVA140_SET_MME_SHADOW_SCRATCH(45):
        return "NVA140_SET_MME_SHADOW_SCRATCH(45)";
    case NVA140_SET_MME_SHADOW_SCRATCH(46):
        return "NVA140_SET_MME_SHADOW_SCRATCH(46)";
    case NVA140_SET_MME_SHADOW_SCRATCH(47):
        return "NVA140_SET_MME_SHADOW_SCRATCH(47)";
    case NVA140_SET_MME_SHADOW_SCRATCH(48):
        return "NVA140_SET_MME_SHADOW_SCRATCH(48)";
    case NVA140_SET_MME_SHADOW_SCRATCH(49):
        return "NVA140_SET_MME_SHADOW_SCRATCH(49)";
    case NVA140_SET_MME_SHADOW_SCRATCH(50):
        return "NVA140_SET_MME_SHADOW_SCRATCH(50)";
    case NVA140_SET_MME_SHADOW_SCRATCH(51):
        return "NVA140_SET_MME_SHADOW_SCRATCH(51)";
    case NVA140_SET_MME_SHADOW_SCRATCH(52):
        return "NVA140_SET_MME_SHADOW_SCRATCH(52)";
    case NVA140_SET_MME_SHADOW_SCRATCH(53):
        return "NVA140_SET_MME_SHADOW_SCRATCH(53)";
    case NVA140_SET_MME_SHADOW_SCRATCH(54):
        return "NVA140_SET_MME_SHADOW_SCRATCH(54)";
    case NVA140_SET_MME_SHADOW_SCRATCH(55):
        return "NVA140_SET_MME_SHADOW_SCRATCH(55)";
    case NVA140_SET_MME_SHADOW_SCRATCH(56):
        return "NVA140_SET_MME_SHADOW_SCRATCH(56)";
    case NVA140_SET_MME_SHADOW_SCRATCH(57):
        return "NVA140_SET_MME_SHADOW_SCRATCH(57)";
    case NVA140_SET_MME_SHADOW_SCRATCH(58):
        return "NVA140_SET_MME_SHADOW_SCRATCH(58)";
    case NVA140_SET_MME_SHADOW_SCRATCH(59):
        return "NVA140_SET_MME_SHADOW_SCRATCH(59)";
    case NVA140_SET_MME_SHADOW_SCRATCH(60):
        return "NVA140_SET_MME_SHADOW_SCRATCH(60)";
    case NVA140_SET_MME_SHADOW_SCRATCH(61):
        return "NVA140_SET_MME_SHADOW_SCRATCH(61)";
    case NVA140_SET_MME_SHADOW_SCRATCH(62):
        return "NVA140_SET_MME_SHADOW_SCRATCH(62)";
    case NVA140_SET_MME_SHADOW_SCRATCH(63):
        return "NVA140_SET_MME_SHADOW_SCRATCH(63)";
    case NVA140_SET_MME_SHADOW_SCRATCH(64):
        return "NVA140_SET_MME_SHADOW_SCRATCH(64)";
    case NVA140_SET_MME_SHADOW_SCRATCH(65):
        return "NVA140_SET_MME_SHADOW_SCRATCH(65)";
    case NVA140_SET_MME_SHADOW_SCRATCH(66):
        return "NVA140_SET_MME_SHADOW_SCRATCH(66)";
    case NVA140_SET_MME_SHADOW_SCRATCH(67):
        return "NVA140_SET_MME_SHADOW_SCRATCH(67)";
    case NVA140_SET_MME_SHADOW_SCRATCH(68):
        return "NVA140_SET_MME_SHADOW_SCRATCH(68)";
    case NVA140_SET_MME_SHADOW_SCRATCH(69):
        return "NVA140_SET_MME_SHADOW_SCRATCH(69)";
    case NVA140_SET_MME_SHADOW_SCRATCH(70):
        return "NVA140_SET_MME_SHADOW_SCRATCH(70)";
    case NVA140_SET_MME_SHADOW_SCRATCH(71):
        return "NVA140_SET_MME_SHADOW_SCRATCH(71)";
    case NVA140_SET_MME_SHADOW_SCRATCH(72):
        return "NVA140_SET_MME_SHADOW_SCRATCH(72)";
    case NVA140_SET_MME_SHADOW_SCRATCH(73):
        return "NVA140_SET_MME_SHADOW_SCRATCH(73)";
    case NVA140_SET_MME_SHADOW_SCRATCH(74):
        return "NVA140_SET_MME_SHADOW_SCRATCH(74)";
    case NVA140_SET_MME_SHADOW_SCRATCH(75):
        return "NVA140_SET_MME_SHADOW_SCRATCH(75)";
    case NVA140_SET_MME_SHADOW_SCRATCH(76):
        return "NVA140_SET_MME_SHADOW_SCRATCH(76)";
    case NVA140_SET_MME_SHADOW_SCRATCH(77):
        return "NVA140_SET_MME_SHADOW_SCRATCH(77)";
    case NVA140_SET_MME_SHADOW_SCRATCH(78):
        return "NVA140_SET_MME_SHADOW_SCRATCH(78)";
    case NVA140_SET_MME_SHADOW_SCRATCH(79):
        return "NVA140_SET_MME_SHADOW_SCRATCH(79)";
    case NVA140_SET_MME_SHADOW_SCRATCH(80):
        return "NVA140_SET_MME_SHADOW_SCRATCH(80)";
    case NVA140_SET_MME_SHADOW_SCRATCH(81):
        return "NVA140_SET_MME_SHADOW_SCRATCH(81)";
    case NVA140_SET_MME_SHADOW_SCRATCH(82):
        return "NVA140_SET_MME_SHADOW_SCRATCH(82)";
    case NVA140_SET_MME_SHADOW_SCRATCH(83):
        return "NVA140_SET_MME_SHADOW_SCRATCH(83)";
    case NVA140_SET_MME_SHADOW_SCRATCH(84):
        return "NVA140_SET_MME_SHADOW_SCRATCH(84)";
    case NVA140_SET_MME_SHADOW_SCRATCH(85):
        return "NVA140_SET_MME_SHADOW_SCRATCH(85)";
    case NVA140_SET_MME_SHADOW_SCRATCH(86):
        return "NVA140_SET_MME_SHADOW_SCRATCH(86)";
    case NVA140_SET_MME_SHADOW_SCRATCH(87):
        return "NVA140_SET_MME_SHADOW_SCRATCH(87)";
    case NVA140_SET_MME_SHADOW_SCRATCH(88):
        return "NVA140_SET_MME_SHADOW_SCRATCH(88)";
    case NVA140_SET_MME_SHADOW_SCRATCH(89):
        return "NVA140_SET_MME_SHADOW_SCRATCH(89)";
    case NVA140_SET_MME_SHADOW_SCRATCH(90):
        return "NVA140_SET_MME_SHADOW_SCRATCH(90)";
    case NVA140_SET_MME_SHADOW_SCRATCH(91):
        return "NVA140_SET_MME_SHADOW_SCRATCH(91)";
    case NVA140_SET_MME_SHADOW_SCRATCH(92):
        return "NVA140_SET_MME_SHADOW_SCRATCH(92)";
    case NVA140_SET_MME_SHADOW_SCRATCH(93):
        return "NVA140_SET_MME_SHADOW_SCRATCH(93)";
    case NVA140_SET_MME_SHADOW_SCRATCH(94):
        return "NVA140_SET_MME_SHADOW_SCRATCH(94)";
    case NVA140_SET_MME_SHADOW_SCRATCH(95):
        return "NVA140_SET_MME_SHADOW_SCRATCH(95)";
    case NVA140_SET_MME_SHADOW_SCRATCH(96):
        return "NVA140_SET_MME_SHADOW_SCRATCH(96)";
    case NVA140_SET_MME_SHADOW_SCRATCH(97):
        return "NVA140_SET_MME_SHADOW_SCRATCH(97)";
    case NVA140_SET_MME_SHADOW_SCRATCH(98):
        return "NVA140_SET_MME_SHADOW_SCRATCH(98)";
    case NVA140_SET_MME_SHADOW_SCRATCH(99):
        return "NVA140_SET_MME_SHADOW_SCRATCH(99)";
    case NVA140_SET_MME_SHADOW_SCRATCH(100):
        return "NVA140_SET_MME_SHADOW_SCRATCH(100)";
    case NVA140_SET_MME_SHADOW_SCRATCH(101):
        return "NVA140_SET_MME_SHADOW_SCRATCH(101)";
    case NVA140_SET_MME_SHADOW_SCRATCH(102):
        return "NVA140_SET_MME_SHADOW_SCRATCH(102)";
    case NVA140_SET_MME_SHADOW_SCRATCH(103):
        return "NVA140_SET_MME_SHADOW_SCRATCH(103)";
    case NVA140_SET_MME_SHADOW_SCRATCH(104):
        return "NVA140_SET_MME_SHADOW_SCRATCH(104)";
    case NVA140_SET_MME_SHADOW_SCRATCH(105):
        return "NVA140_SET_MME_SHADOW_SCRATCH(105)";
    case NVA140_SET_MME_SHADOW_SCRATCH(106):
        return "NVA140_SET_MME_SHADOW_SCRATCH(106)";
    case NVA140_SET_MME_SHADOW_SCRATCH(107):
        return "NVA140_SET_MME_SHADOW_SCRATCH(107)";
    case NVA140_SET_MME_SHADOW_SCRATCH(108):
        return "NVA140_SET_MME_SHADOW_SCRATCH(108)";
    case NVA140_SET_MME_SHADOW_SCRATCH(109):
        return "NVA140_SET_MME_SHADOW_SCRATCH(109)";
    case NVA140_SET_MME_SHADOW_SCRATCH(110):
        return "NVA140_SET_MME_SHADOW_SCRATCH(110)";
    case NVA140_SET_MME_SHADOW_SCRATCH(111):
        return "NVA140_SET_MME_SHADOW_SCRATCH(111)";
    case NVA140_SET_MME_SHADOW_SCRATCH(112):
        return "NVA140_SET_MME_SHADOW_SCRATCH(112)";
    case NVA140_SET_MME_SHADOW_SCRATCH(113):
        return "NVA140_SET_MME_SHADOW_SCRATCH(113)";
    case NVA140_SET_MME_SHADOW_SCRATCH(114):
        return "NVA140_SET_MME_SHADOW_SCRATCH(114)";
    case NVA140_SET_MME_SHADOW_SCRATCH(115):
        return "NVA140_SET_MME_SHADOW_SCRATCH(115)";
    case NVA140_SET_MME_SHADOW_SCRATCH(116):
        return "NVA140_SET_MME_SHADOW_SCRATCH(116)";
    case NVA140_SET_MME_SHADOW_SCRATCH(117):
        return "NVA140_SET_MME_SHADOW_SCRATCH(117)";
    case NVA140_SET_MME_SHADOW_SCRATCH(118):
        return "NVA140_SET_MME_SHADOW_SCRATCH(118)";
    case NVA140_SET_MME_SHADOW_SCRATCH(119):
        return "NVA140_SET_MME_SHADOW_SCRATCH(119)";
    case NVA140_SET_MME_SHADOW_SCRATCH(120):
        return "NVA140_SET_MME_SHADOW_SCRATCH(120)";
    case NVA140_SET_MME_SHADOW_SCRATCH(121):
        return "NVA140_SET_MME_SHADOW_SCRATCH(121)";
    case NVA140_SET_MME_SHADOW_SCRATCH(122):
        return "NVA140_SET_MME_SHADOW_SCRATCH(122)";
    case NVA140_SET_MME_SHADOW_SCRATCH(123):
        return "NVA140_SET_MME_SHADOW_SCRATCH(123)";
    case NVA140_SET_MME_SHADOW_SCRATCH(124):
        return "NVA140_SET_MME_SHADOW_SCRATCH(124)";
    case NVA140_SET_MME_SHADOW_SCRATCH(125):
        return "NVA140_SET_MME_SHADOW_SCRATCH(125)";
    case NVA140_SET_MME_SHADOW_SCRATCH(126):
        return "NVA140_SET_MME_SHADOW_SCRATCH(126)";
    case NVA140_SET_MME_SHADOW_SCRATCH(127):
        return "NVA140_SET_MME_SHADOW_SCRATCH(127)";
    case NVA140_SET_MME_SHADOW_SCRATCH(128):
        return "NVA140_SET_MME_SHADOW_SCRATCH(128)";
    case NVA140_SET_MME_SHADOW_SCRATCH(129):
        return "NVA140_SET_MME_SHADOW_SCRATCH(129)";
    case NVA140_SET_MME_SHADOW_SCRATCH(130):
        return "NVA140_SET_MME_SHADOW_SCRATCH(130)";
    case NVA140_SET_MME_SHADOW_SCRATCH(131):
        return "NVA140_SET_MME_SHADOW_SCRATCH(131)";
    case NVA140_SET_MME_SHADOW_SCRATCH(132):
        return "NVA140_SET_MME_SHADOW_SCRATCH(132)";
    case NVA140_SET_MME_SHADOW_SCRATCH(133):
        return "NVA140_SET_MME_SHADOW_SCRATCH(133)";
    case NVA140_SET_MME_SHADOW_SCRATCH(134):
        return "NVA140_SET_MME_SHADOW_SCRATCH(134)";
    case NVA140_SET_MME_SHADOW_SCRATCH(135):
        return "NVA140_SET_MME_SHADOW_SCRATCH(135)";
    case NVA140_SET_MME_SHADOW_SCRATCH(136):
        return "NVA140_SET_MME_SHADOW_SCRATCH(136)";
    case NVA140_SET_MME_SHADOW_SCRATCH(137):
        return "NVA140_SET_MME_SHADOW_SCRATCH(137)";
    case NVA140_SET_MME_SHADOW_SCRATCH(138):
        return "NVA140_SET_MME_SHADOW_SCRATCH(138)";
    case NVA140_SET_MME_SHADOW_SCRATCH(139):
        return "NVA140_SET_MME_SHADOW_SCRATCH(139)";
    case NVA140_SET_MME_SHADOW_SCRATCH(140):
        return "NVA140_SET_MME_SHADOW_SCRATCH(140)";
    case NVA140_SET_MME_SHADOW_SCRATCH(141):
        return "NVA140_SET_MME_SHADOW_SCRATCH(141)";
    case NVA140_SET_MME_SHADOW_SCRATCH(142):
        return "NVA140_SET_MME_SHADOW_SCRATCH(142)";
    case NVA140_SET_MME_SHADOW_SCRATCH(143):
        return "NVA140_SET_MME_SHADOW_SCRATCH(143)";
    case NVA140_SET_MME_SHADOW_SCRATCH(144):
        return "NVA140_SET_MME_SHADOW_SCRATCH(144)";
    case NVA140_SET_MME_SHADOW_SCRATCH(145):
        return "NVA140_SET_MME_SHADOW_SCRATCH(145)";
    case NVA140_SET_MME_SHADOW_SCRATCH(146):
        return "NVA140_SET_MME_SHADOW_SCRATCH(146)";
    case NVA140_SET_MME_SHADOW_SCRATCH(147):
        return "NVA140_SET_MME_SHADOW_SCRATCH(147)";
    case NVA140_SET_MME_SHADOW_SCRATCH(148):
        return "NVA140_SET_MME_SHADOW_SCRATCH(148)";
    case NVA140_SET_MME_SHADOW_SCRATCH(149):
        return "NVA140_SET_MME_SHADOW_SCRATCH(149)";
    case NVA140_SET_MME_SHADOW_SCRATCH(150):
        return "NVA140_SET_MME_SHADOW_SCRATCH(150)";
    case NVA140_SET_MME_SHADOW_SCRATCH(151):
        return "NVA140_SET_MME_SHADOW_SCRATCH(151)";
    case NVA140_SET_MME_SHADOW_SCRATCH(152):
        return "NVA140_SET_MME_SHADOW_SCRATCH(152)";
    case NVA140_SET_MME_SHADOW_SCRATCH(153):
        return "NVA140_SET_MME_SHADOW_SCRATCH(153)";
    case NVA140_SET_MME_SHADOW_SCRATCH(154):
        return "NVA140_SET_MME_SHADOW_SCRATCH(154)";
    case NVA140_SET_MME_SHADOW_SCRATCH(155):
        return "NVA140_SET_MME_SHADOW_SCRATCH(155)";
    case NVA140_SET_MME_SHADOW_SCRATCH(156):
        return "NVA140_SET_MME_SHADOW_SCRATCH(156)";
    case NVA140_SET_MME_SHADOW_SCRATCH(157):
        return "NVA140_SET_MME_SHADOW_SCRATCH(157)";
    case NVA140_SET_MME_SHADOW_SCRATCH(158):
        return "NVA140_SET_MME_SHADOW_SCRATCH(158)";
    case NVA140_SET_MME_SHADOW_SCRATCH(159):
        return "NVA140_SET_MME_SHADOW_SCRATCH(159)";
    case NVA140_SET_MME_SHADOW_SCRATCH(160):
        return "NVA140_SET_MME_SHADOW_SCRATCH(160)";
    case NVA140_SET_MME_SHADOW_SCRATCH(161):
        return "NVA140_SET_MME_SHADOW_SCRATCH(161)";
    case NVA140_SET_MME_SHADOW_SCRATCH(162):
        return "NVA140_SET_MME_SHADOW_SCRATCH(162)";
    case NVA140_SET_MME_SHADOW_SCRATCH(163):
        return "NVA140_SET_MME_SHADOW_SCRATCH(163)";
    case NVA140_SET_MME_SHADOW_SCRATCH(164):
        return "NVA140_SET_MME_SHADOW_SCRATCH(164)";
    case NVA140_SET_MME_SHADOW_SCRATCH(165):
        return "NVA140_SET_MME_SHADOW_SCRATCH(165)";
    case NVA140_SET_MME_SHADOW_SCRATCH(166):
        return "NVA140_SET_MME_SHADOW_SCRATCH(166)";
    case NVA140_SET_MME_SHADOW_SCRATCH(167):
        return "NVA140_SET_MME_SHADOW_SCRATCH(167)";
    case NVA140_SET_MME_SHADOW_SCRATCH(168):
        return "NVA140_SET_MME_SHADOW_SCRATCH(168)";
    case NVA140_SET_MME_SHADOW_SCRATCH(169):
        return "NVA140_SET_MME_SHADOW_SCRATCH(169)";
    case NVA140_SET_MME_SHADOW_SCRATCH(170):
        return "NVA140_SET_MME_SHADOW_SCRATCH(170)";
    case NVA140_SET_MME_SHADOW_SCRATCH(171):
        return "NVA140_SET_MME_SHADOW_SCRATCH(171)";
    case NVA140_SET_MME_SHADOW_SCRATCH(172):
        return "NVA140_SET_MME_SHADOW_SCRATCH(172)";
    case NVA140_SET_MME_SHADOW_SCRATCH(173):
        return "NVA140_SET_MME_SHADOW_SCRATCH(173)";
    case NVA140_SET_MME_SHADOW_SCRATCH(174):
        return "NVA140_SET_MME_SHADOW_SCRATCH(174)";
    case NVA140_SET_MME_SHADOW_SCRATCH(175):
        return "NVA140_SET_MME_SHADOW_SCRATCH(175)";
    case NVA140_SET_MME_SHADOW_SCRATCH(176):
        return "NVA140_SET_MME_SHADOW_SCRATCH(176)";
    case NVA140_SET_MME_SHADOW_SCRATCH(177):
        return "NVA140_SET_MME_SHADOW_SCRATCH(177)";
    case NVA140_SET_MME_SHADOW_SCRATCH(178):
        return "NVA140_SET_MME_SHADOW_SCRATCH(178)";
    case NVA140_SET_MME_SHADOW_SCRATCH(179):
        return "NVA140_SET_MME_SHADOW_SCRATCH(179)";
    case NVA140_SET_MME_SHADOW_SCRATCH(180):
        return "NVA140_SET_MME_SHADOW_SCRATCH(180)";
    case NVA140_SET_MME_SHADOW_SCRATCH(181):
        return "NVA140_SET_MME_SHADOW_SCRATCH(181)";
    case NVA140_SET_MME_SHADOW_SCRATCH(182):
        return "NVA140_SET_MME_SHADOW_SCRATCH(182)";
    case NVA140_SET_MME_SHADOW_SCRATCH(183):
        return "NVA140_SET_MME_SHADOW_SCRATCH(183)";
    case NVA140_SET_MME_SHADOW_SCRATCH(184):
        return "NVA140_SET_MME_SHADOW_SCRATCH(184)";
    case NVA140_SET_MME_SHADOW_SCRATCH(185):
        return "NVA140_SET_MME_SHADOW_SCRATCH(185)";
    case NVA140_SET_MME_SHADOW_SCRATCH(186):
        return "NVA140_SET_MME_SHADOW_SCRATCH(186)";
    case NVA140_SET_MME_SHADOW_SCRATCH(187):
        return "NVA140_SET_MME_SHADOW_SCRATCH(187)";
    case NVA140_SET_MME_SHADOW_SCRATCH(188):
        return "NVA140_SET_MME_SHADOW_SCRATCH(188)";
    case NVA140_SET_MME_SHADOW_SCRATCH(189):
        return "NVA140_SET_MME_SHADOW_SCRATCH(189)";
    case NVA140_SET_MME_SHADOW_SCRATCH(190):
        return "NVA140_SET_MME_SHADOW_SCRATCH(190)";
    case NVA140_SET_MME_SHADOW_SCRATCH(191):
        return "NVA140_SET_MME_SHADOW_SCRATCH(191)";
    case NVA140_SET_MME_SHADOW_SCRATCH(192):
        return "NVA140_SET_MME_SHADOW_SCRATCH(192)";
    case NVA140_SET_MME_SHADOW_SCRATCH(193):
        return "NVA140_SET_MME_SHADOW_SCRATCH(193)";
    case NVA140_SET_MME_SHADOW_SCRATCH(194):
        return "NVA140_SET_MME_SHADOW_SCRATCH(194)";
    case NVA140_SET_MME_SHADOW_SCRATCH(195):
        return "NVA140_SET_MME_SHADOW_SCRATCH(195)";
    case NVA140_SET_MME_SHADOW_SCRATCH(196):
        return "NVA140_SET_MME_SHADOW_SCRATCH(196)";
    case NVA140_SET_MME_SHADOW_SCRATCH(197):
        return "NVA140_SET_MME_SHADOW_SCRATCH(197)";
    case NVA140_SET_MME_SHADOW_SCRATCH(198):
        return "NVA140_SET_MME_SHADOW_SCRATCH(198)";
    case NVA140_SET_MME_SHADOW_SCRATCH(199):
        return "NVA140_SET_MME_SHADOW_SCRATCH(199)";
    case NVA140_SET_MME_SHADOW_SCRATCH(200):
        return "NVA140_SET_MME_SHADOW_SCRATCH(200)";
    case NVA140_SET_MME_SHADOW_SCRATCH(201):
        return "NVA140_SET_MME_SHADOW_SCRATCH(201)";
    case NVA140_SET_MME_SHADOW_SCRATCH(202):
        return "NVA140_SET_MME_SHADOW_SCRATCH(202)";
    case NVA140_SET_MME_SHADOW_SCRATCH(203):
        return "NVA140_SET_MME_SHADOW_SCRATCH(203)";
    case NVA140_SET_MME_SHADOW_SCRATCH(204):
        return "NVA140_SET_MME_SHADOW_SCRATCH(204)";
    case NVA140_SET_MME_SHADOW_SCRATCH(205):
        return "NVA140_SET_MME_SHADOW_SCRATCH(205)";
    case NVA140_SET_MME_SHADOW_SCRATCH(206):
        return "NVA140_SET_MME_SHADOW_SCRATCH(206)";
    case NVA140_SET_MME_SHADOW_SCRATCH(207):
        return "NVA140_SET_MME_SHADOW_SCRATCH(207)";
    case NVA140_SET_MME_SHADOW_SCRATCH(208):
        return "NVA140_SET_MME_SHADOW_SCRATCH(208)";
    case NVA140_SET_MME_SHADOW_SCRATCH(209):
        return "NVA140_SET_MME_SHADOW_SCRATCH(209)";
    case NVA140_SET_MME_SHADOW_SCRATCH(210):
        return "NVA140_SET_MME_SHADOW_SCRATCH(210)";
    case NVA140_SET_MME_SHADOW_SCRATCH(211):
        return "NVA140_SET_MME_SHADOW_SCRATCH(211)";
    case NVA140_SET_MME_SHADOW_SCRATCH(212):
        return "NVA140_SET_MME_SHADOW_SCRATCH(212)";
    case NVA140_SET_MME_SHADOW_SCRATCH(213):
        return "NVA140_SET_MME_SHADOW_SCRATCH(213)";
    case NVA140_SET_MME_SHADOW_SCRATCH(214):
        return "NVA140_SET_MME_SHADOW_SCRATCH(214)";
    case NVA140_SET_MME_SHADOW_SCRATCH(215):
        return "NVA140_SET_MME_SHADOW_SCRATCH(215)";
    case NVA140_SET_MME_SHADOW_SCRATCH(216):
        return "NVA140_SET_MME_SHADOW_SCRATCH(216)";
    case NVA140_SET_MME_SHADOW_SCRATCH(217):
        return "NVA140_SET_MME_SHADOW_SCRATCH(217)";
    case NVA140_SET_MME_SHADOW_SCRATCH(218):
        return "NVA140_SET_MME_SHADOW_SCRATCH(218)";
    case NVA140_SET_MME_SHADOW_SCRATCH(219):
        return "NVA140_SET_MME_SHADOW_SCRATCH(219)";
    case NVA140_SET_MME_SHADOW_SCRATCH(220):
        return "NVA140_SET_MME_SHADOW_SCRATCH(220)";
    case NVA140_SET_MME_SHADOW_SCRATCH(221):
        return "NVA140_SET_MME_SHADOW_SCRATCH(221)";
    case NVA140_SET_MME_SHADOW_SCRATCH(222):
        return "NVA140_SET_MME_SHADOW_SCRATCH(222)";
    case NVA140_SET_MME_SHADOW_SCRATCH(223):
        return "NVA140_SET_MME_SHADOW_SCRATCH(223)";
    case NVA140_SET_MME_SHADOW_SCRATCH(224):
        return "NVA140_SET_MME_SHADOW_SCRATCH(224)";
    case NVA140_SET_MME_SHADOW_SCRATCH(225):
        return "NVA140_SET_MME_SHADOW_SCRATCH(225)";
    case NVA140_SET_MME_SHADOW_SCRATCH(226):
        return "NVA140_SET_MME_SHADOW_SCRATCH(226)";
    case NVA140_SET_MME_SHADOW_SCRATCH(227):
        return "NVA140_SET_MME_SHADOW_SCRATCH(227)";
    case NVA140_SET_MME_SHADOW_SCRATCH(228):
        return "NVA140_SET_MME_SHADOW_SCRATCH(228)";
    case NVA140_SET_MME_SHADOW_SCRATCH(229):
        return "NVA140_SET_MME_SHADOW_SCRATCH(229)";
    case NVA140_SET_MME_SHADOW_SCRATCH(230):
        return "NVA140_SET_MME_SHADOW_SCRATCH(230)";
    case NVA140_SET_MME_SHADOW_SCRATCH(231):
        return "NVA140_SET_MME_SHADOW_SCRATCH(231)";
    case NVA140_SET_MME_SHADOW_SCRATCH(232):
        return "NVA140_SET_MME_SHADOW_SCRATCH(232)";
    case NVA140_SET_MME_SHADOW_SCRATCH(233):
        return "NVA140_SET_MME_SHADOW_SCRATCH(233)";
    case NVA140_SET_MME_SHADOW_SCRATCH(234):
        return "NVA140_SET_MME_SHADOW_SCRATCH(234)";
    case NVA140_SET_MME_SHADOW_SCRATCH(235):
        return "NVA140_SET_MME_SHADOW_SCRATCH(235)";
    case NVA140_SET_MME_SHADOW_SCRATCH(236):
        return "NVA140_SET_MME_SHADOW_SCRATCH(236)";
    case NVA140_SET_MME_SHADOW_SCRATCH(237):
        return "NVA140_SET_MME_SHADOW_SCRATCH(237)";
    case NVA140_SET_MME_SHADOW_SCRATCH(238):
        return "NVA140_SET_MME_SHADOW_SCRATCH(238)";
    case NVA140_SET_MME_SHADOW_SCRATCH(239):
        return "NVA140_SET_MME_SHADOW_SCRATCH(239)";
    case NVA140_SET_MME_SHADOW_SCRATCH(240):
        return "NVA140_SET_MME_SHADOW_SCRATCH(240)";
    case NVA140_SET_MME_SHADOW_SCRATCH(241):
        return "NVA140_SET_MME_SHADOW_SCRATCH(241)";
    case NVA140_SET_MME_SHADOW_SCRATCH(242):
        return "NVA140_SET_MME_SHADOW_SCRATCH(242)";
    case NVA140_SET_MME_SHADOW_SCRATCH(243):
        return "NVA140_SET_MME_SHADOW_SCRATCH(243)";
    case NVA140_SET_MME_SHADOW_SCRATCH(244):
        return "NVA140_SET_MME_SHADOW_SCRATCH(244)";
    case NVA140_SET_MME_SHADOW_SCRATCH(245):
        return "NVA140_SET_MME_SHADOW_SCRATCH(245)";
    case NVA140_SET_MME_SHADOW_SCRATCH(246):
        return "NVA140_SET_MME_SHADOW_SCRATCH(246)";
    case NVA140_SET_MME_SHADOW_SCRATCH(247):
        return "NVA140_SET_MME_SHADOW_SCRATCH(247)";
    case NVA140_SET_MME_SHADOW_SCRATCH(248):
        return "NVA140_SET_MME_SHADOW_SCRATCH(248)";
    case NVA140_SET_MME_SHADOW_SCRATCH(249):
        return "NVA140_SET_MME_SHADOW_SCRATCH(249)";
    case NVA140_SET_MME_SHADOW_SCRATCH(250):
        return "NVA140_SET_MME_SHADOW_SCRATCH(250)";
    case NVA140_SET_MME_SHADOW_SCRATCH(251):
        return "NVA140_SET_MME_SHADOW_SCRATCH(251)";
    case NVA140_SET_MME_SHADOW_SCRATCH(252):
        return "NVA140_SET_MME_SHADOW_SCRATCH(252)";
    case NVA140_SET_MME_SHADOW_SCRATCH(253):
        return "NVA140_SET_MME_SHADOW_SCRATCH(253)";
    case NVA140_SET_MME_SHADOW_SCRATCH(254):
        return "NVA140_SET_MME_SHADOW_SCRATCH(254)";
    case NVA140_SET_MME_SHADOW_SCRATCH(255):
        return "NVA140_SET_MME_SHADOW_SCRATCH(255)";
    default:
        return "unknown method";
    }
}

void
P_DUMP_NVA140_MTHD_DATA(FILE *fp, uint16_t idx, uint32_t data,
                         const char *prefix)
{
    uint32_t parsed;
    switch (idx) {
    case NVA140_SET_OBJECT:
    
        parsed = (data >> 0) & ((1u << 16) - 1);
        fprintf(fp, "%s.CLASS_ID = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
    
        parsed = (data >> 16) & ((1u << 5) - 1);
        fprintf(fp, "%s.ENGINE_ID = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVA140_NO_OPERATION:
    
        parsed = data;
        fprintf(fp, "%s.V = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVA140_SET_NOTIFY_A:
    
        parsed = (data >> 0) & ((1u << 25) - 1);
        fprintf(fp, "%s.ADDRESS_UPPER = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVA140_SET_NOTIFY_B:
    
        parsed = data;
        fprintf(fp, "%s.ADDRESS_LOWER = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVA140_NOTIFY:
    
        parsed = data;
        fprintf(fp, "%s.TYPE = ", prefix);
        switch (parsed) {
        case NVA140_NOTIFY_TYPE_WRITE_ONLY:
            fprintf(fp, "WRITE_ONLY\n");
            break;
        case NVA140_NOTIFY_TYPE_WRITE_THEN_AWAKEN:
            fprintf(fp, "WRITE_THEN_AWAKEN\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
        break;
    case NVA140_WAIT_FOR_IDLE:
    
        parsed = data;
        fprintf(fp, "%s.V = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVA140_SET_GLOBAL_RENDER_ENABLE_A:
    
        parsed = (data >> 0) & ((1u << 8) - 1);
        fprintf(fp, "%s.OFFSET_UPPER = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVA140_SET_GLOBAL_RENDER_ENABLE_B:
    
        parsed = data;
        fprintf(fp, "%s.OFFSET_LOWER = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVA140_SET_GLOBAL_RENDER_ENABLE_C:
    
        parsed = (data >> 0) & ((1u << 3) - 1);
        fprintf(fp, "%s.MODE = ", prefix);
        switch (parsed) {
        case NVA140_SET_GLOBAL_RENDER_ENABLE_C_MODE_FALSE:
            fprintf(fp, "FALSE\n");
            break;
        case NVA140_SET_GLOBAL_RENDER_ENABLE_C_MODE_TRUE:
            fprintf(fp, "TRUE\n");
            break;
        case NVA140_SET_GLOBAL_RENDER_ENABLE_C_MODE_CONDITIONAL:
            fprintf(fp, "CONDITIONAL\n");
            break;
        case NVA140_SET_GLOBAL_RENDER_ENABLE_C_MODE_RENDER_IF_EQUAL:
            fprintf(fp, "RENDER_IF_EQUAL\n");
            break;
        case NVA140_SET_GLOBAL_RENDER_ENABLE_C_MODE_RENDER_IF_NOT_EQUAL:
            fprintf(fp, "RENDER_IF_NOT_EQUAL\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
        break;
    case NVA140_SEND_GO_IDLE:
    
        parsed = data;
        fprintf(fp, "%s.V = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVA140_PM_TRIGGER:
    
        parsed = data;
        fprintf(fp, "%s.V = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVA140_PM_TRIGGER_WFI:
    
        parsed = data;
        fprintf(fp, "%s.V = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVA140_SET_INSTRUMENTATION_METHOD_HEADER:
    
        parsed = data;
        fprintf(fp, "%s.V = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVA140_SET_INSTRUMENTATION_METHOD_DATA:
    
        parsed = data;
        fprintf(fp, "%s.V = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVA140_LINE_LENGTH_IN:
    
        parsed = data;
        fprintf(fp, "%s.VALUE = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVA140_LINE_COUNT:
    
        parsed = data;
        fprintf(fp, "%s.VALUE = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVA140_OFFSET_OUT_UPPER:
    
        parsed = (data >> 0) & ((1u << 25) - 1);
        fprintf(fp, "%s.VALUE = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVA140_OFFSET_OUT:
    
        parsed = data;
        fprintf(fp, "%s.VALUE = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVA140_PITCH_OUT:
    
        parsed = data;
        fprintf(fp, "%s.VALUE = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVA140_SET_DST_BLOCK_SIZE:
    
        parsed = (data >> 0) & ((1u << 4) - 1);
        fprintf(fp, "%s.WIDTH = ", prefix);
        switch (parsed) {
        case NVA140_SET_DST_BLOCK_SIZE_WIDTH_ONE_GOB:
            fprintf(fp, "ONE_GOB\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
    
        parsed = (data >> 4) & ((1u << 4) - 1);
        fprintf(fp, "%s.HEIGHT = ", prefix);
        switch (parsed) {
        case NVA140_SET_DST_BLOCK_SIZE_HEIGHT_ONE_GOB:
            fprintf(fp, "ONE_GOB\n");
            break;
        case NVA140_SET_DST_BLOCK_SIZE_HEIGHT_TWO_GOBS:
            fprintf(fp, "TWO_GOBS\n");
            break;
        case NVA140_SET_DST_BLOCK_SIZE_HEIGHT_FOUR_GOBS:
            fprintf(fp, "FOUR_GOBS\n");
            break;
        case NVA140_SET_DST_BLOCK_SIZE_HEIGHT_EIGHT_GOBS:
            fprintf(fp, "EIGHT_GOBS\n");
            break;
        case NVA140_SET_DST_BLOCK_SIZE_HEIGHT_SIXTEEN_GOBS:
            fprintf(fp, "SIXTEEN_GOBS\n");
            break;
        case NVA140_SET_DST_BLOCK_SIZE_HEIGHT_THIRTYTWO_GOBS:
            fprintf(fp, "THIRTYTWO_GOBS\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
    
        parsed = (data >> 8) & ((1u << 4) - 1);
        fprintf(fp, "%s.DEPTH = ", prefix);
        switch (parsed) {
        case NVA140_SET_DST_BLOCK_SIZE_DEPTH_ONE_GOB:
            fprintf(fp, "ONE_GOB\n");
            break;
        case NVA140_SET_DST_BLOCK_SIZE_DEPTH_TWO_GOBS:
            fprintf(fp, "TWO_GOBS\n");
            break;
        case NVA140_SET_DST_BLOCK_SIZE_DEPTH_FOUR_GOBS:
            fprintf(fp, "FOUR_GOBS\n");
            break;
        case NVA140_SET_DST_BLOCK_SIZE_DEPTH_EIGHT_GOBS:
            fprintf(fp, "EIGHT_GOBS\n");
            break;
        case NVA140_SET_DST_BLOCK_SIZE_DEPTH_SIXTEEN_GOBS:
            fprintf(fp, "SIXTEEN_GOBS\n");
            break;
        case NVA140_SET_DST_BLOCK_SIZE_DEPTH_THIRTYTWO_GOBS:
            fprintf(fp, "THIRTYTWO_GOBS\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
        break;
    case NVA140_SET_DST_WIDTH:
    
        parsed = data;
        fprintf(fp, "%s.V = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVA140_SET_DST_HEIGHT:
    
        parsed = data;
        fprintf(fp, "%s.V = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVA140_SET_DST_DEPTH:
    
        parsed = data;
        fprintf(fp, "%s.V = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVA140_SET_DST_LAYER:
    
        parsed = data;
        fprintf(fp, "%s.V = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVA140_SET_DST_ORIGIN_BYTES_X:
    
        parsed = (data >> 0) & ((1u << 21) - 1);
        fprintf(fp, "%s.V = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVA140_SET_DST_ORIGIN_SAMPLES_Y:
    
        parsed = (data >> 0) & ((1u << 17) - 1);
        fprintf(fp, "%s.V = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVA140_LAUNCH_DMA:
    
        parsed = (data >> 0) & ((1u << 1) - 1);
        fprintf(fp, "%s.DST_MEMORY_LAYOUT = ", prefix);
        switch (parsed) {
        case NVA140_LAUNCH_DMA_DST_MEMORY_LAYOUT_BLOCKLINEAR:
            fprintf(fp, "BLOCKLINEAR\n");
            break;
        case NVA140_LAUNCH_DMA_DST_MEMORY_LAYOUT_PITCH:
            fprintf(fp, "PITCH\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
    
        parsed = (data >> 4) & ((1u << 2) - 1);
        fprintf(fp, "%s.COMPLETION_TYPE = ", prefix);
        switch (parsed) {
        case NVA140_LAUNCH_DMA_COMPLETION_TYPE_FLUSH_DISABLE:
            fprintf(fp, "FLUSH_DISABLE\n");
            break;
        case NVA140_LAUNCH_DMA_COMPLETION_TYPE_FLUSH_ONLY:
            fprintf(fp, "FLUSH_ONLY\n");
            break;
        case NVA140_LAUNCH_DMA_COMPLETION_TYPE_RELEASE_SEMAPHORE:
            fprintf(fp, "RELEASE_SEMAPHORE\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
    
        parsed = (data >> 8) & ((1u << 2) - 1);
        fprintf(fp, "%s.INTERRUPT_TYPE = ", prefix);
        switch (parsed) {
        case NVA140_LAUNCH_DMA_INTERRUPT_TYPE_NONE:
            fprintf(fp, "NONE\n");
            break;
        case NVA140_LAUNCH_DMA_INTERRUPT_TYPE_INTERRUPT:
            fprintf(fp, "INTERRUPT\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
    
        parsed = (data >> 12) & ((1u << 1) - 1);
        fprintf(fp, "%s.SEMAPHORE_STRUCT_SIZE = ", prefix);
        switch (parsed) {
        case NVA140_LAUNCH_DMA_SEMAPHORE_STRUCT_SIZE_FOUR_WORDS:
            fprintf(fp, "FOUR_WORDS\n");
            break;
        case NVA140_LAUNCH_DMA_SEMAPHORE_STRUCT_SIZE_ONE_WORD:
            fprintf(fp, "ONE_WORD\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
    
        parsed = (data >> 1) & ((1u << 1) - 1);
        fprintf(fp, "%s.REDUCTION_ENABLE = ", prefix);
        switch (parsed) {
        case NVA140_LAUNCH_DMA_REDUCTION_ENABLE_FALSE:
            fprintf(fp, "FALSE\n");
            break;
        case NVA140_LAUNCH_DMA_REDUCTION_ENABLE_TRUE:
            fprintf(fp, "TRUE\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
    
        parsed = (data >> 13) & ((1u << 3) - 1);
        fprintf(fp, "%s.REDUCTION_OP = ", prefix);
        switch (parsed) {
        case NVA140_LAUNCH_DMA_REDUCTION_OP_RED_ADD:
            fprintf(fp, "RED_ADD\n");
            break;
        case NVA140_LAUNCH_DMA_REDUCTION_OP_RED_MIN:
            fprintf(fp, "RED_MIN\n");
            break;
        case NVA140_LAUNCH_DMA_REDUCTION_OP_RED_MAX:
            fprintf(fp, "RED_MAX\n");
            break;
        case NVA140_LAUNCH_DMA_REDUCTION_OP_RED_INC:
            fprintf(fp, "RED_INC\n");
            break;
        case NVA140_LAUNCH_DMA_REDUCTION_OP_RED_DEC:
            fprintf(fp, "RED_DEC\n");
            break;
        case NVA140_LAUNCH_DMA_REDUCTION_OP_RED_AND:
            fprintf(fp, "RED_AND\n");
            break;
        case NVA140_LAUNCH_DMA_REDUCTION_OP_RED_OR:
            fprintf(fp, "RED_OR\n");
            break;
        case NVA140_LAUNCH_DMA_REDUCTION_OP_RED_XOR:
            fprintf(fp, "RED_XOR\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
    
        parsed = (data >> 2) & ((1u << 2) - 1);
        fprintf(fp, "%s.REDUCTION_FORMAT = ", prefix);
        switch (parsed) {
        case NVA140_LAUNCH_DMA_REDUCTION_FORMAT_UNSIGNED_32:
            fprintf(fp, "UNSIGNED_32\n");
            break;
        case NVA140_LAUNCH_DMA_REDUCTION_FORMAT_SIGNED_32:
            fprintf(fp, "SIGNED_32\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
    
        parsed = (data >> 6) & ((1u << 1) - 1);
        fprintf(fp, "%s.SYSMEMBAR_DISABLE = ", prefix);
        switch (parsed) {
        case NVA140_LAUNCH_DMA_SYSMEMBAR_DISABLE_FALSE:
            fprintf(fp, "FALSE\n");
            break;
        case NVA140_LAUNCH_DMA_SYSMEMBAR_DISABLE_TRUE:
            fprintf(fp, "TRUE\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
        break;
    case NVA140_LOAD_INLINE_DATA:
    
        parsed = data;
        fprintf(fp, "%s.V = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVA140_SET_I2M_SEMAPHORE_A:
    
        parsed = (data >> 0) & ((1u << 25) - 1);
        fprintf(fp, "%s.OFFSET_UPPER = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVA140_SET_I2M_SEMAPHORE_B:
    
        parsed = data;
        fprintf(fp, "%s.OFFSET_LOWER = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVA140_SET_I2M_SEMAPHORE_C:
    
        parsed = data;
        fprintf(fp, "%s.PAYLOAD = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVA140_SET_I2M_SPARE_NOOP00:
    
        parsed = data;
        fprintf(fp, "%s.V = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVA140_SET_I2M_SPARE_NOOP01:
    
        parsed = data;
        fprintf(fp, "%s.V = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVA140_SET_I2M_SPARE_NOOP02:
    
        parsed = data;
        fprintf(fp, "%s.V = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVA140_SET_I2M_SPARE_NOOP03:
    
        parsed = data;
        fprintf(fp, "%s.V = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVA140_SET_FALCON00:
    
        parsed = data;
        fprintf(fp, "%s.V = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVA140_SET_FALCON01:
    
        parsed = data;
        fprintf(fp, "%s.V = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVA140_SET_FALCON02:
    
        parsed = data;
        fprintf(fp, "%s.V = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVA140_SET_FALCON03:
    
        parsed = data;
        fprintf(fp, "%s.V = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVA140_SET_FALCON04:
    
        parsed = data;
        fprintf(fp, "%s.V = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVA140_SET_FALCON05:
    
        parsed = data;
        fprintf(fp, "%s.V = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVA140_SET_FALCON06:
    
        parsed = data;
        fprintf(fp, "%s.V = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVA140_SET_FALCON07:
    
        parsed = data;
        fprintf(fp, "%s.V = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVA140_SET_FALCON08:
    
        parsed = data;
        fprintf(fp, "%s.V = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVA140_SET_FALCON09:
    
        parsed = data;
        fprintf(fp, "%s.V = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVA140_SET_FALCON10:
    
        parsed = data;
        fprintf(fp, "%s.V = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVA140_SET_FALCON11:
    
        parsed = data;
        fprintf(fp, "%s.V = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVA140_SET_FALCON12:
    
        parsed = data;
        fprintf(fp, "%s.V = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVA140_SET_FALCON13:
    
        parsed = data;
        fprintf(fp, "%s.V = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVA140_SET_FALCON14:
    
        parsed = data;
        fprintf(fp, "%s.V = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVA140_SET_FALCON15:
    
        parsed = data;
        fprintf(fp, "%s.V = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVA140_SET_FALCON16:
    
        parsed = data;
        fprintf(fp, "%s.V = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVA140_SET_FALCON17:
    
        parsed = data;
        fprintf(fp, "%s.V = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVA140_SET_FALCON18:
    
        parsed = data;
        fprintf(fp, "%s.V = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVA140_SET_FALCON19:
    
        parsed = data;
        fprintf(fp, "%s.V = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVA140_SET_FALCON20:
    
        parsed = data;
        fprintf(fp, "%s.V = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVA140_SET_FALCON21:
    
        parsed = data;
        fprintf(fp, "%s.V = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVA140_SET_FALCON22:
    
        parsed = data;
        fprintf(fp, "%s.V = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVA140_SET_FALCON23:
    
        parsed = data;
        fprintf(fp, "%s.V = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVA140_SET_FALCON24:
    
        parsed = data;
        fprintf(fp, "%s.V = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVA140_SET_FALCON25:
    
        parsed = data;
        fprintf(fp, "%s.V = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVA140_SET_FALCON26:
    
        parsed = data;
        fprintf(fp, "%s.V = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVA140_SET_FALCON27:
    
        parsed = data;
        fprintf(fp, "%s.V = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVA140_SET_FALCON28:
    
        parsed = data;
        fprintf(fp, "%s.V = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVA140_SET_FALCON29:
    
        parsed = data;
        fprintf(fp, "%s.V = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVA140_SET_FALCON30:
    
        parsed = data;
        fprintf(fp, "%s.V = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVA140_SET_FALCON31:
    
        parsed = data;
        fprintf(fp, "%s.V = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVA140_SET_RENDER_ENABLE_A:
    
        parsed = (data >> 0) & ((1u << 8) - 1);
        fprintf(fp, "%s.OFFSET_UPPER = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVA140_SET_RENDER_ENABLE_B:
    
        parsed = data;
        fprintf(fp, "%s.OFFSET_LOWER = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVA140_SET_RENDER_ENABLE_C:
    
        parsed = (data >> 0) & ((1u << 3) - 1);
        fprintf(fp, "%s.MODE = ", prefix);
        switch (parsed) {
        case NVA140_SET_RENDER_ENABLE_C_MODE_FALSE:
            fprintf(fp, "FALSE\n");
            break;
        case NVA140_SET_RENDER_ENABLE_C_MODE_TRUE:
            fprintf(fp, "TRUE\n");
            break;
        case NVA140_SET_RENDER_ENABLE_C_MODE_CONDITIONAL:
            fprintf(fp, "CONDITIONAL\n");
            break;
        case NVA140_SET_RENDER_ENABLE_C_MODE_RENDER_IF_EQUAL:
            fprintf(fp, "RENDER_IF_EQUAL\n");
            break;
        case NVA140_SET_RENDER_ENABLE_C_MODE_RENDER_IF_NOT_EQUAL:
            fprintf(fp, "RENDER_IF_NOT_EQUAL\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
        break;
    case NVA140_SET_RENDER_ENABLE_OVERRIDE:
    
        parsed = (data >> 0) & ((1u << 2) - 1);
        fprintf(fp, "%s.MODE = ", prefix);
        switch (parsed) {
        case NVA140_SET_RENDER_ENABLE_OVERRIDE_MODE_USE_RENDER_ENABLE:
            fprintf(fp, "USE_RENDER_ENABLE\n");
            break;
        case NVA140_SET_RENDER_ENABLE_OVERRIDE_MODE_ALWAYS_RENDER:
            fprintf(fp, "ALWAYS_RENDER\n");
            break;
        case NVA140_SET_RENDER_ENABLE_OVERRIDE_MODE_NEVER_RENDER:
            fprintf(fp, "NEVER_RENDER\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
        break;
    case NVA140_SET_MME_SHADOW_SCRATCH(0):
    case NVA140_SET_MME_SHADOW_SCRATCH(1):
    case NVA140_SET_MME_SHADOW_SCRATCH(2):
    case NVA140_SET_MME_SHADOW_SCRATCH(3):
    case NVA140_SET_MME_SHADOW_SCRATCH(4):
    case NVA140_SET_MME_SHADOW_SCRATCH(5):
    case NVA140_SET_MME_SHADOW_SCRATCH(6):
    case NVA140_SET_MME_SHADOW_SCRATCH(7):
    case NVA140_SET_MME_SHADOW_SCRATCH(8):
    case NVA140_SET_MME_SHADOW_SCRATCH(9):
    case NVA140_SET_MME_SHADOW_SCRATCH(10):
    case NVA140_SET_MME_SHADOW_SCRATCH(11):
    case NVA140_SET_MME_SHADOW_SCRATCH(12):
    case NVA140_SET_MME_SHADOW_SCRATCH(13):
    case NVA140_SET_MME_SHADOW_SCRATCH(14):
    case NVA140_SET_MME_SHADOW_SCRATCH(15):
    case NVA140_SET_MME_SHADOW_SCRATCH(16):
    case NVA140_SET_MME_SHADOW_SCRATCH(17):
    case NVA140_SET_MME_SHADOW_SCRATCH(18):
    case NVA140_SET_MME_SHADOW_SCRATCH(19):
    case NVA140_SET_MME_SHADOW_SCRATCH(20):
    case NVA140_SET_MME_SHADOW_SCRATCH(21):
    case NVA140_SET_MME_SHADOW_SCRATCH(22):
    case NVA140_SET_MME_SHADOW_SCRATCH(23):
    case NVA140_SET_MME_SHADOW_SCRATCH(24):
    case NVA140_SET_MME_SHADOW_SCRATCH(25):
    case NVA140_SET_MME_SHADOW_SCRATCH(26):
    case NVA140_SET_MME_SHADOW_SCRATCH(27):
    case NVA140_SET_MME_SHADOW_SCRATCH(28):
    case NVA140_SET_MME_SHADOW_SCRATCH(29):
    case NVA140_SET_MME_SHADOW_SCRATCH(30):
    case NVA140_SET_MME_SHADOW_SCRATCH(31):
    case NVA140_SET_MME_SHADOW_SCRATCH(32):
    case NVA140_SET_MME_SHADOW_SCRATCH(33):
    case NVA140_SET_MME_SHADOW_SCRATCH(34):
    case NVA140_SET_MME_SHADOW_SCRATCH(35):
    case NVA140_SET_MME_SHADOW_SCRATCH(36):
    case NVA140_SET_MME_SHADOW_SCRATCH(37):
    case NVA140_SET_MME_SHADOW_SCRATCH(38):
    case NVA140_SET_MME_SHADOW_SCRATCH(39):
    case NVA140_SET_MME_SHADOW_SCRATCH(40):
    case NVA140_SET_MME_SHADOW_SCRATCH(41):
    case NVA140_SET_MME_SHADOW_SCRATCH(42):
    case NVA140_SET_MME_SHADOW_SCRATCH(43):
    case NVA140_SET_MME_SHADOW_SCRATCH(44):
    case NVA140_SET_MME_SHADOW_SCRATCH(45):
    case NVA140_SET_MME_SHADOW_SCRATCH(46):
    case NVA140_SET_MME_SHADOW_SCRATCH(47):
    case NVA140_SET_MME_SHADOW_SCRATCH(48):
    case NVA140_SET_MME_SHADOW_SCRATCH(49):
    case NVA140_SET_MME_SHADOW_SCRATCH(50):
    case NVA140_SET_MME_SHADOW_SCRATCH(51):
    case NVA140_SET_MME_SHADOW_SCRATCH(52):
    case NVA140_SET_MME_SHADOW_SCRATCH(53):
    case NVA140_SET_MME_SHADOW_SCRATCH(54):
    case NVA140_SET_MME_SHADOW_SCRATCH(55):
    case NVA140_SET_MME_SHADOW_SCRATCH(56):
    case NVA140_SET_MME_SHADOW_SCRATCH(57):
    case NVA140_SET_MME_SHADOW_SCRATCH(58):
    case NVA140_SET_MME_SHADOW_SCRATCH(59):
    case NVA140_SET_MME_SHADOW_SCRATCH(60):
    case NVA140_SET_MME_SHADOW_SCRATCH(61):
    case NVA140_SET_MME_SHADOW_SCRATCH(62):
    case NVA140_SET_MME_SHADOW_SCRATCH(63):
    case NVA140_SET_MME_SHADOW_SCRATCH(64):
    case NVA140_SET_MME_SHADOW_SCRATCH(65):
    case NVA140_SET_MME_SHADOW_SCRATCH(66):
    case NVA140_SET_MME_SHADOW_SCRATCH(67):
    case NVA140_SET_MME_SHADOW_SCRATCH(68):
    case NVA140_SET_MME_SHADOW_SCRATCH(69):
    case NVA140_SET_MME_SHADOW_SCRATCH(70):
    case NVA140_SET_MME_SHADOW_SCRATCH(71):
    case NVA140_SET_MME_SHADOW_SCRATCH(72):
    case NVA140_SET_MME_SHADOW_SCRATCH(73):
    case NVA140_SET_MME_SHADOW_SCRATCH(74):
    case NVA140_SET_MME_SHADOW_SCRATCH(75):
    case NVA140_SET_MME_SHADOW_SCRATCH(76):
    case NVA140_SET_MME_SHADOW_SCRATCH(77):
    case NVA140_SET_MME_SHADOW_SCRATCH(78):
    case NVA140_SET_MME_SHADOW_SCRATCH(79):
    case NVA140_SET_MME_SHADOW_SCRATCH(80):
    case NVA140_SET_MME_SHADOW_SCRATCH(81):
    case NVA140_SET_MME_SHADOW_SCRATCH(82):
    case NVA140_SET_MME_SHADOW_SCRATCH(83):
    case NVA140_SET_MME_SHADOW_SCRATCH(84):
    case NVA140_SET_MME_SHADOW_SCRATCH(85):
    case NVA140_SET_MME_SHADOW_SCRATCH(86):
    case NVA140_SET_MME_SHADOW_SCRATCH(87):
    case NVA140_SET_MME_SHADOW_SCRATCH(88):
    case NVA140_SET_MME_SHADOW_SCRATCH(89):
    case NVA140_SET_MME_SHADOW_SCRATCH(90):
    case NVA140_SET_MME_SHADOW_SCRATCH(91):
    case NVA140_SET_MME_SHADOW_SCRATCH(92):
    case NVA140_SET_MME_SHADOW_SCRATCH(93):
    case NVA140_SET_MME_SHADOW_SCRATCH(94):
    case NVA140_SET_MME_SHADOW_SCRATCH(95):
    case NVA140_SET_MME_SHADOW_SCRATCH(96):
    case NVA140_SET_MME_SHADOW_SCRATCH(97):
    case NVA140_SET_MME_SHADOW_SCRATCH(98):
    case NVA140_SET_MME_SHADOW_SCRATCH(99):
    case NVA140_SET_MME_SHADOW_SCRATCH(100):
    case NVA140_SET_MME_SHADOW_SCRATCH(101):
    case NVA140_SET_MME_SHADOW_SCRATCH(102):
    case NVA140_SET_MME_SHADOW_SCRATCH(103):
    case NVA140_SET_MME_SHADOW_SCRATCH(104):
    case NVA140_SET_MME_SHADOW_SCRATCH(105):
    case NVA140_SET_MME_SHADOW_SCRATCH(106):
    case NVA140_SET_MME_SHADOW_SCRATCH(107):
    case NVA140_SET_MME_SHADOW_SCRATCH(108):
    case NVA140_SET_MME_SHADOW_SCRATCH(109):
    case NVA140_SET_MME_SHADOW_SCRATCH(110):
    case NVA140_SET_MME_SHADOW_SCRATCH(111):
    case NVA140_SET_MME_SHADOW_SCRATCH(112):
    case NVA140_SET_MME_SHADOW_SCRATCH(113):
    case NVA140_SET_MME_SHADOW_SCRATCH(114):
    case NVA140_SET_MME_SHADOW_SCRATCH(115):
    case NVA140_SET_MME_SHADOW_SCRATCH(116):
    case NVA140_SET_MME_SHADOW_SCRATCH(117):
    case NVA140_SET_MME_SHADOW_SCRATCH(118):
    case NVA140_SET_MME_SHADOW_SCRATCH(119):
    case NVA140_SET_MME_SHADOW_SCRATCH(120):
    case NVA140_SET_MME_SHADOW_SCRATCH(121):
    case NVA140_SET_MME_SHADOW_SCRATCH(122):
    case NVA140_SET_MME_SHADOW_SCRATCH(123):
    case NVA140_SET_MME_SHADOW_SCRATCH(124):
    case NVA140_SET_MME_SHADOW_SCRATCH(125):
    case NVA140_SET_MME_SHADOW_SCRATCH(126):
    case NVA140_SET_MME_SHADOW_SCRATCH(127):
    case NVA140_SET_MME_SHADOW_SCRATCH(128):
    case NVA140_SET_MME_SHADOW_SCRATCH(129):
    case NVA140_SET_MME_SHADOW_SCRATCH(130):
    case NVA140_SET_MME_SHADOW_SCRATCH(131):
    case NVA140_SET_MME_SHADOW_SCRATCH(132):
    case NVA140_SET_MME_SHADOW_SCRATCH(133):
    case NVA140_SET_MME_SHADOW_SCRATCH(134):
    case NVA140_SET_MME_SHADOW_SCRATCH(135):
    case NVA140_SET_MME_SHADOW_SCRATCH(136):
    case NVA140_SET_MME_SHADOW_SCRATCH(137):
    case NVA140_SET_MME_SHADOW_SCRATCH(138):
    case NVA140_SET_MME_SHADOW_SCRATCH(139):
    case NVA140_SET_MME_SHADOW_SCRATCH(140):
    case NVA140_SET_MME_SHADOW_SCRATCH(141):
    case NVA140_SET_MME_SHADOW_SCRATCH(142):
    case NVA140_SET_MME_SHADOW_SCRATCH(143):
    case NVA140_SET_MME_SHADOW_SCRATCH(144):
    case NVA140_SET_MME_SHADOW_SCRATCH(145):
    case NVA140_SET_MME_SHADOW_SCRATCH(146):
    case NVA140_SET_MME_SHADOW_SCRATCH(147):
    case NVA140_SET_MME_SHADOW_SCRATCH(148):
    case NVA140_SET_MME_SHADOW_SCRATCH(149):
    case NVA140_SET_MME_SHADOW_SCRATCH(150):
    case NVA140_SET_MME_SHADOW_SCRATCH(151):
    case NVA140_SET_MME_SHADOW_SCRATCH(152):
    case NVA140_SET_MME_SHADOW_SCRATCH(153):
    case NVA140_SET_MME_SHADOW_SCRATCH(154):
    case NVA140_SET_MME_SHADOW_SCRATCH(155):
    case NVA140_SET_MME_SHADOW_SCRATCH(156):
    case NVA140_SET_MME_SHADOW_SCRATCH(157):
    case NVA140_SET_MME_SHADOW_SCRATCH(158):
    case NVA140_SET_MME_SHADOW_SCRATCH(159):
    case NVA140_SET_MME_SHADOW_SCRATCH(160):
    case NVA140_SET_MME_SHADOW_SCRATCH(161):
    case NVA140_SET_MME_SHADOW_SCRATCH(162):
    case NVA140_SET_MME_SHADOW_SCRATCH(163):
    case NVA140_SET_MME_SHADOW_SCRATCH(164):
    case NVA140_SET_MME_SHADOW_SCRATCH(165):
    case NVA140_SET_MME_SHADOW_SCRATCH(166):
    case NVA140_SET_MME_SHADOW_SCRATCH(167):
    case NVA140_SET_MME_SHADOW_SCRATCH(168):
    case NVA140_SET_MME_SHADOW_SCRATCH(169):
    case NVA140_SET_MME_SHADOW_SCRATCH(170):
    case NVA140_SET_MME_SHADOW_SCRATCH(171):
    case NVA140_SET_MME_SHADOW_SCRATCH(172):
    case NVA140_SET_MME_SHADOW_SCRATCH(173):
    case NVA140_SET_MME_SHADOW_SCRATCH(174):
    case NVA140_SET_MME_SHADOW_SCRATCH(175):
    case NVA140_SET_MME_SHADOW_SCRATCH(176):
    case NVA140_SET_MME_SHADOW_SCRATCH(177):
    case NVA140_SET_MME_SHADOW_SCRATCH(178):
    case NVA140_SET_MME_SHADOW_SCRATCH(179):
    case NVA140_SET_MME_SHADOW_SCRATCH(180):
    case NVA140_SET_MME_SHADOW_SCRATCH(181):
    case NVA140_SET_MME_SHADOW_SCRATCH(182):
    case NVA140_SET_MME_SHADOW_SCRATCH(183):
    case NVA140_SET_MME_SHADOW_SCRATCH(184):
    case NVA140_SET_MME_SHADOW_SCRATCH(185):
    case NVA140_SET_MME_SHADOW_SCRATCH(186):
    case NVA140_SET_MME_SHADOW_SCRATCH(187):
    case NVA140_SET_MME_SHADOW_SCRATCH(188):
    case NVA140_SET_MME_SHADOW_SCRATCH(189):
    case NVA140_SET_MME_SHADOW_SCRATCH(190):
    case NVA140_SET_MME_SHADOW_SCRATCH(191):
    case NVA140_SET_MME_SHADOW_SCRATCH(192):
    case NVA140_SET_MME_SHADOW_SCRATCH(193):
    case NVA140_SET_MME_SHADOW_SCRATCH(194):
    case NVA140_SET_MME_SHADOW_SCRATCH(195):
    case NVA140_SET_MME_SHADOW_SCRATCH(196):
    case NVA140_SET_MME_SHADOW_SCRATCH(197):
    case NVA140_SET_MME_SHADOW_SCRATCH(198):
    case NVA140_SET_MME_SHADOW_SCRATCH(199):
    case NVA140_SET_MME_SHADOW_SCRATCH(200):
    case NVA140_SET_MME_SHADOW_SCRATCH(201):
    case NVA140_SET_MME_SHADOW_SCRATCH(202):
    case NVA140_SET_MME_SHADOW_SCRATCH(203):
    case NVA140_SET_MME_SHADOW_SCRATCH(204):
    case NVA140_SET_MME_SHADOW_SCRATCH(205):
    case NVA140_SET_MME_SHADOW_SCRATCH(206):
    case NVA140_SET_MME_SHADOW_SCRATCH(207):
    case NVA140_SET_MME_SHADOW_SCRATCH(208):
    case NVA140_SET_MME_SHADOW_SCRATCH(209):
    case NVA140_SET_MME_SHADOW_SCRATCH(210):
    case NVA140_SET_MME_SHADOW_SCRATCH(211):
    case NVA140_SET_MME_SHADOW_SCRATCH(212):
    case NVA140_SET_MME_SHADOW_SCRATCH(213):
    case NVA140_SET_MME_SHADOW_SCRATCH(214):
    case NVA140_SET_MME_SHADOW_SCRATCH(215):
    case NVA140_SET_MME_SHADOW_SCRATCH(216):
    case NVA140_SET_MME_SHADOW_SCRATCH(217):
    case NVA140_SET_MME_SHADOW_SCRATCH(218):
    case NVA140_SET_MME_SHADOW_SCRATCH(219):
    case NVA140_SET_MME_SHADOW_SCRATCH(220):
    case NVA140_SET_MME_SHADOW_SCRATCH(221):
    case NVA140_SET_MME_SHADOW_SCRATCH(222):
    case NVA140_SET_MME_SHADOW_SCRATCH(223):
    case NVA140_SET_MME_SHADOW_SCRATCH(224):
    case NVA140_SET_MME_SHADOW_SCRATCH(225):
    case NVA140_SET_MME_SHADOW_SCRATCH(226):
    case NVA140_SET_MME_SHADOW_SCRATCH(227):
    case NVA140_SET_MME_SHADOW_SCRATCH(228):
    case NVA140_SET_MME_SHADOW_SCRATCH(229):
    case NVA140_SET_MME_SHADOW_SCRATCH(230):
    case NVA140_SET_MME_SHADOW_SCRATCH(231):
    case NVA140_SET_MME_SHADOW_SCRATCH(232):
    case NVA140_SET_MME_SHADOW_SCRATCH(233):
    case NVA140_SET_MME_SHADOW_SCRATCH(234):
    case NVA140_SET_MME_SHADOW_SCRATCH(235):
    case NVA140_SET_MME_SHADOW_SCRATCH(236):
    case NVA140_SET_MME_SHADOW_SCRATCH(237):
    case NVA140_SET_MME_SHADOW_SCRATCH(238):
    case NVA140_SET_MME_SHADOW_SCRATCH(239):
    case NVA140_SET_MME_SHADOW_SCRATCH(240):
    case NVA140_SET_MME_SHADOW_SCRATCH(241):
    case NVA140_SET_MME_SHADOW_SCRATCH(242):
    case NVA140_SET_MME_SHADOW_SCRATCH(243):
    case NVA140_SET_MME_SHADOW_SCRATCH(244):
    case NVA140_SET_MME_SHADOW_SCRATCH(245):
    case NVA140_SET_MME_SHADOW_SCRATCH(246):
    case NVA140_SET_MME_SHADOW_SCRATCH(247):
    case NVA140_SET_MME_SHADOW_SCRATCH(248):
    case NVA140_SET_MME_SHADOW_SCRATCH(249):
    case NVA140_SET_MME_SHADOW_SCRATCH(250):
    case NVA140_SET_MME_SHADOW_SCRATCH(251):
    case NVA140_SET_MME_SHADOW_SCRATCH(252):
    case NVA140_SET_MME_SHADOW_SCRATCH(253):
    case NVA140_SET_MME_SHADOW_SCRATCH(254):
    case NVA140_SET_MME_SHADOW_SCRATCH(255):
    
        parsed = data;
        fprintf(fp, "%s.V = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    default:
        fprintf(fp, "%s.VALUE = 0x%x\n", prefix, data);
        break;
    }
}
